/* -*- C++ -*-
 * 
 * $Id: svFeatureEdges.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// .NAME svFeatureEdges - Aggregate filter object for vtkFeatureEdges.
// .SECTION Description
// Aggregate filter object for vtkFeatureEdges.

#ifndef SV_FEATUREEDGES_H_
#  define SV_FEATUREEDGES_H_

#  include "svPolyDataFilter.H" /* includes svMacros */

// 
// .SECTION See Also
// svPolyDataFilter vtkFeatureEdges

class svFeatureEdges : public svPolyDataFilter
{
public:
  // Description:
  // Creates an instance of svFeatureEdges.
  static svFeatureEdges* New();

  vtkTypeMacro(svFeatureEdges,svPolyDataFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // 
  void   InstallFilter(void);
  void   ResetParameters(void);
  void   ApplyParameters(void);

  // Description:
  // 
  svSetGetMacro(BoundaryEdges, int);
  svSetGetMacro(FeatureEdges, int);
  svSetGetMacro(FeatureAngle, float);
  svSetGetMacro(NonManifoldEdges, int);
  svSetGetMacro(ManifoldEdges, int);
  svSetGetMacro(Coloring, int);

protected:
  svFeatureEdges(void);

  int    BoundaryEdges;
  int    FeatureEdges;
  float  FeatureAngle;
  int    NonManifoldEdges;
  int    ManifoldEdges;
  int    Coloring;

private:
  svFeatureEdges(const svFeatureEdges&);  // Not implemented.
  void operator=(const svFeatureEdges&);  // Not implemented.
};

// Description:
// svFeatureEdges pointer data type.
typedef svFeatureEdges* svFeatureEdgesPtr;

#endif /* SV_FEATUREEDGES_H_ */
/* 
 * End of $Id: svFeatureEdges.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
