/* 
 * $Id: svFeatureEdges.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 */

#include "vtkObjectFactory.h"
#include "vtkFeatureEdges.h"

#include "svFeatureEdges.H"


//----------------------------------------------------------------------------
svFeatureEdges::svFeatureEdges(void)
{
  this->ResetParameters();
}


//----------------------------------------------------------------------------
svFeatureEdges*
svFeatureEdges::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("svFeatureEdges");

  if(ret) {
    return reinterpret_cast<svFeatureEdges*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svFeatureEdges;
}

//----------------------------------------------------------------------------
void
svFeatureEdges::InstallFilter(void)
{
  if( !(vtkFeatureEdges::SafeDownCast(this->GetFilter())) )
    this->SetFilter(vtkFeatureEdges::New());
}

//----------------------------------------------------------------------------
void
svFeatureEdges::ResetParameters(void)
{
  // this->Active           = int(0);
  this->BoundaryEdges    = int(1);
  this->FeatureEdges     = int(1);
  this->FeatureAngle     = float(30.0);
  this->NonManifoldEdges = int(1);
  this->ManifoldEdges    = int(0);
  this->Coloring         = int(1);
}

//----------------------------------------------------------------------------
void
svFeatureEdges::ApplyParameters(void)
{
  if(this->Active) {
    vtkFeatureEdges* filter =
      vtkFeatureEdges::SafeDownCast(this->GetFilter());

    filter->SetBoundaryEdges(this->BoundaryEdges);
    filter->SetFeatureEdges(this->FeatureEdges);
    filter->SetFeatureAngle(this->FeatureAngle);
    filter->SetNonManifoldEdges(this->NonManifoldEdges);
    filter->SetManifoldEdges(this->ManifoldEdges);
    filter->SetColoring(this->Coloring);
  }
}

/* 
 * End of: $Id: svFeatureEdges.cxx,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
