/* -*- C++ -*-
 * 
 * $Id: svSelect.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// .NAME svSelect - Aggregate filter object for vtkSelectPolyData.
// .SECTION Description
// Aggregate filter object for vtkSelectPolyData.

#ifndef SV_SELECT_H_
#  define SV_SELECT_H_

#  include "vtkPoints.h"

#  include "svPolyDataFilter.H" /* includes svMacros */

// 
// .SECTION See Also
// svPolyDataFilter vtkSelectPolyData

class svSelect : public svPolyDataFilter
{
public:
  // Description:
  // Creates an instance of svSelect.
  static svSelect* New();

  vtkTypeMacro(svSelect,svPolyDataFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // 
  void   InstallFilter(void);
  void   ResetParameters(void);
  void   ApplyParameters(void);

  // Description:
  // 
  svSetGetMacro(GenerateSelectionScalars, int);
  svSetGetMacro(InsideOut, int);
  vtkPoints* GetLoop(void) const {return this->Loop;}
  void       SetLoop(vtkPoints* arg) {this->Loop = arg;}
  svSetGetMacro(SelectionMode, int);
  void       SetSelectionModeToSmallestRegion() {this->SetSelectionMode(0);}
  void       SetSelectionModeToLargestRegion() {this->SetSelectionMode(1);}
  void       SetSelectionModeToClosestPointRegion() {this->SetSelectionMode(2);}
  svSetGetMacro(GenerateUnselectedOutput, int);
  vtkPolyData* GetUnselectedOutput(void);
  vtkPolyData* GetSelectionEdges(void);

protected:
  svSelect(void) {this->ResetParameters();}

  int          GenerateSelectionScalars;
  int          InsideOut;
  vtkPoints*   Loop;
  int          SelectionMode;
  int          GenerateUnselectedOutput;

private:
  svSelect(const svSelect&);  // Not implemented.
  void operator=(const svSelect&);  // Not implemented.
};

// Description:
// svSelect pointer data type.
typedef svSelect* svSelectPtr;

#endif /* SV_SELECT_H_ */
/* 
 * End of $Id: svSelect.H,v 1.1.1.1 2006/12/19 22:58:37 christianh Exp $.
 * 
 */
