/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: face.h,v 1.1.1.1 2006/12/19 22:58:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_FACE_H_
#  define SVV_FACE_H_
#  include "svvModel.h"

static GLsizei face_nvertices = 2137;
static GLsizei face_nindices  = 4180;
static GLsizei face_nedges    = 16720;

static GLfloat face_vertices[][6] =
{
  {-1.434082e-01, -2.760911e-01, -9.503725e-01, -8.212634e-01, -1.205331e+00, -5.263068e-01},
  {-5.285413e-01, -3.292013e-01, -7.824772e-01, -8.212634e-01, -9.457205e-01, -6.017257e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00, -8.212634e-01, -8.220969e-01, -6.471950e-01},
  {-7.324539e-01, -2.325424e-01, -6.398714e-01, -8.212634e-01, -7.355601e-01, -6.835787e-01},
  {-5.353034e-01, -3.557011e-01, -7.661116e-01, -8.212634e-01, -6.243002e-01, -7.284822e-01},
  {-5.733933e-01, -3.390232e-01, -7.458440e-01, -8.012345e-01, -5.995755e-01, -7.505662e-01},
  {-5.445840e-01, -3.249895e-01, -7.731819e-01, -8.212634e-01, -5.624881e-01, -7.535380e-01},
  {-4.476782e-01, -1.128335e-01, -8.870473e-01, -8.212634e-01, -3.276030e-01, -8.136647e-01},
  {-7.721490e-02, -6.771394e-02, -9.947124e-01, -8.212634e-01, -2.781533e-01, -8.178921e-01},
  {-3.378240e-01, -2.151577e-02, -9.409633e-01, -8.212634e-01, -2.287039e-01, -8.203812e-01},
  {-4.198048e-01, -4.325337e-02, -9.065832e-01, -8.002715e-01, -1.174423e-01, -8.304618e-01},
  {-5.440580e-01, -1.982217e-02, -8.388134e-01, -8.212634e-01,  1.050806e-01, -8.179208e-01},
  {-3.668013e-01,  9.571050e-02, -9.253628e-01, -8.212634e-01,  1.792549e-01, -8.118221e-01},
  {-1.518264e-01,  1.071842e-01, -9.825784e-01, -8.212634e-01,  2.287029e-01, -8.076558e-01},
  {-4.738736e-01,  1.270670e-01, -8.713771e-01, -8.007720e-01,  4.141386e-01, -7.905939e-01},
  {-4.533481e-01,  6.894606e-02, -8.886631e-01, -8.012695e-01,  6.984736e-01, -7.513521e-01},
  {-4.432482e-01,  6.439257e-02, -8.940831e-01, -8.212634e-01,  7.231982e-01, -7.404800e-01},
  {-3.728546e-01,  3.366500e-01, -8.646654e-01, -8.212634e-01,  1.192968e+00, -6.951426e-01},
  {-2.837824e-01,  4.392734e-01, -8.523535e-01, -8.020056e-01,  1.205330e+00, -6.951832e-01},
  {-1.654491e-01,  2.546080e-01, -9.527861e-01, -8.212634e-01,  1.205330e+00, -6.918391e-01},
  {-5.749447e-01, -3.500612e-01, -7.395239e-01, -7.815834e-01, -6.613873e-01, -7.375748e-01},
  {-4.398259e-01,  3.806593e-01, -8.134198e-01, -7.823719e-01,  1.205330e+00, -7.059628e-01},
  {-2.597586e-01, -1.714104e-01, -9.503389e-01, -7.693486e-01, -1.205331e+00, -5.341406e-01},
  {-6.048054e-01,  1.199217e-01, -7.872923e-01, -7.593810e-01,  5.006756e-01, -8.037716e-01},
  {-6.937835e-01,  1.149017e-01, -7.109587e-01, -7.598865e-01,  6.119370e-01, -7.901528e-01},
  {-5.790550e-01,  8.975884e-02, -8.103324e-01, -7.603622e-01,  6.737487e-01, -7.773996e-01},
  {-5.828227e-01, -3.128092e-01, -7.499787e-01, -7.404853e-01, -6.737497e-01, -7.672698e-01},
  {-6.510675e-01,  1.008076e-01, -7.522957e-01, -7.350261e-01,  1.050806e-01, -8.788183e-01},
  {-4.918422e-01,  1.402394e-01, -8.593161e-01, -7.380430e-01,  5.006756e-01, -8.180274e-01},
  {-4.647498e-01,  2.912409e-02, -8.849629e-01, -7.194381e-01,  8.468218e-01, -7.816402e-01},
  {-2.465238e-01, -2.118863e-01, -9.456903e-01, -6.976101e-01, -1.205331e+00, -5.619118e-01},
  {-4.817412e-01, -3.686191e-01, -7.950128e-01, -6.832281e-01, -8.591840e-01, -7.273278e-01},
  {-5.160894e-01, -2.129889e-01, -8.296310e-01, -6.683920e-01, -4.635892e-01, -8.998791e-01},
  {-5.805569e-01,  1.218619e-01, -8.050487e-01, -6.668437e-01,  2.410653e-01, -9.179286e-01},
  {-4.246177e-01,  1.888858e-01, -8.854502e-01, -6.791654e-01,  1.205330e+00, -7.744523e-01},
  {-4.802699e-01, -3.521421e-01, -8.033285e-01, -6.536930e-01, -6.984744e-01, -8.260745e-01},
  {-4.916345e-01, -3.220065e-01, -8.090780e-01, -6.470908e-01, -5.377634e-01, -8.932714e-01},
  {-3.483724e-01, -1.033964e-01, -9.316361e-01, -6.445673e-01, -4.265019e-01, -9.191273e-01},
  {-5.439848e-01,  2.646255e-01, -7.962750e-01, -6.444635e-01,  2.905149e-01, -9.202315e-01},
  {-3.311782e-01,  2.327686e-01, -9.144068e-01, -6.467530e-01,  3.770515e-01, -8.970392e-01},
  {-3.452784e-01,  6.969061e-02, -9.359092e-01, -6.471565e-01,  4.141386e-01, -8.929151e-01},
  {-4.070700e-01,  3.731715e-03, -9.133894e-01, -6.539792e-01,  9.457207e-01, -8.235391e-01},
  {-4.115305e-01,  1.400710e-01, -9.005680e-01, -6.550943e-01,  1.081707e+00, -8.123672e-01},
  {-2.624705e-01, -2.790360e-01, -9.237143e-01, -6.232282e-01, -5.130387e-01, -9.109555e-01},
  {-2.963617e-01, -3.241194e-02, -9.545256e-01, -6.195263e-01, -1.421671e-01, -9.445010e-01},
  {-4.109105e-01, -7.760516e-02, -9.083667e-01, -6.184148e-01,  6.799346e-02, -9.544430e-01},
  {-4.125239e-01,  7.609423e-02, -9.077631e-01, -6.185457e-01,  1.545301e-01, -9.533007e-01},
  {-1.840559e-01,  1.214075e-01, -9.753889e-01, -6.198578e-01,  2.410653e-01, -9.415741e-01},
  {-2.907378e-01,  1.795790e-01, -9.397994e-01, -6.201845e-01,  2.657900e-01, -9.386065e-01},
  {-3.758732e-01,  1.835810e-01, -9.083046e-01, -6.251115e-01,  5.006756e-01, -8.939704e-01},
  {-3.102863e-01, -4.972820e-01, -8.102056e-01, -6.226155e-01, -9.086334e-01, -7.357544e-01},
  {-4.237066e-01, -3.630210e-01, -8.298726e-01, -6.163330e-01, -8.220969e-01, -7.867098e-01},
  {-2.904321e-01, -3.351181e-01, -8.962952e-01, -6.029996e-01, -5.872129e-01, -8.950369e-01},
  {-2.282367e-01, -1.391000e-01, -9.636178e-01, -5.986350e-01, -4.388643e-01, -9.306477e-01},
  {-2.926777e-01, -5.588284e-02, -9.545768e-01, -5.964809e-01, -2.781533e-01, -9.480755e-01},
  {-3.253928e-01, -3.411380e-02, -9.449634e-01, -5.961512e-01, -2.039791e-01, -9.507349e-01},
  {-2.700017e-01, -8.193890e-02, -9.593670e-01, -5.949138e-01,  6.799346e-02, -9.607866e-01},
  {-1.476606e-01,  8.600155e-02, -9.852919e-01, -5.946935e-01,  1.545301e-01, -9.625485e-01},
  {-1.981943e-01,  2.391561e-01, -9.505385e-01, -5.962120e-01,  1.916172e-01, -9.502271e-01},
  {-1.352821e-01,  1.620510e-01, -9.774652e-01, -5.969112e-01,  2.163405e-01, -9.446340e-01},
  {-1.207167e-01,  2.394454e-01, -9.633761e-01, -6.010864e-01,  3.523267e-01, -9.109480e-01},
  {-2.396451e-01,  1.605449e-02, -9.707278e-01, -6.018514e-01,  4.883133e-01, -9.044139e-01},
  {-3.621479e-01,  1.776313e-01, -9.150388e-01, -6.071103e-01,  7.355605e-01, -8.617600e-01},
  {-6.793984e-02,  1.549186e-01, -9.855884e-01, -6.104493e-01,  1.007533e+00, -8.349378e-01},
  {-2.054633e-01, -3.265228e-01, -9.225875e-01, -5.863594e-01, -6.984744e-01, -8.550845e-01},
  {-1.554904e-01, -3.813090e-01, -9.112773e-01, -5.821981e-01, -6.243002e-01, -8.857948e-01},
  {-6.678759e-02, -2.741542e-01, -9.593638e-01, -5.773422e-01, -5.130387e-01, -9.217023e-01},
  {-8.285991e-02,  2.218949e-01, -9.715436e-01, -5.718890e-01,  1.792549e-01, -9.619210e-01},
  {-1.258957e-01,  2.235853e-01, -9.665195e-01, -5.729465e-01,  2.039797e-01, -9.540232e-01},
  {-6.525809e-02,  1.689223e-01, -9.834667e-01, -5.739984e-01,  2.410653e-01, -9.464456e-01},
  {-2.700276e-02,  3.029955e-01, -9.526094e-01, -5.750771e-01,  3.028772e-01, -9.385465e-01},
  { 2.488648e-01,  2.583492e-01, -9.334462e-01, -5.790824e-01,  3.646892e-01, -9.092059e-01},
  { 6.405279e-02, -8.136391e-02, -9.946241e-01, -5.797936e-01,  4.635885e-01, -9.037737e-01},
  {-9.066231e-03, -4.668453e-02, -9.988685e-01, -5.790527e-01,  4.883133e-01, -9.091850e-01},
  {-1.434577e-01,  2.364277e-01, -9.610004e-01, -5.796630e-01,  5.254002e-01, -9.046363e-01},
  {-1.987703e-01,  8.316282e-02, -9.765112e-01, -5.876318e-01,  9.333584e-01, -8.459615e-01},
  {-1.306701e-01, -5.622248e-01, -8.165957e-01, -5.782073e-01, -8.839087e-01, -7.640898e-01},
  {-1.469143e-01, -4.894338e-01, -8.595759e-01, -5.730302e-01, -8.220969e-01, -7.990794e-01},
  {-8.074094e-02, -4.051000e-01, -9.107001e-01, -5.694617e-01, -7.726472e-01, -8.231708e-01},
  { 7.162020e-02, -3.187943e-01, -9.451142e-01, -5.629763e-01, -6.737497e-01, -8.670362e-01},
  { 1.249958e-01, -2.301788e-01, -9.650874e-01, -5.576570e-01, -5.748505e-01, -9.030080e-01},
  { 3.449973e-01, -2.460449e-01, -9.057807e-01, -5.556226e-01, -5.254011e-01, -9.167927e-01},
  { 1.673990e-01, -9.960540e-02, -9.808447e-01, -5.520638e-01, -3.523277e-01, -9.408135e-01},
  { 1.809947e-01, -7.760543e-02, -9.804174e-01, -5.498909e-01, -1.792542e-01, -9.553599e-01},
  { 1.553690e-01,  1.208457e-01, -9.804370e-01, -5.491437e-01,  1.668925e-01, -9.605969e-01},
  { 7.862518e-02,  2.227438e-01, -9.717012e-01, -5.502012e-01,  2.163405e-01, -9.533409e-01},
  { 2.154732e-01,  4.661928e-01, -8.580417e-01, -5.541648e-01,  3.276020e-01, -9.267832e-01},
  { 4.550302e-01, -1.217061e-01, -8.821197e-01, -5.591940e-01,  4.388637e-01, -8.930027e-01},
  { 2.772148e-01, -8.057316e-02, -9.574236e-01, -5.573913e-01,  4.883133e-01, -9.050533e-01},
  { 2.798297e-01,  1.410813e-02, -9.599460e-01, -5.576854e-01,  5.377627e-01, -9.028952e-01},
  { 2.947230e-02,  1.835487e-01, -9.825687e-01, -5.716986e-01,  1.205330e+00, -8.084272e-01},
  { 2.348122e-02, -4.797399e-01, -8.770965e-01, -5.879925e-01, -1.205331e+00, -5.757764e-01},
  {-1.324178e-01, -4.301721e-01, -8.929823e-01, -5.836195e-01, -1.155881e+00, -6.027064e-01},
  { 2.103449e-03, -5.273343e-01, -8.496553e-01, -5.574365e-01, -8.839087e-01, -7.654136e-01},
  { 3.392774e-01, -4.602767e-01, -8.203879e-01, -5.449721e-01, -7.231978e-01, -8.430918e-01},
  { 1.092118e-01, -3.045386e-01, -9.462183e-01, -5.394897e-01, -6.366625e-01, -8.772323e-01},
  { 3.005911e-01, -2.290470e-01, -9.258415e-01, -5.369155e-01, -5.872129e-01, -8.932910e-01},
  { 1.561590e-02, -7.801109e-02, -9.968302e-01, -5.261220e-01,  3.090626e-02, -9.602488e-01},
  { 2.973058e-01,  2.187527e-01, -9.293850e-01, -5.286723e-01,  2.287029e-01, -9.447221e-01},
  { 3.446692e-01,  4.668188e-01, -8.144221e-01, -5.372848e-01,  3.646892e-01, -8.909199e-01},
  { 5.698657e-01, -4.186214e-02, -8.206709e-01, -5.390097e-01,  4.388637e-01, -8.806524e-01},
  { 5.718027e-01, -1.077449e-01, -8.132851e-01, -5.369770e-01,  4.883133e-01, -8.932827e-01},
  { 1.016767e-01,  1.667717e-01, -9.807391e-01, -5.360487e-01,  5.624875e-01, -8.987092e-01},
  { 1.896051e-01,  4.675518e-02, -9.807466e-01, -5.361629e-01,  5.872122e-01, -8.979137e-01},
  {-1.283260e-01,  1.988390e-01, -9.715943e-01, -5.385874e-01,  7.231982e-01, -8.825617e-01},
  { 2.037735e-01, -3.573321e-01, -9.114769e-01, -5.285550e-01, -7.850096e-01, -8.128809e-01},
  { 3.201804e-01,  3.450010e-03, -9.473503e-01, -5.036955e-01,  5.563099e-02, -9.562314e-01},
  { 2.130136e-01,  2.610573e-02, -9.767004e-01, -5.035213e-01,  9.271819e-02, -9.572546e-01},
  { 3.123803e-01,  1.890194e-01, -9.309620e-01, -5.049973e-01,  1.668925e-01, -9.487920e-01},
  { 3.900496e-01,  2.681411e-01, -8.808869e-01, -5.068979e-01,  2.039797e-01, -9.379562e-01},
  { 4.069113e-01,  2.086342e-01, -8.893228e-01, -5.100744e-01,  3.028772e-01, -9.197026e-01},
  { 2.921779e-01,  5.324666e-01, -7.944252e-01, -5.136672e-01,  3.523267e-01, -8.990088e-01},
  { 5.035388e-01, -1.212151e-01, -8.554272e-01, -5.163247e-01,  5.377627e-01, -8.837782e-01},
  { 2.051193e-01,  2.289307e-01, -9.515865e-01, -5.253415e-01,  9.828078e-01, -8.315731e-01},
  { 3.574160e-01,  1.485003e-01, -9.220638e-01, -4.829696e-01,  1.668925e-01, -9.431027e-01},
  { 5.045657e-01,  1.999408e-01, -8.399031e-01, -4.893019e-01,  3.028772e-01, -9.093088e-01},
  { 4.530620e-01, -2.913147e-01, -8.425382e-01, -4.761382e-01, -5.995755e-01, -8.611755e-01},
  { 4.025756e-01,  2.885654e-01, -8.687134e-01, -4.693200e-01,  2.781524e-01, -8.956494e-01},
  { 4.912970e-01,  3.766247e-01, -7.853540e-01, -4.819950e-01,  4.141386e-01, -8.320401e-01},
  { 5.235368e-01, -2.374741e-01, -8.182391e-01, -4.804336e-01,  5.130381e-01, -8.398005e-01},
  { 9.492373e-02,  4.553879e-02, -9.944424e-01, -4.715014e-01,  7.231982e-01, -8.843085e-01},
  { 3.180484e-02,  2.178591e-01, -9.754619e-01, -4.725704e-01,  7.602853e-01, -8.789110e-01},
  { 2.823926e-01,  2.196582e-01, -9.338120e-01, -4.840595e-01,  9.580831e-01, -8.213516e-01},
  { 5.548543e-02, -7.095304e-01, -7.024872e-01, -5.170471e-01, -1.205331e+00, -5.628083e-01},
  { 2.530193e-01, -2.257252e-01, -9.407600e-01, -4.417919e-01, -2.039791e-01, -9.185395e-01},
  { 1.506486e-01,  1.170889e-01, -9.816288e-01, -4.364264e-01, -6.180837e-03, -9.437609e-01},
  { 2.913568e-01,  2.856421e-01, -9.129730e-01, -4.432764e-01,  2.287029e-01, -9.116048e-01},
  { 4.289100e-01,  4.462291e-01, -7.854399e-01, -4.536709e-01,  3.646892e-01, -8.626962e-01},
  { 3.264433e-01, -1.768289e-01, -9.285291e-01, -4.509726e-01,  6.490240e-01, -8.751255e-01},
  { 1.529728e-01, -3.411516e-02, -9.876414e-01, -4.497049e-01,  7.108357e-01, -8.810610e-01},
  { 8.872038e-02, -3.723742e-01, -9.238324e-01, -4.573430e-01, -8.962710e-01, -7.464388e-01},
  { 4.016619e-01,  1.815229e-01, -8.976175e-01, -4.210590e-01,  2.163405e-01, -9.083056e-01},
  { 3.962874e-01,  3.706349e-01, -8.399917e-01, -4.324200e-01,  3.523267e-01, -8.578833e-01},
  { 3.642653e-01,  6.070774e-01, -7.062349e-01, -4.421073e-01,  4.017763e-01, -8.147318e-01},
  { 3.704057e-01,  2.924497e-01, -8.816308e-01, -4.437155e-01,  4.141386e-01, -8.074846e-01},
  { 4.520789e-01, -1.466975e-01, -8.798320e-01, -4.433736e-01,  4.759509e-01, -8.088953e-01},
  { 3.220850e-01, -2.541593e-01, -9.119563e-01, -4.311550e-01,  6.242992e-01, -8.632360e-01},
  { 1.915744e-01,  3.770044e-01, -9.061826e-01, -4.389921e-01,  9.086336e-01, -8.283304e-01},
  { 2.989477e-01,  2.150227e-01, -9.297287e-01, -4.542345e-01,  1.205330e+00, -7.605809e-01},
  { 2.908946e-01,  3.358788e-01, -8.958603e-01, -4.026155e-01,  2.534277e-01, -8.889323e-01},
  { 4.325602e-01,  4.802252e-01, -7.630697e-01, -4.055807e-01,  2.781524e-01, -8.764564e-01},
  { 4.553495e-01,  4.372748e-01, -7.755305e-01, -4.095100e-01,  3.028772e-01, -8.599504e-01},
  { 4.629289e-01,  2.806513e-01, -8.407922e-01, -4.108878e-01,  3.152396e-01, -8.541854e-01},
  { 2.713062e-01,  5.755060e-01, -7.714828e-01, -4.219215e-01,  4.017763e-01, -8.077069e-01},
  { 1.933639e-01,  1.178394e-01, -9.740248e-01, -4.241447e-01,  4.265016e-01, -7.982199e-01},
  { 2.878383e-01, -4.244959e-01, -8.584593e-01, -4.209900e-01,  5.130381e-01, -8.113971e-01},
  { 2.506586e-01, -2.905656e-01, -9.234403e-01, -4.102179e-01,  6.242992e-01, -8.567738e-01},
  { 3.187279e-01,  2.563607e-01, -9.125195e-01, -4.207976e-01,  9.457207e-01, -8.122825e-01},
  { 9.730828e-01,  1.923625e-04,  2.304556e-01, -4.265640e-01,  1.044620e+00, -7.880169e-01},
  { 4.121790e-01,  2.640979e-01, -8.719867e-01, -4.276432e-01,  1.069344e+00, -7.834808e-01},
  { 3.905381e-01, -2.450788e-01, -8.873649e-01, -3.910566e-01, -5.006763e-01, -8.435434e-01},
  { 2.371214e-01, -2.345761e-01, -9.427341e-01, -3.819714e-01, -3.152404e-01, -8.797701e-01},
  { 6.062335e-02,  2.939703e-01, -9.538901e-01, -3.739871e-01,  1.668925e-01, -9.116148e-01},
  { 7.256896e-02,  2.893018e-01, -9.544833e-01, -3.777444e-01,  2.163405e-01, -8.966768e-01},
  { 3.026010e-01,  4.260386e-01, -8.525982e-01, -3.924724e-01,  3.523267e-01, -8.379984e-01},
  { 1.699131e-01,  3.951460e-01, -9.027675e-01, -4.024022e-01,  4.141386e-01, -7.981483e-01},
  { 3.363594e-01, -6.117107e-01, -7.160114e-01, -3.986979e-01,  5.254002e-01, -8.128532e-01},
  { 1.392040e-01, -2.812280e-01, -9.494910e-01, -3.848884e-01,  6.737487e-01, -8.679636e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -4.400823e-01, -1.205331e+00, -5.719050e-01},
  { 4.212679e-02,  1.402529e-01, -9.892191e-01, -3.446737e-01,  5.563099e-02, -9.340851e-01},
  { 1.295070e-01,  3.081671e-01, -9.424760e-01, -3.493332e-01,  1.421678e-01, -9.164991e-01},
  { 3.640605e-01,  3.824411e-01, -8.492342e-01, -3.715549e-01,  3.276020e-01, -8.323693e-01},
  { 2.150166e-01,  4.517114e-01, -8.658664e-01, -3.786767e-01,  3.894139e-01, -8.053156e-01},
  { 3.345095e-01,  3.751153e-01, -8.645183e-01, -3.537595e-01,  3.646892e-01, -8.154706e-01},
  { 3.050969e-01,  7.846195e-02, -9.490836e-01, -3.633841e-01,  4.883133e-01, -7.806023e-01},
  { 2.727401e-01, -6.679811e-01, -6.923974e-01, -3.525506e-01,  5.501251e-01, -8.195688e-01},
  { 1.664744e-01, -3.102612e-01, -9.359617e-01, -3.413053e-01,  6.613864e-01, -8.602095e-01},
  { 1.273341e-01,  1.402728e-01, -9.818908e-01, -3.381432e-01,  7.602853e-01, -8.716493e-01},
  { 4.763237e-02,  2.502190e-01, -9.670169e-01, -3.420152e-01,  8.344595e-01, -8.576931e-01},
  {-3.929140e-03, -4.870184e-01, -8.733829e-01, -3.733969e-01, -1.056982e+00, -6.701064e-01},
  { 4.583928e-01, -2.650145e-01, -8.483179e-01, -3.285478e-01, -4.635892e-01, -8.250698e-01},
  { 8.114747e-02,  3.445835e-01, -9.352418e-01, -3.041125e-01,  1.421678e-01, -9.092998e-01},
  { 2.476505e-01,  6.042092e-01, -7.573640e-01, -3.250107e-01,  3.028772e-01, -8.374195e-01},
  { 4.100446e-02,  2.065570e-01, -9.775750e-01, -3.365491e-01,  3.894139e-01, -7.974380e-01},
  {-1.280296e-01,  1.782290e-01, -9.756243e-01, -3.372620e-01,  4.017763e-01, -7.948985e-01},
  {-8.859310e-02,  2.706033e-01, -9.586058e-01, -3.377751e-01,  4.388637e-01, -7.931690e-01},
  { 3.543554e-01, -4.253027e-01, -8.327964e-01, -3.416780e-01,  5.130381e-01, -7.797743e-01},
  { 2.134756e-01, -8.805195e-02, -9.729722e-01, -3.150171e-01,  7.231982e-01, -8.715740e-01},
  { 4.374382e-01, -2.730423e-01, -8.567938e-01, -3.111775e-01, -5.006763e-01, -8.075482e-01},
  { 2.984869e-01,  4.842764e-01, -8.224244e-01, -3.108705e-01,  3.276020e-01, -8.086865e-01},
  { 2.675311e-01, -6.910191e-02, -9.610682e-01, -3.240476e-01,  4.883133e-01, -7.650910e-01},
  { 1.762278e-01, -3.641331e-01, -9.145222e-01, -3.232372e-01,  5.006756e-01, -7.676975e-01},
  { 2.341189e-01, -6.072459e-01, -7.592369e-01, -3.197800e-01,  5.254002e-01, -7.790688e-01},
  { 2.239217e-01, -6.905538e-01, -6.877459e-01, -3.118635e-01,  5.501251e-01, -8.052035e-01},
  { 1.250358e-01,  1.904836e-02, -9.919693e-01, -2.922539e-01,  7.602853e-01, -8.697655e-01},
  { 4.100200e-01, -1.731316e-01, -8.954937e-01, -2.942224e-01, -5.501258e-01, -7.896603e-01},
  { 3.536183e-01,  4.884803e-01, -7.977099e-01, -2.925681e-01,  3.399643e-01, -7.948628e-01},
  { 4.118514e-02,  4.056160e-01, -9.131152e-01, -2.939636e-01,  4.388637e-01, -7.903997e-01},
  { 1.213594e-01,  4.330708e-01, -8.931527e-01, -3.026346e-01,  4.759509e-01, -7.630518e-01},
  { 1.470630e-01, -6.383614e-01, -7.555576e-01, -2.930455e-01,  5.501251e-01, -7.932246e-01},
  { 1.833847e-01, -6.519027e-01, -7.357939e-01, -2.839918e-01,  5.748498e-01, -8.218170e-01},
  { 1.310813e-01, -4.593767e-01, -8.785163e-01, -2.817884e-01,  5.872122e-01, -8.287564e-01},
  {-6.239790e-02, -4.031955e-01, -9.129841e-01, -2.979512e-01, -9.951702e-01, -7.098256e-01},
  {-9.289556e-03, -1.938538e-01, -9.809864e-01, -2.834422e-01, -8.220969e-01, -7.539220e-01},
  { 5.037353e-01, -4.515922e-01, -7.364206e-01, -2.578016e-01, -3.894148e-01, -8.315620e-01},
  { 1.943649e-01, -1.433851e-01, -9.703932e-01, -2.265817e-01, -6.799289e-02, -9.259628e-01},
  { 7.197940e-02,  3.759065e-01, -9.238578e-01, -2.301792e-01,  1.050806e-01, -9.151698e-01},
  { 5.685358e-01,  4.760987e-01, -6.708927e-01, -2.668594e-01,  3.028772e-01, -8.043600e-01},
  { 3.038707e-01,  2.838542e-01, -9.094446e-01, -2.684505e-01,  3.152396e-01, -7.994747e-01},
  { 4.132212e-02,  2.308796e-01, -9.721044e-01, -2.689590e-01,  4.141386e-01, -7.977062e-01},
  { 1.274017e-01,  5.418938e-01, -8.307346e-01, -2.798031e-01,  4.759509e-01, -7.650042e-01},
  { 3.555786e-01,  1.155013e-01, -9.274822e-01, -2.818085e-01,  4.883133e-01, -7.589515e-01},
  { 3.005432e-01, -4.794441e-01, -8.245042e-01, -2.809554e-01,  5.006756e-01, -7.615336e-01},
  { 1.300254e-01, -6.072738e-01, -7.837805e-01, -2.710039e-01,  5.501251e-01, -7.914506e-01},
  { 5.350460e-02, -1.349889e-01, -9.894015e-01, -2.455582e-01,  7.231982e-01, -8.685281e-01},
  { 4.693046e-02,  3.002886e-01, -9.526932e-01, -2.939851e-01,  1.205330e+00, -7.220914e-01},
  { 3.299670e-01, -1.201210e-01, -9.363187e-01, -2.594559e-01, -6.984744e-01, -7.590717e-01},
  { 3.398007e-01, -3.406196e-01, -8.766493e-01, -2.281369e-01, -3.152404e-01, -8.500538e-01},
  { 2.092949e-01,  2.392329e-01, -9.481367e-01, -2.031549e-01,  6.799346e-02, -9.226481e-01},
  { 2.058668e-01,  4.668375e-01, -8.600474e-01, -2.102372e-01,  1.298054e-01, -9.021248e-01},
  { 5.473506e-01,  6.551622e-01, -5.207397e-01, -2.383256e-01,  2.657900e-01, -8.206962e-01},
  { 5.717593e-01,  5.056934e-01, -6.460382e-01, -2.458612e-01,  2.905149e-01, -7.987646e-01},
  { 3.872039e-01,  4.180557e-02, -9.210458e-01, -2.486099e-01,  3.152396e-01, -7.906114e-01},
  { 1.687500e-01,  9.465387e-03, -9.856135e-01, -2.485740e-01,  3.276020e-01, -7.906493e-01},
  { 2.259993e-01,  4.319994e-01, -8.730984e-01, -2.637808e-01,  4.883133e-01, -7.464793e-01},
  { 2.933248e-01, -3.071859e-01, -9.053162e-01, -2.641429e-01,  5.006756e-01, -7.454270e-01},
  { 3.265553e-01, -6.813489e-01, -6.550765e-01, -2.598989e-01,  5.130381e-01, -7.577095e-01},
  { 7.625204e-02,  3.964788e-01, -9.148717e-01, -2.488149e-01,  9.828078e-01, -7.898449e-01},
  {-1.784542e-02,  3.223744e-01, -9.464440e-01, -2.686103e-01,  1.180606e+00, -7.323575e-01},
  { 2.378948e-01, -1.622237e-01, -9.576479e-01, -2.437649e-01, -8.839087e-01, -7.399086e-01},
  { 5.323127e-01, -4.547679e-01, -7.140234e-01, -2.110226e-01, -3.399654e-01, -8.315267e-01},
  { 2.541571e-01,  5.208583e-01, -8.149299e-01, -2.057176e-01,  2.163405e-01, -8.464893e-01},
  { 5.973341e-01,  4.210221e-01, -6.825924e-01, -2.287355e-01,  2.905149e-01, -7.820011e-01},
  { 5.201684e-01,  6.533676e-02, -8.515609e-01, -2.296101e-01,  3.028772e-01, -7.795563e-01},
  { 1.240101e-01,  9.015007e-02, -9.881773e-01, -2.232970e-01,  4.017763e-01, -7.971258e-01},
  { 3.306107e-02,  5.232134e-01, -8.515601e-01, -2.294942e-01,  4.512262e-01, -7.798333e-01},
  {-8.561147e-02,  2.479651e-01, -9.649787e-01, -2.403971e-01,  4.883133e-01, -7.494108e-01},
  { 5.076969e-02, -4.313470e-01, -9.007565e-01, -2.388351e-01,  5.130381e-01, -7.536103e-01},
  { 2.474923e-01, -6.323703e-01, -7.340677e-01, -2.243979e-01,  5.624875e-01, -7.940038e-01},
  { 2.700419e-01, -4.557884e-01, -8.481358e-01, -2.140462e-01,  6.119370e-01, -8.230235e-01},
  { 1.883877e-01, -1.957566e-01, -9.623873e-01, -1.987004e-01,  7.355605e-01, -8.658638e-01},
  { 9.127340e-02,  4.206874e-01, -9.026025e-01, -2.115306e-01,  8.962712e-01, -8.300073e-01},
  { 1.244885e-01,  3.684275e-01, -9.212838e-01, -2.427907e-01,  1.155881e+00, -7.426714e-01},
  { 1.296947e-01,  3.915287e-01, -9.109800e-01, -2.457535e-01,  1.180606e+00, -7.343786e-01},
  { 2.371728e-01,  3.004346e-01, -9.238442e-01, -2.479102e-01,  1.192968e+00, -7.283593e-01},
  { 1.516486e-01,  1.667951e-01, -9.742597e-01, -2.483518e-01,  1.205330e+00, -7.271785e-01},
  {-4.315142e-02, -6.368105e-01, -7.698119e-01, -2.715052e-01, -1.205331e+00, -6.047094e-01},
  { 5.413793e-01, -4.022625e-01, -7.383043e-01, -1.843914e-01, -2.905157e-01, -8.394002e-01},
  { 4.367310e-01, -3.713158e-01, -8.193843e-01, -1.784621e-01, -2.534286e-01, -8.553072e-01},
  { 2.963634e-01, -1.932939e-01, -9.353107e-01, -1.625447e-01, -1.298047e-01, -8.980761e-01},
  { 2.775963e-01, -6.346489e-03, -9.606769e-01, -1.552408e-01,  3.090626e-02, -9.177549e-01},
  { 6.168491e-01,  5.466927e-01, -5.662369e-01, -1.765030e-01,  1.792549e-01, -8.606885e-01},
  { 6.945887e-01,  5.800171e-01, -4.255899e-01, -1.933057e-01,  2.410653e-01, -8.156072e-01},
  { 6.395582e-01,  6.415890e-01, -4.234722e-01, -1.978242e-01,  2.534277e-01, -8.034976e-01},
  { 6.344862e-01,  5.453086e-01, -5.477826e-01, -2.086738e-01,  2.781524e-01, -7.740258e-01},
  { 5.321136e-01, -1.636252e-01, -8.307117e-01, -2.104208e-01,  3.028772e-01, -7.693776e-01},
  { 3.135977e-01, -2.643111e-01, -9.120286e-01, -2.056941e-01,  3.399643e-01, -7.819875e-01},
  { 1.617997e-01, -1.892971e-01, -9.684975e-01, -2.018522e-01,  3.770515e-01, -7.922890e-01},
  { 2.177029e-01,  5.311749e-01, -8.188154e-01, -2.075251e-01,  4.512262e-01, -7.771271e-01},
  { 1.632650e-01,  4.966393e-01, -8.524634e-01, -2.124211e-01,  4.759509e-01, -7.639442e-01},
  {-2.522283e-01,  1.347843e-01, -9.582349e-01, -2.181931e-01,  4.883133e-01, -7.484171e-01},
  {-1.786127e-01, -1.664387e-01, -9.697400e-01, -2.153934e-01,  5.254002e-01, -7.559489e-01},
  { 2.352708e-01, -5.132925e-01, -8.253354e-01, -2.127228e-01,  5.377627e-01, -7.631330e-01},
  { 4.101432e-01, -5.970007e-01, -6.894728e-01, -2.037081e-01,  5.624875e-01, -7.873517e-01},
  { 2.578991e-01,  8.639900e-03, -9.661332e-01, -1.758221e-01,  7.602853e-01, -8.623794e-01},
  { 2.038289e-01,  2.840373e-01, -9.368973e-01, -1.830899e-01,  8.591842e-01, -8.427838e-01},
  { 2.639379e-01,  4.281864e-01, -8.642877e-01, -2.206586e-01,  1.143519e+00, -7.417623e-01},
  { 2.661282e-01,  2.843609e-01, -9.210400e-01, -2.293491e-01,  1.205330e+00, -7.184044e-01},
  { 3.567962e-01,  3.657393e-01, -8.596111e-01, -1.402528e-01,  1.050806e-01, -8.915260e-01},
  { 5.709962e-01,  5.475890e-01, -6.116450e-01, -1.930152e-01,  2.781524e-01, -7.549335e-01},
  { 6.186592e-01, -7.289944e-02, -7.822701e-01, -1.937907e-01,  2.905149e-01, -7.526590e-01},
  { 3.533999e-01, -3.746313e-02, -9.347219e-01, -1.802210e-01,  3.894139e-01, -7.878250e-01},
  { 3.235748e-01,  3.400908e-01, -8.829709e-01, -1.838107e-01,  4.388637e-01, -7.785192e-01},
  { 8.305011e-02,  6.954870e-01, -7.137230e-01, -1.917885e-01,  4.635885e-01, -7.578496e-01},
  { 4.770309e-01,  2.445543e-01, -8.441769e-01, -1.949475e-01,  4.759509e-01, -7.496595e-01},
  { 5.298945e-01, -3.923801e-01, -7.518309e-01, -1.915216e-01,  4.883133e-01, -7.585419e-01},
  { 1.422959e-01, -3.938160e-01, -9.081084e-01, -1.866275e-01,  5.006756e-01, -7.712288e-01},
  { 5.297970e-01,  2.978638e-01, -7.940983e-01, -1.868499e-01,  5.254002e-01, -7.706524e-01},
  { 4.537377e-01,  2.926041e-01, -8.417274e-01, -1.902758e-01,  5.377627e-01, -7.617701e-01},
  { 6.392180e-01, -3.580790e-01, -6.805730e-01, -1.919665e-01,  5.501251e-01, -7.573876e-01},
  { 5.315704e-01, -6.203101e-01, -5.767566e-01, -1.817530e-01,  5.748498e-01, -7.838938e-01},
  { 5.198225e-01, -3.591840e-01, -7.750944e-01, -1.578868e-01,  7.231982e-01, -8.457495e-01},
  { 4.942228e-01,  4.829608e-02, -8.679927e-01, -1.548254e-01,  7.602853e-01, -8.536876e-01},
  { 2.247766e-01,  3.888119e-01, -8.934768e-01, -2.082060e-01,  1.205330e+00, -7.152890e-01},
  { 1.469240e-01, -2.069794e-01, -9.672502e-01, -1.958573e-01, -1.056982e+00, -6.897012e-01},
  { 5.077087e-01, -7.900652e-02, -8.578985e-01, -1.818289e-01, -6.861120e-01, -7.249662e-01},
  { 5.852260e-01, -6.743784e-02, -8.080610e-01, -1.798968e-01, -6.119378e-01, -7.297916e-01},
  { 6.498474e-01, -1.776134e-01, -7.390208e-01, -1.704763e-01, -4.883140e-01, -7.533486e-01},
  { 7.781205e-01, -3.858289e-01, -4.956456e-01, -1.524960e-01, -3.028781e-01, -7.985957e-01},
  { 7.145790e-01, -4.299400e-01, -5.518410e-01, -1.339756e-01, -2.163415e-01, -8.447362e-01},
  { 5.715829e-01, -2.684193e-01, -7.753993e-01, -1.181715e-01, -1.050800e-01, -8.841935e-01},
  { 5.824552e-01,  1.966258e-01, -7.887232e-01, -1.127570e-01,  4.326862e-02, -8.977436e-01},
  { 4.658880e-01,  4.559401e-01, -7.583318e-01, -1.219589e-01,  1.174429e-01, -8.747849e-01},
  { 5.152638e-01,  8.889995e-02, -8.524083e-01, -1.762617e-01,  2.905149e-01, -7.390099e-01},
  { 5.297328e-01, -2.441252e-01, -8.122721e-01, -1.609725e-01,  3.770515e-01, -7.771282e-01},
  { 2.057755e-01,  6.697862e-01, -7.134725e-01, -1.675407e-01,  4.635885e-01, -7.607185e-01},
  { 2.171265e-01,  7.321299e-01, -6.456329e-01, -1.725343e-01,  4.759509e-01, -7.482774e-01},
  { 7.400143e-01,  1.408419e-01, -6.576796e-01, -1.770437e-01,  4.883133e-01, -7.369155e-01},
  { 8.997908e-01, -1.237027e-01, -4.184186e-01, -1.765536e-01,  5.006756e-01, -7.384000e-01},
  { 8.306740e-01,  1.959778e-01, -5.211270e-01, -1.767988e-01,  5.377627e-01, -7.377721e-01},
  { 7.776196e-01, -3.163862e-01, -5.433300e-01, -1.785586e-01,  5.501251e-01, -7.331279e-01},
  { 5.890393e-01, -6.388768e-01, -4.948426e-01, -1.648661e-01,  5.748498e-01, -7.674821e-01},
  { 6.291614e-01, -1.541746e-02, -7.771218e-01, -1.354375e-01,  7.479229e-01, -8.409998e-01},
  { 1.995704e-01,  3.977247e-01, -8.955371e-01, -1.721378e-01,  1.106431e+00, -7.491767e-01},
  { 8.103189e-01, -1.293727e-02, -5.858462e-01, -1.489231e-01, -3.894148e-01, -7.494162e-01},
  { 9.152511e-01, -8.769743e-02, -3.932232e-01, -1.483319e-01, -3.523277e-01, -7.508962e-01},
  { 9.339635e-01, -3.169627e-01, -1.650662e-01, -1.388745e-01, -2.905157e-01, -7.738220e-01},
  { 8.475297e-01, -4.786318e-01, -2.293576e-01, -1.317440e-01, -2.657909e-01, -7.910057e-01},
  { 6.939104e-01, -2.069620e-01, -6.896775e-01, -1.582902e-01,  3.028772e-01, -7.266683e-01},
  { 5.749925e-01, -4.121123e-02, -8.171201e-01, -1.416375e-01,  4.017763e-01, -7.668408e-01},
  { 7.415245e-01,  2.451506e-01, -6.245340e-01, -1.629535e-01,  4.883133e-01, -7.152983e-01},
  { 7.083085e-01, -6.062189e-02, -7.032951e-01, -1.615281e-01,  5.501251e-01, -7.188591e-01},
  { 5.663785e-01, -6.082640e-01, -5.560848e-01, -1.610139e-01,  5.624875e-01, -7.199805e-01},
  { 5.173814e-01, -7.803591e-01, -3.512212e-01, -1.521261e-01,  5.748498e-01, -7.415075e-01},
  { 6.185063e-01, -6.508904e-01, -4.402179e-01, -1.451636e-01,  5.872122e-01, -7.583640e-01},
  { 5.218709e-01, -8.405139e-02, -8.488735e-01, -1.143478e-01,  7.850100e-01, -8.327149e-01},
  { 6.764624e-01,  6.811681e-02, -7.333202e-01, -1.341147e-01, -3.646901e-01, -7.291299e-01},
  { 7.695860e-01, -1.657615e-01, -6.166527e-01, -1.309822e-01, -2.905157e-01, -7.363004e-01},
  { 8.199968e-01, -1.927153e-01, -5.389491e-01, -1.312257e-01, -2.781533e-01, -7.357333e-01},
  { 8.139242e-01, -4.643316e-01, -3.491757e-01, -1.284007e-01, -2.657909e-01, -7.423224e-01},
  { 6.238087e-01, -5.657773e-01, -5.392207e-01, -9.445388e-02, -1.792542e-01, -8.217340e-01},
  { 5.382308e-01, -1.168158e-01, -8.346627e-01, -7.466520e-02, -3.090557e-02, -8.678080e-01},
  { 6.817745e-01, -4.087361e-01, -6.067276e-01, -1.294992e-01,  3.523267e-01, -7.398657e-01},
  { 6.446421e-01,  2.048852e-01, -7.365180e-01, -1.252745e-01,  4.512262e-01, -7.497249e-01},
  { 2.423393e-01,  8.398008e-01, -4.858048e-01, -1.352469e-01,  4.759509e-01, -7.265069e-01},
  { 1.260487e-01,  3.787001e-01, -9.168958e-01, -1.468608e-01,  4.883133e-01, -6.992596e-01},
  {-1.081044e-01, -2.225014e-01, -9.689204e-01, -1.467634e-01,  5.006756e-01, -6.994867e-01},
  {-9.867229e-02,  1.364600e-01, -9.857193e-01, -1.464109e-01,  5.377627e-01, -7.003096e-01},
  { 4.729236e-01, -1.783436e-02, -8.809230e-01, -1.462764e-01,  5.501251e-01, -7.006226e-01},
  { 5.365285e-01, -6.428846e-01, -5.466595e-01, -1.438409e-01,  5.624875e-01, -7.063046e-01},
  { 2.967660e-01, -8.368704e-01, -4.599758e-01, -1.346302e-01,  5.748498e-01, -7.277232e-01},
  { 4.082709e-01, -5.590570e-01, -7.216441e-01, -1.295899e-01,  5.872122e-01, -7.395384e-01},
  { 5.980908e-01, -5.412393e-01, -5.910562e-01, -1.268539e-01,  5.995746e-01, -7.460119e-01},
  { 6.763875e-01, -3.048639e-01, -6.704908e-01, -1.008076e-01,  7.355605e-01, -8.068123e-01},
  { 1.736010e-01, -1.767912e-02, -9.846574e-01, -1.219777e-01, -7.355601e-01, -7.035016e-01},
  { 2.449108e-01, -2.194156e-03, -9.695432e-01, -1.225448e-01, -6.984744e-01, -7.022280e-01},
  { 5.604014e-01, -2.169360e-01, -7.993053e-01, -1.114745e-01, -2.657909e-01, -7.273045e-01},
  { 6.927603e-01, -4.711818e-01, -5.459586e-01, -1.102212e-01, -2.534286e-01, -7.300822e-01},
  { 6.548439e-01, -6.319185e-01, -4.145582e-01, -9.705141e-02, -2.163415e-01, -7.601368e-01},
  { 7.600402e-01, -9.302781e-02, -6.431832e-01, -5.804799e-02, -4.326793e-02, -8.479304e-01},
  { 7.403429e-01, -1.808202e-01, -6.474538e-01, -1.096283e-01,  3.770515e-01, -7.315754e-01},
  { 5.135828e-01,  6.484329e-01, -5.619318e-01, -1.106354e-01,  4.635885e-01, -7.293998e-01},
  { 6.766315e-01,  3.370482e-01, -6.546513e-01, -1.221947e-01,  4.883133e-01, -7.030703e-01},
  { 5.135419e-01, -5.312595e-01, -6.738235e-01, -1.193893e-01,  5.006756e-01, -7.093999e-01},
  { 4.437586e-01, -7.508000e-01, -4.892623e-01, -1.069147e-01,  5.130381e-01, -7.375413e-01},
  { 5.890457e-01,  3.287959e-01, -7.381859e-01, -1.059129e-01,  5.377627e-01, -7.398021e-01},
  {-2.312609e-01,  5.713010e-01, -7.874856e-01, -1.152310e-01,  5.501251e-01, -7.187798e-01},
  {-2.063337e-01, -2.335465e-01, -9.502012e-01, -1.284068e-01,  5.624875e-01, -6.890560e-01},
  { 3.929420e-02, -8.334307e-01, -5.512251e-01, -1.178362e-01,  5.748498e-01, -7.129031e-01},
  { 2.802665e-01, -3.791655e-01, -8.818641e-01, -1.073656e-01,  5.872122e-01, -7.365245e-01},
  { 4.777515e-01, -2.352407e-02, -8.781801e-01, -1.078083e-01,  5.995746e-01, -7.355565e-01},
  { 6.799802e-01, -3.554727e-01, -6.413003e-01, -1.075955e-01,  6.119370e-01, -7.360954e-01},
  { 7.477257e-01, -3.309512e-01, -5.756541e-01, -9.789044e-02,  6.861111e-01, -7.580493e-01},
  { 6.420009e-01, -5.040754e-01, -5.777048e-01, -9.101105e-02, -2.410662e-01, -7.204162e-01},
  { 8.420861e-01, -3.933102e-01, -3.690501e-01, -5.430850e-02, -1.298047e-01, -8.006877e-01},
  { 5.709196e-01,  5.556442e-01, -6.044092e-01, -1.161468e-01,  2.781524e-01, -6.656513e-01},
  { 8.034434e-01,  2.943703e-01, -5.175180e-01, -1.127786e-01,  4.883133e-01, -6.727933e-01},
  { 9.113480e-01, -5.222114e-02, -4.083107e-01, -1.116114e-01,  5.006756e-01, -6.755442e-01},
  { 9.097116e-01, -2.005786e-03, -4.152358e-01, -1.129846e-01,  5.130381e-01, -6.723437e-01},
  { 8.815504e-01, -3.588802e-01, -3.067148e-01, -1.143231e-01,  5.377627e-01, -6.694217e-01},
  { 5.399943e-01, -7.932267e-01, -2.814206e-01, -1.057257e-01,  5.501251e-01, -6.881922e-01},
  { 7.301165e-02, -6.797562e-01, -7.297952e-01, -8.909724e-02,  5.624875e-01, -7.244944e-01},
  { 4.233843e-01, -2.994263e-01, -8.550378e-01, -8.539068e-02,  5.748498e-01, -7.325871e-01},
  { 3.907540e-01,  7.337653e-02, -9.175659e-01, -8.564801e-02,  5.872122e-01, -7.320262e-01},
  { 5.907007e-01,  3.470741e-01, -7.284313e-01, -8.932631e-02,  5.995746e-01, -7.241291e-01},
  { 7.182869e-01,  1.060447e-02, -6.956662e-01, -9.085253e-02,  6.119370e-01, -7.208247e-01},
  { 3.356114e-01,  3.298053e-01, -8.823794e-01, -7.194918e-02,  1.007533e+00, -7.619168e-01},
  { 7.062647e-01,  4.066094e-02, -7.067792e-01, -8.122737e-02, -4.265019e-01, -6.908087e-01},
  { 5.866902e-01, -2.006138e-01, -7.845691e-01, -7.598703e-02, -2.657909e-01, -7.017837e-01},
  { 8.129197e-01, -3.787457e-01, -4.423948e-01, -6.639815e-02, -1.916168e-01, -7.222150e-01},
  { 7.680061e-01, -1.273421e-02, -6.403159e-01, -1.026747e-01,  2.905149e-01, -6.454784e-01},
  { 8.047188e-01, -2.002450e-01, -5.588646e-01, -7.935799e-02,  3.894139e-01, -6.947811e-01},
  { 8.159358e-01,  1.439650e-01, -5.599312e-01, -7.941896e-02,  4.512262e-01, -6.947101e-01},
  { 6.335317e-01,  5.338520e-01, -5.600352e-01, -9.585898e-02,  4.883133e-01, -6.597360e-01},
  { 7.687965e-01, -2.437636e-02, -6.390287e-01, -9.718242e-02,  5.130381e-01, -6.570617e-01},
  { 5.579854e-01, -1.648700e-01, -8.133082e-01, -9.696899e-02,  5.254002e-01, -6.573892e-01},
  { 3.412417e-01, -4.663109e-01, -8.161545e-01, -9.744477e-02,  5.377627e-01, -6.563835e-01},
  { 5.494934e-01, -6.569582e-01, -5.162005e-01, -7.402918e-02,  5.624875e-01, -7.058905e-01},
  { 8.285168e-01,  2.544159e-01, -4.988311e-01, -7.202491e-02,  5.872122e-01, -7.103471e-01},
  { 8.516890e-01,  3.781548e-02, -5.226815e-01, -7.730897e-02,  6.242992e-01, -6.991510e-01},
  { 3.916911e-01,  7.614265e-02, -9.169408e-01, -3.695482e-02,  8.715466e-01, -7.842788e-01},
  { 3.334450e-01,  8.445742e-02, -9.389790e-01, -5.862963e-02, -5.995755e-01, -6.885085e-01},
  { 6.066226e-01,  8.321639e-02, -7.906226e-01, -6.115046e-02, -5.254011e-01, -6.834518e-01},
  { 8.391253e-01,  5.287957e-02, -5.413618e-01, -6.668362e-02, -4.388643e-01, -6.722334e-01},
  { 7.729115e-01, -8.674288e-02, -6.285565e-01, -6.174142e-02, -3.523277e-01, -6.822806e-01},
  { 7.005708e-01, -3.613210e-01, -6.153436e-01, -5.008313e-02, -1.792542e-01, -7.061940e-01},
  { 7.691460e-01, -3.990026e-01, -4.992106e-01, -4.096216e-02, -1.421671e-01, -7.250167e-01},
  { 7.875662e-01,  8.257185e-02, -6.106728e-01, -8.736356e-02,  2.905149e-01, -6.297946e-01},
  { 7.443241e-01,  4.409049e-01, -5.015819e-01, -6.833529e-02,  4.635885e-01, -6.689208e-01},
  { 6.767024e-01, -5.576850e-01, -4.806883e-01, -8.186402e-02,  5.254002e-01, -6.409421e-01},
  { 4.449410e-01, -7.201028e-01, -5.324277e-01, -7.351355e-02,  5.377627e-01, -6.580511e-01},
  { 6.201921e-01, -6.572706e-01, -4.282022e-01, -5.681254e-02,  5.624875e-01, -6.922687e-01},
  { 8.266882e-01,  4.350392e-02, -5.609760e-01, -5.654135e-02,  5.748498e-01, -6.928250e-01},
  { 8.384237e-01,  3.097591e-01, -4.484361e-01, -5.929441e-02,  5.872122e-01, -6.874303e-01},
  { 8.252552e-01, -3.290496e-01, -4.589992e-01, -6.464787e-02,  6.242992e-01, -6.764434e-01},
  { 6.782668e-01, -5.073221e-01, -5.315811e-01, -4.604971e-02,  7.231982e-01, -7.144319e-01},
  { 5.206316e-01, -4.859190e-01, -7.020154e-01, -2.580048e-02,  7.726477e-01, -7.558169e-01},
  { 4.574108e-01, -2.344386e-01, -8.577960e-01, -1.916011e-02,  8.097348e-01, -7.694093e-01},
  { 3.981420e-01, -1.158284e-01, -9.099817e-01, -1.712900e-02,  8.344595e-01, -7.735699e-01},
  { 8.067957e-01,  2.399053e-01, -5.399317e-01, -5.225369e-02, -4.512267e-01, -6.539598e-01},
  { 9.354750e-01,  5.673102e-02, -3.488095e-01, -5.531548e-02, -4.265019e-01, -6.479338e-01},
  { 8.876931e-01, -2.368006e-01, -3.948753e-01, -5.377755e-02, -3.894148e-01, -6.509360e-01},
  { 6.611036e-01, -2.728940e-01, -6.989070e-01, -3.571067e-02, -1.916168e-01, -6.866731e-01},
  { 8.675858e-01, -9.444544e-02, -4.882366e-01,  7.221678e-03,  6.181527e-03, -7.720971e-01},
  { 7.421990e-01,  1.472106e-01, -6.538118e-01,  6.678245e-03,  1.050806e-01, -7.709803e-01},
  { 6.095398e-01,  2.969467e-02, -7.921992e-01, -7.240136e-02,  3.028772e-01, -6.138235e-01},
  { 7.643985e-01, -2.391780e-01, -5.987393e-01, -7.188495e-02,  3.152396e-01, -6.148553e-01},
  { 8.343695e-01,  2.702049e-02, -5.505429e-01, -5.029077e-02,  4.141386e-01, -6.578392e-01},
  { 8.961669e-01,  1.403851e-01, -4.209239e-01, -5.145806e-02,  4.388637e-01, -6.555487e-01},
  { 7.748116e-01,  5.001112e-01, -3.867244e-01, -6.732329e-02,  4.883133e-01, -6.240797e-01},
  { 8.472537e-01,  1.687625e-01, -5.036669e-01, -6.972177e-02,  5.006756e-01, -6.192582e-01},
  { 8.434492e-01, -4.095987e-01, -3.475950e-01, -7.001199e-02,  5.254002e-01, -6.186504e-01},
  { 6.829302e-01, -6.968266e-01, -2.191784e-01, -5.724157e-02,  5.501251e-01, -6.439897e-01},
  { 7.825267e-01, -5.241967e-01, -3.359609e-01, -5.041327e-02,  5.624875e-01, -6.575607e-01},
  { 9.147991e-01,  1.102877e-01, -3.885605e-01, -4.543129e-02,  5.748498e-01, -6.673107e-01},
  { 8.783497e-01,  2.148041e-01, -4.270376e-01, -5.393333e-02,  6.119370e-01, -6.506526e-01},
  { 4.171734e-01, -7.009747e-01, -5.784469e-01, -1.102574e-02,  7.602853e-01, -7.356359e-01},
  { 1.040126e-01,  5.873559e-02, -9.928402e-01, -4.731514e-03, -8.468216e-01, -6.996437e-01},
  { 6.519287e-01,  3.305271e-01, -6.824520e-01, -3.053085e-02, -5.006763e-01, -6.501608e-01},
  { 7.681306e-01,  3.523309e-01, -5.346385e-01, -3.264381e-02, -4.883140e-01, -6.461025e-01},
  { 9.061271e-01, -3.418259e-01, -2.491759e-01, -4.722328e-02, -4.017772e-01, -6.181075e-01},
  { 8.393269e-01, -4.187989e-01, -3.466089e-01, -4.390047e-02, -3.894148e-01, -6.244544e-01},
  { 7.331561e-01, -4.442264e-01, -5.149223e-01, -3.558847e-02, -3.646901e-01, -6.404064e-01},
  { 5.272789e-01, -2.873860e-01, -7.996163e-01, -1.657347e-02, -1.668918e-01, -6.769993e-01},
  { 6.230781e-01,  3.923227e-01, -6.766510e-01,  1.973291e-02,  1.298054e-01, -7.470536e-01},
  { 5.480884e-01,  4.402108e-01, -7.112057e-01, -5.442258e-02,  2.905149e-01, -6.041144e-01},
  { 7.082549e-01, -1.730847e-01, -6.844098e-01, -5.624202e-02,  3.276020e-01, -6.006069e-01},
  { 7.509985e-01, -4.508810e-01, -4.823978e-01, -5.417611e-02,  3.399643e-01, -6.045889e-01},
  { 8.498083e-01, -2.497587e-01, -4.641620e-01, -4.086250e-02,  3.770515e-01, -6.302913e-01},
  { 8.140450e-01,  4.257186e-01, -3.950878e-01, -4.373289e-02,  4.635885e-01, -6.248475e-01},
  { 6.169805e-01,  6.251091e-01, -4.780937e-01, -4.997539e-02,  4.759509e-01, -6.125735e-01},
  { 3.489444e-01,  3.049213e-01, -8.861494e-01, -5.880010e-02,  4.883133e-01, -5.955649e-01},
  { 4.704823e-01,  8.611017e-02, -8.781978e-01, -5.940286e-02,  5.006756e-01, -5.944033e-01},
  { 4.156439e-01, -5.478621e-01, -7.260078e-01, -5.897101e-02,  5.377627e-01, -5.952356e-01},
  { 4.884362e-01, -7.522486e-01, -4.422128e-01, -4.997539e-02,  5.501251e-01, -6.125735e-01},
  { 7.053621e-01, -6.039282e-01, -3.711267e-01, -3.625422e-02,  5.624875e-01, -6.390191e-01},
  { 9.130315e-01, -8.418174e-02, -3.991076e-01, -3.528640e-02,  5.748498e-01, -6.408846e-01},
  { 8.947744e-01,  1.751444e-01, -4.107350e-01, -3.654185e-02,  5.872122e-01, -6.386772e-01},
  { 7.706121e-01,  2.812892e-01, -5.718683e-01, -3.887322e-02,  5.995746e-01, -6.339715e-01},
  { 6.363071e-01,  2.201822e-01, -7.393464e-01, -4.194758e-02,  6.119370e-01, -6.280459e-01},
  { 6.679142e-01, -1.840226e-01, -7.211285e-01, -4.365559e-02,  6.242992e-01, -6.247541e-01},
  { 5.393525e-01, -6.398717e-01, -5.474150e-01, -4.063822e-02,  6.366616e-01, -6.305697e-01},
  { 7.008070e-01, -5.412508e-01, -4.646687e-01, -3.317986e-02,  6.490240e-01, -6.449447e-01},
  { 7.212094e-01, -3.823787e-01, -5.776189e-01, -2.843229e-02,  6.613864e-01, -6.541821e-01},
  { 7.789513e-01, -3.212567e-01, -5.385433e-01, -2.612789e-02,  6.737487e-01, -6.586577e-01},
  { 7.059420e-01, -3.189219e-01, -6.324039e-01, -2.066109e-02,  7.108357e-01, -6.691360e-01},
  { 4.751586e-01, -7.347551e-01, -4.841068e-01, -1.934465e-02,  7.231982e-01, -6.716096e-01},
  { 3.575453e-01, -8.394889e-01, -4.091697e-01, -8.978171e-03,  7.355605e-01, -6.915197e-01},
  { 3.747531e-01, -7.514560e-01, -5.430231e-01,  7.820961e-04,  7.479229e-01, -7.103348e-01},
  { 4.681226e-01, -4.465937e-01, -7.625060e-01,  1.862834e-02,  7.973725e-01, -7.447709e-01},
  { 3.867030e-01,  4.929429e-01, -7.794024e-01, -3.902042e-02,  1.205330e+00, -6.337063e-01},
  { 7.107379e-02, -4.934797e-01, -8.668484e-01, -3.356360e-02, -1.205331e+00, -5.994998e-01},
  { 6.024288e-02,  6.498604e-02, -9.960662e-01,  2.061819e-02, -8.715463e-01, -7.009180e-01},
  { 2.950017e-01,  1.805159e-01, -9.382899e-01,  6.327980e-03, -6.984744e-01, -6.742471e-01},
  { 4.952340e-01,  1.955435e-01, -8.464668e-01,  3.262934e-03, -6.243002e-01, -6.685745e-01},
  { 5.831894e-01,  2.317568e-01, -7.785750e-01, -2.441107e-03, -5.748505e-01, -6.579537e-01},
  { 5.539575e-01,  4.503893e-01, -7.002005e-01, -2.895421e-02, -4.388643e-01, -6.084450e-01},
  { 6.396010e-01,  4.331383e-01, -6.350604e-01, -3.511265e-02, -4.141395e-01, -5.969108e-01},
  { 7.967451e-01, -8.475590e-02, -5.983424e-01, -3.890068e-02, -4.017772e-01, -5.896954e-01},
  { 5.918667e-01, -6.470282e-01, -4.806748e-01, -3.220888e-02, -3.894148e-01, -6.022518e-01},
  { 6.066624e-01, -5.550961e-01, -5.690598e-01, -2.114882e-02, -3.646901e-01, -6.229287e-01},
  { 5.468227e-01, -1.964045e-01, -8.138859e-01, -1.233324e-02, -3.276030e-01, -6.394011e-01},
  { 8.698348e-01,  4.576859e-02, -4.912154e-01,  3.803127e-02,  1.174429e-01, -7.337580e-01},
  { 5.629897e-01,  5.355781e-01, -6.294432e-01,  2.751930e-02,  1.668925e-01, -7.140883e-01},
  { 8.140926e-01, -7.782794e-02, -5.754964e-01, -4.326588e-02,  3.152396e-01, -5.816593e-01},
  { 7.842618e-01, -3.928805e-01, -4.801857e-01, -3.331130e-02,  3.646892e-01, -6.003014e-01},
  { 8.930627e-01, -1.933859e-01, -4.062521e-01, -2.755685e-02,  3.894139e-01, -6.111167e-01},
  { 9.142236e-01,  5.732081e-02, -4.011354e-01, -2.745387e-02,  4.017763e-01, -6.113313e-01},
  { 9.214575e-01,  2.439297e-01, -3.023484e-01, -3.074184e-02,  4.265016e-01, -6.049590e-01},
  { 9.536671e-01,  8.943335e-02, -2.872641e-01, -3.252156e-02,  4.512262e-01, -6.019138e-01},
  { 9.014248e-01,  1.424326e-01, -4.088353e-01, -3.447172e-02,  4.635885e-01, -5.979812e-01},
  { 8.085353e-01,  1.616613e-01, -5.658059e-01, -3.632971e-02,  4.759509e-01, -5.946289e-01},
  { 6.090664e-01, -3.177785e-01, -7.266739e-01, -3.476300e-02,  4.883133e-01, -5.974362e-01},
  { 1.824094e-01, -4.558451e-01, -8.711671e-01, -2.642951e-02,  5.006756e-01, -6.130270e-01},
  { 3.457916e-01, -1.602746e-01, -9.245216e-01, -2.497261e-02,  5.501251e-01, -6.157527e-01},
  { 8.112671e-01, -1.312871e-01, -5.697449e-01, -2.596316e-02,  5.624875e-01, -6.138992e-01},
  { 8.866339e-01, -6.024333e-03, -4.624328e-01, -2.648872e-02,  5.872122e-01, -6.131306e-01},
  { 8.575285e-01, -6.894041e-02, -5.097960e-01, -2.556144e-02,  5.995746e-01, -6.148140e-01},
  { 7.572497e-01, -2.842967e-01, -5.880037e-01, -2.404020e-02,  6.119370e-01, -6.174972e-01},
  { 4.691750e-01, -4.194389e-01, -7.771395e-01, -1.908658e-02,  6.242992e-01, -6.267643e-01},
  { 5.996564e-01, -4.211516e-01, -6.804731e-01, -1.296768e-02,  6.490240e-01, -6.382120e-01},
  { 7.800536e-01, -2.442379e-01, -5.760767e-01, -1.226824e-02,  6.613864e-01, -6.395204e-01},
  { 9.021240e-01, -1.744285e-01, -3.946479e-01, -1.232300e-02,  6.737487e-01, -6.395542e-01},
  { 7.753789e-01, -4.432047e-01, -4.498411e-01, -8.803389e-03,  6.984736e-01, -6.461103e-01},
  { 6.113986e-01, -6.002687e-01, -5.156249e-01, -5.381388e-03,  7.108357e-01, -6.524487e-01},
  { 4.223385e-01, -6.868230e-01, -5.915272e-01, -9.043175e-04,  7.231982e-01, -6.607804e-01},
  { 3.673878e-01, -7.375179e-01, -5.666511e-01,  2.555023e-02,  7.602853e-01, -7.102256e-01},
  { 5.041357e-01, -4.927633e-01, -7.092471e-01,  3.433036e-02,  7.850100e-01, -7.266782e-01},
  { 4.899908e-01, -2.031832e-01, -8.477179e-01,  4.440936e-02,  8.468218e-01, -7.455478e-01},
  { 7.997530e-02, -4.683830e-01, -8.798985e-01,  1.847931e-02, -1.106432e+00, -6.515339e-01},
  { 1.048777e-01, -2.558952e-01, -9.609986e-01,  3.613806e-02, -1.019895e+00, -6.836177e-01},
  { 5.367486e-01,  3.370797e-01, -7.734845e-01,  2.166851e-03, -5.006763e-01, -6.221330e-01},
  { 3.173033e-01,  3.734897e-01, -8.716788e-01, -1.732610e-02, -4.141395e-01, -5.866569e-01},
  { 3.314818e-01, -1.366252e-01, -9.335166e-01, -2.004403e-02, -4.017772e-01, -5.817172e-01},
  { 2.756912e-01, -5.005923e-01, -8.206106e-01,  1.375023e-04, -3.523277e-01, -6.183038e-01},
  { 3.802057e-01, -2.210712e-01, -8.980932e-01,  1.341664e-02, -2.781533e-01, -6.424846e-01},
  { 1.962666e-01, -1.999390e-01, -9.599500e-01,  1.492016e-02, -2.410662e-01, -6.452400e-01},
  { 6.046724e-01, -1.504967e-02, -7.963321e-01,  1.919799e-02, -1.421671e-01, -6.530403e-01},
  { 8.482307e-01, -2.278462e-01, -4.781118e-01, -2.935706e-02,  3.399643e-01, -5.649343e-01},
  { 8.874231e-01, -1.832794e-01, -4.229526e-01, -1.969615e-02,  3.770515e-01, -5.825376e-01},
  { 8.071321e-01,  3.640650e-01, -4.647521e-01, -1.966616e-02,  4.265016e-01, -5.825663e-01},
  { 6.505106e-01,  4.463894e-01, -6.144693e-01, -2.630310e-02,  4.388637e-01, -5.703453e-01},
  { 9.211821e-01, -6.875987e-02, -3.830087e-01, -2.731650e-02,  4.512262e-01, -5.685041e-01},
  { 9.610917e-01, -8.108666e-02, -2.640599e-01, -2.446388e-02,  4.635885e-01, -5.738567e-01},
  { 9.592479e-01, -1.102143e-01, -2.601849e-01, -2.201120e-02,  4.759509e-01, -5.781432e-01},
  { 9.329081e-01, -2.658389e-01, -2.429242e-01, -1.814618e-02,  5.006756e-01, -5.853634e-01},
  { 9.932256e-01, -4.083356e-02, -1.087918e-01, -1.544520e-02,  5.377627e-01, -5.903122e-01},
  { 8.710605e-01, -1.821160e-01, -4.561659e-01, -1.192873e-02,  6.119370e-01, -5.966772e-01},
  { 8.823244e-01, -3.254068e-01, -3.400207e-01, -5.590840e-03,  6.366616e-01, -6.081819e-01},
  { 2.997302e-01, -8.581796e-01, -4.167609e-01,  1.768031e-02,  7.231982e-01, -6.502149e-01},
  { 4.503835e-01, -7.058290e-01, -5.467724e-01,  3.729805e-02,  7.479229e-01, -6.858295e-01},
  { 4.907926e-01, -3.932509e-01, -7.774807e-01,  5.926685e-02,  8.097348e-01, -7.257965e-01},
  { 4.526800e-01,  5.192041e-02, -8.901602e-01,  6.437091e-02,  8.715466e-01, -7.350900e-01},
  { 3.805895e-01,  3.304367e-01, -8.636917e-01,  5.101052e-02,  1.019895e+00, -7.108353e-01},
  { 6.258482e-02, -1.828426e-01, -9.811482e-01,  6.845950e-02, -9.580831e-01, -6.963966e-01},
  { 3.316157e-01,  3.843294e-01, -8.615811e-01,  7.314726e-03, -4.388643e-01, -5.886032e-01},
  { 1.536942e-01,  1.259430e-01, -9.800594e-01,  3.300733e-03, -4.141395e-01, -5.814847e-01},
  { 9.459567e-02, -1.242741e-01, -9.877285e-01,  2.329557e-03, -4.017772e-01, -5.798424e-01},
  { 3.038193e-01, -1.971245e-01, -9.321136e-01,  3.379411e-02, -2.657909e-01, -6.353214e-01},
  { 7.758882e-01,  1.115751e-01, -6.209255e-01,  6.655772e-02,  1.298054e-01, -6.933582e-01},
  { 6.381492e-01,  2.816037e-01, -7.165648e-01, -1.644561e-02,  3.276020e-01, -5.467830e-01},
  { 8.125899e-01, -1.801983e-01, -5.542799e-01, -1.686778e-02,  3.399643e-01, -5.460534e-01},
  { 6.740981e-01,  2.445631e-01, -6.969797e-01, -8.022512e-03,  4.388637e-01, -5.616655e-01},
  { 7.274420e-01,  2.121277e-01, -6.525567e-01, -1.186804e-02,  4.635885e-01, -5.547803e-01},
  { 9.395078e-01, -1.771531e-01, -2.931583e-01, -8.909266e-03,  5.872122e-01, -5.602586e-01},
  { 8.081320e-01, -4.506875e-01, -3.792143e-01,  1.475286e-02,  6.984736e-01, -6.018708e-01},
  { 4.150773e-01, -7.166007e-01, -5.605304e-01,  6.078890e-02,  7.602853e-01, -6.829945e-01},
  { 6.019223e-01,  6.860241e-02, -7.956024e-01,  8.397480e-02,  8.715466e-01, -7.239681e-01},
  { 2.256635e-01,  3.273467e-01, -9.175621e-01,  3.558607e-02, -4.759516e-01, -5.961359e-01},
  { 9.397998e-02, -1.717757e-01, -9.806431e-01,  5.033184e-02, -3.276030e-01, -6.213198e-01},
  { 5.408051e-01,  1.936958e-01, -8.185425e-01,  5.361268e-02, -8.035525e-02, -6.271560e-01},
  { 8.564057e-01, -2.227360e-01, -4.657874e-01,  7.826352e-02,  9.271819e-02, -6.695759e-01},
  { 8.148293e-01, -1.563125e-02, -5.794901e-01,  8.056234e-02,  1.174429e-01, -6.734936e-01},
  { 6.767768e-01,  3.391695e-01, -6.534043e-01,  7.713594e-02,  1.668925e-01, -6.675846e-01},
  { 7.616459e-01, -5.952902e-02, -6.452533e-01, -1.529713e-03,  3.646892e-01, -5.325969e-01},
  { 8.525971e-01, -1.370334e-01, -5.042818e-01,  6.828897e-03,  4.141386e-01, -5.469887e-01},
  { 7.961437e-01,  1.275973e-01, -5.915015e-01,  7.046141e-03,  4.265016e-01, -5.473499e-01},
  { 8.632964e-01, -3.503289e-01, -3.633027e-01,  4.014291e-03,  6.242992e-01, -5.421993e-01},
  { 5.609078e-01, -6.554135e-01, -5.057821e-01,  2.838852e-02,  6.984736e-01, -5.838323e-01},
  { 4.686125e-01, -7.715047e-01, -4.303288e-01,  3.519032e-02,  7.108357e-01, -5.954069e-01},
  { 2.532174e-01, -8.790094e-01, -4.040091e-01,  4.842093e-02,  7.231982e-01, -6.180292e-01},
  { 3.072977e-01, -8.031778e-01, -5.103661e-01,  6.395136e-02,  7.355605e-01, -6.446842e-01},
  { 4.688807e-01, -5.216833e-01, -7.127395e-01,  8.943671e-02,  7.850100e-01, -6.885291e-01},
  { 5.661428e-01, -3.159527e-01, -7.613516e-01,  9.922156e-02,  8.220971e-01, -7.053608e-01},
  { 4.983030e-01,  1.721552e-01, -8.497392e-01,  1.000099e-01,  9.457207e-01, -7.067331e-01},
  { 1.760099e-01,  6.385083e-02, -9.823155e-01,  4.764715e-02, -4.141395e-01, -5.755802e-01},
  { 8.397389e-02, -4.190852e-01, -9.040552e-01,  4.957059e-02, -4.017772e-01, -5.787209e-01},
  { 5.497115e-01,  2.086598e-01, -8.088748e-01,  7.456721e-02, -1.916168e-01, -6.205592e-01},
  { 7.995116e-01, -1.347473e-01, -5.853413e-01,  6.949323e-02,  6.181527e-03, -6.122350e-01},
  { 8.210384e-01, -3.597105e-01, -4.432880e-01,  7.536683e-02,  4.326862e-02, -6.220914e-01},
  { 7.975974e-01,  6.053777e-02, -6.001447e-01,  9.447572e-02,  1.545301e-01, -6.539242e-01},
  { 6.375334e-01,  3.807317e-01, -6.697720e-01,  8.997021e-02,  1.792549e-01, -6.464036e-01},
  { 5.344349e-01,  4.681281e-01, -7.037297e-01,  1.421975e-02,  3.399643e-01, -5.199620e-01},
  { 7.412612e-01,  9.956979e-02, -6.637903e-01,  1.270118e-02,  3.523267e-01, -5.174542e-01},
  { 8.528617e-01, -1.487546e-01, -5.004988e-01,  1.546864e-02,  4.017763e-01, -5.221457e-01},
  { 9.119035e-01,  1.658417e-01, -3.754044e-01,  4.105914e-03,  5.006756e-01, -5.032537e-01},
  { 8.228608e-01, -3.466127e-01, -4.502886e-01,  1.387254e-02,  6.242992e-01, -5.194592e-01},
  { 2.500626e-01, -8.878245e-01, -3.863111e-01,  5.395161e-02,  7.108357e-01, -5.860301e-01},
  { 3.269836e-01, -7.209736e-01, -6.109654e-01,  9.901542e-02,  7.602853e-01, -6.613084e-01},
  { 7.296877e-01, -2.736760e-02, -6.832326e-01,  1.206347e-01,  8.468218e-01, -6.974658e-01},
  { 5.059918e-01,  4.091713e-02, -8.615673e-01,  1.163169e-01,  9.704456e-01, -6.902785e-01},
  { 4.971857e-01,  3.994085e-01, -7.702462e-01,  1.068567e-01,  1.032257e+00, -6.745108e-01},
  { 3.592066e-01,  1.893212e-01, -9.138535e-01,  9.397753e-02, -5.748505e-01, -6.112863e-01},
  { 8.575618e-02,  2.988319e-01, -9.504448e-01,  8.120202e-02, -4.883140e-01, -5.905170e-01},
  { 3.215705e-01,  1.144414e-01, -9.399444e-01,  9.814209e-02, -2.287039e-01, -6.180211e-01},
  { 6.015522e-01,  8.149748e-02, -7.946654e-01,  8.422500e-02, -6.180837e-03, -5.955574e-01},
  { 4.004151e-01,  5.619141e-01, -7.238234e-01,  3.148172e-02,  3.399643e-01, -5.099468e-01},
  { 8.498287e-01,  1.667265e-01, -4.999935e-01,  2.857432e-02,  4.512262e-01, -5.053621e-01},
  { 8.305501e-01,  3.115487e-01, -4.616535e-01,  1.328545e-02,  5.006756e-01, -4.805620e-01},
  { 9.079339e-01, -1.233186e-02, -4.189319e-01,  1.214948e-02,  5.130381e-01, -4.787051e-01},
  { 4.511357e-01, -7.040783e-01, -5.484071e-01,  5.347697e-02,  6.861111e-01, -5.455644e-01},
  { 6.374499e-01, -1.426812e-02, -7.703596e-01,  1.376753e-01,  8.344595e-01, -6.822519e-01},
  { 4.522669e-01,  1.571737e-01, -8.779243e-01,  1.364097e-01,  9.580831e-01, -6.802232e-01},
  { 5.539714e-01,  6.191354e-01, -5.565853e-01,  6.141803e-02,  1.205330e+00, -5.585812e-01},
  { 1.784179e-01, -7.783912e-01, -6.018922e-01,  9.976237e-02, -1.205331e+00, -5.802699e-01},
  { 8.730384e-02,  9.421192e-02, -9.917167e-01,  1.141021e-01, -5.624881e-01, -6.030200e-01},
  { 3.468606e-02,  3.128750e-01, -9.491608e-01,  1.004747e-01, -4.512267e-01, -5.814633e-01},
  { 1.112036e-01,  4.159870e-01, -9.025456e-01,  9.434211e-02, -4.265019e-01, -5.718298e-01},
  { 2.385430e-01,  1.410943e-02, -9.710295e-01,  8.967198e-02, -4.141395e-01, -5.645207e-01},
  { 2.279643e-01, -6.227684e-01, -7.484596e-01,  9.350851e-02, -4.017772e-01, -5.704535e-01},
  { 6.316792e-02, -5.622277e-01, -8.245664e-01,  1.172218e-01, -3.646901e-01, -6.078203e-01},
  { 5.878315e-01,  2.315470e-01, -7.751388e-01,  1.060564e-01, -8.035525e-02, -5.903935e-01},
  { 5.082502e-01, -6.225374e-02, -8.589565e-01,  1.011649e-01,  1.854389e-02, -5.826746e-01},
  { 5.785582e-01, -1.744162e-01, -7.967744e-01,  1.026004e-01,  4.326862e-02, -5.849563e-01},
  { 7.060345e-01, -2.287915e-02, -7.078077e-01,  1.234039e-01,  1.668925e-01, -6.178585e-01},
  { 8.375875e-01,  1.244269e-01, -5.319447e-01,  2.322085e-02,  5.130381e-01, -4.597057e-01},
  { 6.049237e-01, -6.661910e-01, -4.361844e-01,  4.224870e-02,  6.366616e-01, -4.896588e-01},
  { 1.840380e-01, -9.212527e-01, -3.426712e-01,  1.130151e-01,  7.231982e-01, -6.011455e-01},
  { 1.878926e-01,  5.445573e-01, -8.174067e-01,  1.170705e-01, -4.265019e-01, -5.682735e-01},
  { 4.029709e-01,  3.383881e-01, -8.503575e-01,  1.124472e-01, -4.141395e-01, -5.612130e-01},
  { 4.833441e-01, -4.793479e-01, -7.325326e-01,  1.129191e-01, -4.017772e-01, -5.619383e-01},
  { 6.882601e-02, -7.922533e-01, -6.062983e-01,  1.342060e-01, -3.770525e-01, -5.944724e-01},
  { 9.629417e-02, -3.884997e-01, -9.164035e-01,  1.457206e-01, -3.523277e-01, -6.121787e-01},
  { 6.194082e-01, -3.252312e-01, -7.145335e-01,  1.228732e-01,  6.799346e-02, -5.772017e-01},
  { 6.728637e-01, -2.419959e-01, -6.990654e-01,  1.299462e-01,  1.050806e-01, -5.881265e-01},
  { 8.173500e-01,  9.097257e-02, -5.689139e-01,  3.508835e-02,  5.130381e-01, -4.424018e-01},
  { 4.838304e-01, -7.534726e-01, -4.451821e-01,  7.612164e-02,  6.737487e-01, -5.053024e-01},
  { 3.303511e-01, -8.405133e-01, -4.294243e-01,  8.590610e-02,  6.861111e-01, -5.202538e-01},
  { 4.820432e-01,  2.786073e-01, -8.306698e-01,  1.712566e-01,  9.828078e-01, -6.516340e-01},
  { 2.654453e-01, -9.236233e-01, -2.765116e-01,  1.625157e-01, -1.180606e+00, -5.980858e-01},
  { 2.931451e-02, -4.413845e-01, -8.968391e-01,  2.044176e-01, -1.094069e+00, -6.608204e-01},
  { 7.339781e-02,  1.881624e-01, -9.793915e-01,  2.242340e-01, -9.209958e-01, -6.905524e-01},
  { 1.166827e-01,  1.781624e-01, -9.770585e-01,  1.565640e-01, -5.254011e-01, -5.892892e-01},
  { 1.542960e-02,  2.773374e-01, -9.606487e-01,  1.524723e-01, -4.635892e-01, -5.831448e-01},
  { 5.687282e-01,  7.403240e-02, -8.191870e-01,  1.242199e-01, -4.017772e-01, -5.410123e-01},
  { 1.547385e-01, -8.840560e-01, -4.410226e-01,  1.380028e-01, -3.894148e-01, -5.615093e-01},
  { 3.633285e-01,  1.994040e-01, -9.100717e-01,  1.459981e-01, -9.271762e-02, -5.735621e-01},
  { 4.653851e-01,  1.310505e-01, -8.753527e-01,  1.404384e-01, -3.090557e-02, -5.652557e-01},
  { 3.060908e-01, -1.582047e-01, -9.387650e-01,  1.420699e-01,  4.326862e-02, -5.676340e-01},
  { 3.182969e-01, -1.331558e-01, -9.385929e-01,  1.437640e-01,  6.799346e-02, -5.701496e-01},
  { 5.370074e-01,  2.620047e-01, -8.018582e-01,  1.553184e-01,  1.792549e-01, -5.875830e-01},
  { 5.643657e-01,  3.291507e-01, -7.570674e-01,  6.116926e-02,  4.141386e-01, -4.466520e-01},
  { 8.568717e-01,  1.625238e-01, -4.892412e-01,  4.500229e-02,  5.501251e-01, -4.225881e-01},
  { 9.026273e-01, -8.367605e-02, -4.222111e-01,  4.441836e-02,  5.624875e-01, -4.217091e-01},
  { 1.677431e-01, -8.495198e-01, -5.001784e-01,  1.636873e-01,  7.355605e-01, -5.999531e-01},
  { 4.678209e-01, -5.745903e-01, -6.715576e-01,  1.845897e-01,  7.850100e-01, -6.313136e-01},
  { 5.672148e-01, -3.134315e-01, -7.615957e-01,  1.926169e-01,  8.220971e-01, -6.433480e-01},
  { 5.036491e-01,  4.569808e-01, -7.331482e-01,  1.841481e-01,  1.007533e+00, -6.307454e-01},
  { 1.158169e-01, -8.347246e-01, -5.383505e-01,  1.969689e-01, -1.168244e+00, -6.098866e-01},
  {-1.557991e-02, -5.697005e-01, -8.217047e-01,  2.111765e-01, -1.143519e+00, -6.306067e-01},
  { 3.029373e-02,  6.065863e-01, -7.944402e-01,  1.657440e-01, -4.265019e-01, -5.645084e-01},
  {-1.060559e-01, -5.101683e-01, -8.535106e-01,  1.459191e-01, -4.017772e-01, -5.357252e-01},
  { 1.688935e-01, -4.512193e-01, -8.762855e-01,  1.938333e-01, -3.523277e-01, -6.054066e-01},
  { 1.805110e-01,  2.868866e-02, -9.831545e-01,  1.987944e-01, -3.152404e-01, -6.126700e-01},
  { 2.439350e-01,  7.549638e-02, -9.668486e-01,  1.614455e-01, -3.090557e-02, -5.583555e-01},
  {-8.099016e-02,  1.104750e-01, -9.905735e-01,  1.586479e-01, -1.854320e-02, -5.542778e-01},
  { 5.950646e-02,  4.184762e-02, -9.973503e-01,  1.570394e-01, -6.180837e-03, -5.519335e-01},
  { 6.997977e-02, -1.210877e-01, -9.901720e-01,  1.588687e-01,  1.854389e-02, -5.545998e-01},
  { 9.523858e-02, -2.647837e-01, -9.595933e-01,  1.629841e-01,  4.326862e-02, -5.605983e-01},
  {-1.424422e-02, -1.463581e-01, -9.891291e-01,  1.671456e-01,  5.563099e-02, -5.664694e-01},
  { 1.991212e-01, -4.128375e-02, -9.791049e-01,  1.691300e-01,  1.298054e-01, -5.694996e-01},
  { 4.650044e-01, -1.505973e-01, -8.724055e-01,  1.702476e-01,  1.421678e-01, -5.711479e-01},
  { 2.306043e-01,  6.255167e-01, -7.453526e-01,  1.159686e-01,  3.276020e-01, -4.920190e-01},
  {-2.134476e-02,  6.153224e-01, -7.879865e-01,  8.264566e-02,  4.141386e-01, -4.434043e-01},
  { 3.206629e-01,  3.966645e-01, -8.601353e-01,  7.402209e-02,  4.265016e-01, -4.309327e-01},
  { 6.487977e-01,  1.021418e-01, -7.540746e-01,  7.410189e-02,  4.388637e-01, -4.310685e-01},
  { 7.030899e-01,  2.903713e-01, -6.491141e-01,  7.169557e-02,  4.635885e-01, -4.275950e-01},
  { 7.458209e-01,  1.846316e-01, -6.400487e-01,  5.497567e-02,  5.501251e-01, -4.032485e-01},
  { 7.525937e-01, -1.015108e-01, -6.506138e-01,  5.484610e-02,  5.624875e-01, -4.030368e-01},
  { 7.314397e-01, -3.649228e-01, -5.760446e-01,  5.648341e-02,  5.748498e-01, -4.053981e-01},
  { 4.468277e-01, -5.915849e-01, -6.710979e-01,  6.432932e-02,  5.995746e-01, -4.167857e-01},
  { 4.496581e-01, -6.884730e-01, -5.690453e-01,  7.616001e-02,  6.242992e-01, -4.339956e-01},
  { 2.058479e-01, -8.767424e-01, -4.346833e-01,  1.112430e-01,  6.737487e-01, -4.849967e-01},
  { 1.512205e-01, -8.352169e-01, -5.287204e-01,  1.758812e-01,  7.231982e-01, -5.792444e-01},
  { 4.618500e-01, -5.943040e-01, -6.584052e-01,  1.895234e-01,  7.479229e-01, -5.992025e-01},
  { 5.364411e-01,  2.565034e-01, -8.040130e-01,  2.106443e-01,  9.704456e-01, -6.300882e-01},
  { 5.954239e-01,  6.604401e-01, -4.574814e-01,  1.426915e-01,  1.155881e+00, -5.311386e-01},
  { 1.574136e-01, -7.117731e-01, -6.845437e-01,  2.305585e-01, -1.155881e+00, -6.192371e-01},
  { 4.320030e-02,  3.154792e-01, -9.479487e-01,  2.729131e-01, -8.962710e-01, -6.794872e-01},
  { 1.880983e-01,  3.341559e-02, -9.815816e-01,  2.208603e-01, -6.737497e-01, -6.056335e-01},
  { 1.018392e-02,  3.527821e-01, -9.356501e-01,  2.025154e-01, -4.512267e-01, -5.795084e-01},
  {-1.637179e-01,  1.009074e-01, -9.813328e-01,  1.772826e-01, -4.017772e-01, -5.435351e-01},
  { 1.070296e-01, -6.885421e-01, -7.172548e-01,  2.103568e-01, -3.646901e-01, -5.905837e-01},
  { 2.536808e-01, -1.687794e-01, -9.524493e-01,  2.226834e-01, -3.276030e-01, -6.081625e-01},
  { 9.517309e-02,  1.263660e-03, -9.954599e-01,  1.853553e-01, -5.563052e-02, -5.552847e-01},
  {-1.023671e-02,  2.565989e-02, -9.996184e-01,  1.835045e-01, -4.326793e-02, -5.526569e-01},
  {-2.434432e-01, -3.076346e-01, -9.198350e-01,  1.808707e-01, -3.090557e-02, -5.489171e-01},
  {-3.010848e-01, -4.202102e-01, -8.560207e-01,  1.924738e-01, -1.854320e-02, -5.653921e-01},
  {-4.690524e-01, -1.141946e-01, -8.757566e-01,  1.985605e-01, -6.180837e-03, -5.735257e-01},
  {-3.876897e-01,  8.381562e-02, -9.179714e-01,  1.999260e-01,  5.563099e-02, -5.756139e-01},
  {-7.727269e-02,  1.638004e-01, -9.834624e-01,  1.955805e-01,  8.035583e-02, -5.695729e-01},
  { 1.697539e-01,  4.399486e-02, -9.845040e-01,  1.914108e-01,  1.174429e-01, -5.637488e-01},
  { 2.904675e-01,  2.144914e-02, -9.566444e-01,  1.910817e-01,  1.545301e-01, -5.633463e-01},
  { 2.592999e-01,  4.342591e-01, -8.626602e-01,  1.883770e-01,  2.039797e-01, -5.595582e-01},
  { 2.309981e-02,  4.157337e-01, -9.091929e-01,  9.267323e-02,  4.388637e-01, -4.236885e-01},
  { 2.297929e-01,  4.168178e-01, -8.794647e-01,  8.962187e-02,  4.512262e-01, -4.192962e-01},
  { 5.509503e-01,  3.724697e-01, -7.468066e-01,  7.421427e-02,  5.254002e-01, -3.974912e-01},
  { 4.528641e-01,  3.130002e-01, -8.348323e-01,  7.065815e-02,  5.377627e-01, -3.924293e-01},
  { 4.719205e-01,  4.525800e-02, -8.804787e-01,  6.935386e-02,  5.501251e-01, -3.905540e-01},
  { 4.664177e-01, -1.391133e-01, -8.735572e-01,  7.002179e-02,  5.624875e-01, -3.914767e-01},
  { 3.033239e-01, -3.962075e-01, -8.666108e-01,  7.204060e-02,  5.748498e-01, -3.943183e-01},
  { 3.223847e-01, -7.459744e-01, -5.827438e-01,  1.071179e-01,  6.490240e-01, -4.440636e-01},
  { 5.369754e-01, -5.535956e-02, -8.417794e-01,  2.332942e-01,  8.839090e-01, -6.233630e-01},
  { 5.515267e-01,  7.937583e-02, -8.303721e-01,  2.329449e-01,  9.333584e-01, -6.228563e-01},
  { 9.882481e-02, -6.966305e-01, -7.105911e-01,  2.252689e-01, -1.205331e+00, -5.738834e-01},
  { 1.939986e-01,  6.340935e-02, -9.789503e-01,  3.066844e-01, -9.704455e-01, -6.863758e-01},
  { 1.186920e-01,  3.448381e-01, -9.311277e-01,  2.886114e-01, -8.468216e-01, -6.614178e-01},
  { 8.045813e-02,  1.603867e-01, -9.837697e-01,  2.347123e-01, -5.006763e-01, -5.867720e-01},
  { 2.594265e-02, -1.057014e-01, -9.940594e-01,  2.088299e-01, -4.017772e-01, -5.511400e-01},
  { 2.198486e-01, -5.338189e-01, -8.165194e-01,  2.444160e-01, -3.399654e-01, -6.002448e-01},
  { 1.832492e-01,  1.385048e-01, -9.732606e-01,  2.098297e-01, -6.799289e-02, -5.524257e-01},
  { 1.649122e-02, -4.527581e-01, -8.914809e-01,  2.092382e-01, -5.563052e-02, -5.515656e-01},
  {-1.781908e-01, -6.649364e-01, -7.253327e-01,  2.169408e-01, -4.326793e-02, -5.623615e-01},
  {-4.236487e-01, -5.078297e-01, -7.500872e-01,  2.380872e-01, -3.090557e-02, -5.916172e-01},
  {-5.071681e-01, -2.412401e-01, -8.273957e-01,  2.519755e-01, -6.180837e-03, -6.102183e-01},
  {-3.254187e-02,  2.557898e-01, -9.661846e-01,  2.182852e-01,  1.174429e-01, -5.640534e-01},
  { 1.702305e-01,  5.367516e-01, -8.263894e-01,  1.780456e-01,  2.657900e-01, -5.084857e-01},
  {-6.143614e-02,  5.522532e-01, -8.314096e-01,  1.288251e-01,  4.265016e-01, -4.403239e-01},
  { 2.507194e-01,  3.269905e-01, -9.111624e-01,  9.214314e-02,  5.254002e-01, -3.896534e-01},
  { 1.699443e-01,  5.605349e-02, -9.838582e-01,  8.903600e-02,  5.501251e-01, -3.852969e-01},
  { 1.696114e-01, -7.148492e-01, -6.783970e-01,  1.270259e-01,  6.490240e-01, -4.377721e-01},
  { 1.453468e-01, -9.041258e-01, -4.017847e-01,  1.907966e-01,  6.984736e-01, -5.259379e-01},
  { 4.506790e-01, -5.141825e-01, -7.297293e-01,  2.318188e-01,  7.602853e-01, -5.828920e-01},
  { 5.738676e-01,  5.485910e-01, -6.080493e-01,  2.238607e-01,  1.044620e+00, -5.720168e-01},
  { 1.741024e-01,  3.187421e-01, -9.317144e-01,  2.752343e-01, -7.355601e-01, -6.044217e-01},
  { 8.263288e-02,  3.025914e-01, -9.495317e-01,  2.358883e-01, -4.017772e-01, -5.513993e-01},
  { 2.866148e-01, -1.835558e-01, -9.402974e-01,  2.671548e-01, -3.399654e-01, -5.934463e-01},
  { 2.488434e-01,  1.871615e-01, -9.502881e-01,  2.625829e-01, -2.410662e-01, -5.873086e-01},
  { 9.215733e-02,  6.300158e-02, -9.937494e-01,  2.352318e-01, -8.035525e-02, -5.503696e-01},
  {-5.521711e-02, -1.717776e-01, -9.835870e-01,  2.330898e-01, -6.799289e-02, -5.476261e-01},
  {-1.814156e-01, -4.822408e-01, -8.570486e-01,  2.344889e-01, -5.563052e-02, -5.495128e-01},
  {-2.597557e-01, -7.348455e-01, -6.265214e-01,  2.551682e-01, -4.326793e-02, -5.768851e-01},
  {-4.021118e-01,  1.089079e-01, -9.090903e-01,  3.019162e-01,  1.854389e-02, -6.399788e-01},
  {-2.603029e-01,  3.840258e-01, -8.858706e-01,  2.580758e-01,  9.271819e-02, -5.810423e-01},
  {-1.612644e-01,  4.507746e-01, -8.779499e-01,  2.515827e-01,  1.050806e-01, -5.723364e-01},
  { 1.020347e-01,  5.277412e-01, -8.432546e-01,  2.070495e-01,  2.534277e-01, -5.124623e-01},
  { 4.800571e-02,  4.452204e-01, -8.941332e-01,  1.250202e-01,  4.883133e-01, -4.017825e-01},
  { 1.265898e-02,  2.637434e-01, -9.645098e-01,  1.157785e-01,  5.130381e-01, -3.893433e-01},
  { 1.739113e-02, -1.501615e-01, -9.885085e-01,  1.131770e-01,  5.624875e-01, -3.857746e-01},
  { 1.306474e-01, -5.867226e-01, -7.991794e-01,  1.411995e-01,  6.366616e-01, -4.235452e-01},
  { 1.539149e-02, -9.228675e-01, -3.848100e-01,  1.801066e-01,  6.737487e-01, -4.758838e-01},
  { 3.744881e-01, -8.157297e-01, -4.408441e-01,  2.234198e-01,  7.108357e-01, -5.344551e-01},
  { 5.703500e-01, -4.125346e-01, -7.102931e-01,  2.576341e-01,  7.850100e-01, -5.807050e-01},
  { 6.453649e-01, -1.544380e-01, -7.480997e-01,  2.642902e-01,  8.220971e-01, -5.897062e-01},
  { 6.942470e-01,  2.077121e-01, -6.891131e-01,  2.653269e-01,  9.580831e-01, -5.911515e-01},
  { 5.068968e-01,  6.744576e-01, -5.368077e-01,  2.222492e-01,  1.081707e+00, -5.331305e-01},
  { 5.375575e-01,  6.568359e-01, -5.287709e-01,  2.009202e-01,  1.118794e+00, -5.043748e-01},
  { 3.725021e-01, -2.695301e-02, -9.276398e-01,  2.842521e-01, -6.366625e-01, -5.789371e-01},
  { 2.326375e-01,  6.602044e-01, -7.141498e-01,  2.659868e-01, -4.141395e-01, -5.549532e-01},
  { 5.709063e-01,  2.830375e-01, -7.706852e-01,  2.607860e-01, -4.017772e-01, -5.481575e-01},
  { 3.645768e-01, -5.932979e-01, -7.176917e-01,  2.625077e-01, -3.894148e-01, -5.504202e-01},
  { 3.258885e-01, -5.397061e-01, -7.762178e-01,  2.838752e-01, -3.523277e-01, -5.783980e-01},
  { 2.721213e-01,  7.319484e-02, -9.594751e-01,  2.927796e-01, -3.028781e-01, -5.901337e-01},
  {-2.420192e-01, -7.280943e-01, -6.413309e-01,  2.867611e-01, -5.563052e-02, -5.822964e-01},
  {-1.364678e-01, -7.949846e-01, -5.910804e-01,  3.233694e-01, -3.090557e-02, -6.299256e-01},
  {-2.631906e-01, -4.718431e-01, -8.414838e-01,  3.359420e-01, -1.854320e-02, -6.469348e-01},
  {-8.633206e-02,  3.851979e-01, -9.187869e-01,  3.385095e-01,  3.090626e-02, -6.500206e-01},
  {-2.499919e-01,  5.088964e-01, -8.237285e-01,  3.201858e-01,  6.799346e-02, -6.259775e-01},
  { 2.049755e-02,  2.841630e-01, -9.585569e-01,  2.628794e-01,  1.668925e-01, -5.507580e-01},
  { 8.153964e-02, -3.742610e-01, -9.237316e-01,  1.432846e-01,  5.872122e-01, -3.935511e-01},
  {-1.649122e-02, -7.831928e-01, -6.215603e-01,  1.730221e-01,  6.490240e-01, -4.325585e-01},
  { 7.953757e-02, -9.480928e-01, -3.078858e-01,  2.044859e-01,  6.737487e-01, -4.739033e-01},
  { 4.961582e-01, -6.776073e-01, -5.428401e-01,  2.503475e-01,  7.231982e-01, -5.343605e-01},
  { 5.168151e-01,  7.085761e-01, -4.804394e-01,  2.146852e-01,  1.118794e+00, -4.876800e-01},
  { 2.457094e-01, -3.962582e-01, -8.846503e-01,  3.684644e-01, -1.081707e+00, -6.503705e-01},
  { 3.045196e-01,  4.850007e-01, -8.197817e-01,  3.633544e-01, -8.468216e-01, -6.438764e-01},
  { 2.138374e-01,  8.701186e-02, -9.729863e-01,  3.127857e-01, -4.883140e-01, -5.790328e-01},
  { 1.432557e-01,  4.965280e-01, -8.561179e-01,  3.035582e-01, -4.388643e-01, -5.672415e-01},
  { 1.105396e-01,  7.433657e-01, -6.596881e-01,  2.906402e-01, -4.141395e-01, -5.507164e-01},
  { 2.007572e-01,  6.439299e-01, -7.382755e-01,  2.756468e-01, -4.017772e-01, -5.315557e-01},
  { 4.857013e-01, -3.906685e-01, -7.819670e-01,  2.710831e-01, -3.894148e-01, -5.257081e-01},
  { 3.474242e-01, -8.466726e-01, -4.030410e-01,  2.875416e-01, -3.770525e-01, -5.466985e-01},
  { 4.234324e-01, -4.198714e-01, -8.027534e-01,  3.093452e-01, -3.399654e-01, -5.746492e-01},
  { 4.483231e-01, -1.341617e-01, -8.837461e-01,  3.149436e-01, -3.152404e-01, -5.818391e-01},
  { 2.248320e-02, -6.839753e-01, -7.291586e-01,  2.916534e-01, -6.799289e-02, -5.517814e-01},
  { 2.629000e-02,  6.863849e-01, -7.267631e-01,  3.323761e-01,  9.271819e-02, -6.040945e-01},
  {-4.125497e-02,  4.790860e-01, -8.767979e-01,  2.965685e-01,  1.421678e-01, -5.581976e-01},
  {-9.090227e-02,  4.525580e-01, -8.870897e-01,  2.777928e-01,  2.163405e-01, -5.341705e-01},
  { 1.740556e-02,  5.403160e-01, -8.412822e-01,  2.704962e-01,  2.287029e-01, -5.248513e-01},
  { 4.287751e-02,  4.520426e-01, -8.909652e-01,  2.189106e-01,  3.894139e-01, -4.587412e-01},
  {-7.694070e-02,  2.270240e-01, -9.708451e-01,  1.649162e-01,  5.254002e-01, -3.894984e-01},
  {-6.272840e-02, -2.344207e-02, -9.977552e-01,  1.623149e-01,  5.501251e-01, -3.861584e-01},
  {-5.261983e-02, -6.673422e-01, -7.428899e-01,  1.890900e-01,  6.366616e-01, -4.204131e-01},
  { 2.993612e-01, -8.013784e-01, -5.178567e-01,  2.513185e-01,  6.984736e-01, -5.002543e-01},
  { 3.808911e-01, -7.494316e-01, -5.415482e-01,  2.604388e-01,  7.108357e-01, -5.119750e-01},
  { 8.081806e-01,  1.649766e-01, -5.653555e-01,  2.962204e-01,  9.457207e-01, -5.579953e-01},
  { 5.863291e-01,  6.170183e-01, -5.248873e-01,  2.160574e-01,  1.143519e+00, -4.552962e-01},
  { 2.732236e-01, -7.812744e-01, -5.612122e-01,  3.138240e-01, -1.205331e+00, -5.442413e-01},
  { 2.711779e-01, -6.777755e-01, -6.834347e-01,  3.634641e-01, -1.143519e+00, -6.061236e-01},
  { 3.415130e-01, -1.662122e-01, -9.250634e-01,  4.074329e-01, -9.951702e-01, -6.611023e-01},
  { 2.526005e-01, -4.917932e-02, -9.663200e-01,  3.264134e-01, -5.995755e-01, -5.599079e-01},
  { 9.134341e-02, -1.082656e-01, -9.899166e-01,  3.281515e-01, -5.748505e-01, -5.620610e-01},
  { 1.700445e-01, -1.133955e-01, -9.788904e-01,  3.342442e-01, -5.254011e-01, -5.696531e-01},
  { 2.345272e-01,  4.834850e-01, -8.433501e-01,  3.274441e-01, -4.388643e-01, -5.612000e-01},
  { 1.026480e-01,  6.011015e-01, -7.925531e-01,  3.060454e-01, -4.017772e-01, -5.344595e-01},
  { 9.275202e-02, -8.149338e-02, -9.923487e-01,  3.017733e-01, -3.894148e-01, -5.291847e-01},
  { 2.010287e-01, -7.195230e-01, -6.647363e-01,  3.089019e-01, -3.770525e-01, -5.379609e-01},
  { 4.031848e-01, -6.267802e-01, -6.667749e-01,  3.242958e-01, -3.523277e-01, -5.572363e-01},
  { 4.703211e-01,  1.121969e-01, -8.753343e-01,  3.360656e-01, -3.028781e-01, -5.719863e-01},
  { 5.412198e-01,  1.571991e-01, -8.260567e-01,  3.272944e-01, -2.410662e-01, -5.610328e-01},
  { 1.709376e-01, -1.346440e-02, -9.851899e-01,  3.139798e-01, -9.271762e-02, -5.442767e-01},
  {-8.553321e-02,  6.976860e-01, -7.112792e-01,  3.393413e-01,  1.174429e-01, -5.759959e-01},
  { 3.766330e-02,  5.391589e-01, -8.413615e-01,  3.315136e-01,  1.298054e-01, -5.661975e-01},
  { 3.489079e-02,  4.903225e-01, -8.708423e-01,  2.684637e-01,  2.781524e-01, -4.874486e-01},
  {-2.298769e-02, -4.603929e-01, -8.874176e-01,  1.959602e-01,  5.995746e-01, -3.967523e-01},
  { 2.204567e-01, -8.779352e-01, -4.250045e-01,  2.481737e-01,  6.737487e-01, -4.620357e-01},
  { 3.588466e-01, -7.534183e-01, -5.509900e-01,  2.601364e-01,  6.861111e-01, -4.770272e-01},
  { 7.137650e-01,  4.907360e-01, -4.997177e-01,  2.985493e-01,  9.951702e-01, -5.252498e-01},
  { 5.424442e-01,  1.496331e-01, -8.266585e-01,  3.477252e-01, -7.108354e-01, -5.504270e-01},
  { 5.624784e-01, -6.528945e-02, -8.242301e-01,  3.451206e-01, -6.366625e-01, -5.472042e-01},
  { 3.335409e-01,  2.597755e-01, -9.062379e-01,  3.572723e-01, -4.635892e-01, -5.619808e-01},
  { 3.736452e-01,  3.952195e-01, -8.391607e-01,  3.254173e-01, -3.894148e-01, -5.232293e-01},
  { 4.234630e-01, -5.865469e-01, -6.903925e-01,  3.294793e-01, -3.770525e-01, -5.280958e-01},
  { 5.141350e-01, -4.712229e-01, -7.166688e-01,  3.494228e-01, -3.399654e-01, -5.524136e-01},
  { 5.301973e-01, -5.027699e-02, -8.463823e-01,  3.557090e-01, -3.152404e-01, -5.601012e-01},
  { 4.294363e-01,  1.085995e-01, -8.965437e-01,  3.424273e-01, -1.916168e-01, -5.439152e-01},
  { 3.382203e-01,  5.595028e-02, -9.394022e-01,  3.379600e-01, -1.298047e-01, -5.384030e-01},
  { 1.459097e-01, -1.128126e-01, -9.828447e-01,  3.379426e-01, -1.174423e-01, -5.383675e-01},
  { 1.242403e-01, -4.920017e-01, -8.616836e-01,  3.463774e-01, -6.799289e-02, -5.485999e-01},
  {-7.766444e-02,  1.908873e-01, -9.785348e-01,  4.391002e-01,  6.181527e-03, -6.615204e-01},
  { 3.266914e-02,  2.835120e-01, -9.584121e-01,  2.187824e-01,  5.130381e-01, -3.931631e-01},
  {-6.999294e-02, -2.704528e-01, -9.601855e-01,  2.198491e-01,  5.872122e-01, -3.943378e-01},
  { 1.249735e-01, -7.138581e-01, -6.890488e-01,  2.583131e-01,  6.613864e-01, -4.412817e-01},
  { 4.146508e-01, -6.936564e-01, -5.889869e-01,  2.948112e-01,  7.108357e-01, -4.858822e-01},
  { 5.195944e-01, -5.825447e-01, -6.250307e-01,  3.067368e-01,  7.355605e-01, -5.004428e-01},
  { 8.033746e-01,  5.884084e-02, -5.925597e-01,  3.287336e-01,  8.715466e-01, -5.273120e-01},
  { 7.938163e-01,  3.954698e-01, -4.620166e-01,  3.116545e-01,  9.951702e-01, -5.065666e-01},
  { 3.723872e-01, -3.446280e-01, -8.617188e-01,  4.484429e-01, -1.032257e+00, -6.349087e-01},
  { 7.009293e-01,  2.362558e-01, -6.729645e-01,  3.631230e-01, -6.984744e-01, -5.336082e-01},
  { 4.074708e-01,  2.206812e-02, -9.129516e-01,  3.818890e-01, -5.006763e-01, -5.558230e-01},
  { 3.973527e-01,  3.878215e-01, -8.316882e-01,  3.767935e-01, -4.512267e-01, -5.497970e-01},
  { 5.731921e-01,  7.786392e-03, -8.193840e-01,  3.752103e-01, -3.028781e-01, -5.479360e-01},
  { 5.177274e-01,  4.066419e-02, -8.545787e-01,  3.626375e-01, -2.039791e-01, -5.329849e-01},
  { 1.084936e-01, -3.210517e-01, -9.408268e-01,  3.671513e-01, -8.035525e-02, -5.383758e-01},
  {-1.061744e-01, -7.906972e-01, -6.029302e-01,  3.704943e-01, -6.799289e-02, -5.423489e-01},
  {-1.178349e-01, -8.490852e-01, -5.149459e-01,  4.454352e-01, -4.326793e-02, -6.309546e-01},
  {-2.461855e-01,  3.892339e-01, -8.876315e-01,  3.823209e-01,  1.545301e-01, -5.561885e-01},
  {-2.415934e-01,  3.366387e-01, -9.101137e-01,  3.717121e-01,  2.039797e-01, -5.436229e-01},
  {-1.078893e-01,  3.922212e-01, -9.135220e-01,  3.670661e-01,  2.163405e-01, -5.381102e-01},
  {-1.076760e-01,  3.131461e-01, -9.435812e-01,  3.072130e-01,  3.276020e-01, -4.669346e-01},
  {-1.508549e-01,  3.351790e-01, -9.299989e-01,  2.821074e-01,  4.265016e-01, -4.371524e-01},
  {-1.874977e-01,  2.278128e-01, -9.554821e-01,  2.482889e-01,  5.006756e-01, -3.969019e-01},
  {-1.530046e-01,  5.277871e-02, -9.868151e-01,  2.431702e-01,  5.254002e-01, -3.907838e-01},
  { 2.894925e-02, -3.620624e-01, -9.317042e-01,  2.683412e-01,  6.366616e-01, -4.207420e-01},
  { 1.915456e-01, -6.151662e-01, -7.647750e-01,  2.739712e-01,  6.490240e-01, -4.274603e-01},
  { 7.079884e-01, -2.267802e-01, -6.688223e-01,  3.380897e-01,  7.973725e-01, -5.038656e-01},
  { 4.223493e-01, -4.978134e-01, -7.574978e-01,  4.505885e-01, -1.094069e+00, -6.003641e-01},
  { 4.931092e-01,  5.598570e-01, -6.658855e-01,  3.894946e-01, -7.355601e-01, -5.296284e-01},
  { 7.571855e-01,  3.147247e-01, -5.723796e-01,  3.838041e-01, -7.231978e-01, -5.230539e-01},
  { 4.907180e-01, -1.473633e-01, -8.587666e-01,  4.017348e-01, -5.130387e-01, -5.437312e-01},
  { 4.809396e-01,  2.706005e-01, -8.339499e-01,  4.005893e-01, -4.635892e-01, -5.424293e-01},
  { 6.320869e-01, -6.688748e-02, -7.720054e-01,  3.924747e-01, -3.152404e-01, -5.330332e-01},
  { 5.725729e-01, -3.026842e-02, -8.192948e-01,  3.816755e-01, -1.916168e-01, -5.204970e-01},
  { 2.205837e-01, -2.922188e-01, -9.305648e-01,  3.903691e-01, -9.271762e-02, -5.306127e-01},
  {-1.088827e-01, -6.635783e-01, -7.401407e-01,  3.918224e-01, -8.035525e-02, -5.322976e-01},
  {-1.855306e-01, -8.244089e-01, -5.347226e-01,  4.199230e-01, -6.799289e-02, -5.648734e-01},
  {-6.655948e-02, -7.728145e-01, -6.311319e-01,  4.864005e-01, -4.326793e-02, -6.414983e-01},
  { 7.011428e-04, -6.708996e-01, -7.415478e-01,  4.982177e-01, -3.090557e-02, -6.552919e-01},
  {-7.644500e-02, -2.552526e-01, -9.638476e-01,  5.039682e-01, -1.854320e-02, -6.620198e-01},
  {-8.188310e-02,  3.497153e-01, -9.332708e-01,  4.997496e-01,  3.090626e-02, -6.572165e-01},
  {-1.301972e-01,  4.306215e-01, -8.930922e-01,  3.764521e-01,  2.534277e-01, -5.142229e-01},
  {-1.683578e-01, -1.078805e-01, -9.798048e-01,  2.826500e-01,  5.624875e-01, -4.054271e-01},
  { 1.359014e-02, -2.046075e-01, -9.787498e-01,  2.890312e-01,  6.119370e-01, -4.129068e-01},
  { 3.371724e-01, -4.888979e-01, -8.045456e-01,  3.073103e-01,  6.737487e-01, -4.342212e-01},
  { 7.449553e-01, -3.623580e-01, -5.601234e-01,  3.443657e-01,  7.602853e-01, -4.772966e-01},
  { 8.279655e-01, -1.143876e-01, -5.489886e-01,  3.533571e-01,  8.097348e-01, -4.877481e-01},
  { 8.145131e-01,  3.068763e-01, -4.923366e-01,  3.292608e-01,  1.007533e+00, -4.599028e-01},
  { 3.360865e-01,  1.776424e-01, -9.249265e-01,  4.978602e-01, -9.209958e-01, -6.177542e-01},
  { 7.820988e-01,  1.626694e-01, -6.015481e-01,  3.947075e-01, -6.984744e-01, -5.011796e-01},
  { 7.108005e-01, -5.575700e-02, -7.011802e-01,  3.950645e-01, -6.737497e-01, -5.015601e-01},
  { 5.504214e-01,  5.554012e-02, -8.330376e-01,  4.227810e-01, -5.006763e-01, -5.328599e-01},
  { 4.887194e-01,  4.698040e-01, -7.351445e-01,  4.178148e-01, -4.512267e-01, -5.272785e-01},
  { 4.468850e-01, -2.434016e-01, -8.608423e-01,  4.036316e-01, -1.668918e-01, -5.111667e-01},
  { 3.266222e-01, -2.248801e-01, -9.180125e-01,  4.079357e-01, -1.421671e-01, -5.159985e-01},
  {-1.310104e-01, -8.143327e-01, -5.654189e-01,  4.393703e-01, -8.035525e-02, -5.516636e-01},
  {-1.576009e-01, -8.207963e-01, -5.490496e-01,  5.109708e-01, -5.563052e-02, -6.321552e-01},
  { 2.345504e-03, -3.826056e-01, -9.239087e-01,  5.414258e-01, -6.180837e-03, -6.668136e-01},
  { 4.486398e-02,  2.946609e-01, -9.545482e-01,  5.396633e-01,  1.854389e-02, -6.648496e-01},
  {-2.351569e-01,  2.806748e-01, -9.305498e-01,  3.841374e-01,  3.523267e-01, -4.887845e-01},
  { 1.535039e-01, -1.616250e-01, -9.748405e-01,  3.187416e-01,  6.242992e-01, -4.150778e-01},
  { 5.009860e-01, -6.330778e-01, -5.901064e-01,  4.814747e-01, -1.106432e+00, -5.632854e-01},
  { 4.791532e-01, -2.479947e-01, -8.419684e-01,  5.169986e-01, -1.007533e+00, -6.024704e-01},
  { 4.773499e-01,  1.025919e-01, -8.727037e-01,  5.211474e-01, -9.209958e-01, -6.070571e-01},
  { 3.736451e-01,  3.235039e-01, -8.693300e-01,  5.145258e-01, -8.839087e-01, -5.997671e-01},
  { 3.360332e-01,  4.099862e-01, -8.479345e-01,  5.106323e-01, -8.715463e-01, -5.954777e-01},
  { 2.762085e-01,  7.635338e-01, -5.837166e-01,  4.478915e-01, -7.479225e-01, -5.262771e-01},
  { 5.584252e-01,  5.977111e-01, -5.752414e-01,  4.112756e-01, -7.108354e-01, -4.859307e-01},
  { 7.305005e-01,  1.510824e-01, -6.659903e-01,  4.275589e-01, -2.905157e-01, -5.038701e-01},
  { 6.413745e-01,  2.695974e-02, -7.667542e-01,  4.181326e-01, -2.163415e-01, -4.934559e-01},
  { 2.055897e-01, -3.407446e-01, -9.174017e-01,  4.383441e-01, -1.174423e-01, -5.156268e-01},
  { 2.859000e-02, -3.657514e-01, -9.302734e-01,  4.409964e-01, -1.050800e-01, -5.186825e-01},
  {-2.652958e-01, -5.255303e-01, -8.083539e-01,  4.423248e-01, -9.271762e-02, -5.201482e-01},
  {-1.610777e-01, -8.704067e-01, -4.652376e-01,  4.646576e-01, -8.035525e-02, -5.447881e-01},
  {-1.819379e-01, -8.658332e-01, -4.660811e-01,  5.167950e-01, -6.799289e-02, -6.023118e-01},
  { 2.668214e-01,  1.270626e-01, -9.553331e-01,  5.751101e-01, -1.854320e-02, -6.663690e-01},
  {-1.511645e-01,  4.439061e-01, -8.832307e-01,  5.293549e-01,  9.271819e-02, -6.158013e-01},
  {-6.494383e-02,  3.266808e-01, -9.429008e-01,  3.994845e-01,  4.265016e-01, -4.725408e-01},
  {-3.262192e-02,  1.098140e-01, -9.934167e-01,  3.472949e-01,  5.872122e-01, -4.151248e-01},
  { 2.918234e-01, -1.100616e-01, -9.501187e-01,  3.447126e-01,  6.490240e-01, -4.123424e-01},
  { 8.454466e-01,  5.933660e-02, -5.307533e-01,  3.796982e-01,  8.715466e-01, -4.511158e-01},
  { 5.557103e-01,  6.985635e-01, -4.507718e-01,  2.707193e-01,  1.205330e+00, -3.308141e-01},
  { 5.469876e-01, -2.162265e-01, -8.087341e-01,  5.442023e-01, -9.704455e-01, -5.958340e-01},
  { 4.810391e-01,  2.816019e-01, -8.302420e-01,  5.365294e-01, -8.839087e-01, -5.876073e-01},
  { 2.047747e-01,  8.065743e-01, -5.545315e-01,  4.586105e-01, -7.355601e-01, -5.037696e-01},
  { 2.692499e-01,  8.702281e-01, -4.125622e-01,  4.374177e-01, -7.231978e-01, -4.809860e-01},
  { 6.275154e-01,  5.736957e-01, -5.264007e-01,  4.266775e-01, -7.108354e-01, -4.694226e-01},
  { 6.049669e-01, -8.259796e-02, -7.919549e-01,  4.612652e-01, -5.006763e-01, -5.065879e-01},
  { 5.538925e-01,  4.430146e-01, -7.049406e-01,  4.553677e-01, -4.512267e-01, -5.002733e-01},
  { 8.211026e-01, -5.272361e-02, -5.683403e-01,  4.342752e-01, -2.410662e-01, -4.776029e-01},
  { 5.585688e-01, -3.003126e-01, -7.731839e-01,  4.375365e-01, -1.916168e-01, -4.810399e-01},
  { 1.405843e-01, -5.384815e-01, -8.308271e-01,  4.627033e-01, -1.174423e-01, -5.081597e-01},
  {-9.855019e-02, -7.379149e-01, -6.676598e-01,  4.704441e-01, -1.050800e-01, -5.164922e-01},
  {-2.728524e-01, -7.828349e-01, -5.592148e-01,  5.219374e-01, -9.271762e-02, -5.719228e-01},
  {-3.054252e-01, -7.306318e-01, -6.106492e-01,  5.544043e-01, -8.035525e-02, -6.062109e-01},
  {-1.876843e-01, -7.210830e-01, -6.669437e-01,  5.833592e-01, -6.799289e-02, -6.380410e-01},
  {-1.239596e-01, -6.435450e-01, -7.553038e-01,  5.935399e-01, -5.563052e-02, -6.490002e-01},
  {-2.650690e-02, -3.330429e-01, -9.425390e-01,  6.017584e-01, -4.326793e-02, -6.575400e-01},
  {-1.072114e-01,  1.427266e-01, -9.839385e-01,  6.151398e-01,  1.854389e-02, -6.720027e-01},
  { 2.396163e-01,  2.886595e-01, -9.269626e-01,  3.787467e-01,  5.624875e-01, -4.176422e-01},
  { 3.443141e-01,  1.763849e-02, -9.386888e-01,  3.672559e-01,  6.366616e-01, -4.053284e-01},
  { 5.028027e-01, -2.331091e-01, -8.323758e-01,  3.758558e-01,  7.108357e-01, -4.146353e-01},
  { 5.130861e-01, -3.093702e-01, -8.006452e-01,  3.785145e-01,  7.231982e-01, -4.175095e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  2.809623e-01,  1.205330e+00, -3.125224e-01},
  { 4.633404e-01, -7.260594e-01, -5.080881e-01,  4.454701e-01, -1.205331e+00, -4.564857e-01},
  { 5.371836e-01, -5.034761e-01, -6.767168e-01,  5.447675e-01, -1.056982e+00, -5.607144e-01},
  { 5.243834e-01,  2.414059e-01, -8.165447e-01,  5.626797e-01, -9.086334e-01, -5.795752e-01},
  { 3.461047e-01,  7.288477e-01, -5.907559e-01,  4.817558e-01, -7.355601e-01, -4.946116e-01},
  { 5.347799e-01,  5.787552e-01, -6.156726e-01,  4.403554e-01, -7.108354e-01, -4.511137e-01},
  { 7.162186e-01,  9.844485e-02, -6.908976e-01,  4.790111e-01, -4.883140e-01, -4.917124e-01},
  { 6.368212e-01,  2.338628e-01, -7.346884e-01,  4.759831e-01, -4.635892e-01, -4.885471e-01},
  { 6.819354e-01, -2.232460e-01, -6.965092e-01,  4.602652e-01, -3.152404e-01, -4.720309e-01},
  { 7.859190e-01,  2.973303e-01, -5.421495e-01,  4.583149e-01, -2.905157e-01, -4.700349e-01},
  { 8.423104e-01,  1.019998e-01, -5.292535e-01,  4.465232e-01, -2.410662e-01, -4.576619e-01},
  { 8.280020e-01, -2.642716e-01, -4.945434e-01,  4.503732e-01, -2.039791e-01, -4.616479e-01},
  { 6.918631e-01, -4.637308e-01, -5.534250e-01,  4.537413e-01, -1.916168e-01, -4.651535e-01},
  { 3.189243e-01, -6.257976e-01, -7.118037e-01,  4.730166e-01, -1.545294e-01, -4.852975e-01},
  {-3.545758e-02, -5.575215e-01, -8.294049e-01,  4.791418e-01, -1.421671e-01, -4.918514e-01},
  {-1.820561e-01, -5.144114e-01, -8.379955e-01,  4.850237e-01, -1.298047e-01, -4.980292e-01},
  {-2.801624e-01, -6.359481e-01, -7.190821e-01,  4.908203e-01, -1.174423e-01, -5.041173e-01},
  {-2.706360e-01, -7.876277e-01, -5.535330e-01,  5.350621e-01, -1.050800e-01, -5.505853e-01},
  {-2.255108e-01, -8.074597e-01, -5.451182e-01,  5.788094e-01, -9.271762e-02, -5.959521e-01},
  {-1.427223e-01, -7.777024e-01, -6.122167e-01,  6.057925e-01, -8.035525e-02, -6.243773e-01},
  {-8.260090e-02, -7.101517e-01, -6.991864e-01,  6.210753e-01, -6.799289e-02, -6.405422e-01},
  { 3.922730e-03, -4.469538e-01, -8.945485e-01,  6.453392e-01, -3.090557e-02, -6.661373e-01},
  { 5.070832e-02, -4.116971e-02, -9.978646e-01,  6.520519e-01,  6.181527e-03, -6.732427e-01},
  {-6.467794e-02,  2.679130e-01, -9.612697e-01,  6.440076e-01,  5.563099e-02, -6.647878e-01},
  {-1.401152e-01,  3.721018e-01, -9.175555e-01,  5.246390e-01,  2.905149e-01, -5.393916e-01},
  {-4.753825e-02,  3.846551e-01, -9.218354e-01,  5.059778e-01,  3.523267e-01, -5.198409e-01},
  { 1.142370e-01,  4.798213e-01, -8.698974e-01,  4.605919e-01,  4.512262e-01, -4.722195e-01},
  { 3.037499e-01,  3.910628e-01, -8.687956e-01,  3.994491e-01,  5.748498e-01, -4.080859e-01},
  { 4.533507e-01,  1.387340e-01, -8.804692e-01,  3.893626e-01,  6.242992e-01, -3.975055e-01},
  { 3.950582e-01, -2.781198e-01, -8.755447e-01,  3.906440e-01,  6.984736e-01, -3.988668e-01},
  { 8.177003e-01,  6.287765e-03, -5.756098e-01,  4.054193e-01,  8.344595e-01, -4.144602e-01},
  { 5.770913e-01, -7.265888e-01, -3.728731e-01,  4.702739e-01, -1.192968e+00, -4.496161e-01},
  { 5.751978e-01, -7.636982e-01, -2.931084e-01,  4.586304e-01, -1.205331e+00, -4.377416e-01},
  { 5.951931e-01, -9.096232e-02, -7.984179e-01,  5.841281e-01, -9.704455e-01, -5.662903e-01},
  { 5.952914e-01,  4.347105e-01, -6.757625e-01,  5.726637e-01, -8.715463e-01, -5.545720e-01},
  { 4.594230e-01,  5.938233e-01, -6.605334e-01,  5.465345e-01, -8.097343e-01, -5.278090e-01},
  { 2.372027e-01,  8.453094e-01, -4.787346e-01,  4.895958e-01, -7.231978e-01, -4.694799e-01},
  { 4.928002e-01,  6.917786e-01, -5.278165e-01,  4.547949e-01, -6.984744e-01, -4.337621e-01},
  { 7.259067e-01, -8.858760e-02, -6.820643e-01,  4.946069e-01, -5.130387e-01, -4.745579e-01},
  { 7.087249e-01,  3.157949e-01, -6.308585e-01,  4.889685e-01, -4.512267e-01, -4.688307e-01},
  { 6.802325e-01,  3.608093e-02, -7.321079e-01,  4.477858e-01, -3.894148e-01, -4.266105e-01},
  { 6.439072e-01, -4.309565e-01, -6.321868e-01,  4.697046e-01, -3.399654e-01, -4.490110e-01},
  { 8.664681e-01,  8.299708e-02, -4.922849e-01,  4.582944e-01, -2.534286e-01, -4.374312e-01},
  { 4.119190e-01, -7.138299e-01, -5.663652e-01,  4.846234e-01, -1.668918e-01, -4.642420e-01},
  { 2.053519e-01, -8.189892e-01, -5.358055e-01,  4.923515e-01, -1.545294e-01, -4.722512e-01},
  { 3.107457e-03, -8.607817e-01, -5.089650e-01,  5.123671e-01, -1.421671e-01, -4.924723e-01},
  {-1.976224e-01, -8.258818e-01, -5.280765e-01,  5.386280e-01, -1.298047e-01, -5.196769e-01},
  {-3.584693e-01, -6.352096e-01, -6.841115e-01,  5.938835e-01, -1.174423e-01, -5.763043e-01},
  {-2.927878e-01, -6.795079e-01, -6.727141e-01,  6.146439e-01, -1.050800e-01, -5.969986e-01},
  {-1.458499e-01, -6.780607e-01, -7.203898e-01,  6.399875e-01, -9.271762e-02, -6.235529e-01},
  {-8.528573e-02, -6.503077e-01, -7.548684e-01,  6.484505e-01, -8.035525e-02, -6.318474e-01},
  { 4.219378e-02, -5.972298e-01, -8.009595e-01,  6.700942e-01, -5.563052e-02, -6.541293e-01},
  { 2.593146e-01,  4.359998e-01, -8.617773e-01,  6.736654e-01,  6.799346e-02, -6.579307e-01},
  { 9.736983e-02,  4.715375e-01, -8.764539e-01,  5.682037e-01,  2.657900e-01, -5.497776e-01},
  { 1.160621e-02,  4.330056e-01, -9.013165e-01,  5.517681e-01,  3.152396e-01, -5.329790e-01},
  { 2.392137e-01,  5.729374e-01, -7.839130e-01,  5.197763e-01,  3.894139e-01, -5.002612e-01},
  { 5.497303e-01,  2.848734e-01, -7.852666e-01,  4.124112e-01,  5.995746e-01, -3.903132e-01},
  { 5.512165e-01, -8.367994e-02, -8.301554e-01,  4.059558e-01,  6.737487e-01, -3.836801e-01},
  { 7.194017e-01, -7.121043e-02, -6.909343e-01,  4.153521e-01,  7.726477e-01, -3.933485e-01},
  { 7.904470e-01,  1.435426e-01, -5.954738e-01,  4.154574e-01,  8.839090e-01, -3.934854e-01},
  { 5.264009e-01, -7.398186e-01, -4.190116e-01,  5.079221e-01, -1.155881e+00, -4.551586e-01},
  { 5.595112e-01, -6.295716e-01, -5.390610e-01,  5.696066e-01, -1.081707e+00, -5.168124e-01},
  { 4.168983e-01,  8.020003e-01, -4.277748e-01,  5.194461e-01, -7.355601e-01, -4.667590e-01},
  { 7.442997e-01,  1.834925e-01, -6.421436e-01,  5.109786e-01, -4.883140e-01, -4.582571e-01},
  { 6.965654e-01,  5.390291e-01, -4.735444e-01,  4.980181e-01, -4.388643e-01, -4.453481e-01},
  { 6.148738e-01, -6.067683e-01, -5.037484e-01,  4.826730e-01, -1.916168e-01, -4.299076e-01},
  { 3.928994e-01, -8.531654e-01, -3.431309e-01,  5.017556e-01, -1.668918e-01, -4.489301e-01},
  { 1.071583e-01, -8.727530e-01, -4.762557e-01,  5.189594e-01, -1.545294e-01, -4.659480e-01},
  {-5.978955e-02, -9.100515e-01, -4.101602e-01,  5.407672e-01, -1.421671e-01, -4.880231e-01},
  {-1.082127e-01, -9.272464e-01, -3.584747e-01,  6.018711e-01, -1.298047e-01, -5.491257e-01},
  {-1.220612e-01, -8.322068e-01, -5.408632e-01,  6.563314e-01, -1.174423e-01, -6.035850e-01},
  {-7.655823e-02, -5.950738e-01, -8.000163e-01,  6.662094e-01, -1.050800e-01, -6.134628e-01},
  {-1.714614e-02, -6.346905e-01, -7.725762e-01,  6.748944e-01, -9.271762e-02, -6.218826e-01},
  { 2.849605e-01, -2.784094e-01, -9.172163e-01,  7.110970e-01, -3.090557e-02, -6.582213e-01},
  { 4.349646e-01,  1.589015e-01, -8.863160e-01,  7.124593e-01,  1.854389e-02, -6.596308e-01},
  { 4.059470e-01,  3.638485e-01, -8.383444e-01,  7.052774e-01,  5.563099e-02, -6.524643e-01},
  { 1.815090e-01,  5.303848e-01, -8.280981e-01,  5.641690e-01,  3.523267e-01, -5.113626e-01},
  { 6.580742e-01,  3.665906e-01, -6.576851e-01,  4.338734e-01,  5.872122e-01, -3.811532e-01},
  { 7.113011e-01,  1.367480e-01, -6.894569e-01,  4.221115e-01,  6.490240e-01, -3.693797e-01},
  { 6.591690e-01,  1.688211e-04, -7.519948e-01,  4.336576e-01,  8.220971e-01, -3.809194e-01},
  { 7.027109e-01,  1.291726e-01, -6.996513e-01,  4.311063e-01,  8.715466e-01, -3.783855e-01},
  { 5.661187e-01, -7.727862e-01, -2.868990e-01,  4.948471e-01, -1.192968e+00, -4.101862e-01},
  { 6.332835e-01, -7.553217e-01, -1.686448e-01,  4.831423e-01, -1.205331e+00, -3.987710e-01},
  { 5.241236e-01, -7.902822e-01, -3.174092e-01,  5.317912e-01, -1.143519e+00, -4.461849e-01},
  { 7.675058e-01, -1.131937e-01, -6.309691e-01,  6.176106e-01, -9.828078e-01, -5.299862e-01},
  { 7.648590e-01,  1.744705e-02, -6.439616e-01,  4.841907e-01, -6.984744e-01, -3.998323e-01},
  { 7.935766e-01, -7.880522e-04, -6.084698e-01,  5.256324e-01, -4.883140e-01, -4.402662e-01},
  { 7.789258e-01, -1.602544e-01, -6.062946e-01,  5.043203e-01, -3.276030e-01, -4.194444e-01},
  { 7.744923e-01,  8.223345e-02, -6.272156e-01,  5.044901e-01, -3.152404e-01, -4.196324e-01},
  { 6.114563e-01, -6.121492e-01, -5.013927e-01,  4.966141e-01, -1.916168e-01, -4.118909e-01},
  { 4.540851e-01, -7.018393e-01, -5.488428e-01,  5.060452e-01, -1.792542e-01, -4.210395e-01},
  { 2.248430e-01, -8.201906e-01, -5.260541e-01,  5.120760e-01, -1.668918e-01, -4.270026e-01},
  { 4.621004e-02, -9.476499e-01, -3.159498e-01,  5.393285e-01, -1.545294e-01, -4.535939e-01},
  {-6.662074e-02, -9.436163e-01, -3.242683e-01,  6.026787e-01, -1.421671e-01, -5.148051e-01},
  {-4.086549e-02, -9.324120e-01, -3.590792e-01,  6.541309e-01, -1.298047e-01, -5.651209e-01},
  { 1.677301e-01, -8.310602e-01, -5.302882e-01,  6.882441e-01, -1.174423e-01, -5.988957e-01},
  { 2.612938e-01, -6.020514e-01, -7.544929e-01,  7.229236e-01, -6.799289e-02, -6.326147e-01},
  { 5.254189e-01, -4.046269e-01, -7.484731e-01,  7.284705e-01, -5.563052e-02, -6.380519e-01},
  { 6.016011e-01, -8.706357e-02, -7.940379e-01,  7.363436e-01, -1.854320e-02, -6.457765e-01},
  { 5.846679e-01,  3.785241e-01, -7.175535e-01,  7.241846e-01,  6.799346e-02, -6.339603e-01},
  { 4.301251e-01,  4.979944e-01, -7.529901e-01,  6.794139e-01,  1.792549e-01, -5.902244e-01},
  { 4.050327e-01,  5.592562e-01, -7.233126e-01,  6.071759e-01,  3.152396e-01, -5.197660e-01},
  { 4.227441e-01,  7.435685e-01, -5.180669e-01,  5.866990e-01,  3.523267e-01, -4.998152e-01},
  { 5.221221e-01,  6.286126e-01, -5.763981e-01,  5.794736e-01,  3.646892e-01, -4.927758e-01},
  { 5.039583e-01,  6.392996e-01, -5.807944e-01,  5.297905e-01,  4.512262e-01, -4.443154e-01},
  { 6.374220e-01,  5.849933e-01, -5.014740e-01,  4.667684e-01,  5.501251e-01, -3.828859e-01},
  { 8.297934e-01,  3.525786e-01, -4.325867e-01,  4.433454e-01,  5.995746e-01, -3.600180e-01},
  { 8.637132e-01,  1.056827e-01, -4.927785e-01,  4.348691e-01,  6.613864e-01, -3.517226e-01},
  { 8.484672e-01, -1.547778e-01, -5.061099e-01,  4.353007e-01,  6.737487e-01, -3.521385e-01},
  { 8.357725e-01, -3.587418e-02, -5.479027e-01,  4.482238e-01,  8.344595e-01, -3.647290e-01},
  { 5.439389e-01,  7.607858e-01, -3.540273e-01,  3.315495e-01,  1.205330e+00, -2.508967e-01},
  { 5.025876e-01, -8.482787e-01, -1.668201e-01,  4.833523e-01, -1.205331e+00, -3.680914e-01},
  { 5.570319e-01, -7.406693e-01, -3.756657e-01,  5.739622e-01, -1.118794e+00, -4.543001e-01},
  { 7.153119e-01, -3.192629e-01, -6.216109e-01,  6.293270e-01, -1.007533e+00, -5.070792e-01},
  { 7.815334e-01,  1.611347e-01, -6.026949e-01,  6.315513e-01, -9.086334e-01, -5.092294e-01},
  { 5.227016e-01,  7.307540e-01, -4.390690e-01,  5.604861e-01, -7.479225e-01, -4.415930e-01},
  { 3.655564e-01,  8.944458e-01, -2.575565e-01,  5.186579e-01, -7.108354e-01, -4.018497e-01},
  { 8.168821e-01, -2.044230e-01, -5.393652e-01,  5.361463e-01, -5.254011e-01, -4.183814e-01},
  { 8.337365e-01,  1.697927e-01, -5.254083e-01,  5.391516e-01, -5.006763e-01, -4.212587e-01},
  { 7.700260e-01,  3.887953e-01, -5.058638e-01,  5.144765e-01, -3.028781e-01, -3.977865e-01},
  { 7.963677e-01,  2.647821e-01, -5.437729e-01,  4.940361e-01, -2.534286e-01, -3.782979e-01},
  { 7.628788e-01, -2.547985e-01, -5.942168e-01,  4.951079e-01, -2.287039e-01, -3.792917e-01},
  { 2.172318e-01, -9.267829e-01, -3.064047e-01,  5.461491e-01, -1.668918e-01, -4.276529e-01},
  { 3.067774e-02, -9.662594e-01, -2.557378e-01,  5.980764e-01, -1.545294e-01, -4.768819e-01},
  { 1.147478e-01, -9.663075e-01, -2.303965e-01,  6.901518e-01, -1.298047e-01, -5.646266e-01},
  { 2.496534e-01, -8.871220e-01, -3.881852e-01,  7.098114e-01, -1.174423e-01, -5.835242e-01},
  { 7.419364e-01, -5.981145e-02, -6.677970e-01,  7.554210e-01, -3.090557e-02, -6.270943e-01},
  { 3.939369e-01,  5.452994e-01, -7.399069e-01,  6.905577e-01,  2.039797e-01, -5.653592e-01},
  { 4.950781e-01,  7.805924e-01, -3.815406e-01,  6.044119e-01,  3.523267e-01, -4.834152e-01},
  { 6.311993e-01,  6.263262e-01, -4.574963e-01,  5.882876e-01,  3.770515e-01, -4.680756e-01},
  { 6.116387e-01,  6.214934e-01, -4.895345e-01,  5.516070e-01,  4.388637e-01, -4.331640e-01},
  { 9.047306e-01,  3.996652e-01, -1.474125e-01,  4.612969e-01,  5.748498e-01, -3.472565e-01},
  { 9.248728e-01,  1.136766e-01, -3.628885e-01,  4.435267e-01,  6.490240e-01, -3.302793e-01},
  { 3.869379e-01, -8.139912e-01, -4.332405e-01,  4.969566e-01, -1.205331e+00, -3.505579e-01},
  { 4.715029e-01,  7.883879e-01, -3.951322e-01,  5.529023e-01, -7.231978e-01, -4.026736e-01},
  { 8.597656e-01, -2.785760e-01, -4.280169e-01,  5.371497e-01, -5.748505e-01, -3.879164e-01},
  { 8.561432e-01,  9.773104e-02, -5.074126e-01,  5.503386e-01, -4.883140e-01, -4.002011e-01},
  { 7.697582e-01, -5.053229e-01, -3.900269e-01,  5.302436e-01, -3.276030e-01, -3.815142e-01},
  { 7.737515e-01,  1.441036e-01, -6.168815e-01,  5.098859e-01, -2.657909e-01, -3.625970e-01},
  { 6.983348e-01, -3.871645e-01, -6.020235e-01,  5.124244e-01, -2.163415e-01, -3.649162e-01},
  { 4.192247e-01, -8.621289e-01, -2.845775e-01,  7.118207e-01, -1.298047e-01, -5.500005e-01},
  { 4.737442e-01, -7.626906e-01, -4.403063e-01,  7.406299e-01, -1.050800e-01, -5.768547e-01},
  { 6.400869e-01, -4.937933e-01, -5.886059e-01,  7.622741e-01, -6.799289e-02, -5.969929e-01},
  { 6.875859e-01,  4.844446e-01, -5.408688e-01,  7.332367e-01,  1.421678e-01, -5.700879e-01},
  { 6.600133e-01,  5.433203e-01, -5.188308e-01,  7.090533e-01,  2.039797e-01, -5.476446e-01},
  { 7.207699e-01,  6.202290e-01, -3.095265e-01,  6.404809e-01,  3.152396e-01, -4.840043e-01},
  { 7.338114e-01,  6.565339e-01, -1.745970e-01,  5.446907e-01,  4.635885e-01, -3.950818e-01},
  { 9.909097e-01,  1.331234e-01, -1.939153e-02,  4.574115e-01,  5.872122e-01, -3.140388e-01},
  { 9.474493e-01, -2.418069e-01, -2.094500e-01,  4.539512e-01,  6.984736e-01, -3.106916e-01},
  { 4.850962e-01, -8.062546e-01, -3.385783e-01,  5.264472e-01, -1.192968e+00, -3.474461e-01},
  { 4.509556e-01, -8.278407e-01, -3.336447e-01,  5.158234e-01, -1.205331e+00, -3.378586e-01},
  { 7.871363e-01,  3.899581e-01, -4.778590e-01,  6.496691e-01, -8.715463e-01, -4.592252e-01},
  { 6.694103e-01,  5.467138e-01, -5.029848e-01,  6.318564e-01, -8.220969e-01, -4.430949e-01},
  { 5.510510e-01,  7.134109e-01, -4.328831e-01,  5.877047e-01, -7.479225e-01, -4.030951e-01},
  { 7.315536e-01,  4.338678e-01, -5.259164e-01,  5.575106e-01, -4.635892e-01, -3.757129e-01},
  { 8.308995e-01,  1.760809e-01, -5.278271e-01,  5.418673e-01, -3.152404e-01, -3.615108e-01},
  { 6.431342e-01,  2.647424e-01, -7.185331e-01,  5.255328e-01, -2.657909e-01, -3.466704e-01},
  { 7.120406e-01,  4.531334e-02, -7.006746e-01,  5.233920e-01, -2.534286e-01, -3.447174e-01},
  { 6.536514e-01, -7.023339e-01, -2.818991e-01,  5.400811e-01, -1.792542e-01, -3.598656e-01},
  { 6.816738e-01, -5.943290e-01, -4.267246e-01,  7.734695e-01, -8.035525e-02, -5.713570e-01},
  { 7.421064e-01,  3.322259e-01, -5.821546e-01,  7.801652e-01,  5.563099e-02, -5.774947e-01},
  { 7.379863e-01,  6.534571e-01, -1.684342e-01,  6.231722e-01,  3.523267e-01, -4.353487e-01},
  { 8.375247e-01,  5.463914e-01, -2.985349e-03,  5.975485e-01,  3.894139e-01, -4.121292e-01},
  { 7.805535e-01,  6.246149e-01, -2.433990e-02,  5.653528e-01,  4.388637e-01, -3.829570e-01},
  { 7.944555e-01,  6.044256e-01,  5.924763e-02,  5.560366e-01,  4.512262e-01, -3.745605e-01},
  { 8.488219e-01,  5.249250e-01,  6.288929e-02,  5.375155e-01,  4.759509e-01, -3.577614e-01},
  { 6.587762e-01,  7.490311e-01, -7.047161e-02,  5.162967e-01,  5.006756e-01, -3.385061e-01},
  { 7.547675e-01,  6.553574e-01,  2.885737e-02,  5.042804e-01,  5.130381e-01, -3.277088e-01},
  { 9.225146e-01,  3.087516e-01,  2.316014e-01,  4.586505e-01,  5.748498e-01, -2.863613e-01},
  { 9.759729e-01, -2.178001e-01,  6.323172e-03,  4.537310e-01,  6.737487e-01, -2.817003e-01},
  { 8.364031e-01,  7.704350e-02, -5.426731e-01,  4.784030e-01,  8.839090e-01, -3.039846e-01},
  { 4.416094e-01, -8.669850e-01, -2.309072e-01,  5.221662e-01, -1.205331e+00, -3.139070e-01},
  { 8.756781e-01, -1.772417e-01, -4.491917e-01,  6.737949e-01, -9.951702e-01, -4.480078e-01},
  { 7.678065e-01,  4.079188e-01, -4.940400e-01,  6.501011e-01, -8.344592e-01, -4.271095e-01},
  { 7.704579e-01,  5.475812e-01, -3.264194e-01,  6.313155e-01, -7.973719e-01, -4.105161e-01},
  { 6.471709e-01,  7.330226e-01, -2.093984e-01,  5.895562e-01, -7.355601e-01, -3.736441e-01},
  { 4.717708e-01,  8.641096e-01, -1.753484e-01,  5.756991e-01, -7.231978e-01, -3.614201e-01},
  { 8.114984e-01,  4.564179e-01, -3.649014e-01,  5.308807e-01, -6.984744e-01, -3.216920e-01},
  { 8.603823e-01, -2.210207e-01, -4.592301e-01,  5.710430e-01, -5.254011e-01, -3.571680e-01},
  { 8.738425e-01, -4.869187e-04, -4.862089e-01,  5.735487e-01, -4.883140e-01, -3.594023e-01},
  { 8.767656e-01,  2.962703e-01, -3.788221e-01,  5.717775e-01, -4.759516e-01, -3.578451e-01},
  { 6.917462e-01,  5.829119e-01, -4.262638e-01,  5.579511e-01, -4.388643e-01, -3.456518e-01},
  { 8.891786e-01, -1.598260e-01, -4.287389e-01,  5.235554e-01, -3.894148e-01, -3.151354e-01},
  { 8.835685e-01, -2.763612e-01, -3.780623e-01,  5.511916e-01, -3.276030e-01, -3.396156e-01},
  { 9.180094e-01, -6.847955e-02, -3.906012e-01,  5.523585e-01, -3.028781e-01, -3.406554e-01},
  { 7.424730e-01,  2.372867e-01, -6.264414e-01,  5.412533e-01, -2.657909e-01, -3.308051e-01},
  { 7.686917e-01, -1.193645e-01, -6.283830e-01,  5.400609e-01, -2.287039e-01, -3.297301e-01},
  { 4.761912e-01, -8.624538e-01,  1.715093e-01,  5.837227e-01, -1.545294e-01, -3.684797e-01},
  { 4.181896e-01, -8.846554e-01,  2.061611e-01,  7.370262e-01, -1.298047e-01, -5.038905e-01},
  { 6.817051e-01, -7.216864e-01,  1.201954e-01,  7.559189e-01, -1.174423e-01, -5.205961e-01},
  { 6.804306e-01, -7.321734e-01, -3.059974e-02,  7.649110e-01, -1.050800e-01, -5.286799e-01},
  { 6.325950e-01, -7.564021e-01, -1.663719e-01,  7.777054e-01, -9.271762e-02, -5.399368e-01},
  { 7.528137e-01, -6.017063e-01, -2.668727e-01,  7.872036e-01, -8.035525e-02, -5.483038e-01},
  { 8.300362e-01, -3.625318e-01, -4.238049e-01,  8.020734e-01, -4.326793e-02, -5.614460e-01},
  { 8.840045e-01, -1.888612e-02, -4.670968e-01,  8.081034e-01, -6.180837e-03, -5.667955e-01},
  { 8.230110e-01,  3.186133e-01, -4.702535e-01,  8.059470e-01,  1.854389e-02, -5.649037e-01},
  { 8.435194e-01,  4.688043e-01, -2.621021e-01,  7.639398e-01,  1.298054e-01, -5.278202e-01},
  { 8.090200e-01,  5.722833e-01, -1.340833e-01,  7.354078e-01,  1.916172e-01, -5.026511e-01},
  { 8.792946e-01,  4.662549e-01,  9.719765e-02,  6.325472e-01,  3.399643e-01, -4.117606e-01},
  { 7.867445e-01,  6.106198e-01,  9.042396e-02,  6.236513e-01,  3.523267e-01, -4.039137e-01},
  { 8.953905e-01,  4.153612e-01,  1.604709e-01,  5.975170e-01,  3.894139e-01, -3.808089e-01},
  { 7.822849e-01,  6.122577e-01,  1.147641e-01,  5.890635e-01,  4.017763e-01, -3.733598e-01},
  { 9.316780e-01,  2.433349e-01,  2.697484e-01,  5.722147e-01,  4.265016e-01, -3.584411e-01},
  { 7.728186e-01,  6.298488e-01,  7.772979e-02,  5.661569e-01,  4.388637e-01, -3.528046e-01},
  { 7.040002e-01,  6.871423e-01,  1.794970e-01,  5.515383e-01,  4.512262e-01, -3.402587e-01},
  { 7.877766e-01,  5.105378e-01,  3.446144e-01,  5.376006e-01,  4.635885e-01, -3.280819e-01},
  { 8.618066e-01,  1.988242e-01,  4.666459e-01,  5.251377e-01,  4.759504e-01, -3.170865e-01},
  { 8.774110e-01,  1.616959e-01,  4.516684e-01,  5.299457e-01,  4.883133e-01, -3.207858e-01},
  { 7.523861e-01,  5.938646e-01,  2.850263e-01,  5.206843e-01,  5.006756e-01, -3.125969e-01},
  { 6.783328e-01,  6.475469e-01,  3.471996e-01,  4.983650e-01,  5.130381e-01, -2.928615e-01},
  { 7.928381e-01,  3.562643e-01,  4.944528e-01,  4.693453e-01,  5.254002e-01, -2.678822e-01},
  { 8.816602e-01,  8.611197e-02,  4.639612e-01,  4.440752e-01,  5.624875e-01, -2.454501e-01},
  { 9.603822e-01, -6.855755e-02,  2.701218e-01,  4.414582e-01,  6.119370e-01, -2.428324e-01},
  { 7.828716e-01,  2.940765e-01, -5.482984e-01,  4.792634e-01,  9.580831e-01, -2.759969e-01},
  { 7.198969e-01,  5.121948e-01, -4.684069e-01,  4.193142e-01,  1.106431e+00, -2.230201e-01},
  { 7.159931e-01, -5.911002e-01, -3.714222e-01,  6.612740e-01, -1.069344e+00, -4.048739e-01},
  { 8.096552e-01, -4.611287e-01, -3.630686e-01,  6.723852e-01, -1.044620e+00, -4.144639e-01},
  { 8.963397e-01,  1.286215e-01, -4.243015e-01,  6.885549e-01, -9.580831e-01, -4.284301e-01},
  { 8.525662e-01,  3.642802e-01, -3.747409e-01,  6.742868e-01, -8.715463e-01, -4.161500e-01},
  { 7.868814e-01,  5.880836e-01, -1.870167e-01,  6.259282e-01, -7.726472e-01, -3.744975e-01},
  { 6.135158e-01,  7.892126e-01, -2.723710e-02,  5.563942e-01, -7.108354e-01, -3.143692e-01},
  { 6.481001e-01,  7.168621e-01, -2.570502e-01,  5.402914e-01, -6.984744e-01, -3.005617e-01},
  { 9.204941e-01, -3.221624e-01, -2.211380e-01,  5.771519e-01, -5.377634e-01, -3.323384e-01},
  { 9.417257e-01, -1.768045e-01, -2.861694e-01,  5.825271e-01, -5.130387e-01, -3.369836e-01},
  { 9.518806e-01,  1.023675e-01, -2.888673e-01,  5.834146e-01, -5.006763e-01, -3.377564e-01},
  { 8.690240e-01,  4.433031e-01, -2.197262e-01,  5.730198e-01, -4.512267e-01, -3.288261e-01},
  { 8.071626e-01,  4.538433e-01, -3.775113e-01,  5.340215e-01, -3.894148e-01, -2.950705e-01},
  { 8.902155e-01, -3.536057e-01, -2.871922e-01,  5.357130e-01, -3.770525e-01, -2.965750e-01},
  { 9.028291e-01,  3.356594e-02, -4.286876e-01,  5.629791e-01, -3.028781e-01, -3.201213e-01},
  { 8.665648e-01, -3.386243e-03, -4.990531e-01,  5.532424e-01, -2.287039e-01, -3.116886e-01},
  { 9.323778e-01, -3.517075e-01, -8.350741e-02,  5.644448e-01, -1.545294e-01, -3.213132e-01},
  { 7.509824e-01, -5.893959e-01,  2.977212e-01,  5.691251e-01, -1.421671e-01, -3.253506e-01},
  { 5.649660e-01, -6.903831e-01,  4.518679e-01,  6.322131e-01, -1.298047e-01, -3.803960e-01},
  { 6.205056e-01, -5.899609e-01,  5.166421e-01,  6.936447e-01, -1.174423e-01, -4.334927e-01},
  { 6.967776e-01, -5.501943e-01,  4.602035e-01,  7.436910e-01, -1.050800e-01, -4.764906e-01},
  { 6.757316e-01, -6.601095e-01,  3.280888e-01,  7.725487e-01, -9.271762e-02, -5.011826e-01},
  { 7.294407e-01, -6.794072e-01,  7.951106e-02,  7.912303e-01, -8.035525e-02, -5.171655e-01},
  { 8.243093e-01, -5.647077e-01, -4.024382e-02,  8.017012e-01, -6.799289e-02, -5.261276e-01},
  { 9.148478e-01, -3.911464e-01, -1.002901e-01,  8.080182e-01, -5.563052e-02, -5.315456e-01},
  { 9.826291e-01, -9.459072e-02, -1.596643e-01,  8.176200e-01, -6.180837e-03, -5.398389e-01},
  { 9.643161e-01,  2.056607e-01, -1.667280e-01,  8.157048e-01,  1.854389e-02, -5.382034e-01},
  { 8.922275e-01,  4.222036e-01, -1.602314e-01,  7.996449e-01,  6.799346e-02, -5.243698e-01},
  { 8.707934e-01,  4.472382e-01,  2.041982e-01,  7.276746e-01,  2.039797e-01, -4.624559e-01},
  { 7.900141e-01,  5.598488e-01,  2.498943e-01,  7.072195e-01,  2.287029e-01, -4.449047e-01},
  { 8.399534e-01,  4.647376e-01,  2.801737e-01,  6.594393e-01,  2.781524e-01, -4.037969e-01},
  { 8.953359e-01,  9.529330e-02,  4.350780e-01,  6.217283e-01,  3.399643e-01, -3.711342e-01},
  { 7.869671e-01,  5.458269e-01,  2.876731e-01,  6.200491e-01,  3.523267e-01, -3.692770e-01},
  { 7.815976e-01,  4.883268e-01,  3.881262e-01,  5.976447e-01,  3.646892e-01, -3.505346e-01},
  { 8.495428e-01,  7.023315e-02,  5.228235e-01,  5.798358e-01,  3.894139e-01, -3.351728e-01},
  { 7.953213e-01,  4.442396e-01,  4.124504e-01,  5.862558e-01,  4.017763e-01, -3.401272e-01},
  { 7.783490e-01,  3.468951e-01,  5.232940e-01,  5.524843e-01,  4.141386e-01, -3.118054e-01},
  { 8.056372e-01, -3.307061e-02,  5.914854e-01,  5.451352e-01,  4.265016e-01, -3.054460e-01},
  { 8.483756e-01,  1.896774e-01,  4.942483e-01,  5.644448e-01,  4.388637e-01, -3.213132e-01},
  { 6.574623e-01,  6.297753e-01,  4.136741e-01,  5.381403e-01,  4.512262e-01, -2.986235e-01},
  { 7.098549e-01,  4.768944e-01,  5.183413e-01,  4.968435e-01,  4.635885e-01, -2.638030e-01},
  { 7.628473e-01,  3.129277e-01,  5.658094e-01,  4.776732e-01,  4.759423e-01, -2.473051e-01},
  { 7.647299e-01,  2.802188e-01,  5.802289e-01,  4.605490e-01,  4.883041e-01, -2.325201e-01},
  { 7.280425e-01,  4.163937e-01,  5.445828e-01,  4.419894e-01,  5.006753e-01, -2.164383e-01},
  { 7.045237e-01,  5.529141e-01,  4.448959e-01,  4.070864e-01,  5.130381e-01, -1.855780e-01},
  { 8.280826e-01,  3.342392e-01,  4.500703e-01,  3.808756e-01,  5.254002e-01, -1.629690e-01},
  { 8.240456e-01, -1.393916e-01,  5.491074e-01,  3.962533e-01,  5.377627e-01, -1.768747e-01},
  { 8.650445e-01, -2.766500e-01,  4.185244e-01,  4.231528e-01,  6.119370e-01, -1.997780e-01},
  { 8.783048e-01, -4.133211e-01,  2.403048e-01,  4.391578e-01,  6.366616e-01, -2.134415e-01},
  { 9.428086e-01, -3.192041e-01,  9.602488e-02,  4.450186e-01,  6.490240e-01, -2.184564e-01},
  { 8.954718e-01, -3.498314e-01, -2.752237e-01,  4.830178e-01,  7.355605e-01, -2.511219e-01},
  { 7.154003e-01,  4.392386e-01, -5.433890e-01,  4.777637e-01,  1.007533e+00, -2.465803e-01},
  { 6.303582e-01, -7.724512e-01, -7.725196e-02,  5.599045e-01, -1.192968e+00, -2.881494e-01},
  { 7.033785e-01, -7.007555e-01,  1.191660e-01,  5.477927e-01, -1.205331e+00, -2.779528e-01},
  { 7.516458e-01, -6.589285e-01, -2.901103e-02,  6.431485e-01, -1.106432e+00, -3.582400e-01},
  { 8.171210e-01, -5.631106e-01, -1.233674e-01,  6.614741e-01, -1.081707e+00, -3.736710e-01},
  { 9.090315e-01,  3.577460e-01, -2.137280e-01,  6.782153e-01, -8.591840e-01, -3.878239e-01},
  { 8.072408e-01,  5.893962e-01, -3.121525e-02,  6.292169e-01, -7.726472e-01, -3.466858e-01},
  { 6.284820e-01,  7.765375e-01,  4.472109e-02,  5.939637e-01, -7.355601e-01, -3.170935e-01},
  { 9.002616e-01,  4.327221e-01, -4.775438e-02,  5.480765e-01, -7.108354e-01, -2.781917e-01},
  { 9.378886e-01,  3.253054e-01, -1.205875e-01,  5.479817e-01, -6.984744e-01, -2.781121e-01},
  { 9.772066e-01,  1.362533e-01, -1.627955e-01,  5.866038e-01, -4.759516e-01, -3.107363e-01},
  { 9.910678e-01,  3.826337e-03, -1.333039e-01,  5.383869e-01, -3.894148e-01, -2.701899e-01},
  { 8.892195e-01, -4.050270e-01, -2.127013e-01,  5.617562e-01, -3.399654e-01, -2.897702e-01},
  { 9.824903e-01,  4.052880e-02, -1.818521e-01,  5.625899e-01, -2.039791e-01, -2.905044e-01},
  { 9.903474e-01, -1.373255e-01, -1.880662e-02,  5.641288e-01, -1.668918e-01, -2.918331e-01},
  { 8.687903e-01, -4.166768e-01,  2.675519e-01,  5.732385e-01, -1.298047e-01, -2.993630e-01},
  { 7.371704e-01, -4.818334e-01,  4.737261e-01,  5.845895e-01, -1.174423e-01, -3.089143e-01},
  { 6.782279e-01, -6.397226e-01,  3.616102e-01,  7.892495e-01, -6.799289e-02, -4.815859e-01},
  { 8.090316e-01, -5.187925e-01,  2.762648e-01,  8.035828e-01, -5.563052e-02, -4.935215e-01},
  { 9.502065e-01, -2.541915e-01,  1.802619e-01,  8.116323e-01, -4.326793e-02, -5.002255e-01},
  { 9.766973e-01,  7.240638e-02,  2.020391e-01,  8.171573e-01,  6.181527e-03, -5.048661e-01},
  { 8.905620e-01,  3.937665e-01,  2.277002e-01,  8.043647e-01,  5.563099e-02, -4.941583e-01},
  { 7.817170e-01,  4.464934e-01,  4.353874e-01,  6.820030e-01,  2.287029e-01, -3.915913e-01},
  { 7.749497e-01,  4.572259e-01,  4.363455e-01,  6.441920e-01,  2.534277e-01, -3.598266e-01},
  { 7.897275e-01,  3.207608e-01,  5.229178e-01,  5.924756e-01,  3.152396e-01, -3.163849e-01},
  { 7.748655e-01, -5.768496e-02,  6.294885e-01,  5.791709e-01,  3.399643e-01, -3.051765e-01},
  { 7.789943e-01,  2.829482e-01,  5.595609e-01,  5.933870e-01,  3.523267e-01, -3.163162e-01},
  { 7.288597e-01,  4.076751e-01,  5.500588e-01,  5.321847e-01,  3.646892e-01, -2.648202e-01},
  { 7.077766e-01,  4.708595e-01,  5.266342e-01,  5.052255e-01,  4.017763e-01, -2.421366e-01},
  { 7.637115e-01,  4.592200e-01,  4.537199e-01,  4.351313e-01,  4.141386e-01, -1.831592e-01},
  { 8.116237e-01,  1.505447e-01,  5.644494e-01,  4.517764e-01,  4.265016e-01, -1.979083e-01},
  { 7.533269e-01,  4.373101e-01,  4.911806e-01,  4.284153e-01,  4.388637e-01, -1.775079e-01},
  { 8.031486e-01,  3.715949e-01,  4.656926e-01,  4.116663e-01,  4.512262e-01, -1.634152e-01},
  { 8.647028e-01,  3.910871e-01,  3.151823e-01,  3.964427e-01,  4.635885e-01, -1.506058e-01},
  { 8.491752e-01,  2.213786e-01,  4.794716e-01,  3.954021e-01,  4.759509e-01, -1.497303e-01},
  { 8.110877e-01,  1.892318e-01,  5.534691e-01,  4.011028e-01,  4.881068e-01, -1.552137e-01},
  { 8.054342e-01,  3.070719e-01,  5.069345e-01,  3.842009e-01,  5.130381e-01, -1.408125e-01},
  { 8.321924e-01,  3.912618e-01,  3.928995e-01,  3.805509e-01,  5.254002e-01, -1.372345e-01},
  { 8.968084e-01,  9.521615e-02,  4.320518e-01,  3.704749e-01,  5.377627e-01, -1.291554e-01},
  { 8.378823e-01, -2.632802e-01,  4.781596e-01,  3.716983e-01,  5.872122e-01, -1.301815e-01},
  { 7.847757e-01, -6.021445e-01, -1.467963e-01,  4.507756e-01,  6.613864e-01, -1.964178e-01},
  { 8.444801e-01, -3.831319e-01, -3.742503e-01,  4.956130e-01,  7.479229e-01, -2.340777e-01},
  { 8.782424e-01,  3.529467e-02, -4.769117e-01,  5.140717e-01,  8.715466e-01, -2.496258e-01},
  { 7.961201e-01,  5.044980e-01, -3.341774e-01,  3.894655e-01,  1.205330e+00, -1.448246e-01},
  { 9.447932e-01, -2.616938e-01, -1.971859e-01,  6.975135e-01, -1.007533e+00, -3.725292e-01},
  { 9.884137e-01, -5.492735e-02, -1.414966e-01,  7.030280e-01, -9.704455e-01, -3.770600e-01},
  { 6.571942e-01,  7.536849e-01,  7.406183e-03,  5.693756e-01, -7.231978e-01, -2.675086e-01},
  { 8.043722e-01,  5.802794e-01, -1.275195e-01,  5.545629e-01, -7.108354e-01, -2.551053e-01},
  { 9.711143e-01,  1.303191e-02, -2.382583e-01,  5.522904e-01, -6.861120e-01, -2.533393e-01},
  { 9.869454e-01, -1.284364e-01, -9.717454e-02,  5.917836e-01, -5.130387e-01, -2.857771e-01},
  { 9.443704e-01,  3.257453e-01, -4.532708e-02,  5.898529e-01, -4.759516e-01, -2.842132e-01},
  { 9.886619e-01, -4.055591e-02, -1.445776e-01,  5.729183e-01, -3.152404e-01, -2.702815e-01},
  { 9.655243e-01, -9.942276e-02,  2.405782e-01,  5.630394e-01, -1.174423e-01, -2.623295e-01},
  { 6.081411e-01, -6.101082e-01,  5.078706e-01,  6.018668e-01, -9.271762e-02, -2.939257e-01},
  { 6.773654e-01, -5.012601e-01,  5.384371e-01,  7.634267e-01, -5.563052e-02, -4.270426e-01},
  { 7.884229e-01, -4.246264e-01,  4.450637e-01,  7.894510e-01, -4.326793e-02, -4.483177e-01},
  { 8.934649e-01,  1.249078e-01,  4.314146e-01,  8.020672e-01,  1.854389e-02, -4.586859e-01},
  { 8.698686e-01,  2.592801e-01,  4.196456e-01,  7.864357e-01,  5.563099e-02, -4.460054e-01},
  { 7.913588e-01,  3.950779e-01,  4.665456e-01,  7.773157e-01,  6.799346e-02, -4.386033e-01},
  { 7.748601e-01,  4.211793e-01,  4.713807e-01,  7.662894e-01,  8.035583e-02, -4.296449e-01},
  { 7.613653e-01,  4.176759e-01,  4.958525e-01,  7.541761e-01,  9.271819e-02, -4.197677e-01},
  { 8.143201e-01,  1.445439e-01,  5.621297e-01,  7.446315e-01,  1.050806e-01, -4.119787e-01},
  { 7.865855e-01,  3.257264e-01,  5.245813e-01,  6.998626e-01,  1.668925e-01, -3.752613e-01},
  { 7.226368e-01,  4.603252e-01,  5.156518e-01,  5.197144e-01,  3.152396e-01, -2.272560e-01},
  { 7.332487e-01,  5.193069e-01,  4.389382e-01,  4.893886e-01,  3.276020e-01, -2.016193e-01},
  { 8.709044e-01,  1.556836e-01,  4.661416e-01,  4.717094e-01,  3.399643e-01, -1.871108e-01},
  { 8.135229e-01,  6.668130e-02,  5.776972e-01,  4.897395e-01,  3.523267e-01, -2.025886e-01},
  { 7.596719e-01,  4.542464e-01,  4.653587e-01,  4.652111e-01,  3.646892e-01, -1.817778e-01},
  { 8.506020e-01,  1.783410e-01,  4.946420e-01,  4.614713e-01,  3.894139e-01, -1.793268e-01},
  { 7.920223e-01,  3.747027e-01,  4.819736e-01,  4.529260e-01,  4.017763e-01, -1.722321e-01},
  { 6.805781e-01,  6.933073e-01,  2.369356e-01,  4.339618e-01,  4.141386e-01, -1.561328e-01},
  { 8.744088e-01,  3.293644e-01,  3.562699e-01,  4.236508e-01,  4.265016e-01, -1.479742e-01},
  { 7.208812e-01,  5.874131e-01,  3.677992e-01,  4.152314e-01,  4.388637e-01, -1.407615e-01},
  { 8.162203e-01,  3.495246e-01,  4.600184e-01,  3.979152e-01,  4.512262e-01, -1.269195e-01},
  { 9.029627e-01,  2.020902e-01,  3.792332e-01,  4.002281e-01,  4.635885e-01, -1.284488e-01},
  { 8.268233e-01,  5.054582e-01,  2.467290e-01,  3.949719e-01,  4.759509e-01, -1.241354e-01},
  { 8.311206e-01,  3.674392e-01,  4.174052e-01,  3.663638e-01,  4.849005e-01, -1.010960e-01},
  { 8.639939e-01,  2.609276e-01,  4.306175e-01,  3.391884e-01,  5.254002e-01, -7.871532e-02},
  { 8.694670e-01, -4.311857e-02,  4.921056e-01,  3.364508e-01,  5.377627e-01, -7.648006e-02},
  { 7.506572e-01, -5.013288e-01,  4.303292e-01,  3.691859e-01,  6.119370e-01, -1.032843e-01},
  { 6.893070e-01, -6.768765e-01,  2.582519e-01,  4.183873e-01,  6.366616e-01, -1.435689e-01},
  { 5.914789e-01, -8.063192e-01, -1.435065e-03,  4.376525e-01,  6.490240e-01, -1.592831e-01},
  { 7.920359e-01, -5.209416e-01, -3.182750e-01,  4.950747e-01,  7.231982e-01, -2.063190e-01},
  { 8.315039e-01, -4.182109e-01, -3.656513e-01,  5.004219e-01,  7.355605e-01, -2.107069e-01},
  { 8.969094e-01, -1.555069e-01, -4.139699e-01,  5.215523e-01,  8.468218e-01, -2.280719e-01},
  { 9.437750e-01, -3.301566e-01, -1.689127e-02,  6.957099e-01, -1.019895e+00, -3.402337e-01},
  { 9.736631e-01,  1.965173e-01, -1.155901e-01,  7.047496e-01, -9.209958e-01, -3.474706e-01},
  { 7.707696e-01,  6.362939e-01,  3.231385e-02,  5.811630e-01, -7.355601e-01, -2.486614e-01},
  { 7.078046e-01,  7.044079e-01, -5.312257e-02,  5.693126e-01, -7.231978e-01, -2.391290e-01},
  { 5.890195e-01,  8.034712e-01, -8.654477e-02,  5.612398e-01, -7.108354e-01, -2.326057e-01},
  { 9.955189e-01,  9.456248e-02,  4.514139e-05,  5.406142e-01, -3.894148e-01, -2.159669e-01},
  { 9.942164e-01,  7.990988e-02, -7.175071e-02,  5.756512e-01, -3.028781e-01, -2.441415e-01},
  { 9.322145e-01, -1.252896e-01,  3.395269e-01,  5.478532e-01, -9.271762e-02, -2.217601e-01},
  { 8.371752e-01, -4.667396e-01,  2.851170e-01,  5.464054e-01, -8.035525e-02, -2.206017e-01},
  { 8.595696e-01, -1.781694e-01,  4.789528e-01,  7.730044e-01, -6.180837e-03, -4.024873e-01},
  { 8.142352e-01,  2.463056e-01,  5.256944e-01,  7.679869e-01,  1.854389e-02, -3.985361e-01},
  { 7.610581e-01,  3.761730e-01,  5.284737e-01,  7.180817e-01,  6.799346e-02, -3.587901e-01},
  { 7.025127e-01,  4.713257e-01,  5.332240e-01,  6.953493e-01,  8.035583e-02, -3.406474e-01},
  { 6.498539e-01,  5.938488e-01,  4.743769e-01,  6.705846e-01,  9.271819e-02, -3.208257e-01},
  { 7.249604e-01,  4.625960e-01,  5.103306e-01,  6.252611e-01,  1.050806e-01, -2.837120e-01},
  { 8.154779e-01,  1.997562e-01,  5.432249e-01,  5.357047e-01,  2.410653e-01, -2.128238e-01},
  { 8.152484e-01,  4.619756e-01,  3.492116e-01,  4.755375e-01,  3.276020e-01, -1.642505e-01},
  { 8.426812e-01,  4.861665e-01,  2.313664e-01,  4.668102e-01,  3.399643e-01, -1.571664e-01},
  { 9.095299e-01,  1.397007e-01,  3.914576e-01,  4.606331e-01,  3.523267e-01, -1.522709e-01},
  { 8.541765e-01,  3.693306e-01,  3.660295e-01,  4.545545e-01,  3.646892e-01, -1.474222e-01},
  { 7.925786e-01,  5.294266e-01,  3.025335e-01,  4.218073e-01,  4.141386e-01, -1.212124e-01},
  { 6.369962e-01,  7.358213e-01,  2.297891e-01,  3.942764e-01,  4.388637e-01, -9.914447e-02},
  { 6.181849e-01,  7.783484e-01,  1.096413e-01,  3.541403e-01,  4.512262e-01, -6.672659e-02},
  { 9.797372e-01,  1.709845e-01,  1.043039e-01,  3.389868e-01,  4.635885e-01, -5.459893e-02},
  { 9.742821e-01,  3.207368e-02,  2.230371e-01,  3.444884e-01,  4.759509e-01, -5.900198e-02},
  { 9.359704e-01,  2.195319e-01,  2.752547e-01,  3.420753e-01,  4.883133e-01, -5.707079e-02},
  { 9.651263e-01,  1.583959e-01,  2.084273e-01,  3.441103e-01,  5.004660e-01, -5.893950e-02},
  { 8.800862e-01,  4.269011e-01,  2.078548e-01,  3.385262e-01,  5.130201e-01, -5.443385e-02},
  { 9.025029e-01,  4.269841e-01,  5.632997e-02,  3.278872e-01,  5.254002e-01, -4.571567e-02},
  { 9.973805e-01,  6.641857e-02,  2.864578e-02,  3.198763e-01,  5.624875e-01, -3.930422e-02},
  { 9.504961e-01, -2.845424e-01, -1.248713e-01,  3.224856e-01,  5.748498e-01, -4.139270e-02},
  { 9.169988e-01, -3.970206e-01,  3.857297e-02,  3.255707e-01,  5.872122e-01, -4.386173e-02},
  { 8.197677e-01, -5.473788e-01,  1.683966e-01,  3.345470e-01,  5.995746e-01, -5.104567e-02},
  { 6.882426e-01, -6.792541e-01,  2.548251e-01,  3.634026e-01,  6.242992e-01, -7.435793e-02},
  { 8.081210e-01, -5.852650e-01, -6.637359e-02,  4.776274e-01,  6.861111e-01, -1.656083e-01},
  { 9.097887e-01, -3.249786e-01, -2.582119e-01,  5.167140e-01,  7.602853e-01, -1.968874e-01},
  { 8.770865e-01,  3.161995e-01, -3.615758e-01,  5.177336e-01,  9.828078e-01, -1.977213e-01},
  { 8.385827e-01,  4.111953e-01, -3.573477e-01,  5.045878e-01,  1.019895e+00, -1.872060e-01},
  { 9.975131e-01,  6.594707e-02,  2.487558e-02,  7.066611e-01, -9.333581e-01, -3.185678e-01},
  { 8.978977e-01,  4.389518e-01,  3.318226e-02,  6.865102e-01, -8.591840e-01, -3.028685e-01},
  { 7.714871e-01,  6.183911e-01, -1.496667e-01,  5.660367e-01, -7.108354e-01, -2.087820e-01},
  { 9.887689e-01, -1.464835e-01,  2.964010e-02,  5.917718e-01, -5.130387e-01, -2.288939e-01},
  { 8.355933e-01,  5.493393e-01,  3.177046e-03,  5.771100e-01, -4.388643e-01, -2.174850e-01},
  { 9.676088e-01, -2.513871e-01, -2.318997e-02,  5.744286e-01, -3.276030e-01, -2.153210e-01},
  { 5.749446e-01, -7.592140e-01,  3.050129e-01,  6.741917e-01, -5.563052e-02, -2.933761e-01},
  { 8.964182e-01, -1.521049e-01,  4.162913e-01,  7.377833e-01, -1.854320e-02, -3.431489e-01},
  { 7.584583e-01,  4.790658e-01,  4.418563e-01,  6.900057e-01,  5.563099e-02, -3.059810e-01},
  { 6.009045e-01,  7.570229e-01,  2.565735e-01,  6.128278e-01,  1.050806e-01, -2.456364e-01},
  { 8.149849e-01,  3.337382e-01,  4.737282e-01,  5.917015e-01,  1.174429e-01, -2.286821e-01},
  { 7.982551e-01,  4.171820e-01,  4.344512e-01,  5.260950e-01,  2.163405e-01, -1.779969e-01},
  { 8.727252e-01,  2.331935e-01,  4.289189e-01,  5.094300e-01,  2.287029e-01, -1.649731e-01},
  { 8.711625e-01,  4.093208e-01,  2.711685e-01,  4.255493e-01,  3.894139e-01, -9.930225e-02},
  { 8.326024e-01,  4.689696e-01,  2.946879e-01,  4.180252e-01,  4.017763e-01, -9.343730e-02},
  { 7.759641e-01,  5.339227e-01,  3.358666e-01,  3.969386e-01,  4.265016e-01, -7.700758e-02},
  { 7.398640e-01,  6.111331e-01,  2.812785e-01,  3.840157e-01,  4.388637e-01, -6.660639e-02},
  { 6.824366e-01,  7.288035e-01, -5.590809e-02,  3.605280e-01,  4.512262e-01, -4.827682e-02},
  { 7.526616e-01,  5.190736e-01, -4.050469e-01,  3.521466e-01,  4.635885e-01, -4.173590e-02},
  { 9.215528e-01,  1.151379e-01, -3.707880e-01,  3.505872e-01,  4.759509e-01, -4.051911e-02},
  { 9.649066e-01,  2.446850e-01, -9.531220e-02,  3.425364e-01,  5.006666e-01, -3.434482e-02},
  { 9.167630e-01,  3.751401e-01, -1.371697e-01,  3.381689e-01,  5.130284e-01, -3.095207e-02},
  { 8.841121e-01,  3.878272e-01, -2.606452e-01,  3.324728e-01,  5.253997e-01, -2.647774e-02},
  { 9.282303e-01, -1.547306e-01, -3.383000e-01,  3.267469e-01,  5.624875e-01, -2.196331e-02},
  { 7.560816e-01, -5.235800e-01, -3.926889e-01,  3.414237e-01,  5.995746e-01, -3.337933e-02},
  { 7.670671e-01, -6.000776e-01, -2.269691e-01,  3.493059e-01,  6.119370e-01, -3.955760e-02},
  { 6.318067e-01, -6.676318e-01,  3.938121e-01,  3.972211e-01,  6.490240e-01, -7.715458e-02},
  { 5.938488e-01, -7.853028e-01,  1.750516e-01,  4.634816e-01,  6.737487e-01, -1.287548e-01},
  { 9.420790e-01,  1.430756e-01, -3.033423e-01,  5.348418e-01,  9.333584e-01, -1.843858e-01},
  { 6.837066e-01, -7.294930e-01, -1.962738e-02,  5.325456e-01, -1.205331e+00, -1.562696e-01},
  { 7.501449e-01, -6.273826e-01,  2.089824e-01,  5.672482e-01, -1.180606e+00, -1.824405e-01},
  { 7.268197e-01, -6.820776e-01,  8.064254e-02,  6.023088e-01, -1.155881e+00, -2.092278e-01},
  { 9.882479e-01, -9.621052e-02, -1.187845e-01,  5.634990e-01, -6.366625e-01, -1.797116e-01},
  { 8.905824e-01,  4.474564e-01,  8.152092e-02,  5.441245e-01, -4.017772e-01, -1.650408e-01},
  { 9.682723e-01, -2.379817e-01,  7.624618e-02,  5.406432e-01, -3.894148e-01, -1.623546e-01},
  { 9.064901e-01, -4.177012e-01, -6.165469e-02,  5.764294e-01, -3.152404e-01, -1.895562e-01},
  { 9.931411e-01,  1.140005e-01, -2.597633e-02,  5.674329e-01, -2.287039e-01, -1.827355e-01},
  { 5.895352e-01, -7.503656e-01,  2.989979e-01,  6.683855e-01, -4.326793e-02, -2.596587e-01},
  { 7.370829e-01, -5.719699e-01,  3.599436e-01,  7.016427e-01, -3.090557e-02, -2.846916e-01},
  { 7.298471e-01,  6.277025e-01,  2.707634e-01,  6.562041e-01,  6.799346e-02, -2.505090e-01},
  { 7.430276e-01,  5.962617e-01,  3.039441e-01,  5.577607e-01,  1.298054e-01, -1.755773e-01},
  { 8.972057e-01,  3.065613e-01,  3.178714e-01,  4.950290e-01,  2.287029e-01, -1.278063e-01},
  { 7.605390e-01,  6.332280e-01,  1.435365e-01,  4.095428e-01,  4.017763e-01, -6.267916e-02},
  { 7.231539e-01,  6.668684e-01,  1.798190e-01,  3.812584e-01,  4.265016e-01, -4.117593e-02},
  { 8.824930e-01,  4.585378e-01,  1.046394e-01,  3.625084e-01,  4.388637e-01, -2.666847e-02},
  { 9.368266e-01,  3.472297e-01, -4.227827e-02,  3.591633e-01,  4.512262e-01, -2.412321e-02},
  { 9.040433e-01,  3.341317e-01, -2.665740e-01,  3.579552e-01,  4.635885e-01, -2.326637e-02},
  { 9.381753e-01,  6.360724e-02, -3.402665e-01,  3.326553e-01,  5.501251e-01, -4.010499e-03},
  { 8.711509e-01, -3.785804e-01, -3.126869e-01,  3.356268e-01,  5.748498e-01, -6.250105e-03},
  { 7.692587e-01, -6.367919e-01, -5.231752e-02,  3.737243e-01,  6.490240e-01, -3.520172e-02},
  { 5.869049e-01, -8.012173e-01,  1.165908e-01,  3.827758e-01,  6.613864e-01, -4.208839e-02},
  { 8.991113e-01, -4.046090e-01, -1.670039e-01,  5.221010e-01,  7.479229e-01, -1.481500e-01},
  { 8.616042e-01, -4.556990e-01, -2.235546e-01,  5.580639e-01, -1.180606e+00, -1.489732e-01},
  { 7.935519e-01, -6.075583e-01, -3.388750e-02,  5.595534e-01, -1.168244e+00, -1.500778e-01},
  { 7.208179e-01, -6.903522e-01,  6.192975e-02,  6.255434e-01, -1.131156e+00, -1.990972e-01},
  { 8.503104e-01, -5.261894e-01,  9.843355e-03,  6.554568e-01, -1.081707e+00, -2.213089e-01},
  { 9.755803e-01,  8.243714e-02, -2.035857e-01,  5.638327e-01, -6.737497e-01, -1.533538e-01},
  { 9.939355e-01,  5.787287e-02,  9.350385e-02,  5.330412e-01, -3.894148e-01, -1.304155e-01},
  { 9.086007e-01, -3.958410e-01, -1.332467e-01,  5.742356e-01, -3.276030e-01, -1.610756e-01},
  { 8.633890e-01, -3.509908e-01,  3.624429e-01,  6.810921e-01, -3.090557e-02, -2.402150e-01},
  { 8.816935e-01,  3.402581e-01,  3.268654e-01,  6.828063e-01,  1.854389e-02, -2.418209e-01},
  { 6.853520e-01,  6.237072e-01,  3.758749e-01,  5.562764e-01,  1.174429e-01, -1.476477e-01},
  { 8.958973e-01,  4.229528e-01,  1.359372e-01,  5.271755e-01,  1.668925e-01, -1.263038e-01},
  { 8.512807e-01,  5.245322e-01,  1.368442e-02,  4.138933e-01,  3.894139e-01, -4.223152e-02},
  { 7.854806e-01,  5.920965e-01,  1.801168e-01,  4.038946e-01,  4.017763e-01, -3.483789e-02},
  { 7.822053e-01,  5.983253e-01,  1.736721e-01,  3.941256e-01,  4.141386e-01, -2.739105e-02},
  { 7.418870e-01,  6.684455e-01, -5.276755e-02,  3.760534e-01,  4.265016e-01, -1.398834e-02},
  { 8.434609e-01,  4.771957e-01, -2.466941e-01,  3.661238e-01,  4.388637e-01, -6.624217e-03},
  { 9.066606e-01,  1.435452e-01, -3.966879e-01,  3.663016e-01,  4.512262e-01, -6.789556e-03},
  { 8.265244e-01,  3.807988e-01, -4.145476e-01,  3.617448e-01,  4.759509e-01, -3.431660e-03},
  { 7.162902e-01,  6.349214e-01, -2.894878e-01,  3.566872e-01,  4.883133e-01,  2.917598e-04},
  { 8.854219e-01,  4.450182e-01, -1.341152e-01,  3.502195e-01,  5.006756e-01,  5.064318e-03},
  { 9.699579e-01,  2.413633e-01, -3.042101e-02,  3.445695e-01,  5.130381e-01,  9.257698e-03},
  { 9.711134e-01,  1.743186e-01, -1.629469e-01,  3.414588e-01,  5.254002e-01,  1.158408e-02},
  { 8.556818e-01, -3.862365e-01, -3.444271e-01,  3.407979e-01,  5.748498e-01,  1.213379e-02},
  { 7.453036e-01, -5.963099e-01, -2.982232e-01,  3.829999e-01,  6.490240e-01, -1.912965e-02},
  { 5.808198e-01, -7.999354e-01, -1.508368e-01,  3.929764e-01,  6.613864e-01, -2.653724e-02},
  { 4.956201e-01, -8.401620e-01,  2.202010e-01,  4.245197e-01,  6.737487e-01, -5.001869e-02},
  { 6.536132e-01, -7.531592e-01,  7.443850e-02,  4.867429e-01,  6.984736e-01, -9.616657e-02},
  { 8.802946e-01, -3.777000e-01, -2.870961e-01,  5.354480e-01,  7.726477e-01, -1.322491e-01},
  { 9.268676e-01, -8.600926e-02, -3.654021e-01,  5.461181e-01,  8.715466e-01, -1.401635e-01},
  { 6.456662e-01, -7.034062e-01, -2.972117e-01,  5.765250e-01, -1.168244e+00, -1.363145e-01},
  { 9.416386e-01, -3.331600e-01,  4.817839e-02,  6.829322e-01, -1.019895e+00, -2.133416e-01},
  { 8.704084e-01,  4.916670e-01, -2.555100e-02,  6.841627e-01, -8.715463e-01, -2.142741e-01},
  { 8.220276e-01,  5.518414e-01, -1.405051e-01,  5.951674e-01, -7.479225e-01, -1.498993e-01},
  { 9.604786e-01,  1.800585e-01, -2.122727e-01,  5.694474e-01, -6.861120e-01, -1.312807e-01},
  { 9.969022e-01, -3.511660e-02, -7.037653e-02,  5.653747e-01, -6.243002e-01, -1.283519e-01},
  { 9.442576e-01, -2.949519e-01,  1.462219e-01,  5.243246e-01, -8.035525e-02, -9.858506e-02},
  { 5.046139e-01, -8.126584e-01,  2.914634e-01,  6.355274e-01, -4.326793e-02, -1.791222e-01},
  { 6.937771e-01,  7.040526e-01,  1.516023e-01,  6.457649e-01,  5.563099e-02, -1.866569e-01},
  { 6.748486e-01,  6.989120e-01,  2.368574e-01,  6.321566e-01,  6.799346e-02, -1.768591e-01},
  { 5.871252e-01,  7.401796e-01,  3.277469e-01,  5.645019e-01,  1.050806e-01, -1.276245e-01},
  { 7.877396e-01,  5.628093e-01,  2.504238e-01,  5.356464e-01,  1.174429e-01, -1.067684e-01},
  { 9.414027e-01,  2.786829e-01,  1.899913e-01,  5.329411e-01,  1.298054e-01, -1.048130e-01},
  { 8.529562e-01,  5.014967e-01, -1.447985e-01,  5.145563e-01,  1.916172e-01, -9.166112e-02},
  { 8.348373e-01,  5.330595e-01, -1.374567e-01,  4.765336e-01,  2.410653e-01, -6.416859e-02},
  { 8.524359e-01,  4.505884e-01, -2.651851e-01,  4.452758e-01,  3.276020e-01, -4.155307e-02},
  { 5.975102e-01,  7.972935e-01, -8.546811e-02,  3.998463e-01,  4.017763e-01, -8.759176e-03},
  { 8.247212e-01,  5.499343e-01, -1.319366e-01,  3.798467e-01,  4.141386e-01,  5.840732e-03},
  { 9.247853e-01,  3.192563e-01, -2.069963e-01,  3.777426e-01,  4.265016e-01,  7.361648e-03},
  { 8.573428e-01,  2.282606e-01, -4.613681e-01,  3.764402e-01,  4.388637e-01,  8.303039e-03},
  { 9.955997e-01,  7.480136e-02,  5.644539e-02,  3.411724e-01,  5.130381e-01,  3.379398e-02},
  { 9.818148e-01, -1.360012e-01, -1.324514e-01,  3.439109e-01,  5.254002e-01,  3.175030e-02},
  { 9.497895e-01, -6.797357e-02, -3.054169e-01,  3.448729e-01,  5.377627e-01,  3.108295e-02},
  { 6.657164e-01, -7.218888e-01, -1.889399e-01,  4.047948e-01,  6.737487e-01, -1.219116e-02},
  { 4.898567e-01, -8.686460e-01,  7.412472e-02,  4.225289e-01,  6.861111e-01, -2.500894e-02},
  { 8.998551e-01,  1.199111e-01, -4.193832e-01,  5.542765e-01,  9.333584e-01, -1.202708e-01},
  { 7.262399e-01,  5.813774e-01, -3.668457e-01,  4.258350e-01,  1.205330e+00, -2.739877e-02},
  { 9.237084e-01, -3.645507e-01, -1.177526e-01,  6.708032e-01, -1.056982e+00, -1.768967e-01},
  { 8.257741e-01,  5.635827e-01, -2.171533e-02,  6.589946e-01, -8.220969e-01, -1.686461e-01},
  { 9.865062e-01, -1.069124e-01, -1.239972e-01,  5.696201e-01, -5.624881e-01, -1.056705e-01},
  { 9.795489e-01, -7.012703e-02, -1.885895e-01,  5.732038e-01, -5.377634e-01, -1.082059e-01},
  { 9.494265e-01,  3.082732e-01, -5.963976e-02,  5.707877e-01, -4.388643e-01, -1.065316e-01},
  { 8.490653e-01, -5.213615e-01,  8.526641e-02,  5.387839e-01, -3.770525e-01, -8.392768e-02},
  { 7.342046e-01, -6.755931e-01, -6.721292e-02,  5.623528e-01, -3.523277e-01, -1.005009e-01},
  { 9.740757e-01, -2.082054e-01, -8.847046e-02,  5.794454e-01, -3.152404e-01, -1.125722e-01},
  { 6.001539e-01, -7.061641e-01,  3.756962e-01,  5.586978e-01, -5.563052e-02, -9.787296e-02},
  { 5.213826e-01, -7.363687e-01,  4.311861e-01,  6.015336e-01, -4.326793e-02, -1.283778e-01},
  { 6.935596e-01, -5.438662e-01,  4.724241e-01,  6.338627e-01, -3.090557e-02, -1.512273e-01},
  { 7.923849e-01, -2.399740e-01,  5.608374e-01,  6.512270e-01, -6.180837e-03, -1.634669e-01},
  { 8.980985e-01,  1.010233e-01,  4.280345e-01,  6.540930e-01,  1.854389e-02, -1.654249e-01},
  { 7.948985e-01,  4.793156e-01,  3.720120e-01,  6.383440e-01,  5.563099e-02, -1.539647e-01},
  { 6.820538e-01,  5.702439e-01,  4.578478e-01,  6.108824e-01,  6.799346e-02, -1.350771e-01},
  { 7.073486e-01,  5.123920e-01,  4.869417e-01,  5.957918e-01,  8.035583e-02, -1.239968e-01},
  { 6.180431e-01,  7.230448e-01,  3.085919e-01,  5.662783e-01,  9.271819e-02, -1.032116e-01},
  { 8.427986e-01,  5.065941e-01,  1.818047e-01,  5.367647e-01,  1.050806e-01, -8.242639e-02},
  { 9.418755e-01,  3.341751e-01,  3.460759e-02,  5.321153e-01,  1.174429e-01, -7.915188e-02},
  { 9.219986e-01,  3.355287e-01, -1.932333e-01,  5.181767e-01,  1.916172e-01, -6.941510e-02},
  { 7.263316e-01,  6.363421e-01, -2.598289e-01,  5.053719e-01,  2.163405e-01, -6.041477e-02},
  { 6.761716e-01,  6.269840e-01, -3.868888e-01,  4.835778e-01,  2.410653e-01, -4.503844e-02},
  { 8.055002e-01,  5.160443e-01, -2.913206e-01,  4.776271e-01,  2.534277e-01, -4.083799e-02},
  { 8.008215e-01,  5.737510e-01, -1.717399e-01,  4.339158e-01,  3.646892e-01, -1.009787e-02},
  { 7.412903e-01,  6.657263e-01, -8.542344e-02,  4.182690e-01,  3.894139e-01,  8.875369e-04},
  { 7.086280e-01,  6.997154e-01, -9.080010e-02,  4.054664e-01,  4.017763e-01,  9.928659e-03},
  { 7.176319e-01,  5.634266e-01, -4.093348e-01,  3.918248e-01,  4.141386e-01,  1.964923e-02},
  { 7.792154e-01,  1.881322e-01, -5.978542e-01,  3.885527e-01,  4.265016e-01,  2.194843e-02},
  { 7.424911e-01,  3.547038e-01, -5.682359e-01,  3.798148e-01,  4.759509e-01,  2.809305e-02},
  { 6.422155e-01,  6.283475e-01, -4.390202e-01,  3.731752e-01,  4.883133e-01,  3.274618e-02},
  { 9.447476e-01,  1.613196e-01, -2.853557e-01,  3.400751e-01,  5.130381e-01,  5.609463e-02},
  { 8.573982e-01, -4.857771e-01, -1.699675e-01,  3.466215e-01,  5.254002e-01,  5.146078e-02},
  { 8.512495e-01, -2.878190e-01, -4.387876e-01,  3.522748e-01,  5.377627e-01,  4.750187e-02},
  { 7.500655e-01, -2.895852e-01, -5.945942e-01,  3.585432e-01,  5.748498e-01,  4.311157e-02},
  { 7.068874e-01, -5.574266e-01, -4.354146e-01,  3.672365e-01,  5.995746e-01,  3.698771e-02},
  { 5.094344e-01, -8.554907e-01, -9.280147e-02,  4.995979e-01,  7.108357e-01, -5.626418e-02},
  { 7.418194e-01, -5.865539e-01, -3.250515e-01,  5.350786e-01,  7.479229e-01, -8.125865e-02},
  { 8.630364e-01, -2.407138e-01, -4.441004e-01,  5.591651e-01,  8.097348e-01, -9.821051e-02},
  { 6.303038e-01, -7.761860e-01, -1.588606e-02,  5.673361e-01, -1.168244e+00, -7.869663e-02},
  { 9.036888e-01, -4.222045e-01,  7.134394e-02,  6.791041e-01, -1.044620e+00, -1.554299e-01},
  { 9.578618e-01,  2.787078e-01,  6.944568e-02,  6.971152e-01, -9.086334e-01, -1.678553e-01},
  { 9.021430e-01,  3.972930e-01, -1.682149e-01,  5.962710e-01, -7.231978e-01, -9.862477e-02},
  { 9.953519e-01,  2.082448e-03,  9.628318e-02,  5.724049e-01, -5.995755e-01, -8.224747e-02},
  { 9.911141e-01,  1.319921e-01, -1.645473e-02,  5.804495e-01, -4.759516e-01, -8.782022e-02},
  { 8.721244e-01,  4.864649e-01,  5.244807e-02,  5.635911e-01, -4.265019e-01, -7.628459e-02},
  { 9.855992e-01,  1.689747e-01,  6.462163e-03,  5.328025e-01, -3.894148e-01, -5.498865e-02},
  { 8.093023e-01, -5.861419e-01, -3.830753e-02,  5.334141e-01, -3.770525e-01, -5.540820e-02},
  { 8.005108e-01, -5.947994e-01, -7.345820e-02,  5.739992e-01, -3.399654e-01, -8.330172e-02},
  { 9.994004e-01,  2.188978e-02,  2.682768e-02,  5.262782e-01, -5.563052e-02, -5.051272e-02},
  { 8.550820e-01, -3.681574e-01,  3.650959e-01,  5.242395e-01, -4.326793e-02, -4.911390e-02},
  { 7.638669e-01, -1.046900e-01,  6.368260e-01,  6.169405e-01,  6.181527e-03, -1.133405e-01},
  { 7.181197e-01,  3.656837e-01,  5.920976e-01,  6.132329e-01,  5.563099e-02, -1.101687e-01},
  { 6.015002e-01,  7.334449e-01,  3.166324e-01,  5.523748e-01,  6.799346e-02, -6.841652e-02},
  { 9.385160e-01,  2.303622e-01,  2.571402e-01,  5.281132e-01,  8.035583e-02, -5.177153e-02},
  { 9.426871e-01,  1.045894e-02,  3.335142e-01,  5.353507e-01,  9.271819e-02, -5.673702e-02},
  { 9.731632e-01,  2.105049e-01,  9.295736e-02,  5.353507e-01,  1.050806e-01, -5.673702e-02},
  { 9.906699e-01,  1.172532e-01, -6.946123e-02,  5.353748e-01,  1.174429e-01, -5.681979e-02},
  { 9.357274e-01,  1.938289e-01, -2.946942e-01,  5.317597e-01,  1.545301e-01, -5.432581e-02},
  { 7.853274e-01,  5.066422e-01, -3.557734e-01,  5.210609e-01,  2.039797e-01, -4.701569e-02},
  { 8.307213e-01,  5.480613e-01, -9.762646e-02,  4.373004e-01,  3.646892e-01,  1.042224e-02},
  { 7.979816e-01,  6.022687e-01, -2.231177e-02,  4.153693e-01,  3.894139e-01,  2.545109e-02},
  { 8.324696e-01,  5.122095e-01, -2.112717e-01,  4.033389e-01,  4.017763e-01,  3.383106e-02},
  { 8.419148e-01,  3.340377e-01, -4.237905e-01,  3.987516e-01,  4.141386e-01,  3.697818e-02},
  { 8.050847e-01,  5.261656e-02, -5.908216e-01,  3.989440e-01,  4.265016e-01,  3.685394e-02},
  { 5.501342e-01,  6.846377e-01, -4.781460e-01,  3.864945e-01,  4.883133e-01,  4.535127e-02},
  { 6.308150e-01,  5.435724e-01, -5.537162e-01,  3.525729e-01,  5.130381e-01,  6.865945e-02},
  { 7.479461e-01, -4.160600e-01, -5.171757e-01,  3.505341e-01,  5.254002e-01,  7.005827e-02},
  { 6.814222e-01, -5.941733e-01, -4.273429e-01,  3.615974e-01,  5.377627e-01,  6.250873e-02},
  { 6.560636e-01, -3.341376e-01, -6.767071e-01,  3.673528e-01,  5.501251e-01,  5.856448e-02},
  { 6.324393e-01, -3.853783e-01, -6.719405e-01,  3.777687e-01,  5.995746e-01,  5.142280e-02},
  { 5.641824e-01, -6.602965e-01, -4.956881e-01,  3.848524e-01,  6.119370e-01,  4.657003e-02},
  { 5.287228e-01, -6.799511e-01, -5.080539e-01,  4.062787e-01,  6.366616e-01,  3.189290e-02},
  { 4.086190e-01, -8.153509e-01, -4.101627e-01,  4.423898e-01,  6.861111e-01,  7.139088e-03},
  { 3.158853e-01, -9.391664e-01, -1.348450e-01,  4.648933e-01,  6.984736e-01, -8.305628e-03},
  { 7.643541e-01, -3.570914e-01, -5.368879e-01,  5.680955e-01,  7.973725e-01, -7.918198e-02},
  { 8.173713e-01,  1.173124e-02, -5.759918e-01,  5.776702e-01,  9.086336e-01, -8.577003e-02},
  { 6.417900e-01, -7.559295e-01, -1.291363e-01,  5.352017e-01, -1.205331e+00, -3.246201e-02},
  { 9.464601e-01, -2.348581e-01,  2.214837e-01,  6.926110e-01, -1.007533e+00, -1.376196e-01},
  { 9.978331e-01, -6.543599e-02, -6.875515e-03,  6.984932e-01, -9.580831e-01, -1.415793e-01},
  { 9.134139e-01,  3.635868e-01,  1.829747e-01,  6.729114e-01, -8.468216e-01, -1.245487e-01},
  { 9.734423e-01,  2.009833e-01, -1.096164e-01,  5.801681e-01, -6.490249e-01, -6.249692e-02},
  { 9.921585e-01, -5.067758e-03,  1.248833e-01,  5.771581e-01, -4.883140e-01, -6.053020e-02},
  { 9.406914e-01,  2.991352e-01,  1.600559e-01,  5.720326e-01, -4.512267e-01, -5.714286e-02},
  { 9.963269e-01, -5.095867e-02,  6.881893e-02,  5.317923e-01, -3.894148e-01, -3.023549e-02},
  { 8.352500e-01, -5.157188e-01, -1.907657e-01,  5.361857e-01, -3.770525e-01, -3.301360e-02},
  { 7.809541e-01, -6.044081e-01, -1.574852e-01,  5.677863e-01, -3.523277e-01, -5.414471e-02},
  { 9.790940e-01,  2.020793e-01,  2.321049e-02,  5.710444e-01, -2.163415e-01, -5.642476e-02},
  { 9.394615e-01, -2.121750e-01,  2.690609e-01,  5.296071e-01, -3.090557e-02, -2.861815e-02},
  { 9.851274e-01, -1.406342e-01,  9.872149e-02,  5.243462e-01,  6.181527e-03, -2.510296e-02},
  { 9.542096e-01, -1.361498e-01,  2.663596e-01,  5.266393e-01,  3.090626e-02, -2.663554e-02},
  { 9.225338e-01, -1.581438e-01,  3.520258e-01,  5.349522e-01,  5.563099e-02, -3.218948e-02},
  { 9.714635e-01,  1.490355e-01,  1.845184e-01,  5.366995e-01,  6.799346e-02, -3.335711e-02},
  { 9.597009e-01,  1.779761e-01, -2.174830e-01,  5.379332e-01,  8.035583e-02, -3.418123e-02},
  { 9.619244e-01, -5.541991e-02, -2.676377e-01,  5.379207e-01,  9.271819e-02, -3.420540e-02},
  { 8.871980e-01,  1.974512e-01, -4.170046e-01,  5.368066e-01,  1.792549e-01, -3.349230e-02},
  { 8.178485e-01,  5.145498e-01, -2.576090e-01,  5.323219e-01,  1.916172e-01, -3.052076e-02},
  { 8.014420e-01,  5.894780e-01, -1.010269e-01,  4.290782e-01,  3.770515e-01,  3.855130e-02},
  { 7.858151e-01,  5.065992e-01, -3.547561e-01,  4.142764e-01,  3.894139e-01,  4.844140e-02},
  { 8.251306e-01,  2.480953e-01, -5.075511e-01,  4.113982e-01,  4.017763e-01,  5.036437e-02},
  { 7.198655e-01,  5.826684e-02, -6.916636e-01,  4.121633e-01,  4.141386e-01,  4.987889e-02},
  { 6.918628e-01,  1.157941e-01, -7.126834e-01,  4.106323e-01,  4.512262e-01,  5.090456e-02},
  { 4.713098e-01,  8.224740e-01, -3.184392e-01,  3.970398e-01,  4.883133e-01,  5.988660e-02},
  { 5.018350e-01,  8.452177e-01, -1.837625e-01,  3.808342e-01,  5.006756e-01,  7.066339e-02},
  { 9.745779e-01,  1.681767e-01, -1.480354e-01,  3.621617e-01,  5.130381e-01,  8.326238e-02},
  { 7.387469e-01, -4.469611e-01, -5.044590e-01,  3.646286e-01,  5.254002e-01,  8.161412e-02},
  { 5.787395e-01, -5.162218e-01, -6.313284e-01,  3.815818e-01,  5.501251e-01,  7.035704e-02},
  { 8.138065e-01,  2.019306e-01, -5.449248e-01,  5.855640e-01,  9.580831e-01, -6.601124e-02},
  { 8.255063e-01,  2.612866e-01, -5.002685e-01,  5.796917e-01,  9.828078e-01, -6.209536e-02},
  { 7.199942e-01,  5.048850e-01, -4.761296e-01,  5.586785e-01,  1.044620e+00, -4.806804e-02},
  { 6.823014e-01, -7.310685e-01, -1.905826e-03,  6.112291e-01, -1.143519e+00, -5.795324e-02},
  { 8.892413e-01,  4.545027e-01,  5.174138e-02,  6.681381e-01, -8.468216e-01, -9.513681e-02},
  { 9.316288e-01,  2.667797e-01,  2.467718e-01,  5.703151e-01, -4.635892e-01, -3.148598e-02},
  { 6.508591e-01, -7.419674e-01, -1.608311e-01,  5.456771e-01, -3.770525e-01, -1.531036e-02},
  { 7.263601e-01, -6.720054e-01, -1.442557e-01,  5.723673e-01, -3.523277e-01, -3.268082e-02},
  { 9.999775e-01,  4.749887e-03,  4.730718e-03,  5.839145e-01, -3.028781e-01, -4.028627e-02},
  { 9.410232e-01, -1.335391e-01, -3.108740e-01,  5.451816e-01,  9.271819e-02, -1.498507e-02},
  { 9.131280e-01,  3.200889e-02, -4.064143e-01,  5.483838e-01,  1.421678e-01, -1.708149e-02},
  { 8.114051e-01,  5.144939e-01, -2.773406e-01,  4.946783e-01,  2.534277e-01,  1.780732e-02},
  { 7.988382e-01,  5.844219e-01, -1.425084e-01,  4.655464e-01,  3.276020e-01,  3.675230e-02},
  { 8.177831e-01,  5.332973e-01, -2.163902e-01,  4.342620e-01,  3.646892e-01,  5.719392e-02},
  { 8.934633e-01,  3.769165e-01, -2.442485e-01,  4.268010e-01,  3.770515e-01,  6.204773e-02},
  { 8.051413e-01,  1.863436e-01, -5.630484e-01,  4.255575e-01,  3.894139e-01,  6.285672e-02},
  { 6.373323e-01, -4.129631e-03, -7.705780e-01,  4.268296e-01,  4.017763e-01,  6.207129e-02},
  { 3.690059e-01,  9.088299e-01, -1.945835e-01,  3.812359e-01,  5.006756e-01,  9.159036e-02},
  { 8.520663e-01,  4.684086e-01, -2.336162e-01,  3.557141e-01,  5.130381e-01,  1.082937e-01},
  { 6.277478e-01, -7.251886e-01, -2.829033e-01,  3.668019e-01,  5.254002e-01,  1.010804e-01},
  { 5.405377e-01, -7.455760e-01, -3.897889e-01,  3.872217e-01,  5.377627e-01,  8.786955e-02},
  { 5.395133e-01, -4.078589e-01, -7.365978e-01,  4.134612e-01,  6.119370e-01,  7.081669e-02},
  { 8.341218e-01,  4.070058e-01, -3.722728e-01,  5.697235e-01,  1.044620e+00, -3.096602e-02},
  { 7.206843e-01,  5.674015e-01, -3.983338e-01,  5.570948e-01,  1.069344e+00, -2.275953e-02},
  { 7.321075e-01,  6.151499e-01, -2.925906e-01,  4.698056e-01,  1.205330e+00,  3.407105e-02},
  { 6.769379e-01, -7.360377e-01,  1.899442e-03,  5.438313e-01, -1.205331e+00,  9.568012e-03},
  { 8.842458e-01, -4.576703e-01,  9.299088e-02,  6.656160e-01, -1.081707e+00, -6.765378e-02},
  { 9.247438e-01,  2.561333e-01,  2.815043e-01,  5.533361e-01, -4.388643e-01,  3.345421e-03},
  { 7.895769e-01,  5.657222e-01,  2.377539e-01,  5.336003e-01, -4.141395e-01,  1.581966e-02},
  { 9.023256e-01, -2.679088e-01,  3.376884e-01,  5.202853e-01, -3.894148e-01,  2.422561e-02},
  { 7.452692e-01, -6.656798e-01,  3.800355e-02,  5.644251e-01, -3.646901e-01, -3.522564e-03},
  { 9.529426e-01, -2.971933e-01,  5.980580e-02,  5.785890e-01, -3.399654e-01, -1.254887e-02},
  { 9.910214e-01,  1.636252e-02,  1.326986e-01,  5.812054e-01, -3.276030e-01, -1.422498e-02},
  { 7.667775e-01,  5.616217e-01, -3.108591e-01,  5.215075e-01,  2.163405e-01,  2.362062e-02},
  { 7.947596e-01,  5.651498e-01, -2.212759e-01,  4.493114e-01,  3.523267e-01,  6.933638e-02},
  { 8.073665e-01,  3.298408e-01, -4.892488e-01,  4.401177e-01,  3.646892e-01,  7.524228e-02},
  { 6.824715e-01,  2.518541e-02, -7.304782e-01,  4.407163e-01,  3.770515e-01,  7.488898e-02},
  { 5.526756e-01,  1.567835e-01, -8.185161e-01,  4.428646e-01,  4.388637e-01,  7.355750e-02},
  { 2.858602e-01,  8.889909e-01, -3.577417e-01,  3.939596e-01,  5.006756e-01,  1.044332e-01},
  { 4.679964e-01, -1.238618e-01, -8.750073e-01,  3.731176e-01,  5.130381e-01,  1.177827e-01},
  { 5.483588e-01, -7.837458e-01, -2.916252e-01,  5.603530e-01,  7.231982e-01, -8.188842e-04},
  { 7.672126e-01, -3.842957e-01, -5.135189e-01,  6.077034e-01,  7.973725e-01, -3.085601e-02},
  { 7.076692e-01,  6.108186e-01, -3.551127e-01,  5.273229e-01,  1.131156e+00,  1.996075e-02},
  { 7.480330e-01,  5.952493e-01, -2.934707e-01,  5.005777e-01,  1.168243e+00,  3.689293e-02},
  { 6.849347e-01,  6.195430e-01, -3.834462e-01,  4.758377e-01,  1.205330e+00,  5.262329e-02},
  { 7.849779e-01, -5.726620e-01,  2.363642e-01,  5.393681e-01, -1.205331e+00,  3.543244e-02},
  { 7.680101e-01, -5.507689e-01,  3.268244e-01,  6.293312e-01, -1.118794e+00, -1.997741e-02},
  { 8.855990e-01, -3.844833e-01,  2.605513e-01,  6.520942e-01, -1.094069e+00, -3.399851e-02},
  { 9.627926e-01,  1.344654e-01,  2.344130e-01,  6.866205e-01, -9.333581e-01, -5.529184e-02},
  { 9.793885e-01,  6.643293e-02,  1.907485e-01,  5.036063e-01, -4.017772e-01,  5.764318e-02},
  { 7.702085e-01, -6.372488e-01,  2.632029e-02,  5.047642e-01, -3.894148e-01,  5.692969e-02},
  { 5.557047e-01, -8.000060e-01,  2.262354e-01,  5.363922e-01, -3.770525e-01,  3.734950e-02},
  { 7.744130e-01, -6.041388e-01,  1.878851e-01,  5.590324e-01, -3.646901e-01,  2.337850e-02},
  { 9.669660e-01, -8.129580e-02,  2.415942e-01,  5.754223e-01, -2.905157e-01,  1.323946e-02},
  { 9.878434e-01,  1.057894e-01, -1.139031e-01,  5.499688e-01, -1.298047e-01,  2.900120e-02},
  { 7.851330e-01,  1.186156e-02, -6.192136e-01,  5.651386e-01,  1.174429e-01,  1.973401e-02},
  { 8.836414e-01,  3.391681e-01, -3.227116e-01,  5.586842e-01,  1.668925e-01,  2.366653e-02},
  { 7.653421e-01,  6.107913e-01, -2.029427e-01,  4.620331e-01,  3.399643e-01,  8.318700e-02},
  { 8.561875e-01,  1.678979e-01, -4.886239e-01,  4.515084e-01,  3.523267e-01,  8.974411e-02},
  { 7.534096e-01, -2.134540e-02, -6.572049e-01,  4.533014e-01,  3.646892e-01,  8.866525e-02},
  { 4.605094e-01,  6.364365e-01, -6.187726e-01,  4.455093e-01,  4.759509e-01,  9.344060e-02},
  { 4.655485e-01,  7.187823e-01, -5.163491e-01,  4.073039e-01,  5.006756e-01,  1.169812e-01},
  { 3.419684e-01,  5.703807e-01, -7.468089e-01,  3.939572e-01,  5.130381e-01,  1.253537e-01},
  { 5.290713e-01, -6.061815e-01, -5.938244e-01,  4.090932e-01,  5.377627e-01,  1.158788e-01},
  { 5.021399e-01, -4.439501e-01, -7.421346e-01,  4.442256e-01,  6.119370e-01,  9.432510e-02},
  { 4.397398e-01, -7.583270e-01, -4.812161e-01,  5.071151e-01,  6.861111e-01,  5.555264e-02},
  { 8.696072e-01, -2.287041e-01, -4.375817e-01,  6.211776e-01,  8.097348e-01, -1.480476e-02},
  { 8.841203e-01,  2.686816e-01, -3.822844e-01,  6.211911e-01,  9.457207e-01, -1.483902e-02},
  { 7.667222e-01,  5.390912e-01, -3.485939e-01,  4.882402e-01,  1.205330e+00,  6.711119e-02},
  { 8.077645e-01, -4.521676e-01,  3.782339e-01,  5.550271e-01, -1.168244e+00,  4.894815e-02},
  { 7.538161e-01, -5.641630e-01,  3.368701e-01,  5.647429e-01, -1.155881e+00,  4.310352e-02},
  { 8.817382e-01,  3.744600e-01,  2.869100e-01,  5.344238e-01, -4.388643e-01,  6.123366e-02},
  { 9.750900e-01,  6.992394e-02,  2.104999e-01,  4.987184e-01, -4.017772e-01,  8.271562e-02},
  { 7.782559e-01, -6.278973e-01, -7.917037e-03,  5.129943e-01, -3.894148e-01,  7.428080e-02},
  { 6.625188e-01, -7.304574e-01,  1.658343e-01,  5.267518e-01, -3.770525e-01,  6.595844e-02},
  { 7.974562e-01, -4.854410e-01,  3.583442e-01,  5.579436e-01, -3.523277e-01,  4.716938e-02},
  { 9.715669e-01, -1.390259e-01,  1.916497e-01,  5.630394e-01, -3.399654e-01,  4.410797e-02},
  { 9.635762e-01,  7.169628e-02, -2.576444e-01,  5.508085e-01, -9.271762e-02,  5.156295e-02},
  { 9.822914e-01, -6.759226e-02, -1.747421e-01,  5.546715e-01, -1.854320e-02,  4.927720e-02},
  { 9.392721e-01, -2.920824e-01, -1.801548e-01,  5.574198e-01,  1.854389e-02,  4.765804e-02},
  { 8.620002e-01, -2.334642e-01, -4.499447e-01,  5.658722e-01,  5.563099e-02,  4.263291e-02},
  { 6.410234e-01, -3.065044e-01, -7.036647e-01,  5.699611e-01,  6.799346e-02,  4.018731e-02},
  { 6.904878e-01,  2.882491e-01, -6.634297e-01,  5.755213e-01,  1.421678e-01,  3.681311e-02},
  { 7.379895e-01,  3.687509e-01, -5.651497e-01,  5.681009e-01,  1.668925e-01,  4.123647e-02},
  { 7.433515e-01,  5.798409e-01, -3.334861e-01,  5.379592e-01,  2.163405e-01,  5.928715e-02},
  { 7.402645e-01,  5.904453e-01, -3.215320e-01,  5.005800e-01,  2.905149e-01,  8.166904e-02},
  { 7.950749e-01,  5.522019e-01, -2.508563e-01,  4.758149e-01,  3.276020e-01,  9.649738e-02},
  { 7.973031e-01,  3.107679e-01, -5.174274e-01,  4.663383e-01,  3.399643e-01,  1.022445e-01},
  { 7.284129e-01,  9.342675e-02, -6.787386e-01,  4.640056e-01,  3.523267e-01,  1.036426e-01},
  { 5.129445e-01, -2.398956e-01, -8.242196e-01,  4.682394e-01,  3.646892e-01,  1.011753e-01},
  { 4.976639e-01,  2.511260e-02, -8.670063e-01,  4.799527e-01,  4.265016e-01,  9.416636e-02},
  { 4.815342e-01,  6.009933e-01, -6.379120e-01,  4.172435e-01,  5.006756e-01,  1.316699e-01},
  { 3.464896e-01, -1.949409e-01, -9.175745e-01,  4.187279e-01,  5.130381e-01,  1.307801e-01},
  { 3.641412e-01, -3.239568e-01, -8.731856e-01,  4.254425e-01,  5.377627e-01,  1.268650e-01},
  { 4.387421e-01, -4.744949e-01, -7.631251e-01,  4.284834e-01,  5.501251e-01,  1.249332e-01},
  { 5.432261e-01, -7.512490e-01, -3.748737e-01,  5.297322e-01,  6.984736e-01,  6.432118e-02},
  { 9.274657e-01,  1.011146e-01, -3.599768e-01,  6.342022e-01,  9.086336e-01,  1.599306e-03},
  { 7.951690e-01,  5.570005e-01, -2.397015e-01,  4.918932e-01,  1.205330e+00,  8.692795e-02},
  { 9.584838e-01,  6.581850e-02,  2.774469e-01,  6.730258e-01, -9.704455e-01,  2.915572e-03},
  { 8.994695e-01,  3.132163e-01,  3.047134e-01,  5.188607e-01, -4.265019e-01,  9.276409e-02},
  { 8.892834e-01,  3.954207e-01,  2.298209e-01,  4.966461e-01, -4.017772e-01,  1.059031e-01},
  { 7.703196e-01, -5.411878e-01,  3.372289e-01,  5.030626e-01, -3.894148e-01,  1.020194e-01},
  { 9.156092e-01, -1.968302e-01,  3.505963e-01,  5.585039e-01, -3.028781e-01,  6.969921e-02},
  { 9.949887e-01, -6.104235e-02,  7.919112e-02,  5.628515e-01, -2.410662e-01,  6.720848e-02},
  { 9.980129e-01,  2.296841e-02, -5.867383e-02,  5.604864e-01, -1.916168e-01,  6.861412e-02},
  { 9.478354e-01,  1.873569e-02, -3.182090e-01,  5.561301e-01, -8.035525e-02,  7.121068e-02},
  { 8.990332e-01, -1.097704e-01, -4.238982e-01,  5.566022e-01, -6.799289e-02,  7.093551e-02},
  { 8.040192e-01, -7.361894e-02, -5.900284e-01,  5.618703e-01, -1.854320e-02,  6.790227e-02},
  { 8.108125e-01, -6.483871e-02, -5.817036e-01,  5.607314e-01, -6.180837e-03,  6.855433e-02},
  { 7.438810e-01, -3.333333e-01, -5.792496e-01,  5.659650e-01,  1.854389e-02,  6.550410e-02},
  { 6.013496e-01, -3.680134e-01, -7.091860e-01,  5.732638e-01,  3.090626e-02,  6.132415e-02},
  { 7.087526e-01, -1.034970e-01, -6.978238e-01,  5.930321e-01,  1.050806e-01,  4.977804e-02},
  { 6.801966e-01,  5.038130e-01, -5.324519e-01,  5.804060e-01,  1.668925e-01,  5.708371e-02},
  { 8.221877e-01,  2.959838e-01, -4.862109e-01,  4.797706e-01,  3.276020e-01,  1.157384e-01},
  { 7.718303e-01,  6.992004e-02, -6.319726e-01,  4.780616e-01,  3.399643e-01,  1.167343e-01},
  { 5.714874e-01, -2.479519e-01, -7.822544e-01,  4.819392e-01,  3.523267e-01,  1.145409e-01},
  { 5.235572e-01, -2.736167e-01, -8.068593e-01,  4.987302e-01,  4.017763e-01,  1.047890e-01},
  { 4.270105e-01, -2.148779e-02, -9.039913e-01,  5.001542e-01,  4.141386e-01,  1.039520e-01},
  { 2.927314e-01,  6.407490e-01, -7.097528e-01,  4.853308e-01,  4.759509e-01,  1.125535e-01},
  { 3.594006e-01, -2.367596e-01, -9.026495e-01,  4.458393e-01,  5.254002e-01,  1.356321e-01},
  { 3.657159e-01, -4.711857e-01, -8.026430e-01,  4.580113e-01,  5.624875e-01,  1.285311e-01},
  { 4.425944e-01, -4.261747e-01, -7.889775e-01,  4.786186e-01,  5.872122e-01,  1.165271e-01},
  { 4.446632e-01, -3.217903e-01, -8.358982e-01,  4.871625e-01,  6.242992e-01,  1.115458e-01},
  { 6.693875e-01, -6.677169e-01, -3.256908e-01,  6.145893e-01,  7.602853e-01,  3.717770e-02},
  { 9.059351e-01,  3.900907e-01,  1.646536e-01,  5.098642e-01, -4.265019e-01,  1.197532e-01},
  { 7.214737e-01,  6.861881e-01,  9.285240e-02,  4.913851e-01, -4.017772e-01,  1.302629e-01},
  { 9.681231e-01, -1.197445e-01,  2.199973e-01,  4.732732e-01, -3.894148e-01,  1.406574e-01},
  { 7.689304e-01, -5.502646e-01,  3.255070e-01,  5.172570e-01, -3.646901e-01,  1.156068e-01},
  { 9.465299e-01, -2.976308e-01,  1.244870e-01,  5.508991e-01, -3.028781e-01,  9.656600e-02},
  { 9.902923e-01, -1.384270e-01,  1.261993e-02,  5.573081e-01, -2.781533e-01,  9.295618e-02},
  { 8.226957e-01, -1.922171e-01, -5.349994e-01,  5.667583e-01, -5.563052e-02,  8.772831e-02},
  { 6.714436e-01, -2.306011e-01, -7.042632e-01,  5.752913e-01, -1.854320e-02,  8.293805e-02},
  { 5.291538e-01, -2.526520e-01, -8.100390e-01,  5.789277e-01, -6.180837e-03,  8.089725e-02},
  { 7.647066e-01,  1.716762e-01, -6.210886e-01,  6.075472e-01,  1.174429e-01,  6.462655e-02},
  { 7.394480e-01,  2.983417e-01, -6.034973e-01,  6.026061e-01,  1.421678e-01,  6.740672e-02},
  { 6.558195e-01,  5.871867e-01, -4.744601e-01,  5.714998e-01,  2.039797e-01,  8.499216e-02},
  { 5.646545e-01,  6.825071e-01, -4.640575e-01,  5.622330e-01,  2.163405e-01,  9.023728e-02},
  { 7.329974e-01,  6.464896e-01, -2.115802e-01,  5.045694e-01,  3.028772e-01,  1.228631e-01},
  { 8.466741e-01,  4.040102e-01, -3.462928e-01,  4.955388e-01,  3.152396e-01,  1.280443e-01},
  { 8.691640e-01,  2.513925e-01, -4.258589e-01,  4.911540e-01,  3.276020e-01,  1.305495e-01},
  { 6.771168e-01, -2.286656e-01, -6.994461e-01,  4.942791e-01,  3.399643e-01,  1.288142e-01},
  { 3.807907e-01,  4.045579e-01, -8.314633e-01,  5.110281e-01,  4.759509e-01,  1.192701e-01},
  { 3.449858e-01,  2.841845e-01, -8.945524e-01,  4.697235e-01,  5.006756e-01,  1.426682e-01},
  { 4.751619e-01, -1.568455e-01, -8.658064e-01,  4.697001e-01,  5.501251e-01,  1.427829e-01},
  { 5.015422e-01, -5.837016e-01, -6.385514e-01,  4.762891e-01,  5.624875e-01,  1.390477e-01},
  { 4.520265e-01, -5.724814e-01, -6.840593e-01,  4.988810e-01,  5.872122e-01,  1.262584e-01},
  { 4.570652e-01, -2.655521e-01, -8.488660e-01,  5.048961e-01,  5.995746e-01,  1.228517e-01},
  { 5.429698e-01, -7.022834e-01, -4.604150e-01,  5.574633e-01,  6.984736e-01,  9.304415e-02},
  { 3.954912e-01, -8.252346e-01, -4.032054e-01,  5.855736e-01,  7.231982e-01,  7.713567e-02},
  { 4.209683e-01, -7.110555e-01, -5.631925e-01,  6.017043e-01,  7.355605e-01,  6.799452e-02},
  { 5.702662e-01, -5.804864e-01, -5.812332e-01,  6.103101e-01,  7.479229e-01,  6.302930e-02},
  { 6.794072e-01, -6.152406e-01, -3.998561e-01,  6.217652e-01,  7.602853e-01,  5.656809e-02},
  { 7.883863e-01, -5.403387e-01, -2.940769e-01,  6.309496e-01,  7.726477e-01,  5.134505e-02},
  { 8.602731e-01, -3.829985e-01, -3.365151e-01,  6.375054e-01,  7.850100e-01,  4.761738e-02},
  { 8.731765e-01, -2.518697e-01,  4.172822e-01,  6.388332e-01, -1.007533e+00,  7.018011e-02},
  { 9.245828e-01,  3.723978e-01, -8.041487e-02,  5.277665e-01, -4.883140e-01,  1.313852e-01},
  { 9.221390e-01,  3.862856e-01, -2.105047e-02,  4.802254e-01, -3.894148e-01,  1.576717e-01},
  { 7.849839e-01, -5.774532e-01,  2.243838e-01,  4.861821e-01, -3.770525e-01,  1.543933e-01},
  { 7.943057e-01, -5.827624e-01,  1.716583e-01,  5.267516e-01, -3.399654e-01,  1.319681e-01},
  { 9.199026e-01, -3.844575e-01,  7.727742e-02,  5.518560e-01, -2.905157e-01,  1.181828e-01},
  { 9.659905e-01, -2.395998e-01, -9.723290e-02,  5.614378e-01, -2.534286e-01,  1.129170e-01},
  { 8.512641e-01, -2.041277e-02, -5.243403e-01,  5.738891e-01, -9.271762e-02,  1.061444e-01},
  { 7.514461e-01,  4.636286e-01, -4.694435e-01,  6.053689e-01,  1.668925e-01,  8.878606e-02},
  { 8.822036e-01,  3.946792e-01, -2.567978e-01,  5.053520e-01,  3.028772e-01,  1.438427e-01},
  { 8.671138e-01,  1.314706e-01, -4.804467e-01,  5.016695e-01,  3.152396e-01,  1.458693e-01},
  { 7.389827e-01, -1.837578e-01, -6.481803e-01,  5.027526e-01,  3.276020e-01,  1.452731e-01},
  { 5.910828e-01, -7.665468e-02, -8.029603e-01,  5.372058e-01,  4.141386e-01,  1.263817e-01},
  { 4.605229e-01,  3.749023e-01, -8.045911e-01,  5.301534e-01,  4.759509e-01,  1.301924e-01},
  { 2.518781e-01,  2.791556e-01, -9.266227e-01,  4.859655e-01,  5.006756e-01,  1.545125e-01},
  { 2.390365e-01, -1.352994e-01, -9.615381e-01,  4.910918e-01,  5.130381e-01,  1.518278e-01},
  { 2.725115e-01,  1.848179e-01, -9.442350e-01,  4.913919e-01,  5.377627e-01,  1.516517e-01},
  { 4.879556e-01,  4.601128e-02, -8.716550e-01,  4.896082e-01,  5.501251e-01,  1.525947e-01},
  { 5.936719e-01, -5.746588e-01, -5.633126e-01,  4.916441e-01,  5.624875e-01,  1.514624e-01},
  { 5.362855e-01, -5.166774e-01, -6.674146e-01,  5.221425e-01,  5.995746e-01,  1.346910e-01},
  { 4.691156e-01, -4.360912e-01, -7.679551e-01,  5.324044e-01,  6.366616e-01,  1.290673e-01},
  { 5.649732e-01, -5.903081e-01, -5.764907e-01,  5.510214e-01,  6.613864e-01,  1.188032e-01},
  { 5.646524e-01, -7.112967e-01, -4.185984e-01,  5.809991e-01,  7.108357e-01,  1.022819e-01},
  { 4.705201e-01, -8.579824e-01, -2.060998e-01,  5.953730e-01,  7.231982e-01,  9.436571e-02},
  { 5.788366e-01, -7.963572e-01, -1.753949e-01,  6.234031e-01,  7.355605e-01,  7.887003e-02},
  { 7.723060e-01, -5.144610e-01, -3.726573e-01,  6.355330e-01,  7.479229e-01,  7.219383e-02},
  { 8.324134e-01, -3.675008e-01, -4.147663e-01,  6.360747e-01,  7.602853e-01,  7.189575e-02},
  { 8.507487e-01, -3.791742e-01, -3.639416e-01,  6.388454e-01,  7.726477e-01,  7.037141e-02},
  { 9.333332e-01, -2.875898e-01, -2.148985e-01,  6.472651e-01,  7.973725e-01,  6.571198e-02},
  { 9.677703e-01, -4.418262e-02, -2.479283e-01,  6.522354e-01,  8.344595e-01,  6.295940e-02},
  { 8.803571e-01,  4.444678e-01, -1.655895e-01,  6.137898e-01,  1.032257e+00,  8.407777e-02},
  { 8.952754e-01, -1.813671e-01,  4.069251e-01,  6.227610e-01, -1.007533e+00,  1.019660e-01},
  { 9.552765e-01,  6.127771e-02,  2.892955e-01,  6.333625e-01, -8.715463e-01,  9.632127e-02},
  { 9.675854e-01,  2.517328e-01,  2.022382e-02,  5.715224e-01, -6.490249e-01,  1.294444e-01},
  { 8.880159e-01,  4.462133e-01, -1.110018e-01,  5.032876e-01, -4.388643e-01,  1.659202e-01},
  { 8.200632e-01,  5.471509e-01, -1.676967e-01,  4.811299e-01, -3.894148e-01,  1.777983e-01},
  { 9.014052e-01, -4.328340e-01, -1.110649e-02,  4.722365e-01, -3.770525e-01,  1.826131e-01},
  { 6.209177e-01, -7.828798e-01, -3.950313e-02,  5.125130e-01, -3.523277e-01,  1.610613e-01},
  { 7.908329e-01, -6.099570e-01, -5.035605e-02,  5.239949e-01, -3.399654e-01,  1.549215e-01},
  { 8.823838e-01, -7.846530e-02, -4.639418e-01,  5.840718e-01, -1.050800e-01,  1.228781e-01},
  { 4.597262e-01, -3.639390e-01, -8.100619e-01,  6.287214e-01,  6.181527e-03,  9.909204e-02},
  { 7.593933e-01,  2.096936e-01, -6.159142e-01,  6.346846e-01,  1.174429e-01,  9.580127e-02},
  { 7.089289e-01,  6.831335e-01, -1.753522e-01,  5.208545e-01,  2.905149e-01,  1.565684e-01},
  { 8.679833e-01,  2.253636e-01, -4.425112e-01,  5.106139e-01,  3.028772e-01,  1.621005e-01},
  { 8.015180e-01, -2.002798e-01, -5.634332e-01,  5.140556e-01,  3.152396e-01,  1.602957e-01},
  { 6.484467e-01, -3.383979e-01, -6.819118e-01,  5.181153e-01,  3.276020e-01,  1.581531e-01},
  { 6.435383e-01,  5.909822e-02, -7.631290e-01,  5.495331e-01,  4.635885e-01,  1.413353e-01},
  { 7.955219e-01,  3.180391e-01, -5.157479e-01,  5.461569e-01,  4.759509e-01,  1.431031e-01},
  { 7.652593e-01,  4.071662e-01, -4.985919e-01,  5.452847e-01,  4.883133e-01,  1.435692e-01},
  { 2.075822e-01,  5.572057e-01, -8.040096e-01,  5.248966e-01,  5.006756e-01,  1.544666e-01},
  { 1.897996e-01, -1.139351e-01, -9.751897e-01,  5.231178e-01,  5.130381e-01,  1.555467e-01},
  { 4.549831e-01,  2.282849e-02, -8.902075e-01,  5.270773e-01,  5.254002e-01,  1.533011e-01},
  { 4.715711e-01,  5.019916e-01, -7.250001e-01,  5.280585e-01,  5.377627e-01,  1.527765e-01},
  { 6.565296e-01,  4.200233e-01, -6.265376e-01,  5.100690e-01,  5.501251e-01,  1.623918e-01},
  { 7.326141e-01, -9.805923e-02, -6.735435e-01,  5.059258e-01,  5.624875e-01,  1.646062e-01},
  { 6.525666e-01, -7.081947e-01, -2.694757e-01,  5.117369e-01,  5.748498e-01,  1.615594e-01},
  { 5.355456e-01, -5.403072e-01, -6.490448e-01,  5.379540e-01,  5.995746e-01,  1.475715e-01},
  { 5.738282e-01, -4.648566e-01, -6.742623e-01,  5.667773e-01,  6.613864e-01,  1.321630e-01},
  { 6.765978e-01, -5.470902e-01, -4.928568e-01,  5.829354e-01,  6.984736e-01,  1.234999e-01},
  { 6.236677e-01, -7.020411e-01, -3.437688e-01,  5.921783e-01,  7.108357e-01,  1.185684e-01},
  { 6.652871e-01, -6.937535e-01, -2.758608e-01,  6.200775e-01,  7.355605e-01,  1.035929e-01},
  { 8.453462e-01, -5.290534e-01, -7.410868e-02,  6.245475e-01,  7.479229e-01,  1.012037e-01},
  { 8.461549e-01, -5.226210e-01, -1.043514e-01,  6.337059e-01,  7.602853e-01,  9.630869e-02},
  { 9.132512e-01, -3.732969e-01, -1.631619e-01,  6.438636e-01,  7.726477e-01,  9.086452e-02},
  { 8.248746e-01, -4.809049e-01,  2.971738e-01,  5.293181e-01, -1.155881e+00,  1.731641e-01},
  { 9.168193e-01, -1.796479e-01,  3.566075e-01,  6.199778e-01, -9.704455e-01,  1.260614e-01},
  { 8.973123e-01,  3.820122e-01, -2.211273e-01,  5.322376e-01, -4.883140e-01,  1.717211e-01},
  { 7.554528e-01,  4.278416e-01, -4.962284e-01,  4.969351e-01, -4.141395e-01,  1.900555e-01},
  { 7.384610e-01,  4.314274e-01, -5.182139e-01,  4.883474e-01, -3.894148e-01,  1.945331e-01},
  { 7.277728e-01, -9.652779e-03, -6.857504e-01,  4.821597e-01, -3.770525e-01,  1.977416e-01},
  { 6.692679e-01, -6.669650e-01, -3.274724e-01,  5.290524e-01, -3.399654e-01,  1.734497e-01},
  { 9.207037e-01, -2.009526e-01, -3.345485e-01,  5.767338e-01, -2.039791e-01,  1.486627e-01},
  { 6.192352e-01, -1.580531e-01, -7.691339e-01,  6.535985e-01,  3.090626e-02,  1.088625e-01},
  { 6.835699e-01, -8.420448e-02, -7.250115e-01,  6.556832e-01,  5.563099e-02,  1.077648e-01},
  { 8.803628e-01,  3.150080e-01, -3.545860e-01,  5.250656e-01,  2.905149e-01,  1.754811e-01},
  { 7.996472e-01, -6.040015e-02, -5.974246e-01,  5.222127e-01,  3.028772e-01,  1.769613e-01},
  { 6.877062e-01, -2.900928e-01, -6.655121e-01,  5.638360e-01,  3.894139e-01,  1.554223e-01},
  { 6.632523e-01,  5.914222e-01, -4.586024e-01,  5.562412e-01,  4.759509e-01,  1.592931e-01},
  { 8.091237e-01,  5.706555e-01, -1.402538e-01,  5.442692e-01,  4.883133e-01,  1.655180e-01},
  { 9.886823e-01,  1.472891e-01,  2.851402e-02,  5.460249e-01,  5.006756e-01,  1.646070e-01},
  { 7.293762e-01,  2.864863e-01, -6.212375e-01,  5.475612e-01,  5.254002e-01,  1.638100e-01},
  { 7.479694e-01,  6.475322e-01, -1.457518e-01,  5.329666e-01,  5.377627e-01,  1.713819e-01},
  { 8.199035e-01,  4.094056e-01, -4.001817e-01,  5.118976e-01,  5.501251e-01,  1.823129e-01},
  { 8.093894e-01, -3.944763e-01, -4.350601e-01,  5.140923e-01,  5.624875e-01,  1.811743e-01},
  { 5.152091e-01, -8.091971e-01, -2.824173e-01,  5.330434e-01,  5.872122e-01,  1.714022e-01},
  { 6.098104e-01, -5.755596e-01, -5.448509e-01,  5.597737e-01,  6.119370e-01,  1.575437e-01},
  { 6.655962e-01, -6.122388e-01, -4.267850e-01,  6.029190e-01,  7.108357e-01,  1.351446e-01},
  { 7.814242e-01, -4.935546e-01, -3.818116e-01,  6.441621e-01,  7.602853e-01,  1.137136e-01},
  { 8.779639e-01, -3.549964e-01, -3.211806e-01,  6.498805e-01,  7.726477e-01,  1.107245e-01},
  { 8.590515e-01,  5.075155e-01, -6.677179e-02,  5.171713e-01,  1.205330e+00,  1.794958e-01},
  { 8.460262e-01, -4.845821e-01,  2.223059e-01,  5.125411e-01, -1.168244e+00,  2.025239e-01},
  { 9.286515e-01,  2.530511e-01, -2.712410e-01,  5.567121e-01, -5.624881e-01,  1.803399e-01},
  { 7.727028e-01,  3.543415e-01, -5.266616e-01,  5.299314e-01, -4.635892e-01,  1.938712e-01},
  { 5.950550e-01,  2.440932e-01, -7.657206e-01,  5.104012e-01, -4.141395e-01,  2.037435e-01},
  { 4.729470e-01, -1.918302e-01, -8.599548e-01,  5.021756e-01, -3.770525e-01,  2.078404e-01},
  { 7.840284e-01, -4.383136e-01, -4.395233e-01,  5.551232e-01, -3.152404e-01,  1.812125e-01},
  { 8.260759e-01, -4.212700e-01, -3.743397e-01,  5.655314e-01, -2.905157e-01,  1.759495e-01},
  { 8.849093e-01, -2.338968e-01, -4.027750e-01,  5.909168e-01, -1.668918e-01,  1.631832e-01},
  { 7.503247e-01, -3.445074e-01, -5.642052e-01,  6.017103e-01, -1.298047e-01,  1.577892e-01},
  { 8.291893e-01,  2.016988e-01, -5.213086e-01,  6.657318e-01,  9.271819e-02,  1.255279e-01},
  { 8.189954e-01, -2.484960e-01, -5.172004e-01,  5.342374e-01,  3.028772e-01,  1.917225e-01},
  { 6.507200e-01,  5.774558e-01, -4.930601e-01,  5.775647e-01,  4.635885e-01,  1.698942e-01},
  { 9.618818e-01,  1.720391e-01, -2.125697e-01,  5.316589e-01,  5.006756e-01,  1.930003e-01},
  { 9.362958e-01,  2.682768e-01, -2.266666e-01,  5.250332e-01,  5.377627e-01,  1.963352e-01},
  { 7.483879e-01,  1.389947e-01, -6.485337e-01,  5.228249e-01,  5.501251e-01,  1.974469e-01},
  { 6.316258e-01, -5.034704e-01, -5.895475e-01,  5.316589e-01,  5.748498e-01,  1.930003e-01},
  { 4.495569e-01, -7.498540e-01, -4.854044e-01,  5.434436e-01,  5.872122e-01,  1.871589e-01},
  { 4.436550e-01, -6.979251e-01, -5.622018e-01,  5.598170e-01,  5.995746e-01,  1.788271e-01},
  { 7.141662e-01, -4.045893e-01, -5.712040e-01,  5.937993e-01,  6.613864e-01,  1.617669e-01},
  { 7.445632e-01, -6.084769e-01, -2.745568e-01,  6.383452e-01,  7.355605e-01,  1.393311e-01},
  { 9.488639e-01, -2.557055e-01, -1.851274e-01,  6.590974e-01,  7.850100e-01,  1.288217e-01},
  { 9.910792e-01, -1.229586e-02, -1.327063e-01,  6.612529e-01,  8.468218e-01,  1.276997e-01},
  { 9.765394e-01,  2.149012e-01, -1.372101e-02,  6.492128e-01,  9.333584e-01,  1.337402e-01},
  { 8.638934e-01, -3.967239e-01,  3.103195e-01,  5.203928e-01, -1.143519e+00,  2.190776e-01},
  { 9.958088e-01,  8.870608e-02,  2.227471e-02,  5.802521e-01, -6.984744e-01,  1.898727e-01},
  { 9.863400e-01,  1.606075e-01, -3.658662e-02,  5.624028e-01, -5.748505e-01,  1.986353e-01},
  { 9.815962e-01,  1.582246e-01,  1.069287e-01,  5.567558e-01, -5.254011e-01,  2.014024e-01},
  { 9.209696e-01,  2.092560e-01, -3.286745e-01,  5.483699e-01, -4.883140e-01,  2.055121e-01},
  { 7.473724e-01,  2.684896e-01, -6.077399e-01,  5.421276e-01, -4.635892e-01,  2.085828e-01},
  { 4.424071e-01, -1.614280e-01, -8.821660e-01,  5.272861e-01, -3.770525e-01,  2.159261e-01},
  { 4.452937e-01, -4.874933e-01, -7.510418e-01,  5.339617e-01, -3.646901e-01,  2.126631e-01},
  { 6.081659e-01, -5.530952e-01, -5.694030e-01,  5.437090e-01, -3.523277e-01,  2.078800e-01},
  { 7.656760e-01, -3.576545e-01, -5.346245e-01,  6.034031e-01, -1.545294e-01,  1.786996e-01},
  { 7.015425e-01, -2.842135e-01, -6.534989e-01,  6.742501e-01, -1.854320e-02,  1.441443e-01},
  { 9.021213e-01,  1.995472e-01, -3.825678e-01,  6.732129e-01,  1.050806e-01,  1.445864e-01},
  { 8.038145e-01,  4.582201e-01, -3.793633e-01,  6.586245e-01,  1.421678e-01,  1.516932e-01},
  { 6.741446e-01,  7.073453e-01, -2.125830e-01,  5.721330e-01,  2.534277e-01,  1.938552e-01},
  { 8.478685e-01,  2.214497e-01, -4.817457e-01,  5.880193e-01,  4.635885e-01,  1.861761e-01},
  { 5.998734e-01,  7.758422e-01, -1.955014e-01,  5.780746e-01,  4.759509e-01,  1.909669e-01},
  { 6.303881e-01,  7.302551e-01, -2.633220e-01,  5.618002e-01,  4.883133e-01,  1.989726e-01},
  { 6.019875e-01,  2.503371e-01, -7.582495e-01,  5.428024e-01,  5.006756e-01,  2.082445e-01},
  { 3.014539e-01, -1.195335e-01, -9.459584e-01,  5.494617e-01,  5.130381e-01,  2.050982e-01},
  { 2.718435e-01,  1.976903e-01, -9.418172e-01,  5.451042e-01,  5.501251e-01,  2.072300e-01},
  { 4.912690e-01,  1.079379e-01, -8.642941e-01,  5.422469e-01,  5.624875e-01,  2.085156e-01},
  { 4.515710e-01, -8.120175e-01, -3.697446e-01,  5.653552e-01,  5.872122e-01,  1.972374e-01},
  { 5.711126e-01, -6.523276e-01, -4.982962e-01,  5.823532e-01,  5.995746e-01,  1.889416e-01},
  { 7.903181e-01, -4.026007e-01, -4.618550e-01,  5.856863e-01,  6.119370e-01,  1.873149e-01},
  { 8.280581e-01, -3.940910e-01, -3.987631e-01,  5.891600e-01,  6.242992e-01,  1.856512e-01},
  { 7.774113e-01, -5.844656e-01, -2.324471e-01,  6.203988e-01,  7.108357e-01,  1.703995e-01},
  { 7.204408e-01, -6.714712e-01, -1.734688e-01,  6.438272e-01,  7.355605e-01,  1.589439e-01},
  { 8.108761e-01, -5.278766e-01,  2.526385e-01,  4.665542e-01, -1.205331e+00,  2.647249e-01},
  { 8.976823e-01, -3.335586e-01,  2.879325e-01,  5.535892e-01, -1.056982e+00,  2.236435e-01},
  { 6.210936e-01,  5.217511e-03, -7.837191e-01,  5.436711e-01, -4.017772e-01,  2.285069e-01},
  { 5.726805e-01, -2.877408e-01, -7.676212e-01,  5.466111e-01, -3.770525e-01,  2.271314e-01},
  { 6.981215e-01, -3.667921e-01, -6.148902e-01,  5.562153e-01, -3.523277e-01,  2.225618e-01},
  { 8.289595e-01,  5.378564e-01, -1.534166e-01,  5.520381e-01,  2.781524e-01,  2.244259e-01},
  { 8.219063e-01, -4.042767e-01, -4.012859e-01,  5.512896e-01,  3.028772e-01,  2.248558e-01},
  { 8.768549e-01, -2.330897e-01, -4.204695e-01,  5.970094e-01,  4.017763e-01,  2.032114e-01},
  { 8.283482e-01,  4.613997e-01, -3.177255e-01,  5.975831e-01,  4.635885e-01,  2.029409e-01},
  { 4.998346e-01,  8.215166e-01, -2.743645e-01,  5.799257e-01,  4.759509e-01,  2.112918e-01},
  { 7.821063e-01,  5.799077e-01, -2.280722e-01,  5.599213e-01,  4.883133e-01,  2.207528e-01},
  { 9.065608e-01, -3.407513e-01, -2.490703e-01,  5.622683e-01,  5.006756e-01,  2.196428e-01},
  { 6.137316e-01, -6.889070e-01, -3.856691e-01,  5.772435e-01,  5.130381e-01,  2.125604e-01},
  { 7.401439e-01, -3.637563e-01, -5.655690e-01,  5.859604e-01,  5.254002e-01,  2.084377e-01},
  { 8.199650e-01,  3.759578e-02, -5.711777e-01,  5.864075e-01,  5.377627e-01,  2.082263e-01},
  { 4.810374e-01,  5.416939e-01, -6.893263e-01,  5.832782e-01,  5.501251e-01,  2.097062e-01},
  { 5.491109e-01,  5.812204e-01, -6.005497e-01,  5.700911e-01,  5.624875e-01,  2.159431e-01},
  { 7.426131e-01, -4.158761e-01, -5.249504e-01,  5.560101e-01,  5.748498e-01,  2.226027e-01},
  { 7.926489e-01, -5.967118e-01, -1.250714e-01,  5.835394e-01,  5.995746e-01,  2.095979e-01},
  { 9.157427e-01, -3.502252e-01, -1.968699e-01,  6.543941e-01,  7.479229e-01,  1.760491e-01},
  { 6.025513e-01, -2.206560e-01, -7.669700e-01,  5.672618e-01, -3.523277e-01,  2.380497e-01},
  { 8.042928e-01, -1.835914e-01, -5.651613e-01,  5.703970e-01, -3.399654e-01,  2.365991e-01},
  { 9.075478e-01, -3.064938e-01, -2.870865e-01,  5.855235e-01, -2.657909e-01,  2.296394e-01},
  { 7.223378e-01, -4.716054e-01, -5.057831e-01,  6.078890e-01, -1.916168e-01,  2.194404e-01},
  { 7.426877e-01, -3.335882e-01, -5.806323e-01,  6.928467e-01, -4.326793e-02,  1.805320e-01},
  { 8.945894e-01,  1.173521e-01, -4.312056e-01,  7.013393e-01,  4.326862e-02,  1.766049e-01},
  { 7.793680e-01,  5.302685e-01, -3.337676e-01,  5.533346e-01,  2.781524e-01,  2.443921e-01},
  { 9.248246e-01, -1.345040e-01, -3.558204e-01,  5.517611e-01,  2.905149e-01,  2.451129e-01},
  { 6.039296e-01,  7.669956e-01, -2.167645e-01,  5.929694e-01,  4.759509e-01,  2.261853e-01},
  { 5.723490e-01,  7.364316e-01, -3.606732e-01,  5.781400e-01,  4.883133e-01,  2.330089e-01},
  { 9.045101e-01,  4.071508e-02, -4.245041e-01,  5.652487e-01,  5.006756e-01,  2.389356e-01},
  { 8.408346e-01, -5.410773e-01, -1.524395e-02,  5.722171e-01,  5.130381e-01,  2.357437e-01},
  { 9.398723e-01, -3.011442e-01,  1.610968e-01,  5.833610e-01,  5.254002e-01,  2.305813e-01},
  { 9.339938e-01,  3.571245e-01,  1.084532e-02,  5.882897e-01,  5.501251e-01,  2.283822e-01},
  { 8.527353e-01,  4.606554e-01, -2.462501e-01,  5.694073e-01,  5.624875e-01,  2.370307e-01},
  { 8.785974e-01, -7.015341e-02, -4.723826e-01,  5.687328e-01,  5.748498e-01,  2.373396e-01},
  { 6.280494e-01, -7.462108e-01, -2.207341e-01,  5.988947e-01,  6.119370e-01,  2.235447e-01},
  { 7.703984e-01, -6.350203e-01, -5.688065e-02,  6.525251e-01,  7.355605e-01,  1.989744e-01},
  { 9.591570e-01, -2.820798e-01,  2.118299e-02,  6.575027e-01,  7.479229e-01,  1.966684e-01},
  { 9.696537e-01, -1.465923e-01,  1.956593e-01,  6.610769e-01,  7.602853e-01,  1.950114e-01},
  { 9.982241e-01, -3.082309e-02, -5.097568e-02,  6.630574e-01,  7.973725e-01,  1.940757e-01},
  { 9.991612e-01,  3.920524e-02, -1.182590e-02,  6.632717e-01,  8.097348e-01,  1.939713e-01},
  { 9.771678e-01,  1.390713e-01,  1.606303e-01,  6.589327e-01,  8.468218e-01,  1.959383e-01},
  { 9.016922e-01,  4.027925e-01,  1.571917e-01,  6.097735e-01,  1.032257e+00,  2.184223e-01},
  { 8.769644e-01, -1.937898e-01,  4.397486e-01,  5.663096e-01, -9.580831e-01,  2.588355e-01},
  { 8.031925e-01, -2.664673e-02, -5.951233e-01,  5.697245e-01, -4.635892e-01,  2.574262e-01},
  { 8.764156e-01, -3.504069e-01, -3.303193e-01,  5.950332e-01, -2.534286e-01,  2.462228e-01},
  { 8.234961e-01, -3.295898e-02, -5.663638e-01,  5.607417e-01,  2.905149e-01,  2.614094e-01},
  { 8.472117e-01,  5.134180e-01, -1.365074e-01,  5.807356e-01,  4.883133e-01,  2.525416e-01},
  { 8.882951e-01,  2.971740e-01, -3.501704e-01,  5.765539e-01,  5.006756e-01,  2.543950e-01},
  { 9.271642e-01, -1.640011e-01, -3.368533e-01,  5.767791e-01,  5.130381e-01,  2.542876e-01},
  { 9.759610e-01, -2.102751e-01, -5.731251e-02,  5.781360e-01,  5.254002e-01,  2.536937e-01},
  { 9.953915e-01, -7.364786e-02,  6.141415e-02,  5.803375e-01,  5.377627e-01,  2.526527e-01},
  { 9.963099e-01,  6.443536e-02,  5.669860e-02,  5.801374e-01,  5.501251e-01,  2.527420e-01},
  { 9.602715e-01,  1.118272e-01, -2.556822e-01,  5.772319e-01,  5.624875e-01,  2.540945e-01},
  { 8.331902e-01, -3.226607e-01, -4.490927e-01,  5.794472e-01,  5.748498e-01,  2.531354e-01},
  { 6.358244e-01, -6.945027e-01, -3.367392e-01,  6.057716e-01,  6.119370e-01,  2.414736e-01},
  { 8.763085e-01, -4.585277e-01, -1.477699e-01,  6.631750e-01,  7.479229e-01,  2.159891e-01},
  { 9.768417e-01,  1.998478e-01, -7.642681e-02,  6.608973e-01,  8.344595e-01,  2.169411e-01},
  { 9.691926e-01,  2.257165e-01,  9.857874e-02,  6.376181e-01,  9.209960e-01,  2.272329e-01},
  { 9.190027e-01, -1.393112e-01,  3.688176e-01,  5.673921e-01, -9.086334e-01,  2.786450e-01},
  { 9.659930e-01, -4.635762e-02,  2.543787e-01,  5.677600e-01, -8.591840e-01,  2.784857e-01},
  { 7.008010e-01, -4.903576e-01, -5.180997e-01,  6.263327e-01, -2.039791e-01,  2.535588e-01},
  { 6.913384e-01, -4.472951e-01, -5.674312e-01,  6.884568e-01, -1.174423e-01,  2.269138e-01},
  { 8.868019e-01, -2.269171e-02, -4.615924e-01,  5.715279e-01,  3.028772e-01,  2.769759e-01},
  { 8.486698e-01, -4.398478e-01, -2.937576e-01,  6.029699e-01,  3.523267e-01,  2.634968e-01},
  { 9.825482e-01,  2.496290e-02, -1.843252e-01,  5.816866e-01,  5.006756e-01,  2.725736e-01},
  { 9.722235e-01, -1.577014e-01, -1.729499e-01,  5.832590e-01,  5.624875e-01,  2.719199e-01},
  { 7.639918e-01, -5.681787e-01, -3.057608e-01,  5.872397e-01,  5.748498e-01,  2.702499e-01},
  { 9.944903e-01, -8.493843e-02,  6.143620e-02,  5.568054e-01, -9.704455e-01,  3.031192e-01},
  { 7.665772e-01, -2.708739e-01, -5.822257e-01,  6.005329e-01, -2.905157e-01,  2.851264e-01},
  { 8.546783e-01, -3.020853e-01, -4.222196e-01,  7.190934e-01, -6.799289e-02,  2.360030e-01},
  { 9.347265e-01, -3.313872e-01, -1.283308e-01,  5.842571e-01,  5.624875e-01,  2.918193e-01},
  { 6.715631e-01, -7.132326e-01, -2.007541e-01,  5.932415e-01,  5.748498e-01,  2.881319e-01},
  { 8.397502e-01,  4.593563e-01,  2.895019e-01,  6.142603e-01,  9.704456e-01,  2.792889e-01},
  { 9.967731e-01, -7.396280e-02,  3.119220e-02,  5.642416e-01, -8.097343e-01,  3.198715e-01},
  { 6.819693e-01, -1.889926e-01, -7.065406e-01,  6.145536e-01, -2.905157e-01,  2.998992e-01},
  { 5.660034e-01, -4.229085e-01, -7.076641e-01,  6.274117e-01, -2.657909e-01,  2.947713e-01},
  { 9.029849e-01,  2.099423e-01, -3.748901e-01,  7.326155e-01,  6.799346e-02,  2.525933e-01},
  { 9.002080e-01, -2.754516e-01, -3.372714e-01,  5.843362e-01,  3.028772e-01,  3.119130e-01},
  { 9.774825e-01,  8.310099e-02, -1.939644e-01,  6.241401e-01,  4.265016e-01,  2.959461e-01},
  { 8.088836e-01,  5.735290e-01, -1.295058e-01,  6.147422e-01,  4.635885e-01,  2.996817e-01},
  { 9.878300e-01,  1.502889e-01, -4.006357e-02,  5.844921e-01,  5.006756e-01,  3.117765e-01},
  { 9.583958e-01, -1.989952e-01, -2.046427e-01,  5.857856e-01,  5.501251e-01,  3.113145e-01},
  { 7.988318e-01, -4.902474e-01, -3.486046e-01,  5.867040e-01,  5.624875e-01,  3.109474e-01},
  { 5.891163e-01, -7.381548e-01, -3.287394e-01,  6.022296e-01,  5.748498e-01,  3.047940e-01},
  { 9.197752e-01,  3.922322e-01,  1.293694e-02,  5.185418e-01,  1.205330e+00,  3.381608e-01},
  { 9.942101e-01, -1.044409e-01, -2.526654e-02,  5.667170e-01, -7.726472e-01,  3.385667e-01},
  { 9.452162e-01, -1.007426e-01, -3.105114e-01,  5.984626e-01, -5.006763e-01,  3.263682e-01},
  { 7.112333e-01, -2.214303e-01, -6.671700e-01,  6.204439e-01, -3.276030e-01,  3.179630e-01},
  { 8.166998e-01,  5.061904e-01, -2.770788e-01,  7.175862e-01,  1.298054e-01,  2.803827e-01},
  { 7.639976e-01,  6.050452e-01, -2.241163e-01,  6.109662e-01,  4.759509e-01,  3.214766e-01},
  { 8.714801e-01,  4.840648e-01, -7.876357e-02,  5.852473e-01,  5.006756e-01,  3.313918e-01},
  { 9.691821e-01, -2.144101e-01, -1.213029e-01,  5.848569e-01,  5.377627e-01,  3.316046e-01},
  { 8.113759e-01, -4.938686e-01, -3.126708e-01,  5.868176e-01,  5.501251e-01,  3.308483e-01},
  { 5.932775e-01, -6.051101e-01, -5.309082e-01,  5.992743e-01,  5.624875e-01,  3.260434e-01},
  { 9.135834e-01,  4.035126e-01,  5.042725e-02,  6.348600e-01,  9.209960e-01,  3.122424e-01},
  { 8.532894e-01, -2.737314e-01, -4.438112e-01,  6.064869e-01, -5.006763e-01,  3.433082e-01},
  { 6.714337e-01, -5.071474e-01, -5.403501e-01,  7.034654e-01, -1.916168e-01,  3.073237e-01},
  { 9.318338e-01,  3.619645e-01, -2.583175e-02,  6.177111e-01,  4.759509e-01,  3.391238e-01},
  { 9.019477e-01,  4.290355e-01, -4.918081e-02,  5.832952e-01,  5.006756e-01,  3.519158e-01},
  { 9.822396e-01, -1.821761e-01, -4.491261e-02,  5.851446e-01,  5.254002e-01,  3.512008e-01},
  { 7.783931e-01, -5.763131e-01, -2.489325e-01,  5.867716e-01,  5.377627e-01,  3.506238e-01},
  { 5.986553e-01, -7.193725e-01, -3.522995e-01,  6.010246e-01,  5.501251e-01,  3.453260e-01},
  { 6.806794e-01, -6.863164e-01, -2.562135e-01,  6.204922e-01,  5.624875e-01,  3.380901e-01},
  { 7.821437e-01, -5.364720e-01, -3.169367e-01,  6.260542e-01,  5.748498e-01,  3.360226e-01},
  { 8.619713e-01, -4.844173e-01, -1.494838e-01,  6.298907e-01,  5.872122e-01,  3.346211e-01},
  { 9.437271e-01,  1.230485e-01, -3.069824e-01,  6.078172e-01,  2.905149e-01,  3.626708e-01},
  { 9.402821e-01, -2.591132e-01, -2.207486e-01,  6.300693e-01,  3.646892e-01,  3.546977e-01},
  { 6.184872e-01,  7.823672e-01, -7.331491e-02,  6.106642e-01,  4.883133e-01,  3.616536e-01},
  { 6.639079e-01,  7.418566e-01, -9.420770e-02,  5.917356e-01,  5.006756e-01,  3.683764e-01},
  { 9.923685e-01,  1.021669e-01, -6.904133e-02,  5.820302e-01,  5.130381e-01,  3.718986e-01},
  { 8.908141e-01, -4.363214e-01, -1.267825e-01,  5.834270e-01,  5.254002e-01,  3.713988e-01},
  { 6.963287e-01, -6.646732e-01, -2.708060e-01,  5.941356e-01,  5.377627e-01,  3.675674e-01},
  { 6.341165e-01, -7.259410e-01, -2.662816e-01,  6.119525e-01,  5.501251e-01,  3.612393e-01},
  { 7.593258e-01, -6.254382e-01, -1.795868e-01,  6.232361e-01,  5.624875e-01,  3.571754e-01},
  { 9.343871e-01, -2.087646e-01, -2.886831e-01,  6.041127e-01, -5.624881e-01,  3.836468e-01},
  { 8.429771e-01, -3.372303e-01, -4.191245e-01,  6.144639e-01, -5.130387e-01,  3.800899e-01},
  { 7.890347e-01, -2.931452e-01, -5.398984e-01,  6.645158e-01, -3.523277e-01,  3.629212e-01},
  { 8.028916e-01, -3.394925e-01, -4.900101e-01,  6.949503e-01, -2.657909e-01,  3.524543e-01},
  { 8.844497e-01, -3.238665e-01, -3.359453e-01,  7.411584e-01, -1.545294e-01,  3.365242e-01},
  { 6.747528e-01,  6.546228e-01, -3.408482e-01,  6.189333e-01,  2.781524e-01,  3.785326e-01},
  { 9.945920e-01, -5.950512e-03, -1.036878e-01,  6.362839e-01,  3.894139e-01,  3.725457e-01},
  { 7.160696e-01,  6.946064e-01, -6.903936e-02,  5.912423e-01,  5.006756e-01,  3.880713e-01},
  { 9.617698e-01,  2.162927e-01, -1.679769e-01,  5.794354e-01,  5.130381e-01,  3.921328e-01},
  { 7.419665e-01, -6.076881e-01, -2.831975e-01,  5.885535e-01,  5.254002e-01,  3.889962e-01},
  { 6.687054e-01, -6.853026e-01, -2.884328e-01,  6.186499e-01,  5.501251e-01,  3.786730e-01},
  { 9.611890e-01, -1.441041e-01, -2.352653e-01,  6.948045e-01,  7.108357e-01,  3.524463e-01},
  { 9.460735e-01,  3.239477e-01,  1.686663e-03,  5.325584e-01,  1.205330e+00,  4.082588e-01},
  { 9.635484e-01, -9.419060e-02, -2.504048e-01,  5.823839e-01, -7.479225e-01,  4.102980e-01},
  { 8.827234e-01, -3.387961e-01, -3.256019e-01,  6.410855e-01, -4.512267e-01,  3.909333e-01},
  { 9.440031e-01, -1.157473e-01, -3.089671e-01,  7.749796e-01, -3.090557e-02,  3.466776e-01},
  { 9.677567e-01,  2.103015e-01, -1.386371e-01,  7.707697e-01,  4.326862e-02,  3.480490e-01},
  { 7.916833e-01,  5.914171e-01, -1.531775e-01,  7.070779e-01,  1.792549e-01,  3.690509e-01},
  { 7.872527e-01,  4.060695e-01, -4.640480e-01,  6.217632e-01,  2.905149e-01,  3.972922e-01},
  { 9.763176e-01, -1.166166e-01, -1.822213e-01,  6.199988e-01,  3.152396e-01,  3.978744e-01},
  { 9.786781e-01, -2.005140e-01, -4.453460e-02,  6.339211e-01,  3.646892e-01,  3.932543e-01},
  { 9.955518e-01,  9.421523e-02, -5.082749e-05,  6.373500e-01,  4.017763e-01,  3.921007e-01},
  { 7.923094e-01,  6.067582e-01,  6.395615e-02,  6.066800e-01,  4.883133e-01,  4.021890e-01},
  { 9.227062e-01,  3.531501e-01, -1.545903e-01,  5.921939e-01,  5.006756e-01,  4.070299e-01},
  { 8.673472e-01, -2.104190e-01, -4.510351e-01,  5.900557e-01,  5.130381e-01,  4.077683e-01},
  { 7.952836e-01, -5.823548e-01, -1.684841e-01,  6.369786e-01,  5.748498e-01,  3.922925e-01},
  { 8.266804e-01, -4.998536e-01, -2.583524e-01,  6.657801e-01,  6.119370e-01,  3.827806e-01},
  { 9.540223e-01, -2.086173e-01,  2.152216e-01,  5.595394e-01, -9.457205e-01,  4.365461e-01},
  { 9.830216e-01, -1.626581e-01,  8.491708e-02,  5.691701e-01, -9.086334e-01,  4.334978e-01},
  { 9.860386e-01, -1.664061e-01,  6.075109e-03,  5.774108e-01, -8.591840e-01,  4.308938e-01},
  { 9.995310e-01,  6.771334e-03,  2.986649e-02,  6.378359e-01,  3.894139e-01,  4.117216e-01},
  { 9.958966e-01,  8.002245e-02,  4.226514e-02,  5.941387e-01,  5.006756e-01,  4.256080e-01},
  { 8.968232e-01, -3.782566e-01, -2.294126e-01,  5.982634e-01,  5.130381e-01,  4.243013e-01},
  { 9.915192e-01, -4.975576e-03, -1.298653e-01,  7.041771e-01,  7.231982e-01,  3.907177e-01},
  { 9.498391e-01, -2.490565e-01, -1.891467e-01,  6.772622e-01, -3.894148e-01,  4.194522e-01},
  { 9.249517e-01, -3.667292e-01, -9.987022e-02,  7.481533e-01, -1.792542e-01,  3.979244e-01},
  { 9.020960e-01,  4.202963e-01, -9.784564e-02,  7.563480e-01,  1.050806e-01,  3.953971e-01},
  { 9.264310e-01,  2.554625e-01, -2.765220e-01,  6.297927e-01,  3.152396e-01,  4.338276e-01},
  { 9.968441e-01, -6.558129e-02, -4.473217e-02,  6.364103e-01,  3.770515e-01,  4.317864e-01},
  { 9.069684e-01,  3.523006e-01,  2.308523e-01,  6.230633e-01,  4.388637e-01,  4.357891e-01},
  { 9.484363e-01,  2.042727e-01,  2.423658e-01,  5.961037e-01,  4.883133e-01,  4.440518e-01},
  { 9.656419e-01, -1.019773e-01,  2.390322e-01,  5.908984e-01,  5.006756e-01,  4.456308e-01},
  { 8.336236e-01, -5.518377e-01, -2.337886e-02,  6.006567e-01,  5.130381e-01,  4.426612e-01},
  { 9.722969e-01, -2.099183e-01,  1.028247e-01,  6.954144e-01,  6.737487e-01,  4.139088e-01},
  { 9.754738e-01, -2.042114e-01,  8.214961e-02,  7.025271e-01,  7.108357e-01,  4.117340e-01},
  { 9.869217e-01,  1.242127e-01,  1.027462e-01,  7.027614e-01,  7.479229e-01,  4.116512e-01},
  { 9.326544e-01, -3.209294e-01, -1.648031e-01,  6.961292e-01, -3.523277e-01,  4.339713e-01},
  { 9.740677e-01,  4.021163e-02, -2.226548e-01,  6.350397e-01,  3.152396e-01,  4.516789e-01},
  { 9.499674e-01, -3.038076e-01, -7.254571e-02,  5.943863e-01,  5.006756e-01,  4.634746e-01},
  { 8.136214e-01, -5.811507e-01,  1.685625e-02,  6.153700e-01,  5.377627e-01,  4.573934e-01},
  { 7.432812e-01, -6.648849e-01, -7.389955e-02,  6.265777e-01,  5.501251e-01,  4.541715e-01},
  { 8.792215e-01, -4.760409e-01, -1.883035e-02,  6.717656e-01,  5.995746e-01,  4.410367e-01},
  { 9.537371e-01, -2.994407e-01,  2.684775e-02,  6.920773e-01,  6.613864e-01,  4.351200e-01},
  { 9.304925e-01,  3.599866e-01,  6.777356e-02,  6.732268e-01,  8.591842e-01,  4.405496e-01},
  { 9.033058e-01,  3.967310e-01,  1.632268e-01,  6.211393e-01,  9.457207e-01,  4.556483e-01},
  { 7.040215e-01, -6.539726e-01,  2.769000e-01,  3.957162e-01, -1.205331e+00,  5.371008e-01},
  { 9.916717e-01, -1.221762e-01, -4.074484e-02,  6.791632e-01, -4.017772e-01,  4.587780e-01},
  { 9.393792e-01, -3.320080e-01, -8.565909e-02,  7.016921e-01, -3.399654e-01,  4.525306e-01},
  { 8.251206e-01,  5.380036e-01, -1.724182e-01,  6.762967e-01,  2.410653e-01,  4.595391e-01},
  { 8.265528e-01,  5.202210e-01, -2.148966e-01,  6.598677e-01,  2.657900e-01,  4.640946e-01},
  { 9.876863e-01,  1.416685e-01, -6.637543e-02,  6.381719e-01,  3.399643e-01,  4.701062e-01},
  { 9.931883e-01,  1.080631e-01,  4.357980e-02,  6.344796e-01,  3.770515e-01,  4.711023e-01},
  { 9.539186e-01,  2.919725e-01,  6.921926e-02,  6.320783e-01,  4.017763e-01,  4.717512e-01},
  { 9.861259e-01, -5.088634e-02,  1.580070e-01,  7.006986e-01,  7.108357e-01,  4.527794e-01},
  { 7.254608e-01, -6.336707e-01,  2.686410e-01,  4.270842e-01, -1.168244e+00,  5.449383e-01},
  { 8.969968e-01, -3.900576e-01,  2.079705e-01,  5.288954e-01, -1.007533e+00,  5.181059e-01},
  { 9.793986e-01, -2.010851e-01, -1.852647e-02,  5.994291e-01, -7.726472e-01,  4.995418e-01},
  { 9.834316e-01, -1.745757e-01,  4.884370e-02,  7.798561e-01, -8.035525e-02,  4.519657e-01},
  { 9.991772e-01,  8.500756e-03,  3.965608e-02,  7.847252e-01, -3.090557e-02,  4.506703e-01},
  { 9.275110e-01,  3.686892e-01,  6.157624e-02,  7.558557e-01,  1.050806e-01,  4.582578e-01},
  { 8.809671e-01,  4.689314e-01,  6.324796e-02,  7.224290e-01,  1.668925e-01,  4.670630e-01},
  { 8.528438e-01,  5.172716e-01, -7.132646e-02,  7.061179e-01,  1.916172e-01,  4.713731e-01},
  { 9.158005e-01,  3.637316e-01, -1.703197e-01,  6.469682e-01,  3.028772e-01,  4.870011e-01},
  { 9.310699e-01,  3.307129e-01,  1.540705e-01,  6.249349e-01,  4.141386e-01,  4.927505e-01},
  { 8.348010e-01,  5.199019e-01,  1.811334e-01,  6.168773e-01,  4.265016e-01,  4.948567e-01},
  { 8.937550e-01,  3.809583e-01,  2.367970e-01,  5.987372e-01,  4.512262e-01,  4.996368e-01},
  { 9.939767e-01, -3.545024e-03,  1.095339e-01,  5.891387e-01,  4.759509e-01,  5.022085e-01},
  { 9.593682e-01, -2.608599e-01,  1.075401e-01,  5.744134e-01, -8.839087e-01,  5.243706e-01},
  { 9.385792e-01, -3.448503e-01, -1.213973e-02,  6.684802e-01, -4.388643e-01,  5.008255e-01},
  { 9.259143e-01, -3.073635e-01,  2.195686e-01,  7.623439e-01, -1.421671e-01,  4.772995e-01},
  { 9.764641e-01,  4.680622e-02,  2.105399e-01,  7.792985e-01,  6.181527e-03,  4.730166e-01},
  { 9.145957e-01,  4.042225e-01, -1.089855e-02,  6.793656e-01,  2.410653e-01,  4.980642e-01},
  { 7.965631e-01,  5.345803e-01,  2.823316e-01,  6.108013e-01,  4.265016e-01,  5.151795e-01},
  { 9.752270e-01, -2.204653e-01,  1.809004e-02,  5.890922e-01,  4.883133e-01,  5.207171e-01},
  { 9.323360e-01, -3.615681e-01, -4.262472e-03,  5.946231e-01,  5.006756e-01,  5.193545e-01},
  { 7.671124e-01, -6.311222e-01, -1.149928e-01,  6.034203e-01,  5.130381e-01,  5.171734e-01},
  { 9.453714e-01,  2.404870e-01,  2.200884e-01,  6.842035e-01,  8.097348e-01,  4.968252e-01},
  { 9.552130e-01,  2.267070e-01,  1.901899e-01,  6.053542e-01,  9.704456e-01,  5.165849e-01},
  { 8.301651e-01, -4.760566e-01,  2.901652e-01,  4.563652e-01, -1.106432e+00,  5.705213e-01},
  { 9.885470e-01, -1.205318e-01, -9.081267e-02,  6.441913e-01, -5.254011e-01,  5.259629e-01},
  { 9.791325e-01, -1.524464e-01,  1.343857e-01,  6.749744e-01, -4.141395e-01,  5.186418e-01},
  { 9.471029e-01,  3.186597e-01, -3.810658e-02,  6.789103e-01,  2.410653e-01,  5.176811e-01},
  { 9.177175e-01,  3.970821e-01, -1.097134e-02,  6.599379e-01,  2.781524e-01,  5.221955e-01},
  { 8.323573e-01,  4.338092e-01,  3.449507e-01,  5.914994e-01,  4.388637e-01,  5.383947e-01},
  { 9.453565e-01,  1.626603e-01,  2.825646e-01,  5.859000e-01,  4.512262e-01,  5.397534e-01},
  { 9.932119e-01, -4.723506e-02,  1.062966e-01,  5.852234e-01,  4.635885e-01,  5.399450e-01},
  { 9.203944e-01, -3.661291e-01, -1.371993e-01,  5.909840e-01,  4.883133e-01,  5.386289e-01},
  { 7.953782e-01, -5.866874e-01,  1.522216e-01,  6.436169e-01,  5.501251e-01,  5.261102e-01},
  { 8.631782e-01, -3.729213e-01,  3.403721e-01,  6.519276e-01,  5.624875e-01,  5.241153e-01},
  { 9.496173e-01,  3.126607e-01,  2.168442e-02,  6.412627e-01,  3.276020e-01,  5.455387e-01},
  { 9.641604e-01,  2.604699e-01,  5.049845e-02,  6.384777e-01,  3.399643e-01,  5.461670e-01},
  { 9.549673e-01,  2.905686e-01,  6.006135e-02,  5.814326e-01,  4.388637e-01,  5.590196e-01},
  { 9.428127e-01, -2.572765e-01,  2.119270e-01,  5.825215e-01,  4.512262e-01,  5.587355e-01},
  { 9.097978e-01, -4.050935e-01, -9.037294e-02,  5.885264e-01,  4.759509e-01,  5.574263e-01},
  { 8.558766e-01, -5.059021e-01,  1.074160e-01,  6.304723e-01,  5.377627e-01,  5.479786e-01},
  { 8.948399e-01, -1.964072e-01,  4.008562e-01,  6.755361e-01,  6.737487e-01,  5.378057e-01},
  { 8.418763e-01,  3.888604e-01,  3.742085e-01,  6.524926e-01,  8.468218e-01,  5.429384e-01},
  { 9.242545e-01,  3.708020e-01,  9.088192e-02,  5.306394e-01,  1.205330e+00,  5.703629e-01},
  { 9.428234e-01, -1.980064e-01,  2.680998e-01,  7.553385e-01, -1.174423e-01,  5.401741e-01},
  { 9.280252e-01,  2.420765e-01,  2.831401e-01,  7.505448e-01,  6.799346e-02,  5.411671e-01},
  { 8.593782e-01,  5.099519e-01, -3.766075e-02,  5.920069e-01,  4.265016e-01,  5.747338e-01},
  { 9.527544e-01, -3.021865e-01, -3.069782e-02,  5.819709e-01,  4.512262e-01,  5.769249e-01},
  { 9.243493e-01, -3.612502e-01,  1.227866e-01,  5.965226e-01,  4.883133e-01,  5.738458e-01},
  { 9.064434e-01,  9.849858e-02,  4.106804e-01,  6.681238e-01,  7.726477e-01,  5.585998e-01},
  { 9.466825e-01,  1.214753e-02,  3.219390e-01,  7.531881e-01, -6.799289e-02,  5.607510e-01},
  { 9.901952e-01,  1.378874e-01,  2.236990e-02,  5.836648e-01,  4.388637e-01,  5.945135e-01},
  { 9.730479e-01, -1.934607e-01,  1.255019e-01,  5.899393e-01,  4.759509e-01,  5.932738e-01},
  { 9.422814e-01,  2.777980e-01,  1.869061e-01,  5.490139e-01,  1.131156e+00,  6.013805e-01},
  { 8.977349e-01,  4.398093e-01,  2.529337e-02,  5.233866e-01,  1.205330e+00,  6.065373e-01},
  { 6.153691e-01, -7.352661e-01,  2.840854e-01,  3.298471e-01, -1.205331e+00,  6.595792e-01},
  { 9.558282e-01, -2.481864e-01,  1.574674e-01,  6.778595e-01, -3.523277e-01,  5.948662e-01},
  { 8.981049e-01,  4.303170e-02,  4.376711e-01,  7.456913e-01, -3.090557e-02,  5.821764e-01},
  { 9.486848e-01,  2.939347e-01,  1.166178e-01,  6.423696e-01,  3.276020e-01,  6.014599e-01},
  { 8.470317e-01,  5.042179e-01,  1.682311e-01,  6.178119e-01,  3.894139e-01,  6.059791e-01},
  { 9.339784e-01,  3.261242e-01,  1.460389e-01,  5.289918e-01,  1.192968e+00,  6.225525e-01},
  { 9.571053e-01,  2.767153e-01,  8.589509e-02,  5.253519e-01,  1.205330e+00,  6.232847e-01},
  { 9.592723e-01, -2.638641e-01,  1.008581e-01,  6.192849e-01, -6.737497e-01,  6.240274e-01},
  { 9.203354e-01,  1.148205e-01,  3.738970e-01,  7.275458e-01,  5.563099e-02,  6.051655e-01},
  { 9.330844e-01,  3.111460e-01,  1.803927e-01,  6.753905e-01,  2.163405e-01,  6.142325e-01},
  { 8.701238e-01,  4.457400e-01,  2.102389e-01,  5.909207e-01,  4.141386e-01,  6.288968e-01},
  { 9.287557e-01,  3.363131e-01,  1.559051e-01,  5.843651e-01,  4.265016e-01,  6.300524e-01},
  { 9.614874e-01, -1.382828e-01,  2.375289e-01,  5.823057e-01,  5.130381e-01,  6.304033e-01},
  { 8.994471e-01,  1.514011e-01,  4.099666e-01,  6.296886e-01,  7.726477e-01,  6.221170e-01},
  { 9.281473e-01,  2.310588e-01,  2.918122e-01,  6.564367e-01,  2.410653e-01,  6.361673e-01},
  { 9.731602e-01,  2.062727e-01,  1.020331e-01,  5.795367e-01,  4.388637e-01,  6.485811e-01},
  { 9.198873e-01, -1.213879e-01,  3.729239e-01,  6.202226e-01,  6.490240e-01,  6.419968e-01},
  { 9.164130e-01,  1.882878e-03,  4.002296e-01,  6.250373e-01,  7.108357e-01,  6.412028e-01},
  { 8.890664e-01,  2.648296e-01,  3.733981e-01,  5.881339e-01,  8.591842e-01,  6.471407e-01},
  { 9.301924e-01, -1.190344e-01,  3.472360e-01,  7.107279e-01, -1.298047e-01,  6.466871e-01},
  { 8.840363e-01,  2.183777e-01,  4.132686e-01,  6.866415e-01,  1.545301e-01,  6.502506e-01},
  { 9.281964e-01,  2.744465e-01,  2.512576e-01,  6.511664e-01,  2.410653e-01,  6.555322e-01},
  { 9.723517e-01,  1.455573e-01,  1.826067e-01,  6.480412e-01,  2.534277e-01,  6.560082e-01},
  { 8.858966e-01,  3.916121e-01,  2.486508e-01,  6.285188e-01,  3.399643e-01,  6.588827e-01},
  { 9.700472e-01, -1.992544e-01,  1.389464e-01,  5.756947e-01,  5.254002e-01,  6.667596e-01},
  { 9.615644e-01, -2.303220e-01,  1.494847e-01,  6.070974e-01,  6.242992e-01,  6.620751e-01},
  { 9.354658e-01, -8.577906e-02,  3.428495e-01,  6.113086e-01,  6.490240e-01,  6.614367e-01},
  { 8.694217e-01, -3.576068e-01,  3.409153e-01,  5.513589e-01, -8.097343e-01,  6.875243e-01},
  { 9.239046e-01, -2.811946e-01,  2.594800e-01,  6.182150e-01, -6.490249e-01,  6.784679e-01},
  { 9.638527e-01, -2.135815e-01,  1.592823e-01,  6.519914e-01, -5.130387e-01,  6.738913e-01},
  { 9.948376e-01,  3.062659e-02,  9.674829e-02,  6.619689e-01, -4.388643e-01,  6.725346e-01},
  { 9.336620e-01, -1.872736e-01,  3.052932e-01,  6.981263e-01, -1.668918e-01,  6.675856e-01},
  { 8.886904e-01, -8.589785e-03,  4.584274e-01,  7.033352e-01, -1.050800e-01,  6.668555e-01},
  { 9.637092e-01,  1.727826e-01,  2.034961e-01,  6.414179e-01,  2.905149e-01,  6.753016e-01},
  { 9.791853e-01, -8.219667e-02,  1.855798e-01,  5.723813e-01,  5.130381e-01,  6.847018e-01},
  { 9.338106e-01,  8.141832e-02,  3.483805e-01,  5.545250e-01,  9.580831e-01,  6.870900e-01},
  { 9.109659e-01, -2.614814e-01,  3.190119e-01,  6.358442e-01, -5.748505e-01,  6.942537e-01},
  { 8.748559e-01,  4.464315e-02,  4.823216e-01,  6.880895e-01, -1.854320e-02,  6.877340e-01},
  { 8.854839e-01,  2.995670e-01,  3.552154e-01,  5.036405e-01,  1.192968e+00,  7.105205e-01},
  { 9.422206e-01, -9.427113e-02,  3.214552e-01,  6.480203e-01, -4.883140e-01,  7.110213e-01},
  { 8.544330e-01,  1.197362e-01,  5.055764e-01,  6.628089e-01,  1.174429e-01,  7.093177e-01},
  { 9.976818e-01,  5.976915e-02, -3.253581e-02,  5.122541e-01,  1.131156e+00,  7.261210e-01},
  { 8.484156e-01,  1.343573e-01, -5.119952e-01,  5.084870e-01,  1.143519e+00,  7.265386e-01},
  { 8.581108e-01,  4.838821e-01, -1.717668e-01,  4.972639e-01,  1.180606e+00,  7.277831e-01},
  { 9.376453e-01,  2.407780e-01,  2.506937e-01,  4.927178e-01,  1.192968e+00,  7.282872e-01},
  { 9.274091e-01,  2.347898e-01,  2.911808e-01,  4.936198e-01,  1.205330e+00,  7.281119e-01},
  { 7.438352e-01, -5.311546e-01,  4.056897e-01,  2.912902e-01, -1.205331e+00,  7.643380e-01},
  { 9.121825e-01, -1.572056e-01,  3.784304e-01,  6.407677e-01, -4.883140e-01,  7.299489e-01},
  { 9.299260e-01,  3.848394e-02,  3.657276e-01,  6.540564e-01, -3.894148e-01,  7.286405e-01},
  { 9.625888e-01,  1.968346e-01,  1.862230e-01,  5.702851e-01,  4.265016e-01,  7.369118e-01},
  { 9.148723e-01, -5.768626e-02,  3.996009e-01,  5.779963e-01,  6.119370e-01,  7.361249e-01},
  { 9.314703e-01,  1.746268e-01,  3.191685e-01,  5.229061e-01,  1.081707e+00,  7.415569e-01},
  { 9.005947e-01, -2.506869e-01,  3.550847e-01,  5.116307e-01,  1.131156e+00,  7.427269e-01},
  { 8.784675e-01, -4.084662e-01,  2.478916e-01,  5.256559e-01,  1.143519e+00,  7.413458e-01},
  { 8.947850e-01, -1.639268e-01,  4.153163e-01,  5.350062e-01,  1.155881e+00,  7.404251e-01},
  { 9.955102e-01, -5.392605e-02,  7.779184e-02,  5.326686e-01,  1.168243e+00,  7.406552e-01},
  { 6.301123e-01,  2.509447e-01, -7.348369e-01,  5.292239e-01,  1.180606e+00,  7.409944e-01},
  { 4.778821e-01,  6.127749e-01, -6.293931e-01,  4.952677e-01,  1.192968e+00,  7.443382e-01},
  { 8.901650e-01,  3.672732e-01, -2.696601e-01,  4.861637e-01,  1.205330e+00,  7.452347e-01},
  { 7.085087e-01, -3.394659e-01,  6.186908e-01,  4.735197e-01, -8.715463e-01,  7.624182e-01},
  { 8.598346e-01, -1.967323e-01,  4.711487e-01,  6.226147e-01, -5.377634e-01,  7.495949e-01},
  { 9.206818e-01,  8.943470e-02,  3.799296e-01,  6.300891e-01,  2.039797e-01,  7.489558e-01},
  { 8.916348e-01,  1.902367e-01,  4.108496e-01,  6.284171e-01,  2.410653e-01,  7.490922e-01},
  { 9.282847e-01,  9.305901e-02,  3.600380e-01,  5.582049e-01,  4.883133e-01,  7.551726e-01},
  { 8.504387e-01, -8.001434e-03,  5.260134e-01,  5.571428e-01,  5.006756e-01,  7.552671e-01},
  { 8.736334e-01, -6.323779e-02,  4.824578e-01,  5.628467e-01,  5.501251e-01,  7.547657e-01},
  { 9.199154e-01,  3.353826e-02,  3.906802e-01,  5.273609e-01,  9.457207e-01,  7.578022e-01},
  { 7.961465e-01,  1.201271e-01,  5.930602e-01,  5.002083e-01,  1.143519e+00,  7.602071e-01},
  { 7.947543e-01, -3.571833e-02,  6.058793e-01,  4.954049e-01,  1.155881e+00,  7.606207e-01},
  { 8.325725e-01, -4.439489e-01,  3.312588e-01,  4.899853e-01,  1.168243e+00,  7.610872e-01},
  { 6.369082e-01, -5.066819e-01,  5.810519e-01,  5.207773e-01,  1.180606e+00,  7.584362e-01},
  { 9.746121e-01,  1.145822e-01,  1.923595e-01,  5.653642e-01,  1.192968e+00,  7.545974e-01},
  { 2.787521e-01,  7.364613e-01, -6.163782e-01,  5.213933e-01,  1.205330e+00,  7.583832e-01},
  { 8.415542e-01, -3.620776e-03,  5.401606e-01,  6.231860e-01, -4.512267e-01,  7.673621e-01},
  { 7.949634e-01,  2.969293e-02,  6.059304e-01,  6.362463e-01, -1.421671e-01,  7.663781e-01},
  { 9.506829e-01,  1.668926e-01,  2.614362e-01,  5.606897e-01,  4.635885e-01,  7.720219e-01},
  { 9.497652e-01, -1.761397e-02,  3.124673e-01,  5.552602e-01,  5.377627e-01,  7.724152e-01},
  { 7.780933e-01, -1.160129e-01,  6.173425e-01,  4.851075e-01,  1.155881e+00,  7.776416e-01},
  { 7.720151e-01, -5.121903e-01,  3.763692e-01,  5.084093e-01,  1.168243e+00,  7.759232e-01},
  { 8.216750e-01,  1.539495e-01,  5.487711e-01,  5.164231e-01,  1.180606e+00,  7.753322e-01},
  { 5.430762e-01, -3.327879e-01,  7.709219e-01,  4.832582e-01,  1.192968e+00,  7.777780e-01},
  { 5.957112e-01, -3.119244e-01,  7.401564e-01,  5.174092e-01,  1.205330e+00,  7.752594e-01},
  { 6.985184e-01, -3.552032e-01,  6.212107e-01,  2.638402e-01, -1.205331e+00,  8.073364e-01},
  { 7.596101e-01, -2.977695e-01,  5.782090e-01,  5.711403e-01, -6.119378e-01,  7.883698e-01},
  { 8.388662e-01,  4.761995e-02,  5.422508e-01,  6.059613e-01,  8.035583e-02,  7.862193e-01},
  { 8.447745e-01,  2.087344e-01,  4.927331e-01,  4.891885e-01,  1.118794e+00,  7.934126e-01},
  { 7.739776e-01,  1.145493e-02,  6.331093e-01,  4.681762e-01,  1.168243e+00,  7.947866e-01},
  { 6.199502e-01,  5.917767e-02,  7.824064e-01,  4.731314e-01,  1.180606e+00,  7.943424e-01},
  { 5.999840e-01, -1.553317e-02,  7.998611e-01,  4.654617e-01,  1.192968e+00,  7.949533e-01},
  { 2.946467e-01, -8.664134e-01,  4.031267e-01,  5.095124e-01,  1.205330e+00,  7.922479e-01},
  { 7.751315e-01, -3.486466e-02,  6.308372e-01,  6.061736e-01, -2.657909e-01,  8.037776e-01},
  { 8.543214e-01,  1.695147e-01,  4.913244e-01,  5.500843e-01,  4.512262e-01,  8.065810e-01},
  { 7.699726e-01,  2.430629e-01,  5.899684e-01,  4.734244e-01,  1.143519e+00,  8.103224e-01},
  { 7.069350e-01,  1.107243e-01,  6.985579e-01,  4.591193e-01,  1.180606e+00,  8.110378e-01},
  { 6.250092e-01,  1.003374e-01,  7.741421e-01,  4.488011e-01,  1.205330e+00,  8.116107e-01},
  { 6.835919e-01, -8.223032e-02,  7.252174e-01,  5.662004e-01, -5.254011e-01,  8.227964e-01},
  { 7.911963e-01,  4.433430e-02,  6.099532e-01,  5.812501e-01,  1.916172e-01,  8.222429e-01},
  { 8.654177e-01,  3.295697e-02,  4.999661e-01,  5.275210e-01,  5.624875e-01,  8.242533e-01},
  { 8.634559e-01,  5.513426e-02,  5.014023e-01,  4.924456e-01,  9.086336e-01,  8.255415e-01},
  { 7.032514e-01,  1.586376e-01,  6.930163e-01,  5.414461e-01,  3.646892e-01,  8.404598e-01},
  { 7.939055e-01,  5.734513e-02,  6.053311e-01,  5.055941e-01,  6.737487e-01,  8.413375e-01},
  { 8.178241e-01,  6.827158e-02,  5.714042e-01,  4.780476e-01,  1.007533e+00,  8.420240e-01},
  { 5.207926e-01, -2.981175e-01,  7.999381e-01,  1.986805e-01, -1.205331e+00,  8.614833e-01},
  { 7.929548e-01,  2.322816e-01,  5.632655e-01,  4.176047e-01,  1.205330e+00,  8.586783e-01},
  { 5.104964e-01, -3.256943e-01,  7.958120e-01,  1.627825e-01, -1.205331e+00,  8.740000e-01},
  { 8.809486e-01,  1.150325e-01,  4.590175e-01,  4.142464e-01,  1.180606e+00,  8.739096e-01},
  { 6.419218e-01,  2.848678e-01,  7.118896e-01,  4.084425e-01,  1.155881e+00,  8.890057e-01},
  { 7.756452e-01, -3.423227e-01,  5.302733e-01,  1.292534e-01, -1.205331e+00,  9.090094e-01},
  { 7.228243e-01,  2.996010e-02,  6.903821e-01,  4.216936e-01,  7.479229e-01,  9.196943e-01},
  { 8.529015e-01,  9.946076e-02,  5.125102e-01,  3.979738e-01,  1.094069e+00,  9.188311e-01},
  { 8.503410e-01, -3.484308e-01,  3.943556e-01,  1.135116e-01, -1.205331e+00,  9.429532e-01},
  { 6.334289e-01, -3.281962e-01,  7.007532e-01,  2.310622e-01, -9.086334e-01,  9.516265e-01},
  { 6.236121e-01, -2.667848e-01,  7.348019e-01,  3.615882e-01, -6.366625e-01,  9.612581e-01},
  { 6.692715e-01, -9.190425e-02,  7.373122e-01,  4.289905e-01, -3.894148e-01,  9.662310e-01},
  { 7.045457e-01,  1.796417e-02,  7.094312e-01,  4.399709e-01, -1.668918e-01,  9.670410e-01},
  { 5.387099e-01,  6.581097e-03,  8.424656e-01,  4.265990e-01,  3.090626e-02,  9.660544e-01},
  {-7.373615e-02,  5.460137e-06,  9.972778e-01,  4.246444e-01,  6.799346e-02,  9.659097e-01},
  { 5.445982e-01,  7.982884e-02,  8.348893e-01,  4.302191e-01,  1.792549e-01,  9.663212e-01},
  { 7.750665e-01,  8.003202e-02,  6.267909e-01,  4.148786e-01,  5.624875e-01,  9.651895e-01},
  { 7.526060e-01,  1.613781e-03,  6.584692e-01,  3.813600e-01,  8.097348e-01,  9.627160e-01},
  { 7.823133e-01,  4.922330e-02,  6.209372e-01,  3.852909e-01,  8.962712e-01,  9.630066e-01},
  { 5.773301e-01,  1.392878e-01,  8.045427e-01,  3.623414e-01,  1.118794e+00,  9.613132e-01},
  {-7.360838e-02, -6.104135e-06,  9.972873e-01,  3.402140e-01,  1.180606e+00,  9.596804e-01},
  { 6.103105e-01,  1.969138e-01,  7.672979e-01,  3.335820e-01,  1.205330e+00,  9.591911e-01},
};

static GLushort face_indices[][3] =
{
  {   4,    6,    5},
  {   7,    8,   10},
  {   8,    9,   10},
  {   9,   11,   10},
  {  13,   14,   12},
  {  13,   16,   14},
  {  16,   23,   14},
  {  16,   15,   23},
  {  17,   19,   18},
  {   0,    1,   22},
  {   3,    4,   20},
  {  20,    4,   26},
  {   4,    5,   26},
  {   5,    6,   26},
  {  11,   12,   27},
  {  12,   14,   27},
  {  15,   16,   25},
  {  16,   29,   25},
  {  17,   18,   21},
  {   2,    3,    1},
  {   3,   20,   26},
  {   6,    7,   26},
  {  23,   25,   24},
  {  23,   15,   25},
  {  16,   17,   42},
  {   1,    3,   26},
  {  26,    7,   32},
  {   7,   37,   32},
  {   7,   54,   37},
  {  23,   28,   14},
  {  23,   24,   28},
  {  24,   25,   28},
  {  16,   42,   29},
  {  42,   17,   21},
  {   1,   26,   31},
  {  26,   32,   35},
  {   7,   10,   54},
  {  27,   14,   38},
  {  22,    1,   92},
  {  31,   35,   78},
  {  31,   26,   35},
  {  11,   27,   45},
  {  14,   28,   49},
  {  28,   25,   49},
  {  25,   29,   62},
  {  22,   92,   30},
  {  35,   36,   65},
  {  35,   32,   36},
  {  11,   45,   10},
  {  27,   38,   33},
  {  29,   42,   41},
  {  42,   21,   34},
  {   1,   50,   92},
  {  50,    1,   31},
  {  31,   78,   51},
  {  36,   32,   43},
  {  32,   53,   43},
  {  32,   37,   53},
  {  27,   33,   45},
  {  33,   38,   48},
  {  38,   14,   39},
  {  14,   40,   39},
  {  40,   14,   49},
  {  49,   25,   62},
  {  42,   63,   41},
  {  34,   90,   42},
  {  78,   35,   64},
  {  36,   52,   65},
  {  36,   43,   52},
  {  10,   45,   44},
  {  45,   33,   56},
  {  33,   46,   56},
  {  33,   47,   46},
  {  33,   48,   47},
  {  38,   70,   48},
  {  38,   39,   70},
  {  39,   60,   70},
  {  39,   40,   60},
  {  35,   65,   64},
  {  52,   43,   80},
  {  37,   82,   53},
  {  37,   54,   82},
  {  54,   10,   55},
  {  10,   44,   55},
  {  44,   45,   97},
  {  45,   56,   97},
  {  56,   46,   57},
  {  46,   58,   57},
  {  46,   47,   58},
  {  47,   59,   58},
  {  47,   69,   59},
  {  47,   48,   69},
  {  48,   70,   69},
  {  60,   40,   72},
  {  40,   61,   72},
  {  40,   49,   61},
  {  29,   75,   62},
  {  29,   41,   75},
  {  41,   63,   75},
  {  42,   90,   63},
  {  50,   31,   77},
  {  31,   51,   77},
  {  51,   78,   77},
  {  43,   53,   66},
  {  54,   55,   83},
  {  55,   44,   83},
  {  44,   97,   83},
  {  56,  107,   97},
  {  56,   57,  107},
  {  57,   58,   67},
  {  58,   68,   67},
  {  58,   59,   68},
  {  59,   69,   68},
  {  70,   60,   71},
  {  60,   72,   71},
  {  61,   73,   72},
  {  61,   74,   73},
  {  61,   49,   74},
  {  63,  113,   75},
  {  50,   76,   93},
  {  50,   77,   76},
  {  64,   94,   78},
  {  64,   95,   79},
  {  64,   65,   95},
  {  52,   80,   65},
  {  80,   43,   81},
  {  43,   66,   81},
  {  66,   53,   82},
  {  82,   54,   83},
  {  57,   84,  107},
  {  57,   67,   84},
  {  67,   68,   84},
  {  68,   85,   84},
  {  68,   69,   85},
  {  70,   71,   86},
  {  71,   72,   87},
  {  72,   88,   87},
  {  72,   73,   88},
  {  73,   74,   88},
  {  74,   89,   88},
  {  74,  102,   89},
  {  74,   49,  102},
  {  49,   62,  104},
  {  30,   92,   91},
  {  92,   50,   93},
  {  76,   77,   93},
  {  77,   78,  105},
  {  64,   79,   94},
  {  95,   65,   96},
  {  65,   80,   96},
  {  66,   82,   81},
  {  84,  108,  107},
  {  84,   98,  108},
  {  84,   85,   98},
  {  85,   69,   98},
  {  69,   70,   98},
  {  70,   86,  110},
  {  71,   99,   86},
  {  71,  100,   99},
  {  71,   87,  100},
  {  87,  101,  100},
  {  87,   88,  101},
  {  88,   89,  101},
  { 102,   49,  103},
  {  49,  120,  103},
  {  49,  104,  120},
  {  62,   75,  121},
  {  75,  113,  121},
  {  77,  105,   93},
  {  78,  116,  105},
  {  78,   94,  116},
  {  94,   79,  116},
  {  79,   95,  116},
  {  95,   96,  116},
  {  96,   80,  116},
  {  82,   83,   81},
  {  83,  124,   81},
  {  97,  125,   83},
  {  97,  106,  125},
  {  97,  107,  106},
  {  98,  109,  108},
  {  98,  110,  109},
  {  98,   70,  110},
  { 110,   86,  111},
  {  86,   99,  111},
  { 101,   89,  112},
  {  89,  102,  112},
  { 102,  103,  112},
  { 103,  120,  112},
  {  62,  121,  104},
  {  92,   93,  130},
  {  93,  105,  130},
  {  80,   81,  116},
  { 106,  114,  125},
  { 106,  107,  114},
  { 107,  108,  114},
  { 108,  109,  114},
  { 110,  117,  109},
  { 110,  115,  117},
  { 110,  111,  115},
  {  99,  100,  118},
  { 100,  135,  118},
  { 100,  101,  135},
  { 101,  119,  135},
  { 101,  112,  119},
  { 104,  121,  120},
  { 113,   63,  149},
  {  63,   90,  149},
  {  91,   92,  123},
  {  81,  124,  151},
  { 114,  109,  126},
  { 109,  117,  126},
  { 115,  127,  117},
  { 115,  111,  127},
  { 111,  118,  127},
  { 111,   99,  118},
  { 121,  113,  137},
  { 122,  113,  147},
  { 113,  149,  147},
  { 127,  118,  133},
  { 118,  134,  133},
  { 118,  135,  134},
  { 112,  128,  119},
  { 112,  120,  128},
  { 120,  129,  128},
  { 120,  121,  129},
  { 113,  122,  137},
  { 122,  147,  137},
  { 149,   90,  138},
  { 105,  116,  185},
  {  81,  150,  116},
  { 150,   81,  151},
  { 114,  126,  125},
  { 126,  131,  125},
  { 126,  139,  131},
  { 126,  117,  139},
  { 117,  140,  139},
  { 117,  142,  140},
  { 117,  127,  142},
  { 127,  132,  142},
  { 135,  119,  145},
  { 119,  136,  145},
  { 119,  128,  136},
  { 128,  129,  136},
  {  92,  169,  123},
  {  92,  130,  169},
  { 130,  105,  206},
  { 124,  195,  151},
  { 124,   83,  195},
  {  83,  125,  195},
  { 125,  159,  195},
  { 131,  139,  125},
  { 140,  142,  141},
  { 132,  154,  142},
  { 132,  143,  154},
  { 132,  127,  143},
  { 127,  133,  143},
  { 133,  134,  143},
  { 134,  135,  144},
  { 136,  146,  145},
  { 136,  129,  146},
  { 147,  149,  148},
  { 185,  206,  105},
  { 125,  171,  159},
  { 125,  160,  171},
  { 125,  152,  160},
  { 125,  153,  152},
  { 125,  139,  153},
  { 139,  221,  153},
  { 139,  140,  221},
  { 142,  154,  141},
  { 143,  155,  154},
  { 143,  134,  155},
  { 134,  144,  155},
  { 145,  156,  135},
  { 145,  165,  156},
  { 146,  157,  145},
  { 146,  129,  157},
  { 121,  137,  168},
  { 116,  150,  185},
  { 150,  151,  207},
  { 152,  153,  221},
  { 140,  172,  221},
  { 140,  141,  172},
  { 141,  161,  172},
  { 141,  154,  161},
  { 154,  163,  161},
  { 154,  162,  163},
  { 154,  155,  162},
  { 155,  144,  174},
  { 144,  135,  164},
  { 135,  176,  164},
  { 135,  156,  176},
  { 165,  145,  166},
  { 145,  157,  166},
  { 129,  168,  167},
  { 129,  121,  168},
  { 137,  147,  168},
  { 147,  149,  148},
  { 149,  138,  205},
  { 162,  155,  174},
  { 174,  144,  175},
  { 144,  164,  175},
  { 156,  165,  176},
  { 157,  177,  166},
  { 157,  129,  177},
  { 129,  167,  177},
  { 130,  193,  169},
  { 206,  193,  130},
  { 150,  170,  185},
  { 150,  207,  170},
  { 160,  221,  171},
  { 160,  152,  221},
  { 161,  179,  172},
  { 161,  163,  179},
  { 163,  173,  179},
  { 163,  162,  173},
  { 162,  174,  173},
  { 164,  176,  180},
  { 167,  168,  177},
  { 123,  169,  192},
  { 170,  178,  185},
  { 170,  207,  178},
  { 159,  171,  196},
  { 171,  221,  196},
  { 179,  173,  186},
  { 174,  175,  173},
  { 175,  187,  173},
  { 180,  176,  181},
  { 176,  182,  181},
  { 176,  165,  182},
  { 165,  183,  182},
  { 165,  191,  183},
  { 165,  166,  191},
  { 177,  184,  166},
  { 177,  168,  184},
  { 205,  218,  149},
  { 123,  192,  236},
  { 221,  172,  210},
  { 172,  186,  210},
  { 172,  179,  186},
  { 186,  173,  213},
  { 173,  199,  213},
  { 173,  187,  199},
  { 175,  188,  187},
  { 175,  164,  188},
  { 164,  180,  188},
  { 181,  182,  189},
  { 182,  183,  189},
  { 183,  190,  189},
  { 183,  191,  190},
  { 166,  184,  204},
  { 168,  255,  184},
  { 147,  149,  232},
  { 149,  218,  232},
  { 158,  123,  236},
  { 169,  193,  192},
  { 207,  194,  178},
  { 151,  239,  238},
  { 151,  195,  239},
  { 196,  221,  209},
  { 210,  186,  197},
  { 186,  198,  197},
  { 187,  200,  199},
  { 187,  188,  200},
  { 188,  201,  200},
  { 188,  180,  201},
  { 180,  202,  201},
  { 180,  181,  202},
  { 181,  189,  202},
  { 189,  203,  202},
  { 189,  190,  203},
  { 190,  229,  203},
  { 190,  191,  229},
  { 191,  166,  229},
  { 255,  168,  231},
  { 168,  147,  231},
  { 194,  207,  220},
  { 151,  238,  207},
  { 159,  196,  208},
  { 196,  209,  208},
  { 210,  197,  211},
  { 197,  223,  211},
  { 197,  212,  223},
  { 197,  198,  212},
  { 198,  213,  212},
  { 198,  186,  213},
  { 213,  199,  224},
  { 199,  200,  225},
  { 200,  214,  225},
  { 200,  201,  214},
  { 201,  215,  214},
  { 201,  202,  215},
  { 202,  216,  215},
  { 202,  228,  216},
  { 202,  203,  228},
  { 203,  229,  228},
  { 229,  166,  230},
  { 166,  204,  230},
  { 204,  184,  230},
  { 184,  254,  230},
  { 184,  255,  254},
  { 147,  293,  217},
  { 192,  219,  274},
  { 192,  193,  219},
  { 193,  206,  219},
  { 206,  185,  275},
  { 178,  277,  185},
  { 178,  278,  277},
  { 178,  194,  278},
  { 194,  220,  278},
  { 207,  237,  220},
  { 207,  238,  237},
  { 238,  239,  280},
  { 195,  240,  311},
  { 195,  159,  240},
  { 159,  208,  240},
  { 221,  210,  243},
  { 210,  222,  243},
  { 210,  211,  222},
  { 211,  223,  222},
  { 212,  246,  223},
  { 212,  213,  246},
  { 213,  224,  246},
  { 199,  225,  224},
  { 225,  214,  226},
  { 214,  215,  226},
  { 215,  227,  226},
  { 215,  216,  227},
  { 216,  252,  227},
  { 216,  228,  252},
  { 147,  217,  231},
  { 147,  232,  293},
  { 232,  218,  233},
  { 218,  234,  233},
  { 218,  235,  234},
  { 218,  205,  235},
  { 236,  192,  274},
  { 219,  206,  274},
  { 185,  277,  275},
  { 220,  237,  278},
  { 239,  195,  311},
  { 240,  208,  281},
  { 208,  258,  281},
  { 208,  209,  258},
  { 209,  221,  241},
  { 221,  242,  241},
  { 221,  243,  242},
  { 243,  222,  244},
  { 222,  260,  244},
  { 222,  245,  260},
  { 222,  223,  245},
  { 223,  246,  245},
  { 224,  247,  246},
  { 224,  225,  248},
  { 225,  249,  248},
  { 225,  226,  249},
  { 226,  250,  249},
  { 226,  251,  250},
  { 226,  227,  251},
  { 227,  252,  251},
  { 252,  228,  253},
  { 228,  229,  253},
  { 229,  271,  253},
  { 229,  230,  271},
  { 230,  254,  271},
  { 231,  217,  255},
  { 217,  293,  255},
  { 232,  256,  293},
  { 232,  233,  256},
  { 233,  234,  256},
  { 234,  257,  256},
  { 234,  235,  257},
  { 274,  206,  275},
  { 237,  238,  278},
  { 238,  280,  279},
  { 239,  311,  280},
  { 311,  240,  281},
  { 209,  282,  258},
  { 209,  241,  282},
  { 242,  243,  241},
  { 243,  244,  259},
  { 244,  260,  259},
  { 245,  246,  260},
  { 246,  261,  284},
  { 246,  247,  261},
  { 247,  224,  261},
  { 224,  262,  261},
  { 224,  248,  262},
  { 248,  264,  263},
  { 248,  249,  264},
  { 249,  265,  264},
  { 249,  250,  265},
  { 250,  266,  265},
  { 250,  251,  266},
  { 251,  267,  266},
  { 251,  268,  267},
  { 251,  252,  268},
  { 252,  269,  268},
  { 252,  253,  269},
  { 253,  270,  269},
  { 253,  271,  270},
  { 271,  254,  272},
  { 254,  255,  272},
  { 256,  257,  273},
  { 275,  277,  276},
  { 238,  279,  278},
  { 280,  310,  279},
  { 281,  258,  282},
  { 259,  260,  283},
  { 260,  284,  283},
  { 260,  246,  284},
  { 261,  262,  284},
  { 248,  285,  262},
  { 248,  263,  285},
  { 263,  286,  285},
  { 263,  264,  286},
  { 264,  287,  286},
  { 264,  265,  287},
  { 265,  288,  287},
  { 265,  266,  288},
  { 266,  267,  288},
  { 267,  289,  288},
  { 267,  268,  289},
  { 268,  290,  289},
  { 268,  269,  290},
  { 269,  270,  290},
  { 270,  291,  290},
  { 270,  271,  291},
  { 271,  272,  292},
  { 274,  324,  407},
  { 274,  275,  324},
  { 277,  278,  294},
  { 278,  295,  294},
  { 278,  307,  295},
  { 278,  296,  307},
  { 278,  297,  296},
  { 278,  279,  297},
  { 241,  243,  259},
  { 283,  298,  259},
  { 283,  284,  298},
  { 284,  312,  298},
  { 284,  262,  299},
  { 285,  286,  314},
  { 286,  300,  314},
  { 286,  287,  300},
  { 287,  288,  300},
  { 288,  289,  300},
  { 289,  301,  300},
  { 289,  290,  301},
  { 290,  302,  301},
  { 290,  303,  302},
  { 290,  291,  303},
  { 291,  304,  303},
  { 291,  271,  304},
  { 271,  292,  323},
  { 292,  272,  323},
  { 272,  305,  323},
  { 272,  255,  305},
  { 293,  256,  273},
  { 275,  276,  325},
  { 294,  295,  306},
  { 295,  307,  306},
  { 296,  308,  307},
  { 296,  309,  308},
  { 296,  297,  309},
  { 297,  279,  328},
  { 279,  310,  328},
  { 282,  241,  414},
  { 241,  259,  414},
  { 259,  298,  345},
  { 284,  299,  312},
  { 299,  262,  313},
  { 262,  331,  313},
  { 262,  285,  331},
  { 285,  314,  331},
  { 314,  300,  315},
  { 300,  316,  315},
  { 300,  317,  316},
  { 300,  318,  317},
  { 300,  301,  318},
  { 301,  319,  318},
  { 301,  302,  319},
  { 302,  320,  319},
  { 302,  303,  320},
  { 303,  321,  320},
  { 303,  304,  321},
  { 304,  322,  321},
  { 304,  341,  322},
  { 304,  271,  341},
  { 275,  325,  324},
  { 371,  276,  372},
  { 276,  277,  372},
  { 277,  294,  372},
  { 294,  306,  357},
  { 308,  326,  307},
  { 308,  309,  326},
  { 309,  327,  326},
  { 309,  297,  327},
  { 297,  328,  327},
  { 310,  280,  344},
  { 280,  311,  344},
  { 311,  329,  344},
  { 311,  281,  329},
  { 282,  414,  281},
  { 312,  299,  330},
  { 299,  313,  330},
  { 314,  332,  331},
  { 314,  315,  332},
  { 315,  333,  332},
  { 315,  316,  333},
  { 316,  334,  333},
  { 316,  335,  334},
  { 316,  317,  335},
  { 317,  336,  335},
  { 317,  318,  336},
  { 318,  337,  336},
  { 318,  319,  337},
  { 319,  338,  337},
  { 319,  320,  338},
  { 320,  339,  338},
  { 320,  321,  339},
  { 321,  340,  339},
  { 321,  322,  340},
  { 322,  341,  340},
  { 271,  342,  341},
  { 271,  323,  342},
  { 274,  479,  236},
  { 325,  276,  371},
  { 372,  294,  357},
  { 306,  307,  451},
  { 307,  358,  451},
  { 307,  326,  358},
  { 326,  327,  358},
  { 327,  343,  358},
  { 327,  328,  343},
  { 328,  310,  343},
  { 310,  344,  343},
  { 345,  298,  360},
  { 298,  417,  360},
  { 298,  312,  417},
  { 312,  361,  417},
  { 312,  330,  361},
  { 313,  331,  362},
  { 331,  332,  346},
  { 332,  347,  346},
  { 332,  333,  347},
  { 333,  348,  347},
  { 333,  334,  348},
  { 334,  335,  348},
  { 335,  349,  348},
  { 335,  350,  349},
  { 335,  336,  350},
  { 336,  351,  350},
  { 336,  337,  351},
  { 337,  352,  351},
  { 337,  338,  352},
  { 338,  353,  352},
  { 338,  339,  353},
  { 339,  354,  353},
  { 339,  340,  354},
  { 340,  355,  354},
  { 340,  341,  355},
  { 341,  342,  355},
  { 323,  305,  386},
  { 305,  255,  370},
  { 255,  356,  370},
  { 255,  293,  356},
  { 324,  325,  407},
  { 325,  371,  407},
  { 343,  344,  359},
  { 281,  414,  394},
  { 330,  313,  361},
  { 313,  362,  361},
  { 331,  346,  363},
  { 346,  364,  363},
  { 346,  347,  364},
  { 347,  348,  364},
  { 348,  365,  364},
  { 348,  366,  365},
  { 348,  349,  366},
  { 349,  350,  366},
  { 350,  351,  367},
  { 351,  352,  367},
  { 352,  353,  368},
  { 353,  354,  368},
  { 354,  369,  368},
  { 354,  355,  369},
  { 355,  342,  369},
  { 342,  384,  369},
  { 342,  385,  384},
  { 342,  323,  385},
  { 305,  387,  386},
  { 305,  370,  387},
  { 356,  293,  440},
  { 293,  273,  440},
  { 236,  479,  441},
  { 357,  373,  372},
  { 357,  374,  373},
  { 357,  306,  374},
  { 306,  451,  374},
  { 358,  343,  392},
  { 343,  359,  392},
  { 359,  375,  392},
  { 359,  376,  375},
  { 359,  344,  376},
  { 329,  393,  344},
  { 329,  281,  393},
  { 281,  394,  393},
  { 345,  360,  377},
  { 360,  417,  377},
  { 362,  378,  361},
  { 362,  331,  378},
  { 331,  363,  378},
  { 364,  365,  379},
  { 365,  380,  379},
  { 365,  366,  380},
  { 366,  381,  380},
  { 366,  350,  381},
  { 350,  367,  381},
  { 367,  382,  381},
  { 367,  352,  382},
  { 352,  383,  382},
  { 352,  368,  383},
  { 368,  405,  383},
  { 368,  369,  405},
  { 369,  384,  405},
  { 323,  386,  385},
  { 387,  370,  388},
  { 356,  440,  503},
  { 274,  480,  479},
  { 274,  442,  480},
  { 274,  407,  442},
  { 407,  371,  443},
  { 372,  389,  408},
  { 372,  373,  389},
  { 373,  390,  389},
  { 373,  374,  390},
  { 374,  391,  390},
  { 375,  376,  392},
  { 259,  453,  414},
  { 259,  345,  453},
  { 345,  377,  415},
  { 377,  395,  415},
  { 377,  396,  395},
  { 377,  417,  396},
  { 361,  418,  417},
  { 361,  397,  418},
  { 361,  378,  397},
  { 378,  398,  397},
  { 378,  399,  420},
  { 378,  363,  399},
  { 363,  400,  399},
  { 363,  364,  400},
  { 364,  401,  400},
  { 364,  379,  401},
  { 379,  380,  401},
  { 380,  402,  401},
  { 380,  381,  402},
  { 381,  403,  402},
  { 381,  404,  403},
  { 381,  382,  404},
  { 382,  383,  404},
  { 383,  405,  404},
  { 405,  384,  430},
  { 384,  432,  430},
  { 384,  433,  432},
  { 384,  385,  433},
  { 385,  386,  406},
  { 386,  439,  406},
  { 386,  387,  439},
  { 370,  356,  502},
  { 356,  503,  502},
  { 371,  444,  443},
  { 371,  445,  444},
  { 371,  372,  445},
  { 408,  389,  409},
  { 389,  447,  409},
  { 389,  390,  447},
  { 390,  448,  447},
  { 390,  410,  448},
  { 390,  411,  410},
  { 390,  391,  411},
  { 391,  412,  411},
  { 391,  374,  412},
  { 374,  451,  412},
  { 358,  392,  451},
  { 392,  413,  451},
  { 392,  376,  413},
  { 394,  414,  393},
  { 345,  415,  622},
  { 395,  396,  415},
  { 396,  416,  415},
  { 396,  417,  416},
  { 397,  398,  418},
  { 398,  378,  419},
  { 378,  420,  419},
  { 420,  399,  421},
  { 399,  422,  421},
  { 399,  400,  422},
  { 400,  401,  422},
  { 401,  423,  422},
  { 401,  424,  423},
  { 401,  402,  424},
  { 402,  425,  424},
  { 402,  403,  425},
  { 403,  426,  425},
  { 403,  404,  426},
  { 404,  427,  426},
  { 404,  428,  427},
  { 404,  429,  428},
  { 404,  405,  429},
  { 405,  430,  429},
  { 430,  432,  431},
  { 433,  385,  434},
  { 385,  435,  434},
  { 385,  436,  435},
  { 385,  437,  436},
  { 385,  406,  437},
  { 406,  438,  437},
  { 406,  439,  438},
  { 387,  388,  439},
  { 370,  502,  388},
  { 407,  443,  442},
  { 372,  408,  445},
  { 409,  446,  408},
  { 409,  447,  446},
  { 410,  449,  448},
  { 410,  411,  449},
  { 411,  450,  449},
  { 411,  412,  450},
  { 412,  451,  450},
  { 451,  413,  486},
  { 393,  452,  344},
  { 393,  414,  452},
  { 414,  453,  452},
  { 453,  345,  622},
  { 415,  510,  622},
  { 415,  454,  510},
  { 415,  416,  454},
  { 416,  455,  454},
  { 416,  417,  455},
  { 417,  418,  455},
  { 418,  456,  455},
  { 418,  457,  456},
  { 418,  398,  457},
  { 398,  458,  457},
  { 398,  459,  458},
  { 398,  460,  459},
  { 398,  419,  460},
  { 419,  461,  460},
  { 419,  420,  461},
  { 420,  462,  461},
  { 420,  421,  462},
  { 421,  463,  462},
  { 421,  422,  463},
  { 422,  464,  463},
  { 422,  423,  464},
  { 423,  424,  464},
  { 424,  465,  464},
  { 424,  425,  465},
  { 425,  426,  465},
  { 426,  466,  465},
  { 426,  427,  466},
  { 427,  467,  466},
  { 427,  428,  467},
  { 428,  468,  467},
  { 428,  429,  468},
  { 429,  469,  468},
  { 429,  430,  469},
  { 430,  470,  469},
  { 430,  431,  470},
  { 431,  432,  470},
  { 432,  471,  470},
  { 432,  433,  471},
  { 433,  472,  471},
  { 433,  434,  472},
  { 434,  473,  472},
  { 434,  474,  473},
  { 434,  435,  474},
  { 435,  475,  474},
  { 435,  436,  475},
  { 436,  499,  475},
  { 436,  437,  499},
  { 437,  476,  499},
  { 437,  438,  476},
  { 438,  439,  476},
  { 439,  477,  476},
  { 439,  478,  477},
  { 439,  388,  478},
  { 388,  502,  478},
  { 502,  503,  534},
  { 442,  504,  480},
  { 444,  445,  481},
  { 445,  408,  481},
  { 408,  505,  481},
  { 408,  446,  505},
  { 446,  482,  505},
  { 446,  447,  482},
  { 447,  483,  482},
  { 447,  448,  483},
  { 448,  449,  483},
  { 449,  484,  483},
  { 449,  450,  484},
  { 450,  451,  484},
  { 451,  485,  484},
  { 451,  486,  485},
  { 413,  376,  487},
  { 452,  453,  509},
  { 454,  488,  510},
  { 454,  455,  488},
  { 455,  489,  488},
  { 455,  456,  489},
  { 456,  457,  489},
  { 457,  490,  489},
  { 457,  458,  490},
  { 458,  491,  490},
  { 458,  492,  491},
  { 458,  459,  492},
  { 459,  493,  492},
  { 459,  460,  493},
  { 460,  494,  493},
  { 460,  461,  494},
  { 461,  462,  494},
  { 462,  495,  494},
  { 462,  463,  495},
  { 463,  464,  495},
  { 464,  496,  495},
  { 464,  465,  496},
  { 465,  497,  496},
  { 465,  466,  497},
  { 466,  467,  497},
  { 467,  468,  497},
  { 468,  498,  497},
  { 468,  469,  498},
  { 469,  470,  498},
  { 470,  472,  498},
  { 470,  471,  472},
  { 474,  475,  499},
  { 499,  476,  500},
  { 476,  477,  500},
  { 477,  501,  500},
  { 477,  478,  501},
  { 478,  502,  501},
  { 502,  534,  517},
  { 479,  480,  504},
  { 481,  505,  518},
  { 482,  506,  505},
  { 482,  507,  506},
  { 482,  483,  507},
  { 483,  484,  507},
  { 484,  485,  508},
  { 485,  486,  508},
  { 486,  413,  508},
  { 487,  376,  538},
  { 376,  344,  538},
  { 344,  521,  538},
  { 344,  452,  521},
  { 453,  622,  523},
  { 510,  488,  511},
  { 488,  489,  511},
  { 489,  525,  511},
  { 489,  512,  525},
  { 489,  490,  512},
  { 490,  491,  512},
  { 491,  513,  512},
  { 491,  492,  513},
  { 492,  493,  513},
  { 494,  496,  493},
  { 494,  495,  496},
  { 496,  497,  514},
  { 497,  498,  514},
  { 498,  515,  514},
  { 498,  472,  515},
  { 472,  473,  515},
  { 473,  529,  515},
  { 473,  474,  529},
  { 474,  530,  529},
  { 474,  499,  530},
  { 499,  531,  530},
  { 499,  516,  531},
  { 499,  500,  516},
  { 500,  501,  516},
  { 501,  517,  533},
  { 501,  502,  517},
  { 503,  440,  551},
  { 441,  479,  564},
  { 479,  504,  590},
  { 444,  552,  443},
  { 444,  481,  552},
  { 506,  507,  536},
  { 507,  484,  536},
  { 484,  508,  519},
  { 508,  413,  487},
  { 487,  538,  520},
  { 452,  509,  521},
  { 509,  522,  521},
  { 509,  523,  522},
  { 509,  453,  523},
  { 622,  510,  542},
  { 510,  524,  542},
  { 510,  511,  524},
  { 511,  525,  524},
  { 525,  512,  526},
  { 512,  513,  526},
  { 513,  493,  545},
  { 493,  496,  545},
  { 496,  514,  545},
  { 514,  515,  527},
  { 515,  528,  527},
  { 515,  529,  528},
  { 516,  532,  531},
  { 516,  501,  532},
  { 501,  533,  532},
  { 503,  551,  534},
  { 481,  518,  552},
  { 505,  535,  518},
  { 505,  506,  535},
  { 506,  536,  535},
  { 536,  484,  570},
  { 484,  519,  570},
  { 519,  508,  554},
  { 508,  487,  554},
  { 487,  537,  554},
  { 520,  538,  571},
  { 538,  521,  539},
  { 522,  540,  521},
  { 522,  523,  540},
  { 523,  541,  540},
  { 523,  622,  541},
  { 524,  543,  542},
  { 524,  544,  543},
  { 524,  525,  544},
  { 525,  557,  544},
  { 525,  526,  557},
  { 526,  513,  557},
  { 513,  545,  557},
  { 514,  527,  546},
  { 527,  528,  546},
  { 528,  529,  547},
  { 529,  530,  547},
  { 531,  532,  548},
  { 533,  549,  532},
  { 533,  517,  549},
  { 534,  550,  517},
  { 534,  551,  550},
  { 551,  440,  563},
  { 504,  442,  591},
  { 552,  518,  592},
  { 518,  553,  592},
  { 518,  567,  553},
  { 518,  535,  567},
  { 535,  536,  569},
  { 536,  570,  569},
  { 537,  487,  596},
  { 487,  520,  596},
  { 538,  555,  571},
  { 538,  572,  555},
  { 538,  573,  572},
  { 538,  539,  573},
  { 539,  583,  573},
  { 539,  521,  583},
  { 521,  584,  583},
  { 521,  540,  584},
  { 622,  542,  556},
  { 542,  543,  556},
  { 543,  601,  556},
  { 544,  557,  543},
  { 557,  545,  558},
  { 545,  559,  558},
  { 545,  514,  559},
  { 546,  528,  560},
  { 528,  547,  560},
  { 531,  548,  605},
  { 548,  532,  605},
  { 532,  549,  561},
  { 549,  517,  561},
  { 517,  662,  561},
  { 517,  550,  662},
  { 550,  562,  662},
  { 550,  551,  562},
  { 551,  563,  607},
  { 479,  590,  608},
  { 442,  443,  684},
  { 443,  552,  565},
  { 552,  592,  565},
  { 592,  553,  566},
  { 553,  567,  566},
  { 567,  535,  568},
  { 535,  569,  568},
  { 520,  571,  596},
  { 584,  540,  574},
  { 540,  541,  574},
  { 543,  557,  601},
  { 557,  558,  575},
  { 558,  559,  575},
  { 559,  514,  575},
  { 514,  546,  575},
  { 546,  576,  629},
  { 546,  587,  576},
  { 546,  560,  587},
  { 560,  547,  587},
  { 547,  530,  577},
  { 530,  604,  577},
  { 530,  531,  604},
  { 531,  605,  604},
  { 532,  606,  605},
  { 532,  561,  606},
  { 562,  588,  662},
  { 562,  607,  588},
  { 562,  551,  607},
  { 564,  479,  608},
  { 443,  565,  684},
  { 566,  567,  578},
  { 567,  579,  578},
  { 567,  568,  579},
  { 568,  580,  579},
  { 568,  569,  580},
  { 569,  595,  580},
  { 569,  581,  595},
  { 569,  570,  581},
  { 570,  582,  581},
  { 570,  519,  582},
  { 519,  613,  582},
  { 519,  554,  613},
  { 554,  537,  596},
  { 571,  555,  596},
  { 574,  541,  600},
  { 541,  622,  600},
  { 557,  575,  626},
  { 575,  585,  626},
  { 575,  546,  585},
  { 576,  587,  586},
  { 606,  561,  662},
  { 564,  608,  589},
  { 590,  504,  665},
  { 504,  591,  665},
  { 442,  684,  591},
  { 565,  592,  667},
  { 566,  593,  592},
  { 566,  610,  593},
  { 566,  578,  610},
  { 578,  594,  610},
  { 578,  579,  594},
  { 579,  580,  594},
  { 580,  595,  594},
  { 581,  582,  612},
  { 582,  613,  612},
  { 555,  597,  596},
  { 555,  572,  597},
  { 572,  573,  598},
  { 573,  599,  598},
  { 573,  583,  599},
  { 583,  584,  599},
  { 584,  621,  599},
  { 584,  574,  621},
  { 574,  600,  621},
  { 600,  622,  676},
  { 601,  557,  625},
  { 557,  626,  625},
  { 585,  602,  626},
  { 585,  546,  602},
  { 546,  603,  602},
  { 546,  629,  603},
  { 587,  604,  681},
  { 587,  547,  604},
  { 547,  577,  604},
  { 588,  635,  662},
  { 588,  607,  635},
  { 607,  563,  683},
  { 563,  636,  683},
  { 608,  590,  609},
  { 592,  593,  640},
  { 593,  610,  640},
  { 594,  611,  610},
  { 594,  595,  611},
  { 595,  581,  611},
  { 597,  614,  596},
  { 597,  615,  614},
  { 597,  616,  615},
  { 597,  617,  616},
  { 597,  572,  617},
  { 572,  618,  617},
  { 572,  598,  618},
  { 598,  619,  618},
  { 598,  599,  619},
  { 599,  620,  619},
  { 599,  621,  620},
  { 556,  601,  622},
  { 601,  623,  622},
  { 601,  624,  623},
  { 601,  625,  624},
  { 626,  602,  656},
  { 602,  627,  656},
  { 602,  628,  627},
  { 602,  603,  628},
  { 603,  629,  628},
  { 629,  576,  630},
  { 576,  631,  630},
  { 576,  661,  631},
  { 576,  632,  661},
  { 576,  586,  632},
  { 586,  587,  632},
  { 681,  604,  633},
  { 604,  634,  633},
  { 604,  605,  634},
  { 605,  606,  634},
  { 564,  589,  664},
  { 589,  637,  664},
  { 589,  608,  637},
  { 608,  609,  637},
  { 609,  590,  637},
  { 591,  684,  638},
  { 565,  639,  684},
  { 565,  667,  639},
  { 592,  640,  667},
  { 610,  641,  640},
  { 610,  611,  641},
  { 611,  642,  641},
  { 611,  581,  642},
  { 581,  612,  642},
  { 612,  643,  642},
  { 612,  613,  643},
  { 554,  596,  687},
  { 596,  644,  670},
  { 596,  645,  644},
  { 596,  614,  645},
  { 614,  646,  645},
  { 614,  647,  646},
  { 614,  615,  647},
  { 615,  648,  647},
  { 615,  616,  648},
  { 616,  617,  648},
  { 617,  649,  648},
  { 617,  618,  649},
  { 618,  619,  649},
  { 619,  650,  649},
  { 619,  620,  650},
  { 620,  651,  650},
  { 620,  621,  651},
  { 621,  652,  651},
  { 621,  600,  652},
  { 600,  653,  652},
  { 600,  676,  653},
  { 623,  624,  654},
  { 624,  625,  654},
  { 625,  655,  654},
  { 625,  626,  655},
  { 626,  656,  655},
  { 656,  627,  657},
  { 627,  658,  657},
  { 627,  659,  658},
  { 627,  628,  659},
  { 628,  660,  659},
  { 628,  629,  660},
  { 629,  630,  660},
  { 630,  631,  661},
  { 662,  635,  663},
  { 607,  683,  635},
  { 590,  665,  724},
  { 591,  638,  665},
  { 638,  684,  666},
  { 640,  641,  668},
  { 641,  642,  668},
  { 642,  669,  668},
  { 642,  643,  669},
  { 643,  686,  669},
  { 643,  613,  686},
  { 596,  670,  687},
  { 644,  671,  670},
  { 644,  672,  671},
  { 644,  645,  672},
  { 645,  673,  672},
  { 645,  646,  673},
  { 646,  674,  673},
  { 646,  647,  674},
  { 647,  648,  674},
  { 648,  649,  674},
  { 649,  650,  693},
  { 650,  675,  693},
  { 650,  651,  675},
  { 651,  652,  675},
  { 623,  677,  622},
  { 623,  654,  677},
  { 654,  655,  677},
  { 655,  678,  696},
  { 655,  656,  678},
  { 656,  679,  678},
  { 656,  657,  679},
  { 657,  658,  679},
  { 658,  659,  679},
  { 659,  660,  679},
  { 630,  680,  660},
  { 630,  661,  680},
  { 661,  632,  680},
  { 632,  587,  721},
  { 587,  681,  721},
  { 681,  633,  701},
  { 633,  634,  701},
  { 634,  682,  701},
  { 634,  606,  682},
  { 662,  663,  704},
  { 663,  635,  704},
  { 635,  683,  704},
  { 683,  636,  706},
  { 636,  723,  706},
  { 636,  563,  723},
  { 563,  746,  723},
  { 637,  590,  748},
  { 590,  724,  748},
  { 638,  666,  665},
  { 667,  707,  639},
  { 707,  667,  726},
  { 667,  640,  726},
  { 640,  727,  726},
  { 640,  668,  727},
  { 668,  685,  727},
  { 668,  710,  685},
  { 668,  669,  710},
  { 669,  686,  710},
  { 613,  687,  686},
  { 613,  554,  687},
  { 670,  688,  687},
  { 670,  689,  688},
  { 670,  690,  689},
  { 670,  671,  690},
  { 671,  691,  690},
  { 671,  672,  691},
  { 672,  715,  691},
  { 672,  673,  715},
  { 673,  674,  715},
  { 674,  692,  715},
  { 674,  649,  692},
  { 693,  675,  694},
  { 675,  718,  694},
  { 675,  652,  718},
  { 652,  653,  718},
  { 653,  676,  695},
  { 676,  622,  695},
  { 622,  677,  739},
  { 677,  655,  739},
  { 655,  696,  739},
  { 696,  678,  697},
  { 678,  679,  697},
  { 679,  698,  697},
  { 679,  660,  698},
  { 660,  719,  698},
  { 660,  680,  719},
  { 680,  699,  719},
  { 680,  632,  700},
  { 632,  721,  700},
  { 701,  682,  722},
  { 682,  702,  722},
  { 682,  703,  702},
  { 682,  606,  703},
  { 606,  662,  703},
  { 662,  704,  703},
  { 683,  706,  705},
  { 746,  563,  860},
  { 664,  748,  747},
  { 664,  637,  748},
  { 665,  666,  725},
  { 666,  684,  725},
  { 684,  639,  768},
  { 639,  707,  768},
  { 727,  685,  708},
  { 685,  709,  708},
  { 685,  710,  709},
  { 710,  686,  711},
  { 686,  733,  711},
  { 686,  712,  733},
  { 686,  687,  712},
  { 688,  689,  734},
  { 689,  713,  734},
  { 689,  690,  713},
  { 690,  714,  713},
  { 690,  691,  714},
  { 691,  715,  714},
  { 692,  716,  715},
  { 692,  717,  716},
  { 692,  649,  717},
  { 649,  693,  717},
  { 693,  694,  717},
  { 694,  736,  717},
  { 694,  718,  736},
  { 653,  738,  718},
  { 653,  695,  738},
  { 696,  697,  739},
  { 697,  698,  741},
  { 698,  719,  741},
  { 699,  680,  720},
  { 680,  700,  720},
  { 681,  701,  722},
  { 705,  706,  723},
  { 724,  665,  749},
  { 725,  684,  807},
  { 684,  768,  807},
  { 708,  728,  727},
  { 708,  729,  728},
  { 708,  709,  729},
  { 709,  730,  729},
  { 709,  710,  730},
  { 710,  731,  730},
  { 710,  757,  731},
  { 710,  711,  757},
  { 711,  732,  757},
  { 711,  733,  732},
  { 712,  687,  733},
  { 687,  776,  733},
  { 687,  760,  776},
  { 687,  688,  760},
  { 734,  713,  714},
  { 717,  736,  735},
  { 718,  737,  736},
  { 718,  738,  737},
  { 695,  622,  763},
  { 622,  739,  763},
  { 739,  697,  740},
  { 697,  741,  740},
  { 719,  699,  764},
  { 699,  742,  764},
  { 699,  720,  742},
  { 720,  700,  742},
  { 700,  721,  765},
  { 721,  743,  765},
  { 721,  681,  743},
  { 681,  744,  743},
  { 681,  722,  744},
  { 702,  703,  805},
  { 703,  745,  785},
  { 703,  704,  745},
  { 704,  767,  745},
  { 704,  683,  767},
  { 683,  705,  767},
  { 705,  723,  746},
  { 768,  707,  750},
  { 707,  751,  750},
  { 707,  726,  751},
  { 726,  752,  751},
  { 726,  770,  752},
  { 726,  753,  770},
  { 726,  727,  753},
  { 727,  754,  753},
  { 727,  728,  754},
  { 728,  729,  754},
  { 729,  755,  754},
  { 729,  730,  755},
  { 730,  756,  755},
  { 730,  731,  756},
  { 731,  757,  756},
  { 732,  733,  757},
  { 733,  758,  774},
  { 733,  759,  758},
  { 733,  776,  759},
  { 688,  778,  760},
  { 688,  734,  778},
  { 734,  714,  778},
  { 717,  735,  716},
  { 735,  762,  761},
  { 735,  736,  762},
  { 738,  763,  737},
  { 738,  695,  763},
  { 739,  799,  763},
  { 739,  800,  799},
  { 740,  780,  739},
  { 740,  781,  780},
  { 740,  741,  781},
  { 741,  719,  781},
  { 719,  764,  781},
  { 742,  700,  782},
  { 700,  765,  782},
  { 765,  743,  766},
  { 743,  784,  766},
  { 743,  744,  784},
  { 744,  722,  784},
  { 702,  805,  722},
  { 724,  806,  748},
  { 724,  749,  806},
  { 768,  750,  769},
  { 750,  752,  769},
  { 750,  751,  752},
  { 752,  770,  789},
  { 753,  771,  770},
  { 753,  754,  771},
  { 754,  755,  771},
  { 755,  772,  771},
  { 755,  756,  772},
  { 756,  757,  772},
  { 757,  773,  772},
  { 757,  733,  773},
  { 733,  774,  773},
  { 758,  759,  774},
  { 759,  775,  774},
  { 759,  776,  775},
  { 776,  760,  777},
  { 760,  778,  777},
  { 715,  716,  779},
  { 735,  796,  716},
  { 735,  761,  796},
  { 761,  762,  796},
  { 736,  798,  762},
  { 736,  737,  798},
  { 737,  763,  798},
  { 800,  739,  780},
  { 764,  742,  781},
  { 742,  782,  781},
  { 782,  765,  783},
  { 765,  766,  783},
  { 766,  784,  783},
  { 722,  805,  784},
  { 805,  703,  785},
  { 745,  767,  786},
  { 767,  826,  786},
  { 767,  705,  746},
  { 749,  787,  806},
  { 807,  845,  725},
  { 807,  768,  788},
  { 768,  769,  788},
  { 769,  752,  809},
  { 752,  789,  809},
  { 770,  790,  789},
  { 770,  771,  790},
  { 774,  791,  773},
  { 774,  775,  791},
  { 775,  792,  791},
  { 775,  813,  792},
  { 775,  776,  813},
  { 776,  793,  813},
  { 776,  777,  793},
  { 777,  778,  793},
  { 778,  794,  793},
  { 778,  714,  794},
  { 714,  795,  794},
  { 779,  855,  819},
  { 779,  716,  855},
  { 716,  796,  855},
  { 762,  798,  796},
  { 798,  797,  796},
  { 798,  763,  820},
  { 800,  780,  801},
  { 780,  802,  801},
  { 780,  781,  802},
  { 781,  804,  803},
  { 781,  782,  804},
  { 782,  783,  804},
  { 784,  805,  824},
  { 747,  748,  883},
  { 749,  827,  841},
  { 749,  665,  827},
  { 665,  844,  827},
  { 665,  725,  844},
  { 725,  845,  917},
  { 788,  808,  807},
  { 788,  829,  808},
  { 788,  769,  829},
  { 789,  810,  809},
  { 789,  790,  810},
  { 790,  771,  810},
  { 773,  791,  811},
  { 791,  812,  811},
  { 791,  792,  812},
  { 792,  813,  812},
  { 793,  814,  813},
  { 793,  815,  814},
  { 793,  794,  815},
  { 794,  835,  815},
  { 794,  816,  835},
  { 794,  795,  816},
  { 795,  817,  816},
  { 795,  714,  817},
  { 714,  818,  817},
  { 714,  715,  818},
  { 715,  779,  818},
  { 779,  819,  818},
  { 798,  820,  797},
  { 763,  799,  820},
  { 802,  821,  801},
  { 802,  781,  821},
  { 781,  803,  821},
  { 803,  822,  821},
  { 803,  823,  822},
  { 803,  804,  823},
  { 804,  783,  823},
  { 783,  824,  823},
  { 783,  784,  824},
  { 805,  825,  824},
  { 805,  859,  825},
  { 805,  785,  859},
  { 785,  745,  826},
  { 745,  786,  826},
  { 806,  840,  748},
  { 787,  749,  841},
  { 725,  917,  844},
  { 807,  846,  845},
  { 807,  808,  846},
  { 808,  828,  846},
  { 808,  829,  828},
  { 769,  809,  829},
  { 866,  809,  830},
  { 809,  810,  830},
  { 810,  831,  830},
  { 810,  771,  831},
  { 771,  922,  831},
  { 771,  772,  922},
  { 772,  773,  890},
  { 773,  811,  890},
  { 811,  847,  890},
  { 811,  848,  847},
  { 811,  812,  848},
  { 812,  832,  848},
  { 812,  833,  832},
  { 812,  813,  833},
  { 813,  850,  833},
  { 813,  814,  834},
  { 814,  853,  834},
  { 814,  815,  853},
  { 815,  835,  853},
  { 835,  816,  876},
  { 816,  836,  876},
  { 816,  817,  836},
  { 817,  818,  836},
  { 818,  837,  836},
  { 818,  819,  837},
  { 819,  855,  837},
  { 797,  906,  796},
  { 797,  820,  906},
  { 820,  838,  906},
  { 820,  799,  838},
  { 799,  800,  838},
  { 801,  857,  800},
  { 801,  821,  857},
  { 821,  822,  857},
  { 822,  839,  857},
  { 822,  823,  839},
  { 825,  859,  824},
  { 859,  785,  826},
  { 748,  840,  883},
  { 806,  841,  840},
  { 806,  787,  841},
  { 841,  842,  861},
  { 841,  827,  842},
  { 827,  843,  842},
  { 827,  844,  843},
  { 809,  866,  829},
  { 848,  832,  869},
  { 832,  833,  849},
  { 833,  850,  849},
  { 850,  813,  851},
  { 813,  852,  851},
  { 813,  834,  852},
  { 834,  853,  852},
  { 876,  836,  854},
  { 836,  837,  854},
  { 838,  800,  856},
  { 839,  858,  857},
  { 839,  881,  858},
  { 839,  823,  881},
  { 823,  824,  881},
  { 824,  859,  912},
  { 826,  767, 1096},
  { 767,  746, 1096},
  { 840,  841,  884},
  { 841,  861,  884},
  { 861,  842,  915},
  { 842,  862,  915},
  { 842,  843,  862},
  { 843,  844,  862},
  { 844,  917,  862},
  { 917,  845,  863},
  { 845,  864,  863},
  { 845,  846,  864},
  { 846,  865,  864},
  { 846,  828,  865},
  { 830,  867,  866},
  { 830,  831,  867},
  { 831,  922,  867},
  { 772,  890,  922},
  { 847,  848,  868},
  { 848,  869,  868},
  { 832,  870,  869},
  { 832,  849,  870},
  { 849,  871,  870},
  { 849,  850,  871},
  { 850,  872,  871},
  { 850,  851,  872},
  { 851,  873,  872},
  { 851,  852,  873},
  { 852,  874,  873},
  { 852,  853,  874},
  { 853,  875,  874},
  { 853,  835,  875},
  { 835,  876,  875},
  { 854,  837,  876},
  { 837,  877,  876},
  { 837,  855,  877},
  { 796,  905,  855},
  { 796,  906,  905},
  { 906,  838,  907},
  { 800,  857,  856},
  { 857,  878,  856},
  { 857,  879,  878},
  { 857,  858,  879},
  { 858,  880,  879},
  { 858,  881,  880},
  { 824,  912,  881},
  { 859,  826,  912},
  { 746,  860, 1096},
  { 883,  840,  942},
  { 840,  884,  942},
  { 884,  861,  995},
  { 915,  862,  885},
  { 862,  917,  885},
  { 863,  886,  917},
  { 863,  918,  886},
  { 863,  864,  918},
  { 864,  887,  918},
  { 864,  865,  887},
  { 865,  828,  887},
  { 828,  829,  887},
  { 866,  889,  888},
  { 866,  867,  889},
  { 922,  890,  923},
  { 847,  891,  890},
  { 847,  892,  891},
  { 847,  868,  892},
  { 868,  893,  892},
  { 868,  894,  893},
  { 868,  869,  894},
  { 869,  895,  894},
  { 869,  870,  895},
  { 870,  896,  895},
  { 870,  897,  896},
  { 870,  898,  897},
  { 870,  899,  898},
  { 870,  871,  899},
  { 871,  900,  899},
  { 871,  872,  900},
  { 872,  901,  900},
  { 872,  873,  901},
  { 873,  902,  901},
  { 873,  874,  902},
  { 874,  903,  902},
  { 874,  875,  903},
  { 875,  876,  903},
  { 876,  904,  903},
  { 876,  877,  904},
  { 877,  905,  904},
  { 877,  855,  905},
  { 838,  937,  907},
  { 838,  856,  908},
  { 856,  909,  908},
  { 856,  878,  909},
  { 878,  910,  909},
  { 878,  879,  910},
  { 879,  911,  910},
  { 879,  880,  911},
  { 880,  881,  911},
  { 883,  913,  914},
  { 883,  942,  913},
  { 942,  884,  943},
  { 884,  995,  943},
  { 861,  915,  995},
  { 915,  885,  996},
  { 885,  917,  916},
  { 917,  886,  918},
  { 918,  887,  919},
  { 887,  829,  919},
  { 866,  967,  829},
  { 866,  920,  967},
  { 866,  888,  920},
  { 888,  921,  920},
  { 888,  889,  921},
  { 889,  867,  921},
  { 867,  946,  921},
  { 867,  922,  946},
  { 891,  892,  924},
  { 892,  893,  924},
  { 893,  894,  947},
  { 894,  925,  947},
  { 894,  895,  925},
  { 895,  926,  925},
  { 895,  927,  926},
  { 895,  896,  927},
  { 896,  928,  927},
  { 896,  897,  928},
  { 897,  929,  928},
  { 897,  898,  929},
  { 898,  930,  929},
  { 898,  899,  930},
  { 899,  931,  930},
  { 899,  900,  931},
  { 900,  932,  931},
  { 900,  901,  932},
  { 901,  933,  932},
  { 901,  902,  933},
  { 902,  903,  933},
  { 903,  955,  933},
  { 903,  904,  955},
  { 904,  956,  955},
  { 904,  905,  956},
  { 905,  934,  956},
  { 905,  935,  934},
  { 905,  906,  935},
  { 906,  936,  935},
  { 906,  958,  936},
  { 906,  907,  958},
  { 838,  908,  937},
  { 908,  987,  986},
  { 908,  909,  987},
  { 909,  938,  987},
  { 909,  910,  938},
  { 910,  939,  938},
  { 910,  911,  939},
  { 911,  881,  939},
  { 881,  912,  940},
  { 912,  941,  940},
  { 912,  826,  941},
  { 882,  992,  860},
  { 914,  913,  942},
  { 885,  916,  996},
  { 917,  944,  997},
  { 917,  918,  944},
  { 918,  919,  944},
  { 919,  829,  967},
  { 967,  920,  968},
  { 920,  945,  968},
  { 920,  921,  945},
  { 921,  946,  945},
  { 922, 1064,  946},
  { 923,  970,  969},
  { 923,  890,  970},
  { 890, 1001,  970},
  { 890,  891, 1001},
  { 891, 1002, 1001},
  { 891,  924, 1002},
  { 924, 1003, 1002},
  { 924,  893, 1003},
  { 893,  947, 1003},
  { 947,  925,  948},
  { 925,  949,  948},
  { 925,  926,  949},
  { 926,  950,  949},
  { 926,  927,  950},
  { 927,  951,  950},
  { 927,  928,  951},
  { 928,  952,  951},
  { 928,  929,  952},
  { 929,  953,  952},
  { 929,  930,  953},
  { 930,  954,  953},
  { 930,  931,  954},
  { 931,  978,  954},
  { 931,  932,  978},
  { 932,  933,  978},
  { 933,  955,  978},
  { 956,  934,  957},
  { 934,  935,  982},
  { 935, 1009,  982},
  { 935,  983, 1009},
  { 935,  936,  983},
  { 936,  958,  983},
  { 907,  937,  958},
  { 937,  908,  986},
  { 938,  959,  987},
  { 938,  960,  959},
  { 938,  939,  960},
  { 881,  990,  939},
  { 881,  940,  990},
  { 940,  962,  961},
  { 940,  941,  962},
  { 941, 1052,  962},
  { 941,  826, 1052},
  {1096, 1095,  826},
  { 914,  963,  964},
  { 914,  942,  963},
  { 942,  965,  963},
  { 942,  994,  965},
  { 942,  943,  994},
  { 995,  915,  966},
  { 915,  996,  966},
  { 916, 1034,  996},
  { 916,  917, 1034},
  { 917,  997, 1034},
  { 945,  946,  968},
  { 922, 1019, 1064},
  { 922,  923, 1019},
  { 923,  969, 1019},
  {1003,  947,  971},
  { 947,  972,  971},
  { 947,  973,  972},
  { 947,  948,  973},
  { 948,  974,  973},
  { 948,  949,  974},
  { 949,  975,  974},
  { 949,  950,  975},
  { 950,  976,  975},
  { 950,  951,  976},
  { 951,  977,  976},
  { 951,  952,  977},
  { 952,  953,  977},
  { 953,  978,  977},
  { 953,  954,  978},
  { 978,  955,  979},
  { 955,  980,  979},
  { 955,  956,  980},
  { 957,  981,  956},
  { 957,  934,  981},
  {1009,  983, 1026},
  { 958,  984,  983},
  { 958,  985,  984},
  { 958,  937,  985},
  { 987,  959,  988},
  { 959,  989,  988},
  { 959,  960,  989},
  { 960,  990,  989},
  { 960,  939,  990},
  { 940,  991,  990},
  { 940,  961,  991},
  { 961,  962,  991},
  { 962, 1052,  991},
  {1052,  826, 1095},
  { 860,  992, 1096},
  { 964,  963,  993},
  { 966,  996,  995},
  { 944,  998,  997},
  { 944,  919,  998},
  { 919,  967,  998},
  { 967,  999, 1017},
  { 967,  968,  999},
  { 968, 1000,  999},
  { 968,  946, 1000},
  {1003,  971, 1021},
  { 971,  972, 1021},
  { 972,  973, 1004},
  { 973, 1005, 1004},
  { 973,  974, 1005},
  { 974, 1006, 1005},
  { 974,  975, 1006},
  { 975,  976, 1006},
  { 976, 1007, 1006},
  { 976,  977, 1007},
  { 977, 1023, 1007},
  { 977,  978, 1023},
  { 978, 1024, 1023},
  { 978,  979, 1024},
  { 979, 1008, 1024},
  { 979,  980, 1008},
  { 980,  956, 1008},
  { 956,  981, 1008},
  { 981,  934, 1025},
  { 934,  982, 1025},
  { 983,  984, 1010},
  { 984, 1043, 1010},
  { 984,  985, 1043},
  { 985, 1011, 1043},
  { 985,  937, 1011},
  { 937, 1012, 1011},
  { 937,  986, 1012},
  { 986, 1028, 1012},
  { 986,  987, 1028},
  { 987,  988, 1013},
  { 988, 1014, 1013},
  { 988,  989, 1014},
  { 989,  990, 1014},
  { 990, 1030, 1014},
  { 990,  991, 1146},
  { 993, 1031, 1015},
  { 993,  963, 1031},
  { 963,  965, 1031},
  { 965,  994, 1031},
  { 943,  995, 1098},
  { 996, 1034, 1033},
  { 997, 1016, 1034},
  { 997,  998, 1016},
  { 999, 1000, 1018},
  {1000, 1036, 1018},
  {1000,  946, 1036},
  { 969, 1037, 1019},
  { 969,  970, 1037},
  { 970, 1001, 1037},
  {1001, 1020, 1037},
  {1001, 1002, 1020},
  {1002, 1003, 1020},
  {1003, 1021, 1020},
  {1021,  972, 1040},
  { 972, 1004, 1040},
  {1006, 1023, 1022},
  {1006, 1007, 1023},
  { 981, 1042, 1008},
  { 981, 1025, 1042},
  { 982, 1026, 1025},
  { 982, 1009, 1026},
  { 983, 1027, 1026},
  { 983, 1010, 1027},
  {1010, 1043, 1027},
  {1011, 1028, 1043},
  {1011, 1012, 1028},
  {1028,  987, 1049},
  { 987, 1013, 1049},
  {1013, 1014, 1029},
  {1014, 1030, 1029},
  {1030,  990, 1146},
  {1015, 1031, 1032},
  { 943, 1098,  994},
  { 995, 1054, 1098},
  { 995,  996, 1054},
  { 996, 1099, 1054},
  { 996, 1033, 1099},
  {1034, 1016, 1035},
  {1016, 1058, 1035},
  {1016,  998, 1058},
  { 999, 1061, 1017},
  { 999, 1018, 1061},
  {1018, 1036, 1061},
  { 946, 1108, 1036},
  { 946, 1064, 1108},
  {1064, 1019, 1065},
  {1020, 1038, 1037},
  {1020, 1039, 1038},
  {1020, 1068, 1039},
  {1020, 1021, 1068},
  {1021, 1040, 1068},
  {1004, 1069, 1040},
  {1004, 1005, 1069},
  {1005, 1006, 1069},
  {1006, 1022, 1070},
  {1023, 1041, 1022},
  {1023, 1024, 1041},
  {1024, 1008, 1041},
  {1008, 1075, 1041},
  {1025, 1026, 1079},
  {1026, 1027, 1079},
  {1027, 1080, 1079},
  {1027, 1043, 1080},
  {1043, 1028, 1044},
  {1028, 1045, 1044},
  {1028, 1046, 1045},
  {1028, 1047, 1046},
  {1028, 1048, 1047},
  {1028, 1049, 1048},
  {1049, 1013, 1050},
  {1013, 1029, 1050},
  {1029, 1094, 1050},
  {1029, 1051, 1094},
  {1029, 1030, 1051},
  {1095, 1096, 1147},
  {1096,  992, 1190},
  {1032, 1148, 1053},
  {1032, 1031, 1148},
  {1033, 1055, 1099},
  {1033, 1056, 1055},
  {1033, 1034, 1056},
  {1034, 1035, 1056},
  {1035, 1057, 1056},
  {1035, 1058, 1057},
  { 998,  967, 1059},
  { 967, 1017, 1059},
  {1017, 1061, 1060},
  {1061, 1036, 1062},
  {1036, 1063, 1062},
  {1036, 1108, 1063},
  {1019, 1066, 1065},
  {1019, 1037, 1066},
  {1037, 1067, 1066},
  {1037, 1038, 1067},
  {1038, 1068, 1067},
  {1038, 1039, 1068},
  {1006, 1070, 1069},
  {1070, 1022, 1071},
  {1022, 1072, 1071},
  {1022, 1073, 1072},
  {1022, 1041, 1073},
  {1041, 1074, 1073},
  {1041, 1075, 1074},
  {1075, 1008, 1076},
  {1008, 1077, 1076},
  {1008, 1042, 1077},
  {1042, 1025, 1077},
  {1025, 1078, 1077},
  {1025, 1079, 1078},
  {1043, 1081, 1080},
  {1043, 1082, 1081},
  {1043, 1044, 1082},
  {1044, 1083, 1082},
  {1044, 1084, 1083},
  {1044, 1085, 1084},
  {1044, 1045, 1085},
  {1045, 1086, 1085},
  {1045, 1046, 1086},
  {1046, 1087, 1086},
  {1046, 1047, 1087},
  {1047, 1088, 1087},
  {1047, 1089, 1088},
  {1047, 1090, 1089},
  {1047, 1048, 1090},
  {1048, 1091, 1090},
  {1048, 1049, 1091},
  {1049, 1092, 1091},
  {1049, 1050, 1092},
  {1050, 1093, 1092},
  {1050, 1094, 1093},
  {1051, 1030, 1146},
  {1146,  991, 1052},
  {1053, 1148, 1149},
  {1031,  994, 1150},
  { 994, 1151, 1150},
  { 994, 1097, 1151},
  { 994, 1098, 1097},
  {1054, 1191, 1098},
  {1099, 1055, 1100},
  {1055, 1056, 1100},
  {1056, 1057, 1101},
  {1057, 1058, 1154},
  {1058, 1102, 1154},
  {1058,  998, 1102},
  { 998, 1103, 1102},
  { 998, 1059, 1103},
  {1059, 1195, 1103},
  {1059, 1017, 1195},
  {1017, 1104, 1195},
  {1017, 1105, 1104},
  {1017, 1060, 1105},
  {1060, 1061, 1105},
  {1061, 1106, 1105},
  {1061, 1062, 1106},
  {1062, 1107, 1106},
  {1062, 1063, 1107},
  {1063, 1108, 1107},
  {1064, 1109, 1108},
  {1064, 1159, 1109},
  {1064, 1065, 1159},
  {1065, 1110, 1159},
  {1065, 1066, 1110},
  {1066, 1067, 1110},
  {1067, 1111, 1110},
  {1067, 1068, 1111},
  {1068, 1112, 1111},
  {1068, 1040, 1112},
  {1040, 1069, 1112},
  {1069, 1113, 1112},
  {1069, 1114, 1113},
  {1069, 1070, 1114},
  {1070, 1115, 1114},
  {1070, 1071, 1115},
  {1071, 1116, 1115},
  {1071, 1072, 1116},
  {1072, 1117, 1116},
  {1072, 1073, 1117},
  {1073, 1118, 1117},
  {1073, 1074, 1118},
  {1074, 1119, 1118},
  {1074, 1075, 1119},
  {1075, 1120, 1119},
  {1075, 1121, 1120},
  {1075, 1076, 1121},
  {1076, 1122, 1121},
  {1076, 1077, 1122},
  {1077, 1123, 1122},
  {1077, 1078, 1123},
  {1078, 1124, 1123},
  {1078, 1079, 1124},
  {1079, 1125, 1124},
  {1079, 1126, 1125},
  {1079, 1080, 1126},
  {1080, 1127, 1126},
  {1080, 1128, 1127},
  {1080, 1081, 1128},
  {1081, 1129, 1128},
  {1081, 1082, 1129},
  {1082, 1130, 1129},
  {1082, 1131, 1130},
  {1082, 1083, 1131},
  {1083, 1132, 1131},
  {1083, 1084, 1132},
  {1084, 1133, 1132},
  {1084, 1134, 1133},
  {1084, 1085, 1134},
  {1085, 1135, 1134},
  {1085, 1086, 1135},
  {1086, 1136, 1135},
  {1086, 1087, 1136},
  {1087, 1137, 1136},
  {1087, 1088, 1137},
  {1088, 1138, 1137},
  {1088, 1089, 1138},
  {1089, 1139, 1138},
  {1089, 1090, 1139},
  {1090, 1140, 1139},
  {1090, 1091, 1140},
  {1091, 1141, 1140},
  {1091, 1092, 1141},
  {1092, 1142, 1141},
  {1092, 1093, 1142},
  {1093, 1143, 1142},
  {1093, 1094, 1143},
  {1094, 1144, 1143},
  {1094, 1145, 1144},
  {1094, 1051, 1145},
  {1052, 1231, 1146},
  {1052, 1095, 1189},
  {1031, 1150, 1148},
  {1097, 1098, 1151},
  {1191, 1054, 1192},
  {1054, 1099, 1192},
  {1099, 1100, 1152},
  {1100, 1056, 1152},
  {1056, 1153, 1152},
  {1056, 1101, 1153},
  {1101, 1057, 1153},
  {1057, 1154, 1153},
  {1154, 1102, 1155},
  {1102, 1156, 1155},
  {1102, 1103, 1156},
  {1103, 1195, 1156},
  {1105, 1106, 1157},
  {1106, 1107, 1157},
  {1108, 1158, 1107},
  {1108, 1109, 1158},
  {1109, 1159, 1158},
  {1110, 1111, 1160},
  {1111, 1161, 1160},
  {1111, 1112, 1161},
  {1112, 1162, 1161},
  {1112, 1113, 1162},
  {1113, 1114, 1162},
  {1114, 1163, 1162},
  {1114, 1115, 1163},
  {1116, 1117, 1115},
  {1117, 1164, 1115},
  {1117, 1118, 1164},
  {1118, 1119, 1164},
  {1119, 1165, 1164},
  {1119, 1120, 1165},
  {1120, 1166, 1165},
  {1120, 1121, 1166},
  {1121, 1167, 1166},
  {1121, 1122, 1167},
  {1122, 1168, 1167},
  {1122, 1123, 1168},
  {1123, 1124, 1168},
  {1124, 1125, 1169},
  {1125, 1170, 1169},
  {1125, 1171, 1170},
  {1125, 1126, 1171},
  {1126, 1127, 1171},
  {1127, 1172, 1171},
  {1127, 1173, 1172},
  {1127, 1128, 1173},
  {1128, 1174, 1173},
  {1128, 1129, 1174},
  {1129, 1130, 1174},
  {1130, 1175, 1174},
  {1130, 1131, 1175},
  {1131, 1176, 1175},
  {1131, 1132, 1176},
  {1132, 1177, 1176},
  {1132, 1133, 1177},
  {1133, 1178, 1177},
  {1133, 1134, 1178},
  {1134, 1179, 1178},
  {1134, 1135, 1179},
  {1135, 1180, 1179},
  {1135, 1136, 1180},
  {1136, 1181, 1180},
  {1136, 1137, 1181},
  {1137, 1182, 1181},
  {1137, 1138, 1182},
  {1138, 1139, 1182},
  {1139, 1183, 1182},
  {1139, 1140, 1183},
  {1140, 1184, 1183},
  {1140, 1141, 1184},
  {1141, 1185, 1184},
  {1141, 1142, 1185},
  {1142, 1186, 1185},
  {1142, 1143, 1186},
  {1143, 1227, 1186},
  {1143, 1144, 1227},
  {1144, 1187, 1227},
  {1144, 1145, 1187},
  {1145, 1051, 1187},
  {1051, 1146, 1187},
  {1146, 1188, 1187},
  {1146, 1231, 1188},
  {1052, 1189, 1231},
  {1151, 1098, 1232},
  {1098, 1191, 1232},
  {1099, 1152, 1192},
  {1152, 1153, 1271},
  {1154, 1194, 1193},
  {1154, 1155, 1194},
  {1155, 1195, 1194},
  {1155, 1156, 1195},
  {1195, 1104, 1273},
  {1104, 1196, 1273},
  {1104, 1105, 1196},
  {1105, 1157, 1196},
  {1157, 1197, 1196},
  {1157, 1107, 1197},
  {1158, 1159, 1275},
  {1159, 1198, 1275},
  {1159, 1110, 1198},
  {1110, 1160, 1198},
  {1161, 1199, 1160},
  {1161, 1162, 1199},
  {1162, 1163, 1199},
  {1163, 1239, 1199},
  {1163, 1115, 1239},
  {1115, 1200, 1239},
  {1115, 1164, 1200},
  {1164, 1201, 1200},
  {1164, 1165, 1201},
  {1165, 1202, 1201},
  {1165, 1166, 1202},
  {1166, 1167, 1202},
  {1167, 1203, 1202},
  {1167, 1204, 1203},
  {1167, 1168, 1204},
  {1168, 1205, 1204},
  {1168, 1206, 1205},
  {1168, 1207, 1206},
  {1168, 1208, 1207},
  {1168, 1124, 1208},
  {1124, 1209, 1208},
  {1124, 1169, 1209},
  {1169, 1170, 1209},
  {1170, 1171, 1209},
  {1171, 1210, 1209},
  {1171, 1211, 1210},
  {1171, 1172, 1211},
  {1172, 1212, 1211},
  {1172, 1213, 1212},
  {1172, 1173, 1213},
  {1173, 1214, 1213},
  {1173, 1174, 1214},
  {1174, 1215, 1214},
  {1174, 1216, 1215},
  {1174, 1175, 1216},
  {1175, 1217, 1216},
  {1175, 1176, 1217},
  {1176, 1218, 1217},
  {1176, 1177, 1218},
  {1177, 1219, 1218},
  {1177, 1178, 1219},
  {1178, 1220, 1219},
  {1178, 1179, 1220},
  {1179, 1221, 1220},
  {1179, 1180, 1221},
  {1180, 1222, 1221},
  {1180, 1181, 1222},
  {1181, 1223, 1222},
  {1181, 1182, 1223},
  {1182, 1259, 1223},
  {1182, 1224, 1259},
  {1182, 1183, 1224},
  {1183, 1184, 1224},
  {1184, 1225, 1224},
  {1184, 1185, 1225},
  {1185, 1186, 1225},
  {1186, 1226, 1225},
  {1186, 1227, 1226},
  {1187, 1228, 1227},
  {1187, 1230, 1229},
  {1187, 1188, 1230},
  {1188, 1231, 1230},
  {1189, 1298, 1231},
  {1189, 1095, 1298},
  {1147, 1268, 1095},
  {1148, 1150, 1149},
  {1191, 1192, 1232},
  {1192, 1152, 1233},
  {1152, 1271, 1233},
  {1153, 1234, 1271},
  {1153, 1154, 1234},
  {1154, 1235, 1234},
  {1154, 1193, 1235},
  {1193, 1236, 1235},
  {1193, 1194, 1236},
  {1195, 1302, 1194},
  {1195, 1273, 1302},
  {1196, 1197, 1273},
  {1107, 1158, 1197},
  {1158, 1237, 1197},
  {1158, 1275, 1237},
  {1198, 1238, 1275},
  {1198, 1306, 1238},
  {1198, 1160, 1306},
  {1160, 1199, 1306},
  {1199, 1239, 1306},
  {1200, 1240, 1239},
  {1201, 1202, 1200},
  {1202, 1203, 1241},
  {1203, 1242, 1241},
  {1203, 1243, 1242},
  {1203, 1204, 1243},
  {1204, 1205, 1243},
  {1205, 1244, 1243},
  {1205, 1206, 1244},
  {1206, 1245, 1244},
  {1206, 1207, 1245},
  {1207, 1246, 1245},
  {1207, 1208, 1246},
  {1208, 1280, 1246},
  {1208, 1247, 1280},
  {1208, 1209, 1247},
  {1209, 1210, 1247},
  {1210, 1248, 1247},
  {1210, 1211, 1248},
  {1211, 1249, 1248},
  {1211, 1212, 1249},
  {1212, 1250, 1249},
  {1212, 1213, 1250},
  {1213, 1251, 1250},
  {1213, 1214, 1251},
  {1214, 1215, 1251},
  {1215, 1216, 1251},
  {1216, 1252, 1251},
  {1216, 1217, 1252},
  {1217, 1218, 1252},
  {1218, 1253, 1252},
  {1218, 1219, 1253},
  {1219, 1254, 1253},
  {1219, 1220, 1254},
  {1220, 1255, 1254},
  {1220, 1221, 1255},
  {1221, 1256, 1255},
  {1221, 1222, 1256},
  {1222, 1257, 1256},
  {1222, 1223, 1257},
  {1223, 1258, 1257},
  {1223, 1259, 1258},
  {1224, 1260, 1259},
  {1224, 1261, 1260},
  {1224, 1225, 1261},
  {1225, 1262, 1261},
  {1225, 1263, 1262},
  {1225, 1264, 1263},
  {1225, 1226, 1264},
  {1226, 1265, 1264},
  {1226, 1296, 1265},
  {1226, 1227, 1296},
  {1227, 1297, 1296},
  {1227, 1228, 1297},
  {1228, 1187, 1297},
  {1187, 1266, 1297},
  {1187, 1229, 1266},
  {1229, 1230, 1266},
  {1230, 1231, 1267},
  {1095, 1268, 1298},
  {1268, 1147, 1269},
  {1149, 1300, 1299},
  {1149, 1301, 1300},
  {1149, 1150, 1301},
  {1150, 1325, 1301},
  {1150, 1151, 1325},
  {1151, 1232, 1352},
  {1232, 1192, 1352},
  {1192, 1270, 1352},
  {1192, 1233, 1270},
  {1233, 1271, 1270},
  {1271, 1234, 1353},
  {1234, 1235, 1272},
  {1235, 1236, 1272},
  {1236, 1194, 1272},
  {1197, 1237, 1274},
  {1238, 1306, 1275},
  {1240, 1200, 1358},
  {1200, 1276, 1358},
  {1200, 1202, 1276},
  {1202, 1241, 1308},
  {1241, 1277, 1308},
  {1241, 1278, 1277},
  {1241, 1242, 1278},
  {1242, 1243, 1278},
  {1243, 1244, 1278},
  {1244, 1245, 1278},
  {1245, 1279, 1278},
  {1245, 1246, 1279},
  {1246, 1280, 1279},
  {1247, 1281, 1280},
  {1247, 1282, 1281},
  {1247, 1311, 1282},
  {1247, 1248, 1311},
  {1248, 1283, 1311},
  {1248, 1249, 1283},
  {1249, 1250, 1283},
  {1250, 1251, 1283},
  {1251, 1284, 1283},
  {1251, 1252, 1284},
  {1252, 1285, 1284},
  {1252, 1286, 1285},
  {1252, 1253, 1286},
  {1253, 1287, 1286},
  {1253, 1254, 1287},
  {1254, 1288, 1287},
  {1254, 1255, 1288},
  {1255, 1289, 1288},
  {1255, 1256, 1289},
  {1256, 1290, 1289},
  {1256, 1257, 1290},
  {1257, 1258, 1290},
  {1258, 1291, 1290},
  {1258, 1259, 1291},
  {1259, 1292, 1291},
  {1259, 1260, 1292},
  {1260, 1261, 1292},
  {1261, 1293, 1292},
  {1261, 1262, 1293},
  {1262, 1294, 1293},
  {1262, 1263, 1294},
  {1263, 1264, 1294},
  {1264, 1295, 1294},
  {1264, 1265, 1295},
  {1265, 1319, 1295},
  {1265, 1296, 1319},
  {1230, 1267, 1266},
  {1267, 1231, 1350},
  {1147, 1096, 1269},
  {1190, 1377, 1096},
  {1151, 1352, 1325},
  {1353, 1234, 1354},
  {1234, 1272, 1354},
  {1272, 1194, 1326},
  {1194, 1302, 1326},
  {1273, 1197, 1382},
  {1197, 1274, 1382},
  {1274, 1237, 1303},
  {1237, 1304, 1303},
  {1237, 1305, 1304},
  {1237, 1275, 1305},
  {1275, 1306, 1305},
  {1306, 1239, 1464},
  {1239, 1240, 1464},
  {1276, 1307, 1358},
  {1276, 1202, 1307},
  {1202, 1308, 1307},
  {1308, 1277, 1330},
  {1277, 1278, 1330},
  {1278, 1309, 1330},
  {1278, 1310, 1309},
  {1278, 1279, 1310},
  {1279, 1280, 1310},
  {1280, 1281, 1310},
  {1281, 1311, 1310},
  {1281, 1282, 1311},
  {1283, 1284, 1312},
  {1284, 1313, 1312},
  {1284, 1285, 1313},
  {1285, 1314, 1313},
  {1285, 1286, 1314},
  {1286, 1315, 1314},
  {1286, 1287, 1315},
  {1287, 1316, 1315},
  {1287, 1288, 1316},
  {1288, 1289, 1316},
  {1289, 1290, 1316},
  {1290, 1291, 1316},
  {1291, 1292, 1317},
  {1292, 1293, 1317},
  {1293, 1318, 1317},
  {1293, 1294, 1318},
  {1294, 1295, 1318},
  {1296, 1320, 1319},
  {1296, 1297, 1320},
  {1297, 1266, 1348},
  {1266, 1321, 1348},
  {1266, 1267, 1321},
  {1267, 1350, 1321},
  {1231, 1298, 1350},
  {1298, 1268, 1269},
  {1299, 1300, 1322},
  {1300, 1323, 1322},
  {1300, 1301, 1323},
  {1301, 1324, 1323},
  {1301, 1325, 1324},
  {1270, 1271, 1353},
  {1272, 1355, 1354},
  {1272, 1326, 1355},
  {1302, 1273, 1356},
  {1273, 1382, 1356},
  {1274, 1327, 1382},
  {1274, 1303, 1327},
  {1303, 1304, 1327},
  {1304, 1384, 1327},
  {1304, 1305, 1384},
  {1305, 1328, 1384},
  {1305, 1306, 1328},
  {1464, 1240, 1357},
  {1240, 1386, 1357},
  {1240, 1358, 1386},
  {1307, 1329, 1358},
  {1307, 1308, 1329},
  {1308, 1330, 1329},
  {1309, 1360, 1330},
  {1309, 1310, 1360},
  {1310, 1363, 1331},
  {1310, 1332, 1363},
  {1310, 1365, 1332},
  {1310, 1311, 1365},
  {1311, 1333, 1365},
  {1311, 1283, 1333},
  {1283, 1334, 1333},
  {1283, 1312, 1334},
  {1312, 1335, 1334},
  {1312, 1336, 1335},
  {1312, 1313, 1336},
  {1313, 1337, 1336},
  {1313, 1314, 1337},
  {1314, 1338, 1337},
  {1314, 1315, 1338},
  {1315, 1316, 1338},
  {1316, 1339, 1338},
  {1316, 1340, 1339},
  {1316, 1341, 1340},
  {1316, 1291, 1341},
  {1291, 1342, 1341},
  {1291, 1343, 1342},
  {1291, 1317, 1343},
  {1317, 1318, 1344},
  {1318, 1295, 1344},
  {1295, 1345, 1344},
  {1295, 1319, 1345},
  {1319, 1346, 1345},
  {1319, 1320, 1346},
  {1320, 1347, 1346},
  {1320, 1297, 1347},
  {1297, 1348, 1347},
  {1321, 1349, 1348},
  {1321, 1350, 1349},
  {1350, 1298, 1376},
  {1298, 1269, 1376},
  {1322, 1351, 1299},
  {1322, 1323, 1351},
  {1323, 1324, 1351},
  {1324, 1325, 1352},
  {1352, 1270, 1456},
  {1326, 1302, 1355},
  {1302, 1356, 1355},
  {1382, 1327, 1423},
  {1386, 1358, 1387},
  {1330, 1391, 1329},
  {1330, 1359, 1391},
  {1330, 1360, 1359},
  {1360, 1310, 1361},
  {1310, 1331, 1361},
  {1331, 1362, 1361},
  {1331, 1363, 1362},
  {1332, 1364, 1363},
  {1332, 1365, 1364},
  {1365, 1333, 1366},
  {1333, 1402, 1366},
  {1333, 1367, 1402},
  {1333, 1334, 1367},
  {1334, 1368, 1367},
  {1334, 1335, 1368},
  {1335, 1369, 1368},
  {1335, 1336, 1369},
  {1336, 1370, 1369},
  {1336, 1337, 1370},
  {1337, 1338, 1370},
  {1338, 1406, 1370},
  {1338, 1339, 1406},
  {1339, 1407, 1406},
  {1339, 1340, 1407},
  {1341, 1371, 1340},
  {1341, 1342, 1371},
  {1342, 1372, 1371},
  {1342, 1343, 1372},
  {1343, 1373, 1372},
  {1343, 1317, 1373},
  {1317, 1410, 1373},
  {1317, 1344, 1410},
  {1344, 1345, 1374},
  {1345, 1346, 1374},
  {1346, 1347, 1374},
  {1347, 1375, 1374},
  {1347, 1348, 1375},
  {1348, 1349, 1414},
  {1349, 1350, 1415},
  {1269, 1485, 1376},
  {1269, 1096, 1526},
  {1096, 1377, 1526},
  {1299, 1416, 1454},
  {1299, 1351, 1416},
  {1351, 1324, 1416},
  {1352, 1378, 1324},
  {1352, 1456, 1378},
  {1270, 1353, 1418},
  {1353, 1379, 1418},
  {1353, 1354, 1379},
  {1354, 1488, 1379},
  {1354, 1355, 1419},
  {1356, 1381, 1380},
  {1356, 1382, 1381},
  {1423, 1327, 1383},
  {1327, 1384, 1383},
  {1384, 1328, 1385},
  {1328, 1306, 1385},
  {1357, 1386, 1426},
  {1358, 1388, 1387},
  {1358, 1329, 1388},
  {1329, 1389, 1388},
  {1329, 1390, 1389},
  {1329, 1391, 1390},
  {1359, 1392, 1391},
  {1359, 1360, 1392},
  {1360, 1393, 1392},
  {1360, 1394, 1393},
  {1360, 1361, 1394},
  {1361, 1395, 1394},
  {1361, 1396, 1395},
  {1361, 1362, 1396},
  {1362, 1363, 1396},
  {1363, 1397, 1396},
  {1363, 1364, 1397},
  {1364, 1398, 1397},
  {1364, 1365, 1398},
  {1365, 1399, 1398},
  {1365, 1400, 1399},
  {1365, 1366, 1400},
  {1366, 1402, 1401},
  {1402, 1367, 1403},
  {1367, 1404, 1403},
  {1367, 1368, 1404},
  {1368, 1405, 1404},
  {1368, 1369, 1405},
  {1369, 1370, 1405},
  {1370, 1406, 1405},
  {1340, 1371, 1408},
  {1371, 1409, 1408},
  {1371, 1372, 1409},
  {1372, 1410, 1409},
  {1372, 1373, 1410},
  {1410, 1344, 1411},
  {1344, 1412, 1411},
  {1344, 1374, 1412},
  {1375, 1348, 1451},
  {1348, 1413, 1451},
  {1348, 1414, 1413},
  {1349, 1415, 1414},
  {1350, 1376, 1453},
  {1376, 1485, 1453},
  {1485, 1269, 1486},
  {1269, 1526, 1486},
  {1416, 1324, 1487},
  {1378, 1417, 1324},
  {1378, 1456, 1417},
  {1270, 1418, 1456},
  {1354, 1419, 1488},
  {1356, 1420, 1355},
  {1356, 1380, 1420},
  {1380, 1381, 1420},
  {1382, 1421, 1381},
  {1382, 1422, 1421},
  {1382, 1423, 1422},
  {1423, 1383, 1424},
  {1383, 1425, 1424},
  {1383, 1384, 1425},
  {1384, 1385, 1425},
  {1385, 1306, 1492},
  {1386, 1427, 1426},
  {1386, 1387, 1427},
  {1387, 1465, 1427},
  {1387, 1388, 1465},
  {1388, 1389, 1465},
  {1389, 1390, 1428},
  {1390, 1391, 1428},
  {1391, 1429, 1428},
  {1391, 1430, 1429},
  {1391, 1392, 1430},
  {1392, 1431, 1430},
  {1392, 1393, 1431},
  {1393, 1432, 1431},
  {1393, 1394, 1432},
  {1394, 1433, 1432},
  {1394, 1395, 1433},
  {1395, 1434, 1433},
  {1395, 1396, 1434},
  {1396, 1435, 1434},
  {1396, 1397, 1435},
  {1397, 1436, 1435},
  {1397, 1398, 1436},
  {1398, 1399, 1436},
  {1399, 1400, 1436},
  {1400, 1366, 1437},
  {1366, 1401, 1437},
  {1401, 1438, 1437},
  {1401, 1402, 1438},
  {1402, 1439, 1438},
  {1402, 1403, 1439},
  {1403, 1440, 1439},
  {1403, 1404, 1440},
  {1404, 1441, 1440},
  {1404, 1405, 1441},
  {1405, 1478, 1441},
  {1405, 1406, 1478},
  {1406, 1407, 1442},
  {1407, 1480, 1442},
  {1407, 1340, 1480},
  {1340, 1443, 1480},
  {1340, 1408, 1443},
  {1408, 1444, 1443},
  {1408, 1409, 1444},
  {1409, 1445, 1444},
  {1409, 1410, 1445},
  {1410, 1446, 1445},
  {1410, 1411, 1446},
  {1411, 1447, 1446},
  {1411, 1412, 1447},
  {1412, 1448, 1447},
  {1412, 1449, 1448},
  {1412, 1374, 1449},
  {1374, 1450, 1449},
  {1374, 1375, 1450},
  {1375, 1451, 1450},
  {1414, 1415, 1452},
  {1415, 1453, 1452},
  {1415, 1350, 1453},
  {1377, 1508, 1526},
  {1416, 1487, 1454},
  {1417, 1456, 1455},
  {1418, 1457, 1456},
  {1418, 1379, 1457},
  {1379, 1488, 1457},
  {1419, 1355, 1458},
  {1355, 1420, 1458},
  {1420, 1381, 1459},
  {1381, 1421, 1459},
  {1421, 1460, 1459},
  {1421, 1422, 1460},
  {1422, 1461, 1460},
  {1422, 1423, 1461},
  {1423, 1462, 1461},
  {1423, 1424, 1462},
  {1424, 1491, 1462},
  {1424, 1463, 1491},
  {1424, 1425, 1463},
  {1425, 1385, 1515},
  {1385, 1492, 1515},
  {1492, 1306, 1464},
  {1464, 1357, 1426},
  {1426, 1427, 1465},
  {1465, 1389, 1466},
  {1389, 1428, 1466},
  {1428, 1467, 1466},
  {1428, 1429, 1467},
  {1429, 1468, 1467},
  {1429, 1469, 1468},
  {1429, 1430, 1469},
  {1430, 1470, 1469},
  {1430, 1431, 1470},
  {1431, 1471, 1470},
  {1431, 1432, 1471},
  {1432, 1433, 1471},
  {1433, 1434, 1471},
  {1434, 1435, 1471},
  {1435, 1472, 1471},
  {1435, 1473, 1472},
  {1435, 1436, 1473},
  {1436, 1400, 1473},
  {1400, 1495, 1473},
  {1400, 1437, 1495},
  {1437, 1496, 1495},
  {1437, 1475, 1474},
  {1437, 1438, 1475},
  {1438, 1476, 1475},
  {1438, 1439, 1476},
  {1439, 1477, 1476},
  {1439, 1440, 1477},
  {1440, 1441, 1477},
  {1441, 1478, 1477},
  {1478, 1406, 1544},
  {1406, 1479, 1544},
  {1406, 1442, 1479},
  {1442, 1480, 1479},
  {1480, 1443, 1481},
  {1443, 1482, 1481},
  {1443, 1444, 1482},
  {1444, 1483, 1482},
  {1444, 1445, 1483},
  {1445, 1446, 1483},
  {1446, 1447, 1483},
  {1448, 1449, 1549},
  {1449, 1450, 1549},
  {1452, 1453, 1525},
  {1453, 1485, 1484},
  {1486, 1526, 1507},
  {1324, 1510, 1487},
  {1417, 1455, 1324},
  {1455, 1456, 1532},
  {1459, 1489, 1420},
  {1459, 1460, 1489},
  {1460, 1461, 1489},
  {1461, 1462, 1490},
  {1462, 1491, 1490},
  {1463, 1515, 1491},
  {1463, 1425, 1515},
  {1426, 1465, 1538},
  {1465, 1466, 1538},
  {1467, 1468, 1493},
  {1468, 1469, 1493},
  {1469, 1470, 1493},
  {1470, 1471, 1493},
  {1471, 1494, 1493},
  {1471, 1472, 1494},
  {1472, 1540, 1494},
  {1472, 1473, 1540},
  {1473, 1517, 1540},
  {1473, 1495, 1517},
  {1495, 1496, 1570},
  {1496, 1437, 1497},
  {1437, 1498, 1497},
  {1437, 1474, 1498},
  {1474, 1499, 1498},
  {1474, 1475, 1499},
  {1475, 1500, 1499},
  {1475, 1476, 1500},
  {1476, 1477, 1500},
  {1477, 1478, 1500},
  {1479, 1480, 1501},
  {1480, 1502, 1501},
  {1480, 1481, 1502},
  {1481, 1503, 1502},
  {1481, 1482, 1503},
  {1482, 1504, 1503},
  {1482, 1483, 1504},
  {1447, 1448, 1505},
  {1448, 1549, 1505},
  {1451, 1413, 1524},
  {1413, 1414, 1524},
  {1414, 1452, 1524},
  {1453, 1550, 1525},
  {1550, 1453, 1580},
  {1453, 1484, 1580},
  {1485, 1506, 1484},
  {1485, 1486, 1506},
  {1486, 1507, 1506},
  {1454, 1487, 1509},
  {1324, 1455, 1510},
  {1456, 1457, 1532},
  {1457, 1582, 1532},
  {1457, 1488, 1582},
  {1419, 1458, 1671},
  {1489, 1512, 1511},
  {1489, 1513, 1512},
  {1489, 1461, 1513},
  {1461, 1536, 1513},
  {1461, 1490, 1536},
  {1490, 1514, 1536},
  {1490, 1491, 1514},
  {1491, 1515, 1514},
  {1515, 1492, 1516},
  {1492, 1464, 1516},
  {1464, 1426, 1538},
  {1538, 1466, 1562},
  {1466, 1564, 1562},
  {1466, 1467, 1564},
  {1467, 1493, 1564},
  {1493, 1494, 1539},
  {1496, 1497, 1518},
  {1497, 1519, 1518},
  {1497, 1520, 1519},
  {1497, 1498, 1520},
  {1498, 1499, 1520},
  {1499, 1500, 1520},
  {1500, 1521, 1520},
  {1500, 1478, 1521},
  {1478, 1544, 1521},
  {1479, 1501, 1522},
  {1501, 1523, 1522},
  {1501, 1502, 1523},
  {1502, 1503, 1523},
  {1503, 1547, 1523},
  {1503, 1504, 1547},
  {1504, 1483, 1547},
  {1483, 1505, 1605},
  {1483, 1447, 1505},
  {1450, 1451, 1549},
  {1451, 1524, 1549},
  {1524, 1452, 1525},
  {1580, 1484, 1551},
  {1526, 1508, 1527},
  {1508, 1528, 1527},
  {1509, 1487, 1529},
  {1487, 1530, 1529},
  {1487, 1531, 1530},
  {1487, 1510, 1531},
  {1455, 1532, 1582},
  {1458, 1420, 1671},
  {1489, 1511, 1420},
  {1512, 1513, 1533},
  {1513, 1534, 1533},
  {1513, 1535, 1534},
  {1513, 1536, 1535},
  {1514, 1515, 1536},
  {1515, 1537, 1536},
  {1515, 1516, 1537},
  {1516, 1588, 1537},
  {1516, 1464, 1588},
  {1562, 1564, 1563},
  {1493, 1539, 1564},
  {1494, 1540, 1539},
  {1517, 1495, 1568},
  {1496, 1541, 1570},
  {1496, 1518, 1541},
  {1518, 1542, 1541},
  {1518, 1543, 1542},
  {1518, 1519, 1543},
  {1519, 1520, 1543},
  {1520, 1574, 1543},
  {1520, 1521, 1574},
  {1544, 1479, 1575},
  {1479, 1545, 1575},
  {1479, 1522, 1545},
  {1522, 1546, 1545},
  {1522, 1523, 1546},
  {1505, 1548, 1605},
  {1505, 1549, 1548},
  {1549, 1524, 1579},
  {1524, 1525, 1607},
  {1484, 1506, 1551},
  {1507, 1526, 1668},
  {1527, 1528, 1552},
  {1529, 1530, 1553},
  {1530, 1554, 1553},
  {1510, 1455, 1531},
  {1455, 1582, 1531},
  {1511, 1555, 1420},
  {1511, 1512, 1555},
  {1512, 1556, 1555},
  {1512, 1533, 1556},
  {1533, 1557, 1556},
  {1533, 1534, 1557},
  {1534, 1558, 1557},
  {1534, 1535, 1558},
  {1535, 1559, 1558},
  {1535, 1536, 1559},
  {1536, 1560, 1559},
  {1536, 1537, 1560},
  {1537, 1588, 1560},
  {1464, 1538, 1588},
  {1538, 1561, 1588},
  {1538, 1562, 1561},
  {1564, 1539, 1565},
  {1539, 1567, 1566},
  {1539, 1540, 1567},
  {1540, 1517, 1567},
  {1495, 1570, 1569},
  {1570, 1541, 1571},
  {1541, 1572, 1571},
  {1541, 1542, 1572},
  {1542, 1573, 1572},
  {1542, 1543, 1573},
  {1543, 1574, 1573},
  {1545, 1576, 1575},
  {1545, 1546, 1576},
  {1546, 1523, 1576},
  {1523, 1577, 1576},
  {1523, 1547, 1577},
  {1547, 1578, 1577},
  {1547, 1483, 1578},
  {1483, 1605, 1578},
  {1579, 1524, 1607},
  {1525, 1550, 1607},
  {1506, 1507, 1668},
  {1552, 1581, 1527},
  {1553, 1702, 1529},
  {1553, 1554, 1702},
  {1554, 1530, 1702},
  {1530, 1638, 1702},
  {1530, 1531, 1638},
  {1531, 1582, 1638},
  {1419, 1671, 1488},
  {1555, 1583, 1420},
  {1555, 1584, 1583},
  {1555, 1556, 1584},
  {1556, 1585, 1584},
  {1556, 1557, 1585},
  {1557, 1558, 1585},
  {1558, 1611, 1585},
  {1558, 1559, 1611},
  {1559, 1586, 1611},
  {1559, 1560, 1586},
  {1560, 1587, 1586},
  {1560, 1588, 1587},
  {1561, 1562, 1589},
  {1562, 1590, 1589},
  {1562, 1591, 1590},
  {1562, 1592, 1591},
  {1562, 1593, 1592},
  {1562, 1563, 1593},
  {1563, 1594, 1593},
  {1563, 1564, 1594},
  {1564, 1595, 1594},
  {1564, 1565, 1595},
  {1565, 1539, 1595},
  {1539, 1618, 1595},
  {1539, 1566, 1618},
  {1566, 1596, 1618},
  {1566, 1567, 1596},
  {1567, 1517, 1596},
  {1517, 1568, 1596},
  {1495, 1569, 1568},
  {1569, 1623, 1568},
  {1569, 1597, 1623},
  {1569, 1570, 1597},
  {1570, 1598, 1597},
  {1570, 1571, 1598},
  {1571, 1599, 1598},
  {1571, 1572, 1599},
  {1572, 1573, 1599},
  {1573, 1600, 1599},
  {1573, 1601, 1600},
  {1573, 1574, 1601},
  {1574, 1521, 1602},
  {1521, 1544, 1602},
  {1575, 1626, 1544},
  {1575, 1576, 1626},
  {1576, 1603, 1626},
  {1576, 1577, 1603},
  {1577, 1578, 1603},
  {1578, 1604, 1603},
  {1578, 1605, 1604},
  {1548, 1606, 1605},
  {1548, 1659, 1606},
  {1548, 1549, 1659},
  {1549, 1579, 1659},
  {1579, 1607, 1632},
  {1607, 1550, 1637},
  {1550, 1667, 1637},
  {1551, 1506, 1668},
  {1526, 1581, 1668},
  {1526, 1527, 1581},
  {1488, 1671, 1582},
  {1420, 1583, 1608},
  {1583, 1609, 1608},
  {1583, 1584, 1609},
  {1584, 1610, 1609},
  {1584, 1585, 1610},
  {1585, 1611, 1610},
  {1611, 1586, 1612},
  {1586, 1587, 1612},
  {1587, 1613, 1612},
  {1587, 1588, 1613},
  {1588, 1561, 1677},
  {1561, 1645, 1677},
  {1561, 1589, 1645},
  {1589, 1590, 1645},
  {1590, 1614, 1645},
  {1590, 1615, 1614},
  {1590, 1591, 1615},
  {1591, 1616, 1615},
  {1591, 1592, 1616},
  {1592, 1593, 1616},
  {1593, 1594, 1616},
  {1594, 1595, 1711},
  {1595, 1618, 1617},
  {1596, 1619, 1618},
  {1596, 1620, 1619},
  {1596, 1568, 1620},
  {1568, 1764, 1620},
  {1568, 1621, 1764},
  {1568, 1622, 1621},
  {1568, 1623, 1622},
  {1597, 1624, 1623},
  {1597, 1598, 1624},
  {1598, 1599, 1624},
  {1599, 1600, 1624},
  {1600, 1601, 1650},
  {1601, 1684, 1650},
  {1601, 1574, 1684},
  {1574, 1625, 1684},
  {1574, 1602, 1625},
  {1544, 1626, 1602},
  {1626, 1603, 1627},
  {1603, 1628, 1627},
  {1603, 1604, 1628},
  {1604, 1605, 1628},
  {1605, 1629, 1628},
  {1605, 1630, 1629},
  {1605, 1606, 1630},
  {1659, 1579, 1631},
  {1579, 1632, 1631},
  {1632, 1607, 1633},
  {1607, 1634, 1633},
  {1607, 1635, 1634},
  {1607, 1636, 1635},
  {1607, 1637, 1636},
  {1550, 1580, 1667},
  {1551, 1668, 1580},
  {1582, 1670, 1638},
  {1582, 1671, 1670},
  {1671, 1420, 1639},
  {1420, 1608, 1639},
  {1609, 1640, 1608},
  {1609, 1610, 1640},
  {1610, 1641, 1640},
  {1610, 1611, 1641},
  {1611, 1642, 1641},
  {1611, 1612, 1642},
  {1612, 1643, 1642},
  {1612, 1644, 1643},
  {1612, 1613, 1644},
  {1613, 1588, 1644},
  {1588, 1709, 1644},
  {1588, 1677, 1709},
  {1645, 1614, 1615},
  {1616, 1711, 1615},
  {1616, 1594, 1711},
  {1595, 1679, 1711},
  {1595, 1617, 1679},
  {1618, 1646, 1617},
  {1618, 1619, 1646},
  {1620, 1764, 1619},
  {1764, 1621, 1680},
  {1621, 1647, 1680},
  {1621, 1648, 1647},
  {1621, 1622, 1648},
  {1622, 1649, 1648},
  {1622, 1623, 1649},
  {1623, 1624, 1649},
  {1624, 1600, 1649},
  {1684, 1625, 1651},
  {1625, 1687, 1651},
  {1625, 1602, 1687},
  {1602, 1652, 1687},
  {1602, 1626, 1652},
  {1626, 1653, 1652},
  {1626, 1627, 1653},
  {1627, 1654, 1653},
  {1627, 1655, 1654},
  {1627, 1656, 1655},
  {1627, 1628, 1656},
  {1628, 1657, 1656},
  {1628, 1629, 1657},
  {1629, 1630, 1657},
  {1630, 1606, 1657},
  {1606, 1658, 1657},
  {1606, 1659, 1658},
  {1631, 1660, 1659},
  {1631, 1661, 1660},
  {1631, 1632, 1661},
  {1632, 1662, 1661},
  {1632, 1633, 1662},
  {1633, 1663, 1662},
  {1633, 1634, 1663},
  {1634, 1664, 1663},
  {1634, 1635, 1664},
  {1635, 1665, 1664},
  {1635, 1636, 1665},
  {1636, 1666, 1665},
  {1636, 1637, 1666},
  {1637, 1667, 1666},
  {1702, 1638, 1669},
  {1638, 1670, 1669},
  {1671, 1752, 1670},
  {1639, 1608, 1672},
  {1608, 1673, 1672},
  {1608, 1640, 1673},
  {1640, 1674, 1673},
  {1640, 1641, 1674},
  {1641, 1642, 1674},
  {1642, 1675, 1674},
  {1642, 1676, 1675},
  {1642, 1643, 1676},
  {1645, 1615, 1677},
  {1615, 1711, 1678},
  {1711, 1679, 1737},
  {1617, 1646, 1679},
  {1619, 1764, 1646},
  {1680, 1647, 1681},
  {1647, 1682, 1681},
  {1647, 1648, 1682},
  {1648, 1683, 1682},
  {1648, 1649, 1683},
  {1649, 1714, 1683},
  {1649, 1600, 1714},
  {1600, 1650, 1714},
  {1650, 1684, 1714},
  {1651, 1685, 1684},
  {1651, 1686, 1685},
  {1651, 1687, 1686},
  {1652, 1688, 1687},
  {1652, 1653, 1688},
  {1653, 1689, 1688},
  {1653, 1690, 1689},
  {1653, 1654, 1690},
  {1654, 1691, 1690},
  {1654, 1655, 1691},
  {1655, 1692, 1691},
  {1655, 1656, 1692},
  {1656, 1693, 1692},
  {1656, 1722, 1693},
  {1656, 1657, 1722},
  {1657, 1694, 1722},
  {1657, 1658, 1694},
  {1658, 1695, 1694},
  {1658, 1659, 1695},
  {1659, 1696, 1695},
  {1659, 1697, 1696},
  {1659, 1660, 1697},
  {1660, 1698, 1697},
  {1660, 1661, 1698},
  {1661, 1662, 1698},
  {1662, 1699, 1698},
  {1662, 1663, 1699},
  {1663, 1700, 1699},
  {1663, 1664, 1700},
  {1664, 1701, 1700},
  {1664, 1665, 1701},
  {1665, 1666, 1701},
  {1667, 1750, 1749},
  {1667, 1580, 1750},
  {1580, 1668, 1750},
  {1668, 1581, 1727},
  {1529, 1702, 1778},
  {1702, 1669, 1703},
  {1669, 1670, 1703},
  {1639, 1729, 1671},
  {1639, 1704, 1729},
  {1639, 1705, 1704},
  {1639, 1672, 1705},
  {1672, 1706, 1705},
  {1672, 1673, 1706},
  {1673, 1707, 1706},
  {1673, 1674, 1707},
  {1674, 1708, 1707},
  {1674, 1675, 1708},
  {1675, 1676, 1708},
  {1676, 1643, 1708},
  {1643, 1644, 1708},
  {1644, 1734, 1708},
  {1644, 1800, 1734},
  {1800, 1644, 1709},
  {1677, 1736, 1709},
  {1677, 1615, 1736},
  {1615, 1678, 1736},
  {1678, 1711, 1710},
  {1764, 1680, 1712},
  {1680, 1713, 1712},
  {1680, 1681, 1713},
  {1681, 1682, 1713},
  {1682, 1683, 1713},
  {1683, 1714, 1713},
  {1684, 1765, 1714},
  {1684, 1739, 1765},
  {1684, 1715, 1739},
  {1684, 1685, 1715},
  {1685, 1716, 1715},
  {1685, 1686, 1716},
  {1686, 1717, 1716},
  {1686, 1687, 1717},
  {1687, 1718, 1717},
  {1687, 1688, 1718},
  {1688, 1689, 1718},
  {1689, 1719, 1718},
  {1689, 1690, 1719},
  {1690, 1720, 1719},
  {1690, 1691, 1720},
  {1691, 1721, 1720},
  {1691, 1692, 1721},
  {1692, 1693, 1721},
  {1693, 1722, 1721},
  {1722, 1694, 1723},
  {1694, 1746, 1723},
  {1694, 1695, 1746},
  {1695, 1724, 1746},
  {1695, 1696, 1724},
  {1696, 1697, 1724},
  {1697, 1747, 1724},
  {1697, 1698, 1747},
  {1698, 1725, 1747},
  {1698, 1699, 1725},
  {1699, 1700, 1725},
  {1700, 1726, 1725},
  {1700, 1701, 1726},
  {1701, 1749, 1726},
  {1701, 1666, 1749},
  {1666, 1667, 1749},
  {1821, 1668, 1727},
  {1778, 1702, 1728},
  {1702, 1779, 1728},
  {1702, 1703, 1779},
  {1670, 1752, 1839},
  {1671, 1729, 1753},
  {1704, 1730, 1729},
  {1704, 1705, 1730},
  {1705, 1731, 1730},
  {1705, 1732, 1731},
  {1705, 1706, 1732},
  {1706, 1707, 1732},
  {1707, 1708, 1732},
  {1708, 1734, 1733},
  {1709, 1736, 1735},
  {1678, 1710, 1761},
  {1710, 1711, 1761},
  {1679, 1646, 1763},
  {1712, 1713, 1738},
  {1713, 1714, 1738},
  {1715, 1716, 1739},
  {1716, 1717, 1740},
  {1717, 1741, 1740},
  {1717, 1718, 1741},
  {1718, 1719, 1741},
  {1719, 1742, 1741},
  {1719, 1720, 1742},
  {1720, 1743, 1742},
  {1720, 1721, 1743},
  {1721, 1744, 1743},
  {1721, 1722, 1744},
  {1722, 1745, 1744},
  {1722, 1723, 1745},
  {1723, 1746, 1775},
  {1725, 1748, 1747},
  {1725, 1726, 1748},
  {1726, 1749, 1748},
  {1750, 1668, 1821},
  {1728, 1779, 1751},
  {1671, 1753, 1752},
  {1729, 1754, 1753},
  {1729, 1755, 1754},
  {1729, 1730, 1755},
  {1730, 1756, 1755},
  {1730, 1731, 1756},
  {1731, 1732, 1757},
  {1732, 1758, 1757},
  {1732, 1759, 1758},
  {1732, 1708, 1759},
  {1708, 1733, 1759},
  {1734, 1800, 1733},
  {1709, 1735, 1760},
  {1735, 1736, 1760},
  {1736, 1678, 1841},
  {1761, 1711, 1803},
  {1737, 1762, 1711},
  {1737, 1763, 1762},
  {1737, 1679, 1763},
  {1646, 1764, 1763},
  {1712, 1784, 1805},
  {1712, 1738, 1784},
  {1714, 1765, 1785},
  {1739, 1766, 1765},
  {1739, 1767, 1766},
  {1739, 1716, 1767},
  {1716, 1768, 1767},
  {1716, 1740, 1768},
  {1740, 1769, 1768},
  {1740, 1741, 1769},
  {1741, 1770, 1769},
  {1741, 1742, 1770},
  {1742, 1771, 1770},
  {1742, 1743, 1771},
  {1743, 1744, 1772},
  {1744, 1773, 1772},
  {1744, 1745, 1773},
  {1745, 1774, 1773},
  {1745, 1723, 1774},
  {1723, 1775, 1774},
  {1746, 1724, 1776},
  {1724, 1777, 1776},
  {1724, 1747, 1777},
  {1728, 1751, 1778},
  {1751, 1779, 1778},
  {1703, 1822, 1779},
  {1670, 1839, 1703},
  {1753, 1754, 1755},
  {1755, 1756, 1823},
  {1756, 1731, 1780},
  {1731, 1757, 1780},
  {1757, 1781, 1780},
  {1757, 1758, 1781},
  {1758, 1782, 1781},
  {1758, 1759, 1782},
  {1759, 1799, 1782},
  {1759, 1733, 1799},
  {1733, 1800, 1799},
  {1709, 1760, 1801},
  {1736, 1841, 1760},
  {1678, 1802, 1841},
  {1678, 1761, 1802},
  {1761, 1803, 1802},
  {1711, 1762, 1803},
  {1762, 1763, 1803},
  {1763, 1764, 1868},
  {1764, 1712, 1783},
  {1712, 1805, 1783},
  {1738, 1785, 1784},
  {1738, 1714, 1785},
  {1765, 1786, 1785},
  {1765, 1787, 1786},
  {1765, 1766, 1787},
  {1766, 1788, 1787},
  {1766, 1767, 1788},
  {1767, 1789, 1788},
  {1767, 1768, 1789},
  {1768, 1790, 1789},
  {1768, 1769, 1790},
  {1769, 1791, 1790},
  {1769, 1792, 1791},
  {1769, 1793, 1792},
  {1769, 1770, 1793},
  {1770, 1794, 1793},
  {1770, 1771, 1794},
  {1771, 1795, 1794},
  {1771, 1743, 1795},
  {1743, 1772, 1795},
  {1772, 1796, 1795},
  {1772, 1773, 1796},
  {1773, 1774, 1796},
  {1774, 1775, 1796},
  {1746, 1776, 1775},
  {1776, 1777, 1797},
  {1777, 1747, 1797},
  {1747, 1748, 1797},
  {1748, 1819, 1797},
  {1748, 1749, 1819},
  {1749, 1820, 1819},
  {1749, 1750, 1820},
  {1750, 1837, 1820},
  {1703, 1839, 1822},
  {1839, 1752, 1865},
  {1755, 1866, 1753},
  {1755, 1823, 1866},
  {1823, 1756, 1780},
  {1780, 1781, 1798},
  {1781, 1782, 1798},
  {1782, 1799, 1798},
  {1709, 1801, 1800},
  {1760, 1841, 1801},
  {1764, 1783, 1804},
  {1783, 1805, 1804},
  {1784, 1843, 1805},
  {1784, 1785, 1843},
  {1785, 1786, 1858},
  {1786, 1787, 1806},
  {1787, 1807, 1806},
  {1787, 1788, 1807},
  {1788, 1808, 1807},
  {1788, 1789, 1808},
  {1789, 1809, 1808},
  {1789, 1790, 1809},
  {1790, 1810, 1809},
  {1790, 1791, 1810},
  {1791, 1792, 1810},
  {1792, 1811, 1810},
  {1792, 1793, 1811},
  {1793, 1812, 1811},
  {1793, 1794, 1812},
  {1794, 1813, 1812},
  {1794, 1795, 1813},
  {1795, 1834, 1813},
  {1795, 1814, 1834},
  {1795, 1796, 1814},
  {1796, 1775, 1814},
  {1776, 1797, 1815},
  {1797, 1816, 1815},
  {1797, 1817, 1816},
  {1797, 1818, 1817},
  {1797, 1819, 1818},
  {1750, 1821, 1837},
  {1727, 1864, 1821},
  {1753, 1866, 1752},
  {1800, 1824, 1799},
  {1800, 1840, 1824},
  {1800, 1801, 1840},
  {1868, 1764, 1804},
  {1804, 1805, 1825},
  {1805, 1843, 1825},
  {1858, 1786, 1859},
  {1786, 1806, 1859},
  {1806, 1807, 1826},
  {1807, 1827, 1826},
  {1807, 1808, 1827},
  {1808, 1828, 1827},
  {1808, 1809, 1828},
  {1809, 1829, 1828},
  {1809, 1810, 1829},
  {1810, 1830, 1829},
  {1810, 1831, 1830},
  {1810, 1811, 1831},
  {1811, 1832, 1831},
  {1811, 1812, 1832},
  {1812, 1833, 1832},
  {1812, 1813, 1833},
  {1813, 1834, 1833},
  {1814, 1920, 1834},
  {1814, 1775, 1920},
  {1775, 1776, 1920},
  {1776, 1815, 1835},
  {1815, 1816, 1835},
  {1816, 1818, 1835},
  {1816, 1817, 1818},
  {1819, 1836, 1818},
  {1819, 1837, 1836},
  {1819, 1820, 1837},
  {1822, 1838, 1779},
  {1822, 1839, 1838},
  {1752, 1866, 1865},
  {1780, 1798, 1823},
  {1801, 1876, 1840},
  {1801, 1841, 1876},
  {1841, 1802, 1849},
  {1803, 1763, 1868},
  {1804, 1825, 1842},
  {1825, 1843, 1842},
  {1859, 1806, 1826},
  {1826, 1827, 1844},
  {1827, 1828, 1844},
  {1828, 1829, 1844},
  {1829, 1845, 1844},
  {1829, 1830, 1845},
  {1830, 1831, 1845},
  {1831, 1832, 1845},
  {1832, 1846, 1845},
  {1832, 1833, 1846},
  {1833, 1834, 1846},
  {1837, 1874, 1836},
  {1837, 1821, 1874},
  {1779, 1838, 1847},
  {1838, 1839, 1847},
  {1865, 1866, 1894},
  {1798, 1799, 1823},
  {1799, 1824, 1848},
  {1824, 1840, 1848},
  {1876, 1841, 1898},
  {1849, 1802, 1909},
  {1802, 1803, 1909},
  {1803, 1856, 1909},
  {1843, 1785, 1858},
  {1826, 1844, 1860},
  {1844, 1850, 1860},
  {1844, 1845, 1850},
  {1845, 1851, 1850},
  {1845, 1846, 1851},
  {1846, 1863, 1851},
  {1846, 1834, 1863},
  {1835, 1818, 1905},
  {1874, 1821, 1852},
  {1821, 1864, 1852},
  {1847, 1839, 1853},
  {1839, 1865, 1853},
  {1799, 1867, 1823},
  {1799, 1854, 1867},
  {1799, 1848, 1854},
  {1848, 1855, 1854},
  {1848, 1840, 1855},
  {1841, 1849, 1909},
  {1803, 1868, 1856},
  {1804, 1842, 1885},
  {1842, 1857, 1885},
  {1842, 1843, 1857},
  {1859, 1826, 1860},
  {1850, 1861, 1860},
  {1850, 1862, 1861},
  {1850, 1863, 1862},
  {1850, 1851, 1863},
  {1834, 1884, 1863},
  {1834, 1920, 1884},
  {1776, 1835, 1905},
  {1818, 1836, 1905},
  {1865, 1894, 1907},
  {1854, 1855, 1867},
  {1855, 1840, 1876},
  {1841, 1909, 1898},
  {1868, 1804, 1911},
  {1857, 1886, 1885},
  {1857, 1843, 1886},
  {1843, 1858, 1886},
  {1858, 1859, 1869},
  {1859, 1870, 1869},
  {1859, 1860, 1870},
  {1860, 1871, 1870},
  {1860, 1872, 1871},
  {1860, 1861, 1872},
  {1861, 1873, 1872},
  {1861, 1862, 1873},
  {1862, 1863, 1873},
  {1776, 1905, 1920},
  {1852, 1864, 1874},
  {1866, 1823, 1875},
  {1911, 1804, 1885},
  {1858, 1869, 1877},
  {1869, 1887, 1877},
  {1869, 1870, 1887},
  {1870, 1878, 1887},
  {1870, 1879, 1878},
  {1870, 1871, 1879},
  {1871, 1880, 1879},
  {1871, 1881, 1880},
  {1871, 1872, 1881},
  {1872, 1882, 1881},
  {1872, 1873, 1882},
  {1873, 1883, 1882},
  {1873, 1863, 1883},
  {1863, 1884, 1883},
  {1905, 1836, 1939},
  {1864, 1906, 1874},
  {1894, 1866, 1895},
  {1866, 1875, 1895},
  {1823, 1867, 1875},
  {1867, 1897, 1896},
  {1867, 1855, 1897},
  {1855, 1876, 1897},
  {1909, 1856, 1910},
  {1856, 1868, 1910},
  {1885, 1899, 1911},
  {1887, 1878, 1888},
  {1878, 1889, 1888},
  {1878, 1890, 1889},
  {1878, 1879, 1890},
  {1879, 1891, 1890},
  {1879, 1880, 1891},
  {1880, 1892, 1891},
  {1880, 1881, 1892},
  {1881, 1893, 1892},
  {1881, 1882, 1893},
  {1882, 1884, 1893},
  {1882, 1883, 1884},
  {1778, 1982, 1958},
  {1778, 1779, 1982},
  {1847, 1853, 1907},
  {1853, 1865, 1907},
  {1875, 1908, 1895},
  {1875, 1896, 1908},
  {1875, 1867, 1896},
  {1868, 1911, 1930},
  {1885, 1886, 1914},
  {1886, 1900, 1914},
  {1886, 1858, 1900},
  {1858, 1877, 1900},
  {1877, 1887, 1916},
  {1887, 1901, 1916},
  {1887, 1888, 1901},
  {1888, 1902, 1901},
  {1888, 1889, 1902},
  {1889, 1903, 1902},
  {1889, 1890, 1903},
  {1890, 1904, 1903},
  {1890, 1891, 1904},
  {1891, 1892, 1904},
  {1892, 1919, 1904},
  {1892, 1893, 1919},
  {1893, 1884, 1919},
  {1836, 1874, 1947},
  {1779, 1921, 1959},
  {1779, 1847, 1921},
  {1847, 1907, 1922},
  {1894, 1895, 1908},
  {1897, 1876, 1929},
  {1876, 1898, 1929},
  {1898, 1909, 1961},
  {1868, 1930, 1910},
  {1899, 1885, 1912},
  {1885, 1913, 1912},
  {1885, 1914, 1913},
  {1900, 1915, 1914},
  {1900, 1877, 1915},
  {1916, 1901, 1917},
  {1901, 1918, 1917},
  {1901, 1902, 1918},
  {1902, 1903, 1918},
  {1903, 1904, 1918},
  {1884, 1920, 1919},
  {1920, 1905, 1938},
  {1905, 1939, 1927},
  {1836, 1947, 1939},
  {1949, 1778, 1958},
  {1779, 1959, 1982},
  {1847, 1922, 1921},
  {1922, 1907, 1923},
  {1907, 1894, 1983},
  {1908, 1896, 1928},
  {1896, 1897, 1928},
  {1909, 1910, 1962},
  {1912, 1931, 1899},
  {1912, 1913, 1931},
  {1914, 1924, 1913},
  {1914, 1915, 1924},
  {1915, 1877, 1924},
  {1877, 1916, 1933},
  {1916, 1925, 1933},
  {1916, 1917, 1925},
  {1917, 1926, 1925},
  {1917, 1918, 1926},
  {1918, 1904, 1926},
  {1920, 1938, 1937},
  {1905, 1927, 1938},
  {1874, 1948, 1947},
  {1874, 1906, 1948},
  {1921, 1922, 1923},
  {1908, 1928, 1950},
  {1898, 1961, 1929},
  {1909, 1962, 1961},
  {1911, 1899, 1952},
  {1913, 1924, 1931},
  {1924, 1932, 1931},
  {1924, 1955, 1932},
  {1924, 1877, 1955},
  {1877, 1933, 1955},
  {1933, 1935, 1934},
  {1933, 1925, 1935},
  {1925, 1936, 1935},
  {1925, 1926, 1936},
  {1926, 1904, 1936},
  {1904, 1919, 1936},
  {1919, 1920, 1945},
  {1927, 1939, 1938},
  {1928, 1897, 1940},
  {1911, 1952, 1964},
  {1952, 1899, 1931},
  {1931, 1932, 1941},
  {1932, 1955, 1941},
  {1934, 1935, 1942},
  {1935, 1936, 1942},
  {1936, 1943, 1942},
  {1936, 1944, 1943},
  {1936, 1919, 1944},
  {1919, 1945, 1944},
  {1920, 1946, 1945},
  {1920, 1937, 1946},
  {1938, 1939, 1937},
  {1983, 1894, 1972},
  {1894, 1908, 1972},
  {1928, 1940, 1951},
  {1940, 1897, 1951},
  {1897, 1929, 1951},
  {1929, 1961, 1973},
  {1962, 1910, 1974},
  {1910, 1963, 1974},
  {1910, 1930, 1963},
  {1930, 1911, 1963},
  {1964, 1952, 1965},
  {1931, 1953, 1952},
  {1931, 1966, 1953},
  {1931, 1941, 1966},
  {1941, 1955, 1954},
  {1955, 1933, 1956},
  {1933, 1968, 1956},
  {1933, 1969, 1968},
  {1933, 1934, 1969},
  {1934, 1970, 1969},
  {1942, 1978, 1934},
  {1942, 1979, 1978},
  {1942, 1943, 1979},
  {1943, 1944, 1979},
  {1946, 1957, 1945},
  {1946, 1937, 1957},
  {1937, 1939, 1957},
  {1939, 1947, 1957},
  {1947, 1948, 2000},
  {1921, 1971, 1959},
  {1921, 1923, 1971},
  {1923, 1960, 1971},
  {1923, 1907, 1960},
  {1960, 1907, 1983},
  {1908, 1950, 1972},
  {1951, 1929, 1984},
  {1963, 1911, 1964},
  {1952, 1966, 1965},
  {1952, 1953, 1966},
  {1941, 1954, 1966},
  {1954, 1955, 1967},
  {1955, 1956, 1967},
  {1956, 1968, 1967},
  {1934, 1978, 1970},
  {1979, 1944, 1991},
  {1944, 1945, 1991},
  {1957, 1947, 1980},
  {1947, 2000, 1980},
  {1983, 2020, 1960},
  {1950, 1984, 1972},
  {1950, 1928, 1984},
  {1928, 1951, 1984},
  {1984, 1929, 2044},
  {1973, 1961, 1974},
  {1962, 1974, 1961},
  {1963, 1964, 2003},
  {1964, 1965, 1975},
  {1965, 1966, 1975},
  {1966, 1986, 1975},
  {1966, 1994, 1986},
  {1966, 1954, 1994},
  {1954, 1967, 1994},
  {1967, 2017, 1994},
  {1967, 1976, 2017},
  {1967, 1968, 1976},
  {1968, 1988, 1976},
  {1968, 1969, 1988},
  {1969, 1989, 1988},
  {1969, 1970, 1989},
  {1970, 1978, 1977},
  {1945, 1957, 1999},
  {1948, 1906, 1981},
  {1929, 1973, 2044},
  {1974, 1963, 2003},
  {1964, 1975, 2022},
  {1975, 1985, 2022},
  {1975, 1986, 1985},
  {2017, 1976, 1987},
  {1976, 1988, 1987},
  {1970, 1990, 1989},
  {1970, 1977, 1990},
  {1977, 1978, 1990},
  {1978, 1979, 1990},
  {1979, 1998, 1990},
  {1979, 1991, 1998},
  {1991, 1945, 1992},
  {1945, 1999, 1992},
  {1981, 1906, 2011},
  {1906, 2001, 2011},
  {1973, 2032, 2044},
  {1986, 1993, 1985},
  {1986, 1994, 1993},
  {2017, 1987, 1995},
  {1987, 1996, 1995},
  {1987, 1988, 1996},
  {1988, 2005, 1996},
  {1988, 1989, 2005},
  {1989, 1997, 2005},
  {1989, 1990, 1997},
  {1990, 1998, 1997},
  {1991, 1999, 1998},
  {1991, 1992, 1999},
  {1957, 2007, 1999},
  {1957, 1980, 2007},
  {1980, 2000, 2007},
  {1948, 1981, 2031},
  {1949, 1958, 2013},
  {1958, 1982, 2059},
  {1959, 1971, 2040},
  {2040, 1960, 2020},
  {1972, 2014, 1983},
  {1972, 1984, 2014},
  {1973, 2002, 2032},
  {1973, 1974, 2002},
  {1974, 2008, 2002},
  {1974, 2003, 2008},
  {1985, 1993, 2022},
  {1993, 1994, 2016},
  {1994, 2017, 2016},
  {2017, 1995, 2004},
  {1995, 2009, 2004},
  {1995, 2005, 2009},
  {1995, 1996, 2005},
  {2005, 1997, 2006},
  {1997, 1998, 2006},
  {1999, 2007, 2029},
  {1948, 2031, 2000},
  {2011, 2001, 2018},
  {1958, 2059, 2013},
  {1959, 2040, 1982},
  {1971, 1960, 2040},
  {2002, 2008, 2032},
  {2008, 2021, 2015},
  {2008, 2003, 2021},
  {2022, 1993, 2016},
  {2017, 2004, 2024},
  {2004, 2009, 2024},
  {2005, 2010, 2009},
  {2005, 2006, 2010},
  {1998, 1999, 2025},
  {2018, 2001, 2012},
  {1984, 2044, 2014},
  {1964, 2022, 2033},
  {2009, 2010, 2025},
  {2010, 2006, 2025},
  {2006, 1998, 2025},
  {1999, 2029, 2025},
  {2007, 2000, 2026},
  {2012, 2019, 2018},
  {2003, 1964, 2033},
  {2017, 2024, 2023},
  {2009, 2025, 2024},
  {2029, 2007, 2026},
  {2018, 2058, 2011},
  {2018, 2019, 2058},
  {1982, 2040, 2059},
  {2020, 1983, 2041},
  {1983, 2042, 2041},
  {1983, 2061, 2043},
  {1983, 2014, 2061},
  {2014, 2044, 2061},
  {2008, 2015, 2050},
  {2021, 2033, 2015},
  {2021, 2003, 2033},
  {2022, 2016, 2027},
  {2016, 2017, 2036},
  {2017, 2023, 2036},
  {2023, 2024, 2028},
  {2024, 2025, 2028},
  {2029, 2030, 2039},
  {2029, 2026, 2030},
  {2000, 2031, 2026},
  {2031, 1981, 2048},
  {1981, 2011, 2048},
  {1983, 2043, 2042},
  {2008, 2050, 2032},
  {2022, 2034, 2033},
  {2022, 2027, 2034},
  {2027, 2035, 2034},
  {2027, 2046, 2035},
  {2027, 2016, 2046},
  {2016, 2036, 2046},
  {2023, 2028, 2062},
  {2037, 2025, 2038},
  {2025, 2039, 2038},
  {2025, 2029, 2039},
  {2040, 2020, 2041},
  {2041, 2042, 2049},
  {2032, 2045, 2044},
  {2032, 2050, 2045},
  {2015, 2033, 2050},
  {2033, 2034, 2053},
  {2034, 2035, 2046},
  {2036, 2023, 2062},
  {2028, 2025, 2062},
  {2025, 2047, 2062},
  {2025, 2037, 2047},
  {2037, 2038, 2047},
  {2026, 2031, 2111},
  {2042, 2043, 2052},
  {2044, 2103, 2061},
  {2044, 2045, 2103},
  {2033, 2053, 2050},
  {2053, 2034, 2074},
  {2034, 2046, 2074},
  {2038, 2063, 2047},
  {2026, 2111, 2030},
  {2111, 2031, 2048},
  {2011, 2051, 2055},
  {2011, 2058, 2051},
  {2041, 2049, 2096},
  {2062, 2047, 2076},
  {2038, 2039, 2063},
  {2048, 2011, 2079},
  {2011, 2054, 2064},
  {2011, 2055, 2054},
  {2051, 2056, 2055},
  {2051, 2057, 2056},
  {2051, 2058, 2057},
  {2040, 2041, 2072},
  {2049, 2042, 2073},
  {2042, 2060, 2073},
  {2042, 2052, 2060},
  {2052, 2086, 2060},
  {2052, 2043, 2086},
  {2043, 2061, 2086},
  {2103, 2045, 2087},
  {2045, 2050, 2087},
  {2050, 2053, 2097},
  {2074, 2046, 2075},
  {2046, 2036, 2075},
  {2036, 2062, 2075},
  {2076, 2047, 2078},
  {2047, 2063, 2078},
  {2011, 2064, 2079},
  {2064, 2054, 2065},
  {2054, 2066, 2065},
  {2054, 2055, 2066},
  {2055, 2067, 2066},
  {2055, 2068, 2067},
  {2055, 2069, 2068},
  {2055, 2056, 2069},
  {2056, 2070, 2069},
  {2056, 2057, 2070},
  {2057, 2071, 2070},
  {2057, 2058, 2071},
  {2059, 2040, 2072},
  {2053, 2074, 2109},
  {2075, 2062, 2104},
  {2062, 2076, 2088},
  {2076, 2078, 2077},
  {2063, 2110, 2078},
  {2048, 2079, 2111},
  {2065, 2080, 2064},
  {2065, 2066, 2080},
  {2066, 2081, 2080},
  {2066, 2067, 2081},
  {2067, 2082, 2081},
  {2067, 2068, 2082},
  {2068, 2083, 2082},
  {2068, 2069, 2083},
  {2069, 2084, 2083},
  {2069, 2070, 2084},
  {2070, 2085, 2084},
  {2070, 2071, 2085},
  {2041, 2096, 2072},
  {2060, 2086, 2073},
  {2087, 2050, 2097},
  {2053, 2109, 2097},
  {2062, 2088, 2104},
  {2076, 2077, 2089},
  {2077, 2078, 2089},
  {2064, 2080, 2098},
  {2080, 2090, 2098},
  {2080, 2081, 2090},
  {2081, 2091, 2090},
  {2081, 2082, 2091},
  {2082, 2092, 2091},
  {2082, 2083, 2092},
  {2083, 2093, 2092},
  {2083, 2084, 2093},
  {2084, 2094, 2093},
  {2084, 2085, 2094},
  {2059, 2072, 2095},
  {2049, 2073, 2096},
  {2089, 2110, 2076},
  {2089, 2078, 2110},
  {2063, 2113, 2110},
  {2063, 2039, 2113},
  {2039, 2030, 2113},
  {2098, 2090, 2099},
  {2090, 2091, 2099},
  {2091, 2100, 2099},
  {2091, 2092, 2100},
  {2092, 2101, 2100},
  {2092, 2093, 2101},
  {2093, 2102, 2101},
  {2093, 2094, 2102},
  {2095, 2072, 2115},
  {2096, 2073, 2108},
  {2073, 2086, 2108},
  {2075, 2104, 2112},
  {2088, 2076, 2104},
  {2064, 2098, 2079},
  {2098, 2099, 2105},
  {2099, 2106, 2105},
  {2099, 2100, 2106},
  {2100, 2107, 2106},
  {2100, 2101, 2107},
  {2101, 2102, 2107},
  {2115, 2072, 2124},
  {2086, 2061, 2108},
  {2074, 2075, 2109},
  {2075, 2112, 2109},
  {2104, 2076, 2110},
  {2030, 2111, 2113},
  {2079, 2098, 2114},
  {2106, 2107, 2105},
  {2061, 2103, 2108},
  {2079, 2114, 2111},
  {2105, 2107, 2116},
  {2103, 2087, 2127},
  {2097, 2109, 2087},
  {2109, 2112, 2130},
  {2112, 2104, 2130},
  {2114, 2098, 2122},
  {2105, 2116, 2122},
  {2115, 2124, 2117},
  {2108, 2103, 2126},
  {2104, 2110, 2131},
  {2110, 2113, 2131},
  {2113, 2111, 2132},
  {2132, 2111, 2114},
  {2098, 2105, 2122},
  {2122, 2116, 2118},
  {2122, 2118, 2119},
  {2118, 2116, 2119},
  {2103, 2127, 2126},
  {2087, 2128, 2127},
  {2087, 2109, 2128},
  {2104, 2131, 2130},
  {2131, 2113, 2121},
  {2113, 2132, 2121},
  {2119, 2116, 2136},
  {2117, 2124, 2120},
  {2096, 2125, 2072},
  {2119, 2136, 2122},
  {2124, 2072, 2125},
  {2096, 2108, 2125},
  {2128, 2109, 2130},
  {2114, 2122, 2133},
  {2120, 2124, 2123},
  {2128, 2130, 2129},
  {2121, 2132, 2131},
  {2114, 2133, 2132},
  {2122, 2136, 2134},
  {2108, 2126, 2125},
  {2122, 2134, 2133},
  {2134, 2136, 2135},
};

SVV_NAMESPACE_BEGIN

svvModel face( "face",
               face_vertices, face_nvertices,
               face_indices, face_nindices );

SVV_NAMESPACE_END

#endif /* SV_FACE_H_ */
/*
 * End of: $Id: face.h,v 1.1.1.1 2006/12/19 22:58:44 christianh Exp $.
 * 
 */
