/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: inflatedsurf.h,v 1.1.1.1 2006/12/19 22:58:53 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_INFLATEDSURF_H_
#  define SVV_INFLATEDSURF_H_
#  include "svvModel.h"

static GLsizei inflatedsurf_nvertices = 5918;
static GLsizei inflatedsurf_nindices  = 11832;
static GLsizei inflatedsurf_nedges    = 47328;

static GLfloat inflatedsurf_vertices[][6] =
{
  { 2.764123e-01, -9.607323e-01,  2.428246e-02,  1.212117e-01, -1.418475e+00, -4.012771e-01},
  { 3.205440e-01, -9.341859e-01, -1.566786e-01,  1.189231e-01, -1.418334e+00, -4.122449e-01},
  { 1.610911e-01, -9.746473e-01,  1.552809e-01,  1.057067e-01, -1.418557e+00, -3.768505e-01},
  { 2.686070e-01, -9.539908e-01,  1.332358e-01,  1.256035e-01, -1.416103e+00, -3.914928e-01},
  { 4.662471e-01, -8.841531e-01,  2.978078e-02,  1.339366e-01, -1.412834e+00, -3.950260e-01},
  { 9.862325e-02, -9.946061e-01,  3.212617e-02,  1.007090e-01, -1.421605e+00, -4.072092e-01},
  { 2.015055e-01, -9.566179e-01, -2.104227e-01,  1.095208e-01, -1.420148e+00, -4.140199e-01},
  { 1.584398e-02, -9.923577e-01, -1.223729e-01, -6.368057e-03, -1.420175e+00, -5.230505e-01},
  { 4.995664e-01, -8.564833e-01, -1.298830e-01,  1.336313e-01, -1.413020e+00, -4.069696e-01},
  { 1.715118e-01, -9.812690e-01, -8.772022e-02,  1.351356e-02, -1.419119e+00, -5.115822e-01},
  { 1.441506e-01, -9.823334e-01, -1.193386e-01,  5.358334e-03, -1.419356e+00, -5.209182e-01},
  { 5.663906e-02, -9.682554e-01,  2.434616e-01,  9.125545e-02, -1.413394e+00, -3.446256e-01},
  { 6.027814e-01, -7.961276e-01,  5.324754e-02,  1.429317e-01, -1.406249e+00, -3.848876e-01},
  {-9.290945e-02, -9.956268e-01,  9.749380e-03, -2.249191e-02, -1.419210e+00, -5.130064e-01},
  {-1.295757e-01, -9.788688e-01, -1.581960e-01, -2.899414e-02, -1.418225e+00, -5.248427e-01},
  { 6.314588e-01, -7.707714e-01, -8.468265e-02,  1.438647e-01, -1.405781e+00, -4.022361e-01},
  {-7.681620e-03, -9.997311e-01,  2.188315e-02, -3.474066e-03, -1.420098e+00, -5.005868e-01},
  {-3.435124e-02, -9.704320e-01, -2.389182e-01, -1.617168e-02, -1.417102e+00, -5.355536e-01},
  {-2.334475e-02, -9.308502e-01, -3.646546e-01, -2.089662e-02, -1.414535e+00, -5.418921e-01},
  { 2.865790e-01, -8.764328e-01, -3.869598e-01,  1.064348e-01, -1.415431e+00, -4.303835e-01},
  { 5.561284e-01, -7.737269e-01, -3.034267e-01,  1.347318e-01, -1.409796e+00, -4.148052e-01},
  { 2.255583e-01, -9.711516e-01, -7.738227e-02,  2.789176e-02, -1.417026e+00, -5.049717e-01},
  { 2.968440e-01, -9.352744e-01, -1.927314e-01,  4.523081e-02, -1.409320e+00, -5.207412e-01},
  { 2.770632e-01, -9.265920e-01, -2.542898e-01,  4.518957e-02, -1.408166e+00, -5.281020e-01},
  {-6.775911e-02, -9.206209e-01,  3.845334e-01,  8.143497e-02, -1.401881e+00, -3.094828e-01},
  { 9.680131e-02, -9.493197e-01,  2.990345e-01,  1.027687e-01, -1.406461e+00, -3.223432e-01},
  { 2.586284e-01, -9.433065e-01,  2.080487e-01,  1.228645e-01, -1.408292e+00, -3.450951e-01},
  { 5.969544e-01, -7.990172e-01,  7.222841e-02,  1.499855e-01, -1.399516e+00, -3.678963e-01},
  {-2.458196e-02, -9.870657e-01,  1.584208e-01,  7.394383e-02, -1.418812e+00, -3.709887e-01},
  { 4.089967e-01, -8.980426e-01,  1.619913e-01,  1.368292e-01, -1.407491e+00, -3.675114e-01},
  { 1.045229e-02, -9.987466e-01,  4.895008e-02,  7.868103e-02, -1.422707e+00, -4.033603e-01},
  {-2.231797e-01, -9.735019e-01, -4.984974e-02, -4.189314e-02, -1.415450e+00, -5.256313e-01},
  {-1.522384e-01, -9.504883e-01, -2.709159e-01, -4.394737e-02, -1.410121e+00, -5.494889e-01},
  { 2.288464e-01, -9.034855e-01, -3.624134e-01,  8.742661e-02, -1.418032e+00, -4.364261e-01},
  { 1.450684e-01, -9.298026e-01, -3.382636e-01,  4.398369e-03, -1.416021e+00, -5.353527e-01},
  { 4.902783e-01, -7.440448e-01, -4.538993e-01,  1.338971e-01, -1.402398e+00, -4.306179e-01},
  { 2.240176e-01, -9.333556e-01, -2.804701e-01,  1.965540e-02, -1.414680e+00, -5.312477e-01},
  { 2.602489e-01, -8.680067e-01, -4.228887e-01,  2.721547e-02, -1.402877e+00, -5.518607e-01},
  {-1.272951e-01, -8.656293e-01,  4.842334e-01,  7.565713e-02, -1.378944e+00, -2.630951e-01},
  {-1.480071e-01, -8.861060e-01,  4.392152e-01,  5.533027e-02, -1.387729e+00, -2.852720e-01},
  { 6.212933e-01, -7.384831e-01,  2.619873e-01,  1.777851e-01, -1.371506e+00, -3.033978e-01},
  { 8.086427e-01, -5.833755e-01,  7.596136e-02,  1.881062e-01, -1.363047e+00, -3.170609e-01},
  { 6.867036e-01, -7.250867e-01,  5.183979e-02,  1.796027e-01, -1.372837e+00, -3.189462e-01},
  {-9.906489e-02, -9.537939e-01,  2.836607e-01,  6.444103e-02, -1.406973e+00, -3.274729e-01},
  { 2.615965e-01, -9.358494e-01,  2.361212e-01,  1.211685e-01, -1.404191e+00, -3.262860e-01},
  { 6.686330e-01, -7.430777e-01,  2.766732e-02,  1.629448e-01, -1.389631e+00, -3.753695e-01},
  {-3.896049e-01, -9.199654e-01, -4.326334e-02, -7.518178e-02, -1.405328e+00, -5.409977e-01},
  {-2.711168e-01, -9.593803e-01, -7.800609e-02, -5.916148e-02, -1.411271e+00, -5.228768e-01},
  {-1.773055e-01, -9.424342e-01, -2.835147e-01, -6.422964e-02, -1.403518e+00, -5.601486e-01},
  { 6.942485e-01, -7.087975e-01, -1.250003e-01,  1.574349e-01, -1.392487e+00, -4.073219e-01},
  { 1.097326e-01, -9.771026e-01, -1.822888e-01,  8.415321e-02, -1.421411e+00, -4.264463e-01},
  {-2.112124e-01, -9.734794e-01,  8.790340e-02, -4.190847e-02, -1.414920e+00, -4.978472e-01},
  { 2.133949e-01, -9.710395e-01, -1.074476e-01,  3.643700e-02, -1.416983e+00, -4.848993e-01},
  { 2.186827e-01, -8.984232e-01, -3.808066e-01,  7.341814e-03, -1.412199e+00, -5.428231e-01},
  { 8.560848e-02, -9.224058e-01, -3.766147e-01, -1.733134e-02, -1.399492e+00, -5.738545e-01},
  { 1.481538e-01, -9.472045e-01, -2.843484e-01, -7.478474e-03, -1.398340e+00, -5.770187e-01},
  { 2.319942e-01, -9.076319e-01, -3.498330e-01,  1.431735e-03, -1.396222e+00, -5.752565e-01},
  { 4.498996e-01, -8.263659e-01, -3.386882e-01,  5.229688e-02, -1.402745e+00, -5.329490e-01},
  {-8.067814e-02, -8.236490e-01,  5.613317e-01,  7.356120e-02, -1.354749e+00, -2.239948e-01},
  {-9.215201e-03, -8.301016e-01,  5.575359e-01,  8.187789e-02, -1.359979e+00, -2.308834e-01},
  { 7.438845e-01, -6.200832e-01,  2.492644e-01,  1.834906e-01, -1.363797e+00, -2.995656e-01},
  { 8.548710e-01, -5.179834e-01, -2.980866e-02,  1.938038e-01, -1.354462e+00, -3.276621e-01},
  { 5.166727e-01, -8.278464e-01,  2.184480e-01,  1.710436e-01, -1.378153e+00, -3.105454e-01},
  { 7.187227e-01, -6.952412e-01, -8.790769e-03,  1.770039e-01, -1.375172e+00, -3.474328e-01},
  {-1.687319e-01, -9.534385e-01,  2.499689e-01,  4.594336e-02, -1.411197e+00, -3.500203e-01},
  { 7.242400e-01, -6.892906e-01,  1.883384e-02,  1.720909e-01, -1.380414e+00, -3.693829e-01},
  {-1.178621e-01, -9.794959e-01,  1.633901e-01,  5.271164e-02, -1.419600e+00, -3.870798e-01},
  {-4.342097e-01, -8.658413e-01, -2.485573e-01, -9.249809e-02, -1.395282e+00, -5.638627e-01},
  { 7.516985e-01, -6.497796e-01, -1.128527e-01,  1.680405e-01, -1.382925e+00, -3.964579e-01},
  {-2.589346e-01, -8.811757e-01, -3.955784e-01, -8.250480e-02, -1.394258e+00, -5.736855e-01},
  { 7.068322e-01, -6.401644e-01, -3.009613e-01,  1.578643e-01, -1.389048e+00, -4.156356e-01},
  {-3.134919e-02, -9.880283e-01, -1.510540e-01,  5.941848e-02, -1.421247e+00, -4.345926e-01},
  { 9.512649e-02, -9.855657e-01, -1.400403e-01,  5.688292e-02, -1.419372e+00, -4.481900e-01},
  { 1.004478e-01, -9.925320e-01, -6.921367e-02,  3.076822e-02, -1.419488e+00, -4.632537e-01},
  {-1.145875e-01, -9.072493e-01, -4.046831e-01, -6.049599e-02, -1.398785e+00, -5.736696e-01},
  { 7.598388e-02, -9.893798e-01, -1.239125e-01,  4.636213e-02, -1.419385e+00, -4.545994e-01},
  {-3.057207e-01, -9.498166e-01,  6.620613e-02, -5.704556e-02, -1.411456e+00, -5.047808e-01},
  { 6.454034e-01, -6.499870e-01, -4.012123e-01,  1.535915e-01, -1.388252e+00, -4.254121e-01},
  { 6.411606e-01, -5.848559e-01, -4.968468e-01,  1.446130e-01, -1.379801e+00, -4.485104e-01},
  {-9.681260e-03, -9.064487e-01, -4.222050e-01, -3.347920e-02, -1.398227e+00, -5.783272e-01},
  { 4.991702e-01, -7.700906e-01, -3.972274e-01,  7.466026e-02, -1.385251e+00, -5.397711e-01},
  { 1.581604e-02, -7.826058e-01,  6.223167e-01,  9.105457e-02, -1.342085e+00, -2.068954e-01},
  { 1.153651e-01, -7.830133e-01,  6.112127e-01,  1.071794e-01, -1.345176e+00, -2.122046e-01},
  {-1.727263e-01, -8.449429e-01,  5.061988e-01,  4.347344e-02, -1.355562e+00, -2.320141e-01},
  { 8.205478e-01, -4.816385e-01,  3.077752e-01,  1.953114e-01, -1.344097e+00, -2.917161e-01},
  {-2.651780e-01, -8.246651e-01,  4.996081e-01,  2.226301e-02, -1.378484e+00, -2.812351e-01},
  { 8.602813e-01, -4.858920e-01,  1.543536e-01,  1.945499e-01, -1.349774e+00, -3.028103e-01},
  {-3.708949e-02, -8.671436e-01,  4.966752e-01,  8.781135e-02, -1.383930e+00, -2.692249e-01},
  { 4.459030e-01, -8.403187e-01,  3.082775e-01,  1.575554e-01, -1.384899e+00, -3.065913e-01},
  { 1.156950e-01, -9.177818e-01,  3.798567e-01,  1.135846e-01, -1.392442e+00, -2.866580e-01},
  {-2.171713e-01, -9.064536e-01,  3.621857e-01,  2.422693e-02, -1.395136e+00, -3.138759e-01},
  { 8.538678e-01, -5.190572e-01, -3.859448e-02,  1.918229e-01, -1.356248e+00, -3.519949e-01},
  { 2.320563e-01, -9.269839e-01,  2.947046e-01,  1.229735e-01, -1.398142e+00, -3.072244e-01},
  { 4.870438e-01, -8.595976e-01,  1.545328e-01,  1.466482e-01, -1.394332e+00, -3.224595e-01},
  { 8.628570e-01, -5.036146e-01, -4.301111e-02,  1.925975e-01, -1.353334e+00, -3.707082e-01},
  { 8.197454e-01, -5.565240e-01, -1.352725e-01,  1.866223e-01, -1.362095e+00, -3.833406e-01},
  {-3.673511e-01, -9.240989e-01, -1.053304e-01, -9.338420e-02, -1.397607e+00, -5.505019e-01},
  {-1.425423e-01, -9.888158e-01,  4.387436e-02,  6.071041e-02, -1.422306e+00, -4.074343e-01},
  {-1.011648e-01, -9.940463e-01, -4.046696e-02,  6.097464e-02, -1.422397e+00, -4.230442e-01},
  {-5.388213e-01, -7.648977e-01, -3.529916e-01, -1.069477e-01, -1.384314e+00, -5.695878e-01},
  {-5.823674e-01, -7.199487e-01, -3.775208e-01, -1.039802e-01, -1.381547e+00, -5.796795e-01},
  { 7.306579e-01, -5.433032e-01, -4.134740e-01,  1.601390e-01, -1.379178e+00, -4.271721e-01},
  { 6.826395e-01, -5.688351e-01, -4.587262e-01,  1.407970e-01, -1.370646e+00, -4.648089e-01},
  { 5.551766e-01, -7.411190e-01, -3.775200e-01,  1.031205e-01, -1.388549e+00, -4.887545e-01},
  { 4.815349e-01, -7.737163e-01, -4.116882e-01,  6.559525e-02, -1.380983e+00, -5.586458e-01},
  {-4.258833e-01, -7.950214e-01, -4.319309e-01, -1.189580e-01, -1.356868e+00, -6.148980e-01},
  { 1.290458e-01, -8.580667e-01, -4.970600e-01, -7.961870e-03, -1.386821e+00, -5.961538e-01},
  { 3.337027e-01, -7.615848e-01, -5.555460e-01,  4.601460e-02, -1.333768e+00, -6.672111e-01},
  { 2.047409e-01, -7.394594e-01,  6.413121e-01,  1.227307e-01, -1.334180e+00, -2.025421e-01},
  { 8.933620e-01, -3.117607e-01,  3.235886e-01,  1.968626e-01, -1.336522e+00, -2.872113e-01},
  { 1.408067e-01, -8.081104e-01,  5.719537e-01,  1.163175e-01, -1.358461e+00, -2.318368e-01},
  { 5.832899e-01, -7.272004e-01,  3.618736e-01,  1.740118e-01, -1.363466e+00, -2.819827e-01},
  { 7.571629e-02, -8.834305e-01,  4.624042e-01,  1.126387e-01, -1.387416e+00, -2.766183e-01},
  { 9.166412e-01, -3.966527e-01,  4.935087e-02,  1.977684e-01, -1.346031e+00, -3.140443e-01},
  {-3.905403e-01, -8.347973e-01,  3.880616e-01, -6.125668e-02, -1.352122e+00, -2.922643e-01},
  { 3.433698e-01, -8.774639e-01,  3.348943e-01,  1.353723e-01, -1.390702e+00, -2.953951e-01},
  { 9.591026e-01, -2.292502e-01, -1.660315e-01,  2.033899e-01, -1.317044e+00, -3.914362e-01},
  { 9.269167e-01, -3.141529e-01, -2.052643e-01,  2.003000e-01, -1.325090e+00, -3.949798e-01},
  { 9.129013e-01, -2.586509e-01, -3.157702e-01,  1.987392e-01, -1.321231e+00, -4.045749e-01},
  {-5.738991e-01, -8.173867e-01, -5.018579e-02, -1.011188e-01, -1.392678e+00, -5.501914e-01},
  {-2.135850e-01, -9.689022e-01,  1.249399e-01, -2.745242e-02, -1.413956e+00, -4.614443e-01},
  { 8.012599e-01, -5.154949e-01, -3.037228e-01,  1.758070e-01, -1.368478e+00, -4.089587e-01},
  {-4.402168e-01, -8.957445e-01,  6.205614e-02, -8.152906e-02, -1.402182e+00, -5.179335e-01},
  {-5.143430e-01, -8.140032e-01, -2.699076e-01, -1.337105e-01, -1.361035e+00, -5.874642e-01},
  { 6.899459e-01, -5.764374e-01, -4.378295e-01,  1.338362e-01, -1.360313e+00, -4.890341e-01},
  { 7.005726e-01, -5.810797e-01, -4.141793e-01,  1.325987e-01, -1.356898e+00, -4.955322e-01},
  {-4.460759e-01, -8.014402e-01, -3.983842e-01, -1.002345e-01, -1.374026e+00, -5.994207e-01},
  { 7.518282e-01, -4.452488e-01, -4.863208e-01,  1.622074e-01, -1.367725e+00, -4.362774e-01},
  {-3.822019e-01, -9.118448e-01,  1.498690e-01, -6.266453e-02, -1.406509e+00, -4.843799e-01},
  {-4.866024e-02, -8.815794e-01, -4.695209e-01, -4.731657e-02, -1.389936e+00, -5.943426e-01},
  {-3.346218e-01, -8.075696e-01, -4.856536e-01, -1.005442e-01, -1.359794e+00, -6.250554e-01},
  {-3.529667e-01, -7.884582e-01, -5.037341e-01, -1.047026e-01, -1.345951e+00, -6.448204e-01},
  {-3.299388e-01, -8.293580e-01, -4.508944e-01, -1.041645e-01, -1.337617e+00, -6.592762e-01},
  { 2.060925e-01, -9.154279e-01, -3.457134e-01,  3.733983e-02, -1.346028e+00, -6.499145e-01},
  { 1.146506e-01, -9.689873e-01, -2.189036e-01,  2.521563e-02, -1.348066e+00, -6.542059e-01},
  { 4.174463e-01, -7.891068e-01, -4.506096e-01,  5.234000e-02, -1.336458e+00, -6.583617e-01},
  { 1.256689e-01, -8.829737e-01, -4.522883e-01,  1.526810e-02, -1.347831e+00, -6.552464e-01},
  { 2.977904e-01, -6.618686e-01,  6.879323e-01,  1.307129e-01, -1.313289e+00, -1.828012e-01},
  { 2.968846e-01, -7.523719e-01,  5.880442e-01,  1.351062e-01, -1.344948e+00, -2.211895e-01},
  {-1.517780e-01, -8.223447e-01,  5.483727e-01,  4.251627e-02, -1.343449e+00, -2.130600e-01},
  {-2.578304e-01, -8.395200e-01,  4.782569e-01, -6.448526e-04, -1.357211e+00, -2.549593e-01},
  { 1.097242e-01, -8.353488e-01,  5.386584e-01,  1.119242e-01, -1.375512e+00, -2.556060e-01},
  { 9.407344e-01, -3.112483e-01,  1.346974e-01,  2.016771e-01, -1.332106e+00, -3.013448e-01},
  { 9.608032e-01, -2.221850e-01,  1.658041e-01,  2.036366e-01, -1.323734e+00, -3.001649e-01},
  {-3.459132e-01, -8.026865e-01,  4.858379e-01,  1.932063e-03, -1.379824e+00, -2.959258e-01},
  {-3.347960e-01, -8.459210e-01,  4.151255e-01, -2.907175e-02, -1.363081e+00, -2.857406e-01},
  { 4.454480e-01, -8.414204e-01,  3.059215e-01,  1.517721e-01, -1.379456e+00, -2.836964e-01},
  { 2.413231e-01, -8.762941e-01,  4.169793e-01,  1.298343e-01, -1.387304e+00, -2.825285e-01},
  { 9.491999e-01, -3.136197e-01, -2.573503e-02,  2.024828e-01, -1.332953e+00, -3.489095e-01},
  {-4.594851e-01, -8.171830e-01,  3.479734e-01, -8.797213e-02, -1.335425e+00, -2.859837e-01},
  { 9.482185e-01, -3.111683e-01, -6.368626e-02,  2.018986e-01, -1.333253e+00, -3.571998e-01},
  { 9.679748e-01, -1.603420e-01, -1.931714e-01,  2.070039e-01, -1.292410e+00, -3.967252e-01},
  {-2.820604e-01, -9.240410e-01,  2.580510e-01,  1.191663e-02, -1.403971e+00, -3.544799e-01},
  {-2.297726e-01, -9.547139e-01,  1.890129e-01,  2.346279e-02, -1.411724e+00, -3.725325e-01},
  { 9.254397e-01, -3.455235e-01, -1.554828e-01,  1.977450e-01, -1.339233e+00, -3.834774e-01},
  { 8.960945e-01, -2.218621e-01, -3.844371e-01,  1.975444e-01, -1.303514e+00, -4.185480e-01},
  { 8.735127e-01, -3.349604e-01, -3.532381e-01,  1.911333e-01, -1.335920e+00, -4.092973e-01},
  { 8.847316e-01, -4.174642e-01, -2.073009e-01,  1.925000e-01, -1.350188e+00, -3.892722e-01},
  { 8.394418e-01, -4.317517e-01, -3.300420e-01,  1.867279e-01, -1.351410e+00, -4.036339e-01},
  {-6.243512e-01, -7.573493e-01, -1.913309e-01, -1.165764e-01, -1.380815e+00, -5.552335e-01},
  { 8.038418e-01, -4.025087e-01, -4.379784e-01,  1.768878e-01, -1.334930e+00, -4.399169e-01},
  {-1.092056e-01, -9.933175e-01,  3.734298e-02,  1.728643e-02, -1.418225e+00, -4.327319e-01},
  {-3.728779e-01, -9.028168e-01,  2.142054e-01, -4.308322e-02, -1.409050e+00, -4.567466e-01},
  {-2.837743e-01, -8.346775e-01, -4.720016e-01, -8.621100e-02, -1.372997e+00, -6.106274e-01},
  {-5.526197e-01, -7.756392e-01, -3.049514e-01, -1.477928e-01, -1.349400e+00, -5.929655e-01},
  { 3.169567e-01, -8.381649e-01, -4.438671e-01,  4.331042e-02, -1.370658e+00, -5.965714e-01},
  {-2.071399e-01, -8.398375e-01, -5.017629e-01, -8.659339e-02, -1.353243e+00, -6.445130e-01},
  {-4.416970e-01, -7.616912e-01, -4.740573e-01, -1.362608e-01, -1.315941e+00, -6.683494e-01},
  {-2.805290e-01, -8.491849e-01, -4.474242e-01, -8.749861e-02, -1.337015e+00, -6.725973e-01},
  { 2.023930e-01, -7.342727e-01, -6.479819e-01,  1.401636e-02, -1.319843e+00, -6.936513e-01},
  {-3.683461e-01, -7.822911e-01, -5.023364e-01, -1.011846e-01, -1.326321e+00, -6.813904e-01},
  { 3.070244e-01, -6.358927e-01, -7.080794e-01,  4.306707e-02, -1.318379e+00, -6.856561e-01},
  { 3.464280e-01, -6.214463e-01,  7.027035e-01,  1.326717e-01, -1.299871e+00, -1.718108e-01},
  { 1.331607e-01, -7.223557e-01,  6.785798e-01,  9.322599e-02, -1.315224e+00, -1.753894e-01},
  { 3.721615e-01, -6.798246e-01,  6.319290e-01,  1.370820e-01, -1.322260e+00, -1.951832e-01},
  { 4.403460e-01, -6.800900e-01,  5.861509e-01,  1.422324e-01, -1.334232e+00, -2.123582e-01},
  { 3.385496e-01, -7.496206e-01,  5.687295e-01,  1.351460e-01, -1.355790e+00, -2.352779e-01},
  {-3.654986e-01, -7.884005e-01,  4.948085e-01, -6.175358e-03, -1.379176e+00, -3.009773e-01},
  { 3.992894e-01, -7.856322e-01,  4.725993e-01,  1.558038e-01, -1.373089e+00, -2.756575e-01},
  { 9.725301e-01, -2.308176e-01,  3.013966e-02,  2.053472e-01, -1.322171e+00, -3.237673e-01},
  {-3.308598e-01, -8.858024e-01,  3.254012e-01, -1.609169e-02, -1.382874e+00, -3.179102e-01},
  { 9.873582e-01, -1.014658e-01, -1.217726e-01,  2.124774e-01, -1.275563e+00, -3.726043e-01},
  {-5.672434e-01, -7.779590e-01,  2.702121e-01, -1.140954e-01, -1.323265e+00, -2.983254e-01},
  { 9.187787e-01, -5.333557e-02, -3.911537e-01,  2.035051e-01, -1.281985e+00, -4.127249e-01},
  { 8.441142e-01, -1.544824e-03, -5.361612e-01,  1.904373e-01, -1.301330e+00, -4.349473e-01},
  { 8.677367e-01, -1.638419e-01, -4.692430e-01,  1.838481e-01, -1.308371e+00, -4.446450e-01},
  {-1.925168e-01, -9.757131e-01,  1.045053e-01,  2.591993e-02, -1.418586e+00, -4.147788e-01},
  {-2.045591e-01, -9.759862e-01,  7.487666e-02,  1.912116e-02, -1.418011e+00, -4.244794e-01},
  {-5.603711e-01, -8.224256e-01,  9.798145e-02, -1.106206e-01, -1.384699e+00, -5.298008e-01},
  {-6.179542e-01, -7.842950e-01, -5.490138e-02, -1.300028e-01, -1.369849e+00, -5.558473e-01},
  {-5.371966e-01, -8.362852e-01,  1.097582e-01, -9.763736e-02, -1.391979e+00, -5.150687e-01},
  {-6.329810e-01, -7.711416e-01,  6.837872e-02, -1.237947e-01, -1.374641e+00, -5.344633e-01},
  {-5.795310e-01, -7.907045e-01, -1.973071e-01, -1.456619e-01, -1.355872e+00, -5.773348e-01},
  { 6.581449e-01, -6.600772e-01, -3.621372e-01,  1.006176e-01, -1.358918e+00, -5.499759e-01},
  {-6.506764e-01, -7.304485e-01, -2.075215e-01, -1.698770e-01, -1.330027e+00, -5.974498e-01},
  {-5.155339e-01, -7.540996e-01, -4.068889e-01, -1.616594e-01, -1.328414e+00, -6.192363e-01},
  { 1.263897e-01, -8.610255e-01, -4.926061e-01, -2.096733e-02, -1.375920e+00, -6.190047e-01},
  { 1.526671e-01, -8.592267e-01, -4.882848e-01, -1.444897e-02, -1.364909e+00, -6.359093e-01},
  { 8.830885e-01, -3.206847e-01, -3.425143e-01,  1.267419e-01, -1.267964e+00, -6.440421e-01},
  { 8.666108e-01, -3.476924e-01, -3.579045e-01,  1.203171e-01, -1.276944e+00, -6.517555e-01},
  { 2.482398e-01, -6.417485e-01, -7.256280e-01,  2.373485e-02, -1.305858e+00, -7.039140e-01},
  { 2.448263e-01, -6.147288e-01, -7.497791e-01,  2.179928e-03, -1.307959e+00, -7.091213e-01},
  { 5.236053e-01, -6.918061e-01, -4.972340e-01,  6.623485e-02, -1.321671e+00, -6.659584e-01},
  { 8.090452e-01, -4.483594e-01, -3.800260e-01,  1.160046e-01, -1.281060e+00, -6.577271e-01},
  { 3.909717e-01, -6.659488e-01, -6.353372e-01,  6.104505e-02, -1.311293e+00, -6.828536e-01},
  {-2.176304e-01, -8.091120e-01, -5.458707e-01, -7.560558e-02, -1.328192e+00, -6.944551e-01},
  {-1.276487e-01, -8.205330e-01, -5.571637e-01, -6.054171e-02, -1.335933e+00, -6.895475e-01},
  {-2.264066e-02, -8.317560e-01, -5.546796e-01, -4.932086e-02, -1.322565e+00, -7.105272e-01},
  { 9.388908e-02, -6.940544e-01, -7.137740e-01, -4.501054e-02, -1.317644e+00, -7.172455e-01},
  { 4.249062e-01, -4.913854e-01,  7.602599e-01,  1.369493e-01, -1.289487e+00, -1.654606e-01},
  { 2.877908e-01, -5.846049e-01,  7.585602e-01,  1.230103e-01, -1.294048e+00, -1.630246e-01},
  {-4.067789e-02, -7.712144e-01,  6.352745e-01,  6.047493e-02, -1.315644e+00, -1.731971e-01},
  {-1.071223e-01, -7.768257e-01,  6.205374e-01,  4.222697e-02, -1.322583e+00, -1.837129e-01},
  { 2.545760e-01, -7.615638e-01,  5.959963e-01,  1.400683e-01, -1.364200e+00, -2.497030e-01},
  { 7.594905e-01, -4.768955e-01,  4.424307e-01,  1.808477e-01, -1.340702e+00, -2.617446e-01},
  { 2.599604e-01, -8.385179e-01,  4.788614e-01,  1.392545e-01, -1.368962e+00, -2.562795e-01},
  { 2.718750e-01, -8.400614e-01,  4.694473e-01,  1.417333e-01, -1.367656e+00, -2.534041e-01},
  { 2.768904e-01, -8.384927e-01,  4.693204e-01,  1.324783e-01, -1.378906e+00, -2.680751e-01},
  {-3.983141e-01, -8.097534e-01,  4.308659e-01, -7.283756e-02, -1.329091e+00, -2.566163e-01},
  {-4.187408e-01, -8.537608e-01,  3.094327e-01, -4.210935e-02, -1.372599e+00, -3.202673e-01},
  { 9.810780e-01, -1.905256e-01, -3.443786e-02,  2.091749e-01, -1.304113e+00, -3.511179e-01},
  { 9.746051e-01, -1.011201e-01, -1.997985e-01,  2.102522e-01, -1.261701e+00, -3.961369e-01},
  { 9.157996e-01,  4.917264e-04, -4.016353e-01,  2.047894e-01, -1.252351e+00, -4.203136e-01},
  { 9.369022e-01, -1.389412e-01, -3.207953e-01,  2.016920e-01, -1.263762e+00, -4.253666e-01},
  {-5.114531e-01, -8.228478e-01,  2.476635e-01, -9.051938e-02, -1.355654e+00, -3.496235e-01},
  {-6.395711e-01, -7.631643e-01, -9.235259e-02, -1.548425e-01, -1.348968e+00, -5.762757e-01},
  { 7.560393e-01, -5.750812e-01, -3.125480e-01,  1.230033e-01, -1.335735e+00, -5.466224e-01},
  {-4.979587e-01, -8.388739e-01,  2.198359e-01, -7.328890e-02, -1.397786e+00, -4.690681e-01},
  { 6.483721e-01, -6.616393e-01, -3.766259e-01,  9.181091e-02, -1.351889e+00, -5.760323e-01},
  {-1.684688e-01, -8.489637e-01, -5.008781e-01, -5.457954e-02, -1.370796e+00, -6.276781e-01},
  { 5.321625e-01, -6.827070e-01, -5.007137e-01,  6.988977e-02, -1.352154e+00, -6.081281e-01},
  {-5.598204e-01, -6.979942e-01, -4.465482e-01, -1.633010e-01, -1.307054e+00, -6.534958e-01},
  { 1.017366e-01, -8.094250e-01, -5.783433e-01, -2.484784e-02, -1.353247e+00, -6.574116e-01},
  {-5.032621e-01, -6.750830e-01, -5.394351e-01, -1.557435e-01, -1.297587e+00, -6.769153e-01},
  { 7.060774e-01, -5.523846e-01, -4.430867e-01,  1.107426e-01, -1.285661e+00, -6.612698e-01},
  { 5.627234e-02, -8.294564e-01, -5.557296e-01, -4.000108e-02, -1.330272e+00, -6.973780e-01},
  {-1.271825e-01, -7.278602e-01, -6.738280e-01, -5.145088e-02, -1.316884e+00, -7.175847e-01},
  { 2.097337e-01, -7.144956e-01,  6.674637e-01,  9.667975e-02, -1.277354e+00, -1.365043e-01},
  { 3.134957e-01, -7.759867e-01,  5.473254e-01,  5.576322e-02, -1.220785e+00, -5.492962e-02},
  { 5.013153e-01, -6.011906e-01,  6.222964e-01,  1.494201e-01, -1.309583e+00, -1.915696e-01},
  { 1.441837e-02, -7.811739e-01,  6.241470e-01,  5.708902e-02, -1.311507e+00, -1.679691e-01},
  { 5.106277e-01, -6.555262e-01,  5.563675e-01,  1.592916e-01, -1.338325e+00, -2.310994e-01},
  { 5.376968e-01, -6.591421e-01,  5.257507e-01,  1.596595e-01, -1.346059e+00, -2.409178e-01},
  {-3.075025e-01, -8.265528e-01,  4.714368e-01, -2.491168e-02, -1.333510e+00, -2.269072e-01},
  {-1.880945e-01, -8.149815e-01,  5.481111e-01,  1.031901e-02, -1.322053e+00, -1.908872e-01},
  { 5.567892e-01, -6.931014e-01,  4.578166e-01,  1.681547e-01, -1.349943e+00, -2.552589e-01},
  { 9.820460e-01, -1.571565e-01,  1.043432e-01,  2.099788e-01, -1.286641e+00, -2.954943e-01},
  { 9.937674e-01, -1.114064e-01,  3.856750e-03,  2.131179e-01, -1.279369e+00, -3.450300e-01},
  {-5.236672e-01, -7.647160e-01,  3.754756e-01, -1.031544e-01, -1.315515e+00, -2.604966e-01},
  { 9.588314e-01, -4.300191e-02, -2.807013e-01,  2.077902e-01, -1.243870e+00, -4.122873e-01},
  {-5.714508e-01, -7.525626e-01,  3.272516e-01, -1.222002e-01, -1.311036e+00, -2.830244e-01},
  {-6.123050e-01, -7.592968e-01,  2.203426e-01, -1.339397e-01, -1.318611e+00, -3.308937e-01},
  {-6.714460e-01, -7.380838e-01, -6.627548e-02, -1.588887e-01, -1.345417e+00, -5.760130e-01},
  { 8.672889e-01, -3.338677e-01, -3.692455e-01,  1.529197e-01, -1.307742e+00, -5.155429e-01},
  { 7.502202e-01, -5.387639e-01, -3.832794e-01,  1.187803e-01, -1.332958e+00, -5.574517e-01},
  {-6.363451e-01, -6.884527e-01, -3.479910e-01, -1.939942e-01, -1.296701e+00, -6.271296e-01},
  { 5.494169e-01, -6.613353e-01, -5.106630e-01,  7.710478e-02, -1.349244e+00, -6.045834e-01},
  {-1.973343e-02, -8.581141e-01, -5.130797e-01, -4.014976e-02, -1.367764e+00, -6.349034e-01},
  { 7.893147e-01, -5.495094e-01, -2.739007e-01,  1.202188e-01, -1.293759e+00, -6.204769e-01},
  { 2.405460e-01, -3.938984e-01, -8.871198e-01,  2.071294e-03, -1.284409e+00, -7.242029e-01},
  { 8.994911e-01, -1.307167e-01, -4.169279e-01,  1.289566e-01, -1.246375e+00, -6.508405e-01},
  { 6.669729e-01, -6.597521e-01, -3.462287e-01,  1.084507e-01, -1.299522e+00, -6.407573e-01},
  { 6.443512e-01, -6.655073e-01, -3.767116e-01,  8.064851e-02, -1.326041e+00, -6.418037e-01},
  {-1.460810e-01, -8.430919e-01, -5.175483e-01, -5.083372e-02, -1.352883e+00, -6.593820e-01},
  {-5.725366e-01, -5.697294e-01, -5.895848e-01, -1.641869e-01, -1.287563e+00, -6.802388e-01},
  { 8.463807e-01, -9.776905e-02, -5.235274e-01,  1.242409e-01, -1.257630e+00, -6.558869e-01},
  { 3.060029e-01, -4.575998e-01, -8.348441e-01,  3.832183e-02, -1.291695e+00, -7.081571e-01},
  {-4.510555e-02, -8.297108e-01, -5.563681e-01, -4.499475e-02, -1.353861e+00, -6.583986e-01},
  {-4.394688e-01, -6.813719e-01, -5.853200e-01, -1.265348e-01, -1.303767e+00, -6.931455e-01},
  { 2.522579e-01, -5.023102e-01, -8.270735e-01, -1.473527e-02, -1.297791e+00, -7.223937e-01},
  { 8.260352e-01, -1.032082e-01, -5.540885e-01,  1.174717e-01, -1.263326e+00, -6.658047e-01},
  {-3.415202e-01, -7.239813e-01, -5.993454e-01, -8.842552e-02, -1.313421e+00, -7.087076e-01},
  { 7.492728e-01, -3.370366e-01, -5.700848e-01,  1.121432e-01, -1.274078e+00, -6.695136e-01},
  { 5.025492e-01, -5.493473e-01, -6.675790e-01,  1.013727e-01, -1.286940e+00, -6.730180e-01},
  { 5.208024e-01, -6.381881e-01, -5.669929e-01,  9.994313e-02, -1.291399e+00, -6.696363e-01},
  { 5.435839e-01, -4.210260e-01, -7.261224e-01,  1.016684e-01, -1.278163e+00, -6.788166e-01},
  {-2.749682e-01, -6.506703e-01, -7.078280e-01, -7.875574e-02, -1.314637e+00, -7.114422e-01},
  {-2.365023e-01, -6.717926e-01, -7.019695e-01, -6.969947e-02, -1.314681e+00, -7.152723e-01},
  {-1.830751e-01, -6.772802e-01, -7.125834e-01, -6.080612e-02, -1.314070e+00, -7.180694e-01},
  { 3.779309e-01, -6.405428e-01,  6.684857e-01,  1.096559e-01, -1.252110e+00, -1.184037e-01},
  { 5.120308e-01, -4.501550e-01,  7.315633e-01,  1.445203e-01, -1.282606e+00, -1.659352e-01},
  { 8.763026e-02, -7.565882e-01,  6.479933e-01,  8.586733e-02, -1.238243e+00, -9.254098e-02},
  { 6.392181e-01, -5.095755e-01,  5.759626e-01,  1.543683e-01, -1.285488e+00, -1.761932e-01},
  { 2.596263e-01, -7.681447e-01,  5.852759e-01,  7.255387e-02, -1.243753e+00, -9.175852e-02},
  { 2.700997e-01, -8.295693e-01,  4.887340e-01,  6.826165e-02, -1.244928e+00, -9.132798e-02},
  { 2.411692e-01, -7.100859e-01,  6.615251e-01,  8.301094e-02, -1.269598e+00, -1.230285e-01},
  { 5.842951e-01, -5.139634e-01,  6.280453e-01,  1.515539e-01, -1.297099e+00, -1.823609e-01},
  {-2.303504e-02, -8.026997e-01,  5.959384e-01,  5.265363e-02, -1.304836e+00, -1.595536e-01},
  { 8.980462e-01, -3.089988e-01,  3.131018e-01,  2.002488e-01, -1.295148e+00, -2.599653e-01},
  { 8.220579e-01, -3.915824e-01,  4.133811e-01,  1.849848e-01, -1.314609e+00, -2.423200e-01},
  {-2.219237e-01, -8.248572e-01,  5.199621e-01, -8.912810e-02, -1.314941e+00, -2.467777e-01},
  {-5.778557e-01, -7.370771e-01,  3.504285e-01, -1.174226e-01, -1.306365e+00, -2.650718e-01},
  {-3.035851e-01, -9.341376e-01,  1.876777e-01, -1.538267e-02, -1.403169e+00, -3.883100e-01},
  {-4.397949e-01, -8.678877e-01,  2.309790e-01, -5.387595e-02, -1.381321e+00, -3.676433e-01},
  {-6.479765e-01, -7.359133e-01,  1.963622e-01, -1.431437e-01, -1.354516e+00, -5.103167e-01},
  {-6.906168e-01, -7.213159e-01, -5.245785e-02, -1.680160e-01, -1.337326e+00, -5.697414e-01},
  {-6.197381e-01, -7.559738e-01,  2.107803e-01, -1.132175e-01, -1.374352e+00, -4.878731e-01},
  {-6.813932e-01, -6.902685e-01, -2.433778e-01, -1.979214e-01, -1.302374e+00, -6.058469e-01},
  { 7.465617e-01, -5.673503e-01, -3.475043e-01,  1.182686e-01, -1.323113e+00, -5.739937e-01},
  { 6.735071e-01, -5.459780e-01, -4.982934e-01,  1.029468e-01, -1.330915e+00, -5.922464e-01},
  {-6.194584e-01, -6.167829e-01, -4.856441e-01, -1.862801e-01, -1.275875e+00, -6.694739e-01},
  { 7.914560e-01, -9.954488e-02, -6.030657e-01,  1.192090e-01, -1.243217e+00, -6.670229e-01},
  { 3.099972e-01, -5.116736e-01, -8.013063e-01,  5.678587e-02, -1.291499e+00, -7.015110e-01},
  { 5.631758e-01, -6.697153e-01, -4.840604e-01,  8.595722e-02, -1.300647e+00, -6.742313e-01},
  { 3.350067e-01, -4.678212e-01, -8.178716e-01,  6.404588e-02, -1.292590e+00, -6.981996e-01},
  { 7.167833e-01, -1.012354e-01, -6.899081e-01,  1.046797e-01, -1.267338e+00, -6.797768e-01},
  { 4.204193e-01, -6.982002e-01, -5.794516e-01,  8.088298e-02, -1.297650e+00, -6.836425e-01},
  { 9.331059e-02, -4.633612e-01, -8.812432e-01, -3.855554e-02, -1.298622e+00, -7.284220e-01},
  { 3.781677e-01, -6.305877e-01, -6.777525e-01,  7.436780e-02, -1.293370e+00, -6.922520e-01},
  { 3.269567e-01, -6.176805e-01, -7.152413e-01,  6.878857e-02, -1.291050e+00, -6.969499e-01},
  { 5.574299e-01, -5.063166e-01,  6.579631e-01,  1.329357e-01, -1.249979e+00, -1.331586e-01},
  { 5.710636e-01, -4.812803e-01,  6.650231e-01,  1.412811e-01, -1.251338e+00, -1.411264e-01},
  { 6.319404e-01, -5.196154e-01,  5.750228e-01,  1.597923e-01, -1.305249e+00, -1.980531e-01},
  {-8.163557e-01, -5.212764e-01,  2.486650e-01, -2.799884e-01, -1.123230e+00, -1.567855e-01},
  {-6.631963e-01, -6.678154e-01,  3.379249e-01, -2.771578e-01, -1.124531e+00, -1.527220e-01},
  {-5.783058e-01, -7.542790e-01,  3.108467e-01, -2.783079e-01, -1.126317e+00, -1.557874e-01},
  {-5.916299e-01, -7.717959e-01,  2.330352e-01, -2.773446e-01, -1.127078e+00, -1.588645e-01},
  { 9.528596e-01, -1.747818e-01,  2.480119e-01,  2.075672e-01, -1.274041e+00, -2.650422e-01},
  { 6.947649e-01, -5.308615e-01,  4.852708e-01,  1.745133e-01, -1.329786e+00, -2.394224e-01},
  {-7.480572e-01, -6.194859e-01,  2.380072e-01, -2.813488e-01, -1.127865e+00, -1.721106e-01},
  {-1.793409e-01, -8.051531e-01,  5.653010e-01, -7.488251e-03, -1.314513e+00, -1.862395e-01},
  { 9.981277e-01, -3.565672e-02, -4.969466e-02,  2.160288e-01, -1.230606e+00, -3.591706e-01},
  {-3.304015e-01, -7.957028e-01,  5.076337e-01, -9.295221e-02, -1.309751e+00, -2.387671e-01},
  { 9.838595e-01, -3.128537e-02, -1.761864e-01,  2.102137e-01, -1.198928e+00, -4.116708e-01},
  {-3.811826e-01, -8.897704e-01,  2.510146e-01, -3.413778e-02, -1.388303e+00, -3.577653e-01},
  {-6.270087e-01, -7.347134e-01,  2.589519e-01, -1.751038e-01, -1.277184e+00, -3.090658e-01},
  {-5.927668e-01, -7.797720e-01,  2.014522e-01, -1.209939e-01, -1.341098e+00, -3.768913e-01},
  { 9.345293e-01, -1.410546e-01, -3.267393e-01,  1.767066e-01, -1.178289e+00, -5.767644e-01},
  {-5.502244e-01, -7.956926e-01,  2.532318e-01, -8.445947e-02, -1.386949e+00, -4.570603e-01},
  {-7.011279e-01, -7.114876e-01, -4.695740e-02, -1.844133e-01, -1.321376e+00, -5.681200e-01},
  { 9.147361e-01, -1.233280e-01, -3.847701e-01,  1.655067e-01, -1.189098e+00, -6.017074e-01},
  { 9.048455e-01, -2.483981e-01, -3.457644e-01,  1.614106e-01, -1.224607e+00, -5.895838e-01},
  { 8.912945e-01, -3.424805e-01, -2.971551e-01,  1.535204e-01, -1.257219e+00, -5.794841e-01},
  { 8.453665e-01, -4.398725e-01, -3.030970e-01,  1.455569e-01, -1.280478e+00, -5.725138e-01},
  {-6.350061e-01, -6.907928e-01, -3.457927e-01, -2.072665e-01, -1.284666e+00, -6.269340e-01},
  { 2.464935e-01, -2.381446e-01, -9.394297e-01,  8.605089e-03, -1.267340e+00, -7.279866e-01},
  {-6.270692e-01, -4.998749e-01, -5.974188e-01, -1.990247e-01, -1.255350e+00, -6.743072e-01},
  { 8.352833e-01, -9.656960e-02, -5.412728e-01,  1.263045e-01, -1.223963e+00, -6.604130e-01},
  { 3.212528e-01, -2.987849e-01, -8.986234e-01,  2.778720e-02, -1.277790e+00, -7.189231e-01},
  { 2.500139e-01, -3.475487e-01, -9.037161e-01, -3.315479e-02, -1.295303e+00, -7.297831e-01},
  {-3.567181e-01, -6.134349e-01, -7.045920e-01, -1.012714e-01, -1.299778e+00, -7.151016e-01},
  {-3.438264e-01, -4.632542e-01, -8.168103e-01, -1.241053e-01, -1.272672e+00, -7.233527e-01},
  {-4.440532e-01, -3.594154e-01, -8.207542e-01, -1.431572e-01, -1.248342e+00, -7.253479e-01},
  {-2.595971e-01, -4.923798e-01, -8.307655e-01, -8.440661e-02, -1.296053e+00, -7.246719e-01},
  { 6.068215e-01, -4.120158e-01, -6.797137e-01,  9.041014e-02, -1.282991e+00, -6.884168e-01},
  { 3.285321e-02, -5.494788e-01, -8.348616e-01, -5.179319e-02, -1.306502e+00, -7.259145e-01},
  { 1.939963e-01, -9.807677e-01,  2.144885e-02,  1.402936e-01, -1.123836e+00,  1.434512e-01},
  { 4.762596e-01, -8.791140e-01, -1.831143e-02,  1.574654e-01, -1.116440e+00,  1.177402e-01},
  { 2.494272e-01, -9.516073e-01,  1.795255e-01,  7.936217e-02, -1.155162e+00,  7.357622e-02},
  { 5.927382e-01, -4.859113e-01,  6.423019e-01,  1.395853e-01, -1.240362e+00, -1.312598e-01},
  { 1.238616e-01, -7.172852e-01,  6.856824e-01,  6.112545e-02, -1.282530e+00, -1.326437e-01},
  { 1.964182e-01, -8.530340e-01,  4.834799e-01,  3.926441e-02, -1.251391e+00, -9.029501e-02},
  { 6.582167e-01, -5.273676e-01,  5.372469e-01,  1.686449e-01, -1.322214e+00, -2.235402e-01},
  { 9.184496e-01, -2.021003e-01,  3.400085e-01,  2.002228e-01, -1.279463e+00, -2.461347e-01},
  {-3.700665e-01, -8.004540e-01,  4.715127e-01, -5.238363e-02, -1.312892e+00, -2.112294e-01},
  {-7.208436e-01, -6.631703e-01,  2.014687e-01, -2.739562e-01, -1.143447e+00, -1.915958e-01},
  { 9.978212e-01, -5.622401e-02,  3.452088e-02,  2.145478e-01, -1.252471e+00, -3.117516e-01},
  { 9.926456e-01,  4.252560e-03, -1.209822e-01,  2.114022e-01, -1.184972e+00, -4.060409e-01},
  { 9.629103e-01, -1.170735e-01, -2.431001e-01,  1.871198e-01, -1.166461e+00, -5.486332e-01},
  { 9.488994e-01, -1.922043e-01, -2.502945e-01,  1.820264e-01, -1.185208e+00, -5.558103e-01},
  { 9.116504e-01, -3.356631e-01, -2.371158e-01,  1.678818e-01, -1.261325e+00, -5.285237e-01},
  {-6.714700e-01, -7.379130e-01,  6.791508e-02, -1.667940e-01, -1.336678e+00, -5.294514e-01},
  { 9.235970e-01, -2.642213e-01, -2.777693e-01,  1.721792e-01, -1.221577e+00, -5.586688e-01},
  {-6.960304e-01, -7.002051e-01, -1.589161e-01, -2.095856e-01, -1.293039e+00, -5.963105e-01},
  {-6.737899e-01, -6.371129e-01, -3.742916e-01, -2.164319e-01, -1.278133e+00, -6.231038e-01},
  { 8.124232e-01, -5.862472e-02, -5.801135e-01,  1.389004e-01, -1.192605e+00, -6.472893e-01},
  { 1.825717e-01, -2.200978e-01, -9.582403e-01, -6.982009e-03, -1.260805e+00, -7.326834e-01},
  { 3.628276e-01, -2.726955e-01, -8.910630e-01,  5.784178e-02, -1.266794e+00, -7.109607e-01},
  { 3.605452e-01, -1.984664e-01, -9.113826e-01,  4.582164e-02, -1.258144e+00, -7.177510e-01},
  {-4.879489e-01, -5.382420e-01, -6.871691e-01, -1.373079e-01, -1.279012e+00, -7.099121e-01},
  {-5.378465e-01, -4.611818e-01, -7.057141e-01, -1.567844e-01, -1.255032e+00, -7.131918e-01},
  { 1.542252e-01, -2.455782e-01, -9.570297e-01, -3.909541e-02, -1.286823e+00, -7.331668e-01},
  {-3.399322e-01, -5.327320e-01, -7.750114e-01, -1.168596e-01, -1.285994e+00, -7.175984e-01},
  { 5.103312e-01, -1.739200e-01, -8.422077e-01,  7.942674e-02, -1.263558e+00, -7.016421e-01},
  { 6.439270e-01, -1.558481e-01, -7.490457e-01,  9.525375e-02, -1.265489e+00, -6.896083e-01},
  { 4.298630e-01, -3.666911e-01, -8.250790e-01,  7.814312e-02, -1.283749e+00, -6.961873e-01},
  {-3.163991e-01, -3.699952e-01, -8.734959e-01, -1.261411e-01, -1.259435e+00, -7.289879e-01},
  {-2.614624e-01, -3.830490e-01, -8.859519e-01, -9.599867e-02, -1.275731e+00, -7.318985e-01},
  {-1.145787e-01, -4.578139e-01, -8.816338e-01, -5.745496e-02, -1.299712e+00, -7.291483e-01},
  { 5.422852e-01, -8.398393e-01,  2.442921e-02,  1.660662e-01, -1.109719e+00,  9.906576e-02},
  { 8.234949e-01, -4.871134e-01,  2.908208e-01,  1.647030e-01, -1.273689e+00, -1.782766e-01},
  { 7.778797e-01, -4.569488e-01,  4.313942e-01,  1.656879e-01, -1.271969e+00, -1.773992e-01},
  { 5.872958e-01, -4.649983e-01,  6.624652e-01,  1.430512e-01, -1.225729e+00, -1.236370e-01},
  { 6.316893e-01, -4.089965e-01,  6.585518e-01,  1.451136e-01, -1.218202e+00, -1.203837e-01},
  { 6.087474e-01, -4.559051e-01,  6.492897e-01,  1.379553e-01, -1.211123e+00, -1.082944e-01},
  { 1.054085e-01, -7.998465e-01,  5.908762e-01,  1.601197e-02, -1.239578e+00, -6.675442e-02},
  { 1.119457e-01, -6.297356e-01,  7.687010e-01,  4.784277e-02, -1.283044e+00, -1.319547e-01},
  { 2.308507e-02, -7.667578e-01,  6.415212e-01,  4.079540e-02, -1.284918e+00, -1.320043e-01},
  { 9.112076e-01, -1.938486e-01,  3.634879e-01,  1.997350e-01, -1.268049e+00, -2.375549e-01},
  { 8.515406e-01, -3.052115e-01,  4.262917e-01,  1.923825e-01, -1.281626e+00, -2.302569e-01},
  {-7.833731e-01, -5.951402e-01,  1.792618e-01, -2.943858e-01, -1.120969e+00, -2.019362e-01},
  { 9.762272e-01, -8.249456e-02,  2.004372e-01,  2.120132e-01, -1.256998e+00, -2.764364e-01},
  { 9.955649e-01, -6.154361e-03, -9.387621e-02,  2.156351e-01, -1.198762e+00, -3.693972e-01},
  {-1.635267e-01, -7.879335e-01,  5.936496e-01, -9.924489e-02, -1.293378e+00, -2.194709e-01},
  {-5.686644e-01, -7.547739e-01,  3.270122e-01, -1.639547e-01, -1.272519e+00, -2.702858e-01},
  { 9.143606e-01, -2.176228e-02, -4.043157e-01,  1.716120e-01, -1.146889e+00, -5.938014e-01},
  { 8.294804e-01, -4.969753e-02, -5.563204e-01,  1.481479e-01, -1.168509e+00, -6.362305e-01},
  {-7.114794e-01, -5.522192e-01, -4.345701e-01, -2.294752e-01, -1.246060e+00, -6.470730e-01},
  { 7.128792e-01, -2.925179e-02, -7.006766e-01,  1.111838e-01, -1.209187e+00, -6.800905e-01},
  { 7.320808e-01, -1.200537e-02, -6.811121e-01,  1.166084e-01, -1.198416e+00, -6.747927e-01},
  {-6.050782e-01, -3.922760e-01, -6.928203e-01, -1.979640e-01, -1.227681e+00, -6.942654e-01},
  { 4.488919e-01, -8.527996e-02, -8.895074e-01,  7.089961e-02, -1.244415e+00, -7.083381e-01},
  { 1.466477e-01, -1.803933e-01, -9.726010e-01, -4.482541e-02, -1.275059e+00, -7.361385e-01},
  { 3.069393e-02, -1.440516e-01, -9.890940e-01, -6.948508e-02, -1.255695e+00, -7.409225e-01},
  {-5.738335e-01, -3.983568e-01, -7.155606e-01, -1.740131e-01, -1.238250e+00, -7.090926e-01},
  { 6.613929e-01, -6.393798e-02, -7.473094e-01,  1.011026e-01, -1.235085e+00, -6.886637e-01},
  {-1.710813e-01, -2.905868e-01, -9.414300e-01, -7.964686e-02, -1.271501e+00, -7.371047e-01},
  {-1.081833e-01, -2.846531e-01, -9.525067e-01, -7.160203e-02, -1.278371e+00, -7.364685e-01},
  {-3.735730e-01, -2.762288e-01, -8.855174e-01, -1.423663e-01, -1.231237e+00, -7.316991e-01},
  {-4.986213e-01, -3.330571e-01, -8.002810e-01, -1.704943e-01, -1.217939e+00, -7.225139e-01},
  {-8.379208e-02, -3.659423e-01, -9.268577e-01, -6.540027e-02, -1.288229e+00, -7.338722e-01},
  { 3.491781e-01, -9.114617e-01,  2.175141e-01,  1.689986e-01, -1.106048e+00,  2.185127e-01},
  { 1.547463e-01, -9.628180e-01,  2.214385e-01,  1.472051e-01, -1.112479e+00,  2.122037e-01},
  { 6.474779e-01, -7.609626e-01,  4.132919e-02,  1.998190e-01, -1.089500e+00,  1.989380e-01},
  { 2.351843e-01, -9.719110e-01,  8.796901e-03,  1.383739e-01, -1.124994e+00,  1.051276e-01},
  { 3.162147e-01, -9.199160e-01, -2.318679e-01,  1.023033e-01, -1.141863e+00,  9.522826e-02},
  { 3.164976e-01, -9.459405e-01,  7.089360e-02,  8.830728e-02, -1.146473e+00,  9.747992e-02},
  { 7.363197e-01, -6.760321e-01, -2.853111e-02,  2.270413e-01, -1.062681e+00,  1.557527e-01},
  { 7.295402e-01, -6.750105e-01, -1.101447e-01,  2.192210e-01, -1.068457e+00,  1.348999e-01},
  { 6.273463e-01, -7.749818e-01,  7.641908e-02,  1.763631e-01, -1.102514e+00,  9.842665e-02},
  {-6.705031e-01, -5.915041e-01,  4.478262e-01, -2.887871e-01, -1.060145e+00, -3.806433e-02},
  { 5.816824e-01, -7.583869e-01,  2.940999e-01,  7.942790e-02, -1.185715e+00, -2.190208e-02},
  { 7.087142e-01, -3.662047e-01,  6.030078e-01,  1.655297e-01, -1.240747e+00, -1.592895e-01},
  { 6.409953e-01, -5.312017e-01,  5.540305e-01,  1.277265e-01, -1.195717e+00, -8.596496e-02},
  { 7.041810e-01, -3.398394e-01,  6.234087e-01,  1.393885e-01, -1.198569e+00, -1.009916e-01},
  { 7.642246e-01, -3.377338e-01,  5.494511e-01,  1.576651e-01, -1.215018e+00, -1.323594e-01},
  { 7.327446e-02, -7.266989e-01,  6.830371e-01, -3.700884e-03, -1.225586e+00, -4.550162e-02},
  { 7.670320e-01, -4.069990e-01,  4.959978e-01,  1.773794e-01, -1.303090e+00, -2.190897e-01},
  { 9.995813e-01,  8.401868e-03,  2.768590e-02,  2.161312e-01, -1.217489e+00, -3.303097e-01},
  { 9.521026e-01, -3.312947e-02, -3.039787e-01,  1.912947e-01, -1.137411e+00, -5.428382e-01},
  { 9.621659e-01, -1.808891e-01, -2.037548e-01,  1.864163e-01, -1.212720e+00, -5.134706e-01},
  {-7.138454e-01, -6.997166e-01,  2.866017e-02, -2.061437e-01, -1.299364e+00, -5.509710e-01},
  {-7.396281e-01, -6.720717e-01, -3.563540e-02, -2.186626e-01, -1.285894e+00, -5.726823e-01},
  { 8.659986e-01, -5.610670e-03, -5.000150e-01,  1.604309e-01, -1.159688e+00, -6.166555e-01},
  { 7.706932e-01,  4.198383e-02, -6.358218e-01,  1.366704e-01, -1.146817e+00, -6.506056e-01},
  {-7.461953e-01, -6.285467e-01, -2.193663e-01, -2.281338e-01, -1.269605e+00, -6.127020e-01},
  { 8.813776e-01, -1.423658e-01, -4.504503e-01,  1.600884e-01, -1.189477e+00, -6.138804e-01},
  { 2.803408e-01, -1.381053e-01, -9.499137e-01,  1.358266e-02, -1.240481e+00, -7.318158e-01},
  { 1.592194e-01, -1.487118e-01, -9.759785e-01, -1.122392e-02, -1.243305e+00, -7.370514e-01},
  {-6.738448e-01, -4.669937e-01, -5.725819e-01, -2.301896e-01, -1.227456e+00, -6.627598e-01},
  {-6.354477e-01, -3.554240e-01, -6.854780e-01, -2.205521e-01, -1.204819e+00, -6.871263e-01},
  { 6.561439e-01, -3.416826e-02, -7.538619e-01,  9.998538e-02, -1.225157e+00, -6.904417e-01},
  { 5.991657e-01, -6.532351e-02, -7.979556e-01,  9.056830e-02, -1.240770e+00, -6.965512e-01},
  {-1.405475e-01, -2.018125e-01, -9.692874e-01, -9.919479e-02, -1.245852e+00, -7.397377e-01},
  {-2.869710e-01, -2.541099e-01, -9.236211e-01, -1.254538e-01, -1.236054e+00, -7.361658e-01},
  {-3.945913e-01, -1.934597e-01, -8.982600e-01, -1.584225e-01, -1.205035e+00, -7.326564e-01},
  {-5.573637e-01, -2.231101e-01, -7.997296e-01, -1.867617e-01, -1.196726e+00, -7.189451e-01},
  {-5.527684e-01, -2.620317e-01, -7.910667e-01, -1.756582e-01, -1.203565e+00, -7.244244e-01},
  { 2.637154e-01, -8.895538e-01,  3.730258e-01,  1.695666e-01, -1.101068e+00,  2.315331e-01},
  { 1.511860e-01, -9.097348e-01,  3.866851e-01,  1.457870e-01, -1.108268e+00,  2.261827e-01},
  { 1.285676e-01, -9.727601e-01,  1.928940e-01,  1.335684e-01, -1.118727e+00,  1.902317e-01},
  { 2.845694e-01, -9.328067e-01,  2.211151e-01,  1.663041e-01, -1.110093e+00,  2.009939e-01},
  { 9.889220e-02, -9.876372e-01,  1.216270e-01,  1.577424e-01, -1.113509e+00,  1.928919e-01},
  { 1.583516e-01, -9.792545e-01,  1.264334e-01,  1.621623e-01, -1.113665e+00,  1.944789e-01},
  { 1.243280e-01, -9.785318e-01,  1.643721e-01,  1.399339e-01, -1.120345e+00,  1.742294e-01},
  { 3.406477e-01, -9.388599e-01,  5.001331e-02,  1.589938e-01, -1.116559e+00,  1.555015e-01},
  { 3.944952e-01, -9.162951e-01,  6.911574e-02,  1.085269e-01, -1.135666e+00,  1.150007e-01},
  { 6.946148e-01, -7.065418e-01,  1.353103e-01,  2.048394e-01, -1.083437e+00,  2.096266e-01},
  { 3.834615e-01, -9.174080e-01,  1.063950e-01,  9.093902e-02, -1.156528e+00,  3.743251e-02},
  { 6.454527e-01, -7.637454e-01,  9.151364e-03,  1.836878e-01, -1.096317e+00,  9.930058e-02},
  { 4.890671e-01, -8.127637e-01,  3.165888e-01,  9.631503e-02, -1.170615e+00, -1.383013e-02},
  { 3.406491e-02, -8.879338e-01,  4.587081e-01,  5.317226e-03, -1.200641e+00, -4.196552e-03},
  { 8.690504e-01, -2.798888e-01,  4.079383e-01,  1.705368e-01, -1.260245e+00, -1.778701e-01},
  { 3.295621e-02, -8.644418e-01,  5.016516e-01,  2.958415e-03, -1.209334e+00, -1.949107e-02},
  { 7.564423e-01, -3.956101e-01,  5.208528e-01,  1.777944e-01, -1.284027e+00, -2.057992e-01},
  { 7.791009e-01, -2.081667e-01,  5.913278e-01,  1.624628e-01, -1.199327e+00, -1.309994e-01},
  {-6.747283e-01, -6.793239e-01,  2.885496e-01, -2.553928e-01, -1.153008e+00, -1.664531e-01},
  { 9.826490e-01, -5.509526e-02, -1.771031e-01,  1.997986e-01, -1.135076e+00, -5.020044e-01},
  { 9.759572e-01, -1.443032e-01, -1.633528e-01,  1.952026e-01, -1.161423e+00, -5.134616e-01},
  { 9.902792e-01, -5.874933e-02, -1.260778e-01,  2.073707e-01, -1.122579e+00, -4.502546e-01},
  { 9.968048e-01,  4.434948e-02, -6.643330e-02,  2.095664e-01, -1.097957e+00, -4.257750e-01},
  { 9.677702e-01,  1.465076e-02, -2.514086e-01,  1.934313e-01, -1.116998e+00, -5.350316e-01},
  { 8.529828e-01,  1.028649e-01, -5.117022e-01,  1.595060e-01, -1.115220e+00, -6.169706e-01},
  { 8.056983e-01,  5.152246e-02, -5.900812e-01,  1.482262e-01, -1.100029e+00, -6.322342e-01},
  {-7.601192e-01, -6.496544e-01, -1.295728e-02, -2.374460e-01, -1.264633e+00, -5.653684e-01},
  {-7.589067e-01, -6.226238e-01, -1.907881e-01, -2.344288e-01, -1.264181e+00, -6.054725e-01},
  { 7.069297e-01,  3.525164e-02, -7.064048e-01,  1.149814e-01, -1.174112e+00, -6.759279e-01},
  { 5.141369e-01, -2.233351e-02, -8.574173e-01,  7.393000e-02, -1.223400e+00, -7.077938e-01},
  {-2.678578e-02, -1.007287e-01, -9.945532e-01, -8.442362e-02, -1.215640e+00, -7.453600e-01},
  {-7.059612e-01, -4.857726e-01, -5.154064e-01, -2.480488e-01, -1.212977e+00, -6.539351e-01},
  {-1.885550e-01, -1.539901e-01, -9.699144e-01, -1.224466e-01, -1.211287e+00, -7.423326e-01},
  { 4.791254e-01, -8.271143e-01,  2.938043e-01,  1.825876e-01, -1.097803e+00,  2.253417e-01},
  { 5.505795e-01, -8.263063e-01,  1.186592e-01,  1.834762e-01, -1.101479e+00,  2.034476e-01},
  { 5.010118e-01, -8.639753e-01,  5.033685e-02,  1.804627e-01, -1.103484e+00,  1.997595e-01},
  { 4.309269e-01, -9.023241e-01,  1.063622e-02,  1.686340e-01, -1.110252e+00,  1.871916e-01},
  { 1.326410e-01, -9.534115e-01,  2.709482e-01,  6.822054e-02, -1.144645e+00,  1.212003e-01},
  {-5.015866e-01, -8.556333e-01,  1.276815e-01, -2.901615e-01, -1.013184e+00,  8.767851e-02},
  { 6.235973e-01, -7.817346e-01,  4.156451e-03,  1.993279e-01, -1.090418e+00,  1.805817e-01},
  { 4.662111e-01, -8.841136e-01, -3.147241e-02,  1.659127e-01, -1.113193e+00,  1.563965e-01},
  { 4.501560e-01, -8.910813e-01, -5.773796e-02,  1.407879e-01, -1.124201e+00,  8.653957e-02},
  { 1.539468e-01, -9.469458e-01,  2.821242e-01,  6.570665e-02, -1.151151e+00,  1.049460e-01},
  { 8.074090e-01, -5.888014e-01, -3.746218e-02,  2.376028e-01, -1.049115e+00,  1.502703e-01},
  { 6.653371e-01, -7.444382e-01, -5.602131e-02,  1.975768e-01, -1.089685e+00,  1.405526e-01},
  { 3.753657e-01, -9.070494e-01, -1.906881e-01,  1.047277e-01, -1.150389e+00,  3.237140e-02},
  { 1.380420e-01, -9.557500e-01,  2.597812e-01,  4.607802e-02, -1.161746e+00,  6.959561e-02},
  {-6.834264e-01, -6.025650e-01,  4.121210e-01, -3.019434e-01, -1.045540e+00, -3.886915e-02},
  { 5.176100e-01, -8.009956e-01,  3.008088e-01,  1.014130e-01, -1.170407e+00, -1.797100e-02},
  { 5.190672e-01, -8.065810e-01,  2.828362e-01,  1.020001e-01, -1.170431e+00, -2.212167e-02},
  { 6.462154e-01, -6.884240e-01,  3.293602e-01,  1.059251e-01, -1.165183e+00, -1.808327e-02},
  { 7.014837e-01, -6.580625e-01,  2.736318e-01,  1.180335e-01, -1.171448e+00, -4.923453e-02},
  { 2.449618e-02, -7.797558e-01,  6.256045e-01, -1.502670e-02, -1.223900e+00, -4.288200e-02},
  { 9.167119e-01, -1.362941e-01,  3.755837e-01,  1.942955e-01, -1.252418e+00, -2.180174e-01},
  {-9.138972e-02, -8.563192e-01,  5.082965e-01, -2.524898e-02, -1.234423e+00, -6.163431e-02},
  { 9.592446e-01, -4.931815e-02,  2.782398e-01,  2.055015e-01, -1.242779e+00, -2.451190e-01},
  { 9.983761e-01,  5.679095e-02,  4.461143e-03,  2.155429e-01, -1.180281e+00, -3.570274e-01},
  { 9.938874e-01,  1.300255e-02,  1.096305e-01,  2.131426e-01, -1.227865e+00, -2.834545e-01},
  {-4.503956e-01, -7.889723e-01,  4.179312e-01, -1.216685e-01, -1.272280e+00, -2.055715e-01},
  {-5.095580e-01, -7.927170e-01,  3.345897e-01, -1.493993e-01, -1.266367e+00, -2.304067e-01},
  {-6.228454e-01, -7.295993e-01,  2.823977e-01, -1.896785e-01, -1.246158e+00, -2.590665e-01},
  {-6.793283e-01, -7.121797e-01,  1.769551e-01, -2.251708e-01, -1.240650e+00, -3.372955e-01},
  {-6.939918e-01, -6.862789e-01,  2.177078e-01, -2.359142e-01, -1.225491e+00, -3.178344e-01},
  { 9.084329e-01,  1.046517e-01, -4.047194e-01,  1.818913e-01, -1.092190e+00, -5.684668e-01},
  { 8.858457e-01,  1.197161e-01, -4.482694e-01,  1.709711e-01, -1.106476e+00, -5.947912e-01},
  { 7.728237e-01,  1.024872e-01, -6.262906e-01,  1.486872e-01, -1.082732e+00, -6.296260e-01},
  { 7.126979e-01,  1.071781e-01, -6.932349e-01,  1.368910e-01, -1.093033e+00, -6.447021e-01},
  {-7.726456e-01, -6.223193e-01, -1.254491e-01, -2.458641e-01, -1.252238e+00, -5.937034e-01},
  {-7.344140e-01, -5.686222e-01, -3.705469e-01, -2.447809e-01, -1.239485e+00, -6.301813e-01},
  { 5.803835e-01,  4.218901e-02, -8.132497e-01,  8.982965e-02, -1.189762e+00, -6.982552e-01},
  { 1.789559e-01, -7.739780e-02, -9.808080e-01, -6.003174e-03, -1.207331e+00, -7.397782e-01},
  { 3.628809e-01,  5.569592e-02, -9.301695e-01,  1.139312e-02, -1.160238e+00, -7.356126e-01},
  { 6.037140e-02, -9.417514e-01,  3.308470e-01,  1.245572e-01, -1.107906e+00,  2.319554e-01},
  { 6.381457e-01, -7.376086e-01,  2.206887e-01,  1.974370e-01, -1.086918e+00,  2.240047e-01},
  {-5.103000e-01, -8.392302e-01,  1.878474e-01, -2.871960e-01, -1.014112e+00,  9.379280e-02},
  { 5.441928e-01, -8.358121e-01, -7.261086e-02,  1.848728e-01, -1.099687e+00,  1.344858e-01},
  { 5.510385e-01, -8.333169e-01,  4.403873e-02,  1.214298e-01, -1.141041e+00,  2.456709e-02},
  { 8.357177e-01, -5.344923e-01, -1.260711e-01,  2.406213e-01, -1.039102e+00,  1.253476e-01},
  { 1.627025e-01, -9.024724e-01,  3.988377e-01,  3.285277e-02, -1.170649e+00,  5.006505e-02},
  {-7.673080e-01, -5.882435e-01,  2.553588e-01, -3.168951e-01, -1.037409e+00, -6.187822e-02},
  {-6.395505e-01, -6.608119e-01,  3.928140e-01, -2.670172e-01, -1.081212e+00, -3.563723e-02},
  { 8.704356e-01, -2.099670e-01,  4.452593e-01,  1.772972e-01, -1.224197e+00, -1.700605e-01},
  { 9.194610e-01, -1.201405e-01,  3.743763e-01,  1.901425e-01, -1.220455e+00, -1.972558e-01},
  { 8.891276e-01, -1.211039e-01,  4.413457e-01,  1.701325e-01, -1.195153e+00, -1.432258e-01},
  { 9.391012e-01, -5.829480e-02,  3.386600e-01,  1.906976e-01, -1.205466e+00, -1.957040e-01},
  {-6.496090e-01, -7.400368e-01,  1.742228e-01, -1.677817e-01, -1.314403e+00, -4.263528e-01},
  { 7.613176e-01,  1.277134e-01, -6.356767e-01,  1.478184e-01, -1.075692e+00, -6.295068e-01},
  {-8.281221e-01, -5.581162e-01, -5.215481e-02, -3.401560e-01, -1.138063e+00, -5.096078e-01},
  {-8.701603e-01, -4.860526e-01, -8.107883e-02, -3.569527e-01, -1.110207e+00, -5.148562e-01},
  {-7.762243e-01, -6.304561e-01, -8.671116e-04, -2.572616e-01, -1.240466e+00, -5.642810e-01},
  {-7.922016e-01, -6.064977e-01, -6.765535e-02, -2.611383e-01, -1.235680e+00, -5.613633e-01},
  { 6.640291e-01,  1.071885e-01, -7.399838e-01,  1.119136e-01, -1.136579e+00, -6.749552e-01},
  { 4.765316e-01,  5.772384e-02, -8.772603e-01,  6.310601e-02, -1.204111e+00, -7.138708e-01},
  { 4.080506e-01, -2.717756e-04, -9.129593e-01,  3.680280e-02, -1.208034e+00, -7.262617e-01},
  { 3.093158e-01, -1.730633e-02, -9.508019e-01,  2.054696e-02, -1.190894e+00, -7.331475e-01},
  {-5.909423e-01, -3.352722e-01, -7.337436e-01, -2.512238e-01, -1.143514e+00, -6.890103e-01},
  {-2.408834e-01, -1.373197e-01, -9.607906e-01, -1.432930e-01, -1.183757e+00, -7.417589e-01},
  { 1.053232e-01,  5.972313e-03, -9.944201e-01, -4.568915e-02, -1.139020e+00, -7.469796e-01},
  {-3.331676e-01, -2.013825e-01, -9.211104e-01, -1.781415e-01, -1.153955e+00, -7.358500e-01},
  {-1.357547e-01, -5.279186e-02, -9.893349e-01, -1.349371e-01, -1.126904e+00, -7.470824e-01},
  { 1.089892e-01,  2.089706e-02, -9.938233e-01, -5.459870e-02, -1.107681e+00, -7.476180e-01},
  {-5.503958e-03, -1.473472e-02, -9.998763e-01, -9.833808e-02, -1.121502e+00, -7.497404e-01},
  {-9.772557e-03,  1.400168e-02, -9.998542e-01, -9.796699e-02, -1.102827e+00, -7.496229e-01},
  {-6.070644e-02, -7.137072e-01,  6.978085e-01,  9.170724e-02, -1.043174e+00,  3.551711e-01},
  {-1.080787e-01, -6.889446e-01,  7.167107e-01,  9.329337e-02, -1.034069e+00,  3.654340e-01},
  {-1.969704e-01, -7.446414e-01,  6.377397e-01,  8.863744e-02, -1.042859e+00,  3.547229e-01},
  {-2.191477e-01, -6.219482e-01,  7.517678e-01,  5.208835e-02, -1.002473e+00,  3.824113e-01},
  { 5.114338e-03, -9.546871e-01,  2.975675e-01,  9.797169e-02, -1.112058e+00,  2.241365e-01},
  { 5.657572e-01, -7.437608e-01,  3.560036e-01,  1.924706e-01, -1.084553e+00,  2.400484e-01},
  { 5.589986e-01, -8.291518e-01,  5.278955e-03,  1.784088e-01, -1.106310e+00,  1.685758e-01},
  { 4.338861e-02, -9.588131e-01,  2.807040e-01,  5.150121e-02, -1.144498e+00,  1.288718e-01},
  { 7.568293e-01, -6.443073e-01,  1.098975e-01,  2.318783e-01, -1.054514e+00,  2.042818e-01},
  { 7.111182e-01, -6.714437e-01,  2.085051e-01,  1.367878e-01, -1.156305e+00, -6.272152e-02},
  { 8.803640e-01, -1.872345e-01,  4.357779e-01,  1.758528e-01, -1.210983e+00, -1.610252e-01},
  { 9.218907e-01, -1.199633e-01,  3.684106e-01,  1.947513e-01, -1.231954e+00, -2.112127e-01},
  {-6.299568e-01, -7.233486e-01,  2.827034e-01, -2.445258e-01, -1.168053e+00, -1.788055e-01},
  {-7.038653e-01, -6.765117e-01,  2.165769e-01, -2.492758e-01, -1.184897e+00, -2.452132e-01},
  { 9.980898e-01,  6.072855e-02,  1.134403e-02,  2.104633e-01, -1.106757e+00, -3.708063e-01},
  {-6.532481e-01, -7.084615e-01,  2.671129e-01, -2.095212e-01, -1.225820e+00, -2.521207e-01},
  {-7.297299e-01, -6.444913e-01,  2.283099e-01, -2.627150e-01, -1.185465e+00, -2.907588e-01},
  { 8.648657e-01,  8.469118e-02, -4.948079e-01,  1.642509e-01, -1.075111e+00, -6.044289e-01},
  {-6.771069e-01, -7.247211e-01,  1.276937e-01, -2.072360e-01, -1.287271e+00, -4.629385e-01},
  { 6.549978e-01,  1.474348e-01, -7.411079e-01,  1.202781e-01, -1.059648e+00, -6.542671e-01},
  {-8.955665e-01, -4.446180e-01, -1.659826e-02, -3.253112e-01, -1.158450e+00, -5.093248e-01},
  {-8.771149e-01, -4.723175e-01, -8.709506e-02, -3.260919e-01, -1.154530e+00, -5.327081e-01},
  {-7.818763e-01, -5.943980e-01, -1.880437e-01, -2.525028e-01, -1.240617e+00, -6.074041e-01},
  {-7.945057e-01, -6.008875e-01, -8.772084e-02, -3.063931e-01, -1.179646e+00, -5.460748e-01},
  { 6.257138e-02, -9.965885e-02, -9.930524e-01, -4.959979e-02, -1.212627e+00, -7.446136e-01},
  {-7.216311e-01, -4.024663e-01, -5.632668e-01, -2.656659e-01, -1.186751e+00, -6.518438e-01},
  {-6.311598e-01, -3.203298e-01, -7.064178e-01, -2.605376e-01, -1.136705e+00, -6.842139e-01},
  { 1.872600e-01,  1.106333e-05, -9.823104e-01, -2.198409e-02, -1.164109e+00, -7.441196e-01},
  {-1.177292e-01, -6.166511e-02, -9.911293e-01, -1.182246e-01, -1.167770e+00, -7.465461e-01},
  { 3.300777e-01,  7.417651e-02, -9.410349e-01,  7.657585e-03, -1.137935e+00, -7.349311e-01},
  {-5.180129e-01, -2.815388e-01, -8.077119e-01, -2.016505e-01, -1.133942e+00, -7.293631e-01},
  {-1.677101e-01, -1.644875e-01, -9.720170e-01, -1.735211e-01, -1.125805e+00, -7.420078e-01},
  {-3.813402e-01, -1.770617e-01, -9.073195e-01, -1.896322e-01, -1.132607e+00, -7.362700e-01},
  {-1.369560e-01, -8.103394e-01,  5.697308e-01,  1.079457e-01, -1.052849e+00,  3.448668e-01},
  { 9.681001e-02, -8.758581e-01,  4.727582e-01,  1.224948e-01, -1.069867e+00,  3.177710e-01},
  { 1.009438e-01, -8.966214e-01,  4.311385e-01,  1.209934e-01, -1.075628e+00,  3.066150e-01},
  { 3.682524e-02, -9.491576e-01,  3.126402e-01,  5.941523e-02, -1.133875e+00,  1.616306e-01},
  { 6.387826e-01, -7.590914e-01, -1.254472e-01,  1.701429e-01, -1.102094e+00,  4.441393e-02},
  {-7.420955e-01, -6.213415e-01,  2.514540e-01, -3.174399e-01, -1.011783e+00, -2.144634e-03},
  { 7.887453e-01, -6.019276e-01, -1.247559e-01,  2.252541e-01, -1.051492e+00,  8.287128e-02},
  { 6.859542e-01, -6.984873e-01, -2.039175e-01,  1.811359e-01, -1.091900e+00,  4.576070e-02},
  { 7.240462e-01, -6.350159e-01, -2.692803e-01,  2.062368e-01, -1.065524e+00,  4.651695e-02},
  { 8.074404e-01, -5.811965e-01,  1.012453e-01,  1.361094e-01, -1.140792e+00, -3.296475e-02},
  {-1.521282e-02, -8.946993e-01,  4.464098e-01, -3.019244e-02, -1.187607e+00,  2.299881e-02},
  {-1.491811e-01, -9.002770e-01,  4.089578e-01, -3.335724e-02, -1.195574e+00,  6.287778e-03},
  {-7.785518e-01, -5.950286e-01,  1.994942e-01, -3.428563e-01, -1.027441e+00, -1.178113e-01},
  { 8.011376e-01, -4.810956e-01,  3.559855e-01,  1.602005e-01, -1.136027e+00, -9.552611e-02},
  {-1.616798e-01, -8.601097e-01,  4.838089e-01, -4.435693e-02, -1.212458e+00, -2.959751e-02},
  { 9.453545e-01, -2.357637e-01,  2.252117e-01,  1.677960e-01, -1.137213e+00, -1.173940e-01},
  {-7.990010e-01, -5.781713e-01,  1.652735e-01, -3.191370e-01, -1.101128e+00, -2.509601e-01},
  { 9.924344e-01,  6.544790e-02,  1.038768e-01,  2.101074e-01, -1.161781e+00, -2.956017e-01},
  { 9.968563e-01,  7.857864e-02,  1.013878e-02,  2.066212e-01, -1.042598e+00, -3.966723e-01},
  { 9.831600e-01,  2.322485e-02, -1.812651e-01,  2.007052e-01, -1.073727e+00, -4.975106e-01},
  { 9.486296e-01,  5.712495e-02, -3.111891e-01,  1.861250e-01, -1.054870e+00, -5.516610e-01},
  { 7.890435e-01,  1.527400e-01, -5.950469e-01,  1.490967e-01, -1.052764e+00, -6.226053e-01},
  {-8.978966e-01, -4.354052e-01, -6.483835e-02, -3.758256e-01, -1.075118e+00, -5.014069e-01},
  {-7.581148e-01, -6.520942e-01, -5.915676e-03, -2.750110e-01, -1.219705e+00, -5.292066e-01},
  {-8.023174e-01, -5.946473e-01, -5.178255e-02, -3.569489e-01, -1.104769e+00, -5.348874e-01},
  { 6.036276e-01,  1.398923e-01, -7.848974e-01,  9.569167e-02, -1.112014e+00, -6.845986e-01},
  { 6.127235e-01,  8.364329e-02, -7.858586e-01,  9.069256e-02, -1.155218e+00, -6.957504e-01},
  {-7.875555e-01, -5.517259e-01, -2.745084e-01, -2.627932e-01, -1.220920e+00, -6.198543e-01},
  { 4.851957e-01,  4.918071e-02, -8.730214e-01,  7.881795e-02, -1.168771e+00, -7.050430e-01},
  { 5.922242e-02, -4.284808e-02, -9.973248e-01, -5.466648e-02, -1.183827e+00, -7.469978e-01},
  {-6.490279e-01, -2.927011e-01, -7.022029e-01, -2.667856e-01, -1.125968e+00, -6.830773e-01},
  {-5.725125e-01, -2.228158e-01, -7.890390e-01, -2.429696e-01, -1.116141e+00, -7.057256e-01},
  { 1.121279e-01,  4.254277e-02, -9.927827e-01, -6.203028e-02, -1.080005e+00, -7.475684e-01},
  { 2.120762e-01,  5.539169e-02, -9.756820e-01, -2.392031e-02, -1.112779e+00, -7.425095e-01},
  {-9.168022e-02, -4.116623e-02, -9.949372e-01, -1.548733e-01, -1.087881e+00, -7.457920e-01},
  {-4.607815e-01, -1.923994e-01, -8.664080e-01, -2.014429e-01, -1.122208e+00, -7.327112e-01},
  { 1.148717e-01, -8.065774e-01,  5.798597e-01,  1.221848e-01, -1.056370e+00,  3.401940e-01},
  { 1.292356e-01, -8.483299e-01,  5.134536e-01,  1.244939e-01, -1.063974e+00,  3.275520e-01},
  {-2.611336e-01, -6.039029e-01,  7.530674e-01,  2.643870e-02, -9.871416e-01,  3.862417e-01},
  {-1.083153e-01, -8.572307e-01,  5.034118e-01,  1.018099e-01, -1.068559e+00,  3.195480e-01},
  {-2.617216e-01, -6.867898e-01,  6.781014e-01,  4.493000e-02, -1.027075e+00,  3.549271e-01},
  { 4.746086e-02, -9.096528e-01,  4.126492e-01,  1.134303e-01, -1.084387e+00,  2.886754e-01},
  { 5.219411e-02, -9.175646e-01,  3.941459e-01,  1.173688e-01, -1.086550e+00,  2.829335e-01},
  { 2.469616e-03, -9.132887e-01,  4.073054e-01,  1.058721e-01, -1.096221e+00,  2.624861e-01},
  { 5.203195e-01, -7.277721e-01,  4.467834e-01,  1.981989e-01, -1.068747e+00,  2.618313e-01},
  {-7.336246e-01, -6.386954e-01,  2.320843e-01, -2.990035e-01, -1.000058e+00,  9.764295e-02},
  {-1.141205e-01, -9.108825e-01,  3.965722e-01,  6.270771e-02, -1.112192e+00,  2.228507e-01},
  {-5.567869e-02, -9.325478e-01,  3.567274e-01,  2.801471e-02, -1.133906e+00,  1.618967e-01},
  {-2.690213e-01, -8.385331e-01,  4.738036e-01, -5.425522e-02, -1.240976e+00, -8.503053e-02},
  {-5.936093e-01, -7.267194e-01,  3.456977e-01, -2.230084e-01, -1.159872e+00, -1.192970e-01},
  { 9.677144e-01, -2.288211e-03,  2.520385e-01,  2.025928e-01, -1.205136e+00, -2.350511e-01},
  {-6.316484e-01, -7.267248e-01,  2.699840e-01, -2.092782e-01, -1.216331e+00, -2.263952e-01},
  { 9.673461e-01,  6.535806e-02, -2.448872e-01,  1.937902e-01, -1.056133e+00, -5.253636e-01},
  {-6.824802e-01, -7.080297e-01,  1.814239e-01, -2.185717e-01, -1.272437e+00, -4.414567e-01},
  {-8.982636e-01, -4.382324e-01,  3.278490e-02, -3.724986e-01, -1.082979e+00, -4.658505e-01},
  { 9.121614e-01,  1.335906e-01, -3.874471e-01,  1.800622e-01, -1.032389e+00, -5.629485e-01},
  {-7.199922e-01, -6.889545e-01,  8.338403e-02, -2.237912e-01, -1.271569e+00, -4.606058e-01},
  {-8.594407e-01, -5.109994e-01,  1.552927e-02, -3.573589e-01, -1.112629e+00, -4.739488e-01},
  { 8.109076e-01,  1.293068e-01, -5.707089e-01,  1.560115e-01, -1.044408e+00, -6.107230e-01},
  {-8.417653e-01, -5.390761e-01,  2.877716e-02, -3.242125e-01, -1.160330e+00, -4.872187e-01},
  {-6.569369e-01, -7.533819e-01,  2.914685e-02, -3.543586e-01, -1.108112e+00, -5.447394e-01},
  {-8.128091e-01, -5.429942e-01, -2.109469e-01, -2.781331e-01, -1.204697e+00, -6.053621e-01},
  {-7.797193e-01, -5.277267e-01, -3.369605e-01, -2.723279e-01, -1.206639e+00, -6.211452e-01},
  {-7.819218e-01, -4.822116e-01, -3.950573e-01, -2.735890e-01, -1.198925e+00, -6.298251e-01},
  {-6.958080e-01, -3.740855e-01, -6.131161e-01, -2.765863e-01, -1.167436e+00, -6.510794e-01},
  {-6.575432e-01, -3.082228e-01, -6.874850e-01, -2.764156e-01, -1.118325e+00, -6.772603e-01},
  {-3.072731e-01, -2.243249e-02, -9.513569e-01, -1.914784e-01, -1.075849e+00, -7.393739e-01},
  { 3.041736e-01,  7.411930e-02, -9.497288e-01, -7.083539e-03, -1.098891e+00, -7.367706e-01},
  {-3.028459e-01, -4.125971e-02, -9.521460e-01, -1.927421e-01, -1.086301e+00, -7.386935e-01},
  {-4.327959e-01, -7.339841e-02, -8.984990e-01, -2.087832e-01, -1.090316e+00, -7.326669e-01},
  {-4.541115e-01, -8.624931e-02, -8.867603e-01, -2.072212e-01, -1.098389e+00, -7.325895e-01},
  {-3.386789e-01, -1.042272e-01, -9.351113e-01, -1.955922e-01, -1.116252e+00, -7.372369e-01},
  { 1.599932e-01, -7.291009e-01,  6.654428e-01,  1.269512e-01, -1.046950e+00,  3.505655e-01},
  { 1.227525e-01, -6.873881e-01,  7.158418e-01,  1.240208e-01, -1.030743e+00,  3.669139e-01},
  { 7.087952e-02, -6.709148e-01,  7.381392e-01,  1.118561e-01, -1.023015e+00,  3.746808e-01},
  { 2.798304e-01, -8.541657e-01,  4.382874e-01,  1.460329e-01, -1.069155e+00,  3.084042e-01},
  { 3.567787e-01, -8.041458e-01,  4.754560e-01,  1.541584e-01, -1.060932e+00,  3.170345e-01},
  {-1.596290e-01, -8.799696e-01,  4.474060e-01,  9.228975e-02, -1.081906e+00,  2.934661e-01},
  { 5.588032e-01, -7.203850e-01,  4.108339e-01,  1.792659e-01, -1.066587e+00,  2.831635e-01},
  {-6.353716e-01, -6.828066e-01,  3.606632e-01, -2.878960e-01, -1.004494e+00,  1.137019e-01},
  {-4.935063e-01, -8.052080e-01,  3.287728e-01, -2.720211e-01, -1.016472e+00,  1.134162e-01},
  { 6.938225e-01, -6.677795e-01,  2.695939e-01,  2.154875e-01, -1.059572e+00,  2.468320e-01},
  { 7.351809e-01, -6.388434e-01,  2.266897e-01,  2.349762e-01, -1.042613e+00,  2.352961e-01},
  {-7.360632e-02, -9.252343e-01,  3.721877e-01,  1.646182e-02, -1.137268e+00,  1.509027e-01},
  {-7.589580e-01, -6.344973e-01,  1.462728e-01, -3.240755e-01, -9.879999e-01,  4.203257e-02},
  {-7.181547e-02, -9.327274e-01,  3.533584e-01,  6.375073e-04, -1.145730e+00,  1.255491e-01},
  { 7.427488e-01, -6.688801e-01,  3.039215e-02,  1.584595e-01, -1.110529e+00, -5.596879e-03},
  { 8.141136e-01, -5.568047e-01, -1.648864e-01,  2.275984e-01, -1.043001e+00,  6.000531e-02},
  {-8.065222e-01, -5.542856e-01,  2.056440e-01, -3.548139e-01, -1.015718e+00, -1.296689e-01},
  { 9.525745e-01, -2.851403e-02,  3.029666e-01,  1.803006e-01, -1.151258e+00, -1.592880e-01},
  {-6.354637e-01, -7.227474e-01,  2.717025e-01, -2.290447e-01, -1.189349e+00, -1.998546e-01},
  {-7.843053e-01, -5.919684e-01,  1.855764e-01, -2.818740e-01, -1.177535e+00, -3.357247e-01},
  { 9.870273e-01,  1.125339e-01, -1.145128e-01,  2.033950e-01, -1.036697e+00, -4.506405e-01},
  { 9.820486e-01,  1.129593e-01, -1.510653e-01,  1.976778e-01, -1.049708e+00, -5.044672e-01},
  {-8.572823e-01, -5.032862e-01,  1.084903e-01, -3.626551e-01, -1.101229e+00, -4.567487e-01},
  { 9.872295e-01,  1.408567e-01, -7.441350e-02,  2.027233e-01, -1.014856e+00, -4.256057e-01},
  {-9.182830e-01, -3.943968e-01, -3.474729e-02, -3.875879e-01, -1.050587e+00, -4.861107e-01},
  {-8.986698e-01, -4.165139e-01, -1.375090e-01, -3.778772e-01, -1.064465e+00, -5.316781e-01},
  { 5.532050e-01,  1.295077e-01, -8.229167e-01,  7.739004e-02, -1.141831e+00, -7.031703e-01},
  { 2.639417e-01,  1.137699e-01, -9.578055e-01, -3.376303e-02, -1.041111e+00, -7.399868e-01},
  {-7.425471e-01, -4.979805e-01, -4.479278e-01, -2.916589e-01, -1.151549e+00, -6.422960e-01},
  {-7.103553e-01, -3.482037e-01, -6.116777e-01, -2.883140e-01, -1.139250e+00, -6.539575e-01},
  { 4.682509e-01,  1.074393e-01, -8.770393e-01,  6.005640e-02, -1.126838e+00, -7.105994e-01},
  { 3.747654e-01,  8.924952e-02, -9.228138e-01,  8.688863e-03, -1.086794e+00, -7.298878e-01},
  { 2.205106e-02,  2.156845e-01, -9.762141e-01, -7.322107e-02, -1.027565e+00, -7.456626e-01},
  {-1.772960e-01, -1.379590e-04, -9.841576e-01, -1.829035e-01, -1.038350e+00, -7.423421e-01},
  {-6.367505e-01, -3.044300e-01, -7.084287e-01, -2.794527e-01, -1.095911e+00, -6.846335e-01},
  {-4.211792e-01, -1.052051e-01, -9.008551e-01, -2.430972e-01, -1.049335e+00, -7.199182e-01},
  {-4.692979e-01, -1.191072e-01, -8.749704e-01, -2.286011e-01, -1.079964e+00, -7.233753e-01},
  {-7.132471e-02,  1.084561e-02, -9.973941e-01, -1.393788e-01, -1.048671e+00, -7.476137e-01},
  {-2.221615e-01,  3.742647e-01, -9.003167e-01, -9.450541e-02, -1.043732e+00, -7.482009e-01},
  {-4.820989e-01, -9.394058e-02, -8.710659e-01, -2.070459e-01, -1.107400e+00, -7.318991e-01},
  {-6.946697e-02,  1.138074e-01, -9.910712e-01, -1.081979e-01, -1.054048e+00, -7.484277e-01},
  {-3.595391e-01, -5.607483e-01,  7.458505e-01,  1.512804e-02, -9.725082e-01,  3.929558e-01},
  {-1.654245e-01, -6.594515e-01,  7.333202e-01,  9.593563e-02, -1.004345e+00,  3.898442e-01},
  { 2.838660e-01, -7.846829e-01,  5.510834e-01,  1.470494e-01, -1.053225e+00,  3.342882e-01},
  {-2.107938e-01, -8.040210e-01,  5.559822e-01,  5.712532e-02, -1.055302e+00,  3.248865e-01},
  { 4.693006e-01, -7.636266e-01,  4.434314e-01,  1.847412e-01, -1.049686e+00,  3.093514e-01},
  { 4.579133e-01, -7.922414e-01,  4.033225e-01,  1.859926e-01, -1.054297e+00,  2.993800e-01},
  {-1.097271e-01, -8.787482e-01,  4.645014e-01,  7.232787e-02, -1.084310e+00,  2.843297e-01},
  {-9.282978e-02, -9.033542e-01,  4.187286e-01,  6.714977e-02, -1.097484e+00,  2.567999e-01},
  {-1.014354e-01, -8.995811e-01,  4.248114e-01,  3.561117e-02, -1.126356e+00,  1.817549e-01},
  { 7.408307e-01, -6.701263e-01,  4.583089e-02,  2.538655e-01, -1.024048e+00,  2.153473e-01},
  { 5.970221e-01, -7.715958e-01, -2.195551e-01,  2.625056e-01, -1.012796e+00,  1.931398e-01},
  {-7.777157e-02, -9.333284e-01,  3.504992e-01, -1.397471e-02, -1.153595e+00,  1.017785e-01},
  { 8.217278e-01, -5.686991e-01,  3.667144e-02,  1.639903e-01, -1.104771e+00, -2.050475e-02},
  { 8.764149e-01, -4.512486e-01, -1.681417e-01,  2.387741e-01, -1.019740e+00,  4.583075e-02},
  {-7.313473e-01, -6.403034e-01,  2.348247e-01, -3.604241e-01, -9.732236e-01, -5.460037e-02},
  {-7.877048e-01, -5.703197e-01,  2.329303e-01, -3.647608e-01, -9.815110e-01, -8.840097e-02},
  { 9.268599e-01, -3.730258e-01, -4.222139e-02,  1.742541e-01, -1.110962e+00, -1.190628e-01},
  {-5.610174e-01, -7.571663e-01,  3.346023e-01, -1.750278e-01, -1.228198e+00, -1.874654e-01},
  {-8.923144e-01, -4.350470e-01,  1.204537e-01, -3.760266e-01, -1.066380e+00, -4.197945e-01},
  {-8.632603e-01, -4.866388e-01,  1.340313e-01, -3.656761e-01, -1.089192e+00, -4.302573e-01},
  {-9.197378e-01, -3.899689e-01,  4.479592e-02, -3.976108e-01, -1.026438e+00, -4.622556e-01},
  {-8.147310e-01, -5.736933e-01,  8.419941e-02, -3.393567e-01, -1.137407e+00, -4.567944e-01},
  { 7.343705e-01,  8.710010e-02, -6.731371e-01,  1.467061e-01, -1.029396e+00, -6.198797e-01},
  { 6.864939e-01,  1.427683e-01, -7.129819e-01,  1.176335e-01, -1.007450e+00, -6.458744e-01},
  {-7.445821e-01, -6.649716e-01,  5.839875e-02, -2.704594e-01, -1.223814e+00, -4.691419e-01},
  {-8.105227e-01, -5.559048e-01, -1.844526e-01, -3.145444e-01, -1.157614e+00, -5.877222e-01},
  { 5.433322e-01,  1.405980e-01, -8.276608e-01,  6.809685e-02, -1.088302e+00, -7.002386e-01},
  { 2.077083e-01,  1.448440e-01, -9.674076e-01, -5.612801e-02, -1.011487e+00, -7.414197e-01},
  {-2.533472e-01,  1.249484e-02, -9.672948e-01, -1.969544e-01, -1.015452e+00, -7.386620e-01},
  {-3.881303e-01, -6.030562e-02, -9.196293e-01, -2.375009e-01, -1.020893e+00, -7.246212e-01},
  {-6.365607e-01, -3.016421e-01, -7.097905e-01, -2.880054e-01, -1.085562e+00, -6.813514e-01},
  {-5.495260e-01, -2.352018e-01, -8.016865e-01, -2.663461e-01, -1.087319e+00, -6.983249e-01},
  {-2.494299e-01, -5.898823e-01,  7.679998e-01,  6.539523e-02, -9.674942e-01,  4.152840e-01},
  {-2.900322e-01, -6.309072e-01,  7.196092e-01,  5.894117e-02, -9.606703e-01,  4.175196e-01},
  {-3.538693e-01, -6.398379e-01,  6.821906e-01,  4.798069e-02, -9.516709e-01,  4.209287e-01},
  {-3.184689e-02, -5.940691e-01,  8.037833e-01,  9.171583e-02, -9.813091e-01,  4.083830e-01},
  { 1.292981e-01, -6.510949e-01,  7.479021e-01,  1.326480e-01, -1.010133e+00,  3.835818e-01},
  {-3.095260e-01, -5.664933e-01,  7.637271e-01,  2.973219e-03, -9.877397e-01,  3.756304e-01},
  { 6.981864e-01, -3.171327e-01,  6.418433e-01,  2.918594e-01, -8.954465e-01,  3.905871e-01},
  { 8.242302e-01, -4.729666e-01,  3.113635e-01,  2.973883e-01, -8.963423e-01,  3.808431e-01},
  {-5.606955e-01, -6.921041e-01,  4.545465e-01, -2.844717e-01, -9.977380e-01,  1.293955e-01},
  { 6.270383e-01, -6.909432e-01,  3.597505e-01,  2.186809e-01, -1.041435e+00,  2.768919e-01},
  { 8.209613e-01, -5.583028e-01, -1.196684e-01,  2.679206e-01, -1.000468e+00,  1.706351e-01},
  {-5.913031e-01, -7.405108e-01,  3.193814e-01, -2.365976e-01, -1.078109e+00,  4.001554e-02},
  {-3.925568e-01, -8.066348e-01,  4.418591e-01, -7.161399e-02, -1.184602e+00,  1.389939e-02},
  {-7.198361e-01, -6.754282e-01,  1.601022e-01, -2.571629e-01, -1.233007e+00, -4.369505e-01},
  {-7.751822e-01, -6.192333e-01,  1.250713e-01, -3.209337e-01, -1.160853e+00, -4.540872e-01},
  {-7.622871e-01, -6.379178e-01,  1.094499e-01, -2.905867e-01, -1.198660e+00, -4.574475e-01},
  { 6.160233e-01,  1.663260e-01, -7.699682e-01,  1.082069e-01, -9.863293e-01, -6.489684e-01},
  {-8.362050e-01, -4.988434e-01, -2.278518e-01, -3.341368e-01, -1.130338e+00, -5.806250e-01},
  {-7.855306e-01, -6.069791e-01, -1.204910e-01, -3.431305e-01, -1.116898e+00, -5.750293e-01},
  {-7.953606e-01, -4.640884e-01, -3.899020e-01, -3.036067e-01, -1.161719e+00, -6.130787e-01},
  {-7.459542e-01, -5.202155e-01, -4.158462e-01, -3.114455e-01, -1.142843e+00, -6.190063e-01},
  { 4.323398e-01,  9.141647e-02, -8.970649e-01,  4.830365e-02, -1.099440e+00, -7.135399e-01},
  {-2.859590e-01,  2.021833e-02, -9.580286e-01, -2.160064e-01, -1.001318e+00, -7.337431e-01},
  { 9.632844e-02,  1.054518e-01, -9.897478e-01, -9.397630e-02, -1.005222e+00, -7.460098e-01},
  {-5.246029e-01, -1.854726e-01, -8.308981e-01, -2.742782e-01, -1.059033e+00, -7.018485e-01},
  {-1.383857e-01, -6.772544e-01,  7.226173e-01,  1.019553e-01, -9.089508e-01,  4.795406e-01},
  {-2.653893e-01, -6.573575e-01,  7.053011e-01,  6.520073e-02, -9.131197e-01,  4.611951e-01},
  { 6.880822e-01, -4.945704e-01,  5.309832e-01,  2.504451e-01, -8.650826e-01,  4.753598e-01},
  { 5.546676e-01, -5.930333e-01,  5.836568e-01,  2.445945e-01, -8.709504e-01,  4.751976e-01},
  {-3.179984e-01, -6.209082e-01,  7.164845e-01,  4.826584e-02, -9.433529e-01,  4.291053e-01},
  { 6.875933e-01, -5.540949e-01,  4.692485e-01,  2.555435e-01, -8.710470e-01,  4.607468e-01},
  {-2.826168e-01, -5.820715e-01,  7.624438e-01,  3.703114e-02, -9.491949e-01,  4.187945e-01},
  {-3.809794e-01, -5.519298e-01,  7.417737e-01,  6.118609e-03, -9.548232e-01,  4.017440e-01},
  {-3.306947e-01, -6.556299e-01,  6.788155e-01, -1.947767e-05, -9.982737e-01,  3.649290e-01},
  { 3.758675e-01, -7.437992e-01,  5.527081e-01,  1.670293e-01, -1.035560e+00,  3.451600e-01},
  { 2.106392e-01, -6.706718e-01,  7.112176e-01,  1.498661e-01, -1.015213e+00,  3.750023e-01},
  { 1.234266e-01, -6.838793e-01,  7.190793e-01,  1.360057e-01, -1.001177e+00,  3.912657e-01},
  {-2.617192e-01, -7.751228e-01,  5.750546e-01,  3.184846e-02, -1.052703e+00,  3.178980e-01},
  { 7.610844e-01, -1.006573e-01,  6.407953e-01,  2.978025e-01, -8.910414e-01,  3.858000e-01},
  { 5.497109e-01, -6.365530e-01,  5.409420e-01,  2.891154e-01, -9.036216e-01,  3.850416e-01},
  {-6.024967e-01, -6.524059e-01,  4.597437e-01, -2.871414e-01, -9.847317e-01,  1.457805e-01},
  { 7.206029e-01, -6.435731e-01,  2.579634e-01,  2.413027e-01, -1.027163e+00,  2.566506e-01},
  {-1.846911e-01, -8.906032e-01,  4.155900e-01, -1.578714e-02, -1.132497e+00,  1.525078e-01},
  { 8.106272e-01, -5.807249e-01,  7.511320e-02,  2.676092e-01, -1.003547e+00,  2.327050e-01},
  {-6.556450e-01, -7.179424e-01,  2.338555e-01, -2.424944e-01, -1.065652e+00,  5.745301e-02},
  {-2.009770e-01, -9.076796e-01,  3.684099e-01, -3.114385e-02, -1.143881e+00,  1.196797e-01},
  {-8.105859e-01, -5.486079e-01,  2.048898e-01, -3.570887e-01, -9.595881e-01, -5.260921e-03},
  {-5.791426e-01, -7.443927e-01,  3.323753e-01, -2.229927e-01, -1.093967e+00,  2.775342e-02},
  {-2.733999e-01, -8.451900e-01,  4.592453e-01, -6.784754e-02, -1.177766e+00,  3.343055e-02},
  { 8.944018e-01, -3.848797e-01, -2.278443e-01,  2.569223e-01, -9.560187e-01, -3.777896e-03},
  {-3.449616e-01, -8.488286e-01,  4.006139e-01, -9.749830e-02, -1.204571e+00, -4.850627e-02},
  {-8.126427e-01, -5.690380e-01,  1.257277e-01, -3.649047e-01, -1.013021e+00, -1.770198e-01},
  { 9.244424e-01, -3.652048e-01,  1.096896e-01,  1.797286e-01, -1.097220e+00, -1.311042e-01},
  {-3.795633e-01, -8.284568e-01,  4.118145e-01, -1.008512e-01, -1.210170e+00, -6.342097e-02},
  {-8.538759e-01, -4.937777e-01,  1.645580e-01, -3.561512e-01, -1.065029e+00, -3.178618e-01},
  {-8.928042e-01, -4.246824e-01,  1.501519e-01, -3.798494e-01, -1.044826e+00, -3.773400e-01},
  {-8.365607e-01, -5.135404e-01,  1.908989e-01, -3.613130e-01, -1.081599e+00, -3.846215e-01},
  {-7.392390e-01, -6.509274e-01,  1.726820e-01, -2.848993e-01, -1.190470e+00, -3.962592e-01},
  {-8.084727e-01, -5.657162e-01,  1.622864e-01, -3.311081e-01, -1.142345e+00, -4.308296e-01},
  { 9.202971e-01,  1.754943e-01, -3.496497e-01,  1.760246e-01, -9.933461e-01, -5.552238e-01},
  {-9.254193e-01, -3.739539e-01, -6.129748e-02, -4.148204e-01, -9.841067e-01, -5.024065e-01},
  { 7.910808e-01,  1.706320e-01, -5.874316e-01,  1.397909e-01, -9.868035e-01, -6.167984e-01},
  {-7.829577e-01, -5.525969e-01, -2.856818e-01, -3.268506e-01, -1.136781e+00, -5.920907e-01},
  {-8.716223e-01, -4.286811e-01, -2.377123e-01, -3.544447e-01, -1.095396e+00, -5.753143e-01},
  {-9.144988e-01, -3.889960e-01, -1.112383e-01, -3.972491e-01, -1.018178e+00, -5.391449e-01},
  { 1.940859e-01,  1.615973e-01, -9.675831e-01, -6.472977e-02, -9.773650e-01, -7.372614e-01},
  { 2.949099e-01,  1.796385e-01, -9.384872e-01, -1.585020e-02, -1.007240e+00, -7.300102e-01},
  { 5.466030e-01,  1.608193e-01, -8.218043e-01,  5.036198e-02, -1.036641e+00, -7.025204e-01},
  {-4.213697e-01, -7.471482e-02, -9.038060e-01, -2.648573e-01, -1.011771e+00, -7.131032e-01},
  {-7.608402e-01, -2.268327e-01, -6.080041e-01, -3.178469e-01, -1.082993e+00, -6.531973e-01},
  { 1.522637e-01,  1.778345e-01, -9.722092e-01,  2.168898e-02, -1.045801e+00, -7.197025e-01},
  { 3.110389e-02,  1.157248e-01, -9.927942e-01, -1.042585e-01, -9.944019e-01, -7.454885e-01},
  {-5.307926e-01, -1.725632e-01, -8.297477e-01, -2.890105e-01, -1.033921e+00, -6.975738e-01},
  {-6.902664e-01, -2.661888e-01, -6.728119e-01, -3.051328e-01, -1.067427e+00, -6.736956e-01},
  {-1.046614e-01,  5.242928e-02, -9.931250e-01, -1.657564e-01, -1.006548e+00, -7.442473e-01},
  {-1.409120e-01, -6.894133e-01,  7.105301e-01,  1.167667e-01, -9.515165e-01,  4.392896e-01},
  {-2.590596e-01, -3.813159e-01,  8.874043e-01, -1.748688e-02, -9.760271e-01,  3.758518e-01},
  { 2.979816e-01, -7.115995e-01,  6.362649e-01,  1.673480e-01, -1.020677e+00,  3.624041e-01},
  { 8.974205e-02, -6.889011e-01,  7.192785e-01,  1.408273e-01, -9.929579e-01,  3.984979e-01},
  { 6.640757e-01, -4.727153e-01,  5.792615e-01,  2.838659e-01, -8.816074e-01,  4.096409e-01},
  {-3.197517e-01, -7.190119e-01,  6.170744e-01,  1.295318e-02, -1.030371e+00,  3.368022e-01},
  { 8.787470e-01, -1.344927e-01,  4.579469e-01,  3.005091e-01, -8.870578e-01,  3.821295e-01},
  { 5.060251e-01, -7.329122e-01,  4.547288e-01,  2.032198e-01, -1.028342e+00,  3.253072e-01},
  {-2.023157e-01, -8.488936e-01,  4.883114e-01,  3.522991e-02, -1.079155e+00,  2.797627e-01},
  {-7.026715e-01, -6.115010e-01,  3.637572e-01, -3.275265e-01, -9.552804e-01,  1.242558e-01},
  { 8.617344e-01, -4.770033e-01,  1.728635e-01,  2.999796e-01, -8.962438e-01,  3.703755e-01},
  { 6.232520e-01, -6.935685e-01,  3.612752e-01,  2.213775e-01, -1.027741e+00,  2.993551e-01},
  {-7.613083e-01, -5.900600e-01,  2.687728e-01, -3.350594e-01, -9.497523e-01,  1.163238e-01},
  {-2.037211e-01, -8.827286e-01,  4.234239e-01,  1.997141e-02, -1.098949e+00,  2.362364e-01},
  {-4.992374e-01, -7.216986e-01,  4.794927e-01, -2.185685e-01, -1.033744e+00,  1.478374e-01},
  {-5.495921e-01, -7.486158e-01,  3.708407e-01, -2.296250e-01, -1.057208e+00,  9.523880e-02},
  { 9.022835e-01, -4.241494e-01, -7.734212e-02,  2.767359e-01, -9.805789e-01,  1.545946e-01},
  { 8.541569e-01, -5.191501e-01, -2.998518e-02,  2.744527e-01, -9.942278e-01,  2.119950e-01},
  {-8.296879e-01, -5.370483e-01,  1.523062e-01, -4.062850e-01, -8.743080e-01,  5.088904e-02},
  { 7.781436e-01, -5.670576e-01, -2.700708e-01,  2.279161e-01, -1.025802e+00,  1.504902e-02},
  {-2.919889e-01, -8.359501e-01,  4.646825e-01, -6.910375e-02, -1.172137e+00,  4.086420e-02},
  {-5.665783e-01, -7.405272e-01,  3.613982e-01, -1.851840e-01, -1.184596e+00, -1.095604e-01},
  {-8.702294e-01, -4.557798e-01,  1.869911e-01, -3.683069e-01, -1.050086e+00, -3.354782e-01},
  {-9.129452e-01, -3.833396e-01,  1.399353e-01, -3.934546e-01, -1.013232e+00, -3.749797e-01},
  {-7.839764e-01, -5.925077e-01,  1.852450e-01, -3.139821e-01, -1.151160e+00, -3.840927e-01},
  { 9.884210e-01,  1.403862e-01, -5.758203e-02,  1.989367e-01, -9.747763e-01, -3.959065e-01},
  { 9.594846e-01,  1.566707e-01, -2.341871e-01,  1.878619e-01, -1.003962e+00, -5.202347e-01},
  {-9.361417e-01, -3.485500e-01,  4.638498e-02, -4.095333e-01, -9.938194e-01, -4.419357e-01},
  { 5.600909e-01,  2.070465e-01, -8.021409e-01,  7.402461e-02, -9.381720e-01, -6.651248e-01},
  { 7.485170e-01,  1.891338e-01, -6.355711e-01,  1.248555e-01, -9.460230e-01, -6.231212e-01},
  { 5.108289e-01,  1.634166e-01, -8.440076e-01,  5.343573e-02, -9.837255e-01, -6.889172e-01},
  {-8.182046e-01, -4.338063e-01, -3.772976e-01, -3.319747e-01, -1.114129e+00, -6.107886e-01},
  {-7.948232e-01, -3.283394e-01, -5.103424e-01, -3.300096e-01, -1.093342e+00, -6.316881e-01},
  { 1.233158e-01,  1.678576e-01, -9.780680e-01, -8.772493e-02, -9.563064e-01, -7.375165e-01},
  {-2.955362e-01,  4.010611e-02, -9.544894e-01, -2.287616e-01, -9.771799e-01, -7.281824e-01},
  {-4.164703e-01, -6.284266e-02, -9.069747e-01, -2.784728e-01, -9.901994e-01, -7.083217e-01},
  { 4.246552e-01,  1.083082e-01, -8.988533e-01,  3.640157e-02, -1.069569e+00, -7.158579e-01},
  { 1.548800e-01,  2.345487e-01, -9.596870e-01,  2.374201e-02, -1.040133e+00, -7.186425e-01},
  {-1.606913e-01,  8.586185e-02, -9.832630e-01, -1.784394e-01, -9.762551e-01, -7.400422e-01},
  {-2.118694e-02,  1.019631e-01, -9.945625e-01, -1.244871e-01, -9.974887e-01, -7.459778e-01},
  {-1.244463e-01,  1.105004e-01, -9.860541e-01, -1.705493e-01, -9.570161e-01, -7.394652e-01},
  {-1.986627e-01, -6.063782e-01,  7.699601e-01,  1.121050e-01, -9.031696e-01,  4.871999e-01},
  { 3.877939e-01, -6.147192e-01,  6.868306e-01,  2.220129e-01, -8.818156e-01,  4.824590e-01},
  {-3.643789e-01, -6.998599e-01,  6.143485e-01,  4.435235e-02, -9.119353e-01,  4.528103e-01},
  { 5.806370e-01, -4.979105e-01,  6.441628e-01,  2.474398e-01, -8.586962e-01,  4.831457e-01},
  {-4.108556e-01, -5.913345e-01,  6.939174e-01, -2.870884e-02, -9.704928e-01,  3.740358e-01},
  { 7.995868e-01, -3.531332e-01,  4.857549e-01,  2.801508e-01, -8.633214e-01,  4.283677e-01},
  { 3.891841e-01, -7.088309e-01,  5.882980e-01,  1.770414e-01, -1.013988e+00,  3.651327e-01},
  { 8.425975e-01, -2.405089e-01,  4.818557e-01,  2.954613e-01, -8.802013e-01,  3.944262e-01},
  { 4.409322e-01, -7.041158e-01,  5.565965e-01,  1.950267e-01, -1.020735e+00,  3.443742e-01},
  {-2.064309e-01, -8.599417e-01,  4.667833e-01,  1.571240e-02, -1.085059e+00,  2.610253e-01},
  { 8.473278e-01, -5.192236e-01,  1.115459e-01,  2.999761e-01, -9.010326e-01,  3.533887e-01},
  {-5.161720e-01, -6.847678e-01,  5.144507e-01, -2.546360e-01, -9.889212e-01,  1.740932e-01},
  {-7.731683e-01, -5.907138e-01,  2.307988e-01, -3.501020e-01, -9.317802e-01,  1.117712e-01},
  {-5.477324e-01, -6.468446e-01,  5.306424e-01, -2.788930e-01, -9.733817e-01,  1.692701e-01},
  {-2.034518e-01, -8.689232e-01,  4.511983e-01, -1.724469e-02, -1.120414e+00,  1.764078e-01},
  { 7.264063e-01, -6.418450e-01,  2.457007e-01,  2.614201e-01, -1.003502e+00,  2.601784e-01},
  { 9.205754e-01, -3.773605e-01, -1.006973e-01,  2.906803e-01, -9.446748e-01,  1.422694e-01},
  {-2.740904e-01, -8.809326e-01,  3.857875e-01, -7.544542e-02, -1.156404e+00,  6.820033e-02},
  { 9.090948e-01, -3.601576e-01, -2.093638e-01,  2.907923e-01, -9.016528e-01,  4.769991e-02},
  { 9.451038e-01, -3.262978e-01,  1.756189e-02,  1.826602e-01, -1.074500e+00, -1.029872e-01},
  {-5.084357e-01, -7.819991e-01,  3.605144e-01, -1.877554e-01, -1.143156e+00, -2.404780e-02},
  {-3.576876e-01, -8.055064e-01,  4.724606e-01, -1.006419e-01, -1.185035e+00, -8.424117e-03},
  {-9.114869e-01, -3.845395e-01,  1.460172e-01, -3.959522e-01, -9.991744e-01, -3.550167e-01},
  {-9.126563e-01, -3.793716e-01,  1.521040e-01, -3.955378e-01, -1.003703e+00, -3.641140e-01},
  { 9.192207e-01,  1.968710e-01, -3.409913e-01,  1.746952e-01, -9.745202e-01, -5.486330e-01},
  { 8.846890e-01,  2.147079e-01, -4.137945e-01,  1.635494e-01, -9.600521e-01, -5.668218e-01},
  { 8.250760e-01,  1.875899e-01, -5.329724e-01,  1.439633e-01, -9.665757e-01, -6.044359e-01},
  {-8.369234e-01, -4.326449e-01, -3.352277e-01, -3.417577e-01, -1.106071e+00, -5.982197e-01},
  {-8.773188e-01, -4.116987e-01, -2.466090e-01, -3.641939e-01, -1.071859e+00, -5.820687e-01},
  {-3.792503e-01, -4.676598e-03, -9.252824e-01, -2.764777e-01, -9.634711e-01, -7.103236e-01},
  {-4.914929e-01, -9.999762e-02, -8.651215e-01, -2.967049e-01, -9.828431e-01, -6.999171e-01},
  {-2.517723e-01,  1.386797e-01, -9.577988e-01, -2.196790e-01, -9.259657e-01, -7.288257e-01},
  { 4.734984e-01, -5.576849e-01,  6.817527e-01,  2.353400e-01, -8.597455e-01,  4.920643e-01},
  { 7.480171e-01, -3.643824e-01,  5.547034e-01,  2.609767e-01, -8.449482e-01,  4.765072e-01},
  { 6.693590e-01, -5.309963e-01,  5.196166e-01,  2.487017e-01, -8.954650e-01,  4.425194e-01},
  { 9.458525e-02, -7.226034e-01,  6.847612e-01,  1.429775e-01, -9.790705e-01,  4.123850e-01},
  { 7.943043e-01, -4.112284e-01,  4.471823e-01,  2.770756e-01, -8.464498e-01,  4.474767e-01},
  { 2.790990e-01, -6.963245e-01,  6.612382e-01,  1.854808e-01, -9.999946e-01,  3.765368e-01},
  { 6.396387e-01, -5.725725e-01,  5.128577e-01,  2.623912e-01, -9.158835e-01,  4.048449e-01},
  { 8.577124e-01, -2.504483e-01,  4.490044e-01,  2.973410e-01, -8.652528e-01,  3.987030e-01},
  {-4.987341e-01, -5.731733e-01,  6.501820e-01, -1.235081e-01, -9.731438e-01,  3.071398e-01},
  {-2.726085e-01, -8.081075e-01,  5.221560e-01,  9.467400e-03, -1.074526e+00,  2.757781e-01},
  { 9.369083e-01, -3.106245e-01,  1.603602e-01,  3.055862e-01, -8.823829e-01,  3.663957e-01},
  { 6.914458e-01, -6.355860e-01,  3.434141e-01,  2.832365e-01, -9.163817e-01,  3.736832e-01},
  { 5.505458e-01, -6.832405e-01,  4.796684e-01,  2.197660e-01, -1.006653e+00,  3.379409e-01},
  {-4.814167e-01, -6.376448e-01,  6.013710e-01, -1.179941e-01, -9.975635e-01,  2.879202e-01},
  { 7.109617e-01, -6.318786e-01,  3.086467e-01,  2.482956e-01, -9.973276e-01,  3.067056e-01},
  {-4.927065e-01, -6.444453e-01,  5.847483e-01, -2.228167e-01, -9.884045e-01,  2.043535e-01},
  { 7.751753e-01, -5.911831e-01,  2.227237e-01,  2.680710e-01, -9.957159e-01,  2.593060e-01},
  { 9.083263e-01, -4.048808e-01, -1.049517e-01,  2.867745e-01, -9.694276e-01,  2.034909e-01},
  { 8.908173e-01, -4.539858e-01, -1.847911e-02,  2.831977e-01, -9.801176e-01,  2.183152e-01},
  { 8.456324e-01, -5.227856e-01,  1.077083e-01,  2.811559e-01, -9.836037e-01,  2.372632e-01},
  {-8.057594e-01, -5.489314e-01,  2.223199e-01, -3.819324e-01, -8.952471e-01,  9.884904e-02},
  { 9.214138e-01, -3.640367e-01, -1.359186e-01,  2.974774e-01, -9.196058e-01,  1.208554e-01},
  { 9.294415e-01, -3.389238e-01, -1.458395e-01,  3.054454e-01, -8.916090e-01,  1.002949e-01},
  { 8.115205e-01, -4.993191e-01, -3.035043e-01,  2.320359e-01, -1.005705e+00, -1.035096e-02},
  { 9.130571e-01, -3.471077e-01,  2.141098e-01,  1.857945e-01, -1.065868e+00, -1.129365e-01},
  {-8.640259e-01, -4.817836e-01,  1.460953e-01, -3.841168e-01, -9.756916e-01, -1.514454e-01},
  { 8.891875e-01, -3.893440e-01, -2.403263e-01,  2.496043e-01, -9.480801e-01, -3.978021e-02},
  {-4.487159e-01, -7.717711e-01,  4.505812e-01, -1.207161e-01, -1.182108e+00, -2.198178e-02},
  {-8.386244e-01, -5.442086e-01, -2.336812e-02, -3.800304e-01, -9.907264e-01, -1.924983e-01},
  { 9.492766e-01, -3.002802e-01, -9.330498e-02,  1.869496e-01, -1.074588e+00, -1.568735e-01},
  {-4.746598e-01, -7.880926e-01,  3.919288e-01, -1.480355e-01, -1.192276e+00, -7.568567e-02},
  {-8.957481e-01, -4.297470e-01,  1.138109e-01, -3.876271e-01, -9.880100e-01, -2.669167e-01},
  {-9.026752e-01, -4.055974e-01,  1.437646e-01, -4.024287e-01, -9.748886e-01, -3.305366e-01},
  { 9.684049e-01,  1.866770e-01, -1.653587e-01,  1.857833e-01, -9.745804e-01, -4.991175e-01},
  { 6.695635e-01,  1.793955e-01, -7.207648e-01,  1.093723e-01, -9.178203e-01, -6.318285e-01},
  { 8.664898e-01,  1.796941e-01, -4.657309e-01,  1.610187e-01, -9.793823e-01, -5.802407e-01},
  { 4.965997e-01,  2.173750e-01, -8.403195e-01,  4.248622e-02, -9.412650e-01, -6.872574e-01},
  { 8.199629e-01,  2.021924e-01, -5.355177e-01,  1.407724e-01, -9.467763e-01, -6.024141e-01},
  {-8.811075e-01, -3.862796e-01, -2.728325e-01, -3.921361e-01, -1.006072e+00, -5.892941e-01},
  { 2.731028e-01,  1.775559e-01, -9.454569e-01, -3.637853e-02, -9.447903e-01, -7.242480e-01},
  { 3.377280e-01,  1.791844e-01, -9.240308e-01, -9.525010e-03, -9.773250e-01, -7.214435e-01},
  { 2.607271e-01,  2.634404e-01, -9.287737e-01,  2.726738e-02, -1.027334e+00, -7.139249e-01},
  {-7.084821e-01, -3.631243e-01, -6.051394e-01, -3.416918e-01, -1.054330e+00, -6.426204e-01},
  { 4.208376e-01,  1.499845e-01, -8.946510e-01,  1.093180e-02, -1.014080e+00, -7.200014e-01},
  {-1.383023e-02,  1.217736e-01, -9.924615e-01, -1.318069e-01, -9.440745e-01, -7.393457e-01},
  {-2.220711e-01,  3.637384e-01, -9.046429e-01, -1.661133e-01, -8.990597e-01, -7.342224e-01},
  {-5.757266e-01, -1.706869e-01, -7.996279e-01, -3.183449e-01, -1.018057e+00, -6.807342e-01},
  {-6.283992e-01, -2.818312e-01, -7.250418e-01, -3.225694e-01, -1.032120e+00, -6.732237e-01},
  { 3.399490e-01, -6.535711e-01,  6.762244e-01,  2.143608e-01, -8.962339e-01,  4.732460e-01},
  { 1.388927e-02, -6.891382e-01,  7.244969e-01,  1.313776e-01, -9.316124e-01,  4.610959e-01},
  {-4.829994e-01, -7.146592e-01,  5.059385e-01,  8.975823e-03, -8.903642e-01,  4.511311e-01},
  { 5.045284e-01, -6.325205e-01,  5.876810e-01,  2.290048e-01, -9.019375e-01,  4.567490e-01},
  { 6.091740e-01, -4.470907e-01,  6.549940e-01,  2.434752e-01, -8.435135e-01,  4.974475e-01},
  {-3.829815e-01, -6.603336e-01,  6.459756e-01, -2.649558e-02, -1.003480e+00,  3.451449e-01},
  {-3.408645e-01, -7.553851e-01,  5.596468e-01, -7.928195e-03, -1.048154e+00,  3.034238e-01},
  {-4.743204e-01, -5.621999e-01,  6.774596e-01, -1.163792e-01, -9.486858e-01,  3.330359e-01},
  { 5.307540e-01, -6.929860e-01,  4.879247e-01,  2.170989e-01, -9.985822e-01,  3.532082e-01},
  { 6.415457e-01, -6.352882e-01,  4.299162e-01,  2.350493e-01, -9.948248e-01,  3.345234e-01},
  { 7.857785e-01, -5.390039e-01,  3.033594e-01,  2.857030e-01, -9.261102e-01,  3.458081e-01},
  { 8.256831e-01, -5.039529e-01,  2.535331e-01,  2.883239e-01, -9.239020e-01,  3.422088e-01},
  { 9.048433e-01, -3.944978e-01,  1.600937e-01,  3.035991e-01, -8.985606e-01,  3.341314e-01},
  {-5.081397e-01, -6.607569e-01,  5.524437e-01, -1.709454e-01, -1.004307e+00,  2.308957e-01},
  {-6.540825e-01, -5.779240e-01,  4.880370e-01, -3.157543e-01, -9.432490e-01,  1.611612e-01},
  {-3.077912e-01, -8.336586e-01,  4.585608e-01, -5.359532e-02, -1.117768e+00,  1.595218e-01},
  {-2.912036e-01, -8.479196e-01,  4.429815e-01, -6.251425e-02, -1.126622e+00,  1.374940e-01},
  {-3.736901e-01, -8.529741e-01,  3.644048e-01, -1.856436e-01, -1.108063e+00,  5.824281e-02},
  {-4.568742e-01, -8.162596e-01,  3.535339e-01, -1.846591e-01, -1.111618e+00,  4.909280e-02},
  {-8.705547e-01, -4.358155e-01,  2.284712e-01, -4.012058e-01, -9.055164e-01, -5.743715e-02},
  {-8.855526e-01, -4.403489e-01,  1.479507e-01, -3.975679e-01, -9.345701e-01, -1.152263e-01},
  {-4.698402e-01, -8.027848e-01,  3.671333e-01, -1.471892e-01, -1.179273e+00, -4.646631e-02},
  {-8.981755e-01, -4.309462e-01,  8.698408e-02, -3.888257e-01, -9.721761e-01, -1.789336e-01},
  { 9.886837e-01,  1.338998e-01, -6.764116e-02,  1.943856e-01, -9.459381e-01, -4.001562e-01},
  {-9.404229e-01, -3.399403e-01, -6.728325e-03, -4.307455e-01, -9.422187e-01, -5.059989e-01},
  { 5.673553e-01,  1.467790e-01, -8.102863e-01,  5.368581e-02, -8.761457e-01, -6.677002e-01},
  {-9.066973e-01, -3.627787e-01, -2.151550e-01, -4.049107e-01, -9.858240e-01, -5.738781e-01},
  {-8.211308e-01, -4.110252e-01, -3.959828e-01, -3.514433e-01, -1.077872e+00, -6.086696e-01},
  {-8.406122e-01, -4.046959e-01, -3.599893e-01, -3.611563e-01, -1.064949e+00, -6.011490e-01},
  {-8.335606e-01, -3.955871e-01, -3.856003e-01, -3.574055e-01, -1.068862e+00, -6.054531e-01},
  { 2.302859e-01,  1.601620e-01, -9.598523e-01, -5.156022e-02, -9.109724e-01, -7.221677e-01},
  { 4.593151e-01,  1.155520e-01, -8.807254e-01,  2.182418e-02, -9.730942e-01, -7.058628e-01},
  { 3.879991e-01,  1.821305e-01, -9.034850e-01, -9.196169e-03, -9.566642e-01, -7.171202e-01},
  {-5.238764e-01, -1.077688e-01, -8.449494e-01, -3.208638e-01, -9.636710e-01, -6.880103e-01},
  {-7.668449e-01, -3.753423e-01, -5.206410e-01, -3.446579e-01, -1.058046e+00, -6.365593e-01},
  {-6.965447e-01, -3.575140e-01, -6.221006e-01, -3.471506e-01, -1.035086e+00, -6.479515e-01},
  { 4.324401e-01,  2.069293e-01, -8.775966e-01,  8.834541e-03, -9.934012e-01, -7.167528e-01},
  { 1.331731e-02,  1.970061e-01, -9.803119e-01, -1.480734e-01, -8.888659e-01, -7.334856e-01},
  {-5.620192e-01, -1.858780e-01, -8.059676e-01, -3.301437e-01, -1.005085e+00, -6.751344e-01},
  {-6.469262e-01, -2.798689e-01, -7.093376e-01, -3.488028e-01, -1.009473e+00, -6.586277e-01},
  {-5.997397e-01, -2.215301e-01, -7.689192e-01, -3.285044e-01, -1.013388e+00, -6.741096e-01},
  {-2.076653e-01, -7.893634e-01,  5.777374e-01,  9.988591e-02, -8.662510e-01,  5.222645e-01},
  {-1.315683e-03, -7.415448e-01,  6.709020e-01,  1.195161e-01, -8.773559e-01,  5.125486e-01},
  { 3.943018e-02, -6.944408e-01,  7.184688e-01,  1.402200e-01, -9.073570e-01,  4.837725e-01},
  { 4.421884e-01, -5.641748e-01,  6.972634e-01,  2.189466e-01, -8.532613e-01,  5.082999e-01},
  { 6.335723e-02, -6.933865e-01,  7.177751e-01,  1.489360e-01, -9.423087e-01,  4.498970e-01},
  {-4.475842e-01, -6.116274e-01,  6.523652e-01, -2.681599e-03, -8.836457e-01,  4.489707e-01},
  {-4.623445e-01, -3.867426e-01,  7.979146e-01, -9.572466e-02, -9.114216e-01,  3.730063e-01},
  {-4.789050e-01, -4.973402e-01,  7.233966e-01, -9.591532e-02, -9.341003e-01,  3.582481e-01},
  { 3.554277e-01, -7.241433e-01,  5.910056e-01,  1.934387e-01, -9.889557e-01,  3.852980e-01},
  { 9.433132e-01, -2.158973e-01,  2.520886e-01,  3.123089e-01, -8.595946e-01,  3.616962e-01},
  {-3.113304e-01, -8.102682e-01,  4.965269e-01, -9.939183e-03, -1.082120e+00,  2.518331e-01},
  {-6.527869e-01, -5.925398e-01,  4.719808e-01, -1.591047e-01, -9.829240e-01,  2.652992e-01},
  { 8.126457e-01, -5.269096e-01,  2.489443e-01,  2.863422e-01, -9.358361e-01,  3.223660e-01},
  { 8.873466e-01, -4.295279e-01,  1.676956e-01,  2.983235e-01, -9.188281e-01,  3.122388e-01},
  {-4.520641e-01, -7.369428e-01,  5.025468e-01, -1.556618e-01, -1.056438e+00,  1.760176e-01},
  { 8.471265e-01, -4.872688e-01,  2.120039e-01,  2.787351e-01, -9.776556e-01,  2.652934e-01},
  {-7.904578e-01, -5.208430e-01,  3.223338e-01, -3.814889e-01, -8.869371e-01,  1.154766e-01},
  { 9.054456e-01, -4.166529e-01,  8.104797e-02,  2.837324e-01, -9.773796e-01,  2.429237e-01},
  {-4.033298e-01, -8.092624e-01,  4.271060e-01, -1.811934e-01, -1.100426e+00,  7.608065e-02},
  {-2.954993e-01, -8.648043e-01,  4.059478e-01, -8.473656e-02, -1.130842e+00,  1.140132e-01},
  {-3.610752e-01, -8.491279e-01,  3.854951e-01, -1.180457e-01, -1.147719e+00,  5.257599e-02},
  { 9.605016e-01, -2.629429e-01,  9.109214e-02,  1.920551e-01, -1.047409e+00, -1.061192e-01},
  {-4.015827e-01, -8.434917e-01,  3.567255e-01, -1.355546e-01, -1.145027e+00,  4.072588e-02},
  { 8.922666e-01, -3.436600e-01, -2.928451e-01,  2.686396e-01, -8.880861e-01, -5.160809e-02},
  { 9.400914e-01,  2.197798e-01, -2.606243e-01,  1.758308e-01, -9.578590e-01, -5.328497e-01},
  { 6.804470e-01,  1.704971e-01, -7.126870e-01,  1.029355e-01, -8.943385e-01, -6.319870e-01},
  {-4.581495e-01, -3.888116e-02, -8.880243e-01, -3.124153e-01, -9.219347e-01, -6.952890e-01},
  {-5.521225e-01, -1.006192e-01, -8.276693e-01, -3.362518e-01, -9.671456e-01, -6.778738e-01},
  {-5.929458e-01, -1.965756e-01, -7.808799e-01, -3.426251e-01, -9.934079e-01, -6.686374e-01},
  {-3.156691e-01, -8.007929e-01,  5.090027e-01,  7.249736e-02, -8.527627e-01,  5.279415e-01},
  {-8.409858e-02, -6.491213e-01,  7.560217e-01,  1.239951e-01, -8.915550e-01,  4.986018e-01},
  { 6.043883e-02, -6.838406e-01,  7.271239e-01,  1.458284e-01, -9.176521e-01,  4.737773e-01},
  { 4.193823e-01, -5.686744e-01,  7.076212e-01,  2.119482e-01, -8.425868e-01,  5.209336e-01},
  { 6.603581e-01, -4.519344e-01,  5.997354e-01,  2.464509e-01, -8.243353e-01,  5.078341e-01},
  {-4.594329e-01, -5.405115e-01,  7.048182e-01, -6.114496e-02, -9.667358e-01,  3.564939e-01},
  {-4.380134e-01, -6.101092e-01,  6.602356e-01, -5.312944e-02, -9.799324e-01,  3.511180e-01},
  { 7.907491e-01, -3.783805e-01,  4.811902e-01,  2.937697e-01, -8.208759e-01,  4.354760e-01},
  { 5.758904e-01, -6.358902e-01,  5.138033e-01,  2.347695e-01, -9.375583e-01,  4.113702e-01},
  { 9.154270e-01, -2.076818e-01,  3.447635e-01,  3.106635e-01, -8.287045e-01,  3.896185e-01},
  { 5.522126e-01, -6.644902e-01,  5.035018e-01,  2.145213e-01, -9.887236e-01,  3.690156e-01},
  { 6.566430e-01, -6.274759e-01,  4.184422e-01,  2.528428e-01, -9.470990e-01,  3.757822e-01},
  { 7.271138e-01, -5.992100e-01,  3.350416e-01,  2.684242e-01, -9.483689e-01,  3.459674e-01},
  { 7.217559e-01, -5.616360e-01,  4.045165e-01,  2.467368e-01, -9.841467e-01,  3.312250e-01},
  { 7.755098e-01, -5.361250e-01,  3.333983e-01,  2.626242e-01, -9.808140e-01,  3.075891e-01},
  {-7.404862e-01, -5.501975e-01,  3.859571e-01, -3.408461e-01, -9.275419e-01,  1.405474e-01},
  { 8.984922e-01, -4.105746e-01,  1.553715e-01,  2.931530e-01, -9.367195e-01,  2.930481e-01},
  { 8.380475e-01, -4.661083e-01,  2.835832e-01,  2.807347e-01, -9.594497e-01,  2.930036e-01},
  {-2.699009e-01, -8.465525e-01,  4.588054e-01, -4.650767e-02, -1.100178e+00,  1.966342e-01},
  {-5.227754e-01, -6.048356e-01,  6.007327e-01, -2.531748e-01, -9.533418e-01,  2.162602e-01},
  {-5.872793e-01, -5.730475e-01,  5.715939e-01, -2.889365e-01, -9.346470e-01,  2.008005e-01},
  {-4.438877e-01, -7.732480e-01,  4.528258e-01, -1.597173e-01, -1.085610e+00,  1.270745e-01},
  {-7.946296e-01, -5.198347e-01,  3.135851e-01, -4.029497e-01, -8.510603e-01,  1.198253e-01},
  {-8.146116e-01, -4.993044e-01,  2.951324e-01, -4.187544e-01, -8.347558e-01,  1.057337e-01},
  {-8.741609e-01, -4.226438e-01,  2.391963e-01, -4.108761e-01, -8.910070e-01, -6.730190e-02},
  { 9.286541e-01, -3.146408e-01, -1.964761e-01,  3.128543e-01, -8.471993e-01,  5.927645e-02},
  { 9.344252e-01, -2.472157e-01, -2.563861e-01,  2.816293e-01, -8.498911e-01, -5.731153e-02},
  { 9.370400e-01, -1.924614e-01, -2.914009e-01,  2.748200e-01, -8.481853e-01, -8.429791e-02},
  { 8.790023e-01, -3.077345e-01, -3.642174e-01,  2.726430e-01, -8.462607e-01, -9.160417e-02},
  {-8.860844e-01, -4.631052e-01, -1.969640e-02, -3.959838e-01, -9.627315e-01, -2.179322e-01},
  {-9.312292e-01, -3.532371e-01,  8.964180e-02, -4.208029e-01, -9.393739e-01, -3.552391e-01},
  {-9.307342e-01, -3.362202e-01,  1.438396e-01, -4.227138e-01, -9.312869e-01, -3.502971e-01},
  {-9.111134e-01, -3.960987e-01, -1.139220e-01, -4.414031e-01, -9.110087e-01, -5.058203e-01},
  { 9.388896e-01,  2.400213e-01, -2.467310e-01,  1.730224e-01, -9.452596e-01, -5.319617e-01},
  { 4.974224e-01,  1.341303e-01, -8.570764e-01,  2.827294e-02, -8.474313e-01, -6.788512e-01},
  {-9.369864e-01, -3.318058e-01, -1.093683e-01, -4.323395e-01, -9.332700e-01, -5.357118e-01},
  {-8.735956e-01, -3.161595e-01, -3.699648e-01, -3.981503e-01, -9.766018e-01, -6.067564e-01},
  { 8.433149e-01,  2.083071e-01, -4.954070e-01,  1.410598e-01, -9.185387e-01, -5.904770e-01},
  {-8.132678e-01, -4.006038e-01, -4.220334e-01, -3.735922e-01, -1.029104e+00, -6.129837e-01},
  {-8.280264e-01, -3.572021e-01, -4.321794e-01, -3.749917e-01, -1.022846e+00, -6.163827e-01},
  { 4.065718e-01,  1.941785e-01, -8.927453e-01, -1.462161e-02, -9.194404e-01, -7.119610e-01},
  {-5.566255e-01, -7.147536e-02, -8.276831e-01, -3.393151e-01, -9.454588e-01, -6.779606e-01},
  { 1.389721e-01, -7.038044e-01,  6.966679e-01,  1.552148e-01, -8.782923e-01,  5.086849e-01},
  {-3.785022e-01, -7.270905e-01,  5.727787e-01,  5.189052e-02, -8.429375e-01,  5.278348e-01},
  { 1.473940e-01, -6.753044e-01,  7.226610e-01,  1.576996e-01, -8.873640e-01,  4.993141e-01},
  { 1.951280e-01, -6.466397e-01,  7.374159e-01,  1.756638e-01, -9.130863e-01,  4.720573e-01},
  { 4.877288e-01, -5.422264e-01,  6.841866e-01,  2.197694e-01, -8.298985e-01,  5.261450e-01},
  {-6.146683e-01, -4.149232e-01,  6.708366e-01, -3.848792e-02, -8.503851e-01,  4.491530e-01},
  {-7.043595e-01, -2.291497e-01,  6.718394e-01, -4.482142e-02, -8.563123e-01,  4.398187e-01},
  { 5.916229e-01, -4.025055e-01,  6.985497e-01,  2.399701e-01, -8.152064e-01,  5.205543e-01},
  {-3.991711e-01, -6.879036e-01,  6.061773e-01, -4.733396e-02, -1.022437e+00,  3.108017e-01},
  {-4.560574e-01, -6.143796e-01,  6.438550e-01, -8.600210e-02, -9.892563e-01,  3.191648e-01},
  {-4.392947e-01, -6.831312e-01,  5.833970e-01, -9.215958e-02, -1.010511e+00,  2.928473e-01},
  {-5.292011e-01, -5.049027e-01,  6.819233e-01, -1.543648e-01, -9.075698e-01,  3.350168e-01},
  { 9.600429e-01, -2.212985e-01,  1.713027e-01,  3.226507e-01, -8.347131e-01,  3.381514e-01},
  {-6.191733e-01, -5.728379e-01,  5.371044e-01, -1.710301e-01, -9.590327e-01,  2.786579e-01},
  { 9.391997e-01, -3.269228e-01,  1.050013e-01,  3.157541e-01, -8.815328e-01,  2.883956e-01},
  {-4.473062e-01, -7.298781e-01,  5.169093e-01, -1.125524e-01, -1.048052e+00,  2.257452e-01},
  { 8.195898e-01, -5.195686e-01,  2.414977e-01,  2.782632e-01, -9.683413e-01,  2.849030e-01},
  {-8.345245e-01, -4.828226e-01,  2.654264e-01, -4.280373e-01, -8.224942e-01,  9.887700e-02},
  {-4.424055e-01, -7.972795e-01,  4.106369e-01, -1.470799e-01, -1.126002e+00,  6.751323e-02},
  {-8.772838e-01, -4.684876e-01,  1.043678e-01, -4.466732e-01, -8.082654e-01,  4.502057e-02},
  { 9.825256e-01, -5.806969e-02,  1.768364e-01,  1.957833e-01, -1.032081e+00, -1.201553e-01},
  { 9.163045e-01, -3.230172e-01, -2.367404e-01,  3.005473e-01, -8.420541e-01,  7.426707e-04},
  {-9.174589e-01, -3.937308e-01,  5.696657e-02, -4.208742e-01, -8.993369e-01, -1.690604e-01},
  { 9.271087e-01, -2.764131e-01, -2.531112e-01,  2.672145e-01, -8.464988e-01, -1.079322e-01},
  {-8.957856e-01, -4.346831e-01,  9.283628e-02, -4.667371e-01, -8.184453e-01, -3.725805e-01},
  {-8.737350e-01, -4.735572e-01,  1.110441e-01, -4.679910e-01, -8.166873e-01, -3.717354e-01},
  {-9.374097e-01, -3.434108e-01,  5.772369e-02, -4.417410e-01, -9.028051e-01, -4.176864e-01},
  {-8.396863e-01, -5.084000e-01, -1.909350e-01, -4.435082e-01, -9.052488e-01, -5.142766e-01},
  {-9.313362e-01, -3.565629e-01,  7.399787e-02, -4.370799e-01, -9.178557e-01, -4.367892e-01},
  { 5.662017e-01,  1.090719e-01, -8.170183e-01,  3.480929e-02, -8.244087e-01, -6.714863e-01},
  { 7.748429e-01,  1.951437e-01, -6.012798e-01,  1.230023e-01, -8.896057e-01, -6.082539e-01},
  { 2.126658e-01,  1.301869e-01, -9.684135e-01, -7.361671e-02, -8.691861e-01, -7.211441e-01},
  { 1.731436e-01,  1.090895e-01, -9.788365e-01, -1.102380e-01, -8.485934e-01, -7.259205e-01},
  {-8.824123e-01, -3.134399e-01, -3.508619e-01, -3.895687e-01, -9.796315e-01, -6.226764e-01},
  { 3.278255e-01,  1.544807e-01, -9.320226e-01, -3.117448e-02, -8.813384e-01, -7.111968e-01},
  {-7.581102e-01, -3.712949e-01, -5.361055e-01, -3.662668e-01, -1.020093e+00, -6.340565e-01},
  {-3.144372e-01, -6.520590e-02, -9.470361e-01, -2.798615e-01, -8.487453e-01, -7.125737e-01},
  {-7.166321e-01, -3.016812e-01, -6.288298e-01, -3.655645e-01, -9.972838e-01, -6.476569e-01},
  {-6.863682e-01, -2.272297e-01, -6.908440e-01, -3.641195e-01, -9.892645e-01, -6.524786e-01},
  {-2.522892e-01, -1.002150e-01, -9.624485e-01, -2.561002e-01, -8.192621e-01, -7.215787e-01},
  {-3.646928e-01, -7.296985e-01,  5.783937e-01,  4.394441e-02, -8.248604e-01,  5.465610e-01},
  {-3.441535e-02, -6.860844e-01,  7.267075e-01,  1.166437e-01, -8.519597e-01,  5.405062e-01},
  {-1.248079e-01, -7.446989e-01,  6.556267e-01,  9.667113e-02, -8.438788e-01,  5.470696e-01},
  { 1.537270e-01, -6.795253e-01,  7.173657e-01,  1.453042e-01, -8.497509e-01,  5.404428e-01},
  { 3.222265e-01, -6.262780e-01,  7.098914e-01,  1.861438e-01, -8.353179e-01,  5.401080e-01},
  { 2.440389e-01, -6.693683e-01,  7.017059e-01,  1.787715e-01, -9.350013e-01,  4.511548e-01},
  { 2.282018e-01, -6.506165e-01,  7.243080e-01,  1.757198e-01, -9.488165e-01,  4.390090e-01},
  { 5.470637e-01, -3.520942e-01,  7.594411e-01,  2.223879e-01, -8.152129e-01,  5.357445e-01},
  { 2.933886e-01, -6.880352e-01,  6.637248e-01,  1.838248e-01, -9.558317e-01,  4.304515e-01},
  { 5.045618e-01, -6.287982e-01,  5.916335e-01,  2.176416e-01, -9.406865e-01,  4.254778e-01},
  {-5.165679e-01, -4.383980e-01,  7.355030e-01, -1.195237e-01, -8.846122e-01,  3.745003e-01},
  { 4.446219e-01, -6.936252e-01,  5.667410e-01,  2.061431e-01, -9.636639e-01,  4.074597e-01},
  { 5.309533e-01, -6.620230e-01,  5.289745e-01,  2.222036e-01, -9.605169e-01,  3.971308e-01},
  {-6.014537e-01, -5.794100e-01,  5.500341e-01, -1.814018e-01, -9.387633e-01,  2.878033e-01},
  { 9.579684e-01, -2.631959e-01,  1.141247e-01,  3.230937e-01, -8.519441e-01,  3.020959e-01},
  {-3.733766e-01, -8.014830e-01,  4.671347e-01, -7.481916e-02, -1.092635e+00,  1.890399e-01},
  {-6.892512e-01, -5.277646e-01,  4.963841e-01, -3.362507e-01, -8.991321e-01,  1.811042e-01},
  {-7.365048e-01, -4.831402e-01,  4.734302e-01, -3.647392e-01, -8.749006e-01,  1.644807e-01},
  { 9.084339e-01, -3.973456e-01,  1.298629e-01,  2.947363e-01, -9.510313e-01,  2.485553e-01},
  {-6.229041e-01, -5.269600e-01,  5.781900e-01, -3.080616e-01, -9.092660e-01,  2.049111e-01},
  { 9.337441e-01, -3.557380e-01, -3.965470e-02,  3.041139e-01, -9.266894e-01,  2.105237e-01},
  {-3.931935e-01, -7.895924e-01,  4.711079e-01, -1.122280e-01, -1.104023e+00,  1.396210e-01},
  {-3.807154e-01, -8.063110e-01,  4.526790e-01, -1.126243e-01, -1.113832e+00,  1.222237e-01},
  {-8.432671e-01, -4.820317e-01,  2.377942e-01, -4.396368e-01, -8.066579e-01,  9.118649e-02},
  {-8.476902e-01, -5.303411e-01,  1.264078e-02, -4.191475e-01, -8.681884e-01, -4.316130e-02},
  { 9.442621e-01, -3.020078e-01, -1.309976e-01,  3.248064e-01, -8.367791e-01,  1.055891e-01},
  {-8.791875e-01, -4.372497e-01,  1.893197e-01, -4.219719e-01, -8.685265e-01, -6.374044e-02},
  {-9.037251e-01, -4.165303e-01,  9.891077e-02, -4.273127e-01, -8.794626e-01, -1.347365e-01},
  {-9.528202e-01, -2.806786e-01,  1.155561e-01, -4.588794e-01, -8.331624e-01, -3.371101e-01},
  {-9.344595e-01, -3.173322e-01,  1.615109e-01, -4.690447e-01, -8.072523e-01, -3.590033e-01},
  { 9.951174e-01, -7.419426e-02,  6.508829e-02,  1.958603e-01, -1.020137e+00, -2.342198e-01},
  {-9.018921e-01, -3.802131e-01,  2.050091e-01, -4.336928e-01, -8.993443e-01, -3.335435e-01},
  {-9.518659e-01, -2.979284e-01,  7.204147e-02, -4.528313e-01, -8.658085e-01, -4.042887e-01},
  {-9.464900e-01, -3.177976e-01,  5.622578e-02, -4.438642e-01, -8.967824e-01, -4.178342e-01},
  { 6.515391e-01,  1.810156e-01, -7.367022e-01,  7.666593e-02, -8.437663e-01, -6.441584e-01},
  { 7.474251e-01,  1.967577e-01, -6.345407e-01,  1.092960e-01, -8.663343e-01, -6.177880e-01},
  {-9.106469e-01, -3.469495e-01, -2.243842e-01, -4.228420e-01, -9.440486e-01, -5.684702e-01},
  { 3.063318e-01,  1.140744e-01, -9.450650e-01, -2.662127e-02, -8.369837e-01, -7.029931e-01},
  {-6.002711e-01, -6.910969e-02, -7.968051e-01, -3.497688e-01, -9.135498e-01, -6.732177e-01},
  { 1.351150e-01,  7.695528e-02, -9.878370e-01, -1.062745e-01, -8.388916e-01, -7.243320e-01},
  {-7.727544e-01, -2.982377e-01, -5.602720e-01, -3.766221e-01, -9.929433e-01, -6.361200e-01},
  {-5.944907e-02, -1.115461e-02, -9.981690e-01, -1.975464e-01, -8.156279e-01, -7.287611e-01},
  { 7.131673e-02, -6.560858e-01,  7.513090e-01,  1.325402e-01, -8.545669e-01,  5.389935e-01},
  { 4.486223e-01, -4.808385e-01,  7.533474e-01,  1.995503e-01, -8.171027e-01,  5.493571e-01},
  { 3.812567e-01, -5.297558e-01,  7.576292e-01,  1.905999e-01, -8.165497e-01,  5.547986e-01},
  {-5.138158e-01, -6.270550e-01,  5.854873e-01, -4.920136e-02, -8.221270e-01,  4.651727e-01},
  {-4.793978e-01, -5.041750e-01,  7.183213e-01, -6.767124e-02, -8.384774e-01,  4.361321e-01},
  { 4.294867e-01, -6.435059e-01,  6.335939e-01,  2.055371e-01, -9.559209e-01,  4.177324e-01},
  { 7.023051e-01, -4.672490e-01,  5.370715e-01,  2.947531e-01, -7.923644e-01,  4.571333e-01},
  {-3.967561e-01, -7.350618e-01,  5.497899e-01, -6.915234e-02, -1.028222e+00,  2.885186e-01},
  {-3.727250e-01, -7.696415e-01,  5.183898e-01, -5.380200e-02, -1.067444e+00,  2.452680e-01},
  {-3.911849e-01, -7.786122e-01,  4.906500e-01, -7.571787e-02, -1.076713e+00,  2.145593e-01},
  { 9.437598e-01, -3.240559e-01,  6.561521e-02,  3.097107e-01, -9.063714e-01,  2.641964e-01},
  {-6.967154e-01, -4.634162e-01,  5.475701e-01, -3.436310e-01, -8.828035e-01,  1.875319e-01},
  {-7.375057e-01, -5.089164e-01,  4.439474e-01, -3.756588e-01, -8.570910e-01,  1.667437e-01},
  {-7.704408e-01, -4.909656e-01,  4.066616e-01, -3.993239e-01, -8.305362e-01,  1.553893e-01},
  {-8.977413e-01, -4.378606e-01,  4.836171e-02, -4.460882e-01, -8.136041e-01,  1.805199e-02},
  {-8.833898e-01, -4.501108e-01,  1.304712e-01, -4.519315e-01, -7.937440e-01,  6.436654e-02},
  {-9.227312e-01, -3.767955e-01,  8.119381e-02, -4.359534e-01, -8.534173e-01, -1.117965e-01},
  { 9.039876e-01, -3.084777e-01, -2.960538e-01,  2.915445e-01, -7.976704e-01, -8.801455e-02},
  { 9.999430e-01,  7.626759e-03,  7.479612e-03,  1.974589e-01, -9.582772e-01, -2.806689e-01},
  {-9.607313e-01, -2.749706e-01,  3.723663e-02, -4.584331e-01, -8.488790e-01, -4.095618e-01},
  {-9.461085e-01, -2.863743e-01, -1.512237e-01, -4.493037e-01, -8.875634e-01, -5.066518e-01},
  { 9.009871e-01,  1.496652e-01, -4.072133e-01,  1.516001e-01, -8.813819e-01, -5.484505e-01},
  {-9.390558e-01, -2.591411e-01, -2.258764e-01, -4.288748e-01, -9.282056e-01, -5.676055e-01},
  {-5.290136e-01, -6.882051e-02, -8.458182e-01, -3.509689e-01, -8.678358e-01, -6.762403e-01},
  {-8.749388e-01, -3.049463e-01, -3.761513e-01, -4.104767e-01, -9.481429e-01, -6.008466e-01},
  {-8.889593e-01, -2.141075e-01, -4.048570e-01, -3.937831e-01, -9.661554e-01, -6.236606e-01},
  {-6.480883e-01, -1.103233e-01, -7.535318e-01, -3.645019e-01, -9.715170e-01, -6.558362e-01},
  {-7.597892e-01, -1.941359e-01, -6.205092e-01, -3.780650e-01, -9.782374e-01, -6.404908e-01},
  {-2.115808e-01, -4.558592e-02, -9.762968e-01, -2.601508e-01, -7.934589e-01, -7.219577e-01},
  { 2.359450e-01, -4.076355e-01,  8.821357e-01,  1.773191e-01, -6.317084e-01,  7.310493e-01},
  {-4.644868e-01, -6.627961e-01,  5.873273e-01,  2.205576e-02, -8.013011e-01,  5.604711e-01},
  { 3.027941e-02, -7.174805e-01,  6.959202e-01,  1.261049e-01, -8.366624e-01,  5.569044e-01},
  {-8.935105e-03, -6.913561e-01,  7.224588e-01,  1.065524e-01, -8.325471e-01,  5.613726e-01},
  {-2.138395e-01, -7.086098e-01,  6.724171e-01,  8.587082e-02, -8.289536e-01,  5.611853e-01},
  {-5.177349e-01, -6.526409e-01,  5.531821e-01,  1.040833e-02, -8.031360e-01,  5.476419e-01},
  { 1.760167e-01, -6.560729e-01,  7.338845e-01,  1.380833e-01, -8.270897e-01,  5.641937e-01},
  { 5.211551e-01, -5.959923e-01,  6.108932e-01,  1.875879e-01, -8.061062e-01,  5.655283e-01},
  { 6.395510e-01, -4.627846e-01,  6.138443e-01,  2.498704e-01, -7.910919e-01,  5.292982e-01},
  { 6.394522e-01, -4.833093e-01,  5.979239e-01,  2.550595e-01, -7.811438e-01,  5.316458e-01},
  {-5.444069e-01, -5.131432e-01,  6.635550e-01, -7.267722e-02, -8.232863e-01,  4.443965e-01},
  {-5.753596e-01, -4.397612e-01,  6.896169e-01, -7.975405e-02, -8.284482e-01,  4.348016e-01},
  { 9.986781e-01,  4.528609e-02,  2.431346e-02,  3.402103e-01, -7.706805e-01,  3.019616e-01},
  { 9.740490e-01, -1.968242e-01,  1.117534e-01,  3.365885e-01, -7.979771e-01,  2.929002e-01},
  { 9.666159e-01, -2.506123e-01,  5.336010e-02,  3.273016e-01, -8.489837e-01,  2.610888e-01},
  {-5.124977e-01, -5.145744e-01,  6.874294e-01, -2.469974e-01, -9.217429e-01,  2.490855e-01},
  { 9.414362e-01, -3.333111e-01,  5.100583e-02,  3.066438e-01, -9.200553e-01,  2.374171e-01},
  {-8.044075e-01, -4.659869e-01,  3.684899e-01, -4.081930e-01, -8.143486e-01,  1.575025e-01},
  {-5.616130e-01, -5.376972e-01,  6.288661e-01, -2.760982e-01, -9.134783e-01,  2.322982e-01},
  { 9.495949e-01, -3.075107e-01, -6.088270e-02,  3.186300e-01, -8.823680e-01,  2.007192e-01},
  {-9.657504e-01, -2.593524e-01,  7.911426e-03, -4.526926e-01, -8.023779e-01, -1.995576e-02},
  {-9.295635e-01, -3.678761e-01,  2.406138e-02, -4.520184e-01, -8.061467e-01, -2.853627e-02},
  { 9.226925e-01, -2.892933e-01, -2.548490e-01,  3.062100e-01, -7.788101e-01, -5.957342e-02},
  { 8.324735e-01, -3.383299e-01, -4.387718e-01,  2.704284e-01, -8.057541e-01, -1.365856e-01},
  {-9.571823e-01, -2.894007e-01,  7.002768e-03, -4.571642e-01, -8.574318e-01, -4.619520e-01},
  {-9.648010e-01, -2.382400e-01, -1.113594e-01, -4.532569e-01, -8.695036e-01, -5.111228e-01},
  { 9.354522e-01,  2.355761e-01, -2.635016e-01,  1.628218e-01, -8.831775e-01, -4.988649e-01},
  { 5.505610e-01,  1.152499e-01, -8.268011e-01,  4.864836e-02, -7.978178e-01, -6.580108e-01},
  { 8.834463e-01,  6.843401e-02, -4.635080e-01,  1.449594e-01, -8.726591e-01, -5.608590e-01},
  { 7.513795e-01,  2.041232e-01, -6.275050e-01,  1.063008e-01, -8.437505e-01, -6.144472e-01},
  { 4.123924e-01,  1.264349e-01, -9.021900e-01, -1.328205e-02, -7.938172e-01, -6.932212e-01},
  {-8.809496e-01, -2.370086e-01, -4.095789e-01, -3.972333e-01, -9.521005e-01, -6.219653e-01},
  {-7.272919e-01, -1.059673e-01, -6.780983e-01, -3.837925e-01, -9.424949e-01, -6.402229e-01},
  { 1.086488e-01, -1.198353e-02, -9.940080e-01, -1.354295e-01, -7.039026e-01, -7.236254e-01},
  {-1.922217e-01,  1.132158e-02, -9.812862e-01, -2.309418e-01, -7.857391e-01, -7.263470e-01},
  { 3.769063e-01, -4.911160e-01,  7.853322e-01,  2.006809e-01, -6.363830e-01,  7.197939e-01},
  { 1.098110e-01, -3.790712e-01,  9.188290e-01,  1.528076e-01, -6.283153e-01,  7.370669e-01},
  { 2.523190e-01, -4.944137e-01,  8.317994e-01,  1.812246e-01, -6.403086e-01,  7.254515e-01},
  { 1.010593e-01, -4.713267e-01,  8.761495e-01,  1.515613e-01, -6.373047e-01,  7.329558e-01},
  {-3.409711e-01, -6.788090e-01,  6.503515e-01,  3.468223e-02, -8.027188e-01,  5.672706e-01},
  { 6.282483e-01, -5.648760e-01,  5.349944e-01,  2.523513e-01, -7.068738e-01,  6.211635e-01},
  {-2.245225e-01, -6.867528e-01,  6.913467e-01,  6.817920e-02, -8.128562e-01,  5.720547e-01},
  { 6.312580e-01, -6.058628e-01,  4.841937e-01,  2.477911e-01, -7.217830e-01,  6.084990e-01},
  {-5.572491e-01, -6.454430e-01,  5.223761e-01, -1.275344e-02, -7.926435e-01,  5.364394e-01},
  { 1.859722e-01, -6.605186e-01,  7.274128e-01,  1.465445e-01, -8.095710e-01,  5.775674e-01},
  {-4.592409e-01, -7.124178e-01,  5.306211e-01, -2.710315e-02, -8.068429e-01,  5.032099e-01},
  { 6.363372e-01, -4.991217e-01,  5.881772e-01,  2.608157e-01, -7.693835e-01,  5.351713e-01},
  { 4.990762e-01, -7.319841e-01,  4.638127e-01,  2.215185e-01, -7.778112e-01,  5.694864e-01},
  {-5.061934e-01, -5.022325e-01,  7.010926e-01, -8.868881e-02, -8.293632e-01,  4.276092e-01},
  {-5.004937e-01, -5.059966e-01,  7.024767e-01, -1.067979e-01, -8.187023e-01,  4.224887e-01},
  { 9.827416e-01, -9.470095e-02,  1.589044e-01,  3.356093e-01, -7.490834e-01,  3.510475e-01},
  { 9.867571e-01, -1.567805e-01,  4.159736e-02,  3.399644e-01, -7.951993e-01,  2.518523e-01},
  {-6.582237e-01, -4.705749e-01,  5.876230e-01, -3.201197e-01, -8.742074e-01,  2.225198e-01},
  {-8.818727e-01, -4.212108e-01,  2.118538e-01, -4.556783e-01, -7.758780e-01,  9.378120e-02},
  {-9.140214e-01, -3.901381e-01,  1.111628e-01, -4.689942e-01, -7.579384e-01,  5.799536e-02},
  {-8.867956e-01, -4.604621e-01,  3.960335e-02, -4.402320e-01, -8.333510e-01, -6.828583e-02},
  {-9.580330e-01, -2.859967e-01, -1.945856e-02, -4.500314e-01, -8.111480e-01, -4.913513e-02},
  {-9.173843e-01, -3.932083e-01,  6.158852e-02, -4.701683e-01, -7.608924e-01,  3.737430e-02},
  { 9.807995e-01, -1.948738e-01, -7.523920e-03,  2.020267e-01, -9.990978e-01, -1.473532e-01},
  { 9.422563e-01, -2.746654e-01, -1.916034e-01,  2.019290e-01, -9.949368e-01, -1.562477e-01},
  { 8.866640e-01, -2.666648e-01, -3.777789e-01,  2.864584e-01, -7.756532e-01, -1.217505e-01},
  { 7.821765e-01, -2.988232e-01, -5.467217e-01,  2.723897e-01, -7.906580e-01, -1.428089e-01},
  {-9.767545e-01, -2.115854e-01, -3.438442e-02, -4.616668e-01, -8.376240e-01, -4.979080e-01},
  { 9.386675e-01,  2.302077e-01, -2.567249e-01,  1.569515e-01, -8.698963e-01, -5.076703e-01},
  {-9.039588e-01, -3.830495e-01, -1.900831e-01, -4.457044e-01, -8.893388e-01, -5.398430e-01},
  {-9.270018e-01, -2.865156e-01, -2.420262e-01, -4.383240e-01, -8.986309e-01, -5.666542e-01},
  {-8.772357e-01, -2.281875e-01, -4.223602e-01, -4.256282e-01, -9.147471e-01, -5.915370e-01},
  {-8.854144e-01, -1.921545e-01, -4.232235e-01, -4.275493e-01, -9.074908e-01, -5.911092e-01},
  {-7.929255e-01, -1.871923e-01, -5.798518e-01, -4.113418e-01, -9.314282e-01, -6.104435e-01},
  {-8.738929e-01, -2.552965e-01, -4.136845e-01, -4.171447e-01, -9.234926e-01, -6.040298e-01},
  { 8.365940e-01,  1.543379e-01, -5.256331e-01,  1.284539e-01, -8.600506e-01, -5.880474e-01},
  { 2.351420e-01,  6.173648e-02, -9.699984e-01, -1.100974e-01, -7.803782e-01, -7.209753e-01},
  { 1.904416e-01,  2.926372e-03, -9.816942e-01, -1.087221e-01, -7.184001e-01, -7.187775e-01},
  { 5.511225e-02,  4.076919e-02, -9.976475e-01, -1.669924e-01, -7.627844e-01, -7.266757e-01},
  { 4.931519e-02,  7.390614e-03, -9.987559e-01, -1.602085e-01, -7.174537e-01, -7.250014e-01},
  {-1.637033e-01,  6.110248e-02, -9.846156e-01, -2.235121e-01, -7.713509e-01, -7.277387e-01},
  {-2.663304e-01, -3.540118e-02, -9.632315e-01, -2.782603e-01, -7.718828e-01, -7.185550e-01},
  { 4.520675e-01, -4.116124e-01,  7.913345e-01,  2.228767e-01, -6.131901e-01,  7.215425e-01},
  { 4.945570e-01, -5.108570e-01,  7.031631e-01,  2.208574e-01, -6.512638e-01,  6.975091e-01},
  {-1.338897e-01, -4.257981e-01,  8.948572e-01,  1.295370e-01, -6.268854e-01,  7.380355e-01},
  { 2.532729e-01, -5.501481e-01,  7.957323e-01,  1.727840e-01, -6.480385e-01,  7.228998e-01},
  { 1.132515e-02, -5.380032e-01,  8.428668e-01,  1.390841e-01, -6.432469e-01,  7.301114e-01},
  { 5.911817e-01, -5.454025e-01,  5.941720e-01,  2.449492e-01, -6.714072e-01,  6.622537e-01},
  { 6.438605e-01, -5.351457e-01,  5.468663e-01,  2.707418e-01, -6.782443e-01,  6.277013e-01},
  {-3.931183e-01, -6.424824e-01,  6.577799e-01,  2.632328e-02, -7.851592e-01,  5.802370e-01},
  {-5.580159e-01, -6.079888e-01,  5.647725e-01, -6.683791e-03, -7.741945e-01,  5.643800e-01},
  {-3.558251e-02, -6.658767e-01,  7.452128e-01,  1.165871e-01, -8.171663e-01,  5.756155e-01},
  {-2.258253e-01, -6.619803e-01,  7.146923e-01,  6.952041e-02, -8.012348e-01,  5.832326e-01},
  { 6.955879e-01, -7.025242e-01,  1.503899e-01,  2.569839e-01, -7.459090e-01,  5.654685e-01},
  { 1.290154e-01, -6.984457e-01,  7.039380e-01,  1.575991e-01, -7.915007e-01,  5.908394e-01},
  { 3.667305e-01, -7.870119e-01,  4.961058e-01,  1.928918e-01, -7.830375e-01,  5.848159e-01},
  { 3.202230e-01, -7.417997e-01,  5.892287e-01,  1.851885e-01, -7.848185e-01,  5.870684e-01},
  { 3.453849e-01, -6.525188e-01,  6.744838e-01,  1.837331e-01, -7.918244e-01,  5.808133e-01},
  {-5.480531e-01, -6.138836e-01,  5.681415e-01, -6.115138e-02, -7.958614e-01,  4.805622e-01},
  {-5.295303e-01, -5.761135e-01,  6.226482e-01, -8.171953e-02, -7.890884e-01,  4.682197e-01},
  {-5.040696e-01, -5.121365e-01,  6.954351e-01, -1.161310e-01, -8.087538e-01,  4.229191e-01},
  {-6.675350e-01, -4.011077e-01,  6.273035e-01, -4.104802e-01, -7.374136e-01,  2.291906e-01},
  {-8.226439e-01, -3.844712e-01,  4.188544e-01, -4.173785e-01, -7.376356e-01,  2.203059e-01},
  {-5.080912e-01, -5.023189e-01,  6.996565e-01, -1.260356e-01, -8.063131e-01,  4.174834e-01},
  {-7.127873e-01, -5.246588e-01,  4.654755e-01, -4.183801e-01, -7.473474e-01,  2.097378e-01},
  {-5.725756e-01, -4.145108e-01,  7.073457e-01, -1.946835e-01, -8.190377e-01,  3.599825e-01},
  {-6.511505e-01, -4.824075e-01,  5.859063e-01, -4.016477e-01, -7.486237e-01,  2.308313e-01},
  {-8.535714e-01, -4.001832e-01,  3.335706e-01, -4.162067e-01, -7.673724e-01,  1.935967e-01},
  {-7.561355e-01, -4.608495e-01,  4.646254e-01, -4.075263e-01, -7.909672e-01,  1.846377e-01},
  {-8.177842e-01, -4.361489e-01,  3.755037e-01, -4.423933e-01, -7.610835e-01,  1.496224e-01},
  { 9.628882e-01, -2.698531e-01,  5.073667e-03,  3.248251e-01, -8.630435e-01,  2.233541e-01},
  {-7.322544e-01, -4.782764e-01,  4.848249e-01, -3.892188e-01, -8.200209e-01,  1.843539e-01},
  {-7.081158e-01, -4.938083e-01,  5.047033e-01, -3.712364e-01, -8.375821e-01,  1.934955e-01},
  { 9.568506e-01, -2.767839e-01, -8.847353e-02,  3.401825e-01, -7.933445e-01,  1.261480e-01},
  { 9.507208e-01, -2.089710e-01, -2.290439e-01,  3.315406e-01, -7.318991e-01, -1.469444e-02},
  { 9.136486e-01, -2.486749e-01, -3.215697e-01,  3.000107e-01, -7.579465e-01, -9.975898e-02},
  {-9.748666e-01, -2.181179e-01,  4.538319e-02, -4.787352e-01, -7.636032e-01, -3.599281e-01},
  {-9.624222e-01, -2.707051e-01, -2.150189e-02, -4.697556e-01, -8.086491e-01, -3.900756e-01},
  { 9.839520e-01,  3.864536e-02, -1.741984e-01,  1.896359e-01, -8.873900e-01, -3.416243e-01},
  { 6.259463e-01,  1.252993e-01, -7.697345e-01,  4.856852e-02, -7.761356e-01, -6.545625e-01},
  {-8.625635e-01, -2.706985e-01, -4.274419e-01, -4.384922e-01, -8.800325e-01, -5.826676e-01},
  { 6.794279e-01,  1.352279e-01, -7.211735e-01,  8.214129e-02, -8.000311e-01, -6.301768e-01},
  {-8.783883e-01, -1.931377e-01, -4.371861e-01, -4.271704e-01, -9.014555e-01, -5.944085e-01},
  { 7.782263e-01,  1.945339e-01, -5.970932e-01,  1.072334e-01, -8.306150e-01, -6.088158e-01},
  { 3.997888e-01,  7.780067e-02, -9.132995e-01, -2.103811e-02, -7.689521e-01, -6.933101e-01},
  {-6.742033e-01, -9.007785e-02, -7.330320e-01, -3.832510e-01, -8.824306e-01, -6.487813e-01},
  {-4.462974e-01, -8.066788e-02, -8.912415e-01, -3.216673e-01, -7.966350e-01, -6.993861e-01},
  {-3.465312e-01, -8.968533e-02, -9.337413e-01, -2.952402e-01, -7.800155e-01, -7.124600e-01},
  { 1.310834e-01,  3.670006e-02, -9.906918e-01, -1.278692e-01, -6.775250e-01, -7.217917e-01},
  { 2.205834e-02,  1.832548e-02, -9.995887e-01, -1.676205e-01, -6.824006e-01, -7.245263e-01},
  {-1.349186e-01,  7.768935e-02, -9.878063e-01, -2.171550e-01, -7.509598e-01, -7.268684e-01},
  {-1.369513e-01,  1.118657e-03, -9.905772e-01, -2.500694e-01, -7.494602e-01, -7.244846e-01},
  { 5.103254e-01, -4.698350e-01,  7.202937e-01,  2.306906e-01, -6.187240e-01,  7.134106e-01},
  { 5.952296e-01, -5.015635e-01,  6.278024e-01,  2.578241e-01, -6.422465e-01,  6.738654e-01},
  { 4.575603e-01, -5.334020e-01,  7.114217e-01,  2.141825e-01, -6.733498e-01,  6.855915e-01},
  { 6.991625e-01, -4.851629e-01,  5.251558e-01,  2.743996e-01, -6.584886e-01,  6.415042e-01},
  { 5.163208e-01, -5.816457e-01,  6.285707e-01,  2.249488e-01, -6.865179e-01,  6.677517e-01},
  { 5.502504e-01, -5.858648e-01,  5.949680e-01,  2.295830e-01, -7.007364e-01,  6.501375e-01},
  { 5.200869e-01, -6.260805e-01,  5.809757e-01,  2.329948e-01, -7.228069e-01,  6.235647e-01},
  { 4.071482e-01, -7.361034e-01,  5.407238e-01,  2.180415e-01, -7.430571e-01,  6.125050e-01},
  {-3.422463e-01, -6.462741e-01,  6.820536e-01,  3.120943e-02, -7.708244e-01,  5.965789e-01},
  { 6.735629e-01, -6.049876e-01,  4.246209e-01,  2.866210e-01, -7.174436e-01,  5.523431e-01},
  { 3.235403e-01, -6.834548e-01,  6.543785e-01,  1.949202e-01, -7.705207e-01,  5.969475e-01},
  { 1.351451e-01, -7.447903e-01,  6.534702e-01,  1.472518e-01, -7.828931e-01,  6.016560e-01},
  {-7.087190e-01, -5.000572e-01,  4.976549e-01, -4.176046e-01, -7.318930e-01,  2.243519e-01},
  {-7.383585e-01, -4.899446e-01,  4.634447e-01, -4.182285e-01, -7.312077e-01,  2.246626e-01},
  {-8.758388e-01, -3.260023e-01,  3.558495e-01, -4.191331e-01, -7.297724e-01,  2.235651e-01},
  {-8.302498e-01, -4.973740e-01,  2.516036e-01, -4.221984e-01, -7.480500e-01,  2.024133e-01},
  {-6.227090e-01, -4.079176e-01,  6.677101e-01, -3.895095e-01, -7.646899e-01,  2.321958e-01},
  {-6.899130e-01, -4.652596e-01,  5.545750e-01, -3.846250e-01, -7.949334e-01,  2.138761e-01},
  { 9.867814e-01, -1.573565e-01,  3.874820e-02,  3.402387e-01, -7.980469e-01,  2.096064e-01},
  {-5.484862e-01, -4.718130e-01,  6.903298e-01, -2.838964e-01, -8.866332e-01,  2.466504e-01},
  { 9.374546e-01, -2.893791e-01, -1.934902e-01,  3.387523e-01, -7.616075e-01,  5.131805e-02},
  { 9.809813e-01, -1.238560e-01, -1.494503e-01,  2.053275e-01, -9.394803e-01, -2.156119e-01},
  {-9.551210e-01, -2.274922e-01, -1.897132e-01, -4.473519e-01, -8.645987e-01, -5.703696e-01},
  {-8.671317e-01, -2.211856e-01, -4.462731e-01, -4.440916e-01, -8.618287e-01, -5.855521e-01},
  {-7.556714e-01, -1.285150e-01, -6.422185e-01, -4.179508e-01, -8.528458e-01, -6.184888e-01},
  { 4.683214e-01,  1.268434e-01, -8.744060e-01,  9.159392e-03, -7.456999e-01, -6.759139e-01},
  {-7.433087e-01, -1.581035e-01, -6.499964e-01, -4.167596e-01, -8.735296e-01, -6.163229e-01},
  { 2.830692e-01,  5.599086e-02, -9.574637e-01, -1.004884e-01, -6.827257e-01, -7.158616e-01},
  {-2.379267e-01,  1.366840e-03, -9.712822e-01, -2.748405e-01, -7.411316e-01, -7.202297e-01},
  { 3.539370e-01, -3.963402e-01,  8.471382e-01,  2.140779e-01, -5.871514e-01,  7.381502e-01},
  { 7.981445e-02, -2.949422e-01,  9.521758e-01,  1.614393e-01, -5.793434e-01,  7.553236e-01},
  {-2.628653e-02, -2.690751e-01,  9.627604e-01,  1.449883e-01, -5.850382e-01,  7.540265e-01},
  {-8.856673e-02, -3.684228e-01,  9.254299e-01,  1.192504e-01, -6.032344e-01,  7.463887e-01},
  {-1.672237e-01, -4.086736e-01,  8.972303e-01,  1.159307e-01, -6.206257e-01,  7.392445e-01},
  {-2.713641e-01, -4.819204e-01,  8.331352e-01,  1.280234e-01, -6.457300e-01,  7.281555e-01},
  { 2.380493e-01, -5.694838e-01,  7.867787e-01,  1.773632e-01, -6.762608e-01,  7.022368e-01},
  { 7.366232e-01, -4.923610e-01,  4.636451e-01,  2.882340e-01, -6.660169e-01,  6.147819e-01},
  { 4.552527e-01, -6.677427e-01,  5.889522e-01,  2.158620e-01, -7.212071e-01,  6.401250e-01},
  { 7.271895e-01, -5.383915e-01,  4.258286e-01,  2.917842e-01, -6.835663e-01,  5.865051e-01},
  { 3.054058e-01, -7.238543e-01,  6.186778e-01,  1.795135e-01, -7.656488e-01,  6.103715e-01},
  {-6.177007e-01, -3.039386e-01,  7.253050e-01, -4.085390e-01, -7.229423e-01,  2.363770e-01},
  {-8.644342e-01, -2.819217e-01,  4.162613e-01, -4.276927e-01, -7.270718e-01,  2.097754e-01},
  {-5.419891e-01, -4.968227e-01,  6.778016e-01, -1.522686e-01, -7.682247e-01,  4.244657e-01},
  {-5.385479e-01, -5.471565e-01,  6.407699e-01, -1.644527e-01, -7.646400e-01,  4.170263e-01},
  {-6.187662e-01, -4.497584e-01,  6.440852e-01, -3.614451e-01, -7.970783e-01,  2.374187e-01},
  {-8.487681e-01, -4.323609e-01,  3.043955e-01, -4.551755e-01, -7.517676e-01,  1.287436e-01},
  {-6.554876e-01, -4.671084e-01,  5.934188e-01, -3.566242e-01, -8.319883e-01,  2.164861e-01},
  {-8.973734e-01, -3.947303e-01,  1.972538e-01, -4.809501e-01, -7.143919e-01,  9.787206e-02},
  {-8.846093e-01, -4.661013e-01, -1.469492e-02, -4.588020e-01, -8.016263e-01, -1.142419e-01},
  {-9.366491e-01, -3.411689e-01,  7.932299e-02, -4.927703e-01, -7.019641e-01,  3.376597e-02},
  { 9.208837e-01, -3.033431e-01, -2.448593e-01,  2.110160e-01, -9.629158e-01, -1.562281e-01},
  {-9.415722e-01, -3.335643e-01,  4.665416e-02, -5.029779e-01, -6.842549e-01, -2.786400e-02},
  { 9.574811e-01, -1.411029e-01, -2.516344e-01,  3.219184e-01, -7.213323e-01, -6.041147e-02},
  {-9.584429e-01, -2.782944e-01,  6.276455e-02, -5.114719e-01, -6.571621e-01, -1.320809e-02},
  { 9.691122e-01, -1.949486e-01, -1.510515e-01,  2.062457e-01, -9.502915e-01, -1.971417e-01},
  { 8.905426e-01, -2.072634e-01, -4.049393e-01,  2.912509e-01, -7.446995e-01, -1.286520e-01},
  {-9.788661e-01, -2.008975e-01, -3.822763e-02, -4.973899e-01, -6.838673e-01, -4.057118e-01},
  { 9.963360e-01, -8.549262e-02,  2.342931e-03,  2.009362e-01, -8.789645e-01, -2.786645e-01},
  {-9.789051e-01, -1.964083e-01, -5.629022e-02, -4.807556e-01, -7.542484e-01, -4.359166e-01},
  {-9.789213e-01, -1.989721e-01, -4.607813e-02, -4.838254e-01, -7.404997e-01, -4.275266e-01},
  {-9.600190e-01, -2.084975e-01, -1.867947e-01, -4.603608e-01, -8.306764e-01, -5.285339e-01},
  {-8.507772e-01, -6.070557e-02, -5.220085e-01, -4.386921e-01, -8.232973e-01, -5.970526e-01},
  {-8.471681e-01, -2.524781e-02, -5.307246e-01, -4.402138e-01, -8.470679e-01, -5.920134e-01},
  { 4.229452e-01,  1.724137e-01, -8.896016e-01,  1.974196e-02, -7.280403e-01, -6.678136e-01},
  {-7.054019e-01, -8.590326e-02, -7.035828e-01, -4.129251e-01, -7.869611e-01, -6.316378e-01},
  {-5.886205e-01, -7.486088e-02, -8.049359e-01, -3.573349e-01, -7.849743e-01, -6.793619e-01},
  { 3.230296e-01,  6.050177e-02, -9.444530e-01, -6.532316e-02, -7.012744e-01, -7.053444e-01},
  { 1.558730e-01,  4.624210e-02, -9.866941e-01, -1.417434e-01, -6.499206e-01, -7.226863e-01},
  {-4.216398e-01, -8.565893e-02, -9.027084e-01, -3.197464e-01, -7.725769e-01, -7.024028e-01},
  { 2.968413e-01, -4.112161e-01,  8.618506e-01,  2.011824e-01, -5.702065e-01,  7.512432e-01},
  { 4.210107e-01, -4.034268e-01,  8.124018e-01,  2.305262e-01, -5.786433e-01,  7.343196e-01},
  { 8.631788e-02, -3.280355e-01,  9.407135e-01,  1.743234e-01, -5.734733e-01,  7.560827e-01},
  { 5.932317e-01, -4.483129e-01,  6.686491e-01,  2.540460e-01, -6.119803e-01,  6.993806e-01},
  { 5.177105e-01, -4.190180e-01,  7.459220e-01,  2.493880e-01, -5.957414e-01,  7.130256e-01},
  {-1.771846e-01, -5.087881e-01,  8.424609e-01,  1.087836e-01, -6.422663e-01,  7.261706e-01},
  { 4.359721e-02, -5.798594e-01,  8.135493e-01,  1.439290e-01, -6.732292e-01,  7.092863e-01},
  {-1.893471e-01, -5.466654e-01,  8.156621e-01,  1.213473e-01, -6.679543e-01,  7.112395e-01},
  { 4.813218e-01, -6.252653e-01,  6.143067e-01,  2.089195e-01, -7.030322e-01,  6.645797e-01},
  {-4.418870e-01, -6.048397e-01,  6.624990e-01,  2.028422e-02, -7.573645e-01,  6.025500e-01},
  {-6.514805e-02, -7.046747e-01,  7.065334e-01,  8.913346e-02, -7.623470e-01,  6.224848e-01},
  {-5.847598e-01, -5.538585e-01,  5.927030e-01, -9.215482e-02, -7.591962e-01,  4.859319e-01},
  {-8.526141e-01, -1.963600e-01,  4.842436e-01, -4.198673e-01, -7.263356e-01,  2.242341e-01},
  {-6.102968e-01, -3.817426e-01,  6.941257e-01, -3.767452e-01, -7.561347e-01,  2.494588e-01},
  {-9.170735e-01, -3.634483e-01,  1.639557e-01, -4.905554e-01, -6.935304e-01,  9.666529e-02},
  { 9.439393e-01, -2.806000e-01, -1.739026e-01,  3.497497e-01, -7.284257e-01,  5.636726e-02},
  {-9.863627e-01, -1.557487e-01,  5.320757e-02, -5.211575e-01, -6.215475e-01, -2.027523e-02},
  {-9.614837e-01, -2.746125e-01, -1.170630e-02, -5.122358e-01, -6.565523e-01, -4.295064e-02},
  {-9.538416e-01, -2.984588e-01, -3.329497e-02, -4.720185e-01, -7.615054e-01, -2.356431e-01},
  {-9.712395e-01, -2.217871e-01,  8.662716e-02, -4.897775e-01, -7.126220e-01, -3.467126e-01},
  { 9.992402e-01, -2.938201e-02, -2.560649e-02,  2.030263e-01, -8.513387e-01, -2.794305e-01},
  {-9.801908e-01, -1.868378e-01, -6.570911e-02, -4.691073e-01, -7.982361e-01, -5.054360e-01},
  {-9.619740e-01, -1.106660e-01, -2.497179e-01, -4.516559e-01, -8.395674e-01, -5.692628e-01},
  {-9.464096e-01,  7.037499e-03, -3.228924e-01, -4.495341e-01, -8.483578e-01, -5.744026e-01},
  {-9.037420e-01, -9.188839e-02, -4.180991e-01, -4.464341e-01, -8.565195e-01, -5.835065e-01},
  {-8.056830e-01,  1.185609e-01, -5.803604e-01, -4.431112e-01, -8.525504e-01, -5.877833e-01},
  {-8.254893e-01,  2.448902e-01, -5.085237e-01, -4.456770e-01, -8.524297e-01, -5.841606e-01},
  {-5.783835e-01, -7.958174e-02, -8.118739e-01, -3.588774e-01, -7.716581e-01, -6.795716e-01},
  { 3.006198e-01,  4.622266e-02, -9.526234e-01, -8.180499e-02, -6.549008e-01, -7.090906e-01},
  {-3.010324e-01,  8.279485e-02, -9.500129e-01, -3.097742e-01, -7.456056e-01, -7.080940e-01},
  {-2.924415e-02,  2.491824e-02, -9.992616e-01, -2.167204e-01, -6.635787e-01, -7.238587e-01},
  {-7.988682e-02,  2.958651e-02, -9.963647e-01, -2.469334e-01, -7.055149e-01, -7.234717e-01},
  { 4.497671e-01, -4.131637e-01,  7.918368e-01,  2.383064e-01, -5.735973e-01,  7.325465e-01},
  { 4.268872e-01, -4.078149e-01,  8.071272e-01,  2.309288e-01, -5.634801e-01,  7.423250e-01},
  { 6.634433e-01, -4.563165e-01,  5.929740e-01,  2.774820e-01, -6.197601e-01,  6.717604e-01},
  { 3.290399e-01, -6.082404e-01,  7.223409e-01,  1.896356e-01, -6.973662e-01,  6.807773e-01},
  { 1.252119e-01, -6.217778e-01,  7.731199e-01,  1.617931e-01, -6.888298e-01,  6.956342e-01},
  {-1.904998e-01, -5.879787e-01,  7.861239e-01,  1.066917e-01, -6.707598e-01,  7.062434e-01},
  {-4.640949e-02, -6.214942e-01,  7.820430e-01,  1.323139e-01, -6.862891e-01,  6.995515e-01},
  { 3.231519e-01, -6.883026e-01,  6.494708e-01,  1.961669e-01, -7.167335e-01,  6.584780e-01},
  { 3.459894e-01, -7.766184e-01,  5.264553e-01,  1.910719e-01, -7.426285e-01,  6.319993e-01},
  {-5.134057e-01, -5.970625e-01,  6.163855e-01, -2.066950e-03, -7.529597e-01,  5.896016e-01},
  {-6.295559e-01, -5.619754e-01,  5.365100e-01, -3.555401e-02, -7.300183e-01,  5.784609e-01},
  {-6.233913e-01, -5.501834e-01,  5.555912e-01, -1.368433e-01, -6.537895e-01,  5.382281e-01},
  {-6.091246e-01, -3.292869e-01,  7.214827e-01, -3.725598e-01, -7.356367e-01,  2.626723e-01},
  {-5.767042e-01, -4.550862e-01,  6.784607e-01, -1.839932e-01, -7.614620e-01,  4.033192e-01},
  {-8.375117e-01, -3.168228e-01,  4.451938e-01, -4.560191e-01, -7.027851e-01,  1.771574e-01},
  {-8.465276e-01, -3.879127e-01,  3.645749e-01, -4.715389e-01, -7.048122e-01,  1.443824e-01},
  {-8.831616e-01, -3.572023e-01,  3.040264e-01, -4.805106e-01, -6.936129e-01,  1.337018e-01},
  { 9.325993e-01, -1.660515e-01, -3.204455e-01,  3.159914e-01, -7.126703e-01, -8.586044e-02},
  { 9.460818e-01, -1.874035e-01, -2.642141e-01,  2.137931e-01, -9.228113e-01, -1.897822e-01},
  {-9.757184e-01, -1.893619e-01, -1.100710e-01, -4.763103e-01, -7.478771e-01, -2.184975e-01},
  {-9.590954e-01, -2.830523e-01,  4.174242e-03, -4.785883e-01, -7.397457e-01, -2.363108e-01},
  {-9.844167e-01, -1.664680e-01, -5.667622e-02, -5.010576e-01, -6.648230e-01, -4.066139e-01},
  { 8.740321e-01, -2.202781e-01, -4.330653e-01,  2.718351e-01, -7.418315e-01, -1.676309e-01},
  {-9.181608e-01, -2.737241e-01, -2.864541e-01, -4.582519e-01, -8.159997e-01, -5.524737e-01},
  {-9.358898e-01, -1.865118e-01, -2.988701e-01, -4.568296e-01, -8.132370e-01, -5.588940e-01},
  {-9.437876e-01, -9.123214e-02, -3.177129e-01, -4.541080e-01, -8.211526e-01, -5.657599e-01},
  {-9.366333e-01, -5.978047e-02, -3.451731e-01, -4.519984e-01, -8.312216e-01, -5.701271e-01},
  { 6.877311e-01,  1.423446e-01, -7.118735e-01,  5.753394e-02, -7.433746e-01, -6.416838e-01},
  { 6.211903e-01,  1.230368e-01, -7.739408e-01,  4.586817e-02, -7.313821e-01, -6.496581e-01},
  {-7.487003e-01, -3.287657e-02, -6.620929e-01, -4.183544e-01, -7.646887e-01, -6.284402e-01},
  { 4.585894e-01,  5.987950e-02, -8.866286e-01, -1.718720e-03, -6.746579e-01, -6.762976e-01},
  { 3.228662e-01,  6.805786e-02, -9.439945e-01, -6.405348e-02, -6.474253e-01, -7.030087e-01},
  {-5.043370e-01, -6.116354e-02, -8.613381e-01, -3.443638e-01, -7.605938e-01, -6.901984e-01},
  {-1.330104e-02,  5.526753e-03, -9.998963e-01, -1.779702e-01, -6.266158e-01, -7.238699e-01},
  {-1.481251e-01,  3.094796e-02, -9.884842e-01, -2.568781e-01, -6.726025e-01, -7.213246e-01},
  {-2.173323e-01,  1.140216e-02, -9.760310e-01, -2.716731e-01, -6.998615e-01, -7.200172e-01},
  {-2.661149e-01,  6.935553e-03, -9.639164e-01, -2.877892e-01, -7.254487e-01, -7.165496e-01},
  { 1.940336e-01, -3.865058e-01,  9.016454e-01,  1.778821e-01, -5.507017e-01,  7.658736e-01},
  {-2.238737e-01, -3.671356e-01,  9.028245e-01,  8.497392e-02, -6.052463e-01,  7.407568e-01},
  {-2.292314e-02, -3.494529e-01,  9.366735e-01,  1.469719e-01, -5.577535e-01,  7.645035e-01},
  { 6.303434e-01, -3.983185e-01,  6.663404e-01,  2.777482e-01, -5.764296e-01,  7.005621e-01},
  {-1.181821e-01, -3.183632e-01,  9.405732e-01,  9.928934e-02, -5.710000e-01,  7.559302e-01},
  { 7.121824e-01, -4.682105e-01,  5.230440e-01,  2.937532e-01, -6.222523e-01,  6.490777e-01},
  {-2.574742e-01, -5.352100e-01,  8.045231e-01,  8.596332e-02, -6.435755e-01,  7.189837e-01},
  {-6.346995e-01, -4.847019e-01,  6.018475e-01, -8.474559e-02, -5.601869e-01,  6.728461e-01},
  { 9.971778e-02, -6.571640e-01,  7.471223e-01,  1.609318e-01, -6.988660e-01,  6.874485e-01},
  { 8.096570e-01, -4.405899e-01,  3.877321e-01,  3.096576e-01, -6.405913e-01,  6.048633e-01},
  {-6.576337e-01, -4.589389e-01,  5.974052e-01, -1.066793e-01, -5.722822e-01,  6.391530e-01},
  { 8.284712e-01, -4.272241e-01,  3.620982e-01,  3.188994e-01, -6.480008e-01,  5.699452e-01},
  { 2.269044e-01, -7.739764e-01,  5.911641e-01,  1.772473e-01, -7.431133e-01,  6.377385e-01},
  { 8.209018e-02, -8.122479e-01,  5.775073e-01,  1.572758e-01, -7.471966e-01,  6.382645e-01},
  {-5.197212e-01, -6.234503e-01,  5.841229e-01, -1.055312e-01, -7.149938e-01,  5.143319e-01},
  {-6.124366e-01, -5.277917e-01,  5.885213e-01, -1.152426e-01, -7.058336e-01,  5.125166e-01},
  {-5.029434e-01, -6.344916e-01,  5.869143e-01, -1.166821e-01, -7.264407e-01,  4.918739e-01},
  {-6.121064e-01, -5.259567e-01,  5.905043e-01, -1.257889e-01, -6.974235e-01,  5.090073e-01},
  {-6.215409e-01, -5.227115e-01,  5.834891e-01, -1.323487e-01, -6.877435e-01,  5.108609e-01},
  {-5.769200e-01, -5.476117e-01,  6.060402e-01, -1.172464e-01, -7.387498e-01,  4.799043e-01},
  {-7.006795e-01, -2.358581e-01,  6.733641e-01, -4.004065e-01, -6.986626e-01,  2.526479e-01},
  {-7.951912e-01, -2.797394e-01,  5.379749e-01, -4.515810e-01, -6.789752e-01,  1.982963e-01},
  {-5.643222e-01, -4.185196e-01,  7.116050e-01, -3.328537e-01, -7.981959e-01,  2.614520e-01},
  {-9.294993e-01, -3.685202e-01,  1.496716e-02, -4.942013e-01, -7.096910e-01, -7.212524e-02},
  {-9.874458e-01, -1.563435e-01, -2.253070e-02, -5.232582e-01, -6.071448e-01, -4.828553e-02},
  { 9.623508e-01, -1.580247e-01, -2.211539e-01,  1.988459e-01, -8.105555e-01, -3.040350e-01},
  { 9.456437e-01, -1.239778e-01, -3.006449e-01,  1.909011e-01, -8.155227e-01, -3.299067e-01},
  {-9.576715e-01, -8.323041e-02, -2.755686e-01, -4.655714e-01, -7.907542e-01, -5.348896e-01},
  {-8.674441e-01, -4.223651e-02, -4.957386e-01, -4.437923e-01, -7.846601e-01, -5.926186e-01},
  {-9.145831e-01,  1.487145e-03, -4.043953e-01, -4.493431e-01, -7.961220e-01, -5.811030e-01},
  { 5.426179e-01,  1.570118e-01, -8.251746e-01,  3.097193e-02, -7.056042e-01, -6.576795e-01},
  {-7.963004e-01, -5.564713e-02, -6.023363e-01, -4.347288e-01, -7.615373e-01, -6.084619e-01},
  { 7.532214e-01,  1.744731e-01, -6.342054e-01,  7.566568e-02, -7.449734e-01, -6.233297e-01},
  { 3.273506e-01,  3.407666e-02, -9.442883e-01, -7.447150e-02, -6.308000e-01, -7.059782e-01},
  {-2.894582e-01,  2.107545e-01, -9.337004e-01, -3.297896e-01, -7.304783e-01, -6.992988e-01},
  { 5.802701e-01, -3.967821e-01,  7.112318e-01,  2.642170e-01, -5.520540e-01,  7.263035e-01},
  {-2.424937e-01, -4.600186e-01,  8.541543e-01,  7.899557e-02, -6.255087e-01,  7.279883e-01},
  { 6.896050e-01, -3.975832e-01,  6.052872e-01,  2.893622e-01, -5.857857e-01,  6.823812e-01},
  {-2.324135e-01, -3.224382e-01,  9.176152e-01,  8.794189e-02, -5.515729e-01,  7.597429e-01},
  {-9.745932e-02, -6.474167e-01,  7.558792e-01,  1.275624e-01, -7.062178e-01,  6.818920e-01},
  { 3.439638e-02, -8.656754e-01,  4.994226e-01,  1.472521e-01, -7.464073e-01,  6.414852e-01},
  {-3.693462e-02, -7.960544e-01,  6.040969e-01,  1.323331e-01, -7.455897e-01,  6.422635e-01},
  {-6.409664e-01, -5.289022e-01,  5.562594e-01, -5.858773e-02, -6.860235e-01,  5.956528e-01},
  {-2.602440e-01, -6.502380e-01,  7.137672e-01,  5.584494e-02, -7.343335e-01,  6.410593e-01},
  { 9.777626e-01, -2.054690e-01,  4.198631e-02,  3.892058e-01, -6.174549e-01,  1.500628e-01},
  { 9.483842e-01, -2.511585e-01,  1.936150e-01,  3.873973e-01, -6.208041e-01,  1.591756e-01},
  {-9.033686e-01, -3.342309e-01,  2.687283e-01, -4.903843e-01, -6.762396e-01,  1.244948e-01},
  { 9.527978e-01, -2.537172e-01, -1.667454e-01,  3.792109e-01, -6.317874e-01,  6.529067e-02},
  { 9.575592e-01, -2.694438e-01, -1.023735e-01,  3.713984e-01, -6.750778e-01,  9.356072e-02},
  {-9.396767e-01, -3.107737e-01,  1.429240e-01, -4.979466e-01, -6.730592e-01,  9.474463e-02},
  { 9.575348e-01, -2.775103e-01, -7.819942e-02,  3.596690e-01, -7.176228e-01,  9.978862e-02},
  { 9.242249e-01, -2.531460e-01, -2.858767e-01,  3.555363e-01, -6.487114e-01, -1.860300e-02},
  {-9.816887e-01, -1.597429e-01,  1.037763e-01, -5.168047e-01, -6.242660e-01,  1.802490e-02},
  { 9.087574e-01, -2.061512e-01, -3.628520e-01,  3.358844e-01, -6.447759e-01, -7.700206e-02},
  {-9.787203e-01,  1.820552e-01, -9.467034e-02, -5.031927e-01, -6.486754e-01, -4.095508e-01},
  {-9.289560e-01, -5.507690e-02, -3.660703e-01, -4.531866e-01, -8.068065e-01, -5.715657e-01},
  { 6.371437e-01,  9.439450e-02, -7.649428e-01,  3.247671e-02, -6.854504e-01, -6.539469e-01},
  {-7.537568e-01, -1.824663e-01, -6.313135e-01, -4.301943e-01, -7.212336e-01, -6.194341e-01},
  { 8.081411e-01,  2.087399e-01, -5.507590e-01,  9.097261e-02, -7.544791e-01, -6.059640e-01},
  {-6.989823e-01, -3.171391e-01, -6.409731e-01, -4.479350e-01, -5.914739e-01, -6.261528e-01},
  {-5.930319e-01, -2.409962e-01, -7.682668e-01, -4.511064e-01, -5.766107e-01, -6.267342e-01},
  {-5.762559e-01, -2.017095e-01, -7.919863e-01, -4.422699e-01, -5.803362e-01, -6.336478e-01},
  {-6.723932e-01, -2.906244e-01, -6.807532e-01, -4.515393e-01, -5.713053e-01, -6.279974e-01},
  {-8.101060e-01, -5.373965e-02, -5.838152e-01, -4.542451e-01, -5.668129e-01, -6.262506e-01},
  {-5.073888e-01, -1.822952e-02, -8.615245e-01, -4.502825e-01, -5.672423e-01, -6.293439e-01},
  {-7.409537e-01, -1.041745e-01, -6.634269e-01, -4.533989e-01, -5.681599e-01, -6.275769e-01},
  {-6.695899e-01, -6.254053e-02, -7.400933e-01, -4.128739e-01, -6.074593e-01, -6.549956e-01},
  {-6.352291e-01, -9.412646e-02, -7.665665e-01, -4.213499e-01, -5.911664e-01, -6.494225e-01},
  {-5.555244e-01, -7.926834e-02, -8.277131e-01, -4.054123e-01, -6.165650e-01, -6.598252e-01},
  {-4.011164e-01, -4.472932e-03, -9.160162e-01, -3.158828e-01, -7.052576e-01, -7.061915e-01},
  { 3.433228e-01, -4.144719e-01,  8.428183e-01,  2.227577e-01, -5.343404e-01,  7.604466e-01},
  { 7.570363e-01, -3.882104e-01,  5.255368e-01,  2.982920e-01, -5.907267e-01,  6.676838e-01},
  { 7.386696e-01, -3.431450e-01,  5.801885e-01,  2.964717e-01, -5.471499e-01,  6.974713e-01},
  {-6.502295e-01, -3.751619e-01,  6.606476e-01, -9.013204e-02, -5.374393e-01,  6.821855e-01},
  { 7.985455e-01, -4.062831e-01,  4.441386e-01,  3.131039e-01, -6.099625e-01,  6.296435e-01},
  {-5.377401e-01, -5.897839e-01,  6.024869e-01, -6.583064e-02, -5.795542e-01,  6.761783e-01},
  {-6.882429e-01, -3.623240e-01,  6.285246e-01, -1.187570e-01, -5.323655e-01,  6.548385e-01},
  {-2.476193e-01, -5.803751e-01,  7.757896e-01,  8.509526e-02, -6.761649e-01,  6.960889e-01},
  { 1.003966e-01, -7.125521e-01,  6.943991e-01,  1.511827e-01, -7.244798e-01,  6.652388e-01},
  {-2.112471e-01, -6.040546e-01,  7.684352e-01,  8.823925e-02, -7.045110e-01,  6.755576e-01},
  {-6.745640e-01, -4.424163e-01,  5.909578e-01, -1.676849e-01, -5.696830e-01,  5.723416e-01},
  {-1.469110e-01, -6.734802e-01,  7.244595e-01,  8.985444e-02, -7.337208e-01,  6.505622e-01},
  {-5.593412e-01, -5.527620e-01,  6.177310e-01, -2.622778e-02, -7.056599e-01,  6.115215e-01},
  {-9.333819e-01, -3.479178e-02,  3.571943e-01, -5.038726e-01, -5.720302e-01,  1.454204e-01},
  {-9.764744e-01,  9.442517e-04,  2.156314e-01, -5.090274e-01, -5.584575e-01,  1.292428e-01},
  {-5.675771e-01, -3.080398e-01,  7.635232e-01, -3.189400e-01, -7.096508e-01,  3.211423e-01},
  {-8.675580e-01, -2.831663e-01,  4.088520e-01, -4.858979e-01, -6.628788e-01,  1.478919e-01},
  {-9.600540e-01, -7.503156e-02,  2.695675e-01, -5.073773e-01, -5.813930e-01,  1.325907e-01},
  {-9.907876e-01, -1.301344e-01,  3.748479e-02, -5.096499e-01, -6.130217e-01,  1.135261e-01},
  {-9.421554e-01, -2.351024e-01,  2.388937e-01, -5.042830e-01, -6.363809e-01,  1.195449e-01},
  {-9.304085e-01, -2.821342e-01,  2.339664e-01, -4.996556e-01, -6.513662e-01,  1.210346e-01},
  {-9.776698e-01, -1.573793e-01,  1.392599e-01, -5.076172e-01, -6.251541e-01,  1.158996e-01},
  {-9.961594e-01, -8.410937e-02,  2.433428e-02, -5.123901e-01, -5.883669e-01,  1.053152e-01},
  {-9.730600e-01, -2.115928e-01,  9.155775e-02, -5.069480e-01, -6.380103e-01,  9.867945e-02},
  {-9.742640e-01, -2.059493e-01,  9.162153e-02, -5.068087e-01, -6.404940e-01,  9.266685e-02},
  {-9.690203e-01, -2.297749e-01,  9.057054e-02, -5.111771e-01, -6.389115e-01,  4.740564e-02},
  { 9.024032e-01, -2.488043e-01, -3.518023e-01,  3.548022e-01, -6.116105e-01, -5.203455e-02},
  {-9.691945e-01, -2.373948e-01, -6.561857e-02, -5.031331e-01, -6.813052e-01, -1.101771e-01},
  { 8.627336e-01, -2.590037e-01, -4.342901e-01,  3.308071e-01, -6.246378e-01, -1.007033e-01},
  { 8.795511e-01, -1.872807e-01, -4.373967e-01,  3.088789e-01, -6.554569e-01, -1.309212e-01},
  {-9.893721e-01, -5.749071e-02, -1.335574e-01, -4.964613e-01, -6.519297e-01, -4.606356e-01},
  {-9.794508e-01, -1.622840e-01, -1.197499e-01, -4.818814e-01, -7.187688e-01, -4.967413e-01},
  {-8.905942e-01, -8.258840e-02, -4.472372e-01, -4.538385e-01, -7.527862e-01, -5.781399e-01},
  {-8.187668e-01, -1.387298e-01, -5.571131e-01, -4.402233e-01, -7.253062e-01, -6.060200e-01},
  { 7.353132e-01,  9.176190e-02, -6.714865e-01,  7.443377e-02, -7.048484e-01, -6.145537e-01},
  {-7.671372e-01, -1.249572e-01, -6.291949e-01, -4.439096e-01, -6.511132e-01, -6.155913e-01},
  {-7.691118e-01, -2.626232e-01, -5.826628e-01, -4.572553e-01, -5.863301e-01, -6.158456e-01},
  { 9.120653e-01,  1.744633e-01, -3.710788e-01,  1.168648e-01, -7.655800e-01, -5.659987e-01},
  { 4.620518e-01,  6.429759e-02, -8.845190e-01, -3.072249e-02, -6.315730e-01, -6.889501e-01},
  {-6.746052e-01, -9.879892e-02, -7.315371e-01, -3.862596e-01, -7.267539e-01, -6.629069e-01},
  {-6.694205e-01, -1.068562e-01, -7.351584e-01, -4.014381e-01, -6.940318e-01, -6.532915e-01},
  {-7.304780e-01, -8.220338e-02, -6.779709e-01, -4.297356e-01, -6.353884e-01, -6.349856e-01},
  { 3.089612e-01,  2.061665e-02, -9.508512e-01, -8.028600e-02, -6.057308e-01, -7.071261e-01},
  { 1.573931e-01,  2.404521e-03, -9.875331e-01, -1.387241e-01, -5.869592e-01, -7.206282e-01},
  {-1.511441e-01,  1.315481e-02, -9.884242e-01, -2.620055e-01, -6.132258e-01, -7.193615e-01},
  { 5.716283e-01, -4.002820e-01,  7.162509e-01,  2.690545e-01, -5.335892e-01,  7.330166e-01},
  {-2.862910e-01, -3.998888e-01,  8.707045e-01,  7.470042e-02, -6.080781e-01,  7.368793e-01},
  {-9.508542e-02, -3.153527e-01,  9.441988e-01,  1.246168e-01, -5.224081e-01,  7.757957e-01},
  {-5.928460e-01, -3.892310e-01,  7.050056e-01, -7.251307e-02, -5.496188e-01,  6.915967e-01},
  { 7.953166e-01, -2.824970e-01,  5.363458e-01,  3.078548e-01, -5.574661e-01,  6.762178e-01},
  { 8.228693e-01, -3.103757e-01,  4.759759e-01,  3.130892e-01, -5.652416e-01,  6.634519e-01},
  {-6.825264e-01, -2.759685e-01,  6.767563e-01, -1.078323e-01, -5.186301e-01,  6.745156e-01},
  { 8.876050e-01, -3.337527e-01,  3.174375e-01,  3.269591e-01, -6.069180e-01,  6.007347e-01},
  { 9.054645e-01, -3.684927e-01,  2.105877e-01,  3.266139e-01, -6.201600e-01,  5.847173e-01},
  {-8.747897e-02, -6.846690e-01,  7.235853e-01,  1.089933e-01, -7.236310e-01,  6.636391e-01},
  {-1.419106e-01, -6.770860e-01,  7.220914e-01,  1.018396e-01, -7.257011e-01,  6.606795e-01},
  {-5.843603e-01, -6.015540e-01,  5.446612e-01, -1.688420e-01, -6.554580e-01,  4.999586e-01},
  {-7.281500e-01, -2.726932e-01,  6.288371e-01, -4.235067e-01, -6.485587e-01,  2.491054e-01},
  {-8.433169e-01, -2.398193e-01,  4.809400e-01, -4.654180e-01, -6.279927e-01,  2.042552e-01},
  {-9.039973e-01, -7.531643e-02,  4.208518e-01, -4.936016e-01, -5.835415e-01,  1.696250e-01},
  {-9.105328e-01, -1.574820e-01,  3.822688e-01, -4.961942e-01, -6.078674e-01,  1.550245e-01},
  {-9.022264e-01, -2.091410e-01,  3.771571e-01, -4.975668e-01, -6.303340e-01,  1.418657e-01},
  { 9.691133e-01, -2.389751e-01, -6.091245e-02,  3.868609e-01, -6.236179e-01,  1.136733e-01},
  { 9.470665e-01, -2.897389e-01,  1.382621e-01,  3.770108e-01, -6.638049e-01,  1.457779e-01},
  {-6.281340e-01, -4.437414e-01,  6.391723e-01, -2.711343e-01, -6.846622e-01,  3.798267e-01},
  {-9.964842e-01, -4.317256e-02,  7.180101e-02, -5.155626e-01, -5.646471e-01,  6.773873e-02},
  { 9.329193e-01, -2.539690e-01, -2.552673e-01,  3.786692e-01, -5.836875e-01, -2.289526e-03},
  {-9.972300e-01, -2.501503e-02,  7.004700e-02, -5.256011e-01, -5.675803e-01, -3.126798e-02},
  {-9.758148e-01, -1.933220e-01, -1.020394e-01, -4.873982e-01, -7.191069e-01, -1.755186e-01},
  { 7.870777e-01, -3.106635e-01, -5.329135e-01,  3.227583e-01, -6.068268e-01, -1.243815e-01},
  {-9.950444e-01, -9.927092e-02,  5.649851e-03, -5.046784e-01, -6.376112e-01, -3.380450e-01},
  { 9.169062e-01, -1.469524e-01, -3.710634e-01,  1.885744e-01, -7.698351e-01, -3.402827e-01},
  {-9.713015e-01, -1.296524e-01, -1.994081e-01, -4.764344e-01, -7.319829e-01, -5.188965e-01},
  {-9.221860e-01, -9.687126e-02, -3.744182e-01, -4.645634e-01, -7.405108e-01, -5.570943e-01},
  {-9.748220e-01, -6.682819e-02, -2.127346e-01, -5.021393e-01, -5.253365e-01, -5.197535e-01},
  { 8.423616e-01,  1.197958e-01, -5.254292e-01,  1.116435e-01, -7.373484e-01, -5.648176e-01},
  {-6.024051e-01, -3.544420e-02, -7.974031e-01, -4.226998e-01, -5.392439e-01, -6.519022e-01},
  {-6.556327e-01,  2.430363e-02, -7.546887e-01, -4.478036e-01, -5.483259e-01, -6.304313e-01},
  {-4.369249e-01,  9.914205e-02, -8.940176e-01, -3.547374e-01, -7.102813e-01, -6.858166e-01},
  { 3.281468e-01, -4.053957e-01,  8.532140e-01,  2.291557e-01, -5.145923e-01,  7.672436e-01},
  { 5.800818e-01, -3.708171e-01,  7.252584e-01,  2.709729e-01, -5.115755e-01,  7.434510e-01},
  { 1.666795e-03, -3.546171e-01,  9.350101e-01,  1.711752e-01, -5.131247e-01,  7.813472e-01},
  { 6.881773e-01, -3.675970e-01,  6.255273e-01,  2.887373e-01, -5.203741e-01,  7.220305e-01},
  {-4.223220e-01, -5.649820e-01,  7.088296e-01, -4.752909e-02, -5.775263e-01,  6.927730e-01},
  { 8.049497e-01, -3.474878e-01,  4.809451e-01,  3.139004e-01, -5.401345e-01,  6.769043e-01},
  { 8.631079e-01, -3.073875e-01,  4.006964e-01,  3.211328e-01, -5.730450e-01,  6.424900e-01},
  {-3.392123e-01, -5.321291e-01,  7.757407e-01,  4.432780e-02, -6.506798e-01,  6.973997e-01},
  {-5.659326e-01, -5.066220e-01,  6.504263e-01, -3.997407e-02, -6.118641e-01,  6.729530e-01},
  {-6.569121e-01, -3.049207e-01,  6.895577e-01, -1.274233e-01, -4.997623e-01,  6.642638e-01},
  {-3.152006e-01, -5.456814e-01,  7.764537e-01,  5.452682e-02, -7.009222e-01,  6.677657e-01},
  { 9.480813e-01, -2.964686e-01,  1.151014e-01,  3.379171e-01, -6.053810e-01,  5.515857e-01},
  { 9.651069e-01, -2.002590e-01,  1.687158e-01,  3.461570e-01, -5.686426e-01,  5.619167e-01},
  {-2.826302e-01, -6.109727e-01,  7.394813e-01,  4.453263e-02, -7.156310e-01,  6.528056e-01},
  { 9.788367e-01, -1.323369e-01,  1.560950e-01,  3.568316e-01, -5.287700e-01,  5.425262e-01},
  {-4.079735e-01, -5.546622e-01,  7.251947e-01,  1.871450e-02, -7.123852e-01,  6.418130e-01},
  {-8.608160e-01, -1.701053e-01,  4.796458e-01, -4.813354e-01, -6.008425e-01,  1.881148e-01},
  {-6.008753e-01, -2.875997e-01,  7.458118e-01, -3.473634e-01, -6.752355e-01,  3.131555e-01},
  {-9.766821e-01,  6.084333e-02,  2.058888e-01, -5.091538e-01, -5.237209e-01,  1.207347e-01},
  {-6.478356e-01, -3.621334e-01,  6.702003e-01, -3.450437e-01, -6.723896e-01,  3.168079e-01},
  {-6.532585e-01, -3.623271e-01,  6.648101e-01, -3.383935e-01, -6.751936e-01,  3.217455e-01},
  { 9.826149e-01, -1.813820e-01, -3.960272e-02,  3.926745e-01, -5.974590e-01,  1.200425e-01},
  { 9.557091e-01, -2.882909e-01,  5.923255e-02,  3.714746e-01, -6.832236e-01,  1.410699e-01},
  {-9.915665e-01,  9.471958e-02,  8.845367e-02, -5.121710e-01, -5.044699e-01,  8.697224e-02},
  {-9.946939e-01,  6.772965e-02,  7.743821e-02, -5.133053e-01, -5.214617e-01,  9.194826e-02},
  {-9.932843e-01,  1.019316e-02,  1.152495e-01, -5.140246e-01, -5.452713e-01,  9.721701e-02},
  {-9.670846e-01,  2.538307e-01,  1.781544e-02, -5.013684e-01, -4.251279e-01,  4.036711e-02},
  { 9.057201e-01, -2.402647e-01, -3.492050e-01,  3.729602e-01, -5.487282e-01, -4.964801e-02},
  {-9.973863e-01, -7.052565e-02, -1.569960e-02, -5.260375e-01, -5.781186e-01, -6.201566e-02},
  { 8.706889e-01, -1.958977e-01, -4.511375e-01,  3.359433e-01, -5.766892e-01, -1.127148e-01},
  { 8.245009e-01, -1.973011e-01, -5.303495e-01,  3.086902e-01, -5.895287e-01, -1.535423e-01},
  { 9.560745e-01,  5.493882e-02, -2.879293e-01,  1.664698e-01, -7.554952e-01, -4.081326e-01},
  { 9.484732e-01,  7.018691e-02, -3.089859e-01,  1.379720e-01, -7.450910e-01, -4.989106e-01},
  { 6.600457e-01,  9.415194e-02, -7.453020e-01,  3.215608e-02, -6.304468e-01, -6.474067e-01},
  { 6.217414e-01,  8.083776e-02, -7.790397e-01,  5.288376e-03, -6.062402e-01, -6.666816e-01},
  {-8.577690e-01, -1.304267e-01, -4.972134e-01, -4.605955e-01, -6.618637e-01, -5.885971e-01},
  {-8.745450e-01, -1.537049e-01, -4.599412e-01, -4.673445e-01, -6.204625e-01, -5.892133e-01},
  {-7.539963e-01, -1.859153e-01, -6.300199e-01, -4.605145e-01, -6.375681e-01, -5.958056e-01},
  { 7.909047e-01, -1.585444e-02, -6.117340e-01,  8.908498e-02, -7.141126e-01, -5.965801e-01},
  {-6.444547e-01, -5.546767e-02, -7.626280e-01, -4.238886e-01, -5.162604e-01, -6.528503e-01},
  {-8.220018e-01, -2.906352e-03, -5.694773e-01, -4.642387e-01, -5.475466e-01, -6.100532e-01},
  {-7.656896e-01,  1.027830e-01, -6.349450e-01, -4.557821e-01, -5.350723e-01, -6.212112e-01},
  { 3.267881e-01, -6.223036e-02, -9.430466e-01, -8.687599e-02, -5.436438e-01, -7.088854e-01},
  {-2.607819e-01,  2.617262e-02, -9.650429e-01, -2.909706e-01, -6.246030e-01, -7.135929e-01},
  { 5.040110e-01, -3.920806e-01,  7.695750e-01,  2.550149e-01, -4.981447e-01,  7.616240e-01},
  { 1.781260e-01, -3.751500e-01,  9.096888e-01,  1.972485e-01, -5.091190e-01,  7.793925e-01},
  {-5.024884e-01, -4.459056e-01,  7.407250e-01, -5.606446e-02, -5.588427e-01,  6.993041e-01},
  {-4.371961e-01, -4.918442e-01,  7.529600e-01, -2.323246e-02, -5.794919e-01,  7.054233e-01},
  { 8.090511e-01, -2.980172e-01,  5.065787e-01,  3.152375e-01, -5.175119e-01,  6.874833e-01},
  { 8.927150e-01, -2.434334e-01,  3.792098e-01,  3.248147e-01, -5.231453e-01,  6.671133e-01},
  { 8.667043e-01, -2.684268e-01,  4.204412e-01,  3.282953e-01, -5.477920e-01,  6.442949e-01},
  { 9.322307e-01, -2.290280e-01,  2.801648e-01,  3.355257e-01, -5.808802e-01,  5.997701e-01},
  { 9.439824e-01, -2.566546e-01,  2.074263e-01,  3.393964e-01, -5.832893e-01,  5.827739e-01},
  {-6.195746e-01, -4.991851e-01,  6.057571e-01, -8.489403e-02, -6.454677e-01,  6.031904e-01},
  {-6.725535e-01, -4.489757e-01,  5.882964e-01, -2.094876e-01, -5.804471e-01,  5.158815e-01},
  {-7.730379e-01, -2.326405e-01,  5.901617e-01, -4.379584e-01, -6.250196e-01,  2.428001e-01},
  {-8.083088e-01, -5.808678e-02,  5.858862e-01, -4.624030e-01, -5.889218e-01,  2.227420e-01},
  {-8.018872e-01, -9.276443e-02,  5.902301e-01, -4.344923e-01, -5.992984e-01,  2.550892e-01},
  { 9.786125e-01, -1.665886e-01,  1.206889e-01,  3.927450e-01, -5.837953e-01,  1.693095e-01},
  {-9.799850e-01,  1.202831e-01,  1.586235e-01, -5.076421e-01, -4.866169e-01,  1.085146e-01},
  {-6.612729e-01, -3.537470e-01,  6.614991e-01, -3.380322e-01, -6.680936e-01,  3.257767e-01},
  {-9.794346e-01,  1.840492e-01,  8.266552e-02, -5.062696e-01, -4.623702e-01,  8.471254e-02},
  {-9.435414e-01,  3.290086e-01,  3.850942e-02, -4.913072e-01, -3.936972e-01,  3.211142e-02},
  { 9.580100e-01, -2.379087e-01, -1.600508e-01,  3.939187e-01, -5.501664e-01,  2.457198e-02},
  {-9.424753e-01,  3.054342e-01,  1.358321e-01, -4.912311e-01, -3.903402e-01,  1.998466e-02},
  { 8.799337e-01, -2.251165e-01, -4.183769e-01,  3.811662e-01, -5.186398e-01, -4.984892e-02},
  { 8.502973e-01, -1.800891e-01, -4.945324e-01,  3.481207e-01, -5.318513e-01, -1.076902e-01},
  {-9.635370e-01, -1.457672e-01, -2.243843e-01, -4.843312e-01, -6.695986e-01, -5.200699e-01},
  {-9.153677e-01, -1.501389e-01, -3.735777e-01, -4.618007e-01, -6.893222e-01, -5.784243e-01},
  { 4.774386e-01,  3.653521e-02, -8.779051e-01,  3.258013e-04, -5.865248e-01, -6.687993e-01},
  {-8.675902e-01, -1.671622e-01, -4.683418e-01, -4.744168e-01, -5.823596e-01, -5.876662e-01},
  {-8.523478e-01,  2.004858e-01, -4.830204e-01, -4.693312e-01, -5.405660e-01, -6.027170e-01},
  {-5.287298e-01, -3.632418e-02, -8.480126e-01, -3.684265e-01, -6.890963e-01, -6.781055e-01},
  {-5.225197e-01, -4.219870e-02, -8.515823e-01, -3.900332e-01, -5.779622e-01, -6.718914e-01},
  {-4.297065e-02, -3.787601e-02, -9.983582e-01, -2.460768e-01, -5.303963e-01, -7.239372e-01},
  {-1.521764e-01, -3.923883e-02, -9.875742e-01, -2.739537e-01, -5.705602e-01, -7.180949e-01},
  {-4.181868e-01, -1.014494e-02, -9.083044e-01, -3.271731e-01, -6.470612e-01, -7.010995e-01},
  {-3.043635e-01,  1.653619e-02, -9.524125e-01, -3.075847e-01, -6.720450e-01, -7.106251e-01},
  { 3.919587e-01, -3.973243e-01,  8.297602e-01,  2.383642e-01, -4.868845e-01,  7.764702e-01},
  { 6.538758e-01, -3.512764e-01,  6.701129e-01,  2.898573e-01, -5.020013e-01,  7.313252e-01},
  {-4.798793e-01, -3.085640e-01,  8.212819e-01, -5.799146e-02, -5.503122e-01,  7.023172e-01},
  {-3.376400e-01, -3.212184e-01,  8.847700e-01,  2.672475e-02, -5.672956e-01,  7.356394e-01},
  {-5.799158e-01, -2.696174e-01,  7.687680e-01, -7.317590e-02, -5.361650e-01,  6.969803e-01},
  {-6.556998e-01, -3.260837e-01,  6.809751e-01, -1.747422e-01, -4.693817e-01,  6.301038e-01},
  {-7.042775e-01, -3.824689e-01,  5.980892e-01, -1.921586e-01, -5.029071e-01,  5.895116e-01},
  {-4.233339e-01, -4.851588e-01,  7.651204e-01,  8.968338e-03, -6.290142e-01,  6.943557e-01},
  { 9.291558e-01, -2.332969e-01,  2.867788e-01,  3.378860e-01, -5.608255e-01,  6.083007e-01},
  { 9.389200e-01, -1.899822e-01,  2.869427e-01,  3.397119e-01, -5.394335e-01,  6.190727e-01},
  {-5.564219e-01, -5.244389e-01,  6.444831e-01, -1.497809e-02, -6.847793e-01,  6.400198e-01},
  {-7.940361e-01, -2.069070e-01,  5.715733e-01, -4.567298e-01, -6.097397e-01,  2.257672e-01},
  {-6.017622e-01, -5.377041e-01,  5.905561e-01, -1.929003e-01, -6.554419e-01,  4.741681e-01},
  {-8.735348e-01, -4.923729e-02,  4.842651e-01, -4.781980e-01, -5.751914e-01,  2.004087e-01},
  { 9.590289e-01, -2.582736e-01,  1.164401e-01,  3.601788e-01, -6.123164e-01,  3.286271e-01},
  {-9.861000e-01,  1.436410e-01,  8.351063e-02, -5.221112e-01, -5.228825e-01, -1.048841e-02},
  { 9.124755e-01, -7.486261e-02, -4.022241e-01,  4.086554e-01, -4.207450e-01, -3.838773e-02},
  { 9.030537e-01, -2.063949e-01, -3.766895e-01,  4.010232e-01, -4.540589e-01, -4.185047e-02},
  {-9.944296e-01,  6.200841e-02,  8.523307e-02, -5.250112e-01, -5.172986e-01, -3.724369e-02},
  { 8.623144e-01, -1.639784e-01, -4.790877e-01,  3.868842e-01, -4.443811e-01, -7.499420e-02},
  { 8.504922e-01, -1.956696e-01, -4.882379e-01,  3.792295e-01, -4.581667e-01, -8.291518e-02},
  {-9.848064e-01, -1.642888e-01, -5.626278e-02, -5.175166e-01, -6.093478e-01, -1.356596e-01},
  { 8.610200e-01, -1.246407e-01, -4.930612e-01,  3.897198e-01, -4.255976e-01, -7.542688e-02},
  { 8.327339e-01, -1.840345e-01, -5.221930e-01,  3.631794e-01, -4.862075e-01, -9.880206e-02},
  { 8.326782e-01, -1.711754e-01, -5.266364e-01,  3.510750e-01, -5.020077e-01, -1.129169e-01},
  { 9.343364e-01, -1.031745e-02, -3.562430e-01,  1.577934e-01, -7.137305e-01, -4.282542e-01},
  { 5.902270e-01,  4.148433e-02, -8.061706e-01, -5.815983e-03, -5.668019e-01, -6.718767e-01},
  { 4.319969e-01, -4.606826e-02, -9.006978e-01, -3.499010e-02, -5.604184e-01, -6.881024e-01},
  {-7.658017e-01, -2.677393e-02, -6.425192e-01, -4.729386e-01, -5.060340e-01, -6.009561e-01},
  {-8.564091e-01, -2.753649e-02, -5.155631e-01, -4.819274e-01, -4.984871e-01, -5.911720e-01},
  {-3.187653e-01, -1.094327e-01, -9.414952e-01, -3.044152e-01, -5.890742e-01, -7.101141e-01},
  {-3.035022e-01, -9.685220e-03, -9.527816e-01, -3.086250e-01, -6.057716e-01, -7.083923e-01},
  {-4.218421e-01, -5.405895e-02, -9.050562e-01, -3.381212e-01, -6.238621e-01, -6.968234e-01},
  { 3.546707e-01, -3.997295e-01,  8.452367e-01,  2.390301e-01, -4.699176e-01,  7.842034e-01},
  { 6.832536e-01, -3.397340e-01,  6.463322e-01,  2.822692e-01, -4.859104e-01,  7.477218e-01},
  { 7.469028e-01, -3.046903e-01,  5.910162e-01,  3.070737e-01, -4.829799e-01,  7.208439e-01},
  {-1.930361e-01, -3.122487e-01,  9.301816e-01,  8.537819e-02, -4.851520e-01,  7.822546e-01},
  {-4.210325e-01, -2.993912e-01,  8.562106e-01,  1.864537e-03, -5.491418e-01,  7.306775e-01},
  {-4.943972e-01, -2.039774e-01,  8.449642e-01, -6.623042e-02, -5.111906e-01,  7.078795e-01},
  {-6.306521e-01, -2.364551e-01,  7.391663e-01, -1.063430e-01, -4.909114e-01,  6.853207e-01},
  { 9.573838e-01, -1.940782e-01,  2.138923e-01,  3.573578e-01, -5.020527e-01,  5.801197e-01},
  {-4.701130e-01, -5.413899e-01,  6.970586e-01,  4.677299e-03, -6.874635e-01,  6.526558e-01},
  { 9.729065e-01, -1.841482e-01,  1.397942e-01,  3.696316e-01, -4.507291e-01,  5.570009e-01},
  {-6.874614e-01, -4.069101e-01,  6.015156e-01, -2.299046e-01, -5.788248e-01,  4.937806e-01},
  {-9.115209e-01, -1.544049e-02,  4.109639e-01, -4.891319e-01, -5.375809e-01,  1.844760e-01},
  {-9.635939e-01,  2.436109e-02,  2.662581e-01, -4.978105e-01, -5.101283e-01,  1.613081e-01},
  { 9.301379e-01, -2.167680e-01,  2.964036e-01,  3.659917e-01, -6.176216e-01,  2.753136e-01},
  { 9.827881e-01, -1.845989e-01,  7.120279e-03,  4.009644e-01, -5.499898e-01,  1.245074e-01},
  { 9.720024e-01, -2.238994e-01, -7.127503e-02,  4.073972e-01, -5.097188e-01,  5.152194e-02},
  { 9.405910e-01, -2.395811e-01, -2.406023e-01,  4.017545e-01, -4.922389e-01, -1.178034e-02},
  {-9.992509e-01,  1.667283e-02,  3.492247e-02, -5.271859e-01, -5.472474e-01, -5.966295e-02},
  {-9.764718e-01, -1.970928e-01, -8.750565e-02, -5.159381e-01, -6.075562e-01, -1.719202e-01},
  {-9.879405e-01, -1.516829e-01, -3.107820e-02, -5.164797e-01, -5.575954e-01, -3.578644e-01},
  {-9.822870e-01, -1.104515e-01, -1.513696e-01, -5.047681e-01, -5.520061e-01, -4.838566e-01},
  {-9.299019e-01, -1.684319e-01, -3.269759e-01, -4.775203e-01, -6.656639e-01, -5.493428e-01},
  {-9.727327e-01, -4.271714e-02, -2.279614e-01, -5.063107e-01, -4.906338e-01, -5.019100e-01},
  { 9.332170e-01,  4.085846e-02, -3.569826e-01,  1.487207e-01, -7.033906e-01, -4.527894e-01},
  { 9.312629e-01,  8.796432e-02, -3.535700e-01,  1.349173e-01, -6.859002e-01, -4.864565e-01},
  { 8.316685e-01,  1.561117e-01, -5.328758e-01,  7.460928e-02, -6.326354e-01, -5.984141e-01},
  {-9.260359e-01, -1.405210e-01, -3.503018e-01, -4.794734e-01, -6.217867e-01, -5.615145e-01},
  {-9.222066e-01, -1.195842e-01, -3.677425e-01, -4.785312e-01, -5.904620e-01, -5.757316e-01},
  {-7.109338e-01, -2.971427e-02, -7.026309e-01, -4.201946e-01, -4.685416e-01, -6.589066e-01},
  {-5.415148e-01, -9.594955e-02, -8.351979e-01, -3.851826e-01, -4.739466e-01, -6.850103e-01},
  {-9.063178e-01,  6.822805e-03, -4.225416e-01, -4.799679e-01, -5.442026e-01, -5.836933e-01},
  { 4.416218e-01,  6.597659e-03, -8.971771e-01, -3.895225e-02, -5.417559e-01, -6.898198e-01},
  {-9.422850e-01, -8.347735e-03, -3.347078e-01, -4.901660e-01, -4.965841e-01, -5.696040e-01},
  {-4.295388e-01, -7.280470e-02, -9.001089e-01, -3.524492e-01, -5.481005e-01, -6.943977e-01},
  {-2.546506e-01, -7.568160e-02, -9.640670e-01, -2.926062e-01, -5.399480e-01, -7.161356e-01},
  {-4.396553e-01, -1.499387e-01, -8.855630e-01, -3.456090e-01, -5.686327e-01, -6.958955e-01},
  {-4.139966e-01, -4.831048e-02, -9.089956e-01, -3.437565e-01, -6.090000e-01, -6.954333e-01},
  { 2.378717e-01, -3.889673e-01,  8.900120e-01,  2.180176e-01, -4.697024e-01,  7.916456e-01},
  { 2.901652e-02, -3.508811e-01,  9.359704e-01,  1.717411e-01, -4.730815e-01,  7.960996e-01},
  { 6.151114e-01, -3.545292e-01,  7.042351e-01,  2.784499e-01, -4.630732e-01,  7.625991e-01},
  { 6.689890e-01, -3.038214e-01,  6.783409e-01,  2.967227e-01, -4.263841e-01,  7.632895e-01},
  {-1.033645e-01, -3.468738e-01,  9.321987e-01,  1.365715e-01, -4.846556e-01,  7.910748e-01},
  { 6.713178e-01, -2.678033e-01,  6.910961e-01,  3.059207e-01, -4.082910e-01,  7.616839e-01},
  {-3.327085e-01, -3.136161e-01,  8.893538e-01,  4.470359e-02, -4.830939e-01,  7.706242e-01},
  { 9.358780e-01, -2.364834e-01,  2.611666e-01,  3.462502e-01, -4.894791e-01,  6.345400e-01},
  {-5.883142e-01, -2.149897e-01,  7.795292e-01, -1.099250e-01, -4.665055e-01,  6.889578e-01},
  {-6.215890e-01, -2.529523e-01,  7.413785e-01, -1.385518e-01, -4.563104e-01,  6.695071e-01},
  {-6.459685e-01, -2.586602e-01,  7.182059e-01, -1.647427e-01, -4.464579e-01,  6.496803e-01},
  {-6.201640e-01, -2.197810e-01,  7.530558e-01, -1.560302e-01, -4.415884e-01,  6.588166e-01},
  {-6.425332e-01, -3.889922e-01,  6.601789e-01, -2.662816e-01, -6.386919e-01,  4.147895e-01},
  {-6.849535e-01, -3.839358e-01,  6.192190e-01, -3.223343e-01, -6.260713e-01,  3.649637e-01},
  {-9.775137e-01,  1.753583e-01,  1.171172e-01, -5.023779e-01, -4.556086e-01,  1.096528e-01},
  { 9.558458e-01, -3.617077e-02, -2.916339e-01,  4.203323e-01, -4.024037e-01, -9.644688e-03},
  { 9.494966e-01, -1.557536e-01, -2.723915e-01,  4.176877e-01, -4.212533e-01, -1.260614e-02},
  { 9.645186e-01, -1.967903e-01, -1.760042e-01,  4.173993e-01, -4.381388e-01, -8.345771e-04},
  {-9.460410e-01,  1.748289e-01,  2.728392e-01, -5.026600e-01, -3.930720e-01, -4.769835e-02},
  {-9.952364e-01, -9.643791e-02, -1.428485e-02, -5.262159e-01, -5.443928e-01, -1.369713e-01},
  {-9.845620e-01, -1.571916e-01, -7.699633e-02, -5.219456e-01, -5.687493e-01, -1.865305e-01},
  { 8.057102e-01, -1.248422e-01, -5.790039e-01,  3.621188e-01, -4.450187e-01, -1.123997e-01},
  { 7.983308e-01, -1.012114e-01, -5.936531e-01,  3.415759e-01, -4.663393e-01, -1.352868e-01},
  { 8.009800e-01, -1.217778e-01, -5.861751e-01,  3.220080e-01, -4.951682e-01, -1.558198e-01},
  {-9.859347e-01, -1.609160e-01, -4.515200e-02, -5.163323e-01, -5.736662e-01, -2.516097e-01},
  { 8.278654e-01, -6.216856e-02, -5.574711e-01,  3.079008e-01, -5.071974e-01, -1.725143e-01},
  { 9.320841e-01,  8.081447e-02, -3.531121e-01,  1.272554e-01, -6.727445e-01, -5.035746e-01},
  {-9.596804e-01, -1.122354e-01, -2.577147e-01, -4.928300e-01, -5.507540e-01, -5.459260e-01},
  { 7.793884e-01,  9.382680e-02, -6.194758e-01,  6.489413e-02, -6.179574e-01, -6.093305e-01},
  {-5.376464e-01, -9.894095e-02, -8.373452e-01, -3.799223e-01, -4.580047e-01, -6.904927e-01},
  {-9.533587e-01, -6.474236e-02, -2.948145e-01, -4.892219e-01, -5.207050e-01, -5.660487e-01},
  {-8.217753e-01,  2.775398e-02, -5.691353e-01, -4.812256e-01, -4.882318e-01, -5.910743e-01},
  {-3.952647e-01, -1.658248e-01, -9.034755e-01, -3.250053e-01, -5.778762e-01, -7.037562e-01},
  { 3.524933e-01, -4.196463e-01,  8.364481e-01,  2.420049e-01, -4.471710e-01,  7.947647e-01},
  { 5.230458e-01, -3.725479e-01,  7.665710e-01,  2.658979e-01, -4.421075e-01,  7.825027e-01},
  { 5.818178e-01, -2.516204e-01,  7.734179e-01,  2.737941e-01, -4.138133e-01,  7.891713e-01},
  { 7.282467e-01, -3.291371e-01,  6.011035e-01,  3.106938e-01, -4.319600e-01,  7.451069e-01},
  { 7.126651e-01, -2.106010e-01,  6.691455e-01,  3.181187e-01, -3.740393e-01,  7.609411e-01},
  { 7.512011e-01, -2.764626e-01,  5.993874e-01,  3.166930e-01, -4.045632e-01,  7.509619e-01},
  { 8.125474e-01, -2.926252e-01,  5.041201e-01,  3.236244e-01, -4.633660e-01,  7.082561e-01},
  {-6.989429e-01, -2.981289e-01,  6.500754e-01, -1.962804e-01, -4.414084e-01,  6.203701e-01},
  { 8.903675e-01, -2.677619e-01,  3.681701e-01,  3.396041e-01, -4.750173e-01,  6.652752e-01},
  {-3.949085e-01, -2.906382e-01,  8.715370e-01,  2.245476e-02, -4.693119e-01,  7.660129e-01},
  {-5.707226e-01, -1.467658e-01,  8.079205e-01, -1.157792e-01, -4.406402e-01,  6.904359e-01},
  { 9.852157e-01, -3.922594e-02,  1.667680e-01,  3.790362e-01, -4.382401e-01,  4.309552e-01},
  { 9.831892e-01, -1.463718e-01,  1.091527e-01,  4.006640e-01, -5.215851e-01,  1.811303e-01},
  {-9.756512e-01,  1.990785e-01,  9.204596e-02, -4.932435e-01, -4.117579e-01,  9.239236e-02},
  { 9.853072e-01, -1.659994e-01,  4.017249e-02,  4.121216e-01, -4.916959e-01,  9.495838e-02},
  { 9.811966e-01, -1.904341e-01,  3.143171e-02,  4.143324e-01, -4.804152e-01,  8.706737e-02},
  { 9.778866e-01, -1.977139e-01, -6.816788e-02,  4.184403e-01, -4.571136e-01,  4.212538e-02},
  {-9.342867e-01,  6.901819e-02,  3.497783e-01, -5.107360e-01, -4.100704e-01, -6.352960e-02},
  { 8.645604e-01, -7.767568e-02, -4.964895e-01,  3.831890e-01, -4.027167e-01, -9.181285e-02},
  {-9.983267e-01, -5.612266e-02,  1.393275e-02, -5.284964e-01, -5.170345e-01, -1.580700e-01},
  { 8.915435e-01, -3.820555e-02, -4.513209e-01,  3.833573e-01, -3.982914e-01, -9.235582e-02},
  { 7.855710e-01,  1.017873e-01, -6.103422e-01,  3.200148e-01, -4.523599e-01, -1.635524e-01},
  {-9.890485e-01, -1.260641e-01, -7.675224e-02, -5.203417e-01, -5.152324e-01, -3.894772e-01},
  { 9.603058e-01, -8.351164e-02, -2.661551e-01,  1.327015e-01, -6.610602e-01, -4.864027e-01},
  {-9.121654e-01,  1.495959e-02, -4.095492e-01, -4.829149e-01, -4.501929e-01, -5.840334e-01},
  {-8.379622e-01,  3.619148e-02, -5.445268e-01, -4.804140e-01, -4.600501e-01, -5.895837e-01},
  {-3.616154e-01, -1.214416e-01, -9.243842e-01, -3.370750e-01, -4.949265e-01, -7.074181e-01},
  { 4.398234e-01, -1.667171e-02, -8.979295e-01, -5.639027e-02, -5.100612e-01, -6.983059e-01},
  {-7.609628e-01,  5.310739e-02, -6.466182e-01, -4.706457e-01, -4.733989e-01, -6.041952e-01},
  { 4.087114e-01, -3.850096e-01,  8.274797e-01,  2.471334e-01, -4.296052e-01,  8.008016e-01},
  { 6.379238e-01, -2.056628e-01,  7.421293e-01,  2.886352e-01, -3.830530e-01,  7.860989e-01},
  {-2.034324e-01, -2.829413e-01,  9.373149e-01,  1.005865e-01, -4.658555e-01,  7.915246e-01},
  { 8.003150e-01, -2.472818e-01,  5.462122e-01,  3.353683e-01, -3.868881e-01,  7.335501e-01},
  { 8.190144e-01, -3.000600e-01,  4.890597e-01,  3.330359e-01, -4.219993e-01,  7.184796e-01},
  { 7.853217e-01, -2.196238e-01,  5.788224e-01,  3.398403e-01, -3.483051e-01,  7.437081e-01},
  {-7.149283e-01, -2.857564e-01,  6.381385e-01, -2.108431e-01, -4.351782e-01,  6.072409e-01},
  {-6.799263e-01, -2.141199e-01,  7.013224e-01, -1.902772e-01, -4.226437e-01,  6.334310e-01},
  {-7.339783e-01, -3.338709e-01,  5.914441e-01, -2.566359e-01, -4.885613e-01,  5.208670e-01},
  {-6.387897e-01, -1.232660e-01,  7.594427e-01, -1.732282e-01, -3.917536e-01,  6.554133e-01},
  {-5.863830e-01, -1.152685e-01,  8.017906e-01, -1.365557e-01, -3.996480e-01,  6.824984e-01},
  { 9.817941e-01, -1.828213e-01,  5.154252e-02,  4.165072e-01, -4.664454e-01,  9.873725e-02},
  {-8.636705e-01,  5.031196e-01, -3.072125e-02, -4.487203e-01, -2.992384e-01,  2.659179e-02},
  { 9.627618e-01,  3.275960e-02, -2.683593e-01,  4.232569e-01, -3.784980e-01,  1.239794e-03},
  { 9.891101e-01, -5.868114e-02, -1.349737e-01,  4.260977e-01, -3.947970e-01,  1.565585e-02},
  { 9.816889e-01, -1.094261e-01, -1.559256e-01,  4.247989e-01, -4.045391e-01,  1.196568e-02},
  { 9.216354e-01,  5.899866e-02, -3.835458e-01,  4.121033e-01, -3.807293e-01, -3.055132e-02},
  {-9.779010e-01,  9.097511e-02,  1.882372e-01, -5.221342e-01, -4.473158e-01, -9.111506e-02},
  { 7.832518e-01,  2.276781e-01, -5.785147e-01,  2.959747e-01, -4.428687e-01, -1.932974e-01},
  { 8.256848e-01,  8.662444e-02, -5.574414e-01,  2.557950e-01, -4.286751e-01, -2.474921e-01},
  { 9.108809e-01, -1.774330e-02, -4.122878e-01,  1.565798e-01, -6.095031e-01, -4.210390e-01},
  { 5.653030e-01,  8.401808e-03, -8.248405e-01,  8.913211e-03, -5.109871e-01, -6.600445e-01},
  {-9.588872e-01, -1.292167e-02, -2.834932e-01, -4.989540e-01, -4.414964e-01, -5.381145e-01},
  {-9.505013e-01, -1.750651e-02, -3.102269e-01, -4.962491e-01, -4.464503e-01, -5.473782e-01},
  {-8.785378e-01, -9.197627e-03, -4.775843e-01, -4.845577e-01, -4.266970e-01, -5.800190e-01},
  { 1.324208e-01, -1.212476e-01, -9.837498e-01, -1.121758e-01, -4.708200e-01, -7.182955e-01},
  { 3.248861e-01, -4.027354e-01,  8.557180e-01,  2.382139e-01, -4.320027e-01,  8.036800e-01},
  { 1.399342e-01, -3.843248e-01,  9.125310e-01,  2.058248e-01, -4.396163e-01,  8.074900e-01},
  { 4.993603e-01, -2.604959e-01,  8.263057e-01,  2.544791e-01, -4.193921e-01,  8.012190e-01},
  {-4.746289e-02, -3.306522e-01,  9.425584e-01,  1.611680e-01, -4.447011e-01,  8.062387e-01},
  {-1.298077e-01, -2.936447e-01,  9.470600e-01,  1.262308e-01, -4.466114e-01,  8.017262e-01},
  {-4.339495e-01, -1.154406e-01,  8.935106e-01,  2.264398e-02, -3.422638e-01,  7.888673e-01},
  { 7.165862e-01, -2.074088e-01,  6.659474e-01,  3.232426e-01, -3.422975e-01,  7.651944e-01},
  { 8.963351e-01, -2.666137e-01,  3.542604e-01,  3.410074e-01, -4.451413e-01,  6.857814e-01},
  { 8.690872e-01, -2.065874e-01,  4.494542e-01,  3.529955e-01, -3.507637e-01,  7.218337e-01},
  { 9.375395e-01, -2.329122e-01,  2.584022e-01,  3.560002e-01, -4.375597e-01,  6.454561e-01},
  { 9.478229e-01, -2.406720e-01,  2.090662e-01,  3.596661e-01, -4.296097e-01,  6.390177e-01},
  {-6.990014e-01, -1.823710e-01,  6.914752e-01, -1.998311e-01, -4.123235e-01,  6.269733e-01},
  {-5.859793e-01, -4.473506e-02,  8.090903e-01, -1.493190e-01, -3.635659e-01,  6.765568e-01},
  { 9.816799e-01, -1.747875e-01,  7.585468e-02,  3.824156e-01, -3.851522e-01,  5.319008e-01},
  { 9.894724e-01, -1.424206e-01, -2.570562e-02,  4.265794e-01, -4.150746e-01,  5.449593e-02},
  {-9.116803e-01,  3.872173e-01,  1.374833e-01, -4.333282e-01, -2.676371e-01, -9.334185e-03},
  {-8.564255e-01,  4.518162e-01,  2.497949e-01, -4.416269e-01, -2.773519e-01, -2.491039e-02},
  {-8.878689e-01,  3.976258e-01,  2.314792e-01, -4.884661e-01, -3.363396e-01, -7.161575e-02},
  {-8.903002e-01,  3.860315e-01,  2.415475e-01, -4.910761e-01, -3.342721e-01, -8.177406e-02},
  { 9.040186e-01,  7.350717e-02, -4.211259e-01,  4.023718e-01, -3.823988e-01, -5.333368e-02},
  {-9.988175e-01,  1.773891e-02,  4.526424e-02, -5.289745e-01, -4.812587e-01, -1.527914e-01},
  { 7.433918e-01,  3.065818e-02, -6.681532e-01,  3.696801e-01, -3.992569e-01, -1.090284e-01},
  {-9.885968e-01, -8.506697e-02, -1.242572e-01, -5.195447e-01, -4.847894e-01, -4.321205e-01},
  { 8.627567e-01,  3.912835e-02, -5.041029e-01,  1.740598e-01, -5.341646e-01, -3.819112e-01},
  {-9.540401e-01, -2.585221e-02, -2.985621e-01, -5.006732e-01, -4.259502e-01, -5.334000e-01},
  {-9.344877e-01, -1.120938e-01, -3.378870e-01, -4.815106e-01, -4.038952e-01, -5.863352e-01},
  {-6.506266e-01, -7.453648e-02, -7.557310e-01, -4.138152e-01, -4.256397e-01, -6.676589e-01},
  {-8.396947e-01, -5.054639e-02, -5.407013e-01, -4.695143e-01, -3.942670e-01, -6.074731e-01},
  {-4.132056e-01, -1.406108e-01, -8.997165e-01, -3.409962e-01, -4.450448e-01, -7.134902e-01},
  {-8.049692e-01, -1.694760e-02, -5.930746e-01, -4.653094e-01, -4.493760e-01, -6.105853e-01},
  {-1.553659e-01, -1.508427e-01, -9.762725e-01, -2.798929e-01, -4.634092e-01, -7.281256e-01},
  { 2.144583e-01, -3.406857e-01,  9.153911e-01,  2.216299e-01, -4.287298e-01,  8.095561e-01},
  { 3.662386e-01, -2.584687e-01,  8.939033e-01,  2.448264e-01, -4.140499e-01,  8.072017e-01},
  { 4.773493e-01, -2.507358e-01,  8.421812e-01,  2.532327e-01, -4.072209e-01,  8.052877e-01},
  { 5.311041e-01, -1.993177e-01,  8.235295e-01,  2.672750e-01, -3.883186e-01,  8.010894e-01},
  {-2.597147e-01, -2.228261e-01,  9.396259e-01,  9.692495e-02, -4.195640e-01,  8.041818e-01},
  {-4.881078e-01, -1.514346e-01,  8.595454e-01,  2.104956e-02, -3.156384e-01,  7.902500e-01},
  { 5.778221e-01, -1.893906e-01,  7.938846e-01,  2.780732e-01, -3.437456e-01,  8.040432e-01},
  {-3.984123e-01, -1.110070e-01,  9.104642e-01,  4.717594e-02, -3.945315e-01,  7.924426e-01},
  {-7.291479e-01, -2.852484e-01,  6.220746e-01, -2.264001e-01, -4.188790e-01,  5.968137e-01},
  { 8.779857e-01, -2.553516e-01,  4.048909e-01,  3.510824e-01, -3.849706e-01,  7.058381e-01},
  {-3.224119e-01, -2.402300e-01,  9.156092e-01,  3.215114e-02, -4.512775e-01,  7.756880e-01},
  { 9.168687e-01, -2.017122e-01,  3.444763e-01,  3.688888e-01, -3.376899e-01,  6.924874e-01},
  {-4.654458e-01, -2.132028e-01,  8.590139e-01, -1.359868e-02, -4.434002e-01,  7.547812e-01},
  { 9.567329e-01, -1.944128e-01,  2.164851e-01,  3.775487e-01, -3.420767e-01,  6.592360e-01},
  {-6.931231e-01, -1.230919e-01,  7.102314e-01, -2.121253e-01, -3.699496e-01,  6.238608e-01},
  { 9.696784e-01, -2.439083e-01,  1.524645e-02,  3.774713e-01, -3.503112e-01,  6.496011e-01},
  { 9.721177e-01, -2.101558e-01,  1.040276e-01,  3.789871e-01, -3.825400e-01,  5.796187e-01},
  {-6.437994e-01, -4.308045e-02,  7.639806e-01, -1.991919e-01, -3.413781e-01,  6.390470e-01},
  {-8.373970e-01, -9.799790e-02,  5.377386e-01, -4.460149e-01, -4.302488e-01,  3.064515e-01},
  {-7.714815e-01, -2.829187e-01,  5.698888e-01, -4.131805e-01, -5.103016e-01,  3.151722e-01},
  {-9.576648e-01,  6.556769e-02,  2.803194e-01, -4.907009e-01, -4.661579e-01,  1.831010e-01},
  {-9.552329e-01, -3.015848e-02,  2.943140e-01, -4.766616e-01, -4.569411e-01,  2.198144e-01},
  {-9.587638e-01, -7.655339e-03,  2.841009e-01, -4.845305e-01, -4.596350e-01,  1.988190e-01},
  { 8.929825e-01, -1.551208e-01, -4.225160e-01,  2.984111e-01, -2.316423e-01, -1.719674e-01},
  {-8.199037e-01,  5.550433e-01,  1.403030e-01, -4.125562e-01, -2.301977e-01, -3.179437e-02},
  {-8.111528e-01,  5.670056e-01,  1.433035e-01, -4.018371e-01, -2.129204e-01, -3.919792e-02},
  {-8.204219e-01,  5.383341e-01,  1.926250e-01, -4.267903e-01, -2.484246e-01, -3.934487e-02},
  { 8.515528e-01, -2.206584e-01, -4.755708e-01,  2.551752e-01, -2.509685e-01, -2.492625e-01},
  { 8.464918e-01, -2.283925e-01, -4.809248e-01,  2.503793e-01, -2.465024e-01, -2.594446e-01},
  {-9.431446e-01,  2.549638e-01,  2.132410e-01, -5.077581e-01, -3.826198e-01, -8.262466e-02},
  { 8.183575e-01,  7.138552e-02, -5.702588e-01,  2.975144e-01, -3.051918e-01, -1.745957e-01},
  {-9.988424e-01,  2.155016e-02,  4.300513e-02, -5.272882e-01, -4.761837e-01, -1.210930e-01},
  { 7.707613e-01, -2.637323e-01, -5.799760e-01,  2.119885e-01, -2.614990e-01, -3.134023e-01},
  { 8.878772e-01,  6.773797e-02, -4.550665e-01,  3.840644e-01, -3.860039e-01, -9.034800e-02},
  { 7.179099e-01, -3.548652e-01, -5.988957e-01,  2.010563e-01, -2.337113e-01, -3.395729e-01},
  { 7.580888e-01,  5.495356e-02, -6.498319e-01,  3.778349e-01, -3.911822e-01, -9.975643e-02},
  { 7.955297e-01, -1.590940e-01, -5.846552e-01,  1.931290e-01, -2.504303e-01, -3.424570e-01},
  { 7.483248e-01, -3.383312e-01, -5.705629e-01,  1.887135e-01, -2.342318e-01, -3.547943e-01},
  { 8.472127e-01, -4.808271e-02, -5.290732e-01,  2.147626e-01, -3.167592e-01, -3.050613e-01},
  { 8.298045e-01, -2.449797e-02, -5.575162e-01,  2.038782e-01, -2.915297e-01, -3.215518e-01},
  { 7.882819e-01, -1.957471e-01, -5.833479e-01,  1.780279e-01, -2.419471e-01, -3.648525e-01},
  { 6.340811e-01, -2.373571e-01, -7.359366e-01,  1.679192e-01, -2.307661e-01, -3.812930e-01},
  { 6.826516e-01, -2.043852e-01, -7.015792e-01,  1.668348e-01, -2.401752e-01, -3.797739e-01},
  { 8.527421e-01,  1.474960e-02, -5.221238e-01,  1.740920e-01, -2.843849e-01, -3.670686e-01},
  { 7.618157e-01, -2.525165e-01, -5.965502e-01,  1.533358e-01, -2.219217e-01, -4.015261e-01},
  {-9.289914e-01, -2.750658e-01, -2.476162e-01, -4.946772e-01, -3.896844e-01, -5.544370e-01},
  { 5.357911e-01, -2.716106e-02, -8.439136e-01, -1.285217e-02, -4.689785e-01, -6.758553e-01},
  {-5.407444e-01, -9.560660e-02, -8.357362e-01, -3.664279e-01, -4.133882e-01, -7.038141e-01},
  { 3.479165e-01, -4.535002e-02, -9.364281e-01, -8.437032e-02, -4.619294e-01, -7.113633e-01},
  { 5.750727e-03, -1.759031e-01, -9.843907e-01, -2.690885e-01, -4.394057e-01, -7.335721e-01},
  { 1.537268e-01, -2.867123e-01,  9.456025e-01,  2.185304e-01, -4.065680e-01,  8.173743e-01},
  { 1.171146e-02, -2.888627e-01,  9.572989e-01,  1.845006e-01, -4.149767e-01,  8.169331e-01},
  { 3.707498e-01, -2.029997e-01,  9.062757e-01,  2.400877e-01, -3.890938e-01,  8.155535e-01},
  { 1.629545e-01, -2.426915e-01,  9.563193e-01,  2.201221e-01, -3.941713e-01,  8.204547e-01},
  { 4.121646e-01, -1.916364e-01,  8.907278e-01,  2.505852e-01, -3.682476e-01,  8.152840e-01},
  {-2.981412e-01, -1.655277e-01,  9.400597e-01,  9.606466e-02, -3.790899e-01,  8.125430e-01},
  {-5.258841e-01, -1.776262e-01,  8.318021e-01, -5.580896e-03, -3.134431e-01,  7.745872e-01},
  {-5.456272e-01, -1.006024e-01,  8.319676e-01, -3.440660e-02, -3.135745e-01,  7.555962e-01},
  { 8.971874e-01, -2.766260e-01,  3.442858e-01,  3.488145e-01, -4.166308e-01,  6.884541e-01},
  {-4.143382e-01, -1.889091e-01,  8.903017e-01,  1.333023e-02, -4.381694e-01,  7.706392e-01},
  { 9.234782e-01, -2.493147e-01,  2.915993e-01,  3.619672e-01, -3.811621e-01,  6.809657e-01},
  { 9.341750e-01, -1.570474e-01,  3.203956e-01,  3.749054e-01, -3.191194e-01,  6.851251e-01},
  { 9.617773e-01, -2.495484e-01,  1.127383e-01,  3.695843e-01, -3.779579e-01,  6.548032e-01},
  {-5.212644e-01, -1.401789e-01,  8.418036e-01, -2.733901e-02, -4.237367e-01,  7.509280e-01},
  {-5.383363e-01, -1.094298e-01,  8.355951e-01, -7.034948e-02, -3.915312e-01,  7.274845e-01},
  {-5.521473e-01, -7.104975e-02,  8.307137e-01, -1.026032e-01, -3.770087e-01,  7.076907e-01},
  {-5.988963e-01,  1.535552e-02,  8.006794e-01, -1.804045e-01, -3.329590e-01,  6.541727e-01},
  {-8.831171e-01, -2.939932e-01,  3.656119e-01, -4.510182e-01, -4.343925e-01,  2.922620e-01},
  { 9.801761e-01, -1.604229e-01,  1.162732e-01,  4.090430e-01, -4.537640e-01,  1.946054e-01},
  {-6.949077e-01, -3.251960e-01,  6.413664e-01, -3.340891e-01, -5.738086e-01,  3.805958e-01},
  { 9.782521e-01,  1.171153e-02, -2.070885e-01,  4.269460e-01, -3.452672e-01,  2.061969e-02},
  { 9.953251e-01, -6.439584e-02, -7.197959e-02,  4.313954e-01, -3.737118e-01,  5.265540e-02},
  {-8.970476e-01,  4.415953e-01,  1.729714e-02, -4.227906e-01, -2.489772e-01,  1.085643e-02},
  { 8.952606e-01, -7.391006e-02, -4.393696e-01,  3.091977e-01, -2.310357e-01, -1.499472e-01},
  {-8.595406e-01,  5.100518e-01, -3.220378e-02, -4.010548e-01, -2.131256e-01, -1.024306e-02},
  {-8.505793e-01,  5.257138e-01, -1.182386e-02, -3.905027e-01, -1.971307e-01, -3.120295e-02},
  {-7.662156e-01,  5.222353e-01,  3.744116e-01, -4.545285e-01, -2.707157e-01, -7.157932e-02},
  { 8.614860e-01,  7.062391e-02, -5.028460e-01,  3.189138e-01, -2.774615e-01, -1.358382e-01},
  {-9.351450e-01,  2.837826e-01,  2.120642e-01, -5.067825e-01, -3.608302e-01, -1.028392e-01},
  {-9.372560e-01,  2.573746e-01,  2.351792e-01, -5.090953e-01, -3.647498e-01, -1.074408e-01},
  { 8.105624e-01,  1.568708e-01, -5.642520e-01,  3.115122e-01, -3.012824e-01, -1.520058e-01},
  { 8.382067e-01, -3.142438e-01, -4.457134e-01,  2.418527e-01, -2.398284e-01, -2.773013e-01},
  {-9.809940e-01,  1.167134e-01,  1.550117e-01, -5.228176e-01, -4.208396e-01, -1.264839e-01},
  {-9.975808e-01, -6.630442e-02, -2.089090e-02, -5.300021e-01, -4.833079e-01, -2.050504e-01},
  { 7.500187e-01,  1.230476e-01, -6.498702e-01,  3.558929e-01, -3.923809e-01, -1.228543e-01},
  { 6.104197e-01, -4.207358e-01, -6.710955e-01,  1.698081e-01, -2.172158e-01, -3.863247e-01},
  {-9.955722e-01, -9.201103e-02, -1.923532e-02, -5.289074e-01, -4.627453e-01, -3.165846e-01},
  { 8.766220e-01,  1.867595e-02, -4.808171e-01,  1.823374e-01, -4.832465e-01, -3.663287e-01},
  { 8.598287e-01,  3.131161e-02, -5.096217e-01,  1.864359e-01, -4.132667e-01, -3.565277e-01},
  { 8.549570e-01, -1.759120e-02, -5.184004e-01,  1.589240e-01, -2.530988e-01, -3.904534e-01},
  {-9.741532e-01, -6.019806e-02, -2.177193e-01, -5.164141e-01, -4.037846e-01, -4.774075e-01},
  { 9.102157e-01,  9.569788e-02, -4.029258e-01,  1.231939e-01, -5.508971e-01, -4.906587e-01},
  { 6.903003e-01, -1.431296e-02, -7.233813e-01,  1.301611e-02, -4.685860e-01, -6.565734e-01},
  {-8.837883e-01, -6.748014e-02, -4.629954e-01, -4.851221e-01, -3.497792e-01, -5.818144e-01},
  { 1.065799e-01, -9.472658e-01, -3.022058e-01,  4.114375e-01, -1.386981e-01, -4.688427e-01},
  { 5.477881e-01, -8.286756e-01, -1.149992e-01,  4.128343e-01, -1.380452e-01, -4.689062e-01},
  { 2.668054e-01, -6.958588e-01, -6.667799e-01,  4.132895e-01, -1.369132e-01, -4.715544e-01},
  { 6.727401e-01, -7.228701e-01, -1.577328e-01,  4.135320e-01, -1.373745e-01, -4.700038e-01},
  {-5.910802e-01, -8.375951e-02, -8.022522e-01, -3.987308e-01, -3.876348e-01, -6.840013e-01},
  {-5.274275e-01, -9.220226e-02, -8.445821e-01, -3.714725e-01, -3.627352e-01, -7.062863e-01},
  {-7.724511e-01, -6.192147e-02, -6.320482e-01, -4.505499e-01, -4.047146e-01, -6.312502e-01},
  {-2.266609e-02, -2.403891e-01,  9.704119e-01,  1.740385e-01, -3.834294e-01,  8.256012e-01},
  {-1.045246e-01, -2.652449e-01,  9.584987e-01,  1.543759e-01, -4.027784e-01,  8.189592e-01},
  { 2.465421e-01, -1.919151e-01,  9.499398e-01,  2.240599e-01, -3.763003e-01,  8.232049e-01},
  { 2.401571e-01, -2.187260e-01,  9.457715e-01,  2.271812e-01, -3.647689e-01,  8.249598e-01},
  { 7.382998e-02, -2.308048e-01,  9.701950e-01,  1.935880e-01, -3.704021e-01,  8.286597e-01},
  {-1.881132e-01, -2.082479e-01,  9.598157e-01,  1.372163e-01, -3.838037e-01,  8.209995e-01},
  { 1.809263e-01, -1.305167e-01,  9.747979e-01,  2.168576e-01, -3.516808e-01,  8.300816e-01},
  { 1.928366e-01, -2.802121e-02,  9.808307e-01,  2.032515e-01, -3.496026e-01,  8.322666e-01},
  {-2.896972e-01, -1.830314e-01,  9.394547e-01,  8.762248e-02, -3.437240e-01,  8.159666e-01},
  { 5.254220e-01, -2.167914e-01,  8.227595e-01,  2.787364e-01, -3.138880e-01,  8.107692e-01},
  { 6.508648e-01, -2.074675e-01,  7.302960e-01,  3.131009e-01, -3.117377e-01,  7.840231e-01},
  {-4.500006e-01, -9.026641e-02,  8.884546e-01,  6.470917e-03, -4.103944e-01,  7.720676e-01},
  { 7.974449e-01, -1.906594e-01,  5.724776e-01,  3.508838e-01, -3.086776e-01,  7.420474e-01},
  {-5.177881e-01, -7.281789e-02,  8.524042e-01, -4.011322e-02, -3.823176e-01,  7.478009e-01},
  { 9.207687e-01, -1.645299e-01,  3.537159e-01,  3.684844e-01, -3.030215e-01,  7.108881e-01},
  {-5.618974e-01,  5.824029e-03,  8.271865e-01, -9.122571e-02, -3.317091e-01,  7.169817e-01},
  { 9.811623e-01, -1.811195e-01,  6.720404e-02,  3.845446e-01, -3.186225e-01,  6.373357e-01},
  {-6.709263e-01, -3.392887e-02,  7.407474e-01, -2.186500e-01, -3.262218e-01,  6.227709e-01},
  {-7.612851e-01, -2.564854e-01,  5.955336e-01, -3.948847e-01, -4.740467e-01,  3.577646e-01},
  {-8.367743e-01, -5.320879e-02,  5.449564e-01, -4.238096e-01, -4.340738e-01,  3.324043e-01},
  {-8.061330e-01,  3.948306e-02,  5.904157e-01, -4.506733e-01, -4.223525e-01,  2.969124e-01},
  {-7.138742e-01, -3.359897e-01,  6.144058e-01, -3.504799e-01, -5.517152e-01,  3.739499e-01},
  { 9.880894e-01, -1.388047e-01,  6.642790e-02,  4.277660e-01, -3.917989e-01,  1.124851e-01},
  {-9.673225e-01,  1.028271e-01,  2.317627e-01, -4.920711e-01, -4.508560e-01,  1.746174e-01},
  {-9.168073e-01,  3.922842e-01, -7.468259e-02, -4.281046e-01, -2.550862e-01,  2.981595e-02},
  { 9.779571e-01,  1.893588e-02, -2.079457e-01,  4.290280e-01, -3.370596e-01,  3.062579e-02},
  { 8.991845e-01, -8.679367e-02, -4.288755e-01,  3.175997e-01, -2.213548e-01, -1.345259e-01},
  {-8.281795e-01,  5.604141e-01, -7.397531e-03, -3.716833e-01, -1.680332e-01, -3.626590e-02},
  { 9.073005e-01,  1.069850e-01, -4.066446e-01,  4.109347e-01, -3.452074e-01, -2.532482e-02},
  {-8.257286e-01,  3.372905e-01,  4.521143e-01, -4.892069e-01, -2.878193e-01, -1.211532e-01},
  {-8.462111e-01,  3.062735e-01,  4.360312e-01, -4.961492e-01, -2.867354e-01, -1.349057e-01},
  {-7.664660e-01,  5.322873e-01,  3.594440e-01, -4.345968e-01, -2.419962e-01, -7.025529e-02},
  {-9.055873e-01,  2.661169e-01,  3.302931e-01, -5.073857e-01, -3.462484e-01, -1.184914e-01},
  {-7.692190e-01,  5.848686e-01,  2.573537e-01, -3.911010e-01, -1.867143e-01, -6.968427e-02},
  { 8.548802e-01,  1.688386e-01, -4.905849e-01,  3.904120e-01, -3.664829e-01, -7.342930e-02},
  {-9.988235e-01,  1.426259e-04,  4.849266e-02, -5.307038e-01, -4.424848e-01, -1.992005e-01},
  {-9.967567e-01, -7.395535e-02, -3.172642e-02, -5.299674e-01, -4.462481e-01, -3.461838e-01},
  {-9.764680e-01, -8.464083e-02, -1.983586e-01, -5.202395e-01, -3.856919e-01, -4.666567e-01},
  { 8.025431e-01,  4.536672e-02, -5.948668e-01,  4.954247e-02, -4.915349e-01, -6.156353e-01},
  { 6.800796e-01, -9.280434e-05, -7.331382e-01,  1.461456e-02, -4.567590e-01, -6.551561e-01},
  {-9.558150e-01, -1.838991e-01, -2.293440e-01, -5.108745e-01, -3.707314e-01, -5.075254e-01},
  {-2.104096e-01, -9.323446e-01, -2.940433e-01,  4.085273e-01, -1.387276e-01, -4.669493e-01},
  {-1.840736e-01, -8.867119e-01, -4.240978e-01,  4.030585e-01, -1.378233e-01, -4.664771e-01},
  { 8.853625e-01,  5.892841e-02, -4.611515e-01,  9.039332e-02, -4.766008e-01, -5.479663e-01},
  {-7.959611e-01, -9.244338e-02, -5.982476e-01, -4.596816e-01, -3.329223e-01, -6.290669e-01},
  { 8.408728e-01, -5.202164e-01, -1.493578e-01,  4.148604e-01, -1.355701e-01, -4.702693e-01},
  { 5.907950e-01, -2.777098e-02, -8.063436e-01, -8.413199e-03, -4.408003e-01, -6.738529e-01},
  {-7.729350e-01, -6.750409e-02, -6.308839e-01, -4.529269e-01, -3.498580e-01, -6.357446e-01},
  { 4.742262e-01, -5.866862e-02, -8.784461e-01, -3.345026e-02, -4.273745e-01, -6.904764e-01},
  {-4.916493e-01, -1.025655e-01, -8.647320e-01, -3.520814e-01, -3.872660e-01, -7.155417e-01},
  {-6.559963e-01, -8.483026e-02, -7.499818e-01, -4.214348e-01, -3.520833e-01, -6.682175e-01},
  {-2.682534e-02, -2.299396e-01, -9.728351e-01, -2.643560e-01, -3.904431e-01, -7.434935e-01},
  {-1.326583e-01, -2.138336e-01,  9.678208e-01,  1.529353e-01, -3.631656e-01,  8.279157e-01},
  { 8.125944e-02, -1.250672e-01,  9.888150e-01,  1.942287e-01, -3.499464e-01,  8.343831e-01},
  { 3.277972e-01, -1.816831e-01,  9.271140e-01,  2.347059e-01, -3.244218e-01,  8.316414e-01},
  {-2.412016e-01, -1.959077e-01,  9.504957e-01,  1.337250e-01, -3.458987e-01,  8.284617e-01},
  {-3.322792e-01, -1.390960e-01,  9.328681e-01,  8.874452e-02, -3.257222e-01,  8.192095e-01},
  { 1.394302e-01, -1.817336e-01,  9.734126e-01,  2.123953e-01, -3.213677e-01,  8.369792e-01},
  {-7.338288e-01, -2.215973e-01,  6.421760e-01, -2.495783e-01, -4.056046e-01,  5.749954e-01},
  {-4.825763e-01, -8.944367e-02,  8.712749e-01, -1.883188e-02, -4.051641e-01,  7.587299e-01},
  { 9.664917e-01, -1.351501e-01,  2.182386e-01,  3.822912e-01, -2.999915e-01,  6.678104e-01},
  {-7.363733e-01, -3.072110e-01,  6.028067e-01, -3.190159e-01, -4.513757e-01,  4.653208e-01},
  {-8.217133e-01, -1.705188e-01,  5.437929e-01, -3.903480e-01, -3.369159e-01,  4.223498e-01},
  { 9.857392e-01, -1.526415e-01,  7.084339e-02,  3.883280e-01, -3.391339e-01,  5.560939e-01},
  {-9.062315e-01,  3.005428e-03,  4.227710e-01, -4.199217e-01, -4.192072e-01,  3.411806e-01},
  { 8.397120e-01, -1.926939e-01,  5.076938e-01,  3.892498e-01, -4.846556e-01,  2.907532e-01},
  { 9.738539e-01, -1.694603e-01,  1.513001e-01,  3.913695e-01, -4.803415e-01,  2.811372e-01},
  {-7.523855e-01, -3.358862e-01,  5.666538e-01, -3.845628e-01, -5.225641e-01,  3.480105e-01},
  {-9.043807e-01, -2.875125e-01,  3.153287e-01, -4.662957e-01, -4.286911e-01,  2.600852e-01},
  {-9.146230e-01, -2.258442e-01,  3.353493e-01, -4.692264e-01, -4.284902e-01,  2.512504e-01},
  {-9.707112e-01, -8.368184e-02,  2.252048e-01, -4.806092e-01, -3.800976e-01,  1.501649e-01},
  {-9.910238e-01,  6.893270e-02,  1.145426e-01, -4.833164e-01, -3.955948e-01,  1.591247e-01},
  { 9.955074e-01, -9.281529e-02,  1.872067e-02,  4.330821e-01, -3.560772e-01,  9.368544e-02},
  { 9.949185e-01, -4.531190e-02, -8.991156e-02,  4.337887e-01, -3.437551e-01,  6.577094e-02},
  { 9.068391e-01, -2.379343e-01, -3.478936e-01,  3.076839e-01, -2.079911e-01, -1.640720e-01},
  { 9.136204e-01,  1.258287e-01, -3.866070e-01,  4.143281e-01, -3.303722e-01, -1.240954e-02},
  { 8.581055e-01,  6.356287e-02, -5.095240e-01,  3.279570e-01, -2.431553e-01, -1.157920e-01},
  {-7.947871e-01,  5.992523e-01,  9.596957e-02, -3.512843e-01, -1.361534e-01, -6.933989e-02},
  {-5.826089e-01,  6.669743e-01,  4.644481e-01, -4.669822e-01, -2.570615e-01, -1.090643e-01},
  {-7.743745e-01,  6.018661e-01,  1.951955e-01, -3.641940e-01, -1.536118e-01, -6.839936e-02},
  { 8.198547e-01, -4.192588e-01, -3.899492e-01,  2.517246e-01, -2.278735e-01, -2.691044e-01},
  {-6.741198e-01,  4.562930e-01,  5.808263e-01, -4.325193e-01, -2.176630e-01, -9.650885e-02},
  {-6.843198e-01,  2.982273e-01,  6.654074e-01, -4.449570e-01, -2.272797e-01, -1.039737e-01},
  {-9.698480e-01,  1.503145e-01,  1.918344e-01, -5.184331e-01, -3.609682e-01, -1.492679e-01},
  {-9.716073e-01,  2.321649e-01,  4.559169e-02, -5.258141e-01, -3.976462e-01, -1.679623e-01},
  {-9.763629e-01,  2.132606e-01, -3.514915e-02, -5.317438e-01, -4.204110e-01, -2.214791e-01},
  {-9.176236e-01,  3.906449e-01, -7.323550e-02, -5.305179e-01, -4.126813e-01, -2.028269e-01},
  { 5.333888e-02, -9.980177e-01, -3.340243e-02,  4.043736e-01, -1.438446e-01, -4.450929e-01},
  { 8.845473e-01,  1.700707e-02, -4.661404e-01,  1.460602e-01, -2.518386e-01, -4.136063e-01},
  { 8.020877e-01, -1.990384e-01, -5.630621e-01,  1.395761e-01, -2.107414e-01, -4.266917e-01},
  {-9.886693e-01, -8.274291e-02, -1.252458e-01, -5.301256e-01, -3.976020e-01, -4.008343e-01},
  { 2.777616e-01, -9.407277e-01, -1.946275e-01,  4.139005e-01, -1.408420e-01, -4.551651e-01},
  {-7.619358e-02, -9.464484e-01, -3.137353e-01,  4.031977e-01, -1.400182e-01, -4.611256e-01},
  { 8.190724e-01, -2.025503e-02, -5.733324e-01,  4.440681e-02, -4.730876e-01, -6.217788e-01},
  { 7.424834e-01, -1.480447e-02, -6.697009e-01,  3.180389e-02, -4.638368e-01, -6.373992e-01},
  {-1.863142e-02, -9.913518e-01, -1.299018e-01,  4.124246e-01, -1.387416e-01, -4.628251e-01},
  {-8.503007e-01, -6.178127e-02, -5.226583e-01, -4.651445e-01, -3.074576e-01, -6.236758e-01},
  { 8.262621e-01, -3.894986e-01, -4.069175e-01,  4.162334e-01, -1.331551e-01, -4.695498e-01},
  {-7.875745e-01, -8.159617e-02, -6.107934e-01, -4.508371e-01, -3.365032e-01, -6.399559e-01},
  { 3.248645e-01, -3.291124e-01, -8.866500e-01,  4.110410e-01, -1.270911e-01, -4.760142e-01},
  { 3.499258e-01, -7.445752e-02, -9.338138e-01, -7.906295e-02, -4.158165e-01, -7.123623e-01},
  {-3.362353e-01, -1.657952e-01, -9.270695e-01, -3.207953e-01, -4.031680e-01, -7.285329e-01},
  {-6.913188e-01, -7.966584e-02, -7.181446e-01, -4.156438e-01, -3.220775e-01, -6.774861e-01},
  { 4.531790e-01, -8.084125e-02, -8.877463e-01, -5.500123e-02, -3.967905e-01, -7.042305e-01},
  {-5.874893e-01, -1.178579e-01, -8.006034e-01, -3.860852e-01, -3.115029e-01, -7.026510e-01},
  { 2.820537e-01, -1.056434e-01, -9.535645e-01, -1.163140e-01, -3.932967e-01, -7.271418e-01},
  { 1.980744e-01, -4.604152e-02, -9.791051e-01, -1.456023e-01, -3.915085e-01, -7.338585e-01},
  {-1.166072e-01, -1.971550e-01, -9.734129e-01, -2.813938e-01, -4.071850e-01, -7.380441e-01},
  {-9.040052e-02, -1.702187e-01, -9.812509e-01, -2.638181e-01, -3.657642e-01, -7.500497e-01},
  { 5.912811e-01, -6.930685e-02,  8.034819e-01,  2.869775e-01, -2.800753e-01,  8.143118e-01},
  { 5.307351e-01, -2.277413e-01,  8.163664e-01,  2.757207e-01, -2.889201e-01,  8.193942e-01},
  {-3.486854e-01, -1.069327e-01,  9.311197e-01,  6.266771e-02, -3.036570e-01,  8.115837e-01},
  { 3.392400e-01, -2.249200e-01,  9.134151e-01,  2.453916e-01, -3.017503e-01,  8.327572e-01},
  { 1.101117e-01, -1.734471e-01,  9.786683e-01,  2.053188e-01, -3.135015e-01,  8.392566e-01},
  {-4.497669e-02, -1.790392e-01,  9.828133e-01,  1.709028e-01, -3.162864e-01,  8.390380e-01},
  {-7.513982e-01, -2.329802e-01,  6.173500e-01, -2.699033e-01, -3.912800e-01,  5.561986e-01},
  { 8.456971e-01, -1.314116e-01,  5.172303e-01,  3.529550e-01, -2.729584e-01,  7.512749e-01},
  {-6.993693e-01, -4.804352e-02,  7.131441e-01, -2.387411e-01, -3.213429e-01,  6.041310e-01},
  {-9.133312e-01, -7.594708e-02,  4.000728e-01, -3.981276e-01, -3.231222e-01,  4.138729e-01},
  {-6.462137e-01,  2.783114e-02,  7.626489e-01, -2.135190e-01, -2.989926e-01,  6.266685e-01},
  {-9.422825e-01, -8.356527e-02,  3.242231e-01, -3.988002e-01, -3.274717e-01,  4.115086e-01},
  {-7.188999e-01, -3.376219e-01,  6.076137e-01, -3.256711e-01, -5.165017e-01,  4.222828e-01},
  {-9.141025e-01, -8.759054e-02,  3.959097e-01, -4.687744e-01, -4.006072e-01,  2.660544e-01},
  {-9.730522e-01,  1.957569e-02,  2.297525e-01, -4.800561e-01, -3.883426e-01,  1.811434e-01},
  { 9.804562e-01,  3.358132e-02, -1.938501e-01,  4.330114e-01, -3.116209e-01,  5.322594e-02},
  {-9.334790e-01,  3.492816e-01, -8.135916e-02, -4.231628e-01, -2.404061e-01,  4.059779e-02},
  { 9.021581e-01, -1.144697e-01, -4.159417e-01,  3.268187e-01, -2.095559e-01, -1.173735e-01},
  { 9.347367e-01,  1.194108e-01, -3.346767e-01,  4.211601e-01, -3.125875e-01,  1.074081e-02},
  { 8.467197e-01,  8.741331e-02, -5.248092e-01,  3.389520e-01, -2.274420e-01, -9.521955e-02},
  {-8.590544e-01,  4.780400e-01, -1.830390e-01, -3.649005e-01, -1.543426e-01, -2.432757e-02},
  {-8.304875e-01,  5.569488e-01,  9.926897e-03, -3.449298e-01, -1.281224e-01, -5.651763e-02},
  {-8.448333e-01,  3.196990e-01,  4.290097e-01, -4.976602e-01, -2.701577e-01, -1.483628e-01},
  { 8.336917e-01,  1.241667e-01, -5.380900e-01,  3.428636e-01, -2.858837e-01, -1.045561e-01},
  { 8.243906e-01, -3.465083e-01, -4.475623e-01,  2.719839e-01, -2.207889e-01, -2.363201e-01},
  {-7.191411e-01,  4.252030e-01,  5.495803e-01, -4.723625e-01, -2.526989e-01, -1.213683e-01},
  {-9.699698e-01,  1.270960e-01,  2.073766e-01, -5.179787e-01, -3.331957e-01, -1.649445e-01},
  { 7.526947e-01,  2.105410e-01, -6.237974e-01,  3.761705e-01, -3.606344e-01, -9.238101e-02},
  {-9.928104e-01,  5.425532e-02,  1.066950e-01, -5.307652e-01, -3.841711e-01, -2.161014e-01},
  { 6.385005e-01, -4.894327e-01, -5.939468e-01,  1.660514e-01, -2.006954e-01, -4.017792e-01},
  { 6.993847e-01, -2.928208e-01, -6.520099e-01,  1.406078e-01, -1.866169e-01, -4.357086e-01},
  { 6.905684e-01, -3.325532e-01, -6.422799e-01,  1.372624e-01, -1.805687e-01, -4.422607e-01},
  { 6.839517e-01, -7.181354e-01, -1.284200e-01,  4.169038e-01, -1.399070e-01, -4.461543e-01},
  { 8.676552e-01,  8.503174e-02, -4.898409e-01,  1.366363e-01, -2.844027e-01, -4.372192e-01},
  { 8.202931e-01, -5.259382e-01, -2.247407e-01,  4.168332e-01, -1.364021e-01, -4.575247e-01},
  { 8.335997e-01,  6.826361e-02, -5.481348e-01,  1.125608e-01, -4.104731e-01, -5.026377e-01},
  { 8.705322e-01, -3.270154e-02, -4.910237e-01,  8.110734e-02, -4.240068e-01, -5.625120e-01},
  { 6.341080e-01, -3.859788e-01, -6.700205e-01,  4.170901e-01, -1.268490e-01, -4.725648e-01},
  {-7.513831e-01, -1.001472e-01, -6.522223e-01, -4.459886e-01, -2.962935e-01, -6.510928e-01},
  {-1.590299e-01, -5.220595e-01, -8.379519e-01,  3.977824e-01, -1.271379e-01, -4.760045e-01},
  {-4.009829e-01, -8.569630e-02, -9.120684e-01, -3.289720e-01, -3.751456e-01, -7.287953e-01},
  { 8.127167e-02, -2.424540e-01, -9.667528e-01,  4.061387e-01, -1.183186e-01, -4.794650e-01},
  { 1.124818e-01, -1.454967e-01, -9.829438e-01, -2.128905e-01, -3.662463e-01, -7.472678e-01},
  { 4.557303e-01, -2.303431e-01,  8.597976e-01,  2.562887e-01, -2.779495e-01,  8.337628e-01},
  { 6.608207e-01,  1.011798e-01,  7.436926e-01,  3.245614e-01, -2.696834e-01,  7.846627e-01},
  {-1.713858e-01, -1.487449e-01,  9.739106e-01,  1.407770e-01, -3.110704e-01,  8.362196e-01},
  {-8.360564e-02, -1.243405e-01,  9.887110e-01,  1.757717e-01, -3.032451e-01,  8.413638e-01},
  {-7.331211e-01, -1.478479e-01,  6.638332e-01, -2.610906e-01, -3.646657e-01,  5.738875e-01},
  { 8.955556e-01, -1.395042e-01,  4.225149e-01,  3.694758e-01, -2.692790e-01,  7.220486e-01},
  {-7.363532e-01, -1.059253e-01,  6.682543e-01, -2.798402e-01, -3.183801e-01,  5.613337e-01},
  {-7.941906e-01, -2.473431e-01,  5.550519e-01, -3.664976e-01, -4.028542e-01,  4.262931e-01},
  {-8.995697e-01, -1.248332e-01,  4.185583e-01, -4.026435e-01, -3.162169e-01,  4.069599e-01},
  {-9.233742e-01, -1.156922e-01,  3.660538e-01, -4.033194e-01, -3.594492e-01,  3.840623e-01},
  {-8.061377e-01,  1.345382e-01,  5.762305e-01, -4.579246e-01, -3.914143e-01,  2.869811e-01},
  {-9.731379e-01, -5.372592e-02,  2.238666e-01, -4.725410e-01, -3.986775e-01,  2.547950e-01},
  {-9.172533e-01,  3.709912e-01, -1.449549e-01, -4.406056e-01, -2.679055e-01,  7.332612e-02},
  { 9.023712e-01, -2.971874e-01, -3.120991e-01,  3.250893e-01, -1.816177e-01, -1.383068e-01},
  {-9.164312e-01,  3.704524e-01, -1.513895e-01, -4.366381e-01, -2.604658e-01,  6.697104e-02},
  {-7.876555e-01,  5.587775e-01, -2.595508e-01, -4.425974e-01, -2.690530e-01,  8.308290e-02},
  {-8.559365e-01,  5.109445e-01, -7.942596e-02, -3.394815e-01, -1.190049e-01, -4.870481e-02},
  {-8.393555e-01,  5.248669e-01, -1.414109e-01, -3.320069e-01, -1.080483e-01, -5.307657e-02},
  {-8.341052e-01,  5.286891e-01, -1.573413e-01, -3.502885e-01, -1.327486e-01, -3.345098e-02},
  {-8.594140e-01,  4.380400e-01, -2.636825e-01, -3.854952e-01, -1.772520e-01,  8.987018e-03},
  {-8.595109e-01,  4.659391e-01, -2.100995e-01, -3.747570e-01, -1.627548e-01, -2.988430e-03},
  {-8.142424e-01,  5.770705e-01,  6.323805e-02, -3.256004e-01, -9.945547e-02, -7.494747e-02},
  { 8.744233e-01,  1.849465e-01, -4.485294e-01,  4.066979e-01, -3.161781e-01, -2.387725e-02},
  { 8.271075e-01, -4.232358e-01, -3.698169e-01,  2.876906e-01, -2.041746e-01, -2.198170e-01},
  { 8.680319e-01,  1.808775e-01, -4.623895e-01,  3.974563e-01, -3.331032e-01, -4.825524e-02},
  { 7.985204e-01,  2.543007e-01, -5.456154e-01,  3.736893e-01, -2.924031e-01, -6.822544e-02},
  { 8.530608e-01,  1.801622e-01, -4.897233e-01,  3.930883e-01, -3.367534e-01, -5.741952e-02},
  {-7.951980e-01,  5.804163e-01,  1.754341e-01, -3.440899e-01, -1.219681e-01, -8.558491e-02},
  {-7.170339e-01,  6.238092e-01,  3.110058e-01, -3.568777e-01, -1.354590e-01, -8.995938e-02},
  {-6.899489e-01,  6.130672e-01,  3.848626e-01, -3.679732e-01, -1.443894e-01, -9.614134e-02},
  { 7.632636e-01,  2.184719e-01, -6.080284e-01,  3.686847e-01, -3.420775e-01, -9.419341e-02},
  { 6.245687e-01, -5.886115e-01, -5.132743e-01,  2.238431e-01, -2.125447e-01, -3.285637e-01},
  {-9.967706e-01,  3.544931e-02,  7.205408e-02, -5.318943e-01, -3.677392e-01, -2.368030e-01},
  {-9.995474e-01, -2.757960e-02,  1.201260e-02, -5.334303e-01, -3.987674e-01, -2.926536e-01},
  { 3.165732e-01, -9.140814e-01,  2.534494e-01,  4.111997e-01, -1.419280e-01, -4.389967e-01},
  { 1.546735e-01, -9.426560e-01,  2.957629e-01,  4.050620e-01, -1.423090e-01, -4.363596e-01},
  { 2.053835e-01, -8.832943e-01,  4.214366e-01,  4.043043e-01, -1.412414e-01, -4.327756e-01},
  {-3.542278e-02, -9.892098e-01,  1.421592e-01,  3.934632e-01, -1.419756e-01, -4.349849e-01},
  {-9.977320e-01, -5.600549e-02, -3.734055e-02, -5.330456e-01, -3.929174e-01, -3.593906e-01},
  { 8.937674e-01, -3.898381e-01, -2.218248e-01,  4.195280e-01, -1.355101e-01, -4.461322e-01},
  { 8.377709e-01, -1.065690e-01, -5.355211e-01,  1.265291e-01, -1.976071e-01, -4.503686e-01},
  { 6.554266e-01, -2.811861e-01, -7.009639e-01,  1.269865e-01, -1.625137e-01, -4.611600e-01},
  {-9.941003e-01, -5.097495e-02, -9.573969e-02, -5.313565e-01, -3.573700e-01, -4.161821e-01},
  {-9.694003e-01, -6.799846e-02, -2.358795e-01, -5.228025e-01, -3.203709e-01, -4.791137e-01},
  {-3.066036e-01, -7.990474e-01, -5.172210e-01,  3.853457e-01, -1.350116e-01, -4.619296e-01},
  { 8.073680e-01,  5.218114e-03, -5.900251e-01,  4.824433e-02, -4.266755e-01, -6.151962e-01},
  {-9.038358e-01, -7.900906e-02, -4.205216e-01, -4.878106e-01, -3.051727e-01, -5.808157e-01},
  {-8.468696e-01, -6.652846e-02, -5.276229e-01, -4.604154e-01, -2.693374e-01, -6.360131e-01},
  { 8.826321e-01,  1.032948e-03, -4.700633e-01,  8.769134e-02, -3.774019e-01, -5.508569e-01},
  {-5.594531e-01, -2.296903e-01, -7.964010e-01, -4.013973e-01, -2.794640e-01, -6.966901e-01},
  {-5.050288e-01, -2.852024e-01, -8.146198e-01, -3.909318e-01, -2.711137e-01, -7.058800e-01},
  {-2.528891e-01, -1.498373e-01, -9.558221e-01, -3.017308e-01, -3.884651e-01, -7.376389e-01},
  { 2.234656e-01, -1.840775e-01, -9.571722e-01, -1.219859e-01, -3.479272e-01, -7.363025e-01},
  { 3.714269e-02, -1.522376e-01, -9.876457e-01, -2.358055e-01, -3.458340e-01, -7.522241e-01},
  {-2.095603e-01, -2.242646e-01,  9.517300e-01,  7.747685e-02, -2.817123e-01,  8.190372e-01},
  {-2.985660e-01, -1.035351e-01,  9.487565e-01,  1.007203e-01, -3.002928e-01,  8.267148e-01},
  { 8.502895e-02, -1.928514e-01,  9.775370e-01,  2.044758e-01, -2.875160e-01,  8.442451e-01},
  {-7.495327e-01, -1.710739e-01,  6.394798e-01, -2.982109e-01, -3.679689e-01,  5.312313e-01},
  { 7.606314e-01, -1.182609e-02,  6.490762e-01,  3.464539e-01, -2.617891e-01,  7.625328e-01},
  { 9.388700e-01, -1.512942e-02,  3.439395e-01,  3.759695e-01, -2.584071e-01,  7.106538e-01},
  { 9.653672e-01,  1.961160e-02,  2.601568e-01,  3.813423e-01, -2.643823e-01,  6.923747e-01},
  {-7.339324e-01, -7.135899e-02,  6.754636e-01, -2.947809e-01, -3.011592e-01,  5.471523e-01},
  {-7.669453e-01, -2.416286e-01,  5.944834e-01, -3.497673e-01, -3.666126e-01,  4.660978e-01},
  { 9.754151e-01, -2.502554e-02,  2.189502e-01,  3.858435e-01, -2.690873e-01,  6.716566e-01},
  {-7.625785e-01, -2.688599e-01,  5.883779e-01, -3.459338e-01, -4.456198e-01,  4.345822e-01},
  {-9.454893e-01, -1.654741e-01,  2.804784e-01, -4.094201e-01, -3.112846e-01,  3.926411e-01},
  {-9.169459e-01, -1.047870e-01,  3.850065e-01, -4.167662e-01, -3.385231e-01,  3.646061e-01},
  {-9.903738e-01,  6.917135e-02,  1.198961e-01, -4.715098e-01, -3.408382e-01,  2.134103e-01},
  { 9.840356e-01, -1.303155e-01,  1.212103e-01,  4.228590e-01, -3.648257e-01,  1.912098e-01},
  { 9.928941e-01, -9.686287e-02,  6.913067e-02,  4.336207e-01, -3.295173e-01,  1.354355e-01},
  { 9.994068e-01, -2.315642e-02, -2.549485e-02,  4.359834e-01, -3.141252e-01,  8.720136e-02},
  { 9.217908e-01, -1.297435e-01, -3.653333e-01,  3.425975e-01, -1.804682e-01, -8.823286e-02},
  { 8.752412e-01,  3.825959e-02, -4.821712e-01,  3.443690e-01, -2.052722e-01, -8.328826e-02},
  {-9.280196e-01,  3.567659e-01, -1.072270e-01, -4.166829e-01, -2.183752e-01,  5.381696e-02},
  { 8.836265e-01, -4.035969e-01, -2.373052e-01,  3.095612e-01, -1.886954e-01, -1.794513e-01},
  { 8.690984e-01,  5.845158e-02, -4.911735e-01,  3.615216e-01, -2.473965e-01, -6.715418e-02},
  {-8.446111e-01,  3.374298e-01,  4.156598e-01, -4.930204e-01, -2.560847e-01, -1.507679e-01},
  { 8.287488e-01, -4.894696e-01, -2.712837e-01,  3.025944e-01, -1.885096e-01, -2.018625e-01},
  {-7.475497e-01,  6.023718e-01,  2.798530e-01, -3.372810e-01, -1.114792e-01, -8.995952e-02},
  { 6.998815e-01, -6.406908e-01, -3.157234e-01,  2.690562e-01, -2.005043e-01, -2.705362e-01},
  { 6.413702e-01, -5.245118e-01, -5.599390e-01,  2.465491e-01, -2.065128e-01, -3.034035e-01},
  { 6.854734e-01, -5.178551e-01, -5.118127e-01,  2.400392e-01, -2.107549e-01, -3.077335e-01},
  { 2.960627e-01, -7.294872e-01, -6.165999e-01,  2.816801e-01, -1.787943e-01, -2.990698e-01},
  { 4.777372e-01, -7.583032e-01, -4.435577e-01,  2.679773e-01, -1.880889e-01, -3.009157e-01},
  { 3.939821e-01, -8.783719e-01, -2.706304e-01,  2.769664e-01, -1.762936e-01, -3.224786e-01},
  { 5.624377e-01, -7.563643e-01, -3.340313e-01,  2.553837e-01, -1.891108e-01, -3.221382e-01},
  { 5.440642e-01, -8.019618e-01, -2.466810e-01,  2.527868e-01, -1.847699e-01, -3.361943e-01},
  { 4.870335e-01, -7.816004e-01, -3.897425e-01,  2.386116e-01, -1.924124e-01, -3.388090e-01},
  { 4.940891e-01, -8.517191e-01, -1.745007e-01,  2.570246e-01, -1.817960e-01, -3.378370e-01},
  { 5.618701e-01, -4.619251e-01, -6.862413e-01,  1.556763e-01, -1.794114e-01, -4.264895e-01},
  { 6.662122e-01, -6.479121e-01,  3.692849e-01,  4.151370e-01, -1.388537e-01, -4.357984e-01},
  { 2.220544e-01, -8.977140e-01, -3.805278e-01,  2.658320e-01, -1.626657e-01, -3.835616e-01},
  { 7.215723e-01, -6.673558e-01,  1.843082e-01,  4.177054e-01, -1.387936e-01, -4.404466e-01},
  { 9.040881e-01, -4.273094e-01, -5.592641e-03,  4.204257e-01, -1.357878e-01, -4.427817e-01},
  { 9.501967e-01, -2.774014e-01,  1.420379e-01,  4.210055e-01, -1.321695e-01, -4.410397e-01},
  { 8.026728e-01,  1.337124e-01, -5.812379e-01,  1.294004e-01, -3.292034e-01, -4.601671e-01},
  { 7.584027e-01, -2.111291e-01, -6.166440e-01,  1.233035e-01, -1.788953e-01, -4.592406e-01},
  { 7.911055e-01, -1.939547e-01, -5.801153e-01,  1.212983e-01, -1.699585e-01, -4.648302e-01},
  {-2.505172e-01, -9.308188e-01, -2.661158e-01,  3.833776e-01, -1.380245e-01, -4.537353e-01},
  { 7.265337e-01, -4.474478e-02, -6.856725e-01,  1.980267e-02, -3.900689e-01, -6.520226e-01},
  { 7.423255e-01, -4.610669e-01, -4.861791e-01,  4.207581e-01, -1.241305e-01, -4.711700e-01},
  {-3.233415e-01, -6.266754e-01, -7.090333e-01,  3.838100e-01, -1.276937e-01, -4.705263e-01},
  {-9.331639e-01, -1.038146e-01, -3.441332e-01, -5.064056e-01, -2.945517e-01, -5.390480e-01},
  { 3.866411e-01, -1.783207e-01, -9.048262e-01,  4.148119e-01, -1.105060e-01, -4.793186e-01},
  {-6.965675e-01, -1.384684e-01, -7.040029e-01, -4.185991e-01, -2.430225e-01, -6.891747e-01},
  {-6.889407e-01, -1.683160e-01, -7.050038e-01, -4.130866e-01, -2.179554e-01, -7.000672e-01},
  { 4.740384e-01, -1.650557e-01, -8.648955e-01, -5.775297e-02, -3.308316e-01, -7.166057e-01},
  {-4.186379e-01, -2.208922e-01, -8.808796e-01, -3.513526e-01, -2.475285e-01, -7.330098e-01},
  {-4.794534e-01, -2.057205e-01, -8.531140e-01, -3.900564e-01, -2.164674e-01, -7.188624e-01},
  {-6.166582e-01, -2.297106e-01, -7.529713e-01, -4.048483e-01, -1.948684e-01, -7.142426e-01},
  {-6.157995e-01, -2.482982e-01, -7.477559e-01, -4.023551e-01, -1.814183e-01, -7.208549e-01},
  {-2.571268e-01, -1.363762e-01, -9.567065e-01, -2.857945e-01, -3.687885e-01, -7.440273e-01},
  {-6.246695e-01, -2.468241e-01, -7.408549e-01, -4.035192e-01, -1.727886e-01, -7.226403e-01},
  {-5.919983e-01, -2.355587e-01, -7.707465e-01, -3.990033e-01, -1.540299e-01, -7.329164e-01},
  { 3.650198e-03, -1.548592e-01, -9.879298e-01, -2.564600e-01, -3.477073e-01, -7.525809e-01},
  {-1.138462e-01, -1.049572e-01,  9.879388e-01,  2.160072e-01, -1.708522e-01,  8.626438e-01},
  {-4.635777e-01,  1.110342e-02,  8.859867e-01,  5.879842e-02, -2.303117e-01,  8.121341e-01},
  { 4.871423e-01, -2.252336e-01,  8.437786e-01,  2.759058e-01, -2.239602e-01,  8.386949e-01},
  { 6.082500e-01, -2.329909e-01,  7.587801e-01,  3.018411e-01, -2.374908e-01,  8.157575e-01},
  {-2.538265e-01, -1.284120e-01,  9.586879e-01,  8.062735e-02, -2.732042e-01,  8.221146e-01},
  {-3.070275e-01, -4.357365e-02,  9.507026e-01,  1.097836e-01, -2.841292e-01,  8.305089e-01},
  {-2.084892e-01, -6.773286e-02,  9.756764e-01,  1.401401e-01, -2.921499e-01,  8.383120e-01},
  { 8.827263e-01, -1.300050e-01,  4.515452e-01,  3.705608e-01, -2.467297e-01,  7.274485e-01},
  {-7.213143e-01, -2.111110e-02,  6.922861e-01, -3.127294e-01, -3.020344e-01,  5.278125e-01},
  {-8.079004e-01, -1.145482e-01,  5.780793e-01, -3.761502e-01, -3.153932e-01,  4.466401e-01},
  {-7.043625e-01,  1.891190e-02,  7.095885e-01, -2.739037e-01, -2.805031e-01,  5.707723e-01},
  {-6.820232e-01,  3.782733e-02,  7.303516e-01, -2.570066e-01, -2.736475e-01,  5.870072e-01},
  {-8.517745e-01, -3.030381e-02,  5.230315e-01, -3.993105e-01, -3.000368e-01,  4.162154e-01},
  {-9.540898e-01, -9.368834e-02,  2.844910e-01, -4.147391e-01, -2.925412e-01,  3.845543e-01},
  {-9.008684e-01, -2.121226e-02,  4.335736e-01, -4.064713e-01, -2.948635e-01,  4.027021e-01},
  { 9.866415e-01, -1.525494e-01,  5.716005e-02,  3.939698e-01, -3.247730e-01,  4.658286e-01},
  {-9.454724e-01,  2.165185e-02,  3.249817e-01, -4.711444e-01, -3.793463e-01,  2.609908e-01},
  {-9.615275e-01,  2.614677e-01,  8.425900e-02, -4.711145e-01, -3.428462e-01,  2.259322e-01},
  {-9.725245e-01,  1.952264e-01,  1.268177e-01, -4.724271e-01, -3.541269e-01,  2.360190e-01},
  {-9.676003e-01,  2.420215e-01,  7.193932e-02, -4.613051e-01, -2.940939e-01,  2.140226e-01},
  {-9.930633e-01,  5.073276e-02,  1.060734e-01, -4.755798e-01, -3.769855e-01,  2.342229e-01},
  {-9.743306e-01,  2.179027e-01,  5.655298e-02, -4.576239e-01, -2.752630e-01,  2.016928e-01},
  { 9.942489e-01, -7.970941e-02,  7.152233e-02,  4.343774e-01, -3.124282e-01,  1.450003e-01},
  { 9.374372e-01, -8.757296e-02, -3.369609e-01,  3.528935e-01, -1.530784e-01, -6.882488e-02},
  { 9.335095e-01, -2.805745e-01, -2.232442e-01,  3.385568e-01, -1.590815e-01, -1.139581e-01},
  { 9.659378e-01,  1.090587e-01, -2.346705e-01,  4.336863e-01, -2.807931e-01,  6.174241e-02},
  { 9.238370e-01, -7.684997e-02, -3.749923e-01,  3.500636e-01, -1.726497e-01, -7.208454e-02},
  {-9.795535e-01,  1.824688e-01,  8.473600e-02, -4.581697e-01, -2.917055e-01,  1.469715e-01},
  { 9.142645e-01, -3.131577e-01, -2.570071e-01,  3.292758e-01, -1.669689e-01, -1.409789e-01},
  {-8.595241e-01,  4.165114e-01, -2.962037e-01, -3.459407e-01, -1.174747e-01, -2.044631e-02},
  { 9.319043e-01,  1.359346e-01, -3.362679e-01,  4.229697e-01, -2.748809e-01,  2.933748e-02},
  {-8.383835e-01,  4.028182e-01, -3.672203e-01, -3.236007e-01, -9.025118e-02, -4.486733e-02},
  {-8.525217e-01,  4.078543e-01, -3.268971e-01, -3.554640e-01, -1.257562e-01, -6.408622e-03},
  {-8.544014e-01,  4.350320e-01, -2.841571e-01, -4.419841e-01, -2.516343e-01,  1.157194e-01},
  {-9.275010e-01,  3.184551e-01, -1.957760e-01, -4.244942e-01, -2.152203e-01,  8.724445e-02},
  { 8.574389e-01,  2.200139e-01, -4.651801e-01,  3.973131e-01, -2.815412e-01, -2.737562e-02},
  {-9.366062e-01,  2.138636e-01,  2.775451e-01, -5.124149e-01, -2.900594e-01, -1.701978e-01},
  { 7.729213e-01, -5.111611e-01, -3.759082e-01,  3.045480e-01, -1.716520e-01, -2.410900e-01},
  {-9.828743e-01,  1.020673e-01,  1.534293e-01, -5.266221e-01, -3.257723e-01, -2.157141e-01},
  { 4.427451e-01, -7.652268e-01, -4.673380e-01,  2.379445e-01, -1.837904e-01, -3.551950e-01},
  { 5.592627e-01, -5.127239e-01, -6.514133e-01,  1.894505e-01, -1.952288e-01, -3.845202e-01},
  { 5.691712e-01, -5.846011e-01, -5.781745e-01,  1.828395e-01, -1.913955e-01, -3.939699e-01},
  { 3.805683e-01, -9.095577e-01, -1.669510e-01,  2.793351e-01, -1.683878e-01, -3.567987e-01},
  { 4.913725e-01, -7.334602e-01,  4.696693e-01,  4.152649e-01, -1.359472e-01, -4.310560e-01},
  { 5.793843e-01, -6.507224e-01,  4.907894e-01,  4.120694e-01, -1.344838e-01, -4.261129e-01},
  { 4.112614e-01, -7.953030e-01,  4.453730e-01,  4.080174e-01, -1.336107e-01, -4.209723e-01},
  { 2.156259e-01, -9.368852e-01,  2.752303e-01,  3.801422e-01, -1.389444e-01, -4.115229e-01},
  {-2.406841e-02, -9.996448e-01,  1.144757e-02,  3.734124e-01, -1.413537e-01, -4.217589e-01},
  { 8.805200e-01, -4.181404e-01,  2.232557e-01,  4.223667e-01, -1.275930e-01, -4.364016e-01},
  {-9.880188e-01, -5.437652e-02, -1.444370e-01, -5.303048e-01, -3.192067e-01, -4.416988e-01},
  { 5.951748e-01, -3.720351e-01, -7.122899e-01,  1.236127e-01, -1.449813e-01, -4.731025e-01},
  {-9.464039e-01, -8.036584e-02, -3.128274e-01, -5.127508e-01, -2.976602e-01, -5.195355e-01},
  { 8.907202e-01, -4.349922e-01, -1.319061e-01,  4.268090e-01, -1.204293e-01, -4.573750e-01},
  { 6.145533e-01, -8.779117e-02, -7.839751e-01, -2.613566e-03, -3.739156e-01, -6.742135e-01},
  {-8.260658e-01, -6.634582e-02, -5.596549e-01, -4.583536e-01, -2.415800e-01, -6.425221e-01},
  { 8.363704e-01, -3.893255e-02, -5.467803e-01,  5.361634e-02, -3.240884e-01, -6.122724e-01},
  { 7.487875e-01, -4.861627e-02, -6.610247e-01,  1.867652e-02, -3.449236e-01, -6.579924e-01},
  { 6.558225e-01, -6.831922e-02, -7.518173e-01,  4.260384e-01, -1.047897e-01, -4.754594e-01},
  { 6.941659e-01,  3.012553e-01, -6.537422e-01,  4.251797e-01, -1.015847e-01, -4.755323e-01},
  { 6.338672e-01, -3.038788e-01, -7.112454e-01,  4.234719e-01, -1.118192e-01, -4.743758e-01},
  { 6.830735e-01, -3.145662e-01, -6.591347e-01,  4.257286e-01, -1.104789e-01, -4.727446e-01},
  {-2.373919e-01, -3.589911e-01, -9.026463e-01,  3.835428e-01, -1.138538e-01, -4.786861e-01},
  { 2.213148e-01, -3.639333e-02, -9.745231e-01,  4.102506e-01, -1.044626e-01, -4.810709e-01},
  { 5.873075e-03, -1.409360e-01, -9.900013e-01,  3.964419e-01, -1.067585e-01, -4.820861e-01},
  {-2.708995e-01, -1.074083e-01, -9.565966e-01, -3.068969e-01, -2.624333e-01, -7.493362e-01},
  {-4.178050e-01, -1.578327e-01, -8.947222e-01, -3.952600e-01, -1.532577e-01, -7.352504e-01},
  { 7.686353e-02, -1.453672e-01, -9.863876e-01, -2.229411e-01, -3.228840e-01, -7.558932e-01},
  { 1.666532e-02, -1.082367e-01,  9.939855e-01,  2.357823e-01, -1.696058e-01,  8.637550e-01},
  {-4.528988e-02, -1.433790e-01,  9.886310e-01,  2.248656e-01, -1.822194e-01,  8.619336e-01},
  {-1.336737e-01, -6.081964e-02,  9.891574e-01,  2.164482e-01, -1.557720e-01,  8.638794e-01},
  {-5.463579e-02, -1.573851e-01,  9.860248e-01,  2.209934e-01, -1.911045e-01,  8.604429e-01},
  { 3.078144e-01, -2.072323e-01,  9.286038e-01,  2.516406e-01, -2.371502e-01,  8.469049e-01},
  {-1.115163e-01, -8.683319e-02,  9.899617e-01,  2.060407e-01, -2.267486e-01,  8.537223e-01},
  {-2.136830e-01,  9.635478e-02,  9.721396e-01,  1.728702e-01, -2.336836e-01,  8.478358e-01},
  {-2.409394e-01, -5.396916e-03,  9.705251e-01,  1.481635e-01, -2.373639e-01,  8.422333e-01},
  {-2.275784e-01, -2.534032e-02,  9.734300e-01,  1.389713e-01, -2.569186e-01,  8.392048e-01},
  {-2.839448e-01, -3.092045e-04,  9.588405e-01,  1.227392e-01, -2.676424e-01,  8.346689e-01},
  { 1.258605e-01, -2.519602e-01,  9.595182e-01,  2.322902e-01, -2.648767e-01,  8.461537e-01},
  { 7.517902e-01, -1.851523e-01,  6.328745e-01,  3.352171e-01, -2.356462e-01,  7.830762e-01},
  {-7.575467e-01, -1.867234e-01,  6.255056e-01, -3.230782e-01, -3.394477e-01,  5.106757e-01},
  {-7.166714e-01, -1.215913e-02,  6.973050e-01, -3.176341e-01, -2.972644e-01,  5.228747e-01},
  {-7.418079e-01, -5.767930e-02,  6.681273e-01, -3.225416e-01, -2.982210e-01,  5.174338e-01},
  {-8.052459e-01, -1.575909e-01,  5.716152e-01, -3.665428e-01, -3.118103e-01,  4.606557e-01},
  {-7.214907e-01,  9.328377e-03,  6.923612e-01, -2.954464e-01, -2.543875e-01,  5.484003e-01},
  {-7.265585e-01,  2.571143e-02,  6.866233e-01, -3.049037e-01, -2.368477e-01,  5.381024e-01},
  {-7.333518e-01,  3.491648e-02,  6.789522e-01, -3.196056e-01, -2.296864e-01,  5.216832e-01},
  {-7.392163e-01,  4.849470e-02,  6.717197e-01, -3.215481e-01, -2.185173e-01,  5.188912e-01},
  {-7.444841e-01,  1.106682e-01,  6.584041e-01, -3.290493e-01, -2.062607e-01,  5.093631e-01},
  { 9.507765e-01, -9.293474e-02,  2.956133e-01,  4.087779e-01, -3.460539e-01,  3.074784e-01},
  {-9.823480e-01,  1.720598e-01,  7.340240e-02, -4.557380e-01, -2.695611e-01,  2.112035e-01},
  {-9.929860e-01, -2.723461e-02,  1.150529e-01, -4.767356e-01, -3.752309e-01,  2.155766e-01},
  { 9.201306e-01, -4.405070e-02, -3.891264e-01,  3.610926e-01, -1.516669e-01, -4.907192e-02},
  { 8.801144e-01,  5.230373e-02, -4.718717e-01,  3.589076e-01, -1.798942e-01, -5.418620e-02},
  {-8.587173e-01,  4.879230e-01, -1.566390e-01, -3.050561e-01, -6.608133e-02, -6.473575e-02},
  { 8.765023e-01,  2.215419e-01, -4.273908e-01,  4.142911e-01, -2.599680e-01,  1.378569e-02},
  {-8.297597e-01,  4.023055e-01, -3.868453e-01, -3.765326e-01, -1.487740e-01,  2.047611e-02},
  { 8.884055e-01, -4.542892e-01, -6.600793e-02,  3.335273e-01, -1.460234e-01, -1.689937e-01},
  {-8.213798e-01,  5.557370e-01,  1.284195e-01, -3.058285e-01, -6.908782e-02, -8.764411e-02},
  {-7.672907e-01,  5.781911e-01,  2.774164e-01, -3.203679e-01, -8.777770e-02, -9.363849e-02},
  { 7.976596e-01, -5.460095e-01, -2.561499e-01,  3.231166e-01, -1.526138e-01, -2.296288e-01},
  {-6.427552e-01,  5.894907e-01,  4.892510e-01, -3.569722e-01, -1.214858e-01, -1.100177e-01},
  {-9.867795e-01,  1.021382e-01,  1.258331e-01, -5.281801e-01, -3.007426e-01, -2.452862e-01},
  {-9.986659e-01,  3.047175e-02,  4.168937e-02, -5.336082e-01, -3.387599e-01, -2.873086e-01},
  { 3.266884e-01, -9.420792e-01, -7.590348e-02,  3.019543e-01, -1.603919e-01, -3.570056e-01},
  { 3.254628e-01, -8.758259e-01, -3.563749e-01,  2.232001e-01, -1.708155e-01, -3.879853e-01},
  { 4.398777e-01, -7.366896e-01, -5.136109e-01,  1.988083e-01, -1.771536e-01, -3.959105e-01},
  { 1.395072e-01, -9.618453e-01,  2.353538e-01,  3.747419e-01, -1.384499e-01, -4.055781e-01},
  {-9.997440e-01,  1.743664e-02, -1.441632e-02, -5.345156e-01, -3.331645e-01, -3.655748e-01},
  {-9.977218e-01,  1.430349e-02, -6.592969e-02, -5.321097e-01, -2.899532e-01, -4.268614e-01},
  { 5.350343e-01, -4.552522e-01, -7.116767e-01,  1.478942e-01, -1.556854e-01, -4.484782e-01},
  { 8.971877e-01, -4.337851e-01, -8.297408e-02,  4.264422e-01, -1.226774e-01, -4.469743e-01},
  {-2.747674e-01, -9.145676e-01, -2.967641e-01,  3.668092e-01, -1.360510e-01, -4.442429e-01},
  {-3.593721e-01, -7.878654e-01, -5.001199e-01,  3.675361e-01, -1.300372e-01, -4.578910e-01},
  { 9.776095e-01, -1.031018e-01, -1.834391e-01,  4.335561e-01, -9.995724e-02, -4.538443e-01},
  { 8.929241e-01, -2.485582e-02, -4.495206e-01,  1.098999e-01, -1.824645e-01, -4.832449e-01},
  { 8.015821e-01, -1.598252e-01, -5.761269e-01,  1.125301e-01, -1.486976e-01, -4.833119e-01},
  {-8.905999e-01, -3.502912e-02, -4.534366e-01, -4.770515e-01, -2.489650e-01, -6.081749e-01},
  { 8.943755e-01, -3.389932e-01, -2.918494e-01,  4.297343e-01, -1.109516e-01, -4.644269e-01},
  { 8.969021e-01, -2.670125e-02, -4.414224e-01,  8.468466e-02, -2.846829e-01, -5.587323e-01},
  {-3.098948e-01, -5.734042e-01, -7.584015e-01,  3.724500e-01, -1.184035e-01, -4.724516e-01},
  { 7.231498e-01, -9.331582e-02, -6.843585e-01,  1.357272e-02, -3.343258e-01, -6.639171e-01},
  { 6.012278e-01, -1.186564e-01, -7.902188e-01, -5.793162e-03, -3.538004e-01, -6.792233e-01},
  { 8.836159e-01,  1.605177e-01, -4.398374e-01,  4.284543e-01, -1.009683e-01, -4.700494e-01},
  { 7.867564e-01, -1.167051e-01, -6.061306e-01,  3.069570e-02, -3.045686e-01, -6.473671e-01},
  {-7.833757e-01, -9.784446e-02, -6.137988e-01, -4.423697e-01, -2.122849e-01, -6.686410e-01},
  { 5.885351e-01,  2.010234e-01, -7.830811e-01,  4.217725e-01, -9.853426e-02, -4.769788e-01},
  {-4.222185e-01, -2.630380e-01, -8.674922e-01, -3.820287e-01, -1.712678e-01, -7.362298e-01},
  { 2.604709e-02, -1.367035e-01, -9.902695e-01, -2.303594e-01, -3.048275e-01, -7.579281e-01},
  {-8.735672e-02, -9.527859e-02, -9.916102e-01, -2.531614e-01, -3.231308e-01, -7.551656e-01},
  { 4.804284e-01, -4.626587e-01,  7.450742e-01,  2.769106e-01, -1.787351e-01,  8.501683e-01},
  { 2.522575e-01, -3.940780e-01,  8.837809e-01,  2.534762e-01, -1.839152e-01,  8.600703e-01},
  { 1.793258e-01, -3.659521e-01,  9.131929e-01,  2.442667e-01, -1.854015e-01,  8.606233e-01},
  { 3.670442e-01, -2.369125e-01,  8.995283e-01,  2.618231e-01, -2.071451e-01,  8.501859e-01},
  { 1.259905e-01, -1.913219e-01,  9.734076e-01,  2.414048e-01, -1.940039e-01,  8.593491e-01},
  { 1.274451e-01, -2.041814e-01,  9.706017e-01,  2.362457e-01, -2.013827e-01,  8.586422e-01},
  { 1.624083e-02, -2.493125e-01,  9.682869e-01,  2.235733e-01, -2.493599e-01,  8.500813e-01},
  { 8.453125e-01, -1.213758e-01,  5.203024e-01,  3.631629e-01, -2.176271e-01,  7.483971e-01},
  { 9.450532e-01, -1.190089e-01,  3.044851e-01,  3.830850e-01, -2.336600e-01,  7.014078e-01},
  {-7.604702e-01,  2.276059e-02,  6.489738e-01, -3.458128e-01, -2.550700e-01,  4.907920e-01},
  {-9.562349e-01, -1.040708e-01,  2.734667e-01, -4.264244e-01, -2.717700e-01,  3.561440e-01},
  {-9.546511e-01, -5.260145e-02,  2.930433e-01, -4.213615e-01, -2.664515e-01,  3.688850e-01},
  {-9.639998e-01, -1.143515e-01,  2.400585e-01, -4.286723e-01, -2.664061e-01,  3.497000e-01},
  {-9.604489e-01, -5.477943e-03,  2.784023e-01, -4.324868e-01, -2.739792e-01,  3.373067e-01},
  {-7.819528e-01,  1.255448e-01,  6.105640e-01, -3.555175e-01, -1.710117e-01,  4.731889e-01},
  {-9.024448e-01,  1.334344e-01,  4.096201e-01, -4.695097e-01, -3.725372e-01,  2.643043e-01},
  {-9.718177e-01,  1.248549e-01,  1.999540e-01, -4.718184e-01, -3.642322e-01,  2.523860e-01},
  {-9.422204e-01,  3.113067e-01,  1.237288e-01, -4.649115e-01, -3.263730e-01,  2.462511e-01},
  { 9.992185e-01, -7.639435e-03,  3.878196e-02,  4.320500e-01, -2.907252e-01,  1.910887e-01},
  { 9.496179e-01, -2.226506e-01, -2.205733e-01,  3.469580e-01, -1.385450e-01, -1.021612e-01},
  { 9.887748e-01,  6.162160e-02, -1.361144e-01,  4.326708e-01, -2.530457e-01,  7.126849e-02},
  {-8.478434e-01,  3.564228e-01, -3.925866e-01, -3.346679e-01, -8.942984e-02, -1.743327e-02},
  { 8.654998e-01,  1.137654e-01, -4.878191e-01,  3.818837e-01, -2.083491e-01, -2.333550e-02},
  {-8.329116e-01,  5.508730e-01,  5.288787e-02, -2.989784e-01, -5.889086e-02, -8.860444e-02},
  {-9.087924e-01,  2.312383e-01,  3.473113e-01, -5.110781e-01, -2.487641e-01, -1.979944e-01},
  {-6.815941e-01,  5.862672e-01,  4.378588e-01, -3.405950e-01, -1.038683e-01, -1.095605e-01},
  {-5.546914e-01,  5.618716e-01,  6.136917e-01, -3.650734e-01, -1.194898e-01, -1.199861e-01},
  {-9.999610e-01,  1.607839e-03,  8.687293e-03, -5.344235e-01, -3.444798e-01, -3.348580e-01},
  { 7.649179e-01, -5.444665e-01,  3.441757e-01,  4.176547e-01, -1.184773e-01, -4.118855e-01},
  { 3.705941e-01, -6.500054e-01, -6.634403e-01,  1.961316e-01, -1.661810e-01, -4.090638e-01},
  { 7.311633e-01, -5.533248e-01,  3.990388e-01,  4.188980e-01, -1.247308e-01, -4.233588e-01},
  { 1.727528e-01, -9.690224e-01,  1.764994e-01,  3.666149e-01, -1.393062e-01, -4.038011e-01},
  { 2.314684e-01, -6.284805e-01, -7.425864e-01,  2.226627e-01, -1.523951e-01, -4.111582e-01},
  {-9.818397e-01, -2.841214e-02, -1.875726e-01, -5.291898e-01, -2.822945e-01, -4.608768e-01},
  {-1.600060e-01, -9.417098e-01, -2.959405e-01,  3.575817e-01, -1.397707e-01, -4.248384e-01},
  {-2.556442e-01, -9.021847e-01, -3.474320e-01,  3.517483e-01, -1.377382e-01, -4.266110e-01},
  { 9.904926e-01, -8.514506e-02, -1.080495e-01,  4.361078e-01, -8.799496e-02, -4.392713e-01},
  { 9.505339e-01, -3.073994e-01,  4.461882e-02,  4.322302e-01, -1.064954e-01, -4.406869e-01},
  { 6.170954e-01, -3.572919e-01, -7.010961e-01,  1.220080e-01, -1.275061e-01, -4.830400e-01},
  {-9.880996e-01,  1.253281e-01, -8.917427e-02, -5.217744e-01, -1.626589e-01, -4.666051e-01},
  {-9.835607e-01,  4.968223e-02, -1.736087e-01, -5.237415e-01, -2.078235e-01, -4.853100e-01},
  { 7.751579e-01, -2.540562e-01, -5.784338e-01,  1.108734e-01, -1.405538e-01, -4.881028e-01},
  {-3.836109e-01, -7.043042e-01, -5.973261e-01,  3.640022e-01, -1.253405e-01, -4.620577e-01},
  { 8.912663e-01, -4.936976e-02, -4.507848e-01,  1.050546e-01, -1.556478e-01, -4.943109e-01},
  { 8.336343e-01, -1.938045e-01, -5.171978e-01,  1.044070e-01, -1.413307e-01, -4.978397e-01},
  { 8.827261e-01,  1.254950e-01, -4.528197e-01,  4.311769e-01, -9.350991e-02, -4.623846e-01},
  {-2.883839e-01, -4.684433e-01, -8.351021e-01,  3.683901e-01, -1.136693e-01, -4.744283e-01},
  { 8.401671e-01, -5.658432e-02, -5.393677e-01,  5.963922e-02, -2.872241e-01, -6.064130e-01},
  { 9.187371e-01, -2.687074e-03, -3.948608e-01,  7.463814e-02, -2.411969e-01, -5.821908e-01},
  { 6.849996e-01, -1.229545e-01, -7.180930e-01,  2.712487e-03, -2.902672e-01, -6.817479e-01},
  { 5.985480e-01, -1.461878e-01, -7.876354e-01, -2.067178e-02, -3.176151e-01, -6.966673e-01},
  { 8.308342e-01, -1.074037e-01, -5.460577e-01,  2.613856e-02, -2.713073e-01, -6.583208e-01},
  {-1.294155e-01, -2.264906e-01, -9.653775e-01,  3.818240e-01, -9.775546e-02, -4.825321e-01},
  {-2.204110e-01, -1.503417e-01, -9.637511e-01, -2.649464e-01, -2.154118e-01, -7.671201e-01},
  {-7.590667e-01, -1.520444e-01, -6.330089e-01, -4.191572e-01, -1.704262e-01, -7.055324e-01},
  { 4.159054e-01, -1.547648e-01, -8.961421e-01, -7.467762e-02, -2.861384e-01, -7.339268e-01},
  {-9.819902e-02, -1.175908e-01, -9.881951e-01, -2.476475e-01, -2.711362e-01, -7.618106e-01},
  { 1.864462e-01, -1.906259e-01, -9.637944e-01, -1.104816e-01, -2.996283e-01, -7.435036e-01},
  {-3.590479e-01, -1.616340e-01, -9.192166e-01, -3.817651e-01, -1.546333e-01, -7.401242e-01},
  { 6.323538e-02, -1.857432e-01, -9.805614e-01, -2.089697e-01, -2.819280e-01, -7.609389e-01},
  {-8.768713e-02, -1.156281e-01, -9.894145e-01, -2.474106e-01, -3.093782e-01, -7.570464e-01},
  {-6.190600e-01, -1.199162e-02, -7.852520e-01, -4.026304e-01, -1.433870e-01, -7.307960e-01},
  {-5.530428e-01,  1.748196e-03, -8.331510e-01, -3.964017e-01, -1.364579e-01, -7.361686e-01},
  { 1.642926e-01, -9.105727e-02,  9.821999e-01,  2.560885e-01, -1.358607e-01,  8.655095e-01},
  {-2.148195e-01, -8.095633e-02,  9.732927e-01,  1.880984e-01, -1.326668e-01,  8.597617e-01},
  {-4.733039e-01, -6.028081e-02,  8.788342e-01,  8.145639e-02, -1.846953e-01,  8.218101e-01},
  { 1.806934e-01, -2.105301e-01,  9.607429e-01,  2.411773e-01, -2.234431e-01,  8.531922e-01},
  {-6.416257e-01,  1.580540e-03,  7.670163e-01,  7.867482e-02, -1.759702e-01,  8.209118e-01},
  { 6.812524e-01, -1.965417e-01,  7.051713e-01,  3.124460e-01, -1.955245e-01,  8.184562e-01},
  {-6.690878e-01,  1.448540e-02,  7.430421e-01,  7.986962e-02, -1.714004e-01,  8.231906e-01},
  {-6.353942e-01,  1.144152e-01,  7.636644e-01,  8.108415e-02, -1.638663e-01,  8.223984e-01},
  {-7.739073e-01, -9.677801e-02,  6.258606e-01, -3.370567e-01, -3.161965e-01,  4.997345e-01},
  {-8.201880e-01,  2.888943e-02,  5.713642e-01, -3.677408e-01, -2.014968e-01,  4.588118e-01},
  {-9.851344e-01, -3.882156e-02,  1.673411e-01, -4.442974e-01, -2.632178e-01,  2.882482e-01},
  {-8.822725e-01, -8.504102e-02,  4.629939e-01, -4.461051e-01, -2.752158e-01,  2.819898e-01},
  {-8.793527e-01,  1.273958e-02,  4.760006e-01, -4.516717e-01, -2.973855e-01,  2.683414e-01},
  {-8.923128e-01,  2.371296e-01,  3.841192e-01, -4.677934e-01, -3.554522e-01,  2.594683e-01},
  {-9.000136e-01,  2.410398e-01,  3.631465e-01, -4.654149e-01, -3.454041e-01,  2.587357e-01},
  {-9.279579e-01,  1.766551e-01,  3.281574e-01, -4.602112e-01, -3.168458e-01,  2.520556e-01},
  { 9.618654e-01, -1.880835e-01, -1.985937e-01,  3.636093e-01, -1.070552e-01, -5.684720e-02},
  { 9.999653e-01, -5.851875e-03,  5.946030e-03,  4.376334e-01, -2.684527e-01,  1.259370e-01},
  {-9.780633e-01,  1.645422e-01, -1.277413e-01, -4.215877e-01, -1.867718e-01,  1.048041e-01},
  {-8.466904e-01,  2.794939e-01, -4.527677e-01, -3.735850e-01, -1.202181e-01,  3.760498e-02},
  {-8.627873e-01,  4.462922e-01, -2.375319e-01, -2.905881e-01, -4.021742e-02, -6.953496e-02},
  { 8.957793e-01,  1.342513e-01, -4.237405e-01,  4.102099e-01, -2.168901e-01,  2.123389e-02},
  {-8.713362e-01,  4.765942e-01, -1.167529e-01, -2.841491e-01, -3.549487e-02, -8.672352e-02},
  {-8.188198e-01,  2.938544e-01,  4.931368e-01, -4.883747e-01, -2.266676e-01, -1.655224e-01},
  {-8.203281e-01,  5.497844e-01,  1.574768e-01, -2.871363e-01, -3.886881e-02, -1.006120e-01},
  { 8.014426e-01, -5.947884e-01, -6.258186e-02,  3.437481e-01, -1.288219e-01, -2.182759e-01},
  {-9.024479e-01,  2.164987e-01,  3.724461e-01, -5.061612e-01, -2.341621e-01, -1.929483e-01},
  {-8.844508e-01,  2.986343e-01,  3.585588e-01, -5.047998e-01, -2.286160e-01, -1.936500e-01},
  {-9.089260e-01,  1.720740e-01,  3.797946e-01, -5.086114e-01, -2.393069e-01, -1.964524e-01},
  { 7.549263e-01, -5.596331e-01,  3.419023e-01,  4.098368e-01, -1.096044e-01, -3.727328e-01},
  {-9.965556e-01,  6.772321e-02,  4.785865e-02, -5.321448e-01, -3.010285e-01, -2.961711e-01},
  { 4.689061e-01, -7.964010e-01,  3.819325e-01,  4.017695e-01, -1.129268e-01, -3.689413e-01},
  { 6.320480e-01, -7.681940e-01,  1.019475e-01,  3.341508e-01, -1.438573e-01, -3.187360e-01},
  { 6.508482e-01, -7.158725e-01,  2.528302e-01,  4.136329e-01, -1.119233e-01, -3.914837e-01},
  { 4.852061e-01, -8.045437e-01,  3.424683e-01,  4.014745e-01, -1.201009e-01, -3.850035e-01},
  {-9.988928e-01,  3.466416e-02, -3.180733e-02, -5.314815e-01, -2.638985e-01, -4.235933e-01},
  { 7.843462e-01, -5.597443e-01,  2.673713e-01,  4.205053e-01, -1.085962e-01, -4.012661e-01},
  { 4.136500e-01, -5.857542e-01, -6.969832e-01,  1.773531e-01, -1.621651e-01, -4.241678e-01},
  { 2.913792e-01, -9.333491e-01, -2.096606e-01,  3.094659e-01, -1.536172e-01, -3.797335e-01},
  { 3.755375e-01, -5.925273e-01, -7.126592e-01,  1.815137e-01, -1.524932e-01, -4.299327e-01},
  {-9.958898e-01,  8.654679e-02, -2.670688e-02, -5.291363e-01, -2.260308e-01, -4.407556e-01},
  {-9.963553e-01,  1.432446e-02, -8.408842e-02, -5.298721e-01, -2.486390e-01, -4.544148e-01},
  {-3.546767e-02, -9.976494e-01, -5.863350e-02,  3.525373e-01, -1.398081e-01, -4.162719e-01},
  {-9.903875e-01, -7.138904e-03, -1.381365e-01, -5.272101e-01, -2.675998e-01, -4.721717e-01},
  { 9.098173e-01, -3.623753e-01,  2.022785e-01,  4.304471e-01, -1.058061e-01, -4.266209e-01},
  {-5.659490e-02, -9.763260e-01, -2.087687e-01,  3.462243e-01, -1.402922e-01, -4.088163e-01},
  { 1.715401e-01, -8.920898e-01, -4.180309e-01,  2.997448e-01, -1.512564e-01, -3.944874e-01},
  { 3.650277e-03, -4.699849e-01, -8.826669e-01,  2.436175e-01, -1.442128e-01, -4.150207e-01},
  { 9.822927e-01, -1.870237e-01, -1.110288e-02,  4.372473e-01, -8.275428e-02, -4.260439e-01},
  {-9.584009e-01, -3.510717e-02, -2.832581e-01, -5.156891e-01, -2.698944e-01, -5.151164e-01},
  { 9.461043e-01,  6.332870e-02, -3.176101e-01,  4.336914e-01, -8.562536e-02, -4.542358e-01},
  { 7.488986e-01, -2.089381e-01, -6.288844e-01,  1.079488e-01, -1.182524e-01, -4.996167e-01},
  {-9.255837e-01, -3.085718e-02, -3.772835e-01, -5.048701e-01, -2.620816e-01, -5.475920e-01},
  { 9.075549e-01, -6.335612e-02, -4.151268e-01,  6.567389e-02, -2.112840e-01, -6.037636e-01},
  { 7.044575e-01, -1.423253e-01, -6.953294e-01,  3.036680e-03, -2.702470e-01, -6.851903e-01},
  {-8.125783e-01, -7.356899e-02, -5.781903e-01, -4.405755e-01, -1.889902e-01, -6.741383e-01},
  { 3.784768e-01,  9.692155e-02, -9.205225e-01,  4.144707e-01, -9.003326e-02, -4.794202e-01},
  {-3.539244e-01, -1.377925e-01, -9.250680e-01, -3.236776e-01, -1.978933e-01, -7.527179e-01},
  {-7.943951e-01, -5.833575e-02, -6.045935e-01, -4.160970e-01, -1.486909e-01, -7.133216e-01},
  {-9.747043e-02, -1.452274e-01, -9.845855e-01, -2.302150e-01, -2.414006e-01, -7.672392e-01},
  {-4.882959e-01,  4.665356e-02, -8.714302e-01, -3.923358e-01, -1.328847e-01, -7.381865e-01},
  { 4.371815e-01, -1.907624e-01,  8.789096e-01,  2.812933e-01, -1.495945e-01,  8.565468e-01},
  {-3.794012e-02, -2.537833e-02,  9.989578e-01,  2.373466e-01, -1.207747e-01,  8.669974e-01},
  { 6.044083e-01, -2.073700e-01,  7.692128e-01,  2.964475e-01, -1.644911e-01,  8.408933e-01},
  {-3.127204e-01, -1.044415e-01,  9.440858e-01,  1.337817e-01, -1.386339e-01,  8.443934e-01},
  {-3.786811e-01, -4.660871e-02,  9.243529e-01,  1.029137e-01, -1.541950e-01,  8.320188e-01},
  {-4.152910e-01, -9.104310e-02,  9.051213e-01,  9.365837e-02, -1.457054e-01,  8.288072e-01},
  {-2.521656e-01, -4.472679e-02,  9.666499e-01,  1.528899e-01, -1.004105e-01,  8.529122e-01},
  { 7.834213e-01, -1.521075e-01,  6.025898e-01,  3.411674e-01, -1.887698e-01,  7.878729e-01},
  {-3.890560e-01, -1.657722e-01,  9.061760e-01,  9.659754e-02, -1.100505e-01,  8.327242e-01},
  {-3.533281e-01, -6.375107e-02,  9.333248e-01,  1.111225e-01, -9.429582e-02,  8.399764e-01},
  {-4.237644e-01, -1.516465e-01,  8.929877e-01,  6.723765e-02, -1.142564e-01,  8.187622e-01},
  { 9.737297e-01, -1.366766e-01,  1.821267e-01,  3.981604e-01, -2.036100e-01,  6.515416e-01},
  {-8.026690e-01, -3.260149e-02,  5.955328e-01, -3.682732e-01, -2.901980e-01,  4.612279e-01},
  {-8.638910e-01,  6.837428e-02,  4.990164e-01, -3.768443e-01, -1.905418e-01,  4.446556e-01},
  {-8.511944e-01,  5.065323e-02,  5.224005e-01, -3.843438e-01, -1.755449e-01,  4.316782e-01},
  { 9.392771e-01, -6.454118e-02, -3.370358e-01,  3.719154e-01, -1.056507e-01, -2.878034e-02},
  {-9.805241e-01,  1.782917e-01, -8.236852e-02, -4.378844e-01, -1.828564e-01,  1.738113e-01},
  { 9.993547e-01,  1.732622e-02, -3.146464e-02,  4.371254e-01, -2.415647e-01,  1.139809e-01},
  { 9.485420e-01,  1.207634e-01, -2.927188e-01,  4.222609e-01, -2.127939e-01,  5.235576e-02},
  {-9.648256e-01,  1.389337e-01, -2.231791e-01, -4.207527e-01, -1.743088e-01,  1.106239e-01},
  {-8.575986e-01,  3.398384e-01, -3.860500e-01, -2.995596e-01, -3.895285e-02, -4.693601e-02},
  {-7.854738e-01,  5.589494e-01,  2.657190e-01, -2.823636e-01, -2.610604e-02, -1.158272e-01},
  {-7.325289e-01,  5.742850e-01,  3.655111e-01, -3.171745e-01, -6.863379e-02, -1.192328e-01},
  {-6.434192e-01,  5.724315e-01,  5.082656e-01, -3.277816e-01, -8.100048e-02, -1.193065e-01},
  {-9.519395e-01,  2.150938e-01,  2.180500e-01, -5.158181e-01, -2.406613e-01, -2.246386e-01},
  {-5.449095e-01,  5.585696e-01,  6.253589e-01, -3.493229e-01, -9.618167e-02, -1.271761e-01},
  {-5.242205e-01,  5.477250e-01,  6.520661e-01, -3.596548e-01, -1.005883e-01, -1.317517e-01},
  {-9.835043e-01,  1.323589e-01,  1.232901e-01, -5.258511e-01, -2.596456e-01, -2.648825e-01},
  { 5.858436e-01, -7.970151e-01, -1.468133e-01,  3.467655e-01, -1.308914e-01, -2.793474e-01},
  { 5.523798e-01, -7.540953e-01,  3.552702e-01,  4.076241e-01, -1.103056e-01, -3.697952e-01},
  { 6.286920e-01, -6.592045e-01,  4.125480e-01,  4.046353e-01, -1.050362e-01, -3.597103e-01},
  { 5.785999e-01, -7.597579e-01,  2.966311e-01,  3.783280e-01, -1.158534e-01, -3.329792e-01},
  { 3.775910e-01, -9.200060e-01, -1.049476e-01,  3.234810e-01, -1.510183e-01, -3.533924e-01},
  {-9.993277e-01,  3.471014e-02, -1.180489e-02, -5.306490e-01, -2.474944e-01, -4.357689e-01},
  { 8.591855e-01, -4.317695e-01,  2.745457e-01,  4.267980e-01, -9.266818e-02, -3.942816e-01},
  { 1.941256e-01, -9.804388e-01, -3.247939e-02,  3.512155e-01, -1.404023e-01, -3.888378e-01},
  { 4.117551e-01, -5.447487e-01, -7.305523e-01,  1.691293e-01, -1.457729e-01, -4.420107e-01},
  {-9.837375e-01,  1.781213e-01, -2.309285e-02, -5.139798e-01, -1.101269e-01, -4.454201e-01},
  { 9.243658e-01, -3.373625e-01,  1.781415e-01,  4.364086e-01, -8.102375e-02, -4.111308e-01},
  { 5.884869e-03, -9.629506e-01, -2.696135e-01,  3.379700e-01, -1.396387e-01, -4.114131e-01},
  { 2.815257e-02, -7.887517e-01, -6.140670e-01,  2.974592e-01, -1.417193e-01, -4.097889e-01},
  { 3.567077e-01, -5.959827e-01, -7.194194e-01,  2.168622e-01, -1.286128e-01, -4.355516e-01},
  { 9.897835e-01, -1.372794e-01, -3.850814e-02,  4.386267e-01, -7.528365e-02, -4.251800e-01},
  { 5.075096e-02, -5.141095e-01, -8.562218e-01,  2.694167e-01, -1.362410e-01, -4.196492e-01},
  { 5.190521e-01, -4.507798e-01, -7.262111e-01,  1.293437e-01, -1.138855e-01, -4.849537e-01},
  {-1.994223e-01, -8.540883e-01, -4.803790e-01,  3.267682e-01, -1.245039e-01, -4.391202e-01},
  {-3.842262e-01, -6.547003e-01, -6.509514e-01,  3.432482e-01, -1.181885e-01, -4.558787e-01},
  { 9.379702e-01,  6.608337e-02, -3.403597e-01,  4.324435e-01, -8.058032e-02, -4.569607e-01},
  { 8.585950e-01, -1.068643e-01, -5.013927e-01,  9.840620e-02, -1.220863e-01, -5.132794e-01},
  { 6.919630e-01, -2.688399e-01, -6.700091e-01,  1.084641e-01, -1.089480e-01, -5.029989e-01},
  { 9.099140e-01, -3.419461e-02, -4.133852e-01,  9.537274e-02, -1.355380e-01, -5.187630e-01},
  { 7.636123e-01,  1.324927e-01, -6.319350e-01,  4.233381e-01, -8.490571e-02, -4.721161e-01},
  {-2.629660e-01, -3.163951e-01, -9.114510e-01,  3.544392e-01, -9.170761e-02, -4.788407e-01},
  { 8.904324e-01, -9.816529e-02, -4.444028e-01,  5.989920e-02, -2.020785e-01, -6.167188e-01},
  { 8.506853e-01, -1.292063e-01, -5.095491e-01,  4.562081e-02, -2.228225e-01, -6.389063e-01},
  { 6.579008e-01, -1.532289e-01, -7.373517e-01, -3.981625e-03, -2.607355e-01, -6.939191e-01},
  { 5.693840e-01, -1.677439e-01, -8.047757e-01, -2.936228e-02, -2.829859e-01, -7.096775e-01},
  {-9.236640e-02, -2.245662e-01, -9.700714e-01,  3.674218e-01, -8.614772e-02, -4.832448e-01},
  { 5.463459e-01, -1.701354e-01, -8.200976e-01, -4.016303e-02, -2.630900e-01, -7.210078e-01},
  { 1.722978e-01, -6.597795e-02, -9.828328e-01, -1.730486e-01, -2.209898e-01, -7.691699e-01},
  { 9.584056e-02, -1.797653e-01, -9.790297e-01, -1.650806e-01, -2.176346e-01, -7.690493e-01},
  { 6.452640e-01, -1.160506e-01,  7.550939e-01,  2.957859e-01, -1.387769e-01,  8.475082e-01},
  {-1.526139e-01, -1.804925e-02,  9.881210e-01,  1.980472e-01, -9.647793e-02,  8.628344e-01},
  { 7.713865e-01, -1.559397e-01,  6.169648e-01,  3.302020e-01, -1.781175e-01,  8.041108e-01},
  {-2.179617e-01,  3.644544e-02,  9.752766e-01,  1.335700e-01, -6.741519e-02,  8.487168e-01},
  {-3.781118e-01, -6.084479e-03,  9.257399e-01,  1.271331e-01, -6.869610e-02,  8.483707e-01},
  {-5.216968e-01, -1.187683e-01,  8.448234e-01,  1.240651e-01, -6.936524e-02,  8.458049e-01},
  {-3.495501e-01,  3.886537e-03,  9.369096e-01,  1.171643e-01, -6.501351e-02,  8.436742e-01},
  {-3.899927e-01, -2.409211e-02,  9.205027e-01,  9.919903e-02, -6.596848e-02,  8.370615e-01},
  { 9.235263e-01, -1.118801e-01,  3.668542e-01,  3.811719e-01, -1.980677e-01,  7.180597e-01},
  {-5.713369e-01, -8.044548e-02,  8.167636e-01, -1.929816e-01, -8.501838e-02,  6.278702e-01},
  { 9.416589e-01, -1.065310e-01,  3.192645e-01,  3.859923e-01, -1.903776e-01,  7.073171e-01},
  {-9.037895e-01,  1.384745e-01,  4.049561e-01, -4.280164e-01, -2.286270e-01,  3.481058e-01},
  { 9.706057e-01,  2.179888e-01, -1.020070e-01,  4.290201e-01, -2.439929e-01,  2.694508e-01},
  { 9.809259e-01, -1.650023e-01,  1.027556e-01,  4.336756e-01, -2.284905e-01,  2.426086e-01},
  {-9.783472e-01,  1.316268e-01, -1.597216e-01, -4.353104e-01, -1.660010e-01,  1.705510e-01},
  {-9.744280e-01,  1.098656e-01, -1.960093e-01, -4.318571e-01, -1.531780e-01,  1.607927e-01},
  { 9.806597e-01,  7.248684e-02, -1.818027e-01,  4.348840e-01, -2.106820e-01,  1.070510e-01},
  { 9.992777e-01,  2.546946e-03, -3.791465e-02,  4.377619e-01, -2.175432e-01,  1.377442e-01},
  { 8.805906e-01,  7.677238e-02, -4.676175e-01,  3.916235e-01, -1.448835e-01,  1.120742e-02},
  { 9.360973e-01, -3.453243e-01, -6.688074e-02,  3.634717e-01, -8.738013e-02, -1.142399e-01},
  {-8.578323e-01,  3.711976e-01, -3.554379e-01, -2.820426e-01, -2.126446e-02, -6.906596e-02},
  {-8.786150e-01,  4.769162e-01, -2.422068e-02, -2.696756e-01, -9.622511e-03, -9.702789e-02},
  {-8.581113e-01,  5.079426e-01,  7.509547e-02, -2.666974e-01, -4.175718e-03, -1.092454e-01},
  {-6.603854e-01,  5.570043e-01,  5.036241e-01, -3.007326e-01, -4.050877e-02, -1.292358e-01},
  {-7.797732e-01,  5.518446e-01,  2.956710e-01, -2.741555e-01, -1.274528e-02, -1.194265e-01},
  { 6.991805e-01, -7.147326e-01,  1.743063e-02,  3.757232e-01, -1.071250e-01, -2.973097e-01},
  { 5.530863e-01, -7.911990e-01,  2.609590e-01,  3.653606e-01, -1.238592e-01, -3.289560e-01},
  {-9.968185e-01,  7.288406e-02,  3.226503e-02, -5.312209e-01, -2.757522e-01, -3.219311e-01},
  { 3.649196e-01, -9.135836e-01,  1.794395e-01,  3.548579e-01, -1.369054e-01, -3.673174e-01},
  { 1.419099e-01, -9.898602e-01, -6.184503e-03,  3.297375e-01, -1.441119e-01, -3.953713e-01},
  { 7.721802e-02, -9.533602e-01, -2.917905e-01,  3.313488e-01, -1.413166e-01, -4.059198e-01},
  { 1.701230e-01, -9.542609e-01, -2.458541e-01,  3.249499e-01, -1.446664e-01, -3.978258e-01},
  { 9.653748e-01, -7.321929e-02, -2.503809e-01,  4.355739e-01, -7.083036e-02, -4.474077e-01},
  { 8.079787e-01, -2.011013e-01, -5.538309e-01,  1.032692e-01, -1.049001e-01, -5.102528e-01},
  {-8.576601e-01, -2.394015e-02, -5.136595e-01, -4.551081e-01, -1.809722e-01, -6.519921e-01},
  {-8.910856e-01, -1.065272e-02, -4.537102e-01, -4.705269e-01, -1.900847e-01, -6.237089e-01},
  {-4.264912e-01, -4.845659e-01, -7.637415e-01,  3.439147e-01, -1.026384e-01, -4.693463e-01},
  { 9.282876e-01, -7.412438e-02, -3.644005e-01,  9.374844e-02, -1.228338e-01, -5.241765e-01},
  { 9.305444e-01, -2.710611e-02, -3.651745e-01,  6.766073e-02, -1.619584e-01, -6.045045e-01},
  { 6.512975e-01, -1.579949e-01, -7.421921e-01, -2.420373e-03, -2.477092e-01, -6.952249e-01},
  { 6.823779e-01,  1.027586e-01, -7.237410e-01,  4.201006e-01, -7.819701e-02, -4.735185e-01},
  { 9.099826e-01, -5.353408e-02, -4.111762e-01,  6.129767e-02, -1.577549e-01, -6.203664e-01},
  { 8.353917e-01, -1.092887e-01, -5.386806e-01,  3.838062e-02, -1.875537e-01, -6.572399e-01},
  { 7.529973e-01, -1.377043e-01, -6.434535e-01,  1.520841e-02, -2.138103e-01, -6.833194e-01},
  {-8.304083e-01, -1.522817e-02, -5.569472e-01, -4.344692e-01, -1.486962e-01, -6.870189e-01},
  {-3.135286e-01, -1.556244e-01, -9.367394e-01, -3.350788e-01, -1.452344e-01, -7.570122e-01},
  { 4.096090e-01, -6.662899e-02, -9.098247e-01, -1.033689e-01, -2.608218e-01, -7.503577e-01},
  { 6.300717e-02, -1.050326e-01, -9.924708e-01, -1.939869e-01, -2.015600e-01, -7.741767e-01},
  { 2.473764e-01, -1.613984e-01, -9.553824e-01, -1.159864e-01, -2.460074e-01, -7.563893e-01},
  { 8.982424e-02, -1.927198e-01, -9.771339e-01, -1.519233e-01, -2.065645e-01, -7.698769e-01},
  { 4.651978e-01, -1.061310e-01,  8.788216e-01,  2.815855e-01, -1.342286e-01,  8.591284e-01},
  {-2.217447e-02,  1.642062e-02,  9.996192e-01,  2.339197e-01, -9.870766e-02,  8.668321e-01},
  { 7.192804e-01, -1.459321e-01,  6.792198e-01,  3.236621e-01, -1.539757e-01,  8.171733e-01},
  {-1.704895e-01,  1.940360e-02,  9.851684e-01,  1.810379e-01, -7.337865e-02,  8.601774e-01},
  { 7.940999e-01, -1.391366e-01,  5.916471e-01,  3.428092e-01, -1.499791e-01,  7.946860e-01},
  {-2.943689e-01,  2.830772e-02,  9.552726e-01,  1.190340e-01, -5.180779e-02,  8.443666e-01},
  { 8.715308e-01, -1.073431e-01,  4.784468e-01,  3.663759e-01, -1.560172e-01,  7.568284e-01},
  { 9.474859e-01, -9.777883e-02,  3.044827e-01,  3.936102e-01, -1.697870e-01,  6.896080e-01},
  {-4.796145e-01, -1.575112e-02,  8.773379e-01,  7.303197e-02, -5.441480e-02,  8.245094e-01},
  {-8.272840e-01, -1.594767e-02,  5.615575e-01, -3.839315e-01, -2.746339e-01,  4.388492e-01},
  {-8.743514e-01,  9.226584e-02,  4.764417e-01, -3.986562e-01, -2.114280e-01,  4.087335e-01},
  { 9.995270e-01,  2.965932e-02, -8.141339e-03,  4.279631e-01, -2.063555e-01,  3.338576e-01},
  { 9.985089e-01, -5.138686e-02,  1.842339e-02,  4.378913e-01, -2.153081e-01,  1.887899e-01},
  {-9.797779e-01,  5.712175e-02, -1.917609e-01, -4.370975e-01, -1.538996e-01,  1.857495e-01},
  { 9.868709e-01,  6.493043e-02, -1.478847e-01,  4.338773e-01, -1.958549e-01,  1.073952e-01},
  { 9.509580e-01, -3.091579e-01, -1.001396e-02,  3.655461e-01, -8.234907e-02, -8.977689e-02},
  {-8.405394e-01,  2.696372e-01, -4.698821e-01, -2.998071e-01, -1.709978e-02, -3.081972e-02},
  {-8.209915e-01,  3.014144e-01, -4.848942e-01, -3.060566e-01, -2.972506e-02, -2.782807e-02},
  {-8.249059e-01,  2.762133e-01, -4.931900e-01, -3.133735e-01, -3.744121e-02, -1.991864e-02},
  {-8.356137e-01,  2.722881e-01, -4.770839e-01, -3.229175e-01, -4.098488e-02, -6.087304e-03},
  {-9.409311e-01,  1.382513e-01, -3.090878e-01, -4.232154e-01, -1.452042e-01,  1.330897e-01},
  {-8.249040e-01,  2.572561e-01, -5.033416e-01, -3.366463e-01, -5.965248e-02,  6.446525e-03},
  {-8.844799e-01,  1.207607e-01, -4.506797e-01, -4.058506e-01, -1.144614e-01,  1.023959e-01},
  {-8.011063e-01,  3.831289e-01,  4.598270e-01, -4.881724e-01, -1.945891e-01, -1.894610e-01},
  {-7.632568e-01,  5.327289e-01,  3.655667e-01, -2.673858e-01,  3.552990e-03, -1.313585e-01},
  {-9.013079e-01,  3.040946e-01,  3.084973e-01, -5.043700e-01, -2.101708e-01, -2.106234e-01},
  {-8.104683e-01,  5.174779e-01,  2.745139e-01, -2.549016e-01,  2.066839e-02, -1.290579e-01},
  {-5.834123e-01,  5.550245e-01,  5.929402e-01, -3.266724e-01, -6.578661e-02, -1.340247e-01},
  {-7.648780e-01,  5.431685e-01,  3.463086e-01, -2.544826e-01,  2.574582e-02, -1.375652e-01},
  { 8.073874e-01, -5.485016e-01,  2.174204e-01,  3.917789e-01, -8.378603e-02, -2.837824e-01},
  {-4.260921e-01,  5.490883e-01,  7.189907e-01, -3.546526e-01, -8.206078e-02, -1.431229e-01},
  {-9.883023e-01,  1.217318e-01,  9.186856e-02, -5.258349e-01, -2.337282e-01, -2.944665e-01},
  { 7.042078e-01, -6.748909e-01,  2.204851e-01,  4.036164e-01, -8.166783e-02, -3.163261e-01},
  {-9.957104e-01,  8.999269e-02,  2.149499e-02, -5.281533e-01, -2.340378e-01, -3.476382e-01},
  { 8.432904e-01, -4.331149e-01,  3.182336e-01,  4.207766e-01, -8.132326e-02, -3.606369e-01},
  { 9.556678e-01, -2.865912e-01,  6.755999e-02,  4.372676e-01, -7.406604e-02, -4.043086e-01},
  { 3.716585e-01, -4.782948e-01, -7.956784e-01,  1.600284e-01, -1.210132e-01, -4.637826e-01},
  { 9.561588e-01, -2.590581e-01, -1.365623e-01,  4.398766e-01, -6.428431e-02, -4.088838e-01},
  { 4.593426e-01, -4.930475e-01, -7.388563e-01,  1.405454e-01, -1.101497e-01, -4.804609e-01},
  {-1.151996e-01, -6.933993e-01, -7.112851e-01,  2.814175e-01, -1.164858e-01, -4.387107e-01},
  {-5.365914e-02, -6.729105e-01, -7.377751e-01,  2.774456e-01, -1.126591e-01, -4.417076e-01},
  {-2.610300e-02, -7.029825e-01, -7.107279e-01,  3.029339e-01, -1.090537e-01, -4.487171e-01},
  {-1.592057e-01, -7.767158e-01, -6.093981e-01,  3.049746e-01, -1.061779e-01, -4.515064e-01},
  { 5.705085e-01, -3.507822e-01, -7.426115e-01,  1.156885e-01, -9.333708e-02, -5.041838e-01},
  { 7.795404e-01, -2.152896e-01, -5.881898e-01,  1.007673e-01, -9.644050e-02, -5.167528e-01},
  { 8.842095e-01,  4.288782e-02, -4.651174e-01,  4.313694e-01, -6.709941e-02, -4.569721e-01},
  { 7.130058e-01,  8.962099e-02, -6.954069e-01,  4.249341e-01, -6.974351e-02, -4.678365e-01},
  { 8.522087e-01, -1.158351e-01, -5.102182e-01,  4.301812e-02, -1.567657e-01, -6.564574e-01},
  { 7.469110e-01, -1.566835e-01, -6.461998e-01,  1.000036e-02, -1.999407e-01, -6.926242e-01},
  {-1.377482e-01, -1.633656e-01, -9.769018e-01, -2.592800e-01, -1.689643e-01, -7.747722e-01},
  { 1.780254e-01, -3.688140e-03, -9.840189e-01,  3.956458e-01, -7.136885e-02, -4.839997e-01},
  { 1.987649e-02, -1.345096e-01, -9.907129e-01,  3.772068e-01, -7.247175e-02, -4.859124e-01},
  {-1.394897e-01, -1.488251e-01, -9.789758e-01,  3.589164e-01, -7.462101e-02, -4.843625e-01},
  { 9.163007e-01, -6.705308e-02, -3.948377e-01,  5.888264e-02, -1.421656e-01, -6.282925e-01},
  { 9.279302e-01, -8.042585e-02, -3.639741e-01,  5.657216e-02, -1.268760e-01, -6.363427e-01},
  { 5.253961e-01, -1.825342e-01, -8.310477e-01, -4.258798e-02, -2.287678e-01, -7.296634e-01},
  { 3.704606e-02, -1.336217e-01, -9.903397e-01, -2.203766e-01, -1.725090e-01, -7.792217e-01},
  { 4.023129e-01, -1.967172e-01, -8.941178e-01, -7.291242e-02, -2.219200e-01, -7.469487e-01},
  {-7.465106e-01,  8.911131e-02, -6.593794e-01, -4.096276e-01, -1.187742e-01, -7.208272e-01},
  { 1.142401e-01, -2.077820e-01, -9.714813e-01, -1.508659e-01, -1.867746e-01, -7.738869e-01},
  { 5.076650e-01, -3.996200e-02,  8.606272e-01,  2.879276e-01, -1.148703e-01,  8.561053e-01},
  { 2.064123e-01, -2.397378e-03,  9.784622e-01,  2.674708e-01, -1.046139e-01,  8.647607e-01},
  { 7.030886e-01, -1.011045e-01,  7.038780e-01,  3.177282e-01, -1.094516e-01,  8.316580e-01},
  {-1.978636e-01,  1.994895e-02,  9.800265e-01,  1.662901e-01, -5.661381e-02,  8.571936e-01},
  {-6.194320e-01, -7.045486e-02,  7.818824e-01, -2.489304e-01, -1.520038e-01,  5.817396e-01},
  {-8.841755e-01,  9.331346e-04,  4.671539e-01, -4.122921e-01, -1.870974e-01,  3.809607e-01},
  {-9.730156e-01,  8.285823e-03,  2.305903e-01, -4.354998e-01, -2.066049e-01,  3.239216e-01},
  {-8.655162e-01,  7.699332e-02,  4.949279e-01, -3.949887e-01, -1.519493e-01,  4.109496e-01},
  {-9.953253e-01, -6.675798e-02, -6.979135e-02, -4.461679e-01, -2.214972e-01,  2.582758e-01},
  { 9.665110e-01, -1.735975e-01, -1.889988e-01,  3.762676e-01, -6.073848e-02, -3.571357e-02},
  { 9.566768e-01, -1.075518e-01, -2.705589e-01,  3.824981e-01, -6.408430e-02, -8.211560e-03},
  {-8.076258e-01,  2.094231e-01, -5.512553e-01, -3.633784e-01, -5.863308e-02,  5.017710e-02},
  { 9.592903e-01,  7.774910e-02, -2.715089e-01,  4.251781e-01, -1.653047e-01,  7.935844e-02},
  {-8.361867e-01,  2.700540e-01, -4.773495e-01, -2.971332e-01,  2.878832e-03, -2.461743e-02},
  { 9.617624e-01, -2.735586e-01, -1.337535e-02,  3.687890e-01, -7.240830e-02, -8.749243e-02},
  {-8.342240e-01,  2.369957e-01, -4.978986e-01, -3.556630e-01, -6.673278e-02,  3.452292e-02},
  { 9.443098e-01,  9.328849e-02, -3.155570e-01,  4.179477e-01, -1.644811e-01,  5.743921e-02},
  {-8.387422e-01,  3.076715e-01, -4.492770e-01, -2.736515e-01,  8.153506e-03, -6.119279e-02},
  {-8.730080e-01,  3.901466e-01, -2.926478e-01, -2.690884e-01, -5.825824e-04, -7.906196e-02},
  { 8.138894e-01, -5.177279e-01,  2.637078e-01,  3.900035e-01, -7.578200e-02, -2.557125e-01},
  {-8.174000e-01,  5.084561e-01,  2.707946e-01, -2.474644e-01,  3.877825e-02, -1.420173e-01},
  {-9.405850e-01,  2.373360e-01,  2.428407e-01, -5.126973e-01, -2.009731e-01, -2.488070e-01},
  {-9.865398e-01,  1.410246e-01,  8.277217e-02, -5.239877e-01, -2.091913e-01, -3.084110e-01},
  { 8.296596e-01, -4.949887e-01,  2.581686e-01,  4.049509e-01, -7.168095e-02, -3.011891e-01},
  { 8.692696e-01, -4.063018e-01,  2.815832e-01,  4.227426e-01, -6.572174e-02, -3.440024e-01},
  { 9.338681e-01, -2.636379e-01,  2.416309e-01,  4.350344e-01, -6.627838e-02, -3.845387e-01},
  { 9.833058e-01, -1.405982e-01,  1.155081e-01,  4.402153e-01, -6.002124e-02, -4.016784e-01},
  { 4.159260e-01, -5.408496e-01, -7.310864e-01,  1.608971e-01, -1.022425e-01, -4.743946e-01},
  { 1.768712e-01, -5.945530e-01, -7.843617e-01,  2.232909e-01, -9.795590e-02, -4.559855e-01},
  {-3.285431e-02, -5.744776e-01, -8.178607e-01,  2.686471e-01, -9.158992e-02, -4.557766e-01},
  {-9.158753e-01,  9.460730e-03, -4.013515e-01, -4.988199e-01, -1.838320e-01, -5.644361e-01},
  { 7.633369e-01, -2.169289e-01, -6.084888e-01,  9.955205e-02, -8.497444e-02, -5.224974e-01},
  {-4.211739e-01, -3.245761e-01, -8.469138e-01,  3.308182e-01, -8.090137e-02, -4.749135e-01},
  {-2.414477e-01, -1.304747e-01, -9.616025e-01,  3.471014e-01, -7.035150e-02, -4.829039e-01},
  { 6.651592e-01, -1.770718e-01, -7.254025e-01, -9.246561e-03, -1.985530e-01, -7.122098e-01},
  { 4.683991e-01,  1.571347e-01, -8.694314e-01,  4.090003e-01, -6.490085e-02, -4.785009e-01},
  { 9.294359e-01, -9.068284e-02, -3.576666e-01,  5.857636e-02, -1.180961e-01, -6.335799e-01},
  {-6.843644e-01, -1.405817e-02, -7.290046e-01, -3.929527e-01, -7.229141e-02, -7.333292e-01},
  {-6.600989e-01,  2.829421e-02, -7.506457e-01, -3.738340e-01, -4.486009e-02, -7.503400e-01},
  {-4.757513e-01, -3.941220e-02, -8.786964e-01, -3.636093e-01, -4.118299e-02, -7.579137e-01},
  { 6.861665e-02,  5.078758e-02,  9.963495e-01,  2.486230e-01, -7.196723e-02,  8.655196e-01},
  {-8.737083e-02,  4.054352e-02,  9.953504e-01,  2.137197e-01, -6.514991e-02,  8.645182e-01},
  {-4.982207e-01, -8.555418e-02,  8.628190e-01,  1.437042e-03, -1.336484e-01,  7.802554e-01},
  { 7.955943e-01, -1.469224e-01,  5.877443e-01,  3.432374e-01, -1.170039e-01,  8.021201e-01},
  { 8.699712e-01, -1.288163e-01,  4.759796e-01,  3.727889e-01, -1.146624e-01,  7.560048e-01},
  {-4.080406e-01,  1.943884e-02,  9.127568e-01,  8.767748e-02, -3.142685e-02,  8.316275e-01},
  { 9.665271e-01, -1.151951e-01,  2.292496e-01,  4.033959e-01, -1.364706e-01,  6.655064e-01},
  {-7.311398e-01, -1.737140e-01,  6.597409e-01, -2.616084e-01, -3.487671e-02,  5.610470e-01},
  {-7.611921e-01, -1.547824e-01,  6.297849e-01, -2.664478e-01, -3.284949e-02,  5.566841e-01},
  {-7.553552e-01,  1.423670e-03,  6.553140e-01, -2.692962e-01, -3.244473e-02,  5.528545e-01},
  {-7.193981e-01,  7.219592e-02,  6.908357e-01, -2.828170e-01, -4.063256e-02,  5.390872e-01},
  { 9.878117e-01, -1.483730e-01,  4.704814e-02,  4.130737e-01, -1.972731e-01,  5.216596e-01},
  { 9.172078e-01, -3.457474e-01,  1.979607e-01,  4.329480e-01, -1.356950e-01,  4.019948e-01},
  {-7.920651e-01,  1.581274e-01,  5.896003e-01, -3.828950e-01, -1.061068e-01,  4.218203e-01},
  {-9.993244e-01,  9.166024e-03, -3.559144e-02, -4.458592e-01, -2.059397e-01,  2.453955e-01},
  { 9.897088e-01,  2.968045e-02, -1.399837e-01,  4.359491e-01, -1.233726e-01,  1.453604e-01},
  { 9.993349e-01, -2.278773e-02, -2.846971e-02,  4.400770e-01, -1.607317e-01,  2.000799e-01},
  { 9.705198e-01, -2.100504e-01, -1.181953e-01,  3.784510e-01, -4.570023e-02, -3.993357e-02},
  { 9.971300e-01,  1.467007e-02, -7.427295e-02,  4.385881e-01, -1.728758e-01,  1.658443e-01},
  { 9.724824e-01,  6.127121e-02, -2.247751e-01,  4.294457e-01, -1.423918e-01,  1.039572e-01},
  {-8.455251e-01,  3.062174e-01, -4.373991e-01, -2.649758e-01,  1.725876e-02, -7.168439e-02},
  {-8.888547e-01,  3.966005e-01, -2.294459e-01, -2.513112e-01,  3.108445e-02, -9.135839e-02},
  {-6.670328e-01,  5.614969e-01,  4.896819e-01, -2.910320e-01, -1.512742e-02, -1.451159e-01},
  {-6.598344e-01,  5.494683e-01,  5.125458e-01, -2.840773e-01,  4.016401e-03, -1.560709e-01},
  {-7.806058e-01,  3.961747e-01,  4.834254e-01, -4.832188e-01, -1.692048e-01, -2.017744e-01},
  {-9.009374e-01,  2.965937e-01,  3.167710e-01, -5.000386e-01, -1.846805e-01, -2.229163e-01},
  {-7.740504e-01,  5.441685e-01,  3.236150e-01, -2.353096e-01,  6.479936e-02, -1.550201e-01},
  {-6.985840e-01,  5.433632e-01,  4.655499e-01, -2.529750e-01,  5.173116e-02, -1.674258e-01},
  { 9.870064e-01, -1.122198e-01, -1.150002e-01,  4.413213e-01, -4.938583e-02, -4.198638e-01},
  { 2.757855e-01, -5.258207e-01, -8.046459e-01,  1.939569e-01, -8.299742e-02, -4.712249e-01},
  { 9.721319e-01,  3.387109e-02, -2.319749e-01,  4.393617e-01, -5.004937e-02, -4.337793e-01},
  { 5.365260e-03, -2.771913e-01, -9.607998e-01,  2.508455e-01, -7.670017e-02, -4.640046e-01},
  { 2.301422e-01, -5.078228e-01, -8.301510e-01,  2.119099e-01, -7.079232e-02, -4.722182e-01},
  {-9.750047e-01,  1.993120e-01, -9.818690e-02, -5.064629e-01, -8.739235e-02, -4.917220e-01},
  {-9.691234e-01,  1.441158e-01, -2.000759e-01, -5.102844e-01, -1.327238e-01, -5.172932e-01},
  { 9.292524e-01, -6.203603e-02, -3.641998e-01,  8.918705e-02, -8.640161e-02, -5.413978e-01},
  { 7.986267e-01, -1.954093e-01, -5.692194e-01,  9.776320e-02, -7.802007e-02, -5.273621e-01},
  {-8.919970e-01,  4.030144e-03, -4.520233e-01, -4.743975e-01, -1.445384e-01, -6.166527e-01},
  { 7.164489e-01,  1.683092e-01, -6.770325e-01,  4.233771e-01, -5.753975e-02, -4.664999e-01},
  { 7.513279e-01, -1.542744e-01, -6.416432e-01,  1.225358e-02, -1.602955e-01, -6.997160e-01},
  { 4.969886e-01,  1.410707e-01, -8.562134e-01,  4.111890e-01, -5.810178e-02, -4.761753e-01},
  { 3.981244e-02, -5.453666e-02, -9.977177e-01,  3.750181e-01, -5.847770e-02, -4.867895e-01},
  {-1.750412e-01, -1.156936e-01, -9.777401e-01,  3.554924e-01, -6.127986e-02, -4.859418e-01},
  { 9.106761e-01, -1.036476e-01, -3.999077e-01,  5.736878e-02, -8.485186e-02, -6.438859e-01},
  { 8.689684e-01, -1.333832e-01, -4.765533e-01,  4.393292e-02, -1.139141e-01, -6.651146e-01},
  {-1.192842e-01, -1.504845e-01, -9.813897e-01, -2.387161e-01, -1.421559e-01, -7.819224e-01},
  {-7.882372e-01,  3.789388e-02, -6.142037e-01, -4.157168e-01, -9.167314e-02, -7.101942e-01},
  {-7.719893e-01,  6.827158e-02, -6.319584e-01, -4.044327e-01, -5.769486e-02, -7.207265e-01},
  {-3.536704e-01, -1.518598e-01, -9.229603e-01, -3.185154e-01, -7.091451e-02, -7.726508e-01},
  { 4.014061e-01,  3.424304e-02,  9.152598e-01,  2.817911e-01, -9.419296e-02,  8.598424e-01},
  { 2.945525e-01,  7.251027e-02,  9.528804e-01,  2.694533e-01, -8.372375e-02,  8.636118e-01},
  { 5.511708e-01,  1.046450e-02,  8.343269e-01,  2.943851e-01, -8.912888e-02,  8.527302e-01},
  {-5.269573e-01,  1.365329e-03,  8.498906e-01,  1.195382e-03, -5.533804e-02,  7.814910e-01},
  {-5.191320e-01,  1.571263e-02,  8.545497e-01,  4.835483e-02, -2.742959e-02,  8.105391e-01},
  {-5.234923e-01, -1.943928e-01,  8.295585e-01, -1.506474e-01, -2.818202e-02,  6.699391e-01},
  {-9.126847e-01,  2.154999e-02,  4.080959e-01, -4.235563e-01, -1.604641e-01,  3.567216e-01},
  {-9.989435e-01,  8.720755e-03, -4.512115e-02, -4.451165e-01, -1.851953e-01,  2.583158e-01},
  { 8.975735e-01, -4.304141e-01, -9.542334e-02,  3.842458e-01, -2.700955e-02, -2.038642e-02},
  {-9.862617e-01,  2.167567e-02, -1.637628e-01, -4.414846e-01, -1.381536e-01,  2.138538e-01},
  {-8.385412e-01,  5.336494e-02, -5.422185e-01, -3.771100e-01, -3.384304e-02,  7.746285e-02},
  { 9.113604e-01,  6.137401e-02, -4.070081e-01,  4.013944e-01, -7.622498e-02,  4.109347e-02},
  {-7.955463e-01,  2.164734e-01, -5.659022e-01, -2.882168e-01,  3.085488e-02, -2.585980e-02},
  { 9.153675e-01, -3.970889e-01,  6.650396e-02,  3.807639e-01, -3.392656e-02, -7.729301e-02},
  {-8.351864e-01,  1.382773e-01, -5.322999e-01, -2.542827e-01,  4.044399e-02, -7.584410e-02},
  {-8.885714e-01,  3.977658e-01, -2.285240e-01, -2.412413e-01,  4.654299e-02, -1.029519e-01},
  {-8.797449e-01,  4.749774e-01,  2.110043e-02, -2.437155e-01,  3.832955e-02, -1.143677e-01},
  {-5.409124e-01,  5.370697e-01,  6.472788e-01, -3.183230e-01, -2.854437e-02, -1.582110e-01},
  {-8.319640e-01,  5.189363e-01,  1.963189e-01, -2.358745e-01,  5.492336e-02, -1.352426e-01},
  {-5.817714e-01,  5.455152e-01,  6.032869e-01, -2.675352e-01,  3.694233e-02, -1.696022e-01},
  {-5.274345e-01,  4.958716e-01,  6.898726e-01, -3.975164e-01, -5.185678e-02, -1.957231e-01},
  {-3.729684e-01,  5.209849e-01,  7.677690e-01, -3.427555e-01, -5.101012e-02, -1.586029e-01},
  {-7.341698e-01,  5.448721e-01,  4.051037e-01, -2.328174e-01,  8.094749e-02, -1.714179e-01},
  { 9.372368e-01, -2.984740e-01,  1.802787e-01,  4.345695e-01, -4.747305e-02, -3.609946e-01},
  {-9.892630e-01,  1.402648e-01,  4.104328e-02, -5.161851e-01, -1.315289e-01, -3.701371e-01},
  {-9.592375e-01,  4.436850e-02, -2.790965e-01, -5.111079e-01, -1.808151e-01, -5.345198e-01},
  {-8.935423e-01,  8.002234e-02, -4.417901e-01, -4.956183e-01, -1.507889e-01, -5.693300e-01},
  { 8.546349e-01,  1.222239e-01, -5.046389e-01,  4.328107e-01, -4.290047e-02, -4.505622e-01},
  { 6.228160e-01, -2.963535e-01, -7.240683e-01,  1.067121e-01, -6.578726e-02, -5.229216e-01},
  {-8.559797e-01,  1.800750e-02, -5.166958e-01, -4.492931e-01, -1.325761e-01, -6.622243e-01},
  {-5.515507e-01, -1.955589e-01, -8.108937e-01,  3.315283e-01, -5.696771e-02, -4.825029e-01},
  { 6.119500e-01,  1.701303e-01, -7.723813e-01,  4.137593e-01, -5.160411e-02, -4.733580e-01},
  {-1.090846e-01, -1.626251e-01, -9.806394e-01, -2.283107e-01, -1.289926e-01, -7.852425e-01},
  {-2.452428e-01, -1.381823e-01, -9.595632e-01, -2.882920e-01, -9.586727e-02, -7.784334e-01},
  { 2.696213e-01, -2.045641e-01, -9.409878e-01, -1.010730e-01, -1.739457e-01, -7.677577e-01},
  {-7.586630e-01,  9.319372e-02, -6.447833e-01, -3.987586e-01, -3.977536e-02, -7.256642e-01},
  { 6.283426e-01, -4.175148e-02,  7.768155e-01,  3.211622e-01, -5.889393e-02,  8.324180e-01},
  {-1.880277e-01,  2.193765e-02,  9.819187e-01,  1.758565e-01,  5.200350e-02,  8.547350e-01},
  {-1.622799e-01,  3.685168e-02,  9.860564e-01,  1.821147e-01, -1.802239e-02,  8.584164e-01},
  { 7.872271e-01, -1.324586e-01,  6.022692e-01,  3.497426e-01, -8.075532e-02,  8.020207e-01},
  {-3.120005e-01,  3.929220e-02,  9.492691e-01,  1.192064e-01,  1.262385e-02,  8.418086e-01},
  { 8.697832e-01, -1.380095e-01,  4.737411e-01,  3.701171e-01, -9.066413e-02,  7.677118e-01},
  { 9.302052e-01, -1.124716e-01,  3.493830e-01,  3.924614e-01, -8.791903e-02,  7.175794e-01},
  {-5.549955e-01, -1.191017e-02,  8.317680e-01, -2.874082e-02, -1.618397e-02,  7.624172e-01},
  { 9.771631e-01, -1.163107e-01,  1.778318e-01,  4.136435e-01, -1.170226e-01,  6.276035e-01},
  { 9.802532e-01, -1.374568e-01,  1.421597e-01,  4.173895e-01, -1.249505e-01,  5.994043e-01},
  {-7.195026e-01,  3.286219e-02,  6.937119e-01, -1.889137e-01,  2.068533e-03,  6.354450e-01},
  {-9.081479e-01,  4.949742e-02,  4.157130e-01, -4.273617e-01, -1.517067e-01,  3.480868e-01},
  {-8.658047e-01,  1.497624e-01,  4.774448e-01, -4.023735e-01, -9.193128e-02,  3.849429e-01},
  {-9.968920e-01, -5.380454e-02,  5.754441e-02, -4.451168e-01, -1.242069e-01,  2.717488e-01},
  { 9.629248e-01, -2.008009e-01, -1.801522e-01,  3.934704e-01, -2.128791e-02,  1.658064e-02},
  {-8.045063e-01,  1.805052e-01, -5.658510e-01, -3.492949e-01,  3.281442e-04,  4.738168e-02},
  {-8.679263e-01, -8.246613e-02, -4.897993e-01, -4.108867e-01, -3.733162e-02,  1.320109e-01},
  {-9.090444e-01,  3.986053e-02, -4.147885e-01, -4.199635e-01, -4.602051e-02,  1.494400e-01},
  {-9.025271e-01, -4.404573e-02, -4.283746e-01, -4.182778e-01, -4.033992e-02,  1.462556e-01},
  {-9.336077e-01,  3.102447e-02, -3.569513e-01, -4.271409e-01, -4.691951e-02,  1.667036e-01},
  { 9.200085e-01,  8.251470e-02, -3.831132e-01,  4.066235e-01, -8.812983e-02,  5.093533e-02},
  {-8.788830e-01,  3.348509e-02, -4.758607e-01, -2.701104e-01,  5.290532e-02, -4.341331e-02},
  {-8.772268e-01,  3.695649e-01, -3.064228e-01, -2.306515e-01,  7.324764e-02, -9.937029e-02},
  {-6.447585e-01,  4.186322e-01,  6.395574e-01, -4.360531e-01, -7.277580e-02, -2.165911e-01},
  {-7.012180e-01,  4.193031e-01,  5.766093e-01, -4.512419e-01, -8.984678e-02, -2.212046e-01},
  {-7.995723e-01,  3.873616e-01,  4.589500e-01, -4.834684e-01, -1.467182e-01, -2.214962e-01},
  {-8.593372e-01,  4.813499e-01,  1.727476e-01, -2.245611e-01,  7.739051e-02, -1.443441e-01},
  {-8.683164e-01,  3.314629e-01,  3.689972e-01, -4.961731e-01, -1.564398e-01, -2.390180e-01},
  {-5.331130e-01,  5.276092e-01,  6.613767e-01, -2.639435e-01,  6.072952e-02, -1.865035e-01},
  {-9.688262e-01,  1.891234e-01,  1.600257e-01, -5.131870e-01, -1.564015e-01, -2.967034e-01},
  { 9.478859e-01, -3.052064e-01,  9.144033e-02,  4.398711e-01, -4.052998e-02, -3.792173e-01},
  { 9.949362e-01, -9.979942e-02, -1.191078e-02,  4.420592e-01, -3.511187e-02, -4.013034e-01},
  { 3.930644e-01, -3.450489e-01, -8.523155e-01,  1.721068e-01, -5.192403e-02, -4.921755e-01},
  { 9.666383e-01,  7.618685e-02, -2.445524e-01,  4.383275e-01, -3.531610e-02, -4.336949e-01},
  {-9.682062e-01,  2.120164e-01, -1.327623e-01, -5.011210e-01, -6.694561e-02, -4.973146e-01},
  {-9.111093e-01,  2.571558e-02, -4.113617e-01, -4.725507e-01, -1.055847e-01, -6.190187e-01},
  { 7.844541e-01, -1.760411e-01, -5.946774e-01,  2.247960e-02, -1.128672e-01, -6.995168e-01},
  { 7.566901e-01, -1.887664e-01, -6.259291e-01,  8.287393e-03, -1.287092e-01, -7.126406e-01},
  { 2.562335e-02,  1.557861e-02, -9.995503e-01,  3.654828e-01, -4.447553e-02, -4.873484e-01},
  { 8.404984e-01, -1.315157e-01, -5.256101e-01,  3.472782e-02, -9.320965e-02, -6.867583e-01},
  { 8.410008e-01, -1.497466e-01, -5.198977e-01,  3.677683e-02, -7.654989e-02, -6.881993e-01},
  { 8.415751e-01, -1.630318e-01, -5.149487e-01,  3.817476e-02, -6.232713e-02, -6.900725e-01},
  { 9.352996e-01, -8.328609e-02, -3.439158e-01,  5.412814e-02, -4.766374e-02, -6.619034e-01},
  { 3.948247e-01, -2.282431e-01, -8.899542e-01, -6.300388e-02, -1.570692e-01, -7.573354e-01},
  { 2.414496e-01, -2.152213e-01, -9.462462e-01, -1.026336e-01, -1.506497e-01, -7.734036e-01},
  {-7.262062e-01,  8.856308e-02, -6.817485e-01, -3.940797e-01, -2.583561e-02, -7.288167e-01},
  { 1.619663e-01, -1.460714e-01, -9.759252e-01, -1.338441e-01, -1.234450e-01, -7.856451e-01},
  {-3.722325e-01, -7.927407e-02, -9.247478e-01, -3.140476e-01, -3.196570e-02, -7.792283e-01},
  {-6.874676e-01,  5.939428e-02, -7.237821e-01, -3.793767e-01, -1.562854e-02, -7.432352e-01},
  {-5.797227e-01,  4.307733e-02, -8.136743e-01, -3.645363e-01, -2.103746e-02, -7.561460e-01},
  { 3.277019e-01,  3.038112e-02,  9.442925e-01,  2.912095e-01, -5.758673e-02,  8.530785e-01},
  { 2.261100e-01,  6.298831e-02,  9.720631e-01,  2.687586e-01, -4.978023e-02,  8.611369e-01},
  {-2.380883e-01,  3.523567e-02,  9.706041e-01,  1.579876e-01,  8.982892e-02,  8.488842e-01},
  { 1.690291e-02,  1.635773e-02,  9.997233e-01,  2.350562e-01, -1.873453e-03,  8.623101e-01},
  { 8.527295e-01, -1.293959e-01,  5.060722e-01,  3.663917e-01, -7.319622e-02,  7.794999e-01},
  { 9.604724e-01, -1.144140e-01,  2.537758e-01,  4.068199e-01, -9.219629e-02,  6.703413e-01},
  {-6.207224e-01, -7.019337e-02,  7.808819e-01, -1.126085e-01, -4.538174e-02,  7.005768e-01},
  {-6.285288e-01, -2.584590e-02,  7.773567e-01, -1.277100e-01,  4.426908e-02,  6.927882e-01},
  {-9.636365e-01, -2.389403e-02,  2.661461e-01, -4.369673e-01, -1.459690e-01,  3.239518e-01},
  {-9.919656e-01, -1.148462e-02,  1.259854e-01, -4.451461e-01, -1.060343e-01,  2.668477e-01},
  { 9.949951e-01, -9.817686e-02,  1.860031e-02,  4.443243e-01, -8.484172e-02,  3.387114e-01},
  {-9.098560e-01,  1.247457e-01,  3.957281e-01, -4.228138e-01, -8.768413e-02,  3.430168e-01},
  { 9.876162e-01, -9.941186e-03, -1.565737e-01,  4.366368e-01, -6.454320e-02,  1.575704e-01},
  { 9.324248e-01, -6.060324e-02, -3.562459e-01,  3.996139e-01, -2.720311e-02,  3.660431e-02},
  { 9.026887e-01,  1.232617e-01, -4.122616e-01,  4.107265e-01, -5.755105e-02,  6.399472e-02},
  { 9.596646e-01,  3.242235e-02, -2.792713e-01,  4.207486e-01, -8.575242e-02,  8.581828e-02},
  {-8.754541e-01,  3.737788e-01, -3.063816e-01, -2.254772e-01,  8.033765e-02, -1.056362e-01},
  {-6.157740e-01,  4.150856e-01,  6.697211e-01, -4.082561e-01, -6.875946e-03, -2.356273e-01},
  {-8.911145e-01,  4.465861e-01, -8.047137e-02, -2.266795e-01,  7.062799e-02, -1.236801e-01},
  {-5.398068e-01,  4.503027e-01,  7.112215e-01, -3.859622e-01, -1.654489e-02, -2.110343e-01},
  {-7.846450e-01,  3.845871e-01,  4.862356e-01, -4.741927e-01, -1.136532e-01, -2.334424e-01},
  { 9.076668e-01, -3.614097e-01,  2.133637e-01,  4.175182e-01, -2.531869e-02, -2.628000e-01},
  {-7.937476e-01,  5.536921e-01,  2.517732e-01, -2.142567e-01,  1.028287e-01, -1.641837e-01},
  {-5.433348e-01,  5.362169e-01,  6.459557e-01, -2.561227e-01,  8.011538e-02, -1.958324e-01},
  {-9.412984e-01,  2.211614e-01,  2.550391e-01, -5.036479e-01, -1.145091e-01, -3.009032e-01},
  {-5.344992e-01,  5.316814e-01,  6.569821e-01, -2.403491e-01,  1.095606e-01, -2.069717e-01},
  {-9.724117e-01,  1.694201e-01,  1.603510e-01, -5.139607e-01, -1.314653e-01, -3.346633e-01},
  {-6.694821e-01,  5.385647e-01,  5.116071e-01, -2.175046e-01,  1.191868e-01, -1.918267e-01},
  {-5.384247e-01,  5.332739e-01,  6.524705e-01, -2.323778e-01,  1.184309e-01, -2.075549e-01},
  {-9.055239e-01,  1.355123e-01, -4.020731e-01, -4.999361e-01, -1.301831e-01, -5.560815e-01},
  { 8.167268e-01, -1.834771e-01, -5.470772e-01,  9.206971e-02, -5.106210e-02, -5.447285e-01},
  {-2.631955e-01, -1.049403e-01, -9.590181e-01,  3.317491e-01, -4.545955e-02, -4.848069e-01},
  {-8.666913e-01,  4.700506e-02, -4.966253e-01, -4.601770e-01, -9.304097e-02, -6.413797e-01},
  { 2.034801e-01,  1.087100e-01, -9.730251e-01,  3.843218e-01, -3.490068e-02, -4.847287e-01},
  { 3.643025e-01,  1.216822e-01, -9.232969e-01,  3.913101e-01, -4.149788e-02, -4.836420e-01},
  { 6.821618e-01, -1.830472e-01, -7.079188e-01, -2.882074e-03, -1.243168e-01, -7.252368e-01},
  { 5.984212e-01, -2.056088e-01, -7.743495e-01, -1.607932e-02, -1.370318e-01, -7.332270e-01},
  { 7.357548e-01, -1.795464e-01, -6.530146e-01,  5.026416e-03, -9.534048e-02, -7.253938e-01},
  {-1.150997e-01, -1.668800e-01, -9.792359e-01, -2.189027e-01, -1.072762e-01, -7.898803e-01},
  { 8.540931e-01, -1.497260e-01, -4.981036e-01,  3.926548e-02, -2.194402e-02, -7.007001e-01},
  { 2.840948e-01, -1.058303e-01, -9.529377e-01, -8.309351e-02, -1.287663e-01, -7.728015e-01},
  {-8.342323e-03, -1.918440e-01, -9.813899e-01, -1.748803e-01, -1.079903e-01, -7.918279e-01},
  { 2.669930e-01, -1.019307e-01, -9.582927e-01, -1.083532e-01, -1.282539e-01, -7.800292e-01},
  {-5.223382e-01,  3.094699e-02, -8.521767e-01, -3.537179e-01,  4.618411e-04, -7.615979e-01},
  { 6.960608e-01, -1.464701e-01,  7.028840e-01,  3.504703e-01,  6.557117e-02,  8.282747e-01},
  { 6.066822e-01, -1.727920e-01,  7.759379e-01,  3.493950e-01,  6.414377e-02,  8.288853e-01},
  { 5.487248e-01, -1.777081e-01,  8.168972e-01,  3.451494e-01,  5.936287e-02,  8.308284e-01},
  { 5.298811e-01, -1.693507e-01,  8.309912e-01,  3.451336e-01,  5.355195e-02,  8.297657e-01},
  { 5.456077e-01, -1.724041e-01,  8.201153e-01,  3.433484e-01,  4.574483e-02,  8.292204e-01},
  { 5.987244e-01, -1.584340e-01,  7.851291e-01,  3.448076e-01,  3.531067e-02,  8.257194e-01},
  { 6.953397e-01, -1.150147e-01,  7.094183e-01,  3.450491e-01, -2.315670e-02,  8.154023e-01},
  {-1.151841e-01, -1.018286e-02,  9.932920e-01,  2.066793e-01,  5.888235e-02,  8.591720e-01},
  { 7.550297e-01, -8.965174e-02,  6.495327e-01,  3.507223e-01, -5.532363e-02,  8.047016e-01},
  {-3.036185e-01,  5.272197e-02,  9.513339e-01,  1.152243e-01,  4.355905e-02,  8.391638e-01},
  { 9.857599e-01, -1.438903e-01,  8.702251e-02,  4.276612e-01, -8.773670e-02,  5.518650e-01},
  {-6.924983e-01,  8.308261e-03,  7.213717e-01, -1.469814e-01,  5.688630e-02,  6.760440e-01},
  {-7.708184e-01,  7.791913e-02,  6.322718e-01, -3.111590e-01, -8.483474e-03,  5.031887e-01},
  {-9.914678e-01, -5.281663e-02,  1.191719e-01, -4.425219e-01, -1.295847e-01,  3.012969e-01},
  {-9.700518e-01,  5.318775e-02,  2.370032e-01, -4.410848e-01, -1.134798e-01,  3.072619e-01},
  {-9.700581e-01,  8.491589e-02,  2.275445e-01, -4.425886e-01, -1.034028e-01,  2.974908e-01},
  {-9.731403e-01,  2.136996e-02,  2.292189e-01, -4.459150e-01, -9.910722e-02,  2.655939e-01},
  {-8.960479e-01,  1.769988e-01,  4.071481e-01, -4.205538e-01, -5.465525e-02,  3.368016e-01},
  { 9.421803e-01, -1.037178e-01, -3.186517e-01,  3.978656e-01,  1.548223e-02,  2.202659e-02},
  { 9.828488e-01,  4.361205e-04, -1.844129e-01,  4.377667e-01, -4.013932e-02,  1.652879e-01},
  {-9.715579e-01,  5.017770e-03, -2.367491e-01, -4.392020e-01, -7.719501e-02,  2.047383e-01},
  {-9.857284e-01, -7.144278e-02, -1.524322e-01, -4.354416e-01, -5.087109e-02,  1.910338e-01},
  { 9.699073e-01,  1.723503e-02, -2.428636e-01,  4.290698e-01, -6.499989e-02,  1.187931e-01},
  {-8.510006e-01, -6.080473e-02, -5.216328e-01, -2.866992e-01,  6.756299e-02, -1.659913e-02},
  {-7.899638e-01,  3.226479e-01, -5.213978e-01, -2.260265e-01,  9.894010e-02, -9.013432e-02},
  { 9.609889e-01, -2.192260e-01,  1.686424e-01,  4.127641e-01,  2.880352e-02, -1.523892e-01},
  {-6.789623e-01,  4.228583e-01,  6.001676e-01, -4.315284e-01, -1.838922e-02, -2.515646e-01},
  { 9.338125e-01, -3.291480e-01,  1.401984e-01,  4.204117e-01,  1.842634e-02, -2.078594e-01},
  {-8.743624e-01,  3.404728e-01,  3.457869e-01, -4.929425e-01, -9.924686e-02, -2.827834e-01},
  {-8.957750e-01,  2.934373e-01,  3.338888e-01, -4.956304e-01, -1.265846e-01, -2.647620e-01},
  {-9.487365e-01,  2.213235e-01,  2.256433e-01, -5.041299e-01, -8.817755e-02, -3.284259e-01},
  { 9.376698e-01, -2.657029e-01,  2.240033e-01,  4.323750e-01, -1.474212e-02, -3.120975e-01},
  {-9.767165e-01,  2.021963e-01,  7.170393e-02, -5.055407e-01, -6.750137e-02, -3.763604e-01},
  { 9.869086e-01, -1.174198e-01,  1.105625e-01,  4.400655e-01, -1.273620e-02, -3.578833e-01},
  {-6.150329e-01,  5.354688e-01,  5.787985e-01, -2.208674e-01,  1.403594e-01, -2.161239e-01},
  { 9.988187e-01, -1.927857e-02,  4.460366e-02,  4.420607e-01, -2.319474e-02, -3.902154e-01},
  {-9.128479e-01,  1.725978e-01, -3.700251e-01, -4.995428e-01, -1.215067e-01, -5.524313e-01},
  { 8.784595e-01,  1.681830e-01, -4.472398e-01,  4.344007e-01, -2.201202e-02, -4.410863e-01},
  { 3.862575e-01, -1.591504e-01, -9.085572e-01,  2.143154e-01, -1.501032e-02, -4.903926e-01},
  {-9.560018e-01,  1.588179e-01, -2.466528e-01, -4.949357e-01, -6.756799e-02, -5.390337e-01},
  {-9.600984e-01,  2.484973e-01, -1.282966e-01, -4.921942e-01, -3.899891e-02, -5.169499e-01},
  {-9.137335e-01,  5.545843e-02, -4.025116e-01, -4.749614e-01, -8.528712e-02, -6.120172e-01},
  { 7.434835e-01,  1.735979e-01, -6.458298e-01,  4.238099e-01, -2.728920e-02, -4.593994e-01},
  {-5.381947e-02, -1.820616e-01, -9.818131e-01,  3.275914e-01, -2.845417e-02, -4.862447e-01},
  { 9.334577e-01, -9.607050e-02, -3.455824e-01,  7.895812e-02, -3.389405e-02, -5.797962e-01},
  { 8.050180e-01, -1.698975e-01, -5.684020e-01,  9.037560e-02, -2.911925e-02, -5.541273e-01},
  { 5.604761e-01,  2.115825e-01, -8.006868e-01,  4.135250e-01, -2.285120e-02, -4.670680e-01},
  { 1.949237e-01,  1.651574e-01, -9.668132e-01,  3.759148e-01, -2.660839e-02, -4.852167e-01},
  { 7.463892e-01, -1.880196e-01, -6.383979e-01,  1.278173e-02, -6.193418e-02, -7.262216e-01},
  { 5.583466e-01, -2.202670e-01, -7.998322e-01, -3.097171e-02, -1.002463e-01, -7.539657e-01},
  { 9.433913e-01, -9.753320e-02, -3.170176e-01,  5.796131e-02, -1.714756e-03, -6.653274e-01},
  {-1.213400e-01, -1.795498e-01, -9.762369e-01, -2.113757e-01, -8.963232e-02, -7.939094e-01},
  { 8.961496e-01, -1.236337e-01, -4.261814e-01,  4.650264e-02,  2.015166e-03, -6.944665e-01},
  { 3.399961e-01, -2.445982e-01, -9.080607e-01, -7.125593e-02, -9.722475e-02, -7.766178e-01},
  {-3.296161e-01,  7.453758e-02,  9.411681e-01,  1.145125e-01,  6.490931e-02,  8.375203e-01},
  { 9.190306e-01, -1.263581e-01,  3.733851e-01,  3.965330e-01, -3.635018e-02,  7.251186e-01},
  { 9.784185e-01, -1.208534e-01,  1.676058e-01,  4.202171e-01, -7.875744e-02,  6.168025e-01},
  {-5.414943e-01,  1.806410e-02,  8.405103e-01, -5.476698e-02,  8.054239e-02,  7.469081e-01},
  {-9.758686e-01,  6.953156e-02,  2.069924e-01, -4.449962e-01, -9.318205e-02,  2.659684e-01},
  {-9.896097e-01, -2.777149e-02, -1.410723e-01, -4.364106e-01, -4.428183e-02,  1.922349e-01},
  { 9.804711e-01, -1.951930e-01,  2.399961e-02,  3.938571e-01,  2.996146e-02, -4.008130e-02},
  {-8.170168e-01,  1.021609e-01, -5.674916e-01, -3.836225e-01,  1.397923e-02,  9.493108e-02},
  {-7.465147e-01,  2.935072e-01, -5.971343e-01, -2.309510e-01,  1.185858e-01, -7.375210e-02},
  {-8.719867e-01,  2.987516e-01, -3.877971e-01, -2.141988e-01,  1.117933e-01, -1.035190e-01},
  {-9.075142e-01,  3.455676e-01, -2.387490e-01, -2.110739e-01,  1.053323e-01, -1.177700e-01},
  {-7.610211e-01,  4.074329e-01,  5.048220e-01, -4.635206e-01, -7.954712e-02, -2.446327e-01},
  { 9.701514e-01, -1.762164e-01,  1.665952e-01,  4.295162e-01,  5.268816e-02, -2.151499e-01},
  {-7.991866e-01,  3.849521e-01,  4.616411e-01, -4.793616e-01, -1.027717e-01, -2.503113e-01},
  {-6.812861e-01,  4.086069e-01,  6.073629e-01, -4.280932e-01,  4.292336e-02, -2.908579e-01},
  {-7.111827e-01,  4.043991e-01,  5.750483e-01, -4.455763e-01,  2.933694e-03, -2.835214e-01},
  {-6.846586e-01,  4.164621e-01,  5.981655e-01, -4.304567e-01,  5.162661e-02, -2.994891e-01},
  {-8.530584e-01,  5.046204e-01,  1.328522e-01, -2.060260e-01,  1.129139e-01, -1.533159e-01},
  {-8.766451e-01,  2.944364e-01,  3.805267e-01, -4.887864e-01, -6.943957e-02, -2.986847e-01},
  {-8.089769e-01,  4.998330e-01,  3.093916e-01, -2.019589e-01,  1.357407e-01, -1.856222e-01},
  {-9.775942e-01,  2.104561e-01, -4.230421e-03, -5.015277e-01, -4.556610e-02, -4.106521e-01},
  {-5.802833e-01,  5.603635e-01,  5.909857e-01, -2.128160e-01,  1.553980e-01, -2.218958e-01},
  { 9.604673e-01,  1.239495e-01, -2.492768e-01,  4.381754e-01, -1.148588e-02, -4.255461e-01},
  {-9.449878e-01,  9.554420e-02, -3.128407e-01, -4.913795e-01, -9.068604e-02, -5.671258e-01},
  {-9.478582e-01,  7.412091e-02, -3.099529e-01, -4.860616e-01, -8.467914e-02, -5.818608e-01},
  {-9.333363e-01,  1.888367e-01, -3.053263e-01, -4.906930e-01, -4.774171e-02, -5.409467e-01},
  { 6.156255e-01, -2.585621e-01, -7.444131e-01,  1.086294e-01, -2.802080e-02, -5.354306e-01},
  { 7.264629e-01,  2.384636e-01, -6.445051e-01,  4.225615e-01, -1.386550e-02, -4.560772e-01},
  { 8.687735e-01, -1.333835e-01, -4.769082e-01,  8.824152e-02,  2.567937e-04, -5.662214e-01},
  { 3.543773e-01,  2.029069e-01, -9.128228e-01,  3.935811e-01, -2.437995e-02, -4.792673e-01},
  { 8.286820e-02, -2.737873e-01, -9.582136e-01,  3.499596e-01, -2.216684e-02, -4.872648e-01},
  { 1.334642e-01, -2.916456e-02, -9.906244e-01,  3.644247e-01, -1.928807e-02, -4.860813e-01},
  { 6.343389e-01, -2.022845e-01, -7.461200e-01, -5.538104e-03, -7.928791e-02, -7.400037e-01},
  { 7.727028e-01, -1.718505e-01, -6.110628e-01,  1.673628e-02, -4.848958e-02, -7.252743e-01},
  {-8.390343e-01,  8.389463e-02, -5.375715e-01, -4.447270e-01, -5.307944e-02, -6.623014e-01},
  { 5.018327e-01, -2.359513e-01, -8.321605e-01, -4.878986e-02, -7.989072e-02, -7.708122e-01},
  { 1.533300e-01, -2.512939e-01, -9.556890e-01, -1.139338e-01, -5.738592e-02, -7.989831e-01},
  {-7.203899e-01,  8.767160e-02, -6.880058e-01, -3.653612e-01,  2.503700e-02, -7.495638e-01},
  {-5.217023e-01,  2.270491e-03, -8.531246e-01, -3.267507e-01,  3.783027e-02, -7.775677e-01},
  { 1.437963e-01, -3.643196e-02,  9.889364e-01,  2.961270e-01,  2.037962e-02,  8.507640e-01},
  { 1.900796e-01, -1.326862e-01,  9.727611e-01,  2.783425e-01,  2.381252e-02,  8.567865e-01},
  {-4.391727e-01,  1.082791e-01,  8.918536e-01,  1.259684e-01,  1.094712e-01,  8.378031e-01},
  {-1.794139e-02, -1.122484e-02,  9.997761e-01,  2.729373e-01,  3.675868e-02,  8.600703e-01},
  {-8.498894e-02, -3.707577e-02,  9.956919e-01,  2.694775e-01,  3.614332e-02,  8.591246e-01},
  { 3.375961e-02, -4.873727e-02,  9.982409e-01,  2.530192e-01,  4.522254e-02,  8.612673e-01},
  { 8.562703e-01, -1.326212e-01,  4.992124e-01,  3.765789e-01, -2.911538e-02,  7.734801e-01},
  {-4.197018e-01,  5.071893e-02,  9.062439e-01,  6.884114e-02,  3.982061e-02,  8.219662e-01},
  {-7.680221e-01,  8.846065e-02,  6.342844e-01, -3.008169e-01,  2.558963e-02,  5.113472e-01},
  { 9.957714e-01, -8.681281e-02,  3.004632e-02,  4.504513e-01, -1.463338e-02,  3.638652e-01},
  { 9.962523e-01, -4.429917e-02, -7.428925e-02,  4.475680e-01, -1.713208e-02,  2.376239e-01},
  {-9.636842e-01,  1.181134e-01,  2.395032e-01, -4.373106e-01, -5.629417e-02,  2.959101e-01},
  {-9.390312e-01,  1.230483e-01,  3.210598e-01, -4.151230e-01, -1.370839e-02,  3.335367e-01},
  {-9.788650e-01,  4.643407e-02, -1.991662e-01, -4.366530e-01, -3.295352e-02,  1.989558e-01},
  {-9.248380e-01,  4.772043e-02, -3.773558e-01, -4.237176e-01, -1.574567e-02,  1.604666e-01},
  {-6.011202e-01,  4.546586e-01,  6.572215e-01, -3.897130e-01,  5.421201e-02, -2.619126e-01},
  {-9.045253e-01,  4.169075e-01, -8.956612e-02, -2.048524e-01,  1.131719e-01, -1.332830e-01},
  {-6.725957e-01,  4.226241e-01,  6.074569e-01, -4.270036e-01,  6.665111e-02, -3.062214e-01},
  {-8.597866e-01,  3.245091e-01,  3.942853e-01, -4.815758e-01, -6.002738e-02, -2.910407e-01},
  {-9.474980e-01,  2.614059e-01,  1.841590e-01, -4.989385e-01, -4.661267e-02, -3.527481e-01},
  {-7.652894e-01,  5.186690e-01,  3.812017e-01, -1.914456e-01,  1.568551e-01, -1.930342e-01},
  {-7.830691e-01,  5.123643e-01,  3.525417e-01, -1.890890e-01,  1.674794e-01, -2.029330e-01},
  { 9.769090e-01,  1.035668e-01, -1.868765e-01,  4.404655e-01, -8.917428e-04, -4.083438e-01},
  {-9.456282e-01,  8.689075e-02, -3.134281e-01, -4.818927e-01, -6.477500e-02, -5.890597e-01},
  {-9.459834e-01,  2.368637e-01, -2.213843e-01, -4.853281e-01, -2.889316e-02, -5.444890e-01},
  { 7.942411e-01,  2.432189e-01, -5.567994e-01,  4.266723e-01, -5.932368e-03, -4.478026e-01},
  { 6.256495e-01, -2.387061e-01, -7.426857e-01,  1.069138e-01, -1.725524e-02, -5.402336e-01},
  { 9.195897e-01, -7.983421e-02, -3.846834e-01,  8.009684e-02,  1.261883e-02, -5.856370e-01},
  {-9.047882e-01,  1.227272e-01, -4.077946e-01, -4.683660e-01, -5.184137e-02, -6.206760e-01},
  { 7.245781e-02,  7.965004e-02, -9.941860e-01,  3.511233e-01, -1.019327e-02, -4.866470e-01},
  { 2.506077e-01,  1.525847e-01, -9.559883e-01,  3.736528e-01, -1.025500e-02, -4.831891e-01},
  { 9.501722e-01, -1.007736e-01, -2.949873e-01,  6.268444e-02,  2.498895e-02, -6.586265e-01},
  { 9.565490e-01, -8.045831e-02, -2.802508e-01,  7.360046e-02,  2.847021e-02, -6.099553e-01},
  {-8.329129e-01,  1.392929e-01, -5.355871e-01, -4.288621e-01, -1.986419e-02, -6.802106e-01},
  {-8.704982e-01,  7.971633e-02, -4.856730e-01, -4.627559e-01, -5.285437e-02, -6.322713e-01},
  { 6.613036e-01, -1.999174e-01, -7.229872e-01, -2.290361e-03, -4.390949e-02, -7.469003e-01},
  {-3.541178e-02, -2.063901e-01, -9.778288e-01, -1.937175e-01, -5.897996e-02, -8.014426e-01},
  { 8.914366e-01, -1.137147e-01, -4.386454e-01,  4.688096e-02,  3.139761e-02, -7.019351e-01},
  {-2.138407e-01, -1.635833e-01, -9.630746e-01, -2.570380e-01, -2.441101e-02, -7.976262e-01},
  { 3.025201e-01, -2.389293e-01, -9.227104e-01, -8.711178e-02, -4.216351e-02, -7.966947e-01},
  {-4.482518e-01, -6.040041e-02, -8.918644e-01, -3.005421e-01,  4.083991e-02, -7.919319e-01},
  {-2.283950e-01,  6.274055e-02,  9.715449e-01,  1.956023e-01,  1.395562e-01,  8.544252e-01},
  {-3.106455e-01,  1.017415e-01,  9.450651e-01,  1.452864e-01,  1.544661e-01,  8.393120e-01},
  { 4.665480e-01, -1.078984e-01,  8.778901e-01,  3.410582e-01,  7.883047e-02,  8.353896e-01},
  { 3.573566e-01, -8.896758e-02,  9.297208e-01,  3.016193e-01,  5.241114e-02,  8.512546e-01},
  { 1.768486e-01,  1.602680e-02,  9.841076e-01,  2.782694e-01,  4.786382e-02,  8.578446e-01},
  { 7.828600e-01, -1.633060e-01,  6.003844e-01,  3.762724e-01,  3.345237e-02,  7.907142e-01},
  { 8.083149e-01, -1.491070e-01,  5.695560e-01,  3.735783e-01,  6.903098e-03,  7.881631e-01},
  {-3.876884e-01,  6.886689e-02,  9.192144e-01,  9.016030e-02,  8.290923e-02,  8.269706e-01},
  {-4.843180e-01,  5.266362e-02,  8.733056e-01,  5.837570e-02,  7.600088e-02,  8.122398e-01},
  { 9.299872e-01, -1.437692e-01,  3.383109e-01,  4.033399e-01, -1.020360e-02,  7.168248e-01},
  { 9.836271e-01, -1.349275e-01,  1.194660e-01,  4.358440e-01, -3.559224e-02,  5.456904e-01},
  {-6.116580e-01,  1.570676e-02,  7.909663e-01, -1.098612e-01,  8.908205e-02,  7.076604e-01},
  { 9.869130e-01, -1.234256e-01,  1.037731e-01,  4.402938e-01, -2.004081e-02,  5.262384e-01},
  { 9.970369e-01, -7.118547e-02, -2.915462e-02,  4.524728e-01,  3.389975e-03,  3.080556e-01},
  {-9.223365e-01,  2.313183e-01,  3.094950e-01, -4.363962e-01, -4.022877e-02,  2.900702e-01},
  {-9.973900e-01,  7.434363e-03, -7.181936e-02, -4.444200e-01, -7.168669e-02,  2.406635e-01},
  {-9.644381e-01,  2.163919e-01,  1.517681e-01, -4.413008e-01, -2.736673e-02,  2.596201e-01},
  {-9.908780e-01,  1.264174e-01, -4.668381e-02, -4.432004e-01, -2.670362e-02,  2.429168e-01},
  {-9.848558e-01,  1.731816e-01, -8.198363e-03, -4.402869e-01, -1.760795e-02,  2.217108e-01},
  { 9.362110e-01,  5.446872e-02, -3.471920e-01,  4.235256e-01, -1.948552e-02,  1.036032e-01},
  { 9.851737e-01, -1.611162e-01,  5.894255e-02,  3.989649e-01,  5.962639e-02, -3.155304e-02},
  {-8.264449e-01,  2.410964e-02, -5.625011e-01, -2.990863e-01,  1.061969e-01,  6.738689e-03},
  {-7.952858e-01,  1.071446e-01, -5.966914e-01, -3.656182e-01,  5.169284e-02,  7.719436e-02},
  {-8.706090e-01,  7.215072e-02, -4.866560e-01, -4.095771e-01,  1.471141e-02,  1.356836e-01},
  {-7.077749e-01,  2.640640e-01, -6.552289e-01, -2.379379e-01,  1.339376e-01, -5.898689e-02},
  {-8.504319e-01,  2.575898e-01, -4.587079e-01, -2.041916e-01,  1.385725e-01, -1.062320e-01},
  {-8.918258e-01,  3.840957e-01, -2.389921e-01, -1.999466e-01,  1.250495e-01, -1.285306e-01},
  {-4.892559e-01,  4.885978e-01,  7.224270e-01, -3.683881e-01,  5.551079e-02, -2.465969e-01},
  {-7.953444e-01,  3.703544e-01,  4.798592e-01, -4.670480e-01, -5.657627e-02, -2.680458e-01},
  {-4.140148e-01,  5.076308e-01,  7.555810e-01, -3.107359e-01,  5.057573e-02, -2.086391e-01},
  { 9.731525e-01, -1.803355e-01,  1.430162e-01,  4.359529e-01,  5.255479e-02, -2.548284e-01},
  {-7.832634e-01,  3.685975e-01,  5.006341e-01, -4.603758e-01, -5.824684e-03, -2.978297e-01},
  {-7.887109e-01,  3.833714e-01,  4.805845e-01, -4.682780e-01, -2.774776e-02, -2.935751e-01},
  {-6.664581e-01,  4.334942e-01,  6.065611e-01, -4.098006e-01,  1.088616e-01, -3.175271e-01},
  {-8.686379e-01,  3.310784e-01,  3.685854e-01, -4.877549e-01, -3.117403e-02, -3.305964e-01},
  { 9.844401e-01, -1.404517e-01,  1.055982e-01,  4.396185e-01,  3.544314e-02, -3.037034e-01},
  { 9.897067e-01, -9.581826e-02,  1.062994e-01,  4.399475e-01,  2.866426e-02, -3.141994e-01},
  { 9.986369e-01,  2.440006e-02, -4.614076e-02,  4.423747e-01,  1.861452e-02, -3.721888e-01},
  {-9.668881e-01,  2.485005e-01, -5.809394e-02, -4.902335e-01, -1.732107e-03, -4.370367e-01},
  { 8.504678e-01,  1.732719e-01, -4.966703e-01,  4.301738e-01,  4.771129e-03, -4.372434e-01},
  {-5.884160e-02,  3.431728e-02, -9.976773e-01,  3.283587e-01,  7.639894e-03, -4.870399e-01},
  { 8.469700e-01, -1.364482e-01, -5.138324e-01,  8.572391e-02,  3.246072e-02, -5.792621e-01},
  {-8.690850e-01,  1.546782e-01, -4.698574e-01, -4.508271e-01, -3.055502e-02, -6.468119e-01},
  {-8.650283e-01,  2.043691e-01, -4.582133e-01, -4.439845e-01, -1.026427e-02, -6.519103e-01},
  {-8.143784e-01,  1.476078e-01, -5.612484e-01, -4.138117e-01, -6.282801e-03, -6.990424e-01},
  { 8.947982e-01, -1.184795e-01, -4.304634e-01,  5.252829e-02,  4.704177e-02, -6.942796e-01},
  { 8.239567e-01, -1.361093e-01, -5.500634e-01,  3.152394e-02,  3.009344e-02, -7.269492e-01},
  { 2.856102e-01, -2.267614e-01, -9.311316e-01, -8.229722e-02, -2.426763e-02, -7.996860e-01},
  {-2.873529e-01, -1.365705e-01, -9.480384e-01, -2.748835e-01,  1.588257e-02, -7.992334e-01},
  {-7.404643e-01,  9.624121e-02, -6.651692e-01, -3.618419e-01,  6.110380e-02, -7.482768e-01},
  { 1.327340e-01, -2.238681e-01, -9.655386e-01, -1.202791e-01, -2.252889e-02, -8.090734e-01},
  {-6.042722e-01,  2.138602e-02, -7.964909e-01, -3.349153e-01,  6.919456e-02, -7.716911e-01},
  { 6.014257e-01, -1.153363e-01,  7.905597e-01,  3.563109e-01,  1.299035e-01,  8.330829e-01},
  { 4.506616e-01, -1.125263e-01,  8.855743e-01,  3.408340e-01,  1.170621e-01,  8.409083e-01},
  { 5.070658e-01, -1.365326e-01,  8.510247e-01,  3.390645e-01,  9.112400e-02,  8.381597e-01},
  {-1.110037e-01,  1.198663e-02,  9.937477e-01,  2.245644e-01,  1.132581e-01,  8.597903e-01},
  { 6.994437e-01, -1.198811e-01,  7.045616e-01,  3.681392e-01,  1.039943e-01,  8.167464e-01},
  { 7.805006e-01, -1.762437e-01,  5.997974e-01,  3.762212e-01,  8.991063e-02,  8.045388e-01},
  {-3.554316e-02,  1.558477e-02,  9.992467e-01,  2.377537e-01,  8.137857e-02,  8.615168e-01},
  { 1.357968e-01, -2.820810e-02,  9.903351e-01,  2.669059e-01,  6.826203e-02,  8.604868e-01},
  { 8.791645e-01, -1.434613e-01,  4.544103e-01,  3.860835e-01,  1.513830e-02,  7.696790e-01},
  { 9.134245e-01, -1.433962e-01,  3.809111e-01,  4.233363e-01,  2.682643e-02,  6.625833e-01},
  {-7.942896e-01, -7.136879e-02,  6.033327e-01, -2.285817e-01,  6.978615e-02,  5.899559e-01},
  {-4.768066e-01,  9.604860e-02,  8.737448e-01, -1.217805e-02,  1.235730e-01,  7.692403e-01},
  {-5.056597e-01,  8.690331e-02,  8.583450e-01, -4.553875e-02,  1.182469e-01,  7.503932e-01},
  {-8.353789e-01,  9.231838e-02,  5.418665e-01, -3.435453e-01,  4.159225e-02,  4.516798e-01},
  { 9.976085e-01, -6.030926e-02, -3.376413e-02,  4.543041e-01,  3.849376e-02,  2.993912e-01},
  {-9.947138e-01,  6.264584e-02,  8.136430e-02, -4.445214e-01, -4.860913e-02,  2.539174e-01},
  { 9.821733e-01,  1.478293e-01, -1.161118e-01,  4.413792e-01,  4.617872e-02,  1.811587e-01},
  {-9.767703e-01,  1.957442e-01,  8.720130e-02, -4.339182e-01,  2.423407e-02,  2.372927e-01},
  {-9.724507e-01,  2.327812e-01,  1.235137e-02, -4.344217e-01,  2.210817e-02,  2.339660e-01},
  {-9.819590e-01,  1.668829e-01, -8.891886e-02, -4.368373e-01,  1.323228e-02,  2.229995e-01},
  {-8.964785e-01,  3.631693e-01, -2.538394e-01, -1.935965e-01,  1.398346e-01, -1.290478e-01},
  {-5.224093e-01,  4.765485e-01,  7.070999e-01, -3.800768e-01,  7.835977e-02, -2.703454e-01},
  {-8.954524e-01,  4.451079e-01,  6.623435e-03, -1.906618e-01,  1.411725e-01, -1.475823e-01},
  {-8.173237e-01,  3.680746e-01,  4.432866e-01, -4.604913e-01,  9.700980e-03, -3.098089e-01},
  {-7.681610e-01,  4.062475e-01,  4.948651e-01, -4.461933e-01,  6.163754e-02, -3.270127e-01},
  {-8.604991e-01,  4.658355e-01,  2.062490e-01, -1.828942e-01,  1.645711e-01, -1.806203e-01},
  {-7.262779e-01,  4.223236e-01,  5.423682e-01, -4.200751e-01,  1.172466e-01, -3.361338e-01},
  {-9.355473e-01,  2.977611e-01,  1.899725e-01, -4.923224e-01, -1.446449e-02, -3.655404e-01},
  {-7.283807e-01,  5.584393e-01,  3.969977e-01, -1.762419e-01,  1.969565e-01, -2.189293e-01},
  {-9.634050e-01,  2.573437e-01,  7.500061e-02, -4.897419e-01,  5.563686e-03, -3.958989e-01},
  { 9.465935e-01,  1.592534e-01, -2.803554e-01,  4.356347e-01,  1.868989e-02, -4.172212e-01},
  { 3.404003e-01, -1.377877e-01, -9.301302e-01,  2.076796e-01,  6.277590e-02, -5.031973e-01},
  { 4.922765e-01, -3.855392e-01, -7.803994e-01,  1.792613e-01,  4.857824e-02, -5.122531e-01},
  { 3.625628e-01,  1.524635e-01, -9.194037e-01,  1.549030e-01,  3.210853e-02, -5.217454e-01},
  { 7.192316e-01,  1.953876e-01, -6.667305e-01,  4.232209e-01,  1.492947e-02, -4.431041e-01},
  { 6.917039e-01, -2.141951e-01, -6.896856e-01,  9.762452e-02,  2.709393e-02, -5.616934e-01},
  { 8.062383e-01, -1.312034e-01, -5.768582e-01,  8.806081e-02,  5.030888e-02, -5.798803e-01},
  { 4.220542e-01,  2.930925e-01, -8.578852e-01,  3.906792e-01,  6.149016e-03, -4.727506e-01},
  { 2.722115e-01,  1.703114e-01, -9.470454e-01,  3.657383e-01,  7.130308e-03, -4.825458e-01},
  { 9.408268e-01, -6.685656e-02, -3.322274e-01,  7.779912e-02,  6.102723e-02, -6.027279e-01},
  { 8.232163e-01, -1.027622e-01, -5.583502e-01,  8.698370e-02,  5.962913e-02, -5.836670e-01},
  { 5.971571e-01, -2.211325e-01, -7.710408e-01, -2.657277e-02, -3.518989e-02, -7.695360e-01},
  { 4.503175e-01, -2.326927e-01, -8.620141e-01, -4.317430e-02, -3.609949e-02, -7.801975e-01},
  { 7.120806e-01, -1.838113e-01, -6.776094e-01,  1.130870e-02,  7.886999e-03, -7.465732e-01},
  {-7.839406e-01,  1.672196e-01, -5.978919e-01, -3.968360e-01,  2.466197e-02, -7.136680e-01},
  {-7.376669e-01,  8.324826e-02, -6.700129e-01, -3.562520e-01,  9.206152e-02, -7.505606e-01},
  { 1.496999e-01, -1.902432e-01, -9.702564e-01, -1.148272e-01, -1.688345e-02, -8.093239e-01},
  {-4.997908e-01, -4.106345e-02, -8.651723e-01, -3.059406e-01,  7.449049e-02, -7.912361e-01},
  {-6.707438e-01,  5.359406e-02, -7.397503e-01, -3.382870e-01,  1.065425e-01, -7.669014e-01},
  { 5.830380e-01, -4.292101e-02,  8.113104e-01,  3.526517e-01,  1.453859e-01,  8.373866e-01},
  { 4.368387e-01, -9.535988e-02,  8.944710e-01,  3.420270e-01,  1.342932e-01,  8.425783e-01},
  {-1.064694e-01,  3.973628e-02,  9.935217e-01,  2.298699e-01,  1.695223e-01,  8.598477e-01},
  { 4.302112e-01, -8.778994e-02,  8.984494e-01,  3.299663e-01,  1.002493e-01,  8.443155e-01},
  { 7.147017e-01, -8.270444e-02,  6.945225e-01,  3.718801e-01,  1.327402e-01,  8.179606e-01},
  { 3.328685e-01, -8.770263e-02,  9.388860e-01,  3.083209e-01,  7.942373e-02,  8.516690e-01},
  { 8.525040e-01, -1.646099e-01,  4.961256e-01,  3.928111e-01,  1.029031e-01,  7.852294e-01},
  {-3.942749e-01,  9.080464e-02,  9.144954e-01,  8.262378e-02,  1.168747e-01,  8.195856e-01},
  { 9.203546e-01, -1.549640e-01,  3.590731e-01,  4.007034e-01,  3.172142e-02,  7.449751e-01},
  {-3.922064e-01,  1.653480e-01,  9.048946e-01,  6.276377e-02,  1.763693e-01,  8.004963e-01},
  { 8.189741e-01, -1.424034e-01,  5.558802e-01,  4.272896e-01,  6.209050e-02,  6.670769e-01},
  {-7.585425e-01,  1.216578e-02,  6.515100e-01, -2.273578e-01,  7.539647e-02,  5.917645e-01},
  { 9.803191e-01, -1.100130e-01,  1.639260e-01,  4.349908e-01,  2.027112e-02,  5.992289e-01},
  {-6.666634e-01,  2.929231e-02,  7.447830e-01, -1.311425e-01,  1.123827e-01,  6.893493e-01},
  {-8.194394e-01,  1.548355e-01,  5.518560e-01, -3.384356e-01,  1.296948e-01,  4.388698e-01},
  {-8.212195e-01,  2.017441e-01,  5.337582e-01, -3.396820e-01,  1.604966e-01,  4.265725e-01},
  {-8.450860e-01,  1.083133e-01,  5.235435e-01, -3.582502e-01,  7.601145e-02,  4.221864e-01},
  { 9.935556e-01, -4.166082e-02, -1.054119e-01,  4.508791e-01,  5.171543e-02,  2.438612e-01},
  { 9.822554e-01,  1.425346e-01, -1.218943e-01,  4.113858e-01,  9.203265e-02,  5.206826e-02},
  { 9.764072e-01, -1.241548e-01,  1.766760e-01,  4.241828e-01,  1.062674e-01, -1.303443e-01},
  { 9.968331e-01, -6.937407e-02,  3.887212e-02,  4.292204e-01,  1.003416e-01, -1.705600e-01},
  {-9.036173e-01,  3.527473e-01, -2.429921e-01, -1.890749e-01,  1.466358e-01, -1.355516e-01},
  {-8.954650e-01,  4.439633e-01,  3.223359e-02, -1.861318e-01,  1.504728e-01, -1.509985e-01},
  {-7.703443e-01,  3.805330e-01,  5.116290e-01, -4.513032e-01,  4.848313e-02, -3.255097e-01},
  { 9.934697e-01, -1.018712e-01,  5.138449e-02,  4.408355e-01,  5.793542e-02, -2.892169e-01},
  {-7.892702e-01,  4.166782e-01,  4.510341e-01, -4.385451e-01,  1.025635e-01, -3.525278e-01},
  {-9.006804e-01,  3.260763e-01,  2.871394e-01, -4.815724e-01,  3.855527e-03, -3.480544e-01},
  {-7.664595e-01,  4.382907e-01,  4.695115e-01, -4.194128e-01,  1.393126e-01, -3.547881e-01},
  {-7.512530e-01,  4.439818e-01,  4.883637e-01, -4.117611e-01,  1.615103e-01, -3.630511e-01},
  { 9.937491e-01,  4.209425e-02, -1.033966e-01,  4.417041e-01,  4.682715e-02, -3.703464e-01},
  {-6.692574e-01,  5.909455e-01,  4.504198e-01, -1.737037e-01,  2.075225e-01, -2.289550e-01},
  { 9.593418e-01,  1.201461e-01, -2.553980e-01,  4.390914e-01,  4.075608e-02, -3.922778e-01},
  { 2.460328e-01, -6.176830e-02, -9.672913e-01,  2.316614e-01,  8.231129e-02, -4.970373e-01},
  { 8.377944e-01,  2.643027e-01, -4.777497e-01,  4.266037e-01,  2.849397e-02, -4.314168e-01},
  { 1.370773e-01,  2.469863e-01, -9.592745e-01,  2.646658e-01,  7.817419e-02, -4.899199e-01},
  { 2.592353e-01,  8.625980e-04, -9.658138e-01,  2.509950e-01,  8.411849e-02, -4.924336e-01},
  { 3.261245e-01, -1.031425e-01, -9.396832e-01,  2.004368e-01,  8.272297e-02, -5.063212e-01},
  { 5.269697e-01, -1.508299e-01, -8.363931e-01,  1.398544e-01,  2.827400e-02, -5.297199e-01},
  { 4.872918e-01, -3.622295e-02, -8.724876e-01,  1.244836e-01,  2.378580e-02, -5.384479e-01},
  {-9.424517e-01,  1.427869e-01, -3.023188e-01, -4.787050e-01, -3.412147e-02, -5.909072e-01},
  {-8.718079e-01,  3.306248e-01, -3.614390e-01, -4.505355e-01,  6.092989e-03, -6.305419e-01},
  { 5.980068e-01,  2.885005e-01, -7.477669e-01,  4.053970e-01,  1.056707e-02, -4.623523e-01},
  { 8.976384e-01, -6.931862e-02, -4.352472e-01,  7.909919e-02,  8.241586e-02, -6.035917e-01},
  { 5.607875e-01, -2.071030e-01, -8.016394e-01, -2.543240e-02, -1.985634e-02, -7.728426e-01},
  { 9.696906e-01, -4.397504e-02, -2.403460e-01,  7.241983e-02,  9.933753e-02, -6.276619e-01},
  { 4.320512e-01, -2.194877e-01, -8.747325e-01, -5.475889e-02, -4.429194e-03, -7.941963e-01},
  { 8.528348e-01, -1.225284e-01, -5.076017e-01,  4.338013e-02,  8.667392e-02, -7.226654e-01},
  { 8.188781e-01, -1.378761e-01, -5.571614e-01,  2.954862e-02,  7.367116e-02, -7.409663e-01},
  {-3.814341e-01, -1.163573e-01, -9.170436e-01, -2.700317e-01,  8.136947e-02, -8.093569e-01},
  { 1.446560e-01, -1.960655e-01, -9.698624e-01, -1.171278e-01,  1.797942e-02, -8.164645e-01},
  {-5.446690e-01, -2.938183e-02, -8.381363e-01, -3.094864e-01,  1.007003e-01, -7.897903e-01},
  {-6.712705e-01,  5.255276e-02, -7.393472e-01, -3.284619e-01,  1.223634e-01, -7.747323e-01},
  { 3.901951e-01, -4.049630e-02,  9.198412e-01,  3.407998e-01,  1.419429e-01,  8.436735e-01},
  { 5.992604e-02,  1.124443e-02,  9.981394e-01,  2.606600e-01,  1.524076e-01,  8.608886e-01},
  { 3.538626e-01, -6.957270e-02,  9.327062e-01,  3.153251e-01,  9.840200e-02,  8.504899e-01},
  { 8.034489e-01, -1.215574e-01,  5.828325e-01,  3.925832e-01,  1.310457e-01,  7.933317e-01},
  { 1.704699e-01, -3.578073e-02,  9.847130e-01,  2.832520e-01,  8.930101e-02,  8.590745e-01},
  { 8.438678e-01, -1.592713e-01,  5.123670e-01,  3.935508e-01,  9.041534e-02,  7.801612e-01},
  { 8.992139e-01, -1.682125e-01,  4.038799e-01,  3.989004e-01,  1.186996e-01,  7.798899e-01},
  { 8.963030e-01, -1.290348e-01,  4.242535e-01,  3.990175e-01,  7.906666e-02,  7.664728e-01},
  { 8.953812e-01, -1.570073e-01,  4.167030e-01,  3.986876e-01,  5.382520e-02,  7.588655e-01},
  { 9.570315e-01, -1.375568e-01,  2.552818e-01,  4.160424e-01,  5.858339e-02,  7.089927e-01},
  {-2.305921e-01, -1.758257e-02,  9.728916e-01,  3.378581e-02,  1.922510e-01,  7.844743e-01},
  {-3.789109e-01,  5.653264e-02,  9.237048e-01,  2.348605e-02,  1.765877e-01,  7.810734e-01},
  {-8.046119e-01, -5.016593e-02,  5.916783e-01, -2.591766e-01,  9.167399e-02,  5.509946e-01},
  {-8.146058e-01, -1.643374e-02,  5.797821e-01, -2.755476e-01,  1.018022e-01,  5.285068e-01},
  {-8.093151e-01,  1.119928e-01,  5.765994e-01, -3.011386e-01,  1.301007e-01,  4.888699e-01},
  {-8.241868e-01,  1.425866e-01,  5.480740e-01, -3.026117e-01,  1.376309e-01,  4.851065e-01},
  {-6.103298e-01,  5.219826e-02,  7.904257e-01, -1.146227e-01,  1.386531e-01,  7.017856e-01},
  {-5.470896e-01,  8.797325e-02,  8.324383e-01, -6.834203e-02,  1.477624e-01,  7.335920e-01},
  { 9.908957e-01, -1.039397e-01,  8.556977e-02,  4.456069e-01,  2.277933e-02,  5.208812e-01},
  {-7.975365e-01,  1.303160e-01,  5.890275e-01, -3.292528e-01,  7.072756e-02,  4.668344e-01},
  { 9.892485e-01, -1.138026e-01, -9.184975e-02,  4.081582e-01,  1.154596e-01,  2.429123e-02},
  { 9.914208e-01, -9.847930e-03, -1.303372e-01,  4.055434e-01,  1.056768e-01,  1.017684e-02},
  { 9.833698e-01, -1.538249e-01,  9.654891e-02,  4.063302e-01,  1.046556e-01, -3.031508e-02},
  {-9.688010e-01,  1.611905e-01, -1.882614e-01, -4.295011e-01,  2.499304e-02,  1.870837e-01},
  {-9.218822e-01,  8.444371e-02, -3.781569e-01, -4.203942e-01,  3.299857e-02,  1.608697e-01},
  {-8.775107e-01,  1.024283e-01, -4.684906e-01, -4.083394e-01,  5.770163e-02,  1.411209e-01},
  { 9.907550e-01,  6.016544e-02, -1.215925e-01,  4.302640e-01,  1.132960e-01, -1.610935e-01},
  {-9.063811e-01,  3.478109e-01, -2.397935e-01, -1.779208e-01,  1.733968e-01, -1.390595e-01},
  { 9.887790e-01, -8.059017e-02,  1.257822e-01,  4.378446e-01,  9.014039e-02, -2.355740e-01},
  { 9.983860e-01, -5.356426e-03, -5.654059e-02,  4.429426e-01,  7.050149e-02, -3.491276e-01},
  {-8.078337e-01,  5.225918e-01,  2.725847e-01, -1.618171e-01,  2.203864e-01, -2.227140e-01},
  {-8.400139e-01,  4.194396e-01,  3.441615e-01, -4.343636e-01,  1.353778e-01, -3.786392e-01},
  {-9.343865e-01,  2.837497e-01,  2.154254e-01, -4.805418e-01,  3.218004e-02, -3.770323e-01},
  {-9.773940e-01,  1.851740e-01,  1.020369e-01, -4.800459e-01,  3.783921e-02, -3.831322e-01},
  {-9.702085e-01,  2.342142e-01,  6.196058e-02, -4.808346e-01,  4.190772e-02, -3.922564e-01},
  {-9.738376e-01,  2.269484e-01, -1.161127e-02, -4.796983e-01,  4.436412e-02, -4.040029e-01},
  {-9.500455e-01,  3.092227e-01, -4.236450e-02, -4.768168e-01,  5.286003e-02, -4.174424e-01},
  { 3.154405e-01,  1.063606e-01, -9.429659e-01,  2.237215e-01,  1.160819e-01, -4.975287e-01},
  { 8.232539e-01,  2.556544e-01, -5.068468e-01,  4.260211e-01,  4.503307e-02, -4.239444e-01},
  { 1.055224e-01,  2.785892e-01, -9.545957e-01,  2.750435e-01,  8.494459e-02, -4.872794e-01},
  { 3.383001e-01, -1.660494e-01, -9.262725e-01,  1.796310e-01,  8.920652e-02, -5.147976e-01},
  {-9.471678e-01,  2.924365e-01, -1.317347e-01, -4.727966e-01,  3.987841e-02, -4.974815e-01},
  { 9.999364e-02,  1.848061e-01, -9.776748e-01,  3.140195e-01,  5.206445e-02, -4.843209e-01},
  { 5.831745e-01,  2.628035e-01, -7.686624e-01,  4.088198e-01,  2.505169e-02, -4.538612e-01},
  {-8.493556e-01,  2.187879e-01, -4.803403e-01, -4.287476e-01,  1.996028e-02, -6.661458e-01},
  { 9.698613e-01, -5.427090e-02, -2.375365e-01,  6.284902e-02,  7.510333e-02, -6.741726e-01},
  { 5.827302e-01, -2.068018e-01, -7.859126e-01, -2.599483e-02,  9.214456e-03, -7.810507e-01},
  {-1.543953e-01, -1.827717e-01, -9.709565e-01, -2.107118e-01, -1.188233e-02, -8.091107e-01},
  { 9.175529e-01, -1.002905e-01, -3.847578e-01,  5.564644e-02,  9.769214e-02, -7.010944e-01},
  {-7.987069e-01,  1.992543e-01, -5.677720e-01, -4.005302e-01,  3.520016e-02, -7.053438e-01},
  {-8.044039e-01,  1.815302e-01, -5.656688e-01, -4.003063e-01,  4.419719e-02, -7.026635e-01},
  {-8.330433e-01,  2.390041e-03, -5.532026e-01, -3.907885e-01,  5.154884e-02, -7.143328e-01},
  { 8.709328e-01, -1.103839e-01, -4.788438e-01,  4.569520e-02,  1.070383e-01, -7.236795e-01},
  { 2.315373e-01, -2.057372e-01, -9.508221e-01, -8.219829e-02,  3.282389e-02, -8.125601e-01},
  {-4.335440e-03, -1.908503e-01, -9.816096e-01, -1.634908e-01,  6.521625e-03, -8.164573e-01},
  {-7.680749e-01,  1.829223e-02, -6.400987e-01, -3.134827e-01,  1.748995e-01, -7.836079e-01},
  {-7.132043e-01,  1.288512e-01, -6.890116e-01, -3.362012e-01,  1.469804e-01, -7.643377e-01},
  {-7.541430e-01,  1.164828e-01, -6.462972e-01, -3.488986e-01,  1.307458e-01, -7.527508e-01},
  {-3.633883e-01, -1.369759e-01, -9.215132e-01, -2.596058e-01,  1.049928e-01, -8.169330e-01},
  { 3.434295e-01, -3.098238e-03,  9.391733e-01,  3.311620e-01,  1.711471e-01,  8.480672e-01},
  { 2.176415e-01, -3.650907e-03,  9.760219e-01,  3.168417e-01,  1.596004e-01,  8.526543e-01},
  { 8.042496e-02,  6.762504e-03,  9.967377e-01,  2.732008e-01,  1.679688e-01,  8.599030e-01},
  {-1.820339e-01,  6.245621e-02,  9.813067e-01,  2.178763e-01,  2.005662e-01,  8.549892e-01},
  { 7.733760e-01, -6.079111e-02,  6.310261e-01,  3.898420e-01,  1.632896e-01,  8.015809e-01},
  { 2.798278e-01, -3.056645e-02,  9.595634e-01,  2.941733e-01,  1.244500e-01,  8.578444e-01},
  { 5.251888e-02,  1.414142e-02,  9.985198e-01,  2.720870e-01,  1.316677e-01,  8.608431e-01},
  { 8.903509e-01, -7.664176e-02,  4.487776e-01,  4.024414e-01,  1.495351e-01,  7.809601e-01},
  {-3.000110e-01,  9.835749e-02,  9.488515e-01,  4.521457e-02,  2.063651e-01,  7.867929e-01},
  {-6.253241e-01,  1.188203e-01,  7.712662e-01, -1.182772e-01,  1.835551e-01,  6.952546e-01},
  {-8.018260e-01,  1.029655e-01,  5.886197e-01, -2.888083e-01,  1.189318e-01,  5.079581e-01},
  {-8.101524e-01,  1.028166e-01,  5.771326e-01, -2.890704e-01,  1.298013e-01,  5.055467e-01},
  {-8.588217e-01,  1.612958e-01,  4.862191e-01, -3.699084e-01,  1.367517e-01,  3.883628e-01},
  {-8.770261e-01,  1.072593e-01,  4.683168e-01, -3.788096e-01,  9.588636e-02,  3.827098e-01},
  { 9.754640e-01, -1.970776e-01,  9.813521e-02,  4.069841e-01,  1.134142e-01, -2.383949e-02},
  {-9.044451e-01,  4.178166e-01, -8.607198e-02, -4.206956e-01,  9.465636e-02,  2.220397e-01},
  {-9.764563e-01,  1.735199e-01, -1.281565e-01, -4.245521e-01,  7.332095e-02,  2.046029e-01},
  {-6.788751e-01,  1.840813e-01, -7.108042e-01, -2.426169e-01,  1.928718e-01, -3.804993e-02},
  {-8.970606e-01,  4.371231e-01, -6.485065e-02, -4.206486e-01,  9.324136e-02,  2.074336e-01},
  {-8.012884e-01,  2.036954e-01, -5.625345e-01, -1.960695e-01,  2.017199e-01, -9.091273e-02},
  {-7.995200e-01,  1.132799e-01, -5.898606e-01, -3.613745e-01,  1.296852e-01,  8.496772e-02},
  {-8.328112e-01,  1.207372e-01, -5.402297e-01, -3.740706e-01,  1.154187e-01,  9.975319e-02},
  { 9.827885e-01,  1.479507e-01,  1.106233e-01,  4.298177e-01,  1.260345e-01, -1.532465e-01},
  {-8.597164e-01,  2.581642e-01, -4.407256e-01, -1.808306e-01,  1.902310e-01, -1.201284e-01},
  {-9.244266e-01,  3.464750e-01, -1.593439e-01, -1.698340e-01,  1.887112e-01, -1.482099e-01},
  {-9.125454e-01,  4.089408e-01, -5.320902e-03, -1.724273e-01,  1.799017e-01, -1.604272e-01},
  {-9.038719e-01,  4.170154e-01,  9.546517e-02, -1.680013e-01,  1.915248e-01, -1.725263e-01},
  {-4.166167e-01,  5.274064e-01,  7.404545e-01, -2.898190e-01,  1.488290e-01, -2.630684e-01},
  {-6.417522e-01,  4.611798e-01,  6.127539e-01, -3.936957e-01,  1.489123e-01, -3.301794e-01},
  {-8.743080e-01,  4.670469e-01,  1.321084e-01, -1.616217e-01,  2.087497e-01, -1.921719e-01},
  {-8.504251e-01,  3.872277e-01,  3.561346e-01, -4.597577e-01,  7.194583e-02, -3.646891e-01},
  {-6.769255e-01,  5.119693e-01,  5.288283e-01, -3.996836e-01,  1.983732e-01, -3.768669e-01},
  {-8.190464e-01,  4.698225e-01,  3.292867e-01, -4.048038e-01,  2.138304e-01, -3.992079e-01},
  {-8.639684e-01,  4.047794e-01,  2.995201e-01, -4.280234e-01,  1.632181e-01, -3.975973e-01},
  {-7.662776e-01,  4.786347e-01,  4.286345e-01, -4.056410e-01,  2.221177e-01, -4.105162e-01},
  {-8.804685e-01,  4.381181e-01,  1.811844e-01, -4.795282e-01,  4.238576e-02, -3.881443e-01},
  {-7.000532e-01,  5.870270e-01,  4.066018e-01, -1.654338e-01,  2.347998e-01, -2.526002e-01},
  {-5.377430e-01,  6.144141e-01,  5.773454e-01, -1.928602e-01,  2.259264e-01, -2.709854e-01},
  { 9.062948e-01,  1.145562e-01, -4.068252e-01,  4.366232e-01,  6.105938e-02, -3.936426e-01},
  { 5.004602e-01, -7.664323e-02, -8.623604e-01,  1.589014e-01,  9.740770e-02, -5.253342e-01},
  { 2.342957e-01,  2.507776e-01, -9.392636e-01,  3.082136e-01,  1.115536e-01, -4.749210e-01},
  { 2.793807e-01,  2.143817e-01, -9.359418e-01,  3.208567e-01,  8.950025e-02, -4.761336e-01},
  { 6.153018e-01, -1.740240e-01, -7.688428e-01,  1.250484e-01,  5.720616e-02, -5.438241e-01},
  {-9.154171e-01,  3.433518e-01, -2.100504e-01, -4.676501e-01,  1.376124e-02, -5.718907e-01},
  {-8.859297e-01,  3.926711e-01, -2.468563e-01, -4.671299e-01,  1.186843e-02, -5.769101e-01},
  {-8.775080e-01,  3.146069e-01, -3.619423e-01, -4.662287e-01, -6.518167e-03, -6.036267e-01},
  { 9.895739e-02,  4.993909e-01, -8.607067e-01,  3.398184e-01,  6.384557e-02, -4.769545e-01},
  {-8.785433e-01,  2.734372e-01, -3.916553e-01, -4.388341e-01,  3.204455e-02, -6.390993e-01},
  {-8.374463e-01,  2.077954e-01, -5.054747e-01, -4.170605e-01,  3.150136e-02, -6.810297e-01},
  { 5.873570e-01, -2.868758e-01, -7.567787e-01, -1.731210e-02,  2.788681e-02, -7.792161e-01},
  { 3.626745e-01, -3.301160e-01, -8.714876e-01, -5.253778e-02,  4.118931e-02, -8.043482e-01},
  {-8.554493e-01,  1.236773e-01, -5.029021e-01, -3.960238e-01,  5.536386e-02, -7.053131e-01},
  { 7.285689e-01, -1.723507e-01, -6.629348e-01,  1.551344e-02,  6.632951e-02, -7.571493e-01},
  {-7.790921e-01,  8.322755e-02, -6.213603e-01, -3.225996e-01,  1.908505e-01, -7.707358e-01},
  {-8.360264e-01,  1.811408e-01, -5.179265e-01, -3.666510e-01,  1.166282e-01, -7.315712e-01},
  {-2.832299e-01, -1.685513e-01, -9.441246e-01, -2.452618e-01,  8.426206e-02, -8.187363e-01},
  {-3.287940e-01, -1.557770e-01, -9.314656e-01, -2.409473e-01,  1.138870e-01, -8.251061e-01},
  {-6.797924e-01,  2.905042e-02, -7.328290e-01, -3.047440e-01,  1.525502e-01, -7.930533e-01},
  {-4.885544e-01, -7.220484e-02, -8.695406e-01, -2.783978e-01,  1.206328e-01, -8.100268e-01},
  { 5.747727e-01, -1.901992e-02,  8.180920e-01,  3.516058e-01,  1.726369e-01,  8.385274e-01},
  { 1.727695e-01,  1.345646e-02,  9.848704e-01,  2.994109e-01,  1.955985e-01,  8.564486e-01},
  { 6.243839e-01, -3.580116e-02,  7.802967e-01,  3.733695e-01,  1.909584e-01,  8.216802e-01},
  { 4.998234e-03,  3.168264e-02,  9.994855e-01,  2.627988e-01,  2.130802e-01,  8.590387e-01},
  { 3.219925e-02,  1.464903e-02,  9.993740e-01,  2.765813e-01,  2.353556e-01,  8.583834e-01},
  {-2.944143e-01,  9.492561e-02,  9.509518e-01,  1.756809e-01,  2.102648e-01,  8.432793e-01},
  { 8.843458e-01, -4.027382e-02,  4.650919e-01,  4.007961e-01,  1.657283e-01,  7.858053e-01},
  {-5.313759e-01,  1.291033e-01,  8.372407e-01,  1.321625e-01,  2.221892e-01,  8.251991e-01},
  { 9.455173e-01, -1.184021e-01,  3.032788e-01,  4.135630e-01,  7.878609e-02,  7.281733e-01},
  { 9.497597e-01, -9.308805e-02,  2.988160e-01,  4.299818e-01,  1.054905e-01,  6.726676e-01},
  {-6.711829e-01,  6.563164e-02,  7.383806e-01, -1.413180e-01,  1.768490e-01,  6.763937e-01},
  { 9.861254e-01, -1.080045e-01,  1.260621e-01,  4.504762e-01,  1.164185e-01,  5.637738e-01},
  { 9.949552e-01, -9.288859e-02,  3.789289e-02,  4.589212e-01,  1.155029e-01,  4.573547e-01},
  { 9.990686e-01, -4.204554e-02, -9.701007e-03,  4.605222e-01,  1.111926e-01,  3.687726e-01},
  {-8.141287e-01,  2.815891e-01,  5.078406e-01, -3.587202e-01,  1.917439e-01,  3.816626e-01},
  { 9.987945e-01, -1.223690e-02, -4.753717e-02,  4.592330e-01,  1.222691e-01,  3.102593e-01},
  {-9.260413e-01,  4.130270e-02,  3.751554e-01, -3.938796e-01,  9.072788e-02,  3.539400e-01},
  {-9.828776e-01,  5.404687e-02,  1.761550e-01, -4.113727e-01,  1.071092e-01,  2.980838e-01},
  {-9.704448e-01,  1.541464e-01,  1.856766e-01, -4.097854e-01,  1.506181e-01,  2.694963e-01},
  {-9.504424e-01,  1.154592e-01, -2.886664e-01, -4.218675e-01,  5.431319e-02,  1.710766e-01},
  {-8.842105e-01,  2.557817e-01, -3.908294e-01, -1.704386e-01,  2.027642e-01, -1.337223e-01},
  {-5.143079e-01,  4.665920e-01,  7.195689e-01, -3.610706e-01,  1.297273e-01, -2.900994e-01},
  {-8.855889e-01,  4.536099e-01,  9.985188e-02, -1.511175e-01,  2.332364e-01, -2.101355e-01},
  { 9.667158e-01, -1.797927e-01,  1.820308e-01,  4.472044e-01,  1.146723e-01, -3.118614e-01},
  { 8.928191e-01, -1.564444e-01, -4.223732e-01,  4.504408e-01,  1.305531e-01, -3.148924e-01},
  {-8.512458e-01,  4.915813e-01,  1.836530e-01, -1.496565e-01,  2.388948e-01, -2.203721e-01},
  { 9.896610e-01, -7.236674e-02, -1.238319e-01,  4.455866e-01,  1.065633e-01, -3.286784e-01},
  {-8.777322e-01,  3.726861e-01,  3.011497e-01, -4.709315e-01,  5.426026e-02, -3.731221e-01},
  {-8.540992e-01,  4.211704e-01,  3.051722e-01, -4.536518e-01,  9.863538e-02, -3.818753e-01},
  { 9.669338e-01,  1.344989e-01, -2.166774e-01,  4.383563e-01,  7.906152e-02, -3.779108e-01},
  { 9.706556e-01,  2.393980e-01, -2.272488e-02,  4.371273e-01,  7.513019e-02, -3.857626e-01},
  {-8.956169e-01,  4.053230e-01,  1.832581e-01, -4.078665e-01,  2.304207e-01, -4.304190e-01},
  {-9.459757e-01,  3.180492e-01, -6.304645e-02, -4.641066e-01,  8.540329e-02, -4.515373e-01},
  { 3.268903e-01,  1.892029e-01, -9.259292e-01,  2.659062e-01,  1.570293e-01, -4.792162e-01},
  { 3.345276e-01,  1.835654e-01, -9.243349e-01,  2.841913e-01,  1.407518e-01, -4.764208e-01},
  { 5.328406e-01,  1.580840e-01, -8.313184e-01,  1.913305e-01,  1.456728e-01, -5.071849e-01},
  {-9.177074e-01,  2.394029e-01, -3.170166e-01, -4.763728e-01, -2.204498e-02, -5.927348e-01},
  { 5.143015e-01, -4.968362e-02, -8.561691e-01,  1.416861e-01,  1.062863e-01, -5.358218e-01},
  { 6.206552e-01, -5.920010e-02, -7.818455e-01,  1.258904e-01,  9.455041e-02, -5.467317e-01},
  { 6.830569e-01,  3.248262e-01, -6.541569e-01,  4.092888e-01,  4.722516e-02, -4.433080e-01},
  { 4.154867e-01, -2.746787e-01, -8.671346e-01,  1.129448e-01,  8.109909e-02, -5.563416e-01},
  { 3.195817e-01,  3.991204e-01, -8.594012e-01,  3.535580e-01,  7.068433e-02, -4.710689e-01},
  { 7.829096e-01, -4.394735e-02, -6.205813e-01,  1.013696e-01,  9.179286e-02, -5.692564e-01},
  { 5.535018e-01,  1.292368e-01, -8.227598e-01,  3.697708e-01,  3.488785e-02, -4.773099e-01},
  { 2.682777e-01,  1.823556e-01, -9.459246e-01,  3.642940e-01,  3.703951e-02, -4.792973e-01},
  { 9.315348e-01, -1.655680e-02, -3.632752e-01,  7.794920e-02,  1.349122e-01, -6.122416e-01},
  { 4.144446e-01, -4.836061e-01, -7.709480e-01, -2.620406e-02,  3.140766e-02, -7.877271e-01},
  { 9.916799e-01, -6.871951e-02, -1.088515e-01,  6.246851e-02,  1.185466e-01, -6.878653e-01},
  { 4.844383e-01, -1.536705e-01, -8.612229e-01, -4.596978e-02,  5.008421e-02, -8.034858e-01},
  {-7.763782e-01,  2.107026e-01, -5.940046e-01, -3.074236e-01,  2.328622e-01, -7.759879e-01},
  { 7.791057e-01, -1.502751e-01, -6.086146e-01,  1.615412e-02,  9.260882e-02, -7.631314e-01},
  { 8.710371e-01, -1.300209e-01, -4.736969e-01,  4.774816e-02,  1.388371e-01, -7.281228e-01},
  {-1.820609e-01, -1.929982e-01, -9.641606e-01, -2.129644e-01,  6.260931e-02, -8.231369e-01},
  {-7.837963e-01,  1.780968e-01, -5.949328e-01, -3.395219e-01,  1.771280e-01, -7.526891e-01},
  { 1.908689e-02, -2.181332e-01, -9.757323e-01, -1.425763e-01,  6.513352e-02, -8.288214e-01},
  {-6.744266e-01,  1.182602e-01, -7.288095e-01, -2.944531e-01,  1.944121e-01, -7.983137e-01},
  {-4.849586e-01, -1.143910e-01, -8.670235e-01, -2.640409e-01,  1.528572e-01, -8.212646e-01},
  { 4.996464e-01,  2.720046e-02,  8.658023e-01,  3.445204e-01,  1.919824e-01,  8.422783e-01},
  { 7.556639e-01, -5.559704e-02,  6.525958e-01,  3.836153e-01,  1.989755e-01,  8.118345e-01},
  {-1.228488e-01,  4.898369e-02,  9.912158e-01,  2.398159e-01,  2.331343e-01,  8.567016e-01},
  { 9.401472e-01, -1.140082e-01,  3.211314e-01,  4.154014e-01,  1.454973e-01,  7.445002e-01},
  {-6.351964e-01,  1.650677e-01,  7.545052e-01, -1.278721e-01,  2.278285e-01,  6.803322e-01},
  {-6.753143e-01,  1.128411e-01,  7.288467e-01, -1.481374e-01,  2.024847e-01,  6.667116e-01},
  {-5.504041e-01,  1.210059e-01,  8.260828e-01, -9.348448e-02,  1.983239e-01,  7.121122e-01},
  {-5.048168e-01,  1.300018e-01,  8.533812e-01, -4.542739e-02,  1.658127e-01,  7.453122e-01},
  {-7.205192e-01,  5.308100e-02,  6.914003e-01, -1.829815e-01,  1.455296e-01,  6.371660e-01},
  {-7.260067e-01,  4.666975e-02,  6.861023e-01, -2.042034e-01,  1.379433e-01,  6.146487e-01},
  {-8.375698e-01,  7.562032e-02,  5.410716e-01, -2.895946e-01,  1.868429e-01,  4.935960e-01},
  {-8.810508e-01,  1.884331e-01,  4.338692e-01, -3.805486e-01,  1.554552e-01,  3.621623e-01},
  { 9.958520e-01, -1.851829e-02, -8.908358e-02,  4.564359e-01,  1.492122e-01,  2.616738e-01},
  { 9.850444e-01, -1.649393e-01, -4.982463e-02,  4.123383e-01,  1.573563e-01,  2.124276e-02},
  {-9.585161e-01,  4.026724e-02,  2.821797e-01, -4.044873e-01,  1.025823e-01,  3.241863e-01},
  { 9.703215e-01, -2.217344e-01,  9.648881e-02,  4.092031e-01,  1.381118e-01,  3.258621e-03},
  {-9.946522e-01,  1.029178e-01, -8.663284e-03, -4.108585e-01,  1.602987e-01,  2.371608e-01},
  {-9.893837e-01,  1.364283e-01, -5.007286e-02, -4.117868e-01,  1.481530e-01,  2.211720e-01},
  {-6.588157e-01,  1.854353e-01, -7.290924e-01, -2.572119e-01,  2.185003e-01, -1.740926e-02},
  {-9.475605e-01,  1.265528e-01, -2.934507e-01, -4.208688e-01,  5.963513e-02,  1.696640e-01},
  {-9.432156e-01,  1.498189e-01, -2.964770e-01, -4.190150e-01,  6.404854e-02,  1.660796e-01},
  {-8.540495e-01, -6.842448e-03, -5.201468e-01, -3.426304e-01,  1.719826e-01,  6.827638e-02},
  { 9.968178e-01,  9.911846e-03,  7.909569e-02,  4.446362e-01,  1.466405e-01, -2.719404e-01},
  {-6.235981e-01,  4.734694e-01,  6.220548e-01, -3.810024e-01,  1.873568e-01, -3.460775e-01},
  { 8.143235e-01, -6.279033e-02,  5.770048e-01,  4.509144e-01,  1.351208e-01, -3.103599e-01},
  { 9.190351e-01, -3.582307e-01,  1.644547e-01,  4.515355e-01,  1.339931e-01, -3.122663e-01},
  { 9.482333e-01, -2.195493e-01, -2.294599e-01,  4.512164e-01,  1.333136e-01, -3.148640e-01},
  { 9.534140e-01, -2.941707e-01, -6.682197e-02,  4.517483e-01,  1.341995e-01, -3.135622e-01},
  { 7.766384e-01, -5.045711e-02, -6.279226e-01,  4.511394e-01,  1.346438e-01, -3.154998e-01},
  { 6.711937e-01,  4.036930e-03, -7.412710e-01,  4.505770e-01,  1.363557e-01, -3.157719e-01},
  {-7.945397e-01,  4.825956e-01,  3.685215e-01, -3.921328e-01,  2.471633e-01, -4.124568e-01},
  { 9.480929e-01,  8.707647e-02, -3.058389e-01,  4.420783e-01,  1.214642e-01, -3.446475e-01},
  {-6.548538e-01,  6.444619e-01,  3.947599e-01, -1.452856e-01,  2.637393e-01, -2.619972e-01},
  { 9.385077e-01,  1.498086e-01, -3.110637e-01,  4.380046e-01,  1.134424e-01, -3.601145e-01},
  {-8.847236e-01,  4.244055e-01,  1.927279e-01, -3.980051e-01,  2.548918e-01, -4.409563e-01},
  { 9.363750e-01,  3.434102e-01,  7.260352e-02,  4.355783e-01,  8.071671e-02, -3.886349e-01},
  {-4.759695e-01,  7.441945e-01,  4.686444e-01, -1.568000e-01,  2.703601e-01, -2.878107e-01},
  {-9.713865e-01,  2.244552e-01, -7.764123e-02, -4.007904e-01,  2.524144e-01, -4.545794e-01},
  { 4.157431e-01,  2.407023e-01, -8.770519e-01,  3.079202e-01,  1.578065e-01, -4.633468e-01},
  { 4.611157e-01,  6.693616e-02, -8.848118e-01,  1.766606e-01,  1.439722e-01, -5.141696e-01},
  { 6.761956e-01,  3.449469e-01, -6.509769e-01,  4.073495e-01,  7.643787e-02, -4.300833e-01},
  { 3.871906e-01,  2.832403e-01, -8.774157e-01,  3.419454e-01,  1.089254e-01, -4.631341e-01},
  { 4.016177e-01,  3.040904e-01, -8.638474e-01,  3.485367e-01,  1.037517e-01, -4.619219e-01},
  { 5.746306e-01,  1.245588e-01, -8.088787e-01,  1.236446e-01,  1.127166e-01, -5.491347e-01},
  { 5.936601e-01,  2.999976e-01, -7.467055e-01,  3.750845e-01,  5.512854e-02, -4.666632e-01},
  { 7.917215e-01, -5.657393e-02, -6.082569e-01,  9.941883e-02,  1.107971e-01, -5.732884e-01},
  { 4.597774e-01,  2.421213e-01, -8.543898e-01,  3.698646e-01,  3.935667e-02, -4.767551e-01},
  {-8.457305e-01,  2.308060e-01, -4.811117e-01, -4.132181e-01,  5.859935e-02, -6.750452e-01},
  { 9.661807e-01, -7.237438e-02, -2.475013e-01,  6.341948e-02,  1.324895e-01, -6.895198e-01},
  {-7.851514e-01,  2.934868e-01, -5.453466e-01, -3.037042e-01,  2.529471e-01, -7.716773e-01},
  { 6.103528e-01, -2.003730e-01, -7.663682e-01, -1.503706e-02,  6.467440e-02, -7.866237e-01},
  {-8.617502e-01,  2.425691e-01, -4.455858e-01, -3.868384e-01,  1.041367e-01, -7.009383e-01},
  {-7.275248e-01,  2.153565e-01, -6.514056e-01, -2.965773e-01,  2.368837e-01, -7.873917e-01},
  {-6.706634e-01,  1.410682e-01, -7.282242e-01, -2.854815e-01,  2.207437e-01, -8.019881e-01},
  { 8.048101e-02, -2.272826e-01, -9.704974e-01, -1.348171e-01,  9.245871e-02, -8.345706e-01},
  { 1.781265e-01, -2.369244e-01, -9.550591e-01, -9.814624e-02,  1.164439e-01, -8.356243e-01},
  {-6.389409e-01,  1.953163e-03, -7.692534e-01, -2.772163e-01,  1.848728e-01, -8.134908e-01},
  {-3.022421e-01, -1.434633e-01, -9.423736e-01, -2.330950e-01,  1.493387e-01, -8.332022e-01},
  {-5.542027e-01, -1.537279e-01, -8.180630e-01, -2.640209e-01,  1.672289e-01, -8.235725e-01},
  {-4.857528e-01, -4.886371e-02, -8.727294e-01, -2.638327e-01,  1.748821e-01, -8.253652e-01},
  { 4.427955e-01, -2.834554e-02,  8.961745e-01,  3.347850e-01,  2.206225e-01,  8.466060e-01},
  { 2.070709e-01,  5.057253e-03,  9.783128e-01,  3.089625e-01,  2.357993e-01,  8.544159e-01},
  { 7.998408e-01, -5.474193e-02,  5.977106e-01,  3.901931e-01,  2.091345e-01,  8.044094e-01},
  { 1.088561e-01,  3.889508e-02,  9.932962e-01,  2.916288e-01,  2.608428e-01,  8.567932e-01},
  {-7.446592e-02,  5.431499e-02,  9.957433e-01,  2.563644e-01,  2.647342e-01,  8.570141e-01},
  { 8.795148e-01, -4.450783e-02,  4.737856e-01,  4.066109e-01,  2.024241e-01,  7.770578e-01},
  {-6.365136e-01,  2.232610e-01,  7.382446e-01, -1.139394e-01,  2.969154e-01,  6.729240e-01},
  {-6.728776e-01,  1.657812e-01,  7.209384e-01, -1.612943e-01,  2.350623e-01,  6.481128e-01},
  { 9.788808e-01, -8.756794e-02,  1.847283e-01,  4.490392e-01,  1.489844e-01,  6.003167e-01},
  {-9.251533e-01,  1.397808e-01,  3.529204e-01, -3.947396e-01,  1.329677e-01,  3.380506e-01},
  {-9.349725e-01,  1.693711e-01,  3.116726e-01, -3.950765e-01,  1.656960e-01,  3.219213e-01},
  {-9.424301e-01,  2.219704e-01,  2.501090e-01, -3.981382e-01,  1.854822e-01,  2.970656e-01},
  {-9.826669e-01,  1.620541e-01,  9.002467e-02, -4.068904e-01,  1.875311e-01,  2.461089e-01},
  {-9.776133e-01,  1.634403e-01, -1.325127e-01, -4.094137e-01,  1.605969e-01,  2.106561e-01},
  {-9.340211e-01,  2.872219e-01, -2.123874e-01, -4.176564e-01,  9.129377e-02,  1.799875e-01},
  {-8.868662e-01,  1.576283e-01, -4.343059e-01, -3.890624e-01,  1.368331e-01,  1.286866e-01},
  {-9.011707e-01,  1.649790e-01, -4.008407e-01, -4.120267e-01,  8.471454e-02,  1.568401e-01},
  {-8.465822e-01,  1.470022e-01, -5.115554e-01, -3.704527e-01,  1.734707e-01,  1.079599e-01},
  {-8.546984e-01,  1.569044e-01, -4.948452e-01, -3.783349e-01,  1.663068e-01,  1.188359e-01},
  { 9.797890e-01,  5.535970e-03,  1.999577e-01,  4.360262e-01,  1.576412e-01, -1.804675e-01},
  {-8.939250e-01,  2.708527e-01, -3.571233e-01, -1.547393e-01,  2.476150e-01, -1.394429e-01},
  { 9.963626e-01,  2.077149e-03,  8.519039e-02,  4.417221e-01,  1.639562e-01, -2.273819e-01},
  {-9.321736e-01,  3.351657e-01, -1.368073e-01, -1.560098e-01,  2.189709e-01, -1.613705e-01},
  {-5.087590e-01,  4.804313e-01,  7.143878e-01, -3.537123e-01,  1.796079e-01, -3.177570e-01},
  {-9.273241e-01,  3.594871e-01, -1.041104e-01, -1.474329e-01,  2.395449e-01, -1.760095e-01},
  { 8.774860e-01, -8.440831e-02,  4.721161e-01,  4.514995e-01,  1.350261e-01, -3.110914e-01},
  { 9.428647e-01,  6.454234e-02,  3.268645e-01,  4.516144e-01,  1.351931e-01, -3.115333e-01},
  { 9.765783e-01, -1.136371e-01,  1.827061e-01,  4.517733e-01,  1.347259e-01, -3.120013e-01},
  { 9.702100e-01,  7.313915e-02,  2.309614e-01,  4.520864e-01,  1.364077e-01, -3.116414e-01},
  { 9.898442e-01, -1.137584e-01,  8.524897e-02,  4.518006e-01,  1.350439e-01, -3.126634e-01},
  { 9.777526e-01,  1.235327e-01,  1.695277e-01,  4.498819e-01,  1.394014e-01, -3.085690e-01},
  { 8.758414e-01,  4.179748e-01,  2.412444e-01,  4.507665e-01,  1.375193e-01, -3.105376e-01},
  { 9.968463e-01, -7.280922e-02, -3.156262e-02,  4.519520e-01,  1.347095e-01, -3.132999e-01},
  { 9.299821e-01,  2.496596e-01, -2.698212e-01,  4.512933e-01,  1.362245e-01, -3.145303e-01},
  {-8.236154e-01,  5.442743e-01,  1.594461e-01, -1.347433e-01,  2.689162e-01, -2.397186e-01},
  { 9.328078e-01,  1.779113e-01, -3.133962e-01,  4.458407e-01,  1.477162e-01, -3.221847e-01},
  {-9.295204e-01,  3.511894e-01,  1.125079e-01, -4.730656e-01,  6.517353e-02, -3.949299e-01},
  {-5.504308e-01,  5.986335e-01,  5.819483e-01, -1.738472e-01,  2.639869e-01, -2.951456e-01},
  {-8.854268e-01,  4.470445e-01,  1.271632e-01, -3.917381e-01,  2.724155e-01, -4.535790e-01},
  {-9.369551e-01,  3.381345e-01,  8.820555e-02, -4.166711e-01,  2.083239e-01, -4.348884e-01},
  { 3.737120e-01,  2.442484e-01, -8.948084e-01,  2.782296e-01,  2.105050e-01, -4.613246e-01},
  { 3.870120e-01,  2.679659e-01, -8.822789e-01,  2.956554e-01,  1.899434e-01, -4.596122e-01},
  {-5.813142e-01,  5.326454e-01,  6.151120e-01, -1.573734e-01,  2.761163e-01, -2.953619e-01},
  { 6.757053e-01,  1.526990e-01, -7.211834e-01,  1.873465e-01,  1.852836e-01, -5.028526e-01},
  { 4.624381e-01,  2.866986e-01, -8.390202e-01,  3.373266e-01,  1.527870e-01, -4.504671e-01},
  {-9.048557e-01,  4.256263e-01,  8.854088e-03, -3.930345e-01,  2.716650e-01, -4.681369e-01},
  {-9.780399e-01,  1.392056e-01, -1.551125e-01, -3.975623e-01,  2.600116e-01, -4.682993e-01},
  { 5.254762e-01,  3.395687e-01, -7.801076e-01,  3.654993e-01,  1.265184e-01, -4.433962e-01},
  { 5.368427e-01,  3.134522e-01, -7.832928e-01,  3.724222e-01,  1.003692e-01, -4.501142e-01},
  { 6.104141e-01,  3.243333e-01, -7.226357e-01,  3.832323e-01,  9.381602e-02, -4.444754e-01},
  {-8.790267e-01,  2.658990e-01, -3.957396e-01, -4.118425e-01,  9.669560e-02, -6.544694e-01},
  {-7.585785e-01,  3.024392e-01, -5.771388e-01, -2.935238e-01,  2.638620e-01, -7.800072e-01},
  {-8.327667e-01,  2.894681e-01, -4.719195e-01, -3.229224e-01,  2.319552e-01, -7.529804e-01},
  { 9.994922e-01, -1.856372e-02, -2.590189e-02,  6.371581e-02,  1.491961e-01, -6.897509e-01},
  {-8.518627e-01,  2.497252e-01, -4.603992e-01, -3.458316e-01,  1.923786e-01, -7.350376e-01},
  { 8.924354e-01, -1.124772e-01, -4.369300e-01,  4.686263e-02,  1.591277e-01, -7.348315e-01},
  { 8.044488e-01, -1.475683e-01, -5.754004e-01,  3.243497e-02,  1.459118e-01, -7.556975e-01},
  { 3.507686e-01, -2.146387e-01, -9.115326e-01, -6.053402e-02,  9.785348e-02, -8.212487e-01},
  {-1.849075e-01, -1.943362e-01, -9.633497e-01, -1.977784e-01,  9.613105e-02, -8.321418e-01},
  { 1.896625e-01, -2.357960e-01, -9.531150e-01, -9.967649e-02,  1.403031e-01, -8.419837e-01},
  { 1.950811e-01, -2.489953e-01, -9.486541e-01, -9.552227e-02,  1.585448e-01, -8.460062e-01},
  { 3.671839e-01, -7.791969e-03,  9.301158e-01,  3.322117e-01,  2.365090e-01,  8.477906e-01},
  {-2.340837e-01,  8.642275e-02,  9.683676e-01,  2.117568e-01,  2.560053e-01,  8.495916e-01},
  {-1.742757e-01, -2.356273e-02,  9.844150e-01,  2.286164e-01,  2.644655e-01,  8.525052e-01},
  {-1.519489e-01, -6.674821e-02,  9.861320e-01,  2.335776e-01,  2.695056e-01,  8.545297e-01},
  {-1.160069e-01,  2.440910e-02,  9.929484e-01,  2.559966e-01,  2.773314e-01,  8.560149e-01},
  { 9.486831e-01, -5.602393e-02,  3.112260e-01,  4.197417e-01,  1.911708e-01,  7.393556e-01},
  {-6.870538e-01,  2.378695e-01,  6.865677e-01, -1.639611e-01,  2.705728e-01,  6.355758e-01},
  {-4.785111e-01,  1.610568e-01,  8.631847e-01, -1.685789e-02,  2.249787e-01,  7.512529e-01},
  {-7.178025e-01,  1.005773e-01,  6.889440e-01, -1.704312e-01,  2.056544e-01,  6.443651e-01},
  { 9.824231e-01, -8.006462e-02,  1.686254e-01,  4.572245e-01,  1.862760e-01,  5.698887e-01},
  {-8.969485e-01,  1.701350e-01,  4.080902e-01, -3.822107e-01,  1.857733e-01,  3.432726e-01},
  {-8.693765e-01,  3.296516e-01,  3.681227e-01, -3.821933e-01,  2.048045e-01,  3.293681e-01},
  {-9.456091e-01,  1.296721e-01,  2.983430e-01, -3.889317e-01,  1.898350e-01,  3.242714e-01},
  {-9.541843e-01,  2.100595e-01,  2.130900e-01, -3.951169e-01,  2.098253e-01,  2.869171e-01},
  {-9.639574e-01,  2.038986e-01, -1.709138e-01, -4.070865e-01,  1.556928e-01,  1.908026e-01},
  {-9.298474e-01,  1.891035e-01, -3.156320e-01, -3.962491e-01,  1.633710e-01,  1.544279e-01},
  {-8.011798e-01,  1.797186e-01, -5.707996e-01, -1.802518e-01,  2.497457e-01, -9.531217e-02},
  {-8.450040e-01,  2.445007e-01, -4.755918e-01, -1.574288e-01,  2.577047e-01, -1.272762e-01},
  {-8.054163e-01,  4.869894e-02, -5.907056e-01, -3.575964e-01,  2.197961e-01,  9.894366e-02},
  {-9.138418e-01,  2.951821e-01, -2.788560e-01, -1.397389e-01,  2.719996e-01, -1.590659e-01},
  {-9.157796e-01,  3.865970e-01, -1.090430e-01, -1.353350e-01,  2.658139e-01, -1.899007e-01},
  { 9.939942e-01,  1.073212e-01,  2.139175e-02,  4.466522e-01,  1.552048e-01, -2.954539e-01},
  {-8.208237e-01,  5.540673e-01,  1.387727e-01, -1.279966e-01,  2.819071e-01, -2.502331e-01},
  {-6.955675e-01,  4.996425e-01,  5.162783e-01, -3.789468e-01,  2.474522e-01, -3.925557e-01},
  {-7.838311e-01,  5.201103e-01,  3.392553e-01, -3.849182e-01,  2.730577e-01, -4.328484e-01},
  {-9.111719e-01,  4.006977e-01,  9.595364e-02, -4.308217e-01,  1.714236e-01, -4.261147e-01},
  { 8.549745e-01,  2.630630e-01, -4.470082e-01,  4.357876e-01,  1.499053e-01, -3.453981e-01},
  {-6.457752e-01,  6.012734e-01,  4.705792e-01, -1.369472e-01,  2.857038e-01, -2.849488e-01},
  {-3.318375e-01,  6.839079e-01,  6.497337e-01, -1.771765e-01,  2.722999e-01, -3.061796e-01},
  { 8.564007e-01,  3.584498e-01, -3.716067e-01,  4.310154e-01,  8.914327e-02, -3.922122e-01},
  { 7.720322e-01,  3.134093e-01, -5.529384e-01,  4.248529e-01,  1.154874e-01, -3.847772e-01},
  {-9.352266e-01,  3.490570e-01, -5.924741e-02, -4.506814e-01,  1.194221e-01, -4.663777e-01},
  { 7.922668e-01,  2.423474e-01, -5.599831e-01,  4.348880e-01,  8.083789e-02, -3.927168e-01},
  { 5.515138e-01,  2.072308e-01, -8.080148e-01,  1.851824e-01,  2.046777e-01, -4.995199e-01},
  {-9.376318e-01,  3.472479e-01,  1.629710e-02, -4.066649e-01,  2.365036e-01, -4.583214e-01},
  { 6.097741e-01,  3.256295e-01, -7.225932e-01,  3.595261e-01,  1.707750e-01, -4.280353e-01},
  { 6.644202e-01,  3.243271e-01, -6.733184e-01,  3.884056e-01,  1.248640e-01, -4.244689e-01},
  {-7.223935e-01,  3.447852e-01, -5.993921e-01, -2.810775e-01,  2.885118e-01, -7.824891e-01},
  {-8.417110e-01,  2.666002e-01, -4.695178e-01, -3.428372e-01,  2.060594e-01, -7.325202e-01},
  { 9.795540e-01, -6.057280e-02, -1.918458e-01,  6.184693e-02,  1.717959e-01, -7.023825e-01},
  { 5.128860e-01, -2.076954e-01, -8.329529e-01, -3.488072e-02,  8.542284e-02, -8.062446e-01},
  { 6.442446e-01, -1.789344e-01, -7.435936e-01, -1.242061e-02,  1.089042e-01, -7.956964e-01},
  {-6.687604e-01,  2.589258e-01, -6.969340e-01, -2.782584e-01,  2.678126e-01, -7.956066e-01},
  { 6.954088e-01, -1.547968e-01, -7.017439e-01,  5.408232e-03,  1.263621e-01, -7.834730e-01},
  {-6.182994e-01,  1.703176e-01, -7.672666e-01, -2.681265e-01,  2.505490e-01, -8.104646e-01},
  {-5.158894e-02, -2.104025e-01, -9.762527e-01, -1.657017e-01,  9.983905e-02, -8.364760e-01},
  { 3.135808e-01, -2.280591e-01, -9.217680e-01, -6.573679e-02,  1.214631e-01, -8.288293e-01},
  {-1.547220e-01, -1.659682e-01, -9.739177e-01, -1.889489e-01,  1.535324e-01, -8.439088e-01},
  {-5.778793e-01,  1.105307e-01, -8.086028e-01, -2.630365e-01,  1.972841e-01, -8.238012e-01},
  { 2.355804e-01, -2.648902e-01, -9.350589e-01, -7.258144e-02,  1.979876e-01, -8.517352e-01},
  { 1.903956e-01, -2.644055e-01, -9.454307e-01, -7.428417e-02,  2.139508e-01, -8.568938e-01},
  { 1.522674e-01, -2.291376e-01, -9.614107e-01, -9.264261e-02,  1.838028e-01, -8.518452e-01},
  { 9.935647e-02, -1.229001e-01, -9.874330e-01, -7.566439e-02,  2.257615e-01, -8.603028e-01},
  { 7.456735e-01, -2.952249e-02,  6.656572e-01,  3.815184e-01,  2.465330e-01,  8.170737e-01},
  { 8.577589e-01, -1.624216e-02,  5.137956e-01,  3.959154e-01,  2.574432e-01,  7.980097e-01},
  {-4.794575e-02,  9.307742e-02,  9.945037e-01,  2.689823e-01,  2.960196e-01,  8.558930e-01},
  { 9.338825e-01, -2.592918e-02,  3.566386e-01,  4.159940e-01,  2.246165e-01,  7.563568e-01},
  {-5.490503e-01,  1.888915e-01,  8.141644e-01, -6.389838e-02,  3.380357e-01,  7.003049e-01},
  {-5.331065e-01,  1.944729e-01,  8.233941e-01, -6.938128e-02,  2.990223e-01,  7.056666e-01},
  {-5.787315e-01,  1.867897e-01,  7.938384e-01, -9.431398e-02,  2.640031e-01,  6.980416e-01},
  {-5.054057e-01,  1.756910e-01,  8.448064e-01, -6.777528e-02,  2.498499e-01,  7.183214e-01},
  {-8.251690e-01,  8.034595e-02,  5.591427e-01, -2.649571e-01,  1.836590e-01,  5.356256e-01},
  {-7.884332e-01,  6.294466e-02,  6.118913e-01, -2.410774e-01,  1.831479e-01,  5.695401e-01},
  {-8.837190e-01,  1.594383e-01,  4.400228e-01, -2.798524e-01,  2.028239e-01,  5.075745e-01},
  {-8.537195e-01,  2.929286e-01,  4.305297e-01, -2.931614e-01,  3.265779e-01,  4.212593e-01},
  {-8.365405e-01,  3.166810e-01,  4.471164e-01, -3.612857e-01,  2.455931e-01,  3.420344e-01},
  {-9.353701e-01,  7.663148e-02,  3.452687e-01, -3.861369e-01,  1.888771e-01,  3.335003e-01},
  {-8.627236e-01,  3.656468e-01,  3.492998e-01, -3.905196e-01,  2.362617e-01,  2.809514e-01},
  {-9.752243e-01,  2.002201e-01,  9.407185e-02, -4.039106e-01,  2.080119e-01,  2.378402e-01},
  {-9.876379e-01,  1.454448e-01, -5.845614e-02, -4.052976e-01,  2.023842e-01,  2.149981e-01},
  {-9.717994e-01,  5.507710e-02, -2.292867e-01, -4.044301e-01,  1.946706e-01,  2.038128e-01},
  {-7.395273e-01,  1.668151e-01, -6.521288e-01, -1.916507e-01,  2.849716e-01, -7.057723e-02},
  {-9.069130e-01,  1.738405e-01, -3.837816e-01, -3.898377e-01,  1.898486e-01,  1.509463e-01},
  {-9.063248e-01,  7.958490e-02, -4.150201e-01, -3.871024e-01,  2.106415e-01,  1.523773e-01},
  {-5.095536e-01,  4.880034e-01,  7.086663e-01, -3.450501e-01,  1.962140e-01, -3.231644e-01},
  { 9.914528e-01,  1.295079e-01,  1.577767e-02,  4.433902e-01,  1.767203e-01, -2.745639e-01},
  {-8.907082e-01,  4.505665e-01, -6.023917e-02, -1.233085e-01,  2.876526e-01, -2.123877e-01},
  { 9.900408e-01,  1.405804e-01,  7.508976e-03,  4.455911e-01,  1.629469e-01, -2.933522e-01},
  {-6.414160e-01,  4.788537e-01,  5.994035e-01, -3.754338e-01,  2.359252e-01, -3.780417e-01},
  { 9.711467e-01,  1.940751e-01, -1.385962e-01,  4.441525e-01,  1.637667e-01, -3.140691e-01},
  {-9.083614e-01,  3.947190e-01,  1.381175e-01, -4.644405e-01,  8.655165e-02, -4.024328e-01},
  {-9.140882e-01,  3.908568e-01,  1.080447e-01, -4.540110e-01,  1.145082e-01, -4.190601e-01},
  { 7.612389e-01,  3.263577e-01, -5.603625e-01,  4.127840e-01,  1.612431e-01, -3.760048e-01},
  { 3.619165e-01,  3.364282e-01, -8.693863e-01,  2.007806e-01,  2.355381e-01, -4.848598e-01},
  {-8.154160e-01,  5.423033e-01,  2.024941e-01, -3.838918e-01,  2.858501e-01, -4.541303e-01},
  { 4.806350e-01,  2.875424e-01, -8.284379e-01,  3.103449e-01,  2.214947e-01, -4.420513e-01},
  { 7.016355e-01,  3.323683e-01, -6.302689e-01,  3.992681e-01,  1.447128e-01, -4.023839e-01},
  {-8.588045e-01,  5.108560e-01,  3.848187e-02, -3.844147e-01,  2.889785e-01, -4.692629e-01},
  { 6.117507e-01,  3.482635e-01, -7.102631e-01,  3.757208e-01,  1.463977e-01, -4.256872e-01},
  { 5.628065e-01,  3.136183e-01, -7.647825e-01,  3.423443e-01,  2.043390e-01, -4.271007e-01},
  {-9.381540e-01,  3.138773e-01, -1.461099e-01, -3.848679e-01,  2.802087e-01, -5.094271e-01},
  {-9.237596e-01,  2.978123e-01, -2.407822e-01, -4.421896e-01,  1.118918e-01, -5.447636e-01},
  { 9.827824e-01,  7.614808e-02, -1.683453e-01,  9.532945e-02,  1.624327e-01, -5.779028e-01},
  {-8.919827e-01,  2.647012e-01, -3.664697e-01, -4.002323e-01,  1.545642e-01, -6.415107e-01},
  {-6.160465e-01,  2.878972e-01, -7.332134e-01, -2.587864e-01,  2.952761e-01, -8.034171e-01},
  {-6.509303e-01,  2.660901e-01, -7.109752e-01, -2.627890e-01,  2.866303e-01, -8.030923e-01},
  { 7.013193e-01, -1.677858e-01, -6.928198e-01,  1.120388e-02,  1.594840e-01, -7.853401e-01},
  { 8.369197e-01, -1.152040e-01, -5.350640e-01,  3.663418e-02,  1.875091e-01, -7.591442e-01},
  { 2.640115e-02, -2.224975e-01, -9.745758e-01, -1.261503e-01,  1.578935e-01, -8.489990e-01},
  {-2.860332e-01, -5.553316e-02, -9.566092e-01, -2.168592e-01,  1.866310e-01, -8.414270e-01},
  { 7.761866e-01,  5.450040e-02,  6.281434e-01,  3.840378e-01,  2.743038e-01,  8.146753e-01},
  { 3.289352e-01,  8.142320e-02,  9.408358e-01,  3.434228e-01,  2.721044e-01,  8.435734e-01},
  { 2.327576e-01, -2.191760e-03,  9.725323e-01,  3.176950e-01,  2.985193e-01,  8.508957e-01},
  { 8.687961e-01, -7.007922e-03,  4.951205e-01,  4.060204e-01,  2.845939e-01,  7.817658e-01},
  { 5.526156e-02,  1.549878e-02,  9.983516e-01,  2.933317e-01,  3.086085e-01,  8.544624e-01},
  { 9.343076e-01, -4.124523e-02,  3.540737e-01,  4.167437e-01,  2.600401e-01,  7.561339e-01},
  {-4.397779e-02,  3.138188e-02,  9.985395e-01,  2.715999e-01,  3.201354e-01,  8.539796e-01},
  { 9.626921e-01, -4.825636e-02,  2.662618e-01,  4.280231e-01,  2.073817e-01,  7.134930e-01},
  {-4.711011e-01,  1.705991e-01,  8.654245e-01,  2.466268e-03,  3.120739e-01,  7.446207e-01},
  { 9.945292e-01, -8.913337e-02,  5.446908e-02,  4.674750e-01,  2.109264e-01,  4.569338e-01},
  {-8.217705e-01,  3.418818e-01,  4.558617e-01, -2.423345e-01,  4.088000e-01,  4.611835e-01},
  {-8.529871e-01,  3.373207e-01,  3.982809e-01, -2.672816e-01,  4.145746e-01,  4.060376e-01},
  { 9.917817e-01, -4.987702e-02, -1.178197e-01,  4.588493e-01,  2.205269e-01,  2.588592e-01},
  { 9.827880e-01, -5.527754e-02, -1.762733e-01,  4.365758e-01,  2.228343e-01,  1.205766e-01},
  {-6.657903e-01,  5.931040e-02, -7.437779e-01, -2.793381e-01,  2.878954e-01,  1.611306e-02},
  {-9.464045e-01,  4.475072e-03, -3.229527e-01, -3.921400e-01,  2.081934e-01,  1.649939e-01},
  {-7.516394e-01, -1.169571e-02, -6.594706e-01, -3.243869e-01,  2.547713e-01,  5.967894e-02},
  { 9.929815e-01,  7.926130e-02,  8.777995e-02,  4.381978e-01,  2.028046e-01, -2.078314e-01},
  {-9.148834e-01,  2.826725e-01, -2.882441e-01, -1.339277e-01,  2.991319e-01, -1.504085e-01},
  { 9.652311e-01,  2.268119e-01, -1.299431e-01,  4.427900e-01,  1.724641e-01, -3.098726e-01},
  { 8.691456e-01,  1.907997e-01, -4.562689e-01,  4.367669e-01,  1.763848e-01, -3.294445e-01},
  {-9.198767e-01,  3.850562e-01,  7.455590e-02, -4.405776e-01,  1.484928e-01, -4.272389e-01},
  {-7.014077e-01,  6.713490e-01,  2.394111e-01, -1.217706e-01,  3.030957e-01, -2.887609e-01},
  {-9.234496e-01,  3.805038e-01,  4.957414e-02, -4.299099e-01,  1.760481e-01, -4.422722e-01},
  { 7.576552e-01,  3.242798e-01, -5.663931e-01,  3.988073e-01,  1.817631e-01, -3.828024e-01},
  { 3.837918e-01,  2.888348e-01, -8.770851e-01,  2.550575e-01,  2.784930e-01, -4.506362e-01},
  { 3.671840e-01,  3.966183e-01, -8.413500e-01,  1.750743e-01,  2.374113e-01, -4.947552e-01},
  { 6.798288e-01,  3.273804e-01, -6.562429e-01,  3.743537e-01,  1.915273e-01, -4.047901e-01},
  {-9.325573e-01,  3.447659e-01, -1.071133e-01, -4.358730e-01,  1.534990e-01, -4.866545e-01},
  { 6.000128e-01,  3.184057e-01, -7.338953e-01,  3.374059e-01,  2.256161e-01, -4.222347e-01},
  { 5.792295e-01,  2.996896e-01, -7.580761e-01,  1.492169e-01,  2.355552e-01, -5.088305e-01},
  {-8.540568e-01,  5.200968e-01,  9.294056e-03, -3.759978e-01,  3.024248e-01, -4.834546e-01},
  {-8.666441e-01,  4.949862e-01, -6.258389e-02, -3.753793e-01,  3.007938e-01, -5.079033e-01},
  { 8.267598e-01,  3.814396e-02, -5.612605e-01,  9.905340e-02,  1.884883e-01, -5.676811e-01},
  { 9.623578e-01,  4.854994e-02, -2.674143e-01,  6.973243e-02,  2.040662e-01, -6.283317e-01},
  {-7.342790e-01,  3.385929e-01, -5.883784e-01, -2.690203e-01,  3.164918e-01, -7.811460e-01},
  { 9.817592e-01, -1.480353e-01, -1.193080e-01,  6.369291e-02,  1.923638e-01, -7.041831e-01},
  {-8.859711e-01,  2.533737e-01, -3.884032e-01, -3.823518e-01,  1.776379e-01, -6.680151e-01},
  { 8.824837e-01, -9.912808e-02, -4.597784e-01,  6.152055e-02,  1.932775e-01, -7.126042e-01},
  { 5.333294e-01, -1.907789e-01, -8.241136e-01, -2.954433e-02,  1.173942e-01, -8.107243e-01},
  { 8.135300e-01, -1.563228e-01, -5.601180e-01,  6.227951e-02,  1.987722e-01, -7.128301e-01},
  { 9.860098e-01,  1.666369e-01,  4.125995e-03,  6.289383e-02,  2.024989e-01, -6.875566e-01},
  { 7.361056e-01, -1.509292e-01, -6.598250e-01,  1.203013e-02,  1.777870e-01, -7.886423e-01},
  { 3.604127e-01, -2.330742e-01, -9.032049e-01, -5.386987e-02,  1.414850e-01, -8.295002e-01},
  { 3.734806e-01, -2.525064e-01, -8.926101e-01, -5.749404e-02,  1.824480e-01, -8.420280e-01},
  {-5.829581e-01,  1.073201e-01, -8.053833e-01, -2.539493e-01,  2.268009e-01, -8.260197e-01},
  { 3.841771e-01, -2.432484e-01, -8.906391e-01, -6.277765e-02,  2.152921e-01, -8.537577e-01},
  {-4.810367e-01,  5.666183e-02, -8.748674e-01, -2.499985e-01,  2.024984e-01, -8.306464e-01},
  {-2.256929e-01, -7.569993e-02, -9.712529e-01, -1.787421e-01,  2.084860e-01, -8.530709e-01},
  { 6.431911e-01,  1.985819e-01,  7.395069e-01,  3.748055e-01,  2.744234e-01,  8.256019e-01},
  { 4.650369e-01,  3.218816e-01,  8.247017e-01,  3.624484e-01,  2.724463e-01,  8.357559e-01},
  { 5.949874e-01,  6.653869e-02,  8.009760e-01,  3.633722e-01,  2.899632e-01,  8.326194e-01},
  { 5.406177e-01,  7.491691e-02,  8.379260e-01,  3.650966e-01,  3.036430e-01,  8.303636e-01},
  { 4.222774e-01,  4.932190e-02,  9.051238e-01,  3.488960e-01,  2.995416e-01,  8.401079e-01},
  {-2.662588e-01,  1.242502e-01,  9.558598e-01,  2.044210e-01,  2.898787e-01,  8.434700e-01},
  { 3.935016e-01,  4.425333e-02,  9.182582e-01,  3.393793e-01,  3.066489e-01,  8.439851e-01},
  { 8.258232e-01,  1.693141e-02,  5.636749e-01,  3.977436e-01,  3.108549e-01,  7.945861e-01},
  { 3.851866e-01,  5.159952e-02,  9.213951e-01,  3.402800e-01,  3.188465e-01,  8.430666e-01},
  {-1.561504e-01,  9.794780e-02,  9.828648e-01,  2.441930e-01,  3.130562e-01,  8.509064e-01},
  { 9.276925e-01,  4.650046e-02,  3.704381e-01,  4.136416e-01,  3.063615e-01,  7.664841e-01},
  { 1.004744e-01,  7.213827e-02,  9.923210e-01,  2.951069e-01,  3.313634e-01,  8.526530e-01},
  {-7.126492e-01,  2.872261e-01,  6.400253e-01, -1.505246e-01,  3.550715e-01,  6.164446e-01},
  {-4.882153e-01,  1.667625e-01,  8.566424e-01, -7.514276e-03,  3.396129e-01,  7.342486e-01},
  {-7.159667e-01,  1.526905e-01,  6.812322e-01, -1.958100e-01,  2.518357e-01,  6.089012e-01},
  {-7.448744e-01,  7.369104e-02,  6.631228e-01, -2.223118e-01,  2.019846e-01,  5.900012e-01},
  {-8.446736e-01,  3.003747e-01,  4.430594e-01, -2.684872e-01,  3.464338e-01,  4.556999e-01},
  { 9.970387e-01, -7.004204e-02, -3.174943e-02,  4.689432e-01,  2.316756e-01,  3.861813e-01},
  { 9.866967e-01, -6.902856e-02, -1.471891e-01,  4.587525e-01,  2.619310e-01,  2.364322e-01},
  {-8.839873e-01,  2.975431e-01,  3.606030e-01, -3.750453e-01,  2.641841e-01,  2.988758e-01},
  {-9.224246e-01,  3.018547e-01,  2.408664e-01, -3.907758e-01,  2.428116e-01,  2.726545e-01},
  {-9.694554e-01,  1.536199e-01, -1.911995e-01, -4.013716e-01,  2.121500e-01,  1.993590e-01},
  {-8.928640e-01,  2.840654e-01, -3.494289e-01, -1.296186e-01,  3.137503e-01, -1.497847e-01},
  {-9.047274e-01,  3.625849e-01, -2.236079e-01, -1.141621e-01,  3.194360e-01, -1.877503e-01},
  { 9.940739e-01,  1.031417e-01, -3.433479e-02,  4.375357e-01,  2.127274e-01, -2.631376e-01},
  {-5.010059e-01,  4.866880e-01,  7.156311e-01, -3.436989e-01,  2.243821e-01, -3.409724e-01},
  {-8.652837e-01,  4.935040e-01, -8.796668e-02, -1.046263e-01,  3.189401e-01, -2.431690e-01},
  {-7.962565e-01,  6.015678e-01,  6.396697e-02, -1.042520e-01,  3.190168e-01, -2.646636e-01},
  { 6.637979e-01,  3.563141e-01, -6.575810e-01,  4.334026e-01,  1.843033e-01, -3.310763e-01},
  { 7.153088e-01,  1.215040e-01, -6.881644e-01,  4.360709e-01,  1.834069e-01, -3.286539e-01},
  { 9.668722e-01,  6.422641e-02, -2.470486e-01,  4.374931e-01,  1.844413e-01, -3.263607e-01},
  { 7.993719e-01,  5.535463e-01, -2.336470e-01,  4.372799e-01,  1.861496e-01, -3.253442e-01},
  { 7.908328e-01,  3.511422e-01, -5.012810e-01,  4.152399e-01,  1.988853e-01, -3.493248e-01},
  { 3.291742e-01,  3.220717e-01, -8.876453e-01,  2.225086e-01,  2.779071e-01, -4.633017e-01},
  { 8.164837e-01,  5.475619e-01, -1.831125e-01,  4.372229e-01,  1.858532e-01, -3.264445e-01},
  { 9.100484e-01,  1.372695e-01, -3.911127e-01,  4.374141e-01,  1.850829e-01, -3.272483e-01},
  { 4.860178e-01,  3.096222e-01, -8.172642e-01,  3.098976e-01,  2.549742e-01, -4.301128e-01},
  {-6.131364e-01,  7.247828e-01,  3.142510e-01, -1.188685e-01,  3.168646e-01, -3.121539e-01},
  { 5.104898e-01,  3.251465e-01, -7.960402e-01,  1.494074e-01,  2.507302e-01, -5.029423e-01},
  {-4.644556e-01,  7.153064e-01,  5.221280e-01, -1.255704e-01,  3.227661e-01, -3.302322e-01},
  {-9.343899e-01,  3.350373e-01, -1.211010e-01, -4.160073e-01,  1.946022e-01, -5.317810e-01},
  {-9.272251e-01,  3.207553e-01, -1.933122e-01, -4.234286e-01,  1.579373e-01, -5.608664e-01},
  { 8.445007e-01,  2.303335e-01, -4.834927e-01,  9.236849e-02,  2.053043e-01, -5.724565e-01},
  { 9.797185e-01,  7.546401e-03, -2.002365e-01,  9.210399e-02,  1.857876e-01, -5.786589e-01},
  { 9.786503e-01,  2.054443e-01, -6.030919e-03,  6.401052e-02,  2.011859e-01, -7.075421e-01},
  {-6.732554e-01,  3.469983e-01, -6.529315e-01, -2.566226e-01,  3.328986e-01, -7.866932e-01},
  {-8.086326e-01,  3.444725e-01, -4.769193e-01, -3.026689e-01,  2.954408e-01, -7.437068e-01},
  { 8.886101e-01, -7.398202e-02, -4.526574e-01,  6.386673e-02,  1.996422e-01, -7.104903e-01},
  { 8.749049e-01,  4.839270e-01,  1.887004e-02,  6.269668e-02,  2.057844e-01, -7.049153e-01},
  {-6.041297e-01,  3.292946e-01, -7.256669e-01, -2.376412e-01,  3.147261e-01, -8.128744e-01},
  { 8.911852e-01, -1.984589e-02, -4.532053e-01,  3.579157e-02,  2.139765e-01, -7.656091e-01},
  {-5.311170e-01,  2.807741e-01, -7.994252e-01, -2.345397e-01,  3.102220e-01, -8.168091e-01},
  {-5.224857e-01,  2.359477e-01, -8.193519e-01, -2.398086e-01,  2.818020e-01, -8.224295e-01},
  {-5.053195e-01,  2.433947e-01, -8.278957e-01, -2.293255e-01,  2.966531e-01, -8.242643e-01},
  {-5.338819e-01,  2.059591e-01, -8.200921e-01, -2.462737e-01,  2.514178e-01, -8.261636e-01},
  {-6.735445e-02, -2.933687e-01, -9.536237e-01, -1.675603e-01,  1.693616e-01, -8.498194e-01},
  { 4.603959e-02, -4.371286e-01, -8.982198e-01, -1.455644e-01,  1.796713e-01, -8.534340e-01},
  { 7.483954e-02, -5.495561e-01, -8.320980e-01, -1.534132e-01,  1.782323e-01, -8.527465e-01},
  { 1.178279e-02, -4.398573e-01, -8.979903e-01, -1.581262e-01,  1.779742e-01, -8.539363e-01},
  {-3.029407e-01,  2.539495e-03, -9.530060e-01, -2.052939e-01,  2.187846e-01, -8.464729e-01},
  { 7.187790e-01,  3.908372e-02,  6.941392e-01,  3.807890e-01,  3.000862e-01,  8.169997e-01},
  { 5.101053e-01,  6.287438e-02,  8.578108e-01,  3.558584e-01,  3.297737e-01,  8.347090e-01},
  { 2.731903e-01,  6.737577e-02,  9.595976e-01,  3.224033e-01,  3.573000e-01,  8.465039e-01},
  {-7.720298e-02,  1.051568e-01,  9.914544e-01,  2.737072e-01,  3.483389e-01,  8.518257e-01},
  { 9.527078e-01,  6.999706e-02,  2.957164e-01,  4.201533e-01,  2.918002e-01,  7.500518e-01},
  {-6.951656e-01,  2.593099e-01,  6.704499e-01, -1.226445e-01,  3.678159e-01,  6.405219e-01},
  { 9.658245e-01,  3.130744e-02,  2.572993e-01,  4.296167e-01,  2.713129e-01,  7.187566e-01},
  { 9.653639e-01, -6.204150e-02,  2.534233e-01,  4.359114e-01,  2.486941e-01,  6.920698e-01},
  { 9.858933e-01, -8.966307e-02,  1.413321e-01,  4.595391e-01,  2.340218e-01,  5.819947e-01},
  {-7.798998e-01,  3.496872e-01,  5.191098e-01, -2.032848e-01,  4.334408e-01,  5.082389e-01},
  {-9.110245e-01,  2.673618e-01,  3.139299e-01, -2.677304e-01,  2.351309e-01,  5.190697e-01},
  {-8.017726e-01,  3.575616e-01,  4.788636e-01, -2.079894e-01,  4.612917e-01,  4.811724e-01},
  {-8.011177e-01,  3.111385e-01,  5.112762e-01, -2.439045e-01,  3.708029e-01,  4.856415e-01},
  {-8.464945e-01,  2.598475e-01,  4.646788e-01, -2.745529e-01,  2.906932e-01,  4.791940e-01},
  {-9.230461e-01,  2.963760e-01,  2.452490e-01, -3.822611e-01,  2.663860e-01,  2.773887e-01},
  {-9.735686e-01,  2.268545e-01, -2.647895e-02, -4.012039e-01,  2.246681e-01,  2.200281e-01},
  {-9.623838e-01,  1.768514e-01, -2.062545e-01, -3.978270e-01,  2.214501e-01,  1.901184e-01},
  {-9.363256e-01,  1.718941e-01, -3.061810e-01, -3.890031e-01,  2.386504e-01,  1.680233e-01},
  { 9.971415e-01,  6.392062e-02,  4.028657e-02,  4.300020e-01,  2.512028e-01, -8.379014e-02},
  {-9.125445e-01,  1.318546e-01, -3.871392e-01, -3.760173e-01,  2.607710e-01,  1.419470e-01},
  { 9.802039e-01,  1.844177e-01,  7.204475e-02,  4.320714e-01,  2.609357e-01, -1.071392e-01},
  { 9.216426e-01,  3.876781e-01,  1.675209e-02,  4.334857e-01,  2.597240e-01, -1.169883e-01},
  { 9.815475e-01,  1.886095e-01, -3.147938e-02,  4.332135e-01,  2.589582e-01, -1.267941e-01},
  {-8.742207e-01,  1.379191e-01, -4.655282e-01, -3.637545e-01,  2.875769e-01,  1.243174e-01},
  {-8.830173e-01,  2.954936e-01, -3.646421e-01, -1.128337e-01,  3.389140e-01, -1.704376e-01},
  {-9.002350e-01,  3.432363e-01, -2.678913e-01, -1.083776e-01,  3.354832e-01, -1.863153e-01},
  { 9.918538e-01,  9.812570e-02, -8.122358e-02,  4.356293e-01,  2.133847e-01, -2.845465e-01},
  { 9.128813e-01,  3.171578e-01, -2.570189e-01,  4.331972e-01,  2.234501e-01, -2.819723e-01},
  {-4.205312e-01,  4.843935e-01,  7.671482e-01, -3.410208e-01,  2.419138e-01, -3.512868e-01},
  {-6.257875e-01,  5.321856e-01,  5.702354e-01, -3.580261e-01,  2.726447e-01, -3.908910e-01},
  {-7.884859e-01,  6.133701e-01,  4.546476e-02, -9.555811e-02,  3.317946e-01, -2.773672e-01},
  {-7.156558e-01,  5.727549e-01,  3.997356e-01, -3.635761e-01,  2.940582e-01, -4.216478e-01},
  { 5.747796e-01,  5.271659e-01, -6.258790e-01,  4.350448e-01,  1.871545e-01, -3.278545e-01},
  { 5.603433e-01,  6.053594e-01, -5.652924e-01,  4.369994e-01,  1.855800e-01, -3.274717e-01},
  { 6.902651e-01,  3.344598e-01, -6.416158e-01,  3.659796e-01,  2.348036e-01, -3.914455e-01},
  {-7.793874e-01,  5.951464e-01,  1.958472e-01, -3.655176e-01,  3.133203e-01, -4.641405e-01},
  { 6.129507e-01,  3.297459e-01, -7.180244e-01,  3.332891e-01,  2.610166e-01, -4.096811e-01},
  {-8.165528e-01,  5.755550e-01,  4.447470e-02, -3.686897e-01,  3.131666e-01, -4.810396e-01},
  {-3.921416e-01,  7.917989e-01,  4.682729e-01, -1.271852e-01,  3.381492e-01, -3.545618e-01},
  {-9.153209e-01,  2.870632e-01, -2.824578e-01, -3.983307e-01,  1.816617e-01, -6.224432e-01},
  { 9.011924e-01,  4.172988e-01,  1.171069e-01,  6.296621e-02,  2.059450e-01, -7.075315e-01},
  { 7.728363e-01, -1.022982e-01, -6.263060e-01,  2.637393e-02,  2.137764e-01, -7.794611e-01},
  { 5.921656e-01, -1.923181e-01, -7.825302e-01, -2.239601e-02,  1.581700e-01, -8.158094e-01},
  { 9.104950e-01,  1.960305e-01, -3.641031e-01,  6.022661e-02,  2.090725e-01, -7.151665e-01},
  {-5.590724e-01,  2.907326e-01, -7.764744e-01, -2.262839e-01,  3.274548e-01, -8.160988e-01},
  { 4.501281e-01, -2.354371e-01, -8.613675e-01, -4.779706e-02,  2.034920e-01, -8.433495e-01},
  {-4.276337e-01,  1.751476e-01, -8.868217e-01, -2.223286e-01,  2.573563e-01, -8.375742e-01},
  { 1.287170e-01, -2.149900e-01, -9.680967e-01, -5.958696e-02,  2.394545e-01, -8.589234e-01},
  {-3.336978e-02, -1.518169e-01, -9.878452e-01, -1.360224e-01,  1.990579e-01, -8.573706e-01},
  {-4.080844e-01,  7.265610e-02, -9.100484e-01, -2.410983e-01,  2.315127e-01, -8.328754e-01},
  { 3.907119e-01,  6.479184e-02, -9.182299e-01, -6.523680e-02,  2.538042e-01, -8.636674e-01},
  { 2.699021e-02, -1.361232e-01, -9.903242e-01, -1.280998e-01,  2.141814e-01, -8.598195e-01},
  { 2.325742e-01, -1.889239e-01, -9.540529e-01, -7.091504e-02,  2.583769e-01, -8.651878e-01},
  { 1.871795e-01, -1.539986e-01, -9.701795e-01, -7.040834e-02,  2.633008e-01, -8.671694e-01},
  {-2.854029e-01,  1.465955e-02, -9.582955e-01, -1.758692e-01,  2.368264e-01, -8.551332e-01},
  {-1.050001e-01, -6.086778e-02, -9.926077e-01, -1.476328e-01,  2.376190e-01, -8.608601e-01},
  { 3.794572e-01,  5.608409e-02,  9.235079e-01,  3.412322e-01,  3.687450e-01,  8.398089e-01},
  { 1.527957e-01,  8.420967e-02,  9.846635e-01,  3.119223e-01,  3.667150e-01,  8.479722e-01},
  {-5.978165e-01,  1.967058e-01,  7.771244e-01, -5.857408e-02,  3.909321e-01,  6.916352e-01},
  {-7.836991e-01,  3.096323e-01,  5.384641e-01, -2.084583e-01,  3.840378e-01,  5.316404e-01},
  { 9.840761e-01, -8.246816e-02,  1.574588e-01,  4.624535e-01,  2.673664e-01,  5.806752e-01},
  { 9.829834e-01, -9.842570e-02,  1.551007e-01,  4.654776e-01,  2.878967e-01,  5.727047e-01},
  {-8.550033e-01,  3.598769e-01,  3.734407e-01, -3.058740e-01,  3.792119e-01,  3.522221e-01},
  {-9.600604e-01,  2.720783e-01,  6.525011e-02, -3.903005e-01,  2.655192e-01,  2.300752e-01},
  {-8.018037e-01,  8.489875e-02, -5.915260e-01, -1.513964e-01,  3.856274e-01, -8.869445e-02},
  {-7.109497e-01,  1.349133e-01, -6.901804e-01, -2.841123e-01,  3.351515e-01,  2.953734e-02},
  {-7.624769e-01,  2.025694e-01, -6.144873e-01, -1.494514e-01,  3.414040e-01, -1.041464e-01},
  {-8.359246e-01,  1.295947e-01, -5.333248e-01, -1.283170e-01,  3.658637e-01, -1.249578e-01},
  {-8.272356e-01,  2.131693e-01, -5.198463e-01, -1.319439e-01,  3.508115e-01, -1.252378e-01},
  {-8.429807e-01,  2.293810e-01, -4.865880e-01, -1.364339e-01,  3.291098e-01, -1.264995e-01},
  {-7.758135e-01,  1.395859e-01, -6.153286e-01, -3.263786e-01,  3.115085e-01,  7.345282e-02},
  {-8.846596e-01,  3.807099e-01, -2.691420e-01, -9.722398e-02,  3.491256e-01, -2.040264e-01},
  {-5.341316e-01,  5.350217e-01,  6.545649e-01, -3.433448e-01,  2.610689e-01, -3.676236e-01},
  { 7.778854e-01,  4.875232e-01, -3.965040e-01,  4.345946e-01,  1.924937e-01, -3.230141e-01},
  {-7.659660e-01,  6.428775e-01,  2.156553e-03, -8.502886e-02,  3.456928e-01, -2.925489e-01},
  {-5.383854e-02,  7.760875e-01,  6.283228e-01, -1.995454e-01,  3.007334e-01, -3.460199e-01},
  { 4.000419e-01,  3.487414e-01, -8.475530e-01,  2.703885e-01,  3.100563e-01, -4.325897e-01},
  { 7.725889e-01,  3.562227e-01, -5.255586e-01,  3.989969e-01,  2.241276e-01, -3.579852e-01},
  { 7.948210e-01,  3.476603e-01, -4.973850e-01,  3.974117e-01,  2.273673e-01, -3.581671e-01},
  { 4.783883e-01,  5.307090e-01, -6.996375e-01,  1.326341e-01,  2.823170e-01, -4.974734e-01},
  { 6.121183e-01,  4.290343e-01, -6.642596e-01,  1.006953e-01,  2.624626e-01, -5.337803e-01},
  {-8.596079e-01,  5.041634e-01, -8.302585e-02, -3.596783e-01,  3.252375e-01, -5.404758e-01},
  { 6.657649e-01,  5.748524e-01, -4.757120e-01,  8.590145e-02,  2.621703e-01, -5.523416e-01},
  { 9.545638e-01,  1.476308e-01, -2.588690e-01,  7.355009e-02,  2.275198e-01, -6.028494e-01},
  {-6.305009e-01,  3.498501e-01, -6.928734e-01, -2.279912e-01,  3.582325e-01, -8.019262e-01},
  { 9.908981e-01,  1.082899e-01, -7.996450e-02,  5.733948e-02,  2.316722e-01, -7.116636e-01},
  { 6.887271e-01, -1.479478e-01, -7.097651e-01, -3.771955e-03,  2.039930e-01, -8.103577e-01},
  { 5.860684e-01, -1.945065e-01, -7.865692e-01, -2.011127e-02,  1.891568e-01, -8.215276e-01},
  {-5.051616e-01,  2.698991e-01, -8.197355e-01, -2.026626e-01,  3.458153e-01, -8.249589e-01},
  {-4.469016e-01,  2.327508e-01, -8.637744e-01, -1.955066e-01,  3.176859e-01, -8.368975e-01},
  {-3.343712e-01,  1.210605e-01, -9.346337e-01, -1.846256e-01,  2.766325e-01, -8.495275e-01},
  {-3.793780e-01,  9.777418e-02, -9.200612e-01, -2.239298e-01,  2.384084e-01, -8.393901e-01},
  { 5.172132e-01,  1.578144e-02, -8.557110e-01, -5.702196e-02,  2.483968e-01, -8.596292e-01},
  {-3.397033e-01,  8.742680e-02, -9.364606e-01, -1.939029e-01,  2.670166e-01, -8.474777e-01},
  { 7.961211e-01, -6.138894e-02,  6.020154e-01,  4.006093e-01,  3.641662e-01,  7.903977e-01},
  { 6.896222e-01, -1.546054e-03,  7.241677e-01,  3.766168e-01,  3.505751e-01,  8.180023e-01},
  { 6.999349e-01,  1.555820e-02,  7.140372e-01,  3.806685e-01,  3.655622e-01,  8.135179e-01},
  { 8.642301e-01, -2.388890e-02,  5.025293e-01,  4.117205e-01,  3.590926e-01,  7.724658e-01},
  { 5.404574e-01,  3.148866e-02,  8.407819e-01,  3.627351e-01,  3.761097e-01,  8.276346e-01},
  { 3.122811e-01,  8.089769e-02,  9.465390e-01,  3.364650e-01,  3.869532e-01,  8.403544e-01},
  { 3.198563e-02,  1.244658e-01,  9.917082e-01,  2.940795e-01,  3.860838e-01,  8.480539e-01},
  { 9.402263e-01, -4.330805e-02,  3.377853e-01,  4.264163e-01,  3.296868e-01,  7.374408e-01},
  { 1.609273e-01,  1.088756e-01,  9.809427e-01,  3.135425e-01,  3.870107e-01,  8.461066e-01},
  {-4.969168e-01,  1.559301e-01,  8.536741e-01,  1.379206e-01,  3.424734e-01,  8.076267e-01},
  { 9.679556e-01, -8.582512e-02,  2.360001e-01,  4.493917e-01,  2.913697e-01,  6.527215e-01},
  { 9.720502e-01, -9.733492e-02,  2.136454e-01,  4.698288e-01,  4.094430e-01,  6.183847e-01},
  {-7.284799e-01,  1.887633e-01,  6.585481e-01, -2.218219e-01,  2.521707e-01,  5.814519e-01},
  {-8.612006e-01,  2.991844e-01,  4.108799e-01, -2.350376e-01,  3.169657e-01,  5.333802e-01},
  { 9.925635e-01, -1.014281e-01,  6.730502e-02,  4.741317e-01,  3.049412e-01,  5.096291e-01},
  {-8.775191e-01,  3.365303e-01,  3.416247e-01, -3.571742e-01,  3.193417e-01,  2.934132e-01},
  {-9.307648e-01,  3.107427e-01,  1.926552e-01, -3.819992e-01,  2.859086e-01,  2.503422e-01},
  {-9.681675e-01,  2.211632e-01, -1.172121e-01, -3.901227e-01,  2.623942e-01,  1.974158e-01},
  {-9.424106e-01,  1.966619e-01, -2.705301e-01, -3.867795e-01,  2.619921e-01,  1.751390e-01},
  {-7.048116e-01,  1.595488e-01, -6.912199e-01, -2.797150e-01,  3.468249e-01,  2.763779e-02},
  {-7.640956e-01,  1.697188e-01, -6.223773e-01, -3.091389e-01,  3.374052e-01,  5.797292e-02},
  {-8.650492e-01,  2.020184e-01, -4.592151e-01, -3.519022e-01,  3.272401e-01,  1.161908e-01},
  {-8.252581e-01,  1.446862e-01, -5.459074e-01, -3.460897e-01,  3.087695e-01,  1.008277e-01},
  {-8.716951e-01,  2.807172e-01, -4.016782e-01, -1.054487e-01,  3.759462e-01, -1.603219e-01},
  { 9.873202e-01,  1.149244e-01, -1.095043e-01,  4.290026e-01,  2.938095e-01, -2.116210e-01},
  {-8.612008e-01,  4.030402e-01, -3.096639e-01, -8.961991e-02,  3.623846e-01, -2.099513e-01},
  {-3.675877e-01,  5.257651e-01,  7.671051e-01, -3.337471e-01,  2.525991e-01, -3.544936e-01},
  {-8.448201e-01,  4.902488e-01, -2.143251e-01, -8.214225e-02,  3.597854e-01, -2.408770e-01},
  {-5.070918e-01,  5.617115e-01,  6.537110e-01, -3.422498e-01,  2.739684e-01, -3.776440e-01},
  { 8.983476e-01,  2.512171e-01, -3.603632e-01,  4.145382e-01,  2.851580e-01, -2.862353e-01},
  {-5.809243e-01,  6.062264e-01,  5.431541e-01, -3.527263e-01,  2.966416e-01, -4.092009e-01},
  { 8.538744e-01,  2.605226e-01, -4.505844e-01,  4.027562e-01,  2.663139e-01, -3.233038e-01},
  { 8.020477e-01,  3.007568e-01, -5.160084e-01,  3.943473e-01,  2.590345e-01, -3.416226e-01},
  { 8.091081e-01,  3.104255e-01, -4.989790e-01,  3.961572e-01,  2.767743e-01, -3.279347e-01},
  {-6.795480e-01,  6.524752e-01,  3.353962e-01, -3.562389e-01,  3.157044e-01, -4.428047e-01},
  { 7.049066e-01,  3.305525e-01, -6.275682e-01,  3.629870e-01,  2.812606e-01, -3.704654e-01},
  { 2.956737e-01,  3.722837e-01, -8.797624e-01,  2.185658e-01,  3.410646e-01, -4.388346e-01},
  {-6.936824e-01,  6.604008e-01,  2.875338e-01, -3.522374e-01,  3.264014e-01, -4.564854e-01},
  { 6.524858e-01,  3.298005e-01, -6.822711e-01,  3.292218e-01,  2.982653e-01, -3.957918e-01},
  { 5.228758e-01,  3.423525e-01, -7.806380e-01,  2.995300e-01,  3.378209e-01, -4.010390e-01},
  { 3.860730e-01,  3.824630e-01, -8.394461e-01,  2.451581e-01,  3.519911e-01, -4.249524e-01},
  {-1.051015e-01,  7.811016e-01,  6.154948e-01, -1.332696e-01,  3.542773e-01, -3.805993e-01},
  {-7.640625e-01,  6.341762e-01,  1.184446e-01, -3.495543e-01,  3.398216e-01, -4.938882e-01},
  {-9.150001e-01,  3.635528e-01, -1.749406e-01, -3.868479e-01,  2.558832e-01, -5.714967e-01},
  { 7.445306e-01,  3.850734e-01, -5.453371e-01,  7.694389e-02,  2.794779e-01, -5.526514e-01},
  { 8.271153e-01,  4.102660e-01, -3.841381e-01,  7.773282e-02,  2.598328e-01, -5.686015e-01},
  {-8.978263e-01,  4.151992e-01, -1.466885e-01, -3.695103e-01,  2.961626e-01, -5.741178e-01},
  { 9.621741e-01,  1.126585e-01, -2.480504e-01,  7.511365e-02,  2.520353e-01, -5.810849e-01},
  {-8.783812e-01,  2.853382e-01, -3.834431e-01, -3.724138e-01,  2.179649e-01, -6.626944e-01},
  { 9.930522e-01,  1.111428e-01, -3.865836e-02,  5.454274e-02,  2.670234e-01, -6.883013e-01},
  { 8.522344e-01, -2.683022e-02, -5.224718e-01,  2.872549e-02,  2.406611e-01, -7.791921e-01},
  { 9.561251e-01,  1.274699e-01, -2.637731e-01,  5.398062e-02,  2.424641e-01, -7.200165e-01},
  { 9.615740e-01,  8.825578e-02, -2.599738e-01,  5.058370e-02,  2.537487e-01, -7.280648e-01},
  {-3.849582e-01,  1.632077e-01, -9.083889e-01, -1.661922e-01,  3.305127e-01, -8.478659e-01},
  {-7.938905e-02, -8.342544e-02, -9.933467e-01, -1.076371e-01,  2.801190e-01, -8.662612e-01},
  {-8.526881e-02, -4.694356e-03, -9.963469e-01, -1.102767e-01,  2.885587e-01, -8.662253e-01},
  {-2.288768e-01,  4.515531e-02, -9.724075e-01, -1.649771e-01,  2.620097e-01, -8.570532e-01},
  {-1.293830e-01, -1.591110e-01, -9.787461e-01, -8.883189e-02,  2.783577e-01, -8.670274e-01},
  {-2.324078e-01,  1.090127e-01,  9.664900e-01,  2.544045e-01,  3.710166e-01,  8.471739e-01},
  { 6.382323e-01,  3.622438e-02,  7.689912e-01,  3.734523e-01,  3.904029e-01,  8.192648e-01},
  {-1.102688e-01,  1.292514e-01,  9.854618e-01,  2.697357e-01,  3.879431e-01,  8.473297e-01},
  { 9.060887e-01, -1.243625e-02,  4.229049e-01,  4.261572e-01,  3.873341e-01,  7.428568e-01},
  { 9.442034e-01, -6.915545e-02,  3.220209e-01,  4.611214e-01,  4.277524e-01,  6.569226e-01},
  {-7.149134e-01,  2.888905e-01,  6.367427e-01, -2.046009e-01,  3.029234e-01,  5.802825e-01},
  {-7.585326e-01,  2.944823e-01,  5.812990e-01, -1.964512e-01,  3.725213e-01,  5.534195e-01},
  {-7.516735e-01,  3.217960e-01,  5.757034e-01, -2.013584e-01,  3.602498e-01,  5.538372e-01},
  {-7.495685e-01,  3.178330e-01,  5.806284e-01, -2.061382e-01,  3.482550e-01,  5.543348e-01},
  {-7.867498e-01,  1.297512e-01,  6.034811e-01, -2.349127e-01,  2.448385e-01,  5.676459e-01},
  { 9.875230e-01, -1.020895e-01,  1.199001e-01,  4.751447e-01,  3.532034e-01,  5.529956e-01},
  { 9.985548e-01, -3.746811e-02, -3.852797e-02,  4.265545e-01,  2.845817e-01,  4.843179e-02},
  {-9.610199e-01,  2.647561e-01, -7.965510e-02, -3.838448e-01,  2.860723e-01,  1.955245e-01},
  {-9.447211e-01,  2.139911e-01, -2.484147e-01, -3.743181e-01,  2.953292e-01,  1.536239e-01},
  {-9.257787e-01,  2.262150e-01, -3.029200e-01, -3.669872e-01,  3.129785e-01,  1.421556e-01},
  {-7.928465e-01,  1.974207e-01, -5.765583e-01, -1.185208e-01,  4.240522e-01, -1.191463e-01},
  {-9.034005e-01,  2.126276e-01, -3.723668e-01, -3.537163e-01,  3.465806e-01,  1.313577e-01},
  { 9.995651e-01,  2.052986e-02,  2.117240e-02,  4.321856e-01,  3.080537e-01, -1.188613e-01},
  {-8.646291e-01,  2.559246e-01, -4.323413e-01, -9.445477e-02,  3.892137e-01, -1.734594e-01},
  { 9.941434e-01,  6.664626e-02, -8.507195e-02,  4.306306e-01,  2.963758e-01, -1.932479e-01},
  {-9.013231e-01,  2.505469e-01, -3.533313e-01, -8.817504e-02,  3.807510e-01, -1.938260e-01},
  {-8.910714e-01,  3.189838e-01, -3.228637e-01, -8.131625e-02,  3.756328e-01, -2.171459e-01},
  {-5.975577e-01,  6.431414e-01,  4.788465e-01, -3.445970e-01,  3.162050e-01, -4.247082e-01},
  {-2.399848e-01,  7.312436e-01,  6.385062e-01, -2.040447e-01,  3.106545e-01, -3.573000e-01},
  { 6.972601e-01,  2.762821e-01, -6.614353e-01,  3.477468e-01,  3.625319e-01, -3.493177e-01},
  { 6.663801e-01,  2.896839e-01, -6.870378e-01,  3.360659e-01,  3.266075e-01, -3.762982e-01},
  { 4.593911e-01,  3.134575e-01, -8.310861e-01,  2.755076e-01,  3.712339e-01, -4.022734e-01},
  { 1.231896e-01,  5.513933e-01, -8.250998e-01,  1.382240e-01,  3.610272e-01, -4.483714e-01},
  { 5.900912e-01,  3.188414e-01, -7.417093e-01,  3.227407e-01,  3.576376e-01, -3.747493e-01},
  {-4.678693e-01,  8.382987e-01,  2.799168e-01, -7.274870e-02,  3.624011e-01, -3.448357e-01},
  { 6.564022e-01,  6.370878e-01, -4.040487e-01,  8.582363e-02,  3.387990e-01, -4.854900e-01},
  { 6.022056e-01,  4.856299e-01, -6.336498e-01,  9.858530e-02,  2.946908e-01, -5.137855e-01},
  { 6.245614e-01,  5.161455e-01, -5.861030e-01,  8.842152e-02,  3.111229e-01, -5.091650e-01},
  { 6.299945e-01,  5.202851e-01, -5.765505e-01,  9.846314e-02,  2.824140e-01, -5.230561e-01},
  { 1.348373e-01,  9.050782e-01, -4.033017e-01,  4.969628e-02,  3.557073e-01, -4.919758e-01},
  {-9.283521e-01,  3.244408e-01, -1.813848e-01, -4.034699e-01,  2.200062e-01, -5.578042e-01},
  { 7.252324e-01,  4.928486e-01, -4.807684e-01,  7.286402e-02,  3.039742e-01, -5.345699e-01},
  { 8.151940e-01,  5.055455e-01, -2.826350e-01,  6.952258e-02,  2.994791e-01, -5.452688e-01},
  {-8.180314e-01,  5.749552e-01, -1.584769e-02, -3.435032e-01,  3.514748e-01, -5.376891e-01},
  { 8.914000e-01,  3.648542e-01, -2.688632e-01,  6.441212e-02,  2.886157e-01, -5.709934e-01},
  { 8.769250e-01,  1.922782e-02, -4.802424e-01,  3.337969e-02,  2.649467e-01, -7.711813e-01},
  { 6.826710e-01, -1.060923e-01, -7.229831e-01, -1.294572e-02,  2.431342e-01, -8.260211e-01},
  { 9.300875e-01,  4.365605e-02, -3.647348e-01,  4.269368e-02,  2.663582e-01, -7.506715e-01},
  { 5.631236e-01, -1.614121e-01, -8.104554e-01, -2.894153e-02,  2.275831e-01, -8.370745e-01},
  {-3.894294e-01,  1.390076e-01, -9.105062e-01, -1.501352e-01,  3.364722e-01, -8.536620e-01},
  {-2.849770e-01,  8.525272e-02, -9.547356e-01, -1.344544e-01,  3.233798e-01, -8.605625e-01},
  {-1.351221e-01,  2.602708e-02, -9.904870e-01, -1.126535e-01,  3.123890e-01, -8.657767e-01},
  { 3.994002e-01, -8.365405e-02, -9.129521e-01, -6.267674e-02,  2.774190e-01, -8.649720e-01},
  {-2.449366e-01,  1.503623e-01,  9.578086e-01,  2.361676e-01,  3.969499e-01,  8.392981e-01},
  { 8.091963e-01,  5.511564e-03,  5.875125e-01,  3.963142e-01,  3.870881e-01,  7.959149e-01},
  { 6.627761e-01,  3.098162e-02,  7.481764e-01,  3.790674e-01,  4.040403e-01,  8.138955e-01},
  {-1.106575e-01,  1.541998e-01,  9.818234e-01,  2.679744e-01,  3.959355e-01,  8.460252e-01},
  {-3.621168e-01,  1.420671e-01,  9.212428e-01,  1.933175e-01,  3.751956e-01,  8.282347e-01},
  { 9.562410e-01, -7.508760e-02,  2.827810e-01,  4.676702e-01,  4.622965e-01,  6.458697e-01},
  {-5.321486e-01,  1.916026e-01,  8.246856e-01, -2.080714e-02,  4.224719e-01,  7.105576e-01},
  {-7.369002e-01,  2.926358e-01,  6.093788e-01, -2.201843e-01,  2.888153e-01,  5.689328e-01},
  {-4.811779e-01,  3.095057e-01,  8.201671e-01,  1.959320e-02,  4.208467e-01,  7.332024e-01},
  {-7.496864e-01,  3.343302e-01,  5.711336e-01, -1.719217e-01,  4.292471e-01,  5.546582e-01},
  {-4.509049e-01,  3.267593e-01,  8.306100e-01,  3.664158e-02,  4.252516e-01,  7.410153e-01},
  {-4.702975e-01,  4.262736e-01,  7.727296e-01,  2.750583e-02,  4.225466e-01,  7.376943e-01},
  {-8.308674e-01,  1.576496e-01,  5.336722e-01, -2.516809e-01,  2.452087e-01,  5.439506e-01},
  {-8.494084e-01,  3.567760e-01,  3.888652e-01, -2.549644e-01,  4.858478e-01,  3.686872e-01},
  {-8.660750e-01,  3.909090e-01,  3.116154e-01, -3.425347e-01,  3.540015e-01,  2.928731e-01},
  {-9.454165e-01,  3.153763e-01,  8.200862e-02, -3.761715e-01,  3.093435e-01,  2.326415e-01},
  {-9.643418e-01,  2.556055e-01, -6.863554e-02, -3.769135e-01,  3.099698e-01,  1.908252e-01},
  {-7.324393e-01,  1.879337e-01, -6.543804e-01, -2.886595e-01,  3.676834e-01,  4.211148e-02},
  {-8.386771e-01,  2.082851e-01, -5.032277e-01, -3.363986e-01,  3.553362e-01,  1.024272e-01},
  {-8.661323e-01,  1.409100e-01, -4.795406e-01, -3.449621e-01,  3.528109e-01,  1.159837e-01},
  { 9.954165e-01,  6.965137e-02, -6.553413e-02,  4.308609e-01,  3.191855e-01, -1.640955e-01},
  {-3.068431e-01,  5.100545e-01,  8.035495e-01, -3.234364e-01,  2.644158e-01, -3.579638e-01},
  {-4.676999e-01,  5.867956e-01,  6.610051e-01, -3.321300e-01,  2.843492e-01, -3.788322e-01},
  {-4.906665e-01,  6.245843e-01,  6.075697e-01, -3.330522e-01,  3.090164e-01, -4.038433e-01},
  { 7.764395e-01,  2.694621e-01, -5.696770e-01,  3.800350e-01,  3.342868e-01, -3.215781e-01},
  {-5.816291e-01,  7.064596e-01,  4.032646e-01, -3.367470e-01,  3.316935e-01, -4.376166e-01},
  { 3.282782e-01,  3.486183e-01, -8.778945e-01,  2.297655e-01,  3.858980e-01, -4.167024e-01},
  { 1.419332e-01,  4.042186e-01, -9.035831e-01,  1.926513e-01,  3.847078e-01, -4.259295e-01},
  { 6.376128e-01,  2.717371e-01, -7.208390e-01,  3.270010e-01,  3.843037e-01, -3.604090e-01},
  { 4.527040e-01,  3.232049e-01, -8.310220e-01,  2.690712e-01,  3.951794e-01, -3.962880e-01},
  {-6.439475e-01,  7.650306e-01, -7.725708e-03, -6.067912e-02,  3.710780e-01, -3.483149e-01},
  {-6.492063e-01,  7.022151e-01,  2.922756e-01, -3.407295e-01,  3.404165e-01, -4.614971e-01},
  { 1.967619e-01,  8.298541e-01, -5.221369e-01,  5.769368e-02,  3.723924e-01, -4.623813e-01},
  {-3.010712e-01,  8.899306e-01,  3.426070e-01, -8.034499e-02,  3.671675e-01, -3.788906e-01},
  { 1.279058e-01,  7.798302e-01,  6.127847e-01, -1.271264e-01,  3.667921e-01, -3.973625e-01},
  { 5.990068e-01,  7.353286e-01, -3.169902e-01,  5.094037e-02,  3.276136e-01, -5.444682e-01},
  { 7.986547e-01,  5.699074e-01, -1.932774e-01,  5.751525e-02,  3.130351e-01, -5.537879e-01},
  {-8.360491e-01,  5.414081e-01, -8.887662e-02, -3.431771e-01,  3.485337e-01, -5.668275e-01},
  { 9.346648e-01,  2.968007e-01, -1.957322e-01,  6.035605e-02,  2.854612e-01, -5.921054e-01},
  {-8.570254e-01,  3.146038e-01, -4.080833e-01, -3.534889e-01,  2.665043e-01, -6.684760e-01},
  {-5.831589e-01,  3.611691e-01, -7.276555e-01, -1.981194e-01,  3.884241e-01, -8.116435e-01},
  { 7.524174e-01, -4.617673e-02, -6.570661e-01,  1.132711e-02,  2.705947e-01, -8.038343e-01},
  { 6.489241e-01, -3.601412e-02, -7.600003e-01, -2.204539e-02,  2.767133e-01, -8.373325e-01},
  {-4.706729e-01,  2.335644e-01, -8.508318e-01, -1.721967e-01,  3.738374e-01, -8.347674e-01},
  {-3.960620e-01,  1.455606e-01, -9.066129e-01, -1.481007e-01,  3.493989e-01, -8.525566e-01},
  { 4.805124e-01, -8.069868e-02, -8.732672e-01, -4.797841e-02,  2.731032e-01, -8.577024e-01},
  {-9.798407e-02,  6.047979e-02, -9.933485e-01, -1.127117e-01,  3.241395e-01, -8.653845e-01},
  { 2.501041e-01,  1.016499e-01, -9.628683e-01, -7.287361e-02,  2.938521e-01, -8.659342e-01},
  {-8.943011e-02,  1.754576e-01,  9.804167e-01,  2.694339e-01,  4.414830e-01,  8.394380e-01},
  {-2.917299e-02,  1.659576e-01,  9.857013e-01,  2.773346e-01,  4.187702e-01,  8.430760e-01},
  { 4.822371e-01,  8.274069e-02,  8.721247e-01,  3.514332e-01,  4.121507e-01,  8.323492e-01},
  { 1.154835e-01,  1.426512e-01,  9.830129e-01,  3.097891e-01,  4.273204e-01,  8.410537e-01},
  { 9.011709e-01, -3.392830e-02,  4.321342e-01,  4.325804e-01,  4.252188e-01,  7.320646e-01},
  {-6.893294e-01,  2.495419e-01,  6.801131e-01, -1.040734e-01,  4.209922e-01,  6.394023e-01},
  { 2.586248e-01,  1.309427e-01,  9.570617e-01,  3.297100e-01,  4.238171e-01,  8.384124e-01},
  {-7.302111e-01,  3.098143e-01,  6.089392e-01, -1.456312e-01,  4.240271e-01,  5.902641e-01},
  {-4.827107e-01,  1.942049e-01,  8.539760e-01, -1.841539e-03,  4.328752e-01,  7.194209e-01},
  {-7.702125e-01,  2.266596e-01,  5.961528e-01, -2.315268e-01,  2.683834e-01,  5.648422e-01},
  {-8.160955e-01,  2.600650e-01,  5.160953e-01, -2.438037e-01,  2.687756e-01,  5.473419e-01},
  {-8.256285e-01,  3.005008e-01,  4.775321e-01, -2.499709e-01,  2.755763e-01,  5.332621e-01},
  { 9.926961e-01, -1.025232e-01, -6.358850e-02,  4.810634e-01,  3.469861e-01,  4.220943e-01},
  {-8.740930e-01,  3.646555e-01,  3.209168e-01, -2.708344e-01,  4.703019e-01,  3.444378e-01},
  {-8.980556e-01,  3.654310e-01,  2.448600e-01, -3.604885e-01,  3.294078e-01,  2.727490e-01},
  {-9.454886e-01,  3.248857e-01,  2.237827e-02, -3.751577e-01,  3.178182e-01,  2.044275e-01},
  {-9.639337e-01,  2.625262e-01, -4.372419e-02, -3.710178e-01,  3.271010e-01,  1.834400e-01},
  {-9.593091e-01,  2.754985e-01,  6.185934e-02, -3.687946e-01,  3.353973e-01,  1.865751e-01},
  {-7.248739e-01,  1.478794e-01, -6.728221e-01, -1.847529e-01,  4.265735e-01, -4.370528e-02},
  {-9.361999e-01,  3.043245e-01, -1.758302e-01, -3.596430e-01,  3.539712e-01,  1.601471e-01},
  {-7.680508e-01,  1.561264e-01, -6.210656e-01, -1.172025e-01,  4.546564e-01, -1.128323e-01},
  { 9.657044e-01,  1.506807e-01, -2.114485e-01,  4.204882e-01,  3.338244e-01, -2.282009e-01},
  {-3.694274e-01,  5.752044e-01,  7.298379e-01, -3.163333e-01,  2.748800e-01, -3.625891e-01},
  { 9.477399e-01,  1.571375e-01, -2.776631e-01,  4.172194e-01,  3.487877e-01, -2.313695e-01},
  {-5.594885e-01,  6.829011e-01,  4.697005e-01, -3.344722e-01,  3.258519e-01, -4.258597e-01},
  { 7.789293e-01,  2.263488e-01, -5.848378e-01,  3.673794e-01,  4.013682e-01, -3.101115e-01},
  { 6.860393e-01,  2.258352e-01, -6.916274e-01,  3.449114e-01,  4.074391e-01, -3.346141e-01},
  { 2.363173e-01,  3.933355e-01, -8.885051e-01,  2.291876e-01,  4.056569e-01, -4.086115e-01},
  { 5.388092e-02,  3.992087e-01, -9.152755e-01,  1.839953e-01,  4.042859e-01, -4.181598e-01},
  { 1.484678e-02,  8.258263e-01, -5.637290e-01,  6.576712e-02,  3.878634e-01, -4.375344e-01},
  {-5.165269e-01,  8.549294e-01,  4.791148e-02, -5.092498e-02,  3.776510e-01, -3.629459e-01},
  {-2.322994e-01,  9.562690e-01,  1.777263e-01, -6.341049e-02,  3.761285e-01, -3.951581e-01},
  { 9.531670e-02,  8.697701e-01,  4.841639e-01, -1.178558e-01,  3.813534e-01, -4.184236e-01},
  {-7.245027e-01,  6.759541e-01,  1.348405e-01, -3.301259e-01,  3.663385e-01, -5.173050e-01},
  {-7.886966e-01,  6.147088e-01, -9.525157e-03, -3.308868e-01,  3.687008e-01, -5.432838e-01},
  {-9.099828e-01,  3.141435e-01, -2.706384e-01, -3.714716e-01,  2.570606e-01, -6.325823e-01},
  { 5.897017e-01,  8.062954e-01, -4.625530e-02,  4.672847e-02,  3.293789e-01, -5.559037e-01},
  { 7.501859e-01,  6.527066e-01,  1.058070e-01,  3.910135e-02,  3.416564e-01, -5.511903e-01},
  {-8.985042e-01,  3.747513e-01, -2.285861e-01, -3.661989e-01,  2.863569e-01, -6.105220e-01},
  { 8.003583e-01,  5.983857e-01, -3.689599e-02,  4.260983e-02,  3.323584e-01, -5.738299e-01},
  {-8.681020e-01,  4.694304e-01, -1.613509e-01, -3.473499e-01,  3.362650e-01, -5.869485e-01},
  {-8.367863e-01,  3.010822e-01, -4.573164e-01, -3.359534e-01,  3.014249e-01, -6.769462e-01},
  { 9.878740e-01,  1.461898e-01,  5.228335e-02,  4.708554e-02,  3.127975e-01, -6.503484e-01},
  { 9.598013e-01,  2.748097e-01, -5.710575e-02,  4.706372e-02,  3.132698e-01, -6.371464e-01},
  {-7.517784e-01,  3.841142e-01, -5.359903e-01, -2.624984e-01,  3.692464e-01, -7.546845e-01},
  {-8.158740e-01,  2.966172e-01, -4.963545e-01, -3.133822e-01,  3.306884e-01, -6.980167e-01},
  {-8.085687e-01,  3.875657e-01, -4.427296e-01, -2.905824e-01,  3.573186e-01, -7.173967e-01},
  {-8.058480e-01,  2.982289e-01, -5.115355e-01, -3.049127e-01,  3.399709e-01, -7.057487e-01},
  { 9.767588e-01,  1.898815e-01, -9.943486e-02,  4.667532e-02,  3.017647e-01, -7.049056e-01},
  { 8.606247e-01,  3.287216e-02, -5.081777e-01,  2.620638e-02,  2.836415e-01, -7.825497e-01},
  { 9.245867e-01,  1.091274e-01, -3.650076e-01,  3.471508e-02,  2.942564e-01, -7.637926e-01},
  {-5.125320e-01,  3.193919e-01, -7.970570e-01, -1.704171e-01,  3.926782e-01, -8.292367e-01},
  { 4.844784e-01,  1.073257e-01, -8.681946e-01, -5.253511e-02,  2.829415e-01, -8.608882e-01},
  { 3.396422e-01,  5.307398e-02, -9.390561e-01, -6.181670e-02,  2.840367e-01, -8.646243e-01},
  { 4.377700e-02,  3.981681e-02, -9.982476e-01, -9.010828e-02,  3.145662e-01, -8.666310e-01},
  { 7.701986e-01,  9.578600e-03,  6.377322e-01,  3.983148e-01,  4.342309e-01,  7.931154e-01},
  {-5.631266e-02,  2.164962e-01,  9.746580e-01,  2.791459e-01,  4.549603e-01,  8.370636e-01},
  { 6.268860e-01,  5.444835e-02,  7.772061e-01,  3.821658e-01,  4.295436e-01,  8.100011e-01},
  { 8.637426e-01,  1.317738e-02,  5.037609e-01,  4.151243e-01,  4.397828e-01,  7.676196e-01},
  {-3.508927e-01,  1.466506e-01,  9.248611e-01,  1.951489e-01,  4.048979e-01,  8.239176e-01},
  {-3.427533e-01,  1.903896e-01,  9.199305e-01,  1.959956e-01,  4.190105e-01,  8.213402e-01},
  {-6.592641e-01,  2.477018e-01,  7.099400e-01, -6.804760e-02,  4.331704e-01,  6.714039e-01},
  {-4.145631e-01,  1.649284e-01,  8.949503e-01,  1.481876e-01,  4.595474e-01,  7.922428e-01},
  {-4.641062e-01,  1.881417e-01,  8.655681e-01,  8.395159e-02,  4.703119e-01,  7.561957e-01},
  { 9.578775e-01, -8.140362e-02,  2.753980e-01,  4.772092e-01,  4.965245e-01,  6.228071e-01},
  { 9.823123e-01, -1.115668e-01,  1.503842e-01,  4.817329e-01,  4.420423e-01,  5.750627e-01},
  { 9.879587e-01, -7.648712e-02, -1.344896e-01,  4.299378e-01,  3.292876e-01,  4.980765e-02},
  {-9.151129e-01,  3.931537e-01,  8.943431e-02, -3.278441e-01,  4.298986e-01,  2.160629e-01},
  {-9.371939e-01,  3.265760e-01,  1.225388e-01, -3.653425e-01,  3.437506e-01,  1.922123e-01},
  {-9.140800e-01,  3.937427e-01, -9.707937e-02, -3.454014e-01,  3.936112e-01,  1.751936e-01},
  {-7.297199e-01,  1.955938e-01, -6.551731e-01, -2.832733e-01,  3.993632e-01,  4.564984e-02},
  {-9.135372e-01,  3.588884e-01, -1.914386e-01, -3.533652e-01,  3.691369e-01,  1.566957e-01},
  {-7.502488e-01,  1.434436e-01, -6.454074e-01, -1.259752e-01,  4.692387e-01, -9.866636e-02},
  {-7.985291e-01,  2.566557e-01, -5.444991e-01, -3.006445e-01,  4.016462e-01,  6.898165e-02},
  {-8.855001e-01,  3.428189e-01, -3.136317e-01, -3.429658e-01,  3.800117e-01,  1.326153e-01},
  {-8.916380e-01,  3.331079e-01, -3.066281e-01, -3.401018e-01,  3.847950e-01,  1.294323e-01},
  { 9.885529e-01,  9.304240e-02, -1.187702e-01,  4.280795e-01,  3.498633e-01, -1.700235e-01},
  { 9.555418e-01,  1.238776e-01, -2.675710e-01,  4.174726e-01,  3.616857e-01, -2.222907e-01},
  { 8.877256e-01,  1.907779e-01, -4.189834e-01,  3.882712e-01,  3.711962e-01, -2.909063e-01},
  { 8.126277e-01,  1.747499e-01, -5.559665e-01,  3.749583e-01,  4.239227e-01, -2.912051e-01},
  {-4.781311e-01,  6.785663e-01,  5.576186e-01, -3.186884e-01,  3.332573e-01, -4.200152e-01},
  { 3.655264e-01,  3.287011e-01, -8.708307e-01,  2.549314e-01,  4.369536e-01, -3.867628e-01},
  { 7.078750e-02,  4.230879e-01, -9.033193e-01,  1.761943e-01,  4.253251e-01, -4.091383e-01},
  {-1.289771e-01,  5.708933e-01, -8.108302e-01,  9.717570e-02,  4.141451e-01, -4.126685e-01},
  { 3.870011e-02,  6.304030e-01, -7.753028e-01,  8.444782e-02,  4.094308e-01, -4.148231e-01},
  {-5.666122e-01,  7.239674e-01,  3.934738e-01, -3.186655e-01,  3.497784e-01, -4.447601e-01},
  { 1.827123e-01,  6.893858e-01, -7.009732e-01,  7.296225e-02,  3.945304e-01, -4.293108e-01},
  { 5.345489e-01,  2.726643e-01, -7.999448e-01,  2.934824e-01,  4.354889e-01, -3.674783e-01},
  {-5.979609e-01,  7.422138e-01,  3.025910e-01, -3.173069e-01,  3.618078e-01, -4.658588e-01},
  {-6.316308e-01,  7.322807e-01,  2.545730e-01, -3.202402e-01,  3.682308e-01, -4.886317e-01},
  {-1.972817e-01,  9.791747e-01,  4.792498e-02, -4.760937e-02,  3.815243e-01, -4.076154e-01},
  {-8.286102e-01,  5.428947e-01, -1.366400e-01, -3.364057e-01,  3.548763e-01, -5.869452e-01},
  {-6.726992e-01,  4.099251e-01, -6.159847e-01, -2.299369e-01,  3.931992e-01, -7.792838e-01},
  { 7.644810e-01, -2.890176e-02, -6.439981e-01,  7.404211e-03,  2.949892e-01, -8.103112e-01},
  { 9.643589e-01,  1.604727e-01, -2.103815e-01,  4.186492e-02,  2.996984e-01, -7.384808e-01},
  { 6.378863e-01, -3.399533e-02, -7.693799e-01, -1.713117e-02,  3.069232e-01, -8.344819e-01},
  {-4.681161e-01,  3.022214e-01, -8.303791e-01, -1.606354e-01,  3.962979e-01, -8.339500e-01},
  { 5.780522e-01,  3.637506e-02, -8.151886e-01, -2.829504e-02,  2.997073e-01, -8.430321e-01},
  {-3.761463e-01,  1.728101e-01, -9.103025e-01, -1.411759e-01,  3.611640e-01, -8.536103e-01},
  { 4.837444e-01,  3.830673e-02, -8.743706e-01, -4.289541e-02,  3.171800e-01, -8.518829e-01},
  {-1.548657e-01,  9.041874e-02, -9.837891e-01, -1.146962e-01,  3.429717e-01, -8.638871e-01},
  { 2.969967e-01,  6.268174e-02, -9.528189e-01, -6.730919e-02,  3.274680e-01, -8.615987e-01},
  { 7.319289e-01,  2.445043e-02,  6.809422e-01,  4.022339e-01,  4.542487e-01,  7.878684e-01},
  {-4.596911e-02,  2.276240e-01,  9.726635e-01,  2.768081e-01,  4.663823e-01,  8.342025e-01},
  {-2.268846e-01,  2.224567e-01,  9.481753e-01,  2.488770e-01,  4.671809e-01,  8.289336e-01},
  { 5.933250e-01,  1.025462e-01,  7.984045e-01,  3.754805e-01,  4.434428e-01,  8.139014e-01},
  {-3.421426e-01,  1.929657e-01,  9.196210e-01,  1.954118e-01,  4.711273e-01,  8.102831e-01},
  { 4.356302e-01,  1.113375e-01,  8.932134e-01,  3.581126e-01,  4.471870e-01,  8.242649e-01},
  {-6.820444e-01,  2.946477e-01,  6.693267e-01, -7.969256e-02,  4.376936e-01,  6.583409e-01},
  {-4.942766e-01,  1.467756e-01,  8.568241e-01,  1.518485e-01,  4.937142e-01,  7.878891e-01},
  {-5.118251e-01,  1.470571e-01,  8.464096e-01,  1.439579e-01,  5.061461e-01,  7.814769e-01},
  {-6.080678e-01,  2.563372e-01,  7.513619e-01, -3.996379e-02,  4.430688e-01,  6.918913e-01},
  { 9.442729e-01, -5.201912e-02,  3.250275e-01,  4.710888e-01,  5.125983e-01,  6.453909e-01},
  { 9.607911e-01, -3.475886e-02,  2.750861e-01,  4.771662e-01,  5.189884e-01,  6.281477e-01},
  {-4.530874e-01,  2.020956e-01,  8.682564e-01,  5.895457e-02,  4.730653e-01,  7.423040e-01},
  { 9.937860e-01, -1.050505e-01,  3.679148e-02,  4.861596e-01,  3.952672e-01,  4.590798e-01},
  {-8.425723e-01,  3.426140e-01,  4.155570e-01, -1.973584e-01,  5.723822e-01,  4.144830e-01},
  {-8.758700e-01,  4.058579e-01,  2.610191e-01, -3.333202e-01,  3.864050e-01,  2.771269e-01},
  { 9.866909e-01, -7.456388e-02, -1.445040e-01,  4.357218e-01,  3.587815e-01,  7.351990e-02},
  {-9.152868e-01,  3.872399e-01,  1.108843e-01, -3.433076e-01,  3.940758e-01,  2.153405e-01},
  { 9.979046e-01, -4.591709e-02, -4.558486e-02,  4.280325e-01,  3.557813e-01,  4.393239e-03},
  {-9.028142e-01,  4.236073e-01,  7.404892e-02, -3.224383e-01,  4.477617e-01,  1.846275e-01},
  {-7.387982e-01,  1.069359e-01, -6.653887e-01, -1.382587e-01,  4.864456e-01, -8.145386e-02},
  {-9.475673e-01,  3.170937e-01, -3.959439e-02, -3.258380e-01,  4.387240e-01,  1.662144e-01},
  {-9.291512e-01,  3.693263e-01, -1.661432e-02, -3.576629e-01,  3.639091e-01,  1.736144e-01},
  {-9.258280e-01,  3.484804e-01, -1.463005e-01, -3.278686e-01,  4.246572e-01,  1.409774e-01},
  {-8.918520e-01,  3.253518e-01, -3.142391e-01, -3.354028e-01,  3.982286e-01,  1.301260e-01},
  {-8.159854e-01,  3.455431e-01, -4.634306e-01, -3.168409e-01,  4.102175e-01,  9.906369e-02},
  {-8.739800e-01,  2.572808e-01, -4.122688e-01, -5.611811e-02,  4.371984e-01, -2.142327e-01},
  {-8.422713e-01,  3.638891e-01, -3.976983e-01, -4.658293e-02,  4.283532e-01, -2.410391e-01},
  { 9.268003e-01,  1.179414e-01, -3.565544e-01,  4.095389e-01,  3.868004e-01, -2.362732e-01},
  {-7.740973e-01,  4.968708e-01, -3.922918e-01, -3.329073e-02,  4.200993e-01, -2.795258e-01},
  { 8.870103e-01,  1.616710e-01, -4.325218e-01,  3.989280e-01,  3.955448e-01, -2.594683e-01},
  {-6.708364e-01,  6.830726e-01, -2.887740e-01, -2.909538e-02,  4.172906e-01, -2.931356e-01},
  {-3.847239e-01,  6.572031e-01,  6.481292e-01, -3.120580e-01,  3.163208e-01, -3.957397e-01},
  { 7.962497e-01,  1.616997e-01, -5.829577e-01,  3.664012e-01,  4.512142e-01, -2.948343e-01},
  {-3.268629e-02,  4.511155e-01, -8.918667e-01,  1.437084e-01,  4.416115e-01, -4.009963e-01},
  { 2.455724e-02,  4.251833e-01, -9.047741e-01,  1.689741e-01,  4.428952e-01, -4.012917e-01},
  { 7.013650e-01,  1.909946e-01, -6.867374e-01,  3.420726e-01,  4.561941e-01, -3.218768e-01},
  { 2.234051e-01,  3.512950e-01, -9.092206e-01,  2.284137e-01,  4.555474e-01, -3.882524e-01},
  { 3.825700e-01,  2.859697e-01, -8.785565e-01,  2.638260e-01,  4.602073e-01, -3.748192e-01},
  {-5.797241e-01,  7.932644e-01, -1.861493e-01, -2.489343e-02,  3.959108e-01, -3.529478e-01},
  { 5.365754e-01,  2.315732e-01, -8.114558e-01,  2.990291e-01,  4.602097e-01, -3.560592e-01},
  {-8.808493e-02,  7.352511e-01, -6.720467e-01,  4.005819e-02,  4.025327e-01, -4.111494e-01},
  {-5.827252e-01,  7.621925e-01,  2.819466e-01, -3.132139e-01,  3.767594e-01, -4.967560e-01},
  { 2.331588e-02,  9.221861e-01, -3.860429e-01,  1.892229e-02,  3.831189e-01, -4.485870e-01},
  {-7.556307e-01,  6.546428e-01,  2.156762e-02, -3.196375e-01,  3.826920e-01, -5.560988e-01},
  {-8.866153e-01,  3.333262e-01, -3.206353e-01, -3.630915e-01,  2.744159e-01, -6.392869e-01},
  { 6.114633e-01,  6.969716e-01,  3.746241e-01,  2.403197e-02,  3.614857e-01, -5.665016e-01},
  {-8.797947e-01,  4.183339e-01, -2.257389e-01, -3.534451e-01,  3.105578e-01, -6.183510e-01},
  {-8.398671e-01,  4.910402e-01, -2.313064e-01, -3.315744e-01,  3.543963e-01, -6.117843e-01},
  {-7.748608e-01,  4.729488e-01, -4.194164e-01, -3.012248e-01,  3.635510e-01, -6.885706e-01},
  {-7.826843e-01,  4.241267e-01, -4.555456e-01, -2.724690e-01,  3.849816e-01, -7.254050e-01},
  { 9.231876e-01,  1.340842e-01, -3.602027e-01,  2.861468e-02,  3.233691e-01, -7.699397e-01},
  { 9.542117e-01,  1.841097e-01, -2.357619e-01,  3.381483e-02,  3.288173e-01, -7.489072e-01},
  { 6.195443e-01,  2.421855e-02, -7.845881e-01, -1.705635e-02,  3.208882e-01, -8.344967e-01},
  {-3.142227e-01,  1.418106e-01, -9.386979e-01, -1.305338e-01,  3.735014e-01, -8.556593e-01},
  {-3.596796e-01,  2.331680e-01, -9.034728e-01, -1.330423e-01,  3.866286e-01, -8.518097e-01},
  { 3.457458e-01,  1.278052e-01, -9.295835e-01, -6.209390e-02,  3.467057e-01, -8.580086e-01},
  {-9.495765e-02,  1.005193e-01, -9.903933e-01, -1.063528e-01,  3.627880e-01, -8.631014e-01},
  { 1.193807e-01,  7.791618e-02, -9.897864e-01, -7.815750e-02,  3.423887e-01, -8.639070e-01},
  { 2.233149e-01,  1.674022e-01, -9.602640e-01, -8.405405e-02,  3.550162e-01, -8.633546e-01},
  { 7.727448e-01,  9.410016e-02,  6.277026e-01,  3.985060e-01,  4.663633e-01,  7.914557e-01},
  { 8.387023e-01,  5.150157e-02,  5.421495e-01,  4.161468e-01,  4.810349e-01,  7.642835e-01},
  {-6.934182e-02,  2.336726e-01,  9.698396e-01,  2.893777e-01,  4.906667e-01,  8.290812e-01},
  { 6.109377e-01,  3.995140e-02,  7.906699e-01,  3.821615e-01,  4.622505e-01,  8.064992e-01},
  { 5.524542e-01,  8.918577e-02,  8.287582e-01,  3.693984e-01,  4.593549e-01,  8.155485e-01},
  { 9.318615e-01, -8.954414e-02,  3.515907e-01,  4.395718e-01,  4.881958e-01,  7.232816e-01},
  {-3.593501e-01,  2.014063e-01,  9.112096e-01,  1.702825e-01,  5.096755e-01,  7.927774e-01},
  {-5.351875e-01,  1.637094e-01,  8.287181e-01,  1.338849e-01,  5.194179e-01,  7.727137e-01},
  { 9.811306e-01, -6.221579e-02,  1.830623e-01,  4.837250e-01,  5.037007e-01,  5.955936e-01},
  {-7.804826e-01,  3.415435e-01,  5.236362e-01, -1.655834e-01,  5.569974e-01,  4.823315e-01},
  {-9.057857e-01,  3.947875e-01,  1.539321e-01, -3.547968e-01,  3.547348e-01,  2.499533e-01},
  {-6.961908e-01,  2.155186e-01, -6.847410e-01, -2.585064e-01,  4.302031e-01,  2.881898e-02},
  {-8.411052e-01,  2.308108e-01, -4.891507e-01, -6.638921e-02,  4.549912e-01, -1.856392e-01},
  { 8.912014e-01,  1.692104e-01, -4.208656e-01,  3.929352e-01,  4.620458e-01, -2.489274e-01},
  { 8.014610e-01,  1.573451e-01, -5.769772e-01,  3.705971e-01,  4.734444e-01, -2.831423e-01},
  {-6.024248e-01,  7.488167e-01, -2.763297e-01, -1.139463e-02,  4.234488e-01, -3.191261e-01},
  {-1.844834e-01,  4.402409e-01, -8.787228e-01,  1.318164e-01,  4.576171e-01, -3.906062e-01},
  {-4.457650e-01,  7.380983e-01,  5.064627e-01, -3.061887e-01,  3.471696e-01, -4.284377e-01},
  { 2.607286e-01,  3.043697e-01, -9.161767e-01,  2.505916e-01,  4.834085e-01, -3.721035e-01},
  {-5.766700e-01,  7.591201e-01, -3.019741e-01, -1.260496e-02,  4.047932e-01, -3.536516e-01},
  {-5.333520e-01,  7.414204e-01, -4.072240e-01, -3.038415e-04,  4.143636e-01, -3.533506e-01},
  { 5.865900e-01,  2.016149e-01, -7.843874e-01,  3.207430e-01,  4.843208e-01, -3.337584e-01},
  { 4.231020e-01,  2.679784e-01, -8.655474e-01,  2.769999e-01,  4.865736e-01, -3.609760e-01},
  {-4.347483e-01,  8.888710e-01, -1.445761e-01, -1.561504e-02,  3.940637e-01, -3.815841e-01},
  {-4.790995e-01,  7.809755e-01,  4.006758e-01, -3.054593e-01,  3.683144e-01, -4.627086e-01},
  {-3.441630e-02,  8.143619e-01,  5.793360e-01, -1.482597e-01,  3.939064e-01, -4.380067e-01},
  {-6.644942e-01,  7.266511e-01,  1.744291e-01, -3.102355e-01,  3.868527e-01, -5.211079e-01},
  { 3.562710e-01,  8.766164e-01,  3.234420e-01, -3.940337e-02,  4.006001e-01, -4.912306e-01},
  { 5.177132e-01,  8.036470e-01,  2.934699e-01, -2.692685e-02,  3.949324e-01, -4.931840e-01},
  { 6.956443e-01,  7.025498e-01,  1.500087e-01,  6.673900e-03,  3.790510e-01, -5.376627e-01},
  { 3.292829e-01,  8.344302e-01,  4.419265e-01, -6.378444e-02,  4.127470e-01, -4.933679e-01},
  {-8.668209e-01,  3.840193e-01, -3.180420e-01, -3.507198e-01,  2.936555e-01, -6.513206e-01},
  {-8.561559e-01,  4.558961e-01, -2.432198e-01, -3.440054e-01,  3.260773e-01, -6.241862e-01},
  { 9.073827e-01,  4.132393e-01,  7.674588e-02,  2.693731e-02,  3.675118e-01, -6.265079e-01},
  {-8.476856e-01,  4.258827e-01, -3.163115e-01, -3.348817e-01,  3.203517e-01, -6.595669e-01},
  { 9.505392e-01,  3.080507e-01,  3.974946e-02,  3.338603e-02,  3.602628e-01, -6.815012e-01},
  { 9.702258e-01,  2.223916e-01, -9.593776e-02,  3.923334e-02,  3.367337e-01, -7.056819e-01},
  {-7.252369e-01,  4.452828e-01, -5.251236e-01, -2.411031e-01,  4.070536e-01, -7.549430e-01},
  {-6.077582e-01,  4.201929e-01, -6.738457e-01, -1.888839e-01,  4.293569e-01, -7.962034e-01},
  { 8.427978e-01,  4.157739e-02, -5.366220e-01,  1.386916e-02,  3.133664e-01, -8.011975e-01},
  { 9.645061e-01,  1.854441e-01, -1.879853e-01,  3.193576e-02,  3.516707e-01, -7.357173e-01},
  { 7.193335e-01,  6.863616e-03, -6.946310e-01, -2.262411e-03,  3.196844e-01, -8.214737e-01},
  {-5.079775e-01,  4.046818e-01, -7.603891e-01, -1.574832e-01,  4.384319e-01, -8.166394e-01},
  {-3.749530e-01,  3.901114e-01, -8.409657e-01, -1.414223e-01,  4.204910e-01, -8.346507e-01},
  {-3.372838e-01,  2.523377e-01, -9.069539e-01, -1.228998e-01,  3.969115e-01, -8.525144e-01},
  { 4.179334e-01,  1.210523e-01, -9.003766e-01, -4.491374e-02,  3.560978e-01, -8.497830e-01},
  { 3.967222e-01,  1.343824e-01, -9.080489e-01, -4.501285e-02,  3.661805e-01, -8.485640e-01},
  {-2.611360e-01,  1.314143e-01, -9.563149e-01, -1.194938e-01,  3.734634e-01, -8.595099e-01},
  { 3.519627e-01,  1.693927e-01,  9.205587e-01,  3.483540e-01,  4.653084e-01,  8.258687e-01},
  { 1.368360e-01,  1.768325e-01,  9.746827e-01,  3.244440e-01,  4.619554e-01,  8.334383e-01},
  { 9.394624e-01, -1.529131e-01,  3.066400e-01,  4.524065e-01,  5.197484e-01,  6.980415e-01},
  {-4.782874e-01,  2.248566e-01,  8.489291e-01,  8.864998e-03,  4.735479e-01,  7.157139e-01},
  { 9.700151e-01,  1.172496e-03,  2.430419e-01,  4.796562e-01,  5.383777e-01,  6.203874e-01},
  { 9.930512e-01, -1.112308e-01,  3.843108e-02,  4.894060e-01,  4.304232e-01,  4.869553e-01},
  {-8.851516e-01,  2.217840e-01,  4.090457e-01, -2.056812e-01,  5.960315e-01,  3.758788e-01},
  {-9.143042e-01,  6.439290e-02,  3.998766e-01, -2.183568e-01,  5.949829e-01,  3.486105e-01},
  {-9.085442e-01,  2.382056e-01,  3.432281e-01, -2.332987e-01,  5.913514e-01,  3.129935e-01},
  {-9.147566e-01,  3.578995e-01,  1.874257e-01, -2.831799e-01,  5.288754e-01,  2.194318e-01},
  {-7.421101e-01,  4.879908e-02, -6.684993e-01, -1.891116e-01,  5.043509e-01, -2.277798e-02},
  {-7.639924e-01,  2.222693e-01, -6.057326e-01, -2.783823e-01,  4.326821e-01,  5.085225e-02},
  {-8.578099e-01,  3.539383e-01, -3.726792e-01, -3.212826e-01,  4.265610e-01,  1.213605e-01},
  {-8.306091e-01,  1.860915e-01, -5.248413e-01, -6.732254e-02,  4.821985e-01, -1.726732e-01},
  { 9.840838e-01,  8.613476e-02, -1.554340e-01,  4.221406e-01,  3.967043e-01, -1.809208e-01},
  { 9.483249e-01,  1.518668e-01, -2.785971e-01,  4.124528e-01,  4.305170e-01, -2.082698e-01},
  {-8.576133e-01,  2.195269e-01, -4.650886e-01, -3.098955e-02,  4.521272e-01, -2.486657e-01},
  {-8.276144e-01,  3.639781e-01, -4.272870e-01, -2.573871e-02,  4.498505e-01, -2.601423e-01},
  {-1.261028e-01,  6.290958e-01,  7.670311e-01, -2.819473e-01,  3.176490e-01, -3.834763e-01},
  {-3.647533e-01,  6.212291e-01,  6.935628e-01, -3.027658e-01,  3.108039e-01, -3.850907e-01},
  { 8.759276e-01,  9.164765e-02, -4.736575e-01,  3.837973e-01,  4.871984e-01, -2.592862e-01},
  {-5.439948e-02,  7.556249e-01,  6.527416e-01, -2.373078e-01,  3.431976e-01, -3.962070e-01},
  {-2.475654e-01,  4.241149e-01, -8.711131e-01,  1.393553e-01,  4.813200e-01, -3.801117e-01},
  {-3.331454e-01,  4.263886e-01, -8.409560e-01,  9.882890e-02,  4.612465e-01, -3.787736e-01},
  {-4.408727e-01,  7.146688e-01, -5.430284e-01,  2.133169e-02,  4.328874e-01, -3.521121e-01},
  { 7.086766e-01,  1.707824e-01, -6.845516e-01,  3.417521e-01,  5.055803e-01, -3.100877e-01},
  { 2.382659e-01,  2.690193e-01, -9.331977e-01,  2.398830e-01,  5.066103e-01, -3.679105e-01},
  {-3.731504e-01,  6.353708e-01, -6.760641e-01,  6.912206e-02,  4.544200e-01, -3.687775e-01},
  { 4.625531e-01,  1.538049e-01, -8.731487e-01,  2.972717e-01,  5.106918e-01, -3.439165e-01},
  {-4.613325e-01,  8.028888e-01,  3.775473e-01, -2.956897e-01,  3.813156e-01, -4.779952e-01},
  {-6.345859e-01,  7.468122e-01,  1.989278e-01, -3.013209e-01,  3.977903e-01, -5.331163e-01},
  { 5.181504e-01,  8.301141e-01,  2.059874e-01, -1.577576e-02,  3.914809e-01, -5.060779e-01},
  { 1.962471e-01,  7.998220e-01,  5.672493e-01, -1.087769e-01,  4.179415e-01, -4.758010e-01},
  { 5.424811e-01,  7.828443e-01,  3.047443e-01, -3.623693e-02,  4.095301e-01, -5.191590e-01},
  { 6.288542e-01,  7.242014e-01,  2.829749e-01, -1.953675e-02,  4.037758e-01, -5.383950e-01},
  { 7.530874e-01,  6.009486e-01,  2.678062e-01,  7.744728e-03,  3.899311e-01, -5.887240e-01},
  {-8.478670e-01,  4.294928e-01, -3.108978e-01, -3.396972e-01,  3.179070e-01, -6.494349e-01},
  {-8.185102e-01,  5.637351e-01, -1.106510e-01, -3.095742e-01,  3.887158e-01, -6.128414e-01},
  {-6.658822e-01,  4.698398e-01, -5.795270e-01, -2.137546e-01,  4.281426e-01, -7.711234e-01},
  { 9.261164e-01,  9.779269e-02, -3.643419e-01,  2.186138e-02,  3.440650e-01, -7.811499e-01},
  { 5.809366e-01,  7.113081e-02, -8.108348e-01, -1.995343e-02,  3.504677e-01, -8.350745e-01},
  { 2.107306e-01,  1.829259e-01, -9.602763e-01, -7.182136e-02,  3.857465e-01, -8.541080e-01},
  { 8.382897e-01,  2.251750e-02,  5.447599e-01,  4.246648e-01,  5.156302e-01,  7.487820e-01},
  {-2.227442e-01,  2.245842e-01,  9.486553e-01,  2.459738e-01,  5.038674e-01,  8.197948e-01},
  { 1.311036e-01,  2.105132e-01,  9.687601e-01,  3.222762e-01,  4.855643e-01,  8.285816e-01},
  { 8.990567e-01, -3.134129e-02,  4.367088e-01,  4.496273e-01,  5.275936e-01,  7.052452e-01},
  {-5.599616e-01,  2.456625e-01,  7.912603e-01, -1.950354e-02,  4.776869e-01,  6.964546e-01},
  {-4.752853e-01,  2.679268e-01,  8.380448e-01,  5.558730e-02,  5.290046e-01,  7.246649e-01},
  {-7.660912e-01,  2.276543e-01,  6.010639e-01, -1.301565e-01,  4.882884e-01,  5.746548e-01},
  { 9.932137e-01, -7.911202e-02,  8.525248e-02,  4.908591e-01,  4.798567e-01,  5.341116e-01},
  {-7.665357e-01,  3.418267e-01,  5.436704e-01, -1.271062e-01,  5.603574e-01,  5.379459e-01},
  { 9.946929e-01, -8.660877e-02, -5.554096e-02,  4.868514e-01,  4.357272e-01,  3.811837e-01},
  {-8.693904e-01,  4.297489e-01,  2.438775e-01, -3.126276e-01,  4.323246e-01,  2.732297e-01},
  { 9.860703e-01, -7.141341e-02, -1.502183e-01,  4.348988e-01,  4.052086e-01,  4.745200e-02},
  {-9.006671e-01,  4.195248e-01,  1.131263e-01, -3.040063e-01,  4.836782e-01,  2.084217e-01},
  {-7.598032e-01,  1.195966e-01, -6.390585e-01, -9.857024e-02,  5.236179e-01, -1.213647e-01},
  { 9.996647e-01, -1.538239e-03, -2.584725e-02,  4.308137e-01,  4.029729e-01, -8.250697e-02},
  {-8.837385e-01,  2.772782e-01, -3.769923e-01, -3.045426e-01,  4.507982e-01,  1.011365e-01},
  {-7.720217e-01,  3.869652e-01, -5.042228e-01, -4.868632e-03,  4.686966e-01, -2.782905e-01},
  {-7.599484e-01,  2.454665e-01, -6.018510e-01,  3.745133e-03,  4.720573e-01, -2.881866e-01},
  { 7.976912e-01,  1.011446e-01, -5.945237e-01,  3.721307e-01,  5.177255e-01, -2.713996e-01},
  {-4.412940e-01,  5.777714e-01, -6.866148e-01,  2.252457e-02,  4.669896e-01, -3.169239e-01},
  {-5.842208e-01,  4.262330e-01, -6.906602e-01,  2.186956e-02,  4.762823e-01, -3.085006e-01},
  { 2.760516e-03,  3.134915e-01, -9.495870e-01,  1.956032e-01,  5.180611e-01, -3.703973e-01},
  { 6.579471e-02,  3.422895e-01, -9.372880e-01,  1.899899e-01,  5.036004e-01, -3.755757e-01},
  { 5.886545e-01,  1.344492e-01, -7.971256e-01,  3.208955e-01,  5.372241e-01, -3.224192e-01},
  { 2.138709e-01,  7.931638e-02, -9.736365e-01,  2.635620e-01,  5.282599e-01, -3.552150e-01},
  { 3.839521e-01,  1.400622e-01, -9.126683e-01,  2.757865e-01,  5.245004e-01, -3.515577e-01},
  {-5.157599e-01,  8.028645e-01,  2.989989e-01, -2.898485e-01,  3.960162e-01, -5.039572e-01},
  {-6.436712e-03,  8.030183e-01,  5.959195e-01, -1.413563e-01,  4.106854e-01, -4.602171e-01},
  {-6.205720e-01,  7.635748e-01,  1.784489e-01, -2.954663e-01,  4.061865e-01, -5.477840e-01},
  {-7.296997e-01,  6.836566e-01,  1.232558e-02, -2.977873e-01,  4.073437e-01, -5.692955e-01},
  { 4.369154e-01,  7.993469e-01,  4.124919e-01, -5.792028e-02,  4.300686e-01, -5.306529e-01},
  {-7.391695e-01,  6.733241e-01,  1.621885e-02, -2.968819e-01,  4.085981e-01, -5.849183e-01},
  { 8.959056e-01,  4.138144e-01,  1.615882e-01,  1.448484e-02,  3.972848e-01, -6.356087e-01},
  { 9.220248e-01,  3.651044e-01,  1.287203e-01,  2.069354e-02,  3.923221e-01, -6.619660e-01},
  {-7.860355e-01,  6.069366e-01, -1.173715e-01, -2.919464e-01,  4.099146e-01, -6.255090e-01},
  {-8.327017e-01,  5.044406e-01, -2.283583e-01, -3.031066e-01,  3.881021e-01, -6.434724e-01},
  { 9.618226e-01,  2.721983e-01, -2.837966e-02,  2.839991e-02,  3.761548e-01, -7.137207e-01},
  {-6.489213e-01,  5.060788e-01, -5.681422e-01, -1.879474e-01,  4.553713e-01, -7.776672e-01},
  {-5.886112e-01,  4.728647e-01, -6.556948e-01, -1.726691e-01,  4.580410e-01, -7.916154e-01},
  {-8.319700e-01,  4.563263e-01, -3.155823e-01, -2.719538e-01,  4.102914e-01, -7.009231e-01},
  { 9.302233e-01,  1.086332e-01, -3.505476e-01,  1.834320e-02,  3.661726e-01, -7.846136e-01},
  { 7.266731e-01,  4.792250e-02, -6.853098e-01, -1.529757e-03,  3.450005e-01, -8.194197e-01},
  {-4.791048e-01,  4.543023e-01, -7.510445e-01, -1.447463e-01,  4.609761e-01, -8.117572e-01},
  {-3.512617e-01,  4.207898e-01, -8.363918e-01, -1.294549e-01,  4.510126e-01, -8.247304e-01},
  {-2.243690e-01,  3.108491e-01, -9.235970e-01, -1.099898e-01,  3.995708e-01, -8.560113e-01},
  { 1.549674e-01,  2.927835e-01, -9.435375e-01, -8.985208e-02,  3.982859e-01, -8.554261e-01},
  {-9.266788e-02,  2.159837e-01, -9.719895e-01, -1.031668e-01,  3.951584e-01, -8.578563e-01},
  { 6.982144e-01,  1.478758e-01,  7.004495e-01,  3.858015e-01,  5.085627e-01,  7.950029e-01},
  { 8.200138e-01,  4.381517e-02,  5.706642e-01,  4.323843e-01,  5.430115e-01,  7.352323e-01},
  {-3.149216e-01,  2.533020e-01,  9.146926e-01,  2.281187e-01,  5.386245e-01,  8.059127e-01},
  { 4.672521e-01,  1.732444e-01,  8.669844e-01,  3.594276e-01,  4.959299e-01,  8.144553e-01},
  {-3.753805e-01,  2.580291e-01,  8.902305e-01,  1.778708e-01,  5.402340e-01,  7.880486e-01},
  { 9.058441e-01, -7.997428e-03,  4.235358e-01,  4.525718e-01,  5.488260e-01,  6.997123e-01},
  {-7.197756e-01,  2.591953e-01,  6.440037e-01, -7.473046e-02,  4.933578e-01,  6.385093e-01},
  {-3.956454e-01,  2.839708e-01,  8.733987e-01,  1.600705e-01,  5.606440e-01,  7.736868e-01},
  {-7.305886e-01,  2.513142e-01,  6.348869e-01, -8.948333e-02,  4.933195e-01,  6.218603e-01},
  { 9.544397e-01, -7.467212e-02,  2.889099e-01,  4.650214e-01,  5.529634e-01,  6.666117e-01},
  {-5.110627e-01,  2.797389e-01,  8.127491e-01,  1.578113e-02,  5.167078e-01,  7.067783e-01},
  { 9.827045e-01, -1.733930e-02,  1.843672e-01,  4.892893e-01,  5.548415e-01,  5.792960e-01},
  { 9.948882e-01, -9.331132e-02,  3.860432e-02,  4.922952e-01,  4.618447e-01,  4.932701e-01},
  {-7.576221e-01,  2.026787e-01, -6.204273e-01, -1.794282e-01,  5.350720e-01, -2.725716e-02},
  {-9.163107e-01,  3.957249e-01, -6.145325e-02, -3.088538e-01,  4.767097e-01,  1.570060e-01},
  {-7.430917e-01,  5.302051e-02, -6.670858e-01, -2.505814e-01,  4.957195e-01,  4.012837e-02},
  {-7.732927e-01,  1.170864e-01, -6.231446e-01, -2.706436e-01,  4.913487e-01,  6.296488e-02},
  { 9.757026e-01,  3.775050e-02, -2.158229e-01,  4.251336e-01,  4.600029e-01, -1.330480e-01},
  {-7.735939e-01,  6.284154e-02, -6.305581e-01, -3.886263e-02,  5.050783e-01, -2.041906e-01},
  { 9.159970e-01,  9.719132e-03, -4.010673e-01,  4.006183e-01,  4.995983e-01, -2.229885e-01},
  { 8.572425e-01,  7.234447e-02, -5.098055e-01,  3.797169e-01,  5.382085e-01, -2.567709e-01},
  {-3.255779e-01,  7.688729e-01,  5.503032e-01, -2.820267e-01,  3.566206e-01, -4.247457e-01},
  { 7.288889e-01,  5.761325e-02, -6.822035e-01,  3.446398e-01,  5.558478e-01, -2.988014e-01},
  {-4.661824e-01,  3.285173e-01, -8.214319e-01,  8.996958e-02,  5.121362e-01, -3.451849e-01},
  {-5.988982e-01,  3.291251e-01, -7.300669e-01,  7.232040e-02,  5.019209e-01, -3.388607e-01},
  { 9.456344e-02,  1.121470e-01, -9.891819e-01,  2.402901e-01,  5.478966e-01, -3.564905e-01},
  {-3.404448e-01,  7.917013e-01,  5.072536e-01, -2.788358e-01,  3.751086e-01, -4.498363e-01},
  { 5.646492e-01,  9.951078e-02, -8.193100e-01,  3.146624e-01,  5.662863e-01, -3.226410e-01},
  { 2.610244e-01,  2.246783e-01, -9.388216e-01,  2.563070e-01,  5.553246e-01, -3.508724e-01},
  { 3.971796e-01,  1.651962e-01, -9.027505e-01,  2.903837e-01,  5.640770e-01, -3.369519e-01},
  {-4.590373e-01,  8.128037e-01,  3.586570e-01, -2.814264e-01,  3.975554e-01, -4.958115e-01},
  {-5.236527e-01,  8.036789e-01,  2.826447e-01, -2.863261e-01,  4.074837e-01, -5.284871e-01},
  {-7.529653e-01,  5.930735e-01, -2.851439e-01, -2.876217e-01,  4.073267e-01, -6.553356e-01},
  {-6.228002e-01,  5.974334e-01, -5.051666e-01, -2.927339e-01,  3.950559e-01, -6.647554e-01},
  {-6.854780e-01,  5.489383e-01, -4.783164e-01, -2.129280e-01,  4.525470e-01, -7.495160e-01},
  {-7.047037e-01,  5.195500e-01, -4.831775e-01, -2.403147e-01,  4.360866e-01, -7.287961e-01},
  { 8.444099e-01,  7.428783e-02, -5.305216e-01,  9.003570e-03,  3.587422e-01, -8.046048e-01},
  {-8.385351e-01,  4.699354e-01, -2.757162e-01, -2.612833e-01,  4.270166e-01, -7.047698e-01},
  { 9.531488e-01,  1.548056e-01, -2.598893e-01,  1.759825e-02,  3.919882e-01, -7.763314e-01},
  {-3.966049e-01,  4.948268e-01, -7.732083e-01, -1.320145e-01,  4.664486e-01, -8.156699e-01},
  { 7.134405e-01,  9.852713e-02, -6.937544e-01, -3.134942e-03,  3.687564e-01, -8.188905e-01},
  {-6.306937e-02,  3.949649e-01, -9.165288e-01, -1.043757e-01,  4.206956e-01, -8.473283e-01},
  { 5.530891e-01,  1.216721e-01, -8.241895e-01, -2.505789e-02,  3.899442e-01, -8.346063e-01},
  { 4.401629e-01,  1.919032e-01, -8.771715e-01, -3.788253e-02,  3.992665e-01, -8.399629e-01},
  {-7.809264e-03,  2.226756e-01,  9.748613e-01,  2.987058e-01,  5.394313e-01,  8.178422e-01},
  {-1.768400e-01,  2.315102e-01,  9.566246e-01,  2.626786e-01,  5.542169e-01,  8.107381e-01},
  { 2.455528e-01,  2.071332e-01,  9.469951e-01,  3.374318e-01,  5.019251e-01,  8.217652e-01},
  {-6.568167e-01,  2.880659e-01,  6.968572e-01, -5.149832e-02,  4.923759e-01,  6.637045e-01},
  { 8.937526e-01,  1.970769e-02,  4.481272e-01,  4.517783e-01,  5.654942e-01,  7.014267e-01},
  {-6.570830e-01,  2.991857e-01,  6.919031e-01, -2.446422e-02,  5.158882e-01,  6.791541e-01},
  { 9.033488e-01,  3.704718e-02,  4.273038e-01,  4.561850e-01,  5.882322e-01,  6.909006e-01},
  {-4.553499e-01,  3.001822e-01,  8.381808e-01,  1.486318e-01,  5.722772e-01,  7.638578e-01},
  {-7.580405e-01,  3.125063e-01,  5.724635e-01, -1.133373e-01,  5.193440e-01,  5.792119e-01},
  {-4.001675e-01,  3.163381e-01,  8.601142e-01,  2.665443e-02,  5.637348e-01,  6.959510e-01},
  {-3.097729e-01,  3.312699e-01,  8.912356e-01,  2.909105e-02,  5.850600e-01,  6.892158e-01},
  {-4.659948e-01,  3.139024e-01,  8.272328e-01,  1.125396e-01,  5.909857e-01,  7.370327e-01},
  { 9.886992e-01, -9.903207e-02, -1.125462e-01,  4.839512e-01,  5.014501e-01,  2.980047e-01},
  { 9.977617e-01, -4.059239e-02, -5.314020e-02,  4.307799e-01,  4.186259e-01, -2.897475e-03},
  {-8.988308e-01,  4.347026e-01, -5.600780e-02, -2.913735e-01,  5.184075e-01,  1.819938e-01},
  {-8.695825e-01,  4.775667e-01, -1.255241e-01, -3.008156e-01,  4.958397e-01,  1.564952e-01},
  {-8.770913e-01,  4.175393e-01, -2.374275e-01, -3.047005e-01,  4.777811e-01,  1.309953e-01},
  {-8.420821e-01,  2.638112e-01, -4.704268e-01, -2.886277e-01,  4.750814e-01,  8.394700e-02},
  {-7.910891e-01,  2.881471e-01, -5.395826e-01, -2.637904e-01,  5.063543e-01,  6.032814e-02},
  {-7.918521e-01,  2.683345e-01, -5.486045e-01, -2.673542e-01,  4.999671e-01,  6.202513e-02},
  {-7.180680e-01, -1.444691e-01, -6.808136e-01, -1.403937e-02,  5.161189e-01, -2.340646e-01},
  {-2.751293e-01,  6.941017e-01,  6.652268e-01, -2.756737e-01,  3.390126e-01, -3.989675e-01},
  { 1.149491e-02,  6.636938e-01,  7.479159e-01, -2.673500e-01,  3.470412e-01, -4.056308e-01},
  {-7.426861e-01,  3.888128e-01, -5.451989e-01,  2.615972e-02,  5.048100e-01, -2.935883e-01},
  {-1.047382e-01,  7.260281e-01,  6.796418e-01, -2.608925e-01,  3.546111e-01, -4.128377e-01},
  { 8.313638e-01,  3.256457e-02, -5.547736e-01,  3.758647e-01,  5.639663e-01, -2.600775e-01},
  {-6.863008e-01,  1.938272e-01, -7.010152e-01,  5.498556e-02,  5.173821e-01, -3.160449e-01},
  { 7.849950e-01,  6.282261e-02, -6.163084e-01,  3.656661e-01,  5.708494e-01, -2.734258e-01},
  {-2.371426e-02,  1.917260e-01, -9.811620e-01,  2.069784e-01,  5.668720e-01, -3.557197e-01},
  { 6.628814e-01,  6.358945e-02, -7.460192e-01,  3.409693e-01,  5.844548e-01, -2.994723e-01},
  { 4.951825e-01,  9.802549e-02, -8.632411e-01,  3.050292e-01,  5.917939e-01, -3.256011e-01},
  { 4.140391e-01,  1.192126e-01, -9.024189e-01,  2.912533e-01,  5.873425e-01, -3.330079e-01},
  { 2.460349e-01,  1.686265e-01, -9.544799e-01,  2.543842e-01,  5.838403e-01, -3.453336e-01},
  {-3.547747e-01,  8.056310e-01,  4.744403e-01, -2.684706e-01,  3.851077e-01, -4.588067e-01},
  {-7.676791e-02,  8.452502e-01,  5.288276e-01, -1.626965e-01,  4.204147e-01, -4.741563e-01},
  {-4.996550e-01,  8.117532e-01,  3.023274e-01, -2.765255e-01,  4.156289e-01, -5.338023e-01},
  {-5.149016e-01,  8.122603e-01,  2.740611e-01, -2.760077e-01,  4.191337e-01, -5.428107e-01},
  { 4.463157e-01,  7.577046e-01,  4.761156e-01, -7.907607e-02,  4.467901e-01, -5.358548e-01},
  {-6.989339e-01,  7.116540e-01,  7.099278e-02, -2.844840e-01,  4.220205e-01, -5.886784e-01},
  { 8.073122e-01,  5.261949e-01,  2.671439e-01, -6.286385e-03,  4.331642e-01, -6.319103e-01},
  {-7.289893e-01,  6.831195e-01, -4.384485e-02, -2.756797e-01,  4.306713e-01, -6.231776e-01},
  { 9.181870e-01,  3.874725e-01,  8.244853e-02,  1.317667e-02,  4.203889e-01, -6.978562e-01},
  {-8.076117e-01,  5.592485e-01, -1.870945e-01, -2.707911e-01,  4.272000e-01, -6.709486e-01},
  { 9.409902e-01,  3.383814e-01,  5.955278e-03,  1.647156e-02,  4.157567e-01, -7.252434e-01},
  { 9.602076e-01,  2.677080e-01, -7.958385e-02,  1.704272e-02,  4.116528e-01, -7.514980e-01},
  { 9.419691e-01,  2.018128e-01, -2.682647e-01,  1.346215e-02,  4.069736e-01, -7.820898e-01},
  {-1.819032e-01,  4.232783e-01, -8.875510e-01, -1.038833e-01,  4.506888e-01, -8.329182e-01},
  { 1.190127e-01,  4.422404e-01, -8.889654e-01, -5.713528e-02,  4.626165e-01, -8.284270e-01},
  { 1.253999e-01,  2.344716e-01, -9.640009e-01, -7.311893e-02,  4.393377e-01, -8.392372e-01},
  { 5.666218e-01,  1.938825e-01, -8.008428e-01, -2.118875e-02,  4.024775e-01, -8.294167e-01},
  { 2.925422e-01,  2.429094e-01, -9.248860e-01, -4.751244e-02,  4.163875e-01, -8.400541e-01},
  { 7.011834e-01,  9.910078e-02,  7.060601e-01,  4.072000e-01,  5.718538e-01,  7.644170e-01},
  { 1.091814e-02,  2.479481e-01,  9.687118e-01,  2.990197e-01,  5.568141e-01,  8.138995e-01},
  { 1.947888e-01,  2.275331e-01,  9.540891e-01,  3.287658e-01,  5.356181e-01,  8.159926e-01},
  {-1.078015e-01,  2.527960e-01,  9.614952e-01,  2.718981e-01,  5.692947e-01,  8.084260e-01},
  { 8.298831e-01,  6.450137e-02,  5.541964e-01,  4.352129e-01,  5.857691e-01,  7.268393e-01},
  {-2.498217e-01,  2.583881e-01,  9.331799e-01,  2.383326e-01,  5.687763e-01,  8.014984e-01},
  {-4.191611e-01,  3.081505e-01,  8.540183e-01,  1.721026e-01,  5.895993e-01,  7.694588e-01},
  {-5.951656e-01,  3.086675e-01,  7.419583e-01, -1.233597e-02,  5.581961e-01,  6.722784e-01},
  { 9.551555e-01,  5.846219e-03,  2.960470e-01,  4.689226e-01,  6.089740e-01,  6.547428e-01},
  { 9.935197e-01, -2.905558e-02,  1.098840e-01,  4.954507e-01,  5.482894e-01,  5.329171e-01},
  { 9.834465e-01,  1.517675e-02,  1.805619e-01,  4.911212e-01,  5.723501e-01,  5.684540e-01},
  {-8.164222e-01,  3.535990e-01,  4.565333e-01, -1.594529e-01,  6.342794e-01,  4.367077e-01},
  {-8.865315e-01,  3.367215e-01,  3.173022e-01, -2.142959e-01,  6.386650e-01,  3.146982e-01},
  {-8.881093e-01,  3.659719e-01,  2.780763e-01, -2.321422e-01,  6.364036e-01,  2.661910e-01},
  { 9.883742e-01, -6.280322e-02, -1.384632e-01,  4.351275e-01,  4.485717e-01,  2.910471e-02},
  { 9.775943e-01, -1.151673e-01, -1.761982e-01,  4.675899e-01,  5.745223e-01,  1.223185e-01},
  { 9.983288e-01, -5.392456e-02, -2.077773e-02,  4.311330e-01,  4.513787e-01, -1.801890e-02},
  {-7.397674e-01,  3.445557e-01, -5.779494e-01, -6.999891e-03,  5.366700e-01, -2.344420e-01},
  { 9.471848e-01,  2.629392e-02, -3.196085e-01,  4.099374e-01,  5.122747e-01, -1.957446e-01},
  {-7.371461e-01,  1.734841e-01, -6.530840e-01,  3.216225e-02,  5.335725e-01, -2.841327e-01},
  {-1.682832e-01,  3.141069e-01, -9.343542e-01,  1.543741e-01,  5.688862e-01, -3.494838e-01},
  {-1.928676e-01,  7.755966e-01,  6.010425e-01, -2.385083e-01,  3.823674e-01, -4.405989e-01},
  { 7.494456e-01,  5.825249e-02, -6.594982e-01,  3.514298e-01,  6.035643e-01, -2.880352e-01},
  { 7.007512e-02,  2.062871e-01, -9.759790e-01,  2.123128e-01,  5.984603e-01, -3.481109e-01},
  { 7.079849e-01, -9.331177e-02, -7.000358e-01,  3.389592e-01,  6.518067e-01, -3.003073e-01},
  { 2.038688e-01,  1.823073e-01, -9.618740e-01,  2.631887e-01,  6.083148e-01, -3.389733e-01},
  { 3.334141e-01,  1.750556e-01, -9.263858e-01,  2.811729e-01,  6.074545e-01, -3.340005e-01},
  { 5.309514e-01,  1.813131e-02, -8.472083e-01,  3.165854e-01,  6.254618e-01, -3.167935e-01},
  { 6.881979e-01, -1.046828e-01, -7.179312e-01,  3.311420e-01,  6.434540e-01, -3.078867e-01},
  {-5.728493e-01,  7.966335e-01,  1.929214e-01, -2.698146e-01,  4.270816e-01, -5.553404e-01},
  { 8.667980e-01,  4.741822e-01,  1.543126e-01, -1.453670e-03,  4.404183e-01, -6.669465e-01},
  {-7.567309e-01,  6.484566e-01, -8.283853e-02, -2.635138e-01,  4.418193e-01, -6.475698e-01},
  {-6.666259e-01,  5.907060e-01, -4.546168e-01, -1.930133e-01,  4.740975e-01, -7.530123e-01},
  {-5.280951e-01,  5.654659e-01, -6.335329e-01, -1.472864e-01,  4.884861e-01, -7.909921e-01},
  {-8.809777e-01,  3.469500e-01, -3.217202e-01, -2.566484e-01,  4.378124e-01, -7.016394e-01},
  { 8.616398e-01,  1.412598e-01, -4.874654e-01,  5.906102e-03,  4.000089e-01, -8.016039e-01},
  { 1.300216e-01,  5.157704e-01, -8.468029e-01, -7.597786e-02,  4.819207e-01, -8.196984e-01},
  { 7.645242e-01,  2.009229e-01, -6.124807e-01, -3.462719e-03,  4.072931e-01, -8.120122e-01},
  { 8.717735e-01,  2.802548e-01, -4.018313e-01,  7.641793e-03,  4.186198e-01, -7.904095e-01},
  { 3.992905e-01,  4.820544e-01, -7.798657e-01, -4.303866e-02,  4.641184e-01, -8.212805e-01},
  { 4.140998e-01,  3.499283e-01, -8.402807e-01, -4.660932e-02,  4.521259e-01, -8.294491e-01},
  { 2.138575e-01,  2.690803e-01, -9.390744e-01, -5.581746e-02,  4.418898e-01, -8.366011e-01},
  { 3.999746e-01,  2.331263e-01, -8.863816e-01, -4.270127e-02,  4.259826e-01, -8.358186e-01},
  { 7.013881e-01,  1.042106e-01,  7.051205e-01,  4.054821e-01,  5.595043e-01,  7.679697e-01},
  { 7.192630e-01,  5.629159e-02,  6.924536e-01,  4.083715e-01,  5.955012e-01,  7.601485e-01},
  { 8.203959e-01,  6.004107e-02,  5.686350e-01,  4.323930e-01,  5.963892e-01,  7.296310e-01},
  { 3.958293e-01,  1.966709e-01,  8.970171e-01,  3.579109e-01,  5.291674e-01,  8.088563e-01},
  {-5.459310e-01,  3.631602e-01,  7.550325e-01,  1.235244e-02,  5.916713e-01,  6.758444e-01},
  {-7.469795e-01,  3.050257e-01,  5.907461e-01, -9.191620e-02,  5.720190e-01,  5.774283e-01},
  {-7.802570e-01,  3.382646e-01,  5.260950e-01, -1.249420e-01,  6.431921e-01,  4.858428e-01},
  { 9.856524e-01, -1.187747e-01, -1.199244e-01,  4.851263e-01,  5.465295e-01,  2.732983e-01},
  { 9.841436e-01, -1.350873e-01, -1.149470e-01,  4.836138e-01,  5.577207e-01,  2.479403e-01},
  {-9.456304e-01,  2.308353e-01,  2.291250e-01, -2.359763e-01,  6.491814e-01,  2.336936e-01},
  {-9.389129e-01,  2.998464e-01, -1.689218e-01, -2.754141e-01,  5.486580e-01,  1.265203e-01},
  {-7.783362e-01,  2.687496e-01, -5.674207e-01, -2.535107e-01,  5.255320e-01,  5.574618e-02},
  {-8.954431e-01,  2.997204e-01, -3.291646e-01, -2.854791e-01,  5.164656e-01,  1.129578e-01},
  {-9.002367e-01,  3.219447e-01, -2.931306e-01, -2.928646e-01,  4.974043e-01,  1.102133e-01},
  {-8.473122e-01,  3.063990e-01, -4.337991e-01, -2.792317e-01,  5.087341e-01,  8.834738e-02},
  {-7.494157e-01,  2.976003e-01, -5.914476e-01, -5.044706e-02,  5.426946e-01, -1.760318e-01},
  { 9.639798e-01,  1.029331e-01, -2.452500e-01,  4.110748e-01,  5.462548e-01, -1.881107e-01},
  { 9.289894e-01,  7.495983e-02, -3.624358e-01,  4.011085e-01,  5.687620e-01, -2.135644e-01},
  { 8.910454e-01, -1.593407e-04, -4.539143e-01,  3.955693e-01,  5.835117e-01, -2.253197e-01},
  {-6.227434e-01,  3.006991e-01, -7.223369e-01,  7.292546e-02,  5.690149e-01, -3.072230e-01},
  { 5.305074e-01, -5.805911e-02, -8.456897e-01,  3.851766e-01,  7.513011e-01, -2.640287e-01},
  { 6.024665e-01, -3.070324e-02, -7.975534e-01,  3.579497e-01,  6.454722e-01, -2.808470e-01},
  { 7.700145e-01, -4.621999e-02, -6.363502e-01,  3.715055e-01,  6.187680e-01, -2.639547e-01},
  {-2.566179e-01,  2.440289e-01, -9.351990e-01,  1.555924e-01,  5.924108e-01, -3.427615e-01},
  {-1.631192e-01,  2.166441e-01, -9.625266e-01,  1.723339e-01,  6.010184e-01, -3.443964e-01},
  { 7.449418e-01, -1.329342e-01, -6.537510e-01,  3.902747e-01,  7.629661e-01, -2.613611e-01},
  { 5.653798e-02,  1.704341e-01, -9.837458e-01,  2.237847e-01,  6.131268e-01, -3.449596e-01},
  { 2.060793e-01,  1.140783e-01, -9.718629e-01,  2.532985e-01,  6.372406e-01, -3.370071e-01},
  {-4.198955e-01,  3.003699e-01, -8.564261e-01,  1.207786e-01,  5.644590e-01, -3.403477e-01},
  { 4.732864e-01,  8.811959e-02, -8.764901e-01,  3.164774e-01,  6.548085e-01, -3.152663e-01},
  {-4.051867e-01,  8.428847e-01,  3.540751e-01, -2.464352e-01,  4.119429e-01, -4.881432e-01},
  {-5.461506e-01,  8.029487e-01,  2.387319e-01, -2.609954e-01,  4.357234e-01, -5.649082e-01},
  {-6.325958e-01,  7.637188e-01,  1.286708e-01, -2.598142e-01,  4.450654e-01, -5.987021e-01},
  {-6.317634e-01,  7.652670e-01,  1.234562e-01, -2.678212e-01,  4.383684e-01, -5.983315e-01},
  {-6.328385e-01,  5.851792e-01, -5.070313e-01, -1.762600e-01,  4.833004e-01, -7.655224e-01},
  {-6.760158e-01,  5.958121e-01, -4.336019e-01, -1.847775e-01,  4.829901e-01, -7.536960e-01},
  {-6.734949e-01,  6.246707e-01, -3.952101e-01, -2.148147e-01,  4.700461e-01, -7.238225e-01},
  {-7.332200e-01,  6.681222e-01, -1.264955e-01, -2.579004e-01,  4.397968e-01, -6.882399e-01},
  {-7.580451e-01,  6.494934e-01, -5.938015e-02, -2.536229e-01,  4.433106e-01, -6.942320e-01},
  {-6.867706e-01,  6.875635e-01, -2.358018e-01, -2.426990e-01,  4.511034e-01, -7.039772e-01},
  { 9.282944e-01,  3.301462e-01, -1.710940e-01,  1.022903e-02,  4.301036e-01, -7.663931e-01},
  { 3.292319e-01,  5.421100e-01, -7.731256e-01, -5.649702e-02,  4.868508e-01, -8.125076e-01},
  {-7.131917e-01,  5.186820e-01, -4.715151e-01, -2.552199e-01,  4.397269e-01, -7.024923e-01},
  {-7.718049e-01,  4.626508e-01, -4.362011e-01, -2.558861e-01,  4.393054e-01, -7.021318e-01},
  { 8.587980e-01,  4.001052e-01, -3.199716e-01,  3.978598e-03,  4.338972e-01, -7.835847e-01},
  { 6.036537e-01,  4.863133e-01, -6.317449e-01, -3.312922e-02,  4.706364e-01, -8.099922e-01},
  {-1.550266e-01,  4.631525e-01, -8.726148e-01, -1.054920e-01,  4.829912e-01, -8.183044e-01},
  { 7.910579e-01,  3.232522e-01, -5.193606e-01, -2.309231e-03,  4.313606e-01, -7.992788e-01},
  { 7.055693e-01,  2.577915e-01, -6.600874e-01, -5.717202e-03,  4.206870e-01, -8.099080e-01},
  { 5.340558e-01,  3.475157e-01, -7.707251e-01, -3.833978e-02,  4.521718e-01, -8.243130e-01},
  { 5.570352e-01,  2.632555e-01, -7.876600e-01, -2.967854e-02,  4.283963e-01, -8.281322e-01},
  { 2.918232e-01,  1.796341e-01, -9.394524e-01, -4.856420e-02,  4.379987e-01, -8.354324e-01},
  { 4.853050e-01,  2.111922e-01,  8.484556e-01,  3.727961e-01,  5.515585e-01,  7.969559e-01},
  {-3.290993e-01,  2.851605e-01,  9.002095e-01,  2.157008e-01,  6.141577e-01,  7.801504e-01},
  {-3.985110e-01,  2.985413e-01,  8.672151e-01,  1.939951e-01,  6.220236e-01,  7.689098e-01},
  {-7.188012e-01,  2.310728e-01,  6.556906e-01, -4.538172e-02,  5.554078e-01,  6.430808e-01},
  {-5.830914e-01,  3.937657e-01,  7.106004e-01, -9.681376e-03,  5.872511e-01,  6.612102e-01},
  {-4.603739e-01,  3.465886e-01,  8.172712e-01,  3.774830e-02,  6.325696e-01,  6.737748e-01},
  {-8.362190e-01,  3.290803e-01,  4.386845e-01, -1.664729e-01,  6.543722e-01,  4.088664e-01},
  {-8.270316e-01,  4.957382e-01,  2.650703e-01, -2.044156e-01,  6.743415e-01,  3.056106e-01},
  {-8.917471e-01,  3.736062e-01,  2.553539e-01, -2.254975e-01,  6.647111e-01,  2.544373e-01},
  {-9.054154e-01,  3.917800e-01,  1.634977e-01, -2.260520e-01,  6.758687e-01,  2.381884e-01},
  {-9.149095e-01,  3.937660e-01,  8.881917e-02, -2.328134e-01,  6.632173e-01,  2.262471e-01},
  {-9.639097e-01,  2.611290e-01,  5.186119e-02, -2.417153e-01,  6.447788e-01,  2.079622e-01},
  {-7.972214e-01,  1.653766e-01, -5.805933e-01, -1.693477e-01,  6.088524e-01, -2.424568e-02},
  {-7.381288e-01,  2.364903e-01, -6.318530e-01, -2.258961e-01,  5.496352e-01,  3.166953e-02},
  {-8.997502e-01,  3.429825e-01, -2.698380e-01, -2.738349e-01,  5.380034e-01,  1.050308e-01},
  {-9.100261e-01,  2.476580e-01, -3.324424e-01, -2.790322e-01,  5.223168e-01,  1.008751e-01},
  {-9.012952e-01,  3.462846e-01, -2.602957e-01, -2.895498e-01,  5.026582e-01,  1.056746e-01},
  {-8.592774e-01,  2.029907e-01, -4.695073e-01, -2.667008e-01,  5.304973e-01,  8.042512e-02},
  {-8.379093e-01,  3.316558e-01, -4.334887e-01, -2.711317e-01,  5.206231e-01,  8.155198e-02},
  {-7.056223e-01,  4.417011e-01, -5.540733e-01,  2.632061e-02,  5.667518e-01, -2.626633e-01},
  { 8.679083e-01, -1.719816e-01, -4.660016e-01,  4.106678e-01,  7.761764e-01, -2.350972e-01},
  { 4.776243e-01, -1.084162e-01, -8.718491e-01,  3.760214e-01,  7.262373e-01, -2.686574e-01},
  { 7.237285e-01, -1.502097e-01, -6.735385e-01,  3.891855e-01,  7.841874e-01, -2.669600e-01},
  { 3.781922e-01, -5.837131e-02, -9.238850e-01,  3.190303e-01,  7.029603e-01, -3.121378e-01},
  { 5.550411e-01,  8.449905e-04, -8.318225e-01,  3.369728e-01,  6.901757e-01, -3.013165e-01},
  { 4.206792e-02,  1.523806e-01, -9.874262e-01,  2.149564e-01,  6.436638e-01, -3.396817e-01},
  { 3.426477e-01,  2.993785e-02, -9.389868e-01,  2.842083e-01,  6.705664e-01, -3.269842e-01},
  { 1.657801e-01,  6.661815e-02, -9.839100e-01,  2.658205e-01,  6.659160e-01, -3.317277e-01},
  {-3.347802e-01,  8.830556e-01,  3.288389e-01, -2.312360e-01,  4.385593e-01, -5.307823e-01},
  { 1.371727e-01,  7.688865e-01,  6.244975e-01, -1.314669e-01,  4.583935e-01, -5.250818e-01},
  {-5.170271e-01,  8.101336e-01,  2.763448e-01, -2.405679e-01,  4.513969e-01, -5.737271e-01},
  {-6.193741e-01,  7.690635e-01,  1.578514e-01, -2.560345e-01,  4.499932e-01, -6.090586e-01},
  { 6.846325e-01,  6.226289e-01,  3.789612e-01, -3.890103e-02,  4.684622e-01, -6.218004e-01},
  {-7.307995e-01,  6.745753e-01, -1.043081e-01, -2.472260e-01,  4.583359e-01, -6.608552e-01},
  {-4.659564e-01,  6.712693e-01, -5.764391e-01, -1.392279e-01,  5.011957e-01, -7.836657e-01},
  {-4.494385e-01,  6.349799e-01, -6.283355e-01, -1.291676e-01,  5.003432e-01, -7.927072e-01},
  { 8.092291e-01,  4.310028e-01, -3.992305e-01, -1.904958e-02,  4.789965e-01, -7.839674e-01},
  { 7.346922e-01,  4.918960e-01, -4.671891e-01, -2.373122e-02,  4.884797e-01, -7.820020e-01},
  { 4.756351e-01,  6.174300e-01, -6.265393e-01, -4.591540e-02,  4.934498e-01, -8.012670e-01},
  { 8.059692e-01,  4.482616e-01, -3.866203e-01, -1.604192e-02,  4.651588e-01, -7.934248e-01},
  {-3.573018e-01,  6.325533e-01, -6.871767e-01, -1.103509e-01,  4.903813e-01, -8.117463e-01},
  { 7.561681e-01,  4.175529e-01, -5.038447e-01, -1.301038e-02,  4.526480e-01, -8.007073e-01},
  { 6.605237e-01,  3.704118e-01, -6.530724e-01, -2.117466e-02,  4.511031e-01, -8.113676e-01},
  { 6.556639e-01,  3.187870e-01, -6.844558e-01, -1.726438e-02,  4.365033e-01, -8.147700e-01},
  { 1.435144e-01,  1.967136e-01,  9.699007e-01,  3.345428e-01,  6.056512e-01,  7.990376e-01},
  { 5.614455e-01,  1.480463e-01,  8.141629e-01,  3.648826e-01,  5.807742e-01,  7.953097e-01},
  { 8.368820e-02,  2.074685e-01,  9.746553e-01,  3.251278e-01,  6.251285e-01,  7.959013e-01},
  { 2.644850e-02,  2.481372e-01,  9.683638e-01,  3.279513e-01,  6.633776e-01,  7.868694e-01},
  {-5.641322e-02,  2.371619e-01,  9.698308e-01,  2.936568e-01,  6.302215e-01,  7.944136e-01},
  {-2.004155e-01,  2.771750e-01,  9.396849e-01,  2.680055e-01,  6.178223e-01,  7.943197e-01},
  { 2.154955e-02,  3.030101e-01,  9.527436e-01,  3.261851e-01,  6.741070e-01,  7.840486e-01},
  {-4.672137e-01,  3.156410e-01,  8.258826e-01,  1.341908e-01,  6.624964e-01,  7.214884e-01},
  { 9.985178e-01, -3.302599e-02,  4.326203e-02,  4.984561e-01,  5.537240e-01,  4.882711e-01},
  { 9.975242e-01, -6.778964e-02, -1.870922e-02,  4.981683e-01,  5.391873e-01,  4.376614e-01},
  {-8.303340e-01,  4.642062e-01,  3.083148e-01, -1.850454e-01,  6.843127e-01,  3.446986e-01},
  { 9.738820e-01, -1.579756e-01, -1.630882e-01,  4.729339e-01,  6.475076e-01,  8.872496e-02},
  {-8.473020e-01,  3.377837e-01, -4.098555e-01, -2.547128e-01,  5.486490e-01,  7.003945e-02},
  { 9.679873e-01, -1.781831e-01, -1.767807e-01,  4.638768e-01,  7.326252e-01, -5.737162e-02},
  { 9.788803e-01,  4.975919e-02, -1.982864e-01,  4.251934e-01,  5.377781e-01, -1.287674e-01},
  { 8.763968e-01, -1.150103e-01, -4.676551e-01,  4.169203e-01,  7.427743e-01, -2.108734e-01},
  {-7.210615e-01,  3.094006e-01, -6.199529e-01,  7.288127e-02,  5.885923e-01, -3.000264e-01},
  { 8.824620e-01, -1.725754e-01, -4.375827e-01,  4.184867e-01,  7.592368e-01, -2.137340e-01},
  { 8.434030e-01, -1.632055e-01, -5.118939e-01,  4.096897e-01,  7.942755e-01, -2.432859e-01},
  { 6.231558e-01, -1.195362e-01, -7.729087e-01,  3.654306e-01,  7.722648e-01, -2.864614e-01},
  { 4.280246e-01, -3.002826e-01, -8.524232e-01,  3.548386e-01,  7.607754e-01, -2.925789e-01},
  { 6.241172e-01,  3.800422e-02, -7.804059e-01,  3.469813e-01,  7.159868e-01, -2.942584e-01},
  { 5.236949e-01,  2.707765e-02, -8.514755e-01,  3.253569e-01,  7.235346e-01, -3.088998e-01},
  { 3.136207e-01, -5.683782e-02, -9.478457e-01,  2.987284e-01,  7.145015e-01, -3.208456e-01},
  { 2.032220e-01,  5.092534e-02, -9.778075e-01,  2.756974e-01,  6.934474e-01, -3.279891e-01},
  { 2.224774e-01, -5.342063e-02, -9.734731e-01,  2.773760e-01,  7.183830e-01, -3.268467e-01},
  {-1.620832e-01,  1.765641e-01, -9.708523e-01,  1.826621e-01,  6.419557e-01, -3.371880e-01},
  {-3.251310e-01,  2.123051e-01, -9.215294e-01,  1.439724e-01,  6.348045e-01, -3.281363e-01},
  {-2.587599e-01,  7.843858e-01,  5.637218e-01, -2.259238e-01,  4.190430e-01, -4.817788e-01},
  { 5.552522e-02,  6.132464e-02, -9.965723e-01,  2.322146e-01,  6.939919e-01, -3.338234e-01},
  {-6.791879e-02,  1.143102e-01, -9.911208e-01,  1.994353e-01,  6.711683e-01, -3.352361e-01},
  {-8.226092e-02,  8.330503e-03, -9.965760e-01,  2.038305e-01,  6.996526e-01, -3.328378e-01},
  {-2.256145e-01,  7.851106e-01,  5.768009e-01, -1.674963e-01,  4.721690e-01, -5.496369e-01},
  {-3.628086e-01,  8.288605e-01,  4.258641e-01, -2.161703e-01,  4.582422e-01, -5.587661e-01},
  {-2.065929e-01,  8.503334e-01,  4.839964e-01, -1.532303e-01,  4.949922e-01, -5.789897e-01},
  {-4.983870e-01,  8.114493e-01,  3.052217e-01, -2.305136e-01,  4.592483e-01, -5.783793e-01},
  { 4.093851e-01,  7.241459e-01,  5.549923e-01, -8.542346e-02,  4.710462e-01, -5.644025e-01},
  {-1.887413e-01,  8.937786e-01,  4.068619e-01, -1.465476e-01,  5.053524e-01, -5.951079e-01},
  {-3.427411e-01,  8.525249e-01,  3.946263e-01, -1.656532e-01,  4.998038e-01, -5.950823e-01},
  {-5.370376e-01,  8.003657e-01,  2.664682e-01, -2.315178e-01,  4.654256e-01, -5.973050e-01},
  { 5.990752e-01,  6.807137e-01,  4.215897e-01, -6.293705e-02,  4.724990e-01, -5.910978e-01},
  {-6.746643e-01,  7.348571e-01,  6.937686e-02, -2.419900e-01,  4.632112e-01, -6.179472e-01},
  { 7.875336e-01,  5.409434e-01,  2.952476e-01, -2.168033e-02,  4.723547e-01, -6.642073e-01},
  { 9.002807e-01,  4.078029e-01,  1.522872e-01, -9.562408e-03,  4.796644e-01, -7.171298e-01},
  {-5.647714e-01,  7.033973e-01, -4.315849e-01, -1.624945e-01,  4.990255e-01, -7.620452e-01},
  {-6.161645e-01,  6.889979e-01, -3.816062e-01, -1.739554e-01,  4.946270e-01, -7.528895e-01},
  { 6.409685e-01,  5.582863e-01, -5.267597e-01, -3.076387e-02,  5.037405e-01, -7.771590e-01},
  { 8.659981e-01,  4.290809e-01, -2.567819e-01, -1.502375e-02,  4.919413e-01, -7.566782e-01},
  {-3.581139e-01,  6.548674e-01, -6.655096e-01, -1.164899e-01,  5.061546e-01, -7.948369e-01},
  { 2.414919e-01,  6.509531e-01, -7.196816e-01, -6.634075e-02,  5.023083e-01, -8.041635e-01},
  { 2.859303e-02,  5.753234e-01, -8.174261e-01, -8.296653e-02,  4.962649e-01, -8.113518e-01},
  {-1.956822e-01,  6.402687e-01, -7.428085e-01, -1.032303e-01,  4.936003e-01, -8.119234e-01},
  { 3.640029e-01,  1.614260e-01,  9.173024e-01,  3.694754e-01,  6.371989e-01,  7.839385e-01},
  { 2.740945e-01,  2.021016e-01,  9.402273e-01,  3.592113e-01,  6.461549e-01,  7.857897e-01},
  { 6.363627e-01,  9.922484e-02,  7.649817e-01,  3.977883e-01,  6.294992e-01,  7.677981e-01},
  { 5.508400e-01,  8.606638e-02,  8.301613e-01,  3.854230e-01,  6.217655e-01,  7.781212e-01},
  {-2.471687e-01,  3.013477e-01,  9.209219e-01,  2.550160e-01,  6.372144e-01,  7.853224e-01},
  {-4.888332e-02,  3.293777e-01,  9.429320e-01,  3.232341e-01,  6.968900e-01,  7.767254e-01},
  {-1.440090e-01,  3.050500e-01,  9.413851e-01,  2.991864e-01,  6.767007e-01,  7.814399e-01},
  {-7.070050e-01,  2.644556e-01,  6.559017e-01, -4.580009e-02,  5.723408e-01,  6.361957e-01},
  { 9.461620e-01,  1.273260e-02,  3.234430e-01,  4.686441e-01,  6.662135e-01,  6.535645e-01},
  {-6.076211e-01,  2.879896e-01,  7.401748e-01,  3.880420e-02,  6.538301e-01,  6.646426e-01},
  {-4.950795e-01,  3.414844e-01,  7.989272e-01,  1.122636e-01,  6.870202e-01,  6.987058e-01},
  { 9.871066e-01, -1.246495e-01, -1.004145e-01,  4.906205e-01,  6.259629e-01,  2.346840e-01},
  { 9.922248e-01, -5.588155e-02, -1.112078e-01,  4.345134e-01,  4.952323e-01,  5.853621e-03},
  {-8.341972e-01,  2.490433e-01, -4.920291e-01, -2.187717e-01,  6.029121e-01,  4.245833e-02},
  {-8.449739e-01,  2.380266e-01, -4.789180e-01, -2.276576e-01,  5.842444e-01,  4.728804e-02},
  {-8.100555e-01,  3.152377e-01, -4.944039e-01, -2.264627e-01,  5.880968e-01,  4.722207e-02},
  { 9.575704e-01, -1.715724e-01, -2.315636e-01,  4.584379e-01,  7.321638e-01, -8.331580e-02},
  { 9.492172e-01, -1.676109e-01, -2.662582e-01,  4.544590e-01,  7.610978e-01, -1.188857e-01},
  {-6.963986e-01,  1.778739e-01, -6.952625e-01,  7.372339e-02,  6.254956e-01, -2.898871e-01},
  { 4.022523e-01, -1.976312e-01, -8.939435e-01,  3.400967e-01,  7.798441e-01, -3.039995e-01},
  { 4.481068e-01, -4.270526e-02, -8.929594e-01,  3.256594e-01,  7.569016e-01, -3.101153e-01},
  { 2.535204e-01,  5.080077e-02, -9.659952e-01,  2.901246e-01,  7.483374e-01, -3.234303e-01},
  { 8.446428e-01, -7.345823e-02, -5.302665e-01,  4.109337e-01,  8.129689e-01, -2.465486e-01},
  {-3.597215e-01,  1.580956e-01, -9.195685e-01,  1.444669e-01,  6.621837e-01, -3.226488e-01},
  {-2.483029e-01,  8.048928e-02, -9.653326e-01,  1.589080e-01,  6.812031e-01, -3.248163e-01},
  {-4.412130e-03,  9.076357e-02, -9.958627e-01,  2.260020e-01,  7.147598e-01, -3.326414e-01},
  {-2.179492e-01, -5.845486e-04, -9.759600e-01,  1.825333e-01,  6.944731e-01, -3.303249e-01},
  { 7.831333e-01, -1.168886e-01, -6.107693e-01,  4.048860e-01,  8.048570e-01, -2.542389e-01},
  {-1.988515e-01,  1.007629e-01, -9.748359e-01,  1.868694e-01,  7.071887e-01, -3.306460e-01},
  {-2.371711e-02,  7.322654e-01,  6.806062e-01, -1.384417e-01,  4.745781e-01, -5.440097e-01},
  {-1.714992e-01,  8.203099e-01,  5.456003e-01, -1.480443e-01,  4.853309e-01, -5.604755e-01},
  { 2.333366e-01,  6.861908e-01,  6.889820e-01, -1.073751e-01,  4.758849e-01, -5.553044e-01},
  {-3.736503e-01,  8.179393e-01,  4.374481e-01, -1.997055e-01,  4.734287e-01, -5.732244e-01},
  {-3.008177e-01,  9.048653e-01,  3.012099e-01, -1.648973e-01,  5.057980e-01, -6.093158e-01},
  { 8.030071e-02,  9.433599e-01,  3.219070e-01, -1.188728e-01,  5.182678e-01, -6.211248e-01},
  {-1.423712e-01,  9.354953e-01,  3.233868e-01, -1.428661e-01,  5.134060e-01, -6.144163e-01},
  {-6.808251e-01,  7.321380e-01, -2.124152e-02, -2.407725e-01,  4.664575e-01, -6.477653e-01},
  {-4.327853e-01,  7.731035e-01, -4.636893e-01, -1.261264e-01,  5.173302e-01, -7.726306e-01},
  {-4.983139e-01,  7.699814e-01, -3.985120e-01, -1.475012e-01,  5.103632e-01, -7.612763e-01},
  { 9.199711e-01,  3.748663e-01, -1.145796e-01, -1.170485e-02,  4.862772e-01, -7.517447e-01},
  { 7.205687e-01,  5.613412e-01, -4.070342e-01, -3.040536e-02,  5.110033e-01, -7.674371e-01},
  {-6.060619e-01,  7.358251e-01, -3.020770e-01, -1.984284e-01,  4.904733e-01, -7.153161e-01},
  { 2.869415e-01,  7.169772e-01, -6.353016e-01, -5.255480e-02,  5.099494e-01, -7.892410e-01},
  {-2.374810e-01,  7.375892e-01, -6.321114e-01, -1.075406e-01,  5.130008e-01, -7.916867e-01},
  {-1.513442e-01,  7.047308e-01, -6.931446e-01, -9.199496e-02,  5.002522e-01, -8.083138e-01},
  { 5.038452e-01,  1.429245e-01,  8.518877e-01,  3.819595e-01,  6.441764e-01,  7.768802e-01},
  { 7.312166e-01,  6.723777e-02,  6.788235e-01,  4.123877e-01,  6.570030e-01,  7.502801e-01},
  { 1.931436e-01,  2.490315e-01,  9.490410e-01,  3.534448e-01,  6.755443e-01,  7.802663e-01},
  { 2.140948e-01,  3.028614e-01,  9.286755e-01,  3.517648e-01,  6.944854e-01,  7.750022e-01},
  { 1.141842e-01,  3.519718e-01,  9.290199e-01,  3.395305e-01,  7.054091e-01,  7.731625e-01},
  { 1.168896e-01,  3.514022e-01,  9.288990e-01,  3.391681e-01,  7.146310e-01,  7.697437e-01},
  { 8.613763e-01,  3.127598e-02,  5.070037e-01,  4.477036e-01,  6.737757e-01,  6.983817e-01},
  {-2.868626e-01,  3.135256e-01,  9.052136e-01,  2.330046e-01,  6.630954e-01,  7.697008e-01},
  {-4.863249e-02,  3.677062e-01,  9.286695e-01,  3.219497e-01,  7.136539e-01,  7.702191e-01},
  {-4.354067e-01,  3.515363e-01,  8.287600e-01,  1.706212e-01,  7.041975e-01,  7.245901e-01},
  {-9.528049e-01,  2.890869e-01, -9.269091e-02, -2.219425e-01,  7.197961e-01,  1.417185e-01},
  {-9.699014e-01,  2.388475e-01,  4.736325e-02, -2.207023e-01,  7.218896e-01,  1.829915e-01},
  {-9.544680e-01,  2.762771e-01, -1.125254e-01, -2.257750e-01,  7.053721e-01,  1.346943e-01},
  {-9.668061e-01,  2.318017e-01, -1.074894e-01, -2.284119e-01,  6.951456e-01,  1.342136e-01},
  { 9.762719e-01, -8.253589e-02, -2.002025e-01,  4.385135e-01,  5.254765e-01,  1.793483e-02},
  {-9.424021e-01,  2.745060e-01, -1.911145e-01, -2.499163e-01,  6.263098e-01,  1.481175e-01},
  { 9.713964e-01, -1.742094e-01, -1.613690e-01,  4.780842e-01,  6.983436e-01,  6.598461e-02},
  {-8.237278e-01,  9.578884e-02, -5.588352e-01, -1.860180e-01,  6.466011e-01,  9.059977e-03},
  {-8.281775e-01,  4.483526e-02, -5.586697e-01, -1.872855e-01,  6.600214e-01,  1.499480e-02},
  {-8.407435e-01,  1.705640e-01, -5.138661e-01, -2.180074e-01,  6.217970e-01,  4.958215e-02},
  {-8.393589e-01,  2.535275e-01, -4.808331e-01, -2.281960e-01,  5.871816e-01,  4.928849e-02},
  {-7.940264e-01,  3.212084e-01, -5.160882e-01, -2.399357e-01,  5.734665e-01,  5.995146e-02},
  { 9.381012e-01, -2.147327e-01, -2.717645e-01,  4.525856e-01,  7.129370e-01, -9.317713e-02},
  { 9.337114e-01, -1.734810e-01, -3.131889e-01,  4.389585e-01,  7.445368e-01, -1.577437e-01},
  { 9.140816e-01, -1.747366e-01, -3.659536e-01,  4.403240e-01,  7.703401e-01, -1.671775e-01},
  {-4.844705e-01,  2.002340e-01, -8.515837e-01,  1.015860e-01,  6.592752e-01, -3.020411e-01},
  { 5.095693e-01, -6.558540e-02, -8.579264e-01,  3.575381e-01,  8.228573e-01, -2.975968e-01},
  { 3.611002e-01, -2.878802e-02, -9.320825e-01,  3.270034e-01,  8.009613e-01, -3.117423e-01},
  { 8.431100e-01, -1.351874e-01, -5.204707e-01,  4.230656e-01,  8.239500e-01, -2.289383e-01},
  { 7.332035e-01, -8.147186e-02, -6.751111e-01,  3.859114e-01,  8.234064e-01, -2.763128e-01},
  { 2.529527e-01, -1.053626e-02, -9.674213e-01,  2.909242e-01,  7.647237e-01, -3.231973e-01},
  { 1.897379e-01,  6.352027e-02, -9.797779e-01,  2.702297e-01,  7.484264e-01, -3.278499e-01},
  { 5.781242e-02,  3.396039e-02, -9.977497e-01,  2.467482e-01,  7.364361e-01, -3.309783e-01},
  {-1.881770e-01,  7.637014e-02, -9.791614e-01,  1.865158e-01,  7.324974e-01, -3.270803e-01},
  {-1.052028e-01,  8.367486e-01,  5.373864e-01, -1.365493e-01,  4.775263e-01, -5.466426e-01},
  {-3.139915e-01,  8.520852e-01,  4.187603e-01, -1.375228e-01,  4.770237e-01, -5.471110e-01},
  { 1.220834e-01,  7.957906e-01,  5.931382e-01, -1.345643e-01,  4.788031e-01, -5.497328e-01},
  { 8.798817e-02,  7.486137e-01,  6.571419e-01, -1.219982e-01,  4.850592e-01, -5.609581e-01},
  {-5.440599e-02,  8.377329e-01,  5.433633e-01, -1.407442e-01,  4.893686e-01, -5.650064e-01},
  { 2.243208e-01,  7.151583e-01,  6.619885e-01, -1.148227e-01,  4.815435e-01, -5.586470e-01},
  {-3.164887e-02,  8.505152e-01,  5.249974e-01, -1.357291e-01,  4.949052e-01, -5.731782e-01},
  {-4.041137e-02,  9.064491e-01,  4.203772e-01, -1.240956e-01,  5.071869e-01, -5.938822e-01},
  { 1.069109e-01,  9.274864e-01,  3.582444e-01, -1.151705e-01,  5.132316e-01, -6.094250e-01},
  { 1.957750e-01,  9.405897e-01,  2.774225e-01, -1.098106e-01,  5.197403e-01, -6.306547e-01},
  {-5.765445e-01,  8.023946e-01,  1.541403e-01, -2.174738e-01,  4.829142e-01, -6.261657e-01},
  { 1.308951e-01,  9.602591e-01,  2.465135e-01, -1.130593e-01,  5.219551e-01, -6.369842e-01},
  {-7.947181e-02,  9.687898e-01,  2.347990e-01, -1.261573e-01,  5.208678e-01, -6.319606e-01},
  {-2.432279e-01,  9.475915e-01,  2.071485e-01, -1.459294e-01,  5.189949e-01, -6.379530e-01},
  { 8.956047e-01,  4.432911e-01,  3.721830e-02, -1.599185e-02,  4.986971e-01, -7.323292e-01},
  { 6.861249e-01,  6.000184e-01,  4.113519e-01, -3.338905e-02,  4.913999e-01, -6.706889e-01},
  { 8.239651e-01,  5.206985e-01, -2.235051e-01, -2.496351e-02,  5.130259e-01, -7.538010e-01},
  {-6.175724e-01,  7.420668e-01, -2.606553e-01, -1.850108e-01,  4.984137e-01, -7.238201e-01},
  { 5.116026e-01,  6.769789e-01, -5.291144e-01, -4.337243e-02,  5.177820e-01, -7.741362e-01},
  {-3.255659e-01,  7.994661e-01, -5.048373e-01, -1.111470e-01,  5.211619e-01, -7.782580e-01},
  {-6.641012e-01,  7.474372e-01, -1.752626e-02, -2.233641e-01,  4.816707e-01, -6.789857e-01},
  {-6.298662e-01,  7.577905e-01, -1.703590e-01, -2.191460e-01,  4.856425e-01, -6.870589e-01},
  { 1.565419e-01,  7.518880e-01, -6.404366e-01, -7.601840e-02,  5.102797e-01, -7.982743e-01},
  { 6.204265e-01,  1.468411e-01,  7.703952e-01,  4.038197e-01,  6.780452e-01,  7.564009e-01},
  { 5.701951e-01,  1.313013e-01,  8.109486e-01,  3.934596e-01,  6.643169e-01,  7.669160e-01},
  { 3.831388e-01,  2.226223e-01,  8.964619e-01,  3.784685e-01,  6.663732e-01,  7.744175e-01},
  { 3.202325e-01,  2.817104e-01,  9.044835e-01,  3.786018e-01,  6.900055e-01,  7.688920e-01},
  { 7.868247e-01,  1.123817e-01,  6.068584e-01,  4.223070e-01,  6.836991e-01,  7.350937e-01},
  {-1.665488e-01,  3.533127e-01,  9.205605e-01,  2.820749e-01,  6.945307e-01,  7.719607e-01},
  {-2.386412e-01,  3.196061e-01,  9.170073e-01,  2.670580e-01,  6.831793e-01,  7.724963e-01},
  {-6.879290e-01,  3.314637e-01,  6.456667e-01, -4.525442e-02,  5.786554e-01,  6.340880e-01},
  {-6.579114e-01,  3.811805e-01,  6.495029e-01, -3.506672e-02,  5.979535e-01,  6.332139e-01},
  {-6.792281e-01,  2.416880e-01,  6.929907e-01,  9.389300e-03,  6.695918e-01,  6.328843e-01},
  { 9.784985e-01,  1.401003e-03,  2.062492e-01,  4.885349e-01,  6.804084e-01,  5.789004e-01},
  {-6.974042e-01,  3.446861e-01,  6.283461e-01, -3.982668e-02,  6.758610e-01,  5.785418e-01},
  {-4.607900e-01,  3.723990e-01,  8.056000e-01,  1.281185e-01,  7.206259e-01,  6.937858e-01},
  { 9.939949e-01, -1.781625e-02,  1.079661e-01,  5.002556e-01,  6.590887e-01,  5.012591e-01},
  {-7.633036e-01,  3.343861e-01,  5.527690e-01, -7.730461e-02,  7.522270e-01,  4.878014e-01},
  {-8.312730e-01,  4.032006e-01,  3.826414e-01, -1.486344e-01,  7.056054e-01,  4.056709e-01},
  { 9.961945e-01, -7.799762e-02, -3.889661e-02,  5.018032e-01,  6.470901e-01,  3.593827e-01},
  {-7.995347e-01,  5.211765e-01,  2.985283e-01, -1.635242e-01,  6.968465e-01,  3.822478e-01},
  {-8.839041e-01,  3.190304e-01,  3.419548e-01, -1.808697e-01,  7.418689e-01,  3.042699e-01},
  {-9.745885e-01,  2.043768e-01, -9.169121e-02, -2.295000e-01,  6.889318e-01,  1.313544e-01},
  {-9.747986e-01,  2.007918e-01, -9.721353e-02, -2.306396e-01,  6.821307e-01,  1.288920e-01},
  {-9.605033e-01,  2.250039e-01, -1.637273e-01, -2.317552e-01,  6.756161e-01,  1.264714e-01},
  { 9.953070e-01, -2.879255e-02, -9.238472e-02,  4.327116e-01,  5.164615e-01, -1.915824e-02},
  {-8.581630e-01,  1.770858e-01, -4.818683e-01, -1.912251e-01,  6.785831e-01,  2.775289e-02},
  {-8.291908e-01,  5.741228e-02, -5.560095e-01, -1.659372e-01,  6.737337e-01, -1.489064e-02},
  { 9.584909e-01, -1.999463e-01, -2.032651e-01,  4.519077e-01,  6.723459e-01, -5.837817e-02},
  {-7.135025e-01,  9.722859e-02, -6.938738e-01,  9.699828e-04,  6.436163e-01, -2.143604e-01},
  {-7.417411e-01,  1.018705e-01, -6.629047e-01, -1.869619e-02,  6.215354e-01, -1.957731e-01},
  { 9.554386e-01, -1.897642e-01, -2.261121e-01,  4.671599e-01,  7.931904e-01, -9.489108e-02},
  { 6.313312e-01, -8.212684e-02, -7.711524e-01,  3.821504e-01,  8.437462e-01, -2.819746e-01},
  { 2.160100e-01, -9.671569e-03, -9.763433e-01,  2.904799e-01,  7.804402e-01, -3.233869e-01},
  { 8.182675e-01, -1.731216e-01, -5.481489e-01,  4.239554e-01,  8.431435e-01, -2.337414e-01},
  {-4.445166e-01,  1.176787e-01, -8.880072e-01,  1.216542e-01,  6.993909e-01, -3.065504e-01},
  {-2.119768e-01,  2.343975e-02, -9.769936e-01,  1.855216e-01,  7.690051e-01, -3.248391e-01},
  { 4.722077e-01,  7.076571e-01,  5.255865e-01, -1.039836e-01,  4.931816e-01, -5.795736e-01},
  { 1.097051e-01,  8.980609e-01,  4.259712e-01, -1.215322e-01,  5.056678e-01, -5.907852e-01},
  {-4.767576e-01,  8.261914e-01,  3.001832e-01, -2.053178e-01,  4.853460e-01, -6.072828e-01},
  { 4.930916e-01,  7.568492e-01,  4.289986e-01, -7.600413e-02,  4.932170e-01, -6.085808e-01},
  {-4.239132e-01,  8.627735e-01,  2.755348e-01, -1.859828e-01,  5.000738e-01, -6.192709e-01},
  {-3.951434e-01,  9.040135e-01,  1.631602e-01, -1.724628e-01,  5.092567e-01, -6.313096e-01},
  { 1.530503e-01,  9.500343e-01,  2.720484e-01, -1.067556e-01,  5.230696e-01, -6.445188e-01},
  {-1.106261e-01,  9.750966e-01,  1.922196e-01, -1.305158e-01,  5.243111e-01, -6.490288e-01},
  {-5.491682e-01,  8.337656e-01,  5.700221e-02, -2.104296e-01,  4.898936e-01, -6.402689e-01},
  { 7.881405e-01,  5.332071e-01,  3.074487e-01, -2.375075e-02,  5.001599e-01, -7.059000e-01},
  {-5.227845e-01,  8.048354e-01, -2.809559e-01, -1.491744e-01,  5.167493e-01, -7.444116e-01},
  {-5.427361e-01,  8.003425e-01, -2.547342e-01, -1.650161e-01,  5.104514e-01, -7.317668e-01},
  { 2.639236e-01,  7.691080e-01, -5.820801e-01, -5.594872e-02,  5.231271e-01, -7.759883e-01},
  {-9.087878e-02,  7.873880e-01, -6.097222e-01, -9.291247e-02,  5.164363e-01, -7.912784e-01},
  { 7.050882e-01,  1.035291e-01,  7.015215e-01,  4.142755e-01,  6.941446e-01,  7.433027e-01},
  { 1.068497e-01,  3.602163e-01,  9.267294e-01,  3.448928e-01,  7.337182e-01,  7.617860e-01},
  { 9.222848e-01,  1.736809e-02,  3.861205e-01,  4.619423e-01,  7.119699e-01,  6.683878e-01},
  {-3.802070e-01,  3.512625e-01,  8.556035e-01,  2.271140e-01,  7.185385e-01,  7.458237e-01},
  { 9.827180e-01,  9.913918e-04,  1.851059e-01,  4.913650e-01,  7.027214e-01,  5.631443e-01},
  {-4.563929e-01,  3.782770e-01,  8.053645e-01,  1.516915e-01,  7.594212e-01,  6.896597e-01},
  { 9.988683e-01, -4.243653e-02,  2.147624e-02,  5.044046e-01,  6.698071e-01,  4.395657e-01},
  { 9.979768e-01, -4.013662e-02,  4.930710e-02,  5.054146e-01,  6.932281e-01,  4.400929e-01},
  {-9.556552e-01,  2.937453e-01,  2.090214e-02, -2.138867e-01,  7.474027e-01,  1.662548e-01},
  {-9.380610e-01,  3.099865e-01,  1.547575e-01, -2.085054e-01,  7.499521e-01,  2.115840e-01},
  {-8.676440e-01,  1.700152e-01, -4.672138e-01, -1.853178e-01,  6.846736e-01,  1.944302e-02},
  {-8.807967e-01,  1.508633e-01, -4.488179e-01, -1.819258e-01,  7.000422e-01,  1.835533e-02},
  { 9.731651e-01, -1.702154e-01, -1.548433e-01,  4.851656e-01,  7.376519e-01,  6.536738e-02},
  { 9.731213e-01, -1.779763e-01, -1.461483e-01,  4.839130e-01,  7.450690e-01,  4.906180e-02},
  { 9.682711e-01, -1.725775e-01, -1.807434e-01,  4.428970e-01,  6.680290e-01, -1.008623e-01},
  {-6.318928e-01,  1.253626e-01, -7.648502e-01,  4.781237e-02,  6.752036e-01, -2.580910e-01},
  { 3.900892e-01, -2.418276e-02, -9.204594e-01,  3.394135e-01,  8.389479e-01, -3.080193e-01},
  { 7.776659e-01, -1.509788e-01, -6.102796e-01,  4.185820e-01,  8.574553e-01, -2.461387e-01},
  {-9.452458e-03, -6.058301e-02, -9.981184e-01,  2.328111e-01,  7.690248e-01, -3.307450e-01},
  {-1.723042e-01, -2.637210e-01, -9.490851e-01,  2.115900e-01,  7.804021e-01, -3.297252e-01},
  {-2.828978e-01, -1.731748e-01, -9.433872e-01,  1.925997e-01,  7.900543e-01, -3.265493e-01},
  {-8.135255e-02, -3.140451e-02, -9.961905e-01,  2.147867e-01,  7.914910e-01, -3.303422e-01},
  {-2.289686e-01, -1.935375e-02, -9.732414e-01,  1.892469e-01,  8.081803e-01, -3.262357e-01},
  {-3.829904e-01,  2.174481e-03, -9.237497e-01,  1.861240e-01,  8.151867e-01, -3.254282e-01},
  {-1.179617e-01, -1.166667e-02, -9.929495e-01,  2.116549e-01,  8.116391e-01, -3.307027e-01},
  { 1.928755e-01,  7.827755e-01,  5.916601e-01, -1.172315e-01,  4.972774e-01, -5.785214e-01},
  { 4.287989e-01,  8.281350e-01,  3.610042e-01, -1.011886e-01,  5.098611e-01, -6.121873e-01},
  { 5.423914e-01,  7.450740e-01,  3.881707e-01, -6.042748e-02,  4.978373e-01, -6.370993e-01},
  {-5.038670e-01,  8.503125e-01,  1.519430e-01, -2.050852e-01,  4.926065e-01, -6.317054e-01},
  { 3.790492e-01,  8.624118e-01,  3.355108e-01, -8.735537e-02,  5.136453e-01, -6.370234e-01},
  { 5.870947e-01,  7.003317e-01,  4.060238e-01, -5.339259e-02,  5.033938e-01, -6.585049e-01},
  {-2.842457e-01,  9.492443e-01,  1.346838e-01, -1.528351e-01,  5.201339e-01, -6.543246e-01},
  {-3.662752e-01,  9.242954e-01,  1.073341e-01, -1.659952e-01,  5.147043e-01, -6.497010e-01},
  { 6.274669e-01,  6.717480e-01,  3.937510e-01, -4.190499e-02,  5.037206e-01, -6.756555e-01},
  { 6.181664e-01,  6.419802e-01,  4.535765e-01, -3.972222e-02,  5.078027e-01, -6.858420e-01},
  { 1.364896e-01,  9.498322e-01,  2.814061e-01, -9.986796e-02,  5.269701e-01, -6.621416e-01},
  { 8.084754e-01,  5.854191e-01, -6.043111e-02, -2.527986e-02,  5.159860e-01, -7.434562e-01},
  { 6.554129e-01,  6.921609e-01, -3.022372e-01, -3.133208e-02,  5.204865e-01, -7.532928e-01},
  {-4.087805e-01,  8.463079e-01, -3.415573e-01, -1.280713e-01,  5.256519e-01, -7.534317e-01},
  {-4.731663e-01,  8.423213e-01, -2.580863e-01, -1.421134e-01,  5.217949e-01, -7.419581e-01},
  { 4.875421e-01,  7.603681e-01, -4.291189e-01, -4.452214e-02,  5.265650e-01, -7.620727e-01},
  {-2.699584e-01,  8.839875e-01, -3.816916e-01, -1.112986e-01,  5.302618e-01, -7.594356e-01},
  {-2.886385e-02,  8.471596e-01, -5.305540e-01, -8.969312e-02,  5.280998e-01, -7.741623e-01},
  { 6.553819e-01,  1.009106e-01,  7.485263e-01,  4.093739e-01,  7.033975e-01,  7.471677e-01},
  { 5.508874e-01,  1.776381e-01,  8.154556e-01,  4.010127e-01,  7.061251e-01,  7.529900e-01},
  { 5.092134e-01,  1.076370e-01,  8.538828e-01,  4.045228e-01,  7.090353e-01,  7.499157e-01},
  { 3.878222e-01,  2.790993e-01,  8.784633e-01,  3.867437e-01,  7.319951e-01,  7.531620e-01},
  { 7.656212e-01,  6.672141e-02,  6.398222e-01,  4.354626e-01,  7.089802e-01,  7.149878e-01},
  { 2.029312e-01,  3.551299e-01,  9.125249e-01,  3.709878e-01,  7.457635e-01,  7.528849e-01},
  { 8.590360e-01,  5.411527e-02,  5.090468e-01,  4.522688e-01,  7.219075e-01,  6.876782e-01},
  { 9.630138e-01,  8.699461e-03,  2.693118e-01,  4.782353e-01,  7.180496e-01,  6.199876e-01},
  {-3.966551e-01,  3.920377e-01,  8.300429e-01,  2.019358e-01,  7.853016e-01,  7.040722e-01},
  {-6.063237e-01,  3.593972e-01,  7.093697e-01,  3.982550e-02,  7.175884e-01,  6.344122e-01},
  { 9.981848e-01, -5.289859e-02,  2.878867e-02,  5.067984e-01,  7.120444e-01,  4.275594e-01},
  {-8.037425e-01,  3.237236e-01,  4.992004e-01, -1.164511e-01,  7.623873e-01,  4.256453e-01},
  {-9.552426e-01,  2.943221e-01,  2.976910e-02, -2.117632e-01,  7.546549e-01,  1.643590e-01},
  {-9.514462e-01,  2.826851e-01, -1.218160e-01, -2.090137e-01,  7.575316e-01,  1.323723e-01},
  { 4.611508e-01, -4.522016e-02, -8.861688e-01,  3.521275e-01,  8.589106e-01, -3.028437e-01},
  { 6.460016e-01, -1.209629e-01, -7.536908e-01,  3.923623e-01,  8.616248e-01, -2.756558e-01},
  {-3.747874e-01, -5.195452e-03, -9.270962e-01,  1.508558e-01,  7.803956e-01, -3.135539e-01},
  {-4.338580e-01,  2.162168e-02, -9.007217e-01,  1.868317e-01,  8.229299e-01, -3.260466e-01},
  { 4.561393e-01,  8.058921e-01,  3.774583e-01, -1.044575e-01,  5.009990e-01, -5.897474e-01},
  { 2.174546e-01,  8.865348e-01,  4.083742e-01, -1.096119e-01,  5.076618e-01, -5.981846e-01},
  { 3.364840e-01,  8.750180e-01,  3.480258e-01, -8.024958e-02,  5.208451e-01, -6.622611e-01},
  {-4.631825e-01,  8.824935e-01,  8.165295e-02, -1.850199e-01,  5.060573e-01, -6.507299e-01},
  { 5.220517e-01,  7.271130e-01,  4.458348e-01, -4.198662e-02,  5.141947e-01, -6.918111e-01},
  { 6.513809e-02,  9.618113e-01,  2.658496e-01, -1.002366e-01,  5.306388e-01, -6.737382e-01},
  {-1.225789e-01,  9.748285e-01,  1.862361e-01, -1.269080e-01,  5.292774e-01, -6.724650e-01},
  {-3.244261e-01,  9.408401e-01,  9.781403e-02, -1.458723e-01,  5.245284e-01, -6.716900e-01},
  { 6.476400e-01,  5.773274e-01,  4.972478e-01, -3.408364e-02,  5.134341e-01, -7.032911e-01},
  {-4.692931e-01,  8.825539e-01,  2.937210e-02, -1.800092e-01,  5.093753e-01, -6.792861e-01},
  { 5.103900e-01,  8.233207e-01, -2.482842e-01, -4.003779e-02,  5.272255e-01, -7.535709e-01},
  {-4.999810e-01,  8.583995e-01, -1.147585e-01, -1.585598e-01,  5.190803e-01, -7.097933e-01},
  { 3.728884e-01,  8.375382e-01, -3.993545e-01, -5.395056e-02,  5.305291e-01, -7.639915e-01},
  {-1.946463e-01,  3.621429e-01,  9.115729e-01,  2.808864e-01,  7.343807e-01,  7.563151e-01},
  {-3.098707e-01,  3.738585e-01,  8.741910e-01,  2.472179e-01,  7.458861e-01,  7.417256e-01},
  {-2.419281e-02,  3.768948e-01,  9.259401e-01,  3.280641e-01,  7.688551e-01,  7.476463e-01},
  { 9.360884e-01,  2.080327e-02,  3.511489e-01,  4.700549e-01,  7.430902e-01,  6.461346e-01},
  {-5.929107e-01,  3.507082e-01,  7.248867e-01,  3.389124e-02,  7.273024e-01,  6.247420e-01},
  {-5.287946e-01,  3.669028e-01,  7.653486e-01,  8.329757e-02,  7.413935e-01,  6.556363e-01},
  { 9.896805e-01, -9.172348e-03,  1.429977e-01,  4.994114e-01,  7.483741e-01,  5.156947e-01},
  { 9.971213e-01, -6.868426e-02,  3.211880e-02,  5.083483e-01,  7.228318e-01,  3.903349e-01},
  {-8.132381e-01,  3.200046e-01,  4.860461e-01, -1.186673e-01,  7.709396e-01,  4.166608e-01},
  {-9.288123e-01,  2.232713e-01, -2.957323e-01, -1.990520e-01,  7.421891e-01,  7.760072e-02},
  { 9.986025e-01, -3.665117e-02, -3.807597e-02,  4.319175e-01,  5.396786e-01, -4.037594e-02},
  {-6.395912e-01,  4.997087e-02, -7.670894e-01,  4.515481e-02,  7.246315e-01, -2.512909e-01},
  { 8.645642e-01, -1.923878e-01, -4.642366e-01,  4.573947e-01,  8.891305e-01, -1.889969e-01},
  { 5.629554e-01, -6.935414e-02, -8.235723e-01,  3.812594e-01,  8.840306e-01, -2.871403e-01},
  { 1.258376e-01, -3.439058e-02, -9.914546e-01,  2.708823e-01,  8.205246e-01, -3.282524e-01},
  { 7.236887e-01, -1.486292e-01, -6.739318e-01,  4.185874e-01,  8.987767e-01, -2.573150e-01},
  {-2.749195e-01,  5.096994e-02, -9.601153e-01,  1.867028e-01,  8.320662e-01, -3.252487e-01},
  {-5.373716e-02,  1.350206e-02, -9.984638e-01,  2.232483e-01,  8.283216e-01, -3.320100e-01},
  { 2.760400e-01,  8.518563e-01,  4.451325e-01, -1.089185e-01,  5.021982e-01, -5.880378e-01},
  { 4.298678e-01,  6.447718e-01,  6.320466e-01, -4.653924e-02,  5.252214e-01, -7.011998e-01},
  { 7.764055e-01,  6.213641e-01,  1.053620e-01, -2.768680e-02,  5.178507e-01, -7.278382e-01},
  { 3.855532e-01,  7.816612e-01,  4.902596e-01, -6.843127e-02,  5.317073e-01, -6.956877e-01},
  { 6.657729e-01,  7.431354e-01, -6.705439e-02, -3.175731e-02,  5.233873e-01, -7.427954e-01},
  {-4.908464e-01,  8.678338e-01, -7.703452e-02, -1.660631e-01,  5.165635e-01, -6.944607e-01},
  {-2.595537e-01,  9.271240e-01, -2.703204e-01, -1.104412e-01,  5.344721e-01, -7.487374e-01},
  {-3.260212e-01,  9.238251e-01, -2.006426e-01, -1.169050e-01,  5.350366e-01, -7.390983e-01},
  {-4.306186e-01,  8.968067e-01, -1.015164e-01, -1.432135e-01,  5.266559e-01, -7.159611e-01},
  {-1.402622e-01,  9.373943e-01, -3.187763e-01, -9.290943e-02,  5.375160e-01, -7.520230e-01},
  { 2.317262e-01,  8.954322e-01, -3.801368e-01, -6.071969e-02,  5.349371e-01, -7.598922e-01},
  { 7.528672e-02,  8.986033e-01, -4.322544e-01, -6.698050e-02,  5.352530e-01, -7.626437e-01},
  { 7.235036e-01,  9.124862e-02,  6.842633e-01,  4.237718e-01,  7.365397e-01,  7.253187e-01},
  { 5.883877e-01,  2.579742e-01,  7.663219e-01,  3.966410e-01,  7.416111e-01,  7.457882e-01},
  { 8.688776e-01,  4.601210e-02,  4.928839e-01,  4.532771e-01,  7.415708e-01,  6.845412e-01},
  { 1.737852e-01,  3.608548e-01,  9.162874e-01,  3.598591e-01,  7.684976e-01,  7.457440e-01},
  {-3.184609e-01,  4.002180e-01,  8.593068e-01,  2.468233e-01,  7.729204e-01,  7.294788e-01},
  { 9.946226e-01, -2.937413e-02,  9.931188e-02,  5.063056e-01,  7.859316e-01,  4.694918e-01},
  { 9.969203e-01, -4.736039e-02,  6.250684e-02,  5.132569e-01,  7.865753e-01,  3.873162e-01},
  {-9.544487e-01,  2.983212e-01,  5.668057e-03, -2.048981e-01,  7.772898e-01,  1.504306e-01},
  {-9.584700e-01,  2.780245e-01, -6.354267e-02, -2.021227e-01,  7.861166e-01,  1.447658e-01},
  {-8.868410e-01,  3.166304e-01,  3.365383e-01, -1.637419e-01,  8.011076e-01,  2.939553e-01},
  {-9.056325e-01,  3.187533e-01,  2.796893e-01, -1.779292e-01,  8.072470e-01,  2.491409e-01},
  {-9.415749e-01,  3.157179e-01,  1.172987e-01, -1.974559e-01,  7.870418e-01,  2.004119e-01},
  { 9.525146e-01, -2.341218e-01, -1.946863e-01,  4.377219e-01,  5.785862e-01, -1.656291e-02},
  { 9.932703e-01,  2.583167e-02, -1.129018e-01,  4.331051e-01,  5.702375e-01, -6.640298e-02},
  { 9.449114e-01, -2.102653e-01, -2.508607e-01,  4.789063e-01,  8.749787e-01, -1.190972e-01},
  { 2.636594e-01,  7.453703e-03, -9.645870e-01,  2.949494e-01,  8.537683e-01, -3.229055e-01},
  { 8.049973e-01, -1.182024e-01, -5.813841e-01,  4.311848e-01,  9.154713e-01, -2.468458e-01},
  { 7.068671e-01, -6.729970e-02, -7.041375e-01,  4.233032e-01,  9.236577e-01, -2.577090e-01},
  {-3.633570e-01,  9.313077e-01,  2.525318e-02, -1.403057e-01,  5.285634e-01, -6.982940e-01},
  { 2.340918e-01,  9.171881e-01,  3.224391e-01, -6.095238e-02,  5.358403e-01, -7.100922e-01},
  { 3.249404e-01,  9.200664e-01, -2.188416e-01, -5.731553e-02,  5.368866e-01, -7.506795e-01},
  {-2.055918e-01,  3.762979e-01,  9.034002e-01,  2.812734e-01,  7.606155e-01,  7.457113e-01},
  { 7.789111e-01,  1.215988e-01,  6.152326e-01,  4.378675e-01,  7.590248e-01,  7.039095e-01},
  { 8.578612e-01,  9.375444e-02,  5.052565e-01,  4.561573e-01,  7.615123e-01,  6.770495e-01},
  { 1.157341e-01,  3.914149e-01,  9.129074e-01,  3.561921e-01,  7.998542e-01,  7.329502e-01},
  {-1.233390e-02,  3.988788e-01,  9.169207e-01,  3.284314e-01,  7.950000e-01,  7.366018e-01},
  { 9.392932e-01,  5.035040e-03,  3.430786e-01,  4.751861e-01,  7.888896e-01,  6.279039e-01},
  {-5.035100e-01,  3.843727e-01,  7.737797e-01,  9.655332e-02,  8.064768e-01,  6.330851e-01},
  {-5.398106e-01,  2.909835e-01,  7.898943e-01,  9.794402e-02,  8.223455e-01,  6.260752e-01},
  {-4.969592e-01,  4.541342e-01,  7.394549e-01,  1.226254e-01,  9.407712e-01,  5.770345e-01},
  {-8.649016e-01,  3.130589e-01,  3.923512e-01, -1.325890e-01,  8.044089e-01,  3.656703e-01},
  {-9.724506e-01,  2.047033e-01, -1.115188e-01, -1.991171e-01,  7.934795e-01,  1.309130e-01},
  {-9.654954e-01,  1.965599e-01, -1.708299e-01, -1.971192e-01,  7.919726e-01,  1.124883e-01},
  { 9.928588e-01, -1.126852e-02, -1.187617e-01,  4.349976e-01,  5.585189e-01, -1.518935e-02},
  {-8.341306e-01, -3.582854e-02, -5.504020e-01, -1.378839e-01,  7.358381e-01, -4.866057e-02},
  {-8.857248e-01,  1.203888e-01, -4.483280e-01, -1.705595e-01,  7.500377e-01,  1.149631e-02},
  { 9.694731e-01, -1.951965e-01, -1.483921e-01,  4.953915e-01,  8.191114e-01,  3.399488e-02},
  {-7.588000e-01,  1.346064e-02, -6.511846e-01, -3.998714e-02,  7.037526e-01, -1.678229e-01},
  { 9.714881e-01, -1.864230e-01, -1.464831e-01,  4.900078e-01,  8.470770e-01, -3.347836e-02},
  { 9.482338e-01, -2.089509e-01, -2.391488e-01,  4.809665e-01,  8.845938e-01, -1.195898e-01},
  {-6.733754e-01, -1.302508e-03, -7.392995e-01, -6.102855e-03,  9.477928e-01, -2.052748e-01},
  {-7.360412e-01,  5.897169e-02, -6.743632e-01, -1.200290e-02,  9.612486e-01, -2.006894e-01},
  {-6.977715e-01, -7.078343e-02, -7.128146e-01,  9.571032e-04,  9.290299e-01, -2.115897e-01},
  { 2.852551e-01,  7.896143e-04, -9.584513e-01,  3.105087e-01,  8.762866e-01, -3.188089e-01},
  { 1.352736e-01,  3.359891e-02, -9.902384e-01,  2.593042e-01,  8.491251e-01, -3.305137e-01},
  {-4.865848e-01,  1.404685e-02, -8.735204e-01,  1.040602e-01,  8.441914e-01, -2.909263e-01},
  {-2.274469e-01,  6.041050e-02, -9.719149e-01,  1.913279e-01,  8.730354e-01, -3.248254e-01},
  {-1.444075e-01,  4.334058e-02, -9.885687e-01,  2.085665e-01,  8.680799e-01, -3.289031e-01},
  {-2.529624e-03,  3.223896e-02, -9.994770e-01,  2.443405e-01,  8.418725e-01, -3.321433e-01},
  {-3.609540e-01,  2.424216e-02, -9.322685e-01,  1.350963e-01,  8.608814e-01, -3.067916e-01},
  { 6.523006e-01,  6.343443e-01,  4.148630e-01, -4.347835e-02,  5.301813e-01, -7.116448e-01},
  {-2.198542e-01,  9.682931e-01,  1.186286e-01, -1.251932e-01,  5.336673e-01, -6.986777e-01},
  {-1.999652e-01,  9.730752e-01,  1.146236e-01, -1.200802e-01,  5.358016e-01, -7.055103e-01},
  { 7.454327e-01,  6.614506e-01,  8.254248e-02, -3.612714e-02,  5.273412e-01, -7.266460e-01},
  {-6.598052e-02,  9.837681e-01,  1.668742e-01, -9.644286e-02,  5.395939e-01, -7.081990e-01},
  { 1.519916e-01,  9.470601e-01,  2.827997e-01, -8.454369e-02,  5.392776e-01, -7.089728e-01},
  { 8.792169e-02,  9.883609e-01,  1.241467e-01, -7.594737e-02,  5.408477e-01, -7.180380e-01},
  {-1.322964e-01,  9.840631e-01, -1.188162e-01, -9.571134e-02,  5.409505e-01, -7.345710e-01},
  {-9.117287e-02,  9.859056e-01, -1.402765e-01, -9.176415e-02,  5.408551e-01, -7.378476e-01},
  { 6.565180e-01,  1.852215e-01,  7.312162e-01,  4.217283e-01,  7.578108e-01,  7.226476e-01},
  { 4.559543e-01,  2.765325e-01,  8.459523e-01,  4.056425e-01,  7.738788e-01,  7.300728e-01},
  {-1.490672e-01,  3.827852e-01,  9.117315e-01,  2.958967e-01,  7.817411e-01,  7.396545e-01},
  { 2.848351e-01,  3.403566e-01,  8.961174e-01,  3.911946e-01,  7.898655e-01,  7.304068e-01},
  { 9.206369e-01,  4.491618e-02,  3.878274e-01,  4.685233e-01,  8.156333e-01,  6.455379e-01},
  { 9.603726e-01,  5.741111e-02,  2.727425e-01,  4.778298e-01,  8.206863e-01,  6.158263e-01},
  { 9.733641e-01,  1.233428e-02,  2.289327e-01,  4.870946e-01,  7.965646e-01,  5.822826e-01},
  {-4.988752e-01,  4.310760e-01,  7.518623e-01,  1.120241e-01,  8.815054e-01,  6.037217e-01},
  {-5.453867e-01,  4.398742e-01,  7.134872e-01,  7.528711e-02,  8.951111e-01,  5.705384e-01},
  {-5.526029e-01,  4.385261e-01,  7.087488e-01,  7.587434e-02,  9.185967e-01,  5.566401e-01},
  {-5.487935e-01,  4.395834e-01,  7.110500e-01,  6.997063e-02,  9.032614e-01,  5.615515e-01},
  {-5.657561e-01,  4.502780e-01,  6.907748e-01,  7.918111e-02,  9.411040e-01,  5.450221e-01},
  { 9.915124e-01, -2.269945e-02,  1.280154e-01,  5.086128e-01,  8.223455e-01,  4.578956e-01},
  {-4.202453e-01,  4.640026e-01,  7.798048e-01,  1.302977e-01,  9.871564e-01,  5.528233e-01},
  {-8.229089e-01,  3.197781e-01,  4.696413e-01, -1.090258e-01,  8.225728e-01,  3.998981e-01},
  {-9.611320e-01,  2.742530e-01, -3.178789e-02, -1.930935e-01,  8.160716e-01,  1.362454e-01},
  {-9.258476e-01,  3.134385e-01,  2.110981e-01, -1.687258e-01,  8.568083e-01,  2.212424e-01},
  { 9.822537e-01, -1.603643e-01, -9.726807e-02,  5.093830e-01,  7.935546e-01,  1.938872e-01},
  {-9.166896e-01,  3.221313e-01,  2.364564e-01, -1.661494e-01,  8.688173e-01,  2.146437e-01},
  { 9.548315e-01, -1.866208e-01, -2.312347e-01,  4.880262e-01,  9.033701e-01, -1.070094e-01},
  {-7.060122e-01, -7.138088e-03, -7.081637e-01, -5.210339e-03,  8.997846e-01, -2.044111e-01},
  {-6.376681e-01,  7.885142e-03, -7.702709e-01,  5.781316e-02,  7.700796e-01, -2.602161e-01},
  { 9.277862e-01, -1.875272e-01, -3.225624e-01,  4.781242e-01,  9.220707e-01, -1.553154e-01},
  { 4.252412e-01, -2.826015e-02, -9.046387e-01,  3.629890e-01,  9.065648e-01, -2.994339e-01},
  {-5.221145e-01, -4.305123e-02, -8.517881e-01,  8.205961e-02,  7.906321e-01, -2.778814e-01},
  {-6.343665e-01,  4.811337e-02, -7.715337e-01,  1.481108e-02,  9.491596e-01, -2.233753e-01},
  { 8.659222e-01, -1.787662e-01, -4.671416e-01,  4.550202e-01,  9.373046e-01, -2.156340e-01},
  {-5.535347e-01,  2.593483e-02, -8.324223e-01,  8.336001e-02,  8.712075e-01, -2.770234e-01},
  { 7.900136e-01, -1.505669e-01, -5.943131e-01,  4.399749e-01,  9.379227e-01, -2.402192e-01},
  {-1.568489e-02,  3.458619e-02, -9.992785e-01,  2.348187e-01,  8.693396e-01, -3.310795e-01},
  { 6.949119e-01,  6.843985e-01,  2.206719e-01, -4.186095e-02,  5.312309e-01, -7.155856e-01},
  { 4.171029e-01,  8.524552e-01,  3.151910e-01, -4.587675e-02,  5.340809e-01, -7.155603e-01},
  { 4.041990e-01,  9.129151e-01,  5.665107e-02, -4.840574e-02,  5.357967e-01, -7.204716e-01},
  { 5.264148e-01,  8.450992e-01, -9.324526e-02, -4.705540e-02,  5.350472e-01, -7.356429e-01},
  { 2.386636e-01,  9.524534e-01,  1.893994e-01, -6.665521e-02,  5.398997e-01, -7.245988e-01},
  { 2.380093e-01,  9.712596e-01,  2.504821e-03, -5.491442e-02,  5.380327e-01, -7.348997e-01},
  {-8.623729e-02,  9.959834e-01,  2.408635e-02, -1.056036e-01,  5.401940e-01, -7.254287e-01},
  {-2.343970e-01,  9.719751e-01, -1.795257e-02, -1.098447e-01,  5.398004e-01, -7.232270e-01},
  { 7.688089e-02,  9.861742e-01, -1.467989e-01, -7.390432e-02,  5.406675e-01, -7.456828e-01},
  { 6.548819e-01,  2.039962e-01,  7.276781e-01,  4.231963e-01,  7.744279e-01,  7.167191e-01},
  { 7.172197e-01,  1.955910e-01,  6.688349e-01,  4.272394e-01,  7.790543e-01,  7.116374e-01},
  { 2.463180e-01,  3.775276e-01,  8.926368e-01,  3.870814e-01,  8.095055e-01,  7.237331e-01},
  {-2.636226e-01,  4.050455e-01,  8.754663e-01,  2.719843e-01,  7.950609e-01,  7.279542e-01},
  { 1.523947e-03,  3.918938e-01,  9.200092e-01,  3.321215e-01,  8.313985e-01,  7.208082e-01},
  { 8.303623e-01,  1.037442e-01,  5.474812e-01,  4.608458e-01,  8.200629e-01,  6.605135e-01},
  {-4.635528e-01,  4.000820e-01,  7.906031e-01,  1.779978e-01,  8.711696e-01,  6.505661e-01},
  { 9.807375e-01,  1.611658e-02,  1.946644e-01,  4.958968e-01,  8.389859e-01,  5.363153e-01},
  { 9.954332e-01, -2.566391e-02,  9.194691e-02,  5.115826e-01,  8.409478e-01,  4.365692e-01},
  {-5.227941e-01,  5.102482e-01,  6.828858e-01,  9.935857e-02,  9.875666e-01,  5.306798e-01},
  {-9.654920e-01,  2.603160e-01, -7.789019e-03, -1.872329e-01,  8.366954e-01,  1.321476e-01},
  {-8.810610e-01,  3.395861e-01,  3.292613e-01, -1.500354e-01,  8.688341e-01,  2.649127e-01},
  {-9.121189e-01,  3.264149e-01,  2.479771e-01, -1.585503e-01,  8.805014e-01,  2.271896e-01},
  {-9.290683e-01,  1.452381e-01, -3.402027e-01, -1.721317e-01,  8.069472e-01,  3.334608e-02},
  { 9.754382e-01, -1.806932e-01, -1.259767e-01,  5.034038e-01,  8.221290e-01,  8.682090e-02},
  { 9.942541e-01,  3.212973e-02, -1.021103e-01,  4.336321e-01,  5.629564e-01, -2.428268e-02},
  { 8.747327e-01, -4.574391e-01, -1.599756e-01,  4.343693e-01,  5.788208e-01, -3.099866e-02},
  {-7.580536e-01, -3.253258e-02, -6.513804e-01, -2.206327e-02,  9.308251e-01, -1.864693e-01},
  { 4.399716e-01, -1.756209e-02, -8.978400e-01,  3.642216e-01,  9.294862e-01, -2.994126e-01},
  { 2.915982e-01,  4.815300e-03, -9.565287e-01,  3.264824e-01,  9.140324e-01, -3.137026e-01},
  {-6.513652e-01, -1.242923e-02, -7.586626e-01,  2.191268e-02,  9.152945e-01, -2.298571e-01},
  { 5.298228e-01, -5.211242e-02, -8.465058e-01,  3.849365e-01,  9.386327e-01, -2.885241e-01},
  {-1.272159e-01,  7.234245e-02, -9.892334e-01,  2.108621e-01,  9.233027e-01, -3.252260e-01},
  {-2.628532e-01,  5.590066e-02, -9.632151e-01,  1.798066e-01,  9.291745e-01, -3.192388e-01},
  { 1.287328e-01,  5.713928e-02, -9.900318e-01,  2.552952e-01,  8.827375e-01, -3.289356e-01},
  {-6.894021e-02,  8.017778e-02, -9.943936e-01,  2.279720e-01,  8.909123e-01, -3.294058e-01},
  { 5.275675e-01,  2.872478e-01,  7.994756e-01,  4.141415e-01,  8.015303e-01,  7.149423e-01},
  { 7.155985e-01,  1.861530e-01,  6.732502e-01,  4.322768e-01,  8.027934e-01,  6.994754e-01},
  {-1.280477e-01,  4.028597e-01,  9.062603e-01,  2.984767e-01,  7.927955e-01,  7.352435e-01},
  {-2.909743e-01,  4.011281e-01,  8.685794e-01,  2.572711e-01,  8.438439e-01,  7.006451e-01},
  {-5.880768e-01,  1.108077e-01,  8.011786e-01,  4.597098e-02,  8.228151e-01,  5.904723e-01},
  { 8.503137e-01,  1.725558e-01,  4.971832e-01,  4.627738e-01,  8.348704e-01,  6.524807e-01},
  { 9.183442e-01,  1.313528e-01,  3.733503e-01,  4.720120e-01,  8.405669e-01,  6.307214e-01},
  {-3.982951e-01,  4.049448e-01,  8.230314e-01,  2.093498e-01,  8.660232e-01,  6.701081e-01},
  {-6.581433e-01,  4.148418e-01,  6.282943e-01,  3.297793e-02,  8.917311e-01,  5.361326e-01},
  { 9.871162e-01,  3.587785e-02,  1.559309e-01,  5.050880e-01,  8.677802e-01,  4.830412e-01},
  {-5.739492e-01,  4.546476e-01,  6.810858e-01,  7.664307e-02,  9.683936e-01,  5.247549e-01},
  { 9.962651e-01, -8.633091e-02, -1.731952e-03,  5.151532e-01,  7.962868e-01,  3.290785e-01},
  { 9.970376e-01, -6.005372e-02,  4.805787e-02,  5.184997e-01,  8.382027e-01,  3.558856e-01},
  {-9.639913e-01,  2.157256e-01, -1.555097e-01, -1.875603e-01,  8.261989e-01,  9.496782e-02},
  {-9.587886e-01,  2.820996e-01,  3.382516e-02, -1.767527e-01,  8.731546e-01,  1.338185e-01},
  {-9.540049e-01,  2.021663e-01, -2.213672e-01, -1.725005e-01,  8.675548e-01,  6.802333e-02},
  {-9.513988e-01,  2.285467e-01, -2.064138e-01, -1.690057e-01,  8.799758e-01,  6.505144e-02},
  {-8.086544e-01, -3.423802e-02, -5.872868e-01, -1.127732e-01,  7.339443e-01, -8.484781e-02},
  {-8.650194e-01,  8.637004e-02, -4.942487e-01, -1.422266e-01,  7.821118e-01, -3.548009e-02},
  {-9.012024e-01,  9.338957e-02, -4.232171e-01, -1.528684e-01,  8.281218e-01, -5.684630e-03},
  {-9.349819e-01,  1.721995e-01, -3.100904e-01, -1.623294e-01,  8.676066e-01,  3.333021e-02},
  { 9.699591e-01, -2.109957e-01, -1.210786e-01,  4.994671e-01,  8.978002e-01, -3.858549e-02},
  {-6.540185e-01,  1.135619e-01, -7.479061e-01,  1.742709e-02,  9.848863e-01, -2.210518e-01},
  {-7.640182e-01,  1.636153e-01, -6.241043e-01, -1.566486e-02,  9.725444e-01, -1.934384e-01},
  {-1.371713e-01,  8.762107e-02, -9.866644e-01,  2.045397e-01,  9.636883e-01, -3.212192e-01},
  { 9.220791e-01, -1.793002e-01, -3.429599e-01,  4.776260e-01,  9.604922e-01, -1.769511e-01},
  { 3.486799e-01,  6.013819e-03, -9.372225e-01,  3.492172e-01,  9.418276e-01, -3.060220e-01},
  { 6.582975e-01, -9.224667e-02, -7.470843e-01,  4.048433e-01,  9.655679e-01, -2.775710e-01},
  {-4.531764e-03,  8.304213e-02, -9.965358e-01,  2.470484e-01,  9.438176e-01, -3.257962e-01},
  {-5.809948e-01,  3.941024e-02, -8.129525e-01,  4.649757e-02,  9.365433e-01, -2.483837e-01},
  { 7.621621e-01, -1.599312e-01, -6.273204e-01,  4.457948e-01,  9.806238e-01, -2.414187e-01},
  { 7.041064e-01, -1.676742e-01, -6.900142e-01,  4.304085e-01,  9.808751e-01, -2.588577e-01},
  {-1.621590e-01,  4.088814e-01,  8.980649e-01,  2.930833e-01,  8.222868e-01,  7.207010e-01},
  {-1.810003e-01,  3.937183e-01,  9.012352e-01,  2.948234e-01,  8.443266e-01,  7.113237e-01},
  { 3.059440e-01,  3.039265e-01,  9.022344e-01,  3.939596e-01,  8.468431e-01,  7.060558e-01},
  { 1.737325e-01,  3.503509e-01,  9.203647e-01,  3.753797e-01,  8.501422e-01,  7.089506e-01},
  {-6.695781e-01,  2.336178e-01,  7.050446e-01,  2.391983e-02,  8.191987e-01,  5.734732e-01},
  { 9.439255e-01,  9.510536e-02,  3.161639e-01,  4.773950e-01,  8.725910e-01,  6.055885e-01},
  { 9.638913e-01,  8.929870e-02,  2.508772e-01,  4.943695e-01,  8.978416e-01,  5.365569e-01},
  {-6.341631e-01,  4.297143e-01,  6.427930e-01,  5.267801e-02,  9.559474e-01,  5.109608e-01},
  {-6.099893e-01,  2.023825e-01,  7.661295e-01, -1.029762e-02,  9.110615e-01,  4.729287e-01},
  {-6.526480e-01,  2.969769e-01,  6.970332e-01, -1.549514e-02,  9.043927e-01,  4.700819e-01},
  {-2.181075e-01,  4.080339e-01,  8.865311e-01,  1.578818e-01,  1.030754e+00,  5.412506e-01},
  {-8.599959e-01,  3.339759e-01,  3.858331e-01, -1.219697e-01,  8.488315e-01,  3.530793e-01},
  { 9.983006e-01, -4.160810e-02,  4.080006e-02,  5.198028e-01,  8.707075e-01,  3.342554e-01},
  {-9.614030e-01,  2.350894e-01, -1.429589e-01, -1.852020e-01,  8.382509e-01,  9.769243e-02},
  {-9.124809e-01,  3.372227e-01,  2.316450e-01, -1.533624e-01,  9.142330e-01,  2.013362e-01},
  {-9.449952e-01,  2.963097e-01,  1.385088e-01, -1.645772e-01,  9.118416e-01,  1.451199e-01},
  {-9.036228e-01,  3.417938e-01,  2.581527e-01, -1.450831e-01,  9.295130e-01,  2.117679e-01},
  { 9.883245e-01, -1.026545e-01, -1.125908e-01,  4.334163e-01,  5.745262e-01, -3.241978e-02},
  {-7.255594e-01,  4.765981e-03, -6.881431e-01, -3.830414e-02,  8.018752e-01, -1.689441e-01},
  {-8.161172e-01,  8.983296e-02, -5.708615e-01, -2.863805e-02,  9.698207e-01, -1.752619e-01},
  {-1.249686e-01,  1.081285e-01, -9.862510e-01,  2.039390e-01,  9.832065e-01, -3.191839e-01},
  {-2.293122e-01,  1.358103e-01, -9.638317e-01,  1.793872e-01,  9.813302e-01, -3.148817e-01},
  {-2.724909e-01,  9.652606e-02, -9.573042e-01,  1.729338e-01,  9.641637e-01, -3.149785e-01},
  {-5.803576e-01,  1.102871e-01, -8.068593e-01,  4.337697e-02,  9.715503e-01, -2.431855e-01},
  { 1.062966e-04,  9.129056e-02, -9.958243e-01,  2.465107e-01,  9.677017e-01, -3.236831e-01},
  { 4.281669e-01, -1.841423e-02, -9.035121e-01,  3.743207e-01,  9.715967e-01, -2.953939e-01},
  { 6.196677e-01, -8.411758e-02, -7.803436e-01,  4.222991e-01,  9.908606e-01, -2.674448e-01},
  {-4.178931e-01,  4.385191e-02, -9.074373e-01,  1.359782e-01,  9.169154e-01, -3.050019e-01},
  { 6.538033e-01,  2.344453e-01,  7.194279e-01,  4.301400e-01,  8.255539e-01,  6.945979e-01},
  { 4.036039e-01,  2.916043e-01,  8.672201e-01,  4.158920e-01,  8.295619e-01,  7.037638e-01},
  { 7.146946e-01,  2.159691e-01,  6.652586e-01,  4.407204e-01,  8.373352e-01,  6.802178e-01},
  { 8.074287e-01,  2.046650e-01,  5.533272e-01,  4.558668e-01,  8.554706e-01,  6.555279e-01},
  { 3.035861e-02,  3.973998e-01,  9.171432e-01,  3.379206e-01,  8.744584e-01,  7.023169e-01},
  { 9.001964e-01,  1.456209e-01,  4.104157e-01,  4.694062e-01,  8.677409e-01,  6.276892e-01},
  {-5.798109e-01,  3.966743e-01,  7.116663e-01,  3.510072e-02,  8.355443e-01,  5.763603e-01},
  {-4.511365e-01,  4.428219e-01,  7.748449e-01,  1.953777e-01,  9.369360e-01,  6.249570e-01},
  {-5.856504e-01,  2.297124e-01,  7.773325e-01,  4.259594e-03,  9.249149e-01,  4.796547e-01},
  { 9.947965e-01,  1.769394e-02,  1.003336e-01,  5.146883e-01,  8.891104e-01,  4.084734e-01},
  {-7.102141e-01,  3.433616e-01,  6.145720e-01, -6.157895e-02,  8.820477e-01,  4.317534e-01},
  {-5.175286e-01,  5.385944e-01,  6.648911e-01,  1.143839e-01,  1.028546e+00,  5.100986e-01},
  {-8.097337e-01,  3.335527e-01,  4.827773e-01, -9.742679e-02,  8.701709e-01,  3.870042e-01},
  { 9.937257e-01, -1.113593e-01, -1.041342e-02,  5.213252e-01,  8.686631e-01,  2.480451e-01},
  { 9.977034e-01, -2.356466e-02,  6.350213e-02,  5.222470e-01,  8.942347e-01,  3.133222e-01},
  {-9.635567e-01,  2.219083e-01, -1.493826e-01, -1.819727e-01,  8.492295e-01,  9.321050e-02},
  {-9.603930e-01,  2.650000e-01, -8.614142e-02, -1.736947e-01,  8.823811e-01,  1.018223e-01},
  { 9.877395e-01, -1.337279e-01, -8.054462e-02,  5.146570e-01,  8.561679e-01,  1.387946e-01},
  {-9.521769e-01,  2.834690e-01,  1.140366e-01, -1.563567e-01,  9.411120e-01,  1.411770e-01},
  {-8.718643e-01,  7.403342e-02, -4.841195e-01, -1.352117e-01,  8.063636e-01, -4.444521e-02},
  { 9.444619e-01, -3.185214e-01, -8.084344e-02,  4.336767e-01,  5.795596e-01, -3.966080e-02},
  {-7.278119e-01,  2.071032e-02, -6.854640e-01, -3.881241e-02,  8.371693e-01, -1.680660e-01},
  { 9.659108e-01, -1.855711e-01, -1.804983e-01,  5.044453e-01,  9.627370e-01, -8.958653e-02},
  { 9.369219e-01, -1.767127e-01, -3.015790e-01,  4.958571e-01,  9.959484e-01, -1.441322e-01},
  { 9.079521e-01, -1.348220e-01, -3.967946e-01,  4.826248e-01,  1.000969e+00, -1.830832e-01},
  { 2.824609e-01,  1.650202e-02, -9.591369e-01,  3.297443e-01,  9.718031e-01, -3.115321e-01},
  { 1.653837e-01,  4.039511e-02, -9.854016e-01,  2.969815e-01,  9.654809e-01, -3.190381e-01},
  { 8.649454e-01, -1.507640e-01, -4.786855e-01,  4.655290e-01,  1.002804e+00, -2.183789e-01},
  {-4.958703e-01,  4.935804e-02, -8.669927e-01,  1.212346e-01,  9.346646e-01, -2.970326e-01},
  { 6.252500e-01, -1.237643e-01, -7.705485e-01,  4.363674e-01,  1.023990e+00, -2.618915e-01},
  {-1.406371e-01,  3.960431e-01,  9.073979e-01,  3.085610e-01,  8.601218e-01,  7.073202e-01},
  { 1.372712e-01,  3.870668e-01,  9.117763e-01,  3.699279e-01,  9.029058e-01,  6.872291e-01},
  { 9.173748e-01,  1.580294e-01,  3.653084e-01,  4.735473e-01,  9.023234e-01,  6.053312e-01},
  {-5.585543e-01,  5.198112e-01,  6.463850e-01,  7.855184e-02,  1.003086e+00,  5.005051e-01},
  {-7.003012e-01,  2.549387e-01,  6.667717e-01, -6.873241e-02,  8.904432e-01,  4.187951e-01},
  {-8.450598e-01,  3.789047e-01,  3.772336e-01, -1.026466e-01,  8.980319e-01,  3.501261e-01},
  {-8.383895e-01,  3.959191e-01,  3.746345e-01, -1.022660e-01,  9.303866e-01,  3.159333e-01},
  {-8.402442e-01,  3.833808e-01,  3.834172e-01, -1.052087e-01,  9.333113e-01,  3.063763e-01},
  {-9.096786e-01,  3.128105e-01,  2.731931e-01, -1.382653e-01,  9.536397e-01,  2.051090e-01},
  {-9.285377e-01,  3.012142e-01,  2.169969e-01, -1.461108e-01,  9.550547e-01,  1.743168e-01},
  {-9.694601e-01,  2.429935e-01, -3.318471e-02, -1.583204e-01,  9.409288e-01,  9.626345e-02},
  {-9.568593e-01,  1.887641e-01, -2.208811e-01, -1.538873e-01,  9.143122e-01,  3.505104e-02},
  {-7.950459e-01,  8.338337e-02, -6.007906e-01, -6.885709e-02,  9.308087e-01, -1.261455e-01},
  {-7.434741e-01,  3.390976e-02, -6.679045e-01, -4.325442e-02,  8.535557e-01, -1.627653e-01},
  { 9.550135e-01, -1.757362e-01, -2.388849e-01,  5.078152e-01,  9.858121e-01, -9.348787e-02},
  {-5.836348e-01,  2.095003e-01, -7.845254e-01,  4.988043e-02,  1.010151e+00, -2.396643e-01},
  {-1.226070e-01,  1.634995e-01, -9.788950e-01,  2.193311e-01,  1.011830e+00, -3.168649e-01},
  {-2.481833e-01,  1.718720e-01, -9.533442e-01,  1.789333e-01,  1.010482e+00, -3.101372e-01},
  {-3.717071e-01,  1.635354e-01, -9.138326e-01,  1.555454e-01,  9.950029e-01, -3.051132e-01},
  {-7.043612e-01,  1.525010e-01, -6.932666e-01, -8.750918e-03,  1.003637e+00, -1.932494e-01},
  { 9.249374e-01, -1.322280e-01, -3.563797e-01,  4.906562e-01,  1.014440e+00, -1.683792e-01},
  {-4.098552e-01,  9.282868e-02, -9.074147e-01,  1.398801e-01,  9.642795e-01, -3.031668e-01},
  { 1.505219e-02,  8.186639e-02, -9.965297e-01,  2.615316e-01,  9.952865e-01, -3.210795e-01},
  { 4.952575e-01, -4.104256e-02, -8.677762e-01,  4.092002e-01,  1.011396e+00, -2.789082e-01},
  { 8.342829e-01, -1.869690e-01, -5.186663e-01,  4.574185e-01,  1.031387e+00, -2.403900e-01},
  { 7.133817e-01, -1.814030e-01, -6.768896e-01,  4.493494e-01,  1.043948e+00, -2.544137e-01},
  { 5.206518e-01,  3.050550e-01,  7.974103e-01,  4.202128e-01,  8.559594e-01,  6.909150e-01},
  { 4.618160e-01,  3.400745e-01,  8.191919e-01,  4.160949e-01,  8.641005e-01,  6.899050e-01},
  { 3.601436e-01,  3.726599e-01,  8.552316e-01,  4.087864e-01,  8.811456e-01,  6.863393e-01},
  { 7.588246e-01,  2.286318e-01,  6.098465e-01,  4.526367e-01,  8.784385e-01,  6.514323e-01},
  { 8.643696e-01,  1.853834e-01,  4.674380e-01,  4.650873e-01,  8.942325e-01,  6.264383e-01},
  {-3.283668e-01,  4.125271e-01,  8.497038e-01,  2.604255e-01,  9.114929e-01,  6.702757e-01},
  {-3.922893e-01,  4.415444e-01,  8.069372e-01,  2.360562e-01,  9.399182e-01,  6.453701e-01},
  {-4.210133e-01,  4.855914e-01,  7.661258e-01,  2.268487e-01,  9.792649e-01,  6.167682e-01},
  { 9.645604e-01,  1.193242e-01,  2.353402e-01,  4.894179e-01,  9.411057e-01,  5.379995e-01},
  {-6.056869e-01,  4.856752e-01,  6.302880e-01,  6.261567e-02,  1.006307e+00,  4.831876e-01},
  {-3.954476e-01,  5.117979e-01,  7.626822e-01,  1.793312e-01,  1.059896e+00,  5.319189e-01},
  {-7.116926e-01,  3.126287e-01,  6.290922e-01, -6.159127e-02,  9.026026e-01,  4.211236e-01},
  {-8.573838e-01,  3.625183e-01,  3.653403e-01, -1.154182e-01,  9.563921e-01,  2.618114e-01},
  {-9.753538e-01,  2.114947e-01, -6.288780e-02, -1.560726e-01,  9.483730e-01,  8.801614e-02},
  {-8.386283e-01,  7.187880e-02, -5.399408e-01, -1.206716e-01,  8.039411e-01, -6.861138e-02},
  {-8.983061e-01,  1.284013e-01, -4.201893e-01, -1.408242e-01,  8.757591e-01, -1.735660e-02},
  {-7.798067e-01,  3.469077e-02, -6.250584e-01, -9.178496e-02,  7.966613e-01, -1.084765e-01},
  {-7.771906e-01,  5.905338e-02, -6.264881e-01, -7.588315e-02,  8.680627e-01, -1.233952e-01},
  { 9.766546e-01, -1.826299e-01, -1.131025e-01,  5.121366e-01,  9.481474e-01, -2.534536e-02},
  {-2.154094e-01,  2.117527e-01, -9.532888e-01,  1.875251e-01,  1.031989e+00, -3.079772e-01},
  {-4.284813e-01,  2.784557e-01, -8.595733e-01,  1.448371e-01,  1.026635e+00, -2.941419e-01},
  {-7.708980e-01,  1.155132e-01, -6.263969e-01, -1.769590e-02,  1.005198e+00, -1.824621e-01},
  {-4.774198e-01,  2.171464e-01, -8.514210e-01,  1.149421e-01,  1.015015e+00, -2.810917e-01},
  {-4.093529e-01,  1.377943e-01, -9.019107e-01,  1.343423e-01,  9.808341e-01, -2.984194e-01},
  {-4.908539e-01,  1.625629e-01, -8.559414e-01,  1.126622e-01,  9.955191e-01, -2.841216e-01},
  { 9.001858e-01, -1.900652e-01, -3.918428e-01,  4.879311e-01,  1.038604e+00, -1.848065e-01},
  { 9.226148e-01, -1.349803e-01, -3.613341e-01,  4.844922e-01,  1.041678e+00, -1.942856e-01},
  { 3.707296e-01, -1.840475e-03, -9.287390e-01,  3.705206e-01,  1.011813e+00, -2.974056e-01},
  { 2.817842e-01,  3.033633e-02, -9.589980e-01,  3.319101e-01,  1.000899e+00, -3.101760e-01},
  {-5.484694e-01,  9.489515e-02, -8.307685e-01,  8.067054e-02,  9.577828e-01, -2.706001e-01},
  { 6.964314e-01, -2.499796e-01, -6.726763e-01,  4.551536e-01,  1.059335e+00, -2.527562e-01},
  { 6.398280e-01,  2.754242e-01,  7.174689e-01,  4.323196e-01,  8.623123e-01,  6.797200e-01},
  {-2.188976e-01,  4.060278e-01,  8.872572e-01,  2.939965e-01,  9.054396e-01,  6.838287e-01},
  {-5.166502e-02,  4.015136e-01,  9.143947e-01,  3.213091e-01,  9.085447e-01,  6.872357e-01},
  {-2.498938e-02,  4.021987e-01,  9.152113e-01,  3.349001e-01,  9.364231e-01,  6.762253e-01},
  {-3.190047e-01,  4.498476e-01,  8.341901e-01,  2.601140e-01,  9.454274e-01,  6.531823e-01},
  { 1.116611e-01,  4.212509e-01,  9.000441e-01,  3.503841e-01,  9.477373e-01,  6.703328e-01},
  {-4.144764e-01,  4.996924e-01,  7.606030e-01,  2.377160e-01,  9.971611e-01,  6.112386e-01},
  {-3.764227e-01,  3.699638e-01,  8.493720e-01,  2.371250e-01,  1.020389e+00,  5.951757e-01},
  { 9.863691e-01,  8.013037e-02,  1.437184e-01,  5.100614e-01,  9.350206e-01,  4.289100e-01},
  {-6.876955e-01,  3.875566e-01,  6.139012e-01, -4.733273e-02,  9.259303e-01,  4.227500e-01},
  {-6.580855e-01,  3.230107e-01,  6.801379e-01, -5.572457e-02,  9.104975e-01,  4.231811e-01},
  {-7.902637e-01,  4.037248e-01,  4.609660e-01, -7.124211e-02,  9.192613e-01,  3.943115e-01},
  { 9.951487e-01, -9.739143e-02,  1.393019e-02,  5.262797e-01,  9.076484e-01,  2.147958e-01},
  {-9.261901e-01,  3.254031e-01,  1.904859e-01, -1.422411e-01,  9.747878e-01,  1.612423e-01},
  {-9.597809e-01,  2.709424e-01,  7.355836e-02, -1.487016e-01,  9.734456e-01,  1.234064e-01},
  {-9.751109e-01,  2.137367e-01, -5.895203e-02, -1.531156e-01,  9.624607e-01,  8.815755e-02},
  {-5.931542e-01,  2.390749e-01, -7.687726e-01,  4.067892e-02,  1.059582e+00, -2.190015e-01},
  {-3.154651e-01,  3.094452e-01, -8.970649e-01,  1.738318e-01,  1.040998e+00, -3.021536e-01},
  {-3.540679e-01,  2.703739e-01, -8.952842e-01,  1.636917e-01,  1.035112e+00, -3.000983e-01},
  {-4.110123e-01,  2.648535e-01, -8.723081e-01,  1.538421e-01,  1.043480e+00, -2.940535e-01},
  {-5.337717e-01,  2.034724e-01, -8.207842e-01,  7.971034e-02,  1.035778e+00, -2.530058e-01},
  {-6.643323e-01,  2.283515e-01, -7.117010e-01, -1.163468e-03,  1.030394e+00, -1.919428e-01},
  { 9.609061e-01, -1.278513e-01, -2.455880e-01,  5.064158e-01,  1.033437e+00, -1.287504e-01},
  {-6.429619e-02,  1.390849e-01, -9.881909e-01,  2.541238e-01,  1.024848e+00, -3.178396e-01},
  { 3.741379e-01,  1.256481e-02, -9.272879e-01,  3.844925e-01,  1.032159e+00, -2.917561e-01},
  {-5.157346e-01,  1.275166e-01, -8.472057e-01,  9.474199e-02,  9.622351e-01, -2.790988e-01},
  { 4.635382e-02,  1.276097e-01, -9.907407e-01,  2.851915e-01,  1.024766e+00, -3.177114e-01},
  { 8.532259e-01, -1.769080e-01, -4.906212e-01,  4.702836e-01,  1.065298e+00, -2.330069e-01},
  { 7.883968e-01, -1.930631e-01, -5.840866e-01,  4.628046e-01,  1.080295e+00, -2.530763e-01},
  { 6.234633e-01, -4.080750e-01, -6.669095e-01,  4.562878e-01,  1.075204e+00, -2.577682e-01},
  { 5.838889e-01,  3.169452e-01,  7.474086e-01,  4.318180e-01,  8.758423e-01,  6.746566e-01},
  { 3.693943e-01,  3.742657e-01,  8.505722e-01,  4.094850e-01,  9.058288e-01,  6.750432e-01},
  { 7.612989e-01,  2.679862e-01,  5.904299e-01,  4.518687e-01,  9.046502e-01,  6.422150e-01},
  { 2.896098e-01,  3.988972e-01,  8.700616e-01,  4.022504e-01,  9.140282e-01,  6.738806e-01},
  {-7.242814e-02,  3.867315e-01,  9.193438e-01,  3.228942e-01,  9.226791e-01,  6.813871e-01},
  {-1.889913e-01,  4.214616e-01,  8.869343e-01,  3.063163e-01,  9.300655e-01,  6.755401e-01},
  {-1.063002e-01,  4.222854e-01,  9.002085e-01,  3.251702e-01,  9.540898e-01,  6.673284e-01},
  { 9.072317e-01,  2.068377e-01,  3.662633e-01,  4.751670e-01,  9.326263e-01,  5.866170e-01},
  { 9.236556e-01,  1.928164e-01,  3.311828e-01,  4.809361e-01,  9.549699e-01,  5.571756e-01},
  {-3.354799e-01,  4.784464e-01,  8.115062e-01,  2.507007e-01,  1.029070e+00,  5.965069e-01},
  {-3.267105e-01,  3.705687e-01,  8.694475e-01,  2.425396e-01,  1.025386e+00,  5.957913e-01},
  { 9.423524e-01,  1.998843e-01,  2.683623e-01,  4.894587e-01,  9.693339e-01,  5.190265e-01},
  { 9.759676e-01,  1.173462e-01,  1.836218e-01,  5.025013e-01,  9.571642e-01,  4.681192e-01},
  {-6.421229e-01,  4.490401e-01,  6.213221e-01,  1.031379e-04,  1.007258e+00,  4.140601e-01},
  {-6.361464e-01,  3.997129e-01,  6.599602e-01, -5.895439e-03,  1.005302e+00,  4.100710e-01},
  {-4.427291e-01,  5.797487e-01,  6.840193e-01,  2.054866e-01,  1.093557e+00,  5.219079e-01},
  {-7.033362e-01,  4.373277e-01,  5.604129e-01, -4.525853e-02,  9.441220e-01,  4.122785e-01},
  {-6.795459e-01,  4.262543e-01,  5.970969e-01, -2.266776e-02,  9.921513e-01,  3.998714e-01},
  { 9.940611e-01,  4.818702e-02,  9.757347e-02,  5.213439e-01,  9.840714e-01,  3.023116e-01},
  { 9.971545e-01, -1.383156e-02,  7.410462e-02,  5.268893e-01,  9.516346e-01,  2.471709e-01},
  {-8.965011e-01,  3.452286e-01,  2.776744e-01, -1.249343e-01,  9.860462e-01,  2.086675e-01},
  { 9.866623e-01, -1.448132e-01, -7.434175e-02,  5.259905e-01,  9.432405e-01,  1.229905e-01},
  {-9.223689e-01,  1.501724e-01, -3.559268e-01, -1.404519e-01,  9.100579e-01, -6.565963e-03},
  {-8.258626e-01,  1.580616e-01, -5.412648e-01, -8.406223e-02,  9.670743e-01, -9.814594e-02},
  { 9.806819e-01, -1.241347e-01, -1.511740e-01,  5.181386e-01,  1.027603e+00, -7.143909e-02},
  {-5.227419e-01,  2.543437e-01, -8.136646e-01,  8.339664e-02,  1.075750e+00, -2.435004e-01},
  {-6.698024e-01,  2.440715e-01, -7.012802e-01,  1.765367e-02,  1.067944e+00, -1.968985e-01},
  {-2.134670e-03,  2.276470e-01, -9.737414e-01,  2.564811e-01,  1.044119e+00, -3.150174e-01},
  { 2.309600e-01,  6.004064e-02, -9.711090e-01,  3.192590e-01,  1.043261e+00, -3.115303e-01},
  { 4.894491e-01, -9.465703e-02, -8.668792e-01,  4.317696e-01,  1.065716e+00, -2.713706e-01},
  { 6.928129e-01, -3.846900e-01, -6.099376e-01,  4.597522e-01,  1.077219e+00, -2.562010e-01},
  { 5.679298e-01,  3.039645e-01,  7.648930e-01,  4.299039e-01,  8.880051e-01,  6.711369e-01},
  { 6.671684e-01,  2.854115e-01,  6.880600e-01,  4.401125e-01,  9.005412e-01,  6.573839e-01},
  { 5.216647e-01,  3.465143e-01,  7.796113e-01,  4.281235e-01,  8.993575e-01,  6.677229e-01},
  {-2.451152e-01,  4.546102e-01,  8.562990e-01,  2.957131e-01,  9.612683e-01,  6.568548e-01},
  {-5.480393e-02,  4.431351e-01,  8.947780e-01,  3.268780e-01,  9.678282e-01,  6.614871e-01},
  { 1.765406e-01,  4.443921e-01,  8.782648e-01,  3.644525e-01,  9.638183e-01,  6.601067e-01},
  {-3.121067e-01,  4.871755e-01,  8.156283e-01,  2.796125e-01,  1.009694e+00,  6.233013e-01},
  { 8.923280e-01,  2.648261e-01,  3.655379e-01,  4.728737e-01,  9.750258e-01,  5.641342e-01},
  { 9.496141e-01,  1.888308e-01,  2.501518e-01,  4.909719e-01,  9.772555e-01,  5.073293e-01},
  {-4.145658e-01,  5.509869e-01,  7.242572e-01,  2.371937e-01,  1.076126e+00,  5.548975e-01},
  {-5.712578e-01,  5.593977e-01,  6.006151e-01,  9.854461e-02,  1.061177e+00,  4.697220e-01},
  { 9.856715e-01,  6.164098e-02,  1.570097e-01,  5.099426e-01,  9.872168e-01,  4.003414e-01},
  {-7.367474e-01,  4.635705e-01,  4.922456e-01, -4.928563e-02,  9.669321e-01,  3.879598e-01},
  { 9.965901e-01, -8.065610e-02,  1.739854e-02,  5.281812e-01,  9.307410e-01,  2.230405e-01},
  {-9.690535e-01,  2.465990e-01,  1.114721e-02, -1.476670e-01,  9.842276e-01,  8.975621e-02},
  {-9.606078e-01,  2.278975e-01, -1.590454e-01, -1.470662e-01,  9.766853e-01,  6.257010e-02},
  { 9.853601e-01, -1.556005e-01, -6.966986e-02,  5.276839e-01,  9.630568e-01,  1.027358e-01},
  {-9.456436e-01,  2.112683e-01, -2.472325e-01, -1.430382e-01,  9.704424e-01,  3.456107e-02},
  {-8.403938e-01,  7.792079e-02, -5.363457e-01, -1.104202e-01,  8.671748e-01, -7.566825e-02},
  {-8.092794e-01,  8.745106e-02, -5.808780e-01, -9.434777e-02,  8.968475e-01, -9.593502e-02},
  {-8.365849e-01,  1.020332e-01, -5.382516e-01, -8.973061e-02,  9.221077e-01, -9.917004e-02},
  {-5.232676e-01,  2.928431e-01, -8.002711e-01,  6.723843e-02,  1.100023e+00, -2.253608e-01},
  {-7.467384e-01,  2.247800e-01, -6.259838e-01, -1.303866e-02,  1.055684e+00, -1.695855e-01},
  {-7.455956e-01,  2.328856e-01, -6.243808e-01, -2.010699e-02,  1.030557e+00, -1.709735e-01},
  { 9.619593e-01, -1.128545e-01, -2.487935e-01,  5.111759e-01,  1.056007e+00, -1.215400e-01},
  {-4.695368e-01,  2.843542e-01, -8.358696e-01,  1.214081e-01,  1.063875e+00, -2.698658e-01},
  {-9.365198e-02,  2.191277e-01, -9.711912e-01,  2.454707e-01,  1.060876e+00, -3.102656e-01},
  {-4.226483e-02,  1.191693e-01, -9.919740e-01,  2.754607e-01,  1.056232e+00, -3.145301e-01},
  { 1.287377e-01,  1.302189e-01, -9.830919e-01,  3.001715e-01,  1.056639e+00, -3.136046e-01},
  { 3.024132e-01,  4.257734e-01,  8.527973e-01,  4.031599e-01,  9.355986e-01,  6.637530e-01},
  { 8.419001e-01,  2.443197e-01,  4.811571e-01,  4.630406e-01,  9.318226e-01,  6.125615e-01},
  { 4.588959e-02,  4.787642e-01,  8.767434e-01,  3.447615e-01,  9.810467e-01,  6.545343e-01},
  {-3.659379e-01,  5.478506e-01,  7.522959e-01,  2.671735e-01,  1.056329e+00,  5.855553e-01},
  {-6.291792e-01,  5.208320e-01,  5.769467e-01,  3.840458e-02,  1.019217e+00,  4.504487e-01},
  {-6.560887e-01,  5.194028e-01,  5.475110e-01,  3.362176e-02,  1.018926e+00,  4.447081e-01},
  { 9.501075e-01,  1.907506e-01,  2.467995e-01,  4.937840e-01,  1.011407e+00,  4.707347e-01},
  {-4.912468e-01,  5.733532e-01,  6.557001e-01,  1.586900e-01,  1.103932e+00,  4.800061e-01},
  {-8.063572e-01,  4.859533e-01,  3.371015e-01, -6.816031e-02,  1.006302e+00,  3.073773e-01},
  {-7.811291e-01,  4.568851e-01,  4.255505e-01, -5.845743e-02,  9.664347e-01,  3.722471e-01},
  { 9.969706e-01,  3.700721e-02,  6.841125e-02,  5.267426e-01,  9.984515e-01,  2.274958e-01},
  {-8.514273e-01,  3.762095e-01,  3.654287e-01, -1.061249e-01,  1.023344e+00,  2.172190e-01},
  {-9.557290e-01,  2.850459e-01,  7.301290e-02, -1.427997e-01,  1.002128e+00,  9.968603e-02},
  {-9.364998e-01,  3.123398e-01,  1.594115e-01, -1.381014e-01,  1.005092e+00,  1.273463e-01},
  { 9.877471e-01, -1.394985e-01, -6.997056e-02,  5.296352e-01,  9.831850e-01,  8.535666e-02},
  {-8.762482e-01,  1.297520e-01, -4.640618e-01, -1.178157e-01,  9.154546e-01, -5.189138e-02},
  {-9.268337e-01,  2.080729e-01, -3.125458e-01, -1.363708e-01,  9.772838e-01,  1.565338e-02},
  { 9.846000e-01, -1.528923e-01, -8.477476e-02,  5.266458e-01,  1.007340e+00,  1.479795e-02},
  { 9.880360e-01, -9.935474e-02, -1.179556e-01,  5.264933e-01,  1.037003e+00, -1.950357e-02},
  {-8.606571e-01,  1.527544e-01, -4.857319e-01, -9.295591e-02,  9.668719e-01, -8.341061e-02},
  {-4.510864e-01,  3.431379e-01, -8.238795e-01,  1.048504e-01,  1.123728e+00, -2.395127e-01},
  {-5.358222e-01,  3.616866e-01, -7.629399e-01,  6.235951e-02,  1.105948e+00, -2.199228e-01},
  {-8.224792e-01,  1.804911e-01, -5.393986e-01, -6.400713e-02,  1.033444e+00, -1.071774e-01},
  {-6.707258e-01,  2.294238e-01, -7.053308e-01,  1.406027e-02,  1.090934e+00, -1.859558e-01},
  {-2.633748e-01,  3.222118e-01, -9.092927e-01,  1.849472e-01,  1.071035e+00, -2.955890e-01},
  {-1.786319e-01,  2.828540e-01, -9.423823e-01,  2.187515e-01,  1.079822e+00, -3.005204e-01},
  { 9.455077e-01, -7.929847e-02, -3.157957e-01,  5.050523e-01,  1.090147e+00, -1.536020e-01},
  { 9.325669e-01, -4.963781e-02, -3.575680e-01,  4.979432e-01,  1.100461e+00, -1.764049e-01},
  { 2.991013e-01,  1.142111e-01, -9.473617e-01,  3.824532e-01,  1.072756e+00, -2.906914e-01},
  { 2.358625e-01,  1.167348e-01, -9.647496e-01,  3.323891e-01,  1.054042e+00, -3.073038e-01},
  {-6.286690e-02,  2.254404e-01, -9.722265e-01,  2.809057e-01,  1.064269e+00, -3.134887e-01},
  { 9.200187e-01, -5.526829e-02, -3.879574e-01,  4.769326e-01,  1.092559e+00, -2.276640e-01},
  { 8.180042e-01,  5.199494e-02, -5.728575e-01,  4.655522e-01,  1.097437e+00, -2.482180e-01},
  { 4.946229e-01,  1.339527e-02, -8.690045e-01,  4.410295e-01,  1.081412e+00, -2.674834e-01},
  { 4.395005e-01,  4.129522e-01,  7.976903e-01,  4.204656e-01,  9.347386e-01,  6.554692e-01},
  { 7.248539e-01,  3.258490e-01,  6.069674e-01,  4.509371e-01,  9.362817e-01,  6.280258e-01},
  { 8.196114e-01,  2.912697e-01,  4.933550e-01,  4.611748e-01,  9.416814e-01,  6.102813e-01},
  { 3.361376e-01,  4.635471e-01,  8.198387e-01,  4.051962e-01,  9.571394e-01,  6.503959e-01},
  {-1.605771e-01,  4.895384e-01,  8.570690e-01,  3.254403e-01,  9.951429e-01,  6.458143e-01},
  {-5.693024e-02,  4.800462e-01,  8.753940e-01,  3.238164e-01,  1.007338e+00,  6.386335e-01},
  { 1.530986e-01,  4.833637e-01,  8.619283e-01,  3.582040e-01,  9.877740e-01,  6.490139e-01},
  { 1.453376e-01,  4.910583e-01,  8.589172e-01,  3.561207e-01,  9.964973e-01,  6.445997e-01},
  { 8.809416e-01,  3.525386e-01,  3.156874e-01,  4.757726e-01,  1.009024e+00,  5.302663e-01},
  { 8.051645e-01,  4.926534e-01,  3.301557e-01,  4.716950e-01,  1.007826e+00,  5.440351e-01},
  {-3.689578e-01,  5.889995e-01,  7.189922e-01,  2.569047e-01,  1.097006e+00,  5.488682e-01},
  { 9.018449e-01,  2.798620e-01,  3.291703e-01,  4.856554e-01,  1.035738e+00,  4.795380e-01},
  { 9.706625e-01,  1.044096e-01,  2.165938e-01,  5.032004e-01,  1.022444e+00,  4.191186e-01},
  {-3.807758e-01,  6.208726e-01,  6.852204e-01,  2.327942e-01,  1.116537e+00,  5.192829e-01},
  {-6.370274e-01,  5.409632e-01,  5.491403e-01,  2.274994e-02,  1.047948e+00,  4.034182e-01},
  { 9.980245e-01, -6.280646e-02,  1.562171e-03,  5.288106e-01,  9.361257e-01,  1.983601e-01},
  { 9.958030e-01,  3.737642e-02,  8.354302e-02,  5.267304e-01,  1.025278e+00,  2.122002e-01},
  {-8.994323e-01,  3.622004e-01,  2.446066e-01, -1.235349e-01,  1.021529e+00,  1.683578e-01},
  { 9.959018e-01, -6.803268e-02, -5.959164e-02,  5.324737e-01,  1.027978e+00,  5.546428e-02},
  { 9.972233e-01, -4.139372e-02, -6.190395e-02,  5.329028e-01,  1.058836e+00,  3.506132e-02},
  {-8.968979e-01,  1.763909e-01, -4.055372e-01, -1.250011e-01,  9.575860e-01, -2.284326e-02},
  {-8.755076e-01,  1.870265e-01, -4.455419e-01, -9.679586e-02,  1.007696e+00, -5.972263e-02},
  { 9.721761e-01, -7.888072e-02, -2.205707e-01,  5.188748e-01,  1.100573e+00, -1.075707e-01},
  {-1.741776e-01,  2.974559e-01, -9.387130e-01,  2.438822e-01,  1.103458e+00, -2.980069e-01},
  {-3.460224e-01,  3.262098e-01, -8.796908e-01,  1.553691e-01,  1.085472e+00, -2.797961e-01},
  { 9.064392e-01,  3.880972e-02, -4.205491e-01,  4.756304e-01,  1.105577e+00, -2.309573e-01},
  { 3.974933e-01,  5.472553e-02, -9.159718e-01,  4.258170e-01,  1.090852e+00, -2.741446e-01},
  { 5.719108e-01,  8.479747e-02, -8.159212e-01,  4.572473e-01,  1.096160e+00, -2.574962e-01},
  { 6.121750e-01,  3.653214e-01,  7.012716e-01,  4.344524e-01,  9.307218e-01,  6.481832e-01},
  { 3.773412e-01,  4.761672e-01,  7.942786e-01,  3.994390e-01,  9.889944e-01,  6.349349e-01},
  {-1.364699e-01,  4.768372e-01,  8.683330e-01,  3.243047e-01,  1.015949e+00,  6.341042e-01},
  { 1.764338e-01,  4.703945e-01,  8.646388e-01,  3.610895e-01,  1.007207e+00,  6.373061e-01},
  { 2.150348e-01,  5.104542e-01,  8.325843e-01,  3.662231e-01,  1.021819e+00,  6.274337e-01},
  { 6.572082e-02,  4.771625e-01,  8.763543e-01,  3.499942e-01,  1.015463e+00,  6.346018e-01},
  { 8.339931e-01,  2.956226e-01,  4.659000e-01,  4.618614e-01,  9.714847e-01,  5.907899e-01},
  { 8.018630e-01,  4.336229e-01,  4.110801e-01,  4.651485e-01,  1.007961e+00,  5.575129e-01},
  {-5.375963e-01,  5.712600e-01,  6.202034e-01,  1.089990e-01,  1.124883e+00,  4.218537e-01},
  { 9.520870e-01,  1.831049e-01,  2.449549e-01,  4.932913e-01,  1.041738e+00,  4.477291e-01},
  { 9.844174e-01,  9.550456e-02,  1.476517e-01,  5.115843e-01,  1.031589e+00,  3.606986e-01},
  {-6.878395e-01,  5.110381e-01,  5.154772e-01, -8.162004e-03,  1.028300e+00,  3.853827e-01},
  {-7.258816e-01,  6.422341e-01,  2.462342e-01, -4.095118e-02,  1.031422e+00,  3.335293e-01},
  {-7.940571e-01,  4.282034e-01,  4.314107e-01, -8.087553e-02,  1.046221e+00,  2.469661e-01},
  {-8.439986e-01,  4.026439e-01,  3.543223e-01, -1.005288e-01,  1.044875e+00,  2.074532e-01},
  {-9.569517e-01,  2.761102e-01, -8.947934e-02, -1.402576e-01,  1.008158e+00,  6.576551e-02},
  {-9.241403e-01,  3.817547e-01, -1.510120e-02, -1.265957e-01,  1.049202e+00,  7.324548e-02},
  {-9.330015e-01,  3.299837e-01, -1.435937e-01, -1.267103e-01,  1.044907e+00,  5.225102e-02},
  {-9.195517e-01,  3.822930e-01, -9.097636e-02, -1.163516e-01,  1.068960e+00,  4.704495e-02},
  {-9.118974e-01,  2.076968e-01, -3.539848e-01, -1.192300e-01,  1.005699e+00, -1.303018e-02},
  {-4.149110e-01,  4.371670e-01, -7.979560e-01,  1.180223e-01,  1.146915e+00, -2.353057e-01},
  {-8.839991e-01,  2.160162e-01, -4.145873e-01, -1.009332e-01,  1.039479e+00, -3.622891e-02},
  { 9.844956e-01, -1.007233e-01, -1.436078e-01,  5.261773e-01,  1.086710e+00, -5.856219e-02},
  {-3.013076e-01,  4.585121e-01, -8.360505e-01,  1.524195e-01,  1.149929e+00, -2.497135e-01},
  {-1.658951e-01,  3.541377e-01, -9.203615e-01,  2.560863e-01,  1.132094e+00, -2.903676e-01},
  {-2.240149e-01,  3.934693e-01, -8.916273e-01,  2.014926e-01,  1.110911e+00, -2.850897e-01},
  { 9.546055e-01, -3.841937e-02, -2.953846e-01,  5.121315e-01,  1.120390e+00, -1.370829e-01},
  {-1.665358e-01,  3.169816e-01, -9.336962e-01,  2.553416e-01,  1.118033e+00, -2.953443e-01},
  {-3.812488e-01,  3.559353e-01, -8.532054e-01,  1.576348e-01,  1.103700e+00, -2.736824e-01},
  {-7.578393e-01,  1.912889e-01, -6.237693e-01, -2.552670e-02,  1.100160e+00, -1.404125e-01},
  {-7.672239e-01,  1.900883e-01, -6.125633e-01, -2.499294e-02,  1.111520e+00, -1.378266e-01},
  {-2.374112e-02,  2.784826e-01, -9.601478e-01,  2.858297e-01,  1.094891e+00, -3.064707e-01},
  { 8.798015e-01,  7.169145e-02, -4.699039e-01,  4.813158e-01,  1.121935e+00, -2.179611e-01},
  { 9.475813e-02,  2.458103e-01, -9.646752e-01,  2.976306e-01,  1.084645e+00, -3.083180e-01},
  { 6.079157e-01,  1.637315e-01, -7.769367e-01,  4.539895e-01,  1.109006e+00, -2.576400e-01},
  { 5.326008e-01,  4.223925e-01,  7.334310e-01,  4.276287e-01,  9.482581e-01,  6.433903e-01},
  { 4.765513e-01,  4.931103e-01,  7.278332e-01,  4.170014e-01,  9.726347e-01,  6.358477e-01},
  { 2.005397e-01,  5.074030e-01,  8.380490e-01,  3.686982e-01,  1.037141e+00,  6.174285e-01},
  { 4.933008e-01,  4.469690e-01,  7.462392e-01,  4.250940e-01,  1.004649e+00,  6.123358e-01},
  { 4.780936e-01,  4.225595e-01,  7.699805e-01,  4.217566e-01,  9.949727e-01,  6.201227e-01},
  { 5.140015e-01,  4.558146e-01,  7.266605e-01,  4.231420e-01,  1.015098e+00,  6.072192e-01},
  { 3.569456e-01,  4.871380e-01,  7.970487e-01,  3.965715e-01,  1.031771e+00,  6.107651e-01},
  {-2.229675e-01,  5.954052e-01,  7.718666e-01,  3.017158e-01,  1.067023e+00,  5.926116e-01},
  { 6.945046e-01,  4.049459e-01,  5.947118e-01,  4.413539e-01,  1.019422e+00,  5.890199e-01},
  { 4.905479e-01,  4.709597e-01,  7.331847e-01,  4.203319e-01,  1.035654e+00,  5.960165e-01},
  {-2.922135e-01,  6.145691e-01,  7.327455e-01,  2.879439e-01,  1.095401e+00,  5.640604e-01},
  {-8.507272e-01,  4.158551e-01,  3.214463e-01, -9.542875e-02,  1.066007e+00,  1.948287e-01},
  {-9.056917e-01,  3.782712e-01,  1.913987e-01, -1.179430e-01,  1.051086e+00,  1.414939e-01},
  { 9.989724e-01, -4.166378e-02,  1.783897e-02,  5.329612e-01,  1.004145e+00,  1.120459e-01},
  {-9.424010e-01,  3.333368e-01,  2.769445e-02, -1.364172e-01,  1.023674e+00,  8.947036e-02},
  {-8.947002e-01,  4.379495e-01,  8.781742e-02, -1.125282e-01,  1.076888e+00,  9.821446e-02},
  {-9.384717e-01,  2.530931e-01, -2.349782e-01, -1.296089e-01,  1.021942e+00,  3.060985e-02},
  {-9.057563e-01,  4.215070e-01, -4.401527e-02, -1.106857e-01,  1.082358e+00,  4.827081e-02},
  {-9.273252e-01,  2.888263e-01, -2.380068e-01, -1.218847e-01,  1.038925e+00,  2.076488e-02},
  { 9.958740e-01, -4.412106e-02, -7.929920e-02,  5.304149e-01,  1.099269e+00, -1.525598e-02},
  {-5.127484e-01,  4.111138e-01, -7.537072e-01,  9.318382e-02,  1.145425e+00, -2.220467e-01},
  {-5.781531e-01,  3.210865e-01, -7.500950e-01,  4.367403e-02,  1.130116e+00, -1.961096e-01},
  {-8.689668e-01,  2.961557e-01, -3.964702e-01, -7.225934e-02,  1.106161e+00, -5.742375e-02},
  {-8.701938e-01,  2.410311e-01, -4.297287e-01, -8.561468e-02,  1.065969e+00, -5.423617e-02},
  { 9.926363e-01, -2.588600e-02, -1.183345e-01,  5.260837e-01,  1.111039e+00, -7.124234e-02},
  { 9.739714e-01, -1.117246e-02, -2.263953e-01,  5.217484e-01,  1.135513e+00, -1.040562e-01},
  {-2.486614e-01,  3.950787e-01, -8.843531e-01,  2.192459e-01,  1.141629e+00, -2.769302e-01},
  { 9.495680e-01,  4.074587e-02, -3.109022e-01,  5.130420e-01,  1.142565e+00, -1.352786e-01},
  {-8.440625e-01,  2.010840e-01, -4.971155e-01, -4.112621e-02,  1.107029e+00, -1.163652e-01},
  { 9.290190e-01,  2.348193e-02, -3.692862e-01,  4.979645e-01,  1.140360e+00, -1.778224e-01},
  {-1.173587e-02,  3.243871e-01, -9.458516e-01,  2.859085e-01,  1.118208e+00, -2.985007e-01},
  { 2.210397e-01,  1.873295e-01, -9.571046e-01,  3.447726e-01,  1.097637e+00, -2.975471e-01},
  { 3.925074e-01,  1.477624e-01, -9.078018e-01,  4.285808e-01,  1.111557e+00, -2.707894e-01},
  { 7.288159e-01,  1.651230e-01, -6.645011e-01,  4.617510e-01,  1.122278e+00, -2.468697e-01},
  { 1.218567e-02,  5.698950e-01,  8.216273e-01,  3.405338e-01,  1.045394e+00,  6.175102e-01},
  { 6.407552e-01,  4.027166e-01,  6.536453e-01,  4.449215e-01,  9.621315e-01,  6.210137e-01},
  {-5.978864e-02,  5.647074e-01,  8.231226e-01,  3.327760e-01,  1.034035e+00,  6.244391e-01},
  { 6.553870e-01,  3.875246e-01,  6.482997e-01,  4.421993e-01,  9.858608e-01,  6.094730e-01},
  {-2.557032e-01,  5.349806e-01,  8.052402e-01,  3.187054e-01,  1.030320e+00,  6.246369e-01},
  { 2.394439e-01,  5.340791e-01,  8.108182e-01,  3.722373e-01,  1.048018e+00,  6.093540e-01},
  { 8.023968e-01,  3.373612e-01,  4.922874e-01,  4.533741e-01,  9.900588e-01,  5.926929e-01},
  { 3.889629e-01,  5.052835e-01,  7.703223e-01,  4.087393e-01,  1.051579e+00,  5.925679e-01},
  { 8.036769e-01,  3.683899e-01,  4.673246e-01,  4.538307e-01,  1.027077e+00,  5.645140e-01},
  { 6.199797e-01,  4.400633e-01,  6.495917e-01,  4.296406e-01,  1.056163e+00,  5.752397e-01},
  {-3.689391e-01,  5.831661e-01,  7.237412e-01,  1.038666e-01,  1.142443e+00,  4.015234e-01},
  {-2.883664e-01,  6.509249e-01,  7.022404e-01,  2.680788e-01,  1.123800e+00,  5.312186e-01},
  {-6.883401e-01,  5.787184e-01,  4.373474e-01,  7.099920e-02,  1.113412e+00,  3.924283e-01},
  { 9.564701e-01,  1.805204e-01,  2.292978e-01,  4.996526e-01,  1.073340e+00,  3.970513e-01},
  { 9.758591e-01,  1.321298e-01,  1.738986e-01,  5.074680e-01,  1.062721e+00,  3.667526e-01},
  { 9.928339e-01,  6.254746e-02,  1.018267e-01,  5.279670e-01,  1.084294e+00,  1.786210e-01},
  {-8.725739e-01,  4.351282e-01,  2.219872e-01, -1.015349e-01,  1.076674e+00,  1.593869e-01},
  {-8.824158e-01,  4.437398e-01,  1.563242e-01, -1.116820e-01,  1.068787e+00,  1.334932e-01},
  {-9.203995e-01,  3.722480e-01,  1.195666e-01, -1.280217e-01,  1.042440e+00,  9.897845e-02},
  { 9.998325e-01,  1.404713e-02,  1.173168e-02,  5.344290e-01,  1.081067e+00,  8.899716e-02},
  {-8.888144e-01,  4.581377e-01, -1.090796e-02, -1.013258e-01,  1.102088e+00,  6.173122e-02},
  {-9.180789e-01,  3.623993e-01, -1.606172e-01, -1.051785e-01,  1.086435e+00,  1.636039e-02},
  {-9.176072e-01,  2.534214e-01, -3.062263e-01, -1.129193e-01,  1.046683e+00, -2.185527e-03},
  {-3.715281e-01,  4.954314e-01, -7.851845e-01,  1.371619e-01,  1.172890e+00, -2.295341e-01},
  {-8.568087e-01,  4.252622e-01, -2.916005e-01, -5.250505e-02,  1.155318e+00, -5.451784e-02},
  {-6.062832e-01,  3.285175e-01, -7.242216e-01,  2.009990e-02,  1.135347e+00, -1.750646e-01},
  {-1.136396e-01,  3.752582e-01, -9.199279e-01,  2.651464e-01,  1.145680e+00, -2.864300e-01},
  {-8.771703e-01,  2.912345e-01, -3.817784e-01, -4.899945e-02,  1.133941e+00, -8.776055e-02},
  {-2.335066e-01,  4.394802e-01, -8.673706e-01,  1.881610e-01,  1.118177e+00, -2.784331e-01},
  {-6.601009e-01,  2.906981e-01, -6.926482e-01, -3.574354e-03,  1.135101e+00, -1.543059e-01},
  { 1.314716e-01,  2.370126e-01, -9.625697e-01,  3.176868e-01,  1.108531e+00, -2.996722e-01},
  { 6.371893e-01,  4.227437e-01,  6.444203e-01,  4.320832e-01,  1.063275e+00,  5.681593e-01},
  { 8.065561e-01,  3.495076e-01,  4.767722e-01,  4.442683e-01,  1.065628e+00,  5.510346e-01},
  { 8.910087e-01,  3.124332e-01,  3.293768e-01,  4.758807e-01,  1.102945e+00,  4.448673e-01},
  { 9.452943e-01,  2.183377e-01,  2.423785e-01,  5.012928e-01,  1.076731e+00,  3.876293e-01},
  {-2.921558e-01,  6.990436e-01,  6.526737e-01,  2.549801e-01,  1.152397e+00,  4.970599e-01},
  {-4.138010e-01,  6.375705e-01,  6.498250e-01,  1.808326e-01,  1.153604e+00,  4.509020e-01},
  {-7.165542e-01,  5.152747e-01,  4.701513e-01, -1.668657e-02,  1.088485e+00,  3.098100e-01},
  {-7.446066e-01,  4.873624e-01,  4.561128e-01, -2.487403e-02,  1.052207e+00,  3.366472e-01},
  { 9.877027e-01,  9.907786e-02,  1.209416e-01,  5.162433e-01,  1.087972e+00,  2.772413e-01},
  {-7.660608e-01,  4.489293e-01,  4.600144e-01, -6.729082e-02,  1.077463e+00,  2.404901e-01},
  {-8.693342e-01,  4.356551e-01,  2.333729e-01, -8.964158e-02,  1.105594e+00,  1.515842e-01},
  { 9.989834e-01, -4.170991e-02,  1.710301e-02,  5.340301e-01,  1.016412e+00,  1.014799e-01},
  {-8.925374e-01,  4.508902e-01, -8.665023e-03, -9.363633e-02,  1.116867e+00,  6.177480e-02},
  { 9.994449e-01,  3.323483e-02, -2.293530e-03,  5.328842e-01,  1.118958e+00,  3.700316e-02},
  {-8.382065e-01,  5.320669e-01, -1.196435e-01, -5.446474e-02,  1.178224e+00,  7.974470e-03},
  {-8.545744e-01,  4.896433e-01, -1.730667e-01, -7.470131e-02,  1.143456e+00,  6.068589e-04},
  { 9.986240e-01,  2.907571e-02, -4.364401e-02,  5.318009e-01,  1.129876e+00, -1.919628e-03},
  {-8.744097e-01,  4.166509e-01, -2.486156e-01, -8.463825e-02,  1.118477e+00, -1.327168e-02},
  {-9.090368e-01,  2.509584e-01, -3.326742e-01, -1.005430e-01,  1.071586e+00, -1.836820e-02},
  {-8.713441e-01,  3.390754e-01, -3.546652e-01, -8.625950e-02,  1.105121e+00, -2.560510e-02},
  {-4.529465e-01,  5.007819e-01, -7.376022e-01,  1.058902e-01,  1.180115e+00, -2.079453e-01},
  {-4.560828e-01,  4.690271e-01, -7.563081e-01,  8.847648e-02,  1.177521e+00, -1.991772e-01},
  {-5.006159e-01,  4.409150e-01, -7.449682e-01,  6.063630e-02,  1.157017e+00, -1.936873e-01},
  { 9.567586e-01,  8.951743e-02, -2.767665e-01,  5.170491e-01,  1.167783e+00, -1.172038e-01},
  {-8.378628e-01,  4.150504e-01, -3.545689e-01, -4.066566e-02,  1.156027e+00, -8.592345e-02},
  {-8.462360e-01,  2.220050e-01, -4.843537e-01, -4.125137e-02,  1.128224e+00, -1.078142e-01},
  { 8.904038e-01,  1.778906e-01, -4.189703e-01,  4.942890e-01,  1.169912e+00, -1.815725e-01},
  {-7.736985e-01,  2.621653e-01, -5.767668e-01, -2.207243e-02,  1.140022e+00, -1.326960e-01},
  { 3.090159e-01,  2.181990e-01, -9.256880e-01,  4.043707e-01,  1.145951e+00, -2.714189e-01},
  { 2.312562e-01,  2.273272e-01, -9.459614e-01,  3.802751e-01,  1.142120e+00, -2.787711e-01},
  { 4.713302e-02,  3.127426e-01, -9.486678e-01,  3.061281e-01,  1.125242e+00, -2.957957e-01},
  { 7.824486e-01,  1.714789e-01, -5.986394e-01,  4.685631e-01,  1.147982e+00, -2.331215e-01},
  { 5.000206e-01,  2.181543e-01, -8.380860e-01,  4.460357e-01,  1.133355e+00, -2.573776e-01},
  {-4.084711e-02,  6.101985e-01,  7.911948e-01,  3.460220e-01,  1.056139e+00,  6.096827e-01},
  { 4.362893e-01,  4.951079e-01,  7.513452e-01,  4.096571e-01,  1.071878e+00,  5.789526e-01},
  {-1.717941e-01,  6.760685e-01,  7.165320e-01,  3.131643e-01,  1.104416e+00,  5.642555e-01},
  { 8.380848e-01,  3.438020e-01,  4.235730e-01,  4.526523e-01,  1.081908e+00,  5.223795e-01},
  { 8.769822e-01,  3.458819e-01,  3.335687e-01,  4.677165e-01,  1.094111e+00,  4.753410e-01},
  {-2.531670e-01,  7.074801e-01,  6.598320e-01,  2.708675e-01,  1.147140e+00,  5.096017e-01},
  {-6.761794e-01,  5.403059e-01,  5.008503e-01,  2.329392e-03,  1.071982e+00,  3.555388e-01},
  { 8.657717e-01,  2.482633e-01,  4.345166e-01,  4.869973e-01,  1.126195e+00,  3.915167e-01},
  {-7.036415e-01,  6.137546e-01,  3.580419e-01, -1.846786e-02,  1.049137e+00,  3.504715e-01},
  {-4.160246e-01,  6.472219e-01,  6.387702e-01,  2.027615e-01,  1.158831e+00,  4.617700e-01},
  {-7.947551e-01,  4.471849e-01,  4.103537e-01, -7.814615e-02,  1.091573e+00,  2.057636e-01},
  {-8.666837e-01,  4.495149e-01,  2.163229e-01, -8.161644e-02,  1.125627e+00,  1.430727e-01},
  {-8.796111e-01,  4.568411e-01,  1.325913e-01, -7.901840e-02,  1.136874e+00,  1.291782e-01},
  {-7.570031e-01,  6.500126e-01, -6.655906e-02, -2.375840e-02,  1.229215e+00,  4.764196e-02},
  {-7.433732e-01,  6.632943e-01, -8.623833e-02, -1.638190e-02,  1.236978e+00,  4.164042e-02},
  {-7.848411e-01,  6.192367e-01, -2.388307e-02, -3.029759e-02,  1.222013e+00,  5.361529e-02},
  {-8.247155e-01,  5.610738e-01, -7.099750e-02, -4.151325e-02,  1.205830e+00,  4.639684e-02},
  {-8.456066e-01,  5.269538e-01, -8.525971e-02, -5.054159e-02,  1.190997e+00,  4.211539e-02},
  {-7.922958e-01,  5.954093e-01, -1.332487e-01, -3.139205e-02,  1.211798e+00,  7.414177e-03},
  {-8.806366e-01,  4.650580e-01, -9.055593e-02, -9.134937e-02,  1.118005e+00,  2.369324e-02},
  {-8.082798e-01,  5.521441e-01, -2.045015e-01, -3.111512e-02,  1.200721e+00, -3.406613e-02},
  {-3.524623e-01,  5.342572e-01, -7.683356e-01,  1.823261e-01,  1.190268e+00, -2.375323e-01},
  {-8.158395e-01,  4.972064e-01, -2.952824e-01, -3.728745e-02,  1.176021e+00, -6.656707e-02},
  {-1.789891e-01,  4.391810e-01, -8.803880e-01,  2.637048e-01,  1.175270e+00, -2.731961e-01},
  {-5.572879e-01,  4.195625e-01, -7.165176e-01,  3.030578e-02,  1.163302e+00, -1.681217e-01},
  {-5.948173e-01,  3.383213e-01, -7.291988e-01,  1.020560e-02,  1.160219e+00, -1.539856e-01},
  {-6.437156e-01,  2.781366e-01, -7.129308e-01, -3.331555e-03,  1.157086e+00, -1.438646e-01},
  {-8.222414e-01,  3.556587e-01, -4.443265e-01, -3.719611e-02,  1.143220e+00, -1.062788e-01},
  {-7.193474e-01,  3.414333e-01, -6.049483e-01, -1.677354e-02,  1.151014e+00, -1.332728e-01},
  { 8.126830e-01,  1.849506e-01, -5.525754e-01,  4.791096e-01,  1.168423e+00, -2.107974e-01},
  { 2.652076e-01,  2.959437e-01, -9.176504e-01,  3.948718e-01,  1.153509e+00, -2.722639e-01},
  {-2.003114e-02,  3.572468e-01, -9.337952e-01,  3.041961e-01,  1.149810e+00, -2.875185e-01},
  { 1.864840e-01,  2.557086e-01, -9.485973e-01,  3.546602e-01,  1.134425e+00, -2.866654e-01},
  { 3.987335e-01,  2.874645e-01, -8.708477e-01,  4.314106e-01,  1.153631e+00, -2.589351e-01},
  { 5.592111e-01,  2.583054e-01, -7.877572e-01,  4.523902e-01,  1.149637e+00, -2.479511e-01},
  {-1.084741e-01,  6.315632e-01,  7.676986e-01,  3.356850e-01,  1.075231e+00,  5.943561e-01},
  { 2.089427e-01,  5.903856e-01,  7.796075e-01,  3.760508e-01,  1.077322e+00,  5.883696e-01},
  { 3.259550e-01,  5.507089e-01,  7.684225e-01,  4.054138e-01,  1.083998e+00,  5.729094e-01},
  { 5.213447e-01,  4.823194e-01,  7.039658e-01,  4.237184e-01,  1.084554e+00,  5.614752e-01},
  { 7.262046e-01,  4.096371e-01,  5.521089e-01,  4.353486e-01,  1.092558e+00,  5.438784e-01},
  {-4.539692e-01,  6.427903e-01,  6.170353e-01,  1.132900e-01,  1.163017e+00,  3.899591e-01},
  {-7.841616e-01,  6.096001e-01,  1.160960e-01,  1.035083e-01,  1.162579e+00,  3.762750e-01},
  { 8.478510e-01,  3.588204e-01,  3.903801e-01,  4.495803e-01,  1.099100e+00,  5.137646e-01},
  { 8.465787e-01,  3.706110e-01,  3.820368e-01,  4.718747e-01,  1.124390e+00,  4.349653e-01},
  {-2.245388e-01,  7.088752e-01,  6.686391e-01,  2.910594e-01,  1.176407e+00,  4.869803e-01},
  {-6.025295e-01,  6.419216e-01,  4.742309e-01,  6.141516e-02,  1.167788e+00,  3.127922e-01},
  {-6.369252e-01,  5.837940e-01,  5.034986e-01,  1.335868e-02,  1.098601e+00,  3.398335e-01},
  {-6.820966e-01,  5.230415e-01,  5.110496e-01, -2.752999e-02,  1.120574e+00,  2.565803e-01},
  {-7.934753e-01,  4.537063e-01,  4.056447e-01, -7.068424e-02,  1.109922e+00,  1.996423e-01},
  {-8.276989e-01,  4.547214e-01,  3.288512e-01, -7.326377e-02,  1.117292e+00,  1.844668e-01},
  {-8.991601e-01,  3.803877e-01, -2.163707e-01, -9.623683e-02,  1.098161e+00, -5.693432e-03},
  {-8.973294e-01,  3.034710e-01, -3.204768e-01, -9.689555e-02,  1.086023e+00, -1.733552e-02},
  { 9.930674e-01,  7.378688e-02, -9.150244e-02,  5.266324e-01,  1.167248e+00, -5.833784e-02},
  {-7.463309e-01,  6.084146e-01, -2.698554e-01, -2.849973e-02,  1.199600e+00, -4.532856e-02},
  {-2.303910e-01,  5.051910e-01, -8.316863e-01,  2.437929e-01,  1.193291e+00, -2.578389e-01},
  { 9.798720e-01,  8.393577e-02, -1.811235e-01,  5.231537e-01,  1.164887e+00, -9.448423e-02},
  {-6.110511e-01,  4.850580e-01, -6.255679e-01,  6.847654e-03,  1.170182e+00, -1.443182e-01},
  { 9.169943e-01,  1.426933e-01, -3.725053e-01,  5.002449e-01,  1.193870e+00, -1.589546e-01},
  { 7.991152e-01,  2.517209e-01, -5.459409e-01,  4.767946e-01,  1.179846e+00, -2.102500e-01},
  { 9.068998e-02,  3.327226e-01, -9.386538e-01,  3.289539e-01,  1.155749e+00, -2.836940e-01},
  { 6.765419e-01,  2.500787e-01, -6.926411e-01,  4.587664e-01,  1.155221e+00, -2.411614e-01},
  {-1.507712e-01,  6.913838e-01,  7.065809e-01,  3.174648e-01,  1.129239e+00,  5.414582e-01},
  {-1.325549e-01,  7.220848e-01,  6.789865e-01,  3.180818e-01,  1.144697e+00,  5.259079e-01},
  {-7.669302e-02,  7.338912e-01,  6.749235e-01,  3.147385e-01,  1.171834e+00,  4.970145e-01},
  {-6.925814e-01,  6.594523e-01,  2.923247e-01,  1.140859e-01,  1.176148e+00,  3.696766e-01},
  { 7.250087e-01,  1.945426e-01,  6.606932e-01,  4.740420e-01,  1.152334e+00,  3.999050e-01},
  { 8.700471e-01,  3.594318e-01,  3.373824e-01,  4.781331e-01,  1.159804e+00,  3.831079e-01},
  {-2.259282e-01,  7.330319e-01,  6.415767e-01,  2.752197e-01,  1.206050e+00,  4.486316e-01},
  {-4.026475e-01,  6.544723e-01,  6.399539e-01,  1.867359e-01,  1.176579e+00,  4.327642e-01},
  {-3.590938e-01,  6.967112e-01,  6.210032e-01,  2.301471e-01,  1.181952e+00,  4.529323e-01},
  { 9.486057e-01,  2.294858e-01,  2.179074e-01,  4.977550e-01,  1.134032e+00,  3.463309e-01},
  {-6.155639e-01,  4.901305e-01,  6.171330e-01, -2.222017e-02,  1.123703e+00,  2.604336e-01},
  { 9.619387e-01,  1.997356e-01,  1.864934e-01,  5.079173e-01,  1.151099e+00,  2.761030e-01},
  { 9.933151e-01,  7.220336e-02,  9.006506e-02,  5.260194e-01,  1.139766e+00,  1.621578e-01},
  {-7.249268e-01,  6.882228e-01,  2.881776e-02, -9.128428e-03,  1.245528e+00,  7.078863e-02},
  {-6.896363e-01,  7.241469e-01,  3.618635e-03,  8.116603e-03,  1.263587e+00,  5.249559e-02},
  {-8.591955e-01,  5.113809e-01,  1.651284e-02, -6.311044e-02,  1.174644e+00,  9.644794e-02},
  {-7.739651e-01,  6.332123e-01, -4.492224e-03,  7.242222e-03,  1.260638e+00,  3.076523e-02},
  {-7.278609e-01,  6.785311e-01, -9.906574e-02,  4.993653e-03,  1.258674e+00,  2.307251e-02},
  {-7.097708e-01,  6.841357e-01, -1.678803e-01, -1.367806e-03,  1.248007e+00,  9.502188e-03},
  {-7.238004e-01,  6.572224e-01, -2.101708e-01, -8.234190e-03,  1.236153e+00, -8.446318e-03},
  {-3.416376e-01,  5.478389e-01, -7.636466e-01,  1.681149e-01,  1.210811e+00, -2.183447e-01},
  {-4.277728e-01,  5.668027e-01, -7.040916e-01,  1.015912e-01,  1.211091e+00, -1.824419e-01},
  { 9.717274e-01,  1.477834e-01, -1.841361e-01,  5.191442e-01,  1.193351e+00, -9.331167e-02},
  {-4.799295e-01,  5.543155e-01, -6.800015e-01,  7.425462e-02,  1.202142e+00, -1.730258e-01},
  {-5.231241e-01,  5.337952e-01, -6.643823e-01,  4.541397e-02,  1.192763e+00, -1.582789e-01},
  {-7.447359e-01,  5.621028e-01, -3.597346e-01, -2.479848e-02,  1.187284e+00, -7.907544e-02},
  { 9.397478e-01,  1.718144e-01, -2.955569e-01,  5.040014e-01,  1.208535e+00, -1.412196e-01},
  {-7.690639e-01,  4.862472e-01, -4.148546e-01, -2.241948e-02,  1.174049e+00, -1.024126e-01},
  {-6.326588e-02,  4.404971e-01, -8.955221e-01,  3.043943e-01,  1.181947e+00, -2.747066e-01},
  { 4.781479e-01,  3.231792e-01, -8.166577e-01,  4.395062e-01,  1.172967e+00, -2.476443e-01},
  { 1.620790e-01,  3.210095e-01, -9.331041e-01,  3.610682e-01,  1.173701e+00, -2.730818e-01},
  { 6.213260e-01,  2.986314e-01, -7.244124e-01,  4.566695e-01,  1.168895e+00, -2.374682e-01},
  { 4.782799e-02,  6.586526e-01,  7.509256e-01,  3.454701e-01,  1.085858e+00,  5.856028e-01},
  { 1.438988e-01,  6.236066e-01,  7.683800e-01,  3.800412e-01,  1.103693e+00,  5.658562e-01},
  { 2.729992e-01,  5.789258e-01,  7.683206e-01,  3.973985e-01,  1.103509e+00,  5.620207e-01},
  {-1.344603e-02,  6.861929e-01,  7.272953e-01,  3.369680e-01,  1.107248e+00,  5.657765e-01},
  { 4.547890e-01,  5.114356e-01,  7.291095e-01,  4.191837e-01,  1.105164e+00,  5.508721e-01},
  { 6.087657e-01,  4.963537e-01,  6.189001e-01,  4.275181e-01,  1.109822e+00,  5.405559e-01},
  { 7.301745e-01,  4.015516e-01,  5.528123e-01,  4.335628e-01,  1.114266e+00,  5.294904e-01},
  { 8.055332e-01,  4.488004e-01,  3.869036e-01,  4.431453e-01,  1.125234e+00,  5.008482e-01},
  {-8.389567e-02,  7.332998e-01,  6.747096e-01,  3.252310e-01,  1.187669e+00,  4.813474e-01},
  {-7.200238e-01,  6.276398e-01,  2.960303e-01,  1.347688e-01,  1.207083e+00,  3.498971e-01},
  {-8.780227e-02,  7.359447e-01,  6.713243e-01,  3.111733e-01,  1.205245e+00,  4.602560e-01},
  {-3.577061e-01,  6.951132e-01,  6.235896e-01,  2.016276e-01,  1.196683e+00,  4.181467e-01},
  {-5.228198e-01,  5.503002e-01,  6.510215e-01,  4.551213e-02,  1.188301e+00,  2.678911e-01},
  {-5.738566e-01,  5.274835e-01,  6.264581e-01,  2.331702e-02,  1.168970e+00,  2.658764e-01},
  { 9.035504e-01,  3.222371e-01,  2.824178e-01,  4.855849e-01,  1.173730e+00,  3.470975e-01},
  {-7.082483e-01,  5.063501e-01,  4.919287e-01, -3.369421e-02,  1.143251e+00,  2.242154e-01},
  { 9.739574e-01,  1.485608e-01,  1.712798e-01,  5.165712e-01,  1.154474e+00,  2.205514e-01},
  {-7.552816e-01,  4.896140e-01,  4.356925e-01, -5.466454e-02,  1.135408e+00,  2.008466e-01},
  {-8.140364e-01,  4.825354e-01,  3.232713e-01, -6.272031e-02,  1.139348e+00,  1.795626e-01},
  { 9.924619e-01,  1.061644e-01,  6.122431e-02,  5.292262e-01,  1.162335e+00,  8.920935e-02},
  {-6.403417e-01,  7.565953e-01, -1.323861e-01,  1.404740e-02,  1.267399e+00,  3.159998e-02},
  { 9.946378e-01,  9.909519e-02, -2.959288e-02,  5.270908e-01,  1.196349e+00, -1.542800e-02},
  {-3.778865e-01,  5.898697e-01, -7.136214e-01,  1.444113e-01,  1.232466e+00, -1.904523e-01},
  {-3.372906e-01,  5.849105e-01, -7.376414e-01,  2.093247e-01,  1.220904e+00, -2.282738e-01},
  {-6.055302e-01,  5.414969e-01, -5.831932e-01,  3.261319e-03,  1.182445e+00, -1.307566e-01},
  {-7.040029e-01,  5.117723e-01, -4.924114e-01, -1.380802e-02,  1.168098e+00, -1.233162e-01},
  { 8.002428e-01,  2.671451e-01, -5.368844e-01,  4.801339e-01,  1.205393e+00, -1.931580e-01},
  { 7.838085e-02,  3.976970e-01, -9.141627e-01,  3.314529e-01,  1.183454e+00, -2.728421e-01},
  { 7.422167e-01,  3.179724e-01, -5.899220e-01,  4.682024e-01,  1.190034e+00, -2.171703e-01},
  { 3.582105e-01,  3.521008e-01, -8.647024e-01,  4.157847e-01,  1.193808e+00, -2.504568e-01},
  { 6.507694e-01,  2.889454e-01, -7.021465e-01,  4.610274e-01,  1.186909e+00, -2.255460e-01},
  { 5.080124e-01,  3.536948e-01, -7.853811e-01,  4.435848e-01,  1.186869e+00, -2.392114e-01},
  { 3.774983e-01,  5.216758e-01,  7.650813e-01,  4.100554e-01,  1.126598e+00,  5.403674e-01},
  { 5.874456e-01,  4.005727e-01,  7.031708e-01,  4.268366e-01,  1.121298e+00,  5.323431e-01},
  { 7.678354e-01,  4.943772e-01,  4.074555e-01,  4.498124e-01,  1.158450e+00,  4.469616e-01},
  { 7.774901e-01,  3.892959e-01,  4.939208e-01,  4.592478e-01,  1.174933e+00,  4.077554e-01},
  {-3.389959e-01,  7.256371e-01,  5.987759e-01,  2.303441e-01,  1.210181e+00,  4.208956e-01},
  { 9.043484e-01,  3.182604e-01,  2.843663e-01,  4.870438e-01,  1.180119e+00,  3.354353e-01},
  { 9.044437e-01,  1.070001e-01,  4.129559e-01,  4.805574e-01,  1.200030e+00,  3.321846e-01},
  {-4.461113e-01,  6.176122e-01,  6.477190e-01,  4.440636e-02,  1.211633e+00,  2.373937e-01},
  { 9.059495e-01,  3.178882e-01,  2.796474e-01,  4.883592e-01,  1.186217e+00,  3.243056e-01},
  { 9.340543e-01,  1.539248e-01,  3.222574e-01,  4.853480e-01,  1.197411e+00,  3.214450e-01},
  {-3.944353e-01,  8.067269e-01,  4.400142e-01,  2.067613e-01,  1.331926e+00,  2.198790e-01},
  {-4.362091e-01,  7.966542e-01,  4.184061e-01,  1.550314e-01,  1.321292e+00,  1.882348e-01},
  {-6.694065e-01,  5.582503e-01,  4.901546e-01, -2.615367e-02,  1.161596e+00,  2.145362e-01},
  {-3.817736e-01,  8.441461e-01,  3.763860e-01,  1.781386e-01,  1.348288e+00,  1.596197e-01},
  {-7.312683e-01,  5.297304e-01,  4.296887e-01, -4.277378e-02,  1.162722e+00,  1.895450e-01},
  {-6.627297e-01,  7.350285e-01,  1.432561e-01,  5.548285e-03,  1.257774e+00,  8.611686e-02},
  {-8.398764e-01,  5.067245e-01,  1.945196e-01, -5.774767e-02,  1.178962e+00,  1.223050e-01},
  {-8.663044e-01,  4.335069e-01,  2.481700e-01, -5.432663e-02,  1.186244e+00,  1.176458e-01},
  {-7.857641e-01,  6.108371e-01,  9.722580e-02, -4.151107e-02,  1.206145e+00,  1.023255e-01},
  {-6.816707e-01,  7.244002e-01,  1.028084e-01, -5.392808e-02,  1.189033e+00,  1.157430e-01},
  {-7.845185e-01,  6.200540e-01, -7.989893e-03, -5.356856e-02,  1.188342e+00,  1.134659e-01},
  { 9.843047e-01,  1.759061e-01, -1.418981e-02,  5.245256e-01,  1.221831e+00, -8.382034e-03},
  { 9.825118e-01,  1.430954e-01, -1.191397e-01,  5.214100e-01,  1.220178e+00, -5.289736e-02},
  { 9.493244e-01,  2.249601e-01, -2.194903e-01,  5.091795e-01,  1.232095e+00, -1.073411e-01},
  {-2.086029e-01,  5.435839e-01, -8.130199e-01,  2.636881e-01,  1.221436e+00, -2.444517e-01},
  {-5.528898e-01,  5.980298e-01, -5.802354e-01,  3.326193e-02,  1.211468e+00, -1.315672e-01},
  { 8.762355e-01,  2.292577e-01, -4.238540e-01,  4.914383e-01,  1.219345e+00, -1.668902e-01},
  {-2.345616e-03,  4.813084e-01, -8.765482e-01,  3.178166e-01,  1.206176e+00, -2.626137e-01},
  { 3.059651e-01,  3.941161e-01, -8.666360e-01,  3.969043e-01,  1.207283e+00, -2.515165e-01},
  { 4.584551e-01,  3.749390e-01, -8.057541e-01,  4.352578e-01,  1.200584e+00, -2.381401e-01},
  { 1.780609e-01,  3.800719e-01, -9.076562e-01,  3.764206e-01,  1.191719e+00, -2.636580e-01},
  { 1.684773e-01,  6.294737e-01,  7.585369e-01,  3.991714e-01,  1.132690e+00,  5.383105e-01},
  { 2.591272e-02,  6.752011e-01,  7.371784e-01,  3.651797e-01,  1.126883e+00,  5.474179e-01},
  { 4.727742e-01,  6.423216e-01,  6.032475e-01,  4.122559e-01,  1.136403e+00,  5.318483e-01},
  { 5.191821e-01,  5.890599e-01,  6.192402e-01,  4.169092e-01,  1.129828e+00,  5.341682e-01},
  { 9.906041e-03,  7.133180e-01,  7.007705e-01,  3.629875e-01,  1.138422e+00,  5.363915e-01},
  { 7.066370e-01,  5.076111e-01,  4.929455e-01,  4.331354e-01,  1.129517e+00,  5.161431e-01},
  { 5.205811e-02,  7.453792e-01,  6.646049e-01,  3.598608e-01,  1.188894e+00,  4.808741e-01},
  {-4.266782e-01,  7.102855e-01,  5.598574e-01,  1.488099e-01,  1.220728e+00,  3.484100e-01},
  { 6.939951e-01,  5.897416e-01,  4.130082e-01,  4.335111e-01,  1.155610e+00,  4.818603e-01},
  {-7.771471e-01,  5.969284e-01,  1.992962e-01,  1.438119e-01,  1.225212e+00,  3.349695e-01},
  { 7.814076e-01,  4.878359e-01,  3.891249e-01,  4.420232e-01,  1.160287e+00,  4.599142e-01},
  {-8.254510e-02,  7.594684e-01,  6.452861e-01,  3.215080e-01,  1.221094e+00,  4.438292e-01},
  {-6.138654e-01,  6.871253e-01,  3.886234e-01,  1.577788e-01,  1.249658e+00,  3.103269e-01},
  { 8.475919e-01,  3.284415e-01,  4.167905e-01,  4.593581e-01,  1.206905e+00,  3.717817e-01},
  { 8.270272e-01,  4.198717e-01,  3.738097e-01,  4.695871e-01,  1.214473e+00,  3.441404e-01},
  {-4.247266e-01,  7.155058e-01,  5.546700e-01,  1.158516e-01,  1.283651e+00,  2.114727e-01},
  {-3.628201e-01,  6.457900e-01,  6.718011e-01,  1.040863e-01,  1.273018e+00,  2.156897e-01},
  {-6.306489e-01,  5.949920e-01,  4.982635e-01, -1.443307e-02,  1.181289e+00,  2.069169e-01},
  {-3.277533e-01,  8.425545e-01,  4.274106e-01,  2.260758e-01,  1.345125e+00,  2.102763e-01},
  {-3.538721e-01,  8.466586e-01,  3.974214e-01,  2.207002e-01,  1.353193e+00,  1.898346e-01},
  {-7.171042e-01,  5.674855e-01,  4.046254e-01, -4.168672e-02,  1.174290e+00,  1.761239e-01},
  {-8.078354e-01,  5.193785e-01,  2.786537e-01, -5.085770e-02,  1.176266e+00,  1.507166e-01},
  { 9.823041e-01,  1.541162e-01,  1.064277e-01,  5.212647e-01,  1.185641e+00,  1.527292e-01},
  {-3.592288e-01,  8.795691e-01,  3.119500e-01,  1.917566e-01,  1.370476e+00,  1.218103e-01},
  {-6.374538e-01,  7.576900e-01,  1.398519e-01,  3.384579e-02,  1.282733e+00,  8.457854e-02},
  {-7.344291e-01,  6.699877e-01,  1.083063e-01, -2.752349e-02,  1.222287e+00,  1.064375e-01},
  {-2.954999e-01,  9.065861e-01,  3.012994e-01,  2.256097e-01,  1.379640e+00,  1.296310e-01},
  {-6.045193e-01,  7.627170e-01,  2.298242e-01, -5.239071e-02,  1.189172e+00,  1.169489e-01},
  { 9.934807e-01,  1.112962e-01,  2.468597e-02,  5.278371e-01,  1.188834e+00,  5.977866e-02},
  { 9.681727e-01,  2.229416e-01, -1.137476e-01,  5.181791e-01,  1.244620e+00, -4.535874e-02},
  {-5.476633e-01,  6.734483e-01, -4.965201e-01,  5.323774e-02,  1.232902e+00, -1.259537e-01},
  {-2.960168e-01,  6.144186e-01, -7.313439e-01,  2.230417e-01,  1.243409e+00, -2.149590e-01},
  {-7.311245e-01,  5.772932e-01, -3.635788e-01, -1.020863e-02,  1.199826e+00, -9.100916e-02},
  { 8.902676e-01,  2.695258e-01, -3.671230e-01,  4.967627e-01,  1.232400e+00, -1.467314e-01},
  { 8.913050e-01,  2.861338e-01, -3.517141e-01,  4.976341e-01,  1.242007e+00, -1.370896e-01},
  {-1.206740e-01,  4.973198e-01, -8.591338e-01,  2.989271e-01,  1.213746e+00, -2.574989e-01},
  { 5.840076e-02,  4.618405e-01, -8.850383e-01,  3.410814e-01,  1.215781e+00, -2.565272e-01},
  { 2.388211e-01,  7.285018e-01,  6.420667e-01,  4.062060e-01,  1.145169e+00,  5.257179e-01},
  { 5.138873e-01,  5.600768e-01,  6.497952e-01,  4.174018e-01,  1.144915e+00,  5.204333e-01},
  { 9.572207e-02,  7.534663e-01,  6.504812e-01,  3.873862e-01,  1.158537e+00,  5.133334e-01},
  { 6.530269e-01,  5.880671e-01,  4.772138e-01,  4.222071e-01,  1.148146e+00,  5.113403e-01},
  { 5.938004e-01,  7.086171e-01,  3.811336e-01,  4.241633e-01,  1.158151e+00,  4.965397e-01},
  { 9.452112e-02,  7.457285e-01,  6.595110e-01,  3.640872e-01,  1.201098e+00,  4.667147e-01},
  { 5.566456e-01,  6.684132e-01,  4.933251e-01,  4.200426e-01,  1.184588e+00,  4.611858e-01},
  { 5.194401e-01,  6.796151e-01,  5.179818e-01,  4.187431e-01,  1.205547e+00,  4.346884e-01},
  { 6.904778e-01,  5.592297e-01,  4.588057e-01,  4.361977e-01,  1.193715e+00,  4.273275e-01},
  { 5.828401e-01,  6.249392e-01,  5.193729e-01,  4.295281e-01,  1.216443e+00,  4.088010e-01},
  { 6.922329e-01,  5.565691e-01,  4.593957e-01,  4.413919e-01,  1.217530e+00,  3.904453e-01},
  { 7.324287e-01,  5.188627e-01,  4.408283e-01,  4.529125e-01,  1.231060e+00,  3.562761e-01},
  {-1.715313e-01,  7.714712e-01,  6.127065e-01,  3.000635e-01,  1.233348e+00,  4.251272e-01},
  {-4.138705e-01,  7.774760e-01,  4.735424e-01,  1.938265e-01,  1.279511e+00,  2.973884e-01},
  {-3.574869e-01,  7.886552e-01,  5.002260e-01,  2.107698e-01,  1.297607e+00,  2.819700e-01},
  {-5.344054e-01,  6.708878e-01,  5.141210e-01,  6.147961e-02,  1.247090e+00,  2.101787e-01},
  {-6.263011e-01,  6.204125e-01,  4.720544e-01, -1.671731e-02,  1.191940e+00,  1.913485e-01},
  { 9.342477e-01,  2.773733e-01,  2.241548e-01,  4.944123e-01,  1.210990e+00,  2.712865e-01},
  {-5.892211e-01,  6.545976e-01,  4.736248e-01,  1.995809e-02,  1.224120e+00,  1.932631e-01},
  { 9.720779e-01,  1.745798e-01,  1.568002e-01,  5.137573e-01,  1.187294e+00,  2.054805e-01},
  {-6.261026e-01,  7.324843e-01,  2.673242e-01, -2.187236e-03,  1.240252e+00,  1.280239e-01},
  {-7.019480e-01,  6.808589e-01,  2.090458e-01, -1.952433e-02,  1.226498e+00,  1.228175e-01},
  {-7.600569e-01,  6.190140e-01,  1.978265e-01, -4.372079e-02,  1.195996e+00,  1.315007e-01},
  {-2.748813e-01,  9.388370e-01,  2.074257e-01,  2.233317e-01,  1.387150e+00,  9.968150e-02},
  {-6.609694e-01,  6.914868e-01, -2.914886e-01,  1.861149e-02,  1.249094e+00, -4.734986e-02},
  {-6.265996e-01,  7.047539e-01, -3.327084e-01,  1.523874e-02,  1.240444e+00, -5.960992e-02},
  { 9.256771e-01,  3.587299e-01, -1.201443e-01,  5.117211e-01,  1.261009e+00, -5.505150e-02},
  {-4.567526e-01,  6.311201e-01, -6.269486e-01,  1.004414e-01,  1.253834e+00, -1.424917e-01},
  {-6.414253e-01,  6.994827e-01, -3.151152e-01,  7.778681e-03,  1.230218e+00, -6.686643e-02},
  { 9.291044e-01,  2.847050e-01, -2.360256e-01,  5.035973e-01,  1.253771e+00, -1.073319e-01},
  {-5.760263e-01,  6.528679e-01, -4.918914e-01,  2.171949e-02,  1.217282e+00, -1.128501e-01},
  {-1.121973e-01,  5.541299e-01, -8.248344e-01,  3.043756e-01,  1.230973e+00, -2.470013e-01},
  {-6.527287e-01,  5.849691e-01, -4.814108e-01, -1.370149e-03,  1.200145e+00, -1.057498e-01},
  { 7.936934e-01,  3.500955e-01, -4.974777e-01,  4.806491e-01,  1.242871e+00, -1.713866e-01},
  { 7.798458e-01,  3.998756e-01, -4.816016e-01,  4.807740e-01,  1.249280e+00, -1.656422e-01},
  { 6.436675e-01,  3.968382e-01, -6.543788e-01,  4.616164e-01,  1.235014e+00, -1.982735e-01},
  { 3.985224e-01,  3.993233e-01, -8.256639e-01,  4.220697e-01,  1.225166e+00, -2.337182e-01},
  { 2.018613e-01,  4.522480e-01, -8.687484e-01,  3.875563e-01,  1.227773e+00, -2.445673e-01},
  { 5.584610e-01,  3.804123e-01, -7.371620e-01,  4.453873e-01,  1.214618e+00, -2.249926e-01},
  { 1.321954e-01,  4.497960e-01, -8.832938e-01,  3.741165e-01,  1.221221e+00, -2.509977e-01},
  { 2.840289e-01,  7.254366e-01,  6.269523e-01,  4.098724e-01,  1.147565e+00,  5.230534e-01},
  { 3.604374e-01,  7.670702e-01,  5.307429e-01,  4.052895e-01,  1.168912e+00,  4.961642e-01},
  { 2.869343e-01,  7.933228e-01,  5.369428e-01,  4.181560e-01,  1.157767e+00,  5.040656e-01},
  { 6.192689e-01,  6.164957e-01,  4.862500e-01,  4.243882e-01,  1.168018e+00,  4.794352e-01},
  { 3.056969e-02,  7.772439e-01,  6.284564e-01,  3.525335e-01,  1.227971e+00,  4.365955e-01},
  {-4.664580e-01,  7.372046e-01,  4.888212e-01,  2.160976e-01,  1.252591e+00,  3.592549e-01},
  { 5.781258e-01,  6.229323e-01,  5.269973e-01,  4.197207e-01,  1.234113e+00,  3.986430e-01},
  { 5.462599e-01,  6.732255e-01,  4.983650e-01,  4.243921e-01,  1.244292e+00,  3.797947e-01},
  {-2.503565e-01,  7.801522e-01,  5.733098e-01,  2.781149e-01,  1.250053e+00,  3.942976e-01},
  {-2.942067e-01,  8.308687e-01,  4.723342e-01,  2.262925e-01,  1.317438e+00,  2.606744e-01},
  { 8.621036e-01,  4.028757e-01,  3.073574e-01,  4.836822e-01,  1.232128e+00,  2.831502e-01},
  {-6.494287e-01,  6.415265e-01,  4.082723e-01, -1.800727e-02,  1.200500e+00,  1.778348e-01},
  { 9.503476e-01,  2.438744e-01,  1.932995e-01,  5.050941e-01,  1.214136e+00,  2.194473e-01},
  {-2.707530e-01,  8.795422e-01,  3.912779e-01,  2.593860e-01,  1.370065e+00,  1.811415e-01},
  {-6.380821e-01,  6.977296e-01,  3.256141e-01, -1.413424e-02,  1.224490e+00,  1.418147e-01},
  {-7.130447e-01,  6.289538e-01,  3.098134e-01, -2.717636e-02,  1.211116e+00,  1.429021e-01},
  { 9.580908e-01,  2.442555e-01,  1.496702e-01,  5.140234e-01,  1.213404e+00,  1.668709e-01},
  {-6.407797e-01,  7.603111e-01,  1.064358e-01,  4.772054e-02,  1.298694e+00,  4.671278e-02},
  { 9.774653e-01,  1.924394e-01,  8.676755e-02,  5.210789e-01,  1.214818e+00,  1.013088e-01},
  {-3.140405e-01,  9.324192e-01,  1.788100e-01,  2.001664e-01,  1.380707e+00,  9.590897e-02},
  { 9.775964e-01,  1.975472e-01,  7.266637e-02,  5.221311e-01,  1.221735e+00,  6.730153e-02},
  { 9.808506e-01,  1.916846e-01,  3.448515e-02,  5.226216e-01,  1.224812e+00,  4.794127e-02},
  { 9.529186e-01,  3.030636e-01, -9.924507e-03,  5.163761e-01,  1.258246e+00, -1.515913e-02},
  {-6.592230e-01,  6.449027e-01, -3.866853e-01,  4.163066e-02,  1.265006e+00, -6.153018e-02},
  { 9.341530e-01,  3.446855e-01, -9.246637e-02,  5.144459e-01,  1.261318e+00, -3.728764e-02},
  { 9.236560e-01,  3.524984e-01, -1.503477e-01,  5.062808e-01,  1.272661e+00, -6.550475e-02},
  {-3.924313e-01,  6.303452e-01, -6.698229e-01,  1.488326e-01,  1.268000e+00, -1.611810e-01},
  {-5.843736e-01,  6.373639e-01, -5.022697e-01,  7.076964e-02,  1.265056e+00, -1.046197e-01},
  {-1.839821e-01,  5.952747e-01, -7.821755e-01,  2.840570e-01,  1.259418e+00, -2.220908e-01},
  { 8.179859e-01,  3.636546e-01, -4.457066e-01,  4.825129e-01,  1.262232e+00, -1.533000e-01},
  { 6.787210e-01,  3.729400e-01, -6.326560e-01,  4.670082e-01,  1.253344e+00, -1.810820e-01},
  {-6.136857e-02,  5.578356e-01, -8.276795e-01,  3.197137e-01,  1.240333e+00, -2.422945e-01},
  { 4.822533e-01,  4.272089e-01, -7.648035e-01,  4.316993e-01,  1.233815e+00, -2.242227e-01},
  { 3.214322e-01,  4.580832e-01, -8.287588e-01,  4.076297e-01,  1.238912e+00, -2.323790e-01},
  { 6.014211e-02,  4.987678e-01, -8.646465e-01,  3.547198e-01,  1.231523e+00, -2.472589e-01},
  { 5.873390e-02,  7.999915e-01,  5.971296e-01,  3.531489e-01,  1.237720e+00,  4.244927e-01},
  {-6.846160e-03,  7.888634e-01,  6.145304e-01,  3.262261e-01,  1.246882e+00,  4.121986e-01},
  { 5.518622e-01,  6.616057e-01,  5.076672e-01,  4.314966e-01,  1.253000e+00,  3.602400e-01},
  { 7.844046e-01,  4.977707e-01,  3.700456e-01,  4.648753e-01,  1.238025e+00,  3.253618e-01},
  {-6.092600e-01,  6.674430e-01,  4.281612e-01,  4.457793e-02,  1.255617e+00,  1.794165e-01},
  {-5.966221e-01,  6.942084e-01,  4.026372e-01,  3.556169e-03,  1.225660e+00,  1.688860e-01},
  {-6.238592e-01,  7.227060e-01,  2.974823e-01,  3.447959e-02,  1.268248e+00,  1.377205e-01},
  {-2.495429e-01,  9.129471e-01,  3.228869e-01,  2.652267e-01,  1.383694e+00,  1.528782e-01},
  {-4.488445e-01,  8.289145e-01,  3.338252e-01,  1.450550e-01,  1.345795e+00,  1.276534e-01},
  {-5.880134e-01,  7.839471e-01,  1.991660e-01,  5.484288e-02,  1.294486e+00,  1.076893e-01},
  { 9.533992e-01,  2.805825e-01,  1.109212e-01,  5.090440e-01,  1.247376e+00,  1.399862e-01},
  {-2.441310e-01,  9.577442e-01,  1.520723e-01,  2.752829e-01,  1.402422e+00,  9.705481e-02},
  {-3.768329e-01,  9.047080e-01,  1.987473e-01,  1.830742e-01,  1.375122e+00,  9.149857e-02},
  { 9.582828e-01,  2.715716e-01,  8.912267e-02,  5.120046e-01,  1.259415e+00,  7.812431e-02},
  {-2.736000e-01,  9.608127e-01,  4.451964e-02,  2.390802e-01,  1.395999e+00,  6.372268e-02},
  {-6.796360e-01,  7.229338e-01, -1.243442e-01,  4.906914e-02,  1.298347e+00,  1.949390e-02},
  {-6.667197e-01,  6.962718e-01, -2.658766e-01,  5.266017e-02,  1.284722e+00, -4.244792e-02},
  { 9.438049e-01,  3.301524e-01,  1.522654e-02,  5.129225e-01,  1.264959e+00,  1.986742e-02},
  {-3.769728e-01,  6.698285e-01, -6.397042e-01,  1.564860e-01,  1.279763e+00, -1.541251e-01},
  { 9.098434e-01,  3.724543e-01, -1.829282e-01,  5.007010e-01,  1.275061e+00, -8.703173e-02},
  {-3.197858e-01,  6.439329e-01, -6.950449e-01,  1.876254e-01,  1.277245e+00, -1.724033e-01},
  {-6.317303e-01,  6.825780e-01, -3.674292e-01,  7.048864e-03,  1.218638e+00, -9.137682e-02},
  { 8.786608e-01,  3.653849e-01, -3.073259e-01,  4.926533e-01,  1.271589e+00, -1.227724e-01},
  {-2.051716e-01,  6.087604e-01, -7.663651e-01,  2.854412e-01,  1.270660e+00, -2.135678e-01},
  {-6.763981e-02,  5.945465e-01, -8.012111e-01,  3.122188e-01,  1.277995e+00, -2.147811e-01},
  { 6.480970e-01,  3.777519e-01, -6.612667e-01,  4.578987e-01,  1.259945e+00, -1.866260e-01},
  { 4.822484e-01,  4.449860e-01, -7.546019e-01,  4.368547e-01,  1.247451e+00, -2.131635e-01},
  { 8.272824e-02,  5.373546e-01, -8.392890e-01,  3.714108e-01,  1.247085e+00, -2.371493e-01},
  {-4.667472e-01,  7.811856e-01,  4.146035e-01,  2.218721e-01,  1.262728e+00,  3.491040e-01},
  { 6.679850e-01,  5.807655e-01,  4.653036e-01,  4.419653e-01,  1.259036e+00,  3.398090e-01},
  {-1.594825e-01,  8.092985e-01,  5.653329e-01,  3.041240e-01,  1.257280e+00,  3.938096e-01},
  { 8.636766e-01,  4.308503e-01,  2.615929e-01,  4.813272e-01,  1.259588e+00,  2.536357e-01},
  {-2.142746e-01,  8.552398e-01,  4.718593e-01,  2.694373e-01,  1.345632e+00,  2.354248e-01},
  { 9.005135e-01,  3.616113e-01,  2.414802e-01,  4.894382e-01,  1.253105e+00,  2.340395e-01},
  {-4.880346e-01,  7.620252e-01,  4.256053e-01,  1.042293e-01,  1.310098e+00,  1.601584e-01},
  { 9.397907e-01,  3.014413e-01,  1.610175e-01,  5.051660e-01,  1.249919e+00,  1.615876e-01},
  {-2.309574e-01,  9.345720e-01,  2.706175e-01,  2.824855e-01,  1.398065e+00,  1.232800e-01},
  { 9.457361e-01,  3.123572e-01,  8.953328e-02,  5.030789e-01,  1.285800e+00,  9.149759e-02},
  {-6.411464e-01,  7.251009e-01, -2.513165e-01,  6.809385e-02,  1.302733e+00, -3.137880e-02},
  {-6.458161e-01,  6.535503e-01, -3.947070e-01,  6.560063e-02,  1.284857e+00, -6.882743e-02},
  { 8.954803e-01,  4.410982e-01, -5.956038e-02,  5.008204e-01,  1.292305e+00, -2.724885e-02},
  {-5.512455e-01,  6.313173e-01, -5.454970e-01,  9.026265e-02,  1.281719e+00, -1.055261e-01},
  {-2.764224e-01,  6.635161e-01, -6.952244e-01,  2.142085e-01,  1.287786e+00, -1.734314e-01},
  { 8.096746e-01,  4.119862e-01, -4.179646e-01,  4.814625e-01,  1.285343e+00, -1.345735e-01},
  { 1.549660e-01,  5.196316e-01, -8.402194e-01,  3.842733e-01,  1.251316e+00, -2.323997e-01},
  { 2.762854e-01,  8.029750e-01,  5.281076e-01,  3.975044e-01,  1.255401e+00,  3.875304e-01},
  {-3.087630e-01,  7.809712e-01,  5.429082e-01,  2.315354e-01,  1.262748e+00,  3.557042e-01},
  { 3.148753e-01,  7.747189e-01,  5.483286e-01,  4.001451e-01,  1.264783e+00,  3.714037e-01},
  { 4.215979e-01,  7.422298e-01,  5.209128e-01,  4.085983e-01,  1.269195e+00,  3.587930e-01},
  { 4.821085e-01,  7.045141e-01,  5.207987e-01,  4.313852e-01,  1.270450e+00,  3.374935e-01},
  {-3.986684e-02,  8.035905e-01,  5.938458e-01,  3.349000e-01,  1.262181e+00,  3.923276e-01},
  {-3.948283e-01,  8.071891e-01,  4.388126e-01,  2.339750e-01,  1.285326e+00,  3.189462e-01},
  { 7.054167e-01,  5.578875e-01,  4.372056e-01,  4.446874e-01,  1.270981e+00,  3.206778e-01},
  {-2.786196e-01,  8.207223e-01,  4.987845e-01,  2.573805e-01,  1.310344e+00,  2.906769e-01},
  { 7.938136e-01,  4.854504e-01,  3.663301e-01,  4.641326e-01,  1.271469e+00,  2.825324e-01},
  {-5.527890e-01,  7.184248e-01,  4.222441e-01,  5.780141e-02,  1.272673e+00,  1.715265e-01},
  {-1.813476e-01,  8.728214e-01,  4.530958e-01,  2.926672e-01,  1.360388e+00,  2.174118e-01},
  {-5.621458e-01,  7.668058e-01,  3.098399e-01,  6.678902e-02,  1.291892e+00,  1.435242e-01},
  {-1.959152e-01,  9.698332e-01,  1.450547e-01,  3.045352e-01,  1.411535e+00,  8.288896e-02},
  {-6.480896e-01,  7.609980e-01, -2.935762e-02,  8.189737e-02,  1.329746e+00,  2.874816e-02},
  {-4.950251e-01,  8.349487e-01, -2.404387e-01,  1.191456e-01,  1.344095e+00, -2.617376e-02},
  { 8.912262e-01,  4.409988e-01, -1.059990e-01,  4.946184e-01,  1.298558e+00, -5.976880e-02},
  {-6.037071e-01,  6.360173e-01, -4.806453e-01,  8.430254e-02,  1.289064e+00, -9.036382e-02},
  {-3.844720e-01,  6.917408e-01, -6.112905e-01,  1.582468e-01,  1.291928e+00, -1.417725e-01},
  {-2.107392e-01,  6.501973e-01, -7.299536e-01,  2.983578e-01,  1.296335e+00, -1.955482e-01},
  { 7.231312e-01,  4.127750e-01, -5.538033e-01,  4.630311e-01,  1.285173e+00, -1.635953e-01},
  { 5.262547e-01,  4.035707e-01, -7.484562e-01,  4.298949e-01,  1.269562e+00, -2.041039e-01},
  { 3.701900e-02,  5.566177e-01,  8.299435e-01,  3.907129e-01,  1.235429e+00,  4.252758e-01},
  {-9.585304e-02,  8.159779e-01,  5.700809e-01,  3.886297e-01,  1.238240e+00,  4.216816e-01},
  { 4.785228e-01,  7.203400e-01,  5.021218e-01,  4.312567e-01,  1.282065e+00,  3.219690e-01},
  { 7.058783e-01,  5.707932e-01,  4.194412e-01,  4.451964e-01,  1.282946e+00,  3.056350e-01},
  {-2.294234e-01,  8.327959e-01,  5.038016e-01,  2.624037e-01,  1.285474e+00,  3.339392e-01},
  { 7.805955e-01,  5.272397e-01,  3.356917e-01,  4.629069e-01,  1.280697e+00,  2.717155e-01},
  {-4.896751e-01,  7.592406e-01,  4.286864e-01,  8.321611e-02,  1.294366e+00,  1.626118e-01},
  { 9.150489e-01,  3.436250e-01,  2.112045e-01,  4.884525e-01,  1.271942e+00,  2.095054e-01},
  {-2.530772e-01,  8.872639e-01,  3.856354e-01,  3.010703e-01,  1.393244e+00,  1.494287e-01},
  {-1.767042e-01,  9.516781e-01,  2.511662e-01,  3.125873e-01,  1.406241e+00,  1.163084e-01},
  { 9.109793e-01,  3.873734e-01,  1.416283e-01,  4.925841e-01,  1.305821e+00,  1.171826e-01},
  {-6.417645e-01,  7.653116e-01,  4.936222e-02,  8.457179e-02,  1.331557e+00,  4.333058e-02},
  {-5.882512e-01,  7.935638e-01, -1.556179e-01,  9.300723e-02,  1.337468e+00,  1.472235e-02},
  {-2.132346e-01,  9.769022e-01,  1.389543e-02,  2.975394e-01,  1.411759e+00,  5.326392e-02},
  {-5.382019e-01,  8.154685e-01, -2.129551e-01,  1.080005e-01,  1.343789e+00,  5.182343e-04},
  {-2.728104e-01,  9.585273e-01, -8.246139e-02,  2.103718e-01,  1.387135e+00,  2.016359e-02},
  {-3.244330e-01,  9.451661e-01,  3.747296e-02,  1.777170e-01,  1.377514e+00,  5.567391e-02},
  {-4.346596e-01,  8.797722e-01, -1.925405e-01,  1.346814e-01,  1.354994e+00, -1.653706e-02},
  {-2.437333e-01,  9.656187e-01, -9.041334e-02,  2.932003e-01,  1.408729e+00,  1.870194e-02},
  {-5.834036e-01,  7.652990e-01, -2.719515e-01,  8.886623e-02,  1.318140e+00, -3.665767e-02},
  {-3.981045e-01,  8.612055e-01, -3.159713e-01,  1.427863e-01,  1.354393e+00, -3.238925e-02},
  { 8.980485e-01,  4.374204e-01, -4.660832e-02,  4.925632e-01,  1.314080e+00,  1.988942e-02},
  {-1.507176e-01,  9.644642e-01, -2.170093e-01,  3.132876e-01,  1.406389e+00, -2.823442e-02},
  {-2.481138e-01,  9.484682e-01, -1.970980e-01,  2.520236e-01,  1.394328e+00, -1.210516e-02},
  {-4.846435e-01,  8.027658e-01, -3.474014e-01,  1.143146e-01,  1.333274e+00, -4.540744e-02},
  { 8.861442e-01,  4.596832e-01, -5.864992e-02,  4.943452e-01,  1.308595e+00, -2.017176e-04},
  { 8.579131e-01,  5.031862e-01, -1.038685e-01,  4.886981e-01,  1.312302e+00, -4.669305e-02},
  {-1.658271e-01,  9.417762e-01, -2.925046e-01,  3.054041e-01,  1.399689e+00, -4.871195e-02},
  {-1.732430e-01,  9.277899e-01, -3.304434e-01,  3.038127e-01,  1.396271e+00, -5.875575e-02},
  {-3.030742e-01,  7.216939e-01, -6.223375e-01,  1.110784e-01,  1.294511e+00, -1.078902e-01},
  { 8.711419e-01,  4.439310e-01, -2.098502e-01,  4.866963e-01,  1.301796e+00, -9.477221e-02},
  { 8.275515e-01,  4.622567e-01, -3.185552e-01,  4.803052e-01,  1.298962e+00, -1.208560e-01},
  {-2.618898e-01,  6.707968e-01, -6.938626e-01,  2.653064e-01,  1.303714e+00, -1.775876e-01},
  { 7.377614e-01,  5.050212e-01, -4.479528e-01,  4.723416e-01,  1.299155e+00, -1.373735e-01},
  { 6.495069e-01,  4.718250e-01, -5.962565e-01,  4.566848e-01,  1.296790e+00, -1.632036e-01},
  { 5.920267e-01,  3.293882e-01, -7.355323e-01,  4.423237e-01,  1.285558e+00, -1.842750e-01},
  { 3.134380e-01,  4.637703e-01, -8.286578e-01,  4.102918e-01,  1.279544e+00, -2.083134e-01},
  {-1.926416e-02,  6.194604e-01, -7.847915e-01,  3.527990e-01,  1.289609e+00, -2.093439e-01},
  { 8.148921e-02,  5.419376e-01, -8.364587e-01,  3.808830e-01,  1.277893e+00, -2.169679e-01},
  { 5.105255e-01,  4.652511e-01,  7.231218e-01,  3.926615e-01,  1.236570e+00,  4.240416e-01},
  { 5.872319e-01,  5.804768e-01,  5.640972e-01,  3.933403e-01,  1.236132e+00,  4.237134e-01},
  { 2.505076e-01,  7.913591e-01,  5.576709e-01,  3.925386e-01,  1.237012e+00,  4.237524e-01},
  { 3.908488e-01,  8.642503e-01,  3.167153e-01,  3.923201e-01,  1.237604e+00,  4.221456e-01},
  { 3.584121e-01,  7.871832e-01,  5.018798e-01,  4.103386e-01,  1.296765e+00,  3.169302e-01},
  {-1.445980e-01,  8.254911e-01,  5.455784e-01,  3.166864e-01,  1.279854e+00,  3.638375e-01},
  {-1.830836e-01,  8.864096e-01,  4.251567e-01,  2.969495e-01,  1.318442e+00,  2.930207e-01},
  { 8.396083e-01,  4.370197e-01,  3.226014e-01,  4.783381e-01,  1.283174e+00,  2.280307e-01},
  {-5.211915e-01,  7.707093e-01,  3.665605e-01,  9.516919e-02,  1.308907e+00,  1.491236e-01},
  {-5.322486e-01,  8.014850e-01,  2.726412e-01,  8.228099e-02,  1.306423e+00,  1.338867e-01},
  { 9.045643e-01,  3.823565e-01,  1.885919e-01,  4.833766e-01,  1.303595e+00,  1.726930e-01},
  {-1.294263e-01,  9.394670e-01,  3.172549e-01,  3.296227e-01,  1.409940e+00,  1.117695e-01},
  {-6.117851e-01,  7.745225e-01,  1.607295e-01,  9.458258e-02,  1.336984e+00,  5.925810e-02},
  {-1.936594e-01,  9.784339e-01,  7.185410e-02,  3.258972e-01,  1.414934e+00,  8.621131e-02},
  {-4.529570e-01,  8.652298e-01,  2.149589e-01,  1.336878e-01,  1.355938e+00,  8.206554e-02},
  {-3.945002e-01,  9.137601e-01,  9.701538e-02,  1.381630e-01,  1.361305e+00,  6.391440e-02},
  { 9.041454e-01,  4.207917e-01,  7.386180e-02,  4.929830e-01,  1.313237e+00,  8.842400e-02},
  {-1.794674e-01,  9.806471e-01, -7.824812e-02,  3.116662e-01,  1.412983e+00,  1.745493e-02},
  { 9.057176e-01,  4.234444e-01,  1.924815e-02,  4.910190e-01,  1.319695e+00,  5.944604e-02},
  {-2.812396e-01,  9.342105e-01, -2.194427e-01,  2.152958e-01,  1.383410e+00, -1.596676e-02},
  {-5.064260e-01,  7.796067e-01, -3.684374e-01,  1.039960e-01,  1.322315e+00, -5.477528e-02},
  {-3.050207e-01,  8.690608e-01, -3.894812e-01,  1.551533e-01,  1.351920e+00, -5.003159e-02},
  {-2.612213e-01,  9.141456e-01, -3.100021e-01,  2.545652e-01,  1.382891e+00, -5.733908e-02},
  {-3.542060e-01,  7.550278e-01, -5.517890e-01,  1.633832e-01,  1.307304e+00, -1.262290e-01},
  { 8.366299e-01,  5.265481e-01, -1.509883e-01,  4.800313e-01,  1.318415e+00, -8.135705e-02},
  {-2.621604e-01,  9.014798e-01, -3.443924e-01,  2.712626e-01,  1.383101e+00, -7.072027e-02},
  {-1.797610e-01,  8.916028e-01, -4.156084e-01,  3.024756e-01,  1.388443e+00, -7.760442e-02},
  {-3.132868e-01,  7.121550e-01, -6.282408e-01,  1.952190e-01,  1.307644e+00, -1.442450e-01},
  { 5.075761e-01,  1.436370e-01, -8.495499e-01,  4.205538e-01,  1.287058e+00, -1.988396e-01},
  { 4.552023e-01,  3.822280e-01, -8.041720e-01,  4.148109e-01,  1.286634e+00, -2.019058e-01},
  { 3.934763e-01,  4.641819e-01, -7.935436e-01,  4.117333e-01,  1.284744e+00, -2.054860e-01},
  { 6.590520e-01,  6.684086e-01,  3.447902e-01,  3.927850e-01,  1.237022e+00,  4.234393e-01},
  { 6.592708e-01,  6.279662e-01,  4.135461e-01,  4.436891e-01,  1.291223e+00,  2.964398e-01},
  { 4.824785e-01,  7.666874e-01,  4.235623e-01,  4.260191e-01,  1.312701e+00,  2.781565e-01},
  { 3.305643e-01,  8.183877e-01,  4.700733e-01,  4.063835e-01,  1.313261e+00,  2.929156e-01},
  { 7.030121e-01,  6.215363e-01,  3.456393e-01,  4.469361e-01,  1.299310e+00,  2.744301e-01},
  { 7.128985e-01,  5.774769e-01,  3.978646e-01,  4.551568e-01,  1.302533e+00,  2.538627e-01},
  { 4.607108e-02,  8.770584e-01,  4.781694e-01,  3.527932e-01,  1.343445e+00,  2.575851e-01},
  {-6.714715e-02,  8.604657e-01,  5.050644e-01,  3.331582e-01,  1.347077e+00,  2.509454e-01},
  { 2.286095e-01,  8.640935e-01,  4.484197e-01,  4.001883e-01,  1.352554e+00,  2.244937e-01},
  { 8.661426e-01,  4.481502e-01,  2.212656e-01,  4.777249e-01,  1.304467e+00,  1.945352e-01},
  {-1.853867e-01,  8.137190e-01,  5.509020e-01,  3.290409e-01,  1.378820e+00,  1.964068e-01},
  { 3.274311e-01,  8.668041e-01,  3.760844e-01,  4.120052e-01,  1.365471e+00,  1.888921e-01},
  { 1.806181e-01,  8.835154e-01,  4.321779e-01,  3.563410e-01,  1.379108e+00,  1.932858e-01},
  {-3.679237e-01,  8.334933e-01,  4.122149e-01,  3.247275e-01,  1.382937e+00,  1.874292e-01},
  { 2.246774e-01,  8.795319e-01,  4.194564e-01,  3.689400e-01,  1.384130e+00,  1.779647e-01},
  {-8.723013e-02,  9.473938e-01,  3.079544e-01,  3.268313e-01,  1.399301e+00,  1.456681e-01},
  {-5.477039e-01,  7.979176e-01,  2.516900e-01,  1.093677e-01,  1.340020e+00,  8.722686e-02},
  { 3.947412e-01,  8.566709e-01,  3.321058e-01,  4.129270e-01,  1.379035e+00,  1.545628e-01},
  { 3.541593e-01,  8.704062e-01,  3.420002e-01,  3.973957e-01,  1.387427e+00,  1.504469e-01},
  {-5.465763e-01,  8.098925e-01,  2.129050e-01,  1.086581e-01,  1.343385e+00,  7.394657e-02},
  {-9.408911e-02,  9.297574e-01,  3.559474e-01,  3.401227e-01,  1.410232e+00,  1.141846e-01},
  {-5.452329e-01,  8.382616e-01, -6.203243e-03,  9.895677e-02,  1.342925e+00,  3.021923e-02},
  { 8.276235e-01,  5.582175e-01,  5.858668e-02,  4.820707e-01,  1.333583e+00,  8.731055e-02},
  {-1.145883e-01,  9.745173e-01, -1.928353e-01,  3.344321e-01,  1.413509e+00, -8.474192e-03},
  {-2.785648e-01,  9.399777e-01, -1.970878e-01,  1.987098e-01,  1.380105e+00, -8.455892e-03},
  { 8.704763e-01,  4.904219e-01, -4.192182e-02,  4.832901e-01,  1.335364e+00,  4.158764e-02},
  {-5.928592e-01,  7.218147e-01, -3.570734e-01,  8.406577e-02,  1.298974e+00, -7.453766e-02},
  { 8.314884e-01,  5.481536e-01, -9.030161e-02,  4.716554e-01,  1.345414e+00, -9.076986e-03},
  { 8.206893e-01,  5.650536e-01, -8.475571e-02,  4.701214e-01,  1.345503e+00, -2.239695e-02},
  {-4.959004e-01,  7.267642e-01, -4.752858e-01,  9.856763e-02,  1.303912e+00, -8.492809e-02},
  {-9.594878e-02,  9.074937e-01, -4.089608e-01,  3.250949e-01,  1.391285e+00, -7.797004e-02},
  { 8.114319e-01,  5.332168e-01, -2.392868e-01,  4.760071e-01,  1.318265e+00, -9.954376e-02},
  {-2.789752e-01,  7.509077e-01, -5.985904e-01,  2.112133e-01,  1.319969e+00, -1.372788e-01},
  {-8.995307e-02,  6.807477e-01, -7.269739e-01,  3.258888e-01,  1.317777e+00, -1.816393e-01},
  {-1.838278e-01,  6.985949e-01, -6.915002e-01,  3.003097e-01,  1.319595e+00, -1.745005e-01},
  {-3.829929e-02,  8.441474e-01,  5.347413e-01,  3.512623e-01,  1.288751e+00,  3.571360e-01},
  { 2.895989e-01,  8.240334e-01,  4.869305e-01,  3.822649e-01,  1.304805e+00,  3.228726e-01},
  { 5.520301e-01,  7.256071e-01,  4.108005e-01,  4.425312e-01,  1.295836e+00,  2.907137e-01},
  { 1.653808e-01,  8.718193e-01,  4.610642e-01,  3.786370e-01,  1.318918e+00,  2.989028e-01},
  { 1.696010e-01,  8.629426e-01,  4.759890e-01,  3.734123e-01,  1.311937e+00,  3.144930e-01},
  {-1.363000e-01,  8.525409e-01,  5.045754e-01,  3.208051e-01,  1.306893e+00,  3.221455e-01},
  { 5.908626e-01,  6.186568e-01,  5.178274e-01,  4.421561e-01,  1.320953e+00,  2.475237e-01},
  { 7.387274e-01,  5.369419e-01,  4.074005e-01,  4.578488e-01,  1.310968e+00,  2.373054e-01},
  { 3.894340e-01,  7.703382e-01,  5.048962e-01,  4.254077e-01,  1.328591e+00,  2.521914e-01},
  { 1.923410e-01,  8.720466e-01,  4.500439e-01,  3.759520e-01,  1.330943e+00,  2.765221e-01},
  {-9.617978e-02,  8.758333e-01,  4.729329e-01,  3.297496e-01,  1.323093e+00,  2.957469e-01},
  {-2.270197e-02,  9.366840e-01,  3.494388e-01,  3.533660e-01,  1.332644e+00,  2.786715e-01},
  { 8.014522e-01,  5.469862e-01,  2.418274e-01,  4.674937e-01,  1.319959e+00,  2.008969e-01},
  { 3.528908e-01,  8.389974e-01,  4.141876e-01,  4.249557e-01,  1.343766e+00,  2.261799e-01},
  { 4.555974e-01,  8.317947e-01,  3.170938e-01,  4.361537e-01,  1.351246e+00,  1.984467e-01},
  {-4.750619e-02,  8.443549e-01,  5.336740e-01,  3.360925e-01,  1.382458e+00,  1.922059e-01},
  {-2.387263e-01,  9.036341e-01,  3.556055e-01,  3.296626e-01,  1.386283e+00,  1.835368e-01},
  {-3.574459e-02,  9.592887e-01,  2.801563e-01,  3.337883e-01,  1.389258e+00,  1.774300e-01},
  { 3.435954e-01,  8.764236e-01,  3.373781e-01,  3.877020e-01,  1.396837e+00,  1.362613e-01},
  { 5.005197e-01,  8.298587e-01,  2.466066e-01,  4.297051e-01,  1.375119e+00,  1.384642e-01},
  { 8.603342e-01,  4.939705e-01,  1.257706e-01,  4.781739e-01,  1.334826e+00,  1.252421e-01},
  { 4.937586e-01,  8.295648e-01,  2.608154e-01,  4.224506e-01,  1.385195e+00,  1.207109e-01},
  { 4.633617e-01,  8.405529e-01,  2.806540e-01,  4.152830e-01,  1.391293e+00,  1.154398e-01},
  { 1.218094e-02,  9.708827e-01,  2.392458e-01,  3.500256e-01,  1.415673e+00,  9.592023e-02},
  { 5.171701e-01,  8.195184e-01,  2.468293e-01,  4.174699e-01,  1.395018e+00,  1.017083e-01},
  {-4.346431e-01,  8.993711e-01,  4.708438e-02,  1.243436e-01,  1.356167e+00,  4.866181e-02},
  { 8.268081e-01,  5.589176e-01,  6.324103e-02,  4.796170e-01,  1.335845e+00,  1.014403e-01},
  {-3.721654e-01,  9.274306e-01, -3.695366e-02,  1.549251e-01,  1.369204e+00,  2.683349e-02},
  {-4.543826e-01,  8.841931e-01, -1.083461e-01,  1.240256e-01,  1.355414e+00,  1.916046e-02},
  {-3.964802e-01,  9.133266e-01, -9.294115e-02,  1.445840e-01,  1.363307e+00,  4.219282e-03},
  { 8.142033e-01,  5.779843e-01,  5.483865e-02,  4.756331e-01,  1.348125e+00,  4.878911e-02},
  { 7.858545e-01,  6.146989e-01, -6.766043e-02,  4.744204e-01,  1.348294e+00,  3.122026e-02},
  {-2.787540e-01,  8.992638e-01, -3.370769e-01,  2.155201e-01,  1.373994e+00, -5.028612e-02},
  {-2.117214e-02,  9.410985e-01, -3.374689e-01,  3.383994e-01,  1.399604e+00, -5.958785e-02},
  {-4.880651e-02,  9.215643e-01, -3.851456e-01,  3.382609e-01,  1.394480e+00, -7.281774e-02},
  {-1.882317e-01,  7.857634e-01, -5.891898e-01,  1.170484e-01,  1.310264e+00, -9.210660e-02},
  {-8.475107e-03,  8.784105e-01, -4.778320e-01,  3.546349e-01,  1.383463e+00, -9.641534e-02},
  {-3.101116e-01,  7.732846e-01, -5.530477e-01,  2.010275e-01,  1.325583e+00, -1.246967e-01},
  { 7.384004e-01,  5.746686e-01, -3.528750e-01,  4.637385e-01,  1.325825e+00, -1.190182e-01},
  {-1.561895e-01,  5.814791e-01, -7.984277e-01,  3.514660e-01,  1.323300e+00, -1.781720e-01},
  { 6.165108e-01,  5.308387e-01, -5.814849e-01,  4.450018e-01,  1.315209e+00, -1.600925e-01},
  { 4.811852e-01,  5.113800e-01, -7.120051e-01,  4.233134e-01,  1.298422e+00, -1.896029e-01},
  { 4.490454e-02,  6.144955e-01, -7.876413e-01,  3.862983e-01,  1.298200e+00, -2.010424e-01},
  { 1.023440e-01,  5.800549e-01, -8.081225e-01,  3.959064e-01,  1.301353e+00, -1.976454e-01},
  { 4.971226e-01,  6.964902e-01,  5.174655e-01,  4.420059e-01,  1.329649e+00,  2.362411e-01},
  { 7.390493e-01,  5.132453e-01,  4.363318e-01,  4.584035e-01,  1.317203e+00,  2.284153e-01},
  {-5.961996e-02,  9.367112e-01,  3.449892e-01,  3.426146e-01,  1.330480e+00,  2.838401e-01},
  { 7.859762e-01,  5.619911e-01,  2.576963e-01,  4.626487e-01,  1.324189e+00,  2.083465e-01},
  { 7.734361e-02,  9.273322e-01,  3.661596e-01,  3.517631e-01,  1.392272e+00,  1.675200e-01},
  { 5.927290e-01,  7.668613e-01,  2.461625e-01,  4.446205e-01,  1.356077e+00,  1.688005e-01},
  { 1.971067e-01,  9.108101e-01,  3.627310e-01,  3.650937e-01,  1.398401e+00,  1.467064e-01},
  { 1.155976e-01,  9.498177e-01,  2.906605e-01,  3.370841e-01,  1.388186e+00,  1.813027e-01},
  { 2.596712e-01,  9.180298e-01,  2.996534e-01,  3.827059e-01,  1.400990e+00,  1.291170e-01},
  { 3.141636e-02,  9.339154e-01,  3.561110e-01,  3.569454e-01,  1.408271e+00,  1.206379e-01},
  { 7.595309e-01,  6.424734e-01,  1.016891e-01,  4.708701e-01,  1.344544e+00,  1.283702e-01},
  {-5.182955e-01,  8.494964e-01,  9.861907e-02,  1.063190e-01,  1.347110e+00,  4.906011e-02},
  { 4.149442e-01,  8.697778e-01,  2.670354e-01,  4.027970e-01,  1.404807e+00,  9.417367e-02},
  { 6.516488e-01,  7.459655e-01,  1.374383e-01,  4.501998e-01,  1.366213e+00,  1.144869e-01},
  {-1.786803e-01,  9.827548e-01, -4.760583e-02,  3.511890e-01,  1.422128e+00,  5.123897e-02},
  {-1.349990e-01,  9.865035e-01, -9.266144e-02,  3.509780e-01,  1.419556e+00,  2.015565e-02},
  {-9.999344e-02,  9.904647e-01, -9.476836e-02,  3.527682e-01,  1.421508e+00,  4.074281e-02},
  {-3.194416e-01,  9.214594e-01, -2.210648e-01,  1.638150e-01,  1.369021e+00, -1.074231e-02},
  { 7.704331e-01,  6.374947e-01, -5.777434e-03,  4.749653e-01,  1.349263e+00,  4.263056e-02},
  {-1.938647e-03,  9.846749e-01, -1.743893e-01,  3.571689e-01,  1.416571e+00, -2.973764e-03},
  {-3.141578e-01,  8.902846e-01, -3.296942e-01,  2.091577e-01,  1.372388e+00, -4.906423e-02},
  {-3.204558e-01,  8.870246e-01, -3.324088e-01,  1.989252e-01,  1.368373e+00, -4.935376e-02},
  { 8.152502e-02,  9.190067e-01, -3.857207e-01,  3.703688e-01,  1.393296e+00, -7.515299e-02},
  { 7.711674e-01,  6.175843e-01, -1.545655e-01,  4.633403e-01,  1.348457e+00, -5.685670e-02},
  { 1.009923e-01,  8.778993e-01, -4.680741e-01,  3.851147e-01,  1.377702e+00, -1.040322e-01},
  { 5.158113e-02,  8.575988e-01, -5.117263e-01,  3.765033e-01,  1.371788e+00, -1.156354e-01},
  {-1.090253e-01,  8.757372e-01, -4.703167e-01,  3.167284e-01,  1.373068e+00, -1.116259e-01},
  {-2.195312e-01,  8.559177e-01, -4.681998e-01,  2.900485e-01,  1.368706e+00, -1.096932e-01},
  { 1.355180e-01,  8.486648e-01, -5.112759e-01,  3.935837e-01,  1.358688e+00, -1.349456e-01},
  { 4.856302e-02,  8.207301e-01, -5.692484e-01,  3.873427e-01,  1.351835e+00, -1.456966e-01},
  {-2.002218e-01,  6.230331e-01, -7.561355e-01,  3.347799e-01,  1.335080e+00, -1.666366e-01},
  {-2.662565e-01,  7.272313e-01, -6.326470e-01,  2.811291e-01,  1.333229e+00, -1.549412e-01},
  {-7.875453e-02,  7.789097e-01, -6.221714e-01,  3.931542e-01,  1.347494e+00, -1.516016e-01},
  {-2.284428e-02,  6.717666e-01, -7.404106e-01,  3.795590e-01,  1.315021e+00, -1.875478e-01},
  { 4.620903e-01,  5.894051e-01, -6.626267e-01,  4.333422e-01,  1.318206e+00, -1.674634e-01},
  {-6.480876e-04,  8.502086e-01,  5.264454e-01,  3.612406e-01,  1.297829e+00,  3.439228e-01},
  { 4.710668e-02,  8.881723e-01,  4.570898e-01,  3.668007e-01,  1.303957e+00,  3.330298e-01},
  { 2.172105e-02,  8.818147e-01,  4.710957e-01,  3.537031e-01,  1.309256e+00,  3.227629e-01},
  { 8.162005e-01,  5.362512e-01,  2.150615e-01,  4.723631e-01,  1.338658e+00,  1.430563e-01},
  { 7.524168e-01,  6.075187e-01,  2.545389e-01,  4.626627e-01,  1.346312e+00,  1.525047e-01},
  { 6.780925e-01,  7.094381e-01,  1.920630e-01,  4.643649e-01,  1.349312e+00,  1.387587e-01},
  {-6.967775e-02,  9.944389e-01,  7.896920e-02,  3.531959e-01,  1.422440e+00,  6.111515e-02},
  { 6.613149e-01,  7.476082e-01,  6.119349e-02,  4.281039e-01,  1.397201e+00,  5.151379e-02},
  { 4.993592e-02,  9.912134e-01, -1.224844e-01,  3.674064e-01,  1.419686e+00,  1.732664e-02},
  {-2.863291e-01,  9.406651e-01, -1.821117e-01,  1.687829e-01,  1.372104e+00, -4.112372e-03},
  { 6.248611e-03,  9.714405e-01, -2.372008e-01,  3.665589e-01,  1.414586e+00, -1.232971e-02},
  { 3.764229e-02,  9.482747e-01, -3.152109e-01,  3.634304e-01,  1.407635e+00, -3.847402e-02},
  {-3.067190e-01,  8.265414e-01, -4.719669e-01,  2.099851e-01,  1.358011e+00, -7.973887e-02},
  { 7.312485e-01,  6.527704e-01, -1.979051e-01,  4.531093e-01,  1.352572e+00, -8.549127e-02},
  { 7.196569e-01,  6.472847e-01, -2.512297e-01,  4.565372e-01,  1.343200e+00, -1.016385e-01},
  { 6.400601e-01,  6.640036e-01, -3.865518e-01,  4.483410e-01,  1.341389e+00, -1.237460e-01},
  {-2.758039e-01,  5.936235e-01, -7.560050e-01,  3.236694e-01,  1.340618e+00, -1.579215e-01},
  { 2.420893e-01,  8.069404e-01, -5.387392e-01,  4.147429e-01,  1.350028e+00, -1.412262e-01},
  { 3.117962e-01,  7.406188e-01, -5.952032e-01,  4.158750e-01,  1.336070e+00, -1.591860e-01},
  { 5.454406e-01,  6.259052e-01, -5.574381e-01,  4.374756e-01,  1.326098e+00, -1.569887e-01},
  { 1.165092e-01,  6.420127e-01, -7.577897e-01,  4.033194e-01,  1.316430e+00, -1.869095e-01},
  { 3.669192e-01,  5.938325e-01, -7.160540e-01,  4.107001e-01,  1.316142e+00, -1.834327e-01},
  { 4.488754e-01,  8.335317e-01,  3.220804e-01,  4.453430e-01,  1.334694e+00,  2.258708e-01},
  { 6.458939e-01,  7.276385e-01,  2.310050e-01,  4.518173e-01,  1.331456e+00,  2.230707e-01},
  { 6.560884e-01,  7.139353e-01,  2.446311e-01,  4.523551e-01,  1.337688e+00,  2.056175e-01},
  { 5.313096e-01,  8.290532e-01,  1.743013e-01,  4.140559e-01,  1.406284e+00,  6.341028e-02},
  { 7.014345e-01,  6.943586e-01, -1.607975e-01,  4.524485e-01,  1.365506e+00, -3.603004e-02},
  { 5.705025e-01,  6.441711e-01, -5.094807e-01,  4.377490e-01,  1.340753e+00, -1.390791e-01},
  { 4.408969e-01,  7.403136e-01, -5.074897e-01,  4.346865e-01,  1.345078e+00, -1.355161e-01},
  { 2.385140e-01,  7.318404e-01, -6.383734e-01,  4.061629e-01,  1.329130e+00, -1.732880e-01},
  {-2.375188e-01,  6.427132e-01, -7.283575e-01,  3.942103e-01,  1.320089e+00, -1.836486e-01},
  { 6.959140e-02,  6.919651e-01, -7.185690e-01,  4.029896e-01,  1.318952e+00, -1.841260e-01},
  { 6.816744e-01,  5.951868e-01,  4.255264e-01,  4.509611e-01,  1.330738e+00,  2.265192e-01},
  { 5.187802e-01,  7.921309e-01,  3.215519e-01,  4.501373e-01,  1.332355e+00,  2.247470e-01},
  { 5.685494e-01,  7.664505e-01,  2.988398e-01,  4.502265e-01,  1.335115e+00,  2.174573e-01},
  { 5.702050e-02,  9.967440e-01, -5.700993e-02,  3.767806e-01,  1.422297e+00,  4.422161e-02},
  { 4.555911e-01,  8.901206e-01, -1.104823e-02,  4.172274e-01,  1.406701e+00,  4.216150e-02},
  { 1.965527e-01,  9.706108e-01, -1.388589e-01,  3.828437e-01,  1.419968e+00,  3.075886e-02},
  { 2.008372e-01,  9.748371e-01, -9.673212e-02,  3.824021e-01,  1.417983e+00,  1.663041e-02},
  { 1.145468e-01,  9.491292e-01, -2.933135e-01,  3.791689e-01,  1.408008e+00, -3.400216e-02},
  { 5.604020e-01,  8.029768e-01, -2.029237e-01,  4.425293e-01,  1.364845e+00, -7.634664e-02},
  { 3.397682e-01,  8.682325e-01, -3.615659e-01,  4.084319e-01,  1.382999e+00, -8.077350e-02},
  { 2.713878e-01,  8.900809e-01, -3.662030e-01,  4.146065e-01,  1.371668e+00, -1.028410e-01},
  { 2.724235e-01,  8.452733e-01, -4.596722e-01,  4.186959e-01,  1.365314e+00, -1.138086e-01},
  {-1.023214e-01,  8.518386e-01, -5.137134e-01,  3.085548e-01,  1.361537e+00, -1.302953e-01},
  {-2.410091e-01,  7.628418e-01, -5.999893e-01,  2.855968e-01,  1.352829e+00, -1.333793e-01},
  {-1.386520e-01,  7.603205e-01, -6.345772e-01,  3.940092e-01,  1.329489e+00, -1.747627e-01},
  { 2.297410e-01,  9.598075e-01,  1.612101e-01,  3.830052e-01,  1.421463e+00,  6.721801e-02},
  { 5.565615e-01,  8.307847e-01, -6.003694e-03,  3.978107e-01,  1.415954e+00,  5.996841e-02},
  { 3.244869e-01,  9.343369e-01, -1.473868e-01,  3.858673e-01,  1.420597e+00,  4.346950e-02},
  { 6.170902e-01,  7.833934e-01, -7.412310e-02,  4.312270e-01,  1.397939e+00,  1.252875e-02},
  { 1.790168e-01,  9.647618e-01, -1.928412e-01,  3.901537e-01,  1.413275e+00, -4.543566e-03},
  { 6.846047e-01,  7.107694e-01, -1.616276e-01,  4.345967e-01,  1.391023e+00, -4.398129e-03},
  { 5.604228e-01,  7.817857e-01, -2.733812e-01,  4.286209e-01,  1.378983e+00, -6.254760e-02},
  { 1.869449e-01,  8.994422e-01, -3.950383e-01,  3.978313e-01,  1.401985e+00, -4.177026e-02},
  { 4.442725e-01,  7.637128e-01, -4.683639e-01,  4.357512e-01,  1.355132e+00, -1.194152e-01},
  {-1.124398e-01,  7.800581e-01, -6.155214e-01,  3.136968e-01,  1.356032e+00, -1.395997e-01},
  { 1.980939e-01,  9.801772e-01,  3.389486e-03,  3.871942e-01,  1.421601e+00,  5.593854e-02},
  { 5.452259e-01,  8.345591e-01, -7.899260e-02,  3.921500e-01,  1.419651e+00,  5.304402e-02},
  { 5.196550e-01,  8.531395e-01, -4.595320e-02,  4.210939e-01,  1.404780e+00,  1.645678e-02},
  { 3.621260e-01,  9.276173e-01, -9.160213e-02,  4.075513e-01,  1.410005e+00,  9.309932e-03},
  { 2.397750e-01,  9.430875e-01, -2.304213e-01,  3.961976e-01,  1.406651e+00, -2.861902e-02},
  { 5.155925e-01,  8.250422e-01, -2.312352e-01,  4.315751e-01,  1.367562e+00, -9.535520e-02},
  { 5.437983e-01,  7.669715e-01, -3.406437e-01,  4.353650e-01,  1.357872e+00, -1.149719e-01},
  { 4.609780e-01,  8.644295e-01, -2.006511e-01,  4.177584e-01,  1.404560e+00, -5.808398e-03},
  { 4.284158e-01,  8.741938e-01, -2.285721e-01,  4.159310e-01,  1.401975e+00, -1.493417e-02},
  { 5.117632e-01,  7.958626e-01, -3.235757e-01,  4.201479e-01,  1.393067e+00, -4.171070e-02},
  { 4.057801e-01,  8.673882e-01, -2.880627e-01,  4.112673e-01,  1.400325e+00, -3.721007e-02},
  { 3.518014e-01, -8.548688e-01, -3.813596e-01,  1.206047e-01, -1.413579e+00, -4.231911e-01},
  { 2.940171e-01, -9.211087e-01, -2.551719e-01,  7.754637e-02, -1.406322e+00, -4.807507e-01},
  { 4.029978e-01, -7.803668e-01, -4.781427e-01,  1.171356e-01, -1.401226e+00, -4.483652e-01},
  { 5.027184e-01, -7.468649e-01, -4.352781e-01,  1.191252e-01, -1.391798e+00, -4.624143e-01},
  { 4.121129e-01, -8.807161e-01, -2.334570e-01,  6.649088e-02, -1.402266e+00, -5.107215e-01},
  { 2.193519e-01, -7.568423e-01, -6.156903e-01,  3.918114e-02, -1.329616e+00, -6.752113e-01},
  { 1.765470e-01, -7.514408e-01, -6.357419e-01,  2.741672e-02, -1.328012e+00, -6.804291e-01},
  { 1.924769e-01, -7.703139e-01, -6.079220e-01,  2.788675e-04, -1.328718e+00, -6.877134e-01},
  { 2.152647e-01, -7.435147e-01, -6.331248e-01, -1.247364e-02, -1.320700e+00, -7.017835e-01},
  { 2.101372e-01, -6.735824e-01, -7.086106e-01, -3.643160e-02, -1.319291e+00, -7.128512e-01},
  { 9.114786e-01, -2.656520e-01,  3.140634e-01,  2.003157e-01, -1.317880e+00, -2.813172e-01},
  { 7.606124e-01, -5.622228e-01, -3.246141e-01,  1.205325e-01, -1.309525e+00, -5.915954e-01},
  { 9.068291e-01, -2.333736e-01, -3.509953e-01,  1.315185e-01, -1.257397e+00, -6.398252e-01},
  { 8.741890e-01, -2.077200e-01, -4.389145e-01,  1.401020e-01, -1.237706e+00, -6.321135e-01},
  { 8.709689e-01, -1.838796e-01, -4.556331e-01,  1.460281e-01, -1.221442e+00, -6.279447e-01},
  { 8.688059e-01, -1.695918e-01, -4.652041e-01,  1.554489e-01, -1.205627e+00, -6.160879e-01},
  { 4.154125e-01, -8.947894e-01,  1.636596e-01,  9.567581e-02, -1.148851e+00,  7.802213e-02},
  { 7.346253e-01, -6.781321e-01,  2.150899e-02,  2.204016e-01, -1.069039e+00,  1.799139e-01},
  { 2.468797e-01, -8.678896e-01,  4.310662e-01,  1.414417e-01, -1.080393e+00,  2.871712e-01},
  { 4.534946e-01, -7.804412e-01,  4.304118e-01,  1.743610e-01, -1.087706e+00,  2.540027e-01},
  { 6.628683e-01, -6.450754e-01,  3.801095e-01,  1.761105e-01, -1.080123e+00,  2.623520e-01},
  { 9.953671e-01,  8.314178e-02, -4.828777e-02,  2.075043e-01, -1.055035e+00, -4.228335e-01},
  { 3.037010e-01, -6.464367e-01,  6.999181e-01,  2.018682e-01, -8.665133e-01,  5.053835e-01},
  {-3.676979e-01, -3.844337e-01,  8.467638e-01,  2.018516e-02, -5.884439e-01,  7.240494e-01},
  {-3.944528e-01, -3.400515e-01,  8.536814e-01, -4.012135e-02, -5.517853e-01,  7.094271e-01},
  {-3.329919e-01, -4.792121e-01,  8.120790e-01,  6.231692e-02, -6.223091e-01,  7.237900e-01},
  { 8.228580e-01, -1.923108e-01, -5.347161e-01,  1.483214e-01, -2.156442e-01, -4.113451e-01},
  {-5.051391e-01, -4.972720e-02, -8.616041e-01, -3.780701e-01, -8.692764e-02, -7.448014e-01},
  {-8.152275e-01,  2.344677e-01,  5.295554e-01, -4.032143e-01, -2.592553e-01,  4.058207e-01},
  {-8.382499e-01,  2.293039e-01,  4.947290e-01, -4.125847e-01, -2.488869e-01,  3.860629e-01},
  { 9.738221e-01, -1.981803e-01,  1.113328e-01,  4.341635e-01, -1.027099e-01,  4.562707e-01},
  {-9.544288e-01,  2.226491e-01,  1.987286e-01, -5.075135e-01, -1.003320e-01, -3.312282e-01},
  { 5.968556e-01, -1.503794e-01,  7.881303e-01,  3.516528e-01,  1.117306e-01,  8.331438e-01},
  { 5.850024e-01, -4.037311e-02,  8.100260e-01,  3.656098e-01,  2.135468e-01,  8.293039e-01},
  { 5.527608e-01, -6.597640e-02,  8.307242e-01,  3.674231e-01,  2.395925e-01,  8.297647e-01},
  { 6.516342e-01, -5.199283e-02,  7.567493e-01,  3.753319e-01,  2.314550e-01,  8.224958e-01},
  { 9.458317e-01, -1.031373e-01, -3.078398e-01,  6.418242e-02,  1.991672e-01, -7.098323e-01},
  {-1.117858e-01,  9.584116e-01, -2.625857e-01, -1.254832e-02,  3.864312e-01, -4.280911e-01},
  {-1.248295e-02,  9.352458e-01, -3.537789e-01,  7.246579e-03,  3.835896e-01, -4.482812e-01},
  { 2.020430e-01,  9.633477e-01,  1.764649e-01, -5.483769e-02,  3.860072e-01, -4.336186e-01},
  { 5.909846e-01,  8.006318e-01,  9.862040e-02, -2.385976e-03,  3.823787e-01, -4.995356e-01},
  { 4.582155e-01,  8.493605e-01,  2.619642e-01, -1.237725e-02,  3.876563e-01, -4.958223e-01},
  { 9.072694e-01,  3.971451e-01, -1.383396e-01,  1.114406e-03,  4.530510e-01, -7.597298e-01},
  {-2.496528e-01,  8.739406e-01,  4.170147e-01, -2.210139e-01,  4.234928e-01, -4.861942e-01},
  {-2.533506e-01,  9.151574e-01,  3.135290e-01, -2.140649e-01,  4.279051e-01, -4.943762e-01},
  {-1.379892e-01,  9.538096e-01,  2.668447e-01, -2.056764e-01,  4.324878e-01, -5.001112e-01},
  {-6.802842e-01,  4.187791e-01,  6.015293e-01,  2.334610e-03,  9.603940e-01,  4.543884e-01},
  { 2.356369e-01,  7.552921e-01,  6.115629e-01,  3.894366e-01,  1.187238e+00,  4.775161e-01},
  { 3.383134e-01,  7.215711e-01,  6.040522e-01,  4.010062e-01,  1.194914e+00,  4.626607e-01},
  { 3.841535e-01,  6.860310e-01,  6.178897e-01,  3.917086e-01,  1.217520e+00,  4.416913e-01},
  { 2.368061e-01,  6.549719e-01,  7.175895e-01,  3.914164e-01,  1.232851e+00,  4.274363e-01},
  {-5.464994e-01,  8.065590e-01,  2.253907e-01,  8.618446e-02,  1.313504e+00,  1.195633e-01},
  { 1.538975e-01,  7.802393e-01,  6.062525e-01,  3.675902e-01,  1.265960e+00,  3.848161e-01},
  {-2.165865e-01,  8.206246e-01, -5.288342e-01,  1.293970e-01,  1.331707e+00, -6.555917e-02},
  {-3.556720e-01,  8.139263e-01, -4.593706e-01,  1.651296e-01,  1.343142e+00, -7.411624e-02},
  {-6.688905e-01, -7.333857e-01,  1.213712e-01, -2.909829e-01, -1.021995e+00,  5.426713e-02},
};

static GLushort inflatedsurf_indices[][3] =
{
  {   1,    0,    5},
  {  19, 5862,    6},
  {   3,   29,    2},
  {   3,    4,   29},
  {   0,    4,    3},
  {   3,    2,    5},
  {   3,    5,    0},
  {   5,    6,    1},
  {   7,   10,   13},
  {  16,   13,   10},
  {   4,    0,    1},
  {   4,    1,    8},
  {  16,   10,    9},
  {  21,    9,   22},
  {   7,   34,   10},
  {  22,    9,   36},
  {   9,   10,   36},
  {  11,    2,   26},
  {  11,   26,   44},
  {  11,   28,    2},
  {  26,    2,   29},
  {   2,   28,    5},
  {  15,   12,    4},
  {  32,   14,   31},
  {  50,    6,    5},
  {  13,   14,   17},
  {  13,   17,    7},
  {   4,    8,   15},
  {  19,    6,   50},
  {  16,    9,   21},
  {  18,   17,   14},
  {  15,    8,   20},
  {   7,   17,   34},
  {  11,   25,   24},
  {  43,   11,   24},
  {  44,   25,   11},
  {  11,   43,   28},
  {  29,   12,   27},
  {   4,   12,   29},
  {  30,    5,   28},
  {  12,   15,   49},
  {  31,   14,   13},
  {  47,   32,   31},
  {  52,   16,   21},
  {  32,   18,   14},
  {  18,   34,   17},
  {  36,   53,   37},
  {  38,   39,   24},
  {  38,   24,   87},
  {  39,   90,   24},
  {  41,   60,   42},
  {  60,   40,   42},
  {  24,   25,   89},
  {  24,   90,   43},
  {  41,   42,   61},
  {  25,   92,   89},
  {  92,   25,   44},
  {  29,   44,   26},
  {  45,   49,   68},
  {  47,   46,   48},
  {  48,   46,   96},
  {   5,   30,   98},
  {   5,   98,   50},
  {  47,   48,   32},
  {  15,   20,   49},
  {  49,   20,   70},
  {  13,   51,   31},
  {  32,   48,   79},
  {  48,   74,   79},
  {  20,   77,   70},
  {  33,   50,   71},
  {  33,   71, 5863},
  {  52, 5863,   73},
  {  51,   13,   16},
  {  32,   79,   18},
  {  34,   18,   54},
  {  20,   35,   77},
  {  78,   77,   35},
  {  53,   10,   34},
  {  34,   54,   53},
  {  18,   79,   54},
  {  10,   53,   36},
  {  53,   54,   37},
  {  54,   56,   37},
  {  56,   54,   55},
  {  38,   59,   58},
  {  59,   38,   87},
  {  85,   39,   38},
  {  38,   83,   85},
  {  90,   39,   85},
  {  42,   40,   62},
  {  40,  111,   62},
  {  93,   42,   62},
  {  61,   42,   63},
  {  43,   90,   64},
  {  93,   63,   42},
  {  93,   44,   29},
  {  28,   43,   66},
  {  43,   64,   66},
  {  45,   68,   65},
  {  28,   66,   97},
  {  28,   97,   30},
  {  30,   97,   98},
  {  96,   67,   69},
  {  16,  120,   51},
  {  48,   96,   69},
  {  48,   69,   74},
  {  50,   98,   71},
  {  71,   72, 5863},
  {  52,   73,   16},
  {  31,   51,   76},
  {  31,   76,   47},
  {5863,   72,   75},
  {  73, 5863,   75},
  { 129,   79,   74},
  {  80,   57,   37},
  {  37,  104,   80},
  { 106,   55,   54},
  {  54,   79,  106},
  { 165,   37,   56},
  {  55,  106,   56},
  { 108,   81,   82},
  {  81,   59,   82},
  {  81,   58,   59},
  {  58,   81,  139},
  {  58,  139,   83},
  {  58,   83,   38},
  {  59,   87,  110},
  {  84,   60,   86},
  {  84,  111,   60},
  {  60,  111,   40},
  {  86,   60,   41},
  {  86,   41,  113},
  { 112,   87,   24},
  { 113,   41,   61},
  {  88,   62,  111},
  { 111,  115,   88},
  {  24,   89,  112},
  {  62,   88,   93},
  {  91,  150,   61},
  {  61,   63,   91},
  {  91,   63,   94},
  {  44,   93,   92},
  {  65,   94,   63},
  {  94,   65,   95},
  {  95,   65,   68},
  {  95,   68,  121},
  {  67,   99,   69},
  {  68,   49,  121},
  {  46,   47,  122},
  {  69,   99,  100},
  { 159,  100,   99},
  { 121,   49,   70},
  {  71,  161,   72},
  {  75,   72,  161},
  {  71,   97,  161},
  {  75,  161,   73},
  {  73,  161,   16},
  {  47,   76,  122},
  { 121,   70,  101},
  {  77,  101,   70},
  {5865,  103,  124},
  {5866,   80,  103},
  {  77,   78,  101},
  { 106,   79,  129},
  { 104,   37,  165},
  { 133,  107,  135},
  { 108,   82,  138},
  {  82,  110,  138},
  {  82,   59,  110},
  { 140,   85,   83},
  { 109,   84,  142},
  { 109,  142,  143},
  {  87,  141,  110},
  {  84,   86,  142},
  { 113,  142,   86},
  {  87,  112,  141},
  { 111,  146,  115},
  {  88,  115,   93},
  { 150,  148,   61},
  {  61,  148,  113},
  { 115,   92,   93},
  { 115,   89,   92},
  { 150,   91,   94},
  { 154,  150,   94},
  { 152,   64,   90},
  { 116,  118,  151},
  { 116,  117,  118},
  {  66,   64,  153},
  {  94,   95,  157},
  {  94,  157,  154},
  { 153,  186,   66},
  {  66,  186,   97},
  {  96,  119,   67},
  {  67,  159,   99},
  {  71,   98,   97},
  {  96,  188,  119},
  { 100,  159,  126},
  { 159,  123,  126},
  { 128,   51,  120},
  { 128,  122,   76},
  {  69,  100,  126},
  {  78,  102,  160},
  { 102, 5865,  124},
  { 102,  124,  160},
  { 129,   74,   69},
  { 129,   69,  229},
  { 101,  127,  121},
  { 101,   78,  127},
  { 124,  103,  125},
  { 103,   80,  193},
  { 103,  193,  125},
  {  51,  128,   76},
  {  80,  104,  193},
  { 163,  126,  105},
  { 126,  123,  105},
  { 164,  105,  123},
  { 105,  130,  163},
  { 105,  164,  195},
  { 105,  195,  130},
  { 129,  196,  106},
  {  56,  106,  165},
  { 130,  195,  131},
  { 167,  131,  195},
  { 134, 5867,  133},
  { 131,  167,  132},
  { 136, 5867,  134},
  {5867,  200,  171},
  { 108,  137,  173},
  { 137,  108,  174},
  { 108,  173,   81},
  { 211,   81,  173},
  {  81,  211,  212},
  {  81,  212,  139},
  { 175,  174,  108},
  { 108,  138,  175},
  { 138,  110,  176},
  { 110,  213,  176},
  { 110,  215,  213},
  { 110,  141,  215},
  { 144,   90,   85},
  { 141,  112,  217},
  { 145,  243,  114},
  { 218,  114,  243},
  { 111,  178,  146},
  { 146,  178,  115},
  { 112,   89,  147},
  { 112,  147,  217},
  {  90,  144,  180},
  { 219,  145,  114},
  {  89,  115,  147},
  { 149,  219,  114},
  { 152,   90,  180},
  { 116,  151,  150},
  { 117,  150,  154},
  { 150,  117,  116},
  { 152,  153,   64},
  { 182,  224,  149},
  { 151,  155,  183},
  { 156,  117,  154},
  { 118,  117,  156},
  { 151,  118,  155},
  { 154,  157,  156},
  { 118,  156,  155},
  { 157,   95,  158},
  { 157,  158,  156},
  { 155,  156,  185},
  { 119,  159,   67},
  { 160,  156,  158},
  { 156,  160,  185},
  {  16,  161,  120},
  {  96,   46,  188},
  {  95,  121,  158},
  { 158,  121,  160},
  { 187,  161,   97},
  { 122,  190,   46},
  { 188,   46,  190},
  { 122,  128,  190},
  { 159,  189,  123},
  { 120,  162,  128},
  { 121,  127,  160},
  { 127,   78,  160},
  { 163,  229,   69},
  {  69,  126,  163},
  { 123,  192,  164},
  { 196,  129,  257},
  { 104,  165,  256},
  { 163,  130,  229},
  { 166,  229,  130},
  { 230,  256,  165},
  { 130,  131,  166},
  { 135,  230,  165},
  { 165,  106,  196},
  { 165,  196,  197},
  { 195,  231,  167},
  { 135,  165,  133},
  { 165,  197,  133},
  { 131,  132,  263},
  { 131,  263,  166},
  { 133,  197,  136},
  { 133,  136,  134},
  { 132,  167,  170},
  { 168,  263,  132},
  { 170,  167,  268},
  { 107,  202,  135},
  { 201,  200,  169},
  { 170,  168,  132},
  { 204, 5867,  171},
  { 137,  172,  173},
  { 138,  241,  175},
  { 139,  140,   83},
  { 176,  241,  138},
  { 140,  243,  145},
  { 145,   85,  140},
  {  84,  214,  111},
  { 215,  141,  217},
  { 111,  214,  245},
  { 144,   85,  177},
  {  85,  145,  177},
  { 143,  142,  179},
  { 113,  179,  142},
  { 111,  245,  178},
  { 145,  180,  177},
  { 114,  218,  149},
  { 179,  113,  148},
  { 178,  217,  115},
  { 115,  217,  147},
  { 144,  177,  180},
  { 145,  219,  180},
  { 148,  220,  179},
  { 151,  220,  150},
  { 220,  151,  181},
  { 148,  150,  220},
  { 151,  183,  181},
  { 181,  183,  223},
  { 181,  223,  221},
  { 219,  149,  224},
  { 155,  184,  183},
  { 155,  185,  184},
  { 184,  185,  183},
  { 253,  183,  185},
  { 292,  120,  161},
  { 253,  185,  160},
  { 187,   97,  186},
  { 187,  292,  161},
  { 119,  188,  191},
  { 119,  191,  159},
  { 159,  191,  189},
  { 124,  125,  253},
  { 193,  253,  125},
  { 128,  227,  190},
  { 194,  195,  164},
  { 194,  164,  192},
  { 193,  104,  228},
  { 104,  256,  228},
  { 167,  231,  233},
  { 232,  136,  197},
  { 199,  265,  198},
  { 170,  205,  168},
  { 168,  205,  263},
  { 199,  203,  270},
  { 199,  270,  265},
  { 107, 5867,  204},
  { 107,  204,  202},
  { 170,  271,  205},
  { 209,  210,  172},
  { 172,  286,  209},
  { 172,  210,  173},
  { 137,  239,  172},
  { 137,  174,  239},
  { 174,  175,  239},
  { 139,  243,  140},
  { 213,  215,  216},
  { 179,  246,  143},
  { 245,  215,  178},
  { 217,  178,  215},
  { 180,  219,  324},
  { 179,  220,  246},
  { 220,  181,  247},
  { 218,  290,  149},
  { 149,  250,  182},
  { 153,  152,  292},
  { 180,  292,  152},
  { 223,  222,  221},
  { 219,  224,  293},
  { 153,  292,  186},
  { 186,  292,  187},
  { 162,  120,  292},
  { 192,  123,  189},
  { 189,  225,  192},
  { 192,  225,  194},
  { 160,  124,  253},
  { 188,  296,  191},
  { 194,  225,  252},
  { 193,  226,  253},
  { 227,  128,  162},
  { 229,  257,  129},
  { 195,  194,  255},
  { 195,  255,  231},
  { 196,  257,  197},
  { 264,  233,  231},
  { 135,  262,  230},
  { 198,  258,  199},
  { 203,  199,  258},
  { 262,  135,  202},
  { 200,  201,  266},
  { 259,  266,  201},
  { 201,  269,  259},
  { 167,  233,  268},
  { 200,  266,  171},
  { 232,  235, 5870},
  { 203,  272,  270},
  { 203,  234,  272},
  { 263,  205,  206},
  { 263,  206,  235},
  { 271,  170,  268},
  { 339,  269, 5871},
  { 205,  235,  206},
  { 235,  207, 5871},
  { 235,  205,  207},
  { 236,  205,  278},
  { 207,  205,  236},
  { 208,  207,  236},
  { 208,  236,  345},
  { 173,  210,  237},
  { 279,  285,  237},
  { 173,  237,  240},
  { 173,  240,  211},
  { 320,  211,  240},
  { 240,  287,  320},
  { 211,  320,  212},
  { 176,  213,  242},
  { 176,  242,  241},
  { 212,  244,  139},
  {5872,  143,  246},
  { 242,  213,  245},
  { 213,  216,  245},
  { 243,  139,  244},
  { 215,  245,  216},
  { 218,  243,  290},
  { 246,  220,  247},
  { 181,  221,  321},
  { 221,  392,  321},
  { 221,  249,  392},
  { 291,  149,  248},
  { 250,  149,  291},
  { 221,  222,  249},
  { 325,  182,  250},
  { 253,  222,  223},
  { 222,  253,  249},
  { 430,  249,  253},
  { 326,  224,  182},
  { 325,  251,  182},
  { 182,  251,  326},
  { 223,  183,  253},
  { 292,  293,  162},
  { 189,  361,  225},
  { 296,  188,  190},
  { 190,  227,  296},
  { 253,  226,  254},
  { 253,  254,  333},
  { 226,  193,  254},
  { 228,  254,  193},
  { 254,  228,  298},
  { 297,  255,  194},
  { 229,  166,  257},
  { 256,  230,  299},
  { 257,  166,  267},
  { 258,  262,  261},
  { 197,  257,  232},
  { 231,  300,  264},
  { 258,  261,  203},
  { 166,  263,  267},
  { 257,  267,  232},
  { 260,  265,  301},
  { 203,  261,  234},
  { 232,  267,  263},
  { 233,  369,  268},
  { 262,  202,  261},
  { 266,  302,  171},
  { 232,  263,  235},
  { 202,  204,  303},
  { 202,  303,  261},
  { 171,  302,  204},
  { 271,  268,  340},
  { 306,  303,  204},
  { 234,  273,  272},
  { 275,  273,  274},
  { 309,  306,  204},
  { 205,  271,  276},
  { 273,  275,  272},
  { 339, 5871,  307},
  { 345,  307, 5871},
  { 205,  276,  277},
  { 205,  277,  278},
  {5871,  208,  345},
  { 279,  281,  283},
  { 238,  284,  281},
  { 282,  280,  209},
  { 283,  285,  279},
  { 281,  284,  283},
  { 209,  286,  282},
  { 172,  239,  286},
  { 239,  175,  312},
  { 175,  241,  312},
  { 352,  312,  241},
  { 214,  242,  245},
  { 214,  318,  242},
  { 244,  320,  243},
  { 246,  247,  356},
  { 247,  181,  356},
  { 243,  354,  290},
  { 393,  290,  354},
  { 248,  149,  322},
  { 149,  290,  322},
  { 392,  249,  323},
  { 324,  219,  293},
  { 248,  322,  291},
  { 250,  291,  325},
  { 224,  328,  293},
  { 326,  328,  224},
  { 361,  295,  252},
  { 361,  252,  225},
  { 296,  294,  191},
  { 191,  294,  361},
  { 191,  361,  189},
  { 194,  252,  295},
  { 296,  227,  328},
  { 298,  333,  254},
  { 363,  255,  297},
  { 299,  298,  228},
  { 228,  256,  299},
  { 255,  363,  334},
  { 298,  299,  262},
  { 333,  198, 5874},
  { 333,  258,  198},
  { 299,  230,  262},
  { 255,  334,  300},
  { 255,  300,  231},
  { 337, 5876, 5875},
  { 366,  259,  269},
  { 336,  264,  300},
  { 260,  301,  337},
  { 259,  338,  266},
  { 269,  339,  366},
  { 233,  264,  369},
  { 265,  305,  301},
  { 261,  274,  234},
  { 265,  270,  305},
  { 303,  274,  261},
  { 270,  272,  305},
  { 234,  274,  273},
  { 274,  303,  344},
  { 304,  204,  302},
  { 305,  272,  275},
  { 274,  344,  275},
  { 306,  309,  308},
  { 204,  304,  309},
  { 276,  271,  340},
  { 275,  344,  305},
  { 378,  278,  277},
  { 378,  277,  276},
  { 278,  345,  236},
  { 311,  279,  280},
  { 310,  279,  311},
  { 279,  238,  281},
  { 282,  381,  280},
  { 422,  280,  381},
  { 280,  422,  311},
  { 282,  286,  464},
  { 283,  284,  351},
  { 237,  285,  350},
  { 350,  240,  237},
  { 285,  283,  350},
  { 240,  350,  287},
  { 387,  287,  350},
  { 241,  318,  352},
  { 287,  387,  320},
  { 313,  314,  780},
  { 288,  317,  353},
  { 313,  315,  314},
  { 313,  316,  315},
  { 241,  242,  318},
  { 313,  319,  316},
  { 244,  212,  320},
  { 181,  321,  356},
  { 393,  322,  290},
  { 180,  324,  292},
  { 322,  394,  291},
  { 291,  394,  325},
  { 430,  323,  249},
  { 324,  293,  292},
  { 253,  360,  430},
  { 293,  328,  162},
  { 162,  328,  227},
  { 295,  361,  329},
  { 295,  329,  194},
  { 331,  330,  327},
  { 297,  194,  363},
  { 329,  363,  194},
  { 331,  332, 5874},
  { 332,  333, 5874},
  { 363,  364,  334},
  { 334,  364,  300},
  { 300,  364,  336},
  {5876,  337,  365},
  {5876,  365, 5877},
  { 338,  259,  335},
  { 369,  264,  370},
  { 337,  301,  441},
  { 369,  372,  268},
  { 301,  305,  405},
  { 301,  405,  441},
  { 268,  372,  340},
  { 367,  304,  302},
  { 367,  302,  266},
  { 306,  344,  303},
  { 304,  375,  309},
  { 376,  341,  369},
  { 369,  342,  376},
  { 308,  344,  306},
  { 378,  371,  307},
  { 305,  344,  374},
  { 343,  378,  276},
  { 307,  345,  378},
  { 378,  345,  278},
  { 347,  346,  414},
  { 416,  348, 5878},
  { 381,  282,  380},
  { 311,  422,  310},
  { 310,  422,  349},
  { 310,  349,  279},
  { 282,  464,  380},
  { 284,  238,  351},
  { 286,  239,  312},
  { 286,  312,  464},
  { 385,  351,  238},
  { 388,  389,  353},
  { 314,  315,  316},
  { 314,  316,  466},
  { 313,  780,  319},
  { 353,  317,  391},
  { 289,  427,  318},
  { 318,  427,  352},
  { 316,  319,  466},
  { 780,  390,  319},
  { 355,  319,  390},
  { 320,  354,  243},
  { 391,  317,  246},
  { 321,  428,  356},
  { 246,  356,  505},
  { 392,  323,  357},
  { 322,  393,  506},
  { 323,  430,  357},
  { 430,  469,  357},
  { 358,  327,  429},
  { 358,  359,  327},
  { 327,  395,  429},
  { 361,  431,  329},
  { 327,  362,  331},
  { 332,  362,  360},
  { 332,  360,  333},
  { 360,  253,  333},
  { 431,  363,  329},
  { 332,  331,  362},
  { 335,  259,  366},
  { 335,  366,  437},
  { 338,  335,  437},
  { 364,  397,  336},
  { 399,  365,  337},
  { 338,  437,  368},
  { 336,  440,  400},
  { 398,  337,  441},
  { 399,  337,  398},
  { 368,  367,  266},
  { 368,  266,  338},
  { 366,  339,  402},
  { 369,  370,  342},
  { 373,  375,  367},
  { 367,  375,  304},
  { 371,  402,  339},
  { 372,  369,  341},
  { 339,  307,  371},
  { 405,  305,  442},
  { 340,  372,  343},
  { 404,  342,  370},
  { 276,  340,  343},
  { 343,  372,  377},
  { 376,  372,  341},
  { 372,  376,  377},
  { 378,  343,  410},
  { 346,  454,  414},
  { 523,  346,  347},
  { 416, 5878,  489},
  { 348,  416,  490},
  { 347,  379,  523},
  {5878,  348,  458},
  { 422,  425,  349},
  { 382,  349,  425},
  { 349,  382,  279},
  { 383,  279,  382},
  { 384,  279,  383},
  { 279,  384,  238},
  { 383,  382,  425},
  { 351,  350,  283},
  { 350,  386,  387},
  { 386,  350,  351},
  { 386,  351,  387},
  { 427,  289,  389},
  { 391,  388,  353},
  { 505,  391,  246},
  { 356,  428,  505},
  { 506,  393,  354},
  { 394,  322,  506},
  { 358,  468,  359},
  { 430,  359,  468},
  { 430,  360,  362},
  { 328,  294,  296},
  { 362,  327,  359},
  { 359,  430,  362},
  { 327,  330,  395},
  { 363,  435,  364},
  { 363,  432,  435},
  { 436, 5877,  396},
  { 396, 5877,  365},
  { 396,  365,  434},
  { 434,  365,  476},
  { 437,  366,  438},
  { 403,  366,  402},
  { 397,  364,  435},
  { 439,  336,  397},
  { 440,  336,  439},
  { 407,  403,  402},
  { 264,  336,  404},
  { 400,  404,  336},
  { 401,  367,  368},
  { 264,  404,  370},
  { 442,  373,  401},
  { 373,  367,  401},
  { 404,  400,  447},
  { 442,  374,  373},
  { 403,  407,  406},
  { 374,  442,  305},
  { 371,  378,  402},
  { 404,  409,  408},
  { 344,  373,  374},
  { 373,  344,  375},
  { 410,  402,  378},
  { 402,  410,  407},
  { 376,  342,  444},
  { 408,  444,  342},
  { 342,  404,  408},
  { 411,  448,  412},
  { 412,  451,  411},
  { 412,  448,  449},
  { 346,  455,  454},
  { 456,  414,  454},
  { 489,  456,  415},
  { 416,  489,  415},
  { 416,  415,  456},
  { 346,  523,  455},
  { 347,  414,  379},
  { 458,  348,  494},
  { 458,  526,  238},
  { 238,  421,  458},
  { 497,  421,  238},
  { 422,  381,  462},
  { 381,  380,  462},
  { 384,  424,  238},
  { 423,  238,  424},
  { 238,  423,  499},
  { 238,  461,  463},
  { 380,  464,  462},
  { 423,  424,  597},
  { 425,  465,  383},
  { 383,  465,  384},
  { 384,  465,  424},
  { 385,  238,  426},
  { 312,  352,  427},
  { 351,  385,  387},
  { 502,  385,  426},
  { 319,  355,  466},
  { 321,  392,  428},
  { 320,  632,  354},
  { 357,  470,  565},
  { 430,  468,  469},
  { 357,  469,  470},
  { 325,  510,  509},
  { 467,  358,  429},
  { 294,  328,  326},
  { 512,  429,  395},
  { 294,  533,  361},
  { 395,  330,  433},
  { 363,  431,  432},
  { 435,  432,  475},
  { 330,  436,  433},
  { 433,  436,  396},
  { 396,  434,  433},
  { 438,  366,  403},
  { 476,  365,  399},
  { 439,  397,  516},
  { 398,  441,  517},
  { 399,  398,  517},
  { 575,  403,  443},
  { 478,  575,  443},
  { 516,  479,  439},
  { 442,  401,  477},
  { 480,  443,  444},
  { 446,  400,  440},
  { 403,  406,  443},
  { 408,  480,  444},
  { 446,  447,  400},
  { 377,  443,  406},
  { 376,  443,  377},
  { 443,  376,  444},
  { 404,  447,  409},
  { 343,  406,  407},
  { 377,  406,  343},
  { 408,  409,  445},
  { 445,  409,  447},
  { 407,  410,  343},
  { 448,  411,  481},
  { 450,  455,  412},
  { 450,  454,  455},
  { 450,  555,  454},
  { 454,  555,  587},
  { 451,  412,  452},
  { 451,  452,  453},
  { 455,  452,  412},
  { 454,  587,  558},
  { 413,  482,  483},
  { 482,  413,  457},
  { 416,  456,  454},
  { 489,  414,  456},
  { 490,  494,  348},
  {5878,  458,  493},
  { 491,  417,  418},
  { 417,  491, 5879},
  { 417,  492,  418},
  { 525,  491,  418},
  { 379,  419,  459},
  { 591,  459,  419},
  { 461,  238,  526},
  { 421,  524,  458},
  { 495,  420,  528},
  { 524,  421,  460},
  { 497,  460,  421},
  { 238,  499,  497},
  { 528,  420,  314},
  { 423,  597,  499},
  { 463,  461,  598},
  { 422,  529,  425},
  { 463,  500,  238},
  { 238,  500,  426},
  { 426,  500,  502},
  { 502,  387,  385},
  { 427,  389,  464},
  { 464,  312,  427},
  { 388,  501,  462},
  { 388,  462,  389},
  { 388,  503,  501},
  { 388,  391,  503},
  { 390,  600,  355},
  { 428,  392,  504},
  { 392,  357,  504},
  { 394,  506,  507},
  { 468,  467,  469},
  { 325,  508,  510},
  { 467,  468,  358},
  { 251,  533,  326},
  { 429,  471,  467},
  { 429,  511,  471},
  { 429,  512,  511},
  { 512,  395,  472},
  { 533,  569,  361},
  { 395,  433,  472},
  { 472,  433,  473},
  { 433,  434,  473},
  { 473,  434,  514},
  { 431,  640,  432},
  { 475,  432,  474},
  { 640,  474,  432},
  { 539,  434,  476},
  { 437,  438,  518},
  { 438,  403,  518},
  { 397,  435,  475},
  { 476,  399,  517},
  { 518,  403,  575},
  { 477,  401,  541},
  { 401,  368,  541},
  { 439,  479,  440},
  { 441,  405,  477},
  { 442,  477,  405},
  { 447,  446,  445},
  { 448,  481, 5881},
  { 449,  520,  412},
  { 450,  412,  520},
  { 481,  411,  482},
  { 481,  482,  521},
  { 411,  451,  483},
  { 411,  483,  482},
  { 453,  452,  484},
  { 452,  455,  484},
  { 451,  453,  484},
  { 451,  484,  483},
  { 482,  457,  521},
  { 484,  455,  488},
  { 454,  558,  485},
  { 454,  485,  416},
  { 485,  490,  416},
  { 486,  522,  629},
  { 455,  523,  488},
  { 414,  489,  379},
  { 491,  559, 5879},
  { 492,  523,  459},
  { 492,  459,  418},
  { 523,  379,  459},
  { 458,  524,  493},
  { 458,  494,  526},
  { 773,  589,  495},
  { 419,  588,  591},
  { 418,  459,  591},
  { 773,  495,  528},
  { 594,  461,  526},
  { 496,  460,  497},
  { 496,  498,  460},
  { 496,  497,  498},
  { 527,  420,  495},
  { 497,  499,  498},
  { 420,  527,  314},
  { 463,  598,  500},
  { 314,  527,  596},
  { 462,  501,  562},
  { 389,  462,  464},
  { 425,  531,  465},
  { 387,  502,  632},
  { 387,  632,  320},
  { 503,  634,  501},
  { 314,  466,  633},
  { 780,  600,  390},
  { 391,  505,  503},
  { 355,  563,  466},
  { 505,  428,  504},
  { 394,  714,  325},
  { 508,  325,  714},
  { 251,  325,  533},
  { 326,  533,  294},
  { 472,  473,  568},
  { 513,  568,  473},
  { 513,  473,  514},
  { 475,  474,  515},
  { 474,  640,  537},
  { 474,  537,  515},
  { 475,  515,  516},
  { 475,  516,  397},
  { 476,  517,  610},
  { 368,  437,  541},
  { 542,  541,  437},
  { 518,  542,  437},
  { 540,  517,  441},
  { 441,  477,  540},
  { 477,  541,  540},
  { 479,  576,  440},
  { 480,  408,  544},
  { 408,  445,  544},
  { 445,  446,  546},
  { 440,  546,  446},
  { 520,  555,  450},
  { 483,  484,  487},
  { 484,  488,  557},
  { 457,  665,  521},
  { 487,  557,  492},
  { 523,  557,  488},
  { 490,  485,  708},
  { 523,  492,  557},
  { 490,  708,  494},
  { 591,  592,  590},
  { 460,  498,  524},
  { 597,  560,  499},
  { 422,  462,  529},
  { 529,  561,  425},
  { 633,  528,  314},
  { 462,  562,  530},
  { 462,  530,  529},
  { 425,  561,  531},
  { 500,  598,  502},
  { 530,  532,  529},
  { 465,  531,  424},
  { 424,  531,  597},
  { 505,  504,  601},
  { 632,  506,  354},
  { 506,  714,  507},
  { 507,  714,  394},
  { 564,  600,  567},
  { 471,  603,  467},
  { 467,  603,  469},
  { 470, 5883,  602},
  { 325,  509,  533},
  { 469,  603,  470},
  { 471,  511,  604},
  { 472,  511,  512},
  { 568,  604,  511},
  { 511,  472,  568},
  { 568,  513,  534},
  { 361,  569,  431},
  { 513,  514,  570},
  { 641,  536,  535},
  { 537,  640,  538},
  { 514,  434,  539},
  { 538,  573,  515},
  { 515,  537,  538},
  { 515,  573,  516},
  { 440,  648,  543},
  { 578,  519,  542},
  { 542,  518,  578},
  { 480,  478,  443},
  { 519,  578,  580},
  { 544,  445,  546},
  { 440,  543,  546},
  { 545,  549,  548},
  { 549,  616,  548},
  { 549,  550,  616},
  { 551,  552,  624},
  { 551,  624,  553},
  { 551,  553,  584},
  { 556, 5881,  481},
  { 556,  481,  521},
  { 520,  627,  555},
  { 555,  630,  587},
  { 556,  521,  665},
  { 484,  557,  487},
  { 485,  558,  708},
  { 379,  489,  588},
  { 379,  588,  419},
  { 708,  558,  669},
  {5878,  493,  524},
  { 491,  706,  559},
  { 418,  590,  525},
  { 418,  591,  590},
  { 526,  494,  594},
  { 708,  594,  494},
  { 495,  589,  527},
  { 524,  498,  670},
  { 595,  461,  594},
  { 461,  595,  598},
  { 529,  532,  561},
  { 780,  314,  596},
  { 531,  599,  597},
  { 633,  466,  563},
  { 503,  505,  634},
  { 563,  355,  674},
  { 564,  355,  600},
  { 602,  565,  470},
  { 510,  508,  566},
  { 508,  714,  566},
  { 564,  567,  566},
  { 566,  567,  510},
  { 510,  567,  675},
  { 603,  471,  604},
  { 568,  534,  605},
  { 513,  570,  534},
  { 569,  640,  431},
  { 640,  607,  538},
  { 643,  535,  572},
  { 643,  572,  571},
  { 539,  476,  610},
  { 611,  516,  573},
  { 516,  611,  479},
  { 646,  479,  611},
  { 517,  540,  541},
  { 575,  478,  613},
  { 440,  576,  648},
  { 648,  577,  543},
  { 541,  542,  519},
  { 478,  480,  579},
  { 480,  544,  579},
  { 613,  478,  549},
  { 478,  579,  549},
  { 578,  617,  580},
  { 578,  613,  545},
  { 578,  545,  617},
  { 613,  549,  545},
  { 544,  546,  579},
  { 547,  549,  579},
  { 546,  547,  579},
  { 543,  581,  546},
  { 548,  617,  545},
  { 547,  618,  549},
  { 581,  583,  546},
  { 549,  618,  550},
  { 547,  546,  618},
  { 582,  618,  546},
  { 583,  582,  546},
  { 584,  620,  656},
  { 584,  656,  551},
  { 585,  659,  621},
  { 659,  585,  586},
  { 659,  586, 5880},
  { 625, 5880,  586},
  { 558,  587,  631},
  { 665,  457,  559},
  { 489, 5878,  524},
  { 489,  524,  588},
  { 525,  739,  491},
  { 491,  739,  706},
  { 590,  710,  525},
  { 592,  671,  590},
  { 670,  498,  499},
  { 670,  499,  593},
  { 499,  560,  593},
  { 528,  633,  776},
  { 780,  596,  672},
  { 561,  532,  531},
  { 673,  531,  532},
  { 562,  634,  530},
  { 599,  531,  673},
  { 501,  634,  562},
  { 530,  634,  532},
  { 502,  598,  632},
  { 532, 1107,  673},
  { 355,  564,  674},
  { 504,  357,  565},
  { 504,  565,  601},
  { 714,  635,  566},
  { 566,  635,  564},
  { 509,  510,  786},
  { 640,  569,  533},
  { 536,  641,  638},
  { 606,  536,  638},
  { 568,  605,  642},
  { 568,  639,  604},
  { 514,  609,  570},
  { 611,  573,  538},
  { 574,  538,  607},
  { 607,  571,  574},
  { 643,  571,  607},
  { 572,  574,  571},
  { 572,  535,  747},
  { 535,  536,  747},
  { 608,  747,  536},
  { 606,  608,  536},
  { 539,  609,  514},
  { 538,  574,  722},
  { 610,  682,  539},
  { 609,  539,  682},
  { 517,  612,  610},
  { 517,  541,  612},
  { 541,  519,  612},
  { 646,  647,  479},
  { 479,  647,  576},
  { 518,  575,  578},
  { 575,  613,  578},
  { 576,  748,  648},
  { 577,  648,  614},
  { 543,  577,  615},
  { 614,  615,  577},
  { 543,  615,  581},
  { 619,  581,  615},
  { 618,  582,  655},
  { 583,  581,  619},
  { 583,  619,  582},
  { 585,  621,  623},
  { 621,  584,  623},
  { 552,  551,  658},
  { 552,  658,  698},
  { 698,  622,  554},
  { 585,  623,  586},
  { 554,  622,  624},
  { 586,  623,  625},
  { 627,  520,  626},
  {5881,  556,  628},
  { 665,  628,  556},
  { 629,  522,  663},
  { 630,  705,  587},
  { 522,  664,  663},
  { 631,  667,  558},
  { 558,  667,  669},
  { 739,  525,  820},
  { 524,  670,  588},
  { 525,  710,  820},
  { 592,  591,  588},
  { 773,  528,  740},
  { 589,  711,  527},
  { 709,  593,  560},
  { 527,  672,  596},
  { 672,  527,  712},
  { 560,  597,  709},
  { 597,  599,  709},
  { 632,  598,  782},
  { 674,  564,  635},
  { 675,  567,  600},
  { 533,  509,  637},
  { 637,  509,  786},
  { 675,  786,  510},
  { 604,  636,  603},
  { 533,  637,  640},
  { 641,  678,  638},
  { 638,  680,  606},
  { 720,  642,  605},
  { 605,  534,  720},
  { 534,  570,  720},
  { 640,  721,  607},
  { 643,  718,  535},
  { 535,  718,  641},
  { 721,  643,  607},
  { 639,  568,  642},
  { 570,  796,  720},
  { 747,  608,  644},
  { 792,  644,  608},
  { 609,  723,  570},
  { 796,  570,  723},
  { 611,  538,  645},
  { 722,  645,  538},
  { 572,  722,  574},
  { 611,  645,  646},
  { 647,  748,  576},
  { 612,  519,  686},
  { 612,  686,  682},
  { 649,  648,  685},
  { 648,  649,  614},
  { 615,  614,  649},
  { 686,  519,  580},
  { 580,  750,  686},
  { 650,  725,  689},
  { 651,  580,  617},
  { 616,  694,  688},
  { 616,  688,  683},
  { 693,  618,  689},
  { 689,  618,  650},
  { 650,  618,  652},
  { 650,  652,  653},
  { 651,  617,  616},
  { 548,  616,  617},
  { 618,  655,  652},
  { 696,  694,  616},
  { 653,  652,  654},
  { 616,  550,  696},
  { 618,  696,  550},
  { 582,  619,  655},
  { 584,  621,  620},
  { 621,  699,  620},
  { 656,  657,  551},
  { 551,  657,  658},
  { 698,  760,  622},
  { 621,  659,  660},
  { 624,  622,  734},
  { 623,  584,  661},
  { 584,  553,  700},
  { 553,  624,  700},
  { 623,  661,  625},
  { 659,  702,  660},
  { 625,  661,  626},
  { 626,  661,  703},
  { 626,  703,  627},
  { 627,  703,  704},
  { 627,  704,  555},
  { 628,  738,  662},
  { 662,  738,  702},
  { 628,  665,  738},
  { 705,  630, 1013},
  { 587,  705,  631},
  { 666,  665,  559},
  {5917,  629,  668},
  { 629,  857,  668},
  { 666,  559,  706},
  { 671,  710,  590},
  { 593,  709,  670},
  { 711,  712,  527},
  { 776,  740,  528},
  { 779,  598,  595},
  { 599,  673, 1107},
  { 506,  632,  782},
  { 532,  634, 1107},
  { 633,  563,  825},
  { 563,  674,  825},
  { 634,  505,  601},
  {1107,  634,  601},
  { 603,  677,  470},
  { 676,  470,  677},
  { 470,  676, 5883},
  { 678,  716,  638},
  { 717,  638,  715},
  { 677,  603,  636},
  { 676,  679, 5883},
  { 638,  717,  680},
  { 637,  742,  640},
  { 641,  718,  678},
  { 642,  720,  719},
  { 640,  742,  721},
  { 643,  743,  718},
  { 680,  681,  606},
  { 796,  745,  720},
  { 746,  722,  572},
  { 747,  746,  572},
  { 608,  606,  681},
  { 609,  682,  686},
  { 646,  645,  647},
  { 610,  612,  682},
  { 748,  684,  648},
  { 684,  685,  648},
  { 684,  749,  685},
  { 649,  685,  690},
  { 649,  690,  615},
  { 580,  651,  750},
  { 750,  651,  687},
  { 687,  683,  840},
  { 691,  725,  650},
  { 687,  651,  683},
  { 616,  683,  651},
  { 650,  692,  691},
  { 650,  653,  692},
  { 692,  615,  728},
  { 652,  655,  695},
  { 652,  695,  654},
  { 696,  618,  693},
  { 695,  655,  619},
  { 620,  699,  656},
  { 731,  698,  730},
  { 698,  731,  760},
  { 697,  622,  760},
  { 697,  734,  622},
  { 621,  660,  699},
  { 584,  700,  703},
  { 661,  584,  703},
  { 701,  763,  660},
  { 701,  660,  702},
  { 815,  701,  702},
  { 663,  664,  737},
  { 555,  704,  630},
  { 665,  666,  738},
  { 666,  706,  770},
  { 667,  771,  669},
  { 771,  774,  669},
  { 669,  774,  708},
  { 589,  668,  711},
  { 739,  707,  706},
  { 588,  709,  592},
  { 594,  708,  824},
  { 599,  713,  709},
  { 780,  908,  600},
  { 675,  600,  783},
  { 506,  782,  714},
  { 674,  714,  825},
  { 714,  674,  635},
  { 716,  715,  638},
  { 830,  604,  639},
  { 604,  830,  636},
  { 677,  636,  830},
  { 637,  786,  742},
  { 676,  910,  679},
  { 679,  829,  602},
  { 680,  717,  793},
  { 744,  743,  643},
  { 793,  681,  680},
  { 722,  746,  791},
  { 608,  681,  792},
  { 645,  722,  748},
  { 609,  686,  723},
  { 683,  917,  795},
  { 683,  724,  917},
  { 686,  750,  723},
  { 683,  688,  724},
  { 724,  688,  794},
  { 752,  794,  688},
  { 726,  751,  725},
  { 685,  727,  690},
  { 689,  725,  803},
  { 725,  691,  726},
  { 693,  689,  803},
  { 691,  753,  726},
  { 690,  727,  728},
  { 691,  692,  728},
  { 691,  728,  753},
  { 615,  690,  728},
  { 694,  696,  688},
  { 729,  730,  698},
  { 760,  761,  697},
  { 972,  697,  761},
  { 697,  972,  734},
  { 699,  763,  656},
  { 657,  764,  658},
  { 658,  764,  733},
  { 658,  733,  698},
  { 624,  734,  762},
  { 699,  660,  763},
  { 624,  766,  700},
  { 766,  624,  809},
  { 703,  700,  812},
  { 736,  767,  735},
  { 735,  768,  736},
  { 703,  812,  704},
  { 702,  738,  815},
  { 704,  812,  630},
  { 663,  737,  813},
  { 663,  813,  629},
  { 859,  631,  705},
  { 738,  666,  770},
  { 631,  859,  667},
  { 771,  667,  859},
  { 664, 5917,  773},
  { 664,  773,  819},
  { 668,  857,  822},
  { 822,  775,  668},
  { 668,  775,  711},
  { 709,  588,  670},
  { 824,  708,  862},
  { 710,  863,  861},
  { 861,  863,  898},
  { 671,  823,  710},
  { 671,  592,  823},
  { 592,  900,  823},
  { 594,  824,  777},
  { 594,  777,  595},
  { 863,  710,  778},
  { 595,  777,  741},
  { 713,  599, 1107},
  { 715,  785,  784},
  { 785,  715,  716},
  { 717,  715,  784},
  { 716,  678,  787},
  { 639,  788,  830},
  { 718,  787,  678},
  { 743,  787,  718},
  { 793,  717,  789},
  { 639,  912,  788},
  { 719,  720,  790},
  { 643,  721,  744},
  { 721,  742,  744},
  { 790,  720,  833},
  { 745,  833,  720},
  { 832,  911,  745},
  { 644,  792,  747},
  { 645,  748,  647},
  { 917,  724,  794},
  { 749,  836,  685},
  { 723,  750,  840},
  { 727,  685,  798},
  { 727,  798,  802},
  { 840,  750,  687},
  { 920,  799,  683},
  { 752,  837,  794},
  { 753,  797,  726},
  { 727,  802,  753},
  { 696,  752,  688},
  { 800,  752,  696},
  { 843,  800,  696},
  { 728,  727,  753},
  { 696,  693,  803},
  { 696,  803,  843},
  { 755,  804,  754},
  { 755,  847,  804},
  { 758,  804,  847},
  { 757,  756,  848},
  { 759,  756,  757},
  { 804,  758,  730},
  { 804,  730,  732},
  { 758,  731,  730},
  { 971,  731,  758},
  { 732,  730,  729},
  { 732,  729,  698},
  { 731,  971,  760},
  { 761,  971,  972},
  { 760,  971,  761},
  { 656,  806,  657},
  { 807,  732,  698},
  { 849,  762,  734},
  { 805,  849,  734},
  { 734,  972,  805},
  { 657,  806,  764},
  { 733,  765,  698},
  { 698,  765,  807},
  { 735,  808,  768},
  { 811,  853,  763},
  { 811,  763,  701},
  { 701,  815,  811},
  { 737,  769,  813},
  { 859,  705, 1013},
  { 813,  769,  939},
  { 629,  816,  857},
  { 818,  664,  819},
  { 861,  820,  710},
  { 707,  739,  821},
  { 707,  821,  706},
  { 772,  706,  821},
  { 712,  711,  775},
  { 710,  900,  778},
  { 713,  864,  709},
  { 712,  902,  672},
  { 595,  866,  779},
  { 776,  633,  865},
  { 904,  779,  866},
  { 782,  598,  779},
  { 783,  826,  675},
  { 675,  826,  785},
  { 602,  829, 1137},
  { 787,  785,  716},
  { 742,  786,  744},
  { 831,  789,  717},
  { 719,  790,  642},
  { 747,  792,  872},
  { 639,  642,  912},
  { 642,  790,  912},
  { 722,  791,  748},
  { 745,  796,  834},
  { 748,  791,  684},
  { 791,  749,  684},
  { 837,  916,  794},
  { 749,  835,  836},
  { 723,  840,  796},
  { 751,  726,  838},
  { 797,  838,  726},
  { 836,  798,  685},
  { 683,  795,  920},
  { 751,  838,  725},
  { 801,  839,  797},
  { 840,  683,  799},
  { 797,  753,  801},
  { 752,  800,  837},
  { 801,  753,  802},
  { 758,  847,  971},
  { 878,  848,  756},
  { 804,  732,  880},
  { 805,  972,  849},
  { 732,  807,  880},
  { 656,  763,  806},
  { 853,  806,  763},
  { 733,  882,  765},
  { 807,  765,  882},
  { 624,  762,  809},
  { 808,  735,  852},
  { 735,  810,  852},
  { 700,  766,  812},
  { 767,  810,  735},
  { 767,  736,  810},
  { 736,  768,  888},
  { 812,  854,  630},
  { 630,  854,  817},
  { 629,  813,  816},
  { 813, 1010,  816},
  { 630,  817, 1013},
  { 664,  818,  856},
  { 664,  856,  737},
  { 860,  891,  815},
  { 818,  892,  856},
  { 770,  815,  738},
  { 815,  770,  860},
  { 770,  706,  860},
  { 893,  860,  706},
  { 706,  772,  893},
  { 857,  897,  822},
  { 739,  894,  821},
  { 773,  740,  819},
  { 899,  898,  863},
  { 776,  865,  943},
  { 777,  824,  741},
  { 741,  866,  595},
  { 863,  778,  903},
  { 780,  672,  902},
  { 778,  900,  903},
  { 906,  713, 1107},
  { 782,  907,  714},
  { 600,  908,  783},
  { 785,  826,  784},
  { 827,  784,  826},
  { 675,  785,  828},
  { 675,  828,  786},
  { 717,  784,  827},
  { 786,  828,  743},
  { 828,  785,  787},
  { 787,  743,  828},
  { 677,  830,  910},
  { 677,  910,  676},
  { 786,  743,  744},
  { 827,  831,  717},
  { 788,  912,  869},
  { 833,  871,  790},
  { 872,  746,  747},
  { 832,  745,  913},
  { 834,  913,  745},
  { 793,  915,  681},
  { 749,  791,  835},
  { 792,  681,  873},
  { 915,  873,  681},
  { 918,  834,  796},
  { 917,  794,  916},
  { 838,  797,  839},
  { 838,  839,  874},
  { 802,  798,  836},
  { 801,  875,  839},
  { 924,  802,  919},
  { 799,  918,  841},
  { 799,  920,  918},
  { 837,  800,  843},
  { 725,  838,  842},
  { 725,  842,  803},
  { 842,  838,  844},
  { 838,  876,  844},
  { 844,  843,  842},
  { 803,  842,  843},
  { 755, 1038,  847},
  { 848,  846,  757},
  { 928,  757,  846},
  { 804,  926,  754},
  { 757,  928,  759},
  { 878,  929,  848},
  { 759,  928,  879},
  { 759,  879,  881},
  { 759,  881,  756},
  { 762,  849,  930},
  { 879,  808,  850},
  { 879,  850,  881},
  { 806,  853,  851},
  { 806,  851,  764},
  { 764,  882,  733},
  { 882,  880,  807},
  { 809,  762,  930},
  { 808,  852,  884},
  { 808,  884,  850},
  { 766,  809,  931},
  { 888,  808,  883},
  { 768,  808,  888},
  { 886,  812,  766},
  { 766,  931,  886},
  { 812,  886,  854},
  { 889,  811,  815},
  { 736,  888,  814},
  { 814,  888,  855},
  { 737,  858,  769},
  { 813,  939, 1010},
  { 737,  856,  858},
  { 891,  860,  893},
  { 858,  939,  769},
  { 940,  771,  859},
  { 896,  893,  772},
  { 820,  861,  739},
  { 894,  739,  861},
  { 895,  821,  894},
  { 771,  941,  774},
  { 774,  941,  985},
  { 821,  895,  772},
  { 774,  985,  708},
  { 708,  985,  862},
  { 740,  776,  819},
  { 592,  709,  900},
  { 776,  943,  819},
  { 712,  775,  944},
  { 710,  823,  900},
  { 712,  944,  945},
  { 781,  864,  713},
  { 863,  903,  989},
  { 780,  902,  905},
  { 713,  906,  781},
  { 779,  907,  782},
  { 780,  905, 1024},
  { 780, 1024,  908},
  { 909,  783,  908},
  { 783,  909,  826},
  { 565,  602, 1107},
  { 868,  826,  867},
  { 826,  868,  827},
  { 867, 1065,  868},
  { 827,  868, 1065},
  { 788,  869,  830},
  { 910,  829,  679},
  { 789,  831,  949},
  { 869,  912,  870},
  { 745,  911,  833},
  { 835,  791,  746},
  { 746,  872,  835},
  { 792,  873,  953},
  { 951,  915,  793},
  { 871,  833,  914},
  { 915, 1033,  873},
  { 962,  955,  837},
  { 835,  872,  836},
  { 837,  921,  962},
  { 839,  875,  874},
  { 840,  799,  841},
  { 837,  843,  921},
  { 801,  923,  875},
  { 802,  924,  801},
  { 801,  924,  923},
  { 877, 5884,  846},
  { 846,  925,  928},
  { 846,  848,  877},
  { 970,  926,  804},
  { 848,  929,  877},
  { 878,  756,  881},
  { 883,  808,  879},
  { 764,  851,  882},
  { 851, 1005,  882},
  { 852,  975,  884},
  { 852,  810,  975},
  { 853,  889,  851},
  { 933,  851,  889},
  { 853,  811,  889},
  { 810,  887,  975},
  { 810,  736,  887},
  { 736,  814,  887},
  { 934,  889,  815},
  { 815,  891,  934},
  { 814,  855,  887},
  { 888,  937,  855},
  { 854,  976,  817},
  { 892,  818,  938},
  { 856, 1014,  858},
  { 891,  893, 1053},
  { 818,  980,  938},
  { 892, 1014,  856},
  { 858, 1014, 1015},
  { 858, 1015,  939},
  { 818,  819,  984},
  { 818,  984, 1016},
  { 893,  896,  981},
  { 896,  772,  895},
  { 709,  903,  900},
  { 862,  985,  986},
  { 899,  863, 1020},
  { 862,  741,  824},
  { 943,  865,  988},
  { 864,  781,  901},
  { 865,  633,  946},
  { 633,  825,  907},
  { 907,  825,  714},
  {1137, 1107,  602},
  { 826,  909,  867},
  {1065,  867,  909},
  { 910,  948,  829},
  { 870,  990,  869},
  { 827, 1065,  831},
  { 832,  950,  911},
  { 789,  951,  793},
  { 913,  834,  956},
  { 790,  871,  912},
  { 873, 1033,  953},
  { 871,  914,  870},
  { 916,  837,  955},
  { 916,  957,  917},
  { 874,  875,  992},
  { 876,  838,  874},
  { 836,  959,  802},
  { 841,  796,  840},
  { 796,  841,  918},
  { 917,  961,  795},
  { 802,  959,  919},
  { 920,  795,  961},
  { 919,  960,  924},
  { 924,  960,  965},
  { 962,  921,  922},
  { 921,  843,  844},
  { 921,  844,  876},
  { 921,  876,  922},
  { 927, 1038,  971},
  {1038,  927,  847},
  { 877,  929,  969},
  {1082,  928,  925},
  { 929,  878, 1125},
  { 881,  850, 1002},
  { 879, 1086,  883},
  { 882,  974,  880},
  { 809, 1045,  931},
  { 850,  884, 1004},
  { 882, 1005,  974},
  { 883, 1003,  888},
  {1006,  888, 1003},
  { 932,  885,  890},
  { 932,  890, 1046},
  { 851,  933, 1005},
  { 934,  933,  889},
  { 890,  885, 1050},
  { 886,  976,  854},
  { 937,  887,  855},
  { 888,  935,  937},
  { 936,  937,  935},
  { 937,  936,  979},
  { 816, 1010,  857},
  { 818, 1016,  980},
  { 857,  982,  897},
  { 893,  981, 1053},
  { 771,  940,  941},
  { 894, 1097,  895},
  { 896,  983,  981},
  { 819,  942,  984},
  { 942,  819,  943},
  { 775,  822, 1101},
  { 709,  864,  903},
  { 987,  903,  864},
  { 864,  901,  987},
  { 904,  866,  741},
  { 712,  945,  902},
  { 901,  781,  987},
  { 946,  779,  904},
  { 905,  902,  947},
  { 907,  779,  946},
  { 946,  633,  907},
  { 947, 1024,  905},
  {1137,  829,  948},
  { 869,  990,  830},
  { 910,  830,  990},
  { 950,  991,  911},
  {1035,  950,  832},
  { 832,  913, 1035},
  { 912,  871,  870},
  { 872,  792,  952},
  { 872,  952,  836},
  { 792,  953,  954},
  { 792,  954,  952},
  { 914,  833, 1032},
  { 952,  954,  959},
  { 952,  959,  836},
  { 992,  875,  958},
  { 875,  963,  958},
  { 959, 1033,  919},
  { 960,  919, 1033},
  { 918,  920,  834},
  { 920,  961,  834},
  { 964,  960, 1072},
  { 876,  962,  922},
  { 964,  965,  960},
  { 876, 1073, 1118},
  { 875,  923,  965},
  { 924,  965,  923},
  { 875,  965,  963},
  { 964,  963,  965},
  { 754,  997,  968},
  { 754,  926,  997},
  { 927,  971,  847},
  { 929,  998,  969},
  { 880,  970,  804},
  {1125,  999,  929},
  {1086,  928, 1082},
  {1000, 1001,  849},
  { 849,  972, 1000},
  {1086,  879,  928},
  {1001,  930,  849},
  {1003,  883, 1086},
  { 809,  930, 1045},
  { 972, 1087,  973},
  { 850, 1004, 1002},
  { 973, 1048,  932},
  { 884,  975, 1004},
  { 932, 1048,  885},
  { 886,  931,  976},
  { 888, 1006,  935},
  { 890, 1050,  977},
  { 975,  887,  937},
  {1007,  935, 1006},
  { 890, 1052, 1047},
  { 935, 1007,  936},
  { 978,  936, 1007},
  {1052,  890,  938},
  { 890,  977,  938},
  { 936,  978,  979},
  { 817,  976, 1013},
  { 891, 1053, 1009},
  {1011,  979,  978},
  { 978, 1012, 1011},
  { 857, 1010,  982},
  { 983,  896,  895},
  { 861, 1167,  894},
  { 861,  898, 1167},
  { 984,  942,  943},
  {1104,  944, 1019},
  { 988,  862,  986},
  { 986, 1055,  988},
  { 944, 1104,  945},
  { 862,  988,  741},
  { 904,  741,  988},
  { 865,  904,  988},
  { 863,  989, 1058},
  { 865,  946,  904},
  { 945,  947,  902},
  { 781,  906,  987},
  { 601,  565, 1107},
  { 908, 1025,  909},
  { 909, 1025, 1065},
  { 910,  990, 1028},
  { 949, 1027, 1030},
  { 949,  831, 1027},
  { 990,  870, 1028},
  { 831, 1065, 1172},
  { 870, 1032, 1140},
  { 950, 1035, 1029},
  { 949, 1030,  789},
  { 911,  991, 1067},
  { 833,  911, 1067},
  {1113,  789, 1030},
  { 789, 1113,  951},
  {1032,  870,  914},
  { 951, 1143, 1031},
  { 951, 1031,  915},
  { 915, 1031, 1070},
  {1069, 1068,  962},
  { 954,  953,  959},
  {1033,  959,  953},
  {1070, 1034,  915},
  { 955, 1071, 1035},
  { 955, 1035,  916},
  { 874,  992,  876},
  { 956,  834,  917},
  { 956,  917,  913},
  { 913,  917,  957},
  { 913,  957, 1035},
  { 876,  992, 1073},
  { 992,  958,  993},
  { 992,  993, 1036},
  { 834,  961,  917},
  {1033, 1072,  960},
  { 962,  876, 1118},
  { 963,  994,  958},
  { 963,  964,  994},
  { 964, 1074,  994},
  { 995, 1152, 1038},
  { 995, 1038,  966},
  {1039,  967,  996},
  { 877,  969, 5884},
  { 998, 5884,  969},
  {1038, 1153,  971},
  { 971, 1153, 1122},
  { 926,  970, 1082},
  { 971, 1042,  972},
  { 998,  929, 1041},
  { 970,  880, 1083},
  { 999, 1041,  929},
  {1000,  972,  973},
  {1000,  973,  932},
  { 930, 1001, 1045},
  {1126,  976,  931},
  {1087, 1048,  973},
  {1046,  890, 1047},
  { 933,  934, 1005},
  { 975, 1049, 1004},
  { 934,  891, 1008},
  { 937, 1049,  975},
  { 891, 1009, 1008},
  { 977, 1090,  938},
  {1007, 1008,  978},
  {1012,  978, 1008},
  { 892,  938, 1090},
  { 937,  979, 1051},
  { 938,  980, 1052},
  {1011, 1012, 1095},
  {1092,  859, 1013},
  { 859, 1092,  940},
  { 939, 1015, 1096},
  {1010, 1094,  982},
  { 822,  897,  982},
  { 982, 1017,  822},
  { 982, 1094, 1131},
  { 982, 1131, 1017},
  { 895, 1097,  983},
  { 983, 1095,  981},
  {1017, 1018,  822},
  { 894, 1167, 1097},
  { 898,  899, 1167},
  { 985,  941, 1099},
  { 822, 1018, 1054},
  { 822, 1054, 1100},
  {1020, 1102,  899},
  { 943, 1055,  984},
  { 944,  775, 1019},
  { 986,  985, 1099},
  {1055,  943,  988},
  { 822, 1100, 1056},
  { 906, 1057,  987},
  {1058,  989, 1021},
  {1021,  989, 1022},
  { 947, 1059, 1024},
  {1022,  989, 1023},
  {1025,  908, 1362},
  {1065, 1025, 1063},
  { 991,  950, 1111},
  { 950, 1029, 1111},
  { 955,  962, 1068},
  { 955, 1068, 1071},
  { 915, 1034, 1033},
  {1034, 1070, 1117},
  {1035,  957,  916},
  {1069,  962, 1116},
  {1118, 1116,  962},
  { 994,  993,  958},
  { 964, 1072, 1074},
  { 966, 1079,  995},
  {1080, 1119,  967},
  {1078,  967, 1119},
  { 967, 1078,  966},
  {1079,  966, 1078},
  {1079, 1152,  995},
  {1080,  967, 1037},
  {1037, 1039, 5884},
  {1037,  967, 1039},
  {1039,  968, 1040},
  { 968,  997, 1040},
  {5884, 1081, 1080},
  {1080, 1081, 1154},
  { 846, 1040,  925},
  {5884,  998, 1081},
  { 925, 1040, 1082},
  { 997,  926, 1082},
  { 997, 1082, 1040},
  { 998, 1041, 1081},
  {1122, 1042,  971},
  {1085, 1083,  880},
  {1042, 1043,  972},
  { 999, 1044, 1041},
  {1001, 1000, 1046},
  { 878,  881, 1125},
  { 880,  974, 1085},
  {1000,  932, 1046},
  { 881, 1002, 1125},
  { 974, 1088, 1085},
  {1003, 1089, 1006},
  { 974, 1005, 1089},
  { 974, 1089, 1088},
  {1198, 1002, 1004},
  {1004, 1049, 1198},
  {1005, 1006, 1089},
  {1005, 1007, 1006},
  { 885, 1048, 1050},
  {1008, 1007, 1005},
  {1005,  934, 1008},
  { 977, 1050, 1090},
  {1091,  937, 1051},
  { 937, 1091, 1049},
  { 976, 1127, 1013},
  {1008, 1009, 1012},
  { 979, 1011, 1051},
  {1052,  980, 1092},
  {1012, 1009, 1053},
  {1012, 1053, 1095},
  {1010,  939, 1093},
  {1094, 1010, 1093},
  {1053,  981, 1095},
  {1015, 1014, 1166},
  {1093,  939, 1096},
  {1016, 1098,  980},
  {1132, 1017, 1131},
  {1018, 1017, 1132},
  {1097, 1095,  983},
  { 940, 1099,  941},
  {1102, 1167,  899},
  {1016,  984, 1055},
  {1019,  775, 1103},
  {1099, 1016,  986},
  { 986, 1016, 1055},
  {1019, 1103, 1104},
  { 863, 1058, 1020},
  { 945, 1059,  947},
  {1021, 1022, 1023},
  { 989, 1060, 1171},
  { 989, 1171, 1023},
  {1061, 1062, 1260},
  {1105, 1106, 1061},
  {1105, 1061, 1138},
  {1137,  948, 1261},
  {1025, 1362, 1026},
  {1108, 1026, 1362},
  {1025, 1026, 1108},
  {1109, 1110, 1108},
  {1063, 1025, 1108},
  {1108, 1110, 1063},
  {1027,  831, 1172},
  {1027, 1064, 1212},
  {1027, 1212, 1030},
  {1029, 1066, 1264},
  { 870, 1140, 1028},
  { 991, 1111, 1112},
  {1067,  991, 1112},
  { 951, 1113, 1143},
  {1035, 1071, 1029},
  {1142,  992, 1115},
  {1032,  833, 1067},
  {1068, 1069, 1114},
  {1073,  992, 1142},
  { 992, 1036, 1115},
  {1033, 1034, 1072},
  { 993,  994, 1145},
  {1072, 1034, 1074},
  {1075, 1145,  994},
  {1118, 1073, 1076},
  { 994, 1074, 1075},
  {1118, 1076, 1182},
  {1152, 1077, 1038},
  {1078, 1150, 1079},
  {1038, 1077, 1153},
  {1081, 1121, 1154},
  {1041, 1120, 1081},
  {1081, 1120, 1121},
  { 970, 1083, 1082},
  {1041, 1084, 1120},
  {1043, 1123,  972},
  {1087,  972, 1123},
  {1084, 1041, 1044},
  {1043, 1042, 1123},
  {1001, 1046, 1045},
  { 931, 1045, 1126},
  {1045, 1047, 1126},
  {1045, 1046, 1047},
  {1050, 1048, 1090},
  {1049, 1091, 1161},
  {1091, 1051, 1162},
  {1092, 1128, 1052},
  { 892, 1163, 1014},
  {1014, 1163, 1166},
  { 980, 1098, 1092},
  { 940, 1092, 1098},
  {1015, 1166, 1096},
  {1054, 1018, 1165},
  {1097, 1164, 1095},
  {1098, 1099,  940},
  {1098, 1016, 1099},
  {1203, 1103,  775},
  { 775, 1101, 1203},
  {1104, 1103, 1135},
  { 822, 1056, 1133},
  {1100, 1134, 1056},
  {1020, 1295, 1102},
  { 987, 1057, 1206},
  { 987, 1206,  903},
  {1058, 1295, 1020},
  {1104, 1135, 1362},
  {1058, 1021, 1170},
  {1104, 1059,  945},
  { 989, 1394, 1060},
  {1061, 1106, 1062},
  {1260, 1062, 1106},
  {1024, 1362,  908},
  {1108, 1105, 1138},
  {1108, 1138, 1109},
  {1593,  948,  910},
  {1172, 1139, 1027},
  {1172, 1065, 1063},
  {1030, 1141, 1113},
  {1143, 1113, 1217},
  {1029, 1071, 1114},
  {1115, 1268, 1142},
  {1032, 1067, 1218},
  {1071, 1068, 1114},
  {1114, 1069, 1116},
  {1031, 1179, 1070},
  {1070, 1179, 1144},
  {1036,  993, 1145},
  {1034, 1117, 1074},
  {1074, 1117, 1075},
  {1146, 1075, 1117},
  {1147, 1182, 1076},
  {1119, 1080, 1078},
  {1150, 1078, 1080},
  {1150, 1151, 1079},
  {1079, 1151, 1152},
  {1082, 1083, 1124},
  {1084, 1155, 1121},
  {1084, 1121, 1120},
  {1082, 1124, 1086},
  {1083, 1085, 1124},
  { 999, 1125, 1156},
  {1044,  999, 1156},
  {1044, 1156, 1155},
  {1044, 1155, 1084},
  {1042, 1122, 1158},
  {1042, 1158, 1123},
  {1087, 1123, 1158},
  {1086, 1124, 1003},
  {1088, 1003, 1124},
  {1124, 1085, 1088},
  {1003, 1088, 1089},
  {1126, 1047, 1052},
  {1049, 1161, 1198},
  {1091, 1162, 1161},
  {1128, 1127, 1052},
  {1129, 1162, 1051},
  {1051, 1011, 1129},
  {1164, 1129, 1011},
  {1092, 1013, 1128},
  {1095, 1164, 1011},
  {1094, 1093, 1130},
  {1130, 1093, 1096},
  {1131, 1094, 1200},
  {1165, 1018, 1132},
  {1164, 1097, 1167},
  {1101,  822, 1169},
  {1134, 1201, 1202},
  {1134, 1202, 1056},
  {1133, 1056, 1205},
  {1170, 1295, 1058},
  {1207,  989,  903},
  {1057,  906, 1206},
  {1136, 1170, 1021},
  {1021, 1023, 1136},
  {1394, 1171, 1060},
  {1107, 1329,  906},
  {1023, 1171, 1208},
  {1023, 1208, 1136},
  {1024, 1059, 1362},
  {1138, 1061, 1260},
  {1172, 1110, 1109},
  {1139, 1173, 1027},
  {1063, 1110, 1172},
  {1174,  910, 1028},
  {1064, 1027, 1173},
  {1212, 1064, 1173},
  {1264, 1066, 1175},
  {1111, 1029, 1264},
  {1111, 1177, 1112},
  {1032, 1218, 1140},
  {1218, 1112, 1177},
  {1175, 1066, 1178},
  {1066, 1029, 1178},
  {1112, 1218, 1067},
  {1029, 1114, 1178},
  {1113, 1141, 1217},
  {1031, 1143, 1179},
  {1114, 1116, 1219},
  {1145, 1115, 1036},
  {1115, 1145, 1180},
  {1146, 1117, 1070},
  {1070, 1144, 1146},
  {1116, 1118, 1221},
  {1073, 1142, 1269},
  {1073, 1269, 1076},
  {1145, 1075, 1146},
  {1183, 1148, 1185},
  {1077, 1187, 1149},
  {1077, 1149, 1153},
  {1080, 1154, 1150},
  {1121, 1155, 1154},
  {1156, 1125, 1157},
  {1156, 1157, 1155},
  {1158, 1159, 1087},
  { 976, 1126, 1127},
  {1198, 1161, 1160},
  {1127, 1126, 1052},
  {1048, 1248, 1163},
  {1127, 1128, 1013},
  {1048, 1163, 1090},
  {1253, 1162, 1129},
  {1090, 1163,  892},
  {1165, 1100, 1054},
  {1164, 1167, 1129},
  {1096, 1200, 1130},
  {1130, 1200, 1094},
  {1166, 1294, 1096},
  {1200, 1096, 1294},
  {1200, 1255, 1131},
  {1167, 1102, 1256},
  { 822, 1133, 1169},
  {1103, 1203, 1135},
  {1169, 1133, 1168},
  {1168, 1436, 1204},
  {1168, 1204, 1169},
  {1202, 1205, 1056},
  {1168, 1133, 1436},
  { 903, 1206, 1207},
  {1059, 1104, 1362},
  {1258, 1170, 1136},
  {1136, 1208, 1258},
  {1137, 1329, 1107},
  {1171, 1209, 1208},
  {1105, 1108, 1362},
  {1210, 1172, 1138},
  {1172, 1210, 1173},
  {1593, 1261,  948},
  {1109, 1138, 1172},
  {1139, 1172, 1173},
  {1028, 1211, 1174},
  { 910, 1174, 1593},
  {1520, 1028, 1140},
  {1176, 1520, 1140},
  {1218, 1176, 1140},
  {1217, 1216, 1143},
  {1114, 1219, 1178},
  {1143, 1216, 1179},
  {1268, 1115, 1180},
  {1180, 1146, 1144},
  {1116, 1221, 1219},
  {1180, 1145, 1146},
  {1220, 1222, 1181},
  {1182, 1223, 1118},
  {1076, 1270, 1147},
  {1147, 1270, 1224},
  {1147, 1274, 1182},
  {1184, 1148, 1304},
  {1183, 1304, 1148},
  {1186, 1148, 1184},
  {1186, 1185, 1148},
  {1231, 1188, 1313},
  {1152, 1189, 1077},
  {1077, 1189, 1187},
  {1150, 1154, 1151},
  {1152, 1151, 1234},
  {1152, 1234, 1189},
  {1153, 1233, 1191},
  {1154, 1192, 1151},
  {1153, 1191, 1193},
  {1153, 1193, 1122},
  {1193, 1191, 1122},
  {1154, 1155, 1192},
  {1125, 1284, 1194},
  {1194, 1155, 1157},
  {1194, 1157, 1125},
  {1194, 1284, 1155},
  {1155, 1284, 1236},
  {1155, 1236, 1195},
  {1424, 1313, 1125},
  {1158, 1242, 1159},
  {1196, 1159, 1242},
  {1159, 1196, 1087},
  {1122, 1241, 1158},
  {1196, 1197, 1087},
  {1424, 1125, 1002},
  {1248, 1048, 1087},
  {1198, 1160, 1293},
  {1161, 1162, 1199},
  {1161, 1199, 1160},
  {1252, 1165, 1251},
  {1129, 1167, 1253},
  {1200, 1321, 1255},
  {1131, 1255, 1132},
  {1201, 1134, 1100},
  {1101, 1169, 1203},
  {1203, 1169, 1204},
  {1256, 1102, 1295},
  {1436, 1133, 1205},
  {1295, 1170, 1257},
  {1206,  906, 1207},
  {1106, 1105, 1259},
  {1106, 1259, 1260},
  {1260, 1365, 1138},
  {1210, 1138, 1365},
  {1174, 1211, 1593},
  {1030, 1212, 1213},
  {1213, 1141, 1030},
  {1141, 1213, 1265},
  {1141, 1265, 1215},
  {1215, 1214, 1141},
  {1176, 1218, 1520},
  {1177, 1111, 1266},
  {1217, 1141, 1214},
  {1178, 1267, 1175},
  {1219, 1267, 1178},
  {1179, 1216, 1180},
  {1180, 1144, 1179},
  {1221, 1220, 1219},
  {1220, 1221, 1222},
  {1118, 1223, 1221},
  {1220, 1181, 1271},
  {1181, 1222, 1271},
  {1182, 1274, 1273},
  {1182, 1273, 1223},
  {1274, 1147, 1224},
  {1183, 1275, 1225},
  {1275, 1183, 1226},
  {1184, 1227, 1186},
  {1183, 1185, 1228},
  {1185, 1186, 1228},
  {1186, 1227, 1229},
  {1229, 1228, 1186},
  {1188, 1231, 1281},
  {1232, 1149, 1187},
  {1149, 1232, 1385},
  {1149, 1385, 1233},
  {1149, 1233, 1153},
  {1232, 1187, 1235},
  {1188, 1281, 1190},
  {1189, 1235, 1187},
  {1188, 1190, 1313},
  {1282, 1190, 1281},
  {1235, 1189, 1234},
  {1235, 1283, 1232},
  {1151, 1192, 1234},
  {1282, 1195, 1190},
  {1282, 1285, 1195},
  {1125, 1313, 1284},
  {1190, 1195, 1236},
  {1195, 1285, 1238},
  {1238, 1239, 1195},
  {1240, 1195, 1239},
  {1192, 1155, 1240},
  {1195, 1240, 1155},
  {1241, 1242, 1158},
  {1196, 1242, 1197},
  {1242, 1243, 1197},
  {1087, 1197, 1243},
  {1243, 1246, 1087},
  {1243, 1242, 1246},
  {1087, 1317, 1248},
  {1245, 1247, 1244},
  {1244, 1247, 1249},
  {1290, 1249, 1247},
  {1250, 1249, 1290},
  {1249, 1292, 1291},
  {1251, 1292, 1249},
  {1249, 1250, 1251},
  {1252, 1251, 1250},
  {1160, 1199, 1293},
  {1251, 1165, 1254},
  {1165, 1132, 1254},
  {1165, 1252, 1320},
  {1165, 1320, 1100},
  {1162, 1253, 1293},
  {1162, 1293, 1199},
  {1166, 1163, 1294},
  {1132, 1255, 1254},
  {1100, 1320, 1201},
  {1202, 1324, 1205},
  {1436, 1203, 1204},
  {1257, 1170, 1327},
  { 906, 1329, 1207},
  {1327, 1170, 1258},
  {1137, 1332, 1296},
  {1259, 1365, 1260},
  {1297, 1212, 1173},
  {1297, 1213, 1212},
  {1297, 1263, 1213},
  {1297, 1298, 1263},
  {1028, 1520, 1211},
  {1175, 1300, 1262},
  {1213, 1263, 1265},
  {1111, 1264, 1266},
  {1214, 1215, 1301},
  {1214, 1301, 1217},
  {1175, 1267, 1300},
  {1268, 1180, 1216},
  {1268, 1216, 1301},
  {1217, 1301, 1216},
  {1142, 1340, 1269},
  {1142, 1268, 1340},
  {1267, 1219, 1341},
  {1271, 1302, 1220},
  {1272, 1342, 1271},
  {1221, 1223, 1273},
  {1271, 1222, 1272},
  {1222, 1221, 1375},
  {1222, 1375, 1272},
  {1373, 1224, 1270},
  {1303, 1224, 1373},
  {1274, 1224, 1303},
  {1225, 1304, 1183},
  {1184, 1344, 1305},
  {1275, 1226, 1276},
  {1184, 1307, 1227},
  {1227, 1307, 1308},
  {1276, 1226, 1277},
  {1276, 1277, 1230},
  {1226, 1183, 1277},
  {1183, 1228, 1277},
  {1228, 1229, 1350},
  {1229, 1227, 1309},
  {1230, 1231, 1278},
  {1230, 1278, 1276},
  {1277, 1379, 1279},
  {1277, 1279, 1230},
  {1230, 1279, 1352},
  {1230, 1352, 1280},
  {1230, 1280, 1231},
  {1311, 1278, 1231},
  {1231, 1313, 1311},
  {1231, 1280, 1281},
  {1232, 1283, 1385},
  {1284, 1313, 1190},
  {1236, 1284, 1190},
  {1234, 1192, 1354},
  {1237, 1354, 1192},
  {1237, 1286, 1354},
  {1238, 1285, 1239},
  {1239, 1192, 1240},
  {1239, 1285, 1192},
  {1237, 1192, 1285},
  {1122, 1191, 1241},
  {1241, 1191, 1242},
  {1288, 1315, 1289},
  {1288, 1287, 1315},
  {1315, 1287, 1244},
  {1287, 1245, 1244},
  {1287, 1288, 1289},
  {1287, 1289, 1245},
  {1424, 1002, 1198},
  {1315, 1244, 1249},
  {1242, 1317, 1246},
  {1245, 1316, 1247},
  {1293, 1654, 1198},
  {1246, 1317, 1087},
  {1247, 1316, 1290},
  {1290, 1316, 1250},
  {1291, 1292, 1319},
  {1291, 1319, 1357},
  {1292, 1251, 1254},
  {1255, 1321, 1254},
  {1201, 1322, 1202},
  {1202, 1322, 1324},
  {1135, 1203, 1362},
  {1205, 1324, 1326},
  {1326, 1436, 1205},
  { 989, 1207, 1325},
  {1296, 1329, 1137},
  {1208, 1330, 1258},
  {1105, 1363, 1259},
  {1259, 1363, 1334},
  {1365, 1259, 1333},
  {1334, 1333, 1259},
  {1210, 1335, 1173},
  {1173, 1366, 1297},
  {1298, 1297, 1367},
  {1262, 1264, 1175},
  {1336, 1339, 1299},
  {1299, 1265, 1263},
  {1299, 1263, 1298},
  {1299, 1301, 1265},
  {1265, 1301, 1215},
  {1339, 1301, 1299},
  {1339, 1340, 1268},
  {1339, 1268, 1301},
  {1177, 1266, 1218},
  {1341, 1219, 1220},
  {1302, 1341, 1220},
  {1269, 1343, 1076},
  {1076, 1343, 1270},
  {1273, 1375, 1221},
  {1304, 1344, 1184},
  {1304, 1225, 1348},
  {1225, 1275, 1348},
  {1305, 1306, 1184},
  {1184, 1306, 1307},
  {1351, 1229, 1309},
  {1277, 1228, 1379},
  {1228, 1310, 1379},
  {1228, 1350, 1310},
  {1350, 1229, 1351},
  {1279, 1379, 1352},
  {1281, 1280, 1312},
  {1280, 1352, 1312},
  {1282, 1281, 1384},
  {1234, 1354, 1235},
  {1282, 1314, 1285},
  {1285, 1286, 1237},
  {1242, 1191, 1355},
  {1315, 1356, 1289},
  {1424, 1198, 1654},
  {1289, 1356, 1245},
  {1245, 1356, 1316},
  {1315, 1249, 1291},
  {1317, 1318, 1248},
  {1250, 1391, 1252},
  {1248, 1435, 1163},
  {1391, 1320, 1252},
  {1319, 1292, 1321},
  {1254, 1321, 1292},
  {1322, 1320, 1391},
  {1253, 1167, 1293},
  {1320, 1322, 1201},
  {1167, 1256, 1293},
  {1203, 1323, 1362},
  {1203, 1436, 1323},
  {1324, 1508, 1326},
  {1257, 1359, 1295},
  {1329, 1325, 1207},
  {1393, 1464, 1257},
  {1327, 1393, 1257},
  {1328, 1360, 1361},
  {1330, 1208, 1398},
  {1332, 1394, 1296},
  {1334, 1331, 1513},
  {1335, 1366, 1173},
  {1297, 1366, 1367},
  {1298, 1367, 1368},
  {1339, 1336, 1441},
  {1336, 1299, 1337},
  {1262, 1300, 1404},
  {1338, 1404, 1300},
  {1299, 1298, 1337},
  {1218, 1266, 1520},
  {1269, 1408, 1343},
  {1302, 1271, 1342},
  {1342, 1272, 1374},
  {1273, 1274, 1375},
  {1343, 1373, 1270},
  {1303, 1375, 1274},
  {1345, 1344, 1304},
  {1344, 1413, 1346},
  {1304, 1348, 1345},
  {1305, 1344, 1346},
  {1347, 1275, 1276},
  {1347, 1348, 1275},
  {1306, 1305, 1346},
  {1378, 1347, 1276},
  {1306, 1346, 1415},
  {1308, 1307, 1449},
  {1349, 1227, 1308},
  {1308, 1449, 1349},
  {1418, 1378, 1276},
  {1309, 1227, 1351},
  {1227, 1349, 1351},
  {1276, 1278, 1418},
  {1350, 1380, 1310},
  {1278, 1311, 1422},
  {1313, 1422, 1311},
  {1384, 1312, 1383},
  {1312, 1384, 1281},
  {1283, 1353, 1385},
  {1385, 1386, 1233},
  {1233, 1386, 1191},
  {1455, 1191, 1386},
  {1314, 1286, 1285},
  {1286, 1426, 1354},
  {1235, 1354, 1283},
  {1455, 1428, 1427},
  {1191, 1455, 1355},
  {1242, 1355, 1317},
  {1357, 1388, 1315},
  {1315, 1291, 1357},
  {1316, 1390, 1391},
  {1316, 1391, 1250},
  {1319, 1435, 1357},
  {1163, 1435, 1294},
  {1435, 1319, 1321},
  {1294, 1435, 1200},
  {1391, 1392, 1322},
  {1392, 1358, 1322},
  {1322, 1358, 1324},
  {1358, 1462, 1324},
  {1359, 1256, 1295},
  {1359, 1463, 1256},
  {1323, 1436, 1362},
  {1508, 1328, 1326},
  {1508, 1465, 1328},
  { 989, 1325, 1329},
  { 989, 1329, 1394},
  {1326, 1328, 1361},
  {1327, 1258, 1393},
  {1361, 1360, 1437},
  {1258, 1330, 1393},
  {1105, 1553, 1363},
  {1334, 1363, 1331},
  {1208, 1209, 1398},
  {1333, 1334, 1514},
  {1513, 1514, 1334},
  {1394, 1332, 1364},
  {1137, 1364, 1332},
  {1365, 1333, 1555},
  {1331, 1397, 1513},
  {1364, 1137, 1261},
  {1335, 1210, 1365},
  {1368, 1367, 1370},
  {1445, 1262, 1403},
  {1262, 1404, 1403},
  {1337, 1369, 1367},
  {1369, 1337, 1298},
  {1369, 1298, 1368},
  {1369, 1368, 1370},
  {1369, 1370, 1367},
  {1264, 1262, 1445},
  {1338, 1300, 1443},
  {1406, 1443, 1300},
  {1522, 1371, 1339},
  {1300, 1267, 1406},
  {1339, 1371, 1340},
  {1267, 1341, 1406},
  {1406, 1341, 1302},
  {1340, 1371, 1269},
  {1302, 1372, 1406},
  {1302, 1342, 1372},
  {1406, 1372, 1407},
  {1269, 1371, 1408},
  {1342, 1374, 1409},
  {1272, 1375, 1374},
  {1303, 1412, 1375},
  {1376, 1344, 1345},
  {1376, 1377, 1344},
  {1376, 1345, 1348},
  {1376, 1348, 1448},
  {1347, 1416, 1348},
  {1307, 1414, 1449},
  {1416, 1347, 1450},
  {1417, 1306, 1415},
  {1307, 1306, 1417},
  {1379, 1310, 1380},
  {1278, 1487, 1418},
  {1350, 1382, 1380},
  {1278, 1422, 1487},
  {1352, 1379, 1383},
  {1350, 1351, 1382},
  {1381, 1382, 1351},
  {1424, 1422, 1313},
  {1352, 1383, 1312},
  {1383, 1425, 1384},
  {1384, 1425, 1282},
  {1386, 1385, 1495},
  {1386, 1495, 1455},
  {1282, 1425, 1314},
  {1283, 1456, 1353},
  {1354, 1456, 1283},
  {1455, 1387, 1431},
  {1388, 1357, 1435},
  {1200, 1435, 1321},
  {1256, 1463, 1293},
  {1392, 1462, 1358},
  {1460, 1359, 1257},
  {1460, 1257, 1464},
  {1462, 1508, 1324},
  {1328, 1465, 1360},
  {1394, 1329, 1296},
  {1395, 1396, 1362},
  {1362, 1396, 1105},
  {1105, 1396, 1553},
  {1363, 1553, 1331},
  {1397, 1331, 1553},
  {1439, 1261, 1593},
  {1398, 1394, 1438},
  {1394, 1364, 1438},
  {1397, 1467, 1513},
  {1364, 1261, 1438},
  {1440, 1335, 1365},
  {1335, 1440, 1399},
  {1402, 1366, 1335},
  {1399, 1400, 1335},
  {1335, 1400, 1401},
  {1335, 1401, 1402},
  {1366, 1402, 1337},
  {1366, 1337, 1367},
  {1442, 1441, 1336},
  {1404, 1338, 1443},
  {1339, 1441, 1444},
  {1336, 1337, 1402},
  {1211, 1520, 1593},
  {1406, 1469, 1443},
  {1444, 1405, 1339},
  {1339, 1405, 1522},
  {1406, 1407, 1521},
  {1372, 1342, 1407},
  {1447, 1343, 1408},
  {1373, 1343, 1447},
  {1373, 1412, 1303},
  {1374, 1410, 1527},
  {1374, 1375, 1410},
  {1375, 1411, 1410},
  {1375, 1412, 1411},
  {1413, 1344, 1377},
  {1376, 1448, 1377},
  {1415, 1346, 1413},
  {1348, 1416, 1448},
  {1417, 1414, 1307},
  {1450, 1347, 1378},
  {1485, 1416, 1450},
  {1417, 1415, 1451},
  {1349, 1449, 1419},
  {1349, 1419, 1351},
  {1423, 1420, 1486},
  {1486, 1489, 1423},
  {1379, 1380, 1421},
  {1380, 1382, 1421},
  {1351, 1419, 1381},
  {1452, 1421, 1382},
  {1425, 1286, 1314},
  {1426, 1454, 1354},
  {1456, 1354, 1494},
  {1427, 1428, 1318},
  {1432, 1355, 1455},
  {1429, 1432, 1455},
  {1455, 1427, 1429},
  {1318, 1429, 1427},
  {1428, 1455, 1430},
  {1431, 1430, 1455},
  {1387, 1539, 1431},
  {1355, 1432, 1317},
  {1388, 1433, 1315},
  {1318, 1389, 1248},
  {1547, 1248, 1389},
  {1391, 1390, 1392},
  {1293, 1463, 1584},
  {1460, 1461, 1359},
  {1461, 1463, 1359},
  {1361, 1436, 1326},
  {1464, 1393, 1466},
  {1512, 1466, 1393},
  {1361, 1510, 1436},
  {1512, 1393, 1330},
  {1512, 1330, 1398},
  {1395, 1551, 1396},
  {1171, 1394, 1398},
  {1209, 1171, 1398},
  {1438, 1261, 1439},
  {1514, 1555, 1333},
  {1399, 1440, 1400},
  {1400, 1468, 1401},
  {1401, 1336, 1402},
  {1401, 1468, 1336},
  {1468, 1442, 1336},
  {1403, 1404, 1517},
  {1405, 1444, 1522},
  {1264, 1445, 1471},
  {1266, 1264, 1471},
  {1371, 1561, 1408},
  {1342, 1446, 1407},
  {1374, 1527, 1409},
  {1482, 1412, 1373},
  {1410, 1411, 1639},
  {1412, 1482, 1411},
  {1639, 1411, 1482},
  {1377, 1483, 1413},
  {1484, 1378, 1418},
  {1378, 1484, 1450},
  {1451, 1414, 1417},
  {1487, 1484, 1418},
  {1415, 1530, 1451},
  {1486, 1534, 1489},
  {1379, 1421, 1491},
  {1381, 1419, 1490},
  {1379, 1491, 1383},
  {1382, 1381, 1452},
  {1381, 1490, 1452},
  {1383, 1491, 1425},
  {1424, 1654, 1536},
  {1425, 1491, 1426},
  {1425, 1426, 1286},
  {1453, 1426, 1491},
  {1426, 1453, 1454},
  {1453, 1491, 1454},
  {1493, 1387, 1423},
  {1354, 1454, 1494},
  {1455, 1615, 1387},
  {1456, 1575, 1353},
  {1652, 1539, 1387},
  {1318, 1432, 1429},
  {1428, 1430, 1318},
  {1431, 1318, 1430},
  {1431, 1539, 1318},
  {1432, 1318, 1317},
  {1388, 1498, 1433},
  {1498, 1579, 1433},
  {1457, 1458, 1546},
  {1458, 1584, 1546},
  {1458, 1293, 1584},
  {1390, 1499, 1392},
  {1392, 1499, 1459},
  {1459, 1462, 1392},
  {1461, 1584, 1463},
  {1507, 1508, 1462},
  {1510, 1361, 1437},
  {1360, 1550, 1437},
  {1362, 1551, 1395},
  {1396, 1551, 1553},
  {1397, 1553, 1467},
  {1467, 1553, 1513},
  {1438, 1439, 1398},
  {1554, 1398, 1439},
  {1468, 1400, 1440},
  {1441, 1442, 1440},
  {1404, 1443, 1517},
  {1443, 1469, 1517},
  {1444, 1441, 1515},
  {1403, 1517, 1445},
  {1444, 1516, 1522},
  {1470, 1522, 1516},
  {1406, 1521, 1595},
  {1472, 1519, 1474},
  {1519, 1475, 1473},
  {1519, 1473, 1474},
  {1475, 1519, 1476},
  {1599, 1472, 1474},
  {1475, 1476, 1478},
  {1599, 1479, 1524},
  {1599, 1474, 1480},
  {1599, 1480, 1479},
  {1474, 1473, 1477},
  {1473, 1475, 1477},
  {1475, 1478, 1477},
  {1407, 1446, 1631},
  {1446, 1342, 1525},
  {1409, 1526, 1342},
  {1524, 1479, 1481},
  {1408, 1561, 1447},
  {1447, 1561, 1373},
  {1527, 1410, 1605},
  {1482, 1373, 1561},
  {1639, 1605, 1410},
  {1528, 1377, 1448},
  {1413, 1564, 1415},
  {1414, 1529, 1449},
  {1485, 1448, 1416},
  {1530, 1415, 1564},
  {1531, 1420, 1608},
  {1420, 1488, 1608},
  {1420, 1531, 1486},
  {1450, 1484, 1532},
  {1450, 1532, 1485},
  {1420, 1423, 1570},
  {1420, 1570, 1488},
  {1487, 1422, 1535},
  {1421, 1452, 1491},
  {1490, 1492, 1452},
  {1452, 1492, 1537},
  {1423, 1387, 1615},
  {1495, 1385, 1353},
  {1617, 1434, 1540},
  {1617, 1651, 1434},
  {1652, 1389, 1318},
  {1499, 1390, 1434},
  {1498, 1388, 1435},
  {1620, 1458, 1457},
  {1435, 1248, 1498},
  {1498, 1248, 1579},
  {1496, 1497, 1500},
  {1501, 1500, 1505},
  {1500, 1497, 1505},
  {1499, 1503, 1459},
  {1501, 1505, 1504},
  {1459, 1503, 1462},
  {1502, 1504, 1506},
  {1502, 1506, 1503},
  {1545, 1461, 1460},
  {1462, 1503, 1507},
  {1503, 1506, 1507},
  {1460, 1464, 1549},
  {1511, 1509, 1464},
  {1362, 1436, 1510},
  {1464, 1466, 1511},
  {1591, 1509, 1511},
  {1466, 1512, 1511},
  {1398, 1792, 1512},
  {1629, 1555, 1514},
  {1514, 1513, 1629},
  {1555, 1440, 1365},
  {1515, 1440, 1556},
  {1440, 1442, 1468},
  {1441, 1440, 1515},
  {1444, 1515, 1516},
  {1469, 1406, 1595},
  {1597, 1470, 1516},
  {1471, 1445, 1558},
  {1470, 1597, 1518},
  {1470, 1518, 1522},
  {1522, 1518, 1523},
  {1518, 1524, 1523},
  {1518, 1599, 1524},
  {1266, 1471, 1520},
  {1631, 1521, 1407},
  {1523, 1524, 1481},
  {1560, 1480, 1474},
  {1560, 1474, 1477},
  {1477, 1476, 1560},
  {1477, 1478, 1476},
  {1371, 1522, 1561},
  {1480, 1635, 1479},
  {1525, 1342, 1526},
  {1636, 1526, 1409},
  {1606, 1562, 1483},
  {1483, 1377, 1606},
  {1563, 1606, 1377},
  {1483, 1562, 1413},
  {1528, 1563, 1377},
  {1565, 1528, 1448},
  {1448, 1485, 1565},
  {1531, 1608, 1642},
  {1451, 1530, 1676},
  {1608, 1488, 1566},
  {1484, 1533, 1532},
  {1489, 1571, 1646},
  {1646, 1423, 1489},
  {1487, 1535, 1568},
  {1533, 1612, 1532},
  {1532, 1612, 1485},
  {1419, 5887, 1569},
  {1489, 1679, 1571},
  {1419, 1569, 1490},
  {1423, 1646, 1493},
  {1535, 1422, 1536},
  {1422, 1424, 1536},
  {1537, 1491, 1452},
  {1537, 1454, 1491},
  {1538, 1537, 1492},
  {1575, 1538, 1492},
  {1572, 1575, 1492},
  {1538, 1454, 1537},
  {1494, 1454, 1538},
  {1575, 1494, 1538},
  {1494, 1575, 1456},
  {1577, 1681, 1353},
  {1353, 1681, 1495},
  {1387, 1616, 1652},
  {1651, 1541, 1434},
  {1434, 1541, 1499},
  {1543, 1541, 1578},
  {1541, 1543, 1544},
  {1542, 1496, 1543},
  {1541, 1544, 1499},
  {1500, 1504, 1543},
  {1543, 1496, 1500},
  {1499, 1544, 1503},
  {1545, 1583, 1457},
  {1457, 1546, 1545},
  {1543, 1504, 1544},
  {1497, 1580, 1587},
  {1293, 1686, 1654},
  {1544, 1504, 1502},
  {1500, 1501, 1504},
  {1502, 1503, 1544},
  {1545, 1460, 1583},
  {1584, 1461, 1545},
  {1505, 1497, 1548},
  {1497, 1587, 1548},
  {1548, 1504, 1505},
  {1549, 1625, 1460},
  {1548, 1507, 1506},
  {1506, 1504, 1548},
  {1464, 1509, 1549},
  {1507, 1548, 1508},
  {1548, 1465, 1508},
  {1549, 1509, 1589},
  {1509, 1591, 1589},
  {1362, 1510, 1551},
  {1437, 1550, 1590},
  {1511, 1552, 1591},
  {1512, 1592, 1511},
  {1511, 1592, 1552},
  {1792, 1592, 1512},
  {1551, 1692, 1553},
  {1440, 1555, 1556},
  {1520, 1594, 1593},
  {1516, 1515, 1556},
  {1469, 1595, 1517},
  {1516, 1630, 1597},
  {1558, 1445, 1517},
  {1558, 1517, 1600},
  {1518, 1597, 1599},
  {1599, 1598, 1472},
  {1472, 1632, 1519},
  {1472, 1598, 1632},
  {1632, 1476, 1519},
  {1446, 1525, 1631},
  {1559, 1480, 1560},
  {1602, 1560, 1476},
  {1480, 1559, 1635},
  {1526, 1604, 1525},
  {1409, 1527, 1637},
  {1481, 1479, 1635},
  {1562, 1607, 1413},
  {1564, 1413, 1607},
  {1563, 1528, 1565},
  {1676, 1530, 1564},
  {1644, 1531, 1642},
  {1531, 1644, 1486},
  {1485, 1567, 1610},
  {1485, 1610, 1565},
  {1566, 1488, 1609},
  {1487, 1568, 1484},
  {1484, 1568, 1533},
  {1612, 1567, 1485},
  {5887, 1647, 1569},
  {1489, 1534, 1679},
  {1614, 1613, 1535},
  {1490, 1569, 1492},
  {1535, 1536, 1614},
  {1572, 1492, 1569},
  {1615, 1570, 1423},
  {1654, 1573, 1536},
  {1573, 1614, 1536},
  {1614, 1573, 1574},
  {1573, 1654, 1576},
  {1493, 1616, 1387},
  {1616, 1493, 1646},
  {1574, 1573, 1576},
  {1574, 1576, 1680},
  {1495, 1615, 1455},
  {1577, 1353, 1575},
  {1539, 1652, 1318},
  {1651, 1578, 1541},
  {1578, 1653, 1542},
  {1496, 1542, 1653},
  {1540, 1433, 1848},
  {1578, 1542, 1543},
  {1620, 1457, 1583},
  {1433, 1579, 1848},
  {1458, 1620, 1293},
  {1248, 1581, 1579},
  {1848, 1579, 1581},
  {1248, 1582, 1581},
  {1248, 1723, 1622},
  {1248, 1622, 1582},
  {1580, 1585, 1586},
  {1546, 1584, 1545},
  {1586, 1587, 1580},
  {1625, 1583, 1460},
  {1655, 1550, 1548},
  {1589, 1625, 1549},
  {1548, 1550, 1360},
  {1360, 1465, 1548},
  {1591, 1628, 1589},
  {1437, 1590, 1661},
  {1552, 1592, 1591},
  {1554, 1439, 1593},
  {1593, 1398, 1554},
  {1629, 1630, 1555},
  {1630, 1516, 1556},
  {1520, 1558, 1736},
  {1595, 1521, 1596},
  {1521, 1631, 1596},
  {1603, 1601, 1559},
  {1603, 1559, 1560},
  {1476, 1632, 1602},
  {1520, 1471, 1558},
  {1522, 1523, 1634},
  {1560, 1602, 1603},
  {1525, 1604, 1631},
  {1523, 1481, 1634},
  {1522, 1634, 1561},
  {1409, 1637, 1636},
  {1561, 1634, 1482},
  {1562, 1710, 1607},
  {1606, 1640, 1562},
  {1563, 1565, 1641},
  {1646, 1571, 1645},
  {1610, 1567, 1611},
  {1609, 1488, 1570},
  {1609, 1570, 1647},
  {1568, 1648, 1612},
  {1568, 1612, 1533},
  {1567, 1612, 1611},
  {1676, 1716, 1451},
  {1451, 1716, 1752},
  {1535, 1613, 1568},
  {1577, 1575, 1572},
  {1495, 1650, 1615},
  {1650, 1495, 1681},
  {1576, 1682, 1680},
  {1616, 1683, 1652},
  {1619, 1651, 1617},
  {1496, 1684, 1497},
  {1497, 1684, 1580},
  {1685, 1580, 1684},
  {1581, 1582, 1848},
  {1622, 1848, 1582},
  {1621, 1585, 1580},
  {1547, 1389, 1722},
  {1621, 1623, 1585},
  {1547, 1723, 1248},
  {1588, 1623, 1756},
  {1586, 1585, 1548},
  {1586, 1548, 1587},
  {1624, 1655, 1588},
  {1626, 1624, 1784},
  {1624, 1626, 1655},
  {1588, 1655, 1623},
  {1623, 1655, 1585},
  {1585, 1655, 1548},
  {1626, 1728, 1655},
  {1658, 1690, 1550},
  {1661, 1510, 1437},
  {1628, 1627, 1589},
  {1550, 1690, 1590},
  {1551, 1734, 1692},
  {1630, 1556, 1555},
  {1737, 1693, 1557},
  {1696, 1594, 1520},
  {1740, 1737, 1557},
  {1698, 1736, 1558},
  {1699, 1597, 1694},
  {1699, 1598, 1599},
  {1558, 1600, 1698},
  {1631, 1738, 1596},
  {1599, 1597, 1699},
  {1598, 1700, 1632},
  {1601, 1603, 1701},
  {1632, 1703, 1633},
  {1632, 1633, 1602},
  {1602, 1633, 1603},
  {1631, 1604, 1667},
  {1526, 1636, 1797},
  {1638, 1482, 1634},
  {1482, 1638, 1639},
  {1710, 1562, 1640},
  {1640, 1606, 1744},
  {1563, 1641, 1606},
  {1564, 1714, 1676},
  {1675, 1641, 1565},
  {1752, 1643, 1451},
  {5885, 1609, 1647},
  {5887, 5885, 1647},
  {1646, 1645, 1750},
  {1648, 1649, 1612},
  {1647, 1681, 1569},
  {1568, 1613, 1648},
  {1649, 1611, 1612},
  {1647, 1570, 1681},
  {1613, 1614, 1574},
  {1613, 1574, 1648},
  {1681, 1570, 1650},
  {1648, 1574, 1649},
  {1649, 1574, 1680},
  {1577, 1572, 1569},
  {1570, 1615, 1650},
  {1651, 1618, 1578},
  {1683, 1722, 1652},
  {1578, 1618, 1653},
  {1540, 1848, 1617},
  {1617, 1848, 1619},
  {1618, 1684, 1653},
  {1651, 1619, 1618},
  {1684, 1618, 1619},
  {1580, 1685, 1621},
  {1620, 1583, 1687},
  {1620, 1996, 1293},
  {1623, 1621, 1724},
  {1547, 1722, 1723},
  {1589, 1689, 1625},
  {1689, 1589, 1627},
  {1789, 1655, 1728},
  {1655, 1658, 1550},
  {1657, 1689, 1627},
  {1659, 1662, 1656},
  {1656, 1657, 1659},
  {1659, 1657, 1660},
  {1657, 1627, 1660},
  {1627, 1663, 1660},
  {1510, 1661, 1691},
  {1551, 1510, 1691},
  {1661, 1590, 1729},
  {1690, 1658, 1789},
  {1663, 1627, 1664},
  {1627, 1628, 1664},
  {1729, 1590, 1860},
  {1590, 1690, 1860},
  {1591, 1592, 1628},
  {1765, 1553, 1692},
  {1593, 1594, 1665},
  {1737, 1699, 1629},
  {1629, 1513, 1737},
  {1513, 1693, 1737},
  {1695, 1557, 1693},
  {1557, 1695, 1740},
  {1630, 1694, 1597},
  {1595, 1596, 1738},
  {1698, 1600, 1517},
  {1517, 1595, 1698},
  {1738, 1631, 1666},
  {1631, 1667, 1666},
  {1702, 1601, 1701},
  {1702, 1559, 1601},
  {1702, 1706, 1559},
  {1633, 1703, 1603},
  {1706, 1635, 1559},
  {1703, 1668, 1603},
  {1604, 1526, 1877},
  {1797, 1877, 1526},
  {1707, 1636, 1637},
  {1637, 1527, 1670},
  {1671, 1670, 1527},
  {1481, 1635, 1709},
  {1527, 1605, 1671},
  {1634, 1481, 1638},
  {1672, 1638, 1481},
  {1605, 1638, 1671},
  {1639, 1638, 1605},
  {1672, 1671, 1638},
  {1710, 1640, 1673},
  {1744, 1673, 1640},
  {1711, 1607, 1710},
  {1607, 1711, 1564},
  {1712, 1744, 1606},
  {1606, 1641, 1674},
  {1711, 1714, 1564},
  {1674, 1641, 1675},
  {1643, 1677, 5885},
  {1678, 1644, 1642},
  {1565, 1610, 1675},
  {1643, 1752, 1677},
  {1646, 1750, 1778},
  {1610, 1749, 1675},
  {1678, 1679, 1644},
  {1644, 1534, 1486},
  {1644, 1679, 1534},
  {1611, 1680, 1717},
  {1611, 1649, 1680},
  {1679, 1718, 1571},
  {1571, 1718, 1645},
  {1645, 1718, 1719},
  {1569, 1681, 1577},
  {1576, 1754, 1682},
  {1653, 1684, 1496},
  {1652, 1722, 1389},
  {1576, 1654, 1686},
  {1686, 1293, 1996},
  {1583, 1625, 1687},
  {1756, 1784, 1624},
  {1625, 1688, 1687},
  {1688, 1625, 1689},
  {1726, 1656, 1725},
  {1726, 1689, 1657},
  {1726, 1657, 1656},
  {1626, 1815, 1728},
  {1658, 1655, 1789},
  {1731, 1662, 1659},
  {1659, 1660, 1731},
  {1729, 1691, 1661},
  {1660, 1663, 1731},
  {1732, 1731, 1663},
  {1664, 1732, 1663},
  {1729, 1730, 1691},
  {1664, 1628, 1733},
  {1551, 1691, 1730},
  {1628, 1592, 1733},
  {1592, 1735, 1733},
  {1592, 1792, 1735},
  {1665, 1398, 1593},
  {1630, 1629, 1694},
  {1699, 1694, 1629},
  {1594, 1696, 1665},
  {1520, 1736, 1697},
  {1520, 1697, 1696},
  {1699, 1700, 1598},
  {1698, 1595, 1738},
  {1666, 1667, 1793},
  {1666, 1793, 1738},
  {1695, 1705, 1740},
  {1667, 1604, 1704},
  {1667, 1704, 1793},
  {1603, 1668, 1701},
  {1704, 1604, 1770},
  {1769, 1706, 1702},
  {1703, 1705, 1669},
  {1703, 1669, 1668},
  {1706, 1708, 1635},
  {1637, 1670, 1707},
  {1742, 1707, 1670},
  {1708, 1709, 1635},
  {1797, 1636, 1828},
  {1709, 1670, 1671},
  {1709, 1672, 1481},
  {1671, 1672, 1709},
  {1710, 1673, 1799},
  {1799, 1673, 1743},
  {1712, 1606, 1674},
  {1713, 1748, 1715},
  {1677, 1678, 5886},
  {1674, 1675, 1749},
  {1646, 1778, 1837},
  {1610, 1611, 1751},
  {1610, 1751, 1749},
  {1677, 1752, 1841},
  {1677, 1841, 1678},
  {1892, 1678, 1841},
  {1645, 1720, 1750},
  {1717, 1751, 1611},
  {1678, 1718, 1679},
  {1719, 1721, 1645},
  {1645, 1721, 1720},
  {1717, 1680, 1682},
  {1780, 1683, 1646},
  {1646, 1683, 1616},
  {1808, 1682, 1811},
  {1682, 1754, 1811},
  {1685, 1849, 1621},
  {1687, 1755, 1620},
  {1723, 1848, 1622},
  {1848, 1684, 1619},
  {1688, 1757, 1687},
  {1588, 1756, 1624},
  {1688, 1689, 1759},
  {1725, 1656, 1788},
  {1689, 1726, 1727},
  {1784, 1815, 1626},
  {1817, 1788, 1656},
  {1728, 1760, 1789},
  {1789, 1860, 1690},
  {1662, 1731, 1761},
  {1662, 1761, 1656},
  {1664, 1733, 1732},
  {1551, 1730, 1734},
  {1665, 1696, 1398},
  {1697, 1736, 1766},
  {1699, 1737, 1700},
  {1698, 1738, 1736},
  {1703, 1632, 1700},
  {1737, 1740, 1703},
  {1703, 1740, 1705},
  {1702, 1826, 1769},
  {1668, 1741, 1701},
  {1770, 1604, 1877},
  {1668, 1669, 1741},
  {1741, 1669, 1705},
  {1828, 1636, 1707},
  {1769, 1707, 1706},
  {1742, 1706, 1707},
  {1706, 1742, 1708},
  {1708, 1742, 1670},
  {1670, 1709, 1708},
  {1673, 1744, 1743},
  {1710, 1799, 1711},
  {1744, 1745, 1800},
  {1745, 1744, 1715},
  {1674, 1746, 1712},
  {1714, 1711, 1802},
  {1745, 1715, 1773},
  {1713, 1715, 1744},
  {1744, 1712, 1713},
  {1746, 1713, 1712},
  {1773, 1715, 1747},
  {1713, 1746, 1748},
  {1714, 1774, 1676},
  {1747, 1715, 1748},
  {1746, 1674, 1776},
  {1674, 1749, 1776},
  {1747, 1748, 1775},
  {1676, 1774, 1839},
  {1676, 1839, 1716},
  {1646, 1837, 1780},
  {1751, 1717, 1807},
  {1779, 1750, 1720},
  {1721, 1781, 1720},
  {1779, 1720, 1781},
  {1892, 1893, 1678},
  {1718, 1678, 1893},
  {1718, 1753, 1719},
  {1721, 1719, 1753},
  {1781, 1721, 1782},
  {1753, 1782, 1721},
  {1753, 1718, 1893},
  {1811, 1754, 2212},
  {1576, 1686, 2285},
  {1848, 1999, 1684},
  {1623, 1724, 1756},
  {1757, 1755, 1687},
  {1758, 1757, 1688},
  {1759, 1758, 1688},
  {1689, 1727, 1759},
  {1725, 1788, 1785},
  {1725, 1787, 1726},
  {1727, 1726, 1787},
  {1656, 1761, 1862},
  {1656, 1862, 1817},
  {1730, 1729, 1762},
  {1729, 1860, 1762},
  {1761, 1763, 1862},
  {1731, 1819, 1761},
  {1730, 1912, 1734},
  {1731, 1732, 1764},
  {1761, 1864, 1763},
  {1733, 1735, 1791},
  {1733, 1791, 1732},
  {1732, 1791, 1764},
  {1735, 1792, 1791},
  {1695, 1693, 1820},
  {1792, 1398, 1696},
  {1697, 1792, 1696},
  {1697, 1766, 1792},
  {1736, 1792, 1766},
  {1695, 1794, 1795},
  {1700, 1737, 1703},
  {1695, 1795, 1767},
  {1702, 1824, 1739},
  {1702, 1701, 1824},
  {1702, 1739, 1826},
  {1695, 1767, 1705},
  {1768, 1705, 1767},
  {1704, 1770, 1793},
  {1701, 1741, 1771},
  {1768, 1771, 1741},
  {1768, 1741, 1705},
  {1828, 1878, 1797},
  {1743, 1744, 1798},
  {1799, 1743, 1798},
  {1798, 1744, 1772},
  {1744, 1800, 1772},
  {1799, 1801, 1711},
  {1745, 1773, 1832},
  {1711, 1801, 1802},
  {1774, 1714, 1802},
  {1775, 1804, 1747},
  {1776, 1748, 1746},
  {1804, 1775, 1777},
  {1777, 1775, 1806},
  {1775, 1748, 1776},
  {1749, 1751, 1805},
  {1750, 1779, 1778},
  {1717, 1682, 1807},
  {1779, 1781, 1809},
  {1810, 1781, 1782},
  {1755, 1996, 1620},
  {1723, 1898, 1848},
  {1621, 1849, 1724},
  {1755, 1757, 1897},
  {1758, 1897, 1757},
  {1897, 1758, 1783},
  {1759, 1783, 1758},
  {1725, 1785, 1787},
  {1786, 1787, 1785},
  {1787, 1759, 1727},
  {1905, 1815, 1814},
  {1814, 1815, 1784},
  {1858, 1760, 1728},
  {1789, 1760, 1858},
  {1730, 1762, 1912},
  {1912, 1915, 1734},
  {1731, 1764, 1819},
  {1791, 1790, 1764},
  {1734, 1915, 1692},
  {1695, 1919, 1794},
  {1920, 1792, 1736},
  {1795, 1823, 1796},
  {1826, 1739, 1876},
  {1796, 1767, 1795},
  {1796, 1827, 1767},
  {1768, 1767, 1827},
  {1793, 1770, 1875},
  {1707, 1769, 1828},
  {1771, 1768, 1701},
  {1798, 1830, 1829},
  {1798, 1829, 1799},
  {1832, 1831, 1745},
  {1773, 1747, 1835},
  {1835, 1747, 1804},
  {1887, 1838, 1776},
  {1805, 1887, 1776},
  {1776, 1749, 1805},
  {1775, 1776, 1838},
  {1775, 1838, 1806},
  {1716, 1839, 1752},
  {1751, 1807, 1805},
  {1809, 1778, 1779},
  {1752, 1888, 1841},
  {1807, 1682, 1808},
  {1781, 1843, 1809},
  {1781, 1846, 1843},
  {1808, 1811, 1845},
  {1893, 1894, 1753},
  {1753, 1894, 1782},
  {1683, 2051, 1722},
  {1849, 1685, 1684},
  {1759, 1812, 1783},
  {1786, 1785, 1900},
  {1786, 1812, 1787},
  {1786, 1900, 1812},
  {1812, 1759, 1787},
  {1814, 1784, 1813},
  {1788, 1958, 1785},
  {1858, 1815, 1816},
  {1815, 1858, 1728},
  {1911, 1789, 1858},
  {1864, 1862, 1763},
  {1819, 1764, 1913},
  {1872, 1868, 1917},
  {1915, 1765, 1692},
  {1791, 1792, 1821},
  {1822, 1794, 1919},
  {1738, 1921, 1968},
  {1738, 1793, 1921},
  {1823, 1794, 1822},
  {1736, 1738, 1920},
  {1794, 1823, 1795},
  {1739, 1824, 1876},
  {1823, 1825, 1796},
  {1769, 1826, 1828},
  {1701, 1929, 1824},
  {1877, 1875, 1770},
  {1701, 1827, 1929},
  {1768, 1827, 1701},
  {1827, 1796, 1929},
  {1878, 2037, 1797},
  {1830, 1772, 1800},
  {1772, 1830, 1798},
  {1829, 1879, 1799},
  {1799, 1880, 1801},
  {1800, 1745, 1830},
  {1831, 1830, 1745},
  {1880, 1931, 1801},
  {1801, 1931, 1802},
  {1802, 1931, 1935},
  {1884, 1833, 1935},
  {1833, 1802, 1935},
  {1773, 1835, 1832},
  {1836, 1833, 1884},
  {1836, 1884, 1803},
  {2041, 1803, 1986},
  {1834, 1803, 2041},
  {1802, 1833, 1774},
  {1774, 1833, 1839},
  {1886, 1803, 1834},
  {1804, 1777, 1942},
  {1777, 1806, 1942},
  {1943, 1803, 1886},
  {1778, 1809, 1837},
  {1839, 1888, 1752},
  {1806, 1838, 1840},
  {1838, 1889, 1840},
  {1806, 1840, 1890},
  {1807, 1808, 1805},
  {1840, 1889, 1842},
  {1845, 1891, 1808},
  {1892, 1943, 1893},
  {1946, 1842, 1844},
  {1780, 1991, 1683},
  {2051, 1683, 1991},
  {1781, 1895, 1846},
  {1895, 1781, 1810},
  {1897, 1996, 1755},
  {1723, 1722, 1898},
  {1898, 1951, 1848},
  {1999, 1850, 1684},
  {1684, 1850, 1851},
  {1684, 1851, 1849},
  {1724, 1849, 1953},
  {1812, 1952, 1783},
  {1724, 1953, 2053},
  {1900, 1785, 1899},
  {1954, 1813, 1784},
  {1903, 1854, 1853},
  {1903, 1853, 1901},
  {1813, 1901, 1814},
  {1852, 1856, 2105},
  {2105, 1856, 2063},
  {1855, 1901, 1853},
  {1901, 1855, 1814},
  {1815, 1905, 1816},
  {1788, 1817, 2108},
  {1788, 2108, 1958},
  {1852, 1906, 1909},
  {1856, 1857, 2063},
  {1816, 1907, 1858},
  {1909, 1859, 1852},
  {1852, 1867, 1856},
  {1856, 1867, 1857},
  {1762, 1818, 1912},
  {1762, 1860, 1818},
  {1867, 1861, 1910},
  {1861, 1865, 1863},
  {1761, 1819, 1864},
  {1861, 1868, 1865},
  {1863, 1865, 1866},
  {1861, 1867, 1868},
  {1865, 1869, 1866},
  {1866, 1869, 2237},
  {1791, 1917, 1867},
  {1865, 1872, 1869},
  {1917, 1868, 1867},
  {1868, 1872, 1865},
  {1869, 1871, 2237},
  {2237, 1871, 1870},
  {1914, 1870, 1873},
  {1918, 1869, 1872},
  {1871, 1869, 1918},
  {1870, 1871, 1918},
  {1765, 1966, 1820},
  {1916, 1791, 1821},
  {1820, 1919, 1695},
  {1793, 1875, 1921},
  {1822, 1970, 1823},
  {1922, 1825, 1823},
  {1874, 1922, 1823},
  {1970, 1874, 1823},
  {1876, 1927, 1979},
  {1876, 1824, 1927},
  {1825, 1929, 1796},
  {1875, 1877, 1978},
  {2031, 1828, 1826},
  {1797, 2037, 1981},
  {1797, 1981, 2081},
  {1830, 1879, 1829},
  {1799, 1879, 1880},
  {1831, 1881, 1830},
  {1882, 1830, 1881},
  {1830, 1882, 1879},
  {1881, 1831, 1832},
  {1883, 1881, 1832},
  {1832, 1835, 1883},
  {1984, 1883, 1835},
  {1884, 1938, 1803},
  {1803, 1938, 1986},
  {1833, 1836, 1888},
  {1834, 1885, 1886},
  {1835, 1804, 1940},
  {1942, 1940, 1804},
  {1888, 1839, 1833},
  {1803, 1943, 1836},
  {1943, 1886, 1945},
  {1837, 1988, 1780},
  {1838, 1887, 1889},
  {1806, 1890, 1944},
  {1806, 1944, 1942},
  {1887, 1805, 1808},
  {1887, 1808, 1889},
  {1889, 1891, 1842},
  {1840, 1842, 1890},
  {1842, 1891, 1844},
  {1946, 1844, 1891},
  {1845, 1946, 1891},
  {1810, 1782, 1894},
  {1754, 1576, 2285},
  {1847, 1896, 1848},
  {1848, 1896, 1999},
  {1897, 1783, 1952},
  {2001, 2000, 1756},
  {1756, 1724, 2001},
  {2053, 2001, 1724},
  {1899, 2003, 1900},
  {1813, 1954, 1901},
  {2004, 1902, 1852},
  {1852, 1902, 1906},
  {1903, 1904, 1854},
  {1905, 1962, 1816},
  {1905, 1959, 1962},
  {1962, 1959, 1960},
  {1855, 1853, 1961},
  {1855, 1961, 1814},
  {1814, 1961, 1905},
  {1853, 1854, 1961},
  {1908, 1907, 1816},
  {1858, 1907, 1911},
  {1907, 1908, 1911},
  {1867, 1910, 1857},
  {1859, 1867, 1852},
  {1789, 1911, 1860},
  {1912, 1818, 1965},
  {1818, 1911, 1965},
  {1818, 1860, 1911},
  {1764, 1790, 1913},
  {1791, 1916, 1917},
  {1870, 1918, 1873},
  {1821, 1792, 1973},
  {1821, 1973, 1916},
  {1792, 1920, 1973},
  {1920, 1738, 1973},
  {1923, 1925, 1924},
  {1875, 1969, 1921},
  {1922, 1977, 1825},
  {1924, 1925, 1926},
  {1969, 1875, 1976},
  {1826, 1876, 1979},
  {1877, 2030, 1978},
  {1927, 1928, 1979},
  {2079, 1979, 1928},
  {1828, 2031, 2037},
  {1797, 2030, 1877},
  {1828, 2037, 1878},
  {1879, 1882, 1880},
  {1930, 1880, 1882},
  {1931, 1880, 1930},
  {1882, 1934, 1930},
  {1932, 1881, 1883},
  {1881, 1932, 1882},
  {1934, 1882, 1932},
  {1883, 1984, 1933},
  {1883, 1933, 1932},
  {1932, 1933, 1934},
  {1884, 1935, 1938},
  {1933, 1936, 1934},
  {1934, 1936, 1983},
  {2198, 1834, 2041},
  {1834, 2198, 1885},
  {1983, 1936, 1937},
  {1939, 1835, 1940},
  {1835, 1939, 1984},
  {1888, 1836, 1941},
  {2045, 1780, 1988},
  {1943, 1989, 1836},
  {1780, 2045, 2144},
  {1888, 1989, 1841},
  {1889, 1808, 1891},
  {1841, 1989, 1892},
  {1945, 1893, 1943},
  {1780, 2144, 1991},
  {1892, 1989, 1943},
  {1990, 1890, 1842},
  {1893, 1945, 1894},
  {1946, 1990, 1842},
  {1810, 1894, 1945},
  {1846, 1947, 1843},
  {1946, 1845, 1993},
  {1846, 2049, 1947},
  {1845, 1811, 1993},
  {2212, 1993, 1811},
  {1948, 1949, 1847},
  {1948, 1847, 1848},
  {1847, 1950, 1896},
  {1950, 1949, 1994},
  {1949, 1950, 1847},
  {1951, 1997, 1848},
  {1999, 1851, 1850},
  {1851, 2053, 1849},
  {1849, 2053, 1953},
  {1900, 1952, 1812},
  {2097, 2094, 1784},
  {1899, 2057, 1955},
  {1899, 1955, 2003},
  {1899, 1785, 2057},
  {1956, 1902, 2004},
  {1785, 2005, 2057},
  {1903, 2101, 1904},
  {1785, 1958, 2005},
  {1956, 1906, 1902},
  {1906, 1956, 2006},
  {1960, 2233, 1962},
  {2062, 1906, 2006},
  {1962, 2233, 2065},
  {1904, 1957, 1963},
  {1904, 1963, 1854},
  {1854, 1963, 1961},
  {1816, 1962, 1908},
  {2011, 1961, 1963},
  {1962, 2013, 1908},
  {1817, 1964, 2108},
  {1908, 2013, 1911},
  {1817, 1862, 1964},
  {2066, 1964, 1862},
  {1867, 1859, 1791},
  {1965, 1915, 1912},
  {1861, 1863, 2113},
  {2066, 1862, 1864},
  {1864, 1819, 2066},
  {1913, 2066, 1819},
  {1863, 1866, 2237},
  {1913, 1790, 1859},
  {2237, 1870, 1914},
  {1915, 1966, 1765},
  {1966, 2120, 1820},
  {1820, 2120, 2020},
  {1918, 1872, 2072},
  {5888, 1918, 2018},
  {1918, 5888, 1873},
  {2020, 1919, 1820},
  {2020, 1967, 1919},
  {1822, 1919, 1970},
  {1919, 1967, 1970},
  {1970, 1967, 2125},
  {2025, 1923, 1924},
  {1923, 2025, 1971},
  {1972, 1971, 2025},
  {1925, 1923, 1971},
  {1971, 1972, 1925},
  {1922, 1974, 2028},
  {2248, 1922, 1874},
  {1874, 1970, 2248},
  {1975, 1926, 1925},
  {1922, 2028, 1977},
  {1980, 1927, 1824},
  {1976, 1875, 1978},
  {2031, 1826, 1979},
  {1927, 1980, 1928},
  {1977, 1929, 1825},
  {1980, 1824, 1977},
  {1824, 1929, 1977},
  {2081, 1981, 2196},
  {2038, 2196, 1981},
  {1930, 1982, 1931},
  {1931, 1982, 1935},
  {1930, 1934, 1982},
  {1935, 1982, 1938},
  {1933, 1984, 1936},
  {1934, 1983, 1982},
  {1982, 1985, 1938},
  {2040, 1940, 2039},
  {1940, 2040, 1939},
  {2042, 1939, 2040},
  {1939, 2042, 1984},
  {1936, 1984, 1987},
  {1936, 1987, 1937},
  {1937, 1987, 1983},
  {1938, 1985, 1986},
  {2044, 1983, 1987},
  {1983, 2044, 1982},
  {1886, 2198, 1945},
  {1836, 1989, 1941},
  {1809, 1988, 1837},
  {1989, 1888, 1941},
  {1843, 1988, 1809},
  {1988, 1843, 2086},
  {2047, 2086, 1843},
  {1990, 1944, 1890},
  {2206, 1992, 2144},
  {1810, 1945, 1895},
  {1948, 2146, 1949},
  {1722, 1951, 1898},
  {1950, 2052, 1896},
  {1998, 1896, 2052},
  {1950, 2092, 2052},
  {1686, 1996, 1995},
  {1897, 2285, 1996},
  {1948, 1848, 1997},
  {1896, 1998, 1999},
  {1952, 2150, 1897},
  {2002, 2151, 1952},
  {2002, 1952, 1900},
  {2094, 2096, 1784},
  {2057, 2054, 1955},
  {1900, 2003, 2002},
  {1954, 1784, 2096},
  {2006, 1956, 2056},
  {1958, 2106, 2005},
  {2007, 1957, 2059},
  {1959, 2064, 1960},
  {2007, 2009, 1957},
  {1905, 1961, 2008},
  {1905, 2064, 1959},
  {1905, 2008, 2064},
  {1906, 2062, 1909},
  {1957, 2009, 1963},
  {2064, 1961, 2011},
  {1961, 2064, 2008},
  {1962, 2065, 2013},
  {2012, 2064, 2011},
  {1857, 1910, 2010},
  {2067, 2014, 2013},
  {2013, 2014, 1911},
  {1909, 1913, 1859},
  {2014, 1965, 1911},
  {1859, 1790, 1791},
  {1965, 2016, 2015},
  {2014, 2016, 1965},
  {2115, 1965, 2015},
  {1915, 1965, 2115},
  {1915, 2115, 1966},
  {1914, 1873, 2068},
  {2068, 1873, 5888},
  {2068, 5888, 2019},
  {2177, 1917, 1916},
  {1917, 2177, 1872},
  {2071, 2017, 2021},
  {1916, 1973, 2074},
  {2020, 2124, 1967},
  {2021, 2017, 2022},
  {1968, 1921, 2023},
  {2024, 2023, 1921},
  {2024, 1921, 1969},
  {2021, 2022, 2025},
  {1972, 2025, 2022},
  {1738, 1968, 1973},
  {2023, 1973, 1968},
  {1974, 1922, 2026},
  {2023, 2074, 1973},
  {1974, 2026, 2077},
  {1922, 2248, 2128},
  {1926, 1975, 1924},
  {2027, 1924, 1975},
  {2028, 1974, 2032},
  {1975, 1925, 2027},
  {2029, 2027, 1925},
  {2033, 1976, 1978},
  {2033, 1978, 2030},
  {2079, 2031, 1979},
  {1980, 2034, 1928},
  {1980, 1977, 2032},
  {2030, 1797, 2035},
  {2035, 1797, 2036},
  {1981, 2193, 2038},
  {2039, 1940, 2083},
  {1940, 1942, 2083},
  {2084, 1982, 2044},
  {1982, 2084, 1985},
  {2137, 1985, 2084},
  {1985, 2137, 1986},
  {2041, 1986, 2137},
  {2043, 1987, 1984},
  {1987, 2043, 2044},
  {2043, 1984, 2042},
  {2043, 2085, 2044},
  {2046, 1942, 2087},
  {1942, 1944, 2087},
  {2047, 1843, 1947},
  {2144, 2089, 1991},
  {1947, 2049, 2047},
  {1992, 2089, 2144},
  {1992, 2050, 2091},
  {2050, 1992, 2048},
  {1895, 2049, 1846},
  {1951, 1722, 2051},
  {2212, 2672, 1993},
  {2093, 1998, 2052},
  {2285, 1686, 1995},
  {2285, 1995, 1996},
  {1997, 1951, 1948},
  {2150, 2285, 1897},
  {1851, 1999, 2093},
  {1851, 2093, 2287},
  {1851, 2287, 2053},
  {1955, 2054, 2003},
  {2003, 2054, 2152},
  {2003, 2152, 2002},
  {1954, 2096, 2231},
  {1954, 2231, 2055},
  {1954, 2055, 2155},
  {1954, 2155, 1901},
  {2056, 1956, 2095},
  {2095, 1956, 2004},
  {2101, 1903, 1901},
  {2102, 1904, 2101},
  {2056, 2058, 2006},
  {1957, 1904, 2102},
  {1957, 2102, 2059},
  {2062, 2006, 2058},
  {2100, 2060, 2007},
  {2100, 2098, 2060},
  {2109, 2060, 2098},
  {1960, 2064, 2061},
  {2060, 2109, 2007},
  {1909, 2062, 2107},
  {2010, 2063, 1857},
  {2111, 2009, 2007},
  {2010, 1910, 2161},
  {1861, 2161, 1910},
  {2007, 2110, 2111},
  {2009, 2111, 1963},
  {2065, 2067, 2013},
  {1963, 2111, 2011},
  {2237, 2113, 1863},
  {2014, 2015, 2016},
  {2115, 2015, 2067},
  {2015, 2014, 2067},
  {2068, 2019, 2171},
  {2019, 2069, 2171},
  {2119, 2017, 2117},
  {2074, 2177, 1916},
  {2177, 2072, 1872},
  {2072, 2018, 1918},
  {2018, 2019, 5888},
  {2019, 2122, 2069},
  {2070, 2069, 2122},
  {2071, 2021, 2073},
  {2022, 2017, 2180},
  {1970, 2125, 2248},
  {2021, 2025, 1924},
  {2021, 1924, 2073},
  {2022, 2126, 1972},
  {2074, 2023, 2075},
  {1924, 2027, 2073},
  {2076, 2073, 2027},
  {1972, 2126, 2078},
  {2026, 2129, 2077},
  {1972, 2078, 1925},
  {1974, 2077, 2032},
  {2027, 2029, 2076},
  {1977, 2028, 2032},
  {2185, 2076, 2029},
  {1925, 2078, 2029},
  {2080, 2029, 2078},
  {1980, 2032, 2034},
  {2032, 2077, 2131},
  {2032, 2131, 2034},
  {2029, 2080, 2185},
  {2031, 2079, 2133},
  {2031, 2133, 2037},
  {2034, 2131, 2189},
  {2034, 2189, 1928},
  {2030, 2035, 2033},
  {1928, 2261, 2079},
  {2036, 2081, 2035},
  {2036, 1797, 2081},
  {1928, 2189, 2261},
  {2035, 2081, 2134},
  {2037, 2133, 1981},
  {2082, 2039, 2200},
  {2039, 2082, 2040},
  {1885, 2198, 1886},
  {2040, 2082, 2042},
  {2274, 2042, 2082},
  {1942, 2140, 2083},
  {2042, 2138, 2043},
  {2044, 2085, 2084},
  {2084, 2203, 2137},
  {1942, 2046, 2140},
  {2085, 2043, 2138},
  {2088, 2086, 2047},
  {2142, 2087, 1944},
  {2145, 2142, 1944},
  {1944, 1990, 2145},
  {1990, 1946, 2461},
  {1991, 2089, 2146},
  {2047, 2049, 2208},
  {2089, 1992, 2091},
  {2050, 2048, 2091},
  {2048, 2090, 2091},
  {1991, 2146, 2051},
  {2146, 2089, 1949},
  {2089, 2091, 1949},
  {1949, 2091, 1994},
  {2091, 2148, 1994},
  {2051, 1948, 1951},
  {1950, 2401, 2092},
  {1998, 2093, 1999},
  {1952, 2151, 2150},
  {1756, 2000, 2149},
  {2000, 2001, 2149},
  {2056, 2095, 2225},
  {1784, 1756, 2230},
  {2149, 2216, 1756},
  {2154, 2056, 2153},
  {2154, 2058, 2056},
  {2157, 2058, 2154},
  {2004, 1852, 2156},
  {2100, 2007, 2059},
  {2157, 2062, 2058},
  {2099, 2103, 2109},
  {2099, 2109, 2098},
  {2233, 1960, 2061},
  {2005, 2106, 2104},
  {2005, 2104, 2057},
  {2064, 2158, 2061},
  {1958, 2108, 2106},
  {2107, 2106, 2108},
  {2007, 2109, 2110},
  {2063, 2010, 2161},
  {2107, 2112, 1909},
  {2108, 2112, 2107},
  {1913, 2112, 2066},
  {2112, 1913, 1909},
  {2066, 2108, 1964},
  {2108, 2066, 2112},
  {2115, 2067, 2114},
  {2067, 2235, 2114},
  {2353, 1966, 2115},
  {2240, 2117, 2116},
  {2118, 2117, 2240},
  {2117, 2118, 2119},
  {2120, 1966, 2353},
  {2180, 2017, 2119},
  {2070, 2178, 2306},
  {2122, 2178, 2070},
  {2178, 2123, 2306},
  {2120, 2124, 2020},
  {2071, 2121, 2174},
  {2019, 2018, 2072},
  {2124, 2246, 1967},
  {1967, 2246, 2125},
  {2249, 2071, 2073},
  {2178, 2179, 2123},
  {2022, 2180, 2126},
  {2127, 2075, 2023},
  {2023, 2024, 2127},
  {2024, 1969, 2127},
  {2181, 2127, 1969},
  {1969, 1976, 2181},
  {2128, 2129, 2026},
  {2026, 1922, 2128},
  {2075, 2130, 2074},
  {2127, 2130, 2075},
  {2181, 1976, 2250},
  {2182, 2073, 2076},
  {2033, 2250, 1976},
  {2128, 2248, 2184},
  {2129, 2251, 2077},
  {2256, 2182, 2076},
  {2188, 2250, 2033},
  {2076, 2185, 2256},
  {2077, 2251, 2186},
  {2077, 2186, 2131},
  {2080, 2078, 2260},
  {2131, 2132, 2189},
  {2035, 2188, 2033},
  {2189, 2132, 2190},
  {2035, 2381, 2188},
  {2035, 2134, 2381},
  {2133, 2193, 1981},
  {2134, 2081, 2383},
  {2081, 2196, 2135},
  {2199, 2082, 2200},
  {2039, 2083, 2140},
  {2042, 2274, 2138},
  {2045, 2139, 2144},
  {2203, 2084, 2085},
  {2045, 2088, 2139},
  {2086, 2045, 1988},
  {2088, 2045, 2086},
  {2204, 2140, 2046},
  {2046, 2141, 2204},
  {2046, 2087, 2141},
  {2087, 2142, 2141},
  {2088, 2143, 2139},
  {2047, 2207, 2088},
  {1990, 2461, 2145},
  {2088, 2207, 2143},
  {2207, 2047, 2208},
  {2209, 2048, 1992},
  {1946, 1993, 2461},
  {2049, 1895, 2520},
  {2048, 2209, 2090},
  {2049, 2520, 2208},
  {2147, 2091, 2090},
  {2147, 2148, 2091},
  {2051, 2146, 1948},
  {2148, 2401, 1994},
  {2093, 2052, 2213},
  {2401, 1950, 1994},
  {2218, 2224, 2216},
  {2149, 2001, 2287},
  {2001, 2053, 2287},
  {2152, 2054, 2222},
  {2097, 1784, 2230},
  {2096, 2094, 2231},
  {2094, 2097, 2231},
  {2097, 2230, 2231},
  {2098, 2100, 2226},
  {2098, 2226, 2099},
  {2155, 2101, 1901},
  {2055, 2231, 2155},
  {2054, 2057, 2227},
  {2099, 2290, 2103},
  {2100, 2059, 2229},
  {2155, 2231, 2101},
  {2292, 2059, 2102},
  {2232, 2227, 2057},
  {2156, 1852, 2159},
  {2292, 2102, 2101},
  {2157, 2348, 2062},
  {2105, 2159, 1852},
  {2057, 2104, 2232},
  {2348, 2107, 2062},
  {2159, 2105, 2234},
  {2107, 2104, 2106},
  {2105, 2063, 2161},
  {2103, 2160, 2109},
  {2234, 2105, 2161},
  {2109, 2160, 2297},
  {2109, 2297, 2110},
  {2161, 1861, 2162},
  {2297, 2111, 2110},
  {2162, 1861, 2163},
  {2164, 2161, 2162},
  {2164, 2162, 2165},
  {2162, 2163, 2167},
  {2163, 2113, 2167},
  {2163, 1861, 2113},
  {2065, 2235, 2067},
  {2164, 2165, 2482},
  {2164, 2482, 2161},
  {2165, 2162, 2167},
  {2235, 2298, 2114},
  {2482, 2165, 2166},
  {2165, 2167, 2166},
  {2167, 2113, 2168},
  {2482, 2166, 2239},
  {2168, 2113, 2169},
  {2166, 2167, 2170},
  {2167, 2168, 2170},
  {2239, 2170, 2168},
  {2166, 2170, 2239},
  {2118, 2242, 2119},
  {2116, 2174, 2172},
  {2172, 2240, 2116},
  {2070, 2171, 2069},
  {2121, 2175, 2174},
  {2176, 2174, 2175},
  {2175, 2121, 2176},
  {2307, 2121, 2071},
  {2071, 2249, 2307},
  {2019, 2072, 2122},
  {2313, 2129, 2128},
  {2073, 2314, 2249},
  {2073, 2182, 2314},
  {2126, 2316, 2183},
  {2127, 2181, 2252},
  {2127, 2252, 2130},
  {2126, 2183, 2078},
  {2260, 2078, 2258},
  {2131, 2186, 2132},
  {2187, 2186, 2321},
  {2080, 2260, 2259},
  {2080, 2259, 2185},
  {2132, 2186, 2187},
  {2132, 2187, 2190},
  {2133, 2079, 2193},
  {2079, 2261, 2193},
  {2187, 2191, 2190},
  {2190, 2191, 2323},
  {2191, 2192, 2323},
  {2323, 2192, 2194},
  {2323, 2194, 2195},
  {2081, 2135, 2383},
  {2196, 2325, 2135},
  {2271, 2197, 2266},
  {2199, 2268, 2082},
  {2198, 2041, 2201},
  {2136, 2201, 2041},
  {2201, 2136, 2202},
  {2041, 2202, 2136},
  {2202, 2041, 2137},
  {2202, 2137, 2203},
  {2140, 2275, 2039},
  {2276, 2279, 2139},
  {2139, 2279, 2144},
  {2143, 2205, 2139},
  {2143, 2280, 2205},
  {2142, 2145, 2141},
  {1945, 2198, 1895},
  {2207, 2280, 2143},
  {2144, 2279, 2206},
  {2210, 2147, 2211},
  {2090, 2211, 2147},
  {2211, 2090, 2209},
  {2147, 2210, 2337},
  {1754, 2285, 2212},
  {2213, 2052, 2092},
  {2213, 2342, 2093},
  {2216, 2214, 2404},
  {2217, 2093, 2342},
  {2216, 2404, 2218},
  {2214, 2216, 2149},
  {2344, 2285, 2150},
  {2214, 2149, 2215},
  {2149, 2287, 2215},
  {2093, 2217, 2287},
  {2218, 2466, 2224},
  {2151, 2219, 2150},
  {2152, 2151, 2002},
  {2152, 2219, 2151},
  {2220, 2223, 2345},
  {2153, 2345, 2223},
  {2221, 2345, 2153},
  {2153, 2056, 2221},
  {2289, 2223, 2220},
  {2223, 2154, 2153},
  {2227, 2222, 2054},
  {2289, 2154, 2223},
  {2224, 1756, 2216},
  {2293, 2225, 2095},
  {2099, 2228, 2290},
  {2100, 2229, 2226},
  {2292, 2229, 2059},
  {2157, 2154, 2289},
  {2095, 2004, 2156},
  {2095, 2156, 2293},
  {2101, 2408, 2292},
  {2232, 2104, 2107},
  {2296, 2156, 2159},
  {2290, 2294, 2103},
  {2295, 2103, 2294},
  {2412, 2158, 2064},
  {2233, 2061, 2158},
  {2296, 2159, 2234},
  {2160, 2103, 2295},
  {2412, 2064, 2012},
  {2111, 2297, 2352},
  {2233, 2298, 2235},
  {2235, 2065, 2233},
  {2299, 2114, 2298},
  {2115, 2114, 2299},
  {2168, 2169, 2239},
  {2236, 2239, 2169},
  {2169, 2113, 2236},
  {2237, 2236, 2113},
  {2301, 2239, 2236},
  {2237, 2301, 2236},
  {2239, 2301, 2173},
  {2237, 1914, 2238},
  {2068, 2238, 1914},
  {2240, 2241, 2118},
  {2118, 2241, 2242},
  {2244, 2119, 2243},
  {2119, 2242, 2243},
  {2353, 2304, 2120},
  {2124, 2120, 2304},
  {2172, 2174, 2176},
  {2172, 2176, 2245},
  {2171, 2070, 2306},
  {2176, 2121, 2245},
  {2308, 2119, 2244},
  {2246, 2359, 2125},
  {2121, 2307, 2245},
  {2119, 2308, 2180},
  {2074, 2130, 2072},
  {2074, 2072, 2177},
  {2123, 2179, 2247},
  {2248, 2125, 2359},
  {2309, 2180, 2308},
  {2180, 2309, 2126},
  {2316, 2126, 2309},
  {2072, 2311, 2122},
  {2122, 2311, 2178},
  {2179, 2178, 2311},
  {2130, 2315, 2072},
  {2315, 2130, 2252},
  {2181, 2250, 2253},
  {2441, 2128, 2184},
  {2438, 2441, 2184},
  {2256, 2314, 2182},
  {2253, 2252, 2181},
  {2258, 2078, 2183},
  {2183, 2316, 2258},
  {2185, 2257, 2256},
  {2251, 2321, 2186},
  {2257, 2185, 2254},
  {2259, 2254, 2185},
  {2189, 2446, 2261},
  {2192, 2380, 2194},
  {2193, 2261, 2038},
  {2134, 2383, 2381},
  {2038, 2261, 2196},
  {2195, 2262, 2384},
  {2383, 2135, 2263},
  {2383, 2263, 2324},
  {2262, 2195, 2387},
  {2264, 2197, 2265},
  {2264, 2265, 2328},
  {2264, 2266, 2197},
  {2265, 2197, 2271},
  {2265, 2271, 2267},
  {2265, 2267, 2330},
  {2265, 2330, 2328},
  {2267, 2392, 2331},
  {2267, 2331, 2330},
  {2199, 2200, 2394},
  {2199, 2392, 2268},
  {2392, 2267, 2269},
  {2267, 2271, 2269},
  {2198, 2201, 2202},
  {2082, 2268, 2274},
  {2269, 2271, 2270},
  {2202, 2273, 2198},
  {2269, 2270, 2085},
  {2272, 2270, 2271},
  {2271, 2198, 2272},
  {2273, 2272, 2198},
  {2275, 2200, 2039},
  {2274, 2269, 2138},
  {2274, 2332, 2269},
  {2269, 2085, 2138},
  {2270, 2272, 2085},
  {2203, 2085, 2272},
  {2272, 2273, 2203},
  {2273, 2202, 2203},
  {2204, 2141, 2334},
  {2276, 2139, 2278},
  {2205, 2277, 2139},
  {2139, 2277, 2278},
  {2141, 2145, 2334},
  {2205, 2280, 2335},
  {2205, 2335, 2277},
  {2277, 2335, 2278},
  {2280, 2281, 2335},
  {2281, 2282, 2335},
  {2461, 1993, 2672},
  {2281, 2671, 2282},
  {2671, 2283, 2282},
  {2335, 2282, 2283},
  {2147, 2337, 2336},
  {2671, 2284, 2283},
  {2339, 2401, 2147},
  {2148, 2147, 2401},
  {2212, 2285, 2344},
  {2092, 2341, 2213},
  {2213, 2341, 2342},
  {2404, 2214, 2343},
  {2214, 2215, 2403},
  {2404, 2286, 2218},
  {2217, 2342, 2215},
  {2150, 2219, 2344},
  {2215, 2287, 2217},
  {2219, 2152, 2406},
  {2289, 2220, 2288},
  {2221, 2056, 2225},
  {2221, 2225, 2293},
  {2099, 2347, 2228},
  {2099, 2226, 2347},
  {2226, 2229, 2408},
  {2466, 2230, 1756},
  {2466, 1756, 2224},
  {2229, 2292, 2408},
  {2227, 2291, 2222},
  {2227, 2232, 2291},
  {2291, 2348, 2410},
  {2107, 2291, 2232},
  {2291, 2107, 2348},
  {2293, 2156, 2296},
  {2414, 2293, 2296},
  {2160, 2295, 2351},
  {2160, 2351, 2297},
  {2234, 2161, 2414},
  {2011, 2111, 2352},
  {2353, 2115, 2299},
  {2482, 2239, 2300},
  {2300, 2239, 2173},
  {2301, 2237, 2302},
  {2237, 2238, 2302},
  {2238, 2068, 2302},
  {2242, 2423, 2243},
  {2303, 2243, 2423},
  {2304, 2305, 2124},
  {2241, 2356, 2242},
  {2243, 2303, 2244},
  {2431, 2244, 2303},
  {2360, 2244, 2431},
  {2171, 2306, 2426},
  {2124, 2305, 2246},
  {2172, 2245, 2240},
  {2247, 2306, 2123},
  {2359, 2432, 2438},
  {2359, 2438, 2248},
  {2311, 2312, 2179},
  {2179, 2312, 2247},
  {2247, 2312, 2367},
  {2248, 2438, 2184},
  {2313, 2251, 2129},
  {2128, 2441, 2313},
  {2250, 2317, 2253},
  {2250, 2318, 2317},
  {2252, 2253, 2373},
  {2253, 2317, 2373},
  {2250, 2188, 2318},
  {2314, 2254, 2319},
  {2254, 2314, 2257},
  {2314, 2256, 2257},
  {2315, 2373, 2374},
  {2373, 2317, 2320},
  {2188, 2376, 2318},
  {2254, 2255, 2319},
  {2378, 2258, 2316},
  {2255, 2322, 2319},
  {2255, 2254, 2322},
  {2254, 2259, 2322},
  {2258, 2378, 2260},
  {2376, 2188, 2506},
  {2187, 2380, 2191},
  {2382, 2261, 2448},
  {2191, 2380, 2192},
  {2194, 2380, 2195},
  {2506, 2188, 2381},
  {2382, 2386, 2261},
  {2323, 2195, 2384},
  {2261, 2325, 2196},
  {2383, 2324, 2385},
  {2135, 2324, 2263},
  {2386, 2324, 2135},
  {2388, 2384, 2387},
  {2325, 2386, 2135},
  {2450, 2389, 2327},
  {2389, 2264, 2327},
  {2264, 2451, 2266},
  {2450, 2327, 2326},
  {2328, 2326, 2327},
  {2328, 2327, 2264},
  {2452, 2326, 2329},
  {2326, 2328, 2329},
  {2329, 2199, 2452},
  {2454, 2391, 2198},
  {2199, 2394, 2452},
  {2331, 2392, 2329},
  {2266, 2390, 2271},
  {2271, 2390, 2454},
  {2454, 2198, 2271},
  {2392, 2269, 2332},
  {2268, 2332, 2274},
  {2268, 2392, 2332},
  {2275, 2394, 2200},
  {2275, 2140, 2333},
  {2140, 2204, 2333},
  {2333, 2204, 2519},
  {2204, 2334, 2519},
  {2145, 2461, 2334},
  {2278, 2462, 2397},
  {2570, 2206, 2279},
  {1992, 2206, 2570},
  {2278, 2335, 2462},
  {2280, 2671, 2281},
  {2210, 5891, 2337},
  {2208, 2520, 2207},
  {2207, 2671, 2280},
  {2283, 2284, 2335},
  {2398, 2335, 2284},
  {2338, 2147, 2336},
  {2284, 2340, 2398},
  {2212, 2344, 2572},
  {2401, 2339, 2400},
  {2401, 2404, 2092},
  {2092, 2402, 2341},
  {2343, 2214, 2403},
  {2215, 2402, 2403},
  {2402, 2215, 2342},
  {2218, 2286, 2466},
  {2405, 2288, 2220},
  {2405, 2220, 2345},
  {2346, 2152, 2222},
  {2406, 2152, 2346},
  {2530, 2345, 2221},
  {2221, 2293, 2530},
  {2226, 2408, 2347},
  {2289, 2288, 2529},
  {2348, 2289, 2529},
  {2407, 2231, 2230},
  {2289, 2348, 2157},
  {2290, 2349, 2294},
  {2349, 2472, 2294},
  {2294, 2472, 2295},
  {2412, 2012, 2584},
  {2011, 2584, 2012},
  {2414, 2296, 2234},
  {2233, 2158, 2350},
  {2299, 2298, 2419},
  {2302, 2068, 2171},
  {2302, 2171, 2355},
  {2424, 2305, 2304},
  {2242, 2356, 2354},
  {2242, 2354, 2423},
  {2301, 2302, 2173},
  {2302, 2355, 2173},
  {2305, 2359, 2246},
  {2305, 2432, 2359},
  {2433, 2354, 2356},
  {2357, 2303, 2423},
  {2303, 2357, 2431},
  {2355, 2358, 2173},
  {2245, 2241, 2240},
  {2241, 2245, 2356},
  {2245, 2433, 2356},
  {2244, 2360, 2308},
  {2366, 2430, 2429},
  {2363, 2245, 2307},
  {2308, 2360, 2495},
  {2365, 2366, 2429},
  {2432, 2430, 2366},
  {2247, 2367, 2364},
  {2362, 2363, 2310},
  {2363, 2314, 2310},
  {2363, 2249, 2314},
  {2363, 2307, 2249},
  {2308, 2495, 2368},
  {2308, 2368, 2309},
  {2312, 2369, 2367},
  {2367, 2370, 2364},
  {2315, 2374, 2072},
  {2311, 2072, 2374},
  {2311, 2369, 2312},
  {2367, 2369, 2370},
  {2309, 2368, 2316},
  {2310, 2314, 2319},
  {2310, 2319, 2371},
  {2372, 2316, 2368},
  {2315, 2252, 2373},
  {2319, 2322, 2371},
  {2373, 2377, 2374},
  {2373, 2320, 2377},
  {2320, 2317, 2375},
  {2317, 2318, 2376},
  {2316, 2372, 2378},
  {2187, 2321, 2444},
  {2322, 2259, 2445},
  {2260, 2445, 2259},
  {2448, 2261, 2379},
  {2446, 2379, 2261},
  {2190, 2446, 2189},
  {2381, 2383, 2557},
  {2262, 2387, 2384},
  {2385, 2324, 2382},
  {2386, 2382, 2324},
  {2386, 2325, 2261},
  {2326, 2452, 2450},
  {2328, 2330, 2329},
  {2329, 2330, 2331},
  {2266, 2451, 2390},
  {2329, 2392, 2199},
  {2390, 2453, 2454},
  {2391, 2393, 2198},
  {2391, 2454, 2395},
  {2391, 2395, 2393},
  {2395, 2396, 2393},
  {2394, 2275, 2457},
  {2275, 2567, 2457},
  {2275, 2333, 2567},
  {2276, 2397, 2279},
  {2276, 2278, 2397},
  {2461, 2519, 2334},
  {2397, 2462, 2279},
  {2570, 2279, 2462},
  {2209, 1992, 2570},
  {2522, 2336, 2337},
  {2337, 5891, 2522},
  {2147, 2338, 2339},
  {2336, 2522, 2338},
  {2463, 2398, 2340},
  {2572, 2850, 2212},
  {2284, 2674, 2340},
  {2399, 2400, 2339},
  {2092, 2404, 2403},
  {2402, 2342, 2341},
  {2406, 2344, 2219},
  {2405, 2465, 2288},
  {2406, 2346, 2467},
  {2530, 2405, 2345},
  {2407, 2230, 2466},
  {2529, 2410, 2348},
  {2290, 2470, 2409},
  {2290, 2409, 2349},
  {2222, 2291, 2410},
  {2349, 2409, 2411},
  {2349, 2411, 2413},
  {2413, 2411, 2532},
  {2349, 2413, 2472},
  {2158, 2412, 2350},
  {2412, 2416, 2415},
  {2412, 2415, 2417},
  {2295, 2473, 2351},
  {2412, 2417, 2350},
  {2011, 2352, 2730},
  {2350, 2417, 2474},
  {2350, 2474, 2233},
  {2417, 2415, 2474},
  {2298, 2233, 2474},
  {2476, 2352, 2297},
  {2730, 2352, 2476},
  {2298, 2474, 2477},
  {2418, 2479, 2422},
  {2161, 2482, 2421},
  {2298, 2477, 2419},
  {2299, 2419, 2353},
  {2422, 2479, 2420},
  {2420, 2423, 2422},
  {2422, 2423, 2425},
  {2422, 2425, 2484},
  {2353, 2538, 2304},
  {2424, 2304, 2594},
  {2424, 2432, 2305},
  {2425, 2423, 2354},
  {2300, 2427, 2482},
  {2426, 2358, 2355},
  {2355, 2171, 2426},
  {2423, 2539, 2357},
  {2431, 2357, 2539},
  {2427, 2300, 2173},
  {2358, 2426, 2428},
  {2306, 2428, 2426},
  {2365, 2429, 2734},
  {2483, 2734, 2429},
  {2429, 2430, 2483},
  {2427, 2173, 2435},
  {2490, 2435, 2173},
  {2431, 2485, 2434},
  {2431, 2361, 2360},
  {2431, 2434, 2495},
  {2431, 2495, 2361},
  {2363, 2362, 2433},
  {2362, 2437, 2433},
  {2245, 2363, 2433},
  {2360, 2361, 2495},
  {2173, 2358, 2490},
  {2493, 2490, 2358},
  {2362, 2543, 2437},
  {2358, 2436, 2493},
  {2364, 2370, 2440},
  {2310, 2371, 2439},
  {2310, 2439, 2362},
  {2371, 2501, 2439},
  {2372, 2368, 2496},
  {2369, 2311, 2374},
  {2369, 2500, 2370},
  {2440, 2370, 2500},
  {2317, 2376, 2375},
  {2374, 2377, 2442},
  {2377, 2320, 2443},
  {2320, 2375, 2443},
  {2506, 2443, 2375},
  {2375, 2376, 2506},
  {2507, 2378, 2372},
  {2380, 2187, 2444},
  {2445, 2501, 2322},
  {2611, 2445, 2260},
  {2260, 2378, 2611},
  {2507, 2611, 2378},
  {2508, 2506, 2381},
  {2446, 2190, 2556},
  {2323, 2556, 2190},
  {2379, 2610, 2448},
  {2195, 2447, 2387},
  {2382, 2448, 2385},
  {2559, 2557, 2383},
  {2384, 2388, 2449},
  {2264, 2389, 2451},
  {2394, 2563, 2452},
  {2390, 2451, 2512},
  {2390, 2512, 2456},
  {2454, 2396, 2395},
  {2390, 2456, 2453},
  {2454, 2453, 2455},
  {2454, 2455, 2663},
  {2454, 2663, 2396},
  {2396, 2663, 2393},
  {2393, 2663, 2198},
  {2453, 2459, 2458},
  {2453, 2458, 2455},
  {2455, 2458, 2663},
  {2394, 2457, 2513},
  {2453, 2456, 2459},
  {2663, 2458, 2460},
  {2458, 2459, 2460},
  {2461, 2521, 2519},
  {2335, 2398, 2570},
  {2570, 2398, 2571},
  {2398, 2463, 2571},
  {2338, 2522, 2339},
  {2463, 2340, 2464},
  {2284, 2671, 2674},
  {2092, 2403, 2402},
  {2400, 2399, 2404},
  {2400, 2404, 2401},
  {2403, 2404, 2343},
  {2286, 2404, 2399},
  {2344, 2524, 2523},
  {2344, 2573, 2524},
  {2406, 2467, 2344},
  {2528, 2344, 2467},
  {2529, 2288, 2465},
  {2469, 2407, 2466},
  {2346, 2222, 2468},
  {2290, 2228, 2470},
  {2222, 2410, 2468},
  {2412, 2584, 2416},
  {2413, 2471, 2472},
  {2413, 2532, 2471},
  {2472, 2471, 2534},
  {2532, 2533, 2471},
  {2472, 2473, 2295},
  {2474, 2415, 2416},
  {2475, 2351, 2473},
  {2351, 2475, 2297},
  {2478, 2414, 2161},
  {2476, 2297, 2475},
  {2478, 2161, 2421},
  {2480, 2420, 2479},
  {2480, 2481, 2539},
  {2480, 2539, 2420},
  {2420, 2539, 2423},
  {2422, 2484, 2418},
  {2594, 2483, 2424},
  {2424, 2483, 2432},
  {2542, 2482, 2427},
  {2594, 2734, 2483},
  {2483, 2430, 2432},
  {2427, 2435, 2542},
  {2428, 2306, 2486},
  {2425, 2354, 2488},
  {2433, 2488, 2354},
  {2425, 2488, 2484},
  {2539, 2485, 2431},
  {2358, 2428, 2491},
  {2486, 2491, 2428},
  {2486, 2306, 2247},
  {2433, 2437, 2488},
  {2434, 2485, 2489},
  {2434, 2489, 2495},
  {2490, 2542, 2435},
  {2492, 2488, 2437},
  {2490, 2493, 2649},
  {2436, 2358, 2649},
  {2247, 2364, 2599},
  {2494, 2599, 2364},
  {2437, 2543, 2492},
  {2493, 2436, 2649},
  {2494, 2364, 2440},
  {2494, 2440, 2499},
  {2432, 2366, 2438},
  {2368, 2495, 2496},
  {2438, 2366, 2735},
  {2441, 2438, 2735},
  {2439, 2501, 2497},
  {2439, 2497, 2362},
  {2372, 2496, 2547},
  {2369, 2374, 2500},
  {2500, 2498, 2440},
  {2499, 2440, 2498},
  {2321, 2251, 2545},
  {2251, 2546, 2545},
  {2444, 2321, 2545},
  {2371, 2322, 2501},
  {2372, 2547, 2502},
  {2442, 2377, 2503},
  {2442, 2503, 2549},
  {2377, 2504, 2503},
  {2443, 2554, 2377},
  {2443, 2505, 2554},
  {2443, 2506, 2505},
  {2372, 2502, 2507},
  {2377, 2554, 2504},
  {2550, 2554, 2505},
  {2556, 2379, 2446},
  {2380, 2447, 2195},
  {2381, 2616, 2508},
  {2448, 2610, 2558},
  {2556, 2323, 2384},
  {2509, 2385, 2558},
  {2558, 2385, 2448},
  {2383, 2385, 2559},
  {2510, 2559, 2385},
  {2385, 2509, 2510},
  {2450, 2561, 2389},
  {2389, 2561, 2622},
  {2389, 2622, 2451},
  {2450, 2452, 2561},
  {2561, 2452, 2511},
  {2452, 2563, 2511},
  {2451, 2562, 2512},
  {2456, 2512, 2564},
  {2563, 2394, 2513},
  {2457, 2567, 2513},
  {2456, 2514, 2459},
  {2515, 2459, 2514},
  {2459, 2516, 2517},
  {2459, 2515, 2516},
  {2517, 2516, 2515},
  {2517, 2518, 2459},
  {2459, 2518, 2460},
  {2333, 2519, 2567},
  {2519, 2521, 2567},
  {2198, 2520, 1895},
  {2520, 2715, 2625},
  {2568, 2521, 2461},
  {2461, 2667, 2568},
  {2570, 2462, 2335},
  {2672, 2755, 2461},
  {2463, 2464, 2626},
  {2464, 2628, 2626},
  {2464, 2340, 2628},
  {2339, 2522, 2627},
  {2339, 2627, 2399},
  {2340, 2674, 2628},
  {2465, 2405, 2630},
  {2717, 2525, 2466},
  {2526, 2525, 2717},
  {2528, 2467, 2527},
  {2466, 2525, 2469},
  {2526, 2469, 2525},
  {2467, 2346, 2527},
  {2468, 2527, 2346},
  {2405, 2530, 2576},
  {2580, 2228, 2347},
  {2410, 2637, 2468},
  {2293, 2867, 2530},
  {2470, 2228, 2578},
  {2579, 2578, 2228},
  {2582, 2580, 2347},
  {2409, 2470, 2531},
  {2411, 2409, 2531},
  {2411, 2531, 2639},
  {2411, 2639, 2532},
  {2416, 2584, 2586},
  {2471, 2683, 2534},
  {2472, 2534, 2588},
  {2471, 2533, 2535},
  {2471, 2535, 2683},
  {2584, 2011, 2685},
  {2533, 2585, 2535},
  {2472, 2588, 2473},
  {2477, 2474, 2642},
  {2473, 2591, 2475},
  {2476, 2475, 2730},
  {2536, 2478, 2593},
  {2536, 2414, 2478},
  {2477, 2592, 2538},
  {2478, 2421, 2593},
  {2419, 2477, 2538},
  {2593, 2421, 2537},
  {2593, 2537, 2481},
  {2482, 2537, 2421},
  {2538, 2353, 2419},
  {2480, 2479, 2418},
  {2595, 2480, 2418},
  {2481, 2537, 2539},
  {2537, 2482, 2539},
  {2538, 2594, 2304},
  {2418, 2484, 2595},
  {2542, 2539, 2482},
  {2484, 2596, 2646},
  {2540, 2485, 2539},
  {2539, 2542, 2540},
  {2487, 2365, 2734},
  {2596, 2484, 2488},
  {2541, 2485, 2540},
  {2540, 2542, 2541},
  {2597, 2486, 2247},
  {2485, 2541, 2489},
  {2495, 2489, 2541},
  {2541, 2542, 2495},
  {2488, 2492, 2596},
  {2542, 2490, 2495},
  {2358, 2491, 2649},
  {2601, 2490, 2649},
  {2362, 2497, 2606},
  {2362, 2606, 2543},
  {2498, 2544, 2499},
  {2251, 2313, 2546},
  {2313, 2651, 2546},
  {2313, 2441, 2651},
  {2548, 2374, 2696},
  {2500, 2548, 2498},
  {2544, 2498, 2548},
  {2374, 2442, 2696},
  {2442, 2549, 2696},
  {2501, 2445, 2551},
  {2501, 2551, 2606},
  {2549, 2503, 2552},
  {2503, 2553, 2552},
  {2503, 2504, 2553},
  {2504, 2554, 2553},
  {2554, 2550, 2655},
  {2505, 2506, 2508},
  {2444, 2555, 2380},
  {2507, 2502, 2613},
  {2654, 2613, 2502},
  {2380, 2555, 2447},
  {2610, 2617, 2558},
  {5889, 2556, 2384},
  {2558, 2617, 2509},
  {2388, 2387, 2619},
  {2617, 2510, 2509},
  {2559, 2510, 2560},
  {2617, 2560, 2510},
  {2451, 2622, 2562},
  {2561, 2511, 2621},
  {2511, 2563, 2623},
  {2563, 2565, 2623},
  {2563, 2513, 2565},
  {2513, 2567, 2565},
  {2456, 2624, 2514},
  {2514, 2517, 2515},
  {2514, 2566, 2517},
  {2518, 2517, 2566},
  {2518, 2569, 2460},
  {2521, 2568, 2567},
  {2715, 2756, 2625},
  {2755, 2667, 2461},
  {2571, 2209, 2570},
  {2207, 2625, 2671},
  {2344, 2523, 2572},
  {2399, 2629, 2675},
  {2675, 2466, 2286},
  {2675, 2286, 2399},
  {2573, 2344, 2528},
  {2574, 2526, 2717},
  {2575, 2528, 2527},
  {2575, 2679, 2528},
  {2526, 2574, 2581},
  {2469, 2526, 2581},
  {2637, 2527, 2468},
  {2578, 2577, 2470},
  {2577, 2634, 2470},
  {2578, 2579, 2761},
  {2580, 2761, 2579},
  {2867, 2576, 2530},
  {2634, 2638, 2531},
  {2531, 2470, 2634},
  {2579, 2228, 2580},
  {2529, 2766, 2410},
  {2636, 2582, 2347},
  {2347, 2408, 2636},
  {2632, 2636, 2408},
  {2766, 2637, 2410},
  {2531, 2638, 2639},
  {2408, 2469, 2581},
  {2583, 2408, 2581},
  {2533, 2587, 2585},
  {2535, 2585, 2683},
  {2585, 2587, 2684},
  {2416, 2586, 2474},
  {2587, 2589, 2684},
  {2536, 2590, 2640},
  {2640, 2414, 2536},
  {2588, 2591, 2473},
  {2475, 2591, 2730},
  {2477, 2642, 2775},
  {2592, 2477, 2775},
  {2590, 2536, 2644},
  {2536, 2593, 2644},
  {2538, 2592, 2594},
  {2480, 2593, 2481},
  {2480, 2595, 2593},
  {2645, 2593, 2595},
  {2646, 2595, 2484},
  {2597, 2491, 2486},
  {2689, 2598, 2596},
  {2599, 2648, 2597},
  {2597, 2247, 2599},
  {2596, 2492, 2689},
  {2691, 2689, 2492},
  {2597, 2649, 2491},
  {2599, 2494, 2648},
  {2604, 2648, 2494},
  {2494, 2499, 2604},
  {2601, 2600, 2490},
  {2490, 2603, 2495},
  {2490, 2600, 2602},
  {2490, 2602, 2603},
  {2487, 2694, 2365},
  {2365, 2694, 2695},
  {2366, 2365, 2735},
  {2492, 2543, 2691},
  {2495, 2603, 2496},
  {2603, 2650, 2496},
  {2441, 2735, 2651},
  {2547, 2496, 2653},
  {2547, 2653, 2502},
  {2374, 2548, 2500},
  {2548, 2696, 2544},
  {2544, 2696, 2605},
  {2544, 2605, 2604},
  {2544, 2604, 2499},
  {2545, 2698, 2739},
  {2545, 2739, 2444},
  {2654, 2502, 2653},
  {2696, 2549, 2552},
  {2505, 2508, 2550},
  {2444, 2739, 2555},
  {2606, 2551, 2607},
  {2552, 2553, 2608},
  {2552, 2608, 2614},
  {2554, 2609, 2553},
  {2554, 2655, 2609},
  {2550, 2508, 2616},
  {2550, 2616, 2655},
  {2445, 2656, 2551},
  {2445, 2611, 2656},
  {2611, 2507, 2612},
  {2507, 2613, 2612},
  {2552, 2614, 2696},
  {2705, 2615, 2614},
  {2619, 2447, 2555},
  {2387, 2447, 2619},
  {2557, 2559, 2381},
  {2618, 2381, 2559},
  {2381, 2618, 2616},
  {5889, 2743, 2556},
  {2837, 2620, 2617},
  {5889, 2619, 2707},
  {2559, 2560, 2620},
  {2560, 2617, 2620},
  {2660, 5889, 2659},
  {2621, 2622, 2561},
  {2621, 2511, 2712},
  {2623, 2712, 2511},
  {2562, 2662, 2512},
  {2512, 2662, 2564},
  {2564, 2624, 2456},
  {2565, 2664, 2623},
  {2624, 2566, 2514},
  {2569, 2713, 2663},
  {2569, 2663, 2460},
  {2625, 2207, 2520},
  {2571, 2463, 2522},
  {2850, 2672, 2212},
  {2524, 2850, 2572},
  {2399, 2627, 2629},
  {2572, 2523, 2524},
  {2465, 2630, 2631},
  {2465, 2631, 2721},
  {2405, 2635, 2630},
  {2581, 2574, 2719},
  {2679, 2575, 2680},
  {2528, 2679, 2573},
  {2575, 2527, 2633},
  {2575, 2633, 2680},
  {2405, 2576, 2635},
  {2636, 2632, 2761},
  {2761, 2634, 2577},
  {2577, 2578, 2761},
  {2636, 2761, 2582},
  {2527, 2637, 2633},
  {2580, 2582, 2761},
  {2635, 2576, 2867},
  {2763, 2583, 2581},
  {2533, 2726, 2587},
  {2683, 2585, 2684},
  {2685, 2011, 2770},
  {2586, 2584, 2686},
  {2414, 2640, 2817},
  {2414, 2817, 2293},
  {2587, 2726, 2589},
  {2586, 2686, 2474},
  {2589, 2726, 2641},
  {2011, 2730, 2770},
  {2474, 2686, 2642},
  {2590, 2817, 2640},
  {2589, 2641, 2688},
  {2688, 2641, 2728},
  {2588, 2731, 2591},
  {2592, 2775, 2643},
  {2643, 2594, 2592},
  {2645, 2644, 2593},
  {2647, 2646, 2596},
  {2596, 2598, 2647},
  {2689, 2647, 2598},
  {2648, 2690, 2597},
  {2650, 2600, 2601},
  {2690, 2649, 2597},
  {2650, 2603, 2602},
  {2602, 2600, 2650},
  {2735, 2365, 2695},
  {2496, 2650, 2653},
  {2651, 2736, 2546},
  {2543, 2606, 2691},
  {2696, 2652, 2605},
  {2605, 2652, 2604},
  {2604, 2652, 2738},
  {2545, 2546, 2698},
  {2614, 2608, 2705},
  {2553, 2700, 2608},
  {2553, 2609, 2700},
  {2551, 2656, 2607},
  {2611, 2612, 2702},
  {2612, 2613, 2702},
  {2613, 2654, 2702},
  {2696, 2614, 2615},
  {2696, 2615, 2657},
  {2610, 2706, 2617},
  {2379, 2556, 2743},
  {2379, 2743, 2610},
  {2615, 2705, 2657},
  {2739, 2619, 2555},
  {2559, 2744, 2618},
  {2620, 2744, 2559},
  {2622, 2621, 2710},
  {2621, 2712, 2710},
  {2661, 2622, 2711},
  {2622, 2661, 2562},
  {2662, 2562, 2661},
  {2662, 2799, 2564},
  {2624, 2564, 2799},
  {2665, 2664, 2565},
  {2665, 2565, 2567},
  {2665, 2567, 2752},
  {2566, 2666, 2518},
  {2518, 2666, 2569},
  {2569, 2666, 2714},
  {2569, 2714, 2713},
  {2625, 2756, 2668},
  {2625, 2668, 2670},
  {2625, 2670, 2671},
  {2668, 2756, 2669},
  {2668, 2669, 2670},
  {2628, 2716, 2626},
  {2850, 2524, 2673},
  {2629, 2627, 2675},
  {2524, 2573, 2677},
  {2631, 2630, 2678},
  {2631, 2678, 2718},
  {2719, 2574, 2717},
  {2630, 2635, 2678},
  {2581, 2719, 2860},
  {2679, 2680, 2676},
  {2635, 2723, 2678},
  {2761, 2632, 2720},
  {2720, 2583, 2763},
  {2581, 2860, 2763},
  {2722, 2681, 2638},
  {2638, 2634, 2722},
  {2633, 2766, 2680},
  {2632, 2408, 2720},
  {2720, 2408, 2583},
  {2633, 2637, 2766},
  {2867, 2723, 2635},
  {2638, 2681, 2639},
  {2682, 2639, 2681},
  {2639, 2682, 2532},
  {2532, 2682, 2533},
  {2726, 2533, 2682},
  {2727, 2534, 2683},
  {2771, 2685, 2770},
  {2293, 2817, 2867},
  {2684, 2589, 2729},
  {2589, 2688, 2729},
  {2644, 2817, 2590},
  {2728, 2687, 2688},
  {2688, 2687, 2732},
  {2594, 2643, 2734},
  {2645, 2871, 2644},
  {2595, 2733, 2645},
  {2595, 2646, 2733},
  {2646, 2777, 2733},
  {2647, 2777, 2646},
  {2647, 2689, 2777},
  {2601, 2649, 2650},
  {2649, 2690, 2650},
  {2650, 2693, 2692},
  {2650, 2690, 2693},
  {2690, 2648, 2693},
  {2546, 2736, 2698},
  {2691, 2606, 2737},
  {2697, 2652, 2696},
  {2738, 2652, 2697},
  {2699, 2737, 2606},
  {2653, 2703, 2654},
  {2606, 2607, 2699},
  {2783, 2705, 2608},
  {2608, 2700, 2783},
  {2609, 2655, 2700},
  {2701, 2699, 2607},
  {2607, 2656, 2701},
  {2611, 2701, 2656},
  {2702, 2654, 2703},
  {2696, 2657, 2704},
  {2832, 2655, 2616},
  {2743, 2706, 2610},
  {2705, 2704, 2657},
  {2616, 2618, 2832},
  {2739, 2707, 2619},
  {2705, 2785, 2704},
  {2706, 2837, 2617},
  {2658, 2707, 2708},
  {5889, 2660, 2709},
  {5889, 2709, 2743},
  {2708, 2659, 2658},
  {2708, 2745, 2659},
  {2710, 2711, 2622},
  {2711, 2797, 2661},
  {2712, 2623, 2746},
  {2662, 2661, 2799},
  {2799, 2748, 2624},
  {2664, 2749, 2623},
  {2566, 2624, 2748},
  {2751, 2664, 2665},
  {2752, 2751, 2665},
  {2802, 2715, 2520},
  {2567, 2568, 2752},
  {2669, 2756, 2670},
  {5892, 2850, 2673},
  {2850, 2755, 2672},
  {2673, 2524, 5892},
  {2524, 2806, 5892},
  {2627, 2804, 2759},
  {2943, 2524, 2677},
  {2627, 2717, 2675},
  {2627, 2759, 2717},
  {2675, 2717, 2466},
  {2676, 2677, 2679},
  {2573, 2679, 2677},
  {2760, 2721, 2631},
  {2676, 2680, 2811},
  {2766, 2811, 2680},
  {2465, 2721, 2529},
  {2634, 2761, 2722},
  {2763, 2860, 2765},
  {2681, 2722, 2767},
  {2865, 2723, 2867},
  {2681, 2724, 2682},
  {2682, 2724, 2725},
  {2682, 2725, 2726},
  {2683, 2684, 2727},
  {2685, 2773, 2584},
  {2584, 2773, 2686},
  {2726, 2728, 2641},
  {2686, 2773, 2642},
  {2734, 2643, 2775},
  {2871, 2645, 2733},
  {2694, 2487, 2914},
  {2733, 2777, 2776},
  {2778, 2648, 2604},
  {2693, 2648, 2778},
  {2695, 2825, 2735},
  {2650, 2692, 2653},
  {2736, 2651, 2825},
  {2735, 2825, 2651},
  {2737, 2699, 2741},
  {2698, 2781, 2739},
  {2703, 2653, 2740},
  {2703, 2740, 2827},
  {2696, 2704, 2788},
  {2699, 2701, 2741},
  {2701, 2611, 2830},
  {2701, 2830, 2741},
  {2611, 2702, 2830},
  {2702, 2829, 2830},
  {2702, 2703, 2784},
  {2703, 2827, 2784},
  {2618, 2789, 2832},
  {2618, 2744, 2789},
  {2706, 2742, 2837},
  {2709, 2793, 2743},
  {2793, 2709, 2660},
  {2745, 2791, 2659},
  {2795, 2659, 2791},
  {2659, 2795, 2660},
  {2795, 2793, 2660},
  {2710, 2712, 2711},
  {2796, 2711, 2712},
  {2746, 2623, 2848},
  {2749, 2848, 2623},
  {2799, 2747, 2748},
  {2747, 2566, 2748},
  {2747, 2849, 2750},
  {2747, 2750, 2566},
  {2664, 2751, 2749},
  {2566, 2750, 2666},
  {2752, 2568, 2667},
  {2752, 2667, 2801},
  {2714, 2666, 2940},
  {2714, 2982, 2713},
  {2713, 2982, 2753},
  {2713, 2753, 2663},
  {2714, 2940, 2982},
  {2667, 2754, 2801},
  {2667, 2755, 2754},
  {2850, 5892, 2984},
  {2757, 2627, 2716},
  {2670, 2852, 2671},
  {2757, 2716, 2628},
  {5892, 2806, 2942},
  {2852, 2674, 2671},
  {2758, 2757, 2628},
  {2628, 2674, 2758},
  {2853, 2759, 2804},
  {2853, 2805, 2759},
  {2524, 2943, 2806},
  {2631, 2718, 2760},
  {2718, 2723, 2760},
  {2677, 2676, 2808},
  {2809, 2721, 2760},
  {2676, 2811, 2808},
  {2678, 2723, 2718},
  {2720, 2901, 2761},
  {2720, 2763, 2764},
  {2720, 2764, 2762},
  {2766, 2721, 2810},
  {2766, 2529, 2721},
  {2865, 2900, 2723},
  {2681, 2767, 2724},
  {2724, 2768, 2725},
  {2725, 2768, 2814},
  {2725, 2814, 2726},
  {2726, 2814, 2728},
  {2770, 2730, 2769},
  {2685, 2771, 2773},
  {2770, 2816, 2771},
  {2772, 2728, 2814},
  {2534, 2727, 2588},
  {2731, 2588, 2727},
  {2815, 2730, 3003},
  {2728, 2772, 2687},
  {2774, 2729, 2688},
  {3003, 2730, 2591},
  {2642, 2773, 2869},
  {2732, 2687, 2772},
  {2688, 2732, 2774},
  {2731, 3003, 2591},
  {2642, 2869, 2775},
  {2775, 2869, 2822},
  {2644, 2871, 2817},
  {2819, 2732, 2823},
  {2775, 2822, 2734},
  {2818, 2823, 2732},
  {2487, 2734, 2914},
  {2734, 2872, 2914},
  {2776, 2875, 2733},
  {2914, 3012, 2694},
  {2689, 2691, 2777},
  {2694, 3012, 2780},
  {2691, 2779, 2777},
  {2604, 2738, 2778},
  {2737, 2779, 2691},
  {2694, 2780, 2695},
  {2781, 2736, 2917},
  {2736, 2781, 2698},
  {2696, 2826, 2697},
  {2827, 2653, 2692},
  {2884, 2696, 2788},
  {2696, 2884, 2826},
  {2697, 2826, 2738},
  {2740, 2653, 2827},
  {2784, 2829, 2702},
  {2705, 2783, 2782},
  {2832, 2783, 2700},
  {2700, 2655, 2832},
  {2705, 2782, 2785},
  {2706, 2743, 2742},
  {2785, 2786, 2704},
  {2787, 2704, 2786},
  {2834, 2742, 2743},
  {2742, 2834, 2837},
  {2788, 2704, 2787},
  {2743, 2793, 2971},
  {2744, 2790, 2789},
  {2620, 2837, 2792},
  {2620, 2790, 2744},
  {2620, 2792, 2790},
  {2791, 2794, 2795},
  {2796, 2797, 2711},
  {2796, 2712, 2746},
  {2796, 2746, 2977},
  {2749, 2800, 2848},
  {2198, 2802, 2520},
  {2751, 2800, 2749},
  {2800, 2751, 2895},
  {2751, 2752, 2895},
  {2802, 2803, 2715},
  {2756, 2941, 2670},
  {2715, 2803, 2756},
  {2852, 2670, 2941},
  {2758, 2674, 2857},
  {2808, 2943, 2677},
  {2720, 2762, 2997},
  {2947, 2997, 2762},
  {2762, 2764, 2947},
  {2766, 2810, 2811},
  {2763, 2765, 2764},
  {2767, 2722, 2863},
  {2995, 2863, 2722},
  {2768, 2724, 2864},
  {2768, 2864, 2812},
  {2768, 2812, 2814},
  {2730, 2866, 2769},
  {2815, 2866, 2730},
  {2815, 2813, 2866},
  {2769, 2905, 2770},
  {2905, 2907, 2770},
  {2684, 2729, 2727},
  {2816, 2869, 2771},
  {2771, 2869, 2773},
  {2731, 2727, 3003},
  {2822, 2869, 2820},
  {2819, 2823, 2821},
  {2823, 2824, 2821},
  {5893, 2872, 2734},
  {2734, 2822, 5893},
  {2871, 2733, 2873},
  {2874, 2824, 2823},
  {2873, 2733, 2875},
  {2776, 2777, 2875},
  {2916, 2875, 2777},
  {2779, 2916, 2777},
  {2778, 2692, 2693},
  {3012, 2880, 2780},
  {2695, 2876, 2825},
  {2779, 2737, 2877},
  {2692, 2778, 2878},
  {2738, 2920, 2778},
  {2737, 2882, 2877},
  {2738, 2826, 2920},
  {2826, 2884, 2885},
  {2739, 2781, 2828},
  {2737, 2741, 2882},
  {2739, 2828, 2707},
  {2882, 2741, 2886},
  {2783, 2831, 2782},
  {2783, 2832, 2831},
  {2741, 2830, 2886},
  {2785, 2833, 2786},
  {2785, 2782, 2833},
  {2782, 2831, 2833},
  {2831, 2889, 2833},
  {2831, 2832, 2889},
  {2707, 2967, 2928},
  {2786, 2833, 2787},
  {2707, 2928, 2708},
  {2708, 2928, 2966},
  {2835, 2788, 2787},
  {2832, 2789, 2889},
  {2893, 2789, 2836},
  {2789, 2893, 2889},
  {2789, 2838, 2836},
  {2789, 2790, 2838},
  {2790, 2792, 2838},
  {2931, 2794, 2791},
  {2794, 2931, 2795},
  {2793, 2795, 2839},
  {2935, 2798, 2974},
  {2933, 2796, 2977},
  {2840, 2841, 2979},
  {2842, 2979, 2841},
  {2979, 2842, 2843},
  {2844, 2979, 2843},
  {2845, 2846, 2979},
  {2845, 2844, 2977},
  {2845, 2977, 2846},
  {2746, 2846, 2977},
  {2844, 2845, 2979},
  {2848, 2846, 2746},
  {2799, 2938, 2747},
  {2846, 2848, 2939},
  {2747, 2938, 2847},
  {2747, 2798, 2894},
  {2747, 2894, 2849},
  {2848, 2800, 2939},
  {2663, 2802, 2198},
  {2663, 2753, 2802},
  {2752, 2801, 2895},
  {2801, 2754, 2896},
  {2753, 2982, 2897},
  {2756, 3036, 2941},
  {2754, 2755, 2850},
  {2754, 2850, 2896},
  {2753, 2803, 2802},
  {2753, 2897, 2803},
  {2851, 2756, 2803},
  {2803, 2897, 2985},
  {2854, 2805, 2853},
  {2757, 2758, 2807},
  {2757, 2807, 2804},
  {2804, 2807, 2854},
  {2805, 2854, 2855},
  {2807, 2855, 2854},
  {2805, 2856, 2989},
  {2805, 2989, 2759},
  {2758, 2857, 2807},
  {2807, 2857, 2855},
  {2759, 2989, 2717},
  {2717, 2989, 2719},
  {2808, 2859, 2943},
  {2808, 2862, 2859},
  {2809, 2760, 2858},
  {2723, 2900, 2760},
  {2765, 2860, 2861},
  {2993, 2721, 2809},
  {2997, 2901, 2720},
  {2861, 2899, 2765},
  {2808, 2811, 2862},
  {2810, 2721, 2993},
  {2946, 2764, 2765},
  {2810, 2862, 2811},
  {2724, 2767, 2863},
  {2722, 2761, 2995},
  {2903, 2812, 2864},
  {2812, 2903, 2904},
  {2769, 2866, 2905},
  {2812, 2904, 2814},
  {2866, 2813, 2948},
  {2949, 2814, 2904},
  {2815, 2948, 2813},
  {2814, 2949, 2772},
  {2770, 2907, 2816},
  {2772, 2949, 2911},
  {2772, 2911, 2732},
  {2774, 2732, 2819},
  {2868, 2820, 2869},
  {2869, 2907, 2868},
  {2732, 2911, 2818},
  {2819, 2821, 3213},
  {2912, 2870, 5893},
  {2912, 2952, 2870},
  {5893, 2820, 2868},
  {5893, 2868, 2912},
  {2818, 2913, 2823},
  {2821, 2824, 3213},
  {2870, 2872, 5893},
  {2870, 2952, 2872},
  {2823, 2913, 2874},
  {2877, 2916, 2779},
  {2876, 2695, 2879},
  {2879, 2780, 2880},
  {2780, 2879, 2695},
  {2736, 2825, 2876},
  {2736, 2876, 2917},
  {2919, 2879, 2880},
  {2885, 2920, 2826},
  {2917, 2918, 2781},
  {2881, 2781, 2918},
  {2692, 2883, 2827},
  {2922, 2884, 2788},
  {2828, 2781, 2881},
  {2788, 2890, 2960},
  {2788, 2960, 2922},
  {2707, 2828, 2967},
  {2830, 2923, 2886},
  {2829, 2784, 2887},
  {2784, 2827, 2925},
  {2784, 2925, 2887},
  {2827, 2883, 2925},
  {2833, 2888, 2787},
  {2834, 2743, 2891},
  {2743, 2971, 2891},
  {3018, 2708, 2966},
  {2708, 3018, 2745},
  {2890, 2788, 2835},
  {2834, 2891, 2837},
  {2835, 2892, 2890},
  {2745, 3070, 2791},
  {2837, 2969, 2792},
  {2838, 2792, 2836},
  {2836, 2792, 2893},
  {2792, 2969, 2930},
  {2792, 2930, 2893},
  {2795, 2931, 2839},
  {2793, 2839, 2932},
  {2796, 2933, 2797},
  {2799, 2797, 2933},
  {2797, 2799, 2661},
  {2843, 2842, 2976},
  {2843, 2976, 2844},
  {3029, 2798, 3032},
  {2747, 2847, 2798},
  {2798, 2847, 3032},
  {2798, 2935, 3082},
  {2798, 3082, 2894},
  {2981, 2894, 3082},
  {2979, 2846, 2980},
  {2849, 2940, 2750},
  {2750, 2940, 2666},
  {5892, 2986, 2984},
  {2803, 2985, 2851},
  {2804, 2854, 2853},
  {2987, 2942, 2806},
  {2855, 2898, 2805},
  {2805, 2898, 2856},
  {2989, 2856, 2898},
  {2943, 2987, 2806},
  {2944, 2855, 2857},
  {2855, 2944, 2898},
  {2860, 2719, 2989},
  {2900, 2994, 2760},
  {2809, 2858, 3148},
  {2860, 2946, 2861},
  {2899, 2861, 2946},
  {2946, 2765, 2899},
  {2761, 2901, 2996},
  {2764, 2946, 2947},
  {2862, 2810, 2993},
  {2724, 2998, 2864},
  {2902, 2864, 2998},
  {2864, 2902, 2903},
  {2948, 2908, 2909},
  {2948, 2909, 2866},
  {2948, 2910, 2908},
  {2907, 2869, 2816},
  {2906, 2867, 3004},
  {2867, 2817, 3004},
  {2727, 2729, 3003},
  {2817, 2871, 3010},
  {2871, 2873, 3010},
  {2953, 2874, 2913},
  {3213, 2824, 2874},
  {2875, 3011, 2873},
  {2953, 2954, 2874},
  {2915, 2874, 2954},
  {3213, 2874, 2915},
  {2875, 2916, 2955},
  {2877, 2958, 2916},
  {2917, 2876, 2879},
  {2919, 2880, 2957},
  {2882, 2921, 2877},
  {2882, 2886, 2921},
  {2881, 2956, 2961},
  {2884, 2922, 2885},
  {2885, 2922, 2959},
  {2830, 2829, 2923},
  {2829, 2887, 2923},
  {2828, 2881, 2967},
  {2887, 2925, 2923},
  {2925, 2883, 2924},
  {2890, 2965, 2960},
  {2833, 2889, 2926},
  {2787, 2888, 2927},
  {2833, 2926, 2888},
  {2968, 2888, 2926},
  {2929, 2926, 2889},
  {2787, 2927, 2835},
  {2929, 2889, 2893},
  {2745, 3018, 3070},
  {2971, 2793, 3022},
  {2931, 2791, 3070},
  {2973, 3022, 2793},
  {2793, 2932, 2973},
  {2931, 2932, 2839},
  {2974, 2798, 3029},
  {2841, 2976, 2842},
  {2799, 2933, 2934},
  {2977, 2844, 2976},
  {2933, 2977, 2934},
  {2936, 2934, 2978},
  {2934, 2937, 2938},
  {2934, 2938, 2799},
  {2934, 2936, 2937},
  {2978, 2937, 2936},
  {2937, 2978, 2938},
  {2938, 3032, 2847},
  {2849, 2894, 2940},
  {2895, 2939, 2800},
  {2895, 2983, 2939},
  {2895, 2801, 2983},
  {2801, 2896, 3087},
  {3037, 2897, 2982},
  {2897, 3037, 3038},
  {2850, 2984, 2896},
  {2851, 2985, 3088},
  {3041, 2898, 2944},
  {3042, 2943, 2859},
  {3039, 3199, 2857},
  {3043, 2857, 2945},
  {2988, 2857, 3043},
  {2857, 2988, 2944},
  {2760, 3148, 2858},
  {2991, 2860, 2989},
  {2860, 2991, 2946},
  {2862, 2993, 2859},
  {2997, 2947, 3151},
  {2995, 2761, 2996},
  {2902, 2999, 2903},
  {2904, 2903, 2949},
  {2865, 2867, 2906},
  {2948, 2815, 3001},
  {2948, 2950, 2910},
  {3006, 3002, 2866},
  {2866, 3002, 2905},
  {2911, 2949, 3048},
  {2729, 2774, 3003},
  {3098, 2909, 2908},
  {2905, 2912, 2868},
  {2868, 2907, 2905},
  {2913, 2911, 3048},
  {3098, 2908, 2910},
  {3002, 2951, 2912},
  {2911, 2913, 2818},
  {2819, 3213, 2774},
  {2952, 2912, 2951},
  {2953, 2913, 3051},
  {2872, 2952, 2914},
  {2875, 2955, 3011},
  {2916, 3013, 2955},
  {3057, 2692, 2878},
  {2917, 2879, 2918},
  {2879, 2919, 2957},
  {2918, 2879, 2956},
  {2918, 2956, 2881},
  {2692, 3014, 2883},
  {2877, 2921, 2958},
  {2920, 2885, 2959},
  {2920, 2959, 2778},
  {2922, 2960, 3061},
  {2883, 2962, 2924},
  {2886, 2923, 3063},
  {2923, 2925, 2963},
  {2925, 2924, 2962},
  {2925, 2962, 2963},
  {2965, 2890, 2964},
  {2960, 2965, 3015},
  {2961, 2967, 2881},
  {2968, 2927, 2888},
  {2929, 2968, 2926},
  {3016, 2966, 2928},
  {2928, 2967, 3016},
  {2892, 2964, 2890},
  {2835, 2927, 3069},
  {2927, 2968, 3069},
  {2969, 2891, 2971},
  {2970, 2964, 2892},
  {3069, 3020, 2835},
  {2835, 3020, 2892},
  {3020, 2970, 2892},
  {3068, 2929, 2972},
  {2929, 2893, 2972},
  {2891, 2969, 2837},
  {2893, 2930, 2972},
  {3024, 2972, 2930},
  {2930, 2969, 3024},
  {3025, 2973, 2932},
  {2932, 2931, 3025},
  {2975, 2935, 2974},
  {2840, 3031, 3030},
  {2977, 2978, 2934},
  {2977, 3080, 2978},
  {2978, 3033, 2938},
  {3032, 2938, 3033},
  {2980, 2846, 2939},
  {2894, 2982, 2940},
  {2939, 2983, 3034},
  {2983, 2801, 3035},
  {3035, 2801, 3087},
  {2896, 2984, 3087},
  {3257, 3145, 5892},
  {3257, 5892, 2942},
  {2674, 3039, 2857},
  {2943, 3092, 2987},
  {2990, 2988, 3043},
  {2990, 3043, 2992},
  {2990, 2992, 2991},
  {2991, 3041, 2990},
  {2993, 2809, 3148},
  {2947, 3150, 3151},
  {2863, 2995, 2724},
  {2865, 2994, 2900},
  {2995, 2996, 3206},
  {2902, 2998, 2999},
  {2903, 2999, 3000},
  {3046, 3000, 2999},
  {3095, 2865, 2906},
  {3000, 2949, 2903},
  {3155, 3095, 2906},
  {2948, 3047, 2950},
  {3048, 2949, 3000},
  {2950, 3047, 3007},
  {3213, 3003, 2774},
  {2909, 3005, 2866},
  {3006, 2866, 3005},
  {3049, 2909, 3098},
  {2912, 2905, 3002},
  {2910, 2950, 3098},
  {3002, 3008, 2951},
  {2951, 3008, 2952},
  {2817, 3009, 3004},
  {3099, 3004, 3009},
  {2817, 3010, 3009},
  {3051, 2954, 2953},
  {2952, 3055, 2914},
  {2952, 3053, 3055},
  {2954, 3054, 2915},
  {2914, 3055, 3012},
  {2955, 3056, 3011},
  {2955, 3013, 3056},
  {2878, 3059, 3057},
  {2778, 3113, 2878},
  {2916, 2958, 3013},
  {2957, 3114, 2879},
  {2879, 3114, 2956},
  {3014, 2692, 3169},
  {2956, 3114, 2961},
  {3116, 2958, 2921},
  {2921, 2886, 3116},
  {3014, 2962, 2883},
  {3061, 2959, 2922},
  {3014, 3064, 2962},
  {3016, 3017, 2966},
  {3016, 2967, 2961},
  {2923, 2963, 3063},
  {3064, 3063, 2963},
  {2963, 2962, 3064},
  {2965, 3065, 3015},
  {3062, 3015, 3065},
  {2964, 3065, 2965},
  {2968, 2929, 3067},
  {2964, 3172, 3065},
  {2968, 3067, 3069},
  {3068, 3067, 2929},
  {2964, 2970, 3019},
  {2970, 3020, 3019},
  {3068, 2972, 3021},
  {2972, 3024, 3021},
  {3025, 2931, 3023},
  {2973, 3025, 3073},
  {3026, 3076, 3027},
  {3029, 3077, 2974},
  {5894, 3027, 3078},
  {5894, 3078, 3028},
  {3029, 3192, 3077},
  {3250, 2975, 2974},
  {3080, 2977, 2976},
  {3080, 3028, 3129},
  {2978, 3080, 3033},
  {2840, 2979, 3132},
  {2840, 3132, 3031},
  {2979, 2980, 3034},
  {2980, 2939, 3034},
  {2982, 2894, 2981},
  {2982, 2981, 3082},
  {3034, 2983, 3083},
  {3082, 3037, 2982},
  {3087, 3085, 3035},
  {3140, 2941, 3036},
  {2851, 3088, 3310},
  {2852, 2941, 3039},
  {2852, 3039, 2674},
  {3092, 3040, 2987},
  {2943, 3042, 3092},
  {2988, 2990, 2944},
  {2944, 2990, 3041},
  {2898, 3041, 2989},
  {3199, 2945, 2857},
  {2945, 3262, 3043},
  {3041, 2991, 2989},
  {2991, 2992, 2946},
  {2859, 2993, 3148},
  {3043, 3044, 2992},
  {2992, 3044, 3045},
  {2992, 3045, 2946},
  {2946, 3045, 3150},
  {2946, 3150, 2947},
  {2997, 3152, 2901},
  {3151, 3152, 2997},
  {3094, 2994, 2865},
  {3207, 3206, 2996},
  {2996, 2901, 3152},
  {2998, 3205, 2999},
  {3209, 2999, 3205},
  {3096, 2999, 3209},
  {2999, 3096, 3046},
  {3047, 2948, 3001},
  {3048, 3000, 3046},
  {2815, 3003, 3001},
  {2906, 3004, 3155},
  {3097, 2913, 3048},
  {3005, 2909, 3049},
  {3006, 3008, 3002},
  {3006, 3005, 3008},
  {3098, 2950, 3050},
  {2913, 3097, 3051},
  {3052, 3100, 3007},
  {3007, 3050, 2950},
  {3099, 3009, 3156},
  {2952, 3008, 3053},
  {2954, 3215, 3054},
  {2873, 3011, 3010},
  {2915, 3054, 3223},
  {3054, 3105, 3223},
  {3011, 3056, 3106},
  {3107, 3109, 3169},
  {3169, 3057, 3107},
  {3057, 3059, 3058},
  {3113, 3059, 2878},
  {3056, 3013, 3108},
  {3060, 3108, 3013},
  {3169, 2692, 3057},
  {3170, 3060, 3013},
  {3113, 2778, 3061},
  {2959, 3061, 2778},
  {3168, 2880, 3012},
  {3229, 2880, 3168},
  {2880, 3229, 2957},
  {3013, 2958, 3170},
  {3116, 3170, 2958},
  {3281, 3017, 3016},
  {3281, 3016, 3114},
  {2960, 3015, 3061},
  {3016, 2961, 3114},
  {3015, 3062, 3228},
  {3066, 3228, 3062},
  {2886, 3063, 3116},
  {3065, 3066, 3062},
  {2966, 3017, 3171},
  {2966, 3171, 3018},
  {2964, 3019, 3172},
  {3069, 3067, 3118},
  {3065, 3119, 3117},
  {2969, 2971, 3174},
  {3020, 3069, 3238},
  {2971, 3022, 3174},
  {3020, 3238, 3122},
  {3019, 3122, 3121},
  {3019, 3020, 3122},
  {3022, 3297, 3174},
  {3021, 3120, 3068},
  {3178, 3023, 2931},
  {3023, 3071, 3025},
  {3024, 3072, 3021},
  {3025, 3071, 3074},
  {3024, 3181, 3072},
  {3022, 2973, 3123},
  {2973, 3073, 3123},
  {3025, 3125, 3073},
  {3025, 3074, 3125},
  {3026, 3079, 3075},
  {3026, 3075, 3076},
  {3128, 3188, 3077},
  {2974, 3077, 3250},
  {3027, 3076, 3191},
  {3027, 3191, 3078},
  {3128, 3077, 3192},
  {3129, 3028, 3078},
  {3130, 3079, 3030},
  {3192, 3029, 3032},
  {3081, 3030, 3031},
  {3030, 3081, 3130},
  {3080, 3131, 3033},
  {3033, 3131, 3032},
  {3031, 3132, 3081},
  {3132, 2979, 3134},
  {3135, 3134, 2979},
  {3083, 3135, 2979},
  {2979, 3034, 3083},
  {3082, 2935, 3084},
  {3035, 3083, 2983},
  {3083, 3035, 3136},
  {3254, 3136, 3035},
  {3085, 3254, 3035},
  {2756, 3086, 3036},
  {3139, 3036, 3086},
  {2756, 2851, 3086},
  {2984, 2986, 3087},
  {2986, 3145, 3087},
  {2897, 3038, 3144},
  {2897, 3144, 2985},
  {2985, 3144, 3143},
  {3143, 3088, 2985},
  {3089, 3142, 3090},
  {5892, 3145, 2986},
  {2941, 3146, 3039},
  {3039, 3146, 3091},
  {3146, 3089, 3091},
  {3039, 3091, 3199},
  {3089, 3090, 3198},
  {2987, 3040, 2942},
  {3260, 3040, 3092},
  {3199, 3261, 2945},
  {3262, 2945, 3261},
  {3093, 3042, 3148},
  {3148, 3042, 2859},
  {2994, 3148, 2760},
  {3149, 3148, 2994},
  {3150, 3044, 3043},
  {3044, 3150, 3045},
  {2994, 3094, 3149},
  {2998, 2724, 3203},
  {3323, 2724, 2995},
  {2995, 3206, 3323},
  {2996, 3152, 3207},
  {2865, 3095, 3094},
  {3046, 3096, 3048},
  {3001, 3003, 3047},
  {3007, 3047, 3266},
  {3048, 3096, 3097},
  {3005, 3049, 3008},
  {3099, 3155, 3004},
  {3008, 3049, 3101},
  {3097, 3211, 3051},
  {3007, 3214, 3052},
  {3007, 3100, 3050},
  {3053, 3008, 3101},
  {3103, 3102, 3214},
  {3214, 3102, 3052},
  {3052, 3102, 3100},
  {3273, 3100, 3102},
  {3009, 3010, 3156},
  {3158, 3102, 3103},
  {3053, 3101, 3055},
  {3055, 3101, 3159},
  {3104, 3010, 3011},
  {3106, 3104, 3011},
  {3160, 3012, 3055},
  {3055, 3159, 3160},
  {3012, 3160, 3162},
  {3012, 3162, 3163},
  {3012, 3163, 3277},
  {3108, 3106, 3056},
  {3167, 3110, 3107},
  {3111, 3167, 3107},
  {3012, 3277, 3168},
  {3166, 3169, 3109},
  {3109, 3107, 3110},
  {3107, 3057, 3111},
  {3112, 3111, 3057},
  {3057, 3058, 3112},
  {3058, 3059, 3112},
  {3113, 3112, 3059},
  {3115, 3017, 3231},
  {3231, 3017, 3281},
  {3014, 3169, 3064},
  {3017, 3115, 3171},
  {3065, 3117, 3066},
  {3067, 3068, 3118},
  {3069, 3118, 3173},
  {3069, 3173, 3235},
  {3068, 3120, 3118},
  {3238, 3069, 3235},
  {3070, 3176, 2931},
  {3121, 3175, 3019},
  {3181, 3024, 2969},
  {3071, 3023, 3240},
  {3071, 3184, 3074},
  {3124, 3021, 3072},
  {3072, 3181, 3124},
  {3123, 3073, 3125},
  {3125, 3074, 3126},
  {3184, 3126, 3074},
  {3245, 3127, 3075},
  {3075, 3079, 3245},
  {3075, 3127, 3076},
  {3191, 3076, 3127},
  {3188, 3248, 3077},
  {3190, 3245, 3079},
  {3129, 3078, 3191},
  {3079, 3130, 3190},
  {3129, 3131, 3080},
  {3032, 3131, 3192},
  {3130, 3081, 3133},
  {3134, 3135, 3253},
  {3135, 3083, 3253},
  {2935, 3194, 3084},
  {2935, 3735, 3194},
  {3194, 3137, 3138},
  {3194, 3138, 3084},
  {3084, 3138, 3037},
  {3084, 3037, 3082},
  {3036, 3139, 3140},
  {3037, 3138, 3038},
  {3085, 3087, 3254},
  {3141, 3142, 3146},
  {3141, 3146, 3197},
  {2941, 3140, 3196},
  {2941, 3196, 3146},
  {3310, 3311, 2851},
  {3089, 3146, 3142},
  {3091, 3089, 3199},
  {3198, 3199, 3089},
  {3260, 3092, 3314},
  {3093, 3148, 3147},
  {3043, 3202, 3150},
  {3201, 3204, 3043},
  {3043, 3204, 3202},
  {2998, 3203, 3205},
  {3153, 3094, 3095},
  {3096, 3209, 3154},
  {3096, 3154, 3097},
  {3047, 3003, 3213},
  {3007, 3266, 3214},
  {3211, 3097, 3154},
  {3155, 3099, 3392},
  {3211, 3212, 3051},
  {3216, 3098, 3050},
  {3049, 3098, 3216},
  {3051, 3212, 2954},
  {3215, 2954, 3212},
  {3103, 3219, 3158},
  {3102, 3158, 3273},
  {3010, 3104, 3156},
  {3215, 3157, 3054},
  {3217, 3218, 3219},
  {3054, 3157, 3105},
  {3157, 3222, 3105},
  {3106, 3224, 3104},
  {3105, 3222, 3223},
  {3160, 3161, 3162},
  {3106, 3108, 3165},
  {3226, 3110, 3164},
  {3110, 3167, 3164},
  {3167, 3341, 3164},
  {3109, 3110, 3226},
  {3109, 3226, 3166},
  {3111, 3112, 3167},
  {3169, 3166, 3227},
  {3113, 3061, 3112},
  {2957, 3230, 3281},
  {2957, 3281, 3114},
  {3108, 3060, 3284},
  {2957, 3229, 3230},
  {3060, 3170, 3284},
  {3169, 3232, 3289},
  {3169, 3289, 3064},
  {3061, 3015, 3228},
  {3066, 3117, 3287},
  {3066, 3287, 3228},
  {3116, 3063, 3170},
  {3064, 3170, 3063},
  {3018, 3171, 3234},
  {3018, 3234, 3070},
  {3236, 3173, 3118},
  {3065, 3172, 3119},
  {3176, 3070, 3234},
  {3118, 3120, 3236},
  {3181, 2969, 3174},
  {3176, 3177, 2931},
  {3237, 2931, 3177},
  {3172, 3019, 3175},
  {3120, 3021, 3236},
  {3174, 3297, 3181},
  {2931, 3237, 3178},
  {3175, 3121, 3179},
  {3180, 3236, 3021},
  {3178, 3240, 3023},
  {3295, 3179, 3121},
  {3121, 3122, 3295},
  {3122, 3238, 3295},
  {3184, 3071, 3240},
  {3123, 3297, 3022},
  {3243, 3183, 3298},
  {3184, 3183, 3126},
  {3124, 3180, 3021},
  {3123, 3241, 3297},
  {3123, 3185, 3241},
  {3243, 3126, 3183},
  {3123, 3125, 3185},
  {3125, 3244, 3185},
  {3125, 3126, 3243},
  {3245, 3186, 3127},
  {3127, 3186, 3187},
  {3127, 3187, 3191},
  {3077, 3248, 3189},
  {3077, 3189, 3250},
  {3188, 3128, 3187},
  {3187, 3128, 3192},
  {3192, 3191, 3187},
  {3129, 3191, 3131},
  {3191, 3192, 3131},
  {3190, 3130, 3193},
  {3250, 3252, 2975},
  {2975, 3252, 2935},
  {3130, 3133, 3193},
  {3132, 3134, 3305},
  {3132, 3305, 3081},
  {3081, 3305, 3133},
  {3735, 2935, 3252},
  {3133, 3305, 3193},
  {3136, 3254, 3253},
  {3140, 3484, 3196},
  {3255, 3143, 3195},
  {3196, 3484, 3197},
  {3197, 3484, 3141},
  {3256, 3254, 3087},
  {3146, 3196, 3197},
  {3142, 3141, 3484},
  {3087, 3145, 3256},
  {3143, 3144, 3308},
  {2851, 3311, 3086},
  {3143, 3255, 3088},
  {3088, 3255, 3310},
  {3090, 3259, 3198},
  {2942, 3040, 3258},
  {3198, 3259, 3313},
  {3040, 3260, 3258},
  {3536, 3042, 3093},
  {3149, 3200, 3148},
  {3149, 3094, 3200},
  {3043, 3319, 3201},
  {3150, 3202, 3264},
  {3151, 3150, 3264},
  {3320, 3203, 2724},
  {3264, 3152, 3151},
  {3378, 3207, 3152},
  {3321, 3322, 3152},
  {3152, 3264, 3321},
  {3094, 3153, 3208},
  {3153, 3095, 3208},
  {3381, 3208, 3095},
  {3155, 3381, 3095},
  {3154, 3265, 3210},
  {3210, 3211, 3154},
  {3099, 3268, 3392},
  {3049, 3216, 3272},
  {3099, 3156, 3271},
  {3099, 3271, 3268},
  {3050, 3100, 3216},
  {3219, 3103, 3217},
  {3156, 3335, 3271},
  {3213, 2915, 3223},
  {3159, 3101, 3272},
  {3156, 3274, 3335},
  {3159, 3272, 3160},
  {3156, 3104, 3274},
  {3160, 3221, 3161},
  {3104, 3224, 3275},
  {3104, 3275, 3274},
  {3162, 3161, 3221},
  {3162, 3221, 3398},
  {3162, 3398, 3163},
  {3163, 3503, 3277},
  {3106, 3165, 3224},
  {3164, 3279, 3226},
  {3226, 3227, 3166},
  {3167, 3112, 3225},
  {3165, 3108, 3284},
  {3231, 3281, 3230},
  {3228, 3283, 3112},
  {3112, 3061, 3228},
  {3227, 3286, 3169},
  {3169, 3286, 3232},
  {3229, 3115, 3230},
  {3289, 3232, 3348},
  {3229, 3168, 3514},
  {3115, 3233, 3171},
  {3170, 3064, 3288},
  {3064, 3289, 3288},
  {3290, 3117, 3119},
  {3236, 3235, 3173},
  {3119, 3172, 3290},
  {3350, 3292, 3175},
  {3178, 3237, 3240},
  {3175, 3179, 3350},
  {3296, 3350, 3179},
  {3236, 3180, 3293},
  {3294, 3300, 3239},
  {3239, 3243, 3298},
  {3179, 3295, 3296},
  {3239, 3300, 3182},
  {3239, 3182, 3243},
  {3180, 3124, 3299},
  {3243, 3182, 3300},
  {3185, 3244, 3242},
  {3244, 3125, 3243},
  {3245, 3302, 3186},
  {3187, 3186, 3246},
  {3246, 3248, 3188},
  {3246, 3188, 3187},
  {3245, 3190, 3247},
  {3247, 3190, 3303},
  {3248, 3304, 3189},
  {3190, 3367, 3303},
  {3248, 3249, 3304},
  {3190, 3251, 3367},
  {3190, 3193, 3251},
  {3134, 3253, 3305},
  {3083, 3136, 3253},
  {3735, 3430, 3194},
  {3195, 3307, 3255},
  {3308, 3195, 3143},
  {3038, 3138, 3309},
  {3038, 3309, 3144},
  {3312, 3090, 3142},
  {3257, 2942, 3258},
  {3199, 3198, 3261},
  {3147, 3317, 3315},
  {3148, 3200, 3147},
  {3043, 3262, 3319},
  {3201, 3319, 3376},
  {3201, 3376, 3204},
  {3204, 3376, 3202},
  {3441, 2724, 3323},
  {3206, 3207, 3380},
  {3152, 3322, 3378},
  {3209, 3205, 3265},
  {3154, 3209, 3265},
  {3047, 3213, 3266},
  {3212, 3211, 3210},
  {3385, 3214, 3266},
  {3215, 3212, 3384},
  {3155, 3392, 3444},
  {3214, 3385, 3325},
  {3214, 3325, 3103},
  {3049, 3272, 3101},
  {3269, 3268, 3271},
  {3215, 3267, 3157},
  {3270, 3157, 3267},
  {3103, 3325, 3217},
  {3222, 3157, 3270},
  {3271, 3335, 3333},
  {3271, 3333, 3269},
  {3216, 3100, 3273},
  {3504, 3158, 3219},
  {3160, 3272, 3221},
  {3398, 3221, 3272},
  {3274, 3452, 3335},
  {3223, 3222, 3399},
  {3332, 3276, 3220},
  {3332, 3336, 3276},
  {3163, 3398, 3503},
  {3278, 3164, 3280},
  {3279, 3164, 3278},
  {3279, 3278, 3340},
  {3164, 3341, 3280},
  {3226, 3343, 3227},
  {3167, 3225, 3282},
  {3167, 3282, 3341},
  {3225, 3112, 3283},
  {3225, 3283, 3345},
  {3225, 3345, 3282},
  {3283, 3228, 3347},
  {3230, 3115, 3231},
  {3232, 3286, 3348},
  {3287, 3285, 3228},
  {3288, 3346, 3170},
  {3348, 3346, 3288},
  {3117, 3347, 3287},
  {3233, 3234, 3171},
  {3290, 3347, 3117},
  {3234, 3349, 3176},
  {3235, 3236, 3291},
  {3293, 3235, 3291},
  {3176, 3349, 3177},
  {3172, 3175, 3292},
  {3557, 3290, 3172},
  {3177, 3349, 3237},
  {3291, 3236, 3293},
  {3294, 3239, 3298},
  {3296, 3295, 3418},
  {3180, 3419, 3293},
  {3183, 3184, 3298},
  {3181, 3299, 3124},
  {3297, 3241, 3420},
  {3355, 3300, 3294},
  {3180, 3357, 3419},
  {3241, 3185, 3420},
  {3180, 3299, 3356},
  {3180, 3356, 3357},
  {3185, 3242, 3420},
  {3300, 3358, 3243},
  {3242, 3244, 3301},
  {3242, 3301, 3359},
  {3244, 3243, 3358},
  {3244, 3358, 3301},
  {3302, 3362, 3186},
  {3363, 3186, 3362},
  {3186, 3363, 3246},
  {3247, 3303, 5895},
  {3246, 3363, 3248},
  {3363, 3249, 3248},
  {3304, 3424, 3189},
  {3189, 3424, 3250},
  {3249, 3365, 3366},
  {3249, 3366, 3304},
  {3251, 3193, 3428},
  {3251, 3428, 3367},
  {3306, 3369, 3195},
  {3194, 3430, 3137},
  {3195, 3369, 3307},
  {3370, 3432, 3254},
  {3137, 3430, 3138},
  {3254, 3256, 3370},
  {3255, 3307, 3310},
  {3484, 3140, 3139},
  {3138, 3430, 3309},
  {3589, 3257, 3258},
  {3488, 3259, 3090},
  {3259, 3488, 3433},
  {3259, 3433, 3313},
  {3258, 3260, 3314},
  {3198, 3371, 3261},
  {3198, 3313, 3371},
  {3315, 3093, 3147},
  {3261, 3371, 3316},
  {3261, 3316, 3262},
  {3536, 3093, 3315},
  {3092, 3536, 3314},
  {3316, 3263, 3262},
  {3042, 3536, 3092},
  {3317, 3147, 3200},
  {3263, 3318, 3262},
  {3262, 3318, 3319},
  {3320, 3494, 3205},
  {3320, 3205, 3203},
  {2724, 3537, 3320},
  {3202, 3376, 3322},
  {3264, 3202, 3321},
  {3441, 3537, 2724},
  {3208, 3540, 3094},
  {3207, 3377, 3380},
  {3378, 3377, 3207},
  {3265, 3205, 3382},
  {3384, 3265, 3382},
  {3384, 3210, 3265},
  {3384, 3212, 3210},
  {3155, 3444, 3324},
  {3384, 3386, 3215},
  {3267, 3215, 3386},
  {3326, 3392, 3268},
  {3269, 3327, 3268},
  {3268, 3327, 3326},
  {3327, 3269, 3328},
  {3329, 3327, 3328},
  {3395, 3329, 3328},
  {3269, 3330, 3328},
  {3328, 3330, 3395},
  {3217, 3325, 3501},
  {3269, 3331, 3330},
  {3397, 3331, 3269},
  {3395, 3330, 3331},
  {3217, 3220, 3218},
  {3503, 3216, 3273},
  {3216, 3503, 3272},
  {3398, 3272, 3503},
  {3269, 3333, 3397},
  {3333, 3335, 3449},
  {3333, 3449, 3397},
  {3275, 3452, 3274},
  {3275, 3224, 3337},
  {3275, 3337, 3452},
  {3336, 3400, 3339},
  {3220, 3401, 3218},
  {3220, 3276, 3401},
  {3503, 3504, 3277},
  {3224, 3455, 3337},
  {3278, 3280, 3402},
  {3340, 3278, 3403},
  {3406, 3226, 3279},
  {3406, 3279, 3340},
  {3226, 3406, 3343},
  {3341, 3282, 3345},
  {3343, 3344, 3227},
  {3343, 3409, 3344},
  {3165, 3284, 3342},
  {3344, 3286, 3227},
  {3283, 3347, 3345},
  {3347, 3228, 3285},
  {3284, 3170, 3346},
  {3284, 3346, 3342},
  {3348, 3286, 3346},
  {3285, 3287, 3347},
  {3229, 3514, 3115},
  {3115, 3514, 3233},
  {3233, 3514, 3412},
  {3233, 3412, 3349},
  {3349, 3234, 3233},
  {3415, 3292, 3350},
  {3238, 3235, 3352},
  {3235, 3293, 3352},
  {3351, 3294, 3414},
  {3172, 3292, 3415},
  {3464, 3295, 3238},
  {3352, 3464, 3238},
  {3351, 3354, 3294},
  {3237, 3353, 3240},
  {3355, 3294, 3354},
  {3350, 3296, 3417},
  {3297, 3299, 3181},
  {3296, 3418, 3417},
  {3184, 3240, 3298},
  {3356, 3299, 3468},
  {3358, 3300, 3355},
  {3242, 3359, 3420},
  {3301, 3358, 3360},
  {3358, 3361, 3360},
  {5895, 3303, 5897},
  {3303, 3364, 5897},
  {3363, 3365, 3249},
  {3424, 3304, 3425},
  {3303, 3367, 3364},
  {3366, 3425, 3304},
  {3366, 3365, 3478},
  {3193, 3305, 3428},
  {3369, 3306, 3368},
  {3368, 3429, 3369},
  {3195, 3482, 3306},
  {3307, 3369, 3431},
  {3307, 3431, 3310},
  {3482, 3195, 3308},
  {3309, 3430, 3144},
  {3308, 3144, 3430},
  {3086, 3587, 3139},
  {3484, 3486, 3142},
  {3312, 3142, 3486},
  {3532, 3145, 3257},
  {3145, 3532, 3256},
  {3587, 3086, 3311},
  {3310, 3586, 3311},
  {3486, 3090, 3312},
  {3739, 3645, 3090},
  {3371, 3313, 3372},
  {3313, 3433, 3372},
  {3316, 3371, 3263},
  {3371, 3372, 3263},
  {3263, 3372, 3373},
  {3318, 3263, 3374},
  {3263, 3373, 3436},
  {3263, 3436, 3374},
  {3200, 3795, 3315},
  {3200, 3315, 3317},
  {3375, 3319, 3318},
  {3094, 3795, 3200},
  {3319, 3375, 3437},
  {3319, 3437, 3376},
  {3322, 3376, 3378},
  {3202, 3322, 3321},
  {3379, 3323, 3206},
  {3206, 3380, 3379},
  {3323, 3379, 3441},
  {3383, 3381, 3155},
  {3382, 3386, 3384},
  {3324, 3383, 3155},
  {3385, 3266, 3213},
  {3500, 3324, 3444},
  {3500, 3498, 3324},
  {3497, 3325, 3385},
  {3327, 3387, 3326},
  {3389, 3388, 3387},
  {3387, 3388, 3326},
  {3390, 3326, 3388},
  {3387, 3327, 3389},
  {3391, 3389, 3327},
  {3393, 3392, 3326},
  {3326, 3390, 3393},
  {3327, 3329, 3391},
  {3394, 3391, 3329},
  {3329, 3395, 3394},
  {3267, 3443, 3270},
  {3396, 3270, 3443},
  {3270, 3396, 3222},
  {3395, 3331, 3397},
  {3334, 3222, 3396},
  {3213, 3223, 3399},
  {3332, 3447, 3336},
  {3219, 3544, 3504},
  {3273, 3158, 3504},
  {3400, 3336, 3447},
  {3544, 3219, 3448},
  {3448, 3219, 3218},
  {3402, 3456, 3506},
  {3334, 3450, 3404},
  {3334, 3404, 3338},
  {3337, 3455, 3452},
  {3403, 3278, 3402},
  {3402, 3280, 3456},
  {3338, 3404, 3451},
  {3338, 3451, 3334},
  {3334, 3451, 3399},
  {3334, 3399, 3222},
  {3400, 3507, 3407},
  {3277, 3454, 3168},
  {3280, 3405, 3456},
  {3280, 3341, 3405},
  {3400, 3407, 3408},
  {3400, 3408, 3339},
  {3336, 3457, 3276},
  {3336, 3339, 3457},
  {3224, 3165, 3452},
  {3224, 3452, 3455},
  {3165, 3342, 3453},
  {3409, 3343, 3406},
  {3341, 3345, 3405},
  {3411, 3453, 3342},
  {3344, 3409, 3410},
  {3410, 3286, 3344},
  {3342, 3346, 3411},
  {3286, 3411, 3346},
  {3411, 3286, 3410},
  {3412, 3514, 3516},
  {3412, 3237, 3349},
  {3237, 3412, 3353},
  {3352, 3293, 3463},
  {3354, 3351, 3413},
  {3462, 3415, 3350},
  {3413, 3465, 3354},
  {3416, 3294, 3298},
  {3417, 3462, 3350},
  {3293, 3419, 3463},
  {3354, 3465, 3355},
  {3297, 3420, 3299},
  {3469, 3357, 3421},
  {3356, 3521, 3357},
  {3420, 3359, 3470},
  {3357, 3521, 3421},
  {3358, 3471, 3361},
  {3301, 3360, 3359},
  {3359, 3360, 3361},
  {3362, 5896, 3423},
  {3362, 3423, 3363},
  {3363, 3423, 3524},
  {3363, 3524, 3365},
  {3365, 3527, 3478},
  {3425, 3427, 3426},
  {3425, 3366, 3427},
  {3366, 3478, 3427},
  {3254, 3428, 3305},
  {3254, 3305, 3253},
  {3531, 3430, 3735},
  {3370, 3256, 3432},
  {3587, 3485, 3139},
  {3090, 3486, 3739},
  {3433, 3488, 3434},
  {3258, 3314, 3589},
  {3489, 3433, 3434},
  {3372, 3433, 3435},
  {3372, 3435, 3373},
  {3492, 3318, 3374},
  {3492, 3374, 3491},
  {3374, 3436, 3491},
  {3537, 3697, 3494},
  {3494, 3320, 3537},
  {3795, 3094, 3540},
  {3377, 3376, 3438},
  {3537, 3441, 3539},
  {3380, 3438, 3495},
  {3438, 3380, 3377},
  {3495, 3379, 3380},
  {3208, 3381, 3540},
  {3205, 3440, 3382},
  {3442, 3382, 3440},
  {3386, 3382, 3442},
  {3443, 3386, 3442},
  {3497, 3385, 3213},
  {3324, 3498, 3383},
  {3386, 3443, 3267},
  {3388, 3389, 3391},
  {3388, 3391, 3390},
  {3497, 3501, 3325},
  {3390, 3391, 3395},
  {3390, 3395, 3393},
  {3391, 3394, 3395},
  {3443, 3445, 3396},
  {3392, 3393, 3395},
  {3392, 3395, 3397},
  {3392, 3397, 3444},
  {3397, 3502, 3444},
  {3396, 3445, 3334},
  {3332, 3220, 3446},
  {3220, 3217, 3501},
  {3220, 3501, 3446},
  {3332, 3446, 3447},
  {3399, 3451, 3213},
  {3273, 3504, 3503},
  {3334, 3445, 3450},
  {3400, 3447, 3507},
  {3218, 3546, 3448},
  {3218, 3401, 3546},
  {3506, 3548, 3402},
  {3277, 3504, 3454},
  {3452, 3453, 3335},
  {3335, 3453, 3449},
  {3403, 3402, 3608},
  {3403, 3608, 3508},
  {3451, 3404, 3450},
  {3507, 3510, 3407},
  {3340, 3403, 3508},
  {3340, 3508, 3512},
  {3276, 3457, 3401},
  {3452, 3165, 3453},
  {3406, 3340, 3512},
  {3406, 3512, 3458},
  {3454, 3551, 3168},
  {3459, 3453, 3411},
  {3406, 3511, 3409},
  {3405, 3345, 3456},
  {3410, 3459, 3411},
  {3459, 3410, 3409},
  {3168, 3551, 3514},
  {3515, 3290, 3557},
  {3290, 3515, 3347},
  {3516, 3353, 3412},
  {3465, 3413, 3460},
  {3461, 3414, 3294},
  {3353, 3516, 3240},
  {3172, 3415, 3557},
  {3416, 3461, 3294},
  {3557, 3415, 3462},
  {3464, 3466, 3295},
  {3520, 3418, 3565},
  {3295, 3466, 3418},
  {3463, 3419, 3562},
  {3465, 3467, 3355},
  {3462, 3417, 3561},
  {3299, 3420, 3468},
  {3417, 3520, 3561},
  {3417, 3418, 3520},
  {3419, 3357, 3469},
  {3419, 3469, 3562},
  {3521, 3356, 3468},
  {3420, 3470, 3468},
  {3355, 3467, 3471},
  {3469, 3421, 3566},
  {3355, 3471, 3358},
  {3566, 3421, 3422},
  {3566, 3422, 3567},
  {3474, 3472, 3567},
  {3567, 3422, 3474},
  {3422, 3421, 3521},
  {3473, 3569, 3472},
  {3470, 3359, 3522},
  {3359, 3361, 3522},
  {3475, 3679, 3473},
  {3473, 3472, 3683},
  {3472, 3474, 3683},
  {3476, 5897, 3364},
  {3425, 3577, 3424},
  {3476, 3364, 3477},
  {3426, 3577, 3425},
  {3427, 3577, 3426},
  {3477, 3364, 3367},
  {3478, 3527, 3581},
  {3479, 3477, 3367},
  {3367, 3428, 3479},
  {3252, 3836, 3735},
  {3481, 3480, 3368},
  {3482, 3481, 3368},
  {3368, 3584, 3429},
  {3306, 3482, 3368},
  {3481, 3482, 3483},
  {3429, 3586, 3369},
  {3483, 3531, 3481},
  {3369, 3586, 3431},
  {3531, 3483, 3430},
  {3482, 3308, 3483},
  {3430, 3483, 3308},
  {3431, 3586, 3310},
  {3139, 3485, 3484},
  {3586, 3587, 3311},
  {3256, 3532, 3432},
  {3739, 3486, 3642},
  {3532, 3257, 3589},
  {3090, 3645, 3487},
  {3090, 3487, 3488},
  {3533, 3845, 3534},
  {3589, 3314, 3535},
  {3536, 3535, 3314},
  {3433, 3489, 3435},
  {3434, 3435, 3489},
  {3435, 3434, 3373},
  {3373, 3434, 3436},
  {3490, 3436, 3434},
  {3434, 3592, 3490},
  {3490, 3592, 3436},
  {3492, 3493, 3318},
  {3493, 3375, 3318},
  {3375, 3438, 3437},
  {3437, 3438, 3376},
  {3205, 3494, 3439},
  {3438, 3493, 3495},
  {3496, 3495, 3493},
  {3377, 3378, 3376},
  {3495, 3496, 3379},
  {3205, 3439, 3440},
  {3379, 3496, 3441},
  {3383, 3540, 3381},
  {3442, 3440, 3541},
  {3442, 3541, 3443},
  {3500, 3542, 3498},
  {3443, 3499, 3445},
  {3501, 3497, 3597},
  {3444, 3502, 3500},
  {3543, 3502, 3397},
  {3397, 3449, 3543},
  {3445, 3545, 3450},
  {3548, 3608, 3402},
  {3449, 3453, 3505},
  {3509, 3505, 3453},
  {3550, 3505, 3509},
  {3612, 3401, 3457},
  {3459, 3509, 3453},
  {3511, 3509, 3459},
  {3509, 3511, 3458},
  {3509, 3458, 3550},
  {3406, 3458, 3511},
  {3512, 3550, 3458},
  {3457, 3339, 3612},
  {3513, 3612, 3339},
  {3409, 3511, 3459},
  {3513, 3339, 3408},
  {3456, 3345, 3553},
  {3513, 3407, 3510},
  {3407, 3513, 3408},
  {3551, 3613, 3514},
  {3347, 3553, 3345},
  {3513, 3510, 3554},
  {3514, 3671, 3516},
  {3621, 3460, 3558},
  {3413, 3618, 3460},
  {3352, 3463, 3464},
  {3621, 3517, 3460},
  {3240, 3516, 3560},
  {3462, 3561, 3559},
  {3466, 3464, 3562},
  {3464, 3463, 3562},
  {3517, 3518, 3460},
  {3460, 3518, 3465},
  {3298, 3240, 3416},
  {3240, 3560, 3416},
  {3418, 3466, 3519},
  {3418, 3519, 3565},
  {3466, 3562, 3519},
  {3518, 3626, 3465},
  {3518, 3517, 3626},
  {3626, 3467, 3465},
  {3562, 3469, 3566},
  {3467, 3568, 3570},
  {3467, 3570, 3471},
  {3683, 3474, 3521},
  {3422, 3521, 3474},
  {3571, 3627, 3470},
  {3470, 3522, 3571},
  {3522, 3361, 3570},
  {3683, 3475, 3473},
  {3523, 3572, 3476},
  {5896, 3524, 3423},
  {3424, 3577, 3250},
  {3476, 3477, 3523},
  {3523, 3477, 3526},
  {3524, 3527, 3365},
  {3524, 3525, 3527},
  {3581, 3427, 3478},
  {3528, 3526, 3477},
  {3527, 3529, 3581},
  {3250, 3836, 3252},
  {3479, 3528, 3477},
  {3428, 3530, 3479},
  {3428, 3254, 3530},
  {3531, 3585, 3481},
  {3487, 3588, 3534},
  {3534, 3588, 3533},
  {3591, 3488, 3741},
  {3488, 3591, 3434},
  {3535, 3536, 3590},
  {3487, 3694, 3488},
  {3434, 3591, 3592},
  {3491, 3647, 3492},
  {3491, 3436, 3592},
  {3491, 3592, 3647},
  {3492, 3593, 3493},
  {3493, 3438, 3375},
  {3538, 3493, 3593},
  {3538, 3496, 3493},
  {3494, 3440, 3439},
  {3537, 3539, 3702},
  {3496, 3651, 3441},
  {3441, 3651, 3655},
  {3539, 3441, 3655},
  {3383, 3498, 3540},
  {3658, 3540, 3498},
  {3443, 3595, 3499},
  {3499, 3598, 3445},
  {3500, 3502, 3542},
  {3704, 3446, 3501},
  {3445, 3598, 3545},
  {3447, 3446, 3663},
  {3661, 3663, 3446},
  {3502, 3543, 3542},
  {3447, 3663, 3507},
  {3604, 3543, 3449},
  {3449, 3505, 3547},
  {3449, 3547, 3604},
  {3548, 3506, 3605},
  {3611, 3450, 3545},
  {3549, 3605, 3506},
  {3450, 3611, 3451},
  {3507, 3667, 3510},
  {3554, 3510, 3667},
  {3505, 3550, 3547},
  {3512, 3508, 3552},
  {3608, 3552, 3508},
  {3553, 3549, 3506},
  {3506, 3456, 3553},
  {3550, 3512, 3666},
  {3552, 3666, 3512},
  {3551, 3612, 3613},
  {3554, 3555, 3513},
  {3553, 3347, 3556},
  {3347, 3615, 3556},
  {3615, 3347, 3515},
  {3515, 3557, 3615},
  {3413, 3351, 3618},
  {3351, 3414, 3618},
  {3617, 3621, 3558},
  {3559, 3564, 3462},
  {3557, 3462, 3564},
  {3557, 3564, 3717},
  {3517, 3621, 3623},
  {3626, 3517, 3624},
  {3470, 3521, 3468},
  {3521, 3470, 3627},
  {3467, 3626, 3568},
  {3472, 3569, 3677},
  {3361, 3471, 3570},
  {3473, 3679, 3569},
  {3571, 3522, 3631},
  {3475, 3683, 3679},
  {3572, 3573, 5896},
  {3524, 3573, 3572},
  {3573, 3524, 5896},
  {3572, 3523, 3574},
  {3632, 3574, 3523},
  {3572, 3574, 3524},
  {3574, 3575, 3576},
  {3574, 3576, 3524},
  {3525, 3524, 3576},
  {3526, 3632, 3523},
  {3576, 3575, 3578},
  {3580, 3578, 3575},
  {3576, 3578, 3525},
  {3581, 3577, 3427},
  {3250, 3577, 3836},
  {3632, 3526, 3579},
  {3525, 3578, 3580},
  {3582, 3579, 3526},
  {3636, 3526, 3528},
  {3525, 3583, 3527},
  {3527, 3583, 3529},
  {3690, 3368, 3480},
  {3526, 3636, 3582},
  {3637, 3584, 3368},
  {3479, 3530, 3528},
  {3530, 3639, 3528},
  {3530, 3254, 3639},
  {3481, 3585, 3480},
  {3485, 3793, 3484},
  {3587, 3793, 3485},
  {3532, 3640, 3432},
  {3532, 3740, 3640},
  {3588, 3644, 3533},
  {3588, 3487, 3645},
  {3534, 3694, 3487},
  {3315, 3795, 3536},
  {3592, 3591, 3646},
  {3593, 3492, 3647},
  {3538, 3593, 3648},
  {3538, 3649, 3496},
  {3540, 3650, 3795},
  {3440, 3494, 3698},
  {3540, 3652, 3650},
  {3652, 3540, 3653},
  {3594, 3443, 3541},
  {3594, 3701, 3656},
  {3594, 3656, 3443},
  {3443, 3656, 3595},
  {3658, 3596, 3540},
  {3595, 3598, 3499},
  {3597, 3660, 3501},
  {3498, 3542, 3658},
  {3213, 3451, 3902},
  {3501, 3660, 3704},
  {3446, 3704, 3661},
  {3598, 3599, 3545},
  {3542, 3543, 3602},
  {3601, 3602, 3543},
  {3543, 3600, 3601},
  {3542, 3602, 3603},
  {3607, 3602, 3601},
  {3604, 3600, 3543},
  {3454, 3544, 3448},
  {3544, 3454, 3504},
  {3606, 3603, 3602},
  {3602, 3607, 3606},
  {3665, 3606, 3607},
  {3604, 3547, 3709},
  {3545, 3599, 3609},
  {3545, 3609, 3611},
  {3451, 3611, 3707},
  {3507, 3663, 3667},
  {3454, 3448, 3546},
  {3547, 3550, 3709},
  {3608, 3548, 3708},
  {3551, 3454, 3546},
  {3666, 3709, 3550},
  {3610, 3549, 3553},
  {3546, 3401, 3551},
  {3401, 3612, 3551},
  {3554, 3669, 3555},
  {3553, 3614, 3771},
  {3553, 3556, 3614},
  {3615, 3557, 3556},
  {3514, 3613, 3671},
  {3560, 3516, 3671},
  {3460, 3618, 3558},
  {3559, 3672, 3564},
  {3559, 3616, 3672},
  {3461, 3416, 3774},
  {3564, 3672, 3620},
  {3563, 3675, 3619},
  {3564, 3620, 3717},
  {3519, 3674, 3565},
  {3519, 3562, 3674},
  {3562, 3566, 3674},
  {3621, 3617, 3676},
  {3563, 3561, 3675},
  {3565, 3673, 3520},
  {3621, 3676, 3721},
  {3621, 3721, 3623},
  {3561, 3520, 3622},
  {3561, 3622, 3675},
  {3520, 3673, 3622},
  {3517, 3623, 3625},
  {3517, 3625, 3624},
  {3624, 3678, 3626},
  {3568, 3626, 3681},
  {3521, 3628, 3680},
  {3521, 3680, 3683},
  {3629, 3628, 3521},
  {3521, 3627, 3629},
  {3630, 3629, 3627},
  {3568, 3681, 3570},
  {3571, 3630, 3627},
  {3681, 3631, 3522},
  {3522, 3570, 3681},
  {3783, 3684, 3679},
  {3574, 3632, 3575},
  {3575, 3632, 3633},
  {3575, 3633, 3580},
  {3635, 3577, 3581},
  {3581, 3529, 3635},
  {3633, 3634, 3580},
  {3580, 3634, 3525},
  {3690, 3885, 3368},
  {3525, 3634, 3583},
  {3689, 3583, 3634},
  {3635, 3583, 3689},
  {3583, 3635, 3529},
  {3637, 3368, 3885},
  {3636, 3528, 3638},
  {3528, 3639, 3638},
  {3480, 3585, 3690},
  {3254, 3432, 3639},
  {3429, 3839, 3586},
  {3585, 3531, 3735},
  {3432, 3640, 3736},
  {3643, 3533, 3641},
  {3641, 3533, 3691},
  {3691, 3533, 3644},
  {3484, 3844, 3486},
  {3643, 3845, 3533},
  {3643, 3996, 3845},
  {3589, 3740, 3532},
  {3535, 3590, 3589},
  {3741, 3646, 3591},
  {3694, 3741, 3488},
  {3536, 3795, 3590},
  {3695, 3592, 3646},
  {3695, 3647, 3592},
  {3538, 3648, 3649},
  {3537, 3702, 3697},
  {3701, 3440, 3698},
  {3653, 3540, 3654},
  {3539, 3655, 3748},
  {3595, 3656, 3657},
  {3540, 3659, 3750},
  {3213, 3597, 3497},
  {3596, 3659, 3540},
  {3595, 3657, 3598},
  {3596, 3658, 3659},
  {3598, 3753, 3599},
  {3705, 3659, 3542},
  {3542, 3603, 3705},
  {3599, 3753, 3662},
  {3600, 3705, 3664},
  {3600, 3664, 3601},
  {3599, 3662, 3609},
  {3601, 3664, 3665},
  {3601, 3665, 3607},
  {3600, 3604, 3705},
  {3659, 3705, 3604},
  {3709, 3659, 3604},
  {3605, 3762, 3708},
  {3663, 3760, 3667},
  {3665, 3603, 3606},
  {3605, 3708, 3548},
  {3765, 3668, 3608},
  {3708, 3765, 3608},
  {3605, 3549, 3762},
  {3610, 3762, 3549},
  {3554, 3667, 3669},
  {3552, 3608, 3668},
  {3611, 3609, 3670},
  {3513, 3819, 3612},
  {3712, 3610, 3553},
  {3769, 3819, 3513},
  {3771, 3712, 3553},
  {3555, 3713, 3772},
  {3513, 3555, 3772},
  {3614, 3556, 3557},
  {3614, 3557, 3715},
  {3558, 3924, 3617},
  {3414, 3871, 3618},
  {3414, 3774, 3871},
  {3414, 3461, 3774},
  {3416, 3560, 3774},
  {3619, 3675, 3616},
  {3675, 3620, 3672},
  {3717, 3620, 3675},
  {3673, 3565, 3718},
  {3565, 3674, 3718},
  {3674, 3719, 3718},
  {3566, 3567, 3674},
  {3721, 3625, 3623},
  {3721, 3678, 3625},
  {3625, 3678, 3624},
  {3567, 3472, 3677},
  {3569, 3827, 3677},
  {3569, 3679, 3827},
  {3628, 3629, 3630},
  {3628, 3630, 3680},
  {3827, 3679, 3724},
  {3630, 3571, 3680},
  {3680, 3571, 3687},
  {3631, 3681, 3723},
  {3682, 3679, 3684},
  {3687, 3679, 3683},
  {3683, 3680, 3687},
  {3686, 3687, 3571},
  {3631, 3725, 3571},
  {3725, 3686, 3571},
  {3684, 3783, 3685},
  {3632, 3727, 3633},
  {3632, 3579, 3727},
  {3729, 3727, 3579},
  {3577, 3635, 3784},
  {3579, 3582, 3729},
  {3633, 3727, 3688},
  {3633, 3688, 3634},
  {3582, 3733, 3729},
  {3634, 3688, 3689},
  {3689, 3732, 3635},
  {3638, 3582, 3636},
  {3689, 3688, 3734},
  {3689, 3734, 3732},
  {3639, 3432, 3736},
  {3584, 3789, 3429},
  {3839, 3429, 3789},
  {3789, 3584, 3792},
  {3585, 3735, 3840},
  {3586, 3839, 3738},
  {3587, 3586, 3738},
  {3641, 3691, 3841},
  {3692, 3736, 3640},
  {3692, 3693, 3736},
  {3692, 3640, 3740},
  {3692, 3740, 3693},
  {3641, 3841, 3643},
  {3793, 3844, 3484},
  {3642, 3486, 3844},
  {3644, 3588, 3739},
  {3645, 3739, 3588},
  {3740, 3589, 3892},
  {3590, 3892, 3589},
  {3695, 3646, 3742},
  {3647, 3695, 3743},
  {3898, 3698, 3494},
  {3648, 3593, 3647},
  {3647, 3743, 3648},
  {3649, 3648, 3743},
  {3649, 3744, 3496},
  {3702, 3746, 3697},
  {3496, 3744, 3651},
  {3696, 3700, 3698},
  {3650, 3801, 3795},
  {3698, 3700, 3701},
  {3651, 3797, 3655},
  {3652, 3801, 3650},
  {3696, 3699, 3700},
  {3654, 3652, 3653},
  {3748, 3655, 3747},
  {3539, 3748, 3702},
  {3540, 3750, 3654},
  {3656, 3749, 3657},
  {3703, 3657, 3749},
  {3659, 3755, 3750},
  {3657, 3703, 3598},
  {3660, 3752, 3704},
  {3542, 3659, 3658},
  {3661, 3754, 3756},
  {3661, 3756, 3663},
  {3753, 3706, 3662},
  {3664, 3705, 3603},
  {3662, 3706, 3609},
  {3663, 3756, 3806},
  {3663, 3806, 3760},
  {3603, 3665, 3664},
  {3611, 3807, 3707},
  {3670, 3807, 3611},
  {3710, 3659, 3709},
  {3666, 3710, 3709},
  {3667, 3760, 3763},
  {3666, 3552, 3761},
  {3668, 3765, 3764},
  {3711, 3762, 3610},
  {3552, 3668, 3761},
  {3764, 3761, 3668},
  {3609, 3813, 3670},
  {3667, 3763, 3768},
  {3667, 3768, 3669},
  {3555, 3669, 3768},
  {3555, 3768, 3713},
  {3671, 3612, 3819},
  {3712, 3771, 3714},
  {3769, 3513, 3772},
  {3613, 3612, 3671},
  {3560, 3671, 3774},
  {3715, 3557, 3717},
  {3617, 3924, 3716},
  {3558, 3618, 3924},
  {3616, 3675, 3672},
  {3622, 3673, 3776},
  {3617, 3716, 3676},
  {3720, 3676, 3716},
  {3622, 3776, 3826},
  {3719, 3674, 3567},
  {3675, 3622, 3777},
  {3719, 3567, 3677},
  {3720, 3721, 3676},
  {3721, 3779, 3722},
  {3721, 3722, 3725},
  {3721, 3725, 3678},
  {3678, 3723, 3626},
  {3626, 3723, 3681},
  {3682, 3724, 3679},
  {3724, 3682, 3684},
  {3685, 3831, 3684},
  {3783, 3679, 3780},
  {3679, 3687, 3780},
  {3831, 3685, 3879},
  {3685, 3783, 3879},
  {3687, 3686, 3782},
  {3727, 3726, 3728},
  {3727, 3729, 3726},
  {3577, 3784, 3836},
  {3727, 3730, 3688},
  {3688, 3730, 3731},
  {3635, 3732, 3786},
  {3635, 3786, 3784},
  {3688, 3731, 3734},
  {3582, 3638, 3733},
  {3637, 3885, 3887},
  {3638, 3639, 3733},
  {3637, 3887, 3584},
  {3736, 3737, 3788},
  {3736, 3733, 3639},
  {3585, 3838, 3690},
  {3585, 3888, 3838},
  {3736, 3693, 3737},
  {3888, 3585, 3840},
  {3737, 3693, 3794},
  {3840, 3735, 3843},
  {3691, 3790, 3841},
  {3691, 3644, 3790},
  {3644, 3739, 3792},
  {3644, 3792, 3791},
  {3793, 3587, 3738},
  {3794, 3693, 3740},
  {3646, 3741, 3742},
  {3742, 3847, 3695},
  {3494, 3697, 3898},
  {3745, 3898, 3697},
  {3744, 3649, 3743},
  {3795, 3801, 4000},
  {3696, 3898, 3699},
  {3697, 3746, 3745},
  {3744, 3797, 3651},
  {3655, 3798, 3747},
  {3654, 3750, 3803},
  {3749, 3751, 3703},
  {3597, 3213, 3660},
  {3703, 3751, 3598},
  {3660, 3853, 3752},
  {3753, 3598, 3751},
  {3661, 3704, 3754},
  {3659, 3757, 3755},
  {3659, 3758, 3757},
  {3757, 3758, 3759},
  {3757, 3759, 3755},
  {3659, 3710, 3758},
  {3758, 3710, 3666},
  {3758, 3666, 3761},
  {3758, 3761, 3759},
  {3766, 3765, 3708},
  {3762, 3766, 3708},
  {3815, 3711, 3610},
  {3817, 3815, 3610},
  {3813, 3865, 3670},
  {3670, 3865, 3767},
  {3770, 3610, 3712},
  {3712, 3714, 3770},
  {3768, 3822, 3713},
  {3671, 3819, 3915},
  {3714, 3771, 3770},
  {3614, 3773, 3771},
  {3671, 3915, 3774},
  {3715, 3773, 3614},
  {3618, 3921, 3927},
  {3618, 3871, 3921},
  {3922, 3717, 3775},
  {3717, 3777, 3775},
  {3825, 3673, 3718},
  {3872, 3720, 3716},
  {3717, 3675, 3777},
  {3718, 3719, 3825},
  {3777, 3778, 3775},
  {3777, 3622, 3778},
  {3779, 3721, 3720},
  {3779, 3782, 3722},
  {3678, 3725, 3723},
  {3725, 3631, 3723},
  {3684, 3877, 3724},
  {3780, 3781, 3783},
  {3780, 3782, 3781},
  {3782, 3780, 3687},
  {3722, 3782, 3686},
  {3722, 3686, 3725},
  {3831, 3877, 3684},
  {3726, 3833, 3728},
  {3785, 3728, 3833},
  {3726, 3729, 3833},
  {3728, 3785, 3730},
  {3728, 3730, 3727},
  {3882, 3730, 3785},
  {3730, 3882, 3731},
  {3729, 3733, 3787},
  {3729, 3787, 3833},
  {3788, 3787, 3733},
  {3733, 3736, 3788},
  {3584, 3887, 3841},
  {3738, 3839, 3889},
  {3737, 3837, 3788},
  {3841, 3790, 3584},
  {3790, 3644, 3791},
  {3790, 3791, 3584},
  {3792, 3584, 3791},
  {3792, 3739, 3891},
  {3839, 3792, 3891},
  {3739, 3642, 3891},
  {3845, 3893, 3534},
  {3534, 3893, 3694},
  {3846, 3694, 3997},
  {3694, 3846, 3741},
  {3590, 3795, 3946},
  {3796, 3743, 3695},
  {3849, 3898, 3745},
  {3743, 3796, 3744},
  {3797, 3744, 3796},
  {3745, 3746, 3849},
  {3699, 3898, 3799},
  {3797, 3798, 3655},
  {3798, 3800, 3747},
  {3747, 3800, 3850},
  {3652, 3654, 3801},
  {3852, 3801, 3654},
  {3850, 3702, 3748},
  {3748, 3747, 3850},
  {3654, 3803, 3852},
  {3749, 3802, 3751},
  {3751, 3802, 3804},
  {3901, 3803, 3750},
  {3660, 3213, 3853},
  {3750, 3755, 3901},
  {3805, 3751, 3804},
  {3853, 3213, 3902},
  {3753, 3751, 3805},
  {3752, 3902, 3704},
  {3752, 3853, 3902},
  {3704, 3902, 3754},
  {3754, 3854, 3756},
  {3759, 3856, 3755},
  {3759, 3761, 3856},
  {3859, 3762, 3811},
  {3858, 3762, 3859},
  {3807, 3670, 3767},
  {3761, 3764, 3856},
  {3856, 3764, 3809},
  {3856, 3809, 3808},
  {3858, 3765, 3766},
  {3810, 3765, 3858},
  {3809, 3764, 3765},
  {3809, 3765, 3812},
  {3809, 3812, 3808},
  {3765, 3810, 3812},
  {3766, 3762, 3858},
  {3762, 3711, 3811},
  {3811, 3711, 3864},
  {3864, 3711, 3814},
  {3711, 3816, 3814},
  {3864, 3814, 3867},
  {3763, 3863, 3768},
  {3711, 3815, 3816},
  {3814, 3816, 3867},
  {3864, 3867, 3818},
  {3768, 3913, 3822},
  {3770, 3817, 3610},
  {3817, 3770, 3815},
  {3820, 3815, 3770},
  {3815, 3820, 3816},
  {3915, 3819, 3769},
  {3820, 3770, 3821},
  {3713, 3822, 3914},
  {3823, 3821, 3770},
  {3770, 3771, 3823},
  {3870, 3823, 3771},
  {3713, 3920, 3772},
  {3774, 3915, 4027},
  {3717, 3771, 3773},
  {3717, 3870, 3771},
  {3715, 3717, 3773},
  {4027, 3871, 3774},
  {3775, 3928, 3922},
  {3927, 3926, 3618},
  {3775, 3974, 3928},
  {3873, 3824, 3776},
  {3776, 3673, 3873},
  {3673, 3825, 3873},
  {3826, 3776, 3824},
  {3775, 3778, 3974},
  {3720, 3872, 3875},
  {3826, 3974, 3778},
  {3778, 3622, 3826},
  {3825, 3719, 3827},
  {3720, 3875, 3779},
  {3825, 3827, 3874},
  {3677, 3827, 3719},
  {3779, 3875, 3828},
  {3828, 3829, 3779},
  {3829, 3782, 3779},
  {3830, 3782, 3829},
  {3830, 3934, 3781},
  {3781, 3934, 3783},
  {3830, 3781, 3782},
  {3879, 3783, 3934},
  {3879, 3933, 3831},
  {3835, 3832, 3786},
  {3832, 3784, 3786},
  {3939, 3784, 3832},
  {3784, 3939, 3836},
  {3882, 3785, 3834},
  {3833, 3787, 3884},
  {3787, 3788, 3884},
  {3735, 3836, 3942},
  {3991, 3690, 3838},
  {3789, 3792, 3839},
  {3945, 3837, 3737},
  {3793, 3738, 3889},
  {3735, 3842, 3843},
  {3844, 3793, 3889},
  {3844, 3889, 3890},
  {3890, 3891, 3642},
  {3642, 3844, 3890},
  {3846, 3894, 3741},
  {3894, 3742, 3741},
  {3847, 3742, 3894},
  {3796, 3695, 3847},
  {3796, 3847, 3848},
  {3796, 3848, 3797},
  {3696, 3698, 3898},
  {3848, 3896, 3797},
  {3896, 3899, 3798},
  {3797, 3896, 3798},
  {3799, 3898, 3900},
  {3798, 3899, 3800},
  {3702, 3850, 3746},
  {3850, 3800, 3851},
  {3799, 3802, 3699},
  {3803, 3901, 3852},
  {3804, 3802, 3805},
  {3805, 4009, 3753},
  {3754, 3902, 3854},
  {3451, 4108, 3902},
  {3756, 3854, 3855},
  {3707, 4111, 3451},
  {3756, 3855, 3960},
  {3756, 3960, 3806},
  {3806, 3960, 3904},
  {3806, 3904, 3760},
  {3755, 3856, 3958},
  {3707, 3807, 4111},
  {3760, 3904, 3857},
  {3905, 3856, 3808},
  {3860, 3905, 3808},
  {3706, 3753, 3862},
  {3706, 3862, 3609},
  {3760, 3857, 3965},
  {3760, 3965, 3763},
  {3858, 3861, 3810},
  {3763, 3965, 3863},
  {3808, 3812, 3860},
  {3861, 3860, 3812},
  {3812, 3810, 3861},
  {3609, 3862, 3813},
  {3813, 3862, 3910},
  {3813, 3910, 3865},
  {3767, 3912, 3866},
  {3865, 3912, 3767},
  {3816, 3820, 3867},
  {3865, 3911, 3912},
  {3913, 3914, 3822},
  {3820, 3821, 3868},
  {3820, 3868, 3867},
  {3821, 3823, 3919},
  {3821, 3919, 3868},
  {3914, 3869, 3713},
  {3823, 3870, 3923},
  {3823, 3923, 3919},
  {3920, 3713, 3869},
  {4029, 3772, 3920},
  {3716, 3924, 3972},
  {3826, 3824, 3930},
  {3824, 3929, 3930},
  {3825, 3874, 3873},
  {3874, 3827, 3877},
  {3877, 3932, 3874},
  {3875, 3876, 3828},
  {3829, 3828, 3876},
  {3877, 3827, 3724},
  {3878, 3829, 3980},
  {3830, 3829, 3878},
  {3933, 3877, 3831},
  {3878, 3934, 3830},
  {3834, 3785, 3833},
  {3880, 3832, 3881},
  {3835, 3881, 3832},
  {3832, 3940, 3939},
  {3938, 3935, 3833},
  {3833, 3935, 3834},
  {3834, 3935, 3937},
  {4091, 3936, 3880},
  {3834, 3937, 3882},
  {3880, 3881, 4091},
  {3883, 4091, 3881},
  {3881, 3835, 3732},
  {3786, 3732, 3835},
  {3881, 3732, 3734},
  {3881, 3734, 3883},
  {3833, 3884, 3938},
  {3885, 3690, 3941},
  {3734, 3731, 3883},
  {3882, 3886, 3731},
  {3731, 3886, 3883},
  {3788, 4047, 3884},
  {3888, 3840, 3842},
  {3839, 3891, 3890},
  {3839, 3890, 3889},
  {3737, 3794, 3945},
  {3843, 3842, 3840},
  {3945, 3794, 3995},
  {3643, 3841, 4051},
  {3643, 4051, 3996},
  {3794, 3740, 3995},
  {3995, 3740, 3892},
  {4000, 3946, 3795},
  {3847, 3895, 3848},
  {3896, 3897, 3899},
  {3900, 3898, 3952},
  {3899, 4004, 3951},
  {3899, 3951, 3800},
  {3849, 3746, 3953},
  {3799, 3900, 4103},
  {3746, 3850, 3953},
  {3954, 3850, 3851},
  {3851, 3800, 3954},
  {3799, 4054, 3802},
  {3852, 3901, 3956},
  {3802, 4008, 3805},
  {4009, 3805, 4008},
  {3901, 3903, 3956},
  {3755, 3958, 3901},
  {3901, 3958, 3903},
  {4109, 3902, 4108},
  {3854, 4109, 3855},
  {3856, 3905, 3958},
  {3905, 3860, 3906},
  {3861, 3858, 3907},
  {3859, 3908, 3907},
  {3859, 3907, 3858},
  {3859, 4016, 3908},
  {3859, 3811, 4016},
  {3811, 3864, 3966},
  {4111, 3807, 3767},
  {3861, 3967, 3860},
  {3864, 3909, 3966},
  {3863, 3968, 3768},
  {3910, 3911, 3865},
  {4067, 3767, 3866},
  {3866, 3912, 4067},
  {3913, 3768, 3969},
  {3911, 5901, 3912},
  {3867, 3917, 5902},
  {3868, 3919, 3867},
  {3916, 3867, 3919},
  {3867, 3916, 3917},
  {3918, 3769, 3772},
  {4029, 3918, 3772},
  {3769, 3918, 3915},
  {3914, 4026, 3869},
  {3869, 4026, 3971},
  {3869, 3971, 3920},
  {3920, 3971, 4074},
  {3922, 3923, 3717},
  {3717, 3923, 3870},
  {3926, 3924, 3618},
  {3921, 3925, 3927},
  {3873, 3929, 3824},
  {3930, 3974, 3826},
  {3872, 3931, 3875},
  {3875, 3931, 3978},
  {3874, 3977, 3873},
  {3876, 3875, 3978},
  {3874, 3932, 3977},
  {3876, 3978, 3829},
  {3978, 3980, 3829},
  {3877, 3933, 3932},
  {3878, 3980, 4040},
  {3934, 3878, 4040},
  {3879, 3934, 3981},
  {3984, 3880, 3936},
  {3984, 3832, 3880},
  {3940, 3832, 3984},
  {3935, 3938, 3982},
  {3936, 4091, 3983},
  {3937, 3987, 3882},
  {3940, 3942, 3939},
  {3941, 3988, 3885},
  {4048, 3942, 3986},
  {3942, 3836, 3939},
  {3882, 3987, 3886},
  {4091, 3883, 3886},
  {3989, 3942, 4048},
  {3690, 3991, 3941},
  {4047, 3788, 3837},
  {3837, 3944, 4047},
  {4137, 3943, 3989},
  {3989, 3943, 3942},
  {3735, 3942, 3943},
  {3994, 3735, 3943},
  {3945, 3944, 3837},
  {3735, 3994, 3842},
  {3996, 4098, 3845},
  {3846, 4052, 3894},
  {4052, 3847, 3894},
  {3590, 3946, 3998},
  {3847, 4052, 3895},
  {3948, 3895, 4052},
  {3895, 3896, 3848},
  {3895, 3948, 3896},
  {3896, 3948, 3897},
  {3898, 3849, 3950},
  {4005, 3949, 3947},
  {3952, 3898, 4002},
  {3849, 3953, 3950},
  {4005, 4006, 3949},
  {3949, 3954, 3951},
  {3951, 3954, 3800},
  {4000, 3801, 4146},
  {3850, 4007, 3953},
  {3850, 3954, 3955},
  {4054, 3799, 4103},
  {3801, 3852, 3956},
  {4054, 4008, 3802},
  {3956, 3903, 3957},
  {3902, 4109, 3854},
  {3958, 3957, 3903},
  {4111, 4108, 3451},
  {4109, 4014, 3855},
  {3960, 3855, 4014},
  {3958, 3905, 4012},
  {4012, 3905, 3959},
  {4018, 3959, 3905},
  {4059, 3857, 3904},
  {3904, 3960, 4059},
  {3905, 3906, 4018},
  {3907, 3961, 3861},
  {3962, 3907, 3908},
  {3908, 4016, 3962},
  {3963, 4016, 3811},
  {3964, 3963, 3811},
  {3811, 3966, 3964},
  {3862, 4021, 3910},
  {3857, 4059, 3965},
  {3967, 4018, 3906},
  {3861, 3961, 3967},
  {3966, 3909, 3964},
  {3863, 3965, 3968},
  {3906, 3860, 3967},
  {4025, 3909, 3864},
  {3910, 4065, 3911},
  {3768, 3968, 3969},
  {3915, 3918, 4027},
  {3917, 3916, 3919},
  {3917, 3919, 4125},
  {3871, 4027, 4073},
  {3923, 4075, 3919},
  {3971, 4030, 4074},
  {4029, 3920, 4074},
  {3921, 3871, 4073},
  {3921, 4076, 3925},
  {3716, 3972, 3872},
  {3925, 4031, 3927},
  {3922, 3928, 4078},
  {3872, 4080, 3931},
  {3924, 3926, 4032},
  {3928, 3974, 4078},
  {3873, 3973, 3929},
  {3930, 3929, 4033},
  {3873, 3975, 3973},
  {3931, 3976, 3978},
  {4037, 3978, 3976},
  {3873, 3977, 3975},
  {3978, 4037, 4036},
  {3932, 3879, 3977},
  {3977, 3879, 3979},
  {3977, 3979, 3975},
  {3980, 3978, 4039},
  {3932, 3933, 3879},
  {3981, 3979, 3879},
  {3981, 3934, 4040},
  {3935, 3982, 3937},
  {3936, 3983, 3984},
  {3937, 3982, 3985},
  {3937, 3985, 3987},
  {3938, 3884, 4043},
  {3986, 3942, 3940},
  {3984, 3986, 3940},
  {4047, 4043, 3884},
  {3991, 3988, 3941},
  {3886, 3987, 4091},
  {3992, 4188, 4047},
  {3989, 3990, 4049},
  {4047, 3944, 3992},
  {3989, 4049, 4137},
  {3993, 3992, 3944},
  {3838, 4136, 3991},
  {3888, 4136, 3838},
  {3993, 3944, 4050},
  {3842, 4093, 3888},
  {3944, 3945, 4050},
  {3694, 3893, 4142},
  {4098, 3996, 4096},
  {3946, 4000, 3998},
  {4142, 4001, 3947},
  {4143, 3590, 3998},
  {3948, 4052, 4004},
  {3947, 3949, 3999},
  {3948, 4004, 3897},
  {3899, 3897, 4004},
  {3947, 4001, 4003},
  {4005, 3947, 4003},
  {4002, 3898, 4100},
  {3949, 3955, 3954},
  {3949, 4006, 3955},
  {4006, 4007, 3850},
  {3955, 4006, 3850},
  {3801, 3956, 4146},
  {3956, 3957, 4104},
  {3957, 3958, 4010},
  {4011, 3753, 4009},
  {3958, 4012, 4010},
  {4013, 3753, 4011},
  {4012, 3959, 4055},
  {4057, 3753, 4013},
  {3959, 4018, 4015},
  {3959, 4015, 4055},
  {3753, 4057, 3862},
  {3962, 4016, 4017},
  {4021, 3862, 4057},
  {3961, 3907, 4019},
  {4020, 3961, 4019},
  {3907, 4017, 4019},
  {3907, 3962, 4017},
  {4016, 3963, 4058},
  {3964, 4117, 3963},
  {4111, 3767, 4295},
  {3961, 4020, 3967},
  {3964, 4023, 4117},
  {3964, 3909, 4023},
  {3967, 4022, 4018},
  {3967, 4020, 4022},
  {3767, 4067, 4295},
  {3968, 4066, 3969},
  {4024, 3969, 4066},
  {3913, 3969, 4024},
  {3913, 4024, 4068},
  {4068, 3914, 3913},
  {3912, 5901, 4069},
  {3917, 4071, 5902},
  {4028, 4071, 3917},
  {3917, 4125, 4028},
  {3919, 4075, 4125},
  {4026, 4161, 3971},
  {3971, 4161, 4127},
  {3971, 4127, 4030},
  {4128, 4080, 3872},
  {3872, 3972, 4128},
  {4079, 4128, 3972},
  {3972, 3924, 4079},
  {4032, 4079, 3924},
  {3927, 4031, 3926},
  {4081, 4033, 3929},
  {3929, 3973, 4081},
  {3931, 4080, 4084},
  {4031, 4032, 3926},
  {4083, 4081, 3973},
  {3974, 3930, 4034},
  {4033, 4034, 3930},
  {3973, 3975, 4083},
  {4035, 4083, 3975},
  {3975, 3979, 4035},
  {4130, 4035, 3979},
  {4087, 4130, 3979},
  {4039, 3978, 4036},
  {4038, 4087, 3979},
  {3979, 3981, 4038},
  {3981, 4040, 4038},
  {4041, 4038, 4040},
  {3980, 4039, 4040},
  {4041, 4040, 4039},
  {3982, 3938, 4042},
  {3982, 4042, 4045},
  {3938, 4043, 4042},
  {3983, 4044, 3984},
  {3982, 4045, 4046},
  {3982, 4046, 3985},
  {3985, 4046, 3987},
  {4090, 3987, 4046},
  {4183, 3989, 4048},
  {3990, 3989, 4183},
  {3885, 3988, 3887},
  {4092, 4047, 4188},
  {4093, 3842, 3994},
  {4050, 4094, 3993},
  {4139, 4050, 3945},
  {3945, 3995, 4095},
  {3995, 4141, 4095},
  {4142, 3997, 3694},
  {3893, 3845, 4098},
  {3590, 4143, 4289},
  {4052, 3999, 4004},
  {3999, 3949, 4004},
  {3949, 3951, 4004},
  {3950, 4053, 3898},
  {3898, 4053, 4195},
  {4053, 3950, 4101},
  {4002, 4145, 3952},
  {3900, 3952, 4145},
  {3950, 3953, 4101},
  {3898, 4195, 4100},
  {4007, 4102, 3953},
  {4006, 4005, 4102},
  {3956, 4104, 4146},
  {3900, 4145, 4103},
  {4105, 4104, 3957},
  {4010, 4105, 3957},
  {4008, 4103, 4009},
  {4009, 4103, 4106},
  {4055, 4105, 4012},
  {4105, 4055, 4196},
  {4009, 4106, 4107},
  {4009, 4107, 4011},
  {4011, 4114, 4013},
  {4013, 4114, 4057},
  {4055, 4015, 4056},
  {4244, 4059, 3960},
  {4015, 4018, 4056},
  {4058, 4017, 4016},
  {4021, 4057, 4061},
  {4057, 4114, 4061},
  {4154, 4060, 4019},
  {4019, 4060, 4020},
  {4019, 4017, 4154},
  {4117, 4058, 3963},
  {3965, 4059, 4066},
  {4060, 4064, 4020},
  {5899, 4117, 4023},
  {4061, 3910, 4021},
  {4061, 4062, 3910},
  {3965, 4066, 3968},
  {4018, 4022, 4063},
  {4064, 4063, 4022},
  {4022, 4020, 4064},
  {4023, 3909, 5899},
  {4025, 5899, 3909},
  {4066, 4119, 4024},
  {4122, 4067, 3912},
  {3914, 4068, 4026},
  {4069, 5901, 4070},
  {4069, 4072, 3912},
  {3918, 4073, 4027},
  {4028, 4125, 4071},
  {4073, 3918, 4029},
  {4077, 3923, 3922},
  {4077, 4075, 3923},
  {4127, 4167, 4030},
  {4031, 3925, 4076},
  {4077, 3922, 4078},
  {4032, 4171, 4216},
  {4032, 4031, 4171},
  {4078, 3974, 4034},
  {4078, 4034, 4082},
  {4034, 4033, 4082},
  {4033, 4129, 4082},
  {3931, 4084, 3976},
  {4084, 4085, 3976},
  {4085, 4086, 3976},
  {3976, 4086, 4037},
  {4036, 4089, 4039},
  {4036, 4037, 4178},
  {4037, 4086, 4178},
  {4038, 4041, 4087},
  {4087, 4041, 4088},
  {4178, 4039, 4089},
  {4041, 4039, 4131},
  {4134, 4044, 3983},
  {4044, 4133, 3984},
  {3983, 4091, 4134},
  {3984, 4133, 3986},
  {4046, 4045, 4182},
  {4046, 4182, 4090},
  {3986, 4133, 4048},
  {4043, 4047, 4132},
  {4092, 4132, 4047},
  {3988, 4185, 3887},
  {3887, 4185, 4138},
  {4282, 4188, 3992},
  {3992, 3993, 4282},
  {4093, 4136, 3888},
  {3994, 3943, 4137},
  {3994, 4137, 4093},
  {4093, 4137, 4189},
  {3841, 3887, 4051},
  {3945, 4191, 4139},
  {3945, 4095, 4191},
  {4096, 3996, 4285},
  {4141, 3995, 3892},
  {4142, 3947, 3997},
  {3997, 3947, 3999},
  {3997, 3999, 4052},
  {4142, 3893, 4099},
  {3997, 4052, 3846},
  {4096, 4097, 4098},
  {4099, 3893, 4098},
  {3998, 4000, 4143},
  {4001, 4142, 4144},
  {4236, 4143, 4000},
  {4146, 4236, 4000},
  {4101, 4195, 4053},
  {3953, 4147, 4240},
  {4102, 4147, 3953},
  {4102, 4007, 4006},
  {4145, 4332, 4103},
  {4103, 4008, 4054},
  {4010, 4012, 4105},
  {4014, 4109, 4108},
  {4055, 4110, 4196},
  {4055, 4056, 4110},
  {4011, 4148, 4114},
  {4244, 3960, 4014},
  {4056, 4115, 4110},
  {4056, 4018, 4115},
  {4017, 4058, 4112},
  {4017, 4112, 4154},
  {4058, 4113, 4112},
  {4113, 4117, 4112},
  {4113, 4058, 4117},
  {4060, 4154, 4116},
  {4114, 4117, 4062},
  {4114, 4062, 4061},
  {4018, 4063, 4115},
  {4064, 4060, 4116},
  {4064, 4116, 4118},
  {4117, 5899, 4065},
  {4117, 4065, 4062},
  {4062, 4065, 3910},
  {4063, 4118, 4115},
  {4063, 4064, 4118},
  {4067, 4122, 4159},
  {4024, 4158, 4068},
  {4120, 4068, 4158},
  {4068, 4120, 4026},
  {4160, 4026, 4120},
  {4070, 5901, 4121},
  {5902, 4071, 4121},
  {4123, 4121, 4071},
  {4121, 4123, 4069},
  {4069, 4123, 4072},
  {4072, 4162, 3912},
  {4122, 3912, 4162},
  {4124, 4071, 4125},
  {4071, 4124, 4123},
  {4162, 4123, 4124},
  {4073, 4029, 4074},
  {4074, 4126, 4073},
  {3921, 4073, 4126},
  {4161, 4163, 4127},
  {4074, 4030, 4126},
  {4076, 4126, 4030},
  {4126, 4076, 3921},
  {4077, 4165, 4164},
  {4077, 4164, 4075},
  {4030, 4167, 4076},
  {4031, 4076, 4167},
  {4078, 4168, 4077},
  {4078, 4082, 4168},
  {4080, 4169, 4170},
  {4080, 4170, 4084},
  {4214, 4128, 4079},
  {4032, 4214, 4079},
  {4170, 4174, 4084},
  {4129, 4033, 4081},
  {4082, 4129, 4172},
  {4083, 4035, 4173},
  {4130, 4173, 4035},
  {4084, 4174, 4175},
  {4084, 4175, 4085},
  {4085, 4176, 4086},
  {4085, 4220, 4176},
  {4088, 4130, 4087},
  {4178, 4089, 4036},
  {4178, 4086, 4176},
  {4041, 4131, 4088},
  {4039, 4178, 4131},
  {4043, 4132, 4179},
  {4044, 4134, 4223},
  {4044, 4223, 4133},
  {4133, 4223, 4224},
  {4048, 4133, 4181},
  {4132, 4092, 4135},
  {4134, 4091, 4090},
  {4048, 4181, 4183},
  {3991, 4226, 3988},
  {3987, 4090, 4091},
  {3991, 4136, 4226},
  {4092, 4188, 4135},
  {4228, 4136, 4189},
  {4136, 4093, 4189},
  {3993, 4094, 4282},
  {4049, 4230, 4137},
  {3887, 4138, 4051},
  {4139, 4283, 4050},
  {4190, 4050, 4283},
  {4050, 4190, 4094},
  {4285, 3996, 4051},
  {3590, 4289, 3892},
  {4099, 4237, 4142},
  {4002, 4100, 4756},
  {4001, 4144, 4193},
  {4001, 4193, 4003},
  {4005, 4003, 4193},
  {4101, 3953, 4240},
  {4100, 4195, 4194},
  {4005, 4239, 4102},
  {4104, 4105, 4196},
  {4103, 4107, 4106},
  {4246, 4107, 4103},
  {4011, 4107, 4148},
  {4107, 4246, 4148},
  {4014, 4108, 4244},
  {4196, 4110, 4198},
  {4149, 4152, 4148},
  {4114, 4148, 4152},
  {4150, 4198, 4110},
  {4152, 4151, 4114},
  {4110, 4115, 4150},
  {4111, 4247, 4108},
  {4111, 4295, 4247},
  {4154, 4153, 4116},
  {4251, 4116, 4153},
  {4203, 4112, 4117},
  {4203, 4117, 4151},
  {4114, 4151, 4117},
  {4059, 4200, 4066},
  {4155, 4150, 4115},
  {4116, 4251, 4156},
  {4066, 4205, 4119},
  {4118, 4116, 4156},
  {4118, 4156, 4157},
  {4115, 4118, 4155},
  {4157, 4155, 4118},
  {4295, 4067, 4159},
  {4024, 4119, 4209},
  {4024, 4209, 4158},
  {4158, 4210, 4120},
  {4159, 4122, 4257},
  {4210, 4160, 4120},
  {4160, 4161, 4026},
  {4123, 4162, 4072},
  {4075, 4164, 4125},
  {4163, 4261, 4166},
  {4163, 4166, 4127},
  {4165, 4077, 4264},
  {4127, 4166, 4167},
  {4168, 4264, 4077},
  {4031, 4167, 4212},
  {4080, 4128, 4169},
  {4128, 4214, 4213},
  {4032, 4216, 4359},
  {4082, 4267, 4168},
  {4081, 4083, 4173},
  {4082, 4172, 4217},
  {4082, 4217, 4267},
  {4129, 4081, 4215},
  {4129, 4215, 4172},
  {4081, 4173, 4215},
  {4130, 4219, 4173},
  {4085, 4175, 4220},
  {4088, 4221, 4130},
  {4088, 4131, 4273},
  {4131, 4177, 4273},
  {4177, 4131, 4178},
  {4042, 4179, 4045},
  {4179, 4132, 4180},
  {4132, 4135, 4180},
  {4134, 4225, 4223},
  {4182, 4045, 4179},
  {4181, 4133, 4224},
  {4182, 4225, 4090},
  {4090, 4225, 4134},
  {4135, 4184, 4180},
  {4135, 4188, 4184},
  {4226, 4136, 4228},
  {4226, 4185, 3988},
  {4183, 4186, 3990},
  {4138, 4185, 4187},
  {3990, 4186, 4049},
  {4231, 4138, 4187},
  {4230, 4049, 4186},
  {4232, 4189, 4137},
  {4137, 4234, 4420},
  {4137, 4374, 4232},
  {4374, 4233, 4232},
  {4137, 4420, 4374},
  {4141, 4191, 4095},
  {4141, 4235, 4422},
  {4141, 3892, 4235},
  {4097, 4096, 4286},
  {4097, 4286, 4098},
  {4142, 4237, 4144},
  {4144, 4238, 4193},
  {4100, 4192, 4756},
  {4005, 4193, 4239},
  {4195, 4101, 4240},
  {4239, 4147, 4102},
  {4100, 4194, 4328},
  {4242, 4194, 4195},
  {4146, 4104, 4196},
  {4197, 4246, 4103},
  {4246, 4149, 4148},
  {4245, 4244, 4108},
  {4149, 4246, 4152},
  {4245, 4108, 4247},
  {4198, 4150, 4199},
  {4201, 4199, 4150},
  {4152, 4246, 4151},
  {4244, 4200, 4059},
  {4153, 4154, 4112},
  {4203, 4202, 4112},
  {4066, 4200, 4205},
  {4150, 4155, 4201},
  {4251, 4204, 4156},
  {4205, 4256, 4119},
  {4206, 4201, 4155},
  {4204, 4207, 4156},
  {4156, 4207, 4157},
  {4254, 4206, 4155},
  {4155, 4157, 4208},
  {4155, 4208, 4254},
  {4157, 4207, 4208},
  {4119, 4256, 4209},
  {4160, 4303, 4161},
  {4162, 4260, 4122},
  {4124, 4260, 4162},
  {4161, 4303, 4163},
  {4164, 4262, 4125},
  {4163, 4303, 4261},
  {4164, 4165, 4304},
  {4166, 4261, 4263},
  {4166, 4263, 4211},
  {4166, 4211, 4167},
  {4167, 4211, 4212},
  {4169, 4128, 4306},
  {4168, 4266, 4264},
  {4170, 4169, 4307},
  {4168, 4267, 4266},
  {4170, 4307, 4174},
  {4032, 4359, 4214},
  {4217, 4268, 4267},
  {4218, 4174, 4307},
  {4215, 4173, 4219},
  {4174, 4218, 4175},
  {4269, 4175, 4218},
  {4175, 4269, 4220},
  {4219, 4130, 4221},
  {4221, 4088, 4222},
  {4178, 4220, 4177},
  {4220, 4178, 4176},
  {4273, 4222, 4088},
  {4220, 4273, 4177},
  {4320, 4179, 4369},
  {4223, 4225, 4276},
  {4179, 4320, 4182},
  {4224, 4279, 4181},
  {4180, 4184, 4227},
  {4183, 4181, 4186},
  {4280, 4186, 4181},
  {4185, 4226, 4228},
  {4187, 4185, 4228},
  {4188, 4227, 4184},
  {4227, 4188, 4229},
  {4186, 4280, 4230},
  {4187, 4228, 4322},
  {4231, 4187, 4322},
  {4229, 4188, 4282},
  {4232, 4233, 4321},
  {4094, 4190, 4284},
  {4230, 4234, 4137},
  {4138, 4231, 4051},
  {4140, 4051, 4231},
  {4231, 4322, 4140},
  {4287, 4099, 4098},
  {4143, 4236, 4288},
  {4238, 4144, 4237},
  {4756, 4145, 4002},
  {4099, 4525, 4237},
  {4239, 4193, 4238},
  {4192, 4100, 4382},
  {4239, 4330, 4147},
  {4241, 4328, 4194},
  {4147, 4330, 4240},
  {4194, 4242, 4241},
  {4195, 4331, 4242},
  {4195, 4240, 4331},
  {4332, 4197, 4103},
  {4197, 4291, 4243},
  {4243, 4291, 4293},
  {4243, 4293, 4197},
  {4199, 4292, 4198},
  {4247, 4200, 4245},
  {4199, 4201, 4248},
  {4203, 4151, 4246},
  {4203, 4246, 4293},
  {4203, 4293, 4249},
  {4201, 4250, 4248},
  {4112, 4294, 4153},
  {4153, 4294, 4251},
  {4112, 4202, 4345},
  {4201, 4252, 4250},
  {4204, 4251, 4297},
  {4205, 4295, 4256},
  {4201, 4206, 4252},
  {4207, 4204, 4297},
  {4207, 4297, 4255},
  {4206, 4254, 4253},
  {4206, 4253, 4252},
  {4208, 4207, 4255},
  {4208, 4255, 4254},
  {4256, 4347, 4209},
  {4295, 4159, 4257},
  {4209, 4347, 4158},
  {4210, 4158, 4347},
  {4210, 4347, 4258},
  {4122, 4398, 4257},
  {4160, 4210, 4258},
  {4160, 4258, 4259},
  {4160, 4259, 4303},
  {4122, 4260, 4398},
  {4304, 4165, 4264},
  {4263, 4305, 4211},
  {4211, 4305, 4265},
  {4307, 4169, 4351},
  {4306, 4128, 4213},
  {4265, 4171, 4211},
  {4211, 4171, 4031},
  {4211, 4031, 4212},
  {4213, 4353, 4306},
  {4213, 4214, 4356},
  {4265, 4216, 4171},
  {4359, 4216, 4308},
  {4172, 4215, 4309},
  {4215, 4219, 4309},
  {4311, 4309, 4219},
  {4220, 4270, 4271},
  {4270, 4220, 4269},
  {4311, 4219, 4272},
  {4221, 4272, 4219},
  {4222, 4272, 4221},
  {4270, 4315, 4271},
  {4220, 4271, 4273},
  {4273, 4272, 4222},
  {4274, 4317, 4180},
  {4276, 4275, 4223},
  {4277, 4223, 4275},
  {4223, 4277, 4224},
  {4274, 4180, 4318},
  {4278, 4318, 4180},
  {4224, 4277, 4279},
  {4182, 4320, 4225},
  {4227, 4278, 4180},
  {4278, 4227, 4229},
  {4228, 4189, 4281},
  {4189, 4232, 4281},
  {4232, 4321, 4281},
  {4283, 4139, 4421},
  {4190, 4283, 4284},
  {4191, 4141, 4422},
  {4286, 4096, 4423},
  {4324, 4235, 4289},
  {4098, 4286, 4287},
  {4235, 3892, 4289},
  {4288, 4289, 4143},
  {4525, 4327, 4237},
  {4146, 4290, 4236},
  {4239, 4238, 4237},
  {4328, 4382, 4100},
  {4241, 4242, 4331},
  {4240, 4330, 4331},
  {4293, 4291, 4332},
  {4293, 4246, 4197},
  {4199, 4334, 4292},
  {4199, 4248, 4334},
  {4248, 4250, 4335},
  {4249, 4336, 4203},
  {4200, 4247, 4205},
  {4250, 4296, 4335},
  {4294, 4112, 4345},
  {4202, 4203, 4336},
  {4202, 4336, 4345},
  {4247, 4295, 4205},
  {4296, 4250, 4252},
  {4296, 4252, 4301},
  {4296, 4301, 4339},
  {4251, 4341, 4297},
  {4301, 4302, 4298},
  {4255, 4297, 4299},
  {4300, 4255, 4299},
  {4252, 4253, 4301},
  {4253, 4254, 4300},
  {4253, 4300, 4301},
  {4254, 4255, 4300},
  {4302, 4301, 4346},
  {4261, 4350, 4263},
  {4164, 4304, 4262},
  {4352, 4351, 4169},
  {4169, 4306, 4352},
  {4354, 4216, 4265},
  {4359, 4356, 4214},
  {4267, 4268, 4357},
  {4309, 4268, 4217},
  {4217, 4172, 4309},
  {4363, 4269, 4218},
  {4312, 4357, 4268},
  {4309, 4312, 4268},
  {4313, 4270, 4310},
  {4313, 4310, 4358},
  {4363, 4310, 4270},
  {4270, 4269, 4363},
  {4313, 4314, 4270},
  {4315, 4270, 4314},
  {4367, 4365, 4272},
  {4316, 4367, 4272},
  {4272, 4273, 4316},
  {4271, 4316, 4273},
  {4274, 4318, 4414},
  {4274, 4414, 4317},
  {4277, 4275, 4413},
  {4318, 4278, 4319},
  {4276, 4225, 4320},
  {4229, 4319, 4278},
  {4279, 4370, 4181},
  {4281, 4321, 4373},
  {4282, 4094, 4284},
  {4234, 4618, 4420},
  {4233, 4374, 4321},
  {4051, 4323, 4285},
  {4191, 4422, 4139},
  {4096, 4285, 4375},
  {4325, 4324, 4289},
  {4287, 4286, 4326},
  {4287, 4326, 4099},
  {4525, 4099, 4326},
  {4290, 4288, 4236},
  {4146, 4477, 4290},
  {4756, 4192, 4381},
  {4330, 4239, 4237},
  {4237, 4327, 4383},
  {4385, 4237, 4329},
  {4237, 4384, 4329},
  {4237, 4385, 4330},
  {4241, 4331, 4387},
  {4241, 4387, 4328},
  {4331, 4330, 4385},
  {4292, 4333, 4427},
  {4292, 4334, 4333},
  {4245, 4200, 4244},
  {4334, 4248, 4335},
  {4249, 4293, 4429},
  {4339, 4335, 4296},
  {4251, 4294, 4340},
  {4251, 4340, 4341},
  {4294, 4345, 4340},
  {4298, 4393, 4338},
  {4338, 4339, 4301},
  {4338, 4301, 4298},
  {4297, 4343, 4299},
  {4297, 4341, 4439},
  {4297, 4439, 4343},
  {4298, 4346, 4393},
  {4299, 4344, 4301},
  {4299, 4301, 4300},
  {4299, 4343, 4394},
  {4299, 4394, 4344},
  {4347, 4256, 4295},
  {4295, 4257, 4441},
  {4397, 4258, 4347},
  {4397, 4259, 4258},
  {4397, 4303, 4259},
  {4303, 4397, 4348},
  {4303, 4348, 4261},
  {4350, 4261, 4348},
  {4449, 4398, 4260},
  {4453, 4260, 4124},
  {4453, 4124, 4125},
  {4401, 4125, 4262},
  {4263, 4454, 4305},
  {4504, 4456, 4264},
  {4403, 4307, 4457},
  {4561, 4352, 4306},
  {4305, 4402, 4265},
  {4267, 5904, 4266},
  {4307, 4403, 4218},
  {4404, 4218, 4403},
  {4354, 4265, 4402},
  {4213, 4356, 4353},
  {4354, 4355, 4216},
  {4216, 4355, 4308},
  {4360, 4308, 4355},
  {4362, 4358, 4407},
  {4218, 4409, 4363},
  {4360, 4359, 4308},
  {4357, 4312, 4361},
  {4312, 4309, 4311},
  {4313, 4358, 4362},
  {4310, 4363, 4463},
  {4362, 4366, 4313},
  {4314, 4313, 4366},
  {4312, 4311, 4364},
  {4365, 4364, 4311},
  {4272, 4365, 4311},
  {4271, 4315, 4368},
  {4365, 4367, 4412},
  {4316, 4271, 4368},
  {4275, 4276, 4413},
  {4369, 4413, 4276},
  {4318, 4319, 4511},
  {4318, 4511, 4467},
  {4319, 4516, 4511},
  {4369, 4276, 4320},
  {4319, 4229, 4516},
  {4277, 4417, 4418},
  {4277, 4418, 4279},
  {4418, 4370, 4279},
  {4181, 4370, 4371},
  {4181, 4371, 4280},
  {4228, 4281, 4372},
  {4372, 4281, 4472},
  {4229, 4282, 4473},
  {4280, 4371, 4618},
  {4280, 4618, 4230},
  {4281, 4373, 4575},
  {4282, 4284, 4473},
  {4230, 4618, 4234},
  {4373, 4321, 4578},
  {4420, 4475, 4374},
  {4140, 4578, 4051},
  {4051, 4578, 4323},
  {4323, 4375, 4285},
  {4423, 4096, 4375},
  {4583, 4422, 4235},
  {4235, 4324, 4583},
  {4376, 4286, 4423},
  {4324, 4325, 4583},
  {4377, 4286, 4376},
  {4377, 4379, 4286},
  {4326, 4286, 4379},
  {4377, 4378, 4379},
  {4380, 4326, 4379},
  {4380, 4379, 4378},
  {4326, 4380, 4525},
  {4289, 4288, 4477},
  {4288, 4290, 4477},
  {4289, 4477, 4524},
  {4327, 4525, 4383},
  {4383, 4384, 4237},
  {4328, 4387, 4386},
  {4331, 4329, 4387},
  {4331, 4385, 4329},
  {4332, 4388, 4293},
  {4333, 4334, 4732},
  {4334, 4335, 4732},
  {4429, 4336, 4249},
  {4428, 4339, 4342},
  {4342, 4339, 4338},
  {4342, 4338, 4337},
  {4337, 4338, 4390},
  {4342, 4337, 4432},
  {4342, 4432, 4391},
  {4338, 4393, 4434},
  {4338, 4434, 4390},
  {4395, 4392, 4393},
  {4343, 4439, 4394},
  {4393, 4346, 4395},
  {4346, 4301, 4395},
  {4396, 4395, 4301},
  {4301, 4344, 4396},
  {4344, 4394, 4396},
  {4443, 4396, 4394},
  {4295, 4441, 4347},
  {4302, 4346, 4298},
  {4399, 4348, 4397},
  {4399, 4350, 4348},
  {4398, 4449, 4496},
  {4260, 4453, 4449},
  {4350, 4399, 4349},
  {4400, 4349, 4399},
  {4399, 4448, 4400},
  {4452, 4400, 4448},
  {4350, 4349, 4263},
  {4400, 4263, 4349},
  {4125, 4401, 4453},
  {4454, 4263, 4400},
  {4304, 4455, 4262},
  {4401, 4262, 4455},
  {4454, 4402, 4305},
  {4264, 4456, 4455},
  {4264, 4455, 4304},
  {4307, 4351, 4457},
  {4458, 4457, 4351},
  {4351, 4352, 4458},
  {4352, 4561, 4458},
  {4306, 4353, 4506},
  {4565, 4506, 4353},
  {4402, 4356, 4354},
  {4355, 4354, 4356},
  {4460, 4504, 4405},
  {4460, 4405, 4406},
  {4406, 4407, 4459},
  {4404, 4461, 4218},
  {4353, 4356, 4565},
  {4564, 4565, 4356},
  {4359, 4355, 4356},
  {4360, 4355, 4359},
  {4362, 4405, 4408},
  {4405, 4362, 4406},
  {4406, 4362, 4407},
  {4462, 4407, 4358},
  {4218, 4461, 4409},
  {5904, 4361, 4408},
  {4410, 4408, 4361},
  {4408, 4410, 4362},
  {4358, 4310, 4462},
  {4463, 4462, 4310},
  {4410, 4411, 4362},
  {4361, 4312, 4364},
  {4361, 4364, 4410},
  {4411, 4366, 4362},
  {4365, 4412, 4364},
  {4411, 4412, 4366},
  {4412, 4367, 4366},
  {4366, 4367, 4316},
  {4366, 4316, 4314},
  {4314, 4316, 4368},
  {4314, 4368, 4315},
  {4318, 4467, 4468},
  {4414, 4413, 4369},
  {4414, 4465, 4413},
  {4414, 4318, 4468},
  {4413, 4415, 4417},
  {4413, 4417, 4277},
  {4417, 4415, 4416},
  {4417, 4416, 4471},
  {4471, 4416, 4419},
  {4418, 4417, 4471},
  {4229, 4473, 4516},
  {4371, 4370, 4618},
  {4472, 4281, 4574},
  {4372, 4322, 4228},
  {4574, 4281, 4575},
  {4473, 4284, 4577},
  {4578, 4322, 4575},
  {4322, 4578, 4140},
  {4283, 4421, 4284},
  {4475, 4474, 4374},
  {4422, 4421, 4139},
  {4375, 4323, 4669},
  {4378, 4624, 4380},
  {4325, 4289, 4476},
  {4381, 4192, 4529},
  {4381, 4529, 4756},
  {4382, 4328, 4531},
  {4382, 4531, 4192},
  {4328, 4425, 4531},
  {4383, 4386, 4384},
  {4328, 4386, 4425},
  {4386, 4383, 4425},
  {4386, 4387, 4329},
  {4386, 4329, 4384},
  {4593, 4429, 4332},
  {4429, 4388, 4332},
  {4429, 4293, 4388},
  {4428, 4335, 4339},
  {4342, 4430, 4428},
  {4342, 4389, 4430},
  {4429, 4483, 4336},
  {4336, 4483, 4345},
  {4389, 4342, 4431},
  {4432, 4337, 4433},
  {4390, 4433, 4337},
  {4390, 4434, 4435},
  {4393, 4435, 4434},
  {4485, 4390, 4435},
  {4392, 4435, 4393},
  {4435, 4392, 4436},
  {4435, 4436, 4485},
  {4436, 4392, 4438},
  {4437, 4438, 4392},
  {4542, 4438, 4437},
  {4443, 4394, 4439},
  {4440, 4439, 4341},
  {4341, 4340, 4440},
  {4342, 4391, 4431},
  {4492, 4431, 4391},
  {4392, 4395, 4437},
  {4396, 4437, 4395},
  {4442, 4437, 4396},
  {4396, 4443, 4442},
  {4444, 4442, 4443},
  {4397, 5907, 4257},
  {4497, 4445, 4495},
  {4397, 4446, 4399},
  {4497, 4495, 4447},
  {4399, 4446, 4448},
  {4451, 4497, 4447},
  {4451, 4447, 4450},
  {4450, 4498, 4451},
  {4400, 4452, 4454},
  {4401, 4642, 4453},
  {4401, 4455, 4645},
  {4454, 4501, 4402},
  {4403, 4457, 4503},
  {4402, 4501, 4356},
  {4505, 4460, 4406},
  {4505, 4406, 4459},
  {4403, 4563, 4404},
  {4356, 4501, 4564},
  {4407, 4562, 4459},
  {4407, 4507, 4562},
  {4404, 4563, 4461},
  {4461, 4509, 4409},
  {4409, 4509, 4464},
  {4462, 4463, 4566},
  {4409, 4464, 4363},
  {4463, 4363, 4464},
  {4463, 4464, 4509},
  {4410, 4364, 4411},
  {4364, 4412, 4411},
  {4466, 4465, 4510},
  {4467, 4511, 4510},
  {4466, 4413, 4465},
  {4468, 4465, 4414},
  {4413, 4466, 4415},
  {4512, 4415, 4466},
  {4512, 4416, 4415},
  {4512, 4419, 4416},
  {4418, 4471, 4469},
  {4418, 4469, 4370},
  {4419, 4514, 4470},
  {4469, 4517, 4370},
  {4572, 4419, 4470},
  {4419, 4572, 4471},
  {4618, 4370, 4517},
  {4372, 4472, 4322},
  {4574, 4322, 4472},
  {4420, 4618, 4519},
  {4373, 4578, 4575},
  {4374, 4578, 4321},
  {4580, 4577, 4284},
  {4581, 4669, 4323},
  {4521, 4520, 4522},
  {4523, 4521, 4522},
  {4325, 4476, 4583},
  {4423, 4585, 4377},
  {4423, 4377, 4376},
  {4624, 4521, 4380},
  {4476, 4289, 4424},
  {4380, 4521, 4525},
  {4521, 4588, 4525},
  {4529, 4527, 4756},
  {4529, 4590, 4527},
  {4477, 4146, 4589},
  {4529, 4192, 4478},
  {4192, 4480, 4478},
  {4192, 4531, 4479},
  {4192, 4479, 4530},
  {4192, 4530, 4480},
  {4425, 4383, 4525},
  {4426, 4592, 4481},
  {4482, 4595, 4426},
  {4426, 4481, 4482},
  {4533, 4482, 4481},
  {4481, 4532, 4533},
  {4196, 4427, 4732},
  {4429, 4593, 4483},
  {4732, 4427, 4333},
  {4533, 4335, 4428},
  {4732, 4335, 4533},
  {4428, 4430, 4533},
  {4430, 4389, 4534},
  {4389, 4431, 4534},
  {4487, 4534, 4431},
  {4433, 4484, 4432},
  {4390, 4484, 4433},
  {4484, 4390, 4485},
  {4537, 4484, 4485},
  {4486, 4540, 4485},
  {4485, 4436, 4486},
  {4541, 4486, 4436},
  {4539, 4391, 4432},
  {4436, 4438, 4541},
  {4489, 4443, 4439},
  {4439, 4440, 4488},
  {4535, 4488, 4440},
  {4439, 4488, 4489},
  {4440, 4340, 4535},
  {4391, 4539, 4492},
  {4490, 4542, 4437},
  {4437, 4442, 4490},
  {4443, 4489, 4444},
  {4491, 4444, 4489},
  {4487, 4431, 4492},
  {4442, 4444, 4490},
  {4493, 4490, 4444},
  {4493, 4444, 4491},
  {4347, 5906, 5907},
  {4546, 4494, 4398},
  {5907, 4397, 4347},
  {4546, 4398, 4496},
  {4495, 4548, 4447},
  {4257, 4497, 4446},
  {4257, 4446, 4397},
  {4548, 4550, 4447},
  {4446, 4497, 4448},
  {4447, 4550, 4551},
  {4447, 4551, 4450},
  {4448, 4497, 4452},
  {4453, 4604, 4449},
  {4500, 4450, 4551},
  {4500, 4551, 4552},
  {4450, 4500, 4498},
  {4500, 4552, 4499},
  {4610, 4455, 4456},
  {4559, 4455, 4610},
  {4645, 4455, 4559},
  {4457, 4611, 4503},
  {4504, 4460, 4558},
  {4460, 4505, 4560},
  {4460, 4560, 4558},
  {4563, 4403, 4502},
  {4306, 4506, 4561},
  {4407, 4566, 4507},
  {4563, 4508, 4461},
  {4407, 4462, 4566},
  {4461, 4508, 4509},
  {4566, 4463, 4509},
  {4510, 4468, 4467},
  {4569, 4510, 4568},
  {4510, 4465, 4468},
  {4466, 4510, 4569},
  {4510, 4511, 4568},
  {4512, 4466, 4569},
  {4569, 4513, 4512},
  {4419, 4512, 4513},
  {4517, 4469, 4471},
  {4513, 4514, 4419},
  {4513, 4570, 4514},
  {4515, 4514, 4570},
  {4518, 4514, 4515},
  {4572, 4573, 4471},
  {4514, 4518, 4470},
  {4572, 4470, 4518},
  {4574, 4575, 4322},
  {4474, 4578, 4374},
  {4519, 4475, 4420},
  {4577, 4580, 4619},
  {4284, 4421, 4580},
  {4475, 4519, 4579},
  {4475, 4579, 4694},
  {4422, 4583, 4421},
  {4378, 4377, 4585},
  {4521, 4523, 4586},
  {4526, 4795, 4424},
  {4528, 4756, 4527},
  {4590, 4528, 4527},
  {4731, 4526, 4424},
  {4529, 4478, 4525},
  {4478, 4480, 4525},
  {4426, 4731, 4592},
  {4479, 4531, 4525},
  {4479, 4525, 4530},
  {4531, 4425, 4525},
  {4481, 4592, 4532},
  {4196, 4732, 4146},
  {4482, 4533, 4534},
  {4482, 4534, 4595},
  {4534, 4533, 4430},
  {4483, 4630, 4535},
  {4535, 4345, 4483},
  {4432, 4536, 4596},
  {4536, 4432, 4484},
  {4536, 4484, 4537},
  {4535, 4340, 4345},
  {4534, 4487, 4538},
  {4485, 4540, 4537},
  {4487, 4539, 4538},
  {4438, 4542, 4541},
  {4487, 4492, 4539},
  {4490, 4543, 4542},
  {4490, 4493, 4543},
  {4544, 4494, 4546},
  {4545, 4494, 4544},
  {4548, 4495, 4546},
  {4546, 4496, 4547},
  {4547, 4496, 4549},
  {4549, 4496, 4449},
  {4549, 4449, 4640},
  {4604, 4601, 4449},
  {4640, 4449, 4601},
  {4603, 4452, 4497},
  {4454, 4452, 4554},
  {4452, 4603, 4554},
  {4641, 4553, 4499},
  {4499, 4552, 4641},
  {4556, 4499, 4553},
  {4499, 4556, 4500},
  {4500, 4557, 4498},
  {4606, 4498, 4557},
  {4605, 4498, 4606},
  {4454, 4554, 4501},
  {4553, 4555, 4556},
  {4557, 4500, 4556},
  {4504, 4558, 4456},
  {4610, 4456, 4558},
  {4503, 4502, 4403},
  {4612, 4611, 4457},
  {4457, 4458, 4612},
  {4458, 4561, 4612},
  {4558, 4560, 4651},
  {4505, 4459, 4562},
  {4563, 4502, 4653},
  {4613, 4562, 4507},
  {4657, 4613, 4507},
  {4566, 4657, 4507},
  {4508, 4614, 4509},
  {4568, 4511, 4567},
  {4569, 4568, 4567},
  {4569, 4567, 4570},
  {4571, 4567, 4511},
  {4513, 4569, 4570},
  {4511, 4516, 4571},
  {4571, 4516, 4662},
  {4570, 4616, 4515},
  {4471, 4573, 4517},
  {4617, 4516, 4473},
  {4515, 4616, 4518},
  {4473, 4577, 4665},
  {4618, 4579, 4519},
  {4578, 4474, 4576},
  {4421, 4621, 4580},
  {4475, 4694, 4474},
  {4375, 4669, 4582},
  {4582, 4584, 4375},
  {4584, 4423, 4375},
  {4623, 4521, 4624},
  {4521, 4623, 4520},
  {4520, 4698, 4522},
  {4477, 4589, 4524},
  {4588, 4521, 4587},
  {4586, 4587, 4521},
  {4529, 4698, 4590},
  {4525, 4698, 4529},
  {4289, 4524, 4731},
  {4756, 4528, 4591},
  {4528, 4590, 4591},
  {4526, 4731, 4627},
  {4424, 4289, 4731},
  {4731, 4426, 4628},
  {4731, 4628, 4627},
  {4480, 4530, 4525},
  {4593, 4332, 4594},
  {4533, 4532, 4592},
  {4593, 4630, 4483},
  {4533, 4629, 4732},
  {4535, 4630, 4599},
  {4432, 4596, 4539},
  {4599, 4488, 4535},
  {4598, 4701, 4538},
  {4632, 4539, 4596},
  {4537, 4540, 4597},
  {4633, 4597, 4540},
  {4540, 4486, 4633},
  {4599, 4489, 4488},
  {4538, 4539, 4598},
  {4632, 4598, 4539},
  {4486, 4541, 4633},
  {4489, 4599, 4491},
  {4633, 4541, 4542},
  {4493, 4491, 4599},
  {4542, 4543, 4633},
  {4599, 4543, 4493},
  {4600, 4633, 4543},
  {4544, 4546, 4545},
  {4548, 4546, 4547},
  {4549, 4640, 4547},
  {4547, 4550, 4548},
  {4547, 4640, 4550},
  {4602, 4550, 4640},
  {4602, 4551, 4550},
  {4677, 4551, 4602},
  {4451, 4603, 4497},
  {4451, 4605, 4603},
  {4643, 4603, 4605},
  {4605, 4451, 4498},
  {4603, 4643, 4554},
  {4642, 4604, 4453},
  {4553, 4644, 4555},
  {4554, 4643, 4609},
  {4401, 4645, 4642},
  {4555, 4644, 4607},
  {4555, 4607, 4608},
  {4555, 4608, 4556},
  {4556, 4608, 4646},
  {4556, 4646, 4557},
  {4557, 4647, 4606},
  {4554, 4609, 4501},
  {4501, 4609, 4564},
  {4559, 4610, 4648},
  {4560, 4505, 4652},
  {4502, 4503, 4653},
  {4654, 4653, 4503},
  {4503, 4611, 4654},
  {4505, 4562, 4652},
  {4655, 4652, 4562},
  {4563, 4653, 4656},
  {4561, 4506, 4712},
  {4565, 4712, 4506},
  {4563, 4614, 4508},
  {4566, 4509, 4614},
  {4567, 4571, 4615},
  {4567, 4659, 4570},
  {4570, 4659, 4661},
  {4661, 4663, 4570},
  {4570, 4663, 4616},
  {4516, 4617, 4664},
  {4572, 4518, 4689},
  {4618, 4690, 4666},
  {4473, 4665, 4617},
  {4577, 4619, 4665},
  {4618, 4620, 4579},
  {4576, 4474, 4667},
  {4619, 4580, 4695},
  {4578, 4581, 4323},
  {4622, 4695, 4580},
  {4622, 4580, 4621},
  {4583, 4621, 4421},
  {4584, 4582, 4423},
  {4585, 4423, 4582},
  {4520, 4623, 4671},
  {4671, 4698, 4520},
  {4523, 4522, 4698},
  {4523, 4698, 4586},
  {4586, 4698, 4587},
  {4476, 4424, 4795},
  {4698, 4588, 4587},
  {4625, 4590, 4698},
  {4625, 4698, 4626},
  {4625, 4626, 4591},
  {4625, 4591, 4590},
  {4698, 4525, 4588},
  {4756, 4591, 4753},
  {4526, 4627, 4795},
  {4628, 4426, 4755},
  {4145, 4594, 4332},
  {4426, 4595, 4755},
  {4592, 4731, 4629},
  {4592, 4629, 4533},
  {4701, 4534, 4538},
  {4631, 4672, 4536},
  {4536, 4537, 4631},
  {4596, 4536, 4672},
  {4673, 4596, 4672},
  {4596, 4673, 4632},
  {4599, 4674, 4543},
  {4543, 4674, 4600},
  {4633, 4600, 4635},
  {4633, 4635, 4634},
  {4674, 4635, 4600},
  {4635, 4674, 4637},
  {4634, 4635, 4636},
  {4637, 4636, 4635},
  {4637, 4639, 4636},
  {4639, 4637, 4638},
  {4604, 4641, 4601},
  {4676, 4601, 4641},
  {4677, 4641, 4552},
  {4552, 4551, 4677},
  {4644, 4604, 4642},
  {4683, 4646, 4608},
  {4557, 4646, 4647},
  {4679, 4606, 4647},
  {4559, 4648, 4645},
  {4682, 4607, 4650},
  {4607, 4682, 4608},
  {4609, 4685, 4564},
  {4610, 4684, 4649},
  {4610, 4649, 4648},
  {4560, 4652, 4651},
  {4685, 4565, 4564},
  {4653, 4713, 4656},
  {4611, 4612, 4715},
  {4611, 4715, 4654},
  {4612, 4687, 4715},
  {4612, 4561, 4687},
  {4561, 4712, 4687},
  {4562, 4613, 4655},
  {4657, 4563, 4656},
  {4563, 4657, 4614},
  {4613, 4657, 4718},
  {4657, 4566, 4614},
  {4615, 4659, 4567},
  {4615, 4658, 4660},
  {4615, 4660, 4659},
  {4615, 4720, 4658},
  {4659, 4660, 4661},
  {4615, 4571, 4720},
  {4571, 4662, 4720},
  {4662, 4516, 4664},
  {4662, 4664, 4719},
  {4572, 4618, 4573},
  {4572, 4689, 4618},
  {4691, 4689, 4518},
  {4618, 4517, 4573},
  {4616, 4663, 4691},
  {4616, 4691, 4518},
  {4617, 4692, 4664},
  {4618, 4666, 4620},
  {4576, 4667, 4578},
  {4694, 4667, 4474},
  {4724, 4622, 4668},
  {4621, 4583, 4622},
  {4668, 4622, 4583},
  {4854, 4696, 4583},
  {4697, 4582, 4669},
  {4583, 4476, 4854},
  {4623, 4670, 4671},
  {4726, 4671, 4670},
  {4670, 4623, 4624},
  {4585, 4728, 4378},
  {4378, 4729, 4624},
  {4626, 4698, 4754},
  {4591, 4626, 4754},
  {4146, 4699, 4589},
  {4146, 4732, 4699},
  {4731, 4923, 4629},
  {4145, 4756, 4594},
  {4593, 4594, 4756},
  {4595, 4534, 4733},
  {4534, 4800, 4733},
  {4534, 4701, 4800},
  {4672, 4702, 4673},
  {4598, 4632, 4701},
  {4597, 4633, 4703},
  {4597, 4703, 4537},
  {4632, 4704, 4701},
  {4673, 4702, 4704},
  {4673, 4704, 4632},
  {4633, 4634, 4703},
  {4634, 4636, 4703},
  {4674, 4638, 4637},
  {4703, 4636, 4639},
  {4638, 4675, 4639},
  {4705, 4706, 4639},
  {4675, 4705, 4639},
  {4601, 4707, 4640},
  {4602, 4640, 4707},
  {4601, 4676, 4707},
  {4676, 4677, 4602},
  {4677, 4676, 4641},
  {4604, 4644, 4641},
  {4553, 4641, 4644},
  {4643, 4605, 4606},
  {4678, 4642, 4645},
  {4642, 4678, 4644},
  {4607, 4644, 4678},
  {4650, 4607, 4678},
  {4685, 4647, 4646},
  {4609, 4606, 4679},
  {4606, 4609, 4643},
  {4648, 4710, 4645},
  {4648, 4649, 4710},
  {4680, 4710, 4649},
  {4645, 4710, 4678},
  {4774, 4678, 4710},
  {4681, 4678, 4774},
  {4678, 4681, 4650},
  {4650, 4681, 4682},
  {4608, 4682, 4683},
  {4685, 4646, 4683},
  {4685, 4609, 4679},
  {4651, 4709, 4558},
  {4558, 4709, 4610},
  {4684, 4680, 4649},
  {4652, 4711, 4651},
  {4565, 4685, 4712},
  {4652, 4655, 4686},
  {4688, 4686, 4655},
  {4713, 4653, 4714},
  {4653, 4654, 4714},
  {4715, 4714, 4654},
  {4657, 4656, 4716},
  {4718, 4657, 4716},
  {4655, 4613, 4688},
  {4717, 4688, 4613},
  {4613, 4718, 4717},
  {4720, 4660, 4658},
  {4660, 4720, 4661},
  {4720, 4662, 4719},
  {4661, 4720, 4663},
  {4722, 4663, 4720},
  {4692, 4721, 4664},
  {4663, 4722, 4691},
  {4692, 4617, 4665},
  {4665, 4619, 4784},
  {4665, 4784, 4692},
  {4620, 4666, 4746},
  {4693, 4667, 4694},
  {4693, 4578, 4667},
  {4620, 4694, 4579},
  {4620, 4746, 4694},
  {4697, 4669, 4581},
  {4697, 4581, 4792},
  {4583, 4696, 4668},
  {4668, 4696, 4724},
  {4696, 4725, 4724},
  {4582, 4697, 4749},
  {4582, 4749, 4585},
  {4585, 4749, 4728},
  {4726, 4727, 4671},
  {4854, 4476, 4795},
  {4727, 4698, 4671},
  {4624, 4729, 4730},
  {4624, 4730, 4670},
  {4378, 4728, 4729},
  {4524, 4589, 4752},
  {4524, 4752, 4731},
  {4591, 4754, 4753},
  {4627, 4628, 4795},
  {4755, 4795, 4628},
  {4799, 4593, 4756},
  {4595, 4733, 4757},
  {4700, 4630, 4593},
  {4599, 4630, 4700},
  {4631, 4537, 4734},
  {4631, 4734, 4672},
  {4537, 4703, 4734},
  {4705, 4675, 4638},
  {4638, 4674, 4768},
  {4638, 4768, 4705},
  {4706, 4703, 4639},
  {4602, 4707, 4676},
  {4684, 4710, 4680},
  {4684, 4708, 4710},
  {4682, 4737, 4683},
  {4683, 4737, 4712},
  {4683, 4712, 4685},
  {4647, 4685, 4679},
  {4610, 4709, 4769},
  {4610, 4769, 4684},
  {4651, 4711, 4709},
  {4652, 4686, 4711},
  {4686, 4688, 4739},
  {4656, 4713, 4716},
  {4714, 4715, 4815},
  {4715, 4687, 4737},
  {4688, 4717, 4739},
  {4689, 4740, 4690},
  {4690, 4618, 4689},
  {4723, 4666, 4690},
  {4740, 4723, 4690},
  {4721, 4692, 4742},
  {4692, 4745, 4742},
  {4784, 4745, 4692},
  {4846, 4850, 4666},
  {4746, 4693, 4694},
  {4695, 4784, 4619},
  {4913, 4581, 4578},
  {4724, 4824, 4695},
  {4695, 4622, 4724},
  {4854, 4725, 4696},
  {4726, 4730, 4727},
  {4670, 4730, 4726},
  {4729, 4794, 4730},
  {4699, 4732, 4752},
  {4755, 4595, 4757},
  {4593, 4799, 4700},
  {4599, 4700, 4799},
  {4800, 4758, 4733},
  {4734, 4703, 4763},
  {4735, 4701, 4704},
  {4702, 4838, 4704},
  {4736, 4704, 4838},
  {4767, 4763, 4703},
  {4736, 4735, 4704},
  {4703, 4706, 4767},
  {4684, 4769, 4708},
  {4708, 4738, 4710},
  {4708, 4769, 4738},
  {4681, 4770, 4682},
  {4737, 4682, 4770},
  {4774, 4773, 4681},
  {4737, 4687, 4712},
  {4711, 4686, 4811},
  {4711, 4811, 4709},
  {4686, 4739, 4811},
  {4815, 4715, 4771},
  {4716, 4713, 4777},
  {4713, 4714, 4776},
  {4713, 4776, 4777},
  {4717, 4816, 4739},
  {4717, 4718, 4816},
  {4719, 4664, 4741},
  {4719, 4741, 4778},
  {4720, 4779, 4722},
  {4740, 4691, 4780},
  {4740, 4689, 4691},
  {4664, 4721, 4741},
  {4722, 4779, 4781},
  {4721, 4742, 4741},
  {4722, 4781, 4743},
  {4722, 4744, 4691},
  {4722, 4743, 4744},
  {4723, 4820, 4666},
  {4822, 4742, 4745},
  {4666, 4820, 4846},
  {4745, 4782, 4822},
  {4695, 4824, 4784},
  {4790, 4824, 4724},
  {4724, 4725, 4790},
  {4792, 4581, 4915},
  {4697, 4792, 4749},
  {4727, 4750, 4698},
  {4751, 4698, 4750},
  {4589, 4699, 4752},
  {4752, 4732, 4832},
  {4795, 4755, 4831},
  {4757, 4733, 4758},
  {4599, 4799, 4674},
  {4761, 4759, 4803},
  {4761, 4803, 4837},
  {4701, 4804, 4800},
  {4702, 4672, 4801},
  {4672, 4762, 4801},
  {4672, 4734, 4762},
  {4763, 4841, 4734},
  {4701, 4735, 4806},
  {4701, 4806, 4804},
  {4764, 4768, 4674},
  {4705, 4765, 4766},
  {4870, 4735, 4736},
  {4705, 4768, 4765},
  {4705, 4767, 4706},
  {4809, 4769, 4808},
  {4769, 4809, 4738},
  {4709, 4772, 4769},
  {4808, 4769, 4772},
  {4810, 4738, 4809},
  {4681, 4773, 4770},
  {4715, 4770, 4771},
  {4770, 4715, 4737},
  {4811, 4772, 4709},
  {4774, 4710, 4738},
  {4738, 4812, 4774},
  {4775, 4774, 4812},
  {4776, 4714, 4814},
  {4815, 4814, 4714},
  {4739, 4816, 4813},
  {4719, 4778, 4720},
  {4779, 4720, 4778},
  {4778, 4741, 4817},
  {4818, 4817, 4741},
  {4723, 4740, 4820},
  {4818, 4741, 4742},
  {4691, 4744, 4845},
  {4743, 4819, 4821},
  {4743, 4821, 4744},
  {4782, 4745, 4783},
  {4745, 4784, 4783},
  {4851, 4578, 4879},
  {4666, 4850, 4823},
  {4666, 4823, 4746},
  {4746, 4823, 4747},
  {4786, 4785, 4788},
  {4785, 4748, 4787},
  {4785, 4787, 4788},
  {4787, 4748, 4789},
  {4748, 4791, 4789},
  {4791, 4853, 4789},
  {4789, 4853, 4882},
  {4790, 4725, 4825},
  {4791, 4826, 4853},
  {4725, 4854, 4825},
  {4828, 4728, 4749},
  {4727, 4793, 4750},
  {4727, 4730, 4793},
  {4728, 4828, 4729},
  {4857, 4730, 4794},
  {4794, 4729, 4828},
  {4796, 4794, 4828},
  {4831, 4920, 4795},
  {4752, 4832, 4731},
  {4754, 4698, 4830},
  {4892, 4832, 4732},
  {4731, 4833, 4923},
  {4755, 4757, 4831},
  {4923, 4732, 4629},
  {4757, 4758, 4797},
  {4759, 4834, 4760},
  {4837, 4798, 4834},
  {4834, 4761, 4837},
  {4761, 4834, 4759},
  {4799, 4802, 4674},
  {4762, 4836, 4801},
  {4804, 4868, 4800},
  {4801, 4835, 4702},
  {4702, 4835, 4838},
  {4734, 4841, 4762},
  {4674, 4802, 4764},
  {4802, 4805, 4764},
  {4736, 4838, 4870},
  {4765, 4842, 4766},
  {4735, 4870, 4806},
  {4768, 4840, 4765},
  {4902, 4840, 4768},
  {4902, 4768, 4764},
  {4763, 4767, 4807},
  {4705, 4807, 4767},
  {4766, 4807, 4705},
  {4771, 4770, 4773},
  {4810, 4808, 4772},
  {4772, 4811, 4810},
  {4810, 4813, 4738},
  {4738, 4813, 4812},
  {4811, 4739, 4813},
  {4775, 4812, 4816},
  {4718, 4716, 4816},
  {4777, 4816, 4716},
  {4778, 4817, 4779},
  {4843, 4779, 4817},
  {4779, 4843, 4781},
  {4820, 4780, 4845},
  {4780, 4691, 4845},
  {4780, 4820, 4740},
  {4818, 4742, 4844},
  {4781, 4819, 4743},
  {4742, 4822, 4844},
  {4846, 4820, 4875},
  {4819, 4878, 4821},
  {4848, 4822, 4782},
  {4848, 4782, 4849},
  {4783, 4849, 4782},
  {4783, 4784, 4824},
  {4747, 4823, 4785},
  {4879, 4578, 4693},
  {4578, 4851, 4913},
  {4823, 4910, 4785},
  {4786, 4788, 4851},
  {4785, 4910, 4748},
  {4788, 4787, 4851},
  {4787, 4789, 4851},
  {4824, 4790, 4852},
  {4852, 4790, 4825},
  {4581, 4913, 4915},
  {4826, 4936, 4853},
  {4914, 4791, 4885},
  {4854, 4855, 4825},
  {4751, 4750, 4793},
  {4730, 4827, 4793},
  {4856, 4793, 4827},
  {4793, 4856, 4751},
  {4730, 4857, 4827},
  {4828, 4829, 4796},
  {4890, 4796, 4829},
  {4796, 4890, 4794},
  {4794, 4890, 4857},
  {4751, 4856, 4830},
  {4830, 4698, 4751},
  {4756, 4753, 4860},
  {4861, 4860, 4753},
  {4753, 4754, 4861},
  {4754, 4830, 4861},
  {4731, 4832, 4892},
  {4731, 4892, 4833},
  {4756, 4893, 4799},
  {4797, 4864, 4757},
  {4760, 4834, 4894},
  {4797, 4758, 4800},
  {4837, 4799, 4798},
  {4837, 4805, 4799},
  {4797, 4800, 4868},
  {4865, 4760, 4866},
  {4865, 4803, 4759},
  {4865, 4759, 4760},
  {4801, 4836, 4835},
  {4867, 4839, 4840},
  {4762, 4841, 4836},
  {4839, 4765, 4840},
  {4842, 4839, 4871},
  {4839, 4842, 4765},
  {4764, 4805, 4902},
  {4931, 4902, 4805},
  {4873, 4804, 4806},
  {4806, 4870, 4873},
  {4763, 4807, 4841},
  {4842, 4841, 4807},
  {4842, 4807, 4766},
  {4808, 4810, 4809},
  {4810, 4811, 4813},
  {4774, 4814, 4773},
  {4773, 4814, 4771},
  {4815, 4771, 4814},
  {4774, 4775, 4814},
  {4776, 4814, 4775},
  {4816, 4812, 4813},
  {4777, 4775, 4816},
  {4776, 4775, 4777},
  {4843, 4817, 4818},
  {4781, 4843, 4819},
  {4875, 4820, 4845},
  {4822, 4903, 4844},
  {4904, 4819, 4843},
  {4878, 4819, 4904},
  {4849, 4783, 4908},
  {4880, 4908, 4783},
  {4824, 4880, 4783},
  {4823, 4850, 4910},
  {4909, 4786, 4851},
  {4881, 4880, 4824},
  {4824, 4852, 4881},
  {4913, 4851, 4884},
  {4748, 4910, 4966},
  {4789, 4882, 4851},
  {4748, 4966, 4791},
  {4826, 4791, 4936},
  {4749, 4792, 4886},
  {4792, 4915, 4886},
  {4855, 4854, 4887},
  {4855, 4887, 4825},
  {4749, 4886, 4828},
  {4854, 4795, 4916},
  {4888, 4856, 4827},
  {4827, 4857, 4888},
  {4920, 4916, 4795},
  {4918, 4830, 4888},
  {4829, 4828, 4889},
  {4830, 4856, 4888},
  {4890, 4829, 4889},
  {4858, 4830, 4918},
  {4858, 4919, 4859},
  {4859, 4863, 4858},
  {4863, 4830, 4858},
  {4861, 4830, 4922},
  {4830, 4862, 4922},
  {4974, 4862, 4830},
  {4830, 4863, 4974},
  {4945, 4894, 4834},
  {4797, 4925, 4864},
  {4802, 4799, 4805},
  {4865, 4898, 4803},
  {4867, 4897, 4895},
  {4897, 4867, 4840},
  {4897, 4896, 4895},
  {4835, 4836, 4869},
  {4871, 4839, 4867},
  {4871, 4867, 4895},
  {4898, 4837, 4803},
  {4838, 4835, 4869},
  {4868, 4804, 4930},
  {4873, 4930, 4804},
  {4929, 4836, 4841},
  {4805, 4837, 4872},
  {4805, 4872, 4931},
  {4841, 4842, 4871},
  {4873, 4870, 4874},
  {4843, 4818, 4844},
  {4903, 4843, 4844},
  {4875, 4845, 4744},
  {4744, 4821, 4875},
  {4876, 4875, 4821},
  {4875, 4876, 4846},
  {4903, 4822, 4905},
  {4848, 4905, 4822},
  {4904, 4877, 4878},
  {4907, 4933, 4821},
  {4849, 4906, 4848},
  {4907, 4821, 4878},
  {4847, 4909, 4879},
  {4880, 4881, 4935},
  {4881, 4852, 4967},
  {4851, 4882, 4884},
  {4884, 4882, 4911},
  {4884, 4911, 4883},
  {4914, 4936, 4791},
  {4854, 4916, 4887},
  {4890, 4919, 4857},
  {4889, 4891, 4890},
  {4863, 4859, 4944},
  {4923, 4892, 4732},
  {4946, 4945, 4834},
  {4946, 4799, 4924},
  {4798, 4946, 4834},
  {4798, 4799, 4946},
  {4866, 4760, 4894},
  {4947, 4925, 4797},
  {4898, 4865, 4948},
  {4865, 4866, 4980},
  {4797, 4868, 4947},
  {4895, 4896, 4949},
  {4899, 4871, 4895},
  {4930, 4927, 4868},
  {4838, 4869, 4900},
  {4838, 4900, 4870},
  {4836, 4929, 4869},
  {4840, 4954, 4897},
  {4840, 4902, 4954},
  {4872, 4898, 4988},
  {4872, 4837, 4898},
  {4870, 4900, 4901},
  {4841, 4871, 4929},
  {4931, 4872, 4988},
  {4874, 4870, 4901},
  {4874, 4901, 4873},
  {4843, 4903, 4904},
  {4933, 4876, 4821},
  {4876, 4933, 4846},
  {4905, 4848, 4906},
  {4877, 4961, 4878},
  {4849, 4908, 4906},
  {4878, 4961, 4934},
  {4851, 4879, 4909},
  {4935, 4881, 5027},
  {5908, 4883, 4911},
  {4969, 4885, 4791},
  {4853, 4936, 4882},
  {4883, 5908, 4884},
  {4884, 5908, 4913},
  {4825, 4887, 4912},
  {4828, 4886, 4938},
  {4918, 4888, 4857},
  {4828, 4891, 4889},
  {4857, 4919, 4918},
  {4918, 4919, 4858},
  {4921, 4890, 4942},
  {4890, 4921, 4943},
  {4890, 4943, 4919},
  {4944, 4919, 4943},
  {4919, 4944, 4859},
  {4861, 4922, 4860},
  {4831, 4757, 4920},
  {4833, 4892, 4923},
  {4860, 4893, 4756},
  {4757, 4864, 5097},
  {4864, 4977, 5097},
  {4925, 4977, 4864},
  {4799, 4893, 4924},
  {4894, 4945, 5102},
  {4894, 5102, 4866},
  {4865, 4952, 4948},
  {4865, 4980, 4952},
  {4926, 4947, 4868},
  {4895, 4949, 4899},
  {4927, 4926, 4868},
  {4928, 4900, 4869},
  {4869, 4929, 4928},
  {4871, 4899, 4929},
  {4900, 4956, 4901},
  {4930, 4873, 4957},
  {4932, 4957, 4873},
  {4932, 4901, 4956},
  {4873, 4901, 4932},
  {4959, 4904, 4903},
  {4903, 4905, 4959},
  {4990, 4959, 4905},
  {4904, 4959, 4877},
  {4960, 4877, 4959},
  {4961, 4877, 4960},
  {4933, 4991, 4846},
  {4905, 4906, 4990},
  {4962, 4990, 4906},
  {4933, 4907, 4992},
  {4934, 4992, 4907},
  {4907, 4878, 4934},
  {4906, 4908, 4962},
  {4908, 4880, 4963},
  {4880, 4935, 4963},
  {5027, 4881, 5028},
  {4881, 4967, 5028},
  {4910, 4965, 4966},
  {4969, 4791, 4966},
  {5908, 4911, 4882},
  {4825, 4912, 4852},
  {4936, 4968, 4882},
  {4915, 4913, 4937},
  {4912, 4887, 4917},
  {4886, 4915, 4938},
  {4887, 4916, 4917},
  {4916, 5002, 4917},
  {4828, 4938, 4939},
  {4828, 4939, 4940},
  {4828, 4940, 4971},
  {4828, 4971, 4891},
  {4891, 4971, 4941},
  {4891, 4941, 4890},
  {4890, 4941, 4942},
  {4921, 5004, 4943},
  {4920, 4757, 5041},
  {4860, 4922, 4973},
  {4860, 4975, 4893},
  {4975, 4976, 4924},
  {4946, 4924, 4976},
  {4924, 4893, 4975},
  {4925, 4947, 5044},
  {4980, 4866, 5102},
  {4948, 4952, 5011},
  {4950, 4978, 4949},
  {4949, 4896, 4950},
  {4951, 4950, 4896},
  {5010, 4898, 4948},
  {4896, 4897, 4951},
  {4951, 4897, 4982},
  {4898, 5010, 4988},
  {4927, 4957, 4953},
  {4927, 4953, 4926},
  {4949, 4955, 4899},
  {4897, 4954, 4982},
  {4900, 4928, 4987},
  {4928, 4929, 4987},
  {4955, 4929, 4899},
  {4930, 4957, 4927},
  {4900, 4986, 4956},
  {4954, 4902, 4931},
  {4931, 4988, 5015},
  {4957, 4932, 4958},
  {4992, 4991, 4933},
  {4962, 4908, 4963},
  {4846, 4991, 4964},
  {4846, 4964, 4850},
  {4850, 4964, 4965},
  {4850, 4965, 4910},
  {4852, 4912, 4998},
  {4936, 5061, 4968},
  {4914, 5061, 4936},
  {4912, 4917, 5062},
  {4970, 5001, 4915},
  {4915, 4937, 4970},
  {4969, 4914, 4885},
  {5001, 4938, 4915},
  {5039, 4917, 5002},
  {5038, 4917, 5039},
  {4938, 5001, 4939},
  {4916, 4920, 5002},
  {5041, 5129, 4920},
  {4942, 4941, 5040},
  {4942, 5003, 4921},
  {4921, 5003, 5004},
  {4972, 4943, 5004},
  {4943, 4972, 4944},
  {4974, 4973, 4922},
  {4922, 4862, 4974},
  {4863, 4944, 4974},
  {4975, 5069, 4976},
  {4976, 5070, 4946},
  {4946, 5070, 4945},
  {4945, 5043, 5102},
  {4945, 5071, 5043},
  {4925, 5044, 4977},
  {5006, 4948, 5011},
  {4950, 5008, 4978},
  {4950, 4951, 5008},
  {4947, 4926, 5012},
  {5008, 4951, 4979},
  {4979, 4951, 4981},
  {4926, 4953, 5012},
  {4951, 4982, 4983},
  {4981, 4951, 4983},
  {5010, 5015, 4988},
  {4953, 4957, 4984},
  {4982, 4954, 4983},
  {4957, 4985, 4984},
  {4900, 4987, 4986},
  {4956, 4986, 5014},
  {4957, 5017, 4985},
  {4956, 5014, 4932},
  {4931, 5015, 4954},
  {4958, 5017, 4957},
  {4958, 4989, 5017},
  {4958, 5049, 4989},
  {4958, 4932, 5049},
  {4959, 4990, 4960},
  {4960, 5020, 4961},
  {4962, 5020, 4990},
  {4961, 5021, 4934},
  {4963, 5022, 4962},
  {4934, 5021, 5023},
  {4934, 5023, 4995},
  {4994, 4991, 5025},
  {4935, 5081, 4963},
  {4991, 4994, 4964},
  {4934, 4995, 4993},
  {4965, 4964, 4994},
  {4966, 4965, 4994},
  {4996, 4966, 5057},
  {4967, 5031, 5028},
  {4967, 4852, 5032},
  {4997, 4969, 4996},
  {4996, 4969, 4966},
  {4998, 5032, 4852},
  {5908, 4882, 4968},
  {4913, 5000, 4937},
  {4937, 5000, 4970},
  {4912, 5062, 4998},
  {5908, 4999, 4913},
  {5000, 4913, 4999},
  {4940, 4939, 5088},
  {4940, 5088, 4971},
  {4939, 5001, 5088},
  {4920, 5064, 5002},
  {4920, 5129, 5064},
  {4941, 4971, 5040},
  {4942, 5040, 5003},
  {5004, 5005, 4972},
  {4972, 5005, 4944},
  {4860, 4973, 4975},
  {4974, 4944, 5042},
  {4974, 5042, 5095},
  {4757, 5097, 5094},
  {4976, 5069, 5070},
  {5070, 5071, 4945},
  {5045, 4948, 5006},
  {5008, 5007, 4978},
  {5008, 4979, 5007},
  {5009, 5007, 4979},
  {5045, 5010, 4948},
  {5045, 5076, 5010},
  {4979, 4981, 5009},
  {4980, 5074, 4952},
  {4981, 4983, 5010},
  {5074, 5011, 4952},
  {4984, 5106, 4953},
  {4985, 5106, 4984},
  {4955, 4949, 5013},
  {5010, 4983, 5015},
  {4986, 4987, 5014},
  {5048, 5014, 4987},
  {4955, 5013, 5016},
  {5015, 4983, 4954},
  {4987, 4929, 5048},
  {5016, 4929, 4955},
  {4932, 5014, 5049},
  {4929, 5016, 5079},
  {5078, 5079, 5016},
  {4989, 5018, 5017},
  {5018, 4989, 5019},
  {4989, 5049, 5019},
  {5018, 5019, 5050},
  {4990, 5020, 4960},
  {5020, 4962, 5051},
  {5052, 5051, 4962},
  {5020, 5051, 4961},
  {5021, 4961, 5051},
  {5024, 4991, 4992},
  {4962, 5022, 5052},
  {4992, 4934, 5024},
  {4963, 5081, 5022},
  {4934, 4993, 5024},
  {5024, 4993, 5025},
  {5025, 5054, 4994},
  {4993, 4995, 5026},
  {4993, 5026, 5025},
  {4994, 5057, 4966},
  {5029, 4969, 5030},
  {5029, 5083, 4969},
  {5029, 5030, 4997},
  {5029, 4997, 4996},
  {5030, 4969, 4997},
  {4967, 5032, 5031},
  {4969, 5083, 5060},
  {4969, 5060, 5035},
  {5085, 5033, 5037},
  {5908, 5085, 5036},
  {5085, 5037, 5036},
  {5908, 5036, 4999},
  {5034, 5037, 5033},
  {5038, 5062, 4917},
  {4969, 5035, 5087},
  {4969, 5087, 4914},
  {5036, 5037, 5063},
  {5001, 4970, 5000},
  {5039, 5090, 5038},
  {5001, 5063, 5089},
  {4971, 5088, 5091},
  {5040, 4971, 5091},
  {5093, 5040, 5131},
  {5040, 5093, 5003},
  {5004, 5003, 5093},
  {5004, 5065, 5005},
  {4975, 4973, 5069},
  {4974, 5069, 4973},
  {4944, 5068, 5042},
  {5096, 5042, 5068},
  {4977, 5044, 5098},
  {5006, 5072, 5045},
  {5045, 5100, 5076},
  {4947, 5012, 5044},
  {5006, 5011, 5046},
  {5074, 4980, 5102},
  {5009, 5138, 5007},
  {5011, 5074, 5046},
  {5105, 4949, 4978},
  {5009, 4981, 5076},
  {4981, 5010, 5076},
  {5075, 4953, 5106},
  {4953, 5075, 5012},
  {4949, 5105, 5077},
  {4949, 5077, 5013},
  {5013, 5077, 5047},
  {5013, 5047, 5016},
  {5048, 4929, 5079},
  {5017, 5111, 4985},
  {5017, 5018, 5112},
  {5019, 5113, 5050},
  {5051, 5052, 5053},
  {5051, 5053, 5021},
  {5024, 5025, 4991},
  {5021, 5114, 5023},
  {5023, 5080, 4995},
  {5023, 5114, 5080},
  {5025, 5026, 5054},
  {5054, 5057, 4994},
  {4935, 5027, 5081},
  {5116, 5081, 5027},
  {5080, 5056, 4995},
  {5055, 5026, 4995},
  {5026, 5055, 5054},
  {5148, 5116, 5027},
  {4995, 5056, 5055},
  {5148, 5027, 5028},
  {5148, 5028, 5058},
  {4996, 5057, 5029},
  {5028, 5031, 5058},
  {5122, 5031, 5059},
  {5031, 5032, 5059},
  {5061, 5084, 4968},
  {4998, 5151, 5032},
  {5033, 5085, 5128},
  {5151, 4998, 5062},
  {5001, 4999, 5036},
  {4999, 5001, 5000},
  {5034, 5153, 5037},
  {5036, 5063, 5001},
  {5002, 5064, 5039},
  {5001, 5089, 5088},
  {5131, 5040, 5091},
  {5041, 4757, 5067},
  {5041, 5067, 5190},
  {5004, 5093, 5065},
  {5092, 5065, 5093},
  {5005, 5065, 5066},
  {5005, 5066, 4944},
  {4944, 5066, 5068},
  {4757, 5094, 5067},
  {4974, 5095, 5069},
  {5070, 5095, 5071},
  {5097, 4977, 5098},
  {5043, 5071, 5099},
  {5045, 5072, 5100},
  {5072, 5006, 5101},
  {5006, 5046, 5198},
  {5044, 5012, 5164},
  {5164, 5012, 5075},
  {5138, 5104, 5007},
  {5073, 5046, 5074},
  {4978, 5007, 5105},
  {5009, 5076, 5138},
  {5106, 4985, 5107},
  {5139, 5107, 4985},
  {5047, 5077, 5016},
  {5078, 5016, 5077},
  {5014, 5048, 5109},
  {5139, 4985, 5111},
  {5048, 5079, 5109},
  {5017, 5112, 5111},
  {5110, 5079, 5078},
  {5049, 5113, 5019},
  {5113, 5018, 5050},
  {5053, 5052, 5142},
  {5053, 5114, 5021},
  {5052, 5022, 5142},
  {5115, 5142, 5022},
  {5022, 5081, 5115},
  {5117, 5080, 5114},
  {5056, 5080, 5117},
  {5055, 5118, 5054},
  {5057, 5054, 5118},
  {5118, 5055, 5082},
  {5056, 5082, 5055},
  {5215, 5029, 5057},
  {5031, 5122, 5058},
  {5187, 5083, 5184},
  {5059, 5086, 5122},
  {5124, 5083, 5187},
  {5059, 5032, 5086},
  {5083, 5124, 5060},
  {5085, 5084, 5061},
  {5086, 5032, 5151},
  {5035, 5060, 5124},
  {5062, 5126, 5151},
  {5062, 5152, 5126},
  {5128, 5153, 5033},
  {5061, 4914, 5087},
  {5061, 5087, 5150},
  {5033, 5153, 5034},
  {5062, 5038, 5152},
  {5038, 5250, 5152},
  {5153, 5063, 5037},
  {5064, 5129, 5039},
  {5039, 5129, 5090},
  {5090, 5250, 5038},
  {5129, 5190, 5090},
  {5065, 5157, 5066},
  {5068, 5066, 5096},
  {5095, 5070, 5069},
  {5042, 5096, 5134},
  {5100, 5072, 5197},
  {5101, 5197, 5072},
  {5099, 5135, 5043},
  {5102, 5043, 5135},
  {5198, 5101, 5006},
  {5076, 5100, 5170},
  {5198, 5046, 5103},
  {5171, 5103, 5046},
  {5164, 5075, 5136},
  {5046, 5073, 5171},
  {5073, 5074, 5102},
  {5073, 5102, 5171},
  {5075, 5106, 5136},
  {5007, 5104, 5105},
  {5105, 5110, 5077},
  {5014, 5109, 5108},
  {5110, 5078, 5077},
  {5014, 5108, 5049},
  {5049, 5108, 5140},
  {5112, 5139, 5111},
  {5049, 5140, 5113},
  {5018, 5141, 5112},
  {5114, 5053, 5142},
  {5081, 5116, 5115},
  {5118, 5119, 5057},
  {5056, 5117, 5120},
  {5120, 5117, 5121},
  {5120, 5119, 5082},
  {5120, 5082, 5056},
  {5120, 5121, 5119},
  {5082, 5119, 5118},
  {5215, 5083, 5029},
  {5058, 5122, 5123},
  {5187, 5184, 5277},
  {5125, 5122, 5086},
  {5085, 5061, 5128},
  {5125, 5086, 5151},
  {5035, 5124, 5127},
  {5127, 5284, 5035},
  {5088, 5089, 5154},
  {5088, 5155, 5091},
  {5130, 5250, 5090},
  {5129, 5041, 5190},
  {5090, 5190, 5130},
  {5131, 5091, 5156},
  {5229, 5093, 5131},
  {5092, 5093, 5229},
  {5066, 5193, 5096},
  {5161, 5096, 5193},
  {5094, 5097, 5132},
  {5133, 5132, 5097},
  {5095, 5042, 5134},
  {5097, 5098, 5133},
  {5071, 5095, 5099},
  {5133, 5098, 5196},
  {5098, 5044, 5196},
  {5044, 5164, 5196},
  {5135, 5163, 5102},
  {5102, 5163, 5200},
  {5165, 5170, 5100},
  {5170, 5138, 5076},
  {5136, 5106, 5168},
  {5137, 5169, 5110},
  {5137, 5110, 5105},
  {5105, 5167, 5137},
  {5105, 5104, 5167},
  {5106, 5206, 5168},
  {5206, 5106, 5107},
  {5107, 5174, 5206},
  {5110, 5169, 5173},
  {5107, 5139, 5174},
  {5108, 5109, 5208},
  {5209, 5140, 5108},
  {5113, 5140, 5141},
  {5018, 5113, 5141},
  {5114, 5177, 5117},
  {5115, 5116, 5212},
  {5117, 5177, 5178},
  {5178, 5143, 5117},
  {5057, 5119, 5144},
  {5143, 5145, 5117},
  {5121, 5117, 5145},
  {5145, 5143, 5146},
  {5145, 5119, 5121},
  {5145, 5146, 5147},
  {5145, 5147, 5119},
  {5144, 5215, 5057},
  {5083, 5215, 5184},
  {5148, 5058, 5217},
  {5149, 5217, 5058},
  {5123, 5149, 5058},
  {5123, 5122, 5149},
  {5150, 5223, 5061},
  {5124, 5222, 5127},
  {5280, 5127, 5222},
  {5128, 5061, 5223},
  {5151, 5126, 5224},
  {5152, 5224, 5126},
  {5283, 5153, 5128},
  {5087, 5035, 5247},
  {5247, 5035, 5284},
  {5089, 5063, 5153},
  {5089, 5153, 5154},
  {5250, 5130, 5226},
  {5130, 5190, 5226},
  {5155, 5156, 5091},
  {5156, 5188, 5131},
  {5157, 5092, 5191},
  {5092, 5157, 5065},
  {5158, 5159, 5157},
  {5157, 5193, 5066},
  {5157, 5159, 5193},
  {5132, 5230, 5253},
  {5158, 5160, 5159},
  {5253, 5094, 5132},
  {5132, 5133, 5230},
  {5095, 5134, 5135},
  {5134, 5096, 5135},
  {5095, 5135, 5099},
  {5096, 5161, 5135},
  {5163, 5135, 5161},
  {5161, 5233, 5163},
  {5197, 5162, 5100},
  {5201, 5196, 5164},
  {5162, 5165, 5100},
  {5201, 5164, 5136},
  {5198, 5103, 5236},
  {5136, 5168, 5202},
  {5204, 5202, 5168},
  {5203, 5166, 5169},
  {5167, 5169, 5137},
  {5169, 5167, 5203},
  {5172, 5103, 5171},
  {5205, 5171, 5102},
  {5168, 5206, 5204},
  {5138, 5167, 5104},
  {5170, 5239, 5138},
  {5205, 5172, 5171},
  {5206, 5174, 5304},
  {5169, 5207, 5173},
  {5174, 5139, 5210},
  {5173, 5175, 5110},
  {5110, 5175, 5079},
  {5141, 5140, 5209},
  {5139, 5112, 5210},
  {5176, 5210, 5112},
  {5209, 5176, 5141},
  {5112, 5141, 5176},
  {5177, 5114, 5142},
  {5148, 5212, 5116},
  {5147, 5146, 5213},
  {5179, 5213, 5146},
  {5147, 5144, 5119},
  {5147, 5213, 5144},
  {5213, 5215, 5144},
  {5214, 5180, 5181},
  {5181, 5180, 5183},
  {5181, 5183, 5143},
  {5143, 5183, 5146},
  {5179, 5146, 5183},
  {5180, 5214, 5182},
  {5180, 5182, 5183},
  {5148, 5217, 5214},
  {5214, 5185, 5182},
  {5182, 5186, 5183},
  {5182, 5185, 5186},
  {5149, 5122, 5219},
  {5187, 5222, 5124},
  {5150, 5221, 5223},
  {5125, 5151, 5279},
  {5152, 5225, 5224},
  {5087, 5247, 5150},
  {5152, 5250, 5225},
  {5154, 5153, 5283},
  {5155, 5251, 5156},
  {5156, 5251, 5188},
  {5188, 5227, 5131},
  {5131, 5227, 5189},
  {5189, 5229, 5131},
  {5189, 5228, 5229},
  {5092, 5229, 5191},
  {5226, 5190, 5348},
  {5229, 5158, 5191},
  {5157, 5191, 5158},
  {5190, 5067, 5094},
  {5190, 5094, 5253},
  {5192, 5158, 5229},
  {5160, 5158, 5192},
  {5192, 5231, 5194},
  {5192, 5194, 5160},
  {5255, 5230, 5133},
  {5195, 5159, 5160},
  {5159, 5195, 5193},
  {5160, 5194, 5232},
  {5160, 5232, 5195},
  {5165, 5162, 5234},
  {5261, 5235, 5199},
  {5202, 5201, 5136},
  {5170, 5165, 5239},
  {5240, 5236, 5103},
  {5166, 5203, 5237},
  {5203, 5167, 5165},
  {5103, 5172, 5240},
  {5102, 5200, 5205},
  {5207, 5169, 5166},
  {5167, 5138, 5239},
  {5167, 5239, 5165},
  {5172, 5269, 5240},
  {5207, 5175, 5173},
  {5174, 5210, 5273},
  {5142, 5115, 5177},
  {5115, 5212, 5177},
  {5177, 5212, 5178},
  {5211, 5213, 5179},
  {5212, 5214, 5181},
  {5212, 5181, 5143},
  {5212, 5143, 5178},
  {5179, 5216, 5211},
  {5215, 5213, 5184},
  {5214, 5217, 5185},
  {5183, 5218, 5216},
  {5183, 5216, 5179},
  {5183, 5186, 5218},
  {5149, 5185, 5217},
  {5185, 5149, 5219},
  {5185, 5219, 5220},
  {5185, 5220, 5186},
  {5186, 5220, 5218},
  {5219, 5122, 5243},
  {5220, 5219, 5243},
  {5122, 5125, 5243},
  {5187, 5277, 5222},
  {5224, 5244, 5151},
  {5283, 5128, 5281},
  {5224, 5225, 5245},
  {5127, 5246, 5284},
  {5249, 5155, 5088},
  {5283, 5088, 5154},
  {5285, 5188, 5251},
  {5228, 5189, 5227},
  {5348, 5190, 5253},
  {5228, 5192, 5229},
  {5192, 5287, 5231},
  {5232, 5231, 5254},
  {5231, 5232, 5194},
  {5195, 5161, 5193},
  {5195, 5232, 5233},
  {5195, 5233, 5161},
  {5133, 5196, 5255},
  {5257, 5295, 5235},
  {5257, 5235, 5259},
  {5260, 5233, 5232},
  {5259, 5235, 5261},
  {5233, 5260, 5163},
  {5200, 5163, 5260},
  {5162, 5262, 5234},
  {5162, 5197, 5262},
  {5197, 5101, 5262},
  {5101, 5198, 5264},
  {5198, 5299, 5264},
  {5261, 5199, 5200},
  {5198, 5236, 5299},
  {5266, 5235, 5297},
  {5235, 5238, 5199},
  {5203, 5298, 5237},
  {5203, 5165, 5298},
  {5235, 5266, 5238},
  {5238, 5205, 5199},
  {5199, 5205, 5200},
  {5202, 5204, 5265},
  {5237, 5207, 5166},
  {5205, 5267, 5172},
  {5204, 5206, 5268},
  {5207, 5237, 5272},
  {5269, 5303, 5240},
  {5174, 5273, 5304},
  {5209, 5108, 5270},
  {5108, 5208, 5307},
  {5207, 5241, 5175},
  {5210, 5176, 5274},
  {5176, 5209, 5274},
  {5216, 5275, 5211},
  {5211, 5275, 5213},
  {5214, 5212, 5148},
  {5184, 5213, 5275},
  {5275, 5310, 5184},
  {5218, 5311, 5216},
  {5184, 5310, 5277},
  {5218, 5220, 5276},
  {5242, 5220, 5243},
  {5221, 5150, 5343},
  {5278, 5243, 5125},
  {5244, 5279, 5151},
  {5223, 5321, 5128},
  {5281, 5128, 5321},
  {5245, 5282, 5244},
  {5244, 5224, 5245},
  {5246, 5127, 5280},
  {5250, 5345, 5225},
  {5248, 5155, 5249},
  {5088, 5283, 5249},
  {5248, 5251, 5155},
  {5227, 5188, 5252},
  {5227, 5252, 5192},
  {5227, 5192, 5228},
  {5252, 5286, 5192},
  {5253, 5230, 5348},
  {5286, 5287, 5192},
  {5230, 5255, 5348},
  {5231, 5287, 5254},
  {5294, 5232, 5254},
  {5255, 5196, 5258},
  {5256, 5295, 5257},
  {5294, 5325, 5232},
  {5258, 5196, 5201},
  {5165, 5234, 5296},
  {5262, 5101, 5263},
  {5295, 5297, 5235},
  {5261, 5200, 5326},
  {5200, 5260, 5326},
  {5101, 5264, 5263},
  {5202, 5330, 5201},
  {5298, 5165, 5329},
  {5240, 5299, 5236},
  {5205, 5238, 5267},
  {5238, 5302, 5267},
  {5238, 5266, 5302},
  {5206, 5304, 5268},
  {5237, 5306, 5272},
  {5269, 5172, 5267},
  {5271, 5305, 5270},
  {5270, 5108, 5271},
  {5307, 5271, 5108},
  {5207, 5272, 5241},
  {5209, 5270, 5274},
  {5210, 5335, 5273},
  {5208, 5241, 5307},
  {5272, 5307, 5241},
  {5309, 5335, 5210},
  {5210, 5274, 5309},
  {5216, 5311, 5275},
  {5311, 5218, 5276},
  {5220, 5242, 5276},
  {5313, 5276, 5242},
  {5243, 5314, 5242},
  {5313, 5242, 5314},
  {5243, 5278, 5314},
  {5374, 5314, 5278},
  {5438, 5221, 5343},
  {5317, 5278, 5125},
  {5374, 5278, 5317},
  {5277, 5336, 5222},
  {5223, 5221, 5315},
  {5280, 5222, 5336},
  {5279, 5244, 5441},
  {5318, 5441, 5244},
  {5244, 5282, 5318},
  {5280, 5337, 5246},
  {5319, 5246, 5337},
  {5321, 5248, 5281},
  {5150, 5247, 5343},
  {5248, 5249, 5281},
  {5344, 5246, 5319},
  {5346, 5248, 5321},
  {5246, 5344, 5284},
  {5251, 5248, 5346},
  {5281, 5249, 5283},
  {5250, 5347, 5345},
  {5250, 5226, 5347},
  {5226, 5348, 5384},
  {5285, 5323, 5188},
  {5188, 5324, 5252},
  {5288, 5293, 5290},
  {5288, 5289, 5293},
  {5287, 5351, 5254},
  {5289, 5355, 5293},
  {5290, 5293, 5291},
  {5291, 5293, 5292},
  {5254, 5351, 5294},
  {5293, 5256, 5292},
  {5355, 5295, 5293},
  {5256, 5293, 5295},
  {5255, 5258, 5459},
  {5256, 5257, 5294},
  {5294, 5259, 5325},
  {5232, 5326, 5260},
  {5296, 5234, 5356},
  {5326, 5325, 5259},
  {5259, 5261, 5326},
  {5330, 5327, 5201},
  {5165, 5296, 5329},
  {5262, 5263, 5357},
  {5263, 5264, 5359},
  {5202, 5265, 5330},
  {5332, 5265, 5204},
  {5266, 5297, 5363},
  {5300, 5360, 5299},
  {5299, 5240, 5300},
  {5303, 5300, 5240},
  {5204, 5268, 5332},
  {5300, 5303, 5301},
  {5302, 5266, 5363},
  {5267, 5302, 5269},
  {5366, 5305, 5271},
  {5270, 5305, 5308},
  {5271, 5307, 5366},
  {5306, 5334, 5272},
  {5335, 5304, 5273},
  {5309, 5274, 5308},
  {5274, 5270, 5308},
  {5334, 5307, 5272},
  {5276, 5312, 5311},
  {5312, 5276, 5313},
  {5221, 5438, 5315},
  {5125, 5279, 5317},
  {5336, 5337, 5280},
  {5315, 5316, 5223},
  {5339, 5223, 5316},
  {5223, 5339, 5320},
  {5441, 5318, 5402},
  {5337, 5338, 5319},
  {5223, 5320, 5321},
  {5320, 5443, 5380},
  {5282, 5341, 5340},
  {5346, 5321, 5320},
  {5282, 5345, 5341},
  {5282, 5245, 5345},
  {5225, 5345, 5245},
  {5247, 5284, 5344},
  {5322, 5251, 5346},
  {5251, 5322, 5383},
  {5251, 5383, 5285},
  {5285, 5383, 5323},
  {5188, 5323, 5324},
  {5324, 5386, 5252},
  {5252, 5386, 5286},
  {5286, 5452, 5287},
  {5349, 5289, 5288},
  {5349, 5288, 5290},
  {5387, 5348, 5255},
  {5289, 5352, 5354},
  {5351, 5292, 5294},
  {5289, 5354, 5355},
  {5459, 5387, 5255},
  {5326, 5232, 5325},
  {5234, 5262, 5356},
  {5295, 5355, 5328},
  {5295, 5328, 5297},
  {5359, 5357, 5263},
  {5362, 5358, 5330},
  {5330, 5265, 5362},
  {5265, 5332, 5362},
  {5329, 5364, 5298},
  {5359, 5264, 5360},
  {5264, 5299, 5360},
  {5331, 5360, 5300},
  {5300, 5301, 5331},
  {5303, 5331, 5301},
  {5332, 5268, 5394},
  {5237, 5298, 5306},
  {5298, 5364, 5306},
  {5363, 5303, 5302},
  {5269, 5302, 5303},
  {5363, 5393, 5303},
  {5268, 5304, 5333},
  {5334, 5306, 5364},
  {5333, 5304, 5398},
  {5308, 5365, 5309},
  {5310, 5275, 5368},
  {5368, 5275, 5311},
  {5310, 5371, 5277},
  {5313, 5314, 5373},
  {5314, 5374, 5373},
  {5315, 5438, 5339},
  {5315, 5339, 5316},
  {5375, 5279, 5441},
  {5279, 5375, 5317},
  {5338, 5342, 5319},
  {5339, 5377, 5320},
  {5443, 5320, 5377},
  {5438, 5343, 5379},
  {5318, 5282, 5403},
  {5282, 5340, 5403},
  {5319, 5342, 5344},
  {5344, 5379, 5247},
  {5247, 5379, 5343},
  {5322, 5346, 5381},
  {5347, 5226, 5384},
  {5383, 5385, 5323},
  {5323, 5385, 5324},
  {5348, 5487, 5384},
  {5286, 5386, 5452},
  {5289, 5349, 5350},
  {5349, 5290, 5456},
  {5350, 5352, 5289},
  {5290, 5291, 5351},
  {5291, 5292, 5351},
  {5352, 5353, 5354},
  {5292, 5256, 5294},
  {5389, 5459, 5258},
  {5259, 5294, 5257},
  {5389, 5258, 5327},
  {5201, 5327, 5258},
  {5356, 5262, 5390},
  {5357, 5390, 5262},
  {5329, 5296, 5391},
  {5361, 5297, 5328},
  {5297, 5361, 5363},
  {5392, 5360, 5331},
  {5362, 5332, 5426},
  {5331, 5303, 5393},
  {5331, 5393, 5392},
  {5394, 5426, 5332},
  {5268, 5333, 5396},
  {5308, 5305, 5397},
  {5305, 5430, 5397},
  {5395, 5334, 5364},
  {5366, 5334, 5395},
  {5307, 5334, 5366},
  {5304, 5335, 5367},
  {5304, 5367, 5398},
  {5367, 5309, 5365},
  {5335, 5309, 5367},
  {5368, 5311, 5371},
  {5371, 5310, 5368},
  {5312, 5369, 5311},
  {5371, 5311, 5369},
  {5370, 5369, 5312},
  {5372, 5370, 5313},
  {5370, 5312, 5313},
  {5277, 5432, 5336},
  {5337, 5336, 5432},
  {5372, 5313, 5373},
  {5317, 5375, 5374},
  {5441, 5439, 5375},
  {5338, 5376, 5342},
  {5378, 5342, 5376},
  {5339, 5438, 5377},
  {5318, 5403, 5402},
  {5340, 5341, 5403},
  {5380, 5443, 5407},
  {5320, 5380, 5346},
  {5346, 5380, 5381},
  {5342, 5404, 5344},
  {5344, 5404, 5379},
  {5341, 5345, 5382},
  {5347, 5382, 5345},
  {5381, 5383, 5322},
  {5386, 5324, 5385},
  {5349, 5415, 5350},
  {5287, 5416, 5351},
  {5351, 5416, 5420},
  {5290, 5351, 5418},
  {5350, 5388, 5352},
  {5352, 5388, 5353},
  {5353, 5388, 5354},
  {5421, 5389, 5422},
  {5327, 5422, 5389},
  {5462, 5356, 5390},
  {5495, 5390, 5357},
  {5357, 5359, 5495},
  {5461, 5495, 5359},
  {5356, 5462, 5296},
  {5360, 5461, 5359},
  {5425, 5461, 5360},
  {5358, 5362, 5423},
  {5391, 5296, 5462},
  {5425, 5360, 5392},
  {5328, 5463, 5361},
  {5362, 5464, 5423},
  {5329, 5424, 5364},
  {5393, 5363, 5361},
  {5364, 5466, 5427},
  {5430, 5428, 5397},
  {5395, 5364, 5427},
  {5396, 5394, 5268},
  {5333, 5398, 5396},
  {5365, 5308, 5397},
  {5365, 5397, 5399},
  {5305, 5366, 5430},
  {5367, 5365, 5399},
  {5367, 5399, 5398},
  {5400, 5370, 5372},
  {5432, 5370, 5400},
  {5370, 5432, 5369},
  {5369, 5432, 5371},
  {5371, 5432, 5277},
  {5400, 5372, 5373},
  {5400, 5373, 5374},
  {5400, 5374, 5401},
  {5375, 5436, 5374},
  {5376, 5473, 5378},
  {5378, 5442, 5342},
  {5402, 5403, 5476},
  {5342, 5442, 5480},
  {5438, 5379, 5513},
  {5404, 5513, 5379},
  {5403, 5341, 5444},
  {5341, 5382, 5444},
  {5405, 5444, 5382},
  {5347, 5405, 5382},
  {5410, 5411, 5481},
  {5446, 5481, 5411},
  {5381, 5412, 5383},
  {5412, 5381, 5448},
  {5408, 5444, 5405},
  {5409, 5406, 5444},
  {5405, 5347, 5408},
  {5444, 5408, 5409},
  {5347, 5409, 5408},
  {5485, 5409, 5347},
  {5384, 5485, 5347},
  {5410, 5449, 5411},
  {5450, 5411, 5449},
  {5413, 5411, 5450},
  {5383, 5412, 5385},
  {5414, 5385, 5412},
  {5385, 5414, 5386},
  {5487, 5348, 5453},
  {5413, 5450, 5521},
  {5455, 5415, 5549},
  {5287, 5452, 5416},
  {5416, 5452, 5490},
  {5455, 5350, 5415},
  {5418, 5456, 5290},
  {5420, 5418, 5351},
  {5416, 5417, 5420},
  {5419, 5420, 5417},
  {5387, 5459, 5528},
  {5355, 5354, 5492},
  {5460, 5421, 5422},
  {5390, 5495, 5534},
  {5496, 5564, 5328},
  {5358, 5423, 5422},
  {5463, 5328, 5564},
  {5329, 5391, 5424},
  {5391, 5462, 5424},
  {5466, 5364, 5424},
  {5393, 5361, 5463},
  {5426, 5464, 5362},
  {5397, 5428, 5429},
  {5395, 5427, 5467},
  {5395, 5467, 5430},
  {5395, 5430, 5366},
  {5396, 5503, 5394},
  {5396, 5506, 5503},
  {5399, 5397, 5429},
  {5399, 5429, 5398},
  {5400, 5431, 5432},
  {5433, 5431, 5434},
  {5431, 5400, 5434},
  {5434, 5400, 5401},
  {5435, 5338, 5337},
  {5435, 5337, 5432},
  {5470, 5437, 5338},
  {5470, 5338, 5435},
  {5434, 5401, 5436},
  {5434, 5436, 5469},
  {5436, 5401, 5374},
  {5471, 5375, 5439},
  {5471, 5436, 5375},
  {5471, 5469, 5436},
  {5437, 5473, 5376},
  {5437, 5376, 5338},
  {5378, 5473, 5512},
  {5377, 5438, 5440},
  {5377, 5440, 5443},
  {5378, 5512, 5442},
  {5478, 5476, 5403},
  {5444, 5478, 5403},
  {5589, 5513, 5404},
  {5516, 5589, 5404},
  {5342, 5480, 5516},
  {5342, 5516, 5404},
  {5446, 5443, 5481},
  {5407, 5443, 5446},
  {5486, 5380, 5407},
  {5380, 5486, 5381},
  {5444, 5406, 5445},
  {5446, 5447, 5407},
  {5407, 5447, 5483},
  {5381, 5486, 5448},
  {5407, 5483, 5486},
  {5451, 5412, 5448},
  {5414, 5412, 5451},
  {5485, 5518, 5409},
  {5520, 5485, 5384},
  {5384, 5487, 5520},
  {5411, 5413, 5551},
  {5454, 5551, 5413},
  {5452, 5451, 5523},
  {5549, 5415, 5488},
  {5386, 5414, 5451},
  {5452, 5386, 5451},
  {5457, 5454, 5521},
  {5521, 5454, 5413},
  {5415, 5349, 5456},
  {5348, 5387, 5453},
  {5490, 5418, 5420},
  {5490, 5420, 5458},
  {5490, 5458, 5416},
  {5416, 5458, 5417},
  {5458, 5420, 5419},
  {5458, 5419, 5417},
  {5528, 5526, 5387},
  {5492, 5354, 5558},
  {5390, 5534, 5563},
  {5355, 5496, 5328},
  {5460, 5422, 5423},
  {5462, 5390, 5563},
  {5461, 5425, 5498},
  {5423, 5465, 5497},
  {5424, 5499, 5466},
  {5392, 5500, 5425},
  {5393, 5463, 5500},
  {5464, 5502, 5465},
  {5464, 5465, 5423},
  {5392, 5393, 5500},
  {5466, 5499, 5427},
  {5394, 5538, 5501},
  {5394, 5501, 5426},
  {5429, 5504, 5506},
  {5429, 5428, 5504},
  {5506, 5398, 5429},
  {5428, 5430, 5505},
  {5430, 5507, 5505},
  {5506, 5396, 5398},
  {5468, 5431, 5433},
  {5435, 5432, 5431},
  {5435, 5431, 5468},
  {5469, 5508, 5468},
  {5468, 5433, 5434},
  {5468, 5470, 5435},
  {5468, 5434, 5469},
  {5472, 5510, 5471},
  {5471, 5439, 5472},
  {5437, 5909, 5473},
  {5439, 5441, 5511},
  {5511, 5441, 5474},
  {5474, 5476, 5475},
  {5477, 5475, 5476},
  {5441, 5402, 5474},
  {5476, 5474, 5402},
  {5513, 5481, 5438},
  {5443, 5438, 5481},
  {5481, 5513, 5594},
  {5438, 5443, 5440},
  {5476, 5478, 5477},
  {5444, 5479, 5478},
  {5444, 5445, 5479},
  {5546, 5479, 5445},
  {5481, 5482, 5410},
  {5517, 5410, 5482},
  {5616, 5447, 5446},
  {5598, 5447, 5616},
  {5447, 5598, 5483},
  {5406, 5518, 5445},
  {5406, 5409, 5518},
  {5410, 5517, 5449},
  {5411, 5551, 5446},
  {5483, 5547, 5486},
  {5448, 5484, 5451},
  {5521, 5449, 5575},
  {5484, 5519, 5451},
  {5449, 5521, 5450},
  {5519, 5523, 5451},
  {5487, 5453, 5524},
  {5552, 5455, 5549},
  {5415, 5456, 5489},
  {5415, 5489, 5488},
  {5550, 5457, 5521},
  {5490, 5452, 5523},
  {5489, 5456, 5418},
  {5489, 5418, 5490},
  {5550, 5491, 5457},
  {5455, 5525, 5350},
  {5457, 5491, 5527},
  {5457, 5527, 5454},
  {5388, 5350, 5525},
  {5558, 5354, 5388},
  {5492, 5558, 5559},
  {5530, 5421, 5460},
  {5389, 5529, 5459},
  {5460, 5532, 5530},
  {5355, 5492, 5493},
  {5355, 5493, 5496},
  {5460, 5494, 5532},
  {5494, 5460, 5423},
  {5494, 5423, 5533},
  {5562, 5423, 5497},
  {5462, 5536, 5424},
  {5497, 5465, 5565},
  {5499, 5424, 5536},
  {5500, 5498, 5425},
  {5564, 5500, 5463},
  {5501, 5538, 5502},
  {5501, 5464, 5426},
  {5501, 5502, 5464},
  {5427, 5499, 5539},
  {5503, 5538, 5394},
  {5504, 5540, 5506},
  {5504, 5428, 5541},
  {5505, 5541, 5428},
  {5539, 5542, 5467},
  {5467, 5542, 5430},
  {5467, 5427, 5539},
  {5507, 5430, 5542},
  {5468, 5508, 5510},
  {5468, 5510, 5470},
  {5469, 5471, 5508},
  {5509, 5510, 5472},
  {5509, 5511, 5474},
  {5472, 5439, 5509},
  {5511, 5509, 5439},
  {5512, 5473, 5912},
  {5477, 5514, 5912},
  {5477, 5478, 5514},
  {5515, 5514, 5478},
  {5513, 5571, 5594},
  {5478, 5545, 5515},
  {5478, 5479, 5545},
  {5442, 5544, 5480},
  {5481, 5596, 5482},
  {5517, 5482, 5596},
  {5546, 5445, 5518},
  {5547, 5483, 5598},
  {5575, 5449, 5517},
  {5486, 5484, 5448},
  {5485, 5520, 5576},
  {5446, 5551, 5577},
  {5519, 5484, 5548},
  {5484, 5486, 5548},
  {5549, 5486, 5547},
  {5548, 5486, 5549},
  {5520, 5487, 5524},
  {5488, 5489, 5522},
  {5522, 5489, 5523},
  {5525, 5455, 5552},
  {5523, 5489, 5490},
  {5526, 5453, 5387},
  {5526, 5524, 5453},
  {5550, 5579, 5491},
  {5579, 5554, 5491},
  {5454, 5527, 5555},
  {5525, 5558, 5388},
  {5491, 5554, 5557},
  {5528, 5459, 5529},
  {5558, 5581, 5559},
  {5530, 5560, 5421},
  {5421, 5529, 5389},
  {5559, 5531, 5492},
  {5461, 5492, 5531},
  {5495, 5461, 5535},
  {5492, 5461, 5493},
  {5496, 5493, 5461},
  {5534, 5495, 5561},
  {5496, 5461, 5564},
  {5533, 5423, 5562},
  {5497, 5565, 5562},
  {5536, 5462, 5566},
  {5539, 5499, 5536},
  {5539, 5536, 5566},
  {5537, 5565, 5465},
  {5502, 5537, 5465},
  {5609, 5538, 5503},
  {5540, 5504, 5541},
  {5541, 5505, 5587},
  {5540, 5503, 5506},
  {5542, 5505, 5507},
  {5510, 5508, 5471},
  {5512, 5543, 5442},
  {5544, 5442, 5543},
  {5588, 5514, 5515},
  {5515, 5545, 5588},
  {5545, 5479, 5572},
  {5573, 5480, 5544},
  {5589, 5516, 5614},
  {5516, 5480, 5573},
  {5572, 5479, 5546},
  {5518, 5485, 5574},
  {5518, 5574, 5597},
  {5485, 5576, 5574},
  {5548, 5549, 5488},
  {5519, 5522, 5523},
  {5553, 5524, 5526},
  {5553, 5578, 5524},
  {5551, 5454, 5555},
  {5556, 5553, 5528},
  {5553, 5526, 5528},
  {5554, 5623, 5557},
  {5556, 5528, 5529},
  {5491, 5557, 5527},
  {5529, 5560, 5556},
  {5529, 5421, 5560},
  {5582, 5584, 5535},
  {5494, 5533, 5604},
  {5562, 5604, 5533},
  {5495, 5535, 5584},
  {5535, 5461, 5531},
  {5534, 5561, 5563},
  {5461, 5498, 5564},
  {5462, 5607, 5566},
  {5462, 5563, 5585},
  {5498, 5500, 5564},
  {5539, 5566, 5567},
  {5537, 5502, 5608},
  {5568, 5608, 5502},
  {5609, 5568, 5538},
  {5538, 5568, 5502},
  {5540, 5541, 5569},
  {5569, 5609, 5503},
  {5503, 5540, 5569},
  {5567, 5570, 5542},
  {5542, 5539, 5567},
  {5570, 5587, 5505},
  {5505, 5542, 5570},
  {5912, 5514, 5650},
  {5588, 5650, 5514},
  {5912, 5611, 5512},
  {5512, 5588, 5543},
  {5513, 5589, 5571},
  {5543, 5588, 5544},
  {5545, 5572, 5592},
  {5481, 5594, 5596},
  {5546, 5595, 5572},
  {5614, 5516, 5573},
  {5546, 5518, 5595},
  {5518, 5597, 5595},
  {5549, 5547, 5598},
  {5576, 5520, 5524},
  {5548, 5488, 5522},
  {5548, 5522, 5519},
  {5521, 5618, 5550},
  {5579, 5550, 5618},
  {5578, 5553, 5659},
  {5659, 5580, 5620},
  {5580, 5659, 5556},
  {5659, 5553, 5556},
  {5558, 5525, 5621},
  {5601, 5623, 5554},
  {5527, 5626, 5555},
  {5580, 5556, 5560},
  {5557, 5626, 5527},
  {5558, 5622, 5581},
  {5559, 5581, 5582},
  {5560, 5530, 5583},
  {5531, 5582, 5535},
  {5582, 5531, 5559},
  {5530, 5532, 5583},
  {5532, 5494, 5583},
  {5584, 5582, 5605},
  {5706, 5605, 5582},
  {5495, 5606, 5561},
  {5495, 5584, 5639},
  {5607, 5462, 5642},
  {5462, 5585, 5642},
  {5537, 5586, 5565},
  {5567, 5566, 5607},
  {5537, 5608, 5586},
  {5567, 5587, 5570},
  {5512, 5611, 5588},
  {5588, 5914, 5544},
  {5588, 5545, 5590},
  {5591, 5590, 5545},
  {5545, 5592, 5591},
  {5544, 5914, 5593},
  {5544, 5593, 5573},
  {5595, 5592, 5572},
  {5597, 5613, 5595},
  {5594, 5655, 5596},
  {5574, 5615, 5597},
  {5517, 5596, 5655},
  {5517, 5655, 5575},
  {5576, 5685, 5574},
  {5655, 5687, 5575},
  {5575, 5599, 5521},
  {5446, 5657, 5616},
  {5446, 5577, 5657},
  {5524, 5617, 5576},
  {5599, 5618, 5521},
  {5552, 5549, 5600},
  {5549, 5598, 5600},
  {5577, 5551, 5657},
  {5617, 5524, 5578},
  {5579, 5618, 5619},
  {5554, 5579, 5619},
  {5601, 5554, 5619},
  {5525, 5661, 5621},
  {5551, 5555, 5663},
  {5558, 5621, 5602},
  {5555, 5664, 5663},
  {5602, 5622, 5558},
  {5625, 5557, 5628},
  {5557, 5625, 5626},
  {5664, 5555, 5626},
  {5624, 5629, 5622},
  {5622, 5629, 5581},
  {5624, 5634, 5629},
  {5582, 5581, 5706},
  {5560, 5667, 5580},
  {5624, 5603, 5634},
  {5560, 5583, 5635},
  {5494, 5604, 5636},
  {5494, 5636, 5583},
  {5604, 5562, 5673},
  {5495, 5639, 5606},
  {5709, 5584, 5605},
  {5562, 5565, 5640},
  {5562, 5640, 5673},
  {5584, 5709, 5639},
  {5561, 5606, 5676},
  {5561, 5676, 5563},
  {5565, 5641, 5640},
  {5585, 5563, 5676},
  {5565, 5586, 5641},
  {5586, 5608, 5643},
  {5568, 5609, 5645},
  {5568, 5645, 5608},
  {5569, 5646, 5609},
  {5569, 5541, 5646},
  {5647, 5648, 5567},
  {5610, 5651, 5611},
  {5588, 5590, 5914},
  {5589, 5614, 5571},
  {5595, 5613, 5612},
  {5612, 5592, 5595},
  {5612, 5653, 5592},
  {5571, 5614, 5594},
  {5613, 5597, 5684},
  {5573, 5593, 5654},
  {5573, 5654, 5614},
  {5685, 5576, 5656},
  {5575, 5687, 5599},
  {5617, 5656, 5576},
  {5599, 5690, 5618},
  {5659, 5617, 5578},
  {5657, 5551, 5658},
  {5913, 5658, 5551},
  {5525, 5699, 5661},
  {5619, 5660, 5601},
  {5601, 5660, 5662},
  {5665, 5620, 5580},
  {5601, 5662, 5623},
  {5602, 5621, 5701},
  {5602, 5701, 5622},
  {5623, 5628, 5557},
  {5603, 5624, 5743},
  {5632, 5666, 5703},
  {5632, 5628, 5666},
  {5628, 5632, 5633},
  {5630, 5603, 5627},
  {5581, 5629, 5706},
  {5667, 5560, 5631},
  {5603, 5630, 5634},
  {5634, 5669, 5629},
  {5706, 5629, 5669},
  {5632, 5637, 5633},
  {5583, 5636, 5708},
  {5583, 5708, 5635},
  {5637, 5674, 5633},
  {5633, 5674, 5671},
  {5605, 5706, 5709},
  {5604, 5673, 5636},
  {5637, 5638, 5674},
  {5676, 5606, 5672},
  {5606, 5639, 5672},
  {5640, 5711, 5673},
  {5640, 5641, 5711},
  {5607, 5714, 5713},
  {5607, 5713, 5567},
  {5607, 5642, 5714},
  {5641, 5586, 5643},
  {5642, 5585, 5676},
  {5643, 5608, 5644},
  {5645, 5644, 5608},
  {5646, 5678, 5609},
  {5609, 5678, 5645},
  {5541, 5587, 5646},
  {5587, 5567, 5648},
  {5912, 5650, 5610},
  {5649, 5610, 5650},
  {5610, 5649, 5651},
  {5651, 5652, 5611},
  {5590, 5591, 5716},
  {5613, 5681, 5612},
  {5716, 5591, 5592},
  {5914, 5715, 5593},
  {5613, 5684, 5681},
  {5593, 5715, 5654},
  {5615, 5684, 5597},
  {5654, 5720, 5614},
  {5614, 5655, 5594},
  {5614, 5725, 5655},
  {5615, 5574, 5685},
  {5599, 5687, 5690},
  {5616, 5657, 5600},
  {5659, 5689, 5617},
  {5600, 5657, 5658},
  {5690, 5693, 5618},
  {5689, 5659, 5798},
  {5695, 5619, 5618},
  {5695, 5660, 5619},
  {5659, 5620, 5797},
  {5621, 5661, 5701},
  {5620, 5665, 5741},
  {5622, 5743, 5624},
  {5666, 5628, 5623},
  {5625, 5803, 5626},
  {5626, 5803, 5742},
  {5626, 5742, 5664},
  {5603, 5743, 5627},
  {5580, 5667, 5665},
  {5666, 5774, 5703},
  {5628, 5633, 5625},
  {5668, 5625, 5633},
  {5625, 5668, 5704},
  {5630, 5627, 5776},
  {5631, 5705, 5667},
  {5707, 5705, 5631},
  {5631, 5560, 5635},
  {5631, 5635, 5707},
  {5707, 5635, 5708},
  {5630, 5670, 5634},
  {5634, 5915, 5669},
  {5633, 5671, 5668},
  {5670, 5916, 5634},
  {5637, 5710, 5638},
  {5675, 5638, 5710},
  {5638, 5675, 5674},
  {5641, 5753, 5711},
  {5642, 5676, 5712},
  {5643, 5753, 5641},
  {5644, 5755, 5643},
  {5647, 5567, 5713},
  {5644, 5645, 5756},
  {5677, 5645, 5678},
  {5646, 5679, 5678},
  {5646, 5758, 5679},
  {5645, 5677, 5756},
  {5587, 5648, 5646},
  {5650, 5652, 5680},
  {5590, 5716, 5795},
  {5592, 5653, 5716},
  {5612, 5683, 5653},
  {5653, 5683, 5719},
  {5653, 5719, 5716},
  {5717, 5682, 5612},
  {5612, 5682, 5683},
  {5719, 5683, 5718},
  {5654, 5715, 5720},
  {5615, 5685, 5684},
  {5614, 5720, 5725},
  {5688, 5692, 5686},
  {5686, 5692, 5687},
  {5690, 5687, 5692},
  {5656, 5617, 5689},
  {5688, 5728, 5691},
  {5691, 5728, 5729},
  {5692, 5688, 5691},
  {5691, 5694, 5692},
  {5693, 5732, 5618},
  {5691, 5697, 5694},
  {5698, 5694, 5697},
  {5695, 5618, 5732},
  {5797, 5620, 5735},
  {5700, 5662, 5660},
  {5700, 5738, 5662},
  {5661, 5699, 5770},
  {5620, 5741, 5735},
  {5661, 5770, 5701},
  {5663, 5664, 5740},
  {5741, 5665, 5702},
  {5667, 5702, 5665},
  {5664, 5742, 5740},
  {5701, 5743, 5622},
  {5774, 5666, 5662},
  {5623, 5662, 5666},
  {5625, 5704, 5803},
  {5743, 5744, 5627},
  {5667, 5745, 5702},
  {5776, 5627, 5744},
  {5745, 5667, 5705},
  {5780, 5704, 5668},
  {5777, 5745, 5705},
  {5746, 5777, 5705},
  {5780, 5668, 5779},
  {5747, 5779, 5668},
  {5705, 5707, 5746},
  {5632, 5748, 5637},
  {5669, 5709, 5706},
  {5668, 5671, 5747},
  {5636, 5673, 5807},
  {5637, 5749, 5710},
  {5676, 5672, 5752},
  {5676, 5752, 5712},
  {5639, 5709, 5750},
  {5710, 5786, 5675},
  {5675, 5786, 5674},
  {5714, 5642, 5790},
  {5642, 5712, 5790},
  {5757, 5647, 5713},
  {5757, 5713, 5754},
  {5644, 5756, 5755},
  {5678, 5679, 5758},
  {5646, 5648, 5757},
  {5646, 5757, 5758},
  {5648, 5647, 5757},
  {5681, 5717, 5612},
  {5717, 5684, 5682},
  {5684, 5685, 5682},
  {5682, 5685, 5723},
  {5718, 5683, 5724},
  {5685, 5656, 5722},
  {5685, 5722, 5721},
  {5685, 5721, 5723},
  {5682, 5723, 5683},
  {5683, 5723, 5724},
  {5656, 5760, 5722},
  {5723, 5688, 5724},
  {5686, 5724, 5688},
  {5724, 5726, 5718},
  {5724, 5686, 5726},
  {5655, 5726, 5686},
  {5725, 5761, 5655},
  {5762, 5760, 5656},
  {5688, 5723, 5728},
  {5686, 5687, 5655},
  {5689, 5727, 5656},
  {5764, 5762, 5727},
  {5690, 5692, 5730},
  {5727, 5689, 5798},
  {5727, 5798, 5764},
  {5691, 5729, 5764},
  {5692, 5766, 5730},
  {5690, 5730, 5693},
  {5731, 5693, 5730},
  {5730, 5766, 5731},
  {5693, 5731, 5732},
  {5764, 5697, 5691},
  {5698, 5765, 5694},
  {5733, 5765, 5698},
  {5694, 5765, 5763},
  {5695, 5732, 5763},
  {5768, 5700, 5660},
  {5660, 5695, 5768},
  {5763, 5768, 5695},
  {5696, 5663, 5699},
  {5764, 5734, 5697},
  {5697, 5734, 5698},
  {5736, 5698, 5734},
  {5733, 5698, 5736},
  {5737, 5767, 5733},
  {5734, 5772, 5736},
  {5736, 5737, 5733},
  {5663, 5740, 5699},
  {5736, 5772, 5737},
  {5739, 5737, 5772},
  {5738, 5800, 5662},
  {5772, 5741, 5702},
  {5702, 5745, 5772},
  {5775, 5774, 5662},
  {5703, 5774, 5778},
  {5703, 5778, 5804},
  {5704, 5780, 5803},
  {5803, 5780, 5670},
  {5803, 5670, 5776},
  {5670, 5630, 5776},
  {5703, 5804, 5632},
  {5632, 5804, 5805},
  {5632, 5805, 5748},
  {5709, 5669, 5750},
  {5708, 5636, 5782},
  {5708, 5782, 5820},
  {5637, 5748, 5749},
  {5915, 5750, 5669},
  {5636, 5807, 5782},
  {5751, 5749, 5781},
  {5749, 5751, 5710},
  {5671, 5806, 5747},
  {5751, 5785, 5710},
  {5671, 5674, 5806},
  {5711, 5808, 5673},
  {5786, 5710, 5785},
  {5808, 5711, 5753},
  {5712, 5752, 5806},
  {5712, 5806, 5790},
  {5713, 5810, 5754},
  {5755, 5813, 5643},
  {5756, 5677, 5678},
  {5756, 5678, 5815},
  {5678, 5758, 5815},
  {5719, 5718, 5761},
  {5721, 5722, 5760},
  {5721, 5760, 5759},
  {5721, 5759, 5723},
  {5718, 5726, 5761},
  {5726, 5655, 5761},
  {5727, 5762, 5656},
  {5728, 5828, 5729},
  {5797, 5798, 5659},
  {5767, 5765, 5733},
  {5732, 5731, 5766},
  {5768, 5763, 5765},
  {5797, 5735, 5769},
  {5764, 5772, 5734},
  {5738, 5700, 5768},
  {5770, 5699, 5740},
  {5735, 5741, 5769},
  {5737, 5739, 5771},
  {5819, 5771, 5739},
  {5701, 5770, 5740},
  {5740, 5743, 5701},
  {5741, 5772, 5769},
  {5772, 5819, 5739},
  {5800, 5773, 5662},
  {5662, 5773, 5775},
  {5740, 5744, 5743},
  {5740, 5742, 5744},
  {5777, 5772, 5745},
  {5801, 5772, 5777},
  {5772, 5801, 5819},
  {5775, 5802, 5774},
  {5742, 5803, 5776},
  {5776, 5744, 5742},
  {5780, 5916, 5670},
  {5749, 5748, 5781},
  {5781, 5748, 5848},
  {5805, 5848, 5748},
  {5806, 5779, 5747},
  {5672, 5806, 5752},
  {5781, 5783, 5751},
  {5673, 5808, 5807},
  {5783, 5784, 5838},
  {5783, 5838, 5751},
  {5787, 5784, 5836},
  {5785, 5751, 5838},
  {5806, 5674, 5786},
  {5713, 5714, 5810},
  {5753, 5643, 5821},
  {5643, 5813, 5821},
  {5787, 5811, 5788},
  {5754, 5810, 5789},
  {5811, 5791, 5788},
  {5758, 5757, 5792},
  {5813, 5755, 5793},
  {5755, 5756, 5793},
  {5756, 5815, 5793},
  {5794, 5795, 5715},
  {5795, 5716, 5796},
  {5795, 5796, 5715},
  {5715, 5796, 5720},
  {5716, 5719, 5796},
  {5796, 5719, 5725},
  {5796, 5725, 5720},
  {5827, 5759, 5826},
  {5719, 5761, 5725},
  {5826, 5759, 5760},
  {5826, 5760, 5762},
  {5728, 5759, 5816},
  {5759, 5728, 5723},
  {5818, 5764, 5729},
  {5694, 5763, 5732},
  {5694, 5732, 5692},
  {5692, 5732, 5766},
  {5765, 5767, 5768},
  {5738, 5768, 5767},
  {5798, 5799, 5764},
  {5772, 5764, 5799},
  {5737, 5771, 5767},
  {5841, 5767, 5771},
  {5772, 5799, 5769},
  {5771, 5819, 5841},
  {5774, 5802, 5778},
  {5746, 5844, 5801},
  {5746, 5801, 5777},
  {5846, 5844, 5746},
  {5778, 5802, 5845},
  {5746, 5707, 5846},
  {5708, 5846, 5707},
  {5778, 5845, 5804},
  {5779, 5806, 5780},
  {5916, 5780, 5806},
  {5782, 5807, 5834},
  {5781, 5835, 5783},
  {5784, 5783, 5836},
  {5857, 5808, 5753},
  {5809, 5857, 5753},
  {5836, 5837, 5787},
  {5785, 5838, 5786},
  {5786, 5839, 5806},
  {5821, 5809, 5753},
  {5839, 5810, 5714},
  {5806, 5839, 5790},
  {5714, 5790, 5839},
  {5811, 5812, 5791},
  {5813, 5793, 5812},
  {5812, 5793, 5815},
  {5812, 5840, 5791},
  {5815, 5758, 5814},
  {5827, 5816, 5759},
  {5826, 5762, 5817},
  {5762, 5828, 5817},
  {5816, 5828, 5728},
  {5762, 5818, 5828},
  {5762, 5764, 5818},
  {5797, 5769, 5799},
  {5797, 5799, 5798},
  {5767, 5841, 5738},
  {5738, 5841, 5800},
  {5829, 5800, 5841},
  {5800, 5829, 5773},
  {5775, 5773, 5829},
  {5801, 5830, 5819},
  {5832, 5802, 5775},
  {5845, 5802, 5832},
  {5708, 5820, 5846},
  {5836, 5783, 5835},
  {5839, 5786, 5838},
  {5811, 5787, 5837},
  {5812, 5822, 5821},
  {5822, 5812, 5811},
  {5821, 5813, 5812},
  {5840, 5812, 5823},
  {5824, 5825, 5758},
  {5758, 5825, 5814},
  {5758, 5792, 5824},
  {5815, 5814, 5825},
  {5826, 5817, 5827},
  {5816, 5827, 5817},
  {5817, 5828, 5816},
  {5828, 5818, 5729},
  {5842, 5841, 5819},
  {5830, 5842, 5819},
  {5831, 5775, 5829},
  {5831, 5832, 5775},
  {5853, 5801, 5844},
  {5801, 5853, 5830},
  {5860, 5846, 5820},
  {5804, 5845, 5805},
  {5834, 5820, 5782},
  {5833, 5848, 5805},
  {5835, 5781, 5848},
  {5856, 5807, 5808},
  {5856, 5834, 5807},
  {5857, 5856, 5808},
  {5809, 5849, 5857},
  {5822, 5809, 5821},
  {5809, 5822, 5849},
  {5822, 5811, 5849},
  {5837, 5849, 5811},
  {5839, 5850, 5810},
  {5823, 5825, 5840},
  {5824, 5840, 5825},
  {5829, 5841, 5843},
  {5831, 5829, 5843},
  {5831, 5843, 5830},
  {5831, 5830, 5832},
  {5846, 5860, 5861},
  {5833, 5805, 5845},
  {5833, 5845, 5855},
  {5833, 5855, 5848},
  {5820, 5834, 5847},
  {5820, 5847, 5860},
  {5848, 5860, 5835},
  {5837, 5836, 5857},
  {5849, 5837, 5857},
  {5841, 5842, 5852},
  {5851, 5843, 5841},
  {5852, 5843, 5851},
  {5842, 5830, 5843},
  {5842, 5843, 5852},
  {5854, 5832, 5830},
  {5832, 5854, 5845},
  {5861, 5848, 5855},
  {5860, 5848, 5861},
  {5847, 5834, 5835},
  {5847, 5835, 5860},
  {5836, 5834, 5856},
  {5834, 5836, 5835},
  {5841, 5852, 5851},
  {5854, 5830, 5853},
  {5853, 5844, 5854},
  {5844, 5858, 5854},
  {5845, 5854, 5858},
  {5858, 5859, 5845},
  {5845, 5859, 5855},
  {5861, 5855, 5859},
  {5846, 5858, 5844},
  {5859, 5858, 5846},
  {5846, 5861, 5859},
  {  20,    1, 5862},
  {5862,   19,   35},
  {5862,   35,   20},
  {5863, 5865,   33},
  {5863,  103, 5865},
  {  19,   33, 5864},
  {  19, 5864,   35},
  {  33,   19,   50},
  {5864, 5865,   78},
  {  78, 5865,  102},
  {5866,   22,   57},
  {5866,   57,   80},
  {5863, 5866,  103},
  {  22,   37,   23},
  {  22,   36,   37},
  {  21, 5866,   52},
  {  57,   22,   23},
  {   1,   20,    8},
  {5863,   52, 5866},
  {  93,   29,   27},
  {  93,   27,   45},
  {  93,   65,   63},
  {  93,   45,   65},
  {  27,   49,   45},
  {  27,   12,   49},
  {5868,  200, 5867},
  {5868,  169,  200},
  {5868,  136,  169},
  { 136,  232, 5869},
  {5870, 5871,  269},
  {5870,  269,  201},
  {5870,  235, 5871},
  {5869,  201,  169},
  {5867,  107,  133},
  {5871,  207,  208},
  { 109,  143, 5872},
  { 109, 5872,  214},
  { 109,  214,   84},
  {5872,  288,  214},
  { 288,  289,  214},
  {5872,  246,  288},
  { 288,  389,  289},
  { 214,  289,  318},
  { 288,  246,  317},
  { 288,  353,  389},
  {5873,  258,  333},
  {5873,  333,  298},
  {5873,  298,  262},
  {5873,  262,  258},
  { 198,  265,  260},
  { 198,  260, 5874},
  {5875,  331, 5874},
  {5874,  260,  337},
  {5874,  337, 5875},
  {5875, 5876,  331},
  {5877,  331, 5876},
  { 331,  436,  330},
  { 210,  279,  237},
  { 210,  209,  280},
  { 375,  344,  308},
  { 308,  309,  375},
  {5879,  413,  487},
  {5879,  457,  413},
  { 487,  413,  483},
  { 457, 5879,  559},
  { 417, 5879,  492},
  { 487,  492, 5879},
  { 486,  629, 5917},
  {5917,  664,  486},
  { 773,  668,  589},
  { 773, 5917,  668},
  { 522,  486,  664},
  { 552,  554,  624},
  { 552,  698,  554},
  {5880, 5881,  662},
  {5880,  449, 5881},
  { 448, 5881,  449},
  {5880,  626,  449},
  { 626, 5880,  625},
  {5881, 5882,  662},
  { 659, 5880,  702},
  {5882, 5881,  628},
  {5882,  628,  662},
  {5880,  662,  702},
  { 449,  626,  520},
  { 602, 5883,  679},
  { 615,  654,  695},
  { 615,  653,  654},
  { 615,  695,  619},
  { 615,  692,  653},
  { 755,  967,  966},
  { 755,  996,  967},
  { 755,  754,  845},
  { 845,  754,  968},
  { 845,  968,  996},
  { 755,  966, 1038},
  {1080, 1037, 5884},
  {5884, 1039,  846},
  { 846, 1039, 1040},
  {1356, 1433, 1316},
  {1316, 1433, 1540},
  {1316, 1540, 1434},
  {1433, 1356, 1315},
  {1316, 1434, 1390},
  {5885, 1414, 1643},
  {1643, 1414, 1451},
  {1609, 1677, 5886},
  {1609, 5886, 1566},
  {1677, 1609, 5885},
  {1608, 5886, 1642},
  {1566, 5886, 1608},
  {5886, 1678, 1642},
  {5887, 1419, 1449},
  {1553, 1765, 1513},
  {1693, 1765, 1820},
  {2174, 2116, 2071},
  {2116, 2017, 2071},
  {2116, 2117, 2017},
  {2231, 2407, 2469},
  {2231, 2469, 2408},
  {2231, 2408, 2101},
  {2449, 2619, 5889},
  {2384, 2449, 5889},
  {5889, 2658, 2659},
  {5889, 2707, 2658},
  {2211, 5891, 2210},
  {2211, 5890, 5891},
  {5891, 5890, 2522},
  {5890, 2571, 2522},
  {2209, 2571, 5890},
  {2209, 5890, 2211},
  {2522, 2626, 2716},
  {2626, 2522, 2463},
  {2716, 2627, 2522},
  {2627, 2757, 2804},
  {2501, 2606, 2497},
  {5893, 2822, 2820},
  {2840, 2976, 2841},
  {2976, 2840, 3030},
  {5894, 3079, 3026},
  {5894, 3030, 3079},
  {5894, 3026, 3027},
  {3030, 3028, 2976},
  {3030, 5894, 3028},
  {3028, 3080, 2976},
  {3288, 3289, 3348},
  {3245, 3247, 3302},
  {3247, 3362, 3302},
  {3247, 5895, 3362},
  {5896, 3362, 5897},
  {5896, 3476, 3572},
  {5896, 5897, 3476},
  {3701, 3700, 3656},
  {3440, 3701, 3594},
  {3749, 3700, 3699},
  {3749, 3656, 3700},
  {3699, 3802, 3749},
  {5898, 3559, 3619},
  {3559, 3563, 3619},
  {5898, 3619, 3616},
  {5898, 3616, 3559},
  {3559, 3561, 3563},
  {5900, 5901, 5899},
  {5900, 3818, 5901},
  {5899, 3970, 4065},
  {5899, 5901, 3970},
  {3970, 5901, 3911},
  {4025, 3818, 5900},
  {3818, 3867, 5902},
  {5900, 5899, 4025},
  {3818, 5902, 5901},
  {5903, 5901, 5902},
  {5903, 5902, 4121},
  {5903, 4121, 5901},
  {3970, 3911, 4065},
  {4196, 4198, 4292},
  {4292, 4427, 4196},
  {4317, 4179, 4180},
  {4317, 4414, 4179},
  {4179, 4414, 4369},
  {4042, 4043, 4179},
  {4197, 4332, 4291},
  {5904, 4504, 4266},
  {5904, 4408, 4504},
  {4408, 4405, 4504},
  {5904, 4267, 4357},
  {4266, 4504, 4264},
  {5904, 4357, 4361},
  {4441, 5905, 4347},
  {5905, 4441, 4257},
  {5905, 4257, 5906},
  {5906, 4257, 5907},
  {4445, 4398, 4494},
  {4445, 4257, 4398},
  {4257, 4445, 4497},
  {4495, 4545, 4546},
  {5905, 5906, 4347},
  {4847, 4879, 4747},
  {4747, 4879, 4693},
  {4747, 4693, 4746},
  {4747, 4909, 4847},
  {4747, 4785, 4909},
  {4785, 4786, 4909},
  {5079, 5175, 5241},
  {5241, 5208, 5109},
  {5908, 5084, 5085},
  {5908, 4968, 5084},
  {5358, 5327, 5330},
  {5327, 5358, 5422},
  {5475, 5477, 5911},
  {5475, 5910, 5474},
  {5475, 5911, 5910},
  {5910, 5911, 5473},
  {5910, 5473, 5909},
  {5909, 5474, 5910},
  {5909, 5509, 5474},
  {5911, 5912, 5473},
  {5911, 5477, 5912},
  {5509, 5437, 5470},
  {5509, 5470, 5510},
  {5610, 5611, 5912},
  {5658, 5913, 5552},
  {5658, 5552, 5600},
  {5913, 5551, 5696},
  {5913, 5696, 5525},
  {5913, 5525, 5552},
  {5696, 5551, 5663},
  {5525, 5696, 5699},
  {5652, 5650, 5588},
  {5588, 5611, 5652},
  {5715, 5914, 5590},
  {5590, 5795, 5794},
  {5590, 5794, 5715},
  {5598, 5616, 5600},
  {5717, 5681, 5684},
  {5915, 5634, 5916},
  {5916, 5639, 5915},
  {5916, 5806, 5672},
  {5916, 5672, 5639},
  {5915, 5639, 5750},
  {5784, 5788, 5850},
  {5784, 5850, 5838},
  {5850, 5788, 5789},
  {5788, 5791, 5789},
  {5789, 5791, 5754},
  {5788, 5784, 5787},
  {5754, 5791, 5792},
  {5789, 5810, 5850},
  {5792, 5791, 5824},
  {5792, 5757, 5754},
  {5815, 5823, 5812},
  {5823, 5815, 5825},
  {5839, 5838, 5850},
  {5836, 5856, 5857},
  {   1,    6, 5862},
  {5866,   21,   22},
  {  37,   57,   23},
  {5864,   78,   35},
  {5868, 5867,  136},
  {5870,  201, 5869},
  { 279,  210,  280},
  {5869,  232, 5870},
  { 755,  845,  996},
  { 996,  968, 1039},
  {1449, 1529, 5885},
  {5887, 1449, 5885},
  {1414, 5885, 1529},
  {1693, 1513, 1765},
  {2449, 2388, 2619},
  {3440, 3594, 3541},
  {4025, 3864, 3818},
  {4069, 4070, 4121},
  {4494, 4545, 4495},
  {4445, 4494, 4495},
  {5680, 5649, 5650},
  {5651, 5649, 5680},
  {5680, 5652, 5651},
  {5791, 5840, 5824},
  {5865, 5864,   33},
  { 169,  136, 5869},
  {5877,  436,  331},
  {5895, 5897, 3362},
  {5079, 5241, 5109},
  {5909, 5437, 5509},
};

SVV_NAMESPACE_BEGIN

svvModel inflatedsurf( "inflatedsurf",
                       inflatedsurf_vertices, inflatedsurf_nvertices,
                       inflatedsurf_indices, inflatedsurf_nindices );

SVV_NAMESPACE_END

#endif /* SVV_INFLATEDSURF_H_ */
/*
 * End of: $Id: inflatedsurf.h,v 1.1.1.1 2006/12/19 22:58:53 christianh Exp $.
 * 
 */
