/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: smoothwmsurf.h,v 1.1.1.1 2006/12/19 22:59:19 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_SMOOTHWMSURF_H_
#  define SVV_SMOOTHWMSURF_H_
#  include "svvModel.h"

static GLsizei smoothwmsurf_nvertices = 6484;
static GLsizei smoothwmsurf_nindices  = 11831;
static GLsizei smoothwmsurf_nedges    = 47324;

static GLfloat smoothwmsurf_vertices[][6] =
{
  { 1.394190e-01, -9.890297e-01,  4.881135e-02,  2.310548e-01, -1.382089e+00, -4.173841e-01},
  {-7.187851e-01, -5.637421e-01, -4.068697e-01,  2.176652e-01, -1.381689e+00, -4.354982e-01},
  {-4.805324e-01, -8.758897e-01, -4.365560e-02,  1.998457e-01, -1.371890e+00, -3.835896e-01},
  { 4.414181e-01, -8.196000e-01,  3.652476e-01,  2.436650e-01, -1.373890e+00, -4.092557e-01},
  { 4.414181e-01, -8.196000e-01,  3.652476e-01,  6.119835e-02, -1.372040e+00, -4.311025e-01},
  { 4.414181e-01, -8.196000e-01,  3.652476e-01,  6.223324e-02, -1.372242e+00, -4.340994e-01},
  { 4.000004e-01, -7.515810e-01,  5.245242e-01,  1.015542e-01, -1.364405e+00, -4.501052e-01},
  { 4.888199e-01, -8.367777e-01, -2.466944e-01,  2.575132e-01, -1.373652e+00, -4.532970e-01},
  { 3.471428e-01, -9.311788e-01, -1.113462e-01,  1.078808e-01, -1.364302e+00, -4.680815e-01},
  {-3.463537e-01, -9.185917e-01, -1.903372e-01,  7.510856e-02, -1.367927e+00, -4.617429e-01},
  {-5.550814e-02, -9.740316e-01, -2.195023e-01,  9.790312e-02, -1.358558e+00, -4.946068e-01},
  {-8.287648e-02, -3.168876e-01,  9.448353e-01,  5.685772e-02, -1.361371e+00, -4.252728e-01},
  { 8.488528e-01, -4.418695e-01, -2.901729e-01,  2.704368e-01, -1.359149e+00, -4.482173e-01},
  {-6.922051e-01, -4.307435e-01, -5.790614e-01,  2.220802e-01, -1.352264e+00, -4.574697e-01},
  { 7.517017e-01, -2.816865e-01, -5.963198e-01,  1.126778e-01, -1.340662e+00, -5.358819e-01},
  { 4.819416e-01, -3.976715e-01, -7.807623e-01,  1.103689e-01, -1.342813e+00, -5.391579e-01},
  { 3.898572e-01, -7.211123e-01,  5.727202e-01,  1.341270e-01, -1.336079e+00, -2.368462e-01},
  {-2.615239e-01, -9.558002e-01,  1.343552e-01,  1.161911e-01, -1.334651e+00, -2.476722e-01},
  { 3.738833e-01, -7.668303e-01,  5.217113e-01,  1.806887e-01, -1.341108e+00, -2.865125e-01},
  { 1.044180e-01, -3.827169e-01,  9.179459e-01,  2.529948e-02, -1.342251e+00, -4.198231e-01},
  {-1.252822e-01, -9.397046e-01,  3.182133e-01, -2.139948e-02, -1.330652e+00, -4.206551e-01},
  { 1.745920e-01,  1.561990e-01,  9.721726e-01,  5.677385e-02, -1.324668e+00, -4.416437e-01},
  { 4.148798e-01, -3.635591e-01, -8.340861e-01,  2.642303e-01, -1.343775e+00, -4.770172e-01},
  {-2.600824e-01, -6.464705e-01, -7.172400e-01,  2.685621e-02, -1.331735e+00, -5.358288e-01},
  {-5.319780e-02, -4.494746e-01, -8.917076e-01,  6.538318e-02, -1.336800e+00, -5.407158e-01},
  {-2.528164e-01, -9.618295e-01,  1.047279e-01,  7.443912e-02, -1.307618e+00, -1.652733e-01},
  { 2.151774e-01, -8.081901e-01,  5.482038e-01,  2.761076e-01, -1.309942e+00, -2.122923e-01},
  {-3.633395e-01, -8.653733e-01,  3.451281e-01,  2.532778e-01, -1.310606e+00, -2.116813e-01},
  { 6.233470e-01, -7.173613e-01,  3.111773e-01,  2.933626e-01, -1.313004e+00, -2.362217e-01},
  {-1.839925e-03, -9.993300e-01,  3.655279e-02,  2.751624e-01, -1.316640e+00, -2.426084e-01},
  {-6.656184e-01, -7.462921e-01,  3.073044e-04,  9.309940e-02, -1.320755e+00, -2.487890e-01},
  { 4.550550e-01, -4.799339e-01,  7.500590e-01, -3.453608e-02, -1.318148e+00, -3.996333e-01},
  {-8.937131e-01, -2.844779e-01, -3.469141e-01,  2.027246e-01, -1.319140e+00, -4.094450e-01},
  {-9.214591e-01, -3.646354e-01, -1.339928e-01,  2.144686e-01, -1.331029e+00, -4.310759e-01},
  { 4.048808e-01, -3.555062e-01,  8.424292e-01,  1.164485e-01, -1.315127e+00, -4.345049e-01},
  {-5.939396e-01, -7.079441e-01, -3.821661e-01, -2.541189e-02, -1.317150e+00, -4.742919e-01},
  {-6.872882e-01, -6.540547e-01, -3.159863e-01, -3.901014e-03, -1.316933e+00, -5.219070e-01},
  { 3.400143e-01,  2.929102e-01, -8.936408e-01,  1.013021e-01, -1.322292e+00, -5.358403e-01},
  { 1.086533e-01,  5.664527e-02, -9.924645e-01,  5.714703e-02, -1.317227e+00, -5.422813e-01},
  {-7.188930e-02, -9.648068e-01,  2.529422e-01,  1.091532e-01, -1.296860e+00, -9.326416e-02},
  {-5.272353e-01, -2.120442e-01,  8.228367e-01,  1.108295e-01, -1.290892e+00, -8.522866e-02},
  {-5.796742e-01, -8.138230e-01,  4.086501e-02,  6.529467e-02, -1.301613e+00, -1.540927e-01},
  { 3.859704e-01, -5.519615e-01,  7.391653e-01,  2.721229e-01, -1.289531e+00, -1.939064e-01},
  {-2.512982e-01, -4.944473e-01,  8.320884e-01,  2.555975e-01, -1.299095e+00, -2.012420e-01},
  {-4.667359e-01, -8.699404e-01,  1.592522e-01,  2.494967e-01, -1.307073e+00, -2.328535e-01},
  { 5.005853e-01, -8.630795e-01,  6.714159e-02,  3.069763e-01, -1.304181e+00, -2.758169e-01},
  {-7.462205e-01, -3.390443e-01, -5.728909e-01,  9.068955e-02, -1.300327e+00, -2.895257e-01},
  { 5.211464e-02, -9.273008e-01,  3.706715e-01,  2.561483e-01, -1.316508e+00, -3.204756e-01},
  {-7.383834e-01,  6.570828e-02, -6.711723e-01,  1.342900e-01, -1.295479e+00, -3.286079e-01},
  { 2.330458e-01, -1.832472e-01,  9.550446e-01, -5.440746e-02, -1.305284e+00, -3.837295e-01},
  { 4.548504e-01,  4.768385e-01,  7.521543e-01, -4.547220e-02, -1.298024e+00, -3.916922e-01},
  { 6.968889e-02,  6.432063e-01,  7.625149e-01, -7.216730e-02, -1.295872e+00, -3.826444e-01},
  {-4.612611e-01, -4.719901e-01,  7.513079e-01, -9.948670e-02, -1.301701e+00, -3.873634e-01},
  {-1.985272e-01,  3.066874e-01, -9.308758e-01,  1.710960e-01, -1.313642e+00, -4.536733e-01},
  { 5.513188e-01,  7.361240e-02, -8.310409e-01,  2.793128e-01, -1.298034e+00, -4.694072e-01},
  { 9.656627e-02,  4.530891e-01, -8.862196e-01,  2.581710e-01, -1.292354e+00, -4.736013e-01},
  { 1.867278e-01, -1.883251e-01, -9.641922e-01,  3.097854e-02, -1.301033e+00, -5.473449e-01},
  {-3.725050e-01, -3.235571e-01, -8.697993e-01,  2.335676e-03, -1.299714e+00, -5.467460e-01},
  { 1.534835e-01, -8.726082e-01,  4.636784e-01,  2.127400e-01, -1.276281e+00, -6.547136e-02},
  {-7.526688e-02, -3.883347e-01,  9.184395e-01,  1.471216e-01, -1.287432e+00, -7.454149e-02},
  { 4.043596e-01, -8.951359e-01, -1.876832e-01,  1.996123e-01, -1.280393e+00, -8.567863e-02},
  { 2.017122e-01, -5.649966e-01,  8.000569e-01,  3.062254e-01, -1.278095e+00, -1.708040e-01},
  { 5.861654e-01, -7.265586e-01, -3.585005e-01,  3.101628e-01, -1.276080e+00, -1.789686e-01},
  { 8.352342e-01, -4.980522e-01, -2.330835e-01,  3.429078e-01, -1.280100e+00, -3.593391e-01},
  { 5.480094e-01, -6.790984e-01, -4.883760e-01,  3.328955e-01, -1.282748e+00, -3.685035e-01},
  {-8.650648e-01, -2.107896e-01, -4.552259e-01,  1.691615e-01, -1.275626e+00, -3.719296e-01},
  {-6.263352e-01, -6.337849e-01,  4.538952e-01, -1.245339e-01, -1.279579e+00, -4.004216e-01},
  {-6.093996e-02, -3.745283e-01,  9.252107e-01,  1.098587e-01, -1.282614e+00, -4.181516e-01},
  { 8.690171e-01,  2.331677e-01, -4.363968e-01,  2.871056e-01, -1.293829e+00, -4.609678e-01},
  {-4.816100e-01, -8.647055e-01, -1.426049e-01, -1.240008e-01, -1.279727e+00, -5.169714e-01},
  { 2.006510e-01, -2.715068e-01, -9.412881e-01,  3.334430e-02, -1.284945e+00, -5.511716e-01},
  {-6.715325e-01, -2.598091e-01, -6.939332e-01, -1.535822e-03, -1.284598e+00, -5.465131e-01},
  { 8.443444e-02, -9.328545e-01, -3.502190e-01, -1.030112e-01, -1.278805e+00, -5.555492e-01},
  { 5.194468e-01, -7.365834e-01, -4.331510e-01, -9.888602e-02, -1.274144e+00, -5.587308e-01},
  {-6.776390e-01, -5.262843e-01, -5.136442e-01, -1.168198e-01, -1.268753e+00, -5.605589e-01},
  { 7.594018e-03, -8.962607e-01,  4.434626e-01,  8.481980e-02, -1.266497e+00, -6.482508e-01},
  { 6.919681e-02, -9.267542e-01,  3.692405e-01,  7.945254e-02, -1.261745e+00, -6.371762e-01},
  { 3.492694e-02, -9.992501e-01, -1.671213e-02,  9.857859e-02, -1.268000e+00, -6.555480e-01},
  {-2.282527e-01, -4.150388e-01, -8.807063e-01,  1.179414e-01, -1.267022e+00, -6.701595e-01},
  { 7.852797e-01, -6.190668e-01,  9.600667e-03,  1.210133e-01, -1.262469e+00, -6.707292e-01},
  { 5.054801e-01, -8.516053e-01,  1.387744e-01,  2.756121e-01, -1.254632e+00, -4.054268e-02},
  { 5.712988e-01, -6.254636e-01, -5.314254e-01,  2.487856e-01, -1.264563e+00, -6.834869e-02},
  {-5.386440e-01,  3.067240e-01,  7.847185e-01,  1.090286e-01, -1.273225e+00, -8.780985e-02},
  {-3.432866e-01,  3.542981e-01,  8.698431e-01,  6.530784e-02, -1.267971e+00, -1.086973e-01},
  {-5.542433e-01, -4.404880e-01,  7.062469e-01,  3.410789e-02, -1.268697e+00, -1.266550e-01},
  { 5.546117e-01, -3.013808e-01,  7.756130e-01,  3.222025e-01, -1.257193e+00, -1.726819e-01},
  {-2.792066e-01, -9.016497e-01,  3.302599e-01, -5.212062e-02, -1.257488e+00, -2.468685e-01},
  { 9.435866e-01,  2.907837e-01, -1.583951e-01,  3.432868e-01, -1.270778e+00, -2.937214e-01},
  { 2.100343e-01, -6.049272e-01,  7.680811e-01,  1.794164e-01, -1.283923e+00, -2.633687e-01},
  {-8.963400e-01, -3.579913e-01, -2.615665e-01,  1.803874e-01, -1.278333e+00, -3.942580e-01},
  { 8.510251e-01,  2.533459e-01, -4.599697e-01,  3.136957e-01, -1.271436e+00, -4.056658e-01},
  {-5.251791e-01, -7.004576e-01,  4.832660e-01,  1.784291e-01, -1.280286e+00, -4.186525e-01},
  { 3.316583e-01,  5.393617e-01,  7.740101e-01, -2.344273e-02, -1.267042e+00, -4.268005e-01},
  {-2.321035e-01, -9.284142e-01,  2.901294e-01,  3.056298e-01, -1.279583e+00, -4.329320e-01},
  { 1.138936e-01, -9.486867e-01, -2.949946e-01, -9.816257e-02, -1.275640e+00, -4.490800e-01},
  {-1.335907e-01,  3.066809e-01,  9.423908e-01,  3.964113e-02, -1.256390e+00, -4.685078e-01},
  {-8.600205e-01, -8.595902e-02, -5.029670e-01, -1.617358e-01, -1.253447e+00, -4.837347e-01},
  { 5.343612e-01,  5.953878e-02, -8.431567e-01,  9.945352e-02, -1.263921e+00, -5.056397e-01},
  {-8.562803e-01, -2.948541e-01, -4.240814e-01, -1.317888e-01, -1.265109e+00, -5.345595e-01},
  {-9.552712e-01, -7.809489e-02, -2.852335e-01, -1.343707e-01, -1.261171e+00, -5.315889e-01},
  { 3.412429e-02, -7.291816e-01, -6.834687e-01,  1.773674e-02, -1.262547e+00, -5.661467e-01},
  { 1.865448e-01, -9.392543e-01, -2.881012e-01, -9.995187e-02, -1.262693e+00, -5.906407e-01},
  {-2.934409e-01, -9.522889e-01,  8.389459e-02,  5.934675e-02, -1.253574e+00, -6.232306e-01},
  { 3.936229e-01, -6.556102e-01,  6.443883e-01,  1.068073e-01, -1.259622e+00, -6.478943e-01},
  { 2.774915e-01,  1.230394e-01, -9.528167e-01,  1.251186e-01, -1.250001e+00, -6.762847e-01},
  {-1.855190e-01, -1.749212e-01, -9.669464e-01,  1.000793e-01, -1.251285e+00, -6.729462e-01},
  {-9.588079e-01,  2.510132e-01,  1.329653e-01,  2.943969e-01, -1.240929e+00, -3.106380e-02},
  {-2.617423e-02, -9.868595e-01,  1.594465e-01,  2.936501e-01, -1.241672e+00, -3.504702e-02},
  {-7.896152e-02, -5.084099e-01,  8.574873e-01,  2.964359e-01, -1.234014e+00, -2.941489e-02},
  { 2.220238e-01, -7.599834e-01,  6.108442e-01,  2.819073e-01, -1.244835e+00, -3.431294e-02},
  {-4.435836e-01,  5.409760e-01,  7.145478e-01,  1.042425e-01, -1.253464e+00, -1.065243e-01},
  {-3.194841e-01,  3.877653e-01,  8.646201e-01,  1.995264e-02, -1.246050e+00, -1.328138e-01},
  { 8.222251e-01, -4.992504e-01, -2.733039e-01,  3.403073e-01, -1.236381e+00, -1.894437e-01},
  {-2.917946e-01, -6.471932e-01,  7.042705e-01,  1.863089e-01, -1.249569e+00, -2.311831e-01},
  { 5.660551e-01, -5.806855e-01,  5.851376e-01,  1.566468e-01, -1.256749e+00, -2.368000e-01},
  { 9.263534e-01, -4.328014e-02,  3.741606e-01,  3.406020e-01, -1.255815e+00, -2.795440e-01},
  {-5.729923e-01, -7.859644e-01,  2.322490e-01, -9.848721e-02, -1.239392e+00, -2.756705e-01},
  { 4.531047e-01,  8.342951e-01, -3.140826e-01,  2.605799e-01, -1.246745e+00, -3.054698e-01},
  { 1.961396e-01, -7.889018e-01, -5.823773e-01, -3.386326e-02, -1.236746e+00, -3.013179e-01},
  {-1.855835e-01, -8.782460e-01, -4.407299e-01, -8.054227e-02, -1.238994e+00, -2.982512e-01},
  {-8.161086e-01, -3.589180e-01, -4.529290e-01,  1.428049e-01, -1.252527e+00, -3.409082e-01},
  { 7.149110e-01,  6.077695e-01, -3.457144e-01,  3.414021e-01, -1.264794e+00, -3.625791e-01},
  { 5.862857e-01,  8.089081e-01, -4.400949e-02,  2.649605e-01, -1.253305e+00, -3.764933e-01},
  {-6.700558e-01, -3.677341e-01,  6.448231e-01,  1.290869e-01, -1.246029e+00, -3.990243e-01},
  { 3.911853e-01,  3.110464e-01, -8.661548e-01,  2.358097e-01, -1.248795e+00, -4.461102e-01},
  { 2.529534e-01,  3.053436e-01,  9.180304e-01,  1.552366e-02, -1.242448e+00, -4.658084e-01},
  { 4.500907e-01, -1.215913e-01, -8.846660e-01,  1.188566e-01, -1.241142e+00, -4.922047e-01},
  {-5.065991e-01, -6.353527e-01, -5.828246e-01, -1.222457e-01, -1.238393e+00, -6.228259e-01},
  { 7.215439e-02, -9.577347e-01, -2.784564e-01, -7.395414e-02, -1.242448e+00, -6.512223e-01},
  {-5.393093e-01, -3.719431e-01, -7.555158e-01, -7.323498e-02, -1.229911e+00, -6.699719e-01},
  { 8.991902e-01, -4.341320e-01, -5.464770e-02,  3.060429e-01, -1.224342e+00, -3.617113e-02},
  {-6.738927e-01, -5.040102e-01,  5.402244e-01, -1.775516e-02, -1.234560e+00, -1.508673e-01},
  { 6.235888e-01, -7.756659e-01,  9.736251e-02,  1.522508e-01, -1.248918e+00, -1.982352e-01},
  { 3.339138e-01, -8.585956e-01,  3.889926e-01,  1.635296e-01, -1.243476e+00, -2.227433e-01},
  { 4.890978e-01,  6.194748e-01, -6.140313e-01,  2.595432e-01, -1.231333e+00, -2.802553e-01},
  { 6.965029e-01,  4.311951e-01, -5.735456e-01,  3.224473e-01, -1.236340e+00, -2.768589e-01},
  {-5.499506e-01, -8.316430e-01, -7.696953e-02, -1.360896e-01, -1.222896e+00, -3.044703e-01},
  { 3.215981e-01, -8.779458e-01, -3.546630e-01, -6.140943e-03, -1.215429e+00, -3.343788e-01},
  { 7.294103e-01,  6.750020e-01, -1.110534e-01,  2.411379e-01, -1.233325e+00, -3.990313e-01},
  {-7.850438e-01, -5.369521e-01,  3.088504e-01,  1.108819e-01, -1.221501e+00, -3.978179e-01},
  {-9.525130e-01, -2.805821e-01, -1.182902e-01, -1.833975e-01, -1.229276e+00, -4.605136e-01},
  { 1.853495e-01, -8.942669e-01, -4.073478e-01,  1.520862e-01, -1.230519e+00, -4.849565e-01},
  {-3.284098e-01,  7.803608e-02,  9.413062e-01,  5.160622e-02, -1.222198e+00, -4.759310e-01},
  {-6.012530e-01, -5.619397e-01, -5.680833e-01, -1.414180e-02, -1.238350e+00, -5.413799e-01},
  {-8.289032e-01,  2.837803e-01, -4.820665e-01, -1.251701e-01, -1.234563e+00, -5.395440e-01},
  {-6.745340e-01, -7.291908e-01, -1.152596e-01, -1.396253e-01, -1.223983e+00, -6.206875e-01},
  {-2.369907e-02, -9.882140e-01,  1.512332e-01,  2.338428e-01, -1.220178e+00, -6.575631e-01},
  {-2.871978e-01,  1.919233e-01, -9.384471e-01,  8.312344e-02, -1.218988e+00, -6.552434e-01},
  { 7.414400e-01, -6.631176e-01, -1.026733e-01,  1.338119e-01, -1.224703e+00, -6.559408e-01},
  { 4.177249e-01, -8.643014e-01, -2.801588e-01,  2.373844e-01, -1.219144e+00, -6.817595e-01},
  {-4.826666e-01, -6.609995e-01, -5.745543e-01, -5.472739e-02, -1.227549e+00, -6.893577e-01},
  { 3.112697e-01, -7.950725e-01, -5.205487e-01,  1.350365e-01, -1.221420e+00, -6.887629e-01},
  { 4.193205e-02, -9.442915e-01, -3.264282e-01,  1.039850e-02, -1.217389e+00, -7.745111e-01},
  { 2.624839e-01, -8.175545e-01, -5.125494e-01,  4.086072e-02, -1.214508e+00, -7.789316e-01},
  { 6.556640e-01, -6.881163e-02,  7.519107e-01,  3.102485e-01, -1.206113e+00, -1.305552e-02},
  { 3.491419e-01, -8.565766e-01,  3.799689e-01,  2.195074e-01, -1.216733e+00, -1.760001e-01},
  { 8.247944e-01, -1.528587e-01, -5.443789e-01,  3.481168e-01, -1.211132e+00, -2.187694e-01},
  {-3.594710e-01, -7.412310e-01, -5.668837e-01,  3.661598e-02, -1.216154e+00, -2.567858e-01},
  { 5.098655e-01,  5.713813e-01, -6.430868e-01,  2.380406e-01, -1.210493e+00, -2.727755e-01},
  {-5.143821e-01, -8.645446e-03,  8.575175e-01, -9.509478e-02, -1.215672e+00, -2.654126e-01},
  { 7.497871e-01,  6.383188e-01, -1.742657e-01,  2.192416e-01, -1.206558e+00, -3.111775e-01},
  {-6.857023e-01, -2.498286e-01,  6.836651e-01, -1.458644e-01, -1.205636e+00, -3.037526e-01},
  {-7.499148e-01, -3.164594e-01, -5.809313e-01,  1.134563e-01, -1.215443e+00, -3.223879e-01},
  {-5.778712e-01, -7.477378e-01, -3.270368e-01, -1.578466e-01, -1.199853e+00, -3.223172e-01},
  {-1.543995e-01, -6.579565e-01, -7.370577e-01, -1.096153e-01, -1.207299e+00, -3.269457e-01},
  {-8.405520e-01, -5.389389e-01,  5.492766e-02,  1.273300e-01, -1.216974e+00, -3.603266e-01},
  {-7.223134e-01, -6.777179e-01,  1.377017e-01,  1.429076e-01, -1.236941e+00, -3.785232e-01},
  {-8.848094e-01,  3.392118e-01, -3.194492e-01, -1.836227e-01, -1.211977e+00, -4.489260e-01},
  { 4.766064e-01, -6.701618e-01, -5.689725e-01,  1.225190e-01, -1.217656e+00, -5.029308e-01},
  { 3.455103e-01, -8.697887e-01, -3.522645e-01,  8.867454e-02, -1.218048e+00, -5.406682e-01},
  { 5.111606e-01, -8.546976e-01, -9.059135e-02, -4.612908e-02, -1.220382e+00, -5.893476e-01},
  {-6.588667e-01, -7.319880e-01,  1.734597e-01, -1.673862e-01, -1.203814e+00, -5.993803e-01},
  {-7.910079e-02, -9.839643e-01, -1.598668e-01,  2.085934e-01, -1.200225e+00, -6.092244e-01},
  { 4.051735e-01, -7.880170e-01,  4.635339e-01,  1.309857e-01, -1.215217e+00, -6.338307e-01},
  {-8.409998e-01, -3.535970e-01, -4.094978e-01, -1.540537e-01, -1.214288e+00, -6.190372e-01},
  {-4.411244e-01,  4.988081e-01, -7.460561e-01,  8.435459e-02, -1.198880e+00, -6.425273e-01},
  { 9.323379e-01,  2.499447e-01, -2.612925e-01,  5.255690e-02, -1.212972e+00, -6.922198e-01},
  { 5.235398e-01, -7.194943e-01, -4.563267e-01,  1.396847e-01, -1.208484e+00, -6.947532e-01},
  { 2.711729e-01, -6.429791e-01, -7.162702e-01,  2.298761e-01, -1.204221e+00, -7.088817e-01},
  { 9.961313e-01, -8.615097e-02,  1.733191e-02,  4.779761e-02, -1.205580e+00, -7.493725e-01},
  { 8.943997e-01, -4.432740e-01, -5.964360e-02,  4.341383e-02, -1.213161e+00, -7.648953e-01},
  {-7.254610e-02, -9.860416e-01, -1.498631e-01, -1.349250e-02, -1.215017e+00, -7.492694e-01},
  {-8.093268e-01,  3.000390e-01,  5.049423e-01,  9.430559e-03, -1.210849e+00, -7.799487e-01},
  { 4.265935e-01,  7.033628e-02, -9.017044e-01,  3.281102e-02, -1.202322e+00, -7.852873e-01},
  { 6.844745e-01, -1.594140e-03,  7.290351e-01,  3.124714e-01, -1.190974e+00, -1.325883e-02},
  {-1.329522e-02, -5.956052e-01, -8.031673e-01,  2.008351e-01, -1.189775e+00, -5.321260e-04},
  { 1.329522e-02,  5.956053e-01,  8.031673e-01,  1.851995e-01, -1.191134e+00,  7.344828e-04},
  {-2.774326e-01, -9.066415e-01,  3.178554e-01,  1.614173e-01, -1.188887e+00, -5.383070e-04},
  {-3.813597e-01, -7.461535e-01,  5.457287e-01,  1.383272e-01, -1.178893e+00, -8.343937e-03},
  {-3.278033e-01, -6.339763e-01,  7.004421e-01,  1.177266e-03, -1.176969e+00, -2.986441e-02},
  {-9.306316e-01, -8.676342e-02,  3.555233e-01,  2.343903e-01, -1.197290e+00, -7.047115e-02},
  {-7.537200e-01,  2.792051e-01,  5.949375e-01,  2.200281e-01, -1.194462e+00, -9.184723e-02},
  { 6.649269e-01, -6.703733e-01, -3.293505e-01,  2.540004e-01, -1.185338e+00, -1.431596e-01},
  {-1.421655e-01, -3.167390e-01,  9.377981e-01,  2.771144e-01, -1.201567e+00, -1.852229e-01},
  { 9.750049e-01, -2.101055e-01, -7.225598e-02,  3.587905e-01, -1.186807e+00, -2.190551e-01},
  { 2.894928e-01, -3.344962e-01, -8.968312e-01,  3.468527e-01, -1.182582e+00, -2.341075e-01},
  { 4.105975e-01, -6.291677e-01, -6.599679e-01,  1.763789e-02, -1.206442e+00, -2.684292e-01},
  {-4.389703e-01, -8.498431e-01, -2.916707e-01, -1.741708e-01, -1.187755e+00, -3.274140e-01},
  {-5.448174e-01, -7.564451e-01, -3.618905e-01, -1.795690e-01, -1.183256e+00, -3.353090e-01},
  {-2.594200e-01, -5.359629e-01, -8.033958e-01, -1.370925e-02, -1.195467e+00, -3.518871e-01},
  {-7.867873e-01, -5.970110e-01,  1.566636e-01,  9.576770e-02, -1.190999e+00, -4.195461e-01},
  {-8.313574e-01,  5.255148e-01,  1.807742e-01, -9.464426e-02, -1.187060e+00, -5.271693e-01},
  {-9.418138e-01,  2.414182e-01,  2.338891e-01, -1.003727e-01, -1.192341e+00, -5.304026e-01},
  { 3.562569e-01, -9.227280e-01,  1.471527e-01,  8.832718e-02, -1.211773e+00, -5.664461e-01},
  { 2.185338e-01, -9.169605e-01, -3.338061e-01, -3.008842e-02, -1.216646e+00, -5.699697e-01},
  {-2.788606e-01, -9.010063e-01, -3.323018e-01, -1.677266e-02, -1.209241e+00, -5.920833e-01},
  { 2.759915e-01, -9.574783e-01, -8.404773e-02, -2.693821e-02, -1.207013e+00, -5.994350e-01},
  {-1.932620e-01, -9.778126e-01,  8.082378e-02,  1.283801e-01, -1.203670e+00, -6.010869e-01},
  { 3.518764e-02, -9.986911e-01, -3.711756e-02,  1.882092e-01, -1.198166e+00, -6.424849e-01},
  { 7.510483e-02, -9.899614e-01,  1.197316e-01, -9.293240e-03, -1.210013e+00, -6.350799e-01},
  {-2.709998e-01, -9.267032e-01, -2.603465e-01, -1.343978e-02, -1.214086e+00, -6.558198e-01},
  { 8.550254e-01,  4.412074e-01, -2.725210e-01,  4.741570e-02, -1.195126e+00, -6.695002e-01},
  { 7.066229e-01, -2.704232e-01, -6.538771e-01,  2.356583e-01, -1.191491e+00, -7.110334e-01},
  {-6.930386e-02, -9.953564e-01,  6.680267e-02,  8.763192e-02, -1.172846e+00, -2.272643e-02},
  { 2.067380e-02, -2.192978e-01,  9.754390e-01,  7.157219e-02, -1.161861e+00, -9.648569e-03},
  {-5.259804e-01, -7.403895e-01, -4.185308e-01, -7.307291e-03, -1.169204e+00, -3.943757e-02},
  {-8.101817e-01,  1.645213e-01,  5.626173e-01,  1.955406e-01, -1.175351e+00, -1.278575e-01},
  {-5.739576e-01,  4.554065e-01,  6.805716e-01,  1.685203e-01, -1.182547e+00, -1.516820e-01},
  { 3.824863e-01, -8.760449e-01, -2.936825e-01,  2.289982e-02, -1.192624e+00, -2.927120e-01},
  {-2.990638e-01, -7.724279e-01, -5.602821e-01,  6.849471e-02, -1.185782e+00, -3.031591e-01},
  {-5.336239e-01, -7.360421e-01, -4.165184e-01,  1.012382e-01, -1.182185e+00, -3.342780e-01},
  {-7.142874e-01, -2.571624e-01,  6.508924e-01, -1.731230e-01, -1.181776e+00, -3.190495e-01},
  { 9.306867e-01,  2.955692e-01,  2.155487e-01,  2.056556e-01, -1.175702e+00, -3.324651e-01},
  {-7.347695e-01, -6.741924e-01, -7.468931e-02,  1.105354e-01, -1.188440e+00, -3.490115e-01},
  { 8.879444e-02, -4.283124e-01, -8.992575e-01, -3.203457e-02, -1.182215e+00, -3.552260e-01},
  {-7.315388e-01, -2.705150e-01,  6.258376e-01,  8.938192e-02, -1.190018e+00, -4.390035e-01},
  {-1.837349e-01,  4.722382e-01,  8.621094e-01, -1.620717e-01, -1.173344e+00, -4.587019e-01},
  {-9.986780e-02, -2.572040e-01,  9.611828e-01,  3.066512e-04, -1.167400e+00, -4.778227e-01},
  {-6.919581e-01,  2.276182e-01, -6.851160e-01, -9.601016e-02, -1.172630e+00, -5.100959e-01},
  {-8.336957e-01, -4.980501e-01, -2.385322e-01, -1.802444e-01, -1.179076e+00, -5.839736e-01},
  {-1.342833e-01,  5.757118e-01, -8.065507e-01,  7.076747e-02, -1.166224e+00, -5.964690e-01},
  { 5.152767e-01,  6.724141e-01, -5.313655e-01,  5.337194e-02, -1.174289e+00, -6.054673e-01},
  { 8.224458e-01, -5.686879e-01, -1.330688e-02,  2.617107e-01, -1.176957e+00, -5.990762e-01},
  {-4.942970e-01, -4.140120e-01, -7.643719e-01, -8.165331e-02, -1.179093e+00, -6.623530e-01},
  {-2.412146e-01, -3.953696e-01, -8.862835e-01,  1.828805e-01, -1.172734e+00, -7.320014e-01},
  {-3.030760e-01, -3.955196e-01, -8.670116e-01,  1.399550e-01, -1.174893e+00, -7.204979e-01},
  { 9.135389e-01,  3.779036e-01,  1.504509e-01,  4.299229e-02, -1.167713e+00, -7.411937e-01},
  { 5.362723e-01, -7.447313e-01,  3.972244e-01,  1.714739e-01, -1.146734e+00,  2.021949e-01},
  {-1.834467e-01, -9.419222e-01,  2.813003e-01,  1.509496e-01, -1.145701e+00,  2.120380e-01},
  {-4.512301e-01, -5.703325e-01, -6.863762e-01,  1.624425e-01, -1.140741e+00,  1.944183e-01},
  { 5.512092e-01, -8.325241e-01,  5.542614e-02,  2.792569e-02, -1.141328e+00,  1.527325e-01},
  { 4.161154e-02, -9.610952e-01, -2.730652e-01,  8.715545e-03, -1.140842e+00,  1.375088e-01},
  {-5.385363e-01, -7.153113e-01, -4.453183e-01, -3.958951e-03, -1.138882e+00,  1.345172e-01},
  {-9.216471e-03, -3.332089e-01,  9.428080e-01,  2.750289e-02, -1.151005e+00, -1.116943e-02},
  { 8.597074e-01, -1.856281e-01,  4.758627e-01,  3.281134e-01, -1.153811e+00, -3.684928e-02},
  {-4.057602e-01, -8.502340e-01, -3.353518e-01,  1.001515e-01, -1.157967e+00, -6.115014e-02},
  {-7.196364e-01, -6.841744e-01,  1.184434e-01,  2.172435e-01, -1.172381e+00, -8.514617e-02},
  {-6.599749e-01, -7.450694e-01, -9.646107e-02,  2.010238e-01, -1.159022e+00, -1.057843e-01},
  { 1.147189e-01, -5.369244e-01,  8.357942e-01,  3.492045e-01, -1.154143e+00, -1.483214e-01},
  { 7.558208e-01, -3.908615e-01, -5.253212e-01,  2.696302e-01, -1.157905e+00, -1.316827e-01},
  { 8.081977e-01, -5.133892e-01,  2.885275e-01, -1.724803e-01, -1.143266e+00, -1.451082e-01},
  {-3.636799e-01,  4.993412e-01,  7.863811e-01,  1.147114e-01, -1.159781e+00, -1.993061e-01},
  { 3.183751e-01, -8.822250e-01, -3.468665e-01, -2.015948e-01, -1.145842e+00, -1.940080e-01},
  { 4.315948e-01, -2.972584e-01, -8.516827e-01, -2.276680e-01, -1.141400e+00, -2.061089e-01},
  { 7.573912e-01, -1.466461e-01, -6.362810e-01,  3.598927e-01, -1.151351e+00, -2.365121e-01},
  { 1.427803e-01, -9.472242e-01, -2.870194e-01,  4.498748e-02, -1.175681e+00, -3.170156e-01},
  {-3.819515e-01, -5.405084e-01, -7.496423e-01, -2.043515e-01, -1.143845e+00, -3.515988e-01},
  {-8.408584e-02, -9.872440e-01, -1.351994e-01,  7.156406e-02, -1.167220e+00, -3.607870e-01},
  {-5.316939e-01, -8.460581e-01,  3.856405e-02,  7.821129e-02, -1.168528e+00, -3.944742e-01},
  {-2.784160e-01, -8.110270e-01, -5.145092e-01,  1.785331e-02, -1.162168e+00, -3.885145e-01},
  { 2.579869e-01, -8.475837e-01,  4.637291e-01,  3.235899e-01, -1.148302e+00, -4.566093e-01},
  { 9.200514e-01, -3.904770e-01,  3.214379e-02,  3.290415e-01, -1.148074e+00, -4.746716e-01},
  {-4.577527e-01, -6.447756e-01,  6.121495e-01,  5.871686e-02, -1.172966e+00, -4.614308e-01},
  {-1.930586e-01,  2.457314e-03,  9.811841e-01,  3.808847e-02, -1.171720e+00, -4.735144e-01},
  { 3.636463e-03, -2.507457e-01,  9.680461e-01, -3.825953e-02, -1.149334e+00, -4.761686e-01},
  { 7.152914e-01, -5.798419e-01,  3.900534e-01,  1.873933e-01, -1.166385e+00, -5.224853e-01},
  {-8.834065e-01,  1.372844e-01, -4.480467e-01, -7.693522e-02, -1.141880e+00, -5.339671e-01},
  { 9.439107e-01, -6.096629e-02, -3.245238e-01,  3.249789e-01, -1.138810e+00, -5.290414e-01},
  {-6.874074e-01,  5.069356e-02,  7.245006e-01, -1.952890e-01, -1.162160e+00, -5.867507e-01},
  { 9.808308e-01, -1.919202e-01, -3.372804e-02,  2.568298e-01, -1.154865e+00, -6.514145e-01},
  {-1.456965e-01, -8.165420e-01, -5.585980e-01, -7.928532e-02, -1.165503e+00, -6.763438e-01},
  {-5.912963e-01, -4.562591e-01, -6.649784e-01, -4.159841e-02, -1.170798e+00, -7.124485e-01},
  {-1.519184e-01, -8.689083e-01, -4.710828e-01, -1.022321e-01, -1.152746e+00, -7.134479e-01},
  { 1.086143e-01, -1.136021e-01, -9.875715e-01,  2.019512e-01, -1.157631e+00, -7.450061e-01},
  { 7.089005e-01,  3.151653e-01, -6.309763e-01,  3.732158e-02, -1.169137e+00, -7.775657e-01},
  {-6.239337e-01,  2.328012e-01, -7.459962e-01,  2.475877e-02, -1.169500e+00, -7.799504e-01},
  {-5.651305e-01, -7.493801e-01,  3.450464e-01,  1.364640e-01, -1.129595e+00,  2.269467e-01},
  { 6.048810e-01, -7.240252e-01, -3.315214e-01,  1.967481e-01, -1.131366e+00,  1.868597e-01},
  {-6.798983e-01, -4.775589e-01,  5.564853e-01,  1.956043e-03, -1.128431e+00,  1.561927e-01},
  { 1.055884e-01,  2.523341e-01,  9.618620e-01,  1.088502e-01, -1.139558e+00, -1.604101e-02},
  { 8.685045e-01, -3.072638e-01,  3.889588e-01,  3.357802e-01, -1.130774e+00, -3.805551e-02},
  { 8.631187e-02,  3.537915e-01,  9.313334e-01,  3.121663e-01, -1.139897e+00, -2.584183e-02},
  {-8.114007e-01, -4.379056e-01,  3.871274e-01, -2.083870e-02, -1.126095e+00, -1.423260e-02},
  {-7.807627e-01, -5.766954e-01, -2.404825e-01, -2.711616e-02, -1.118667e+00, -6.642181e-02},
  {-7.920227e-01, -1.753742e-01,  5.847597e-01,  1.871535e-01, -1.146423e+00, -1.418902e-01},
  { 3.128732e-01, -6.546505e-01,  6.881447e-01,  2.952614e-01, -1.138387e+00, -1.459571e-01},
  { 5.998563e-01, -7.855588e-01, -1.518878e-01, -1.694666e-01, -1.130646e+00, -1.636705e-01},
  { 6.990956e-01, -4.276823e-01, -5.730211e-01, -1.795761e-01, -1.126834e+00, -1.890104e-01},
  {-6.318348e-01,  2.835845e-01,  7.213631e-01,  1.336896e-01, -1.133445e+00, -1.973983e-01},
  {-4.167792e-01, -7.973359e-01,  4.365209e-01, -2.621763e-01, -1.120740e+00, -2.162527e-01},
  { 2.137843e-01, -3.950740e-01, -8.934276e-01, -2.375248e-01, -1.124804e+00, -2.190991e-01},
  {-2.873910e-01,  3.288644e-01,  8.995858e-01,  8.310851e-02, -1.125955e+00, -2.304026e-01},
  { 8.314168e-01,  4.584392e-01, -3.139739e-01,  1.788783e-01, -1.137497e+00, -2.784773e-01},
  { 6.073869e-01, -7.517179e-01,  2.569073e-01,  2.272874e-01, -1.134169e+00, -3.881832e-01},
  {-9.794520e-01, -8.888553e-02,  1.810338e-01,  3.445170e-01, -1.126814e+00, -3.980762e-01},
  { 1.644841e-01, -7.326331e-01,  6.604497e-01,  3.440950e-01, -1.126927e+00, -4.004150e-01},
  { 6.711730e-01, -7.387967e-01, -6.087814e-02,  3.394959e-01, -1.128546e+00, -4.073565e-01},
  {-3.626274e-01, -1.815075e-01,  9.140877e-01,  3.439384e-01, -1.122235e+00, -3.989585e-01},
  {-2.832507e-01, -4.810922e-01,  8.296502e-01,  3.360423e-01, -1.121840e+00, -3.988322e-01},
  { 5.350212e-01, -8.432747e-01,  5.138048e-02,  1.971355e-01, -1.151915e+00, -4.754837e-01},
  {-9.458758e-01,  9.782706e-02, -3.094331e-01, -1.535888e-01, -1.132868e+00, -4.724932e-01},
  { 9.410232e-01,  3.208598e-01, -1.073511e-01,  3.269362e-01, -1.134067e+00, -4.923336e-01},
  { 7.916334e-01, -5.495680e-01, -2.670049e-01,  1.948442e-01, -1.155450e+00, -4.922053e-01},
  {-1.655696e-02, -3.354363e-01,  9.419174e-01, -4.505242e-02, -1.135807e+00, -4.730012e-01},
  { 6.501492e-01,  7.025999e-01, -2.892391e-01,  3.246241e-01, -1.134102e+00, -5.260046e-01},
  { 3.013780e-01,  3.658136e-01, -8.805405e-01,  4.851793e-02, -1.142926e+00, -5.886846e-01},
  {-4.601074e-01,  4.086475e-01,  7.882311e-01, -1.009228e-01, -1.140674e+00, -5.693235e-01},
  { 6.135566e-01,  7.234183e-01, -3.165660e-01,  2.424917e-01, -1.137539e+00, -5.911737e-01},
  {-2.443887e-01,  5.787514e-01,  7.780237e-01, -2.019825e-01, -1.137806e+00, -6.032007e-01},
  {-7.527415e-01, -4.218065e-01,  5.054301e-01, -2.106153e-01, -1.129380e+00, -6.136624e-01},
  {-5.553821e-01, -4.545992e-01, -6.963406e-01, -1.285542e-01, -1.155004e+00, -6.475370e-01},
  {-6.512477e-02,  2.025793e-01, -9.770979e-01, -7.070433e-02, -1.141717e+00, -7.306006e-01},
  {-3.262831e-01, -6.020819e-01, -7.287227e-01, -1.521875e-01, -1.126500e+00, -7.217835e-01},
  {-3.250028e-01,  2.932951e-01, -8.990836e-01,  1.966481e-01, -1.152211e+00, -7.426395e-01},
  {-3.208276e-01,  2.935432e-01, -9.005010e-01, -4.570247e-02, -1.134065e+00, -7.393575e-01},
  {-7.404831e-02,  3.651482e-01, -9.279999e-01, -9.457907e-02, -1.136897e+00, -7.302275e-01},
  { 7.225744e-01,  5.931697e-01, -3.550153e-01,  3.586625e-02, -1.153744e+00, -7.665530e-01},
  {-3.552648e-01, -6.789348e-01,  6.425220e-01,  1.286118e-01, -1.115346e+00,  2.348678e-01},
  {-7.236342e-01, -6.889517e-01, -4.122269e-02,  1.158534e-01, -1.105855e+00,  2.132219e-01},
  { 2.472251e-01, -3.504788e-01, -9.033517e-01,  6.404557e-03, -1.112040e+00,  1.217141e-01},
  {-2.550121e-02,  1.850940e-01, -9.823899e-01,  3.177166e-01, -1.101609e+00,  9.431364e-02},
  {-2.012475e-01, -5.287700e-01,  8.245615e-01, -2.560189e-02, -1.104574e+00,  6.130160e-03},
  { 3.722841e-01,  2.599458e-01,  8.909729e-01,  3.258964e-01, -1.124978e+00, -3.153158e-02},
  { 9.334982e-01, -4.633147e-02,  3.555763e-01,  3.419554e-01, -1.122076e+00, -4.582331e-02},
  {-6.200325e-01, -6.876358e-01, -3.777787e-01, -2.791558e-02, -1.115177e+00, -7.542759e-02},
  {-4.552170e-01, -7.744898e-01, -4.392527e-01,  8.161051e-02, -1.116384e+00, -1.128745e-01},
  { 6.839262e-01, -6.777731e-01,  2.699416e-01,  2.819293e-01, -1.140684e+00, -1.391166e-01},
  {-6.005253e-01, -7.993408e-01,  2.058530e-02,  1.856752e-01, -1.135428e+00, -1.298323e-01},
  { 9.590208e-01, -2.828126e-01, -1.720900e-02,  3.793777e-01, -1.117623e+00, -1.577181e-01},
  {-6.681969e-01, -7.198290e-01,  1.880406e-01,  1.659156e-01, -1.131064e+00, -1.541607e-01},
  { 9.982244e-01, -5.955197e-02,  1.260687e-03,  3.461565e-01, -1.118064e+00, -2.008233e-01},
  {-5.930737e-02, -2.220942e-01, -9.732198e-01,  2.508408e-01, -1.122573e+00, -2.306076e-01},
  {-6.019242e-01, -6.320158e-02,  7.960482e-01,  1.069441e-01, -1.124197e+00, -2.213144e-01},
  { 4.868402e-01,  3.276112e-01, -8.097268e-01,  1.929066e-01, -1.123741e+00, -2.511417e-01},
  { 4.019163e-01, -1.398490e-01,  9.049340e-01,  2.255254e-01, -1.116822e+00, -3.652582e-01},
  {-1.553733e-01,  1.069230e-01,  9.820522e-01, -1.303641e-01, -1.132741e+00, -4.542846e-01},
  {-9.906751e-01, -3.698231e-02, -1.311311e-01, -1.516638e-01, -1.118278e+00, -4.769208e-01},
  {-5.795907e-01, -2.034894e-01, -7.890923e-01, -1.017141e-01, -1.116229e+00, -5.100976e-01},
  { 5.319523e-01,  6.538552e-01, -5.380521e-01,  3.181220e-01, -1.135714e+00, -5.376496e-01},
  { 8.543352e-01,  4.613464e-01,  2.393132e-01,  2.314292e-01, -1.115635e+00, -5.587699e-01},
  {-3.270531e-01,  9.606785e-02, -9.401103e-01,  1.144291e-01, -1.110580e+00, -5.844513e-01},
  {-6.685655e-01,  5.289810e-01, -5.226848e-01,  1.611758e-01, -1.111789e+00, -6.136715e-01},
  {-8.627069e-01, -4.951917e-01, -1.025765e-01, -2.340554e-01, -1.109808e+00, -6.409165e-01},
  { 5.899358e-01,  7.891436e-01, -1.709625e-01,  1.775537e-02, -1.126990e+00, -6.564376e-01},
  { 6.807202e-01,  5.114965e-01, -5.243961e-01,  2.349206e-01, -1.134922e+00, -7.145072e-01},
  { 2.234478e-01,  6.749943e-01, -7.031741e-01,  2.207752e-01, -1.136600e+00, -7.298489e-01},
  {-7.923590e-02,  9.424691e-01, -3.247673e-01,  1.554102e-02, -1.133707e+00, -7.418765e-01},
  { 1.793916e-02,  7.652128e-01, -6.435274e-01, -8.400860e-02, -1.125623e+00, -7.240813e-01},
  { 2.316139e-01,  8.244128e-01, -5.164286e-01,  1.715962e-02, -1.133724e+00, -7.518789e-01},
  { 6.749848e-02, -4.161212e-01,  9.068005e-01,  3.048479e-01, -1.080427e+00,  2.901267e-01},
  {-1.852398e-01, -8.191361e-01,  5.428649e-01,  2.513223e-01, -1.095147e+00,  2.787786e-01},
  {-4.833584e-02, -6.919525e-01,  7.203231e-01,  2.186241e-01, -1.088804e+00,  2.811369e-01},
  { 4.900891e-01, -8.575727e-01,  1.561463e-01,  3.070948e-01, -1.094073e+00,  2.758133e-01},
  {-6.376485e-01, -3.187392e-01,  7.012915e-01,  1.199865e-01, -1.090231e+00,  2.474866e-01},
  { 3.715416e-01, -7.036814e-01,  6.056313e-01,  1.662840e-01, -1.101197e+00,  2.343041e-01},
  { 6.143276e-01, -7.890475e-01, -2.383090e-03,  1.781791e-01, -1.095384e+00,  2.210144e-01},
  { 4.472136e-01,  0.000000e+00,  8.944272e-01,  3.347863e-01, -1.085424e+00,  2.004540e-01},
  { 4.472136e-01,  0.000000e+00,  8.944272e-01,  3.324355e-01, -1.084808e+00,  1.995176e-01},
  { 7.057416e-01, -7.049997e-01,  7.003026e-02,  3.357800e-01, -1.082005e+00,  2.047326e-01},
  {-2.420901e-01, -5.750564e-01,  7.814746e-01,  2.264546e-02, -1.104121e+00,  1.767300e-01},
  {-6.186807e-01, -2.713010e-01,  7.373127e-01,  1.090731e-02, -1.091366e+00,  1.726465e-01},
  {-9.056543e-01, -7.364534e-02,  4.175724e-01, -6.486378e-03, -1.089984e+00,  1.465754e-01},
  {-8.060345e-01, -3.672813e-01, -4.641260e-01, -8.454243e-03, -1.097192e+00,  1.189654e-01},
  { 2.609380e-01, -4.701167e-01, -8.431498e-01,  3.389886e-01, -1.087778e+00,  9.636734e-02},
  {-2.612060e-01, -6.790497e-01, -6.860487e-01,  3.039233e-01, -1.091886e+00,  9.650359e-02},
  { 1.225614e-01, -9.185843e-01, -3.757414e-01,  1.805521e-01, -1.102430e+00,  9.624752e-02},
  {-9.844387e-01, -5.342944e-02,  1.674088e-01, -2.124381e-02, -1.090826e+00,  6.271452e-02},
  { 3.646115e-01, -6.472371e-01,  6.694346e-01, -1.742373e-01, -1.091697e+00,  2.292679e-02},
  { 7.731293e-01,  2.357298e-01,  5.888147e-01, -1.667558e-01, -1.094133e+00,  1.393635e-02},
  { 6.390663e-01,  4.352582e-02,  7.679190e-01,  2.212576e-02, -1.101837e+00, -1.678552e-02},
  {-3.071176e-01, -8.431177e-01, -4.413970e-01, -1.761043e-01, -1.081376e+00, -1.145112e-02},
  {-5.869442e-02,  5.291400e-01,  8.465021e-01,  2.319533e-01, -1.097195e+00, -8.859483e-02},
  {-5.736234e-01, -7.482561e-01,  3.332702e-01, -1.939407e-01, -1.101673e+00, -1.174903e-01},
  { 4.576720e-01, -8.272005e-01,  3.259996e-01,  3.007392e-01, -1.120214e+00, -1.290358e-01},
  { 9.824408e-01, -1.810261e-01,  4.516118e-02,  3.804993e-01, -1.092984e+00, -1.607377e-01},
  { 3.186281e-02, -6.952776e-01,  7.180347e-01,  3.218713e-01, -1.114399e+00, -1.268102e-01},
  { 8.770987e-01, -3.257983e-01, -3.529209e-01,  3.479799e-01, -1.104452e+00, -2.020779e-01},
  {-6.143090e-01, -4.733921e-01,  6.312878e-01, -2.861130e-01, -1.100488e+00, -2.165241e-01},
  {-5.345654e-01, -7.292202e-01, -4.271739e-01, -2.146209e-01, -1.094860e+00, -3.740242e-01},
  { 7.524328e-01,  9.033252e-02,  6.524453e-01,  3.437385e-01, -1.107558e+00, -3.987833e-01},
  { 9.436919e-01, -2.813438e-01, -1.740440e-01,  3.472550e-01, -1.101743e+00, -4.263156e-01},
  { 7.061191e-01, -1.361236e-01, -6.948857e-01,  3.370249e-01, -1.093922e+00, -4.497749e-01},
  { 6.985419e-01,  3.459416e-01, -6.263893e-01,  3.177026e-01, -1.104194e+00, -4.671513e-01},
  {-6.431167e-01, -4.246650e-01,  6.372288e-01, -2.510786e-02, -1.106997e+00, -4.584346e-01},
  { 4.167865e-01,  8.303839e-01, -3.697995e-01,  2.932889e-01, -1.108202e+00, -5.025194e-01},
  {-6.799451e-01, -2.824476e-01, -6.766816e-01, -8.443298e-02, -1.096586e+00, -5.281320e-01},
  {-8.567279e-01, -2.862408e-01, -4.290496e-01, -7.812622e-02, -1.101993e+00, -5.295535e-01},
  {-9.012253e-01,  9.892631e-02,  4.219080e-01, -7.707953e-02, -1.106955e+00, -5.543190e-01},
  {-9.194266e-01, -5.193488e-02,  3.898172e-01, -2.358394e-01, -1.101384e+00, -6.355985e-01},
  { 4.573862e-01,  4.708269e-01, -7.544003e-01, -7.299174e-02, -1.094534e+00, -6.558792e-01},
  { 5.044717e-01,  3.600252e-01, -7.847868e-01,  2.864298e-01, -1.106892e+00, -6.580497e-01},
  {-5.975614e-01, -7.196894e-01, -3.535075e-01, -2.120599e-01, -1.105360e+00, -6.916165e-01},
  { 1.555554e-01,  4.209724e-01, -8.936357e-01, -1.471187e-01, -1.090876e+00, -6.987119e-01},
  {-6.517652e-01, -5.042546e-01, -5.665063e-01, -2.039832e-01, -1.101800e+00, -7.141123e-01},
  {-1.714155e-02,  9.991606e-01, -3.720380e-02, -2.773394e-02, -1.127638e+00, -7.369211e-01},
  {-4.650655e-01,  7.375866e-01,  4.895714e-01,  3.126696e-01, -1.077320e+00,  2.928757e-01},
  {-4.650655e-01,  7.375866e-01,  4.895714e-01,  3.157963e-01, -1.073713e+00,  2.904122e-01},
  { 1.013297e-01, -6.429745e-01,  7.591549e-01,  1.667770e-01, -1.084887e+00,  2.687469e-01},
  { 3.365100e-02, -6.407945e-02,  9.973773e-01,  1.744020e-01, -1.074653e+00,  2.725747e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  3.421249e-01, -1.075729e+00,  2.205341e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  3.364705e-01, -1.077650e+00,  2.175464e-01},
  { 6.751209e-01, -7.366037e-01,  4.033402e-02,  3.427069e-01, -1.069832e+00,  2.229739e-01},
  { 8.990104e-01, -4.337170e-01, -6.057903e-02,  3.611468e-01, -1.066623e+00,  9.128391e-02},
  {-1.801852e-02, -8.914797e-01, -4.527023e-01, -5.901550e-03, -1.082449e+00,  9.131976e-02},
  { 5.398594e-01, -4.521207e-01,  7.100273e-01, -1.775075e-01, -1.037955e+00,  9.257735e-02},
  {-2.682257e-01, -6.451236e-01, -7.154513e-01,  1.885382e-01, -1.081267e+00,  7.795802e-02},
  { 5.050908e-01, -8.330300e-01,  2.257085e-01, -1.922087e-02, -1.077140e+00,  7.283495e-02},
  { 8.114704e-01, -3.700891e-01,  4.522717e-01, -1.751297e-01, -1.071974e+00,  3.663395e-02},
  {-7.226132e-01, -6.694857e-01, -1.721012e-01, -1.953767e-01, -1.077303e+00,  1.227285e-02},
  { 3.867712e-01, -8.404206e-01, -3.796067e-01, -1.549713e-01, -1.078543e+00, -1.240445e-02},
  { 9.741833e-01, -1.951137e-01,  1.135679e-01,  2.598448e-02, -1.079070e+00, -1.975059e-02},
  { 5.086724e-01,  5.317539e-01,  6.771191e-01,  3.373907e-01, -1.098503e+00, -5.195537e-02},
  { 1.390583e-01, -8.615474e-01, -4.882611e-01, -1.566654e-01, -1.070628e+00, -3.656077e-02},
  {-9.870441e-01, -1.594157e-01,  1.818182e-02, -3.872538e-02, -1.075475e+00, -8.680036e-02},
  { 8.718154e-01, -4.889098e-01, -3.008446e-02,  3.426985e-01, -1.095609e+00, -1.009948e-01},
  { 9.419988e-01, -2.628190e-01,  2.087206e-01, -1.798812e-01, -1.075475e+00, -9.480991e-02},
  {-6.783665e-01, -4.777671e-01, -5.581735e-01, -3.610500e-02, -1.074128e+00, -1.136669e-01},
  {-6.929384e-01, -7.205615e-01, -2.505235e-02, -2.204597e-01, -1.079067e+00, -1.156237e-01},
  {-6.472665e-01, -3.323761e-01,  6.859827e-01, -2.919122e-01, -1.083456e+00, -2.144314e-01},
  {-6.839355e-01, -4.308005e-01,  5.887641e-01,  9.750703e-02, -1.097893e+00, -2.210778e-01},
  {-5.115327e-01,  1.915651e-01,  8.376378e-01, -2.518637e-02, -1.087403e+00, -2.534176e-01},
  {-3.852632e-01, -8.118404e-01, -4.387339e-01, -3.082238e-01, -1.070754e+00, -2.480210e-01},
  { 8.236601e-01, -3.184215e-01, -4.692461e-01,  3.606380e-01, -1.078574e+00, -2.559681e-01},
  { 7.738956e-01,  1.166724e-01, -6.224735e-01,  1.577019e-01, -1.083685e+00, -2.881980e-01},
  { 5.048087e-01,  8.141233e-01,  2.870041e-01, -5.674409e-02, -1.075995e+00, -2.849559e-01},
  { 2.026882e-01, -9.563658e-02,  9.745620e-01,  2.415232e-01, -1.089011e+00, -3.667885e-01},
  { 3.513565e-01, -8.832843e-02,  9.320658e-01,  3.110086e-01, -1.077775e+00, -3.920732e-01},
  { 1.201449e-01, -8.800812e-01, -4.593715e-01, -2.408985e-01, -1.064983e+00, -3.916925e-01},
  { 7.808103e-01,  2.758685e-01,  5.605638e-01,  3.417805e-01, -1.082285e+00, -4.090975e-01},
  { 9.733309e-01, -1.585812e-01,  1.657681e-01,  3.537408e-01, -1.068987e+00, -4.301916e-01},
  { 4.695355e-01, -4.776857e-01, -7.425314e-01,  3.452063e-01, -1.075240e+00, -4.487519e-01},
  { 3.469071e-01,  7.067963e-01, -6.165180e-01,  2.526953e-01, -1.086685e+00, -4.791271e-01},
  { 3.450854e-01,  6.042014e-01, -7.182317e-01,  2.107291e-01, -1.071514e+00, -4.792636e-01},
  { 7.034700e-01,  7.082047e-01, -5.979972e-02,  1.853367e-01, -1.069140e+00, -5.114059e-01},
  {-5.502878e-01, -7.963473e-02,  8.311689e-01, -1.121918e-01, -1.081306e+00, -5.955817e-01},
  { 6.229722e-01,  2.727506e-02, -7.817684e-01, -6.725887e-02, -1.074879e+00, -6.464551e-01},
  { 5.205024e-01, -1.976363e-01, -8.306727e-01, -9.392181e-02, -1.076027e+00, -6.618738e-01},
  { 5.552895e-01,  2.832910e-01, -7.819206e-01, -1.227011e-01, -1.088371e+00, -6.823013e-01},
  { 3.710701e-01,  2.447760e-01, -8.957632e-01, -1.495486e-01, -1.077144e+00, -6.942360e-01},
  { 2.470980e-01, -3.666559e-02, -9.682965e-01, -1.926905e-01, -1.095060e+00, -7.279988e-01},
  { 8.581605e-01,  3.961555e-02,  5.118508e-01,  3.424296e-01, -1.064924e+00,  2.574992e-01},
  {-4.156103e-01, -5.976489e-02,  9.075772e-01,  1.125822e-01, -1.057005e+00,  2.520255e-01},
  { 1.513439e-01, -8.998557e-01, -4.090901e-01,  2.205654e-01, -1.074540e+00,  2.377352e-01},
  {-4.649170e-01, -3.537049e-01,  8.116311e-01,  8.604326e-02, -1.057266e+00,  2.429086e-01},
  { 6.850873e-01, -7.242708e-01,  7.801992e-02,  1.952301e-01, -1.077766e+00,  2.127150e-01},
  {-2.590599e-01, -9.591863e-01, -1.133566e-01, -1.547630e-01, -1.024211e+00,  2.036131e-01},
  { 3.507066e-01, -6.964040e-01, -6.261200e-01, -1.567511e-01, -1.021522e+00,  1.976701e-01},
  { 7.349285e-01, -6.772157e-01,  3.548200e-02,  2.141767e-01, -1.066737e+00,  1.659286e-01},
  { 7.752102e-01, -2.451585e-01,  5.821911e-01,  3.584399e-01, -1.065792e+00,  9.775756e-02},
  {-4.120976e-01, -6.575990e-01,  6.306657e-01, -1.944157e-01, -1.043813e+00,  8.500144e-02},
  { 1.255496e-02, -9.894777e-01, -1.441396e-01,  2.301954e-01, -1.069097e+00,  1.001237e-01},
  { 6.778638e-01, -6.047536e-01,  4.180596e-01, -1.749742e-01, -1.052040e+00,  7.249366e-02},
  {-8.904938e-01, -4.082537e-01, -2.008727e-01, -2.363798e-01, -1.061097e+00, -1.018218e-01},
  { 8.028512e-01,  7.218252e-02,  5.917937e-01,  3.783413e-01, -1.060762e+00, -1.380354e-01},
  {-9.306808e-01, -3.208186e-01, -1.758086e-01, -2.157512e-01, -1.059685e+00, -1.430700e-01},
  { 9.622227e-01,  2.401450e-01,  1.282883e-01,  3.842971e-01, -1.060956e+00, -1.552676e-01},
  { 6.818615e-01, -2.847410e-01, -6.737861e-01, -1.643958e-01, -1.053442e+00, -2.047447e-01},
  { 5.606196e-02, -1.251323e-02,  9.983490e-01, -2.756163e-01, -1.059465e+00, -2.059500e-01},
  {-3.882218e-01, -2.896059e-01,  8.748784e-01, -3.107211e-01, -1.055242e+00, -2.179188e-01},
  { 4.947805e-01, -1.011418e-01, -8.631122e-01,  1.950592e-01, -1.079857e+00, -2.515418e-01},
  {-5.153196e-01, -6.577989e-01, -5.493144e-01, -3.251407e-01, -1.047864e+00, -2.957956e-01},
  {-3.962820e-02,  4.065885e-02,  9.983869e-01,  2.674485e-01, -1.073587e+00, -3.723350e-01},
  { 7.778174e-01,  6.124974e-01, -1.408799e-01,  1.158230e-01, -1.059255e+00, -3.568355e-01},
  {-4.732168e-01, -3.584140e-01, -8.047392e-01, -5.704803e-02, -1.066990e+00, -3.781373e-01},
  { 3.538051e-02,  5.362405e-01,  8.433233e-01,  1.610925e-01, -1.068685e+00, -3.984805e-01},
  { 3.533142e-01,  6.748047e-01,  6.479256e-01,  1.125243e-01, -1.048915e+00, -4.040482e-01},
  {-4.634309e-01, -8.328355e-01, -3.026826e-01, -2.533688e-01, -1.057946e+00, -4.015084e-01},
  {-4.797375e-01,  8.029211e-02, -8.737305e-01, -2.598069e-01, -1.053082e+00, -4.002652e-01},
  { 3.106113e-01,  1.454477e-01, -9.393432e-01,  2.911114e-01, -1.073441e+00, -4.576439e-01},
  { 1.714035e-01, -1.432514e-01, -9.747306e-01,  2.771362e-01, -1.062711e+00, -4.646418e-01},
  { 6.099960e-01,  5.059155e-01, -6.098805e-01,  1.814621e-01, -1.056718e+00, -4.877928e-01},
  {-5.622479e-01,  1.327476e-01,  8.162447e-01, -1.376550e-01, -1.060270e+00, -4.848657e-01},
  {-9.317935e-02, -5.435734e-01, -8.341736e-01,  6.710883e-02, -1.063993e+00, -5.935315e-01},
  { 2.365479e-01, -5.623666e-02, -9.699910e-01,  4.260694e-02, -1.078312e+00, -5.854354e-01},
  {-8.820684e-01, -3.027185e-01,  3.609941e-01, -9.192532e-02, -1.065439e+00, -5.709088e-01},
  { 4.539703e-01, -2.054567e-01, -8.670055e-01, -1.177461e-02, -1.071660e+00, -6.134999e-01},
  { 3.709920e-01, -4.842028e-01, -7.924094e-01, -2.681466e-02, -1.065986e+00, -6.205031e-01},
  { 4.938388e-01, -3.612816e-01, -7.909480e-01, -3.633686e-02, -1.064623e+00, -6.276908e-01},
  { 3.065378e-01,  1.878713e-01, -9.331340e-01,  2.635813e-01, -1.058908e+00, -6.265252e-01},
  {-9.348843e-01, -2.611152e-01, -2.404376e-01, -2.525905e-01, -1.050642e+00, -6.595283e-01},
  { 6.406103e-02, -9.268037e-01, -3.700420e-01,  1.591037e-01, -1.056303e+00, -6.904254e-01},
  { 3.417092e-01, -2.478836e-01, -9.065255e-01, -1.529571e-01, -1.066877e+00, -6.957525e-01},
  {-4.436497e-01,  2.079522e-02, -8.959590e-01, -2.049076e-01, -1.076188e+00, -7.164034e-01},
  { 6.831408e-01, -7.301009e-01, -1.647155e-02, -1.312139e-01, -1.030722e+00,  2.260299e-01},
  {-9.492476e-02, -9.493086e-01, -2.996704e-01,  2.773864e-01, -1.059295e+00,  2.144052e-01},
  { 8.666565e-02, -8.842026e-01, -4.589933e-01,  2.514104e-01, -1.053977e+00,  2.137993e-01},
  {-7.244443e-01,  1.049885e-01,  6.812913e-01,  3.940107e-02, -1.049699e+00,  2.119688e-01},
  { 5.266840e-01, -4.899000e-01, -6.946955e-01, -1.365954e-01, -1.024579e+00,  2.090593e-01},
  { 5.606665e-01, -5.722217e-01, -5.985110e-01,  5.251594e-02, -1.053037e+00,  1.231450e-01},
  { 3.338401e-01, -9.092672e-01,  2.485637e-01,  2.272639e-01, -1.062390e+00,  1.149152e-01},
  { 9.095272e-01, -2.520932e-01, -3.304682e-01,  3.609267e-01, -1.040904e+00,  7.700641e-02},
  { 2.317837e-01, -2.749500e-01, -9.331017e-01,  3.500578e-01, -1.041630e+00,  7.272874e-02},
  {-7.850946e-01, -6.184992e-01, -3.294547e-02, -2.350826e-01, -1.038418e+00,  7.224527e-03},
  {-1.124204e-02,  6.697280e-01,  7.425213e-01,  2.942386e-01, -1.056743e+00, -8.229498e-02},
  {-5.540320e-01,  4.178777e-01,  7.200186e-01,  2.459679e-01, -1.045265e+00, -9.870912e-02},
  { 6.866449e-01,  4.384273e-01,  5.799140e-01,  3.514853e-01, -1.055020e+00, -1.183910e-01},
  { 3.599541e-01,  6.069879e-01,  7.085187e-01,  1.202389e-01, -1.051531e+00, -1.098269e-01},
  {-9.303582e-01,  4.757974e-02, -3.635516e-01, -3.946563e-02, -1.037629e+00, -1.293327e-01},
  { 1.829488e-01,  9.146889e-01,  3.603801e-01,  2.985357e-01, -1.044034e+00, -1.539528e-01},
  {-6.164355e-01, -1.074233e-01, -7.800434e-01, -3.270722e-02, -1.040349e+00, -1.360462e-01},
  {-9.439986e-01, -2.477320e-01, -2.179345e-01, -2.163382e-01, -1.035463e+00, -1.578352e-01},
  {-4.802310e-01, -7.447701e-01, -4.633527e-01,  5.922725e-02, -1.053104e+00, -1.703568e-01},
  {-8.244740e-01, -4.924407e-01,  2.788277e-01, -3.314479e-01, -1.047041e+00, -2.308705e-01},
  {-8.424081e-01, -5.435625e-02, -5.360915e-01, -3.321475e-01, -1.043171e+00, -2.945146e-01},
  {-4.871097e-01, -1.017707e-01,  8.673909e-01, -1.115690e-01, -1.030946e+00, -3.163133e-01},
  {-8.025321e-01, -5.770208e-01, -1.516226e-01, -2.714093e-01, -1.035223e+00, -3.748776e-01},
  { 5.161254e-01,  5.570334e-01,  6.506369e-01,  9.623486e-02, -1.040498e+00, -3.998065e-01},
  {-8.382273e-01, -4.889100e-01, -2.415407e-01, -4.008703e-02, -1.056734e+00, -4.069810e-01},
  { 4.214379e-01, -1.411953e-01, -8.957980e-01, -2.357893e-01, -1.050564e+00, -4.000446e-01},
  { 9.020236e-01, -4.020298e-01, -1.572431e-01,  3.645818e-01, -1.036607e+00, -4.493655e-01},
  { 2.411978e-01,  2.549943e-02, -9.701409e-01,  2.066765e-01, -1.042495e+00, -4.707655e-01},
  { 3.154660e-01, -7.749350e-01, -5.476832e-01,  3.564762e-01, -1.038893e+00, -4.723056e-01},
  { 3.568245e-01, -6.591206e-01, -6.619942e-01,  3.436587e-01, -1.043490e+00, -4.767536e-01},
  { 1.253999e-01, -9.191540e-01,  3.734041e-01, -3.063405e-01, -1.036363e+00, -5.056515e-01},
  {-2.838868e-01, -9.385472e-01,  1.963094e-01, -3.307118e-01, -1.035670e+00, -5.095999e-01},
  { 1.534960e-01, -9.809999e-01,  1.186508e-01, -2.894457e-01, -1.034984e+00, -5.217766e-01},
  {-2.684321e-01, -8.665108e-01, -4.208364e-01, -3.280929e-01, -1.035891e+00, -5.137021e-01},
  {-6.994808e-02, -7.554557e-01, -6.514553e-01,  7.461362e-02, -1.059369e+00, -6.003238e-01},
  { 1.290521e-01, -5.951826e-01, -7.931603e-01,  2.578070e-02, -1.052765e+00, -5.989979e-01},
  { 9.445431e-01, -1.427654e-01,  2.957305e-01,  3.019245e-01, -1.045131e+00, -6.128657e-01},
  {-4.311215e-01, -1.865046e-01,  8.828082e-01, -1.305933e-01, -1.045555e+00, -6.086199e-01},
  {-3.736887e-01, -6.844445e-01, -6.260130e-01,  1.988880e-01, -1.050921e+00, -6.250860e-01},
  {-6.431670e-02, -9.636871e-01, -2.591729e-01,  8.659641e-02, -1.042302e+00, -6.401660e-01},
  { 4.940678e-01, -5.810236e-01, -6.467677e-01, -7.759230e-02, -1.060175e+00, -6.588428e-01},
  {-6.853474e-01, -6.982325e-01, -2.068097e-01, -2.653152e-01, -1.028663e+00, -6.612968e-01},
  { 2.409541e-01, -7.214100e-01, -6.492370e-01, -8.609118e-02, -1.055664e+00, -6.695802e-01},
  { 3.875328e-01, -5.304028e-01, -7.539836e-01,  1.786926e-01, -1.046038e+00, -6.900027e-01},
  {-1.848567e-01, -6.069224e-01, -7.729638e-01,  1.364160e-01, -1.045949e+00, -6.984448e-01},
  {-3.871804e-01, -5.355472e-01, -7.505202e-01, -2.104437e-01, -1.038349e+00, -7.239001e-01},
  { 4.616479e-01, -1.383631e-01, -8.762059e-01,  5.139690e-02, -1.035880e+00, -7.340232e-01},
  { 4.512680e-01, -4.640806e-01, -7.622246e-01,  6.473949e-02, -1.033386e+00, -7.218658e-01},
  {-1.740777e-01, -6.963106e-01,  6.963106e-01, -9.597635e-02, -1.036933e+00, -7.328814e-01},
  {-1.740777e-01, -6.963106e-01,  6.963106e-01, -8.902328e-02, -1.036559e+00, -7.357659e-01},
  {-1.068016e-01, -2.411640e-01, -9.645898e-01, -7.893825e-02, -1.033874e+00, -7.357171e-01},
  { 5.663395e-02, -8.507081e-01, -5.225787e-01,  1.463349e-03, -1.033815e+00, -7.458048e-01},
  {-2.480683e-01, -7.622999e-01,  5.977969e-01,  1.487920e-01, -1.012684e+00,  4.083917e-01},
  {-5.057834e-02, -9.939526e-01, -9.746859e-02,  1.576941e-01, -1.014804e+00,  4.028906e-01},
  {-1.705160e-01, -6.680622e-01, -7.243047e-01,  5.192344e-02, -9.923761e-01,  4.063355e-01},
  {-1.705160e-01, -6.680622e-01, -7.243047e-01,  6.568079e-02, -9.925459e-01,  4.032533e-01},
  {-3.291563e-01, -9.229942e-02,  9.397537e-01,  2.684744e-01, -1.036254e+00,  2.907022e-01},
  {-3.940354e-01,  2.425546e-01,  8.865119e-01,  7.123730e-02, -1.032571e+00,  2.390096e-01},
  {-7.326328e-01,  2.382926e-01,  6.375468e-01,  4.806986e-02, -1.037434e+00,  2.201598e-01},
  { 2.362350e-01, -3.843679e-01,  8.924429e-01, -1.310692e-01, -1.019594e+00,  2.296135e-01},
  { 9.407304e-01,  1.011277e-01, -3.237275e-01,  3.258728e-01, -1.034202e+00,  2.036249e-01},
  {-4.993348e-01, -8.444958e-01,  1.936271e-01,  2.641028e-01, -1.050930e+00,  1.898842e-01},
  { 1.942555e-02, -9.888002e-01, -1.479756e-01,  2.463895e-01, -1.043886e+00,  1.882214e-01},
  { 1.391927e-01, -9.627734e-01,  2.317172e-01,  2.383979e-01, -1.044794e+00,  1.820864e-01},
  { 3.180381e-03, -9.561689e-01,  2.927983e-01,  2.439357e-01, -1.052654e+00,  1.562748e-01},
  {-9.143483e-01, -2.694408e-01, -3.022729e-01,  1.669918e-01, -1.027225e+00,  8.563529e-02},
  { 7.497820e-01, -3.465773e-01, -5.636588e-01,  3.650022e-01, -1.018274e+00,  7.592083e-02},
  {-1.294643e-01, -6.472107e-01, -7.512372e-01,  1.646920e-01, -1.036193e+00,  4.155851e-02},
  { 4.600375e-01,  7.530850e-01,  4.703492e-01,  3.672792e-01, -1.043625e+00, -1.381445e-01},
  { 3.563378e-01,  4.626528e-01,  8.117731e-01,  8.950045e-02, -1.021195e+00, -1.175849e-01},
  {-6.327087e-01, -3.830550e-01, -6.730144e-01,  5.142293e-02, -1.030365e+00, -1.878600e-01},
  { 1.035673e-01,  8.506410e-01,  5.154453e-01,  2.939959e-01, -1.024972e+00, -1.999355e-01},
  { 7.287330e-01, -3.545355e-01, -5.858779e-01, -1.562864e-01, -1.015435e+00, -2.191947e-01},
  {-9.614741e-01, -2.746597e-01, -1.138098e-02, -3.335533e-01, -1.038030e+00, -2.469125e-01},
  { 6.104072e-01, -2.613487e-01, -7.477298e-01,  3.527291e-01, -1.032932e+00, -2.693752e-01},
  {-7.419496e-01, -2.808107e-01, -6.088154e-01, -2.875136e-01, -1.028348e+00, -3.565049e-01},
  {-1.614662e-01, -9.001265e-01,  4.045998e-01, -2.612963e-01, -1.034400e+00, -3.477623e-01},
  {-6.723990e-01, -3.999621e-01, -6.228241e-01, -2.953905e-01, -1.027340e+00, -3.507182e-01},
  {-2.420554e-01, -5.925125e-01, -7.683347e-01, -6.887247e-02, -1.035499e+00, -3.975049e-01},
  {-3.779131e-02,  1.283168e-01,  9.910129e-01,  1.272259e-01, -1.016330e+00, -4.158057e-01},
  {-7.317364e-01, -6.742975e-01,  9.942222e-02, -5.874269e-02, -1.039157e+00, -4.264735e-01},
  { 6.550068e-01,  3.718251e-01, -6.578086e-01,  1.600135e-01, -1.026028e+00, -4.933378e-01},
  {-6.696311e-01, -1.418350e-01,  7.290246e-01, -1.400614e-01, -1.020875e+00, -4.880670e-01},
  { 8.655313e-01, -1.553781e-01, -4.761441e-01,  3.573953e-01, -1.021054e+00, -4.901847e-01},
  {-8.441921e-02, -4.822273e-01, -8.719692e-01,  2.971634e-01, -1.018785e+00, -4.938979e-01},
  { 4.408339e-01, -5.677491e-01, -6.952168e-01,  3.359710e-01, -1.011984e+00, -5.008255e-01},
  {-8.661498e-01, -4.500033e-01,  2.174430e-01, -1.543163e-01, -1.026444e+00, -5.209215e-01},
  {-2.463377e-01, -1.956899e-01, -9.492224e-01, -2.751600e-01, -1.022646e+00, -5.066683e-01},
  {-3.327856e-01, -7.043846e-01, -6.269738e-01, -1.496729e-01, -1.024542e+00, -5.336609e-01},
  {-2.658579e-01, -9.640110e-01, -1.559306e-03, -2.411850e-01, -1.023179e+00, -5.368365e-01},
  { 1.289060e-01, -7.949747e-01,  5.927886e-01, -2.206547e-01, -1.016382e+00, -5.261733e-01},
  {-8.394848e-01, -5.254031e-01, -1.386255e-01, -9.379395e-02, -1.043064e+00, -5.535230e-01},
  {-3.045016e-01, -9.511915e-01,  5.013370e-02, -1.881220e-01, -1.016594e+00, -5.513114e-01},
  { 6.271283e-01,  1.938706e-01,  7.544032e-01,  2.937067e-01, -1.043574e+00, -6.012371e-01},
  { 2.820724e-01, -8.175583e-01, -5.020295e-01, -2.670265e-03, -1.041449e+00, -6.160667e-01},
  { 3.114553e-01, -8.802436e-01, -3.580039e-01, -5.072284e-02, -1.047362e+00, -6.629001e-01},
  {-7.711098e-01, -6.251730e-01,  1.206177e-01, -2.775613e-01, -1.020062e+00, -6.536852e-01},
  { 5.953860e-01,  2.633574e-01, -7.590511e-01,  2.204390e-01, -1.028661e+00, -6.702052e-01},
  { 4.108675e-01,  1.834865e-01, -8.930400e-01,  2.149054e-01, -1.028487e+00, -6.758388e-01},
  { 1.159409e-01, -2.344042e-01, -9.652007e-01,  1.271979e-01, -1.025448e+00, -7.071034e-01},
  { 2.004524e-01,  5.026777e-01, -8.409126e-01,  6.398836e-02, -1.023089e+00, -7.235187e-01},
  { 1.386773e-01, -3.104079e-01, -9.404337e-01, -1.239334e-01, -1.018391e+00, -7.342797e-01},
  {-4.155105e-02, -4.136082e-01, -9.095063e-01, -2.042267e-01, -1.023472e+00, -7.454270e-01},
  {-5.743870e-01, -1.917265e-01, -7.958144e-01, -2.077417e-01, -1.022505e+00, -7.453170e-01},
  { 5.268338e-01, -8.200885e-01, -2.233855e-01,  2.009456e-01, -1.003985e+00,  4.087450e-01},
  { 5.384190e-01, -1.202919e-01,  8.340473e-01, -1.407022e-01, -1.000424e+00,  2.351762e-01},
  {-3.503187e-01, -6.190756e-01,  7.028671e-01, -1.626374e-01, -1.006003e+00,  2.292025e-01},
  {-1.731437e-01,  2.988175e-01,  9.384719e-01,  1.755495e-01, -9.950172e-01,  2.232900e-01},
  { 9.678305e-01, -5.791420e-02, -2.448473e-01, -1.302658e-01, -1.000184e+00,  2.098886e-01},
  {-5.076830e-01, -8.464820e-01,  1.603938e-01, -1.953674e-01, -9.961478e-01,  1.984570e-01},
  { 5.322057e-01,  3.727229e-01,  7.601544e-01,  2.902394e-01, -1.010382e+00,  1.111978e-01},
  {-7.200816e-01, -4.885194e-01,  4.927792e-01, -1.968754e-01, -1.017338e+00,  9.793442e-02},
  { 4.154900e-02, -5.166145e-01, -8.552095e-01,  3.093072e-01, -1.018520e+00,  6.330939e-02},
  {-6.803788e-01, -3.075648e-01, -6.651982e-01,  1.747247e-01, -1.000644e+00,  6.945803e-03},
  {-8.263028e-01, -4.079379e-01,  3.883432e-01, -2.566615e-01, -1.005440e+00, -3.332387e-02},
  { 9.647961e-01, -1.962450e-01,  1.750897e-01,  4.470600e-02, -1.017131e+00, -4.239252e-02},
  {-6.768612e-01,  1.251382e-01,  7.253960e-01, -3.093293e-01, -9.984860e-01, -7.032741e-02},
  {-4.162687e-01, -8.625990e-01,  2.874777e-01, -2.715642e-01, -1.010664e+00, -6.585823e-02},
  {-4.391593e-01, -7.237160e-01, -5.323291e-01, -3.093653e-01, -9.939218e-01, -7.868201e-02},
  { 5.333636e-02,  8.542550e-01,  5.171109e-01,  2.612723e-01, -1.029227e+00, -1.003408e-01},
  { 9.930593e-01, -6.215329e-02,  9.985114e-02, -1.605226e-01, -1.007732e+00, -1.090980e-01},
  { 7.908713e-01,  3.191476e-01,  5.221757e-01,  6.922270e-02, -1.005800e+00, -1.048376e-01},
  {-9.116789e-01, -1.803705e-02, -4.105074e-01, -3.957887e-02, -1.011412e+00, -1.415371e-01},
  { 8.382488e-01,  5.024293e-01,  2.119047e-01,  3.659258e-01, -1.012523e+00, -2.082414e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  2.312444e-01, -1.006525e+00, -1.872107e-01},
  { 1.953841e-01,  7.120503e-01,  6.743955e-01,  2.280283e-01, -1.005051e+00, -1.840029e-01},
  {-7.244319e-01,  8.528485e-02,  6.840503e-01, -3.281006e-01, -1.022049e+00, -2.141132e-01},
  {-6.035409e-01,  3.894124e-01, -6.957704e-01, -2.591087e-01, -1.014918e+00, -3.830462e-01},
  { 8.871458e-01, -1.038646e-01,  4.496493e-01,  3.643323e-01, -1.009705e+00, -4.174119e-01},
  { 1.088296e-01, -6.176353e-02, -9.921398e-01, -2.241561e-01, -1.005292e+00, -3.917437e-01},
  { 9.561381e-01,  2.528643e-01, -1.478497e-01,  3.641635e-01, -1.005046e+00, -4.408669e-01},
  { 3.656591e-02,  1.716221e-01,  9.844840e-01,  1.098744e-01, -1.005246e+00, -4.183209e-01},
  { 2.787697e-01,  8.357262e-02, -9.567147e-01,  1.715282e-01, -1.001027e+00, -4.802562e-01},
  { 7.027267e-01,  5.732139e-01, -4.214275e-01,  1.415580e-01, -1.007004e+00, -5.002495e-01},
  {-8.494253e-01, -4.738279e-01, -2.323013e-01, -3.750255e-01, -1.005222e+00, -4.837175e-01},
  { 3.874606e-01, -2.249006e-01, -8.940325e-01,  3.531223e-01, -1.009921e+00, -4.922712e-01},
  {-9.068421e-03, -6.007432e-01, -7.993906e-01,  3.305901e-01, -1.004071e+00, -5.076728e-01},
  { 3.118569e-01,  3.953154e-01, -8.639855e-01,  3.170217e-01, -1.002391e+00, -5.080979e-01},
  {-3.398215e-01, -2.944582e-01, -8.932053e-01, -3.518915e-01, -1.010040e+00, -5.151303e-01},
  {-5.131722e-01, -5.776113e-01, -6.348382e-01, -1.215555e-01, -1.019922e+00, -5.471121e-01},
  {-8.094924e-01, -5.732464e-01,  1.269272e-01, -1.111514e-01, -1.019567e+00, -5.679172e-01},
  {-3.020828e-01, -1.788693e-01, -9.363502e-01, -2.289836e-01, -1.011167e+00, -5.464131e-01},
  { 4.315161e-01,  6.197734e-01,  6.554958e-01,  2.034090e-01, -1.017283e+00, -5.698621e-01},
  { 1.926638e-01,  4.994859e-01, -8.446268e-01,  1.154538e-01, -1.010571e+00, -7.046899e-01},
  {-4.610357e-01,  1.371855e-01, -8.767133e-01, -5.106004e-02, -1.012529e+00, -7.399836e-01},
  { 2.123457e-01,  5.910335e-02, -9.754056e-01, -1.546609e-01, -1.008215e+00, -7.496231e-01},
  {-7.240354e-02, -9.928427e-01, -9.498005e-02,  2.352232e-01, -9.933761e-01,  4.205586e-01},
  { 2.568626e-01, -8.028567e-01,  5.379987e-01,  2.146463e-01, -9.925526e-01,  4.243512e-01},
  { 1.533746e-02, -5.419804e-01,  8.402511e-01,  6.124271e-02, -9.734572e-01,  4.191965e-01},
  {-8.960645e-02, -9.902530e-01, -1.066287e-01,  2.658770e-01, -9.933149e-01,  3.942299e-01},
  {-2.252604e-01, -3.165615e-01,  9.214372e-01,  1.366130e-02, -9.769954e-01,  4.063489e-01},
  { 7.765033e-01, -4.102914e-01,  4.782297e-01,  2.705230e-01, -9.910135e-01,  3.689527e-01},
  {-4.005620e-01, -8.973351e-01, -1.853098e-01,  2.286010e-01, -9.913952e-01,  3.693545e-01},
  { 5.256815e-01, -6.044412e-01, -5.985898e-01,  1.868438e-01, -9.953783e-01,  3.848693e-01},
  {-7.227096e-01, -2.095662e-01,  6.586143e-01,  2.161661e-01, -9.974569e-01,  2.537363e-01},
  { 4.996900e-01,  9.740527e-03,  8.661495e-01, -1.453486e-01, -9.942275e-01,  2.405226e-01},
  {-3.300423e-01, -4.901783e-01,  8.067201e-01, -1.605198e-01, -9.919323e-01,  2.391773e-01},
  {-3.714734e-01, -5.715722e-01,  7.316507e-01, -1.773255e-01, -9.903710e-01,  2.333256e-01},
  { 9.944953e-01,  5.238519e-02, -9.074645e-02, -1.278595e-01, -9.842083e-01,  2.105313e-01},
  {-6.687161e-01,  5.831112e-01,  4.613025e-01,  7.361874e-02, -9.833288e-01,  1.725530e-01},
  { 8.898868e-01,  4.428858e-01,  1.093322e-01,  2.745727e-01, -9.946481e-01,  1.214635e-01},
  {-7.912717e-01, -2.739890e-01, -5.466436e-01,  1.721585e-01, -9.799745e-01,  5.749779e-03},
  {-9.485508e-01, -3.030714e-01, -9.164665e-02, -3.336616e-02, -9.859231e-01, -1.465876e-01},
  { 6.416282e-01,  3.123605e-01,  7.005314e-01,  8.041131e-02, -9.782336e-01, -1.336947e-01},
  { 4.820379e-01,  7.717544e-01,  4.147705e-01,  3.651212e-01, -1.005834e+00, -2.137273e-01},
  { 9.885301e-01, -1.405352e-01,  5.529958e-02, -1.434494e-01, -9.782181e-01, -2.013658e-01},
  { 4.844936e-01, -6.488379e-01, -5.867499e-01, -2.380313e-01, -1.000840e+00, -2.520985e-01},
  { 9.739829e-01, -6.738466e-02, -2.163716e-01,  3.643739e-01, -1.003585e+00, -2.639349e-01},
  { 9.819195e-01,  1.883437e-01, -1.899770e-02,  3.626272e-01, -9.902138e-01, -2.719434e-01},
  { 6.251767e-01, -7.552785e-01, -1.967451e-01, -2.514561e-01, -1.002033e+00, -2.666191e-01},
  { 6.424057e-01, -7.657735e-01, -3.009710e-02, -2.471598e-01, -9.953898e-01, -2.859984e-01},
  { 6.503143e-01, -3.729787e-01, -6.617992e-01,  3.517203e-01, -9.957857e-01, -2.888486e-01},
  { 7.970046e-02, -4.692763e-01, -8.794473e-01,  3.323718e-01, -9.888996e-01, -2.966231e-01},
  {-5.492119e-02, -3.795521e-01,  9.235387e-01, -1.263720e-01, -9.858707e-01, -3.193571e-01},
  { 6.540134e-01,  3.770447e-01, -6.558230e-01,  6.893629e-02, -9.874705e-01, -3.548461e-01},
  { 6.375690e-01,  5.010090e-01,  5.852314e-01,  6.361703e-02, -9.908677e-01, -4.048074e-01},
  {-7.771530e-01, -6.261593e-01,  6.291079e-02, -3.924954e-01, -9.862160e-01, -4.543548e-01},
  {-7.775527e-01, -4.568259e-01,  4.321132e-01, -9.720989e-02, -1.001394e+00, -4.523332e-01},
  { 6.176668e-01,  2.055101e-01, -7.591136e-01,  1.131586e-01, -9.821386e-01, -5.081615e-01},
  { 5.147585e-01,  8.098333e-01,  2.814139e-01,  9.812101e-02, -9.821958e-01, -5.535967e-01},
  {-5.667775e-01, -5.756065e-01, -5.894408e-01, -1.309359e-01, -9.936639e-01, -5.669751e-01},
  { 7.441202e-01,  6.595886e-01, -1.059620e-01,  2.853896e-01, -1.007285e+00, -6.165248e-01},
  { 7.663645e-01,  4.441641e-01, -4.641159e-01,  2.796466e-01, -1.001657e+00, -6.231044e-01},
  {-3.986183e-01,  3.194315e-01, -8.596900e-01, -2.270458e-01, -9.870726e-01, -7.106169e-01},
  { 3.049233e-01,  2.173962e-01, -9.272328e-01, -1.696558e-02, -9.941313e-01, -7.489353e-01},
  {-4.954163e-01, -8.668327e-01,  5.624592e-02,  2.227504e-01, -9.817607e-01,  3.466839e-01},
  {-5.795267e-01, -2.445111e-01,  7.774079e-01,  1.861731e-01, -9.788904e-01,  2.272504e-01},
  {-1.471360e-01,  3.038831e-02,  9.886494e-01,  1.657812e-01, -9.691319e-01,  2.205670e-01},
  { 9.576998e-01, -2.871395e-01, -1.902737e-02, -1.270881e-01, -9.779291e-01,  1.979947e-01},
  { 4.488353e-01, -5.932958e-01, -6.682418e-01,  3.569050e-01, -9.716141e-01, -3.578971e-03},
  {-6.763233e-01,  1.570326e-01,  7.196718e-01, -2.949549e-01, -9.741189e-01, -6.383531e-02},
  {-8.881092e-01,  1.952071e-01,  4.161204e-01, -3.128158e-01, -9.766437e-01, -8.801512e-02},
  {-8.885990e-01,  1.866002e-01, -4.190134e-01, -3.119181e-01, -9.683686e-01, -8.998116e-02},
  {-9.912240e-01,  7.419938e-02, -1.094049e-01, -2.128794e-01, -9.668013e-01, -1.592251e-01},
  {-1.532206e-01,  2.238123e-01,  9.625131e-01, -3.035465e-01, -9.843777e-01, -2.192066e-01},
  {-3.056967e-02,  3.012929e-01,  9.530415e-01, -2.916041e-01, -9.693880e-01, -2.206624e-01},
  { 6.572080e-01,  6.569870e-01,  3.693857e-01,  3.521717e-01, -9.807760e-01, -2.617077e-01},
  { 9.200960e-01,  3.809869e-01, -9.095166e-02,  3.605929e-01, -9.826331e-01, -2.732518e-01},
  { 8.836671e-01,  2.981339e-01, -3.609000e-01,  3.481239e-01, -9.701768e-01, -3.000986e-01},
  { 7.737907e-01,  2.841709e-01, -5.661226e-01,  1.230662e-01, -9.787804e-01, -3.116113e-01},
  { 1.604368e-01, -6.773173e-01,  7.179841e-01, -1.981757e-01, -9.811201e-01, -3.101269e-01},
  { 4.224751e-01,  2.215039e-01,  8.788918e-01,  6.006017e-02, -9.630110e-01, -4.180057e-01},
  { 1.715327e-01,  9.958085e-02,  9.801327e-01,  8.585503e-02, -9.671600e-01, -4.231221e-01},
  { 2.460779e-01, -6.841917e-02, -9.668322e-01,  1.697250e-01, -9.782938e-01, -4.768335e-01},
  {-7.697240e-01, -8.505946e-02, -6.326846e-01, -3.925074e-01, -9.781542e-01, -4.767896e-01},
  { 8.190070e-01,  5.461963e-01,  1.757760e-01,  7.610686e-02, -9.569704e-01, -5.612195e-01},
  {-5.309853e-01, -1.500862e-01, -8.339837e-01, -3.665401e-01, -9.637413e-01, -5.282534e-01},
  { 5.172504e-01,  8.535113e-01, -6.301241e-02,  2.543905e-01, -9.880655e-01, -6.241154e-01},
  {-1.896334e-01,  7.239597e-01, -6.632659e-01,  4.424800e-02, -9.658294e-01, -6.366077e-01},
  { 1.788463e-01,  8.382789e-01, -5.150751e-01,  2.268334e-02, -9.689729e-01, -6.375420e-01},
  {-9.602648e-02,  3.359756e-01, -9.369627e-01,  9.080626e-02, -9.755466e-01, -6.628566e-01},
  { 3.594237e-01,  8.261726e-01, -4.338818e-01,  2.174625e-02, -9.765543e-01, -6.588778e-01},
  {-1.404692e-01,  6.229182e-01, -7.695721e-01, -9.444455e-02, -9.744256e-01, -6.828945e-01},
  { 2.762358e-01,  1.368818e-01, -9.512924e-01, -2.457280e-01, -9.656053e-01, -7.060214e-01},
  { 4.492764e-01,  3.441006e-01, -8.244668e-01, -2.015733e-02, -9.831032e-01, -7.484059e-01},
  {-1.946687e-01,  4.397382e-01, -8.767750e-01, -1.996070e-01, -9.993155e-01, -7.433707e-01},
  { 3.374343e-01, -5.407532e-02,  9.397947e-01,  1.298267e-01, -9.480374e-01,  4.053468e-01},
  {-4.032488e-01,  8.047176e-02, -9.115453e-01, -4.592993e-03, -9.402173e-01,  4.069191e-01},
  {-4.993238e-01, -2.679506e-01, -8.239407e-01,  1.283414e-01, -9.459288e-01,  3.573631e-01},
  {-8.306912e-01, -4.779207e-01,  2.855591e-01,  1.962637e-01, -9.503965e-01,  2.654395e-01},
  {-4.698017e-02,  2.121028e-01,  9.761174e-01, -1.729474e-01, -9.611073e-01,  2.417165e-01},
  {-4.443848e-01, -8.123275e-04,  8.958356e-01, -1.967552e-01, -9.644237e-01,  2.379574e-01},
  { 4.110080e-01,  3.978031e-01,  8.202591e-01, -1.445386e-01, -9.569085e-01,  2.295868e-01},
  {-4.608569e-01, -8.677784e-01, -1.859349e-01, -2.342793e-01, -9.592052e-01,  1.318606e-01},
  { 5.859473e-01,  3.359402e-01,  7.374347e-01,  2.645511e-01, -9.518526e-01,  1.018137e-01},
  {-1.523204e-01, -6.415789e-01, -7.517812e-01,  1.377078e-01, -9.635137e-01,  8.829413e-02},
  {-8.846777e-01, -2.962028e-01, -3.600129e-01,  1.603026e-01, -9.579692e-01,  4.623229e-02},
  { 6.448818e-02, -5.871686e-01, -8.068917e-01,  2.269674e-01, -9.617816e-01,  2.983188e-02},
  { 8.403386e-01, -5.281415e-01, -1.220554e-01,  6.238361e-02, -9.600187e-01,  2.144597e-02},
  {-9.919570e-01,  6.927656e-02,  1.059347e-01, -1.084400e-02, -9.399830e-01, -6.965271e-02},
  {-6.743101e-01,  4.223174e-02, -7.372396e-01, -2.232050e-01, -9.584131e-01, -1.261111e-01},
  {-9.643574e-01,  1.619454e-01, -2.092570e-01, -2.151004e-01, -9.539080e-01, -1.403681e-01},
  {-8.838908e-01, -4.666409e-01, -3.135835e-02,  1.533300e-02, -9.654245e-01, -2.283374e-01},
  {-9.143918e-01, -2.400447e-01,  3.259848e-01,  1.540369e-02, -9.662470e-01, -2.340313e-01},
  {-7.893346e-01,  4.297976e-01,  4.384347e-01, -3.065751e-01, -9.473684e-01, -2.400929e-01},
  { 5.005611e-01, -8.349306e-01,  2.287563e-01, -2.058899e-01, -9.642011e-01, -2.846150e-01},
  { 6.092551e-01,  6.216910e-01,  4.922484e-01,  3.439150e-01, -9.551513e-01, -3.015434e-01},
  {-7.814900e-01,  1.717800e-01, -5.998042e-01, -2.710539e-01, -9.561313e-01, -3.230472e-01},
  { 8.693560e-01,  4.824307e-01,  1.071489e-01,  2.950003e-02, -9.472662e-01, -3.883571e-01},
  { 9.749155e-01,  1.840061e-01,  1.252254e-01,  3.598846e-01, -9.498968e-01, -4.154056e-01},
  {-3.489331e-01, -6.449655e-01, -6.799008e-01, -1.473885e-01, -9.644644e-01, -4.129156e-01},
  { 4.634430e-01,  1.775603e-01,  8.681549e-01,  4.614177e-02, -9.508016e-01, -4.166265e-01},
  {-6.188850e-01, -7.581605e-01,  2.053630e-01, -1.278650e-01, -9.616567e-01, -4.474733e-01},
  { 9.632146e-02, -6.920259e-01,  7.154176e-01, -2.414643e-01, -9.492589e-01, -4.638765e-01},
  {-5.132513e-02, -7.538939e-01,  6.549883e-01, -1.874986e-01, -9.627742e-01, -4.823909e-01},
  { 6.381527e-01,  5.244814e-01, -5.636314e-01,  7.954311e-02, -9.505635e-01, -5.252306e-01},
  {-6.956692e-01, -6.510901e-01,  3.035227e-01, -1.518255e-01, -9.704701e-01, -5.811370e-01},
  { 6.430465e-01,  7.194786e-01, -2.623771e-01, -8.353288e-03, -9.557319e-01, -6.439895e-01},
  {-5.830698e-01,  5.653743e-02, -8.104524e-01, -9.552953e-02, -9.552321e-01, -6.739604e-01},
  {-7.377959e-01,  1.562825e-01, -6.566833e-01, -5.911740e-02, -9.611976e-01, -7.071105e-01},
  {-4.609513e-01, -4.858184e-01, -7.426334e-01, -2.719750e-01, -9.665800e-01, -7.013930e-01},
  { 4.347318e-01,  2.129448e-01, -8.750216e-01, -2.650632e-01, -9.487389e-01, -7.159140e-01},
  { 3.359739e-01, -4.472095e-01,  8.289301e-01,  8.292538e-02, -9.374601e-01,  4.377493e-01},
  {-5.136164e-01,  2.368768e-02, -8.576929e-01, -3.615349e-02, -9.276175e-01,  4.261666e-01},
  {-4.669020e-01, -8.802926e-01, -8.418677e-02,  3.576758e-01, -9.232374e-01,  3.104773e-01},
  { 2.084997e-01, -9.561982e-01,  2.054578e-01,  3.788656e-01, -9.262695e-01,  3.072820e-01},
  { 9.775398e-01, -1.364091e-01,  1.606499e-01,  3.827462e-01, -9.204267e-01,  2.981779e-01},
  { 5.651962e-01, -7.667651e-01, -3.043428e-01,  3.735945e-01, -9.261315e-01,  2.858583e-01},
  {-4.524836e-01, -1.941493e-01,  8.703819e-01, -2.268385e-01, -9.373922e-01,  2.191149e-01},
  { 1.119180e-01, -3.835788e-01,  9.167015e-01, -2.501773e-01, -9.333020e-01,  2.152868e-01},
  {-7.874563e-01, -5.264532e-01,  3.205611e-01, -3.218814e-01, -9.286725e-01,  1.203310e-01},
  {-4.867853e-01, -5.405111e-01, -6.862127e-01, -2.244706e-01, -9.435763e-01,  9.905276e-02},
  {-3.378533e-01, -3.894531e-01, -8.568438e-01, -2.314053e-01, -9.344774e-01,  9.596139e-02},
  {-1.135307e-01, -9.082434e-01, -4.027465e-01, -3.389485e-01, -9.236928e-01,  7.551423e-02},
  { 8.821077e-01, -3.838608e-01, -2.730145e-01,  3.502934e-01, -9.304965e-01, -6.724197e-02},
  {-9.439223e-01,  2.834879e-01, -1.692496e-01, -3.048137e-01, -9.476451e-01, -8.730568e-02},
  { 7.026608e-01, -6.793779e-01, -2.114556e-01, -1.342352e-01, -9.374159e-01, -2.355513e-01},
  { 5.469112e-01, -8.371359e-01,  9.566819e-03, -1.875116e-01, -9.512324e-01, -2.735783e-01},
  { 4.006735e-01, -6.479622e-01,  6.477697e-01, -1.717949e-01, -9.458316e-01, -2.982413e-01},
  { 5.582639e-01,  1.880968e-01, -8.080601e-01,  3.394406e-01, -9.504275e-01, -3.102116e-01},
  { 6.379369e-01,  6.928542e-01,  3.361391e-01,  3.164488e-01, -9.405380e-01, -3.078277e-01},
  {-7.685478e-01,  4.380801e-01,  4.662832e-01, -4.061900e-01, -9.241384e-01, -3.207761e-01},
  {-4.862308e-02, -9.078506e-01,  4.164649e-01, -3.869193e-01, -9.296097e-01, -3.257636e-01},
  {-8.041133e-01, -5.011128e-01,  3.198245e-01, -4.215605e-01, -9.304176e-01, -3.501027e-01},
  {-7.149134e-01, -6.771796e-01,  1.741453e-01, -4.229903e-01, -9.315950e-01, -3.610995e-01},
  {-5.364186e-01, -8.062248e-01, -2.495129e-01, -1.385555e-01, -9.532015e-01, -4.368142e-01},
  {-8.466688e-01,  1.931211e-02, -5.317696e-01, -4.145175e-01, -9.385414e-01, -4.357910e-01},
  {-7.375605e-01,  4.062456e-01, -5.394154e-01, -3.641355e-01, -9.341239e-01, -4.723368e-01},
  {-6.045167e-01,  6.009831e-01, -5.228565e-01, -3.606599e-01, -9.210681e-01, -4.591087e-01},
  { 3.872078e-01, -7.269810e-02, -9.191220e-01,  3.291563e-01, -9.280520e-01, -5.098174e-01},
  {-8.762560e-01,  1.206032e-01, -4.665085e-01, -3.623075e-01, -9.271543e-01, -5.270878e-01},
  {-6.564602e-01, -4.760109e-01, -5.852125e-01, -1.854376e-01, -9.441156e-01, -5.481687e-01},
  { 9.130837e-01,  2.460484e-01,  3.251742e-01,  6.455198e-02, -9.310048e-01, -5.544971e-01},
  {-4.418849e-01, -7.505490e-01,  4.913388e-01, -1.697948e-01, -9.505765e-01, -5.699454e-01},
  { 8.676826e-01,  1.902145e-01,  4.592879e-01,  6.921460e-02, -9.409803e-01, -5.652316e-01},
  { 2.101904e-02,  5.242077e-01, -8.513310e-01, -5.434075e-03, -9.307015e-01, -6.049169e-01},
  { 6.491281e-01,  3.112360e-01,  6.940929e-01,  1.024438e-01, -9.420166e-01, -6.038401e-01},
  { 4.340735e-01,  8.243921e-01, -3.632600e-01,  1.886756e-01, -9.441652e-01, -6.327960e-01},
  { 5.554775e-01,  7.324015e-01, -3.937421e-01,  1.960046e-01, -9.496984e-01, -6.374993e-01},
  { 4.806800e-01,  5.437238e-01,  6.879761e-01,  1.192484e-01, -9.302903e-01, -6.212960e-01},
  {-6.269649e-01, -5.224263e-02, -7.772938e-01, -1.559478e-01, -9.271910e-01, -6.388921e-01},
  { 4.255737e-01,  6.135335e-01, -6.651794e-01, -2.173315e-01, -9.345387e-01, -6.556083e-01},
  {-8.113112e-01, -5.378296e-01,  2.291581e-01, -3.131209e-01, -9.319573e-01, -6.704255e-01},
  {-5.345177e-01, -1.407611e-01, -8.333529e-01, -2.939368e-01, -9.296400e-01, -7.030146e-01},
  { 5.706386e-01,  8.186031e-01,  6.527308e-02, -2.705747e-01, -9.444126e-01, -7.219871e-01},
  { 9.701425e-01,  0.000000e+00,  2.425356e-01,  1.853418e-01, -8.991577e-01,  5.509948e-01},
  { 9.701425e-01,  0.000000e+00,  2.425356e-01,  1.955934e-01, -8.928186e-01,  5.523893e-01},
  { 5.278717e-01, -8.274361e-01,  1.915749e-01,  1.836168e-01, -9.016553e-01,  5.384310e-01},
  {-3.019394e-01, -6.586716e-01,  6.891912e-01,  1.529261e-01, -9.063308e-01,  5.386835e-01},
  { 5.217201e-01, -7.607353e-01, -3.861217e-01,  1.356096e-01, -9.070856e-01,  4.892567e-01},
  { 6.485032e-01, -4.821683e-01,  5.890309e-01,  3.624028e-01, -9.085898e-01,  4.596903e-01},
  { 0.000000e+00, -7.071068e-01, -7.071068e-01,  3.555333e-01, -9.057344e-01,  4.644298e-01},
  { 5.467898e-01, -7.458723e-01, -3.803885e-01,  1.352057e-01, -9.022626e-01,  4.822389e-01},
  { 6.136409e-01, -7.457419e-01,  2.594492e-01,  1.192569e-01, -9.103013e-01,  4.680402e-01},
  { 5.182363e-01, -8.374910e-01, -1.733203e-01,  1.269890e-01, -9.026170e-01,  4.683190e-01},
  { 3.768238e-01, -8.610091e-01,  3.415655e-01,  1.022593e-01, -9.252118e-01,  4.425470e-01},
  { 3.768238e-01, -8.610091e-01,  3.415655e-01,  3.687876e-01, -9.064020e-01,  4.327896e-01},
  {-2.762145e-01, -5.759525e-01,  7.694052e-01, -5.574276e-02, -9.086484e-01,  4.384212e-01},
  {-2.762145e-01, -5.759525e-01,  7.694052e-01,  3.692468e-01, -9.062711e-01,  4.289819e-01},
  { 6.331702e-01, -4.304528e-01, -6.432774e-01,  3.699112e-01, -9.000470e-01,  4.278373e-01},
  { 8.115240e-01,  2.790750e-01,  5.133674e-01,  3.503474e-01, -9.032009e-01,  3.326316e-01},
  { 5.403253e-01, -5.332836e-01, -6.508895e-01,  3.830033e-01, -9.009963e-01,  2.577400e-01},
  { 6.285419e-01,  3.133246e-01,  7.118727e-01, -2.627320e-01, -9.165488e-01,  2.347919e-01},
  {-4.401415e-01, -7.703308e-01,  4.613738e-01, -2.715520e-01, -9.118711e-01,  2.394580e-01},
  {-8.560882e-01, -1.703361e-01,  4.879536e-01,  1.577689e-01, -9.118834e-01,  2.297625e-01},
  { 9.129931e-01, -3.013682e-01,  2.749923e-01, -9.855959e-02, -9.225269e-01,  1.919527e-01},
  {-8.360453e-01, -4.352073e-01,  3.341000e-01, -2.881340e-01, -9.190636e-01,  1.974818e-01},
  { 3.827661e-01, -7.418980e-01,  5.505247e-01, -8.468372e-02, -9.185981e-01,  1.783892e-01},
  { 6.825168e-01, -4.054461e-01,  6.080990e-01, -7.074958e-02, -9.056143e-01,  1.812833e-01},
  { 9.442584e-01,  3.090591e-01,  1.133957e-01,  2.465002e-01, -9.276254e-01,  1.385975e-01},
  {-8.107618e-01,  1.748631e-01,  5.586483e-01,  7.381929e-02, -9.241261e-01,  1.215607e-01},
  { 7.181097e-01,  1.925672e-01,  6.687573e-01,  2.564344e-01, -9.011854e-01,  8.956584e-02},
  {-2.512478e-01, -6.078129e-01, -7.532849e-01,  1.292236e-01, -9.304404e-01,  5.963082e-02},
  { 8.685086e-01,  2.833374e-01, -4.067098e-01,  3.376165e-01, -9.168397e-01,  4.040415e-02},
  {-4.971171e-01, -5.585128e-01, -6.640316e-01,  1.381909e-01, -9.192106e-01,  4.958659e-02},
  { 4.620359e-01, -6.243258e-01, -6.298732e-01,  1.010521e-01, -9.266396e-01,  4.889638e-02},
  { 3.727156e-01, -3.882116e-01, -8.428374e-01, -3.578717e-01, -9.036966e-01,  3.575466e-02},
  {-8.403224e-02,  8.358017e-01,  5.425625e-01, -3.723499e-01, -9.032790e-01,  3.889422e-02},
  { 1.132733e-01, -6.269680e-01, -7.707660e-01, -3.778940e-01, -8.956273e-01,  2.624826e-02},
  { 7.274023e-01, -1.906287e-01,  6.592015e-01,  3.587212e-01, -9.133532e-01, -7.680193e-02},
  {-1.489568e-01, -8.075906e-01, -5.706218e-01,  3.267592e-01, -9.139902e-01, -1.085985e-01},
  { 9.619721e-01,  2.207588e-01,  1.608582e-01,  5.956738e-02, -9.094395e-01, -1.251963e-01},
  {-8.526040e-01, -1.673852e-01, -4.950239e-01, -2.992533e-01, -9.191113e-01, -1.061868e-01},
  {-9.027249e-01,  2.843264e-01,  3.228717e-01, -2.034233e-01, -9.079905e-01, -1.859477e-01},
  {-2.493335e-01,  4.427265e-01,  8.612933e-01, -3.283830e-01, -9.180248e-01, -2.559550e-01},
  {-5.085117e-01, -4.077132e-01,  7.584101e-01, -2.955289e-02, -9.261772e-01, -2.712235e-01},
  { 3.127279e-01,  1.555221e-02, -9.497155e-01,  1.086983e-01, -9.267259e-01, -3.060515e-01},
  { 3.987283e-01, -8.339211e-01,  3.815644e-01, -1.531363e-01, -9.272587e-01, -2.897419e-01},
  {-5.848784e-01, -3.191868e-01,  7.456788e-01, -3.787097e-01, -9.102820e-01, -2.968443e-01},
  { 4.420063e-02, -6.656819e-01,  7.449254e-01, -1.324771e-01, -9.237416e-01, -2.975104e-01},
  {-6.467497e-01, -5.906603e-01, -4.825301e-01, -2.552142e-01, -9.324525e-01, -3.429531e-01},
  {-9.768458e-01,  1.680359e-01,  1.324242e-01, -4.264589e-01, -9.175295e-01, -3.972690e-01},
  { 2.775412e-01, -8.301252e-01,  4.835937e-01, -2.987041e-01, -9.308171e-01, -4.146966e-01},
  {-4.733072e-01, -8.673437e-01, -1.539327e-01, -1.923111e-01, -9.329104e-01, -4.461652e-01},
  { 4.749628e-02, -9.131420e-01,  4.048651e-01, -2.623863e-01, -9.255185e-01, -4.245370e-01},
  {-1.309025e-01,  4.702265e-01, -8.727838e-01, -3.657803e-01, -9.181560e-01, -4.537630e-01},
  { 8.944287e-03,  3.515556e-01, -9.361243e-01, -1.823383e-02, -9.073685e-01, -5.952708e-01},
  { 5.154027e-01,  6.547321e-01, -5.528886e-01, -2.767469e-02, -9.214142e-01, -6.110631e-01},
  { 6.926575e-01,  6.707644e-01, -2.651427e-01,  1.804903e-01, -9.330651e-01, -6.417632e-01},
  {-2.432634e-02,  4.021285e-01, -9.152600e-01, -1.825199e-01, -9.216583e-01, -6.351439e-01},
  { 7.152881e-01,  6.627052e-01, -2.217764e-01, -3.651455e-02, -9.249004e-01, -7.149547e-01},
  {-1.815323e-01,  2.304649e-01, -9.559979e-01, -4.729947e-02, -9.209281e-01, -7.267026e-01},
  {-3.139556e-01,  1.310193e-01,  9.403541e-01,  1.425314e-01, -8.877867e-01,  5.345938e-01},
  {-2.784609e-01, -8.381760e-01,  4.689569e-01,  3.384848e-01, -8.903847e-01,  4.639068e-01},
  {-9.185927e-02, -7.001072e-01,  7.081044e-01,  4.505045e-02, -9.078088e-01,  4.447783e-01},
  { 8.963403e-01, -1.056975e-01,  4.305836e-01,  3.419135e-01, -8.907462e-01,  3.486534e-01},
  { 8.169091e-01, -5.752465e-01,  4.184338e-02,  3.387046e-01, -8.823708e-01,  3.609322e-01},
  { 6.164253e-01, -5.661468e-01,  5.472639e-01,  3.300598e-01, -8.835007e-01,  3.695006e-01},
  { 9.885203e-01,  6.961388e-02,  1.340949e-01,  3.840950e-01, -9.046476e-01,  2.870947e-01},
  {-6.735772e-01, -6.244467e-01, -3.954239e-01,  1.681949e-01, -9.084859e-01,  2.856703e-01},
  { 9.861912e-01,  1.212772e-01,  1.127780e-01,  3.858650e-01, -8.964539e-01,  2.707697e-01},
  { 4.996267e-01,  6.811902e-01,  5.351198e-01, -2.809657e-01, -9.020717e-01,  2.372825e-01},
  { 3.062747e-01,  7.015788e-01,  6.434152e-01, -2.862333e-01, -8.915048e-01,  2.282679e-01},
  { 4.750286e-02, -1.433959e-01,  9.885247e-01, -7.616882e-02, -9.034805e-01,  1.876390e-01},
  { 4.097687e-01, -7.462730e-01, -5.245630e-01, -2.772931e-02, -8.833289e-01,  1.779933e-01},
  {-4.542758e-02,  6.963891e-01,  7.162252e-01, -1.776597e-01, -9.025909e-01,  1.780683e-01},
  { 9.455974e-01,  1.333817e-01,  2.967403e-01,  2.359423e-01, -8.957719e-01,  1.246461e-01},
  { 7.338274e-01,  3.071270e-01,  6.059459e-01,  3.622120e-01, -9.132370e-01,  7.977739e-02},
  { 7.216423e-01,  2.967469e-01,  6.254389e-01,  3.580932e-01, -9.048550e-01,  7.605300e-02},
  {-9.574088e-01,  1.627793e-01,  2.384771e-01, -2.152836e-02, -9.067010e-01,  1.292024e-02},
  {-6.271316e-01, -3.945657e-01, -6.715830e-01,  1.775660e-01, -8.984985e-01, -3.048124e-02},
  {-3.819282e-01, -4.896922e-01, -7.837936e-01,  1.763458e-01, -8.871944e-01, -3.674595e-02},
  {-7.471892e-01, -3.231788e-01, -5.807442e-01, -2.989050e-01, -8.894374e-01, -1.211213e-01},
  {-5.256817e-01, -2.388895e-01, -8.164500e-01, -2.172383e-01, -9.022241e-01, -1.428558e-01},
  {-8.605360e-01, -1.739076e-01, -4.787838e-01, -2.055551e-01, -8.888752e-01, -1.589072e-01},
  {-6.921661e-01, -7.195931e-01, -5.560308e-02, -3.022592e-02, -9.083524e-01, -2.353102e-01},
  {-7.109463e-01, -2.933755e-01,  6.391292e-01, -3.540256e-01, -9.080660e-01, -2.731091e-01},
  { 4.112934e-01, -9.101958e-01, -4.879903e-02, -1.208745e-01, -9.091969e-01, -2.807881e-01},
  {-8.569883e-01, -4.969849e-01,  1.362980e-01,  3.089735e-01, -9.021985e-01, -3.044839e-01},
  { 8.979470e-02, -2.984369e-01, -9.501959e-01,  1.583108e-01, -9.069278e-01, -3.042120e-01},
  { 2.504061e-01,  6.565170e-01,  7.115351e-01,  3.059820e-01, -8.984872e-01, -3.097605e-01},
  { 5.781610e-02, -8.632740e-01,  5.014132e-01, -9.864222e-02, -9.069350e-01, -2.881026e-01},
  {-4.423107e-01, -8.665391e-01, -2.312387e-01, -2.697732e-01, -9.150013e-01, -3.515227e-01},
  {-2.822267e-01, -9.587349e-01, -3.428359e-02, -2.326544e-01, -9.235945e-01, -4.000041e-01},
  {-1.422271e-01, -9.884247e-01,  5.280271e-02, -2.502574e-01, -9.193739e-01, -3.982173e-01},
  { 2.624289e-01,  8.070951e-02,  9.615701e-01,  3.512259e-01, -8.989823e-01, -4.119539e-01},
  { 6.910357e-01,  4.226719e-01, -5.863602e-01,  2.920438e-01, -8.964633e-01, -4.579914e-01},
  { 7.895330e-01,  5.476043e-01, -2.770690e-01,  2.775752e-01, -8.885834e-01, -4.759536e-01},
  { 7.759135e-01,  6.100594e-01, -1.605795e-01,  3.228624e-01, -9.105824e-01, -5.155845e-01},
  {-3.211272e-01, -3.609424e-01, -8.755558e-01, -2.567665e-01, -9.088549e-01, -5.276359e-01},
  { 4.850560e-02, -2.677263e-01, -9.622733e-01, -2.838375e-01, -9.059029e-01, -5.280180e-01},
  {-4.673268e-01, -6.831656e-01, -5.611510e-01, -2.199430e-01, -9.154133e-01, -5.337909e-01},
  {-7.448597e-01, -4.594997e-01, -4.837810e-01, -3.639740e-01, -8.863245e-01, -5.405695e-01},
  {-5.459183e-01, -8.135146e-01,  2.004174e-01, -2.238525e-01, -9.112659e-01, -5.533453e-01},
  {-6.061016e-01, -6.747593e-01,  4.211184e-01, -2.604904e-01, -8.954380e-01, -5.790373e-01},
  {-7.194653e-01, -2.387960e-01, -6.521858e-01, -1.548276e-01, -9.067987e-01, -6.404374e-01},
  {-8.204022e-01, -5.419996e-01,  1.821443e-01, -3.330996e-01, -8.884007e-01, -6.534109e-01},
  { 4.611477e-01,  8.554629e-01,  2.356396e-01,  1.528487e-01, -9.148400e-01, -6.483020e-01},
  {-5.609851e-01, -3.523819e-01, -7.490813e-01, -3.147895e-01, -8.945155e-01, -6.944781e-01},
  {-5.288715e-02,  5.759796e-02, -9.969380e-01, -1.247885e-01, -8.954113e-01, -7.265373e-01},
  {-1.923401e-02, -6.429123e-02, -9.977458e-01, -1.271565e-01, -8.901139e-01, -7.280799e-01},
  {-5.418848e-02, -8.103834e-01,  5.833885e-01,  3.125549e-01, -8.665519e-01,  5.026292e-01},
  { 2.179129e-02, -8.428740e-01,  5.376695e-01,  3.268835e-01, -8.778799e-01,  4.798926e-01},
  {-7.081962e-01, -7.041065e-01, -5.188718e-02,  3.182427e-01, -8.734812e-01,  4.475430e-01},
  {-6.861366e-02, -4.686878e-01,  8.806952e-01, -5.466412e-02, -8.742211e-01,  4.645796e-01},
  { 9.059578e-01, -7.630767e-02,  4.164345e-01,  3.794945e-01, -8.763592e-01,  4.281883e-01},
  {-7.247003e-01, -6.385875e-01,  2.588732e-01,  3.256899e-01, -8.765676e-01,  4.094362e-01},
  { 3.069749e-02, -9.224846e-01, -3.848114e-01,  3.328409e-01, -8.813460e-01,  3.967657e-01},
  {-8.679446e-01, -4.633822e-01, -1.787436e-01,  3.121522e-01, -8.715538e-01,  3.167327e-01},
  { 9.325053e-01,  3.514699e-01, -8.308294e-02,  3.829002e-01, -8.837407e-01,  2.559522e-01},
  { 3.164967e-01, -4.259629e-01, -8.475762e-01,  3.630708e-01, -8.678262e-01,  2.234824e-01},
  {-6.469433e-02, -5.363740e-01, -8.414972e-01,  3.585927e-01, -8.631537e-01,  2.221816e-01},
  { 2.894657e-01,  3.039064e-01,  9.076621e-01, -1.427221e-02, -8.706841e-01,  1.672403e-01},
  { 3.382635e-01,  4.798341e-01,  8.095289e-01, -2.076332e-01, -8.763673e-01,  1.490710e-01},
  { 7.605523e-01, -6.017467e-01, -2.438468e-01, -1.233913e-01, -8.888420e-01,  9.086935e-02},
  {-7.380605e-01, -4.856172e-01,  4.684471e-01, -3.367719e-01, -8.670548e-01,  8.153616e-02},
  { 8.193660e-01, -1.945965e-02,  5.729402e-01,  3.542879e-01, -8.791783e-01,  6.969853e-02},
  { 1.838327e-01,  2.181176e-01,  9.584520e-01,  2.840424e-01, -8.826899e-01,  7.575236e-02},
  {-5.291587e-01, -4.469877e-01, -7.212441e-01,  1.451769e-01, -8.915665e-01,  2.809940e-02},
  {-3.549225e-01, -5.528573e-01, -7.539091e-01,  1.835010e-01, -8.752191e-01, -4.706851e-02},
  { 9.736538e-01, -1.073614e-01,  2.011757e-01,  3.645494e-01, -8.759994e-01, -9.747431e-02},
  {-3.200214e-01, -4.274285e-01, -8.455124e-01,  2.595956e-01, -8.635548e-01, -1.109569e-01},
  {-8.925043e-01, -3.681161e-01,  2.606275e-01, -2.136990e-02, -8.795208e-01, -1.072607e-01},
  { 9.133303e-01, -2.254936e-01, -3.390872e-01,  3.648669e-01, -8.843257e-01, -1.268184e-01},
  { 2.828115e-01, -4.410422e-01, -8.517625e-01,  3.559119e-01, -8.828331e-01, -1.392074e-01},
  { 4.709888e-01,  2.622790e-01,  8.422466e-01,  1.504564e-01, -8.760482e-01, -2.352243e-01},
  { 1.304518e-01, -9.154423e-01,  3.807202e-01, -8.203700e-02, -8.944970e-01, -2.736877e-01},
  {-4.265846e-01,  7.264007e-01,  5.388578e-01, -3.622193e-01, -8.938156e-01, -2.876887e-01},
  {-3.940654e-01,  8.475329e-01,  3.555284e-01, -3.572659e-01, -8.866910e-01, -3.015160e-01},
  {-3.578002e-01,  5.333998e-01,  7.664618e-01, -3.550723e-01, -8.700586e-01, -3.698521e-01},
  { 8.378605e-01,  2.663368e-01,  4.765025e-01,  1.356738e-02, -8.773404e-01, -3.976434e-01},
  { 7.078801e-01,  3.480939e-02, -7.054743e-01,  2.871212e-01, -8.812287e-01, -4.548818e-01},
  {-6.489355e-01,  3.309756e-01, -6.850824e-01, -4.199384e-01, -8.901973e-01, -4.401870e-01},
  {-6.988398e-03,  4.418777e-01, -8.970481e-01,  6.935805e-02, -8.772989e-01, -4.766256e-01},
  {-8.892401e-01,  4.347039e-01,  1.424241e-01, -3.181197e-01, -8.779078e-01, -4.792510e-01},
  {-5.060546e-01, -8.390312e-01, -1.998384e-01, -2.577746e-01, -8.878642e-01, -5.520970e-01},
  {-6.592368e-02,  2.640072e-01, -9.622651e-01, -2.441642e-02, -8.731657e-01, -5.838103e-01},
  {-1.731611e-01,  2.974876e-01, -9.388909e-01, -3.915970e-02, -8.684120e-01, -5.805525e-01},
  {-8.808529e-01, -4.433605e-01, -1.659200e-01, -1.505321e-01, -8.964978e-01, -6.605850e-01},
  { 5.037590e-01,  7.080752e-01, -4.948297e-01,  1.229485e-01, -8.946446e-01, -6.540853e-01},
  {-8.159548e-02,  2.057281e-01, -9.752015e-01,  7.198510e-02, -8.858296e-01, -6.573753e-01},
  {-7.733829e-01, -6.338738e-01,  9.105269e-03, -3.391878e-01, -8.835249e-01, -6.709629e-01},
  {-3.280482e-01, -1.938331e-01, -9.245611e-01, -3.333594e-01, -8.803863e-01, -6.919152e-01},
  {-7.468003e-01, -5.962227e-01, -2.946316e-01, -1.671592e-01, -8.776987e-01, -7.084850e-01},
  { 1.634010e-01,  7.042673e-01, -6.908745e-01, -9.950424e-02, -8.886373e-01, -7.213144e-01},
  {-6.140659e-01, -4.108771e-02, -7.881846e-01, -1.514016e-01, -8.808433e-01, -7.234223e-01},
  {-7.071068e-01,  7.071068e-01,  0.000000e+00,  3.104548e-01, -8.582911e-01,  5.106757e-01},
  {-5.497028e-01, -5.568849e-01,  6.226604e-01,  3.068982e-01, -8.552152e-01,  5.105953e-01},
  { 7.023083e-02, -2.756668e-01,  9.586843e-01, -3.871550e-02, -8.471958e-01,  4.789459e-01},
  {-3.309786e-01, -1.057800e-01,  9.376907e-01,  4.417990e-02, -8.735399e-01,  4.631004e-01},
  { 8.403206e-01, -4.737312e-01,  2.635147e-01,  1.431348e-01, -8.692592e-01,  4.081668e-01},
  {-8.117800e-01, -5.778758e-01,  8.410003e-02,  3.035153e-01, -8.606977e-01,  3.467536e-01},
  { 2.722040e-01, -7.570354e-01,  5.939717e-01, -1.229460e-02, -8.519897e-01,  2.968269e-01},
  {-7.060149e-02, -9.910490e-01,  1.133025e-01, -5.575379e-02, -8.418128e-01,  3.112049e-01},
  { 9.262245e-01,  3.764360e-01,  2.010598e-02,  3.760296e-01, -8.638693e-01,  2.558951e-01},
  { 8.212461e-01, -4.004236e-01,  4.064674e-01,  1.007113e-02, -8.525041e-01,  2.741408e-01},
  {-2.870933e-01, -8.691467e-01, -4.026929e-01, -1.287045e-02, -8.508326e-01,  2.761640e-01},
  { 5.392119e-01, -8.376500e-01,  8.713745e-02,  1.373512e-04, -8.428967e-01,  1.925230e-01},
  { 1.281549e-01,  3.140708e-01,  9.407103e-01, -5.874037e-02, -8.485815e-01,  1.735448e-01},
  {-7.725529e-01, -7.279368e-02,  6.307639e-01, -3.500139e-01, -8.598703e-01,  6.322548e-02},
  {-7.018521e-01, -1.684863e-01,  6.921098e-01, -4.025076e-01, -8.498582e-01,  1.243016e-02},
  {-7.980404e-01, -3.597684e-01,  4.834234e-01, -2.035591e-02, -8.605572e-01, -1.041484e-02},
  {-9.917585e-01,  4.573925e-02, -1.196783e-01, -2.010612e-01, -8.551719e-01,  1.354991e-04},
  { 8.032286e-01, -5.792075e-01,  1.390777e-01, -1.202680e-01, -8.704427e-01, -1.882454e-02},
  {-7.083879e-02, -7.276897e-01, -6.822385e-01,  2.255250e-01, -8.743979e-01, -4.356753e-02},
  {-3.624224e-01, -8.240632e-01, -4.353960e-01,  2.391937e-01, -8.684258e-01, -9.147780e-02},
  { 9.847790e-01, -1.222683e-02, -1.733804e-01,  3.672757e-01, -8.597624e-01, -1.227317e-01},
  {-4.809655e-01, -1.079141e-01, -8.700728e-01, -3.089157e-01, -8.700228e-01, -1.214512e-01},
  {-3.890518e-01, -2.732730e-01, -8.797503e-01,  2.368605e-01, -8.512498e-01, -1.066207e-01},
  {-5.508592e-01, -6.498407e-01,  5.236995e-01, -3.661430e-02, -8.666050e-01, -1.224131e-01},
  { 4.811223e-01,  3.205349e-02, -8.760673e-01,  3.580340e-01, -8.697513e-01, -1.355723e-01},
  { 7.178880e-01, -6.455372e-01,  2.606117e-01, -1.128763e-01, -8.750078e-01, -1.637275e-01},
  {-7.055802e-01, -4.219418e-01, -5.693170e-01, -2.108530e-01, -8.708099e-01, -1.603596e-01},
  {-4.628950e-01, -4.650300e-01, -7.546359e-01, -2.223227e-01, -8.742033e-01, -1.512774e-01},
  {-3.709337e-01, -8.912333e-01,  2.609811e-01, -7.899802e-02, -8.764767e-01, -1.970098e-01},
  {-1.864358e-01, -9.238521e-01,  3.342735e-01, -6.775309e-02, -8.831327e-01, -2.126495e-01},
  { 8.409976e-01,  5.126989e-01,  1.728090e-01,  2.762527e-01, -8.609884e-01, -3.073095e-01},
  { 7.767200e-01,  5.429254e-01,  3.192773e-01,  2.899870e-01, -8.718550e-01, -3.132217e-01},
  { 2.800118e-01, -9.866355e-02,  9.549130e-01,  3.880154e-02, -8.582914e-01, -4.097209e-01},
  {-6.276044e-01,  7.872258e-02, -7.745422e-01, -4.100074e-01, -8.590701e-01, -4.392469e-01},
  { 6.068880e-01,  3.635034e-01, -7.067901e-01,  2.506009e-01, -8.584599e-01, -4.721009e-01},
  {-8.341354e-01,  4.109311e-01,  3.679044e-01, -2.983606e-01, -8.510464e-01, -4.560058e-01},
  {-7.875335e-01,  1.515159e-01,  5.973558e-01, -3.151826e-01, -8.545451e-01, -4.912863e-01},
  { 0.000000e+00,  6.585046e-01, -7.525767e-01,  2.942435e-01, -8.781617e-01, -5.280343e-01},
  {-2.899149e-01, -6.653342e-01, -6.879532e-01, -3.032038e-01, -8.655279e-01, -5.530965e-01},
  { 6.542203e-01,  5.587769e-01, -5.096709e-01,  2.666556e-01, -8.646814e-01, -5.364642e-01},
  { 1.649988e-01, -1.928868e-01, -9.672487e-01,  2.270219e-01, -8.640436e-01, -5.508175e-01},
  {-5.379205e-01, -8.429956e-01,  3.194684e-04, -2.716017e-01, -8.770524e-01, -5.654191e-01},
  {-9.581955e-01, -2.261025e-01,  1.753255e-01, -3.872337e-01, -8.510530e-01, -5.506774e-01},
  { 7.134531e-01,  6.994540e-01, -4.181816e-02,  9.835332e-02, -8.772675e-01, -6.424061e-01},
  { 2.200384e-01,  5.090123e-01, -8.321596e-01,  8.095208e-02, -8.737249e-01, -6.552354e-01},
  { 3.665938e-01,  4.901072e-01, -7.908248e-01, -3.062055e-01, -8.649123e-01, -6.760225e-01},
  {-7.539792e-01, -3.455916e-01, -5.586429e-01, -1.797331e-01, -8.518004e-01, -7.040470e-01},
  {-3.894504e-01, -8.292314e-02, -9.173070e-01, -3.358896e-01, -8.750657e-01, -6.918722e-01},
  { 5.298756e-01, -7.881774e-01,  3.130627e-01,  2.236235e-01, -8.273094e-01,  5.908223e-01},
  {-9.039862e-01, -4.197710e-01,  8.124874e-02,  3.013888e-01, -8.330150e-01,  5.131702e-01},
  { 3.548080e-04, -7.192177e-02,  9.974102e-01, -4.510228e-02, -8.426598e-01,  4.822451e-01},
  {-1.191489e-01, -2.726490e-02,  9.925020e-01,  4.104529e-02, -8.506959e-01,  4.701650e-01},
  {-3.015797e-01, -5.569269e-01,  7.738748e-01, -8.239563e-02, -8.432221e-01,  4.697891e-01},
  {-5.437583e-01, -8.325463e-01,  1.057998e-01, -1.074769e-01, -8.344909e-01,  4.435338e-01},
  { 9.320376e-01,  1.261112e-01, -3.397085e-01,  3.323055e-01, -8.326183e-01,  3.548030e-01},
  { 9.555847e-01,  1.278534e-01,  2.655396e-01,  1.871710e-01, -8.380022e-01,  3.598332e-01},
  {-1.540620e-01, -9.689085e-01, -1.936006e-01, -1.332187e-01, -8.331605e-01,  3.461003e-01},
  {-1.905777e-01, -9.699549e-01, -1.512208e-01, -1.423681e-01, -8.344321e-01,  3.517358e-01},
  {-2.293415e-01, -9.576457e-01, -1.741183e-01, -7.555198e-02, -8.362374e-01,  3.172677e-01},
  { 5.765532e-01, -7.177116e-01, -3.904824e-01,  1.213997e-02, -8.414990e-01,  2.540673e-01},
  { 9.815947e-01,  2.567192e-02, -1.892431e-01,  3.646937e-01, -8.369071e-01,  2.143469e-01},
  {-5.377669e-01, -8.139989e-01,  2.195734e-01, -4.941130e-03, -8.345845e-01,  2.079173e-01},
  { 2.192526e-01,  6.875396e-01,  6.922554e-01, -2.834550e-01, -8.509354e-01,  1.863538e-01},
  { 3.762598e-01,  6.503940e-01,  6.598607e-01, -2.958217e-01, -8.554262e-01,  1.934921e-01},
  {-6.964857e-01,  4.847671e-01,  5.290638e-01, -3.008314e-01, -8.508975e-01,  1.833484e-01},
  { 4.177162e-03, -7.694107e-01, -6.387407e-01,  3.249315e-01, -8.315238e-01,  1.888656e-01},
  { 2.091403e-01,  5.419295e-01,  8.139857e-01, -2.126124e-01, -8.354934e-01,  1.280613e-01},
  { 9.528231e-01,  2.595398e-02, -3.024146e-01,  3.585384e-01, -8.393271e-01,  6.237358e-02},
  {-8.460563e-01,  1.420631e-02,  5.329041e-01,  5.219895e-02, -8.423426e-01,  6.767317e-02},
  { 2.393858e-01, -6.487802e-01, -7.223424e-01,  1.228196e-01, -8.547956e-01,  9.676541e-03},
  { 7.731084e-01, -6.324380e-01,  4.822493e-02, -1.118430e-01, -8.456491e-01,  5.302839e-03},
  {-3.550586e-01, -6.319278e-01, -6.889127e-01, -4.298436e-01, -8.301138e-01,  1.010098e-03},
  { 8.949353e-01,  3.560705e-01,  2.688952e-01,  2.749861e-01, -8.308260e-01, -2.420379e-02},
  { 8.061846e-01,  2.664699e-01, -5.282614e-01,  5.847958e-02, -8.361838e-01, -6.406359e-02},
  { 8.838863e-01,  2.510270e-02,  4.670276e-01,  3.552842e-01, -8.390427e-01, -8.635089e-02},
  {-4.500723e-01, -8.541034e-01,  2.606574e-01, -4.131560e-02, -8.558178e-01, -1.033569e-01},
  { 9.529068e-01,  2.965318e-01,  6.354173e-02,  3.685025e-01, -8.385274e-01, -1.192345e-01},
  {-8.815041e-01,  3.577933e-01,  3.081143e-01, -3.017573e-01, -8.580400e-01, -1.239602e-01},
  {-9.008001e-01,  1.758643e-01, -3.970274e-01, -2.759328e-01, -8.398397e-01, -1.532752e-01},
  { 8.096578e-01,  2.172717e-01,  5.452039e-01,  8.152999e-02, -8.460039e-01, -1.911788e-01},
  { 6.959354e-01,  3.175687e-01,  6.440682e-01,  2.121431e-01, -8.425416e-01, -2.543293e-01},
  {-5.035943e-01,  4.743117e-01,  7.220951e-01, -2.418258e-01, -8.380668e-01, -3.079291e-01},
  {-2.697077e-02, -3.113536e-01, -9.499113e-01,  1.936458e-01, -8.458532e-01, -3.345800e-01},
  { 2.484525e-01, -1.467695e-01, -9.574602e-01,  2.566151e-01, -8.414639e-01, -3.306587e-01},
  {-7.644597e-02,  8.040214e-02, -9.938266e-01,  1.527686e-01, -8.332170e-01, -3.295738e-01},
  {-4.712590e-01,  6.550365e-01,  5.906286e-01, -2.912082e-01, -8.396640e-01, -3.496102e-01},
  { 9.424239e-01,  3.328287e-01, -3.259321e-02, -6.060027e-03, -8.420348e-01, -3.713789e-01},
  { 4.603988e-01, -1.858829e-01,  8.680326e-01,  6.599247e-03, -8.426830e-01, -3.974448e-01},
  {-7.625765e-01,  1.704981e-01, -6.240253e-01, -4.113654e-01, -8.386595e-01, -4.390595e-01},
  { 4.971887e-01,  2.363215e-01, -8.348386e-01,  3.007505e-02, -8.303120e-01, -4.681382e-01},
  {-6.989940e-02,  1.230971e-01, -9.899299e-01, -3.939700e-01, -8.396868e-01, -4.443383e-01},
  { 6.977083e-01,  7.107018e-01, -9.003372e-02,  2.124410e-01, -8.324273e-01, -5.019959e-01},
  { 2.435058e-01,  3.535553e-01, -9.031632e-01, -8.273122e-02, -8.372306e-01, -5.687803e-01},
  {-4.223862e-01, -7.455282e-01, -5.155364e-01, -3.078218e-01, -8.576432e-01, -5.580725e-01},
  {-8.443124e-01, -5.154226e-01,  1.465472e-01, -3.871169e-01, -8.357636e-01, -5.596198e-01},
  { 4.514036e-01,  2.998056e-01, -8.404472e-01,  2.316734e-01, -8.449382e-01, -5.517704e-01},
  {-2.729126e-01,  2.096629e-01, -9.389144e-01, -2.078383e-01, -8.454422e-01, -6.019115e-01},
  {-6.973992e-01, -6.905156e-01,  1.918919e-01, -3.127607e-01, -8.514270e-01, -5.922408e-01},
  {-2.099040e-01,  6.555831e-01, -7.253627e-01,  2.812085e-02, -8.476131e-01, -6.163814e-01},
  {-2.138661e-01, -4.723233e-01, -8.550860e-01, -1.961522e-01, -8.356071e-01, -7.024890e-01},
  {-1.448625e-01, -7.586443e-01, -6.351957e-01, -2.074121e-01, -8.224380e-01, -7.104073e-01},
  { 2.983449e-01, -4.918223e-01,  8.179860e-01,  2.160869e-01, -8.188804e-01,  6.079376e-01},
  {-3.606942e-01, -7.281958e-01,  5.827782e-01,  1.901867e-01, -8.197968e-01,  6.044295e-01},
  {-3.071063e-01, -1.674902e-01,  9.368206e-01,  1.888353e-01, -8.125077e-01,  6.104857e-01},
  { 7.074903e-01, -6.881150e-01, -1.611066e-01,  2.315338e-01, -8.227489e-01,  5.753036e-01},
  {-3.168036e-01,  5.822925e-01,  7.487128e-01,  6.452847e-02, -8.320040e-01,  4.698878e-01},
  {-4.388622e-01, -7.896463e-01,  4.287873e-01, -1.425916e-01, -8.228558e-01,  4.300402e-01},
  { 9.866316e-01, -1.463669e-01, -7.165841e-02,  3.962476e-01, -8.271453e-01,  4.149756e-01},
  { 5.470794e-01,  3.677281e-01,  7.519841e-01,  3.438756e-01, -8.145545e-01,  4.338230e-01},
  {-7.569323e-01, -3.706461e-01,  5.382147e-01, -1.825565e-01, -8.142701e-01,  3.971497e-01},
  {-7.350785e-01, -6.718647e-01,  9.086996e-02,  2.916604e-01, -8.351488e-01,  3.939060e-01},
  {-4.004969e-01, -9.160823e-01, -1.988520e-02, -1.766620e-01, -8.225285e-01,  3.702111e-01},
  {-8.990045e-01, -2.675340e-01,  3.467223e-01, -1.886229e-01, -8.118762e-01,  3.865480e-01},
  {-5.633522e-01, -8.229489e-01, -7.341255e-02, -1.864190e-01, -8.180534e-01,  3.567306e-01},
  {-9.450566e-01, -3.163259e-01,  8.249814e-02,  1.310635e-01, -8.332316e-01,  2.341527e-01},
  { 4.209510e-01, -8.893072e-01, -1.786981e-01,  1.637285e-02, -8.189620e-01,  2.237092e-01},
  {-4.809525e-01, -7.966657e-01, -3.660716e-01,  2.979991e-01, -8.184891e-01,  1.814811e-01},
  {-8.854613e-01, -3.081297e-01,  3.478714e-01,  9.973050e-02, -8.183566e-01,  1.626060e-01},
  {-1.079941e-01,  4.500205e-01,  8.864642e-01, -8.133382e-02, -8.287463e-01,  1.589041e-01},
  {-6.272593e-01,  3.660954e-01,  6.874008e-01, -3.082029e-01, -8.274711e-01,  1.519810e-01},
  { 9.327189e-01, -3.336939e-01,  1.366888e-01,  2.277037e-01, -8.318014e-01,  1.405889e-01},
  { 4.612837e-01, -9.439503e-02,  8.822170e-01,  2.720439e-01, -8.337111e-01,  7.819021e-02},
  { 9.406596e-01, -7.327978e-02, -3.313451e-01,  3.549218e-01, -8.168433e-01,  5.525745e-02},
  {-7.815988e-01, -1.419892e-01, -6.074061e-01, -2.049990e-01, -8.224305e-01,  1.158783e-02},
  { 3.843177e-01, -4.535016e-01, -8.041369e-01,  1.389648e-01, -8.372270e-01, -9.219779e-03},
  {-7.228459e-01, -4.741430e-01, -5.026751e-01,  1.480530e-01, -8.290367e-01, -3.144882e-02},
  {-5.838763e-02, -4.288740e-01, -9.014754e-01, -4.299598e-01, -8.128663e-01, -4.749290e-03},
  { 7.701128e-01, -1.346108e-01, -6.235433e-01,  6.719927e-02, -8.215587e-01, -4.882708e-02},
  { 1.149684e-01, -9.366125e-01,  3.309670e-01, -7.866139e-02, -8.332961e-01, -4.396170e-02},
  {-9.462616e-01,  3.142647e-01, -7.633207e-02, -1.902457e-01, -8.219920e-01, -4.216841e-02},
  { 9.988822e-01, -2.814719e-02,  3.797261e-02,  3.685986e-01, -8.179864e-01, -1.043271e-01},
  {-5.064850e-01, -4.993968e-01, -7.029053e-01,  1.764042e-01, -8.270960e-01, -8.418523e-02},
  { 9.976584e-01,  6.665762e-02, -1.531356e-02,  4.693675e-02, -8.233223e-01, -1.127927e-01},
  {-7.606902e-01,  3.470566e-01, -5.485455e-01, -2.826610e-01, -8.418858e-01, -1.355166e-01},
  {-2.835814e-01, -4.262362e-01, -8.590135e-01,  3.432849e-01, -8.251171e-01, -1.382228e-01},
  { 7.134872e-01, -6.499558e-02, -6.976472e-01,  3.571028e-01, -8.251077e-01, -1.422062e-01},
  {-6.689085e-01, -3.191833e-01, -6.713296e-01, -2.476307e-01, -8.164131e-01, -1.892086e-01},
  {-7.595723e-01, -3.532645e-01, -5.461265e-01, -1.860305e-01, -8.204433e-01, -2.331374e-01},
  { 7.295614e-01,  4.784081e-01, -4.887390e-01,  2.685013e-01, -8.406113e-01, -3.276170e-01},
  { 8.915318e-01,  2.847532e-01, -3.522592e-01, -5.090267e-03, -8.253749e-01, -3.423726e-01},
  {-2.193189e-01,  1.179505e-02, -9.755819e-01,  1.782625e-01, -8.248522e-01, -3.379365e-01},
  { 8.642083e-01,  1.173103e-02,  5.029973e-01, -6.341777e-03, -8.261133e-01, -3.823849e-01},
  {-1.983997e-01, -3.023537e-02,  9.796547e-01, -3.864616e-01, -8.312378e-01, -4.031942e-01},
  {-6.525348e-01, -6.635983e-02,  7.548475e-01, -2.785676e-01, -8.112350e-01, -4.481627e-01},
  {-6.235910e-01,  2.219510e-01, -7.495813e-01, -4.024114e-01, -8.257188e-01, -4.412834e-01},
  { 7.701712e-01,  5.650018e-01, -2.959890e-01,  5.764763e-03, -8.201346e-01, -4.898578e-01},
  { 7.807758e-01,  3.520194e-01, -5.162087e-01,  2.139952e-01, -8.304259e-01, -5.574266e-01},
  {-3.470604e-01, -3.031822e-01, -8.874850e-01,  1.763724e-01, -8.177233e-01, -5.604876e-01},
  {-3.996546e-01, -7.416182e-01, -5.387753e-01, -3.314957e-01, -8.402054e-01, -5.724350e-01},
  {-2.211095e-01,  4.109714e-01, -8.844281e-01,  1.070739e-03, -8.300304e-01, -5.941280e-01},
  { 6.921944e-01,  5.317690e-01, -4.879433e-01, -1.229204e-01, -8.260194e-01, -6.251709e-01},
  { 1.722043e-02,  2.507790e-01, -9.678912e-01, -3.693799e-01, -8.129969e-01, -6.764830e-01},
  { 6.655567e-01, -5.836706e-01,  4.651485e-01,  2.403387e-01, -8.101246e-01,  5.902994e-01},
  { 7.919508e-01, -5.660340e-01,  2.289531e-01,  2.142525e-01, -8.454521e-01,  5.624096e-01},
  {-7.375633e-01, -6.422594e-01,  2.085743e-01,  1.667430e-01, -8.082175e-01,  5.576761e-01},
  { 4.889805e-01, -7.837342e-01, -3.829606e-01,  2.097784e-01, -8.193338e-01,  5.264667e-01},
  { 1.376494e-01,  3.624861e-01,  9.217681e-01, -3.642397e-02, -8.149232e-01,  4.710488e-01},
  {-2.428586e-01,  4.439413e-01,  8.625172e-01, -9.557320e-02, -8.083202e-01,  4.668222e-01},
  {-4.382995e-01, -8.401874e-02,  8.948935e-01, -1.222928e-01, -8.048093e-01,  4.524852e-01},
  {-6.399493e-01,  5.952682e-02,  7.661079e-01, -1.434000e-01, -8.116033e-01,  4.436132e-01},
  { 4.746438e-02, -9.976616e-01, -4.917672e-02, -1.030778e-01, -8.173333e-01,  3.994169e-01},
  {-9.216048e-01, -2.351149e-01,  3.088132e-01, -1.940551e-01, -8.001029e-01,  3.763965e-01},
  { 8.832272e-01, -3.763783e-01,  2.797304e-01,  1.972709e-01, -8.185222e-01,  3.080291e-01},
  { 8.469920e-01, -5.300391e-01,  4.078251e-02,  2.318308e-01, -8.203104e-01,  1.794669e-01},
  { 1.027483e-01, -8.821834e-01, -4.595597e-01,  2.966477e-01, -8.023831e-01,  1.594317e-01},
  {-6.738053e-01,  4.534198e-02,  7.375165e-01, -3.300014e-01, -8.157333e-01,  1.317358e-01},
  {-7.514248e-01,  1.669884e-01,  6.383383e-01, -3.327544e-01, -8.117729e-01,  1.289213e-01},
  {-4.400214e-01, -1.861294e-01,  8.784856e-01, -3.439669e-01, -8.134790e-01,  1.120578e-01},
  { 8.224641e-01, -3.296829e-01,  4.635322e-01,  2.417901e-01, -8.186494e-01,  1.139869e-01},
  {-2.481059e-01,  4.228617e-01,  8.715684e-01, -1.622348e-01, -8.092257e-01,  1.113036e-01},
  { 6.598855e-01, -5.227697e-01,  5.396878e-01,  2.554783e-01, -8.185021e-01,  9.553955e-02},
  {-6.665516e-01, -5.732958e-01,  4.764881e-01, -4.311957e-01, -8.018411e-01,  6.509420e-02},
  { 4.633195e-01, -8.621734e-01, -2.049196e-01, -6.376119e-02, -8.069494e-01,  5.299512e-02},
  { 7.802954e-01,  1.843064e-01,  5.976372e-01,  2.619797e-01, -7.988588e-01, -9.565484e-03},
  { 1.859508e-03, -8.333654e-01,  5.527193e-01, -5.256394e-02, -8.160632e-01, -2.160853e-02},
  {-1.149206e-02, -6.647109e-01, -7.470122e-01, -4.402330e-01, -7.960005e-01, -1.429616e-02},
  {-6.616268e-01,  6.658823e-01,  3.447474e-01, -2.100100e-01, -8.203000e-01, -8.278458e-02},
  { 6.488152e-01, -6.918214e-01, -3.168942e-01,  3.640801e-01, -8.087485e-01, -1.557812e-01},
  { 9.864283e-01, -1.413364e-01, -8.356507e-02,  3.666404e-01, -7.955737e-01, -2.058378e-01},
  {-2.032792e-02, -8.681216e-01, -4.959351e-01,  3.590682e-01, -7.971780e-01, -2.302993e-01},
  { 5.180792e-01, -5.323534e-01, -6.694729e-01,  3.616488e-01, -7.953424e-01, -2.318117e-01},
  { 6.596353e-02,  5.976072e-02, -9.960309e-01,  9.619883e-02, -8.051316e-01, -3.256158e-01},
  {-7.104247e-01,  6.929954e-02,  7.003530e-01, -2.338940e-01, -7.987737e-01, -3.233758e-01},
  { 2.027170e-01,  3.165245e-01, -9.266704e-01,  2.156835e-01, -8.149278e-01, -3.383293e-01},
  {-1.128471e-01,  3.493951e-01, -9.301552e-01,  1.898937e-01, -8.137020e-01, -3.387560e-01},
  {-6.945971e-01, -5.098446e-01,  5.075365e-01, -4.107459e-01, -8.141962e-01, -4.044713e-01},
  {-7.576911e-01, -5.406876e-01, -3.654600e-01, -4.243754e-01, -8.032904e-01, -4.251186e-01},
  {-1.785825e-01,  1.528756e-01, -9.719760e-01,  5.236647e-02, -7.996801e-01, -4.599335e-01},
  { 5.366063e-01,  5.549721e-01, -6.356569e-01,  1.346936e-03, -7.926590e-01, -4.638879e-01},
  { 7.686533e-01,  2.595858e-01, -5.846257e-01,  1.991060e-01, -8.041597e-01, -4.968023e-01},
  {-5.673340e-01,  2.464121e-02,  8.231190e-01, -3.115654e-01, -8.025601e-01, -4.993121e-01},
  {-7.313960e-01,  2.993640e-01, -6.127326e-01, -2.198268e-01, -7.981836e-01, -5.801520e-01},
  { 4.956391e-01,  5.324212e-01, -6.861993e-01, -2.104321e-01, -8.115756e-01, -5.928466e-01},
  {-8.936332e-01, -4.479590e-01, -2.742961e-02, -2.057465e-01, -8.020925e-01, -6.210907e-01},
  {-6.612015e-01, -6.707624e-01,  3.359919e-01, -3.529621e-01, -8.195443e-01, -6.249726e-01},
  {-7.894855e-01, -5.979517e-01, -1.384432e-01, -3.854222e-01, -7.991461e-01, -6.688753e-01},
  {-7.276253e-01, -5.951791e-01, -3.410620e-01, -2.342092e-01, -8.019652e-01, -7.172681e-01},
  { 1.830890e-01, -3.014734e-01, -9.357308e-01, -2.194076e-01, -8.003067e-01, -7.275798e-01},
  { 3.571991e-01, -6.135889e-02,  9.320107e-01,  2.582273e-01, -7.852128e-01,  5.921922e-01},
  { 2.934681e-01,  2.746382e-01,  9.156693e-01,  2.419028e-01, -7.829224e-01,  5.957381e-01},
  {-4.048158e-01, -8.294412e-01,  3.849044e-01,  1.429575e-01, -7.763873e-01,  6.012518e-01},
  {-8.582573e-01, -2.970954e-01,  4.184839e-01,  1.508785e-01, -7.850050e-01,  5.203046e-01},
  { 1.001684e-01, -9.949352e-01, -8.385535e-03, -7.611289e-02, -8.153217e-01,  4.027171e-01},
  { 9.723074e-01, -2.008371e-01, -1.195099e-01,  3.926130e-01, -7.860390e-01,  3.977155e-01},
  { 7.869992e-01, -5.526711e-01,  2.742026e-01,  1.878309e-01, -7.955757e-01,  3.619388e-01},
  {-9.806382e-01,  1.537775e-01,  1.212485e-01, -2.045153e-01, -7.845994e-01,  3.459305e-01},
  {-6.055430e-01, -7.913393e-01, -8.426122e-02,  2.569649e-01, -7.953491e-01,  3.534198e-01},
  {-3.626511e-01, -8.953659e-01,  2.584644e-01,  2.414178e-01, -7.890011e-01,  3.360574e-01},
  {-1.848665e-01, -7.772641e-01, -6.014024e-01,  5.032598e-02, -7.993748e-01,  3.401567e-01},
  { 8.478210e-01,  5.251241e-01, -7.378457e-02,  3.037678e-01, -7.894534e-01,  3.212715e-01},
  {-8.793310e-03,  9.998914e-01,  1.182712e-02, -2.017300e-01, -7.843551e-01,  3.273461e-01},
  { 5.560681e-01, -7.295510e-01,  3.981753e-01,  2.118846e-01, -7.996873e-01,  3.044824e-01},
  {-8.793310e-03,  9.998914e-01,  1.182712e-02, -1.965829e-01, -7.841813e-01,  3.164788e-01},
  {-1.793347e-01, -9.801549e-01,  8.447085e-02,  2.295618e-01, -7.999583e-01,  2.876782e-01},
  {-4.942341e-01, -7.670991e-01, -4.090129e-01, -1.821246e-01, -7.814223e-01,  2.717104e-01},
  { 7.854522e-01, -3.067294e-01,  5.375704e-01,  1.254020e-02, -7.904499e-01,  2.596627e-01},
  {-3.315004e-01, -8.405887e-01, -4.283901e-01, -6.727280e-02, -7.980949e-01,  2.590572e-01},
  {-8.346592e-01, -5.507635e-01,  1.928820e-03,  1.109671e-01, -7.974180e-01,  2.393851e-01},
  {-8.580568e-01, -5.081585e-01,  7.425307e-02,  1.084299e-01, -7.975916e-01,  2.161418e-01},
  { 8.978362e-01, -3.479197e-01, -2.698928e-01,  3.773641e-01, -7.803438e-01,  1.778372e-01},
  { 4.615059e-01, -8.601349e-01, -2.172101e-01,  2.697775e-01, -7.956126e-01,  1.320560e-01},
  { 5.783569e-01, -8.157110e-01,  1.090161e-02,  2.466706e-01, -8.116053e-01,  1.376212e-01},
  {-2.492774e-01,  5.646832e-01,  7.867615e-01, -3.104831e-01, -8.006156e-01,  1.326727e-01},
  {-8.166999e-01, -3.546247e-01,  4.552391e-01,  7.382880e-02, -8.002712e-01,  1.172873e-01},
  { 5.462847e-01, -6.236588e-01,  5.591269e-01,  2.721912e-01, -7.970342e-01,  9.836286e-02},
  {-6.696114e-01, -5.302159e-01,  5.200882e-01,  3.978677e-02, -7.971801e-01,  7.226510e-02},
  { 4.885366e-01, -8.237450e-01, -2.877085e-01, -4.013246e-02, -7.985483e-01,  5.958254e-02},
  { 9.553388e-01, -1.741451e-01, -2.387492e-01,  3.620385e-01, -7.786467e-01,  5.972328e-02},
  { 3.358553e-01, -9.125906e-01,  2.331945e-01, -6.275064e-02, -8.006966e-01,  1.779887e-02},
  { 7.995884e-02, -4.228561e-01, -9.026623e-01, -3.169414e-01, -7.862044e-01,  3.051110e-02},
  {-2.151978e-01, -9.117926e-01,  3.497486e-01, -1.520806e-02, -8.017411e-01,  2.392749e-02},
  {-3.540747e-01, -7.717996e-01,  5.281634e-01, -4.357638e-02, -8.053438e-01,  7.970064e-04},
  {-8.600532e-01, -4.813052e-01, -1.692743e-01, -4.592001e-01, -7.896330e-01,  1.318382e-03},
  { 9.271151e-01,  2.435202e-01,  2.848780e-01,  3.617655e-01, -8.029352e-01, -9.228981e-02},
  { 9.867724e-01,  1.002247e-01, -1.274184e-01,  3.955515e-02, -7.791547e-01, -1.306465e-01},
  {-8.279408e-01,  5.605805e-01, -1.623156e-02, -2.428805e-01, -7.975252e-01, -1.881333e-01},
  {-6.050538e-01, -5.870821e-01, -5.378146e-01,  3.199388e-01, -7.759593e-01, -2.113058e-01},
  { 6.053583e-01,  2.289959e-01,  7.623006e-01,  1.292275e-01, -7.920947e-01, -2.138830e-01},
  {-6.196892e-01, -3.143456e-01, -7.191468e-01, -2.273867e-01, -7.931640e-01, -2.156540e-01},
  {-1.499669e-01, -4.903060e-01,  8.585511e-01, -4.167741e-01, -7.770627e-01, -2.283702e-01},
  {-3.614897e-01, -6.257662e-01,  6.911888e-01, -4.346156e-01, -7.821462e-01, -2.397325e-01},
  {-3.334966e-01, -5.807589e-01,  7.426298e-01, -4.276444e-01, -7.783428e-01, -2.345766e-01},
  {-9.893885e-01,  5.687959e-02,  1.336980e-01, -1.904837e-01, -7.963184e-01, -2.467628e-01},
  { 3.908263e-01,  7.628437e-01, -5.150965e-01,  1.396418e-01, -7.811255e-01, -2.868530e-01},
  {-1.782082e-01, -9.810434e-01, -7.612908e-02, -4.407944e-01, -7.838978e-01, -2.863461e-01},
  { 9.851905e-01,  1.119095e-01, -1.299074e-01,  2.234067e-01, -7.943131e-01, -3.024480e-01},
  { 1.946814e-01,  1.214969e-01, -9.733127e-01,  1.686873e-02, -7.877011e-01, -3.069461e-01},
  {-3.063199e-01, -2.218300e-01,  9.257211e-01, -2.397011e-01, -7.926067e-01, -3.284508e-01},
  {-4.823807e-01, -8.744220e-01,  5.191441e-02, -4.222369e-01, -7.866535e-01, -3.261806e-01},
  { 9.944764e-01,  5.053114e-02,  9.199577e-02, -1.925863e-02, -7.844852e-01, -3.690237e-01},
  { 9.055403e-01,  8.952933e-03,  4.241657e-01, -2.030750e-02, -7.909999e-01, -3.729542e-01},
  {-6.078901e-03, -7.497494e-01,  6.616939e-01, -3.312662e-01, -7.927615e-01, -3.535485e-01},
  { 7.191475e-02, -8.568640e-01,  5.105021e-01, -3.410078e-01, -8.010598e-01, -3.632605e-01},
  { 6.259205e-01,  3.458218e-01, -6.990213e-01,  3.333209e-01, -8.083696e-01, -4.373275e-01},
  {-5.080233e-01,  5.284553e-01, -6.801819e-01, -2.677985e-01, -7.762506e-01, -4.319754e-01},
  {-6.265104e-01,  1.833364e-01, -7.575437e-01, -4.426127e-01, -7.901447e-01, -4.179305e-01},
  { 2.403309e-01,  6.065038e-01, -7.578879e-01, -3.789208e-01, -7.882403e-01, -4.241442e-01},
  { 3.980142e-01, -5.656122e-03, -9.173618e-01,  3.071572e-01, -7.970234e-01, -4.551419e-01},
  { 5.314601e-01,  1.636916e-01, -8.311169e-01,  2.787797e-01, -7.892672e-01, -4.615394e-01},
  { 1.459032e-01, -2.323186e-03, -9.892962e-01, -7.155838e-02, -7.979380e-01, -5.623444e-01},
  {-6.203976e-01,  4.097858e-01, -6.687170e-01, -2.341940e-01, -7.753056e-01, -5.615703e-01},
  {-8.485682e-01, -4.602192e-01,  2.610176e-01, -4.173419e-01, -7.842335e-01, -5.630244e-01},
  { 1.545466e-01,  3.372401e-01, -9.286466e-01, -1.567470e-02, -8.020733e-01, -5.714513e-01},
  { 7.297382e-01,  1.511083e-01, -6.668197e-01, -1.168731e-01, -8.002805e-01, -5.840330e-01},
  {-9.863386e-01, -4.172835e-02, -1.593577e-01, -2.120183e-01, -7.803552e-01, -5.948280e-01},
  { 1.609775e-01, -8.773382e-02, -9.830509e-01,  1.711146e-01, -7.864649e-01, -5.772363e-01},
  {-9.682145e-01, -2.500673e-01,  5.194366e-03, -2.103827e-01, -7.862458e-01, -6.164323e-01},
  {-6.448304e-01, -2.843361e-01, -7.094693e-01, -3.901838e-01, -7.879114e-01, -6.747014e-01},
  {-3.707423e-01, -8.769757e-01,  3.057185e-01,  1.058395e-01, -7.639271e-01,  6.108691e-01},
  { 7.498322e-01,  6.556877e-01, -8.845982e-02,  2.807195e-01, -7.819908e-01,  5.828212e-01},
  { 6.585733e-01,  7.320750e-01,  1.742045e-01,  2.775887e-01, -7.787114e-01,  5.813782e-01},
  { 2.099143e-01,  7.743497e-01,  5.969242e-01,  2.723808e-01, -7.784089e-01,  5.905890e-01},
  {-2.497078e-01, -9.197825e-01, -3.027313e-01,  2.103394e-01, -7.788084e-01,  4.344204e-01},
  { 7.664533e-01, -6.076173e-01, -2.082079e-01,  1.756110e-01, -7.868244e-01,  4.354131e-01},
  {-2.180579e-01,  7.947116e-01,  5.664665e-01, -1.078027e-01, -7.805859e-01,  4.344322e-01},
  { 4.106164e-01,  9.767865e-02,  9.065611e-01,  3.251811e-01, -7.623509e-01,  4.216863e-01},
  {-6.473420e-01,  4.982873e-01,  5.767652e-01, -1.794552e-01, -7.820421e-01,  3.848306e-01},
  { 1.006050e-01, -9.635870e-01,  2.477471e-01,  2.195598e-01, -7.863778e-01,  3.288213e-01},
  {-6.972140e-01, -6.145905e-01, -3.690136e-01,  7.876989e-02, -7.786223e-01,  2.886349e-01},
  { 6.330264e-01, -5.994697e-01,  4.898098e-01, -6.280100e-03, -7.866350e-01,  2.934496e-01},
  { 8.013631e-01, -5.753078e-01,  1.638240e-01,  6.606655e-03, -7.804745e-01,  2.764988e-01},
  { 8.884700e-01, -4.246510e-01,  1.740478e-01,  2.483369e-02, -7.754704e-01,  2.479617e-01},
  {-9.131625e-01, -8.012132e-02, -3.996434e-01, -1.716223e-01, -7.541706e-01,  2.185215e-01},
  {-7.601765e-01, -6.065155e-01,  2.329606e-01,  9.297040e-02, -7.785290e-01,  1.878254e-01},
  {-7.414876e-01, -8.804768e-03,  6.709088e-01, -7.220438e-02, -7.678181e-01,  1.380892e-01},
  {-5.515504e-01, -7.665971e-01,  3.288175e-01,  5.885105e-02, -7.809978e-01,  1.274777e-01},
  { 4.759321e-01, -8.748186e-01,  9.044947e-02,  2.836575e-01, -7.842755e-01,  1.059745e-01},
  { 5.132726e-01, -5.120897e-01,  6.887056e-01,  3.124914e-01, -7.771043e-01,  9.433053e-02},
  {-2.313633e-01, -8.849713e-01,  4.041001e-01,  6.456302e-03, -7.865059e-01,  7.358646e-02},
  { 6.428268e-01,  2.713470e-01, -7.163410e-01,  2.684882e-01, -7.705134e-01,  3.721612e-02},
  { 3.358586e-01, -3.910101e-01, -8.569189e-01, -3.458537e-01, -7.791883e-01,  2.424480e-02},
  { 9.547851e-01,  2.851854e-01,  8.399280e-02,  2.476787e-01, -7.571588e-01,  1.926782e-03},
  {-5.964543e-01, -3.189084e-02, -8.020133e-01, -2.052446e-01, -7.712518e-01,  9.577559e-03},
  {-8.289775e-01,  2.644300e-01, -4.928215e-01, -4.620904e-01, -7.684409e-01,  1.941013e-03},
  { 5.650496e-01, -2.571444e-01, -7.839615e-01, -1.635303e-01, -7.700633e-01, -3.994592e-02},
  {-1.332760e-01, -4.067799e-01, -9.037520e-01,  9.779279e-02, -7.780021e-01, -4.412557e-02},
  {-8.197913e-01,  5.609791e-01, -1.150854e-01, -1.532596e-01, -7.630675e-01, -7.309337e-02},
  {-5.965633e-01, -1.059499e-01, -7.955419e-01, -4.370034e-01, -7.661234e-01, -2.927951e-02},
  { 9.583357e-01,  2.818939e-01, -4.613535e-02,  3.649075e-01, -7.836545e-01, -1.948266e-01},
  { 2.511823e-01, -8.132027e-01,  5.249845e-01, -3.804068e-01, -7.643523e-01, -2.192951e-01},
  {-9.842517e-01, -7.278121e-02, -1.610942e-01, -2.187685e-01, -7.698983e-01, -2.253923e-01},
  { 4.537842e-01,  7.640281e-01,  4.586294e-01,  2.103156e-01, -7.875018e-01, -2.794995e-01},
  { 3.752254e-01,  7.824026e-01,  4.970433e-01,  2.027476e-01, -7.873325e-01, -2.737523e-01},
  {-5.332151e-01, -6.894692e-01, -4.902183e-01, -4.698534e-01, -7.625082e-01, -2.691787e-01},
  { 6.429921e-01,  7.598088e-01,  9.618599e-02,  2.185663e-01, -7.846987e-01, -2.941545e-01},
  {-7.422831e-01,  1.938970e-01, -6.414201e-01, -4.526121e-01, -7.620457e-01, -3.042587e-01},
  { 4.744557e-01,  7.286285e-01, -4.939558e-01,  2.156119e-01, -7.951029e-01, -3.194745e-01},
  {-9.085152e-01, -4.152263e-01,  4.676889e-02, -4.434539e-01, -7.792025e-01, -4.024942e-01},
  {-1.281603e-01,  7.057073e-01, -6.968158e-01, -4.162864e-01, -7.844986e-01, -4.222944e-01},
  { 5.496299e-01,  8.142520e-01, -1.868172e-01,  3.108216e-01, -7.905805e-01, -4.486734e-01},
  { 5.148132e-01,  2.900624e-01, -8.067411e-01, -1.024558e-02, -7.685924e-01, -4.564725e-01},
  { 9.350032e-01,  2.062944e-01, -2.884640e-01, -2.643442e-02, -7.539675e-01, -4.784467e-01},
  { 5.877277e-01,  1.687375e-02, -8.088828e-01,  1.893633e-01, -7.560892e-01, -5.013528e-01},
  {-3.593571e-01, -2.589284e-01,  8.965593e-01, -3.210666e-01, -7.676259e-01, -4.998910e-01},
  { 8.990557e-01,  2.912933e-01, -3.268749e-01,  1.784148e-01, -7.659531e-01, -5.193707e-01},
  { 2.317107e-01, -4.239927e-02, -9.718603e-01, -7.225981e-02, -7.767572e-01, -5.650873e-01},
  {-5.895343e-01, -8.058163e-01, -5.576174e-02, -3.785550e-01, -7.957615e-01, -6.061816e-01},
  {-7.490550e-01, -6.356551e-01, -1.867062e-01, -4.216001e-01, -7.746483e-01, -5.977393e-01},
  { 7.668210e-01,  2.287262e-01, -5.997248e-01,  1.632834e-01, -7.610527e-01, -5.801067e-01},
  { 6.710260e-01, -4.506319e-01, -5.887742e-01, -1.460842e-01, -7.709420e-01, -6.261106e-01},
  {-3.414637e-01,  5.544339e-01, -7.589503e-01, -4.008488e-01, -7.707888e-01, -6.647537e-01},
  {-1.697627e-01, -1.014523e-02, -9.854327e-01, -2.564372e-01, -7.616675e-01, -7.219334e-01},
  { 7.479204e-02,  2.551456e-01, -9.640056e-01, -2.311609e-01, -7.697904e-01, -7.301670e-01},
  { 5.224158e-01,  7.592626e-01,  3.880748e-01,  2.556354e-01, -7.554762e-01,  5.667286e-01},
  { 2.462721e-01,  6.197434e-01,  7.451631e-01,  2.339281e-01, -7.566878e-01,  5.809203e-01},
  {-6.742672e-01, -7.366272e-01, -5.238481e-02,  1.405699e-01, -7.652137e-01,  5.325661e-01},
  { 6.372412e-01,  5.034102e-01,  5.835254e-01,  2.840551e-01, -7.584385e-01,  4.447157e-01},
  { 6.022117e-01,  1.716885e-01,  7.796564e-01,  3.022642e-01, -7.579176e-01,  4.297797e-01},
  { 8.046844e-02, -9.903253e-01, -1.130514e-01,  2.091527e-01, -7.687414e-01,  3.916879e-01},
  {-6.681398e-01,  4.308864e-01,  6.065692e-01,  1.040945e-01, -7.478665e-01,  4.017408e-01},
  { 7.034310e-02, -9.893919e-01,  1.271040e-01,  2.129832e-01, -7.669896e-01,  3.819379e-01},
  { 6.138683e-01, -4.608175e-01, -6.409469e-01,  3.736549e-01, -7.465697e-01,  3.591388e-01},
  { 5.130798e-01, -8.582817e-01,  1.007351e-02,  2.392825e-02, -7.646321e-01,  2.850387e-01},
  {-5.441530e-01, -8.216001e-01,  1.699140e-01,  8.312427e-02, -7.685415e-01,  1.850871e-01},
  { 8.986992e-01,  4.027402e-01,  1.736090e-01,  3.800031e-01, -7.466376e-01,  1.507365e-01},
  {-4.963771e-02, -9.517297e-01,  3.028971e-01,  6.411479e-02, -7.674090e-01,  1.658099e-01},
  {-6.714482e-01, -1.500075e-02,  7.408997e-01, -8.625679e-02, -7.444696e-01,  1.161796e-01},
  {-6.882250e-01, -3.116080e-01,  6.551692e-01, -4.429212e-01, -7.497106e-01,  8.770909e-02},
  { 8.569014e-01, -4.208915e-01,  2.976080e-01,  3.637289e-01, -7.500420e-01,  8.517572e-02},
  { 2.923364e-01, -4.964579e-01, -8.173549e-01, -4.021654e-01, -7.337446e-01, -5.041143e-02},
  { 9.486827e-01,  1.489500e-01, -2.789537e-01,  4.009312e-02, -7.476855e-01, -1.261148e-01},
  {-8.281072e-01,  3.598965e-01,  4.297826e-01, -1.509150e-01, -7.539569e-01, -1.109780e-01},
  { 7.214290e-01, -2.077612e-02,  6.921766e-01,  5.967288e-02, -7.432283e-01, -1.843499e-01},
  {-5.731656e-01,  2.429626e-01,  7.825921e-01, -4.053454e-01, -7.610116e-01, -2.254193e-01},
  {-4.736103e-01, -3.455521e-01, -8.101155e-01,  3.433705e-01, -7.375519e-01, -2.580002e-01},
  { 7.002586e-01,  1.321814e-01, -7.015454e-01,  2.710939e-04, -7.450981e-01, -3.091875e-01},
  {-8.658522e-01, -4.323723e-01,  2.517023e-01, -2.035395e-01, -7.652559e-01, -2.876953e-01},
  {-5.666476e-01, -5.019184e-01,  6.534435e-01, -2.164246e-01, -7.655290e-01, -3.047521e-01},
  { 9.824758e-01,  1.160034e-01, -1.458923e-01, -2.480160e-02, -7.510462e-01, -3.528450e-01},
  { 6.516021e-01, -6.613036e-02,  7.556729e-01, -1.349042e-02, -7.469579e-01, -3.785881e-01},
  {-2.558810e-01,  6.879349e-01, -6.791690e-01, -3.701515e-01, -7.519990e-01, -3.704300e-01},
  { 5.566352e-01, -1.684624e-01,  8.134972e-01,  1.352259e-02, -7.443702e-01, -3.946288e-01},
  {-6.009856e-01,  4.893210e-01, -6.319662e-01, -2.755356e-01, -7.584238e-01, -4.084972e-01},
  {-7.157394e-01,  4.492567e-01, -5.346826e-01, -2.727292e-01, -7.474419e-01, -4.039158e-01},
  { 7.607126e-01,  4.301629e-01,  4.860825e-01,  2.510552e-01, -7.443479e-01, -4.313194e-01},
  {-9.756461e-01, -6.671994e-02,  2.089571e-01, -2.667668e-01, -7.502182e-01, -4.200555e-01},
  {-8.026856e-01, -1.171429e-01,  5.847850e-01, -2.814378e-01, -7.576164e-01, -4.661298e-01},
  { 8.284644e-01, -2.222674e-01, -5.140466e-01, -2.784839e-02, -7.544460e-01, -5.538177e-01},
  { 6.824749e-01, -3.729071e-01, -6.286242e-01, -1.051688e-01, -7.593296e-01, -5.824253e-01},
  {-6.429467e-01,  3.761890e-01,  6.671592e-01, -4.397429e-01, -7.512379e-01, -5.791481e-01},
  {-5.688027e-01,  7.381971e-01, -3.626686e-01, -4.203556e-01, -7.569599e-01, -6.262020e-01},
  { 1.864624e-01,  8.222397e-01, -5.377300e-01, -3.813486e-01, -7.673953e-01, -6.591505e-01},
  {-7.414832e-01,  1.871670e-01, -6.443378e-01, -4.119660e-01, -7.586880e-01, -6.465375e-01},
  {-8.830652e-01, -2.848219e-01,  3.729240e-01, -2.623484e-01, -7.418638e-01, -6.991184e-01},
  { 2.519199e-01, -9.344933e-01,  2.515129e-01,  2.765721e-01, -7.227349e-01,  7.469220e-01},
  {-3.114789e-01, -9.256516e-01,  2.148254e-01,  1.853691e-01, -7.235278e-01,  7.356767e-01},
  { 1.668115e-01,  6.186990e-01,  7.677145e-01,  9.893122e-02, -7.424868e-01,  5.998663e-01},
  { 6.069584e-01,  7.924690e-01, -5.995383e-02,  2.403568e-01, -7.343970e-01,  5.301464e-01},
  {-9.090793e-01, -3.891962e-01, -1.486645e-01,  1.261935e-01, -7.379830e-01,  4.788084e-01},
  {-9.298390e-01, -3.568994e-01, -8.956776e-02,  1.271354e-01, -7.376413e-01,  4.641491e-01},
  { 7.242882e-01,  1.962074e-01,  6.609911e-01,  2.527358e-01, -7.281753e-01,  4.654371e-01},
  { 6.403799e-01, -4.332000e-01,  6.342329e-01,  3.094006e-01, -7.381899e-01,  4.286658e-01},
  { 9.694490e-01, -1.915679e-01,  1.532000e-01,  3.914541e-01, -7.302179e-01,  3.923718e-01},
  {-8.521302e-02,  7.388037e-01,  6.685116e-01, -6.366798e-02, -7.417251e-01,  3.462549e-01},
  {-6.304446e-01,  7.178371e-01,  2.953800e-01, -1.761971e-01, -7.475314e-01,  3.321798e-01},
  { 4.772438e-01, -3.000785e-02, -8.782585e-01,  2.899171e-01, -7.425183e-01,  3.205640e-01},
  { 7.736143e-01,  1.543746e-02, -6.334686e-01,  2.429247e-01, -7.281425e-01,  2.724991e-01},
  {-2.395571e-01, -9.673495e-01, -8.274950e-02,  5.258325e-02, -7.598704e-01,  2.452721e-01},
  { 2.716409e-01,  6.466010e-01,  7.128242e-01,  3.680742e-01, -7.465780e-01,  1.651974e-01},
  {-8.842650e-01, -2.414484e-01,  3.997225e-01, -7.578476e-02, -7.406774e-01,  1.303885e-01},
  {-8.477553e-01, -3.314061e-01,  4.141026e-01, -4.319988e-01, -7.202225e-01,  1.200445e-01},
  { 4.916042e-01,  3.191964e-01, -8.102092e-01,  3.601766e-01, -7.452954e-01,  6.640615e-02},
  { 9.787319e-01,  1.979041e-01,  5.401557e-02,  2.379136e-01, -7.256663e-01,  1.324539e-02},
  { 8.810549e-01,  6.357331e-02,  4.687223e-01,  2.478891e-01, -7.227079e-01, -1.687736e-02},
  { 1.931047e-01, -3.389682e-01, -9.207667e-01, -3.660786e-01, -7.290439e-01, -3.092348e-02},
  { 7.574397e-01,  2.043516e-01,  6.201012e-01,  2.670641e-01, -7.411424e-01, -3.476694e-02},
  {-8.436676e-01,  1.942031e-01, -5.005099e-01, -1.490212e-01, -7.364841e-01, -4.050251e-02},
  {-4.540154e-02, -7.544849e-01, -6.547453e-01,  1.329058e-01, -7.293984e-01, -6.723833e-02},
  { 9.897019e-01,  4.125657e-02,  1.370699e-01,  3.255688e-01, -7.278209e-01, -1.578389e-01},
  {-8.184705e-01,  4.054457e-01,  4.070870e-01, -1.671898e-01, -7.396191e-01, -1.532663e-01},
  { 4.416535e-02, -1.250931e-01,  9.911615e-01, -3.496818e-01, -7.326011e-01, -2.177837e-01},
  { 9.190269e-01, -1.578971e-01, -3.611900e-01,  3.589813e-01, -7.197725e-01, -2.595095e-01},
  {-7.646851e-01, -2.930062e-01, -5.739374e-01, -4.807557e-01, -7.420049e-01, -2.769928e-01},
  {-2.231692e-01, -5.614403e-01,  7.968564e-01, -2.446172e-01, -7.477129e-01, -3.049537e-01},
  {-9.107089e-01,  2.032872e-01, -3.595601e-01, -2.728654e-01, -7.217840e-01, -3.801756e-01},
  {-8.506681e-01,  4.983458e-01,  1.673781e-01, -4.147843e-01, -7.294539e-01, -5.465362e-01},
  {-8.178188e-01,  5.285145e-01,  2.276947e-01, -4.210929e-01, -7.408825e-01, -5.670139e-01},
  {-2.483812e-01, -1.786551e-01, -9.520447e-01,  1.428347e-01, -7.327729e-01, -5.782651e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -5.452967e-02, -7.268824e-01, -6.680173e-01},
  { 4.318833e-01, -4.701709e-01,  7.696859e-01,  2.910804e-01, -7.042980e-01,  7.605162e-01},
  { 4.646476e-02, -6.248373e-01,  7.793711e-01,  2.682433e-01, -7.116757e-01,  7.617786e-01},
  { 6.768371e-01, -6.405986e-01,  3.626638e-01,  3.109245e-01, -6.997528e-01,  7.475556e-01},
  { 4.525391e-01, -8.856885e-01, -1.037498e-01,  2.993450e-01, -7.109209e-01,  7.364663e-01},
  { 1.742370e-01, -8.854120e-01, -4.309143e-01,  2.684542e-01, -7.191824e-01,  7.288076e-01},
  {-1.437055e-01, -6.812650e-01,  7.177929e-01,  1.513624e-01, -6.997549e-01,  7.173428e-01},
  {-9.173988e-01, -3.934747e-01,  5.964215e-02,  4.039760e-01, -7.060192e-01,  6.214597e-01},
  { 7.867360e-01, -5.568213e-01,  2.664515e-01,  4.022487e-01, -7.014176e-01,  6.252485e-01},
  {-5.561464e-01, -2.201041e-02,  8.307928e-01,  3.844080e-02, -7.195668e-01,  5.883505e-01},
  {-2.935939e-01, -9.518159e-01,  8.859468e-02,  3.868443e-01, -7.070033e-01,  5.723778e-01},
  { 7.145839e-01, -6.993023e-01, -1.860600e-02,  3.997871e-01, -7.054486e-01,  5.607921e-01},
  { 7.530464e-01, -6.430485e-01, -1.393191e-01,  4.003741e-01, -7.027594e-01,  5.302815e-01},
  { 8.868409e-01, -3.000660e-01,  3.513881e-01,  3.936041e-01, -7.199838e-01,  3.963254e-01},
  { 8.238361e-01,  1.708276e-01, -5.404739e-01,  3.739666e-01, -7.239713e-01,  3.386926e-01},
  { 4.263157e-01, -3.365486e-01, -8.396368e-01,  2.949744e-01, -7.246543e-01,  3.192070e-01},
  {-1.192529e-01, -9.841962e-01,  1.309068e-01, -3.547490e-01, -7.089775e-01,  2.895533e-01},
  {-7.495747e-01,  6.618840e-01,  6.872902e-03, -1.640397e-01, -7.214181e-01,  2.018014e-01},
  {-8.491773e-01,  1.832632e-01, -4.952902e-01, -1.646750e-01, -7.256219e-01,  1.930115e-01},
  {-6.054520e-01, -7.850296e-01,  1.309830e-01, -4.210033e-01, -6.965301e-01,  1.720736e-01},
  {-3.436313e-01, -8.385007e-01, -4.228880e-01, -9.958230e-02, -7.173569e-01,  1.619286e-01},
  {-7.741469e-01, -2.432911e-01, -5.843853e-01, -1.387771e-01, -7.157078e-01,  1.728916e-01},
  { 7.685029e-02,  7.967571e-01,  5.993931e-01,  3.778613e-01, -7.240114e-01,  1.326134e-01},
  {-8.414871e-01, -5.373150e-01,  5.649814e-02, -7.999633e-02, -7.216842e-01,  1.441709e-01},
  {-5.731002e-01, -3.624985e-01,  7.349496e-01, -4.303322e-01, -7.040460e-01,  1.361415e-01},
  {-7.645127e-01, -9.569356e-02,  6.374661e-01, -9.068221e-02, -7.160469e-01,  1.130652e-01},
  { 9.402547e-01,  3.404700e-01,  1.055514e-03,  3.770703e-01, -7.286794e-01,  9.008241e-02},
  {-6.216263e-01, -6.642350e-02,  7.804926e-01, -1.103143e-01, -7.123137e-01,  9.204675e-02},
  {-2.915716e-01,  1.308370e-01,  9.475588e-01, -1.409647e-01, -7.175933e-01,  7.510454e-02},
  { 1.848553e-01,  1.852277e-01,  9.651524e-01, -3.341186e-01, -7.159384e-01,  8.967872e-02},
  { 4.790166e-02,  1.890515e-01,  9.807981e-01, -2.123313e-01, -7.035772e-01,  6.753045e-02},
  {-9.923126e-01, -1.218282e-01,  2.176216e-02, -4.757670e-01, -7.107657e-01,  5.986972e-02},
  {-2.487194e-01, -3.852696e-01, -8.886539e-01, -1.914946e-01, -7.254320e-01, -8.509024e-03},
  { 7.426662e-01,  4.462379e-03,  6.696468e-01,  3.135661e-01, -7.206233e-01, -6.847022e-02},
  {-2.257524e-01, -5.978389e-01, -7.691713e-01,  1.650625e-01, -7.274897e-01, -6.983379e-02},
  { 8.424858e-01, -5.102621e-01,  1.727725e-01,  3.292250e-01, -7.047808e-01, -8.882627e-02},
  {-4.820095e-01, -3.933740e-01, -7.828944e-01,  1.961540e-01, -7.298951e-01, -8.732886e-02},
  {-5.304704e-01, -1.002954e-01, -8.417494e-01, -4.147626e-01, -7.063817e-01, -6.448839e-02},
  {-9.653494e-01,  2.502325e-01,  7.405529e-02, -1.293625e-01, -7.120869e-01, -1.081715e-01},
  { 9.769538e-01, -1.662389e-01,  1.338876e-01,  3.459848e-02, -7.238001e-01, -1.512784e-01},
  { 9.550076e-01,  2.669699e-01,  1.291801e-01,  3.282098e-01, -7.199677e-01, -1.895349e-01},
  {-3.417972e-01, -6.951826e-01,  6.323732e-01, -2.555926e-01, -7.236913e-01, -2.763376e-01},
  {-3.920991e-01,  2.389683e-01, -8.883425e-01, -3.713215e-01, -7.052317e-01, -3.052369e-01},
  {-1.684304e-01,  3.368608e-01, -9.263671e-01, -3.175414e-01, -7.046477e-01, -3.255114e-01},
  { 7.398495e-02, -1.003755e-02, -9.972088e-01,  9.363815e-02, -7.090188e-01, -3.283632e-01},
  {-5.394431e-01,  5.671381e-01, -6.223789e-01, -2.950829e-01, -7.119728e-01, -3.450401e-01},
  { 6.332355e-01, -4.575367e-01,  6.242378e-01,  2.524061e-01, -7.099612e-01, -4.193500e-01},
  {-9.856874e-01, -1.242259e-01,  1.139652e-01, -2.664709e-01, -7.225367e-01, -4.091178e-01},
  { 2.670872e-01,  4.046513e-02, -9.628224e-01, -2.209817e-03, -7.072946e-01, -4.454432e-01},
  { 8.191108e-01,  1.288986e-01, -5.589657e-01,  1.776230e-01, -7.276125e-01, -5.105631e-01},
  { 8.087361e-01,  5.881717e-01,  0.000000e+00, -4.189325e-01, -7.137405e-01, -5.239772e-01},
  {-9.387979e-01,  2.546231e-01, -2.320032e-01, -2.043138e-01, -7.101190e-01, -5.623896e-01},
  {-9.646254e-01,  2.155879e-01,  1.517221e-01, -2.024910e-01, -7.166262e-01, -5.873160e-01},
  { 5.608116e-01, -3.366379e-01, -7.564161e-01, -2.287971e-02, -7.070667e-01, -6.564593e-01},
  { 6.629195e-01, -5.407301e-01, -5.178307e-01, -1.110616e-02, -6.994535e-01, -6.494806e-01},
  { 3.470044e-01, -2.350982e-02, -9.375688e-01, -2.772658e-01, -7.113914e-01, -7.158358e-01},
  { 4.472585e-01, -8.898781e-01, -8.987103e-02,  3.126984e-01, -6.991411e-01,  7.216324e-01},
  {-6.380271e-01, -7.698025e-01,  1.804382e-02,  1.258579e-01, -6.850177e-01,  7.077897e-01},
  { 1.021957e-01, -9.643518e-01,  2.440936e-01,  3.927128e-01, -6.923898e-01,  6.413447e-01},
  { 5.283363e-01,  7.576810e-01,  3.831191e-01,  2.062490e-01, -7.091731e-01,  5.283293e-01},
  { 8.810917e-01, -4.587201e-01, -1.151233e-01,  3.962641e-01, -6.928092e-01,  4.840402e-01},
  {-7.519823e-02, -9.952016e-01, -6.260122e-02,  3.589112e-01, -7.007683e-01,  4.835662e-01},
  { 3.582529e-02, -8.796514e-01,  4.742676e-01,  3.460455e-01, -7.027048e-01,  4.684162e-01},
  { 5.893606e-01,  3.638566e-01,  7.212924e-01,  2.357879e-01, -6.872128e-01,  4.690079e-01},
  { 2.619376e-01, -1.976968e-01,  9.446188e-01,  2.711485e-01, -7.056711e-01,  4.476898e-01},
  {-9.311650e-01, -4.771781e-02,  3.614622e-01,  1.045140e-01, -7.033646e-01,  3.890901e-01},
  {-5.911294e-01,  6.912470e-01,  4.156244e-01, -1.314261e-01, -7.116294e-01,  3.250326e-01},
  { 4.776426e-01, -7.171482e-01,  5.074997e-01, -3.399065e-01, -6.853781e-01,  3.263017e-01},
  {-4.961232e-01, -6.597732e-01,  5.644122e-01, -3.689067e-01, -6.910626e-01,  3.163595e-01},
  { 6.881073e-01,  2.144850e-01, -6.931844e-01,  3.577484e-01, -7.060844e-01,  3.202396e-01},
  {-6.178193e-01, -7.706069e-01,  1.564109e-01, -3.829426e-01, -6.970037e-01,  2.866779e-01},
  { 4.177217e-01, -9.052965e-01, -7.711504e-02, -3.409984e-01, -6.988772e-01,  2.364095e-01},
  {-4.027300e-01, -9.148628e-01,  2.888723e-02, -3.833281e-01, -6.989236e-01,  2.234070e-01},
  {-5.870756e-01, -8.095174e-01,  4.880352e-03, -4.086435e-01, -6.908824e-01,  2.070331e-01},
  {-7.705956e-01, -3.155996e-01,  5.536960e-01, -4.184688e-01, -6.884064e-01,  1.836039e-01},
  {-7.805150e-01, -5.717912e-01,  2.526876e-01, -9.195940e-02, -7.061542e-01,  1.210104e-01},
  { 3.897220e-01,  9.209317e-01, -1.233377e-03,  3.642669e-01, -7.101143e-01,  1.039933e-01},
  { 5.983523e-01,  6.411385e-01,  4.805371e-01,  2.721794e-01, -7.012930e-01,  1.159643e-01},
  { 2.168085e-01, -8.504068e-01,  4.793771e-01, -3.591163e-01, -7.054186e-01,  1.100401e-01},
  { 4.209381e-01,  8.424632e-01, -3.362541e-01,  3.678087e-01, -7.148619e-01,  9.392398e-02},
  { 5.568473e-01,  7.680618e-01, -3.162311e-01,  2.918919e-01, -6.961995e-01,  9.612277e-02},
  {-7.819112e-01, -2.343909e-02,  6.229490e-01, -4.529416e-01, -7.062616e-01,  8.764610e-02},
  { 5.992469e-04,  5.218021e-01, -8.530664e-01,  3.279207e-01, -7.126136e-01,  7.539017e-02},
  { 4.707644e-01, -5.702410e-01,  6.732058e-01, -2.836922e-01, -6.969260e-01,  7.699157e-02},
  {-4.507368e-01,  8.617399e-01, -2.328962e-01, -4.774435e-01, -7.077817e-01,  6.440424e-02},
  { 8.214859e-01,  1.295378e-01, -5.553206e-01,  2.872418e-01, -6.985990e-01,  7.235733e-02},
  { 9.017833e-01,  1.376047e-01, -4.096972e-01,  2.441796e-01, -7.000948e-01,  4.230706e-02},
  { 2.780015e-01, -3.380898e-01,  8.991165e-01, -2.020936e-01, -6.877771e-01,  6.380813e-02},
  {-6.981832e-01,  6.377161e-01, -3.253591e-01, -4.573725e-01, -7.007452e-01,  5.159593e-02},
  { 9.170852e-01, -1.340351e-02,  3.984659e-01,  2.331121e-01, -6.861079e-01, -2.247600e-03},
  {-9.558949e-01, -2.476521e-01, -1.579032e-01, -4.278356e-01, -7.036028e-01, -3.029080e-02},
  {-9.376847e-01,  5.089724e-02, -3.437394e-01, -1.296422e-01, -7.022330e-01, -6.488029e-02},
  { 4.541465e-02, -2.698745e-01, -9.618239e-01, -4.075933e-01, -6.932892e-01, -6.712746e-02},
  { 7.188475e-01, -3.873655e-01, -5.772402e-01,  5.153130e-02, -7.044607e-01, -1.213170e-01},
  { 1.731866e-01, -4.896368e-01,  8.545538e-01, -3.206533e-01, -6.994351e-01, -2.121947e-01},
  { 6.692686e-01, -3.749356e-01,  6.414848e-01,  9.060791e-02, -6.921753e-01, -1.987314e-01},
  { 8.249030e-01, -2.506396e-01,  5.066703e-01,  1.315131e-01, -6.945164e-01, -2.569532e-01},
  { 9.067107e-01, -1.583636e-01, -3.908922e-01,  3.640133e-01, -6.890357e-01, -2.678224e-01},
  {-4.752817e-01,  3.682224e-01,  7.990742e-01, -4.312018e-01, -7.063659e-01, -2.743215e-01},
  {-9.462095e-01,  1.361703e-01, -2.935050e-01, -4.226613e-01, -6.880751e-01, -2.746960e-01},
  {-4.805121e-01,  2.122647e-01,  8.509123e-01, -4.803746e-01, -7.285702e-01, -2.776222e-01},
  { 2.094866e-02, -2.509201e-01, -9.677811e-01,  3.431559e-01, -6.906607e-01, -2.742628e-01},
  {-2.996603e-03,  8.425914e-02, -9.964394e-01,  1.833605e-02, -6.905990e-01, -3.029314e-01},
  {-6.666667e-01, -6.666667e-01,  3.333333e-01, -3.626802e-01, -7.004321e-01, -3.052098e-01},
  {-2.686979e-01,  3.134658e-01, -9.107912e-01, -3.537642e-01, -6.947134e-01, -3.064002e-01},
  {-1.684304e-01,  3.368608e-01, -9.263671e-01, -3.062564e-01, -6.998008e-01, -3.280098e-01},
  { 3.030776e-01, -3.500897e-01, -8.863302e-01, -2.985469e-02, -6.878434e-01, -3.604257e-01},
  {-9.233443e-01,  1.590510e-01, -3.494826e-01, -2.787825e-01, -6.902986e-01, -3.523378e-01},
  { 3.555280e-01, -6.715190e-02,  9.322503e-01,  2.791337e-01, -6.902163e-01, -4.193900e-01},
  {-5.894650e-01, -5.641587e-01,  5.781487e-01, -2.970085e-01, -7.008064e-01, -4.256133e-01},
  { 9.123737e-01,  2.414557e-01, -3.305653e-01, -2.854786e-02, -6.905416e-01, -4.603510e-01},
  {-3.280671e-01, -8.497091e-01,  4.127547e-01, -3.687939e-01, -6.811571e-01, -4.536434e-01},
  {-6.882486e-01, -1.667112e-01,  7.060603e-01, -3.699043e-01, -6.933537e-01, -4.736353e-01},
  { 1.173612e-02,  9.254888e-01, -3.785933e-01, -4.002253e-01, -7.054781e-01, -4.966349e-01},
  { 1.173612e-02,  9.254888e-01, -3.785933e-01, -4.203627e-01, -7.073840e-01, -5.061403e-01},
  { 6.541623e-01, -2.465434e-01, -7.150441e-01,  2.298931e-01, -6.905634e-01, -4.959503e-01},
  { 9.939431e-01,  1.017537e-01,  4.151335e-02, -9.367962e-03, -6.961731e-01, -5.458357e-01},
  { 8.210935e-02,  8.414215e-01, -5.341048e-01, -3.279239e-01, -7.038248e-01, -5.345130e-01},
  { 9.070101e-01,  2.001631e-01, -3.704961e-01,  9.812443e-03, -6.910426e-01, -6.272254e-01},
  { 8.422534e-01, -3.167968e-01, -4.361753e-01,  6.727645e-03, -6.924284e-01, -6.355259e-01},
  { 4.155565e-01, -2.997006e-01, -8.587737e-01, -1.733972e-01, -7.006828e-01, -6.735246e-01},
  { 3.697453e-01, -1.179252e-01, -9.216193e-01, -1.150355e-01, -6.937875e-01, -6.719321e-01},
  {-9.003949e-01,  7.830792e-03,  4.350032e-01, -2.760023e-01, -6.905414e-01, -7.051027e-01},
  {-6.432526e-01, -6.512395e-01, -4.026328e-01,  1.250170e-01, -6.815431e-01,  6.991348e-01},
  {-1.686990e-02, -8.751149e-01, -4.836211e-01,  1.514280e-01, -6.828588e-01,  6.821674e-01},
  {-3.869471e-02,  5.796763e-01,  8.139275e-01,  2.902416e-02, -6.884022e-01,  5.699767e-01},
  { 7.860247e-01, -6.181903e-01,  2.396867e-03,  3.986144e-01, -6.866375e-01,  4.748734e-01},
  {-8.655341e-01, -4.526913e-01, -2.142925e-01,  1.023487e-01, -6.905627e-01,  4.169118e-01},
  { 2.647552e-01, -5.686557e-01,  7.788038e-01, -3.522828e-01, -6.716807e-01,  3.484026e-01},
  {-8.536821e-03, -3.275793e-01,  9.447851e-01, -3.518742e-01, -6.667717e-01,  3.506681e-01},
  {-7.015904e-01,  4.657943e-01,  5.392647e-01,  7.288324e-02, -6.744183e-01,  3.459087e-01},
  {-4.492955e-01,  7.445844e-01,  4.936877e-01, -1.200484e-01, -6.963676e-01,  3.194550e-01},
  { 6.043466e-01, -6.412037e-01,  4.728881e-01, -3.121763e-01, -6.765569e-01,  3.082015e-01},
  {-8.698796e-01, -2.824758e-01,  4.043722e-01, -3.842214e-01, -6.866750e-01,  3.029755e-01},
  {-9.570812e-01,  1.952815e-01,  2.141510e-01, -3.930836e-01, -6.814781e-01,  2.570829e-01},
  {-7.263625e-01,  6.464139e-01,  2.335519e-01, -1.063604e-01, -6.862625e-01,  2.448373e-01},
  {-9.278769e-01,  2.928242e-03,  3.728753e-01, -4.059308e-01, -6.789875e-01,  2.210224e-01},
  {-9.547056e-01, -1.770879e-01,  2.391171e-01, -4.138773e-01, -6.794313e-01,  1.969207e-01},
  {-9.768969e-01,  1.221694e-01,  1.753480e-01, -4.245377e-01, -6.846128e-01,  1.585106e-01},
  {-8.468319e-01,  4.895711e-01,  2.078359e-01, -4.343220e-01, -6.890932e-01,  1.117762e-01},
  { 2.381146e-01, -6.861174e-01,  6.874186e-01, -1.935995e-01, -6.859962e-01,  6.069833e-02},
  {-3.221458e-01,  6.120934e-01,  7.221937e-01, -1.889475e-01, -6.833931e-01,  6.085419e-02},
  { 9.952123e-01,  5.728420e-02, -7.918923e-02,  2.298000e-01, -6.723405e-01,  1.548455e-02},
  {-8.426778e-01,  5.061343e-01,  1.836361e-01, -4.302963e-01, -6.765221e-01,  2.701414e-02},
  { 9.196322e-02, -7.407269e-01, -6.654821e-01, -4.272876e-01, -6.789142e-01, -7.170276e-02},
  { 3.272583e-01, -6.354986e-01, -6.993164e-01,  9.361900e-02, -6.861819e-01, -1.024812e-01},
  {-8.360187e-01,  1.187122e-01,  5.357053e-01, -1.351089e-01, -6.755224e-01, -1.337186e-01},
  { 9.200373e-01, -3.780606e-01, -1.029640e-01,  3.231103e-01, -6.741093e-01, -1.596773e-01},
  { 7.687355e-01, -5.781975e-01,  2.733742e-01,  5.178436e-02, -6.932462e-01, -1.498130e-01},
  {-7.585395e-01,  7.673708e-02,  6.470929e-01, -1.986000e-01, -6.752582e-01, -1.929403e-01},
  { 9.261591e-01, -2.812016e-01,  2.513063e-01,  3.456003e-01, -6.715739e-01, -2.159097e-01},
  {-7.862344e-01, -1.285726e-01, -6.044043e-01, -4.245220e-01, -6.665632e-01, -2.749285e-01},
  { 7.083660e-01, -6.203766e-02, -7.031136e-01, -6.968445e-03, -6.733410e-01, -3.153276e-01},
  {-5.011653e-01,  1.456109e-01, -8.530127e-01, -2.928920e-01, -6.803994e-01, -3.280545e-01},
  { 3.632625e-01, -2.569168e-02, -9.313325e-01,  1.055198e-01, -6.756375e-01, -3.279254e-01},
  {-7.811089e-01, -3.262736e-01,  5.323668e-01, -2.754216e-01, -6.807332e-01, -3.785562e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  2.838626e-01, -6.865298e-01, -4.186781e-01},
  { 7.605025e-01, -4.922809e-01, -4.234328e-01,  2.831202e-01, -6.844473e-01, -4.198131e-01},
  { 1.651183e-01,  1.637537e-01,  9.725845e-01,  1.322405e-01, -6.744676e-01, -4.261184e-01},
  {-3.574682e-01,  6.408737e-01, -6.793360e-01, -2.420505e-01, -6.691774e-01, -4.645875e-01},
  {-4.141838e-01, -6.261901e-01,  6.605586e-01, -3.854310e-01, -6.710172e-01, -4.383238e-01},
  {-4.081752e-01,  6.391730e-01, -6.518058e-01, -2.925112e-01, -6.774985e-01, -4.646578e-01},
  {-8.635589e-01,  1.346173e-01, -4.859467e-01,  1.072807e-01, -6.699903e-01, -5.081940e-01},
  {-7.008424e-01,  5.397467e-01, -4.663620e-01, -2.108029e-01, -6.840725e-01, -5.254888e-01},
  { 9.129656e-01,  1.851892e-01, -3.635915e-01, -1.014975e-02, -6.942331e-01, -5.510184e-01},
  { 7.817263e-01,  1.236394e-01, -6.112424e-01,  1.482472e-01, -6.775495e-01, -5.782677e-01},
  {-9.673358e-01,  2.082865e-01,  1.444930e-01, -1.948847e-01, -6.728355e-01, -5.943274e-01},
  { 9.611698e-01, -1.033840e-01,  2.558600e-01,  8.312201e-03, -6.765982e-01, -6.230944e-01},
  { 6.825904e-01, -3.160644e-01,  6.589186e-01,  3.361681e-03, -6.705258e-01, -6.163797e-01},
  { 4.083119e-01, -2.117727e-01, -8.879379e-01, -1.272943e-01, -6.666906e-01, -6.810966e-01},
  { 3.559285e-01, -2.274863e-01, -9.064021e-01, -1.425358e-01, -6.654659e-01, -6.893920e-01},
  { 3.600507e-01, -1.909172e-01, -9.131891e-01, -2.068200e-01, -6.917385e-01, -6.902558e-01},
  { 3.103395e-01, -2.369899e-01, -9.206113e-01, -2.774324e-01, -6.653368e-01, -7.302359e-01},
  { 5.229080e-01, -1.872640e-01,  8.315645e-01,  2.619142e-01, -6.496392e-01,  7.860635e-01},
  {-5.270581e-01, -1.734215e-01,  8.319464e-01,  1.082455e-01, -6.454495e-01,  7.078208e-01},
  {-3.805663e-01,  4.068695e-01,  8.304375e-01,  1.759450e-01, -6.493587e-01,  7.097599e-01},
  { 1.517188e-01,  6.057194e-01,  7.810796e-01,  2.569350e-02, -6.672115e-01,  5.540037e-01},
  { 1.445577e-01,  5.656427e-01,  8.118814e-01,  2.343409e-02, -6.706883e-01,  5.570608e-01},
  { 9.753504e-01,  2.181484e-01, -3.321064e-02,  4.016754e-01, -6.743066e-01,  5.350044e-01},
  {-6.555166e-01, -7.097254e-01,  2.580463e-01, -5.392166e-02, -6.488313e-01,  4.960482e-01},
  { 8.716146e-01,  4.543929e-01, -1.838886e-01,  3.894553e-01, -6.665341e-01,  4.692269e-01},
  { 6.386005e-01, -4.523384e-01,  6.225588e-01, -2.802912e-01, -6.507158e-01,  2.961867e-01},
  { 6.377429e-01,  3.502906e-01, -6.859887e-01,  2.839663e-01, -6.542477e-01,  2.844002e-01},
  { 8.054409e-01,  5.825015e-01, -1.093479e-01,  1.889979e-01, -6.490487e-01,  2.136687e-01},
  {-5.724582e-01,  7.709513e-01,  2.791518e-01, -3.998048e-01, -6.698353e-01,  2.265644e-01},
  {-4.615206e-01,  6.480759e-01,  6.058022e-01, -8.719005e-02, -6.484795e-01,  2.032961e-01},
  {-8.357842e-01, -4.348575e-01,  3.352070e-01, -1.564232e-01, -6.545516e-01,  1.763597e-01},
  {-7.784098e-01,  6.134667e-01,  1.331789e-01, -4.105219e-01, -6.692049e-01,  1.796868e-01},
  {-6.497241e-01, -6.308416e-01,  4.241434e-01, -1.308858e-01, -6.724995e-01,  8.974063e-02},
  { 3.601865e-01, -5.759365e-01,  7.338684e-01, -2.628421e-01, -6.754645e-01,  7.901903e-02},
  { 1.740233e-01, -4.949680e-01,  8.513064e-01, -2.249853e-01, -6.606777e-01,  8.024470e-02},
  {-8.815770e-01,  1.106365e-01,  4.588916e-01, -4.368189e-01, -6.708817e-01, -1.106201e-02},
  {-4.044835e-01, -2.651895e-01, -8.752528e-01, -1.658775e-01, -6.640810e-01, -3.990075e-02},
  { 8.670728e-01, -4.603166e-01, -1.905082e-01,  3.703858e-01, -6.601269e-01, -9.692915e-02},
  { 8.207664e-01, -4.044771e-01, -4.034113e-01,  3.683510e-01, -6.593527e-01, -1.045707e-01},
  { 2.092984e-01, -9.073206e-01, -3.646416e-01, -4.523113e-01, -6.578206e-01, -1.193200e-01},
  {-2.983442e-01, -9.421419e-01,  1.528381e-01, -5.118812e-01, -6.517475e-01, -1.279122e-01},
  {-3.832043e-01, -8.761626e-01,  2.923929e-01, -4.907751e-01, -6.505262e-01, -1.053369e-01},
  {-5.977562e-01, -5.608082e-01,  5.728713e-01, -5.193131e-01, -6.413621e-01, -1.176611e-01},
  { 5.886061e-01, -8.080686e-01,  2.383489e-02,  7.516133e-02, -6.725166e-01, -1.362025e-01},
  {-3.122751e-02, -9.405411e-01, -3.382416e-01, -4.864182e-01, -6.557974e-01, -1.295261e-01},
  {-4.168928e-01, -9.011640e-01, -1.187593e-01, -5.251552e-01, -6.497841e-01, -1.366906e-01},
  { 2.244498e-02, -5.059872e-01, -8.622489e-01, -4.888755e-01, -6.450220e-01, -1.424033e-01},
  {-5.754845e-01,  3.766076e-01,  7.259368e-01, -1.908700e-01, -6.508471e-01, -2.019321e-01},
  { 8.235305e-01, -5.666640e-01, -2.625728e-02,  1.520323e-01, -6.619623e-01, -2.652414e-01},
  {-1.738984e-01, -7.931417e-01, -5.836828e-01, -4.904748e-01, -6.413872e-01, -2.829633e-01},
  { 2.096667e-01, -9.152409e-02, -9.734800e-01,  1.964132e-02, -6.556638e-01, -3.027501e-01},
  { 8.248414e-01, -2.924344e-01,  4.838582e-01, -2.414323e-02, -6.672167e-01, -3.666200e-01},
  { 3.830870e-01,  5.490651e-01,  7.428135e-01,  2.829695e-01, -6.690701e-01, -4.355226e-01},
  { 8.320503e-01,  0.000000e+00, -5.547002e-01, -3.860987e-01, -6.605377e-01, -4.351943e-01},
  { 9.238522e-01,  3.819087e-01,  2.535448e-02,  2.863349e-01, -6.663655e-01, -4.469498e-01},
  { 2.793027e-01, -8.007636e-02, -9.568583e-01, -2.592606e-02, -6.633307e-01, -4.533090e-01},
  {-5.177779e-01,  5.582942e-03, -8.554969e-01,  8.334423e-02, -6.554499e-01, -4.828100e-01},
  {-9.547868e-01,  2.616701e-01, -1.411064e-01, -1.893796e-01, -6.578174e-01, -5.390504e-01},
  { 8.903496e-01,  4.285254e-01,  1.537652e-01, -2.232416e-02, -6.755962e-01, -5.460021e-01},
  {-5.603625e-01,  2.934150e-01, -7.745330e-01,  1.372546e-01, -6.657750e-01, -5.835182e-01},
  { 9.057922e-01, -7.602610e-02,  4.168459e-01, -1.594251e-02, -6.658717e-01, -5.895355e-01},
  { 5.654435e-01,  1.162788e-01, -8.165495e-01, -6.113416e-04, -6.540202e-01, -6.402754e-01},
  { 2.560771e-01, -3.433784e-01, -9.036127e-01, -1.770732e-01, -6.569338e-01, -6.993924e-01},
  {-9.317964e-01, -2.273279e-01, -2.829799e-01,  1.076427e-01, -6.359599e-01,  6.733725e-01},
  { 5.080231e-02, -7.475269e-01, -6.622859e-01,  3.086209e-01, -6.523036e-01,  6.490433e-01},
  { 5.264157e-02,  5.950726e-01,  8.019461e-01,  1.850818e-02, -6.518286e-01,  5.405134e-01},
  {-3.437632e-01, -8.441176e-01, -4.114516e-01, -4.404506e-02, -6.525555e-01,  4.816908e-01},
  {-5.119947e-01, -1.581156e-01,  8.443109e-01, -8.123539e-02, -6.358601e-01,  4.830049e-01},
  {-3.456749e-03,  4.103700e-01,  9.119126e-01,  2.010316e-01, -6.492255e-01,  4.682611e-01},
  {-1.038487e-01, -3.624296e-01,  9.262074e-01,  2.656058e-01, -6.395930e-01,  4.639403e-01},
  { 3.231010e-01,  5.865586e-01,  7.426673e-01,  1.261934e-01, -6.441846e-01,  4.598303e-01},
  {-1.923110e-01, -7.136055e-01,  6.736347e-01, -1.482632e-01, -6.338341e-01,  4.500036e-01},
  {-3.675122e-01, -5.437444e-01,  7.545043e-01, -1.553604e-01, -6.321561e-01,  4.490220e-01},
  {-2.152771e-01, -9.722536e-01,  9.153516e-02, -1.672310e-01, -6.299884e-01,  4.334667e-01},
  {-2.264998e-01, -8.134575e-01, -5.357095e-01, -1.900727e-01, -6.284695e-01,  4.298739e-01},
  { 8.851268e-01,  4.214179e-01, -1.973765e-01,  2.730651e-01, -6.380196e-01,  3.733770e-01},
  {-6.444485e-01,  2.355738e-01,  7.274552e-01, -3.547324e-01, -6.579424e-01,  3.529540e-01},
  { 5.222834e-01,  1.634071e-01,  8.369696e-01, -3.356709e-01, -6.528998e-01,  3.340720e-01},
  { 4.359653e-01, -2.201208e-01,  8.726288e-01, -2.470879e-01, -6.313670e-01,  2.746142e-01},
  { 3.106620e-01, -9.133122e-01,  2.633438e-01, -2.393631e-01, -6.356866e-01,  2.687877e-01},
  { 5.840393e-01,  3.817286e-01, -7.163668e-01,  2.161069e-01, -6.432916e-01,  2.544506e-01},
  { 8.875345e-01,  4.352378e-03, -4.607206e-01,  1.904546e-01, -6.348624e-01,  2.224935e-01},
  {-2.137929e-01,  7.835894e-01,  5.833355e-01,  8.306239e-03, -6.365160e-01,  2.449142e-01},
  {-5.008293e-01, -3.388627e-01,  7.964559e-01, -1.631985e-01, -6.440476e-01,  1.730450e-01},
  {-7.166681e-01,  6.970434e-01,  2.274512e-02, -3.641522e-01, -6.380613e-01,  1.102177e-01},
  { 3.437586e-01, -8.666689e-01,  3.615455e-01, -2.290209e-01, -6.472908e-01,  9.529038e-02},
  {-5.030944e-01, -4.313274e-01,  7.489010e-01, -1.589401e-01, -6.594614e-01,  7.889157e-02},
  {-8.012633e-01,  4.143895e-01,  4.315768e-01, -3.742087e-01, -6.367795e-01,  4.385902e-02},
  { 1.662010e-01, -2.775371e-01, -9.462295e-01, -2.992253e-01, -6.393198e-01, -2.730406e-02},
  {-3.513415e-01, -1.741652e-01, -9.199052e-01, -1.802831e-01, -6.379349e-01, -4.114557e-02},
  { 8.156156e-01, -5.126047e-01,  2.683423e-01,  3.846366e-01, -6.386219e-01, -7.076359e-02},
  {-9.248978e-01,  8.504780e-02,  3.705820e-01, -1.256496e-01, -6.380637e-01, -1.133568e-01},
  {-4.358338e-01, -5.251794e-01,  7.309141e-01, -5.008880e-01, -6.369781e-01, -9.919602e-02},
  { 9.687787e-01, -1.319580e-01, -2.098924e-01,  3.647603e-01, -6.354898e-01, -1.185039e-01},
  { 2.799203e-01, -4.750473e-01, -8.342510e-01, -4.428265e-01, -6.407423e-01, -1.377346e-01},
  {-3.157771e-01,  2.208938e-01,  9.227625e-01, -2.184049e-01, -6.409999e-01, -2.191664e-01},
  {-4.811594e-01, -1.816224e-01, -8.576124e-01,  3.516529e-01, -6.330104e-01, -2.806445e-01},
  {-5.929580e-02, -5.343090e-01, -8.432069e-01, -4.840398e-01, -6.363565e-01, -2.959497e-01},
  {-7.435600e-01, -3.966700e-01,  5.383042e-01, -5.123964e-01, -6.300751e-01, -2.943086e-01},
  { 1.273625e-01, -4.303001e-01, -8.936558e-01,  1.623129e-01, -6.381444e-01, -3.081229e-01},
  { 1.509293e-01, -9.629031e-02, -9.838438e-01,  1.268623e-01, -6.463756e-01, -3.225173e-01},
  {-8.864442e-01,  1.260331e-01, -4.453453e-01, -2.771848e-01, -6.439591e-01, -3.383881e-01},
  {-9.505965e-01,  1.756757e-01, -2.559380e-01, -2.743454e-01, -6.400089e-01, -3.470244e-01},
  {-8.583495e-01,  2.978500e-01,  4.177577e-01, -2.761201e-01, -6.397310e-01, -3.721780e-01},
  {-5.662310e-01,  7.217820e-01,  3.980116e-01, -3.624298e-01, -6.505947e-01, -4.257222e-01},
  {-7.248551e-01,  6.731632e-01,  1.464119e-01, -3.850543e-01, -6.569995e-01, -4.347445e-01},
  { 7.473112e-01,  5.111040e-01,  4.246160e-01,  2.708103e-01, -6.468979e-01, -4.525602e-01},
  { 6.949102e-01, -2.614577e-02, -7.186211e-01, -3.485697e-02, -6.362289e-01, -4.607078e-01},
  {-7.730231e-01,  4.978349e-02, -6.324214e-01, -1.960586e-01, -6.338010e-01, -4.984813e-01},
  { 6.818574e-01,  1.488824e-01, -7.161736e-01,  2.525331e-01, -6.386446e-01, -4.849830e-01},
  { 3.827949e-01,  5.025989e-01, -7.751532e-01,  1.542803e-01, -6.394424e-01, -5.342133e-01},
  { 8.925817e-01,  3.922136e-01,  2.224104e-01, -5.973123e-02, -6.321782e-01, -5.413373e-01},
  { 2.962781e-02,  7.813832e-01, -6.233478e-01,  1.441093e-01, -6.464376e-01, -5.480224e-01},
  {-7.900213e-01, -2.579685e-01,  5.561643e-01,  2.481945e-01, -6.129770e-01,  7.979558e-01},
  { 8.194709e-01, -1.043102e-01,  5.635485e-01,  3.872756e-01, -6.332929e-01,  6.925512e-01},
  { 7.276596e-01,  1.592623e-02,  6.857534e-01,  3.796003e-01, -6.309184e-01,  7.027595e-01},
  {-8.618504e-01, -4.146726e-01,  2.919940e-01,  9.906067e-02, -6.110336e-01,  7.156200e-01},
  {-5.390406e-01,  4.480540e-01,  7.132201e-01,  2.008036e-01, -6.164529e-01,  6.999140e-01},
  { 1.163589e-02,  4.049742e-01,  9.142541e-01,  1.647535e-01, -6.161883e-01,  6.880873e-01},
  {-7.684092e-01, -4.015065e-01, -4.983372e-01,  1.289548e-01, -6.266500e-01,  6.348802e-01},
  {-4.135402e-01,  4.114380e-01,  8.122212e-01, -3.127003e-02, -6.324033e-01,  5.060230e-01},
  {-2.501938e-01,  1.708088e-01,  9.530097e-01, -9.987669e-02, -6.242476e-01,  4.712267e-01},
  {-1.832637e-01,  3.904978e-01,  9.021785e-01,  1.671094e-01, -6.207353e-01,  4.423956e-01},
  {-7.395848e-01, -6.462658e-01,  1.880287e-01, -2.120790e-01, -6.072714e-01,  4.291174e-01},
  {-5.029049e-01, -6.950688e-01, -5.137761e-01,  6.342205e-02, -6.310256e-01,  3.979813e-01},
  { 7.029526e-01,  4.986951e-01, -5.071103e-01,  2.606222e-01, -6.297771e-01,  2.826256e-01},
  {-3.289618e-01,  8.229037e-01,  4.632642e-01, -5.266524e-02, -6.377357e-01,  2.563695e-01},
  { 7.685694e-01, -1.480716e-01,  6.223951e-01, -2.266648e-01, -6.257820e-01,  2.598421e-01},
  { 9.516349e-01,  2.228426e-01,  2.114995e-01,  1.807688e-01, -6.212668e-01,  1.845769e-01},
  { 1.163610e-01, -6.659273e-01,  7.368860e-01, -1.731655e-01, -6.227963e-01,  1.828248e-01},
  { 4.372291e-01, -8.716339e-01,  2.215517e-01, -2.451429e-01, -6.305217e-01,  1.618597e-01},
  {-2.391328e-01, -8.622276e-01,  4.465189e-01, -1.714981e-01, -6.518127e-01,  8.716146e-02},
  {-9.565577e-01,  2.212050e-01,  1.899097e-01, -3.534310e-01, -6.189839e-01,  7.911883e-02},
  {-6.905807e-01, -6.098759e-01,  3.887799e-01, -3.655623e-01, -6.154907e-01,  4.532381e-02},
  { 8.095386e-01, -3.899497e-01,  4.388468e-01,  2.372301e-01, -6.290846e-01,  1.584806e-02},
  { 2.184453e-01, -9.551922e-01,  1.997235e-01,  3.589027e-01, -6.244392e-01, -1.942788e-02},
  { 4.183277e-01, -6.340694e-01,  6.503521e-01,  2.548803e-01, -6.289430e-01, -2.939901e-03},
  {-2.635173e-02, -4.354872e-01, -8.998091e-01, -2.579024e-01, -6.289984e-01, -2.830909e-02},
  { 8.566184e-01, -5.150591e-01,  3.031608e-02,  3.876681e-01, -6.180714e-01, -5.020892e-02},
  { 3.267179e-01, -4.856091e-01, -8.108262e-01, -3.254804e-01, -6.261327e-01, -4.205483e-02},
  {-6.727733e-01, -3.572000e-01,  6.479076e-01, -5.502225e-01, -6.112145e-01, -1.270750e-01},
  {-9.203191e-01,  1.265420e-01,  3.701350e-01, -1.347618e-01, -6.290969e-01, -1.533602e-01},
  { 1.303804e-02, -5.493746e-02, -9.984046e-01, -5.571558e-01, -6.130205e-01, -1.457777e-01},
  {-7.022474e-01,  1.655348e-01,  6.924210e-01, -1.633375e-01, -6.135661e-01, -1.973650e-01},
  { 9.939739e-01,  1.487921e-02, -1.086028e-01,  3.665408e-01, -6.182155e-01, -2.349100e-01},
  { 7.203864e-01, -4.255206e-04, -6.935727e-01,  3.483695e-01, -6.239026e-01, -2.852480e-01},
  { 6.195867e-01, -7.582790e-01, -2.027939e-01,  1.996898e-01, -6.172049e-01, -2.984519e-01},
  { 4.078888e-01, -5.671562e-01, -7.155142e-01,  2.002469e-01, -6.148968e-01, -3.169737e-01},
  { 7.931602e-01, -4.558926e-01, -4.038054e-01, -2.027374e-03, -6.326883e-01, -3.217246e-01},
  { 7.931602e-01, -4.558926e-01, -4.038054e-01,  1.933847e-01, -6.171087e-01, -3.221057e-01},
  {-1.687183e-01, -5.280312e-01, -8.322963e-01,  1.656384e-01, -6.117475e-01, -3.174004e-01},
  { 8.373764e-01, -5.406548e-01, -8.057923e-02, -6.615719e-03, -6.328825e-01, -3.400309e-01},
  {-5.578208e-01,  8.290837e-01, -3.815828e-02, -3.404025e-01, -6.375347e-01, -4.194844e-01},
  {-5.578208e-01,  8.290837e-01, -3.815828e-02, -3.445838e-01, -6.400640e-01, -4.236764e-01},
  { 4.686235e-01,  1.163459e-01, -8.757030e-01,  1.873849e-01, -6.137885e-01, -5.157542e-01},
  {-9.860104e-01, -3.641337e-03, -1.666443e-01, -1.823959e-01, -6.153139e-01, -5.419831e-01},
  { 8.797784e-01,  3.133613e-01, -3.574837e-01,  1.420530e-01, -6.509937e-01, -5.720329e-01},
  {-8.335274e-01,  5.375264e-01, -1.276619e-01,  1.403257e-01, -6.498379e-01, -5.661846e-01},
  { 9.860204e-01,  1.157550e-01, -1.198523e-01, -1.791335e-03, -6.203579e-01, -6.392830e-01},
  {-8.438935e-01,  1.125945e-01,  5.245631e-01,  2.182380e-01, -6.101553e-01,  7.208762e-01},
  {-6.679138e-01,  2.324131e-01,  7.070186e-01,  2.045703e-01, -6.059220e-01,  6.983734e-01},
  {-9.406755e-01, -2.771410e-01, -1.957611e-01,  9.662049e-02, -5.959941e-01,  6.639394e-01},
  { 9.518390e-01, -6.849758e-02,  2.988487e-01,  4.027865e-01, -6.060312e-01,  6.678005e-01},
  { 9.538398e-01, -2.937104e-01,  6.263936e-02,  4.059077e-01, -5.965784e-01,  6.509823e-01},
  {-4.461664e-01, -8.041368e-01,  3.928098e-01, -5.988539e-02, -5.945427e-01,  6.520739e-01},
  {-4.597840e-02, -3.370867e-01,  9.403502e-01, -1.068632e-01, -5.945039e-01,  6.295620e-01},
  {-1.718056e-01, -7.806858e-01, -6.008430e-01,  2.542047e-01, -6.132250e-01,  6.191888e-01},
  { 1.926445e-01, -9.600112e-01, -2.031417e-01, -8.946010e-02, -5.964599e-01,  6.202251e-01},
  {-4.049882e-01, -8.606402e-01,  3.086797e-01, -1.258963e-01, -5.951580e-01,  6.151124e-01},
  {-6.179898e-01, -7.807072e-01,  9.265403e-02,  2.966571e-01, -6.122997e-01,  5.755645e-01},
  { 1.433342e-02, -9.480671e-01, -3.177471e-01, -1.354194e-01, -5.939712e-01,  5.858127e-01},
  { 8.447765e-01,  2.372337e-01, -4.796591e-01,  3.407305e-01, -6.103405e-01,  4.905739e-01},
  {-5.272034e-01, -2.945863e-01,  7.970417e-01,  1.873366e-01, -6.058936e-01,  4.478807e-01},
  {-3.677755e-01, -4.974405e-01, -7.856806e-01, -1.943026e-01, -6.000420e-01,  4.081576e-01},
  { 8.184493e-01,  6.733427e-02, -5.706199e-01,  2.574539e-01, -6.165252e-01,  2.885348e-01},
  { 2.506544e-01, -9.633222e-01,  9.582694e-02, -2.326592e-01, -6.215684e-01,  2.015961e-01},
  { 9.996265e-01, -1.249121e-02, -2.430684e-02,  1.786794e-01, -6.102838e-01,  1.951990e-01},
  {-1.709078e-01,  6.906639e-01,  7.026905e-01, -6.418159e-02, -6.147879e-01,  1.854826e-01},
  { 4.236276e-03, -9.878908e-01,  1.550926e-01, -2.216069e-01, -6.186424e-01,  1.634172e-01},
  {-9.919562e-01, -1.264444e-01, -5.898498e-03, -3.499346e-01, -5.989195e-01,  1.242464e-01},
  { 8.132059e-01, -5.484177e-01,  1.947667e-01,  2.524284e-01, -5.936319e-01,  1.320517e-01},
  {-9.133176e-01, -1.840248e-01,  3.632984e-01, -3.552881e-01, -6.030194e-01,  7.864543e-02},
  { 2.893848e-01, -8.374368e-01,  4.636336e-01,  3.743444e-01, -6.013524e-01,  2.041959e-02},
  { 9.922781e-01, -1.190525e-01,  3.479407e-02,  2.372116e-01, -6.178126e-01,  3.273695e-02},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.735192e-01, -6.044978e-01,  1.799078e-02},
  {-8.031753e-01,  2.062329e-01,  5.589074e-01, -3.895902e-01, -6.043576e-01, -8.464222e-03},
  {-6.646907e-01, -2.421152e-01,  7.068002e-01, -4.596535e-01, -6.062927e-01, -7.061650e-02},
  { 9.299825e-01,  1.207536e-01, -3.472049e-01,  3.812758e-01, -6.131721e-01, -9.512646e-02},
  {-8.608539e-01, -2.894210e-01, -4.185285e-01, -1.339121e-01, -6.089509e-01, -9.185568e-02},
  { 3.212273e-01, -5.668095e-01, -7.586435e-01, -3.854857e-01, -5.983641e-01, -1.208534e-01},
  {-8.150274e-01,  1.865762e-02,  5.791221e-01, -1.429869e-01, -6.034222e-01, -1.725391e-01},
  {-6.131256e-01,  1.629886e-02,  7.898172e-01, -1.931162e-01, -6.013458e-01, -2.203572e-01},
  { 8.677407e-01,  3.847216e-01, -3.146671e-01,  3.588513e-01, -6.040835e-01, -2.626660e-01},
  {-2.773035e-01, -2.004445e-01, -9.396408e-01,  3.364254e-01, -6.014631e-01, -2.829836e-01},
  {-3.267933e-01, -1.344669e-01, -9.354810e-01, -5.128422e-01, -5.891805e-01, -3.017840e-01},
  { 7.724780e-01, -2.535548e-01, -5.822265e-01,  2.107346e-01, -5.942199e-01, -3.135558e-01},
  {-9.718317e-01,  1.304548e-01, -1.962771e-01, -2.638629e-01, -6.061763e-01, -3.685363e-01},
  { 6.064860e-01, -4.438241e-01,  6.596930e-01,  3.171434e-02, -6.012591e-01, -3.829859e-01},
  {-8.056889e-01, -5.768334e-01, -1.346424e-01, -1.900402e-01, -6.067125e-01, -5.250026e-01},
  { 9.085882e-02, -1.584600e-01, -9.831760e-01,  1.457341e-01, -6.039861e-01, -5.324215e-01},
  { 9.545863e-01,  2.234196e-01,  1.971006e-01, -6.304674e-02, -6.058894e-01, -5.518028e-01},
  {-8.757510e-01, -3.370678e-01,  3.456091e-01,  9.721687e-02, -5.893686e-01,  7.320774e-01},
  { 4.610110e-01,  1.986676e-01,  8.648700e-01,  1.050283e-01, -5.886980e-01,  7.196658e-01},
  { 5.586116e-01,  3.812280e-01,  7.366263e-01,  3.903350e-01, -5.982695e-01,  6.807842e-01},
  { 4.445311e-02, -6.066425e-01,  7.937309e-01, -4.055213e-02, -5.813965e-01,  6.661303e-01},
  { 3.559290e-02,  5.907640e-01,  8.060590e-01,  1.703656e-01, -5.813770e-01,  6.600099e-01},
  {-3.760972e-01, -8.847691e-01, -2.751986e-01,  2.561685e-01, -5.918471e-01,  5.781025e-01},
  { 1.189038e-01, -7.737858e-01, -6.221877e-01,  2.025909e-01, -5.907081e-01,  5.793653e-01},
  {-2.895780e-01, -7.703878e-01, -5.680204e-01,  1.601909e-01, -5.914441e-01,  5.756731e-01},
  { 9.129739e-01, -2.990912e-01, -2.775301e-01,  3.591844e-01, -5.908430e-01,  5.581754e-01},
  {-2.706470e-01, -9.594132e-01,  7.922493e-02, -1.699908e-01, -5.795863e-01,  5.611984e-01},
  {-4.721740e-01, -5.053442e-01,  7.222735e-01, -2.050729e-01, -5.754557e-01,  5.425246e-01},
  {-3.828927e-01, -8.924607e-01,  2.385520e-01, -2.422546e-01, -5.745439e-01,  5.183337e-01},
  {-4.885142e-01, -7.484336e-01,  4.485544e-01,  2.572632e-01, -5.932361e-01,  4.975908e-01},
  {-4.890224e-01, -8.464763e-01, -2.105586e-01, -2.403540e-01, -5.743402e-01,  4.969952e-01},
  { 8.449132e-01, -3.717935e-01, -3.845663e-01,  3.151862e-01, -5.866826e-01,  4.487952e-01},
  { 7.734607e-01, -5.871055e-01, -2.388843e-01,  3.011674e-01, -5.911357e-01,  4.233634e-01},
  {-8.327680e-01, -5.401586e-01, -1.213507e-01, -2.299970e-01, -5.757198e-01,  4.536202e-01},
  {-6.369046e-02,  8.652552e-02,  9.942117e-01,  1.406642e-01, -5.811705e-01,  4.265298e-01},
  {-6.684732e-01, -1.519206e-01, -7.280547e-01, -2.064778e-01, -5.869910e-01,  4.094649e-01},
  { 8.140874e-01, -5.529505e-01,  1.775037e-01,  3.536572e-01, -5.693225e-01,  3.856405e-01},
  { 1.723711e-01, -9.839627e-01, -4.588844e-02,  3.405236e-01, -5.785791e-01,  3.736298e-01},
  { 8.768216e-01,  3.997940e-01,  2.671115e-01,  3.601702e-01, -5.757229e-01,  3.634484e-01},
  { 9.254104e-01, -6.317867e-02, -3.736629e-01,  2.740866e-01, -5.991818e-01,  3.652979e-01},
  { 7.178354e-01, -6.961957e-01, -4.885757e-03,  3.598629e-01, -5.735638e-01,  3.484800e-01},
  {-8.317043e-01, -5.167520e-01, -2.030649e-01,  5.687374e-02, -5.951170e-01,  3.362042e-01},
  { 2.601289e-01, -7.329442e-01,  6.285903e-01, -3.380054e-01, -5.801489e-01,  3.192965e-01},
  { 7.796475e-01, -1.261432e-01,  6.133822e-01, -1.955735e-01, -5.942624e-01,  2.201148e-01},
  { 5.742341e-01, -1.033821e-01,  8.121375e-01, -1.808817e-01, -5.929437e-01,  2.051482e-01},
  {-9.493321e-01, -3.142546e-01,  3.545081e-03, -3.527206e-01, -5.869262e-01,  1.916446e-01},
  { 4.845574e-01, -8.576975e-01,  1.719271e-01,  3.819681e-01, -5.745736e-01,  1.699562e-01},
  { 6.780508e-03, -1.996629e-01,  9.798412e-01,  3.330111e-01, -5.761038e-01,  1.719709e-01},
  {-4.622479e-02, -7.854692e-01,  6.171720e-01,  3.144347e-01, -5.768246e-01,  1.659147e-01},
  { 1.704719e-01,  3.412316e-01,  9.243918e-01, -1.212518e-01, -5.936512e-01,  1.609871e-01},
  {-8.952830e-01, -4.379641e-01, -8.158293e-02, -3.530208e-01, -5.837439e-01,  1.533630e-01},
  { 1.326762e-01, -5.186179e-01,  8.446494e-01,  2.570173e-01, -5.827801e-01,  1.449626e-01},
  { 5.323954e-01, -7.102913e-01,  4.604796e-01,  3.987933e-01, -5.799435e-01,  3.981188e-02},
  {-6.768116e-01, -4.361474e-01,  5.930442e-01, -4.043223e-01, -5.917733e-01, -1.623653e-02},
  { 2.154003e-02, -6.833044e-01, -7.298157e-01, -2.273073e-01, -5.970532e-01, -4.650477e-02},
  {-4.543670e-01, -5.781096e-01, -6.777462e-01, -1.642968e-01, -6.017087e-01, -6.329489e-02},
  { 8.723553e-01,  4.888716e-01,  8.311521e-04,  3.587049e-01, -5.869573e-01, -1.957908e-01},
  { 5.141892e-02, -8.472680e-01, -5.286710e-01,  2.372017e-01, -6.007375e-01, -2.293027e-01},
  {-4.384714e-01, -2.712179e-01, -8.568452e-01, -2.879374e-01, -5.877205e-01, -3.448313e-01},
  {-9.361262e-01, -1.701882e-01, -3.077395e-01, -2.662832e-01, -5.946325e-01, -3.703937e-01},
  {-4.499859e-01,  8.929465e-01,  1.262178e-02, -2.991746e-01, -6.050299e-01, -4.100578e-01},
  {-2.873325e-01, -1.993039e-01, -9.368660e-01,  9.839179e-03, -6.009423e-01, -4.536055e-01},
  { 6.644461e-01,  7.435003e-01,  7.562254e-02,  2.604041e-01, -6.018704e-01, -4.691349e-01},
  { 4.939761e-02,  5.191478e-01,  8.532557e-01,  2.490965e-01, -6.010952e-01, -4.775256e-01},
  {-9.907157e-01, -9.729610e-02,  9.495147e-02, -1.840683e-01, -5.880190e-01, -5.670959e-01},
  {-9.069866e-01, -1.797343e-01,  3.808818e-01, -4.309958e-01, -5.718853e-01, -5.581928e-01},
  { 2.587088e-01, -9.231015e-01,  2.845228e-01, -3.268436e-01, -5.818086e-01, -5.762270e-01},
  {-2.679882e-01, -8.431839e-01, -4.660722e-01, -3.697729e-01, -5.813465e-01, -5.781879e-01},
  {-2.307789e-01, -4.404270e-04, -9.730061e-01, -3.900403e-01, -5.820350e-01, -5.711073e-01},
  {-5.285677e-01, -8.487776e-01, -1.388589e-02, -4.254193e-01, -5.841874e-01, -5.727325e-01},
  {-1.818565e-01, -7.855883e-01,  5.914214e-01, -4.404135e-01, -5.800933e-01, -5.719048e-01},
  {-5.866044e-01, -6.910125e-01, -4.223707e-01, -3.461435e-01, -5.815225e-01, -6.023067e-01},
  {-1.396826e-01,  9.303622e-01,  3.389911e-01, -4.328745e-01, -5.835332e-01, -5.775998e-01},
  { 2.430870e-02,  9.890598e-01, -1.454987e-01, -4.409719e-01, -5.845867e-01, -5.780452e-01},
  { 2.430870e-02,  9.890598e-01, -1.454987e-01, -3.445219e-01, -5.763472e-01, -6.368213e-01},
  { 2.430870e-02,  9.890598e-01, -1.454987e-01, -3.496366e-01, -5.764668e-01, -6.382756e-01},
  { 3.222760e-01,  2.524986e-01, -9.123501e-01, -1.047631e-01, -5.762283e-01, -6.588923e-01},
  { 4.236332e-01,  7.548547e-01,  5.007288e-01,  8.765083e-02, -5.763459e-01,  7.205386e-01},
  {-4.169881e-01,  6.035669e-01,  6.795792e-01,  9.274929e-02, -5.674509e-01,  7.028159e-01},
  { 2.225522e-01, -6.642216e-01,  7.136388e-01, -2.527157e-02, -5.572413e-01,  6.782377e-01},
  {-7.854762e-01,  3.025685e-01,  5.398884e-01,  1.964640e-01, -5.635650e-01,  6.614891e-01},
  { 5.394951e-01, -8.400325e-01, -5.736385e-02, -1.434026e-02, -5.599735e-01,  6.430297e-01},
  {-8.264875e-01,  6.681862e-02,  5.589756e-01, -5.366754e-02, -5.563113e-01,  6.549807e-01},
  { 9.610656e-01, -6.646154e-02,  2.682085e-01,  4.159834e-01, -5.694055e-01,  6.300038e-01},
  { 9.516793e-01, -2.817103e-01, -1.222532e-01,  4.172913e-01, -5.687098e-01,  6.253399e-01},
  {-3.079660e-01, -9.344723e-01, -1.786575e-01,  2.462516e-01, -5.784815e-01,  5.468658e-01},
  {-1.906427e-01, -9.698234e-01, -1.519795e-01,  2.285167e-01, -5.759827e-01,  5.476085e-01},
  {-4.215465e-01, -8.361316e-01, -3.509735e-01,  1.331432e-01, -5.592666e-01,  5.445402e-01},
  { 8.458852e-01, -3.102496e-01, -4.338470e-01,  3.493986e-01, -5.772122e-01,  5.308017e-01},
  {-8.528540e-01, -4.031158e-01,  3.318701e-01, -2.538351e-01, -5.624500e-01,  5.105527e-01},
  { 7.913964e-01, -5.842402e-01, -1.798751e-01,  3.236422e-01, -5.759928e-01,  4.567166e-01},
  {-1.831034e-02, -9.814668e-01,  1.907553e-01, -2.154152e-01, -5.722388e-01,  4.739499e-01},
  {-7.646797e-01, -5.116130e-01, -3.918125e-01, -2.532697e-01, -5.556104e-01,  4.815576e-01},
  { 8.934712e-01, -4.273684e-01, -1.380775e-01,  3.644892e-01, -5.587726e-01,  4.179357e-01},
  { 1.964784e-01, -4.644621e-01,  8.635225e-01, -3.454168e-01, -5.581405e-01,  3.471478e-01},
  { 4.329084e-01, -2.806405e-01,  8.566396e-01, -3.365686e-01, -5.566659e-01,  3.446794e-01},
  {-1.122629e-01, -7.986518e-01, -5.912295e-01,  3.510732e-01, -5.659518e-01,  3.263020e-01},
  {-7.971001e-01, -5.196689e-01, -3.075317e-01,  3.982575e-02, -5.676167e-01,  3.267187e-01},
  { 6.797367e-01, -5.279503e-01,  5.091429e-01,  3.776537e-01, -5.581352e-01,  3.113233e-01},
  {-9.851667e-01, -1.201307e-01,  1.225369e-01,  4.371723e-02, -5.688877e-01,  2.509993e-01},
  { 6.914440e-01,  2.582708e-01,  6.746861e-01, -2.644050e-01, -5.522696e-01,  2.220431e-01},
  {-4.865782e-01, -8.609701e-01,  1.482300e-01, -5.063735e-01, -5.609183e-01,  1.983391e-01},
  { 3.970425e-01, -2.631085e-01,  8.792788e-01,  3.896725e-01, -5.566567e-01,  1.722976e-01},
  { 8.220003e-01, -6.716319e-02,  5.655128e-01,  1.933892e-01, -5.645552e-01,  1.586513e-01},
  {-6.602404e-01,  4.572217e-01,  5.958446e-01, -8.406179e-03, -5.606830e-01,  1.461653e-01},
  {-7.940271e-01,  4.675664e-01, -3.884619e-01, -5.346150e-01, -5.623831e-01,  1.317058e-01},
  {-6.743979e-01, -7.104720e-01,  2.010392e-01, -3.561202e-01, -5.787172e-01,  1.265324e-01},
  {-6.123748e-01, -7.652463e-01, -1.984818e-01, -5.304477e-01, -5.640932e-01,  1.116975e-01},
  { 8.773286e-01, -4.446892e-01,  1.804052e-01,  3.957623e-01, -5.541852e-01,  7.846953e-02},
  { 9.061591e-01, -3.538451e-01, -2.316666e-01,  2.533099e-01, -5.767972e-01,  8.016923e-02},
  { 8.990833e-01,  3.852324e-01, -2.079546e-01,  3.270810e-01, -5.551766e-01, -1.553642e-01},
  {-3.081838e-01, -6.279835e-01,  7.146044e-01, -5.725867e-01, -5.694536e-01, -1.426382e-01},
  {-8.724623e-01, -4.779355e-01,  1.019169e-01, -1.465853e-01, -5.748697e-01, -1.674413e-01},
  { 3.893733e-01, -6.703262e-01, -6.317050e-01,  2.446196e-01, -5.857901e-01, -2.717991e-01},
  { 3.050011e-02,  2.762459e-01,  9.606029e-01, -4.797212e-01, -5.572079e-01, -2.670265e-01},
  {-5.153137e-01, -2.201536e-01,  8.282416e-01, -5.134991e-01, -5.648928e-01, -2.730597e-01},
  {-9.808397e-01, -1.171953e-01, -1.556233e-01, -5.219862e-01, -5.613925e-01, -2.925972e-01},
  { 2.061161e-01, -2.356832e-01, -9.497208e-01,  8.139168e-02, -5.735243e-01, -3.062702e-01},
  {-3.046125e-01, -1.568721e-01, -9.394692e-01, -5.097657e-01, -5.588090e-01, -3.115499e-01},
  { 7.368570e-01, -3.408170e-01,  5.838540e-01,  3.266755e-02, -5.714194e-01, -3.694087e-01},
  { 5.558684e-01,  6.276983e-01, -5.449818e-01,  1.615221e-01, -5.528756e-01, -4.899466e-01},
  {-5.621642e-02, -9.858154e-01,  1.581383e-01, -2.828564e-01, -5.646287e-01, -5.207127e-01},
  { 9.616646e-02, -9.188114e-01,  3.828025e-01, -2.869843e-01, -5.689613e-01, -5.308810e-01},
  { 8.302420e-01,  3.205016e-01, -4.560450e-01,  1.734693e-01, -5.704728e-01, -5.367759e-01},
  {-5.640725e-04, -8.485616e-01,  5.290962e-01, -3.785438e-01, -5.702040e-01, -5.362507e-01},
  {-6.127133e-01, -5.429428e-01,  5.742783e-01, -4.110710e-01, -5.651283e-01, -5.400761e-01},
  {-6.127133e-01, -5.429428e-01,  5.742783e-01,  1.754131e-01, -5.728673e-01, -5.458899e-01},
  {-8.247105e-01, -5.605689e-01, -7.493471e-02, -1.877011e-01, -5.775710e-01, -5.773157e-01},
  {-5.391601e-01,  3.528885e-01, -7.647066e-01, -3.694836e-01, -5.657796e-01, -5.789678e-01},
  { 4.302862e-01, -8.614385e-01, -2.697731e-01, -2.910584e-01, -5.689690e-01, -5.955849e-01},
  { 1.239641e-01,  1.904343e-01, -9.738417e-01, -5.875968e-02, -5.638998e-01, -6.316699e-01},
  { 3.890785e-01, -1.430379e-01, -9.100319e-01, -8.139978e-02, -5.666248e-01, -6.393032e-01},
  { 6.484742e-01,  4.999493e-01,  5.740488e-01,  3.974467e-01, -5.634756e-01,  6.512172e-01},
  {-7.795057e-01,  2.754726e-01,  5.625706e-01,  2.001397e-01, -5.466004e-01,  6.558796e-01},
  {-5.597475e-01,  4.452246e-01,  6.988976e-01,  1.877766e-01, -5.476846e-01,  6.391326e-01},
  { 4.387998e-01,  5.992134e-01,  6.696253e-01,  1.522549e-01, -5.412526e-01,  6.362614e-01},
  { 9.807211e-01, -1.623159e-01, -1.088102e-01,  4.147063e-01, -5.526780e-01,  5.969701e-01},
  { 8.285269e-01, -4.131675e-01, -3.779361e-01,  3.517499e-01, -5.644431e-01,  5.212904e-01},
  { 5.595576e-01, -8.131222e-01,  1.603980e-01, -1.843280e-01, -5.529295e-01,  4.700761e-01},
  { 5.652902e-01, -8.247135e-01,  1.716606e-02,  3.230972e-01, -5.713287e-01,  4.270191e-01},
  { 4.888996e-02, -1.197747e-01,  9.915966e-01, -1.156801e-01, -5.475703e-01,  4.466487e-01},
  { 1.290192e-01, -2.529333e-01,  9.588425e-01, -1.230961e-01, -5.530728e-01,  4.459162e-01},
  {-1.313089e-01, -7.188122e-01, -6.826909e-01, -7.559921e-02, -5.523081e-01,  3.737564e-01},
  {-1.909110e-01, -4.601480e-01, -8.670737e-01, -1.517264e-01, -5.548686e-01,  3.780540e-01},
  {-4.052857e-01, -5.890231e-01, -6.991389e-01, -1.971350e-02, -5.443174e-01,  3.520079e-01},
  {-3.742530e-01,  2.635247e-01, -8.890948e-01,  3.933044e-01, -5.388160e-01,  3.104615e-01},
  {-7.834543e-01, -4.792652e-01, -3.956062e-01,  4.243106e-02, -5.567846e-01,  2.945785e-01},
  { 8.745109e-01, -1.131415e-01, -4.716246e-01,  1.991062e-01, -5.394428e-01,  2.261779e-01},
  {-2.353767e-01, -9.593931e-01,  1.554437e-01, -4.239871e-01, -5.520896e-01,  2.240442e-01},
  {-4.798512e-01, -7.478621e-01,  4.587429e-01, -4.859062e-01, -5.476991e-01,  2.324173e-01},
  { 9.802463e-01, -1.756281e-01,  9.094999e-02,  1.874401e-01, -5.411564e-01,  1.832080e-01},
  {-3.436544e-01, -9.386087e-01, -3.025672e-02, -3.832518e-01, -5.636159e-01,  1.887647e-01},
  {-5.225929e-02,  1.686346e-01,  9.842923e-01,  3.968275e-01, -5.498005e-01,  1.715028e-01},
  { 8.544897e-01, -4.934170e-01, -1.624405e-01,  3.967921e-01, -5.478513e-01,  1.669045e-01},
  { 8.569577e-01, -5.104164e-01, -7.140338e-02,  3.974955e-01, -5.393183e-01,  1.497840e-01},
  { 3.507062e-01, -1.829881e-01,  9.184337e-01,  2.083705e-01, -5.506107e-01,  1.480992e-01},
  {-4.052020e-01, -9.119394e-01,  6.463724e-02, -3.732998e-01, -5.698194e-01,  1.356382e-01},
  { 3.079464e-01, -9.481474e-01, -7.864784e-02,  3.534991e-01, -5.562873e-01,  1.122605e-01},
  { 6.270683e-01, -7.623111e-01, -1.602095e-01,  2.729507e-01, -5.676129e-01,  1.143204e-01},
  {-4.540095e-01,  4.463947e-01,  7.711077e-01, -4.290668e-03, -5.436612e-01,  1.368910e-01},
  {-3.250355e-01,  4.527418e-01,  8.302872e-01, -1.807963e-02, -5.444931e-01,  1.281544e-01},
  { 3.030403e-01, -2.986270e-02,  9.525097e-01, -1.285793e-01, -5.418590e-01,  1.277654e-01},
  { 1.722361e-01,  9.849772e-01, -1.243511e-02, -5.316290e-01, -5.460487e-01,  8.847725e-02},
  {-6.481317e-01, -7.155249e-01,  2.606713e-01, -5.234609e-01, -5.439078e-01,  5.350320e-02},
  { 4.189900e-01, -8.635724e-01,  2.805175e-01,  2.654942e-01, -5.635899e-01,  5.433220e-02},
  {-9.855150e-01,  4.725553e-02,  1.628718e-01, -5.235938e-01, -5.390656e-01,  1.431465e-02},
  { 7.656097e-01,  4.526299e-01, -4.571302e-01,  3.942853e-01, -5.529329e-01,  2.342524e-03},
  { 7.540305e-01, -6.554819e-01, -4.220842e-02,  3.473465e-01, -5.410373e-01, -8.769695e-02},
  {-6.271253e-01, -6.574626e-01,  4.176802e-01, -4.839881e-01, -5.639091e-01, -6.238329e-02},
  { 3.666874e-01, -8.004196e-01,  4.742035e-01, -5.729711e-01, -5.410145e-01, -9.433791e-02},
  {-2.985383e-01, -6.962950e-01, -6.527236e-01, -2.046666e-01, -5.414887e-01, -1.243544e-01},
  { 2.176806e-01, -1.191897e-01, -9.687151e-01, -4.761005e-01, -5.469255e-01, -1.344960e-01},
  {-7.488462e-01,  6.494509e-02,  6.595541e-01, -1.804132e-01, -5.548410e-01, -2.197564e-01},
  {-8.277078e-01, -1.053840e-02,  5.610604e-01, -5.170096e-01, -5.498073e-01, -2.727801e-01},
  { 6.028951e-01, -3.996822e-01, -6.904866e-01,  3.256172e-01, -5.481353e-01, -2.923521e-01},
  {-7.447006e-01, -2.097385e-01, -6.335857e-01, -5.172491e-01, -5.437941e-01, -3.117920e-01},
  {-3.855354e-01, -6.927449e-01,  6.094809e-01, -5.128090e-01, -5.351459e-01, -4.272600e-01},
  {-3.548642e-01, -5.701647e-01, -7.409343e-01, -5.081040e-01, -5.326690e-01, -4.377387e-01},
  {-3.834705e-01, -1.600694e-02, -9.234145e-01,  1.140205e-01, -5.588947e-01, -5.344092e-01},
  {-4.034731e-01, -8.812826e-01, -2.460701e-01, -2.077363e-01, -5.597325e-01, -5.793712e-01},
  {-5.759383e-01,  3.032301e-01, -7.591749e-01, -4.228073e-01, -5.447745e-01, -5.564426e-01},
  { 6.660521e-01, -2.856934e-02, -7.453578e-01,  1.581807e-02, -5.446692e-01, -6.325188e-01},
  { 6.679105e-01, -6.964076e-02, -7.409762e-01,  1.249457e-02, -5.521663e-01, -6.364984e-01},
  {-9.044793e-01, -1.429424e-01,  4.018515e-01, -2.215528e-01, -5.569938e-01, -6.533042e-01},
  {-2.322000e-01, -1.786254e-01, -9.561256e-01, -1.070686e-01, -5.308346e-01, -6.667396e-01},
  { 5.007043e-01,  1.763722e-01, -8.474597e-01, -2.382367e-01, -5.476696e-01, -7.310131e-01},
  { 2.215271e-01, -3.488534e-02, -9.745300e-01, -2.593403e-01, -5.528758e-01, -7.356239e-01},
  {-5.095245e-01, -2.948409e-01,  8.083647e-01,  2.548262e-01, -5.247154e-01,  8.275295e-01},
  {-9.587333e-01, -1.921834e-01,  2.095139e-01,  2.227756e-01, -5.253810e-01,  7.591079e-01},
  {-6.073477e-01, -1.641772e-01,  7.772867e-01, -2.037562e-02, -5.286957e-01,  7.020851e-01},
  { 6.855270e-01,  6.423900e-01,  3.426190e-01,  4.067342e-01, -5.452093e-01,  6.140027e-01},
  { 4.679013e-01, -8.610347e-01, -1.992180e-01,  1.305089e-02, -5.313849e-01,  6.162873e-01},
  { 9.407999e-01,  3.310837e-01, -7.265657e-02,  4.160118e-01, -5.440513e-01,  5.883468e-01},
  { 6.957144e-01,  7.083442e-01,  1.192897e-01,  4.006680e-01, -5.283411e-01,  5.497378e-01},
  { 9.759209e-01, -3.167204e-02, -2.158129e-01,  3.987578e-01, -5.285347e-01,  5.258135e-01},
  { 2.878024e-01, -7.994338e-01, -5.273284e-01, -1.177927e-01, -5.390223e-01,  5.261256e-01},
  { 5.244728e-01, -8.038421e-01,  2.806530e-01, -1.691538e-01, -5.419837e-01,  4.713626e-01},
  { 9.344223e-01,  2.631529e-01, -2.400114e-01,  3.643969e-01, -5.327758e-01,  4.443797e-01},
  { 1.122727e-02, -4.655188e-01,  8.849669e-01, -9.029344e-02, -5.409721e-01,  4.447725e-01},
  { 3.656191e-01,  5.318777e-01,  7.638251e-01, -3.428918e-01, -5.303555e-01,  3.522922e-01},
  {-3.299218e-01,  7.671990e-01,  5.500522e-01, -4.315645e-01, -5.244984e-01,  3.530135e-01},
  {-4.321160e-01, -4.423026e-01, -7.859034e-01, -1.233078e-01, -5.313480e-01,  3.515365e-01},
  { 7.194038e-01, -8.087786e-02,  6.898674e-01, -3.203261e-01, -5.351079e-01,  3.390916e-01},
  {-6.544058e-01, -4.885076e-01,  5.771596e-01, -4.563968e-01, -5.250037e-01,  3.280852e-01},
  {-6.061882e-01, -3.051716e-01, -7.344428e-01, -1.055627e-01, -5.200027e-01,  3.340236e-01},
  { 3.270108e-01,  9.097630e-01,  2.557247e-01, -3.027585e-01, -5.309625e-01,  3.109794e-01},
  { 5.842991e-01, -5.741437e-01, -5.735447e-01,  2.663150e-01, -5.477591e-01,  3.030095e-01},
  { 6.868316e-01, -1.655850e-01,  7.077034e-01, -2.853202e-01, -5.281719e-01,  2.876685e-01},
  {-8.691882e-01, -4.367740e-01, -2.318197e-01,  3.568122e-02, -5.321702e-01,  2.810044e-01},
  {-9.858487e-01, -7.487150e-02,  1.499886e-01,  4.108912e-02, -5.366067e-01,  2.433617e-01},
  { 7.086442e-01,  6.496482e-01, -2.752828e-01, -2.692942e-01, -5.404741e-01,  2.372938e-01},
  {-7.704843e-01,  3.401625e-02,  6.365507e-01,  1.501943e-02, -5.156469e-01,  1.496678e-01},
  { 2.406722e-01,  1.036519e-01,  9.650561e-01,  2.236638e-01, -5.288661e-01,  1.458293e-01},
  {-3.179960e-01,  2.375311e-01,  9.178548e-01, -3.257817e-02, -5.317964e-01,  1.173535e-01},
  {-3.895295e-03,  5.398815e-01,  8.417320e-01, -8.325899e-02, -5.239547e-01,  1.123192e-01},
  {-3.352527e-01,  9.259247e-01,  1.739801e-01, -5.242096e-01, -5.410822e-01,  1.097729e-01},
  {-9.208776e-01,  3.897287e-01,  9.791322e-03, -5.334643e-01, -5.444920e-01,  1.003791e-01},
  {-8.551627e-02,  9.944744e-01, -6.089014e-02, -3.891417e-01, -5.247854e-01,  4.050691e-02},
  { 8.908513e-01,  2.932357e-01, -3.469826e-01,  3.970896e-01, -5.456979e-01,  1.184468e-02},
  {-8.502269e-01,  3.800654e-01,  3.642314e-01, -5.272862e-01, -5.292714e-01,  6.552539e-04},
  {-7.207651e-01,  3.842374e-01,  5.769396e-01, -5.478538e-01, -5.250856e-01, -2.703672e-02},
  { 8.682404e-01,  4.073607e-01, -2.832241e-01,  3.477328e-01, -5.202671e-01, -1.610218e-02},
  {-1.416992e-01, -2.689791e-01, -9.526656e-01, -3.836328e-01, -5.304890e-01, -1.283204e-01},
  {-9.077419e-01, -6.794951e-02, -4.139897e-01, -5.743910e-01, -5.325636e-01, -1.493620e-01},
  {-8.676921e-01, -4.967636e-01,  1.834443e-02, -1.678067e-01, -5.362574e-01, -1.810523e-01},
  { 9.346234e-01, -1.660230e-01, -3.145088e-01,  3.168130e-01, -5.313023e-01, -2.223373e-01},
  {-8.703379e-01, -4.086096e-01,  2.748640e-01, -1.826665e-01, -5.347970e-01, -2.192598e-01},
  { 7.016507e-02,  9.571584e-02,  9.929327e-01, -4.992484e-01, -5.354135e-01, -2.693031e-01},
  {-9.961492e-01, -8.734309e-02, -7.604246e-03, -5.249959e-01, -5.297578e-01, -2.882656e-01},
  {-9.523162e-02,  3.145349e-01,  9.444568e-01, -3.184807e-01, -5.206912e-01, -3.034055e-01},
  {-9.614673e-01, -2.069687e-01, -1.809544e-01, -2.622202e-01, -5.435268e-01, -3.920499e-01},
  { 7.184093e-01, -6.941620e-01, -4.502453e-02, -4.935263e-01, -5.265149e-01, -4.256635e-01},
  {-9.174072e-01,  2.363428e-01,  3.201656e-01, -5.088727e-01, -5.189500e-01, -4.235219e-01},
  { 6.595025e-01, -2.127324e-01, -7.209725e-01, -5.006605e-01, -5.146225e-01, -4.445643e-01},
  { 8.995193e-02,  4.214139e-02, -9.950542e-01,  1.203298e-02, -5.279334e-01, -4.798979e-01},
  {-3.207433e-03,  6.996320e-01, -7.144961e-01,  1.055458e-01, -5.411440e-01, -5.266669e-01},
  { 9.427310e-02,  3.196056e-01, -9.428493e-01, -3.751906e-01, -5.167230e-01, -5.370646e-01},
  {-3.426592e-01,  6.499383e-01, -6.783546e-01, -3.516340e-01, -5.267147e-01, -5.460144e-01},
  { 1.673757e-01,  2.768013e-01, -9.462380e-01,  1.535535e-01, -5.520182e-01, -5.453131e-01},
  {-2.115353e-02,  8.203709e-01, -5.714403e-01,  1.169583e-01, -5.432895e-01, -5.295972e-01},
  {-3.814594e-01,  8.096323e-01, -4.460765e-01, -3.320726e-01, -5.279554e-01, -5.629845e-01},
  {-4.401682e-01, -1.795064e-01, -8.797894e-01, -4.318184e-01, -5.323396e-01, -5.529189e-01},
  { 8.470128e-01, -3.558545e-01,  3.948886e-01,  2.504522e-02, -5.161638e-01, -6.102883e-01},
  {-2.931901e-01, -8.663278e-01, -4.043705e-01, -2.298041e-01, -5.385544e-01, -6.145998e-01},
  { 5.499097e-01, -3.184515e-01, -7.721320e-01,  1.807918e-02, -5.270021e-01, -6.314943e-01},
  { 4.497058e-01, -2.068213e-01, -8.689014e-01, -3.053613e-01, -5.409337e-01, -6.390730e-01},
  {-6.184670e-01,  7.421899e-01, -2.581715e-01, -3.267585e-01, -5.352439e-01, -6.390522e-01},
  {-1.268093e-01, -2.099715e-01, -9.694490e-01, -9.619605e-02, -5.138682e-01, -6.728227e-01},
  { 3.947927e-02, -1.004407e-01,  9.941595e-01, -9.453192e-03, -5.198155e-01,  7.086493e-01},
  { 9.975588e-01, -6.960087e-02, -5.667914e-03,  2.635604e-01, -4.983674e-01,  6.850646e-01},
  { 4.936309e-01,  7.770581e-01,  3.905243e-01,  2.695289e-01, -5.139071e-01,  6.365849e-01},
  {-8.407708e-01, -1.174766e-01,  5.284919e-01,  1.894585e-01, -4.994464e-01,  6.099256e-01},
  { 6.348180e-01,  6.299263e-01,  4.474360e-01,  2.891471e-01, -5.094137e-01,  5.928698e-01},
  { 2.431704e-01, -9.482394e-01, -2.042305e-01, -1.264473e-01, -5.257098e-01,  5.022936e-01},
  { 8.892438e-01, -8.351922e-02, -4.497444e-01,  3.912013e-01, -5.220692e-01,  5.052785e-01},
  {-9.220970e-01, -3.286946e-01,  2.041985e-01, -2.711740e-01, -5.118198e-01,  4.958292e-01},
  { 4.223956e-01, -8.119009e-01,  4.029876e-01, -1.419424e-01, -5.249647e-01,  4.722329e-01},
  {-6.949273e-01, -3.861911e-02, -7.180421e-01, -2.384236e-01, -5.084345e-01,  4.640943e-01},
  { 1.659236e-01, -7.699488e-01,  6.161560e-01, -1.329059e-01, -5.267305e-01,  4.634202e-01},
  { 1.988241e-01,  6.268145e-01,  7.533741e-01, -3.804297e-01, -5.234372e-01,  3.664303e-01},
  {-3.299218e-01,  7.671990e-01,  5.500522e-01, -3.982261e-01, -5.204953e-01,  3.674265e-01},
  {-1.812951e-02,  9.875546e-01,  1.562283e-01, -4.095807e-01, -5.193015e-01,  3.589510e-01},
  {-4.535679e-01, -6.270761e-01,  6.332864e-01, -4.351360e-01, -5.220334e-01,  3.509580e-01},
  { 3.809904e-01,  3.175661e-01,  8.683306e-01, -3.286008e-01, -5.262243e-01,  3.395328e-01},
  { 9.995121e-01,  0.000000e+00,  3.123475e-02, -4.457818e-01, -5.216672e-01,  3.412587e-01},
  {-2.664495e-01,  8.505082e-01,  4.534761e-01, -4.527351e-01, -5.187272e-01,  3.292423e-01},
  {-6.379837e-01, -4.620849e-01, -6.159986e-01, -8.639177e-02, -5.095392e-01,  3.078699e-01},
  {-5.855460e-01, -6.938288e-01, -4.192106e-01, -6.789751e-02, -5.053527e-01,  2.815784e-01},
  { 6.403627e-01, -5.900754e-01,  4.916774e-01, -2.750994e-01, -5.165234e-01,  2.788716e-01},
  { 2.403689e-01, -3.304496e-01, -9.127026e-01,  3.601670e-01, -5.101770e-01,  2.930062e-01},
  {-2.732640e-01, -8.473815e-01, -4.552707e-01, -6.283027e-02, -5.038278e-01,  2.692159e-01},
  {-8.347267e-01, -5.399626e-01,  1.080353e-01,  3.412033e-02, -5.207655e-01,  2.127372e-01},
  { 7.558478e-01, -1.149255e-01,  6.445822e-01,  1.991599e-01, -5.082718e-01,  1.640529e-01},
  {-1.284638e-01,  6.506953e-02,  9.895772e-01,  2.907536e-01, -5.142645e-01,  1.469156e-01},
  { 3.997548e-01, -1.557317e-01,  9.032961e-01,  2.152509e-01, -5.189907e-01,  1.489402e-01},
  {-4.312360e-01,  2.865950e-01, -8.555108e-01, -4.204020e-01, -4.959816e-01,  1.240860e-01},
  {-4.442619e-01, -1.314758e-01,  8.861972e-01, -9.470469e-03, -5.083726e-01,  1.281346e-01},
  {-1.492121e-01,  9.753183e-01, -1.627574e-01, -4.171463e-01, -5.171689e-01,  8.986646e-02},
  {-1.921650e-01, -2.337536e-01,  9.531169e-01, -3.985314e-02, -5.104153e-01,  1.129205e-01},
  {-5.244975e-01,  6.636537e-01, -5.333536e-01, -3.096206e-01, -4.935117e-01,  4.855248e-02},
  {-3.522941e-02,  9.978550e-01, -5.517379e-02, -4.062031e-01, -5.238904e-01,  4.052438e-02},
  {-4.054278e-01,  9.025552e-01, -1.449907e-01, -3.078492e-01, -5.079151e-01,  4.883836e-03},
  {-2.465899e-01,  9.558817e-01,  1.596362e-01, -3.259971e-01, -5.108739e-01, -4.095510e-03},
  {-2.602078e-01,  9.007177e-01,  3.478501e-01, -5.036841e-01, -5.172890e-01, -3.665103e-03},
  {-3.436160e-02,  9.495079e-01,  3.118557e-01, -4.345004e-01, -5.137397e-01, -2.815293e-02},
  {-1.091454e-01, -9.687489e-01,  2.227395e-01, -5.560083e-01, -5.137110e-01, -6.136858e-02},
  { 1.402689e-03, -4.723611e-01, -8.814039e-01, -2.981022e-01, -5.246813e-01, -1.248378e-01},
  { 2.376024e-01, -6.261808e-01, -7.425917e-01, -4.597089e-01, -5.207463e-01, -1.392095e-01},
  {-7.672577e-01,  5.299658e-01,  3.611813e-01, -5.662931e-01, -5.125291e-01, -1.299829e-01},
  {-9.514412e-01,  2.464169e-01, -1.844952e-01, -5.780748e-01, -5.110797e-01, -1.553828e-01},
  { 9.761600e-01,  1.929209e-01,  9.946512e-02,  3.300446e-01, -5.083314e-01, -2.853337e-01},
  {-7.055102e-01,  1.994820e-02,  7.084189e-01, -2.241196e-01, -5.144930e-01, -2.744045e-01},
  {-3.575307e-01,  4.721781e-01,  8.057417e-01, -5.199182e-01, -5.127037e-01, -2.831706e-01},
  { 6.289369e-01, -2.665172e-01, -7.303470e-01,  3.181625e-01, -5.056847e-01, -3.142379e-01},
  {-1.782264e-01, -7.545009e-01, -6.316358e-01, -4.230058e-01, -5.262873e-01, -3.493273e-01},
  {-5.906146e-01, -5.103586e-01, -6.250669e-01, -2.810599e-01, -5.320528e-01, -3.781480e-01},
  {-7.918860e-01, -5.735462e-01, -2.096695e-01, -2.708649e-01, -5.172955e-01, -4.209840e-01},
  {-4.651933e-01, -6.754335e-01,  5.721754e-01, -4.908272e-01, -5.112489e-01, -4.120711e-01},
  { 1.576510e-01, -8.693962e-01, -4.682910e-01, -4.471641e-01, -4.977366e-01, -4.212438e-01},
  {-8.971305e-01, -2.089356e-01, -3.892335e-01, -5.090078e-01, -4.932122e-01, -4.510098e-01},
  { 3.103895e-01,  2.514266e-01, -9.167567e-01,  1.869425e-01, -5.117788e-01, -4.797837e-01},
  {-5.572922e-01, -6.792331e-01,  4.775645e-01, -2.884163e-01, -5.186262e-01, -4.774747e-01},
  {-4.057706e-01,  2.724152e-01, -8.724334e-01,  7.254034e-02, -5.341812e-01, -5.117667e-01},
  { 5.228279e-03,  5.680459e-01, -8.229803e-01, -3.509994e-01, -5.060717e-01, -5.283718e-01},
  { 2.969979e-01, -7.867070e-02, -9.516318e-01, -4.168369e-01, -5.071288e-01, -5.505108e-01},
  {-5.842507e-01, -7.070314e-01, -3.984441e-01, -2.425049e-01, -5.262285e-01, -6.322777e-01},
  { 7.439315e-02, -4.423597e-01, -8.937469e-01, -2.883352e-01, -5.207747e-01, -6.429318e-01},
  { 9.219228e-02,  6.184841e-02, -9.938186e-01, -3.086950e-01, -5.227522e-01, -6.415045e-01},
  {-6.327353e-01, -1.419477e-01, -7.612469e-01, -1.027185e-01, -4.905333e-01, -6.720522e-01},
  {-9.909299e-01,  1.343745e-01,  1.234432e-03, -2.425336e-01, -5.254548e-01, -7.155358e-01},
  { 1.033255e-01,  7.254062e-01, -6.805217e-01, -2.393431e-01, -5.275169e-01, -7.238527e-01},
  {-9.066885e-01,  3.341070e-01,  2.574655e-01, -2.497736e-01, -5.287670e-01, -7.332194e-01},
  { 4.586249e-01, -6.391159e-01,  6.174093e-01,  2.897520e-01, -4.996481e-01,  8.390274e-01},
  { 5.831111e-01, -8.116452e-01, -3.483476e-02,  2.941581e-01, -4.944389e-01,  8.204880e-01},
  { 3.520668e-01,  3.587286e-01,  8.645015e-01,  1.089992e-01, -5.241569e-01,  6.903847e-01},
  {-9.487000e-01, -1.855739e-01,  2.559897e-01,  2.148160e-01, -4.876354e-01,  6.991063e-01},
  { 2.487590e-02,  3.086432e-01,  9.508526e-01,  1.021305e-01, -5.029349e-01,  6.921806e-01},
  {-4.325800e-01,  6.898700e-01,  5.804772e-01, -1.616799e-02, -5.088951e-01,  6.977305e-01},
  { 9.855208e-01,  1.119248e-01,  1.273643e-01,  2.617249e-01, -4.799426e-01,  6.267270e-01},
  {-1.353321e-01, -9.864237e-01,  9.302333e-02,  7.325216e-02, -5.145505e-01,  6.302840e-01},
  { 2.016362e-01, -3.914489e-01,  8.978366e-01, -1.900495e-01, -4.779809e-01,  6.397449e-01},
  {-7.731479e-01,  5.446517e-01,  3.249564e-01, -4.517759e-02, -5.065914e-01,  6.292896e-01},
  { 6.625246e-01,  4.734191e-01,  5.804615e-01, -1.567559e-01, -4.985403e-01,  6.000217e-01},
  { 1.130869e-01,  6.766864e-01,  7.275348e-01,  1.618909e-01, -4.938431e-01,  5.851989e-01},
  {-3.772475e-01, -9.157574e-01, -1.381043e-01,  6.559378e-02, -5.071139e-01,  5.909353e-01},
  {-3.589738e-01,  4.735314e-01,  8.043045e-01, -6.580798e-02, -4.976323e-01,  5.902461e-01},
  { 5.470138e-01,  8.348582e-01,  6.154374e-02,  3.906044e-01, -5.181927e-01,  5.317070e-01},
  {-4.620908e-01, -7.824863e-01,  4.173575e-01,  8.956555e-02, -5.078595e-01,  4.384783e-01},
  { 7.094882e-01,  6.927695e-01, -1.292169e-01,  2.789037e-01, -4.944118e-01,  3.753353e-01},
  { 5.904688e-01,  4.634295e-01,  6.607417e-01,  2.893287e-01, -4.986399e-01,  3.541336e-01},
  {-4.277375e-01, -7.211714e-01, -5.449334e-01, -1.607876e-02, -5.113047e-01,  3.220454e-01},
  {-2.042079e-02, -9.185011e-01, -3.948908e-01, -4.316706e-02, -5.101615e-01,  3.277244e-01},
  {-4.953021e-02,  6.876229e-02,  9.964028e-01,  3.528098e-01, -4.901424e-01,  3.285198e-01},
  { 4.401065e-01,  4.447840e-01,  7.800471e-01, -2.951133e-01, -5.150875e-01,  2.905787e-01},
  {-3.946651e-01, -8.266585e-01, -4.010925e-01,  8.122812e-03, -5.034620e-01,  2.774848e-01},
  {-6.424482e-01,  2.059848e-01,  7.381263e-01, -4.949586e-01, -4.955350e-01,  2.740466e-01},
  {-8.457485e-01, -5.229588e-01, -1.059412e-01,  3.416324e-02, -5.156683e-01,  2.367591e-01},
  { 7.869427e-01, -3.916849e-01, -4.767641e-01,  2.047003e-01, -4.929208e-01,  2.163639e-01},
  {-7.199591e-01, -2.114827e-01, -6.610098e-01, -5.177229e-02, -4.851004e-01,  2.531947e-01},
  { 3.520510e-01,  8.567497e-01,  3.768821e-01, -4.443648e-01, -4.924004e-01,  2.331649e-01},
  {-8.269119e-01, -3.410446e-01,  4.471077e-01, -5.151580e-01, -5.066602e-01,  2.374469e-01},
  {-7.785754e-01, -3.621448e-01, -5.125149e-01, -3.926392e-02, -4.821726e-01,  2.415971e-01},
  {-3.621957e-01,  8.704699e-01,  3.333113e-01, -2.846559e-01, -4.892328e-01,  2.084405e-01},
  { 1.693150e-01,  9.124798e-01,  3.724424e-01, -4.265375e-01, -4.913155e-01,  2.163165e-01},
  { 2.288872e-01,  8.588394e-01,  4.582636e-01, -3.546948e-01, -4.948767e-01,  1.922067e-01},
  {-8.933790e-01, -2.894932e-01,  3.436099e-01,  1.432214e-02, -4.998844e-01,  1.711229e-01},
  { 5.253370e-01, -3.080600e-01,  7.931708e-01, -1.756637e-01, -5.022593e-01,  1.507970e-01},
  {-5.159605e-01,  3.211259e-01, -7.941429e-01, -4.286805e-01, -4.866666e-01,  1.322396e-01},
  { 9.596356e-01, -4.518827e-02, -2.775926e-01,  4.035036e-01, -4.874399e-01,  1.031317e-01},
  {-3.422179e-01,  6.791460e-01, -6.493440e-01, -3.669546e-01, -4.853779e-01,  9.980896e-02},
  { 8.952760e-01, -2.835706e-01,  3.436112e-01,  3.504856e-01, -4.998783e-01,  1.424438e-02},
  {-5.354048e-01,  8.072307e-01, -2.484358e-01, -2.669942e-01, -4.786846e-01,  7.113107e-03},
  {-2.240970e-01,  7.820879e-01,  5.814800e-01, -3.471577e-01, -4.959161e-01, -3.949270e-02},
  {-2.780188e-01,  9.012053e-01,  3.324676e-01, -5.382609e-01, -5.049719e-01, -5.032248e-02},
  {-6.227164e-01,  6.933483e-01,  3.626189e-01, -5.518750e-01, -5.117268e-01, -4.366498e-02},
  { 6.238627e-01, -7.365109e-01,  2.614330e-01,  5.320971e-01, -4.841022e-01, -6.274913e-02},
  { 9.457262e-01, -3.227345e-01,  3.800563e-02,  5.250795e-01, -4.908914e-01, -8.447155e-02},
  { 6.410284e-01, -7.658277e-01, -5.089823e-02,  5.306942e-01, -4.830818e-01, -1.434376e-01},
  {-2.778117e-01, -7.939188e-01, -5.408452e-01, -2.432479e-01, -5.097654e-01, -1.445144e-01},
  {-2.903497e-01, -5.083465e-01, -8.107285e-01, -3.709622e-01, -5.061892e-01, -1.424045e-01},
  { 6.835270e-01, -6.884606e-01, -2.425135e-01,  5.264905e-01, -4.849876e-01, -1.646552e-01},
  {-7.406619e-01, -6.715183e-01,  2.198053e-02, -2.019420e-01, -5.021796e-01, -2.217684e-01},
  {-3.811880e-01, -1.384759e-01,  9.140679e-01, -2.431322e-01, -4.877799e-01, -2.913122e-01},
  { 1.577411e-01, -3.647533e-01, -9.176452e-01,  1.659665e-01, -5.033895e-01, -3.354435e-01},
  {-4.984506e-01, -8.088837e-01, -3.118560e-01, -4.574563e-01, -5.012135e-01, -3.670790e-01},
  {-5.806722e-01, -7.493228e-01,  3.183318e-01, -2.848213e-01, -5.012125e-01, -4.482799e-01},
  {-1.234981e-01,  5.287291e-01, -8.397582e-01,  9.407843e-02, -4.918975e-01, -4.713483e-01},
  { 3.722664e-01,  2.802562e-01, -8.848017e-01, -3.815253e-01, -4.799965e-01, -5.246845e-01},
  {-5.193397e-01, -8.545623e-01, -3.076115e-03, -4.494324e-01, -4.937754e-01, -5.441632e-01},
  { 6.109081e-01,  1.067664e-01, -7.844694e-01, -4.634823e-01, -4.859664e-01, -5.865465e-01},
  {-2.910112e-01, -2.605886e-01, -9.205466e-01, -4.851748e-01, -4.844645e-01, -6.019149e-01},
  {-6.036368e-01, -7.740785e-01, -1.908533e-01, -4.877990e-01, -4.818020e-01, -5.901478e-01},
  {-2.720476e-01, -8.262131e-01, -4.933172e-01, -2.479506e-01, -4.916406e-01, -6.888120e-01},
  { 3.071716e-01,  5.542104e-01, -7.736256e-01, -2.281522e-01, -5.090245e-01, -6.954744e-01},
  { 4.565607e-01,  1.360495e-01, -8.792285e-01, -2.339499e-01, -4.911377e-01, -6.868349e-01},
  { 1.834112e-01,  8.034358e-01, -5.664373e-01, -2.452424e-01, -5.270051e-01, -7.271527e-01},
  { 7.020723e-01, -6.802711e-01, -2.105362e-01,  2.904164e-01, -4.828213e-01,  7.837014e-01},
  {-1.431776e-01,  7.009817e-01,  6.986593e-01,  7.380334e-02, -4.944059e-01,  6.777332e-01},
  { 1.842517e-01, -2.286458e-01,  9.559144e-01, -1.873671e-01, -4.678291e-01,  6.448527e-01},
  {-2.442363e-01,  8.535659e-01,  4.601889e-01,  1.621180e-02, -4.775333e-01,  6.320980e-01},
  { 7.137753e-01,  3.985372e-01,  5.759278e-01,  2.758368e-01, -4.701600e-01,  5.688915e-01},
  { 2.729014e-01,  7.574131e-01,  5.931695e-01, -1.574935e-01, -4.668141e-01,  5.594538e-01},
  { 1.776805e-01, -9.800047e-01,  8.955746e-02,  6.734797e-02, -4.898973e-01,  4.558972e-01},
  { 6.936722e-02, -2.933860e-01,  9.534741e-01,  9.440026e-03, -5.005986e-01,  4.501218e-01},
  { 9.118180e-01,  4.099028e-01, -2.382332e-02,  2.547825e-01, -4.663705e-01,  4.009686e-01},
  {-7.816201e-01,  5.239460e-02, -6.215503e-01, -9.410927e-02, -4.741787e-01,  3.339602e-01},
  {-3.280261e-01,  7.845905e-01,  5.261337e-01, -2.494476e-01, -4.871221e-01,  2.445961e-01},
  { 8.816868e-01, -4.217617e-01,  2.115313e-01,  1.986624e-01, -4.855582e-01,  1.819132e-01},
  {-1.684791e-01,  5.463260e-01,  8.204527e-01, -3.010111e-01, -4.759139e-01,  1.718636e-01},
  { 1.966133e-01,  4.217406e-01,  8.851430e-01, -3.632773e-01, -4.676456e-01,  1.676411e-01},
  {-4.407544e-01, -5.022516e-02, -8.962215e-01, -4.593891e-01, -4.856706e-01,  1.532801e-01},
  {-7.000153e-02, -1.973847e-01,  9.778236e-01,  2.589141e-01, -4.710792e-01,  1.442598e-01},
  {-5.207847e-01,  7.654810e-01, -3.779181e-01, -2.889715e-01, -4.752131e-01,  4.318720e-02},
  { 6.104316e-01, -6.201817e-01,  4.926947e-01,  5.243174e-01, -4.656715e-01, -2.454839e-02},
  {-3.713501e-01,  8.619084e-01,  3.452722e-01, -2.593185e-01, -4.741101e-01, -1.740316e-02},
  {-4.710356e-01,  5.165694e-01,  7.150395e-01, -3.931989e-01, -4.706556e-01, -8.870348e-02},
  {-2.315103e-01,  8.377597e-01,  4.945316e-01, -4.248687e-01, -4.790602e-01, -9.716593e-02},
  { 9.854973e-01, -1.671626e-01,  2.918551e-02,  5.423601e-01, -4.602549e-01, -1.428601e-01},
  {-5.764833e-01,  5.865440e-01,  5.688877e-01, -5.012073e-01, -4.769901e-01, -1.311601e-01},
  {-1.884996e-01, -8.860198e-01, -4.235999e-01, -2.476659e-01, -4.896293e-01, -1.783376e-01},
  {-5.680619e-01,  7.965285e-01,  2.069977e-01, -5.822929e-01, -4.928923e-01, -1.641625e-01},
  {-5.026737e-01, -8.497813e-01, -1.587166e-01, -2.198470e-01, -4.926645e-01, -1.927947e-01},
  {-3.915653e-01,  1.205249e-01, -9.122227e-01, -5.469348e-01, -4.815636e-01, -1.650500e-01},
  {-1.732367e-01, -4.707140e-01, -8.651111e-01, -3.354440e-01, -4.685371e-01, -1.913013e-01},
  {-5.825858e-01, -5.887446e-01, -5.603335e-01, -2.459595e-01, -4.643197e-01, -2.124362e-01},
  { 9.676962e-01,  2.418312e-01,  7.128642e-02,  3.255512e-01, -4.774149e-01, -3.059818e-01},
  { 3.760301e-01, -5.033633e-01, -7.779633e-01,  1.275889e-01, -4.828345e-01, -3.573914e-01},
  { 6.711884e-01, -5.452733e-01, -5.021785e-01,  9.020523e-02, -4.853276e-01, -3.785813e-01},
  { 6.940374e-01, -6.200047e-01, -3.659322e-01,  9.599077e-02, -4.730424e-01, -3.869425e-01},
  {-2.748454e-01, -6.790977e-01, -6.806514e-01, -3.219470e-01, -4.905378e-01, -3.983275e-01},
  { 8.164479e-01, -2.874276e-01,  5.007977e-01,  8.789017e-02, -4.849909e-01, -4.077262e-01},
  {-8.207679e-01, -3.530885e-01, -4.490752e-01, -5.184013e-01, -4.639181e-01, -4.018424e-01},
  {-7.597130e-01,  2.033174e-01,  6.176554e-01,  2.133539e-01, -5.075202e-01, -4.658684e-01},
  {-5.586711e-01, -8.293372e-01,  9.299479e-03, -5.132648e-01, -4.695903e-01, -4.887733e-01},
  {-1.488559e-01,  4.483412e-01, -8.813808e-01, -3.105995e-01, -4.736937e-01, -5.073584e-01},
  { 2.647120e-01,  1.230281e-01, -9.564474e-01, -3.497557e-01, -4.707534e-01, -5.078438e-01},
  {-3.623844e-01, -6.473885e-01,  6.704966e-01, -4.064784e-01, -4.820976e-01, -4.915796e-01},
  {-4.969946e-01,  7.744844e-01, -3.913697e-01, -2.426215e-01, -4.749120e-01, -5.370715e-01},
  {-4.718148e-01, -8.129070e-01,  3.414274e-01, -5.345209e-01, -4.686160e-01, -5.278897e-01},
  {-6.007871e-01,  6.343718e-01, -4.864435e-01, -5.310638e-01, -4.694619e-01, -5.419658e-01},
  { 4.720249e-01,  2.174196e-01, -8.543543e-01, -4.686933e-01, -4.718497e-01, -5.886833e-01},
  { 2.603313e-01,  6.790615e-01, -6.863695e-01, -1.795434e-01, -4.742353e-01, -6.196430e-01},
  {-8.005179e-01, -4.252273e-01, -4.223184e-01, -2.706802e-01, -4.901772e-01, -6.377404e-01},
  { 8.632810e-01, -2.632138e-01, -4.306558e-01,  5.150542e-02, -4.735213e-01, -6.342700e-01},
  { 2.003042e-01, -8.568378e-02, -9.759797e-01, -2.155580e-02, -4.699427e-01, -6.374889e-01},
  { 1.142559e-01, -4.727308e-01, -8.737684e-01, -2.518519e-01, -4.790279e-01, -6.966133e-01},
  {-2.755175e-01, -9.245607e-01, -2.632065e-01, -2.636217e-01, -4.719844e-01, -7.090344e-01},
  {-6.681237e-02, -2.641944e-01,  9.621524e-01,  2.743357e-01, -4.473913e-01,  8.618742e-01},
  { 4.816710e-01, -8.687405e-01, -1.152511e-01,  3.178211e-01, -4.638090e-01,  7.856449e-01},
  { 7.595521e-01, -4.493450e-02,  6.488925e-01, -1.835446e-01, -4.412155e-01,  6.441794e-01},
  { 9.288643e-01,  1.993286e-01,  3.122166e-01, -1.777343e-01, -4.482184e-01,  6.284091e-01},
  { 9.487430e-01,  2.791569e-01,  1.481829e-01, -1.750742e-01, -4.502438e-01,  5.763245e-01},
  { 8.557709e-01,  4.504415e-01, -2.544773e-01,  2.800864e-01, -4.600980e-01,  5.101680e-01},
  {-6.877416e-01,  2.669278e-01, -6.751009e-01, -2.777992e-01, -4.514836e-01,  4.725468e-01},
  { 7.270121e-01,  6.601891e-01, -1.886896e-01,  2.595589e-01, -4.632655e-01,  4.355463e-01},
  { 8.825583e-01,  4.244597e-01, -2.022988e-01,  2.502359e-01, -4.538004e-01,  4.191408e-01},
  {-2.688269e-01, -2.572216e-01,  9.282075e-01,  4.104575e-01, -4.371570e-01,  3.603114e-01},
  { 8.141720e-01,  4.453785e-01,  3.725076e-01,  2.521571e-01, -4.530091e-01,  3.531716e-01},
  { 2.104321e-01,  9.614835e-01,  1.768270e-01, -5.087503e-01, -4.587006e-01,  2.349257e-01},
  {-3.637938e-01,  5.520164e-01,  7.502878e-01, -5.189061e-01, -4.692949e-01,  2.502646e-01},
  {-6.014183e-01,  5.976444e-01,  5.302048e-01, -5.283524e-01, -4.588256e-01,  2.278344e-01},
  { 8.072416e-01, -5.749272e-01, -1.334909e-01,  2.119859e-01, -4.663060e-01,  1.950354e-01},
  {-9.285265e-01, -3.610789e-01, -8.637514e-02, -5.417324e-01, -4.592520e-01,  2.005064e-01},
  {-7.547274e-01, -6.520937e-01,  7.183467e-02, -1.571340e-02, -4.565999e-01,  1.692084e-01},
  {-5.586290e-01, -4.716962e-01, -6.822289e-01, -4.702632e-01, -4.673842e-01,  1.535766e-01},
  {-2.127195e-01,  3.298502e-01,  9.197550e-01, -2.857787e-01, -4.481498e-01,  1.638937e-01},
  { 2.104349e-01,  3.557287e-01,  9.105901e-01, -3.746096e-01, -4.457698e-01,  1.624350e-01},
  {-6.597053e-01, -5.802220e-01,  4.776309e-01, -2.263370e-02, -4.682491e-01,  1.396104e-01},
  {-6.725678e-01,  7.155361e-01,  1.888400e-01, -2.428829e-01, -4.574013e-01, -2.413170e-02},
  {-3.555164e-01,  6.830934e-01,  6.379589e-01, -2.642263e-01, -4.471098e-01, -5.512195e-02},
  {-9.060907e-01,  4.045874e-01, -1.237279e-01, -5.387855e-01, -4.689613e-01, -1.617302e-01},
  {-5.995465e-01, -2.842533e-01, -7.481605e-01, -5.333627e-01, -4.487900e-01, -1.748848e-01},
  {-8.555738e-01, -2.140450e-01,  4.713580e-01, -2.339637e-01, -4.523509e-01, -2.697345e-01},
  {-3.279692e-01,  6.594259e-01,  6.764567e-01, -5.041665e-01, -4.764090e-01, -3.037725e-01},
  { 6.455824e-01, -1.901224e-01, -7.396464e-01,  3.154170e-01, -4.664520e-01, -3.296537e-01},
  { 6.336216e-01, -6.672949e-01, -3.914605e-01,  1.129124e-01, -4.543061e-01, -3.881462e-01},
  {-2.056967e-01, -8.851658e-01, -4.173372e-01, -3.267180e-01, -4.771143e-01, -4.202730e-01},
  {-5.948062e-03, -9.140850e-01, -4.054789e-01, -3.571080e-01, -4.698974e-01, -4.253070e-01},
  {-3.325174e-01, -9.358066e-01,  1.170392e-01, -3.353381e-01, -4.735203e-01, -4.414916e-01},
  { 9.382332e-02, -9.267251e-01, -3.638377e-01, -4.457494e-01, -4.711151e-01, -4.515305e-01},
  {-2.782686e-01, -7.542462e-01,  5.947094e-01, -3.716222e-01, -4.726143e-01, -4.613082e-01},
  { 7.338635e-02, -3.736361e-01, -9.246678e-01,  2.113513e-01, -4.625643e-01, -4.831300e-01},
  {-3.486177e-01,  5.146449e-01, -7.833303e-01, -2.623277e-01, -4.558473e-01, -5.090867e-01},
  { 1.001741e-01,  1.091858e-01, -9.889609e-01, -3.148620e-01, -4.483123e-01, -5.005571e-01},
  {-1.127463e-01, -9.523144e-01,  2.835231e-01, -4.481875e-01, -4.693327e-01, -5.017369e-01},
  {-7.014377e-01, -4.178829e-01, -5.773726e-01, -5.156673e-01, -4.639705e-01, -5.674006e-01},
  {-4.670098e-01,  4.068324e-01, -7.851046e-01, -4.920088e-01, -4.665325e-01, -5.866004e-01},
  {-5.815871e-01,  6.316395e-01, -5.126287e-01, -1.647765e-01, -4.537005e-01, -6.076874e-01},
  {-3.037535e-01,  9.269056e-01,  2.204082e-01, -2.320220e-01, -4.693491e-01, -6.281117e-01},
  { 1.725239e-01,  6.606655e-02, -9.827872e-01,  3.826633e-02, -4.615866e-01, -6.413325e-01},
  { 6.781127e-02,  9.861951e-01, -1.510656e-01, -2.427153e-01, -4.694020e-01, -6.643128e-01},
  { 4.139068e-01,  8.007822e-01, -4.329308e-01, -2.468114e-01, -4.722352e-01, -6.905029e-01},
  { 5.686736e-01, -4.024946e-01,  7.173621e-01,  3.235101e-01, -4.270538e-01,  8.589084e-01},
  { 7.593673e-01, -5.110794e-01,  4.026900e-01,  3.672096e-01, -4.328261e-01,  8.132641e-01},
  { 7.897781e-01, -4.640252e-01,  4.011620e-01,  3.850873e-01, -4.269282e-01,  7.874936e-01},
  { 5.493467e-01, -8.248935e-01,  1.333000e-01,  4.028275e-01, -4.334673e-01,  7.391730e-01},
  { 7.309541e-01, -6.655662e-01, -1.507572e-01,  4.188323e-01, -4.273702e-01,  6.761442e-01},
  { 3.227348e-01, -9.016755e-01, -2.877907e-01,  4.014581e-01, -4.332120e-01,  6.546766e-01},
  { 4.107816e-02, -1.110917e-01,  9.929608e-01, -1.885727e-01, -4.299457e-01,  6.483766e-01},
  {-5.111528e-01, -3.549979e-01,  7.827511e-01, -2.104405e-01, -4.430379e-01,  6.396787e-01},
  { 9.499954e-04,  8.614206e-01,  5.078915e-01,  8.211657e-02, -4.574810e-01,  5.907421e-01},
  { 9.654337e-01, -5.516716e-02,  2.547435e-01,  2.656574e-01, -4.411101e-01,  5.736639e-01},
  {-6.621085e-01, -6.033667e-01,  4.444781e-01, -2.867838e-01, -4.382658e-01,  5.697261e-01},
  {-9.689552e-01,  7.840186e-02, -2.344761e-01, -2.966520e-01, -4.364852e-01,  5.332651e-01},
  {-3.661823e-01,  8.440481e-01,  3.917824e-01,  2.290959e-02, -4.385671e-01,  4.831425e-01},
  {-7.179871e-01,  2.424406e-02, -6.956341e-01, -2.033862e-01, -4.321584e-01,  4.124687e-01},
  {-7.807445e-01, -2.458940e-01, -5.744339e-01, -1.150427e-01, -4.437094e-01,  3.501948e-01},
  {-8.189415e-01, -1.065026e-01, -5.639079e-01, -7.545128e-02, -4.368545e-01,  3.025245e-01},
  {-6.144820e-01,  4.743475e-01,  6.304017e-01, -5.469438e-01, -4.414511e-01,  1.993903e-01},
  { 8.883584e-01, -1.407275e-01,  4.370527e-01,  4.181224e-01, -4.420126e-01,  1.541666e-01},
  { 7.494140e-01, -5.951254e-01,  2.901798e-01,  2.325301e-01, -4.459489e-01,  1.697160e-01},
  { 1.033900e-01, -3.328638e-01,  9.372898e-01,  2.931327e-01, -4.488460e-01,  1.467285e-01},
  { 4.523672e-01, -4.992528e-01,  7.389930e-01,  2.470916e-01, -4.498343e-01,  1.530294e-01},
  {-2.625590e-01, -5.990318e-01,  7.564547e-01, -3.878635e-02, -4.518790e-01,  1.431171e-01},
  { 6.704281e-01,  1.650334e-01, -7.233879e-01,  4.032578e-01, -4.455472e-01,  1.003207e-01},
  { 7.899812e-01,  2.433812e-01, -5.627568e-01,  3.543395e-01, -4.413255e-01,  6.518044e-02},
  { 6.623680e-01, -3.998031e-01,  6.335819e-01,  5.321557e-01, -4.285457e-01,  5.262182e-03},
  {-6.152083e-01,  7.196630e-01, -3.218754e-01, -2.107516e-01, -4.281710e-01,  4.940850e-03},
  { 9.884570e-01, -6.401474e-02,  1.373131e-01,  5.415045e-01, -4.233962e-01, -1.653517e-02},
  {-8.225075e-01, -3.130392e-01, -4.748557e-01, -5.437430e-01, -4.270211e-01, -1.744315e-01},
  { 8.670567e-02, -2.639681e-01, -9.606264e-01, -4.046228e-01, -4.385325e-01, -2.001541e-01},
  { 8.234481e-03, -7.144153e-02, -9.974108e-01, -4.581112e-01, -4.289215e-01, -2.024762e-01},
  { 3.479795e-01, -2.913184e-01, -8.910914e-01,  5.256199e-01, -4.292602e-01, -2.394264e-01},
  {-7.264025e-01, -3.965546e-01, -5.613233e-01, -5.671805e-01, -4.245861e-01, -3.854234e-01},
  {-7.981378e-02, -9.967812e-01, -7.559109e-03, -4.172322e-01, -4.658171e-01, -4.634410e-01},
  {-1.977940e-01, -2.279312e-01, -9.533755e-01,  1.778982e-01, -4.450299e-01, -4.928702e-01},
  {-3.365411e-01,  5.702421e-02, -9.399406e-01, -2.548018e-01, -4.345604e-01, -5.086977e-01},
  { 3.065448e-01, -8.766783e-02, -9.478104e-01, -3.585230e-01, -4.418530e-01, -5.071043e-01},
  { 9.954277e-01,  3.372785e-02, -8.936572e-02, -7.953378e-02, -4.386530e-01, -5.149614e-01},
  {-6.763274e-01,  4.804857e-01, -5.583142e-01, -2.103820e-01, -4.355980e-01, -5.344465e-01},
  {-9.072475e-01,  4.167247e-01,  5.694276e-02, -5.299520e-01, -4.498799e-01, -5.200943e-01},
  { 7.925391e-01, -3.870921e-01,  4.712128e-01,  5.076484e-02, -4.501008e-01, -5.987889e-01},
  { 9.049770e-01, -3.620915e-01,  2.233971e-01,  6.201889e-02, -4.376017e-01, -6.078876e-01},
  {-6.985224e-01,  1.204634e-01, -7.053759e-01, -1.450170e-01, -4.350907e-01, -6.090997e-01},
  { 5.158144e-01, -2.053978e-03, -8.566979e-01,  4.728150e-02, -4.494562e-01, -6.348936e-01},
  { 3.814031e-01,  1.730118e-03, -9.244072e-01, -1.141755e-01, -4.199673e-01, -6.882153e-01},
  { 3.596241e-01,  6.143976e-02,  9.310724e-01,  3.150398e-01, -4.180093e-01,  8.657991e-01},
  {-1.427142e-01,  8.684141e-02,  9.859469e-01,  2.860421e-01, -4.134293e-01,  8.716214e-01},
  { 8.374962e-01, -4.648471e-01,  2.872584e-01,  4.201669e-01, -4.220157e-01,  7.124962e-01},
  { 9.782312e-01, -1.922236e-01, -7.819116e-02,  4.275796e-01, -4.072125e-01,  6.771522e-01},
  { 7.144325e-01, -6.021648e-01, -3.563477e-01,  2.838736e-01, -4.224320e-01,  6.350610e-01},
  { 5.504217e-01, -7.878915e-01, -2.761576e-01,  4.202805e-01, -4.093581e-01,  6.112162e-01},
  { 4.244735e-01, -8.382988e-01, -3.421658e-01,  4.153069e-01, -4.085593e-01,  6.021306e-01},
  {-9.761841e-01, -5.768336e-02,  2.091346e-01, -2.967543e-01, -4.150839e-01,  5.767581e-01},
  { 9.882527e-01, -1.065996e-01,  1.095129e-01,  2.662367e-01, -4.306700e-01,  5.744693e-01},
  { 9.975765e-01,  2.112594e-02, -6.629320e-02,  2.664539e-01, -4.148453e-01,  5.226657e-01},
  {-8.005109e-01, -5.945243e-01,  7.565079e-02, -2.933212e-01, -4.341443e-01,  5.145262e-01},
  { 4.803675e-01,  4.757141e-01,  7.368467e-01, -7.684837e-02, -4.301347e-01,  4.631948e-01},
  { 6.009777e-01,  4.013305e-01,  6.912017e-01, -1.311070e-01, -4.119081e-01,  4.810126e-01},
  { 7.012151e-01, -2.807642e-01,  6.553388e-01,  4.232062e-01, -4.142527e-01,  3.713321e-01},
  {-4.575186e-01, -3.845140e-02,  8.883683e-01,  3.822830e-01, -4.127501e-01,  3.565948e-01},
  { 8.174607e-01,  2.444517e-01,  5.215375e-01,  2.337952e-01, -4.041891e-01,  3.375815e-01},
  {-8.545303e-01, -1.141885e-01, -5.066941e-01, -4.145125e-02, -4.271764e-01,  2.518330e-01},
  { 6.454805e-01, -6.517405e-01, -3.982328e-01,  2.611807e-01, -4.247960e-01,  2.201937e-01},
  {-8.479177e-01, -5.118045e-01,  1.381733e-01, -2.466750e-02, -4.279450e-01,  2.118635e-01},
  { 4.907105e-01, -1.817153e-01,  8.521636e-01,  4.146276e-01, -4.173334e-01,  1.675834e-01},
  { 3.675847e-01, -7.176516e-01,  5.914877e-01,  2.482501e-01, -4.301443e-01,  1.768093e-01},
  {-1.157627e-01, -2.335983e-01,  9.654174e-01, -9.287176e-02, -4.120856e-01,  1.668762e-01},
  {-1.557332e-04, -2.298709e-01,  9.732211e-01, -3.363665e-01, -4.185921e-01,  1.645488e-01},
  { 9.299205e-02,  5.639715e-01,  8.205417e-01, -4.469665e-01, -4.143365e-01,  1.591164e-01},
  { 9.904469e-01,  1.435274e-02, -1.371457e-01,  4.224198e-01, -4.264988e-01,  1.348829e-01},
  {-2.808786e-01, -2.569156e-01, -9.247170e-01, -4.522416e-01, -4.178953e-01,  1.010868e-01},
  { 5.988141e-01, -2.245578e-01,  7.687623e-01,  5.218588e-01, -4.154525e-01,  1.875669e-02},
  {-6.486261e-01,  6.797442e-01, -3.423914e-01, -1.988704e-01, -4.132506e-01,  1.733295e-02},
  {-5.960712e-01, -8.310475e-02,  7.986193e-01, -4.292790e-01, -4.160083e-01, -1.376355e-01},
  {-9.767982e-01,  3.931962e-02,  2.105207e-01, -5.501549e-01, -4.104393e-01, -1.719206e-01},
  { 7.257441e-01, -2.694699e-01, -6.329941e-01,  5.317026e-01, -4.135885e-01, -2.472823e-01},
  { 6.872401e-01,  7.159596e-01,  1.228939e-01,  2.671173e-01, -4.158280e-01, -3.072913e-01},
  { 8.506634e-01,  4.915901e-01,  1.863088e-01,  3.112638e-01, -4.347228e-01, -3.235849e-01},
  {-8.769971e-01, -4.614583e-01,  1.339120e-01, -5.728900e-01, -4.177642e-01, -3.720423e-01},
  { 5.786573e-01, -3.001098e-01, -7.583467e-01,  2.853930e-01, -4.104613e-01, -3.681254e-01},
  {-8.798606e-01, -1.974089e-02, -4.748218e-01, -5.726910e-01, -4.085995e-01, -3.840177e-01},
  {-9.517279e-01, -1.338449e-01, -2.762238e-01, -5.027685e-01, -4.209418e-01, -4.411933e-01},
  { 2.544062e-01,  8.451813e-01,  4.700489e-01,  1.537434e-01, -4.297418e-01, -4.625322e-01},
  { 9.766945e-01, -1.174076e-01, -1.796755e-01,  1.433361e-01, -4.185327e-01, -4.519521e-01},
  { 3.162615e-01,  7.954419e-01, -5.169631e-01,  1.975089e-01, -4.405402e-01, -4.934910e-01},
  {-4.404693e-01,  5.394176e-01, -7.176458e-01,  1.496958e-01, -4.285960e-01, -4.756133e-01},
  {-1.984951e-02, -2.526640e-01, -9.673505e-01, -2.873854e-01, -4.224946e-01, -5.037194e-01},
  {-5.149469e-01,  1.910215e-01, -8.356677e-01, -2.058681e-01, -4.206732e-01, -5.283893e-01},
  {-7.661788e-01,  5.479501e-01, -3.357390e-01, -5.103871e-01, -4.274832e-01, -5.036376e-01},
  {-7.646564e-01,  1.560745e-01, -6.252531e-01, -1.749728e-01, -4.300108e-01, -5.913727e-01},
  {-8.760669e-01, -2.068672e-01, -4.355603e-01, -1.275896e-01, -4.166882e-01, -6.307209e-01},
  { 7.229866e-01, -6.834062e-02, -6.874736e-01,  6.662301e-02, -4.205815e-01, -6.233713e-01},
  {-4.517625e-01, -5.485242e-02,  8.904504e-01,  2.477544e-01, -4.055147e-01,  8.640082e-01},
  { 6.744091e-01,  3.088370e-01,  6.706654e-01,  3.632535e-01, -4.081174e-01,  8.303306e-01},
  { 8.262146e-01,  2.994188e-01,  4.771979e-01,  3.786307e-01, -4.059094e-01,  7.968417e-01},
  {-7.397508e-01, -4.988564e-01,  4.515651e-01,  2.064654e-01, -4.048747e-01,  7.893102e-01},
  { 5.461498e-02, -6.867842e-01,  7.248065e-01,  2.985595e-02, -3.912313e-01,  7.340623e-01},
  {-2.882236e-02, -7.327385e-01,  6.798997e-01,  1.518965e-02, -3.907663e-01,  7.351351e-01},
  {-3.317215e-01, -9.123495e-01,  2.399570e-01,  3.437402e-03, -3.966892e-01,  7.236897e-01},
  {-1.539648e-01, -9.783691e-01,  1.381626e-01,  2.629991e-02, -3.971502e-01,  7.140374e-01},
  {-6.231129e-01, -7.793298e-01, -6.614912e-02, -2.546528e-02, -3.930040e-01,  6.464898e-01},
  { 9.578332e-01, -2.140432e-01, -1.916794e-01,  4.267060e-01, -3.907792e-01,  6.090602e-01},
  {-1.842587e-01, -9.049317e-01, -3.835979e-01, -2.606397e-02, -3.899581e-01,  6.364225e-01},
  {-6.722869e-01, -2.152905e-01,  7.082939e-01, -2.806268e-01, -4.069420e-01,  5.986033e-01},
  {-8.929202e-01, -3.205007e-02,  4.490727e-01, -2.922588e-01, -4.002933e-01,  5.887203e-01},
  { 9.950292e-01, -9.082001e-02,  4.084868e-02, -1.787562e-01, -4.057192e-01,  5.750067e-01},
  { 4.116124e-01, -8.175036e-01, -4.028190e-01,  4.145222e-01, -3.965418e-01,  5.751948e-01},
  { 7.915000e-01, -5.877002e-01, -1.677388e-01,  2.726614e-01, -4.112831e-01,  5.795178e-01},
  {-6.559253e-01,  6.304216e-01, -4.151272e-01, -2.531321e-01, -3.936213e-01,  5.389984e-01},
  { 8.967724e-01,  3.845830e-02,  4.408178e-01, -1.712752e-01, -4.056192e-01,  5.335233e-01},
  { 7.567229e-01,  9.558254e-02,  6.467104e-01, -1.392001e-01, -3.977855e-01,  4.826575e-01},
  {-6.600689e-01,  4.540582e-01,  5.984481e-01,  4.846305e-02, -4.041727e-01,  4.611794e-01},
  {-7.264345e-01,  2.425295e-01,  6.430182e-01,  5.344817e-02, -3.969256e-01,  4.657394e-01},
  { 9.336991e-01, -1.045052e-01, -3.424682e-01,  2.489652e-01, -3.994103e-01,  4.269043e-01},
  {-4.099611e-01,  5.182357e-01,  7.505755e-01, -2.746073e-02, -3.991063e-01,  4.099407e-01},
  {-8.885647e-01, -3.718423e-01, -2.686746e-01, -3.814591e-02, -4.079275e-01,  2.280148e-01},
  { 1.914499e-01, -5.721632e-01,  7.974811e-01,  3.002794e-01, -4.131783e-01,  1.645716e-01},
  { 5.764230e-01, -6.960052e-01,  4.281510e-01,  2.714391e-01, -4.128439e-01,  1.745686e-01},
  {-7.150398e-01,  5.662582e-01,  4.099632e-01, -5.530849e-01, -3.979302e-01,  1.449161e-01},
  { 1.248764e-02, -1.266844e-01,  9.918645e-01, -1.950437e-01, -3.940156e-01,  1.617836e-01},
  {-3.005332e-01, -4.683818e-01,  8.308418e-01, -4.087852e-01, -3.967789e-01,  1.604621e-01},
  { 8.901460e-01,  6.849448e-02, -4.504981e-01,  3.614776e-01, -3.955055e-01,  8.787647e-02},
  {-1.677949e-01, -4.054638e-01, -8.985789e-01, -4.894171e-01, -4.015256e-01,  1.004283e-01},
  {-4.909622e-01,  3.549765e-01, -7.955802e-01, -2.698947e-01, -4.097819e-01,  6.691985e-02},
  {-6.055290e-01,  5.701228e-01, -5.552428e-01, -1.877253e-01, -3.884179e-01,  3.728292e-02},
  {-6.342102e-01,  7.575936e-01,  1.543670e-01, -2.013665e-01, -4.107663e-01, -3.262751e-02},
  {-3.453521e-01,  2.052222e-02,  9.382488e-01, -3.839213e-01, -4.023286e-01, -8.191718e-02},
  {-2.660431e-01,  3.449768e-01,  9.001178e-01, -4.821282e-01, -4.029907e-01, -1.635492e-01},
  {-2.805152e-01,  2.859434e-01,  9.162683e-01, -5.512785e-01, -4.025559e-01, -1.733288e-01},
  {-8.852702e-01, -2.355472e-01, -4.010164e-01, -2.422093e-01, -4.120162e-01, -2.393026e-01},
  { 1.000730e-01, -6.570549e-02, -9.928082e-01,  5.248331e-01, -3.966845e-01, -2.532847e-01},
  { 1.985072e-01,  9.504023e-01, -2.394373e-01,  2.452138e-01, -4.017575e-01, -3.039895e-01},
  { 1.499609e-01,  9.680377e-01,  2.010341e-01,  2.206091e-01, -3.989744e-01, -3.241581e-01},
  { 5.271635e-01, -8.292410e-01,  1.856283e-01, -5.617935e-01, -3.998459e-01, -3.312509e-01},
  {-7.636910e-01,  3.841270e-01,  5.188664e-01, -5.661514e-01, -4.015703e-01, -3.327335e-01},
  {-7.658814e-01, -4.559635e-01,  4.533466e-01, -5.703174e-01, -4.101661e-01, -3.531466e-01},
  { 8.470901e-01,  3.548007e-01, -3.956701e-01,  2.941782e-01, -4.051953e-01, -3.562758e-01},
  {-1.801750e-01, -6.096732e-02, -9.817433e-01,  6.683019e-02, -4.054222e-01, -4.375482e-01},
  { 1.783304e-01,  1.849543e-01, -9.664317e-01,  2.843582e-02, -4.024559e-01, -4.350986e-01},
  { 3.740877e-01,  8.017678e-02, -9.239210e-01, -9.342494e-02, -4.106211e-01, -6.796362e-01},
  {-2.963917e-01,  3.142528e-01,  9.018853e-01,  2.513578e-01, -3.941684e-01,  8.638914e-01},
  {-3.935112e-01, -2.748471e-01,  8.772730e-01,  1.593368e-01, -3.751134e-01,  7.855824e-01},
  {-3.439875e-02,  3.478622e-01,  9.369145e-01,  6.827519e-02, -3.753330e-01,  7.447447e-01},
  { 1.120228e-01, -1.307706e-01,  9.850634e-01,  4.982098e-02, -3.769391e-01,  7.425026e-01},
  {-4.032432e-01, -6.382292e-01,  6.557884e-01, -1.801212e-02, -3.761337e-01,  7.394894e-01},
  {-7.055374e-01, -7.081472e-01,  2.728834e-02, -3.834454e-02, -3.745381e-01,  7.059566e-01},
  {-2.923824e-02, -9.254050e-01, -3.778499e-01,  3.324302e-01, -3.939919e-01,  5.974143e-01},
  { 4.239329e-01, -8.636367e-01, -2.727869e-01,  2.872218e-01, -4.004016e-01,  5.966874e-01},
  {-9.077218e-01,  3.986371e-01,  1.308804e-01, -2.881929e-01, -3.869033e-01,  5.915090e-01},
  {-7.733473e-01,  5.737241e-01, -2.697680e-01, -2.870744e-01, -3.918269e-01,  5.694616e-01},
  { 3.874001e-01, -7.129722e-01, -5.844586e-01,  3.615302e-01, -3.801491e-01,  5.069469e-01},
  { 9.421126e-01, -2.986950e-01, -1.523328e-01,  2.695676e-01, -3.958751e-01,  5.083091e-01},
  {-8.487840e-01, -3.680763e-02,  5.274571e-01,  1.292452e-01, -3.871487e-01,  5.234702e-01},
  {-8.474813e-01,  5.142529e-02, -5.283283e-01, -2.244408e-01, -3.808146e-01,  5.055997e-01},
  { 5.858508e-01, -3.564217e-01, -7.278340e-01,  3.434186e-01, -3.674672e-01,  4.734917e-01},
  { 1.537636e-01, -8.671699e-01, -4.736805e-01,  3.244708e-01, -3.767467e-01,  4.710774e-01},
  {-8.598956e-01,  3.293115e-01, -3.900429e-01, -1.985249e-01, -3.763022e-01,  4.432666e-01},
  {-5.719180e-01, -3.935945e-01,  7.197175e-01,  4.342224e-03, -3.851050e-01,  4.236132e-01},
  { 2.424593e-01, -5.716274e-03,  9.701447e-01,  4.236454e-01, -3.788698e-01,  3.721390e-01},
  {-5.585973e-01, -8.191428e-01, -1.302846e-01, -4.056880e-01, -3.802007e-01,  2.796222e-01},
  {-7.262322e-01, -5.535203e-01, -4.076789e-01, -6.645058e-02, -3.816326e-01,  2.551648e-01},
  { 2.558273e-02, -9.991159e-01,  3.336311e-02, -3.321377e-01, -3.791842e-01,  2.536640e-01},
  {-1.096983e-01, -9.066176e-01, -4.074440e-01, -3.809068e-01, -3.805370e-01,  2.505476e-01},
  { 6.232404e-01, -4.607677e-01,  6.318738e-01,  4.106641e-01, -3.706913e-01,  1.947258e-01},
  { 5.815244e-01, -7.613305e-01,  2.867144e-01,  2.766009e-01, -4.004238e-01,  1.908211e-01},
  {-5.911577e-02,  8.387346e-01,  5.413221e-01, -5.336502e-01, -4.032704e-01,  1.651835e-01},
  {-2.860498e-01, -4.398702e-01,  8.512871e-01, -1.071082e-01, -3.863485e-01,  1.704941e-01},
  { 8.754375e-01,  1.598619e-01, -4.561287e-01,  4.124509e-01, -3.791375e-01,  1.337591e-01},
  {-2.682330e-01, -5.124432e-01, -8.157531e-01, -5.327787e-01, -3.928890e-01,  1.051092e-01},
  {-6.432742e-01, -2.855169e-01, -7.104071e-01, -5.530703e-01, -3.745386e-01,  1.009352e-01},
  { 8.655068e-01,  1.033213e-01, -4.901250e-01,  3.623047e-01, -3.771001e-01,  9.288160e-02},
  { 8.381959e-02,  4.246056e-02, -9.955759e-01, -4.664435e-01, -3.813780e-01,  9.405425e-02},
  {-3.826609e-01,  4.063977e-01, -8.297057e-01, -2.086428e-01, -3.752722e-01,  6.028350e-02},
  { 2.499148e-02,  9.155883e-01, -4.013396e-01,  1.673944e-01, -3.806458e-01, -2.671786e-02},
  { 5.557790e-01,  6.033800e-01, -5.718760e-01,  1.322897e-01, -3.716265e-01, -3.031663e-02},
  {-4.432152e-01,  8.946481e-01, -5.625922e-02, -1.312148e-01, -3.764609e-01, -4.364957e-02},
  {-2.703825e-01,  8.592185e-01, -4.343235e-01,  2.386561e-01, -3.805463e-01, -5.084432e-02},
  {-5.132987e-01,  8.002779e-01,  3.099674e-01, -1.878882e-01, -3.965155e-01, -4.635995e-02},
  { 2.610284e-01,  9.213369e-01, -2.881012e-01,  1.441384e-01, -3.907869e-01, -7.065541e-02},
  { 8.011310e-01,  3.223070e-01, -5.042889e-01,  1.077142e-01, -3.660389e-01, -6.500208e-02},
  {-4.767535e-01,  8.641087e-01, -1.613140e-01,  2.751795e-01, -3.745244e-01, -8.575106e-02},
  { 4.167098e-01,  8.448330e-01, -3.355744e-01,  1.122566e-01, -3.853458e-01, -9.037250e-02},
  { 8.428010e-01,  3.823227e-01, -3.788349e-01,  8.632292e-02, -3.696200e-01, -1.001309e-01},
  {-1.899077e-01,  9.794998e-01,  6.719602e-02,  2.274114e-01, -3.896503e-01, -1.374917e-01},
  { 3.411231e-01,  9.282548e-01, -1.482497e-01,  9.953009e-02, -3.900973e-01, -1.452330e-01},
  { 7.115018e-01,  6.415885e-01, -2.865823e-01,  6.388253e-02, -3.799244e-01, -1.858478e-01},
  { 1.137409e-01,  9.866700e-01,  1.163838e-01,  1.062555e-01, -3.940375e-01, -1.981310e-01},
  { 6.317125e-01,  7.105483e-01, -3.099363e-01,  4.993749e-02, -3.771653e-01, -2.077378e-01},
  {-2.421944e-01,  2.025262e-01, -9.488546e-01, -4.968286e-01, -3.900002e-01, -2.003367e-01},
  { 9.524605e-01,  1.455559e-01, -2.676428e-01,  5.366068e-01, -3.813152e-01, -2.399108e-01},
  { 5.871904e-01,  7.577503e-01, -2.846433e-01,  2.440766e-02, -3.739188e-01, -2.526474e-01},
  { 8.543498e-02,  9.962123e-01,  1.618477e-02,  4.683975e-02, -3.920161e-01, -2.735661e-01},
  { 3.380265e-01,  2.224033e-01, -9.144807e-01,  2.964391e-01, -3.833090e-01, -2.806701e-01},
  { 1.615222e-01,  7.871583e-01, -5.952247e-01,  2.354210e-01, -3.895362e-01, -2.854509e-01},
  {-1.326270e-01,  9.205415e-01, -3.674419e-01,  2.101075e-01, -3.935384e-01, -2.994237e-01},
  { 2.069552e-01,  9.627680e-01, -1.739178e-01,  2.574925e-03, -3.843831e-01, -3.094643e-01},
  { 7.732976e-01,  5.180773e-01, -3.655227e-01, -2.061690e-02, -3.742117e-01, -3.205226e-01},
  { 1.148912e-01,  8.157392e-02,  9.900231e-01, -5.503644e-01, -3.928244e-01, -3.323416e-01},
  {-1.951138e-01,  9.514140e-01,  2.382059e-01,  8.513675e-03, -3.863028e-01, -3.400482e-01},
  {-7.884642e-01,  6.082892e-01,  9.115093e-02, -5.680697e-01, -3.896705e-01, -3.559739e-01},
  { 3.099296e-01,  9.478068e-01,  7.487257e-02, -1.678360e-02, -3.813471e-01, -3.546247e-01},
  {-3.427218e-02,  7.576238e-01,  6.517910e-01,  1.529221e-01, -3.777548e-01, -3.637922e-01},
  { 1.297545e-01,  9.486037e-01,  2.886428e-01, -2.343436e-02, -3.778118e-01, -3.647443e-01},
  { 5.813853e-01,  6.836269e-01,  4.411862e-01, -3.748682e-02, -3.758550e-01, -3.658565e-01},
  {-8.045092e-01,  5.803612e-01, -1.262770e-01, -5.738587e-01, -3.963649e-01, -3.740577e-01},
  { 2.328876e-01, -7.202708e-01, -6.534321e-01,  1.749624e-01, -3.917800e-01, -4.168313e-01},
  {-7.618546e-01,  2.892191e-01, -5.795946e-01, -5.504583e-01, -3.846389e-01, -3.989225e-01},
  { 3.711101e-01, -4.393265e-01, -8.180889e-01,  1.429264e-01, -3.751962e-01, -4.583760e-01},
  {-2.738454e-01, -1.878815e-01, -9.432440e-01, -2.085395e-01, -3.833772e-01, -5.269467e-01},
  {-7.324970e-01, -2.465368e-02, -6.803237e-01, -1.881600e-01, -3.885245e-01, -5.418946e-01},
  {-4.201821e-01, -5.339217e-01, -7.337402e-01, -2.754371e-01, -3.714043e-01, -5.495546e-01},
  { 7.703471e-01, -4.772996e-01,  4.227890e-01,  7.982160e-02, -3.899382e-01, -5.879608e-01},
  { 8.275086e-01,  2.292344e-01,  5.125242e-01,  7.916765e-02, -3.856950e-01, -5.837367e-01},
  {-8.807098e-01, -1.623668e-01, -4.449576e-01, -1.395565e-01, -3.802128e-01, -6.149063e-01},
  { 9.825299e-01,  1.327462e-01, -1.304359e-01,  8.108313e-02, -3.814920e-01, -6.020902e-01},
  {-6.201236e-01, -5.128987e-01, -5.936175e-01, -1.408141e-01, -3.801310e-01, -6.915761e-01},
  {-3.483985e-01, -4.997155e-01, -7.930340e-01, -1.451119e-01, -3.687518e-01, -6.987393e-01},
  { 1.116429e-01,  5.697855e-01,  8.141746e-01,  2.769899e-01, -3.863509e-01,  8.591664e-01},
  {-1.631608e-01,  7.124161e-01,  6.825260e-01,  2.459979e-01, -3.788351e-01,  8.522006e-01},
  { 4.441798e-01,  6.849198e-01,  5.775717e-01,  3.249952e-01, -3.748534e-01,  8.126682e-01},
  {-2.836003e-01, -9.160480e-01, -2.835964e-01,  1.452551e-01, -3.688393e-01,  7.793983e-01},
  {-3.302114e-01, -3.593797e-01,  8.728154e-01, -2.253785e-02, -3.540118e-01,  7.495223e-01},
  { 7.527835e-01,  8.907358e-02,  6.522139e-01,  3.892095e-01, -3.619797e-01,  7.377945e-01},
  {-7.669671e-01, -4.782166e-01,  4.278672e-01, -4.147987e-02, -3.627811e-01,  7.265108e-01},
  { 9.359200e-01,  1.070279e-01,  3.355576e-01,  4.234204e-01, -3.615697e-01,  7.077255e-01},
  {-9.802449e-01, -6.013750e-02,  1.884233e-01, -4.854248e-02, -3.516361e-01,  7.113011e-01},
  {-9.807784e-01, -1.891517e-01, -4.790941e-02, -4.920985e-02, -3.523006e-01,  6.759748e-01},
  { 9.705427e-01, -1.830298e-01,  1.566744e-01, -1.686195e-01, -3.614362e-01,  6.346343e-01},
  {-7.738515e-01, -5.755733e-01, -2.643278e-01, -3.931739e-02, -3.643828e-01,  6.168406e-01},
  {-3.903865e-01, -8.940217e-01, -2.198261e-01, -1.643371e-02, -3.665261e-01,  5.812249e-01},
  {-8.920013e-01, -1.241164e-01, -4.346593e-01, -3.013997e-02, -3.498179e-01,  5.771514e-01},
  {-6.484748e-01, -5.559127e-01, -5.200401e-01, -2.325206e-02, -3.588624e-01,  5.695168e-01},
  { 1.335513e-01, -9.781035e-01, -1.596174e-01,  3.267263e-01, -3.776305e-01,  5.469055e-01},
  {-7.358676e-01, -6.583508e-01, -1.583453e-01, -1.222140e-02, -3.616185e-01,  5.440443e-01},
  { 9.412906e-01, -2.034609e-01, -2.693989e-01,  4.189732e-01, -3.616954e-01,  5.426455e-01},
  {-5.997075e-01, -7.934356e-01,  1.039756e-01, -1.342478e-02, -3.592306e-01,  5.322857e-01},
  { 4.738855e-01, -8.605753e-01, -1.866619e-01,  2.828287e-01, -3.810340e-01,  5.104228e-01},
  {-5.845442e-01, -8.084823e-01, -6.829645e-02, -1.778998e-03, -3.615249e-01,  5.148142e-01},
  { 5.718851e-01, -2.864394e-01, -7.687001e-01,  4.016867e-01, -3.534912e-01,  5.153837e-01},
  {-5.351083e-01, -6.283216e-01,  5.646866e-01,  1.034464e-01, -3.661064e-01,  5.075590e-01},
  { 6.590575e-01, -6.882497e-01, -3.032417e-01,  2.908775e-01, -3.711075e-01,  4.552570e-01},
  { 4.815810e-01, -5.755276e-01, -6.609445e-01,  2.972396e-01, -3.614742e-01,  4.483961e-01},
  { 4.608089e-01, -3.140146e-01, -8.300903e-01,  2.947306e-01, -3.510801e-01,  4.396791e-01},
  {-8.285318e-01, -1.887452e-01,  5.271720e-01,  2.339398e-04, -3.743599e-01,  4.252074e-01},
  {-6.231085e-01,  1.570502e-01,  7.662056e-01, -1.754544e-02, -3.706585e-01,  4.068319e-01},
  { 3.470610e-01,  1.940047e-01,  9.175570e-01,  4.207350e-01, -3.635347e-01,  3.718343e-01},
  { 8.613871e-02,  3.407734e-01,  9.361910e-01, -5.613196e-02, -3.533627e-01,  3.882146e-01},
  {-7.158225e-01, -6.971586e-01,  3.960004e-02, -4.065734e-01, -3.636257e-01,  2.362403e-01},
  { 5.965144e-01, -3.204565e-01,  7.358521e-01,  4.075796e-01, -3.641917e-01,  2.047549e-01},
  {-7.695812e-01, -5.811986e-01,  2.644861e-01, -6.272735e-02, -3.753778e-01,  2.104246e-01},
  { 3.539834e-01, -7.688342e-01,  5.325314e-01,  3.242030e-01, -3.638184e-01,  2.035346e-01},
  {-5.301352e-01, -5.664911e-01,  6.309077e-01, -7.307507e-02, -3.751244e-01,  1.965871e-01},
  {-3.037916e-01,  6.210645e-01,  7.224885e-01, -4.713661e-01, -3.580245e-01,  1.360230e-01},
  {-2.518202e-01,  9.327111e-02, -9.632689e-01, -3.060032e-01, -3.655229e-01,  9.829182e-02},
  { 2.142128e-01,  6.413386e-01, -7.367480e-01,  1.574822e-01, -3.630116e-01, -9.204146e-03},
  {-3.533182e-01,  8.795987e-01, -3.185473e-01, -1.169696e-01, -3.677605e-01, -3.495361e-02},
  {-3.972774e-01,  8.132160e-01, -4.252652e-01,  2.661861e-01, -3.652114e-01, -4.474609e-02},
  {-2.021181e-01, -2.122073e-01,  9.560943e-01, -4.746455e-01, -3.514035e-01, -7.119879e-02},
  { 8.562430e-01,  1.451371e-01, -4.957651e-01,  8.660228e-02, -3.640601e-01, -9.731530e-02},
  { 8.796774e-01,  2.309273e-01, -4.157406e-01,  7.329673e-02, -3.679281e-01, -1.303456e-01},
  {-6.555311e-01, -6.371493e-01,  4.053636e-01, -4.552898e-01, -3.718579e-01, -1.288059e-01},
  {-4.313931e-01,  8.974612e-01,  9.199712e-02,  2.559451e-01, -3.559560e-01, -2.251832e-01},
  { 3.650583e-01,  3.720790e-01, -8.533989e-01,  5.228933e-01, -3.714947e-01, -2.482202e-01},
  { 5.842159e-01,  7.510440e-01,  3.076113e-01,  2.786610e-01, -3.848982e-01, -3.542544e-01},
  {-3.518443e-01,  7.410787e-01,  5.718461e-01, -5.569338e-01, -3.836718e-01, -3.379126e-01},
  { 2.255400e-01,  7.588481e-01,  6.109674e-01,  2.591590e-01, -3.750819e-01, -3.542657e-01},
  { 9.088485e-01,  1.426401e-01,  3.919796e-01, -3.879298e-02, -3.615503e-01, -3.658268e-01},
  {-2.246174e-01,  7.008693e-01,  6.770001e-01, -4.853566e-01, -3.762074e-01, -3.605536e-01},
  {-3.295176e-04,  7.057726e-01,  7.084383e-01,  3.131846e-02, -3.697498e-01, -3.671432e-01},
  { 3.345329e-02,  6.211381e-01,  7.829868e-01, -1.166625e-02, -3.648758e-01, -3.784029e-01},
  { 8.775363e-02,  6.886115e-02,  9.937592e-01, -1.010466e-02, -3.587724e-01, -3.808606e-01},
  {-9.648085e-01, -1.598130e-01,  2.088166e-01, -5.351048e-01, -3.621464e-01, -4.184234e-01},
  {-1.604500e-01, -3.225997e-01, -9.328372e-01,  8.598027e-02, -3.652208e-01, -4.450606e-01},
  { 1.494343e-01, -9.089803e-01,  3.891328e-01,  4.424144e-01, -3.549723e-01, -4.886380e-01},
  {-4.000078e-01,  6.139297e-01, -6.805028e-01, -3.748695e-01, -3.489114e-01, -4.825922e-01},
  { 6.625484e-01, -6.852682e-01, -3.023857e-01,  4.545094e-01, -3.549809e-01, -5.075764e-01},
  { 5.931247e-01, -4.494308e-01, -6.679933e-01,  4.500870e-01, -3.481338e-01, -5.153978e-01},
  {-4.414327e-01, -7.711504e-01, -4.587638e-01,  4.399059e-01, -3.492274e-01, -5.180997e-01},
  { 3.371445e-02, -3.989227e-01, -9.163646e-01, -2.265110e-01, -3.703338e-01, -5.317089e-01},
  {-1.565332e-01, -4.802262e-01, -8.630645e-01, -3.166921e-01, -3.741433e-01, -5.252361e-01},
  {-7.498975e-01, -1.609895e-01, -6.416668e-01, -1.790006e-01, -3.577642e-01, -5.547117e-01},
  {-2.609015e-01,  6.512519e-01, -7.126019e-01, -4.096027e-01, -3.819928e-01, -5.387980e-01},
  {-7.907581e-01, -5.723467e-01,  2.170734e-01, -2.962686e-01, -3.510234e-01, -5.856354e-01},
  { 1.651401e-01,  1.610506e-01, -9.730321e-01, -2.391036e-02, -3.696531e-01, -6.202073e-01},
  {-2.219428e-01, -9.525480e-01, -2.083115e-01, -3.025911e-01, -3.541271e-01, -6.108607e-01},
  { 4.790144e-01,  3.427578e-01, -8.081228e-01, -7.928941e-02, -3.649631e-01, -6.389849e-01},
  { 6.633715e-02,  4.355785e-01, -8.977031e-01, -3.073352e-01, -3.599926e-01, -6.276277e-01},
  {-1.953651e-01,  8.926982e-01,  4.061064e-01,  2.087971e-01, -3.609790e-01,  8.148685e-01},
  {-5.766619e-01, -2.069399e-01,  7.903398e-01,  1.791876e-01, -3.621980e-01,  8.023100e-01},
  { 1.034864e-02,  6.098455e-01,  7.924527e-01,  1.535171e-01, -3.571370e-01,  7.785683e-01},
  {-2.836003e-01, -9.160480e-01, -2.835964e-01,  1.274433e-01, -3.586227e-01,  7.642097e-01},
  { 5.243717e-01, -2.922202e-01,  7.997760e-01,  4.163737e-01, -3.390130e-01,  7.184273e-01},
  { 5.688621e-01,  1.130978e-01,  8.146194e-01, -1.780465e-01, -3.481057e-01,  6.413168e-01},
  { 9.864861e-01, -1.139368e-02,  1.634479e-01, -1.641698e-01, -3.511505e-01,  6.215540e-01},
  {-9.487061e-01,  2.247260e-01, -2.223848e-01, -3.911990e-02, -3.346679e-01,  6.130303e-01},
  {-9.101348e-01,  2.437478e-01, -3.350249e-01, -2.718595e-01, -3.484039e-01,  5.802147e-01},
  {-9.573749e-01, -2.888394e-01, -2.258720e-03, -2.685153e-01, -3.435878e-01,  5.714928e-01},
  {-1.675929e-01, -9.739279e-01, -1.528959e-01,  1.113739e-01, -3.555303e-01,  5.606690e-01},
  {-9.956017e-01, -6.335590e-02, -6.901571e-02, -2.557429e-02, -3.409612e-01,  5.373020e-01},
  {-3.545710e-02, -9.823225e-01,  1.838081e-01,  6.054601e-02, -3.553829e-01,  5.181581e-01},
  { 7.479811e-01,  1.208211e-02,  6.636100e-01, -1.058137e-01, -3.386088e-01,  4.275895e-01},
  { 4.693980e-01,  1.921269e-01,  8.618311e-01, -7.293946e-02, -3.433356e-01,  3.920119e-01},
  { 4.809936e-01,  1.052435e-01, -8.703843e-01,  4.223186e-01, -3.449419e-01,  3.557119e-01},
  { 9.883910e-01, -1.518794e-01,  3.966578e-03,  2.381997e-01, -3.408820e-01,  3.519148e-01},
  { 7.827807e-01,  1.902891e-02,  6.220067e-01,  2.472053e-01, -3.422291e-01,  3.117762e-01},
  { 1.903471e-01,  1.255998e-01,  9.736491e-01,  2.789923e-01, -3.336426e-01,  2.958574e-01},
  { 2.343933e-01,  7.648377e-01,  6.000693e-01, -4.084602e-01, -3.512833e-01,  2.479144e-01},
  {-5.470759e-01, -8.707926e-02,  8.325414e-01, -4.178967e-01, -3.411312e-01,  2.375130e-01},
  {-5.411289e-01, -8.027247e-01,  2.506242e-01, -8.195886e-02, -3.575698e-01,  2.220734e-01},
  {-3.556660e-01, -6.889754e-01,  6.315176e-01, -1.285292e-01, -3.486755e-01,  1.826353e-01},
  { 2.960385e-01, -6.644498e-01,  6.861980e-01, -2.367056e-01, -3.569028e-01,  1.753696e-01},
  {-8.252843e-02, -5.330967e-01,  8.420196e-01, -1.764949e-01, -3.539598e-01,  1.684070e-01},
  { 7.974418e-01,  1.694434e-01, -5.791161e-01,  3.659739e-01, -3.395972e-01,  1.087833e-01},
  {-2.012866e-01, -1.567321e-01, -9.669120e-01, -3.037651e-01, -3.457029e-01,  9.576839e-02},
  {-7.075085e-01,  5.076039e-01, -4.917011e-01, -4.856181e-01, -3.460699e-01,  1.041328e-01},
  {-4.537960e-01,  8.911055e-01, -4.356688e-04, -5.431869e-01, -3.633809e-01,  1.004214e-01},
  {-2.185379e-01, -2.719033e-01, -9.371818e-01, -2.242962e-01, -3.417682e-01,  7.193029e-02},
  {-2.767752e-01,  5.179721e-01, -8.093827e-01, -5.245799e-01, -3.630190e-01,  9.618807e-02},
  {-6.718569e-01,  3.332889e-02, -7.399307e-01, -1.656399e-01, -3.498388e-01,  4.284950e-02},
  {-6.570642e-01,  6.656380e-01, -3.538260e-01, -7.699002e-02, -3.392438e-01, -4.457220e-02},
  { 1.812483e-01,  2.828737e-01,  9.418766e-01, -4.153198e-01, -3.539364e-01, -7.216676e-02},
  {-4.857981e-01,  8.440452e-01,  2.271297e-01, -7.628176e-02, -3.425011e-01, -7.465920e-02},
  {-8.655943e-01, -4.768000e-01,  1.529975e-01, -4.678060e-01, -3.529693e-01, -1.198422e-01},
  {-9.004746e-01, -5.854474e-02, -4.309502e-01, -5.164570e-01, -3.668812e-01, -1.804217e-01},
  { 9.199981e-01, -1.148799e-01, -3.747080e-01,  4.814853e-02, -3.467619e-01, -1.903064e-01},
  {-3.129371e-02,  9.456462e-01,  3.236879e-01, -5.379854e-01, -3.775657e-01, -3.486929e-01},
  { 3.689009e-01,  5.982747e-01,  7.113224e-01,  2.440757e-01, -3.568091e-01, -3.691916e-01},
  { 7.376336e-02,  4.551219e-01,  8.873687e-01, -5.018098e-01, -3.418604e-01, -3.996683e-01},
  {-8.486621e-01, -5.239226e-01,  7.264804e-02, -5.447121e-01, -3.466362e-01, -4.158737e-01},
  {-2.612147e-01, -7.850506e-02,  9.620830e-01, -5.633820e-01, -3.310643e-01, -4.214809e-01},
  { 2.854173e-01, -1.553100e-01, -9.457356e-01, -5.798626e-02, -3.490899e-01, -4.565159e-01},
  {-7.023163e-01, -2.076280e-01, -6.809129e-01, -5.596108e-01, -3.246228e-01, -4.277122e-01},
  { 9.981209e-02,  9.966291e-02, -9.900025e-01, -4.187820e-01, -3.369515e-01, -4.640843e-01},
  { 5.138426e-01, -7.370216e-01,  4.390498e-01,  4.384487e-01, -3.367395e-01, -4.697593e-01},
  {-6.053089e-01, -7.776426e-01,  1.699208e-01,  4.216842e-01, -3.422568e-01, -4.855937e-01},
  { 8.720269e-01,  3.701981e-01,  3.201912e-01, -8.300781e-02, -3.425354e-01, -5.181217e-01},
  {-2.323286e-02, -6.945421e-01, -7.190770e-01, -2.054680e-01, -3.549084e-01, -5.408236e-01},
  { 4.310467e-01,  1.072903e-01,  8.959282e-01,  4.171877e-02, -3.560595e-01, -5.669754e-01},
  { 4.439780e-01,  6.981903e-01,  5.616173e-01, -3.559913e-02, -3.444268e-01, -5.575875e-01},
  {-6.611513e-02, -4.137304e-02, -9.969538e-01, -3.545943e-01, -3.475713e-01, -5.325914e-01},
  { 2.195511e-01, -1.834664e-02, -9.754285e-01, -3.004267e-02, -3.519638e-01, -6.202899e-01},
  { 4.775224e-01, -3.298070e-01, -8.143708e-01, -2.794880e-01, -3.461609e-01, -6.076412e-01},
  { 6.065055e-01,  2.403105e-02, -7.947161e-01, -8.285044e-02, -3.435848e-01, -6.375901e-01},
  {-5.043378e-01, -8.136293e-01, -2.892246e-01, -1.895846e-01, -3.344773e-01, -7.102020e-01},
  {-3.018863e-01, -9.506682e-01, -7.137780e-02, -1.969849e-01, -3.316894e-01, -7.280390e-01},
  {-8.539683e-01, -1.858779e-01,  4.859913e-01, -4.278148e-02, -3.174839e-01,  7.498901e-01},
  {-1.739408e-02,  8.318312e-01,  5.547562e-01,  2.607801e-01, -3.312478e-01,  6.977104e-01},
  {-5.591916e-01, -7.711979e-02,  8.254437e-01, -2.532442e-01, -3.177411e-01,  6.366693e-01},
  { 8.147057e-01,  5.041919e-02,  5.776786e-01, -1.614500e-01, -3.392769e-01,  5.484394e-01},
  {-9.938131e-01,  6.578863e-02,  8.948413e-02, -7.115224e-03, -3.321796e-01,  4.396412e-01},
  {-4.082613e-01, -7.898759e-01,  4.576229e-01, -3.914790e-01, -3.173046e-01,  4.329205e-01},
  {-1.748531e-01, -9.655833e-01, -1.925497e-01, -3.855300e-01, -3.201606e-01,  4.165890e-01},
  {-8.100716e-01, -2.975774e-01, -5.052045e-01, -1.824484e-01, -3.317887e-01,  4.029917e-01},
  {-7.914165e-02, -3.401241e-02,  9.962830e-01, -3.533710e-02, -3.221053e-01,  3.868130e-01},
  { 3.392212e-01, -2.071391e-01,  9.176177e-01, -6.607494e-02, -3.231663e-01,  3.892199e-01},
  {-8.081886e-01, -5.216258e-01, -2.733819e-01, -1.323326e-01, -3.356911e-01,  3.160906e-01},
  { 4.234709e-01, -7.685043e-01,  4.796598e-01, -2.351503e-01, -3.235854e-01,  2.851859e-01},
  {-1.040727e-01, -8.144166e-01,  5.708717e-01, -2.717153e-01, -3.288498e-01,  2.870887e-01},
  { 7.879815e-01, -3.959348e-01, -4.715091e-01,  3.424144e-01, -3.355494e-01,  2.563115e-01},
  {-3.948497e-01, -4.997239e-01,  7.709538e-01, -4.346460e-01, -3.298720e-01,  2.317416e-01},
  {-2.207561e-01, -7.956165e-01,  5.641463e-01, -4.473476e-01, -3.156496e-01,  2.389424e-01},
  {-1.614914e-01, -7.557544e-01,  6.346305e-01, -1.728428e-01, -3.347090e-01,  1.852162e-01},
  {-7.266747e-01, -5.700906e-01,  3.833281e-01, -4.644575e-01, -3.255610e-01,  1.559373e-01},
  {-9.541320e-01, -2.022743e-01,  2.207201e-01, -4.820289e-01, -3.261463e-01,  1.194263e-01},
  {-2.754986e-01, -4.016005e-02, -9.604623e-01, -4.699014e-01, -3.244180e-01,  1.036212e-01},
  {-3.484015e-01, -2.615166e-01, -9.001253e-01, -2.066944e-01, -3.290892e-01,  6.364915e-02},
  {-3.011713e-01,  7.226554e-01, -6.221455e-01,  2.738188e-01, -3.266120e-01, -6.031885e-03},
  { 8.451926e-01, -3.156400e-02, -5.335290e-01,  1.416833e-01, -3.244729e-01, -7.249473e-03},
  {-6.483909e-01,  7.271372e-01, -2.255233e-01, -5.440226e-02, -3.274661e-01, -6.675593e-02},
  {-6.506454e-01,  6.922535e-01,  3.121628e-01, -5.714115e-02, -3.227927e-01, -8.914812e-02},
  {-3.904865e-01,  6.818762e-01,  6.185185e-01, -7.225945e-02, -3.205982e-01, -1.076158e-01},
  { 8.829965e-01, -1.549779e-01, -4.430565e-01,  6.890502e-02, -3.379788e-01, -1.503944e-01},
  {-3.023296e-02,  2.199938e-01, -9.750326e-01, -4.828173e-01, -3.516918e-01, -1.803135e-01},
  { 7.511738e-01,  5.465458e-01, -3.701697e-01,  5.295601e-01, -3.324825e-01, -2.079747e-01},
  { 4.152856e-01,  6.203527e-01, -6.653574e-01,  5.209976e-01, -3.451551e-01, -2.309499e-01},
  {-5.544658e-02,  3.875239e-01, -9.201908e-01,  4.783289e-01, -3.393584e-01, -2.366630e-01},
  {-6.932089e-02,  8.298900e-01, -5.536039e-01,  2.834670e-01, -3.449153e-01, -2.513404e-01},
  { 9.296402e-01, -2.914638e-03, -3.684570e-01, -3.376099e-02, -3.198725e-01, -3.416196e-01},
  { 7.545587e-01,  9.969028e-02,  6.486161e-01, -3.918488e-02, -3.331028e-01, -3.729560e-01},
  { 6.793476e-01,  5.305648e-01,  5.069395e-01, -4.415908e-02, -3.177294e-01, -3.829017e-01},
  {-3.550548e-01,  2.625348e-01,  8.972244e-01, -3.094761e-01, -3.358139e-01, -3.649468e-01},
  {-7.730556e-02, -9.092560e-01,  4.089954e-01,  4.249839e-01, -3.182045e-01, -3.974427e-01},
  { 7.617197e-01, -6.475437e-01,  2.168512e-02,  4.548231e-01, -3.235112e-01, -4.369399e-01},
  { 9.585901e-01,  2.567938e-01, -1.231334e-01,  2.594246e-01, -3.349951e-01, -4.208004e-01},
  {-6.505734e-01, -7.561519e-01,  7.063027e-02,  4.108129e-01, -3.291852e-01, -4.691111e-01},
  { 7.957767e-01, -1.174846e-01, -5.940849e-01, -7.398960e-02, -3.374170e-01, -4.699689e-01},
  {-5.614922e-01,  5.077755e-01, -6.533686e-01, -3.474762e-01, -3.248352e-01, -4.756178e-01},
  { 9.936712e-01, -3.023891e-02, -1.081812e-01, -8.323626e-02, -3.251379e-01, -4.959459e-01},
  { 9.821169e-01,  7.253142e-02,  1.737405e-01,  4.562837e-01, -3.320958e-01, -4.983357e-01},
  {-6.028290e-01,  6.796836e-01, -4.178844e-01, -3.578620e-01, -3.411911e-01, -5.283576e-01},
  {-6.028290e-01,  6.796836e-01, -4.178844e-01,  5.827510e-02, -3.417023e-01, -5.938958e-01},
  { 6.283575e-01, -1.694244e-01, -7.592512e-01, -2.874804e-01, -3.391523e-01, -6.160485e-01},
  { 9.009222e-01,  3.024040e-01, -3.112728e-01,  4.025219e-02, -3.188372e-01, -6.340740e-01},
  { 6.002488e-01, -7.928294e-02, -7.958741e-01, -1.848221e-01, -3.188095e-01, -7.250698e-01},
  { 2.470831e-01, -2.596388e-01, -9.335619e-01, -1.955516e-01, -3.171446e-01, -7.302296e-01},
  {-2.929400e-01, -3.809434e-01,  8.769654e-01, -1.480011e-02, -2.970300e-01,  7.773100e-01},
  {-3.298186e-01,  1.281828e-01,  9.353014e-01,  4.068286e-01, -3.093929e-01,  7.286158e-01},
  {-3.622324e-01,  5.702890e-01,  7.372640e-01,  3.014898e-01, -2.980039e-01,  6.713434e-01},
  { 4.690126e-02,  7.724037e-01,  6.333979e-01,  2.707547e-01, -3.081735e-01,  6.661765e-01},
  { 2.505819e-01,  1.734974e-01,  9.524218e-01,  1.086310e-01, -2.965996e-01,  6.776342e-01},
  { 4.867038e-01,  7.568033e-02,  8.702826e-01, -1.886300e-01, -3.206722e-01,  6.482576e-01},
  { 8.474394e-01,  4.904832e-01,  2.031568e-01, -1.671416e-01, -3.140567e-01,  5.976809e-01},
  { 9.635981e-01,  1.639610e-01,  2.111761e-01, -1.676061e-01, -3.125792e-01,  5.600657e-01},
  {-3.933765e-01, -8.761050e-01,  2.787381e-01, -3.420814e-01, -3.114756e-01,  4.403763e-01},
  {-6.921563e-01, -7.151957e-01, -9.702957e-02, -4.103030e-01, -3.081225e-01,  4.163747e-01},
  {-4.257298e-01,  1.080820e-01,  8.983721e-01, -8.564522e-03, -3.106861e-01,  3.946649e-01},
  { 3.921954e-01, -1.428911e-01,  9.087160e-01, -6.649308e-02, -3.100264e-01,  3.909308e-01},
  {-6.424000e-01,  4.873973e-02, -7.648181e-01, -3.878148e-01, -3.025550e-01,  3.796755e-01},
  { 8.607925e-01, -1.037044e-01,  4.982789e-01,  2.466514e-01, -3.074272e-01,  3.158178e-01},
  {-8.000941e-01, -5.875922e-01, -1.207679e-01, -1.366934e-01, -3.206511e-01,  2.902710e-01},
  {-5.141379e-01, -8.486255e-01, -1.244869e-01, -1.298379e-01, -3.237976e-01,  2.640085e-01},
  { 2.195826e-01, -9.480113e-01,  2.303436e-01, -1.964395e-01, -3.170596e-01,  2.387155e-01},
  {-6.196337e-01, -3.940312e-01,  6.788177e-01, -3.005883e-01, -3.188341e-01,  2.668716e-01},
  {-1.535502e-01, -6.003841e-01,  7.848320e-01, -4.536359e-01, -3.127319e-01,  2.426445e-01},
  {-7.424017e-01, -4.654815e-01,  4.818370e-01, -4.744643e-01, -3.022831e-01,  2.397576e-01},
  { 6.852384e-01, -6.089709e-01,  3.995031e-01,  3.618048e-01, -3.164318e-01,  2.349518e-01},
  { 5.978264e-01, -3.180035e-01,  7.358515e-01,  3.736254e-01, -3.121482e-01,  2.275673e-01},
  { 2.277479e-01, -8.740363e-01,  4.291754e-01, -1.898525e-01, -3.208230e-01,  2.137790e-01},
  {-7.390945e-01, -6.693113e-01,  7.590627e-02, -4.727028e-01, -3.087884e-01,  2.189371e-01},
  {-2.976042e-01, -8.993726e-01,  3.202509e-01, -1.568921e-01, -3.176169e-01,  2.232584e-01},
  { 9.421614e-01,  2.198644e-02, -3.344376e-01,  4.246945e-01, -3.035361e-01,  1.596155e-01},
  { 9.674820e-01,  1.922468e-02, -2.522079e-01,  3.641139e-01, -3.031076e-01,  1.125170e-01},
  { 8.828040e-01, -3.656260e-02, -4.683164e-01,  1.550205e-01, -3.015260e-01,  1.438864e-02},
  {-7.650139e-01, -5.209894e-01,  3.785810e-01, -5.182456e-01, -3.011470e-01, -4.870663e-02},
  { 7.650138e-01, -6.102795e-01, -2.057007e-01,  8.843551e-02, -3.139009e-01, -1.441493e-01},
  { 9.640552e-02,  5.573905e-01,  8.246344e-01, -2.553638e-01, -3.117398e-01, -1.497248e-01},
  { 9.241757e-02, -7.928533e-01,  6.023643e-01,  5.272307e-01, -3.203582e-01, -1.916589e-01},
  { 3.586114e-01,  8.248088e-01, -4.371364e-01,  5.130909e-01, -3.172196e-01, -2.038396e-01},
  { 1.828390e-01,  8.343061e-01, -5.200992e-01,  4.835361e-01, -3.139758e-01, -2.056227e-01},
  {-7.739049e-01, -8.499210e-02,  6.275728e-01, -2.712875e-01, -3.046131e-01, -3.425016e-01},
  { 9.214762e-01,  2.236906e-01, -3.175597e-01, -5.473584e-02, -3.047997e-01, -3.856003e-01},
  {-7.294975e-01, -6.533869e-01,  2.022845e-01,  4.035116e-01, -3.033417e-01, -3.958358e-01},
  { 5.507355e-01,  5.299463e-01,  6.448623e-01,  2.500269e-01, -3.178013e-01, -3.967912e-01},
  { 8.150508e-01,  4.833862e-01, -3.194210e-01, -6.995835e-02, -2.905889e-01, -4.033494e-01},
  {-7.693655e-01, -6.103913e-01,  1.884120e-01,  3.978958e-01, -3.077209e-01, -4.246485e-01},
  {-3.028262e-01, -2.909447e-01,  9.075503e-01, -5.290065e-01, -3.042804e-01, -4.099620e-01},
  {-3.583672e-03, -2.037190e-02, -9.997861e-01, -4.103762e-01, -3.046211e-01, -4.639751e-01},
  {-8.291998e-01,  3.084652e-01, -4.661297e-01, -3.260763e-01, -3.032556e-01, -4.874373e-01},
  { 7.931994e-01, -3.591800e-01, -4.917564e-01,  4.471781e-01, -3.092213e-01, -5.503164e-01},
  { 8.600193e-01,  3.175463e-01,  3.994134e-01, -7.249010e-02, -3.092433e-01, -5.548155e-01},
  {-2.962944e-01, -6.073894e-01, -7.370805e-01,  4.154838e-01, -2.990318e-01, -5.658265e-01},
  {-4.099729e-01, -6.086074e-01, -6.793521e-01, -1.843339e-01, -3.143196e-01, -5.836341e-01},
  { 8.530708e-02, -2.700882e-01, -9.590490e-01, -2.442290e-01, -3.013339e-01, -6.060218e-01},
  {-7.167956e-01,  3.980897e-02, -6.961461e-01, -2.913033e-01, -3.167710e-01, -6.054713e-01},
  {-6.431890e-01, -1.966769e-01, -7.400176e-01, -2.198099e-01, -3.063699e-01, -7.253003e-01},
  { 2.618777e-01, -4.632843e-01,  8.466333e-01,  1.376923e-02, -2.991658e-01,  7.721258e-01},
  {-1.969831e-01, -5.811008e-01,  7.896325e-01,  4.135661e-01, -2.766170e-01,  7.453998e-01},
  {-4.443112e-01,  3.151008e-01,  8.386292e-01,  3.370523e-01, -2.898648e-01,  6.849511e-01},
  { 3.845021e-01, -9.264871e-02,  9.184631e-01,  8.401240e-02, -2.973934e-01,  6.871211e-01},
  { 5.834736e-01, -8.523946e-02,  8.076465e-01,  7.960981e-02, -2.950374e-01,  6.895918e-01},
  { 3.631332e-01, -1.559604e-02,  9.316067e-01,  1.211470e-01, -2.855558e-01,  6.716862e-01},
  {-5.899986e-01, -3.128754e-01,  7.443188e-01, -2.666858e-01, -2.882711e-01,  6.410804e-01},
  { 3.555539e-01,  5.805081e-01,  7.325243e-01,  2.452538e-01, -2.924972e-01,  6.505404e-01},
  { 7.920495e-01,  4.243112e-01,  4.388821e-01, -1.763348e-01, -3.084515e-01,  6.309481e-01},
  { 3.647173e-01,  9.183003e-01,  1.539662e-01, -2.169059e-01, -2.869011e-01,  5.600120e-01},
  { 7.714136e-01,  8.870196e-02, -6.301214e-01,  4.226618e-01, -2.849905e-01,  5.379725e-01},
  {-8.694541e-01,  4.517504e-01,  1.999278e-01,  1.614480e-02, -2.892940e-01,  4.165018e-01},
  { 4.310515e-01, -7.235559e-02,  8.994216e-01, -5.337862e-02, -2.922644e-01,  3.880663e-01},
  {-1.921505e-01,  2.328461e-01,  9.533419e-01,  4.013782e-01, -2.935986e-01,  3.559988e-01},
  {-5.222862e-01,  6.375578e-03, -8.527464e-01, -3.967274e-01, -2.890584e-01,  3.826259e-01},
  {-9.543151e-01,  2.043922e-01, -2.179598e-01, -3.541511e-01, -2.819877e-01,  3.404016e-01},
  {-1.857266e-02, -7.903149e-01,  6.124193e-01, -2.634784e-01, -2.981077e-01,  3.258783e-01},
  { 8.604648e-01, -1.098183e-01,  4.975343e-01,  2.533845e-01, -2.889436e-01,  3.067451e-01},
  {-6.469448e-01, -7.102954e-01,  2.773860e-01, -3.093853e-01, -2.985393e-01,  2.809173e-01},
  {-3.632145e-01, -1.329964e-01,  9.221644e-01, -3.550885e-01, -2.972388e-01,  2.284605e-01},
  {-1.561869e-01, -1.831000e-01,  9.706081e-01, -3.695165e-01, -2.866135e-01,  2.287194e-01},
  { 8.830964e-01, -1.692438e-01,  4.376040e-01,  4.160474e-01, -2.857974e-01,  2.032513e-01},
  { 7.031386e-01,  1.199877e-01, -7.008560e-01,  3.703669e-01, -2.901667e-01,  1.306026e-01},
  {-9.245502e-01, -3.250264e-01,  1.989094e-01, -5.073642e-01, -2.854389e-01,  1.001213e-01},
  {-3.394850e-01, -5.847284e-01, -7.367786e-01, -1.922190e-01, -3.044528e-01,  4.084695e-02},
  {-1.733076e-01,  4.246034e-01, -8.886374e-01, -1.095606e-01, -2.871137e-01, -6.087632e-03},
  {-5.103920e-01,  1.782138e-01,  8.412728e-01, -5.201649e-01, -2.877046e-01, -4.885849e-02},
  { 8.876057e-01,  4.316325e-01, -1.607774e-01,  5.313581e-01, -3.064269e-01, -1.227718e-01},
  { 1.399777e-01, -7.043072e-01,  6.959581e-01,  4.466923e-01, -2.960079e-01, -3.753828e-01},
  {-2.131198e-01, -3.397603e-01,  9.160474e-01, -3.216064e-01, -2.993579e-01, -3.679516e-01},
  {-2.260105e-01, -1.525014e-01,  9.621136e-01, -5.737551e-01, -2.802075e-01, -4.166582e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00, -8.963900e-02, -2.844518e-01, -4.209391e-01},
  { 0.000000e+00,  2.425356e-01,  9.701425e-01, -9.126544e-02, -2.832592e-01, -4.224982e-01},
  { 9.129738e-02, -5.629272e-01, -8.214486e-01, -2.831365e-02, -3.002200e-01, -4.715766e-01},
  { 8.959711e-02, -9.536454e-02, -9.914020e-01, -3.602066e-01, -2.886674e-01, -4.643511e-01},
  {-8.588616e-01, -5.022839e-01, -1.003379e-01,  3.787656e-01, -2.864363e-01, -5.064521e-01},
  {-3.827699e-01, -2.486182e-01, -8.897619e-01, -4.929335e-01, -2.862260e-01, -4.938629e-01},
  { 3.874089e-01, -7.246466e-01, -5.699137e-01, -4.948503e-01, -2.770520e-01, -4.995692e-01},
  { 9.990631e-01, -2.287590e-02,  3.673769e-02, -8.355696e-02, -2.851276e-01, -5.379915e-01},
  {-3.198438e-01, -3.902743e-01, -8.633574e-01, -5.057532e-01, -2.814189e-01, -5.081214e-01},
  {-9.653539e-01, -2.574389e-01,  4.262593e-02, -3.224312e-01, -2.857265e-01, -5.611646e-01},
  { 6.011251e-01, -6.673996e-01, -4.395750e-01,  4.718310e-01, -2.780504e-01, -5.611556e-01},
  {-9.879666e-01, -1.397985e-01, -6.616993e-02, -3.201635e-01, -2.878255e-01, -5.817149e-01},
  {-7.972620e-01, -6.036037e-01, -5.992305e-03, -1.697965e-01, -3.054651e-01, -6.216057e-01},
  { 8.052699e-02, -6.001615e-02, -9.949439e-01, -2.974147e-01, -2.827175e-01, -6.029895e-01},
  {-9.186930e-01, -3.731743e-01,  1.293987e-01, -1.878818e-01, -3.009292e-01, -6.686314e-01},
  {-2.692607e-02,  1.700591e-01, -9.850660e-01, -2.113284e-01, -2.931737e-01, -7.325621e-01},
  { 3.111165e-01, -5.988324e-01,  7.379745e-01,  2.463144e-02, -2.736591e-01,  7.938343e-01},
  {-6.392538e-01, -6.414869e-03,  7.689691e-01, -1.879096e-02, -2.643981e-01,  7.845091e-01},
  { 5.210550e-01, -7.093003e-01,  4.747576e-01,  4.246662e-01, -2.516330e-01,  7.718273e-01},
  { 4.845360e-01, -6.369506e-01,  5.995988e-01,  7.604320e-02, -2.846930e-01,  6.993802e-01},
  {-5.147747e-01, -1.879760e-01,  8.364640e-01,  3.437613e-01, -2.707291e-01,  6.856396e-01},
  {-3.743860e-01, -1.910234e-01,  9.073837e-01,  3.070089e-01, -2.795400e-01,  6.661732e-01},
  { 3.897494e-01,  7.143306e-01,  5.812291e-01, -2.080602e-01, -2.896029e-01,  6.371777e-01},
  { 2.900911e-01,  4.494753e-01,  8.448781e-01, -2.421377e-01, -2.819433e-01,  6.471626e-01},
  {-2.864807e-01, -6.348756e-02,  9.559802e-01,  2.761552e-01, -2.776336e-01,  6.535010e-01},
  { 2.943671e-01, -5.484502e-01,  7.826560e-01,  1.577317e-01, -2.722583e-01,  6.513994e-01},
  { 9.995920e-01,  2.421848e-02,  1.514379e-02,  4.100073e-01, -2.661578e-01,  6.056472e-01},
  { 4.836538e-02, -2.991603e-01,  9.529764e-01,  2.324579e-01, -2.729187e-01,  6.484259e-01},
  {-7.382787e-01, -4.509270e-01,  5.016068e-01, -3.776440e-01, -2.766021e-01,  4.800876e-01},
  { 7.196515e-01,  2.970877e-01,  6.275671e-01, -1.164183e-01, -2.775490e-01,  4.539657e-01},
  { 6.288065e-01,  8.377326e-02,  7.730358e-01, -6.233962e-02, -2.688994e-01,  3.962037e-01},
  { 2.589068e-01, -4.573071e-01,  8.507864e-01, -4.224598e-01, -2.771054e-01,  4.038979e-01},
  {-5.741687e-01,  2.981684e-01,  7.625130e-01,  5.157907e-03, -2.776813e-01,  3.905651e-01},
  {-2.466308e-01, -9.639422e-01, -9.994391e-02, -2.323691e-01, -2.847707e-01,  3.771289e-01},
  { 9.818246e-01, -8.855053e-02,  1.678665e-01,  4.157504e-01, -2.876414e-01,  3.500373e-01},
  {-4.882116e-01, -1.383809e-01,  8.616845e-01, -4.749252e-01, -2.792307e-01,  2.444899e-01},
  {-9.349204e-01, -3.311781e-01,  1.274552e-01, -4.971505e-01, -2.725841e-01,  2.066086e-01},
  { 7.821246e-01,  4.796414e-02, -6.212732e-01,  4.284030e-01, -2.658795e-01,  1.666164e-01},
  {-2.161780e-01,  9.234492e-01, -3.170311e-01, -3.367974e-01, -2.679718e-01,  1.600064e-01},
  {-9.991140e-01,  1.951028e-03, -4.204161e-02, -5.158946e-01, -2.712464e-01,  1.180668e-01},
  { 7.186899e-01,  3.922754e-01, -5.741124e-01,  1.786720e-01, -2.713078e-01,  6.021515e-02},
  {-2.361291e-01,  7.862372e-01, -5.710289e-01, -4.349372e-01, -2.780298e-01,  8.686437e-02},
  {-4.057594e-01,  6.434865e-01, -6.490644e-01, -4.159647e-01, -2.792338e-01,  7.432401e-02},
  {-3.102041e-01, -3.190805e-01, -8.955228e-01, -4.085585e-01, -2.806937e-01,  6.804814e-02},
  {-5.493538e-03,  5.595870e-01, -8.287534e-01, -3.459310e-01, -2.764234e-01,  5.534483e-02},
  {-2.744349e-01,  3.852312e-01, -8.810689e-01, -2.356719e-02, -2.700073e-01,  4.276983e-03},
  { 4.994723e-01, -5.599291e-01, -6.610649e-01,  3.627237e-02, -2.728459e-01, -2.713424e-01},
  { 1.850666e-01, -9.506102e-01, -2.491798e-01,  1.805429e-01, -2.703820e-01, -3.046726e-01},
  {-9.980225e-01, -5.881543e-02,  2.217933e-02, -2.587248e-01, -2.747256e-01, -3.134659e-01},
  {-8.065009e-01, -3.630299e-01,  4.666537e-01, -2.633581e-01, -2.779408e-01, -3.274343e-01},
  { 3.571710e-01, -5.217952e-01,  7.746992e-01,  4.551375e-01, -2.790091e-01, -3.650123e-01},
  {-5.053283e-03, -6.399478e-01,  7.684017e-01,  4.100872e-01, -2.694975e-01, -3.559670e-01},
  { 1.713496e-01, -9.492277e-01, -2.638297e-01,  1.944872e-01, -2.612233e-01, -3.497092e-01},
  { 8.716329e-01, -1.586159e-01,  4.637857e-01,  4.742959e-01, -2.667066e-01, -3.673929e-01},
  { 1.366106e-01, -7.811161e-01, -6.092579e-01,  1.897845e-01, -2.581470e-01, -3.591851e-01},
  { 8.034587e-01,  4.968049e-01,  3.280838e-01, -8.931639e-02, -2.730176e-01, -4.256351e-01},
  { 6.414179e-01,  4.489504e-01,  6.221147e-01, -8.477941e-02, -2.619533e-01, -4.326031e-01},
  { 2.906224e-01,  4.381461e-01,  8.506272e-01,  4.599076e-01, -2.808375e-01, -5.224060e-01},
  {-9.795928e-01,  1.416708e-01,  1.425740e-01, -3.056175e-01, -2.641357e-01, -5.221006e-01},
  {-8.448120e-01, -4.414523e-01, -3.023451e-01,  3.795555e-01, -2.782449e-01, -5.340627e-01},
  { 4.335165e-01, -7.364745e-01, -5.192965e-01,  4.781368e-01, -2.687632e-01, -5.676001e-01},
  { 8.530470e-01,  2.940160e-01,  4.311213e-01, -7.783779e-02, -2.764209e-01, -5.782268e-01},
  { 1.514018e-02, -3.204185e-01, -9.471551e-01,  4.254920e-01, -2.632128e-01, -5.778927e-01},
  { 7.574954e-01,  2.890373e-01,  5.853699e-01, -7.199166e-02, -2.631266e-01, -5.947937e-01},
  {-3.278187e-01, -2.908793e-01, -8.988460e-01, -2.459193e-01, -2.758420e-01, -6.126990e-01},
  {-3.946427e-01, -8.238840e-01, -4.067829e-01, -3.250013e-01, -2.675335e-01, -6.105887e-01},
  {-7.562122e-01, -6.070548e-01, -2.441873e-01, -1.892682e-01, -2.931956e-01, -6.442599e-01},
  {-8.193532e-01,  1.804533e-01, -5.441480e-01, -2.380978e-01, -2.669317e-01, -6.160511e-01},
  {-4.357149e-01, -7.428572e-01,  5.082478e-01, -3.631522e-01, -2.605039e-01, -6.189833e-01},
  {-6.174400e-01, -6.863763e-01, -3.842595e-01, -2.211823e-01, -2.741945e-01, -6.478825e-01},
  {-8.018711e-01, -5.022655e-01,  3.236236e-01, -3.849617e-01, -2.576372e-01, -6.493998e-01},
  { 3.185173e-01, -3.503206e-01, -8.808076e-01,  2.533762e-02, -2.717136e-01, -6.752172e-01},
  { 7.936513e-01, -4.969152e-02, -6.063401e-01,  2.998971e-02, -2.618855e-01, -6.748712e-01},
  { 2.394158e-01, -1.874992e-01, -9.526406e-01, -1.401830e-01, -2.697460e-01, -6.882933e-01},
  { 7.333243e-01,  2.123798e-01, -6.458563e-01, -3.900782e-01, -2.585097e-01, -6.815116e-01},
  { 7.224358e-01, -4.453640e-01, -5.289021e-01, -3.950535e-01, -2.514067e-01, -6.848249e-01},
  { 3.931995e-01,  3.815447e-01, -8.365512e-01, -1.824706e-01, -2.713936e-01, -7.158636e-01},
  {-6.011715e-02, -9.580511e-01,  2.802213e-01,  3.073452e-01, -2.425759e-01,  8.232204e-01},
  { 3.948059e-01, -1.841173e-01,  9.001274e-01,  7.269471e-02, -2.477769e-01,  8.062006e-01},
  {-2.668359e-01, -2.614703e-01,  9.275947e-01,  4.434982e-03, -2.590070e-01,  7.995743e-01},
  {-7.320487e-01, -5.619342e-01,  3.851421e-01,  2.841289e-01, -2.420674e-01,  7.831942e-01},
  { 9.854716e-01, -9.670825e-02,  1.396181e-01,  4.380624e-01, -2.650930e-01,  7.356799e-01},
  { 3.463758e-01, -8.169439e-01,  4.611144e-01,  1.041662e-01, -2.650733e-01,  7.014484e-01},
  {-3.011989e-01, -4.276794e-01,  8.522732e-01,  3.059533e-01, -2.644714e-01,  6.725767e-01},
  {-9.229600e-02,  5.133790e-01,  8.531843e-01, -2.623040e-01, -2.722627e-01,  6.474363e-01},
  {-3.378154e-01,  5.791099e-01,  7.419652e-01, -2.861212e-01, -2.612084e-01,  6.266441e-01},
  { 2.203007e-01,  6.071533e-01,  7.634348e-01,  2.222719e-01, -2.644839e-01,  6.532694e-01},
  { 3.502139e-01,  9.205537e-01,  1.730058e-01, -2.605234e-01, -2.626803e-01,  6.174196e-01},
  {-5.632575e-01, -6.479511e-01,  5.127381e-01, -3.343216e-01, -2.532120e-01,  5.755038e-01},
  {-7.350568e-01, -3.928124e-01,  5.526208e-01, -3.639980e-01, -2.492522e-01,  5.375509e-01},
  { 3.843692e-01,  7.950206e-01,  4.692576e-01, -1.533585e-01, -2.579792e-01,  4.570327e-01},
  {-9.225897e-01,  3.027768e-01,  2.390702e-01,  3.224495e-02, -2.546885e-01,  4.168051e-01},
  { 2.589068e-01, -4.573071e-01,  8.507864e-01, -4.385796e-01, -2.456463e-01,  4.257130e-01},
  {-7.606078e-01,  2.012580e-01, -6.172284e-01, -3.316179e-01, -2.423638e-01,  3.498530e-01},
  { 9.640463e-01, -1.718681e-01, -2.026724e-01,  2.503461e-01, -2.612073e-01,  3.306172e-01},
  {-9.289102e-01, -7.986723e-02,  3.615896e-01, -3.338222e-01, -2.502738e-01,  2.782631e-01},
  { 4.204399e-01, -9.489658e-02,  9.023442e-01,  2.722168e-01, -2.522387e-01,  2.934729e-01},
  { 9.192906e-01, -3.223435e-01,  2.258306e-01,  3.956710e-01, -2.607664e-01,  2.569319e-01},
  {-9.098708e-01, -1.296283e-01,  3.941213e-01, -4.948605e-01, -2.560432e-01,  2.340015e-01},
  {-9.945274e-01,  3.400349e-02, -9.878757e-02, -4.999830e-01, -2.565693e-01,  1.875602e-01},
  {-1.464664e-01,  8.495665e-01, -5.067389e-01, -3.351182e-01, -2.531535e-01,  1.770674e-01},
  { 9.862927e-01, -1.081211e-01,  1.246454e-01,  4.316158e-01, -2.468905e-01,  1.625134e-01},
  {-7.539357e-01,  5.954972e-01, -2.774240e-01, -3.018177e-01, -2.474262e-01,  1.524812e-01},
  {-7.825023e-01,  6.180081e-01,  7.586982e-02, -5.044771e-01, -2.620868e-01,  1.592152e-01},
  { 8.414459e-01,  6.627560e-02, -5.362614e-01,  3.734877e-01, -2.505206e-01,  1.375716e-01},
  { 7.921414e-01,  5.807022e-02, -6.075687e-01,  3.677207e-01, -2.605681e-01,  1.294587e-01},
  { 3.605471e-01,  5.097237e-01, -7.811450e-01,  2.071559e-01, -2.586607e-01,  8.289994e-02},
  { 8.215516e-01, -2.132810e-02, -5.697350e-01,  1.839734e-01, -2.518705e-01,  6.663626e-02},
  {-4.284347e-01,  7.814892e-01, -4.535618e-01, -5.116369e-01, -2.691410e-01,  1.068929e-01},
  { 7.221739e-01, -1.671455e-01,  6.712133e-01,  5.313380e-01, -2.536310e-01,  6.092783e-02},
  { 9.156473e-01, -9.402333e-02, -3.908322e-01,  1.783053e-01, -2.608309e-01,  6.146294e-02},
  {-7.838655e-01,  5.071563e-01, -3.582562e-01,  2.799702e-03, -2.545179e-01, -5.808468e-03},
  { 2.815267e-01, -6.007007e-01, -7.482656e-01, -1.741350e-01, -2.647461e-01, -2.174510e-02},
  { 1.796020e-02, -3.744006e-01, -9.270930e-01, -1.549797e-01, -2.585243e-01, -2.305227e-02},
  {-2.521366e-01, -6.351506e-01, -7.300760e-01, -1.950842e-01, -2.526976e-01, -3.234310e-02},
  { 7.168117e-01, -4.872939e-02, -6.955619e-01, -1.761030e-01, -2.463195e-01, -3.328130e-02},
  {-6.064032e-01, -6.548594e-01,  4.510370e-01, -5.257748e-01, -2.502528e-01, -6.490269e-02},
  { 5.990344e-01, -8.001468e-01,  3.038176e-02,  2.253524e-01, -2.583516e-01, -1.159391e-01},
  {-1.803324e-01,  3.521356e-01,  9.184121e-01, -2.073299e-01, -2.568834e-01, -1.844086e-01},
  {-6.991355e-01, -2.085581e-01, -6.838956e-01, -2.837019e-01, -2.497107e-01, -2.649332e-01},
  {-9.472451e-01, -3.065275e-01, -9.363663e-02, -2.623180e-01, -2.622200e-01, -2.993401e-01},
  { 8.024760e-01, -3.531690e-02, -5.956382e-01, -2.493097e-02, -2.664162e-01, -3.330370e-01},
  {-6.695582e-01, -5.866496e-01,  4.555590e-01,  3.498672e-01, -2.467262e-01, -3.676881e-01},
  {-8.781016e-01, -4.080213e-01,  2.499125e-01,  3.472763e-01, -2.396435e-01, -3.673091e-01},
  { 6.664472e-01, -6.500332e-01, -3.651094e-01,  2.160879e-01, -2.454207e-01, -3.465243e-01},
  { 9.206176e-01, -2.264534e-01,  3.180912e-01,  4.778598e-01, -2.688769e-01, -3.758475e-01},
  { 9.969345e-01,  7.609743e-02,  1.818870e-02,  4.703707e-01, -2.477756e-01, -3.963352e-01},
  { 1.979692e-01, -5.478037e-01, -8.128464e-01,  2.010976e-01, -2.395664e-01, -3.713643e-01},
  {-9.918590e-01, -5.074817e-02,  1.167921e-01, -5.711890e-01, -2.446142e-01, -3.885732e-01},
  {-5.762199e-01,  6.913016e-02, -8.143658e-01, -3.275845e-01, -2.651643e-01, -4.725477e-01},
  {-8.972724e-01, -1.968346e-01, -3.951688e-01, -5.161017e-01, -2.599300e-01, -4.733576e-01},
  { 3.415890e-01, -4.397512e-01, -8.306237e-01,  2.072669e-01, -2.429210e-01, -5.070320e-01},
  { 4.929631e-01, -5.503097e-01, -6.739041e-01, -6.984394e-02, -2.646036e-01, -5.065379e-01},
  {-9.479188e-01,  3.161875e-01, -3.841244e-02, -2.988534e-01, -2.536168e-01, -5.069950e-01},
  { 3.054237e-01, -7.056822e-04, -9.522163e-01, -4.943755e-01, -2.508534e-01, -4.988850e-01},
  { 7.265617e-01, -6.165488e-01, -3.032749e-01,  5.264694e-01, -2.504841e-01, -5.553712e-01},
  { 1.136786e-02, -1.254354e-01, -9.920367e-01,  4.533348e-01, -2.464431e-01, -5.806416e-01},
  {-7.403517e-01, -1.146832e-01,  6.623648e-01, -3.748080e-01, -2.438717e-01, -6.224039e-01},
  { 9.693395e-01,  2.078009e-01,  1.311478e-01,  3.550890e-02, -2.567089e-01, -6.574650e-01},
  {-9.672732e-01,  1.349701e-01, -2.148617e-01, -2.191674e-01, -2.604970e-01, -6.647192e-01},
  {-9.055831e-01,  3.607903e-01, -2.230460e-01, -2.217883e-01, -2.678114e-01, -7.088581e-01},
  {-9.707318e-01, -8.912791e-02, -2.230155e-01, -2.176560e-01, -2.742296e-01, -7.215992e-01},
  { 8.943629e-01, -4.415294e-01, -7.188129e-02, -3.935069e-01, -2.448624e-01, -7.057800e-01},
  {-1.393335e-01,  3.950336e-02,  9.894572e-01,  5.089958e-02, -2.352156e-01,  8.125832e-01},
  { 7.794925e-01, -5.358117e-01,  3.244952e-01,  4.198479e-01, -2.219480e-01,  8.122383e-01},
  { 3.680176e-01, -3.484360e-01,  8.620646e-01,  1.103499e-01, -2.310847e-01,  7.923609e-01},
  {-5.412867e-01, -8.614836e-02,  8.364133e-01, -2.178261e-02, -2.317605e-01,  7.862722e-01},
  {-9.259053e-01, -1.391214e-01,  3.512044e-01,  2.716945e-01, -2.432626e-01,  7.556825e-01},
  { 3.220849e-02, -6.200121e-01,  7.839308e-01,  2.315648e-01, -2.265448e-01,  7.648147e-01},
  { 1.270039e-01, -8.865077e-01,  4.449428e-01,  2.395278e-01, -2.430130e-01,  7.397997e-01},
  {-6.273077e-01, -5.263437e-01,  5.739750e-01,  3.730759e-01, -2.476963e-01,  7.248199e-01},
  {-5.103169e-01, -5.356691e-01,  6.727817e-01,  3.584596e-01, -2.512211e-01,  7.019407e-01},
  {-9.704975e-01,  1.126796e-01, -2.131618e-01, -4.172414e-02, -2.309343e-01,  7.083696e-01},
  {-1.280555e-01, -9.337040e-01,  3.343631e-01,  3.404759e-01, -2.462604e-01,  7.023998e-01},
  {-7.076515e-02, -8.320999e-01,  5.500928e-01,  2.437783e-01, -2.491103e-01,  6.776773e-01},
  { 9.824560e-01, -1.046984e-02,  1.862003e-01,  4.107052e-01, -2.313119e-01,  6.232644e-01},
  {-9.012100e-01,  2.693521e-01, -3.395142e-01,  5.127341e-03, -2.390447e-01,  6.127029e-01},
  {-5.630571e-01, -8.545054e-03,  8.263738e-01, -3.194704e-01, -2.435640e-01,  5.994456e-01},
  {-1.790311e-01,  7.862269e-01,  5.914348e-01, -3.478340e-01, -2.340032e-01,  5.701663e-01},
  { 9.498169e-01,  1.769358e-02, -3.123057e-01,  4.240853e-01, -2.329459e-01,  5.460867e-01},
  {-9.912984e-01,  1.128751e-01, -6.772538e-02,  2.404046e-02, -2.295681e-01,  5.417906e-01},
  {-8.375742e-01, -3.828821e-03,  5.463102e-01, -3.743382e-01, -2.346415e-01,  5.304598e-01},
  { 7.103097e-01,  5.002878e-02, -7.021091e-01,  3.472640e-01, -2.432034e-01,  4.741247e-01},
  {-9.942033e-01,  3.426992e-02, -1.019086e-01,  3.534719e-02, -2.306088e-01,  4.553392e-01},
  { 1.881185e-01,  8.564540e-01,  4.807266e-01, -1.184507e-01, -2.502968e-01,  4.320808e-01},
  { 5.069624e-01,  5.380534e-01,  6.734149e-01, -8.239645e-02, -2.499650e-01,  4.055602e-01},
  { 8.861710e-01,  1.048254e-01, -4.513453e-01,  2.965855e-01, -2.299488e-01,  4.143441e-01},
  {-9.104498e-01,  1.158902e-01,  3.970524e-01,  3.257101e-02, -2.367802e-01,  4.069145e-01},
  { 2.454778e-01,  4.634583e-01,  8.514382e-01, -6.415602e-02, -2.477927e-01,  3.897924e-01},
  { 4.529415e-02,  9.831612e-01,  1.770378e-01, -1.653662e-01, -2.403591e-01,  3.714107e-01},
  {-6.388149e-01,  1.212010e-01, -7.597539e-01, -3.464287e-01, -2.339074e-01,  3.702318e-01},
  {-3.536436e-01,  9.068583e-01,  2.292254e-01, -1.106170e-01, -2.359834e-01,  3.246352e-01},
  {-5.927633e-02,  8.701061e-01,  4.892870e-01, -1.227027e-01, -2.260447e-01,  2.876995e-01},
  {-5.509051e-02, -5.319710e-02,  9.970633e-01,  3.013626e-01, -2.310424e-01,  2.909919e-01},
  {-6.596798e-01,  6.307965e-01,  4.085564e-01, -3.303545e-01, -2.402009e-01,  2.791151e-01},
  {-7.847805e-01,  5.697451e-01,  2.439468e-01, -4.972302e-01, -2.397445e-01,  2.294614e-01},
  {-8.942084e-01,  4.231506e-01, -1.460645e-01, -4.957090e-01, -2.430231e-01,  2.194270e-01},
  { 7.298088e-01,  1.992365e-01, -6.539754e-01,  1.978316e-01, -2.372718e-01,  9.275606e-02},
  { 3.410286e-01,  5.796321e-01, -7.400852e-01, -1.239707e-01, -2.301744e-01,  2.403836e-02},
  {-8.344544e-01,  2.108139e-01, -5.091594e-01,  1.573640e-02, -2.280591e-01, -1.254787e-02},
  {-6.164971e-01,  5.541865e-01,  5.592931e-01,  5.988976e-03, -2.440992e-01, -5.055179e-02},
  { 4.351095e-01,  6.193973e-01, -6.534728e-01,  5.182485e-01, -2.379309e-01, -4.014761e-02},
  { 3.468302e-01, -7.689928e-01,  5.369906e-01,  2.361219e-01, -2.335582e-01, -5.373669e-02},
  { 4.151496e-01, -4.397696e-02, -9.086896e-01, -1.856395e-01, -2.406085e-01, -3.926064e-02},
  {-2.667703e-05, -2.040529e-01, -9.789599e-01, -1.942234e-01, -2.393390e-01, -4.215416e-02},
  {-5.393686e-01, -4.614823e-01, -7.043548e-01, -2.089562e-01, -2.342852e-01, -4.301778e-02},
  { 2.735461e-01,  1.553764e-01,  9.492263e-01, -4.999548e-01, -2.336132e-01, -6.532706e-02},
  { 7.474627e-01, -6.394230e-01,  1.801044e-01,  2.532863e-01, -2.220612e-01, -6.227944e-02},
  {-5.957366e-01, -1.933590e-01, -7.795578e-01, -5.001349e-01, -2.379081e-01, -1.740876e-01},
  {-8.430348e-01, -5.030073e-01,  1.904625e-01, -2.674427e-01, -2.513199e-01, -3.035595e-01},
  {-1.639511e-01, -7.659768e-01, -6.216105e-01,  8.303549e-02, -2.366377e-01, -3.169028e-01},
  { 6.588463e-01, -3.511486e-01, -6.652941e-01, -2.073575e-02, -2.467712e-01, -3.350748e-01},
  {-5.097326e-01, -4.781784e-01,  7.152049e-01, -2.876764e-01, -2.472333e-01, -3.297836e-01},
  { 7.677962e-01,  8.062608e-02,  6.356009e-01,  4.730787e-01, -2.523491e-01, -3.607499e-01},
  { 6.285850e-01, -3.154490e-01,  7.108958e-01,  4.686217e-01, -2.486450e-01, -3.588288e-01},
  {-8.979343e-01, -4.170390e-01,  1.406855e-01,  3.397492e-01, -2.265275e-01, -3.740887e-01},
  {-9.989497e-01,  3.870491e-02,  2.452279e-02, -5.694711e-01, -2.431886e-01, -4.090812e-01},
  { 9.099839e-01,  1.085173e-02, -4.145016e-01, -8.960011e-02, -2.221146e-01, -4.272785e-01},
  { 8.546612e-01, -5.160021e-01,  5.741110e-02,  4.715311e-01, -2.489003e-01, -4.383093e-01},
  { 9.546573e-01,  2.716640e-01,  1.217702e-01, -9.451023e-02, -2.296973e-01, -4.481815e-01},
  { 8.081955e-01, -5.580217e-01,  1.882338e-01,  5.301889e-01, -2.235480e-01, -4.736384e-01},
  { 8.397020e-01, -5.262672e-01,  1.339533e-01,  5.237943e-01, -2.332027e-01, -5.021234e-01},
  {-6.359240e-02,  3.248846e-02, -9.974470e-01, -4.903040e-01, -2.362172e-01, -4.968293e-01},
  { 9.033530e-01, -2.172997e-01, -3.697758e-01,  5.348440e-01, -2.325157e-01, -5.472718e-01},
  {-6.706664e-01, -2.074591e-01, -7.121568e-01,  3.775654e-01, -2.377740e-01, -5.614496e-01},
  { 4.685645e-01, -2.224179e-01, -8.549723e-01,  5.122783e-01, -2.271620e-01, -5.747893e-01},
  {-6.741116e-01, -1.773841e-01,  7.170136e-01, -3.514448e-01, -2.366847e-01, -5.932463e-01},
  { 8.326918e-01,  3.352541e-02,  5.527209e-01, -7.202222e-02, -2.259911e-01, -6.100791e-01},
  { 5.345778e-01,  4.992468e-02,  8.436432e-01, -5.371092e-02, -2.272010e-01, -6.244372e-01},
  { 4.086663e-01, -2.059898e-02, -9.124514e-01,  1.440478e-02, -2.293947e-01, -6.852537e-01},
  {-3.683955e-01,  3.974141e-01, -8.404443e-01, -1.461097e-01, -2.366279e-01, -6.929336e-01},
  {-3.085347e-01,  7.803480e-01, -5.439332e-01, -2.015783e-01, -2.515759e-01, -7.080569e-01},
  { 7.137368e-01, -6.112267e-01, -3.420261e-01, -3.835734e-01, -2.241115e-01, -7.096469e-01},
  {-6.470926e-01, -2.692602e-01,  7.132812e-01,  3.492664e-01, -2.087637e-01,  8.836843e-01},
  { 6.721870e-01, -5.519409e-01,  4.934835e-01,  4.154157e-01, -2.103697e-01,  8.623526e-01},
  { 2.453736e-01,  6.204321e-01,  7.448865e-01,  6.195653e-02, -2.195536e-01,  8.003440e-01},
  {-2.976225e-01,  2.107938e-01,  9.311213e-01,  7.331936e-03, -2.251621e-01,  8.017452e-01},
  {-3.252223e-01, -8.977388e-01,  2.971457e-01,  3.714554e-01, -2.329046e-01,  7.504431e-01},
  {-9.700919e-01, -6.141483e-02, -2.348405e-01,  1.364112e-02, -2.214997e-01,  6.066780e-01},
  { 8.690481e-01,  2.372264e-02, -4.941586e-01,  4.291920e-01, -2.104622e-01,  5.620843e-01},
  {-7.097528e-01,  3.966717e-01,  5.821534e-01, -3.676593e-01, -2.161446e-01,  5.348780e-01},
  {-8.283215e-01,  6.128632e-02,  5.568909e-01, -3.900885e-01, -2.120735e-01,  4.977290e-01},
  { 1.151671e-01,  9.866085e-01,  1.154999e-01, -1.134505e-01, -2.414434e-01,  4.064656e-01},
  {-9.558534e-01, -1.106665e-01,  2.722079e-01,  3.273998e-02, -2.186679e-01,  4.057804e-01},
  {-5.430723e-01,  3.222301e-01,  7.753968e-01,  9.889102e-03, -2.205409e-01,  3.670736e-01},
  { 7.083746e-01,  3.464382e-03,  7.058281e-01,  3.978104e-01, -2.297498e-01,  3.253823e-01},
  {-4.582904e-01,  4.479337e-01,  7.676753e-01, -6.701051e-03, -2.141884e-01,  3.548609e-01},
  {-2.821279e-01,  7.471887e-01,  6.017581e-01, -4.075256e-02, -2.190712e-01,  3.466637e-01},
  {-9.597374e-01,  2.808128e-01,  6.953778e-03, -3.184968e-01, -2.204710e-01,  3.384263e-01},
  { 8.228292e-01, -1.581764e-01,  5.458319e-01,  2.665129e-01, -2.174536e-01,  3.076339e-01},
  {-5.878623e-01,  7.967691e-01,  1.399173e-01, -7.832994e-02, -2.142230e-01,  2.972231e-01},
  {-5.464648e-01,  6.022321e-01,  5.819731e-01, -8.012473e-02, -2.119704e-01,  2.880530e-01},
  {-5.631958e-01,  4.562375e-01,  6.889541e-01, -4.874664e-01, -2.310951e-01,  2.397972e-01},
  { 6.005586e-01,  3.415297e-01, -7.229708e-01,  4.231464e-01, -2.192169e-01,  1.771583e-01},
  {-9.082953e-01,  2.588291e-01, -3.286445e-01, -3.016640e-01, -2.107457e-01,  1.730286e-01},
  {-9.526418e-01, -2.817578e-01, -1.143948e-01, -2.904090e-01, -2.168086e-01,  1.283937e-01},
  { 8.618783e-01, -2.820237e-01,  4.214597e-01,  3.818756e-01, -2.135226e-01,  1.274580e-01},
  {-7.458464e-02,  5.633801e-01, -8.228244e-01,  2.383101e-01, -2.161386e-01,  1.203530e-01},
  {-7.861291e-01, -2.807916e-01, -5.505970e-01, -2.791543e-01, -2.179347e-01,  9.759463e-02},
  { 3.184542e-01, -4.661368e-01,  8.254110e-01,  4.291663e-01, -2.189838e-01,  9.025008e-02},
  {-8.663546e-01, -4.823436e-01,  1.295157e-01, -2.804201e-01, -2.269210e-01, -2.992773e-01},
  {-4.032906e-01, -6.043735e-01,  6.870876e-01, -2.949489e-01, -2.281472e-01, -3.176219e-01},
  { 1.376221e-01,  7.582800e-01, -6.372374e-01, -3.888344e-01, -2.195750e-01, -3.258880e-01},
  {-5.422521e-01, -1.382237e-01,  8.287683e-01, -5.504385e-01, -2.195030e-01, -3.527676e-01},
  {-8.503742e-01,  3.275180e-01,  4.118200e-01, -5.692669e-01, -2.254052e-01, -3.762064e-01},
  {-1.490682e-01,  9.520960e-01, -2.670056e-01, -3.822949e-01, -2.159778e-01, -3.723868e-01},
  {-3.099226e-01,  9.480080e-01, -7.231006e-02, -3.249774e-01, -2.053180e-01, -3.835318e-01},
  {-1.084428e-01,  9.578190e-01,  2.661259e-01, -3.797498e-01, -2.169537e-01, -3.952014e-01},
  {-2.797917e-01,  8.647759e-01,  4.169884e-01, -3.387738e-01, -2.103066e-01, -3.979805e-01},
  {-1.212621e-01,  9.407000e-01,  3.168265e-01, -3.568013e-01, -2.115147e-01, -4.029925e-01},
  { 2.044808e-01,  8.892921e-01,  4.090808e-01, -3.886228e-01, -2.131108e-01, -4.064710e-01},
  {-7.572185e-01,  6.246970e-01, -1.907191e-01, -5.498447e-01, -2.164686e-01, -4.167804e-01},
  {-2.041533e-01,  5.413298e-01,  8.156490e-01, -5.054692e-01, -2.074704e-01, -4.173345e-01},
  { 9.886542e-01,  1.105746e-01, -1.016672e-01, -9.855387e-02, -2.086010e-01, -4.473310e-01},
  { 4.723999e-01,  4.983799e-01,  7.269497e-01, -8.583215e-02, -2.105899e-01, -4.735855e-01},
  {-9.038067e-01, -6.250291e-02, -4.233517e-01, -3.001297e-01, -2.133949e-01, -5.013648e-01},
  { 6.768213e-01, -3.756387e-01, -6.330944e-01, -7.822683e-02, -2.294943e-01, -5.428980e-01},
  { 9.031752e-01, -1.684413e-01,  3.948444e-01, -8.159909e-02, -2.109905e-01, -5.924549e-01},
  {-8.742711e-02,  6.788753e-01, -7.290300e-01, -1.646252e-01, -2.244180e-01, -6.738103e-01},
  {-5.559158e-01,  6.716316e-01, -4.897639e-01, -3.715727e-01, -2.133083e-01, -7.137134e-01},
  { 3.511381e-01, -1.145346e-01,  9.292922e-01,  3.844915e-01, -1.942297e-01,  8.886420e-01},
  { 8.333868e-01,  2.549596e-01,  4.903694e-01,  4.135531e-01, -1.928389e-01,  8.663328e-01},
  { 9.988682e-02,  6.307151e-01,  7.695590e-01,  1.621904e-01, -2.102588e-01,  7.740354e-01},
  { 9.246041e-02,  7.497815e-01,  6.551937e-01,  1.069030e-01, -2.090038e-01,  7.731676e-01},
  {-2.307307e-01, -2.608743e-02,  9.726678e-01, -1.826851e-02, -1.927742e-01,  7.880480e-01},
  {-9.289725e-01, -2.286843e-02,  3.694417e-01, -4.847894e-02, -1.965088e-01,  7.525729e-01},
  {-8.995544e-01, -1.464476e-01, -4.115276e-01, -2.413094e-03, -1.962872e-01,  6.515765e-01},
  {-9.501126e-01, -1.717480e-01, -2.603624e-01,  6.989677e-03, -1.992838e-01,  6.236323e-01},
  { 9.950650e-01,  3.490757e-02,  9.288171e-02,  4.333777e-01, -1.976504e-01,  5.766515e-01},
  {-8.818907e-01, -4.642501e-01, -8.210241e-02,  2.100628e-02, -2.022100e-01,  5.547151e-01},
  {-8.696525e-01, -4.797248e-01,  1.164847e-01,  2.158808e-02, -1.997458e-01,  5.212797e-01},
  {-7.920626e-01, -6.049077e-01, -8.199778e-02,  2.462141e-02, -1.966429e-01,  4.133047e-01},
  {-9.293680e-01,  3.688342e-01, -1.537295e-02, -4.401530e-01, -2.166895e-01,  4.231890e-01},
  {-8.090114e-01, -1.201607e-01, -5.753799e-01, -3.765977e-01, -1.948595e-01,  3.837960e-01},
  { 9.956584e-01, -1.320282e-02, -9.214067e-02,  2.668946e-01, -2.048718e-01,  3.437619e-01},
  {-6.138008e-01,  7.546151e-03,  7.894248e-01, -1.731568e-03, -1.926461e-01,  3.525613e-01},
  {-8.119474e-01, -2.822739e-01, -5.109430e-01, -3.215646e-01, -1.927399e-01,  3.319632e-01},
  {-5.907276e-01,  3.921606e-01,  7.051603e-01, -4.119603e-02, -2.009566e-01,  3.276116e-01},
  {-6.280069e-01,  6.650189e-02,  7.753612e-01, -3.608224e-02, -1.909561e-01,  3.283201e-01},
  { 8.099187e-01, -2.344842e-01,  5.376326e-01,  2.703165e-01, -2.064985e-01,  3.056251e-01},
  {-8.082147e-01,  3.136724e-01,  4.983961e-01, -6.292109e-02, -1.924907e-01,  3.000795e-01},
  { 9.233103e-01, -3.623186e-01,  1.273704e-01,  4.197368e-01, -1.946177e-01,  2.658419e-01},
  { 3.939800e-01,  6.968697e-01,  5.992932e-01, -1.752635e-01, -2.038721e-01,  2.762474e-01},
  {-1.718144e-01,  9.753745e-01,  1.382907e-01, -4.259134e-01, -2.134334e-01,  2.457357e-01},
  {-5.447379e-01,  5.948426e-03,  8.385852e-01, -1.115970e-01, -1.847568e-01,  2.573788e-01},
  { 6.670544e-01,  2.351146e-01, -7.069367e-01,  2.234529e-01, -1.865744e-01,  1.315646e-01},
  { 4.543815e-01, -5.304585e-01,  7.156475e-01,  3.994328e-01, -1.951124e-01,  1.152509e-01},
  { 9.124783e-01, -1.748847e-01,  3.698628e-01,  5.382228e-01, -2.016631e-01,  5.963566e-02},
  { 9.929467e-01, -4.131833e-02, -1.111284e-01,  5.406361e-01, -1.966104e-01,  2.766087e-02},
  {-9.857442e-01,  9.895525e-02, -1.360745e-01,  3.293340e-02, -1.973171e-01, -6.020644e-02},
  {-7.361454e-01,  3.812732e-01,  5.592143e-01,  2.560695e-02, -1.887563e-01, -8.498061e-02},
  {-2.850019e-01,  2.001377e-01, -9.374000e-01, -2.108506e-01, -2.204928e-01, -4.217432e-02},
  {-7.975692e-01, -6.024164e-01, -3.127062e-02, -5.492105e-01, -2.085047e-01, -1.251630e-01},
  {-8.787423e-01, -4.761252e-01,  3.341954e-02, -5.764535e-01, -1.899576e-01, -1.371396e-01},
  { 1.373232e-01, -9.534082e-01,  2.686171e-01,  4.650337e-01, -1.947541e-01, -2.556203e-01},
  {-4.558546e-01, -3.233957e-01,  8.292236e-01,  4.573747e-01, -1.923403e-01, -2.609826e-01},
  { 0.000000e+00,  7.071068e-01,  7.071068e-01,  4.546619e-01, -1.939918e-01, -2.642121e-01},
  {-4.714389e-02, -9.986840e-01,  2.019043e-02,  4.504512e-01, -1.953719e-01, -2.709936e-01},
  {-2.426186e-01, -7.249300e-01,  6.446803e-01,  4.367721e-01, -1.917034e-01, -2.785189e-01},
  {-8.562844e-01, -4.493594e-01, -2.546627e-01, -2.932206e-01, -2.020535e-01, -2.793306e-01},
  { 5.338679e-01, -8.148778e-01, -2.257416e-01,  4.695719e-01, -1.909758e-01, -2.721376e-01},
  { 7.076132e-01, -6.432416e-01,  2.924443e-01,  4.613073e-01, -1.987591e-01, -2.973953e-01},
  { 5.666159e-01, -6.681897e-01,  4.821504e-01,  4.504908e-01, -2.076961e-01, -3.087717e-01},
  { 1.376221e-01,  7.582800e-01, -6.372374e-01, -4.762354e-01, -2.071434e-01, -3.299707e-01},
  {-7.023073e-01, -5.009055e-01,  5.058243e-01,  3.463992e-01, -1.958708e-01, -3.485816e-01},
  {-1.924308e-01,  9.701341e-01,  1.476829e-01, -5.350798e-01, -2.113232e-01, -3.476529e-01},
  { 9.061695e-02, -5.224981e-01, -8.478115e-01,  1.905885e-01, -1.992549e-01, -4.002958e-01},
  {-4.530879e-01,  6.031228e-01,  6.564711e-01, -3.183064e-01, -1.922358e-01, -4.097081e-01},
  {-2.572869e-02,  6.080296e-01,  7.934974e-01, -3.862096e-01, -1.944819e-01, -4.241736e-01},
  {-9.019316e-01,  3.060454e-01,  3.047221e-01, -5.436179e-01, -1.977886e-01, -4.342944e-01},
  {-1.474198e-02,  3.968812e-01,  9.177516e-01,  1.299799e-01, -2.086191e-01, -4.786695e-01},
  { 6.098397e-01,  3.938367e-01,  6.877413e-01, -9.530519e-02, -1.879006e-01, -4.825090e-01},
  {-5.879297e-01, -1.280443e-01, -7.987134e-01, -3.183898e-01, -1.997864e-01, -4.894440e-01},
  {-7.310248e-01,  4.667279e-02, -6.807528e-01, -5.217953e-01, -2.048525e-01, -4.795090e-01},
  { 7.795906e-01,  2.569331e-01, -5.711600e-01,  2.154338e-01, -1.970949e-01, -5.258563e-01},
  { 3.972804e-01, -3.354085e-01, -8.542069e-01,  2.058419e-01, -2.030260e-01, -5.347135e-01},
  { 9.018956e-01, -2.710223e-02, -4.311030e-01,  5.349758e-01, -2.021179e-01, -5.603385e-01},
  {-2.316561e-01,  3.675823e-01, -9.006768e-01, -1.943771e-01, -2.005620e-01, -5.845094e-01},
  { 4.962864e-01, -4.312329e-02, -8.670872e-01,  5.178812e-01, -1.968462e-01, -5.756656e-01},
  {-6.295913e-01,  4.881189e-01, -6.044459e-01, -1.679624e-01, -1.996460e-01, -5.972505e-01},
  {-6.220856e-01,  3.238673e-01,  7.128251e-01, -3.525108e-01, -2.053458e-01, -6.001298e-01},
  { 4.296057e-01, -3.893383e-01, -8.147727e-01, -2.975891e-01, -2.107769e-01, -6.188761e-01},
  {-5.480654e-01,  6.764563e-01, -4.919668e-01, -1.500762e-01, -2.005879e-01, -6.347880e-01},
  { 9.581477e-01, -1.670387e-01,  2.324889e-01,  3.124748e-02, -1.962412e-01, -6.655560e-01},
  {-9.713567e-01,  1.677959e-01,  1.682579e-01, -3.943482e-01, -2.159541e-01, -6.529917e-01},
  {-4.536475e-01,  7.048413e-01, -5.453465e-01, -3.585109e-01, -1.966575e-01, -7.012003e-01},
  { 2.989005e-01,  3.707529e-01,  8.793183e-01, -2.491433e-03, -1.699645e-01,  7.847521e-01},
  { 2.840742e-01,  5.586857e-01,  7.792125e-01,  1.607020e-02, -1.709360e-01,  7.751930e-01},
  {-5.747905e-01,  4.313332e-01,  6.953902e-01,  2.874505e-01, -1.775473e-01,  7.399904e-01},
  { 9.344959e-01,  3.514739e-01,  5.642190e-02,  4.261439e-01, -1.938838e-01,  7.200107e-01},
  {-8.996969e-01, -3.585143e-01, -2.490239e-01, -2.848546e-02, -1.757156e-01,  6.899897e-01},
  { 9.906207e-01,  3.048943e-02,  1.331961e-01,  4.098250e-01, -1.757425e-01,  6.518768e-01},
  { 7.673745e-02,  9.776926e-01,  1.955212e-01,  1.428964e-01, -1.786193e-01,  6.442077e-01},
  {-7.814707e-01, -6.183395e-01, -8.342586e-02,  1.445267e-02, -1.927896e-01,  5.767553e-01},
  {-3.186861e-01,  5.499954e-01,  7.719743e-01, -3.499405e-01, -2.111240e-01,  5.458231e-01},
  { 5.848929e-01,  2.810155e-01, -7.608749e-01,  4.189051e-01, -1.912499e-01,  5.575132e-01},
  { 5.760114e-01,  2.952906e-01, -7.622430e-01,  3.825721e-01, -1.820921e-01,  5.456803e-01},
  {-5.984092e-01, -7.943348e-01,  1.045885e-01,  3.943907e-03, -1.859476e-01,  4.904245e-01},
  {-6.929507e-01, -6.740423e-01, -2.559029e-01,  1.693622e-02, -1.883201e-01,  4.348926e-01},
  {-8.487139e-01, -2.880841e-01,  4.435001e-01,  1.708361e-02, -1.917349e-01,  3.771971e-01},
  { 8.947562e-01, -3.615129e-01,  2.621446e-01,  2.773029e-01, -1.735918e-01,  3.174513e-01},
  {-9.674196e-01,  2.033363e-01, -1.508434e-01, -3.000443e-01, -1.901468e-01,  2.896882e-01},
  { 9.636282e-01, -2.663033e-01, -2.243261e-02,  4.243455e-01, -1.797490e-01,  2.691369e-01},
  {-3.178743e-02, -9.091798e-02,  9.953510e-01,  3.181010e-01, -1.817665e-01,  2.952657e-01},
  {-9.998601e-01,  9.027795e-03, -1.408114e-02, -2.989090e-01, -1.765270e-01,  2.740012e-01},
  {-5.119624e-01,  6.973790e-01,  5.015547e-01, -3.715470e-01, -2.100126e-01,  2.381677e-01},
  {-4.693041e-01,  8.436005e-01, -2.609442e-01, -3.468619e-01, -2.071144e-01,  2.288643e-01},
  {-6.061754e-01,  7.923664e-01,  6.860670e-02, -3.163973e-01, -1.926029e-01,  2.204755e-01},
  { 9.491114e-01, -1.307830e-01, -2.865017e-01,  4.246145e-01, -1.786464e-01,  2.117555e-01},
  { 9.410701e-01,  1.019817e-01, -3.224698e-01,  4.203757e-01, -1.813828e-01,  1.982211e-01},
  {-9.240714e-01, -2.858143e-01,  2.537759e-01, -3.046936e-01, -1.733036e-01,  1.550006e-01},
  {-2.859408e-01,  3.854100e-01, -8.773237e-01,  2.779082e-01, -1.854934e-01,  1.232641e-01},
  {-7.036893e-01, -6.911302e-01,  1.648036e-01, -3.348508e-01, -1.742357e-01,  1.174647e-01},
  { 7.579039e-01, -2.443167e-01,  6.048893e-01,  5.297676e-01, -1.876618e-01,  7.834413e-02},
  { 9.935420e-01,  8.225818e-02, -7.815199e-02,  5.372293e-01, -1.780138e-01,  2.818987e-02},
  {-3.104998e-01,  4.908522e-01,  8.140356e-01, -6.138548e-02, -1.738891e-01, -1.192838e-01},
  {-1.305952e-01, -9.683800e-02,  9.866951e-01, -7.802921e-02, -1.716071e-01, -1.235130e-01},
  {-6.632326e-01, -2.252013e-01,  7.137274e-01, -9.543318e-02, -1.818598e-01, -1.483483e-01},
  {-7.117547e-01, -3.328126e-01, -6.185797e-01, -5.696588e-01, -1.781348e-01, -1.608172e-01},
  {-5.870225e-01,  1.963135e-01,  7.854078e-01, -1.291501e-01, -1.835311e-01, -1.799617e-01},
  { 4.118230e-01,  5.550314e-01,  7.227322e-01,  4.702388e-01, -1.917393e-01, -2.575839e-01},
  { 4.118230e-01,  5.550314e-01,  7.227322e-01,  4.602918e-01, -1.911637e-01, -2.575760e-01},
  {-7.312285e-01, -6.132573e-01,  2.986977e-01, -3.003150e-01, -1.912888e-01, -2.852412e-01},
  {-5.036630e-01,  8.160142e-01,  2.836272e-01, -3.749739e-01, -1.983933e-01, -3.303893e-01},
  {-5.640056e-01,  6.921986e-01, -4.502874e-01, -2.693227e-01, -1.739826e-01, -3.631923e-01},
  { 9.040214e-01, -3.747573e-01,  2.056753e-01,  5.402098e-01, -1.649198e-01, -4.169569e-01},
  {-6.634775e-01, -7.481688e-01, -6.425027e-03,  3.126729e-01, -1.834939e-01, -4.256414e-01},
  {-7.317486e-01,  8.233935e-02,  6.765826e-01, -5.435097e-01, -1.751971e-01, -4.415017e-01},
  { 5.440935e-01,  6.148105e-01,  5.709381e-01,  1.884005e-01, -1.817732e-01, -4.892632e-01},
  { 9.983394e-01, -5.507687e-02, -1.687753e-02,  5.456511e-01, -1.758206e-01, -5.085641e-01},
  {-9.514845e-01, -4.900719e-02, -3.037690e-01, -3.000074e-01, -1.792885e-01, -5.110345e-01},
  {-9.824273e-01, -4.135309e-02, -1.820069e-01, -2.938031e-01, -1.757778e-01, -5.335729e-01},
  { 1.694452e-03,  2.248750e-02, -9.997457e-01, -1.802979e-01, -1.757095e-01, -5.831301e-01},
  { 2.671799e-01,  1.157581e-01, -9.566687e-01,  5.014091e-01, -1.785146e-01, -5.804545e-01},
  {-4.231186e-01, -2.078825e-01, -8.819046e-01,  3.501511e-01, -1.643742e-01, -5.717826e-01},
  {-7.663064e-01,  4.435703e-01,  4.647793e-01, -3.620111e-01, -1.762746e-01, -6.285155e-01},
  { 8.990054e-01,  1.589689e-02, -4.376487e-01,  3.084764e-02, -1.863061e-01, -6.885408e-01},
  {-9.933279e-01, -9.002460e-02,  7.207863e-02,  2.996504e-01, -1.579487e-01,  7.630932e-01},
  { 9.483122e-01,  3.135566e-01, -4.884950e-02,  4.145729e-01, -1.731965e-01,  7.019089e-01},
  {-2.030792e-01, -7.510083e-01,  6.282876e-01, -1.543842e-01, -1.477352e-01,  6.552826e-01},
  {-3.834827e-01,  8.358766e-01,  3.927484e-01,  1.833164e-01, -1.685127e-01,  6.360590e-01},
  { 4.332620e-02, -9.389223e-01,  3.413907e-01, -1.295634e-01, -1.529135e-01,  6.342525e-01},
  {-5.018160e-01,  3.811574e-01,  7.764663e-01,  2.024654e-01, -1.549059e-01,  6.292920e-01},
  {-7.018403e-01, -6.965404e-01,  1.491700e-01, -5.036959e-03, -1.770346e-01,  6.110860e-01},
  { 2.635770e-02, -9.725579e-01,  2.311630e-01, -1.262094e-01, -1.631741e-01,  6.078628e-01},
  {-1.732523e-01,  6.724238e-01,  7.196039e-01,  1.634826e-01, -1.580989e-01,  6.095970e-01},
  { 1.953861e-01,  7.051722e-01,  6.815838e-01,  1.217235e-01, -1.576155e-01,  6.123824e-01},
  {-2.852763e-01, -9.397148e-01,  1.885567e-01, -1.709040e-01, -1.594855e-01,  5.918196e-01},
  { 9.266660e-01,  3.645221e-01, -9.172570e-02,  4.282548e-01, -1.814665e-01,  5.758145e-01},
  { 9.069939e-01,  3.048678e-01, -2.905471e-01,  4.190569e-01, -1.626721e-01,  5.753574e-01},
  {-3.953750e-01, -2.668322e-03,  9.185160e-01, -2.030224e-01, -1.558537e-01,  5.718158e-01},
  {-1.179125e-01, -9.659160e-01, -2.304409e-01, -1.821078e-01, -1.590972e-01,  5.490714e-01},
  {-3.455261e-01, -9.352785e-01,  7.658891e-02, -8.624422e-03, -1.810758e-01,  5.058594e-01},
  { 1.753081e-01,  8.864829e-01,  4.282699e-01, -3.667289e-01, -1.832796e-01,  4.925867e-01},
  {-3.312633e-01,  7.181237e-01,  6.120155e-01, -3.794661e-01, -1.803645e-01,  4.946443e-01},
  { 8.545324e-02,  9.191818e-01,  3.844510e-01, -3.563591e-01, -1.687802e-01,  4.231191e-01},
  {-6.555074e-01, -7.496221e-01, -9.152429e-02,  8.637591e-03, -1.760481e-01,  3.950244e-01},
  { 9.477487e-01, -3.021254e-01,  1.024336e-01,  4.362877e-01, -1.571715e-01,  3.143224e-01},
  {-5.948460e-01, -4.683194e-01,  6.533263e-01, -5.000984e-02, -1.630370e-01,  3.231592e-01},
  { 4.689406e-01, -3.735041e-01,  8.003683e-01,  2.868244e-01, -1.719618e-01,  3.042930e-01},
  {-9.806164e-01,  1.955095e-01,  1.294565e-02, -2.983896e-01, -1.695415e-01,  2.032256e-01},
  { 9.736401e-01, -2.193485e-01,  6.254094e-02,  3.840612e-01, -1.587546e-01,  1.696811e-01},
  {-4.597158e-01, -8.058383e-01,  3.732104e-01, -3.551956e-01, -1.572141e-01,  1.222437e-01},
  {-3.030566e-01, -9.370217e-01,  1.736288e-01, -3.674871e-01, -1.590859e-01,  1.066748e-01},
  { 7.828529e-01, -2.997633e-01,  5.452370e-01,  5.316921e-01, -1.655630e-01,  8.407176e-02},
  { 9.985526e-01, -5.360859e-02, -4.333714e-03,  5.404921e-01, -1.620550e-01,  5.755711e-02},
  {-9.954180e-01, -8.475766e-02,  4.426373e-02,  3.230164e-02, -1.720896e-01, -7.114062e-02},
  {-3.180143e-01,  6.899046e-01, -6.503065e-01, -2.711525e-01, -1.574878e-01, -3.812237e-02},
  {-5.513283e-01,  1.929666e-01,  8.116656e-01, -5.549093e-01, -1.718426e-01, -8.923893e-02},
  {-9.422765e-01,  9.164955e-02,  3.220488e-01,  2.651971e-02, -1.571714e-01, -1.019454e-01},
  {-7.979578e-01,  3.337918e-01,  5.018430e-01,  1.560500e-02, -1.652966e-01, -1.273120e-01},
  {-9.871579e-01,  2.433323e-02,  1.578839e-01, -5.785121e-01, -1.614033e-01, -1.400825e-01},
  {-8.277447e-01, -1.317662e-01,  5.454140e-01, -1.099393e-01, -1.644293e-01, -1.590504e-01},
  { 6.776404e-01, -6.378690e-01,  3.659600e-01,  3.119382e-01, -1.663987e-01, -1.947220e-01},
  { 2.473026e-01, -4.599111e-01,  8.528325e-01,  4.046042e-01, -1.660459e-01, -2.649300e-01},
  { 4.851717e-01,  3.302210e-01,  8.096681e-01,  4.499303e-01, -1.688663e-01, -2.779120e-01},
  { 2.090873e-01, -9.604938e-01,  1.836690e-01,  3.284969e-01, -1.833762e-01, -3.056847e-01},
  {-8.327776e-01,  4.882941e-01,  2.608648e-01, -3.352381e-01, -1.579039e-01, -3.195789e-01},
  {-1.313815e-01, -9.911325e-01,  1.987990e-02,  2.983932e-01, -1.775335e-01, -3.652804e-01},
  {-6.547074e-01,  7.534795e-01,  6.022315e-02, -2.523952e-01, -1.581927e-01, -3.620832e-01},
  { 5.195324e-01, -3.597106e-01, -7.750447e-01, -5.915445e-02, -1.581388e-01, -4.000648e-01},
  {-3.615513e-01, -4.493573e-01, -8.169202e-01,  2.376474e-01, -1.683857e-01, -4.129698e-01},
  {-5.463308e-01, -7.912393e-01, -2.747053e-01,  2.917482e-01, -1.612796e-01, -4.443260e-01},
  {-9.816577e-01, -1.136996e-01,  1.530379e-01, -5.489740e-01, -1.681983e-01, -4.455920e-01},
  { 9.814305e-01,  7.398091e-02,  1.769774e-01, -1.019358e-01, -1.563975e-01, -4.831835e-01},
  {-2.027951e-01,  1.734821e-01, -9.637314e-01, -1.660576e-01, -1.549826e-01, -5.837788e-01},
  { 8.397161e-01,  1.067978e-01,  5.324199e-01,  3.219604e-02, -1.800509e-01, -6.592125e-01},
  {-7.605314e-01,  6.477098e-01, -4.543112e-02, -3.718251e-01, -1.801817e-01, -6.595098e-01},
  {-6.225876e-01,  6.822486e-01, -3.833036e-01, -3.707202e-01, -1.864735e-01, -6.778815e-01},
  {-1.347051e-01, -1.021135e-01, -9.856102e-01, -5.032811e-02, -1.600079e-01, -6.868883e-01},
  { 6.063865e-01,  5.575628e-01,  5.669384e-01,  3.806798e-01, -1.608474e-01,  8.824031e-01},
  {-1.795023e-01, -3.125707e-02,  9.832608e-01,  3.384120e-01, -1.398332e-01,  8.900744e-01},
  {-9.084944e-01, -2.811822e-02,  4.169500e-01,  2.842147e-01, -1.374719e-01,  7.063856e-01},
  {-5.750647e-01,  6.460463e-01,  5.019212e-01,  2.316206e-01, -1.438337e-01,  6.455651e-01},
  {-5.206660e-01, -8.346397e-01,  1.796761e-01, -2.925945e-02, -1.582312e-01,  6.304137e-01},
  {-5.799114e-01, -7.707641e-01,  2.638663e-01, -4.046125e-02, -1.518708e-01,  6.293899e-01},
  { 9.926632e-01, -3.950103e-02, -1.142779e-01,  4.250685e-01, -1.364744e-01,  5.952947e-01},
  { 3.816152e-01,  8.697248e-01,  3.129675e-01,  1.041141e-01, -1.446965e-01,  6.069302e-01},
  {-2.122361e-01, -7.127655e-01,  6.685216e-01, -6.219597e-02, -1.553376e-01,  6.122877e-01},
  {-5.232379e-01, -8.317285e-01, -1.856067e-01, -2.241075e-01, -1.389520e-01,  5.593407e-01},
  { 7.216543e-01,  9.271748e-04, -6.922529e-01,  3.180203e-01, -1.353483e-01,  5.191279e-01},
  {-2.852415e-01, -9.109675e-01, -2.979523e-01, -2.093488e-01, -1.414618e-01,  5.088945e-01},
  {-3.779729e-01,  8.415937e-01,  3.858196e-01, -3.918938e-01, -1.668724e-01,  4.673744e-01},
  {-5.915189e-01,  8.025263e-01,  7.782674e-02, -4.024564e-01, -1.700682e-01,  4.459666e-01},
  { 9.819061e-01, -9.348407e-02, -1.646847e-01,  2.809582e-01, -1.505099e-01,  3.967899e-01},
  {-6.322260e-01, -6.517233e-01,  4.189833e-01, -1.154500e-02, -1.606854e-01,  3.658012e-01},
  { 7.233602e-01, -1.146360e-01,  6.808881e-01,  4.354066e-01, -1.303778e-01,  3.317808e-01},
  {-6.367306e-01, -7.211656e-01, -2.729365e-01, -1.376754e-01, -1.358367e-01,  3.246790e-01},
  {-3.486244e-01, -8.391819e-01,  4.174144e-01, -7.071051e-02, -1.508701e-01,  3.192959e-01},
  { 3.454915e-03, -4.360743e-01,  8.999040e-01,  3.234385e-01, -1.560394e-01,  3.023179e-01},
  { 9.895857e-01, -1.288534e-01,  6.416386e-02,  4.394763e-01, -1.427068e-01,  2.708964e-01},
  { 4.926513e-01,  2.340444e-01, -8.381634e-01,  2.406096e-01, -1.416584e-01,  1.509816e-01},
  { 6.453667e-01, -3.999971e-01,  6.507721e-01,  5.203678e-01, -1.489131e-01,  1.016931e-01},
  {-4.886869e-01, -8.722531e-01,  1.896354e-02, -4.227134e-01, -1.362195e-01,  8.952186e-02},
  {-5.881870e-01,  2.014349e-01, -7.832369e-01, -1.708054e-02, -1.419226e-01,  2.725674e-02},
  {-4.824387e-01,  3.324991e-01, -8.103686e-01, -3.572009e-01, -1.371828e-01,  5.231671e-03},
  { 3.168803e-01,  6.964551e-01, -6.438457e-01, -2.553494e-01, -1.518070e-01, -2.929346e-02},
  {-3.540831e-01,  3.928148e-02, -9.343887e-01, -2.785809e-01, -1.547443e-01, -3.659451e-02},
  {-5.409782e-01,  6.175131e-01,  5.709817e-01, -2.614595e-01, -1.524127e-01, -3.442741e-02},
  { 6.795499e-01, -7.273966e-01,  9.542565e-02,  2.942429e-01, -1.649011e-01, -1.347624e-01},
  {-5.986662e-01,  5.055323e-01,  6.213179e-01,  7.921330e-03, -1.435531e-01, -1.488811e-01},
  { 2.299035e-01,  8.056427e-01,  5.459708e-01, -4.048159e-02, -1.379664e-01, -1.802326e-01},
  {-7.576030e-01, -3.498440e-01, -5.510416e-01, -3.430362e-01, -1.495838e-01, -2.480744e-01},
  {-9.344065e-01, -1.630258e-01, -3.167129e-01, -3.348683e-01, -1.419472e-01, -2.915202e-01},
  {-6.343742e-01,  5.533518e-01, -5.397881e-01, -2.389455e-01, -1.399859e-01, -3.435928e-01},
  {-3.269598e-01,  4.837621e-01, -8.118322e-01, -2.436712e-01, -1.416631e-01, -3.433087e-01},
  {-3.829703e-01,  1.274075e-01, -9.149323e-01, -5.453005e-01, -1.572170e-01, -4.491450e-01},
  {-3.019082e-01,  2.267610e-01, -9.259757e-01, -5.355643e-01, -1.453094e-01, -4.514905e-01},
  { 4.473307e-01,  1.190990e-01,  8.864032e-01, -8.957770e-02, -1.440626e-01, -5.048704e-01},
  {-7.680140e-01, -4.752439e-01, -4.292991e-01,  3.210822e-01, -1.468026e-01, -5.541452e-01},
  {-6.554034e-01,  7.509098e-01,  8.112288e-02, -3.470981e-01, -1.561407e-01, -6.339810e-01},
  { 8.996771e-01,  2.733305e-01, -3.403991e-01,  1.960114e-02, -1.428374e-01, -6.716703e-01},
  { 4.516509e-01, -7.903274e-01, -4.139977e-01, -2.782862e-01, -1.387490e-01, -7.040973e-01},
  { 4.253206e-01, -7.556434e-01, -4.981019e-01, -3.020743e-01, -1.324876e-01, -7.556157e-01},
  { 5.633224e-02, -6.027722e-01, -7.959224e-01, -3.322127e-01, -1.321291e-01, -7.661660e-01},
  { 4.715022e-01,  4.223715e-01,  7.741369e-01,  3.302982e-01, -1.289679e-01,  8.883410e-01},
  {-7.835161e-01, -1.156017e-01,  6.105233e-01,  3.233831e-01, -1.235575e-01,  8.832753e-01},
  {-6.386283e-01, -8.976660e-02,  7.642616e-01, -5.167696e-02, -1.204827e-01,  7.755502e-01},
  {-8.544456e-01, -5.043229e-01,  1.248236e-01, -6.663204e-02, -1.230908e-01,  7.442790e-01},
  {-9.662150e-01, -2.426722e-01,  8.682592e-02,  2.939484e-01, -1.296295e-01,  7.407655e-01},
  {-2.744880e-01, -1.830743e-01,  9.440022e-01, -1.531783e-01, -1.163410e-01,  6.719968e-01},
  {-7.470295e-01, -4.787188e-02,  6.630650e-01, -1.656888e-01, -1.128660e-01,  6.717430e-01},
  { 7.609342e-01,  3.791349e-01,  5.265319e-01,  4.043215e-01, -1.231636e-01,  6.437259e-01},
  {-5.644580e-01,  1.841299e-01,  8.046635e-01,  1.859541e-01, -1.278224e-01,  6.077258e-01},
  {-3.240809e-01,  3.029028e-01,  8.962262e-01,  1.651269e-01, -1.346239e-01,  5.933863e-01},
  { 9.503572e-01, -2.061290e-01,  2.330925e-01,  2.825337e-01, -1.240062e-01,  4.021094e-01},
  {-3.463032e-01, -9.348664e-01, -7.809578e-02, -7.235271e-02, -1.326529e-01,  3.956377e-01},
  {-3.752603e-01, -8.976611e-01, -2.310501e-01, -1.838482e-01, -1.223718e-01,  3.753561e-01},
  {-7.766471e-01, -3.053170e-01, -5.509998e-01, -1.956507e-01, -1.093363e-01,  3.636693e-01},
  {-6.538762e-01, -4.747029e-01, -5.891544e-01, -1.871409e-01, -1.152641e-01,  3.580605e-01},
  {-8.345791e-01, -5.507352e-01,  1.298050e-02, -3.838010e-01, -1.152744e-01,  3.380643e-01},
  { 4.142447e-01, -7.213222e-01,  5.550636e-01,  3.024320e-01, -1.388166e-01,  3.183359e-01},
  {-8.156621e-01, -4.028994e-01, -4.151714e-01, -3.629524e-01, -1.284176e-01,  3.147561e-01},
  {-6.805443e-01, -6.112578e-01, -4.040093e-01, -3.053728e-01, -1.324047e-01,  2.442568e-01},
  { 8.946078e-01,  6.416322e-02, -4.422214e-01,  4.371435e-01, -1.199501e-01,  2.388980e-01},
  {-8.925995e-01, -4.436235e-01, -8.040120e-02, -2.995954e-01, -1.373905e-01,  2.377294e-01},
  { 1.744399e-01,  1.600713e-01, -9.715698e-01,  2.481621e-01, -1.157604e-01,  1.575774e-01},
  { 7.515249e-01,  7.446340e-02, -6.554888e-01,  2.303400e-01, -1.149647e-01,  1.448034e-01},
  { 8.436679e-01, -3.657440e-01,  3.930089e-01,  5.262138e-01, -1.224306e-01,  1.170428e-01},
  { 9.982046e-01,  2.343577e-02, -5.512078e-02,  2.187040e-01, -1.227985e-01,  9.900998e-02},
  { 9.883909e-01, -3.572911e-02,  1.476711e-01,  5.382480e-01, -1.274334e-01,  7.465534e-02},
  {-2.423663e-01,  3.309675e-01, -9.119864e-01, -1.781982e-01, -1.154564e-01,  8.349727e-02},
  { 1.090473e-01,  7.876734e-01, -6.063657e-01, -2.372814e-01, -1.166581e-01,  8.834423e-02},
  { 7.352802e-02,  8.299441e-01, -5.529796e-01, -2.618571e-01, -1.241136e-01,  7.133436e-02},
  {-6.815183e-01,  8.002605e-02, -7.274123e-01, -4.381864e-01, -1.182447e-01,  8.317363e-02},
  { 7.304288e-01,  2.727374e-01, -6.261693e-01,  5.292937e-01, -1.237343e-01,  4.867915e-02},
  { 7.559667e-02,  6.969150e-01, -7.131584e-01, -1.944413e-01, -1.423455e-01,  4.784993e-02},
  {-3.281347e-01,  7.428341e-01, -5.835453e-01, -4.183988e-01, -1.230727e-01,  6.071681e-02},
  {-6.920794e-02,  9.663023e-01, -2.479314e-01, -3.935670e-01, -1.306480e-01,  2.819766e-02},
  {-5.026396e-01,  3.660601e-01, -7.831688e-01, -3.710591e-01, -1.307517e-01,  1.971075e-02},
  { 3.986594e-02,  9.089885e-01, -4.149103e-01, -2.807077e-01, -1.324827e-01, -1.094457e-02},
  { 7.279350e-01, -6.838960e-01, -4.895812e-02,  3.683553e-01, -1.239092e-01, -1.219973e-01},
  {-9.764117e-01, -1.164835e-01,  1.818016e-01,  2.299413e-02, -1.259329e-01, -1.140122e-01},
  { 2.576618e-01,  3.651277e-01,  8.945906e-01, -8.631904e-02, -1.349046e-01, -1.234283e-01},
  {-5.447465e-01, -2.071526e-01,  8.126126e-01, -1.191938e-01, -1.284456e-01, -1.337301e-01},
  {-7.470838e-01, -1.628322e-01, -6.444777e-01, -5.766976e-01, -1.265065e-01, -1.435262e-01},
  { 4.512724e-01,  8.451312e-01,  2.865422e-01, -7.824790e-02, -1.199879e-01, -1.923704e-01},
  {-3.222048e-01,  7.775970e-01,  5.399324e-01, -3.542983e-02, -1.223356e-01, -2.038185e-01},
  {-1.658927e-01,  8.137067e-01,  5.571005e-01, -4.495808e-02, -1.161364e-01, -2.151254e-01},
  {-8.739977e-01, -1.514800e-01, -4.617162e-01, -3.322946e-01, -1.231070e-01, -3.070979e-01},
  { 9.259173e-01, -1.287427e-01,  3.551091e-01,  5.304487e-01, -1.208901e-01, -3.622720e-01},
  {-9.757907e-01,  1.574649e-01, -1.517807e-01, -2.197888e-01, -1.129327e-01, -3.527878e-01},
  {-8.323923e-01,  5.457325e-01,  9.643152e-02, -2.221136e-01, -1.217904e-01, -3.692823e-01},
  { 8.876005e-01, -1.469032e-01, -4.365600e-01, -8.959912e-02, -1.242939e-01, -4.431086e-01},
  { 8.020884e-02,  2.637010e-01,  9.612640e-01, -3.844835e-01, -1.284043e-01, -4.429169e-01},
  {-5.110762e-01, -1.340534e-01, -8.490176e-01, -2.972786e-01, -1.290016e-01, -5.270957e-01},
  {-6.985151e-01, -6.463689e-02, -7.126703e-01,  3.245739e-01, -1.183552e-01, -5.672467e-01},
  {-4.092916e-01, -6.876610e-02, -9.098085e-01, -1.615279e-01, -1.242740e-01, -5.837893e-01},
  { 3.048932e-01, -7.247408e-02, -9.496250e-01, -1.768345e-01, -1.288504e-01, -5.819653e-01},
  {-7.346814e-01,  8.242328e-02, -6.733868e-01, -1.392010e-01, -1.211656e-01, -6.050280e-01},
  { 5.992374e-01,  4.413612e-01,  6.679183e-01, -1.068043e-02, -1.241937e-01, -6.509053e-01},
  { 9.249406e-01, -1.768323e-01, -3.364748e-01,  1.382031e-02, -1.204912e-01, -6.972293e-01},
  { 8.598317e-01,  4.485567e-01,  2.438982e-01,  3.425541e-01, -1.075655e-01,  8.110691e-01},
  {-7.762306e-01, -2.147169e-01,  5.927585e-01,  2.714989e-01, -1.173964e-01,  6.823662e-01},
  {-4.032100e-01, -7.348666e-01,  5.453373e-01, -5.651237e-02, -1.191629e-01,  6.715425e-01},
  {-1.702262e-01,  1.752502e-01,  9.696960e-01,  1.274019e-01, -9.848339e-02,  5.819013e-01},
  {-4.755451e-01, -1.639656e-01,  8.642755e-01, -2.660062e-01, -1.023792e-01,  5.514941e-01},
  {-1.466738e-01,  7.749008e-01,  6.148296e-01, -1.706371e-01, -1.055704e-01,  5.301093e-01},
  { 2.730920e-01,  5.544878e-01,  7.861068e-01, -2.233295e-01, -1.039441e-01,  5.382518e-01},
  {-2.851299e-01,  7.200018e-01,  6.326914e-01,  4.151911e-01, -9.421343e-02,  4.199392e-01},
  { 5.955623e-01, -5.002592e-01,  6.285272e-01,  4.227120e-01, -1.118191e-01,  3.519521e-01},
  {-6.409591e-01, -7.609288e-01,  1.007911e-01, -3.927159e-01, -1.049008e-01,  3.286384e-01},
  {-3.100724e-01,  1.038208e-01,  9.450271e-01, -1.306157e-01, -1.037091e-01,  2.389175e-01},
  {-8.555368e-01, -4.912995e-01,  1.633454e-01, -3.106805e-01, -1.127187e-01,  2.020797e-01},
  {-7.691945e-01, -4.774348e-01,  4.247303e-01, -3.129447e-01, -1.152691e-01,  1.825842e-01},
  {-2.348882e-01,  7.911495e-02, -9.687974e-01, -4.706776e-01, -1.069225e-01,  1.054887e-01},
  { 9.367058e-02,  8.285520e-01, -5.520212e-01, -3.084455e-01, -1.086105e-01,  8.552134e-02},
  { 9.326066e-03,  8.949330e-01, -4.461030e-01, -3.193554e-01, -1.141270e-01,  7.187197e-02},
  {-6.372858e-01, -1.331145e-01, -7.590436e-01, -4.632939e-01, -1.128448e-01,  9.886067e-02},
  {-6.190823e-01,  2.934621e-01, -7.284346e-01, -3.809144e-02, -9.584738e-02,  6.214349e-02},
  { 8.934277e-01, -3.576504e-01,  2.717959e-01,  2.343651e-01, -1.172235e-01,  5.751615e-02},
  { 4.511226e-01, -7.808575e-01,  4.321459e-01,  3.662084e-01, -1.077530e-01,  1.897430e-02},
  {-8.402930e-01,  1.039641e-01, -5.320705e-01, -1.559187e-02, -1.056243e-01,  3.033441e-02},
  { 8.379739e-01, -5.214473e-01,  1.609116e-01,  4.083646e-01, -9.479318e-02, -1.890617e-02},
  { 4.461624e-01, -7.470269e-01,  4.928387e-01,  4.038171e-01, -9.405611e-02, -1.445070e-02},
  { 9.863346e-01, -1.155065e-01, -1.174833e-01,  4.075728e-01, -9.100389e-02, -2.280387e-02},
  {-3.809158e-01, -9.377270e-02,  9.198423e-01, -1.228187e-01, -1.129596e-01, -1.295779e-01},
  { 4.266597e-01,  6.173083e-01,  6.609780e-01, -1.057644e-01, -1.090790e-01, -1.389507e-01},
  {-6.276982e-01,  4.902578e-01,  6.046836e-01, -5.684375e-01, -1.070316e-01, -1.352793e-01},
  {-2.327439e-01, -1.136850e-01,  9.658706e-01, -4.921277e-01, -1.091777e-01, -1.429608e-01},
  {-8.509532e-01, -3.210528e-01, -4.156966e-01, -5.704817e-01, -1.076417e-01, -1.701372e-01},
  {-6.528845e-01,  4.091572e-01,  6.374419e-01, -1.593478e-02, -1.053778e-01, -2.027056e-01},
  {-4.456608e-01, -4.872020e-01, -7.510131e-01, -4.001233e-01, -1.183069e-01, -2.287826e-01},
  {-2.936103e-01,  5.509279e-01,  7.811987e-01, -6.399562e-02, -1.022068e-01, -2.395067e-01},
  { 4.102460e-01,  8.345973e-01,  3.676213e-01, -7.839601e-02, -1.072415e-01, -2.320762e-01},
  {-6.902083e-01,  3.673952e-02, -7.226774e-01, -2.241492e-01, -9.697520e-02, -3.388507e-01},
  {-3.863563e-01,  1.081610e-01,  9.159858e-01, -5.157402e-01, -1.065572e-01, -4.335827e-01},
  {-3.884170e-01,  3.159350e-01, -8.656312e-01, -4.917955e-01, -1.151552e-01, -4.583766e-01},
  { 8.055868e-01,  1.087437e-01,  5.824128e-01, -1.019206e-01, -1.024476e-01, -4.925145e-01},
  { 7.599500e-01,  1.364368e-01, -6.355006e-01,  5.299803e-01, -1.061628e-01, -5.671722e-01},
  {-4.129542e-03, -3.409520e-01, -9.400717e-01,  3.017410e-02, -1.045910e-01, -5.694830e-01},
  { 6.404249e-01, -3.261771e-01, -6.953161e-01, -1.970825e-01, -1.014703e-01, -6.009505e-01},
  {-9.022248e-01,  3.550149e-01,  2.448565e-01, -3.111281e-01, -1.196759e-01, -6.158196e-01},
  { 8.407038e-01,  3.822653e-01,  3.835235e-01,  1.235558e-02, -1.206547e-01, -6.743393e-01},
  {-8.679013e-01,  2.953869e-01,  3.993668e-01, -2.941193e-01, -1.019880e-01, -7.051628e-01},
  { 6.495387e-01, -5.724475e-03, -7.603070e-01,  9.790353e-03, -1.075435e-01, -7.125273e-01},
  { 3.404645e-01, -1.499845e-01, -9.282179e-01, -2.797891e-01, -9.569156e-02, -7.588697e-01},
  { 9.105791e-02, -2.220914e-03, -9.958431e-01, -3.159626e-01, -1.098263e-01, -7.675492e-01},
  {-3.966255e-01,  2.680558e-01,  8.779717e-01,  3.313051e-01, -1.008246e-01,  8.835327e-01},
  { 2.295204e-01,  5.304950e-01,  8.160241e-01, -4.206967e-02, -1.006509e-01,  7.744695e-01},
  { 1.318713e-01,  5.903035e-01,  7.963364e-01, -5.439385e-02, -9.217131e-02,  7.669872e-01},
  { 9.516896e-01,  2.352943e-01,  1.972902e-01,  3.413208e-01, -8.197626e-02,  7.280170e-01},
  {-7.770538e-01, -5.899242e-01,  2.194924e-01,  2.718201e-01, -9.735965e-02,  7.244264e-01},
  { 8.416290e-01,  3.400233e-01,  4.195770e-01,  3.545441e-01, -7.928517e-02,  6.740762e-01},
  {-5.615690e-01, -5.605941e-01,  6.085840e-01,  2.363590e-01, -1.053366e-01,  6.561744e-01},
  { 9.236187e-01, -8.462735e-02, -3.738540e-01,  4.336031e-01, -9.106739e-02,  5.895045e-01},
  {-1.842105e-01,  9.147846e-01,  3.594935e-01, -1.402189e-01, -8.351070e-02,  5.054367e-01},
  { 5.700299e-01, -1.546474e-01,  8.069388e-01,  4.104027e-01, -9.023913e-02,  4.132585e-01},
  { 7.417082e-01,  2.513224e-01,  6.218568e-01, -3.684189e-01, -8.646085e-02,  3.605754e-01},
  { 9.663863e-01, -4.062784e-02, -2.538641e-01,  4.008960e-01, -9.172221e-02,  1.996383e-01},
  {-4.120244e-01, -8.285700e-01,  3.790878e-01, -3.403854e-01, -9.655049e-02,  1.801411e-01},
  {-3.246110e-02,  3.159318e-01, -9.482265e-01, -2.145712e-01, -9.254806e-02,  1.005041e-01},
  { 2.694453e-02,  2.005862e-01, -9.793054e-01, -2.933646e-01, -9.105046e-02,  1.032226e-01},
  { 9.083479e-02,  4.453957e-01, -8.907142e-01, -3.719638e-01, -7.705969e-02,  1.060623e-01},
  {-1.233799e-01,  4.243020e-01, -8.970760e-01, -4.177897e-01, -9.174904e-02,  9.788202e-02},
  {-2.730470e-01,  2.988442e-01, -9.144055e-01, -6.979609e-02, -9.331438e-02,  8.158736e-02},
  { 9.676810e-01, -2.473313e-01, -4.920059e-02,  4.105913e-01, -7.857090e-02, -2.362955e-02},
  { 5.127360e-01,  6.030143e-01,  6.111265e-01, -1.179537e-01, -9.132233e-02, -1.486475e-01},
  { 3.071739e-01, -1.867192e-02,  9.514703e-01, -3.926458e-01, -9.663812e-02, -1.489886e-01},
  {-9.714635e-01,  1.986499e-02,  2.363559e-01,  2.235423e-03, -9.139512e-02, -1.798252e-01},
  {-6.666667e-01, -3.333333e-01, -6.666667e-01,  4.462866e-01, -8.117466e-02, -2.866677e-01},
  {-4.838063e-01, -2.246383e-02, -8.748868e-01, -3.418306e-01, -9.542900e-02, -2.980395e-01},
  {-7.740151e-01,  4.227795e-01,  4.713364e-01, -2.118435e-01, -9.058313e-02, -3.894001e-01},
  {-8.548595e-01,  4.471243e-02, -5.169295e-01, -4.313587e-01, -8.470294e-02, -4.786403e-01},
  {-5.085828e-01, -5.522794e-01, -6.605536e-01, -3.089858e-01, -9.507672e-02, -5.422860e-01},
  { 8.714775e-01,  3.351190e-01,  3.580810e-01,  2.012258e-01, -8.972623e-02, -5.630254e-01},
  { 7.837662e-01, -1.604824e-01, -5.999633e-01, -4.846355e-02, -8.827963e-02, -5.888780e-01},
  { 9.694389e-01, -9.309555e-02,  2.269834e-01, -5.326150e-02, -8.266862e-02, -6.195320e-01},
  { 8.677000e-01,  4.392689e-01,  2.326794e-01,  1.023285e-02, -1.012293e-01, -6.929402e-01},
  { 7.350124e-01,  6.539751e-01,  1.790902e-01,  4.765183e-03, -8.861020e-02, -7.025730e-01},
  {-8.769441e-01,  3.599271e-01, -3.184671e-01, -3.352534e-01, -1.006097e-01, -7.610895e-01},
  { 1.412078e-01, -8.393681e-01,  5.249016e-01,  1.492359e-01, -6.382652e-02,  7.720186e-01},
  { 3.554882e-01, -8.192967e-01,  4.498677e-01,  1.695645e-01, -6.577591e-02,  7.590196e-01},
  {-8.259189e-01, -1.534647e-01,  5.425003e-01, -8.220290e-02, -7.944480e-02,  7.486258e-01},
  {-4.067214e-01, -6.022177e-01,  6.869582e-01,  2.351317e-01, -5.898738e-02,  7.420614e-01},
  { 3.231791e-01, -7.156765e-01,  6.191627e-01,  1.821989e-01, -7.451736e-02,  7.226216e-01},
  {-4.312163e-01, -9.022102e-01, -8.325542e-03,  1.513511e-01, -6.806096e-02,  7.192705e-01},
  { 9.879546e-01, -4.710998e-02,  1.473993e-01,  3.448692e-01, -6.670311e-02,  6.889656e-01},
  {-7.557774e-01,  1.173664e-02,  6.547234e-01, -1.659029e-01, -8.345006e-02,  6.739689e-01},
  { 8.626443e-01, -1.697965e-01, -4.764599e-01,  4.358549e-01, -6.157706e-02,  5.864360e-01},
  { 1.771054e-01,  3.390726e-01,  9.239390e-01, -2.678393e-01, -7.610441e-02,  5.554702e-01},
  { 1.742445e-01,  1.721549e-01,  9.695368e-01, -2.799334e-01, -6.159537e-02,  5.487390e-01},
  { 5.057905e-01,  4.753452e-01,  7.198771e-01, -2.277708e-01, -7.407521e-02,  5.159504e-01},
  { 5.266069e-01,  3.975526e-01,  7.514233e-01, -2.118830e-01, -7.295348e-02,  5.006024e-01},
  { 9.121555e-01, -2.481801e-02, -4.090922e-01,  2.966418e-01, -6.544082e-02,  4.656081e-01},
  { 4.130330e-01,  2.495402e-01,  8.758615e-01,  4.005823e-01, -7.399219e-02,  4.097758e-01},
  {-9.993019e-01,  3.359247e-02,  1.635311e-02, -9.710485e-02, -6.957623e-02,  2.786911e-01},
  { 3.348388e-02,  5.262473e-01,  8.496720e-01, -2.465670e-01, -7.043153e-02,  2.565525e-01},
  {-5.207830e-01, -2.007387e-01,  8.297524e-01, -1.211577e-01, -6.526456e-02,  2.455366e-01},
  { 1.130766e-01, -2.850607e-01,  9.518162e-01, -1.446144e-01, -7.635271e-02,  2.373148e-01},
  {-4.912301e-01, -8.678946e-01, -7.383610e-02, -3.588990e-01, -7.952124e-02,  2.125140e-01},
  { 6.824527e-01, -4.075914e-01,  6.067352e-01,  5.316372e-01, -5.345417e-02,  1.695705e-01},
  { 9.848530e-01,  1.885266e-02,  1.723631e-01,  5.361195e-01, -5.892886e-02,  1.537532e-01},
  {-2.180998e-01, -3.292401e-01, -9.187129e-01, -2.290023e-01, -7.288373e-02,  1.012858e-01},
  {-1.106463e-01, -3.091622e-01, -9.445508e-01, -2.206402e-01, -6.797690e-02,  9.796108e-02},
  {-7.808559e-01, -6.143903e-01, -1.130874e-01, -5.185661e-01, -6.289187e-02,  1.124213e-01},
  {-6.073707e-01, -3.408190e-01, -7.175955e-01, -5.188363e-01, -5.459781e-02,  1.098556e-01},
  { 9.349492e-01,  1.285110e-01, -3.306886e-01,  5.366716e-01, -6.683725e-02,  9.374679e-02},
  { 3.095407e-01,  2.842374e-01, -9.074104e-01,  4.971576e-01, -7.773287e-02,  5.275175e-02},
  { 8.247699e-01, -3.440359e-01,  4.487693e-01,  4.057309e-01, -6.886247e-02,  8.961993e-03},
  {-9.700153e-01, -2.294732e-01, -8.007605e-02, -1.334128e-02, -7.313418e-02, -1.334624e-02},
  { 8.431368e-01, -5.327570e-01, -7.273499e-02,  4.129933e-01, -6.644487e-02, -3.789810e-02},
  { 3.781447e-02, -1.493336e-01,  9.880635e-01, -4.272854e-01, -6.070796e-02, -1.086563e-01},
  { 4.696328e-01,  6.224129e-01,  6.261368e-01, -1.309125e-01, -7.875345e-02, -1.492704e-01},
  {-3.370050e-02,  4.225614e-01,  9.057076e-01, -1.568032e-01, -7.633606e-02, -1.467420e-01},
  {-1.206099e-01,  3.685257e-01,  9.217603e-01, -1.644387e-01, -6.487545e-02, -1.556363e-01},
  {-9.439615e-01,  2.448978e-01,  2.212729e-01, -5.748821e-01, -8.874768e-02, -1.580202e-01},
  {-9.233998e-01,  3.700058e-01,  1.021196e-01, -5.702552e-01, -7.178875e-02, -1.825538e-01},
  {-2.283021e-01, -1.667544e-01,  9.592034e-01, -2.529843e-01, -6.715408e-02, -2.036095e-01},
  {-2.384578e-01, -5.733764e-01, -7.838222e-01, -5.189506e-01, -7.395670e-02, -2.212965e-01},
  {-6.778372e-01, -2.651033e-01, -6.857529e-01, -5.516464e-01, -6.519710e-02, -2.126305e-01},
  { 8.075790e-01,  5.858820e-01,  6.751572e-02, -1.403309e-01, -6.980099e-02, -2.423640e-01},
  {-6.666667e-01, -3.333333e-01, -6.666667e-01,  4.419790e-01, -6.520396e-02, -2.811122e-01},
  {-3.199427e-01,  2.067344e-01, -9.246067e-01, -2.761381e-01, -7.200950e-02, -3.075390e-01},
  {-3.552034e-01, -4.661195e-02, -9.336262e-01, -2.825056e-01, -6.139221e-02, -3.039717e-01},
  {-7.252189e-01, -1.519336e-01, -6.715457e-01, -2.364672e-01, -7.594652e-02, -3.259306e-01},
  {-9.045789e-01, -2.036362e-01, -3.745254e-01, -2.054491e-01, -6.800441e-02, -3.775621e-01},
  {-4.424472e-01,  8.066748e-01,  3.918114e-01, -4.808794e-01, -8.162092e-02, -4.375986e-01},
  { 4.514178e-01,  4.848132e-01,  7.491183e-01,  1.766374e-01, -7.793234e-02, -5.461183e-01},
  {-4.336644e-01, -6.385437e-01, -6.357650e-01, -3.285156e-01, -7.738221e-02, -5.455402e-01},
  {-3.462374e-01, -5.790783e-01, -7.380975e-01, -3.981717e-01, -5.754451e-02, -5.350658e-01},
  { 4.848002e-01,  2.674459e-01,  8.327314e-01, -7.798207e-02, -5.943196e-02, -5.304878e-01},
  { 4.519915e-01, -7.843013e-02, -8.885676e-01, -4.473936e-02, -8.112326e-02, -5.856299e-01},
  { 9.865789e-01, -1.337700e-01,  9.363534e-02,  2.014589e-01, -6.700714e-02, -6.005121e-01},
  {-8.951026e-01, -1.076448e-02, -4.457304e-01, -2.795433e-01, -6.731097e-02, -6.367723e-01},
  {-3.516764e-01, -2.218381e-01, -9.094567e-01, -4.983873e-02, -6.951596e-02, -7.131289e-01},
  { 7.286659e-01,  6.070614e-01, -3.170527e-01, -1.045396e-02, -7.444127e-02, -7.134189e-01},
  {-7.951360e-01,  3.826668e-01, -4.704518e-01, -3.305504e-01, -8.279874e-02, -7.576640e-01},
  {-5.145542e-01,  3.946935e-01,  7.612169e-01,  3.109884e-01, -6.638400e-02,  8.476907e-01},
  { 8.485287e-01, -1.993483e-02,  5.287737e-01,  3.473022e-01, -4.307539e-02,  7.927527e-01},
  {-5.710868e-01, -7.726129e-01,  2.773611e-01,  1.144610e-01, -4.459513e-02,  7.977203e-01},
  {-6.966380e-01, -1.251479e-01,  7.064230e-01,  2.665477e-01, -4.935816e-02,  7.638152e-01},
  { 9.678148e-01, -1.817869e-01,  1.740350e-01,  3.467782e-01, -5.565092e-02,  6.849706e-01},
  {-6.599233e-01,  5.619133e-02,  7.492288e-01, -1.431298e-01, -6.250887e-02,  6.886860e-01},
  { 9.100161e-01, -3.067845e-01,  2.788442e-01,  3.514956e-01, -5.068437e-02,  6.632177e-01},
  {-8.309873e-01,  5.551813e-01, -3.512758e-02, -1.539755e-01, -6.106080e-02,  6.561220e-01},
  { 7.677277e-01, -1.963354e-01,  6.099561e-01,  3.627829e-01, -4.813882e-02,  6.471377e-01},
  { 8.218862e-01, -1.303430e-01, -5.545393e-01,  4.294502e-01, -5.173151e-02,  5.728641e-01},
  {-2.815070e-01,  9.278228e-01,  2.447421e-01, -1.047742e-01, -5.567760e-02,  5.692226e-01},
  { 6.529970e-02,  7.603080e-01,  6.462721e-01, -6.473882e-02, -4.554784e-02,  4.197868e-01},
  {-1.284990e-01, -9.857949e-01, -1.081503e-01, -4.132532e-01, -5.808593e-02,  3.812678e-01},
  {-2.291725e-01, -9.576925e-01, -1.740836e-01, -4.085418e-01, -5.824460e-02,  3.771162e-01},
  { 2.034513e-01,  8.938476e-01,  3.995547e-01, -4.224025e-01, -5.687634e-02,  3.811131e-01},
  { 5.899013e-01,  6.654950e-01,  4.573104e-01, -3.616327e-01, -6.165182e-02,  3.308236e-01},
  {-1.085642e-01,  9.934888e-01, -3.455291e-02, -4.679670e-01, -4.785106e-02,  3.178999e-01},
  {-5.256169e-01, -8.503301e-01, -2.579739e-02, -4.821650e-01, -5.117976e-02,  2.668002e-01},
  { 9.984623e-01,  5.282469e-02, -1.680814e-02,  5.416431e-01, -5.284083e-02,  1.167619e-01},
  {-6.477119e-01, -4.618724e-01, -6.059234e-01, -5.273359e-01, -3.581425e-02,  1.061781e-01},
  {-1.964535e-01,  3.827024e-01, -9.027429e-01,  4.719017e-01, -5.807417e-02,  6.313700e-02},
  { 3.636661e-01, -2.628888e-01,  8.936647e-01,  3.683006e-01, -5.290842e-02,  4.473673e-02},
  { 8.640514e-01, -1.552690e-01,  4.788599e-01,  4.056899e-01, -4.107790e-02,  2.372583e-02},
  { 4.782633e-02,  6.381290e-02,  9.968151e-01, -4.011177e-01, -5.257130e-02, -1.097471e-01},
  { 7.756662e-02,  4.089561e-01,  9.092516e-01, -4.741020e-01, -4.763729e-02, -1.102531e-01},
  { 5.671092e-01,  4.671679e-01,  6.783372e-01, -1.443274e-01, -5.125529e-02, -1.640668e-01},
  {-2.883393e-01,  9.967927e-02,  9.523258e-01, -1.755407e-01, -4.243179e-02, -1.599395e-01},
  { 8.742225e-01,  4.755559e-01,  9.788532e-02, -1.433866e-01, -4.803148e-02, -1.763828e-01},
  {-4.074784e-01,  4.662383e-02, -9.120238e-01, -4.652863e-01, -5.661367e-02, -2.384935e-01},
  {-4.389474e-01,  2.385709e-03, -8.985096e-01, -5.399305e-01, -5.353417e-02, -2.264647e-01},
  {-7.391326e-01, -2.163423e-01, -6.378707e-01, -4.453574e-01, -6.029384e-02, -2.536849e-01},
  { 8.404705e-01, -3.141562e-01,  4.414920e-01,  4.408297e-01, -5.423636e-02, -2.756911e-01},
  { 9.254442e-01, -3.272155e-01,  1.910052e-01,  4.418404e-01, -4.585114e-02, -2.801161e-01},
  {-3.469321e-01,  6.226405e-01,  7.013963e-01, -5.810570e-02, -5.360116e-02, -2.788825e-01},
  {-6.578864e-01, -2.332020e-01, -7.161021e-01, -4.422401e-01, -5.852564e-02, -2.595860e-01},
  { 8.250200e-01,  4.821946e-02,  5.630424e-01,  4.460770e-01, -5.037088e-02, -2.926302e-01},
  { 9.924262e-01,  5.588940e-02,  1.093923e-01,  5.310583e-01, -5.486010e-02, -3.552031e-01},
  {-5.746247e-01,  6.113806e-01,  5.440774e-01, -4.374371e-01, -5.927109e-02, -4.435810e-01},
  { 9.206123e-01, -8.702272e-02,  3.806573e-01, -8.998720e-02, -4.820259e-02, -5.177121e-01},
  { 7.657846e-01,  1.785679e-01, -6.178086e-01,  5.172153e-01, -4.556957e-02, -5.553058e-01},
  { 7.424769e-01, -5.099320e-01, -4.343930e-01,  1.972529e-01, -5.512812e-02, -6.183059e-01},
  { 9.637415e-01,  1.903672e-01,  1.869828e-01, -4.869337e-02, -4.081013e-02, -6.685718e-01},
  { 8.445542e-01,  3.208083e-01, -4.287310e-01, -2.824380e-02, -4.597838e-02, -7.097252e-01},
  {-6.704122e-01,  4.266901e-01,  6.070281e-01, -3.131658e-01, -5.009551e-02, -7.404046e-01},
  {-1.168499e-01, -6.021805e-01,  7.897625e-01,  1.232668e-01, -3.307761e-02,  8.151427e-01},
  { 6.637430e-01, -7.448546e-01,  6.809463e-02,  4.475718e-01, -2.311491e-02,  7.828895e-01},
  { 2.575196e-02, -9.601048e-01,  2.784519e-01,  4.225770e-01, -2.353473e-02,  7.770323e-01},
  { 8.069835e-01, -5.075223e-01,  3.019915e-01,  3.656788e-01, -3.422147e-02,  7.775070e-01},
  { 8.663951e-01, -4.176874e-01, -2.736729e-01,  4.434531e-01, -1.869052e-02,  7.747645e-01},
  { 0.000000e+00, -4.472136e-01, -8.944272e-01, -8.388162e-02, -4.906778e-02,  7.461543e-01},
  {-3.190520e-01,  6.737143e-01,  6.665695e-01, -8.623152e-02, -4.895356e-02,  7.442008e-01},
  { 5.006748e-01,  8.524754e-01,  1.503674e-01, -7.242282e-02, -4.884591e-02,  7.267292e-01},
  {-6.287601e-01,  6.154620e-01,  4.752550e-01, -1.034294e-01, -4.477284e-02,  7.159031e-01},
  {-3.238926e-01,  9.395544e-01,  1.110457e-01, -1.323640e-01, -4.260590e-02,  6.908649e-01},
  {-6.335190e-01,  7.131288e-01, -3.001683e-01, -1.347248e-01, -5.280318e-02,  6.249319e-01},
  {-4.629949e-01, -1.737729e-01,  8.691598e-01,  1.135915e-01, -4.212938e-02,  5.774365e-01},
  {-7.363213e-01, -1.592778e-01,  6.576181e-01,  1.039931e-01, -3.976553e-02,  5.725455e-01},
  {-6.660797e-01,  6.240348e-01,  4.085567e-01,  6.917732e-02, -3.175743e-02,  5.396752e-01},
  {-3.751050e-01,  6.812801e-01,  6.286124e-01,  2.580695e-02, -2.885299e-02,  4.305725e-01},
  { 3.758364e-01,  3.453094e-01,  8.599468e-01, -1.225334e-01, -2.327663e-02,  4.233326e-01},
  {-2.477517e-01,  6.616416e-01,  7.077072e-01, -2.720428e-02, -3.087027e-02,  4.111833e-01},
  { 3.092931e-01,  1.213054e-01,  9.431981e-01, -8.817656e-02, -2.923722e-02,  4.097474e-01},
  { 6.721829e-01, -1.570872e-01,  7.235287e-01,  4.313972e-01, -3.568340e-02,  3.851258e-01},
  { 6.501765e-02,  1.428070e-01,  9.876127e-01, -6.807774e-02, -2.085176e-02,  4.052824e-01},
  {-4.599695e-01,  6.432992e-01,  6.120410e-01, -4.457284e-01, -4.451440e-02,  3.439645e-01},
  {-4.599695e-01,  6.432992e-01,  6.120410e-01, -4.599400e-01, -4.766566e-02,  3.365962e-01},
  {-7.626126e-01, -4.011309e-01,  5.074604e-01, -9.786049e-02, -4.293795e-02,  2.704561e-01},
  { 8.139918e-01, -1.647364e-01,  5.570272e-01,  4.284201e-01, -3.726732e-02,  2.152407e-01},
  { 6.260602e-01, -3.781054e-01,  6.819714e-01,  4.351996e-01, -4.293107e-02,  2.070670e-01},
  {-1.906385e-01,  3.820136e-01, -9.042802e-01,  2.985933e-01, -2.421512e-02,  1.785856e-01},
  {-2.753823e-01, -9.609199e-01,  2.824132e-02, -4.380873e-01, -4.416662e-02,  1.866497e-01},
  {-4.663171e-01, -8.016400e-01,  3.740612e-01, -4.513002e-01, -4.536789e-02,  1.718465e-01},
  {-9.337888e-01, -3.447849e-01,  9.571745e-02, -5.302183e-01, -3.138082e-02,  1.238122e-01},
  { 8.603830e-01,  2.869135e-01, -4.212144e-01,  5.335271e-01, -3.176843e-02,  1.023772e-01},
  {-6.771565e-02, -4.182327e-01, -9.058123e-01, -3.754029e-01, -3.299404e-02,  1.034700e-01},
  {-7.474411e-01, -3.308237e-01, -5.760968e-01, -5.328946e-01, -2.928986e-02,  1.065930e-01},
  {-8.411919e-01,  1.559606e-02, -5.405117e-01, -1.993512e-02, -2.202797e-02,  3.439905e-02},
  { 8.064500e-01, -5.828999e-01, -9.932818e-02,  4.025800e-01, -5.091304e-02, -9.588262e-02},
  { 5.963081e-03,  6.664763e-01,  7.455023e-01, -4.394399e-01, -3.845282e-02, -1.167560e-01},
  {-4.448619e-01, -2.162189e-01,  8.691072e-01, -2.041413e-01, -3.719079e-02, -1.838740e-01},
  {-6.562840e-01,  4.855002e-01, -5.775645e-01, -5.505978e-01, -4.783031e-02, -2.128647e-01},
  {-3.623659e-01, -4.102362e-02, -9.311327e-01, -3.283580e-01, -2.975795e-02, -2.862130e-01},
  { 5.696544e-01,  6.504726e-01,  5.023737e-01, -1.673768e-01, -2.978861e-02, -2.881975e-01},
  {-8.176466e-03,  5.739959e-01,  8.188173e-01, -1.048168e-01, -2.957409e-02, -3.151036e-01},
  {-6.407428e-01, -3.784521e-01, -6.679989e-01, -2.687959e-01, -3.329576e-02, -3.170282e-01},
  {-6.403213e-01,  4.790590e-01,  6.004092e-01, -2.151225e-01, -2.468214e-02, -4.505235e-01},
  { 5.660462e-01,  1.641216e-01,  8.078712e-01,  1.939619e-01, -2.717063e-02, -5.881605e-01},
  { 9.062451e-01, -2.120494e-01,  3.657252e-01,  2.124921e-01, -2.449044e-02, -6.026760e-01},
  { 2.137811e-01, -4.058270e-01, -8.885955e-01, -1.457938e-01, -2.933067e-02, -6.115749e-01},
  {-5.580472e-01, -1.595144e-01, -8.143332e-01, -3.228243e-01, -3.936753e-02, -5.970340e-01},
  {-8.953785e-01,  7.135254e-02, -4.395523e-01, -3.045990e-01, -2.686131e-02, -7.560475e-01},
  {-7.795874e-01,  1.245495e-01,  6.137841e-01,  1.077799e-01, -1.427609e-02,  8.161348e-01},
  { 5.098487e-01, -7.663799e-01,  3.907894e-01,  8.948230e-02, -1.858854e-02,  7.917477e-01},
  {-3.103838e-01, -8.426138e-01,  4.400726e-01,  8.892307e-02, -2.173162e-02,  7.863134e-01},
  {-5.526986e-01, -3.452791e-01,  7.584897e-01,  9.188298e-02, -1.514799e-02,  7.953629e-01},
  {-9.095700e-01, -3.636510e-01,  2.010980e-01,  7.635369e-02, -7.309709e-03,  7.697878e-01},
  { 6.820069e-01, -4.575186e-01,  5.705639e-01,  1.836551e-01, -9.714682e-03,  7.583188e-01},
  { 1.259446e-01, -4.658110e-01,  8.758756e-01,  2.129014e-01, -5.744958e-03,  7.401995e-01},
  { 6.446187e-01, -7.612709e-01,  7.023694e-02,  3.741673e-01, -1.828975e-02,  6.710930e-01},
  { 5.724155e-02, -1.561692e-01,  9.860703e-01, -2.787618e-01, -9.451687e-04,  5.571008e-01},
  { 5.752653e-01,  1.150098e-01, -8.098411e-01,  4.022407e-01, -1.952512e-02,  5.518296e-01},
  {-8.276996e-01,  5.611476e-01, -5.172406e-03,  8.953441e-02, -5.335850e-03,  4.823282e-01},
  {-6.160919e-01,  7.768125e-01,  1.303580e-01,  8.806552e-02, -8.303325e-03,  4.633506e-01},
  {-3.550407e-01,  3.475864e-01,  8.678305e-01,  2.938243e-02, -6.584746e-03,  4.177899e-01},
  { 7.873847e-02,  1.366470e-02,  9.968017e-01,  3.534385e-01, -1.243569e-02,  3.905071e-01},
  { 9.330454e-01,  2.329125e-01, -2.741862e-01,  4.246846e-01, -2.312200e-02,  2.692885e-01},
  { 9.590277e-01,  1.646132e-01, -2.305826e-01,  5.347822e-01, -1.426487e-02,  1.136291e-01},
  {-9.654717e-01,  3.954125e-02, -2.574892e-01, -5.358998e-01, -1.295408e-02,  1.070024e-01},
  {-3.890031e-01, -1.318146e-01, -9.117573e-01, -5.353911e-02, -1.574416e-02,  6.693523e-02},
  {-9.691691e-01, -6.609356e-02,  2.373668e-01, -3.773215e-02, -1.420584e-02, -4.569248e-02},
  { 5.914560e-01, -8.045058e-01,  5.431572e-02,  4.297867e-01, -2.762345e-02, -9.684560e-02},
  {-2.064494e-01,  1.644601e-01,  9.645370e-01, -4.911122e-01, -2.571520e-02, -1.123242e-01},
  { 4.958896e-01, -2.537864e-01,  8.304734e-01, -3.472624e-01, -1.524810e-02, -1.214322e-01},
  {-1.782050e-01, -2.198724e-01,  9.591137e-01, -1.972987e-01, -7.914380e-03, -1.623305e-01},
  { 7.854350e-01, -6.159536e-01, -6.076973e-02,  4.886052e-01, -9.155327e-03, -1.686544e-01},
  { 9.122363e-01, -3.699886e-01,  1.758784e-01,  4.919672e-01, -2.415041e-03, -1.664342e-01},
  {-7.915813e-01,  6.030819e-01, -9.844416e-02, -3.633751e-01, -5.341608e-03, -1.691826e-01},
  {-2.226847e-01,  9.366427e-01,  2.703921e-01, -3.700899e-01, -7.287494e-03, -1.836883e-01},
  { 8.031200e-01, -5.733085e-01, -1.622209e-01,  4.723685e-01, -1.154161e-02, -2.116202e-01},
  { 3.623584e-01,  4.518500e-01,  8.151858e-01, -1.424315e-01, -1.623677e-02, -3.148389e-01},
  {-5.264517e-01, -4.462249e-01, -7.236933e-01, -2.728851e-01, -2.549921e-02, -3.189039e-01},
  { 3.654750e-01, -2.757457e-01, -8.890401e-01, -1.949794e-02, -2.410619e-02, -4.288466e-01},
  {-8.349622e-01,  4.547850e-01, -3.098528e-01, -4.209149e-01, -2.091059e-02, -4.649665e-01},
  {-1.910178e-01,  5.153401e-01,  8.354262e-01, -2.619714e-01, -1.692486e-02, -4.806319e-01},
  { 7.298610e-01,  2.712646e-02,  6.830572e-01, -7.947171e-02, -1.982717e-02, -5.318121e-01},
  {-2.947215e-01, -2.775525e-01, -9.143872e-01, -3.968042e-01, -2.120315e-02, -5.767081e-01},
  { 4.796648e-01,  1.897493e-01,  8.566895e-01,  2.109466e-01, -9.064213e-03, -5.989559e-01},
  {-4.978929e-01, -6.195156e-03, -8.672163e-01, -3.712941e-01, -1.241830e-02, -5.856120e-01},
  { 1.380946e-01, -5.514028e-01, -8.227301e-01,  1.763674e-01, -1.841220e-02, -6.596549e-01},
  {-8.971894e-01, -4.367933e-01, -6.529053e-02, -3.095165e-01, -8.281973e-03, -7.468108e-01},
  { 4.061286e-01, -3.637950e-01, -8.382795e-01, -4.615859e-02, -8.144392e-03, -7.454189e-01},
  { 2.679659e-02,  1.851667e-02, -9.994693e-01, -2.643674e-01, -8.844251e-03, -7.666507e-01},
  {-3.514522e-01, -1.616582e-01, -9.221432e-01, -2.953952e-01, -6.786825e-03, -7.646273e-01},
  { 2.114707e-02, -4.992574e-01,  8.661957e-01,  1.423389e-01,  9.858796e-03,  8.389232e-01},
  {-7.285442e-01,  9.029498e-02,  6.790214e-01,  1.215545e-01,  3.917999e-03,  8.295225e-01},
  { 9.941891e-01, -1.062372e-01, -1.737235e-02,  4.440560e-01,  1.527336e-02,  7.550339e-01},
  { 5.268351e-01, -8.438188e-01,  1.020507e-01,  3.838958e-01, -9.706792e-03,  6.643577e-01},
  {-6.818599e-01, -7.197260e-01,  1.306196e-01,  1.100083e-01, -4.306477e-03,  6.387268e-01},
  { 6.829920e-01, -7.062140e-01,  1.865038e-01,  3.985248e-01, -1.087162e-02,  6.285954e-01},
  { 8.819279e-01, -7.598276e-02,  4.652201e-01,  4.385515e-01,  1.235425e-02,  5.973555e-01},
  {-9.623763e-01,  1.080800e-01, -2.493000e-01,  6.971925e-02,  7.768516e-03,  5.642908e-01},
  {-7.795240e-01,  2.953753e-01,  5.523547e-01,  8.839420e-02,  5.372405e-03,  4.486507e-01},
  { 5.205234e-01, -2.437074e-01,  8.183289e-01,  4.454088e-01,  1.617942e-02,  3.965794e-01},
  { 9.256207e-01,  7.779629e-02, -3.703703e-01,  4.482487e-01,  7.955060e-03,  3.085879e-01},
  {-5.609185e-01, -1.920201e-01,  8.052942e-01, -1.236570e-01, -6.515184e-03,  2.428680e-01},
  { 2.390570e-01,  2.099919e-01, -9.480270e-01,  2.723297e-01,  1.935587e-03,  1.935633e-01},
  { 6.140055e-01,  2.982588e-01, -7.307797e-01,  2.582679e-01,  2.942644e-03,  1.887669e-01},
  { 3.302769e-01,  4.429345e-01, -8.335024e-01,  5.058215e-01, -1.108409e-02,  8.941516e-02},
  {-1.036479e-01, -3.219323e-01, -9.410720e-01, -4.801375e-01, -1.866024e-04,  8.930842e-02},
  { 6.306497e-02, -4.354062e-01, -8.980225e-01, -2.183566e-01,  9.153428e-03,  4.716739e-02},
  {-3.744472e-01, -8.943664e-02,  9.229249e-01, -3.607353e-01,  1.586100e-02, -1.084586e-01},
  {-4.324112e-01,  1.063366e-01,  8.953844e-01, -5.303003e-01, -7.214218e-03, -1.344665e-01},
  {-8.799528e-01,  2.435978e-01,  4.078519e-01, -5.501468e-01, -6.657312e-04, -1.483019e-01},
  { 9.155464e-01, -3.467447e-01,  2.038210e-01,  4.911974e-01,  1.114104e-02, -1.501194e-01},
  {-3.197933e-01,  7.271826e-01, -6.074025e-01, -5.178131e-01,  7.362649e-03, -1.809702e-01},
  {-7.174269e-01,  3.522299e-01, -6.010264e-01, -4.768022e-01,  3.211069e-03, -2.086270e-01},
  {-4.893850e-01, -1.870890e-01, -8.517628e-01, -4.164086e-01,  1.001137e-02, -2.554033e-01},
  {-8.760999e-01, -2.693646e-01, -3.998646e-01, -2.111571e-01, -5.402504e-03, -3.981495e-01},
  {-9.897416e-01,  6.114912e-02,  1.291222e-01, -2.034288e-01,  1.390790e-02, -4.549285e-01},
  {-1.981130e-01,  3.369675e-01,  9.204369e-01, -4.015529e-01,  1.852339e-03, -4.659275e-01},
  { 8.890169e-01, -2.970805e-01, -3.484136e-01, -7.773061e-02,  6.993966e-03, -4.916919e-01},
  {-6.074176e-01,  3.698256e-01,  7.030454e-01, -2.189640e-01,  1.419221e-02, -4.828506e-01},
  {-6.422103e-01, -4.399046e-01, -6.277340e-01, -4.403055e-01, -4.705164e-03, -5.611793e-01},
  { 7.157742e-01,  1.654514e-01,  6.784490e-01,  2.207163e-01,  4.071061e-03, -6.093439e-01},
  {-3.663436e-01,  3.533925e-01, -8.607590e-01, -4.187928e-01, -6.122763e-03, -5.760134e-01},
  { 9.126586e-01, -9.659226e-02, -3.971451e-01, -5.999923e-02,  1.190514e-04, -6.218356e-01},
  {-9.856383e-01,  1.685378e-02, -1.680268e-01, -2.630767e-01,  2.753898e-03, -6.265998e-01},
  { 4.729182e-01, -1.979153e-01, -8.585907e-01, -2.229603e-01,  1.190802e-02, -7.505191e-01},
  { 9.974532e-01, -4.443646e-02,  5.579039e-02, -3.856491e-02,  1.671148e-02, -7.646288e-01},
  {-1.628141e-01, -3.270160e-01,  9.308878e-01,  1.467478e-01,  2.313248e-02,  8.488470e-01},
  { 3.772834e-01, -5.699372e-01,  7.299513e-01,  1.510817e-01,  2.048063e-02,  8.456377e-01},
  {-8.436340e-01,  9.384072e-02,  5.286545e-01,  1.246119e-01,  1.542131e-02,  8.274821e-01},
  { 6.029001e-01, -5.918011e-01,  5.350541e-01,  1.788965e-01,  1.205004e-02,  7.879883e-01},
  {-6.818076e-01,  6.946332e-01,  2.293970e-01,  1.268099e-01,  2.790016e-02,  7.595477e-01},
  {-7.151254e-01,  6.100697e-01,  3.411901e-01,  5.750845e-02,  2.500314e-02,  7.327023e-01},
  {-3.279140e-01,  1.486082e-01,  9.329458e-01,  2.978874e-01,  2.731917e-02,  7.452860e-01},
  {-8.251784e-01, -4.594171e-01,  3.286586e-01,  6.455401e-02,  2.181719e-02,  6.057853e-01},
  { 1.235050e-01,  1.218356e-01,  9.848363e-01, -2.683368e-01,  2.889795e-02,  5.576683e-01},
  {-8.013500e-01, -1.324594e-01,  5.833461e-01, -2.882330e-01,  2.506491e-02,  5.520359e-01},
  { 6.662255e-01,  1.084282e-01,  7.378258e-01, -2.329481e-01,  3.104194e-02,  5.263669e-01},
  { 4.872514e-01, -2.702874e-01,  8.303799e-01,  3.403574e-01,  2.685292e-02,  3.995855e-01},
  {-1.470296e-01,  1.016685e-01,  9.838932e-01,  9.831003e-03,  1.010701e-02,  4.105723e-01},
  {-7.362624e-01, -3.176228e-01, -5.975228e-01, -2.099195e-01,  2.290967e-02,  3.841058e-01},
  { 9.790910e-01, -7.292882e-02,  1.899001e-01,  4.532012e-01,  2.468303e-02,  3.840809e-01},
  { 9.722610e-01, -1.113311e-01, -2.057032e-01,  4.570156e-01,  3.195286e-02,  3.332275e-01},
  {-7.042756e-01, -3.215163e-01, -6.329480e-01, -1.567162e-01,  1.784309e-02,  3.293179e-01},
  {-8.931395e-01, -4.465119e-01,  5.412048e-02, -1.152925e-01,  8.773586e-03,  2.634266e-01},
  { 3.137662e-01,  9.093629e-01,  2.731482e-01, -4.349054e-01,  1.606038e-02,  2.053410e-01},
  {-9.428167e-01,  1.457031e-01,  2.997786e-01, -5.047646e-01,  3.802897e-03,  2.058887e-01},
  { 8.314962e-01, -1.823536e-02, -5.552312e-01,  2.441484e-01,  3.382507e-02,  1.767200e-01},
  {-2.626059e-01,  9.421309e-01,  2.083930e-01, -3.889362e-01,  1.520709e-02,  1.897901e-01},
  {-9.040391e-01,  3.597387e-02,  4.259334e-01, -5.174471e-01,  7.491005e-03,  1.712169e-01},
  {-5.006436e-02,  9.317434e-01,  3.596495e-01, -3.915956e-01,  1.880317e-02,  1.532328e-01},
  {-5.310465e-01,  7.808954e-01,  3.289255e-01, -5.162881e-01,  1.705146e-02,  1.349779e-01},
  { 1.791370e-03,  9.633769e-01,  2.681451e-01, -4.339235e-01,  2.685707e-02,  1.311724e-01},
  {-2.439423e-01,  9.676573e-01,  6.427525e-02, -4.877191e-01,  2.071257e-02, -1.770992e-01},
  {-4.816622e-01,  7.989233e-01, -3.601709e-01, -5.395620e-01,  1.437802e-02, -1.589641e-01},
  { 1.437859e-02,  7.694844e-01,  6.385037e-01, -4.490344e-01,  2.523918e-02, -1.891450e-01},
  {-8.313169e-01,  4.865496e-01, -2.686664e-01, -3.189778e-01,  2.945173e-02, -2.034638e-01},
  {-5.015013e-01,  8.197376e-01,  2.766347e-01, -3.258423e-01,  2.680770e-02, -2.202422e-01},
  {-1.139365e-01,  2.030748e-01,  9.725118e-01, -4.040492e-01,  3.220513e-02, -4.692820e-01},
  {-7.640556e-01, -5.843677e-02,  6.424984e-01, -4.378560e-01,  2.456752e-02, -4.856494e-01},
  { 5.319025e-03,  3.671744e-01,  9.301369e-01, -2.568783e-01,  3.150737e-02, -5.071661e-01},
  {-9.079977e-01,  2.814010e-01, -3.104089e-01, -4.419287e-01,  2.716028e-02, -5.241279e-01},
  { 2.501389e-01,  3.507775e-01,  9.024332e-01,  4.941396e-02,  3.102845e-02, -5.855390e-01},
  {-9.493711e-02, -3.645020e-01, -9.263505e-01,  1.201789e-01,  2.151621e-02, -6.789293e-01},
  {-7.174518e-01, -1.088556e-01, -6.880504e-01, -6.859179e-02,  2.806534e-02, -7.427542e-01},
  {-7.071068e-01,  7.071068e-01,  0.000000e+00,  4.497719e-01,  4.759201e-02,  8.629853e-01},
  {-7.071068e-01,  0.000000e+00,  7.071068e-01,  4.446332e-01,  5.767925e-02,  8.685559e-01},
  {-5.441241e-01,  1.891940e-02,  8.387914e-01,  1.429972e-01,  4.620980e-02,  8.491699e-01},
  { 9.410298e-01,  1.856195e-01,  2.828574e-01,  4.451198e-01,  4.533971e-02,  8.400587e-01},
  {-8.171929e-01,  5.104645e-01, -2.676225e-01,  1.562713e-01,  5.438984e-02,  7.727922e-01},
  {-5.009358e-02,  4.413359e-02,  9.977690e-01,  3.460914e-01,  3.862062e-02,  7.598721e-01},
  {-9.094432e-01,  2.995372e-01,  2.884276e-01,  5.163041e-02,  3.886267e-02,  6.868302e-01},
  { 9.408321e-01, -2.776809e-02, -3.377336e-01,  4.437645e-01,  4.580519e-02,  6.041935e-01},
  {-9.940662e-01,  1.031629e-01, -3.449519e-02,  5.838481e-02,  4.067941e-02,  6.051823e-01},
  { 4.984710e-01,  3.849228e-01, -7.767633e-01,  3.465100e-01,  4.353557e-02,  5.561259e-01},
  {-8.928012e-01,  1.506694e-01,  4.245053e-01,  1.060428e-01,  3.702638e-02,  4.676485e-01},
  {-4.117458e-01, -1.195294e-01,  9.034258e-01,  5.564656e-02,  2.916543e-02,  4.254639e-01},
  { 5.908992e-01, -1.932363e-01,  7.832611e-01,  4.437804e-01,  4.722388e-02,  4.011544e-01},
  {-1.185099e-02, -3.634448e-01,  9.315404e-01, -1.752511e-02,  2.579091e-02,  4.116778e-01},
  { 9.326490e-01, -1.933838e-01,  3.045794e-01,  4.225546e-01,  3.137619e-02,  2.648880e-01},
  {-7.273781e-01, -6.857076e-01,  2.694782e-02, -1.290533e-01,  3.005172e-02,  2.794200e-01},
  {-6.916333e-01, -2.464530e-01,  6.788993e-01, -1.322967e-01,  2.978112e-02,  2.477736e-01},
  {-7.278000e-01, -1.551817e-01,  6.680014e-01, -1.486182e-01,  3.553917e-02,  2.256973e-01},
  { 2.926899e-02,  9.671400e-01,  2.525540e-01, -4.567004e-01,  2.579099e-02,  2.017895e-01},
  {-3.201227e-01,  9.227954e-01,  2.144062e-01, -5.073922e-01,  1.630401e-02,  1.675385e-01},
  { 9.899644e-01, -5.208202e-02,  1.313695e-01,  2.417526e-01,  4.516505e-02,  1.407861e-01},
  {-4.683027e-01,  7.402710e-01,  4.823809e-01, -2.583533e-01,  4.922810e-02,  1.255334e-01},
  {-1.901363e-01,  7.938611e-01,  5.776095e-01, -2.970173e-01,  4.854478e-02,  9.973086e-02},
  { 4.213457e-01,  3.709888e-02,  9.061410e-01,  3.932669e-01,  4.038760e-02,  3.420357e-02},
  { 1.418114e-01, -3.567933e-01, -9.233570e-01, -2.566090e-01,  5.608112e-02,  2.821735e-03},
  { 1.071272e-01,  9.390923e-01,  3.265418e-01, -5.173721e-01,  2.073417e-02, -1.443001e-01},
  {-4.465733e-01,  7.420678e-01,  4.999077e-01, -5.326515e-01,  2.063532e-02, -1.450750e-01},
  { 2.966020e-01,  2.728609e-01,  9.151908e-01, -2.205139e-01,  4.039215e-02, -1.615133e-01},
  {-4.812086e-01,  8.016717e-01,  3.546278e-01, -3.138690e-01,  4.269984e-02, -2.472135e-01},
  { 4.434840e-02,  7.667806e-01,  6.403756e-01, -3.469203e-01,  3.618700e-02, -2.408089e-01},
  {-5.517250e-01, -4.996142e-01, -6.678211e-01, -3.026654e-01,  4.255075e-02, -3.701732e-01},
  {-8.339736e-01,  1.413074e-01,  5.334044e-01, -2.052895e-01,  3.187906e-02, -4.738380e-01},
  {-2.635488e-02, -8.972687e-02,  9.956177e-01, -3.947445e-01,  4.666808e-02, -4.727912e-01},
  {-9.432057e-01,  1.978713e-01, -2.668517e-01, -4.437282e-01,  4.342937e-02, -5.066119e-01},
  { 3.225406e-01, -4.523579e-02,  9.454741e-01, -6.768555e-02,  3.011661e-02, -5.474063e-01},
  { 9.202808e-01, -3.415981e-01,  1.907722e-01, -7.568692e-02,  3.419368e-02, -5.443425e-01},
  {-7.863474e-01,  2.417672e-01, -5.685124e-01,  3.391415e-01,  3.796443e-02, -5.676200e-01},
  { 5.228652e-01,  3.571448e-01, -7.739894e-01,  4.824830e-01,  4.300635e-02, -5.687932e-01},
  { 8.539857e-01, -2.731327e-01,  4.428397e-01,  2.345789e-01,  3.842745e-02, -6.277022e-01},
  {-2.715192e-01, -1.926746e-01,  9.429495e-01,  2.336275e-01,  4.797181e-02, -6.212840e-01},
  { 3.659982e-01, -3.357823e-01, -8.679261e-01, -4.118931e-02,  3.225779e-02, -6.203078e-01},
  { 9.779165e-01, -9.512569e-02, -1.860927e-01, -5.982400e-02,  2.949682e-02, -6.333932e-01},
  {-2.236055e-01, -3.327017e-01, -9.161387e-01, -1.431262e-01,  3.120947e-02, -6.384978e-01},
  {-4.678135e-01, -1.311339e-01, -8.740448e-01, -1.359513e-01,  4.071921e-02, -6.459596e-01},
  {-8.298335e-01, -4.418956e-01,  3.407410e-01, -2.728813e-01,  4.147746e-02, -6.402223e-01},
  {-6.723597e-01, -8.819817e-02, -7.349514e-01, -1.256184e-01,  4.672133e-02, -6.532432e-01},
  {-7.677326e-01, -1.083940e-01, -6.315357e-01, -3.438600e-01,  4.612940e-02, -7.389613e-01},
  { 3.072058e-02, -2.882314e-01, -9.570678e-01, -2.762996e-01,  4.471342e-02, -7.812543e-01},
  { 1.406298e-01, -1.913968e-01,  9.713858e-01,  2.373033e-01,  7.371069e-02,  8.497358e-01},
  {-9.575009e-01,  2.825629e-01,  5.788193e-02,  1.383457e-01,  6.549370e-02,  8.335295e-01},
  {-6.950416e-01,  7.185805e-01, -2.364965e-02,  1.681518e-01,  5.763745e-02,  7.325079e-01},
  { 8.740407e-01,  4.158981e-01,  2.511608e-01,  4.427010e-01,  6.224003e-02,  6.977710e-01},
  {-2.445991e-01,  9.437389e-01,  2.225491e-01,  1.431864e-01,  4.602519e-02,  6.917411e-01},
  {-9.409164e-01,  3.386161e-01, -3.930065e-03,  1.803817e-01,  6.596905e-02,  6.720295e-01},
  {-5.922579e-01,  8.044235e-01,  4.619065e-02,  5.218691e-02,  4.633459e-02,  6.517664e-01},
  { 8.736911e-01, -4.532716e-01,  1.766599e-01,  4.538732e-01,  5.474894e-02,  6.154991e-01},
  {-6.790641e-01,  6.561124e-01, -3.292240e-01,  7.205757e-02,  4.665248e-02,  5.890660e-01},
  {-6.095836e-01,  5.102961e-01, -6.066349e-01,  8.696165e-02,  5.023468e-02,  5.658179e-01},
  {-6.935303e-01, -7.821483e-02,  7.161691e-01, -2.917785e-01,  4.769487e-02,  5.504993e-01},
  {-7.746887e-01, -4.383886e-01, -4.557113e-01, -2.418978e-01,  4.184583e-02,  4.162250e-01},
  {-1.868520e-01, -9.524810e-01,  2.405540e-01, -3.645387e-01,  7.006269e-02,  4.200784e-01},
  {-7.990494e-01,  4.293020e-01,  4.209748e-01, -3.771923e-01,  6.425765e-02,  4.070915e-01},
  {-7.278995e-01, -5.824853e-01,  3.617639e-01, -3.864547e-01,  6.318626e-02,  3.866931e-01},
  { 9.313232e-01, -2.679642e-01,  2.466418e-01,  4.557751e-01,  6.664973e-02,  3.775349e-01},
  { 3.076085e-01, -5.148351e-01,  8.002011e-01,  3.582573e-01,  4.048893e-02,  3.969196e-01},
  { 3.076085e-01, -5.148351e-01,  8.002011e-01, -3.324946e-01,  5.720330e-02,  3.749646e-01},
  {-4.056056e-01, -8.950821e-01, -1.852359e-01, -3.839887e-01,  6.100943e-02,  3.692241e-01},
  { 9.933192e-01, -1.153608e-01,  2.982634e-03,  4.626344e-01,  6.812112e-02,  3.450901e-01},
  { 9.672356e-01, -1.687009e-01, -1.897243e-01,  4.566417e-01,  6.201076e-02,  3.142784e-01},
  { 9.886340e-01, -1.499431e-01, -1.094665e-02,  4.316013e-01,  6.630056e-02,  2.748620e-01},
  { 6.989638e-01, -1.539419e-01,  6.983922e-01,  5.324759e-01,  5.557804e-02,  2.258213e-01},
  { 6.193984e-01, -1.599948e-01,  7.686008e-01,  4.457149e-01,  6.930919e-02,  2.539946e-01},
  {-7.065250e-01,  5.432825e-01,  4.535049e-01, -2.282816e-01,  5.340443e-02,  1.585019e-01},
  {-9.341153e-02,  4.761804e-01, -8.743720e-01,  4.886534e-01,  5.216656e-02,  1.271310e-01},
  {-7.714145e-01,  8.942449e-02,  6.300181e-01, -2.649686e-01,  6.797750e-02,  1.095132e-01},
  {-8.668008e-01,  1.209506e-01, -4.837636e-01, -5.176505e-01,  4.561735e-02,  7.267116e-02},
  {-8.057516e-01,  6.350514e-02, -5.888392e-01, -5.013136e-01,  5.937909e-02,  5.037543e-02},
  { 7.488324e-01, -2.039477e-01,  6.305992e-01,  4.440958e-01,  5.487666e-02, -8.873389e-03},
  {-9.015627e-03, -3.483980e-01, -9.373033e-01, -2.749691e-01,  5.472635e-02,  3.840285e-03},
  { 5.391304e-02,  2.182675e-01,  9.743986e-01, -3.610919e-01,  5.192583e-02, -1.083931e-01},
  {-5.061398e-01,  2.129499e-01,  8.357480e-01, -3.745878e-01,  5.560663e-02, -1.140964e-01},
  {-7.216743e-01, -1.133437e-01, -6.828905e-01, -3.110266e-01,  5.997602e-02, -2.074842e-01},
  { 8.049058e-02,  7.073315e-01,  7.022843e-01, -4.314591e-01,  4.377618e-02, -2.106000e-01},
  {-4.571255e-01,  6.687254e-01,  5.863808e-01, -4.407649e-01,  4.657759e-02, -2.102054e-01},
  { 6.446192e-02,  7.982805e-01,  5.988263e-01, -4.349594e-01,  5.236077e-02, -2.187288e-01},
  {-9.336818e-01,  2.671816e-01, -2.384369e-01, -2.982205e-01,  6.464275e-02, -2.294740e-01},
  {-5.641566e-01,  7.584012e-01,  3.264274e-01, -2.996315e-01,  5.744787e-02, -2.578959e-01},
  { 5.143316e-01, -4.692307e-01, -7.178340e-01,  1.359652e-02,  5.194504e-02, -4.479590e-01},
  { 6.604232e-01, -4.265918e-01, -6.179489e-01, -4.277517e-02,  5.119640e-02, -4.742038e-01},
  {-7.244681e-01, -3.301733e-01,  6.050880e-01, -4.468271e-01,  6.566426e-02, -4.675736e-01},
  {-5.203122e-01,  2.985940e-01,  8.000731e-01, -2.282712e-01,  5.940483e-02, -5.110446e-01},
  { 8.991322e-01,  3.065231e-01, -3.124178e-01,  5.015666e-01,  4.696310e-02, -5.397415e-01},
  {-7.346633e-01, -1.712255e-01, -6.564690e-01, -2.771163e-01,  4.945906e-02, -6.159341e-01},
  { 7.320156e-01, -4.173273e-01, -5.385082e-01, -1.742584e-01,  5.431508e-02, -6.665733e-01},
  { 8.900716e-02, -3.564309e-01, -9.300724e-01,  1.672548e-01,  6.372427e-02, -6.983851e-01},
  {-6.815272e-01, -5.095621e-01,  5.252305e-01, -3.534031e-01,  6.049171e-02, -7.210528e-01},
  {-8.647932e-01, -5.011303e-01, -3.163755e-02, -3.665841e-01,  6.921859e-02, -7.311882e-01},
  { 8.123956e-01, -5.376902e-02, -5.806223e-01, -4.887657e-02,  6.638669e-02, -7.544487e-01},
  {-6.769490e-01,  2.722315e-01, -6.838349e-01, -3.130630e-01,  5.713815e-02, -7.790625e-01},
  { 2.090125e-01, -1.343809e-01,  9.686359e-01,  4.129196e-01,  7.578897e-02,  8.708559e-01},
  { 4.202223e-01, -7.493080e-01,  5.118112e-01,  2.573603e-01,  8.028658e-02,  8.519306e-01},
  { 1.308416e-01,  1.118864e-01,  9.850695e-01,  1.753337e-01,  7.486703e-02,  8.525118e-01},
  {-4.979042e-01,  2.729529e-01,  8.231573e-01,  1.498826e-01,  6.621698e-02,  8.521500e-01},
  {-9.988606e-01,  3.031735e-02, -3.685536e-02,  1.388407e-01,  7.363116e-02,  8.229623e-01},
  {-9.464999e-01, -4.250250e-02, -3.198930e-01,  1.607365e-01,  8.428989e-02,  7.778843e-01},
  {-3.294581e-01, -6.491529e-01,  6.856077e-01,  3.341979e-01,  5.940247e-02,  7.618375e-01},
  { 1.068325e-01, -7.247344e-01,  6.806959e-01,  3.087174e-01,  6.470723e-02,  7.616802e-01},
  { 8.519539e-01,  3.272248e-01, -4.087768e-01,  4.566880e-01,  7.834639e-02,  6.349469e-01},
  { 4.901859e-01,  5.046847e-01, -7.106413e-01,  4.372016e-01,  7.984177e-02,  6.162891e-01},
  { 7.687918e-02,  3.740252e-01,  9.242265e-01, -2.840557e-01,  6.298368e-02,  5.481490e-01},
  {-6.656734e-01,  7.049237e-01,  2.448702e-01,  1.505371e-01,  8.457219e-02,  5.514790e-01},
  {-8.155870e-01, -3.055888e-01,  4.913586e-01, -3.113785e-01,  6.962423e-02,  5.297492e-01},
  {-6.874103e-01, -7.262484e-01, -5.514457e-03, -2.934809e-01,  6.310397e-02,  4.671679e-01},
  {-8.707470e-01, -1.396403e-01,  4.714872e-01, -3.557574e-01,  8.315689e-02,  4.628371e-01},
  {-1.510003e-02, -7.211062e-01,  6.926601e-01, -3.665195e-02,  7.869627e-02,  4.588039e-01},
  {-3.522398e-01, -2.897582e-01,  8.899254e-01,  7.864394e-02,  6.835499e-02,  4.442420e-01},
  { 7.818137e-01, -2.531685e-01,  5.698009e-01,  4.379629e-01,  8.099734e-02,  4.200610e-01},
  {-3.176919e-01, -8.570006e-01, -4.057360e-01, -2.627147e-01,  6.050899e-02,  4.119097e-01},
  {-3.176919e-01, -8.570006e-01, -4.057360e-01, -3.124394e-01,  6.898977e-02,  4.102186e-01},
  {-7.244561e-01,  5.966512e-01,  3.452111e-01, -3.859996e-01,  8.329970e-02,  3.709558e-01},
  {-8.244442e-01,  1.194479e-01,  5.531943e-01, -3.976961e-01,  7.386524e-02,  3.608129e-01},
  {-9.523853e-02, -8.056995e-01, -5.846179e-01, -3.824509e-01,  6.965713e-02,  3.426493e-01},
  { 7.132658e-02,  1.654440e-01, -9.836365e-01,  2.846741e-01,  7.644592e-02,  2.079902e-01},
  { 7.180973e-01,  2.076982e-01, -6.642271e-01,  5.306688e-01,  7.979390e-02,  1.468070e-01},
  {-5.894688e-01,  3.265894e-01,  7.388273e-01, -2.835866e-01,  7.726479e-02,  8.643952e-02},
  { 6.213624e-01, -7.191465e-02,  7.802161e-01,  4.437225e-01,  7.716750e-02,  2.074631e-03},
  { 4.947596e-01,  1.072083e-01,  8.623916e-01,  4.352100e-01,  8.403531e-02,  5.429171e-03},
  { 8.128764e-02, -3.416815e-01, -9.362938e-01, -4.827524e-01,  8.426037e-02,  3.174066e-02},
  { 1.639428e-01,  2.956852e-01,  9.411127e-01, -3.460851e-01,  8.118256e-02, -1.242762e-01},
  { 3.343017e-01,  9.888592e-02,  9.372641e-01, -2.453329e-01,  6.820074e-02, -1.621015e-01},
  { 9.988876e-01, -2.584316e-02, -3.944220e-02,  4.938441e-01,  7.486488e-02, -2.438774e-01},
  {-8.998362e-01,  3.644474e-01, -2.397349e-01, -2.830093e-01,  8.989006e-02, -2.783893e-01},
  {-8.011517e-02,  5.953049e-01,  7.994958e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  {-5.603940e-01, -7.203575e-01, -4.087097e-01, -4.256536e-01,  7.281120e-02, -2.971773e-01},
  { 2.894397e-01,  6.248294e-01,  7.251295e-01, -3.118535e-01,  8.395584e-02, -3.123391e-01},
  {-7.398068e-01, -3.765071e-01, -5.576093e-01, -4.131292e-01,  8.244140e-02, -3.250809e-01},
  {-6.530346e-02,  9.908454e-01, -1.181562e-01, -2.521654e-01,  8.792878e-02, -3.293268e-01},
  {-3.452591e-01, -5.226323e-01, -7.795202e-01, -3.615861e-01,  8.349308e-02, -3.648942e-01},
  { 7.115073e-01, -5.343440e-01, -4.563265e-01, -4.160109e-02,  7.167282e-02, -4.887314e-01},
  { 7.832640e-01, -6.063785e-01, -1.371226e-01, -5.368406e-02,  7.238816e-02, -5.220682e-01},
  {-7.556515e-01,  3.606812e-02,  6.539801e-01, -2.256102e-01,  8.366416e-02, -5.142679e-01},
  {-4.649783e-01,  6.099193e-01, -6.417115e-01, -4.039125e-01,  8.124824e-02, -5.149164e-01},
  {-1.998194e-01,  1.891215e-01, -9.614080e-01,  3.828141e-01,  7.641745e-02, -5.770596e-01},
  {-5.241061e-02,  3.993660e-01,  9.152923e-01,  2.396227e-01,  6.375681e-02, -6.236317e-01},
  { 1.466708e-01,  1.001715e-01,  9.841002e-01,  1.223006e-01,  9.460822e-02, -6.438109e-01},
  {-2.020781e-01, -5.395470e-01, -8.173454e-01, -1.355483e-01,  6.364491e-02, -6.552105e-01},
  { 1.250600e-01, -5.916864e-01, -7.964090e-01, -1.497886e-01,  6.251413e-02, -6.560026e-01},
  {-5.141388e-01, -4.850323e-01, -7.073929e-01, -1.160593e-01,  7.603619e-02, -6.746960e-01},
  {-7.587115e-01,  2.113366e-01, -6.161929e-01, -3.702302e-01,  8.952221e-02, -7.191812e-01},
  {-3.773893e-01,  9.214610e-01, -9.212455e-02, -2.905237e-01,  8.009139e-02, -7.395110e-01},
  {-4.582227e-01,  7.156206e-01, -5.271804e-01, -3.042806e-01,  7.570812e-02, -7.499935e-01},
  {-1.421645e-01, -6.189598e-02,  9.879059e-01,  2.821145e-01,  1.018936e-01,  8.419913e-01},
  { 8.355045e-01,  5.491991e-01, -1.767701e-02,  3.825777e-01,  9.969617e-02,  7.224964e-01},
  { 8.497145e-01,  3.340206e-01,  4.079407e-01,  4.514215e-01,  9.049514e-02,  6.605551e-01},
  { 9.925661e-01,  6.409141e-02,  1.034650e-01,  3.209208e-01,  1.037852e-01,  5.559122e-01},
  {-5.024301e-01,  3.655045e-01,  7.835627e-01, -3.161069e-01,  9.300967e-02,  5.273540e-01},
  {-9.073981e-01, -2.871288e-01,  3.068969e-01, -3.389706e-01,  8.744540e-02,  4.850352e-01},
  {-8.449435e-01, -1.254975e-01,  5.199239e-01, -3.316459e-01,  9.420884e-02,  5.043541e-01},
  { 4.369187e-01,  2.867604e-01,  8.525670e-01, -1.996792e-01,  8.699489e-02,  4.758974e-01},
  { 5.884362e-01, -1.841932e-01,  7.872837e-01,  4.396965e-01,  9.283989e-02,  4.275053e-01},
  { 2.562319e-01, -2.646451e-01,  9.296818e-01,  4.129488e-01,  9.464157e-02,  4.303869e-01},
  {-6.841413e-01, -6.654556e-01, -2.985287e-01, -4.172950e-01,  1.056115e-01,  3.217726e-01},
  { 8.764205e-01, -2.755262e-02,  4.807577e-01,  5.315480e-01,  1.009520e-01,  2.247397e-01},
  {-9.430409e-02,  1.114659e-01, -9.892836e-01,  3.253120e-01,  1.014810e-01,  2.080958e-01},
  {-1.276222e-01,  1.842690e-01, -9.745551e-01,  5.224206e-01,  9.619969e-02,  1.449969e-01},
  {-9.292277e-01, -5.406609e-02,  3.655308e-01, -2.805228e-01,  1.013577e-01,  8.621927e-02},
  {-1.859764e-01,  6.174539e-01,  7.643059e-01, -3.554320e-01,  9.737584e-02,  5.367006e-02},
  {-1.833576e-01,  1.202994e-01, -9.756578e-01, -4.860394e-02,  1.014722e-01,  4.839590e-02},
  {-9.017056e-01, -2.154913e-02,  4.318133e-01, -3.870381e-01,  8.756030e-02, -1.325969e-01},
  {-9.753364e-01,  2.167524e-01,  4.167937e-02, -5.477341e-02,  9.710319e-02, -1.409552e-01},
  { 6.872317e-01,  5.647138e-01,  4.569584e-01, -2.535422e-01,  8.665583e-02, -1.688825e-01},
  {-8.810638e-01, -1.410058e-01, -4.514908e-01, -1.774755e-02,  9.330644e-02, -1.943516e-01},
  { 8.860928e-01,  1.410912e-01,  4.415120e-01, -2.445424e-01,  1.041156e-01, -2.341930e-01},
  { 8.860928e-01,  1.410912e-01,  4.415120e-01, -4.464836e-01,  7.954719e-02, -2.539281e-01},
  {-6.063673e-01,  4.102907e-01, -6.811610e-01, -2.481159e-01,  9.909539e-02, -3.185832e-01},
  { 1.087958e-01,  8.396639e-01,  5.320976e-01, -2.797455e-01,  1.059738e-01, -3.424512e-01},
  {-1.407519e-01,  6.979287e-01,  7.021996e-01, -4.376526e-01,  8.270777e-02, -4.585593e-01},
  {-8.030896e-01,  5.397218e-01,  2.524826e-01, -4.451081e-01,  8.100600e-02, -4.559437e-01},
  {-7.067463e-01,  6.315926e-01, -3.187481e-01, -4.424617e-01,  7.640197e-02, -4.755747e-01},
  {-9.542986e-01, -2.981732e-01,  2.017328e-02, -2.205752e-01,  9.060641e-02, -4.980136e-01},
  {-4.832305e-01,  8.656440e-01, -1.309529e-01, -3.923453e-01,  9.450752e-02, -5.141111e-01},
  { 7.445302e-01, -4.638803e-01,  4.800935e-01, -4.461893e-02,  8.167720e-02, -5.379693e-01},
  { 8.229963e-01,  2.040555e-02,  5.676802e-01,  2.404177e-01,  8.893672e-02, -6.419719e-01},
  { 8.027506e-01, -3.579857e-01, -4.769042e-01,  2.343767e-01,  9.745424e-02, -6.773905e-01},
  {-9.905470e-01, -1.369085e-01,  8.526222e-03, -3.678795e-01,  9.836847e-02, -7.175610e-01},
  { 4.961165e-01, -3.988445e-01, -7.712272e-01, -2.105504e-01,  1.055865e-01, -7.919732e-01},
  {-4.160455e-01,  1.973097e-01, -8.876796e-01, -2.806656e-01,  8.977858e-02, -7.873928e-01},
  {-2.878648e-01, -3.516336e-01,  8.907793e-01,  3.297210e-01,  1.256720e-01,  8.566163e-01},
  { 7.339453e-01,  6.187851e-01, -2.800523e-01,  4.495808e-01,  9.813341e-02,  6.416835e-01},
  {-5.830751e-01, -1.059941e-01,  8.054742e-01,  1.509639e-01,  1.194821e-01,  5.325420e-01},
  { 2.196490e-01,  6.496409e-01,  7.278194e-01, -2.773712e-01,  1.008305e-01,  5.240066e-01},
  {-9.032974e-01,  3.859896e-01,  1.872587e-01, -3.351725e-01,  1.092304e-01,  4.914912e-01},
  {-9.262056e-02, -4.322058e-01,  8.970059e-01,  6.371088e-02,  1.140509e-01,  4.590070e-01},
  {-6.733252e-01, -7.009284e-01,  2.352289e-01, -2.047714e-01,  1.003028e-01,  1.845821e-01},
  { 8.056697e-01,  3.640464e-02, -5.912452e-01,  5.332152e-01,  1.111501e-01,  1.554174e-01},
  {-8.960248e-01, -3.520389e-01, -2.705701e-01, -2.898567e-01,  1.185975e-01,  1.213539e-01},
  {-5.999433e-01, -7.588945e-01, -2.532729e-01, -2.972850e-01,  1.207825e-01,  1.264764e-01},
  {-9.738689e-01,  1.239904e-01,  1.902780e-01, -2.806438e-01,  1.230394e-01,  8.615347e-02},
  { 3.034428e-01, -1.860268e-01, -9.345140e-01, -2.013094e-01,  9.882305e-02,  2.952267e-02},
  {-4.890088e-01,  3.185119e-01,  8.120471e-01, -3.056178e-01,  1.248926e-01,  5.385803e-02},
  {-9.671172e-01,  1.128789e-01,  2.279091e-01, -3.397191e-02,  1.099214e-01, -1.004395e-01},
  {-7.825382e-02,  3.328670e-01,  9.397212e-01, -3.677073e-01,  1.049906e-01, -1.257180e-01},
  {-7.114874e-01,  1.411833e-01,  6.883697e-01, -3.856698e-01,  1.112577e-01, -1.356928e-01},
  { 9.407155e-01,  3.359407e-01, -4.688517e-02,  4.754320e-01,  1.228889e-01, -2.793742e-01},
  {-1.096197e-01,  5.838426e-01,  8.044323e-01, -4.331305e-01,  1.035942e-01, -2.946221e-01},
  { 6.021591e-01,  1.532652e-01,  7.835268e-01, -1.459767e-01,  1.188442e-01, -3.565899e-01},
  {-7.070576e-01, -1.839139e-01, -6.828215e-01, -4.113697e-01,  1.115931e-01, -3.489891e-01},
  {-4.274471e-01,  8.049592e-01,  4.114970e-01, -2.175518e-01,  1.228959e-01, -3.666699e-01},
  {-3.014639e-01, -9.112077e-02, -9.491135e-01, -3.777907e-01,  1.187704e-01, -3.659796e-01},
  { 3.316937e-01,  7.708471e-01, -5.438510e-01,  4.385825e-01,  1.070212e-01, -5.543846e-01},
  {-1.403369e-01,  3.225108e-01,  9.361050e-01, -2.803748e-01,  1.137401e-01, -5.473956e-01},
  { 9.109541e-01, -3.378161e-01,  2.367338e-01,  2.451933e-01,  1.119009e-01, -6.462701e-01},
  { 8.910168e-01, -2.380029e-01, -3.865796e-01, -4.641977e-02,  1.169991e-01, -6.683264e-01},
  {-4.009124e-02, -6.809824e-01, -7.312016e-01, -1.340857e-01,  1.072558e-01, -6.908331e-01},
  { 2.442227e-01,  6.674187e-01, -7.034967e-01, -2.946371e-01,  1.188764e-01, -6.791167e-01},
  { 2.829880e-01, -4.561943e-01, -8.436850e-01,  2.285901e-01,  1.241596e-01, -6.971350e-01},
  {-5.314849e-01, -5.046012e-01, -6.803686e-01, -9.542023e-02,  1.042049e-01, -7.111247e-01},
  { 5.250799e-01, -3.654492e-01, -7.685948e-01, -4.844972e-02,  1.271625e-01, -7.687550e-01},
  {-4.098423e-01, -8.695199e-01, -2.756167e-01, -2.584201e-01,  1.235154e-01, -8.087446e-01},
  {-5.524337e-02,  2.138980e-01,  9.752927e-01,  3.926881e-01,  1.379402e-01,  8.672025e-01},
  { 1.650531e-01,  4.837975e-01,  8.594752e-01,  1.926302e-01,  1.339795e-01,  8.083753e-01},
  {-2.437946e-02,  5.280568e-01,  8.488591e-01,  2.528859e-01,  1.399995e-01,  7.868091e-01},
  { 8.513999e-01,  5.037701e-01,  1.460617e-01,  3.641611e-01,  1.385977e-01,  6.912056e-01},
  { 6.194717e-01,  7.084188e-01,  3.382271e-01,  3.775535e-01,  1.258194e-01,  6.802519e-01},
  { 3.987548e-01,  8.133837e-01,  4.235582e-01,  4.177895e-01,  1.183002e-01,  6.551189e-01},
  { 5.581787e-01,  8.092936e-01, -1.829765e-01,  4.236230e-01,  1.165595e-01,  6.417866e-01},
  { 2.238531e-01, -9.544610e-01,  1.972153e-01, -9.068245e-02,  1.401708e-01,  5.995440e-01},
  {-2.517419e-01, -9.595927e-01,  1.257296e-01, -1.035135e-01,  1.385288e-01,  5.687221e-01},
  { 8.515565e-01,  7.206850e-02, -5.192856e-01,  3.225020e-01,  1.359700e-01,  5.633736e-01},
  {-7.519974e-01,  6.273495e-02,  6.561739e-01,  1.951468e-01,  1.377004e-01,  5.654916e-01},
  {-5.286352e-01,  5.772434e-01,  6.223623e-01, -3.138672e-01,  1.399748e-01,  4.825130e-01},
  {-9.232773e-01,  3.811865e-01, -4.749442e-02, -3.329365e-01,  1.379187e-01,  4.441688e-01},
  {-5.601589e-01,  7.503877e-01,  3.509133e-01, -3.125607e-01,  1.331338e-01,  3.754331e-01},
  {-3.113651e-01, -9.012652e-01, -3.012852e-01, -3.005945e-01,  1.201061e-01,  2.634304e-01},
  { 6.007161e-01, -7.797372e-02, -7.956508e-01,  2.764099e-01,  1.386776e-01,  2.027130e-01},
  {-5.343649e-01, -7.621335e-01, -3.655224e-01, -3.184437e-01,  1.355844e-01,  1.621602e-01},
  {-1.146619e-01,  5.581772e-03, -9.933889e-01,  4.903139e-01,  1.408047e-01,  1.500789e-01},
  {-8.300608e-01, -2.894651e-02, -5.569212e-01, -3.146618e-01,  1.468438e-01,  1.340675e-01},
  {-9.886855e-01, -6.863106e-02,  1.333816e-01,  3.341703e-03,  1.385160e-01,  8.848534e-03},
  {-2.805039e-01, -2.227578e-01, -9.336469e-01, -4.411499e-01,  1.275986e-01,  2.660129e-03},
  {-6.018205e-01,  7.252674e-01,  3.343638e-01, -4.708512e-01,  1.272735e-01,  1.836621e-02},
  {-2.573846e-01,  9.448907e-03, -9.662628e-01, -3.520433e-01,  1.370661e-01, -1.014238e-02},
  {-1.740627e-01,  5.542752e-01, -8.139295e-01, -3.945161e-01,  1.358449e-01, -1.487973e-03},
  { 9.952373e-01,  7.760275e-02,  5.899638e-02,  4.973947e-01,  1.400696e-01, -1.087055e-01},
  { 9.937193e-01,  1.022008e-01,  4.557224e-02,  5.005419e-01,  1.349627e-01, -1.456333e-01},
  {-9.584048e-01, -4.283485e-03, -2.853802e-01, -3.872685e-01,  1.345738e-01, -1.664654e-01},
  { 7.181834e-01,  2.897168e-01,  6.326742e-01, -2.623418e-01,  1.184037e-01, -1.945309e-01},
  { 8.077184e-01,  2.327844e-01, -5.416664e-01,  4.940694e-01,  1.429370e-01, -2.543193e-01},
  { 6.469260e-01, -2.868104e-01, -7.065596e-01,  4.717723e-01,  1.387228e-01, -2.618764e-01},
  { 8.467193e-02,  9.918765e-01, -9.493025e-02,  4.619766e-01,  1.383327e-01, -2.746892e-01},
  { 9.953996e-01,  3.868232e-02, -8.765431e-02,  4.790945e-01,  1.415588e-01, -3.064588e-01},
  { 8.918300e-01,  2.707879e-01,  3.623715e-01,  5.216498e-01,  1.273959e-01, -3.939451e-01},
  {-3.961849e-01,  7.364592e-01,  5.483295e-01, -2.003580e-01,  1.428784e-01, -4.005979e-01},
  {-7.627344e-01, -2.636757e-01, -5.905179e-01, -2.906958e-01,  1.471353e-01, -4.132198e-01},
  { 8.604031e-01, -4.135003e-01, -2.978657e-01, -2.395182e-02,  1.262759e-01, -5.208776e-01},
  {-9.101293e-01,  9.109497e-02, -4.041860e-01, -3.722619e-01,  1.321416e-01, -5.508521e-01},
  {-8.327914e-01, -3.752266e-01,  4.070180e-01, -2.483821e-01,  1.333734e-01, -5.322843e-01},
  { 7.663326e-01,  7.259496e-02,  6.383293e-01, -1.020514e-02,  1.277438e-01, -5.734968e-01},
  {-3.564719e-01,  7.454794e-02,  9.313272e-01, -2.828283e-01,  1.386607e-01, -5.519941e-01},
  {-4.472136e-01, -8.944272e-01,  0.000000e+00,  3.977995e-01,  1.108312e-01, -5.772532e-01},
  {-2.994363e-01,  7.978948e-01, -5.231652e-01,  3.867096e-01,  1.110370e-01, -5.764841e-01},
  { 8.789428e-01, -3.949953e-01, -2.672794e-01,  2.533895e-01,  1.272855e-01, -6.420529e-01},
  { 9.252708e-01, -3.358856e-01, -1.762237e-01,  2.540548e-01,  1.327311e-01, -6.479129e-01},
  { 1.713493e-01,  1.980413e-01,  9.651005e-01,  2.453536e-01,  1.265300e-01, -6.443335e-01},
  {-1.212878e-03,  4.829252e-01, -8.756607e-01, -2.207263e-01,  1.445622e-01, -6.387975e-01},
  {-4.845555e-01,  8.581403e-01, -1.697093e-01, -2.173354e-01,  1.348413e-01, -6.488366e-01},
  {-1.016292e-01, -6.882796e-01, -7.182916e-01, -1.461103e-01,  1.248181e-01, -7.094266e-01},
  {-3.638461e-01,  6.367973e-01, -6.797832e-01, -3.678209e-01,  1.194575e-01, -7.027541e-01},
  { 3.058554e-01, -7.949989e-01, -5.238598e-01, -4.055792e-02,  1.426429e-01, -7.773483e-01},
  {-5.969319e-01, -1.296054e-01,  7.917542e-01, -2.767895e-01,  1.411674e-01, -8.046817e-01},
  { 1.583775e-01, -8.116521e-01, -5.622609e-01, -2.763781e-01,  1.353540e-01, -8.176388e-01},
  {-7.216821e-01, -4.355117e-01, -5.380562e-01, -2.923574e-01,  1.391993e-01, -8.232872e-01},
  {-5.082186e-01,  3.845079e-01,  7.706280e-01,  3.056794e-01,  1.462035e-01,  8.435879e-01},
  { 2.189712e-01,  3.264301e-01,  9.195081e-01,  1.521190e-01,  1.580400e-01,  8.199256e-01},
  { 9.205346e-01, -2.669877e-01, -2.851908e-01,  3.667468e-01,  1.453872e-01,  7.371901e-01},
  {-7.350591e-01, -2.671443e-01,  6.231549e-01, -7.423544e-02,  1.620085e-01,  7.152994e-01},
  { 1.848434e-01, -9.703543e-01,  1.557090e-01, -8.090443e-02,  1.579447e-01,  7.065307e-01},
  {-6.209444e-01, -7.725381e-01,  1.327140e-01, -1.257265e-01,  1.558878e-01,  6.587021e-01},
  { 4.919163e-01,  8.319336e-01, -2.567194e-01,  4.060299e-01,  1.280406e-01,  6.399400e-01},
  { 3.929969e-01,  9.173841e-01, -6.292679e-02,  4.000382e-01,  1.298761e-01,  6.369313e-01},
  { 5.003393e-01,  8.462610e-01, -1.830381e-01,  3.877214e-01,  1.383668e-01,  6.468623e-01},
  {-6.238072e-01, -3.134979e-02,  7.809493e-01,  1.122111e-01,  1.413762e-01,  4.980555e-01},
  { 4.001826e-02,  4.582483e-01,  8.879229e-01, -3.027384e-01,  1.528609e-01,  4.763551e-01},
  { 6.620177e-02, -8.096311e-01,  5.831935e-01,  6.635325e-02,  1.499222e-01,  4.805763e-01},
  { 7.363160e-01,  2.064982e-01,  6.443580e-01,  4.342693e-01,  1.319123e-01,  4.242553e-01},
  {-3.142429e-01,  5.794093e-01,  7.520214e-01, -4.001057e-01,  1.498544e-01,  3.276950e-01},
  {-8.222961e-01,  9.625634e-02,  5.608600e-01, -4.301005e-01,  1.433617e-01,  3.139887e-01},
  {-7.127764e-01, -6.913610e-01, -1.181941e-01, -4.425432e-01,  1.596457e-01,  2.744065e-01},
  { 9.372824e-01, -5.653635e-02,  3.439552e-01,  4.359215e-01,  1.456083e-01,  2.809730e-01},
  {-2.743473e-01, -8.730699e-01, -4.030911e-01, -3.443368e-01,  1.459982e-01,  2.472339e-01},
  {-3.428461e-01, -9.381729e-01, -4.783469e-02, -3.289783e-01,  1.448975e-01,  2.289187e-01},
  { 8.936090e-01, -4.500982e-02,  4.465838e-01,  5.408719e-01,  1.570647e-01,  2.104864e-01},
  {-8.363382e-01, -3.531740e-02, -5.470751e-01, -2.468168e-03,  1.565362e-01,  3.283563e-02},
  {-2.932629e-01,  5.251990e-01,  7.988510e-01, -3.231775e-01,  1.502360e-01,  4.175222e-02},
  {-3.850334e-01,  7.413297e-01,  5.497087e-01, -4.503041e-01,  1.430982e-01,  2.102370e-02},
  {-5.946048e-01,  6.217674e-01, -5.097553e-01, -4.542091e-01,  1.423444e-01,  1.354909e-02},
  {-5.367516e-01,  1.429473e-01, -8.315430e-01, -3.147368e-01,  1.432521e-01, -2.241753e-02},
  { 9.831711e-01,  1.770467e-01, -4.504509e-02,  4.949143e-01,  1.554813e-01, -1.433748e-01},
  {-7.161220e-01,  4.955297e-01,  4.915482e-01, -3.818028e-01,  1.583724e-01, -1.692736e-01},
  {-7.091960e-01, -1.010754e-01, -6.977282e-01, -3.997875e-02,  1.412088e-01, -1.786944e-01},
  {-8.676236e-01, -9.633982e-02, -4.877991e-01, -3.768259e-01,  1.689533e-01, -1.928366e-01},
  {-4.536733e-01,  7.225294e-01,  5.216625e-01, -3.089393e-02,  1.439737e-01, -1.851061e-01},
  {-1.852938e-01,  7.325528e-01,  6.550057e-01, -3.836837e-01,  1.482905e-01, -3.203238e-01},
  {-2.014739e-01,  8.194345e-01,  5.365961e-01, -4.254181e-01,  1.360635e-01, -3.278688e-01},
  { 1.932207e-01,  5.363112e-01,  8.216058e-01, -3.307514e-01,  1.564065e-01, -3.339019e-01},
  {-8.532293e-01,  3.355054e-01, -3.992940e-01, -1.966589e-01,  1.628562e-01, -3.634280e-01},
  { 8.122487e-01,  4.831484e-01,  3.268329e-01,  4.789019e-01,  1.570388e-01, -3.773806e-01},
  {-6.404421e-01,  7.604913e-01,  1.071772e-01, -1.847258e-01,  1.581023e-01, -3.989195e-01},
  { 8.944272e-01, -4.472136e-01,  0.000000e+00,  5.278153e-01,  1.429954e-01, -4.215666e-01},
  { 4.898647e-01,  3.956775e-01, -7.768345e-01,  5.004121e-01,  1.429428e-01, -4.304777e-01},
  { 7.041656e-01,  5.389865e-01, -4.622167e-01,  4.935820e-01,  1.374568e-01, -4.419023e-01},
  {-4.537865e-01,  8.851612e-01,  1.027988e-01, -1.845175e-01,  1.592262e-01, -4.405199e-01},
  { 1.393967e-01,  9.380175e-01,  3.173199e-01, -2.020336e-01,  1.582042e-01, -4.440934e-01},
  {-1.737425e-01,  6.794902e-01, -7.128160e-01,  3.534527e-01,  1.468890e-01, -4.659346e-01},
  { 9.884799e-01, -1.506306e-01, -1.476223e-02, -2.258604e-02,  1.462063e-01, -5.429479e-01},
  { 1.348119e-01,  3.416218e-01,  9.301184e-01, -2.128974e-02,  1.517784e-01, -5.535814e-01},
  {-4.053101e-01,  4.669610e-01, -7.859206e-01, -1.980817e-01,  1.543485e-01, -6.391299e-01},
  {-5.409073e-01,  5.688178e-01, -6.195689e-01, -1.932556e-01,  1.629206e-01, -6.379994e-01},
  {-2.251140e-01, -1.614823e-01, -9.608575e-01,  4.241837e-02,  1.525208e-01, -6.647785e-01},
  { 7.584833e-02,  5.528620e-01, -8.298135e-01, -3.375385e-01,  1.411374e-01, -6.928313e-01},
  { 4.414599e-01, -7.115877e-01, -5.465857e-01, -1.278160e-01,  1.513833e-01, -7.362073e-01},
  { 1.528345e-02, -7.735441e-01, -6.335582e-01, -3.108305e-02,  1.586690e-01, -8.033296e-01},
  { 4.842820e-01, -1.222829e-01, -8.663243e-01, -2.928674e-01,  1.458770e-01, -8.245148e-01},
  { 6.921337e-01,  7.464387e-02,  7.178991e-01,  4.069393e-01,  1.593108e-01,  8.582382e-01},
  { 8.098758e-01,  5.538474e-01, -1.932726e-01,  3.776338e-01,  1.432756e-01,  6.379218e-01},
  { 2.984080e-01, -9.212365e-01,  2.495517e-01, -3.679940e-02,  1.604689e-01,  5.735829e-01},
  {-8.007390e-01, -3.801598e-01,  4.629207e-01,  1.897820e-01,  1.780606e-01,  5.653325e-01},
  { 9.639242e-01, -3.447122e-02,  2.639352e-01,  3.052619e-01,  1.770859e-01,  4.951263e-01},
  {-6.542841e-01, -4.467284e-01,  6.102017e-01,  1.112972e-01,  1.529785e-01,  5.063087e-01},
  {-4.653449e-01, -4.550300e-01,  7.592113e-01,  9.478980e-02,  1.522689e-01,  4.907777e-01},
  {-6.628814e-01, -7.225192e-01,  1.963522e-01, -1.136751e-01,  1.545543e-01,  4.671126e-01},
  {-9.319679e-01,  2.130900e-01,  2.933063e-01, -3.339264e-01,  1.699231e-01,  4.530227e-01},
  { 3.669043e-01,  5.251135e-01,  7.678783e-01,  4.260517e-01,  1.607356e-01,  4.151144e-01},
  { 4.612327e-01,  4.277933e-01,  7.773398e-01,  3.634855e-01,  1.792414e-01,  4.182117e-01},
  { 5.620372e-01,  3.350249e-01,  7.562225e-01,  4.445200e-01,  1.752052e-01,  3.885216e-01},
  {-8.677182e-01,  2.770346e-01, -4.126946e-01, -2.792944e-01,  1.695104e-01,  3.825177e-01},
  {-1.693757e-01,  8.304880e-01,  5.306613e-01, -3.398097e-01,  1.696098e-01,  3.273879e-01},
  {-2.652469e-01,  6.676411e-01,  6.956288e-01, -3.918371e-01,  1.626707e-01,  3.206595e-01},
  {-5.785112e-01,  6.004221e-01,  5.521032e-01, -4.274966e-01,  1.550487e-01,  3.108061e-01},
  {-2.011865e-01, -9.786143e-01, -4.287366e-02, -3.667499e-01,  1.585729e-01,  2.366394e-01},
  {-5.339882e-01, -5.942560e-01, -6.014286e-01, -4.002594e-01,  1.753104e-01,  1.661425e-01},
  {-4.338360e-01, -6.425169e-01, -6.316314e-01, -3.899899e-01,  1.719903e-01,  1.606761e-01},
  { 2.321474e-01,  4.742401e-01, -8.492373e-01, -1.065094e-01,  1.723956e-01,  8.126110e-02},
  {-5.048787e-01,  4.525307e-01, -7.350602e-01, -3.450334e-02,  1.834523e-01,  7.279409e-02},
  { 6.358338e-01,  2.472974e-01,  7.311357e-01,  3.616222e-01,  1.821679e-01,  9.122656e-03},
  {-2.746111e-01,  7.779176e-01, -5.651840e-01, -3.483336e-01,  1.582159e-01,  3.262300e-03},
  {-3.910208e-01,  9.072350e-01,  1.550077e-01, -4.503560e-01,  1.482778e-01,  1.640720e-02},
  { 5.901231e-01,  1.700616e-01, -7.891981e-01, -1.897274e-01,  1.702116e-01,  2.729066e-03},
  {-1.780808e-02, -3.528247e-01, -9.355199e-01, -2.756260e-01,  1.730878e-01, -4.735183e-02},
  { 8.607333e-01,  1.809629e-01,  4.758054e-01,  4.923106e-01,  1.604118e-01, -9.218732e-02},
  {-9.828684e-01,  1.624126e-01, -8.713152e-02, -2.393538e-02,  1.708414e-01, -1.065301e-01},
  {-6.957797e-01,  3.213952e-01,  6.423361e-01, -3.739472e-01,  1.725503e-01, -1.625618e-01},
  {-9.706231e-01,  1.999141e-01,  1.338850e-01, -2.007689e-02,  1.628545e-01, -1.759163e-01},
  { 8.914843e-01, -3.622419e-01, -2.720968e-01,  4.968930e-01,  1.612350e-01, -2.601565e-01},
  { 5.395910e-02,  7.054775e-01,  7.066753e-01, -4.101588e-01,  1.511629e-01, -3.441076e-01},
  {-5.228160e-01,  6.763529e-01, -5.188546e-01, -3.689109e-01,  1.615815e-01, -3.576581e-01},
  { 3.068924e-01,  8.810105e-01, -3.600521e-01,  4.707488e-01,  1.685987e-01, -4.034865e-01},
  {-9.242864e-01, -2.956371e-01, -2.414403e-01, -2.877663e-01,  1.691151e-01, -4.292166e-01},
  { 3.411269e-01,  6.709835e-01,  6.583416e-01, -2.232927e-01,  1.726023e-01, -4.521849e-01},
  {-4.201362e-01,  6.949648e-01,  5.835320e-01, -1.849496e-01,  1.658398e-01, -4.534360e-01},
  { 8.861691e-01, -1.274124e-01,  4.455001e-01, -1.502546e-02,  1.776186e-01, -5.730380e-01},
  {-8.095849e-01, -5.869657e-01, -6.600062e-03, -3.820763e-01,  1.691225e-01, -6.122559e-01},
  { 2.633010e-01,  3.143991e-01, -9.120448e-01, -2.920310e-01,  1.654802e-01, -6.391720e-01},
  { 4.049884e-01,  3.814930e-01, -8.309318e-01, -3.100165e-01,  1.681067e-01, -6.466807e-01},
  { 1.652662e-01, -2.560652e-01, -9.524273e-01, -1.559046e-02,  1.616536e-01, -6.564292e-01},
  {-2.333807e-03, -4.784413e-01, -8.781164e-01,  4.606833e-03,  1.749650e-01, -6.605314e-01},
  { 6.195183e-01, -4.279995e-01, -6.580375e-01, -3.107340e-02,  1.598880e-01, -6.639014e-01},
  {-6.228538e-01,  6.770754e-01, -3.919464e-01, -1.684453e-01,  1.740064e-01, -6.444918e-01},
  {-6.141562e-01,  7.809256e-01,  1.138743e-01, -1.715812e-01,  1.682041e-01, -6.683357e-01},
  {-5.039853e-01,  6.455260e-01, -5.738423e-01, -3.495266e-01,  1.578423e-01, -6.739742e-01},
  {-8.084561e-01,  2.848725e-01, -5.150208e-01, -3.532090e-01,  1.506114e-01, -6.829904e-01},
  {-6.343409e-01,  6.706063e-01,  3.845761e-01, -2.723231e-01,  1.685081e-01, -8.110920e-01},
  {-7.881187e-01,  6.121565e-01,  6.429283e-02, -2.825431e-01,  1.636401e-01, -8.212507e-01},
  { 4.106544e-01, -9.048252e-01,  1.124917e-01,  1.576133e-02,  1.777639e-01, -8.355721e-01},
  { 8.416151e-02, -7.121478e-01, -6.969664e-01,  4.520307e-02,  1.826566e-01, -8.496534e-01},
  {-1.139260e-01,  3.658900e-01, -9.236586e-01, -2.666467e-01,  1.685694e-01, -8.256391e-01},
  {-3.665294e-01,  4.424977e-01,  8.184449e-01,  3.467111e-01,  1.769589e-01,  8.480135e-01},
  {-9.364429e-01, -1.334305e-01,  3.244551e-01,  1.476183e-01,  1.805035e-01,  8.161737e-01},
  {-9.761617e-01,  4.455145e-02,  2.124227e-01,  1.443711e-01,  1.877503e-01,  8.097818e-01},
  { 4.733775e-01, -8.768204e-01, -8.425883e-02, -2.758044e-02,  1.853323e-01,  7.211098e-01},
  { 3.907370e-01, -6.239164e-01,  6.767961e-01, -2.112629e-02,  1.902989e-01,  7.173387e-01},
  { 4.937169e-01, -6.410885e-01,  5.875791e-01,  3.136695e-02,  1.900370e-01,  6.757919e-01},
  { 6.942408e-01, -9.441192e-02,  7.135237e-01,  5.207256e-02,  1.905804e-01,  6.656368e-01},
  {-6.511204e-01,  5.834121e-01,  4.854613e-01, -9.675858e-02,  1.875164e-01,  6.691247e-01},
  {-2.096021e-01,  4.691148e-01,  8.579034e-01, -1.663857e-01,  1.782570e-01,  6.473206e-01},
  { 7.693700e-01, -8.128482e-02,  6.336107e-01,  8.245080e-02,  1.899806e-01,  6.227658e-01},
  { 3.802654e-01,  7.870571e-02,  9.215224e-01,  1.176269e-01,  1.876878e-01,  5.863649e-01},
  {-6.681286e-02, -8.788506e-01,  4.723956e-01,  1.166341e-01,  1.718131e-01,  5.566112e-01},
  {-6.391937e-01, -7.649470e-01, -7.929359e-02, -1.445855e-01,  1.864426e-01,  5.462034e-01},
  {-2.725667e-02, -9.547501e-01,  2.961580e-01,  6.419624e-02,  1.770702e-01,  5.393170e-01},
  {-3.965748e-01,  3.776193e-01,  8.367390e-01, -3.213584e-01,  1.814304e-01,  4.640932e-01},
  {-9.599861e-03,  9.856586e-01, -1.684786e-01, -7.268825e-02,  1.893381e-01,  3.242640e-01},
  {-3.350799e-01,  9.323866e-01, -1.355603e-01, -4.282898e-02,  1.921569e-01,  3.158971e-01},
  {-2.966772e-01,  7.968410e-01,  5.263337e-01, -3.735668e-02,  1.954221e-01,  2.859564e-01},
  { 9.680050e-02,  9.063932e-01, -4.111947e-01, -2.034420e-01,  1.959558e-01,  2.975812e-01},
  {-1.173921e-01,  9.731251e-01, -1.981079e-01, -1.921490e-01,  1.922125e-01,  2.862444e-01},
  { 3.069663e-02,  9.357801e-01,  3.512455e-01, -2.093476e-01,  1.899590e-01,  2.592297e-01},
  {-4.763117e-02,  9.913369e-01,  1.224021e-01, -2.408385e-01,  1.904869e-01,  2.560141e-01},
  { 8.214663e-01, -4.140073e-03, -5.702420e-01,  2.812456e-01,  1.931879e-01,  1.996942e-01},
  {-6.928911e-01, -2.114812e-01, -6.893314e-01, -4.337240e-01,  2.057463e-01,  1.682797e-01},
  {-1.824560e-01, -6.786349e-02, -9.808691e-01, -3.749514e-01,  1.899272e-01,  1.478232e-01},
  {-4.064413e-01,  2.302329e-01, -8.841936e-01, -5.264167e-02,  1.959616e-01,  8.913630e-02},
  { 3.212087e-01,  3.468578e-01, -8.812006e-01, -1.002456e-01,  1.995178e-01,  9.592763e-02},
  {-5.449989e-01,  8.207872e-01,  1.711274e-01, -3.138437e-01,  1.736768e-01,  2.522608e-02},
  { 6.978216e-01, -1.311329e-01, -7.041656e-01, -2.382057e-01,  1.824622e-01, -4.302193e-02},
  { 8.490816e-01,  4.200907e-01,  3.202876e-01,  4.759337e-01,  1.882342e-01, -8.846791e-02},
  {-5.157977e-02, -4.171476e-01, -9.073739e-01, -2.662374e-01,  1.928831e-01, -5.505035e-02},
  { 9.616399e-01,  2.540142e-01,  1.035632e-01,  4.936443e-01,  1.862425e-01, -1.301191e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -3.758662e-01,  1.809619e-01, -1.644847e-01},
  {-7.687835e-01, -1.325364e-01, -6.256245e-01, -2.276551e-01,  2.004481e-01, -3.209937e-01},
  {-4.353179e-01,  7.928228e-01,  4.265329e-01, -3.582715e-01,  1.725966e-01, -3.452231e-01},
  { 7.792201e-01,  5.742902e-01, -2.510113e-01,  4.670121e-01,  1.824678e-01, -3.826299e-01},
  {-9.482674e-01, -1.330971e-01, -2.882257e-01, -1.694694e-01,  1.968145e-01, -4.152822e-01},
  {-9.506065e-01,  2.121449e-01, -2.265876e-01, -1.664960e-01,  1.843782e-01, -4.234725e-01},
  {-9.398307e-01,  2.551851e-01,  2.271539e-01, -1.674890e-01,  1.845192e-01, -4.414666e-01},
  { 1.824653e-01,  6.920701e-01,  6.983878e-01, -1.925366e-01,  1.840421e-01, -4.829172e-01},
  { 7.100662e-01, -5.158342e-01, -4.792923e-01,  1.284744e-03,  1.829866e-01, -5.379016e-01},
  {-8.370254e-01, -3.821760e-01,  3.915738e-01, -2.752119e-01,  1.761937e-01, -5.385258e-01},
  { 1.348119e-01,  3.416218e-01,  9.301184e-01, -1.698223e-02,  1.804787e-01, -5.647470e-01},
  {-8.069656e-01, -5.862940e-01, -7.117483e-02, -4.056481e-01,  1.984654e-01, -6.108194e-01},
  {-5.957313e-01,  4.755512e-01, -6.472675e-01, -1.539450e-01,  1.958487e-01, -6.419408e-01},
  { 1.585955e-01,  4.797630e-01, -8.629455e-01, -3.155790e-01,  1.939323e-01, -6.357798e-01},
  {-5.904323e-01, -2.221853e-02, -8.067813e-01, -3.635898e-01,  1.755364e-01, -6.455613e-01},
  { 1.425419e-01, -5.769717e-01, -8.042297e-01, -3.231165e-03,  1.868994e-01, -6.663479e-01},
  {-7.334909e-01,  6.777618e-01, -5.128279e-02, -1.467873e-01,  1.897448e-01, -6.777405e-01},
  { 8.590137e-01, -3.431578e-01, -3.799188e-01,  2.656624e-01,  1.972449e-01, -6.913635e-01},
  {-1.500517e-01, -2.432574e-01, -9.582852e-01,  2.098089e-01,  1.938753e-01, -7.225352e-01},
  {-3.496989e-01, -5.504923e-01, -7.580691e-01, -9.195959e-02,  1.692679e-01, -7.527719e-01},
  { 1.057729e-01, -6.272305e-01, -7.716178e-01, -1.713588e-01,  1.905077e-01, -8.352309e-01},
  { 6.853583e-01, -6.603798e-01,  3.068918e-01,  4.400709e-01,  1.968735e-01,  8.532287e-01},
  { 1.262284e-02,  2.410346e-01,  9.704344e-01,  4.231863e-01,  1.930799e-01,  8.578217e-01},
  {-5.932621e-02,  6.970422e-01,  7.145717e-01,  4.394076e-01,  2.060966e-01,  8.510094e-01},
  {-1.922209e-01,  5.400545e-01,  8.193853e-01,  3.699036e-01,  1.871634e-01,  8.465371e-01},
  { 7.422981e-01, -6.434557e-01, -1.869714e-01,  4.492620e-01,  2.121404e-01,  7.835216e-01},
  { 1.880102e-01, -9.411660e-01,  2.808178e-01,  2.750282e-02,  1.825691e-01,  5.736258e-01},
  { 9.629788e-01, -2.484986e-01,  1.044999e-01,  3.063729e-01,  1.958285e-01,  4.979182e-01},
  { 7.822616e-01, -4.466330e-01,  4.342646e-01,  3.288187e-01,  2.111827e-01,  4.478461e-01},
  {-5.528414e-01,  5.500382e-01,  6.259589e-01, -3.237087e-01,  2.051718e-01,  4.441420e-01},
  { 7.057997e-01, -1.664694e-01,  6.885744e-01,  3.436802e-01,  1.998919e-01,  4.256918e-01},
  { 4.356961e-01,  2.686541e-01,  8.590657e-01,  3.816167e-01,  2.085446e-01,  3.937537e-01},
  {-4.948017e-01,  8.612731e-01, -1.156720e-01,  4.603907e-03,  2.149541e-01,  3.242178e-01},
  {-3.798071e-01,  8.994383e-01,  2.162344e-01, -2.669870e-01,  1.933705e-01,  3.281913e-01},
  {-1.543857e-01,  9.149890e-01,  3.727736e-01, -3.278656e-01,  1.836620e-01,  3.093555e-01},
  {-5.459645e-01,  7.912362e-01,  2.754416e-01, -3.637242e-03,  2.136184e-01,  2.980190e-01},
  {-5.124918e-02,  8.178467e-01,  5.731494e-01, -1.920390e-01,  2.035401e-01,  2.406612e-01},
  { 2.646714e-01, -1.905527e-01, -9.453246e-01,  3.135643e-01,  2.048139e-01,  2.128691e-01},
  { 8.709117e-01, -2.717888e-02, -4.906873e-01,  2.693743e-01,  2.066546e-01,  1.826029e-01},
  {-7.254193e-01,  4.426724e-01,  5.270750e-01, -4.463860e-01,  2.068969e-01,  1.872134e-01},
  { 1.888203e-01, -3.750984e-02, -9.812950e-01,  5.271308e-01,  2.085507e-01,  1.512852e-01},
  {-3.611560e-01, -3.492170e-02, -9.318513e-01, -4.115925e-01,  2.052370e-01,  1.533432e-01},
  { 9.937569e-01,  4.898652e-02,  1.002372e-01,  2.660092e-01,  2.117763e-01,  1.072927e-01},
  { 1.064412e-02,  4.635448e-01, -8.860096e-01, -9.048354e-02,  2.070235e-01,  1.007400e-01},
  {-9.713450e-01,  2.362224e-01, -2.622576e-02, -2.760151e-01,  2.126129e-01,  7.367196e-03},
  { 6.636600e-01, -2.021816e-01, -7.201930e-01, -2.394501e-01,  2.108549e-01, -5.083495e-02},
  {-7.569261e-01, -2.362552e-01, -6.093000e-01, -2.783225e-01,  2.082219e-01, -5.543852e-02},
  { 9.885303e-01,  7.662775e-02,  1.301389e-01,  5.001007e-01,  2.009675e-01, -1.873630e-01},
  { 7.063380e-01, -5.386381e-01, -4.592990e-01,  4.959606e-01,  2.108355e-01, -3.514085e-01},
  {-2.228191e-01,  7.935569e-01,  5.662323e-01, -3.301616e-01,  1.868506e-01, -3.469664e-01},
  { 5.331155e-01, -1.102874e-01, -8.388233e-01,  4.838654e-01,  2.083915e-01, -3.565473e-01},
  { 4.115424e-01,  6.877106e-01,  5.980694e-01, -2.876472e-01,  1.865736e-01, -3.656255e-01},
  {-4.908339e-01,  8.629676e-01, -1.198711e-01, -3.419342e-01,  1.856692e-01, -3.614996e-01},
  { 7.161898e-01,  4.597328e-02,  6.963897e-01, -1.266198e-01,  2.174483e-01, -3.990878e-01},
  {-8.193341e-01,  8.405193e-02, -5.671216e-01, -3.160693e-01,  1.892403e-01, -3.810679e-01},
  {-3.219048e-02,  5.011523e-01,  8.647602e-01, -7.865081e-02,  2.063187e-01, -4.219414e-01},
  {-9.964515e-01,  2.001516e-02, -8.175445e-02, -1.629194e-01,  2.069301e-01, -4.404266e-01},
  {-9.542143e-01, -1.258902e-01,  2.713423e-01, -3.078836e-01,  2.180102e-01, -4.669775e-01},
  {-3.670500e-01,  6.272303e-01,  6.869180e-01, -1.726542e-01,  2.121669e-01, -5.071227e-01},
  {-8.914362e-01, -1.367798e-01,  4.320101e-01, -4.052497e-01,  2.032003e-01, -6.004568e-01},
  { 6.811857e-01, -4.278952e-02,  7.308592e-01,  2.821953e-01,  2.165731e-01, -6.582544e-01},
  {-9.397406e-01,  2.463181e-01, -2.370967e-01, -4.054536e-01,  2.081733e-01, -6.099538e-01},
  {-2.917338e-01,  4.068579e-01, -8.656547e-01, -1.518715e-01,  2.064048e-01, -6.367461e-01},
  {-4.959029e-01,  5.511042e-01, -6.710919e-01, -1.336511e-01,  2.162226e-01, -6.416094e-01},
  { 1.928275e-01, -3.366807e-01,  9.216635e-01,  2.720892e-01,  2.144872e-01, -6.578790e-01},
  { 9.868940e-01,  5.352075e-02, -1.522360e-01,  2.826081e-01,  2.138947e-01, -6.712297e-01},
  { 5.544707e-02, -3.971707e-01, -9.160683e-01,  2.076181e-02,  2.028753e-01, -6.729527e-01},
  { 4.642560e-01, -7.238797e-01, -5.103573e-01, -2.083701e-02,  1.956457e-01, -6.816627e-01},
  { 5.544389e-01, -1.041913e-01, -8.256764e-01,  2.490351e-01,  1.976514e-01, -7.134930e-01},
  {-4.084602e-01, -1.951612e-02, -9.125674e-01,  1.715692e-01,  2.118710e-01, -7.150562e-01},
  { 8.358108e-01, -4.048500e-01,  3.708326e-01, -1.169355e-02,  2.013731e-01, -7.789428e-01},
  {-6.347177e-01,  6.084870e-01,  4.763161e-01, -1.990535e-01,  2.029819e-01, -7.701389e-01},
  {-4.132549e-01, -4.318257e-01, -8.017150e-01, -3.797010e-02,  1.992093e-01, -8.129242e-01},
  {-6.566752e-01,  4.992681e-01, -5.652513e-01, -2.483966e-01,  1.969305e-01, -8.156404e-01},
  { 8.141123e-01, -3.975059e-01,  4.233322e-01,  6.590067e-02,  2.107558e-01, -8.551339e-01},
  { 4.840881e-01, -5.972931e-01, -6.394527e-01,  6.262434e-02,  2.164399e-01, -8.731465e-01},
  { 9.430240e-01, -2.869871e-01,  1.683579e-01,  4.563336e-01,  2.149196e-01,  8.196846e-01},
  { 5.318694e-01, -4.539118e-02,  8.456090e-01,  2.116767e-01,  2.402103e-01,  7.601832e-01},
  { 6.638286e-01,  3.447367e-02,  7.470899e-01, -2.005271e-02,  2.172800e-01,  7.191553e-01},
  { 7.436280e-01,  6.173250e-01,  2.567633e-01, -2.025027e-01,  2.178262e-01,  6.157026e-01},
  {-6.824923e-01, -7.198697e-01, -1.264595e-01, -2.042028e-01,  2.286772e-01,  5.945380e-01},
  {-8.185732e-02,  1.785201e-01,  9.805254e-01,  1.824133e-01,  2.259919e-01,  5.576035e-01},
  { 2.214185e-01,  9.359296e-01, -2.738790e-01, -8.346816e-02,  2.231055e-01,  4.159923e-01},
  {-3.539548e-01,  8.663387e-01, -3.523825e-01, -2.645783e-02,  2.262143e-01,  3.893907e-01},
  {-6.909707e-01,  3.606299e-01, -6.265028e-01, -2.515181e-01,  2.332209e-01,  3.813552e-01},
  {-7.973105e-01,  5.684210e-01, -2.029620e-01,  2.505093e-02,  2.397949e-01,  3.314506e-01},
  { 8.685264e-01, -6.870330e-02, -4.908581e-01,  5.412121e-01,  2.397377e-01,  1.671323e-01},
  {-5.397020e-01,  3.809606e-01, -7.507269e-01, -4.287742e-01,  2.276797e-01,  1.699212e-01},
  { 6.936038e-01,  3.137289e-01, -6.484504e-01, -1.989791e-01,  2.364941e-01,  3.638675e-02},
  {-9.043679e-01,  2.481048e-01,  3.472214e-01, -2.717024e-02,  2.293609e-01, -3.055255e-02},
  { 3.294588e-01, -3.937617e-02, -9.433485e-01, -2.610938e-01,  2.263757e-01, -6.714746e-02},
  {-8.550961e-01,  1.696903e-01,  4.899140e-01, -3.745010e-01,  2.233749e-01, -1.841096e-01},
  { 9.879180e-01,  1.359780e-01,  7.435168e-02,  5.085958e-01,  2.142495e-01, -2.260227e-01},
  { 1.731641e-01,  3.886088e-01, -9.049847e-01,  4.931082e-01,  2.216993e-01, -3.559321e-01},
  {-9.550099e-01,  1.048947e-01, -2.774046e-01,  5.050454e-01,  2.285325e-01, -3.759924e-01},
  {-7.022864e-01, -3.234001e-01,  6.341974e-01, -3.225240e-01,  2.372109e-01, -4.712935e-01},
  { 7.012858e-01, -3.241312e-01, -6.349309e-01,  5.916471e-02,  2.290328e-01, -5.293793e-01},
  {-4.632333e-01, -2.650246e-01,  8.456813e-01, -3.304277e-01,  2.193179e-01, -5.646265e-01},
  { 6.781513e-01, -8.906604e-02,  7.295054e-01,  5.627268e-04,  2.146576e-01, -5.798435e-01},
  {-6.607551e-01, -1.130943e-01,  7.420325e-01, -3.889461e-01,  2.268326e-01, -5.874625e-01},
  {-8.389902e-01,  2.815661e-01, -4.656351e-01, -3.971145e-01,  2.293280e-01, -6.142731e-01},
  {-5.120336e-01,  1.394242e-01, -8.475744e-01, -1.322146e-01,  2.257072e-01, -6.364431e-01},
  { 3.241271e-02,  8.435865e-02, -9.959081e-01, -2.334662e-01,  2.190983e-01, -6.286361e-01},
  {-8.490784e-01,  4.587697e-01, -2.619089e-01, -1.078542e-01,  2.390991e-01, -6.578025e-01},
  { 8.647159e-01, -4.909678e-01, -1.059106e-01, -2.308718e-02,  2.078484e-01, -7.166807e-01},
  {-7.926335e-03,  1.765897e-01, -9.842526e-01,  2.077372e-01,  2.284767e-01, -7.222708e-01},
  {-1.753237e-01, -7.468683e-01, -6.414432e-01, -6.769399e-02,  2.076535e-01, -8.043483e-01},
  {-3.124889e-01, -4.487312e-01, -8.372521e-01,  3.225007e-02,  2.215530e-01, -8.725361e-01},
  { 8.127531e-02,  7.384627e-01,  6.693781e-01,  4.428051e-01,  2.399066e-01,  8.064267e-01},
  { 4.973025e-01, -1.708920e-01,  8.505799e-01, -4.389499e-02,  2.393812e-01,  7.375354e-01},
  { 4.784569e-01, -2.482023e-01,  8.423031e-01,  2.584559e-01,  2.568727e-01,  7.373677e-01},
  { 9.621439e-01, -1.200686e-01, -2.446685e-01,  3.429072e-01,  2.376972e-01,  6.105683e-01},
  {-6.557564e-01,  6.044719e-01, -4.523245e-01, -5.356476e-02,  2.456679e-01,  4.532866e-01},
  {-4.990216e-01, -2.343350e-01,  8.343048e-01, -2.598100e-01,  2.472420e-01,  4.535687e-01},
  {-9.543319e-01,  2.510495e-01, -1.619405e-01, -3.141795e-01,  2.376028e-01,  4.287826e-01},
  { 6.269191e-01,  6.728141e-02,  7.761737e-01,  3.833451e-01,  2.439315e-01,  3.866121e-01},
  {-1.525889e-01,  8.471521e-01, -5.089695e-01, -2.015472e-01,  2.309703e-01,  3.382183e-01},
  {-3.194150e-01,  1.818759e-01,  9.299975e-01, -6.895979e-02,  2.431804e-01,  2.519366e-01},
  {-2.949295e-01,  1.910991e-01,  9.362145e-01, -1.403689e-01,  2.422080e-01,  2.233442e-01},
  { 1.142564e-01,  5.472499e-02,  9.919429e-01, -1.965798e-01,  2.515062e-01,  2.154838e-01},
  { 1.069058e-01, -1.487475e-01, -9.830796e-01,  5.060157e-01,  2.471662e-01,  1.428576e-01},
  {-6.645303e-01, -1.525876e-01, -7.315165e-01, -2.910115e-01,  2.261716e-01,  1.331529e-01},
  {-2.404958e-01, -5.125498e-02, -9.692960e-01, -6.785772e-02,  2.449003e-01,  1.043973e-01},
  { 2.899514e-01,  1.390986e-01, -9.468790e-01, -9.471826e-02,  2.470133e-01,  1.050214e-01},
  {-9.281101e-01,  1.858706e-02, -3.718415e-01, -2.612266e-01,  2.275671e-01,  9.890273e-02},
  {-8.983098e-01, -3.699429e-01,  2.370267e-01, -2.640837e-01,  2.340348e-01,  6.936846e-02},
  {-9.663743e-01,  2.570913e-01, -4.994204e-03, -2.194644e-02,  2.355238e-01,  8.405814e-03},
  {-9.739498e-01,  9.047642e-02, -2.079321e-01, -3.433213e-02,  2.381859e-01, -5.549071e-02},
  {-7.869334e-01,  1.122983e-01,  6.067331e-01, -3.766454e-01,  2.440070e-01, -1.937624e-01},
  { 1.763294e-01,  9.820215e-01, -6.739338e-02,  5.099334e-01,  2.315640e-01, -3.351102e-01},
  {-2.314920e-01,  9.717517e-01, -4.593489e-02,  5.109428e-01,  2.309389e-01, -3.581673e-01},
  {-6.829736e-01, -1.887029e-01, -7.056475e-01,  5.005285e-01,  2.283472e-01, -3.605126e-01},
  {-9.030015e-01,  1.680592e-01,  3.954039e-01, -2.168591e-02,  2.450510e-01, -4.016434e-01},
  {-2.840540e-01,  3.618388e-01, -8.879110e-01,  3.457727e-01,  2.321521e-01, -4.180865e-01},
  {-5.127351e-01,  5.259026e-01,  6.786231e-01, -3.982789e-02,  2.409921e-01, -4.250198e-01},
  {-9.157055e-01, -3.950245e-01, -7.375006e-02, -3.306848e-01,  2.452090e-01, -4.809945e-01},
  {-8.306158e-01, -3.397485e-01,  4.411895e-01, -3.219602e-01,  2.336848e-01, -5.505958e-01},
  {-9.443133e-01,  2.613336e-01, -1.999429e-01, -3.962019e-01,  2.445617e-01, -6.056368e-01},
  {-1.442362e-01,  7.916854e-02, -9.863712e-01, -1.633624e-01,  2.493836e-01, -6.266657e-01},
  { 4.016182e-01,  7.571025e-01,  5.152656e-01,  2.742725e-01,  2.271161e-01, -6.620586e-01},
  {-4.510525e-01,  2.830886e-01,  8.464115e-01,  2.477607e-01,  2.410077e-01, -6.797137e-01},
  {-3.215924e-01, -3.132180e-01, -8.935731e-01,  1.180887e-01,  2.381870e-01, -6.865767e-01},
  { 1.791388e-01, -4.768357e-01, -8.605446e-01,  5.672111e-02,  2.448276e-01, -6.868696e-01},
  { 7.832750e-01,  3.872221e-01, -4.863532e-01,  2.599887e-01,  2.322191e-01, -7.016484e-01},
  { 5.638790e-01, -5.818490e-01, -5.860822e-01, -2.863488e-03,  2.316535e-01, -6.998875e-01},
  {-7.720957e-01,  6.184077e-01,  1.464248e-01, -1.116420e-01,  2.431176e-01, -7.117314e-01},
  { 8.884152e-01, -4.519558e-01, -8.033864e-02, -8.793867e-03,  2.356915e-01, -7.274469e-01},
  { 5.658999e-01,  2.751604e-01, -7.772027e-01,  2.473429e-01,  2.392105e-01, -7.103238e-01},
  { 2.332745e-01,  2.948613e-01, -9.266281e-01,  2.299040e-01,  2.445787e-01, -7.174636e-01},
  { 8.593394e-01, -4.731239e-01,  1.941383e-01, -9.378320e-03,  2.364723e-01, -7.454084e-01},
  { 7.321833e-02, -8.460124e-01, -5.281119e-01, -4.653340e-02,  2.283293e-01, -8.376014e-01},
  {-5.662173e-01,  7.777731e-01,  2.728862e-01, -2.219957e-01,  2.257307e-01, -8.144653e-01},
  { 9.074718e-01, -4.091895e-01,  9.517791e-02,  8.041981e-02,  2.467937e-01, -8.689119e-01},
  { 8.721224e-01, -3.928769e-01,  2.916339e-01,  8.520346e-02,  2.481776e-01, -8.769674e-01},
  {-3.410904e-01, -1.687852e-01, -9.247535e-01,  2.814790e-02,  2.415204e-01, -8.805851e-01},
  { 2.529957e-01, -5.293121e-01, -8.098283e-01,  6.025862e-02,  2.371772e-01, -8.901652e-01},
  {-1.920573e-02,  5.259498e-01, -8.502988e-01, -5.372991e-02,  2.469824e-01, -8.866009e-01},
  {-4.609073e-01,  8.367975e-01, -2.955240e-01, -5.941476e-02,  2.432591e-01, -8.907630e-01},
  { 5.395446e-01,  1.763115e-01,  8.232897e-01, -3.643553e-02,  2.638111e-01,  7.298875e-01},
  { 5.140631e-01,  3.297451e-02,  8.571183e-01,  2.971599e-01,  2.759461e-01,  7.182429e-01},
  { 9.707671e-01, -2.382186e-01,  2.937568e-02,  4.519195e-01,  2.723156e-01,  5.809855e-01},
  { 1.919921e-01, -9.805770e-01, -4.009737e-02,  4.518608e-01,  2.694722e-01,  5.429845e-01},
  {-4.078642e-01,  1.036766e-01, -9.071373e-01,  1.776788e-01,  2.522323e-01,  5.627313e-01},
  { 8.720503e-01, -2.787648e-01, -4.022665e-01,  4.332101e-01,  2.680917e-01,  5.331646e-01},
  {-3.628320e-01,  1.378396e-01,  9.216036e-01,  1.455710e-01,  2.580314e-01,  5.406728e-01},
  { 7.959712e-01, -5.620997e-01,  2.246641e-01,  3.428625e-01,  2.508280e-01,  4.953420e-01},
  { 9.570550e-01, -4.357507e-02,  2.866127e-01,  4.528033e-01,  2.627502e-01,  2.865761e-01},
  {-4.550196e-01,  6.349759e-01,  6.243098e-01,  3.724250e-02,  2.579407e-01,  2.925013e-01},
  {-7.161040e-01, -5.601774e-01, -4.164088e-01, -2.773697e-01,  2.459003e-01,  1.120819e-01},
  { 9.534867e-01, -6.166482e-02,  2.950604e-01,  2.625369e-01,  2.699155e-01,  1.084113e-01},
  {-7.461600e-01,  4.914889e-01, -4.490924e-01,  1.431339e-02,  2.657470e-01,  3.672962e-02},
  {-7.562135e-01,  6.123484e-01,  2.305873e-01,  2.034478e-02,  2.704587e-01, -1.976676e-02},
  {-7.238997e-01,  6.793051e-01,  1.204730e-01, -2.756878e-02,  2.479800e-01, -5.173496e-02},
  { 7.646865e-01,  2.379587e-01, -5.988574e-01, -2.526785e-01,  2.567941e-01, -5.174940e-02},
  { 3.249426e-01,  1.357600e-01,  9.359389e-01, -3.652651e-01,  2.632930e-01, -1.912874e-01},
  { 3.132196e-01, -2.921197e-01,  9.036369e-01, -3.778095e-01,  2.612643e-01, -2.102596e-01},
  { 5.180841e-01,  8.347257e-01, -1.866061e-01,  4.919027e-01,  2.377391e-01, -3.290156e-01},
  { 4.687691e-01, -3.825448e-03, -8.833125e-01,  1.885402e-01,  2.612861e-01, -3.848419e-01},
  { 4.382722e-01,  4.971618e-01, -7.488309e-01,  4.402235e-01,  2.496354e-01, -3.813123e-01},
  { 3.888700e-01,  5.215238e-01, -7.594690e-01,  4.053953e-01,  2.490434e-01, -3.940457e-01},
  { 4.185677e-01,  6.584176e-01,  6.255296e-01, -3.054661e-01,  2.504480e-01, -4.785388e-01},
  {-8.939078e-01,  3.786990e-01,  2.398248e-01, -1.534035e-01,  2.594065e-01, -5.239680e-01},
  {-1.335005e-01,  4.631561e-01, -8.761644e-01, -3.623869e-01,  2.579061e-01, -6.201189e-01},
  { 8.584324e-01, -4.178599e-01,  2.974677e-01,  1.039465e-02,  2.543345e-01, -7.902351e-01},
  {-3.984377e-01,  9.170623e-01,  1.562427e-02, -1.961274e-01,  2.419715e-01, -8.315833e-01},
  {-4.427069e-01, -6.001634e-02, -8.946556e-01, -1.732534e-01,  2.439396e-01, -8.551310e-01},
  { 5.656086e-01, -1.600955e-01, -8.089847e-01,  9.889076e-02,  2.773713e-01, -8.858994e-01},
  {-2.186774e-01,  6.260825e-02, -9.737866e-01,  5.872766e-02,  2.539856e-01, -8.904536e-01},
  { 2.534914e-01,  4.225279e-01,  8.701794e-01,  4.768453e-01,  2.835861e-01,  7.713964e-01},
  { 9.107347e-01, -3.429829e-01, -2.300547e-01,  4.766370e-01,  2.748563e-01,  7.474680e-01},
  { 6.531971e-01,  6.798033e-02,  7.541301e-01, -5.440699e-02,  2.873707e-01,  7.239316e-01},
  {-1.939537e-01,  6.415636e-01,  7.421443e-01,  3.485898e-01,  2.807769e-01,  7.050239e-01},
  { 3.475979e-01, -9.374829e-01, -1.736465e-02,  3.525100e-01,  2.586617e-01,  5.775731e-01},
  {-5.606359e-01,  7.362453e-01,  3.789859e-01, -6.412942e-02,  2.815018e-01,  5.698282e-01},
  { 6.676109e-01,  3.994596e-01,  6.282737e-01,  4.721287e-02,  2.931630e-01,  5.606544e-01},
  { 5.406738e-01, -6.669173e-01, -5.127311e-01,  4.112407e-01,  2.924655e-01,  4.836102e-01},
  {-9.721613e-01, -3.528323e-02, -2.316406e-01, -3.113973e-01,  2.806688e-01,  4.344824e-01},
  {-7.754734e-01,  4.571157e-01,  4.355298e-01,  5.213057e-02,  2.833641e-01,  2.871922e-01},
  { 9.380936e-01, -1.696480e-01, -3.019933e-01,  2.656629e-01,  2.740329e-01,  1.552164e-01},
  { 1.115986e-01, -1.650661e-01, -9.799485e-01,  5.184261e-01,  2.804136e-01,  1.394711e-01},
  { 1.688134e-01, -3.450479e-01, -9.232789e-01, -1.027320e-01,  2.733443e-01,  1.003968e-01},
  {-6.555884e-01, -7.293061e-01, -1.957457e-01, -2.916645e-01,  2.709942e-01,  9.637427e-02},
  { 9.547995e-01,  1.596708e-01,  2.507254e-01,  2.677268e-01,  2.720805e-01,  8.875435e-02},
  {-5.425117e-01,  2.621303e-01, -7.981032e-01,  7.910880e-03,  2.871895e-01,  5.698466e-02},
  { 8.228877e-01,  2.061671e-01,  5.294818e-01,  2.735615e-01,  2.831601e-01,  6.381579e-02},
  {-5.391235e-01, -3.536200e-01, -7.643943e-01, -3.121835e-01,  2.690973e-01, -6.971523e-02},
  { 2.812601e-01,  4.285559e-01, -8.586224e-01, -2.812680e-01,  2.728601e-01, -6.573781e-02},
  { 2.675100e-01,  2.831829e-01,  9.210026e-01, -7.404663e-02,  2.816969e-01, -4.609787e-01},
  {-4.856519e-01,  4.619710e-01,  7.421085e-01, -3.292655e-01,  2.615690e-01, -4.761074e-01},
  {-9.213598e-01, -1.571155e-01, -3.555430e-01, -1.528013e-01,  2.905221e-01, -4.853982e-01},
  {-9.316899e-01, -5.379140e-02, -3.592498e-01, -1.422900e-01,  2.927002e-01, -5.098566e-01},
  {-6.565893e-01,  7.383211e-01,  1.541834e-01, -3.271003e-01,  2.703194e-01, -5.070934e-01},
  {-8.174679e-01,  5.175787e-01,  2.527022e-01, -3.273924e-01,  2.748837e-01, -5.246320e-01},
  {-2.029641e-01,  4.697133e-01,  8.591711e-01, -1.878594e-01,  2.756442e-01, -5.550515e-01},
  { 2.695784e-01, -6.391296e-02,  9.608551e-01,  3.470679e-02,  2.700602e-01, -6.075650e-01},
  {-6.772976e-01,  4.446202e-01, -5.861578e-01, -3.895807e-01,  2.626189e-01, -6.074927e-01},
  {-2.055602e-02, -1.909077e-01, -9.813927e-01, -1.873057e-01,  2.737778e-01, -6.297293e-01},
  {-2.937880e-01,  5.372154e-02, -9.543598e-01, -2.628143e-01,  2.862619e-01, -6.446930e-01},
  { 1.740277e-01, -1.545173e-01, -9.725424e-01,  9.202281e-02,  2.876704e-01, -6.843349e-01},
  { 8.685989e-01,  3.895532e-01, -3.062421e-01,  2.354849e-01,  2.715144e-01, -7.015035e-01},
  { 6.820924e-01, -7.133909e-01, -1.606960e-01,  2.477329e-02,  2.786333e-01, -7.316266e-01},
  {-8.862957e-01,  3.274173e-01, -3.275330e-01, -8.156285e-02,  2.904054e-01, -7.813627e-01},
  { 7.591626e-01, -2.948028e-01,  5.803131e-01,  4.891533e-02,  2.684122e-01, -8.277792e-01},
  {-7.082056e-01,  2.678055e-01,  6.532419e-01,  1.555418e-01,  2.886888e-01,  7.814860e-01},
  {-4.143258e-01, -2.365351e-02,  9.098212e-01,  3.713467e-01,  2.985196e-01,  7.041910e-01},
  { 2.839865e-01,  6.190599e-02,  9.568278e-01,  3.240887e-01,  3.045016e-01,  7.026364e-01},
  { 9.591486e-01, -4.143185e-02, -2.798524e-01,  4.568706e-01,  2.980596e-01,  6.517292e-01},
  {-8.267886e-01,  5.624624e-01,  7.525733e-03,  1.616868e-01,  3.031147e-01,  6.317888e-01},
  {-9.771976e-01,  7.885630e-02, -1.971459e-01,  1.580546e-01,  3.011391e-01,  5.771441e-01},
  {-8.470383e-01,  2.113035e-01,  4.877262e-01,  1.548428e-01,  3.002176e-01,  5.618856e-01},
  {-9.041324e-01,  3.465251e-01, -2.499302e-01, -5.307959e-02,  2.954285e-01,  5.117581e-01},
  { 6.421604e-01, -4.776106e-01, -5.995983e-01,  4.455187e-01,  3.102722e-01,  4.951337e-01},
  { 4.925451e-04,  6.976275e-01, -7.164604e-01, -2.310814e-01,  2.830533e-01,  3.902035e-01},
  { 8.414539e-01,  8.325458e-02,  5.338766e-01,  4.752314e-01,  2.926806e-01,  3.422397e-01},
  {-2.963554e-01,  4.436233e-01,  8.457966e-01,  1.883651e-02,  2.973231e-01,  2.605580e-01},
  { 9.154983e-01,  7.572880e-02,  3.951303e-01,  5.390084e-01,  3.036591e-01,  2.180169e-01},
  {-3.145879e-01, -3.097284e-01,  8.972751e-01, -1.453815e-01,  2.931152e-01,  2.249703e-01},
  {-2.788117e-01, -1.791068e-01, -9.434960e-01,  3.517880e-01,  2.997034e-01,  1.942941e-01},
  { 9.945005e-01,  6.546247e-02, -8.175313e-02,  5.445827e-01,  3.048368e-01,  1.703698e-01},
  {-6.385645e-01,  1.557671e-01, -7.536392e-01, -3.705553e-01,  2.995127e-01,  1.727192e-01},
  {-4.778730e-01, -2.009951e-01, -8.551247e-01, -3.862367e-01,  3.052741e-01, -2.119084e-02},
  {-9.404897e-01,  2.953842e-01, -1.680094e-01, -3.718326e-01,  2.935975e-01, -2.205646e-01},
  {-7.662243e-01, -8.093745e-02, -6.374554e-01, -2.802743e-01,  2.993529e-01, -2.983843e-01},
  { 3.481082e-01,  4.970867e-01, -7.948117e-01,  8.194269e-02,  3.034102e-01, -4.082731e-01},
  { 4.418973e-02,  1.737299e-01, -9.838014e-01,  3.295937e-01,  3.054485e-01, -3.915704e-01},
  { 5.934728e-01,  6.414891e-01, -4.860882e-01,  4.563532e-02,  3.048760e-01, -4.183454e-01},
  { 9.633455e-01,  8.652142e-02, -2.539281e-01,  3.964122e-02,  3.096319e-01, -4.271025e-01},
  { 7.911637e-01,  6.005663e-01,  1.156719e-01,  3.928069e-02,  3.025419e-01, -4.857104e-01},
  {-1.853124e-01,  4.604429e-01,  8.681312e-01, -5.197270e-02,  3.086395e-01, -4.738175e-01},
  { 7.368481e-01,  6.009359e-01, -3.097272e-01,  7.016644e-02,  2.835980e-01, -5.132293e-01},
  { 9.801148e-01, -1.747768e-01, -9.395777e-02,  6.690600e-02,  2.847695e-01, -5.292752e-01},
  { 1.943223e-02,  1.285067e-01,  9.915182e-01, -3.211582e-01,  2.893070e-01, -5.347848e-01},
  { 6.311458e-02,  5.138238e-01,  8.555710e-01, -2.844927e-01,  3.048471e-01, -5.525274e-01},
  {-5.367966e-01,  6.245410e-01, -5.672724e-01, -3.781044e-01,  2.806928e-01, -5.972182e-01},
  { 6.098758e-01, -7.135244e-01,  3.448686e-01,  4.425822e-02,  2.776107e-01, -6.056914e-01},
  {-7.179937e-01,  2.020456e-01, -6.660801e-01, -9.640092e-02,  3.044358e-01, -6.371310e-01},
  { 5.574570e-01, -2.997952e-03,  8.302004e-01,  1.959513e-01,  3.027301e-01, -6.620967e-01},
  { 9.989198e-01,  3.297609e-02, -3.273668e-02,  2.263584e-01,  3.039947e-01, -7.059253e-01},
  { 2.998188e-01,  1.106182e-01, -9.475612e-01,  2.115290e-01,  3.005577e-01, -7.154869e-01},
  { 7.665610e-01, -5.941634e-01,  2.436267e-01,  2.775384e-02,  2.856980e-01, -7.811766e-01},
  {-7.301201e-01,  5.731089e-01, -3.721167e-01, -3.819908e-02,  2.967198e-01, -8.255754e-01},
  {-4.859869e-01,  9.987830e-02, -8.682402e-01,  4.092697e-02,  3.035481e-01, -8.686847e-01},
  { 2.414102e-01,  8.418539e-02,  9.667647e-01,  2.147237e-01,  3.160960e-01,  8.108283e-01},
  {-2.307742e-01,  5.989352e-01,  7.668247e-01,  2.080969e-01,  3.201219e-01,  8.026928e-01},
  { 2.928002e-01,  1.357428e-01,  9.464892e-01,  2.328238e-01,  3.157196e-01,  7.966349e-01},
  {-3.879013e-01, -1.458663e-01,  9.100855e-01,  4.730678e-01,  3.065957e-01,  7.784290e-01},
  {-5.065542e-02,  7.628666e-03,  9.986870e-01,  4.748649e-01,  3.182445e-01,  7.750396e-01},
  {-3.441366e-01, -7.967453e-02,  9.355330e-01,  4.566365e-01,  3.218891e-01,  7.740871e-01},
  {-8.937365e-01,  2.250025e-01,  3.880838e-01,  1.456719e-01,  3.179196e-01,  7.628440e-01},
  {-9.889714e-01,  1.480184e-01, -5.121712e-03,  1.423403e-01,  3.102752e-01,  7.331520e-01},
  {-2.680697e-01, -1.985039e-02,  9.631951e-01, -4.998556e-02,  3.086025e-01,  7.243932e-01},
  {-8.169777e-01,  1.900475e-01,  5.444532e-01, -6.573958e-02,  3.216365e-01,  7.112212e-01},
  {-9.404178e-01, -8.904936e-02,  3.281534e-01, -7.161367e-02,  3.220299e-01,  6.992972e-01},
  {-8.447982e-01,  4.883725e-01, -2.186511e-01,  1.498359e-01,  3.170272e-01,  7.009481e-01},
  {-9.273142e-01, -1.777147e-01,  3.294020e-01, -7.492926e-02,  3.249114e-01,  6.855066e-01},
  { 2.115391e-01,  3.991682e-02,  9.765540e-01,  3.448088e-01,  3.233816e-01,  6.958457e-01},
  {-7.559257e-01, -5.963206e-01,  2.701447e-01, -2.379230e-01,  2.989262e-01,  5.394865e-01},
  {-4.701873e-01,  2.119316e-01,  8.567433e-01,  1.447386e-01,  3.233936e-01,  5.276141e-01},
  { 9.462098e-01,  2.566271e-01,  1.970522e-01,  4.533947e-01,  3.153777e-01,  5.031133e-01},
  { 4.491380e-01,  8.927538e-01, -3.557362e-02, -2.491001e-01,  3.137068e-01,  4.741173e-01},
  {-9.952973e-01,  5.665610e-02,  7.857129e-02, -2.342268e-02,  3.244739e-01,  4.831687e-01},
  {-8.745695e-01,  4.542139e-01, -1.697587e-01, -3.124124e-01,  3.000467e-01,  4.378130e-01},
  { 2.411945e-01,  8.966410e-01, -3.712953e-01, -2.436498e-01,  3.043385e-01,  4.237440e-01},
  {-3.872154e-01,  6.558177e-01, -6.480491e-01, -3.040059e-01,  3.000051e-01,  4.296524e-01},
  {-9.039873e-01, -3.817114e-01, -1.926224e-01, -3.684988e-02,  3.281417e-01,  4.173796e-01},
  {-5.531319e-02, -2.165312e-01,  9.747074e-01, -8.973938e-02,  3.186938e-01,  2.647742e-01},
  { 7.896501e-01,  2.379988e-01,  5.655169e-01,  5.255634e-01,  3.205837e-01,  2.330869e-01},
  { 6.237094e-02,  2.397358e-01,  9.688327e-01,  2.857030e-04,  3.193438e-01,  2.554530e-01},
  { 1.918634e-01, -4.211608e-01,  8.864604e-01, -1.758428e-01,  3.121381e-01,  2.239000e-01},
  {-8.206870e-01,  3.298310e-01, -4.665664e-01, -4.281395e-01,  3.046764e-01,  2.150613e-01},
  {-7.748864e-01, -2.369020e-01, -5.860276e-01, -3.660669e-01,  3.186229e-01,  1.656865e-01},
  { 9.313561e-01, -1.285716e-01, -3.406540e-01,  5.438995e-01,  3.230260e-01,  1.617502e-01},
  {-6.976648e-01, -1.868348e-01, -6.916333e-01, -3.467664e-01,  3.053637e-01,  1.509462e-01},
  { 3.274459e-01, -2.730133e-01, -9.045678e-01,  5.262201e-01,  3.138756e-01,  1.338965e-01},
  { 9.514451e-01,  5.604524e-02,  3.026735e-01,  2.566394e-01,  3.147383e-01,  9.081086e-02},
  {-3.977196e-01, -1.805265e-01, -8.995717e-01, -4.710416e-02,  3.051766e-01,  8.248735e-02},
  {-2.895765e-01, -5.914407e-02, -9.553258e-01, -6.153631e-03,  3.055219e-01,  6.580348e-02},
  { 5.662485e-01,  2.113227e-01, -7.966840e-01, -2.258220e-01,  3.160430e-01,  4.223957e-02},
  {-9.987047e-01, -3.524229e-02, -3.669807e-02, -4.049278e-01,  3.191187e-01,  1.519263e-02},
  {-9.373337e-01,  2.529323e-01,  2.396473e-01,  6.536405e-03,  3.110235e-01, -1.199256e-01},
  { 8.367888e-01,  4.968653e-01,  2.300204e-01,  4.422539e-01,  3.262751e-01, -1.982867e-01},
  {-7.198451e-01,  4.149404e-01,  5.564598e-01, -3.682758e-01,  2.934899e-01, -2.031466e-01},
  { 6.801771e-01,  4.540125e-01,  5.755274e-01,  3.795112e-02,  3.154580e-01, -5.091760e-01},
  {-9.587945e-01,  2.523217e-01,  1.305633e-01, -1.325505e-01,  3.174576e-01, -5.288112e-01},
  { 6.849554e-01, -2.148114e-01,  6.961984e-01,  7.475641e-02,  3.033914e-01, -6.021045e-01},
  {-9.992194e-01,  3.745439e-02, -1.255901e-02, -9.489982e-02,  3.197911e-01, -7.354174e-01},
  { 8.826596e-01, -4.684578e-01,  3.820245e-02,  6.719908e-02,  3.218766e-01, -7.996170e-01},
  { 9.386716e-01,  2.027684e-02,  3.442158e-01,  8.293786e-02,  3.199737e-01, -8.206238e-01},
  {-6.435999e-01,  2.525447e-01, -7.224959e-01, -2.498294e-02,  3.251832e-01, -8.170958e-01},
  { 2.095515e-01,  4.226310e-01, -8.817433e-01,  4.514683e-02,  3.225438e-01, -8.693161e-01},
  { 4.751894e-01,  4.790414e-01, -7.380477e-01,  9.966893e-02,  3.108101e-01, -8.771216e-01},
  { 3.765301e-01, -4.975279e-01,  7.814672e-01,  2.890574e-01,  3.372404e-01,  7.940668e-01},
  { 7.136362e-01,  1.255353e-01,  6.891764e-01,  2.988976e-01,  3.478029e-01,  7.854093e-01},
  { 4.120044e-01, -4.864928e-01,  7.704395e-01,  2.731919e-01,  3.324573e-01,  7.884482e-01},
  {-6.626910e-01,  5.620583e-01,  4.949052e-01,  1.515756e-01,  3.313171e-01,  7.593942e-01},
  { 7.652553e-01, -3.451047e-01,  5.434033e-01,  3.083984e-01,  3.416241e-01,  7.237074e-01},
  {-8.497987e-01,  5.018314e-01, -1.612685e-01,  1.451833e-01,  3.233036e-01,  7.180380e-01},
  { 9.716401e-01, -1.374395e-01, -1.924214e-01,  4.710239e-01,  3.329425e-01,  6.837949e-01},
  { 4.724741e-01, -9.900800e-02,  8.757658e-01,  3.378835e-01,  3.405061e-01,  6.960714e-01},
  {-9.632970e-01, -2.300746e-01, -1.382917e-01, -3.787160e-02,  3.317527e-01,  5.791044e-01},
  {-5.420580e-01,  6.867625e-01,  4.842833e-01,  2.007021e-01,  3.435225e-01,  5.686837e-01},
  {-7.016270e-01,  5.641575e-01,  4.352538e-01,  1.872446e-01,  3.398578e-01,  5.574893e-01},
  {-4.557100e-01,  3.683609e-01,  8.103324e-01,  1.543964e-01,  3.311096e-01,  5.313035e-01},
  {-8.251431e-01, -3.792718e-01,  4.186784e-01, -2.682075e-01,  3.182549e-01,  5.013476e-01},
  { 2.459375e-01,  9.689253e-01, -2.642778e-02, -2.775024e-01,  3.211923e-01,  4.842484e-01},
  { 2.560258e-01,  9.602888e-01, -1.108880e-01, -2.820964e-01,  3.193485e-01,  4.467906e-01},
  { 9.530662e-01, -2.719942e-01,  1.329811e-01,  3.791135e-01,  3.244548e-01,  3.911907e-01},
  {-6.633461e-01,  2.813367e-01, -6.934130e-01,  5.864741e-02,  3.298476e-01,  3.562890e-01},
  { 3.376787e-01, -3.377052e-02,  9.406555e-01, -7.708554e-02,  3.396749e-01,  2.668120e-01},
  {-6.070945e-01, -1.711016e-01,  7.759901e-01, -4.126650e-01,  3.253769e-01,  2.397191e-01},
  {-5.655447e-01,  3.360184e-01,  7.531606e-01, -4.068783e-01,  3.344148e-01,  2.354514e-01},
  {-8.751689e-01,  2.379264e-01, -4.212723e-01, -4.111436e-01,  3.335122e-01,  2.028424e-01},
  {-1.672466e-01, -3.875668e-01, -9.065432e-01,  5.082107e-01,  3.436565e-01,  1.239982e-01},
  { 9.624279e-01, -1.949867e-01,  1.889784e-01,  2.567051e-01,  3.241699e-01,  9.283175e-02},
  { 2.932802e-02, -5.874059e-01, -8.087609e-01, -8.116086e-02,  3.204886e-01,  7.938405e-02},
  { 3.742472e-01,  1.879182e-01, -9.080890e-01, -3.071989e-01,  3.453066e-01, -3.190885e-02},
  {-9.076052e-01,  3.022618e-01,  2.913602e-01,  4.453827e-02,  3.412697e-01, -4.130473e-02},
  {-8.172156e-01,  5.714194e-01,  7.508940e-02, -3.915806e-01,  3.388143e-01, -2.104251e-02},
  { 1.439397e-01,  4.588363e-01,  8.767841e-01, -3.480489e-01,  3.202134e-01, -2.191441e-01},
  { 5.648728e-01,  2.408789e-01,  7.892377e-01, -2.822673e-01,  3.406551e-01, -2.572850e-01},
  {-6.607776e-01, -1.703307e-01, -7.309996e-01, -3.288504e-01,  3.433398e-01, -2.806804e-01},
  { 8.070698e-01,  3.125916e-01, -5.009239e-01,  3.584197e-01,  3.376401e-01, -3.561136e-01},
  { 7.947911e-01, -1.420691e-03, -6.068814e-01,  4.932463e-02,  3.314158e-01, -4.165220e-01},
  {-9.807664e-01,  9.009383e-02, -1.731483e-01, -1.288370e-01,  3.386926e-01, -5.292414e-01},
  {-8.229415e-01,  1.289084e-01,  5.533081e-01, -3.702654e-01,  3.290963e-01, -5.402191e-01},
  {-9.558821e-01,  1.411172e-01, -2.576341e-01, -7.286597e-02,  3.433020e-01, -6.616620e-01},
  { 9.311749e-01,  3.059179e-01,  1.983117e-01,  9.671889e-02,  3.219935e-01, -8.551973e-01},
  { 8.951963e-02,  6.945429e-01, -7.138602e-01,  6.672162e-02,  3.296387e-01, -8.664597e-01},
  { 9.923857e-01, -7.406261e-02,  9.841385e-02,  4.712363e-01,  3.536955e-01,  7.844065e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.070503e-01,  3.643690e-01,  7.759047e-01},
  {-1.248858e-02,  3.192904e-01,  9.475747e-01,  2.514837e-01,  3.538146e-01,  7.883818e-01},
  {-6.276562e-01,  7.683809e-01, -1.250538e-01,  1.594378e-01,  3.385478e-01,  7.400667e-01},
  { 9.930280e-01,  8.941444e-02, -7.681442e-02,  4.756227e-01,  3.608757e-01,  7.455785e-01},
  { 8.985129e-01, -2.491250e-01,  3.614017e-01,  3.104399e-01,  3.596804e-01,  7.306294e-01},
  {-7.853965e-01,  6.054645e-01, -1.287054e-01,  2.143235e-01,  3.599138e-01,  7.012147e-01},
  {-3.748996e-01,  1.596733e-01,  9.132112e-01, -5.915934e-02,  3.559952e-01,  7.073605e-01},
  {-6.456450e-01,  1.938716e-01,  7.386178e-01, -7.491950e-02,  3.585022e-01,  6.950626e-01},
  {-6.595033e-01,  6.838494e-01,  3.120984e-01,  2.268641e-01,  3.590388e-01,  5.697792e-01},
  {-9.871938e-01, -1.176179e-01, -1.077705e-01, -2.876707e-02,  3.562051e-01,  5.157291e-01},
  {-4.140408e-01,  1.920583e-01,  8.897662e-01,  1.551409e-01,  3.573163e-01,  5.224694e-01},
  {-2.476194e-01,  1.619516e-02,  9.687220e-01,  1.481189e-01,  3.585283e-01,  5.187613e-01},
  { 3.603132e-01,  9.306901e-02,  9.281770e-01,  8.466755e-02,  3.458047e-01,  5.192735e-01},
  {-9.962658e-01, -8.612648e-02,  6.053443e-03, -2.445209e-02,  3.492874e-01,  4.910477e-01},
  { 5.724743e-01,  3.783032e-02,  8.190495e-01,  4.125009e-01,  3.590707e-01,  3.596576e-01},
  {-8.047014e-01,  4.876616e-01, -3.385880e-01,  9.256069e-02,  3.584136e-01,  3.402330e-01},
  { 8.462760e-01, -5.270624e-03,  5.327186e-01,  4.802337e-01,  3.602299e-01,  3.178483e-01},
  {-2.539741e-01, -1.387318e-01,  9.572098e-01, -1.315803e-01,  3.602299e-01,  2.743221e-01},
  {-8.087779e-02, -5.015937e-01,  8.613144e-01, -1.715161e-01,  3.404448e-01,  2.449650e-01},
  {-2.463393e-01,  9.677346e-01, -5.297836e-02, -2.836409e-01,  3.563927e-01,  1.503123e-01},
  {-6.930768e-01,  6.432933e-01,  3.252971e-01, -2.691525e-01,  3.616269e-01,  1.289142e-01},
  { 9.691712e-01, -2.227798e-01,  1.052449e-01,  2.653579e-01,  3.557422e-01,  1.110763e-01},
  { 1.427494e-01, -3.666026e-01, -9.193612e-01, -1.696528e-01,  3.443981e-01,  6.321037e-02},
  { 2.174508e-01, -2.833674e-01, -9.340333e-01, -1.965932e-01,  3.443761e-01,  5.836228e-02},
  { 5.358368e-01,  5.837875e-01, -6.099764e-01, -4.032350e-01,  3.506045e-01,  6.787866e-02},
  { 1.061914e-01, -4.004579e-01, -9.101411e-01, -4.127799e-02,  3.488831e-01,  5.515437e-02},
  {-3.160814e-02, -1.860474e-01, -9.820323e-01, -1.783090e-02,  3.568791e-01,  5.289836e-02},
  {-6.614263e-01,  6.869909e-01,  3.009298e-01, -3.395713e-01,  3.610291e-01,  1.401652e-02},
  {-8.803796e-01,  4.725423e-01,  4.044192e-02,  9.430394e-04,  3.564799e-01, -2.302063e-01},
  {-8.907384e-01,  3.237867e-01,  3.189785e-01, -3.539059e-01,  3.451642e-01, -2.447638e-01},
  { 7.039343e-01,  6.236604e-01, -3.398883e-01,  4.219686e-01,  3.420639e-01, -2.980198e-01},
  {-9.946394e-01,  2.320212e-02, -1.007680e-01, -1.310368e-01,  3.545095e-01, -5.193762e-01},
  { 3.391823e-01,  4.798605e-01,  8.091286e-01, -3.385276e-01,  3.541356e-01, -5.340915e-01},
  {-6.551652e-01,  5.115743e-01, -5.559229e-01, -3.428142e-01,  3.469731e-01, -5.775278e-01},
  {-4.253943e-01, -8.447703e-02, -9.010567e-01, -8.947932e-02,  3.431273e-01, -6.392531e-01},
  { 6.829362e-01, -1.864055e-01,  7.062940e-01,  2.098643e-01,  3.421357e-01, -6.645225e-01},
  { 6.256233e-01,  1.701081e-01, -7.613533e-01,  8.427979e-02,  3.570573e-01, -6.902435e-01},
  { 3.152940e-01,  1.462103e-01, -9.376632e-01,  2.169157e-01,  3.409438e-01, -7.105592e-01},
  { 6.687219e-01,  7.085409e-01, -2.253458e-01,  4.876591e-02,  3.548478e-01, -8.071925e-01},
  { 8.452613e-01,  4.049124e-01, -3.486821e-01,  4.358548e-02,  3.531163e-01, -8.568980e-01},
  { 1.137390e-01,  6.756014e-02, -9.912109e-01,  3.520762e-02,  3.482574e-01, -8.713475e-01},
  { 8.999157e-01,  2.572989e-01,  3.520637e-01,  4.754087e-01,  3.750139e-01,  7.917938e-01},
  {-2.181282e-01,  5.023034e-01,  8.367267e-01,  2.279691e-01,  3.653023e-01,  7.805812e-01},
  { 6.238475e-01, -1.426322e-01,  7.684206e-01,  3.095807e-01,  3.703948e-01,  7.690489e-01},
  {-6.332510e-01,  7.100475e-01,  3.079377e-01,  2.106098e-01,  3.713363e-01,  7.684726e-01},
  { 6.875876e-01,  1.183724e-01,  7.163877e-01, -2.762139e-02,  3.735935e-01,  6.929585e-01},
  {-9.141405e-01, -1.781536e-01,  3.641544e-01, -9.128608e-02,  3.669787e-01,  6.684484e-01},
  {-9.033415e-01, -4.104069e-01, -1.246612e-01, -9.522917e-02,  3.763355e-01,  6.458867e-01},
  { 9.055732e-01,  2.443641e-01, -3.467325e-01,  4.166624e-01,  3.664859e-01,  6.246915e-01},
  { 7.442464e-01,  6.561923e-01, -1.245350e-01,  3.847525e-01,  3.711656e-01,  5.630366e-01},
  {-8.738875e-01, -3.984051e-01, -2.785568e-01, -3.919565e-02,  3.649840e-01,  5.695894e-01},
  { 9.962286e-01, -7.140405e-02, -4.929644e-02,  3.815757e-01,  3.750300e-01,  5.385095e-01},
  {-7.401168e-01,  4.499892e-01,  4.997368e-01,  2.357095e-01,  3.749028e-01,  5.621823e-01},
  { 7.267290e-01,  5.477397e-01,  4.145433e-01,  3.852212e-01,  3.808976e-01,  5.180871e-01},
  { 2.023451e-01, -4.053553e-01,  8.914839e-01,  1.171611e-01,  3.647877e-01,  5.184180e-01},
  {-6.523374e-01, -2.499253e-01, -7.155371e-01, -9.370054e-02,  3.788993e-01,  4.290392e-01},
  {-6.706611e-01, -6.427548e-01, -3.702432e-01, -9.193765e-02,  3.869862e-01,  4.255424e-01},
  {-7.707363e-01,  1.558291e-01, -6.178048e-01,  8.971311e-02,  3.775816e-01,  3.537705e-01},
  {-9.375363e-01,  1.620755e-01, -3.078265e-01,  1.089081e-01,  3.840219e-01,  3.219644e-01},
  {-9.113370e-01,  4.100767e-01,  3.608119e-02,  1.086865e-01,  3.766352e-01,  3.077732e-01},
  { 1.091330e-01,  7.543063e-01,  6.473886e-01, -1.240612e-01,  3.704962e-01,  2.728684e-01},
  {-4.744393e-02,  3.732066e-01,  9.265344e-01,  2.980238e-02,  3.679706e-01,  2.503426e-01},
  {-4.065426e-01,  8.890989e-01, -2.103001e-01, -2.701252e-01,  3.742618e-01,  2.014804e-01},
  {-8.627171e-01,  5.056449e-01,  6.520936e-03, -4.063473e-01,  3.565509e-01,  2.083477e-01},
  {-7.824275e-03,  9.764286e-01,  2.156988e-01, -1.459566e-01,  3.790551e-01,  1.995961e-01},
  {-3.738925e-01,  9.097876e-01, -1.802522e-01, -2.650156e-01,  3.719339e-01,  1.859934e-01},
  {-6.285856e-01,  7.746443e-01, -6.932842e-02, -3.701921e-01,  3.638741e-01,  1.166531e-01},
  { 5.236046e-01, -3.013055e-01, -7.969022e-01,  5.318489e-01,  3.726029e-01,  1.170648e-01},
  {-1.343390e-01, -3.338532e-01, -9.330032e-01,  5.128312e-01,  3.816348e-01,  1.090684e-01},
  {-5.358368e-01, -5.837875e-01,  6.099764e-01, -3.827861e-01,  3.600647e-01,  9.489613e-02},
  {-6.489075e-01,  7.159343e-01,  2.575988e-01, -2.844850e-01,  3.751173e-01,  7.464983e-02},
  { 5.358368e-01,  5.837875e-01, -6.099764e-01, -4.012627e-01,  3.547150e-01,  7.354528e-02},
  { 4.173586e-01, -3.525642e-01, -8.375621e-01, -2.183522e-01,  3.608058e-01,  4.555380e-02},
  { 2.890606e-01, -3.639416e-01, -8.854324e-01, -6.906848e-02,  3.717776e-01,  4.375071e-02},
  { 2.446870e-01, -3.987873e-01, -8.837970e-01, -9.238923e-02,  3.771355e-01,  3.589593e-02},
  {-9.660913e-01,  2.578963e-01, -1.253350e-02,  5.913024e-02,  3.680766e-01, -1.144350e-05},
  { 4.938725e-02, -1.476930e-01, -9.877994e-01, -3.246891e-01,  3.785649e-01, -3.662403e-02},
  { 7.448330e-01,  4.821712e-02,  6.655065e-01, -2.283590e-01,  3.682156e-01, -3.335258e-01},
  { 2.979077e-02,  3.626275e-01,  9.314579e-01, -3.448558e-01,  3.565461e-01, -5.313641e-01},
  {-7.312108e-01,  6.507946e-01,  2.044436e-01, -3.585514e-01,  3.530603e-01, -5.354109e-01},
  {-7.531688e-01,  1.921481e-01,  6.291391e-01, -1.372164e-01,  3.697363e-01, -5.676277e-01},
  {-6.092525e-01,  2.016489e-01,  7.669088e-01, -1.391425e-01,  3.823878e-01, -5.751830e-01},
  { 8.533686e-01, -7.909826e-02,  5.152722e-01,  2.148543e-01,  3.641203e-01, -6.638613e-01},
  { 9.057400e-01,  1.750440e-01, -3.859983e-01,  6.019726e-02,  3.742308e-01, -7.231041e-01},
  {-8.658938e-01, -2.523252e-01, -4.319258e-01, -9.346782e-02,  3.729412e-01, -7.854906e-01},
  {-5.557053e-01, -4.935230e-01, -6.690491e-01, -7.156051e-02,  3.651904e-01, -7.972710e-01},
  {-9.237553e-01, -2.767267e-01, -2.647612e-01, -9.413210e-02,  3.827843e-01, -7.924779e-01},
  { 3.310970e-01,  3.035020e-01, -8.934548e-01,  2.254297e-02,  3.709396e-01, -8.698910e-01},
  {-5.644116e-01, -2.244770e-02,  8.251882e-01,  4.633636e-01,  3.823802e-01,  7.868043e-01},
  {-7.930348e-01,  5.025822e-01,  3.442484e-01,  2.114491e-01,  3.781056e-01,  7.604604e-01},
  { 1.496672e-01,  2.741597e-01,  9.499665e-01, -3.877053e-02,  3.778982e-01,  7.031887e-01},
  { 6.121179e-01, -5.223526e-02,  7.890394e-01, -3.502797e-02,  3.891766e-01,  6.961431e-01},
  {-7.682400e-01,  3.958042e-02,  6.389371e-01, -8.536898e-02,  3.850085e-01,  6.751434e-01},
  {-9.058419e-01,  4.227834e-01,  2.654394e-02,  2.579787e-01,  3.927558e-01,  6.070008e-01},
  { 7.657294e-01, -3.752991e-01,  5.223113e-01,  4.550976e-02,  3.814174e-01,  5.700148e-01},
  { 2.895603e-01, -7.182583e-01,  6.326609e-01,  7.560489e-02,  3.777837e-01,  5.369883e-01},
  { 6.991847e-01,  3.402331e-01,  6.287943e-01,  3.935906e-01,  3.976206e-01,  4.984510e-01},
  { 5.070556e-01,  4.137872e-01,  7.560918e-01, -1.745304e-01,  3.940230e-01,  2.966732e-01},
  {-1.916261e-01,  9.957849e-02,  9.764034e-01, -2.957489e-01,  3.887085e-01,  2.791439e-01},
  {-4.358254e-01,  4.776837e-01,  7.628070e-01, -3.194198e-01,  3.801171e-01,  2.765192e-01},
  { 1.853274e-01,  6.863872e-01,  7.032256e-01, -7.917374e-02,  3.728236e-01,  2.639128e-01},
  { 1.322550e-01,  6.895659e-01,  7.120446e-01, -7.552397e-02,  3.756860e-01,  2.606822e-01},
  { 1.461775e-01,  4.691231e-01,  8.709510e-01, -2.763797e-02,  3.778250e-01,  2.462111e-01},
  { 1.442943e-02,  9.528384e-01,  3.031349e-01, -9.172609e-02,  3.835297e-01,  2.500984e-01},
  {-1.513632e-01,  9.696567e-01, -1.919769e-01, -3.016427e-01,  3.870740e-01,  2.521531e-01},
  {-5.264286e-01,  8.119236e-01,  2.522957e-01, -3.884284e-01,  3.723602e-01,  2.141752e-01},
  {-1.439405e-01,  8.786691e-01,  4.552160e-01, -6.761364e-02,  3.916254e-01,  1.978336e-01},
  { 2.855617e-01,  9.299960e-01,  2.314348e-01, -1.795317e-01,  3.922063e-01,  1.930815e-01},
  {-5.799773e-01,  7.694642e-01, -2.674902e-01, -3.925146e-01,  3.687368e-01,  1.957650e-01},
  {-3.494843e-01, -3.131881e-01, -8.830481e-01,  3.961967e-01,  3.905345e-01,  1.637560e-01},
  {-3.304582e-01,  6.447065e-01,  6.893119e-01, -1.165185e-01,  3.950520e-01,  1.640396e-01},
  { 9.899472e-02,  8.878662e-01,  4.493257e-01, -1.399855e-01,  3.914194e-01,  1.647993e-01},
  {-6.514062e-01,  6.812914e-01, -3.339342e-01, -3.760502e-01,  3.716299e-01,  1.642095e-01},
  { 9.999078e-01,  2.354757e-03,  1.337989e-02,  2.706178e-01,  3.948474e-01,  1.016176e-01},
  { 1.357654e-01, -3.943955e-01, -9.088564e-01,  5.263831e-01,  4.043508e-01,  9.921543e-02},
  {-2.950285e-01,  3.095168e-02, -9.549870e-01, -3.678760e-01,  3.735297e-01, -3.298883e-02},
  { 8.796138e-01,  1.792253e-01,  4.406334e-01,  3.890079e-01,  3.794954e-01, -6.977127e-02},
  {-5.766120e-01,  7.902833e-01, -2.072940e-01, -3.341017e-01,  3.926843e-01, -3.747012e-02},
  { 7.681237e-01,  2.993286e-01, -5.660286e-01,  3.701062e-01,  4.032886e-01, -2.537667e-01},
  { 7.714759e-01,  3.826666e-01, -5.083219e-01,  3.629836e-01,  4.042701e-01, -2.616441e-01},
  {-7.670398e-01,  2.281614e-01, -5.996602e-01, -3.286992e-01,  3.905501e-01, -2.772519e-01},
  {-2.692178e-02,  6.924232e-01, -7.209891e-01,  4.256233e-02,  3.771496e-01, -4.057292e-01},
  { 4.028103e-01,  4.937358e-01,  7.706938e-01, -3.219651e-02,  3.876555e-01, -5.193043e-01},
  { 2.828349e-01,  5.876653e-01,  7.580594e-01, -3.178878e-01,  3.721062e-01, -5.501194e-01},
  {-3.149480e-01,  9.379675e-01,  1.449992e-01, -3.356471e-01,  3.692065e-01, -5.542874e-01},
  {-7.428786e-01,  2.772294e-01,  6.093234e-01, -1.324057e-01,  3.981345e-01, -5.740255e-01},
  { 4.641015e-01, -2.344093e-02,  8.854718e-01,  1.553167e-01,  3.829507e-01, -6.177376e-01},
  {-6.251801e-01,  7.765502e-01, -7.822771e-02, -2.501316e-01,  3.898098e-01, -6.246125e-01},
  { 9.541815e-01,  7.578164e-02,  2.894732e-01,  2.136863e-01,  3.771856e-01, -6.588185e-01},
  {-6.558825e-01,  7.343993e-02, -7.512820e-01, -7.244057e-02,  3.856411e-01, -6.562293e-01},
  { 8.535115e-02, -5.318890e-01, -8.425018e-01,  1.011067e-01,  3.819646e-01, -6.923146e-01},
  { 9.792550e-01, -1.265877e-02, -2.022359e-01,  4.860340e-02,  3.872833e-01, -7.587376e-01},
  {-2.103159e-01, -3.076514e-01, -9.279644e-01, -3.884189e-02,  3.978255e-01, -8.589891e-01},
  { 2.860217e-01, -2.778287e-01,  9.170620e-01,  3.301265e-01,  4.002539e-01,  7.046360e-01},
  {-3.798677e-01,  3.884964e-01,  8.395064e-01, -5.060460e-02,  4.016724e-01,  6.919757e-01},
  {-9.838281e-01,  1.285777e-01, -1.246991e-01,  2.564607e-01,  4.068424e-01,  6.527892e-01},
  { 9.404712e-01, -6.788994e-02, -3.330238e-01,  3.918043e-01,  4.028686e-01,  5.818083e-01},
  {-9.548199e-01,  1.372461e-01,  2.635953e-01,  2.563093e-01,  4.140566e-01,  5.771899e-01},
  { 2.148929e-01,  1.196790e-01,  9.692770e-01,  1.504741e-01,  4.070775e-01,  5.382537e-01},
  {-5.015023e-01,  3.575841e-01,  7.878002e-01,  2.207382e-01,  4.072576e-01,  5.329024e-01},
  { 4.039538e-03,  3.507414e-01,  9.364635e-01,  1.858349e-01,  4.087967e-01,  5.274994e-01},
  {-8.378506e-01, -5.386395e-01, -8.873403e-02, -5.172339e-02,  4.020502e-01,  5.355272e-01},
  {-7.695140e-01, -5.432596e-01,  3.357338e-01, -5.364539e-02,  4.026155e-01,  5.007319e-01},
  {-5.598004e-01, -7.991673e-01,  2.189862e-01, -1.327835e-01,  4.169077e-01,  4.594122e-01},
  {-4.586200e-01, -2.143469e-01, -8.623938e-01,  3.899032e-02,  4.081299e-01,  3.906142e-01},
  { 8.722934e-01, -1.559337e-01,  4.634535e-01,  3.971708e-01,  4.099278e-01,  3.780587e-01},
  {-5.284983e-01,  8.402631e-01, -1.210269e-01, -2.684377e-01,  4.096238e-01,  2.858275e-01},
  {-9.106255e-01,  1.046280e-01,  3.997677e-01,  1.076324e-01,  4.145699e-01,  2.557396e-01},
  {-3.283710e-01,  8.597487e-01,  3.911581e-01, -3.464787e-01,  3.796603e-01,  2.413169e-01},
  {-8.314196e-01,  1.141415e-01,  5.437952e-01,  9.748646e-02,  4.147186e-01,  2.410338e-01},
  {-1.640568e-01,  5.204915e-01,  8.379582e-01,  1.002131e-02,  4.089219e-01,  2.048082e-01},
  {-1.915026e-01,  7.325428e-01,  6.532288e-01, -1.566876e-01,  4.221746e-01,  1.221545e-01},
  { 1.166943e-01,  9.218532e-01,  3.695526e-01, -1.896699e-01,  4.127241e-01,  1.281006e-01},
  { 8.851798e-01, -2.082407e-01, -4.160439e-01,  5.388880e-01,  4.208423e-01,  9.950049e-02},
  { 9.911339e-01,  1.128656e-01,  7.010591e-02,  2.698152e-01,  4.083066e-01,  8.419988e-02},
  { 2.760411e-01, -5.138940e-01, -8.122279e-01, -1.570117e-01,  4.090781e-01,  3.104503e-03},
  {-7.078860e-01,  6.321747e-01, -3.150435e-01, -3.330409e-01,  4.081149e-01, -2.730548e-02},
  { 9.239882e-01,  3.302902e-01,  1.927540e-01,  4.015962e-01,  4.074541e-01, -1.521465e-01},
  { 9.643273e-01,  2.591544e-01, -5.396320e-02,  4.100738e-01,  4.002498e-01, -1.923169e-01},
  { 3.573442e-01,  1.162954e-01,  9.267040e-01, -2.993790e-01,  4.091547e-01, -2.591473e-01},
  { 3.611152e-01,  3.656385e-01,  8.578486e-01, -2.550329e-02,  4.107640e-01, -5.326664e-01},
  { 5.229136e-01, -1.912505e-02,  8.521712e-01,  1.196926e-01,  4.120514e-01, -5.987756e-01},
  { 5.283329e-01, -4.097396e-02,  8.480480e-01,  1.833066e-01,  4.062627e-01, -6.378293e-01},
  {-7.700902e-01,  3.466390e-02, -6.369926e-01, -2.275226e-01,  4.174962e-01, -6.822296e-01},
  { 2.116965e-01, -4.237710e-01, -8.806831e-01,  1.546514e-01,  4.131438e-01, -7.117927e-01},
  { 5.968367e-01, -4.962406e-01, -6.305007e-01,  7.669862e-02,  3.974123e-01, -7.099434e-01},
  {-9.220496e-01,  3.784275e-01,  8.134575e-02, -3.815398e-02,  4.079118e-01, -7.121550e-01},
  {-9.086672e-01,  3.332008e-01,  2.515972e-01, -9.144022e-02,  3.977144e-01, -7.847801e-01},
  {-9.865158e-01, -8.304942e-02, -1.410299e-01, -9.327406e-02,  4.038067e-01, -8.204879e-01},
  {-6.982723e-01, -6.362524e-01, -3.280220e-01, -9.170926e-02,  4.044742e-01, -8.270107e-01},
  { 4.534330e-01,  2.573828e-01, -8.533186e-01, -4.183055e-03,  4.133855e-01, -8.551279e-01},
  {-4.602141e-01, -5.652069e-01, -6.846490e-01, -7.497958e-02,  4.049616e-01, -8.514191e-01},
  {-1.078200e-01,  1.952764e-01, -9.748036e-01, -5.422574e-02,  4.095147e-01, -8.583914e-01},
  {-1.608571e-01,  4.603299e-01, -8.730530e-01, -6.715084e-02,  4.094662e-01, -8.566600e-01},
  { 9.950367e-01,  5.229592e-02,  8.465914e-02,  4.673300e-01,  4.373477e-01,  7.623088e-01},
  {-6.273342e-01,  4.187903e-01,  6.565565e-01,  2.326257e-01,  4.255663e-01,  7.438133e-01},
  { 8.497542e-01, -2.997395e-01,  4.336750e-01,  3.249934e-01,  4.196294e-01,  7.223440e-01},
  {-4.011416e-01, -1.407404e-01,  9.051395e-01,  3.774137e-01,  4.155129e-01,  7.037336e-01},
  { 9.428767e-01, -7.497696e-02, -3.245951e-01,  4.166225e-01,  4.167360e-01,  6.299876e-01},
  {-8.102168e-01,  1.971631e-01,  5.519742e-01, -1.234847e-01,  4.246544e-01,  6.190589e-01},
  { 7.610859e-01,  1.888405e-01,  6.205541e-01,  1.222968e-01,  4.287089e-01,  5.519281e-01},
  {-9.533382e-01, -9.853835e-02,  2.853707e-01,  2.424867e-01,  4.350587e-01,  5.446497e-01},
  {-4.915715e-01,  3.788157e-01,  7.841277e-01,  2.129733e-01,  4.312609e-01,  5.168144e-01},
  { 9.781063e-01,  1.288246e-01,  1.634390e-01,  3.841693e-01,  4.269856e-01,  4.959136e-01},
  {-4.950404e-01, -7.874717e-01,  3.671828e-01, -7.608540e-02,  4.135778e-01,  4.852951e-01},
  {-9.687740e-01, -1.455106e-01, -2.007576e-01,  1.092720e-01,  4.351028e-01,  3.033611e-01},
  { 4.337908e-01,  8.986189e-01,  6.564959e-02, -1.963406e-01,  4.121913e-01,  2.894942e-01},
  {-4.872842e-01,  8.150781e-01, -3.133717e-01, -2.624639e-01,  4.146260e-01,  2.947477e-01},
  {-3.042265e-01,  9.437752e-01, -1.293618e-01, -2.522141e-01,  4.182185e-01,  2.699188e-01},
  { 1.033631e-01,  9.872473e-01, -1.210732e-01, -2.219699e-01,  4.095601e-01,  2.236612e-01},
  {-5.043448e-01,  8.478919e-01,  1.634496e-01, -2.232673e-01,  4.143307e-01,  1.640901e-01},
  {-4.421650e-01, -1.095667e-01,  8.902164e-01, -7.551563e-02,  4.355837e-01,  1.601075e-01},
  {-7.702105e-01,  3.646545e-01,  5.232618e-01, -2.485520e-01,  4.187307e-01,  1.402686e-01},
  { 5.502407e-01, -3.281476e-01, -7.678244e-01,  5.334162e-01,  4.313374e-01,  8.276835e-02},
  { 4.490904e-02,  1.205673e-01, -9.916888e-01,  1.923442e-02,  4.326894e-01,  6.847537e-02},
  {-9.484560e-01,  2.924274e-01,  1.221371e-01,  8.265477e-02,  4.265443e-01, -1.879039e-02},
  {-8.479371e-01,  1.949531e-02, -5.297384e-01, -3.159800e-01,  4.386724e-01, -5.258678e-02},
  {-2.574309e-01,  6.836075e-01,  6.829423e-01, -3.008158e-01,  4.278659e-01, -2.637662e-01},
  {-7.526904e-01,  6.401740e-01,  1.537345e-01, -3.192798e-01,  4.126345e-01, -2.628119e-01},
  { 2.276556e-01,  7.239196e-02,  9.710470e-01, -2.842775e-01,  4.300660e-01, -2.658775e-01},
  {-7.376714e-01,  3.683086e-01, -5.658530e-01, -3.190848e-01,  4.121047e-01, -2.805972e-01},
  {-7.460355e-01,  5.752094e-01, -3.355075e-01, -3.025620e-01,  4.234350e-01, -2.914640e-01},
  {-1.333105e-01, -3.388505e-02, -9.904949e-01,  3.064136e-01,  4.301071e-01, -3.893129e-01},
  {-9.600176e-01, -8.642507e-02, -2.662644e-01, -1.288588e-01,  4.349154e-01, -5.518419e-01},
  { 5.369757e-01, -7.749954e-01, -3.332253e-01,  6.765171e-02,  4.164628e-01, -7.459735e-01},
  {-6.666137e-01, -3.415922e-01, -6.625261e-01, -9.163201e-02,  4.143219e-01, -8.394900e-01},
  {-6.146157e-01,  7.731091e-01, -1.566839e-01, -8.875245e-02,  4.164226e-01, -8.433207e-01},
  {-5.753856e-01, -4.587745e-02, -8.165945e-01, -8.055492e-02,  4.179346e-01, -8.482195e-01},
  {-9.015787e-01, -1.897048e-01,  3.888032e-01,  2.233243e-01,  4.484050e-01,  7.209657e-01},
  {-9.685004e-01, -5.607834e-02,  2.426151e-01, -1.309010e-01,  4.428264e-01,  5.955757e-01},
  { 6.959035e-01, -5.580213e-02,  7.159640e-01,  1.034325e-01,  4.309608e-01,  5.750366e-01},
  { 2.561083e-01,  2.311905e-01,  9.385945e-01,  4.754048e-01,  4.533725e-01,  4.553743e-01},
  { 5.592354e-01,  1.786500e-01,  8.095307e-01,  3.982962e-01,  4.505506e-01,  4.750273e-01},
  { 8.386917e-01, -3.575002e-01, -4.108405e-01,  4.099009e-01,  4.381794e-01,  3.926490e-01},
  { 8.278360e-01, -2.210661e-01,  5.155749e-01,  4.142734e-01,  4.471781e-01,  3.538811e-01},
  {-6.748409e-01, -3.845129e-01, -6.298727e-01,  9.627658e-02,  4.480131e-01,  3.189149e-01},
  {-4.663124e-01,  7.503635e-01, -4.685161e-01, -2.443167e-01,  4.285216e-01,  2.989406e-01},
  {-2.039988e-01,  9.651110e-01, -1.641497e-01, -2.349313e-01,  4.300443e-01,  2.920381e-01},
  {-3.749623e-01,  1.420164e-01,  9.160974e-01,  9.472669e-02,  4.452605e-01,  2.254408e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -2.579377e-01,  4.309814e-01,  1.152805e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -2.583732e-01,  4.350182e-01,  1.159476e-01},
  {-4.024153e-01,  7.946610e-01,  4.545062e-01, -2.574086e-01,  4.367478e-01,  1.072969e-01},
  { 9.948108e-01, -3.519909e-02,  9.545923e-02,  2.701389e-01,  4.465623e-01,  8.609184e-02},
  {-5.704840e-01,  6.758174e-01,  4.667107e-01, -2.686116e-01,  4.429596e-01,  6.934055e-02},
  {-6.061183e-01,  3.374627e-01, -7.202358e-01,  7.893061e-02,  4.433508e-01,  5.734382e-02},
  {-2.349767e-01,  7.186614e-01,  6.544552e-01, -1.995046e-01,  4.498804e-01,  8.428334e-02},
  {-8.842454e-01,  4.330873e-01, -1.747729e-01,  3.135982e-02,  4.367305e-01, -2.740566e-01},
  { 7.036888e-01, -9.169064e-02,  7.045671e-01, -2.626522e-01,  4.473381e-01, -2.744063e-01},
  { 9.065180e-01, -3.393629e-01, -2.511131e-01,  3.502865e-01,  4.515025e-01, -2.969440e-01},
  {-2.102754e-03,  6.471267e-03, -9.999768e-01,  1.850155e-01,  4.429806e-01, -3.463139e-01},
  { 4.441234e-01,  2.455167e-01,  8.616705e-01,  2.287231e-02,  4.535714e-01, -5.661828e-01},
  { 4.991900e-01, -6.521065e-01, -5.705842e-01,  2.159671e-01,  4.482999e-01, -7.364713e-01},
  { 1.804297e-01, -3.235280e-01, -9.288566e-01, -2.048997e-01,  4.553712e-01, -7.086510e-01},
  { 5.646412e-01, -7.460108e-01, -3.530557e-01,  8.925381e-02,  4.374921e-01, -7.495450e-01},
  { 5.595340e-01, -6.314216e-01, -5.368692e-01,  2.135745e-01,  4.585010e-01, -7.532263e-01},
  { 5.820929e-01, -6.720223e-01, -4.577705e-01,  8.324593e-02,  4.415282e-01, -7.704993e-01},
  {-6.628697e-01,  7.479706e-01,  3.381828e-02, -7.264040e-02,  4.311461e-01, -8.027994e-01},
  { 4.694714e-01, -6.535428e-01, -5.936989e-01,  4.497649e-02,  4.474044e-01, -8.362759e-01},
  {-4.570245e-01,  8.104010e-01, -3.665771e-01, -7.365995e-02,  4.341089e-01, -8.327022e-01},
  {-2.416517e-01,  7.852340e-01, -5.700983e-01, -1.969788e-02,  4.439360e-01, -8.370737e-01},
  { 1.493805e-01, -1.834933e-01, -9.716048e-01,  1.816902e-02,  4.465355e-01, -8.442130e-01},
  { 7.793621e-01,  1.195050e-01,  6.150717e-01,  4.912553e-02,  4.554952e-01,  6.326666e-01},
  { 9.187012e-01, -1.783409e-01, -3.523957e-01,  4.613222e-01,  4.781063e-01,  6.234339e-01},
  {-4.596259e-01,  5.565568e-01,  6.920900e-01, -8.723292e-02,  4.711811e-01,  5.952820e-01},
  {-3.970328e-01,  8.998025e-01, -1.808880e-01, -1.727955e-01,  4.696984e-01,  5.239763e-01},
  {-7.135713e-01,  2.198283e-01,  6.652004e-01,  1.979062e-01,  4.732858e-01,  4.853557e-01},
  {-3.224402e-01, -3.745864e-01, -8.693201e-01, -2.924603e-03,  4.599180e-01,  3.946162e-01},
  {-5.391314e-01, -3.312080e-01,  7.743633e-01, -1.061767e-01,  4.635648e-01,  1.482960e-01},
  {-7.037116e-01,  8.481936e-02,  7.054046e-01, -1.542624e-01,  4.698662e-01,  1.004300e-01},
  { 9.860809e-01, -4.403654e-03,  1.662080e-01,  2.753314e-01,  4.694740e-01,  6.471599e-02},
  { 3.601748e-01, -1.624213e-01, -9.186367e-01, -5.246948e-02,  4.531960e-01,  4.667770e-02},
  {-8.644288e-01,  3.188032e-01,  3.887512e-01, -3.075310e-01,  4.638940e-01, -9.465488e-03},
  { 3.609556e-01, -2.140127e-01, -9.076947e-01, -2.214746e-01,  4.630434e-01, -6.237132e-02},
  {-6.431646e-01,  5.971841e-01, -4.792812e-01, -2.743300e-01,  4.578047e-01, -3.017277e-01},
  { 8.040732e-01, -5.028033e-01, -3.172620e-01,  3.511440e-01,  4.620652e-01, -3.744275e-01},
  { 4.990458e-01, -2.880978e-01, -8.172838e-01,  3.443247e-01,  4.667231e-01, -3.882589e-01},
  {-1.369445e-01, -3.708033e-02, -9.898844e-01,  3.151613e-01,  4.627594e-01, -3.919816e-01},
  { 5.455883e-01, -1.667661e-01,  8.212932e-01, -4.161653e-02,  4.743039e-01, -5.351089e-01},
  {-9.817490e-01,  4.242806e-02,  1.853878e-01, -1.288818e-01,  4.650969e-01, -5.926273e-01},
  {-8.637183e-01,  2.779988e-01,  4.203657e-01, -1.411384e-01,  4.644014e-01, -6.206179e-01},
  {-6.156185e-01,  6.638075e-01,  4.247040e-01, -2.009580e-01,  4.621092e-01, -6.684354e-01},
  {-9.732913e-01,  2.295127e-01,  5.291136e-03, -1.875655e-02,  4.658461e-01, -6.999113e-01},
  {-7.096003e-01,  6.460239e-01, -2.812837e-01, -3.504327e-02,  4.693819e-01, -7.680299e-01},
  {-3.592437e-01,  8.995783e-01, -2.484007e-01,  4.200487e-02,  4.694196e-01, -7.778642e-01},
  { 3.762613e-01, -3.150300e-01, -8.713114e-01,  4.397842e-02,  4.574531e-01, -8.418866e-01},
  { 1.160851e-01, -3.331201e-01,  9.357111e-01,  3.161519e-01,  4.769902e-01,  7.918123e-01},
  { 7.349805e-01, -4.958773e-01,  4.625033e-01,  3.379699e-01,  4.768927e-01,  7.644666e-01},
  { 7.735950e-01,  2.361949e-01,  5.880160e-01,  2.502606e-02,  4.823887e-01,  6.524271e-01},
  {-6.173660e-01, -7.148421e-01,  3.284205e-01, -1.586691e-01,  4.797557e-01,  5.522193e-01},
  {-7.618363e-01, -2.599299e-01,  5.933311e-01,  2.152337e-01,  4.864903e-01,  5.091898e-01},
  { 6.445391e-01,  2.618030e-01,  7.183514e-01,  8.929490e-02,  4.888605e-01,  4.983582e-01},
  {-4.274271e-01,  5.324231e-01,  7.306380e-01,  1.834099e-01,  4.866552e-01,  4.612575e-01},
  { 9.380478e-02,  6.257892e-01,  7.743311e-01,  1.413695e-01,  4.781584e-01,  4.644262e-01},
  {-9.432049e-01, -2.272751e-01, -2.423028e-01,  1.151236e-01,  4.843878e-01,  2.660179e-01},
  {-9.186335e-01,  4.552162e-02,  3.924796e-01,  1.084209e-01,  4.811093e-01,  2.400513e-01},
  { 8.638373e-01, -1.787622e-01, -4.709873e-01,  2.940356e-01,  4.858901e-01,  1.189043e-01},
  {-3.779191e-01, -3.539574e-01, -8.555064e-01,  4.663377e-01,  4.743335e-01,  9.966693e-02},
  { 9.885392e-01,  1.323989e-01,  7.253110e-02,  2.747901e-01,  4.917059e-01,  6.109159e-02},
  {-9.338033e-01,  3.527887e-01, -5.959408e-02,  1.157241e-01,  4.931843e-01,  3.015620e-02},
  {-5.346246e-01,  4.663779e-01,  7.047469e-01, -1.936747e-01,  4.863149e-01,  5.648414e-02},
  {-5.921461e-01,  6.327247e-01,  4.990215e-01, -2.636553e-01,  4.877942e-01,  2.947772e-03},
  { 1.721280e-01, -3.999379e-01, -9.002342e-01, -2.761891e-01,  4.882790e-01, -7.982224e-02},
  {-3.311339e-01,  6.115981e-01,  7.185389e-01, -2.832405e-01,  4.661456e-01, -2.556720e-01},
  { 2.368226e-01,  8.879426e-01,  3.943008e-01, -2.300955e-01,  4.720768e-01, -3.262600e-01},
  {-7.450140e-01,  6.065280e-01, -2.776291e-01, -2.354594e-01,  4.731551e-01, -3.545098e-01},
  {-2.983998e-01,  7.434222e-02, -9.515413e-01,  1.635037e-01,  4.838474e-01, -3.606077e-01},
  { 4.629763e-01, -2.922232e-02, -8.858888e-01,  3.682410e-01,  4.873086e-01, -4.034281e-01},
  { 3.868871e-02, -3.261053e-01, -9.445415e-01,  3.495753e-01,  4.783808e-01, -3.976810e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  3.681813e-01,  4.839948e-01, -4.106873e-01},
  {-1.363991e-01,  9.568213e-02, -9.860224e-01, -4.607928e-02,  4.806373e-01, -6.566678e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -2.054614e-01,  4.784350e-01, -7.162301e-01},
  {-6.838980e-01, -9.079389e-02, -7.239060e-01, -3.585128e-02,  4.886126e-01, -7.552205e-01},
  { 4.171306e-01, -3.234370e-01,  8.493472e-01, -2.008654e-01,  4.829222e-01, -7.181997e-01},
  { 1.383393e-01, -7.677754e-01, -6.256064e-01,  1.527634e-01,  4.731491e-01, -7.660860e-01},
  {-3.418729e-01,  7.892442e-01, -5.101142e-01,  6.198246e-02,  4.840238e-01, -7.640818e-01},
  {-3.058610e-01,  9.509653e-01, -4.597647e-02,  6.570822e-02,  4.806769e-01, -7.849158e-01},
  { 6.760145e-01, -2.656394e-01, -6.873428e-01,  2.137634e-01,  4.825436e-01, -7.771924e-01},
  {-3.376364e-01,  5.555876e-01, -7.598183e-01,  3.622562e-02,  4.736659e-01, -8.395600e-01},
  {-2.291333e-01, -2.783347e-01,  9.327528e-01,  3.073053e-01,  4.907883e-01,  7.913320e-01},
  {-6.152132e-01, -6.553782e-02,  7.856318e-01,  2.240525e-01,  4.903322e-01,  7.318950e-01},
  { 1.779144e-01,  4.495646e-01,  8.753503e-01,  8.585494e-03,  4.820426e-01,  6.680840e-01},
  { 7.382157e-01,  2.069249e-01,  6.420432e-01,  3.188482e-02,  4.876657e-01,  6.371778e-01},
  { 9.128512e-01, -1.629693e-01, -3.743576e-01,  4.701413e-01,  4.994805e-01,  6.285026e-01},
  {-5.786107e-01,  3.670370e-01,  7.283497e-01, -1.962935e-02,  5.019968e-01,  6.250200e-01},
  {-5.580397e-01,  7.348588e-01,  3.854534e-01, -1.484779e-01,  4.851570e-01,  5.576703e-01},
  { 4.953870e-01,  3.815652e-01,  7.803843e-01,  4.864982e-01,  5.041040e-01,  4.505941e-01},
  { 8.560722e-01,  5.437643e-02, -5.139879e-01,  4.912525e-01,  4.987409e-01,  4.489965e-01},
  { 9.617863e-01,  1.261567e-01, -2.430054e-01,  4.873694e-01,  5.043248e-01,  4.443619e-01},
  {-1.615578e-01,  3.360739e-01,  9.278757e-01,  1.687198e-01,  5.144340e-01,  4.398368e-01},
  {-5.332612e-01, -3.670188e-01, -7.621875e-01, -9.576291e-02,  4.978609e-01,  4.092355e-01},
  {-1.759855e-01, -2.401220e-01, -9.546573e-01,  4.573785e-02,  4.928812e-01,  3.338437e-01},
  { 9.218025e-01,  1.903164e-01,  3.377275e-01,  5.388021e-01,  5.023681e-01,  1.507720e-01},
  { 1.786252e-01, -3.330457e-01, -9.258367e-01,  3.283109e-01,  5.064561e-01,  1.316324e-01},
  { 8.507075e-01, -2.064095e-01, -4.834167e-01,  2.819421e-01,  5.034595e-01,  8.957956e-02},
  {-2.455415e-01,  1.823618e-01, -9.520786e-01,  8.597971e-02,  5.063524e-01,  7.251828e-02},
  {-7.423712e-01,  3.891066e-01, -5.454181e-01,  1.080179e-01,  5.008357e-01,  5.892116e-02},
  { 2.249348e-01, -4.465654e-01, -8.660160e-01,  5.340477e-01,  5.167331e-01,  5.285867e-02},
  { 9.962611e-01,  7.788507e-02, -3.738590e-02,  2.721695e-01,  5.032391e-01,  4.990910e-02},
  {-6.926966e-01,  3.445497e-01,  6.336063e-01, -2.086667e-01,  4.983706e-01,  3.445365e-02},
  {-7.843134e-01,  3.569100e-01, -5.074128e-01, -3.130477e-01,  4.928994e-01, -6.486506e-02},
  {-2.450513e-01,  2.454629e-02, -9.691993e-01, -2.825558e-01,  4.915565e-01, -8.371604e-02},
  { 2.806132e-02,  2.650035e-01, -9.638391e-01, -2.778033e-01,  4.931641e-01, -8.443440e-02},
  {-1.594705e-01, -9.626992e-01, -2.185849e-01,  5.314450e-01,  5.151153e-01, -1.178301e-01},
  { 7.572837e-01, -6.200826e-01, -2.049856e-01,  5.344771e-01,  5.246702e-01, -1.114760e-01},
  { 1.026139e-01, -9.798638e-01,  1.712810e-01,  4.465518e-01,  5.062995e-01, -3.449665e-01},
  {-6.667547e-01,  4.191162e-01, -6.162628e-01,  1.345464e-01,  5.046657e-01, -3.357308e-01},
  { 6.622051e-01,  2.485621e-02, -7.489102e-01,  3.852174e-01,  4.981981e-01, -3.680647e-01},
  { 5.174928e-01, -2.796831e-01, -8.086894e-01,  3.993217e-01,  5.069106e-01, -3.567033e-01},
  { 4.008168e-01, -8.231434e-01, -4.022198e-01,  4.505616e-01,  5.087349e-01, -3.564794e-01},
  {-5.156130e-01,  8.132074e-01,  2.698831e-01, -2.221197e-01,  4.826139e-01, -3.764700e-01},
  { 8.667156e-01,  1.596351e-01, -4.725682e-01,  3.721857e-01,  4.989327e-01, -3.869882e-01},
  {-9.421558e-01,  1.901716e-01, -2.760022e-01, -2.250806e-01,  5.030783e-01, -4.301903e-01},
  {-8.983340e-01,  4.069843e-01, -1.654082e-01, -5.693356e-03,  5.095242e-01, -6.871431e-01},
  {-5.545640e-01,  3.181130e-01, -7.689362e-01, -1.570119e-01,  5.048779e-01, -6.937197e-01},
  { 7.038398e-01,  4.889347e-01,  5.153180e-01,  2.178218e-01,  4.862270e-01, -7.221881e-01},
  {-5.643969e-01,  7.416038e-01,  3.626017e-01, -1.809598e-01,  4.912502e-01, -7.053974e-01},
  { 9.791559e-01,  1.968541e-01, -5.002189e-02,  2.238477e-01,  4.846766e-01, -7.367196e-01},
  { 7.055394e-02,  4.387348e-01, -8.958426e-01,  4.954056e-02,  5.015868e-01, -7.462053e-01},
  {-5.776532e-01,  6.128087e-01,  5.392424e-01, -1.949641e-01,  4.889991e-01, -7.187839e-01},
  {-9.685655e-01,  2.206763e-01, -1.148172e-01, -3.776061e-02,  5.017770e-01, -7.568896e-01},
  { 7.090374e-01,  5.394293e-01, -4.541829e-01,  2.083208e-01,  4.906168e-01, -7.847473e-01},
  {-3.840603e-02,  6.502349e-01, -7.587618e-01,  8.870346e-02,  4.891245e-01, -8.386981e-01},
  {-4.108911e-01,  9.039031e-01, -1.188605e-01,  4.556740e-02,  4.844785e-01, -8.344939e-01},
  {-4.774240e-01,  5.572857e-01,  6.793371e-01,  3.204963e-01,  5.048432e-01,  7.919803e-01},
  { 4.189689e-01, -4.406132e-01,  7.939302e-01,  4.815091e-01,  5.338718e-01,  7.800007e-01},
  {-4.289916e-01,  5.366113e-01,  7.266461e-01,  2.861810e-01,  5.056184e-01,  7.672284e-01},
  { 1.399477e-01, -5.179710e-01,  8.438725e-01,  3.872408e-01,  4.976797e-01,  7.465912e-01},
  { 6.424535e-01,  5.208337e-01,  5.621262e-01,  1.097425e-02,  4.987711e-01,  6.453968e-01},
  {-5.961729e-01,  7.948965e-01,  1.127720e-01, -8.308406e-02,  5.289847e-01,  5.167022e-01},
  { 9.946803e-01,  5.407830e-02, -8.767343e-02,  3.876665e-01,  5.229750e-01,  4.992609e-01},
  { 7.831004e-01, -3.283802e-01, -5.281290e-01,  4.676788e-01,  5.168360e-01,  4.058748e-01},
  { 9.927118e-01,  1.248905e-02,  1.198632e-01,  4.744997e-01,  5.091876e-01,  2.771486e-01},
  {-7.405567e-01, -7.862904e-02,  6.673779e-01,  9.096230e-02,  5.294005e-01,  2.316149e-01},
  { 9.404125e-01,  4.214742e-02,  3.374137e-01,  4.769463e-01,  5.293300e-01,  2.192226e-01},
  { 9.026564e-01,  1.489122e-01,  4.037778e-01,  4.851435e-01,  5.346597e-01,  2.026991e-01},
  {-1.238482e-01, -2.248062e-01,  9.665008e-01, -1.412097e-01,  5.230933e-01,  1.809853e-01},
  { 3.478552e-01, -1.058388e-01, -9.315550e-01,  3.671057e-02,  5.269292e-01,  6.903378e-02},
  {-8.360636e-01, -1.838631e-01,  5.169063e-01, -1.899068e-01,  5.113031e-01,  5.539721e-02},
  { 3.958631e-01, -9.593339e-02, -9.132848e-01, -2.934155e-02,  5.183116e-01,  3.086798e-02},
  {-7.478386e-01, -4.148366e-01,  5.183127e-01, -2.252435e-01,  5.242962e-01,  8.179371e-03},
  {-8.770934e-01, -4.039769e-03,  4.803029e-01, -2.362141e-01,  5.249647e-01, -8.978622e-03},
  { 5.347960e-01, -6.472721e-02, -8.424985e-01, -8.730847e-02,  5.261737e-01, -5.724298e-03},
  {-3.396124e-01,  8.843876e-01, -3.201906e-01, -2.859913e-01,  5.113083e-01, -5.609633e-02},
  { 1.933263e-01, -9.342774e-01,  2.995839e-01,  5.304391e-01,  5.256804e-01, -9.431772e-02},
  {-9.426257e-01, -4.441439e-02,  3.308840e-01,  9.646228e-02,  5.234657e-01, -7.961382e-02},
  { 5.891345e-01,  2.234006e-01, -7.765390e-01, -2.506864e-01,  5.085515e-01, -6.963764e-02},
  {-9.202582e-01, -7.005719e-02,  3.849894e-01,  9.039747e-02,  5.159625e-01, -9.415933e-02},
  {-7.578241e-01,  8.948480e-02,  6.462934e-01,  8.850440e-02,  5.132926e-01, -9.965187e-02},
  {-5.832669e-01,  6.928676e-01, -4.239508e-01,  5.615637e-02,  5.163050e-01, -1.783922e-01},
  { 2.412145e-01, -8.272279e-01,  5.074542e-01,  4.585546e-01,  5.212589e-01, -3.194072e-01},
  {-5.230140e-02, -8.932119e-01, -4.465838e-01,  4.202245e-01,  5.118031e-01, -3.515452e-01},
  { 6.457351e-01, -7.278953e-01, -2.306393e-01,  4.828495e-01,  5.259973e-01, -3.704789e-01},
  {-5.525264e-01,  5.435554e-01,  6.318720e-01, -2.262564e-01,  5.104415e-01, -4.025396e-01},
  { 1.263122e-01, -2.816036e-01,  9.511806e-01, -1.345270e-01,  5.150781e-01, -4.562768e-01},
  {-3.543090e-01,  1.092215e-01, -9.287280e-01, -3.564219e-02,  5.211132e-01, -6.552176e-01},
  { 5.446983e-01,  3.613623e-01,  7.567834e-01,  1.877008e-01,  5.144342e-01, -6.719882e-01},
  {-5.219484e-03,  9.994310e-01, -3.332466e-02,  1.653326e-01,  5.154818e-01, -7.191105e-01},
  { 2.501456e-01,  3.150721e-01, -9.155090e-01,  7.805238e-02,  5.184265e-01, -7.281830e-01},
  { 2.039241e-01,  9.732745e-01, -1.056019e-01,  1.845050e-01,  5.065911e-01, -7.817588e-01},
  {-8.432668e-01,  4.681199e-01, -2.641300e-01, -2.874253e-02,  5.121558e-01, -7.548790e-01},
  { 2.471415e-01,  2.555395e-01, -9.346767e-01,  1.604199e-01,  5.081515e-01, -8.088773e-01},
  {-3.691522e-01,  8.929284e-01,  2.576927e-01,  3.282464e-01,  5.184696e-01,  7.829576e-01},
  {-4.209772e-01, -1.719063e-01,  8.906326e-01,  3.783785e-01,  5.311787e-01,  7.853661e-01},
  {-8.048733e-01,  2.139527e-01,  5.535371e-01,  2.008774e-01,  5.363549e-01,  7.087812e-01},
  {-4.324721e-02,  7.499909e-01,  6.600327e-01,  3.396787e-01,  5.439026e-01,  6.991828e-01},
  { 8.223455e-01,  9.582376e-02, -5.608616e-01,  4.006791e-01,  5.467121e-01,  5.699850e-01},
  { 9.607514e-01, -2.538088e-01,  1.119729e-01,  4.397716e-01,  5.236399e-01,  3.621108e-01},
  {-2.817461e-01, -7.243885e-01, -6.291904e-01, -9.821602e-02,  5.523584e-01,  3.503357e-01},
  {-4.447427e-01, -8.842168e-01,  1.427044e-01, -1.735449e-01,  5.323358e-01,  1.784756e-01},
  {-7.526305e-01, -4.786753e-01,  4.521252e-01, -2.140562e-01,  5.298287e-01,  2.696654e-02},
  { 2.452685e-01, -9.041833e-01,  3.497082e-01,  5.275341e-01,  5.531403e-01, -4.469609e-02},
  {-1.373900e-01,  8.684680e-01, -4.763270e-01, -2.588622e-01,  5.230560e-01, -6.087715e-02},
  {-6.637920e-01,  1.855593e-01, -7.245329e-01, -2.470058e-01,  5.393928e-01, -6.046190e-02},
  { 9.975622e-01, -4.734720e-02,  5.126379e-02,  5.405467e-01,  5.443012e-01, -9.926660e-02},
  {-8.205960e-01,  1.152506e-01,  5.597674e-01,  4.469026e-02,  5.367832e-01, -1.302761e-01},
  { 3.642028e-01, -6.472601e-01, -6.696348e-01,  5.120305e-01,  5.444048e-01, -1.497517e-01},
  { 5.025784e-02, -8.646563e-01, -4.998437e-01,  4.966687e-01,  5.548823e-01, -1.670383e-01},
  { 9.398303e-01, -2.844570e-01, -1.892174e-01,  4.940966e-01,  5.429312e-01, -3.697972e-01},
  { 5.717091e-01, -1.934372e-01, -7.973273e-01,  2.477899e-01,  5.436789e-01, -3.787544e-01},
  { 4.430627e-02, -2.329810e-01, -9.714714e-01,  4.886178e-01,  5.419680e-01, -3.789212e-01},
  {-7.825650e-01,  5.576780e-01, -2.767438e-01, -2.183866e-01,  5.212588e-01, -4.356545e-01},
  {-2.763641e-01,  9.595868e-01,  5.306690e-02, -1.022089e-01,  5.456146e-01, -5.168004e-01},
  {-3.376395e-01,  9.358482e-01,  1.009346e-01, -9.474476e-02,  5.460123e-01, -5.458289e-01},
  { 1.561323e-01,  9.283437e-01,  3.373434e-01, -1.151664e-01,  5.459510e-01, -5.522220e-01},
  { 2.166824e-01, -8.803290e-02, -9.722649e-01, -7.517567e-02,  5.420777e-01, -6.572268e-01},
  {-7.859247e-01,  3.986398e-01, -4.726613e-01,  8.159635e-03,  5.467445e-01, -6.795073e-01},
  { 2.549820e-01, -2.187214e-01, -9.418839e-01, -1.539048e-01,  5.462924e-01, -6.924691e-01},
  {-7.460693e-02,  1.528330e-01, -9.854318e-01,  5.238435e-03,  5.299644e-01, -7.545361e-01},
  {-4.138516e-01,  3.439661e-01, -8.428607e-01, -2.224882e-02,  5.228260e-01, -7.512863e-01},
  {-2.336242e-01, -7.261733e-02,  9.696115e-01,  4.100227e-01,  5.625590e-01,  8.119306e-01},
  {-3.830371e-01,  2.987127e-01,  8.741015e-01,  3.933406e-01,  5.524104e-01,  8.032123e-01},
  {-7.632310e-01,  3.348139e-01,  5.526103e-01,  3.835032e-01,  5.511521e-01,  7.974761e-01},
  {-5.241033e-01,  7.563484e-01,  3.914753e-01,  3.809446e-01,  5.530239e-01,  7.830847e-01},
  {-2.538461e-02,  5.570579e-01,  8.300856e-01,  3.508958e-01,  5.624915e-01,  6.857780e-01},
  { 9.105685e-02,  4.792286e-01,  8.729539e-01,  3.023648e-01,  5.570133e-01,  6.858255e-01},
  { 4.203972e-02,  2.769280e-01,  9.599706e-01,  2.754528e-01,  5.662140e-01,  6.867391e-01},
  {-9.688097e-01, -2.273652e-01,  9.855326e-02,  1.877300e-01,  5.660223e-01,  6.697165e-01},
  { 4.839579e-01,  2.367129e-01,  8.424676e-01, -2.971911e-03,  5.579799e-01,  6.289052e-01},
  {-6.936986e-01,  6.171675e-01,  3.713309e-01, -7.890611e-02,  5.425761e-01,  5.627885e-01},
  { 9.630524e-01,  1.558018e-01, -2.196723e-01,  3.822542e-01,  5.529345e-01,  5.328354e-01},
  {-4.292168e-01,  3.711962e-01,  8.233992e-01, -8.501321e-02,  5.587053e-01,  4.593785e-01},
  { 6.471130e-01,  5.039578e-01,  5.720763e-01,  4.725973e-01,  5.368048e-01,  4.443472e-01},
  { 6.072030e-01, -1.189366e-01,  7.855944e-01,  1.387412e-01,  5.558448e-01,  4.412721e-01},
  {-2.515388e-01,  1.863410e-01,  9.497395e-01,  1.822746e-01,  5.495953e-01,  4.281802e-01},
  {-1.953608e-01, -2.877330e-01, -9.375734e-01,  3.026501e-02,  5.513135e-01,  3.387996e-01},
  {-1.238318e-01, -3.464400e-01, -9.298629e-01, -1.379264e-01,  5.672632e-01,  3.355406e-01},
  { 9.796016e-01, -1.885820e-01,  6.940892e-02,  4.544298e-01,  5.463664e-01,  3.179207e-01},
  {-9.671094e-01, -2.194598e-01, -1.285954e-01,  1.062131e-01,  5.453711e-01,  2.776141e-01},
  {-9.384236e-01, -2.570863e-01,  2.307980e-01,  9.854066e-02,  5.563806e-01,  2.553622e-01},
  {-6.129650e-01,  1.465947e-01,  7.763916e-01,  7.275958e-02,  5.526316e-01,  2.158563e-01},
  { 6.798007e-02, -6.056059e-01,  7.928557e-01, -2.203850e-01,  5.574969e-01,  2.092097e-01},
  {-4.474586e-01, -8.708951e-01,  2.032796e-01, -2.771942e-01,  5.568748e-01,  1.856294e-01},
  {-9.791229e-01, -2.009637e-01,  3.052985e-02, -2.853880e-01,  5.677483e-01,  1.709776e-01},
  { 8.174496e-01, -1.244588e-01, -5.623932e-01,  2.949247e-01,  5.527537e-01,  8.925872e-02},
  { 7.934432e-02, -4.754153e-03, -9.968359e-01,  8.556693e-02,  5.632954e-01,  8.394597e-02},
  { 8.011979e-01, -5.858548e-01,  1.218852e-01,  5.121788e-01,  5.578462e-01, -2.201529e-04},
  { 7.731116e-01, -5.379092e-01,  3.360837e-01,  5.335889e-01,  5.666841e-01, -3.269443e-02},
  {-1.542983e-01, -9.767946e-01,  1.485404e-01,  5.213616e-01,  5.597892e-01, -3.188265e-02},
  { 3.947089e-01,  7.419803e-01, -5.419133e-01, -1.362932e-01,  5.525672e-01, -3.832810e-02},
  {-8.710490e-01,  2.097798e-01,  4.441464e-01,  5.683890e-02,  5.567667e-01, -1.137706e-01},
  {-9.243578e-01,  3.743005e-01, -7.390285e-02,  4.207097e-02,  5.440419e-01, -1.381076e-01},
  { 7.470255e-02, -8.974945e-01, -4.346530e-01,  4.914415e-01,  5.640861e-01, -1.845667e-01},
  { 6.063432e-01, -7.398468e-01, -2.915041e-01,  4.833029e-01,  5.767992e-01, -2.162505e-01},
  { 3.615473e-01,  1.859620e-01, -9.136201e-01,  3.296032e-01,  5.572295e-01, -3.379540e-01},
  { 9.899368e-01,  3.409672e-03, -1.414690e-01,  4.912035e-01,  5.455084e-01, -3.786571e-01},
  {-4.078039e-02,  2.892238e-01, -9.563925e-01,  2.299682e-01,  5.634493e-01, -3.858913e-01},
  {-4.605209e-01,  8.706147e-01,  1.730623e-01, -2.207872e-01,  5.237693e-01, -4.159342e-01},
  {-4.605209e-01,  8.706147e-01,  1.730623e-01,  2.319005e-01,  5.580555e-01, -3.925867e-01},
  {-4.605209e-01,  8.706147e-01,  1.730623e-01,  2.305134e-01,  5.578341e-01, -3.940589e-01},
  { 5.779549e-01, -8.294129e-02,  8.118428e-01,  2.056650e-02,  5.511972e-01, -5.603629e-01},
  {-4.915162e-01,  8.370408e-01, -2.403635e-01, -5.281448e-02,  5.663146e-01, -5.560855e-01},
  {-3.705148e-02,  7.678086e-01,  6.396070e-01, -8.341386e-02,  5.567835e-01, -5.704210e-01},
  { 9.808043e-02,  7.386543e-01,  6.669108e-01, -1.178465e-01,  5.548240e-01, -5.640962e-01},
  {-4.571354e-01,  2.569688e-02, -8.890258e-01, -3.926576e-03,  5.587735e-01, -6.671962e-01},
  { 5.725519e-02, -3.701408e-01, -9.272096e-01, -5.145493e-02,  5.604454e-01, -6.580792e-01},
  {-2.332359e-01,  3.333148e-01, -9.135109e-01,  9.556159e-03,  5.460863e-01, -7.521461e-01},
  { 9.880762e-01, -1.387924e-01,  6.664981e-02,  4.997181e-01,  5.715271e-01,  7.590185e-01},
  {-5.599900e-01,  7.769366e-01,  2.877163e-01,  3.967374e-01,  5.650260e-01,  7.416872e-01},
  {-5.369936e-01,  6.842545e-01,  4.933900e-01,  3.904707e-01,  5.733920e-01,  6.983765e-01},
  {-4.838226e-01, -3.365274e-01,  8.078768e-01,  1.874108e-01,  5.784715e-01,  6.894696e-01},
  {-8.716801e-01,  4.665766e-01, -1.499331e-01,  2.102042e-01,  5.709493e-01,  6.232817e-01},
  {-6.142660e-01,  7.057051e-01,  3.530688e-01, -5.988681e-02,  5.545551e-01,  5.884340e-01},
  { 9.200267e-01, -1.559463e-01, -3.594880e-01,  3.864582e-01,  5.773624e-01,  5.449063e-01},
  { 9.966081e-01, -3.387218e-02,  7.499957e-02,  3.799422e-01,  5.764248e-01,  4.902024e-01},
  {-4.169975e-01,  8.266437e-01,  3.778534e-01, -2.361921e-02,  5.739808e-01,  4.979548e-01},
  {-7.628622e-01,  3.517150e-01,  5.425290e-01,  2.248834e-01,  5.711773e-01,  4.564458e-01},
  {-4.341419e-01, -2.815304e-02,  9.004045e-01,  1.988027e-01,  5.748562e-01,  4.350744e-01},
  { 1.767405e-01, -1.396178e-01,  9.743047e-01,  1.761672e-01,  5.670539e-01,  4.289797e-01},
  {-9.418410e-01, -2.513590e-01, -2.230566e-01, -1.240514e-01,  5.698827e-01,  4.113975e-01},
  { 9.729073e-01, -2.868345e-02, -2.294091e-01,  4.704545e-01,  5.775586e-01,  3.461348e-01},
  {-2.048746e-01, -4.093010e-01, -8.891001e-01,  1.389389e-02,  5.717018e-01,  3.382003e-01},
  {-5.883650e-01, -5.599515e-01, -5.833359e-01, -1.849479e-01,  5.811907e-01,  3.508548e-01},
  {-5.209693e-01, -3.069542e-01, -7.964735e-01,  7.252528e-02,  5.601441e-01,  3.207330e-01},
  {-7.689177e-01, -4.896820e-01, -4.110681e-01,  9.417609e-02,  5.590869e-01,  2.914629e-01},
  { 1.176883e-01, -1.727672e-01,  9.779065e-01, -2.498060e-01,  5.795554e-01,  2.262812e-01},
  {-8.424584e-01, -1.514908e-01,  5.170246e-01, -2.710907e-01,  5.737388e-01,  2.224786e-01},
  {-2.847878e-01, -9.443071e-01, -1.648633e-01, -2.931744e-01,  5.739929e-01,  1.465212e-01},
  {-2.507176e-01, -2.292277e-01, -9.405293e-01,  3.540306e-01,  5.739852e-01,  1.166542e-01},
  { 2.712002e-01, -1.495442e-01, -9.508349e-01,  3.321979e-01,  5.735211e-01,  1.140037e-01},
  {-2.036469e-01, -9.398202e-01, -2.743464e-01, -2.753741e-01,  5.781672e-01,  9.705982e-02},
  {-2.722372e-01, -6.432537e-02, -9.600777e-01,  8.809553e-02,  5.764099e-01,  8.360559e-02},
  {-6.710833e-01,  1.316543e-01, -7.295987e-01,  1.295771e-01,  5.678579e-01,  6.107051e-02},
  { 4.580844e-01,  7.097438e-03, -8.888804e-01, -1.438134e-01,  5.602626e-01, -4.762619e-02},
  { 8.759493e-01, -2.165818e-01, -4.310513e-01,  5.177194e-01,  5.720406e-01, -1.567706e-01},
  { 9.326468e-01, -3.447070e-01,  1.065231e-01,  4.804415e-01,  5.734937e-01, -2.633917e-01},
  {-2.450760e-01,  3.981840e-01, -8.839611e-01,  4.228072e-01,  5.744631e-01, -3.192488e-01},
  { 9.929891e-01, -1.071667e-02,  1.177188e-01,  4.917498e-01,  5.784628e-01, -3.583275e-01},
  { 4.548318e-02, -2.772687e-01, -9.597152e-01,  2.532949e-01,  5.799440e-01, -3.879392e-01},
  { 0.000000e+00,  9.544800e-01, -2.982750e-01, -9.015630e-02,  5.603570e-01, -4.483003e-01},
  { 3.183431e-01, -6.100077e-01,  7.256365e-01, -8.645917e-02,  5.630881e-01, -4.533517e-01},
  { 3.636917e-01,  7.210152e-01,  5.898012e-01, -8.047366e-02,  5.637383e-01, -4.550950e-01},
  { 4.948140e-01,  4.489473e-01,  7.440467e-01, -6.496752e-02,  5.742891e-01, -4.772631e-01},
  { 2.358218e-01,  9.211831e-01,  3.095316e-01, -1.844564e-01,  5.597481e-01, -5.210837e-01},
  {-1.784691e-01,  9.241334e-01,  3.378256e-01, -1.657811e-02,  5.867360e-01, -5.929591e-01},
  {-1.868939e-01,  8.011954e-01,  5.684686e-01, -4.488396e-02,  5.749052e-01, -5.906086e-01},
  {-8.256708e-01,  4.041113e-01, -3.936518e-01,  3.256167e-02,  5.764717e-01, -6.931064e-01},
  {-8.952197e-01, -3.067012e-01,  3.232894e-01, -1.648052e-01,  5.734997e-01, -6.968423e-01},
  {-7.441702e-01,  5.907403e-01, -3.118276e-01,  1.050142e-02,  5.614259e-01, -7.448318e-01},
  { 4.978366e-01,  3.150026e-01,  8.080420e-01,  4.858073e-01,  5.867371e-01,  8.112389e-01},
  { 3.688386e-02,  5.922990e-01,  8.048735e-01,  4.920590e-01,  5.984018e-01,  7.978048e-01},
  {-8.934440e-01,  2.164893e-01,  3.935609e-01,  1.818219e-01,  5.916060e-01,  6.825946e-01},
  { 5.436707e-01,  5.517461e-01,  6.324543e-01, -1.030608e-03,  5.774953e-01,  6.258036e-01},
  {-2.991426e-01,  6.258963e-01,  7.202552e-01, -7.205966e-03,  5.754979e-01,  6.294049e-01},
  { 5.163128e-01,  7.876212e-01,  3.362648e-01,  2.836405e-02,  5.748091e-01,  5.715287e-01},
  { 4.223186e-01, -4.026018e-01,  8.121323e-01,  4.686839e-03,  5.787132e-01,  5.857765e-01},
  { 4.223186e-01, -4.026018e-01,  8.121323e-01,  1.583325e-02,  5.782701e-01,  5.797606e-01},
  {-7.658534e-01,  6.415151e-01, -4.389900e-02,  2.728167e-01,  5.969536e-01,  5.471048e-01},
  { 5.402442e-01,  7.215140e-01,  4.330746e-01,  4.817775e-02,  5.829444e-01,  5.339437e-01},
  {-7.573273e-01,  3.707078e-01,  5.376161e-01,  2.446932e-01,  5.919925e-01,  4.688537e-01},
  { 6.910655e-01,  3.445970e-01,  6.353591e-01,  4.025965e-01,  5.846012e-01,  4.357916e-01},
  { 8.986412e-01,  3.788536e-01,  2.211649e-01,  3.980644e-01,  5.952373e-01,  4.323527e-01},
  {-8.658879e-01, -4.861446e-01,  1.179046e-01, -2.215135e-01,  5.991048e-01,  3.988826e-01},
  { 9.695682e-01,  2.219965e-01,  1.032236e-01,  4.721897e-01,  5.787234e-01,  3.886331e-01},
  { 9.089418e-01,  3.836699e-01,  1.631634e-01,  4.712874e-01,  5.829687e-01,  3.663661e-01},
  {-8.289074e-01, -3.421492e-01, -4.425454e-01, -2.170379e-01,  5.964726e-01,  3.766630e-01},
  {-6.007685e-01,  1.402883e-01, -7.870174e-01, -1.933123e-01,  5.956602e-01,  3.583110e-01},
  {-3.847100e-01, -5.984719e-01, -7.027301e-01,  5.250474e-02,  5.778856e-01,  3.188411e-01},
  {-1.218647e-01,  2.545096e-01, -9.593612e-01, -1.616041e-01,  5.887332e-01,  3.387528e-01},
  {-8.874930e-01,  3.153503e-01, -3.360214e-01, -2.478960e-01,  6.012026e-01,  1.974663e-01},
  {-4.016137e-01, -9.103028e-01, -1.002766e-01, -2.701167e-01,  5.864080e-01,  7.438765e-02},
  {-8.407562e-01,  9.695128e-02, -5.326626e-01,  1.463468e-01,  5.979843e-01,  4.031354e-02},
  { 9.999173e-01,  6.887623e-03, -1.086729e-02,  5.451232e-01,  5.992824e-01, -5.335662e-02},
  { 5.073869e-02,  8.850279e-01, -4.627648e-01, -2.183473e-01,  5.790963e-01, -6.470304e-02},
  {-5.726173e-01,  5.866704e-01, -5.726494e-01, -2.354762e-01,  5.769812e-01, -6.088677e-02},
  {-8.868378e-01,  4.515665e-01,  9.801324e-02,  9.167022e-02,  5.868382e-01, -9.031174e-02},
  {-4.408800e-01,  8.488439e-01, -2.917000e-01,  7.632703e-02,  5.809866e-01, -1.084019e-01},
  { 9.176744e-01,  2.424880e-01,  3.147590e-01,  3.072826e-01,  5.932858e-01, -1.406637e-01},
  { 5.984499e-02,  3.522708e-01, -9.339828e-01,  3.824812e-01,  5.943289e-01, -3.055397e-01},
  {-3.573801e-01,  2.387071e-01, -9.029388e-01,  4.296107e-01,  6.037889e-01, -3.102657e-01},
  {-5.316411e-01,  2.725173e-01, -8.019302e-01,  4.901073e-01,  5.990160e-01, -3.559279e-01},
  {-2.819454e-01, -7.792056e-01, -5.597728e-01,  2.396405e-01,  6.054845e-01, -3.992999e-01},
  { 4.213946e-01,  3.194852e-01,  8.487377e-01, -5.622045e-02,  5.903630e-01, -4.884750e-01},
  { 5.490332e-01,  1.416442e-01,  8.237107e-01, -4.328226e-02,  5.941555e-01, -4.967974e-01},
  { 2.155058e-01,  7.518640e-01,  6.231031e-01, -1.881363e-01,  5.873804e-01, -5.619805e-01},
  { 4.885761e-01,  2.456989e-01,  8.372129e-01,  6.889086e-02,  5.906276e-01, -6.028827e-01},
  {-9.459364e-01,  2.519398e-01, -2.042808e-01, -1.580061e-01,  5.893041e-01, -6.542332e-01},
  {-4.846490e-01,  5.888960e-01, -6.467742e-01, -1.638733e-01,  5.768009e-01, -6.911299e-01},
  {-6.714052e-01,  3.864604e-01,  6.323475e-01,  4.032705e-01,  6.102505e-01,  6.822785e-01},
  {-1.941231e-01,  3.006127e-01,  9.337816e-01,  3.745620e-01,  6.088971e-01,  6.689440e-01},
  { 7.734260e-01, -3.002779e-01, -5.582522e-01,  4.146605e-01,  6.001804e-01,  5.863945e-01},
  {-6.191918e-01,  6.774141e-01,  3.971293e-01,  2.816457e-01,  6.086618e-01,  5.246369e-01},
  {-8.507316e-02,  3.407494e-01,  9.362972e-01,  3.986336e-02,  6.134926e-01,  4.953066e-01},
  { 9.898201e-01, -6.986111e-02,  1.239984e-01,  3.852221e-01,  6.140014e-01,  4.727667e-01},
  {-3.197993e-01,  4.913879e-01,  8.101026e-01, -1.853281e-02,  6.091091e-01,  4.617897e-01},
  {-2.618418e-01, -2.935300e-01,  9.193906e-01,  2.161727e-01,  6.019683e-01,  4.455365e-01},
  { 2.488990e-01, -5.159781e-01,  8.196438e-01,  1.581702e-01,  5.987422e-01,  4.470660e-01},
  {-3.463001e-01,  1.726865e-01,  9.220930e-01, -4.468324e-02,  6.182039e-01,  4.517170e-01},
  {-1.527740e-01, -2.012685e-02,  9.880561e-01, -1.005301e-01,  6.205940e-01,  4.391305e-01},
  {-8.400385e-01,  3.330159e-01, -4.282940e-01, -2.195347e-01,  6.082285e-01,  3.859257e-01},
  { 9.448698e-01,  2.829299e-01,  1.648389e-01,  4.584606e-01,  6.071213e-01,  3.357594e-01},
  {-2.475367e-01, -7.268768e-01, -6.406057e-01,  5.091109e-02,  6.000397e-01,  3.011569e-01},
  { 9.800581e-01, -1.470010e-02,  1.981666e-01,  4.792885e-01,  6.052487e-01,  2.518547e-01},
  {-8.406833e-01, -2.375746e-01, -4.866310e-01,  8.056997e-02,  6.119949e-01,  2.604397e-01},
  {-4.671753e-01,  2.039689e-01,  8.603162e-01, -2.469359e-01,  5.985282e-01,  2.244705e-01},
  {-8.846159e-01, -3.915991e-02,  4.646731e-01,  7.673226e-02,  6.197045e-01,  2.132853e-01},
  {-9.302632e-01,  3.661937e-01, -2.263982e-02, -2.479269e-01,  6.069583e-01,  2.099778e-01},
  {-4.361027e-01,  7.038914e-02,  8.971397e-01,  5.572967e-02,  6.111377e-01,  1.900375e-01},
  {-4.116202e-01,  8.847682e-01, -2.185269e-01, -2.196691e-01,  6.143164e-01,  1.765821e-01},
  {-3.017872e-02, -1.158731e-01,  9.928054e-01, -1.131455e-03,  6.131697e-01,  1.796988e-01},
  {-4.193790e-01,  7.348526e-01, -5.330224e-01, -1.560251e-01,  6.235244e-01,  1.237985e-01},
  {-3.612744e-01,  8.960198e-01, -2.581267e-01, -2.024943e-01,  6.018261e-01,  1.118257e-01},
  {-2.701691e-01,  4.657873e-02, -9.616855e-01,  1.070761e-01,  6.213738e-01,  7.751927e-02},
  {-9.780245e-01,  2.084316e-01, -4.914555e-03,  1.503629e-01,  6.253759e-01,  3.945012e-02},
  {-2.220655e-01,  3.085513e-01, -9.249232e-01, -6.775922e-02,  6.051715e-01,  5.521706e-02},
  { 9.088553e-01, -2.205451e-01, -3.540365e-01,  2.864048e-01,  6.183270e-01,  2.303989e-02},
  {-7.806267e-01,  5.847320e-01, -2.207046e-01,  1.510064e-01,  6.065274e-01, -1.572645e-01},
  {-8.138377e-01,  5.708331e-01, -1.087091e-01,  1.608206e-01,  6.166274e-01, -1.793657e-01},
  { 6.186647e-01, -3.203363e-01,  7.173831e-01,  3.429787e-01,  6.168224e-01, -2.138586e-01},
  { 2.060534e-01, -6.136324e-01, -7.622318e-01,  4.956092e-01,  6.200544e-01, -3.490045e-01},
  {-3.947713e-01, -3.004366e-01, -8.682705e-01,  2.198076e-01,  6.068989e-01, -3.603540e-01},
  { 5.204005e-01, -4.471269e-01, -7.275031e-01,  2.818498e-01,  5.997314e-01, -3.761575e-01},
  { 1.291915e-01, -6.426352e-01, -7.552016e-01,  2.677995e-01,  6.208101e-01, -4.322920e-01},
  {-4.444127e-01, -2.539309e-01, -8.590789e-01,  2.431893e-01,  6.271353e-01, -4.364352e-01},
  { 1.489807e-01,  9.816284e-01,  1.192078e-01,  7.770999e-03,  6.027896e-01, -5.522994e-01},
  { 4.673517e-01,  6.011589e-01,  6.482209e-01,  2.818364e-02,  6.004501e-01, -5.718248e-01},
  { 4.679912e-01,  8.146276e-01,  3.425873e-01,  5.266126e-02,  5.962377e-01, -5.842569e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.853283e-01,  5.984282e-01, -5.915587e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -1.845267e-01,  6.009947e-01, -5.931655e-01},
  {-4.996175e-01,  8.315926e-01, -2.425614e-01, -1.787249e-01,  6.009465e-01, -5.990402e-01},
  {-1.677224e-01,  8.230697e-02, -9.823924e-01,  1.954909e-01,  6.100466e-01, -6.535490e-01},
  {-4.270371e-01,  1.051399e-01, -8.981007e-01,  3.518935e-02,  6.149568e-01, -6.892469e-01},
  {-7.760676e-01,  4.748803e-01, -4.149792e-01,  5.032577e-02,  5.984383e-01, -7.308918e-01},
  {-7.400360e-01,  3.571905e-01,  5.698787e-01,  4.484232e-01,  6.391745e-01,  7.183465e-01},
  {-7.052566e-01,  3.334917e-01,  6.256168e-01,  4.334127e-01,  6.363615e-01,  6.985465e-01},
  { 8.915503e-01, -1.566653e-01, -4.249635e-01,  4.543640e-01,  6.308798e-01,  6.267629e-01},
  { 8.728424e-01, -3.355728e-01, -3.543121e-01,  3.986019e-01,  6.238435e-01,  5.380900e-01},
  {-8.324795e-01,  3.033704e-01,  4.636207e-01,  2.916444e-01,  6.354843e-01,  5.086663e-01},
  { 1.945658e-01,  6.411321e-02,  9.787919e-01,  1.100122e-01,  6.300316e-01,  5.042712e-01},
  {-3.802807e-01,  3.527922e-01,  8.549410e-01,  3.411148e-02,  6.276399e-01,  4.839703e-01},
  {-4.992407e-01, -2.302051e-01,  8.353229e-01,  2.360574e-01,  6.141130e-01,  4.600710e-01},
  {-2.510490e-01, -3.084789e-03,  9.679695e-01, -6.128020e-02,  6.264952e-01,  4.448867e-01},
  {-6.070768e-01, -2.950812e-01,  7.378244e-01, -2.081570e-01,  6.248837e-01,  4.206831e-01},
  {-4.105235e-01, -4.051239e-01, -8.169119e-01,  3.478716e-01,  6.281843e-01,  8.684650e-02},
  { 5.616363e-01, -3.545270e-01, -7.475796e-01,  3.214484e-01,  6.337621e-01,  8.131878e-02},
  { 9.923702e-01, -4.730368e-02,  1.138581e-01,  2.839175e-01,  6.191536e-01, -3.723993e-02},
  {-8.982599e-01,  2.537568e-01, -3.587989e-01,  1.590861e-01,  6.266970e-01, -1.399623e-01},
  {-9.555134e-01,  1.863582e-01, -2.286151e-01,  1.697472e-01,  6.385046e-01, -1.762650e-01},
  { 8.331175e-01, -2.433876e-02,  5.525603e-01,  3.299176e-01,  6.196495e-01, -2.001344e-01},
  {-8.306894e-01,  5.188407e-01, -2.018894e-01,  1.673460e-01,  6.268402e-01, -1.979909e-01},
  {-2.642708e-01,  6.038428e-02, -9.625563e-01,  4.134060e-01,  6.372838e-01, -2.993006e-01},
  { 1.893145e-01,  7.854366e-02, -9.787701e-01,  3.854540e-01,  6.366487e-01, -2.988345e-01},
  { 6.974142e-01, -1.219164e-01, -7.062224e-01,  3.327762e-01,  6.231031e-01, -3.333572e-01},
  {-5.646511e-01, -4.759007e-01, -6.743053e-01,  4.794599e-01,  6.387877e-01, -3.573006e-01},
  { 7.988631e-01, -4.131698e-01, -4.371595e-01,  3.159396e-01,  6.241038e-01, -3.541412e-01},
  { 3.384537e-01, -5.897737e-01, -7.332232e-01,  4.908285e-01,  6.420906e-01, -3.643030e-01},
  {-6.590587e-01, -2.800978e-01, -6.979877e-01,  2.204624e-01,  6.378695e-01, -4.147722e-01},
  { 4.733524e-01, -7.344236e-01, -4.863736e-01,  2.897651e-01,  6.293451e-01, -4.317722e-01},
  {-4.784398e-01,  8.477634e-01,  2.288941e-01, -5.109990e-02,  6.083824e-01, -5.035437e-01},
  {-2.282302e-01,  9.734158e-01,  1.930008e-02, -1.394467e-01,  6.151710e-01, -6.145063e-01},
  {-1.213316e-01,  6.731439e-01,  7.294902e-01, -6.414662e-02,  6.334850e-01, -6.234355e-01},
  {-4.773494e-01,  2.965390e-01, -8.271651e-01,  8.690705e-02,  6.317977e-01, -7.378627e-01},
  { 5.272184e-02,  3.379605e-01,  9.396824e-01,  4.930821e-01,  6.367817e-01,  7.797472e-01},
  {-5.620391e-01,  3.831486e-01,  7.330137e-01,  2.303786e-01,  6.478508e-01,  7.062050e-01},
  {-7.077764e-01,  6.243612e-01, -3.304929e-01,  2.878167e-01,  6.575216e-01,  6.464969e-01},
  { 2.971976e-01, -4.459692e-01,  8.442660e-01,  1.487234e-01,  6.380139e-01,  4.900419e-01},
  {-5.426787e-01, -2.143571e-02,  8.396668e-01,  2.610346e-01,  6.419021e-01,  4.838862e-01},
  {-6.486236e-01, -6.088629e-02,  7.586702e-01,  3.068668e-02,  6.506985e-01,  4.790013e-01},
  {-2.165473e-01, -3.056847e-01,  9.271807e-01,  4.747320e-04,  6.503428e-01,  4.682899e-01},
  {-8.287467e-01,  3.779393e-01,  4.127236e-01, -2.039857e-01,  6.422663e-01,  4.178146e-01},
  {-8.607687e-01,  4.026299e-01, -3.113943e-01, -2.022240e-01,  6.518877e-01,  4.008092e-01},
  { 6.870255e-01,  5.358146e-01,  4.908142e-01,  4.001116e-01,  6.462506e-01,  3.472809e-01},
  { 4.841781e-01,  4.661118e-01,  7.404805e-01,  4.217843e-01,  6.467642e-01,  3.303489e-01},
  { 9.099829e-01, -5.005508e-02,  4.116135e-01,  4.677004e-01,  6.558495e-01,  3.046220e-01},
  {-7.923025e-01,  5.506940e-01,  2.626649e-01, -2.290792e-01,  6.509641e-01,  2.225771e-01},
  { 2.522784e-01,  1.649438e-01, -9.534932e-01, -2.154611e-01,  6.463898e-01,  2.253889e-01},
  {-4.965659e-01, -2.181401e-01,  8.401412e-01,  6.145937e-02,  6.419010e-01,  1.999786e-01},
  { 9.774967e-01,  1.318038e-02,  2.105383e-01,  4.763475e-01,  6.541592e-01,  1.645657e-01},
  {-6.456192e-01,  3.433379e-01, -6.821254e-01, -1.670647e-01,  6.418421e-01,  1.429569e-01},
  {-2.210895e-01, -3.172596e-02, -9.747373e-01,  1.013369e-01,  6.437087e-01,  8.112723e-02},
  {-5.565702e-01, -4.082280e-01, -7.235879e-01, -8.371115e-02,  6.532834e-01,  7.048938e-02},
  { 3.067036e-01, -7.778119e-02, -9.486216e-01,  6.062534e-02,  6.531322e-01,  6.923825e-02},
  { 2.658053e-02, -1.231425e-01, -9.920329e-01, -1.473201e-03,  6.563108e-01,  3.710197e-02},
  {-8.455192e-01,  5.191061e-01, -1.250042e-01,  1.264778e-01,  6.371865e-01, -7.742164e-02},
  { 9.319994e-01, -2.589661e-01,  2.536014e-01,  3.014462e-01,  6.468418e-01, -1.115305e-01},
  {-4.998927e-01, -8.041060e-01,  3.217465e-01,  3.863245e-01,  6.381683e-01, -1.961147e-01},
  { 9.169569e-01,  3.450636e-02, -3.974914e-01,  4.962761e-01,  6.502029e-01, -2.438658e-01},
  {-6.483268e-01, -1.771844e-01, -7.404580e-01,  4.442719e-01,  6.532456e-01, -3.167388e-01},
  { 9.886454e-01, -1.193627e-01,  9.128381e-02,  4.983306e-01,  6.551965e-01, -3.356866e-01},
  { 9.899284e-01, -1.291723e-01, -5.793319e-02,  4.993896e-01,  6.554546e-01, -3.564668e-01},
  {-6.535346e-01, -6.682152e-01, -3.555011e-01,  2.044848e-01,  6.393576e-01, -3.646186e-01},
  { 7.129537e-01, -2.885979e-01, -6.390682e-01,  4.905580e-01,  6.614028e-01, -3.775057e-01},
  {-4.141521e-01, -3.985354e-01, -8.183200e-01,  1.841103e-01,  6.577451e-01, -4.027920e-01},
  {-4.214198e-01, -2.735354e-01, -8.646293e-01,  2.046501e-01,  6.544769e-01, -4.073078e-01},
  { 4.505659e-01, -1.066973e-01, -8.863443e-01,  3.010005e-01,  6.490040e-01, -4.347055e-01},
  {-5.981089e-01,  6.255193e-01, -5.009903e-01, -2.969296e-02,  6.255552e-01, -5.097234e-01},
  {-2.008232e-01,  5.632393e-01,  8.015183e-01,  9.848943e-02,  6.479425e-01, -6.321011e-01},
  {-6.527756e-01,  7.223502e-01,  2.282413e-01, -1.038961e-01,  6.351263e-01, -6.424307e-01},
  {-9.816509e-01, -1.322899e-01, -1.373349e-01,  1.897578e-01,  6.314381e-01, -6.555979e-01},
  { 4.866891e-01,  6.368604e-02,  8.712507e-01,  1.847541e-01,  6.428114e-01, -6.521417e-01},
  { 3.483064e-01,  6.377073e-02, -9.352091e-01,  9.937390e-02,  6.413764e-01, -7.417344e-01},
  { 5.393746e-01, -1.272518e-01,  8.323953e-01,  3.707213e-01,  6.707612e-01,  6.658340e-01},
  {-9.515271e-01,  2.806788e-01,  1.257603e-01,  3.135201e-01,  6.643007e-01,  5.340067e-01},
  {-2.184552e-01, -4.339267e-01,  8.740624e-01, -4.959138e-02,  6.540152e-01,  4.569261e-01},
  {-8.711382e-01,  3.979411e-01, -2.876824e-01, -1.940953e-01,  6.689616e-01,  4.002195e-01},
  {-4.732944e-01,  5.507756e-02, -8.791808e-01,  7.664578e-02,  6.668969e-01,  2.824581e-01},
  {-9.288187e-01, -1.790613e-01,  3.243963e-01,  8.994887e-02,  6.680576e-01,  2.428080e-01},
  {-3.749070e-01,  1.224276e-01,  9.189429e-01,  4.110940e-02,  6.704887e-01,  1.974414e-01},
  { 8.089034e-02,  5.763763e-02,  9.950551e-01, -8.225304e-03,  6.601153e-01,  1.906904e-01},
  {-7.245171e-02,  3.065319e-01,  9.490990e-01, -3.154871e-02,  6.699293e-01,  1.909007e-01},
  { 2.642628e-01,  2.755350e-02,  9.640570e-01, -1.127503e-01,  6.721736e-01,  2.016084e-01},
  {-6.048813e-01, -1.865501e-01, -7.741561e-01, -2.018891e-01,  6.551201e-01,  1.751424e-01},
  {-5.694826e-01, -2.442312e-01, -7.848826e-01, -1.250491e-01,  6.551343e-01,  1.054071e-01},
  { 3.530760e-01, -4.624317e-01, -8.133230e-01,  3.269987e-01,  6.553590e-01,  7.660522e-02},
  {-4.386528e-01, -5.891424e-01, -6.785978e-01,  3.487883e-01,  6.650495e-01,  6.459332e-02},
  { 7.210149e-01, -4.712822e-01,  5.079672e-01,  3.267232e-01,  6.611722e-01, -1.670382e-01},
  { 1.571561e-01, -6.646790e-01,  7.304134e-01,  3.493914e-01,  6.530965e-01, -1.950238e-01},
  {-9.428490e-01, -2.463260e-01, -2.244086e-01,  1.894220e-01,  6.605525e-01, -2.495463e-01},
  {-8.825626e-01, -4.368758e-01, -1.738473e-01,  1.871641e-01,  6.560830e-01, -3.625308e-01},
  {-2.652653e-02, -1.783868e-01, -9.836028e-01,  4.915221e-01,  6.738079e-01, -3.790014e-01},
  { 6.121506e-01,  2.433267e-01, -7.523721e-01,  3.207475e-01,  6.698326e-01, -4.088632e-01},
  {-2.818453e-01,  7.155749e-01, -6.391525e-01,  2.184822e-01,  6.699501e-01, -4.020514e-01},
  {-1.626544e-01,  7.552589e-02, -9.837883e-01,  1.385624e-01,  6.736162e-01, -4.139474e-01},
  { 3.681247e-02,  5.727476e-01, -8.189048e-01,  2.862412e-01,  6.672393e-01, -4.280365e-01},
  { 5.308180e-02,  5.936261e-01,  8.029884e-01,  6.568156e-03,  6.595576e-01, -6.352642e-01},
  {-5.591656e-01,  7.618787e-01, -3.269168e-01, -9.535440e-02,  6.383688e-01, -6.506775e-01},
  { 2.443516e-01,  2.256300e-01, -9.430712e-01,  1.056798e-01,  6.673790e-01, -7.314302e-01},
  { 9.128083e-01,  3.602465e-01,  1.923626e-01,  4.976713e-01,  6.797124e-01,  7.613631e-01},
  {-5.322690e-01,  3.801695e-01,  7.564132e-01,  4.829641e-01,  6.847224e-01,  7.550284e-01},
  {-4.598094e-02, -1.540849e-01,  9.869872e-01,  2.894856e-01,  6.805518e-01,  7.218091e-01},
  {-4.821526e-02, -1.955790e-01,  9.795020e-01,  2.993644e-01,  6.923324e-01,  7.231223e-01},
  {-6.752026e-01,  6.557448e-01,  3.377873e-01,  2.572915e-01,  6.711206e-01,  7.120830e-01},
  { 5.522217e-01, -4.146539e-01,  7.232658e-01,  3.356799e-01,  6.918344e-01,  7.011334e-01},
  { 1.772914e-01, -2.831617e-01,  9.425430e-01,  2.137664e-01,  6.866162e-01,  5.157256e-01},
  {-4.651925e-01, -1.134132e-01,  8.779142e-01,  2.790537e-01,  6.715552e-01,  4.966379e-01},
  { 8.106793e-01, -5.371399e-01, -2.329804e-01,  4.070495e-01,  6.804104e-01,  4.686954e-01},
  {-5.372127e-01,  1.358842e-02,  8.433374e-01, -8.970975e-02,  6.902496e-01,  4.776503e-01},
  {-4.982600e-01,  3.798440e-01,  7.793943e-01, -1.215417e-01,  6.849990e-01,  4.628612e-01},
  { 1.091051e-01,  9.806622e-01, -1.624740e-01,  1.900151e-01,  6.865886e-01,  4.457755e-01},
  { 1.282337e-01,  9.493843e-01, -2.867500e-01,  1.666976e-01,  6.815522e-01,  4.262021e-01},
  {-4.972376e-01,  8.412806e-01,  2.121360e-01,  1.888392e-01,  6.864005e-01,  4.221088e-01},
  { 5.953742e-02,  9.960621e-01,  6.569210e-02,  1.431690e-01,  6.834681e-01,  4.162332e-01},
  {-6.450633e-01,  5.866376e-01,  4.896425e-01, -1.832143e-01,  6.815391e-01,  4.149782e-01},
  { 5.636513e-02,  9.780880e-01,  2.004171e-01,  1.489360e-01,  6.839385e-01,  3.921627e-01},
  { 2.093938e-01,  7.969320e-01,  5.666160e-01,  1.446366e-01,  6.981301e-01,  3.561488e-01},
  {-1.165813e-01,  9.435632e-01,  3.099956e-01,  1.714741e-01,  6.957983e-01,  3.587792e-01},
  { 6.865671e-01,  3.685460e-01,  6.267371e-01,  3.940036e-01,  6.948510e-01,  3.202570e-01},
  { 7.967756e-01, -1.372454e-01,  5.884830e-01,  4.760959e-01,  6.793653e-01,  3.038338e-01},
  { 3.319013e-01,  4.226090e-01,  8.433524e-01, -1.201831e-01,  6.751419e-01,  2.056663e-01},
  {-6.372630e-02,  3.557353e-01,  9.324116e-01,  8.338584e-04,  6.793256e-01,  1.887861e-01},
  {-5.301985e-01, -6.708964e-01, -5.184473e-01, -1.882808e-01,  6.830398e-01,  1.512181e-01},
  {-4.252391e-01, -4.389614e-01, -7.915078e-01, -1.186468e-01,  6.737674e-01,  8.953244e-02},
  { 4.399886e-01, -5.442140e-01, -7.143117e-01,  3.231907e-01,  6.731081e-01,  6.121963e-02},
  {-5.193891e-01, -1.205344e-01, -8.459943e-01,  1.221443e-01,  6.828379e-01,  6.936444e-02},
  {-7.477255e-01, -4.379186e-01, -4.991330e-01,  1.458289e-01,  6.824048e-01,  5.092876e-02},
  { 9.719412e-01, -2.136271e-01,  9.845711e-02,  2.958670e-01,  6.936254e-01, -2.609082e-02},
  { 6.513547e-01, -5.785994e-01,  4.908765e-01,  3.251107e-01,  6.725854e-01, -1.489749e-01},
  {-8.603387e-01, -3.873624e-01, -3.313121e-01,  1.690370e-01,  6.897732e-01, -2.023810e-01},
  { 9.418724e-01,  7.028716e-02, -3.285366e-01,  5.038949e-01,  6.788597e-01, -2.212142e-01},
  {-7.071068e-01, -7.071068e-01,  0.000000e+00, -1.292324e-01,  6.929345e-01, -2.228482e-01},
  {-4.461064e-01, -8.153970e-01,  3.689402e-01, -1.275474e-01,  6.912364e-01, -2.245438e-01},
  {-7.071068e-01, -7.071068e-01,  0.000000e+00, -1.295835e-01,  6.987787e-01, -2.193948e-01},
  {-9.390733e-01, -3.433052e-01,  1.681347e-02,  1.943283e-01,  6.696486e-01, -2.948511e-01},
  {-3.556708e-01, -3.789633e-01, -8.543331e-01, -6.054032e-02,  6.884582e-01, -2.665877e-01},
  { 2.730786e-01, -5.099595e-02, -9.606391e-01,  3.851184e-01,  6.894625e-01, -2.998319e-01},
  { 9.863050e-01, -1.508707e-01,  6.663687e-02,  5.038770e-01,  6.911156e-01, -3.475921e-01},
  { 9.295521e-01, -1.003191e-01, -3.547801e-01,  3.431814e-01,  6.860908e-01, -3.636858e-01},
  {-5.137558e-01, -8.520320e-01,  1.004814e-01,  9.663881e-02,  6.960493e-01, -3.698240e-01},
  { 7.071068e-01,  0.000000e+00, -7.071068e-01,  9.165360e-02,  7.027153e-01, -3.702277e-01},
  { 8.842091e-01,  1.145993e-01, -4.528148e-01,  3.427156e-01,  6.808926e-01, -3.895594e-01},
  {-7.299684e-01, -3.511131e-01, -5.864007e-01,  1.093345e-01,  6.901084e-01, -3.868790e-01},
  {-7.585539e-01, -1.677275e-01, -6.296534e-01,  1.212269e-01,  6.874787e-01, -4.005161e-01},
  {-2.722159e-02,  6.926041e-01,  7.208042e-01, -1.267527e-02,  6.734965e-01, -6.413363e-01},
  {-4.208016e-01,  8.126485e-01,  4.031482e-01, -5.296727e-02,  6.615618e-01, -6.464085e-01},
  {-4.523233e-01,  5.032045e-01, -7.363347e-01,  6.516463e-02,  6.799260e-01, -7.073587e-01},
  { 1.977462e-01, -1.521722e-01,  9.683698e-01,  3.166220e-01,  6.963529e-01,  7.232763e-01},
  { 9.723973e-01, -1.749996e-01, -1.543329e-01,  5.131472e-01,  7.121614e-01,  6.504432e-01},
  { 6.570874e-01, -7.430010e-01, -1.272224e-01,  5.074155e-01,  7.103313e-01,  5.966223e-01},
  { 4.837624e-01, -8.700584e-01, -9.472281e-02,  4.511286e-01,  6.960530e-01,  5.385131e-01},
  {-5.958856e-01,  1.522376e-01,  7.885074e-01,  3.051412e-01,  7.011126e-01,  5.110250e-01},
  {-2.220459e-03,  1.513967e-01,  9.884706e-01,  2.349949e-01,  6.886014e-01,  5.025228e-01},
  {-3.276721e-01,  9.297088e-01,  1.681441e-01,  2.039205e-01,  6.953628e-01,  4.897671e-01},
  {-2.704132e-01, -4.004276e-01,  8.755195e-01,  4.878900e-02,  6.902166e-01,  5.020553e-01},
  {-5.428408e-01,  8.349944e-01,  9.004524e-02,  2.052014e-01,  7.012851e-01,  4.015423e-01},
  {-8.351449e-01,  3.752853e-01, -4.021120e-01, -1.840198e-01,  6.920967e-01,  3.983161e-01},
  {-4.144301e-01, -1.424713e-01, -8.988603e-01, -1.239559e-01,  6.938581e-01,  3.723662e-01},
  {-9.157643e-01,  2.878079e-01, -2.802541e-01, -1.753406e-01,  7.013663e-01,  3.905678e-01},
  {-2.365259e-01,  7.046691e-01,  6.689521e-01,  1.931542e-01,  7.058015e-01,  3.529721e-01},
  { 4.317159e-01,  5.129017e-01,  7.419927e-01,  3.935628e-01,  7.173017e-01,  3.087452e-01},
  { 9.714951e-01, -2.350719e-01,  3.063602e-02,  4.897704e-01,  7.058469e-01,  2.630942e-01},
  {-9.468029e-01, -2.849722e-01, -1.495166e-01,  8.401692e-02,  6.929766e-01,  2.659740e-01},
  { 7.757191e-02,  4.535826e-01,  8.878319e-01, -2.071318e-01,  6.918546e-01,  2.236426e-01},
  {-4.405192e-01,  3.708543e-01,  8.175635e-01, -2.241378e-01,  6.960232e-01,  2.192260e-01},
  {-1.884571e-01,  5.456931e-01,  8.165188e-01, -2.005114e-02,  6.864988e-01,  1.818572e-01},
  {-7.597054e-01, -5.864472e-01, -2.809402e-01, -2.228691e-01,  7.060028e-01,  1.695971e-01},
  { 9.349495e-01,  2.805832e-02,  3.536695e-01,  4.783071e-01,  7.047043e-01,  1.566795e-01},
  {-1.974973e-01, -3.471085e-01, -9.167936e-01,  1.063992e-01,  7.015765e-01,  6.921012e-02},
  { 3.839796e-01, -5.829082e-01, -7.160851e-01,  3.201176e-01,  6.946204e-01,  4.235570e-02},
  {-4.304001e-01, -7.630957e-01, -4.821212e-01, -1.238435e-01,  6.986167e-01,  5.974116e-02},
  {-9.930283e-01,  9.454842e-03, -1.174962e-01,  1.557553e-01,  7.085444e-01, -2.980853e-02},
  {-7.472085e-01, -6.093771e-01,  2.652149e-01,  3.730570e-01,  6.924801e-01, -1.267363e-01},
  {-8.522432e-02, -8.036016e-01,  5.890343e-01,  3.544622e-01,  6.909529e-01, -1.435291e-01},
  { 4.339687e-01, -4.214914e-01,  7.962514e-01, -1.294382e-01,  7.108676e-01, -2.131215e-01},
  { 8.783718e-01,  3.247673e-01, -3.506980e-01,  4.978085e-01,  6.928738e-01, -2.200105e-01},
  { 9.982490e-01,  4.491989e-02,  3.848587e-02,  4.735193e-01,  7.105244e-01, -2.672272e-01},
  {-7.026209e-01, -6.922507e-01, -1.646601e-01,  1.791995e-01,  6.951282e-01, -2.821778e-01},
  {-6.779344e-01, -2.142169e-01, -7.032184e-01, -3.328741e-02,  7.126711e-01, -2.913808e-01},
  {-6.457806e-01, -5.362833e-01, -5.434775e-01,  7.190327e-02,  7.191916e-01, -3.550969e-01},
  { 9.456198e-01,  4.602221e-02, -3.220020e-01,  5.045486e-01,  7.076587e-01, -3.609966e-01},
  { 6.624939e-02,  8.388159e-01, -5.403693e-01,  3.102659e-01,  6.998659e-01, -3.916995e-01},
  { 1.920247e-01,  8.022193e-01, -5.653058e-01,  3.259746e-01,  7.026472e-01, -3.818997e-01},
  {-4.700114e-02,  6.004409e-01, -7.982866e-01,  1.478872e-01,  6.947264e-01, -4.010442e-01},
  {-2.624813e-01,  7.786658e-01,  5.698974e-01,  1.258352e-01,  6.868591e-01, -6.289622e-01},
  { 9.125417e-01,  1.915995e-01, -3.613270e-01,  1.453721e-01,  6.830384e-01, -6.445106e-01},
  {-2.542276e-02,  9.928819e-01,  1.163585e-01,  1.337790e-01,  6.889042e-01, -6.442342e-01},
  {-4.228372e-02,  9.353091e-01,  3.512963e-01, -9.424149e-03,  6.875001e-01, -6.667056e-01},
  { 2.266777e-01,  9.726985e-01,  4.974854e-02,  1.366995e-01,  6.865112e-01, -6.805828e-01},
  { 4.548315e-02,  9.245993e-01,  3.782162e-01,  9.854048e-02,  6.903295e-01, -6.830417e-01},
  {-4.884208e-01,  6.533138e-01, -5.784688e-01, -7.271674e-03,  6.898397e-01, -6.772184e-01},
  {-2.060850e-01,  8.281155e-01, -5.213001e-01,  3.814752e-02,  6.904785e-01, -6.939127e-01},
  { 7.984172e-01,  2.234905e-01, -5.590904e-01,  1.236697e-01,  6.849483e-01, -7.090150e-01},
  { 3.356068e-01,  8.339506e-01, -4.380576e-01,  1.044809e-01,  6.855130e-01, -7.255971e-01},
  { 1.661120e-02,  6.495675e-01, -7.601223e-01,  9.732989e-02,  6.874631e-01, -7.295433e-01},
  { 7.823343e-01, -9.344093e-02,  6.158099e-01,  5.133263e-01,  7.205890e-01,  7.359831e-01},
  { 4.232139e-01,  2.678427e-01,  8.655347e-01,  3.307622e-01,  7.145126e-01,  7.150616e-01},
  { 7.366303e-01, -6.714610e-01,  8.072069e-02,  5.174837e-01,  7.201319e-01,  6.840268e-01},
  {-1.928836e-02,  8.053460e-01,  5.924913e-01,  2.036467e-01,  6.937446e-01,  5.113795e-01},
  {-3.715652e-01,  4.729053e-02,  9.272016e-01, -3.430299e-02,  7.275944e-01,  5.171606e-01},
  {-4.145235e-01,  6.409590e-01,  6.460201e-01,  2.528408e-01,  7.123716e-01,  4.793774e-01},
  { 4.604461e-01,  8.536797e-01,  2.433527e-01,  6.343459e-02,  7.207338e-01,  4.053275e-01},
  {-9.218243e-01, -6.691910e-02, -3.817876e-01, -1.680723e-01,  7.212275e-01,  3.771267e-01},
  { 1.929625e-01,  5.098635e-01,  8.383344e-01,  1.604758e-01,  7.374384e-01,  3.216985e-01},
  { 9.459087e-01,  1.774756e-01,  2.715863e-01,  4.905199e-01,  7.139070e-01,  2.839161e-01},
  {-8.834253e-02,  5.230803e-01,  8.476925e-01, -8.321034e-03,  7.197257e-01,  1.463805e-01},
  {-1.381076e-01, -7.662295e-01, -6.275497e-01,  3.338667e-01,  7.120420e-01,  2.615332e-02},
  { 7.788504e-01, -4.611921e-01, -4.250809e-01,  3.089767e-01,  7.113955e-01,  1.913588e-02},
  {-1.027584e-01, -4.040464e-01, -9.089484e-01, -1.399676e-01,  7.279273e-01,  8.850685e-03},
  { 8.828668e-01, -4.333079e-01,  1.810811e-01,  3.022350e-01,  7.267017e-01, -2.989620e-02},
  {-5.765747e-01, -7.881107e-01,  2.155068e-01,  3.706928e-01,  7.120246e-01, -9.001861e-02},
  {-4.321968e-01, -9.017745e-01, -2.950644e-03,  1.499313e-01,  7.163190e-01, -2.074809e-01},
  { 9.507060e-01, -1.027502e-01,  2.925755e-01,  4.775965e-01,  7.282835e-01, -2.866751e-01},
  {-4.088377e-01, -7.068084e-02, -9.098659e-01,  4.119985e-01,  7.327801e-01, -3.043516e-01},
  { 5.018633e-01, -1.292011e-01, -8.552428e-01,  3.784036e-01,  7.221419e-01, -3.050274e-01},
  {-2.386891e-01,  7.673261e-01, -5.951792e-01,  2.725077e-01,  7.302483e-01, -3.112305e-01},
  {-4.076442e-01, -9.113186e-01, -5.765971e-02,  1.637943e-01,  7.069669e-01, -2.924975e-01},
  { 9.977529e-01,  6.495012e-02,  1.644880e-02,  5.057427e-01,  7.119730e-01, -3.455058e-01},
  {-4.620751e-01, -8.351780e-01, -2.982689e-01,  5.426301e-02,  7.268275e-01, -3.410932e-01},
  { 9.063213e-02,  9.619598e-01, -2.577194e-01,  1.117977e-01,  6.915345e-01, -7.054046e-01},
  { 4.502864e-01,  1.109089e-01,  8.859692e-01,  3.278141e-01,  7.196561e-01,  7.181250e-01},
  {-1.973291e-01,  7.317688e-01,  6.523616e-01,  3.172410e-01,  7.241712e-01,  7.135258e-01},
  {-8.330446e-01,  5.200227e-01,  1.887140e-01,  3.162280e-01,  7.336451e-01,  6.935711e-01},
  {-7.179939e-01,  4.427913e-01,  5.370482e-01,  4.647180e-01,  7.352855e-01,  6.826099e-01},
  { 3.413708e-01,  8.839427e-01,  3.195482e-01,  1.174130e-01,  7.270645e-01,  6.037626e-01},
  {-3.523364e-01, -9.351049e-01,  3.791984e-02,  1.009880e-01,  7.297091e-01,  5.979519e-01},
  {-2.859431e-01, -8.559359e-01,  4.308250e-01,  1.397114e-01,  7.140466e-01,  5.715169e-01},
  {-4.611479e-01,  3.213107e-01,  8.271046e-01, -2.135077e-02,  7.381082e-01,  5.201480e-01},
  {-3.940974e-01,  8.869371e-01,  2.408937e-01, -3.193516e-02,  7.402644e-01,  4.703417e-01},
  { 8.528050e-01, -1.952735e-01, -4.843468e-01,  3.982247e-01,  7.466967e-01,  3.993107e-01},
  {-4.623557e-01,  6.291856e-01,  6.247821e-01, -1.611095e-01,  7.290115e-01,  3.881982e-01},
  { 8.609988e-01,  3.118042e-01,  4.018200e-01,  3.772149e-01,  7.455416e-01,  3.254051e-01},
  { 3.551014e-01,  4.948870e-01,  7.930888e-01,  1.344716e-01,  7.328109e-01,  3.343354e-01},
  { 4.383203e-01,  4.206405e-01,  7.943153e-01,  4.832052e-01,  7.213677e-01,  2.927809e-01},
  { 4.602745e-01,  7.317826e-01,  5.026348e-01,  4.787574e-01,  7.277686e-01,  2.880308e-01},
  {-1.948775e-01,  5.486504e-01,  8.130224e-01,  1.903033e-01,  7.413194e-01,  3.165423e-01},
  { 1.652758e-01,  4.241905e-01,  8.903630e-01,  1.635732e-01,  7.522018e-01,  3.137399e-01},
  {-4.804831e-01, -3.892926e-01, -7.858672e-01,  4.253588e-02,  7.378784e-01,  2.847623e-01},
  {-7.457056e-01, -1.211944e-01,  6.551602e-01, -2.568241e-01,  7.352324e-01,  2.006897e-01},
  { 9.045408e-02,  9.108804e-01,  4.026351e-01, -2.314750e-01,  7.456790e-01,  1.876696e-01},
  {-5.794618e-01,  4.605618e-01,  6.723889e-01,  4.282707e-02,  7.400433e-01,  1.493172e-01},
  { 9.506805e-01,  1.340284e-01,  2.797193e-01,  4.904504e-01,  7.481946e-01,  1.148820e-01},
  { 8.386909e-01,  4.223197e-01,  3.438658e-01,  4.944772e-01,  7.455451e-01,  1.074798e-01},
  {-9.233596e-01, -3.660793e-01, -1.157278e-01, -2.788476e-01,  7.471268e-01,  7.608376e-02},
  { 9.742882e-01,  1.770097e-01,  1.393919e-01,  5.378538e-01,  7.385236e-01,  1.736430e-02},
  {-3.477358e-01, -7.507080e-01, -5.617092e-01, -2.388134e-01,  7.452448e-01,  3.743744e-02},
  {-7.148935e-01, -1.921977e-01, -6.723000e-01, -2.649991e-01,  7.609587e-01,  4.159274e-02},
  {-2.938139e-01, -4.414332e-01, -8.478268e-01, -1.859992e-01,  7.505499e-01,  1.405249e-02},
  {-7.067869e-01, -6.352993e-01, -3.112025e-01,  3.461830e-01,  7.331166e-01, -2.005712e-02},
  {-3.816201e-01, -8.564630e-01,  3.476164e-01,  3.447865e-01,  7.351133e-01, -9.247582e-02},
  { 4.664467e-01, -7.366024e-01,  4.897392e-01,  3.321799e-01,  7.361245e-01, -9.209667e-02},
  {-9.907494e-01,  1.239174e-01, -5.531885e-02, -1.214008e-01,  7.414405e-01, -2.142349e-01},
  { 9.647595e-01,  2.474460e-01,  8.949660e-02,  4.716272e-01,  7.420393e-01, -2.255563e-01},
  {-3.821835e-01, -9.113736e-01,  1.527544e-01,  1.461614e-01,  7.262967e-01, -2.421506e-01},
  {-4.419670e-01, -6.883267e-01, -5.752144e-01,  4.381318e-03,  7.412333e-01, -3.225176e-01},
  {-5.504313e-01, -2.709960e-01, -7.896751e-01, -9.011058e-03,  7.460061e-01, -3.218545e-01},
  { 3.703305e-01,  6.526974e-01, -6.609399e-01,  3.324148e-01,  7.285492e-01, -3.489600e-01},
  {-3.687620e-01, -3.460227e-03, -9.295174e-01,  4.629629e-02,  7.463052e-01, -3.461997e-01},
  { 4.931528e-01,  8.740477e-02, -8.655407e-01,  4.868741e-01,  7.495961e-01, -3.692912e-01},
  {-6.194640e-01,  4.615445e-01,  6.350126e-01,  4.908327e-01,  7.645214e-01,  7.130579e-01},
  { 2.890811e-01,  8.508595e-01,  4.387143e-01,  8.265790e-02,  7.494373e-01,  5.783491e-01},
  { 2.410820e-01,  7.558534e-01,  6.087406e-01,  5.738318e-02,  7.552240e-01,  5.811737e-01},
  { 8.354870e-02,  9.796169e-01, -1.826758e-01,  4.148771e-03,  7.499451e-01,  5.300927e-01},
  {-1.447752e-01,  7.986980e-01,  5.840561e-01, -2.694184e-02,  7.570644e-01,  4.234725e-01},
  {-4.252360e-01,  5.314131e-01,  7.326489e-01, -7.103454e-02,  7.604417e-01,  3.869981e-01},
  { 9.459110e-01, -1.400199e-01, -2.926548e-01,  3.769085e-01,  7.604399e-01,  3.562858e-01},
  { 5.049219e-01,  4.852227e-02,  8.618001e-01,  8.174175e-02,  7.532496e-01,  3.674539e-01},
  {-7.634054e-01,  4.801291e-01,  4.320744e-01,  2.204120e-01,  7.631491e-01,  3.223088e-01},
  { 4.684043e-01,  1.518580e-01,  8.703657e-01,  1.432690e-01,  7.669811e-01,  3.194571e-01},
  {-9.525364e-01, -1.188303e-01,  2.802744e-01,  6.705569e-02,  7.479234e-01,  2.074796e-01},
  { 3.467168e-02,  7.256465e-01,  6.871936e-01, -2.458731e-01,  7.430917e-01,  1.962737e-01},
  {-6.855146e-01,  6.221376e-01,  3.781728e-01, -2.740834e-01,  7.448523e-01,  1.776052e-01},
  { 4.632210e-01, -7.930964e-01, -3.955054e-01,  3.143804e-01,  7.407533e-01, -1.462277e-02},
  { 3.078350e-01, -9.513350e-01, -1.411436e-02,  3.170833e-01,  7.436523e-01, -3.385491e-02},
  {-3.955179e-01,  3.787204e-01, -8.367416e-01,  2.754819e-01,  7.583990e-01, -2.845594e-01},
  { 7.959130e-02, -3.796827e-01, -9.216866e-01,  4.119428e-01,  7.547581e-01, -3.058813e-01},
  {-4.914832e-02, -9.913213e-01, -1.219283e-01,  5.700505e-02,  7.363809e-01, -2.988220e-01},
  {-8.531407e-01,  3.655683e-01, -3.721703e-01, -2.182248e-02,  7.435880e-01, -3.080564e-01},
  {-2.302840e-02,  2.283689e-01, -9.733023e-01,  3.503186e-01,  7.626974e-01, -3.272247e-01},
  { 8.498952e-01,  2.528340e-01,  4.623345e-01,  3.490127e-01,  7.840286e-01,  7.024996e-01},
  {-7.696257e-01,  3.017910e-01,  5.626708e-01,  4.777045e-01,  7.814046e-01,  6.685079e-01},
  { 8.092155e-01,  2.582530e-01,  5.277079e-01,  3.648464e-01,  7.807987e-01,  6.562533e-01},
  {-6.674818e-01,  3.173710e-01,  6.736050e-01,  4.568481e-01,  7.776378e-01,  6.403596e-01},
  { 3.829039e-01,  8.621143e-01,  3.318790e-01,  6.337538e-02,  7.596462e-01,  5.740770e-01},
  { 3.145505e-01,  8.532363e-01, -4.159878e-01,  1.967043e-02,  7.598765e-01,  5.621998e-01},
  { 7.962498e-01, -3.385271e-01, -5.013838e-01,  4.841239e-01,  7.873036e-01,  4.820819e-01},
  {-7.497146e-01, -5.781535e-01,  3.219729e-01,  2.942184e-01,  7.645360e-01,  4.998237e-01},
  {-9.176326e-01,  2.851693e-01,  2.768192e-01,  2.195680e-01,  7.838071e-01,  4.392461e-01},
  {-1.645732e-02,  2.982000e-01,  9.543615e-01, -2.317769e-02,  7.821319e-01,  4.055790e-01},
  {-2.460366e-01, -6.594456e-01, -7.103502e-01, -9.611361e-02,  7.838781e-01,  2.985890e-01},
  { 9.668032e-01,  7.919400e-02,  2.429399e-01,  4.913253e-01,  7.892050e-01,  1.872485e-01},
  {-9.765291e-01,  1.141309e-01, -1.826611e-01,  6.227938e-02,  7.839087e-01,  1.523806e-01},
  {-1.270021e-01,  5.740345e-01,  8.089220e-01, -1.985981e-01,  7.765370e-01,  1.026941e-01},
  {-4.061140e-01,  7.922438e-01,  4.554351e-01, -2.362555e-01,  7.703873e-01,  1.037406e-01},
  { 1.121899e-01, -2.674715e-01, -9.570122e-01,  1.420507e-03,  7.781758e-01,  3.819792e-02},
  { 9.823128e-01,  1.862022e-01,  1.975873e-02,  5.115529e-01,  7.902209e-01, -3.876734e-02},
  { 4.300340e-01, -8.439158e-01,  3.207445e-01,  3.286853e-01,  7.459339e-01, -5.372969e-02},
  {-8.783844e-01, -4.758792e-01, -4.449774e-02,  1.382080e-01,  7.617613e-01, -8.124656e-02},
  {-3.844227e-01, -5.397558e-01,  7.489212e-01, -1.819386e-02,  7.842816e-01, -1.047140e-01},
  {-9.588965e-01,  2.716798e-01,  8.190036e-02, -1.133806e-01,  7.765238e-01, -2.208867e-01},
  {-4.354689e-01,  8.511468e-02, -8.961710e-01, -1.070038e-01,  7.750787e-01, -2.342125e-01},
  {-3.404794e-01, -1.901004e-01, -9.208342e-01,  4.348351e-01,  7.815367e-01, -3.228394e-01},
  { 9.706358e-01, -2.130172e-01, -1.117579e-01,  5.011721e-01,  7.735317e-01, -3.418085e-01},
  { 9.829631e-01,  2.800876e-02, -1.816562e-01,  5.007789e-01,  7.677337e-01, -3.473912e-01},
  {-2.779022e-01,  1.663322e-01, -9.460993e-01,  3.236022e-02,  7.799250e-01, -3.357796e-01},
  { 7.963963e-01, -5.628993e-01, -2.211274e-01,  4.956357e-01,  7.905788e-01, -3.755107e-01},
  {-2.324884e-02, -2.575973e-01, -9.659726e-01,  4.842233e-01,  7.850024e-01, -3.766364e-01},
  {-5.879761e-01,  4.821283e-01,  6.494893e-01,  5.079415e-01,  7.843654e-01,  7.198721e-01},
  { 4.488651e-01,  4.396873e-01,  7.779429e-01,  3.445435e-01,  7.922892e-01,  7.036955e-01},
  { 2.122093e-01, -9.933379e-02,  9.721625e-01,  2.840766e-02,  7.907348e-01,  3.900950e-01},
  {-5.562459e-01,  3.457294e-01,  7.556862e-01, -9.308904e-02,  8.010651e-01,  3.502675e-01},
  {-8.891959e-01,  2.694199e-01,  3.697886e-01, -1.648790e-01,  7.991328e-01,  3.280452e-01},
  { 3.550355e-03,  2.552185e-01,  9.668769e-01,  2.030649e-01,  7.984402e-01,  2.948947e-01},
  {-5.545574e-01,  2.755571e-01,  7.851970e-01,  5.574484e-02,  7.962143e-01,  1.339057e-01},
  {-3.806958e-02, -3.267109e-01, -9.443573e-01,  5.179493e-02,  7.836438e-01,  4.469072e-02},
  {-9.082620e-01,  3.972652e-01,  1.313038e-01, -2.618096e-01,  7.927747e-01,  5.384561e-02},
  {-5.371779e-01, -8.202540e-01,  1.965284e-01,  1.076597e-01,  7.911439e-01, -4.563950e-02},
  { 9.670506e-01, -1.595604e-01,  1.983777e-01,  4.530760e-01,  8.074027e-01, -2.252562e-01},
  {-2.426282e-01,  7.146295e-01, -6.560764e-01,  5.050502e-03,  7.996631e-01, -2.229201e-01},
  { 2.183777e-01,  7.448983e-01, -6.304266e-01,  1.729602e-01,  7.924394e-01, -2.578862e-01},
  {-7.608106e-01,  2.358002e-01, -6.046202e-01, -1.073390e-01,  7.922748e-01, -2.341429e-01},
  {-1.029369e-01, -2.029209e-01, -9.737695e-01,  3.302982e-01,  7.961742e-01, -3.241594e-01},
  { 4.981155e-01,  7.098005e-01, -4.980605e-01,  1.251366e-01,  7.837988e-01, -3.434934e-01},
  { 6.356858e-02,  5.672463e-01, -8.210912e-01,  9.921081e-02,  7.864197e-01, -3.459893e-01},
  { 1.925847e-01, -5.029237e-01, -8.426025e-01,  5.025665e-01,  8.134630e-01, -3.884258e-01},
  {-6.459866e-01,  4.404110e-01,  6.234898e-01,  3.314542e-01,  8.090363e-01,  6.854581e-01},
  { 7.410408e-01,  4.785919e-01,  4.709653e-01,  3.535583e-01,  8.058822e-01,  6.576447e-01},
  {-5.153203e-02,  5.763614e-01,  8.155685e-01,  4.020278e-01,  8.195781e-01,  5.810974e-01},
  { 7.022238e-01, -3.982332e-01, -5.901629e-01,  4.382851e-01,  8.110386e-01,  4.321267e-01},
  {-3.421091e-02, -4.947115e-01,  8.683836e-01,  4.752495e-02,  8.070654e-01,  3.899010e-01},
  {-2.456406e-01, -2.170082e-01,  9.447582e-01,  2.159030e-02,  8.137312e-01,  3.975028e-01},
  {-1.424077e-01, -6.003413e-01, -7.869627e-01, -4.914691e-02,  8.220795e-01,  2.287091e-01},
  {-7.935748e-01, -4.526096e-01,  4.066742e-01, -9.201489e-02,  8.209236e-01, -1.182087e-01},
  {-5.071675e-01, -8.492632e-01,  1.467422e-01, -1.006634e-01,  8.235015e-01, -1.223146e-01},
  { 8.863716e-01,  3.468830e-01, -3.066229e-01,  4.951117e-01,  8.081620e-01, -1.357535e-01},
  { 1.118535e-01,  3.326144e-01, -9.364062e-01,  1.670776e-01,  8.266110e-01, -2.231305e-01},
  { 4.396918e-01,  8.402917e-01, -3.171451e-01,  1.114278e-01,  8.041188e-01, -3.107093e-01},
  { 3.170520e-02, -3.400861e-01, -9.398597e-01,  3.478440e-01,  8.200131e-01, -3.270735e-01},
  { 1.019641e-01,  6.555089e-01, -7.482722e-01,  7.062934e-02,  8.053160e-01, -3.332569e-01},
  { 7.856144e-01, -5.428878e-01,  2.967875e-01,  5.056124e-01,  8.112416e-01, -3.696720e-01},
  { 6.227874e-01,  3.725944e-01,  6.879747e-01,  5.167046e-01,  8.156201e-01,  7.031636e-01},
  { 1.897588e-01,  8.381033e-01,  5.114434e-01,  3.415723e-01,  8.143682e-01,  6.843306e-01},
  { 6.098110e-01,  6.998795e-01,  3.718861e-01,  3.358480e-01,  8.210989e-01,  6.618295e-01},
  {-6.864913e-03,  8.053839e-01,  5.927137e-01,  3.112946e-01,  8.271340e-01,  6.661164e-01},
  {-5.487348e-01, -8.359960e-01, -8.996154e-04,  2.875020e-01,  8.324435e-01,  6.652634e-01},
  { 4.570668e-01,  7.829655e-01,  4.219655e-01,  3.421152e-01,  8.404016e-01,  5.689398e-01},
  { 1.089660e-01,  3.104560e-01,  9.443217e-01,  3.596311e-01,  8.427259e-01,  5.611092e-01},
  {-9.385790e-01, -3.389646e-01,  6.459549e-02,  2.274378e-01,  8.315610e-01,  5.484759e-01},
  {-9.869677e-01,  1.247383e-01, -1.016611e-01,  2.199330e-01,  8.320768e-01,  5.007612e-01},
  { 9.335782e-01, -2.244544e-01, -2.793778e-01,  5.083987e-01,  8.347707e-01,  4.810000e-01},
  {-4.306294e-01,  1.316829e-01,  8.928706e-01, -5.470615e-02,  8.184575e-01,  3.886330e-01},
  { 3.476194e-02, -7.822904e-01, -6.219432e-01, -1.621205e-01,  8.234442e-01,  2.976201e-01},
  { 3.723274e-01,  1.014381e-01,  9.225414e-01,  1.827360e-01,  8.353721e-01,  2.921577e-01},
  {-7.798520e-01, -8.188453e-02, -6.205850e-01, -1.152137e-01,  8.408298e-01,  2.462896e-01},
  { 5.867937e-01,  4.196791e-01,  6.924902e-01,  4.827945e-01,  8.308265e-01,  2.236115e-01},
  {-6.903844e-01,  5.139428e-01,  5.091484e-01, -2.442999e-01,  8.230489e-01,  5.685143e-02},
  { 6.717776e-02, -4.889224e-01, -8.697367e-01, -7.245593e-02,  8.229907e-01,  1.316363e-02},
  {-1.427351e-01, -4.591041e-01, -8.768410e-01, -1.946982e-01,  8.277472e-01,  8.944496e-03},
  {-8.955746e-01,  8.028478e-02, -4.376075e-01, -2.392591e-01,  8.385108e-01,  1.716483e-02},
  {-6.937021e-01, -4.978236e-01, -5.205277e-01, -2.301372e-01,  8.443502e-01, -1.954401e-03},
  {-3.412020e-01,  1.549234e-01, -9.271353e-01,  2.242060e-01,  8.325105e-01, -2.169130e-01},
  {-2.760219e-02,  2.208832e-01, -9.749096e-01,  1.989969e-01,  8.382606e-01, -2.133963e-01},
  { 7.811059e-01, -1.623184e-01,  6.029314e-01,  4.665266e-01,  8.323177e-01, -2.425429e-01},
  { 4.461882e-02,  9.627980e-01, -2.665128e-01,  6.751535e-02,  8.249959e-01, -2.548383e-01},
  { 5.358273e-02,  7.227384e-01, -6.890414e-01,  6.045264e-02,  8.104703e-01, -3.320356e-01},
  {-4.996499e-01,  7.129420e-01, -4.919995e-01,  3.682149e-02,  8.138672e-01, -3.232833e-01},
  {-1.559915e-01, -4.374065e-01, -8.856309e-01,  5.390584e-01,  8.409730e-01, -4.107112e-01},
  {-2.179409e-01,  4.091374e-01,  8.860634e-01,  5.066217e-01,  8.406196e-01,  6.875700e-01},
  { 8.968810e-01,  2.239955e-01,  3.813535e-01,  5.182526e-01,  8.544840e-01,  6.728485e-01},
  {-5.603741e-01, -5.486676e-01,  6.204392e-01,  2.818019e-01,  8.361883e-01,  6.621434e-01},
  {-9.212679e-02,  7.018191e-01,  7.063728e-01,  2.746752e-01,  8.391510e-01,  6.537363e-01},
  { 6.666667e-01, -6.666667e-01, -3.333333e-01,  2.538494e-01,  8.382681e-01,  6.333566e-01},
  { 6.666667e-01, -6.666667e-01, -3.333333e-01,  2.488060e-01,  8.414466e-01,  6.299105e-01},
  {-6.596618e-01,  5.579957e-01,  5.034752e-01,  2.430350e-01,  8.458927e-01,  6.213049e-01},
  {-6.541848e-01,  6.120283e-01,  4.443687e-01,  2.313963e-01,  8.437787e-01,  6.074277e-01},
  { 3.680094e-01,  8.223618e-01, -4.339242e-01,  2.338014e-01,  8.460920e-01,  6.138517e-01},
  {-6.561085e-01,  2.757583e-01,  7.024805e-01,  4.274880e-01,  8.469929e-01,  5.722536e-01},
  {-1.982474e-01,  2.609698e-01,  9.447713e-01,  4.012036e-01,  8.493411e-01,  5.588438e-01},
  {-5.386745e-01,  2.966655e-01,  7.885553e-01,  5.697035e-03,  8.475140e-01,  4.054442e-01},
  {-4.808255e-01,  8.274274e-01,  2.901222e-01,  1.771332e-03,  8.596851e-01,  3.210931e-01},
  {-7.868352e-01,  4.518104e-01,  4.204257e-01,  2.735072e-01,  8.537253e-01,  3.081809e-01},
  { 6.257385e-01, -2.095626e-01,  7.513554e-01,  1.437847e-01,  8.506140e-01,  3.202813e-01},
  {-5.853481e-01,  3.409999e-01,  7.355860e-01, -2.178246e-02,  8.562943e-01,  3.053561e-01},
  { 3.476194e-02, -7.822904e-01, -6.219432e-01, -1.160975e-01,  8.473311e-01,  2.701472e-01},
  { 3.476194e-02, -7.822904e-01, -6.219432e-01,  4.955128e-01,  8.508164e-01,  2.102762e-01},
  {-7.911776e-01,  1.739843e-01,  5.863169e-01, -1.181128e-01,  8.607835e-01,  2.347608e-01},
  {-4.629782e-01, -4.761755e-01, -7.476016e-01, -1.140477e-01,  8.576676e-01,  2.240457e-01},
  {-3.112314e-01,  2.727337e-01, -9.103578e-01,  4.732429e-02,  8.534020e-01,  2.110156e-01},
  { 9.342598e-01, -2.578198e-01,  2.463486e-01,  4.986007e-01,  8.625129e-01,  8.588032e-02},
  { 7.723776e-01,  4.946896e-01, -3.983906e-01,  4.940354e-01,  8.511699e-01, -8.788814e-02},
  {-6.931755e-01, -7.137725e-01, -1.001819e-01, -1.497941e-01,  8.604763e-01, -1.438531e-01},
  { 5.645036e-01,  2.916041e-01, -7.722064e-01,  9.233921e-03,  8.600587e-01, -1.717402e-01},
  {-5.969589e-01, -4.695930e-02, -8.008963e-01,  2.421949e-01,  8.445294e-01, -2.297574e-01},
  {-7.947283e-03,  6.364869e-01, -7.712466e-01,  1.131512e-01,  8.522196e-01, -2.271808e-01},
  { 9.068781e-01, -2.207484e-01,  3.589460e-01,  4.898248e-01,  8.606273e-01, -2.562231e-01},
  {-6.979182e-01,  4.870671e-01, -5.250485e-01, -7.876231e-02,  8.401945e-01, -2.272162e-01},
  {-8.661172e-01,  1.899453e-01, -4.623436e-01,  2.857749e-01,  8.502975e-01, -3.006477e-01},
  { 2.352634e-01, -1.343365e-01, -9.626032e-01,  3.936235e-01,  8.559365e-01, -3.190273e-01},
  {-5.974730e-01, -1.658603e-01, -7.845486e-01,  3.027546e-01,  8.506713e-01, -3.277899e-01},
  {-3.245238e-01, -4.325397e-02,  9.448881e-01,  4.295035e-01,  8.725743e-01,  5.669372e-01},
  {-8.751566e-01,  4.095537e-01, -2.576174e-01,  2.292957e-01,  8.630515e-01,  5.322678e-01},
  { 8.777342e-01, -2.758409e-01, -3.917835e-01,  4.959046e-01,  8.774059e-01,  4.243238e-01},
  {-3.939250e-01,  8.305753e-03,  9.191051e-01,  2.231277e-02,  8.613576e-01,  4.268557e-01},
  {-8.254489e-01,  5.447211e-01, -1.480305e-01,  2.952390e-01,  8.644969e-01,  4.169104e-01},
  {-2.860547e-01,  8.399661e-01,  4.611177e-01, -4.977243e-02,  8.381041e-01,  3.871219e-01},
  { 4.163699e-01, -1.394137e-01,  8.984430e-01,  1.854874e-01,  8.689545e-01,  2.939739e-01},
  {-5.698206e-01,  5.566691e-01,  6.045030e-01, -4.334799e-02,  8.712660e-01,  2.783183e-01},
  {-5.698206e-01,  5.566691e-01,  6.045030e-01,  4.971923e-01,  8.686394e-01,  1.968172e-01},
  {-9.406022e-01, -1.524527e-01, -3.033571e-01, -1.246596e-01,  8.712382e-01,  2.225882e-01},
  {-2.191038e-01,  7.991682e-01,  5.597532e-01,  4.318276e-01,  8.673412e-01,  1.825156e-01},
  {-9.358436e-01,  2.920277e-01,  1.972722e-01,  9.440990e-02,  8.808047e-01,  1.690959e-01},
  {-5.070316e-01,  9.766323e-02,  8.563765e-01,  5.250820e-02,  8.752615e-01,  1.109755e-01},
  {-2.863888e-01, -7.966217e-01, -5.323300e-01, -9.779536e-03,  8.548944e-01, -1.736121e-02},
  { 1.612859e-02, -6.584650e-01, -7.524385e-01, -7.042433e-02,  8.553838e-01, -6.328480e-03},
  {-7.205750e-02, -6.262853e-01, -7.762566e-01, -1.244464e-01,  8.646531e-01, -5.597761e-03},
  {-9.667742e-01,  2.417772e-01, -8.301450e-02, -2.309581e-01,  8.709162e-01, -1.187680e-03},
  { 8.217362e-01,  5.088580e-01, -2.565409e-01,  5.041111e-01,  8.703029e-01, -2.418364e-02},
  {-4.377707e-01, -8.967662e-01, -6.455466e-02,  1.022414e-02,  8.485069e-01, -3.296037e-02},
  {-2.016375e-01, -8.672947e-01, -4.551288e-01, -5.171393e-02,  8.633476e-01, -2.128741e-02},
  {-5.244120e-01, -4.366231e-01, -7.309940e-01, -2.190712e-01,  8.697842e-01, -3.310752e-02},
  {-5.693544e-01, -4.229847e-01, -7.049251e-01, -2.237379e-01,  8.675242e-01, -2.989389e-02},
  { 4.502848e-03,  5.256339e-01, -8.506990e-01,  9.017323e-02,  8.803937e-01, -1.492843e-01},
  { 1.690767e-01,  4.313543e-01, -8.861978e-01,  4.717410e-02,  8.713713e-01, -1.562249e-01},
  { 9.503133e-01,  7.393780e-02,  3.023869e-01,  4.397788e-01,  8.694182e-01, -1.730668e-01},
  {-7.254360e-01, -4.273288e-01, -5.395671e-01, -1.693999e-01,  8.825241e-01, -1.796491e-01},
  {-2.464027e-01, -2.991786e-01, -9.218340e-01, -7.787448e-02,  8.711591e-01, -2.108404e-01},
  {-9.602342e-01,  1.313332e-01, -2.463776e-01,  2.933416e-01,  8.774018e-01, -3.184196e-01},
  { 8.831316e-01, -2.251977e-01,  4.115393e-01,  5.089669e-01,  8.704016e-01, -3.367688e-01},
  {-7.326773e-02, -1.504234e-01, -9.859030e-01,  3.290148e-01,  8.762417e-01, -3.522617e-01},
  { 8.607674e-02,  1.801255e-01, -9.798702e-01,  5.408481e-01,  8.690310e-01, -4.090689e-01},
  { 9.877475e-01,  1.016307e-01, -1.184319e-01,  5.166862e-01,  8.852007e-01,  6.665832e-01},
  {-9.591135e-01,  2.822761e-01, -2.053034e-02,  2.218950e-01,  8.760225e-01,  5.679637e-01},
  { 2.232434e-01, -1.843712e-04,  9.747627e-01,  3.005230e-01,  8.877252e-01,  5.589859e-01},
  { 6.246951e-01,  0.000000e+00, -7.808688e-01,  5.375593e-02,  8.762100e-01,  4.363699e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  4.444579e-02,  8.761554e-01,  4.398302e-01},
  { 1.752432e-01,  3.504864e-01, -9.200267e-01,  6.441207e-02,  8.782063e-01,  4.242879e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  7.144044e-02,  8.805526e-01,  4.139931e-01},
  {-2.120099e-01,  8.482722e-01,  4.852691e-01,  8.486567e-02,  8.872939e-01,  3.971653e-01},
  { 1.893409e-01,  3.107176e-01,  9.314530e-01,  1.016188e-01,  8.885832e-01,  3.926241e-01},
  {-6.060577e-01,  1.305500e-01,  7.846341e-01,  2.712619e-01,  8.876873e-01,  2.894823e-01},
  {-9.035910e-02,  2.002026e-01,  9.755789e-01,  2.537402e-01,  8.880712e-01,  2.785970e-01},
  {-1.506151e-01,  9.514057e-01,  2.685932e-01,  4.692256e-01,  8.826697e-01,  1.692763e-01},
  { 2.906283e-01,  9.414682e-01, -1.708005e-01,  4.883101e-01,  8.772322e-01,  1.415362e-01},
  { 7.777590e-01,  4.335503e-01,  4.551101e-01,  4.853659e-01,  8.800845e-01,  1.208693e-01},
  {-5.795862e-02,  9.120961e-01,  4.058590e-01,  4.275514e-01,  8.910945e-01,  1.308654e-01},
  {-1.644776e-01,  2.915204e-01,  9.423179e-01, -1.594710e-01,  8.961191e-01,  8.646755e-02},
  { 9.756644e-01, -1.818081e-01,  1.225748e-01,  5.098788e-01,  8.886790e-01,  4.469978e-02},
  {-8.464134e-01, -2.029980e-01, -4.923171e-01, -2.119666e-01,  9.002301e-01, -5.733569e-02},
  { 6.967492e-01,  6.403719e-01, -3.232097e-01,  4.829317e-01,  8.780432e-01, -7.240006e-02},
  {-1.452752e-01,  4.929677e-01, -8.578333e-01,  1.210837e-01,  8.929465e-01, -1.419792e-01},
  {-4.729557e-01,  7.483436e-01, -4.650751e-01,  1.490125e-01,  8.928878e-01, -1.569103e-01},
  { 2.474064e-01, -4.799237e-02, -9.677224e-01,  5.025302e-02,  8.954415e-01, -1.487920e-01},
  { 4.292001e-01, -3.154174e-03, -9.032039e-01,  2.744390e-02,  8.934395e-01, -1.572782e-01},
  {-2.044518e-01, -5.473502e-01, -8.115463e-01, -6.768448e-02,  8.882994e-01, -2.179355e-01},
  {-4.648250e-01,  3.305189e-01, -8.213981e-01,  2.625690e-01,  8.846747e-01, -2.428208e-01},
  {-3.778289e-01,  4.457048e-01, -8.115373e-01,  1.543169e-01,  8.860744e-01, -2.250382e-01},
  {-3.323781e-01,  5.748951e-01, -7.476768e-01,  1.365533e-01,  8.779266e-01, -2.196043e-01},
  {-5.236614e-02,  6.208438e-02, -9.966962e-01,  4.058665e-01,  8.906996e-01, -3.189474e-01},
  {-8.218559e-01,  7.105275e-02, -5.652471e-01,  2.980864e-01,  8.823212e-01, -3.341891e-01},
  {-5.305463e-01,  4.637115e-02, -8.463866e-01,  3.087839e-01,  8.851486e-01, -3.440270e-01},
  { 9.403432e-01, -2.447627e-01,  2.363172e-01,  5.429489e-01,  8.846633e-01, -3.741654e-01},
  { 9.788489e-01, -9.000306e-03, -2.043867e-01,  5.489414e-01,  8.872916e-01, -3.979771e-01},
  { 9.193303e-01,  2.945350e-02, -3.923829e-01,  5.131892e-01,  8.940722e-01,  6.641963e-01},
  {-6.653205e-01,  6.849191e-01,  2.970428e-01,  2.383284e-01,  8.960875e-01,  5.670232e-01},
  {-7.460159e-01,  6.040935e-01, -2.802343e-01,  3.145007e-01,  9.182227e-01,  4.705239e-01},
  { 1.091799e-01, -2.381033e-02,  9.937367e-01,  1.109364e-01,  9.011158e-01,  3.902499e-01},
  { 5.512730e-01, -4.614542e-01,  6.950957e-01,  1.460069e-01,  9.040773e-01,  3.726380e-01},
  { 3.467028e-01, -7.131002e-01,  6.093318e-01,  1.606663e-01,  9.235850e-01,  3.889583e-01},
  { 3.389854e-01, -6.077864e-01,  7.181119e-01,  1.441590e-01,  9.212182e-01,  3.905891e-01},
  {-5.099775e-01,  3.999327e-01,  7.615620e-01,  7.121124e-02,  9.113566e-01,  3.417698e-01},
  {-7.395966e-01,  6.316836e-01, -2.323201e-01, -5.793329e-02,  9.030870e-01,  2.484874e-01},
  { 9.618166e-01, -2.039434e-01, -1.825265e-01,  3.860296e-01,  9.110179e-01,  2.024952e-01},
  {-7.903734e-01,  3.205715e-01, -5.220574e-01,  8.931546e-02,  9.038609e-01,  2.084920e-01},
  {-3.432360e-01,  8.855382e-01,  3.130670e-01, -7.363325e-02,  8.907549e-01,  2.305470e-01},
  {-3.622203e-01,  7.223641e-01, -5.890557e-01, -1.119197e-01,  8.849699e-01,  2.213229e-01},
  { 8.455511e-01, -5.070427e-01, -1.671857e-01,  5.034564e-01,  8.907101e-01,  1.772635e-01},
  { 2.524710e-01,  9.081234e-01, -3.340213e-01,  5.011869e-01,  8.901772e-01,  1.674015e-01},
  {-7.874435e-01,  2.159585e-01,  5.773168e-01,  9.547150e-02,  9.009044e-01,  1.512575e-01},
  { 4.467593e-01,  4.319308e-01,  7.834807e-01,  4.866438e-01,  9.109395e-01,  9.091930e-02},
  {-2.011579e-01,  1.047921e-01,  9.739375e-01,  4.221196e-03,  8.969401e-01,  9.281742e-02},
  { 7.927316e-01,  3.841741e-01, -4.732724e-01,  5.053704e-01,  8.981608e-01, -6.581235e-04},
  { 6.315075e-01,  7.566321e-01, -1.694289e-01,  4.284228e-01,  9.128170e-01, -4.311008e-02},
  {-5.686355e-02, -9.396620e-01, -3.373453e-01, -1.409628e-01,  8.937032e-01, -4.757451e-02},
  {-2.341806e-01, -9.542978e-01, -1.856746e-01, -8.376116e-02,  8.830003e-01, -6.935357e-02},
  {-7.055960e-01, -6.015908e-01, -3.744633e-01, -2.077865e-01,  9.049041e-01, -6.706472e-02},
  {-4.241849e-01, -7.126883e-01,  5.586971e-01, -1.236333e-01,  8.903682e-01, -1.001393e-01},
  {-4.727506e-01, -8.541192e-01,  2.167650e-01, -1.503626e-01,  8.929703e-01, -1.164666e-01},
  {-8.652614e-01, -4.968162e-01,  6.705525e-02, -1.805703e-01,  9.098079e-01, -1.382559e-01},
  {-8.366998e-01, -1.445796e-02, -5.474709e-01, -1.682286e-01,  9.090111e-01, -1.808508e-01},
  {-1.238614e-01,  5.303066e-01, -8.387093e-01,  2.739871e-01,  9.119877e-01, -2.335941e-01},
  { 9.658429e-01, -1.791849e-03, -2.591221e-01,  5.138105e-01,  9.082674e-01,  6.515592e-01},
  {-1.975553e-01,  5.041195e-01,  8.407351e-01,  4.064374e-01,  9.264465e-01,  5.650026e-01},
  { 5.770705e-01, -7.754988e-02,  8.130041e-01,  3.455874e-01,  9.361694e-01,  5.721068e-01},
  { 9.851360e-01,  1.097746e-01, -1.321231e-01,  5.164603e-01,  9.255688e-01,  5.358351e-01},
  {-2.910799e-01,  3.307477e-03,  9.566931e-01,  1.220684e-01,  9.236668e-01,  3.848980e-01},
  {-6.423254e-01,  2.585981e-01,  7.214881e-01,  9.156948e-02,  9.220183e-01,  3.580609e-01},
  { 2.006927e-01,  6.083772e-01, -7.678539e-01, -5.257160e-02,  9.291360e-01,  2.637577e-01},
  {-7.866666e-01,  7.529493e-02,  6.127694e-01,  9.242476e-02,  9.303896e-01,  1.414530e-01},
  {-6.280242e-01,  6.613557e-01,  4.101149e-01, -1.894621e-01,  9.105607e-01,  6.630341e-02},
  {-2.928678e-01,  9.213666e-01,  2.555620e-01, -1.045835e-01,  9.278081e-01, -8.679902e-03},
  {-8.103287e-01,  5.832179e-01,  5.678259e-02, -2.110146e-01,  9.162863e-01, -1.668272e-02},
  { 8.073757e-01,  5.899174e-01,  1.191510e-02,  4.182880e-01,  9.203199e-01, -1.034031e-01},
  {-9.337440e-01, -3.472057e-01, -8.700781e-02, -1.871450e-01,  9.200283e-01, -1.236310e-01},
  {-6.724017e-01,  6.728793e-01, -3.083982e-01,  1.911524e-01,  9.253873e-01, -1.585917e-01},
  {-9.608970e-01, -1.148709e-02, -2.766677e-01, -1.881470e-01,  9.250917e-01, -1.462704e-01},
  { 6.391259e-01, -2.285034e-01,  7.343734e-01,  4.423817e-01,  9.288718e-01, -1.649085e-01},
  { 6.058272e-01, -2.300947e-01, -7.615969e-01, -1.106520e-02,  9.253196e-01, -1.913929e-01},
  { 9.235517e-01, -2.679013e-01,  2.743741e-01,  4.877616e-01,  9.247105e-01, -2.027200e-01},
  {-7.107860e-01,  6.093318e-01, -3.514226e-01,  3.113664e-01,  9.221525e-01, -2.489983e-01},
  {-6.433207e-01,  6.528996e-01, -3.998257e-01,  1.776767e-01,  9.122949e-01, -2.262403e-01},
  { 9.414823e-01,  1.711317e-02,  3.366276e-01,  4.853047e-01,  9.319715e-01, -2.739232e-01},
  {-7.236678e-01,  5.792603e-01, -3.751830e-01,  3.118124e-01,  9.167267e-01, -3.281434e-01},
  {-4.098962e-01,  6.379148e-01, -6.519584e-01,  3.254144e-01,  9.203178e-01, -3.408954e-01},
  {-3.024999e-01,  5.329760e-01, -7.902091e-01,  3.322123e-01,  9.196479e-01, -3.445420e-01},
  { 4.989933e-01,  3.843992e-01, -7.766872e-01,  5.422506e-01,  9.242626e-01, -3.842635e-01},
  { 8.156254e-01,  3.253784e-01, -4.784184e-01,  5.015866e-01,  9.239632e-01,  6.324639e-01},
  {-3.284861e-01,  5.677556e-01,  7.548182e-01,  4.910762e-01,  9.264529e-01,  6.223220e-01},
  {-5.082827e-01,  6.566346e-01,  5.572072e-01,  4.662537e-01,  9.251810e-01,  6.017517e-01},
  {-5.436426e-01,  5.840158e-01,  6.028086e-01,  4.425061e-01,  9.280782e-01,  5.822936e-01},
  { 2.103608e-01,  3.082813e-01,  9.277452e-01,  3.773771e-01,  9.377789e-01,  5.585476e-01},
  {-9.304280e-02, -5.376784e-01,  8.380006e-01,  1.723354e-01,  9.391438e-01,  4.031930e-01},
  {-5.951189e-01,  2.328097e-01,  7.691769e-01,  2.752892e-01,  9.472530e-01,  2.837430e-01},
  { 8.172836e-01, -2.757573e-01,  5.059699e-01,  2.046517e-01,  9.525699e-01,  2.864853e-01},
  {-9.622233e-03, -1.966393e-02,  9.997604e-01,  2.232560e-01,  9.461293e-01,  2.748439e-01},
  { 9.162763e-01, -3.148872e-01, -2.475556e-01,  3.908723e-01,  9.415308e-01,  2.325210e-01},
  {-9.990101e-01,  1.749819e-02,  4.089956e-02,  1.101514e-01,  9.474751e-01,  1.773844e-01},
  {-9.065511e-01, -4.790126e-02,  4.193693e-01,  1.060702e-01,  9.481333e-01,  1.584680e-01},
  {-2.148011e-01,  2.593752e-01,  9.415864e-01, -9.547151e-04,  9.434063e-01,  9.985931e-02},
  { 6.399342e-01,  2.906190e-01,  7.113542e-01,  5.113681e-01,  9.356071e-01,  7.597721e-02},
  {-3.998896e-01,  6.683761e-01,  6.271855e-01, -6.750300e-02,  9.336331e-01,  8.019862e-02},
  {-1.194575e-01,  9.269645e-01,  3.556215e-01, -1.060435e-01,  9.272176e-01,  7.957340e-02},
  {-2.221071e-01,  7.495670e-01,  6.235527e-01, -1.403845e-01,  9.231681e-01,  7.955791e-02},
  {-2.519042e-01,  9.496594e-01,  1.862560e-01, -1.866480e-01,  9.300912e-01, -1.010117e-02},
  {-7.112850e-01,  6.989014e-01,  7.490410e-02, -2.058830e-01,  9.240448e-01, -2.879008e-02},
  {-3.062171e-01,  8.584893e-01,  4.113722e-01, -1.131123e-01,  9.430481e-01, -3.899352e-02},
  { 8.603525e-01, -6.075476e-02,  5.060657e-01,  4.173236e-01,  9.476665e-01, -1.155103e-01},
  {-9.920883e-02,  9.829567e-01, -1.547703e-01, -9.387837e-02,  9.474787e-01, -1.560189e-01},
  {-3.388563e-01,  9.250149e-01, -1.718252e-01, -1.231318e-01,  9.461625e-01, -1.740055e-01},
  {-6.006755e-01,  5.604104e-01, -5.702009e-01, -1.653044e-01,  9.347181e-01, -1.753419e-01},
  { 9.771956e-01, -2.099050e-01, -3.207219e-02,  5.062157e-01,  9.496052e-01, -1.998868e-01},
  {-5.118132e-01,  4.432214e-01, -7.359360e-01,  3.095814e-01,  9.508492e-01, -2.164868e-01},
  { 9.854130e-01,  1.348339e-01, -1.038310e-01,  4.768881e-01,  9.458367e-01, -2.476813e-01},
  {-8.433016e-01,  9.745822e-02, -5.285304e-01, -1.046300e-01,  9.454772e-01, -2.341764e-01},
  {-5.782579e-01,  6.462547e-02, -8.132905e-01, -1.180518e-01,  9.406020e-01, -2.205416e-01},
  { 2.217305e-01,  1.131612e-01, -9.685196e-01,  3.720163e-01,  9.447109e-01, -3.402447e-01},
  {-4.525284e-01,  6.046136e-01, -6.554849e-01,  3.496675e-01,  9.399567e-01, -3.405175e-01},
  { 3.263691e-02, -2.369950e-01,  9.709625e-01,  3.112853e-01,  9.710965e-01,  6.085857e-01},
  {-5.514245e-01,  7.867756e-01,  2.773356e-01,  2.942883e-01,  9.697378e-01,  6.003765e-01},
  { 3.958745e-01,  7.953783e-01,  4.589736e-01,  5.161231e-01,  9.444817e-01,  5.966990e-01},
  {-6.086066e-01,  2.388198e-01,  7.566790e-01,  2.613865e-01,  9.478673e-01,  5.905076e-01},
  { 5.571991e-01,  8.242539e-01,  1.006711e-01,  5.157091e-01,  9.459971e-01,  5.803434e-01},
  {-5.910007e-01,  7.319804e-01, -3.390026e-01,  2.731922e-01,  9.551372e-01,  5.779844e-01},
  { 7.846260e-01,  6.198251e-01, -1.337298e-02,  5.062426e-01,  9.436437e-01,  5.143003e-01},
  { 2.975795e-01,  8.426852e-01,  4.486960e-01,  4.671646e-01,  9.629703e-01,  4.752927e-01},
  { 4.823875e-01,  7.800726e-01,  3.984834e-01,  4.754997e-01,  9.622026e-01,  4.695699e-01},
  { 8.026847e-01, -3.238603e-01,  5.008110e-01,  1.806152e-01,  9.693021e-01,  4.239961e-01},
  { 9.714199e-01,  1.618885e-01,  1.735957e-01,  5.158775e-01,  9.652583e-01,  3.890600e-01},
  {-7.949746e-01,  4.061347e-01,  4.506330e-01,  2.921491e-01,  9.634978e-01,  2.976455e-01},
  { 9.326141e-01,  3.407217e-01, -1.189102e-01,  3.638172e-01,  9.620444e-01,  1.238551e-01},
  {-3.018246e-01,  1.363343e-01,  9.435650e-01, -2.548512e-02,  9.478859e-01,  9.637423e-02},
  {-9.683270e-01,  2.034438e-01,  1.447528e-01, -2.253233e-02,  9.651824e-01,  4.803881e-02},
  { 1.942955e-01,  9.661036e-01,  1.699795e-01,  4.186516e-01,  9.525928e-01,  3.079958e-02},
  {-4.546920e-01,  7.366585e-01,  5.005891e-01, -1.025702e-01,  9.627788e-01, -5.923769e-02},
  {-1.444869e-01,  2.319057e-01, -9.619477e-01,  1.761436e-01,  9.627460e-01, -1.366915e-01},
  {-4.773622e-02,  8.984466e-01, -4.364803e-01, -6.380439e-02,  9.568430e-01, -1.434025e-01},
  { 5.342727e-01, -4.075852e-01,  7.405585e-01,  4.570112e-01,  9.522561e-01, -1.650354e-01},
  {-5.987937e-01,  7.223943e-01,  3.458217e-01, -5.786176e-02,  9.736934e-01, -2.045189e-01},
  { 8.729621e-01,  2.845419e-01, -3.961984e-01,  4.722777e-01,  9.718714e-01, -2.274356e-01},
  {-2.610605e-01,  3.798838e-01, -8.874322e-01,  2.147884e-01,  9.411948e-01, -2.300327e-01},
  {-1.891442e-01, -5.133600e-01, -8.370698e-01, -5.992964e-02,  9.645782e-01, -2.870261e-01},
  { 5.888528e-01,  3.478278e-01,  7.295671e-01,  4.216982e-01,  9.825388e-01,  4.946243e-01},
  {-3.618366e-01, -2.356312e-01,  9.019713e-01,  9.488828e-02,  9.663071e-01,  3.648675e-01},
  {-3.745790e-01, -6.115655e-01,  6.969063e-01,  5.312554e-03,  9.734794e-01,  3.422369e-01},
  {-8.236997e-01,  3.519499e-01, -4.445786e-01,  4.272146e-02,  9.673334e-01,  2.710757e-01},
  { 8.464913e-01, -3.103107e-01, -4.326197e-01,  4.091690e-01,  9.763356e-01,  2.428529e-01},
  {-5.579934e-01,  1.676450e-02,  8.296760e-01,  5.789342e-02,  9.813653e-01,  1.120442e-01},
  { 8.028098e-01,  5.869524e-01,  1.048003e-01,  3.585321e-01,  9.785805e-01,  7.876170e-02},
  {-5.738026e-01,  1.987719e-01,  7.945063e-01,  3.828388e-03,  9.911673e-01,  7.411246e-02},
  { 8.331107e-01,  5.479664e-01, -7.522963e-02,  5.093710e-01,  9.583002e-01,  5.442042e-02},
  { 9.718336e-01,  2.307544e-01,  4.787306e-02,  3.810610e-01,  9.781195e-01, -7.554192e-03},
  { 1.877038e-02,  9.766016e-01, -2.142357e-01, -1.466454e-02,  9.822925e-01, -7.822192e-02},
  { 7.030814e-01, -2.929350e-01,  6.479704e-01,  4.301335e-01,  9.682160e-01, -1.294745e-01},
  {-6.687464e-01,  5.509108e-01, -4.992751e-01, -1.696860e-01,  9.744209e-01, -1.336375e-01},
  {-3.152477e-01,  6.325824e-01, -7.074308e-01,  2.381210e-01,  9.542012e-01, -2.093816e-01},
  {-8.320217e-01,  3.137630e-01, -4.574851e-01,  3.329706e-01,  9.793833e-01, -2.316508e-01},
  { 9.514039e-01, -7.312765e-02,  2.991369e-01,  4.733073e-01,  9.885383e-01, -2.417261e-01},
  {-6.718425e-01, -3.842875e-02, -7.396964e-01, -7.597558e-02,  9.765002e-01, -2.787106e-01},
  {-3.004311e-02,  3.723589e-01, -9.276024e-01,  3.873093e-01,  9.777789e-01, -3.263239e-01},
  { 8.257222e-01,  9.201048e-02, -5.565223e-01,  5.545475e-01,  9.796897e-01, -3.547699e-01},
  { 7.192728e-01,  5.039660e-02,  6.928974e-01,  4.562110e-01,  9.990516e-01,  4.567305e-01},
  {-5.333130e-01, -3.992432e-01,  7.457762e-01,  1.629201e-01,  9.953212e-01,  4.443079e-01},
  { 9.410143e-01, -2.085968e-01,  2.664194e-01,  5.183316e-01,  1.001925e+00,  3.928133e-01},
  {-7.424484e-01,  2.255973e-01,  6.307743e-01,  1.314934e-01,  9.916637e-01,  3.973000e-01},
  {-3.672977e-01,  2.146271e-01,  9.050015e-01,  1.009507e-01,  9.965441e-01,  3.740343e-01},
  { 7.452444e-01, -4.697098e-01, -4.732690e-01,  5.050718e-01,  9.990432e-01,  3.211689e-01},
  {-7.624323e-01,  2.359207e-01,  6.025267e-01,  3.205096e-01,  9.999707e-01,  3.190093e-01},
  { 2.149775e-01, -3.032669e-01,  9.283394e-01,  2.345456e-01,  9.858137e-01,  2.786148e-01},
  {-8.734944e-01,  1.383926e-01, -4.667494e-01,  7.401439e-02,  1.005904e+00,  2.657827e-01},
  { 9.530031e-01,  2.365948e-01, -1.892301e-01,  3.437873e-01,  1.000675e+00,  1.191261e-01},
  { 9.606530e-01,  6.269098e-02,  2.705840e-01,  3.430967e-01,  1.001947e+00,  9.578933e-02},
  {-7.552592e-02,  9.412131e-01,  3.292626e-01,  4.588012e-01,  9.635231e-01,  5.819272e-02},
  {-3.006271e-01,  8.891854e-01, -3.449238e-01,  6.482036e-02,  1.007367e+00,  9.407965e-04},
  {-6.819270e-01,  7.119418e-01,  1.676736e-01,  6.871490e-02,  1.007687e+00, -1.827770e-02},
  { 9.740586e-01,  2.160332e-01,  6.737656e-02,  3.778091e-01,  9.907773e-01, -1.514708e-02},
  {-6.846561e-01,  6.732902e-01,  2.791531e-01,  5.056563e-02,  1.010383e+00, -6.686719e-02},
  {-3.449585e-01,  1.506970e-01, -9.264416e-01,  1.997895e-01,  1.004483e+00, -1.342588e-01},
  { 9.605280e-01,  2.484752e-01,  1.250853e-01,  5.052053e-01,  9.998745e-01, -1.720025e-01},
  { 9.906670e-01,  9.672169e-02,  9.604070e-02,  5.125841e-01,  9.892198e-01, -1.819438e-01},
  { 7.777524e-01,  4.449115e-01, -4.440213e-01,  4.765362e-01,  9.916002e-01, -2.054367e-01},
  {-6.398476e-01,  7.683970e-01,  1.269304e-02, -7.895889e-02,  9.853770e-01, -2.607977e-01},
  {-8.678115e-01,  1.937397e-01, -4.575676e-01, -8.232915e-02,  9.795949e-01, -2.703664e-01},
  {-7.553622e-01,  4.104443e-01, -5.108457e-01,  3.609796e-01,  1.004794e+00, -2.841148e-01},
  {-6.868948e-01,  3.276386e-01, -6.487131e-01,  3.741993e-01,  9.878429e-01, -3.181028e-01},
  { 6.775534e-01, -3.196021e-01,  6.624016e-01,  3.901904e-01,  1.012287e+00,  5.310432e-01},
  { 4.197960e-02, -2.693590e-01,  9.621245e-01,  1.722459e-01,  1.008783e+00,  4.568447e-01},
  { 8.597226e-01, -2.095950e-01,  4.657757e-01,  5.116093e-01,  1.023695e+00,  4.089831e-01},
  {-3.871107e-02,  5.575911e-01,  8.292127e-01,  5.080714e-02,  1.003855e+00,  3.669940e-01},
  {-2.939673e-01, -2.684827e-01,  9.173332e-01,  2.684269e-02,  1.002740e+00,  3.679891e-01},
  { 9.472654e-01, -3.101904e-01, -8.043735e-02,  5.244268e-01,  1.023052e+00,  3.361502e-01},
  {-3.983040e-01,  7.958566e-01,  4.560331e-01,  1.150574e-01,  1.024700e+00,  3.331013e-01},
  {-6.216459e-01,  1.291137e-01,  7.725839e-01,  3.184549e-01,  1.025860e+00,  3.099776e-01},
  {-3.466089e-01, -1.334359e-01,  9.284703e-01,  2.894671e-01,  1.008748e+00,  2.929195e-01},
  { 4.185681e-01, -4.979982e-01,  7.594725e-01,  2.222938e-01,  1.009680e+00,  2.961936e-01},
  {-7.944854e-01, -5.796596e-01,  1.810738e-01,  8.927777e-02,  1.012127e+00,  2.266753e-01},
  {-8.592661e-01, -4.865615e-01,  1.578593e-01,  9.222093e-02,  1.009488e+00,  1.785982e-01},
  {-3.468985e-01,  8.781705e-01, -3.293601e-01,  7.578083e-02,  1.022530e+00,  2.583016e-02},
  {-6.391761e-01,  4.748232e-01, -6.049766e-01, -2.295102e-02,  1.016621e+00,  9.763381e-03},
  {-3.987569e-01,  9.027029e-01, -1.616179e-01, -2.370078e-02,  1.005362e+00, -1.004549e-02},
  {-4.208184e-01,  8.732311e-01,  2.457221e-01, -3.191075e-02,  1.000680e+00, -2.298214e-02},
  {-6.382595e-02,  9.958914e-01, -6.423885e-02, -6.007732e-02,  9.980136e-01, -6.731905e-02},
  { 6.253890e-01, -5.433472e-01,  5.600556e-01,  4.503158e-01,  1.008432e+00, -1.197364e-01},
  {-3.560345e-01,  7.315236e-01,  5.814746e-01, -1.319203e-01,  9.939518e-01, -1.167257e-01},
  {-2.275209e-01,  9.719657e-01,  5.930216e-02, -1.252980e-01,  9.966397e-01, -1.105912e-01},
  { 7.977190e-02,  5.930259e-01, -8.012220e-01, -1.670456e-01,  9.951398e-01, -1.253361e-01},
  {-4.542926e-01,  3.168466e-01, -8.326022e-01,  2.973131e-01,  1.017230e+00, -1.790096e-01},
  { 4.426568e-01,  2.476070e-01, -8.618270e-01,  1.101294e-01,  1.020898e+00, -1.658686e-01},
  { 3.314164e-01, -7.597791e-02, -9.404203e-01,  8.330604e-02,  1.008213e+00, -1.801000e-01},
  {-1.126738e-01,  5.756643e-01, -8.098860e-01, -4.729179e-02,  1.004057e+00, -2.854875e-01},
  { 7.934930e-01,  1.871315e-01, -5.790946e-01,  5.655545e-01,  1.003212e+00, -3.446259e-01},
  { 2.816213e-01,  5.994004e-01,  7.492720e-01,  1.694407e-01,  1.014449e+00,  4.536259e-01},
  { 5.371931e-01,  1.822971e-01,  8.235237e-01,  1.772544e-01,  1.034161e+00,  4.082111e-01},
  {-6.522201e-01,  6.827297e-01,  3.293767e-01,  1.312229e-01,  1.041078e+00,  3.270541e-01},
  {-6.497457e-01,  5.452203e-01,  5.296841e-01,  7.065867e-02,  1.037540e+00,  3.020117e-01},
  {-5.121151e-01,  4.123892e-01,  7.534410e-01,  3.313158e-01,  1.040719e+00,  3.137458e-01},
  {-4.563684e-01,  7.245429e-01,  5.164934e-01,  1.232383e-01,  1.041629e+00,  3.114570e-01},
  {-2.051985e-01,  7.744730e-01,  5.984022e-01,  1.033661e-01,  1.032264e+00,  3.169605e-01},
  {-9.762082e-01,  2.164741e-01,  1.251615e-02,  6.740653e-02,  1.038841e+00,  2.885270e-01},
  { 7.998430e-01, -4.846883e-01, -3.540176e-01,  5.234889e-01,  1.039787e+00,  2.911490e-01},
  { 7.588242e-01, -1.618115e-01, -6.308748e-01,  3.642339e-01,  1.037300e+00,  1.596899e-01},
  {-7.199313e-01, -5.229639e-01,  4.562978e-01,  7.107916e-02,  1.024015e+00,  1.485108e-01},
  { 9.414475e-01, -3.304852e-01,  6.675406e-02,  3.435305e-01,  1.024970e+00,  1.000346e-01},
  {-8.006516e-01,  5.784395e-01,  1.560921e-01,  1.058166e-01,  1.043997e+00,  2.910082e-02},
  {-6.556426e-01,  1.011873e-01, -7.482606e-01, -4.710927e-02,  1.040125e+00,  3.459198e-02},
  {-4.970724e-01,  4.082067e-01, -7.656933e-01, -3.960231e-02,  1.029395e+00,  2.486791e-02},
  {-4.970724e-01,  4.082067e-01, -7.656933e-01, -4.336134e-02,  1.034183e+00,  2.855721e-02},
  { 9.234461e-01, -2.502394e-01,  2.909079e-01,  3.807018e-01,  1.024730e+00, -2.222806e-02},
  {-8.154919e-02,  9.956248e-01,  4.561854e-02, -3.513366e-02,  1.001479e+00, -3.590737e-02},
  {-8.659371e-01, -1.396467e-01,  4.802622e-01,  5.012136e-02,  1.036979e+00, -7.754602e-02},
  { 8.015362e-01, -2.719933e-01,  5.325029e-01,  5.614606e-01,  1.034636e+00, -3.046245e-01},
  {-9.269343e-02,  4.404613e-01, -8.929736e-01,  3.972826e-01,  1.022027e+00, -3.028130e-01},
  {-1.836194e-01,  7.196112e-01,  6.696594e-01,  3.308249e-01,  1.034142e+00,  5.865409e-01},
  { 2.135085e-01,  3.360875e-01,  9.173109e-01,  3.498285e-01,  1.043848e+00,  5.750991e-01},
  { 6.767167e-01, -6.471573e-01,  3.510585e-01,  4.534063e-01,  1.042016e+00,  4.787610e-01},
  { 9.453509e-01, -1.348753e-01,  2.968505e-01,  5.280150e-01,  1.049353e+00,  3.922385e-01},
  { 9.987409e-01,  4.862673e-02, -1.232891e-02,  5.278686e-01,  1.056220e+00,  3.635048e-01},
  {-6.442993e-01,  3.987452e-01,  6.525954e-01,  3.615386e-01,  1.055641e+00,  3.346890e-01},
  {-2.089198e-01, -1.155140e-02,  9.778645e-01,  3.247038e-01,  1.064137e+00,  3.095058e-01},
  { 1.383113e-01, -3.022534e-01,  9.431399e-01,  2.903823e-01,  1.055003e+00,  3.077734e-01},
  {-3.560972e-01,  7.710639e-01,  5.278782e-01,  1.294789e-01,  1.059803e+00,  2.836531e-01},
  {-3.560972e-01,  7.710639e-01,  5.278782e-01, -5.995552e-02,  1.057374e+00,  5.172404e-02},
  {-7.716117e-01,  3.821037e-02, -6.349452e-01, -5.486626e-02,  1.047287e+00,  3.967211e-02},
  {-7.716117e-01,  3.821037e-02, -6.349452e-01, -5.753279e-02,  1.050767e+00,  4.314758e-02},
  {-8.792838e-01,  2.899990e-01,  3.778368e-01,  1.013730e-01,  1.061674e+00,  4.672939e-03},
  {-7.810551e-01, -6.366890e-02,  6.212078e-01,  7.371715e-02,  1.047444e+00, -3.531278e-02},
  { 9.898130e-01, -2.934515e-02, -1.393162e-01,  4.993396e-01,  1.054996e+00, -1.193378e-01},
  {-6.281784e-01,  2.419078e-01, -7.395083e-01,  3.087900e-01,  1.059462e+00, -1.793638e-01},
  { 4.342862e-01,  4.604554e-01, -7.741941e-01,  3.428448e-02,  1.050941e+00, -1.866090e-01},
  { 6.567422e-01,  4.608225e-01, -5.969358e-01, -2.262544e-02,  1.037958e+00, -2.537391e-01},
  {-5.737823e-01,  3.555543e-01, -7.378042e-01,  3.849983e-01,  1.047642e+00, -2.833234e-01},
  {-4.401804e-01, -6.160904e-02,  8.957933e-01,  1.702123e-01,  1.066134e+00,  4.089714e-01},
  {-4.400788e-01, -4.286372e-01,  7.890506e-01,  1.642481e-01,  1.075913e+00,  4.109403e-01},
  { 6.809858e-01,  2.655142e-04,  7.322966e-01,  1.960355e-01,  1.071211e+00,  3.874849e-01},
  {-8.245160e-01,  5.326876e-01,  1.908333e-01,  1.527878e-01,  1.067260e+00,  3.538372e-01},
  {-2.672548e-01,  6.533319e-01,  7.083308e-01,  7.415213e-02,  1.055721e+00,  2.982989e-01},
  {-1.569244e-01,  4.798033e-02,  9.864445e-01,  3.310962e-01,  1.081021e+00,  3.095345e-01},
  { 3.108800e-01, -1.557136e-01,  9.376070e-01,  2.920325e-01,  1.078287e+00,  3.158225e-01},
  {-9.181605e-01,  1.591466e-01,  3.628410e-01,  5.825523e-02,  1.073451e+00,  2.564522e-01},
  {-2.591123e-01,  9.474978e-01, -1.873728e-01,  2.160438e-01,  1.075645e+00,  2.546367e-01},
  { 5.409646e-01, -4.965639e-01, -6.788089e-01,  5.072555e-01,  1.068737e+00,  2.403664e-01},
  { 4.427553e-01,  8.916315e-01,  9.466319e-02,  1.882033e-01,  1.079229e+00,  2.359496e-01},
  {-4.512336e-01,  8.520970e-01, -2.651772e-01,  2.478859e-01,  1.078406e+00,  2.179037e-01},
  {-4.340464e-01,  8.804747e-01,  1.907038e-01,  2.556509e-01,  1.075950e+00,  1.649315e-01},
  { 3.564811e-01,  9.149511e-01,  1.891714e-01,  2.222149e-01,  1.084576e+00,  1.332148e-01},
  {-7.203143e-01, -6.337984e-01,  2.818635e-01, -6.795107e-02,  1.067747e+00,  6.791356e-02},
  {-7.793418e-01, -6.203430e-01,  8.832362e-02, -6.697005e-02,  1.065347e+00,  5.971555e-02},
  {-5.801300e-02,  2.444486e-01, -9.679254e-01,  1.559663e-01,  1.081256e+00, -1.143715e-01},
  {-2.214847e-01,  3.532690e-01, -9.089254e-01,  4.793272e-01,  1.081435e+00, -2.804268e-01},
  { 9.994338e-01,  2.842693e-02, -1.800198e-02,  5.667052e-01,  1.060670e+00, -3.066504e-01},
  { 4.871665e-01, -5.397192e-01,  6.865653e-01,  4.733195e-01,  1.084561e+00,  5.531512e-01},
  {-4.264205e-01,  8.854763e-01,  1.846551e-01,  3.832533e-01,  1.075202e+00,  5.500906e-01},
  { 8.324833e-01, -5.399076e-01,  1.243842e-01,  4.977427e-01,  1.089670e+00,  5.326142e-01},
  {-4.932839e-01,  8.603214e-01,  1.285226e-01,  4.063759e-01,  1.084556e+00,  5.257874e-01},
  {-8.096464e-01,  4.849949e-01,  3.305337e-01,  4.122021e-01,  1.092637e+00,  4.469193e-01},
  {-8.096464e-01,  4.849949e-01,  3.305337e-01,  1.717050e-01,  1.080431e+00,  4.234320e-01},
  {-8.096464e-01,  4.849949e-01,  3.305337e-01,  1.697199e-01,  1.081547e+00,  4.196423e-01},
  { 9.550521e-01,  2.236022e-01,  1.946217e-01,  5.259278e-01,  1.082906e+00,  4.055434e-01},
  {-7.740471e-01,  5.114878e-01,  3.731372e-01,  1.582371e-01,  1.082354e+00,  3.914134e-01},
  { 3.504227e-01, -3.680351e-01,  8.612515e-01,  2.301956e-01,  1.082630e+00,  3.649635e-01},
  { 9.298686e-01,  3.159308e-01, -1.884997e-01,  5.268424e-01,  1.073503e+00,  3.757535e-01},
  {-8.247845e-01,  1.760982e-01,  5.373268e-01,  3.738737e-01,  1.091685e+00,  3.323657e-01},
  {-4.465552e-01,  8.964016e-02,  8.902545e-01,  3.515363e-01,  1.097259e+00,  3.115910e-01},
  {-5.679937e-02,  9.576788e-01,  2.821792e-01,  1.664543e-01,  1.073072e+00,  2.785836e-01},
  { 9.872963e-01, -1.327059e-01, -8.737946e-02,  5.292792e-01,  1.097497e+00,  2.421348e-01},
  {-8.431084e-01,  5.373694e-01, -2.006070e-02,  2.722868e-01,  1.090079e+00,  1.928975e-01},
  { 7.466261e-01, -4.606327e-01, -4.799655e-01,  3.735108e-01,  1.078419e+00,  1.520017e-01},
  {-1.687073e-01,  8.873065e-01, -4.292145e-01,  1.149365e-01,  1.092782e+00,  1.351928e-01},
  { 1.161388e-01,  8.209913e-01, -5.590037e-01,  1.008850e-01,  1.102710e+00,  1.489805e-01},
  {-3.717816e-01,  8.947955e-01, -2.472233e-01,  1.263026e-01,  1.089833e+00,  1.078146e-01},
  {-9.423470e-01,  2.326828e-01,  2.405011e-01, -4.470019e-02,  1.090511e+00,  1.200593e-01},
  {-7.781208e-02,  8.611496e-01, -5.023612e-01, -3.265783e-02,  1.087086e+00,  8.677728e-02},
  {-9.460062e-01,  3.523280e-02,  3.222277e-01,  1.250891e-01,  1.086086e+00,  5.410084e-02},
  {-6.784623e-01, -3.231778e-01,  6.597310e-01,  7.240367e-02,  1.084826e+00, -2.580474e-02},
  { 6.343453e-01, -6.471096e-01,  4.229128e-01,  5.372724e-01,  1.096668e+00, -8.274026e-02},
  { 6.579255e-01,  1.347974e-01, -7.409207e-01,  5.316582e-01,  1.089043e+00, -1.025049e-01},
  { 5.971681e-01,  3.478045e-01, -7.227879e-01,  5.325977e-01,  1.099073e+00, -1.006569e-01},
  { 7.580414e-01,  2.637087e-01, -5.965158e-01,  4.652186e-01,  1.090486e+00, -1.361369e-01},
  { 8.925756e-01,  3.670910e-01, -2.618262e-01,  4.579225e-01,  1.089005e+00, -1.511455e-01},
  { 9.729213e-01,  1.070012e-01,  2.048783e-01,  4.577367e-01,  1.085485e+00, -1.791742e-01},
  { 9.932669e-01,  1.158127e-01,  2.859121e-03,  5.251222e-01,  1.110074e+00,  4.959972e-01},
  { 1.443875e-01,  9.846253e-01, -9.831224e-02,  5.266817e-01,  1.108841e+00,  4.859437e-01},
  {-1.443875e-01, -9.846253e-01,  9.831224e-02,  5.255837e-01,  1.107686e+00,  4.727596e-01},
  { 2.104009e-01, -4.476250e-01,  8.691165e-01,  2.455569e-01,  1.112795e+00,  3.774447e-01},
  { 5.353151e-01, -4.219317e-01,  7.317181e-01,  2.553068e-01,  1.115159e+00,  3.745367e-01},
  {-2.113654e-01,  7.087553e-01,  6.730458e-01,  2.103214e-01,  1.099406e+00,  3.692137e-01},
  { 7.444728e-01, -3.099793e-01,  5.913316e-01,  2.688247e-01,  1.119942e+00,  3.567096e-01},
  {-5.497417e-01,  2.192879e-01,  8.060378e-01,  2.626639e-02,  1.096036e+00,  2.282169e-01},
  { 6.605946e-01,  2.973676e-02, -7.501535e-01,  5.242746e-01,  1.101008e+00,  2.280211e-01},
  { 3.158126e-01,  2.459408e-01, -9.163927e-01,  4.776184e-01,  1.103739e+00,  2.225764e-01},
  {-8.490842e-01, -1.783259e-01,  4.972483e-01, -2.086685e-02,  1.106579e+00,  1.745012e-01},
  { 2.339876e-02,  7.617793e-01, -6.474138e-01,  7.927797e-02,  1.106803e+00,  1.535728e-01},
  {-5.687856e-01,  5.691679e-01, -5.937431e-01,  1.298236e-01,  1.119465e+00,  1.491948e-01},
  {-8.518990e-01,  4.871854e-01,  1.921420e-01, -4.042637e-02,  1.102579e+00,  1.397006e-01},
  { 2.245858e-02,  9.658941e-01, -2.579617e-01, -5.310334e-02,  1.092601e+00,  1.056472e-01},
  { 7.282321e-01, -6.671116e-01,  1.569720e-01,  3.996922e-01,  1.097200e+00,  5.810931e-02},
  { 7.416503e-01,  6.371684e-01,  2.096931e-01,  2.099336e-01,  1.112029e+00,  7.090245e-02},
  {-2.177491e-01,  7.266234e-01,  6.516163e-01,  2.692414e-01,  1.115229e+00,  4.425722e-02},
  { 2.422308e-01,  8.120385e-01,  5.309592e-01,  2.289573e-01,  1.114081e+00,  4.602750e-02},
  { 8.368129e-01,  3.174337e-01, -4.460718e-01,  4.581046e-01,  1.106415e+00, -1.340000e-01},
  { 9.888742e-01, -6.186764e-02,  1.352785e-01,  4.546323e-01,  1.106351e+00, -1.606257e-01},
  {-4.499790e-01,  1.313775e-01, -8.833227e-01,  3.295357e-01,  1.106835e+00, -1.806089e-01},
  {-9.105904e-01,  4.105382e-01,  4.778575e-02, -2.462003e-02,  1.100996e+00, -1.902611e-01},
  { 6.556107e-01, -2.417990e-01,  7.153376e-01,  4.846996e-01,  1.105716e+00, -2.058256e-01},
  { 2.699205e-01,  4.842444e-01, -8.322561e-01,  5.622161e-01,  1.099286e+00, -2.870712e-01},
  { 5.640218e-01, -1.787975e-01, -8.061705e-01,  5.093832e-01,  1.113358e+00,  5.355045e-01},
  { 6.225381e-01, -2.140711e-01, -7.527416e-01,  4.990745e-01,  1.111699e+00,  5.274509e-01},
  { 6.225381e-01, -2.140711e-01, -7.527416e-01,  5.156624e-01,  1.111908e+00,  5.246860e-01},
  { 5.004304e-01,  7.573246e-01,  4.195579e-01,  5.170688e-01,  1.113157e+00,  5.160216e-01},
  {-1.915946e-01,  9.495774e-01,  2.481820e-01,  4.878119e-01,  1.110452e+00,  5.255839e-01},
  { 2.754900e-01,  9.582784e-01, -7.620937e-02,  5.131526e-01,  1.117936e+00,  4.875517e-01},
  { 2.357962e-01,  9.706932e-01, -4.642215e-02,  4.934250e-01,  1.114571e+00,  4.596224e-01},
  { 1.123436e-01, -2.497568e-01,  9.617695e-01,  2.535639e-01,  1.133104e+00,  3.874724e-01},
  {-6.746933e-01,  5.358301e-01,  5.076169e-01,  2.336819e-01,  1.121395e+00,  3.729839e-01},
  { 8.247582e-01,  4.465552e-01,  3.469327e-01,  4.685837e-01,  1.133557e+00,  3.459493e-01},
  {-8.877909e-01,  8.696266e-02,  4.519566e-01,  3.904298e-01,  1.121889e+00,  3.564996e-01},
  {-7.991976e-01, -3.426284e-02,  6.000910e-01,  3.743941e-01,  1.130033e+00,  3.242830e-01},
  { 9.419516e-01,  2.514994e-01, -2.224303e-01,  5.289083e-01,  1.115483e+00,  2.520760e-01},
  { 7.056391e-01,  2.680625e-01,  6.559087e-01,  1.745950e-01,  1.134721e+00,  2.182727e-01},
  {-3.424698e-01,  3.760734e-01,  8.609781e-01, -6.255194e-03,  1.114636e+00,  2.026281e-01},
  {-8.565301e-01,  4.872355e-01,  1.701697e-01,  8.739077e-02,  1.135534e+00,  2.172433e-01},
  {-5.212513e-01,  6.424114e-01, -5.617869e-01,  1.196477e-01,  1.132526e+00,  1.706596e-01},
  {-7.680236e-02,  9.957408e-01,  5.100712e-02,  5.147098e-02,  1.125543e+00,  1.709065e-01},
  { 6.755323e-01, -7.369265e-01,  2.440092e-02,  4.107434e-01,  1.124163e+00,  1.428212e-01},
  {-3.986534e-01,  9.113367e-01, -1.026696e-01, -2.239796e-02,  1.115236e+00,  1.440392e-01},
  {-9.765660e-01, -3.311774e-04,  2.152177e-01,  1.378833e-01,  1.134103e+00,  1.122293e-01},
  {-7.961244e-01, -2.843947e-01,  5.341401e-01,  1.051079e-01,  1.123886e+00,  3.424355e-02},
  {-7.505847e-01, -3.682707e-01,  5.486339e-01,  2.085816e-02,  1.123510e+00, -4.009676e-02},
  { 9.916918e-01,  7.068982e-02, -1.074727e-01,  5.434333e-01,  1.121245e+00, -6.765442e-02},
  {-9.601810e-01,  2.213389e-01, -1.704743e-01,  6.953073e-03,  1.127187e+00, -8.760082e-02},
  {-4.474723e-01,  8.017899e-02, -8.906962e-01,  1.873903e-01,  1.127186e+00, -1.049227e-01},
  {-9.209622e-01, -2.296591e-01,  3.147783e-01,  1.430194e-03,  1.121359e+00, -1.029327e-01},
  { 7.467141e-01,  2.663847e-01, -6.094730e-01,  4.617581e-01,  1.122832e+00, -1.165983e-01},
  {-8.087034e-01, -2.248227e-01,  5.435565e-01, -1.177448e-02,  1.123029e+00, -1.340433e-01},
  { 5.371888e-01, -1.844777e-01,  8.230408e-01,  5.464720e-01,  1.133786e+00, -2.305206e-01},
  { 1.624889e-01,  4.470208e-01, -8.796418e-01,  5.536398e-01,  1.120298e+00, -2.761356e-01},
  {-3.266264e-01, -2.050156e-01,  9.226504e-01,  3.516327e-01,  1.147421e+00,  3.097365e-01},
  { 1.355891e-01,  7.965364e-01,  5.891905e-01,  9.996641e-03,  1.129872e+00,  1.956186e-01},
  {-5.261870e-01,  8.035545e-01,  2.782578e-01, -2.054367e-03,  1.128983e+00,  1.925697e-01},
  {-3.572866e-02,  9.830370e-01, -1.798936e-01,  2.389163e-02,  1.130304e+00,  1.783494e-01},
  {-8.206497e-01,  5.241522e-01, -2.275930e-01,  1.504231e-01,  1.155544e+00,  1.538857e-01},
  { 5.424441e-01, -8.253118e-01, -1.568910e-01,  4.824729e-01,  1.143413e+00,  4.238087e-02},
  {-5.701636e-01,  6.350576e-01,  5.211672e-01,  3.193936e-01,  1.154165e+00,  4.696518e-02},
  {-3.359457e-01,  6.703308e-01,  6.616624e-01,  2.900745e-01,  1.155887e+00,  2.645255e-02},
  {-1.721009e-01,  5.942956e-01,  7.856170e-01,  2.658722e-01,  1.154299e+00,  1.879581e-02},
  { 3.368328e-01,  4.742057e-01,  8.134326e-01,  2.190227e-01,  1.148797e+00,  2.384256e-02},
  {-8.249899e-01, -3.293121e-01,  4.592879e-01,  4.356261e-03,  1.153126e+00, -3.422713e-02},
  { 3.684747e-01,  6.574529e-01, -6.572534e-01,  5.333234e-01,  1.133751e+00, -7.448493e-02},
  { 9.911177e-01, -1.327130e-01,  8.532803e-03,  4.553164e-01,  1.137476e+00, -1.425341e-01},
  {-7.825526e-01, -1.818681e-01,  5.954288e-01, -1.943001e-02,  1.127074e+00, -1.414365e-01},
  {-8.393015e-01, -3.875809e-01,  3.812534e-01, -2.433528e-02,  1.125911e+00, -1.510491e-01},
  { 9.136204e-01,  2.575632e-01, -3.145775e-01,  5.660571e-01,  1.151626e+00, -2.431333e-01},
  {-8.335114e-01,  3.799237e-02,  5.511945e-01,  4.144550e-01,  1.165185e+00,  4.240294e-01},
  {-5.316492e-01,  4.454305e-01,  7.203754e-01,  2.501551e-01,  1.156572e+00,  3.866758e-01},
  {-6.722471e-01,  7.319735e-01,  1.108990e-01,  2.464041e-01,  1.158743e+00,  3.637605e-01},
  {-9.422962e-01,  2.471426e-01, -2.258282e-01,  2.965448e-01,  1.161968e+00,  2.369725e-01},
  {-8.668299e-01,  3.972164e-01, -3.013718e-01,  9.961687e-02,  1.158214e+00,  2.067589e-01},
  { 7.984971e-01, -5.647912e-01,  2.083587e-01,  5.040786e-01,  1.170593e+00,  9.892514e-02},
  { 9.753813e-01, -1.827830e-01,  1.233757e-01,  5.128279e-01,  1.177068e+00,  7.355317e-02},
  { 8.222967e-01, -5.654116e-01, -6.432553e-02,  5.027356e-01,  1.161619e+00,  3.873694e-02},
  { 8.110880e-01, -5.713518e-01, -1.252729e-01,  5.078552e-01,  1.173528e+00,  2.549040e-02},
  {-6.993940e-01,  2.347894e-03,  7.147325e-01,  6.106831e-02,  1.155988e+00,  1.241950e-02},
  { 9.059450e-01, -3.350872e-01,  2.588053e-01,  5.189333e-01,  1.168802e+00, -3.854846e-02},
  {-6.897249e-01, -1.182258e-01, -7.143545e-01,  1.971710e-01,  1.164381e+00, -1.121982e-01},
  { 5.922592e-01,  4.029272e-01,  6.977670e-01,  2.615748e-01,  1.160967e+00,  3.834967e-01},
  {-6.138493e-01,  2.317538e-01,  7.546385e-01,  1.113701e-01,  1.169270e+00,  2.394098e-01},
  {-3.961508e-01, -1.688019e-02,  9.180303e-01,  1.139028e-01,  1.176715e+00,  2.407926e-01},
  { 9.511908e-01, -4.049087e-02,  3.059353e-01,  1.828999e-01,  1.187871e+00,  2.038185e-01},
  {-9.169427e-01,  3.987485e-01,  1.468417e-02,  3.471696e-01,  1.181414e+00,  8.487155e-02},
  {-9.677229e-01, -7.856954e-02,  2.394561e-01,  6.538460e-02,  1.189682e+00,  4.053548e-02},
  {-6.819572e-01,  6.093056e-01,  4.045752e-01,  3.067640e-01,  1.183568e+00,  1.726522e-02},
  {-2.456524e-01,  7.531855e-01,  6.102185e-01,  2.862993e-01,  1.180205e+00,  9.747234e-03},
  {-9.243981e-01,  1.754313e-01,  3.386916e-01,  2.554732e-03,  1.170791e+00, -3.235495e-02},
  {-3.589815e-01,  8.898336e-01,  2.816528e-01,  1.058174e-01,  1.193932e+00, -2.815599e-02},
  {-7.133335e-01,  3.057161e-01, -6.306291e-01,  5.017480e-03,  1.176279e+00, -4.215635e-02},
  {-3.166763e-01, -4.199301e-02, -9.476037e-01,  1.769282e-01,  1.175122e+00, -1.007873e-01},
  {-6.595635e-01, -3.234800e-02, -7.509524e-01,  2.225095e-01,  1.187193e+00, -1.495855e-01},
  {-1.457523e-01,  2.354586e-01, -9.608931e-01,  4.361503e-01,  1.181175e+00, -2.715101e-01},
  { 4.004052e-02,  9.115651e-01,  4.092016e-01,  2.754849e-01,  1.183397e+00,  3.269527e-01},
  {-7.744730e-01,  6.007739e-01, -1.981471e-01,  2.680237e-01,  1.182041e+00,  3.197015e-01},
  { 9.843427e-01,  1.180418e-01,  1.309026e-01,  5.224301e-01,  1.202354e+00,  3.088200e-01},
  {-1.286535e-01,  1.887130e-01,  9.735685e-01,  3.044401e-01,  1.187590e+00,  3.112136e-01},
  {-7.841492e-01,  6.164316e-01,  7.156928e-02,  2.780480e-01,  1.187914e+00,  2.933943e-01},
  { 4.427790e-01,  4.331563e-01,  7.850620e-01,  1.543222e-01,  1.181469e+00,  2.259920e-01},
  {-7.159379e-01,  6.957785e-01,  5.766450e-02,  1.084011e-01,  1.186267e+00,  2.286469e-01},
  {-8.809035e-01,  4.672887e-01, -7.516843e-02,  3.601448e-01,  1.208240e+00,  7.733215e-02},
  {-7.691128e-01,  5.774521e-02,  6.364990e-01,  6.751327e-02,  1.205249e+00,  6.425801e-02},
  { 9.370420e-01, -3.400406e-01,  7.952785e-02,  5.140468e-01,  1.199919e+00,  4.412124e-02},
  { 6.619346e-01,  6.295822e-01,  4.067787e-01,  1.526214e-01,  1.205586e+00,  4.847296e-02},
  { 2.960202e-01,  6.440924e-01,  7.053489e-01,  2.651477e-01,  1.191694e+00, -9.165229e-04},
  { 9.154936e-01, -3.927708e-01,  8.719170e-02,  5.191931e-01,  1.204182e+00,  1.187334e-02},
  {-3.738058e-01,  8.771363e-01, -3.014983e-01,  1.479729e-01,  1.206040e+00, -2.324928e-02},
  {-3.904795e-01,  5.772652e-01,  7.171406e-01,  1.312066e-02,  1.191888e+00, -3.301243e-02},
  {-6.638961e-01,  5.316064e-01,  5.259626e-01,  1.336714e-02,  1.199597e+00, -3.978471e-02},
  { 8.272617e-01, -1.583881e-01, -5.390280e-01,  5.239518e-01,  1.203270e+00, -3.941700e-02},
  {-5.723995e-01,  8.162321e-01,  7.825593e-02,  3.533317e-01,  1.209205e+00, -4.301033e-02},
  { 9.047843e-01,  2.476521e-03, -4.258628e-01,  5.193882e-01,  1.190390e+00, -4.783048e-02},
  { 1.231334e-01,  9.617912e-01,  2.445318e-01,  3.111136e-01,  1.200053e+00, -6.697717e-02},
  {-2.781592e-01,  8.765342e-01,  3.928297e-01,  3.268255e-01,  1.209633e+00, -1.022628e-01},
  { 2.735625e-01,  8.795687e-01,  3.892588e-01,  2.902719e-01,  1.210311e+00, -1.045516e-01},
  { 7.624136e-01, -4.481903e-01,  4.667451e-01,  4.791769e-01,  1.204837e+00, -1.399791e-01},
  { 6.215556e-01,  8.337124e-02,  7.789210e-01,  4.348283e-01,  1.181760e+00,  4.474384e-01},
  {-7.296010e-01,  5.052045e-01,  4.609238e-01,  4.240213e-01,  1.192888e+00,  4.510375e-01},
  { 6.491593e-01,  9.356537e-02,  7.548760e-01,  5.185490e-01,  1.208753e+00,  3.301983e-01},
  {-9.420159e-01, -2.153571e-01,  2.573467e-01,  1.106018e-01,  1.189384e+00,  2.393114e-01},
  { 5.974606e-01,  6.512442e-01,  4.678907e-01,  1.828876e-01,  1.201206e+00,  2.045557e-01},
  {-9.095644e-01,  1.137524e-01, -3.996910e-01,  3.159156e-01,  1.222520e+00,  1.760696e-01},
  { 5.497558e-01,  7.568600e-01, -3.534565e-01,  1.734396e-01,  1.194859e+00,  1.709507e-01},
  { 9.033358e-01, -4.229307e-01,  7.151397e-02,  5.291480e-01,  1.219145e+00,  1.269850e-01},
  {-3.880558e-01,  7.878469e-01,  4.782363e-01,  1.795467e-01,  1.223326e+00, -3.245410e-02},
  {-2.496329e-01,  6.029162e-01,  7.577436e-01,  3.136881e-02,  1.214966e+00, -4.182763e-02},
  { 8.996707e-01, -7.774444e-02, -4.295911e-01,  4.904071e-01,  1.222525e+00, -6.615912e-02},
  { 9.247072e-01, -2.417707e-01, -2.940467e-01,  4.737465e-01,  1.213279e+00, -9.473433e-02},
  {-1.326860e-01,  3.855357e-01, -9.131027e-01,  8.537870e-02,  1.218270e+00, -9.188604e-02},
  { 6.552991e-03,  5.277091e-01,  8.493999e-01,  3.143007e-01,  1.222248e+00, -1.229387e-01},
  { 6.254446e-01,  6.876934e-01,  3.686418e-01,  4.172562e-01,  1.244454e+00,  3.457665e-01},
  { 2.874385e-01,  9.447858e-01,  1.573494e-01,  4.364335e-01,  1.232779e+00,  3.177495e-01},
  { 1.347703e-01,  9.432237e-01,  3.035885e-01,  4.936479e-01,  1.236844e+00,  2.983471e-01},
  { 3.310898e-01,  9.238965e-01,  1.918198e-01,  4.427575e-01,  1.233217e+00,  3.050369e-01},
  {-2.876216e-01,  9.551744e-01, -7.011232e-02,  4.532721e-01,  1.243150e+00,  1.944306e-01},
  { 9.764727e-03,  9.700511e-01,  2.427044e-01,  3.486921e-01,  1.238855e+00,  1.950134e-01},
  {-6.464207e-01,  7.605497e-01,  6.086445e-02,  3.166924e-01,  1.239426e+00,  1.880312e-01},
  { 5.947494e-02,  9.739012e-01,  2.190415e-01,  3.645137e-01,  1.241556e+00,  1.800386e-01},
  { 2.342980e-01,  9.122794e-01,  3.359324e-01,  4.157364e-01,  1.242507e+00,  1.402143e-01},
  { 1.206113e-01,  9.196287e-01,  3.738130e-01,  4.439878e-01,  1.240314e+00,  1.265951e-01},
  { 9.552764e-01,  2.544076e-01,  1.507442e-01,  5.418162e-01,  1.242482e+00,  3.081079e-02},
  {-7.882051e-01,  6.146791e-01,  3.003721e-02,  2.046672e-02,  1.215853e+00, -5.139555e-02},
  { 5.135170e-01,  5.398705e-01,  6.669634e-01,  2.551687e-01,  1.238055e+00, -1.112968e-01},
  {-2.355606e-01,  6.105298e-01,  7.561511e-01,  3.511792e-01,  1.240291e+00, -1.209996e-01},
  { 1.279374e-01,  7.372358e-01,  6.634120e-01,  5.139980e-01,  1.223663e+00,  3.241927e-01},
  {-7.305668e-01,  5.305899e-01,  4.298215e-01,  3.149400e-01,  1.245532e+00,  3.008591e-01},
  { 8.863366e-01,  4.129060e-01,  2.095615e-01,  4.975924e-01,  1.245272e+00,  2.845162e-01},
  { 5.954320e-01, -5.270317e-02,  8.016751e-01,  5.048513e-01,  1.257395e+00,  2.732191e-01},
  { 7.284557e-02,  9.896790e-01,  1.234056e-01,  4.263484e-01,  1.241988e+00,  2.635237e-01},
  { 7.958031e-01, -5.158579e-01,  3.171563e-01,  5.105930e-01,  1.241202e+00,  2.420754e-01},
  {-4.931726e-01,  7.927110e-01,  3.583156e-01,  4.563333e-01,  1.253296e+00,  2.607812e-01},
  {-5.083466e-01,  8.519626e-01, -1.254728e-01,  4.600038e-01,  1.259651e+00,  2.333944e-01},
  { 9.727511e-01,  3.937877e-02, -2.284835e-01,  5.401853e-01,  1.266670e+00,  2.002225e-01},
  { 4.051770e-01,  8.173444e-01,  4.096091e-01,  1.350387e-01,  1.238046e+00,  9.683407e-02},
  {-8.547091e-01,  5.121036e-01,  8.498362e-02,  3.707303e-01,  1.262306e+00,  4.776392e-02},
  {-3.612735e-02,  9.206784e-01, -3.886466e-01,  1.087551e-01,  1.239230e+00,  3.821082e-02},
  { 2.678622e-01,  9.262817e-01,  2.650508e-01,  2.117774e-01,  1.242817e+00, -1.701894e-02},
  { 8.562482e-01, -3.044742e-01, -4.172942e-01,  5.578058e-01,  1.245166e+00, -2.854329e-02},
  { 7.624756e-01,  7.341398e-02, -6.428385e-01,  4.963589e-01,  1.266088e+00, -4.965095e-02},
  {-5.948904e-01,  8.016565e-01,  5.875441e-02,  5.170019e-02,  1.240428e+00, -6.340560e-02},
  {-5.225118e-01,  8.526208e-01, -4.391942e-03,  3.998238e-01,  1.261721e+00, -8.834470e-02},
  {-4.054535e-01,  6.609856e-01, -6.314313e-01,  4.012479e-01,  1.258810e+00, -1.886278e-01},
  {-5.830660e-01,  3.772382e-01, -7.195314e-01,  4.462088e-01,  1.254475e+00, -2.519664e-01},
  { 8.485037e-01,  4.326570e-01, -3.047120e-01,  4.030606e-01,  1.267381e+00,  3.461011e-01},
  {-5.357618e-01,  2.853523e-01,  7.946908e-01,  3.770560e-01,  1.258292e+00,  3.484198e-01},
  { 7.228177e-01,  6.209365e-01,  3.032698e-01,  5.199082e-01,  1.224475e+00,  3.216159e-01},
  {-4.048418e-01,  8.328987e-01,  3.773364e-01,  3.539626e-01,  1.258477e+00,  3.226926e-01},
  {-4.858219e-01,  8.713847e-01,  6.830588e-02,  3.210876e-01,  1.254555e+00,  2.893046e-01},
  {-4.272919e-01,  7.745448e-01,  4.663711e-01,  4.830793e-01,  1.270363e+00,  2.669075e-01},
  {-5.027283e-02,  9.949947e-01, -8.636113e-02,  3.535537e-01,  1.258878e+00,  2.764180e-01},
  { 9.875010e-01,  1.546896e-01, -3.021455e-02,  5.439227e-01,  1.279245e+00,  2.107479e-01},
  { 9.672816e-01,  2.327423e-01,  1.009820e-01,  5.401403e-01,  1.271779e+00,  1.835048e-01},
  {-9.431267e-01,  3.015097e-01,  1.400137e-01,  3.146757e-01,  1.255690e+00,  1.792320e-01},
  {-3.531707e-01,  9.299702e-01, -1.021074e-01,  3.465905e-01,  1.258376e+00,  1.559988e-01},
  {-2.493620e-01,  9.596696e-01,  1.298184e-01,  3.206397e-01,  1.258044e+00,  1.692883e-01},
  {-8.010266e-02,  6.810774e-01,  7.278167e-01,  1.087060e-01,  1.251486e+00,  9.686192e-02},
  {-6.628056e-01,  7.471909e-01, -4.893527e-02,  9.072682e-02,  1.251458e+00,  8.644610e-02},
  { 4.134342e-01,  8.566231e-01,  3.086568e-01,  5.088222e-01,  1.265614e+00,  2.927360e-02},
  { 6.692383e-01,  3.905528e-01,  6.321301e-01,  4.740587e-01,  1.275133e+00,  3.347331e-02},
  { 7.696352e-02,  8.130500e-01,  5.770844e-01,  1.503963e-01,  1.252002e+00,  2.332062e-02},
  {-8.079149e-01,  5.892588e-01,  6.899968e-03,  4.007920e-01,  1.277292e+00, -1.063323e-03},
  { 8.735152e-01,  4.468129e-01, -1.932080e-01,  5.610839e-01,  1.255195e+00, -2.384681e-02},
  { 8.454884e-01,  4.898438e-01, -2.126086e-01,  5.000989e-01,  1.281122e+00, -4.116029e-02},
  { 7.842689e-01,  4.847286e-01,  3.872475e-01,  2.405618e-01,  1.255471e+00, -5.231610e-02},
  { 6.691539e-01,  7.431229e-01, -1.198789e-03,  7.259303e-02,  1.246827e+00, -7.374600e-02},
  {-5.061881e-02,  4.890020e-01, -8.708127e-01,  6.275901e-02,  1.247646e+00, -8.343530e-02},
  {-4.722188e-01,  7.275101e-01, -4.977334e-01,  4.469806e-01,  1.276540e+00, -1.268668e-01},
  {-1.212740e-01,  9.839357e-01,  1.310083e-01,  4.375910e-01,  1.272401e+00, -1.460719e-01},
  { 9.183201e-01, -5.097343e-02, -3.925427e-01,  5.801998e-01,  1.266093e+00, -2.317455e-01},
  { 2.795759e-01,  3.281035e-02, -9.595628e-01,  4.940487e-01,  1.275451e+00, -2.559955e-01},
  { 4.130262e-01,  7.995713e-01,  4.359990e-01,  3.995003e-01,  1.272818e+00,  3.511530e-01},
  {-2.222534e-01,  9.666711e-01,  1.270844e-01,  3.930534e-01,  1.271829e+00,  3.412874e-01},
  {-3.181303e-01,  3.988431e-01,  8.600683e-01,  5.012443e-01,  1.286690e+00,  2.704909e-01},
  { 6.182510e-01, -2.071837e-01,  7.581824e-01,  5.220852e-01,  1.292055e+00,  2.689863e-01},
  { 8.864313e-02,  8.059403e-01, -5.853227e-01,  5.367154e-01,  1.285593e+00,  2.108666e-01},
  {-1.484651e-01,  9.144738e-01,  3.764248e-01,  3.717000e-01,  1.268649e+00,  1.414872e-01},
  { 9.645141e-01,  2.597452e-01,  4.738208e-02,  5.496244e-01,  1.272733e+00,  1.127442e-01},
  {-1.296414e-01,  8.941675e-01,  4.285530e-01,  3.973551e-01,  1.278257e+00,  1.141401e-01},
  {-4.245853e-01,  6.233469e-01,  6.566324e-01,  4.049206e-01,  1.290882e+00,  9.829342e-02},
  { 3.664502e-01,  8.730597e-01, -3.216849e-01,  5.471894e-01,  1.275285e+00,  8.648785e-02},
  { 6.651528e-01,  3.616573e-01,  6.532807e-01,  4.581659e-01,  1.290079e+00,  3.897148e-02},
  {-8.470039e-01,  5.303789e-01, -3.581338e-02,  3.748729e-01,  1.284456e+00,  5.148825e-02},
  { 2.928504e-01,  8.925079e-01,  3.430282e-01,  2.109135e-01,  1.278675e+00, -7.743721e-02},
  { 7.261017e-02,  9.923865e-01, -9.948287e-02,  6.662676e-02,  1.251735e+00, -7.885835e-02},
  {-1.586102e-01,  7.898731e-01, -5.924048e-01,  2.016383e-01,  1.261883e+00, -1.334149e-01},
  {-3.577257e-01,  8.119285e-01,  4.613072e-01,  2.824979e-01,  1.286131e+00, -1.504581e-01},
  { 7.405849e-01, -3.597789e-01,  5.675325e-01,  5.725170e-01,  1.286530e+00, -1.698261e-01},
  { 6.250616e-01,  7.782640e-01, -6.002674e-02,  5.819747e-01,  1.291428e+00, -1.817751e-01},
  { 6.503466e-01,  5.988891e-01, -4.673127e-01,  5.805796e-01,  1.278043e+00, -2.235252e-01},
  { 4.529896e-01,  6.073583e-01, -6.526227e-01,  5.083414e-01,  1.293206e+00, -2.406219e-01},
  {-7.813990e-01,  4.080822e-01, -4.721064e-01,  4.469239e-01,  1.271687e+00, -2.449897e-01},
  {-3.595491e-01,  3.893950e-01, -8.479953e-01,  4.737342e-01,  1.288997e+00, -2.546432e-01},
  { 2.328250e-01,  7.100003e-01,  6.645991e-01,  5.236756e-01,  1.300046e+00,  2.698404e-01},
  { 9.331419e-01,  3.191498e-01,  1.654975e-01,  5.282307e-01,  1.297647e+00,  2.517690e-01},
  {-2.159231e-01,  9.755902e-01, -4.001253e-02,  5.060582e-01,  1.295905e+00,  2.513470e-01},
  { 2.094470e-01,  9.687620e-01, -1.327857e-01,  5.447017e-01,  1.278878e+00,  1.002701e-01},
  { 1.205718e-01,  2.301041e-01,  9.656678e-01,  4.080321e-01,  1.310131e+00,  8.970936e-02},
  { 9.993655e-01,  2.115228e-02,  2.865777e-02,  4.954252e-01,  1.313064e+00, -8.411997e-02},
  {-2.660877e-02,  7.949483e-01,  6.060933e-01,  1.947135e-01,  1.288587e+00, -8.053803e-02},
  { 3.027672e-01,  9.107273e-01, -2.809052e-01,  2.010971e-01,  1.285887e+00, -9.121985e-02},
  {-5.499486e-01,  6.344833e-01,  5.431274e-01,  1.703756e-01,  1.272922e+00, -8.385732e-02},
  { 6.557637e-01, -1.565122e-01,  7.385647e-01,  5.605257e-01,  1.301889e+00, -1.529401e-01},
  { 2.437514e-01,  2.308775e-01, -9.419559e-01,  3.719476e-01,  1.292074e+00, -1.664542e-01},
  { 2.211024e-01, -1.401300e-01,  9.651307e-01,  4.173582e-01,  1.324167e+00,  8.995934e-02},
  { 9.951708e-01, -5.347570e-02,  8.231226e-02,  5.098494e-01,  1.333106e+00, -7.708346e-03},
  {-8.397847e-01,  4.474907e-01, -3.074310e-01,  4.077784e-01,  1.310997e+00, -4.756582e-02},
  {-4.830527e-01,  8.204728e-01, -3.057522e-01,  1.818311e-01,  1.286210e+00, -8.450291e-02},
  {-8.157378e-02,  5.244970e-01,  8.474955e-01,  3.222572e-01,  1.314545e+00, -1.523507e-01},
  {-6.168592e-01,  7.600048e-01,  2.046403e-01,  2.924347e-01,  1.310753e+00, -1.634539e-01},
  {-1.852858e-01,  9.640589e-01, -1.904192e-01,  4.768211e-01,  1.304508e+00, -2.420181e-01},
  { 3.013397e-01,  8.141422e-01, -4.963535e-01,  4.876588e-01,  1.302548e+00, -2.527002e-01},
  { 8.270914e-01, -3.125209e-01,  4.671729e-01,  4.241656e-01,  1.341595e+00,  8.956553e-02},
  {-5.178682e-01,  4.525564e-01,  7.259512e-01,  4.142739e-01,  1.335892e+00,  9.195532e-02},
  { 3.119540e-01,  6.969553e-01,  6.457073e-01,  4.545230e-01,  1.343529e+00,  3.463581e-02},
  {-4.776630e-01,  8.717527e-01, -1.090191e-01,  4.258727e-01,  1.338580e+00,  5.103133e-02},
  {-5.747957e-01,  8.171157e-01, -4.395240e-02,  4.425350e-01,  1.343326e+00,  2.676217e-02},
  {-6.985164e-01,  5.953524e-01,  3.970270e-01,  4.208651e-01,  1.333553e+00, -3.170994e-02},
  { 5.031282e-01,  5.984361e-01, -6.234872e-01,  4.908781e-01,  1.344864e+00, -8.706315e-02},
  { 5.977670e-01,  7.921587e-01,  1.231232e-01,  4.965493e-01,  1.335613e+00, -1.135333e-01},
  { 2.029772e-01,  3.034023e-01, -9.309927e-01,  3.621059e-01,  1.323090e+00, -1.535366e-01},
  {-2.030542e-01,  5.037553e-01, -8.396426e-01,  3.083691e-01,  1.320396e+00, -1.659857e-01},
  {-5.731655e-01,  7.392404e-01, -3.535606e-01,  4.659200e-01,  1.300736e+00, -2.393260e-01},
  { 8.878148e-01, -3.534570e-01, -2.947086e-01,  4.227763e-01,  1.342757e+00,  8.398680e-02},
  { 6.880267e-01, -3.159556e-01,  6.532927e-01,  4.346418e-01,  1.347635e+00,  8.273751e-02},
  { 7.022744e-01,  4.243463e-01,  5.716125e-01,  5.079447e-01,  1.356164e+00, -5.036190e-03},
  {-4.073294e-01,  4.767465e-01, -7.789708e-01,  4.658721e-01,  1.366881e+00, -7.540946e-02},
  {-3.612117e-01,  4.451047e-01, -8.193949e-01,  5.222006e-01,  1.342007e+00, -1.167447e-01},
  {-4.961798e-01,  4.026194e-01, -7.692225e-01,  5.546193e-01,  1.334085e+00, -1.418030e-01},
  { 1.092998e-01,  9.099768e-01,  3.999948e-01,  4.834948e-01,  1.366084e+00, -5.005411e-03},
  { 8.452791e-01,  5.322861e-01, -4.663374e-02,  5.050429e-01,  1.364148e+00, -1.651266e-02},
  {-5.462205e-01,  8.338445e-01,  7.966530e-02,  4.536677e-01,  1.378264e+00, -5.723789e-02},
  { 8.944272e-01, -4.472136e-01,  0.000000e+00,  4.571767e-01,  1.385003e+00, -6.283463e-02},
  { 8.611788e-02,  9.206867e-01, -3.806834e-01,  4.706725e-01,  1.382260e+00, -6.803595e-02},
  { 6.223390e-03, -6.733628e-01, -7.392860e-01,  2.447126e-01, -1.368984e+00, -4.623058e-01},
  {-7.208155e-01, -5.658430e-01, -4.003083e-01,  2.090971e-01, -1.331526e+00, -4.676701e-01},
  {-8.540131e-01, -2.755626e-01,  4.412787e-01,  1.551611e-01, -1.324145e+00, -4.910716e-01},
  {-2.038699e-01, -7.864982e-02, -9.758336e-01,  2.455043e-01, -1.331376e+00, -4.776125e-01},
  { 8.676586e-01, -4.505036e-01, -2.102740e-01,  5.524440e-02, -1.237011e+00, -6.779348e-01},
  { 3.651616e-01, -8.752105e-01, -3.172752e-01,  5.103468e-02, -1.226512e+00, -6.978073e-01},
  { 8.952950e-01, -4.120664e-01, -1.692575e-01,  3.658124e-02, -1.223300e+00, -7.298670e-01},
  { 2.149471e-01, -9.491519e-01,  2.300186e-01,  2.828396e-02, -1.220321e+00, -7.621496e-01},
  { 7.763040e-01, -2.671653e-01,  5.709420e-01,  3.368136e-01, -1.206856e+00, -1.734398e-01},
  { 4.743461e-01, -8.792857e-01,  4.303918e-02,  2.452316e-01, -1.206070e+00, -6.205044e-01},
  { 1.617674e-01,  9.203562e-02,  9.825277e-01,  2.688811e-01, -1.191722e+00, -1.241150e-02},
  { 3.019034e-01, -8.860388e-01,  3.518375e-01,  3.113245e-01, -1.074141e+00,  1.511360e-01},
  { 3.762777e-01, -7.910517e-01,  4.823405e-01,  3.095740e-01, -1.080210e+00,  1.311041e-01},
  { 9.520096e-01,  2.956540e-02,  3.046368e-01,  3.143108e-01, -1.068457e+00,  1.354617e-01},
  { 3.881028e-02, -9.201527e-01,  3.896314e-01,  3.198077e-01, -1.097130e+00,  1.032176e-01},
  { 1.907797e-01, -8.669335e-01, -4.604665e-01, -1.616418e-01, -1.003595e+00,  1.761454e-01},
  { 6.172987e-01, -7.865528e-01, -1.663927e-02, -1.837966e-01, -1.013965e+00,  1.109467e-01},
  { 5.616629e-01, -7.840077e-01, -2.643233e-01, -1.698821e-01, -9.978486e-01,  1.478129e-01},
  { 7.240933e-02, -9.599975e-01,  2.704841e-01, -1.734472e-01, -9.991137e-01,  1.270222e-01},
  {-3.765897e-01, -4.441826e-01,  8.129466e-01,  1.309408e-01, -1.003694e+00,  4.016043e-01},
  {-3.514369e-01, -9.247617e-01,  1.459729e-01,  9.681771e-02, -9.916533e-01,  3.961039e-01},
  {-1.982553e-01, -5.607200e-01, -8.039203e-01,  7.540555e-02, -9.854484e-01,  3.944175e-01},
  { 2.406925e-01, -7.880154e-01,  5.666559e-01,  2.780105e-01, -1.011370e+00,  3.115985e-01},
  { 5.811111e-01, -7.548636e-01,  3.041229e-01,  2.759840e-01, -1.008437e+00,  3.271309e-01},
  { 9.304340e-01,  3.076651e-01, -1.990846e-01,  2.759400e-01, -9.959790e-01,  3.172426e-01},
  {-1.737885e-01, -2.068508e-01,  9.628137e-01,  2.783689e-01, -1.033207e+00,  2.959544e-01},
  {-7.678919e-02, -7.728493e-01,  6.299265e-01,  2.013203e-01, -8.453979e-01,  5.811761e-01},
  {-1.792810e-01, -5.582522e-01,  8.100696e-01,  1.926700e-01, -8.557053e-01,  5.701283e-01},
  {-4.232441e-01, -8.954045e-01,  1.382579e-01,  2.887529e-01, -8.141543e-01,  5.209730e-01},
  {-6.451971e-01,  9.696332e-02,  7.578382e-01, -2.243537e-01, -6.762419e-01, -2.077166e-01},
  {-7.101412e-01,  1.973970e-01,  6.758208e-01, -3.293926e-01, -6.126131e-01,  2.998727e-01},
  {-4.916377e-01, -1.954399e-01,  8.485845e-01,  8.575442e-02, -5.083030e-01,  6.814566e-01},
  { 1.449811e-01,  4.582541e-01,  8.769171e-01,  5.063770e-02, -4.956112e-01,  6.766769e-01},
  { 4.492951e-01, -3.968987e-01,  8.003783e-01,  3.033289e-02, -5.050424e-01,  6.820989e-01},
  { 5.386251e-01, -7.342833e-01,  4.131720e-01,  1.465966e-02, -5.051909e-01,  6.925905e-01},
  { 3.390759e-01,  7.780150e-02,  9.375364e-01,  2.158427e-01, -5.739149e-01, -4.646989e-01},
  { 2.292845e-01,  1.288850e-01,  9.647887e-01,  2.051597e-01, -5.377083e-01, -4.660100e-01},
  {-9.314502e-01,  3.307785e-01, -1.516115e-01, -5.180701e-01, -4.869292e-01, -3.036836e-01},
  {-9.332306e-01,  8.316346e-02, -3.495204e-01, -5.103278e-01, -4.784493e-01, -3.287269e-01},
  {-9.109946e-01,  2.325061e-01,  3.406315e-01, -5.124062e-01, -4.586960e-01, -3.367156e-01},
  { 8.525708e-01, -4.625793e-01,  2.431939e-01,  4.772542e-01, -2.844363e-01, -3.937951e-01},
  {-4.422392e-01,  5.066035e-01, -7.401198e-01, -2.263976e-01, -2.045836e-01, -2.890264e-02},
  { 4.678552e-01,  2.592142e-01, -8.449376e-01, -2.378543e-01, -1.897507e-01, -2.495215e-02},
  { 4.966142e-01,  6.382738e-01, -5.882015e-01, -2.061020e-01, -2.052072e-01, -2.720986e-02},
  {-5.631373e-01,  5.921896e-01, -5.763573e-01, -3.260506e-01, -1.677044e-01, -6.944722e-01},
  { 1.075548e-01, -9.434156e-01, -3.136863e-01, -3.192688e-01, -1.412664e-01, -7.251363e-01},
  {-2.976853e-01, -7.317519e-01, -6.131253e-01, -3.221733e-01, -1.515348e-01, -7.049181e-01},
  {-7.970331e-01,  1.268732e-01, -5.904586e-01, -4.070664e-01, -1.893885e-01,  4.148430e-01},
  {-7.361313e-01,  6.384336e-01, -2.247515e-01, -3.774674e-01, -1.634751e-01,  3.906569e-01},
  {-8.393228e-01,  3.360232e-01,  4.273473e-01, -3.627925e-01, -1.355253e-01,  3.715603e-01},
  { 2.442026e-01,  8.008017e-02,  9.664120e-01, -3.686831e-01, -1.151270e-01,  3.649637e-01},
  { 3.544785e-01, -6.988596e-01,  6.212410e-01,  2.882403e-01, -1.492539e-01, -4.234756e-03},
  {-2.851299e-01,  7.200018e-01,  6.326914e-01,  4.153803e-01, -8.855777e-02,  4.135883e-01},
  { 2.215422e-01, -7.193468e-01,  6.583761e-01,  4.336132e-01,  2.338482e-02,  8.063350e-01},
  { 2.269022e-01,  4.398920e-01, -8.689134e-01,  3.960375e-01,  1.112201e-01, -5.763669e-01},
  {-9.348047e-01,  2.636154e-01, -2.380066e-01, -2.921441e-02,  2.346209e-01, -7.161024e-02},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  2.827446e-01,  2.180128e-01, -6.593949e-01},
  {-3.770216e-02,  9.604470e-01,  2.758989e-01, -1.492909e-02,  3.510504e-01, -4.773085e-01},
  {-4.522887e-02,  1.035869e-01,  9.935915e-01,  4.594564e-01,  4.226800e-01,  7.776092e-01},
  { 8.427809e-01, -1.337657e-01,  5.213703e-01,  4.699445e-01,  4.621072e-01,  7.693002e-01},
  {-9.974998e-01, -1.967048e-02,  6.787561e-02,  4.126605e-02,  4.650374e-01, -1.586542e-01},
  { 6.399654e-01,  7.605543e-01,  1.095509e-01,  2.032737e-01,  5.020416e-01, -7.257628e-01},
  {-5.631545e-01,  6.903154e-01,  4.542266e-01, -2.205262e-01,  5.209804e-01, -4.028366e-01},
  { 4.264787e-01,  4.715036e-01,  7.718810e-01, -1.591235e-01,  5.171360e-01, -4.511088e-01},
  {-3.965931e-01,  7.035882e-01,  5.896420e-01, -1.335150e-01,  5.326842e-01, -4.594164e-01},
  {-3.102329e-01,  6.858003e-01,  6.583565e-01, -1.100975e-01,  5.472539e-01, -4.546076e-01},
  { 2.033571e-01, -7.281967e-01,  6.545040e-01,  1.534181e-01,  7.005291e-01,  5.581372e-01},
  { 5.706351e-02,  1.929418e-02, -9.981841e-01,  3.408626e-01,  8.992773e-01, -3.484921e-01},
  { 9.184020e-01, -2.443484e-01, -3.111778e-01,  5.424479e-01,  8.438338e-01, -4.135286e-01},
  { 5.030662e-01, -5.449883e-01, -6.707548e-01,  1.737903e-01,  1.081714e+00,  4.149558e-01},
  { 6.194986e-01,  5.111448e-01,  5.957789e-01,  4.459862e-01,  1.147171e+00,  4.318807e-01},
  { 4.408507e-02,  8.805321e-01,  4.719319e-01,  4.456260e-01,  1.126317e+00,  4.429967e-01},
  {-9.564207e-03,  9.903303e-01,  1.383999e-01,  1.694765e-01,  1.191556e+00,  1.507386e-01},
  {-4.995089e-01,  4.870783e-01,  7.164116e-01,  1.618321e-01,  1.201939e+00,  1.304099e-01},
  { 4.884675e-01,  7.322920e-01,  4.744977e-01,  1.599438e-01,  1.219178e+00,  1.172083e-01},
  { 1.765781e-01,  9.638796e-01, -1.993898e-01,  4.207471e-01,  1.182853e+00,  4.199581e-01},
  {-1.409053e-01,  8.350230e-01,  5.318668e-01,  4.138328e-01,  1.188827e+00,  3.901563e-01},
  {-1.742588e-01,  4.949137e-01,  8.512897e-01,  4.049568e-01,  1.202314e+00,  3.717107e-01},
  { 4.890056e-01,  8.394125e-01,  2.371927e-01,  4.133904e-01,  1.199868e+00,  3.774704e-01},
  { 6.421731e-02,  1.982566e-01,  9.780443e-01,  3.975388e-01,  1.256390e+00,  3.570522e-01},
  {-6.610885e-01,  4.017192e-01, -6.337062e-01,  1.520720e-01,  1.237948e+00, -9.110395e-02},
  {-2.119766e-01,  9.767674e-01,  3.148510e-02,  4.345775e-01,  1.273299e+00, -1.604148e-01},
  { 2.394688e-01,  9.144888e-01, -3.261363e-01,  3.838454e-01,  1.292030e+00, -1.598271e-01},
  { 1.962684e-01,  9.574670e-01,  2.115079e-01,  1.848674e-01,  1.253365e+00,  9.416123e-03},
  { 3.184187e-01, -1.790949e-01, -9.308784e-01,  3.240103e-01,  1.325403e+00, -1.593984e-01},
  {-8.465656e-01,  5.309119e-01, -3.820236e-02, -3.742947e-02,  2.451462e-01, -4.990261e-02},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.724584e-02,  2.454290e-01, -5.221223e-02},
  {-2.308599e-01, -8.055393e-02, -9.696468e-01,  3.233452e-01, -1.264155e+00, -1.830978e-01},
  { 5.209305e-02,  1.135680e-01,  9.921637e-01, -8.000618e-02, -1.248651e+00, -2.685733e-01},
  {-9.550522e-01,  2.733601e-01, -1.146715e-01,  1.039850e-02, -1.217389e+00, -7.745111e-01},
  { 3.274126e-01,  9.350771e-01,  1.357639e-01,  3.098377e-01, -1.206485e+00, -9.507994e-03},
  {-7.679571e-01,  2.470358e-01, -5.909443e-01, -1.349250e-02, -1.215017e+00, -7.492694e-01},
  {-1.174813e-01, -3.634978e-01, -9.241577e-01,  9.430559e-03, -1.210849e+00, -7.799487e-01},
  {-1.329522e-02, -5.956052e-01, -8.031673e-01,  1.851995e-01, -1.191134e+00,  7.344828e-04},
  {-8.331554e-02, -7.986434e-01, -5.960095e-01,  1.828805e-01, -1.172734e+00, -7.320014e-01},
  { 1.090341e-01, -8.980839e-01,  4.260949e-01,  3.177166e-01, -1.101609e+00,  9.431364e-02},
  { 7.629511e-01, -9.013339e-02, -6.401419e-01,  3.181220e-01, -1.135714e+00, -5.376496e-01},
  {-7.658489e-01, -3.415777e-01, -5.447938e-01, -1.667558e-01, -1.094133e+00,  1.393635e-02},
  { 4.650654e-01, -7.375867e-01, -4.895714e-01,  3.126696e-01, -1.077320e+00,  2.928757e-01},
  { 5.048087e-01,  8.141233e-01,  2.870041e-01, -7.855986e-02, -1.056854e+00, -3.008815e-01},
  {-2.119141e-01, -7.993028e-01, -5.623232e-01, -9.597635e-02, -1.036933e+00, -7.328814e-01},
  {-6.766984e-01, -6.473534e-01, -3.507318e-01, -3.093293e-01, -9.984860e-01, -7.032741e-02},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  2.383586e-01, -1.008000e+00, -1.932242e-01},
  { 7.071068e-01,  7.071068e-01,  0.000000e+00,  2.280283e-01, -1.005051e+00, -1.840029e-01},
  { 7.240354e-02,  9.928427e-01,  9.498002e-02,  2.352232e-01, -9.933761e-01,  4.205586e-01},
  { 6.803864e-01, -2.384493e-01, -6.929764e-01, -3.128158e-01, -9.766437e-01, -8.801512e-02},
  { 3.078539e-01, -5.910728e-01,  7.455595e-01, -1.936910e-01, -9.626002e-01, -2.999550e-01},
  { 7.637578e-01,  3.439138e-01,  5.462577e-01,  3.788656e-01, -9.262695e-01,  3.072820e-01},
  { 5.965444e-01, -7.362968e-01, -3.193772e-01, -4.177653e-01, -9.306448e-01, -3.424900e-01},
  {-3.935594e-01, -7.824991e-01, -4.824997e-01, -2.705747e-01, -9.444126e-01, -7.219871e-01},
  {-5.227145e-01, -8.522742e-01,  1.995675e-02, -2.771989e-01, -9.403024e-01, -7.199591e-01},
  {-6.308634e-01, -1.902053e-01, -7.522188e-01, -5.574276e-02, -9.086484e-01,  4.384212e-01},
  {-5.869430e-01, -8.013494e-01,  1.154858e-01,  3.300598e-01, -8.835007e-01,  3.695006e-01},
  { 7.852809e-01, -2.507469e-01,  5.660918e-01,  3.300598e-01, -8.835007e-01,  3.695006e-01},
  {-8.766013e-01, -3.649316e-01,  3.136800e-01, -2.809657e-01, -9.020717e-01,  2.372825e-01},
  { 5.703006e-01,  4.630447e-02, -8.201299e-01, -3.893970e-01, -8.722580e-01,  1.560764e-02},
  { 4.878863e-01,  4.141625e-02, -8.719241e-01, -4.025076e-01, -8.498582e-01,  1.243016e-02},
  {-9.438934e-01, -9.418152e-02,  3.165361e-01, -2.958217e-01, -8.554262e-01,  1.934921e-01},
  {-5.874638e-02,  4.826802e-01,  8.738242e-01, -1.860305e-01, -8.204433e-01, -2.331374e-01},
  {-8.701559e-01,  2.042318e-01, -4.484619e-01, -2.410295e-01, -8.026991e-01, -2.044984e-01},
  {-9.530892e-01, -2.015847e-01, -2.257978e-01, -2.104321e-01, -8.115756e-01, -5.928466e-01},
  { 8.793310e-03, -9.998914e-01, -1.182712e-02, -2.017300e-01, -7.843551e-01,  3.273461e-01},
  {-1.632288e-02, -4.157280e-01,  9.093425e-01, -2.677985e-01, -7.762506e-01, -4.319754e-01},
  {-6.429467e-01,  3.761890e-01,  6.671592e-01, -4.393587e-01, -7.488002e-01, -5.801523e-01},
  { 9.014663e-01,  4.328460e-01, -1.660819e-03,  4.039760e-01, -7.060192e-01,  6.214597e-01},
  { 3.598017e-01,  9.328905e-01, -1.606885e-02,  4.039073e-01, -7.062979e-01,  6.037441e-01},
  { 9.251398e-01,  3.248586e-01, -1.964263e-01, -4.126712e-01, -7.121616e-01, -6.419753e-02},
  {-6.666667e-01, -6.666667e-01,  3.333333e-01, -3.713215e-01, -7.052317e-01, -3.052369e-01},
  {-2.877278e-01,  4.044184e-01, -8.681351e-01, -3.175414e-01, -7.046477e-01, -3.255114e-01},
  {-3.483612e-01, -8.369993e-01,  4.219914e-01, -4.774435e-01, -7.077817e-01,  6.440424e-02},
  {-4.744618e-01,  2.725333e-01, -8.370255e-01, -4.803746e-01, -7.285702e-01, -2.776222e-01},
  {-1.684304e-01,  3.368608e-01, -9.263671e-01, -2.963185e-01, -6.945751e-01, -3.319170e-01},
  {-4.640293e-01, -5.175580e-01,  7.188953e-01, -4.002253e-01, -7.054781e-01, -4.966349e-01},
  {-3.184333e-01, -1.726964e-01,  9.320817e-01,  2.487254e-01, -6.739987e-01,  7.805319e-01},
  { 3.030776e-01, -3.500897e-01, -8.863302e-01, -3.552967e-02, -6.754332e-01, -3.672681e-01},
  { 3.030776e-01, -3.500897e-01, -8.863302e-01, -3.492245e-01, -6.467029e-01, -4.299225e-01},
  { 3.030776e-01, -3.500897e-01, -8.863302e-01, -3.404025e-01, -6.375347e-01, -4.194844e-01},
  { 5.166681e-01,  7.212526e-01,  4.613555e-01,  9.721687e-02, -5.893686e-01,  7.320774e-01},
  { 1.867386e-01, -1.011180e-01, -9.771918e-01,  3.776537e-01, -5.581352e-01,  3.113233e-01},
  { 4.657514e-01, -3.408816e-01,  8.166244e-01,  3.836014e-01, -5.544330e-01,  3.094765e-01},
  { 9.407653e-01, -6.303278e-02, -3.331480e-01,  3.933044e-01, -5.388160e-01,  3.104615e-01},
  { 8.512013e-01, -4.808351e-01, -2.103663e-01,  3.968275e-01, -5.498005e-01,  1.715028e-01},
  { 9.995121e-01,  0.000000e+00,  3.123475e-02, -4.395493e-01, -5.242131e-01,  3.472119e-01},
  { 2.933562e-01, -9.307761e-01, -2.181696e-01, -8.325899e-02, -5.239547e-01,  1.123192e-01},
  { 1.586262e-01,  9.845741e-01, -7.383530e-02, -3.982261e-01, -5.204953e-01,  3.674265e-01},
  {-3.299218e-01,  7.671990e-01,  5.500522e-01, -4.095807e-01, -5.193015e-01,  3.589510e-01},
  { 9.838599e-01,  1.565437e-01,  8.668171e-02, -2.750994e-01, -5.165234e-01,  2.788716e-01},
  {-5.503894e-02,  8.816941e-01,  4.686004e-01,  3.412033e-02, -5.207655e-01,  2.127372e-01},
  {-9.521881e-01,  2.984560e-01, -6.528359e-02,  3.912517e-01, -5.190234e-01,  5.184692e-01},
  {-9.907740e-01, -5.258226e-02, -1.249077e-01, -5.258131e-01, -5.015063e-01, -2.936762e-01},
  { 3.655368e-01,  4.301538e-01, -8.254396e-01,  2.133539e-01, -5.075202e-01, -4.658684e-01},
  { 8.573794e-02, -3.538012e-01, -9.313827e-01,  2.133539e-01, -5.075202e-01, -4.658684e-01},
  {-2.278411e-01,  9.486318e-01,  2.195133e-01, -2.636217e-01, -4.719844e-01, -7.090344e-01},
  {-3.951729e-01, -2.103025e-01,  8.942099e-01,  4.171951e-01, -4.282612e-01,  3.653811e-01},
  {-9.281436e-01, -3.668742e-01, -6.287120e-02, -1.141755e-01, -4.199673e-01, -6.882153e-01},
  {-7.798360e-01,  3.466088e-01, -5.212660e-01, -7.684837e-02, -4.301347e-01,  4.631948e-01},
  { 2.182897e-01,  7.304798e-01,  6.471081e-01, -4.056880e-01, -3.802007e-01,  2.796222e-01},
  {-4.117771e-01,  5.967598e-01,  6.887070e-01,  1.274433e-01, -3.586227e-01,  7.642097e-01},
  { 5.769380e-01,  4.902015e-01, -6.533337e-01,  4.163737e-01, -3.390130e-01,  7.184273e-01},
  {-2.605720e-01, -5.881149e-01, -7.656521e-01, -5.633820e-01, -3.310643e-01, -4.214809e-01},
  { 4.463700e-01,  2.622513e-01, -8.555572e-01, -2.039475e-01, -3.250571e-01, -7.296386e-01},
  { 2.589068e-01, -4.573071e-01,  8.507864e-01, -3.878148e-01, -3.025550e-01,  3.796755e-01},
  {-9.245502e-01, -3.250264e-01,  1.989094e-01, -5.083024e-01, -2.844249e-01,  9.741720e-02},
  { 0.000000e+00,  2.425356e-01,  9.701425e-01, -8.963900e-02, -2.844518e-01, -4.209391e-01},
  { 0.000000e+00,  2.425356e-01,  9.701425e-01, -9.073050e-02, -2.798822e-01, -4.239056e-01},
  {-1.389005e-01,  9.157624e-01, -3.769428e-01, -4.085585e-01, -2.806937e-01,  6.804814e-02},
  {-5.723376e-01, -9.295484e-02, -8.147326e-01,  3.734877e-01, -2.505206e-01,  1.375716e-01},
  {-5.723376e-01, -9.295484e-02, -8.147326e-01,  3.768436e-01, -2.298685e-01,  1.328578e-01},
  {-8.709781e-01,  4.459542e-01, -2.062086e-01, -3.835734e-01, -2.241115e-01, -7.096469e-01},
  {-5.723376e-01, -9.295484e-02, -8.147326e-01,  3.818756e-01, -2.135226e-01,  1.274580e-01},
  { 9.167758e-01, -1.583473e-02, -3.990882e-01, -3.426602e-01, -2.182292e-01,  5.628293e-01},
  { 0.000000e+00,  7.071068e-01,  7.071068e-01,  4.573747e-01, -1.923403e-01, -2.609826e-01},
  { 4.548139e-01,  1.085696e-01, -8.839440e-01, -2.711525e-01, -1.574878e-01, -3.812237e-02},
  {-4.126127e-01,  2.673601e-01,  8.707866e-01, -5.355643e-01, -1.453094e-01, -4.514905e-01},
  {-6.879926e-01, -5.341699e-01, -4.912521e-01, -4.125718e-01, -1.301081e-01,  5.140515e-02},
  {-7.760192e-01, -5.436248e-01, -3.197912e-01, -2.660062e-01, -1.023792e-01,  5.514941e-01},
  { 2.851299e-01, -7.200018e-01, -6.326914e-01,  4.151911e-01, -9.421343e-02,  4.199392e-01},
  {-3.801304e-01, -7.269097e-01,  5.719293e-01, -4.706776e-01, -1.069225e-01,  1.054887e-01},
  { 8.005926e-01,  5.921907e-01, -9.144215e-02, -6.963644e-02, -6.357381e-02,  7.561623e-01},
  {-1.680677e-01, -9.516706e-01, -2.570531e-01, -4.224025e-01, -5.687634e-02,  3.811131e-01},
  { 2.793120e-01,  9.376711e-01,  2.067796e-01, -4.333499e-01, -4.915747e-02,  3.694195e-01},
  {-4.113536e-01,  7.893090e-01,  4.558284e-01, -4.636905e-01, -4.463654e-02,  3.279664e-01},
  {-6.186552e-01, -1.504554e-01, -7.711219e-01, -3.856491e-02,  1.671148e-02, -7.646288e-01},
  { 1.999127e-02, -9.933863e-01, -1.130655e-01, -3.324946e-01,  5.720330e-02,  3.749646e-01},
  {-1.411471e-01,  6.381086e-01,  7.568983e-01,  2.573603e-01,  8.028658e-02,  8.519306e-01},
  { 8.793490e-01, -1.117613e-01, -4.628766e-01, -3.011146e-01,  7.019775e-02,  4.314410e-01},
  {-9.438384e-01, -3.026025e-01, -1.326688e-01,  2.343767e-01,  9.745424e-02, -6.773905e-01},
  {-2.632226e-01,  6.522483e-01,  7.108347e-01, -4.794360e-01,  1.124748e-01,  3.065502e-02},
  {-4.472136e-01, -8.944272e-01,  0.000000e+00,  3.993985e-01,  1.079846e-01, -5.754017e-01},
  {-2.862459e-01,  3.358501e-01,  8.973672e-01,  2.533895e-01,  1.272855e-01, -6.420529e-01},
  { 8.099499e-01,  3.256717e-02,  5.855941e-01, -1.461103e-01,  1.248181e-01, -7.094266e-01},
  {-6.139985e-02,  1.751566e-01,  9.826242e-01, -7.423544e-02,  1.620085e-01,  7.152994e-01},
  {-2.928904e-01, -4.645537e-02,  9.550168e-01, -1.257265e-01,  1.558878e-01,  6.587021e-01},
  { 1.801946e-01,  6.242477e-01,  7.601610e-01, -4.038833e-02,  1.424134e-01, -1.815741e-01},
  {-9.519160e-01, -2.991645e-01, -6.600375e-02, -3.089393e-02,  1.439737e-01, -1.851061e-01},
  { 8.765075e-01,  1.322878e-01,  4.628549e-01,  3.196544e-01,  1.813249e-01,  4.566621e-01},
  {-7.743493e-01,  5.257317e-02, -6.305706e-01,  1.443711e-01,  1.877503e-01,  8.097818e-01},
  {-2.013981e-01, -7.096118e-01, -6.751962e-01, -1.663857e-01,  1.782570e-01,  6.473206e-01},
  { 4.924933e-01,  6.771520e-01,  5.467316e-01,  4.536352e-01,  2.042757e-01,  8.531008e-01},
  {-5.068211e-01, -7.705873e-01, -3.864293e-01, -1.980425e-01,  2.086692e-01,  6.248007e-01},
  { 8.641466e-03,  3.224979e-01, -9.465308e-01,  4.559045e-01,  2.132738e-01,  2.697470e-01},
  {-7.174351e-01, -5.191288e-02, -6.946883e-01,  1.824133e-01,  2.259919e-01,  5.576035e-01},
  { 8.641466e-03,  3.224979e-01, -9.465308e-01,  4.525754e-01,  2.301235e-01,  2.754576e-01},
  {-2.293865e-01,  9.717634e-01, -5.529731e-02,  5.050454e-01,  2.285325e-01, -3.759924e-01},
  {-7.743493e-01,  5.257317e-02, -6.305706e-01,  1.572679e-01,  2.408301e-01,  7.983699e-01},
  {-7.743493e-01,  5.257317e-02, -6.305706e-01,  1.638790e-01,  2.604165e-01,  7.918844e-01},
  {-7.156655e-01, -3.276544e-01,  6.168190e-01,  1.776788e-01,  2.522323e-01,  5.627313e-01},
  { 8.641466e-03,  3.224979e-01, -9.465308e-01,  4.528033e-01,  2.627502e-01,  2.865761e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.297633e-02,  2.439955e-01, -5.846882e-02},
  { 3.132196e-01, -2.921197e-01,  9.036369e-01, -3.771372e-01,  2.733768e-01, -2.065771e-01},
  {-9.311495e-01,  3.266620e-02,  3.631715e-01, -4.308815e-01,  2.958753e-01,  2.189625e-01},
  { 9.914624e-01, -8.559889e-02, -9.836170e-02,  4.748649e-01,  3.182445e-01,  7.750396e-01},
  { 5.064002e-01,  8.492740e-01,  1.493069e-01, -2.682075e-01,  3.182549e-01,  5.013476e-01},
  {-4.790153e-01, -1.699137e-01,  8.612047e-01,  4.712363e-01,  3.536955e-01,  7.844065e-01},
  {-5.726429e-01, -2.231091e-01,  7.888615e-01,  4.762183e-01,  3.700826e-01,  7.926576e-01},
  {-3.810021e-01,  9.044508e-01,  1.918492e-01,  3.815757e-01,  3.750300e-01,  5.385095e-01},
  {-5.358368e-01, -5.837875e-01,  6.099764e-01, -4.012627e-01,  3.547150e-01,  7.354528e-02},
  { 5.031914e-01,  7.544554e-01,  4.214209e-01, -7.481512e-02,  4.139739e-01, -8.555787e-01},
  { 7.985526e-01, -3.134417e-01, -5.138756e-01,  4.099009e-01,  4.381794e-01,  3.926490e-01},
  { 1.847956e-01,  8.854615e-02,  9.787799e-01, -2.443167e-01,  4.285216e-01,  2.989406e-01},
  { 1.400459e-02, -9.441533e-01,  3.292089e-01, -1.825194e-01,  4.758503e-01,  5.420333e-01},
  {-1.848945e-02,  9.447783e-01, -3.271882e-01, -1.812514e-01,  4.761880e-01,  5.431935e-01},
  {-8.462012e-01,  4.622289e-01, -2.651186e-01, -2.054614e-01,  4.784350e-01, -7.162301e-01},
  { 3.977405e-01, -3.704435e-01, -8.393891e-01, -1.949641e-01,  4.889991e-01, -7.187839e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00, -1.949641e-01,  4.889991e-01, -7.187839e-01},
  { 5.933757e-01, -6.249997e-01, -5.072284e-01, -1.981847e-01,  4.894755e-01, -7.231386e-01},
  {-5.776532e-01,  6.128087e-01,  5.392424e-01, -1.995587e-01,  4.884494e-01, -7.230811e-01},
  { 4.371447e-01, -6.557884e-01, -6.155047e-01,  1.530042e-01,  5.056797e-01, -8.158371e-01},
  {-4.862639e-01,  2.736536e-01, -8.298561e-01,  4.917498e-01,  5.784628e-01, -3.583275e-01},
  {-8.545084e-01, -4.116887e-01, -3.167458e-01, -1.844564e-01,  5.597481e-01, -5.210837e-01},
  {-3.173852e-02,  3.229238e-01, -9.458926e-01, -1.636978e-01,  5.709850e-01, -6.975852e-01},
  { 4.223186e-01, -4.026018e-01,  8.121323e-01,  2.836405e-02,  5.748091e-01,  5.715287e-01},
  {-6.504731e-01,  7.595068e-01,  5.852876e-03, -2.654859e-01,  5.837427e-01,  6.560525e-02},
  {-8.686733e-01, -1.837071e-02, -4.950448e-01,  2.198076e-01,  6.068989e-01, -3.603540e-01},
  {-4.873064e-01,  7.137872e-01, -5.030312e-01,  5.032577e-02,  5.984383e-01, -7.308918e-01},
  {-2.230108e-01,  8.908779e-01, -3.957307e-01,  7.639650e-02,  6.530241e-01,  2.166017e-01},
  {-2.230108e-01,  8.908779e-01, -3.957307e-01,  6.145937e-02,  6.419010e-01,  1.999786e-01},
  {-2.230108e-01,  8.908779e-01, -3.957307e-01,  8.994887e-02,  6.680576e-01,  2.428080e-01},
  { 4.339687e-01, -4.214914e-01,  7.962514e-01, -1.307213e-01,  7.048131e-01, -2.156271e-01},
  { 7.071068e-01,  0.000000e+00, -7.071068e-01,  8.596957e-02,  7.130477e-01, -3.665552e-01},
  {-9.117677e-02, -6.005033e-01,  7.944071e-01, -4.597618e-02,  7.179949e-01,  5.138039e-01},
  {-6.277596e-01,  7.590935e-01,  1.723220e-01, -4.228042e-02,  7.213015e-01,  5.161877e-01},
  {-5.717766e-01,  7.083662e-01, -4.138708e-01,  3.706928e-01,  7.120246e-01, -9.001861e-02},
  {-2.312024e-01, -9.471250e-01,  2.224854e-01,  1.174130e-01,  7.270645e-01,  6.037626e-01},
  {-4.044159e-01, -4.839285e-01, -7.760547e-01, -1.648790e-01,  7.991328e-01,  3.280452e-01},
  {-6.566344e-01, -4.688577e-01,  5.907654e-01, -6.866427e-02,  9.632549e-01,  2.790982e-01},
  { 1.926004e-01,  7.808014e-01, -5.943521e-01, -1.319203e-01,  9.939518e-01, -1.167257e-01},
  { 1.926004e-01,  7.808014e-01, -5.943521e-01, -4.710927e-02,  1.040125e+00,  3.459198e-02},
  {-6.777188e-03,  7.654189e-01, -6.434967e-01, -5.995552e-02,  1.057374e+00,  5.172404e-02},
  { 1.104459e-01, -9.750807e-01,  1.924045e-01,  4.655832e-01,  1.085008e+00,  5.525247e-01},
  { 1.104459e-01, -9.750807e-01,  1.924045e-01,  4.348443e-01,  1.081919e+00,  5.545166e-01},
  { 1.104459e-01, -9.750807e-01,  1.924045e-01,  3.832533e-01,  1.075202e+00,  5.500906e-01},
  {-1.443875e-01, -9.846253e-01,  9.831224e-02,  5.266817e-01,  1.108841e+00,  4.859437e-01},
  {-6.906390e-01, -5.873432e-01,  4.219548e-01, -5.310334e-02,  1.092601e+00,  1.056472e-01},
  {-9.398684e-01,  3.271718e-01,  9.801040e-02,  1.378833e-01,  1.134103e+00,  1.122293e-01},
  { 7.855175e-01,  5.195233e-01, -3.362409e-01, -2.433528e-02,  1.125911e+00, -1.510491e-01},
  {-1.503587e-01,  1.589276e-01, -9.757738e-01,  2.816173e-01,  1.290118e+00, -1.671109e-01},
  { 2.391632e-01,  3.276211e-01,  9.140379e-01,  3.621059e-01,  1.323090e+00, -1.535366e-01},
  { 6.904281e-01, -1.201037e-01,  7.133611e-01,  5.546193e-01,  1.334085e+00, -1.418030e-01},
  {-1.705160e-01, -6.680622e-01, -7.243047e-01,  7.540555e-02, -9.854484e-01,  3.944175e-01},
  {-6.673759e-01, -2.004293e-01,  7.172430e-01,  8.575442e-02, -5.083030e-01,  6.814566e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.742947e-02,  2.451462e-01, -4.990261e-02},
  {-8.793490e-01,  1.117613e-01,  4.628766e-01, -3.011146e-01,  7.019775e-02,  4.314410e-01},
  {-5.635759e-01,  6.750931e-01,  4.760584e-01, -1.949641e-01,  4.889991e-01, -7.187839e-01},
  { 5.933757e-01, -6.249997e-01, -5.072284e-01, -1.949641e-01,  4.889991e-01, -7.187839e-01},
  {-4.218861e-01, -4.196479e-01, -8.036839e-01, -4.794360e-01,  1.124748e-01,  3.065502e-02},
  { 9.670577e-01, -1.222620e-01, -2.232742e-01, -4.794360e-01,  1.124748e-01,  3.065502e-02},
  {-4.641397e-01, -1.022765e-01, -8.798374e-01, -4.708512e-01,  1.272735e-01,  1.836621e-02},
  {-4.641397e-01, -1.022765e-01, -8.798374e-01,  4.636332e-01, -1.910101e-01, -2.577957e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  2.812262e-01,  2.204374e-01, -6.613927e-01},
  { 7.679556e-02, -9.333085e-01, -3.507672e-01,  3.776537e-01, -5.581352e-01,  3.113233e-01},
  {-8.805842e-01,  3.639931e-01, -3.034479e-01, -5.633820e-01, -3.310643e-01, -4.214809e-01},
  { 5.358368e-01,  5.837875e-01, -6.099764e-01, -3.827861e-01,  3.600647e-01,  9.489613e-02},
  {-9.998038e-01, -1.974867e-02,  1.538018e-03, -4.032350e-01,  3.506045e-01,  6.787866e-02},
  {-5.358368e-01, -5.837875e-01,  6.099764e-01, -4.032350e-01,  3.506045e-01,  6.787866e-02},
  {-4.906345e-01,  5.596331e-01, -6.678987e-01, -5.157402e-01, -1.065572e-01, -4.335827e-01},
  {-7.071068e-01,  7.071068e-01,  0.000000e+00,  3.125549e-01, -8.665519e-01,  5.026292e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.027017e-01,  3.583950e-01,  7.815045e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00,  3.095807e-01,  3.703948e-01,  7.690489e-01},
  {-1.818565e-01, -7.855883e-01,  5.914214e-01, -4.254193e-01, -5.841874e-01, -5.727325e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -4.404135e-01, -5.800933e-01, -5.719048e-01},
  { 1.818565e-01,  7.855883e-01, -5.914214e-01, -4.404135e-01, -5.800933e-01, -5.719048e-01},
  {-7.872310e-01,  2.031759e-01,  5.822259e-01, -3.430306e-01, -1.195251e-01, -7.651761e-01},
  { 8.128928e-01, -3.068542e-01,  4.950210e-01,  9.721687e-02, -5.893686e-01,  7.320774e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00, -8.931639e-02, -2.730176e-01, -4.256351e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00, -8.284611e-02, -2.857620e-01, -4.163388e-01},
  {-7.969090e-01,  5.770907e-01,  1.786121e-01, -3.645387e-01,  7.006269e-02,  4.200784e-01},
  { 6.638434e-01, -7.013782e-01, -2.595778e-01,  5.050454e-01,  2.285325e-01, -3.759924e-01},
  {-8.571331e-01, -1.919772e-01,  4.779829e-01, -4.807557e-01, -7.420049e-01, -2.769928e-01},
  { 1.460517e-01, -8.732474e-01, -4.648741e-01, -3.255635e-01, -1.328462e-01, -7.629527e-01},
  {-5.810791e-01, -8.317691e-03,  8.138046e-01, -6.963644e-02, -6.357381e-02,  7.561623e-01},
  {-2.724352e-01, -4.490142e-01, -8.509790e-01,  5.192344e-02, -9.923761e-01,  4.063355e-01},
  { 3.858587e-01,  2.034394e-01,  8.998474e-01, -2.969296e-02,  6.255552e-01, -5.097234e-01},
  {-5.093731e-01, -7.850296e-01, -3.525161e-01, -2.378543e-01, -1.897507e-01, -2.495215e-02},
  {-9.066885e-01,  3.341070e-01,  2.574655e-01, -2.593403e-01, -5.528758e-01, -7.356239e-01},
  {-2.026878e-01, -9.621767e-01,  1.820263e-01,  6.223324e-02, -1.372242e+00, -4.340994e-01},
  {-2.026878e-01, -9.621767e-01,  1.820263e-01,  5.712070e-02, -1.365837e+00, -4.253607e-01},
  {-3.678457e-01,  5.412266e-01, -7.561504e-01, -3.369018e-01, -1.405307e-01, -1.204518e-03},
  { 5.391375e-01,  2.265231e-01,  8.111831e-01,  1.443711e-01,  1.877503e-01,  8.097818e-01},
  { 1.443875e-01,  9.846253e-01, -9.831224e-02,  5.251222e-01,  1.110074e+00,  4.959972e-01},
  {-1.443875e-01, -9.846253e-01,  9.831224e-02,  5.251222e-01,  1.110074e+00,  4.959972e-01},
  { 9.761838e-01,  2.140445e-01, -3.535703e-02,  5.255837e-01,  1.107686e+00,  4.727596e-01},
  { 1.443875e-01,  9.846253e-01, -9.831224e-02,  5.255837e-01,  1.107686e+00,  4.727596e-01},
  { 8.538235e-01,  5.185066e-01, -4.621993e-02,  5.315959e-01,  1.448939e-01, -4.165785e-01},
  { 8.944272e-01, -4.472136e-01,  0.000000e+00,  5.325525e-01,  1.485983e-01, -4.193127e-01},
  { 6.281711e-01, -5.393724e-01, -5.607837e-01, -3.715727e-01, -2.133083e-01, -7.137134e-01},
  {-8.716478e-01,  4.567209e-01, -1.778653e-01, -1.853283e-01,  5.984282e-01, -5.915587e-01},
  { 2.795096e-01, -4.948193e-01, -8.228173e-01,  3.324355e-01, -1.084808e+00,  1.995176e-01},
  {-2.452976e-01, -9.694475e-01,  8.327123e-04, -4.634823e-01, -4.859664e-01, -5.865465e-01},
  { 2.430870e-02,  9.890598e-01, -1.454987e-01, -4.254193e-01, -5.841874e-01, -5.727325e-01},
  {-1.000000e+00,  0.000000e+00,  0.000000e+00,  2.791337e-01, -6.902163e-01, -4.193900e-01},
  { 1.499643e-01,  2.776319e-01, -9.489105e-01,  2.319005e-01,  5.580555e-01, -3.925867e-01},
  { 1.499643e-01,  2.776319e-01, -9.489105e-01,  2.299682e-01,  5.634493e-01, -3.858913e-01},
  {-4.666764e-01, -7.850303e-01, -4.073582e-01, -2.019825e-01, -1.137806e+00, -6.032007e-01},
  {-2.935964e-01, -5.952073e-01, -7.480171e-01, -2.273867e-01, -7.931640e-01, -2.156540e-01},
  { 2.851299e-01, -7.200018e-01, -6.326914e-01,  4.153803e-01, -8.855777e-02,  4.135883e-01},
  { 2.851299e-01, -7.200018e-01, -6.326914e-01,  4.104027e-01, -9.023913e-02,  4.132585e-01},
  {-2.851299e-01,  7.200018e-01,  6.326914e-01,  4.104027e-01, -9.023913e-02,  4.132585e-01},
  { 2.268635e-01,  9.570465e-01, -1.805409e-01, -2.911285e-01, -4.458691e-01,  4.855595e-01},
  {-8.610770e-01, -3.218345e-01, -3.936612e-01, -2.911285e-01, -4.458691e-01,  4.855595e-01},
  {-8.930649e-01, -3.992602e-01,  2.074281e-01, -2.932464e-01, -4.497722e-01,  4.847673e-01},
  { 4.882890e-02, -8.088958e-01,  5.859210e-01,  9.812443e-03, -6.910426e-01, -6.272254e-01},
  { 4.088400e-01,  3.832195e-01,  8.282467e-01,  1.364909e-01,  6.754713e-01, -6.241725e-01},
  { 4.088400e-01,  3.832195e-01,  8.282467e-01,  5.128876e-01,  1.109076e+00,  5.312565e-01},
  { 4.088400e-01,  3.832195e-01,  8.282467e-01,  5.170688e-01,  1.113157e+00,  5.160216e-01},
  {-8.954273e-01, -4.100139e-01,  1.734896e-01, -4.698534e-01, -7.625082e-01, -2.691787e-01},
  { 4.836420e-01,  1.956070e-01, -8.531286e-01, -2.497736e-01, -5.287670e-01, -7.332194e-01},
  {-9.066885e-01,  3.341070e-01,  2.574655e-01, -2.493583e-01, -5.295250e-01, -7.307732e-01},
  {-4.537559e-02, -9.303426e-01,  3.638732e-01, -6.425221e-02, -7.279894e-01, -6.720602e-01},
  { 4.537560e-02,  9.303426e-01, -3.638732e-01, -6.425221e-02, -7.279894e-01, -6.720602e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -5.488652e-02, -7.246914e-01, -6.624599e-01},
  {-3.558834e-01,  3.578019e-01,  8.633220e-01, -3.478454e-02, -6.767728e-01, -3.670461e-01},
  { 8.059967e-01, -5.685754e-01,  1.645946e-01,  3.403073e-01, -1.236381e+00, -1.894437e-01},
  { 2.815850e-01, -7.890927e-01, -5.459327e-01, -5.941476e-02,  2.432591e-01, -8.907630e-01},
  {-1.788045e-01, -9.685592e-01, -1.729797e-01, -3.935670e-01, -1.306480e-01,  2.819766e-02},
  { 5.210978e-01,  7.496623e-01,  4.079994e-01,  3.089735e-01, -9.021985e-01, -3.044839e-01},
  {-3.992356e-02, -1.979154e-01, -9.794057e-01,  3.089735e-01, -9.021985e-01, -3.044839e-01},
  {-8.569883e-01, -4.969849e-01,  1.362980e-01,  2.899870e-01, -8.718550e-01, -3.132217e-01},
  {-8.569883e-01, -4.969849e-01,  1.362980e-01,  3.059820e-01, -8.984872e-01, -3.097605e-01},
  {-1.492578e-01,  9.217471e-01, -3.579167e-01, -3.699043e-01, -6.933537e-01, -4.736353e-01},
  {-1.818565e-01, -7.855883e-01,  5.914214e-01, -4.409719e-01, -5.845867e-01, -5.780452e-01},
  { 6.497414e-01, -6.012100e-01, -4.651695e-01,  5.627268e-04,  2.146576e-01, -5.798435e-01},
  { 1.348119e-01,  3.416218e-01,  9.301184e-01,  5.627268e-04,  2.146576e-01, -5.798435e-01},
  {-1.050512e-01,  7.722526e-01, -6.265701e-01,  5.738318e-02,  7.552240e-01,  5.811737e-01},
  {-4.089750e-01, -8.244609e-01,  3.911569e-01,  5.738318e-02,  7.552240e-01,  5.811737e-01},
  {-7.334864e-01, -8.775938e-02, -6.740149e-01,  6.337538e-02,  7.596462e-01,  5.740770e-01},
  {-4.876989e-01, -6.783429e-01,  5.495460e-01,  1.967043e-02,  7.598765e-01,  5.621998e-01},
  {-7.421968e-01, -4.063245e-01,  5.329580e-01, -4.581023e-01, -7.808987e-01, -2.519913e-01},
  {-6.465344e-01,  7.520598e-01,  1.280598e-01, -3.108217e-01,  5.048956e-01, -5.627988e-02},
  {-9.418164e-01, -3.344716e-01,  3.332721e-02, -2.850986e-01, -4.658838e-01,  4.888353e-01},
  { 7.587005e-01, -4.701772e-01, -4.508957e-01,  5.627268e-04,  2.146576e-01, -5.798435e-01},
  { 5.919874e-01, -6.215512e-01, -5.130547e-01,  3.470679e-02,  2.700602e-01, -6.075650e-01},
  {-9.228622e-01,  3.098963e-01,  2.286692e-01, -3.910582e-02,  2.503358e-01,  7.373728e-01},
  { 8.153897e-01, -5.363802e-01, -2.177980e-01,  5.105666e-01,  1.107299e+00,  5.372089e-01},
  {-2.321035e-01, -9.284142e-01,  2.901294e-01,  2.871056e-01, -1.293829e+00, -4.609678e-01},
  {-2.321035e-01, -9.284142e-01,  2.901294e-01,  3.136957e-01, -1.271436e+00, -4.056658e-01},
  {-1.303811e-01, -9.166507e-01,  3.778258e-01, -3.982261e-01, -5.204953e-01,  3.674265e-01},
  { 5.965444e-01, -7.362968e-01, -3.193772e-01, -4.046506e-01, -9.285170e-01, -3.228996e-01},
  { 5.965444e-01, -7.362968e-01, -3.193772e-01, -4.215605e-01, -9.304176e-01, -3.501027e-01},
  {-1.591843e-01, -9.795820e-01, -1.227995e-01,  3.687876e-01, -9.064020e-01,  4.327896e-01},
  {-1.331556e-02,  9.145519e-01,  4.042494e-01,  1.593368e-01, -3.751134e-01,  7.855824e-01},
  {-2.836003e-01, -9.160480e-01, -2.835964e-01,  1.593368e-01, -3.751134e-01,  7.855824e-01},
  { 3.102260e-01,  5.381687e-01, -7.836672e-01,  1.791876e-01, -3.621980e-01,  8.023100e-01},
  { 0.000000e+00,  1.000000e+00,  0.000000e+00,  3.607765e-01,  4.828440e-01, -4.029327e-01},
  { 9.754050e-01, -2.090990e-01, -6.973302e-02, -2.128974e-02,  1.517784e-01, -5.535814e-01},
  { 7.605883e-01, -4.411497e-01, -4.763322e-01, -1.698223e-02,  1.804787e-01, -5.647470e-01},
  {-3.969452e-01, -2.250548e-01, -8.898229e-01,  3.164488e-01, -9.405380e-01, -3.078277e-01},
  {-9.521881e-01,  2.984560e-01, -6.528359e-02,  3.906044e-01, -5.181927e-01,  5.317070e-01},
  {-1.206105e-01, -8.910004e-01, -4.376887e-01, -3.723499e-01, -9.032790e-01,  3.889422e-02},
  { 3.475668e-01, -8.581988e-01, -3.777461e-01, -5.372991e-02,  2.469824e-01, -8.866009e-01},
  {-3.626803e-02,  5.372670e-01,  8.426320e-01,  2.540548e-01,  1.327311e-01, -6.479129e-01},
  {-8.943629e-01,  4.415293e-01,  7.188129e-02, -3.935069e-01, -2.448624e-01, -7.057800e-01},
  {-9.532471e-01, -2.669101e-01, -1.417000e-01, -3.128158e-01, -9.766437e-01, -8.801512e-02},
  {-9.145104e-01, -3.912711e-01, -1.028477e-01, -1.657393e-01,  4.487689e-01,  4.492336e-01},
  { 8.944272e-01, -4.472136e-01,  0.000000e+00,  5.315959e-01,  1.448939e-01, -4.165785e-01},
  { 7.466564e-01,  2.428367e-01, -6.193017e-01,  5.278153e-01,  1.429954e-01, -4.215666e-01},
  {-4.535253e-01,  6.367465e-01, -6.235934e-01, -2.200502e-02,  6.251874e-01, -5.183780e-01},
  {-5.264733e-01, -5.578650e-01,  6.415703e-01,  1.710960e-01, -1.313642e+00, -4.536733e-01},
  { 7.099811e-01, -6.960407e-01, -1.070244e-01,  1.710960e-01, -1.313642e+00, -4.536733e-01},
  { 7.907249e-01, -5.274820e-01, -3.106715e-01,  1.551611e-01, -1.324145e+00, -4.910716e-01},
  { 9.488847e-01, -9.358674e-02,  3.014288e-01,  4.901073e-01,  5.990160e-01, -3.559279e-01},
  { 6.794237e-01, -7.249140e-01, -1.135040e-01, -3.125713e-01, -3.608188e-01, -6.278628e-01},
  {-8.772526e-01,  2.022727e-01,  4.353316e-01, -3.125713e-01, -3.608188e-01, -6.278628e-01},
  { 8.320503e-01,  0.000000e+00, -5.547002e-01, -3.854310e-01, -6.710172e-01, -4.383238e-01},
  {-7.724136e-01, -1.635733e-01,  6.136946e-01,  6.145937e-02,  6.419010e-01,  1.999786e-01},
  { 4.463700e-01,  2.622513e-01, -8.555572e-01, -1.969849e-01, -3.316894e-01, -7.280390e-01},
  { 4.463700e-01,  2.622513e-01, -8.555572e-01, -2.128747e-01, -3.125741e-01, -7.304698e-01},
  {-6.794590e-01, -6.181985e-01, -3.951787e-01, -3.643553e-02,  2.638111e-01,  7.298875e-01},
  {-9.413947e-01,  2.957337e-01,  1.622266e-01, -3.643553e-02,  2.638111e-01,  7.298875e-01},
  {-5.260886e-01, -8.229952e-01, -2.142653e-01, -7.161367e-02,  3.220299e-01,  6.992972e-01},
  {-6.204499e-01, -2.776917e-01,  7.334366e-01, -8.239563e-02, -8.432221e-01,  4.697891e-01},
  { 0.000000e+00,  9.544800e-01, -2.982750e-01, -8.645917e-02,  5.630881e-01, -4.533517e-01},
  { 0.000000e+00,  9.544800e-01, -2.982750e-01, -1.100975e-01,  5.472539e-01, -4.546076e-01},
  { 3.476194e-02, -7.822904e-01, -6.219432e-01, -1.648790e-01,  7.991328e-01,  3.280452e-01},
  {-4.608499e-01,  8.590973e-01, -2.226415e-01,  2.684269e-02,  1.002740e+00,  3.679891e-01},
  { 8.467193e-02,  9.918765e-01, -9.493025e-02,  4.600697e-01,  1.395070e-01, -2.641201e-01},
  {-8.961914e-01, -1.086577e-01,  4.301564e-01,  2.240589e-01,  8.506296e-01,  5.991594e-01},
  {-8.570285e-01,  3.625642e-01,  3.661273e-01, -3.192688e-01, -1.412664e-01, -7.251363e-01},
  {-1.181932e-01, -9.926510e-01,  2.597032e-02, -3.381843e-01, -1.293029e-01, -7.534488e-01},
  {-8.657486e-01,  9.694639e-02, -4.909998e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  {-2.837584e-01, -8.936241e-01, -3.477314e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  {-4.250996e-01,  8.568186e-01,  2.918088e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  { 3.457339e-02,  7.204070e-01,  6.926892e-01,  1.009880e-01,  7.297091e-01,  5.979519e-01},
  { 5.209305e-02,  1.135680e-01,  9.921637e-01, -9.178441e-02, -1.243127e+00, -2.685871e-01},
  { 5.209305e-02,  1.135680e-01,  9.921637e-01, -6.605846e-02, -1.251950e+00, -2.689280e-01},
  {-1.368995e-01,  1.422028e-01, -9.803249e-01, -3.430306e-01, -1.195251e-01, -7.651761e-01},
  {-1.823003e-01, -9.382812e-01,  2.939303e-01,  4.663682e-01,  1.403221e-01, -2.601226e-01},
  { 5.239225e-02, -9.914376e-01,  1.196104e-01,  4.663682e-01,  1.403221e-01, -2.601226e-01},
  {-5.487348e-01, -8.359960e-01, -8.996154e-04,  3.063536e-01,  8.200653e-01,  6.692004e-01},
  {-5.487348e-01, -8.359960e-01, -8.996154e-04,  2.818019e-01,  8.361883e-01,  6.621434e-01},
  {-3.292758e-01,  8.948580e-01, -3.013415e-01, -6.697005e-02,  1.065347e+00,  5.971555e-02},
  {-2.719688e-01,  8.788010e-01, -3.920991e-01, -6.795107e-02,  1.067747e+00,  6.791356e-02},
  { 1.554901e-01,  8.235247e-01,  5.455545e-01, -3.864978e-01, -6.475685e-03, -1.826491e-01},
  {-2.824744e-01, -2.363511e-01, -9.297023e-01, -5.725867e-01, -5.694536e-01, -1.426382e-01},
  {-8.679076e-01,  4.823000e-01,  1.188412e-01, -5.729711e-01, -5.410145e-01, -9.433791e-02},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00,  4.010840e-02,  8.714800e-01,  4.341211e-01},
  { 9.364429e-01,  1.334305e-01, -3.244551e-01,  1.476183e-01,  1.805035e-01,  8.161737e-01},
  {-1.085642e-01,  9.934888e-01, -3.455291e-02, -4.457284e-01, -4.451440e-02,  3.439645e-01},
  {-1.085642e-01,  9.934888e-01, -3.455291e-02, -4.821650e-01, -5.117976e-02,  2.668002e-01},
  { 0.000000e+00, -7.071068e-01, -7.071068e-01,  3.624028e-01, -9.085898e-01,  4.596903e-01},
  {-1.222207e-01,  8.063954e-01, -5.786092e-01, -3.687939e-01, -6.811571e-01, -4.536434e-01},
  {-1.977889e-01,  5.257785e-01, -8.273067e-01, -3.854310e-01, -6.710172e-01, -4.383238e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -3.739472e-01,  1.725503e-01, -1.625618e-01},
  { 1.000000e+00,  0.000000e+00,  0.000000e+00, -3.735416e-01,  1.885507e-01, -1.684847e-01},
  {-2.925426e-01,  3.500779e-01, -8.898676e-01,  2.016383e-01,  1.261883e+00, -1.334149e-01},
  { 5.326577e-02,  4.492144e-01,  8.918348e-01,  2.016383e-01,  1.261883e+00, -1.334149e-01},
  { 8.727394e-01, -4.759450e-01, -1.086389e-01,  5.104830e-01,  2.288771e-01, -3.630173e-01},
  { 5.923639e-01,  6.687799e-01,  4.492643e-01, -2.715520e-01, -9.118711e-01,  2.394580e-01},
  { 1.647858e-01,  9.861226e-01,  2.019160e-02, -2.379230e-01,  2.989262e-01,  5.394865e-01},
  {-4.261694e-01,  8.586013e-01,  2.849275e-01,  4.241656e-01,  1.341595e+00,  8.956553e-02},
  {-6.329518e-01, -3.540065e-01, -6.885139e-01, -4.497800e-01, -7.855040e-01, -2.569485e-02},
  {-2.431701e-01, -3.059176e-02, -9.695011e-01, -4.430611e-01, -7.791812e-01, -2.812492e-02},
  {-2.793120e-01, -9.376711e-01, -2.067796e-01, -4.333499e-01, -4.915747e-02,  3.694195e-01},
  { 6.222147e-03,  9.365994e-01,  3.503469e-01, -4.457284e-01, -4.451440e-02,  3.439645e-01},
  {-4.224194e-01, -8.115377e-01, -4.036934e-01, -1.742373e-01, -1.091697e+00,  2.292679e-02},
  { 6.807753e-02, -9.501420e-01,  3.042955e-01, -1.727955e-01,  4.696984e-01,  5.239763e-01},
  { 2.522784e-01,  1.649438e-01, -9.534932e-01, -2.479269e-01,  6.069583e-01,  2.099778e-01},
  {-9.156419e-01,  2.481902e-01, -3.162301e-01, -2.479269e-01,  6.069583e-01,  2.099778e-01},
  { 1.613401e-02, -5.372623e-02,  9.984254e-01, -2.154611e-01,  6.463898e-01,  2.253889e-01},
  {-3.951729e-01, -2.103025e-01,  8.942099e-01,  4.232062e-01, -4.142527e-01,  3.713321e-01},
  {-3.951729e-01, -2.103025e-01,  8.942099e-01,  4.104575e-01, -4.371570e-01,  3.603114e-01},
  { 8.268090e-01, -4.654191e-01, -3.158667e-01,  3.642669e-01, -7.101143e-01,  1.039933e-01},
  {-2.668167e-01, -6.889637e-01,  6.738976e-01,  3.642669e-01, -7.101143e-01,  1.039933e-01},
  { 7.643430e-01, -3.574848e-01, -5.366418e-01,  3.778613e-01, -7.240114e-01,  1.326134e-01},
  {-2.668167e-01, -6.889637e-01,  6.738976e-01,  3.601766e-01, -7.452954e-01,  6.640615e-02},
  {-2.668167e-01, -6.889637e-01,  6.738976e-01,  4.827945e-01,  8.308265e-01,  2.236115e-01},
  { 5.798773e-01, -1.588188e-01,  7.990738e-01,  1.133526e-01, -1.268338e+00, -6.663364e-01},
  { 4.650654e-01, -7.375867e-01, -4.895714e-01,  3.048479e-01, -1.080427e+00,  2.901267e-01},
  {-4.650655e-01,  7.375866e-01,  4.895714e-01,  3.048479e-01, -1.080427e+00,  2.901267e-01},
  { 4.478386e-01, -6.090332e-01,  6.546137e-01,  3.157963e-01, -1.073713e+00,  2.904122e-01},
  { 4.650654e-01, -7.375867e-01, -4.895714e-01,  3.157963e-01, -1.073713e+00,  2.904122e-01},
  {-8.952197e-01, -3.067012e-01,  3.232894e-01, -1.539048e-01,  5.462924e-01, -6.924691e-01},
  {-8.952197e-01, -3.067012e-01,  3.232894e-01, -1.638733e-01,  5.768009e-01, -6.911299e-01},
  {-8.793310e-03,  9.998914e-01,  1.182712e-02, -2.045153e-01, -7.845994e-01,  3.459305e-01},
  { 8.793310e-03, -9.998914e-01, -1.182712e-02, -2.045153e-01, -7.845994e-01,  3.459305e-01},
  {-8.352861e-01, -3.729941e-01, -4.039462e-01, -1.965829e-01, -7.841813e-01,  3.164788e-01},
  { 8.793310e-03, -9.998914e-01, -1.182712e-02, -1.965829e-01, -7.841813e-01,  3.164788e-01},
  {-4.306862e-01, -7.521909e-01, -4.987166e-01, -3.878148e-01, -3.025550e-01,  3.796755e-01},
  { 7.470550e-01,  5.072731e-01,  4.296311e-01,  2.887529e-01, -8.141543e-01,  5.209730e-01},
  { 7.127650e-01,  5.272816e-01, -4.625368e-01,  2.887529e-01, -8.141543e-01,  5.209730e-01},
  { 2.903886e-01, -8.497418e-01,  4.400150e-01,  2.887529e-01, -8.141543e-01,  5.209730e-01},
  {-7.522854e-01, -6.194381e-01,  2.244175e-01,  2.807195e-01, -7.819908e-01,  5.828212e-01},
  {-8.101892e-03, -8.631176e-01,  5.049380e-01,  2.775887e-01, -7.787114e-01,  5.813782e-01},
  { 5.945584e-01, -6.498451e-01,  4.734994e-01,  2.723808e-01, -7.784089e-01,  5.905890e-01},
  {-7.200043e-01,  3.674305e-01,  5.887178e-01,  5.131892e-01,  8.940722e-01,  6.641963e-01},
  {-4.874144e-01,  5.192686e-01,  7.019881e-01,  5.138105e-01,  9.082674e-01,  6.515592e-01},
  {-2.892607e-02,  3.133970e-01,  9.491816e-01,  4.227763e-01,  1.342757e+00,  8.398680e-02},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -4.309958e-01, -5.718853e-01, -5.581928e-01},
  { 0.000000e+00, -1.000000e+00,  0.000000e+00, -4.254193e-01, -5.841874e-01, -5.727325e-01},
  {-4.554118e-01,  8.321228e-01,  3.164994e-01, -2.758044e-02,  1.853323e-01,  7.211098e-01},
  { 1.765140e-01, -6.095198e-01, -7.728702e-01, -4.633837e-01, -7.789197e-01, -2.547583e-01},
  {-4.510801e-01,  4.081841e-01,  7.936702e-01,  1.697199e-01,  1.081547e+00,  4.196423e-01},
  { 3.030776e-01, -3.500897e-01, -8.863302e-01, -2.414323e-02, -6.672167e-01, -3.666200e-01},
  {-3.558834e-01,  3.578019e-01,  8.633220e-01, -2.414323e-02, -6.672167e-01, -3.666200e-01},
  {-3.558834e-01,  3.578019e-01,  8.633220e-01, -2.985469e-02, -6.878434e-01, -3.604257e-01},
  { 9.915962e-01, -1.238825e-01, -3.728401e-02, -2.985469e-02, -6.878434e-01, -3.604257e-01},
  {-3.686620e-01,  9.294737e-01,  1.292206e-02,  5.005285e-01,  2.283472e-01, -3.605126e-01},
  {-2.866431e-01, -3.488210e-01, -8.922778e-01,  1.366130e-02, -9.769954e-01,  4.063489e-01},
  {-3.388931e-01,  8.501704e-01, -4.029414e-01, -2.948096e-01, -4.414980e-01,  5.041054e-01},
  { 5.650496e-01, -2.571444e-01, -7.839615e-01, -1.490212e-01, -7.364841e-01, -4.050251e-02},
  { 5.650496e-01, -2.571444e-01, -7.839615e-01, -1.902457e-01, -8.219920e-01, -4.216841e-02},
  { 5.650496e-01, -2.571444e-01, -7.839615e-01,  2.002469e-01, -6.148968e-01, -3.169737e-01},
  { 5.650496e-01, -2.571444e-01, -7.839615e-01,  1.656384e-01, -6.117475e-01, -3.174004e-01},
  { 1.922857e-01,  4.963844e-01,  8.465392e-01,  1.058395e-01, -7.639271e-01,  6.108691e-01},
  {-9.141712e-01, -2.747597e-02,  4.043960e-01, -1.294382e-01,  7.108676e-01, -2.131215e-01},
  { 1.329522e-02,  5.956053e-01,  8.031673e-01,  2.008351e-01, -1.189775e+00, -5.321260e-04},
  {-2.131664e-01, -7.915297e-01,  5.727484e-01,  2.008351e-01, -1.189775e+00, -5.321260e-04},
  {-1.329522e-02, -5.956052e-01, -8.031673e-01,  1.614173e-01, -1.188887e+00, -5.383070e-04},
  { 1.329522e-02,  5.956053e-01,  8.031673e-01,  1.614173e-01, -1.188887e+00, -5.383070e-04},
  {-8.127515e-01,  5.607375e-01, -1.581406e-01,  1.399550e-01, -1.174893e+00, -7.204979e-01},
  {-7.065468e-01,  9.235978e-02,  7.016134e-01, -3.722619e-01,  1.321416e-01, -5.508521e-01},
  {-8.928999e-01, -1.138816e-01, -4.356154e-01, -3.722619e-01,  1.321416e-01, -5.508521e-01},
  { 9.906581e-01, -1.085666e-01, -8.252110e-02,  2.336275e-01,  4.797181e-02, -6.212840e-01},
  {-5.125144e-01,  2.144123e-01,  8.314785e-01,  2.540548e-01,  1.327311e-01, -6.479129e-01},
  {-1.121751e-01, -4.601657e-01,  8.807181e-01,  1.955934e-01, -8.928186e-01,  5.523893e-01},
  {-2.030696e-01, -9.480422e-01, -2.449059e-01,  3.598629e-01, -5.735638e-01,  3.484800e-01},
  {-7.465997e-01,  6.412443e-01,  1.771852e-01, -1.694262e-01,  9.934660e-01, -1.264131e-01},
  { 1.134286e-01, -5.540004e-01,  8.247531e-01, -3.615349e-02, -9.276175e-01,  4.261666e-01},
  {-1.536941e-01, -5.179080e-01,  8.415161e-01, -4.592993e-03, -9.402173e-01,  4.069191e-01},
  {-1.433134e-02, -5.572988e-01,  8.301883e-01,  5.192344e-02, -9.923761e-01,  4.063355e-01},
  { 1.043410e-01, -9.096910e-01,  4.019642e-01,  6.568079e-02, -9.925459e-01,  4.032533e-01},
  { 9.167758e-01, -1.583473e-02, -3.990882e-01, -3.499405e-01, -2.111240e-01,  5.458231e-01},
  { 9.167758e-01, -1.583473e-02, -3.990882e-01, -3.363686e-01, -2.288959e-01,  5.777054e-01},
  { 4.808259e-01, -4.194790e-02, -8.758121e-01,  2.051597e-01, -5.377083e-01, -4.660100e-01},
  {-1.910116e-01,  8.278311e-01,  5.274565e-01,  4.733195e-01,  1.084561e+00,  5.531512e-01},
  {-4.571463e-01,  4.744030e-01,  7.523026e-01,  5.105666e-01,  1.107299e+00,  5.372089e-01},
  {-6.223840e-01,  9.691169e-02,  7.766894e-01,  5.093832e-01,  1.113358e+00,  5.355045e-01},
  { 7.394499e-01,  6.324512e-01, -2.306933e-01,  4.628087e-01,  1.362205e-01, -2.754233e-01},
  {-1.823003e-01, -9.382812e-01,  2.939303e-01,  4.628087e-01,  1.362205e-01, -2.754233e-01},
  { 5.239225e-02, -9.914376e-01,  1.196104e-01,  4.600697e-01,  1.395070e-01, -2.641201e-01},
  {-1.823003e-01, -9.382812e-01,  2.939303e-01,  4.717723e-01,  1.387228e-01, -2.618764e-01},
  { 8.467193e-02,  9.918765e-01, -9.493025e-02,  4.717723e-01,  1.387228e-01, -2.618764e-01},
  {-3.488714e-01, -3.867890e-01, -8.536294e-01,  2.133539e-01, -5.075202e-01, -4.658684e-01},
  {-7.197432e-01, -5.748149e-01,  3.893040e-01, -5.571558e-01, -6.130205e-01, -1.457777e-01},
  { 2.317391e-01,  3.882866e-01,  8.919252e-01,  2.113513e-01, -4.625643e-01, -4.831300e-01},
  {-7.414739e-01,  8.736934e-02, -6.652692e-01, -5.737551e-01, -2.802075e-01, -4.166582e-01},
  { 4.347804e-01,  4.450825e-01, -7.828586e-01,  2.158427e-01, -5.739149e-01, -4.646989e-01},
  { 6.444200e-01, -3.464425e-01, -6.816894e-01,  4.754048e-01,  4.533725e-01,  4.553743e-01},
  {-8.260069e-01,  1.838147e-01,  5.328460e-01, -3.389485e-01, -9.236928e-01,  7.551423e-02},
  { 9.849096e-02, -7.275540e-01, -6.789438e-01, -3.389485e-01, -9.236928e-01,  7.551423e-02},
  { 3.311454e-02, -9.612270e-02, -9.948185e-01,  9.407843e-02, -4.918975e-01, -4.713483e-01},
  { 3.835045e-01,  9.541220e-02,  9.185972e-01,  1.106018e-01,  1.189384e+00,  2.393114e-01},
  { 8.237025e-02,  9.518614e-01, -2.952543e-01,  1.106018e-01,  1.189384e+00,  2.393114e-01},
  {-3.379218e-01,  9.352894e-01,  1.050835e-01,  2.231277e-02,  8.613576e-01,  4.268557e-01},
  { 3.379217e-01, -9.352894e-01, -1.050834e-01,  2.231277e-02,  8.613576e-01,  4.268557e-01},
  { 3.559953e-01,  0.000000e+00, -9.344878e-01,  2.231277e-02,  8.613576e-01,  4.268557e-01},
  { 0.000000e+00,  0.000000e+00, -1.000000e+00,  2.231277e-02,  8.613576e-01,  4.268557e-01},
  {-3.431375e-01,  9.353357e-01, -8.604433e-02, -2.701167e-01,  5.864080e-01,  7.438765e-02},
  {-6.547977e-01,  7.463092e-01,  1.194260e-01, -2.753741e-01,  5.781672e-01,  9.705982e-02},
  { 9.241757e-02, -7.928533e-01,  6.023643e-01,  5.295601e-01, -3.324825e-01, -2.079747e-01},
  { 9.241757e-02, -7.928533e-01,  6.023643e-01,  5.209351e-01, -3.101987e-01, -1.773207e-01},
  {-3.070176e-01, -1.251792e-01,  9.434354e-01,  2.688811e-01, -1.191722e+00, -1.241150e-02},
  {-3.623118e-01, -6.040069e-01,  7.098632e-01,  4.148771e-03,  7.499451e-01,  5.300927e-01},
  { 5.239225e-02, -9.914376e-01,  1.196104e-01,  4.619766e-01,  1.383327e-01, -2.746892e-01},
  { 5.030662e-01, -5.449883e-01, -6.707548e-01,  1.960355e-01,  1.071211e+00,  3.874849e-01},
  { 4.842820e-01, -1.222829e-01, -8.663243e-01, -2.923574e-01,  1.391993e-01, -8.232872e-01},
  { 4.842820e-01, -1.222829e-01, -8.663243e-01, -2.825431e-01,  1.636401e-01, -8.212507e-01},
  {-6.908318e-02,  9.585423e-01,  2.764493e-01,  1.465966e-02, -5.051909e-01,  6.925905e-01},
  { 7.157168e-01, -3.690189e-01, -5.929373e-01, -3.585109e-01, -1.966575e-01, -7.012003e-01},
  {-9.887344e-01,  1.029187e-01,  1.086828e-01, -3.950535e-01, -2.514067e-01, -6.848249e-01},
  {-9.840193e-01, -1.747661e-01,  3.409913e-02,  8.765083e-02, -5.763459e-01,  7.205386e-01},
  {-8.222151e-01, -5.031936e-01, -2.660047e-01, -1.881363e-01,  5.873804e-01, -5.619805e-01},
  {-4.728521e-01,  4.442920e-01, -7.609307e-01,  4.912035e-01,  5.455084e-01, -3.786571e-01},
  { 2.206732e-01,  2.185883e-01, -9.505380e-01, -6.425221e-02, -7.279894e-01, -6.720602e-01},
  { 5.036986e-01, -8.049682e-01,  3.135504e-01, -6.425221e-02, -7.279894e-01, -6.720602e-01},
  { 9.251398e-01,  3.248586e-01, -1.964263e-01, -4.021654e-01, -7.337446e-01, -5.041143e-02},
  { 9.251398e-01,  3.248586e-01, -1.964263e-01, -4.147626e-01, -7.063817e-01, -6.448839e-02},
  { 7.700986e-01,  2.000913e-01,  6.057323e-01,  3.013888e-01, -8.330150e-01,  5.131702e-01},
  { 2.067630e-01,  7.609611e-01,  6.149693e-01, -1.980425e-01,  2.086692e-01,  6.248007e-01},
  { 1.760382e-01,  7.642609e-01,  6.204158e-01, -2.042028e-01,  2.286772e-01,  5.945380e-01},
  {-6.403161e-01, -7.400060e-01,  2.058799e-01, -3.900782e-01, -2.585097e-01, -6.815116e-01},
  { 6.886290e-01, -6.297147e-01, -3.595129e-01,  3.282464e-01,  5.184696e-01,  7.829576e-01},
  { 3.236809e-01, -2.050650e-01,  9.236769e-01,  3.282464e-01,  5.184696e-01,  7.829576e-01},
  { 6.657556e-01,  7.387420e-01,  1.050221e-01,  1.397114e-01,  7.140466e-01,  5.715169e-01},
  {-9.253726e-02, -5.585631e-01,  8.242840e-01, -5.350798e-01, -2.113232e-01, -3.476529e-01},
  { 1.376221e-01,  7.582800e-01, -6.372374e-01, -5.350798e-01, -2.113232e-01, -3.476529e-01},
  { 2.213009e-01,  3.892555e-01,  8.941510e-01,  1.429575e-01, -7.763873e-01,  6.012518e-01},
  {-9.543533e-02, -9.910532e-01, -9.330416e-02,  3.601702e-01, -5.757229e-01,  3.634484e-01},
  {-8.308803e-01,  5.496129e-01,  8.696900e-02, -4.126650e-01,  3.253769e-01,  2.397191e-01},
  {-6.429467e-01,  3.761890e-01,  6.671592e-01, -4.210929e-01, -7.408825e-01, -5.670139e-01},
  {-9.960099e-01, -2.709040e-02,  8.503139e-02, -4.397429e-01, -7.512379e-01, -5.791481e-01},
  {-9.266074e-01, -3.220798e-01,  1.940708e-01, -5.440699e-02,  2.873707e-01,  7.239316e-01},
  {-9.000131e-01,  2.819533e-01,  3.323835e-01, -2.593403e-01, -5.528758e-01, -7.356239e-01},
  { 4.118017e-03, -2.905911e-01,  9.568384e-01, -3.321377e-01, -3.791842e-01,  2.536640e-01},
  {-9.437465e-01, -2.916574e-01,  1.558158e-01, -4.084602e-01, -3.512833e-01,  2.479144e-01},
  { 4.575383e-02,  9.908143e-01,  1.272545e-01, -1.732534e-01,  2.439396e-01, -8.551310e-01},
  { 6.123763e-01, -3.440571e-01, -7.117724e-01, -1.809598e-01,  4.912502e-01, -7.053974e-01},
  {-6.051779e-01,  9.691349e-02, -7.901693e-01, -4.224598e-01, -2.771054e-01,  4.038979e-01},
  {-8.553112e-01, -3.194958e-01,  4.078788e-01, -4.385796e-01, -2.456463e-01,  4.257130e-01},
  {-4.167931e-01,  1.120100e-01, -9.020739e-01, -4.385796e-01, -2.456463e-01,  4.257130e-01},
  {-7.884284e-02, -5.882552e-01, -8.048228e-01, -3.445219e-01, -5.763472e-01, -6.368213e-01},
  {-7.884284e-02, -5.882552e-01, -8.048228e-01, -3.461435e-01, -5.815225e-01, -6.023067e-01},
  {-2.148001e-01,  7.734670e-04,  9.766577e-01, -3.888344e-01, -2.195750e-01, -3.258880e-01},
  {-4.864680e-01,  4.663565e-01,  7.388238e-01, -4.085418e-01, -5.824460e-02,  3.771162e-01},
  {-6.307326e-02,  2.692460e-01,  9.610038e-01, -4.085418e-01, -5.824460e-02,  3.771162e-01},
  {-3.426491e-01, -9.394516e-01, -4.732971e-03, -4.457284e-01, -4.451440e-02,  3.439645e-01},
  { 4.944578e-01, -3.843054e-01,  7.796286e-01,  3.933044e-01, -5.388160e-01,  3.104615e-01},
  {-9.760095e-01,  2.161884e-01, -2.584451e-02,  1.383795e-01, -6.606995e-01, -5.835427e-01},
  {-4.880961e-01,  8.724827e-01,  2.315748e-02, -2.894545e-01,  5.765948e-01,  1.268962e-01},
  {-5.326334e-01,  8.226366e-01,  1.989238e-01, -2.931744e-01,  5.739929e-01,  1.465212e-01},
  {-6.786630e-01,  7.121923e-01, -1.794397e-01, -2.196691e-01,  6.143164e-01,  1.765821e-01},
  {-1.521294e-01,  6.980727e-01,  6.996794e-01,  4.990745e-01,  1.111699e+00,  5.274509e-01},
  {-4.838151e-01,  5.693255e-01, -6.646740e-01, -5.157402e-01, -1.065572e-01, -4.335827e-01},
  { 9.970631e-02, -9.245250e-01, -3.678482e-01, -4.599400e-01, -4.766566e-02,  3.365962e-01},
  {-4.232609e-01, -8.953963e-01,  1.382591e-01, -4.636905e-01, -4.463654e-02,  3.279664e-01},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.655623e-01, -6.154907e-01,  4.532381e-02},
  { 0.000000e+00,  0.000000e+00,  1.000000e+00, -3.895902e-01, -6.043576e-01, -8.464222e-03},
  {-9.428299e-01, -2.631726e-01, -2.044797e-01, -5.234609e-01, -5.439078e-01,  5.350320e-02},
  { 9.075423e-01, -3.750302e-01,  1.889958e-01, -5.234609e-01, -5.439078e-01,  5.350320e-02},
  {-6.267611e-01,  2.580178e-01,  7.352532e-01, -3.778940e-01, -8.956273e-01,  2.624826e-02},
  {-3.905769e-01,  5.302854e-01, -7.524939e-01, -4.312018e-01, -7.063659e-01, -2.743215e-01},
  {-3.174975e-01, -9.444034e-01,  8.542625e-02, -2.775024e-01,  3.211923e-01,  4.842484e-01},
  {-8.539012e-01,  3.229651e-01,  4.081008e-01, -2.775024e-01,  3.211923e-01,  4.842484e-01},
  {-3.174975e-01, -9.444034e-01,  8.542625e-02, -2.820964e-01,  3.193485e-01,  4.467906e-01},
  { 9.451789e-01,  1.346508e-01,  2.974997e-01,  4.223186e-01, -3.449419e-01,  3.557119e-01},
  { 9.451789e-01,  1.346508e-01,  2.974997e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  {-8.239256e-01, -1.548746e-01, -5.451244e-01, -4.365617e-01,  7.265282e-02, -2.806453e-01},
  {-8.239256e-01, -1.548746e-01, -5.451244e-01, -4.349594e-01,  5.236077e-02, -2.187288e-01},
  {-2.925426e-01,  3.500779e-01, -8.898676e-01,  3.222572e-01,  1.314545e+00, -1.523507e-01},
  {-1.529065e-01,  6.005455e-01,  7.848342e-01,  3.240103e-01,  1.325403e+00, -1.593984e-01},
  { 8.944272e-01, -4.472136e-01,  0.000000e+00,  4.706725e-01,  1.382260e+00, -6.803595e-02},
  { 1.420358e-01,  5.309118e-01, -8.354390e-01,  1.399550e-01, -1.174893e+00, -7.204979e-01},
  {-9.507412e-01,  1.486603e-01,  2.720132e-01, -2.774324e-01, -6.653368e-01, -7.302359e-01},
  {-7.743154e-02, -6.192855e-01,  7.813385e-01, -2.624639e-01,  4.146260e-01,  2.947477e-01},
  {-9.772153e-02, -6.040825e-01,  7.909076e-01, -2.684377e-01,  4.096238e-01,  2.858275e-01},
  {-8.371430e-01, -2.728757e-01, -4.740574e-01, -1.160975e-01,  8.473311e-01,  2.701472e-01},
  { 2.624617e-01,  9.646673e-01,  2.304345e-02, -2.682075e-01,  3.182549e-01,  5.013476e-01},
  {-7.295548e-01,  6.831645e-01,  3.218759e-02, -5.560083e-01, -5.137110e-01, -6.136858e-02},
  {-5.464200e-01,  8.113589e-01, -2.076582e-01,  4.227763e-01,  1.342757e+00,  8.398680e-02},
  {-4.817242e-01,  8.198419e-01, -3.095173e-01,  4.346418e-01,  1.347635e+00,  8.273751e-02},
  { 2.410869e-01,  8.313832e-01, -5.006786e-01, -1.709040e-01, -1.594855e-01,  5.918196e-01},
  {-9.049494e-01,  4.175537e-01,  8.194824e-02, -1.709040e-01, -1.594855e-01,  5.918196e-01},
  { 5.179562e-02,  2.948685e-01,  9.541330e-01, -2.241075e-01, -1.389520e-01,  5.593407e-01},
  {-3.115278e-01,  1.986515e-01,  9.292406e-01,  3.333209e-01, -8.083696e-01, -4.373275e-01},
  { 4.095068e-01, -2.178370e-01, -8.859184e-01,  3.333209e-01, -8.083696e-01, -4.373275e-01},
  {-3.952480e-01,  4.126501e-01, -8.206697e-01, -2.785676e-01, -8.112350e-01, -4.481627e-01},
  {-5.487040e-01,  1.778971e-01,  8.168699e-01, -5.674409e-02, -1.075995e+00, -2.849559e-01},
  { 5.048087e-01,  8.141233e-01,  2.870041e-01, -1.115690e-01, -1.030946e+00, -3.163133e-01},
  { 5.048087e-01,  8.141233e-01,  2.870041e-01,  1.734693e-01, -5.704728e-01, -5.367759e-01},
  { 3.132196e-01, -2.921197e-01,  9.036369e-01, -3.682758e-01,  2.934899e-01, -2.031466e-01},
  {-9.975113e-01,  3.862049e-02, -5.898979e-02, -3.778095e-01,  2.612643e-01, -2.102596e-01},
  { 4.467832e-01,  8.939726e-01,  3.460710e-02,  1.534181e-01,  7.005291e-01,  5.581372e-01},
  { 4.170076e-01, -3.561001e-01,  8.362401e-01,  5.222006e-01,  1.342007e+00, -1.167447e-01},
  {-3.417561e-01, -9.391738e-01,  3.399310e-02, -4.025076e-01, -8.498582e-01,  1.243016e-02},
  { 4.328267e-01, -6.877111e-01, -5.828503e-01, -3.500139e-01, -8.598703e-01,  6.322548e-02},
  { 9.949728e-01, -1.216296e-02, -9.940497e-02,  4.730678e-01,  3.065957e-01,  7.784290e-01},
  { 9.617905e-02,  9.950757e-01,  2.395837e-02, -1.160975e-01,  8.473311e-01,  2.701472e-01},
  {-1.382776e-01,  6.599299e-01,  7.384930e-01, -1.621205e-01,  8.234442e-01,  2.976201e-01},
  { 8.589682e-01,  3.591984e-01,  3.648975e-01, -1.648790e-01,  7.991328e-01,  3.280452e-01},
  {-9.521881e-01,  2.984560e-01, -6.528359e-02,  3.912013e-01, -5.220692e-01,  5.052785e-01},
  { 7.010441e-03, -6.832998e-01,  7.301043e-01,  8.435459e-02, -1.198880e+00, -6.425273e-01},
  {-1.629733e-01,  7.545303e-01, -6.357073e-01,  8.435459e-02, -1.198880e+00, -6.425273e-01},
  {-9.245502e-01, -3.250264e-01,  1.989094e-01, -5.116369e-01, -2.691410e-01,  1.068929e-01},
  {-8.092317e-01, -4.404002e-01, -3.888338e-01, -5.073642e-01, -2.854389e-01,  1.001213e-01},
  { 2.906224e-01,  4.381461e-01,  8.506272e-01,  4.650475e-01, -2.783012e-01, -5.254685e-01},
  { 2.906224e-01,  4.381461e-01,  8.506272e-01,  4.592727e-01, -2.885351e-01, -5.182242e-01},
  { 5.769466e-01,  7.223033e-01, -3.813275e-01,  1.430194e-03,  1.121359e+00, -1.029327e-01},
  {-6.430984e-01,  7.305104e-01, -2.297370e-01, -2.933212e-01, -4.341443e-01,  5.145262e-01},
  { 8.576099e-01, -3.917552e-01,  3.332162e-01, -4.126650e-01,  3.253769e-01,  2.397191e-01},
  {-7.071068e-01,  7.071068e-01,  0.000000e+00,  4.446332e-01,  5.767925e-02,  8.685559e-01},
  {-4.505973e-01,  8.459109e-01, -2.853012e-01, -2.706802e-01, -4.901772e-01, -6.377404e-01},
  {-6.052276e-02,  9.683641e-01, -2.420910e-01,  2.705230e-01, -9.910135e-01,  3.689527e-01},
  { 8.960644e-02,  9.902530e-01,  1.066287e-01,  2.658770e-01, -9.933149e-01,  3.942299e-01},
  {-2.425356e-01,  0.000000e+00, -9.701425e-01,  2.146463e-01, -9.925526e-01,  4.243512e-01},
  { 3.775619e-01, -9.184189e-01, -1.181253e-01, -5.276962e-01, -5.667790e-01,  1.499649e-01},
  {-8.284217e-01,  4.674743e-01,  3.085211e-01, -5.276962e-01, -5.667790e-01,  1.499649e-01},
  {-3.858596e-01,  3.592430e-01, -8.497393e-01, -2.983606e-01, -8.510464e-01, -4.560058e-01},
  {-3.858596e-01,  3.592430e-01, -8.497393e-01,  4.171877e-02, -3.560595e-01, -5.669754e-01},
  {-3.858596e-01,  3.592430e-01, -8.497393e-01,  4.025219e-02, -3.188372e-01, -6.340740e-01},
  { 4.515856e-02, -9.867054e-01,  1.561192e-01, -1.349250e-02, -1.215017e+00, -7.492694e-01},
  {-7.071068e-01,  0.000000e+00,  7.071068e-01,  4.129196e-01,  7.578897e-02,  8.708559e-01},
  { 7.399483e-01,  5.405197e-02, -6.704885e-01, -2.636217e-01, -4.719844e-01, -7.090344e-01},
  {-9.428605e-01, -6.003729e-02,  3.277342e-01, -2.375248e-01, -1.124804e+00, -2.190991e-01},
  { 3.971205e-01,  4.706115e-02,  9.165591e-01, -2.375248e-01, -1.124804e+00, -2.190991e-01},
  {-6.802284e-01, -5.365413e-01,  4.994124e-01, -2.276680e-01, -1.141400e+00, -2.061089e-01},
  { 0.000000e+00,  6.585046e-01, -7.525767e-01,  3.228624e-01, -9.105824e-01, -5.155845e-01},
  { 6.914605e-01, -3.317502e-01, -6.417353e-01,  4.754048e-01,  4.533725e-01,  4.553743e-01},
  {-9.801254e-01, -1.715970e-01, -9.954166e-02, -2.799334e-01, -6.159537e-02,  5.487390e-01},
  {-9.575696e-01, -1.892717e-01,  2.173401e-01, -2.772658e-01, -7.113914e-01, -7.158358e-01},
  { 6.886290e-01, -6.297147e-01, -3.595129e-01,  3.204963e-01,  5.048432e-01,  7.919803e-01},
  { 7.164121e-01,  6.412973e-01,  2.747571e-01,  2.477607e-01,  2.410077e-01, -6.797137e-01},
  {-9.068286e-01,  2.467230e-01, -3.417452e-01, -4.794360e-01,  1.124748e-01,  3.065502e-02},
  { 4.694987e-01,  3.775113e-01, -7.981580e-01,  2.490965e-01, -6.010952e-01, -4.775256e-01},
  {-2.942432e-01,  8.782552e-01,  3.769465e-01,  5.034564e-01,  8.907101e-01,  1.772635e-01},
  { 8.431211e-01,  4.989486e-01, -2.004923e-01,  5.034564e-01,  8.907101e-01,  1.772635e-01},
  { 8.455511e-01, -5.070427e-01, -1.671857e-01,  4.883101e-01,  8.772322e-01,  1.415362e-01},
  {-1.558920e-01, -5.575866e-01,  8.153496e-01, -4.762354e-01, -2.071434e-01, -3.299707e-01},
  {-7.251971e-01, -3.168124e-01, -6.113256e-01, -4.331305e-01,  1.035942e-01, -2.946221e-01},
  {-4.689124e-02, -7.091749e-01, -7.034716e-01, -4.254181e-01,  1.360635e-01, -3.278688e-01},
  {-6.697220e-01, -9.878211e-02, -7.360126e-01, -4.101588e-01,  1.511629e-01, -3.441076e-01},
  { 7.398055e-02,  7.795728e-01,  6.219270e-01, -2.750994e-01, -5.165234e-01,  2.788716e-01},
  {-6.599663e-01,  6.770375e-01, -3.256758e-01,  3.064710e-01,  9.765027e-01,  6.079522e-01},
  {-4.036459e-01, -2.565498e-01,  8.782097e-01,  3.064710e-01,  9.765027e-01,  6.079522e-01},
  { 4.473359e-01,  5.336779e-01, -7.176898e-01, -6.866427e-02,  9.632549e-01,  2.790982e-01},
  {-9.239168e-01, -1.488535e-01,  3.524491e-01, -5.257160e-02,  9.291360e-01,  2.637577e-01},
};

static GLushort smoothwmsurf_indices[][3] =
{
  {   1, 5809,    0},
  {   3,    2,    0},
  {   1,    0,    2},
  {   3,    0,    7},
  {   5, 6105,    4},
  {   4, 6105,    5},
  {   7,    0, 5809},
  {   6, 6104,    9},
  {  13, 5809,    1},
  {   8,    6,   10},
  {  18,   17,    3},
  {   3,   17,    2},
  {  46,    2,   17},
  {  12,    3,    7},
  {   2,   32,    1},
  {  20,    9,   19},
  {  33,    1,   32},
  {6104,    6,   11},
  {  11,    9, 6104},
  {  13,    1,   33},
  {   6,    8, 6188},
  {   6,    9,   10},
  {  12, 5809,   22},
  {  30,   16,   25},
  {  16,   30,   17},
  {  17,   18,   16},
  {  32,    2,   46},
  {   9,   11,   19},
  {   6, 6188,   34},
  {  10,   24,   15},
  {  23,   38,   24},
  {  26,   42,   43},
  {  26,   43,   27},
  {  28,   26,   29},
  {  26,   27,   29},
  {  45,  115,   28},
  {  44,   29,   27},
  {  28,   29,   45},
  {  16,   18,   88},
  {  48,   32,   46},
  {  20,   19,   50},
  {  20,   50,   31},
  {  31,   52,   20},
  {  31,   50,   49},
  {  31,   49,   52},
  {  12,   68,    3},
  {  20,   52,   35},
  {  34,   21,    6},
  {  11,    6,   21},
  {  20,   35,    9},
  {  68,   12,   54},
  {  11,   21,   19},
  {  54,   12,   22},
  {  33, 5810,   13},
  {  53,  124, 5810},
  {  35,   10,    9},
  {  10,   35,   36},
  {  22, 5812,   54},
  {  55,   54, 5812},
  {  10,   36,   23},
  {  10,   23,   24},
  {  15,   24,   37},
  {  24,   38,   37},
  {  57,   23,   36},
  {  39,   41,   25},
  { 113,   27,   43},
  {  27,  113,   44},
  {  47,   29,   44},
  {  17,   30,   46},
  {  45,   29,   47},
  {  18,    3,   47},
  {  47,   88,   18},
  {  32,   48,   89},
  {  49,   51,   52},
  {  68,   45,    3},
  {  32,   89,   91},
  {  33,   32, 5810},
  {  32,   91, 5810},
  {  34,   67,   21},
  {  94,   35,   52},
  {6187, 6188,  124},
  {  54,   55,   68},
  {  71,   36,   35},
  {6188,   14,   97},
  {  37,   97,   14},
  {  37,   38,   97},
  {  36,   71,   57},
  {  38,   23,   56},
  {  57,   56,   23},
  {  58,   59,   60},
  {  39,   59,   40},
  {  82,   40,   59},
  {  40,   84,   39},
  {  39,   84,   41},
  { 157,   25,   41},
  {  61,   42,   62},
  { 113,   43,   42},
  {  42,   26,   28},
  {  25,  132,   39},
  {  25,   16,  132},
  { 114,  132,   16},
  { 157,   30,   25},
  { 115,   42,   28},
  { 114,   16,   88},
  { 115,   45,   87},
  {  45,   63,   87},
  {  47,   44,   88},
  {  63,   45,   64},
  {  64,   45,   90},
  {  48,   65,   89},
  {  51,   49,   50},
  {  68,   90,   45},
  {  52,   66,   94},
  {6164, 6163,   93},
  {6188,   67,   34},
  {  19,   92,   50},
  {  19,   21,   92},
  {6186, 5810,   91},
  {5811, 6186,   91},
  {  21,   67,   95},
  {  92,   21,   95},
  {  38,   56,   97},
  {  56,   70,   97},
  {  56,   57,   70},
  {  69,   74,   72},
  {  74,   73,   72},
  {  77, 6255,   79},
  {  77,  103,   75},
  { 105,   79,   78},
  {  80,   58,   81},
  {  80,   81,  109},
  { 192,   81,   58},
  {  59,  110,   82},
  {  58,   60,  192},
  { 110,   40,   82},
  {  40,  110,   83},
  {  40,   83,   84},
  {  39,   60,   59},
  {  62,   85,   61},
  {  41,   84,  131},
  {  41,  131,  157},
  {  85,   62, 6141},
  {5896,   62,  112},
  {  62,   42,  112},
  {  42,  193,  113},
  {  42,   61,  193},
  { 135,   42,  115},
  {  44,  113,   88},
  {  63,  121,   87},
  {  87,  121,  117},
  {  65,   48,  120},
  {  63,   64,  121},
  {  65,  166,   89},
  {  52,   51,   50},
  {  95,   67,  123},
  {6188,   91,   67},
  {6163, 6164,   93},
  {  66,   69,   94},
  {  55, 5812,  124},
  {  95,  125,   92},
  { 302, 6188,  141},
  {6188,   97,  141},
  {  96,   69,   66},
  {  69,   72,   94},
  {  71,   35,  143},
  {  69,   99,   98},
  {  69,   96,   99},
  {  70,  100,   97},
  {  94,   72,   73},
  {  69,   98,   74},
  {  70,   71,  100},
  { 143,  100,   71},
  {  94,   73,  101},
  {  73,   74,  101},
  { 103,  173,   75},
  {  76,   75,  173},
  {  79,  103,   77},
  {  79,  105,  104},
  { 106,  108,  107},
  { 109,  107,  108},
  { 108,  107,  106},
  { 130,  108,  107},
  {  80,  109,   58},
  { 109,   81,  192},
  { 109,  192,  107},
  {  59,   58,  110},
  {  83,  111,   84},
  { 132,  192,   60},
  {  60,   39,  132},
  {  84,  111,  131},
  { 192,  132,  155},
  { 135,  112,   42},
  {  30,  157,   46},
  { 113,  114,   88},
  {5897, 6213, 6212},
  { 162,   46,  157},
  {  86,  116,  119},
  {  86,  119,  118},
  { 162,  120,   48},
  {  48,   46,  162},
  { 166,   65,  120},
  { 121,  122,  117},
  { 121,   64,   90},
  { 121,   90,  122},
  { 122,   90,  138},
  {  89,  166,   91},
  {  50,   92,   52},
  {  90,   68,  138},
  {  91,  123,   67},
  {  68,   55,  124},
  {  35,   94,  143},
  { 126,  141,   97},
  {  95,  142,  125},
  {  96,   66,  140},
  { 144,   98,   99},
  {  97,  100,  169},
  { 203,  169,  100},
  {  98,  144,   74},
  { 100,  102,  203},
  { 127,  101,  145},
  { 101,  127,  128},
  {  79,  148,  173},
  {  79,  173,  103},
  {  79,  104,  148},
  { 105,  210,  147},
  { 147,  148,  104},
  { 104,  105,  147},
  { 130,  154,  108},
  { 109,  110,   58},
  { 192,  130,  107},
  { 110,  251,   83},
  {  83,  251,  111},
  {  61,   85,  193},
  { 133,  132,  114},
  { 113,  133,  114},
  {  86,  157,  131},
  { 159,  116,   86},
  { 117,  134,  135},
  { 116,  159,  161},
  { 115,   87,  135},
  { 117,  135,   87},
  { 136,  164,  116},
  { 117,  122,  134},
  { 134,  122,  160},
  { 162,  165,  120},
  { 119,  116,  164},
  { 139,  123,  166},
  { 123,   91,  166},
  {  52,  226,   66},
  {  95,  123,  142},
  {  52,   92,  226},
  {  66,  167,  140},
  {  68,  124,  138},
  { 138,  124,  302},
  { 226,   92,  125},
  { 167,   66,  226},
  { 141,  126,  168},
  { 142,  263,  125},
  { 126,   97,  168},
  { 202,   99,   96},
  {  97,  169,  168},
  { 202,  144,   99},
  { 101,  204,   94},
  { 100,  143,  205},
  { 100,  205,  102},
  { 170,  204,  101},
  {  74,  145,  101},
  {  76,  203,  102},
  { 102,  205,  209},
  { 101,  128,  170},
  { 175,  147,  210},
  { 129,  128,  127},
  { 210, 5813, 6439},
  { 129,  150,  128},
  { 148,  147,  151},
  { 154,  130,  184},
  { 110,  191,  216},
  { 110,  217,  251},
  { 110,  216,  217},
  { 112,  156, 5817},
  { 194, 5817,  156},
  { 133,  155,  132},
  { 112,  135,  156},
  { 193,  155,  113},
  { 133,  113,  155},
  { 135,  134,  333},
  { 135,  333,  156},
  { 134,  158,  333},
  {  86, 6425,  159},
  { 134,  160,  158},
  {  86,  118,  157},
  { 196,  157,  118},
  { 162,  157,  220},
  { 118,  218,  196},
  { 116,  161,  136},
  { 163,  136,  161},
  { 137,  218,  118},
  { 118,  119,  164},
  { 136,  163,  164},
  { 122,  138,  160},
  { 120,  165,  166},
  { 165,  139,  166},
  { 139,  200,  123},
  { 200,  225,  123},
  { 142,  123,  225},
  { 140,  167,   96},
  { 263,  142,  225},
  { 202,   96,  228},
  { 143,   94,  204},
  { 144,  202,   74},
  {  74,  202,  145},
  { 203,   76,  173},
  { 207,  203,  173},
  { 174,  145,  171},
  { 229,  174,  171},
  {5818,  172,  208},
  {5818,  208,  146},
  { 209,  170,  128},
  { 173,  148,  208},
  {6440,  211,  231},
  { 102,  209,  210},
  { 128,  150,  209},
  { 127,  145,  310},
  { 127,  310,  129},
  { 148,  177,  208},
  {6440, 5813,  211},
  { 210, 6458, 5814},
  { 148,  151,  177},
  {5813,  176,  211},
  { 178,  212,  149},
  {5903,  178,  149},
  { 147,  235,  151},
  { 150, 6458,  210},
  { 235,  177,  151},
  {5900,  150,  275},
  { 152, 5901,  153},
  {5898, 5900,  275},
  {5898,  275,  182},
  { 153, 5901,  183},
  {6296,  185, 5902},
  { 187,  188,  245},
  { 184,  130,  244},
  { 109,  108, 6340},
  { 109, 6340,  110},
  { 190,  110, 6340},
  { 110,  190,  191},
  { 191,  246,  216},
  { 111,  251,  420},
  { 111,  420, 6425},
  { 111, 6425,  131},
  {  86,  131, 6425},
  { 194,  156,  195},
  { 158,  160,  333},
  { 159, 6425,  161},
  { 221,  163,  161},
  { 163,  221,  197},
  { 162,  220,  223},
  { 162,  223,  165},
  { 218,  137,  255},
  { 164,  163,  561},
  { 197,  221,  198},
  { 160,  138,  222},
  { 137,  118,  199},
  { 163,  197,  561},
  { 139,  165,  200},
  { 138,  302,  222},
  { 125,  263,  226},
  { 168,  169,  141},
  { 201,  202,  228},
  { 143,  204,  205},
  { 170,  205,  204},
  { 172, 5818,  141},
  { 205,  170,  206},
  { 145,  202,  171},
  { 171,  202,  229},
  { 172,  141,  208},
  { 231,  230, 6440},
  { 206,  209,  205},
  { 269,  232, 5818},
  { 170,  209,  206},
  { 310,  174,  229},
  {5818,  149,  269},
  { 212,  269,  149},
  { 150,  210,  209},
  { 233,  129,  310},
  { 146,  208,  149},
  { 233,  150,  129},
  { 233,  271,  150},
  { 176, 5815,  211},
  { 178, 5903,  212},
  { 236, 5815,  179},
  { 179,  180,  274},
  { 179,  274,  236},
  { 150,  271,  275},
  { 180,  153,  183},
  { 180,  183,  274},
  { 244,  281,  184},
  { 184,  281, 5819},
  { 214,  189,  213},
  { 279,  189,  214},
  { 243,  189,  279},
  { 190, 5819, 6295},
  { 188,  213,  245},
  { 190, 6295,  246},
  {6295,  187,  246},
  { 192,  414,  130},
  { 190,  246,  191},
  { 248,  285,  193},
  { 216,  284,  217},
  { 193,  285,  155},
  { 155,  285,  192},
  { 330,  194,  254},
  { 194,  195,  254},
  { 156,  333,  331},
  { 156,  331,  195},
  { 157,  196,  218},
  { 292,  333,  160},
  { 220,  157,  219},
  { 255,  219,  157},
  { 157,  218,  255},
  { 160,  222,  292},
  { 257,  255,  137},
  { 118,  224,  199},
  { 118,  164,  224},
  { 164,  561,  224},
  { 198,  561,  197},
  { 258,  165,  223},
  { 137,  259,  257},
  { 199,  224,  463},
  { 165,  258,  200},
  { 137,  199,  259},
  { 463,  259,  199},
  { 226,  228,  167},
  { 167,  228,   96},
  { 263,  227,  226},
  { 266,  201,  228},
  { 141,  169,  203},
  {5818,  232,  141},
  { 141,  203,  207},
  { 202,  268,  229},
  { 231,  305,  230},
  { 173,  208,  141},
  { 141,  207,  173},
  { 233,  270,  271},
  { 149,  208, 5903},
  { 208,  177, 5903},
  { 235, 5903,  177},
  { 211, 5815,  236},
  { 212,  234,  273},
  { 275,  183, 5901},
  { 237,  238,  239},
  { 241,  278,  242},
  {5819,  281, 6295},
  {6294, 6297,  186},
  { 188,  187,  279},
  { 188,  279,  213},
  { 214,  213,  279},
  {6295,  281,  187},
  { 189,  243,  282},
  { 189,  282,  215},
  { 414,  244,  130},
  { 187,  245,  325},
  { 501,  245,  213},
  { 215,  213,  189},
  { 247,  216,  246},
  { 284,  216,  247},
  { 192,  249,  414},
  { 248,  375,  285},
  { 284,  251,  217},
  { 252,  372, 6463},
  { 291,  251,  288},
  { 420,  251,  291},
  { 219,  255,  220},
  { 220,  257,  223},
  { 256,  198,  221},
  { 255,  257,  220},
  { 198,  256,  561},
  { 561,  463,  224},
  { 257,  259,  258},
  { 258,  262,  200},
  { 302,  299,  222},
  { 200,  262,  225},
  { 260,  232,  261},
  { 263,  225,  262},
  { 226,  264,  335},
  { 226,  335,  300},
  { 226,  300,  228},
  { 267,  261,  232},
  { 262,  227,  263},
  { 227,  264,  226},
  { 265,  302,  141},
  { 201,  306,  202},
  { 269,  307,  232},
  {6122,  229,  268},
  { 310,  229, 6122},
  { 211,  343,  231},
  { 269,  212,  344},
  { 147,  175,  235},
  { 211,  236,  343},
  { 345,  344,  212},
  { 314,  275,  271},
  { 212,  273,  345},
  { 316,  236,  274},
  { 183,  275,  274},
  { 237,  239,  277},
  { 238,  276,  239},
  { 240,  278,  241},
  { 319,  488,  240},
  { 240,  241,  319},
  { 241,  242,  319},
  { 244,  322,  281},
  { 244,  280,  322},
  { 281,  371,  187},
  { 279,  187,  371},
  { 244,  414,  280},
  { 213,  215,  501},
  { 283,  501,  215},
  { 246,  187,  247},
  { 501,  325,  245},
  { 414,  249,  326},
  { 328,  248, 5817},
  { 375,  326,  285},
  { 249,  192,  326},
  { 250,  372,  286},
  { 285,  326,  192},
  { 372,  252,  286},
  { 252,  287,  286},
  {6461, 6463,  372},
  { 251,  329,  288},
  { 422,  330,  254},
  { 288,  332,  291},
  { 221,  161, 6425},
  { 223,  257,  258},
  { 612,  561,  256},
  { 294,  297,  295},
  { 298,  295,  297},
  { 297,  295,  294},
  { 295,  298,  296},
  { 334,  222,  293},
  { 259,  463,  383},
  { 260,  261,  301},
  { 260,  301,  296},
  { 261,  267,  301},
  { 304,  301,  267},
  { 260,  302,  232},
  { 265,  232,  302},
  { 260,  299,  302},
  { 227,  262,  264},
  { 303,  264,  262},
  { 228,  337,  266},
  { 300,  337,  228},
  { 267,  338,  304},
  { 230,  305,  340},
  { 306,  268,  202},
  {6440,  230,  340},
  { 308,  268,  306},
  { 305,  231,  343},
  { 233,  310,  272},
  { 233,  272,  270},
  { 310, 6122,  272},
  {6122,  312,  272},
  { 271,  270,  311},
  { 272,  311,  270},
  {6410,  313,  234},
  {6410,  345,  313},
  { 271,  311,  314},
  { 315,  311,  272},
  { 272,  312,  315},
  { 273,  313,  345},
  { 236,  316,  348},
  { 275,  314,  346},
  { 311,  315,  347},
  { 275,  346,  348},
  { 274,  275,  348},
  { 274,  348,  316},
  { 354,  276,  238},
  { 317,  276,  354},
  { 277,  444,  237},
  { 318,  276,  317},
  { 318,  277,  239},
  { 239,  276,  318},
  { 488,  359,  240},
  { 240,  359,  278},
  { 361,  278,  359},
  {5904,  448, 5823},
  {5823,  364, 5904},
  { 243,  279,  369},
  { 321,  243,  369},
  { 243,  321,  282},
  { 322,  280,  323},
  { 493,  281,  322},
  { 493,  371,  281},
  { 283,  215,  282},
  { 323,  280,  414},
  { 501,  283,  324},
  { 247,  187,  329},
  { 187,  325,  329},
  { 247,  329,  327},
  { 247,  327,  284},
  { 327,  329,  284},
  { 284,  329,  251},
  {5817,  330,  328},
  { 287,  252,  456},
  {6462,  457,  289},
  { 289,  457,  377},
  { 422,  376,  330},
  { 288,  329,  332},
  { 252,  253,  456},
  { 195,  331,  254},
  { 332,  419,  291},
  { 290,  289,  421},
  { 423,  333,  292},
  { 221,  378,  256},
  { 297,  379,  298},
  { 297,  295,  379},
  { 293,  260,  334},
  { 296,  380,  295},
  { 296,  298,  260},
  { 293,  222,  299},
  { 259,  383,  258},
  { 296,  301,  382},
  { 260,  293,  299},
  { 258,  383,  262},
  { 264,  303,  335},
  { 303,  383,  335},
  { 335,  336,  300},
  { 384,  382,  301},
  { 301,  304,  384},
  { 300,  336,  337},
  { 266,  387,  201},
  { 201,  387,  306},
  { 309,  308,  306},
  { 269,  339,  307},
  { 340,  341, 6440},
  { 305,  343,  389},
  { 309,  388,  342},
  { 341, 6298, 6440},
  { 309,  312, 6122},
  { 309,  391,  312},
  { 309,  342,  391},
  { 344,  390,  269},
  { 345, 6410,  344},
  { 343,  236,  394},
  { 439,  312,  391},
  { 346,  236,  348},
  { 236,  346,  394},
  { 314,  311,  394},
  { 352, 6258,  349},
  { 352,  349,  350},
  { 351,  442,  350},
  { 317,  354,  397},
  { 318,  317,  353},
  { 238,  237,  354},
  { 355,  354,  237},
  { 356,  358,  357},
  { 356,  357,  358},
  { 444,  355,  237},
  { 277,  447,  444},
  { 359,  360,  361},
  { 277,  365,  447},
  { 277,  318,  365},
  { 488,  319,  362},
  { 278,  361,  362},
  { 278,  362,  242},
  { 319,  242,  362},
  { 320,  364,  363},
  { 406,  366,  321},
  {5906, 6243,  409},
  { 711,  321,  369},
  { 409, 6243,  370},
  { 411,  322,  323},
  { 493,  322,  411},
  { 279,  604,  369},
  { 495,  411,  323},
  { 283,  282,  413},
  { 283,  413,  324},
  { 323,  414,  495},
  { 501,  324,  416},
  { 414,  373,  375},
  { 501,  329,  325},
  { 373,  414,  326},
  { 454,  372,  417},
  { 414,  248,  328},
  { 248,  414,  375},
  { 373,  326,  375},
  { 372,  454, 6461},
  { 286,  287,  456},
  { 286,  456,  250},
  { 376,  374,  328},
  { 328,  330,  376},
  { 253,  290,  456},
  { 289,  377,  421},
  { 331,  422,  254},
  { 333,  459,  331},
  { 423,  459,  333},
  { 291,  419,  420},
  { 462,  423,  292},
  { 292,  222,  462},
  { 334,  425,  464},
  { 334,  464,  222},
  { 425,  334,  260},
  { 426,  298,  379},
  { 612,  256,  378},
  { 379,  295,  380},
  { 260,  298,  426},
  { 296,  382,  380},
  { 381,  380,  382},
  { 335,  383,  336},
  { 303,  262,  383},
  { 384,  304,  307},
  { 339,  433,  431},
  { 386,  266,  385},
  { 266,  337,  385},
  { 304,  338,  307},
  { 266,  386,  387},
  { 305,  472,  340},
  { 473,  305,  389},
  { 269,  519,  339},
  { 475,  473,  389},
  { 306,  520,  309},
  { 342,  388,  391},
  { 390,  344, 6410},
  { 343,  311,  389},
  { 391,  388,  479},
  { 393,  391,  479},
  { 343,  394,  311},
  { 347,  389,  311},
  { 315,  389,  347},
  { 315,  312,  392},
  { 439,  438,  392},
  { 392,  312,  439},
  { 391,  393,  439},
  { 394,  346,  314},
  {6259, 5907, 6256},
  { 395,  396, 6257},
  { 351,  398,  354},
  { 398,  397,  354},
  { 397,  398,  353},
  { 353,  317,  397},
  { 353,  398,  441},
  { 352,  350,  484},
  { 352,  484, 6258},
  { 351,  354,  355},
  { 353,  441,  318},
  { 399,  401,  400},
  { 399,  400,  401},
  { 401,  484,  358},
  {6116,  358,  484},
  {6116,  484,  543},
  { 543,  358, 6116},
  { 360,  359,  318},
  { 447,  365,  489},
  { 365,  450,  489},
  { 361,  852,  362},
  { 450, 5820,  547},
  { 318,  548,  365},
  { 362,  403,  488},
  { 362,  852,  403},
  { 405,  450,  365},
  { 365,  548,  405},
  { 368,  407,  367},
  { 406,  321,  711},
  { 369,  410,  711},
  { 409,  412,  603},
  { 409,  370,  412},
  { 324,  413,  416},
  { 415,  372,  250},
  { 372,  597,  417},
  { 452,  417,  597},
  { 328,  374,  414},
  { 457,  418,  377},
  { 329,  501,  419},
  { 329,  419,  332},
  { 377,  418,  421},
  {6425,  504,  221},
  { 461,  425,  426},
  { 426,  425,  260},
  { 462,  222,  464},
  { 507,  383,  463},
  { 426,  379,  428},
  { 379,  380,  428},
  { 429,  428,  380},
  { 427,  612,  378},
  { 381,  429,  380},
  { 381,  382,  468},
  { 430,  381,  468},
  { 429,  381,  430},
  { 468,  382,  431},
  { 382,  384,  431},
  { 432,  433,  470},
  { 431,  384,  339},
  { 431,  433,  432},
  { 339,  384,  307},
  { 474,  386,  385},
  { 385,  337,  574},
  { 385,  574,  474},
  { 336,  574,  337},
  { 386,  474,  387},
  { 473,  472,  305},
  { 517,  340,  472},
  { 387,  474,  306},
  { 434,  306,  474},
  { 269,  390,  519},
  { 340,  521,  341},
  { 341,  521, 6298},
  { 473,  475,  518},
  { 434,  520,  306},
  { 309,  520,  388},
  { 389,  436,  523},
  { 389,  523,  435},
  { 436,  389,  437},
  { 389,  315,  437},
  { 437,  315,  438},
  { 315,  392,  438},
  { 438,  439,  481},
  { 393,  479,  482},
  { 350,  637,  351},
  { 440, 6258,  401},
  {6258,  484,  401},
  { 351,  355,  442},
  { 441,  443,  318},
  { 350,  442,  484},
  { 358,  543,  401},
  { 318,  443,  486},
  { 486,  360,  318},
  { 484,  547,  543},
  { 444,  447,  547},
  { 360,  486,  361},
  { 488,  318,  359},
  { 543,  547, 5820},
  { 448,  363,  402},
  { 489,  450,  547},
  { 402,  363,  490},
  { 402,  490,  448},
  { 403,  406,  711},
  { 403,  711,  488},
  { 403,  852,  406},
  { 404,  449,  451},
  { 405,  548,  550},
  { 406,  852,  366},
  { 550,  450,  405},
  { 451,  449,  407},
  { 367,  407,  449},
  { 451,  407,  603},
  { 368,  603,  407},
  { 408,  367,  449},
  { 409,  603,  368},
  { 282,  321,  413},
  {6243,  408,  370},
  { 412,  370,  408},
  { 604,  410,  369},
  { 412,  372,  415},
  { 412,  415,  603},
  { 412,  597,  372},
  { 493,  494,  371},
  { 371,  496,  279},
  { 279,  496,  604},
  { 413,  852,  497},
  { 413,  497,  416},
  { 453,  495,  374},
  { 455,  453,  374},
  { 414,  374,  495},
  { 452,  454,  417},
  { 250,  456,  648},
  { 376,  422,  374},
  { 290,  421,  456},
  { 457,  458,  418},
  { 418,  458,  421},
  { 421,  458,  502},
  { 557,  422,  331},
  {6426,  424, 5908},
  { 425,  461,  464},
  { 462,  465,  506},
  { 428,  429,  426},
  { 465,  462,  464},
  { 612,  427,  508},
  { 466,  505,  467},
  { 466,  508,  427},
  { 429,  430,  509},
  { 468,  431,  469},
  { 431,  432,  469},
  { 432,  470,  510},
  { 383,  471,  336},
  { 336,  622,  574},
  { 576,  339,  519},
  { 340,  517,  521},
  { 577,  518,  475},
  { 475,  389,  476},
  { 477,  476,  389},
  { 478,  390, 6410},
  { 389,  435,  477},
  { 523,  477,  435},
  { 436,  437,  525},
  { 437,  438,  525},
  { 480,  526,  521},
  { 479,  528,  482},
  { 482,  439,  393},
  { 349,  539,  350},
  { 637,  350,  539},
  { 590,  351,  637},
  { 351,  590,  398},
  { 398,  670,  441},
  { 484,  442,  485},
  { 355,  485,  442},
  { 670,  398,  590},
  { 444,  485,  355},
  { 540,  541,  443},
  { 486,  443,  541},
  { 445,  487,  483},
  { 483,  542,  445},
  { 484,  544,  547},
  { 543, 5820, 5822},
  { 447,  489,  547},
  { 318,  709,  548},
  { 593, 5822,  448},
  { 850,  448,  490},
  { 490,  363,  491},
  { 363,  595,  491},
  { 363,  364,  595},
  { 364,  450,  595},
  { 366,  852,  321},
  { 449,  597,  492},
  { 408,  449,  492},
  { 408,  492,  412},
  { 598,  711,  410},
  { 597,  412,  492},
  { 410,  604,  598},
  { 493,  411,  495},
  { 452,  597,  500},
  { 493,  495,  498},
  { 498,  602,  493},
  { 501,  416,  553},
  { 454,  452,  500},
  { 499,  553,  416},
  { 416,  497,  499},
  { 454,  500, 6461},
  { 606,  455,  374},
  { 501,  553,  419},
  { 250,  648,  415},
  { 456,  421,  649},
  { 458,  609,  502},
  { 422,  557,  374},
  { 421,  556,  460},
  { 559,  221,  504},
  { 221,  559,  378},
  { 560,  559,  460},
  { 378,  559,  427},
  { 463,  561,  507},
  { 427,  559,  466},
  { 466,  559,  505},
  { 466,  467,  508},
  { 469,  430,  468},
  { 512,  509,  430},
  { 510,  469,  432},
  { 509,  512,  511},
  { 510,  470,  564},
  { 565,  471,  383},
  { 569,  471,  565},
  { 470,  433,  564},
  { 471,  569,  336},
  { 571,  336,  569},
  { 515,  513,  516},
  { 513,  514,  516},
  { 622,  336,  571},
  { 625,  433,  339},
  { 576,  625,  339},
  { 472,  473,  518},
  { 474,  574,  434},
  { 577,  475,  578},
  { 475,  476,  578},
  { 434,  574,  520},
  { 521,  517,  522},
  { 523,  578,  477},
  { 388,  520,  479},
  { 524,  479,  520},
  { 521,  522,  480},
  { 523,  436,  525},
  { 581,  521,  526},
  { 527,  480,  522},
  { 481,  525,  438},
  { 481,  439,  482},
  { 480,  527,  526},
  { 529,  522,  534},
  { 482,  528,  481},
  { 532,  533,  531},
  { 532,  531,  533},
  { 535,  536,  630},
  { 441,  540,  443},
  { 485,  444,  545},
  { 483,  487,  591},
  { 483,  591,  542},
  { 542,  589,  445},
  { 592,  445,  589},
  { 401,  543,  440},
  { 484,  485,  544},
  { 485,  545,  544},
  { 545,  444,  546},
  { 445,  592,  446},
  { 546,  544,  545},
  { 546,  444,  547},
  { 544,  546,  547},
  { 318,  708,  709},
  { 486,  852,  361},
  { 850,  490,  549},
  { 490,  491,  549},
  { 491,  595,  549},
  { 450,  550,  595},
  { 449,  594,  597},
  { 321,  852,  413},
  { 494,  493,  602},
  { 494,  602,  608},
  { 453,  551,  495},
  { 604,  496,  552},
  { 602,  498,  608},
  { 551,  498,  495},
  { 552,  496,  371},
  { 499,  497,  553},
  { 498,  554,  608},
  { 500, 1010, 6461},
  { 498,  647,  554},
  { 555,  648,  456},
  { 374,  557,  650},
  { 374,  650,  606},
  { 456,  649,  555},
  { 421,  652,  649},
  { 556,  421,  502},
  { 503,  460,  556},
  { 420,  504, 6425},
  { 460,  652,  421},
  { 558,  559,  560},
  { 559,  558,  505},
  { 561,  612,  723},
  { 505,  558,  610},
  { 505,  610,  467},
  { 507,  561,  563},
  { 508,  467,  612},
  { 467,  610,  612},
  { 611,  426,  429},
  { 562,  465,  464},
  { 507,  563,  383},
  { 566,  509,  511},
  { 567,  430,  469},
  { 660,  383,  563},
  { 512,  430,  567},
  { 567,  469,  510},
  { 383,  660,  565},
  { 514,  755,  617},
  { 514,  617,  621},
  { 618,  566,  511},
  { 511,  512,  618},
  { 567,  618,  512},
  { 564,  433,  616},
  { 618,  567,  568},
  { 567,  619,  568},
  { 574,  622,  623},
  { 572,  575,  573},
  { 575,  572,  624},
  { 576,  664,  625},
  { 664,  576,  519},
  { 517,  472,  522},
  { 518,  522,  472},
  { 477,  578,  476},
  { 519,  390,  664},
  { 390,  478,  664},
  { 665,  664,  478},
  { 478, 6410,  665},
  { 520,  579,  524},
  { 524,  579,  733},
  { 527,  522,  582},
  { 522,  577,  534},
  { 578,  523,  534},
  { 479,  524,  666},
  { 523,  525,  534},
  { 525,  481,  584},
  { 525,  584, 5909},
  { 582,  581,  526},
  { 526,  527,  582},
  { 582,  522,  530},
  { 529,  530,  522},
  { 533,  534,  525},
  { 525, 5909,  533},
  { 628,  584,  481},
  { 479,  666,  528},
  { 586,  528,  666},
  { 582,  530,  626},
  { 583,  626,  530},
  { 530,  529,  583},
  { 481,  528,  628},
  { 585,  628,  528},
  { 586,  585,  528},
  { 667,  529,  534},
  { 584,  533, 5909},
  { 628,  585,  698},
  { 585,  586,  698},
  { 630,  536,  587},
  {6309,  631, 6308},
  { 535,  630, 5828},
  { 535, 5828,  536},
  { 540,  441,  670},
  { 589,  542,  588},
  { 486,  541,  642},
  { 543, 5822,  643},
  { 318,  488,  708},
  { 486,  803,  852},
  { 486,  642,  803},
  {5822,  593,  643},
  { 548,  709,  550},
  { 550,  709,  596},
  { 597,  600,  500},
  { 600, 5910,  601},
  {6181,  601, 5910},
  { 852,  712,  497},
  { 601,  500,  600},
  { 646,  604,  552},
  { 605,  497,  712},
  { 646,  552,  371},
  { 553,  497,  605},
  { 453,  455,  551},
  { 551,  455,  606},
  { 551,  606,  498},
  { 553,  605,  645},
  { 606,  647,  498},
  {5912, 5911,  607},
  {1010,  457, 6462},
  {5911, 5912,  607},
  { 553,  715,  419},
  { 502,  609,  556},
  { 647,  606,  650},
  { 717,  503,  556},
  { 331,  459,  862},
  { 652,  460,  559},
  { 655,  650,  557},
  { 331,  655,  557},
  { 459,  423,  862},
  { 717,  460,  503},
  { 560,  720,  558},
  { 461,  562,  464},
  { 658,  462,  506},
  { 613,  611,  429},
  { 429,  509,  613},
  { 755,  659,  617},
  { 687,  617,  659},
  { 510,  564,  615},
  { 564,  616,  615},
  { 514,  825,  755},
  { 565,  575,  569},
  { 570,  726,  515},
  { 570,  572,  726},
  { 513,  825,  514},
  { 618,  568,  620},
  { 568,  619,  620},
  { 567,  620,  619},
  { 575,  571,  569},
  { 572,  570,  872},
  { 621,  570,  515},
  { 515,  516,  621},
  { 516,  514,  621},
  { 433,  625,  616},
  { 663,  622,  571},
  { 571,  575,  663},
  { 572,  872,  624},
  { 520,  574,  623},
  { 577,  522,  518},
  {6410,  580,  665},
  {6298,  521,  581},
  {6410,  581,  580},
  { 577,  578,  534},
  { 666,  524,  733},
  { 582,  626,  581},
  { 667,  694,  529},
  { 627,  534,  533},
  { 667,  627,  697},
  { 534,  627,  667},
  { 629, 6450,  632},
  { 629, 6452, 6450},
  { 630,  587,  636},
  { 630,  699, 5828},
  {6308,  631,  633},
  { 634,  630,  635},
  { 636,  842,  630},
  { 587,  536,  636},
  {6100, 6286,  701},
  { 634,  668, 5832},
  { 536,  842,  636},
  {5829,  842,  536},
  { 637, 5831,  668},
  { 589,  588,  638},
  { 638,  639,  589},
  { 542,  591,  588},
  { 638,  588,  591},
  { 592,  589,  639},
  { 639,  640,  592},
  { 669,  590,  637},
  { 642,  541,  540},
  { 591,  641,  638},
  { 592,  640,  704},
  { 591,  446,  641},
  { 448,  850,  593},
  { 672,  549,  595},
  { 549,  672,  850},
  { 710,  672,  595},
  { 709,  644,  596},
  { 550,  596,  947},
  { 596,  644,  947},
  { 646,  598,  604},
  { 675,  500,  601},
  { 601, 5914,  675},
  { 645,  605,  712},
  { 676,  500,  713},
  { 500,  676, 1010},
  { 553,  645,  715},
  { 458,  677,  609},
  { 647,  650,  679},
  { 457,  678,  458},
  { 419,  715,  420},
  { 651,  679,  650},
  { 609,  717,  556},
  { 650,  654,  651},
  { 655,  654,  650},
  { 652,  559,  653},
  { 654,  655,  681},
  { 717,  720,  460},
  { 462,  657,  682},
  { 462,  682,  423},
  { 504,  656,  559},
  { 683,  559,  656},
  { 718,  559,  683},
  { 720,  560,  460},
  { 462,  721,  657},
  { 720,  610,  558},
  { 462,  658,  721},
  { 562,  461,  614},
  { 660,  563,  561},
  { 561,  725,  660},
  { 561,  723,  725},
  { 509,  566,  613},
  { 566,  618,  613},
  { 613,  618,  620},
  { 510,  615,  567},
  { 615,  616,  686},
  { 616,  661,  686},
  { 660,  575,  565},
  { 573,  727,  572},
  { 726,  572,  727},
  { 825,  515,  726},
  { 515,  825,  513},
  { 575,  727,  573},
  { 661,  662,  728},
  { 621,  617,  689},
  { 616,  662,  661},
  { 622,  663,  623},
  { 575,  624,  663},
  { 662,  616,  625},
  { 623,  663,  520},
  { 665,  580,  690},
  { 580,  771,  690},
  { 580,  581,  771},
  { 694,  583,  529},
  { 694,  693,  583},
  { 627,  533,  695},
  { 627,  695,  732},
  { 693,  626,  583},
  { 694,  667,  697},
  { 584,  695,  533},
  { 628,  695,  584},
  { 666,  695,  628},
  { 666,  628,  698},
  {6450, 5913, 6451},
  { 631, 5829,  699},
  { 631, 6307,  633},
  { 635,  630,  842},
  { 634,  635,  668},
  { 635,  842,  668},
  {5829,  701,  842},
  { 440,  543,  984},
  { 638,  703,  639},
  { 639,  703,  640},
  { 640,  703,  704},
  { 671,  705,  638},
  { 638,  641,  671},
  { 590,  669,  670},
  { 641,  446,  671},
  { 592,  704,  741},
  { 799,  592,  741},
  { 802,  543,  643},
  { 643,  707,  802},
  { 488,  808,  708},
  { 707,  643,  593},
  { 488,  711,  808},
  { 947,  710,  550},
  {1053,  711,  598},
  { 597,  673,  600},
  { 600,  673,  599},
  { 673,  675,  599},
  { 599,  675,  674},
  { 500,  675,  713},
  { 494,  608,  371},
  { 603,  415,  954},
  { 749,  954,  415},
  { 415,  648,  749},
  { 677,  458,  678},
  { 648,  555,  749},
  { 678,  457, 1010},
  { 717,  609,  677},
  { 647,  679,  554},
  { 555,  649,  749},
  { 649,  652,  653},
  { 651,  654,  680},
  { 651,  680,  679},
  { 608,  554,  679},
  { 818,  420,  716},
  { 420,  818,  504},
  { 653,  718,  649},
  { 654,  681,  680},
  { 718,  653,  559},
  { 752,  681,  655},
  { 504,  818,  822},
  { 504,  822,  656},
  { 720,  612,  610},
  { 611,  613,  722},
  { 426,  611,  722},
  { 612,  826,  723},
  { 868,  461,  426},
  { 685,  614,  868},
  { 614,  685,  658},
  { 658,  684,  721},
  { 684,  658,  685},
  { 659,  759,  687},
  { 686,  567,  615},
  { 660,  725,  575},
  { 686,  661, 1076},
  { 575,  725,  727},
  { 688,  728,  662},
  { 728,  688,  765},
  { 663,  624,  872},
  { 872,  570,  873},
  { 570,  621,  873},
  { 689,  873,  621},
  { 662,  769,  688},
  { 663,  729,  520},
  { 664,  665,  625},
  { 625,  665,  690},
  { 768,  693,  691},
  { 691,  692,  768},
  { 520,  775,  579},
  { 775,  733,  579},
  { 694,  692,  691},
  { 626,  771,  581},
  { 694,  691,  693},
  { 666,  774,  695},
  { 834,  627,  732},
  { 666,  733,  696},
  { 627,  834,  697},
  {5913, 6450, 6452},
  { 699,  630,  634},
  { 701, 6286,  700},
  { 634, 5833,  984},
  { 668,  842,  637},
  { 702,  637,  842},
  { 638,  705,  703},
  { 637,  702,  669},
  { 543,  802,  984},
  { 702,  670,  669},
  { 671,  798,  705},
  { 706,  592, 6328},
  { 744,  594,  706},
  { 592,  743, 6328},
  {5827,  897, 5826},
  { 850,  707,  593},
  { 595,  550,  710},
  { 806,  850,  672},
  { 945,  594,  744},
  { 597,  594,  945},
  { 748,  713,  675},
  { 713,  714,  676},
  { 608,  908,  371},
  { 676,  714, 1010},
  { 716,  420,  715},
  { 749,  649,  750},
  { 750,  649,  718},
  { 680,  681,  679},
  { 753,  679,  681},
  { 423,  682,  819},
  { 717,  859,  720},
  { 752,  719,  681},
  { 752,  655, 6175},
  { 655,  331, 6175},
  { 682,  657,  819},
  { 656, 5915,  683},
  { 656,  822,  820},
  { 826,  612,  720},
  { 826,  720,  823},
  { 659,  755,  757},
  { 722,  868,  426},
  { 461,  868,  614},
  { 721,  684,  724},
  { 685,  868,  684},
  { 724,  684,  868},
  { 760,  687,  759},
  { 760,  759,  761},
  {1076,  567,  686},
  { 727,  827,  726},
  { 760,  617,  687},
  { 620,  762,  613},
  { 728, 1076,  661},
  { 617,  760,  763},
  { 620,  567,  762},
  {1076,  728,  916},
  { 663,  872,  764},
  { 689,  617,  763},
  { 663,  764,  729},
  { 729,  766,  520},
  { 692,  730,  768},
  { 771,  625,  690},
  { 770,  831,  625},
  { 880,  625,  831},
  { 625,  880,  662},
  { 772,  662,  880},
  { 662,  772,  769},
  { 833,  768,  730},
  { 692,  694,  730},
  { 730,  694,  833},
  { 731,  695,  773},
  { 774,  773,  695},
  { 770,  771,  626},
  { 693,  770,  626},
  { 694,  697,  833},
  { 732,  695,  731},
  { 666,  696,  774},
  { 696,  733,  734},
  { 734,  733, 5918},
  { 699,  735,  631},
  { 887,  631,  735},
  { 631,  887, 6307},
  { 700,  736, 5920},
  { 740,  738,  737},
  { 738,  740,  739},
  { 702,  842,  797},
  { 703,  848,  704},
  { 702,  797,  670},
  { 848,  703,  705},
  { 704,  848,  741},
  { 670,  797,  540},
  { 741,  742,  799},
  { 671, 5826,  798},
  { 706, 6328,  744},
  { 850,  900,  707},
  { 708,  805,  709},
  { 808,  805,  708},
  { 709,  805,  807},
  { 644,  709,  807},
  { 672,  710,  947},
  { 748,  675,  673},
  { 814,  598,  646},
  { 954,  946,  603},
  { 673,  815,  748},
  { 815,  713,  748},
  { 714,  713,  856},
  { 857,  714,  856},
  { 646,  371,  908},
  { 816,  714,  857},
  { 714,  816, 1010},
  { 715,  645,  858},
  { 715,  858,  716},
  { 678,  717,  677},
  { 717,  678, 1010},
  { 717,  817,  859},
  { 608,  679, 6144},
  { 750,  718,  683},
  { 681,  719,  753},
  { 753, 6144,  679},
  { 719,  752,  753},
  { 818,  864,  822},
  { 656,  820,  751},
  { 656,  751, 5915},
  { 756,  755,  754},
  {6166, 5917, 6167},
  { 757,  755,  756},
  { 757,  824,  659},
  { 721,  724,  913},
  { 722,  613,  869},
  { 723,  758,  725},
  { 659,  824,  759},
  { 726,  827,  825},
  { 725,  826,  727},
  { 727,  826,  827},
  { 764,  872,  874},
  { 729,  764,  766},
  { 873,  689,  763},
  { 688,  767,  765},
  { 688,  769,  767},
  { 766,  876,  520},
  { 876,  775,  520},
  { 625,  771,  770},
  { 832,  773,  774},
  { 770,  693,  831},
  { 693,  922,  880},
  { 734,  774,  696},
  { 697,  834,  833},
  { 732,  731,  834},
  { 776,  733,  775},
  { 733,  776, 5918},
  {5918,  776, 5919},
  { 835,  781,  780},
  { 780,  781,  782},
  { 782,  781,  837},
  { 781,  932,  837},
  { 782,  837,  785},
  { 837,  786,  787},
  { 837,  787,  785},
  { 786,  837,  788},
  { 837,  735,  788},
  { 788,  735,  933},
  { 788,  933,  786},
  {6306, 6307,  887},
  {6306,  887,  790},
  { 789,  791,  792},
  { 735,  699,  933},
  { 735,  837,  887},
  { 791,  789,  792},
  {5920,  701,  700},
  { 738,  793,  737},
  {5916,  739,  793},
  { 740,  737,  794},
  { 740,  794,  843},
  { 795,  796,  742},
  { 741,  848,  742},
  { 540,  797,  642},
  { 798, 1098,  705},
  { 742,  796,  799},
  { 642,  797,  803},
  { 897,  801,  800},
  { 800,  798,  897},
  {5826,  897,  798},
  { 743,  592,  799},
  { 804,  802,  707},
  { 743,  799, 6327},
  { 744, 6328,  745},
  { 707,  900,  804},
  { 805,  808,  807},
  { 852,  803,  997},
  { 901,  644,  807},
  { 744,  745,  945},
  { 746, 6177,  809},
  { 806,  747, 1001},
  { 711, 1053,  808},
  { 809, 6177,  811},
  { 806,  672,  747},
  { 644,  901,  853},
  { 644,  853,  947},
  { 672,  947,  813},
  { 813,  747,  672},
  {1053,  598,  814},
  { 712,  944,  645},
  { 713,  815,  856},
  { 957,  645,  952},
  { 858,  645,  957},
  { 608, 1009,  908},
  { 858,  818,  716},
  { 750, 5915,  751},
  { 423,  819,  862},
  { 750,  751,  820},
  { 821,  754,  755},
  {6175,  331, 6145},
  { 862, 6145,  331},
  { 821,  755,  825},
  { 757,  756,  824},
  { 722,  869,  868},
  { 723,  826,  758},
  { 824,  915,  759},
  { 758,  826,  725},
  { 828,  761,  915},
  { 761,  759,  915},
  { 917,  761,  828},
  { 613,  871,  869},
  { 761,  763,  760},
  { 871,  613,  762},
  { 761,  917,  763},
  { 567,  969,  762},
  { 567, 1076,  969},
  { 873,  763,  967},
  { 765,  767,  769},
  { 764,  876,  766},
  { 764,  874,  876},
  { 829, 1078,  768},
  { 768,  830,  829},
  { 876,  877,  775},
  { 833,  830,  768},
  { 773,  832,  878},
  { 772,  880,  922},
  { 768, 1027,  693},
  { 921,  773,  878},
  { 831,  693,  880},
  { 774,  734,  974},
  { 734,  776,  974},
  { 734,  777,  776},
  { 776,  881,  974},
  { 776,  775,  881},
  { 778,  779,  780},
  { 778,  780,  779},
  { 784, 6228,  836},
  { 784,  836, 6228},
  {1202,  782,  785},
  { 785,  787, 1202},
  { 783,  836, 6168},
  { 787,  786, 1202},
  { 888,  783, 6168},
  { 933, 1202,  786},
  {6168,  792,  888},
  { 890,  792, 6168},
  { 699,  634,  984},
  { 699,  984,  933},
  { 839,  840,  838},
  { 838, 5922,  793},
  { 737,  793, 5922},
  { 740,  841,  739},
  { 739,  841,  793},
  { 740,  843,  841},
  {6236,  795,  844},
  { 802, 1091,  984},
  { 796, 5923,  799},
  { 800,  801,  846},
  { 846, 1098,  800},
  { 798,  800, 1098},
  { 897,  847,  801},
  { 802,  804,  849},
  {6328, 1158,  745},
  { 850,  806,  851},
  { 900,  850,  851},
  {6328,  809, 1158},
  {6327, 6398,  810},
  { 806, 1001, 1218},
  { 809,  811, 5924},
  { 897,  946,  999},
  { 854,  947,  853},
  { 747,  812, 1001},
  {1102, 1001,  812},
  {1105,  597,  945},
  {1054,  854,  853},
  {1053,  814, 1002},
  {1105,  673,  597},
  { 812,  747,  903},
  {1006,  673, 1105},
  { 673, 1006,  815},
  { 747,  907,  906},
  { 747,  906,  903},
  { 855,  815, 1006},
  { 747,  813,  907},
  { 856,  815,  855},
  { 856,  855,  950},
  { 814,  646,  908},
  { 954,  749,  909},
  {1010,  817,  717},
  {1010,  859,  817},
  { 749,  750,  820},
  { 749,  820,  822},
  { 749,  822,  860},
  { 859,  910,  821},
  {6145,  862, 1012},
  { 859,  823,  720},
  { 859,  821,  825},
  { 657,  721, 1068},
  { 823,  859,  865},
  { 867,  865,  859},
  { 823,  865,  867},
  { 859,  825,  867},
  { 754,  912,  824},
  { 754,  824,  756},
  { 866,  826,  823},
  { 823,  867,  866},
  { 827,  866,  867},
  { 825,  827,  867},
  { 724,  868,  961},
  { 913,  724,  961},
  { 826,  866,  827},
  { 869,  870,  914},
  { 869,  871,  870},
  { 917,  875,  763},
  { 871,  762,  968},
  { 875,  967,  763},
  { 876,  918,  877},
  { 769,  772,  765},
  { 972,  765,  772},
  { 919, 1078,  829},
  { 830,  919,  829},
  { 775,  877,  970},
  { 772,  922,  972},
  { 774, 1025,  832},
  { 833, 1079,  830},
  { 879,  775, 1026},
  { 775,  879,  881},
  { 924,  881,  879},
  { 922,  693,  923},
  { 922,  923,  972},
  { 693, 1027,  923},
  { 921,  928,  773},
  { 925,  881,  924},
  { 834, 1079,  833},
  { 731,  773,  834},
  { 773,  882,  834},
  { 773,  928,  883},
  { 773,  883,  882},
  { 834,  882,  927},
  { 780, 6303,  835},
  { 835, 6303,  932},
  { 835,  932,  781},
  {1084, 6303,  780},
  { 884,  886,  885},
  { 884,  885,  888},
  { 780,  782, 1084},
  { 783,  888,  836},
  { 886,  836,  885},
  { 836,  888,  885},
  {1202, 1084,  782},
  { 836,  886, 6168},
  { 837,  932,  887},
  { 980,  887,  932},
  {6168,  889,  890},
  { 792,  890,  888},
  { 890, 5921,  839},
  { 701, 5920, 1137},
  { 839,  838,  983},
  { 838,  793,  983},
  { 891,  737, 5921},
  {1207,  842,  701},
  { 894,  737,  891},
  { 843,  793,  841},
  { 737,  894,  893},
  { 892,  843,  794},
  { 737,  893,  794},
  { 842, 1207,  797},
  { 893,  892,  794},
  { 992,  844,  795},
  { 845,  844,  992},
  { 892,  893,  894},
  {5923, 5926,  799},
  { 742,  896,  795},
  { 795,  896,  992},
  { 847,  895,  801},
  { 801,  895,  941},
  { 801,  941,  846},
  { 848,  896,  742},
  { 705, 1098,  848},
  { 799, 1048, 6327},
  {1050,  849,  804},
  { 898,  942, 6327},
  { 851,  806,  899},
  {1050,  851,  899},
  { 851, 1050,  900},
  {1050,  804,  900},
  { 942, 6398, 6327},
  { 807,  808,  901},
  {6398,  942,  943},
  { 901,  808,  998},
  { 808, 1053,  998},
  { 852,  997,  944},
  { 852,  944,  712},
  { 854, 1054,  902},
  { 813,  947,  904},
  { 948,  904,  947},
  { 905,  645,  944},
  { 952,  645,  905},
  { 855, 1006,  950},
  { 904,  953,  907},
  { 907,  813,  904},
  { 856,  950,  956},
  { 908, 1008,  814},
  { 857,  955,  816},
  { 858,  957,  958},
  { 818,  858,  958},
  { 909,  749,  864},
  { 608,  960, 1009},
  { 864,  749,  860},
  {6144,  863,  608},
  { 960,  608,  863},
  { 818,  909,  864},
  { 822,  864,  860},
  { 910,  911,  821},
  { 754,  821,  911},
  {6146, 6147,  861},
  {6145, 1012,  960},
  { 819, 1013,  862},
  { 721,  913, 1068},
  { 868,  869, 6423},
  { 869,  914, 6423},
  { 964,  917,  828},
  { 828,  915,  962},
  { 914,  870, 6423},
  { 968, 6464,  966},
  { 870,  871,  968},
  { 762,  969,  968},
  { 874,  872,  876},
  { 918,  876,  872},
  { 967,  872,  873},
  { 919,  830,  920},
  { 877,  918,  970},
  { 878,  832, 1025},
  { 768, 1078, 1027},
  { 928,  921,  926},
  { 925,  924,  976},
  { 881,  925,  974},
  { 976,  974,  925},
  { 929,  930, 6085},
  { 884,  930,  886},
  { 931,  981,  887},
  { 790,  887,  981},
  { 887,  980,  931},
  { 888, 1036, 1037},
  { 888,  890, 1036},
  {1039,  890,  889},
  { 890, 1039, 5921},
  {5921, 1039,  934},
  { 983,  793, 1138},
  {1137, 1207,  701},
  {5921,  934,  891},
  { 894,  891,  934},
  { 935,  936,  939},
  { 892,  793,  843},
  { 793,  892,  937},
  { 935,  939,  938},
  { 892,  894,  937},
  {1091,  802, 1092},
  { 797, 1043,  803},
  { 992,  896,  991},
  { 802,  849, 1092},
  { 846,  941, 1098},
  { 895,  847, 1155},
  {1155,  847,  897},
  { 848, 1098,  896},
  { 995,  896, 1098},
  { 996,  899,  806},
  {1216,  899,  996},
  {1050,  899, 1216},
  { 901,  998, 1053},
  { 901, 1053,  853},
  {5925,  809, 5924},
  { 853, 1053, 1054},
  { 947,  854,  902},
  {1053, 1002, 1056},
  { 902, 1060,  947},
  { 946,  954, 1057},
  { 905,  944, 1004},
  { 903,  906,  949},
  {1102,  812,  903},
  { 952,  905, 1004},
  { 906,  953,  949},
  { 904,  948,  951},
  { 907,  953,  906},
  { 957,  952, 1057},
  { 857,  856,  956},
  { 857,  956,  955},
  {1062,  956,  950},
  {1006, 1062,  950},
  { 816,  955, 1066},
  { 957,  954,  958},
  { 909,  958,  954},
  { 958,  909,  818},
  { 859,  911,  910},
  { 819, 1110, 1013},
  { 859, 1014,  911},
  { 960, 1012,  959},
  {1012, 1067,  959},
  {1014,  754,  911},
  {1014,  912,  754},
  {1068,  913, 1015},
  { 912, 1114,  824},
  { 828,  962, 1019},
  { 824,  962,  915},
  {6423,  870,  963},
  { 917,  965,  875},
  { 870,  968,  963},
  { 971,  875,  965},
  {6464,  968,  966},
  { 872,  967,  970},
  { 872,  970,  918},
  { 967,  875, 1022},
  { 969, 1024,  968},
  { 969, 1076, 1024},
  { 920,  830, 1021},
  { 875,  971, 1077},
  { 878, 1025, 1122},
  { 975,  921,  878},
  { 878, 1122,  975},
  { 972,  923,  973},
  { 923, 1027,  973},
  { 921,  975,  926},
  {1079,  834,  927},
  {1079,  927,  882},
  { 882,  883, 1079},
  {1079,  883,  928},
  { 926,  975,  928},
  { 930,  884,  888},
  { 930,  888, 6356},
  {6303, 1083, 1130},
  {6303, 1130,  932},
  { 930, 1039,  886},
  { 981,  931,  979},
  {1130,  980,  932},
  { 886, 1039, 6168},
  { 982, 5920, 6199},
  {1039,  889, 6168},
  { 890,  839, 1036},
  { 984, 1202,  933},
  { 839,  983, 1036},
  { 935, 1208,  936},
  {1145,  939,  936},
  { 989,  793,  937},
  { 938,  939,  988},
  {1044,  988,  939},
  { 937,  894,  989},
  { 894, 1142,  994},
  {5926,  993,  799},
  { 799,  993, 1048},
  { 941,  895, 1047},
  { 941, 1047, 1098},
  {1092,  849, 1049},
  { 940,  895, 1155},
  { 896,  995,  991},
  {1048,  898, 6327},
  { 849, 1050, 1097},
  { 806, 1218,  996},
  {1052,  945,  745},
  { 945, 1058, 1105},
  { 902, 1054, 1060},
  { 947, 1060,  948},
  { 949, 1003,  903},
  { 903, 1003, 1102},
  {1002,  814, 1061},
  { 949, 1005, 1003},
  { 948, 1060,  951},
  { 814, 1008, 1061},
  {1062, 1006, 1105},
  { 949, 1064, 1005},
  { 949,  953, 1064},
  { 953,  904, 1064},
  {1007,  956, 1062},
  {1057,  954,  957},
  { 816, 5927, 1171},
  { 816, 1171, 1010},
  {1009,  960,  959},
  { 959, 1067, 1009},
  {1010, 1014,  859},
  { 862, 1011, 1012},
  {1011,  862, 1069},
  { 862, 1013, 1069},
  {1014, 1176,  912},
  {1016, 1070,  913},
  {1015,  913, 1070},
  { 961, 1016,  913},
  { 912, 1071, 1114},
  {6455,  828, 6424},
  {1285,  964, 1072},
  {1185,  828, 1019},
  {1017,  962,  824},
  { 916, 1074, 1018},
  { 964, 1285,  917},
  {1017, 1019,  962},
  { 916,  728, 1074},
  { 968, 1020,  963},
  { 965, 1285, 1119},
  {1022,  875, 1077},
  { 920, 1021, 1191},
  { 967, 1022, 1026},
  { 967, 1026,  970},
  {1077,  971, 1023},
  {1078,  919,  920},
  { 830, 1079, 1192},
  { 970, 1026,  775},
  {1026, 1123,  879},
  { 924,  879, 1123},
  {1080,  976,  924},
  { 975, 1122, 1028},
  {1029, 1028, 1122},
  {1080,  974,  976},
  {1079,  928,  975},
  { 975, 1028, 1079},
  {1029, 1079, 1028},
  {1030, 1031,  977},
  {1030, 1032, 1031},
  {1030,  977, 1081},
  {1033, 1081,  977},
  {1031, 1032, 1083},
  {1130, 1034,  980},
  { 980, 1085,  931},
  { 931, 1085,  979},
  {6199, 1086,  982},
  {1087,  982, 1086},
  { 982, 1087, 1035},
  { 982, 1035, 1089},
  {1035, 1205, 1038},
  {1040, 1035, 1038},
  {1035, 1040, 1089},
  {1042, 1040, 1090},
  {1040, 1038, 1041},
  {1040, 1041, 1090},
  {1036,  983, 1342},
  {1138, 1342,  983},
  {1042,  986, 1089},
  {1089, 1040, 1042},
  { 985, 1131, 1089},
  { 985, 1089,  986},
  { 987, 1131,  985},
  {1142,  934, 1136},
  { 934, 1142,  894},
  { 987, 1145,  936},
  { 793,  989, 1138},
  {1208,  935,  938},
  {1043,  797, 1207},
  { 988, 1044, 1210},
  {1045,  994, 1142},
  { 990,  940, 1044},
  { 993,  992,  991},
  { 994,  989,  894},
  { 991, 1048,  993},
  { 994, 1045, 1093},
  {1043, 1046,  803},
  {1213,  895,  940},
  { 895, 1213, 1047},
  {1047, 1213, 1098},
  { 803, 1046, 1152},
  {1048, 1094,  898},
  {1097, 1049,  849},
  { 898, 1094, 1095},
  { 898, 1095, 1096},
  { 803, 1152, 1154},
  { 803, 1154,  997},
  { 897, 1101, 1155},
  {1050, 1099, 1097},
  {1101,  897,  999},
  {6433,  898, 6432},
  { 996, 1218, 1051},
  { 997, 1154,  944},
  { 745, 1158, 1052},
  {1058,  945, 1052},
  { 809, 5925, 1219},
  {5925, 1000, 1219},
  {1053, 1056, 1224},
  { 944, 1160, 1103},
  { 999,  946, 1157},
  {1161, 1055, 1000},
  {1057,  944, 1103},
  { 944, 1057, 1004},
  {1060, 1054, 1224},
  {1061, 1056, 1002},
  {1003, 1005, 1064},
  {1003, 1064, 1059},
  {1063,  904,  951},
  {1063,  951, 1363},
  {1004, 1057,  952},
  {1064,  904, 1063},
  {1061, 1008, 1163},
  {1062, 1105, 1007},
  { 956, 1065,  955},
  { 956, 1007, 1065},
  {1007, 1164, 1065},
  { 908, 1271, 1008},
  {1111, 1010, 1171},
  {1235, 1009, 1067},
  {1175, 1110,  819},
  { 819,  657, 1175},
  {1176, 1010, 1111},
  {1014, 1010, 1176},
  {1067, 1012, 1112},
  {1069, 1012, 1011},
  {1113, 1012, 1069},
  {1015, 1070, 1068},
  {1176, 1071,  912},
  {1016,  961, 1070},
  {6422, 1238,  868},
  {1073,  824, 1114},
  { 824, 1073, 1017},
  {6423,  963, 1187},
  { 916, 1018, 1116},
  {1019, 1073, 1185},
  {1019, 1017, 1073},
  {1020, 1118,  963},
  { 917, 1285,  965},
  {1024, 1020,  968},
  {1075, 1020, 1024},
  {1020, 1075, 1118},
  {1074,  728,  765},
  { 965, 1119,  971},
  {1024, 1076, 1075},
  {1021,  830, 1192},
  {1022, 1077, 1026},
  {1074,  765,  972},
  { 920, 1191, 1078},
  {1025,  774, 1121},
  {1025, 5929, 1122},
  {1026, 1077, 1123},
  { 972, 1027, 1074},
  {1074, 1027, 1078},
  { 972,  973, 1027},
  { 924, 1245, 1080},
  {1029, 1122, 1125},
  {1029, 1125, 1126},
  {1029, 1126, 1079},
  {1030, 1081, 1128},
  {1083, 1032, 1129},
  {1033,  977, 1084},
  {1084,  977, 1082},
  {1033, 1084, 1081},
  {6269, 1081, 1084},
  {1037, 6267,  888},
  { 979, 1086, 6199},
  {1086, 1203, 1087},
  {1039, 1084, 1135},
  {1085, 1034, 1258},
  {1034, 1085,  980},
  {1087, 1088, 1035},
  {1034, 1130, 1258},
  {1088, 1205, 1035},
  {1037, 1204, 1256},
  {1038, 1205, 1041},
  {1090, 1041, 1205},
  {1036, 1342, 1132},
  {5920,  982, 1137},
  { 984, 1133, 1202},
  {1090, 1134, 1042},
  {6264, 1042, 1134},
  {1136,  934, 1135},
  { 987,  936, 1131},
  {1131,  936, 1208},
  {6264,  985,  986},
  { 986, 1042, 6264},
  {1207, 1146, 1043},
  {1209, 1208,  938},
  { 988, 1210,  938},
  { 938, 1144, 1209},
  { 938, 1210, 1144},
  {1043, 1146, 1046},
  { 939, 1145, 1044},
  { 989, 1148, 1138},
  {1044, 1145,  990},
  {1142, 1093, 1045},
  {1091, 1092, 1142},
  { 989,  994, 1148},
  { 940, 1210, 1044},
  { 994, 1093, 1148},
  { 991,  995, 1048},
  {1151, 1048,  995},
  {1048, 1151, 1094},
  {1151, 1096, 1095},
  {1050, 1216, 1153},
  {1050, 1153, 1099},
  {1096, 1100,  898},
  {1051, 1216,  996},
  {1156, 1216, 1051},
  { 999, 1157, 1101},
  { 898, 1100, 6432},
  {1051, 1218, 1156},
  {1100, 1000, 6432},
  {1001, 1102, 1218},
  { 944, 1154, 1217},
  {1158,  809, 1219},
  {1053, 1224, 1054},
  {1159,  944, 1217},
  {1160,  944, 1159},
  {1000, 1055, 1219},
  {1055, 1161, 1104},
  {1103,  946, 1057},
  {1103, 1157,  946},
  {1059, 1162, 1003},
  { 951, 1060, 1363},
  {1059, 1064, 1162},
  {1106, 1064, 1063},
  {1061, 1163, 1056},
  {1007, 1105, 1164},
  {1064, 1106, 1162},
  {1106, 1227, 1162},
  { 955, 1167, 1066},
  { 955, 1065, 6123},
  {1106, 1108, 1107},
  {1106, 1107, 1227},
  {1106, 1165, 1108},
  {1065, 1164, 5928},
  {1009, 1166,  908},
  { 908, 1166, 1271},
  {1108, 1109, 1107},
  {1171, 1275, 1111},
  {1009, 1235, 1174},
  {1172, 1113, 1069},
  {1172, 1069, 1013},
  {1013, 1110, 1172},
  { 657, 1068, 1175},
  {1235, 1067, 1112},
  {1113, 1112, 1012},
  {1070, 1179, 1068},
  {1114, 1115, 1073},
  {1116, 1076,  916},
  {1018, 1074, 1116},
  {1074, 1117, 1116},
  {6423, 1187, 1186},
  {1117, 1074, 1240},
  {1075, 1243, 1118},
  {1119, 1023,  971},
  {1021, 1192, 1188},
  {1021, 1188, 1191},
  {1120, 1121, 1444},
  { 774, 1444, 1121},
  {1245, 1077, 1023},
  {1190, 1245, 1023},
  {1194, 1075, 1076},
  {1080, 1444,  774},
  { 974, 1080,  774},
  {1123, 1245,  924},
  {1245, 1124, 1080},
  {6269, 6272, 1127},
  {1127, 1081, 6269},
  {1128, 1081, 1127},
  {1032, 1030, 1128},
  {1086,  979, 1085},
  {1037, 1256, 6267},
  {1201, 1135, 1084},
  {1085, 1258, 1086},
  {1089, 1131,  982},
  {1037, 1036, 1204},
  {1039, 1135,  934},
  { 982, 1131, 1137},
  { 984, 1091, 1140},
  { 984, 1140, 1133},
  {6265, 6263, 5930},
  { 987,  985, 1145},
  {1143,  985, 6264},
  {1143, 1145,  985},
  {1142, 1140, 1091},
  {1046, 1146, 1147},
  {1148, 1404, 1138},
  {1046, 1147, 1212},
  {1142, 1092, 1093},
  {1093, 1092, 1150},
  {1092, 1049, 1150},
  {1210,  940, 1264},
  {1093, 1149, 1148},
  {1149, 1093, 1150},
  {1150, 1049, 1097},
  { 940, 1155, 1264},
  {1094, 1151, 1095},
  {1150, 1097, 1099},
  {1150, 1099, 1153},
  {1266, 1100, 1096},
  {1000, 1100, 1161},
  {1052, 1221, 1058},
  {1055, 1104, 1219},
  {1103, 1160, 1157},
  {6289, 6288, 1223},
  {1104, 6240, 1219},
  {1104, 1161, 6239},
  {1104, 6239, 6240},
  {1161, 1222, 6239},
  {1058, 1315, 1105},
  {1060, 1224, 1363},
  {1165, 1106, 1063},
  {1105, 1318, 1164},
  {1163, 1008, 1271},
  {1066, 1167, 1171},
  {1168, 1170, 1173},
  {1169, 1173, 1170},
  {1169, 6156, 1173},
  {1173, 6156, 1232},
  {6156, 6279, 1232},
  {1233, 1172, 1230},
  {1172, 1235, 1113},
  {1172, 1233, 1235},
  {1175, 1068, 1274},
  {1177, 1173, 1234},
  {1113, 1235, 1112},
  {1068, 1179, 1178},
  {1180, 1181, 1176},
  {1071, 1176, 1181},
  {1114, 1071, 1181},
  {1181, 1177, 1114},
  {1236, 1114, 1177},
  {1070,  961, 1179},
  {1115, 1114, 1236},
  {1184, 1115, 1236},
  {1279, 1183, 6424},
  {6424,  828, 1279},
  {1279,  828, 1185},
  {1239, 1116, 1117},
  {1072, 5931, 1284},
  {1072, 1284, 1285},
  {1115, 1184, 1237},
  {1115, 1237, 1073},
  {1182, 1186, 1238},
  {1187,  963, 1442},
  {1187, 1442, 1283},
  { 963, 1118, 1442},
  {1242, 1119, 1285},
  {1074, 1286, 1240},
  {1119, 5941, 1023},
  {1074, 1191, 1286},
  {1188, 1192, 1244},
  {1444, 1189, 1120},
  {1191, 1074, 1078},
  {1191, 1188, 1244},
  {1189, 1193, 1120},
  {1192, 1079, 1287},
  {5929, 1120, 1122},
  {1195, 1122, 1120},
  {1120, 1193, 1195},
  {1246, 1245, 1190},
  {1077, 1245, 1123},
  {1122, 1195, 1292},
  {1125, 1122, 1292},
  {1196, 1124, 1249},
  {1124, 1196, 1080},
  {1126, 1125, 1251},
  {1125, 1250, 1251},
  {6269, 6270, 6271},
  {6269, 6271, 6272},
  {1128, 1127, 1252},
  {1198, 1252, 1199},
  {1199, 1252, 1200},
  {1128, 1252, 1253},
  {1128, 1253, 1032},
  {1032, 1253, 6365},
  {1252, 6268, 1296},
  {1083, 1254, 1130},
  {6267, 1255, 1299},
  {1084, 1202, 1201},
  {6267, 1256, 1255},
  {1087, 1203, 1088},
  {1257, 1135, 1201},
  {1203, 1205, 1088},
  {1036, 1132, 1204},
  {1302, 1203, 1086},
  {1203, 1302, 1205},
  {1090, 1205, 1134},
  {1137, 1131, 1208},
  {1135, 1259, 1206},
  {1135, 1206, 1136},
  {1206, 1133, 1140},
  {1139, 6262, 1141},
  {1136, 1206, 1140},
  {1136, 1140, 1142},
  {1207, 1306, 1146},
  {1146, 1306, 1147},
  {1212, 1147, 1306},
  {1145, 1347,  990},
  {1212, 1264, 1046},
  {1212, 1262, 1264},
  {1149, 6250, 1148},
  {1046, 1264, 1214},
  {1046, 1214, 1152},
  { 940,  990, 1213},
  {1149, 1150, 1215},
  {1215, 1150, 1153},
  {1152, 1214, 1154},
  {1264, 1155, 1217},
  {1213, 1265, 1098},
  {1216, 1215, 1153},
  {1216, 1149, 1215},
  {1154, 1214, 1217},
  { 995, 1098, 1357},
  {1356, 1096, 1151},
  {1218, 1310, 1156},
  {1155, 1159, 1217},
  {1155, 1101, 1159},
  {1266, 1161, 1100},
  {1157, 1159, 1101},
  {1220, 1218, 1102},
  {1159, 1157, 1160},
  {1158, 1221, 1052},
  {1221, 1315, 1058},
  {1226, 1219, 6240},
  {6239, 1222, 6240},
  {1003, 1162, 1102},
  {1315, 1225, 1105},
  {1363, 1224, 1361},
  {1225, 1270, 1105},
  {1270, 1318, 1105},
  {1063, 1363, 1165},
  {1227, 1107, 1367},
  {1318, 1229, 1164},
  {1228, 1319, 1168},
  {1272, 1168, 1319},
  {1009, 1231, 1166},
  {1168, 1272, 1170},
  {1169, 1170, 1272},
  {1108, 1165, 1273},
  {1172, 1166, 1231},
  {1171, 1167, 1229},
  {1167, 5928, 1229},
  {1164, 1229, 5928},
  {1173, 1228, 1168},
  {6156, 1169, 1272},
  {1273, 1109, 1108},
  {1171, 1229, 1275},
  {1009, 1233, 1230},
  {1231, 1230, 1172},
  {1228, 1173, 1181},
  {1009, 1174, 1233},
  {1173, 1232, 1234},
  {1111, 1275, 1276},
  {1173, 1177, 1181},
  {1068, 1178, 1274},
  {1178, 1179, 1280},
  { 961, 1280, 1179},
  {1279, 1281, 1183},
  { 868, 1485,  961},
  {1284, 1183, 1281},
  {1073, 1237, 1185},
  {1238, 1283,  868},
  {1238, 1186, 1187},
  {1283, 1238, 1187},
  {1240, 1239, 1117},
  {1442, 1118, 1241},
  {1118, 1243, 1241},
  {1076, 1116, 1489},
  {1119, 1242, 5941},
  {1023, 5941, 1324},
  {1023, 1324, 1190},
  {1243, 1075, 1194},
  {1076, 1326, 1194},
  {1191, 1244, 1286},
  {1244, 1192, 1287},
  {1190, 6369, 1246},
  {1194, 1247, 1243},
  {1194, 1326, 1247},
  {1079, 1248, 1287},
  {1290, 1444, 1080},
  {1292, 1195, 1193},
  {1124, 1245, 1246},
  {1291, 1124, 1246},
  {1250, 1125, 1292},
  {1080, 1196, 1249},
  {1079, 1126, 1251},
  {1295, 6292, 6365},
  {1200, 1252, 1127},
  {1253, 1386, 1295},
  {1253, 1295, 6365},
  {1129, 1197, 1083},
  {1130, 1297, 1258},
  {1256, 1299, 1255},
  {1201, 1202, 1257},
  {1258, 1457, 1086},
  {1132, 1301, 1204},
  {1204, 1340, 1300},
  {1204, 1300, 1256},
  {1257, 1259, 1135},
  {1202, 1133, 1257},
  {1133, 1259, 1257},
  {1132, 1260, 1301},
  {1132, 1342, 1260},
  {1259, 1133, 1206},
  {1205, 1303, 1134},
  {1302, 1303, 1205},
  {1138, 1304, 1342},
  {6264, 1134, 1303},
  {1207, 1137, 1306},
  {1261, 1306, 1137},
  {1305, 1342, 1304},
  {1137, 1209, 1261},
  {1137, 1208, 1209},
  {1303, 1211, 6264},
  {6264, 1211, 1143},
  {1138, 1305, 1304},
  {1209, 1144, 1261},
  {1144, 1210, 1261},
  {1145, 1211, 1347},
  {1145, 1143, 1211},
  {1212, 1306, 1262},
  {1210, 1264, 1306},
  {1263, 1148, 6250},
  { 990, 1350, 1213},
  {1214, 1264, 1217},
  {1265, 1213, 1308},
  {1356,  995, 1357},
  { 995, 1356, 1151},
  {1310, 1267, 1156},
  {1156, 1267, 1216},
  {1149, 1216, 1267},
  {1358, 1161, 1266},
  {1310, 1218, 1407},
  {1161, 1358, 1222},
  {1158, 1219, 1313},
  {1222, 1415, 6240},
  {1220, 1102, 1314},
  {1219, 1268, 1313},
  {1219, 1226, 1268},
  {6240, 1415, 1226},
  {1162, 1360, 1102},
  {1315, 1365, 1225},
  {1420, 1056, 1163},
  {1225, 1365, 1270},
  {1162, 1317, 1360},
  {1269, 1420, 1163},
  {1163, 1271, 1269},
  {1367, 1317, 1162},
  {1162, 1227, 1367},
  {1107, 1109, 1320},
  {1319, 1228, 1181},
  {1109, 1273, 1320},
  {1009, 1230, 1231},
  {1166, 1172, 1423},
  {1181, 1180, 1421},
  {1175, 1274, 1429},
  {1232, 1321, 1234},
  {1235, 1233, 1174},
  {1172, 1110, 1371},
  {1175, 1371, 1110},
  {1274, 1178, 1277},
  {1111, 1276, 1322},
  {1111, 1322, 1176},
  {1176, 1368, 1180},
  {1178, 1278, 1277},
  {1178, 1280, 1278},
  {1234, 1236, 1177},
  {1279, 1282, 1281},
  {1234, 1279, 1185},
  {1237, 1234, 1185},
  {1234, 1237, 1236},
  {1280,  961, 1485},
  {1284, 1281, 1282},
  {1237, 1184, 1236},
  {1239, 1240, 1375},
  {1116, 1239, 1375},
  {1241, 1243, 1376},
  {1287, 1286, 1244},
  {1189, 1379, 1193},
  {1190, 1324, 1325},
  {1190, 1325, 6369},
  {1444, 1290, 1289},
  {1246, 6369, 1289},
  {1246, 1289, 1291},
  {1447, 1248, 1079},
  {1250, 1447, 1079},
  {1080, 1249, 1290},
  {1290, 1249, 1124},
  {1079, 1251, 1250},
  {1293, 1329, 1294},
  {5942, 1294, 1329},
  {1252, 1296, 1253},
  {1386, 1253, 1296},
  {1083, 1197, 1336},
  {1083, 1336, 1506},
  {1083, 1506, 1254},
  {1254, 1506, 1130},
  {1297, 1298, 1258},
  {1302, 1086, 1457},
  {1260, 1342, 1341},
  {1393, 1303, 1302},
  {1303, 1393, 1211},
  {1306, 1261, 1210},
  {1393, 1462, 1211},
  {1138, 1510, 1305},
  {1148, 1263, 1307},
  {1148, 1307, 1404},
  {1262, 1306, 1264},
  {1211, 1345, 1348},
  {1307, 1263, 1404},
  {1138, 1404, 1510},
  {1350,  990, 1347},
  {1263, 6250, 6252},
  {6250, 1149, 1267},
  {1213, 1350, 1308},
  {1310, 6250, 1267},
  {1308, 1350, 1265},
  {1265, 1350, 1352},
  {1265, 1352, 1098},
  {1357, 1098, 1355},
  {1412, 1407, 1218},
  {1218, 1220, 1311},
  {1220, 1314, 1311},
  {1315, 1221, 1359},
  {1221, 1158, 1359},
  {1415, 1470, 1226},
  {1314, 1312, 1311},
  {1360, 1314, 1102},
  {1316, 1361, 1224},
  {1224, 1472, 1316},
  {1224, 1056, 1472},
  {1268, 1226, 1364},
  {1360, 1317, 1362},
  {1366, 1420, 1269},
  {1269, 1271, 1366},
  {1166, 1422, 1271},
  {1318, 1476, 1229},
  {1579, 1273, 1165},
  {1107, 1320, 1367},
  {1166, 1423, 1422},
  {1319, 1181, 1421},
  {1425, 6156, 1272},
  {1427, 6156, 1425},
  {1229, 1368, 1275},
  {1421, 1180, 1368},
  {1275, 1368, 1276},
  {5939, 6399, 1234},
  {5939, 1234, 1321},
  {1274, 1277, 1479},
  {1274, 1479, 1429},
  {1368, 1322, 1276},
  {1322, 1368, 1176},
  {6399, 1279, 1234},
  {1278, 6284, 1277},
  {1282, 1372, 1323},
  {1282, 1279, 1372},
  {1374, 1282, 1323},
  {1374, 1284, 1282},
  {1283, 1442, 1373},
  { 868, 1283, 1485},
  {1326, 1076, 1489},
  {1443, 1240, 1286},
  {1324, 5941, 1377},
  {1243, 1247, 1376},
  {1444, 1490, 1189},
  {6368, 5932, 1288},
  {1287, 1248, 1286},
  {1193, 1379, 1292},
  {1290, 1291, 1289},
  {1291, 1290, 1124},
  {6139, 6137, 1327},
  {6139, 1327, 6138},
  {1250, 1498, 1447},
  {1292, 1449, 6467},
  {1292, 6467, 1250},
  {1328, 1329, 1293},
  {1331, 1330, 1328},
  {1328, 1293, 1331},
  {1332, 1331, 1293},
  {1334, 1335, 1338},
  {1337, 1338, 1335},
  {1336, 6292, 1295},
  {5934, 1338, 5933},
  {1338, 1337, 1339},
  {1297, 1130, 1549},
  {1130, 1506, 1549},
  {1297, 1549, 1298},
  {1340, 1204, 1301},
  {1389, 1300, 1340},
  {1389, 1256, 1300},
  {1256, 1389, 1391},
  {1256, 1391, 1299},
  {1258, 1298, 1454},
  {1258, 1454, 1392},
  {1341, 1340, 1301},
  {1301, 1260, 1341},
  {1341, 1342, 1396},
  {1302, 1458, 1393},
  {1211, 1344, 1345},
  {1347, 1211, 1348},
  {1263, 1349, 1404},
  {1405, 1351, 1096},
  {1405, 1346, 1465},
  {1405, 1465, 1351},
  {1096, 1351, 1309},
  {6251, 6253, 1353},
  {1096, 1309, 1408},
  {1096, 1408, 1266},
  {1352, 1354, 1098},
  {1406, 1353, 1310},
  {1098, 1354, 1355},
  {1357, 1410, 1356},
  {1356, 1410, 1405},
  {1358, 1266, 1408},
  {1409, 1406, 1310},
  {1407, 1409, 1310},
  {1355, 1569, 1357},
  {1357, 1516, 1410},
  {1218, 1311, 1413},
  {1358, 1415, 1222},
  {1313, 1359, 1158},
  {1314, 1360, 1312},
  {1313, 1268, 1419},
  {1313, 1419, 1622},
  {1364, 1226, 1417},
  {1056, 1420, 1472},
  {6354, 5935, 6355},
  {1268, 1364, 1419},
  {1362, 1317, 1474},
  {1366, 1271, 1475},
  {1475, 1271, 1422},
  {1579, 1428, 1273},
  {1428, 1320, 1273},
  {1428, 1424, 1320},
  {1172, 1371, 1481},
  {1279, 6399, 1369},
  {5937, 1372, 1279},
  {1431, 5937, 1279},
  {1369, 1431, 1279},
  {1175, 1429, 1371},
  {1277, 6284, 1479},
  {1435, 1373, 1442},
  {1283, 1373, 1485},
  {1116, 1375, 1539},
  {1240, 1437, 1375},
  {1284, 1374, 1436},
  {1285, 1284, 1436},
  {1285, 1436, 5941},
  {1241, 1376, 1442},
  {1285, 5941, 1242},
  {1377, 5941, 1441},
  {1379, 1189, 1378},
  {1490, 1378, 1189},
  {1444, 1289, 1324},
  {1325, 1324, 1289},
  {1325, 1289, 6369},
  {1248, 1448, 1286},
  {1380, 1381, 6353},
  {1250, 1382, 1498},
  {1329, 1328, 5942},
  {5942, 1502, 1294},
  {1330, 1331, 1383},
  {1383, 1331, 1547},
  {1331, 1332, 1547},
  {1293, 1294, 1332},
  {1333, 1384, 1451},
  {1335, 1385, 1337},
  {1336, 1452, 1603},
  {1336, 1603, 1506},
  {1505, 5933, 1338},
  {1295, 1452, 1336},
  {1338, 1339, 1505},
  {1452, 1295, 1553},
  {1337, 1388, 1339},
  {1296, 6268, 1386},
  {1390, 1386, 6267},
  {1388, 1387, 1339},
  {1388, 1389, 1453},
  {1388, 1453, 1387},
  {1299, 1390, 6267},
  {1340, 1507, 1453},
  {1453, 1389, 1340},
  {1391, 1552, 1299},
  {1390, 1299, 1552},
  {1549, 1454, 1298},
  {1509, 1396, 1342},
  {1394, 1395, 1343},
  {1342, 1305, 1509},
  {1305, 1510, 1509},
  {1462, 1393, 1458},
  {1461, 1343, 1397},
  {1399, 1398, 1343},
  {1343, 1461, 1399},
  {1344, 1211, 1462},
  {1398, 1399, 1400},
  {1399, 1463, 1400},
  {1405, 1398, 1400},
  {1400, 1464, 1405},
  {1401, 1405, 1464},
  {1348, 1344, 1462},
  {1344, 1348, 1345},
  {1405, 1401, 1346},
  {1465, 1346, 1401},
  {1347, 1348, 1350},
  {1348, 1513, 1350},
  {1466, 1351, 1465},
  {1349, 1403, 1404},
  {1350, 1402, 1352},
  {1405, 1096, 1356},
  {1351, 1466, 1309},
  {1403, 1406, 1404},
  {1309, 1466, 1408},
  {1403, 1353, 1406},
  {1406, 1409, 1407},
  {1406, 1407, 1404},
  {1352, 1402, 1354},
  {1408, 5938, 1358},
  {1218, 1413, 1412},
  {1355, 1354, 1569},
  {1411, 1415, 1358},
  {1311, 1312, 1413},
  {1226, 1470, 1417},
  {1312, 1416, 1413},
  {1312, 1360, 1416},
  {1418, 1365, 1315},
  {1418, 1315, 1671},
  {1418, 1671, 1365},
  {1419, 1364, 1417},
  {1363, 1361, 1316},
  {1362, 1474, 1521},
  {1420, 1366, 1475},
  {1270, 1365, 1574},
  {1270, 1476, 1318},
  {1317, 1477, 1474},
  {1317, 1367, 1477},
  {1367, 1320, 1477},
  {1476, 1368, 1229},
  {1421, 1478, 1319},
  {1272, 1319, 1478},
  {1425, 1272, 1426},
  {6399, 1426, 1369},
  {1430, 1431, 5936},
  {1430, 5936, 1431},
  {1432, 5940, 1370},
  {1372, 5937, 1480},
  {1432, 1370, 5940},
  {1429, 1481, 1371},
  {1434, 1372, 1480},
  {1372, 1434, 1323},
  {1482, 1323, 1434},
  {1374, 1323, 1482},
  {1442, 1484, 1435},
  {1280, 1485, 1278},
  {1482, 5941, 1436},
  {1482, 1439, 5941},
  {1482, 1438, 1439},
  {1326, 1489, 1542},
  {1324, 1440, 1444},
  {1440, 1324, 1377},
  {1441, 1440, 1377},
  {1443, 1286, 1491},
  {6130, 6353, 1446},
  {1381, 1446, 6353},
  {1379, 1850, 1292},
  {1248, 1447, 1448},
  {1544, 1381, 1380},
  {1448, 1544, 6352},
  {1380, 6352, 1544},
  {6411, 6467, 1449},
  {1382, 1499, 1498},
  {5942, 1328, 1500},
  {1500, 1328, 1598},
  {5942, 1642, 1502},
  {1330, 1383, 1598},
  {1502, 1333, 1294},
  {1384, 1501, 1450},
  {1384, 1450, 1451},
  {1598, 1383, 1385},
  {1383, 1547, 1385},
  {1333, 1691, 1294},
  {1333, 1451, 1691},
  {1451, 1450, 1691},
  {5933, 1505, 1335},
  {1452, 1553, 1504},
  {1388, 1337, 1652},
  {1389, 1388, 1652},
  {1551, 1295, 1386},
  {1339, 1387, 1507},
  {1551, 1386, 1390},
  {1553, 1295, 1551},
  {1387, 1453, 1507},
  {1552, 1551, 1390},
  {1389, 1552, 1391},
  {1507, 1340, 1341},
  {1507, 1341, 1654},
  {1654, 1341, 1558},
  {1341, 1396, 1558},
  {1455, 1560, 1456},
  {1258, 1392, 1708},
  {1258, 1708, 1457},
  {1459, 1560, 1394},
  {1560, 1455, 1394},
  {1455, 1395, 1394},
  {1396, 1509, 1558},
  {1395, 1559, 1460},
  {1395, 1460, 1397},
  {1395, 1397, 1343},
  {1459, 1394, 1398},
  {1343, 1398, 1394},
  {1397, 1460, 1461},
  {1609, 1462, 1458},
  {1302, 1457, 1565},
  {1463, 1399, 1461},
  {1464, 1400, 1463},
  {1462, 1513, 1348},
  {1613, 1398, 1405},
  {1350, 1513, 1402},
  {1466, 1415, 1408},
  {1408, 1415, 1411},
  {1412, 1413, 1666},
  {1413, 1469, 1666},
  {1354, 1515, 1569},
  {1569, 1468, 1357},
  {1357, 1468, 1414},
  {1415, 1466, 1470},
  {1413, 1416, 1469},
  {1470, 1518, 1417},
  {1519, 1671, 1315},
  {1315, 1359, 1519},
  {1313, 1519, 1359},
  {1417, 1471, 1419},
  {1360, 1362, 1619},
  {1574, 1473, 1270},
  {1476, 1270, 1473},
  {1422, 1526, 1475},
  {1477, 1320, 1424},
  {1363, 1579, 1165},
  {1423, 1526, 1422},
  {1531, 1423, 1172},
  {1172, 1481, 1531},
  {1272, 1478, 1426},
  {1426, 1478, 1369},
  {1583, 1531, 1481},
  {1479, 1533, 1429},
  {1431, 1369, 1725},
  {1478, 1725, 1369},
  {1725, 5937, 1431},
  {5943, 6281, 1433},
  {1434, 1586, 1482},
  {6283, 6282, 6140},
  {1483, 6119, 1484},
  {1483, 1484, 6119},
  {1680, 1534, 1278},
  {1278, 1534, 6284},
  {1374, 1482, 1436},
  {1535, 1484, 1442},
  {1485, 1680, 1278},
  {1373, 1435, 1485},
  {1375, 1437, 1538},
  {1482, 1487, 1438},
  {1535, 1442, 1537},
  {6148, 6229, 1488},
  {1486, 1444, 1488},
  {1442, 1376, 1637},
  {1489, 1116, 1539},
  {1591, 1490, 1486},
  {1488, 1444, 6148},
  {1442, 1637, 1592},
  {1443, 1437, 1240},
  {1486, 1490, 1444},
  {6148, 1444, 1440},
  {1247, 1326, 1376},
  {1492, 1376, 1326},
  {1378, 1490, 1493},
  {1491, 1286, 1448},
  {1491, 6353, 1541},
  {1543, 1541, 6353},
  {1495, 1543, 6353},
  {1378, 1493, 1379},
  {1494, 6353, 6130},
  {1494, 1495, 6353},
  {1446, 1494, 1445},
  {1379, 1493, 1850},
  {1292, 1850, 1449},
  {1446, 1381, 1544},
  {1448, 1447, 1496},
  {1497, 1496, 1447},
  {6411, 1449, 1850},
  {1499, 1545, 1498},
  {1598, 1328, 1330},
  {1502, 1501, 1333},
  {1333, 1501, 1384},
  {1332, 1294, 1547},
  {1385, 1335, 1645},
  {1294, 1691, 1547},
  {1385, 1649, 1652},
  {1385, 1652, 1337},
  {1452, 1504, 1603},
  {1553, 1503, 1504},
  {1339, 1507, 1505},
  {1552, 1389, 1652},
  {1454, 1549, 1607},
  {1708, 1392, 1454},
  {1560, 1559, 1456},
  {1456, 1395, 1455},
  {1559, 1395, 1456},
  {1559, 1461, 1460},
  {1459, 1398, 1508},
  {1302, 1609, 1458},
  {1509, 1510, 1563},
  {1462, 1609, 1512},
  {1464, 1463, 1514},
  {1464, 1514, 1401},
  {1462, 1512, 1513},
  {1401, 1514, 1465},
  {1404, 1611, 1510},
  {1402, 1513, 1515},
  {1569, 1515, 1513},
  {1613, 1405, 1410},
  {1465, 1567, 1466},
  {1354, 1402, 1515},
  {1567, 1470, 1466},
  {1412, 1666, 1407},
  {1614, 1467, 1569},
  {1467, 1614, 1414},
  {1517, 1414, 1614},
  {1414, 1517, 1357},
  {1516, 1357, 1517},
  {1469, 1416, 1666},
  {1313, 1571, 1620},
  {1571, 1313, 1622},
  {1519, 1313, 1572},
  {1313, 1620, 1572},
  {1622, 1419, 1471},
  {1518, 1669, 1417},
  {1417, 1669, 1524},
  {1417, 1524, 1471},
  {1520, 1362, 1521},
  {1365, 1671, 1574},
  {1471, 1524, 1522},
  {1520, 1521, 1670},
  {1724, 1316, 1472},
  {1420, 1526, 1472},
  {1523, 1524, 1575},
  {1523, 1527, 1524},
  {1528, 1523, 1525},
  {1523, 1575, 1525},
  {1521, 1474, 1576},
  {1527, 1523, 1529},
  {1528, 1529, 1523},
  {1475, 1526, 1420},
  {5838, 1476, 1530},
  {1578, 5838, 1530},
  {1477, 1424, 1627},
  {1578, 1478, 1421},
  {1424, 1428, 1579},
  {1478, 1532, 1580},
  {1533, 1784, 1583},
  {1533, 1583, 1429},
  {1479, 1631, 1533},
  {1479, 6284, 1631},
  {5937, 1725, 1480},
  {1434, 1480, 1584},
  {1481, 1429, 1583},
  {1434, 1584, 1586},
  {1484, 1535, 1435},
  {1535, 1485, 1435},
  {1487, 1482, 1588},
  {6192, 1588, 1536},
  {1538, 1539, 1375},
  {1591, 1486, 1488},
  {1592, 1537, 1442},
  {1590, 1538, 1437},
  {6230, 1488, 6229},
  {1539, 1595, 1489},
  {1540, 1490, 1591},
  {1443, 1491, 1541},
  {1492, 1639, 1376},
  {1490, 1540, 1493},
  {1492, 1326, 1542},
  {1446, 1544, 1494},
  {1496, 1743, 1448},
  {1447, 1545, 1497},
  {1447, 1498, 1545},
  {1496, 1497, 1743},
  {1500, 1596, 5942},
  {5942, 1596, 1642},
  {1502, 1642, 1600},
  {1502, 1600, 1601},
  {1502, 1601, 1501},
  {1546, 1450, 1501},
  {1598, 1385, 1597},
  {1645, 1597, 1385},
  {1450, 1546, 1602},
  {1602, 1691, 1450},
  {1385, 1547, 1649},
  {1692, 1335, 1505},
  {1503, 1603, 1504},
  {1503, 1548, 1603},
  {1503, 1553, 1548},
  {1553, 2050, 1548},
  {1550, 1506, 1603},
  {1506, 1550, 1549},
  {1550, 1604, 1556},
  {1550, 1556, 1549},
  {1551, 1605, 1553},
  {1551, 1655, 1605},
  {1708, 1607, 1549},
  {1554, 1555, 1556},
  {1555, 1606, 1556},
  {1459, 1508, 1560},
  {1561, 1508, 1658},
  {1561, 1658, 1562},
  {1613, 1658, 1508},
  {1509, 1563, 1608},
  {1565, 1609, 1302},
  {1562, 1658, 1610},
  {1508, 1398, 1613},
  {1712, 1567, 1461},
  {1563, 1510, 1564},
  {1565, 1457, 1771},
  {1567, 1511, 1461},
  {1461, 1511, 1463},
  {1510, 1611, 1564},
  {1567, 1514, 1511},
  {1511, 1514, 1463},
  {1614, 1513, 1566},
  {1514, 1567, 1465},
  {1568, 1614, 1613},
  {1513, 1614, 1569},
  {1568, 1613, 1410},
  {1516, 1568, 1410},
  {1404, 1407, 1666},
  {1516, 1517, 1568},
  {1614, 1568, 1517},
  {1567, 1615, 1570},
  {1470, 1567, 1570},
  {1519, 1572, 1671},
  {1572, 1620, 1722},
  {1573, 1362, 1520},
  {1619, 1362, 1573},
  {1520, 1670, 1573},
  {1471, 1522, 1672},
  {1670, 1521, 1576},
  {1522, 1577, 1672},
  {1522, 1524, 1527},
  {6322, 1528, 1525},
  {1472, 1526, 1724},
  {1574, 1476, 1473},
  {1316, 1724, 1363},
  {1574, 1624, 1476},
  {1522, 1527, 1577},
  {1476, 1624, 1530},
  {1527, 1529, 1577},
  {1576, 1474, 1477},
  {1530, 1674, 1578},
  {1526, 1423, 1531},
  {1424, 1579, 1627},
  {1526, 1531, 1629},
  {1629, 1531, 1582},
  {1581, 1580, 1532},
  {1582, 1633, 1629},
  {1583, 1582, 1531},
  {1478, 1580, 1677},
  {1580, 1581, 1677},
  {6284, 1534, 1634},
  {6284, 1634, 1631},
  {1584, 1585, 1586},
  {1586, 1587, 1482},
  {1535, 1537, 1485},
  {1588, 1482, 1587},
  {1485, 1537, 1589},
  {1488, 1588, 1587},
  {1488, 1587, 1635},
  {1588, 1488, 6230},
  {1588, 6192, 1536},
  {1537, 1592, 1589},
  {1637, 1376, 1682},
  {1593, 1682, 1376},
  {1595, 1539, 1593},
  {1590, 1437, 1683},
  {1594, 1683, 1437},
  {1591, 1681, 1540},
  {1595, 1593, 1376},
  {1681, 1638, 1540},
  {1376, 1639, 1595},
  {1489, 1595, 1640},
  {1489, 1640, 1542},
  {1443, 1541, 1437},
  {1437, 1541, 1594},
  {1683, 1594, 1541},
  {1542, 1640, 6386},
  {1683, 1541, 1543},
  {1850, 1493, 1731},
  {1495, 1641, 1543},
  {1495, 1494, 1641},
  {1494, 1544, 1641},
  {1448, 1641, 1544},
  {1597, 1686, 1598},
  {1501, 1599, 1546},
  {1597, 1645, 1686},
  {1600, 1643, 1601},
  {1602, 1546, 1599},
  {1645, 1335, 1692},
  {1755, 1692, 1505},
  {1505, 1507, 1755},
  {1548, 2050, 1603},
  {1755, 1507, 1654},
  {1550, 2050, 1604},
  {1556, 1604, 1554},
  {1605, 1701, 1553},
  {1553, 1701, 2050},
  {1554, 1808, 1555},
  {1606, 1555, 1808},
  {1556, 1606, 1557},
  {1654, 1558, 1706},
  {1654, 1706, 1699},
  {1557, 1606, 1656},
  {1560, 1461, 1559},
  {1558, 1509, 1608},
  {1558, 1608, 1657},
  {1708, 1766, 1457},
  {1771, 1457, 1766},
  {1608, 1563, 1657},
  {1564, 1657, 1563},
  {1658, 1710, 1610},
  {1771, 1660, 1565},
  {1564, 1611, 1659},
  {1512, 1609, 1660},
  {1513, 1716, 1566},
  {1513, 1512, 1716},
  {1566, 1716, 1612},
  {1512, 1660, 1716},
  {1666, 1776, 1404},
  {1615, 1664, 1570},
  {1616, 1570, 1664},
  {1570, 1616, 1470},
  {1666, 1416, 1617},
  {1668, 1470, 1616},
  {1665, 1618, 1621},
  {1619, 1617, 1416},
  {1668, 1518, 1470},
  {1618, 1619, 1621},
  {1619, 1416, 1360},
  {1621, 1619, 1573},
  {1722, 1671, 1572},
  {1524, 1669, 1575},
  {1672, 1622, 1471},
  {1525, 1623, 6322},
  {1838, 1577, 1529},
  {1529, 1528, 1625},
  {1624, 1673, 1530},
  {1576, 1477, 1627},
  {1576, 1627, 1723},
  {1530, 1673, 1626},
  {1530, 1626, 1674},
  {1579, 1363, 1676},
  {1627, 1579, 1628},
  {1627, 1628, 1675},
  {1478, 1578, 1781},
  {1532, 1478, 1581},
  {1630, 1629, 1633},
  {6290, 6291, 1632},
  {1584, 1480, 1725},
  {1725, 1585, 1584},
  {1534, 1680, 1634},
  {1679, 1586, 1585},
  {1586, 1635, 1587},
  {5945, 1636, 5944},
  {1539, 1538, 1728},
  {1901, 1538, 1590},
  {1636, 5945, 5944},
  {1589, 1592, 1729},
  {1589, 1729, 1485},
  {1485, 1729, 1730},
  {1485, 1730, 5844},
  {1539, 1845, 1682},
  {1539, 1682, 1593},
  {1638, 1731, 1540},
  {1540, 1731, 1493},
  {1543, 1641, 1683},
  {1497, 1545, 1852},
  {1497, 1852, 1743},
  {1545, 1499, 1852},
  {1500, 1854, 1596},
  {6349, 1599, 1684},
  {1501, 1685, 1599},
  {1644, 1599, 6349},
  {1643, 1600, 1642},
  {1601, 1685, 1501},
  {1643, 1688, 1601},
  {1599, 1644, 1602},
  {1650, 1647, 1648},
  {1691, 1602, 1644},
  {1651, 1650, 1648},
  {1650, 1651, 1653},
  {1652, 1696, 1552},
  {1550, 1603, 2050},
  {1654, 1699, 1698},
  {1552, 1696, 1551},
  {1551, 1696, 1655},
  {1808, 1554, 1604},
  {1605, 1655, 1701},
  {1549, 1809, 1708},
  {1810, 1809, 1549},
  {1810, 1549, 1556},
  {1556, 1557, 1810},
  {1656, 1810, 1557},
  {1702, 1656, 1606},
  {1708, 1454, 1607},
  {1873, 1706, 1558},
  {1558, 1657, 1873},
  {1562, 1610, 1561},
  {1561, 1610, 1767},
  {1561, 1767, 1508},
  {1660, 1609, 1565},
  {1711, 1612, 1716},
  {1711, 1710, 1658},
  {1711, 1658, 1612},
  {1612, 1658, 1614},
  {1612, 1614, 1566},
  {1658, 1613, 1661},
  {1717, 1567, 1712},
  {1611, 1770, 1659},
  {1614, 1658, 1661},
  {1770, 1611, 1404},
  {1661, 1613, 1614},
  {1567, 1717, 1662},
  {1825, 1404, 1776},
  {1567, 1662, 1615},
  {1664, 1615, 1662},
  {1776, 1666, 1831},
  {1619, 1618, 1665},
  {6394, 1667, 6395},
  {1721, 1722, 1620},
  {1571, 1622, 1620},
  {1518, 1668, 1720},
  {1518, 1720, 1669},
  {1621, 1573, 1670},
  {1575, 1669, 1835},
  {1574, 1671, 1624},
  {1575, 1835, 1525},
  {1525, 1835, 1623},
  {1838, 1672, 1577},
  {1625, 1838, 1529},
  {1674, 1626, 1673},
  {1363, 1724, 1841},
  {1676, 1363, 1841},
  {1675, 1628, 1676},
  {1579, 1676, 1628},
  {1581, 1478, 1781},
  {1526, 1629, 1780},
  {1629, 1630, 1678},
  {1629, 1678, 1780},
  {1533, 1631, 1784},
  {1677, 1581, 1783},
  {1582, 2030, 1633},
  {1630, 1633, 2030},
  {1582, 1583, 1784},
  {1632, 6291, 6290},
  {1680, 1631, 1634},
  {1585, 1725, 1679},
  {1679, 1727, 1586},
  {1586, 1727, 1635},
  {1901, 1728, 1538},
  {6471, 1592, 1637},
  {6471, 1637, 6325},
  {1637, 1682, 1905},
  {1731, 1638, 1681},
  {6371, 6411, 1850},
  {6092, 1599, 1685},
  {1688, 1685, 1601},
  {1688, 1643, 1747},
  {1647, 1748, 1687},
  {1687, 1748, 1746},
  {1647, 1687, 1749},
  {1646, 1645, 1692},
  {1646, 1692, 1750},
  {1751, 1750, 1692},
  {1755, 1751, 1692},
  {1647, 1862, 1748},
  {1650, 1862, 1647},
  {1690, 1689, 1649},
  {1649, 1547, 1690},
  {1547, 1691, 1690},
  {1652, 1649, 1689},
  {1653, 1651, 1693},
  {1696, 1652, 1689},
  {1695, 1756, 1697},
  {1606, 1700, 1924},
  {1704, 6366, 1703},
  {1708, 1809, 1811},
  {1656, 1702, 1810},
  {1873, 6366, 1704},
  {1763, 6304, 6366},
  {6366, 1873, 1763},
  {1657, 1564, 1814},
  {1564, 1817, 1814},
  {1710, 1767, 1610},
  {1564, 1659, 1817},
  {1714, 1715, 1713},
  {1659, 1770, 1817},
  {1663, 1715, 1718},
  {1718, 1404, 1663},
  {1718, 1715, 1822},
  {1718, 1822, 1404},
  {1717, 1773, 1662},
  {1715, 1663, 1825},
  {1663, 1404, 1825},
  {1662, 1773, 1616},
  {1664, 1662, 1616},
  {1665, 1719, 1619},
  {1831, 1666, 1619},
  {1621, 1719, 1665},
  {1617, 1619, 1666},
  {1620, 1672, 1721},
  {1835, 1669, 1720},
  {1620, 1622, 1672},
  {1835, 1778, 1623},
  {1671, 1779, 1624},
  {1624, 1779, 1673},
  {1673, 1779, 1674},
  {1674, 1839, 1578},
  {1675, 1676, 1841},
  {1582, 1784, 2030},
  {1478, 1677, 1785},
  {1783, 1785, 1677},
  {1786, 1631, 1680},
  {1726, 1488, 1679},
  {1679, 1488, 1727},
  {1786, 1680, 1485},
  {5845, 1485, 5844},
  {1590, 2175, 1901},
  {1729, 1592, 6471},
  {6325, 1637, 1787},
  {1845, 1539, 1728},
  {1590, 1683, 2175},
  {1637, 1905, 1790},
  {1905, 1793, 6427},
  {1905, 1682, 1845},
  {1791, 1735, 1734},
  {1735, 1791, 1736},
  {1736, 1792, 1732},
  {6276, 6089, 6277},
  {1791, 1734, 1738},
  {1791, 1738, 1733},
  {6088, 1737, 6149},
  {6090, 6118, 1740},
  {1733, 1738, 1796},
  {1734, 1735, 1795},
  {1641, 2175, 1683},
  {1731, 1794, 1850},
  {1796, 1738, 6379},
  {1797, 1641, 1448},
  {1448, 1743, 1797},
  {6380, 1742, 1741},
  {1853, 1852, 1499},
  {1642, 1596, 1643},
  {1645, 1799, 1686},
  {1746, 1749, 1687},
  {1646, 1799, 1645},
  {1646, 1750, 1799},
  {1686, 1917, 1598},
  {1800, 1688, 1747},
  {1686, 1799, 1917},
  {1644, 1986, 1691},
  {1755, 1803, 1751},
  {1689, 1690, 1752},
  {1690, 1753, 1752},
  {1690, 1691, 1753},
  {1696, 1689, 1752},
  {1691, 1754, 1753},
  {1650, 1653, 1862},
  {1693, 1862, 1653},
  {1755, 1654, 1804},
  {1758, 1693, 1694},
  {1694, 1695, 1758},
  {1697, 1758, 1695},
  {1804, 1654, 1757},
  {1759, 1758, 1697},
  {1697, 1756, 1759},
  {1654, 1698, 1757},
  {1700, 1606, 1758},
  {1758, 1759, 1700},
  {1758, 1606, 1808},
  {1701, 1655, 1994},
  {1702, 1606, 1924},
  {1760, 1703, 1995},
  {1699, 1704, 1703},
  {1703, 1705, 1995},
  {1704, 1699, 1873},
  {1699, 1706, 1873},
  {1708, 1811, 1764},
  {1762, 1761, 1709},
  {6304, 1763, 6079},
  {1708, 1764, 1766},
  {5948, 6385, 1765},
  {1766, 1764, 1813},
  {1876, 1771, 1766},
  {1711, 1767, 1710},
  {1820, 1769, 1713},
  {1713, 1769, 1714},
  {1711, 1716, 1767},
  {1824, 1820, 1713},
  {1818, 1717, 1712},
  {1404, 1822, 1770},
  {1771, 1826, 1660},
  {1768, 6453, 1830},
  {6453, 1772, 1774},
  {6453, 1774, 1830},
  {1774, 1772, 1883},
  {1775, 1719, 1885},
  {1619, 1719, 1831},
  {1719, 1621, 1885},
  {1667, 6394, 6395},
  {1833, 1621, 1670},
  {1720, 1668, 1616},
  {1671, 1722, 1779},
  {1672, 1837, 1721},
  {1670, 1777, 1834},
  {1670, 1576, 1777},
  {1672, 1838, 1953},
  {1838, 1625, 6222},
  {1576, 1723, 1777},
  {1674, 1891, 1839},
  {1627, 1675, 1723},
  {1839, 1893, 1958},
  {1839, 1958, 1578},
  {1724, 1780, 1841},
  {1724, 1526, 1780},
  {1894, 1782, 1581},
  {1894, 1581, 1781},
  {1675, 1841, 1892},
  {1578, 1896, 1781},
  {1782, 1783, 1581},
  {1630, 2030, 1678},
  {1842, 1785, 1783},
  {1679, 1725, 1726},
  {1635, 1727, 1488},
  {1786, 1485, 5845},
  {6325, 1787, 6312},
  {1637, 1790, 1787},
  {1845, 1728, 1969},
  {1681, 1788, 1846},
  {1789, 1796, 1788},
  {1796, 1789, 1791},
  {1736, 1791, 1792},
  {1681, 1794, 1731},
  {1796, 1791, 1733},
  {1846, 1788, 1796},
  {1735, 1736, 1847},
  {1734, 1795, 1738},
  {6118, 1739, 1740},
  {1850, 1794, 1846},
  {1741, 1742, 6380},
  {1797, 1743, 1798},
  {1743, 1852, 2088},
  {1855, 1596, 1854},
  {1982, 1596, 1855},
  {1500, 1598, 1916},
  {1596, 1747, 1643},
  {1856, 1746, 1915},
  {5843, 1915, 1746},
  {1749, 1746, 1856},
  {1746, 1748, 5843},
  {1747, 1982, 1800},
  {1750, 1857, 1799},
  {1750, 1751, 1857},
  {1800, 1801, 1688},
  {1751, 1803, 1857},
  {1801, 1802, 1688},
  {1986, 1991, 1691},
  {1803, 1755, 1859},
  {1859, 1755, 1860},
  {1691, 1991, 1754},
  {1755, 1804, 1921},
  {1752, 1753, 1696},
  {1694, 1756, 1695},
  {1696, 1753, 1655},
  {1994, 1753, 1754},
  {1994, 1655, 1753},
  {1805, 1693, 1758},
  {1922, 1759, 1756},
  {1698, 1806, 1757},
  {1805, 1758, 1808},
  {1863, 1805, 1808},
  {1759, 1924, 1700},
  {1757, 1760, 1864},
  {1760, 1806, 1703},
  {1760, 1757, 1806},
  {1699, 1806, 1698},
  {1807, 1604, 1865},
  {1604, 1807, 1808},
  {1760, 1995, 1864},
  {1703, 1806, 1699},
  {1810, 1702, 1924},
  {1811, 1809, 1998},
  {1930, 1761, 1762},
  {1930, 1866, 1761},
  {1930, 1762, 1869},
  {1707, 6385, 1705},
  {1707, 1765, 6385},
  {1764, 1811, 1813},
  {1762, 1709, 1869},
  {1761, 1929, 1709},
  {1815, 1709, 1929},
  {1874, 1709, 1767},
  {1875, 1766, 1813},
  {1814, 1873, 1657},
  {1876, 1766, 1875},
  {1815, 1712, 1709},
  {1816, 2007, 1768},
  {1712, 1815, 1818},
  {1816, 1768, 1815},
  {5950, 1769, 1820},
  {1819, 2156, 1769},
  {5950, 1820, 2156},
  {1714, 1769, 2156},
  {1878, 1771, 1876},
  {1768, 1818, 1815},
  {1820, 1824, 1821},
  {1818, 1823, 1717},
  {1713, 1715, 1824},
  {1715, 1825, 1824},
  {1715, 1940, 1879},
  {1822, 1817, 1770},
  {1771, 1878, 1826},
  {1716, 1828, 1767},
  {1717, 1823, 1773},
  {1826, 1827, 1660},
  {1660, 1827, 1881},
  {1660, 1828, 1716},
  {1818, 1768, 1830},
  {1827, 1880, 1881},
  {1660, 1881, 1828},
  {1773, 1823, 1830},
  {1823, 1818, 1830},
  {1774, 1883, 6396},
  {1824, 1775, 1821},
  {2015, 1821, 1775},
  {1775, 1824, 1719},
  {1831, 1825, 1776},
  {1830, 1616, 1773},
  {6397, 1883, 1829},
  {1719, 1824, 1831},
  {1616, 1830, 1835},
  {1833, 1885, 1621},
  {1616, 1835, 1720},
  {1888, 1833, 1670},
  {1888, 1670, 1834},
  {1722, 1721, 1837},
  {1722, 1837, 1779},
  {1837, 1672, 1953},
  {1953, 1838, 1889},
  {1779, 1891, 1674},
  {1723, 1675, 1777},
  {1892, 1777, 1675},
  {1894, 1840, 1782},
  {1783, 1782, 1840},
  {1578, 1958, 1896},
  {1783, 1840, 1842},
  {2074, 2030, 1784},
  {1631, 2074, 1784},
  {1478, 1785, 1842},
  {2076, 1725, 1478},
  {1631, 1786, 2074},
  {1726, 1725, 1962},
  {1897, 1488, 1726},
  {1843, 1844, 1898},
  {1591, 1488, 1963},
  {1591, 1963, 1681},
  {1968, 1681, 1963},
  {1728, 1901, 1969},
  {1788, 1681, 2127},
  {1788, 2127, 1789},
  {1790, 1905, 1787},
  {6427, 1793, 1905},
  {1794, 1681, 1846},
  {1904, 1795, 1735},
  {1903, 1904, 1735},
  {1847, 1903, 1735},
  {1792, 1847, 1732},
  {1909, 2175, 1641},
  {6089, 6276, 6277},
  {1736, 1732, 1847},
  {1910, 1846, 1796},
  {1795, 1904, 1738},
  {1909, 1641, 1849},
  {1909, 1849, 1848},
  {1738, 1913, 6379},
  {1641, 1797, 1849},
  {2088, 2180, 1743},
  {1796, 6379, 1912},
  {1743, 1851, 1798},
  {1743, 2180, 1851},
  {1596, 1982, 1747},
  {1856, 1984, 1749},
  {1986, 1644, 6069},
  {1982, 1801, 1800},
  {1986, 1748, 1858},
  {1749, 1988, 1647},
  {1648, 1987, 1651},
  {1857, 1917, 1799},
  {1982, 1918, 1801},
  {1857, 1803, 1859},
  {1917, 1857, 1859},
  {2049, 1858, 1748},
  {1651, 1987, 1693},
  {1917, 1859, 1860},
  {1860, 1755, 1861},
  {1921, 1861, 1755},
  {1991, 1994, 1754},
  {1920, 1862, 1693},
  {1922, 1756, 1694},
  {1757, 1921, 1804},
  {1693, 1805, 1920},
  {1921, 1757, 1864},
  {1925, 1808, 1807},
  {1864, 1995, 2101},
  {1865, 1604, 2050},
  {2050, 1701, 1994},
  {1809, 1810, 1868},
  {1761, 1866, 1926},
  {1996, 1705, 6385},
  {1705, 1996, 1995},
  {1998, 1997, 1811},
  {1871, 1809, 1868},
  {1761, 1926, 1929},
  {1997, 1813, 1811},
  {1869, 1709, 1872},
  {1815, 1929, 1870},
  {1709, 2000, 1872},
  {1874, 2000, 1709},
  {1874, 1767, 5955},
  {1877, 5955, 1767},
  {1870, 2002, 1816},
  {1816, 1815, 1870},
  {1938, 1876, 2003},
  {1820, 1821, 2156},
  {1715, 1714, 1940},
  {2202, 1940, 1714},
  {1822, 1939, 1817},
  {1824, 1825, 1831},
  {1715, 1879, 1822},
  {1822, 1879, 1939},
  {1878, 1827, 1826},
  {1827, 1878, 1880},
  {1882, 1883, 1772},
  {1772, 1944, 1882},
  {1883, 1882, 1829},
  {1775, 1885, 2015},
  {2017, 1885, 1833},
  {1888, 2017, 1833},
  {1830, 1832, 1835},
  {1832, 1886, 1835},
  {1952, 1886, 1887},
  {1952, 1835, 1886},
  {1778, 1835, 1952},
  {1836, 1778, 1952},
  {1837, 1953, 2025},
  {1838, 1954, 1889},
  {6223, 1890, 6222},
  {1779, 1837, 1891},
  {1838, 6222, 2167},
  {1891, 1893, 1839},
  {1892, 1841, 1957},
  {1840, 1895, 1842},
  {1958, 2029, 1896},
  {1841, 1780, 1960},
  {1961, 1478, 1842},
  {2076, 1962, 1725},
  {1962, 1897, 1726},
  {1897, 1963, 1488},
  {1898, 1964, 1843},
  {1899, 1843, 1964},
  {5845, 2077, 1786},
  {1900, 1898, 1844},
  {1844, 1843, 1899},
  {1966, 1844, 1899},
  {1966, 1900, 1844},
  {1967, 5959, 6312},
  {6312, 1787, 1967},
  {2033, 1967, 1787},
  {2127, 1681, 1968},
  {1902, 1845, 1969},
  {1792, 2035, 1908},
  {1905, 1845, 1906},
  {1905, 1906, 1787},
  {1845, 1902, 1906},
  {1904, 1907, 1913},
  {1903, 1847, 1908},
  {1792, 1908, 1847},
  {2175, 1909, 2475},
  {1913, 1738, 1904},
  {1846, 1910, 1850},
  {1848, 1911, 1909},
  {1848, 1849, 1797},
  {1848, 1797, 1911},
  {1798, 1911, 1797},
  {1974, 1973, 1796},
  {1796, 1912, 1974},
  {1913, 1974, 1912},
  {1912, 6379, 1913},
  {1851, 2180, 1914},
  {2040, 2088, 1852},
  {1850, 1972, 1976},
  {1850, 1976, 6371},
  {6371, 1976, 2042},
  {1978, 6103, 6136},
  {6135, 1852, 1853},
  {1854, 1500, 1979},
  {2043, 1979, 1500},
  {1915, 1984, 1856},
  {1988, 1749, 1984},
  {1748, 1986, 5843},
  {1598, 1917, 1916},
  {1916, 1917, 1985},
  {1648, 1989, 1987},
  {1647, 1992, 1648},
  {1918, 1990, 1801},
  {1801, 1990, 1802},
  {1858, 2049, 1991},
  {1648, 1992, 1989},
  {1860, 1919, 1917},
  {1860, 1861, 1993},
  {1748, 1862, 2050},
  {1920, 2050, 1862},
  {2050, 1920, 1865},
  {2050, 2049, 1748},
  {1863, 1923, 1920},
  {1920, 1805, 1863},
  {1759, 2100, 1924},
  {1759, 1922, 2100},
  {1808, 1925, 1923},
  {1923, 1863, 1808},
  {2101, 1921, 1864},
  {1925, 1807, 1865},
  {1868, 1810, 1924},
  {6165, 1929, 1926},
  {1927, 5954, 1867},
  {5951, 1931, 1932},
  {1929, 1932, 1870},
  {1996, 6385, 1999},
  {1998, 1809, 1933},
  {1809, 1871, 1933},
  {1869, 1872, 1930},
  {2010, 1926, 1872},
  {1926, 2010, 1928},
  {1763, 1873, 2200},
  {1875, 1813, 2001},
  {1998, 1933, 1934},
  {5947, 1763, 1936},
  {2200, 1936, 1763},
  {1998, 1934, 1937},
  {2007, 1816, 2002},
  {2004, 1873, 1814},
  {2054, 2004, 1814},
  {1814, 1817, 2054},
  {1939, 2054, 1817},
  {2012, 1878, 1876},
  {1714, 2156, 2202},
  {2014, 1944, 1772},
  {1879, 1940, 1941},
  {1879, 1941, 1939},
  {1942, 1944, 2014},
  {1878, 1943, 1945},
  {1878, 1945, 1880},
  {1880, 1945, 1881},
  {1942, 2016, 1944},
  {1944, 1830, 1882},
  {1882, 1830, 1829},
  {1946, 1948, 2016},
  {2016, 1949, 1884},
  {2016, 1884, 1947},
  {2016, 1947, 1944},
  {1948, 1949, 2016},
  {1949, 2019, 1884},
  {1884, 2019, 1947},
  {1947, 2019, 1951},
  {1947, 1951, 1944},
  {1944, 1951, 1830},
  {1830, 1950, 1832},
  {1886, 1832, 1950},
  {1951, 1950, 1830},
  {6416, 1887, 2021},
  {6416, 2065, 6223},
  {1955, 6223, 2065},
  {1890, 6223, 1955},
  {1834, 1777, 1892},
  {2025, 1891, 1837},
  {2167, 1954, 1838},
  {1955, 1956, 1890},
  {6222, 1890, 2069},
  {6222, 2069, 2167},
  {1890, 1956, 2069},
  {1893, 2028, 1958},
  {1781, 1959, 1894},
  {1894, 1959, 1840},
  {1840, 1959, 1895},
  {1895, 1959, 5958},
  {1841, 1960, 1957},
  {1895, 5958, 5846},
  {1895, 5846, 1842},
  {1960, 1780, 2121},
  {1780, 1678, 2030},
  {1780, 2030, 2121},
  {1961, 1842, 2031},
  {1842, 5847, 2031},
  {1842, 5846, 5847},
  {1961, 2076, 1478},
  {1963, 1897, 1962},
  {1965, 1964, 1898},
  {2077, 5845, 6323},
  {1898, 1900, 1966},
  {6323, 5845, 2079},
  {1963, 2032, 1968},
  {1967, 2033, 5959},
  {1791, 1789, 2127},
  {1787, 1906, 1902},
  {1787, 1902, 2033},
  {2033, 1902, 1969},
  {1970, 1907, 1904},
  {1904, 1903, 2034},
  {1904, 2034, 1970},
  {1903, 1971, 2034},
  {1913, 1907, 2129},
  {1903, 1908, 1971},
  {1908, 2035, 1971},
  {1909, 2178, 2475},
  {1913, 6449, 1974},
  {6449, 1973, 1974},
  {1910, 1972, 1850},
  {1910, 1796, 1973},
  {1910, 1973, 1972},
  {1798, 2091, 1911},
  {1851, 1914, 1798},
  {2180, 1975, 1914},
  {2040, 2041, 2088},
  {1972, 2089, 1976},
  {2040, 1852, 1977},
  {2042, 1977, 1852},
  {6135, 2042, 1852},
  {1854, 1979, 2094},
  {1979, 2043, 1980},
  {1855, 2233, 1982},
  {1918, 1982, 1990},
  {1986, 1858, 1991},
  {1647, 1988, 1992},
  {1919, 1985, 1917},
  {1919, 1860, 2047},
  {1860, 1993, 2101},
  {1693, 1922, 1694},
  {1861, 1921, 1993},
  {5957, 6438, 6176},
  {1993, 1921, 2101},
  {1925, 1865, 1920},
  {1923, 1925, 1920},
  {1995, 1996, 2104},
  {5953, 1926, 1928},
  {1996, 1999, 2104},
  {1924, 1871, 1868},
  {1924, 2052, 1871},
  {1929, 1928, 1932},
  {5951, 1932, 1931},
  {1930, 1872, 1866},
  {1866, 1872, 1926},
  {1871, 2052, 1933},
  {1928, 2010, 1932},
  {1813, 1997, 2001},
  {1874, 6479, 2000},
  {1875, 2001, 1876},
  {2003, 1876, 2001},
  {2001, 1998, 1937},
  {1934, 1933, 2005},
  {1934, 2005, 1937},
  {2009, 2000, 6479},
  {2000, 2009, 1872},
  {2010, 1872, 2009},
  {2010, 2006, 1932},
  {2002, 1932, 2006},
  {2001, 1937, 2005},
  {2008, 2110, 2001},
  {2001, 2005, 2008},
  {1767, 2204, 1935},
  {2011, 2010, 2009},
  {2109, 1768, 2007},
  {1876, 5956, 2012},
  {2009, 2055, 2011},
  {1768, 2109, 2111},
  {6454, 1768, 2111},
  {1772, 2111, 2057},
  {1941, 2054, 1939},
  {2012, 2114, 1878},
  {1943, 1878, 2114},
  {1767, 2013, 2204},
  {2014, 1772, 2057},
  {1940, 2202, 2058},
  {1940, 2058, 1941},
  {1828, 2013, 1767},
  {5952, 1945, 1828},
  {1885, 2017, 2162},
  {1885, 2162, 2015},
  {2059, 2018, 2061},
  {1948, 2059, 2061},
  {1948, 2061, 1949},
  {2019, 1949, 2061},
  {1886, 2020, 1887},
  {2021, 1887, 2020},
  {1951, 2063, 1950},
  {2063, 1886, 1950},
  {1886, 2063, 2020},
  {2062, 1951, 2019},
  {1951, 2062, 2063},
  {6416, 2021, 2020},
  {2023, 1834, 2024},
  {2065, 6416, 2020},
  {2025, 1953, 2066},
  {1953, 1889, 2070},
  {1889, 2026, 2070},
  {2026, 1889, 1954},
  {2026, 1954, 2070},
  {1956, 1955, 2065},
  {1834, 1892, 2027},
  {2069, 1956, 2067},
  {1891, 2068, 1893},
  {1893, 2068, 2028},
  {2214, 1892, 1957},
  {1781, 2120, 1959},
  {1957, 1960, 2072},
  {2121, 2072, 1960},
  {2030, 2074, 2073},
  {1962, 2076, 1963},
  {2077, 2074, 1786},
  {2076, 1961, 2123},
  {1961, 2031, 1965},
  {1965, 2031, 1964},
  {1966, 1899, 1964},
  {1898, 1966, 1965},
  {1966, 2080, 1965},
  {1901, 2175, 2276},
  {2032, 2127, 1968},
  {2033, 1969, 1901},
  {1791, 2127, 2083},
  {1907, 1970, 2081},
  {1970, 2034, 2082},
  {1791, 2083, 1792},
  {1792, 2083, 2035},
  {1913, 2129, 2084},
  {2081, 2129, 1907},
  {2475, 2473, 2175},
  {2037, 6117, 2038},
  {2178, 1909, 1911},
  {2178, 1911, 2090},
  {1914, 2091, 1798},
  {2041, 2137, 2088},
  {1973, 6449, 1972},
  {2136, 2090, 1911},
  {2040, 1977, 2089},
  {1976, 2089, 1977},
  {2040, 2089, 2041},
  {2039, 2041, 2089},
  {2042, 1976, 1977},
  {1980, 2043, 2095},
  {1500, 1916, 2043},
  {1983, 1990, 2044},
  {1984, 2046, 1988},
  {1916, 1985, 2187},
  {2045, 1987, 2096},
  {1987, 1989, 2097},
  {1987, 2097, 2096},
  {1987, 2045, 2146},
  {1988, 2046, 1992},
  {1987, 2146, 1693},
  {1919, 2047, 1985},
  {2148, 1985, 2047},
  {1693, 2146, 1922},
  {2048, 1992, 2046},
  {1989, 1992, 2048},
  {1989, 2048, 2098},
  {2049, 1994, 1991},
  {6128, 1922, 6158},
  {1994, 2049, 2050},
  {1995, 2051, 2102},
  {1995, 2102, 2101},
  {2051, 1995, 2104},
  {2154, 2052, 2153},
  {2052, 2154, 1933},
  {1997, 1998, 2001},
  {2005, 1933, 2154},
  {1932, 2002, 1870},
  {2003, 2001, 2110},
  {6479, 2204, 2053},
  {2009, 6479, 2053},
  {2002, 2106, 2007},
  {2200, 1873, 2108},
  {2004, 2108, 1873},
  {2007, 2107, 2109},
  {2054, 2108, 2004},
  {2110, 1938, 2003},
  {2110, 2008, 2201},
  {2053, 2112, 2009},
  {2114, 2012, 1938},
  {1938, 2110, 2114},
  {1828, 2204, 2013},
  {2056, 2011, 2055},
  {2011, 2056, 2113},
  {2011, 2113, 2010},
  {2054, 1941, 2159},
  {2014, 2057, 2208},
  {1821, 2015, 2156},
  {2058, 2159, 1941},
  {2016, 1942, 2208},
  {1942, 2014, 2208},
  {1943, 2160, 1945},
  {1943, 2114, 2160},
  {2059, 1948, 1946},
  {2165, 2060, 2022},
  {2022, 2023, 2165},
  {1834, 2022, 2017},
  {2061, 2116, 2019},
  {2020, 2063, 2065},
  {2022, 1834, 2023},
  {2024, 2027, 2064},
  {2327, 2064, 2027},
  {2024, 1834, 2027},
  {2068, 1891, 2025},
  {2066, 2068, 2025},
  {2070, 2066, 1953},
  {1956, 2065, 2067},
  {2066, 2070, 2071},
  {2167, 2117, 2118},
  {2167, 2069, 2117},
  {2068, 2066, 2028},
  {2066, 2071, 2028},
  {2027, 1892, 2169},
  {2214, 1957, 2072},
  {1781, 1896, 2120},
  {1896, 2029, 2119},
  {2075, 2073, 2074},
  {2077, 2075, 2074},
  {1965, 2123, 1961},
  {2123, 1965, 2124},
  {2031, 2216, 1964},
  {1964, 2078, 1966},
  {2126, 2171, 1965},
  {2127, 2032, 2125},
  {2032, 1963, 2125},
  {1965, 2080, 2126},
  {6321, 6329, 2223},
  {5960, 2172, 2128},
  {2081, 1970, 2130},
  {1970, 2082, 2130},
  {2034, 1971, 2087},
  {2086, 2132, 2085},
  {1971, 2036, 2087},
  {1971, 2035, 6117},
  {2035, 2132, 2038},
  {2035, 2038, 6117},
  {2085, 2132, 2035},
  {2036, 2037, 2087},
  {2038, 2133, 2037},
  {2137, 2135, 2088},
  {6449, 1913, 2135},
  {2091, 2136, 1911},
  {2092, 2039, 2089},
  {2093, 2092, 2089},
  {2092, 2041, 2039},
  {2138, 2041, 2092},
  {2092, 6460, 2138},
  {2094, 1979, 2139},
  {1854, 2094, 2230},
  {1980, 2139, 1979},
  {1854, 2230, 2233},
  {1854, 2233, 1855},
  {5841, 2044, 1990},
  {2096, 2146, 2045},
  {1990, 2147, 5841},
  {5841, 2147, 2046},
  {1985, 2148, 2187},
  {1989, 2098, 2097},
  {2147, 1990, 2290},
  {2046, 2147, 2151},
  {2046, 2151, 2048},
  {2252, 2048, 2151},
  {1860, 2101, 2099},
  {1922, 6128, 2100},
  {1924, 2100, 2152},
  {2251, 2102, 2051},
  {2051, 2104, 2251},
  {2196, 2103, 6385},
  {1924, 2153, 2052},
  {6403, 2196, 5949},
  {6385, 2103, 1999},
  {1812, 5947, 2440},
  {2496, 5947, 1936},
  {2154, 2199, 2005},
  {2200, 2496, 1936},
  {2005, 2199, 2008},
  {2002, 2006, 2106},
  {2105, 2106, 2006},
  {2007, 2106, 2107},
  {2204, 2112, 2053},
  {2006, 2107, 2105},
  {2107, 2155, 2109},
  {2010, 2206, 2006},
  {2108, 2054, 2159},
  {2009, 2112, 2055},
  {2205, 2056, 2055},
  {2208, 2057, 2111},
  {2202, 2158, 2058},
  {2203, 2058, 2158},
  {2156, 2015, 2207},
  {2161, 2207, 2015},
  {1828, 1945, 2160},
  {2261, 1946, 2016},
  {2059, 1946, 2261},
  {2061, 2018, 2115},
  {2115, 2018, 2164},
  {2022, 2060, 2017},
  {1888, 1834, 2017},
  {2116, 2061, 2115},
  {2019, 2116, 2264},
  {2019, 2264, 2062},
  {2064, 2023, 2024},
  {2265, 2063, 2062},
  {2065, 2063, 2265},
  {2062, 2211, 2265},
  {2167, 2070, 1954},
  {2117, 2069, 2065},
  {2117, 2065, 2118},
  {2065, 2069, 2067},
  {2119, 2028, 2071},
  {1892, 2214, 2330},
  {2028, 2119, 1958},
  {1958, 2119, 2029},
  {2217, 2121, 2030},
  {5848, 2031, 5847},
  {2030, 2343, 2217},
  {2122, 2343, 2030},
  {2030, 2073, 2122},
  {2031, 5848, 2216},
  {2073, 2075, 2122},
  {2075, 2077, 2122},
  {2078, 1964, 2216},
  {2076, 2123, 1963},
  {2125, 1963, 2123},
  {2123, 2124, 2125},
  {2171, 2124, 1965},
  {2078, 2219, 1966},
  {6323, 2220, 2077},
  {2033, 1901, 2276},
  {2125, 2124, 2171},
  {2125, 2171, 2127},
  {2127, 2171, 2083},
  {1966, 2219, 2226},
  {1966, 2226, 2080},
  {2172, 6321, 2223},
  {2129, 2081, 2224},
  {2081, 2130, 2224},
  {2080, 2131, 2126},
  {2080, 2177, 2085},
  {2080, 2226, 2177},
  {2129, 2176, 2084},
  {2082, 2034, 2174},
  {2131, 2085, 2083},
  {2131, 2080, 2085},
  {2083, 2085, 2035},
  {2176, 2134, 1913},
  {2176, 1913, 2084},
  {2034, 2087, 2174},
  {2038, 2132, 2133},
  {2180, 2088, 2134},
  {1913, 2134, 2135},
  {2133, 2087, 2037},
  {2178, 2090, 2179},
  {2181, 2179, 2090},
  {2088, 2135, 2134},
  {2180, 2228, 1975},
  {2135, 2137, 6449},
  {2138, 2137, 2041},
  {2137, 2138, 6449},
  {6449, 2138, 5961},
  {2139, 1980, 2140},
  {2095, 2140, 1980},
  {2141, 2232, 2140},
  {2142, 2141, 2095},
  {2141, 2140, 2095},
  {2142, 2095, 2185},
  {2095, 2043, 1916},
  {2185, 2095, 2144},
  {2185, 2144, 2143},
  {2095, 1916, 2187},
  {1982, 2233, 2290},
  {2096, 2145, 2146},
  {2147, 2290, 2151},
  {2146, 2241, 2149},
  {2146, 2149, 1922},
  {2047, 2191, 2148},
  {2047, 1860, 2192},
  {2047, 2192, 2191},
  {2149, 2193, 1922},
  {2149, 2150, 2193},
  {1860, 2099, 2192},
  {2247, 2048, 2195},
  {2048, 2247, 2098},
  {1922, 2193, 6158},
  {5964, 2048, 2252},
  {2195, 2048, 2194},
  {6158, 2193, 6129},
  {2101, 2102, 2251},
  {1924, 2152, 2153},
  {5962, 6248, 6249},
  {1999, 2103, 2197},
  {2440, 5947, 2496},
  {1999, 2198, 2104},
  {2008, 2199, 2253},
  {2008, 2253, 2201},
  {2105, 2107, 2106},
  {2155, 2107, 2206},
  {2006, 2206, 2107},
  {2108, 2159, 2157},
  {2111, 2109, 2256},
  {2109, 2155, 2256},
  {2157, 2159, 2203},
  {2159, 2058, 2203},
  {2160, 2114, 2110},
  {2205, 2055, 2112},
  {2113, 2056, 2205},
  {2206, 2010, 2113},
  {2160, 2204, 1828},
  {2208, 2261, 2016},
  {2015, 2162, 2161},
  {2164, 2018, 2261},
  {2018, 2059, 2261},
  {2163, 2017, 2060},
  {2310, 2210, 2164},
  {2060, 2165, 2163},
  {2164, 2263, 2115},
  {2064, 2327, 2023},
  {2062, 2264, 2211},
  {2065, 2166, 2118},
  {2065, 2265, 2212},
  {2065, 2212, 2166},
  {2027, 2169, 2327},
  {2071, 2070, 2267},
  {2167, 2118, 2168},
  {2071, 2267, 2119},
  {2169, 1892, 2330},
  {2072, 2215, 2214},
  {2072, 2121, 2215},
  {2401, 2214, 2215},
  {2078, 2216, 2170},
  {2221, 2077, 2220},
  {2077, 2221, 2122},
  {2276, 2275, 2033},
  {2171, 2126, 2131},
  {6323, 2222, 2220},
  {2171, 2131, 2083},
  {2128, 2172, 2222},
  {2129, 2224, 2173},
  {2130, 2082, 2224},
  {2082, 2174, 2224},
  {2176, 2173, 2225},
  {2176, 2129, 2173},
  {2419, 2086, 2226},
  {2086, 2177, 2226},
  {2086, 2085, 2177},
  {2419, 2132, 2086},
  {2134, 2176, 2227},
  {2419, 2133, 2132},
  {2475, 2178, 2179},
  {2133, 2419, 2087},
  {2179, 2181, 2229},
  {2136, 2181, 2090},
  {2136, 2091, 2181},
  {2277, 2181, 2091},
  {2228, 5963, 1975},
  {1914, 1975, 2277},
  {2182, 2277, 1975},
  {2183, 2094, 2139},
  {2184, 2094, 2183},
  {2231, 2139, 2140},
  {2232, 2231, 2140},
  {2185, 2141, 2142},
  {2185, 2143, 2186},
  {2144, 2095, 2187},
  {2144, 2186, 2143},
  {2186, 2144, 2188},
  {2144, 2284, 2188},
  {2284, 2144, 2187},
  {2096, 2097, 2098},
  {2188, 2284, 2189},
  {2187, 2148, 2191},
  {1990, 1982, 2290},
  {2149, 2241, 2242},
  {2149, 2242, 2190},
  {2098, 2243, 2365},
  {2149, 2190, 2150},
  {2192, 2099, 2289},
  {2291, 6287, 6446},
  {2291, 6446, 2246},
  {2099, 2101, 2289},
  {2151, 2290, 2250},
  {2247, 2195, 2248},
  {2291, 2100, 6287},
  {6287, 2100, 6127},
  {2252, 2151, 2249},
  {2194, 2248, 2195},
  {2198, 2251, 2104},
  {2154, 2298, 2199},
  {2108, 2157, 2200},
  {2157, 2203, 2200},
  {2204, 2257, 2112},
  {2156, 2207, 2202},
  {2110, 2201, 2160},
  {2202, 2388, 2254},
  {2202, 2254, 2158},
  {2158, 2254, 2203},
  {2203, 2254, 2255},
  {2112, 2448, 2205},
  {2205, 2258, 2113},
  {2113, 2258, 2206},
  {2111, 2260, 2208},
  {2162, 2259, 2161},
  {2017, 2259, 2162},
  {2165, 2209, 2163},
  {2163, 2209, 2017},
  {2169, 2213, 2327},
  {2214, 2401, 2269},
  {2119, 2518, 1896},
  {2215, 2274, 2401},
  {1896, 2335, 2273},
  {1896, 2273, 2216},
  {2121, 2217, 2274},
  {2218, 2170, 2216},
  {2078, 2170, 2344},
  {2410, 2033, 2275},
  {2468, 2276, 2175},
  {2223, 2220, 2222},
  {2172, 2223, 2222},
  {2224, 2174, 2417},
  {2416, 2225, 2173},
  {2412, 2419, 2226},
  {2174, 2087, 2419},
  {2176, 2225, 2227},
  {2229, 2349, 2179},
  {2179, 2349, 2475},
  {2180, 2134, 2227},
  {2180, 2227, 2228},
  {2181, 2277, 2229},
  {1914, 2277, 2091},
  {2183, 2355, 2184},
  {2184, 2355, 2094},
  {2094, 2355, 2230},
  {2139, 2231, 2183},
  {2141, 2185, 2232},
  {2237, 2234, 2235},
  {2237, 2235, 2236},
  {2096, 2430, 2145},
  {2145, 2485, 2146},
  {2241, 2146, 2485},
  {2188, 2189, 2239},
  {2244, 2239, 2189},
  {2244, 2189, 2284},
  {2245, 2285, 2187},
  {2187, 2191, 2245},
  {2096, 2098, 2365},
  {2287, 2190, 2242},
  {2245, 2191, 2192},
  {2190, 2287, 2150},
  {2247, 2243, 2098},
  {2150, 2287, 2246},
  {2246, 6446, 2150},
  {2377, 2250, 2290},
  {2251, 2289, 2101},
  {2151, 2250, 2249},
  {2249, 2295, 2252},
  {2196, 6403, 2296},
  {2196, 2296, 2103},
  {2103, 2296, 2197},
  {2154, 2153, 2298},
  {2496, 2200, 2388},
  {2388, 2202, 2301},
  {2203, 2255, 2200},
  {2201, 2204, 2160},
  {2305, 2202, 2207},
  {2204, 2304, 2257},
  {2307, 2111, 2256},
  {2161, 2305, 2207},
  {2261, 2208, 2391},
  {2208, 2260, 2309},
  {2164, 2261, 2310},
  {2723, 2017, 2209},
  {2209, 2165, 2723},
  {2164, 2210, 2263},
  {2263, 2315, 2115},
  {2115, 2315, 2116},
  {2212, 2265, 2266},
  {2266, 2265, 2461},
  {2212, 2266, 2461},
  {2212, 2461, 2166},
  {2118, 2166, 2461},
  {2118, 2461, 2326},
  {2326, 2168, 2118},
  {2268, 2213, 2169},
  {2327, 2213, 2268},
  {2269, 2401, 2270},
  {2331, 2269, 2270},
  {2270, 2403, 2329},
  {2335, 2271, 2273},
  {2272, 2337, 2273},
  {2215, 2121, 2274},
  {2405, 1896, 2518},
  {2342, 2216, 2273},
  {2401, 2274, 2217},
  {2216, 2342, 2218},
  {2170, 2218, 2344},
  {2218, 2342, 2344},
  {2078, 2344, 2219},
  {2122, 2221, 2345},
  {2220, 2223, 2033},
  {2220, 2033, 2221},
  {2221, 2033, 2345},
  {2033, 2410, 2345},
  {2468, 2175, 2523},
  {2173, 2224, 2416},
  {2225, 2416, 2346},
  {2225, 2346, 2347},
  {2475, 2476, 2473},
  {2347, 2227, 2225},
  {2347, 2418, 2227},
  {2228, 2227, 2351},
  {2182, 2353, 2277},
  {2355, 2278, 2230},
  {2278, 2356, 2425},
  {2278, 2425, 2230},
  {2183, 2231, 2355},
  {2426, 2233, 2230},
  {2426, 2279, 2233},
  {2237, 2233, 2279},
  {2360, 2232, 2185},
  {2280, 2237, 2279},
  {2280, 2281, 2234},
  {2359, 2234, 2281},
  {2234, 2359, 2235},
  {2235, 2282, 2236},
  {2235, 2359, 2282},
  {2361, 2236, 2282},
  {2360, 2185, 2362},
  {2185, 2186, 2362},
  {2280, 2234, 2237},
  {2233, 2237, 2290},
  {2236, 2283, 2237},
  {2236, 2361, 2283},
  {2283, 2238, 2237},
  {2283, 2364, 2238},
  {2237, 2238, 2240},
  {2186, 2188, 2239},
  {2238, 2366, 2240},
  {2430, 2485, 2145},
  {2187, 2285, 2284},
  {2241, 2485, 2286},
  {2241, 2286, 2242},
  {2244, 2284, 2370},
  {2244, 2370, 2288},
  {2247, 2365, 2243},
  {2242, 2286, 2287},
  {2374, 2245, 2192},
  {2286, 2246, 2287},
  {2244, 2288, 2376},
  {2192, 2289, 2374},
  {2288, 2293, 2292},
  {2291, 2294, 2100},
  {2295, 2250, 2377},
  {2379, 2292, 2293},
  {2250, 2295, 2249},
  {2152, 2100, 2294},
  {2294, 2490, 2152},
  {2381, 2252, 2295},
  {2382, 2252, 2381},
  {2490, 2153, 2152},
  {2384, 2252, 2382},
  {2252, 2384, 2194},
  {1999, 2443, 2198},
  {2297, 2300, 2299},
  {6372, 2300, 2385},
  {2297, 2385, 2300},
  {2199, 2298, 2253},
  {2388, 2200, 2302},
  {2253, 2298, 2387},
  {2253, 2387, 2201},
  {2201, 2387, 2204},
  {2205, 6372, 2258},
  {2202, 2558, 2301},
  {2302, 2200, 2255},
  {2303, 2155, 2206},
  {2256, 2155, 2303},
  {2305, 2558, 2202},
  {2254, 2388, 2302},
  {2254, 2302, 2255},
  {2256, 2206, 2390},
  {2206, 2256, 2303},
  {2304, 2449, 2257},
  {2112, 2257, 2448},
  {2308, 2161, 2259},
  {2306, 2260, 2111},
  {2111, 2307, 2306},
  {2017, 2308, 2259},
  {2260, 2306, 2455},
  {2310, 2261, 2451},
  {2455, 2309, 2260},
  {2210, 2310, 2262},
  {2262, 2310, 2456},
  {2262, 2456, 2210},
  {2608, 2313, 2210},
  {2456, 2608, 2210},
  {2313, 2263, 2210},
  {2313, 2315, 2263},
  {2321, 2314, 2394},
  {2318, 2321, 2394},
  {2311, 2316, 2392},
  {2392, 2316, 2312},
  {2312, 2316, 2317},
  {2315, 2313, 2508},
  {2315, 2508, 2116},
  {2311, 2314, 2321},
  {2311, 2321, 2316},
  {2316, 2319, 2317},
  {2317, 2319, 2396},
  {2165, 2023, 2610},
  {2316, 2321, 2319},
  {2319, 2320, 2396},
  {2264, 2398, 2211},
  {2319, 2322, 2320},
  {2320, 2322, 2397},
  {2323, 2322, 2324},
  {2023, 2327, 2610},
  {2511, 2610, 2327},
  {2319, 2321, 2322},
  {2324, 2322, 2321},
  {2211, 2461, 2265},
  {2324, 2325, 2323},
  {2323, 2325, 2462},
  {2510, 2070, 2167},
  {2168, 2510, 2167},
  {2321, 2514, 2399},
  {2328, 2321, 2332},
  {2321, 2328, 2324},
  {2324, 2328, 2325},
  {2321, 2399, 2332},
  {2332, 2329, 2328},
  {2329, 2333, 2328},
  {2330, 2214, 2514},
  {2214, 2269, 2514},
  {2269, 2331, 2514},
  {2331, 2270, 2332},
  {2270, 2329, 2332},
  {2329, 2406, 2333},
  {2333, 2336, 2338},
  {2333, 2338, 2328},
  {2328, 2338, 2334},
  {2329, 2403, 2339},
  {2329, 2339, 2406},
  {2333, 2406, 2336},
  {2336, 2407, 2338},
  {2335, 2402, 2272},
  {2272, 2402, 2337},
  {2401, 2403, 2270},
  {2406, 2407, 2336},
  {2518, 2465, 2405},
  {2273, 2337, 2342},
  {2340, 2338, 2407},
  {2338, 2340, 2334},
  {2341, 2334, 2340},
  {2407, 2341, 2340},
  {2343, 2122, 2345},
  {2409, 2219, 2344},
  {2468, 2275, 2276},
  {2226, 2470, 2412},
  {2416, 2224, 2348},
  {2224, 2417, 2348},
  {2475, 2349, 2350},
  {2349, 2229, 2352},
  {2349, 2352, 2350},
  {2227, 2418, 2351},
  {2229, 2530, 2352},
  {2229, 2421, 2530},
  {2229, 2277, 2421},
  {2228, 2626, 5963},
  {2353, 5963, 2626},
  {2277, 2353, 2354},
  {2278, 2355, 2356},
  {2231, 2357, 2355},
  {2230, 2425, 2426},
  {2231, 2232, 2357},
  {2357, 2484, 2425},
  {2279, 5966, 2280},
  {2232, 2360, 2357},
  {2282, 2359, 2361},
  {2281, 2583, 2359},
  {2361, 2363, 2283},
  {2283, 2363, 2364},
  {2238, 2364, 2366},
  {2096, 2365, 2430},
  {2237, 2240, 2435},
  {2240, 2366, 2435},
  {2284, 2285, 2370},
  {2435, 2366, 2367},
  {2368, 2367, 2366},
  {2370, 2285, 2245},
  {2367, 2369, 2435},
  {2367, 2368, 2369},
  {2770, 2369, 2368},
  {2365, 2247, 2540},
  {2286, 2433, 2246},
  {2239, 2244, 2372},
  {2370, 2245, 2374},
  {2435, 2369, 2371},
  {2435, 2371, 2373},
  {2369, 2770, 2371},
  {2246, 2433, 2291},
  {2244, 2376, 2372},
  {2370, 2374, 2288},
  {2435, 2373, 2375},
  {2371, 2770, 2373},
  {2288, 2374, 2293},
  {2374, 2289, 2378},
  {2251, 2378, 2289},
  {2293, 2374, 2379},
  {2378, 2379, 2374},
  {2380, 2379, 2378},
  {2378, 2251, 2380},
  {2248, 2194, 2438},
  {2296, 6403, 2383},
  {2153, 2490, 2493},
  {2296, 2383, 2197},
  {2197, 2596, 1999},
  {2198, 2443, 2442},
  {6373, 2385, 2297},
  {2385, 2258, 6372},
  {2388, 2301, 2386},
  {2387, 2389, 2204},
  {2304, 2204, 2389},
  {6372, 2205, 2448},
  {2449, 2448, 2257},
  {2161, 2450, 2305},
  {2161, 2308, 2450},
  {2017, 2450, 2308},
  {2451, 2261, 2391},
  {2390, 2455, 2256},
  {2453, 2256, 2455},
  {2256, 2453, 2307},
  {2208, 2309, 2502},
  {2310, 2451, 2454},
  {2307, 2455, 2306},
  {2456, 2310, 2503},
  {2311, 2392, 2314},
  {2394, 2314, 2392},
  {2505, 2392, 2312},
  {2608, 2393, 2313},
  {2264, 2458, 2395},
  {2393, 2508, 2313},
  {2508, 2264, 2116},
  {2320, 2562, 2396},
  {2264, 2395, 2398},
  {2320, 2397, 2562},
  {2322, 2323, 2397},
  {2398, 2461, 2211},
  {2514, 2321, 2318},
  {2168, 2326, 2510},
  {2513, 2400, 2268},
  {2268, 2169, 2513},
  {2327, 2268, 2400},
  {2399, 2514, 2332},
  {2331, 2332, 2514},
  {2119, 2267, 2567},
  {2119, 2567, 2518},
  {2335, 2463, 2402},
  {2334, 2341, 2404},
  {1896, 2405, 2463},
  {1896, 2463, 2335},
  {2402, 2463, 2337},
  {2342, 2337, 2463},
  {2342, 2463, 2405},
  {2401, 2217, 2521},
  {2407, 2406, 2408},
  {2341, 2407, 2404},
  {2405, 2344, 2342},
  {2407, 2408, 2404},
  {2516, 2404, 2408},
  {2344, 2405, 2409},
  {2217, 2345, 2521},
  {2217, 2343, 2345},
  {2411, 2415, 2413},
  {2174, 2477, 2417},
  {2413, 2415, 2414},
  {2418, 2347, 2474},
  {2347, 2346, 2474},
  {2174, 2419, 2477},
  {2474, 2416, 2348},
  {2350, 2530, 2475},
  {2350, 2352, 2530},
  {2348, 2420, 2474},
  {2422, 2474, 2420},
  {2421, 2277, 2478},
  {2351, 2626, 2228},
  {2423, 2478, 2277},
  {2423, 2277, 2480},
  {2356, 2355, 2425},
  {2355, 2357, 2425},
  {6169, 2425, 2484},
  {2358, 2428, 6170},
  {6169, 2427, 5966},
  {2280, 5966, 2700},
  {2363, 2361, 2359},
  {2362, 2429, 2360},
  {2357, 2360, 2429},
  {2362, 2186, 5967},
  {2364, 2432, 2366},
  {2365, 2431, 2430},
  {2239, 2372, 2640},
  {2237, 2435, 2290},
  {2368, 2366, 2432},
  {2365, 2540, 2431},
  {2485, 2433, 2286},
  {2486, 2540, 2247},
  {2770, 2436, 2373},
  {2291, 2433, 2434},
  {2436, 2375, 2373},
  {2372, 2376, 2593},
  {2290, 2435, 2377},
  {2435, 2375, 2437},
  {2248, 2486, 2247},
  {2288, 2593, 2376},
  {2375, 2295, 2437},
  {2295, 2377, 2437},
  {2381, 2295, 2375},
  {2375, 2436, 2487},
  {2375, 2487, 2381},
  {2292, 2379, 2776},
  {2379, 2380, 2776},
  {2381, 2487, 2382},
  {2380, 2251, 2776},
  {2194, 2439, 2438},
  {2384, 2439, 2194},
  {2251, 2198, 2441},
  {2384, 2382, 2491},
  {2384, 2491, 2439},
  {2383, 2596, 2197},
  {2496, 2648, 2440},
  {2596, 2443, 1999},
  {2198, 2442, 2441},
  {2153, 2548, 2298},
  {6372, 2444, 5965},
  {2387, 2298, 2446},
  {6372, 2602, 2603},
  {2445, 2385, 6373},
  {2387, 2446, 2389},
  {2558, 2386, 2301},
  {2386, 2553, 2388},
  {2258, 2385, 2500},
  {2445, 2500, 2385},
  {2389, 2446, 2304},
  {2447, 2304, 2446},
  {2449, 2304, 2447},
  {2258, 2500, 2206},
  {2390, 2452, 2455},
  {2452, 2502, 2309},
  {2455, 2452, 2309},
  {2454, 2503, 2310},
  {2453, 2455, 2307},
  {2392, 2504, 2394},
  {2457, 2393, 2608},
  {2457, 2459, 2393},
  {2393, 2459, 2508},
  {2396, 2562, 2317},
  {2561, 2460, 2395},
  {2264, 2508, 2563},
  {2395, 2460, 2398},
  {2397, 2323, 2509},
  {2398, 2460, 2461},
  {2460, 2802, 2461},
  {2462, 2509, 2323},
  {2325, 2328, 2462},
  {2461, 2510, 2326},
  {2512, 2511, 2327},
  {2327, 2400, 2512},
  {2400, 2513, 2512},
  {2401, 2521, 2403},
  {2521, 2464, 2403},
  {2403, 2464, 2339},
  {2464, 2570, 2339},
  {2465, 2573, 2405},
  {2466, 2405, 2573},
  {2405, 2466, 2409},
  {2219, 2409, 2466},
  {2466, 5968, 2469},
  {2275, 2468, 2410},
  {2219, 2466, 2619},
  {2619, 2226, 2219},
  {2411, 2471, 2472},
  {2522, 2472, 2471},
  {2470, 2226, 2619},
  {2411, 2413, 2526},
  {2411, 2472, 2415},
  {2416, 2474, 2346},
  {2578, 2414, 2415},
  {2175, 2473, 2523},
  {2417, 2477, 2348},
  {2477, 2419, 2527},
  {2579, 2351, 2418},
  {2422, 2479, 2474},
  {2423, 2480, 2478},
  {2479, 2422, 2529},
  {2480, 2277, 2687},
  {2626, 2354, 2353},
  {2481, 2354, 2626},
  {2277, 2354, 2687},
  {2425, 6169, 6171},
  {6169, 2484, 2427},
  {2427, 2700, 5966},
  {2483, 2359, 2533},
  {2357, 2534, 2484},
  {2427, 2484, 2700},
  {2533, 2359, 2583},
  {2359, 2483, 2363},
  {2429, 2534, 2357},
  {2280, 2587, 2281},
  {2432, 2364, 2363},
  {2239, 2640, 2186},
  {2430, 2538, 2485},
  {2539, 2430, 2431},
  {2432, 2770, 2368},
  {2540, 2539, 2431},
  {2433, 2485, 2434},
  {2485, 2541, 2434},
  {2593, 2640, 2372},
  {2437, 2377, 2435},
  {2288, 2292, 2776},
  {2248, 2438, 2643},
  {2248, 2643, 2486},
  {2487, 2543, 2382},
  {2294, 2291, 2490},
  {2438, 2439, 2492},
  {2596, 2383, 6403},
  {2382, 2543, 2491},
  {2491, 2492, 2439},
  {2441, 2442, 2546},
  {2787, 2443, 2596},
  {2442, 2443, 2546},
  {2495, 2550, 6372},
  {6372, 2445, 2444},
  {2298, 2548, 2446},
  {2557, 2446, 2548},
  {2495, 6372, 2448},
  {2602, 6372, 2550},
  {2445, 6372, 2603},
  {2556, 2498, 2551},
  {2500, 2445, 2497},
  {2497, 2498, 2500},
  {2558, 2604, 2386},
  {2554, 2386, 2604},
  {2386, 2554, 2553},
  {2447, 2446, 2557},
  {2447, 2557, 2449},
  {2305, 2450, 2558},
  {2390, 2206, 2501},
  {2390, 2501, 2452},
  {2017, 2559, 2450},
  {2391, 2208, 2502},
  {2501, 2502, 2452},
  {2504, 2318, 2394},
  {2506, 2457, 2608},
  {2165, 2610, 2795},
  {2312, 2317, 2505},
  {2317, 2562, 2505},
  {2506, 2507, 2457},
  {2457, 2507, 2459},
  {2458, 2563, 2395},
  {2507, 2508, 2459},
  {2264, 2563, 2458},
  {2460, 2561, 2802},
  {2509, 2562, 2397},
  {2508, 2732, 2563},
  {2461, 2802, 2510},
  {2564, 6339, 6338},
  {2462, 2328, 2562},
  {2070, 2510, 2733},
  {2733, 2267, 2070},
  {2514, 2169, 2330},
  {2328, 2334, 2562},
  {2334, 2515, 2562},
  {2334, 2404, 2515},
  {2404, 2516, 2515},
  {2516, 2517, 2515},
  {2521, 2570, 2464},
  {2408, 2406, 2516},
  {2517, 2516, 2406},
  {2520, 2519, 2471},
  {2467, 2466, 2573},
  {2471, 2519, 2522},
  {2572, 2522, 2519},
  {2619, 2466, 2469},
  {2744, 2619, 2469},
  {2616, 2410, 2468},
  {2411, 2526, 2471},
  {2472, 2522, 2415},
  {2524, 2575, 2527},
  {2523, 2473, 2525},
  {2527, 2412, 2524},
  {2413, 2414, 2526},
  {2577, 2525, 2473},
  {2419, 2412, 2527},
  {2414, 2578, 2576},
  {2476, 2475, 2530},
  {2473, 2476, 2577},
  {2527, 2348, 2477},
  {6457, 2528, 6456},
  {6456, 2528, 6457},
  {2420, 2348, 2581},
  {2420, 2581, 2422},
  {2474, 2479, 2580},
  {2530, 2421, 2478},
  {2479, 2529, 2581},
  {2479, 2581, 2580},
  {2422, 2581, 6191},
  {2422, 6190, 2529},
  {2687, 2354, 2481},
  {2481, 2482, 2532},
  {2481, 2532, 2531},
  {6194, 5969, 6195},
  {2482, 2582, 2532},
  {2429, 2186, 2695},
  {2583, 2281, 2587},
  {2483, 2766, 2363},
  {2534, 2585, 2484},
  {2585, 2535, 2484},
  {2536, 2484, 2535},
  {2484, 2536, 2700},
  {2587, 2280, 2586},
  {2537, 2280, 2588},
  {2586, 2280, 2537},
  {2538, 2636, 2485},
  {2590, 2700, 2536},
  {2430, 2539, 2538},
  {2589, 2485, 2637},
  {2432, 2766, 2770},
  {2485, 2589, 2541},
  {2541, 2291, 2434},
  {2776, 2593, 2288},
  {2541, 2642, 2488},
  {2487, 2777, 2594},
  {2487, 2594, 2543},
  {2291, 2647, 2490},
  {2541, 2488, 2489},
  {2488, 6377, 2542},
  {2488, 2542, 2489},
  {2776, 2251, 2708},
  {2542, 6377, 6266},
  {2492, 2544, 2438},
  {2647, 2493, 2490},
  {2489, 2542, 6266},
  {2596, 6403, 2648},
  {2251, 2441, 2708},
  {2491, 2543, 2492},
  {2544, 2492, 2543},
  {2547, 2493, 2647},
  {2493, 2547, 2153},
  {2494, 2599, 2495},
  {2600, 2546, 2443},
  {2153, 2547, 2548},
  {2495, 2549, 2494},
  {2601, 2550, 2495},
  {2448, 2549, 2495},
  {2388, 2553, 2496},
  {2603, 2602, 2550},
  {2551, 2552, 2556},
  {2549, 2448, 2555},
  {2445, 2603, 2497},
  {2497, 2603, 2498},
  {2499, 2449, 2557},
  {2557, 2555, 2499},
  {2498, 2556, 2500},
  {2449, 2499, 2555},
  {2555, 2448, 2449},
  {2206, 2500, 2501},
  {2605, 2558, 2450},
  {2451, 2391, 2502},
  {2723, 2853, 2017},
  {2456, 2503, 2607},
  {2504, 2392, 2654},
  {2392, 2560, 2654},
  {2560, 2392, 2505},
  {2608, 2659, 2506},
  {2794, 2507, 2506},
  {2563, 2732, 2395},
  {2794, 2508, 2507},
  {2509, 2462, 2562},
  {2318, 2795, 2514},
  {2565, 2610, 2511},
  {2511, 2512, 2565},
  {2512, 2513, 2566},
  {2512, 2566, 2565},
  {2514, 2513, 2169},
  {2515, 2517, 2568},
  {2569, 2519, 2611},
  {2518, 2612, 2465},
  {2568, 2517, 2406},
  {2519, 2569, 2572},
  {2613, 2467, 2573},
  {2469, 6080, 2744},
  {2468, 2523, 2616},
  {2617, 2743, 2524},
  {2524, 2743, 2575},
  {2524, 2412, 2617},
  {2412, 2470, 2574},
  {2748, 2574, 2470},
  {2618, 2415, 2522},
  {2523, 2525, 2746},
  {2621, 2746, 2525},
  {2576, 2471, 2526},
  {2526, 2414, 2576},
  {2415, 2618, 2578},
  {2525, 2577, 2621},
  {2576, 2578, 2676},
  {2576, 2676, 2624},
  {2476, 2675, 2577},
  {2579, 2626, 2351},
  {2478, 2480, 2687},
  {2580, 2581, 2627},
  {2581, 2529, 2424},
  {2530, 2478, 2687},
  {2626, 2680, 2481},
  {2628, 2481, 2680},
  {2755, 2481, 2628},
  {2481, 2755, 2482},
  {2531, 2532, 2629},
  {2482, 2755, 2582},
  {2532, 2582, 2629},
  {2693, 2533, 2583},
  {2583, 2587, 2630},
  {2584, 2429, 2695},
  {2429, 2584, 2534},
  {2764, 2534, 2584},
  {2534, 2764, 2634},
  {2534, 2634, 2585},
  {2585, 2635, 2535},
  {2639, 2280, 2700},
  {2633, 2537, 2588},
  {2537, 2633, 2586},
  {2587, 2586, 2633},
  {2363, 2766, 2432},
  {2637, 2485, 2636},
  {2638, 2535, 2635},
  {2535, 2638, 2536},
  {2536, 2638, 2590},
  {2590, 2641, 2700},
  {2280, 2639, 2588},
  {2591, 2538, 2539},
  {2636, 2538, 2591},
  {2592, 2539, 2540},
  {2436, 2770, 2774},
  {2487, 2436, 2777},
  {2643, 2438, 2779},
  {2291, 2541, 2647},
  {2488, 2642, 6377},
  {2541, 2489, 2647},
  {2544, 2595, 2438},
  {2779, 2438, 2595},
  {5970, 2706, 2645},
  {2543, 2595, 2544},
  {2489, 6266, 2598},
  {2599, 2647, 2601},
  {2489, 2598, 2601},
  {2494, 2549, 2599},
  {2599, 2601, 2495},
  {2441, 2546, 2600},
  {2710, 2443, 2787},
  {2443, 2710, 2600},
  {2547, 2647, 2548},
  {2549, 2548, 2647},
  {2603, 2550, 2601},
  {2649, 2552, 2551},
  {2548, 2549, 2557},
  {2555, 2557, 2549},
  {2498, 2603, 2551},
  {2552, 2649, 2556},
  {2556, 2713, 2500},
  {2500, 2713, 2501},
  {2450, 2559, 2605},
  {2017, 2605, 2559},
  {2501, 6442, 2502},
  {6442, 2653, 2722},
  {2657, 2451, 2502},
  {6442, 2655, 2502},
  {2606, 6441, 5971},
  {2454, 2607, 2503},
  {2454, 2451, 2607},
  {2451, 2658, 2852},
  {2451, 2657, 2658},
  {2720, 2504, 2654},
  {2165, 2795, 2723},
  {2318, 2504, 2795},
  {2659, 2725, 2506},
  {2725, 2794, 2506},
  {2561, 2395, 2800},
  {2800, 2395, 2732},
  {2906, 2802, 2561},
  {2514, 2795, 2566},
  {2610, 2565, 2566},
  {2514, 2566, 2513},
  {2562, 2515, 2660},
  {2267, 2662, 2567},
  {2515, 2568, 2660},
  {2664, 2611, 5849},
  {2611, 2519, 5849},
  {2611, 2665, 2569},
  {2612, 2518, 2567},
  {2521, 2982, 2570},
  {2568, 2406, 2571},
  {2571, 2406, 2669},
  {2612, 2573, 2465},
  {2520, 2812, 5849},
  {6094, 2614, 6093},
  {5972, 2615, 5973},
  {6094, 6093, 2614},
  {5972, 5973, 2615},
  {2412, 2574, 2617},
  {2748, 2617, 2574},
  {2520, 2471, 2812},
  {2746, 2410, 2616},
  {2616, 2523, 2746},
  {2470, 2619, 2748},
  {2471, 2576, 2812},
  {2620, 2619, 2744},
  {2744, 2622, 2620},
  {2618, 2673, 2578},
  {2675, 2621, 2577},
  {2527, 2672, 2348},
  {2348, 2623, 2581},
  {2418, 2474, 2579},
  {2580, 2579, 2474},
  {2676, 2674, 2624},
  {2476, 2530, 2677},
  {2476, 2677, 2675},
  {2679, 2581, 2625},
  {2580, 2678, 2579},
  {2581, 2679, 2627},
  {2530, 2685, 2686},
  {2530, 2686, 2752},
  {2530, 2687, 2685},
  {2481, 2531, 2687},
  {2629, 2582, 2755},
  {2630, 2693, 2583},
  {2757, 2693, 2630},
  {2693, 2631, 2533},
  {2483, 2533, 2631},
  {2632, 2584, 2695},
  {2585, 2634, 2697},
  {2585, 2697, 2635},
  {2637, 2698, 2589},
  {2589, 2698, 2699},
  {2638, 2641, 2590},
  {2591, 2539, 2636},
  {2592, 2636, 2539},
  {2636, 2592, 2637},
  {2637, 2592, 2701},
  {2777, 2436, 2774},
  {2486, 2704, 2540},
  {2540, 2704, 2592},
  {2486, 2643, 2704},
  {2705, 2594, 2777},
  {2643, 2779, 2778},
  {2594, 2705, 2646},
  {2779, 2595, 2644},
  {2594, 2646, 2543},
  {2595, 2543, 2782},
  {2644, 2595, 2782},
  {2545, 2597, 2784},
  {2598, 2545, 2784},
  {2597, 2545, 6376},
  {2597, 6376, 2784},
  {2782, 2543, 2646},
  {2601, 2647, 2489},
  {2599, 2549, 2647},
  {2600, 2708, 2441},
  {2648, 2496, 2553},
  {2554, 2711, 2553},
  {2554, 2604, 2711},
  {2556, 2649, 2650},
  {2556, 2650, 2713},
  {2604, 2558, 2651},
  {2652, 2655, 2714},
  {2713, 6442, 2501},
  {2655, 2652, 2716},
  {2605, 2017, 2719},
  {6442, 2717, 2653},
  {2502, 2655, 2656},
  {2502, 2656, 2657},
  {2654, 2724, 2720},
  {2655, 6442, 2722},
  {2607, 2451, 2852},
  {2456, 2727, 2608},
  {2456, 2607, 2727},
  {2726, 2727, 2607},
  {2609, 2906, 2561},
  {2561, 2800, 2609},
  {2508, 2794, 2732},
  {2795, 2610, 2566},
  {2562, 2660, 2661},
  {2733, 2510, 2802},
  {2662, 2267, 2733},
  {2663, 2567, 2662},
  {2664, 2665, 2611},
  {2661, 2804, 2666},
  {2660, 2568, 2735},
  {2739, 2667, 2664},
  {2739, 2664, 5849},
  {2666, 2804, 2668},
  {2812, 2740, 5849},
  {2811, 2568, 2571},
  {2669, 2811, 2571},
  {2570, 2982, 2339},
  {2339, 2982, 2406},
  {2669, 2406, 2670},
  {6324, 2744, 6080},
  {2345, 2745, 2521},
  {2747, 2527, 2575},
  {2619, 2620, 2748},
  {6444, 6443, 2671},
  {2527, 2747, 2672},
  {2620, 2622, 2748},
  {2348, 2672, 2623},
  {2581, 2623, 2625},
  {2623, 2672, 2625},
  {2625, 2672, 2679},
  {2579, 2678, 2626},
  {2580, 2935, 2678},
  {2580, 2627, 2935},
  {2627, 2679, 2935},
  {2530, 2822, 2677},
  {2626, 2678, 2680},
  {2678, 2681, 2680},
  {2680, 2681, 2683},
  {2681, 2753, 2683},
  {6359, 2679, 2682},
  {6359, 2682, 2684},
  {2680, 2683, 2753},
  {2823, 2685, 2687},
  {2687, 2531, 2872},
  {2690, 2872, 2531},
  {2531, 2629, 2690},
  {2755, 2690, 2629},
  {2692, 2757, 2630},
  {2693, 2757, 2631},
  {2631, 2757, 2760},
  {2631, 2760, 2879},
  {2631, 2879, 2483},
  {2632, 2831, 2584},
  {2692, 2630, 2633},
  {2587, 2633, 2630},
  {2584, 2831, 2764},
  {2692, 2633, 2759},
  {2765, 2634, 2764},
  {2634, 2765, 2767},
  {2696, 2588, 2639},
  {2696, 2633, 2588},
  {2186, 2640, 2695},
  {2640, 2769, 2695},
  {2637, 2701, 2698},
  {2589, 2699, 2771},
  {2589, 2771, 2541},
  {2593, 2773, 2640},
  {2592, 2772, 2701},
  {2771, 2702, 2541},
  {2541, 2702, 2703},
  {2702, 2772, 2703},
  {2541, 2703, 2642},
  {2703, 2775, 2642},
  {2593, 2776, 2950},
  {2704, 2783, 2592},
  {2708, 2780, 2776},
  {2705, 2781, 2646},
  {2784, 6376, 6378},
  {2598, 2784, 2707},
  {2648, 2839, 2596},
  {2648, 2711, 2839},
  {2553, 2711, 2648},
  {2710, 2843, 2600},
  {2709, 2601, 2598},
  {2603, 2601, 2709},
  {2649, 2551, 2603},
  {2649, 2712, 2650},
  {2712, 2790, 2650},
  {2650, 2790, 2713},
  {2651, 2715, 2604},
  {2714, 2716, 2652},
  {6442, 2713, 2717},
  {2651, 2558, 2719},
  {2651, 2719, 2847},
  {2719, 2558, 2605},
  {2719, 2718, 2847},
  {2714, 2722, 2717},
  {2655, 2722, 2714},
  {2719, 2017, 2850},
  {2716, 2849, 2852},
  {2653, 2717, 2722},
  {2720, 2791, 2851},
  {2720, 2724, 2721},
  {2716, 2852, 2655},
  {2658, 2655, 2852},
  {2655, 2658, 2656},
  {5974, 2656, 2658},
  {2720, 2851, 2504},
  {3164, 2654, 2560},
  {2723, 2795, 2901},
  {2560, 2505, 3164},
  {3164, 2505, 2562},
  {2794, 2725, 2793},
  {2726, 2607, 2728},
  {2852, 2728, 2607},
  {2608, 2727, 5852},
  {2726, 2728, 2729},
  {2609, 2800, 2906},
  {2727, 2726, 5852},
  {2726, 2729, 5852},
  {2729, 2728, 2797},
  {2728, 2852, 2798},
  {2728, 2798, 2797},
  {2852, 2799, 2798},
  {2800, 2730, 2906},
  {2732, 3212, 2800},
  {2562, 2661, 2731},
  {2804, 2661, 2660},
  {2805, 2804, 2660},
  {2662, 2733, 2734},
  {2803, 2734, 2733},
  {2662, 2734, 2663},
  {2738, 2661, 2666},
  {2568, 2805, 2735},
  {2664, 2667, 2807},
  {2807, 2808, 2664},
  {2664, 2808, 2665},
  {2668, 2738, 2666},
  {2741, 2738, 2668},
  {2663, 2806, 2567},
  {2567, 2806, 2612},
  {2569, 2665, 2736},
  {2739, 5849, 2740},
  {2739, 2740, 2667},
  {2668, 2804, 2741},
  {2568, 2811, 2805},
  {2810, 2573, 2742},
  {2740, 2812, 2979},
  {2573, 2810, 2613},
  {2618, 2572, 2569},
  {2669, 2670, 2811},
  {2572, 2618, 2522},
  {2406, 2868, 2670},
  {2670, 2868, 2813},
  {2670, 2813, 2811},
  {2622, 2744, 2927},
  {2345, 2410, 2745},
  {2746, 2929, 2410},
  {2927, 2748, 2622},
  {2812, 2576, 2624},
  {2674, 2812, 2624},
  {2673, 2618, 2818},
  {2673, 2818, 2578},
  {2819, 2749, 2674},
  {2677, 2621, 2675},
  {2750, 2819, 2674},
  {2674, 2676, 2750},
  {2818, 2750, 2676},
  {2676, 2578, 2818},
  {2678, 2935, 2931},
  {2672, 2820, 2679},
  {2931, 2681, 2678},
  {2684, 2682, 2751},
  {2530, 2752, 2822},
  {2938, 6359, 2684},
  {2680, 2753, 2628},
  {6348, 6359, 2938},
  {2753, 2755, 2628},
  {2754, 2755, 2753},
  {2685, 2823, 2686},
  {2689, 2756, 2826},
  {6348, 5977, 6180},
  {2690, 2755, 2825},
  {2691, 2827, 2694},
  {2767, 2691, 2694},
  {2757, 2830, 2760},
  {2694, 2761, 2767},
  {2761, 2762, 2767},
  {2763, 2759, 2696},
  {2759, 2633, 2696},
  {2767, 2762, 2763},
  {2696, 2639, 2763},
  {2768, 2697, 2767},
  {2767, 2763, 2768},
  {2697, 2634, 2767},
  {2763, 2639, 2768},
  {2700, 2768, 2639},
  {2697, 2768, 2635},
  {2638, 2635, 2768},
  {2638, 2768, 2641},
  {2768, 2700, 2641},
  {2699, 2698, 2701},
  {2774, 2770, 2832},
  {2701, 2772, 2771},
  {2702, 2771, 2772},
  {2640, 2773, 2769},
  {2772, 2948, 2703},
  {2775, 2703, 2948},
  {2592, 2896, 2772},
  {2775, 2834, 2642},
  {2835, 2642, 2834},
  {2643, 2778, 2704},
  {2704, 2778, 2783},
  {2642, 2835, 6377},
  {2886, 6377, 2835},
  {2592, 2783, 2896},
  {2781, 2705, 2777},
  {2784, 6378, 5856},
  {2781, 2837, 2646},
  {2837, 2838, 2646},
  {2646, 2838, 2782},
  {2785, 2783, 2841},
  {2843, 2780, 2708},
  {2786, 2783, 2785},
  {2598, 2707, 2842},
  {2708, 2600, 2843},
  {2598, 2788, 2709},
  {2709, 2959, 2603},
  {2709, 2788, 2959},
  {2603, 2959, 2897},
  {2603, 2897, 2649},
  {2712, 2649, 2789},
  {2712, 2789, 2790},
  {2711, 2604, 2715},
  {2716, 2714, 2960},
  {2897, 2959, 2714},
  {2713, 2897, 2714},
  {2897, 2713, 2790},
  {2714, 2717, 2713},
  {2715, 2651, 2847},
  {2718, 2719, 2850},
  {2850, 2017, 2853},
  {2720, 2721, 2791},
  {2853, 2723, 2901},
  {2721, 2724, 3164},
  {2721, 3164, 2791},
  {3164, 2724, 2654},
  {2659, 2608, 2792},
  {2725, 2659, 2793},
  {2608, 5852, 2792},
  {2852, 5850, 2905},
  {2852, 2905, 2799},
  {2562, 2731, 2796},
  {2801, 2796, 2731},
  {2797, 5852, 2729},
  {2854, 2733, 2913},
  {2733, 2854, 2803},
  {2660, 2735, 2805},
  {2734, 2803, 2663},
  {2731, 2661, 2738},
  {2916, 2665, 2808},
  {2912, 2736, 2665},
  {2806, 2663, 2803},
  {2912, 2737, 2736},
  {2612, 6475, 2573},
  {2612, 6381, 6475},
  {2736, 2737, 2569},
  {2737, 2809, 2569},
  {6475, 6363, 2573},
  {2573, 2858, 2742},
  {2667, 2740, 2807},
  {6324, 2810, 2865},
  {2868, 2406, 2924},
  {2744, 6324, 2927},
  {2928, 2982, 2521},
  {2926, 2575, 2743},
  {2743, 2617, 2926},
  {2814, 2812, 2815},
  {2521, 2745, 2928},
  {2869, 2747, 2575},
  {2617, 2748, 2816},
  {2672, 2747, 2869},
  {2748, 2927, 2816},
  {2817, 2815, 2749},
  {2815, 2812, 2674},
  {2815, 2674, 2749},
  {2746, 2621, 2870},
  {2749, 2819, 2817},
  {2751, 2679, 2820},
  {2677, 2821, 2621},
  {2933, 2681, 2931},
  {2679, 2751, 2682},
  {2821, 2677, 2822},
  {2933, 2936, 2753},
  {2933, 2753, 2681},
  {2751, 2938, 2684},
  {2679, 2688, 2689},
  {2753, 2872, 2825},
  {2754, 2753, 2825},
  {2823, 2687, 3043},
  {2824, 3043, 2687},
  {2687, 2872, 2824},
  {2755, 2754, 2825},
  {2825, 2872, 2690},
  {2758, 2828, 2691},
  {2828, 2758, 2943},
  {2758, 2691, 2632},
  {2692, 2759, 2877},
  {2692, 2877, 2829},
  {2692, 2829, 2757},
  {2757, 2829, 2830},
  {2767, 2831, 2691},
  {2694, 2827, 2761},
  {2876, 2759, 2763},
  {2830, 2879, 2760},
  {2763, 2762, 2876},
  {2766, 2483, 2879},
  {2831, 2767, 2764},
  {2764, 2767, 2765},
  {2944, 2770, 2766},
  {2880, 2770, 2944},
  {2881, 2770, 2880},
  {2770, 2881, 2832},
  {2701, 2771, 2699},
  {2769, 2773, 2833},
  {2834, 2775, 2948},
  {2896, 2948, 2772},
  {2773, 2593, 2950},
  {2774, 2951, 2777},
  {2776, 2780, 3099},
  {2777, 2837, 2781},
  {2779, 2836, 2778},
  {2783, 2778, 2836},
  {5856, 6378, 2886},
  {2644, 2782, 2779},
  {2783, 2836, 2779},
  {2782, 2841, 2779},
  {2779, 2841, 2783},
  {2780, 2843, 2888},
  {2838, 2840, 2782},
  {2782, 2840, 2841},
  {2896, 2783, 2786},
  {2841, 2891, 2785},
  {2842, 2890, 2598},
  {2839, 2957, 2596},
  {2785, 2891, 2894},
  {2785, 2894, 2844},
  {2839, 2711, 2895},
  {2596, 2957, 2787},
  {2844, 2894, 2845},
  {2844, 2845, 2786},
  {2844, 2786, 2785},
  {2787, 2843, 2710},
  {2845, 2898, 2786},
  {2711, 2715, 2895},
  {2897, 2846, 2649},
  {2649, 2846, 2789},
  {2897, 2789, 2846},
  {2789, 2897, 2790},
  {2960, 2848, 2716},
  {2714, 2959, 2960},
  {5975, 5976, 5978},
  {2716, 2848, 2849},
  {2851, 2791, 2899},
  {2853, 2900, 2850},
  {2795, 2504, 2851},
  {2901, 2795, 2902},
  {5860, 2562, 2796},
  {5860, 3164, 2562},
  {2794, 2793, 2903},
  {2798, 5852, 2797},
  {5860, 2796, 2801},
  {2798, 2799, 2905},
  {2800, 3022, 2730},
  {3073, 2801, 2731},
  {2906, 2972, 2802},
  {2854, 2855, 2803},
  {2808, 2979, 2916},
  {2912, 2665, 2916},
  {2803, 2855, 2806},
  {2855, 2612, 2806},
  {2855, 2976, 2612},
  {3031, 6381, 2612},
  {2918, 2809, 2737},
  {6363, 2857, 2573},
  {2857, 2858, 2573},
  {2740, 2808, 2807},
  {2860, 2861, 2859},
  {2919, 2859, 2864},
  {2980, 2569, 2809},
  {2738, 2741, 2920},
  {2741, 2804, 2920},
  {2805, 2811, 3034},
  {2863, 2860, 2862},
  {2860, 2863, 2861},
  {2864, 2859, 2861},
  {2858, 2919, 2865},
  {2866, 2919, 2864},
  {2865, 2919, 2866},
  {2742, 2865, 2810},
  {2811, 2813, 2867},
  {2863, 2862, 2922},
  {2863, 2922, 2861},
  {2861, 2922, 2864},
  {2866, 2923, 2865},
  {2865, 2927, 6324},
  {2813, 2868, 2867},
  {2979, 2814, 2815},
  {2979, 2812, 2814},
  {2982, 2924, 2406},
  {2575, 2926, 2869},
  {2745, 2410, 2929},
  {2929, 2746, 2870},
  {2988, 2750, 2818},
  {2820, 2934, 2751},
  {2621, 2821, 2871},
  {2822, 2871, 2821},
  {2752, 2823, 2937},
  {2752, 2937, 2822},
  {2689, 2935, 2679},
  {2752, 2686, 2823},
  {6114, 2935, 2689},
  {6348, 2938, 5977},
  {2689, 2826, 6114},
  {2874, 2827, 2828},
  {2691, 2828, 2827},
  {2827, 2874, 3045},
  {2828, 2875, 2874},
  {2828, 2943, 2875},
  {2758, 2632, 2943},
  {2632, 2691, 2831},
  {2759, 2876, 2877},
  {2830, 2941, 2878},
  {2830, 2878, 2879},
  {2876, 3051, 2877},
  {2829, 2877, 3051},
  {2632, 2695, 2943},
  {2769, 2945, 2695},
  {2882, 2769, 2833},
  {2947, 2774, 2832},
  {2883, 2774, 2947},
  {6311, 6310, 5979},
  {2950, 2833, 2773},
  {2884, 2774, 2883},
  {2951, 2774, 2884},
  {3007, 2948, 2896},
  {3099, 2950, 2776},
  {2952, 2777, 2951},
  {2835, 3056, 2886},
  {2777, 2952, 2837},
  {2837, 2952, 2885},
  {2837, 2885, 2953},
  {2837, 2953, 2838},
  {5856, 2887, 2784},
  {2890, 2842, 2707},
  {2707, 2784, 2890},
  {2784, 2887, 2890},
  {2838, 2953, 2840},
  {2840, 2953, 2889},
  {2841, 2840, 2889},
  {2888, 2843, 2893},
  {2889, 2892, 2841},
  {2841, 2892, 2891},
  {2891, 2892, 3012},
  {2891, 3012, 2894},
  {2598, 2890, 2955},
  {2787, 2957, 2843},
  {2843, 2957, 2893},
  {2598, 2955, 2958},
  {2598, 2958, 3014},
  {2895, 2715, 2956},
  {2786, 2898, 2896},
  {2598, 3014, 2788},
  {2788, 2960, 2959},
  {2715, 2847, 2956},
  {2848, 2960, 2961},
  {2847, 2718, 3015},
  {2718, 2850, 3015},
  {2848, 2964, 2849},
  {2966, 2849, 2964},
  {2851, 2899, 2965},
  {2791, 3164, 2899},
  {2965, 2795, 2851},
  {2853, 2901, 2967},
  {3068, 2793, 2659},
  {2800, 3212, 3022},
  {2904, 2794, 2903},
  {3022, 2906, 2730},
  {2794, 2969, 2732},
  {2906, 2907, 2972},
  {2733, 2802, 3076},
  {2974, 2908, 2914},
  {2908, 2909, 2914},
  {5980, 2910, 2911},
  {2909, 2911, 2914},
  {2910, 5980, 2911},
  {2912, 2911, 2909},
  {2913, 2733, 3076},
  {2914, 2912, 2915},
  {2914, 2911, 2912},
  {2976, 2854, 2913},
  {2915, 2912, 2916},
  {2854, 2976, 2855},
  {2916, 2979, 3134},
  {2916, 3134, 2915},
  {2976, 3031, 2612},
  {2912, 2918, 2737},
  {3034, 2804, 2805},
  {2977, 3031, 2859},
  {2919, 2977, 2859},
  {2977, 2919, 6381},
  {2856, 6364, 2917},
  {2858, 2857, 2919},
  {2740, 2979, 2808},
  {2918, 2980, 2809},
  {3032, 2731, 3035},
  {2738, 3035, 2731},
  {2918, 3032, 2980},
  {3035, 2738, 2920},
  {2978, 2921, 2860},
  {2862, 2860, 2921},
  {2858, 2865, 2742},
  {2569, 2980, 2618},
  {2811, 2867, 3034},
  {2862, 2921, 2922},
  {2922, 3138, 2864},
  {2865, 2923, 2927},
  {2864, 3138, 2866},
  {2867, 2868, 2925},
  {2924, 2925, 2868},
  {2869, 2926, 2985},
  {2869, 2985, 2672},
  {2617, 2816, 3139},
  {2816, 2927, 3139},
  {2618, 2988, 2818},
  {2815, 2817, 2930},
  {2815, 2930, 2983},
  {2928, 2745, 2929},
  {3186, 2672, 2985},
  {2621, 3221, 2870},
  {2871, 3221, 2621},
  {3186, 2820, 2672},
  {2932, 2930, 2817},
  {2817, 2819, 2932},
  {2819, 2750, 2932},
  {2820, 3186, 2934},
  {2934, 2989, 2751},
  {3221, 2871, 2822},
  {2751, 2989, 2938},
  {2872, 2753, 2936},
  {2990, 2937, 2823},
  {2936, 2824, 2872},
  {2935, 6114, 6347},
  {2874, 2875, 3044},
  {2874, 3044, 3045},
  {2941, 2940, 2878},
  {2878, 2940, 3091},
  {2878, 3091, 2879},
  {2761, 2991, 2942},
  {2829, 2941, 2830},
  {2761, 2942, 2762},
  {2762, 2942, 2876},
  {2829, 3051, 2941},
  {2942, 3047, 2876},
  {2695, 2992, 2943},
  {2876, 3047, 2946},
  {2876, 2946, 3051},
  {2944, 2997, 2880},
  {2695, 2945, 2992},
  {2994, 2946, 3047},
  {2997, 2832, 2881},
  {2832, 2997, 2947},
  {3002, 2769, 2882},
  {2882, 2833, 3002},
  {2950, 2949, 2833},
  {2833, 2949, 3002},
  {2948, 3007, 2834},
  {2834, 3008, 2835},
  {2835, 3008, 3056},
  {2950, 3099, 3054},
  {3056, 3007, 2896},
  {2896, 3241, 3009},
  {2887, 5856, 5857},
  {2780, 2888, 3058},
  {2888, 2893, 3058},
  {2954, 3058, 2893},
  {2953, 3010, 3059},
  {2953, 3059, 2889},
  {2893, 3013, 2954},
  {2839, 2895, 3011},
  {2839, 3060, 2957},
  {2895, 2956, 3011},
  {2893, 2957, 3013},
  {2845, 2894, 2898},
  {3014, 2961, 2788},
  {2788, 2961, 2960},
  {2956, 2847, 2963},
  {2956, 2963, 2962},
  {3014, 2848, 2961},
  {2848, 3014, 2964},
  {2850, 2900, 3015},
  {2849, 2966, 2852},
  {2853, 2967, 3018},
  {2965, 3351, 2795},
  {3113, 2899, 3164},
  {2968, 2967, 2901},
  {2901, 2902, 2968},
  {2659, 2792, 3120},
  {2795, 2968, 2902},
  {3120, 3068, 2659},
  {3068, 2903, 2793},
  {5860, 2801, 3073},
  {2904, 3020, 3023},
  {2904, 3023, 2794},
  {2794, 3023, 3024},
  {2969, 2970, 2971},
  {2906, 3022, 2907},
  {2732, 2969, 2971},
  {3030, 3027, 2731},
  {6077, 2975, 2909},
  {3029, 2912, 2909},
  {3028, 2912, 3029},
  {2913, 3076, 2976},
  {2914, 2915, 3029},
  {3030, 2731, 3032},
  {2977, 6381, 3031},
  {2978, 2860, 2859},
  {2859, 3031, 2978},
  {2804, 3034, 2920},
  {2980, 3035, 3036},
  {2980, 3036, 2618},
  {2866, 2981, 2923},
  {2923, 2981, 2927},
  {2618, 3036, 2988},
  {2867, 2925, 3038},
  {2925, 3082, 3038},
  {2985, 2926, 2984},
  {2928, 2929, 2982},
  {2931, 2986, 2933},
  {3039, 2933, 2986},
  {2932, 2750, 2987},
  {2935, 2986, 2931},
  {3186, 3084, 2934},
  {3221, 2822, 3144},
  {2937, 3040, 2822},
  {3144, 2822, 3040},
  {2989, 3041, 2938},
  {3043, 2824, 2936},
  {3040, 2937, 2990},
  {2990, 2823, 3085},
  {2823, 3043, 3085},
  {3145, 3085, 3043},
  {2875, 2943, 3044},
  {2941, 3051, 2940},
  {2879, 3091, 2944},
  {2879, 2944, 2766},
  {3047, 2996, 2994},
  {2946, 3000, 3051},
  {2881, 2880, 2997},
  {2994, 2999, 2946},
  {2946, 2999, 3000},
  {2995, 2993, 3001},
  {2995, 3001, 2998},
  {3002, 3003, 2769},
  {2769, 3003, 2945},
  {2996, 3097, 2994},
  {2999, 2994, 3097},
  {2997, 2998, 2947},
  {2949, 3003, 3002},
  {3006, 2883, 2947},
  {2947, 2998, 3006},
  {3001, 3004, 3005},
  {2949, 2950, 3003},
  {2883, 3006, 2884},
  {2834, 3007, 3008},
  {2884, 3006, 2951},
  {3006, 2998, 2951},
  {2998, 3101, 2951},
  {3007, 3056, 3008},
  {2951, 3101, 2952},
  {2896, 3009, 3056},
  {2952, 3100, 2885},
  {3010, 2885, 3100},
  {2885, 3010, 2953},
  {3241, 5858, 3009},
  {5857, 5858, 2887},
  {3060, 2839, 3011},
  {2889, 3059, 2892},
  {2892, 3059, 3012},
  {2890, 2958, 2955},
  {3011, 2956, 3064},
  {3013, 2957, 3063},
  {2962, 2963, 3015},
  {2963, 2847, 3015},
  {3014, 3158, 2964},
  {2965, 2899, 3065},
  {3158, 2966, 2964},
  {2966, 3158, 3016},
  {6102, 2966, 3016},
  {3016, 3017, 6102},
  {2966, 6102, 2852},
  {2967, 2968, 3018},
  {3019, 3018, 2968},
  {3119, 3019, 2968},
  {2968, 2795, 3119},
  {3302, 3119, 2795},
  {2903, 3254, 3020},
  {2903, 3020, 2904},
  {2969, 2794, 3075},
  {2969, 3075, 2970},
  {2794, 3024, 3074},
  {2970, 3128, 2971},
  {3026, 2971, 3128},
  {2907, 3025, 2972},
  {3129, 2972, 3025},
  {2971, 3026, 2732},
  {2972, 3129, 2802},
  {2732, 3026, 2973},
  {2973, 3026, 3262},
  {3073, 2731, 3027},
  {3212, 2732, 3262},
  {3027, 3030, 3028},
  {3076, 2802, 3176},
  {2908, 2974, 2909},
  {6077, 2909, 2975},
  {2974, 2914, 3029},
  {2974, 3029, 2909},
  {3030, 2912, 3028},
  {2915, 3134, 3029},
  {3032, 2912, 3030},
  {3032, 2918, 2912},
  {3079, 3033, 2978},
  {3033, 3216, 2978},
  {3032, 3035, 2980},
  {3137, 3034, 2867},
  {3403, 3035, 2920},
  {3216, 2921, 2978},
  {2867, 3038, 3137},
  {2866, 5982, 2981},
  {2981, 5982, 3037},
  {2981, 3037, 2927},
  {2979, 2815, 2983},
  {2927, 3037, 3080},
  {2927, 3080, 3139},
  {2924, 3082, 2925},
  {2984, 2926, 3139},
  {2617, 3139, 2926},
  {2984, 3186, 2985},
  {2929, 2870, 3184},
  {2929, 3410, 3277},
  {2929, 3184, 3410},
  {2986, 3185, 3039},
  {2986, 2935, 3185},
  {2932, 2987, 2930},
  {2988, 2987, 2750},
  {2934, 3084, 2989},
  {2936, 3143, 3043},
  {2938, 3041, 3042},
  {2990, 3085, 3040},
  {3045, 3090, 2827},
  {3146, 3044, 2943},
  {2940, 3193, 3091},
  {2943, 3195, 3146},
  {2944, 3091, 3092},
  {2991, 3093, 2942},
  {2942, 3093, 3046},
  {3148, 2944, 3092},
  {2992, 2945, 3096},
  {2942, 3147, 3047},
  {2997, 2944, 3048},
  {3049, 3048, 2944},
  {3047, 3198, 2996},
  {3048, 3049, 3052},
  {3048, 3052, 2997},
  {2945, 3003, 3050},
  {2997, 3052, 2998},
  {3052, 3148, 2998},
  {3097, 3098, 2999},
  {2999, 3098, 3149},
  {2999, 3149, 3000},
  {3000, 3149, 3051},
  {3003, 2950, 3050},
  {3004, 3053, 3005},
  {3054, 3199, 2950},
  {3005, 2998, 3001},
  {3005, 3053, 3055},
  {3053, 5984, 3055},
  {3055, 3101, 2998},
  {2998, 3005, 3055},
  {2952, 3101, 3100},
  {3056, 3009, 3057},
  {5857, 3057, 3009},
  {3058, 3099, 2780},
  {5857, 3009, 5858},
  {3059, 3010, 3100},
  {2887, 3106, 2890},
  {3011, 3064, 3060},
  {3060, 3154, 2957},
  {3012, 3100, 3062},
  {2890, 3106, 3107},
  {2890, 3107, 2958},
  {3154, 3063, 2957},
  {3012, 3062, 2898},
  {3012, 2898, 2894},
  {3062, 3061, 2898},
  {2898, 3061, 3240},
  {3064, 2956, 2962},
  {3158, 3014, 2958},
  {2899, 3113, 3065},
  {3067, 3016, 3158},
  {3016, 3067, 3017},
  {3066, 3018, 3114},
  {3066, 2853, 3018},
  {3066, 3112, 2853},
  {2900, 2853, 3015},
  {3017, 3067, 6102},
  {3019, 3114, 3018},
  {3120, 3209, 3068},
  {6106, 6102, 3067},
  {6106, 3071, 6102},
  {6106, 3067, 3069},
  {3071, 3021, 6102},
  {3165, 5860, 3073},
  {3165, 3073, 3125},
  {3020, 3254, 3023},
  {3023, 3126, 3024},
  {3075, 3127, 2970},
  {2970, 3127, 3128},
  {3022, 3025, 2907},
  {3024, 3126, 3074},
  {3125, 3073, 3313},
  {2794, 3074, 3075},
  {3313, 3073, 3027},
  {3027, 3028, 3313},
  {3262, 2732, 2973},
  {3077, 2976, 3076},
  {2976, 3077, 3031},
  {3313, 3029, 3134},
  {3033, 3079, 3078},
  {3031, 3077, 2978},
  {3078, 3136, 3033},
  {2921, 3216, 3138},
  {2921, 3138, 2922},
  {3138, 3271, 2866},
  {2866, 3180, 5982},
  {2979, 2983, 3134},
  {3139, 3080, 3181},
  {2983, 3183, 3134},
  {3036, 3083, 2988},
  {2983, 2930, 3183},
  {3182, 3082, 2924},
  {3186, 2984, 3139},
  {2988, 3083, 3140},
  {2982, 2929, 3277},
  {3039, 3142, 3141},
  {3039, 3185, 3142},
  {2930, 2987, 3183},
  {2987, 2988, 3183},
  {2933, 3039, 3143},
  {3141, 3143, 3039},
  {2933, 3143, 2936},
  {3041, 2989, 3084},
  {6207, 3088, 6098},
  {3045, 3044, 3089},
  {3045, 3089, 3090},
  {3044, 3146, 3089},
  {3090, 3282, 2827},
  {2827, 3282, 2761},
  {2940, 3051, 3193},
  {2943, 2992, 3195},
  {3195, 2992, 3096},
  {3046, 3147, 2942},
  {2993, 3094, 3095},
  {3147, 3198, 3047},
  {2993, 3148, 3094},
  {3095, 3001, 2993},
  {2944, 3148, 3049},
  {2995, 3148, 2993},
  {3096, 2945, 3421},
  {3049, 3148, 3052},
  {2998, 3148, 2995},
  {3050, 3421, 2945},
  {3050, 3199, 3421},
  {2996, 3198, 3097},
  {3050, 2950, 3199},
  {6420, 3151, 3004},
  {3004, 3151, 3152},
  {3004, 3152, 6421},
  {3055, 5984, 3101},
  {2954, 3099, 3058},
  {3103, 3061, 3101},
  {3102, 3103, 3101},
  {3467, 3061, 3103},
  {5858, 3104, 3106},
  {3060, 3064, 3154},
  {3012, 3059, 3100},
  {2887, 5858, 3106},
  {2954, 3013, 3105},
  {3100, 3061, 3062},
  {3063, 3154, 3105},
  {3105, 3013, 3063},
  {3108, 3064, 2962},
  {2898, 3240, 3156},
  {2958, 3107, 3109},
  {3108, 2962, 3015},
  {3015, 3203, 3108},
  {3065, 3111, 3110},
  {2965, 3065, 3110},
  {2965, 3110, 3351},
  {3065, 3113, 3111},
  {3245, 2853, 3112},
  {3067, 5986, 3162},
  {3119, 3114, 3019},
  {3120, 3115, 3209},
  {3120, 3124, 3116},
  {3116, 3124, 3117},
  {3067, 3162, 3118},
  {3067, 3118, 5983},
  {3121, 5983, 3118},
  {3068, 3209, 3166},
  {3166, 2903, 3068},
  {6143, 3067, 5983},
  {6143, 3123, 3067},
  {3067, 3123, 3069},
  {3070, 3021, 3124},
  {3124, 3021, 3071},
  {3071, 6106, 3124},
  {3070, 3072, 3021},
  {3023, 3254, 3126},
  {3022, 3172, 3025},
  {3128, 3170, 3026},
  {3212, 3173, 3022},
  {3025, 3172, 3129},
  {3127, 3075, 3171},
  {3125, 3313, 3359},
  {3074, 3131, 3075},
  {3075, 3131, 3130},
  {2802, 3129, 3176},
  {3132, 3131, 3175},
  {3131, 3132, 3130},
  {3133, 3077, 3076},
  {3318, 3313, 3134},
  {3078, 3079, 3179},
  {3079, 2978, 3267},
  {2978, 3077, 3133},
  {3136, 3078, 3135},
  {3179, 3135, 3078},
  {3033, 3136, 3216},
  {2920, 3034, 3403},
  {3138, 3216, 3405},
  {3180, 2866, 3271},
  {3182, 3137, 3038},
  {3181, 3080, 3081},
  {3038, 3082, 3182},
  {2982, 3272, 2924},
  {2924, 3486, 3182},
  {3184, 2870, 3220},
  {2870, 3221, 3220},
  {2935, 3086, 3185},
  {3040, 3085, 3144},
  {3186, 5853, 3084},
  {3144, 3085, 3187},
  {3085, 3145, 3187},
  {5855, 5853, 3188},
  {3189, 3145, 3043},
  {3191, 3087, 6098},
  {6098, 3088, 3191},
  {6214, 3191, 3088},
  {3282, 3192, 3089},
  {3192, 3090, 3089},
  {3146, 3282, 3089},
  {3282, 3090, 3192},
  {3282, 2991, 2761},
  {3196, 3093, 2991},
  {3194, 3193, 3051},
  {3227, 3092, 3091},
  {3092, 3227, 3148},
  {3093, 3196, 3046},
  {3147, 3046, 3196},
  {3094, 6419, 3095},
  {3097, 3149, 3098},
  {6421, 3234, 3150},
  {3054, 3099, 3238},
  {3102, 3101, 5984},
  {3101, 3061, 3100},
  {3467, 3103, 3102},
  {3106, 3104, 3107},
  {3107, 3244, 3109},
  {3157, 3109, 3244},
  {2896, 2898, 3156},
  {3157, 2958, 3109},
  {2958, 3157, 3158},
  {3111, 3351, 3110},
  {3204, 3067, 3158},
  {2853, 3245, 3015},
  {3067, 3204, 5986},
  {3205, 3116, 3117},
  {3205, 3117, 3206},
  {3205, 3206, 3247},
  {3066, 3114, 3112},
  {3120, 3205, 3115},
  {3120, 3116, 3205},
  {3206, 3117, 3160},
  {3160, 3161, 3207},
  {3160, 3207, 3206},
  {3121, 3208, 3161},
  {3159, 3208, 3162},
  {3114, 3119, 3251},
  {3114, 3251, 3112},
  {3160, 3117, 6106},
  {3160, 6106, 3161},
  {3161, 3123, 3122},
  {3161, 3122, 3121},
  {3208, 3121, 3118},
  {3118, 3162, 3208},
  {2795, 3351, 3302},
  {3209, 3163, 3166},
  {3161, 6106, 3069},
  {3161, 3069, 3123},
  {3165, 3303, 5860},
  {6106, 3117, 3124},
  {3165, 3125, 3168},
  {3168, 3167, 3253},
  {3169, 3253, 3167},
  {3125, 3167, 3168},
  {3125, 3169, 3167},
  {3128, 3171, 3170},
  {3171, 3128, 3127},
  {3172, 3022, 3173},
  {3171, 3130, 3211},
  {3262, 3170, 3258},
  {3174, 3129, 3172},
  {3171, 3075, 3130},
  {3262, 3026, 3170},
  {3131, 3074, 3213},
  {3263, 3176, 3129},
  {3129, 3174, 3263},
  {3175, 3131, 3213},
  {3130, 3132, 3178},
  {3132, 3177, 3178},
  {3029, 3313, 3028},
  {3133, 3076, 3215},
  {3269, 3079, 3267},
  {3179, 3079, 3269},
  {2978, 3133, 3215},
  {2978, 3215, 3267},
  {3136, 3135, 3216},
  {3034, 3137, 3442},
  {3137, 3182, 3442},
  {3181, 3081, 6084},
  {3036, 3035, 3083},
  {3181, 3217, 3139},
  {3486, 2924, 3272},
  {2982, 3219, 3272},
  {3525, 3140, 3083},
  {2988, 3631, 3183},
  {3086, 3087, 3185},
  {3186, 3188, 5853},
  {3144, 3187, 3222},
  {3187, 3145, 3222},
  {3043, 3279, 3189},
  {3043, 3143, 3279},
  {3145, 3189, 3222},
  {6091, 3188, 3224},
  {3087, 3191, 3190},
  {2991, 3282, 3285},
  {3193, 3194, 3091},
  {2991, 3285, 3196},
  {3091, 3194, 3227},
  {3197, 3195, 3096},
  {3094, 3148, 3232},
  {3094, 3232, 6420},
  {3096, 3290, 3197},
  {3149, 3097, 3198},
  {3149, 3337, 3292},
  {3051, 3149, 3292},
  {6420, 3292, 3151},
  {3235, 3150, 3234},
  {6421, 3152, 3234},
  {3151, 3236, 3152},
  {3237, 3236, 3151},
  {3201, 3239, 3099},
  {3154, 3201, 3099},
  {3099, 3105, 3154},
  {5859, 3297, 3202},
  {3241, 3297, 5859},
  {3155, 3104, 6383},
  {3061, 3467, 3240},
  {3104, 3155, 3107},
  {3107, 3155, 3299},
  {3156, 3243, 2896},
  {3244, 3204, 3157},
  {3157, 3204, 3158},
  {3246, 3245, 3112},
  {3353, 5986, 3204},
  {3206, 3207, 3356},
  {3208, 3207, 3161},
  {3209, 3115, 3248},
  {3247, 3115, 3205},
  {3159, 3249, 3430},
  {3163, 3209, 3390},
  {3252, 3251, 3119},
  {3119, 3302, 3252},
  {3165, 3168, 3303},
  {3253, 3303, 3168},
  {3166, 3254, 2903},
  {3253, 3169, 3210},
  {3169, 3125, 3210},
  {3171, 3258, 3170},
  {3171, 3211, 3258},
  {3172, 3260, 3174},
  {3175, 3213, 3177},
  {3130, 3178, 3257},
  {3257, 3178, 3307},
  {3175, 3177, 3132},
  {3176, 3263, 3310},
  {3364, 3265, 3178},
  {3364, 3178, 3177},
  {3177, 3315, 3364},
  {3215, 3268, 3267},
  {3179, 3269, 3135},
  {3270, 3135, 3269},
  {3216, 3135, 3270},
  {3217, 3181, 3271},
  {6391, 3271, 3181},
  {3525, 3083, 3035},
  {3218, 3139, 3274},
  {3218, 3274, 3273},
  {3139, 3218, 3278},
  {3183, 3631, 3321},
  {2988, 3140, 3525},
  {3141, 3142, 3370},
  {3142, 3185, 3370},
  {3139, 3278, 3186},
  {3185, 3087, 3370},
  {3186, 3278, 3188},
  {3223, 3222, 3189},
  {3280, 3223, 3189},
  {3281, 3224, 3188},
  {3190, 3191, 3281},
  {6214, 3224, 3191},
  {3191, 3224, 3281},
  {3146, 3195, 3283},
  {3230, 3226, 3225},
  {3329, 3283, 3195},
  {3228, 3196, 3285},
  {3230, 3229, 3226},
  {3227, 3334, 3148},
  {3196, 3228, 3147},
  {3198, 3147, 3228},
  {3228, 3229, 3198},
  {3229, 3230, 3198},
  {3195, 3197, 3231},
  {3148, 3334, 3287},
  {3148, 3287, 3232},
  {3096, 3421, 3290},
  {6420, 3336, 3292},
  {3335, 3292, 3336},
  {3199, 3054, 3233},
  {3292, 3200, 3151},
  {3152, 3236, 3234},
  {3200, 3237, 3151},
  {3200, 3341, 3237},
  {3201, 3154, 3239},
  {3344, 3239, 3154},
  {2954, 3105, 3099},
  {3154, 3064, 3344},
  {6393, 3155, 6383},
  {3299, 3155, 6393},
  {3242, 3156, 3240},
  {3156, 3242, 3243},
  {2896, 3243, 3241},
  {3245, 3350, 3015},
  {5986, 3353, 3249},
  {3246, 3112, 3300},
  {3430, 3208, 3159},
  {3112, 3251, 3300},
  {3247, 3248, 3115},
  {3163, 3390, 3166},
  {3253, 3210, 3304},
  {3255, 3304, 3210},
  {3210, 3359, 3255},
  {3254, 3391, 3213},
  {3254, 3213, 3126},
  {3173, 3305, 3256},
  {3074, 3126, 3213},
  {3257, 3258, 3211},
  {3305, 3173, 3212},
  {3211, 3130, 3257},
  {3262, 3258, 3259},
  {3305, 3212, 3394},
  {3261, 3172, 3173},
  {3172, 3261, 3260},
  {3261, 3174, 3260},
  {3265, 3307, 3178},
  {3261, 3264, 3174},
  {3174, 3264, 3263},
  {3263, 3264, 3311},
  {3076, 3176, 3215},
  {3214, 3266, 3313},
  {3215, 3176, 3316},
  {3363, 3268, 3215},
  {3138, 3319, 3271},
  {3183, 3318, 3134},
  {3274, 3139, 3217},
  {3277, 3272, 3219},
  {3218, 3273, 3278},
  {3219, 2982, 3277},
  {3184, 3220, 3276},
  {3371, 3278, 3273},
  {3322, 3277, 3410},
  {3141, 3370, 3143},
  {3143, 3370, 3279},
  {3222, 3223, 3144},
  {3223, 3280, 3144},
  {3189, 3279, 3280},
  {3282, 3146, 3283},
  {3225, 3326, 3284},
  {3225, 3226, 3454},
  {3225, 3284, 3230},
  {3284, 3377, 3230},
  {3194, 6099, 3227},
  {3227, 6099, 3332},
  {3332, 3334, 3227},
  {3230, 3419, 3198},
  {3335, 3287, 3334},
  {3231, 3197, 3286},
  {3288, 3286, 3197},
  {3287, 3289, 3232},
  {3232, 3289, 6420},
  {3197, 3290, 3288},
  {3336, 6420, 3289},
  {3421, 3420, 3290},
  {3337, 3149, 3198},
  {3233, 3054, 3291},
  {3382, 3291, 3054},
  {3054, 3238, 3382},
  {3338, 3292, 3337},
  {3338, 3339, 3292},
  {3236, 3235, 3234},
  {5984, 6466, 3601},
  {3200, 3342, 3293},
  {3099, 3462, 3238},
  {3293, 3341, 3200},
  {3099, 3239, 3386},
  {3293, 3343, 3341},
  {3294, 5988, 3295},
  {5988, 6241, 3295},
  {3202, 3297, 6383},
  {3295, 6241, 6384},
  {3297, 6242, 6383},
  {3346, 3347, 6382},
  {6383, 6392, 6393},
  {6226, 6227, 3298},
  {3108, 3203, 3425},
  {3240, 3348, 3242},
  {3243, 3242, 3348},
  {3107, 3299, 3244},
  {3244, 3299, 3204},
  {3203, 3015, 3350},
  {3387, 3203, 3350},
  {3351, 3111, 3428},
  {3247, 3206, 3248},
  {3207, 3208, 3356},
  {3430, 3356, 3208},
  {3249, 3354, 3250},
  {3301, 3250, 3354},
  {3249, 3250, 3430},
  {3301, 3430, 3250},
  {3355, 3251, 3252},
  {3304, 3303, 3253},
  {3390, 3358, 3166},
  {3166, 3358, 3254},
  {3256, 3360, 3306},
  {3256, 3306, 3173},
  {3257, 3259, 3258},
  {3257, 3307, 3259},
  {3259, 3308, 3262},
  {3259, 3307, 3308},
  {3173, 3306, 3393},
  {3261, 3173, 3434},
  {3308, 3361, 3262},
  {3307, 3265, 3309},
  {3261, 3362, 3264},
  {3176, 3310, 3312},
  {3263, 3311, 3310},
  {3264, 3362, 3311},
  {3177, 3213, 3315},
  {3438, 3312, 3310},
  {3214, 3313, 3266},
  {3317, 3314, 3313},
  {3366, 3267, 3268},
  {3268, 3363, 3402},
  {3317, 3313, 3318},
  {3315, 3365, 3364},
  {3366, 3269, 3267},
  {3217, 3271, 3319},
  {3183, 3321, 3318},
  {3442, 3182, 3320},
  {3182, 3275, 3320},
  {3486, 3275, 3182},
  {2988, 3525, 3631},
  {3184, 3487, 3410},
  {3184, 3276, 3529},
  {3276, 3220, 3529},
  {3220, 3447, 3529},
  {3323, 3447, 3220},
  {3220, 3221, 3323},
  {3144, 3323, 3221},
  {3370, 3488, 3279},
  {3144, 3280, 3323},
  {3087, 3190, 3370},
  {3280, 3279, 3324},
  {3325, 3281, 3188},
  {3326, 3376, 3284},
  {3375, 3284, 3376},
  {3327, 3328, 3330},
  {3494, 3283, 3329},
  {3225, 3454, 3326},
  {3229, 3454, 3226},
  {6099, 3331, 3332},
  {3228, 3285, 3379},
  {3228, 3379, 3229},
  {3194, 3333, 5987},
  {5987, 3333, 3332},
  {3329, 3195, 3231},
  {3329, 3231, 3286},
  {3329, 3286, 3288},
  {3194, 3051, 3333},
  {3287, 3335, 3289},
  {3289, 3335, 3336},
  {3198, 3419, 3337},
  {3199, 3233, 3421},
  {3235, 3236, 3381},
  {6466, 3381, 3601},
  {3383, 3292, 3339},
  {3292, 3383, 3384},
  {3384, 3340, 3292},
  {3292, 3340, 3342},
  {3200, 3292, 3342},
  {3340, 3463, 3342},
  {3345, 3293, 3342},
  {3343, 3293, 3345},
  {3344, 3386, 3239},
  {6242, 5989, 6383},
  {3467, 3102, 3464},
  {5990, 3347, 3346},
  {3425, 3064, 3108},
  {3240, 3467, 3348},
  {3297, 3241, 6242},
  {3425, 3203, 3387},
  {3348, 3426, 3241},
  {3348, 3241, 3243},
  {3350, 3245, 3349},
  {3350, 3349, 3387},
  {3299, 3352, 3204},
  {3111, 3509, 3428},
  {3111, 3113, 3509},
  {3204, 3352, 3353},
  {3249, 3353, 3473},
  {3300, 3355, 3246},
  {3113, 3164, 3509},
  {3249, 3473, 3354},
  {3354, 3357, 3301},
  {3300, 3251, 3355},
  {3430, 3301, 3357},
  {3355, 3252, 3429},
  {3209, 3248, 3431},
  {3302, 3429, 3252},
  {3255, 3566, 3304},
  {3392, 3255, 3359},
  {3360, 3256, 3305},
  {3360, 6221, 3306},
  {3173, 3393, 3433},
  {3360, 3305, 6221},
  {3395, 3308, 3307},
  {3434, 3173, 3433},
  {3308, 3395, 3361},
  {3261, 3434, 3362},
  {3265, 3364, 3309},
  {3310, 3311, 3362},
  {3213, 4029, 3315},
  {3215, 3316, 3438},
  {3215, 3438, 3363},
  {3318, 3314, 3317},
  {3365, 3401, 3364},
  {3034, 3442, 3403},
  {3441, 3138, 3405},
  {3138, 3441, 3319},
  {3367, 3405, 3216},
  {3442, 3320, 3406},
  {3217, 3444, 3274},
  {3406, 3320, 3275},
  {3444, 3273, 3274},
  {3371, 3273, 3409},
  {3273, 3444, 3407},
  {3277, 3369, 3368},
  {3277, 3368, 3272},
  {3277, 3322, 3369},
  {3487, 3184, 3529},
  {3278, 3448, 3188},
  {3280, 3324, 3323},
  {3188, 3533, 3372},
  {3324, 3279, 3412},
  {3188, 3372, 3325},
  {3325, 3372, 3281},
  {3190, 3281, 3372},
  {3190, 3372, 3413},
  {3326, 3373, 3376},
  {3376, 3374, 3375},
  {3375, 3376, 3374},
  {3329, 3328, 3494},
  {3283, 3494, 3282},
  {3377, 3284, 3375},
  {3378, 3454, 3229},
  {3331, 5987, 3332},
  {3328, 3329, 3380},
  {3285, 3457, 3379},
  {3378, 3229, 3379},
  {3419, 3230, 3377},
  {3288, 3380, 3329},
  {3334, 3332, 3333},
  {3333, 3051, 3334},
  {3335, 3334, 3051},
  {3288, 3290, 3380},
  {3418, 3380, 3290},
  {3051, 3292, 3335},
  {3420, 3418, 3290},
  {3233, 3291, 3421},
  {3496, 3421, 3291},
  {3338, 3422, 3339},
  {3291, 3382, 3496},
  {3238, 3498, 3382},
  {3236, 3237, 3381},
  {3386, 3344, 3424},
  {3500, 3385, 3340},
  {3340, 3385, 3463},
  {3102, 5984, 3548},
  {3342, 3463, 3502},
  {3342, 3502, 3345},
  {3344, 3064, 3424},
  {3503, 3387, 3349},
  {3241, 3511, 6242},
  {3299, 6242, 3470},
  {3503, 3349, 3245},
  {3353, 3352, 3299},
  {3299, 3470, 3353},
  {3245, 3246, 3388},
  {3246, 3355, 3388},
  {3473, 3389, 3354},
  {3357, 3354, 3389},
  {3429, 3388, 3355},
  {3562, 3302, 3351},
  {3248, 3206, 3356},
  {3209, 3431, 3390},
  {3248, 3356, 3431},
  {3304, 3566, 3303},
  {3358, 3727, 3254},
  {3254, 3727, 3391},
  {3392, 3359, 3313},
  {3394, 3432, 3305},
  {3306, 3514, 3393},
  {3305, 3432, 3398},
  {3397, 3392, 3396},
  {3397, 3435, 3392},
  {3394, 3212, 3262},
  {6221, 3398, 3399},
  {3398, 6221, 3305},
  {3396, 3392, 3400},
  {3392, 3313, 3400},
  {3361, 3395, 3262},
  {3314, 3400, 3313},
  {3310, 3362, 3436},
  {6208, 3438, 3310},
  {3438, 3402, 3363},
  {3365, 3315, 4029},
  {3694, 3364, 3401},
  {3366, 3268, 3402},
  {3269, 3366, 3270},
  {3519, 3270, 3366},
  {3366, 3402, 3519},
  {3439, 3270, 3519},
  {3439, 3216, 3270},
  {3403, 3442, 3577},
  {3216, 3440, 3367},
  {3319, 3404, 3217},
  {3405, 3367, 3443},
  {3444, 3217, 3485},
  {3321, 3631, 3526},
  {3273, 3407, 3409},
  {3407, 3444, 3446},
  {3369, 3445, 3408},
  {3369, 3408, 3368},
  {3272, 3368, 3486},
  {3278, 3371, 3581},
  {3369, 3322, 3445},
  {3188, 3448, 3533},
  {3324, 3412, 3323},
  {3450, 3323, 3412},
  {3411, 3372, 3533},
  {3449, 3190, 3413},
  {3413, 3372, 3414},
  {3411, 3414, 3372},
  {3416, 3326, 3415},
  {3454, 3415, 3326},
  {3326, 3416, 3373},
  {3376, 3377, 3375},
  {3330, 3417, 5862},
  {3494, 3328, 5862},
  {3457, 3282, 3494},
  {3282, 3457, 3285},
  {3377, 3456, 3419},
  {3330, 3328, 3420},
  {3328, 3380, 3418},
  {3328, 3418, 3420},
  {3419, 3458, 3338},
  {3419, 3338, 3337},
  {3458, 3422, 3338},
  {3381, 3461, 3459},
  {3422, 3383, 3339},
  {3237, 3461, 3381},
  {3384, 3383, 3423},
  {5984, 3601, 3548},
  {3423, 3340, 3384},
  {3340, 3423, 3500},
  {3386, 3462, 3099},
  {3343, 3502, 3341},
  {3343, 3345, 3502},
  {3102, 3548, 3464},
  {3064, 3465, 3424},
  {3424, 3462, 3386},
  {3425, 3387, 3503},
  {3467, 3468, 3348},
  {3348, 3468, 3426},
  {3507, 6242, 3469},
  {3428, 3427, 3351},
  {3241, 3561, 3511},
  {3388, 3651, 3245},
  {3473, 3353, 3470},
  {3357, 3389, 3430},
  {3303, 3833, 3164},
  {3303, 3566, 3512},
  {3255, 3435, 3566},
  {3435, 3255, 3392},
  {3393, 3514, 3433},
  {3306, 6221, 3514},
  {3307, 3309, 3516},
  {3307, 3516, 3395},
  {3619, 3435, 3397},
  {3397, 3396, 3619},
  {3400, 3619, 3396},
  {3478, 3436, 3362},
  {3362, 3434, 3478},
  {3398, 3518, 3399},
  {3399, 3518, 6221},
  {6208, 3310, 3437},
  {3310, 3436, 3437},
  {3477, 3437, 3436},
  {3398, 3481, 3518},
  {3400, 3314, 3619},
  {3440, 3216, 3439},
  {3403, 3577, 3576},
  {3441, 3404, 3319},
  {3440, 3443, 3367},
  {3404, 3441, 3217},
  {3217, 3441, 3483},
  {3217, 3483, 3485},
  {3275, 3486, 3406},
  {3408, 3486, 3368},
  {3581, 3448, 3278},
  {3445, 3322, 3527},
  {3488, 3370, 3531},
  {3672, 3527, 3322},
  {3322, 3410, 3672},
  {3530, 3447, 3323},
  {3323, 3450, 3530},
  {3279, 3488, 3412},
  {3449, 3370, 3190},
  {3488, 5991, 3412},
  {3413, 3414, 3449},
  {3415, 3452, 3451},
  {3451, 3452, 3590},
  {3453, 3415, 3451},
  {3415, 3453, 3416},
  {3415, 3454, 3452},
  {3453, 3455, 3416},
  {3373, 3416, 3455},
  {3455, 3376, 3373},
  {5862, 3417, 3540},
  {3376, 3455, 3377},
  {3455, 3456, 3377},
  {3419, 3456, 3495},
  {3417, 3330, 3420},
  {3417, 3420, 3496},
  {3421, 3496, 3420},
  {3497, 3458, 3419},
  {3381, 3459, 3460},
  {3381, 3460, 3601},
  {3383, 3422, 3499},
  {3461, 3237, 3647},
  {3643, 3498, 3238},
  {3462, 3643, 3238},
  {3383, 3499, 3423},
  {3424, 3465, 3501},
  {3385, 3500, 3463},
  {3424, 3501, 3462},
  {3553, 3462, 3501},
  {3064, 3425, 3465},
  {3466, 3465, 3425},
  {3503, 3466, 3425},
  {3467, 3504, 3468},
  {3426, 3505, 3241},
  {3506, 3241, 3505},
  {3507, 3508, 6242},
  {3470, 6242, 3508},
  {3427, 3611, 3351},
  {3611, 3427, 3471},
  {3427, 3428, 3471},
  {3428, 3509, 3471},
  {3474, 3469, 6242},
  {3474, 6242, 3472},
  {3510, 3511, 3561},
  {3511, 3474, 3472},
  {3469, 3474, 3476},
  {3476, 3475, 3508},
  {3473, 3508, 3475},
  {3473, 3475, 3389},
  {3302, 3562, 3429},
  {3509, 3164, 3833},
  {3389, 3564, 3430},
  {3515, 3433, 3514},
  {3433, 3515, 3434},
  {3262, 3395, 3516},
  {3394, 3262, 3618},
  {3477, 3514, 6221},
  {3434, 3515, 3478},
  {3479, 3477, 6221},
  {3478, 3514, 3436},
  {3481, 3398, 3480},
  {3518, 3573, 6221},
  {3571, 6221, 3573},
  {3477, 6208, 3437},
  {3402, 3438, 3519},
  {3401, 3365, 3694},
  {3439, 3668, 3440},
  {3440, 3668, 3520},
  {3440, 3520, 3443},
  {3405, 3484, 3441},
  {3441, 3484, 3482},
  {3441, 3482, 3483},
  {3443, 3520, 3484},
  {3443, 3484, 3405},
  {3318, 3321, 3580},
  {3524, 3442, 3406},
  {3486, 3523, 3406},
  {3630, 3446, 3485},
  {3406, 3523, 3524},
  {3409, 3407, 3630},
  {3630, 3407, 3446},
  {3444, 3485, 3446},
  {3486, 3408, 3445},
  {3581, 3371, 6300},
  {3409, 6300, 3371},
  {3633, 3445, 3527},
  {3445, 3633, 3486},
  {3531, 3532, 3488},
  {3487, 3672, 3410},
  {3411, 3535, 3414},
  {3590, 3491, 3451},
  {3451, 3491, 3453},
  {3453, 3491, 3538},
  {3453, 3538, 3455},
  {3492, 3588, 5862},
  {3452, 3454, 3537},
  {3455, 3538, 3493},
  {3454, 3378, 3379},
  {3455, 3493, 3539},
  {3494, 3594, 3595},
  {3494, 3595, 3457},
  {3455, 3539, 3456},
  {3417, 3496, 3540},
  {3419, 3495, 3497},
  {3495, 3543, 3497},
  {3458, 3497, 3422},
  {3545, 3422, 3497},
  {3496, 3382, 3498},
  {3547, 3460, 3459},
  {3598, 3459, 3461},
  {3460, 3547, 3601},
  {3422, 3599, 3499},
  {3598, 3461, 3647},
  {3647, 3237, 3341},
  {3553, 3643, 3462},
  {3500, 3423, 3499},
  {3502, 3463, 3500},
  {3557, 3501, 3465},
  {3465, 3466, 3557},
  {3503, 3557, 3466},
  {3468, 3504, 3426},
  {3504, 3505, 3426},
  {3245, 3651, 3559},
  {3511, 3472, 6242},
  {3470, 3508, 3473},
  {3241, 3506, 3682},
  {3241, 3682, 3561},
  {3469, 3476, 3507},
  {3507, 3476, 3508},
  {3653, 3351, 3611},
  {3510, 3563, 3511},
  {3655, 3474, 3511},
  {3474, 3655, 3476},
  {3476, 3655, 3475},
  {3389, 3475, 3564},
  {3833, 3303, 3512},
  {3431, 3356, 3513},
  {3356, 3567, 3513},
  {3658, 3213, 3391},
  {3569, 3432, 3568},
  {3617, 3394, 3618},
  {3394, 3617, 3432},
  {3568, 3432, 3617},
  {3516, 3618, 3262},
  {3514, 3478, 3515},
  {3479, 6221, 3571},
  {3477, 3479, 6208},
  {3477, 3436, 3514},
  {3309, 3364, 3659},
  {3309, 3659, 3516},
  {3480, 3398, 3570},
  {3481, 3480, 3574},
  {3481, 3574, 3517},
  {3481, 3517, 3518},
  {3438, 3626, 3519},
  {3483, 3482, 3521},
  {3521, 3578, 3483},
  {3484, 3521, 3482},
  {3442, 3524, 3577},
  {3579, 3484, 3520},
  {3522, 3483, 3578},
  {3483, 3522, 3485},
  {3321, 3526, 3580},
  {3630, 3485, 3522},
  {3527, 3528, 3633},
  {3447, 3530, 3529},
  {3448, 3581, 3533},
  {3532, 3534, 3488},
  {3531, 3370, 3582},
  {3487, 3583, 3672},
  {3487, 3807, 3583},
  {3370, 3449, 3674},
  {3449, 3414, 3536},
  {3414, 3675, 3536},
  {3414, 3535, 3587},
  {3414, 3587, 3675},
  {3490, 6459, 3492},
  {3537, 3590, 3452},
  {3590, 3591, 3491},
  {3489, 3492, 6448},
  {3491, 3591, 3538},
  {3537, 3454, 3589},
  {3379, 3589, 3454},
  {3641, 3492, 3540},
  {3493, 3593, 3539},
  {3594, 3494, 5862},
  {3457, 3595, 3379},
  {3589, 3379, 3595},
  {3539, 3541, 3456},
  {3495, 3456, 3541},
  {3642, 3540, 3496},
  {3542, 3541, 3539},
  {3541, 3542, 3495},
  {3543, 3495, 3542},
  {3496, 3544, 3642},
  {3542, 3599, 3543},
  {3497, 3543, 3599},
  {3544, 3496, 3596},
  {3422, 3545, 3546},
  {3459, 3598, 3547},
  {3422, 3546, 3599},
  {3547, 3600, 3601},
  {3499, 3604, 3500},
  {3464, 3548, 3606},
  {3464, 3606, 3467},
  {3549, 3551, 5992},
  {3501, 3557, 3552},
  {3501, 3552, 3605},
  {5992, 3551, 3555},
  {3551, 3609, 3555},
  {3557, 3556, 3552},
  {5992, 3555, 3610},
  {3610, 3606, 5992},
  {3557, 3503, 3558},
  {3560, 3558, 3503},
  {3651, 3503, 3559},
  {3245, 3559, 3503},
  {3560, 3503, 3651},
  {3506, 3505, 3504},
  {3612, 3651, 3388},
  {3388, 3429, 3612},
  {3653, 3562, 3351},
  {3471, 3509, 3939},
  {3562, 3612, 3429},
  {3563, 3613, 3511},
  {3688, 3511, 3613},
  {3511, 3688, 3655},
  {3430, 3564, 3565},
  {3569, 3657, 3432},
  {3479, 3571, 6208},
  {3570, 3574, 3480},
  {3571, 3572, 6209},
  {3571, 3573, 3572},
  {3517, 3574, 3575},
  {3518, 3517, 3575},
  {3518, 3793, 3573},
  {3623, 3575, 3664},
  {3518, 3575, 3623},
  {3438, 6208, 3626},
  {3314, 3318, 3740},
  {3439, 3519, 3742},
  {3439, 3742, 3668},
  {3521, 3665, 3578},
  {3577, 3524, 3627},
  {3665, 3521, 3484},
  {3486, 3670, 3523},
  {3523, 3670, 3524},
  {3528, 3632, 3633},
  {3534, 3532, 3634},
  {3532, 3531, 3635},
  {3532, 3635, 3634},
  {3531, 3582, 3635},
  {3529, 3853, 3487},
  {3674, 3582, 3370},
  {3586, 3530, 3450},
  {3584, 3411, 3533},
  {3535, 3411, 3584},
  {3585, 3535, 3584},
  {5991, 3488, 3586},
  {3490, 3492, 6459},
  {5862, 3588, 3676},
  {3592, 3538, 3591},
  {3593, 3538, 3592},
  {3538, 3593, 3493},
  {3642, 3544, 3596},
  {3642, 3596, 3677},
  {3496, 3498, 3597},
  {3497, 3599, 3545},
  {3599, 3546, 3545},
  {3547, 3598, 3600},
  {3598, 3679, 3644},
  {3598, 3644, 3600},
  {3600, 3644, 3646},
  {3603, 3502, 3500},
  {3602, 3549, 3601},
  {3604, 3681, 3603},
  {3604, 3603, 3500},
  {3502, 3647, 3341},
  {3548, 3601, 3606},
  {3773, 3648, 3605},
  {3605, 3649, 3501},
  {3605, 3648, 3649},
  {3553, 3501, 3649},
  {3601, 3549, 5992},
  {5994, 3554, 3607},
  {3551, 3550, 3608},
  {3605, 3552, 3773},
  {3556, 3773, 3552},
  {6071, 3607, 3554},
  {3609, 3551, 3608},
  {3606, 3601, 5992},
  {3650, 3610, 3555},
  {3555, 3609, 3650},
  {3777, 3557, 3558},
  {3560, 3777, 3558},
  {3467, 3606, 3682},
  {3682, 3504, 3467},
  {3504, 3682, 3506},
  {3651, 3612, 3683},
  {3561, 3563, 3510},
  {3562, 3653, 3612},
  {3563, 3654, 3613},
  {3475, 3565, 3564},
  {3390, 3687, 3656},
  {3614, 3615, 3566},
  {3512, 3566, 3615},
  {3431, 3513, 3687},
  {3431, 3687, 3390},
  {3430, 3565, 3616},
  {3430, 3616, 6075},
  {3513, 3567, 3687},
  {3568, 3617, 3569},
  {3569, 3617, 3657},
  {3617, 3618, 3659},
  {3432, 3657, 3398},
  {3659, 3618, 3516},
  {4029, 3213, 3660},
  {3661, 3659, 3364},
  {3572, 3573, 6210},
  {3662, 6404, 6406},
  {3621, 3573, 3793},
  {6406, 6404, 3662},
  {3574, 3620, 3575},
  {3575, 3620, 3664},
  {3314, 3740, 3619},
  {6476, 3622, 6405},
  {3793, 3518, 3623},
  {6208, 3622, 3626},
  {3622, 3624, 3626},
  {3035, 3403, 4074},
  {3403, 3576, 4074},
  {3578, 3665, 3666},
  {3578, 3666, 3667},
  {3578, 3667, 3522},
  {3520, 3668, 3579},
  {3522, 3667, 3630},
  {3580, 3526, 3799},
  {3524, 3628, 3627},
  {3579, 3668, 3629},
  {3579, 6299, 3484},
  {3630, 3669, 3409},
  {3526, 3631, 3698},
  {3581, 6300, 3533},
  {3672, 6301, 3527},
  {3701, 3529, 3530},
  {3534, 3634, 3636},
  {3534, 3636, 3488},
  {3853, 3807, 3487},
  {3672, 3583, 3915},
  {3701, 3530, 3586},
  {3673, 3584, 3533},
  {3637, 3585, 3584},
  {3535, 3585, 3637},
  {3639, 3587, 3535},
  {3586, 3488, 3706},
  {3449, 3536, 3674},
  {3536, 3675, 3674},
  {3638, 3968, 3639},
  {3537, 3709, 3590},
  {3590, 3762, 3591},
  {3589, 3595, 3640},
  {3590, 3709, 3762},
  {5862, 3676, 3595},
  {3593, 3592, 3867},
  {5862, 3595, 3594},
  {3539, 3593, 3542},
  {3540, 3711, 3641},
  {3496, 3597, 3596},
  {3596, 3597, 3677},
  {3679, 3598, 3647},
  {3646, 3680, 3645},
  {3600, 3646, 3601},
  {3646, 3645, 3601},
  {3602, 3601, 3645},
  {3818, 3604, 3499},
  {3681, 3604, 3818},
  {6095, 3721, 3608},
  {6095, 3608, 3550},
  {3608, 3721, 3609},
  {3606, 3610, 3722},
  {3610, 3778, 3722},
  {3606, 3722, 3682},
  {3611, 3652, 3653},
  {3471, 3939, 3723},
  {3561, 3682, 3563},
  {3612, 3653, 3683},
  {3613, 3654, 3688},
  {3655, 5996, 3475},
  {3358, 3390, 3656},
  {3475, 6470, 3565},
  {3565, 6470, 3616},
  {3614, 3566, 3838},
  {3566, 3435, 3838},
  {3391, 3727, 3689},
  {3732, 3435, 3619},
  {3391, 3689, 3658},
  {3657, 3617, 3691},
  {3213, 3658, 3660},
  {3734, 3570, 3398},
  {3793, 3791, 3621},
  {3364, 3694, 3661},
  {3664, 3620, 3663},
  {3663, 3625, 3664},
  {3624, 3622, 6476},
  {3663, 3696, 3625},
  {3625, 3696, 3664},
  {3697, 3624, 3695},
  {3626, 3624, 3697},
  {3519, 3626, 3742},
  {3035, 3631, 3525},
  {3577, 3627, 3576},
  {3669, 3665, 3484},
  {3670, 3627, 3628},
  {3579, 3699, 6299},
  {3484, 6299, 3669},
  {3524, 3670, 3628},
  {3579, 3629, 3747},
  {3409, 3669, 3744},
  {3579, 3747, 3699},
  {3698, 3631, 5863},
  {3486, 3633, 3746},
  {6301, 3672, 3671},
  {3632, 3671, 3633},
  {3634, 3635, 3636},
  {3488, 3636, 3705},
  {3702, 3636, 3635},
  {3635, 3582, 3702},
  {3586, 3706, 3701},
  {3673, 3637, 3584},
  {3583, 3807, 3915},
  {3703, 3754, 3638},
  {3703, 3638, 3639},
  {3916, 3488, 3705},
  {3968, 3638, 3754},
  {3639, 3535, 3637},
  {3639, 3637, 3673},
  {3706, 3488, 3916},
  {3675, 3639, 3968},
  {3639, 3675, 3587},
  {3675, 3968, 3674},
  {3588, 3865, 3676},
  {3492, 3641, 3588},
  {3588, 3641, 3812},
  {3676, 3640, 3595},
  {5993, 3710, 3709},
  {5993, 3709, 3537},
  {3812, 3641, 3763},
  {3641, 3711, 3763},
  {3713, 3540, 3642},
  {3712, 3540, 3713},
  {3540, 3712, 3711},
  {3677, 3597, 3714},
  {3767, 3714, 3597},
  {3597, 3498, 3767},
  {3498, 3643, 3717},
  {3599, 3718, 3678},
  {3814, 3716, 3603},
  {3499, 3599, 3818},
  {3648, 3773, 3649},
  {3643, 3553, 3649},
  {3602, 3720, 6095},
  {3557, 3777, 3556},
  {3610, 3650, 3778},
  {3777, 3651, 3780},
  {3651, 3777, 3560},
  {3611, 3723, 3652},
  {3651, 3683, 3780},
  {3611, 3471, 3723},
  {3563, 3682, 3684},
  {3684, 3682, 3685},
  {3563, 3684, 3654},
  {3684, 3686, 3654},
  {3654, 3686, 3688},
  {3358, 3656, 3781},
  {3655, 3892, 3783},
  {3655, 3783, 5996},
  {3512, 3615, 3833},
  {3567, 3356, 3785},
  {3730, 3785, 3356},
  {3356, 3731, 3730},
  {3728, 3731, 3356},
  {3356, 3430, 3728},
  {3430, 6074, 3728},
  {6076, 3728, 6074},
  {3732, 3838, 3435},
  {3690, 3617, 3787},
  {3617, 3690, 3691},
  {3733, 3732, 3619},
  {3398, 3657, 3734},
  {3788, 3660, 3658},
  {3659, 3661, 3735},
  {3694, 3735, 3661},
  {3944, 3619, 3736},
  {3620, 3574, 3789},
  {3693, 3621, 3791},
  {3739, 3692, 3619},
  {3663, 3620, 3789},
  {6478, 3624, 6476},
  {3739, 3619, 3795},
  {3696, 3663, 3794},
  {3619, 3740, 3795},
  {3624, 6478, 3695},
  {3697, 3695, 6478},
  {3844, 3626, 3697},
  {3580, 3799, 3318},
  {4074, 3576, 3905},
  {3665, 3667, 3666},
  {3742, 3745, 3668},
  {3665, 3630, 3667},
  {3576, 3627, 3743},
  {3576, 3743, 3905},
  {3668, 3745, 3629},
  {3630, 3665, 3669},
  {3749, 3631, 3802},
  {3627, 3670, 3743},
  {3629, 3745, 3747},
  {3486, 3746, 3670},
  {3670, 3746, 3743},
  {3752, 3671, 3700},
  {3671, 3672, 3700},
  {3751, 3700, 3672},
  {3701, 3853, 3529},
  {3671, 3752, 3633},
  {3702, 3705, 3636},
  {3673, 3533, 6300},
  {5995, 3915, 3704},
  {3639, 3673, 3756},
  {3639, 3756, 3703},
  {3582, 3674, 3809},
  {3674, 3968, 3707},
  {3968, 3758, 3707},
  {3865, 3588, 3708},
  {3761, 3640, 3676},
  {3640, 3710, 5993},
  {3640, 3761, 3710},
  {3762, 3867, 3591},
  {3591, 3867, 3592},
  {3867, 3542, 3593},
  {3713, 3768, 3712},
  {3714, 3642, 3677},
  {3642, 3714, 3767},
  {3642, 3767, 3713},
  {3713, 3767, 3768},
  {3498, 3717, 4008},
  {3715, 3766, 3716},
  {3599, 3542, 3718},
  {3715, 3716, 3814},
  {3816, 3717, 3643},
  {3719, 3679, 3647},
  {3679, 3719, 3644},
  {3646, 3644, 3719},
  {6004, 3816, 3643},
  {3719, 3680, 3646},
  {3599, 3770, 3818},
  {3680, 3719, 3645},
  {3645, 3719, 3602},
  {6004, 3643, 3822},
  {4010, 3647, 3502},
  {3602, 3719, 3720},
  {3822, 3649, 3773},
  {6095, 3720, 3721},
  {3609, 3775, 3650},
  {3778, 3650, 3776},
  {3650, 3775, 3776},
  {4063, 3777, 3780},
  {3652, 3723, 3934},
  {3653, 3652, 3934},
  {3653, 3725, 3683},
  {3682, 3724, 3685},
  {3685, 3724, 3726},
  {3358, 3781, 3727},
  {3781, 3656, 3832},
  {3687, 3836, 3656},
  {3688, 3782, 3655},
  {3614, 3838, 3615},
  {3691, 3690, 3787},
  {3691, 3734, 3657},
  {3617, 3659, 3735},
  {3660, 3788, 6003},
  {3660, 6003, 4029},
  {3789, 3574, 3570},
  {3692, 3736, 3619},
  {3736, 3692, 6316},
  {3736, 6316, 3737},
  {6204, 6320, 3738},
  {3792, 3693, 3791},
  {6476, 6477, 6478},
  {3664, 3948, 3623},
  {3793, 3623, 3948},
  {3664, 3696, 3948},
  {3365, 4029, 3952},
  {3741, 3948, 3696},
  {3796, 3741, 3794},
  {3740, 6184, 6112},
  {3741, 3796, 3948},
  {3740, 3318, 6184},
  {3799, 3526, 3698},
  {3802, 3631, 3035},
  {3749, 3802, 3698},
  {3698, 5863, 3749},
  {3699, 3747, 6299},
  {5998, 3752, 3700},
  {3753, 3754, 3703},
  {3750, 3700, 3751},
  {3751, 3672, 3914},
  {3704, 3914, 3672},
  {3755, 3705, 3702},
  {3852, 3703, 3808},
  {3755, 3702, 3582},
  {3673, 6300, 3756},
  {3701, 3706, 4001},
  {3705, 3809, 3916},
  {3703, 3756, 3808},
  {3756, 6300, 3808},
  {3706, 3757, 4001},
  {3674, 3707, 3917},
  {3707, 3758, 3759},
  {3758, 3760, 3759},
  {3708, 3921, 3865},
  {3865, 3761, 3676},
  {3762, 3709, 3710},
  {3542, 3867, 4166},
  {3765, 3764, 3766},
  {3711, 4008, 3763},
  {3712, 4008, 3711},
  {3712, 3813, 4008},
  {3768, 3769, 3712},
  {3712, 3769, 3813},
  {3767, 3498, 3768},
  {3769, 3768, 3498},
  {3603, 3923, 3814},
  {3678, 3817, 3599},
  {3770, 3599, 3817},
  {3819, 3603, 3716},
  {3771, 3719, 3647},
  {3649, 3822, 3643},
  {3772, 3681, 3818},
  {3772, 3603, 3681},
  {3820, 3719, 3771},
  {3719, 3820, 3720},
  {3822, 3927, 6004},
  {3603, 3819, 3502},
  {4010, 3502, 3819},
  {3820, 3824, 3720},
  {3823, 3821, 3773},
  {3721, 3720, 3824},
  {3773, 3556, 3823},
  {3721, 3826, 3609},
  {3826, 3721, 3825},
  {3774, 3609, 3826},
  {3609, 3774, 3775},
  {3556, 3777, 4063},
  {3776, 3775, 3827},
  {3722, 3778, 3779},
  {3682, 3722, 3724},
  {3722, 3779, 3724},
  {3653, 3934, 4134},
  {3726, 3684, 3685},
  {3726, 4021, 3684},
  {3686, 3684, 4021},
  {3832, 3656, 3831},
  {3782, 3892, 3655},
  {5996, 3783, 3729},
  {3615, 3838, 3833},
  {6076, 3784, 3728},
  {3687, 3567, 3893},
  {3730, 3731, 3834},
  {3837, 3893, 3567},
  {3567, 3785, 3837},
  {4024, 3689, 3727},
  {3894, 3838, 3732},
  {3839, 3689, 4024},
  {3732, 3733, 3894},
  {3896, 3894, 3733},
  {3786, 3896, 3733},
  {3689, 3839, 3658},
  {3841, 3658, 3839},
  {3734, 3691, 3787},
  {3733, 3944, 3786},
  {3944, 3733, 3619},
  {3570, 3734, 3789},
  {3734, 3787, 3789},
  {3944, 3736, 3842},
  {3736, 3737, 3842},
  {6318, 6342, 6216},
  {3739, 3945, 3692},
  {6316, 3692, 3945},
  {3696, 3794, 3741},
  {3697, 6478, 3844},
  {3742, 3626, 3844},
  {3742, 3844, 3951},
  {3952, 3694, 3365},
  {3796, 3800, 3948},
  {3796, 3902, 3800},
  {3800, 3801, 3948},
  {3318, 3799, 3798},
  {3318, 3798, 6184},
  {3905, 3743, 3803},
  {3743, 3746, 3803},
  {6173, 3803, 3746},
  {6299, 3747, 3996},
  {3747, 3745, 3906},
  {6299, 3996, 3850},
  {3805, 3754, 3753},
  {3851, 3753, 3703},
  {5998, 6179, 3752},
  {3855, 3853, 3701},
  {3805, 3806, 3754},
  {3851, 3703, 3852},
  {3807, 3853, 3854},
  {3859, 6299, 3858},
  {3808, 6299, 3859},
  {3701, 4001, 3855},
  {3705, 3755, 3809},
  {5999, 3582, 3809},
  {3916, 3757, 3706},
  {3917, 3707, 3970},
  {3707, 3759, 3970},
  {3861, 3760, 3758},
  {3970, 3759, 3864},
  {3759, 3760, 3864},
  {3760, 3861, 3864},
  {3762, 3710, 6107},
  {3765, 3868, 3764},
  {3769, 3498, 3813},
  {3813, 3498, 4008},
  {3715, 3814, 3766},
  {3924, 4008, 3717},
  {3717, 3816, 3924},
  {3542, 3815, 3718},
  {3718, 3815, 3876},
  {3718, 3876, 3678},
  {3817, 3678, 3876},
  {3819, 3716, 3766},
  {3766, 3877, 3819},
  {3772, 3923, 3603},
  {3818, 3770, 3817},
  {3771, 3879, 3820},
  {3773, 3821, 3822},
  {3721, 3931, 3825},
  {3778, 3776, 3828},
  {3779, 3778, 3724},
  {3778, 3828, 3724},
  {3780, 3683, 3983},
  {3780, 3983, 4132},
  {3723, 3939, 3887},
  {3724, 3776, 3830},
  {4134, 3725, 3653},
  {3830, 3776, 3829},
  {3683, 3937, 3983},
  {3683, 3725, 3937},
  {3830, 3889, 3724},
  {3726, 3724, 4021},
  {3831, 3656, 3836},
  {4022, 3686, 4021},
  {3686, 4022, 3688},
  {3892, 3688, 4022},
  {3688, 3892, 3782},
  {3731, 3892, 3834},
  {3731, 3783, 3892},
  {3835, 3783, 3731},
  {3783, 3784, 3729},
  {3783, 3835, 3784},
  {3893, 3836, 3687},
  {3731, 3728, 3784},
  {3835, 3731, 3784},
  {3892, 3785, 3834},
  {3730, 3834, 3785},
  {3787, 3617, 3840},
  {6002, 3658, 3790},
  {3789, 3787, 3840},
  {3841, 3790, 3658},
  {4235, 3617, 3735},
  {3735, 3694, 4235},
  {3737, 6316, 3945},
  {3737, 3945, 3842},
  {6319, 6215, 6317},
  {3794, 3663, 3898},
  {3793, 3899, 3791},
  {3948, 3946, 3793},
  {3739, 3795, 3900},
  {3794, 3902, 3796},
  {3795, 3740, 3900},
  {3951, 3844, 3949},
  {3951, 3846, 3742},
  {6112, 6184, 3845},
  {6112, 3845, 3740},
  {3740, 3845, 3900},
  {6183, 3797, 6113},
  {6183, 6113, 3797},
  {6184, 3798, 3845},
  {3742, 3846, 3906},
  {3798, 3799, 3845},
  {3847, 3948, 3801},
  {3800, 3848, 3801},
  {3847, 3801, 3848},
  {3848, 3904, 3847},
  {3742, 3906, 3745},
  {6173, 3905, 3803},
  {3747, 3906, 3996},
  {3746, 3849, 6173},
  {3633, 3995, 3746},
  {3999, 3806, 3805},
  {3805, 3753, 3999},
  {3911, 6299, 3850},
  {3856, 3857, 3806},
  {3754, 3806, 3857},
  {3808, 3910, 3852},
  {6299, 3911, 3858},
  {3965, 3914, 3704},
  {3915, 3807, 4038},
  {3809, 3674, 3917},
  {3809, 3917, 3916},
  {3810, 3757, 4003},
  {3758, 3860, 3861},
  {3811, 6345, 6344},
  {3918, 3812, 3763},
  {3865, 3710, 3761},
  {3762, 3866, 3867},
  {3762, 6107, 6225},
  {6000, 6278, 3869},
  {4008, 4086, 3763},
  {6197, 3766, 3764},
  {3765, 3869, 3868},
  {3872, 3766, 6197},
  {3814, 3870, 3869},
  {3869, 3765, 3814},
  {3766, 3814, 3765},
  {3876, 3874, 3871},
  {6008, 3766, 6006},
  {3871, 3870, 3876},
  {3875, 3874, 3876},
  {3876, 3870, 3923},
  {3870, 3814, 3923},
  {3875, 3876, 3815},
  {3876, 3923, 3878},
  {3878, 3772, 3876},
  {3923, 3772, 3878},
  {3817, 3876, 3818},
  {3876, 3772, 3818},
  {3771, 3926, 3879},
  {3771, 3647, 3926},
  {6004, 3927, 3925},
  {4010, 3926, 3647},
  {3824, 3820, 3926},
  {3824, 3926, 4011},
  {3821, 3823, 3822},
  {3822, 3823, 3928},
  {3981, 4013, 3721},
  {3981, 3721, 3824},
  {3881, 3882, 3880},
  {3721, 3930, 3931},
  {3826, 3936, 3774},
  {3774, 3936, 3827},
  {3774, 3827, 3775},
  {3881, 3932, 3882},
  {3886, 3883, 3885},
  {3936, 3776, 3827},
  {4063, 3780, 4132},
  {3776, 3724, 3828},
  {3887, 3934, 3723},
  {3887, 3939, 3935},
  {3776, 3936, 3829},
  {3888, 3829, 3936},
  {4134, 3937, 3725},
  {3830, 3829, 3889},
  {3938, 3829, 3888},
  {3940, 3890, 3832},
  {3891, 3940, 3832},
  {3832, 3831, 3891},
  {3836, 3891, 3831},
  {3509, 3833, 3939},
  {3985, 4020, 3836},
  {3941, 3785, 3892},
  {3943, 3785, 3941},
  {3893, 3837, 3942},
  {3837, 3895, 3942},
  {3896, 3786, 3944},
  {6231, 6232, 3897},
  {6231, 3897, 6232},
  {3840, 3988, 3789},
  {4235, 3840, 3617},
  {3944, 3842, 3989},
  {3791, 3844, 3792},
  {3793, 3946, 3899},
  {3844, 3791, 3899},
  {3899, 3946, 3949},
  {3843, 3792, 3844},
  {3899, 3949, 3844},
  {3739, 3900, 3947},
  {4236, 3694, 3950},
  {3802, 3900, 3845},
  {3950, 3694, 3952},
  {3698, 3845, 3799},
  {3845, 3698, 3802},
  {3802, 3035, 4030},
  {3902, 3903, 3800},
  {3848, 3800, 3903},
  {3848, 3955, 3904},
  {3905, 6173, 6174},
  {6173, 3849, 3995},
  {3804, 6151, 3907},
  {3746, 3995, 3849},
  {3996, 3908, 3850},
  {3995, 3633, 4111},
  {3996, 3956, 3908},
  {3856, 3806, 3909},
  {3806, 3999, 3909},
  {3753, 3851, 3999},
  {3851, 3852, 3999},
  {3852, 3910, 3999},
  {3850, 3908, 3911},
  {3853, 3855, 3854},
  {3909, 3913, 3857},
  {3909, 3857, 3856},
  {3909, 3959, 3913},
  {3914, 3961, 3751},
  {6179, 6469, 3752},
  {3854, 3912, 3807},
  {3854, 3855, 3912},
  {3910, 3808, 3858},
  {3910, 3858, 3911},
  {3858, 3808, 3859},
  {3857, 3968, 3754},
  {3704, 3915, 3965},
  {3967, 4001, 3757},
  {3758, 3968, 3970},
  {3810, 3967, 3757},
  {3916, 4003, 3757},
  {3758, 3970, 3860},
  {3810, 3862, 3967},
  {3969, 3810, 4003},
  {3860, 3864, 3861},
  {3862, 3863, 3971},
  {4082, 3917, 3970},
  {3969, 3862, 3810},
  {3972, 3971, 3863},
  {3812, 3918, 3919},
  {3920, 3919, 3918},
  {3812, 3919, 3921},
  {6007, 3918, 3973},
  {3973, 3918, 3922},
  {3763, 3922, 3918},
  {3921, 4088, 3865},
  {3865, 4088, 3710},
  {3974, 6107, 3710},
  {3922, 3763, 4086},
  {3869, 3975, 6000},
  {4008, 4089, 4086},
  {3869, 3870, 3975},
  {6197, 3764, 6161},
  {3872, 3873, 6001},
  {4125, 3815, 3542},
  {3766, 6008, 3877},
  {3877, 3977, 3819},
  {3815, 4125, 6010},
  {3879, 3926, 3820},
  {3824, 4011, 3981},
  {3980, 3881, 3880},
  {3979, 3980, 3880},
  {3932, 3980, 3929},
  {3881, 3980, 3932},
  {4013, 3930, 3721},
  {3884, 3880, 3933},
  {4013, 3880, 3884},
  {3883, 4013, 3884},
  {4013, 3883, 3886},
  {3930, 4013, 3886},
  {3930, 3886, 3931},
  {3885, 3883, 3884},
  {3936, 3931, 3886},
  {3936, 3826, 3825},
  {3931, 3936, 3825},
  {3933, 3880, 3882},
  {4016, 3936, 3886},
  {3884, 3933, 3885},
  {4016, 3886, 3885},
  {4016, 3885, 3933},
  {3887, 3935, 3934},
  {3938, 3888, 3984},
  {3724, 4018, 4021},
  {3829, 3938, 3889},
  {3891, 3836, 4020},
  {4023, 3781, 3832},
  {4022, 3941, 3892},
  {3781, 4023, 3727},
  {4023, 3986, 3727},
  {3836, 3893, 3985},
  {3838, 3894, 3833},
  {3785, 3943, 3837},
  {3942, 3895, 3987},
  {3895, 3837, 3943},
  {6003, 3841, 4196},
  {4235, 3694, 4236},
  {3842, 3945, 3989},
  {4139, 3898, 3663},
  {3663, 3789, 4139},
  {3739, 3947, 3945},
  {3794, 3898, 3902},
  {3802, 3947, 3900},
  {3902, 3898, 3901},
  {3953, 3901, 3898},
  {3948, 3847, 3954},
  {3846, 3951, 3954},
  {3902, 3901, 3903},
  {3953, 3903, 3901},
  {3846, 3954, 3906},
  {3903, 3953, 3848},
  {3955, 3848, 3953},
  {4074, 3905, 3993},
  {3904, 3955, 3847},
  {6174, 6150, 3905},
  {3996, 3906, 3994},
  {3996, 3958, 3956},
  {3958, 3908, 3956},
  {3909, 3999, 3959},
  {3960, 3913, 3959},
  {3960, 3998, 4000},
  {3960, 4000, 3913},
  {3908, 3958, 3911},
  {6302, 3961, 4037},
  {3807, 3912, 3963},
  {3912, 3855, 3964},
  {3962, 3961, 3914},
  {3962, 3914, 4040},
  {3855, 4001, 3964},
  {3914, 3965, 4040},
  {4038, 3966, 3915},
  {4042, 3857, 3913},
  {3968, 4048, 3970},
  {3864, 3860, 3970},
  {3862, 3971, 3967},
  {3862, 3969, 3863},
  {3921, 3919, 3920},
  {4088, 3921, 3920},
  {4056, 3710, 4088},
  {4007, 3710, 4056},
  {3974, 3710, 4007},
  {3975, 4006, 6000},
  {3870, 3871, 4091},
  {3874, 4091, 3871},
  {3874, 3875, 4091},
  {3873, 3872, 4090},
  {3873, 4090, 6357},
  {6008, 3977, 3877},
  {3875, 4258, 4091},
  {3815, 3978, 3875},
  {3924, 3816, 4062},
  {3816, 6004, 4062},
  {3819, 4173, 4010},
  {6004, 3925, 4062},
  {3925, 3927, 4062},
  {3926, 4010, 4011},
  {3927, 3822, 4012},
  {4009, 3980, 3979},
  {3928, 4012, 3822},
  {3823, 4012, 3928},
  {3980, 3982, 3929},
  {3979, 3880, 4013},
  {3982, 3932, 3929},
  {3982, 4064, 3932},
  {6016, 6009, 6011},
  {3882, 4015, 3933},
  {3934, 3935, 4095},
  {3935, 3939, 4095},
  {3888, 3936, 3984},
  {3724, 3889, 4189},
  {3889, 3938, 3984},
  {4018, 4065, 4021},
  {3940, 4020, 3890},
  {3940, 3891, 4020},
  {3890, 4067, 3832},
  {4023, 3832, 4067},
  {3893, 3942, 4070},
  {3895, 3943, 4102},
  {3895, 4102, 3987},
  {3896, 4197, 3894},
  {3988, 6429, 3789},
  {6235, 3989, 3945},
  {6096, 6235, 3945},
  {3945, 3947, 3990},
  {3945, 3990, 4028},
  {3945, 4028, 3991},
  {3949, 3946, 3951},
  {3948, 3954, 3946},
  {3946, 3954, 3951},
  {3947, 3802, 4076},
  {3802, 4030, 4076},
  {3992, 3954, 3847},
  {3954, 3992, 3906},
  {3905, 6150, 3993},
  {3906, 4033, 3994},
  {3997, 3958, 3996},
  {4036, 3961, 3957},
  {3960, 3959, 4035},
  {3960, 4035, 3998},
  {3958, 3997, 3911},
  {3752, 4153, 3633},
  {3963, 3912, 4041},
  {4038, 3807, 4039},
  {3807, 3963, 4039},
  {3912, 3964, 4001},
  {3912, 4001, 4041},
  {3913, 4000, 4042},
  {3965, 3915, 4044},
  {4002, 4044, 3915},
  {3915, 3966, 4002},
  {3967, 4043, 4001},
  {3968, 3857, 4042},
  {3917, 4003, 3916},
  {3969, 4003, 4047},
  {3969, 4004, 3863},
  {4081, 4082, 3970},
  {4048, 4081, 3970},
  {3972, 3863, 4004},
  {3971, 3972, 4049},
  {4052, 4049, 3972},
  {3972, 4004, 4052},
  {6007, 3973, 4005},
  {4088, 3920, 6007},
  {6007, 4005, 4088},
  {4086, 3973, 3922},
  {3870, 4091, 3975},
  {6197, 4090, 3872},
  {6357, 4090, 6358},
  {4008, 3924, 4062},
  {4008, 4062, 4089},
  {4061, 3978, 6015},
  {3978, 4061, 3875},
  {3875, 4061, 4258},
  {3819, 3977, 4173},
  {4009, 3979, 6237},
  {4062, 3927, 4012},
  {3556, 4130, 3823},
  {3823, 4130, 4012},
  {4009, 3982, 3980},
  {3556, 4063, 4130},
  {3932, 4014, 3882},
  {3932, 4064, 4014},
  {4014, 4015, 3882},
  {3933, 4015, 4016},
  {3984, 3936, 4186},
  {4017, 3937, 4134},
  {4189, 4018, 3724},
  {3889, 3984, 4189},
  {3983, 3937, 4017},
  {3939, 4066, 4095},
  {3890, 4020, 4019},
  {4020, 4194, 4097},
  {4066, 3939, 3833},
  {4194, 4020, 3985},
  {3893, 4070, 3985},
  {3942, 3987, 4070},
  {3987, 4102, 4070},
  {3896, 3944, 4197},
  {4235, 3988, 3840},
  {4235, 4025, 3988},
  {3988, 4025, 6429},
  {4026, 3989, 6235},
  {3990, 3947, 4075},
  {3947, 4076, 4075},
  {4141, 4030, 3035},
  {4074, 4141, 3035},
  {3952, 4029, 4031},
  {3898, 4139, 3953},
  {3950, 3952, 4104},
  {3953, 4078, 3955},
  {3847, 4077, 3992},
  {3992, 4105, 4032},
  {4108, 3992, 4032},
  {4074, 3993, 4146},
  {4149, 4108, 3847},
  {3906, 3992, 4033},
  {4108, 4033, 3992},
  {3847, 4110, 4149},
  {6159, 4146, 3993},
  {4110, 3955, 4078},
  {3955, 4110, 3847},
  {3994, 4033, 3996},
  {3996, 4034, 3997},
  {3959, 3999, 4113},
  {3957, 3962, 4036},
  {4036, 3962, 6469},
  {4037, 3961, 4036},
  {4113, 3999, 4114},
  {3999, 3910, 4114},
  {3910, 3911, 4079},
  {3911, 3997, 4079},
  {3962, 4040, 6469},
  {4153, 3752, 6469},
  {3963, 4041, 4039},
  {4001, 4043, 4041},
  {3965, 4044, 4040},
  {4044, 4002, 4045},
  {4002, 3966, 4045},
  {4043, 3967, 4046},
  {3967, 4080, 4117},
  {3967, 4119, 4080},
  {3968, 4042, 4081},
  {3968, 4081, 4048},
  {3967, 3971, 4119},
  {4051, 4004, 3969},
  {3969, 4047, 4051},
  {4047, 4003, 6142},
  {3917, 6142, 4003},
  {6178, 4051, 4047},
  {4047, 6142, 6178},
  {4052, 4050, 4049},
  {4084, 4052, 4004},
  {4004, 4051, 4084},
  {4082, 6142, 3917},
  {4050, 4052, 4083},
  {4084, 4083, 4052},
  {3973, 4085, 4005},
  {3973, 4086, 4085},
  {4005, 4085, 4088},
  {4006, 3975, 4055},
  {4056, 4088, 4122},
  {6197, 4216, 4090},
  {4091, 4340, 3975},
  {6357, 6358, 3976},
  {4057, 4058, 4060},
  {4057, 4089, 4058},
  {4059, 6010, 4125},
  {4058, 4089, 4060},
  {4009, 6237, 4090},
  {4062, 4012, 4223},
  {4010, 4093, 4011},
  {4011, 4093, 3981},
  {4130, 4260, 4012},
  {4064, 3982, 4094},
  {4064, 4184, 4014},
  {4014, 4182, 4015},
  {4189, 3984, 4136},
  {4186, 4136, 3984},
  {4134, 4096, 4017},
  {4018, 4189, 4065},
  {4096, 3983, 4017},
  {3890, 4019, 4192},
  {4097, 4192, 4019},
  {4019, 4020, 4097},
  {4192, 4067, 3890},
  {4021, 4065, 4022},
  {4099, 4066, 3833},
  {4068, 4023, 4067},
  {4068, 3986, 4023},
  {3941, 4022, 4102},
  {3941, 4102, 3943},
  {4069, 4068, 4233},
  {4068, 4069, 3986},
  {3986, 4069, 5894},
  {3833, 3894, 4197},
  {4070, 4102, 4103},
  {3944, 3989, 4197},
  {4235, 4071, 4025},
  {4198, 4025, 4071},
  {4025, 4198, 6429},
  {3989, 4026, 4073},
  {4026, 3990, 4073},
  {4026, 4027, 6285},
  {4026, 6285, 3990},
  {4075, 4073, 3990},
  {6012, 6285, 4027},
  {4029, 4145, 4031},
  {3952, 4031, 4104},
  {4031, 4145, 4104},
  {4106, 4078, 3953},
  {3953, 4139, 4106},
  {3992, 4077, 4105},
  {3847, 4108, 4077},
  {4032, 4105, 4108},
  {4033, 4108, 4109},
  {4146, 6159, 4147},
  {4151, 4111, 3633},
  {4035, 3959, 4113},
  {4035, 4113, 3998},
  {4079, 3997, 4034},
  {4079, 4034, 4112},
  {4153, 6469, 4116},
  {4038, 4039, 4115},
  {4042, 4000, 4152},
  {6469, 4044, 4116},
  {3966, 4038, 4115},
  {4040, 4044, 6469},
  {4043, 4046, 4117},
  {4043, 4117, 4041},
  {4044, 4045, 4116},
  {4117, 4046, 3967},
  {4118, 4054, 4042},
  {4042, 4054, 4081},
  {4049, 4119, 3971},
  {6005, 6013, 6014},
  {4159, 6107, 3974},
  {6107, 4159, 4120},
  {3867, 4120, 4166},
  {4085, 4121, 4088},
  {6196, 6370, 4169},
  {4170, 3542, 4166},
  {4124, 3542, 4170},
  {6197, 6198, 4216},
  {4123, 4057, 4060},
  {6358, 4090, 6237},
  {4089, 4062, 4092},
  {4089, 4092, 4060},
  {4060, 4128, 4175},
  {4060, 4092, 4128},
  {4009, 4090, 4127},
  {4092, 4062, 4223},
  {6237, 3979, 6021},
  {6401, 4093, 4010},
  {3981, 4093, 4129},
  {3982, 4009, 4224},
  {4013, 3981, 4129},
  {4013, 4129, 3979},
  {4064, 4094, 4131},
  {4064, 4131, 4184},
  {4132, 4183, 4063},
  {4226, 6019, 3936},
  {3936, 6019, 4186},
  {4015, 4133, 4016},
  {4096, 4190, 3983},
  {4134, 4190, 4096},
  {4099, 4095, 4066},
  {4065, 4098, 4022},
  {4101, 4099, 3833},
  {3833, 4362, 4101},
  {4067, 4321, 4233},
  {4067, 4233, 4068},
  {4069, 4024, 5894},
  {3985, 4070, 4194},
  {6428, 6018, 4072},
  {3789, 6429, 4138},
  {3989, 4073, 4197},
  {4075, 4076, 4073},
  {3950, 4145, 4236},
  {3950, 4104, 4145},
  {4077, 4108, 4105},
  {4106, 4107, 4078},
  {4109, 4148, 4033},
  {4147, 6159, 4151},
  {6160, 4151, 6159},
  {3633, 4153, 4201},
  {3633, 4201, 4151},
  {3998, 4152, 4000},
  {4114, 3910, 4150},
  {3910, 4079, 4150},
  {4079, 4112, 4150},
  {4115, 4039, 4203},
  {4152, 4242, 4042},
  {4203, 4039, 4117},
  {4039, 4041, 4117},
  {4118, 4042, 4242},
  {4116, 4045, 4155},
  {4045, 3966, 4155},
  {4117, 4080, 4156},
  {4080, 4119, 4156},
  {4049, 4050, 4119},
  {4051, 4053, 4158},
  {4054, 6374, 4081},
  {4083, 4207, 4050},
  {4084, 4051, 4207},
  {4084, 4207, 4083},
  {4085, 4086, 6434},
  {4007, 4159, 3974},
  {4121, 4085, 4162},
  {4210, 4007, 4056},
  {6370, 4167, 4169},
  {4087, 4291, 4167},
  {4087, 4055, 4291},
  {4169, 4167, 4168},
  {4086, 4089, 4214},
  {4122, 4212, 4056},
  {4055, 3975, 4291},
  {4089, 4123, 4214},
  {4088, 4121, 4122},
  {4057, 4123, 4089},
  {4125, 3542, 4124},
  {4126, 6015, 4125},
  {6015, 4126, 4061},
  {4061, 4126, 4174},
  {4061, 4174, 4258},
  {4258, 4174, 4300},
  {4173, 4220, 4010},
  {4009, 4127, 4177},
  {4181, 4009, 4177},
  {6021, 3979, 4176},
  {4180, 4093, 4178},
  {4224, 4009, 4181},
  {3979, 4129, 4176},
  {4176, 4129, 4179},
  {4129, 4093, 4180},
  {3982, 4305, 4094},
  {4094, 4305, 4131},
  {4182, 4014, 4184},
  {3983, 4135, 4132},
  {4185, 4016, 4133},
  {3983, 4190, 4135},
  {6082, 4098, 4065},
  {4065, 4189, 6082},
  {4095, 4099, 4191},
  {4099, 4101, 4191},
  {4100, 4067, 4193},
  {4192, 4193, 4067},
  {4098, 6082, 4022},
  {4067, 4100, 4321},
  {4137, 4022, 4195},
  {4102, 4022, 4137},
  {4103, 4194, 4070},
  {4233, 4196, 4069},
  {4103, 4102, 4137},
  {4138, 6429, 4198},
  {4138, 4275, 3789},
  {4197, 4073, 4276},
  {6003, 4196, 4145},
  {4076, 4030, 4141},
  {4076, 4141, 4238},
  {6003, 4145, 4029},
  {4140, 4074, 4146},
  {4140, 4142, 4239},
  {4146, 4142, 4140},
  {4146, 4144, 4142},
  {4106, 4139, 4107},
  {4146, 4147, 4199},
  {4107, 4200, 4078},
  {4109, 4108, 4149},
  {4148, 4109, 4149},
  {4148, 4241, 4033},
  {3996, 4033, 4241},
  {4147, 4151, 4201},
  {4078, 4200, 4110},
  {4034, 3996, 4241},
  {4241, 4150, 4034},
  {4114, 4150, 4279},
  {4241, 4279, 4150},
  {4150, 4112, 4034},
  {4153, 4407, 4201},
  {4154, 4153, 4116},
  {4118, 4242, 4202},
  {4116, 4155, 4154},
  {4117, 4156, 4203},
  {4054, 4157, 4205},
  {4157, 4054, 4118},
  {4205, 4158, 4053},
  {4205, 4053, 4054},
  {4207, 4051, 4244},
  {4161, 4159, 4007},
  {4159, 4160, 4120},
  {6434, 4249, 6020},
  {4121, 4162, 4164},
  {4007, 4210, 4161},
  {4160, 4211, 4120},
  {4166, 4120, 4165},
  {6434, 4086, 4249},
  {4213, 4166, 4248},
  {4166, 4213, 4170},
  {4121, 4172, 4122},
  {4212, 4122, 4172},
  {3975, 4340, 4291},
  {4216, 6198, 4171},
  {4125, 4218, 4126},
  {4340, 4091, 4258},
  {4216, 4127, 4090},
  {4220, 6401, 4010},
  {4223, 6027, 4092},
  {4093, 6401, 4178},
  {4129, 4180, 4179},
  {6401, 4179, 4180},
  {4012, 4260, 4223},
  {4224, 4305, 3982},
  {4184, 4348, 4182},
  {4182, 4348, 4225},
  {4135, 4183, 4132},
  {4015, 4182, 4133},
  {4186, 6367, 4228},
  {4136, 4186, 4228},
  {4136, 4228, 4187},
  {4189, 4136, 4187},
  {4135, 4190, 4188},
  {4190, 4134, 4355},
  {4312, 6082, 4189},
  {4191, 4230, 4095},
  {4191, 4362, 4230},
  {4191, 4101, 4362},
  {4192, 4231, 4193},
  {4022, 6082, 4195},
  {4194, 4103, 4232},
  {4137, 4195, 4234},
  {4103, 4137, 4232},
  {3833, 4197, 4362},
  {4071, 4235, 4198},
  {4139, 3789, 4275},
  {4139, 4275, 4237},
  {4076, 4276, 4073},
  {4276, 4076, 4238},
  {4146, 4199, 4144},
  {4107, 4139, 4200},
  {4201, 4199, 4147},
  {4200, 4326, 4110},
  {4152, 3998, 4113},
  {4114, 4409, 4113},
  {4281, 4153, 4154},
  {4282, 4283, 4115},
  {4115, 4203, 4282},
  {3966, 4115, 4283},
  {4118, 4202, 4205},
  {4203, 4156, 4119},
  {4205, 4157, 4118},
  {4204, 4119, 4243},
  {4204, 4203, 4119},
  {4119, 4050, 4243},
  {4050, 4207, 4243},
  {4206, 4051, 4158},
  {4206, 4244, 4051},
  {4159, 4161, 4160},
  {4162, 4163, 4164},
  {6020, 4249, 4245},
  {4163, 6022, 4164},
  {4164, 6022, 4121},
  {4120, 4211, 4165},
  {4166, 4165, 4211},
  {4210, 4212, 4208},
  {4208, 4212, 4209},
  {4166, 4211, 4248},
  {4056, 4212, 4210},
  {4086, 4214, 4249},
  {4291, 4252, 4167},
  {4167, 4252, 4168},
  {4168, 4171, 4169},
  {4172, 4121, 4215},
  {4172, 4215, 4212},
  {4171, 4292, 4216},
  {4171, 4253, 4292},
  {4175, 4294, 4060},
  {4218, 4125, 4124},
  {4175, 4295, 4294},
  {4124, 4217, 4218},
  {4218, 4219, 4126},
  {4219, 4174, 4126},
  {4216, 4255, 4127},
  {4174, 4219, 4300},
  {4259, 4127, 4255},
  {4177, 4127, 4259},
  {6415, 4176, 4221},
  {4175, 4128, 6326},
  {4128, 4092, 6326},
  {4092, 6027, 6326},
  {4221, 4176, 4222},
  {4176, 4179, 4222},
  {6401, 4180, 4178},
  {6402, 4179, 6400},
  {4224, 4181, 4301},
  {4305, 4224, 4261},
  {4130, 4063, 4262},
  {4182, 4225, 4263},
  {4182, 4263, 4133},
  {4263, 4264, 4133},
  {6447, 3936, 4227},
  {4185, 4133, 4264},
  {3936, 4394, 4227},
  {4016, 4185, 4264},
  {4228, 6367, 4227},
  {4228, 4358, 4187},
  {4189, 4187, 4312},
  {4313, 4188, 4190},
  {4190, 4229, 4313},
  {4355, 4229, 4190},
  {4193, 4231, 4272},
  {4097, 4231, 4192},
  {4269, 4268, 4194},
  {4193, 4272, 4100},
  {4321, 4100, 4470},
  {4232, 4318, 4194},
  {4235, 4138, 4198},
  {4235, 4275, 4138},
  {4196, 4274, 4145},
  {4141, 4074, 4475},
  {4142, 4143, 4239},
  {4143, 4144, 4239},
  {4139, 4240, 4200},
  {4324, 4241, 4148},
  {4149, 4369, 4148},
  {4110, 4326, 4149},
  {4325, 4279, 4241},
  {4113, 4280, 4152},
  {4152, 4280, 4242},
  {4283, 4155, 3966},
  {4154, 4155, 4283},
  {4205, 4331, 4158},
  {4158, 4286, 4206},
  {4286, 4158, 4331},
  {4161, 4288, 4160},
  {6087, 4246, 6086},
  {4247, 4210, 4208},
  {4210, 4247, 4161},
  {4211, 4160, 4288},
  {4245, 4249, 4287},
  {4334, 4121, 6022},
  {4423, 4121, 4334},
  {4209, 4212, 4250},
  {4209, 4250, 4289},
  {4211, 4290, 4248},
  {4290, 4251, 4248},
  {4212, 4215, 4250},
  {4251, 4170, 4248},
  {4248, 4170, 4213},
  {4168, 4252, 4171},
  {4253, 4171, 4252},
  {4121, 4379, 4215},
  {4251, 4381, 4170},
  {4381, 4124, 4170},
  {4381, 4254, 4124},
  {4292, 4293, 4216},
  {4123, 4060, 4294},
  {4216, 4293, 4296},
  {4254, 4217, 4124},
  {4256, 4217, 4254},
  {4217, 4256, 4218},
  {4299, 4295, 4175},
  {4295, 4299, 6024},
  {4219, 4218, 4256},
  {4219, 4256, 4257},
  {4219, 4257, 4300},
  {4181, 4177, 4388},
  {4130, 4262, 4260},
  {4261, 4303, 4305},
  {4225, 4306, 4263},
  {4184, 4131, 4307},
  {4184, 4307, 4348},
  {4344, 4345, 4016},
  {3936, 4016, 4345},
  {4345, 4394, 3936},
  {4264, 4344, 4016},
  {4227, 4309, 4228},
  {4309, 4354, 4228},
  {4228, 4354, 4358},
  {4312, 4187, 4358},
  {4313, 4229, 4314},
  {4229, 4355, 4314},
  {4095, 4230, 4267},
  {6025, 6083, 4315},
  {4267, 4230, 4362},
  {4231, 4097, 4319},
  {4097, 4194, 4268},
  {4272, 4231, 4271},
  {4231, 4319, 4271},
  {4269, 4194, 4318},
  {4470, 4100, 4272},
  {6082, 4273, 4195},
  {4273, 4234, 4195},
  {4196, 4233, 4321},
  {4232, 4137, 4322},
  {4137, 4361, 4322},
  {4137, 4234, 4361},
  {4362, 4197, 4276},
  {4196, 4472, 4274},
  {4275, 4235, 4236},
  {4237, 4275, 4366},
  {4237, 4366, 4139},
  {4323, 4236, 4145},
  {4145, 4274, 4367},
  {4140, 4475, 4074},
  {4144, 4367, 4239},
  {4240, 4139, 4277},
  {4241, 4324, 4325},
  {4326, 4240, 4277},
  {4278, 4148, 4369},
  {4148, 4278, 4324},
  {4407, 4199, 4201},
  {4240, 4326, 4200},
  {4114, 4279, 4373},
  {4281, 4408, 4153},
  {4154, 4328, 4281},
  {4154, 4283, 4328},
  {4412, 4202, 4242},
  {4203, 4377, 4282},
  {4330, 4202, 4413},
  {4202, 4330, 4205},
  {4203, 4204, 4377},
  {4377, 4204, 4284},
  {4204, 4243, 4284},
  {4244, 4284, 4243},
  {4206, 4284, 4244},
  {4285, 4284, 4206},
  {4243, 4207, 4244},
  {4286, 4285, 4206},
  {4333, 4286, 4331},
  {6023, 4334, 6022},
  {4208, 4209, 4247},
  {4288, 4161, 4247},
  {4288, 4290, 4211},
  {4334, 5867, 4423},
  {4209, 4421, 4247},
  {4247, 4421, 4288},
  {4288, 4421, 4335},
  {4288, 4335, 4290},
  {4424, 4287, 4249},
  {4422, 4289, 4250},
  {4290, 4335, 4251},
  {4250, 4215, 4422},
  {4379, 4422, 4215},
  {4291, 4336, 4252},
  {4252, 4336, 4253},
  {4424, 4249, 4214},
  {4214, 4123, 4424},
  {4121, 4423, 4379},
  {4253, 4380, 4292},
  {4254, 4381, 4339},
  {4294, 4424, 4123},
  {4254, 4339, 4383},
  {4254, 4383, 4298},
  {4296, 4387, 4216},
  {4258, 4341, 4340},
  {4216, 4387, 4255},
  {4254, 4385, 4256},
  {4255, 4388, 4259},
  {4175, 4342, 4299},
  {4259, 4388, 4177},
  {4224, 4301, 4390},
  {4261, 4224, 4303},
  {4303, 4304, 4305},
  {4063, 4597, 4262},
  {4306, 4343, 4264},
  {4306, 4264, 4263},
  {4305, 4393, 4131},
  {4306, 4225, 4346},
  {4348, 4347, 4225},
  {4183, 4135, 4557},
  {4227, 4351, 4309},
  {4308, 4311, 4350},
  {4135, 4188, 4557},
  {4134, 3934, 4558},
  {4265, 4311, 4436},
  {4311, 4265, 4350},
  {4312, 4350, 4265},
  {4436, 4266, 4265},
  {4265, 4316, 4312},
  {4266, 4316, 4265},
  {4266, 4438, 4316},
  {6082, 4316, 4273},
  {4319, 4097, 4320},
  {4097, 4268, 4320},
  {4496, 4272, 4271},
  {4271, 4319, 4496},
  {4318, 4232, 4322},
  {4273, 4363, 4234},
  {4322, 4361, 4363},
  {4236, 4405, 4275},
  {4236, 4323, 4405},
  {4366, 4275, 4444},
  {4238, 4365, 4276},
  {4140, 4239, 4367},
  {4368, 4503, 4145},
  {4370, 4324, 4278},
  {4370, 4278, 4369},
  {4279, 4325, 4370},
  {4326, 4277, 4327},
  {4326, 4327, 4149},
  {4373, 4279, 4370},
  {4408, 4281, 4328},
  {4242, 4280, 4375},
  {4113, 4375, 4280},
  {4242, 4375, 4412},
  {4328, 4283, 4374},
  {4283, 4282, 4376},
  {4377, 4329, 4282},
  {4202, 4412, 4413},
  {4330, 4331, 4205},
  {4377, 4284, 4416},
  {4284, 4333, 4416},
  {4284, 4285, 4333},
  {4285, 4286, 4333},
  {4331, 4378, 4333},
  {4246, 6087, 6086},
  {4209, 4289, 4421},
  {4592, 4423, 5867},
  {4289, 4422, 4512},
  {4336, 4291, 4337},
  {4336, 4380, 4253},
  {4291, 4340, 4337},
  {4380, 4338, 4292},
  {4292, 4338, 4293},
  {4425, 4293, 4338},
  {4294, 4295, 4382},
  {4337, 4340, 4300},
  {4296, 4293, 4455},
  {4295, 4297, 4382},
  {4385, 4298, 4383},
  {4387, 4296, 4455},
  {4298, 4385, 4254},
  {4385, 4386, 4256},
  {4299, 4595, 4297},
  {4384, 4256, 4386},
  {4256, 4384, 4257},
  {4300, 4257, 4384},
  {4341, 4258, 4300},
  {4299, 4342, 4595},
  {4388, 4301, 4181},
  {4459, 4223, 4391},
  {4391, 4223, 4260},
  {4303, 4224, 4390},
  {4303, 4390, 4431},
  {4260, 4262, 4391},
  {4304, 4303, 4431},
  {4304, 4431, 4305},
  {4305, 4431, 4393},
  {4225, 4347, 4346},
  {4344, 4264, 6413},
  {4310, 4306, 4349},
  {4345, 4434, 4350},
  {4350, 4394, 4345},
  {4310, 4349, 4352},
  {4358, 4394, 4350},
  {4183, 4557, 4063},
  {4063, 4557, 4599},
  {4396, 4352, 4348},
  {4347, 4348, 4352},
  {4352, 4356, 4310},
  {4227, 4394, 4351},
  {4351, 4354, 4309},
  {4353, 4306, 4310},
  {4308, 4436, 4311},
  {4352, 4464, 4356},
  {4310, 4356, 4357},
  {4310, 4357, 4353},
  {4350, 4312, 4358},
  {4558, 3934, 4521},
  {3934, 4095, 4521},
  {4356, 4397, 4357},
  {4188, 4313, 4360},
  {4267, 4362, 4359},
  {4267, 4359, 4095},
  {4316, 6082, 4312},
  {4313, 4314, 4360},
  {4362, 4400, 4359},
  {6081, 4270, 4317},
  {4269, 4401, 4268},
  {4269, 4318, 4401},
  {4268, 4401, 4320},
  {4321, 4441, 4196},
  {4363, 4361, 4234},
  {4472, 4196, 4441},
  {4364, 4276, 4365},
  {4366, 4446, 4139},
  {4140, 4367, 4475},
  {4475, 4448, 4141},
  {4501, 4238, 4141},
  {4141, 4448, 4501},
  {4323, 4145, 5872},
  {4145, 4503, 5872},
  {4144, 4406, 4368},
  {4324, 4370, 4325},
  {4277, 4371, 4327},
  {4327, 4371, 4149},
  {4372, 4153, 4408},
  {4372, 4407, 4153},
  {4506, 4149, 4371},
  {4409, 4114, 4373},
  {4374, 4408, 4328},
  {4282, 4411, 4376},
  {4374, 4283, 4410},
  {4282, 4329, 4411},
  {4329, 4377, 4411},
  {4331, 4330, 4332},
  {4330, 4413, 4332},
  {4414, 4332, 4413},
  {4332, 4414, 4331},
  {4287, 5867, 4334},
  {4335, 4421, 4251},
  {4251, 4421, 4381},
  {4380, 4336, 4337},
  {4293, 4425, 4455},
  {4300, 4340, 4341},
  {4595, 4382, 4297},
  {4384, 4426, 4300},
  {4388, 4255, 4387},
  {4175, 4457, 4342},
  {4388, 4302, 4301},
  {4388, 4430, 4302},
  {4302, 4430, 4514},
  {4389, 4302, 4514},
  {4389, 6182, 4302},
  {4302, 4492, 4301},
  {4343, 6028, 4264},
  {6028, 6412, 4264},
  {4264, 6412, 6413},
  {4347, 4352, 4346},
  {4346, 4352, 4349},
  {4346, 4349, 4306},
  {4392, 4434, 4344},
  {4344, 4434, 4345},
  {4597, 4063, 4599},
  {4393, 4395, 4131},
  {4131, 4464, 4307},
  {4350, 4434, 4435},
  {4464, 4131, 4395},
  {4307, 4464, 4396},
  {4307, 4396, 4348},
  {4350, 4435, 4308},
  {4354, 4394, 4358},
  {4394, 4354, 4351},
  {4306, 4353, 4435},
  {4308, 4435, 4436},
  {4134, 4558, 4355},
  {4353, 4398, 4435},
  {4436, 4435, 4398},
  {4396, 4464, 4352},
  {4436, 4438, 4266},
  {4357, 4397, 4353},
  {4398, 4353, 4397},
  {4558, 4360, 4355},
  {4188, 4360, 4399},
  {4314, 4355, 4360},
  {4095, 4359, 4521},
  {4400, 4521, 4359},
  {4439, 4399, 4360},
  {4438, 4467, 4316},
  {4319, 4320, 4496},
  {4321, 4470, 4441},
  {4273, 4442, 4402},
  {4273, 4402, 4363},
  {4322, 4363, 4402},
  {4362, 4404, 4403},
  {4276, 4404, 4362},
  {4276, 4364, 4404},
  {4323, 4445, 4405},
  {4446, 4366, 4444},
  {4365, 4238, 4474},
  {4277, 4139, 4449},
  {4503, 4368, 4406},
  {4277, 4449, 4371},
  {4373, 4369, 4149},
  {4369, 4373, 4370},
  {4149, 4506, 4373},
  {4373, 4506, 4409},
  {4375, 4507, 4412},
  {4113, 4409, 4478},
  {4376, 4410, 4283},
  {4477, 4374, 4410},
  {4539, 4477, 4410},
  {4411, 4377, 4450},
  {4413, 4412, 4508},
  {4413, 4482, 4414},
  {4331, 4414, 4417},
  {4414, 4415, 4417},
  {4331, 4417, 4378},
  {4415, 4451, 4417},
  {4333, 4378, 4416},
  {4378, 4417, 4418},
  {4417, 4419, 4418},
  {4287, 4424, 4420},
  {4379, 4592, 4422},
  {4337, 4546, 4380},
  {4380, 4425, 4338},
  {4294, 4382, 4424},
  {4382, 4595, 4424},
  {4456, 4300, 4426},
  {4455, 4514, 4387},
  {4383, 4427, 4385},
  {4385, 4428, 4386},
  {4386, 4518, 4384},
  {4386, 4428, 4518},
  {4427, 4428, 4385},
  {4387, 4514, 4388},
  {4342, 4429, 4595},
  {4458, 4429, 4342},
  {4458, 4342, 4457},
  {4301, 4492, 4390},
  {4262, 4460, 4391},
  {4343, 4432, 6028},
  {4435, 4432, 4343},
  {4343, 4306, 4435},
  {4393, 4431, 4395},
  {4464, 4437, 4356},
  {4188, 4399, 4557},
  {4521, 4400, 4468},
  {4399, 4439, 4557},
  {4360, 4522, 4439},
  {4470, 4272, 4440},
  {4322, 4402, 4442},
  {5869, 4472, 4441},
  {4405, 4443, 4275},
  {4275, 4443, 4444},
  {4443, 4405, 4445},
  {4274, 4472, 4367},
  {4446, 4447, 4139},
  {4499, 4139, 4447},
  {4474, 4238, 4500},
  {4475, 4367, 4531},
  {4501, 4500, 4238},
  {4503, 4406, 4199},
  {4407, 4476, 4199},
  {4371, 4449, 4505},
  {4372, 4408, 4621},
  {4372, 4621, 4407},
  {4371, 4505, 4506},
  {4375, 4535, 4507},
  {4375, 4113, 4535},
  {4113, 4478, 4535},
  {4410, 4376, 4539},
  {4411, 4450, 4376},
  {4481, 4377, 4416},
  {4508, 4482, 4413},
  {4481, 4416, 4486},
  {4452, 4415, 4414},
  {4416, 4378, 4418},
  {4416, 4418, 4485},
  {4416, 4485, 4486},
  {4451, 4453, 4417},
  {4419, 4417, 4453},
  {4511, 4289, 4512},
  {4420, 4424, 5868},
  {4512, 4422, 4592},
  {4592, 4379, 4423},
  {4549, 4380, 4546},
  {4380, 4549, 4425},
  {4337, 4300, 4487},
  {4456, 4547, 4300},
  {4549, 4455, 4425},
  {4339, 4381, 4383},
  {4427, 4383, 4381},
  {4595, 4429, 4458},
  {4428, 4491, 4518},
  {4388, 4514, 4430},
  {4302, 6182, 4714},
  {4459, 4391, 4460},
  {4431, 4390, 4461},
  {4432, 4463, 6028},
  {4432, 4435, 4434},
  {4432, 4434, 4463},
  {4433, 4462, 4463},
  {4433, 4463, 4392},
  {4434, 4392, 4463},
  {4395, 4431, 4520},
  {4395, 4520, 4464},
  {4438, 4436, 4467},
  {4436, 4398, 4467},
  {4467, 4465, 4466},
  {4360, 4558, 4522},
  {4398, 4397, 4471},
  {4398, 4471, 4467},
  {4397, 4494, 4471},
  {4494, 4525, 4471},
  {4467, 4469, 4316},
  {4400, 4362, 4468},
  {4526, 4316, 4469},
  {4316, 4526, 4273},
  {4497, 4273, 4526},
  {4318, 4322, 4498},
  {4273, 4497, 4442},
  {4318, 4498, 4401},
  {4442, 4527, 4322},
  {4772, 4362, 4403},
  {4445, 4473, 4528},
  {4443, 4447, 4444},
  {4446, 4444, 4447},
  {4443, 4445, 4447},
  {4323, 4473, 4445},
  {4473, 4323, 4529},
  {4499, 4530, 4139},
  {4472, 4531, 4367},
  {4529, 4323, 5872},
  {4499, 4529, 4530},
  {4475, 4502, 4448},
  {4501, 4448, 4502},
  {4199, 4476, 4503},
  {4449, 4504, 4505},
  {4407, 4780, 4476},
  {4408, 4374, 4621},
  {4508, 4412, 4507},
  {4376, 4450, 4479},
  {4479, 4450, 4377},
  {4479, 4377, 4481},
  {4481, 4486, 4483},
  {4414, 4484, 4452},
  {4485, 4418, 4484},
  {4452, 4484, 4419},
  {4484, 4418, 4419},
  {6026, 4452, 4419},
  {4591, 4289, 4511},
  {4289, 4591, 4421},
  {5868, 4424, 4702},
  {4454, 4421, 4591},
  {4381, 4421, 4454},
  {4547, 4337, 4487},
  {4547, 4487, 4300},
  {4595, 4488, 4424},
  {4549, 4489, 4455},
  {4749, 4547, 4456},
  {4456, 4426, 4749},
  {4516, 4426, 4384},
  {4426, 4516, 4749},
  {4384, 4518, 4516},
  {6182, 4514, 6244},
  {4514, 6182, 4389},
  {4518, 4491, 4517},
  {4457, 4551, 4458},
  {4552, 6465, 4459},
  {4492, 4302, 4555},
  {4302, 4714, 4555},
  {4262, 4632, 4460},
  {4390, 4519, 4461},
  {4431, 4461, 4519},
  {4520, 4431, 4519},
  {4437, 4493, 4356},
  {4494, 4356, 4493},
  {4356, 4494, 4397},
  {4465, 4467, 4466},
  {4471, 4469, 4467},
  {4439, 4522, 4562},
  {4494, 4603, 4525},
  {4471, 4525, 4469},
  {4468, 4362, 4495},
  {4441, 4470, 4561},
  {4524, 4441, 4561},
  {4440, 4272, 4602},
  {4320, 4401, 4607},
  {4565, 4442, 4497},
  {4527, 4498, 4322},
  {4473, 4529, 4528},
  {4445, 4528, 4447},
  {4499, 4447, 4528},
  {4478, 4579, 4535},
  {4506, 6031, 4409},
  {4579, 4478, 6375},
  {6031, 4478, 4409},
  {4480, 4477, 4539},
  {4539, 4376, 4479},
  {4478, 6031, 6032},
  {4582, 4477, 4480},
  {4542, 4582, 4480},
  {4509, 4485, 4508},
  {4482, 4508, 4485},
  {6036, 4481, 4510},
  {4484, 4482, 4485},
  {4482, 4484, 4414},
  {4481, 4483, 4510},
  {4483, 4486, 4510},
  {4543, 4510, 4486},
  {4591, 4511, 4544},
  {4591, 4545, 4454},
  {4424, 4548, 4702},
  {4513, 4546, 4337},
  {4488, 4548, 4424},
  {4631, 4548, 4488},
  {4595, 4631, 4488},
  {4455, 4489, 4550},
  {4455, 4550, 4514},
  {4514, 6029, 6244},
  {4427, 4515, 4428},
  {4428, 4515, 4491},
  {4517, 4554, 4518},
  {4437, 4464, 4601},
  {4601, 4493, 4437},
  {4468, 4495, 4521},
  {4523, 4521, 4495},
  {4560, 4561, 4470},
  {4470, 4440, 4560},
  {4602, 4560, 4440},
  {4495, 4362, 4523},
  {4563, 4523, 4362},
  {4272, 4496, 4602},
  {4525, 4564, 4469},
  {4564, 4526, 4469},
  {4497, 6157, 4565},
  {4772, 4840, 4362},
  {4527, 4442, 4566},
  {4565, 4566, 4442},
  {4403, 4404, 4772},
  {5869, 4614, 4472},
  {4531, 4472, 4571},
  {4529, 5872, 4575},
  {4500, 4572, 4474},
  {4502, 4475, 4531},
  {4502, 4531, 4689},
  {4500, 4533, 4532},
  {4500, 4532, 4576},
  {4533, 4500, 4501},
  {4139, 4530, 4575},
  {4501, 4502, 4533},
  {4532, 6172, 4534},
  {4533, 4689, 4532},
  {4449, 4139, 4577},
  {4503, 4476, 4780},
  {4781, 4504, 4449},
  {4504, 4781, 4505},
  {4407, 4621, 4780},
  {4505, 4579, 4506},
  {4581, 4506, 4579},
  {5870, 4621, 4374},
  {4506, 4581, 6031},
  {6032, 6375, 4478},
  {4582, 4374, 4477},
  {4537, 4508, 4507},
  {6033, 4536, 4538},
  {4539, 4479, 4481},
  {4583, 4540, 4509},
  {4509, 4508, 4583},
  {4480, 4539, 4542},
  {4540, 4541, 4509},
  {4537, 4654, 4508},
  {4541, 4588, 4509},
  {4543, 4509, 4588},
  {6036, 4510, 4587},
  {4509, 4543, 4485},
  {4486, 4485, 4543},
  {4511, 6361, 4544},
  {5868, 4702, 4590},
  {4592, 4511, 4512},
  {4545, 4629, 4454},
  {4454, 4629, 4381},
  {4337, 4547, 4513},
  {4513, 4547, 4593},
  {4546, 4663, 4549},
  {4489, 4549, 4664},
  {4489, 4664, 4550},
  {4515, 4427, 4706},
  {4550, 4594, 4490},
  {4550, 4490, 4514},
  {4514, 4490, 6030},
  {4515, 4706, 4491},
  {4490, 4594, 6182},
  {4594, 4714, 6182},
  {4554, 4517, 4491},
  {4552, 4459, 4553},
  {4755, 4458, 4551},
  {4518, 4554, 4516},
  {4492, 4555, 4633},
  {4390, 4492, 4556},
  {4262, 4597, 4632},
  {4598, 4520, 4519},
  {4520, 4598, 4464},
  {4601, 4464, 4598},
  {4559, 4558, 4521},
  {4723, 4522, 4558},
  {4603, 4494, 4634},
  {4563, 4559, 4521},
  {4521, 4523, 4563},
  {4562, 4557, 4439},
  {4564, 4525, 4603},
  {4602, 4496, 4604},
  {4607, 4496, 4320},
  {4564, 4605, 4606},
  {4564, 4606, 4526},
  {4362, 4840, 4563},
  {6157, 4497, 4526},
  {4524, 4770, 4441},
  {4498, 4527, 4611},
  {4527, 4567, 4611},
  {4527, 4566, 4567},
  {4441, 4613, 4640},
  {4404, 4474, 4813},
  {4529, 4499, 4528},
  {4615, 4570, 4574},
  {4615, 4616, 4570},
  {4572, 4573, 4474},
  {4529, 4575, 4530},
  {4572, 4500, 4576},
  {4502, 4689, 4533},
  {4575, 4618, 4139},
  {4532, 4689, 4576},
  {4577, 4139, 4618},
  {4532, 4534, 6172},
  {5872, 4503, 4619},
  {4578, 4535, 4620},
  {4781, 4579, 4505},
  {4507, 4535, 4578},
  {4581, 6072, 6031},
  {4625, 4507, 4578},
  {4582, 4580, 4374},
  {6033, 4538, 4536},
  {6035, 4538, 4584},
  {4541, 4540, 4623},
  {4540, 4583, 4623},
  {4507, 4625, 4585},
  {4507, 4585, 4537},
  {6073, 4538, 6034},
  {4508, 4654, 4583},
  {4582, 4542, 5870},
  {4586, 5870, 4542},
  {4481, 4626, 4539},
  {4625, 4654, 4537},
  {4585, 4625, 4537},
  {4626, 4542, 4539},
  {4626, 4586, 4542},
  {4541, 4626, 4587},
  {4588, 4541, 4587},
  {4510, 4543, 4587},
  {4588, 4587, 4543},
  {6360, 6468, 4544},
  {4544, 4589, 4591},
  {4592, 4628, 6361},
  {4592, 6361, 4511},
  {4545, 4591, 4629},
  {4381, 4629, 4662},
  {4513, 4593, 4546},
  {4593, 4547, 4663},
  {4593, 4663, 4546},
  {4547, 4749, 4663},
  {4381, 4662, 4427},
  {4706, 4427, 4662},
  {4594, 4550, 4664},
  {4711, 4491, 4706},
  {4552, 4553, 4551},
  {4595, 4458, 4755},
  {4491, 4711, 4554},
  {4551, 4667, 4755},
  {4554, 4668, 4516},
  {4553, 4459, 4596},
  {4459, 4460, 4632},
  {4459, 4632, 4596},
  {4633, 4555, 4714},
  {4390, 4556, 4718},
  {4556, 4492, 4716},
  {4632, 4597, 4672},
  {4718, 4673, 4519},
  {4519, 4390, 4718},
  {4598, 4519, 4673},
  {4675, 4601, 4598},
  {4600, 4599, 4557},
  {4601, 4634, 4493},
  {4493, 4634, 4494},
  {4604, 4496, 4607},
  {4564, 4635, 4605},
  {4526, 4637, 4608},
  {4526, 4608, 6157},
  {4526, 4638, 4637},
  {4636, 4609, 4639},
  {4441, 4610, 4612},
  {4441, 4612, 4613},
  {4608, 4567, 4566},
  {4566, 4565, 4608},
  {4569, 4609, 4880},
  {4569, 4880, 4568},
  {4568, 4641, 4569},
  {4568, 4880, 4641},
  {4615, 4574, 4730},
  {4730, 4574, 4617},
  {4570, 4616, 4574},
  {4616, 4474, 4573},
  {4574, 4645, 4617},
  {4572, 4576, 4689},
  {4575, 5872, 4618},
  {4618, 5871, 4577},
  {4577, 4646, 4449},
  {4620, 4535, 4650},
  {4535, 4579, 4652},
  {4621, 4541, 4623},
  {4541, 4621, 4622},
  {4624, 4622, 5870},
  {4622, 4624, 4541},
  {4653, 4623, 4583},
  {4654, 4653, 4583},
  {5870, 4586, 4624},
  {4624, 4626, 4541},
  {4586, 4626, 4624},
  {4628, 4591, 4627},
  {4627, 4591, 4589},
  {4590, 4592, 5868},
  {4590, 4655, 4592},
  {4592, 4655, 4656},
  {4592, 4656, 4628},
  {4630, 4659, 4591},
  {4663, 4748, 4549},
  {4748, 4707, 4549},
  {4549, 4707, 4664},
  {4631, 4595, 4665},
  {4551, 4553, 4667},
  {4711, 4712, 4554},
  {4669, 4554, 4712},
  {4758, 4667, 4553},
  {4553, 4596, 4758},
  {4718, 4556, 4670},
  {4556, 4716, 4670},
  {4633, 4716, 4492},
  {4797, 4597, 4599},
  {4634, 4601, 4676},
  {4679, 4723, 4558},
  {4558, 4559, 4679},
  {4559, 4563, 4679},
  {4560, 4602, 4680},
  {4634, 4635, 4603},
  {4563, 4840, 4679},
  {4602, 4604, 4680},
  {4603, 4635, 4564},
  {4562, 4681, 4557},
  {4605, 4635, 6041},
  {4605, 6041, 4606},
  {4607, 4401, 4684},
  {4606, 6041, 4638},
  {4606, 4638, 4526},
  {4441, 4770, 4610},
  {4498, 4611, 4637},
  {4498, 4637, 4638},
  {4637, 4611, 4567},
  {4637, 4567, 4608},
  {4608, 4565, 6157},
  {4610, 4685, 4612},
  {4609, 4569, 4639},
  {4612, 4685, 4613},
  {4640, 4613, 4685},
  {4569, 4641, 4729},
  {4569, 4729, 4639},
  {4404, 4813, 4772},
  {4813, 4474, 4616},
  {4643, 4730, 4617},
  {4645, 4574, 4616},
  {4616, 4573, 4731},
  {4572, 4731, 4573},
  {4731, 4572, 4773},
  {4689, 4773, 4572},
  {4618, 5872, 5871},
  {4689, 4531, 4644},
  {4645, 4643, 4617},
  {4690, 4643, 4645},
  {6120, 4644, 4531},
  {4646, 4577, 4692},
  {4646, 4692, 4647},
  {5874, 4619, 4503},
  {4647, 4738, 4646},
  {4449, 4646, 6038},
  {4449, 6038, 4781},
  {4649, 4647, 4648},
  {4503, 4780, 4695},
  {4649, 4648, 4698},
  {4578, 4620, 4651},
  {4535, 4652, 4650},
  {4579, 4781, 4782},
  {4578, 4651, 4743},
  {4579, 4782, 4652},
  {4625, 4578, 4654},
  {4623, 4653, 4701},
  {4654, 4743, 4653},
  {4656, 4657, 4628},
  {4658, 4628, 4657},
  {4590, 4702, 4744},
  {4628, 4658, 4591},
  {4703, 4704, 4591},
  {4591, 4661, 4629},
  {4591, 4704, 4630},
  {4662, 4629, 4661},
  {4704, 4659, 4630},
  {4659, 4704, 4784},
  {4659, 4660, 4591},
  {4591, 4660, 4661},
  {4664, 4710, 4594},
  {4709, 4665, 4595},
  {4711, 4706, 4754},
  {4595, 4755, 4709},
  {4594, 4666, 4714},
  {4554, 4713, 4668},
  {4554, 4669, 4713},
  {4596, 4632, 4758},
  {4672, 4758, 4632},
  {4718, 4670, 4762},
  {4718, 4719, 4673},
  {4597, 4797, 4672},
  {4673, 4674, 4598},
  {4598, 4674, 4675},
  {4676, 4721, 4677},
  {4676, 4677, 4634},
  {4677, 4721, 4678},
  {4634, 4677, 4678},
  {4634, 4678, 4722},
  {4679, 4724, 4723},
  {4522, 4723, 5071},
  {4680, 4727, 4560},
  {4561, 4560, 4727},
  {4561, 4727, 4524},
  {4766, 4524, 4727},
  {4681, 4562, 5071},
  {4524, 4766, 4770},
  {4607, 4809, 4604},
  {4607, 4684, 4809},
  {4683, 4636, 4682},
  {4684, 4401, 4728},
  {4401, 4498, 4728},
  {4498, 4638, 4728},
  {4685, 4610, 4770},
  {4609, 4636, 4880},
  {4640, 4685, 4686},
  {4641, 4880, 4642},
  {4685, 4614, 4686},
  {4641, 4642, 4729},
  {4687, 4642, 4880},
  {4688, 4729, 4687},
  {4687, 4880, 4688},
  {4615, 4813, 4616},
  {4615, 4880, 4813},
  {4616, 4731, 4645},
  {4531, 4571, 6042},
  {4531, 6042, 4691},
  {4690, 4730, 4643},
  {4645, 4731, 6351},
  {4691, 4689, 4644},
  {4531, 4691, 6120},
  {4644, 6120, 4691},
  {4694, 6121, 4693},
  {4693, 6121, 4694},
  {6200, 4734, 6201},
  {4735, 5874, 4503},
  {4647, 4649, 4738},
  {4647, 4853, 4648},
  {4695, 4820, 4503},
  {4648, 4853, 4696},
  {4648, 4696, 4697},
  {4781, 6038, 6115},
  {4648, 4697, 4698},
  {4696, 4740, 4697},
  {4651, 4620, 4699},
  {4620, 4700, 4699},
  {4620, 4650, 4700},
  {4650, 4652, 4700},
  {4621, 4623, 4825},
  {4651, 4741, 4743},
  {6260, 6261, 4742},
  {4654, 4578, 4743},
  {4701, 4653, 4743},
  {4590, 4744, 4655},
  {4656, 4658, 4657},
  {4658, 4656, 4703},
  {4658, 4703, 4591},
  {4662, 4661, 4705},
  {4746, 4662, 4705},
  {4704, 4783, 4784},
  {4660, 4659, 4784},
  {4663, 4747, 4748},
  {4785, 4548, 4631},
  {4663, 4749, 4747},
  {4831, 4785, 4631},
  {4708, 4831, 4631},
  {4749, 4516, 4753},
  {4749, 4710, 4707},
  {4631, 4665, 4708},
  {4707, 4710, 4664},
  {4594, 4710, 4666},
  {4665, 4709, 4708},
  {4711, 4754, 4790},
  {4711, 4790, 4712},
  {4713, 4791, 4668},
  {4669, 4712, 4713},
  {4758, 4672, 4759},
  {4672, 4715, 4759},
  {4671, 4633, 4717},
  {4717, 4633, 4757},
  {4633, 4671, 4763},
  {4671, 4717, 4763},
  {4674, 4673, 4719},
  {4599, 4600, 4797},
  {4720, 4676, 4799},
  {4720, 4721, 4676},
  {4675, 4802, 4601},
  {6247, 4676, 4601},
  {4601, 4802, 4804},
  {4722, 4725, 4634},
  {4680, 4726, 4727},
  {4634, 4725, 4765},
  {4562, 4522, 5071},
  {4634, 4765, 4635},
  {4683, 4682, 4681},
  {4681, 4682, 4767},
  {4636, 4767, 4682},
  {6041, 4769, 4638},
  {4768, 4728, 4638},
  {4638, 4769, 4768},
  {4636, 4639, 4729},
  {4880, 4636, 4995},
  {4685, 4771, 4614},
  {4642, 4687, 4729},
  {4688, 4880, 4730},
  {4730, 4880, 4615},
  {6042, 4571, 4844},
  {4571, 4472, 4844},
  {4730, 6189, 4999},
  {4730, 4690, 4732},
  {4730, 4732, 6189},
  {4689, 4691, 4733},
  {4736, 4735, 4503},
  {4503, 4737, 4736},
  {4737, 4503, 4777},
  {4820, 4778, 4503},
  {4649, 4779, 4738},
  {4649, 4698, 4779},
  {6038, 6350, 6115},
  {4696, 4739, 4740},
  {4779, 4698, 4697},
  {4741, 4651, 4699},
  {4741, 6043, 4743},
  {6039, 4826, 4652},
  {4701, 4743, 6043},
  {4744, 4702, 4745},
  {4703, 4655, 4744},
  {4655, 4703, 4656},
  {4744, 4745, 4703},
  {4703, 4783, 4704},
  {4705, 4661, 4746},
  {4548, 4785, 4830},
  {4749, 4707, 4748},
  {4750, 6040, 4751},
  {4752, 4786, 4706},
  {4786, 4754, 4706},
  {4516, 4787, 4753},
  {4516, 4977, 4787},
  {4749, 4753, 4710},
  {4753, 4834, 4710},
  {4753, 4787, 4834},
  {4709, 4755, 4788},
  {4666, 4710, 4792},
  {4789, 4710, 4834},
  {4792, 4710, 4789},
  {4755, 4756, 4788},
  {4754, 4835, 4790},
  {4667, 4758, 4755},
  {4755, 4758, 4756},
  {4791, 4713, 4712},
  {4714, 4666, 4837},
  {4714, 4837, 4633},
  {4837, 4757, 4633},
  {4757, 4760, 4761},
  {4757, 4761, 4717},
  {4715, 4672, 4795},
  {4796, 4762, 4670},
  {4670, 4716, 4796},
  {4761, 4763, 4717},
  {4718, 4762, 4719},
  {4762, 4796, 4719},
  {4719, 4798, 4674},
  {4720, 4799, 4721},
  {4764, 6389, 4721},
  {4678, 4721, 6389},
  {4872, 4600, 4557},
  {6388, 4678, 6389},
  {6388, 6389, 6387},
  {4839, 4724, 4679},
  {4727, 4726, 4766},
  {4807, 4766, 4726},
  {4876, 4726, 4680},
  {4604, 4876, 4680},
  {4810, 4839, 4679},
  {4809, 4684, 4805},
  {4679, 4840, 4810},
  {4805, 4684, 6041},
  {4684, 4768, 6041},
  {4681, 5071, 4683},
  {4684, 4728, 4768},
  {4683, 5071, 4636},
  {4636, 4729, 4767},
  {5071, 4995, 4636},
  {4685, 4770, 4771},
  {4614, 4771, 4770},
  {4812, 4614, 4811},
  {4812, 4844, 4472},
  {4812, 4472, 4614},
  {4773, 4774, 4731},
  {6037, 6351, 4731},
  {6037, 4731, 4775},
  {4689, 4733, 4816},
  {4776, 4816, 4733},
  {6042, 4733, 4691},
  {4776, 4733, 6042},
  {5874, 4735, 4736},
  {4736, 4737, 5874},
  {4737, 4777, 5874},
  {4853, 5874, 4777},
  {5874, 4853, 4647},
  {4777, 4503, 4778},
  {4820, 4819, 4778},
  {4819, 4739, 4696},
  {4826, 4699, 4700},
  {4700, 4652, 4826},
  {4741, 4699, 4826},
  {4741, 4826, 4827},
  {4782, 4826, 6039},
  {4702, 4857, 4745},
  {4828, 4703, 4745},
  {4746, 4661, 4858},
  {4661, 4896, 4858},
  {4784, 4896, 4660},
  {4706, 4662, 4746},
  {4706, 4746, 4858},
  {4747, 4749, 4748},
  {4708, 4709, 4831},
  {4832, 4786, 4752},
  {4786, 4861, 4754},
  {4786, 4832, 4861},
  {4835, 4754, 4861},
  {4860, 4516, 4668},
  {4860, 4668, 4791},
  {4834, 4792, 4789},
  {4792, 4836, 4666},
  {4793, 4666, 4836},
  {4712, 4790, 4791},
  {4756, 4758, 4759},
  {4757, 4794, 4760},
  {4715, 4795, 4759},
  {4867, 4756, 4759},
  {4761, 4980, 4763},
  {4633, 4796, 4716},
  {4980, 4633, 4763},
  {4672, 4797, 4795},
  {4719, 4796, 4798},
  {4800, 4674, 4798},
  {4797, 4600, 4872},
  {4674, 4800, 4675},
  {4676, 6247, 4799},
  {4721, 4799, 4764},
  {4801, 4764, 4799},
  {4675, 4800, 4802},
  {4764, 4801, 6389},
  {4802, 4871, 4804},
  {4873, 4806, 4803},
  {4806, 4873, 4805},
  {5071, 4723, 4838},
  {4805, 6041, 4806},
  {4806, 6041, 4803},
  {4803, 6041, 6336},
  {4803, 6336, 6337},
  {4807, 4726, 4876},
  {4604, 4877, 4876},
  {4604, 4809, 4877},
  {4766, 4808, 4770},
  {4768, 4769, 6041},
  {4841, 4614, 4770},
  {4811, 4614, 4841},
  {4772, 4813, 4843},
  {4774, 4773, 4846},
  {4773, 4689, 4846},
  {4847, 4846, 4689},
  {4814, 4999, 6189},
  {4731, 4774, 4775},
  {4814, 4775, 4774},
  {4689, 4816, 4849},
  {6042, 4885, 4776},
  {4818, 4776, 4885},
  {4817, 4852, 4776},
  {4776, 4818, 4817},
  {4777, 4778, 4853},
  {6101, 4853, 4778},
  {6101, 4778, 4819},
  {6185, 4819, 4696},
  {4821, 4695, 4780},
  {4695, 4821, 4820},
  {4697, 4854, 4779},
  {6115, 4779, 4854},
  {4823, 4824, 4822},
  {6115, 4824, 4781},
  {4697, 4855, 4892},
  {4781, 4826, 4782},
  {4826, 4856, 4827},
  {4623, 4701, 4856},
  {4701, 4827, 4856},
  {4745, 4857, 4828},
  {4703, 4828, 4829},
  {4703, 4829, 4783},
  {4702, 4548, 4830},
  {4896, 4661, 4660},
  {4783, 4829, 4784},
  {4859, 4706, 4858},
  {4706, 4897, 4752},
  {4752, 4897, 4832},
  {4709, 4788, 4831},
  {4516, 4860, 4833},
  {4516, 4833, 4977},
  {4977, 4862, 4787},
  {4787, 4862, 4834},
  {4834, 4863, 4792},
  {4666, 4793, 4837},
  {4898, 4837, 4793},
  {4898, 4793, 4836},
  {4932, 4837, 4898},
  {4865, 4757, 4837},
  {4794, 4757, 4865},
  {4980, 4761, 4865},
  {4794, 4865, 4761},
  {4760, 4794, 4761},
  {4867, 4759, 4795},
  {4756, 4867, 4866},
  {4797, 4868, 4795},
  {4901, 4800, 4798},
  {6193, 4800, 4901},
  {4869, 4799, 6247},
  {4799, 4869, 4801},
  {4871, 4802, 4800},
  {4601, 4943, 6247},
  {4803, 6246, 4873},
  {4723, 4724, 4838},
  {4839, 4838, 4724},
  {4907, 4809, 4805},
  {4874, 4766, 4807},
  {4807, 4876, 4874},
  {4839, 4810, 4908},
  {4877, 4809, 4875},
  {4810, 4840, 5030},
  {4808, 4878, 4770},
  {4840, 4772, 4879},
  {4841, 4842, 4811},
  {4772, 4843, 4910},
  {4842, 4812, 4811},
  {4729, 4688, 4953},
  {4813, 4910, 4843},
  {4688, 4730, 4881},
  {4844, 4912, 6042},
  {4730, 4999, 4881},
  {4774, 4846, 4845},
  {4774, 4845, 4882},
  {4846, 4847, 4959},
  {4999, 4814, 4883},
  {4847, 4689, 4849},
  {4814, 4850, 4883},
  {4814, 4774, 4882},
  {4814, 4882, 4848},
  {4814, 4848, 4850},
  {4818, 4885, 4851},
  {4852, 4817, 4889},
  {4890, 4696, 4853},
  {6185, 4696, 4890},
  {4739, 4819, 4820},
  {4739, 4821, 4780},
  {4821, 4739, 4820},
  {4824, 6115, 4854},
  {4823, 4822, 4824},
  {4919, 4739, 4780},
  {4697, 4892, 4854},
  {4781, 4824, 4854},
  {4919, 4780, 4891},
  {4855, 4740, 4739},
  {4740, 4855, 4697},
  {4826, 4781, 4854},
  {4621, 4825, 4893},
  {4621, 4891, 4780},
  {4623, 5008, 4825},
  {4856, 4826, 4969},
  {4895, 4623, 4856},
  {4857, 4923, 4828},
  {4927, 4924, 4896},
  {4858, 4896, 4924},
  {4859, 4858, 4926},
  {4897, 4706, 4859},
  {4973, 4830, 4785},
  {4785, 4831, 4930},
  {4831, 4788, 4930},
  {4860, 4977, 4833},
  {4835, 4861, 4975},
  {4835, 4975, 4790},
  {4834, 4862, 4863},
  {4792, 4898, 4836},
  {4864, 4865, 4837},
  {4866, 4867, 4941},
  {4795, 4868, 4867},
  {4633, 4798, 4796},
  {4633, 5060, 4798},
  {4797, 4872, 4868},
  {4869, 4870, 6245},
  {6046, 6044, 6045},
  {4873, 6246, 4906},
  {4873, 4906, 4945},
  {4905, 4601, 4804},
  {4907, 4805, 4873},
  {4908, 4838, 4839},
  {4946, 4875, 4809},
  {4809, 4907, 4946},
  {4908, 4909, 4838},
  {4766, 4874, 4948},
  {4838, 4909, 5071},
  {4681, 4767, 5067},
  {4770, 4878, 4841},
  {4772, 4910, 4879},
  {4812, 4912, 4844},
  {4812, 4842, 4912},
  {4881, 4953, 4688},
  {4880, 4911, 4813},
  {4910, 4813, 4911},
  {4912, 4957, 6042},
  {4883, 4850, 4884},
  {6042, 4957, 4913},
  {4850, 4886, 4884},
  {4815, 4913, 4885},
  {4816, 4776, 4852},
  {4816, 4852, 4849},
  {4818, 4851, 4916},
  {4851, 4885, 4888},
  {4851, 4888, 4916},
  {4885, 4887, 4888},
  {4817, 4818, 4889},
  {4621, 6131, 4891},
  {4739, 4919, 4968},
  {4739, 4968, 4855},
  {4855, 4968, 4920},
  {4855, 4920, 4892},
  {4892, 4826, 4854},
  {4893, 4894, 4621},
  {4621, 4894, 5008},
  {4893, 4825, 5008},
  {4893, 5008, 4894},
  {4623, 4895, 5008},
  {4895, 5015, 5008},
  {4895, 4921, 5015},
  {4856, 4969, 4895},
  {4857, 4702, 4922},
  {4857, 4922, 4923},
  {4828, 4923, 4829},
  {4858, 4924, 4926},
  {4859, 5045, 4897},
  {4930, 4973, 4785},
  {5049, 4977, 4860},
  {4929, 4832, 4897},
  {4928, 4860, 4791},
  {4832, 4929, 4861},
  {4975, 4861, 4929},
  {4790, 4975, 4928},
  {4928, 4791, 4790},
  {4864, 4932, 4937},
  {4932, 4864, 4837},
  {4864, 4899, 4865},
  {4899, 4980, 4865},
  {4941, 4756, 4866},
  {5060, 4633, 4980},
  {4867, 4868, 4942},
  {4985, 4798, 4900},
  {4798, 4985, 4901},
  {4902, 4944, 4804},
  {4902, 4804, 4871},
  {4944, 4903, 4804},
  {4903, 4904, 4804},
  {4903, 4944, 4988},
  {4903, 4988, 4904},
  {4601, 4905, 4943},
  {4904, 4905, 4804},
  {4872, 4557, 4990},
  {4873, 4945, 4907},
  {4874, 4876, 4991},
  {4874, 4991, 4948},
  {4908, 4810, 4947},
  {4766, 4948, 4949},
  {4766, 4949, 4808},
  {4557, 4681, 5067},
  {4808, 4949, 4994},
  {4808, 4994, 4878},
  {5071, 6051, 4995},
  {4879, 5119, 4840},
  {4910, 4951, 4879},
  {4953, 4767, 4729},
  {4911, 4880, 4996},
  {4912, 4842, 4952},
  {4884, 4999, 4883},
  {4959, 4847, 5037},
  {4961, 5037, 4847},
  {4914, 4848, 4882},
  {4849, 4961, 4847},
  {4887, 4913, 4957},
  {4848, 4914, 4850},
  {4964, 4961, 4849},
  {4887, 4885, 4913},
  {4884, 4886, 4914},
  {4850, 4914, 4886},
  {4964, 4849, 4915},
  {4889, 4915, 4849},
  {4852, 4889, 4849},
  {4887, 4966, 4917},
  {4918, 4818, 4916},
  {4918, 4889, 4818},
  {5008, 6131, 4621},
  {4919, 4967, 4968},
  {4826, 4920, 4968},
  {4826, 4892, 4920},
  {4969, 4826, 5014},
  {4895, 4969, 4921},
  {4924, 4925, 5044},
  {4829, 4923, 5046},
  {4927, 4970, 4925},
  {4927, 4925, 4924},
  {4702, 4830, 5018},
  {4829, 5046, 4784},
  {4830, 4973, 5018},
  {4897, 4974, 4929},
  {4788, 4756, 4930},
  {4862, 4977, 4863},
  {4863, 6049, 4898},
  {4863, 4898, 4792},
  {6049, 4931, 4898},
  {4931, 4932, 4898},
  {4933, 4935, 4934},
  {4936, 4934, 4935},
  {4935, 4978, 4936},
  {4938, 4936, 4978},
  {4864, 4937, 4899},
  {4979, 4899, 4937},
  {4938, 4939, 5024},
  {4979, 4980, 4899},
  {4938, 4978, 4939},
  {4940, 4978, 4982},
  {4939, 4978, 4940},
  {5056, 4867, 4942},
  {4798, 5060, 4900},
  {4867, 5056, 4941},
  {4871, 4901, 4985},
  {4987, 6247, 4986},
  {6247, 4987, 6246},
  {4993, 4946, 4907},
  {4909, 4908, 4947},
  {4947, 4810, 4992},
  {4557, 5067, 5065},
  {5030, 4992, 4810},
  {5030, 4840, 4950},
  {4840, 5119, 4950},
  {4994, 4841, 4878},
  {4879, 5073, 5119},
  {4879, 4951, 5073},
  {4995, 4996, 4880},
  {4996, 4910, 4911},
  {4996, 4951, 4910},
  {4955, 4956, 4954},
  {4953, 4881, 4998},
  {4881, 4999, 4998},
  {4958, 4955, 5074},
  {4912, 5000, 4957},
  {4845, 4846, 5036},
  {4846, 4959, 5036},
  {4999, 4884, 5035},
  {4882, 4845, 5036},
  {4882, 5036, 4914},
  {5035, 4884, 4960},
  {4884, 4914, 4960},
  {4914, 5003, 4960},
  {4966, 4887, 4965},
  {4962, 4965, 4887},
  {4963, 4962, 6048},
  {4965, 4962, 5002},
  {4963, 6048, 4962},
  {4916, 4888, 4887},
  {4918, 4915, 4889},
  {6131, 5007, 4891},
  {5007, 5009, 4891},
  {5011, 4891, 5009},
  {5012, 4919, 4891},
  {4919, 5010, 4967},
  {4826, 4968, 5013},
  {5012, 4891, 5011},
  {5015, 5011, 5008},
  {4826, 5013, 5014},
  {5016, 5015, 4921},
  {4969, 5017, 4921},
  {5017, 5016, 4921},
  {4923, 4922, 4702},
  {5044, 4925, 4970},
  {4926, 4924, 5044},
  {4970, 4927, 5043},
  {5044, 5045, 4926},
  {5104, 4927, 4896},
  {4926, 5045, 4859},
  {5018, 4973, 5020},
  {4971, 5020, 4973},
  {4784, 5046, 5150},
  {4784, 5150, 4896},
  {4896, 5150, 5104},
  {4972, 4971, 4973},
  {4975, 5021, 4928},
  {4863, 5022, 6049},
  {4929, 4974, 4975},
  {5021, 4976, 4933},
  {4976, 5021, 4975},
  {4976, 4975, 5023},
  {4976, 5023, 4935},
  {4976, 4935, 4933},
  {4930, 4756, 5052},
  {4933, 4934, 5024},
  {4934, 4936, 5024},
  {4935, 5110, 4978},
  {4936, 4938, 5024},
  {4756, 5088, 5052},
  {4980, 4981, 5025},
  {4980, 4979, 4981},
  {4756, 4941, 5054},
  {4756, 5054, 5088},
  {4940, 4982, 4939},
  {5027, 5056, 4942},
  {4983, 5054, 4941},
  {5056, 4983, 4941},
  {5060, 4985, 4900},
  {4984, 5027, 4942},
  {4942, 4868, 4984},
  {4868, 4872, 4984},
  {4985, 5092, 4871},
  {6247, 4943, 4986},
  {6246, 4987, 4989},
  {4871, 5092, 4902},
  {6246, 4989, 4906},
  {4872, 4990, 5113},
  {5063, 4902, 5092},
  {4905, 5028, 4943},
  {4989, 4945, 4906},
  {4902, 5063, 4944},
  {5028, 4944, 5063},
  {4944, 5028, 4988},
  {4988, 5028, 4904},
  {4904, 5028, 4905},
  {4557, 5064, 4990},
  {4907, 4945, 4993},
  {4991, 4949, 4948},
  {4993, 4875, 4946},
  {4909, 4947, 4992},
  {5137, 4991, 4876},
  {4876, 4877, 5137},
  {4875, 4993, 5031},
  {4877, 4875, 5031},
  {4950, 5119, 5032},
  {4994, 5120, 4841},
  {4951, 4996, 5073},
  {4842, 4841, 4952},
  {4841, 5120, 5034},
  {4841, 5034, 4952},
  {4953, 4998, 4767},
  {4952, 5034, 4912},
  {4955, 4997, 6047},
  {4955, 4954, 4956},
  {4959, 5037, 5036},
  {4957, 5000, 4887},
  {5000, 5039, 4887},
  {5040, 4960, 5003},
  {4960, 5040, 5035},
  {5076, 4962, 4887},
  {4962, 5076, 5002},
  {5004, 5005, 4915},
  {5006, 4965, 5002},
  {4964, 4915, 5005},
  {4918, 5004, 4915},
  {5004, 4918, 4916},
  {4887, 4917, 5006},
  {5006, 4917, 4966},
  {4966, 4965, 5006},
  {4967, 5010, 4968},
  {5010, 4919, 5012},
  {5010, 5013, 4968},
  {4702, 5018, 4923},
  {5018, 5082, 4923},
  {5044, 4970, 5043},
  {5043, 4927, 5019},
  {5018, 5020, 5163},
  {5046, 4923, 5082},
  {4927, 5104, 5019},
  {5045, 5109, 4897},
  {5108, 4971, 4972},
  {6052, 5048, 5049},
  {4897, 5109, 4974},
  {5049, 6153, 4977},
  {4973, 4930, 4972},
  {6430, 4933, 6362},
  {4975, 4974, 5023},
  {4977, 5022, 4863},
  {6050, 5051, 4931},
  {4974, 5110, 5023},
  {5024, 5085, 4933},
  {5051, 5086, 4932},
  {5051, 4932, 4931},
  {5023, 5110, 4935},
  {4932, 5087, 4937},
  {5086, 5087, 4932},
  {4937, 4981, 4979},
  {4937, 5053, 4981},
  {4978, 5090, 4982},
  {4981, 5053, 5025},
  {4980, 5025, 6053},
  {4939, 4982, 5055},
  {5059, 4982, 5058},
  {5026, 4982, 5059},
  {5055, 4982, 5026},
  {4985, 5060, 5092},
  {4984, 4872, 5113},
  {4987, 4986, 4943},
  {5061, 4989, 4987},
  {5029, 4909, 4992},
  {5031, 4993, 4945},
  {4992, 5030, 5029},
  {4877, 5031, 5137},
  {5095, 5030, 4950},
  {4950, 5032, 5095},
  {4949, 5120, 4994},
  {4995, 5033, 4996},
  {5157, 4767, 4998},
  {4955, 5121, 6293},
  {4998, 5075, 5157},
  {5034, 5076, 4912},
  {6293, 5074, 4955},
  {4998, 4999, 5075},
  {4912, 5076, 5039},
  {4912, 5039, 5000},
  {5039, 5076, 4887},
  {5001, 5078, 5099},
  {5078, 5001, 5100},
  {5038, 4916, 4887},
  {4961, 5079, 5037},
  {4914, 5036, 5081},
  {4961, 4964, 5079},
  {5005, 5079, 4964},
  {5080, 5002, 5041},
  {5003, 4914, 5081},
  {4916, 5005, 5004},
  {5009, 6131, 5008},
  {6131, 5009, 5007},
  {5008, 5011, 5009},
  {5013, 5010, 5014},
  {5042, 5012, 5011},
  {5012, 5014, 5010},
  {5011, 5015, 5042},
  {5012, 5042, 5014},
  {4969, 5014, 5042},
  {5016, 5042, 5015},
  {5042, 5016, 4969},
  {5017, 4969, 5016},
  {6153, 5049, 5048},
  {4933, 5047, 6362},
  {4977, 5050, 5022},
  {5022, 5050, 5051},
  {4972, 4930, 5108},
  {5022, 5051, 6050},
  {4974, 5109, 5110},
  {5108, 4930, 5052},
  {4978, 5110, 5090},
  {5087, 5053, 4937},
  {4939, 5089, 5024},
  {5055, 5089, 4939},
  {5026, 5059, 5091},
  {5026, 5091, 5055},
  {4980, 5112, 5060},
  {5056, 5027, 5057},
  {4984, 5113, 5027},
  {4987, 4943, 5093},
  {5062, 5093, 4943},
  {4989, 5061, 5094},
  {5114, 5063, 5092},
  {5066, 4989, 5094},
  {4989, 5066, 4945},
  {5063, 5136, 5028},
  {5065, 5064, 4557},
  {5068, 5070, 4945},
  {4945, 5066, 5068},
  {5066, 5069, 5068},
  {4945, 5070, 5031},
  {5095, 5029, 5030},
  {5069, 5070, 5068},
  {4909, 5029, 5071},
  {5029, 5095, 5071},
  {5071, 5119, 5033},
  {5032, 5096, 5095},
  {5033, 5119, 5072},
  {5033, 5072, 4996},
  {4958, 5034, 4955},
  {5034, 4958, 5099},
  {4887, 5097, 5038},
  {5099, 4958, 5001},
  {5036, 5037, 5098},
  {5099, 5078, 5077},
  {5040, 5126, 5035},
  {5076, 5099, 5002},
  {5099, 5041, 5002},
  {5077, 5041, 5099},
  {4916, 5038, 5079},
  {5041, 5077, 5080},
  {5040, 5003, 5081},
  {5040, 5081, 5126},
  {5081, 5036, 5129},
  {4916, 5079, 5005},
  {5080, 5146, 5002},
  {4887, 5006, 5146},
  {5006, 5002, 5146},
  {5130, 5018, 5163},
  {5082, 5018, 5130},
  {5043, 5019, 5044},
  {5045, 5044, 5019},
  {5102, 5019, 5104},
  {5020, 4971, 5163},
  {5148, 5045, 5019},
  {5105, 5046, 5103},
  {5109, 5045, 5148},
  {5150, 5046, 5105},
  {6211, 5083, 5084},
  {6211, 5047, 5083},
  {5047, 4933, 5083},
  {4977, 6153, 6155},
  {6155, 6341, 4977},
  {4977, 6341, 5050},
  {5051, 5050, 5085},
  {5051, 5085, 5024},
  {5024, 5086, 5051},
  {5086, 5024, 5111},
  {5024, 5089, 5132},
  {5087, 5133, 5053},
  {5025, 5053, 5134},
  {5089, 5055, 5091},
  {5056, 5057, 4983},
  {5090, 5058, 4982},
  {5092, 5060, 5114},
  {4987, 5093, 5061},
  {5093, 5094, 5061},
  {4990, 5064, 5113},
  {5114, 5136, 5063},
  {5137, 4949, 4991},
  {5070, 5069, 5181},
  {5096, 5071, 5095},
  {5071, 5096, 5119},
  {5096, 5032, 5119},
  {5119, 5073, 5072},
  {5072, 5073, 4996},
  {5074, 5121, 5155},
  {5034, 5121, 4955},
  {5121, 5074, 6293},
  {5034, 5099, 5076},
  {4958, 5074, 5123},
  {4999, 5035, 5075},
  {4958, 5141, 5001},
  {4887, 5142, 5097},
  {5141, 5100, 5001},
  {5036, 5098, 5124},
  {5101, 5038, 5097},
  {5038, 5101, 5079},
  {5101, 5037, 5079},
  {5036, 5124, 5129},
  {5080, 5077, 5127},
  {5077, 5078, 5127},
  {5126, 5081, 5129},
  {5082, 5130, 5046},
  {5046, 5130, 5103},
  {5084, 5083, 5106},
  {5083, 4933, 5106},
  {6154, 4933, 6152},
  {5085, 6152, 4933},
  {5107, 6152, 5085},
  {5086, 5111, 5087},
  {5052, 5088, 5151},
  {5024, 5132, 5111},
  {5090, 5135, 5058},
  {5058, 5135, 5059},
  {5059, 5135, 5091},
  {5027, 5113, 5057},
  {4983, 5057, 5113},
  {5093, 5062, 5094},
  {5062, 5116, 5094},
  {5028, 5115, 4943},
  {4943, 5115, 5062},
  {5062, 5115, 5116},
  {5136, 5302, 5028},
  {5116, 5066, 5094},
  {5138, 5066, 5116},
  {5066, 5138, 5069},
  {5137, 5031, 5117},
  {5031, 5070, 5180},
  {5031, 5180, 5237},
  {4767, 5118, 5067},
  {4767, 5157, 5118},
  {5074, 5122, 5123},
  {5098, 5037, 5124},
  {5220, 5124, 5037},
  {5037, 5101, 5220},
  {5035, 5126, 5125},
  {5142, 4887, 5159},
  {5126, 5129, 5125},
  {5128, 5125, 5129},
  {5124, 5280, 5129},
  {5146, 5080, 5161},
  {5127, 5161, 5080},
  {4887, 5146, 5145},
  {5147, 5128, 5129},
  {5102, 5131, 5019},
  {5148, 5019, 5131},
  {5165, 5131, 5102},
  {5104, 5165, 5102},
  {5150, 5105, 5103},
  {5104, 5150, 5168},
  {5171, 5110, 5109},
  {5153, 5111, 5132},
  {5173, 5087, 5111},
  {5089, 5152, 5132},
  {5133, 5087, 5173},
  {5089, 5091, 5204},
  {5112, 4980, 5176},
  {4980, 6053, 6414},
  {4980, 6414, 5176},
  {5060, 5112, 5114},
  {5113, 5054, 4983},
  {5114, 5210, 5295},
  {5114, 5295, 5233},
  {5113, 5064, 5118},
  {5114, 5233, 5136},
  {5064, 5065, 5118},
  {5302, 5115, 5028},
  {5116, 5178, 5138},
  {5118, 5065, 5067},
  {5179, 5117, 5031},
  {5181, 5180, 5070},
  {5120, 4949, 5139},
  {5139, 5308, 5121},
  {5139, 5121, 5034},
  {5034, 5120, 5139},
  {5218, 5122, 5074},
  {4958, 5123, 5141},
  {5143, 5122, 5218},
  {5183, 5215, 5097},
  {5184, 5183, 5097},
  {5142, 5184, 5097},
  {5122, 5143, 5123},
  {5141, 5188, 5100},
  {5188, 5078, 5100},
  {5127, 5078, 5188},
  {5125, 5250, 5035},
  {5101, 5144, 5220},
  {5125, 5128, 5250},
  {5159, 4887, 5145},
  {5161, 5127, 5187},
  {5147, 5129, 5280},
  {5103, 5130, 5163},
  {5104, 5168, 5149},
  {5104, 5149, 5165},
  {5108, 5172, 4971},
  {5052, 5151, 5108},
  {5089, 5225, 5152},
  {5152, 5225, 5132},
  {5132, 5225, 5153},
  {5090, 5110, 5203},
  {5133, 5173, 5227},
  {5053, 5133, 6436},
  {5053, 6436, 6437},
  {5135, 5204, 5091},
  {5175, 5204, 5135},
  {5206, 6202, 5174},
  {5210, 5114, 5112},
  {5154, 5112, 5176},
  {5054, 5113, 5177},
  {5154, 5210, 5112},
  {5113, 5118, 5177},
  {5302, 5136, 5234},
  {5115, 5178, 5116},
  {5181, 5138, 5178},
  {5235, 4949, 5137},
  {5137, 5117, 5235},
  {5138, 5181, 5069},
  {5179, 5235, 5117},
  {4949, 5240, 5139},
  {5118, 5157, 5239},
  {5139, 5240, 5308},
  {5121, 5308, 5155},
  {5156, 5155, 5308},
  {5075, 5246, 5157},
  {5075, 5140, 5246},
  {5218, 5074, 5155},
  {5184, 5142, 5158},
  {5158, 5142, 5216},
  {5141, 5123, 5218},
  {5140, 5075, 5185},
  {5123, 5143, 5218},
  {5075, 5217, 5185},
  {5216, 5142, 5186},
  {5217, 5075, 5035},
  {5142, 5159, 5186},
  {5035, 5250, 5217},
  {5144, 5101, 5097},
  {5220, 5144, 5160},
  {5144, 5221, 5160},
  {5145, 5146, 5159},
  {5127, 5188, 5187},
  {5250, 5128, 5162},
  {5147, 5162, 5128},
  {5103, 5163, 5190},
  {5148, 5131, 5164},
  {5148, 5164, 5165},
  {5191, 5190, 5163},
  {5103, 5190, 6273},
  {5131, 5165, 5164},
  {5148, 5165, 5166},
  {5148, 5166, 5109},
  {5109, 5166, 5192},
  {6218, 6217, 5167},
  {5163, 4971, 5191},
  {5168, 5165, 5149},
  {5193, 5109, 5192},
  {5193, 5196, 5109},
  {5103, 6273, 5199},
  {5103, 5199, 5150},
  {5109, 5196, 5197},
  {5169, 5168, 5150},
  {5200, 5150, 5199},
  {5150, 5200, 5169},
  {5109, 5170, 5171},
  {5108, 5151, 5224},
  {5226, 5110, 5171},
  {5287, 5226, 5171},
  {5173, 5111, 5153},
  {5226, 5203, 5110},
  {6436, 5133, 5227},
  {5090, 5203, 5135},
  {5177, 5232, 5054},
  {5177, 5118, 6473},
  {5180, 5181, 5182},
  {5180, 5182, 5243},
  {5157, 5212, 5239},
  {5248, 5155, 5156},
  {5213, 5248, 5156},
  {5155, 5248, 5218},
  {5141, 5218, 5248},
  {5219, 5097, 5215},
  {5141, 5186, 5188},
  {5124, 5220, 5280},
  {5144, 5097, 5221},
  {5219, 5221, 5097},
  {5161, 5186, 5159},
  {5187, 5186, 5161},
  {5159, 5146, 5161},
  {5162, 5147, 5189},
  {5877, 5283, 5189},
  {5165, 5168, 5166},
  {5166, 5168, 5193},
  {5194, 5195, 5196},
  {5197, 5198, 5196},
  {5197, 6205, 5109},
  {5109, 6205, 5170},
  {5254, 5170, 6205},
  {5200, 5222, 5169},
  {5255, 5169, 5222},
  {5168, 5169, 5255},
  {5172, 5108, 5224},
  {5225, 5201, 5153},
  {5202, 5227, 5201},
  {5227, 5202, 5205},
  {5088, 5054, 5347},
  {5205, 5229, 5227},
  {5204, 5175, 5228},
  {5227, 6435, 6436},
  {5203, 5263, 5135},
  {5175, 5135, 5228},
  {5227, 5229, 5296},
  {5176, 5208, 5209},
  {5209, 5210, 5176},
  {5154, 5176, 5210},
  {6473, 5118, 5265},
  {5266, 5265, 5118},
  {5211, 5266, 5118},
  {5303, 5211, 5118},
  {5268, 5115, 5302},
  {5178, 5115, 5321},
  {5181, 5178, 5321},
  {5239, 5303, 5118},
  {5235, 5240, 4949},
  {5235, 5179, 5241},
  {5179, 5031, 5236},
  {5237, 5236, 5031},
  {5180, 5243, 5237},
  {5181, 5238, 5182},
  {5243, 5182, 5238},
  {5141, 5214, 5245},
  {5214, 5141, 5329},
  {5216, 5186, 5141},
  {5215, 5277, 5219},
  {5186, 5187, 5188},
  {5189, 5283, 5162},
  {5283, 5877, 5252},
  {5189, 5252, 5877},
  {5191, 5253, 5190},
  {5191, 4971, 5253},
  {5166, 5193, 5192},
  {5194, 5196, 5195},
  {5196, 5197, 5198},
  {5196, 5193, 5286},
  {5196, 5286, 5197},
  {5197, 5286, 6205},
  {6205, 5286, 5254},
  {5200, 5199, 5222},
  {5193, 5168, 5255},
  {5193, 5255, 5286},
  {5171, 5170, 5223},
  {5254, 5223, 5170},
  {5171, 5223, 5287},
  {4971, 5172, 5316},
  {5224, 5316, 5172},
  {5256, 6335, 5258},
  {5225, 5202, 5201},
  {5225, 5089, 5261},
  {5261, 5089, 5204},
  {5088, 5347, 5151},
  {5203, 5262, 5263},
  {5228, 5135, 5263},
  {5294, 5347, 5054},
  {5296, 5176, 5227},
  {5227, 5176, 6435},
  {5207, 5230, 6254},
  {5207, 6254, 5230},
  {5208, 5231, 5209},
  {5234, 5136, 5233},
  {5211, 5303, 5269},
  {5181, 5321, 5238},
  {5179, 5236, 5241},
  {5237, 5243, 5305},
  {5305, 5243, 5242},
  {5305, 5242, 5270},
  {5239, 5212, 5271},
  {5212, 5157, 5324},
  {5324, 5157, 5246},
  {5156, 5308, 5213},
  {5141, 5245, 5244},
  {5245, 5274, 5244},
  {5245, 5275, 5274},
  {5183, 5184, 5215},
  {5215, 5184, 5391},
  {5184, 5158, 5278},
  {5279, 5278, 5158},
  {5141, 5248, 5329},
  {5185, 5217, 5140},
  {5158, 5216, 5279},
  {5217, 5250, 5333},
  {5249, 5221, 5219},
  {5281, 5160, 5221},
  {5221, 5249, 5281},
  {5160, 5281, 5282},
  {5147, 5280, 5189},
  {5160, 5282, 5251},
  {5162, 5283, 5250},
  {5283, 5252, 5284},
  {5341, 5199, 5340},
  {5222, 5199, 5341},
  {5254, 5286, 5223},
  {5222, 5342, 5255},
  {5286, 5287, 5223},
  {5257, 6224, 5256},
  {5258, 6334, 5259},
  {5203, 5226, 5287},
  {6333, 5260, 5259},
  {5260, 5225, 5261},
  {6332, 5259, 5260},
  {5225, 5260, 5202},
  {5224, 5151, 5417},
  {5261, 5204, 5288},
  {5260, 5292, 5202},
  {5202, 5292, 5205},
  {5229, 5293, 5296},
  {5176, 5296, 5208},
  {5208, 5297, 5231},
  {6472, 5264, 5177},
  {5177, 5264, 5232},
  {5293, 5210, 5296},
  {5264, 5267, 5232},
  {5232, 5267, 5054},
  {5298, 6474, 5299},
  {5233, 5300, 5234},
  {5266, 5211, 5301},
  {5115, 5268, 5321},
  {5211, 5269, 5301},
  {5321, 5323, 5238},
  {5306, 5241, 5236},
  {5236, 5237, 5306},
  {5305, 5306, 5237},
  {5240, 5235, 5241},
  {5240, 5241, 5306},
  {5240, 5306, 5308},
  {5242, 5243, 5356},
  {5242, 5356, 5270},
  {5271, 5212, 5324},
  {5272, 5141, 5244},
  {5272, 5244, 5274},
  {5308, 5309, 5213},
  {5310, 5213, 5309},
  {5141, 5272, 5273},
  {5213, 5310, 5247},
  {5245, 5214, 5275},
  {5329, 5275, 5214},
  {5279, 5141, 5273},
  {5366, 5213, 5247},
  {5279, 5273, 5278},
  {5276, 5248, 5213},
  {5246, 5140, 5217},
  {5184, 5278, 5391},
  {5279, 5216, 5141},
  {5329, 5248, 5276},
  {5215, 5391, 5277},
  {5277, 5331, 5219},
  {5331, 5249, 5219},
  {5281, 5249, 5331},
  {5189, 5280, 5519},
  {5251, 5282, 5876},
  {5253, 4971, 5285},
  {4971, 5313, 5285},
  {6273, 5339, 5199},
  {5199, 5339, 5340},
  {5257, 5256, 6224},
  {5256, 5258, 6335},
  {5258, 5259, 6334},
  {5260, 5261, 5292},
  {5289, 5291, 5317},
  {5289, 5317, 5288},
  {5292, 5261, 5318},
  {5204, 5289, 5288},
  {5151, 5347, 5417},
  {5203, 5525, 5262},
  {5289, 5204, 5228},
  {5289, 5228, 5345},
  {5345, 5228, 5263},
  {5229, 5205, 6483},
  {5229, 6483, 5293},
  {5293, 5319, 5210},
  {5297, 5208, 5296},
  {5297, 5209, 5231},
  {5381, 5294, 5054},
  {5348, 5233, 5295},
  {5297, 5296, 5210},
  {5210, 5209, 5297},
  {5233, 5348, 5300},
  {5299, 5265, 5264},
  {5267, 5264, 5265},
  {5265, 5266, 5267},
  {5267, 5384, 5054},
  {5266, 5301, 5267},
  {5384, 5267, 5301},
  {5268, 5302, 5352},
  {5304, 5303, 5239},
  {5238, 5323, 5243},
  {5356, 5243, 5323},
  {5306, 5305, 5308},
  {5305, 5270, 5307},
  {5239, 5271, 5324},
  {5239, 5324, 5304},
  {5356, 5405, 5270},
  {5307, 5270, 5405},
  {5310, 5327, 5311},
  {5310, 5311, 5247},
  {5326, 5278, 5273},
  {5366, 5247, 5311},
  {5331, 5277, 5312},
  {5277, 5391, 5312},
  {5391, 5278, 5332},
  {5217, 5333, 5330},
  {5280, 5220, 5367},
  {5331, 5334, 5281},
  {5220, 5876, 5367},
  {5281, 5334, 5282},
  {5189, 5519, 5252},
  {5337, 5284, 5252},
  {5337, 5283, 5284},
  {6273, 6274, 5339},
  {5341, 5314, 5222},
  {5342, 5222, 5314},
  {5342, 5315, 5255},
  {5255, 5315, 5369},
  {5375, 5224, 5379},
  {5317, 5291, 5290},
  {5345, 5343, 5290},
  {5318, 5288, 5317},
  {5288, 5318, 5261},
  {5290, 5291, 5345},
  {5289, 5345, 5291},
  {5205, 5292, 5394},
  {5205, 6054, 6483},
  {5262, 5346, 5263},
  {5345, 5263, 5346},
  {5299, 5264, 6472},
  {5320, 5300, 5348},
  {5398, 5300, 5320},
  {5300, 5398, 5234},
  {5301, 5269, 5351},
  {5234, 5382, 5302},
  {5321, 5268, 5354},
  {5382, 5352, 5302},
  {5352, 5353, 5268},
  {5322, 5355, 5353},
  {5355, 5321, 5353},
  {5269, 5303, 5401},
  {5321, 5355, 5323},
  {5303, 5304, 5384},
  {5305, 5307, 5309},
  {5308, 5305, 5309},
  {5309, 5307, 5325},
  {5307, 5405, 5325},
  {5309, 5325, 5310},
  {5327, 5310, 5325},
  {5325, 5405, 5327},
  {5324, 5246, 5404},
  {5328, 5404, 5246},
  {5388, 5328, 5246},
  {5329, 5274, 5275},
  {5327, 5361, 5311},
  {5217, 5330, 5388},
  {5330, 5362, 5388},
  {5388, 5246, 5217},
  {5278, 5326, 5332},
  {5366, 5276, 5213},
  {5331, 5312, 5363},
  {5406, 5363, 5312},
  {5392, 5329, 5276},
  {5330, 5333, 5364},
  {5391, 5406, 5312},
  {5333, 5250, 5481},
  {5283, 5481, 5250},
  {5335, 5876, 5282},
  {5334, 5335, 5282},
  {5336, 5876, 5335},
  {5252, 5519, 5337},
  {4971, 5338, 5313},
  {6274, 5338, 5339},
  {5369, 5372, 5255},
  {5286, 5255, 5372},
  {5341, 5373, 5376},
  {5341, 5376, 5314},
  {5342, 5393, 5315},
  {5373, 4971, 5316},
  {5376, 5342, 5314},
  {5342, 5376, 5393},
  {5375, 5316, 5224},
  {5290, 5343, 5317},
  {5224, 5417, 5379},
  {5317, 5394, 5318},
  {5318, 5394, 5292},
  {5205, 5394, 6054},
  {5262, 5525, 5344},
  {5262, 5344, 5346},
  {5210, 5319, 6203},
  {5210, 6203, 5396},
  {5295, 5210, 5420},
  {5210, 5396, 5420},
  {5295, 5420, 5348},
  {5348, 5349, 5320},
  {5054, 5384, 5381},
  {5234, 5398, 5350},
  {5350, 5382, 5234},
  {5268, 5353, 5354},
  {5321, 5354, 5353},
  {5401, 5351, 5269},
  {5352, 5322, 5353},
  {5303, 5423, 5401},
  {5451, 5352, 5383},
  {5352, 5451, 5322},
  {5357, 5355, 5322},
  {5355, 5356, 5323},
  {5322, 5451, 5357},
  {5357, 5356, 5355},
  {5304, 5324, 5426},
  {5357, 5385, 5356},
  {5404, 5358, 5324},
  {5326, 5273, 5386},
  {5273, 5272, 5386},
  {5274, 5386, 5272},
  {5405, 5387, 5359},
  {5359, 5360, 5405},
  {5328, 5388, 5404},
  {5406, 5326, 5386},
  {5332, 5326, 5391},
  {5326, 5406, 5391},
  {5366, 5311, 5361},
  {5362, 5330, 5364},
  {5390, 5362, 5364},
  {5276, 5365, 5392},
  {5276, 5366, 5365},
  {5364, 5333, 5408},
  {5280, 5367, 5410},
  {5336, 5335, 5331},
  {5336, 5331, 5368},
  {5367, 5336, 5368},
  {5335, 5334, 5331},
  {5338, 4971, 5339},
  {4971, 5371, 5339},
  {4971, 5373, 5371},
  {5371, 5340, 5339},
  {5371, 5373, 5340},
  {5369, 5370, 5372},
  {5340, 5373, 5341},
  {5373, 5375, 5376},
  {5374, 5287, 5286},
  {5374, 5286, 5372},
  {5316, 5375, 5373},
  {5375, 5377, 5376},
  {5375, 5379, 5377},
  {5376, 5377, 5412},
  {5376, 5412, 5393},
  {5287, 5525, 5203},
  {5343, 5345, 5378},
  {5317, 5343, 5394},
  {5394, 5395, 6054},
  {5525, 5380, 5344},
  {5319, 6482, 6203},
  {5294, 5381, 5471},
  {5472, 5349, 5348},
  {5349, 5472, 5320},
  {5399, 5381, 5384},
  {5398, 5320, 5472},
  {5423, 5351, 5401},
  {5351, 5423, 5301},
  {5301, 5423, 5384},
  {5303, 5384, 5423},
  {5384, 5304, 5399},
  {5357, 5451, 5385},
  {5324, 5358, 5426},
  {5385, 5454, 5356},
  {5454, 5385, 5455},
  {5274, 5329, 5459},
  {5387, 5389, 5359},
  {5360, 5361, 5405},
  {5405, 5361, 5327},
  {5388, 5362, 5430},
  {5363, 5406, 5457},
  {5359, 5389, 5360},
  {5360, 5366, 5361},
  {5363, 5407, 5331},
  {5364, 5408, 5390},
  {5392, 5460, 5329},
  {5408, 5333, 5481},
  {5367, 5368, 5410},
  {5331, 5410, 5368},
  {5411, 5481, 5283},
  {5337, 5519, 5411},
  {5283, 5337, 5411},
  {5369, 6481, 5370},
  {5370, 6480, 5287},
  {5374, 5370, 5287},
  {5370, 5374, 5372},
  {5436, 5315, 5393},
  {5412, 5377, 5379},
  {5378, 5413, 5343},
  {5343, 5413, 5415},
  {5417, 5414, 5379},
  {5343, 5415, 5416},
  {5343, 5416, 5394},
  {5440, 5394, 5439},
  {5395, 5394, 5440},
  {6054, 5395, 5440},
  {5525, 5418, 5380},
  {5397, 5417, 5347},
  {5380, 5444, 5344},
  {5419, 5345, 5346},
  {5445, 5345, 5419},
  {5344, 5444, 5346},
  {5419, 5346, 5444},
  {5397, 5347, 5294},
  {5348, 5420, 5446},
  {5397, 5294, 5471},
  {5381, 5399, 5421},
  {5398, 5400, 5350},
  {5421, 5399, 5422},
  {5350, 5400, 5382},
  {5382, 5400, 5352},
  {5400, 5383, 5352},
  {5399, 5304, 5402},
  {5304, 5426, 5402},
  {5451, 5479, 5385},
  {5452, 5385, 5479},
  {5385, 5452, 5455},
  {5454, 6305, 5356},
  {5356, 6305, 5405},
  {5427, 5387, 5403},
  {5403, 5387, 5452},
  {5387, 5455, 5452},
  {5358, 5404, 5453},
  {5274, 5459, 5386},
  {5430, 5404, 5388},
  {5386, 5457, 5406},
  {5499, 5459, 5329},
  {5390, 5430, 5362},
  {5430, 5390, 5431},
  {5408, 5431, 5390},
  {5389, 5432, 5360},
  {5365, 5360, 5432},
  {5366, 5360, 5365},
  {5432, 5433, 5365},
  {5392, 5365, 5433},
  {5407, 5434, 5435},
  {5433, 5409, 5392},
  {5482, 5519, 5280},
  {5410, 5482, 5280},
  {5407, 5435, 5331},
  {5331, 5435, 5410},
  {6480, 5483, 5287},
  {5369, 5315, 5483},
  {5484, 5483, 5315},
  {5315, 5436, 5484},
  {5287, 5524, 5525},
  {5413, 5378, 5437},
  {5462, 5437, 5378},
  {5412, 5379, 5414},
  {5345, 5462, 5378},
  {5439, 5394, 5416},
  {5417, 5441, 5414},
  {5443, 5418, 5525},
  {5418, 5444, 5380},
  {5396, 6203, 5420},
  {5447, 5348, 5446},
  {5472, 5348, 5447},
  {5398, 5472, 5400},
  {5402, 5426, 5478},
  {5402, 5478, 5399},
  {5424, 5425, 5450},
  {5383, 5449, 5450},
  {5383, 5450, 5451},
  {5425, 5427, 5403},
  {5425, 5403, 5450},
  {5450, 5403, 5451},
  {5403, 5479, 5451},
  {5452, 5479, 5403},
  {5426, 5358, 5478},
  {5453, 5478, 5358},
  {5387, 5427, 5389},
  {5457, 5386, 5428},
  {5456, 5387, 5405},
  {5429, 5404, 5430},
  {5329, 5460, 5499},
  {5389, 5573, 5460},
  {5550, 5431, 5408},
  {5389, 5460, 5432},
  {5481, 5574, 5550},
  {5481, 5550, 5408},
  {5392, 5409, 5460},
  {5460, 5409, 5433},
  {5481, 5411, 5461},
  {5524, 5287, 5483},
  {5393, 5412, 5436},
  {5437, 5462, 5413},
  {5414, 5487, 5438},
  {5412, 5414, 5438},
  {5415, 5442, 5416},
  {5416, 5442, 5439},
  {5414, 5441, 5487},
  {5439, 5442, 5468},
  {5466, 5443, 5525},
  {5417, 5470, 5441},
  {5468, 5442, 5464},
  {5444, 5418, 5443},
  {6203, 5469, 5420},
  {5509, 5420, 5469},
  {5445, 5419, 5444},
  {5471, 5417, 5397},
  {5381, 5421, 5471},
  {5421, 5422, 5473},
  {5400, 5516, 5383},
  {5383, 5516, 5476},
  {5448, 5495, 5424},
  {5448, 5424, 5476},
  {5383, 5476, 5449},
  {5424, 5495, 5425},
  {5476, 5424, 5449},
  {5450, 5449, 5424},
  {5427, 5480, 5389},
  {5455, 5387, 6055},
  {5456, 6055, 5387},
  {5404, 5497, 5453},
  {5363, 5457, 5498},
  {5459, 5458, 5386},
  {5363, 5498, 5407},
  {5500, 5499, 5460},
  {5433, 5432, 5460},
  {5482, 5435, 5434},
  {5411, 5519, 5461},
  {5410, 5435, 5482},
  {5521, 5484, 5436},
  {5462, 5415, 5413},
  {5462, 5345, 5463},
  {5412, 5438, 5486},
  {5438, 5487, 5486},
  {5345, 5504, 5463},
  {5345, 5445, 5504},
  {5505, 5442, 5415},
  {5442, 5505, 5464},
  {5439, 5468, 6203},
  {5525, 5488, 5466},
  {5468, 5465, 6203},
  {5464, 5467, 5468},
  {6203, 5465, 5469},
  {5443, 5466, 5490},
  {5443, 5490, 5444},
  {5446, 5420, 5509},
  {5472, 5447, 5446},
  {5472, 5516, 5400},
  {5476, 5516, 5475},
  {5422, 5399, 5478},
  {5474, 5495, 5448},
  {5476, 6056, 5477},
  {5495, 5496, 5425},
  {5425, 5496, 5480},
  {5425, 5480, 5427},
  {5457, 5428, 5518},
  {5386, 5518, 5428},
  {5386, 5458, 5518},
  {5550, 5497, 5431},
  {5501, 5407, 5498},
  {5407, 5501, 5434},
  {5482, 5434, 5501},
  {5481, 5520, 5574},
  {5481, 5461, 5520},
  {5436, 5412, 5485},
  {5462, 5463, 5415},
  {5528, 5485, 5412},
  {5486, 5528, 5412},
  {5463, 5502, 5415},
  {5463, 5504, 5502},
  {5505, 5415, 5502},
  {5505, 5467, 5464},
  {5467, 5505, 5491},
  {5465, 5468, 5506},
  {5488, 5489, 5466},
  {5466, 5489, 5490},
  {5490, 5445, 5444},
  {5468, 5467, 5506},
  {5491, 5506, 5467},
  {5469, 5465, 5509},
  {5470, 5511, 5535},
  {5470, 5417, 5511},
  {5471, 5511, 5417},
  {5473, 5471, 5421},
  {5448, 5540, 5474},
  {5448, 5476, 5542},
  {5493, 5516, 5517},
  {5422, 5478, 5566},
  {5516, 5493, 5475},
  {5493, 5492, 5494},
  {5477, 6056, 5476},
  {5498, 5457, 5518},
  {5549, 5497, 5550},
  {5499, 5458, 5459},
  {5500, 5460, 5573},
  {5501, 5519, 5482},
  {5520, 5461, 5519},
  {5483, 5484, 5524},
  {5521, 5522, 5484},
  {5524, 5484, 5522},
  {5436, 5485, 5521},
  {5502, 5503, 5529},
  {5486, 5487, 5531},
  {5486, 5531, 5528},
  {5502, 5529, 5505},
  {5531, 5487, 5585},
  {5525, 5532, 5488},
  {5530, 5445, 5490},
  {5487, 5441, 5535},
  {5441, 5470, 5535},
  {5488, 5507, 5489},
  {5489, 5507, 5508},
  {5489, 5508, 5490},
  {5465, 5506, 5509},
  {5512, 5584, 5510},
  {5584, 5512, 5534},
  {5589, 5534, 5512},
  {5509, 5558, 5446},
  {5559, 5535, 5511},
  {5515, 5510, 5513},
  {5512, 5510, 5515},
  {5560, 5511, 5471},
  {5471, 5537, 5594},
  {5514, 5513, 5536},
  {5515, 5513, 5514},
  {5473, 5537, 5471},
  {5446, 5516, 5472},
  {5566, 5473, 5422},
  {5543, 5474, 5540},
  {5476, 5475, 5542},
  {5474, 5543, 5495},
  {5493, 5542, 5475},
  {5542, 5493, 6057},
  {5494, 5492, 5493},
  {5544, 5495, 5543},
  {5633, 5566, 5478},
  {5544, 5496, 5495},
  {5480, 5496, 5598},
  {5633, 5478, 5453},
  {5497, 5549, 5548},
  {5573, 5389, 5480},
  {6060, 6058, 6059},
  {5523, 6162, 5521},
  {5523, 5521, 5485},
  {5485, 5551, 5523},
  {5551, 5485, 6110},
  {6110, 5485, 5528},
  {5525, 5524, 5880},
  {6280, 5503, 5504},
  {5504, 5503, 5502},
  {5503, 6280, 5529},
  {5530, 5584, 5556},
  {5530, 5556, 5504},
  {5504, 5445, 5530},
  {5488, 5532, 5533},
  {5491, 5556, 5584},
  {5556, 5491, 5505},
  {5488, 5533, 5507},
  {5507, 5533, 5508},
  {5534, 5491, 5584},
  {5534, 5589, 5491},
  {5506, 5491, 5509},
  {5558, 5509, 5491},
  {5560, 5559, 5511},
  {5561, 5446, 5558},
  {5540, 5539, 5538},
  {5539, 5540, 5562},
  {5564, 5446, 5561},
  {5541, 5446, 5564},
  {5473, 5566, 5594},
  {5540, 5538, 5563},
  {5448, 5542, 5540},
  {5446, 6062, 5516},
  {5446, 5541, 6062},
  {5542, 6220, 5565},
  {5514, 5568, 5569},
  {5542, 6219, 6220},
  {5544, 5598, 5496},
  {5545, 5453, 5497},
  {5545, 5633, 5453},
  {5545, 5497, 5546},
  {5497, 5548, 5546},
  {5548, 5570, 5546},
  {5601, 5498, 5518},
  {5549, 5571, 5548},
  {5549, 5550, 5571},
  {5498, 5601, 5572},
  {5498, 5572, 5648},
  {5498, 5648, 5501},
  {5500, 6064, 5499},
  {5520, 5605, 5574},
  {5501, 5648, 5519},
  {5520, 5519, 5575},
  {5524, 5522, 6313},
  {5524, 6313, 5580},
  {5523, 5551, 5579},
  {5553, 6061, 6109},
  {5582, 6110, 5528},
  {5585, 5582, 5528},
  {5582, 5585, 5880},
  {5585, 5528, 5531},
  {5530, 5554, 5584},
  {5554, 5555, 5584},
  {5555, 5554, 5557},
  {5530, 5557, 5554},
  {5556, 5505, 5529},
  {5535, 5585, 5487},
  {5525, 5586, 5532},
  {5557, 5530, 5490},
  {5532, 5586, 5533},
  {5508, 5557, 5490},
  {5533, 5607, 5508},
  {5650, 5510, 5584},
  {5535, 5588, 5585},
  {5588, 5535, 5559},
  {5650, 5513, 5510},
  {5593, 5558, 5491},
  {5626, 5513, 5650},
  {5513, 5626, 5536},
  {5515, 5589, 5512},
  {5590, 5561, 5558},
  {5536, 5626, 5514},
  {5639, 5514, 5626},
  {5562, 5563, 5539},
  {5537, 5473, 5594},
  {5538, 5539, 5563},
  {5540, 5610, 5562},
  {5540, 5542, 5610},
  {5514, 5613, 5568},
  {5563, 6063, 5540},
  {5541, 5542, 5565},
  {5514, 5569, 5567},
  {5543, 5597, 5544},
  {5545, 5546, 5599},
  {5480, 5598, 5602},
  {5546, 5547, 5599},
  {5547, 5546, 5618},
  {5547, 5618, 5599},
  {5546, 5603, 5618},
  {5546, 5570, 5603},
  {5458, 5499, 5518},
  {5548, 5571, 5570},
  {6064, 5500, 5573},
  {5622, 5605, 5520},
  {5575, 5519, 5606},
  {5575, 5622, 5520},
  {5576, 6162, 5523},
  {6314, 6315, 6390},
  {6314, 6390, 6313},
  {6132, 6133, 5578},
  {6313, 6390, 5580},
  {5552, 6111, 6108},
  {5581, 5551, 5582},
  {5582, 5551, 6110},
  {5525, 5623, 5586},
  {5584, 5555, 5583},
  {5635, 5583, 5555},
  {5555, 5557, 5635},
  {5586, 5587, 5533},
  {5652, 5557, 5508},
  {5650, 5584, 5625},
  {5652, 5508, 5607},
  {5607, 5533, 5587},
  {5636, 5491, 5589},
  {5560, 5588, 5559},
  {5560, 5471, 5702},
  {5558, 5593, 5590},
  {5593, 5491, 5591},
  {5609, 5561, 5590},
  {5563, 5562, 5593},
  {5563, 5593, 5592},
  {5562, 5610, 5593},
  {5609, 5564, 5561},
  {5514, 5639, 5613},
  {5610, 5542, 5595},
  {5595, 5542, 5564},
  {5564, 5542, 5541},
  {5515, 5514, 5567},
  {5566, 5612, 5594},
  {5540, 5596, 5543},
  {5567, 5569, 5616},
  {5613, 5615, 5568},
  {5568, 5616, 5569},
  {5599, 5633, 5545},
  {5602, 5598, 5600},
  {5646, 5601, 5518},
  {5619, 5603, 5570},
  {5602, 5604, 5480},
  {5571, 5619, 5570},
  {5621, 5480, 5620},
  {5480, 5604, 5620},
  {5647, 5572, 5601},
  {5480, 5621, 5573},
  {5550, 5574, 5571},
  {5622, 5574, 5605},
  {5622, 5575, 5606},
  {5577, 5576, 5523},
  {5578, 6133, 6132},
  {5523, 5579, 6390},
  {5580, 6390, 5579},
  {5581, 5579, 5551},
  {5579, 5581, 5580},
  {5580, 5581, 5582},
  {5623, 5525, 5879},
  {5624, 5583, 5635},
  {5623, 5587, 5586},
  {5583, 5624, 5584},
  {5625, 5584, 5624},
  {5635, 5557, 5649},
  {5588, 5651, 5585},
  {5560, 5702, 5588},
  {5636, 5591, 5491},
  {5590, 5593, 5608},
  {5608, 5609, 5590},
  {5592, 5627, 5611},
  {5592, 5591, 5627},
  {5592, 5611, 5563},
  {5593, 5610, 5608},
  {5610, 5564, 5609},
  {5564, 5610, 5595},
  {5589, 5515, 5567},
  {5563, 5611, 6063},
  {5596, 5597, 5543},
  {5567, 5616, 5659},
  {5613, 5614, 5615},
  {5568, 5615, 5616},
  {5598, 5544, 5632},
  {5598, 5632, 5617},
  {5600, 5598, 5617},
  {5617, 5643, 5600},
  {5618, 5633, 5599},
  {5518, 5499, 5645},
  {5600, 5645, 5499},
  {6445, 5600, 5499},
  {6064, 6445, 5499},
  {5619, 5571, 5671},
  {5648, 5606, 5519},
  {5879, 5585, 5885},
  {5623, 5885, 5587},
  {5624, 5635, 5625},
  {5649, 5557, 5652},
  {5674, 5585, 5651},
  {5588, 5702, 5651},
  {5471, 5594, 5702},
  {5636, 5627, 5591},
  {5591, 5592, 5593},
  {5608, 5610, 5609},
  {5594, 5628, 5705},
  {5628, 5594, 5612},
  {5628, 5630, 5629},
  {5630, 5628, 5612},
  {5630, 5612, 5631},
  {5630, 5631, 5658},
  {5631, 5566, 5633},
  {5631, 5612, 5566},
  {5642, 5614, 5613},
  {5615, 5614, 5642},
  {5640, 5544, 5597},
  {5640, 5632, 5544},
  {5618, 5603, 5633},
  {5518, 5645, 5684},
  {5683, 5603, 5619},
  {5518, 5684, 5646},
  {5646, 5634, 5601},
  {5634, 5647, 5601},
  {5619, 5671, 5683},
  {5574, 5671, 5571},
  {5672, 5673, 5623},
  {5884, 5672, 5879},
  {5879, 5885, 5884},
  {5623, 5884, 5885},
  {5607, 5587, 5652},
  {5589, 6330, 5637},
  {5589, 5637, 5636},
  {5654, 6330, 5589},
  {5636, 5637, 5655},
  {5705, 5702, 5594},
  {5626, 5692, 5677},
  {5638, 5654, 5589},
  {5626, 5677, 5639},
  {5611, 5627, 5655},
  {5611, 5655, 5678},
  {5589, 5678, 5638},
  {5589, 5567, 5678},
  {5611, 5882, 6063},
  {5705, 5628, 5679},
  {5597, 6063, 5882},
  {5883, 5567, 5659},
  {5630, 5658, 5629},
  {5641, 5613, 5639},
  {5613, 5641, 5642},
  {5660, 5615, 5642},
  {5616, 5615, 5660},
  {5644, 5632, 5640},
  {5633, 5661, 5631},
  {5643, 5617, 5632},
  {5661, 5633, 5667},
  {5600, 5643, 5645},
  {5633, 5603, 5667},
  {5603, 5683, 5667},
  {5634, 5646, 5647},
  {5606, 5648, 5622},
  {5885, 5585, 5887},
  {5886, 5887, 5585},
  {5674, 5700, 5585},
  {5885, 5886, 5587},
  {5635, 5649, 5625},
  {5650, 5625, 5649},
  {5626, 5650, 5653},
  {5626, 5653, 5692},
  {5637, 5675, 5655},
  {5654, 5638, 5676},
  {5636, 5655, 5627},
  {5678, 5676, 5638},
  {5677, 5656, 5639},
  {5882, 5657, 5597},
  {5658, 5679, 5628},
  {5597, 5657, 5640},
  {5628, 5629, 5658},
  {5644, 5640, 5657},
  {5661, 5658, 5631},
  {5641, 5666, 5642},
  {5666, 5668, 5642},
  {5642, 5668, 5660},
  {5632, 5644, 5663},
  {5632, 5663, 5643},
  {5664, 5643, 5663},
  {5667, 5665, 5661},
  {5643, 5664, 5645},
  {5645, 5664, 5697},
  {5666, 5669, 5668},
  {5668, 5669, 5670},
  {5645, 5697, 5715},
  {5684, 5645, 5715},
  {5669, 5685, 5670},
  {5622, 5762, 5574},
  {5671, 5574, 5762},
  {5585, 5700, 5686},
  {5722, 5587, 5886},
  {5651, 5721, 5674},
  {5587, 5722, 5652},
  {5653, 5649, 5652},
  {5649, 5653, 5650},
  {5652, 5701, 5653},
  {5692, 5653, 5701},
  {5654, 5676, 5655},
  {5655, 5676, 5678},
  {5656, 5677, 5729},
  {5882, 5883, 5657},
  {5656, 5641, 5639},
  {5616, 5660, 5892},
  {5616, 5892, 5659},
  {5711, 5662, 5644},
  {5712, 5680, 5662},
  {5664, 5663, 5644},
  {5668, 5712, 5660},
  {5668, 5670, 5712},
  {5644, 5681, 5664},
  {5697, 5664, 5681},
  {5682, 5665, 5667},
  {5682, 5667, 5683},
  {5681, 5644, 5715},
  {5646, 5684, 5889},
  {5647, 5646, 5889},
  {5669, 5699, 5685},
  {5622, 5744, 5762},
  {5700, 5688, 5687},
  {5700, 5687, 5686},
  {5721, 5651, 5688},
  {5688, 5689, 5687},
  {5687, 5689, 5686},
  {5689, 5704, 5686},
  {5722, 5701, 5652},
  {5651, 5702, 5688},
  {5689, 5688, 5704},
  {5725, 5691, 5692},
  {5690, 5693, 5725},
  {5725, 5693, 5691},
  {5690, 5695, 5694},
  {5690, 5694, 5693},
  {5693, 5694, 5751},
  {5730, 5729, 5677},
  {5696, 5679, 5658},
  {5656, 5710, 5641},
  {5709, 5883, 5659},
  {5711, 5709, 5659},
  {5732, 5644, 5657},
  {5732, 5711, 5644},
  {5696, 5658, 5713},
  {5661, 5713, 5658},
  {5892, 5735, 5659},
  {5713, 5661, 5665},
  {5711, 5892, 5662},
  {5698, 5712, 5670},
  {5739, 5712, 5698},
  {5681, 5715, 5697},
  {5714, 5713, 5665},
  {5665, 5682, 5714},
  {5773, 5714, 5682},
  {5666, 5699, 5669},
  {5741, 5684, 5715},
  {5683, 5671, 5682},
  {5684, 5741, 5740},
  {5670, 5685, 5698},
  {5699, 5698, 5685},
  {5572, 5647, 6065},
  {5718, 5648, 5572},
  {5718, 5572, 5717},
  {5688, 5700, 5721},
  {5686, 5704, 5722},
  {5686, 5722, 5719},
  {5702, 5705, 5703},
  {5724, 5702, 5703},
  {5702, 5724, 5706},
  {5702, 5706, 5688},
  {5688, 5706, 5704},
  {5722, 5704, 5725},
  {5692, 5701, 5723},
  {5704, 5706, 5690},
  {5725, 5704, 5690},
  {5705, 5708, 5726},
  {5706, 5707, 5690},
  {5727, 5708, 5679},
  {5708, 5705, 5679},
  {5752, 5727, 5679},
  {5729, 5691, 5693},
  {5691, 5730, 5692},
  {5691, 5729, 5730},
  {5692, 5730, 5728},
  {5692, 5728, 5677},
  {5730, 5677, 5728},
  {5693, 5751, 5729},
  {5694, 5695, 5751},
  {5656, 5729, 5751},
  {5883, 5709, 5657},
  {5679, 5696, 5752},
  {5657, 5709, 5731},
  {5657, 5731, 5732},
  {5709, 5711, 5731},
  {5641, 5710, 5666},
  {5735, 5711, 5659},
  {5712, 5892, 5660},
  {5710, 5736, 5666},
  {5712, 5662, 5892},
  {5713, 5714, 5738},
  {5666, 5736, 5699},
  {5712, 5758, 5680},
  {5698, 5758, 5739},
  {5698, 5760, 5758},
  {5891, 5699, 5716},
  {5572, 5778, 5891},
  {5572, 6065, 5778},
  {5622, 5648, 5765},
  {5765, 5648, 5745},
  {5648, 5718, 5745},
  {5888, 5719, 5746},
  {5719, 5722, 5747},
  {5722, 5723, 5701},
  {5703, 5705, 5769},
  {5726, 5769, 5705},
  {5724, 5707, 5706},
  {5724, 5690, 5707},
  {5770, 5690, 5724},
  {5695, 5690, 5770},
  {5695, 5753, 5751},
  {5656, 5751, 5710},
  {5696, 5755, 5752},
  {5695, 5770, 5771},
  {5695, 5771, 5755},
  {5733, 5695, 5696},
  {5695, 5755, 5696},
  {5732, 5731, 5711},
  {5734, 5695, 5733},
  {5695, 5734, 5756},
  {5696, 5738, 5733},
  {5713, 5737, 5696},
  {5738, 5696, 5737},
  {5733, 5738, 5734},
  {5713, 5738, 5737},
  {5773, 5738, 5714},
  {5699, 5736, 5716},
  {5758, 5774, 5776},
  {5740, 5759, 5715},
  {5715, 5759, 5741},
  {5741, 5759, 5740},
  {5773, 5682, 5671},
  {5775, 5758, 5760},
  {5776, 5782, 5889},
  {5889, 5782, 5760},
  {5742, 5743, 5716},
  {5889, 5760, 5647},
  {5743, 5891, 5716},
  {5699, 5783, 5698},
  {5698, 5783, 5760},
  {5761, 6233, 6407},
  {5784, 6234, 5761},
  {5572, 5891, 5717},
  {5762, 5744, 5763},
  {5762, 5777, 5671},
  {5622, 5765, 5744},
  {5718, 5766, 5767},
  {5745, 5718, 5767},
  {5747, 5720, 5888},
  {5719, 5747, 5746},
  {5747, 5722, 5720},
  {5722, 5725, 5692},
  {5722, 5692, 5723},
  {5749, 5703, 5769},
  {5703, 5748, 5724},
  {5748, 5770, 5724},
  {5726, 5708, 5750},
  {5708, 5727, 5770},
  {5708, 5770, 5750},
  {5727, 5752, 5770},
  {5752, 5755, 5771},
  {5753, 5710, 5751},
  {5754, 5710, 5753},
  {5772, 5710, 5754},
  {5756, 5772, 5695},
  {5710, 5772, 5757},
  {5736, 5710, 5757},
  {5711, 5735, 5892},
  {5758, 5712, 5739},
  {5742, 5716, 5781},
  {5716, 5736, 5781},
  {5775, 5760, 5782},
  {5777, 5773, 5671},
  {5891, 6066, 5699},
  {5760, 5784, 5647},
  {5762, 5763, 5777},
  {5763, 5890, 5742},
  {5744, 5764, 5763},
  {5763, 5765, 5890},
  {5890, 5765, 5786},
  {5786, 5785, 5890},
  {5765, 5745, 5786},
  {5746, 5747, 5888},
  {5748, 5768, 5770},
  {5749, 5769, 5768},
  {5726, 5750, 5769},
  {5752, 5771, 5770},
  {5695, 5772, 5754},
  {5695, 5754, 5753},
  {5736, 5757, 5791},
  {5738, 5780, 5734},
  {5738, 5773, 5780},
  {5774, 5782, 5776},
  {5758, 5775, 5774},
  {5775, 5782, 5774},
  {5783, 5784, 5761},
  {5763, 5742, 5802},
  {5784, 6065, 5647},
  {5763, 5764, 5765},
  {5744, 5765, 5764},
  {5767, 5766, 5797},
  {5745, 5767, 5786},
  {5768, 5769, 5770},
  {5770, 5769, 5750},
  {5757, 5772, 5779},
  {5789, 5772, 5756},
  {5756, 5734, 5789},
  {5800, 5734, 5780},
  {5791, 5806, 5736},
  {5792, 5736, 5806},
  {5792, 5781, 5736},
  {5777, 5763, 6067},
  {5802, 5742, 5794},
  {5699, 6066, 6408},
  {5699, 6408, 5783},
  {5784, 5783, 6408},
  {5891, 5778, 5795},
  {5778, 6065, 5795},
  {6065, 5784, 5796},
  {5767, 5797, 5785},
  {5767, 5785, 5786},
  {5787, 5788, 5779},
  {5799, 5779, 5772},
  {5779, 5788, 5757},
  {5772, 5789, 5799},
  {5757, 6418, 5790},
  {5791, 5757, 5790},
  {5734, 5800, 5789},
  {5791, 5789, 5806},
  {5780, 5805, 5800},
  {5780, 5773, 5805},
  {5773, 5793, 5805},
  {5794, 5773, 5777},
  {5794, 5793, 5773},
  {5742, 5781, 5801},
  {5742, 5801, 5793},
  {5742, 5793, 5794},
  {5777, 6431, 5794},
  {5777, 6067, 6431},
  {5802, 5803, 5763},
  {5784, 6408, 5796},
  {5787, 5779, 5798},
  {6238, 6417, 5788},
  {5779, 5799, 6275},
  {6417, 6418, 5757},
  {6417, 5757, 5788},
  {6418, 5789, 5790},
  {5789, 5791, 5790},
  {5781, 5792, 5806},
  {5801, 5781, 5806},
  {5793, 5808, 5805},
  {5793, 5801, 5808},
  {5796, 5893, 6065},
  {5800, 5804, 5789},
  {5805, 5804, 5800},
  {5789, 5804, 5806},
  {5801, 5806, 5808},
  {5807, 6409, 5806},
  {5808, 5804, 5805},
  {5804, 5808, 5806},
  {5807, 5806, 6409},
  {5809,   13, 5812},
  {5809, 5812,   22},
  { 124, 5812, 5810},
  {  13, 5810, 5812},
  { 124, 6188,  302},
  {  14,    8,   10},
  {  14,   10,   15},
  {  14, 6188,    8},
  {   7, 5809,   12},
  {   3,   45,   47},
  { 105,   77,  210},
  { 210,   75,   76},
  { 210,   77,   75},
  { 210,   76,  102},
  {5814, 5815,  176},
  {5814,  176, 5813},
  {5813,  210, 5814},
  {5815, 5814, 6458},
  {5816,  181,  153},
  {5816,  153,  180},
  { 181,  152,  153},
  {  57,   71,   70},
  {5817,   85,  112},
  {5817,  248,  193},
  {5817,  193,   85},
  {5817,  194,  330},
  { 141,  232,  265},
  { 146,  149, 5818},
  { 338,  232,  307},
  {5905,  267,  232},
  {6340,  108,  154},
  {5819, 5899,  154},
  { 154,  184, 5819},
  { 234,  313,  273},
  {5820, 5821, 5822},
  {5821,  448, 5822},
  {5823,  450,  364},
  {5823, 5821,  450},
  {5823,  448, 5821},
  {5821, 5820,  450},
  { 594,  897, 5825},
  { 594,  449,  404},
  { 594,  404,  897},
  { 603,  897,  404},
  { 603,  404,  451},
  {5824, 5826,  671},
  { 446,  591,  445},
  {5824,  446,  592},
  {5824,  592, 5826},
  {5825, 5827,  594},
  { 897,  603,  946},
  {5827,  592,  706},
  {5827,  706,  594},
  {5829, 6309, 5830},
  {6068,  538,  537},
  {5830,  701, 5829},
  {5830, 6100,  701},
  {6309, 5829,  631},
  {5831, 5833, 5832},
  {5831,  984, 5833},
  {5831,  440,  984},
  {5831, 5834,  440},
  {5832, 5833,  634},
  {6258,  440, 5834},
  {5832,  668, 5831},
  {5834,  637,  539},
  {5834,  539, 6258},
  {5834, 5831,  637},
  {6258,  539,  349},
  { 506,  465,  562},
  { 506,  562,  614},
  { 614,  658,  506},
  { 666,  698,  586},
  {5835, 1082,  977},
  {1082, 6303, 1084},
  {5835,  977, 1031},
  {5835, 1083, 5836},
  {5835, 1031, 1083},
  {5836, 1083, 6303},
  { 978, 1039,  930},
  {1039,  978, 5837},
  { 888, 6267, 6356},
  {5837, 1084, 1039},
  {1252, 1198, 6268},
  {6097, 6134, 6156},
  {6097, 6156, 1427},
  {5838, 1368, 1476},
  {1368, 5838, 1578},
  {1368, 1578, 1421},
  {1560, 5839, 1461},
  {1560, 1508, 5839},
  {5839, 1508, 1709},
  {1461, 5839, 1712},
  {1508, 1767, 1709},
  {5839, 1709, 1712},
  {1639, 1492, 1542},
  {1745, 5946, 1685},
  {1745, 1685, 1981},
  {1981, 1685, 1688},
  {1981, 1802, 1990},
  {1981, 1990, 1983},
  {1983, 6069, 1981},
  {1981, 6069, 1745},
  {5840, 1983, 2044},
  {6069, 2044, 5841},
  {5841, 1984, 5842},
  {5841, 1986, 6069},
  {6346, 1984, 1915},
  {5842, 5843, 1986},
  {5842, 1984, 6346},
  {1984, 5841, 2046},
  {1644, 6349, 1745},
  {5946, 1745, 1744},
  {5846, 1959, 2120},
  {5846, 2120, 5847},
  {5848, 1896, 2216},
  {5849, 2519, 2520},
  {5850, 2852, 6102},
  {5850, 2792, 5852},
  {2792, 5851, 3070},
  {2792, 5850, 5851},
  {5852, 2905, 5850},
  {5852, 2798, 2905},
  {5851, 5981, 3070},
  {2792, 3070, 3120},
  {3120, 3070, 3124},
  {2873, 3042, 2939},
  {2939, 3042, 5853},
  {3042, 5977, 2938},
  {6206, 3188, 6091},
  {6206, 5855, 3188},
  {3042, 3084, 5853},
  {6347, 5853, 2935},
  {5853, 5855, 2935},
  {5855, 3086, 2935},
  {6207, 6098, 3087},
  {3042, 3041, 3084},
  {5857, 5856, 3057},
  {5858, 5859, 3104},
  {5856, 2886, 3056},
  {5856, 3056, 3057},
  {5858, 3241, 5859},
  {5859, 6383, 3104},
  {5859, 3202, 6383},
  {5860, 3303, 3164},
  {5861, 6126, 3153},
  {6124, 5985, 6125},
  {3125, 3359, 3210},
  {3327, 5862, 3328},
  {3327, 3330, 5862},
  {5862, 3540, 3492},
  {3489, 6448, 3492},
  {3631, 3749, 5863},
  {5997, 5863, 3748},
  {5863, 5997, 3748},
  {3588, 3812, 3708},
  {3708, 3812, 3921},
  {4024, 3727, 3986},
  {4024, 3986, 5894},
  {5864, 3841, 3839},
  {4024, 5864, 3839},
  {4196, 5864, 4069},
  {4196, 3841, 5864},
  {5864, 4024, 4069},
  {5865, 6078, 3957},
  {5865, 3957, 6078},
  {3957, 3961, 3962},
  {4144, 4143, 4142},
  {4144, 5866, 4367},
  {4144, 4368, 5866},
  {4145, 5866, 4368},
  {4144, 4199, 4406},
  {5866, 4145, 4367},
  {4364, 4474, 4404},
  {4364, 4365, 4474},
  {5867, 5868, 4592},
  {5868, 5867, 4420},
  {4287, 4420, 5867},
  {5869, 4441, 4640},
  {5869, 4640, 4686},
  {4614, 5869, 4686},
  {5870, 4374, 4580},
  {5870, 4622, 4621},
  {4580, 4582, 5870},
  {5871, 5872, 4692},
  {5872, 4647, 4692},
  {5873, 4619, 5874},
  {5873, 5872, 4619},
  {5873, 4647, 5872},
  {5873, 5874, 4647},
  {5021, 5875, 4860},
  {5875, 5049, 4860},
  {5021, 4860, 4928},
  {5021, 4933, 6430},
  {5876, 5220, 5160},
  {5876, 5336, 5367},
  {5251, 5876, 5160},
  {5201, 5227, 5173},
  {5201, 5173, 5153},
  {5431, 5429, 5430},
  {5497, 5429, 5431},
  {5878, 5526, 5527},
  {5878, 6280, 6343},
  {5878, 5527, 5526},
  {5878, 6343, 6280},
  {6280, 5504, 5529},
  {5504, 5556, 5529},
  {5880, 5585, 5879},
  {5879, 5525, 5880},
  {5672, 5623, 5879},
  {5582, 5524, 5580},
  {5582, 5880, 5524},
  {5611, 5678, 5881},
  {5881, 5678, 5567},
  {5881, 5567, 5882},
  {5881, 5882, 5611},
  {5567, 5883, 5882},
  {5672, 5884, 5673},
  {5885, 5887, 5886},
  {5884, 5623, 5673},
  {5888, 5886, 5686},
  {5888, 5722, 5886},
  {5888, 5720, 5722},
  {5888, 5686, 5719},
  {6331, 5654, 5655},
  {5721, 5700, 5674},
  {5644, 5662, 5680},
  {5644, 5740, 5715},
  {5776, 5680, 5758},
  {5644, 5776, 5889},
  {5889, 5684, 5644},
  {5644, 5684, 5740},
  {5890, 5743, 5742},
  {5890, 5891, 5743},
  {5891, 5890, 5717},
  {5717, 5890, 5718},
  {5890, 5766, 5718},
  {5890, 5797, 5766},
  {5890, 5785, 5797},
  {5749, 5748, 5703},
  {5749, 5768, 5748},
  {5893, 5795, 6065},
  {  14,   15,   37},
  { 105,   78,   77},
  { 180, 6458, 5816},
  {5815,  180,  179},
  {5825,  897, 5827},
  { 487,  445,  591},
  {5824,  671,  446},
  {5828, 5829,  536},
  {5829, 5828,  699},
  {5836, 6303, 1082},
  {5835, 5836, 1082},
  { 929, 6085,  930},
  {6069, 1644, 1745},
  {1688, 1802, 1981},
  {5848, 2120, 1896},
  {5848, 5847, 2120},
  {2873, 5977, 3042},
  {5854, 3087, 3086},
  {5854, 6207, 3087},
  {3296, 6383, 5989},
  {3312, 3316, 3176},
  {3312, 3438, 3316},
  {6017, 6070, 5895},
  {6070, 6017, 5895},
  {4577, 5871, 4692},
  {4734, 6200, 6201},
  {5429, 5497, 5404},
  {5686, 5886, 5585},
  {5815, 6458,  180},
  {5826,  592, 5827},
  {5841, 5842, 1986},
  {5854, 3086, 5855},
  {5680, 5776, 5644},
};

SVV_NAMESPACE_BEGIN

svvModel smoothwmsurf( "smoothwmsurf",
                       smoothwmsurf_vertices, smoothwmsurf_nvertices,
                       smoothwmsurf_indices, smoothwmsurf_nindices );

SVV_NAMESPACE_END

#endif /* SVV_SMOOTHWMSURF_H_ */
/*
 * End of: $Id: smoothwmsurf.h,v 1.1.1.1 2006/12/19 22:59:19 christianh Exp $.
 * 
 */
