/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: spheresurf.h,v 1.1.1.1 2006/12/19 22:59:28 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_SPHERESURF_H_
#  define SVV_SPHERESURF_H_
#  include "svvModel.h"

static GLsizei spheresurf_nvertices = 5918;
static GLsizei spheresurf_nindices  = 11832;
static GLsizei spheresurf_nedges    = 47328;

static GLfloat spheresurf_vertices[][6] =
{
  { 1.183981e-01, -7.732797e-01, -6.229128e-01,  1.206380e-01, -8.456787e-01, -5.395676e-01},
  { 1.838326e-01, -7.226207e-01, -6.663520e-01,  1.230099e-01, -8.480710e-01, -5.372561e-01},
  { 8.312618e-02, -8.598592e-01, -5.037183e-01,  1.091965e-01, -8.692865e-01, -5.032991e-01},
  { 6.797304e-03, -8.426721e-01, -5.383842e-01,  7.097377e-03, -8.457006e-01, -5.528086e-01},
  { 2.100163e-01, -7.928523e-01, -5.720825e-01,  1.282931e-01, -8.478220e-01, -5.344138e-01},
  { 7.781108e-03, -9.955688e-01, -9.371384e-02,  9.101355e-02, -8.986570e-01, -4.527582e-01},
  { 1.163298e-02, -9.891812e-01, -1.462368e-01,  8.863245e-02, -8.990142e-01, -4.550218e-01},
  { 1.715144e-01, -8.082353e-01, -5.633282e-01,  1.328190e-01, -8.628497e-01, -5.086340e-01},
  { 1.077918e-01, -9.279453e-01, -3.567891e-01,  1.062877e-01, -8.978453e-01, -4.510374e-01},
  {-2.376084e-03, -9.470086e-01, -3.211995e-01,  7.446534e-02, -8.974522e-01, -4.581398e-01},
  { 1.854564e-01, -8.027993e-01, -5.666739e-01,  1.522085e-01, -8.687226e-01, -4.951826e-01},
  { 1.972963e-01, -7.607352e-01, -6.183496e-01,  1.463413e-01, -8.657201e-01, -4.999723e-01},
  { 7.649706e-02, -8.691870e-01, -4.885306e-01,  7.394753e-02, -8.771189e-01, -4.960363e-01},
  { 8.010168e-02, -9.104725e-01, -4.057381e-01,  8.194406e-02, -9.216924e-01, -4.057409e-01},
  { 3.036733e-02, -9.212026e-01, -3.878962e-01,  3.709876e-02, -9.300773e-01, -3.929838e-01},
  { 4.701699e-02, -9.147595e-01, -4.012537e-01,  5.212504e-02, -9.240014e-01, -4.054147e-01},
  { 1.614496e-01, -8.299873e-01, -5.339056e-01,  1.794212e-01, -8.430415e-01, -5.278406e-01},
  {-5.492710e-02, -8.389571e-01, -5.414184e-01, -5.797811e-02, -8.483309e-01, -5.457374e-01},
  { 2.022989e-02, -8.581746e-01, -5.129591e-01,  1.853847e-02, -8.655795e-01, -5.208509e-01},
  {-3.764252e-02, -8.555475e-01, -5.163540e-01, -4.158990e-02, -8.612735e-01, -5.266257e-01},
  {-3.782393e-02, -8.233473e-01, -5.662760e-01, -3.761052e-02, -8.342432e-01, -5.687534e-01},
  { 1.479238e-01, -8.126171e-01, -5.637128e-01,  1.594104e-01, -8.202885e-01, -5.679570e-01},
  { 8.641306e-02, -8.299418e-01, -5.511165e-01,  8.015481e-02, -8.335999e-01, -5.652834e-01},
  { 1.984049e-02, -8.176258e-01, -5.754081e-01,  1.271977e-02, -8.283568e-01, -5.801826e-01},
  { 7.838371e-02, -9.363684e-01, -3.421550e-01,  8.203931e-02, -9.452251e-01, -3.473844e-01},
  { 2.046491e-01, -8.818545e-01, -4.247957e-01,  2.002928e-01, -8.891388e-01, -4.360905e-01},
  { 2.134114e-01, -8.667856e-01, -4.507087e-01,  2.287035e-01, -8.619707e-01, -4.749335e-01},
  { 1.713626e-01, -8.805093e-01, -4.419709e-01,  1.733751e-01, -8.888284e-01, -4.480899e-01},
  { 1.181262e-01, -8.975888e-01, -4.247124e-01,  1.235235e-01, -8.980688e-01, -4.461755e-01},
  { 6.129869e-02, -9.048425e-01, -4.213105e-01,  4.830847e-02, -9.065560e-01, -4.434856e-01},
  { 1.290584e-01, -8.782675e-01, -4.604240e-01,  1.559102e-01, -8.814123e-01, -4.686826e-01},
  { 6.784704e-02, -8.451762e-01, -5.301641e-01,  7.158861e-02, -8.516601e-01, -5.388955e-01},
  { 7.525751e-02, -8.095132e-01, -5.822582e-01,  1.010642e-01, -8.118817e-01, -5.935004e-01},
  { 4.460910e-02, -8.097543e-01, -5.850709e-01,  4.033936e-02, -8.006025e-01, -6.150342e-01},
  { 2.814405e-02, -9.449388e-01, -3.260344e-01,  2.835844e-02, -9.528935e-01, -3.347321e-01},
  { 1.087577e-01, -9.136798e-01, -3.916132e-01,  1.017494e-01, -9.220277e-01, -4.004617e-01},
  {-1.018391e-01, -8.160856e-01, -5.688875e-01, -9.702574e-02, -8.286108e-01, -5.699524e-01},
  { 2.027882e-01, -8.209903e-01, -5.337152e-01,  1.976759e-01, -8.250088e-01, -5.487673e-01},
  { 1.344550e-01, -8.074231e-01, -5.744474e-01,  1.284928e-01, -8.159671e-01, -5.818480e-01},
  { 5.134415e-02, -7.301338e-01, -6.813725e-01,  5.242666e-02, -7.413158e-01, -6.845159e-01},
  { 5.200564e-01, -8.540689e-01,  1.037530e-02,  1.553631e-01, -9.508197e-01, -3.044045e-01},
  { 4.193950e-01, -9.038201e-01, -8.495317e-02,  1.512488e-01, -9.540719e-01, -3.002276e-01},
  { 2.509703e-01, -9.285443e-01, -2.735315e-01,  1.672199e-01, -9.422168e-01, -3.242272e-01},
  { 1.330447e-01, -9.245842e-01, -3.569919e-01,  1.290042e-01, -9.365451e-01, -3.565091e-01},
  { 1.622647e-01, -7.813793e-01, -6.025916e-01,  1.679998e-01, -7.990057e-01, -5.951694e-01},
  {-6.391907e-02, -8.708575e-01, -4.873618e-01, -6.444142e-02, -8.776098e-01, -4.964916e-01},
  {-1.462889e-01, -7.886084e-01, -5.972406e-01, -1.478505e-01, -7.916308e-01, -6.101774e-01},
  {-1.108563e-01, -7.781540e-01, -6.182130e-01, -1.113600e-01, -7.821015e-01, -6.298988e-01},
  { 1.872092e-01, -9.161678e-01, -3.543858e-01,  1.761667e-01, -9.289479e-01, -3.562019e-01},
  {-9.634153e-03, -9.357173e-01, -3.526192e-01, -8.223005e-03, -9.453236e-01, -3.565823e-01},
  {-7.864287e-02, -9.302301e-01, -3.584512e-01, -6.253734e-02, -9.410457e-01, -3.624589e-01},
  {-3.452427e-01, -9.350397e-01, -8.067434e-02, -1.345397e-01, -9.444221e-01, -3.364569e-01},
  {-2.899747e-01, -9.288781e-01, -2.304345e-01, -1.428853e-01, -9.389881e-01, -3.445841e-01},
  { 2.724544e-01, -7.935558e-01, -5.440934e-01,  2.836018e-01, -7.972101e-01, -5.521672e-01},
  {-9.438632e-02, -9.288605e-01, -3.582030e-01, -1.108182e-01, -9.320894e-01, -3.738748e-01},
  { 2.540011e-01, -8.297684e-01, -4.969586e-01,  2.529982e-01, -8.300884e-01, -5.175003e-01},
  { 2.289199e-01, -8.048126e-01, -5.476060e-01,  2.221026e-01, -8.182387e-01, -5.495608e-01},
  {-1.280316e-01, -8.368229e-01, -5.322927e-01, -1.154682e-01, -8.511657e-01, -5.326458e-01},
  { 1.988166e-01, -7.913144e-01, -5.781812e-01,  1.974325e-01, -8.026972e-01, -5.809979e-01},
  {-7.927550e-02, -7.952007e-01, -6.011416e-01, -7.537629e-02, -7.990409e-01, -6.137660e-01},
  { 2.982422e-02, -7.692986e-01, -6.381930e-01,  3.087053e-02, -7.825971e-01, -6.389477e-01},
  {-1.974101e-02, -7.385719e-01, -6.738855e-01,  7.521271e-03, -7.320215e-01, -6.963814e-01},
  { 2.716656e-01, -8.831037e-01, -3.825254e-01,  2.111343e-01, -9.336276e-01, -3.234514e-01},
  { 2.540294e-01, -9.539864e-01, -1.593078e-01,  1.320483e-01, -9.626476e-01, -2.770021e-01},
  {-2.411435e-01, -9.556791e-01, -1.689006e-01, -1.308023e-01, -9.454476e-01, -3.314706e-01},
  {-4.338007e-02, -8.817806e-01, -4.696606e-01, -1.295129e-02, -9.153493e-01, -4.275790e-01},
  {-6.694007e-03, -8.956267e-01, -4.447561e-01, -3.305865e-03, -9.031639e-01, -4.529240e-01},
  { 2.449458e-01, -7.730647e-01, -5.851260e-01,  2.483247e-01, -7.803259e-01, -5.918520e-01},
  { 9.752341e-03, -8.779289e-01, -4.786917e-01,  3.358218e-03, -8.902374e-01, -4.778312e-01},
  {-1.143037e-01, -6.421417e-01, -7.580163e-01, -3.948987e-02, -8.030092e-01, -6.119428e-01},
  {-1.871154e-02, -7.228941e-01, -6.907054e-01, -2.005016e-02, -8.007804e-01, -6.157973e-01},
  {-1.037025e-01, -5.154624e-01, -8.506141e-01, -2.919181e-02, -8.028013e-01, -6.144441e-01},
  { 9.132002e-02, -7.512606e-01, -6.536575e-01,  8.490644e-02, -7.503008e-01, -6.713417e-01},
  {-6.292873e-02, -7.611752e-01, -6.454861e-01, -6.796246e-02, -7.778379e-01, -6.427829e-01},
  {-3.596458e-02, -7.725537e-01, -6.339301e-01, -6.879395e-02, -7.680603e-01, -6.528462e-01},
  {-9.079164e-02, -7.499467e-01, -6.552381e-01, -8.689732e-02, -7.580254e-01, -6.623468e-01},
  {-6.295037e-02, -7.484524e-01, -6.601942e-01, -6.248033e-02, -7.564663e-01, -6.668751e-01},
  {-1.303858e-01, -7.638922e-01, -6.320351e-01, -7.626987e-02, -7.516862e-01, -6.708264e-01},
  { 6.187851e-02,  7.361278e-01,  6.740081e-01, -6.118261e-02, -7.465249e-01, -6.780966e-01},
  { 4.212998e-02,  7.837521e-01,  6.196432e-01, -6.096098e-02, -7.470421e-01, -6.775467e-01},
  {-6.045234e-02, -7.414444e-01, -6.682856e-01, -5.903434e-02, -7.466878e-01, -6.781076e-01},
  {-6.966081e-02, -7.343253e-01, -6.752138e-01, -6.426647e-02, -7.475976e-01, -6.766279e-01},
  { 6.632623e-02, -9.587261e-01, -2.764871e-01,  6.238040e-02, -9.713632e-01, -2.709577e-01},
  { 8.179463e-03, -9.617584e-01, -2.737773e-01,  1.746594e-02, -9.698930e-01, -2.825912e-01},
  { 1.569988e-01, -9.044619e-01, -3.966106e-01,  1.619990e-01, -9.174949e-01, -3.909194e-01},
  {-7.654819e-02, -9.525506e-01, -2.945974e-01, -6.941557e-02, -9.597077e-01, -3.082153e-01},
  {-1.040713e-01, -9.437057e-01, -3.139886e-01, -1.170224e-01, -9.531903e-01, -3.139864e-01},
  {-1.691670e-01, -9.186567e-01, -3.570046e-01, -1.617253e-01, -9.292399e-01, -3.622309e-01},
  {-7.073598e-02, -8.794563e-01, -4.706941e-01, -7.475702e-02, -8.909685e-01, -4.705758e-01},
  {-2.515888e-01, -8.232704e-01, -5.088506e-01, -1.430475e-01, -8.629109e-01, -5.078925e-01},
  {-1.722631e-01, -7.587968e-01, -6.281344e-01, -1.722642e-01, -7.609885e-01, -6.419324e-01},
  {-1.149620e-01,  9.914591e-01,  6.158328e-02, -5.644239e-02, -7.668360e-01, -6.567279e-01},
  {-2.857664e-01, -4.795060e-01, -8.297058e-01, -6.108366e-02, -7.672168e-01, -6.546026e-01},
  {-2.853121e-02, -7.560539e-01, -6.538872e-01, -4.856131e-02, -7.651922e-01, -6.580125e-01},
  {-4.858357e-02, -7.339056e-01, -6.775119e-01, -5.258258e-02, -7.613256e-01, -6.621752e-01},
  {-1.148266e-01, -7.370154e-01, -6.660504e-01, -1.023435e-01, -7.504725e-01, -6.687105e-01},
  {-2.083275e-02, -7.548289e-01, -6.555908e-01, -5.174236e-02, -7.549861e-01, -6.694598e-01},
  {-4.548408e-02, -7.389971e-01, -6.721715e-01, -5.736786e-02, -7.617390e-01, -6.613019e-01},
  {-3.168202e-01, -8.123077e-01, -4.896747e-01, -6.663428e-02, -7.614725e-01, -6.607397e-01},
  {-1.185795e-01, -6.510343e-01,  7.497288e-01, -5.998404e-02, -7.610498e-01, -6.618630e-01},
  {-5.274669e-01, -5.006787e-01,  6.863669e-01, -9.259982e-02, -7.552401e-01, -6.647515e-01},
  {-7.245583e-02, -6.987964e-01, -7.116417e-01, -9.513265e-02, -7.542664e-01, -6.654990e-01},
  {-4.689397e-02, -7.306743e-01, -6.811138e-01, -5.508967e-02, -7.464408e-01, -6.787114e-01},
  {-5.770652e-02, -7.438495e-01, -6.658514e-01, -5.619516e-02, -7.567808e-01, -6.670701e-01},
  { 5.069965e-01, -7.416450e-01, -4.392235e-01,  2.338333e-01, -9.363689e-01, -2.989892e-01},
  { 1.973874e-01, -9.548521e-01, -2.220264e-01,  1.937313e-01, -9.675086e-01, -2.173784e-01},
  { 1.742856e-01, -9.576331e-01, -2.292671e-01,  1.918235e-01, -9.683484e-01, -2.153211e-01},
  { 1.693902e-01, -9.620608e-01, -2.138834e-01,  1.885321e-01, -9.695562e-01, -2.127781e-01},
  { 1.636658e-01, -9.495753e-01, -2.674327e-01,  1.786469e-01, -9.574732e-01, -2.689952e-01},
  { 2.460071e-01, -9.136795e-01, -3.235280e-01,  2.347668e-01, -9.277312e-01, -3.241282e-01},
  { 2.151333e-01, -8.948159e-01, -3.911805e-01,  2.052162e-01, -9.071810e-01, -3.946749e-01},
  { 3.071253e-01, -8.006940e-01, -5.143570e-01,  3.080579e-01, -8.084543e-01, -5.225173e-01},
  { 2.891343e-01, -8.208370e-01, -4.925729e-01,  3.005903e-01, -8.242036e-01, -5.011948e-01},
  {-5.013146e-02, -9.374274e-01, -3.445529e-01, -4.243678e-02, -9.234152e-01, -4.107183e-01},
  { 3.003063e-01, -7.605634e-01, -5.756384e-01,  3.020913e-01, -7.664942e-01, -5.848854e-01},
  {-1.559543e-01, -9.071754e-01, -3.907827e-01, -1.541342e-01, -9.205495e-01, -3.868908e-01},
  {-3.108617e-01, -8.176323e-01, -4.846055e-01, -1.471623e-01, -8.640751e-01, -5.025654e-01},
  {-1.717405e-01, -8.052019e-01, -5.675870e-01, -1.904917e-01, -8.151414e-01, -5.657843e-01},
  { 1.172627e-01, -7.747893e-01, -6.212496e-01,  1.217878e-01, -7.722406e-01, -6.400567e-01},
  {-3.832379e-02, -7.840716e-01, -6.194860e-01, -3.680967e-02, -7.877684e-01, -6.316040e-01},
  { 1.557433e-01, -7.344735e-01, -6.605246e-01,  1.499363e-01, -7.422279e-01, -6.703368e-01},
  {-3.439779e-02, -7.285345e-01, -6.841450e-01, -2.900469e-02, -7.191489e-01, -7.091137e-01},
  { 1.522933e-01, -6.784267e-01, -7.187099e-01,  1.372267e-01, -6.852863e-01, -7.296666e-01},
  { 1.078853e-01, -7.061727e-01, -6.997720e-01,  1.200566e-01, -7.186677e-01, -6.999745e-01},
  { 3.719952e-01, -8.552687e-01, -3.607425e-01,  2.351848e-01, -9.384723e-01, -2.952733e-01},
  { 2.047965e-02, -9.093743e-01, -4.154743e-01,  1.079012e-01, -9.734954e-01, -2.480334e-01},
  {-3.098610e-02, -9.577316e-01, -2.859896e-01, -3.591142e-02, -9.670979e-01, -2.903211e-01},
  { 3.588977e-01, -8.556179e-01, -3.729748e-01,  3.047635e-01, -8.494959e-01, -4.542446e-01},
  { 3.275901e-01, -7.787029e-01, -5.350763e-01,  3.237939e-01, -7.907815e-01, -5.391525e-01},
  {-1.244012e-02, -9.843597e-01, -1.757303e-01, -5.267050e-02, -9.238384e-01, -4.057134e-01},
  {-5.695350e-02, -9.356500e-01, -3.483035e-01, -7.310603e-02, -9.255413e-01, -3.986018e-01},
  {-2.261414e-01, -9.093962e-01, -3.490826e-01, -2.266731e-01, -9.161282e-01, -3.608053e-01},
  { 2.505224e-01, -8.079852e-01, -5.332902e-01,  2.803429e-01, -7.469847e-01, -6.199072e-01},
  {-1.559647e-01, -8.947809e-01, -4.183805e-01, -1.455784e-01, -9.053333e-01, -4.243023e-01},
  {-1.912047e-01, -8.277913e-01, -5.274488e-01, -1.926438e-01, -8.380103e-01, -5.305479e-01},
  {-2.917747e-01, -8.057325e-01, -5.154247e-01, -1.532702e-01, -8.692526e-01, -4.916933e-01},
  {-1.728892e-01, -8.582470e-01, -4.832405e-01, -1.730136e-01, -8.636798e-01, -4.949519e-01},
  { 1.856047e-01, -7.155938e-01, -6.734066e-01,  1.822604e-01, -7.193089e-01, -6.857391e-01},
  {-1.542777e-01, -7.422389e-01, -6.521347e-01, -1.594418e-01, -7.365445e-01, -6.743854e-01},
  { 2.518813e-02, -7.035124e-01, -7.102365e-01,  2.444161e-02, -7.015920e-01, -7.266575e-01},
  { 1.914722e-01, -9.795683e-01, -6.151679e-02,  1.851754e-01, -9.903916e-01, -7.544468e-02},
  { 3.802970e-01, -8.658971e-01, -3.249561e-01,  2.454800e-01, -9.407905e-01, -2.747946e-01},
  { 2.450821e-01, -9.021487e-01, -3.550529e-01,  2.486387e-01, -9.147599e-01, -3.496470e-01},
  { 2.627410e-01, -8.804441e-01, -3.946966e-01,  2.739528e-01, -8.876166e-01, -3.976436e-01},
  {-4.673042e-02, -8.570202e-01, -5.131595e-01,  9.097228e-02, -9.788973e-01, -2.383517e-01},
  {-4.427299e-01, -8.728605e-01, -2.051943e-01, -4.380004e-01, -8.834888e-01, -2.201166e-01},
  {-4.352798e-01, -8.654091e-01, -2.481903e-01, -4.417305e-01, -8.776891e-01, -2.353389e-01},
  { 3.114193e-01, -8.292045e-01, -4.641530e-01,  3.258001e-01, -8.286258e-01, -4.775943e-01},
  {-1.982267e-01, -9.275391e-01, -3.168242e-01, -2.140732e-01, -9.348806e-01, -3.178412e-01},
  { 3.252565e-01, -7.310421e-01, -5.998213e-01,  3.160158e-01, -7.417304e-01, -6.089613e-01},
  {-8.471378e-02, -9.038731e-01, -4.193290e-01, -8.396563e-02, -9.139429e-01, -4.252290e-01},
  { 1.965076e-01, -8.849732e-01, -4.221460e-01,  2.372800e-01, -7.511648e-01, -6.327024e-01},
  { 1.954889e-01, -8.074838e-01, -5.565555e-01,  2.070017e-01, -7.538808e-01, -6.400595e-01},
  { 2.478622e-01, -6.793917e-01, -6.906456e-01,  2.473705e-01, -6.965356e-01, -6.888465e-01},
  {-2.211210e-01, -7.969351e-01, -5.621389e-01, -2.191452e-01, -8.052636e-01, -5.695436e-01},
  {-2.317172e-02, -6.853395e-01, -7.278550e-01, -2.362145e-02, -6.879354e-01, -7.396258e-01},
  {-1.299013e-01, -6.962586e-01, -7.059388e-01, -1.434165e-01, -7.083133e-01, -7.061026e-01},
  { 2.412235e-01, -9.692814e-01, -4.800847e-02,  2.376220e-01, -9.817149e-01, -2.509150e-02},
  { 3.191714e-01, -9.469501e-01, -3.761661e-02,  3.091112e-01, -9.612780e-01, -3.541918e-02},
  { 2.554022e-01, -9.381852e-01, -2.336198e-01,  2.443256e-01, -9.524460e-01, -2.324021e-01},
  { 1.241208e-01, -9.766270e-01, -1.754815e-01,  1.156649e-01, -9.870318e-01, -1.823350e-01},
  {-1.270546e-01, -8.057318e-01, -5.784923e-01,  8.442599e-02, -9.788811e-01, -2.356274e-01},
  { 2.370900e-01, -8.870134e-01, -3.962266e-01,  2.449000e-01, -9.003795e-01, -3.875576e-01},
  {-1.481151e-01, -9.464002e-01, -2.870339e-01, -1.573263e-01, -9.565000e-01, -2.849714e-01},
  {-2.151045e-01, -8.982893e-01, -3.831533e-01, -2.131692e-01, -9.067430e-01, -3.914439e-01},
  { 2.825951e-01, -6.668371e-01, -6.895422e-01,  2.884492e-01, -6.737261e-01, -6.955248e-01},
  { 2.817045e-01, -6.717951e-01, -6.850795e-01,  2.869708e-01, -6.754436e-01, -6.944698e-01},
  { 2.816983e-01, -6.612969e-01, -6.952211e-01,  2.884006e-01, -6.724485e-01, -6.967803e-01},
  {-1.292612e-01, -8.764127e-01, -4.638885e-01, -1.309287e-01, -8.898842e-01, -4.602369e-01},
  { 2.471598e-01, -7.110369e-01, -6.582846e-01,  2.540195e-01, -7.076056e-01, -6.750051e-01},
  {-1.946167e-01, -8.401482e-01, -5.062366e-01, -2.115223e-01, -8.472511e-01, -5.082099e-01},
  { 2.098839e-01, -6.495365e-01, -7.307879e-01,  2.037048e-01, -6.575176e-01, -7.396204e-01},
  {-2.151486e-01, -7.636775e-01, -6.086935e-01, -2.199546e-01, -7.654369e-01, -6.217564e-01},
  {-2.172368e-01, -7.301294e-01, -6.478574e-01, -2.171629e-01, -7.347528e-01, -6.586607e-01},
  { 3.340660e-02, -6.674107e-01, -7.439402e-01,  2.510140e-02, -6.829376e-01, -7.441951e-01},
  {-1.864657e-01, -6.809589e-01, -7.081847e-01, -1.866727e-01, -6.965142e-01, -7.089678e-01},
  { 7.056736e-02, -6.989756e-01, -7.116554e-01,  7.428000e-02, -6.981873e-01, -7.265519e-01},
  { 9.001192e-02, -6.747421e-01, -7.325442e-01,  9.377003e-02, -6.829342e-01, -7.386944e-01},
  { 2.776482e-01, -9.604105e-01, -2.287147e-02,  2.874168e-01, -9.697013e-01, -1.944151e-02},
  { 1.466818e-01, -9.874869e-01, -5.791405e-02,  1.541823e-01, -9.968080e-01, -5.880662e-02},
  { 7.760999e-02, -9.832448e-01, -1.649435e-01,  7.890505e-02, -9.923236e-01, -1.729844e-01},
  { 2.262587e-02, -9.718096e-01, -2.346788e-01,  1.471760e-02, -9.842999e-01, -2.275782e-01},
  {-2.731499e-01, -8.938623e-01, -3.555266e-01, -2.773578e-01, -9.053044e-01, -3.526299e-01},
  {-7.533851e-02, -7.202916e-01, -6.895681e-01, -7.871542e-02, -7.108859e-01, -7.136546e-01},
  {-2.316998e-01, -7.621999e-01, -6.044556e-01, -1.837854e-01, -6.796728e-01, -7.246547e-01},
  {-2.869423e-01, -8.320239e-01, -4.747635e-01, -1.882392e-01, -6.774527e-01, -7.268525e-01},
  {-3.359985e-01,  9.411319e-01, -3.709279e-02,  3.428582e-01, -9.492174e-01,  4.790101e-02},
  {-4.273289e-01, -1.769010e-01, -8.866206e-01,  3.435320e-01, -9.489766e-01,  4.784330e-02},
  { 3.427979e-01, -9.391224e-01,  2.320943e-02,  3.459731e-01, -9.481362e-01,  4.690756e-02},
  { 3.331832e-01, -9.408997e-01,  6.080173e-02,  3.392252e-01, -9.503582e-01,  5.104532e-02},
  { 2.988913e-01, -9.518548e-01, -6.809090e-02,  3.010127e-01, -9.621362e-01, -6.741389e-02},
  { 2.197799e-01, -9.684666e-01, -1.173422e-01,  2.169265e-01, -9.812851e-01, -1.043096e-01},
  { 3.512970e-01, -9.340277e-01, -6.467392e-02,  3.632021e-01, -9.408751e-01, -6.082036e-02},
  { 1.672572e-01, -9.761136e-01, -1.386626e-01,  1.755297e-01, -9.863749e-01, -1.312316e-01},
  { 2.002154e-01, -9.651495e-01, -1.685239e-01,  2.112629e-01, -9.735348e-01, -1.686895e-01},
  {-4.726034e-01, -8.722455e-01, -1.258326e-01, -4.760065e-01, -8.821381e-01, -1.268760e-01},
  { 2.935471e-01, -8.985403e-01, -3.262750e-01,  2.933549e-01, -9.028173e-01, -3.460124e-01},
  { 5.831092e-02, -9.916223e-01, -1.152611e-01,  6.890601e-02, -1.000399e+00, -1.237315e-01},
  {-4.372979e-01, -8.854134e-01, -1.575236e-01, -4.359672e-01, -8.951069e-01, -1.719423e-01},
  { 3.062344e-02, -9.824935e-01, -1.837630e-01,  4.521748e-02, -9.924685e-01, -1.838930e-01},
  {-1.517640e-02, -9.328806e-01, -3.598657e-01,  5.216873e-02, -9.845471e-01, -2.209094e-01},
  {-3.935119e-01, -8.908811e-01, -2.268901e-01, -3.967384e-01, -9.004872e-01, -2.292819e-01},
  { 3.562364e-01, -7.991866e-01, -4.841451e-01,  3.635213e-01, -8.098164e-01, -4.826108e-01},
  { 3.705013e-01, -7.747403e-01, -5.123537e-01,  3.700506e-01, -7.786157e-01, -5.269576e-01},
  { 3.624391e-01, -7.486302e-01, -5.551493e-01,  3.711389e-01, -7.583111e-01, -5.556852e-01},
  { 3.764746e-01, -7.195265e-01, -5.835655e-01,  3.814981e-01, -7.284894e-01, -5.870500e-01},
  { 3.711017e-01, -7.044745e-01, -6.049786e-01,  3.758120e-01, -7.134284e-01, -6.088108e-01},
  { 2.955900e-01, -7.113355e-01, -6.376743e-01,  2.968516e-01, -7.172258e-01, -6.467845e-01},
  {-2.161402e-01, -8.857828e-01, -4.106973e-01, -2.149675e-01, -8.920050e-01, -4.230469e-01},
  { 2.967156e-01, -6.875486e-01, -6.627494e-01,  3.057069e-01, -6.915168e-01, -6.702331e-01},
  { 3.402785e-01, -6.959741e-01, -6.323216e-01,  3.515278e-01, -7.070510e-01, -6.303746e-01},
  { 2.720220e-01, -6.439493e-01, -7.150758e-01,  2.748817e-01, -6.490403e-01, -7.239140e-01},
  {-2.392201e-01, -8.244996e-01, -5.128101e-01, -2.404908e-01, -8.315774e-01, -5.210531e-01},
  { 2.329294e-01, -6.280118e-01, -7.425263e-01,  2.452938e-01, -6.387322e-01, -7.434490e-01},
  { 9.089513e-03, -7.658274e-01, -6.429819e-01, -2.574041e-01, -7.954618e-01, -5.673069e-01},
  {-3.394164e-01, -7.877129e-01, -5.141060e-01, -2.575515e-01, -8.067530e-01, -5.510626e-01},
  { 1.837991e-01, -6.203606e-01, -7.624767e-01,  1.681338e-01, -6.357925e-01, -7.670476e-01},
  {-6.503417e-02, -6.710983e-01, -7.385104e-01, -6.162532e-02, -6.885610e-01, -7.368478e-01},
  { 9.306137e-02, -6.448636e-01, -7.586109e-01,  1.073982e-01, -6.522537e-01, -7.641287e-01},
  {-1.078003e-01, -6.748973e-01, -7.299951e-01, -1.122703e-01, -6.783582e-01, -7.403265e-01},
  {-3.228109e-01, -6.499162e-01, -6.880422e-01, -2.024906e-01, -6.695188e-01, -7.291080e-01},
  {-2.111042e-01, -6.048026e-01, -7.678859e-01, -1.770451e-01, -6.640990e-01, -7.418602e-01},
  { 2.218043e-01, -9.715111e-01,  8.348062e-02,  2.250523e-01, -9.820195e-01,  7.646286e-02},
  { 2.452619e-01, -9.686714e-01,  3.901831e-02,  2.433653e-01, -9.797187e-01,  4.221910e-02},
  { 2.101860e-01, -9.773026e-01,  2.648773e-02,  2.003252e-01, -9.899141e-01,  2.823049e-02},
  { 2.872243e-01, -9.557574e-01,  6.348291e-02,  2.883593e-01, -9.665591e-01,  5.891627e-02},
  { 1.896392e-01, -9.817376e-01, -1.510744e-02,  1.966347e-01, -9.909980e-01, -1.071736e-02},
  { 1.538161e-01, -9.834524e-01, -9.571719e-02,  1.523437e-01, -9.928674e-01, -1.089153e-01},
  { 3.951975e-01, -9.145395e-01, -8.623560e-02,  3.869452e-01, -9.295020e-01, -8.462177e-02},
  { 1.194129e-01, -9.850416e-01, -1.242313e-01,  1.291868e-01, -9.954721e-01, -1.149014e-01},
  { 3.007393e-01, -8.830237e-01, -3.603124e-01,  3.055171e-01, -8.909124e-01, -3.657809e-01},
  { 2.949150e-01, -9.179639e-01, -2.652684e-01,  3.132151e-01, -9.225762e-01, -2.676005e-01},
  { 2.429168e-02, -9.872106e-01, -1.575600e-01,  1.863327e-02, -9.995711e-01, -1.461673e-01},
  { 3.187598e-01, -8.617854e-01, -3.946114e-01,  3.187726e-01, -8.756517e-01, -3.904868e-01},
  {-3.920240e-01, -9.024497e-01, -1.786106e-01, -3.953543e-01, -9.111173e-01, -1.854963e-01},
  {-2.411800e-02, -9.766140e-01, -2.136432e-01, -3.260808e-02, -9.870510e-01, -2.133566e-01},
  {-1.193859e-01, -9.604607e-01, -2.515200e-01, -1.273300e-01, -9.712340e-01, -2.476777e-01},
  {-3.976389e-01, -8.749210e-01, -2.763993e-01, -4.049169e-01, -8.829182e-01, -2.781127e-01},
  {-8.422879e-02, -9.685551e-01, -2.341081e-01, -9.223770e-02, -9.794051e-01, -2.304582e-01},
  {-2.015580e-01, -9.445883e-01, -2.590894e-01, -2.037238e-01, -9.513020e-01, -2.727136e-01},
  {-2.492166e-01, -9.228567e-01, -2.936436e-01, -2.461104e-01, -9.349597e-01, -2.934813e-01},
  { 3.206241e-01, -6.639245e-01, -6.755772e-01,  3.187119e-01, -6.752160e-01, -6.807137e-01},
  {-2.760075e-01, -8.788420e-01, -3.891743e-01, -2.764661e-01, -8.920754e-01, -3.855120e-01},
  { 2.011741e-01, -5.929724e-01, -7.796876e-01,  2.176437e-01, -6.100160e-01, -7.754843e-01},
  {-2.156283e-01, -7.466979e-01, -6.292429e-01, -2.606326e-01, -7.929245e-01, -5.711359e-01},
  {-2.903072e-01, -7.558487e-01, -5.868683e-01, -2.616385e-01, -7.888384e-01, -5.745718e-01},
  {-2.297982e-02, -6.521291e-01, -7.577597e-01, -2.391255e-02, -6.536059e-01, -7.701216e-01},
  { 2.655926e-02, -6.428913e-01, -7.654967e-01,  2.269189e-02, -6.471343e-01, -7.756048e-01},
  {-2.367161e-01, -6.874934e-01, -6.865263e-01, -2.418698e-01, -7.040092e-01, -6.831728e-01},
  {-1.191576e-01, -6.371030e-01, -7.615126e-01, -1.224074e-01, -6.478085e-01, -7.656744e-01},
  {-3.443847e-01, -4.597231e-01, -8.185682e-01, -1.825167e-01, -6.642976e-01, -7.390894e-01},
  { 2.552277e-01, -9.625664e-01,  9.124044e-02,  2.618949e-01, -9.716056e-01,  9.083869e-02},
  { 3.012904e-01, -9.533637e-01,  1.793923e-02,  2.879948e-01, -9.682637e-01,  1.957192e-02},
  { 2.419410e-01, -9.665796e-01, -8.478545e-02,  2.504597e-01, -9.753463e-01, -8.263216e-02},
  { 3.872801e-01, -9.219599e-01, -2.028294e-03,  3.848195e-01, -9.342239e-01, -7.893302e-04},
  { 4.200307e-01, -9.074467e-01,  1.070282e-02,  4.260723e-01, -9.159225e-01,  2.024874e-02},
  { 3.716200e-01, -9.281970e-01, -1.868059e-02,  3.774208e-01, -9.369071e-01, -2.489054e-02},
  { 4.005895e-01, -9.149165e-01, -4.955704e-02,  3.941013e-01, -9.288608e-01, -5.256587e-02},
  { 2.403655e-01, -9.536369e-01, -1.811108e-01,  2.476138e-01, -9.617312e-01, -1.860632e-01},
  { 3.273387e-01, -8.950965e-01, -3.027403e-01,  3.353345e-01, -9.017173e-01, -3.087366e-01},
  {-1.198154e-03, -9.927607e-01, -1.201038e-01,  2.369047e-03, -1.001464e+00, -1.338601e-01},
  {-4.796718e-01, -8.352913e-01, -2.687069e-01, -4.846344e-01, -8.423072e-01, -2.765795e-01},
  {-4.303847e-01, -8.486198e-01, -3.075928e-01, -4.356924e-01, -8.574610e-01, -3.094861e-01},
  {-1.574236e-01, -9.583542e-01, -2.382750e-01, -1.513137e-01, -9.682741e-01, -2.457678e-01},
  {-3.003932e-01, -9.020963e-01, -3.098165e-01, -3.018175e-01, -9.113052e-01, -3.150865e-01},
  {-2.058557e-01, -8.654777e-01, -4.566965e-01, -2.121740e-01, -8.779186e-01, -4.553132e-01},
  {-3.168147e-01, -8.812973e-01, -3.506331e-01, -3.253005e-01, -8.899627e-01, -3.507085e-01},
  { 2.241462e-01, -5.885575e-01, -7.767615e-01,  2.131334e-01, -5.737771e-01, -8.038773e-01},
  {-2.674047e-01, -7.516252e-01, -6.029546e-01, -2.679633e-01, -7.630731e-01, -6.056144e-01},
  { 1.078655e-01, -5.733815e-01, -8.121568e-01,  2.898214e-02, -5.940705e-01, -8.167629e-01},
  { 1.788600e-01, -9.802409e-01,  8.447918e-02,  1.945589e-01, -9.881307e-01,  8.124749e-02},
  { 1.449726e-01, -9.892620e-01,  1.853094e-02,  1.567985e-01, -9.980514e-01,  1.279910e-02},
  { 1.437766e-01, -9.893966e-01, -2.056050e-02,  1.471151e-01, -9.995682e-01, -8.762016e-03},
  { 2.725343e-01, -9.590346e-01, -7.731549e-02,  2.765946e-01, -9.683270e-01, -8.183718e-02},
  { 3.813231e-01, -9.223997e-01,  6.141305e-02,  3.870387e-01, -9.320948e-01,  4.755062e-02},
  { 3.285047e-01, -9.384192e-01, -1.070238e-01,  3.316910e-01, -9.489313e-01, -1.018362e-01},
  { 4.356897e-01, -8.989737e-01, -4.495230e-02,  4.670366e-01, -8.950604e-01, -4.008286e-02},
  {-4.454400e-01, -8.908573e-01, -8.919821e-02, -4.538602e-01, -8.988818e-01, -8.288468e-02},
  {-5.232469e-01, -8.440422e-01, -1.174965e-01, -5.326446e-01, -8.515595e-01, -1.094659e-01},
  { 3.070369e-01, -9.285631e-01, -2.085639e-01,  2.982631e-01, -9.405779e-01, -2.172840e-01},
  { 3.361848e-01, -9.089555e-01, -2.465354e-01,  3.404114e-01, -9.153302e-01, -2.591369e-01},
  { 3.624526e-01, -8.659310e-01, -3.446617e-01,  3.720236e-01, -8.711994e-01, -3.513867e-01},
  {-4.916268e-01, -8.434011e-01, -2.167436e-01, -5.086720e-01, -8.416429e-01, -2.318141e-01},
  {-3.721938e-01, -8.943470e-01, -2.482242e-01, -3.716428e-01, -9.060213e-01, -2.487091e-01},
  {-4.731060e-01, -8.255337e-01, -3.076765e-01, -4.748271e-01, -8.392178e-01, -3.018297e-01},
  {-3.860126e-01, -8.668931e-01, -3.154214e-01, -3.906315e-01, -8.734285e-01, -3.246214e-01},
  { 4.134586e-01, -6.822310e-01, -6.030032e-01,  4.249508e-01, -6.926625e-01, -6.004179e-01},
  {-2.548491e-01, -8.689987e-01, -4.241381e-01, -2.521881e-01, -8.804655e-01, -4.266540e-01},
  { 3.279077e-01, -6.407553e-01, -6.941968e-01,  3.300874e-01, -6.504056e-01, -6.991997e-01},
  { 3.763001e-01, -6.636117e-01, -6.465430e-01,  3.880780e-01, -6.706700e-01, -6.484314e-01},
  { 2.904582e-01, -6.137608e-01, -7.341196e-01,  2.950836e-01, -6.261102e-01, -7.360551e-01},
  { 2.530184e-01, -5.966328e-01, -7.615846e-01,  2.462950e-01, -5.984043e-01, -7.759613e-01},
  {-4.052559e-01, -7.528213e-01, -5.186789e-01, -4.035792e-01, -7.637103e-01, -5.241388e-01},
  {-6.671011e-02, -6.395365e-01, -7.658608e-01, -6.517505e-02, -6.442131e-01, -7.756293e-01},
  { 3.931861e-02, -6.240240e-01, -7.804154e-01,  4.510969e-02, -6.303762e-01, -7.883224e-01},
  {-2.711998e-01, -7.180576e-01, -6.409711e-01, -2.695135e-01, -7.222613e-01, -6.531122e-01},
  {-6.417446e-02, -5.622337e-01, -8.244846e-01, -6.194438e-02, -5.734528e-01, -8.295631e-01},
  { 1.615835e-01, -9.843804e-01,  6.989947e-02,  1.677521e-01, -9.935507e-01,  7.465043e-02},
  { 3.284378e-01, -9.403683e-01,  8.852170e-02,  3.200358e-01, -9.541121e-01,  9.003759e-02},
  { 1.294395e-01, -9.908772e-01,  3.752140e-02,  1.322133e-01, -1.000649e+00,  4.558288e-02},
  {-5.129267e-01, -8.554099e-01, -7.197363e-02, -5.144811e-01, -8.680714e-01, -6.927625e-02},
  { 4.639382e-01, -8.858193e-01,  9.238123e-03,  4.606696e-01, -8.992022e-01,  9.025528e-03},
  { 1.018296e-01, -9.926465e-01, -6.545006e-02,  8.860112e-02, -1.003939e+00, -7.149428e-02},
  { 2.613033e-01, -9.524056e-01, -1.569848e-01,  2.608433e-01, -9.624953e-01, -1.625505e-01},
  {-5.398920e-01, -8.307844e-01, -1.353283e-01, -5.461879e-01, -8.384916e-01, -1.394898e-01},
  {-4.909066e-01, -8.560053e-01, -1.620665e-01, -4.988027e-01, -8.649302e-01, -1.547224e-01},
  {-3.993924e-01, -9.099470e-01, -1.117238e-01, -4.090074e-01, -9.170645e-01, -1.120439e-01},
  { 3.631107e-01, -8.952339e-01, -2.582768e-01,  3.614897e-01, -9.067157e-01, -2.608705e-01},
  {-2.670710e-02, -9.852670e-01, -1.689248e-01, -2.975336e-02, -9.955537e-01, -1.698272e-01},
  { 3.593337e-01, -8.244758e-01, -4.371715e-01,  3.770651e-01, -8.274893e-01, -4.403940e-01},
  {-3.468439e-01, -9.175806e-01, -1.942812e-01, -3.477650e-01, -9.282755e-01, -1.954826e-01},
  { 4.130716e-01, -7.469310e-01, -5.210239e-01,  4.194457e-01, -7.533144e-01, -5.267335e-01},
  { 4.185601e-01, -7.132404e-01, -5.622236e-01,  4.198926e-01, -7.210435e-01, -5.697827e-01},
  {-3.504059e-01, -8.760052e-01, -3.314070e-01, -3.547223e-01, -8.872241e-01, -3.284136e-01},
  { 2.113785e-01, -5.320695e-01, -8.198909e-01,  2.106993e-01, -5.519344e-01, -8.196580e-01},
  {-2.940385e-01, -8.166038e-01, -4.966885e-01, -2.976768e-01, -8.190339e-01, -5.112967e-01},
  {-3.151455e-01, -7.802153e-01, -5.403215e-01, -3.283547e-01, -7.859226e-01, -5.438526e-01},
  { 1.271599e-01, -5.955303e-01, -7.932049e-01,  1.341274e-01, -6.134102e-01, -7.915811e-01},
  {-1.880157e-02, -6.154345e-01, -7.879638e-01, -2.997387e-02, -6.246203e-01, -7.936063e-01},
  { 9.302048e-02, -6.051681e-01, -7.906445e-01,  8.862949e-02, -6.138512e-01, -7.976175e-01},
  {-7.737375e-02, -6.026591e-01, -7.942389e-01, -8.394621e-02, -6.092758e-01, -8.016204e-01},
  {-2.672180e-02, -5.825989e-01, -8.123204e-01, -1.216233e-02, -5.885938e-01, -8.211396e-01},
  {-1.227459e-01, -6.002315e-01, -7.903516e-01, -1.305085e-01, -6.134763e-01, -7.921318e-01},
  {-1.541800e-01, -6.160526e-01, -7.724685e-01, -1.617474e-01, -6.163103e-01, -7.841284e-01},
  {-9.497420e-02, -5.640825e-01, -8.202384e-01, -8.547118e-02, -5.668649e-01, -8.319968e-01},
  {-2.141715e-01, -6.313748e-01, -7.453163e-01, -2.027782e-01, -6.332279e-01, -7.607630e-01},
  { 1.403879e-01, -9.686004e-01,  2.051941e-01,  1.409349e-01, -9.779644e-01,  2.111363e-01},
  { 8.614057e-02, -9.763036e-01,  1.985223e-01,  9.553201e-02, -9.838727e-01,  2.091003e-01},
  { 2.176980e-02, -9.686640e-01,  2.474191e-01,  1.735162e-02, -9.786186e-01,  2.507150e-01},
  { 1.960416e-01, -9.720042e-01,  1.295200e-01,  1.879339e-01, -9.860932e-01,  1.147064e-01},
  { 2.839049e-01, -9.515993e-01,  1.177142e-01,  2.873556e-01, -9.609594e-01,  1.218297e-01},
  { 1.055519e-01, -9.911395e-01,  8.063044e-02,  1.273361e-01, -1.000373e+00,  6.241113e-02},
  { 8.734275e-02, -9.961355e-01, -9.243985e-03,  7.418711e-02, -1.007645e+00, -1.613526e-03},
  { 2.856010e-01, -9.493874e-01, -1.307500e-01,  3.004472e-01, -9.555250e-01, -1.325255e-01},
  { 5.761744e-01, -8.171502e-01,  1.699584e-02,  4.937080e-01, -8.812475e-01, -2.277566e-02},
  { 5.452519e-02, -9.951097e-01, -8.236293e-02,  5.325965e-02, -1.006512e+00, -7.037096e-02},
  { 6.717803e-01, -7.385174e-01,  5.747345e-02,  4.979044e-01, -8.784013e-01, -3.696035e-02},
  { 7.194902e-01, -6.909740e-01,  6.991991e-02,  4.994751e-01, -8.784613e-01, -4.371951e-02},
  { 6.099765e-01, -7.919566e-01, -2.707910e-02,  5.046486e-01, -8.737203e-01, -5.297586e-02},
  { 4.633548e-01, -8.810511e-01, -9.513850e-02,  4.492853e-01, -8.987734e-01, -1.058863e-01},
  { 4.067912e-01, -9.056675e-01, -1.195295e-01,  4.085518e-01, -9.150662e-01, -1.288459e-01},
  {-5.281223e-01, -8.302096e-01, -1.784344e-01, -5.305892e-01, -8.436839e-01, -1.658903e-01},
  {-5.504923e-01, -8.089847e-01, -2.061604e-01, -5.565675e-01, -8.183925e-01, -2.032568e-01},
  {-5.276239e-01, -8.147547e-01, -2.403912e-01, -5.300475e-01, -8.250651e-01, -2.432378e-01},
  { 3.903978e-01, -8.563777e-01, -3.379449e-01,  3.970213e-01, -8.815883e-01, -2.933235e-01},
  { 3.907599e-01, -8.352247e-01, -3.869192e-01,  3.761706e-01, -8.502051e-01, -3.956136e-01},
  {-5.557628e-02, -9.883749e-01, -1.415143e-01, -6.142483e-02, -9.983323e-01, -1.428729e-01},
  {-4.449471e-01, -8.278444e-01, -3.416075e-01, -4.524027e-01, -8.335795e-01, -3.483189e-01},
  { 4.038433e-01, -7.787557e-01, -4.800524e-01,  4.115095e-01, -7.872025e-01, -4.814941e-01},
  { 3.554600e-01, -6.310799e-01, -6.894826e-01,  3.630877e-01, -6.419714e-01, -6.905839e-01},
  { 4.399889e-01, -6.442605e-01, -6.255702e-01,  4.440058e-01, -6.546838e-01, -6.285819e-01},
  {-3.404472e-01, -8.614566e-01, -3.768133e-01, -3.486926e-01, -8.673033e-01, -3.834698e-01},
  {-2.629234e-01, -8.489308e-01, -4.584625e-01, -2.691699e-01, -8.555753e-01, -4.651782e-01},
  { 2.872842e-01, -5.687178e-01, -7.707319e-01,  2.846037e-01, -5.786619e-01, -7.778284e-01},
  {-3.661891e-01, -7.768080e-01, -5.123231e-01, -3.652004e-01, -7.884136e-01, -5.156397e-01},
  { 1.659726e-01, -5.732607e-01, -8.023872e-01,  1.641418e-01, -5.693800e-01, -8.183690e-01},
  { 6.595356e-02, -6.069044e-01, -7.920336e-01,  6.364736e-02, -6.133224e-01, -8.004040e-01},
  {-1.301570e-01, -6.765096e-01, -7.248406e-01, -2.467669e-01, -6.546096e-01, -7.290049e-01},
  { 2.226076e-01, -5.308294e-01, -8.177200e-01,  2.168741e-02, -5.726969e-01, -8.321115e-01},
  { 1.218119e-01, -5.327458e-01, -8.374628e-01,  1.784107e-02, -5.657101e-01, -8.382310e-01},
  { 1.627650e-01, -9.699906e-01,  1.806263e-01,  1.506738e-01, -9.812945e-01,  1.876550e-01},
  { 1.666796e-01, -9.782463e-01,  1.234993e-01,  1.761072e-01, -9.874066e-01,  1.219457e-01},
  {-5.363898e-01, -8.438841e-01, -1.207043e-02, -5.351496e-01, -8.565506e-01, -2.797163e-02},
  { 3.864209e-02, -9.987679e-01, -3.113604e-02,  4.429949e-02, -1.009338e+00, -1.131410e-02},
  { 3.572919e-01, -9.261967e-01, -1.204248e-01,  3.619518e-01, -9.348359e-01, -1.262292e-01},
  {-4.235155e-01, -9.043499e-01, -5.278120e-02, -4.182270e-01, -9.178901e-01, -5.841037e-02},
  { 5.163275e-01, -8.543257e-01, -5.944433e-02,  5.303687e-01, -8.582730e-01, -5.422987e-02},
  { 3.311782e-01, -9.284651e-01, -1.681473e-01,  3.323854e-01, -9.377576e-01, -1.760433e-01},
  {-7.015543e-02, -9.921702e-01, -1.033274e-01, -4.968854e-02, -1.003258e+00, -1.088929e-01},
  {-3.554333e-01, -9.235811e-01, -1.437542e-01, -3.486840e-01, -9.363208e-01, -1.502393e-01},
  {-8.002085e-02, -9.804453e-01, -1.797881e-01, -8.550694e-02, -9.909109e-01, -1.778682e-01},
  { 4.160605e-01, -8.064699e-01, -4.201189e-01,  4.042497e-01, -8.165685e-01, -4.366487e-01},
  { 4.445443e-01, -7.542595e-01, -4.831904e-01,  4.338187e-01, -7.673312e-01, -4.938313e-01},
  { 4.457369e-01, -7.087314e-01, -5.468259e-01,  4.476914e-01, -7.231622e-01, -5.454128e-01},
  {-3.437445e-01, -8.948388e-01, -2.847863e-01, -3.438084e-01, -9.032547e-01, -2.945787e-01},
  { 4.593713e-01, -6.702733e-01, -5.828480e-01,  4.675143e-01, -6.699747e-01, -5.945012e-01},
  {-3.903501e-01, -8.489472e-01, -3.562522e-01, -3.978032e-01, -8.535295e-01, -3.661828e-01},
  {-3.399544e-01, -8.490400e-01, -4.044280e-01, -3.453180e-01, -8.601898e-01, -4.020942e-01},
  { 4.138629e-01, -6.345935e-01, -6.526933e-01,  4.248048e-01, -6.353549e-01, -6.608571e-01},
  {-4.409962e-01, -7.471135e-01, -4.973367e-01, -4.608043e-01, -7.433040e-01, -5.059733e-01},
  {-4.729106e-01, -7.069350e-01, -5.259264e-01, -4.722761e-01, -7.246789e-01, -5.221553e-01},
  { 3.225923e-01, -5.976393e-01, -7.340038e-01,  3.231781e-01, -5.901163e-01, -7.537805e-01},
  { 1.889865e-01, -5.194142e-01, -8.333625e-01,  1.762433e-01, -5.136206e-01, -8.533176e-01},
  {-3.282933e-01, -7.999186e-01, -5.023483e-01, -3.292575e-01, -8.017366e-01, -5.192878e-01},
  {-3.899611e-01, -7.395788e-01, -5.485923e-01, -3.791508e-01, -7.449859e-01, -5.675321e-01},
  {-4.300911e-01, -7.124223e-01, -5.545053e-01, -4.407409e-01, -7.170301e-01, -5.589870e-01},
  {-3.264376e-01, -7.620787e-01, -5.591731e-01, -3.367178e-01, -7.715909e-01, -5.586778e-01},
  {-3.496599e-01, -7.460105e-01, -5.667505e-01, -3.489224e-01, -7.614080e-01, -5.651225e-01},
  { 1.522940e-01, -5.474900e-01, -8.228374e-01,  1.539235e-01, -5.454824e-01, -8.364333e-01},
  {-9.447578e-02, -6.628351e-01, -7.427812e-01, -2.489820e-01, -6.513985e-01, -7.323879e-01},
  {-5.009343e-02, -5.417591e-01, -8.390397e-01, -4.837178e-02, -5.426375e-01, -8.509204e-01},
  {-1.431236e-01, -5.733779e-01, -8.066928e-01, -1.434585e-01, -5.713406e-01, -8.208826e-01},
  {-1.867052e-01, -5.933592e-01, -7.829853e-01, -1.866706e-01, -6.086488e-01, -7.850647e-01},
  { 1.979593e-01, -9.632670e-01,  1.814632e-01,  1.897377e-01, -9.750305e-01,  1.848563e-01},
  { 1.058343e-01, -9.614519e-01,  2.537899e-01,  1.031618e-01, -9.739934e-01,  2.529984e-01},
  { 1.539258e-01, -9.501516e-01,  2.711435e-01,  1.316965e-01, -9.695463e-01,  2.519752e-01},
  { 6.607927e-02, -9.780748e-01,  1.974918e-01,  7.335528e-02, -9.898081e-01,  1.890852e-01},
  { 3.555961e-02, -9.751679e-01,  2.185931e-01,  4.492027e-02, -9.875716e-01,  2.086590e-01},
  { 2.351326e-01, -9.613305e-01,  1.433747e-01,  2.337638e-01, -9.708978e-01,  1.535235e-01},
  { 3.262787e-01, -9.354858e-01,  1.356782e-01,  3.309400e-01, -9.458998e-01,  1.288871e-01},
  { 6.804881e-02, -9.972560e-01,  2.914980e-02,  7.014957e-02, -1.007484e+00,  3.015123e-02},
  {-4.236878e-01, -9.058065e-01, -1.755745e-03, -4.345362e-01, -9.120926e-01,  1.061196e-02},
  { 4.527543e-01, -8.895468e-01,  6.099100e-02,  4.438466e-01, -9.057569e-01,  5.888018e-02},
  {-5.707093e-01, -8.152742e-01, -9.807494e-02, -5.767461e-01, -8.239049e-01, -9.690632e-02},
  {-8.395471e-02, -9.899783e-01, -1.135542e-01,  1.464588e-02, -1.010077e+00, -5.416567e-02},
  {-1.908805e-01, -9.675408e-01, -1.656184e-01,  1.283630e-02, -1.008643e+00, -5.770007e-02},
  { 5.052475e-01, -8.580903e-01, -9.168419e-02,  5.141558e-01, -8.646994e-01, -9.382405e-02},
  {-1.079720e-01, -9.906181e-01, -8.377205e-02,  1.183788e-02, -1.008264e+00, -6.416944e-02},
  { 7.168954e-03, -9.914096e-01, -1.305973e-01, -1.325653e-02, -1.007852e+00, -7.009101e-02},
  { 5.517571e-01, -8.307486e-01, -7.362643e-02,  5.543027e-01, -8.402197e-01, -8.743387e-02},
  {-5.789232e-01, -8.033370e-01, -1.396340e-01, -5.825827e-01, -8.120635e-01, -1.483136e-01},
  { 4.164014e-01, -8.786510e-01, -2.336287e-01,  4.044527e-01, -8.925796e-01, -2.461345e-01},
  {-1.047655e-01, -9.848391e-01, -1.382612e-01, -1.024556e-01, -9.957392e-01, -1.373275e-01},
  {-5.212184e-01, -8.006472e-01, -2.954578e-01, -5.300491e-01, -8.054774e-01, -3.018313e-01},
  {-4.961823e-01, -8.030273e-01, -3.300763e-01, -4.994446e-01, -8.133652e-01, -3.314223e-01},
  {-3.023136e-01, -9.333414e-01, -1.935984e-01, -3.097592e-01, -9.433629e-01, -1.869903e-01},
  {-4.629770e-01, -8.119910e-01, -3.554193e-01, -4.757065e-01, -8.148353e-01, -3.613802e-01},
  {-1.296055e-01, -9.725397e-01, -1.933102e-01, -1.374739e-01, -9.827181e-01, -1.906267e-01},
  {-1.766338e-01, -9.633468e-01, -2.018995e-01, -1.715536e-01, -9.757995e-01, -1.983546e-01},
  {-2.914580e-01, -9.220517e-01, -2.547014e-01, -2.919376e-01, -9.323986e-01, -2.574017e-01},
  { 4.807398e-01, -6.262800e-01, -6.137285e-01,  4.829456e-01, -6.340919e-01, -6.209341e-01},
  { 3.767395e-01, -6.182708e-01, -6.897889e-01,  3.874320e-01, -6.230068e-01, -6.947127e-01},
  {-3.006418e-01, -8.476360e-01, -4.371814e-01, -3.034794e-01, -8.551125e-01, -4.444486e-01},
  { 2.072749e-01, -4.970581e-01, -8.425975e-01,  2.504554e-01, -5.489942e-01, -8.103970e-01},
  { 2.211231e-01, -5.114242e-01, -8.303914e-01,  1.896974e-01, -5.074234e-01, -8.532538e-01},
  {-2.502751e-02, -5.265629e-01, -8.497677e-01, -2.031058e-02, -5.359864e-01, -8.562520e-01},
  {-1.266856e-01, -5.368278e-01, -8.341264e-01, -1.262421e-01, -5.557542e-01, -8.343018e-01},
  {-8.494014e-02, -6.176646e-01, -7.818412e-01, -2.495271e-01, -6.395993e-01, -7.412859e-01},
  { 1.347416e-02, -9.565303e-01,  2.913215e-01,  1.625676e-02, -9.652765e-01,  2.980441e-01},
  { 7.199126e-02, -9.597030e-01,  2.716387e-01,  7.757571e-02, -9.672100e-01,  2.816759e-01},
  {-2.702249e-02, -9.668142e-01,  2.540474e-01, -2.738491e-02, -9.771391e-01,  2.555422e-01},
  { 8.905347e-02, -9.823731e-01,  1.643549e-01,  9.295624e-02, -9.931601e-01,  1.607697e-01},
  { 1.258851e-01, -9.829054e-01,  1.343496e-01,  1.186664e-01, -9.947057e-01,  1.316596e-01},
  {-4.806737e-01, -8.761795e-01,  3.552854e-02, -4.819156e-01, -8.884368e-01,  3.907255e-02},
  {-5.725327e-01, -8.198416e-01, -8.133158e-03, -5.754862e-01, -8.301820e-01, -2.143411e-02},
  {-5.708241e-01, -8.191912e-01, -5.555032e-02, -5.731786e-01, -8.302963e-01, -5.404167e-02},
  {-6.014969e-01, -7.984095e-01, -2.726735e-02, -6.092700e-01, -8.052477e-01, -3.481253e-02},
  { 4.194605e-01, -9.038128e-01,  8.470730e-02,  4.257033e-01, -9.122791e-01,  8.593682e-02},
  { 1.996685e-03, -9.996937e-01, -2.466826e-02, -1.139482e-03, -1.010308e+00, -1.141253e-02},
  { 3.702348e-01, -9.121289e-01, -1.759173e-01,  3.714741e-01, -9.253970e-01, -1.628153e-01},
  {-3.906884e-01, -9.194523e-01, -4.438812e-02, -4.014712e-01, -9.262754e-01, -4.101872e-02},
  { 5.519650e-01, -8.259400e-01, -1.147072e-01,  5.578727e-01, -8.342326e-01, -1.200151e-01},
  { 3.670698e-01, -9.067677e-01, -2.074416e-01,  3.835643e-01, -9.130744e-01, -2.000889e-01},
  {-3.526812e-01, -9.322465e-01, -8.082401e-02, -3.625761e-01, -9.394246e-01, -8.287683e-02},
  {-5.905561e-01, -7.856110e-01, -1.845501e-01, -5.907980e-01, -7.987816e-01, -1.837181e-01},
  {-5.859973e-01, -7.795136e-01, -2.212818e-01, -5.827293e-01, -7.944397e-01, -2.239176e-01},
  { 4.321420e-01, -8.604907e-01, -2.698316e-01,  4.324648e-01, -8.723828e-01, -2.697885e-01},
  {-3.147963e-01, -9.393119e-01, -1.363688e-01, -3.150000e-01, -9.492785e-01, -1.431597e-01},
  {-3.238492e-01, -9.164528e-01, -2.350233e-01, -3.248741e-01, -9.273750e-01, -2.351215e-01},
  {-4.889607e-01, -7.899356e-01, -3.700259e-01, -4.877217e-01, -8.055972e-01, -3.660457e-01},
  { 4.592605e-01, -7.234510e-01, -5.154594e-01,  4.652421e-01, -7.290248e-01, -5.224356e-01},
  {-2.103004e-01, -9.522410e-01, -2.213836e-01, -2.112326e-01, -9.645178e-01, -2.143296e-01},
  {-4.061293e-01, -8.294626e-01, -3.834717e-01, -4.169077e-01, -8.359005e-01, -3.851075e-01},
  { 3.982968e-01, -5.842783e-01, -7.070916e-01,  3.716015e-01, -6.016400e-01, -7.216706e-01},
  { 4.446568e-01, -6.056559e-01, -6.598948e-01,  4.513010e-01, -6.138925e-01, -6.635746e-01},
  { 4.667134e-01, -6.018553e-01, -6.480345e-01,  4.675825e-01, -6.137326e-01, -6.523550e-01},
  {-4.199830e-01, -7.731084e-01, -4.753080e-01, -4.271879e-01, -7.841382e-01, -4.727453e-01},
  { 2.061155e-01, -4.793930e-01, -8.530526e-01,  1.985071e-01, -4.931525e-01, -8.592212e-01},
  {-3.827475e-01, -7.143708e-01, -5.858145e-01, -3.838238e-01, -7.267206e-01, -5.877148e-01},
  {-3.087683e-01, -7.436554e-01, -5.929913e-01, -3.211635e-01, -7.423813e-01, -6.054562e-01},
  {-3.250202e-01, -6.871143e-01, -6.497967e-01, -3.120236e-01, -7.024896e-01, -6.557465e-01},
  { 8.628933e-02, -5.615657e-01, -8.229205e-01,  8.567725e-02, -5.607452e-01, -8.361142e-01},
  { 3.031022e-02, -9.841259e-01,  1.748642e-01,  2.529619e-02, -9.931284e-01,  1.841455e-01},
  { 4.290829e-01, -8.523540e-01,  2.989656e-01,  4.328567e-01, -8.594655e-01,  3.079217e-01},
  { 6.714464e-02, -9.890148e-01,  1.316863e-01,  6.764060e-02, -9.984302e-01,  1.393421e-01},
  { 2.872853e-01, -9.434814e-01,  1.652571e-01,  2.925139e-01, -9.519871e-01,  1.703373e-01},
  { 5.388141e-02, -9.955757e-01,  7.697902e-02,  5.514492e-02, -1.005689e+00,  8.001843e-02},
  { 3.760258e-01, -9.200175e-01,  1.103279e-01,  3.783531e-01, -9.297593e-01,  1.151394e-01},
  {-6.125705e-01, -7.874010e-01, -6.897138e-02, -6.273055e-01, -7.900752e-01, -5.580876e-02},
  {-6.458375e-01, -7.617201e-01, -5.173371e-02, -6.568249e-01, -7.661151e-01, -4.994055e-02},
  { 4.957263e-01, -8.575306e-01, -1.374651e-01,  4.990735e-01, -8.667902e-01, -1.430539e-01},
  {-6.138481e-01, -7.708176e-01, -1.703838e-01, -6.246409e-01, -7.804211e-01, -1.470123e-01},
  {-7.270164e-02, -9.946660e-01, -7.317135e-02, -6.852052e-02, -1.005791e+00, -6.739347e-02},
  { 5.998245e-01, -7.898227e-01, -1.280261e-01,  6.066887e-01, -7.984554e-01, -1.235494e-01},
  { 3.942669e-01, -8.468373e-01, -3.569597e-01,  4.411825e-01, -8.480725e-01, -3.271006e-01},
  {-1.234486e-01, -9.859682e-01, -1.123700e-01, -1.303899e-01, -9.937941e-01, -1.273717e-01},
  { 4.344165e-01, -8.116339e-01, -3.905542e-01,  4.551055e-01, -8.061854e-01, -4.047333e-01},
  { 4.479838e-01, -7.803624e-01, -4.362853e-01,  4.517159e-01, -7.886871e-01, -4.413508e-01},
  { 4.870513e-01, -6.822140e-01, -5.453119e-01,  4.925596e-01, -6.846479e-01, -5.563360e-01},
  {-2.655410e-01, -9.396035e-01, -2.159474e-01, -2.651609e-01, -9.494528e-01, -2.215388e-01},
  {-6.042618e-01, -7.324194e-01, -3.137346e-01, -4.984358e-01, -7.585841e-01, -4.438031e-01},
  {-5.383769e-01, -7.358077e-01, -4.107766e-01, -5.018843e-01, -7.523416e-01, -4.525954e-01},
  { 5.008115e-01, -6.534837e-01, -5.675799e-01,  5.062059e-01, -6.442571e-01, -5.912331e-01},
  {-5.460789e-01, -7.489454e-01, -3.753380e-01, -4.942159e-01, -7.656614e-01, -4.363058e-01},
  {-5.071415e-01, -6.959012e-01, -5.084576e-01, -5.003405e-01, -7.127476e-01, -5.123479e-01},
  {-3.978380e-01, -7.974626e-01, -4.536279e-01, -4.082308e-01, -8.051715e-01, -4.537587e-01},
  { 1.229690e-01, -5.189858e-01, -8.458914e-01,  1.072322e-01, -5.208327e-01, -8.591265e-01},
  {-2.636175e-02, -4.838994e-01, -8.747265e-01, -3.414975e-02, -4.841476e-01, -8.861697e-01},
  {-1.845749e-01, -5.390861e-01, -8.217775e-01, -1.981862e-01, -5.461733e-01, -8.266045e-01},
  {-2.872493e-01, -6.742431e-01, -6.803559e-01, -3.084890e-01, -6.737130e-01, -6.868767e-01},
  { 6.007952e-02, -5.286621e-01, -8.467035e-01,  3.630261e-02, -5.263334e-01, -8.629577e-01},
  {-2.372372e-01, -5.775757e-01, -7.811049e-01, -2.456393e-01, -5.831509e-01, -7.876884e-01},
  { 9.170880e-02, -9.233919e-01,  3.727423e-01,  7.548293e-02, -9.362040e-01,  3.723962e-01},
  { 3.664512e-02, -9.265910e-01,  3.742810e-01,  3.676588e-02, -9.393322e-01,  3.703473e-01},
  { 1.547863e-02, -9.461693e-01,  3.233016e-01,  2.171377e-02, -9.526722e-01,  3.358538e-01},
  { 6.934217e-02, -9.422386e-01,  3.276860e-01,  7.430879e-02, -9.544864e-01,  3.266464e-01},
  { 2.330509e-01, -9.454732e-01,  2.275251e-01,  2.378092e-01, -9.584436e-01,  2.137520e-01},
  {-6.328351e-03, -9.785516e-01,  2.059048e-01, -1.073340e-02, -9.887430e-01,  2.076655e-01},
  { 2.564356e-01, -9.468796e-01,  1.940611e-01,  2.559379e-01, -9.560242e-01,  2.033996e-01},
  { 4.450297e-01, -8.424993e-01,  3.035515e-01,  4.538996e-01, -8.617024e-01,  2.688981e-01},
  { 4.973392e-01, -8.113065e-01,  3.073037e-01,  4.575162e-01, -8.634833e-01,  2.609932e-01},
  {-5.445011e-01, -8.380937e-01,  3.342947e-02, -5.508651e-01, -8.465091e-01,  2.856771e-02},
  {-4.103097e-01, -9.104090e-01,  5.292813e-02, -4.185861e-01, -9.178324e-01,  5.671569e-02},
  { 2.399191e-03, -9.993660e-01,  3.552203e-02, -7.137201e-03, -1.009834e+00,  3.222584e-02},
  { 5.141606e-01, -8.576791e-01,  5.046142e-03,  5.214135e-01, -8.653027e-01,  1.558956e-02},
  { 4.977403e-01, -8.664043e-01,  3.997611e-02,  5.057316e-01, -8.739558e-01,  3.605868e-02},
  { 5.497885e-01, -8.349876e-01, -2.298717e-02,  5.605977e-01, -8.403884e-01, -1.851324e-02},
  { 4.485618e-01, -8.773177e-01, -1.706042e-01,  4.505391e-01, -8.889185e-01, -1.664382e-01},
  {-4.277833e-02, -9.981797e-01, -4.251047e-02, -5.090432e-02, -1.008760e+00, -2.577314e-02},
  {-6.240761e-01, -7.746713e-01, -1.020462e-01, -6.320033e-01, -7.794200e-01, -1.179923e-01},
  {-6.610476e-01, -7.471967e-01, -6.865239e-02, -6.720510e-01, -7.518027e-01, -6.312943e-02},
  {-6.969931e-01, -7.166128e-01, -2.582206e-02, -6.951576e-01, -7.323048e-01, -3.647745e-02},
  { 4.159637e-01, -8.904426e-01, -1.846245e-01,  4.232885e-01, -8.984913e-01, -1.854803e-01},
  { 4.945695e-01, -8.507023e-01, -1.780636e-01,  5.011091e-01, -8.592240e-01, -1.774493e-01},
  { 6.070893e-01, -7.756351e-01, -1.727211e-01,  6.138353e-01, -7.830017e-01, -1.760159e-01},
  {-5.683711e-01, -7.759030e-01, -2.737314e-01, -5.781184e-01, -7.806684e-01, -2.778185e-01},
  {-6.015119e-01, -7.644746e-01, -2.318664e-01, -5.999752e-01, -7.746004e-01, -2.467199e-01},
  { 4.158480e-01, -8.277787e-01, -3.766336e-01,  4.634376e-01, -8.247091e-01, -3.548875e-01},
  {-2.745401e-01, -9.497325e-01, -1.504524e-01, -2.784074e-01, -9.583644e-01, -1.577245e-01},
  {-5.390650e-01, -7.704929e-01, -3.402197e-01, -5.419504e-01, -7.758953e-01, -3.537294e-01},
  {-7.500201e-02, -9.863192e-01, -1.467961e-01, -1.620753e-01, -9.829441e-01, -1.685348e-01},
  {-4.652571e-01, -7.766222e-01, -4.247279e-01, -4.643850e-01, -7.849743e-01, -4.347548e-01},
  { 4.735410e-01, -5.893151e-01, -6.545737e-01,  3.651679e-01, -5.697536e-01, -7.515299e-01},
  { 4.207880e-01, -5.859998e-01, -6.924894e-01,  4.251183e-01, -5.883151e-01, -7.028710e-01},
  {-3.523112e-01, -8.224575e-01, -4.465876e-01, -3.511995e-01, -8.321601e-01, -4.527910e-01},
  { 2.564425e-01, -5.068676e-01, -8.229960e-01,  2.493085e-01, -5.073429e-01, -8.374454e-01},
  { 2.387623e-01, -4.967316e-01, -8.344161e-01,  2.424544e-01, -4.987780e-01, -8.445724e-01},
  { 1.263123e-01, -2.897612e-01, -9.487274e-01,  2.831910e-01, -5.306206e-01, -8.131195e-01},
  { 2.501265e-01, -4.699940e-01, -8.464882e-01,  2.443278e-01, -4.844834e-01, -8.523181e-01},
  { 1.460964e-01, -4.740996e-01, -8.682657e-01,  1.527746e-01, -4.699088e-01, -8.813120e-01},
  {-3.345369e-01, -7.170613e-01, -6.114802e-01, -3.369780e-01, -7.254644e-01, -6.172523e-01},
  { 1.027458e-01, -4.867666e-01, -8.674685e-01,  1.171398e-01, -4.955473e-01, -8.726829e-01},
  { 3.476334e-02, -4.723817e-01, -8.807083e-01,  1.511863e-02, -4.824297e-01, -8.876349e-01},
  {-7.658277e-02, -5.120553e-01, -8.555318e-01, -7.012977e-02, -5.050690e-01, -8.722660e-01},
  {-2.676872e-01, -6.068325e-01, -7.483969e-01, -2.750860e-01, -6.197483e-01, -7.490631e-01},
  { 3.506377e-01, -8.570759e-01,  3.774576e-01,  3.544249e-01, -8.697090e-01,  3.726247e-01},
  {-3.945082e-02, -9.495977e-01,  3.109790e-01, -3.893416e-02, -9.582943e-01,  3.178189e-01},
  {-9.638222e-02, -9.597511e-01,  2.637959e-01, -1.087193e-01, -9.640845e-01,  2.820862e-01},
  {-7.592208e-02, -9.664712e-01,  2.452943e-01, -7.614459e-02, -9.761171e-01,  2.494979e-01},
  { 1.946338e-01, -9.507813e-01,  2.411071e-01,  2.112743e-01, -9.580795e-01,  2.414618e-01},
  { 1.543753e-01, -9.471212e-01,  2.813001e-01,  1.564460e-01, -9.576963e-01,  2.814220e-01},
  { 1.691323e-02, -9.892535e-01,  1.452295e-01,  1.668475e-02, -9.988352e-01,  1.513387e-01},
  { 5.129157e-02, -9.921728e-01,  1.138518e-01,  3.780789e-02, -1.002159e+00,  1.228861e-01},
  { 5.715992e-01, -7.739671e-01,  2.724869e-01,  4.612912e-01, -8.618366e-01,  2.555594e-01},
  { 3.587184e-01, -9.176990e-01,  1.707324e-01,  3.600573e-01, -9.304397e-01,  1.596904e-01},
  {-3.623948e-01, -9.292861e-01,  7.139520e-02, -3.616867e-01, -9.414304e-01,  6.115216e-02},
  {-5.251878e-01, -8.477640e-01,  7.398645e-02, -5.043558e-01, -8.724959e-01,  7.226594e-02},
  { 4.271064e-01, -8.957362e-01,  1.234370e-01,  4.342373e-01, -9.051057e-01,  1.143829e-01},
  {-3.367643e-01, -9.408340e-01,  3.769783e-02, -3.562689e-01, -9.449603e-01,  3.115843e-02},
  {-3.658149e-01, -9.306436e-01, -9.049907e-03, -3.637258e-01, -9.426214e-01,  4.090950e-03},
  {-6.351676e-01, -7.723538e-01, -5.632438e-03, -6.416548e-01, -7.804642e-01,  2.703650e-04},
  {-6.700897e-01, -7.422535e-01, -6.294626e-03, -6.749456e-01, -7.517075e-01, -1.514508e-02},
  {-6.510144e-01, -7.491115e-01, -1.225236e-01, -6.455560e-01, -7.663254e-01, -1.298018e-01},
  { 5.929051e-01, -8.030642e-01, -5.959393e-02,  6.051359e-01, -8.070248e-01, -5.820397e-02},
  { 5.450341e-01, -8.234735e-01, -1.575732e-01,  5.530280e-01, -8.316717e-01, -1.527994e-01},
  {-6.353917e-01, -7.535311e-01, -1.687255e-01, -6.465608e-01, -7.556510e-01, -1.783164e-01},
  { 6.347770e-01, -7.472467e-01, -1.966738e-01,  6.379790e-01, -7.600392e-01, -1.902396e-01},
  { 4.608243e-01, -8.347362e-01, -3.014239e-01,  4.665794e-01, -8.442505e-01, -3.006810e-01},
  {-2.719269e-01, -9.536334e-01, -1.289927e-01, -2.699743e-01, -9.649093e-01, -1.300538e-01},
  {-1.639419e-01, -9.674223e-01, -1.929177e-01, -2.550749e-01, -9.645408e-01, -1.669819e-01},
  {-1.831267e-02, -9.918807e-01, -1.258461e-01, -1.667394e-01, -9.840775e-01, -1.646978e-01},
  {-2.295042e-01, -9.492063e-01, -2.152562e-01, -1.758877e-01, -9.814117e-01, -1.635424e-01},
  {-5.038872e-01, -7.740490e-01, -3.833351e-01, -5.122088e-01, -7.822959e-01, -3.827584e-01},
  { 4.756020e-01, -7.477350e-01, -4.633521e-01,  4.743141e-01, -7.604656e-01, -4.671002e-01},
  { 4.850067e-01, -7.170977e-01, -5.005391e-01,  4.937928e-01, -7.185982e-01, -5.105410e-01},
  {-4.481222e-01, -7.979501e-01, -4.030659e-01, -4.549953e-01, -8.063758e-01, -4.044586e-01},
  {-4.028238e-01, -8.127047e-01, -4.210037e-01, -4.109937e-01, -8.165033e-01, -4.304146e-01},
  { 5.773942e-01, -6.196103e-01, -5.316945e-01,  3.682036e-01, -5.669779e-01, -7.508858e-01},
  { 4.785272e-01, -6.055180e-01, -6.358929e-01,  3.719303e-01, -5.631883e-01, -7.519003e-01},
  { 3.962025e-01, -5.652849e-01, -7.235168e-01,  3.953539e-01, -5.731988e-01, -7.321244e-01},
  { 5.165497e-01, -5.813148e-01, -6.286888e-01,  5.051396e-01, -5.971863e-01, -6.395868e-01},
  { 3.301135e-01, -5.373546e-01, -7.760638e-01,  3.547073e-01, -5.282668e-01, -7.848468e-01},
  {-4.660075e-01, -6.737551e-01, -5.734903e-01, -4.642806e-01, -6.761312e-01, -5.900353e-01},
  {-4.274726e-01, -6.727463e-01, -6.038870e-01, -4.429961e-01, -6.744982e-01, -6.079955e-01},
  {-1.845600e-02, -4.435160e-01, -8.960765e-01, -1.402427e-02, -4.580118e-01, -9.004949e-01},
  {-3.015240e-01, -6.251971e-01, -7.198693e-01, -3.096969e-01, -6.268781e-01, -7.293605e-01},
  {-1.328005e-01, -4.981484e-01, -8.568618e-01, -1.439205e-01, -4.990237e-01, -8.666729e-01},
  { 6.584884e-02, -9.068103e-01,  4.163641e-01,  8.154458e-02, -9.184696e-01,  4.130603e-01},
  { 1.066543e-01, -9.244540e-01,  3.660732e-01,  1.135796e-01, -9.323816e-01,  3.723162e-01},
  {-1.547178e-02, -9.259547e-01,  3.773176e-01, -6.176786e-03, -9.402207e-01,  3.698646e-01},
  { 1.210750e-01, -9.401196e-01,  3.186158e-01,  1.303166e-01, -9.518514e-01,  3.128127e-01},
  { 3.937617e-01, -8.445759e-01,  3.628265e-01,  3.985400e-01, -8.541372e-01,  3.639730e-01},
  {-5.474873e-02, -9.768496e-01,  2.068031e-01, -4.871754e-02, -9.884317e-01,  2.036701e-01},
  { 4.128096e-01, -8.478619e-01,  3.327437e-01,  4.268785e-01, -8.492871e-01,  3.425606e-01},
  { 3.976791e-01, -8.713082e-01,  2.875294e-01,  3.960162e-01, -8.838019e-01,  2.879690e-01},
  { 4.271224e-01, -8.692538e-01,  2.489263e-01,  4.340012e-01, -8.772859e-01,  2.507471e-01},
  { 3.161476e-01, -9.288951e-01,  1.928851e-01,  3.229157e-01, -9.358674e-01,  2.018338e-01},
  { 3.888219e-01, -8.964469e-01,  2.126044e-01,  4.585921e-01, -8.664612e-01,  2.445413e-01},
  { 7.900007e-05, -9.954197e-01,  9.560131e-02, -3.904414e-03, -1.006007e+00,  9.374023e-02},
  {-3.536177e-02, -9.977299e-01,  5.731120e-02, -3.007594e-02, -1.008537e+00,  5.292505e-02},
  {-3.088424e-01, -9.483427e-01,  7.254261e-02, -3.127434e-01, -9.573968e-01,  8.019597e-02},
  {-6.306984e-02, -9.977268e-01,  2.373601e-02, -6.583343e-02, -1.008113e+00,  1.503358e-02},
  {-6.795429e-01, -7.292848e-01, -7.978217e-02, -6.871839e-01, -7.360157e-01, -8.309247e-02},
  {-1.183521e-01, -9.915542e-01, -5.303815e-02, -1.077754e-01, -1.003791e+00, -4.049079e-02},
  { 6.301680e-01, -7.723323e-01, -7.994474e-02,  6.359958e-01, -7.813758e-01, -7.634450e-02},
  { 5.282350e-01, -8.269536e-01, -1.926539e-01,  5.267372e-01, -8.395817e-01, -1.962543e-01},
  { 4.576247e-01, -8.632739e-01, -2.129272e-01,  4.628690e-01, -8.723652e-01, -2.135298e-01},
  {-3.080562e-01, -9.484261e-01, -7.476223e-02, -3.007564e-01, -9.625759e-01, -6.198791e-02},
  { 5.759474e-01, -7.959496e-01, -1.864105e-01,  5.805527e-01, -8.040587e-01, -1.931698e-01},
  { 6.420193e-01, -7.515609e-01, -1.515500e-01,  6.457800e-01, -7.606998e-01, -1.586562e-01},
  { 5.873162e-01, -7.789975e-01, -2.195965e-01,  5.910686e-01, -7.906179e-01, -2.154714e-01},
  {-6.156794e-01, -7.506120e-01, -2.398344e-01, -6.296314e-01, -7.540668e-01, -2.362080e-01},
  {-5.913901e-01, -7.479029e-01, -3.014944e-01, -5.997717e-01, -7.517675e-01, -3.097852e-01},
  { 5.167639e-01, -7.789633e-01, -3.552061e-01,  4.882807e-01, -8.054443e-01, -3.656595e-01},
  {-8.106336e-02, -9.738203e-01, -2.123743e-01, -2.461909e-01, -9.679280e-01, -1.528262e-01},
  {-1.289191e-01, -9.891096e-01, -7.100713e-02, -1.796115e-01, -9.832088e-01, -1.479569e-01},
  {-7.141069e-02, -9.753842e-01, -2.086293e-01, -2.496130e-01, -9.659544e-01, -1.596115e-01},
  { 5.149881e-01, -7.672539e-01, -3.822418e-01,  4.951101e-01, -7.813334e-01, -4.065095e-01},
  {-5.838055e-01, -7.365619e-01, -3.415373e-01, -5.851266e-01, -7.459513e-01, -3.493297e-01},
  { 4.959865e-01, -7.576622e-01, -4.241996e-01,  4.963807e-01, -7.639114e-01, -4.369346e-01},
  {-5.645779e-01, -7.343360e-01, -3.768321e-01, -5.718639e-01, -7.447408e-01, -3.730696e-01},
  {-5.394093e-01, -7.465955e-01, -3.894005e-01, -5.433258e-01, -7.574258e-01, -3.898096e-01},
  {-5.051198e-01, -7.616777e-01, -4.058338e-01, -5.206804e-01, -7.599984e-01, -4.149015e-01},
  { 5.680343e-01, -5.628076e-01, -6.004871e-01,  5.334789e-01, -6.631248e-01, -5.445495e-01},
  { 5.320653e-01, -5.921530e-01, -6.051953e-01,  5.324421e-01, -6.092108e-01, -6.051749e-01},
  {-5.474902e-01, -7.126026e-01, -4.386934e-01, -5.549501e-01, -7.171058e-01, -4.456888e-01},
  { 4.609162e-01, -5.634596e-01, -6.856163e-01,  4.627643e-01, -5.646260e-01, -6.985094e-01},
  {-4.989039e-01, -6.550788e-01, -5.674211e-01, -5.092812e-01, -6.596456e-01, -5.712714e-01},
  { 1.953375e-01, -4.334323e-01, -8.797611e-01,  1.949349e-01, -4.427688e-01, -8.870301e-01},
  { 1.577524e-01, -4.392429e-01, -8.844094e-01,  1.580101e-01, -4.498956e-01, -8.907818e-01},
  { 8.123048e-02, -4.963850e-01, -8.642936e-01,  7.887708e-02, -5.130522e-01, -8.668444e-01},
  { 1.333543e-02, -4.812687e-01, -8.764716e-01, -1.749204e-01, -5.075454e-01, -8.559554e-01},
  { 1.321871e-02, -9.109566e-01,  4.122904e-01,  2.375302e-02, -9.210074e-01,  4.147708e-01},
  { 2.725289e-01, -8.674156e-01,  4.163150e-01,  2.635562e-01, -8.787286e-01,  4.233584e-01},
  { 1.288913e-01, -9.214860e-01,  3.664022e-01,  1.268485e-01, -9.321845e-01,  3.685062e-01},
  {-1.135036e-01, -9.370576e-01,  3.302120e-01, -1.115931e-01, -9.521041e-01,  3.192117e-01},
  { 3.221771e-01, -8.483315e-01,  4.201614e-01,  3.347567e-01, -8.516768e-01,  4.283038e-01},
  { 3.065723e-01, -8.747563e-01,  3.752531e-01,  3.097628e-01, -8.850845e-01,  3.762065e-01},
  {-2.613945e-01, -8.768116e-01,  4.035768e-01, -1.444855e-01, -9.559279e-01,  2.935584e-01},
  { 3.572660e-01, -8.701046e-01,  3.395275e-01,  3.519333e-01, -8.830115e-01,  3.424813e-01},
  { 3.513978e-01, -8.866653e-01,  3.005733e-01,  3.709131e-01, -8.892592e-01,  3.049096e-01},
  {-2.552173e-02, -9.874431e-01,  1.558993e-01, -2.701698e-02, -9.984959e-01,  1.520818e-01},
  { 4.864086e-01, -8.292195e-01,  2.753210e-01,  4.865754e-01, -8.422853e-01,  2.732447e-01},
  { 4.024388e-01, -9.012918e-01,  1.603625e-01,  4.057859e-01, -9.103703e-01,  1.656044e-01},
  {-3.208891e-01, -9.403127e-01,  1.133236e-01, -3.311664e-01, -9.486805e-01,  1.057474e-01},
  {-6.106486e-01, -7.916011e-01,  2.182104e-02, -6.184614e-01, -7.983985e-01,  3.017854e-02},
  {-4.134423e-01, -9.047011e-01,  1.028660e-01, -4.146582e-01, -9.158687e-01,  1.004507e-01},
  {-4.743326e-01, -8.744543e-01,  1.016777e-01, -4.824071e-01, -8.818947e-01,  1.019392e-01},
  { 4.618889e-01, -8.811967e-01,  1.007522e-01,  4.653258e-01, -8.896620e-01,  1.132954e-01},
  {-3.163478e-01, -9.486115e-01, -7.756890e-03, -3.220416e-01, -9.576719e-01, -1.622397e-03},
  { 5.109892e-01, -8.568785e-01,  6.818520e-02,  5.220170e-01, -8.626740e-01,  6.446458e-02},
  {-1.041920e-01, -9.945415e-01, -5.596970e-03, -1.065248e-01, -1.004734e+00, -3.834218e-03},
  { 5.824099e-01, -8.128953e-01, -1.296763e-04,  5.878965e-01, -8.217114e-01, -5.818742e-03},
  {-6.818871e-01, -7.238780e-01, -1.050268e-01, -6.916478e-01, -7.302220e-01, -9.614854e-02},
  { 4.715914e-01, -8.442731e-01, -2.545674e-01,  4.799910e-01, -8.513100e-01, -2.564067e-01},
  {-6.603664e-01, -7.236878e-01, -2.004802e-01, -6.661310e-01, -7.333500e-01, -2.024714e-01},
  { 6.457783e-01, -7.554331e-01, -1.108653e-01,  6.536413e-01, -7.607456e-01, -1.220119e-01},
  {-1.480359e-01, -9.847583e-01, -9.130442e-02, -1.539817e-01, -9.951978e-01, -8.198932e-02},
  {-2.251951e-01, -9.733150e-01, -4.410487e-02, -2.465964e-01, -9.753340e-01, -9.361430e-02},
  { 5.134229e-01, -7.926410e-01, -3.288118e-01,  4.889187e-01, -8.194979e-01, -3.320343e-01},
  {-2.259433e-01, -9.671130e-01, -1.167991e-01, -1.925353e-01, -9.858971e-01, -1.085725e-01},
  {-2.198301e-01, -9.633424e-01, -1.537728e-01, -2.124724e-01, -9.787890e-01, -1.329598e-01},
  { 4.208782e-01, -5.474819e-01, -7.232739e-01,  4.358728e-01, -5.476039e-01, -7.287067e-01},
  { 4.963261e-01, -5.655280e-01, -6.586642e-01,  5.031433e-01, -5.663589e-01, -6.685460e-01},
  { 3.970258e-01, -5.206344e-01, -7.558507e-01,  3.754913e-01, -5.262038e-01, -7.765203e-01},
  { 2.382192e-01, -4.473211e-01, -8.620646e-01,  2.281678e-01, -4.483721e-01, -8.762240e-01},
  { 2.526883e-01, -3.944533e-01, -8.834904e-01,  3.219552e-01, -5.045289e-01, -8.140410e-01},
  {-3.805700e-01, -6.838175e-01, -6.225432e-01, -3.892408e-01, -6.889308e-01, -6.282663e-01},
  {-2.369017e-01, -5.240316e-01, -8.180883e-01, -2.328808e-01, -5.252970e-01, -8.310760e-01},
  {-2.739910e-01, -5.604308e-01, -7.815666e-01, -2.781521e-01, -5.566719e-01, -7.959927e-01},
  {-7.897248e-02, -4.686148e-01, -8.798656e-01, -7.501832e-02, -4.646074e-01, -8.940769e-01},
  { 1.444157e-01, -4.112887e-01, -8.999920e-01, -1.795978e-01, -4.965845e-01, -8.626617e-01},
  {-5.752086e-02, -9.371188e-01,  3.442380e-01, -5.834308e-02, -9.462714e-01,  3.493118e-01},
  {-7.852499e-02, -9.273360e-01,  3.658985e-01, -8.159599e-02, -9.404842e-01,  3.601156e-01},
  { 1.629982e-01, -9.276821e-01,  3.359130e-01,  1.536711e-01, -9.418620e-01,  3.318687e-01},
  {-4.200826e-01, -8.089715e-01,  4.112126e-01, -1.577516e-01, -9.595087e-01,  2.788015e-01},
  { 3.718694e-01, -8.323097e-01,  4.110644e-01,  3.716492e-01, -8.389387e-01,  4.229885e-01},
  { 4.686080e-01, -8.233926e-01,  3.200484e-01,  4.795731e-01, -8.282917e-01,  3.237362e-01},
  {-2.688286e-01, -9.425563e-01,  1.982898e-01, -2.641726e-01, -9.542792e-01,  2.069350e-01},
  { 2.843116e-01, -9.294313e-01,  2.352115e-01,  2.929196e-01, -9.370592e-01,  2.390855e-01},
  {-2.496734e-01, -9.581805e-01,  1.398330e-01, -2.521873e-01, -9.679813e-01,  1.423480e-01},
  {-2.970465e-01, -9.443468e-01,  1.413242e-01, -2.986148e-01, -9.514640e-01,  1.624627e-01},
  { 4.907953e-01, -8.389590e-01,  2.350910e-01,  5.015545e-01, -8.430006e-01,  2.421904e-01},
  {-5.722195e-01, -8.190730e-01,  4.104007e-02, -5.923792e-01, -8.172197e-01,  4.565455e-02},
  {-7.814124e-02, -9.952123e-01,  5.870574e-02, -7.711758e-02, -1.006084e+00,  5.196207e-02},
  {-2.798016e-01, -9.593529e-01,  3.678364e-02, -2.786036e-01, -9.701678e-01,  4.476186e-02},
  { 5.500384e-01, -8.338310e-01,  4.672853e-02,  5.588878e-01, -8.408121e-01,  3.929776e-02},
  { 6.347054e-01, -7.720708e-01, -3.249345e-02,  6.403717e-01, -7.803330e-01, -4.326253e-02},
  {-7.177393e-01, -6.919210e-01, -7.807393e-02, -7.277222e-01, -6.972703e-01, -7.127001e-02},
  {-1.695653e-01, -9.839866e-01, -5.493643e-02, -1.701383e-01, -9.940463e-01, -6.144802e-02},
  { 5.452833e-01, -8.035960e-01, -2.385364e-01,  5.503281e-01, -8.162444e-01, -2.274858e-01},
  { 6.040886e-01, -7.586141e-01, -2.440934e-01,  6.201760e-01, -7.608483e-01, -2.394982e-01},
  { 4.924541e-01, -8.119506e-01, -3.134088e-01,  4.959910e-01, -8.262266e-01, -3.036570e-01},
  {-1.337530e-01, -9.855878e-01,  1.035698e-01, -2.319816e-01, -9.777951e-01, -1.046502e-01},
  {-1.682923e-01, -9.857370e-01, -5.774855e-04, -2.246589e-01, -9.799432e-01, -1.120891e-01},
  {-6.317571e-01, -7.219923e-01, -2.821525e-01, -6.353236e-01, -7.316140e-01, -2.862723e-01},
  {-5.879406e-01, -6.994011e-01, -4.064035e-01, -5.866081e-01, -7.155479e-01, -4.065014e-01},
  { 5.274257e-01, -6.954113e-01, -4.880834e-01,  5.273375e-01, -7.006539e-01, -5.018635e-01},
  { 5.850788e-01, -4.520195e-01, -6.733210e-01,  5.497488e-01, -6.612974e-01, -5.304061e-01},
  { 5.741168e-01, -5.881264e-01, -5.696466e-01,  5.557502e-01, -6.615456e-01, -5.253925e-01},
  { 4.608049e-01, -5.267576e-01, -7.142726e-01,  4.618372e-01, -5.361723e-01, -7.211760e-01},
  {-5.511171e-01, -6.729348e-01, -4.933848e-01, -5.559115e-01, -6.753479e-01, -5.056850e-01},
  {-5.297055e-01, -6.549293e-01, -5.389616e-01, -5.366794e-01, -6.602139e-01, -5.449247e-01},
  {-4.588076e-01, -6.411477e-01, -6.151627e-01, -4.684466e-01, -6.444849e-01, -6.213282e-01},
  { 4.024513e-02, -4.345050e-01, -8.997698e-01,  5.086336e-02, -4.400833e-01, -9.080768e-01},
  {-1.150045e-01, -4.440526e-01, -8.885894e-01, -1.106687e-01, -4.567749e-01, -8.944104e-01},
  { 1.803226e-02, -4.098434e-01, -9.119776e-01, -1.843092e-01, -4.805536e-01, -8.694582e-01},
  { 1.302214e-01, -8.900064e-01,  4.369563e-01,  1.317545e-01, -9.036989e-01,  4.322321e-01},
  { 1.552029e-01, -9.090096e-01,  3.867992e-01,  1.578553e-01, -9.160989e-01,  3.958543e-01},
  {-5.030990e-02, -9.130941e-01,  4.046333e-01, -5.135319e-02, -9.201675e-01,  4.141339e-01},
  { 2.556832e-01, -8.873917e-01,  3.836171e-01,  2.618859e-01, -8.992053e-01,  3.790827e-01},
  {-1.349358e-01, -9.291672e-01,  3.441519e-01, -1.221023e-01, -9.415348e-01,  3.456221e-01},
  {-5.250001e-01, -7.875203e-01,  3.227797e-01, -1.618643e-01, -9.606225e-01,  2.680576e-01},
  {-2.601998e-01, -9.093139e-01,  3.247220e-01, -1.745408e-01, -9.599177e-01,  2.625718e-01},
  {-2.011360e-01, -9.375200e-01,  2.839022e-01, -2.011854e-01, -9.516096e-01,  2.735209e-01},
  { 3.177696e-01, -8.886486e-01,  3.306448e-01,  3.229497e-01, -8.974036e-01,  3.335110e-01},
  {-2.541832e-01, -9.282573e-01,  2.715315e-01, -2.483273e-01, -9.400641e-01,  2.747043e-01},
  {-8.073507e-02, -9.825420e-01,  1.676098e-01, -8.640791e-02, -9.896757e-01,  1.841935e-01},
  { 3.685675e-01, -8.912706e-01,  2.641867e-01,  3.643480e-01, -9.042169e-01,  2.655230e-01},
  { 3.928033e-01, -8.891255e-01,  2.348651e-01,  4.008505e-01, -8.961693e-01,  2.388729e-01},
  {-5.176344e-02, -9.926101e-01,  1.097528e-01, -4.339845e-02, -1.002888e+00,  1.148270e-01},
  { 5.104314e-01, -8.347977e-01,  2.063309e-01,  5.153072e-01, -8.424928e-01,  2.133729e-01},
  { 4.350962e-01, -8.772742e-01,  2.026852e-01,  4.444118e-01, -8.840957e-01,  2.042914e-01},
  {-2.625356e-01, -9.599539e-01,  9.779301e-02, -2.560506e-01, -9.737560e-01,  8.418375e-02},
  { 4.754809e-01, -8.575761e-01,  1.961661e-01,  4.837115e-01, -8.690242e-01,  1.779970e-01},
  { 4.402681e-01, -8.839409e-01,  1.575199e-01,  4.398757e-01, -8.961250e-01,  1.559839e-01},
  {-3.705575e-01, -9.208827e-01,  1.210870e-01, -3.732036e-01, -9.303401e-01,  1.266261e-01},
  {-5.623747e-01, -8.217772e-01,  9.174438e-02, -5.697484e-01, -8.290749e-01,  9.416568e-02},
  {-5.310630e-01, -8.405055e-01,  1.073432e-01, -5.431803e-01, -8.450401e-01,  1.082040e-01},
  {-1.204891e-01, -9.918363e-01,  4.175049e-02, -1.183414e-01, -1.002937e+00,  3.106613e-02},
  {-2.856638e-01, -9.582713e-01,  1.060293e-02, -2.888243e-01, -9.681723e-01, -8.493165e-03},
  { 6.100440e-01, -7.923644e-01, -2.220653e-03,  6.176568e-01, -7.996012e-01, -2.156999e-03},
  {-7.298574e-01, -6.712455e-01, -1.293739e-01, -7.059563e-01, -7.131535e-01, -1.178262e-01},
  {-2.715382e-01, -9.614750e-01, -4.281273e-02, -2.705701e-01, -9.729111e-01, -3.294328e-02},
  {-6.918430e-01, -7.070529e-01, -1.463883e-01, -6.968001e-01, -7.158040e-01, -1.514595e-01},
  {-7.554914e-01, -6.550509e-01, -1.187614e-02, -7.548940e-01, -6.714795e-01, -9.737658e-03},
  { 5.003964e-01, -8.356454e-01, -2.264955e-01,  5.051526e-01, -8.442054e-01, -2.302233e-01},
  {-7.382816e-01, -6.712204e-01, -6.635977e-02, -7.545754e-01, -6.701657e-01, -4.835984e-02},
  {-2.235965e-01, -9.718691e-01, -7.399368e-02, -2.199738e-01, -9.842259e-01, -6.132901e-02},
  { 6.713272e-01, -7.121699e-01, -2.052655e-01,  6.783386e-01, -7.180683e-01, -2.123761e-01},
  {-6.246046e-01, -7.119867e-01, -3.208488e-01, -6.339431e-01, -7.167711e-01, -3.243493e-01},
  { 5.168830e-01, -7.355008e-01, -4.380303e-01,  5.284513e-01, -7.398014e-01, -4.407949e-01},
  {-6.142580e-01, -7.001134e-01, -3.640444e-01, -6.212850e-01, -7.077379e-01, -3.660052e-01},
  { 4.948344e-01, -7.239262e-01, -4.806972e-01,  5.063018e-01, -7.388120e-01, -4.676346e-01},
  { 5.376684e-01, -5.636017e-01, -6.271091e-01,  5.511819e-01, -5.680911e-01, -6.279657e-01},
  { 4.248230e-01, -5.171903e-01, -7.429938e-01,  4.219377e-01, -5.244786e-01, -7.534982e-01},
  { 5.062363e-01, -5.290091e-01, -6.810831e-01,  5.110005e-01, -5.414796e-01, -6.830433e-01},
  { 1.401156e-01, -4.113615e-01, -9.006382e-01,  1.468159e-01, -4.016002e-01, -9.154388e-01},
  {-4.804905e-01, -6.281756e-01, -6.119840e-01, -4.848302e-01, -6.338965e-01, -6.201439e-01},
  { 3.022524e-01, -4.679050e-01, -8.304868e-01,  3.090535e-01, -4.704925e-01, -8.390414e-01},
  {-2.761733e-01, -6.133118e-01, -7.399844e-01, -3.786513e-01, -6.665850e-01, -6.581343e-01},
  { 2.402491e-02, -4.957203e-01, -8.681499e-01,  7.967332e-02, -4.453349e-01, -9.034342e-01},
  { 1.114636e-01, -4.507626e-01, -8.856574e-01,  7.724327e-02, -4.615469e-01, -8.954731e-01},
  {-3.214949e-01, -5.385705e-01, -7.788343e-01, -3.110072e-01, -5.583757e-01, -7.825261e-01},
  {-6.655138e-02, -4.325904e-01, -8.991309e-01, -7.366745e-02, -4.343080e-01, -9.092917e-01},
  {-3.524817e-01, -6.116444e-01, -7.082709e-01, -3.457847e-01, -6.192886e-01, -7.198649e-01},
  {-3.105894e-01, -5.875175e-01, -7.472332e-01, -3.253912e-01, -5.945016e-01, -7.493621e-01},
  { 3.246241e-01, -8.221928e-01,  4.675663e-01,  3.201098e-01, -8.407331e-01,  4.599532e-01},
  { 2.709843e-01, -8.994253e-01,  3.429309e-01,  2.741157e-01, -9.064254e-01,  3.522952e-01},
  {-3.038332e-01, -9.106738e-01,  2.799261e-01, -1.704707e-01, -9.649612e-01,  2.462516e-01},
  { 4.145850e-01, -8.125882e-01,  4.096583e-01,  4.264593e-01, -8.236886e-01,  4.013345e-01},
  { 4.468990e-01, -8.149125e-01,  3.690511e-01,  4.466844e-01, -8.228461e-01,  3.798151e-01},
  {-1.077090e-01, -9.706083e-01,  2.152171e-01, -1.195409e-01, -9.822097e-01,  2.045127e-01},
  {-1.426470e-01, -9.657158e-01,  2.168983e-01, -1.482690e-01, -9.755066e-01,  2.173800e-01},
  {-2.934187e-01, -9.156929e-01,  2.746125e-01, -2.942310e-01, -9.251759e-01,  2.798681e-01},
  { 2.669429e-01, -9.269235e-01,  2.637317e-01,  2.645726e-01, -9.372742e-01,  2.690288e-01},
  {-2.043724e-01, -9.513487e-01,  2.305807e-01, -2.123417e-01, -9.618915e-01,  2.247788e-01},
  {-2.005807e-01, -9.648645e-01,  1.697175e-01, -2.069766e-01, -9.719081e-01,  1.827708e-01},
  { 3.342360e-01, -9.108239e-01,  2.422522e-01,  3.323766e-01, -9.239269e-01,  2.382102e-01},
  {-6.144512e-01, -7.853010e-01,  7.584243e-02, -6.264120e-01, -7.899048e-01,  6.710825e-02},
  {-6.480526e-01, -7.600628e-01,  4.829403e-02, -6.568798e-01, -7.659904e-01,  5.111581e-02},
  { 5.055070e-01, -8.564415e-01,  1.047404e-01,  5.176682e-01, -8.615131e-01,  1.033375e-01},
  {-1.693128e-01, -9.850684e-01,  3.119661e-02, -1.517933e-01, -9.987072e-01,  1.983921e-02},
  {-7.165199e-01, -6.975646e-01, -1.656751e-03, -7.231347e-01, -7.054958e-01,  1.402596e-02},
  { 6.580456e-01, -7.507340e-01, -5.808998e-02,  6.639820e-01, -7.601790e-01, -4.608211e-02},
  {-6.971822e-01, -6.884870e-01, -1.998066e-01, -7.027086e-01, -6.980049e-01, -1.995887e-01},
  { 6.721101e-01, -7.320963e-01, -1.109186e-01,  6.824350e-01, -7.366608e-01, -1.117232e-01},
  { 5.082127e-01, -8.122924e-01, -2.861834e-01,  5.140941e-01, -8.229299e-01, -2.853702e-01},
  { 6.765119e-01, -7.199937e-01, -1.547279e-01,  6.881036e-01, -7.233154e-01, -1.555547e-01},
  {-6.674103e-01, -7.009889e-01, -2.513524e-01, -6.699446e-01, -7.102979e-01, -2.598031e-01},
  { 6.630592e-01, -7.068697e-01, -2.463488e-01,  6.684325e-01, -7.174820e-01, -2.434885e-01},
  { 5.483016e-01, -7.183625e-01, -4.281598e-01,  5.527418e-01, -7.328973e-01, -4.229694e-01},
  { 5.565770e-01, -6.721873e-01, -4.882483e-01,  5.665838e-01, -6.730276e-01, -4.968756e-01},
  { 5.690242e-01, -5.892604e-01, -5.735708e-01,  5.791651e-01, -6.016911e-01, -5.686876e-01},
  {-5.724767e-01, -6.365921e-01, -5.167407e-01, -5.644539e-01, -6.507840e-01, -5.279411e-01},
  {-4.796200e-01, -6.929264e-01, -5.383472e-01, -5.108063e-01, -6.147048e-01, -6.181151e-01},
  { 3.788421e-01, -4.330077e-01, -8.179138e-01,  3.919213e-01, -4.709691e-01, -8.034019e-01},
  { 3.649048e-01, -4.519290e-01, -8.140054e-01,  3.689742e-01, -4.555345e-01, -8.229309e-01},
  {-4.195750e-01, -6.112658e-01, -6.710521e-01, -4.417038e-01, -6.262154e-01, -6.584867e-01},
  {-8.188887e-03, -4.155429e-01, -9.095368e-01, -1.553445e-02, -4.164562e-01, -9.204270e-01},
  {-2.851717e-01, -5.175211e-01, -8.067522e-01, -2.886632e-01, -5.190109e-01, -8.174094e-01},
  {-2.726948e-01, -5.432662e-01, -7.940398e-01, -3.897196e-01, -6.585135e-01, -6.610596e-01},
  { 2.984679e-01, -4.427904e-01, -8.454902e-01,  3.076162e-01, -4.463602e-01, -8.526446e-01},
  { 5.497012e-02, -5.219766e-01, -8.511867e-01,  7.207877e-02, -4.356520e-01, -9.087774e-01},
  { 8.366551e-02, -4.161074e-01, -9.054583e-01,  6.875828e-02, -4.293749e-01, -9.132792e-01},
  { 1.514841e-01, -2.832988e-01, -9.469922e-01,  6.074255e-02, -4.190628e-01, -9.173663e-01},
  {-2.712889e-01, -5.169339e-01, -8.119000e-01, -3.920464e-01, -6.546220e-01, -6.622860e-01},
  {-3.696451e-01, -6.395087e-01, -6.740854e-01, -3.765349e-01, -6.449648e-01, -6.805111e-01},
  { 2.469289e-02, -8.892612e-01,  4.567325e-01,  8.938277e-03, -8.982233e-01,  4.625672e-01},
  { 1.828916e-01, -8.860494e-01,  4.259896e-01,  1.808059e-01, -8.971577e-01,  4.281051e-01},
  { 2.151248e-01, -9.053580e-01,  3.661260e-01,  2.232733e-01, -9.119192e-01,  3.733760e-01},
  { 2.735460e-01, -8.441299e-01,  4.611044e-01,  2.787037e-01, -8.520749e-01,  4.659950e-01},
  {-1.069562e-01, -8.976431e-01,  4.275478e-01, -1.077069e-01, -9.082892e-01,  4.319192e-01},
  {-1.268955e-01, -9.157677e-01,  3.811391e-01, -1.357942e-01, -9.218923e-01,  3.905450e-01},
  { 2.016226e-01, -9.293228e-01,  3.093663e-01,  2.057421e-01, -9.362760e-01,  3.192405e-01},
  { 3.633716e-01, -8.145186e-01,  4.522396e-01,  3.579969e-01, -8.259599e-01,  4.587904e-01},
  {-1.422275e-01, -9.766770e-01,  1.608520e-01, -1.257097e-01, -9.875808e-01,  1.724307e-01},
  { 5.155611e-01, -8.001829e-01,  3.064378e-01,  5.266861e-01, -8.032225e-01,  3.135270e-01},
  {-3.536217e-01, -8.983009e-01,  2.607818e-01, -3.413280e-01, -9.140313e-01,  2.624693e-01},
  {-3.248411e-01, -9.202861e-01,  2.180637e-01, -3.362029e-01, -9.324439e-01,  1.958675e-01},
  { 5.288264e-01, -8.115935e-01,  2.483117e-01,  5.377707e-01, -8.167582e-01,  2.541120e-01},
  {-2.070102e-01, -9.685214e-01,  1.382500e-01, -2.103785e-01, -9.780643e-01,  1.413542e-01},
  { 3.856585e-01, -9.000456e-01,  2.029418e-01,  3.976572e-01, -9.052616e-01,  2.079206e-01},
  {-3.425069e-01, -9.254538e-01,  1.619388e-01, -3.466426e-01, -9.346887e-01,  1.644499e-01},
  {-1.029743e-01, -9.884219e-01,  1.114385e-01, -9.840845e-02, -1.000193e+00,  1.038383e-01},
  { 5.474935e-01, -8.157814e-01,  1.864181e-01,  5.400767e-01, -8.343878e-01,  1.815991e-01},
  {-2.167728e-01, -9.721203e-01,  8.939639e-02, -2.224012e-01, -9.815201e-01,  8.947659e-02},
  { 5.114155e-01, -8.449780e-01,  1.564171e-01,  5.148205e-01, -8.546116e-01,  1.595693e-01},
  { 4.724774e-01, -8.701772e-01,  1.398453e-01,  4.810542e-01, -8.766479e-01,  1.446997e-01},
  {-1.272561e-01, -9.898365e-01,  6.347901e-02, -1.405193e-01, -9.987563e-01,  5.992745e-02},
  {-4.584194e-01, -8.772739e-01,  1.422750e-01, -4.586592e-01, -8.881086e-01,  1.474507e-01},
  {-2.355997e-01, -9.709189e-01,  4.253647e-02, -2.389273e-01, -9.807605e-01,  4.327305e-02},
  {-6.770262e-01, -7.342914e-01,  4.951333e-02, -6.763762e-01, -7.479534e-01,  6.265605e-02},
  {-7.175978e-01, -6.938097e-01,  6.067604e-02, -7.312826e-01, -6.968027e-01,  4.880552e-02},
  { 6.356461e-01, -7.719062e-01,  1.071094e-02,  6.424471e-01, -7.798203e-01,  2.975906e-03},
  {-2.355609e-01, -9.717733e-01,  1.295517e-02, -2.398438e-01, -9.813090e-01, -1.890399e-02},
  {-6.298667e-01, -7.546133e-01, -1.839203e-01, -7.261705e-01, -6.914919e-01, -1.307890e-01},
  {-6.676086e-01, -7.378275e-01, -9.954588e-02, -7.461044e-01, -6.732406e-01, -1.045008e-01},
  {-1.891165e-01, -9.819259e-01,  7.513826e-03, -1.831569e-01, -9.936311e-01, -1.206051e-03},
  { 6.951851e-01, -6.996171e-01, -1.650867e-01,  6.995720e-01, -7.094167e-01, -1.679178e-01},
  { 6.328152e-01, -7.205738e-01, -2.834049e-01,  6.445071e-01, -7.270406e-01, -2.772926e-01},
  {-6.667959e-01, -6.833604e-01, -2.973244e-01, -6.790757e-01, -6.869169e-01, -2.963919e-01},
  { 5.343078e-01, -7.513800e-01, -3.872251e-01,  5.499625e-01, -7.554398e-01, -3.843421e-01},
  {-6.508006e-01, -6.808383e-01, -3.360322e-01, -6.497111e-01, -6.943416e-01, -3.414855e-01},
  { 7.107087e-01, -6.361089e-01, -3.004308e-01,  7.141666e-01, -6.453388e-01, -3.072047e-01},
  { 5.684453e-01, -5.527771e-01, -6.093500e-01,  5.717719e-01, -5.612940e-01, -6.155456e-01},
  {-5.971947e-01, -6.038412e-01, -5.279527e-01, -6.073282e-01, -6.102474e-01, -5.287722e-01},
  {-5.851517e-01, -6.732066e-01, -4.520955e-01, -5.996286e-01, -6.698606e-01, -4.610652e-01},
  {-5.996795e-01, -6.481738e-01, -4.693136e-01, -6.057407e-01, -6.559956e-01, -4.728603e-01},
  { 4.702960e-01, -5.027815e-01, -7.252809e-01,  4.846134e-01, -5.030780e-01, -7.300221e-01},
  { 4.328938e-01, -4.845000e-01, -7.601728e-01,  4.327841e-01, -4.887263e-01, -7.711769e-01},
  { 1.798581e-01, -3.837951e-01, -9.057330e-01,  1.853118e-01, -3.858390e-01, -9.152347e-01},
  { 2.898642e-01, -3.969709e-01, -8.708575e-01,  2.946855e-01, -4.207277e-01, -8.700671e-01},
  { 8.654624e-02, -3.633889e-01, -9.276089e-01,  4.304113e-02, -4.012332e-01, -9.262956e-01},
  {-2.213836e-01, -4.827202e-01, -8.473314e-01, -2.273130e-01, -4.810878e-01, -8.589190e-01},
  {-1.664549e-01, -4.441943e-01, -8.803318e-01, -1.584315e-01, -4.450568e-01, -8.931317e-01},
  { 7.167304e-02, -8.840183e-01,  4.619249e-01,  8.662497e-02, -8.869036e-01,  4.761858e-01},
  {-1.197703e-02, -8.664193e-01,  4.991734e-01, -6.168855e-03, -8.834532e-01,  4.902303e-01},
  { 1.978969e-01, -8.587245e-01,  4.726827e-01,  2.067161e-01, -8.641093e-01,  4.810829e-01},
  {-1.827289e-01, -9.260725e-01,  3.301513e-01, -1.905067e-01, -9.304683e-01,  3.446537e-01},
  {-1.672195e-01, -8.896167e-01,  4.249938e-01, -1.548799e-01, -8.984942e-01,  4.353977e-01},
  {-1.819719e-01, -9.088511e-01,  3.753346e-01, -1.893148e-01, -9.189115e-01,  3.749824e-01},
  {-2.297989e-01, -9.111167e-01,  3.421386e-01, -2.370964e-01, -9.199171e-01,  3.440747e-01},
  { 2.997438e-01, -9.029927e-01,  3.078277e-01,  3.011459e-01, -9.131649e-01,  3.103223e-01},
  {-2.672202e-01, -9.063528e-01,  3.272886e-01, -2.732356e-01, -9.118415e-01,  3.387276e-01},
  { 2.452507e-01, -9.232813e-01,  2.956412e-01,  2.526780e-01, -9.314504e-01,  2.990182e-01},
  {-1.752721e-01, -9.657077e-01,  1.915420e-01, -1.809130e-01, -9.750651e-01,  1.933102e-01},
  {-3.015709e-01, -8.936779e-01,  3.322570e-01, -3.003828e-01, -9.048713e-01,  3.344048e-01},
  { 3.020341e-01, -9.114824e-01,  2.792406e-01,  3.006050e-01, -9.214534e-01,  2.853401e-01},
  { 5.532146e-01, -7.868186e-01,  2.736240e-01,  5.580474e-01, -7.944161e-01,  2.799120e-01},
  { 5.652530e-01, -7.935880e-01,  2.251824e-01,  5.736003e-01, -8.010253e-01,  2.240673e-01},
  {-4.052701e-01, -8.998073e-01,  1.615643e-01, -4.111205e-01, -9.083886e-01,  1.632704e-01},
  {-1.847281e-01, -9.816436e-01,  4.744935e-02, -1.984739e-01, -9.894133e-01,  5.019624e-02},
  {-5.088055e-01, -8.501162e-01,  1.357182e-01, -5.214609e-01, -8.540841e-01,  1.395159e-01},
  { 5.502365e-01, -8.299914e-01,  9.140047e-02,  5.529252e-01, -8.398520e-01,  9.892944e-02},
  { 5.948599e-01, -8.021997e-01,  5.116059e-02,  5.922616e-01, -8.161979e-01,  6.255397e-02},
  {-5.586923e-01, -7.789780e-01, -2.847036e-01, -7.285020e-01, -6.856301e-01, -1.415682e-01},
  {-6.466884e-01, -7.528672e-01, -1.224138e-01, -7.446136e-01, -6.722525e-01, -1.202999e-01},
  { 6.937288e-01, -7.175648e-01, -6.197665e-02,  6.912735e-01, -7.340613e-01, -6.452706e-02},
  {-7.832299e-01, -6.213817e-01, -2.087199e-02, -7.948545e-01, -6.232801e-01, -2.393424e-02},
  {-7.066286e-01, -6.717987e-01, -2.221767e-01, -7.159622e-01, -6.761653e-01, -2.259304e-01},
  { 5.330471e-01, -7.762411e-01, -3.366165e-01,  5.401697e-01, -7.859491e-01, -3.337171e-01},
  {-6.995577e-01, -6.629718e-01, -2.666222e-01, -7.087932e-01, -6.699703e-01, -2.638146e-01},
  { 7.037489e-01, -6.769843e-01, -2.154756e-01,  7.137426e-01, -6.803347e-01, -2.204233e-01},
  { 6.643240e-01, -6.859221e-01, -2.969587e-01,  6.690764e-01, -6.943543e-01, -3.017919e-01},
  { 7.049432e-01, -6.598317e-01, -2.601488e-01,  7.213051e-01, -6.560539e-01, -2.649208e-01},
  { 6.733918e-01, -6.579340e-01, -3.371443e-01,  6.874906e-01, -6.659678e-01, -3.235953e-01},
  {-6.479793e-01, -5.712319e-01, -5.038025e-01, -6.655076e-01, -5.637808e-01, -5.099998e-01},
  {-6.416593e-01, -6.013114e-01, -4.761282e-01, -6.460335e-01, -6.100730e-01, -4.809369e-01},
  {-6.122953e-01, -6.094003e-01, -5.037120e-01, -6.179791e-01, -6.150472e-01, -5.105566e-01},
  {-6.102654e-01, -6.317452e-01, -4.779899e-01, -6.191959e-01, -6.406978e-01, -4.763942e-01},
  { 5.979834e-01, -6.157157e-01, -5.131373e-01,  5.977917e-01, -6.211390e-01, -5.269737e-01},
  {-6.316032e-01, -6.673524e-01, -3.946113e-01, -6.399038e-01, -6.690651e-01, -4.046271e-01},
  {-6.223471e-01, -6.566702e-01, -4.259910e-01, -6.292565e-01, -6.656480e-01, -4.263768e-01},
  {-4.391031e-01, -8.034679e-01, -4.020298e-01, -5.551096e-01, -6.081505e-01, -5.861950e-01},
  { 4.928038e-01, -4.845650e-01, -7.227317e-01,  4.946702e-01, -4.926059e-01, -7.304184e-01},
  { 2.443550e-01, -3.956058e-01, -8.853173e-01,  2.538037e-01, -4.065336e-01, -8.897724e-01},
  {-4.718694e-01, -5.938291e-01, -6.516950e-01, -4.873829e-01, -6.019388e-01, -6.488295e-01},
  {-4.190899e-01, -5.976766e-01, -6.834809e-01, -4.297937e-01, -6.014243e-01, -6.887810e-01},
  {-2.657345e-01, -4.881141e-01, -8.313421e-01, -2.692319e-01, -4.918320e-01, -8.405194e-01},
  { 1.560942e-01, -8.658483e-01,  4.753329e-01,  1.612694e-01, -8.771014e-01,  4.749122e-01},
  { 1.095366e-01, -8.695163e-01,  4.816046e-01,  1.049406e-01, -8.781120e-01,  4.886328e-01},
  {-2.618138e-02, -8.929797e-01,  4.493347e-01, -3.109485e-02, -8.942469e-01,  4.692636e-01},
  {-6.631546e-02, -8.821554e-01,  4.662661e-01, -6.378963e-02, -8.955908e-01,  4.633577e-01},
  { 2.287597e-01, -8.402947e-01,  4.915016e-01,  2.236842e-01, -8.511586e-01,  4.963385e-01},
  { 4.876470e-01, -7.944454e-01,  3.620179e-01,  4.956219e-01, -7.996468e-01,  3.684928e-01},
  { 5.560042e-01, -7.717321e-01,  3.086892e-01,  5.550608e-01, -7.836713e-01,  3.140565e-01},
  { 5.903971e-01, -7.613312e-01,  2.679665e-01,  5.967371e-01, -7.711616e-01,  2.647265e-01},
  {-1.675321e-01, -9.794645e-01,  1.121706e-01, -1.793602e-01, -9.868633e-01,  1.215779e-01},
  {-3.808221e-01, -9.038949e-01,  1.948039e-01, -3.819180e-01, -9.140537e-01,  1.987260e-01},
  {-3.841867e-01, -8.927535e-01,  2.353545e-01, -3.951510e-01, -9.005650e-01,  2.317016e-01},
  { 5.960158e-01, -7.762149e-01,  2.055619e-01,  6.007313e-01, -7.828637e-01,  2.170531e-01},
  {-4.225660e-01, -8.675787e-01,  2.621929e-01, -4.390805e-01, -8.741406e-01,  2.528505e-01},
  { 5.528119e-01, -8.220769e-01,  1.363399e-01,  5.627322e-01, -8.279387e-01,  1.368022e-01},
  {-5.660952e-01, -8.121006e-01,  1.415225e-01, -5.702237e-01, -8.223466e-01,  1.394159e-01},
  { 6.280153e-01, -7.765021e-01,  5.139372e-02,  6.351445e-01, -7.846023e-01,  4.309756e-02},
  {-6.387003e-01, -7.433267e-01, -1.988145e-01, -7.371305e-01, -6.699065e-01, -1.694380e-01},
  {-7.635001e-01, -6.374063e-01, -1.038317e-01, -7.759572e-01, -6.375926e-01, -1.105041e-01},
  {-7.842297e-01, -6.172856e-01, -6.278749e-02, -7.966686e-01, -6.172820e-01, -7.160144e-02},
  { 5.484191e-01, -7.839325e-01, -2.910089e-01,  5.544562e-01, -7.915186e-01, -2.948612e-01},
  { 7.197998e-01, -6.763832e-01, -1.561862e-01,  7.236180e-01, -6.849950e-01, -1.674190e-01},
  {-7.391098e-01, -6.337865e-01, -2.281040e-01, -7.390378e-01, -6.475899e-01, -2.351518e-01},
  { 6.415696e-01, -7.060372e-01, -2.998332e-01,  6.508303e-01, -7.136157e-01, -2.967177e-01},
  { 6.437914e-01, -6.906356e-01, -3.294772e-01,  6.591735e-01, -6.898701e-01, -3.323236e-01},
  { 7.378896e-01, -6.213199e-01, -2.635919e-01,  7.406768e-01, -6.345691e-01, -2.638013e-01},
  {-6.891823e-01, -6.475320e-01, -3.251614e-01, -7.000526e-01, -6.459071e-01, -3.370122e-01},
  { 7.037447e-01, -6.177686e-01, -3.508636e-01,  7.122424e-01, -6.298454e-01, -3.418722e-01},
  { 5.735855e-01, -6.831951e-01, -4.519338e-01,  5.833028e-01, -6.846973e-01, -4.602348e-01},
  {-6.590362e-01, -6.574914e-01, -3.652073e-01, -6.688153e-01, -6.615660e-01, -3.685973e-01},
  { 5.776095e-01, -5.479363e-01, -6.050893e-01,  5.969025e-01, -5.570755e-01, -5.951849e-01},
  {-6.419231e-01, -6.280302e-01, -4.399008e-01, -6.505320e-01, -6.343783e-01, -4.418377e-01},
  {-6.193491e-01, -5.700649e-01, -5.398452e-01, -6.189433e-01, -5.800422e-01, -5.489171e-01},
  {-5.951774e-01, -5.886089e-01, -5.470864e-01, -5.982227e-01, -5.980623e-01, -5.525405e-01},
  {-5.232164e-01, -6.896178e-01, -5.006715e-01, -5.687622e-01, -6.059098e-01, -5.746592e-01},
  { 5.593582e-01, -5.203505e-01, -6.452548e-01,  5.597534e-01, -5.159169e-01, -6.643619e-01},
  { 3.669643e-01, -4.113301e-01, -8.343529e-01,  3.735683e-01, -4.247901e-01, -8.371794e-01},
  { 1.292007e-01, -3.601949e-01, -9.238868e-01,  1.248058e-01, -3.663694e-01, -9.333075e-01},
  {-3.089201e-01, -4.807606e-01, -8.206325e-01, -3.145745e-01, -4.910000e-01, -8.251173e-01},
  { 3.193775e-01, -3.975796e-01, -8.601909e-01,  3.257157e-01, -4.101884e-01, -8.640159e-01},
  {-3.101078e-01, -5.107048e-01, -8.018814e-01, -3.633740e-01, -5.522147e-01, -7.641160e-01},
  {-5.864263e-02, -3.947644e-01, -9.169090e-01, -6.422977e-02, -3.975342e-01, -9.266626e-01},
  {-3.597355e-01, -5.673421e-01, -7.407519e-01, -3.625116e-01, -5.724170e-01, -7.495192e-01},
  { 2.677678e-01, -6.552012e-01,  7.064077e-01,  2.626836e-01, -6.534399e-01,  7.244814e-01},
  { 2.642582e-02, -8.645248e-01,  5.018950e-01,  2.745390e-02, -8.677770e-01,  5.167816e-01},
  {-6.050128e-02, -8.625036e-01,  5.024212e-01, -5.720263e-02, -8.646751e-01,  5.195356e-01},
  { 6.465489e-02, -8.572121e-01,  5.108886e-01,  6.041591e-02, -8.686239e-01,  5.125398e-01},
  { 4.083428e-01, -7.899124e-01,  4.574871e-01,  4.108537e-01, -7.995400e-01,  4.612988e-01},
  {-2.202440e-01, -8.842482e-01,  4.118223e-01, -2.170582e-01, -8.939617e-01,  4.178133e-01},
  { 5.322491e-01, -7.715705e-01,  3.484103e-01,  5.334280e-01, -7.853429e-01,  3.457676e-01},
  {-3.377559e-01, -8.893951e-01,  3.080542e-01, -3.468260e-01, -8.989149e-01,  3.041570e-01},
  {-3.856690e-01, -8.752505e-01,  2.918836e-01, -3.813166e-01, -8.828357e-01,  3.099132e-01},
  { 6.332120e-01, -7.376370e-01,  2.343802e-01,  6.315612e-01, -7.526215e-01,  2.357066e-01},
  { 5.862707e-01, -7.939391e-01,  1.610816e-01,  5.971046e-01, -7.968708e-01,  1.712556e-01},
  { 6.162377e-01, -7.693087e-01,  1.685679e-01,  6.211131e-01, -7.793389e-01,  1.664799e-01},
  {-4.478589e-01, -8.874354e-01,  1.089992e-01, -4.507030e-01, -8.852553e-01,  1.844897e-01},
  {-7.573879e-01, -6.516742e-01,  4.103945e-02, -7.685751e-01, -6.542721e-01,  4.543899e-02},
  {-4.633089e-01, -8.850837e-01,  4.440515e-02, -4.881138e-01, -8.666519e-01,  1.774987e-01},
  {-5.984122e-01, -7.920709e-01,  1.205263e-01, -6.012481e-01, -8.020252e-01,  1.268920e-01},
  {-4.955406e-01, -8.591139e-01,  1.279173e-01, -5.138456e-01, -8.531078e-01,  1.703407e-01},
  { 6.765817e-01, -7.363340e-01, -7.026532e-03,  6.882601e-01, -7.397060e-01, -1.230835e-03},
  {-8.142319e-01, -5.790778e-01, -4.117547e-02, -8.187320e-01, -5.909742e-01, -3.566393e-02},
  { 7.109459e-01, -6.946260e-01, -1.097753e-01,  7.198610e-01, -7.011398e-01, -1.052273e-01},
  { 5.873717e-01, -7.507300e-01, -3.023224e-01,  5.948145e-01, -7.575908e-01, -3.082719e-01},
  {-8.219008e-01, -5.648208e-01, -7.386882e-02, -8.273694e-01, -5.741475e-01, -8.160440e-02},
  { 7.402186e-01, -6.473706e-01, -1.816249e-01,  7.375467e-01, -6.657243e-01, -1.835936e-01},
  { 7.406594e-01, -6.336808e-01, -2.233211e-01,  7.468029e-01, -6.429205e-01, -2.231812e-01},
  {-7.281301e-01, -6.226556e-01, -2.865771e-01, -7.372062e-01, -6.309481e-01, -2.829737e-01},
  {-6.797153e-01, -5.851959e-01, -4.421911e-01, -6.844251e-01, -5.857279e-01, -4.575297e-01},
  {-6.490022e-01, -5.355433e-01, -5.403606e-01, -6.575761e-01, -5.454625e-01, -5.393642e-01},
  { 7.285956e-01, -5.919366e-01, -3.446149e-01,  7.392847e-01, -5.944102e-01, -3.478599e-01},
  { 6.126784e-01, -5.653284e-01, -5.522943e-01,  6.155485e-01, -5.691637e-01, -5.639358e-01},
  {-5.958246e-01, -5.422855e-01, -5.923845e-01, -5.996835e-01, -5.553331e-01, -5.939994e-01},
  {-5.496716e-01, -5.850015e-01, -5.963509e-01, -5.694808e-01, -5.623057e-01, -6.167293e-01},
  {-5.240015e-01, -5.704371e-01, -6.324745e-01, -5.450874e-01, -5.578339e-01, -6.428505e-01},
  { 5.431117e-01, -4.829728e-01, -6.868529e-01,  5.453218e-01, -4.875036e-01, -6.975124e-01},
  { 4.079190e-01, -3.780712e-01, -8.310621e-01,  4.311707e-01, -4.534684e-01, -7.933019e-01},
  { 4.832337e-01, -4.552113e-01, -7.478421e-01,  4.865014e-01, -4.652012e-01, -7.535083e-01},
  { 2.585875e-01, -3.682278e-01, -8.930513e-01,  2.254695e-01, -3.616453e-01, -9.161026e-01},
  {-3.337081e-01, -4.869061e-01, -8.071935e-01, -3.375054e-01, -4.929785e-01, -8.148121e-01},
  { 8.394364e-02, -3.611245e-01, -9.287317e-01,  8.901366e-02, -3.661480e-01, -9.377311e-01},
  {-1.074301e-01, -4.017196e-01, -9.094394e-01, -1.075999e-01, -3.993353e-01, -9.218542e-01},
  {-2.160911e-01, -4.286396e-01, -8.772530e-01, -2.147529e-01, -4.356468e-01, -8.859754e-01},
  { 2.084802e-01, -6.747901e-01,  7.079508e-01,  2.140601e-01, -6.756625e-01,  7.200813e-01},
  { 3.897690e-01, -7.352285e-01,  5.545441e-01,  3.941424e-01, -7.459556e-01,  5.559347e-01},
  { 1.193174e-01, -8.454647e-01,  5.205313e-01,  1.171863e-01, -8.569243e-01,  5.223061e-01},
  {-1.028835e-01, -8.493754e-01,  5.176645e-01, -1.046336e-01, -8.510635e-01,  5.344104e-01},
  { 1.718702e-01, -8.336483e-01,  5.248724e-01,  1.837514e-01, -8.376066e-01,  5.343289e-01},
  {-1.184094e-01, -8.716973e-01,  4.755239e-01, -1.313968e-01, -8.849925e-01,  4.694405e-01},
  {-1.424424e-01, -8.597000e-01,  4.905365e-01, -1.343310e-01, -8.732303e-01,  4.901790e-01},
  { 3.045177e-01, -8.095777e-01,  5.018496e-01,  3.104926e-01, -8.181633e-01,  5.050372e-01},
  { 2.670684e-01, -8.079755e-01,  5.252143e-01,  2.659058e-01, -8.227718e-01,  5.226847e-01},
  { 4.604901e-01, -7.834877e-01,  4.172480e-01,  4.742780e-01, -7.852441e-01,  4.234560e-01},
  {-2.706432e-01, -8.856951e-01,  3.772219e-01, -2.750725e-01, -8.912821e-01,  3.883303e-01},
  {-3.225825e-01, -8.737488e-01,  3.640104e-01, -3.329156e-01, -8.795736e-01,  3.692772e-01},
  {-7.183338e-01, -6.771867e-01,  1.594203e-01, -7.236323e-01, -6.857441e-01,  1.641820e-01},
  { 6.443729e-01, -7.368223e-01,  2.046375e-01,  6.510800e-01, -7.449568e-01,  2.049420e-01},
  {-4.287024e-01, -8.792016e-01,  2.078912e-01, -4.434308e-01, -8.829042e-01,  2.114145e-01},
  { 6.441825e-01, -7.490703e-01,  1.546692e-01,  6.473892e-01, -7.595603e-01,  1.575505e-01},
  {-4.757451e-01, -8.501355e-01,  2.256905e-01, -4.750369e-01, -8.604494e-01,  2.341219e-01},
  {-7.440840e-01, -6.599838e-01,  1.037322e-01, -7.436705e-01, -6.762894e-01,  1.021337e-01},
  { 6.303508e-01, -7.666581e-01,  1.220382e-01,  6.227064e-01, -7.881763e-01,  1.090011e-01},
  {-5.528150e-01, -8.179507e-01,  1.592238e-01, -5.470888e-01, -8.335135e-01,  1.636911e-01},
  {-6.401627e-01, -7.581153e-01,  1.243095e-01, -6.458110e-01, -7.665067e-01,  1.274382e-01},
  {-7.777582e-01, -6.280841e-01,  2.454701e-02, -7.863631e-01, -6.335621e-01,  3.281168e-02},
  {-7.560170e-01, -6.363102e-01, -1.534518e-01, -7.703426e-01, -6.341295e-01, -1.590511e-01},
  {-7.945408e-01, -5.953326e-01, -1.195155e-01, -8.014182e-01, -6.036906e-01, -1.220396e-01},
  { 5.726642e-01, -7.353282e-01, -3.624198e-01,  5.711650e-01, -7.508429e-01, -3.617637e-01},
  {-7.187123e-01, -6.060138e-01, -3.408811e-01, -7.205828e-01, -6.228767e-01, -3.370932e-01},
  { 7.481875e-01, -5.943266e-01, -2.949431e-01,  7.512056e-01, -6.037546e-01, -3.033848e-01},
  {-6.915503e-01, -6.150993e-01, -3.786965e-01, -6.989011e-01, -6.247243e-01, -3.769671e-01},
  {-6.773018e-01, -5.252827e-01, -5.151119e-01, -6.798126e-01, -5.356306e-01, -5.213481e-01},
  {-6.638716e-01, -6.289699e-01, -4.045632e-01, -6.736387e-01, -6.383570e-01, -3.994481e-01},
  { 1.999620e-01, -3.315077e-01, -9.220183e-01,  1.911605e-01, -3.418912e-01, -9.313622e-01},
  {-3.610988e-01, -5.029406e-01, -7.852759e-01, -3.658819e-01, -5.041415e-01, -7.955045e-01},
  {-4.053369e-01, -5.694246e-01, -7.151627e-01, -4.068473e-01, -5.780987e-01, -7.218941e-01},
  { 3.034837e-01, -3.885316e-01, -8.700235e-01,  3.229545e-01, -3.852393e-01, -8.764474e-01},
  {-2.474678e-01, -4.261539e-01, -8.701451e-01, -3.833591e-01, -5.357158e-01, -7.673565e-01},
  {-5.881253e-03, -3.668068e-01, -9.302785e-01, -9.768823e-04, -3.733164e-01, -9.391320e-01},
  {-2.641935e-01, -4.476075e-01, -8.543122e-01, -2.722036e-01, -4.580096e-01, -8.584815e-01},
  {-4.814310e-02, -3.434082e-01, -9.379515e-01, -5.437730e-02, -3.504407e-01, -9.460960e-01},
  { 2.224005e-01, -6.226041e-01,  7.502680e-01,  2.423761e-01, -6.328263e-01,  7.494293e-01},
  { 3.082596e-01, -6.580502e-01,  6.869832e-01,  3.108319e-01, -6.601462e-01,  6.988928e-01},
  { 1.820156e-01, -6.454794e-01,  7.417726e-01,  1.755908e-01, -6.496977e-01,  7.536040e-01},
  { 3.354362e-01, -7.273352e-01,  5.987203e-01,  3.465684e-01, -7.310026e-01,  6.052985e-01},
  {-5.243848e-02, -8.369413e-01,  5.447747e-01, -5.779087e-02, -8.485618e-01,  5.453951e-01},
  {-1.579721e-02, -8.428897e-01,  5.378544e-01, -1.779192e-02, -8.496115e-01,  5.465319e-01},
  { 1.025501e-01, -8.218160e-01,  5.604481e-01,  2.059034e-02, -8.421183e-01,  5.579129e-01},
  { 3.918622e-01, -7.651199e-01,  5.109164e-01,  3.924317e-01, -7.701498e-01,  5.231902e-01},
  { 3.454894e-01, -7.812063e-01,  5.199557e-01,  3.427747e-01, -7.942425e-01,  5.220580e-01},
  { 3.633180e-01, -7.921225e-01,  4.904507e-01,  3.757094e-01, -7.919793e-01,  5.024661e-01},
  { 4.340506e-01, -7.678415e-01,  4.711896e-01,  4.407571e-01, -7.749487e-01,  4.754471e-01},
  {-1.845500e-01, -8.703121e-01,  4.566161e-01, -1.997088e-01, -8.767334e-01,  4.607660e-01},
  { 5.083940e-01, -7.612337e-01,  4.025652e-01,  5.058835e-01, -7.785096e-01,  3.985828e-01},
  {-2.547275e-01, -8.587077e-01,  4.446740e-01, -2.557521e-01, -8.686514e-01,  4.482019e-01},
  {-2.800315e-01, -8.639133e-01,  4.186122e-01, -2.743657e-01, -8.762508e-01,  4.216126e-01},
  {-3.234573e-01, -8.551657e-01,  4.050518e-01, -3.224965e-01, -8.671362e-01,  4.061024e-01},
  {-7.498024e-01, -6.402408e-01,  1.669976e-01, -7.575682e-01, -6.489267e-01,  1.665557e-01},
  { 6.375247e-01, -7.289578e-01,  2.493648e-01,  6.344209e-01, -7.409329e-01,  2.634293e-01},
  {-4.256853e-01, -8.488182e-01,  3.135279e-01, -4.419730e-01, -8.537459e-01,  3.108450e-01},
  {-4.718779e-01, -8.324223e-01,  2.905246e-01, -4.689884e-01, -8.432613e-01,  2.996775e-01},
  {-6.900384e-01, -7.049035e-01,  1.641890e-01, -6.976543e-01, -7.099094e-01,  1.736424e-01},
  {-7.100486e-01, -6.931525e-01,  1.239786e-01, -7.203732e-01, -6.970851e-01,  1.264094e-01},
  { 6.752726e-01, -7.270998e-01,  1.238254e-01,  6.775559e-01, -7.371854e-01,  1.354378e-01},
  { 5.819850e-01, -8.065112e-01,  1.040827e-01,  6.037875e-01, -8.036792e-01,  1.020114e-01},
  { 6.589183e-01, -7.420949e-01,  1.229707e-01,  6.645395e-01, -7.560855e-01,  8.711772e-02},
  {-6.798533e-01, -7.237117e-01,  1.184938e-01, -6.869789e-01, -7.316590e-01,  1.165321e-01},
  { 6.672037e-01, -7.434435e-01,  4.616215e-02,  6.723201e-01, -7.519560e-01,  5.844241e-02},
  {-8.021311e-01, -5.969825e-01,  1.405589e-02, -8.098618e-01, -6.038761e-01,  1.737836e-02},
  {-8.253537e-01, -5.646086e-01, -2.869563e-03, -8.306251e-01, -5.758263e-01, -7.580884e-03},
  {-7.602643e-01, -6.199279e-01, -1.941328e-01, -7.725857e-01, -6.229622e-01, -1.944857e-01},
  {-8.395119e-01, -5.350069e-01, -9.480108e-02, -8.426962e-01, -5.492286e-01, -9.516262e-02},
  { 6.041907e-01, -7.222393e-01, -3.366363e-01,  5.925591e-01, -7.403249e-01, -3.487988e-01},
  { 6.230201e-01, -6.928961e-01, -3.629614e-01,  6.344129e-01, -6.972630e-01, -3.636118e-01},
  {-6.986217e-01, -5.382411e-01, -4.714068e-01, -7.093629e-01, -5.433709e-01, -4.715938e-01},
  { 6.212150e-01, -6.017751e-01, -5.019547e-01,  6.367424e-01, -5.984382e-01, -5.072490e-01},
  {-6.287293e-01, -5.215969e-01, -5.767462e-01, -6.317698e-01, -5.279405e-01, -5.856586e-01},
  { 4.490758e-01, -3.830661e-01, -8.072121e-01,  4.639454e-01, -4.347157e-01, -7.852690e-01},
  { 5.407990e-01, -4.534904e-01, -7.084370e-01,  5.472358e-01, -4.561533e-01, -7.164696e-01},
  { 4.217810e-01, -4.266288e-01, -8.000554e-01,  4.393309e-01, -4.312345e-01, -8.011838e-01},
  {-4.872464e-01, -5.863572e-01, -6.471292e-01, -5.038415e-01, -5.602961e-01, -6.731007e-01},
  {-4.454419e-01, -5.711740e-01, -6.894503e-01, -4.360441e-01, -5.707092e-01, -7.106405e-01},
  { 5.779209e-01, -7.650737e-01,  2.840242e-01, -4.347034e-01, -5.705202e-01, -7.116130e-01},
  { 4.292888e-01,  5.660671e-01,  7.037608e-01, -4.333746e-01, -5.713735e-01, -7.117389e-01},
  {-4.266514e-01, -5.443850e-01, -7.222281e-01, -4.342556e-01, -5.697192e-01, -7.125276e-01},
  { 4.128893e-01, -3.957316e-01, -8.203164e-01,  4.099855e-01, -4.041734e-01, -8.303167e-01},
  { 2.996203e-01, -3.623153e-01, -8.825845e-01,  3.146362e-01, -3.659903e-01, -8.876510e-01},
  {-4.158827e-01, -5.466200e-01, -7.268068e-01, -4.058053e-01, -5.306879e-01, -7.579888e-01},
  {-2.402535e-01, -4.183313e-01, -8.759435e-01, -3.871183e-01, -5.290011e-01, -7.688643e-01},
  { 3.533840e-02, -3.601168e-01, -9.322377e-01,  3.227201e-02, -3.543741e-01, -9.456437e-01},
  { 2.100583e-02, -3.243339e-01, -9.457094e-01,  3.113367e-02, -3.242707e-01, -9.564226e-01},
  {-7.160536e-02, -4.851110e-01, -8.715159e-01, -1.265401e-01, -3.858418e-01, -9.251893e-01},
  {-1.351495e-01, -2.597709e-01, -9.561661e-01, -1.408446e-01, -3.893004e-01, -9.216665e-01},
  {-7.975022e-02, -4.945725e-01, -8.654698e-01, -1.514506e-01, -3.941020e-01, -9.191995e-01},
  {-1.223824e-01, -5.150974e-01, -8.483496e-01, -1.609093e-01, -3.970619e-01, -9.150468e-01},
  { 3.065292e-01, -6.235058e-01,  7.192220e-01,  3.008604e-01, -6.363688e-01,  7.248299e-01},
  { 3.189393e-01, -6.806378e-01,  6.595528e-01,  3.334534e-01, -6.892456e-01,  6.592495e-01},
  { 1.364346e-01, -6.414950e-01,  7.548971e-01,  1.401602e-01, -6.477715e-01,  7.626302e-01},
  { 2.865278e-01, -6.923877e-01,  6.621942e-01,  3.042430e-01, -6.980690e-01,  6.640753e-01},
  { 2.434174e-01, -6.857359e-01,  6.859404e-01,  2.412284e-01, -6.938352e-01,  6.937294e-01},
  { 3.621871e-01, -6.866813e-01,  6.303090e-01,  3.623991e-01, -6.987198e-01,  6.334972e-01},
  { 1.539126e-01, -6.775484e-01,  7.191934e-01,  1.714656e-01, -6.869792e-01,  7.207752e-01},
  { 3.866345e-01, -7.107782e-01,  5.876292e-01,  3.911062e-01, -7.117245e-01,  6.011206e-01},
  { 4.229776e-01, -7.140208e-01,  5.579105e-01,  4.189870e-01, -7.283323e-01,  5.611096e-01},
  { 3.408951e-01, -7.462621e-01,  5.717371e-01,  3.411677e-01, -7.545046e-01,  5.789541e-01},
  { 3.050068e-01, -7.735583e-01,  5.554982e-01,  3.159431e-01, -7.775791e-01,  5.625036e-01},
  { 7.253012e-02, -8.311087e-01,  5.513598e-01,  7.748738e-02, -8.404815e-01,  5.553753e-01},
  {-1.505189e-01, -8.218825e-01,  5.494117e-01, -1.573296e-01, -8.329341e-01,  5.504673e-01},
  {-1.634258e-01, -8.385238e-01,  5.197786e-01, -1.668027e-01, -8.411670e-01,  5.342901e-01},
  {-1.899730e-01, -8.360148e-01,  5.147712e-01, -1.909651e-01, -8.446401e-01,  5.205438e-01},
  { 2.193445e-01, -8.124204e-01,  5.402416e-01,  2.304513e-01, -8.180208e-01,  5.464357e-01},
  {-1.956047e-01, -8.471074e-01,  4.941132e-01, -1.900149e-01, -8.611551e-01,  4.931092e-01},
  { 4.775618e-01, -7.504011e-01,  4.569824e-01,  4.796356e-01, -7.613150e-01,  4.595782e-01},
  {-2.290358e-01, -8.547475e-01,  4.657781e-01, -2.286817e-01, -8.640348e-01,  4.711668e-01},
  { 5.495543e-01, -7.236137e-01,  4.175800e-01,  5.468720e-01, -7.374953e-01,  4.217773e-01},
  { 5.501307e-01, -7.458480e-01,  3.755889e-01,  5.606652e-01, -7.464280e-01,  3.864770e-01},
  {-7.276491e-01, -6.481207e-01,  2.246468e-01, -7.288261e-01, -6.644740e-01,  2.193887e-01},
  {-3.759841e-01, -8.634378e-01,  3.363199e-01, -3.758453e-01, -8.737887e-01,  3.407069e-01},
  { 5.846277e-01, -7.400395e-01,  3.324936e-01,  5.892628e-01, -7.522645e-01,  3.282270e-01},
  {-3.659730e-01, -8.498749e-01,  3.791786e-01, -3.757606e-01, -8.567486e-01,  3.822404e-01},
  {-7.572787e-01, -6.426398e-01,  1.163744e-01, -7.664243e-01, -6.452329e-01,  1.308149e-01},
  { 6.804676e-01, -7.103294e-01,  1.799886e-01,  6.864716e-01, -7.196410e-01,  1.781616e-01},
  {-6.597106e-01, -7.311046e-01,  1.739770e-01, -6.677281e-01, -7.354431e-01,  1.846815e-01},
  {-5.092965e-01, -8.239421e-01,  2.484684e-01, -5.187232e-01, -8.301430e-01,  2.502693e-01},
  { 7.054655e-01, -7.082739e-01,  2.581486e-02,  7.085574e-01, -7.198578e-01,  2.489985e-02},
  {-7.728080e-01, -5.881954e-01, -2.383149e-01, -7.775373e-01, -6.063150e-01, -2.205982e-01},
  { 6.267955e-01, -6.844774e-01, -3.723145e-01,  6.412650e-01, -6.832615e-01, -3.778920e-01},
  { 5.874293e-01, -7.068919e-01, -3.939932e-01,  5.902918e-01, -7.168763e-01, -3.981360e-01},
  { 6.852430e-01, -6.195457e-01, -3.828906e-01,  6.847939e-01, -6.289529e-01, -3.954065e-01},
  {-7.173585e-01, -5.487700e-01, -4.292415e-01, -7.209539e-01, -5.537446e-01, -4.409539e-01},
  { 7.483932e-01, -5.509127e-01, -3.693275e-01,  7.531413e-01, -5.588346e-01, -3.759716e-01},
  { 6.184433e-01, -5.136282e-01, -5.947386e-01,  6.243628e-01, -5.167999e-01, -6.032916e-01},
  { 5.818810e-01, -5.066103e-01, -6.362079e-01,  5.944225e-01, -5.040892e-01, -6.436148e-01},
  { 5.551818e-01, -5.074483e-01, -6.589912e-01,  5.860383e-01, -4.935697e-01, -6.586499e-01},
  { 2.585790e-01, -3.391375e-01, -9.045014e-01,  2.617306e-01, -3.344297e-01, -9.168001e-01},
  { 1.579822e-01, -3.315720e-01, -9.301084e-01,  1.627603e-01, -3.252042e-01, -9.426656e-01},
  {-3.759503e-01, -4.712351e-01, -7.978714e-01, -4.067078e-01, -5.076507e-01, -7.731329e-01},
  { 8.701380e-02, -3.277740e-01, -9.407405e-01,  8.956902e-02, -3.334619e-01, -9.495506e-01},
  { 2.932632e-01, -6.367139e-01,  7.131564e-01,  1.715669e-01, -6.277081e-01,  7.729202e-01},
  { 3.120373e-01, -7.151139e-01,  6.254956e-01,  3.124861e-01, -7.244117e-01,  6.312211e-01},
  {-1.062187e-01, -8.193032e-01,  5.634359e-01, -1.095704e-01, -8.279940e-01,  5.685704e-01},
  { 4.376075e-01, -7.416852e-01,  5.083333e-01,  4.348153e-01, -7.495759e-01,  5.195516e-01},
  { 2.516753e-01, -7.447661e-01,  6.180478e-01,  1.367850e-02, -8.282877e-01,  5.802559e-01},
  {-1.953895e-01, -8.062996e-01,  5.583044e-01, -1.970263e-01, -8.140091e-01,  5.651729e-01},
  { 1.970053e-01, -7.553318e-01,  6.250302e-01,  1.305209e-02, -8.232881e-01,  5.855599e-01},
  { 5.048484e-01, -7.286828e-01,  4.627629e-01,  5.092300e-01, -7.343322e-01,  4.714922e-01},
  { 5.838136e-01, -7.165877e-01,  3.816592e-01,  5.874872e-01, -7.278218e-01,  3.820989e-01},
  {-6.813108e-01, -6.920162e-01,  2.385981e-01, -6.922525e-01, -6.936024e-01,  2.460625e-01},
  { 6.234280e-01, -7.230685e-01,  2.975053e-01,  6.298724e-01, -7.291697e-01,  3.040373e-01},
  {-3.677520e-01, -8.268360e-01,  4.255593e-01, -3.781486e-01, -8.383164e-01,  4.184220e-01},
  {-6.789354e-01, -7.040811e-01,  2.081261e-01, -6.864872e-01, -7.117659e-01,  2.072901e-01},
  {-5.075723e-01, -8.068879e-01,  3.021626e-01, -5.098205e-01, -8.155826e-01,  3.094419e-01},
  {-7.796773e-01, -6.206054e-01,  8.337963e-02, -7.930585e-01, -6.213498e-01,  7.633391e-02},
  {-8.095811e-01, -5.843418e-01,  5.588410e-02, -8.172240e-01, -5.928676e-01,  5.966510e-02},
  { 6.913791e-01, -7.153527e-01,  1.013191e-01,  7.058582e-01, -7.183889e-01,  8.093277e-02},
  {-5.948084e-01, -7.849571e-01,  1.733362e-01, -6.114081e-01, -7.855153e-01,  1.731794e-01},
  { 7.257600e-01, -6.872558e-01, -3.084946e-02,  7.361587e-01, -6.909987e-01, -3.822409e-02},
  {-7.975498e-01, -5.755402e-01, -1.807425e-01, -8.070642e-01, -5.834140e-01, -1.727926e-01},
  { 7.395610e-01, -6.693501e-01, -7.085202e-02,  7.478953e-01, -6.750380e-01, -7.646327e-02},
  {-8.276070e-01, -5.444784e-01, -1.364185e-01, -8.347475e-01, -5.507385e-01, -1.439750e-01},
  {-8.507774e-01, -5.231206e-01, -5.022377e-02, -8.652207e-01, -5.192068e-01, -5.159453e-02},
  { 7.386908e-01, -6.645932e-01, -1.124805e-01,  7.536755e-01, -6.656818e-01, -9.854779e-02},
  { 7.604193e-01, -6.351699e-01, -1.353576e-01,  7.691370e-01, -6.403853e-01, -1.385864e-01},
  {-8.668497e-01, -4.918256e-01, -8.172679e-02, -8.710696e-01, -5.046200e-01, -8.626199e-02},
  { 7.684739e-01, -6.089590e-01, -1.965112e-01,  7.826119e-01, -6.071337e-01, -1.994474e-01},
  {-7.645608e-01, -5.826228e-01, -2.756762e-01, -7.686166e-01, -5.890759e-01, -2.882092e-01},
  {-8.610681e-01, -4.955231e-01, -1.140993e-01, -8.726135e-01, -4.990855e-01, -1.015092e-01},
  { 7.754510e-01, -5.830640e-01, -2.423059e-01,  7.874257e-01, -5.860639e-01, -2.395042e-01},
  {-7.518620e-01, -5.770206e-01, -3.189836e-01, -7.619044e-01, -5.820427e-01, -3.187076e-01},
  { 6.474028e-01, -6.546608e-01, -3.902420e-01,  6.514264e-01, -6.631934e-01, -3.979093e-01},
  {-7.489432e-01, -5.612318e-01, -3.522826e-01, -7.485718e-01, -5.706202e-01, -3.672600e-01},
  { 7.668661e-01, -5.515525e-01, -3.281863e-01,  7.720416e-01, -5.631391e-01, -3.281750e-01},
  { 6.105319e-01, -6.400561e-01, -4.664538e-01,  6.230698e-01, -6.462191e-01, -4.637398e-01},
  {-5.845324e-01, -5.103924e-01, -6.307309e-01, -5.853076e-01, -5.128913e-01, -6.443671e-01},
  { 6.504096e-01, -5.426165e-01, -5.315399e-01,  6.541902e-01, -5.449212e-01, -5.440292e-01},
  { 6.352904e-01, -5.234654e-01, -5.677940e-01,  6.455340e-01, -5.336238e-01, -5.651577e-01},
  {-5.043537e-01, -5.191615e-01, -6.899990e-01, -5.002229e-01, -5.303851e-01, -6.995152e-01},
  { 5.451787e-01, -4.090099e-01, -7.317727e-01,  5.480895e-01, -4.286790e-01, -7.330728e-01},
  {-4.541978e-01, -5.333561e-01, -7.136075e-01, -4.731818e-01, -5.309122e-01, -7.176939e-01},
  {-4.480105e-01, -5.019559e-01, -7.398154e-01, -4.573237e-01, -5.010512e-01, -7.487701e-01},
  {-3.641574e-01, -4.491664e-01, -8.158669e-01, -3.726998e-01, -4.600288e-01, -8.187335e-01},
  {-2.846102e-01, -4.312291e-01, -8.561766e-01, -2.902676e-01, -4.325965e-01, -8.657153e-01},
  {-1.692359e-02, -3.064605e-01, -9.517330e-01, -1.307017e-02, -3.051919e-01, -9.630948e-01},
  {-1.060916e-01, -3.223923e-01, -9.406422e-01, -9.341312e-02, -3.355905e-01, -9.484280e-01},
  {-9.645071e-02, -3.680893e-01, -9.247743e-01, -1.134893e-01, -3.566450e-01, -9.385023e-01},
  { 2.928639e-01, -6.175898e-01,  7.299408e-01,  1.735965e-01, -6.174342e-01,  7.819663e-01},
  { 9.702096e-02, -6.519943e-01,  7.519909e-01,  9.975015e-02, -6.515550e-01,  7.657564e-01},
  { 2.283363e-01, -7.123289e-01,  6.636641e-01,  2.396375e-01, -7.225086e-01,  6.643898e-01},
  { 2.629801e-01, -7.758023e-01,  5.735610e-01,  2.737961e-01, -7.814022e-01,  5.790555e-01},
  {-2.187026e-01, -7.781731e-01,  5.887409e-01, -2.063485e-01, -7.905058e-01,  5.944505e-01},
  { 1.111362e-01, -8.182609e-01,  5.640017e-01,  1.061723e-01, -8.206046e-01,  5.798200e-01},
  {-2.215406e-02, -8.075671e-01,  5.893595e-01, -5.551432e-03, -8.162702e-01,  5.954208e-01},
  { 2.221180e-01, -7.910060e-01,  5.700642e-01,  2.220415e-01, -8.029697e-01,  5.716599e-01},
  { 1.514748e-01, -8.035263e-01,  5.756743e-01,  1.576850e-01, -8.124702e-01,  5.795553e-01},
  {-2.642888e-01, -7.705910e-01,  5.799490e-01, -2.710243e-01, -7.707333e-01,  5.944456e-01},
  {-2.864544e-01, -7.185729e-01,  6.337168e-01, -2.961066e-01, -7.323554e-01,  6.299413e-01},
  {-2.415790e-01, -8.296766e-01,  5.032656e-01, -2.467881e-01, -8.378288e-01,  5.079256e-01},
  {-3.160966e-01, -8.366593e-01,  4.473076e-01, -3.209717e-01, -8.429679e-01,  4.552262e-01},
  {-4.095149e-01, -8.334533e-01,  3.710164e-01, -4.084496e-01, -8.452150e-01,  3.736679e-01},
  {-7.860249e-01, -6.004168e-01,  1.471886e-01, -7.846587e-01, -6.168317e-01,  1.570782e-01},
  {-7.986805e-01, -5.869073e-01,  1.328507e-01, -8.089069e-01, -5.930397e-01,  1.217286e-01},
  {-5.351623e-01, -7.970310e-01,  2.798979e-01, -5.444790e-01, -7.979906e-01,  2.959722e-01},
  {-6.260954e-01, -7.535481e-01,  2.004236e-01, -6.307896e-01, -7.622029e-01,  2.049298e-01},
  { 7.224697e-01, -6.841220e-01,  1.000719e-01,  7.228172e-01, -6.999316e-01,  9.219601e-02},
  {-5.700635e-01, -7.931461e-01,  2.143519e-01, -5.575880e-01, -8.102623e-01,  2.311200e-01},
  {-5.374637e-01, -8.146215e-01,  2.180015e-01, -5.490370e-01, -8.200459e-01,  2.166308e-01},
  {-8.385759e-01, -5.428444e-01,  4.594125e-02, -8.486413e-01, -5.447184e-01,  6.272260e-02},
  {-8.475801e-01, -5.305188e-01, -1.256328e-02, -8.544044e-01, -5.392926e-01,  9.908155e-04},
  { 8.001438e-01, -5.714743e-01, -1.821734e-01,  8.046633e-01, -5.823955e-01, -1.849465e-01},
  {-8.796708e-01, -4.718196e-01, -5.971170e-02, -8.812482e-01, -4.911062e-01, -5.532736e-02},
  { 7.755467e-01, -6.105638e-01, -1.604345e-01,  7.857680e-01, -6.150234e-01, -1.587033e-01},
  {-9.006221e-01, -4.299750e-01, -6.325670e-02, -9.115498e-01, -4.302792e-01, -6.914912e-02},
  { 6.099021e-01, -6.705227e-01, -4.223964e-01,  6.139130e-01, -6.776530e-01, -4.298447e-01},
  { 7.160630e-01, -5.488575e-01, -4.312879e-01,  7.167951e-01, -5.645881e-01, -4.360347e-01},
  { 7.626805e-01, -5.027544e-01, -4.068864e-01,  7.599260e-01, -5.291620e-01, -4.041947e-01},
  {-6.735317e-01, -4.877580e-01, -5.553803e-01, -6.844943e-01, -4.845260e-01, -5.635175e-01},
  {-4.715661e-01, -5.185956e-01, -7.132208e-01, -4.748716e-01, -5.291681e-01, -7.178658e-01},
  {-4.690780e-01, -5.245293e-01, -7.105173e-01, -4.749113e-01, -5.300789e-01, -7.171672e-01},
  { 5.109993e-01, -3.989288e-01, -7.614036e-01,  5.225883e-01, -3.957095e-01, -7.693160e-01},
  { 2.368301e-01, -2.989482e-01, -9.244141e-01,  2.490984e-01, -3.115685e-01, -9.283016e-01},
  { 3.077515e-01, -3.379679e-01, -8.894193e-01,  3.107349e-01, -3.255735e-01, -9.046078e-01},
  { 1.214386e-01, -3.049778e-01, -9.445851e-01,  1.236412e-01, -3.157708e-01, -9.517711e-01},
  { 3.599777e-01, -3.507019e-01, -8.645370e-01,  3.615713e-01, -3.498393e-01, -8.762127e-01},
  { 2.832817e-01, -5.960082e-01,  7.513493e-01,  2.920900e-01, -6.078913e-01,  7.523379e-01},
  { 3.459923e-01, -6.188172e-01,  7.052337e-01,  3.588483e-01, -6.262177e-01,  7.070651e-01},
  { 3.663277e-01, -6.433607e-01,  6.722284e-01,  3.720769e-01, -6.489376e-01,  6.791911e-01},
  { 2.982481e-01, -5.958669e-01,  7.456478e-01,  1.785804e-01, -6.055425e-01,  7.888510e-01},
  { 1.485225e-01, -5.800295e-01,  8.009412e-01,  1.641744e-01, -6.039072e-01,  7.932220e-01},
  { 4.157834e-01, -6.778998e-01,  6.062804e-01,  4.173369e-01, -6.802678e-01,  6.196193e-01},
  { 1.162271e-01, -6.904869e-01,  7.139461e-01,  1.007647e-01, -6.969447e-01,  7.245489e-01},
  { 1.750373e-01, -7.069406e-01,  6.852715e-01,  1.707142e-01, -7.231745e-01,  6.846407e-01},
  { 2.723166e-01, -7.415026e-01,  6.132029e-01,  2.650528e-01, -7.537268e-01,  6.184673e-01},
  { 4.722731e-01, -7.111197e-01,  5.208328e-01,  4.777903e-01, -7.192400e-01,  5.252966e-01},
  {-7.809816e-02, -8.110999e-01,  5.796703e-01, -8.115634e-02, -8.180652e-01,  5.873971e-01},
  { 1.124793e-01, -7.801222e-01,  6.154330e-01,  1.143542e-01, -8.041756e-01,  6.008998e-01},
  {-2.351478e-01, -8.179129e-01,  5.250943e-01, -2.515576e-01, -8.226510e-01,  5.299187e-01},
  {-2.430235e-01, -7.875690e-01,  5.662813e-01, -2.666410e-01, -7.979220e-01,  5.595291e-01},
  { 5.679768e-01, -6.983752e-01,  4.355164e-01,  5.737466e-01, -7.027122e-01,  4.448321e-01},
  { 6.099971e-02, -7.999055e-01,  5.970178e-01,  5.142732e-02, -8.041058e-01,  6.096097e-01},
  {-2.994569e-01, -7.431645e-01,  5.983578e-01, -3.030543e-01, -7.510388e-01,  6.041094e-01},
  {-2.798517e-01, -8.314335e-01,  4.800013e-01, -2.753867e-01, -8.381328e-01,  4.924884e-01},
  { 6.221913e-01, -7.037037e-01,  3.430439e-01,  6.312063e-01, -7.150112e-01,  3.334728e-01},
  {-6.970572e-01, -6.671013e-01,  2.628444e-01, -7.068690e-01, -6.729189e-01,  2.614591e-01},
  {-6.597415e-01, -7.011970e-01,  2.703035e-01, -6.622983e-01, -7.128412e-01,  2.721457e-01},
  { 6.636798e-01, -6.980762e-01,  2.687354e-01,  6.669017e-01, -7.091253e-01,  2.706489e-01},
  {-7.994481e-01, -5.746838e-01,  1.749895e-01, -7.974378e-01, -5.925125e-01,  1.840277e-01},
  {-4.470941e-01, -7.986096e-01,  4.029014e-01, -5.071784e-01, -8.067420e-01,  3.358331e-01},
  {-5.590992e-01, -7.712296e-01,  3.043239e-01, -5.687602e-01, -7.812053e-01,  2.950861e-01},
  {-5.741856e-01, -7.798700e-01,  2.492262e-01, -5.811965e-01, -7.880702e-01,  2.490009e-01},
  { 7.179424e-01, -6.827514e-01,  1.356805e-01,  7.248877e-01, -6.901661e-01,  1.381221e-01},
  {-8.192815e-01, -5.634399e-01,  1.063642e-01, -8.290482e-01, -5.681201e-01,  1.071436e-01},
  { 8.023012e-01, -5.836216e-01, -1.252944e-01,  8.146183e-01, -5.851566e-01, -1.219067e-01},
  { 7.815574e-01, -6.176234e-01, -8.780281e-02,  7.872390e-01, -6.263925e-01, -9.358773e-02},
  {-8.757123e-01, -4.827367e-01,  9.657794e-03, -8.830477e-01, -4.909874e-01, -1.631723e-03},
  {-8.719963e-01, -4.888722e-01, -2.503042e-02, -8.804778e-01, -4.949336e-01, -2.538013e-02},
  {-7.838913e-01, -5.692902e-01, -2.478366e-01, -7.886478e-01, -5.700035e-01, -2.719865e-01},
  { 7.805058e-01, -5.551674e-01, -2.874017e-01,  7.936094e-01, -5.525159e-01, -2.928881e-01},
  {-8.699591e-01, -4.702851e-01, -1.483342e-01, -8.823105e-01, -4.685133e-01, -1.512238e-01},
  {-8.900093e-01, -4.410636e-01, -1.155260e-01, -8.965352e-01, -4.474058e-01, -1.299912e-01},
  {-7.592320e-01, -5.221984e-01, -3.884269e-01, -7.664472e-01, -5.319554e-01, -3.878522e-01},
  {-7.403567e-01, -5.000337e-01, -4.492641e-01, -7.472890e-01, -5.166387e-01, -4.421443e-01},
  {-7.133152e-01, -4.938767e-01, -4.972598e-01, -7.202901e-01, -4.997222e-01, -5.029308e-01},
  { 6.527030e-01, -4.694826e-01, -5.946132e-01,  6.467195e-01, -4.816367e-01, -6.088123e-01},
  {-5.455393e-01, -5.030406e-01, -6.703261e-01, -5.558842e-01, -5.008399e-01, -6.789730e-01},
  {-6.307291e-01, -4.836628e-01, -6.068370e-01, -6.411577e-01, -4.774050e-01, -6.179417e-01},
  { 5.722724e-01, -4.175068e-01, -7.058275e-01,  5.753865e-01, -4.210882e-01, -7.158822e-01},
  {-4.451600e-01, -4.519385e-01, -7.730356e-01, -4.366616e-01, -4.607318e-01, -7.860712e-01},
  { 4.935245e-01, -3.792322e-01, -7.826983e-01,  5.002471e-01, -3.754824e-01, -7.934971e-01},
  {-4.021704e-01, -4.481590e-01, -7.983811e-01, -4.060458e-01, -4.530163e-01, -8.079591e-01},
  { 4.092825e-01, -3.637412e-01, -8.367677e-01,  4.240271e-01, -3.618923e-01, -8.426778e-01},
  { 1.684767e-01, -2.869436e-01, -9.430159e-01,  1.761407e-01, -2.851667e-01, -9.531643e-01},
  {-3.276280e-01, -4.315462e-01, -8.404925e-01, -3.376702e-01, -4.295115e-01, -8.499153e-01},
  { 6.752264e-02, -2.946773e-01, -9.532083e-01,  7.404278e-02, -2.877741e-01, -9.656966e-01},
  { 2.595853e-02, -2.699273e-01, -9.625308e-01,  2.508809e-02, -2.880982e-01, -9.681091e-01},
  {-1.696615e-01, -3.391296e-01, -9.253141e-01, -1.648783e-01, -3.556156e-01, -9.312432e-01},
  {-2.105857e-01, -3.872659e-01, -8.975962e-01, -2.233725e-01, -3.933994e-01, -9.035167e-01},
  { 2.394826e-01, -5.873500e-01,  7.730899e-01,  2.362873e-01, -5.934760e-01,  7.828246e-01},
  { 4.068553e-01, -6.387545e-01,  6.530401e-01,  3.982354e-01, -6.490801e-01,  6.640526e-01},
  { 1.034646e-01, -6.099479e-01,  7.856581e-01,  9.152254e-02, -6.201545e-01,  7.923945e-01},
  { 5.877169e-02, -6.635348e-01,  7.458334e-01,  6.029476e-02, -6.750541e-01,  7.493479e-01},
  {-1.924669e-01, -6.297415e-01,  7.525836e-01, -2.025113e-01, -6.311405e-01,  7.630855e-01},
  { 4.742070e-01, -6.844313e-01,  5.537884e-01,  4.730511e-01, -6.936152e-01,  5.621247e-01},
  { 6.153540e-02, -7.071201e-01,  7.044107e-01,  7.237104e-02, -7.116073e-01,  7.136059e-01},
  { 4.970527e-01, -6.883994e-01,  5.282470e-01,  5.207032e-01, -7.026889e-01,  5.059256e-01},
  {-5.322949e-02, -7.958945e-01,  6.030908e-01, -6.138159e-02, -8.065216e-01,  6.054816e-01},
  {-1.372462e-01, -7.928314e-01,  5.937860e-01, -1.409956e-01, -7.937940e-01,  6.089853e-01},
  { 5.508277e-01, -6.849408e-01,  4.769118e-01,  5.494826e-01, -6.981936e-01,  4.811023e-01},
  {-2.469948e-01, -7.449794e-01,  6.196768e-01, -2.529276e-01, -7.447212e-01,  6.342461e-01},
  { 3.069810e-02, -7.829919e-01,  6.212739e-01,  3.841053e-02, -7.957352e-01,  6.214377e-01},
  {-2.849416e-01, -7.995959e-01,  5.286347e-01, -2.879514e-01, -8.097255e-01,  5.312983e-01},
  {-3.038606e-01, -7.739179e-01,  5.556256e-01, -3.079323e-01, -7.823387e-01,  5.603328e-01},
  {-3.428508e-01, -7.051376e-01,  6.206724e-01, -3.535436e-01, -7.159158e-01,  6.191288e-01},
  { 6.028554e-01, -6.981204e-01,  3.862553e-01,  6.238668e-01, -6.920910e-01,  3.907259e-01},
  { 6.561004e-01, -6.837609e-01,  3.193794e-01,  6.588451e-01, -6.915964e-01,  3.293704e-01},
  {-4.140732e-01, -8.027554e-01,  4.291005e-01, -4.113571e-01, -8.142734e-01,  4.342712e-01},
  {-6.218249e-01, -7.315836e-01,  2.794983e-01, -6.271230e-01, -7.410135e-01,  2.801086e-01},
  {-4.392301e-01, -8.035724e-01,  4.016818e-01, -4.446841e-01, -8.159853e-01,  3.965741e-01},
  {-5.978355e-01, -7.497800e-01,  2.835888e-01, -6.026170e-01, -7.596766e-01,  2.838829e-01},
  {-6.442128e-01, -7.277212e-01,  2.353968e-01, -6.419255e-01, -7.423359e-01,  2.402373e-01},
  {-4.729666e-01, -8.065698e-01,  3.546092e-01, -4.785507e-01, -8.131616e-01,  3.642202e-01},
  {-6.059982e-01, -7.609506e-01,  2.317767e-01, -6.211808e-01, -7.611510e-01,  2.358574e-01},
  {-4.747024e-01, -7.832279e-01,  4.015120e-01, -5.218453e-01, -7.926232e-01,  3.468023e-01},
  { 7.372465e-01, -6.756191e-01, -2.570992e-03,  7.450135e-01, -6.823711e-01,  1.394474e-02},
  { 8.138778e-01, -5.756717e-01, -7.877207e-02,  8.221376e-01, -5.805247e-01, -8.918269e-02},
  {-8.080202e-01, -5.596723e-01, -1.840384e-01, -8.277026e-01, -5.453100e-01, -1.959362e-01},
  {-8.473017e-01, -5.037056e-01, -1.684059e-01, -8.529365e-01, -5.140097e-01, -1.707007e-01},
  { 8.091096e-01, -5.442941e-01, -2.215528e-01,  8.155359e-01, -5.522664e-01, -2.253363e-01},
  { 8.023218e-01, -5.367626e-01, -2.610857e-01,  8.107706e-01, -5.407385e-01, -2.666953e-01},
  {-9.152243e-01, -3.874298e-01, -1.107375e-01, -9.297894e-01, -3.806659e-01, -1.069130e-01},
  { 6.545179e-01, -6.102951e-01, -4.462581e-01,  6.674423e-01, -6.111550e-01, -4.501698e-01},
  { 7.806959e-01, -5.058605e-01, -3.669047e-01,  7.904168e-01, -5.088395e-01, -3.704018e-01},
  { 6.561309e-01, -5.666845e-01, -4.983583e-01,  6.841064e-01, -5.549580e-01, -4.948656e-01},
  { 6.934260e-01, -5.092515e-01, -5.097286e-01,  6.929008e-01, -5.191064e-01, -5.208546e-01},
  { 6.283574e-01, -4.571840e-01, -6.294042e-01,  6.348051e-01, -4.655805e-01, -6.339797e-01},
  { 6.777927e-01, -4.874539e-01, -5.504413e-01,  6.866670e-01, -4.921740e-01, -5.547498e-01},
  { 5.983046e-01, -4.427794e-01, -6.678159e-01,  6.068630e-01, -4.458211e-01, -6.736715e-01},
  {-6.110305e-01, -4.610315e-01, -6.434996e-01, -6.184167e-01, -4.736271e-01, -6.434978e-01},
  {-4.877847e-01, -4.846139e-01, -7.260960e-01, -4.904219e-01, -4.965864e-01, -7.305763e-01},
  { 5.238910e-01, -3.700903e-01, -7.671840e-01,  5.252177e-01, -3.698835e-01, -7.798749e-01},
  { 3.205400e-01, -2.842706e-01, -9.035731e-01,  2.961206e-01, -2.983503e-01, -9.187869e-01},
  { 4.470228e-01, -4.410085e-01, -7.782558e-01,  4.253159e-01, -3.312945e-01, -8.545300e-01},
  { 3.798714e-01, -4.816469e-01, -7.897556e-01,  3.978685e-01, -3.393742e-01, -8.645210e-01},
  { 3.924272e-01, -5.945662e-01, -7.017776e-01,  4.058075e-01, -3.369530e-01, -8.630366e-01},
  {-7.050854e-02, -2.811150e-01, -9.570804e-01, -7.708045e-02, -2.951405e-01, -9.632311e-01},
  {-2.912489e-01, -3.901285e-01, -8.734837e-01, -2.878169e-01, -3.987198e-01, -8.826338e-01},
  { 4.106995e-01, -6.092610e-01,  6.783266e-01,  4.141344e-01, -6.188216e-01,  6.835178e-01},
  { 1.978620e-01, -7.350325e-01,  6.485198e-01,  1.963123e-01, -7.402843e-01,  6.590133e-01},
  {-2.680033e-01, -6.137474e-01,  7.426227e-01, -2.763416e-01, -6.134928e-01,  7.537326e-01},
  { 4.554992e-01, -6.792672e-01,  5.754273e-01,  4.641726e-01, -6.849879e-01,  5.804579e-01},
  { 1.358043e-01, -7.323859e-01,  6.672093e-01,  1.482950e-01, -7.379629e-01,  6.740002e-01},
  { 1.095733e-01, -7.307132e-01,  6.738338e-01,  1.176668e-01, -7.337916e-01,  6.845149e-01},
  {-2.406287e-01, -6.370980e-01,  7.322595e-01, -2.211808e-01, -6.503938e-01,  7.408903e-01},
  { 2.114047e-01, -7.625352e-01,  6.114312e-01,  2.109206e-01, -7.686859e-01,  6.208804e-01},
  {-3.121116e-01, -6.328028e-01,  7.086232e-01, -2.975839e-01, -6.565123e-01,  7.080153e-01},
  {-3.362295e-01, -6.587245e-01,  6.730763e-01, -3.360731e-01, -6.643674e-01,  6.830230e-01},
  { 1.603466e-01, -7.818114e-01,  6.025446e-01,  1.668840e-01, -7.870958e-01,  6.111357e-01},
  {-1.723791e-01, -7.754836e-01,  6.073802e-01, -1.717951e-01, -7.820202e-01,  6.162647e-01},
  {-9.098424e-02, -7.778338e-01,  6.218493e-01, -9.600989e-02, -7.917485e-01,  6.202975e-01},
  {-2.032100e-01, -7.539104e-01,  6.247599e-01, -2.171694e-01, -7.598690e-01,  6.295135e-01},
  { 7.739045e-02, -7.768493e-01,  6.249126e-01,  8.130945e-02, -7.914826e-01,  6.227354e-01},
  {-3.431469e-01, -7.442122e-01,  5.730606e-01, -3.341624e-01, -7.531503e-01,  5.847640e-01},
  { 6.912048e-01, -5.958880e-01,  4.088441e-01,  6.454557e-01, -6.766051e-01,  3.827004e-01},
  {-3.265309e-01, -8.179154e-01,  4.737003e-01, -3.233277e-01, -8.218213e-01,  4.908337e-01},
  {-3.249034e-01, -7.973389e-01,  5.086142e-01, -3.277484e-01, -8.051140e-01,  5.149961e-01},
  {-3.528985e-01, -7.691198e-01,  5.328389e-01, -3.434580e-01, -7.807297e-01,  5.416147e-01},
  { 6.919546e-01, -6.062006e-01,  3.920709e-01,  6.580055e-01, -6.761394e-01,  3.615685e-01},
  {-7.530534e-01, -6.118013e-01,  2.420947e-01, -7.654102e-01, -6.108276e-01,  2.487592e-01},
  {-7.734320e-01, -5.897773e-01,  2.323049e-01, -7.861633e-01, -5.884853e-01,  2.376482e-01},
  {-3.586226e-01, -8.086318e-01,  4.663737e-01, -3.702213e-01, -8.154107e-01,  4.678565e-01},
  { 6.868924e-01, -6.878315e-01,  2.346628e-01,  7.121532e-01, -6.788170e-01,  2.300300e-01},
  {-4.420355e-01, -7.851963e-01,  4.336719e-01, -4.457716e-01, -7.991018e-01,  4.284518e-01},
  { 7.181762e-01, -6.694719e-01,  1.898168e-01,  7.226992e-01, -6.768683e-01,  2.010571e-01},
  { 8.078332e-01, -5.878118e-01,  4.339077e-02,  8.082305e-01, -6.041533e-01,  5.132054e-02},
  { 7.835438e-01, -6.185254e-01,  5.903787e-02,  7.977604e-01, -6.170648e-01,  6.066936e-02},
  {-4.902370e-01, -7.738497e-01,  4.010290e-01, -5.025532e-01, -7.856634e-01,  3.886124e-01},
  { 7.571622e-01, -6.484864e-01,  7.855319e-02,  7.703022e-01, -6.490554e-01,  7.894249e-02},
  { 7.412484e-01, -6.694680e-01,  4.861426e-02,  7.500911e-01, -6.749194e-01,  5.212592e-02},
  {-8.501365e-01, -5.176176e-01,  9.664299e-02, -8.569478e-01, -5.286672e-01,  8.363939e-02},
  {-8.668109e-01, -4.964488e-01,  4.666502e-02, -8.754033e-01, -5.020834e-01,  4.925090e-02},
  { 7.687996e-01, -6.377936e-01, -4.654649e-02,  7.857441e-01, -6.325591e-01, -5.784877e-02},
  { 8.252671e-01, -5.453075e-01, -1.468807e-01,  8.307450e-01, -5.549728e-01, -1.508019e-01},
  {-8.169932e-01, -5.321535e-01, -2.221143e-01, -8.276139e-01, -5.372495e-01, -2.221548e-01},
  {-7.867810e-01, -5.369502e-01, -3.044011e-01, -8.015759e-01, -5.335657e-01, -3.059903e-01},
  { 8.069616e-01, -5.059683e-01, -3.046458e-01,  8.124121e-01, -5.194631e-01, -3.016929e-01},
  {-8.765227e-01, -4.455051e-01, -1.822992e-01, -8.822868e-01, -4.545728e-01, -1.891535e-01},
  { 6.998498e-01, -5.213782e-01, -4.882367e-01,  6.961238e-01, -5.431116e-01, -4.930218e-01},
  { 7.579856e-01, -4.933657e-01, -4.266709e-01,  7.659808e-01, -4.909942e-01, -4.393995e-01},
  { 7.040733e-01, -4.992003e-01, -5.050544e-01,  7.012423e-01, -5.102285e-01, -5.184582e-01},
  {-7.221885e-01, -4.565909e-01, -5.195850e-01, -7.262621e-01, -4.637003e-01, -5.276122e-01},
  {-6.795841e-01, -4.436490e-01, -5.842438e-01, -6.891150e-01, -4.455982e-01, -5.894174e-01},
  {-5.760230e-01, -4.727748e-01, -6.668444e-01, -5.814879e-01, -4.788854e-01, -6.733443e-01},
  {-5.111525e-01, -4.718292e-01, -7.184012e-01, -5.179139e-01, -4.829507e-01, -7.206780e-01},
  {-4.650500e-01, -4.608101e-01, -7.558985e-01, -4.722831e-01, -4.655600e-01, -7.622709e-01},
  { 3.857228e-01, -3.478656e-01, -8.545218e-01,  4.717200e-01, -3.627499e-01, -8.165563e-01},
  { 2.989874e-01, -2.819330e-01, -9.116579e-01,  4.779334e-01, -3.552800e-01, -8.174906e-01},
  { 4.458290e-01, -2.975219e-01, -8.442258e-01,  4.436654e-01, -3.081285e-01, -8.538675e-01},
  { 1.936875e-01, -2.616546e-01, -9.455274e-01,  2.013873e-01, -2.686621e-01, -9.529598e-01},
  { 3.569034e-01, -2.998075e-01, -8.847234e-01,  3.714929e-01, -3.034113e-01, -8.892723e-01},
  {-3.635857e-01, -2.935364e-01, -8.841051e-01, -4.505573e-01, -3.379995e-01, -8.388150e-01},
  {-4.600853e-01, -3.246714e-01, -8.263838e-01, -4.643976e-01, -3.227910e-01, -8.372557e-01},
  {-4.656850e-01, -3.301412e-01, -8.210629e-01, -4.641186e-01, -3.258849e-01, -8.362112e-01},
  {-4.591323e-01, -3.293913e-01, -8.250448e-01, -4.593554e-01, -3.270450e-01, -8.383856e-01},
  {-4.502683e-01, -3.075337e-01, -8.382609e-01, -4.643309e-01, -3.200918e-01, -8.383283e-01},
  { 7.490733e-01,  3.673863e-01, -5.512863e-01, -4.673631e-01, -3.168562e-01, -8.378723e-01},
  {-4.591025e-01, -3.114327e-01, -8.320063e-01, -4.676389e-01, -3.156627e-01, -8.381690e-01},
  { 4.602897e-01,  3.147197e-01,  8.301114e-01, -4.660215e-01, -3.183921e-01, -8.380374e-01},
  {-8.335717e-01, -1.669370e-01,  5.265836e-01, -4.682218e-01, -3.148201e-01, -8.381604e-01},
  {-3.018025e-01, -2.097541e-01, -9.300100e-01, -4.598849e-01, -3.243809e-01, -8.391300e-01},
  { 4.555007e-01,  3.108068e-01,  8.342172e-01, -4.655745e-01, -3.186903e-01, -8.381725e-01},
  {-4.724025e-01, -3.317068e-01, -8.165822e-01, -4.633674e-01, -3.212950e-01, -8.384011e-01},
  { 5.879871e-01,  6.262400e-01, -5.119519e-01, -4.649707e-01, -3.194678e-01, -8.382117e-01},
  { 4.544721e-01,  3.163781e-01,  8.326824e-01, -4.675749e-01, -3.157049e-01, -8.381888e-01},
  { 4.331082e-01,  7.423772e-01, -5.111686e-01, -4.691037e-01, -3.145388e-01, -8.377728e-01},
  { 9.848123e-02, -2.661384e-01, -9.588909e-01,  8.224016e-02, -2.707455e-01, -9.699484e-01},
  {-4.019014e-01, -2.561573e-01, -8.791238e-01, -4.675026e-01, -3.167770e-01, -8.378245e-01},
  {-2.588560e-01, -3.702540e-01, -8.921353e-01, -2.534254e-01, -3.846931e-01, -8.992475e-01},
  { 3.405204e-01, -5.795941e-01,  7.403489e-01,  3.338951e-01, -5.816509e-01,  7.556837e-01},
  { 3.765537e-01, -5.989432e-01,  7.067350e-01,  3.773931e-01, -5.954815e-01,  7.237669e-01},
  { 1.953325e-01, -5.804763e-01,  7.905015e-01,  2.095287e-01, -5.776005e-01,  8.020816e-01},
  { 4.433272e-01, -5.934775e-01,  6.717480e-01,  4.348473e-01, -6.037301e-01,  6.835796e-01},
  { 4.656365e-01, -6.125882e-01,  6.386847e-01,  4.558419e-01, -6.355664e-01,  6.396303e-01},
  { 8.007856e-02, -5.766479e-01,  8.130587e-01,  8.775775e-02, -5.810332e-01,  8.219223e-01},
  {-1.403641e-01, -6.432527e-01,  7.526777e-01, -1.410172e-01, -6.465737e-01,  7.634850e-01},
  { 1.398057e-01, -7.635916e-01,  6.303826e-01,  1.552224e-01, -7.608745e-01,  6.463999e-01},
  { 9.981449e-02, -7.539663e-01,  6.492857e-01,  8.670957e-02, -7.556522e-01,  6.650767e-01},
  {-3.125752e-01, -6.759502e-01,  6.673741e-01, -3.166753e-01, -6.796699e-01,  6.772115e-01},
  {-1.404109e-01, -7.604359e-01,  6.340520e-01, -1.372599e-01, -7.687024e-01,  6.411773e-01},
  { 6.328838e-01, -6.260982e-01,  4.554767e-01,  6.379221e-01, -6.352053e-01,  4.587338e-01},
  {-3.656142e-01, -6.739558e-01,  6.419578e-01, -3.728482e-01, -6.835262e-01,  6.439138e-01},
  { 6.564945e-01, -6.225601e-01,  4.259505e-01,  6.183391e-01, -6.726898e-01,  4.312908e-01},
  { 6.741761e-01, -6.099602e-01,  4.164552e-01,  6.861954e-01, -6.107074e-01,  4.207621e-01},
  { 7.091492e-01, -5.859962e-01,  3.920662e-01,  7.090521e-01, -6.045164e-01,  3.907352e-01},
  { 6.765442e-01, -6.321133e-01,  3.777838e-01,  6.892324e-01, -6.386993e-01,  3.713358e-01},
  { 6.726941e-01, -6.488607e-01,  3.556154e-01,  6.758988e-01, -6.591193e-01,  3.599865e-01},
  {-4.047072e-01, -7.919481e-01,  4.571983e-01, -3.992649e-01, -8.051074e-01,  4.617762e-01},
  {-7.163190e-01, -6.385183e-01,  2.813919e-01, -7.204562e-01, -6.445520e-01,  2.941527e-01},
  {-6.812055e-01, -6.652895e-01,  3.055305e-01, -6.897681e-01, -6.734179e-01,  3.026102e-01},
  {-6.439487e-01, -7.015449e-01,  3.052294e-01, -6.485019e-01, -7.100701e-01,  3.099850e-01},
  {-8.257757e-01, -5.445747e-01,  1.467411e-01, -8.431401e-01, -5.374802e-01,  1.451686e-01},
  {-8.931200e-01, -4.209567e-01,  1.585313e-01, -9.063648e-01, -4.186365e-01,  1.552116e-01},
  {-8.639428e-01, -4.769097e-01,  1.617405e-01, -9.192190e-01, -3.992485e-01,  1.371201e-01},
  { 8.290355e-01, -5.591902e-01,  2.551455e-03,  8.369387e-01, -5.660445e-01,  3.154279e-04},
  { 7.592329e-01, -6.426023e-01,  1.030909e-01,  7.786144e-01, -6.363285e-01,  9.857161e-02},
  {-8.487411e-01, -5.046692e-01,  1.579479e-01, -9.165034e-01, -4.053194e-01,  1.287714e-01},
  {-9.020337e-01, -4.166167e-01,  1.129855e-01, -9.130984e-01, -4.139565e-01,  1.254426e-01},
  {-5.061453e-01, -7.610247e-01,  4.057814e-01, -5.485485e-01, -7.632754e-01,  3.706092e-01},
  {-9.204265e-01, -3.810368e-01,  8.732762e-02, -9.312980e-01, -3.811100e-01,  9.101563e-02},
  {-8.866811e-01, -4.563867e-01,  7.421395e-02, -8.905596e-01, -4.714886e-01,  7.380088e-02},
  {-9.153323e-01, -3.984311e-01,  5.847789e-02, -9.234293e-01, -4.031265e-01,  7.491300e-02},
  { 8.419803e-01, -5.303755e-01, -9.884825e-02,  8.447164e-01, -5.467807e-01, -9.142474e-02},
  { 7.611906e-01, -6.485164e-01,  3.912415e-03,  7.666814e-01, -6.580696e-01,  3.832152e-03},
  {-8.934513e-01, -4.489419e-01, -1.400118e-02, -9.073629e-01, -4.444512e-01,  5.526951e-04},
  { 8.313931e-01, -5.003372e-01, -2.417605e-01,  8.388606e-01, -5.060641e-01, -2.471563e-01},
  {-8.465933e-01, -4.818815e-01, -2.259867e-01, -8.490878e-01, -4.920898e-01, -2.402985e-01},
  {-9.168867e-01, -3.970134e-01, -4.122012e-02, -9.276394e-01, -3.984241e-01, -3.985350e-02},
  {-9.261138e-01, -3.731783e-01, -5.523767e-02, -9.362153e-01, -3.763604e-01, -5.633676e-02},
  {-6.686519e-01, -7.291791e-01, -1.456105e-01, -8.059435e-01, -5.161464e-01, -3.238741e-01},
  { 7.952451e-01, -4.760145e-01, -3.754937e-01,  8.169579e-01, -4.766959e-01, -3.552682e-01},
  {-6.584488e-01, -7.278169e-01, -1.916447e-01, -8.031438e-01, -5.179487e-01, -3.310029e-01},
  {-9.216236e-01, -3.644358e-01, -1.334034e-01, -9.371195e-01, -3.563983e-01, -1.250308e-01},
  {-6.965495e-01, -6.584315e-01, -2.851085e-01, -7.987214e-01, -5.193816e-01, -3.363534e-01},
  { 7.663860e-01, -4.716327e-01, -4.361367e-01,  7.789860e-01, -4.712297e-01, -4.381754e-01},
  { 7.915322e-01, -4.488522e-01, -4.147391e-01,  7.904633e-01, -4.600342e-01, -4.294308e-01},
  {-7.662845e-01, -4.800543e-01, -4.270316e-01, -7.764838e-01, -4.868653e-01, -4.253030e-01},
  { 7.275015e-01, -4.872584e-01, -4.830331e-01,  7.332500e-01, -4.929239e-01, -4.901469e-01},
  { 7.418324e-01, -4.603716e-01, -4.875887e-01,  7.449191e-01, -4.708084e-01, -4.942762e-01},
  {-6.424316e-01, -4.375615e-01, -6.291436e-01, -6.476797e-01, -4.392770e-01, -6.390601e-01},
  {-5.344916e-01, -4.767519e-01, -6.978728e-01, -5.424625e-01, -4.781294e-01, -7.056766e-01},
  { 6.053222e-01, -3.706443e-01, -7.044201e-01,  5.955250e-01, -3.913843e-01, -7.167935e-01},
  { 2.364501e-01, -2.548862e-01, -9.376163e-01,  2.325433e-01, -2.604219e-01, -9.481419e-01},
  {-4.368732e-01, -3.971529e-01, -8.071006e-01, -4.412208e-01, -4.062406e-01, -8.131103e-01},
  {-3.820968e-01, -3.987259e-01, -8.336784e-01, -3.901283e-01, -4.158545e-01, -8.340991e-01},
  {-4.790736e-01, -3.147254e-01, -8.194123e-01, -4.666111e-01, -3.217769e-01, -8.364149e-01},
  { 4.608112e-01,  3.183471e-01,  8.284371e-01, -4.642627e-01, -3.210697e-01, -8.379921e-01},
  {-3.783437e-01, -3.738479e-01, -8.468139e-01, -3.755037e-01, -3.710746e-01, -8.614858e-01},
  {-4.199505e-01, -3.206251e-01, -8.490237e-01, -4.114813e-01, -3.220083e-01, -8.647838e-01},
  { 4.292375e-01,  2.861133e-01,  8.566763e-01, -4.655141e-01, -3.180707e-01, -8.384413e-01},
  { 4.759463e-01,  3.733876e-01,  7.962770e-01, -4.628007e-01, -3.212492e-01, -8.387316e-01},
  {-2.004177e-02, -2.667626e-01, -9.635538e-01, -1.373834e-02, -2.674468e-01, -9.742424e-01},
  {-1.744382e-01, -3.169123e-01, -9.322757e-01, -1.770114e-01, -3.146312e-01, -9.436820e-01},
  {-2.179509e-01, -3.531936e-01, -9.098086e-01, -2.310744e-01, -3.595040e-01, -9.155443e-01},
  { 1.294631e-01, -5.605858e-01,  8.179138e-01,  1.287191e-01, -5.696537e-01,  8.244902e-01},
  {-1.416358e-01, -6.119492e-01,  7.781115e-01, -1.462797e-01, -6.174465e-01,  7.862665e-01},
  {-1.749612e-01, -5.900755e-01,  7.881621e-01, -1.838857e-01, -6.005104e-01,  7.914707e-01},
  { 4.698061e-01, -6.021110e-01,  6.455576e-01,  4.707127e-01, -6.029399e-01,  6.601190e-01},
  { 2.382596e-02, -5.895337e-01,  8.073922e-01,  2.922161e-02, -5.986204e-01,  8.134223e-01},
  {-2.891978e-01, -5.805179e-01,  7.611593e-01, -2.967186e-01, -5.863299e-01,  7.674804e-01},
  {-2.375124e-01, -5.828074e-01,  7.771251e-01, -2.341954e-01, -5.886437e-01,  7.870851e-01},
  {-1.674743e-01, -6.628830e-01,  7.297524e-01, -1.753741e-01, -6.691563e-01,  7.364278e-01},
  {-3.180095e-01, -6.101356e-01,  7.256752e-01, -3.158685e-01, -6.187621e-01,  7.336285e-01},
  { 4.979818e-01, -6.723349e-01,  5.477042e-01,  5.062218e-01, -6.751863e-01,  5.556321e-01},
  { 5.293878e-01, -6.474897e-01,  5.481839e-01,  5.206342e-01, -6.610962e-01,  5.592462e-01},
  {-2.075345e-01, -6.684008e-01,  7.142617e-01, -2.208112e-01, -6.759397e-01,  7.177739e-01},
  {-2.662227e-01, -6.660088e-01,  6.968198e-01, -2.720854e-01, -6.758839e-01,  7.000006e-01},
  { 5.880193e-02, -7.479118e-01,  6.611885e-01,  5.044161e-02, -7.505522e-01,  6.745237e-01},
  {-3.769476e-01, -6.368170e-01,  6.725879e-01, -3.810098e-01, -6.396986e-01,  6.833353e-01},
  {-2.884422e-01, -6.968718e-01,  6.566359e-01, -2.921094e-01, -6.983180e-01,  6.692339e-01},
  { 5.923854e-01, -6.619301e-01,  4.592690e-01,  6.060509e-01, -6.666581e-01,  4.573133e-01},
  {-3.995335e-01, -6.818610e-01,  6.127304e-01, -4.064453e-01, -6.847169e-01,  6.219433e-01},
  {-4.029290e-01, -7.074006e-01,  5.807173e-01, -4.005108e-01, -7.227126e-01,  5.814859e-01},
  {-3.748698e-01, -7.840884e-01,  4.946494e-01, -3.863843e-01, -7.917424e-01,  4.946705e-01},
  { 7.130007e-01, -6.134911e-01,  3.394974e-01,  7.208428e-01, -6.091199e-01,  3.608708e-01},
  {-8.011593e-01, -5.540655e-01,  2.261752e-01, -8.149691e-01, -5.562831e-01,  2.172988e-01},
  { 6.905487e-01, -6.562255e-01,  3.041557e-01,  7.004169e-01, -6.567517e-01,  3.145820e-01},
  {-8.266280e-01, -5.317419e-01,  1.842191e-01, -8.388498e-01, -5.307136e-01,  1.884627e-01},
  {-8.515041e-01, -4.992073e-01,  1.604143e-01, -8.616760e-01, -5.001758e-01,  1.678777e-01},
  {-6.641514e-01, -6.736985e-01,  3.240883e-01, -6.700770e-01, -6.811634e-01,  3.284177e-01},
  {-7.923776e-01, -5.942135e-01,  1.380152e-01, -8.794296e-01, -4.725566e-01,  1.553646e-01},
  { 7.464010e-01, -6.494033e-01,  1.454681e-01,  7.552650e-01, -6.544740e-01,  1.486896e-01},
  {-6.198460e-01, -7.124605e-01,  3.289242e-01, -6.168047e-01, -7.234048e-01,  3.421735e-01},
  {-8.851396e-01, -4.506801e-01,  1.158240e-01, -8.915426e-01, -4.617252e-01,  1.131642e-01},
  {-5.220829e-01, -7.471532e-01,  4.113289e-01, -5.290024e-01, -7.610617e-01,  4.022286e-01},
  {-5.824991e-01, -7.363407e-01,  3.442343e-01, -5.888045e-01, -7.416556e-01,  3.549273e-01},
  {-8.645580e-01, -4.913211e-01,  1.055593e-01, -8.762344e-01, -4.926276e-01,  1.018607e-01},
  { 8.395223e-01, -5.408298e-01, -5.201473e-02,  8.516414e-01, -5.400758e-01, -6.243847e-02},
  { 8.104015e-01, -5.844043e-01, -4.148450e-02,  8.216776e-01, -5.873355e-01, -2.748271e-02},
  {-8.964921e-01, -4.408225e-01,  4.446645e-02, -9.102771e-01, -4.366850e-01,  3.932397e-02},
  {-9.226656e-01, -3.852227e-01,  1.707715e-02, -9.307170e-01, -3.931538e-01,  6.388612e-03},
  { 8.334257e-01, -5.155340e-01, -1.990632e-01,  8.435085e-01, -5.224282e-01, -1.908824e-01},
  {-9.367079e-01, -3.500041e-01, -8.689004e-03, -9.433445e-01, -3.618584e-01, -2.148239e-03},
  {-9.099803e-01, -4.146512e-01, -4.637823e-04, -9.188582e-01, -4.201341e-01, -5.610938e-03},
  { 8.358921e-01, -4.721352e-01, -2.799511e-01,  8.461535e-01, -4.803967e-01, -2.722463e-01},
  {-9.374961e-01, -3.415489e-01, -6.667433e-02, -9.444799e-01, -3.526823e-01, -6.646936e-02},
  {-8.609241e-01, -4.442251e-01, -2.479391e-01, -8.665534e-01, -4.591504e-01, -2.431298e-01},
  {-8.835526e-01, -4.137938e-01, -2.193386e-01, -8.898887e-01, -4.273758e-01, -2.151597e-01},
  {-8.208843e-01, -5.042471e-01, -2.681114e-01, -8.413094e-01, -4.814015e-01, -2.851267e-01},
  {-8.997973e-01, -4.006210e-01, -1.728228e-01, -9.021528e-01, -4.099636e-01, -1.972206e-01},
  {-8.003991e-01, -4.790392e-01, -3.603925e-01, -8.095356e-01, -4.852459e-01, -3.606044e-01},
  { 7.803940e-01, -4.253083e-01, -4.583645e-01,  7.917017e-01, -4.304975e-01, -4.568975e-01},
  {-7.947024e-01, -4.630643e-01, -3.924531e-01, -8.027085e-01, -4.656871e-01, -3.995523e-01},
  {-7.556983e-01, -4.464804e-01, -4.791403e-01, -7.571202e-01, -4.505706e-01, -4.945743e-01},
  {-7.445447e-01, -4.168632e-01, -5.214195e-01, -7.508993e-01, -4.341106e-01, -5.182157e-01},
  { 7.500333e-01, -4.303575e-01, -5.022374e-01,  7.533106e-01, -4.363450e-01, -5.128359e-01},
  { 7.189598e-01, -4.431547e-01, -5.354538e-01,  7.268520e-01, -4.408982e-01, -5.460486e-01},
  { 6.898394e-01, -4.273785e-01, -5.843537e-01,  7.086082e-01, -4.236391e-01, -5.824761e-01},
  { 6.612219e-01, -4.303272e-01, -6.144950e-01,  6.677480e-01, -4.291095e-01, -6.251810e-01},
  { 6.128424e-01, -4.001185e-01, -6.814172e-01,  6.213579e-01, -4.016669e-01, -6.880780e-01},
  { 5.575356e-01, -3.558708e-01, -7.500067e-01,  5.642570e-01, -3.513953e-01, -7.609260e-01},
  {-5.993736e-01, -3.901470e-01, -6.989540e-01, -6.133410e-01, -3.488510e-01, -7.231658e-01},
  {-6.094760e-01, -3.406835e-01, -7.158727e-01, -6.141496e-01, -3.491119e-01, -7.223532e-01},
  {-6.124451e-01, -3.553861e-01, -7.061245e-01, -6.165423e-01, -3.486201e-01, -7.205502e-01},
  { 4.130175e-01, -2.876395e-01, -8.641065e-01,  4.884853e-01, -3.334615e-01, -8.191811e-01},
  {-4.712411e-01, -3.559254e-01, -8.070000e-01, -4.722503e-01, -3.675036e-01, -8.141107e-01},
  {-3.658355e-01, -3.932324e-01, -8.435240e-01, -3.609773e-01, -4.071089e-01, -8.513605e-01},
  {-3.726685e-01, -3.034434e-01, -8.769494e-01, -3.839233e-01, -3.222033e-01, -8.772945e-01},
  {-3.196850e-01, -3.779826e-01, -8.688674e-01, -3.279395e-01, -3.889889e-01, -8.729268e-01},
  {-1.238603e-01, -2.888495e-01, -9.493285e-01, -1.258592e-01, -2.774526e-01, -9.633495e-01},
  {-2.332369e-01, -3.573664e-01, -9.043726e-01, -2.321645e-01, -3.579113e-01, -9.158925e-01},
  {-2.541546e-01, -3.393001e-01, -9.056937e-01, -2.332090e-01, -3.570918e-01, -9.159470e-01},
  { 3.206278e-01, -5.485056e-01,  7.722301e-01,  3.271554e-01, -5.533880e-01,  7.794825e-01},
  { 2.329371e-01, -5.469500e-01,  8.041058e-01,  2.302172e-01, -5.629703e-01,  8.067988e-01},
  {-9.540810e-02, -6.411861e-01,  7.614315e-01, -9.267125e-02, -6.482558e-01,  7.694350e-01},
  {-3.252578e-01, -5.724738e-01,  7.526494e-01, -3.288541e-01, -5.762579e-01,  7.619923e-01},
  { 4.790243e-01, -6.511577e-01,  5.886675e-01,  4.814538e-01, -6.521381e-01,  6.031434e-01},
  { 5.039889e-01, -6.077278e-01,  6.137280e-01,  5.033332e-01, -6.351659e-01,  6.033942e-01},
  { 3.206970e-03, -6.895657e-01,  7.242160e-01,  1.747210e-03, -6.939785e-01,  7.343334e-01},
  {-1.191781e-01, -6.739973e-01,  7.290571e-01, -1.183187e-01, -6.878724e-01,  7.305375e-01},
  {-1.332418e-01, -6.840332e-01,  7.171786e-01, -1.495937e-01, -6.932788e-01,  7.196100e-01},
  { 4.725807e-01, -6.662282e-01,  5.768948e-01,  5.388380e-01, -6.509880e-01,  5.553162e-01},
  {-3.571369e-01, -6.129851e-01,  7.047712e-01, -3.736496e-01, -6.250378e-01,  7.004020e-01},
  {-2.433418e-01, -6.976478e-01,  6.738489e-01, -2.357098e-01, -6.950617e-01,  6.943925e-01},
  { 5.672120e-01, -6.477246e-01,  5.086486e-01,  5.744457e-01, -6.527901e-01,  5.145317e-01},
  { 5.870019e-01, -6.426768e-01,  4.923365e-01,  5.854273e-01, -6.526530e-01,  5.021799e-01},
  { 1.716951e-02, -7.559687e-01,  6.543825e-01,  2.204546e-02, -7.613310e-01,  6.638852e-01},
  {-4.091630e-01, -6.438938e-01,  6.465186e-01, -4.008092e-01, -6.546710e-01,  6.569678e-01},
  {-2.176591e-01, -7.208436e-01,  6.580343e-01, -2.252353e-01, -7.289980e-01,  6.623307e-01},
  {-1.780454e-01, -7.382349e-01,  6.506221e-01, -1.671275e-01, -7.489120e-01,  6.573056e-01},
  {-2.870013e-02, -7.695989e-01,  6.378824e-01, -2.731353e-02, -7.736529e-01,  6.492833e-01},
  { 6.263138e-01, -5.948731e-01,  5.038422e-01,  6.837027e-01, -5.840309e-01,  4.607895e-01},
  {-7.729197e-01, -5.692252e-01,  2.803174e-01, -7.710596e-01, -5.878280e-01,  2.842001e-01},
  {-7.365929e-01, -6.121922e-01,  2.874919e-01, -7.444555e-01, -6.154842e-01,  2.963271e-01},
  {-8.280432e-01, -5.224624e-01,  2.034147e-01, -8.722464e-01, -4.687645e-01,  2.007245e-01},
  { 7.158082e-01, -6.382726e-01,  2.832431e-01,  7.238351e-01, -6.467032e-01,  2.805472e-01},
  {-6.990346e-01, -6.971622e-01,  1.591087e-01, -8.781822e-01, -4.709435e-01,  1.734049e-01},
  {-4.648481e-01, -7.666018e-01,  4.429875e-01, -4.706715e-01, -7.717732e-01,  4.513106e-01},
  { 7.475010e-01, -6.394367e-01,  1.798970e-01,  7.536431e-01, -6.462860e-01,  1.876336e-01},
  {-9.312290e-01, -3.346384e-01,  1.443247e-01, -9.354860e-01, -3.503596e-01,  1.515211e-01},
  { 7.852155e-01, -6.058902e-01,  1.278039e-01,  7.872927e-01, -6.218283e-01,  1.198780e-01},
  { 7.912588e-01, -6.114762e-01,  2.517647e-03,  7.968549e-01, -6.211761e-01, -5.836606e-03},
  {-9.431725e-01, -3.153600e-01,  1.047562e-01, -9.548720e-01, -3.181198e-01,  8.868028e-02},
  {-9.735598e-01, -2.202410e-01,  6.062391e-02, -9.866231e-01, -2.089992e-01,  6.115482e-02},
  { 8.512798e-01, -4.823411e-01, -2.065669e-01,  8.652495e-01, -4.787272e-01, -2.074572e-01},
  {-9.243183e-01, -3.401997e-01, -1.729160e-01, -9.309927e-01, -3.545452e-01, -1.685118e-01},
  {-9.395979e-01, -3.224969e-01, -1.146798e-01, -9.505257e-01, -3.248922e-01, -1.085884e-01},
  { 8.140879e-01, -4.378416e-01, -3.815177e-01,  8.207233e-01, -4.446781e-01, -3.867167e-01},
  {-7.188647e-01, -4.141178e-01, -5.583367e-01, -7.194052e-01, -4.162211e-01, -5.745139e-01},
  {-7.855701e-01, -4.372370e-01, -4.378397e-01, -7.929997e-01, -4.385581e-01, -4.468404e-01},
  {-6.721005e-01, -4.101844e-01, -6.164654e-01, -6.754325e-01, -4.125648e-01, -6.280383e-01},
  { 7.442025e-01, -3.990890e-01, -5.356217e-01,  7.517063e-01, -4.103189e-01, -5.361445e-01},
  { 6.385015e-01, -4.048999e-01, -6.545012e-01,  6.407331e-01, -4.081280e-01, -6.661578e-01},
  {-6.014367e-01, -4.320773e-01, -6.719992e-01, -6.062541e-01, -4.338543e-01, -6.819667e-01},
  {-5.622173e-01, -4.369403e-01, -7.021359e-01, -5.652608e-01, -4.496261e-01, -7.070238e-01},
  { 5.272612e-01, -3.102134e-01, -7.910520e-01,  5.355298e-01, -3.238033e-01, -7.932416e-01},
  { 2.864600e-01, -2.364602e-01, -9.284543e-01,  2.876225e-01, -2.458871e-01, -9.368474e-01},
  { 3.907359e-01, -2.873285e-01, -8.745100e-01,  4.040074e-01, -2.832412e-01, -8.817165e-01},
  { 1.408787e-01, -2.454311e-01, -9.591230e-01,  1.374111e-01, -2.378294e-01, -9.723287e-01},
  { 2.848074e-01, -5.424520e-01,  7.903358e-01,  2.814926e-01, -5.454596e-01,  8.025564e-01},
  { 4.013285e-01, -5.641565e-01,  7.215698e-01,  4.134277e-01, -5.654089e-01,  7.281851e-01},
  { 3.971310e-02, -5.582289e-01,  8.287360e-01,  4.105040e-02, -5.533330e-01,  8.443898e-01},
  {-2.506457e-01, -5.496435e-01,  7.969120e-01, -2.542493e-01, -5.590890e-01,  8.022646e-01},
  {-2.936147e-01, -5.435002e-01,  7.863829e-01, -2.998726e-01, -5.483755e-01,  7.938588e-01},
  { 5.096766e-01, -6.121246e-01,  6.045936e-01,  5.391666e-01, -6.222870e-01,  5.855967e-01},
  {-5.878035e-02, -6.930671e-01,  7.184725e-01, -7.552015e-02, -6.946660e-01,  7.297873e-01},
  { 9.096107e-03, -7.202459e-01,  6.936592e-01,  1.260509e-02, -7.361977e-01,  6.918877e-01},
  {-1.888746e-01, -6.981450e-01,  6.905940e-01, -1.842392e-01, -7.011739e-01,  7.037491e-01},
  { 6.160458e-01, -6.085615e-01,  5.001404e-01,  6.188741e-01, -6.181617e-01,  5.057052e-01},
  {-4.309073e-01, -6.578810e-01,  6.176662e-01, -4.329137e-01, -6.625956e-01,  6.280135e-01},
  { 6.549866e-01, -5.783281e-01,  4.863427e-01,  6.593885e-01, -5.903205e-01,  4.874386e-01},
  { 5.658560e-01, -5.856654e-01,  5.803474e-01,  6.918119e-01, -5.654092e-01,  4.736280e-01},
  {-8.346027e-01, -5.006456e-01,  2.297657e-01, -8.373916e-01, -5.122780e-01,  2.404941e-01},
  {-3.904496e-01, -7.451659e-01,  5.406265e-01, -4.045957e-01, -7.535236e-01,  5.379149e-01},
  {-4.101751e-01, -7.605831e-01,  5.032591e-01, -4.136948e-01, -7.700263e-01,  5.067188e-01},
  {-4.339975e-01, -7.222734e-01,  5.384862e-01, -4.370269e-01, -7.223538e-01,  5.550316e-01},
  { 7.498322e-01, -5.563142e-01,  3.581428e-01,  7.554877e-01, -5.658804e-01,  3.603997e-01},
  {-8.095053e-01, -5.184231e-01,  2.755696e-01, -8.193531e-01, -5.215152e-01,  2.784364e-01},
  {-3.624269e-01, -7.834960e-01,  5.047581e-01, -4.797890e-01, -7.191737e-01,  5.229136e-01},
  {-1.281290e-01, -8.390081e-01,  5.288179e-01, -4.841435e-01, -7.215073e-01,  5.173976e-01},
  {-3.391337e-01, -6.745692e-01,  6.557018e-01, -4.846716e-01, -7.172229e-01,  5.210872e-01},
  { 7.137606e-01, -6.286211e-01,  3.088387e-01,  7.490051e-01, -6.379689e-01,  2.299061e-01},
  {-7.073059e-01, -6.248510e-01,  3.305745e-01, -7.161244e-01, -6.318969e-01,  3.297225e-01},
  {-8.802289e-01, -4.319233e-01,  1.965691e-01, -9.177432e-01, -3.806826e-01,  1.835013e-01},
  {-4.962951e-01, -7.446030e-01,  4.463827e-01, -5.020348e-01, -7.522838e-01,  4.504184e-01},
  { 8.320095e-01, -5.521845e-01,  5.340844e-02,  8.488944e-01, -5.454661e-01,  5.213634e-02},
  { 8.119739e-01, -5.751175e-01,  9.969103e-02,  8.243359e-01, -5.764767e-01,  9.495859e-02},
  {-9.564871e-01, -2.708336e-01,  1.085433e-01, -9.646570e-01, -2.712519e-01,  1.292457e-01},
  {-5.366278e-01, -7.381578e-01,  4.088444e-01, -5.481755e-01, -7.391212e-01,  4.171924e-01},
  {-9.803862e-01, -1.778250e-01,  8.497755e-02, -9.928336e-01, -1.713971e-01,  7.583127e-02},
  {-9.381489e-01, -3.421857e-01,  5.277965e-02, -9.515441e-01, -3.343512e-01,  6.015072e-02},
  {-9.902773e-01, -1.279247e-01,  5.464410e-02, -1.001684e+00, -1.222893e-01,  5.020174e-02},
  {-9.612228e-01, -2.710550e-01,  5.079177e-02, -9.714338e-01, -2.737640e-01,  4.706295e-02},
  {-9.547352e-01, -2.966726e-01,  2.159010e-02, -9.592340e-01, -3.160015e-01,  2.929540e-02},
  { 8.539181e-01, -5.000371e-01, -1.441764e-01,  8.651386e-01, -5.036734e-01, -1.368308e-01},
  {-9.848924e-01, -1.724108e-01,  1.617386e-02, -9.946421e-01, -1.773488e-01,  8.976908e-03},
  {-9.744177e-01, -2.246180e-01,  7.546475e-03, -9.882230e-01, -2.103605e-01,  3.122320e-03},
  {-9.904942e-01, -1.371966e-01, -9.917018e-03, -1.000412e+00, -1.414114e-01, -5.119510e-03},
  {-9.487759e-01, -3.118795e-01, -5.055225e-02, -9.597697e-01, -3.111975e-01, -5.332629e-02},
  { 8.562578e-01, -4.288746e-01, -2.879047e-01,  8.654664e-01, -4.381956e-01, -2.825388e-01},
  {-9.490992e-01, -3.025426e-01, -8.762886e-02, -9.571272e-01, -3.122867e-01, -8.502981e-02},
  { 8.495355e-01, -4.088483e-01, -3.333656e-01,  8.542458e-01, -4.195910e-01, -3.392393e-01},
  { 8.307574e-01, -4.462931e-01, -3.326627e-01,  8.410869e-01, -4.425466e-01, -3.429298e-01},
  {-8.392052e-01, -4.523733e-01, -3.018162e-01, -8.489181e-01, -4.588334e-01, -2.994266e-01},
  { 8.180280e-01, -4.037769e-01, -4.096272e-01,  8.283438e-01, -4.093236e-01, -4.088722e-01},
  { 7.801632e-01, -3.866142e-01, -4.918076e-01,  7.832140e-01, -3.927308e-01, -5.032035e-01},
  { 6.700841e-01, -3.914202e-01, -6.306962e-01,  6.794949e-01, -4.001822e-01, -6.316763e-01},
  { 7.071726e-01, -3.929360e-01, -5.877995e-01,  7.166926e-01, -3.869776e-01, -5.978920e-01},
  {-6.294384e-01, -4.017654e-01, -6.651254e-01, -6.423270e-01, -4.050681e-01, -6.664740e-01},
  { 3.343329e-01, -2.473101e-01, -9.094280e-01,  3.191483e-01, -2.411623e-01, -9.290861e-01},
  {-4.733214e-01, -4.095022e-01, -7.799197e-01, -4.804140e-01, -4.088749e-01, -7.892266e-01},
  { 3.587801e-01, -2.573345e-01, -8.972490e-01,  3.673199e-01, -2.586203e-01, -9.050209e-01},
  {-4.957736e-01, -3.654063e-01, -7.878367e-01, -5.076461e-01, -3.685492e-01, -7.920364e-01},
  {-4.345062e-01, -2.771975e-01, -8.569515e-01, -4.315391e-01, -2.855010e-01, -8.678251e-01},
  { 1.011853e-01, -2.198270e-01, -9.702771e-01,  9.949927e-02, -2.307281e-01, -9.786376e-01},
  {-1.540068e-01, -2.729988e-01, -9.496071e-01, -1.544639e-01, -2.701846e-01, -9.612511e-01},
  {-2.266428e-01, -3.031922e-01, -9.255850e-01, -2.183726e-01, -3.034136e-01, -9.386770e-01},
  {-3.283677e-01, -3.325416e-01, -8.840762e-01, -3.270805e-01, -3.380789e-01, -8.941921e-01},
  {-1.537876e-02, -6.149630e-01,  7.884060e-01, -8.118511e-03, -6.137284e-01,  8.025751e-01},
  { 4.771431e-01, -5.616497e-01,  6.759319e-01,  4.864835e-01, -5.584998e-01,  6.872237e-01},
  { 7.733084e-02, -5.377715e-01,  8.395367e-01,  7.220944e-02, -5.490691e-01,  8.450835e-01},
  {-4.502756e-02, -6.507248e-01,  7.579774e-01, -4.927744e-02, -6.585524e-01,  7.646795e-01},
  {-1.796363e-01, -5.711490e-01,  8.009493e-01, -1.792414e-01, -5.776135e-01,  8.093750e-01},
  {-3.513709e-01, -5.467993e-01,  7.599664e-01, -3.493421e-01, -5.533401e-01,  7.698215e-01},
  {-1.613472e-02, -5.573855e-01,  8.300970e-01, -2.519147e-02, -5.706737e-01,  8.333981e-01},
  {-2.305951e-02, -6.651522e-01,  7.463517e-01, -3.818205e-02, -6.805214e-01,  7.458466e-01},
  { 5.261963e-01, -5.742769e-01,  6.271551e-01,  5.410627e-01, -5.753739e-01,  6.301283e-01},
  {-3.611216e-01, -6.013944e-01,  7.126823e-01, -3.683507e-01, -5.900443e-01,  7.328132e-01},
  { 5.747789e-01, -6.068158e-01,  5.490026e-01,  5.818579e-01, -6.140186e-01,  5.531609e-01},
  {-1.004585e-01, -7.135653e-01,  6.933489e-01, -1.069215e-01, -7.175486e-01,  7.032386e-01},
  {-3.674506e-01, -5.986426e-01,  7.117634e-01, -3.886848e-01, -6.084985e-01,  7.067552e-01},
  { 6.013006e-01, -5.984217e-01,  5.294611e-01,  6.011552e-01, -6.024473e-01,  5.445515e-01},
  {-1.799290e-02, -7.309966e-01,  6.821438e-01, -1.462145e-02, -7.440271e-01,  6.834209e-01},
  {-1.182526e-01, -7.141980e-01,  6.898823e-01, -1.321330e-01, -7.262927e-01,  6.911767e-01},
  {-4.240832e-01, -6.132268e-01,  6.664131e-01, -4.307599e-01, -6.106123e-01,  6.800346e-01},
  { 6.345108e-01, -5.687870e-01,  5.233330e-01,  6.498061e-01, -5.682101e-01,  5.251259e-01},
  {-4.393629e-01, -6.630047e-01,  6.061229e-01, -4.517987e-01, -6.634359e-01,  6.136599e-01},
  { 6.184438e-01, -5.587966e-01,  5.525157e-01,  6.929521e-01, -5.569915e-01,  4.800487e-01},
  {-4.504882e-01, -6.876975e-01,  5.693263e-01, -4.553131e-01, -6.940610e-01,  5.760354e-01},
  { 7.084590e-01, -5.548506e-01,  4.361496e-01,  7.233998e-01, -5.492880e-01,  4.425438e-01},
  { 7.382283e-01, -6.037601e-01,  3.008203e-01,  7.457415e-01, -6.126376e-01,  2.990223e-01},
  {-4.360194e-01, -6.962722e-01,  5.701686e-01, -4.885760e-01, -7.102391e-01,  5.269734e-01},
  {-8.559363e-01, -4.485919e-01,  2.571736e-01, -8.720042e-01, -4.429551e-01,  2.534636e-01},
  {-7.755963e-01, -5.397019e-01,  3.273718e-01, -7.930477e-01, -5.367621e-01,  3.221897e-01},
  {-8.247068e-01, -4.761793e-01,  3.051425e-01, -8.267792e-01, -4.948124e-01,  3.040415e-01},
  {-3.610691e-01, -8.284387e-01,  4.281569e-01, -4.977828e-01, -7.267786e-01,  4.948252e-01},
  {-7.941747e-01, -5.108103e-01,  3.291799e-01, -8.085236e-01, -5.121347e-01,  3.238085e-01},
  { 8.581027e-01, -5.132785e-01,  1.431949e-02,  8.681338e-01, -5.166273e-01,  1.771247e-02},
  {-7.968153e-01, -4.893088e-01,  3.544887e-01, -8.103257e-01, -4.909732e-01,  3.509445e-01},
  {-6.438756e-01, -6.743711e-01,  3.614523e-01, -6.514884e-01, -6.839632e-01,  3.608964e-01},
  { 8.608658e-01, -5.085753e-01, -1.616721e-02,  8.687761e-01, -5.155998e-01, -1.608565e-02},
  {-9.659832e-01, -2.305465e-01,  1.171535e-01, -9.743324e-01, -2.378806e-01,  1.222068e-01},
  {-5.951006e-01, -7.012761e-01,  3.925138e-01, -6.026136e-01, -7.049650e-01,  4.009074e-01},
  { 8.640354e-01, -4.991039e-01, -6.586564e-02,  8.744886e-01, -5.034891e-01, -5.140653e-02},
  { 8.841354e-01, -4.629189e-01, -6.332968e-02,  8.842179e-01, -4.736592e-01, -1.211643e-01},
  {-9.950384e-01, -8.886953e-02,  4.472941e-02, -1.005279e+00, -8.919819e-02,  4.800233e-02},
  {-9.654757e-01, -2.604387e-01,  5.320690e-03, -9.756523e-01, -2.624468e-01, -8.354924e-03},
  { 8.693966e-01, -4.590558e-01, -1.828042e-01,  8.805140e-01, -4.592423e-01, -1.861906e-01},
  {-9.555034e-01, -2.934981e-01, -2.953158e-02, -9.636746e-01, -3.016810e-01, -3.413436e-02},
  {-9.956216e-01, -9.342191e-02, -3.178922e-03, -1.005533e+00, -9.868789e-02, -3.441423e-03},
  {-9.712981e-01, -2.334908e-01, -4.540933e-02, -9.816150e-01, -2.369138e-01, -3.390680e-02},
  { 9.013847e-01, -3.321126e-01, -2.778613e-01,  9.062057e-01, -3.504298e-01, -2.772500e-01},
  { 8.603737e-01, -4.507982e-01, -2.377772e-01,  8.690680e-01, -4.472638e-01, -2.560299e-01},
  {-9.818113e-01, -1.836870e-01, -4.801505e-02, -9.924458e-01, -1.811639e-01, -5.547346e-02},
  { 8.888280e-01, -3.426355e-01, -3.042789e-01,  8.984408e-01, -3.503738e-01, -3.015288e-01},
  { 8.682096e-01, -3.837593e-01, -3.145488e-01,  8.823763e-01, -3.844320e-01, -3.074098e-01},
  {-9.627504e-01, -2.598681e-01, -7.470071e-02, -9.729998e-01, -2.600182e-01, -8.067083e-02},
  {-8.815910e-01, -3.956747e-01, -2.573691e-01, -8.825209e-01, -4.085979e-01, -2.739545e-01},
  {-8.904146e-01, -3.860098e-01, -2.411605e-01, -9.045192e-01, -3.842853e-01, -2.345548e-01},
  {-9.049156e-01, -3.652443e-01, -2.184591e-01, -9.203862e-01, -3.623823e-01, -2.059474e-01},
  {-8.526021e-01, -4.205337e-01, -3.101952e-01, -8.648809e-01, -4.252883e-01, -3.032448e-01},
  { 8.684217e-01, -3.312639e-01, -3.689283e-01,  8.896791e-01, -3.243277e-01, -3.523636e-01},
  { 8.404859e-01, -3.935731e-01, -3.724025e-01,  8.435312e-01, -3.945305e-01, -3.920166e-01},
  {-9.417706e-01, -2.951884e-01, -1.610344e-01, -9.503601e-01, -2.996382e-01, -1.669688e-01},
  { 8.170151e-01, -3.926343e-01, -4.222851e-01,  8.250984e-01, -3.919933e-01, -4.317754e-01},
  {-8.271559e-01, -4.357868e-01, -3.548281e-01, -8.371614e-01, -4.325788e-01, -3.645319e-01},
  {-8.166445e-01, -4.174964e-01, -3.984828e-01, -8.287831e-01, -4.245253e-01, -3.921025e-01},
  { 7.742795e-01, -3.593332e-01, -5.209329e-01,  7.845477e-01, -3.630186e-01, -5.230471e-01},
  { 7.476651e-01, -3.653535e-01, -5.545391e-01,  7.576104e-01, -3.653300e-01, -5.598537e-01},
  {-6.997255e-01, -3.805106e-01, -6.046452e-01, -7.152169e-01, -3.868273e-01, -5.997332e-01},
  {-7.973039e-01, -4.005545e-01, -4.515116e-01, -8.062474e-01, -4.029738e-01, -4.565364e-01},
  { 7.354420e-01, -3.425219e-01, -5.846400e-01,  7.409989e-01, -3.506893e-01, -5.906041e-01},
  { 6.866869e-01, -3.497029e-01, -6.373139e-01,  6.886868e-01, -3.614813e-01, -6.449159e-01},
  { 6.529073e-01, -3.530855e-01, -6.701065e-01,  6.618342e-01, -3.554360e-01, -6.756591e-01},
  {-5.943263e-01, -3.951194e-01, -7.004691e-01, -5.920982e-01, -4.013568e-01, -7.135721e-01},
  { 4.387475e-01, -2.520238e-01, -8.625455e-01,  4.434955e-01, -2.488380e-01, -8.730773e-01},
  { 3.697647e-01, -2.343611e-01, -8.990823e-01,  3.331701e-01, -2.331839e-01, -9.249291e-01},
  { 2.072490e-01, -2.177671e-01, -9.537428e-01,  2.146979e-01, -2.219359e-01, -9.620387e-01},
  {-4.670642e-01, -2.796102e-01, -8.388499e-01, -5.052425e-01, -3.109184e-01, -8.178725e-01},
  {-4.816589e-01, -8.599909e-02, -8.721289e-01, -5.228910e-01, -2.928930e-01, -8.134212e-01},
  {-4.912688e-01, -1.156233e-01, -8.632996e-01, -5.240157e-01, -2.951337e-01, -8.131492e-01},
  { 5.066099e-02, -2.377128e-01, -9.700134e-01,  5.580375e-02, -2.268675e-01, -9.829973e-01},
  {-5.681414e-03, -2.338027e-01, -9.722675e-01, -9.464296e-03, -2.319118e-01, -9.833579e-01},
  {-5.574750e-02, -2.413978e-01, -9.688237e-01, -5.366726e-02, -2.385197e-01, -9.803534e-01},
  {-1.075246e-01, -2.425881e-01, -9.641523e-01, -1.121672e-01, -2.361197e-01, -9.759763e-01},
  { 3.927054e-01, -5.292998e-01,  7.520799e-01,  3.811727e-01, -5.357006e-01,  7.671996e-01},
  { 1.999813e-01, -5.366731e-01,  8.197497e-01,  1.945574e-01, -5.324124e-01,  8.363875e-01},
  { 4.404495e-01, -5.318060e-01,  7.233164e-01,  4.398859e-01, -5.461562e-01,  7.273773e-01},
  { 1.044310e-01, -5.196986e-01,  8.479432e-01,  1.064053e-01, -5.308470e-01,  8.530753e-01},
  {-1.175108e-01, -5.901604e-01,  7.986876e-01, -1.082258e-01, -6.005567e-01,  8.052780e-01},
  {-1.606125e-01, -5.529786e-01,  8.175685e-01, -1.597739e-01, -5.626864e-01,  8.238384e-01},
  {-3.340902e-01, -5.120282e-01,  7.913348e-01, -3.333148e-01, -5.197865e-01,  7.997338e-01},
  {-3.889444e-01, -5.724171e-01,  7.218455e-01, -3.947954e-01, -5.818079e-01,  7.255932e-01},
  { 5.903785e-01, -5.727557e-01,  5.686864e-01,  5.878770e-01, -5.775708e-01,  5.845334e-01},
  {-2.105749e-01, -5.371929e-01,  8.167509e-01, -2.185259e-01, -5.281532e-01,  8.331586e-01},
  {-5.267497e-02, -7.305412e-01,  6.808341e-01, -5.217661e-02, -7.450719e-01,  6.804401e-01},
  { 6.354446e-01, -5.417734e-01,  5.501742e-01,  6.407011e-01, -5.552852e-01,  5.495711e-01},
  {-8.709370e-02, -7.302783e-01,  6.775753e-01, -1.025931e-01, -7.459052e-01,  6.737602e-01},
  {-7.229936e-02, -7.479714e-01,  6.597815e-01, -7.036164e-02, -7.549933e-01,  6.677480e-01},
  {-4.940192e-01, -6.817644e-01,  5.395760e-01, -5.002430e-01, -6.866097e-01,  5.469652e-01},
  { 7.356225e-01, -5.407723e-01,  4.079521e-01,  7.445129e-01, -5.379298e-01,  4.209540e-01},
  { 7.639399e-01, -5.607802e-01,  3.192514e-01,  7.756172e-01, -5.678766e-01,  3.111348e-01},
  {-4.469220e-01, -7.534679e-01,  4.822311e-01, -4.590446e-01, -7.501505e-01,  4.973926e-01},
  { 7.126092e-01, -6.053481e-01,  3.546009e-01,  7.625187e-01, -6.228974e-01,  2.309949e-01},
  {-7.430145e-01, -5.798297e-01,  3.342560e-01, -7.505855e-01, -5.808821e-01,  3.464708e-01},
  {-8.956193e-01, -3.830482e-01,  2.261418e-01, -9.110666e-01, -3.800133e-01,  2.153883e-01},
  {-5.121156e-01, -7.164494e-01,  4.737488e-01, -5.172740e-01, -7.213213e-01,  4.826694e-01},
  {-6.805459e-01, -6.331901e-01,  3.686838e-01, -6.815947e-01, -6.403779e-01,  3.823478e-01},
  {-9.192072e-01, -3.397858e-01,  1.990074e-01, -9.256864e-01, -3.530028e-01,  1.983393e-01},
  { 7.861534e-01, -5.913565e-01,  1.796117e-01,  7.917988e-01, -6.036410e-01,  1.718819e-01},
  { 9.200292e-01, -3.910250e-01, -2.541315e-02,  8.880661e-01, -4.662787e-01, -1.305360e-01},
  { 9.243088e-01, -3.760501e-01, -6.511233e-02,  8.903979e-01, -4.582576e-01, -1.344133e-01},
  {-9.982057e-01, -5.150516e-02,  3.053761e-02, -1.008338e+00, -5.233184e-02,  3.690703e-02},
  { 9.134443e-01, -3.381658e-01, -2.264144e-01,  9.203237e-01, -3.451537e-01, -2.339886e-01},
  { 8.890953e-01, -3.837994e-01, -2.494143e-01,  8.978935e-01, -3.870981e-01, -2.545957e-01},
  {-9.924676e-01, -1.122165e-01, -4.914822e-02, -1.001275e+00, -1.212425e-01, -5.995587e-02},
  {-9.847355e-01, -1.570488e-01, -7.504404e-02, -9.954743e-01, -1.508179e-01, -8.444876e-02},
  {-9.563115e-01, -2.648158e-01, -1.238580e-01, -9.698365e-01, -2.554641e-01, -1.224799e-01},
  { 8.645678e-01, -3.568363e-01, -3.538227e-01,  8.727819e-01, -3.529910e-01, -3.667781e-01},
  {-8.833283e-01, -3.691492e-01, -2.888945e-01, -8.893027e-01, -3.811928e-01, -2.909973e-01},
  { 8.482325e-01, -3.486296e-01, -3.986967e-01,  8.569910e-01, -3.534674e-01, -4.018756e-01},
  { 8.177483e-01, -3.572369e-01, -4.512976e-01,  8.259425e-01, -3.678885e-01, -4.515787e-01},
  {-8.465082e-01, -3.920996e-01, -3.601135e-01, -8.570946e-01, -3.929578e-01, -3.630705e-01},
  { 7.638829e-01, -3.191102e-01, -5.609381e-01,  7.773227e-01, -3.226471e-01, -5.590569e-01},
  {-7.813560e-01, -3.781047e-01, -4.965075e-01, -7.853170e-01, -3.811701e-01, -5.087588e-01},
  { 7.228939e-01, -3.235673e-01, -6.105150e-01,  7.246962e-01, -3.252983e-01, -6.243974e-01},
  { 6.315780e-01, -3.382221e-01, -6.976496e-01,  6.373731e-01, -3.256754e-01, -7.131377e-01},
  { 5.918007e-01, -3.279279e-01, -7.363662e-01,  5.986898e-01, -3.263585e-01, -7.456102e-01},
  {-5.302094e-01, -4.171391e-01, -7.381551e-01, -5.396629e-01, -4.270509e-01, -7.397600e-01},
  {-5.626839e-01, -3.825715e-01, -7.328205e-01, -5.754282e-01, -3.860277e-01, -7.353355e-01},
  {-5.112636e-01, -4.194219e-01, -7.501299e-01, -5.197546e-01, -4.219656e-01, -7.567391e-01},
  { 4.869227e-01, -2.768412e-01, -8.284113e-01,  5.015420e-01, -2.772825e-01, -8.321317e-01},
  { 4.022426e-01, -2.187751e-01, -8.890098e-01,  4.061450e-01, -2.236306e-01, -8.977237e-01},
  {-5.877853e-01, -3.195509e-01, -7.432332e-01, -5.842689e-01, -3.398528e-01, -7.509884e-01},
  { 4.582660e-01, -2.415068e-01, -8.553751e-01,  4.594976e-01, -2.423316e-01, -8.666085e-01},
  {-5.278063e-01, -3.725074e-01, -7.633209e-01, -5.252995e-01, -3.720320e-01, -7.792112e-01},
  { 2.490150e-01, -2.088109e-01, -9.457217e-01,  2.383106e-01, -2.089497e-01, -9.593841e-01},
  {-3.393136e-01, -2.567762e-01, -9.049488e-01, -3.457413e-01, -2.623858e-01, -9.136640e-01},
  { 1.630121e-01, -2.042959e-01, -9.652411e-01,  1.660407e-01, -2.126014e-01, -9.737042e-01},
  {-2.848854e-01, -2.795468e-01, -9.168937e-01, -2.968675e-01, -2.770958e-01, -9.251743e-01},
  {-5.668924e-01, -2.153611e-01, -7.951432e-01, -5.504496e-01, -2.971572e-01, -7.934468e-01},
  {-1.989155e-01, -2.566040e-01, -9.458260e-01, -2.043189e-01, -2.632118e-01, -9.538527e-01},
  {-2.500985e-01, -3.112135e-01, -9.168407e-01, -2.543180e-01, -3.156407e-01, -9.255018e-01},
  { 2.418175e-01, -9.292584e-01,  2.792901e-01, -2.731482e-01, -3.268317e-01, -9.162045e-01},
  {-2.639335e-01, -3.767025e-01, -8.879383e-01, -2.748171e-01, -3.273064e-01, -9.155357e-01},
  {-2.545350e-01, -3.392569e-01, -9.056030e-01, -2.712891e-01, -3.266356e-01, -9.168266e-01},
  {-2.693967e-01, -3.224520e-01, -9.074415e-01, -2.721181e-01, -3.250023e-01, -9.171613e-01},
  {-2.620655e-01, -3.170386e-01, -9.114868e-01, -2.724111e-01, -3.253040e-01, -9.169675e-01},
  { 2.690534e-01,  3.226693e-01,  9.074661e-01, -2.710287e-01, -3.256109e-01, -9.172680e-01},
  { 2.694362e-01,  3.234808e-01,  9.070636e-01, -2.713113e-01, -3.265329e-01, -9.168566e-01},
  {-2.807367e-01, -3.294815e-01, -9.014593e-01, -2.711687e-01, -3.266810e-01, -9.168461e-01},
  { 3.489396e-01, -4.945858e-01,  7.960063e-01,  3.533739e-01, -5.078442e-01,  7.988015e-01},
  { 2.611929e-01, -5.112672e-01,  8.187699e-01,  2.703903e-01, -5.161218e-01,  8.254505e-01},
  { 5.169398e-01, -5.297176e-01,  6.724377e-01,  5.204735e-01, -5.443365e-01,  6.735507e-01},
  {-6.563180e-02, -5.702323e-01,  8.188575e-01, -6.834899e-02, -5.681912e-01,  8.326715e-01},
  {-9.897288e-02, -5.545328e-01,  8.262552e-01, -1.263070e-01, -5.652964e-01,  8.278528e-01},
  {-1.741992e-02, -5.180570e-01,  8.551686e-01, -1.605433e-02, -5.241669e-01,  8.636245e-01},
  { 5.772266e-01, -5.528687e-01,  6.009539e-01,  5.871196e-01, -5.574560e-01,  6.044834e-01},
  {-2.535163e-01, -5.018187e-01,  8.269870e-01, -2.494701e-01, -5.137007e-01,  8.335037e-01},
  {-1.852452e-01, -5.061844e-01,  8.422954e-01, -1.957880e-01, -5.108874e-01,  8.494200e-01},
  {-4.231596e-01, -5.802662e-01,  6.958643e-01, -4.291508e-01, -5.913594e-01,  6.982220e-01},
  {-4.775740e-01, -5.999923e-01,  6.418195e-01, -4.720584e-01, -6.085687e-01,  6.539518e-01},
  {-4.666315e-01, -6.200815e-01,  6.306774e-01, -4.797269e-01, -6.274040e-01,  6.301382e-01},
  {-4.787943e-01, -6.516316e-01,  5.883301e-01, -4.821069e-01, -6.520206e-01,  6.032397e-01},
  { 7.286669e-01, -5.159100e-01,  4.504236e-01,  7.390838e-01, -5.206493e-01,  4.511649e-01},
  { 8.376581e-01, -4.864878e-01,  2.483115e-01,  7.908370e-01, -5.523060e-01,  3.006759e-01},
  { 8.166723e-01, -5.298055e-01,  2.288070e-01,  7.878078e-01, -5.771440e-01,  2.629126e-01},
  { 8.435314e-01, -5.048324e-01,  1.833001e-01,  7.869768e-01, -5.858374e-01,  2.415225e-01},
  { 7.394626e-01, -5.829991e-01,  3.366114e-01,  7.777808e-01, -6.003853e-01,  2.355103e-01},
  {-7.089291e-01, -6.037114e-01,  3.646260e-01, -7.134681e-01, -6.106368e-01,  3.727342e-01},
  {-8.784574e-01, -4.051605e-01,  2.532934e-01, -8.790551e-01, -4.138877e-01,  2.771346e-01},
  {-7.324511e-01, -5.669714e-01,  3.769068e-01, -7.414572e-01, -5.769162e-01,  3.718247e-01},
  {-6.436771e-01, -6.481960e-01,  4.068435e-01, -6.611972e-01, -6.479449e-01,  4.047600e-01},
  {-9.325759e-01, -3.103463e-01,  1.843565e-01, -9.417256e-01, -3.160897e-01,  1.846212e-01},
  { 8.631384e-01, -5.003771e-01,  6.793340e-02,  8.677796e-01, -5.144838e-01,  7.299990e-02},
  {-7.530999e-01, -5.399181e-01,  3.759376e-01, -7.510066e-01, -5.567895e-01,  3.831700e-01},
  {-8.467236e-01, -4.244258e-01,  3.208143e-01, -8.468443e-01, -4.380522e-01,  3.343795e-01},
  {-5.580970e-01, -7.008270e-01,  4.442627e-01, -5.544866e-01, -7.168698e-01,  4.486620e-01},
  {-6.100679e-01, -6.748133e-01,  4.152639e-01, -6.137859e-01, -6.815006e-01,  4.238742e-01},
  {-9.664780e-01, -2.149721e-01,  1.403829e-01, -9.749233e-01, -2.184824e-01,  1.504512e-01},
  { 8.794888e-01, -4.738453e-01, -4.438587e-02,  8.902044e-01, -4.764275e-01, -3.778578e-02},
  {-9.833723e-01, -1.388082e-01,  1.170951e-01, -9.929401e-01, -1.454024e-01,  1.173635e-01},
  { 8.944503e-01, -3.976435e-01, -2.045441e-01,  9.081575e-01, -3.963596e-01, -1.975489e-01},
  {-9.998339e-01, -1.811352e-02,  2.032055e-03, -1.010239e+00, -1.603004e-02,  2.681846e-03},
  {-9.980579e-01, -5.200600e-02, -3.429091e-02, -1.008771e+00, -5.162654e-02, -2.371664e-02},
  {-9.813765e-01, -1.563443e-01, -1.116091e-01, -9.891134e-01, -1.713241e-01, -1.146712e-01},
  {-9.717821e-01, -2.118370e-01, -1.037526e-01, -9.802107e-01, -2.135736e-01, -1.200812e-01},
  {-9.192567e-01, -3.165360e-01, -2.340343e-01, -9.243655e-01, -3.270033e-01, -2.438518e-01},
  { 8.413442e-01, -3.359500e-01, -4.234118e-01,  8.491081e-01, -3.434174e-01, -4.265639e-01},
  {-9.013534e-01, -3.422805e-01, -2.653415e-01, -9.106525e-01, -3.279108e-01, -2.898852e-01},
  {-9.349303e-01, -2.893475e-01, -2.053860e-01, -9.490066e-01, -2.781070e-01, -2.070976e-01},
  {-8.700125e-01, -3.629381e-01, -3.336978e-01, -8.813139e-01, -3.607887e-01, -3.375861e-01},
  { 8.006757e-01, -3.269402e-01, -5.020244e-01,  8.081577e-01, -3.242895e-01, -5.124395e-01},
  {-8.280672e-01, -3.844387e-01, -4.080581e-01, -8.354087e-01, -3.849537e-01, -4.180320e-01},
  { 7.516866e-01, -2.789374e-01, -5.976298e-01,  7.616682e-01, -2.749673e-01, -6.042610e-01},
  {-8.052458e-01, -3.632396e-01, -4.686536e-01, -8.116506e-01, -3.742116e-01, -4.712086e-01},
  {-7.611195e-01, -3.703479e-01, -5.324842e-01, -7.744160e-01, -3.628671e-01, -5.380118e-01},
  {-7.447060e-01, -3.634367e-01, -5.597559e-01, -7.601894e-01, -3.680974e-01, -5.544963e-01},
  {-7.031222e-01, -3.581020e-01, -6.143145e-01, -7.096961e-01, -3.608891e-01, -6.220462e-01},
  { 7.045304e-01, -2.988106e-01, -6.436996e-01,  7.195787e-01, -2.917986e-01, -6.464797e-01},
  { 6.622564e-01, -3.133086e-01, -6.806278e-01,  6.705046e-01, -3.056299e-01, -6.912952e-01},
  {-6.335675e-01, -3.665014e-01, -6.813729e-01, -6.501051e-01, -3.483723e-01, -6.905450e-01},
  { 5.742261e-01, -2.876373e-01, -7.665046e-01,  5.787711e-01, -2.914754e-01, -7.752033e-01},
  { 5.375462e-01, -2.476669e-01, -8.060429e-01,  5.395296e-01, -2.564471e-01, -8.148721e-01},
  { 5.652235e-01, -2.699670e-01, -7.795129e-01,  5.684274e-01, -2.791642e-01, -7.872939e-01},
  { 3.567048e-01, -2.218775e-01, -9.074867e-01,  3.664753e-01, -2.154595e-01, -9.165941e-01},
  { 3.013007e-01, -2.061891e-01, -9.309694e-01,  2.998961e-01, -2.012025e-01, -9.436370e-01},
  {-4.096899e-01, -2.498368e-01, -8.773459e-01, -4.250919e-01, -2.545525e-01, -8.805440e-01},
  {-5.376595e-01, -3.272178e-01, -7.770783e-01, -5.453049e-01, -3.284745e-01, -7.850415e-01},
  {-3.745767e-01, -2.221340e-01, -9.001937e-01, -4.904062e-01, -2.771786e-01, -8.387670e-01},
  { 1.512024e-02, -2.107709e-01, -9.774186e-01,  1.098969e-02, -2.095444e-01, -9.883504e-01},
  {-2.849142e-01, -3.385961e-01, -8.967590e-01, -2.757394e-01, -3.272324e-01, -9.152849e-01},
  {-2.894808e-01, -3.054616e-01, -9.071351e-01, -2.735352e-01, -3.236135e-01, -9.172309e-01},
  { 2.692315e-01,  3.248162e-01,  9.066471e-01, -2.709238e-01, -3.280879e-01, -9.164160e-01},
  { 2.709308e-01,  3.204802e-01,  9.076833e-01, -2.721381e-01, -3.267973e-01, -9.165173e-01},
  { 2.250926e-01, -5.029535e-01,  8.344885e-01,  2.241663e-01, -5.077507e-01,  8.442742e-01},
  { 4.152936e-01, -4.806472e-01,  7.723402e-01,  4.164493e-01, -5.046829e-01,  7.698890e-01},
  { 2.162648e-01, -5.054004e-01,  8.353442e-01,  1.893386e-01, -5.095498e-01,  8.529493e-01},
  { 4.508862e-01, -4.619572e-01,  7.637389e-01,  4.589013e-01, -4.590020e-01,  7.743332e-01},
  { 4.353769e-01, -5.163510e-01,  7.374474e-01,  4.422146e-01, -5.118695e-01,  7.505333e-01},
  { 4.751239e-01, -4.783014e-01,  7.385697e-01,  4.778489e-01, -4.902131e-01,  7.431129e-01},
  { 1.432173e-01, -5.062639e-01,  8.504033e-01,  1.535858e-01, -5.071623e-01,  8.602656e-01},
  { 4.724051e-01, -5.152696e-01,  7.150739e-01,  4.856740e-01, -5.289276e-01,  7.107892e-01},
  { 5.052732e-01, -4.737348e-01,  7.213005e-01,  5.077966e-01, -4.709383e-01,  7.356804e-01},
  {-3.794330e-01, -5.032778e-01,  7.763646e-01, -3.831197e-01, -5.175578e-01,  7.785907e-01},
  { 3.040793e-02, -5.214645e-01,  8.527310e-01,  3.945356e-02, -5.196061e-01,  8.656268e-01},
  {-4.175238e-01, -5.412829e-01,  7.298538e-01, -4.242793e-01, -5.392236e-01,  7.416700e-01},
  { 5.655366e-01, -5.283604e-01,  6.332485e-01,  5.703381e-01, -5.439509e-01,  6.322171e-01},
  {-1.286667e-01, -5.225478e-01,  8.428455e-01, -1.280591e-01, -5.292704e-01,  8.510745e-01},
  {-4.599158e-01, -5.617426e-01,  6.876938e-01, -4.701698e-01, -5.676891e-01,  6.910266e-01},
  {-6.267317e-02, -5.197629e-01,  8.520085e-01, -6.227158e-02, -5.147135e-01,  8.672068e-01},
  {-3.127346e-01, -4.805566e-01,  8.193060e-01, -3.142183e-01, -4.868191e-01,  8.277231e-01},
  {-3.465220e-01, -4.745221e-01,  8.091670e-01, -3.556601e-01, -4.726380e-01,  8.191278e-01},
  {-2.206625e-01, -4.810478e-01,  8.484699e-01, -2.207134e-01, -4.903153e-01,  8.554932e-01},
  { 6.244833e-01, -5.281473e-01,  5.753964e-01,  6.304751e-01, -5.324866e-01,  5.829468e-01},
  {-2.818705e-01, -4.573932e-01,  8.434100e-01, -2.889927e-01, -4.607727e-01,  8.514833e-01},
  { 6.701841e-01, -5.256513e-01,  5.239694e-01,  6.798900e-01, -5.228757e-01,  5.340594e-01},
  { 7.145445e-01, -4.926966e-01,  4.966652e-01,  7.201384e-01, -5.059728e-01,  4.962481e-01},
  {-5.233647e-01, -6.171620e-01,  5.875376e-01, -5.137217e-01, -6.358079e-01,  5.938733e-01},
  { 8.040631e-01, -4.973859e-01,  3.257143e-01,  8.053167e-01, -5.150614e-01,  3.278139e-01},
  {-5.142438e-01, -6.540831e-01,  5.547329e-01, -5.167300e-01, -6.605741e-01,  5.634527e-01},
  { 7.620047e-01, -5.122028e-01,  3.962285e-01,  7.743772e-01, -5.120304e-01,  3.987930e-01},
  {-5.325351e-01, -6.836624e-01,  4.990112e-01, -5.411046e-01, -6.878339e-01,  5.049127e-01},
  { 7.989619e-01, -5.516773e-01,  2.393990e-01,  7.980300e-01, -5.791211e-01,  2.205404e-01},
  { 8.370606e-01, -5.321451e-01,  1.270870e-01,  8.431375e-01, -5.415586e-01,  1.292524e-01},
  {-8.212529e-01, -4.426605e-01,  3.599934e-01, -8.262423e-01, -4.498734e-01,  3.684866e-01},
  {-9.487147e-01, -2.691833e-01,  1.657733e-01, -9.569115e-01, -2.727254e-01,  1.754607e-01},
  {-9.715393e-01, -1.813970e-01,  1.523362e-01, -9.839828e-01, -1.772089e-01,  1.456732e-01},
  { 8.978534e-01, -4.357117e-01, -6.336155e-02,  9.031066e-01, -4.488005e-01, -6.206412e-02},
  {-9.962117e-01, -4.054838e-02,  7.692898e-02, -1.005980e+00, -3.757982e-02,  8.625707e-02},
  {-9.915383e-01, -8.690003e-02,  9.643727e-02, -1.002630e+00, -8.049794e-02,  9.539468e-02},
  {-9.987022e-01, -5.067842e-03,  5.067914e-02, -1.009358e+00, -4.842505e-03,  4.495087e-02},
  { 9.006769e-01, -4.040413e-01, -1.597866e-01,  9.111082e-01, -4.047928e-01, -1.640154e-01},
  {-9.954952e-01, -6.827341e-02, -6.578860e-02, -1.005575e+00, -6.941616e-02, -6.961909e-02},
  {-9.890838e-01, -1.078048e-01, -1.004566e-01, -1.000374e+00, -1.074570e-01, -9.247549e-02},
  {-9.691881e-01, -1.958916e-01, -1.493350e-01, -9.814315e-01, -1.946393e-01, -1.405506e-01},
  {-9.533037e-01, -2.440340e-01, -1.779310e-01, -9.624513e-01, -2.483495e-01, -1.812640e-01},
  {-8.513610e-01, -3.562539e-01, -3.850553e-01, -8.622248e-01, -3.597884e-01, -3.846664e-01},
  { 8.324033e-01, -3.190726e-01, -4.530976e-01,  8.412466e-01, -3.167732e-01, -4.613416e-01},
  { 7.833848e-01, -2.738234e-01, -5.579686e-01,  7.889323e-01, -2.858562e-01, -5.628045e-01},
  { 6.937891e-01, -2.663522e-01, -6.691137e-01,  6.995999e-01, -2.755713e-01, -6.749047e-01},
  {-6.458645e-01, -3.590293e-01, -6.737633e-01, -6.719410e-01, -3.494700e-01, -6.687434e-01},
  { 6.239496e-01, -2.764062e-01, -7.309490e-01,  6.298151e-01, -2.747009e-01, -7.420378e-01},
  {-6.351300e-01, -3.081687e-01, -7.082668e-01, -6.494141e-01, -3.157817e-01, -7.066796e-01},
  { 4.810262e-01, -2.201587e-01, -8.486129e-01,  4.864204e-01, -2.303223e-01, -8.551142e-01},
  { 6.148978e-02, -1.853050e-01, -9.807554e-01,  6.353293e-02, -1.946195e-01, -9.894210e-01},
  {-2.429940e-01, -2.541772e-01, -9.361345e-01, -2.279774e-01, -2.553726e-01, -9.506169e-01},
  {-3.605851e-02, -1.967916e-01, -9.797820e-01, -4.507086e-02, -2.076214e-01, -9.877890e-01},
  {-1.403452e-01, -2.192719e-01, -9.655169e-01, -1.406891e-01, -2.231943e-01, -9.753226e-01},
  { 5.493973e-01, -4.624673e-01,  6.959071e-01,  5.549669e-01, -4.610539e-01,  7.073246e-01},
  { 5.708530e-01, -4.175275e-01,  7.069637e-01,  5.670980e-01, -4.387761e-01,  7.118586e-01},
  {-4.574480e-01, -5.248825e-01,  7.178019e-01, -4.619592e-01, -5.328997e-01,  7.235057e-01},
  {-8.395131e-02, -4.983259e-01,  8.629157e-01, -8.276206e-02, -4.980692e-01,  8.751758e-01},
  {-5.176204e-01, -5.471303e-01,  6.578127e-01, -5.095993e-01, -5.529571e-01,  6.748296e-01},
  {-1.844454e-01, -4.582391e-01,  8.694808e-01, -1.833652e-01, -4.653291e-01,  8.778952e-01},
  {-5.142689e-01, -5.670065e-01,  6.434526e-01, -5.132340e-01, -5.762243e-01,  6.522300e-01},
  {-2.384507e-01, -4.529023e-01,  8.590814e-01, -2.404130e-01, -4.466415e-01,  8.738227e-01},
  {-3.313129e-01, -4.294944e-01,  8.400991e-01, -3.305175e-01, -4.356997e-01,  8.495739e-01},
  {-2.646276e-01, -4.147421e-01,  8.706096e-01, -2.648396e-01, -4.337099e-01,  8.732746e-01},
  { 8.030741e-01, -4.792696e-01,  3.540801e-01,  7.980850e-01, -4.998782e-01,  3.661336e-01},
  { 7.439704e-01, -4.818217e-01,  4.629859e-01,  7.472117e-01, -4.846639e-01,  4.771228e-01},
  { 8.161744e-01, -4.993628e-01,  2.906823e-01,  8.159330e-01, -5.200257e-01,  2.910302e-01},
  {-5.466337e-01, -6.593238e-01,  5.162206e-01, -5.544901e-01, -6.691077e-01,  5.154434e-01},
  {-6.966739e-01, -5.930584e-01,  4.036425e-01, -6.971923e-01, -6.074913e-01,  4.070900e-01},
  {-8.798040e-01, -3.795757e-01,  2.861243e-01, -8.926106e-01, -3.813707e-01,  2.804414e-01},
  {-9.134712e-01, -3.320093e-01,  2.352450e-01, -9.222929e-01, -3.410778e-01,  2.321347e-01},
  {-6.127737e-01, -6.531909e-01,  4.448034e-01, -6.149580e-01, -6.668589e-01,  4.449400e-01},
  {-7.693102e-01, -4.974932e-01,  4.008270e-01, -7.799370e-01, -5.008654e-01,  4.020906e-01},
  { 8.870007e-01, -4.617679e-01,  2.841564e-04,  9.018339e-01, -4.555856e-01, -3.538348e-03},
  {-9.612202e-01, -2.036262e-01,  1.859895e-01, -9.722443e-01, -2.066859e-01,  1.812941e-01},
  { 9.209407e-01, -3.536494e-01, -1.637080e-01,  9.333645e-01, -3.459665e-01, -1.732493e-01},
  {-9.975689e-01,  1.645779e-02,  6.771624e-02, -1.008141e+00,  1.834024e-02,  6.453034e-02},
  { 9.197275e-01, -2.947459e-01, -2.592801e-01,  9.309259e-01, -2.888965e-01, -2.660717e-01},
  {-9.997631e-01,  2.112900e-02,  5.238723e-03, -1.010138e+00,  2.140929e-02, -3.276074e-03},
  {-9.990717e-01,  2.349894e-03, -4.301574e-02, -1.009269e+00, -7.627978e-03, -4.653103e-02},
  {-9.762916e-01, -1.478959e-01, -1.580553e-01, -9.887000e-01, -1.499422e-01, -1.443493e-01},
  { 8.979482e-01, -2.626979e-01, -3.530987e-01,  9.004431e-01, -2.796938e-01, -3.631143e-01},
  {-8.712702e-01, -3.257167e-01, -3.671467e-01, -8.750743e-01, -3.405043e-01, -3.730273e-01},
  {-8.942069e-01, -3.157782e-01, -3.172981e-01, -9.069433e-01, -3.184249e-01, -3.112982e-01},
  {-9.163576e-01, -2.866735e-01, -2.794761e-01, -9.266400e-01, -2.831516e-01, -2.863749e-01},
  {-9.339541e-01, -2.631999e-01, -2.417756e-01, -9.451697e-01, -2.606136e-01, -2.440933e-01},
  { 8.695196e-01, -3.644133e-01, -3.333747e-01,  8.751662e-01, -2.905065e-01, -4.129987e-01},
  { 8.305478e-01, -5.355639e-01, -1.528453e-01,  8.798680e-01, -2.831852e-01, -4.080643e-01},
  { 8.617538e-01, -4.104778e-01, -2.981416e-01,  8.830044e-01, -2.794721e-01, -4.065779e-01},
  { 8.532070e-01, -2.897259e-01, -4.337012e-01,  8.626318e-01, -2.846129e-01, -4.424249e-01},
  { 8.350816e-01, -2.837957e-01, -4.712734e-01,  8.425338e-01, -2.942079e-01, -4.737680e-01},
  {-8.292316e-01, -3.545238e-01, -4.320740e-01, -8.392192e-01, -3.575181e-01, -4.344423e-01},
  { 7.615618e-01, -2.233204e-01, -6.084009e-01,  7.715480e-01, -2.297195e-01, -6.112215e-01},
  { 7.289544e-01, -2.412215e-01, -6.406541e-01,  7.421474e-01, -2.416410e-01, -6.416415e-01},
  { 6.661295e-01, -2.456326e-01, -7.042273e-01,  6.717143e-01, -2.438247e-01, -7.143006e-01},
  { 5.627394e-01, -2.552420e-01, -7.862417e-01,  5.722234e-01, -2.548193e-01, -7.927812e-01},
  { 5.091137e-01, -2.244457e-01, -8.309196e-01,  5.093336e-01, -2.309852e-01, -8.415728e-01},
  {-5.883144e-01, -2.813629e-01, -7.581036e-01, -5.950826e-01, -2.808463e-01, -7.667179e-01},
  {-3.842912e-01, -2.330664e-01, -8.933086e-01, -3.783798e-01, -2.344361e-01, -9.070432e-01},
  {-2.892010e-01, -2.219973e-01, -9.311714e-01, -3.030706e-01, -2.330014e-01, -9.352641e-01},
  {-5.462678e-01, -2.518842e-01, -7.988403e-01, -5.504258e-01, -2.491380e-01, -8.102542e-01},
  {-5.124096e-01, -2.493939e-01, -8.217293e-01, -5.232618e-01, -2.518139e-01, -8.268270e-01},
  { 1.066740e-01, -1.839367e-01, -9.771326e-01,  1.053674e-01, -1.833898e-01, -9.879948e-01},
  {-1.007178e-01, -2.029744e-01, -9.739904e-01, -9.196414e-02, -2.051918e-01, -9.850397e-01},
  { 2.963527e-01, -4.797432e-01,  8.258460e-01,  3.043234e-01, -4.898568e-01,  8.297479e-01},
  { 3.846794e-01, -4.617059e-01,  7.992806e-01,  3.923336e-01, -4.659011e-01,  8.061478e-01},
  { 4.343392e-01, -4.384557e-01,  7.868329e-01,  4.501358e-01, -4.354082e-01,  7.928825e-01},
  { 4.828235e-01, -4.225116e-01,  7.670498e-01,  4.822077e-01, -4.246288e-01,  7.797641e-01},
  { 5.333148e-01, -4.147422e-01,  7.372681e-01,  5.232425e-01, -4.234796e-01,  7.534912e-01},
  {-4.272335e-01, -5.043250e-01,  7.504184e-01, -4.265187e-01, -5.089038e-01,  7.615433e-01},
  { 5.382983e-01, -4.977745e-01,  6.800408e-01,  5.426909e-01, -4.957589e-01,  6.932359e-01},
  { 6.049703e-02, -4.898804e-01,  8.696880e-01,  5.748627e-02, -4.907934e-01,  8.812916e-01},
  { 6.283972e-03, -4.867707e-01,  8.735072e-01, -1.487730e-03, -4.974488e-01,  8.794311e-01},
  { 5.913428e-01, -4.379156e-01,  6.771584e-01,  5.938737e-01, -4.444302e-01,  6.860493e-01},
  {-4.993509e-01, -5.157667e-01,  6.961561e-01, -5.099021e-01, -5.269636e-01,  6.950952e-01},
  {-1.330756e-01, -4.799360e-01,  8.671519e-01, -1.279267e-01, -4.828303e-01,  8.782734e-01},
  {-3.755378e-01, -4.477464e-01,  8.114767e-01, -3.746875e-01, -4.491934e-01,  8.241677e-01},
  { 6.972314e-01, -4.688410e-01,  5.422699e-01,  6.966064e-01, -4.901042e-01,  5.435134e-01},
  {-2.991349e-01, -4.163399e-01,  8.585915e-01, -3.063982e-01, -4.116921e-01,  8.703344e-01},
  {-5.455660e-01, -5.757116e-01,  6.090270e-01, -5.560367e-01, -5.798126e-01,  6.127703e-01},
  { 8.148176e-01, -4.773425e-01,  3.289628e-01,  8.186955e-01, -4.866832e-01,  3.372678e-01},
  { 7.746925e-01, -4.806772e-01,  4.108540e-01,  7.857331e-01, -4.877622e-01,  4.069189e-01},
  {-5.528195e-01, -6.286990e-01,  5.469260e-01, -5.534740e-01, -6.417634e-01,  5.501390e-01},
  { 8.241605e-01, -5.115052e-01,  2.431502e-01,  8.256894e-01, -5.239002e-01,  2.542398e-01},
  { 8.866839e-01, -4.520248e-01,  9.728957e-02,  8.935796e-01, -4.624221e-01,  9.249839e-02},
  {-5.742312e-01, -6.647424e-01,  4.778872e-01, -5.780516e-01, -6.782749e-01,  4.760731e-01},
  { 8.916423e-01, -4.504048e-01,  4.593001e-02,  8.998732e-01, -4.571328e-01,  4.618321e-02},
  { 8.190309e-01, -5.527290e-01,  1.538794e-01,  8.345960e-01, -5.454904e-01,  1.635914e-01},
  {-6.684617e-01, -6.054776e-01,  4.319211e-01, -6.788541e-01, -6.075155e-01,  4.369523e-01},
  {-7.371997e-01, -5.314231e-01,  4.172842e-01, -7.438473e-01, -5.400611e-01,  4.193689e-01},
  {-9.328373e-01, -2.829141e-01,  2.231013e-01, -9.466677e-01, -2.721521e-01,  2.249415e-01},
  {-9.877715e-01, -6.182697e-02,  1.431259e-01, -9.987699e-01, -7.377333e-02,  1.336522e-01},
  {-9.816452e-01, -1.080176e-01,  1.571779e-01, -9.925862e-01, -1.171063e-01,  1.480042e-01},
  { 9.145759e-01, -3.954887e-01, -8.449587e-02,  9.236233e-01, -4.008509e-01, -8.435094e-02},
  {-9.941791e-01, -1.911549e-02,  1.060301e-01, -1.003343e+00, -3.061877e-02,  1.149426e-01},
  { 9.393692e-01, -2.905579e-01, -1.821034e-01,  9.452807e-01, -3.085624e-01, -1.791979e-01},
  { 9.082888e-01, -4.002591e-01, -1.216725e-01,  9.226826e-01, -3.945263e-01, -1.178235e-01},
  {-9.973834e-01,  5.028624e-02,  5.193844e-02, -1.008310e+00,  4.650042e-02,  4.469454e-02},
  {-9.938717e-01, -5.242164e-02, -9.731918e-02, -1.003305e+00, -5.357600e-02, -1.065663e-01},
  {-9.592918e-01, -2.025454e-01, -1.968113e-01, -9.666306e-01, -2.204248e-01, -1.946404e-01},
  {-9.400560e-01, -2.336568e-01, -2.483933e-01, -9.495886e-01, -2.439324e-01, -2.441834e-01},
  { 8.205506e-01, -2.596895e-01, -5.091742e-01,  8.224902e-01, -2.675833e-01, -5.242735e-01},
  { 7.852980e-01, -2.155447e-01, -5.803857e-01,  7.902678e-01, -2.364410e-01, -5.834811e-01},
  { 7.463199e-01, -1.895027e-01, -6.380402e-01,  7.554119e-01, -1.784950e-01, -6.468155e-01},
  { 7.232345e-01, -1.597737e-01, -6.718662e-01,  7.269285e-01, -1.674809e-01, -6.828158e-01},
  { 6.929163e-01, -1.572691e-01, -7.036573e-01,  7.095156e-01, -1.630702e-01, -7.006235e-01},
  { 7.118090e-01, -1.262329e-01, -6.909364e-01,  7.179987e-01, -1.204988e-01, -7.005969e-01},
  {-6.659535e-01, -3.191216e-01, -6.742903e-01, -6.818392e-01, -3.285355e-01, -6.706209e-01},
  {-7.405357e-01, -3.210448e-01, -5.903704e-01, -7.480558e-01, -3.224654e-01, -5.983599e-01},
  { 6.730214e-01, -2.066536e-01, -7.101665e-01,  6.798250e-01, -2.194836e-01, -7.145218e-01},
  { 6.199221e-01, -2.254411e-01, -7.515803e-01,  6.319967e-01, -2.181975e-01, -7.575260e-01},
  { 4.556240e-01, -1.833944e-01, -8.710759e-01,  4.530526e-01, -1.844739e-01, -8.840736e-01},
  { 3.132968e-01, -1.652877e-01, -9.351605e-01,  3.077675e-01, -1.720252e-01, -9.468673e-01},
  { 2.380937e-01, -1.783446e-01, -9.547275e-01,  2.347834e-01, -1.657736e-01, -9.687179e-01},
  { 1.375684e-01, -1.558248e-01, -9.781583e-01,  1.376352e-01, -1.671306e-01, -9.869106e-01},
  {-1.859405e-01, -2.130270e-01, -9.591901e-01, -1.884951e-01, -2.235263e-01, -9.671443e-01},
  { 2.137534e-01, -4.634372e-01,  8.599624e-01,  2.066360e-01, -4.613766e-01,  8.748106e-01},
  { 1.867347e-01, -5.613251e-01,  8.062532e-01,  1.676427e-01, -4.451516e-01,  8.914011e-01},
  { 1.477038e-01, -4.585319e-01,  8.763174e-01,  1.496547e-01, -4.608996e-01,  8.865858e-01},
  { 8.554436e-02, -4.199723e-01,  9.034962e-01,  9.056868e-02, -4.198975e-01,  9.145175e-01},
  { 7.405372e-02, -3.797460e-01,  9.221220e-01,  6.202060e-02, -3.771974e-01,  9.352723e-01},
  { 1.028785e-01, -4.656412e-01,  8.789735e-01,  1.073262e-01, -4.777206e-01,  8.838114e-01},
  { 2.685074e-02, -3.962486e-01,  9.177505e-01,  2.951020e-02, -4.008057e-01,  9.270069e-01},
  {-5.990985e-02, -3.881534e-01,  9.196455e-01, -5.605676e-02, -3.958462e-01,  9.279117e-01},
  { 5.944387e-01, -4.698670e-01,  6.525852e-01,  5.942498e-01, -4.754923e-01,  6.645614e-01},
  {-5.430055e-01, -5.192365e-01,  6.599533e-01, -5.437874e-01, -5.188730e-01,  6.752139e-01},
  { 6.206480e-01, -4.049202e-01,  6.714430e-01,  6.312239e-01, -4.230590e-01,  6.659177e-01},
  { 6.310729e-01, -4.398478e-01,  6.389686e-01,  6.387667e-01, -4.517936e-01,  6.393186e-01},
  { 6.161844e-01, -4.990327e-01,  6.093301e-01,  6.322469e-01, -5.001476e-01,  6.090849e-01},
  { 6.375229e-01, -4.609557e-01,  6.173203e-01,  6.444204e-01, -4.644182e-01,  6.248943e-01},
  {-1.476298e-01, -4.430076e-01,  8.842791e-01, -1.553078e-01, -4.521250e-01,  8.901218e-01},
  {-3.269516e-01, -3.879511e-01,  8.617404e-01, -3.268780e-01, -3.835629e-01,  8.757184e-01},
  { 8.293211e-01, -4.835728e-01,  2.799711e-01,  8.376764e-01, -4.881636e-01,  2.843718e-01},
  { 6.869667e-01, -5.833789e-01,  4.332964e-01,  7.703205e-01, -4.649507e-01,  4.596721e-01},
  { 7.192258e-01, -5.767887e-01,  3.873359e-01,  7.813634e-01, -4.648430e-01,  4.407535e-01},
  { 7.276530e-01, -5.453963e-01,  4.160098e-01,  7.779408e-01, -4.638041e-01,  4.500321e-01},
  {-8.234872e-01, -3.399593e-01,  4.541987e-01, -8.195789e-01, -4.103049e-01,  4.251887e-01},
  { 8.135513e-01, -5.412949e-01,  2.124479e-01,  8.237988e-01, -5.493689e-01,  2.010507e-01},
  {-7.992920e-01, -4.492477e-01,  3.991348e-01, -8.064060e-01, -4.517592e-01,  4.080047e-01},
  {-8.738015e-01, -3.516269e-01,  3.359011e-01, -8.772794e-01, -3.666463e-01,  3.417547e-01},
  {-8.963269e-01, -3.420204e-01,  2.821705e-01, -9.079812e-01, -3.368762e-01,  2.879746e-01},
  { 9.075344e-01, -4.197610e-01,  1.349206e-02,  9.151923e-01, -4.277950e-01,  1.703253e-02},
  { 9.174865e-01, -3.940175e-01, -5.448494e-02,  9.269120e-01, -3.985239e-01, -5.375293e-02},
  {-9.716486e-01, -1.527045e-01,  1.805002e-01, -9.797367e-01, -1.504530e-01,  1.957703e-01},
  { 9.286637e-01, -3.535758e-01, -1.121063e-01,  9.348876e-01, -3.674510e-01, -1.088205e-01},
  {-9.936935e-01,  6.634066e-02,  9.039996e-02, -1.005017e+00,  5.294063e-02,  8.936307e-02},
  { 9.379472e-01, -2.605806e-01, -2.288074e-01,  9.477562e-01, -2.688138e-01, -2.244463e-01},
  {-9.959363e-01,  7.774907e-02,  4.545235e-02, -1.005877e+00,  7.860555e-02,  5.367649e-02},
  {-9.921432e-01,  1.170921e-01,  4.406061e-02, -1.003029e+00,  1.151172e-01,  3.911776e-02},
  { 8.394370e-01, -2.561045e-03, -5.434510e-01,  8.437762e-01, -8.727169e-04, -5.558075e-01},
  { 8.151239e-01,  2.360999e-02, -5.788053e-01,  8.298996e-01,  1.937717e-02, -5.759969e-01},
  { 8.074795e-01,  4.176468e-02, -5.884152e-01,  8.155131e-01,  4.225870e-02, -5.950074e-01},
  {-9.933413e-01,  1.151943e-01, -1.829885e-03, -1.002061e+00,  1.293164e-01, -5.216809e-04},
  {-9.982188e-01,  5.869609e-02, -1.067788e-02, -1.008468e+00,  6.135762e-02, -8.726046e-03},
  {-9.959373e-01, -1.473263e-02, -8.883581e-02, -1.006544e+00, -1.829124e-02, -8.592106e-02},
  {-9.860001e-01, -9.183532e-02, -1.391760e-01, -9.953185e-01, -9.187941e-02, -1.474681e-01},
  { 8.309159e-01, -5.747205e-02, -5.534217e-01,  8.431441e-01, -5.473447e-02, -5.540693e-01},
  { 8.048691e-01, -5.886966e-02, -5.905253e-01,  8.217781e-01, -3.689581e-02, -5.866855e-01},
  { 7.708982e-01,  2.900277e-02, -6.362976e-01,  7.788515e-01,  3.344419e-02, -6.427693e-01},
  { 8.045284e-01,  1.105552e-01, -5.835337e-01,  7.702358e-01,  4.978876e-02, -6.520267e-01},
  { 8.230067e-01,  1.582818e-01, -5.455335e-01,  7.618725e-01,  6.556097e-02, -6.604035e-01},
  { 9.079255e-01, -2.780527e-01, -3.136204e-01,  9.203575e-01, -2.617169e-01, -3.245382e-01},
  { 7.931843e-01, -2.089040e-02, -6.086233e-01,  8.024602e-01, -2.587980e-02, -6.150557e-01},
  { 7.763959e-01, -8.896161e-04, -6.302450e-01,  7.833788e-01, -1.852894e-02, -6.378515e-01},
  { 7.378804e-01,  5.019001e-02, -6.730627e-01,  7.439035e-01,  6.151363e-02, -6.809582e-01},
  { 7.558578e-01, -1.864934e-02, -6.544701e-01,  7.661554e-01, -6.404348e-03, -6.586691e-01},
  {-9.194552e-01, -2.527783e-01, -3.011732e-01, -9.294633e-01, -2.544775e-01, -3.036226e-01},
  { 7.703708e-01, -7.497121e-02, -6.331730e-01,  7.802258e-01, -7.995520e-02, -6.369727e-01},
  { 7.027837e-01,  8.131326e-02, -7.067412e-01,  7.086033e-01,  7.592597e-02, -7.162380e-01},
  {-8.925287e-01, -2.872059e-01, -3.477143e-01, -8.981442e-01, -2.975532e-01, -3.544665e-01},
  { 7.204211e-01,  7.761126e-03, -6.934934e-01,  7.319705e-01,  2.585698e-03, -6.978106e-01},
  { 7.251506e-01, -4.940138e-02, -6.868160e-01,  7.345987e-01, -3.385336e-02, -6.928912e-01},
  {-8.514364e-01, -3.085928e-01, -4.240597e-01, -8.606902e-01, -3.161409e-01, -4.244002e-01},
  { 7.330319e-01, -1.168357e-01, -6.700848e-01,  7.510257e-01, -1.116644e-01, -6.666110e-01},
  { 7.272172e-01, -7.441755e-02, -6.823615e-01,  7.294822e-01, -8.383211e-02, -6.940508e-01},
  { 6.810817e-01,  2.555465e-02, -7.317614e-01,  6.935906e-01,  2.226793e-02, -7.343811e-01},
  { 6.657445e-01,  7.463314e-02, -7.424380e-01,  6.669363e-01,  6.951205e-02, -7.558065e-01},
  {-8.191168e-01, -3.265676e-01, -4.715944e-01, -8.340838e-01, -3.199138e-01, -4.720256e-01},
  { 6.827841e-01, -2.357145e-02, -7.302399e-01,  6.905301e-01, -3.206640e-02, -7.368981e-01},
  { 7.011107e-01, -2.207931e-01, -6.780077e-01,  7.061321e-01, -2.249691e-01, -6.867627e-01},
  { 6.726093e-01, -6.017229e-02, -7.375473e-01,  6.877943e-01, -5.933894e-02, -7.377643e-01},
  { 6.363378e-01,  8.646518e-02, -7.665494e-01,  6.418050e-01,  9.191497e-02, -7.749305e-01},
  { 6.184145e-01,  1.315270e-01, -7.747671e-01,  6.233503e-01,  1.371933e-01, -7.832574e-01},
  {-7.946333e-01, -3.243941e-01, -5.131535e-01, -7.994491e-01, -3.248887e-01, -5.255263e-01},
  { 6.891146e-01, -1.541917e-01, -7.080579e-01,  6.930616e-01, -1.510519e-01, -7.195320e-01},
  { 6.783200e-01, -1.036879e-01, -7.274138e-01,  6.841394e-01, -9.640948e-02, -7.372492e-01},
  { 6.484731e-01,  2.600976e-02, -7.607931e-01,  6.507049e-01,  1.835455e-02, -7.727387e-01},
  { 6.575724e-01, -1.877369e-01, -7.296255e-01,  6.642813e-01, -1.929812e-01, -7.364544e-01},
  { 6.483894e-01, -1.964897e-02, -7.610552e-01,  6.509316e-01, -1.471343e-02, -7.726254e-01},
  { 5.854074e-01, -2.035361e-01, -7.847746e-01,  5.926360e-01, -2.117399e-01, -7.904581e-01},
  { 4.184517e-01, -1.618010e-01, -8.937106e-01,  4.147791e-01, -1.691159e-01, -9.056661e-01},
  {-6.180983e-01, -2.767569e-01, -7.357717e-01, -6.241693e-01, -2.665770e-01, -7.484671e-01},
  {-5.813699e-01, -2.494866e-01, -7.744452e-01, -5.922816e-01, -2.505969e-01, -7.792678e-01},
  {-4.463787e-01, -2.157297e-01, -8.684509e-01, -4.505293e-01, -2.246667e-01, -8.760171e-01},
  {-3.751057e-01, -1.871824e-01, -9.078867e-01, -3.766417e-01, -1.981592e-01, -9.163696e-01},
  { 1.894786e-01, -1.553080e-01, -9.695243e-01,  1.945608e-01, -1.503573e-01, -9.800044e-01},
  { 9.060176e-03, -1.696287e-01, -9.854664e-01,  2.428116e-02, -1.656004e-01, -9.964204e-01},
  { 2.646589e-01, -4.618061e-01,  8.465760e-01,  2.660434e-01, -4.687859e-01,  8.545889e-01},
  { 3.204295e-01, -4.499508e-01,  8.335882e-01,  3.251491e-01, -4.597456e-01,  8.389128e-01},
  { 4.057414e-01, -4.335849e-01,  8.045981e-01,  3.928604e-01, -4.422459e-01,  8.191113e-01},
  { 2.896427e-01, -4.943113e-01,  8.196117e-01,  1.719690e-01, -4.420281e-01,  8.933941e-01},
  { 4.447531e-01, -3.807808e-01,  8.106792e-01,  4.505287e-01, -4.024539e-01,  8.098890e-01},
  { 7.374959e-03, -3.518282e-01,  9.360355e-01,  9.280300e-03, -3.485162e-01,  9.483187e-01},
  { 3.711642e-02, -4.409271e-01,  8.967751e-01,  2.999061e-02, -4.457798e-01,  9.062221e-01},
  {-3.285678e-02, -4.110205e-01,  9.110337e-01, -2.082631e-02, -4.179131e-01,  9.196585e-01},
  {-4.253317e-01, -4.755228e-01,  7.700461e-01, -4.351661e-01, -4.770743e-01,  7.770973e-01},
  { 5.780029e-01, -4.929613e-01,  6.503091e-01,  5.935972e-01, -4.944758e-01,  6.511554e-01},
  {-1.186216e-01, -3.639341e-01,  9.238402e-01, -1.110684e-01, -3.680755e-01,  9.343662e-01},
  {-1.675436e-01, -4.014541e-01,  9.004242e-01, -1.711668e-01, -4.055690e-01,  9.094341e-01},
  { 6.613615e-01, -4.869682e-01,  5.704936e-01,  6.746426e-01, -4.769321e-01,  5.816032e-01},
  { 6.816486e-01, -4.380524e-01,  5.860592e-01,  6.847822e-01, -4.386460e-01,  5.996105e-01},
  {-2.155487e-01, -4.134972e-01,  8.846236e-01, -2.151570e-01, -4.180819e-01,  8.942979e-01},
  {-3.850613e-01, -4.034770e-01,  8.300205e-01, -3.944615e-01, -4.037936e-01,  8.379749e-01},
  {-4.064951e-01, -3.125129e-01,  8.585438e-01, -3.619105e-01, -3.764153e-01,  8.649764e-01},
  {-5.734144e-01, -5.915344e-01,  5.668182e-01, -5.952352e-01, -5.932916e-01,  5.608444e-01},
  { 7.947030e-01, -4.481495e-01,  4.094009e-01,  7.927089e-01, -4.536392e-01,  4.320832e-01},
  {-5.986441e-01, -6.027210e-01,  5.275911e-01, -5.953317e-01, -6.129156e-01,  5.392224e-01},
  {-7.910857e-01, -3.938749e-01,  4.680235e-01, -8.041332e-01, -4.010039e-01,  4.619642e-01},
  {-7.740307e-01, -4.516056e-01,  4.437666e-01, -7.784721e-01, -4.630229e-01,  4.477010e-01},
  {-8.399669e-01, -3.023749e-01,  4.505830e-01, -8.364148e-01, -4.005909e-01,  4.009766e-01},
  { 8.664413e-01, -4.786013e-01,  1.421978e-01,  8.748510e-01, -4.820617e-01,  1.520728e-01},
  {-8.515918e-01, -3.216879e-01,  4.138941e-01, -8.514933e-01, -3.900673e-01,  3.790140e-01},
  {-6.299294e-01, -6.129665e-01,  4.769288e-01, -6.389623e-01, -6.242095e-01,  4.730138e-01},
  {-9.099557e-01, -3.052038e-01,  2.807690e-01, -9.191664e-01, -3.098272e-01,  2.828166e-01},
  { 9.159131e-01, -4.010532e-01, -1.611176e-02,  9.267898e-01, -4.022200e-01, -1.248276e-02},
  {-9.484903e-01, -2.160609e-01,  2.316976e-01, -9.584908e-01, -2.164561e-01,  2.351333e-01},
  {-9.279659e-01, -2.593676e-01,  2.675963e-01, -9.401040e-01, -2.564327e-01,  2.670055e-01},
  {-9.893435e-01, -7.712312e-03,  1.453959e-01, -1.001172e+00,  9.603465e-03,  1.356809e-01},
  {-9.928476e-01,  4.031457e-02,  1.123758e-01, -1.002948e+00,  4.885835e-02,  1.120521e-01},
  { 8.274978e-01,  7.578575e-02, -5.563309e-01,  8.357685e-01,  7.468118e-02, -5.628459e-01},
  { 7.805362e-01,  8.465298e-02, -6.193522e-01,  7.913015e-01,  9.376988e-02, -6.212332e-01},
  {-9.877707e-01,  1.535556e-01,  2.701260e-02, -9.986320e-01,  1.519977e-01,  2.192002e-02},
  { 9.276553e-01, -2.398840e-01, -2.862016e-01,  9.372798e-01, -2.455286e-01, -2.865332e-01},
  { 8.555396e-01, -4.757566e-02, -5.155469e-01,  8.609236e-01, -5.110342e-02, -5.263835e-01},
  {-9.952375e-01,  8.549453e-02, -4.682913e-02, -1.006707e+00,  8.009890e-02, -3.120676e-02},
  {-9.908612e-01, -3.183176e-02, -1.310754e-01, -1.001553e+00, -2.677369e-02, -1.304739e-01},
  {-9.755647e-01, -9.727444e-02, -1.970056e-01, -9.847777e-01, -8.903790e-02, -2.076852e-01},
  { 7.823643e-01,  1.340666e-01, -6.082206e-01,  7.474690e-01,  9.387797e-02, -6.733186e-01},
  {-9.648539e-01, -1.576947e-01, -2.102123e-01, -9.750919e-01, -1.575065e-01, -2.126852e-01},
  { 7.961867e-01, -9.142204e-02, -5.981044e-01,  8.142078e-01, -1.065449e-01, -5.887218e-01},
  { 7.141725e-01,  1.084784e-01, -6.915128e-01,  7.254651e-01,  1.031911e-01, -6.956528e-01},
  { 7.728879e-01, -1.288653e-01, -6.213197e-01,  7.758790e-01, -1.321739e-01, -6.335776e-01},
  { 6.571828e-01,  1.332241e-01, -7.418640e-01,  6.619030e-01,  1.357092e-01, -7.512308e-01},
  { 7.785105e-01, -1.786017e-01, -6.016833e-01,  7.827117e-01, -1.804085e-01, -6.129382e-01},
  {-7.223961e-01, -3.805082e-01, -5.773710e-01, -7.501841e-01, -3.054622e-01, -6.039599e-01},
  {-6.755925e-01, -4.257765e-01, -6.019047e-01, -7.414851e-01, -3.020580e-01, -6.178052e-01},
  {-6.936997e-01, -3.566037e-01, -6.257911e-01, -7.339184e-01, -3.020977e-01, -6.252615e-01},
  {-6.540448e-01, -2.943695e-01, -6.968299e-01, -6.831594e-01, -2.994924e-01, -6.815056e-01},
  {-7.781535e-01, -2.948577e-01, -5.545593e-01, -7.832263e-01, -3.000755e-01, -5.633485e-01},
  { 5.504124e-01, -1.900331e-01, -8.129782e-01,  5.417585e-01, -1.885612e-01, -8.317555e-01},
  { 3.785738e-01, -1.718398e-01, -9.094795e-01,  3.928274e-01, -1.623324e-01, -9.166284e-01},
  { 5.160292e-01, -1.786245e-01, -8.377392e-01,  5.283468e-01, -1.767073e-01, -8.429109e-01},
  { 5.101727e-01, -1.385397e-01, -8.488408e-01,  5.079417e-01, -1.539171e-01, -8.597555e-01},
  { 5.428782e-01,  3.731044e-01, -7.523806e-01,  5.356657e-01,  4.500208e-01, -7.289891e-01},
  { 5.415760e-01,  5.848512e-01,  6.038579e-01,  5.349116e-01,  4.502231e-01, -7.294178e-01},
  { 5.468255e-01,  4.539929e-01, -7.034715e-01,  5.376657e-01,  4.497876e-01, -7.276595e-01},
  {-4.902575e-01, -3.888627e-01,  7.800214e-01,  5.354832e-01,  4.497041e-01, -7.293185e-01},
  { 5.326328e-01,  4.735998e-01, -7.014311e-01,  5.341374e-01,  4.509199e-01, -7.295547e-01},
  { 2.379611e-01, -1.353661e-01, -9.617955e-01,  2.327406e-01, -1.412882e-01, -9.730056e-01},
  {-2.898133e-01, -1.612363e-01, -9.434040e-01, -3.366974e-01, -1.922646e-01, -9.330216e-01},
  {-4.771278e-01, -2.294021e-01, -8.483654e-01, -4.748038e-01, -2.260214e-01, -8.627472e-01},
  {-2.273400e-01, -2.097803e-01, -9.509515e-01, -2.255243e-01, -2.096295e-01, -9.623181e-01},
  { 2.234061e-01,  9.434281e-01, -2.450169e-01, -3.561712e-01, -1.612137e-01, -9.316719e-01},
  {-3.536866e-01, -1.654708e-01, -9.206113e-01, -3.557571e-01, -1.651414e-01, -9.311420e-01},
  { 2.754680e-02, -1.279675e-01, -9.913957e-01,  3.009550e-02, -1.459598e-01, -9.993283e-01},
  {-4.040965e-02, -1.576907e-01, -9.866614e-01, -5.336802e-02, -1.588031e-01, -9.963930e-01},
  {-3.515180e-01, -1.600050e-01, -9.224063e-01, -3.557009e-01, -1.608264e-01, -9.319184e-01},
  { 3.107077e-01, -9.494959e-01,  4.379859e-02, -3.564430e-01, -1.565966e-01, -9.323551e-01},
  {-5.173990e-01,  8.539286e-01,  5.571572e-02, -3.570516e-01, -1.573165e-01, -9.320010e-01},
  {-9.320908e-01, -2.536327e-02,  3.613356e-01, -3.562455e-01, -1.552865e-01, -9.326497e-01},
  {-1.973124e-01, -1.937236e-02, -9.801493e-01, -3.552279e-01, -1.605056e-01, -9.321541e-01},
  {-3.537895e-01, -1.556236e-01, -9.222875e-01, -3.582017e-01, -1.567739e-01, -9.316511e-01},
  {-3.529876e-01, -1.553935e-01, -9.226336e-01, -3.574602e-01, -1.556149e-01, -9.321300e-01},
  {-3.554285e-01, -1.562911e-01, -9.215441e-01, -3.576250e-01, -1.562497e-01, -9.319606e-01},
  {-1.378174e-01, -1.830569e-01, -9.733943e-01, -1.168043e-01, -1.740354e-01, -9.883990e-01},
  {-1.552951e-01, -1.840549e-01, -9.705706e-01, -1.634887e-01, -1.898485e-01, -9.788219e-01},
  { 3.351256e-01, -3.375961e-01,  8.796134e-01,  1.729365e-01, -4.355632e-01,  8.951188e-01},
  { 3.527443e-01, -4.141358e-01,  8.390847e-01,  3.536855e-01, -4.195247e-01,  8.483921e-01},
  { 2.566777e-01, -4.259780e-01,  8.675594e-01,  2.522843e-01, -4.261102e-01,  8.807067e-01},
  { 2.304306e-01, -4.750666e-01,  8.492428e-01,  1.847138e-01, -4.361906e-01,  8.924566e-01},
  { 1.104734e-01, -4.238597e-01,  8.989652e-01,  1.329176e-01, -4.082815e-01,  9.146031e-01},
  { 4.800899e-01, -3.665379e-01,  7.969715e-01,  4.811687e-01, -3.891276e-01,  7.987005e-01},
  {-4.306513e-02, -3.299428e-01,  9.430181e-01, -4.210675e-02, -3.412282e-01,  9.500778e-01},
  {-4.689207e-01, -4.905768e-01,  7.344711e-01, -4.748177e-01, -4.920760e-01,  7.438133e-01},
  { 5.893162e-01, -3.904000e-01,  7.073148e-01,  6.029304e-01, -3.914170e-01,  7.100255e-01},
  {-3.527999e-02, -4.688216e-01,  8.825880e-01, -3.480223e-02, -4.708816e-01,  8.932613e-01},
  {-4.202470e-01, -4.432577e-01,  7.917796e-01, -4.233315e-01, -4.377064e-01,  8.062592e-01},
  {-5.383238e-01, -4.839968e-01,  6.898946e-01, -5.399657e-01, -4.922812e-01,  6.978139e-01},
  {-1.138374e-01, -4.111429e-01,  9.044349e-01, -1.406626e-01, -4.159210e-01,  9.099883e-01},
  {-1.974229e-01, -3.730577e-01,  9.065606e-01, -1.971286e-01, -3.832778e-01,  9.138341e-01},
  { 6.665958e-01, -4.046494e-01,  6.260263e-01,  6.686459e-01, -4.176388e-01,  6.319493e-01},
  {-5.747219e-01, -5.214123e-01,  6.307328e-01, -5.960472e-01, -5.148934e-01,  6.328188e-01},
  {-2.431986e-01, -3.707426e-01,  8.963283e-01, -2.520897e-01, -3.741591e-01,  9.040516e-01},
  {-6.006424e-01, -5.300010e-01,  5.986047e-01, -5.978738e-01, -5.389094e-01,  6.107131e-01},
  { 7.319536e-01, -4.447956e-01,  5.161402e-01,  7.408201e-01, -4.404642e-01,  5.273023e-01},
  { 8.326430e-01, -4.415148e-01,  3.343207e-01,  8.349496e-01, -4.486675e-01,  3.498996e-01},
  { 8.436528e-01, -4.616784e-01,  2.740495e-01,  8.573466e-01, -4.555326e-01,  2.798578e-01},
  { 8.108692e-01, -4.468994e-01,  3.778521e-01,  8.260055e-01, -4.463667e-01,  3.732887e-01},
  {-7.538248e-01, -4.401525e-01,  4.878667e-01, -7.603142e-01, -4.340027e-01,  5.043902e-01},
  {-5.900289e-01, -6.338961e-01,  5.000416e-01, -6.032018e-01, -6.303784e-01,  5.095259e-01},
  {-7.429460e-01, -4.656673e-01,  4.808172e-01, -7.581890e-01, -4.682364e-01,  4.761821e-01},
  { 8.428811e-01, -4.958656e-01,  2.089707e-01,  8.565142e-01, -4.971119e-01,  2.003411e-01},
  {-8.429810e-01, -3.659248e-01,  3.943122e-01, -8.515999e-01, -3.693379e-01,  3.990140e-01},
  { 9.079326e-01, -4.125920e-01,  7.366373e-02,  9.180599e-01, -4.143144e-01,  7.990755e-02},
  {-7.090476e-01, -5.554638e-01,  4.344095e-01, -7.149563e-01, -5.542855e-01,  4.499448e-01},
  {-9.045137e-01, -2.972643e-01,  3.057596e-01, -9.163303e-01, -2.945972e-01,  3.072400e-01},
  {-9.729108e-01, -1.092000e-01,  2.037642e-01, -9.822850e-01, -1.092948e-01,  2.098032e-01},
  {-9.615697e-01, -1.632701e-01,  2.207407e-01, -9.702738e-01, -1.583876e-01,  2.330842e-01},
  { 9.334279e-01, -3.574298e-01, -3.092191e-02,  9.406556e-01, -3.663711e-01, -4.261699e-02},
  { 9.401885e-01, -3.149213e-01, -1.298856e-01,  9.533152e-01, -3.075439e-01, -1.322310e-01},
  { 9.345022e-01, -3.489532e-01, -7.026549e-02,  9.450529e-01, -3.492253e-01, -7.611839e-02},
  { 8.458866e-01,  6.004456e-02, -5.299721e-01,  8.559375e-01,  6.658749e-02, -5.327467e-01},
  { 8.639542e-01,  3.715984e-02, -5.021974e-01,  8.670794e-01,  2.386254e-02, -5.181560e-01},
  { 8.074661e-01,  1.020118e-01, -5.810267e-01,  8.146818e-01,  9.837800e-02, -5.894890e-01},
  { 8.644327e-01, -2.744766e-03, -5.027410e-01,  8.765134e-01, -5.806669e-03, -5.025654e-01},
  { 8.776269e-01, -1.391477e-02, -4.791422e-01,  8.833942e-01, -1.413254e-02, -4.902002e-01},
  {-9.821909e-01,  1.850891e-01,  3.229663e-02, -9.913444e-01,  1.935968e-01,  2.463671e-02},
  {-9.836430e-01, -3.843074e-02, -1.759818e-01, -9.944342e-01, -4.132720e-02, -1.738994e-01},
  {-9.968283e-01,  3.620973e-02, -7.086703e-02, -1.006173e+00,  3.892573e-02, -8.336526e-02},
  { 8.701552e-01, -7.703859e-02, -4.867187e-01,  8.761904e-01, -8.013964e-02, -4.967380e-01},
  {-9.748514e-01,  2.209543e-01, -2.904870e-02, -9.867165e-01,  2.161430e-01, -2.288317e-02},
  {-9.842356e-01,  1.761205e-01, -1.618026e-02, -9.942111e-01,  1.790895e-01, -1.792643e-02},
  {-9.923136e-01,  3.282031e-02, -1.193171e-01, -1.002385e+00,  3.119759e-02, -1.228807e-01},
  {-9.893023e-01,  1.370126e-01, -5.008535e-02, -1.000245e+00,  1.337044e-01, -4.983004e-02},
  {-9.923472e-01,  7.704106e-02, -9.649716e-02, -1.002194e+00,  7.444302e-02, -1.044754e-01},
  { 8.302546e-01, -1.059608e-01, -5.472200e-01,  8.408040e-01, -1.070617e-01, -5.499692e-01},
  { 6.948659e-01,  1.210597e-01, -7.088765e-01,  7.019633e-01,  1.284440e-01, -7.152835e-01},
  {-9.464895e-01, -1.946622e-01, -2.574188e-01, -9.538732e-01, -1.963305e-01, -2.691242e-01},
  { 7.839716e-01, -1.340922e-01, -6.061417e-01,  7.944108e-01, -1.506952e-01, -6.058723e-01},
  { 8.582512e-01, -2.470284e-01, -4.498688e-01,  8.795453e-01, -2.372088e-01, -4.372191e-01},
  { 8.136303e-01, -2.130750e-01, -5.409295e-01,  8.331890e-01, -2.125942e-01, -5.305454e-01},
  {-8.236548e-01, -2.856766e-01, -4.898792e-01, -8.317586e-01, -2.962829e-01, -4.911652e-01},
  { 6.400082e-01, -1.572845e-01, -7.520977e-01,  6.456194e-01, -1.554967e-01, -7.614940e-01},
  { 6.168503e-01,  6.636836e-02, -7.842774e-01,  6.222934e-01,  6.571576e-02, -7.932914e-01},
  { 6.418576e-01, -1.028575e-01, -7.598941e-01,  6.452253e-01, -1.034939e-01, -7.706171e-01},
  { 6.279325e-01, -3.556055e-02, -7.774549e-01,  6.349041e-01, -2.281830e-02, -7.856552e-01},
  { 6.157953e-01,  5.547059e-03, -7.878866e-01,  6.217344e-01,  7.926650e-03, -7.964055e-01},
  { 5.827881e-01,  1.521905e-01, -7.982457e-01,  5.880347e-01,  1.517280e-01, -8.075104e-01},
  { 6.023599e-01, -1.439941e-01, -7.851294e-01,  6.143137e-01, -1.521952e-01, -7.876113e-01},
  {-6.511991e-01, -2.581452e-01, -7.136531e-01, -6.586543e-01, -2.602620e-01, -7.206188e-01},
  { 3.568767e-01, -1.455254e-01, -9.227467e-01,  3.674246e-01, -1.463550e-01, -9.297591e-01},
  { 5.350376e-01, -1.314337e-01, -8.345417e-01,  5.421450e-01, -1.398782e-01, -8.410639e-01},
  {-3.869350e-01, -1.550501e-01, -9.089778e-01, -3.566554e-01, -1.678473e-01, -9.303141e-01},
  { 3.385880e-01,  1.696120e-01,  9.255214e-01, -3.542892e-01, -1.618275e-01, -9.322827e-01},
  { 4.445137e-02,  1.034894e-01, -9.936368e-01, -3.518347e-01, -1.645149e-01, -9.327419e-01},
  { 5.636380e-01,  5.810375e-01, -5.871180e-01, -3.560822e-01, -1.595053e-01, -9.319999e-01},
  {-3.525037e-01, -1.538222e-01, -9.230818e-01, -3.546943e-01, -1.583312e-01, -9.327290e-01},
  {-1.190850e-01, -2.236393e-01, -9.673698e-01, -1.713946e-01, -1.488489e-01, -9.845464e-01},
  { 2.212737e-01, -4.104629e-01,  8.846232e-01,  2.276791e-01, -4.189296e-01,  8.907982e-01},
  { 2.447642e-01, -3.875906e-01,  8.887430e-01,  1.700343e-01, -4.138684e-01,  9.059038e-01},
  { 3.955788e-01, -3.925700e-01,  8.303049e-01,  3.884678e-01, -3.965358e-01,  8.442253e-01},
  { 3.030729e-01, -4.038829e-01,  8.631486e-01,  3.210504e-01, -3.981114e-01,  8.713766e-01},
  { 1.917804e-01, -3.827988e-01,  9.037065e-01,  1.903694e-01, -3.928044e-01,  9.112217e-01},
  { 2.632542e-01, -3.862127e-01,  8.840458e-01,  2.595691e-01, -3.895799e-01,  8.953846e-01},
  { 1.394006e-01, -3.752469e-01,  9.163827e-01,  1.458032e-01, -3.741272e-01,  9.271625e-01},
  {-9.455311e-02, -3.370558e-01,  9.367247e-01, -1.029784e-01, -3.393296e-01,  9.461011e-01},
  {-4.628124e-01, -4.597069e-01,  7.579408e-01, -4.642221e-01, -4.678156e-01,  7.658300e-01},
  {-5.066657e-01, -4.669541e-01,  7.247371e-01, -5.229178e-01, -4.684049e-01,  7.266377e-01},
  {-8.923636e-02, -4.362019e-01,  8.954132e-01, -8.675314e-02, -4.409699e-01,  9.049171e-01},
  {-4.412661e-01, -4.179303e-01,  7.941149e-01, -4.490401e-01, -4.217142e-01,  8.008559e-01},
  {-5.746847e-01, -4.791418e-01,  6.634459e-01, -5.884952e-01, -4.891584e-01,  6.597309e-01},
  { 7.202785e-01, -3.970575e-01,  5.688096e-01,  7.187213e-01, -4.149585e-01,  5.762984e-01},
  {-2.805298e-01, -3.605318e-01,  8.895616e-01, -2.806396e-01, -3.557324e-01,  9.030777e-01},
  { 7.199619e-01, -4.293841e-01,  5.452377e-01,  7.414588e-01, -4.261504e-01,  5.380574e-01},
  {-3.811398e-01, -3.411165e-01,  8.592858e-01, -3.780705e-01, -3.512919e-01,  8.686244e-01},
  {-3.284281e-01, -3.398300e-01,  8.812778e-01, -3.262427e-01, -3.454154e-01,  8.916875e-01},
  { 7.474793e-01, -4.423723e-01,  4.955617e-01,  7.693147e-01, -4.315767e-01,  4.927149e-01},
  {-6.131491e-01, -5.595163e-01,  5.576645e-01, -6.257972e-01, -5.663011e-01,  5.554522e-01},
  {-7.035758e-01, -4.851016e-01,  5.192856e-01, -7.203755e-01, -4.822133e-01,  5.195997e-01},
  {-6.354559e-01, -5.766162e-01,  5.135266e-01, -6.352089e-01, -5.929010e-01,  5.155812e-01},
  {-8.260372e-01, -3.438385e-01,  4.465846e-01, -8.350857e-01, -3.528021e-01,  4.461030e-01},
  {-7.385246e-01, -5.002546e-01,  4.520250e-01, -7.440289e-01, -5.019718e-01,  4.639942e-01},
  {-8.537098e-01, -3.356391e-01,  3.981531e-01, -8.687340e-01, -3.442688e-01,  3.842206e-01},
  { 8.944317e-01, -4.280228e-01,  1.295698e-01,  9.072418e-01, -4.240781e-01,  1.339600e-01},
  { 8.779647e-01, -4.437556e-01,  1.796077e-01,  8.856239e-01, -4.549891e-01,  1.718413e-01},
  {-6.592837e-01, -5.756230e-01,  4.837386e-01, -6.640748e-01, -5.855860e-01,  4.867640e-01},
  {-6.842451e-01, -5.571714e-01,  4.704983e-01, -6.886302e-01, -5.684693e-01,  4.727329e-01},
  { 9.261187e-01, -3.764156e-01,  2.480887e-02,  9.376431e-01, -3.755140e-01,  2.628959e-02},
  {-9.348913e-01, -2.108600e-01,  2.855106e-01, -9.436042e-01, -2.295035e-01,  2.788992e-01},
  {-9.815341e-01, -5.676709e-02,  1.826698e-01, -9.898163e-01, -5.827814e-02,  1.942013e-01},
  { 9.597058e-01, -2.266818e-01, -1.660725e-01,  9.675315e-01, -2.362288e-01, -1.701705e-01},
  { 9.497411e-01, -2.382267e-01, -2.030759e-01,  9.627131e-01, -2.349749e-01, -1.971030e-01},
  {-9.906738e-01,  9.599540e-02,  9.669621e-02, -9.989222e-01,  1.138197e-01,  1.002422e-01},
  { 8.816911e-01, -3.940563e-02, -4.701786e-01,  8.918946e-01, -3.858141e-02, -4.731983e-01},
  {-9.753776e-01,  2.188614e-01,  2.717156e-02, -9.856359e-01,  2.216520e-01,  1.559098e-02},
  {-9.736890e-01, -4.147081e-02, -2.240756e-01, -9.833443e-01, -5.058646e-02, -2.265469e-01},
  {-9.890089e-01,  7.478097e-03, -1.476668e-01, -9.999278e-01,  1.149927e-02, -1.444325e-01},
  {-9.632689e-01, -9.814917e-02, -2.499594e-01, -9.720879e-01, -1.186872e-01, -2.486089e-01},
  {-9.798144e-01,  1.894308e-01, -6.387377e-02, -9.874690e-01,  2.048468e-01, -6.159192e-02},
  { 8.606544e-01, -1.234474e-01, -4.939988e-01,  8.753002e-01, -1.134402e-01, -4.917935e-01},
  {-9.869284e-01,  1.291742e-01, -9.636520e-02, -9.963855e-01,  1.353219e-01, -9.876180e-02},
  {-9.843451e-01,  9.259152e-02, -1.499713e-01, -9.970334e-01,  8.221199e-02, -1.414754e-01},
  {-9.545358e-01, -1.489149e-01, -2.582360e-01, -9.632159e-01, -1.577457e-01, -2.611114e-01},
  { 8.472189e-01, -1.312210e-01, -5.147827e-01,  8.548599e-01, -1.377834e-01, -5.206822e-01},
  { 8.248596e-01, -1.223600e-01, -5.519371e-01,  8.323690e-01, -1.401285e-01, -5.553424e-01},
  {-9.093577e-01, -2.318638e-01, -3.454094e-01, -9.199654e-01, -2.305822e-01, -3.483439e-01},
  { 7.937174e-01, -1.513073e-01, -5.891680e-01,  8.119258e-01, -1.406033e-01, -5.847104e-01},
  {-8.774264e-01, -2.743775e-01, -3.934968e-01, -8.850234e-01, -2.771667e-01, -4.009494e-01},
  {-9.302366e-01, -2.016406e-01, -3.065958e-01, -9.404663e-01, -1.929051e-01, -3.148947e-01},
  { 8.748526e-01, -2.327821e-01, -4.247888e-01,  8.949866e-01, -2.348416e-01, -4.058659e-01},
  { 7.143236e-01, -3.467590e-01, -6.078650e-01,  8.692555e-01, -2.193961e-01, -4.659817e-01},
  {-9.020270e-01, -2.284004e-01, -3.663067e-01, -9.135097e-01, -2.208875e-01, -3.708868e-01},
  { 8.415266e-01, -2.241966e-01, -4.914965e-01,  8.517325e-01, -2.151309e-01, -4.991484e-01},
  { 7.968320e-01, -1.645869e-01, -5.813518e-01,  8.104557e-01, -1.752006e-01, -5.773603e-01},
  { 6.109470e-01,  1.837515e-01, -7.700514e-01,  6.176290e-01,  1.802000e-01, -7.790651e-01},
  { 6.561658e-01,  3.379496e-01, -6.747122e-01,  5.781295e-01,  4.092821e-01, -7.210173e-01},
  { 6.306221e-01, -8.041099e-02, -7.719131e-01,  6.323438e-01, -8.284817e-02, -7.836803e-01},
  { 5.910935e-01,  4.001730e-02, -8.056098e-01,  6.000541e-01,  4.320056e-02, -8.117555e-01},
  { 5.862237e-01,  9.226844e-02, -8.048778e-01,  5.919315e-01,  9.094675e-02, -8.137718e-01},
  {-7.135221e-01, -2.646160e-01, -6.487407e-01, -7.196965e-01, -2.568924e-01, -6.609805e-01},
  { 5.568826e-01,  4.272967e-01, -7.122495e-01,  5.626041e-01,  4.331456e-01, -7.188486e-01},
  { 5.509622e-01,  4.269916e-01, -7.170209e-01,  5.619523e-01,  4.331542e-01, -7.193531e-01},
  { 5.613819e-01,  4.332787e-01, -7.050673e-01,  5.634028e-01,  4.326532e-01, -7.185196e-01},
  { 5.707579e-01, -1.391325e-01, -8.092450e-01,  5.807754e-01, -1.326951e-01, -8.160686e-01},
  { 5.276020e-01, -1.093392e-01, -8.424258e-01,  5.298967e-01, -1.092855e-01, -8.533121e-01},
  {-5.579301e-01, -2.080437e-01, -8.033878e-01, -5.630605e-01, -2.093229e-01, -8.128427e-01},
  { 4.817579e-01, -1.132993e-01, -8.689491e-01,  4.955885e-01, -1.191910e-01, -8.723878e-01},
  {-6.137945e-01, -2.199356e-01, -7.582115e-01, -6.194807e-01, -2.236114e-01, -7.662219e-01},
  {-2.657862e-01, -2.093970e-01, -9.410157e-01, -2.808399e-01, -1.897997e-01, -9.518225e-01},
  {-4.079954e-01, -1.909869e-01, -8.927842e-01, -4.168056e-01, -1.842833e-01, -9.017602e-01},
  { 1.688705e-01, -1.025661e-01, -9.802871e-01,  1.760949e-01, -1.133388e-01, -9.884406e-01},
  {-3.114147e-01, -1.671838e-01, -9.354520e-01, -3.160649e-01, -1.676234e-01, -9.449160e-01},
  { 8.182314e-02, -1.384407e-01, -9.869849e-01,  7.463885e-02, -1.320386e-01, -9.989309e-01},
  {-3.731586e-01, -1.103791e-01, -9.211782e-01, -3.543711e-01, -1.638420e-01, -9.318997e-01},
  {-2.690681e-02, -3.280854e-01, -9.442648e-01, -1.622339e-01, -1.381643e-01, -9.876511e-01},
  { 6.425275e-02, -3.259754e-01,  9.431923e-01,  7.398881e-02, -3.341445e-01,  9.506484e-01},
  { 5.310636e-01, -3.729966e-01,  7.608185e-01,  5.449871e-01, -3.690991e-01,  7.665654e-01},
  {-1.582472e-01, -3.497011e-01,  9.233996e-01, -1.547502e-01, -3.441028e-01,  9.372839e-01},
  { 6.423687e-01, -3.730686e-01,  6.694642e-01,  6.570267e-01, -3.787617e-01,  6.676265e-01},
  {-4.610965e-01, -2.507418e-01,  8.511866e-01, -4.437722e-01, -3.911115e-01,  8.194157e-01},
  {-6.097960e-01, -4.647339e-01,  6.420056e-01, -6.165912e-01, -4.739301e-01,  6.450215e-01},
  {-6.695438e-01, -4.150234e-01,  6.160086e-01, -6.804989e-01, -4.089614e-01,  6.249149e-01},
  {-6.652930e-01, -3.801521e-01,  6.425492e-01, -6.739660e-01, -3.898368e-01,  6.439287e-01},
  {-7.017257e-01, -3.588468e-01,  6.154755e-01, -7.200874e-01, -3.580611e-01,  6.116478e-01},
  { 8.545836e-01, -4.272728e-01,  2.951694e-01,  8.650193e-01, -4.272243e-01,  3.001582e-01},
  { 8.658826e-01, -4.393814e-01,  2.391469e-01,  8.763462e-01, -4.386695e-01,  2.458874e-01},
  {-7.144384e-01, -5.051333e-01,  4.841675e-01, -7.079470e-01, -5.156050e-01,  5.037936e-01},
  {-8.745172e-01, -3.122974e-01,  3.710659e-01, -8.817977e-01, -3.159994e-01,  3.787114e-01},
  { 9.210877e-01, -3.825178e-01,  7.264765e-02,  9.343498e-01, -3.781506e-01,  6.977814e-02},
  { 9.387500e-01, -3.317985e-01, -9.304985e-02,  9.590085e-01, -3.072797e-01, -8.221850e-02},
  {-9.820310e-01, -1.594574e-02,  1.880442e-01, -9.903235e-01, -2.481753e-02,  1.987225e-01},
  {-9.734618e-01, -7.357483e-02,  2.167002e-01, -9.835266e-01, -6.342354e-02,  2.224851e-01},
  { 9.570777e-01, -2.660729e-01, -1.149228e-01,  9.661599e-01, -2.704541e-01, -1.194502e-01},
  {-9.850637e-01,  1.520149e-01,  8.087687e-02, -9.940216e-01,  1.570111e-01,  9.010162e-02},
  {-9.660041e-01,  2.585163e-01,  2.305647e-03, -9.766641e-01,  2.585272e-01,  1.192525e-02},
  { 9.433033e-01, -2.111832e-01, -2.560869e-01,  9.514688e-01, -2.064604e-01, -2.701129e-01},
  { 8.901413e-01, -9.264281e-02, -4.461678e-01,  9.022470e-01, -8.928499e-02, -4.459365e-01},
  { 7.425016e-01,  1.393927e-01, -6.551801e-01,  7.486385e-01,  1.361722e-01, -6.647397e-01},
  {-9.673617e-01,  2.502302e-01, -3.995230e-02, -9.773912e-01,  2.508735e-01, -5.119038e-02},
  {-9.823719e-01,  2.635897e-02, -1.850693e-01, -9.940403e-01,  3.482831e-02, -1.844708e-01},
  { 9.113744e-01, -2.180189e-01, -3.490909e-01,  9.239156e-01, -2.107037e-01, -3.505188e-01},
  {-9.434964e-01, -1.487167e-01, -2.961383e-01, -9.546362e-01, -1.497824e-01, -2.954140e-01},
  { 8.904077e-01, -2.062751e-01, -4.057397e-01,  8.975838e-01, -2.024125e-01, -4.174348e-01},
  { 8.336659e-01, -1.750050e-01, -5.238076e-01,  8.425973e-01, -1.744823e-01, -5.295893e-01},
  { 7.313845e-01, -2.977571e-01, -6.135287e-01,  8.686380e-01, -2.036100e-01, -4.765317e-01},
  { 7.389522e-01, -2.634830e-01, -6.201017e-01,  8.656141e-01, -1.865094e-01, -4.866267e-01},
  {-8.745496e-01, -2.419679e-01, -4.202553e-01, -8.810810e-01, -2.432133e-01, -4.305719e-01},
  {-8.485023e-01, -2.582136e-01, -4.619194e-01, -8.608484e-01, -2.574655e-01, -4.620611e-01},
  { 6.776990e-01,  2.839221e-01, -6.783156e-01,  5.752599e-01,  4.018465e-01, -7.269642e-01},
  { 5.998108e-01, -7.918251e-02, -7.962142e-01,  6.062159e-01, -6.850085e-02, -8.058860e-01},
  { 5.808063e-01, -3.720952e-02, -8.131909e-01,  5.943829e-01, -5.025086e-02, -8.155127e-01},
  { 5.617015e-01,  1.758048e-01, -8.084455e-01,  5.638991e-01,  1.766566e-01, -8.195666e-01},
  { 5.811400e-01, -2.822806e-03, -8.137987e-01,  5.900040e-01, -1.429140e-02, -8.201028e-01},
  { 5.515461e-01, -9.045067e-02, -8.292258e-01,  5.671863e-01, -9.315176e-02, -8.309625e-01},
  { 4.029267e-01, -1.188513e-01, -9.074824e-01,  4.111185e-01, -1.126701e-01, -9.160572e-01},
  { 3.636244e-01, -9.743782e-02, -9.264357e-01,  3.624646e-01, -1.117879e-01, -9.364805e-01},
  { 4.997576e-01, -9.000606e-02, -8.614762e-01,  5.064666e-01, -8.154110e-02, -8.704700e-01},
  { 4.426899e-01, -7.088175e-02, -8.938688e-01,  4.531662e-01, -1.049270e-01, -8.969421e-01},
  {-4.734682e-01, -1.747839e-01, -8.632951e-01, -4.848369e-01, -1.780618e-01, -8.683805e-01},
  { 1.195228e-01, -1.015355e-01, -9.876258e-01,  1.256682e-01, -1.058636e-01, -9.969301e-01},
  {-2.880809e-01, -1.292056e-01, -9.488494e-01, -2.960190e-01, -1.445074e-01, -9.551710e-01},
  {-8.140949e-02, -1.279171e-01, -9.884380e-01, -7.664654e-02, -1.284596e-01, -9.992442e-01},
  {-2.085002e-01, -1.720324e-01, -9.627734e-01, -2.147619e-01, -1.731434e-01, -9.719883e-01},
  {-8.453986e-02, -2.343181e-01, -9.684772e-01, -1.594125e-01, -1.323231e-01, -9.901726e-01},
  { 5.025128e-01, -3.306423e-01,  7.988470e-01,  5.224276e-01, -3.528079e-01,  7.895969e-01},
  { 1.131647e-01, -3.490269e-01,  9.302548e-01,  1.170187e-01, -3.471149e-01,  9.416357e-01},
  { 3.825157e-01, -3.664152e-01,  8.481873e-01,  3.956209e-01, -3.668317e-01,  8.542736e-01},
  { 2.388868e-01, -3.596568e-01,  9.019868e-01,  2.396871e-01, -3.649737e-01,  9.111565e-01},
  { 5.745738e-01, -3.618955e-01,  7.340958e-01,  5.851980e-01, -3.606617e-01,  7.404963e-01},
  {-4.713781e-01, -4.403706e-01,  7.641181e-01, -4.774247e-01, -4.497788e-01,  7.685143e-01},
  {-5.134009e-01, -3.744020e-01,  7.721674e-01, -5.215464e-01, -3.803875e-01,  7.772670e-01},
  {-4.833746e-01, -3.232118e-01,  8.135619e-01, -4.745526e-01, -3.920994e-01,  8.011915e-01},
  { 6.685017e-01, -3.468586e-01,  6.578712e-01,  6.678523e-01, -3.682788e-01,  6.627324e-01},
  {-2.003623e-01, -3.267017e-01,  9.236454e-01, -2.134572e-01, -3.289652e-01,  9.311673e-01},
  {-4.336488e-01, -3.338128e-01,  8.369694e-01, -4.407429e-01, -3.333252e-01,  8.458670e-01},
  {-6.326142e-01, -4.702736e-01,  6.153389e-01, -6.428227e-01, -4.804645e-01,  6.138237e-01},
  {-6.329478e-01, -5.000287e-01,  5.910571e-01, -6.365709e-01, -5.059810e-01,  5.996727e-01},
  { 7.571632e-01, -3.928702e-01,  5.218781e-01,  7.697096e-01, -4.035131e-01,  5.153602e-01},
  {-6.491608e-01, -5.118541e-01,  5.626683e-01, -6.579360e-01, -5.165268e-01,  5.667154e-01},
  {-7.276823e-01, -3.956951e-01,  5.602713e-01, -7.360927e-01, -3.949178e-01,  5.683782e-01},
  { 8.581241e-01, -4.016563e-01,  3.198361e-01,  8.641680e-01, -4.076438e-01,  3.285029e-01},
  {-7.478744e-01, -3.641843e-01,  5.550259e-01, -7.509859e-01, -3.746554e-01,  5.625830e-01},
  {-7.468405e-01, -3.304120e-01,  5.771110e-01, -7.475513e-01, -3.406281e-01,  5.882058e-01},
  { 8.309809e-01, -4.115106e-01,  3.743392e-01,  8.494794e-01, -4.041888e-01,  3.686323e-01},
  {-6.574356e-01, -5.298569e-01,  5.357520e-01, -6.582555e-01, -5.357103e-01,  5.482337e-01},
  {-7.248678e-01, -4.242529e-01,  5.427485e-01, -7.321980e-01, -4.275332e-01,  5.494974e-01},
  { 8.803397e-01, -3.936293e-01,  2.646848e-01,  8.841628e-01, -4.069383e-01,  2.714834e-01},
  {-7.537577e-01, -3.967476e-01,  5.238709e-01, -7.709199e-01, -3.953528e-01,  5.198311e-01},
  {-7.750536e-01, -3.639251e-01,  5.165757e-01, -7.800776e-01, -3.757993e-01,  5.206724e-01},
  { 8.135676e-01, -4.029295e-01,  4.192321e-01,  8.247417e-01, -4.043936e-01,  4.208801e-01},
  {-6.736612e-01, -5.332868e-01,  5.116501e-01, -6.891600e-01, -5.290701e-01,  5.157411e-01},
  { 9.023319e-01, -3.967192e-01,  1.685554e-01,  9.133968e-01, -3.996298e-01,  1.639445e-01},
  { 8.902205e-01, -3.997801e-01,  2.183654e-01,  9.226319e-01, -3.920004e-01,  1.263403e-01},
  { 8.598011e-01, -3.905555e-01,  3.289508e-01,  9.287378e-01, -3.803946e-01,  1.263584e-01},
  {-8.887597e-01, -2.968275e-01,  3.492844e-01, -8.995911e-01, -2.993940e-01,  3.492052e-01},
  { 9.470739e-01, -3.204640e-01,  1.880749e-02,  9.532728e-01, -3.347751e-01,  8.611212e-03},
  {-9.115883e-01, -2.574717e-01,  3.204922e-01, -9.213619e-01, -2.578077e-01,  3.247660e-01},
  {-9.635541e-01, -1.081424e-01,  2.446808e-01, -9.747295e-01, -1.044596e-01,  2.446159e-01},
  { 9.416614e-01, -3.325817e-01, -5.160722e-02,  9.649101e-01, -2.990618e-01, -5.314467e-02},
  {-9.503825e-01, -1.574987e-01,  2.682670e-01, -9.605219e-01, -1.489601e-01,  2.757799e-01},
  { 9.594955e-01, -2.500526e-01, -1.297768e-01,  9.719520e-01, -2.432361e-01, -1.304783e-01},
  {-9.827582e-01,  4.106487e-02,  1.802771e-01, -9.949803e-01,  4.615262e-02,  1.695057e-01},
  {-9.708229e-01, -3.284752e-02,  2.375367e-01, -9.805682e-01, -3.135953e-02,  2.415570e-01},
  { 8.870569e-01,  2.703608e-02, -4.608679e-01,  9.005874e-01,  2.887039e-02, -4.571554e-01},
  {-9.758732e-01,  2.032546e-01,  7.974387e-02, -9.863815e-01,  2.055322e-01,  7.522289e-02},
  { 9.011891e-01, -5.183781e-02, -4.303149e-01,  9.099246e-01, -4.747975e-02, -4.366511e-01},
  { 7.783184e-01,  1.316011e-01, -6.139231e-01,  7.894685e-01,  1.425606e-01, -6.142458e-01},
  { 9.097359e-01, -1.011277e-01, -4.026833e-01,  9.207051e-01, -1.055381e-01, -4.025475e-01},
  { 9.234729e-01, -1.051407e-01, -3.689759e-01,  9.319460e-01, -1.088291e-01, -3.748517e-01},
  { 9.309065e-01, -1.976826e-01, -3.071393e-01,  9.400099e-01, -1.990300e-01, -3.124870e-01},
  {-9.590018e-01,  2.746981e-01, -6.968857e-02, -9.717225e-01,  2.698012e-01, -6.176091e-02},
  { 8.865874e-01, -1.410693e-01, -4.405249e-01,  8.915024e-01, -1.482881e-01, -4.517899e-01},
  { 7.138879e-01,  1.633569e-01, -6.809395e-01,  7.193609e-01,  1.688180e-01, -6.891311e-01},
  {-9.696279e-01,  2.306350e-01, -8.142028e-02, -9.780782e-01,  2.366326e-01, -9.066090e-02},
  {-9.752388e-01,  1.888409e-01, -1.151017e-01, -9.873496e-01,  1.810166e-01, -1.149977e-01},
  { 8.813670e-01, -1.653459e-01, -4.425528e-01,  8.883876e-01, -1.792234e-01, -4.466831e-01},
  { 6.808899e-01,  1.723949e-01, -7.118068e-01,  6.929063e-01,  1.736356e-01, -7.145715e-01},
  { 6.436609e-01,  1.924773e-01, -7.407113e-01,  6.508465e-01,  1.971697e-01, -7.472641e-01},
  {-8.184398e-01, -2.499797e-01, -5.173649e-01, -8.268485e-01, -2.455711e-01, -5.261808e-01},
  {-7.966700e-01, -2.354536e-01, -5.566671e-01, -8.010761e-01, -2.498602e-01, -5.627588e-01},
  {-6.901349e-01, -2.373821e-01, -6.836400e-01, -6.999581e-01, -2.354527e-01, -6.895458e-01},
  { 5.133045e-01,  4.195589e-01, -7.486579e-01,  5.239941e-01,  4.184579e-01, -7.557805e-01},
  {-6.579589e-01, -2.204417e-01, -7.200664e-01, -6.613864e-01, -2.235590e-01, -7.303718e-01},
  { 5.149367e-01, -6.417096e-02, -8.548229e-01,  5.217425e-01, -6.112820e-02, -8.630899e-01},
  { 3.304167e-01, -1.040862e-01, -9.380783e-01,  3.385260e-01, -1.024294e-01, -9.464571e-01},
  {-5.177863e-01, -1.881534e-01, -8.345631e-01, -5.224200e-01, -1.809352e-01, -8.456930e-01},
  { 2.876963e-01, -1.130052e-01, -9.510314e-01,  2.987365e-01, -9.698605e-02, -9.603241e-01},
  { 2.293046e-01, -7.862482e-02, -9.701740e-01,  2.186957e-01, -8.382718e-02, -9.841242e-01},
  { 4.810345e-01,  4.651022e-01, -7.431594e-01,  4.829987e-01,  4.718561e-01, -7.516283e-01},
  { 6.160791e-02, -9.219544e-02, -9.938332e-01,  6.414022e-02, -9.210330e-02, -1.004127e+00},
  {-2.503805e-02, -1.139382e-01, -9.931723e-01, -1.325664e-02, -1.127671e-01, -1.003979e+00},
  { 4.726120e-01, -3.346053e-01,  8.152773e-01,  4.770838e-01, -3.354093e-01,  8.250808e-01},
  { 1.235101e-01, -3.005463e-01,  9.457363e-01,  1.200330e-01, -3.167535e-01,  9.519032e-01},
  { 1.638575e-01, -3.365656e-01,  9.272941e-01,  1.632894e-01, -3.424486e-01,  9.364434e-01},
  { 3.416566e-01, -3.384838e-01,  8.767551e-01,  3.473123e-01, -3.486451e-01,  8.824312e-01},
  {-5.271253e-01, -4.124120e-01,  7.430043e-01, -5.125698e-01, -4.305750e-01,  7.567869e-01},
  { 6.185190e-01, -3.541234e-01,  7.014491e-01,  6.200262e-01, -3.461111e-01,  7.187794e-01},
  { 3.297494e-01, -3.347791e-01,  8.827164e-01,  3.173730e-01, -3.473422e-01,  8.941428e-01},
  { 2.873583e-01, -3.473853e-01,  8.926077e-01,  3.025406e-01, -3.480069e-01,  8.990126e-01},
  {-5.572494e-01, -4.311897e-01,  7.096116e-01, -5.580753e-01, -4.444652e-01,  7.154375e-01},
  {-1.456116e-01, -3.125230e-01,  9.386835e-01, -1.572133e-01, -3.152128e-01,  9.469850e-01},
  {-5.818023e-01, -4.271588e-01,  6.921281e-01, -5.962393e-01, -4.353544e-01,  6.897919e-01},
  {-2.467214e-01, -3.148545e-01,  9.165125e-01, -2.412698e-01, -3.174274e-01,  9.283766e-01},
  {-6.250110e-01, -4.206530e-01,  6.575807e-01, -6.209420e-01, -4.271410e-01,  6.729257e-01},
  { 6.926855e-01, -3.702993e-01,  6.189225e-01,  6.996418e-01, -3.644195e-01,  6.313245e-01},
  {-5.306793e-01, -3.245986e-01,  7.829528e-01, -5.286210e-01, -3.354661e-01,  7.930145e-01},
  {-4.480814e-01, -3.494354e-01,  8.228717e-01, -4.601482e-01, -3.370488e-01,  8.339739e-01},
  {-2.904632e-01, -3.025458e-01,  9.077980e-01, -2.967646e-01, -3.072065e-01,  9.156465e-01},
  {-7.086440e-01, -4.143791e-01,  5.710637e-01, -7.112280e-01, -4.237184e-01,  5.791924e-01},
  { 7.885975e-01, -3.914398e-01,  4.742244e-01,  7.888744e-01, -3.922878e-01,  4.946308e-01},
  {-3.585938e-01, -2.995268e-01,  8.841347e-01, -3.678348e-01, -3.013123e-01,  8.914937e-01},
  {-6.886050e-01, -4.680411e-01,  5.538598e-01, -6.883174e-01, -4.802893e-01,  5.624833e-01},
  { 8.885825e-01, -4.062620e-01,  2.130077e-01,  8.992237e-01, -4.062895e-01,  2.172568e-01},
  {-7.991343e-01, -3.397266e-01,  4.959540e-01, -8.017797e-01, -3.395489e-01,  5.125444e-01},
  {-8.688570e-01, -2.843025e-01,  4.052894e-01, -8.689393e-01, -2.946826e-01,  4.230273e-01},
  {-8.895632e-01, -2.702378e-01,  3.683054e-01, -9.003736e-01, -2.737464e-01,  3.677440e-01},
  {-9.221542e-01, -1.469986e-01,  3.578031e-01, -9.282474e-01, -1.509702e-01,  3.693388e-01},
  {-9.347159e-01, -1.019160e-01,  3.404693e-01, -9.412262e-01, -1.095012e-01,  3.506415e-01},
  { 9.369082e-01, -3.437056e-01,  6.379264e-02,  9.456159e-01, -3.500116e-01,  6.464680e-02},
  {-9.287292e-01, -1.757099e-01,  3.264782e-01, -9.415148e-01, -1.626082e-01,  3.285645e-01},
  {-9.452285e-01, -6.363182e-02,  3.201471e-01, -9.548067e-01, -6.214714e-02,  3.245442e-01},
  { 9.446355e-01, -3.275105e-01, -2.001872e-02,  9.632115e-01, -3.046098e-01, -1.773411e-02},
  { 8.572351e-01,  1.210926e-01, -5.004843e-01,  8.696694e-01,  1.104076e-01, -5.023624e-01},
  { 9.686065e-01, -2.169532e-01, -1.213786e-01,  9.760296e-01, -2.268436e-01, -1.295670e-01},
  { 8.863128e-01,  5.871385e-02, -4.593499e-01,  9.003940e-01,  5.776487e-02, -4.547926e-01},
  {-9.742866e-01,  7.548159e-03,  2.251857e-01, -9.860252e-01,  7.607492e-03,  2.203274e-01},
  {-9.858140e-01,  8.730977e-02,  1.433453e-01, -9.934477e-01,  8.846298e-02,  1.615074e-01},
  {-9.578620e-01, -7.437064e-02,  2.774338e-01, -9.688017e-01, -8.198120e-02,  2.748621e-01},
  { 9.011427e-01, -1.497269e-03, -4.335199e-01,  9.099885e-01,  8.058758e-03, -4.390192e-01},
  {-9.538075e-01,  2.998258e-01,  1.885720e-02, -9.625331e-01,  3.068648e-01,  1.470515e-02},
  {-9.636897e-01,  2.613135e-01,  5.493049e-02, -9.754152e-01,  2.580436e-01,  5.319599e-02},
  {-9.796842e-01,  1.264474e-01,  1.556595e-01, -9.927727e-01,  1.219386e-01,  1.427668e-01},
  { 9.545726e-01, -1.921061e-01, -2.277859e-01,  9.686780e-01, -1.919922e-01, -2.137330e-01},
  {-9.784772e-01,  1.652687e-01,  1.235661e-01, -9.903176e-01,  1.551175e-01,  1.267248e-01},
  {-9.511628e-01,  3.074467e-01, -2.767273e-02, -9.617494e-01,  3.090759e-01, -1.903783e-02},
  {-9.697965e-01,  1.146208e-02, -2.436459e-01, -9.825823e-01, -4.551759e-03, -2.352880e-01},
  { 9.321784e-01, -1.373646e-01, -3.349243e-01,  9.368737e-01, -1.412310e-01, -3.510012e-01},
  { 7.587496e-01,  1.870888e-01, -6.239365e-01,  7.747046e-01,  1.775660e-01, -6.238471e-01},
  { 9.218606e-01, -1.806572e-01, -3.428351e-01,  9.329178e-01, -1.786532e-01, -3.444231e-01},
  {-9.745259e-01,  7.681858e-02, -2.107092e-01, -9.879283e-01,  6.892248e-02, -2.002425e-01},
  { 9.063719e-01, -1.624711e-01, -3.899911e-01,  9.170509e-01, -1.746472e-01, -3.865177e-01},
  { 7.246787e-01,  1.962504e-01, -6.605502e-01,  7.281656e-01,  1.894503e-01, -6.743627e-01},
  {-9.760962e-01,  1.497555e-01, -1.575103e-01, -9.846134e-01,  1.607149e-01, -1.598680e-01},
  { 7.074455e-01,  2.093659e-01, -6.750458e-01,  7.037303e-01,  2.094988e-01, -6.940860e-01},
  { 7.052292e-01,  2.379136e-01, -6.678689e-01,  7.017748e-01,  2.668974e-01, -6.761361e-01},
  { 6.668338e-01,  2.221000e-01, -7.113398e-01,  6.774508e-01,  2.189765e-01, -7.169317e-01},
  {-8.945739e-01, -1.902225e-01, -4.044167e-01, -9.090066e-01, -1.926744e-01, -3.996583e-01},
  {-9.247605e-01, -1.636988e-01, -3.435416e-01, -9.311005e-01, -1.622825e-01, -3.571619e-01},
  { 6.581922e-01,  2.662703e-01, -7.041897e-01,  6.612186e-01,  2.633353e-01, -7.171652e-01},
  { 6.308451e-01,  2.546049e-01, -7.329467e-01,  6.364118e-01,  2.688991e-01, -7.372615e-01},
  { 5.815532e-01,  2.213570e-01, -7.828135e-01,  5.935089e-01,  2.245874e-01, -7.862492e-01},
  { 5.988649e-01,  3.816623e-01, -7.040559e-01,  6.103024e-01,  3.958127e-01, -7.012455e-01},
  { 5.519006e-01,  2.253539e-01, -8.028831e-01,  5.539186e-01,  2.313004e-01, -8.127447e-01},
  {-7.516873e-01, -2.423879e-01, -6.133631e-01, -7.680556e-01, -2.368143e-01, -6.122589e-01},
  { 5.596986e-01,  4.798297e-02, -8.273059e-01,  5.623832e-01,  4.932165e-02, -8.379561e-01},
  { 5.453991e-01,  1.117881e-01, -8.306885e-01,  5.549459e-01,  1.122462e-01, -8.368478e-01},
  { 5.285885e-01,  1.827650e-01, -8.289699e-01,  5.448061e-01,  1.804242e-01, -8.315723e-01},
  { 5.507187e-01, -3.525265e-03, -8.346835e-01,  5.527521e-01,  1.643318e-03, -8.457775e-01},
  { 5.011600e-01, -2.981070e-02, -8.648410e-01,  5.033744e-01, -3.483896e-02, -8.753722e-01},
  { 3.992909e-01, -4.973687e-02, -9.154742e-01,  3.942428e-01, -7.678446e-02, -9.271196e-01},
  {-4.349852e-01, -1.551022e-01, -8.869787e-01, -4.279940e-01, -1.555515e-01, -9.019334e-01},
  { 5.185689e-01,  4.769731e-01, -7.096358e-01,  5.173144e-01,  4.869456e-01, -7.188911e-01},
  {-2.555594e-01, -1.577342e-01, -9.538392e-01, -2.608798e-01, -1.602967e-01, -9.628648e-01},
  {-3.140025e-01, -9.813017e-02, -9.443373e-01, -3.771360e-01, -1.071580e-01, -9.312068e-01},
  {-2.074330e-01, -1.268926e-01, -9.699845e-01, -2.115281e-01, -1.272741e-01, -9.797552e-01},
  { 6.823684e-02, -2.774405e-01,  9.583166e-01,  6.770791e-02, -2.842593e-01,  9.671981e-01},
  { 4.260096e-01, -3.457653e-01,  8.360396e-01,  4.444284e-01, -3.455803e-01,  8.392614e-01},
  {-9.952872e-02, -2.828612e-01,  9.539830e-01, -8.753327e-02, -2.923941e-01,  9.631723e-01},
  { 3.778704e-01, -3.481781e-01,  8.578962e-01,  3.801172e-01, -3.444377e-01,  8.704817e-01},
  { 2.107050e-01, -3.345192e-01,  9.185317e-01,  2.127722e-01, -3.355682e-01,  9.289692e-01},
  {-5.747506e-01, -4.180119e-01,  7.035110e-01, -5.838205e-01, -4.156004e-01,  7.122346e-01},
  {-6.065575e-01, -3.855611e-01,  6.952918e-01, -6.168421e-01, -3.917451e-01,  6.977746e-01},
  {-5.492827e-01, -3.556721e-01,  7.561653e-01, -5.600930e-01, -3.543969e-01,  7.625927e-01},
  {-6.492861e-01, -3.644632e-01,  6.675285e-01, -6.473424e-01, -3.838739e-01,  6.741188e-01},
  { 7.165500e-01, -3.496667e-01,  6.035637e-01,  7.329195e-01, -3.698487e-01,  5.889927e-01},
  {-4.902362e-01, -3.379160e-01,  8.034186e-01, -4.950257e-01, -3.316124e-01,  8.159859e-01},
  {-6.924263e-01, -3.166055e-01,  6.483108e-01, -7.046089e-01, -3.233077e-01,  6.479549e-01},
  {-4.089909e-01, -2.967229e-01,  8.629496e-01, -4.197609e-01, -2.940777e-01,  8.707300e-01},
  {-6.671754e-01, -4.615636e-01,  5.846674e-01, -6.809497e-01, -4.618164e-01,  5.864124e-01},
  {-7.243363e-01, -2.969760e-01,  6.222075e-01, -7.317445e-01, -3.022026e-01,  6.277505e-01},
  {-7.604691e-01, -2.800578e-01,  5.858791e-01, -7.675232e-01, -2.886421e-01,  5.902886e-01},
  {-7.794181e-01, -2.960837e-01,  5.521249e-01, -7.859816e-01, -2.996867e-01,  5.597029e-01},
  { 8.541866e-01, -3.703110e-01,  3.650139e-01,  8.632605e-01, -3.770704e-01,  3.683100e-01},
  {-7.777123e-01, -3.248385e-01,  5.381855e-01, -7.946036e-01, -3.142226e-01,  5.391804e-01},
  {-8.104972e-01, -2.963695e-01,  5.052322e-01, -8.200880e-01, -2.893382e-01,  5.143785e-01},
  { 9.075583e-01, -3.618166e-01,  2.131354e-01,  9.169582e-01, -3.680640e-01,  2.111690e-01},
  {-8.383601e-01, -3.006980e-01,  4.546791e-01, -8.482935e-01, -2.931570e-01,  4.640073e-01},
  {-9.088225e-01, -1.982188e-01,  3.670844e-01, -9.127319e-01, -2.086617e-01,  3.797720e-01},
  { 9.140396e-01, -3.439721e-01,  2.149764e-01,  9.388160e-01, -3.498237e-01,  1.308607e-01},
  {-9.162859e-01, -1.361740e-01,  3.766654e-01, -9.160200e-01, -1.650873e-01,  3.930647e-01},
  {-8.959357e-01, -2.422224e-01,  3.723273e-01, -9.102738e-01, -2.405610e-01,  3.665755e-01},
  {-9.125408e-01, -1.163493e-01,  3.920870e-01, -9.243780e-01, -1.089627e-01,  3.930638e-01},
  {-9.394038e-01, -1.464378e-01,  3.099622e-01, -9.507738e-01, -1.480736e-01,  3.081390e-01},
  {-9.188110e-01, -2.165121e-01,  3.300135e-01, -9.257308e-01, -2.274838e-01,  3.348421e-01},
  { 8.821330e-01,  8.726411e-02, -4.628460e-01,  8.919951e-01,  9.619032e-02, -4.647309e-01},
  { 9.654498e-01, -2.539362e-01, -5.850759e-02,  9.740493e-01, -2.630415e-01, -5.399962e-02},
  {-9.589314e-01, -1.885906e-02,  2.830104e-01, -9.664484e-01, -2.619735e-02,  2.934937e-01},
  {-9.510552e-01, -1.092884e-01,  2.890504e-01, -9.627302e-01, -1.095290e-01,  2.863572e-01},
  { 9.242618e-01,  1.378335e-02, -3.815102e-01,  9.233763e-01,  1.537902e-02, -4.099047e-01},
  { 8.345773e-01,  1.283537e-01, -5.357295e-01,  8.405634e-01,  1.364419e-01, -5.438009e-01},
  {-9.690323e-01,  2.934766e-02,  2.451837e-01, -9.787477e-01,  2.816138e-02,  2.492143e-01},
  {-9.765199e-01,  8.968946e-02,  1.958689e-01, -9.849108e-01,  8.823369e-02,  2.073985e-01},
  { 8.046819e-01,  1.558547e-01, -5.728842e-01,  8.177883e-01,  1.534582e-01, -5.731974e-01},
  { 9.458964e-01, -1.601830e-01, -2.821726e-01,  9.582776e-01, -1.614790e-01, -2.766025e-01},
  { 7.390221e-01,  2.308610e-01, -6.328899e-01,  7.448531e-01,  2.413169e-01, -6.386254e-01},
  {-9.596351e-01, -8.936065e-02, -2.666743e-01, -9.606566e-01, -9.615681e-02, -2.978950e-01},
  {-9.402102e-01, -1.110307e-01, -3.219893e-01, -9.523873e-01, -1.109994e-01, -3.185689e-01},
  {-9.596850e-01,  2.488796e-01, -1.306286e-01, -9.713243e-01,  2.500824e-01, -1.218185e-01},
  {-9.345397e-01, -1.252150e-01, -3.331015e-01, -9.411500e-01, -1.244185e-01, -3.458402e-01},
  { 6.129026e-01,  2.335315e-01, -7.548599e-01,  6.168659e-01,  2.414151e-01, -7.629390e-01},
  {-8.624477e-01, -2.061821e-01, -4.622477e-01, -8.662955e-01, -2.126383e-01, -4.745173e-01},
  { 6.244778e-01,  3.003876e-01, -7.209679e-01,  6.325861e-01,  3.024629e-01, -7.274837e-01},
  { 5.162412e-01,  2.468369e-01, -8.201016e-01,  5.329702e-01,  2.459691e-01, -8.223876e-01},
  {-7.268471e-01, -2.211965e-01, -6.502042e-01, -7.378275e-01, -2.321891e-01, -6.500390e-01},
  { 5.361820e-01, -2.994115e-02, -8.435712e-01,  5.403747e-01, -2.857573e-02, -8.532615e-01},
  { 4.710840e-01,  1.052652e-03, -8.820877e-01,  4.910218e-01, -1.062324e-02, -8.829840e-01},
  { 2.970965e-01, -7.419959e-02, -9.519601e-01,  2.995704e-01, -8.025450e-02, -9.616076e-01},
  {-5.656542e-01, -1.698095e-01, -8.069697e-01, -5.754206e-01, -1.731303e-01, -8.122641e-01},
  { 4.631774e-01, -5.298809e-02, -8.846801e-01,  4.570754e-01, -4.090100e-02, -9.001580e-01},
  { 3.895763e-01, -2.384408e-02, -9.206855e-01,  3.664058e-01, -5.689391e-02, -9.398848e-01},
  { 4.145101e-01, -3.175052e-02, -9.094907e-01,  4.093847e-01, -3.036594e-02, -9.232317e-01},
  { 1.961979e-01, -2.901844e-02, -9.801348e-01,  2.114478e-01, -5.983412e-02, -9.861951e-01},
  {-3.968531e-01, -1.351462e-01, -9.078783e-01, -4.108563e-01, -1.267119e-01, -9.143308e-01},
  { 1.445461e-01, -5.277972e-02, -9.880895e-01,  1.551162e-01, -5.319406e-02, -9.969853e-01},
  {-9.499766e-03, -8.373503e-02, -9.964428e-01, -2.089523e-02, -8.450610e-02, -1.006623e+00},
  { 3.714843e-01, -2.678836e-01,  8.889531e-01,  3.913871e-01, -2.558752e-01,  8.959374e-01},
  { 4.813725e-01, -2.964998e-01,  8.248444e-01,  4.817273e-01, -3.007672e-01,  8.356704e-01},
  { 4.001130e-01, -1.312911e-01,  9.070128e-01,  3.530051e-01, -2.553242e-01,  9.116261e-01},
  { 1.492177e-01, -2.711155e-01,  9.509104e-01,  1.569203e-01, -2.684664e-01,  9.613342e-01},
  { 3.038884e-01, -2.744702e-01,  9.123147e-01,  3.136550e-01, -2.606122e-01,  9.244276e-01},
  { 8.423984e-03, -2.923214e-01,  9.562830e-01,  5.840698e-03, -2.792642e-01,  9.709975e-01},
  { 1.331057e-01, -3.833613e-01,  9.139568e-01,  2.708237e-01, -2.652007e-01,  9.365824e-01},
  { 1.925319e-01, -2.931296e-01,  9.364862e-01,  2.013225e-01, -2.960327e-01,  9.448258e-01},
  { 3.767823e-01, -3.117791e-01,  8.722551e-01,  3.764157e-01, -3.212940e-01,  8.808781e-01},
  { 3.207822e-01, -3.005292e-01,  8.982099e-01,  3.180895e-01, -3.080584e-01,  9.081756e-01},
  { 2.567802e-01, -2.998945e-01,  9.187639e-01,  2.657271e-01, -3.021398e-01,  9.268031e-01},
  {-5.900640e-02, -2.729822e-01,  9.602078e-01, -5.238006e-02, -2.826142e-01,  9.686296e-01},
  { 6.030231e-01, -3.115763e-01,  7.343591e-01,  6.085826e-01, -3.217724e-01,  7.395669e-01},
  {-5.673728e-01, -3.843110e-01,  7.282809e-01, -5.699505e-01, -3.939953e-01,  7.353725e-01},
  {-2.227883e-01, -2.847238e-01,  9.323614e-01, -2.092001e-01, -2.851335e-01,  9.464615e-01},
  {-5.756847e-01, -3.404765e-01,  7.434130e-01, -5.763153e-01, -3.527435e-01,  7.511867e-01},
  {-6.054779e-01, -3.041896e-01,  7.354355e-01, -6.045334e-01, -3.135751e-01,  7.463638e-01},
  {-2.667685e-01, -2.686929e-01,  9.255478e-01, -2.877988e-01, -2.803134e-01,  9.270654e-01},
  { 7.460052e-01, -3.523909e-01,  5.650635e-01,  7.506703e-01, -3.488141e-01,  5.793918e-01},
  {-5.446316e-01, -2.795829e-01,  7.907022e-01, -5.486847e-01, -2.850159e-01,  7.991001e-01},
  {-5.754074e-01, -2.919935e-01,  7.639673e-01, -5.907974e-01, -2.788303e-01,  7.707538e-01},
  { 7.571880e-01, -3.591562e-01,  5.455944e-01,  7.713686e-01, -3.508057e-01,  5.502710e-01},
  {-3.601175e-01, -2.566089e-01,  8.969210e-01, -3.604117e-01, -2.720731e-01,  9.038432e-01},
  {-5.285893e-01, -2.461716e-01,  8.123994e-01, -5.244674e-01, -2.544900e-01,  8.252390e-01},
  { 8.832512e-01, -3.673091e-01,  2.914641e-01,  8.927749e-01, -3.722324e-01,  2.920119e-01},
  { 8.142632e-01, -3.673786e-01,  4.494533e-01,  8.267609e-01, -3.689557e-01,  4.485660e-01},
  {-5.617386e-01, -2.112524e-01,  7.998888e-01, -5.725938e-01, -2.057007e-01,  8.066437e-01},
  {-7.989579e-01, -2.645569e-01,  5.400702e-01, -8.106205e-01, -2.655129e-01,  5.415199e-01},
  { 9.061092e-01, -3.367009e-01,  2.561228e-01,  9.158189e-01, -3.436223e-01,  2.531309e-01},
  {-5.031428e-01, -2.225536e-01,  8.350552e-01, -5.082644e-01, -2.119277e-01,  8.471158e-01},
  {-8.302948e-01, -2.604455e-01,  4.927258e-01, -8.365324e-01, -2.609593e-01,  5.029513e-01},
  { 9.218180e-01, -3.511831e-01,  1.640795e-01,  9.298764e-01, -3.553113e-01,  1.730899e-01},
  {-8.872596e-01, -2.181737e-01,  4.064119e-01, -8.954065e-01, -2.167910e-01,  4.148432e-01},
  { 9.469208e-01, -3.120156e-01,  7.737862e-02,  9.581689e-01, -3.113076e-01,  7.666484e-02},
  {-9.302573e-01, -5.830183e-02,  3.622461e-01, -9.392648e-01, -6.287247e-02,  3.669822e-01},
  { 9.050971e-01,  7.097360e-02, -4.192398e-01,  9.189291e-01,  5.888060e-02, -4.159147e-01},
  { 9.691867e-01, -1.662494e-01, -1.817645e-01,  9.800555e-01, -1.729806e-01, -1.744971e-01},
  {-9.668775e-01,  2.381117e-01,  9.192727e-02, -9.736632e-01,  2.513669e-01,  9.821245e-02},
  {-9.688210e-01,  1.980605e-01,  1.488549e-01, -9.776433e-01,  2.128296e-01,  1.405971e-01},
  {-9.689543e-01,  6.640548e-02,  2.381552e-01, -9.787434e-01,  7.181415e-02,  2.403177e-01},
  { 9.249836e-01, -4.262383e-02, -3.776091e-01,  9.390523e-01, -3.106783e-02, -3.716147e-01},
  { 9.557769e-01, -1.670875e-01, -2.420175e-01,  9.702873e-01, -1.544879e-01, -2.357044e-01},
  {-9.318517e-01,  3.620592e-01, -2.377895e-02, -9.439529e-01,  3.596230e-01, -2.185109e-02},
  { 9.452794e-01, -9.264095e-02, -3.128332e-01,  9.548795e-01, -8.565564e-02, -3.189822e-01},
  { 9.356581e-01, -6.804074e-02, -3.462866e-01,  9.443275e-01, -7.619173e-02, -3.511719e-01},
  {-9.676932e-01,  1.247742e-01,  2.190922e-01, -9.800240e-01,  1.204136e-01,  2.142492e-01},
  { 7.950135e-01,  1.993826e-01, -5.728875e-01,  8.030305e-01,  2.102354e-01, -5.760434e-01},
  { 7.757434e-01,  2.369134e-01, -5.848882e-01,  7.875893e-01,  2.415120e-01, -5.850283e-01},
  {-9.377748e-01,  3.402634e-01, -6.927690e-02, -9.484216e-01,  3.418121e-01, -6.718714e-02},
  {-9.464673e-01,  3.126760e-01, -8.020873e-02, -9.551501e-01,  3.166794e-01, -9.085842e-02},
  { 7.217157e-01,  2.789922e-01, -6.334743e-01,  7.356231e-01,  2.748373e-01, -6.357719e-01},
  {-9.482108e-01,  2.970844e-01, -1.124149e-01, -9.587041e-01,  3.018399e-01, -1.031102e-01},
  {-9.710572e-01,  1.217491e-01, -2.054873e-01, -9.797078e-01,  1.260307e-01, -2.124605e-01},
  {-9.645773e-01,  2.047032e-01, -1.663949e-01, -9.733686e-01,  2.108388e-01, -1.701527e-01},
  {-9.489249e-01, -1.004268e-01, -2.990920e-01, -9.481485e-01, -9.048846e-02, -3.371576e-01},
  {-9.030951e-01, -1.342725e-01, -4.079095e-01, -9.090916e-01, -1.506456e-01, -4.143762e-01},
  { 5.788473e-01,  2.867143e-01, -7.633680e-01,  5.899677e-01,  2.890267e-01, -7.677662e-01},
  {-8.353288e-01, -1.997811e-01, -5.121654e-01, -8.515089e-01, -2.007228e-01, -5.054630e-01},
  {-8.127259e-01, -1.948748e-01, -5.490905e-01, -8.177357e-01, -1.888475e-01, -5.625796e-01},
  {-7.806625e-01, -1.898668e-01, -5.954130e-01, -7.880412e-01, -1.993900e-01, -6.007032e-01},
  { 5.408112e-01,  3.950543e-01, -7.426003e-01,  5.451888e-01,  3.854921e-01, -7.583179e-01},
  {-6.950612e-01, -1.961862e-01, -6.916654e-01, -7.020055e-01, -1.989195e-01, -6.989081e-01},
  { 5.181585e-01,  3.226143e-02, -8.546760e-01,  5.265591e-01,  3.836206e-02, -8.614761e-01},
  { 4.946917e-01,  9.737469e-02, -8.635962e-01,  5.108714e-01,  8.251287e-02, -8.678015e-01},
  { 5.068626e-01,  1.499287e-01, -8.488886e-01,  5.055140e-01,  1.424087e-01, -8.631647e-01},
  {-5.157787e-01, -1.528542e-01, -8.429756e-01, -5.174109e-01, -1.496197e-01, -8.548434e-01},
  { 3.806979e-01, -4.174004e-02, -9.237569e-01,  3.919789e-01, -2.515251e-02, -9.309105e-01},
  { 3.277437e-01, -6.994046e-02, -9.421743e-01,  3.219399e-01, -4.295258e-02, -9.567565e-01},
  { 2.678016e-01, -3.209443e-02, -9.629394e-01,  2.895636e-01, -4.072223e-02, -9.671438e-01},
  {-4.546241e-01, -1.292990e-01, -8.812484e-01, -4.604123e-01, -1.331164e-01, -8.894712e-01},
  { 4.762702e-01,  5.113362e-01, -7.153335e-01,  4.840657e-01,  5.087185e-01, -7.264759e-01},
  { 1.913723e-01, -3.247084e-02, -9.809802e-01,  1.814814e-01, -4.261464e-02, -9.930354e-01},
  {-2.315382e-01, -1.004993e-01, -9.676208e-01, -2.248065e-01, -1.117599e-01, -9.786904e-01},
  { 2.202269e-02, -7.240548e-02, -9.971321e-01,  1.242307e-02, -6.189647e-02, -1.008406e+00},
  {-1.021824e-01, -7.979059e-02, -9.915605e-01, -1.068849e-01, -8.189325e-02, -1.001366e+00},
  {-1.386765e-01, -9.405648e-02, -9.858611e-01, -1.486357e-01, -9.342923e-02, -9.950091e-01},
  { 4.298131e-01, -2.410764e-01,  8.701395e-01,  4.365793e-01, -2.541311e-01,  8.750329e-01},
  { 4.598637e-01, -2.604375e-01,  8.489392e-01,  4.693733e-01, -2.667327e-01,  8.540548e-01},
  { 3.585573e-02, -2.489623e-01,  9.678493e-01,  4.254068e-02, -2.644198e-01,  9.742340e-01},
  { 3.913662e-01, -2.532001e-02,  9.198866e-01,  3.396608e-01, -2.530513e-01,  9.185746e-01},
  { 2.312277e-01, -2.551380e-01,  9.388494e-01,  2.253855e-01, -2.631031e-01,  9.491264e-01},
  { 3.510732e-01, -9.929092e-02,  9.310687e-01,  3.300710e-01, -2.490488e-01,  9.218962e-01},
  { 1.232557e-01, -3.506504e-01,  9.283600e-01,  2.700497e-01, -2.596562e-01,  9.396209e-01},
  { 5.666675e-01, -2.952461e-01,  7.692320e-01,  5.703358e-01, -3.102689e-01,  7.741569e-01},
  {-1.650761e-01, -2.768143e-01,  9.466381e-01, -1.723609e-01, -2.689796e-01,  9.585393e-01},
  { 6.395419e-01, -3.147908e-01,  7.013507e-01,  6.492544e-01, -3.134003e-01,  7.078977e-01},
  { 7.122092e-01, -3.181983e-01,  6.257058e-01,  7.163637e-01, -3.254649e-01,  6.338509e-01},
  {-3.157192e-01, -2.708337e-01,  9.093792e-01, -3.144628e-01, -2.731885e-01,  9.205079e-01},
  {-4.883349e-01, -2.856842e-01,  8.245687e-01, -5.035976e-01, -2.906707e-01,  8.262872e-01},
  { 7.827685e-01, -3.421843e-01,  5.197918e-01,  7.892081e-01, -3.426246e-01,  5.297469e-01},
  {-6.196030e-01, -2.532333e-01,  7.429435e-01, -6.279002e-01, -2.528506e-01,  7.501047e-01},
  { 8.054687e-01, -3.431169e-01,  4.832092e-01,  8.126765e-01, -3.478482e-01,  4.893178e-01},
  {-4.568432e-01, -2.726046e-01,  8.467474e-01, -4.428737e-01, -2.689751e-01,  8.673909e-01},
  {-5.769809e-01, -2.419508e-01,  7.800978e-01, -5.934629e-01, -2.372089e-01,  7.825493e-01},
  {-7.675133e-01, -2.126409e-01,  6.047373e-01, -7.743855e-01, -2.519863e-01,  5.980611e-01},
  {-6.096452e-01, -2.118623e-01,  7.638370e-01, -6.060764e-01, -2.206201e-01,  7.777197e-01},
  {-7.855027e-01, -2.221565e-01,  5.776088e-01, -7.959631e-01, -2.455503e-01,  5.718345e-01},
  {-4.106544e-01, -2.446807e-01,  8.783475e-01, -4.085135e-01, -2.494358e-01,  8.898039e-01},
  {-4.631905e-01, -2.226854e-01,  8.578262e-01, -4.679398e-01, -2.328104e-01,  8.646868e-01},
  { 8.854098e-01, -3.397228e-01,  3.172350e-01,  8.905051e-01, -3.453651e-01,  3.295432e-01},
  {-5.960842e-01, -1.715786e-01,  7.843751e-01, -6.033804e-01, -1.808363e-01,  7.899876e-01},
  {-8.156727e-01, -2.185425e-01,  5.356466e-01, -8.253245e-01, -2.338658e-01,  5.338472e-01},
  {-5.517282e-01, -1.835541e-01,  8.135747e-01, -5.599830e-01, -1.822478e-01,  8.210089e-01},
  { 9.288725e-01, -3.219745e-01,  1.831072e-01,  9.376727e-01, -3.247313e-01,  1.902525e-01},
  {-5.215169e-01, -1.623795e-01,  8.376473e-01, -5.257081e-01, -1.677976e-01,  8.463606e-01},
  {-8.460732e-01, -2.273534e-01,  4.821522e-01, -8.552569e-01, -2.400423e-01,  4.814163e-01},
  {-8.591148e-01, -2.463535e-01,  4.485884e-01, -8.710478e-01, -2.598090e-01,  4.411587e-01},
  {-8.759200e-01, -2.019807e-01,  4.381415e-01, -8.847181e-01, -1.979668e-01,  4.460150e-01},
  { 9.595050e-01, -2.758871e-01,  5.689104e-02,  9.687367e-01, -2.803201e-01,  6.203214e-02},
  {-9.151343e-01, -7.275693e-02,  3.965295e-01, -9.243245e-01, -8.231527e-02,  3.996193e-01},
  { 9.659235e-01, -2.588209e-01, -1.880109e-03,  9.776514e-01, -2.550194e-01, -6.463425e-03},
  { 9.743230e-01, -1.748524e-01, -1.418493e-01,  9.840817e-01, -1.753250e-01, -1.473924e-01},
  { 9.705889e-01, -2.306210e-01, -6.907378e-02,  9.832456e-01, -2.243996e-01, -6.125712e-02},
  {-9.472386e-01,  3.140053e-01,  6.434124e-02, -9.583183e-01,  3.154456e-01,  5.631480e-02},
  { 9.409658e-01, -1.664697e-03, -3.384974e-01,  9.499623e-01, -1.644575e-02, -3.437779e-01},
  {-9.382779e-01,  3.450786e-01,  2.356558e-02, -9.458613e-01,  3.551183e-01,  9.510905e-03},
  { 8.221787e-01,  1.819173e-01, -5.393777e-01,  8.323522e-01,  1.833301e-01, -5.426443e-01},
  {-9.717588e-01,  1.601780e-01,  1.732857e-01, -9.809393e-01,  1.713268e-01,  1.710409e-01},
  { 9.516411e-01, -1.312043e-01, -2.777849e-01,  9.651646e-01, -1.246422e-01, -2.716660e-01},
  { 8.113149e-01,  2.242862e-01, -5.398740e-01,  8.167931e-01,  2.275793e-01, -5.494907e-01},
  {-9.310663e-01,  3.609185e-01, -5.341729e-02, -9.382167e-01,  3.699707e-01, -6.102967e-02},
  {-9.656932e-01,  6.836990e-02, -2.505239e-01, -9.766224e-01,  7.824601e-02, -2.468530e-01},
  {-9.567586e-01, -7.017284e-02, -2.822920e-01, -9.617119e-01, -3.897789e-02, -3.073115e-01},
  {-9.678940e-01,  1.600519e-01, -1.938157e-01, -9.730063e-01,  1.722521e-01, -2.108059e-01},
  {-9.235175e-01, -9.052393e-02, -3.727209e-01, -9.341446e-01, -9.628803e-02, -3.727624e-01},
  { 6.830349e-01,  2.969194e-01, -6.673096e-01,  6.869950e-01,  3.009694e-01, -6.770064e-01},
  {-8.805013e-01, -1.564708e-01, -4.474757e-01, -8.891516e-01, -1.580042e-01, -4.530934e-01},
  { 6.444429e-01,  3.121461e-01, -6.980388e-01,  6.585259e-01,  3.093994e-01, -7.010689e-01},
  {-8.160859e-01, -1.586915e-01, -5.557165e-01, -8.217872e-01, -1.561357e-01, -5.666909e-01},
  {-7.885867e-01, -1.361884e-01, -5.996529e-01, -8.040370e-01, -1.234477e-01, -5.992805e-01},
  {-7.488975e-01, -1.574705e-01, -6.437045e-01, -7.575741e-01, -1.545402e-01, -6.504240e-01},
  {-6.687156e-01, -1.166546e-01, -7.343100e-01, -7.226079e-01, -1.487574e-01, -6.903351e-01},
  {-6.592366e-01, -5.256775e-02, -7.500958e-01, -7.363630e-01, -1.263947e-01, -6.814447e-01},
  { 5.533613e-01,  4.864983e-01, -6.760996e-01,  5.584071e-01,  5.007297e-01, -6.770034e-01},
  {-6.544518e-01, -1.683175e-01, -7.371310e-01, -6.647593e-01, -1.845002e-01, -7.381793e-01},
  { 4.955866e-01,  2.210290e-01, -8.399643e-01,  4.855321e-01,  2.288486e-01, -8.560172e-01},
  { 5.202842e-01,  5.106908e-01, -6.844701e-01,  5.355716e-01,  5.076808e-01, -6.901488e-01},
  { 4.741472e-01,  1.896549e-01, -8.597764e-01,  4.832035e-01,  1.838553e-01, -8.680954e-01},
  {-4.822780e-01, -1.203556e-01, -8.677111e-01, -4.882000e-01, -1.292089e-01, -8.751136e-01},
  {-6.128899e-01, -1.663691e-01, -7.724554e-01, -6.188092e-01, -1.658366e-01, -7.812992e-01},
  { 4.218435e-01,  8.778944e-03, -9.066262e-01,  4.252474e-01,  5.811635e-03, -9.165184e-01},
  { 4.410933e-01,  3.957328e-02, -8.965883e-01,  4.421147e-01,  3.392990e-02, -9.078872e-01},
  { 3.802423e-01,  1.506397e-02, -9.247642e-01,  3.820404e-01,  1.669216e-02, -9.352226e-01},
  { 3.315501e-01, -8.923059e-03, -9.433954e-01,  3.292531e-01, -2.544631e-03, -9.552275e-01},
  { 4.543965e-01,  5.131816e-01, -7.281268e-01,  4.645160e-01,  5.095400e-01, -7.385627e-01},
  {-2.989674e-01, -1.020199e-01, -9.487942e-01, -2.953178e-01, -1.009352e-01, -9.609691e-01},
  {-1.832707e-01, -8.091015e-02, -9.797272e-01, -1.907827e-01, -7.674449e-02, -9.892302e-01},
  {-4.311376e-01, -1.014800e-01, -8.965613e-01, -4.217905e-01, -9.425957e-02, -9.132731e-01},
  { 8.350512e-02, -5.485447e-02, -9.949964e-01,  8.605651e-02, -4.607703e-02, -1.005654e+00},
  {-3.286794e-01, -7.418749e-02, -9.415233e-01, -3.332744e-01, -7.606532e-02, -9.507911e-01},
  {-3.799874e-01, -8.096181e-02, -9.214417e-01, -3.879197e-01, -8.499724e-02, -9.290609e-01},
  {-5.967635e-02, -7.609721e-02, -9.953130e-01, -5.354362e-02, -6.020037e-02, -1.007162e+00},
  { 4.308563e-01, -2.990287e-01,  8.514369e-01,  4.317687e-01, -3.062747e-01,  8.606032e-01},
  { 1.499021e-01, -2.411661e-01,  9.588370e-01,  1.535146e-01, -2.485668e-01,  9.672174e-01},
  { 1.170810e-01, -3.079277e-01,  9.441783e-01,  2.627369e-01, -2.493671e-01,  9.432120e-01},
  {-6.154910e-01, -3.419708e-01,  7.100894e-01, -6.227953e-01, -3.456916e-01,  7.165693e-01},
  { 7.259923e-01, -3.159675e-01,  6.108189e-01,  7.528214e-01, -3.147991e-01,  5.958471e-01},
  {-6.582224e-01, -3.304970e-01,  6.763985e-01, -6.609873e-01, -3.232247e-01,  6.924374e-01},
  {-6.443117e-01, -2.793829e-01,  7.119043e-01, -6.616820e-01, -2.716627e-01,  7.135999e-01},
  { 9.106901e-01, -3.065077e-01,  2.769412e-01,  9.239049e-01, -3.070115e-01,  2.702220e-01},
  {-6.338655e-01, -1.787493e-01,  7.525046e-01, -6.443060e-01, -1.719713e-01,  7.590423e-01},
  { 8.390381e-01, -3.597225e-01,  4.081847e-01,  8.439105e-01, -3.581243e-01,  4.247776e-01},
  { 9.256908e-01, -3.102835e-01,  2.163808e-01,  9.365306e-01, -3.097100e-01,  2.187849e-01},
  {-5.547282e-01, -1.458702e-01,  8.191450e-01, -5.628085e-01, -1.517301e-01,  8.252731e-01},
  {-8.548305e-01, -1.903746e-01,  4.827238e-01, -8.607422e-01, -1.819017e-01,  4.968718e-01},
  { 9.455158e-01, -2.985202e-01,  1.299443e-01,  9.553093e-01, -2.993986e-01,  1.364624e-01},
  {-8.941411e-01, -1.370476e-01,  4.262975e-01, -9.040928e-01, -1.288459e-01,  4.349066e-01},
  { 9.222866e-01,  9.953458e-02, -3.734707e-01,  9.236819e-01,  1.065896e-01, -3.953904e-01},
  { 9.263948e-01,  7.267941e-02, -3.694734e-01,  9.345309e-01,  7.269209e-02, -3.771616e-01},
  { 8.840643e-01,  1.348842e-01, -4.474778e-01,  8.830809e-01,  1.445132e-01, -4.692197e-01},
  {-9.414153e-01, -1.589253e-02,  3.368749e-01, -9.506143e-01, -1.730059e-02,  3.418781e-01},
  { 9.375581e-01,  3.912483e-02, -3.456213e-01,  9.422093e-01,  4.966873e-02, -3.614656e-01},
  { 9.785519e-01, -1.879818e-01, -8.425592e-02,  9.884671e-01, -1.931740e-01, -8.060040e-02},
  { 8.614095e-01,  1.714671e-01, -4.780927e-01,  8.719931e-01,  1.697070e-01, -4.813637e-01},
  {-9.536715e-01,  2.798075e-01,  1.105378e-01, -9.632877e-01,  2.812065e-01,  1.176912e-01},
  {-9.576946e-01,  2.462973e-01,  1.488584e-01, -9.700955e-01,  2.394820e-01,  1.497127e-01},
  {-9.615058e-01,  1.993575e-01,  1.891117e-01, -9.722445e-01,  1.968587e-01,  1.919308e-01},
  { 9.503661e-01, -4.106822e-02, -3.084115e-01,  9.638110e-01, -4.332918e-02, -3.001214e-01},
  { 9.713857e-01, -1.124100e-01, -2.092221e-01,  9.778562e-01, -1.236547e-01, -2.223213e-01},
  {-9.613689e-01,  3.129747e-02, -2.734782e-01, -9.697472e-01,  2.706984e-02, -2.823248e-01},
  {-9.590734e-01, -2.080476e-02, -2.823922e-01, -9.651006e-01, -2.216561e-03, -2.990410e-01},
  {-9.182343e-01,  3.849174e-01, -9.319010e-02, -9.306252e-01,  3.808729e-01, -9.862328e-02},
  {-9.323826e-01,  3.412740e-01, -1.191416e-01, -9.370021e-01,  3.598899e-01, -1.155854e-01},
  {-9.552376e-01,  1.666371e-01, -2.444446e-01, -9.684786e-01,  1.612617e-01, -2.385270e-01},
  {-9.382097e-01, -4.181037e-02, -3.435325e-01, -9.476174e-01, -5.331062e-02, -3.464515e-01},
  {-9.527426e-01,  2.098192e-01, -2.196759e-01, -9.645067e-01,  2.076362e-01, -2.178661e-01},
  {-9.520002e-01,  2.373064e-01, -1.933421e-01, -9.628159e-01,  2.343374e-01, -1.972902e-01},
  {-9.059765e-01, -1.160809e-01, -4.071016e-01, -9.108253e-01, -1.137650e-01, -4.222610e-01},
  {-6.431311e-01, -4.245159e-01,  6.373136e-01,  6.498741e-01,  4.282846e-01, -6.442973e-01},
  {-6.407678e-01, -4.302039e-01,  6.358784e-01,  6.488358e-01,  4.284876e-01, -6.452081e-01},
  { 6.438036e-01,  4.304560e-01, -6.326330e-01,  6.459479e-01,  4.301934e-01, -6.469682e-01},
  {-6.842957e-01, -3.851176e-01,  6.192123e-01,  6.513304e-01,  4.270917e-01, -6.436182e-01},
  { 6.420309e-01,  4.192751e-01, -6.418760e-01,  6.496229e-01,  4.230802e-01, -6.479786e-01},
  {-6.574196e-01, -4.097635e-01,  6.323712e-01,  6.507943e-01,  4.259799e-01, -6.448960e-01},
  {-8.644757e-01, -1.580688e-01, -4.771750e-01, -8.745827e-01, -1.572552e-01, -4.808595e-01},
  { 6.374486e-01,  4.040380e-01, -6.560584e-01,  6.426455e-01,  4.115179e-01, -6.626174e-01},
  {-8.421055e-01, -1.558180e-01, -5.163130e-01, -8.549182e-01, -1.556623e-01, -5.154945e-01},
  { 5.490062e-01,  2.803150e-01, -7.874109e-01,  5.491731e-01,  2.865621e-01, -7.982301e-01},
  {-7.360671e-01, -1.891348e-01, -6.499487e-01, -7.291568e-01, -1.831758e-01, -6.750035e-01},
  { 5.097915e-01,  2.947586e-01, -8.082265e-01,  5.175159e-01,  3.020371e-01, -8.135298e-01},
  {-7.675958e-01, -1.590985e-01, -6.208739e-01, -7.813268e-01, -1.615658e-01, -6.199006e-01},
  { 5.450363e-01,  2.936721e-01, -7.852975e-01,  5.498064e-01,  3.392889e-01, -7.768376e-01},
  {-2.371522e-01, -9.713559e-01,  1.505458e-02,  5.384238e-01,  3.412991e-01, -7.838975e-01},
  { 5.191911e-01,  2.678013e-01, -8.116175e-01,  5.158503e-01,  3.442058e-01, -7.976848e-01},
  { 4.984351e-01,  3.655693e-01, -7.860799e-01,  5.060372e-01,  3.753630e-01, -7.898794e-01},
  {-5.286270e-01, -3.840082e-01,  7.570279e-01,  5.328947e-01,  3.425570e-01, -7.871203e-01},
  { 4.731537e-01, -1.211067e-02, -8.808966e-01,  5.188500e-01,  3.466159e-01, -7.946901e-01},
  {-5.059233e-01, -6.086550e-01,  6.112124e-01,  5.298508e-01,  3.435706e-01, -7.887318e-01},
  {-7.784899e-01, -9.478368e-02, -6.204591e-01, -7.884148e-01, -8.846925e-02, -6.262735e-01},
  {-7.606419e-01, -1.045650e-01, -6.406949e-01, -7.809666e-01, -8.531115e-02, -6.353471e-01},
  { 4.697061e-01,  3.944861e-01, -7.897828e-01,  4.664745e-01,  3.951418e-01, -8.044530e-01},
  {-6.781069e-01, -4.073653e-02, -7.338336e-01, -7.471399e-01, -1.005161e-01, -6.727049e-01},
  { 4.737729e-01,  5.304595e-02, -8.790479e-01,  4.706115e-01,  6.517267e-02, -8.917140e-01},
  {-5.296419e-01, -1.229374e-01, -8.392651e-01, -5.316823e-01, -1.340415e-01, -8.486484e-01},
  { 4.536252e-01,  4.393254e-01, -7.753821e-01,  4.669872e-01,  4.470867e-01, -7.764773e-01},
  {-5.823987e-01, -1.312353e-01, -8.022400e-01, -5.876839e-01, -1.406531e-01, -8.097533e-01},
  { 3.641169e-01,  5.816120e-02, -9.295354e-01,  3.710265e-01,  4.390211e-02, -9.387687e-01},
  { 2.777216e-01,  2.831620e-03, -9.606574e-01,  2.844814e-01, -3.913148e-03, -9.694988e-01},
  {-1.936718e-01, -5.179676e-02, -9.796981e-01, -1.968339e-01, -5.812800e-02, -9.893138e-01},
  {-2.527045e-01, -8.926606e-02, -9.634169e-01, -2.531343e-01, -7.839999e-02, -9.750074e-01},
  { 3.025378e-02, -3.263334e-02, -9.990094e-01,  3.309236e-02, -4.011373e-02, -1.009041e+00},
  { 1.945713e-01, -2.426688e-01,  9.503967e-01,  2.085050e-01, -2.425801e-01,  9.584066e-01},
  { 1.088347e-01, -2.367352e-01,  9.654592e-01,  9.606989e-02, -2.271741e-01,  9.798078e-01},
  {-1.397999e-02, -2.432341e-01,  9.698669e-01, -2.270184e-02, -2.438181e-01,  9.802530e-01},
  { 2.597167e-01, -1.868405e-01,  9.474375e-01,  2.647935e-01, -2.096574e-01,  9.522564e-01},
  { 2.224675e-01, -2.129989e-01,  9.513883e-01,  2.301240e-01, -2.116800e-01,  9.607799e-01},
  { 1.672060e-01, -2.054817e-01,  9.642714e-01,  1.622792e-01, -2.063474e-01,  9.756785e-01},
  { 1.458205e-01, -1.803296e-01,  9.727373e-01,  1.404363e-01, -1.769581e-01,  9.847973e-01},
  { 2.264468e-01, -1.567950e-01,  9.613205e-01,  2.221259e-01, -1.745302e-01,  9.700840e-01},
  { 6.562010e-01, -2.895852e-01,  6.968074e-01,  6.652389e-01, -2.887896e-01,  7.035116e-01},
  {-2.090063e-01, -2.463737e-01,  9.463701e-01, -2.068062e-01, -2.492765e-01,  9.570517e-01},
  { 6.888756e-01, -2.994504e-01,  6.601362e-01,  6.936205e-01, -2.952214e-01,  6.727601e-01},
  { 7.719314e-01, -3.054998e-01,  5.574871e-01,  7.780935e-01, -3.111636e-01,  5.644649e-01},
  {-3.319507e-01, -2.294323e-01,  9.149697e-01, -3.369826e-01, -2.351180e-01,  9.230471e-01},
  {-6.612295e-01, -2.172926e-01,  7.180247e-01, -6.652401e-01, -2.256329e-01,  7.262191e-01},
  { 8.321534e-01, -3.235863e-01,  4.503472e-01,  8.429414e-01, -3.262464e-01,  4.515388e-01},
  {-6.690512e-01, -1.705733e-01,  7.233777e-01, -6.702182e-01, -1.727024e-01,  7.360914e-01},
  {-8.303323e-01, -1.892729e-01,  5.241413e-01, -8.373396e-01, -1.987356e-01,  5.293518e-01},
  {-5.949118e-01, -1.336284e-01,  7.926055e-01, -5.987756e-01, -1.347413e-01,  8.025979e-01},
  {-8.610270e-01, -2.025807e-01,  4.664693e-01, -8.744127e-01, -2.009967e-01,  4.645957e-01},
  { 9.447042e-01, -2.776587e-01,  1.744695e-01,  9.546314e-01, -2.856021e-01,  1.672949e-01},
  { 9.603642e-01, -2.619870e-01,  9.520294e-02,  9.700023e-01, -2.663635e-01,  9.499544e-02},
  { 9.022582e-01,  1.201919e-01, -4.141063e-01,  9.156035e-01,  1.293661e-01, -4.072074e-01},
  {-9.206569e-01, -1.752771e-02,  3.899792e-01, -9.350680e-01, -8.882049e-03,  3.826447e-01},
  { 9.783899e-01, -2.054985e-01, -2.288135e-02,  9.876583e-01, -2.121004e-01, -2.059284e-02},
  {-9.529648e-01,  3.399533e-02,  3.011685e-01, -9.609531e-01,  3.719985e-02,  3.098927e-01},
  { 8.422341e-01,  1.887840e-01, -5.049775e-01,  8.531208e-01,  1.940973e-01, -5.053657e-01},
  {-9.550225e-01,  8.954979e-02,  2.826886e-01, -9.697242e-01,  9.231529e-02,  2.682566e-01},
  { 9.671607e-01, -7.813754e-02, -2.418570e-01,  9.759223e-01, -8.779714e-02, -2.464725e-01},
  { 9.613963e-01, -5.856206e-02, -2.688637e-01,  9.704684e-01, -4.399853e-02, -2.777355e-01},
  { 7.956226e-01,  2.634465e-01, -5.455093e-01,  8.036090e-01,  2.580988e-01, -5.554107e-01},
  {-9.563745e-01,  1.197653e-01, -2.664663e-01, -9.667059e-01,  1.193750e-01, -2.684775e-01},
  {-9.404906e-01,  2.972178e-01, -1.647391e-01, -9.507633e-01,  2.964562e-01, -1.703400e-01},
  {-9.476317e-01,  2.543965e-01, -1.930716e-01, -9.555327e-01,  2.651578e-01, -1.936519e-01},
  {-6.077871e-01, -4.054364e-01,  6.828003e-01,  6.486359e-01,  4.276945e-01, -6.459349e-01},
  { 5.609708e-01,  2.835826e-01,  7.777484e-01,  6.489108e-01,  4.269567e-01, -6.461469e-01},
  { 5.605208e-01,  2.856193e-01,  7.773275e-01,  6.460051e-01,  4.300324e-01, -6.470181e-01},
  { 6.593125e-01,  4.108244e-01, -6.297064e-01,  6.510845e-01,  4.241738e-01, -6.457929e-01},
  { 6.633554e-01,  3.719811e-01, -6.492994e-01,  6.588952e-01,  3.867640e-01, -6.611758e-01},
  { 6.275939e-01,  3.540131e-01, -6.933979e-01,  6.336389e-01,  3.514311e-01, -7.041875e-01},
  {-8.097810e-01, -8.962498e-02, -5.798467e-01, -8.342901e-01, -1.181216e-01, -5.575469e-01},
  { 5.917890e-01,  4.585381e-01, -6.629695e-01,  6.097689e-01,  4.701550e-01, -6.554946e-01},
  {-8.118685e-01, -4.620292e-02, -5.820094e-01, -8.099520e-01, -6.459168e-02, -6.005482e-01},
  { 4.724004e-01,  2.990732e-01, -8.290918e-01,  4.728660e-01,  3.057157e-01, -8.389367e-01},
  {-6.683130e-01, -1.432117e-01, -7.299644e-01, -6.795797e-01, -1.503449e-01, -7.324083e-01},
  { 4.458380e-01,  9.537309e-02, -8.900182e-01,  4.560028e-01,  9.538429e-02, -8.965712e-01},
  { 4.599032e-01,  1.483003e-01, -8.754976e-01,  4.600048e-01,  1.594809e-01, -8.853468e-01},
  { 4.460931e-01,  2.347668e-01, -8.636467e-01,  4.488625e-01,  2.375207e-01, -8.734899e-01},
  { 4.048995e-01,  6.928769e-02, -9.117322e-01,  4.133129e-01,  7.607513e-02, -9.188367e-01},
  { 2.244416e-01, -1.741183e-02, -9.743320e-01,  2.248547e-01, -1.216939e-02, -9.849691e-01},
  { 4.709190e-01,  5.272771e-01, -7.072582e-01,  4.862753e-01,  5.306984e-01, -7.090679e-01},
  { 4.321259e-01,  4.796038e-01, -7.637064e-01,  4.381363e-01,  4.933110e-01, -7.652198e-01},
  {-1.395553e-01, -3.747426e-02, -9.895049e-01, -1.318228e-01, -3.844392e-02, -1.001005e+00},
  { 1.105530e-01, -1.520001e-02, -9.937539e-01,  1.117246e-01, -1.583972e-02, -1.004060e+00},
  {-8.056372e-02, -2.806933e-02, -9.963541e-01, -9.061597e-02, -3.693106e-02, -1.005630e+00},
  {-2.208771e-02, -3.026707e-02, -9.992978e-01, -2.974025e-02, -4.099555e-02, -1.009110e+00},
  { 5.694485e-01, -1.174692e-01,  8.135904e-01,  4.811276e-01, -2.286010e-01,  8.585602e-01},
  { 5.343814e-01, -1.876038e-01,  8.241609e-01,  4.975033e-01, -2.464266e-01,  8.441756e-01},
  { 5.268865e-01, -2.628064e-01,  8.082842e-01,  5.343022e-01, -2.629662e-01,  8.174973e-01},
  { 2.990177e-01, -2.213192e-01,  9.282275e-01,  3.331817e-01, -1.959983e-01,  9.335096e-01},
  { 2.782032e-01, -2.247198e-01,  9.338651e-01,  3.392289e-01, -1.889093e-01,  9.340559e-01},
  {-7.468042e-02, -2.483388e-01,  9.657902e-01, -6.455114e-02, -2.434744e-01,  9.784740e-01},
  { 9.706840e-02, -1.783834e-01,  9.791614e-01,  1.045247e-01, -1.920127e-01,  9.864417e-01},
  {-1.404025e-01, -2.359462e-01,  9.615698e-01, -1.630868e-01, -2.359062e-01,  9.688175e-01},
  {-1.947762e-01, -1.362091e-01,  9.713441e-01, -1.856212e-01, -1.347056e-01,  9.840001e-01},
  { 1.745780e-01, -1.523727e-01,  9.727821e-01,  1.760047e-01, -1.498890e-01,  9.835745e-01},
  {-2.005648e-01, -1.868931e-01,  9.616885e-01, -2.029576e-01, -1.758478e-01,  9.740340e-01},
  {-2.395206e-01, -1.002220e-01,  9.657046e-01, -2.355837e-01, -9.476113e-02,  9.779455e-01},
  {-2.329393e-01, -2.302098e-01,  9.448507e-01, -2.318337e-01, -2.379581e-01,  9.541931e-01},
  {-2.492833e-01, -1.650150e-01,  9.542682e-01, -2.541407e-01, -1.733113e-01,  9.624091e-01},
  {-2.643756e-01, -1.265179e-01,  9.560851e-01, -2.704893e-01, -1.329300e-01,  9.643760e-01},
  {-2.663614e-01, -2.213199e-01,  9.381199e-01, -2.698632e-01, -2.189022e-01,  9.487416e-01},
  {-2.967179e-01, -2.162536e-01,  9.301575e-01, -3.027976e-01, -2.135921e-01,  9.399715e-01},
  {-3.171679e-01, -1.829683e-01,  9.305521e-01, -3.299462e-01, -1.814882e-01,  9.375777e-01},
  {-6.796437e-01, -2.552635e-01,  6.876954e-01, -6.835697e-01, -2.765422e-01,  6.907278e-01},
  { 8.127748e-01, -2.985258e-01,  5.002793e-01,  8.221499e-01, -2.984119e-01,  5.058594e-01},
  {-3.562790e-01, -2.076953e-01,  9.110038e-01, -3.526193e-01, -2.037318e-01,  9.246657e-01},
  {-6.928130e-01, -2.187848e-01,  6.871269e-01, -7.081444e-01, -2.158219e-01,  6.876051e-01},
  {-6.787413e-01, -1.988804e-01,  7.069348e-01, -6.914415e-01, -2.060193e-01,  7.073283e-01},
  {-3.816188e-01, -2.146518e-01,  8.990505e-01, -3.934525e-01, -2.208514e-01,  9.040313e-01},
  {-7.825353e-01, -2.072963e-01,  5.870832e-01, -7.978935e-01, -2.016219e-01,  5.861415e-01},
  { 8.961385e-01, -2.994103e-01,  3.275504e-01,  9.009666e-01, -3.049030e-01,  3.408358e-01},
  { 9.299134e-01, -2.814631e-01,  2.367269e-01,  9.444714e-01, -2.805158e-01,  2.239684e-01},
  {-6.354842e-01, -1.261939e-01,  7.617316e-01, -6.412302e-01, -1.226291e-01,  7.711266e-01},
  {-5.722340e-01, -9.733441e-02,  8.142937e-01, -5.734870e-01, -1.157157e-01,  8.237560e-01},
  {-9.040976e-01, -8.487558e-02,  4.188122e-01, -9.004450e-01, -1.001657e-01,  4.472279e-01},
  { 9.005858e-01,  1.600230e-01, -4.041507e-01,  9.114997e-01,  1.548730e-01, -4.075122e-01},
  { 9.754981e-01, -2.189710e-01,  2.133240e-02,  9.844973e-01, -2.257426e-01,  2.615968e-02},
  {-9.151640e-01,  3.606137e-02,  4.014654e-01, -9.245729e-01,  3.191929e-02,  4.061951e-01},
  { 9.850086e-01, -1.234570e-01, -1.204843e-01,  9.942498e-01, -1.330576e-01, -1.210118e-01},
  { 9.865826e-01, -1.458856e-01, -7.329492e-02,  9.960310e-01, -1.519918e-01, -7.550520e-02},
  { 9.836463e-01, -1.780756e-01, -2.699807e-02,  9.943470e-01, -1.747351e-01, -4.027114e-02},
  {-9.332123e-01,  2.416889e-02,  3.585118e-01, -9.413472e-01,  2.210043e-02,  3.663675e-01},
  { 9.592426e-01,  1.687582e-02, -2.820795e-01,  9.678786e-01,  9.457625e-04, -2.899870e-01},
  { 9.784771e-01, -1.200206e-01, -1.678617e-01,  9.896057e-01, -1.109398e-01, -1.710384e-01},
  {-9.543758e-01,  2.241234e-01,  1.973207e-01, -9.630501e-01,  2.339829e-01,  1.965638e-01},
  { 8.091220e-01,  2.973299e-01, -5.068693e-01,  8.157179e-01,  3.021816e-01, -5.139791e-01},
  { 7.983932e-01,  3.049422e-01, -5.192097e-01,  8.085830e-01,  3.045467e-01, -5.237641e-01},
  {-9.148207e-01,  4.030387e-01,  2.574757e-02, -9.284430e-01,  3.982697e-01,  1.512130e-02},
  {-9.536709e-01,  1.334619e-01,  2.696287e-01, -9.636690e-01,  1.354600e-01,  2.717389e-01},
  {-9.088253e-01,  4.144719e-01, -4.742945e-02, -9.209477e-01,  4.121773e-01, -5.309768e-02},
  {-9.195242e-01,  3.760192e-01, -1.143889e-01, -9.193378e-01,  3.965835e-01, -1.356241e-01},
  {-9.478274e-01,  8.683570e-02, -3.067290e-01, -9.601234e-01,  8.220807e-02, -3.037359e-01},
  { 7.541546e-01,  2.840606e-01, -5.920813e-01,  7.576916e-01,  2.963144e-01, -5.991530e-01},
  {-9.237511e-01, -3.702132e-02, -3.811999e-01, -9.326488e-01, -3.757792e-02, -3.867871e-01},
  {-9.277031e-01,  3.353370e-01, -1.640609e-01, -9.389043e-01,  3.331439e-01, -1.683074e-01},
  { 7.040016e-01,  3.270656e-01, -6.304044e-01,  7.141849e-01,  3.258619e-01, -6.361107e-01},
  {-9.083889e-01, -6.562086e-02, -4.129449e-01, -9.180914e-01, -6.930783e-02, -4.161186e-01},
  {-8.852940e-01, -1.085804e-01, -4.521778e-01, -8.940136e-01, -1.021135e-01, -4.595242e-01},
  { 6.629019e-01,  3.394755e-01, -6.673211e-01,  6.640643e-01,  3.449405e-01, -6.789086e-01},
  {-8.589208e-01, -1.228005e-01, -4.971671e-01, -8.657293e-01, -1.354548e-01, -5.030060e-01},
  { 5.937287e-01,  3.395949e-01, -7.294940e-01,  5.955234e-01,  3.372473e-01, -7.433018e-01},
  {-7.825730e-01, -3.242181e-02, -6.217141e-01, -8.386330e-01, -1.123819e-01, -5.528237e-01},
  {-7.992354e-01, -2.446201e-02, -6.005200e-01, -8.418716e-01, -1.058266e-01, -5.485475e-01},
  {-8.194827e-01, -8.059692e-02, -5.674084e-01, -8.296198e-01, -8.440933e-02, -5.704892e-01},
  { 4.432793e-01,  3.430043e-01, -8.281615e-01,  4.490148e-01,  3.526783e-01, -8.335965e-01},
  { 4.232655e-01,  2.706657e-01, -8.646307e-01,  4.271912e-01,  2.763449e-01, -8.729372e-01},
  { 4.417210e-01,  3.386122e-01, -8.307974e-01,  3.997644e-01,  3.516175e-01, -8.587387e-01},
  {-7.019845e-01, -1.008475e-01, -7.050161e-01, -7.054989e-01, -1.141551e-01, -7.142087e-01},
  { 4.289066e-01,  4.020743e-01, -8.089347e-01,  4.421255e-01,  4.115341e-01, -8.099657e-01},
  { 4.447588e-01,  1.353112e-01, -8.853703e-01,  4.416979e-01,  1.392087e-01, -8.979982e-01},
  {-4.878476e-01, -9.938919e-02, -8.672522e-01, -4.901815e-01, -9.006909e-02, -8.789017e-01},
  { 3.235592e-01,  2.985878e-02, -9.457367e-01,  3.280369e-01,  3.843024e-02, -9.548764e-01},
  { 3.235518e-01,  6.163058e-02, -9.442012e-01,  3.308647e-01,  6.055700e-02, -9.527517e-01},
  {-4.481985e-01, -5.943748e-02, -8.919559e-01, -4.595596e-01, -6.727860e-02, -8.985577e-01},
  { 5.122650e-01, -1.596086e-01,  8.438659e-01,  4.654714e-01, -2.097063e-01,  8.719102e-01},
  { 4.031188e-01, -1.999179e-01,  8.930442e-01,  4.032722e-01, -1.950630e-01,  9.056427e-01},
  { 6.315725e-02, -2.125509e-01,  9.751068e-01,  6.628057e-02, -2.072691e-01,  9.866646e-01},
  { 6.104881e-01, -2.661095e-01,  7.459826e-01,  6.117419e-01, -2.548429e-01,  7.626906e-01},
  { 3.014193e-01, -1.612657e-01,  9.397551e-01,  3.041823e-01, -1.643750e-01,  9.493784e-01},
  { 1.316613e-01, -1.285796e-01,  9.829204e-01,  1.404453e-01, -1.249172e-01,  9.927405e-01},
  { 7.570217e-01, -2.918281e-01,  5.845976e-01,  7.413434e-01, -2.635082e-01,  6.339131e-01},
  { 7.738457e-01, -2.537617e-01,  5.803170e-01,  7.539166e-01, -2.644832e-01,  6.184911e-01},
  { 7.765515e-01, -2.556410e-01,  5.758606e-01,  7.811181e-01, -2.654281e-01,  5.833317e-01},
  {-3.051980e-01, -1.441306e-01,  9.413185e-01, -2.985334e-01, -1.448406e-01,  9.543344e-01},
  {-2.988281e-01, -8.875225e-02,  9.501709e-01, -3.064187e-01, -9.129640e-02,  9.584510e-01},
  { 8.049267e-01, -2.671853e-01,  5.298160e-01,  8.129812e-01, -2.753714e-01,  5.330161e-01},
  {-3.622141e-01, -1.625236e-01,  9.178165e-01, -3.612979e-01, -1.605856e-01,  9.298011e-01},
  {-7.031646e-01, -2.612345e-01,  6.612988e-01, -7.106108e-01, -2.500348e-01,  6.733223e-01},
  {-7.232003e-01, -1.938438e-01,  6.628768e-01, -7.282709e-01, -2.020101e-01,  6.718310e-01},
  { 9.259185e-01, -2.486800e-01,  2.843117e-01,  9.327561e-01, -2.616376e-01,  2.870342e-01},
  { 9.157895e-01, -2.758487e-01,  2.919537e-01,  9.267967e-01, -2.699514e-01,  2.984139e-01},
  {-4.057842e-01, -1.893298e-01,  8.941439e-01, -4.120844e-01, -1.955083e-01,  9.015630e-01},
  {-7.595862e-01, -1.936057e-01,  6.209232e-01, -7.650428e-01, -1.913485e-01,  6.316195e-01},
  {-4.757159e-01, -1.007069e-01,  8.738149e-01, -4.762280e-01, -9.625560e-02,  8.858864e-01},
  {-7.994899e-01, -1.733340e-01,  5.751272e-01, -8.023841e-01, -1.756018e-01,  5.883802e-01},
  { 8.646669e-01, -2.973526e-01,  4.048860e-01,  8.688803e-01, -3.130005e-01,  4.098202e-01},
  {-4.827047e-01, -1.596129e-01,  8.611155e-01, -4.955584e-01, -1.438654e-01,  8.686638e-01},
  {-5.154512e-01, -1.097558e-01,  8.498610e-01, -5.144219e-01, -1.140348e-01,  8.621011e-01},
  { 9.490799e-01, -2.462353e-01,  1.965080e-01,  9.548496e-01, -2.508947e-01,  2.149226e-01},
  {-8.579559e-01, -1.346453e-01,  4.957644e-01, -8.691533e-01, -1.409818e-01,  4.955238e-01},
  { 9.613902e-01, -2.418669e-01,  1.312604e-01,  9.753857e-01, -2.321993e-01,  1.248385e-01},
  {-9.002967e-01,  3.013100e-02,  4.342326e-01, -9.137390e-01,  2.178707e-02,  4.306445e-01},
  { 8.796881e-01,  1.911635e-01, -4.354369e-01,  8.914643e-01,  1.887361e-01, -4.365248e-01},
  { 9.507270e-01,  3.219074e-02, -3.083536e-01,  9.645249e-01,  4.276681e-02, -2.979019e-01},
  {-9.403371e-01,  6.344858e-02,  3.342762e-01, -9.493293e-01,  5.213197e-02,  3.419130e-01},
  {-9.209521e-01,  6.692696e-02,  3.838854e-01, -9.302994e-01,  7.351683e-02,  3.872817e-01},
  {-9.260176e-01,  3.726927e-01,  5.992969e-02, -9.331882e-01,  3.813499e-01,  6.771568e-02},
  {-9.281961e-01,  3.603202e-01,  9.285135e-02, -9.371736e-01,  3.633387e-01,  1.026815e-01},
  { 9.655959e-01, -1.338781e-02, -2.597025e-01,  9.761212e-01, -1.219007e-02, -2.606164e-01},
  {-9.402209e-01,  3.178217e-01,  1.223687e-01, -9.501405e-01,  3.188970e-01,  1.280224e-01},
  {-9.406079e-01,  1.266962e-01,  3.149681e-01, -9.467802e-01,  1.271388e-01,  3.290781e-01},
  {-9.369975e-01,  1.208166e-01,  3.277788e-01, -9.457679e-01,  1.274261e-01,  3.318661e-01},
  {-9.344464e-01,  1.251058e-01,  3.334043e-01, -9.452839e-01,  1.268483e-01,  3.334626e-01},
  {-9.470992e-01,  1.708154e-01,  2.717080e-01, -9.631884e-01,  1.674679e-01,  2.550929e-01},
  { 7.835148e-01,  2.907021e-01, -5.491782e-01,  7.942092e-01,  2.907826e-01, -5.527754e-01},
  { 7.658235e-01,  3.152762e-01, -5.604599e-01,  7.771432e-01,  3.131860e-01, -5.648400e-01},
  {-9.498004e-01,  4.627857e-02, -3.094148e-01, -9.569087e-01,  4.834839e-02, -3.206845e-01},
  {-9.108866e-01,  3.808097e-01, -1.589641e-01, -9.139796e-01,  4.044149e-01, -1.557294e-01},
  { 7.395968e-01,  3.416711e-01, -5.798771e-01,  7.408569e-01,  3.444061e-01, -5.944737e-01},
  {-8.863195e-01,  4.488229e-01, -1.139983e-01, -8.941584e-01,  4.565567e-01, -1.135432e-01},
  {-8.947840e-01,  4.269042e-01, -1.308218e-01, -9.087303e-01,  4.184804e-01, -1.491038e-01},
  {-9.378093e-01,  1.221519e-02, -3.469358e-01, -9.468959e-01,  1.866836e-02, -3.519800e-01},
  { 7.025529e-01,  3.710782e-01, -6.072235e-01,  7.154252e-01,  3.693422e-01, -6.104395e-01},
  {-9.420527e-01,  1.919289e-01, -2.751361e-01, -9.513813e-01,  1.969876e-01, -2.773474e-01},
  {-9.321069e-01,  2.823787e-01, -2.268020e-01, -9.445164e-01,  2.754721e-01, -2.299064e-01},
  {-9.392186e-01,  2.210309e-01, -2.627046e-01, -9.483691e-01,  2.286556e-01, -2.629923e-01},
  {-8.661835e-01, -1.136881e-01, -4.866222e-01, -8.837140e-01, -8.973150e-02, -4.815063e-01},
  { 6.747255e-01,  4.052270e-01, -6.168765e-01,  6.788940e-01,  4.190694e-01, -6.199734e-01},
  { 3.934842e-01,  2.970142e-01, -8.700303e-01,  4.043126e-01,  2.979785e-01, -8.767087e-01},
  {-7.496859e-01, -3.475672e-02, -6.608805e-01, -7.598466e-01, -4.953093e-02, -6.641036e-01},
  { 4.774798e-01,  3.440426e-01, -8.084849e-01,  3.974378e-01,  3.714390e-01, -8.527059e-01},
  {-6.290618e-01, -1.236666e-01, -7.674554e-01, -6.267420e-01, -1.176613e-01, -7.837129e-01},
  {-5.709282e-01, -9.598572e-02, -8.153697e-01, -5.733035e-01, -9.961491e-02, -8.259884e-01},
  { 4.180751e-01,  4.545709e-01, -7.864977e-01,  4.201538e-01,  4.630762e-01, -7.936694e-01},
  { 5.044016e-01,  5.314342e-01, -6.805562e-01,  4.974025e-01,  5.427635e-01, -6.925067e-01},
  { 3.645136e-01,  1.192053e-01, -9.235367e-01,  3.662413e-01,  1.198918e-01, -9.340069e-01},
  { 3.383159e-01,  1.045760e-01, -9.352039e-01,  3.358018e-01,  1.076753e-01, -9.468465e-01},
  { 2.687489e-01,  5.345163e-02, -9.617260e-01,  2.732903e-01,  4.559618e-02, -9.716516e-01},
  { 2.344312e-01,  2.902213e-02, -9.716994e-01,  2.300202e-01,  2.743691e-02, -9.834685e-01},
  {-2.316970e-01, -4.517676e-02, -9.717384e-01, -2.327555e-01, -4.441082e-02, -9.821997e-01},
  { 1.460060e-01,  8.400369e-03, -9.892481e-01,  1.371891e-01,  1.331817e-02, -1.000936e+00},
  {-2.829046e-01, -5.096598e-02, -9.577931e-01, -2.790749e-01, -4.836439e-02, -9.698665e-01},
  {-3.361169e-01, -3.535264e-02, -9.411566e-01, -3.377051e-01, -2.920815e-02, -9.518215e-01},
  { 6.321043e-01,  7.463844e-01, -2.082178e-01, -3.647605e-01,  6.955070e-03, -9.422119e-01},
  {-3.397997e-01,  1.486029e-02, -9.403803e-01, -3.627112e-01,  5.425711e-03, -9.430128e-01},
  { 3.570382e-01, -7.721008e-03,  9.340578e-01, -3.660083e-01,  8.500041e-03, -9.417153e-01},
  { 4.981992e-01,  8.526250e-01, -1.575693e-01, -3.660306e-01,  8.366812e-03, -9.417078e-01},
  {-3.753342e-01,  3.269423e-02, -9.263127e-01, -3.677828e-01,  8.248012e-03, -9.410259e-01},
  { 5.688345e-01, -2.216999e-01,  7.920079e-01,  5.586880e-01, -2.198754e-01,  8.126450e-01},
  {-3.182293e-02, -1.993593e-01,  9.794096e-01, -2.980313e-02, -2.154630e-01,  9.866846e-01},
  { 3.782533e-01, -2.192466e-01,  8.993639e-01,  3.786086e-01, -1.782174e-01,  9.196524e-01},
  {-9.075154e-02, -2.079033e-01,  9.739304e-01, -8.693446e-02, -2.194001e-01,  9.824276e-01},
  { 7.423382e-02, -1.394488e-01,  9.874429e-01,  7.751797e-02, -1.453898e-01,  9.968522e-01},
  { 6.542360e-01, -2.401903e-01,  7.171358e-01,  6.562588e-01, -2.491061e-01,  7.267335e-01},
  {-2.055176e-01, -9.192438e-02,  9.743266e-01, -2.059667e-01, -9.292413e-02,  9.847843e-01},
  { 8.107534e-01, -3.373959e-01,  4.783753e-01,  7.474614e-01, -2.505277e-01,  6.319891e-01},
  { 1.891667e-01, -1.111683e-01,  9.756319e-01,  1.888545e-01, -1.167102e-01,  9.856858e-01},
  {-3.209317e-01, -4.411667e-02,  9.460743e-01, -3.356640e-01, -3.245595e-02,  9.524349e-01},
  {-3.442359e-01, -6.856474e-02,  9.363763e-01, -3.541520e-01, -7.387319e-02,  9.433845e-01},
  {-3.562222e-01, -1.130947e-01,  9.275319e-01, -3.576708e-01, -1.218477e-01,  9.370588e-01},
  { 8.482314e-01, -2.739659e-01,  4.532616e-01,  8.586748e-01, -2.789689e-01,  4.542050e-01},
  {-4.370511e-01, -8.916755e-02,  8.950059e-01, -4.443961e-01, -1.064653e-01,  9.011274e-01},
  {-4.407694e-01, -1.863949e-01,  8.780543e-01, -4.368730e-01, -1.805295e-01,  8.929746e-01},
  {-7.077935e-01, -1.569025e-01,  6.887742e-01, -7.265051e-01, -1.578376e-01,  6.842340e-01},
  {-7.761899e-01, -1.531596e-01,  6.116138e-01, -7.889407e-01, -1.537666e-01,  6.121898e-01},
  { 9.394686e-01, -2.214640e-01,  2.614433e-01,  9.505826e-01, -2.264770e-01,  2.568631e-01},
  {-4.518871e-01, -1.431697e-01,  8.805115e-01, -4.563721e-01, -1.501235e-01,  8.888420e-01},
  { 8.753638e-01, -3.044531e-01,  3.755615e-01,  8.898486e-01, -2.975982e-01,  3.748069e-01},
  {-6.888908e-01, -1.292594e-01,  7.132470e-01, -6.962109e-01, -1.247841e-01,  7.215046e-01},
  {-8.097267e-01, -1.705041e-01,  5.614901e-01, -8.185695e-01, -1.588082e-01,  5.705886e-01},
  {-8.290273e-01, -1.463598e-01,  5.397153e-01, -8.351979e-01, -1.527247e-01,  5.476925e-01},
  {-5.437166e-01, -1.001837e-01,  8.332679e-01, -5.480682e-01, -1.006910e-01,  8.428134e-01},
  {-6.079805e-01, -9.122957e-02,  7.886931e-01, -6.197278e-01, -9.005616e-02,  7.928922e-01},
  { 9.743305e-01, -1.968765e-01,  1.091768e-01,  9.830417e-01, -2.079702e-01,  1.060958e-01},
  { 9.206653e-01,  1.390930e-01, -3.647311e-01,  9.323459e-01,  1.418213e-01, -3.626314e-01},
  { 9.743240e-01, -2.150232e-01,  6.676611e-02,  9.846431e-01, -2.165882e-01,  6.668288e-02},
  {-8.969579e-01, -4.755167e-02,  4.395515e-01, -9.049290e-01, -4.616068e-02,  4.470127e-01},
  { 9.925175e-01, -1.079204e-01, -5.711567e-02,  1.001887e+00, -1.143875e-01, -6.338643e-02},
  { 9.820259e-01, -1.879011e-01,  1.784262e-02,  9.916204e-01, -1.921598e-01,  2.536259e-02},
  {-8.997850e-01, -5.118639e-03,  4.363035e-01, -9.113095e-01, -9.532531e-03,  4.362020e-01},
  { 9.898921e-01, -9.719969e-02, -1.032756e-01,  1.000945e+00, -1.008158e-01, -9.394540e-02},
  {-8.990765e-01,  7.944557e-02,  4.305229e-01, -9.058659e-01,  8.924166e-02,  4.385112e-01},
  {-9.297426e-01,  2.526540e-01,  2.678521e-01, -9.459415e-01,  2.482420e-01,  2.538141e-01},
  {-9.083849e-01,  1.086957e-01,  4.037598e-01, -9.196540e-01,  9.793752e-02,  4.068097e-01},
  {-9.252918e-01,  3.296573e-01,  1.875128e-01, -9.401897e-01,  3.196490e-01,  1.863327e-01},
  {-9.430597e-01,  2.929592e-01,  1.575219e-01, -9.526119e-01,  2.904364e-01,  1.703788e-01},
  {-9.429912e-01,  2.717886e-01,  1.920901e-01, -9.540274e-01,  2.754686e-01,  1.865477e-01},
  { 9.843795e-01, -8.135822e-02, -1.561339e-01,  9.949438e-01, -7.442215e-02, -1.594672e-01},
  { 9.824601e-01, -6.328534e-02, -1.754054e-01,  9.924827e-01, -6.510697e-02, -1.778230e-01},
  { 8.558550e-01,  2.241342e-01, -4.661287e-01,  8.648709e-01,  2.349714e-01, -4.665517e-01},
  {-9.507027e-01,  2.163830e-01,  2.221322e-01, -9.583607e-01,  2.335521e-01,  2.187440e-01},
  {-9.311624e-01,  1.056573e-01,  3.489601e-01, -9.401211e-01,  1.081515e-01,  3.540125e-01},
  { 9.779959e-01, -6.116036e-02, -1.994579e-01,  9.892138e-01, -5.838314e-02, -1.973053e-01},
  {-8.823588e-01,  4.277845e-01, -1.960696e-01, -8.984907e-01,  4.240475e-01, -1.837208e-01},
  {-9.135853e-01,  3.593194e-01, -1.903981e-01, -9.243219e-01,  3.610068e-01, -1.901508e-01},
  {-9.406407e-01,  1.118105e-01, -3.204580e-01, -9.518499e-01,  1.173287e-01, -3.179103e-01},
  {-9.394384e-01,  1.606468e-01, -3.027342e-01, -9.495061e-01,  1.593663e-01, -3.064185e-01},
  {-8.556694e-01,  4.892445e-01, -1.687295e-01, -8.689154e-01,  4.874491e-01, -1.680346e-01},
  {-8.983855e-01,  4.090312e-01, -1.599905e-01, -8.769671e-01,  4.658788e-01, -1.863912e-01},
  {-9.199150e-01,  5.293018e-03, -3.920819e-01, -9.316415e-01,  8.404508e-04, -3.910164e-01},
  {-9.343464e-01,  2.566885e-01, -2.471999e-01, -9.408956e-01,  2.578452e-01, -2.628388e-01},
  {-8.913143e-01, -5.032780e-02, -4.505838e-01, -9.058756e-01, -4.264737e-02, -4.454449e-01},
  {-8.450805e-01, -6.455375e-02, -5.307276e-01, -8.587754e-01, -7.788305e-02, -5.265837e-01},
  { 6.420830e-01,  4.546232e-01, -6.172902e-01,  6.535372e-01,  4.635170e-01, -6.155684e-01},
  {-7.826408e-01, -3.100110e-02, -6.217011e-01, -7.827109e-01, -2.324790e-02, -6.384957e-01},
  { 3.601905e-01,  3.339962e-01, -8.710393e-01,  3.635344e-01,  3.355693e-01, -8.809732e-01},
  { 4.476105e-01,  4.044511e-01, -7.975363e-01,  4.015947e-01,  4.115114e-01, -8.308184e-01},
  { 4.011772e-01,  1.338097e-01, -9.061742e-01,  3.999407e-01,  1.423125e-01, -9.168811e-01},
  { 4.175913e-01,  1.946250e-01, -8.875464e-01,  4.158894e-01,  1.899935e-01, -9.010081e-01},
  {-5.411726e-01, -8.277857e-02, -8.368273e-01, -5.485911e-01, -8.390298e-02, -8.443137e-01},
  { 2.807426e-01,  8.096708e-02, -9.563618e-01,  2.927468e-01,  7.477330e-02, -9.641485e-01},
  { 3.195174e-01,  1.286691e-01, -9.388039e-01,  3.231896e-01,  1.236930e-01, -9.492753e-01},
  { 6.665055e-02, -3.318720e-03, -9.977708e-01,  6.529327e-02, -2.947378e-03, -1.008265e+00},
  { 4.884351e-01, -1.889565e-01,  8.518958e-01,  4.986367e-01, -1.945663e-01,  8.569561e-01},
  { 5.268337e-01, -1.848625e-01,  8.296217e-01,  5.346012e-01, -1.883867e-01,  8.364098e-01},
  { 4.394264e-01, -1.806960e-01,  8.799168e-01,  4.415466e-01, -1.807967e-01,  8.906271e-01},
  { 3.943891e-01, -1.496883e-01,  9.066701e-01,  3.953436e-01, -1.589723e-01,  9.161322e-01},
  { 1.478409e-02, -2.077273e-01,  9.780750e-01,  1.675264e-02, -2.014372e-01,  9.899506e-01},
  { 6.017978e-01, -2.173442e-01,  7.685056e-01,  6.089478e-01, -2.162145e-01,  7.767266e-01},
  { 6.481476e-01, -2.280381e-01,  7.265696e-01,  6.468144e-01, -2.294408e-01,  7.415248e-01},
  {-1.472575e-01, -1.733839e-01,  9.737830e-01, -1.538425e-01, -1.761154e-01,  9.829410e-01},
  {-1.555920e-01, -1.180373e-01,  9.807438e-01, -1.673899e-01, -1.115904e-01,  9.901444e-01},
  { 2.670092e-01, -1.436873e-01,  9.529218e-01,  2.797107e-01, -1.364022e-01,  9.612604e-01},
  { 7.007478e-01, -2.388247e-01,  6.722465e-01,  7.137793e-01, -2.362099e-01,  6.762416e-01},
  { 3.334191e-01, -2.638236e-01,  9.051126e-01,  2.045168e-01, -1.119920e-01,  9.843676e-01},
  { 8.608568e-01, -2.582295e-01,  4.384553e-01,  7.524248e-01, -2.396154e-01,  6.318334e-01},
  {-2.587276e-01, -4.581218e-02,  9.648634e-01, -2.560893e-01, -3.273826e-02,  9.768335e-01},
  { 7.924480e-01, -2.279630e-01,  5.657375e-01,  8.083048e-01, -2.452732e-01,  5.543992e-01},
  {-1.972533e-01, -3.832207e-02,  9.796032e-01, -2.038414e-01, -4.271201e-02,  9.886770e-01},
  {-3.753907e-01, -2.509291e-02,  9.265270e-01, -3.805225e-01, -3.080951e-02,  9.354723e-01},
  {-4.048259e-01, -1.305308e-01,  9.050291e-01, -4.120826e-01, -1.255528e-01,  9.139355e-01},
  {-4.097967e-01, -6.680090e-02,  9.097276e-01, -4.180875e-01, -5.326916e-02,  9.182699e-01},
  { 9.042122e-01, -2.486676e-01,  3.472243e-01,  9.141106e-01, -2.536785e-01,  3.477434e-01},
  { 9.585130e-01, -2.010258e-01,  2.020928e-01,  9.687647e-01, -2.069380e-01,  1.988718e-01},
  {-6.673391e-01, -8.945818e-02,  7.393618e-01, -6.697981e-01, -8.309662e-02,  7.518749e-01},
  {-6.340679e-01, -6.748883e-02,  7.703267e-01, -6.465342e-01, -7.640287e-02,  7.726622e-01},
  { 9.644237e-01, -2.085177e-01,  1.625035e-01,  9.731036e-01, -2.127662e-01,  1.693472e-01},
  {-8.751410e-01, -9.024151e-02,  4.753786e-01, -8.893769e-01, -8.901010e-02,  4.710978e-01},
  { 9.371978e-01,  1.416298e-01, -3.187494e-01,  9.459850e-01,  1.387286e-01, -3.267270e-01},
  { 9.863237e-01, -1.607153e-01,  3.655491e-02,  9.970182e-01, -1.588656e-01,  3.995420e-02},
  { 9.893945e-01, -1.444163e-01, -1.556953e-02,  9.998084e-01, -1.452400e-01, -1.299934e-02},
  { 9.449205e-01,  9.573611e-02, -3.129854e-01,  9.604099e-01,  1.020000e-01, -2.968035e-01},
  {-9.228774e-01,  3.548860e-01,  1.495095e-01, -9.326747e-01,  3.592730e-01,  1.479646e-01},
  {-9.255235e-01,  1.968871e-01,  3.234837e-01, -9.316204e-01,  1.988502e-01,  3.367379e-01},
  { 9.734178e-01,  2.916933e-02, -2.271719e-01,  9.819657e-01,  2.899691e-02, -2.361892e-01},
  {-9.064898e-01,  4.168099e-01,  6.742286e-02, -9.145793e-01,  4.222097e-01,  7.834302e-02},
  {-9.348184e-01,  2.150198e-01,  2.826321e-01, -9.452732e-01,  2.122268e-01,  2.868256e-01},
  {-9.250265e-01,  1.621438e-01,  3.435629e-01, -9.345379e-01,  1.641786e-01,  3.471804e-01},
  { 9.748523e-01, -2.856281e-02, -2.210140e-01,  9.875113e-01, -2.569444e-02, -2.122343e-01},
  { 8.236541e-01,  3.079193e-01, -4.762138e-01,  8.345448e-01,  3.125966e-01, -4.761329e-01},
  { 8.416614e-01,  2.844182e-01, -4.590341e-01,  8.498779e-01,  2.845086e-01, -4.665261e-01},
  {-8.853600e-01,  4.644463e-01, -2.067127e-02, -9.006459e-01,  4.572668e-01, -2.447489e-02},
  { 7.572067e-01,  3.767070e-01, -5.336007e-01,  7.638834e-01,  3.739818e-01, -5.454390e-01},
  {-9.204540e-01,  3.241967e-01, -2.183138e-01, -9.263607e-01,  3.327475e-01, -2.280104e-01},
  {-9.045711e-01, -1.353984e-02, -4.261077e-01, -9.089652e-01, -1.449372e-02, -4.409343e-01},
  { 6.782207e-01,  4.446961e-01, -5.850317e-01,  6.815798e-01,  4.463696e-01, -5.990047e-01},
  {-8.682277e-01, -5.269730e-02, -4.933595e-01, -8.754742e-01, -6.410240e-02, -5.002868e-01},
  { 5.665069e-01,  5.186095e-01, -6.404015e-01,  5.669544e-01,  5.377364e-01, -6.405350e-01},
  { 3.345052e-01,  3.214723e-01, -8.858678e-01,  3.401574e-01,  3.125058e-01, -8.986158e-01},
  {-7.255010e-01, -4.589507e-02, -6.866892e-01, -7.347289e-01, -3.767257e-02, -6.925377e-01},
  {-6.149703e-01, -7.505749e-02, -7.849699e-01, -6.267312e-01, -8.695595e-02, -7.877198e-01},
  { 5.102721e-01,  5.571377e-01, -6.551488e-01,  5.200725e-01,  5.552305e-01, -6.649255e-01},
  { 3.869443e-01,  4.427981e-01, -8.088287e-01,  3.953880e-01,  4.517958e-01, -8.126674e-01},
  {-5.167202e-01, -6.271133e-02, -8.538545e-01, -5.189248e-01, -6.181287e-02, -8.647280e-01},
  { 1.999866e-01,  4.310372e-02, -9.788501e-01,  1.933993e-01,  4.288753e-02, -9.907721e-01},
  { 4.245556e-01,  5.420178e-01, -7.252374e-01,  4.317966e-01,  5.493333e-01, -7.298394e-01},
  { 4.177454e-01,  4.059977e-01, -8.128067e-01,  4.158624e-01,  5.100803e-01, -7.666531e-01},
  {-1.616277e-01, -1.085689e-02, -9.867921e-01, -1.626281e-01, -1.255577e-02, -9.971257e-01},
  {-4.920812e-01, -3.134385e-02, -8.699849e-01, -4.869224e-01, -4.377535e-02, -8.842226e-01},
  { 9.457324e-02,  2.933158e-02, -9.950857e-01,  1.040978e-01,  3.008029e-02, -1.004554e+00},
  {-2.683194e-01, -2.455625e-03, -9.633269e-01, -2.785348e-01, -1.050206e-02, -9.711701e-01},
  {-4.214813e-01, -1.055470e-02, -9.067757e-01, -4.097983e-01,  8.935766e-03, -9.234970e-01},
  { 5.751022e-01, -1.646187e-01,  8.013477e-01,  5.867605e-01, -1.845751e-01,  8.015699e-01},
  { 5.963122e-01, -1.885205e-01,  7.803024e-01,  6.002241e-01, -1.915450e-01,  7.898810e-01},
  { 2.674839e-02, -1.680382e-01,  9.854175e-01,  3.221158e-02, -1.659569e-01,  9.961331e-01},
  { 2.844252e-01, -1.153834e-01,  9.517294e-01,  3.459085e-01, -1.425376e-01,  9.385609e-01},
  { 4.947514e-02, -1.006011e-01,  9.936960e-01,  4.995808e-02, -1.098110e-01,  1.003149e+00},
  { 2.460015e-01, -1.281903e-01,  9.607552e-01,  2.411878e-01, -1.097825e-01,  9.750081e-01},
  { 4.365292e-01, -2.979677e-01,  8.489155e-01,  2.092170e-01, -1.088512e-01,  9.824682e-01},
  {-1.555398e-01, -7.340472e-02,  9.850985e-01, -1.573046e-01, -7.867107e-02,  9.949494e-01},
  { 9.305481e-02, -7.412388e-02,  9.928980e-01,  1.014095e-01, -8.573633e-02,  1.001613e+00},
  {-2.874311e-01, -1.501035e-02,  9.576837e-01, -2.835494e-01, -1.361672e-02,  9.696758e-01},
  {-1.739290e-01, -4.341938e-02,  9.838005e-01, -1.757961e-01, -5.179095e-02,  9.936154e-01},
  { 8.316163e-01, -2.469723e-01,  4.974123e-01,  8.455757e-01, -2.404137e-01,  4.980742e-01},
  { 9.000089e-01, -2.194124e-01,  3.766194e-01,  9.025561e-01, -2.289313e-01,  3.922492e-01},
  { 9.207530e-01, -2.195769e-01,  3.224900e-01,  9.326741e-01, -2.178697e-01,  3.217596e-01},
  { 8.752081e-01, -2.484586e-01,  4.150653e-01,  8.841178e-01, -2.597252e-01,  4.144325e-01},
  {-4.580374e-01, -3.851314e-02,  8.880982e-01, -4.628696e-01, -3.098418e-02,  8.988406e-01},
  {-7.475994e-01, -1.412441e-01,  6.489570e-01, -7.559745e-01, -1.368141e-01,  6.562263e-01},
  {-7.218603e-01, -1.080545e-01,  6.835510e-01, -7.244903e-01, -1.115760e-01,  6.953516e-01},
  {-8.000839e-01, -1.210118e-01,  5.875559e-01, -8.076010e-01, -1.229775e-01,  5.945630e-01},
  {-5.066497e-01, -5.432557e-02,  8.604388e-01, -5.116955e-01, -5.421789e-02,  8.695292e-01},
  {-8.442421e-01, -1.041519e-01,  5.257449e-01, -8.473712e-01, -1.133014e-01,  5.384910e-01},
  { 9.758490e-01, -1.755680e-01,  1.299796e-01,  9.858224e-01, -1.689987e-01,  1.430837e-01},
  { 9.846361e-01, -1.578175e-01,  7.473463e-02,  9.962676e-01, -1.569354e-01,  6.084602e-02},
  { 9.155840e-01,  1.808772e-01, -3.591511e-01,  9.213850e-01,  1.921473e-01, -3.674414e-01},
  { 9.949397e-01, -9.593567e-02, -2.985377e-02,  1.004740e+00, -1.041666e-01, -2.298156e-02},
  { 8.924321e-01,  2.129239e-01, -3.977793e-01,  9.031399e-01,  2.125966e-01, -4.000312e-01},
  {-8.801773e-01,  8.449744e-02,  4.670633e-01, -8.886759e-01,  1.020678e-01,  4.697731e-01},
  {-9.269043e-01,  2.996985e-01,  2.258965e-01, -9.323093e-01,  3.087574e-01,  2.373186e-01},
  { 9.688608e-01,  5.662470e-02, -2.410441e-01,  9.795731e-01,  5.562652e-02, -2.412991e-01},
  { 8.627589e-01,  2.493797e-01, -4.398373e-01,  8.709842e-01,  2.573982e-01, -4.427378e-01},
  {-8.996577e-01,  4.360947e-01,  2.091534e-02, -9.016852e-01,  4.555316e-01,  1.759527e-02},
  { 8.018559e-01,  3.483535e-01, -4.854656e-01,  8.087087e-01,  3.611449e-01, -4.862602e-01},
  {-8.742828e-01,  4.810398e-01, -6.504041e-02, -8.783128e-01,  4.949071e-01, -6.700399e-02},
  { 7.283613e-01,  3.936352e-01, -5.608398e-01,  7.448831e-01,  3.941565e-01, -5.573812e-01},
  {-8.530069e-01,  5.090844e-01, -1.149447e-01, -8.630925e-01,  5.125037e-01, -1.151860e-01},
  {-8.904167e-01,  3.907034e-01, -2.334716e-01, -9.012775e-01,  3.928968e-01, -2.327789e-01},
  {-9.303320e-01,  7.556022e-02, -3.588496e-01, -9.425130e-01,  8.056512e-02, -3.550065e-01},
  {-9.239902e-01,  2.184081e-01, -3.139108e-01, -9.330066e-01,  2.179129e-01, -3.207263e-01},
  {-9.214329e-01,  5.626895e-02, -3.844414e-01, -9.353414e-01,  4.300214e-02, -3.796554e-01},
  {-9.015374e-01,  3.851503e-01, -1.972046e-01, -8.777776e-01,  4.461604e-01, -2.313416e-01},
  {-9.193013e-01,  2.552478e-01, -2.995558e-01, -9.267149e-01,  2.658844e-01, -3.022552e-01},
  {-8.246101e-01,  5.269145e-01, -2.058625e-01, -8.291903e-01,  5.389849e-01, -2.068735e-01},
  {-8.404431e-01,  4.929436e-01, -2.250824e-01, -8.485022e-01,  4.933491e-01, -2.398079e-01},
  {-8.179480e-01,  5.143280e-01, -2.577359e-01, -8.304546e-01,  5.100634e-01, -2.665294e-01},
  { 6.048233e-01,  4.989527e-01, -6.206730e-01,  6.376530e-01,  4.954154e-01, -6.073267e-01},
  {-8.232082e-01, -2.542466e-02, -5.671701e-01, -8.396283e-01, -2.100157e-02, -5.616364e-01},
  {-7.679530e-01,  6.413710e-03, -6.404741e-01, -7.786985e-01,  2.624244e-03, -6.437978e-01},
  {-6.571613e-01, -9.639951e-02, -7.475601e-01, -6.719100e-01, -8.217371e-02, -7.500930e-01},
  { 3.489839e-01,  3.800177e-01, -8.566194e-01,  3.445524e-01,  3.886929e-01, -8.666484e-01},
  { 3.231578e-01,  4.250019e-01, -8.455426e-01,  3.299731e-01,  4.219270e-01, -8.567226e-01},
  {-6.962560e-01, -4.059007e-02, -7.166450e-01, -7.043069e-01, -4.307815e-02, -7.231535e-01},
  { 3.616739e-01,  4.304393e-01, -8.269910e-01,  3.636286e-01,  4.444954e-01, -8.313104e-01},
  { 3.834890e-01,  2.383677e-01, -8.922539e-01,  3.844862e-01,  2.375117e-01, -9.036790e-01},
  { 3.881692e-01,  3.271997e-01, -8.615481e-01,  3.445359e-01,  2.717649e-01, -9.101185e-01},
  { 3.708304e-01,  1.904328e-01, -9.089665e-01,  3.730149e-01,  1.841581e-01, -9.207726e-01},
  { 3.364047e-01,  1.719613e-01, -9.258840e-01,  3.420180e-01,  1.820415e-01, -9.331455e-01},
  { 2.792110e-01,  1.296217e-01, -9.514407e-01,  2.929240e-01,  1.338145e-01, -9.576867e-01},
  { 2.967250e-01,  1.718905e-01, -9.393657e-01,  3.080033e-01,  1.786678e-01, -9.455618e-01},
  {-1.001268e-01,  3.284389e-03, -9.949693e-01, -1.134790e-01,  6.551071e-03, -1.003965e+00},
  {-3.583182e-02,  1.033233e-02, -9.993044e-01, -2.089642e-02,  2.216147e-02, -1.009921e+00},
  { 3.212342e-02,  2.543071e-02, -9.991603e-01,  2.557127e-02,  2.244293e-02, -1.009808e+00},
  {-3.095824e-01,  2.221567e-02, -9.506131e-01, -3.083624e-01,  3.291392e-02, -9.616094e-01},
  {-3.328605e-01,  4.317842e-02, -9.419870e-01, -3.413419e-01,  3.961927e-02, -9.501467e-01},
  { 3.363881e-01, -7.094128e-02,  9.390476e-01,  3.363790e-01, -7.682508e-02,  9.496388e-01},
  { 2.938213e-01, -8.283066e-02,  9.522647e-01,  3.609187e-01, -1.095134e-01,  9.373428e-01},
  { 2.927895e-01, -9.418689e-02,  9.515267e-01,  3.043723e-01, -1.104022e-01,  9.570970e-01},
  { 6.590891e-01, -2.003329e-01,  7.248919e-01,  6.639642e-01, -2.046931e-01,  7.335693e-01},
  { 2.799380e-01, -1.389506e-01,  9.499092e-01,  2.200166e-01, -1.013511e-01,  9.809103e-01},
  { 1.440054e-01, -7.934989e-02,  9.863904e-01,  1.432037e-01, -7.806990e-02,  9.971265e-01},
  { 7.693611e-01, -2.084698e-01,  6.038408e-01,  7.772409e-01, -2.162384e-01,  6.082855e-01},
  { 5.590816e-03, -7.356374e-02,  9.972749e-01,  1.192188e-02, -6.565636e-02,  1.008171e+00},
  {-3.335823e-01,  7.340861e-03,  9.426924e-01, -3.381682e-01, -1.934483e-03,  9.521001e-01},
  {-1.327647e-01, -2.379202e-02,  9.908620e-01, -1.365680e-01, -1.782608e-02,  1.000945e+00},
  { 8.551177e-01, -2.177373e-01,  4.704933e-01,  8.572819e-01, -2.261882e-01,  4.845434e-01},
  {-2.011323e-01, -5.447849e-03,  9.795489e-01, -2.011082e-01, -3.401705e-03,  9.901527e-01},
  { 9.166241e-01, -1.869512e-01,  3.533403e-01,  9.255507e-01, -1.865407e-01,  3.597721e-01},
  {-4.311209e-01, -2.676646e-03,  9.022902e-01, -4.284576e-01, -2.804702e-03,  9.150251e-01},
  { 8.866123e-01, -2.062043e-01,  4.140029e-01,  8.987803e-01, -2.098636e-01,  4.111298e-01},
  { 9.403028e-01, -1.598439e-01,  3.004672e-01,  9.467633e-01, -1.766323e-01,  3.054805e-01},
  { 9.613863e-01, -1.652653e-01,  2.200540e-01,  9.697736e-01, -1.702314e-01,  2.268023e-01},
  {-5.384779e-01, -5.360256e-02,  8.409330e-01, -5.372139e-01, -4.794227e-02,  8.543742e-01},
  {-7.064763e-01, -5.652364e-02,  7.054760e-01, -7.094353e-01, -6.261341e-02,  7.166806e-01},
  {-8.255926e-01, -7.285917e-02,  5.595431e-01, -8.380038e-01, -8.176320e-02,  5.584913e-01},
  {-5.852272e-01, -4.108077e-02,  8.098280e-01, -5.959835e-01, -4.848319e-02,  8.144352e-01},
  {-8.555678e-01, -3.736956e-02,  5.163402e-01, -8.584242e-01, -4.304896e-02,  5.311337e-01},
  { 9.825658e-01, -1.379551e-01,  1.246306e-01,  9.929599e-01, -1.478789e-01,  1.142031e-01},
  {-8.699374e-01, -5.775715e-02,  4.897683e-01, -8.809196e-01, -5.871057e-02,  4.913060e-01},
  { 9.982483e-01, -5.588063e-02, -1.943727e-02,  1.008349e+00, -5.833697e-02, -2.667282e-02},
  { 9.925477e-01, -1.173804e-01,  3.272478e-02,  1.003762e+00, -1.130942e-01,  2.350325e-02},
  {-8.728541e-01, -3.375233e-03,  4.879698e-01, -8.853304e-01,  6.030524e-03,  4.868287e-01},
  {-8.832950e-01,  3.730157e-02,  4.673313e-01, -8.854839e-01,  3.648284e-02,  4.852176e-01},
  { 9.626903e-01,  9.028971e-02, -2.550982e-01,  9.735897e-01,  9.334704e-02, -2.535604e-01},
  {-9.168959e-01,  2.636738e-01,  2.996296e-01, -9.235983e-01,  2.747543e-01,  3.038546e-01},
  {-9.025270e-01,  1.939164e-01,  3.845016e-01, -9.137931e-01,  1.912458e-01,  3.863388e-01},
  {-8.988613e-01,  1.498606e-01,  4.118133e-01, -9.108750e-01,  1.572207e-01,  4.079687e-01},
  { 9.947797e-01, -6.347042e-02, -7.990512e-02,  1.004892e+00, -4.969482e-02, -9.275946e-02},
  { 9.787742e-01,  4.299198e-02, -2.003811e-01,  9.868186e-01,  5.057927e-02, -2.109832e-01},
  {-8.996649e-01,  4.193575e-01,  1.214182e-01, -9.102722e-01,  4.240220e-01,  1.116415e-01},
  { 9.899131e-01, -4.681185e-02, -1.337189e-01,  1.000918e+00, -2.973824e-02, -1.347660e-01},
  { 9.838019e-01, -8.426607e-03, -1.790612e-01,  9.952708e-01, -6.478045e-03, -1.740011e-01},
  {-9.206226e-01,  1.798510e-01, -3.465655e-01, -9.245343e-01,  1.836428e-01, -3.638189e-01},
  {-9.113495e-01,  2.362342e-01, -3.370988e-01, -9.182586e-01,  2.345174e-01, -3.502228e-01},
  {-9.256983e-01,  1.426778e-01, -3.503223e-01, -9.366064e-01,  1.389343e-01, -3.525870e-01},
  {-8.308415e-01,  5.363064e-01, -1.485862e-01, -8.429121e-01,  5.343618e-01, -1.575243e-01},
  {-9.093537e-01,  2.950126e-01, -2.933317e-01, -9.201157e-01,  2.963582e-01, -2.939603e-01},
  {-9.089633e-01,  3.199612e-01, -2.672278e-01, -9.164479e-01,  3.305327e-01, -2.678162e-01},
  {-7.958792e-01,  5.429935e-01, -2.678327e-01, -8.026704e-01,  5.490535e-01, -2.740782e-01},
  {-8.507288e-01, -1.298102e-02, -5.254447e-01, -8.558894e-01, -1.043274e-02, -5.368395e-01},
  { 5.356089e-01,  5.611963e-01, -6.310165e-01,  5.397760e-01,  5.646252e-01, -6.415082e-01},
  { 3.048998e-01,  3.807006e-01, -8.729852e-01,  3.102586e-01,  3.871607e-01, -8.801839e-01},
  { 3.623709e-01,  4.710298e-01, -8.042502e-01,  3.660238e-01,  4.742827e-01, -8.136103e-01},
  { 4.026791e-01,  4.342999e-01, -8.057500e-01,  3.153642e-01,  2.916082e-01, -9.145418e-01},
  { 4.264036e-01,  4.790702e-01, -7.672494e-01,  3.104415e-01,  2.950497e-01, -9.151221e-01},
  { 2.907746e-01,  3.188983e-01, -9.020832e-01,  3.053086e-01,  3.000806e-01, -9.152130e-01},
  { 3.417704e-01,  2.186638e-01, -9.139908e-01,  3.453645e-01,  2.192014e-01, -9.238780e-01},
  { 2.347120e-01,  9.095939e-02, -9.678000e-01,  2.348111e-01,  9.276039e-02, -9.783314e-01},
  { 4.711082e-01,  5.726780e-01, -6.708926e-01,  4.798335e-01,  5.692576e-01, -6.830721e-01},
  { 1.360765e-01,  6.140044e-02, -9.887938e-01,  1.391812e-01,  6.592692e-02, -9.985758e-01},
  {-1.984001e-01,  1.146499e-02, -9.800541e-01, -2.055583e-01,  2.739660e-03, -9.892437e-01},
  {-4.728924e-01, -1.064693e-02, -8.810559e-01, -4.870462e-01, -8.756732e-03, -8.851942e-01},
  { 4.844212e-01, -1.556351e-01,  8.608796e-01,  4.807469e-01, -1.497150e-01,  8.759775e-01},
  { 4.352802e-01, -8.514972e-02,  8.962593e-01,  4.465543e-01, -1.330964e-01,  8.965170e-01},
  { 2.976928e-01, -5.310414e-02,  9.531836e-01,  3.021068e-01, -6.048689e-02,  9.622573e-01},
  {-1.011149e-01, -1.460035e-01,  9.841030e-01, -9.943927e-02, -1.567315e-01,  9.931794e-01},
  { 8.602565e-03, -1.292123e-01,  9.915797e-01,  1.295328e-03, -1.359130e-01,  1.001192e+00},
  {-1.241899e-01, -8.097018e-02,  9.889492e-01, -1.274972e-01, -9.312230e-02,  9.979635e-01},
  { 7.765757e-01, -1.892120e-01,  6.009401e-01,  7.514018e-01, -2.066998e-01,  6.430737e-01},
  {-5.023801e-02, -5.657010e-02,  9.971339e-01, -5.303894e-02, -5.458828e-02,  1.007505e+00},
  { 8.284979e-01, -2.033489e-01,  5.217666e-01,  8.330671e-01, -2.065687e-01,  5.331076e-01},
  {-2.081664e-02, -2.362214e-02,  9.995042e-01, -2.999540e-02, -3.747563e-02,  1.009236e+00},
  {-8.729539e-02, -4.105240e-02,  9.953363e-01, -8.608481e-02, -4.077334e-02,  1.005876e+00},
  { 2.377190e-02, -2.078148e-02,  9.995014e-01,  1.896956e-02, -2.727796e-02,  1.009831e+00},
  {-2.436942e-01,  1.136380e-02,  9.697856e-01, -2.432986e-01,  9.268272e-03,  9.806007e-01},
  {-1.025964e-01, -1.321375e-03,  9.947222e-01, -9.713538e-02, -1.908531e-02,  1.005515e+00},
  {-7.593886e-01, -1.005730e-01,  6.428174e-01, -7.650667e-01, -1.042250e-01,  6.516586e-01},
  {-7.988828e-01, -6.461804e-02,  5.980056e-01, -8.001078e-01, -8.102492e-02,  6.116462e-01},
  { 9.517790e-01, -1.605975e-01,  2.613909e-01,  9.643471e-01, -1.603125e-01,  2.553689e-01},
  {-8.135881e-01, -3.018295e-02,  5.806578e-01, -8.224781e-01, -2.065216e-02,  5.864744e-01},
  { 9.732026e-01, -1.514817e-01,  1.730026e-01,  9.840847e-01, -1.454200e-01,  1.769457e-01},
  {-6.544942e-01, -3.478728e-02,  7.552663e-01, -6.670893e-01, -4.067466e-02,  7.577521e-01},
  {-6.850840e-01, -2.761638e-02,  7.279404e-01, -6.945001e-01, -3.235637e-02,  7.331256e-01},
  {-8.392951e-01, -1.841529e-02,  5.433640e-01, -8.492010e-01, -1.939456e-02,  5.471107e-01},
  { 9.935322e-01, -1.026188e-01,  4.861226e-02,  1.004247e+00, -9.623471e-02,  5.574955e-02},
  { 9.310101e-01,  1.860292e-01, -3.140276e-01,  9.426700e-01,  1.873130e-01, -3.117229e-01},
  { 9.071245e-01,  2.214771e-01, -3.578729e-01,  9.194497e-01,  2.180904e-01, -3.576773e-01},
  { 9.539868e-01,  1.354297e-01, -2.675220e-01,  9.614165e-01,  1.400310e-01, -2.774047e-01},
  {-9.013596e-01,  2.210529e-01,  3.724064e-01, -9.137773e-01,  2.275017e-01,  3.662035e-01},
  { 9.960237e-01, -1.690963e-02, -8.746967e-02,  1.005412e+00, -3.137372e-02, -9.509675e-02},
  {-8.846549e-01,  4.592322e-01,  8.056983e-02, -8.975138e-01,  4.563359e-01,  8.415040e-02},
  { 8.307817e-01,  3.409793e-01, -4.399261e-01,  8.367484e-01,  3.441521e-01, -4.497733e-01},
  { 8.536984e-01,  3.055122e-01, -4.217360e-01,  8.646940e-01,  2.980451e-01, -4.293692e-01},
  {-8.806068e-01,  4.720118e-01,  4.167150e-02, -8.840123e-01,  4.873221e-01,  4.352864e-02},
  { 7.742397e-01,  3.968113e-01, -4.930453e-01,  7.916759e-01,  3.959657e-01, -4.871806e-01},
  {-8.460495e-01,  5.290827e-01, -6.535960e-02, -8.563968e-01,  5.306512e-01, -7.648857e-02},
  {-8.919723e-01,  3.844282e-01, -2.379082e-01, -8.791810e-01,  4.265201e-01, -2.568598e-01},
  {-8.984731e-01,  2.843245e-01, -3.345229e-01, -9.075209e-01,  2.755147e-01, -3.483551e-01},
  {-8.994964e-01,  3.606975e-01, -2.465839e-01, -9.070292e-01,  3.645912e-01, -2.553934e-01},
  {-8.376313e-01,  4.661139e-01, -2.848009e-01, -8.480545e-01,  4.724872e-01, -2.800290e-01},
  { 6.623560e-01,  4.883721e-01, -5.681348e-01,  6.722137e-01,  4.819779e-01, -5.802671e-01},
  {-7.959481e-01,  5.607048e-01, -2.282031e-01, -8.062865e-01,  5.697213e-01, -2.148912e-01},
  {-9.021464e-01,  3.738274e-02, -4.298075e-01, -9.109787e-01,  4.865867e-02, -4.342830e-01},
  {-8.090593e-01,  5.025066e-01, -3.048117e-01, -8.084607e-01,  5.238649e-01, -3.046556e-01},
  {-7.804726e-01,  5.388107e-01, -3.170893e-01, -7.901886e-01,  5.484963e-01, -3.092131e-01},
  {-7.666370e-01,  5.783019e-01, -2.789883e-01, -7.805643e-01,  5.719420e-01, -2.906216e-01},
  {-8.079771e-01,  1.290697e-02, -5.890726e-01, -8.161224e-01,  2.085388e-02, -5.952836e-01},
  {-7.442056e-01,  1.448653e-02, -6.677935e-01, -7.517079e-01,  2.423777e-02, -6.746869e-01},
  { 3.263464e-01,  4.678353e-01, -8.213575e-01,  3.254534e-01,  4.718793e-01, -8.320388e-01},
  { 3.840798e-01,  4.321958e-01, -8.158979e-01,  3.755151e-01,  5.194035e-01, -7.823445e-01},
  { 2.849858e-01,  2.947111e-01, -9.121011e-01,  2.941424e-01,  3.030730e-01, -9.178798e-01},
  { 4.033633e-01,  3.927556e-01, -8.264630e-01,  3.899680e-01,  5.153331e-01, -7.766832e-01},
  {-5.560724e-01, -4.324486e-02, -8.300080e-01, -5.685183e-01, -3.714014e-02, -8.344252e-01},
  { 1.808916e-01,  9.046212e-02, -9.793339e-01,  1.812766e-01,  7.628416e-02, -9.910558e-01},
  { 4.415250e-01,  5.559976e-01, -7.042176e-01,  4.408076e-01,  5.784182e-01, -7.014288e-01},
  { 2.828688e-01,  2.102613e-01, -9.358287e-01,  2.803957e-01,  2.168370e-01, -9.461687e-01},
  {-4.749957e-01,  1.785561e-02, -8.798069e-01, -4.647763e-01,  1.690941e-02, -8.969712e-01},
  { 8.148674e-02,  6.603761e-02, -9.944842e-01,  7.727470e-02,  6.313635e-02, -1.005442e+00},
  {-6.589704e-02,  4.730687e-02, -9.967043e-01, -6.554247e-02,  4.323633e-02, -1.007324e+00},
  { 3.298563e-01, -3.256637e-02,  9.434692e-01,  3.770035e-01, -5.559400e-02,  9.357592e-01},
  { 5.930945e-01, -1.206183e-01,  7.960466e-01,  5.968587e-01, -1.235736e-01,  8.058289e-01},
  {-3.984065e-02, -1.651186e-01,  9.854687e-01, -4.175136e-02, -1.542513e-01,  9.976586e-01},
  { 2.431275e-01, -6.604109e-02,  9.677436e-01,  2.539697e-01, -6.766789e-02,  9.755951e-01},
  {-4.507522e-02, -1.097284e-01,  9.929391e-01, -4.460003e-02, -1.174140e-01,  1.002539e+00},
  { 2.022326e-01, -6.407530e-02,  9.772391e-01,  1.964086e-01, -7.249938e-02,  9.884492e-01},
  { 6.975108e-01, -1.996779e-01,  6.881914e-01,  7.167305e-01, -1.874965e-01,  6.870337e-01},
  {-8.728205e-02, -9.095257e-02,  9.920229e-01, -9.389886e-02, -8.787160e-02,  1.002158e+00},
  { 7.939458e-01, -1.921698e-01,  5.768195e-01,  7.910751e-01, -1.940596e-01,  5.978423e-01},
  { 5.886774e-02, -4.723743e-02,  9.971475e-01,  6.094707e-02, -3.567921e-02,  1.007906e+00},
  {-2.877323e-01,  3.669113e-02,  9.570078e-01, -3.008190e-01,  2.440650e-02,  9.642454e-01},
  {-3.780400e-01,  3.656201e-02,  9.250669e-01, -3.690366e-01,  3.158590e-02,  9.400374e-01},
  {-2.338405e-01, -3.236091e-02,  9.717363e-01, -1.569170e-01,  2.234016e-02,  9.978664e-01},
  {-5.401302e-02,  7.313958e-03,  9.985135e-01, -5.365136e-02,  2.044506e-02,  1.008744e+00},
  {-2.821425e-02, -1.922588e-01,  9.809386e-01, -1.509724e-01,  2.853337e-02,  9.998884e-01},
  {-7.766678e-01, -7.801004e-02,  6.250613e-01, -7.821685e-01, -7.848901e-02,  6.347446e-01},
  {-5.475523e-01, -1.360129e-02,  8.366609e-01, -5.510533e-01, -1.880668e-02,  8.466636e-01},
  {-7.371359e-01, -6.307498e-02,  6.727943e-01, -7.459114e-01, -6.576946e-02,  6.783362e-01},
  {-7.620248e-01, -4.195288e-02,  6.461873e-01, -7.740434e-01, -3.758819e-02,  6.483003e-01},
  {-7.905160e-01, -2.809704e-02,  6.117964e-01, -7.987345e-01, -1.605618e-02,  6.185585e-01},
  {-6.164138e-01, -2.611167e-02,  7.869894e-01, -6.185352e-01, -1.547597e-02,  7.987655e-01},
  {-7.333186e-01, -1.306420e-02,  6.797596e-01, -7.437702e-01, -3.114384e-03,  6.838467e-01},
  {-7.720736e-01,  1.631513e-02,  6.353237e-01, -7.740217e-01,  5.393288e-03,  6.493928e-01},
  { 9.898341e-01, -1.033097e-01,  9.775232e-02,  1.000160e+00, -9.760181e-02,  1.050424e-01},
  { 9.972247e-01, -6.549293e-02,  3.540426e-02,  1.006769e+00, -7.158668e-02,  4.661700e-02},
  { 9.504868e-01,  1.672398e-01, -2.619270e-01,  9.571982e-01,  1.681110e-01, -2.763954e-01},
  {-8.637496e-01,  4.541504e-02,  5.018708e-01, -8.713760e-01,  4.450221e-02,  5.094826e-01},
  { 9.735783e-01,  9.139315e-02, -2.092667e-01,  9.809143e-01,  1.066708e-01, -2.175132e-01},
  {-9.052141e-01,  2.542250e-01,  3.405247e-01, -9.114868e-01,  2.477678e-01,  3.586840e-01},
  {-8.888248e-01,  1.763723e-01,  4.229460e-01, -8.905200e-01,  1.492640e-01,  4.533701e-01},
  {-8.898476e-01,  3.205225e-01,  3.247100e-01, -8.884735e-01,  1.516076e-01,  4.590457e-01},
  {-8.528742e-01,  2.177649e-02,  5.216622e-01, -8.747314e-01,  1.235648e-01,  4.903332e-01},
  {-8.962077e-01,  2.447858e-01,  3.699887e-01, -8.747144e-01,  1.282604e-01,  4.891564e-01},
  {-8.476608e-01,  7.691617e-02,  5.249335e-01, -8.735546e-01,  1.279910e-01,  4.935339e-01},
  { 9.832979e-01,  5.634473e-02, -1.730626e-01,  9.943073e-01,  5.469837e-02, -1.710089e-01},
  {-9.077217e-01,  3.127522e-01,  2.796917e-01, -9.130049e-01,  3.226610e-01,  2.883819e-01},
  { 8.814967e-01,  2.668743e-01, -3.895404e-01,  8.868875e-01,  2.736453e-01, -3.992910e-01},
  {-8.995397e-01,  3.995207e-01,  1.766677e-01, -9.038402e-01,  4.138726e-01,  1.806548e-01},
  {-9.020742e-01,  3.767692e-01,  2.104925e-01, -9.075932e-01,  3.879168e-01,  2.159829e-01},
  {-8.979579e-01,  3.617963e-01,  2.505496e-01, -9.090754e-01,  3.653513e-01,  2.468873e-01},
  { 9.897046e-01,  1.253104e-02, -1.425750e-01,  9.999488e-01,  1.039796e-02, -1.444884e-01},
  {-8.591882e-01,  5.115756e-01, -9.273708e-03, -8.630849e-01,  5.252963e-01, -2.156342e-03},
  {-9.006853e-01,  2.129835e-01, -3.786871e-01, -9.089968e-01,  2.241018e-01, -3.829505e-01},
  { 7.147493e-01,  4.210322e-01, -5.584490e-01,  7.202580e-01,  4.360382e-01, -5.585544e-01},
  {-9.238771e-01,  1.116528e-01, -3.660394e-01, -9.283000e-01,  1.224087e-01, -3.796408e-01},
  {-7.962787e-01,  5.782934e-01, -1.775305e-01, -8.109392e-01,  5.745245e-01, -1.820924e-01},
  {-8.843144e-01,  7.298314e-02, -4.611525e-01, -8.906487e-01,  7.046609e-02, -4.718387e-01},
  {-8.308040e-01,  2.522378e-02, -5.559932e-01, -8.416447e-01,  2.062214e-02, -5.586249e-01},
  { 3.144145e-01,  3.494010e-01, -8.826451e-01,  2.840321e-01,  3.524316e-01, -9.033242e-01},
  {-6.585656e-01, -3.644640e-02, -7.516403e-01, -6.706305e-01, -3.468486e-02, -7.549221e-01},
  {-7.176674e-01,  1.866480e-02, -6.961359e-01, -7.231479e-01,  2.244248e-02, -7.052721e-01},
  { 3.287614e-01,  5.257505e-01, -7.845396e-01,  3.426857e-01,  5.093805e-01, -8.024819e-01},
  {-5.949733e-01, -1.699975e-02, -8.035656e-01, -6.092477e-01, -3.715276e-02, -8.051669e-01},
  { 3.677882e-01,  5.590354e-01, -7.431092e-01,  3.913738e-01,  5.555116e-01, -7.482079e-01},
  { 3.005603e-01,  2.510609e-01, -9.201260e-01,  3.095463e-01,  2.467589e-01, -9.296060e-01},
  { 2.340363e-01,  1.529084e-01, -9.601281e-01,  2.305730e-01,  1.568668e-01, -9.711347e-01},
  {-5.201049e-01, -1.351414e-02, -8.539955e-01, -5.212491e-01, -1.201767e-03, -8.655385e-01},
  {-2.265994e-01,  3.649313e-02, -9.733042e-01, -2.242340e-01,  3.315052e-02, -9.846243e-01},
  {-4.419860e-01,  3.684236e-02, -8.962650e-01, -4.441129e-01,  3.465959e-02, -9.081386e-01},
  {-1.179802e-02,  6.098997e-02, -9.980687e-01, -6.386065e-03,  6.220032e-02, -1.008444e+00},
  {-3.721001e-01,  4.785852e-02, -9.269579e-01, -3.799756e-01,  5.607332e-02, -9.345248e-01},
  { 6.209700e-01, -1.070169e-01,  7.764944e-01,  6.284807e-01, -1.079749e-01,  7.842312e-01},
  { 6.319656e-01, -1.565846e-01,  7.590130e-01,  6.477438e-01, -1.543206e-01,  7.599243e-01},
  { 1.230806e-01, -3.524221e-02,  9.917707e-01,  1.214274e-01, -3.220475e-02,  1.002538e+00},
  { 8.656389e-01, -3.873555e-03,  5.006539e-01,  7.621777e-01, -1.732762e-01,  6.402612e-01},
  { 2.751895e-02,  1.066003e-02,  9.995645e-01,  3.040785e-02,  9.569910e-03,  1.009874e+00},
  { 9.975752e-03,  4.730865e-02,  9.988305e-01,  1.682707e-03,  2.529401e-02,  1.010059e+00},
  { 9.268403e-01, -1.364373e-01,  3.497883e-01,  9.359517e-01, -1.473170e-01,  3.509564e-01},
  { 8.698769e-01, -1.871614e-01,  4.563822e-01,  8.836266e-01, -1.771567e-01,  4.568325e-01},
  {-4.380756e-01,  1.020612e-01,  8.931255e-01, -1.527086e-01,  4.153536e-02,  9.991681e-01},
  { 9.029478e-01, -1.663834e-01,  3.962345e-01,  9.159239e-01, -1.604167e-01,  3.952560e-01},
  {-4.990562e-01,  1.532990e-02,  8.664339e-01, -5.096704e-01,  2.070382e-02,  8.721590e-01},
  { 9.609287e-01, -1.242978e-01,  2.473176e-01,  9.743084e-01, -1.209766e-01,  2.386781e-01},
  { 9.764001e-01, -1.053732e-01,  1.885192e-01,  9.849328e-01, -1.127844e-01,  1.951073e-01},
  { 9.836103e-01, -1.050952e-01,  1.465117e-01,  9.945835e-01, -9.909183e-02,  1.478671e-01},
  {-8.000129e-01, -2.844592e-04,  5.999826e-01, -8.132453e-01,  5.741616e-03,  5.995402e-01},
  {-8.083632e-01,  1.651731e-02,  5.884524e-01, -8.288533e-01,  1.176900e-02,  5.776789e-01},
  {-6.311001e-01,  5.836045e-03,  7.756795e-01, -6.391146e-01, -2.701866e-03,  7.825451e-01},
  {-7.013870e-01,  2.727019e-02,  7.122588e-01, -7.023790e-01,  2.077558e-02,  7.260048e-01},
  {-7.391278e-01,  2.738849e-02,  6.730082e-01, -7.476283e-01,  2.751404e-02,  6.790768e-01},
  {-8.487231e-01,  2.941996e-02,  5.280185e-01, -8.470064e-01,  2.877839e-02,  5.500918e-01},
  { 9.950857e-01, -6.261501e-02,  7.670721e-02,  1.004692e+00, -6.949710e-02,  8.151264e-02},
  { 9.998817e-01, -7.450501e-03, -1.345955e-02,  1.010254e+00, -9.505402e-03, -1.336276e-02},
  { 9.186333e-01,  2.367640e-01, -3.163157e-01,  9.260262e-01,  2.340974e-01, -3.294819e-01},
  {-8.570278e-01,  7.971805e-02,  5.090663e-01, -8.655763e-01,  8.341074e-02,  5.144609e-01},
  {-8.811116e-01,  1.773075e-01,  4.384114e-01, -8.959665e-01,  1.930059e-01,  4.252569e-01},
  {-8.255845e-01,  1.269643e-01,  5.498093e-01, -8.694495e-01,  1.315927e-01,  4.975852e-01},
  {-8.955134e-01,  3.018440e-01,  3.270259e-01, -9.075028e-01,  2.960701e-01,  3.311088e-01},
  {-8.569394e-01,  2.209292e-02,  5.149434e-01, -8.724096e-01,  1.531741e-01,  4.860963e-01},
  { 8.010324e-01,  3.967191e-01, -4.482868e-01,  8.067884e-01,  3.972026e-01, -4.606596e-01},
  { 7.422411e-01,  4.269513e-01, -5.165179e-01,  7.432774e-01,  4.454080e-01, -5.196488e-01},
  {-9.055578e-01,  1.603423e-01, -3.927536e-01, -9.117212e-01,  1.702359e-01, -4.007955e-01},
  { 7.040144e-01,  4.737636e-01, -5.290669e-01,  7.152240e-01,  4.779761e-01, -5.299790e-01},
  {-8.777338e-01,  2.091893e-01, -4.310720e-01, -8.919926e-01,  1.990259e-01, -4.308031e-01},
  {-8.906847e-01,  3.268071e-01, -3.160345e-01, -8.943435e-01,  3.391335e-01, -3.255655e-01},
  {-8.800464e-01,  3.718317e-01, -2.953972e-01, -8.895566e-01,  3.733844e-01, -3.002135e-01},
  {-9.027458e-01,  8.386115e-02, -4.219209e-01, -9.091014e-01,  7.930049e-02, -4.337028e-01},
  {-8.639125e-01,  6.333063e-02, -4.996442e-01, -8.746189e-01,  6.714148e-02, -5.013843e-01},
  {-7.681307e-01,  5.512933e-01, -3.256547e-01, -7.727535e-01,  5.674140e-01, -3.220297e-01},
  { 5.850212e-01,  5.395786e-01, -6.054792e-01,  6.028658e-01,  5.558724e-01, -5.902899e-01},
  { 5.335435e-01,  5.881524e-01, -6.077896e-01,  5.367483e-01,  5.871812e-01, -6.228984e-01},
  { 2.964693e-01,  4.685329e-01, -8.322158e-01,  3.020331e-01,  4.800022e-01, -8.362130e-01},
  { 3.021273e-01,  3.859259e-01, -8.716538e-01,  2.829351e-01,  3.925290e-01, -8.869869e-01},
  { 3.467900e-01,  5.570264e-01, -7.546245e-01,  3.631455e-01,  5.660467e-01, -7.540534e-01},
  { 3.620980e-01,  5.542337e-01, -7.494732e-01,  3.717161e-01,  5.598100e-01, -7.545330e-01},
  { 4.385295e-01,  5.877076e-01, -6.799203e-01,  4.316983e-01,  5.956096e-01, -6.926522e-01},
  {-5.654962e-01,  1.060513e-02, -8.246827e-01, -5.666845e-01,  6.685348e-04, -8.364964e-01},
  { 1.852090e-01,  1.372292e-01, -9.730703e-01,  1.859894e-01,  1.413849e-01, -9.830011e-01},
  { 1.560268e-01,  1.331836e-01, -9.787328e-01,  1.637828e-01,  1.251813e-01, -9.891296e-01},
  { 1.454976e-01,  1.210396e-01, -9.819266e-01,  1.532672e-01,  1.157412e-01, -9.919603e-01},
  { 2.263951e-01,  2.110770e-01, -9.508899e-01,  2.289701e-01,  2.202771e-01, -9.591273e-01},
  { 2.042684e-02,  8.317808e-02, -9.963253e-01,  2.662024e-02,  7.322835e-02, -1.007372e+00},
  {-2.764970e-01,  6.052024e-02, -9.591073e-01, -2.758640e-01,  6.328934e-02, -9.699267e-01},
  { 5.357345e-01, -1.196141e-01,  8.358714e-01,  5.378867e-01, -1.262349e-01,  8.459389e-01},
  { 6.497617e-01, -1.071878e-01,  7.525427e-01,  6.530433e-01, -1.019894e-01,  7.642023e-01},
  { 5.560519e-01, -1.099934e-01,  8.238373e-01,  5.625342e-01, -1.095854e-01,  8.321159e-01},
  { 2.802008e-01,  8.139855e-04,  9.599410e-01,  2.823978e-01, -1.636178e-02,  9.699744e-01},
  { 4.114175e-01, -8.507185e-02,  9.074682e-01,  4.156166e-01, -7.873868e-02,  9.188311e-01},
  { 2.449263e-01, -3.628801e-02,  9.688623e-01,  2.554888e-01, -3.030770e-02,  9.770736e-01},
  { 1.677922e-01, -4.889753e-02,  9.846089e-01,  1.754135e-01, -5.447605e-02,  9.935424e-01},
  {-3.163366e-01,  5.642715e-02,  9.469673e-01, -3.201483e-01,  5.559502e-02,  9.566981e-01},
  { 8.071576e-01, -1.372834e-01,  5.741515e-01,  8.130947e-01, -1.563459e-01,  5.790580e-01},
  { 7.705607e-02,  2.687891e-03,  9.970232e-01,  8.690353e-02, -7.282115e-03,  1.006607e+00},
  { 8.510363e-01, -1.628468e-01,  4.992175e-01,  8.585165e-01, -1.560934e-01,  5.093725e-01},
  {-2.548622e-01,  5.473396e-02,  9.654271e-01, -2.540771e-01,  5.122743e-02,  9.765648e-01},
  {-4.210589e-01,  4.634176e-02,  9.058487e-01, -4.332868e-01,  4.638839e-02,  9.115733e-01},
  {-2.041314e-01,  4.231729e-02,  9.780285e-01, -1.979467e-01,  4.202424e-02,  9.899040e-01},
  {-3.822961e-02, -4.411305e-02,  9.982948e-01, -1.217900e-01,  4.866937e-02,  1.001828e+00},
  { 9.994517e-01, -1.751128e-02,  2.810304e-02,  1.009829e+00, -1.156372e-02,  3.152261e-02},
  { 9.967375e-01, -3.080811e-02,  7.460013e-02,  1.007003e+00, -3.515598e-02,  7.476480e-02},
  {-6.558414e-01,  2.214646e-02,  7.545738e-01, -6.557537e-01,  2.674894e-02,  7.681949e-01},
  {-7.334759e-01,  6.158882e-02,  6.769195e-01, -7.391710e-01,  5.470930e-02,  6.866469e-01},
  {-8.462343e-01,  1.149243e-01,  5.202690e-01, -8.556529e-01,  1.057596e-01,  5.268044e-01},
  { 9.985608e-01,  7.611485e-03, -5.308885e-02,  1.009118e+00,  1.618741e-02, -4.797015e-02},
  { 8.981215e-01,  2.643314e-01, -3.514351e-01,  9.054484e-01,  2.689071e-01, -3.587990e-01},
  { 9.902706e-01,  5.604498e-02, -1.273698e-01,  1.000914e+00,  4.529680e-02, -1.303913e-01},
  {-8.727462e-01,  4.746609e-01,  1.140657e-01, -8.768501e-01,  4.898783e-01,  1.095835e-01},
  {-8.776393e-01,  4.514114e-01,  1.611740e-01, -8.861508e-01,  4.563164e-01,  1.654293e-01},
  {-8.875403e-01,  3.520426e-01,  2.972175e-01, -8.956786e-01,  3.656718e-01,  2.913710e-01},
  {-8.305196e-01,  5.567049e-01, -1.780252e-02, -8.424601e-01,  5.576852e-01, -1.026183e-02},
  { 7.487020e-01,  4.530061e-01, -4.839739e-01,  7.531502e-01,  4.595629e-01, -4.923935e-01},
  {-8.204793e-01,  5.648437e-01, -8.812158e-02, -8.254144e-01,  5.762367e-01, -8.660375e-02},
  {-8.774431e-01,  2.791212e-01, -3.901090e-01, -8.838360e-01,  2.924193e-01, -3.954877e-01},
  {-8.767684e-01,  3.383664e-01, -3.417387e-01, -8.840182e-01,  3.469430e-01, -3.449600e-01},
  {-8.571348e-01,  2.593180e-01, -4.450552e-01, -8.610825e-01,  2.656420e-01, -4.569750e-01},
  {-7.624621e-01,  6.184516e-01, -1.901816e-01, -7.747273e-01,  6.100333e-01, -2.202643e-01},
  {-7.840561e-01,  5.180582e-01, -3.418648e-01, -7.982941e-01,  5.154070e-01, -3.434249e-01},
  { 6.296407e-01,  5.380324e-01, -5.604230e-01,  6.355485e-01,  5.352849e-01, -5.754635e-01},
  {-8.452566e-01,  5.306784e-02, -5.317191e-01, -8.536285e-01,  5.199905e-02, -5.380217e-01},
  {-7.276233e-01,  6.157292e-01, -3.023938e-01, -7.351784e-01,  6.298916e-01, -2.891538e-01},
  {-7.581675e-01,  5.476232e-01, -3.539644e-01, -7.622510e-01,  5.694877e-01, -3.398775e-01},
  {-7.318987e-01,  5.952214e-01, -3.317164e-01, -7.407786e-01,  5.999864e-01, -3.348490e-01},
  { 5.634497e-01,  5.644011e-01, -6.033041e-01,  5.745316e-01,  5.816725e-01, -5.936783e-01},
  {-7.788963e-01,  6.593775e-02, -6.236768e-01, -7.920434e-01,  5.751995e-02, -6.262683e-01},
  { 3.072360e-01,  4.194521e-01, -8.542049e-01,  2.943549e-01,  4.383557e-01, -8.614390e-01},
  {-7.455167e-01,  5.632512e-02, -6.641027e-01, -7.538530e-01,  6.523432e-02, -6.695560e-01},
  { 2.921381e-01,  5.112994e-01, -8.082254e-01,  2.972758e-01,  5.195393e-01, -8.139930e-01},
  { 3.226466e-01,  5.570397e-01, -7.652490e-01,  3.190814e-01,  5.637043e-01, -7.754379e-01},
  { 5.083789e-01,  5.945696e-01, -6.229268e-01,  5.125235e-01,  6.046343e-01, -6.265936e-01},
  {-7.194417e-01,  8.400045e-02, -6.894544e-01, -7.308471e-01,  6.456607e-02, -6.946577e-01},
  {-6.747389e-01,  7.455531e-03, -7.380189e-01, -6.794947e-01,  1.315450e-02, -7.476429e-01},
  {-6.810135e-01,  4.379831e-02, -7.309600e-01, -6.924295e-01,  3.514621e-02, -7.349573e-01},
  { 2.591471e-01,  3.535427e-01, -8.988049e-01,  2.559972e-01,  3.640369e-01, -9.070938e-01},
  { 3.851779e-01,  5.851666e-01, -7.135952e-01,  3.867061e-01,  6.032100e-01, -7.123741e-01},
  {-5.109758e-01,  2.572474e-02, -8.592101e-01, -5.175771e-01,  2.702048e-02, -8.673196e-01},
  { 1.135227e-01,  1.118386e-01, -9.872208e-01,  1.278396e-01,  1.161193e-01, -9.955125e-01},
  {-1.357066e-01,  3.432662e-02, -9.901543e-01, -1.394940e-01,  4.433316e-02, -9.997212e-01},
  { 2.390517e-01,  2.627329e-01, -9.347865e-01,  2.443583e-01,  2.641883e-01, -9.441233e-01},
  { 1.894661e-01,  1.796719e-01, -9.653086e-01,  1.882386e-01,  1.772439e-01, -9.767417e-01},
  { 6.389266e-02,  9.413038e-02, -9.935076e-01,  6.503942e-02,  1.018437e-01, -1.003129e+00},
  { 3.267180e-01, -6.590712e-03,  9.450989e-01,  3.215879e-01,  1.413372e-02,  9.577311e-01},
  { 6.686738e-01, -1.081331e-01,  7.356511e-01,  6.747951e-01, -1.053072e-01,  7.446038e-01},
  { 3.446321e-01, -7.708474e-03,  9.387062e-01,  4.929913e-01, -9.606118e-02,  8.779621e-01},
  { 6.920830e-01, -1.565176e-01,  7.046440e-01,  6.948738e-01, -1.569641e-01,  7.165092e-01},
  { 8.373598e-01,  6.309478e-04,  5.466518e-01,  7.498066e-01, -1.498796e-01,  6.617174e-01},
  {-3.388877e-01,  6.024078e-02,  9.388963e-01, -3.458748e-01,  6.487099e-02,  9.471110e-01},
  { 1.039020e-01, -1.001681e-02,  9.945371e-01,  1.142369e-01, -5.833777e-03,  1.003882e+00},
  { 8.259968e-01, -1.514729e-01,  5.429413e-01,  8.374913e-01, -1.469145e-01,  5.458024e-01},
  {-1.806969e-01,  7.305360e-02,  9.808220e-01, -1.797562e-01,  7.049070e-02,  9.917552e-01},
  {-2.874795e-01,  1.122518e-01,  9.511862e-01, -1.477926e-01,  6.618240e-02,  9.973150e-01},
  { 9.101596e-01, -1.126442e-01,  3.986486e-01,  9.196742e-01, -1.331923e-01,  3.966574e-01},
  { 9.544400e-01, -9.180413e-02,  2.839300e-01,  9.639608e-01, -1.066308e-01,  2.833524e-01},
  { 9.653744e-01, -7.703619e-02,  2.492345e-01,  9.741367e-01, -8.337135e-02,  2.549253e-01},
  {-5.565246e-01,  3.357275e-02,  8.301526e-01, -5.589533e-01,  3.259408e-02,  8.410482e-01},
  { 9.866650e-01, -6.785978e-02,  1.479434e-01,  9.973483e-01, -6.209352e-02,  1.494038e-01},
  {-7.628396e-01,  5.762162e-02,  6.440150e-01, -7.720292e-01,  6.029721e-02,  6.489882e-01},
  {-7.995871e-01,  4.874942e-02,  5.985681e-01, -8.069195e-01,  5.796015e-02,  6.052864e-01},
  { 9.388615e-01,  2.054612e-01, -2.762694e-01,  9.502594e-01,  2.087968e-01, -2.725716e-01},
  {-7.239655e-01,  8.793986e-02,  6.842079e-01, -7.323821e-01,  8.529800e-02,  6.907909e-01},
  {-7.845690e-01,  8.033905e-02,  6.148147e-01, -7.937875e-01,  8.225633e-02,  6.196658e-01},
  {-7.632039e-01,  1.086245e-01,  6.369619e-01, -7.759526e-01,  1.084141e-01,  6.379616e-01},
  {-7.896813e-01,  8.897661e-02,  6.070309e-01, -8.113643e-01,  9.431522e-02,  5.946789e-01},
  {-6.130913e-01,  1.015829e-01,  7.834539e-01, -7.405333e-01,  1.198695e-01,  6.768261e-01},
  {-5.477970e-01,  1.315878e-01,  8.261979e-01, -7.410834e-01,  1.293451e-01,  6.757383e-01},
  {-6.733150e-01,  1.647457e-01,  7.207675e-01, -7.391500e-01,  1.400637e-01,  6.744563e-01},
  { 9.835481e-01,  9.544361e-02, -1.533743e-01,  9.925608e-01,  9.810621e-02, -1.614984e-01},
  { 9.940767e-01,  4.083305e-02, -1.007182e-01,  1.005456e+00,  3.705477e-02, -9.256463e-02},
  {-8.798158e-01,  2.460575e-01,  4.066692e-01, -8.908905e-01,  2.459599e-01,  4.082514e-01},
  {-8.798608e-01,  2.205270e-01,  4.209666e-01, -8.855799e-01,  2.226187e-01,  4.324815e-01},
  { 8.664751e-01,  3.207894e-01, -3.825115e-01,  8.776869e-01,  3.157617e-01, -3.883876e-01},
  {-8.399174e-01,  5.414748e-01,  3.665858e-02, -8.511168e-01,  5.425594e-01,  4.567274e-02},
  {-8.523997e-01,  5.158375e-01,  8.559488e-02, -8.618076e-01,  5.209569e-01,  8.214337e-02},
  {-8.857373e-01,  3.164810e-01,  3.395722e-01, -8.897964e-01,  3.287930e-01,  3.478649e-01},
  { 8.189206e-01,  3.894343e-01, -4.215566e-01,  8.246391e-01,  3.933875e-01, -4.313948e-01},
  {-8.704854e-01,  4.194262e-01,  2.575597e-01, -8.863705e-01,  4.132138e-01,  2.538807e-01},
  {-8.751349e-01,  3.123401e-01,  3.695707e-01, -8.837572e-01,  3.167949e-01,  3.737198e-01},
  { 7.842357e-01,  4.235110e-01, -4.534455e-01,  7.885362e-01,  4.312310e-01, -4.616657e-01},
  {-7.998927e-01,  5.878230e-01, -1.209790e-01, -8.084118e-01,  5.945070e-01, -1.178564e-01},
  {-8.653238e-01,  3.343144e-01, -3.734283e-01, -8.744011e-01,  3.326261e-01, -3.816252e-01},
  {-8.353165e-01,  4.494184e-01, -3.166535e-01, -8.516875e-01,  4.359923e-01, -3.246472e-01},
  {-8.576658e-01,  4.011671e-01, -3.216743e-01, -8.673472e-01,  3.996308e-01, -3.299395e-01},
  {-8.732524e-01,  1.592783e-01, -4.605004e-01, -8.869750e-01,  1.631683e-01, -4.555268e-01},
  {-8.054279e-01,  4.829220e-01, -3.436162e-01, -8.107661e-01,  4.881125e-01, -3.539243e-01},
  {-8.575467e-01,  2.189355e-01, -4.654899e-01, -8.645465e-01,  2.236346e-01, -4.726535e-01},
  {-7.026013e-01,  6.952734e-01, -1.514808e-01, -7.618604e-01,  6.209280e-01, -2.383275e-01},
  {-6.446803e-01,  7.586340e-01, -9.413683e-02, -7.551082e-01,  6.253409e-01, -2.441729e-01},
  {-8.708270e-01,  1.141884e-01, -4.781437e-01, -8.768752e-01,  1.121020e-01, -4.898922e-01},
  {-7.514508e-01,  5.950162e-01, -2.850923e-01, -7.517438e-01,  6.255018e-01, -2.539470e-01},
  { 2.912424e-01,  5.743357e-01, -7.650596e-01,  2.923426e-01,  5.755114e-01, -7.773039e-01},
  { 4.312050e-01,  6.160331e-01, -6.592158e-01,  4.440424e-01,  6.166459e-01, -6.659248e-01},
  { 3.883828e-01,  6.144317e-01, -6.867551e-01,  3.925775e-01,  6.164880e-01, -6.976435e-01},
  { 2.414332e-01,  3.053721e-01, -9.211177e-01,  2.554154e-01,  3.081339e-01, -9.277351e-01},
  { 1.874800e-01,  2.230212e-01, -9.566153e-01,  1.860091e-01,  2.214689e-01, -9.681044e-01},
  {-4.501401e-01,  7.823414e-02, -8.895243e-01, -4.411853e-01,  7.291900e-02, -9.060351e-01},
  {-4.015153e-02,  1.012945e-01, -9.940459e-01, -4.252530e-02,  1.069354e-01, -1.003805e+00},
  { 4.072793e-01,  1.809143e-03,  9.133019e-01,  4.076031e-01,  5.648782e-03,  9.244981e-01},
  { 6.200022e-01, -6.350861e-02,  7.820255e-01,  6.308559e-01, -5.317243e-02,  7.874428e-01},
  { 4.321550e-01, -4.255135e-02,  9.007949e-01,  4.281225e-01, -4.515547e-02,  9.140792e-01},
  { 4.358743e-01, -4.651562e-02,  8.988047e-01,  4.399045e-01, -3.989987e-02,  9.087140e-01},
  { 3.102084e-01,  4.984113e-02,  9.493611e-01,  3.128951e-01,  4.358401e-02,  9.597212e-01},
  { 1.859168e-01,  8.403090e-02,  9.789656e-01,  4.946265e-01, -8.797955e-02,  8.766264e-01},
  { 8.241250e-01,  1.074377e-02,  5.663060e-01,  7.390635e-01, -1.318675e-01,  6.762174e-01},
  { 7.702769e-01, -1.411900e-01,  6.218833e-01,  7.797242e-01, -1.391749e-01,  6.273238e-01},
  { 8.569661e-01, -1.192334e-01,  5.013905e-01,  8.603395e-01, -1.277712e-01,  5.141662e-01},
  { 8.805360e-01, -1.382329e-01,  4.533740e-01,  8.865947e-01, -1.404407e-01,  4.637922e-01},
  {-4.587399e-01,  6.760352e-02,  8.859951e-01, -4.645140e-01,  7.388432e-02,  8.945441e-01},
  {-5.048759e-01,  7.570393e-02,  8.598658e-01, -4.933197e-01,  7.135089e-02,  8.788626e-01},
  { 9.398764e-01, -1.019085e-01,  3.259555e-01,  9.515604e-01, -8.478606e-02,  3.289729e-01},
  {-8.808782e-02,  5.446019e-02,  9.946229e-01, -7.770911e-02,  5.584178e-02,  1.005835e+00},
  { 9.762091e-01, -5.935830e-02,  2.085485e-01,  9.859288e-01, -5.999212e-02,  2.126635e-01},
  {-5.945961e-01,  1.617504e-02,  8.038618e-01, -6.038632e-01,  2.368376e-02,  8.097165e-01},
  { 9.843017e-01, -3.999713e-02,  1.719022e-01,  9.952173e-01, -4.557547e-02,  1.683633e-01},
  { 9.921328e-01, -3.326937e-02,  1.206883e-01,  1.000785e+00, -2.887087e-02,  1.359289e-01},
  {-8.277354e-01,  8.275586e-02,  5.549824e-01, -8.325967e-01,  8.063534e-02,  5.685351e-01},
  { 9.512734e-01,  2.097723e-01, -2.259966e-01,  9.619793e-01,  2.035333e-01, -2.324963e-01},
  {-6.891347e-01,  9.785447e-02,  7.179958e-01, -7.082493e-01,  1.017863e-01,  7.133543e-01},
  {-7.739831e-01,  4.534699e-02,  6.315805e-01, -8.226508e-01,  7.034856e-02,  5.841431e-01},
  { 9.984545e-01,  5.186768e-02, -1.996224e-02,  1.009257e+00,  4.408159e-02, -1.842252e-02},
  { 9.665724e-01,  1.473851e-01, -2.097984e-01,  9.778652e-01,  1.584440e-01, -1.988951e-01},
  { 9.791566e-01,  1.364247e-01, -1.504686e-01,  9.902638e-01,  1.329707e-01, -1.502678e-01},
  { 9.888651e-01,  9.312776e-02, -1.160739e-01,  9.979994e-01,  1.043950e-01, -1.182472e-01},
  {-7.956694e-01,  1.495956e-01,  5.869679e-01, -8.138167e-01,  1.429879e-01,  5.814704e-01},
  { 9.956266e-01,  6.224344e-02, -6.966604e-02,  1.006135e+00,  5.836410e-02, -7.189815e-02},
  {-7.645103e-01,  1.615981e-01,  6.240273e-01, -7.685279e-01,  1.675372e-01,  6.341514e-01},
  {-8.264008e-01,  1.415274e-01,  5.450062e-01, -8.364493e-01,  1.495852e-01,  5.466513e-01},
  {-8.440316e-01,  3.142151e-01,  4.346027e-01, -8.590651e-01,  1.708237e-01,  5.036637e-01},
  {-8.513645e-01,  5.047044e-01,  1.430101e-01, -8.653577e-01,  4.999886e-01,  1.484017e-01},
  {-8.732365e-01,  4.353933e-01,  2.188398e-01, -8.798753e-01,  4.398746e-01,  2.306167e-01},
  {-8.767768e-01,  2.721727e-01,  3.964650e-01, -8.808228e-01,  2.844417e-01,  4.050879e-01},
  {-8.661788e-01,  3.638218e-01,  3.425903e-01, -8.811238e-01,  3.619800e-01,  3.368150e-01},
  {-8.692466e-01,  4.007242e-01,  2.895350e-01, -8.761931e-01,  4.121442e-01,  2.885769e-01},
  {-8.035048e-01,  5.940431e-01, -3.863682e-02, -8.134102e-01,  5.972451e-01, -5.020106e-02},
  { 7.184815e-01,  4.949647e-01, -4.886658e-01,  7.205251e-01,  5.021310e-01, -4.995924e-01},
  {-8.554654e-01,  2.964106e-01, -4.246406e-01, -8.645518e-01,  3.060403e-01, -4.239630e-01},
  {-9.002095e-01,  1.176295e-01, -4.192683e-01, -9.113555e-01,  1.319721e-01, -4.157726e-01},
  { 6.741317e-01,  5.221246e-01, -5.224293e-01,  6.767118e-01,  5.353491e-01, -5.256869e-01},
  {-8.575825e-01,  3.722655e-01, -3.549235e-01, -8.695634e-01,  3.744096e-01, -3.528917e-01},
  {-7.441211e-01,  6.344810e-01, -2.090880e-01, -7.532213e-01,  6.368924e-01, -2.188285e-01},
  {-8.227719e-01,  2.656641e-01, -5.024629e-01, -8.360939e-01,  2.604591e-01, -5.039479e-01},
  {-8.134257e-01,  8.061376e-02, -5.760555e-01, -8.225285e-01,  8.754695e-02, -5.802036e-01},
  {-6.413471e-01, -2.968215e-03, -7.672452e-01, -6.415205e-01,  1.421651e-03, -7.805806e-01},
  { 4.746757e-01,  6.139463e-01, -6.306767e-01,  4.823409e-01,  6.271222e-01, -6.289326e-01},
  { 3.370468e-01,  6.061058e-01, -7.204410e-01,  3.328046e-01,  6.201230e-01, -7.249611e-01},
  { 2.510209e-01,  4.329411e-01, -8.657659e-01,  2.634514e-01,  4.330008e-01, -8.740600e-01},
  {-5.388951e-01,  5.970614e-02, -8.402542e-01, -5.424137e-01,  6.001397e-02, -8.503205e-01},
  {-4.912018e-01,  5.885584e-02, -8.690552e-01, -5.014335e-01,  5.879745e-02, -8.751956e-01},
  { 2.119109e-01,  3.813822e-01, -8.998007e-01,  2.309650e-01,  3.829405e-01, -9.060287e-01},
  {-1.492228e-01,  7.211990e-02, -9.861701e-01, -1.468567e-01,  7.073319e-02, -9.971442e-01},
  {-9.012915e-02,  8.232740e-02, -9.925215e-01, -8.275414e-02,  9.314856e-02, -1.002668e+00},
  {-2.325800e-01,  9.711090e-02, -9.677169e-01, -2.347725e-01,  8.382692e-02, -9.791425e-01},
  {-3.976291e-01,  1.062034e-01, -9.113792e-01, -4.104892e-01,  1.022356e-01, -9.175558e-01},
  {-3.322286e-01,  1.017989e-01, -9.376893e-01, -3.365036e-01,  1.010594e-01, -9.485833e-01},
  { 7.149378e-01, -9.615002e-02,  6.925453e-01,  6.031218e-01, -4.409629e-02,  8.094268e-01},
  { 8.200465e-01, -2.006781e-01,  5.359589e-01,  5.999756e-01, -5.204100e-02,  8.125539e-01},
  { 4.537050e-01, -6.218692e-03,  8.911303e-01,  4.551868e-01, -1.331341e-02,  9.019409e-01},
  { 7.056015e-01, -1.761505e-01,  6.863654e-01,  5.891179e-01, -7.372665e-02,  8.175427e-01},
  { 6.618896e-01, -6.136770e-02,  7.470850e-01,  6.596928e-01, -6.301706e-02,  7.626975e-01},
  { 3.559956e-01,  2.760723e-02,  9.340797e-01,  3.561350e-01,  3.973077e-02,  9.446998e-01},
  { 4.620348e-01, -5.900129e-02,  8.848970e-01,  4.668008e-01, -4.724983e-02,  8.948374e-01},
  { 3.903113e-01, -1.960708e-02,  9.204741e-01,  4.977374e-01, -8.008456e-02,  8.756219e-01},
  { 2.833114e-01,  6.257758e-02,  9.569842e-01,  2.883454e-01,  6.306508e-02,  9.663059e-01},
  { 2.337840e-01,  8.610913e-03,  9.722505e-01,  2.408887e-01, -8.095396e-05,  9.812434e-01},
  { 2.556276e-01,  4.608190e-02,  9.656764e-01,  2.516605e-01,  4.673958e-02,  9.774196e-01},
  { 7.106554e-01, -1.063710e-01,  6.954525e-01,  7.217187e-01, -1.114638e-01,  6.995664e-01},
  { 2.225776e-01,  5.739332e-02,  9.732241e-01,  2.254512e-01,  5.758902e-02,  9.832200e-01},
  { 1.953105e-01,  4.181508e-02,  9.798496e-01,  1.955982e-01,  4.383283e-02,  9.902957e-01},
  { 1.592658e-01,  7.293780e-02,  9.845377e-01,  1.691858e-01,  6.854483e-02,  9.937521e-01},
  {-2.778939e-01,  8.529595e-02,  9.568174e-01, -2.832421e-01,  8.770404e-02,  9.658882e-01},
  {-4.827565e-02,  6.081932e-02,  9.969806e-01, -4.336945e-02,  6.464937e-02,  1.007373e+00},
  {-2.732894e-01,  1.901148e-01,  9.429578e-01, -5.004862e-01,  1.710213e-01,  8.608838e-01},
  {-2.910477e-01,  1.784064e-01,  9.399268e-01, -5.020462e-01,  1.616263e-01,  8.630531e-01},
  {-5.261142e-01,  1.884531e-01,  8.292703e-01, -5.063198e-01,  1.938816e-01,  8.525879e-01},
  {-5.369412e-01,  8.254959e-02,  8.395712e-01, -5.434629e-01,  7.412108e-02,  8.485329e-01},
  {-5.505859e-01,  1.392962e-01,  8.230745e-01, -5.524149e-01,  1.412546e-01,  8.341100e-01},
  {-5.254895e-01,  1.413452e-01,  8.389770e-01, -5.309365e-01,  1.375711e-01,  8.485746e-01},
  {-5.429471e-01,  1.964028e-01,  8.164768e-01, -5.436324e-01,  1.864259e-01,  8.310021e-01},
  {-5.908816e-01,  9.472042e-02,  8.011785e-01, -5.822577e-01,  9.345321e-02,  8.204243e-01},
  {-6.124946e-01,  6.128261e-02,  7.880957e-01, -6.166952e-01,  6.503209e-02,  7.976907e-01},
  { 9.971169e-01,  9.746286e-03,  7.525233e-02,  1.008082e+00,  1.531693e-02,  6.647247e-02},
  { 9.983582e-01,  4.800704e-02,  3.124439e-02,  1.008847e+00,  5.071926e-02,  2.318323e-02},
  {-6.611592e-01,  7.635128e-02,  7.463505e-01, -6.648942e-01,  8.691998e-02,  7.557862e-01},
  { 9.600414e-01,  1.861483e-01, -2.089719e-01,  9.699777e-01,  1.952431e-01, -2.047139e-01},
  { 8.860009e-01,  3.111462e-01, -3.437884e-01,  8.979905e-01,  3.119600e-01, -3.423141e-01},
  {-7.448599e-01,  1.965762e-01,  6.376063e-01, -7.537768e-01,  2.012961e-01,  6.419913e-01},
  {-7.642643e-01,  2.071310e-01,  6.107346e-01, -7.728646e-01,  2.117032e-01,  6.153976e-01},
  {-7.859108e-01,  2.044409e-01,  5.835650e-01, -7.947524e-01,  1.997591e-01,  5.910303e-01},
  {-8.521985e-01,  4.850754e-01,  1.961109e-01, -8.645719e-01,  4.839341e-01,  1.979355e-01},
  {-8.584598e-01,  1.966597e-01,  4.736790e-01, -8.617241e-01,  2.252919e-01,  4.769974e-01},
  {-8.563771e-01,  3.374353e-01,  3.908399e-01, -8.682748e-01,  3.342240e-01,  3.940127e-01},
  {-8.103048e-01,  4.135222e-01,  4.152175e-01, -8.673320e-01,  3.210332e-01,  4.068481e-01},
  { 7.817827e-01,  4.483984e-01, -4.333067e-01,  7.861719e-01,  4.527425e-01, -4.447954e-01},
  {-7.596421e-01,  6.283894e-01, -1.675434e-01, -7.671885e-01,  6.350834e-01, -1.757470e-01},
  {-8.340382e-01,  3.144206e-01, -4.533432e-01, -8.471811e-01,  3.049932e-01, -4.583874e-01},
  { 6.368949e-01,  5.634422e-01, -5.262107e-01,  6.499825e-01,  5.628060e-01, -5.307131e-01},
  {-8.511303e-01,  1.866565e-01, -4.906492e-01, -8.680667e-01,  1.856263e-01, -4.825526e-01},
  {-8.491653e-01,  1.132269e-01, -5.158469e-01, -8.558340e-01,  1.084397e-01, -5.259681e-01},
  {-7.260984e-01,  5.746421e-01, -3.775811e-01, -7.365229e-01,  5.755990e-01, -3.835104e-01},
  { 5.884457e-01,  5.835679e-01, -5.596250e-01,  5.905751e-01,  5.954172e-01, -5.635450e-01},
  {-6.743684e-01,  6.633101e-01, -3.244178e-01, -6.821091e-01,  6.685497e-01, -3.295914e-01},
  {-8.172759e-01,  1.167881e-01, -5.642876e-01, -8.296025e-01,  1.119711e-01, -5.657529e-01},
  {-7.032371e-01,  6.164850e-01, -3.541239e-01, -7.088527e-01,  6.179677e-01, -3.694658e-01},
  { 2.477673e-01,  6.189483e-01, -7.453284e-01,  2.703412e-01,  6.276479e-01, -7.442130e-01},
  { 2.584972e-01,  5.415426e-01, -7.999442e-01,  2.638135e-01,  5.492041e-01, -8.060122e-01},
  { 2.987648e-01,  6.206064e-01, -7.249740e-01,  3.011060e-01,  6.285573e-01, -7.315262e-01},
  {-6.949624e-01,  8.465797e-02, -7.140450e-01, -6.985602e-01,  9.061162e-02, -7.243340e-01},
  {-5.783464e-01,  7.299053e-02, -8.125194e-01, -5.902899e-01,  6.619560e-02, -8.173338e-01},
  { 2.306933e-01,  4.095687e-01, -8.826290e-01,  2.295561e-01,  4.171651e-01, -8.911531e-01},
  { 1.371632e-01,  1.879296e-01, -9.725578e-01,  1.385003e-01,  1.922056e-01, -9.822155e-01},
  {-1.800971e-01,  7.847779e-02, -9.805133e-01, -1.958831e-01,  8.624194e-02, -9.874502e-01},
  { 1.430087e-01,  2.369522e-01, -9.609382e-01,  1.586803e-01,  2.363767e-01, -9.694433e-01},
  { 4.213305e-02,  1.309937e-01, -9.904875e-01,  2.582777e-02,  1.412103e-01, -1.000131e+00},
  { 1.686872e-01,  2.676504e-01, -9.486348e-01,  1.793624e-01,  2.659566e-01, -9.581077e-01},
  {-2.552762e-02,  1.282840e-01, -9.914089e-01, -2.506240e-02,  1.257882e-01, -1.002207e+00},
  { 5.564766e-01, -3.284834e-02,  8.302137e-01,  5.637361e-01, -6.031210e-02,  8.363224e-01},
  { 4.845183e-01, -4.379598e-02,  8.736842e-01,  4.986680e-01, -4.292368e-02,  8.777003e-01},
  { 7.344279e-01, -1.137188e-01,  6.690916e-01,  7.366260e-01, -1.051210e-01,  6.835245e-01},
  { 1.998533e-01, -1.638430e-02,  9.796888e-01,  1.936841e-01,  4.899748e-03,  9.916288e-01},
  { 2.193195e-01,  1.203555e-02,  9.755788e-01,  1.939944e-01,  9.438739e-02,  9.870782e-01},
  { 1.540449e-01,  1.188981e-02,  9.879923e-01,  1.522645e-01,  1.943412e-02,  9.986503e-01},
  { 8.163010e-01, -7.736989e-02,  5.724216e-01,  8.191078e-01, -8.486199e-02,  5.854373e-01},
  { 1.198253e-01,  4.052348e-02,  9.919677e-01,  1.237591e-01,  4.614807e-02,  1.001708e+00},
  {-3.620467e-01,  8.465680e-02,  9.283077e-01, -3.586470e-01,  9.116381e-02,  9.401693e-01},
  { 1.151373e-01,  9.362566e-02,  9.889276e-01,  1.260645e-01,  8.069118e-02,  9.992304e-01},
  { 8.559293e-02,  6.005681e-02,  9.945185e-01,  9.481763e-02,  6.570449e-02,  1.003771e+00},
  {-4.032381e-01,  9.567995e-02,  9.100793e-01, -4.127785e-01,  1.076623e-01,  9.159034e-01},
  { 8.682519e-01, -8.391915e-02,  4.889748e-01,  8.762539e-01, -9.150641e-02,  4.946544e-01},
  {-4.347955e-01,  1.333702e-01,  8.905982e-01, -4.390709e-01,  1.444394e-01,  8.984488e-01},
  {-1.037304e-01,  8.062856e-02,  9.913319e-01, -9.725767e-02,  9.527474e-02,  1.001162e+00},
  {-2.443877e-01,  9.132561e-02,  9.653674e-01, -2.378700e-01,  9.487305e-02,  9.773822e-01},
  { 8.902390e-01, -1.018830e-01,  4.439531e-01,  9.022501e-01, -1.004350e-01,  4.435485e-01},
  { 4.107225e-02,  6.762911e-02,  9.968648e-01,  3.068873e-02,  7.229554e-02,  1.007321e+00},
  {-4.470405e-01,  1.273924e-01,  8.853959e-01, -5.014455e-01,  1.374020e-01,  8.663304e-01},
  { 9.633110e-01, -1.825702e-02,  2.677659e-01,  9.703968e-01, -3.640726e-02,  2.790786e-01},
  { 9.671462e-01, -3.544889e-02,  2.517372e-01,  9.809895e-01, -3.543372e-02,  2.393420e-01},
  {-6.010177e-01,  1.291750e-01,  7.887278e-01, -5.960505e-01,  1.402443e-01,  8.036848e-01},
  {-5.694954e-01,  1.787769e-01,  8.023177e-01, -5.852545e-01,  1.820593e-01,  8.032348e-01},
  { 9.911984e-01,  1.153536e-02,  1.318811e-01,  1.001098e+00,  8.628399e-03,  1.364178e-01},
  { 9.251226e-01,  2.640787e-01, -2.727831e-01,  9.340451e-01,  2.702395e-01, -2.746183e-01},
  { 9.691822e-01,  1.876422e-01, -1.596129e-01,  9.777638e-01,  1.872730e-01, -1.726006e-01},
  { 9.062930e-01,  2.899307e-01, -3.075276e-01,  9.153466e-01,  2.954206e-01, -3.094387e-01},
  {-7.014689e-01,  1.327875e-01,  7.002205e-01, -6.989136e-01,  1.377679e-01,  7.165138e-01},
  { 9.831113e-01,  1.460635e-01, -1.102625e-01,  9.946648e-01,  1.386228e-01, -1.109482e-01},
  { 9.926286e-01,  1.002096e-01, -6.816573e-02,  1.001961e+00,  1.064065e-01, -7.506356e-02},
  {-7.289999e-01,  1.973452e-01,  6.554496e-01, -7.402634e-01,  1.977308e-01,  6.586085e-01},
  {-8.254924e-01,  1.875170e-01,  5.323528e-01, -8.290415e-01,  1.925815e-01,  5.444759e-01},
  { 8.452817e-01,  3.629142e-01, -3.921635e-01,  8.561898e-01,  3.781825e-01, -3.805286e-01},
  {-8.056518e-01,  2.148067e-01,  5.520719e-01, -8.129808e-01,  2.159990e-01,  5.596950e-01},
  {-8.491153e-01,  3.543075e-01,  3.917517e-01, -8.630798e-01,  3.487433e-01,  3.928415e-01},
  {-8.505304e-01,  2.550016e-01,  4.599698e-01, -8.589940e-01,  2.593406e-01,  4.644607e-01},
  {-7.803245e-01,  6.214514e-01, -6.994215e-02, -7.882689e-01,  6.291512e-01, -6.049703e-02},
  {-7.666891e-01,  6.328958e-01, -1.078462e-01, -7.749949e-01,  6.373582e-01, -1.183934e-01},
  {-8.458483e-01,  3.454669e-01, -4.064398e-01, -8.514157e-01,  3.520332e-01, -4.147527e-01},
  {-8.367919e-01,  3.904012e-01, -3.838829e-01, -8.477073e-01,  3.884763e-01, -3.890177e-01},
  {-8.317868e-01,  4.259646e-01, -3.559282e-01, -8.370189e-01,  4.397334e-01, -3.562173e-01},
  {-7.947982e-01,  4.722480e-01, -3.811530e-01, -8.125001e-01,  4.683900e-01, -3.759152e-01},
  {-8.582695e-01,  1.432135e-01, -4.928117e-01, -8.621794e-01,  1.503408e-01, -5.048743e-01},
  {-7.982710e-01,  2.998013e-01, -5.223818e-01, -8.065969e-01,  3.030628e-01, -5.276465e-01},
  {-8.330721e-01,  2.164435e-01, -5.090610e-01, -8.391052e-01,  2.251335e-01, -5.158220e-01},
  {-7.795803e-01,  2.979611e-01, -5.508845e-01, -7.819954e-01,  3.038319e-01, -5.630509e-01},
  { 5.413786e-01,  6.106972e-01, -5.778911e-01,  5.455993e-01,  6.242830e-01, -5.774733e-01},
  {-6.712672e-01,  6.474566e-01, -3.608328e-01, -6.730870e-01,  6.552368e-01, -3.721304e-01},
  { 5.004202e-01,  6.360546e-01, -5.873791e-01,  5.096197e-01,  6.363828e-01, -5.968145e-01},
  {-7.188775e-01,  4.433184e-02, -6.937217e-01, -7.663388e-01,  1.320049e-01, -6.451010e-01},
  {-7.421136e-01,  1.117513e-01, -6.608926e-01, -7.528465e-01,  1.231716e-01, -6.625003e-01},
  { 2.359830e-01,  5.870896e-01, -7.743629e-01,  2.501385e-01,  5.803437e-01, -7.883592e-01},
  {-6.039923e-01,  1.834984e-02, -7.967788e-01, -6.344353e-01,  2.620473e-02, -7.859149e-01},
  {-7.669245e-01, -7.820688e-02,  6.369541e-01, -6.348888e-01,  2.989953e-02, -7.854167e-01},
  { 7.398532e-01,  3.263933e-01, -5.882897e-01, -6.353745e-01,  3.075036e-02, -7.849910e-01},
  {-6.416487e-01,  4.794442e-02, -7.654988e-01, -6.464918e-01,  5.462553e-02, -7.745461e-01},
  {-6.575156e-01,  8.442932e-02, -7.486955e-01, -6.576478e-01,  7.734320e-02, -7.631347e-01},
  { 3.288183e-01,  6.489382e-01, -6.861179e-01,  3.322254e-01,  6.463223e-01, -7.019787e-01},
  { 2.578827e-01,  4.763684e-01, -8.405770e-01,  2.515305e-01,  4.742090e-01, -8.559998e-01},
  { 2.369195e-01,  4.756026e-01, -8.471548e-01,  2.340660e-01,  4.740919e-01, -8.610035e-01},
  { 3.775905e-01,  6.337057e-01, -6.751610e-01,  3.829125e-01,  6.430994e-01, -6.787358e-01},
  { 1.030589e-01,  1.548225e-01, -9.825522e-01,  9.547305e-02,  1.698364e-01, -9.914193e-01},
  { 2.042265e-01,  3.395442e-01, -9.181510e-01,  2.035224e-01,  3.351337e-01, -9.312032e-01},
  {-4.706582e-01,  9.087184e-02, -8.776236e-01, -4.776385e-01,  8.835479e-02, -8.859547e-01},
  { 1.856809e-01,  3.100265e-01, -9.324195e-01,  1.750496e-01,  3.105855e-01, -9.453935e-01},
  { 5.699982e-01, -1.172694e-02,  8.215622e-01,  5.783831e-01, -1.120957e-02,  8.283836e-01},
  { 4.929029e-01,  1.417430e-02,  8.699689e-01,  4.919757e-01,  7.375185e-03,  8.824829e-01},
  { 5.261076e-01, -6.575347e-02,  8.478721e-01,  5.296767e-01, -5.632761e-02,  8.585688e-01},
  { 7.040174e-01, -5.737388e-02,  7.078614e-01,  7.022915e-01, -4.130405e-02,  7.252274e-01},
  { 7.348803e-01, -4.540834e-02,  6.766749e-01,  7.418178e-01, -4.820915e-02,  6.856597e-01},
  { 2.704780e-01, -8.233102e-02,  9.591993e-01,  2.087958e-01,  1.024918e-01,  9.845057e-01},
  { 7.835293e-01, -9.205852e-02,  6.144972e-01,  7.932312e-01, -8.578778e-02,  6.199194e-01},
  { 8.380020e-01, -8.950415e-02,  5.382766e-01,  8.543705e-01, -7.191084e-02,  5.345623e-01},
  {-9.998338e-02,  1.444317e-01,  9.844505e-01, -1.033405e-01,  1.391722e-01,  9.953961e-01},
  {-3.179919e-01,  1.091366e-01,  9.417910e-01, -3.136462e-01,  1.156932e-01,  9.534668e-01},
  { 8.955820e-01, -6.498193e-02,  4.401251e-01,  8.984689e-01, -6.756723e-02,  4.572379e-01},
  {-6.864194e-02,  1.238017e-01,  9.899300e-01, -5.802512e-02,  1.178135e-01,  1.001806e+00},
  { 9.250581e-01, -7.258368e-02,  3.728260e-01,  9.328936e-01, -6.944779e-02,  3.817921e-01},
  { 9.076590e-01, -6.659634e-02,  4.143913e-01,  9.196466e-01, -6.735093e-02,  4.130284e-01},
  {-4.718439e-01,  1.373753e-01,  8.709140e-01, -4.854355e-01,  1.250949e-01,  8.772451e-01},
  {-4.690129e-01,  1.812311e-01,  8.643970e-01, -4.748889e-01,  1.897703e-01,  8.713920e-01},
  { 9.477025e-01, -3.491545e-02,  3.172397e-01,  9.595326e-01, -2.395981e-02,  3.194137e-01},
  {-5.116966e-01,  2.359553e-01,  8.261305e-01, -5.171264e-01,  2.287131e-01,  8.373331e-01},
  {-5.199896e-01,  2.400418e-01,  8.197505e-01, -5.283124e-01,  2.286627e-01,  8.303345e-01},
  { 9.787026e-01, -5.930172e-03,  2.051973e-01,  9.879976e-01, -5.116631e-03,  2.114607e-01},
  { 9.839419e-01,  1.979139e-02,  1.773882e-01,  9.951912e-01,  7.639864e-03,  1.744063e-01},
  {-6.371762e-01,  1.171198e-01,  7.617673e-01, -6.480505e-01,  1.184341e-01,  7.660657e-01},
  { 9.948428e-01,  5.911149e-02,  8.242381e-02,  1.004914e+00,  4.987054e-02,  9.243190e-02},
  { 9.401437e-01,  2.479378e-01, -2.337877e-01,  9.492742e-01,  2.551111e-01, -2.338408e-01},
  { 9.962615e-01,  8.577771e-02,  1.025603e-02,  1.006374e+00,  8.988943e-02,  3.650758e-03},
  {-8.184250e-01,  5.707091e-01,  6.687058e-02, -8.255697e-01,  5.789436e-01,  6.415761e-02},
  {-7.918372e-01,  2.523237e-01,  5.561713e-01, -7.988138e-01,  2.601759e-01,  5.612999e-01},
  { 8.148789e-01,  4.234347e-01, -3.958225e-01,  8.330262e-01,  4.183534e-01, -3.897858e-01},
  {-7.978227e-01,  6.023641e-01,  2.522941e-02, -8.027821e-01,  6.133447e-01,  1.440321e-02},
  {-8.265520e-01,  5.509902e-01,  1.149849e-01, -8.300334e-01,  5.643801e-01,  1.156570e-01},
  {-8.457264e-01,  4.668145e-01,  2.585171e-01, -8.542241e-01,  4.692749e-01,  2.663402e-01},
  { 7.563943e-01,  4.775512e-01, -4.470038e-01,  7.693712e-01,  4.795535e-01, -4.460732e-01},
  {-8.452919e-01,  4.421748e-01,  2.999384e-01, -8.521674e-01,  4.524297e-01,  2.999549e-01},
  {-7.847617e-01,  4.355132e-01,  4.409958e-01, -8.531891e-01,  3.107660e-01,  4.455323e-01},
  {-8.436031e-01,  4.200622e-01,  3.344869e-01, -8.511171e-01,  4.290899e-01,  3.351657e-01},
  { 7.037323e-01,  5.283757e-01, -4.749528e-01,  7.085025e-01,  5.361171e-01, -4.811313e-01},
  {-8.321749e-01,  3.625398e-01, -4.195831e-01, -8.434248e-01,  3.674919e-01, -4.176608e-01},
  {-7.136453e-01,  6.640245e-01, -2.231185e-01, -7.187889e-01,  6.748761e-01, -2.207846e-01},
  {-6.831926e-01,  6.812031e-01, -2.630782e-01, -6.877199e-01,  6.879719e-01, -2.731264e-01},
  {-7.714605e-01,  5.087844e-01, -3.820827e-01, -7.712574e-01,  5.170905e-01, -3.982944e-01},
  {-7.399623e-01,  5.363228e-01, -4.059726e-01, -7.539814e-01,  5.408381e-01, -3.998325e-01},
  {-8.339997e-01,  1.592633e-01, -5.282799e-01, -8.423249e-01,  1.623181e-01, -5.338501e-01},
  {-8.066214e-01,  2.422443e-01, -5.391472e-01, -8.159986e-01,  2.344610e-01, -5.477499e-01},
  {-6.891712e-01,  6.058350e-01, -3.975008e-01, -6.957689e-01,  6.134603e-01, -4.005416e-01},
  {-7.949249e-01,  1.494381e-01, -5.880158e-01, -8.075439e-01,  1.467084e-01, -5.892406e-01},
  {-6.318067e-01,  6.786503e-01, -3.745051e-01, -6.440826e-01,  6.729560e-01, -3.913447e-01},
  {-6.151771e-01, -1.731791e-03, -7.883871e-01, -7.615742e-01,  1.423659e-01, -6.500112e-01},
  { 2.750854e-01,  6.643729e-01, -6.949366e-01,  2.739199e-01,  6.657884e-01, -7.089239e-01},
  {-6.056318e-01,  3.100807e-02, -7.951406e-01, -6.343459e-01,  3.204508e-02, -7.857707e-01},
  { 6.272849e-01, -3.086484e-02,  7.781780e-01, -6.354252e-01,  3.201589e-02, -7.848994e-01},
  { 2.328501e-01,  4.928296e-01, -8.383912e-01,  2.254444e-01,  4.939828e-01, -8.520758e-01},
  { 4.581444e-02,  1.728075e-01, -9.838895e-01,  4.679340e-02,  1.688005e-01, -9.950817e-01},
  {-4.739065e-01,  1.247487e-01, -8.716940e-01, -4.841774e-01,  1.205883e-01, -8.785737e-01},
  {-1.673617e-03,  1.797422e-01, -9.837123e-01,  9.196539e-03,  1.666779e-01, -9.964960e-01},
  {-1.072526e-01,  1.280690e-01, -9.859489e-01, -1.064692e-01,  1.214826e-01, -9.973836e-01},
  {-4.208188e-01,  1.301421e-01, -8.977609e-01, -4.276175e-01,  1.320370e-01, -9.058541e-01},
  { 6.055778e-01,  3.379380e-04,  7.957861e-01,  6.115482e-01, -6.032539e-03,  8.042668e-01},
  { 6.342620e-01, -1.005556e-02,  7.730528e-01,  6.429664e-01, -9.709984e-03,  7.793416e-01},
  { 5.086344e-01, -1.911011e-03,  8.609805e-01,  5.355201e-01, -1.097084e-02,  8.567200e-01},
  { 3.977984e-01,  5.321284e-02,  9.159284e-01,  4.037060e-01,  4.750240e-02,  9.250051e-01},
  { 7.426386e-01, -9.562843e-02,  6.628296e-01,  7.455877e-01, -8.662287e-02,  6.763652e-01},
  { 2.841183e-01,  7.648982e-03,  9.587587e-01,  2.340582e-01,  1.118136e-01,  9.765151e-01},
  { 1.718105e-01,  1.214180e-01,  9.776189e-01,  1.687302e-01,  1.244252e-01,  9.883898e-01},
  {-3.576127e-01,  1.207385e-01,  9.260321e-01, -3.630819e-01,  1.161298e-01,  9.357043e-01},
  { 6.617299e-03,  1.102731e-01,  9.938793e-01, -2.380882e-02,  1.145677e-01,  1.004842e+00},
  {-4.287876e-01,  1.643604e-01,  8.883281e-01, -4.338636e-01,  1.632315e-01,  8.977608e-01},
  {-4.350139e-01,  1.876718e-01,  8.806488e-01, -4.375233e-01,  1.868880e-01,  8.913490e-01},
  {-1.454113e-01,  1.175038e-01,  9.823688e-01, -1.521006e-01,  1.217145e-01,  9.914190e-01},
  {-4.534577e-01,  2.316522e-01,  8.606471e-01, -4.626472e-01,  2.283892e-01,  8.687905e-01},
  {-5.269364e-01,  2.512485e-01,  8.119189e-01, -4.887700e-01,  2.457380e-01,  8.494549e-01},
  {-5.631781e-01,  2.401837e-01,  7.906594e-01, -5.710638e-01,  2.529369e-01,  7.942069e-01},
  {-5.905431e-01,  2.191668e-01,  7.766755e-01, -5.912086e-01,  2.190856e-01,  7.895117e-01},
  {-6.253736e-01,  1.567807e-01,  7.644133e-01, -6.339602e-01,  1.760475e-01,  7.667825e-01},
  {-6.643223e-01,  1.403789e-01,  7.341455e-01, -6.659122e-01,  1.435296e-01,  7.461991e-01},
  { 9.908344e-01,  1.252122e-01, -5.068511e-02,  1.000655e+00,  1.288007e-01, -5.461797e-02},
  {-7.465314e-01,  2.613129e-01,  6.118876e-01, -7.570347e-01,  2.625959e-01,  6.154634e-01},
  { 8.615785e-01,  3.723645e-01, -3.450033e-01,  8.715487e-01,  3.719871e-01, -3.505904e-01},
  {-7.684892e-01,  2.591658e-01,  5.850276e-01, -7.779160e-01,  2.651190e-01,  5.878595e-01},
  {-8.292312e-01,  2.284010e-01,  5.101065e-01, -8.359173e-01,  2.285495e-01,  5.194798e-01},
  {-8.362301e-01,  3.978844e-01,  3.773689e-01, -8.421331e-01,  4.038920e-01,  3.854053e-01},
  { 7.431003e-01,  5.044650e-01, -4.396782e-01,  7.503542e-01,  5.088918e-01, -4.459627e-01},
  {-7.354860e-01,  6.651073e-01, -1.292007e-01, -7.466276e-01,  6.676340e-01, -1.329373e-01},
  {-8.201007e-01,  3.623128e-01, -4.429044e-01, -8.330668e-01,  3.712102e-01, -4.348094e-01},
  { 6.631568e-01,  5.734422e-01, -4.810271e-01,  6.655182e-01,  5.750473e-01, -4.972833e-01},
  {-8.016807e-01,  4.444645e-01, -3.996990e-01, -8.131106e-01,  4.502800e-01, -3.961777e-01},
  {-8.034616e-01,  3.451192e-01, -4.851207e-01, -8.160851e-01,  3.410502e-01, -4.884121e-01},
  {-6.526197e-01,  6.989377e-01, -2.925296e-01, -6.589682e-01,  7.042252e-01, -3.011488e-01},
  { 5.997887e-01,  5.977663e-01, -5.319107e-01,  5.954094e-01,  6.169375e-01, -5.351964e-01},
  { 5.931116e-01,  5.736250e-01, -5.649540e-01,  5.689651e-01,  6.296473e-01, -5.483671e-01},
  {-7.524665e-01,  2.766163e-01, -5.977271e-01, -7.620815e-01,  2.793924e-01, -6.016883e-01},
  {-7.797423e-01,  1.642760e-01, -6.041651e-01, -7.758801e-01,  1.610268e-01, -6.268462e-01},
  { 2.139532e-01,  6.555659e-01, -7.241943e-01,  2.262930e-01,  6.770590e-01, -7.150255e-01},
  {-6.185912e-01,  3.446085e-02, -7.849570e-01, -7.519882e-01,  1.566769e-01, -6.563706e-01},
  { 2.024131e-01,  6.420552e-01, -7.394552e-01,  2.102863e-01,  6.381333e-01, -7.546150e-01},
  { 2.980145e-01,  6.881499e-01, -6.615415e-01,  3.048070e-01,  6.983282e-01, -6.635591e-01},
  { 2.157360e-01,  6.003250e-01, -7.701089e-01,  2.095380e-01,  6.158221e-01, -7.731332e-01},
  {-7.166087e-01,  1.484886e-01, -6.814859e-01, -7.234910e-01,  1.456271e-01, -6.900799e-01},
  { 2.151746e-01,  5.713548e-01, -7.919934e-01,  2.149915e-01,  5.613118e-01, -8.121486e-01},
  { 4.277233e-01,  6.582212e-01, -6.195141e-01,  4.372695e-01,  6.608970e-01, -6.268113e-01},
  { 2.698536e-01,  6.229402e-01, -7.342510e-01,  3.509452e-01,  6.890739e-01, -6.503042e-01},
  { 2.066202e-01,  5.224980e-01, -8.272268e-01,  2.204124e-01,  5.221891e-01, -8.364294e-01},
  {-6.220134e-01,  9.398149e-02, -7.773460e-01, -6.289231e-01,  1.017800e-01, -7.841904e-01},
  { 2.455304e-01,  5.258394e-01, -8.143756e-01,  3.750340e-01,  6.719095e-01, -6.560668e-01},
  {-6.729769e-01,  1.271275e-01, -7.286567e-01, -6.850120e-01,  1.316741e-01, -7.309430e-01},
  { 3.966926e-01,  6.392221e-01, -6.588095e-01,  3.895939e-01,  6.599988e-01, -6.584068e-01},
  { 1.976156e-01,  4.661303e-01, -8.623633e-01,  1.940761e-01,  4.693433e-01, -8.737964e-01},
  {-5.199457e-01,  1.032710e-01, -8.479337e-01, -5.176693e-01,  1.122865e-01, -8.603898e-01},
  {-4.235563e-01,  1.624042e-01, -8.911930e-01, -4.315567e-01,  1.745314e-01, -8.967497e-01},
  { 1.491658e-01,  3.088098e-01, -9.393541e-01,  1.432697e-01,  3.237644e-01, -9.463216e-01},
  {-5.435202e-02,  1.635865e-01, -9.850307e-01, -4.887654e-02,  1.712502e-01, -9.945621e-01},
  {-2.713889e-01,  1.200510e-01, -9.549534e-01, -2.871809e-01,  1.284043e-01, -9.601584e-01},
  { 6.829903e-01, -3.755352e-03,  7.304178e-01,  6.924895e-01, -4.493106e-03,  7.370024e-01},
  { 4.491612e-01,  5.934729e-02,  8.914775e-01,  4.600911e-01,  6.201318e-02,  8.974080e-01},
  { 5.016655e-01,  6.648994e-02,  8.625027e-01,  4.980137e-01,  5.935563e-02,  8.771150e-01},
  { 3.545614e-01,  8.329082e-02,  9.313157e-01,  3.572659e-01,  8.672205e-02,  9.411213e-01},
  { 2.720356e-01,  1.199580e-01,  9.547810e-01,  2.880904e-01,  1.048173e-01,  9.627488e-01},
  {-1.188180e-01,  1.888700e-01,  9.747874e-01, -1.198633e-01,  1.879844e-01,  9.854728e-01},
  { 8.477501e-01, -4.433390e-02,  5.285397e-01,  8.542967e-01, -4.547812e-02,  5.375743e-01},
  { 1.223815e-01,  1.263972e-01,  9.844016e-01,  1.283080e-01,  1.284953e-01,  9.939273e-01},
  { 8.726801e-01, -2.677590e-02,  4.875576e-01,  8.815454e-01, -3.836131e-02,  4.922235e-01},
  {-3.850493e-01,  1.475482e-01,  9.110249e-01, -3.849981e-01,  1.458004e-01,  9.227003e-01},
  { 8.781266e-02,  1.171408e-01,  9.892254e-01,  9.051502e-02,  1.129584e-01,  9.999560e-01},
  {-2.871837e-01,  1.430781e-01,  9.471294e-01, -2.950226e-01,  1.496482e-01,  9.546862e-01},
  {-1.859703e-01,  1.214724e-01,  9.750177e-01, -1.907449e-01,  1.319807e-01,  9.833909e-01},
  {-2.168613e-01,  1.421580e-01,  9.657961e-01, -2.306635e-01,  1.353352e-01,  9.743399e-01},
  {-5.290565e-01,  2.414771e-01,  8.135035e-01, -5.403687e-01,  2.480922e-01,  8.168892e-01},
  { 9.688146e-01,  2.042837e-02,  2.469433e-01,  9.816206e-01,  2.354128e-02,  2.382183e-01},
  {-6.230745e-01,  2.119899e-01,  7.528868e-01, -6.355584e-01,  2.035179e-01,  7.586173e-01},
  { 9.849355e-01,  5.102573e-02,  1.652226e-01,  9.960448e-01,  5.038140e-02,  1.619831e-01},
  { 9.942598e-01,  8.624895e-02,  6.331416e-02,  1.003091e+00,  9.535266e-02,  7.482782e-02},
  { 9.895688e-01,  7.132417e-02,  1.251654e-01,  1.000598e+00,  6.998014e-02,  1.216093e-01},
  {-6.596979e-01,  1.877615e-01,  7.276978e-01, -6.673051e-01,  1.816002e-01,  7.365993e-01},
  { 9.912320e-01,  1.266038e-01,  3.782170e-02,  1.003030e+00,  1.176857e-01,  3.106705e-02},
  { 9.555099e-01,  2.287909e-01, -1.861599e-01,  9.652781e-01,  2.358649e-01, -1.830038e-01},
  { 9.067621e-01,  3.247817e-01, -2.688855e-01,  9.226993e-01,  3.133559e-01, -2.670564e-01},
  {-6.902757e-01,  1.783043e-01,  7.012326e-01, -6.986664e-01,  1.806359e-01,  7.071697e-01},
  { 9.707398e-01,  2.076102e-01, -1.206740e-01,  9.804976e-01,  2.062820e-01, -1.302174e-01},
  { 9.817110e-01,  1.745437e-01, -7.601312e-02,  9.921630e-01,  1.736623e-01, -7.961251e-02},
  {-7.072582e-01,  2.086338e-01,  6.754686e-01, -7.127080e-01,  2.186123e-01,  6.819891e-01},
  {-7.265767e-01,  2.539232e-01,  6.384428e-01, -7.285906e-01,  2.595265e-01,  6.501194e-01},
  {-8.191127e-01,  5.492498e-01,  1.654664e-01, -8.282310e-01,  5.542781e-01,  1.663305e-01},
  {-8.308790e-01,  5.036107e-01,  2.366779e-01, -8.427141e-01,  5.070440e-01,  2.315060e-01},
  {-7.737845e-01,  2.966538e-01,  5.596910e-01, -7.816746e-01,  2.943863e-01,  5.684847e-01},
  {-7.690970e-01,  6.387656e-01, -2.164364e-02, -7.756775e-01,  6.473133e-01, -1.300533e-02},
  {-8.213207e-01,  5.338764e-01,  2.010180e-01, -8.318917e-01,  5.354173e-01,  2.052822e-01},
  {-8.342691e-01,  4.718377e-01,  2.852443e-01, -8.393578e-01,  4.784912e-01,  2.956009e-01},
  {-8.260158e-01,  4.557525e-01,  3.316439e-01, -8.358107e-01,  4.637426e-01,  3.274420e-01},
  {-8.282113e-01,  3.756871e-01,  4.158429e-01, -8.346315e-01,  3.886323e-01,  4.161840e-01},
  {-8.320927e-01,  3.371513e-01,  4.403985e-01, -8.331329e-01,  3.393343e-01,  4.599946e-01},
  {-7.098393e-01,  6.831539e-01, -1.715483e-01, -7.094355e-01,  6.991872e-01, -1.694105e-01},
  {-8.105297e-01,  4.002593e-01, -4.275911e-01, -8.205911e-01,  4.110018e-01, -4.225694e-01},
  { 6.265675e-01,  5.989953e-01, -4.986158e-01,  6.345090e-01,  6.051475e-01, -5.020748e-01},
  {-6.340738e-01,  7.033048e-01, -3.214231e-01, -6.354709e-01,  7.194077e-01, -3.154243e-01},
  { 5.738381e-01,  6.170882e-01, -5.384347e-01,  5.474009e-01,  6.520806e-01, -5.440834e-01},
  {-8.178604e-01,  1.857391e-01, -5.446149e-01, -8.236414e-01,  1.950783e-01, -5.517377e-01},
  {-7.860552e-01,  2.220592e-01, -5.768942e-01, -7.959836e-01,  2.330382e-01, -5.770263e-01},
  {-6.518836e-01,  6.322473e-01, -4.187017e-01, -6.589738e-01,  6.395677e-01, -4.213896e-01},
  {-6.140768e-01,  6.693161e-01, -4.182412e-01, -6.183884e-01,  6.853228e-01, -4.108432e-01},
  {-7.140762e-01,  3.029010e-01, -6.311467e-01, -7.256649e-01,  3.038762e-01, -6.339779e-01},
  { 2.363102e-01,  6.923317e-01, -6.817876e-01,  2.434466e-01,  6.978586e-01, -6.889169e-01},
  {-6.043530e-01,  1.248543e-01, -7.868729e-01, -6.019484e-01,  1.139820e-01, -8.034457e-01},
  {-6.413019e-01,  1.427431e-01, -7.538942e-01, -6.501679e-01,  1.363661e-01, -7.612779e-01},
  { 3.826306e-01,  6.498069e-01, -6.567685e-01,  3.882576e-01,  6.607832e-01, -6.584092e-01},
  { 1.744848e-01,  5.201856e-01, -8.360395e-01,  1.793148e-01,  5.133774e-01, -8.515671e-01},
  {-4.172380e-01,  2.142830e-01, -8.831733e-01, -4.261690e-01,  2.159368e-01, -8.902889e-01},
  { 7.312633e-02,  2.033744e-01, -9.763665e-01,  7.089276e-02,  2.061666e-01, -9.865806e-01},
  { 9.060634e-02,  2.319374e-01, -9.685017e-01,  8.602651e-02,  2.364449e-01, -9.785528e-01},
  {-1.849284e-01,  1.318944e-01, -9.738610e-01, -1.680336e-01,  1.257905e-01, -9.883361e-01},
  {-3.787190e-01,  1.889921e-01, -9.060099e-01, -3.758965e-01,  1.932637e-01, -9.177226e-01},
  {-3.552685e-01,  1.586023e-01, -9.212109e-01, -3.484418e-01,  1.652248e-01, -9.338914e-01},
  { 5.147905e-01,  3.408970e-02,  8.566380e-01,  5.481191e-01,  3.285332e-02,  8.485575e-01},
  { 7.226580e-01,  3.771297e-03,  6.911955e-01,  7.295915e-01, -1.084361e-03,  6.989780e-01},
  {-8.256071e-02,  2.303033e-01,  9.696103e-01, -1.001698e-01,  2.388374e-01,  9.766195e-01},
  { 7.703198e-01, -5.520492e-02,  6.352636e-01,  7.778285e-01, -4.976977e-02,  6.429474e-01},
  {-1.394046e-01,  2.359121e-01,  9.617234e-01, -1.389560e-01,  2.299440e-01,  9.740016e-01},
  { 7.984821e-01, -3.300005e-02,  6.011134e-01,  8.027700e-01, -3.866842e-02,  6.123244e-01},
  {-8.416662e-02,  1.883778e-01,  9.784834e-01, -9.088705e-02,  1.913416e-01,  9.879223e-01},
  {-1.600328e-01,  1.643444e-01,  9.733347e-01, -1.535417e-01,  1.705335e-01,  9.839737e-01},
  { 5.859534e-03,  1.425134e-01,  9.897755e-01, -1.634172e-02,  1.385361e-01,  1.000702e+00},
  {-5.269265e-03,  1.014782e-01,  9.948238e-01,  6.781452e-03,  1.197265e-01,  1.003236e+00},
  {-3.317323e-01,  1.690578e-01,  9.281019e-01, -3.307147e-01,  1.703058e-01,  9.394051e-01},
  { 9.270818e-01, -2.936366e-03,  3.748475e-01,  9.381545e-01, -1.662518e-02,  3.747923e-01},
  { 9.161848e-01, -1.873477e-02,  4.003177e-01,  9.241725e-01, -1.921437e-02,  4.079402e-01},
  { 8.991761e-01, -1.822484e-02,  4.372075e-01,  9.128022e-01, -1.037085e-02,  4.330861e-01},
  {-2.557616e-01,  1.398415e-01,  9.565722e-01, -2.630700e-01,  1.447435e-01,  9.647293e-01},
  {-4.313882e-01,  2.459257e-01,  8.680004e-01, -4.337831e-01,  2.360180e-01,  8.814676e-01},
  {-5.833907e-01,  2.727348e-01,  7.650302e-01, -5.896510e-01,  2.748845e-01,  7.730497e-01},
  {-6.015628e-01,  2.733110e-01,  7.506153e-01, -6.046010e-01,  2.850022e-01,  7.576852e-01},
  {-6.376715e-01,  2.298143e-01,  7.352282e-01, -6.478592e-01,  2.289601e-01,  7.407497e-01},
  { 9.447403e-01,  2.633565e-01, -1.952156e-01,  9.525077e-01,  2.738087e-01, -1.965777e-01},
  { 9.278423e-01,  2.986330e-01, -2.234436e-01,  9.388465e-01,  2.955949e-01, -2.282015e-01},
  {-6.815177e-01,  2.381294e-01,  6.919741e-01, -6.792148e-01,  2.462506e-01,  7.063158e-01},
  { 9.716047e-01,  2.196457e-01, -8.797777e-02,  9.846262e-01,  2.070430e-01, -9.235148e-02},
  { 9.903328e-01,  1.383561e-01, -9.931195e-03,  1.000122e+00,  1.424918e-01, -1.832346e-02},
  {-6.842041e-01,  2.727364e-01,  6.763724e-01, -6.925609e-01,  2.842158e-01,  6.785538e-01},
  { 8.910176e-01,  3.416020e-01, -2.989915e-01,  8.998664e-01,  3.526516e-01, -2.945548e-01},
  {-7.884956e-01,  6.044545e-01,  1.136197e-01, -8.039646e-01,  6.018111e-01,  1.110059e-01},
  {-7.938784e-01,  3.054170e-01,  5.258113e-01, -8.028364e-01,  3.099837e-01,  5.293553e-01},
  {-8.136594e-01,  2.692284e-01,  5.152420e-01, -8.258568e-01,  2.709532e-01,  5.151673e-01},
  {-7.871169e-01,  3.947943e-01,  4.739034e-01, -8.346279e-01,  3.039159e-01,  4.815435e-01},
  {-7.421712e-01,  6.665149e-01, -7.028423e-02, -7.417185e-01,  6.803433e-01, -8.858402e-02},
  {-8.164767e-01,  4.390906e-01,  3.749205e-01, -8.221623e-01,  4.447466e-01,  3.835420e-01},
  {-6.809275e-01,  7.027335e-01, -2.061633e-01, -6.895866e-01,  7.052500e-01, -2.189855e-01},
  {-7.877545e-01,  3.751258e-01, -4.885932e-01, -7.944712e-01,  3.758932e-01, -4.983746e-01},
  { 6.069946e-01,  6.052496e-01, -5.150054e-01,  5.962538e-01,  6.343010e-01, -5.128621e-01},
  { 6.975955e-01,  4.054919e-01, -5.907088e-01,  5.835863e-01,  6.326496e-01, -5.292119e-01},
  {-2.746976e-01,  7.353153e-01,  6.195585e-01,  5.820103e-01,  6.335738e-01, -5.298415e-01},
  { 2.671422e-01, -7.628585e-01, -5.887972e-01,  5.816429e-01,  6.338587e-01, -5.299042e-01},
  { 5.658021e-01,  6.373667e-01, -5.230982e-01,  5.803130e-01,  6.339119e-01, -5.312968e-01},
  {-6.024266e-01,  7.206432e-01, -3.431552e-01, -6.035837e-01,  7.309971e-01, -3.495626e-01},
  {-7.049222e-01,  5.721496e-01, -4.192010e-01, -7.148089e-01,  5.726516e-01, -4.265901e-01},
  {-7.692323e-01,  3.482505e-01, -5.357269e-01, -7.748314e-01,  3.624730e-01, -5.376872e-01},
  { 4.622664e-01,  6.103888e-01, -6.432225e-01,  5.587379e-01,  6.532740e-01, -5.309694e-01},
  {-5.808926e-01,  7.214181e-01, -3.769877e-01, -5.868849e-01,  7.248462e-01, -3.886243e-01},
  { 2.598594e-01,  7.127338e-01, -6.515241e-01,  2.576015e-01,  7.310044e-01, -6.481928e-01},
  { 2.132292e-01,  7.144453e-01, -6.664092e-01,  2.234092e-01,  7.194085e-01, -6.733638e-01},
  {-5.720661e-01,  7.035346e-01, -4.216391e-01, -5.785283e-01,  7.076678e-01, -4.305530e-01},
  { 4.534485e-01,  6.696920e-01, -5.881302e-01,  4.535452e-01,  6.856080e-01, -5.874698e-01},
  { 3.385874e-01,  7.139559e-01, -6.128830e-01,  3.455006e-01,  7.150096e-01, -6.247172e-01},
  { 1.645196e-01,  6.261685e-01, -7.621328e-01,  1.682983e-01,  6.299090e-01, -7.718599e-01},
  { 1.739859e-01,  5.742170e-01, -8.000024e-01,  1.885299e-01,  5.781932e-01, -8.068621e-01},
  {-7.006118e-01,  1.426911e-01, -6.991297e-01, -7.000687e-01,  1.500416e-01, -7.129156e-01},
  { 3.910778e-01,  6.877040e-01, -6.116546e-01,  3.931536e-01,  6.933193e-01, -6.209831e-01},
  { 1.498628e-01,  3.802353e-01, -9.126676e-01,  1.534986e-01,  3.981591e-01, -9.158508e-01},
  { 1.696989e-01,  4.246134e-01, -8.893288e-01,  1.650923e-01,  4.259093e-01, -9.012332e-01},
  {-4.774450e-01,  1.797505e-01, -8.600791e-01, -4.807393e-01,  1.706860e-01, -8.733969e-01},
  { 1.056882e-01,  2.637284e-01, -9.587895e-01,  9.233022e-02,  2.664651e-01, -9.702289e-01},
  { 1.073950e-01,  3.023829e-01, -9.471172e-01,  1.100800e-01,  3.052502e-01, -9.568585e-01},
  { 1.131100e-01,  3.589070e-01, -9.264944e-01,  1.232968e-01,  3.549993e-01, -9.378953e-01},
  {-5.210462e-02,  2.086159e-01, -9.766087e-01, -5.743026e-02,  2.029180e-01, -9.881273e-01},
  {-2.366445e-01,  1.443382e-01, -9.608153e-01, -2.423300e-01,  1.560176e-01, -9.684010e-01},
  { 3.221603e-01,  1.094489e-01,  9.403370e-01,  3.332019e-01,  1.150991e-01,  9.468883e-01},
  {-8.305980e-02,  2.933606e-01,  9.523867e-01, -7.386995e-02,  2.738883e-01,  9.697382e-01},
  { 7.666642e-01,  2.356956e-03,  6.420440e-01,  7.718155e-01, -4.944997e-03,  6.520371e-01},
  { 8.319378e-01, -1.289177e-02,  5.547192e-01,  8.426228e-01, -1.861529e-02,  5.572410e-01},
  { 1.558493e-01,  1.694309e-01,  9.731414e-01,  1.643963e-01,  1.620736e-01,  9.836527e-01},
  {-1.833194e-01,  1.985657e-01,  9.627905e-01, -1.750942e-01,  1.870822e-01,  9.773450e-01},
  { 9.475005e-01,  2.845320e-02,  3.184858e-01,  9.572750e-01,  2.851756e-02,  3.220121e-01},
  {-5.013554e-01,  2.949993e-01,  8.133991e-01, -4.724390e-01,  2.975747e-01,  8.433487e-01},
  { 9.765887e-01,  4.929390e-02,  2.093908e-01,  9.843757e-01,  5.750666e-02,  2.204067e-01},
  { 9.895186e-01,  1.099395e-01,  9.362797e-02,  9.989393e-01,  1.171923e-01,  9.627600e-02},
  {-6.418689e-01,  2.655012e-01,  7.193841e-01, -6.388271e-01,  2.726506e-01,  7.337687e-01},
  { 9.563131e-01,  2.495974e-01, -1.522056e-01,  9.652004e-01,  2.575782e-01, -1.514147e-01},
  {-6.580318e-01,  3.007851e-01,  6.903059e-01, -6.633763e-01,  2.954021e-01,  7.025129e-01},
  { 9.817727e-01,  1.891759e-01, -1.829782e-02,  9.942737e-01,  1.791619e-01, -1.431386e-02},
  {-7.101521e-01,  2.797560e-01,  6.460809e-01, -7.174202e-01,  2.985364e-01,  6.457851e-01},
  {-7.639809e-01,  6.445199e-01,  3.045261e-02, -7.663175e-01,  6.580336e-01,  2.467397e-02},
  { 8.116320e-01,  4.640958e-01, -3.547795e-01,  8.106818e-01,  4.723923e-01, -3.748678e-01},
  {-8.043829e-01,  3.269801e-01,  4.960366e-01, -8.187596e-01,  3.210889e-01,  4.973810e-01},
  { 7.817081e-01,  4.820767e-01, -3.956446e-01,  7.887194e-01,  4.940142e-01, -3.933915e-01},
  {-8.095477e-01,  3.683453e-01,  4.571152e-01, -8.222086e-01,  3.682104e-01,  4.574361e-01},
  { 7.421957e-01,  5.651509e-01, -3.602084e-01,  7.388591e-01,  5.386061e-01, -4.299718e-01},
  {-7.066979e-01,  6.982247e-01, -1.142817e-01, -7.199769e-01,  7.000962e-01, -1.111738e-01},
  {-6.551170e-01,  7.244086e-01, -2.146019e-01, -6.639101e-01,  7.329457e-01, -2.070672e-01},
  {-7.618148e-01,  4.878842e-01, -4.261541e-01, -7.653292e-01,  4.952330e-01, -4.357459e-01},
  {-6.780451e-01,  5.928804e-01, -4.344510e-01, -6.835792e-01,  5.996593e-01, -4.404427e-01},
  {-7.269691e-01,  3.448351e-01, -5.938052e-01, -7.273853e-01,  3.580575e-01, -6.035943e-01},
  { 4.995120e-01,  6.822261e-01, -5.339056e-01,  4.968132e-01,  6.882028e-01, -5.481210e-01},
  { 1.749488e-01,  7.240862e-01, -6.671522e-01,  1.816226e-01,  7.245867e-01, -6.803424e-01},
  { 4.808764e-01,  6.703879e-01, -5.650998e-01,  4.843019e-01,  6.747017e-01, -5.754232e-01},
  {-5.205383e-01,  7.091439e-01, -4.755575e-01, -5.562594e-01,  7.167025e-01, -4.447226e-01},
  { 2.944752e-01,  7.205316e-01, -6.277887e-01,  2.891240e-01,  7.308724e-01, -6.349120e-01},
  { 1.771797e-01,  6.809665e-01, -7.105575e-01,  1.599596e-01,  6.907884e-01, -7.197930e-01},
  { 1.606020e-01,  5.413856e-01, -8.252930e-01,  1.573318e-01,  5.497200e-01, -8.330254e-01},
  {-5.563019e-01,  1.388284e-01, -8.193015e-01, -5.675993e-01,  1.507154e-01, -8.234404e-01},
  {-5.229580e-01,  1.342747e-01, -8.417156e-01, -5.380199e-01,  1.493244e-01, -8.420790e-01},
  {-2.046675e-01,  1.676476e-01, -9.643679e-01, -2.122154e-01,  1.739258e-01, -9.724099e-01},
  {-2.898693e-01,  1.676279e-01, -9.422721e-01, -2.964271e-01,  1.603360e-01, -9.525167e-01},
  {-9.513937e-02,  2.325596e-01, -9.679176e-01, -9.825214e-02,  2.273406e-01, -9.795570e-01},
  { 5.871096e-01,  2.264819e-02,  8.091905e-01,  5.826225e-01,  3.286702e-02,  8.248293e-01},
  { 6.561185e-01,  3.550815e-02,  7.538221e-01,  6.752880e-01,  3.029648e-02,  7.509611e-01},
  { 3.988947e-01,  9.636123e-02,  9.119197e-01,  3.936350e-01,  1.025316e-01,  9.248831e-01},
  { 5.213119e-01,  6.201781e-02,  8.511097e-01,  5.483301e-01,  7.042129e-02,  8.457230e-01},
  {-4.024308e-02,  2.399052e-01,  9.699618e-01, -3.696567e-02,  2.291278e-01,  9.833605e-01},
  { 7.462333e-03,  2.018640e-01,  9.793851e-01,  1.043427e-02,  2.101100e-01,  9.894984e-01},
  { 9.384890e-02,  1.584045e-01,  9.829041e-01,  9.968348e-02,  1.786592e-01,  9.894491e-01},
  { 1.318091e-01,  1.851448e-01,  9.738315e-01,  1.246904e-01,  1.857201e-01,  9.853052e-01},
  { 6.556287e-02,  1.836298e-01,  9.808066e-01,  6.149072e-02,  1.786590e-01,  9.925547e-01},
  {-5.451478e-02,  1.793867e-01,  9.822670e-01, -3.931817e-02,  1.841694e-01,  9.926726e-01},
  {-1.928880e-01,  2.151736e-01,  9.573372e-01, -1.846583e-01,  2.243441e-01,  9.676943e-01},
  { 4.571059e-02,  1.737857e-01,  9.837221e-01,  3.915145e-02,  1.711137e-01,  9.950134e-01},
  { 4.376905e-02,  1.334094e-01,  9.900940e-01,  4.831340e-02,  1.338401e-01,  1.000308e+00},
  {-2.119372e-01,  1.763067e-01,  9.612485e-01, -2.049597e-01,  1.769722e-01,  9.734129e-01},
  {-3.825453e-01,  1.871286e-01,  9.047884e-01, -3.793958e-01,  1.965514e-01,  9.155787e-01},
  {-2.613310e-01,  1.782765e-01,  9.486431e-01, -2.650157e-01,  1.738083e-01,  9.593835e-01},
  {-4.011516e-01,  2.291914e-01,  8.868758e-01, -4.083875e-01,  2.291614e-01,  8.953002e-01},
  { 9.265057e-01,  4.000525e-02,  3.741479e-01,  9.356186e-01,  4.040615e-02,  3.792957e-01},
  { 9.565312e-01,  4.599042e-02,  2.879811e-01,  9.649159e-01,  4.485659e-02,  2.963211e-01},
  { 1.866387e-01,  2.977142e-01,  9.362330e-01, -3.923488e-01,  4.573430e-01,  8.122875e-01},
  { 2.184241e-01,  2.867480e-01,  9.327735e-01, -3.951023e-01,  4.471394e-01,  8.153657e-01},
  {-2.913226e-01,  4.051900e-01,  8.665750e-01, -3.987336e-01,  4.370143e-01,  8.190791e-01},
  {-5.043878e-01,  3.127064e-01,  8.048650e-01, -4.734492e-01,  3.117924e-01,  8.363547e-01},
  {-5.321618e-01,  3.030311e-01,  7.905542e-01, -5.346999e-01,  3.035629e-01,  8.030125e-01},
  {-4.760682e-01,  3.463288e-01,  8.083411e-01, -4.895071e-01,  3.453040e-01,  8.140171e-01},
  {-4.402182e-01,  3.958457e-01,  8.059245e-01, -4.526533e-01,  4.017626e-01,  8.090433e-01},
  {-5.144614e-01,  3.335905e-01,  7.899663e-01, -5.177218e-01,  3.468916e-01,  7.952911e-01},
  { 9.807056e-01,  1.003223e-01,  1.677859e-01,  9.911060e-01,  1.011149e-01,  1.684255e-01},
  { 9.815180e-01,  1.388921e-01,  1.316490e-01,  9.926013e-01,  1.210327e-01,  1.448323e-01},
  {-4.831570e-01,  3.861689e-01,  7.857689e-01, -4.854235e-01,  3.838884e-01,  7.986566e-01},
  { 9.840044e-01,  1.545494e-01,  8.859868e-02,  9.966286e-01,  1.481013e-01,  7.537110e-02},
  {-6.244704e-01,  3.127689e-01,  7.156901e-01, -6.335554e-01,  3.117356e-01,  7.228283e-01},
  { 9.842317e-01,  1.742319e-01,  3.051533e-02,  9.938470e-01,  1.801369e-01,  2.650760e-02},
  { 8.737372e-01,  3.880146e-01, -2.933054e-01,  8.861214e-01,  3.820639e-01, -2.995020e-01},
  {-7.361478e-01,  3.107137e-01,  6.012849e-01, -7.373486e-01,  3.212754e-01,  6.115172e-01},
  {-7.194953e-01,  3.187276e-01,  6.170407e-01, -7.292028e-01,  3.176345e-01,  6.230778e-01},
  {-7.705939e-01,  6.327600e-01,  7.615524e-02, -7.698979e-01,  6.483074e-01,  8.839555e-02},
  {-7.882059e-01,  5.931822e-01,  1.639095e-01, -7.927983e-01,  6.035494e-01,  1.675020e-01},
  { 8.534031e-01,  4.125803e-01, -3.185604e-01,  8.587569e-01,  4.224110e-01, -3.240232e-01},
  {-7.696733e-01,  3.433183e-01,  5.382710e-01, -7.772793e-01,  3.436205e-01,  5.464574e-01},
  { 8.329085e-01,  4.392118e-01, -3.366847e-01,  8.433867e-01,  4.399542e-01, -3.406240e-01},
  {-7.407277e-01,  6.717882e-01, -4.806859e-03, -7.490382e-01,  6.780850e-01, -1.601978e-03},
  {-8.032627e-01,  5.461900e-01,  2.375824e-01, -8.115987e-01,  5.491299e-01,  2.462127e-01},
  {-7.893106e-01,  3.777046e-01,  4.840744e-01, -7.956587e-01,  3.734750e-01,  4.982949e-01},
  {-8.047480e-01,  5.012484e-01,  3.180106e-01, -8.144141e-01,  5.035726e-01,  3.224905e-01},
  {-8.020185e-01,  4.146420e-01,  4.299283e-01, -8.105155e-01,  4.245650e-01,  4.285601e-01},
  { 7.249824e-01,  5.912364e-01, -3.533271e-01,  7.122365e-01,  5.700225e-01, -4.364354e-01},
  {-7.791331e-01,  4.328423e-01, -4.534305e-01, -7.889775e-01,  4.296553e-01, -4.623514e-01},
  {-6.357589e-01,  7.313231e-01, -2.469357e-01, -6.362169e-01,  7.457700e-01, -2.447827e-01},
  {-6.016775e-01,  7.480192e-01, -2.800919e-01, -6.129366e-01,  7.498186e-01, -2.880015e-01},
  {-7.583691e-01,  3.979167e-01, -5.162738e-01, -7.680873e-01,  3.953892e-01, -5.239918e-01},
  {-7.171099e-01,  5.379928e-01, -4.430768e-01, -7.184922e-01,  5.526009e-01, -4.471682e-01},
  { 5.052390e-01,  5.097301e-01, -6.963539e-01,  5.507839e-01,  6.634837e-01, -5.266024e-01},
  { 5.289586e-01,  5.933003e-01, -6.067930e-01,  5.502129e-01,  6.660168e-01, -5.255965e-01},
  {-7.384999e-01,  3.784172e-01, -5.580486e-01, -7.487900e-01,  3.796740e-01, -5.621563e-01},
  { 4.472044e-01,  7.126933e-01, -5.404410e-01,  4.559627e-01,  7.119414e-01, -5.532812e-01},
  {-7.206762e-01,  2.463484e-01, -6.480265e-01, -7.325844e-01,  2.482056e-01, -6.500551e-01},
  {-6.834999e-01,  3.513978e-01, -6.398028e-01, -6.906803e-01,  3.559484e-01, -6.458490e-01},
  {-7.303124e-01,  1.950673e-01, -6.546698e-01, -7.396139e-01,  2.059582e-01, -6.568177e-01},
  { 4.134896e-01,  7.033375e-01, -5.782238e-01,  4.185536e-01,  7.139777e-01, -5.795954e-01},
  { 1.452127e-01,  6.632515e-01, -7.341736e-01,  1.252695e-01,  6.836942e-01, -7.333122e-01},
  {-6.764362e-01,  3.270581e-01, -6.598992e-01, -6.839617e-01,  3.365831e-01, -6.631497e-01},
  {-6.895549e-01,  2.818529e-01, -6.671380e-01, -6.941775e-01,  2.782845e-01, -6.793628e-01},
  { 1.199993e-01,  6.468867e-01, -7.530855e-01,  1.220411e-01,  6.511005e-01, -7.629226e-01},
  {-6.694387e-01,  1.764285e-01, -7.216127e-01, -6.779373e-01,  1.816912e-01, -7.268062e-01},
  { 1.334660e-01,  5.321242e-01, -8.360806e-01,  1.263123e-01,  5.311055e-01, -8.502048e-01},
  { 1.353893e-01,  4.861917e-01, -8.633003e-01,  1.347446e-01,  4.998668e-01, -8.680345e-01},
  {-3.936130e-01,  2.405161e-01, -8.872547e-01, -3.811194e-01,  2.539289e-01, -9.006289e-01},
  {-3.241283e-01,  2.023893e-01, -9.241101e-01, -3.269601e-01,  2.118689e-01, -9.322411e-01},
  {-1.068310e-01,  1.877698e-01, -9.763860e-01, -1.090870e-01,  1.953238e-01, -9.853005e-01},
  {-2.382215e-01,  1.693539e-01, -9.563314e-01, -2.447825e-01,  1.745574e-01, -9.646124e-01},
  { 5.943907e-01,  5.336271e-02,  8.024039e-01,  6.043389e-01,  4.648452e-02,  8.083853e-01},
  { 7.341188e-01,  3.009617e-02,  6.783538e-01,  7.429748e-01,  3.215352e-02,  6.839813e-01},
  { 3.627161e-02,  2.019438e-01,  9.787252e-01,  2.903144e-02,  2.436474e-01,  9.801317e-01},
  {-1.256559e-01,  3.125300e-01,  9.415601e-01, -1.315807e-01,  3.155925e-01,  9.507635e-01},
  { 2.060802e-01,  1.611447e-01,  9.651753e-01,  2.260341e-01,  1.674286e-01,  9.704349e-01},
  { 7.879341e-01, -4.406954e-02,  6.141807e-01,  8.342564e-01,  9.401723e-03,  5.699170e-01},
  { 8.442462e-01,  9.131716e-03,  5.358778e-01,  8.527202e-01,  8.262127e-03,  5.419205e-01},
  { 8.851924e-01,  2.214158e-02,  4.646980e-01,  8.960566e-01,  2.117508e-02,  4.663830e-01},
  { 9.023148e-01,  3.619773e-02,  4.295552e-01,  9.123910e-01,  3.175033e-02,  4.329135e-01},
  {-3.644072e-01,  4.404483e-01,  8.204954e-01, -3.666543e-01,  4.423724e-01,  8.311031e-01},
  {-3.876117e-01,  4.149472e-01,  8.231500e-01, -3.886169e-01,  4.206406e-01,  8.324055e-01},
  { 9.631697e-01,  8.470621e-02,  2.552038e-01,  9.740326e-01,  8.318779e-02,  2.553862e-01},
  {-2.079356e-01,  4.525399e-01,  8.671622e-01, -3.821129e-01,  4.854565e-01,  7.994893e-01},
  { 9.762107e-01,  7.830063e-02,  2.021925e-01,  9.836220e-01,  9.109028e-02,  2.123024e-01},
  {-4.282560e-01,  3.613689e-01,  8.282568e-01, -4.306172e-01,  3.714010e-01,  8.351583e-01},
  {-5.472441e-01,  3.264748e-01,  7.706738e-01, -5.516459e-01,  3.191209e-01,  7.840315e-01},
  {-4.252936e-01,  4.717523e-01,  7.723828e-01, -4.301172e-01,  4.796008e-01,  7.783591e-01},
  {-4.494627e-01,  4.325407e-01,  7.815957e-01, -4.532147e-01,  4.367317e-01,  7.903933e-01},
  {-5.267380e-01,  3.743839e-01,  7.631407e-01, -5.240718e-01,  3.736518e-01,  7.788394e-01},
  {-5.498981e-01,  3.610507e-01,  7.531630e-01, -5.580234e-01,  3.515629e-01,  7.658817e-01},
  { 9.822044e-01,  1.701980e-01,  7.941756e-02,  9.925274e-01,  1.803560e-01,  5.696201e-02},
  { 9.561617e-01,  2.678930e-01, -1.182711e-01,  9.654921e-01,  2.735312e-01, -1.178586e-01},
  { 8.932151e-01,  3.663428e-01, -2.606908e-01,  9.011687e-01,  3.737889e-01, -2.627971e-01},
  { 9.749642e-01,  2.187106e-01, -4.013184e-02,  9.823246e-01,  2.323429e-01, -4.404197e-02},
  {-7.434258e-01,  6.662090e-01,  5.902187e-02, -7.546871e-01,  6.690044e-01,  6.115390e-02},
  {-7.758593e-01,  3.593825e-01,  5.185428e-01, -7.840598e-01,  3.640949e-01,  5.230098e-01},
  {-8.062797e-01,  5.235831e-01,  2.752703e-01, -8.082938e-01,  5.384479e-01,  2.785525e-01},
  {-7.083206e-01,  7.029141e-01, -6.476031e-02, -7.189049e-01,  7.072897e-01, -6.146663e-02},
  { 7.448863e-01,  5.361157e-01, -3.971452e-01,  7.614581e-01,  5.332248e-01, -3.959017e-01},
  {-6.763948e-01,  7.211660e-01, -1.496988e-01, -6.764371e-01,  7.344734e-01, -1.544152e-01},
  { 6.358444e-01,  6.141978e-01, -4.674001e-01,  6.464005e-01,  6.221435e-01, -4.647456e-01},
  {-6.568387e-01,  7.357058e-01, -1.652270e-01, -6.624041e-01,  7.439539e-01, -1.691633e-01},
  {-7.433004e-01,  4.929782e-01, -4.521913e-01, -7.575375e-01,  4.849700e-01, -4.602175e-01},
  {-5.688744e-01,  7.543299e-01, -3.276710e-01, -5.781264e-01,  7.627622e-01, -3.237724e-01},
  {-6.584961e-01,  5.955124e-01, -4.601607e-01, -6.631727e-01,  6.072099e-01, -4.608257e-01},
  {-5.323228e-01,  7.469546e-01, -3.983608e-01, -5.371506e-01,  7.600776e-01, -3.932139e-01},
  {-6.394032e-01,  6.183506e-01, -4.569530e-01, -6.503190e-01,  6.203997e-01, -4.615754e-01},
  {-6.173159e-01,  6.407405e-01, -4.564785e-01, -6.257029e-01,  6.424766e-01, -4.653848e-01},
  {-5.172830e-01,  7.187225e-01, -4.646034e-01, -5.267720e-01,  7.468356e-01, -4.308291e-01},
  { 1.858008e-01,  7.524562e-01, -6.318921e-01,  1.765222e-01,  7.570908e-01, -6.453930e-01},
  {-5.601524e-01,  6.712211e-01, -4.854808e-01, -5.866359e-01,  6.738942e-01, -4.717936e-01},
  { 2.364978e-01,  7.457431e-01, -6.228451e-01,  2.474477e-01,  7.612445e-01, -6.165680e-01},
  { 3.699501e-01,  7.250246e-01, -5.809271e-01,  3.739887e-01,  7.375823e-01, -5.805053e-01},
  { 2.895547e-01,  7.519179e-01, -5.922648e-01,  3.031100e-01,  7.541793e-01, -6.001822e-01},
  { 1.221404e-01,  7.079854e-01, -6.955850e-01,  1.203011e-01,  7.204077e-01, -6.981531e-01},
  {-5.115587e-01,  7.124839e-01, -4.802858e-01, -5.293398e-01,  7.107691e-01, -4.852549e-01},
  {-6.942312e-01,  2.126247e-01, -6.876292e-01, -7.010409e-01,  2.233672e-01, -6.924643e-01},
  {-6.725791e-01,  2.695558e-01, -6.891858e-01, -6.807863e-01,  2.746755e-01, -6.942206e-01},
  { 7.723650e-02,  6.319793e-01, -7.711269e-01,  9.492731e-02,  6.447186e-01, -7.721419e-01},
  { 1.228332e-01,  6.066995e-01, -7.853838e-01,  1.138931e-01,  6.140581e-01, -7.942528e-01},
  {-6.551192e-01,  3.135207e-01, -6.874034e-01, -6.559159e-01,  3.164704e-01, -7.003431e-01},
  {-6.276975e-01,  1.725205e-01, -7.590997e-01, -6.278605e-01,  1.762450e-01, -7.717433e-01},
  { 1.205665e-01,  5.693834e-01, -8.131828e-01,  1.165530e-01,  5.785450e-01, -8.201081e-01},
  {-4.503037e-01,  2.434871e-01, -8.590347e-01, -4.643463e-01,  2.396055e-01, -8.651130e-01},
  { 1.367592e-01,  2.682306e-01, -9.535981e-01,  7.231852e-02,  3.400690e-01, -9.486814e-01},
  { 5.286016e-02,  2.884806e-01, -9.560255e-01,  5.274945e-02,  2.912614e-01, -9.660521e-01},
  { 2.981950e-02,  2.324931e-01, -9.721408e-01,  2.010994e-02,  2.373732e-01, -9.818965e-01},
  {-3.317493e-01,  2.535485e-01, -9.086559e-01, -3.414733e-01,  2.447610e-01, -9.189709e-01},
  {-1.890358e-01,  2.183242e-01, -9.573923e-01, -1.968477e-01,  2.156006e-01, -9.672821e-01},
  { 6.285991e-01,  3.212054e-02,  7.770659e-01,  6.347315e-01,  5.022782e-02,  7.845170e-01},
  { 6.655077e-01,  7.237881e-02,  7.428734e-01,  6.726661e-01,  6.476566e-02,  7.511328e-01},
  { 4.354502e-01,  1.264227e-01,  8.912914e-01,  4.394118e-01,  1.242313e-01,  9.013073e-01},
  { 7.092211e-01,  6.303719e-02,  7.021622e-01,  7.096763e-01,  6.790543e-02,  7.159775e-01},
  { 5.926734e-01,  8.281774e-02,  8.011738e-01,  5.984966e-01,  8.845280e-02,  8.092290e-01},
  { 3.652475e-01,  1.338117e-01,  9.212430e-01,  3.710088e-01,  1.392901e-01,  9.294195e-01},
  { 5.506102e-01,  9.995922e-02,  8.287560e-01,  5.518644e-01,  1.068039e-01,  8.395901e-01},
  { 4.960101e-01,  1.111381e-01,  8.611750e-01,  5.094074e-01,  1.173622e-01,  8.646401e-01},
  { 7.436293e-01,  5.390241e-02,  6.664159e-01,  7.547231e-01,  5.463918e-02,  6.695400e-01},
  { 7.963441e-02,  1.101770e-01,  9.907166e-01,  4.299215e-02,  2.504000e-01,  9.791776e-01},
  { 1.006646e-01,  2.165649e-01,  9.710644e-01,  1.076577e-01,  2.238476e-01,  9.793714e-01},
  { 1.736797e-01,  2.086022e-01,  9.624555e-01,  1.753376e-01,  2.034596e-01,  9.740267e-01},
  {-3.571708e-01,  2.171107e-01,  9.084558e-01, -3.565016e-01,  2.153790e-01,  9.205308e-01},
  {-3.224712e-01,  4.611191e-01,  8.266689e-01, -3.307079e-01,  4.674793e-01,  8.326912e-01},
  { 9.371665e-01,  7.263342e-02,  3.412382e-01,  9.496810e-01,  7.740158e-02,  3.361487e-01},
  {-4.288807e-01,  3.139443e-01,  8.470539e-01, -4.334328e-01,  3.214852e-01,  8.541908e-01},
  {-3.554479e-01,  4.842973e-01,  7.994455e-01, -3.563117e-01,  4.923531e-01,  8.075356e-01},
  {-3.748367e-01,  5.183758e-01,  7.686248e-01, -3.794306e-01,  5.150357e-01,  7.820693e-01},
  {-5.871817e-01,  3.487717e-01,  7.304628e-01, -5.935012e-01,  3.469701e-01,  7.404219e-01},
  {-4.861898e-01,  4.238494e-01,  7.641800e-01, -4.888230e-01,  4.323395e-01,  7.713584e-01},
  { 9.384555e-01,  3.047350e-01, -1.625973e-01,  9.466771e-01,  3.116052e-01, -1.661016e-01},
  {-5.668003e-01,  3.692231e-01,  7.364861e-01, -5.639602e-01,  3.816675e-01,  7.476785e-01},
  { 9.740629e-01,  2.238719e-01,  3.290739e-02,  9.875588e-01,  2.095155e-01,  4.141050e-02},
  { 8.152285e-01,  3.404971e-01, -4.684701e-01,  9.159378e-01,  3.552464e-01, -2.361002e-01},
  { 7.134340e-01,  3.774878e-01, -5.903515e-01,  9.136907e-01,  3.656061e-01, -2.338659e-01},
  { 9.655350e-01,  2.548199e-01, -5.299806e-02,  9.767203e-01,  2.538122e-01, -4.981329e-02},
  {-6.907498e-01,  3.298427e-01,  6.434817e-01, -6.924141e-01,  3.394150e-01,  6.528516e-01},
  {-7.475266e-01,  3.481483e-01,  5.656825e-01, -7.506115e-01,  3.511601e-01,  5.780340e-01},
  {-7.168875e-01,  6.966580e-01,  2.720067e-02, -7.297970e-01,  6.984255e-01,  2.141758e-02},
  {-7.148467e-01,  6.989736e-01, -2.073499e-02, -7.190647e-01,  7.096083e-01, -1.621848e-02},
  {-7.838405e-01,  5.850780e-01,  2.080332e-01, -7.841794e-01,  5.995876e-01,  2.154417e-01},
  {-7.984070e-01,  4.889716e-01,  3.513590e-01, -7.976825e-01,  4.924567e-01,  3.777120e-01},
  { 7.052628e-01,  6.114548e-01, -3.587860e-01,  6.875922e-01,  5.989449e-01, -4.351630e-01},
  {-6.287593e-01,  7.548299e-01, -1.867978e-01, -6.378624e-01,  7.631338e-01, -1.778251e-01},
  {-5.315120e-01,  7.682678e-01, -3.567347e-01, -5.399609e-01,  7.733865e-01, -3.621897e-01},
  {-6.983499e-01,  4.026726e-01, -5.917449e-01, -7.087612e-01,  3.945957e-01, -6.023381e-01},
  {-7.592496e-01,  2.193261e-01, -6.127285e-01, -7.673792e-01,  2.198271e-01, -6.194044e-01},
  { 5.078283e-01,  6.996636e-01, -5.025748e-01,  4.961332e-01,  7.048305e-01, -5.272087e-01},
  { 5.666918e-01,  6.562057e-01, -4.982515e-01,  4.915126e-01,  7.076324e-01, -5.277829e-01},
  { 5.002280e-01,  6.896669e-01, -5.235757e-01,  4.913854e-01,  7.052038e-01, -5.311413e-01},
  { 1.426294e-01,  7.553823e-01, -6.395736e-01,  1.434795e-01,  7.633862e-01, -6.461681e-01},
  {-6.720337e-01,  3.889867e-01, -6.301270e-01, -6.897981e-01,  3.860328e-01, -6.292988e-01},
  {-5.067193e-01, -7.011086e-01,  5.016795e-01,  4.929192e-01,  7.066696e-01, -5.277612e-01},
  { 4.925888e-01,  6.816950e-01, -5.409697e-01,  4.916678e-01,  7.088217e-01, -5.260397e-01},
  { 7.646687e-01, -6.316966e-01, -1.274406e-01,  4.925733e-01,  7.086061e-01, -5.254827e-01},
  {-4.862237e-01, -7.001808e-01,  5.228129e-01,  4.919391e-01,  7.074258e-01, -5.276624e-01},
  {-4.852359e-01, -7.008039e-01,  5.228959e-01,  4.917135e-01,  7.079800e-01, -5.271294e-01},
  { 1.177344e-01,  7.382390e-01, -6.641850e-01,  1.186973e-01,  7.508597e-01, -6.655812e-01},
  {-4.873584e-01,  7.550390e-01, -4.386320e-01, -4.994582e-01,  7.537805e-01, -4.508028e-01},
  { 2.361510e-01,  7.644079e-01, -5.999277e-01,  2.364977e-01,  7.735083e-01, -6.055028e-01},
  { 3.318540e-01,  7.503370e-01, -5.717231e-01,  3.291276e-01,  7.562201e-01, -5.836842e-01},
  { 7.631189e-02,  7.198043e-01, -6.899698e-01,  8.083528e-02,  7.160262e-01, -7.082719e-01},
  { 7.479323e-02,  6.806106e-01, -7.288176e-01,  7.559882e-02,  6.927907e-01, -7.315753e-01},
  { 1.079765e-01,  4.483532e-01, -8.873109e-01,  1.109797e-01,  4.464815e-01, -8.998756e-01},
  {-3.633007e-01,  2.896847e-01, -8.854916e-01, -3.681838e-01,  2.906545e-01, -8.948886e-01},
  { 7.209601e-02,  4.222578e-01, -9.036041e-01,  9.460320e-02,  4.307701e-01, -9.090609e-01},
  {-2.346574e-02,  2.418027e-01, -9.700416e-01, -2.565990e-02,  2.509020e-01, -9.783968e-01},
  {-1.529630e-01,  1.814431e-01, -9.714323e-01, -1.553434e-01,  1.913782e-01, -9.798523e-01},
  {-6.473813e-02,  2.645895e-01, -9.621857e-01, -6.096109e-02,  2.715730e-01, -9.712889e-01},
  {-1.095972e-01,  2.759143e-01, -9.549134e-01, -1.018675e-01,  2.852933e-01, -9.638985e-01},
  {-2.193250e-01,  2.174417e-01, -9.511128e-01, -2.269198e-01,  2.115216e-01, -9.615782e-01},
  { 6.308267e-01,  1.064406e-01,  7.685883e-01,  6.381872e-01,  1.042446e-01,  7.763534e-01},
  { 5.959107e-01,  1.164471e-01,  7.945631e-01,  6.066044e-01,  1.098514e-01,  8.005234e-01},
  {-3.116477e-02,  2.751359e-01,  9.609000e-01, -2.513623e-02,  2.862868e-01,  9.686448e-01},
  { 7.775918e-01,  4.033246e-02,  6.274746e-01,  7.819360e-01,  4.924532e-02,  6.386188e-01},
  { 2.919749e-01,  1.555528e-01,  9.436917e-01,  2.788295e-01,  1.724196e-01,  9.558086e-01},
  { 7.634702e-01, -5.466203e-02,  6.435257e-01,  8.139497e-01,  3.667514e-02,  5.975099e-01},
  { 1.049489e-01,  1.534277e-01,  9.825710e-01,  5.978157e-02,  2.532738e-01,  9.762911e-01},
  {-2.033571e-01,  2.801942e-01,  9.381563e-01, -2.053357e-01,  2.814147e-01,  9.496852e-01},
  {-1.938975e-01,  3.465738e-01,  9.177638e-01, -2.028802e-01,  3.363736e-01,  9.308892e-01},
  {-2.405056e-01,  2.232916e-01,  9.446152e-01, -2.705477e-01,  2.185972e-01,  9.486195e-01},
  {-3.219767e-01,  4.028635e-01,  8.567567e-01, -3.089693e-01,  4.006706e-01,  8.745642e-01},
  {-3.056349e-01,  3.721457e-01,  8.764102e-01, -3.076106e-01,  3.842818e-01,  8.823631e-01},
  {-2.915161e-01,  4.208435e-01,  8.590164e-01, -2.969586e-01,  4.286753e-01,  8.653988e-01},
  {-2.917804e-01,  2.062224e-01,  9.339896e-01, -2.868968e-01,  2.157702e-01,  9.444538e-01},
  {-3.142607e-01,  4.007316e-01,  8.606129e-01, -3.319504e-01,  4.066614e-01,  8.633056e-01},
  {-3.668250e-01,  3.795284e-01,  8.493513e-01, -3.712917e-01,  3.862928e-01,  8.578729e-01},
  {-3.798771e-01,  2.559687e-01,  8.889170e-01, -3.865313e-01,  2.537794e-01,  8.983585e-01},
  {-4.030567e-01,  2.876843e-01,  8.687826e-01, -4.060791e-01,  3.001906e-01,  8.751251e-01},
  { 9.690623e-01,  1.310490e-01,  2.091521e-01,  9.803628e-01,  1.305437e-01,  2.070273e-01},
  { 9.774902e-01,  1.486778e-01,  1.496925e-01,  9.846253e-01,  1.560179e-01,  1.644823e-01},
  {-4.596806e-01,  4.743407e-01,  7.507960e-01, -4.642515e-01,  4.825782e-01,  7.566036e-01},
  {-5.863616e-01,  3.609588e-01,  7.251819e-01, -5.949339e-01,  3.677576e-01,  7.291535e-01},
  { 9.199575e-01,  3.433689e-01, -1.891457e-01,  9.298121e-01,  3.446426e-01, -1.937941e-01},
  {-5.403730e-01,  4.174378e-01,  7.305769e-01, -5.355013e-01,  4.134286e-01,  7.504488e-01},
  { 8.521230e-01,  4.041626e-01, -3.324744e-01,  9.086180e-01,  3.768270e-01, -2.308683e-01},
  { 9.598027e-01,  2.682775e-01, -8.249841e-02,  9.674016e-01,  2.807654e-01, -7.867486e-02},
  {-6.932781e-01,  3.569579e-01,  6.260563e-01, -7.005110e-01,  3.670249e-01,  6.288342e-01},
  {-7.466937e-01,  6.543485e-01,  1.194848e-01, -7.578364e-01,  6.562258e-01,  1.261388e-01},
  {-7.622331e-01,  6.235057e-01,  1.739010e-01, -7.693063e-01,  6.319174e-01,  1.723566e-01},
  {-7.730114e-01,  5.794774e-01,  2.581848e-01, -7.808787e-01,  5.869512e-01,  2.580201e-01},
  {-7.789088e-01,  4.208711e-01,  4.649394e-01, -7.818316e-01,  4.251771e-01,  4.783502e-01},
  {-6.756330e-01,  7.310722e-01, -9.514979e-02, -6.748044e-01,  7.451908e-01, -1.009562e-01},
  {-7.729173e-01,  4.574080e-01,  4.397462e-01, -7.845436e-01,  4.753591e-01,  4.235338e-01},
  { 6.995384e-01,  5.873199e-01, -4.070645e-01,  6.928832e-01,  6.013256e-01, -4.233267e-01},
  {-7.744173e-01,  4.842250e-01,  4.071904e-01, -7.821370e-01,  4.933442e-01,  4.095159e-01},
  { 6.569354e-01,  6.190718e-01, -4.303324e-01,  6.595408e-01,  6.251734e-01, -4.416434e-01},
  {-6.001033e-01,  7.713033e-01, -2.120549e-01, -6.075663e-01,  7.765579e-01, -2.206474e-01},
  {-7.322274e-01,  4.766958e-01, -4.864196e-01, -7.522706e-01,  4.693184e-01, -4.844465e-01},
  { 5.814618e-01,  6.606526e-01, -4.748054e-01,  5.823203e-01,  6.700075e-01, -4.825734e-01},
  {-5.663428e-01,  7.755443e-01, -2.789031e-01, -5.743655e-01,  7.819716e-01, -2.819390e-01},
  { 5.496176e-01,  6.862791e-01, -4.763837e-01,  5.514210e-01,  6.867789e-01, -4.951297e-01},
  {-6.801217e-01,  5.596535e-01, -4.735214e-01, -6.963372e-01,  5.590748e-01, -4.726638e-01},
  {-7.415469e-01,  4.373741e-01, -5.087358e-01, -7.491417e-01,  4.445588e-01, -5.118723e-01},
  {-7.197533e-01,  4.275571e-01, -5.469462e-01, -7.291473e-01,  4.178440e-01, -5.609009e-01},
  {-2.123153e-01,  6.607593e-01,  7.199439e-01,  4.932401e-01,  7.057107e-01, -5.287434e-01},
  { 4.565986e-01,  7.157858e-01, -5.283640e-01,  4.903705e-01,  7.050545e-01, -5.322760e-01},
  {-5.138061e-01, -6.677045e-01,  5.386781e-01,  4.919547e-01,  7.060500e-01, -5.294874e-01},
  {-1.439121e-01,  6.758005e-01,  7.228990e-01,  4.908116e-01,  7.057720e-01, -5.309170e-01},
  { 3.850341e-01,  7.408525e-01, -5.503510e-01,  3.917446e-01,  7.491387e-01, -5.533618e-01},
  {-5.421619e-01,  6.874641e-01, -4.831704e-01, -5.459489e-01,  6.877291e-01, -4.998336e-01},
  { 1.893044e-01,  7.751565e-01, -6.027406e-01,  1.919589e-01,  7.821385e-01, -6.101559e-01},
  { 7.577203e-02,  7.442582e-01, -6.635799e-01,  8.283549e-02,  7.514524e-01, -6.703243e-01},
  {-4.757493e-01,  7.246606e-01, -4.985273e-01, -4.806273e-01,  7.243435e-01, -5.149665e-01},
  {-6.426775e-01,  3.639684e-01, -6.741607e-01, -6.412202e-01,  3.695569e-01, -6.878408e-01},
  {-6.742756e-01,  8.999576e-02, -7.329755e-01, -6.620889e-01,  2.185148e-01, -7.312647e-01},
  {-4.063247e-01,  3.469231e-01, -8.453074e-01, -6.552468e-01,  2.628037e-01, -7.228036e-01},
  {-6.299853e-01,  2.792562e-01, -7.246617e-01, -6.427034e-01,  2.869991e-01, -7.248611e-01},
  {-6.192027e-01,  3.299023e-01, -7.125674e-01, -6.323301e-01,  3.346608e-01, -7.134572e-01},
  { 7.682715e-02,  5.458395e-01, -8.343601e-01,  8.352450e-02,  5.398080e-01, -8.500036e-01},
  { 7.892113e-02,  5.913061e-01, -8.025762e-01,  8.027079e-02,  5.961857e-01, -8.117850e-01},
  {-4.277880e-01,  2.596801e-01, -8.657734e-01, -4.318440e-01,  2.788453e-01, -8.698390e-01},
  { 7.760360e-02,  5.051631e-01, -8.595278e-01,  7.468886e-02,  5.203726e-01, -8.628493e-01},
  {-5.253466e-01,  2.032554e-01, -8.262555e-01, -5.353442e-01,  2.035011e-01, -8.323790e-01},
  { 9.651608e-02,  2.122259e-01, -9.724427e-01,  2.733171e-02,  3.036558e-01, -9.645481e-01},
  { 5.958893e-02,  3.809637e-01, -9.226677e-01,  5.839669e-02,  3.890323e-01, -9.306542e-01},
  { 8.154903e-02,  4.217537e-01, -9.030357e-01,  6.862765e-02,  4.130263e-01, -9.195507e-01},
  {-2.825445e-01,  2.411525e-01, -9.284471e-01, -2.826986e-01,  2.355567e-01, -9.409891e-01},
  {-1.421080e-01,  2.443106e-01, -9.592276e-01, -1.447472e-01,  2.468830e-01, -9.690023e-01},
  { 6.915454e-01,  1.092214e-01,  7.140278e-01,  7.036299e-01,  1.060669e-01,  7.173079e-01},
  { 7.654890e-01,  5.966530e-03,  6.434213e-01,  7.975454e-01,  5.490334e-02,  6.178868e-01},
  { 2.666725e-01,  1.961371e-01,  9.436186e-01,  2.514699e-01,  1.864543e-01,  9.606591e-01},
  { 3.381879e-02,  2.813868e-01,  9.589983e-01,  5.307879e-02,  2.803922e-01,  9.692414e-01},
  { 1.058211e-01,  1.747137e-01,  9.789163e-01,  8.523937e-02,  2.682332e-01,  9.703873e-01},
  { 9.691846e-02,  2.472245e-01,  9.640990e-01,  1.045508e-01,  2.504011e-01,  9.732599e-01},
  { 2.015994e-01,  2.171601e-01,  9.550912e-01,  2.030421e-01,  2.164813e-01,  9.658041e-01},
  { 8.602828e-01,  1.054118e-01,  4.988005e-01,  8.662086e-01,  1.130781e-01,  5.077158e-01},
  { 8.689674e-01,  4.379645e-02,  4.929274e-01,  8.708544e-01,  4.235471e-02,  5.105852e-01},
  { 1.495579e-01,  2.303016e-01,  9.615579e-01,  1.573199e-01,  2.459146e-01,  9.672869e-01},
  { 8.769721e-01,  6.337856e-02,  4.763433e-01,  8.866567e-01,  7.282197e-02,  4.789741e-01},
  { 8.842080e-01,  9.294289e-02,  4.577529e-01,  8.947707e-01,  7.783122e-02,  4.628253e-01},
  {-3.163555e-01,  2.289739e-01,  9.205922e-01, -3.287532e-01,  2.272981e-01,  9.279633e-01},
  { 9.120359e-01,  7.825787e-02,  4.025744e-01,  9.183574e-01,  8.241528e-02,  4.131679e-01},
  {-3.533969e-01,  3.466274e-01,  8.688844e-01, -3.762091e-01,  3.517274e-01,  8.692608e-01},
  { 9.455082e-01,  1.036639e-01,  3.086553e-01,  9.524146e-01,  1.107584e-01,  3.186226e-01},
  {-3.263113e-01,  5.077963e-01,  7.972853e-01, -3.342936e-01,  5.108535e-01,  8.050708e-01},
  {-4.163274e-01,  5.275943e-01,  7.404835e-01, -4.251082e-01,  5.277166e-01,  7.494395e-01},
  { 9.725388e-01,  2.191250e-01,  7.843766e-02,  9.826354e-01,  2.213328e-01,  7.951950e-02},
  { 9.759008e-01,  1.832770e-01,  1.184360e-01,  9.840599e-01,  1.947629e-01,  1.207351e-01},
  {-6.423876e-01,  3.543643e-01,  6.795322e-01, -6.407842e-01,  3.697776e-01,  6.881252e-01},
  {-5.024090e-01,  4.367970e-01,  7.461860e-01, -5.162519e-01,  4.427148e-01,  7.472258e-01},
  {-5.653775e-01,  4.009680e-01,  7.208140e-01, -5.715899e-01,  4.007717e-01,  7.304276e-01},
  { 9.464523e-01,  3.053618e-01, -1.047964e-01,  9.545289e-01,  3.131489e-01, -1.081554e-01},
  {-7.196724e-01,  3.695483e-01,  5.877973e-01, -7.344576e-01,  3.818102e-01,  5.793515e-01},
  { 9.682673e-01,  2.498937e-01, -3.435110e-03,  9.737340e-01,  2.696153e-01, -5.849943e-03},
  {-7.536438e-01,  6.378720e-01,  1.585574e-01, -7.580522e-01,  6.477988e-01,  1.630111e-01},
  {-6.796923e-01,  7.321424e-01, -4.456452e-02, -6.822369e-01,  7.439277e-01, -4.457102e-02},
  { 7.744743e-01,  5.226659e-01, -3.563845e-01,  7.793835e-01,  5.277903e-01, -3.681716e-01},
  {-6.391801e-01,  7.609003e-01, -1.117119e-01, -6.571078e-01,  7.582294e-01, -1.189972e-01},
  {-7.707523e-01,  5.521947e-01,  3.178398e-01, -7.819306e-01,  5.533845e-01,  3.212587e-01},
  {-7.649621e-01,  5.282902e-01,  3.684326e-01, -7.827130e-01,  5.222043e-01,  3.681296e-01},
  { 6.173279e-01,  6.438124e-01, -4.521193e-01,  6.278864e-01,  6.525701e-01, -4.481021e-01},
  {-5.288475e-01,  7.886679e-01, -3.135652e-01, -5.295460e-01,  7.954373e-01, -3.282174e-01},
  {-4.902794e-01,  7.801481e-01, -3.885809e-01, -4.934479e-01,  7.929786e-01, -3.854361e-01},
  {-4.574246e-01,  7.895868e-01, -4.090421e-01, -4.708230e-01,  7.886288e-01, -4.210199e-01},
  {-4.536680e-01,  7.582648e-01, -4.682093e-01, -4.505145e-01,  7.786911e-01, -4.599399e-01},
  { 2.068989e-01,  7.926274e-01, -5.735283e-01,  2.222086e-01,  7.919803e-01, -5.867454e-01},
  { 9.292533e-02,  7.745143e-01, -6.256935e-01,  9.924676e-02,  7.792081e-01, -6.355017e-01},
  {-4.234970e-01,  7.538090e-01, -5.024164e-01, -4.368409e-01,  7.582508e-01, -5.050679e-01},
  { 2.988796e-02,  7.163144e-01, -6.971372e-01,  3.195198e-02,  7.238342e-01, -7.042152e-01},
  {-6.448340e-01,  1.543872e-01, -7.485676e-01, -6.558599e-01,  2.498943e-01, -7.268147e-01},
  {-4.720577e-01,  2.558930e-01, -8.436114e-01, -6.558397e-01,  2.553387e-01, -7.260789e-01},
  {-6.719120e-01, -1.260081e-01, -7.298331e-01, -6.403219e-01,  2.170990e-01, -7.520726e-01},
  {-6.433004e-01, -3.737855e-01, -6.681685e-01, -6.348152e-01,  2.158222e-01, -7.558370e-01},
  { 3.125846e-02,  6.455960e-01, -7.630391e-01,  3.528823e-02,  6.521389e-01, -7.709378e-01},
  {-6.486904e-01, -5.240353e-03, -7.610343e-01, -6.126034e-01,  2.119140e-01, -7.750285e-01},
  {-5.929153e-01,  2.048528e-01, -7.787726e-01, -5.877729e-01,  2.013858e-01, -7.980230e-01},
  { 5.161868e-02,  5.784432e-01, -8.140878e-01,  5.359567e-02,  5.879193e-01, -8.199717e-01},
  {-3.962346e-01,  3.076084e-01, -8.650868e-01, -3.978135e-01,  3.038875e-01, -8.776454e-01},
  {-5.005148e-01,  2.486664e-01, -8.292466e-01, -5.039060e-01,  2.495355e-01, -8.394480e-01},
  {-4.655237e-01,  2.774007e-01, -8.404383e-01, -4.693449e-01,  2.740240e-01, -8.517565e-01},
  {-3.330747e-01,  3.047510e-01, -8.922937e-01, -3.444653e-01,  3.055793e-01, -8.993500e-01},
  { 2.740241e-02,  3.599518e-01, -9.325684e-01,  2.533398e-02,  3.480396e-01, -9.494714e-01},
  { 1.002218e-01,  1.804814e-01, -9.784591e-01,  4.206138e-03,  2.808316e-01, -9.705603e-01},
  {-2.610792e-01,  2.093788e-01, -9.423366e-01, -2.503363e-01,  2.212130e-01, -9.535528e-01},
  { 6.613362e-01,  1.186749e-01,  7.406421e-01,  6.689560e-01,  1.199698e-01,  7.476500e-01},
  { 3.152216e-01,  1.876211e-01,  9.302868e-01,  3.171664e-01,  1.799303e-01,  9.422844e-01},
  { 7.523627e-01,  9.549247e-02,  6.517910e-01,  7.627357e-01,  9.675480e-02,  6.555530e-01},
  { 5.655411e-01,  1.454546e-01,  8.117920e-01,  5.820645e-01,  1.461708e-01,  8.128400e-01},
  {-1.240111e-01,  3.485479e-01,  9.290509e-01, -1.475166e-01,  3.617708e-01,  9.317855e-01},
  { 8.350170e-01,  1.840160e-01,  5.185410e-01,  8.177379e-01,  9.417581e-02,  5.859298e-01},
  { 8.306183e-01,  1.097164e-01,  5.459263e-01,  8.408676e-01,  1.001711e-01,  5.511679e-01},
  { 8.444412e-01,  6.524763e-02,  5.316594e-01,  8.532673e-01,  6.563529e-02,  5.377586e-01},
  {-2.297079e-01,  3.479876e-01,  9.089219e-01, -2.266861e-01,  3.584559e-01,  9.170524e-01},
  {-2.769378e-01,  2.664625e-01,  9.232027e-01, -2.756124e-01,  2.704669e-01,  9.336733e-01},
  {-2.575128e-01,  3.886809e-01,  8.846549e-01, -2.617477e-01,  4.128434e-01,  8.842573e-01},
  {-3.071771e-01,  3.379234e-01,  8.896347e-01, -3.085423e-01,  3.361711e-01,  9.014718e-01},
  { 8.963198e-01,  1.186630e-01,  4.272353e-01,  9.033346e-01,  1.197608e-01,  4.364909e-01},
  { 9.208843e-01,  1.197408e-01,  3.709908e-01,  9.324630e-01,  1.135773e-01,  3.721478e-01},
  { 9.541181e-01,  1.346426e-01,  2.674512e-01,  9.626238e-01,  1.405256e-01,  2.729287e-01},
  { 9.609753e-01,  1.620868e-01,  2.241749e-01,  9.720926e-01,  1.618563e-01,  2.229823e-01},
  {-4.494353e-01,  5.212097e-01,  7.254986e-01, -4.449270e-01,  5.308627e-01,  7.355855e-01},
  {-6.067163e-01,  3.916856e-01,  6.917208e-01, -6.115285e-01,  3.944439e-01,  7.009306e-01},
  {-4.898103e-01,  4.840018e-01,  7.251400e-01, -4.871274e-01,  4.878553e-01,  7.386230e-01},
  { 8.757747e-01,  4.157887e-01, -2.452313e-01,  8.905131e-01,  4.111970e-01, -2.424645e-01},
  {-6.790757e-01,  3.824488e-01,  6.265694e-01, -6.818313e-01,  3.935506e-01,  6.333086e-01},
  { 9.535105e-01,  3.002197e-01, -2.618804e-02,  9.649104e-01,  2.989069e-01, -2.207973e-02},
  { 8.492474e-01,  4.433715e-01, -2.867064e-01,  8.639606e-01,  4.450758e-01, -2.763429e-01},
  {-7.222704e-01,  6.871904e-01,  7.806988e-02, -7.309070e-01,  6.932147e-01,  7.803077e-02},
  {-7.514141e-01,  4.025822e-01,  5.227852e-01, -7.543998e-01,  4.231800e-01,  5.227953e-01},
  {-6.472508e-01,  7.603236e-01, -5.453731e-02, -6.572028e-01,  7.653496e-01, -5.645369e-02},
  {-7.556512e-01,  4.523856e-01,  4.736437e-01, -7.668737e-01,  4.551628e-01,  4.749601e-01},
  {-5.746456e-01,  7.852920e-01, -2.304319e-01, -5.729249e-01,  7.991541e-01, -2.323252e-01},
  {-7.096308e-01,  5.071568e-01, -4.890971e-01, -7.157672e-01,  5.174100e-01, -4.907387e-01},
  {-4.816895e-01,  7.995259e-01, -3.587947e-01, -4.918543e-01,  8.040225e-01, -3.639973e-01},
  {-6.126404e-01,  6.114461e-01, -5.008048e-01, -6.285654e-01,  6.140140e-01, -4.987536e-01},
  {-4.406054e-01,  7.889325e-01, -4.283133e-01, -4.424907e-01,  7.966642e-01, -4.363440e-01},
  { 4.299737e-01,  7.353874e-01, -5.237632e-01,  4.202409e-01,  7.501534e-01, -5.306126e-01},
  {-5.663797e-01,  6.430284e-01, -5.154885e-01, -5.688089e-01,  6.594992e-01, -5.122322e-01},
  { 4.452324e-01,  7.724070e-01, -4.529410e-01,  3.830118e-01,  7.702634e-01, -5.299796e-01},
  { 1.439842e-01,  7.974877e-01, -5.859026e-01,  1.394476e-01,  8.013700e-01, -5.993655e-01},
  { 2.921613e-01,  7.812540e-01, -5.516195e-01,  2.868718e-01,  7.923388e-01, -5.574805e-01},
  { 2.569008e-01,  7.916887e-01, -5.542843e-01,  2.597250e-01,  7.968580e-01, -5.643052e-01},
  { 3.100810e-02,  7.558808e-01, -6.539745e-01,  2.522458e-02,  7.674740e-01, -6.566761e-01},
  {-4.476630e-01,  7.153016e-01, -5.366018e-01, -4.482955e-01,  7.268472e-01, -5.399923e-01},
  {-6.056130e-01,  2.164972e-01, -7.657427e-01, -6.600990e-01,  2.350077e-01, -7.279420e-01},
  {-6.337661e-01,  4.028798e-01, -6.603245e-01, -6.305305e-01,  4.062482e-01, -6.769451e-01},
  {-1.414330e-03,  6.839992e-01, -7.294813e-01,  3.219392e-03,  6.948335e-01, -7.335336e-01},
  { 4.065212e-02,  6.034433e-01, -7.963691e-01,  3.493224e-02,  6.059113e-01, -8.077910e-01},
  {-4.142942e-02,  2.946261e-01, -9.547141e-01, -4.363763e-02,  3.033548e-01, -9.627785e-01},
  {-2.237438e-01,  2.707278e-01, -9.362933e-01, -2.293227e-01,  2.675835e-01, -9.469305e-01},
  {-1.877058e-01,  2.631790e-01, -9.463104e-01, -1.811877e-01,  2.768949e-01, -9.546562e-01},
  {-9.181833e-02,  3.109578e-01, -9.459781e-01, -9.956261e-02,  3.097739e-01, -9.565549e-01},
  { 4.850695e-01,  1.576696e-01,  8.601442e-01,  4.870772e-01,  1.523257e-01,  8.720234e-01},
  { 3.715349e-01,  1.675923e-01,  9.131674e-01,  3.811304e-01,  1.727221e-01,  9.199229e-01},
  { 7.182128e-01,  1.304969e-01,  6.834772e-01,  7.280434e-01,  1.258550e-01,  6.891950e-01},
  { 5.330997e-01,  1.471951e-01,  8.331496e-01,  5.453449e-01,  1.529377e-01,  8.367092e-01},
  { 7.701690e-01,  1.153860e-01,  6.273162e-01,  7.777507e-01,  1.186521e-01,  6.339582e-01},
  { 8.127934e-01,  1.658003e-01,  5.584597e-01,  7.982141e-01,  1.157799e-01,  6.085451e-01},
  { 8.417127e-01,  1.128465e-01,  5.280013e-01,  8.357154e-01,  7.536810e-02,  5.628301e-01},
  {-1.845353e-01,  3.884799e-01,  9.027902e-01, -1.851893e-01,  3.832249e-01,  9.163552e-01},
  { 8.212506e-01,  1.511601e-01,  5.501799e-01,  8.344368e-01,  1.498075e-01,  5.496835e-01},
  {-2.459203e-01,  2.878905e-01,  9.255497e-01, -2.578177e-01,  2.945217e-01,  9.314762e-01},
  { 8.434218e-01,  1.524352e-01,  5.151730e-01,  8.523662e-01,  1.537604e-01,  5.202971e-01},
  { 1.439769e-01,  1.911590e-01,  9.709423e-01,  1.265024e-01,  2.799599e-01,  9.638048e-01},
  { 8.649519e-01,  1.424990e-01,  4.811989e-01,  8.695094e-01,  1.523512e-01,  4.915510e-01},
  {-2.788252e-01,  3.248635e-01,  9.037258e-01, -2.851373e-01,  3.243208e-01,  9.135391e-01},
  {-2.972188e-01,  4.716909e-01,  8.301619e-01, -2.914179e-01,  4.868678e-01,  8.360013e-01},
  { 9.327725e-01,  1.531117e-01,  3.263313e-01,  9.454286e-01,  1.444228e-01,  3.258658e-01},
  {-3.745815e-01,  5.599149e-01,  7.390425e-01, -3.788392e-01,  5.626042e-01,  7.488790e-01},
  { 9.665999e-01,  1.868702e-01,  1.753971e-01,  9.753056e-01,  1.925976e-01,  1.804667e-01},
  { 9.638829e-01,  2.317759e-01,  1.311858e-01,  9.760416e-01,  2.272549e-01,  1.287707e-01},
  {-5.899761e-01,  4.195884e-01,  6.898360e-01, -5.971491e-01,  4.239273e-01,  6.961006e-01},
  { 9.250773e-01,  3.522663e-01, -1.419169e-01,  9.334242e-01,  3.589329e-01, -1.441242e-01},
  {-6.418695e-01,  3.969626e-01,  6.560673e-01, -6.570297e-01,  3.982644e-01,  6.561659e-01},
  { 9.600751e-01,  2.783739e-01,  2.763978e-02,  9.674198e-01,  2.899306e-01,  3.039235e-02},
  {-7.157844e-01,  4.151269e-01,  5.615357e-01, -7.306021e-01,  4.128739e-01,  5.626822e-01},
  {-6.724722e-01,  7.401021e-01,  5.475815e-03, -6.781389e-01,  7.489607e-01,  6.891134e-03},
  {-7.484983e-01,  6.229830e-01,  2.272495e-01, -7.534329e-01,  6.325804e-01,  2.303032e-01},
  {-7.415912e-01,  6.042114e-01,  2.914980e-01, -7.594384e-01,  5.999311e-01,  2.901620e-01},
  {-7.367585e-01,  5.175782e-01,  4.350858e-01, -7.443073e-01,  5.265909e-01,  4.353914e-01},
  {-5.315344e-01,  8.042753e-01, -2.657301e-01, -5.461565e-01,  8.110843e-01, -2.544035e-01},
  {-4.963822e-01,  8.038874e-01, -3.276733e-01, -4.922795e-01,  8.137281e-01, -3.411370e-01},
  {-6.854216e-01,  4.455208e-01, -5.759414e-01, -6.938544e-01,  4.525061e-01, -5.785020e-01},
  { 3.265954e-01,  7.766204e-01, -5.386986e-01,  3.394466e-01,  7.843709e-01, -5.389060e-01},
  { 5.553304e-02,  7.953406e-01, -6.036136e-01,  4.742102e-02,  8.066053e-01, -6.066431e-01},
  { 1.317825e-02,  7.988548e-01, -6.013795e-01,  2.529760e-02,  8.055249e-01, -6.093983e-01},
  {-2.567015e-02,  7.745154e-01, -6.320341e-01, -2.352992e-02,  7.876869e-01, -6.323537e-01},
  {-5.217786e-01,  6.683329e-01, -5.301681e-01, -5.292963e-01,  6.772968e-01, -5.310179e-01},
  {-6.902456e-02,  7.814283e-01, -6.201656e-01, -7.337045e-02,  7.841337e-01, -6.329499e-01},
  {-1.799265e-02,  7.478375e-01, -6.636379e-01, -1.960117e-02,  7.611960e-01, -6.641324e-01},
  {-6.738812e-02,  7.524316e-01, -6.552141e-01, -6.690010e-02,  7.661242e-01, -6.553265e-01},
  {-4.843614e-01,  6.959951e-01, -5.300801e-01, -4.843942e-01,  7.018011e-01, -5.419447e-01},
  {-5.349271e-02,  7.400830e-01, -6.703848e-01, -5.526468e-02,  7.413161e-01, -6.843031e-01},
  {-1.065556e-01,  7.518326e-01, -6.506871e-01, -1.064777e-01,  7.580214e-01, -6.594999e-01},
  {-4.160787e-01,  7.180063e-01, -5.579835e-01, -4.289498e-01,  7.284436e-01, -5.533893e-01},
  {-5.868433e-01,  2.537794e-01, -7.689024e-01, -6.544083e-01,  2.380869e-01, -7.320679e-01},
  {-3.863693e-01,  7.444876e-01, -5.444786e-01, -4.000037e-01,  7.403399e-01, -5.592515e-01},
  {-2.471619e-02,  7.166670e-01, -6.969774e-01, -3.228449e-02,  7.165390e-01, -7.116211e-01},
  {-5.946835e-01,  3.830695e-01, -7.068304e-01, -6.010979e-01,  3.910915e-01, -7.117515e-01},
  { 3.578415e-03,  6.074685e-01, -7.943357e-01,  1.245179e-02,  6.163155e-01, -8.005466e-01},
  { 4.550046e-02,  4.669349e-01, -8.831203e-01,  4.290778e-02,  4.788732e-01, -8.886582e-01},
  { 3.444627e-02,  4.339225e-01, -9.002915e-01,  3.004180e-02,  4.268663e-01, -9.152901e-01},
  {-2.827396e-01,  2.939061e-01, -9.130594e-01, -2.824687e-01,  3.078421e-01, -9.199518e-01},
  {-1.568699e-01,  3.080549e-01, -9.383464e-01, -1.674481e-01,  3.125542e-01, -9.461182e-01},
  { 4.412946e-01,  1.769242e-01,  8.797482e-01,  4.431038e-01,  1.837351e-01,  8.892537e-01},
  { 3.651550e-01,  2.049935e-01,  9.080966e-01,  3.601073e-01,  1.954012e-01,  9.235862e-01},
  {-6.855246e-03,  3.292064e-01,  9.442331e-01, -1.951761e-02,  3.322468e-01,  9.539898e-01},
  {-7.571179e-02,  3.336779e-01,  9.396418e-01, -7.504306e-02,  3.525228e-01,  9.439073e-01},
  { 2.899120e-02,  3.116660e-01,  9.497494e-01,  3.706641e-02,  3.149807e-01,  9.593118e-01},
  {-1.646776e-01,  3.854316e-01,  9.079227e-01, -1.586124e-01,  3.840919e-01,  9.209665e-01},
  {-2.625972e-01,  3.269135e-01,  9.078383e-01, -2.649222e-01,  3.216718e-01,  9.204372e-01},
  { 1.570892e-01,  2.210254e-01,  9.625335e-01,  1.543677e-01,  2.816795e-01,  9.579639e-01},
  { 8.771627e-01,  1.502746e-01,  4.560736e-01,  8.878369e-01,  1.551132e-01,  4.566900e-01},
  {-2.241397e-01,  4.501891e-01,  8.643444e-01, -2.409023e-01,  4.426468e-01,  8.757243e-01},
  {-2.248246e-01,  4.744412e-01,  8.510931e-01, -2.554305e-01,  4.621700e-01,  8.617428e-01},
  {-3.422416e-01,  2.586409e-01,  9.033136e-01, -3.436940e-01,  2.651240e-01,  9.124748e-01},
  {-3.521589e-01,  3.008436e-01,  8.862715e-01, -3.570180e-01,  3.028226e-01,  8.953748e-01},
  {-2.401784e-01,  5.054203e-01,  8.287730e-01, -2.657122e-01,  5.009320e-01,  8.362582e-01},
  {-2.878768e-01,  5.295194e-01,  7.979575e-01, -2.994168e-01,  5.215203e-01,  8.119294e-01},
  {-3.272165e-01,  5.433446e-01,  7.731146e-01, -3.373791e-01,  5.513876e-01,  7.765372e-01},
  { 9.522197e-01,  2.126198e-01,  2.192498e-01,  9.672512e-01,  1.954730e-01,  2.170214e-01},
  {-4.837039e-01,  5.184336e-01,  7.051647e-01, -4.939424e-01,  5.186252e-01,  7.126774e-01},
  { 9.569134e-01,  2.817171e-01,  7.037196e-02,  9.679227e-01,  2.808904e-01,  7.148939e-02},
  {-5.377087e-01,  4.496560e-01,  7.132172e-01, -5.361680e-01,  4.616878e-01,  7.212677e-01},
  {-6.698626e-01,  4.329680e-01,  6.031772e-01, -6.792197e-01,  4.276356e-01,  6.137140e-01},
  { 9.349108e-01,  3.472567e-01, -7.317519e-02,  9.486592e-01,  3.442932e-01, -6.919286e-02},
  { 8.150843e-01,  4.918471e-01, -3.061437e-01,  8.277394e-01,  4.989008e-01, -2.981951e-01},
  {-6.882628e-01,  7.229945e-01,  5.977802e-02, -6.909512e-01,  7.350259e-01,  5.643334e-02},
  {-7.189201e-01,  4.588637e-01,  5.221093e-01, -7.277362e-01,  4.619534e-01,  5.271198e-01},
  {-7.397152e-01,  6.187848e-01,  2.644369e-01, -7.517234e-01,  6.225680e-01,  2.611121e-01},
  {-7.346190e-01,  4.833994e-01,  4.760883e-01, -7.442089e-01,  4.878662e-01,  4.785354e-01},
  { 7.270103e-01,  5.710371e-01, -3.812779e-01,  7.383160e-01,  5.793466e-01, -3.743426e-01},
  {-5.976448e-01,  7.930094e-01, -1.181384e-01, -5.988537e-01,  8.050511e-01, -1.188752e-01},
  {-7.496801e-01,  5.551823e-01,  3.602115e-01, -7.554699e-01,  5.652204e-01,  3.614535e-01},
  {-5.742738e-01,  8.017332e-01, -1.656309e-01, -5.797140e-01,  8.110197e-01, -1.644493e-01},
  { 5.848036e-01,  6.820041e-01, -4.391755e-01,  6.003316e-01,  6.827909e-01, -4.407753e-01},
  { 5.262346e-01,  7.187316e-01, -4.544251e-01,  5.392689e-01,  7.182838e-01, -4.627538e-01},
  {-6.997505e-01,  4.844646e-01, -5.250174e-01, -7.062176e-01,  4.886593e-01, -5.322866e-01},
  { 4.515055e-01,  7.483242e-01, -4.859565e-01,  4.489258e-01,  7.587281e-01, -4.936398e-01},
  {-3.917253e-01,  7.979649e-01, -4.580429e-01, -3.960458e-01,  8.122845e-01, -4.518964e-01},
  { 4.053488e-01,  7.699543e-01, -4.928112e-01,  4.052391e-01,  7.778116e-01, -5.016698e-01},
  {-6.576191e-01,  4.314907e-01, -6.175377e-01, -6.527316e-01,  4.555182e-01, -6.223390e-01},
  { 5.015877e-01,  7.896799e-01, -3.532921e-01,  3.617468e-01,  7.930541e-01, -5.129209e-01},
  { 1.687153e-01,  8.172771e-01, -5.509930e-01,  1.657232e-01,  8.256159e-01, -5.583665e-01},
  { 8.914587e-02,  8.140594e-01, -5.738992e-01,  9.724325e-02,  8.243237e-01, -5.761182e-01},
  {-2.739428e-02,  8.029193e-01, -5.954580e-01, -2.784840e-02,  8.123325e-01, -6.001800e-01},
  {-1.003743e-01,  7.955577e-01, -5.975056e-01, -9.488452e-02,  8.036229e-01, -6.050302e-01},
  {-3.740369e-01,  7.767568e-01, -5.067003e-01, -3.687348e-01,  7.950416e-01, -5.028051e-01},
  {-3.539290e-01,  7.400044e-01, -5.719509e-01, -3.543428e-01,  7.486692e-01, -5.786234e-01},
  {-8.663703e-02,  7.160777e-01, -6.926231e-01, -9.471234e-02,  7.168314e-01, -7.057309e-01},
  {-6.361380e-02,  6.893909e-01, -7.215909e-01, -6.804457e-02,  6.979087e-01, -7.274389e-01},
  {-2.669495e-02,  6.559910e-01, -7.542965e-01, -2.504795e-02,  6.598075e-01, -7.647883e-01},
  {-5.763073e-01,  3.425816e-01, -7.419620e-01, -5.935678e-01,  3.380929e-01, -7.444673e-01},
  {-5.720965e-01,  2.888229e-01, -7.676503e-01, -5.433195e-01,  2.612643e-01, -8.108060e-01},
  {-4.281970e-01,  3.175772e-01, -8.460449e-01, -4.391293e-01,  3.185000e-01, -8.524008e-01},
  { 9.258886e-03,  3.931006e-01, -9.194489e-01,  7.476663e-03,  3.859351e-01, -9.337402e-01},
  {-3.533585e-02,  3.615729e-01, -9.316740e-01, -2.680602e-02,  3.579711e-01, -9.444627e-01},
  {-5.104052e-02,  3.385974e-01, -9.395460e-01, -3.826199e-02,  3.439934e-01, -9.492502e-01},
  {-2.282671e-01,  3.103270e-01, -9.228171e-01, -2.248271e-01,  3.131774e-01, -9.339381e-01},
  { 4.065248e-01,  1.759525e-01,  8.965369e-01,  4.124516e-01,  1.836233e-01,  9.039012e-01},
  { 5.274814e-01,  1.792024e-01,  8.304516e-01,  5.442262e-01,  1.807424e-01,  8.318796e-01},
  { 7.440291e-01,  1.446725e-01,  6.522964e-01,  7.527095e-01,  1.512542e-01,  6.568317e-01},
  { 6.379345e-01,  2.440243e-01,  7.304052e-01,  6.124716e-01,  1.668335e-01,  7.860788e-01},
  { 7.941180e-01,  1.558437e-01,  5.874430e-01,  8.056876e-01,  1.577498e-01,  5.889491e-01},
  { 2.175772e-01,  2.941686e-02,  9.755997e-01,  2.735219e-01,  2.570417e-01,  9.380751e-01},
  { 1.988311e-01, -4.058340e-02,  9.791932e-01,  2.588004e-01,  2.621261e-01,  9.408409e-01},
  { 2.231589e-01,  1.461285e-01,  9.637669e-01,  2.471119e-01,  2.673158e-01,  9.437847e-01},
  {-1.995277e-01,  3.940443e-01,  8.971722e-01, -1.899371e-01,  4.085899e-01,  9.043460e-01},
  { 1.899747e-01,  2.775348e-01,  9.417452e-01,  1.933395e-01,  2.876208e-01,  9.490851e-01},
  {-3.085567e-01,  2.825823e-01,  9.082621e-01, -3.064616e-01,  2.834752e-01,  9.200995e-01},
  { 8.973852e-01,  1.596798e-01,  4.113419e-01,  9.045347e-01,  1.618299e-01,  4.201296e-01},
  { 9.415208e-01,  1.902483e-01,  2.781082e-01,  9.542420e-01,  1.841576e-01,  2.763884e-01},
  { 9.549496e-01,  2.332557e-01,  1.834748e-01,  9.672922e-01,  2.385739e-01,  1.682616e-01},
  {-6.368315e-01,  4.192048e-01,  6.470804e-01, -6.353662e-01,  4.256107e-01,  6.603197e-01},
  { 9.053192e-01,  3.885015e-01, -1.716498e-01,  9.128038e-01,  3.976747e-01, -1.718422e-01},
  { 9.466615e-01,  3.204515e-01,  3.380604e-02,  9.574364e-01,  3.205426e-01,  3.811326e-02},
  {-6.895484e-01,  4.473274e-01,  5.695798e-01, -6.966942e-01,  4.514240e-01,  5.759254e-01},
  {-7.091502e-01,  6.946142e-01,  1.209016e-01, -7.166395e-01,  7.016629e-01,  1.223002e-01},
  {-7.193088e-01,  6.739981e-01,  1.682899e-01, -7.334886e-01,  6.727504e-01,  1.739571e-01},
  {-7.297817e-01,  6.518310e-01,  2.062403e-01, -7.364835e-01,  6.568264e-01,  2.168647e-01},
  {-6.183564e-01,  7.851622e-01, -3.399651e-02, -6.297848e-01,  7.893714e-01, -3.357430e-02},
  {-7.106710e-01,  5.144314e-01,  4.799032e-01, -7.177636e-01,  5.166608e-01,  4.886044e-01},
  {-6.116037e-01,  7.884362e-01, -6.564470e-02, -6.071524e-01,  8.042096e-01, -7.400622e-02},
  {-5.950789e-01,  7.981548e-01, -9.396819e-02, -5.986962e-01,  8.083049e-01, -9.523766e-02},
  {-7.277117e-01,  5.888807e-01,  3.516464e-01, -7.389589e-01,  5.917770e-01,  3.529842e-01},
  {-5.353467e-01,  8.213524e-01, -1.969368e-01, -5.484194e-01,  8.226715e-01, -2.081189e-01},
  { 6.267459e-01,  6.631795e-01, -4.091242e-01,  6.333209e-01,  6.672300e-01, -4.178438e-01},
  {-4.967940e-01,  8.205535e-01, -2.826441e-01, -4.989445e-01,  8.288014e-01, -2.915636e-01},
  {-4.409403e-01,  8.143412e-01, -3.773860e-01, -4.398288e-01,  8.306652e-01, -3.706941e-01},
  { 4.739492e-01,  7.342191e-01, -4.861013e-01,  5.043235e-01,  7.385513e-01, -4.701951e-01},
  {-6.426697e-01,  5.649179e-01, -5.175359e-01, -6.467695e-01,  5.763629e-01, -5.199589e-01},
  {-6.817970e-01,  4.761147e-01, -5.553988e-01, -6.778892e-01,  4.868681e-01, -5.694616e-01},
  {-6.332108e-01,  4.844146e-01, -6.036444e-01, -6.509336e-01,  4.761571e-01, -6.086224e-01},
  { 4.178373e-01,  8.068261e-01, -4.176644e-01,  3.475854e-01,  8.077179e-01, -4.976525e-01},
  { 3.212325e-02,  8.287240e-01, -5.587348e-01,  2.781701e-02,  8.331470e-01, -5.709369e-01},
  {-3.452941e-01,  7.974122e-01, -4.948795e-01, -3.479478e-01,  8.039339e-01, -5.034804e-01},
  { 2.187771e-01,  8.159310e-01, -5.351572e-01,  2.208856e-01,  8.292403e-01, -5.333385e-01},
  {-5.800505e-02,  8.102893e-01, -5.831524e-01, -5.762098e-02,  8.214175e-01, -5.855153e-01},
  {-1.231842e-01,  8.007302e-01, -5.862225e-01, -1.227770e-01,  8.093804e-01, -5.922021e-01},
  {-4.904844e-01,  6.686175e-01, -5.589057e-01, -4.874868e-01,  6.861810e-01, -5.589083e-01},
  {-6.201725e-01,  4.493723e-01, -6.430013e-01, -6.300223e-01,  4.492238e-01, -6.497164e-01},
  {-3.232291e-01,  7.745929e-01, -5.436255e-01, -3.216547e-01,  7.796363e-01, -5.563954e-01},
  {-1.434820e-01,  7.696213e-01, -6.221704e-01, -1.525016e-01,  7.695226e-01, -6.367507e-01},
  {-5.940775e-01,  4.279594e-01, -6.811187e-01, -5.973923e-01,  4.338912e-01, -6.901235e-01},
  {-3.130430e-01,  7.412817e-01, -5.937216e-01, -3.200713e-01,  7.460777e-01, -6.014917e-01},
  {-6.265084e-01,  3.114835e-01, -7.144685e-01, -5.923930e-01,  2.544812e-01, -7.779269e-01},
  {-6.370675e-01,  3.858894e-01, -6.672588e-01, -5.905351e-01,  2.550332e-01, -7.796360e-01},
  {-1.251742e-01,  7.132887e-01, -6.896019e-01, -1.198532e-01,  7.176889e-01, -7.010215e-01},
  {-5.855857e-01,  2.932157e-01, -7.557208e-01, -5.943796e-01,  2.962284e-01, -7.614607e-01},
  {-6.989827e-02,  6.618420e-01, -7.463775e-01, -6.462187e-02,  6.766430e-01, -7.475643e-01},
  {-2.271323e-02,  6.290506e-01, -7.770324e-01, -2.991154e-02,  6.436046e-01, -7.783011e-01},
  { 3.884388e-03,  5.647273e-01, -8.252684e-01,  3.596849e-03,  5.626357e-01, -8.392273e-01},
  { 1.995427e-02,  5.249372e-01, -8.509070e-01,  1.556920e-02,  5.259549e-01, -8.625561e-01},
  { 4.717917e-01,  1.999659e-01,  8.587353e-01,  4.665755e-01,  2.085868e-01,  8.715913e-01},
  { 6.448362e-01,  1.791410e-01,  7.430308e-01,  6.478024e-01,  1.702005e-01,  7.564783e-01},
  { 3.546751e-01,  2.231834e-01,  9.079618e-01,  3.499575e-01,  2.351531e-01,  9.182066e-01},
  { 6.822072e-01,  4.230373e-01,  5.963495e-01,  5.936562e-01,  1.812779e-01,  7.972360e-01},
  {-8.850376e-02,  3.751929e-01,  9.227120e-01, -8.775969e-02,  3.836646e-01,  9.305722e-01},
  { 7.655036e-01,  1.592664e-01,  6.234087e-01,  7.698553e-01,  1.666863e-01,  6.327846e-01},
  {-1.153606e-01,  4.012082e-01,  9.086935e-01, -1.270403e-01,  3.938954e-01,  9.219916e-01},
  { 7.258193e-02,  3.227340e-01,  9.437026e-01,  7.350773e-02,  3.261436e-01,  9.534642e-01},
  {-1.948588e-01,  4.231932e-01,  8.848375e-01, -1.997346e-01,  4.256114e-01,  8.943291e-01},
  { 8.304534e-01,  2.055627e-01,  5.177752e-01,  8.449513e-01,  2.077813e-01,  5.135799e-01},
  { 8.565389e-01,  1.896455e-01,  4.799747e-01,  8.649291e-01,  1.944468e-01,  4.847356e-01},
  {-3.540593e-01,  5.644926e-01,  7.456474e-01, -3.394452e-01,  5.759876e-01,  7.575477e-01},
  {-3.991513e-01,  5.844120e-01,  7.064990e-01, -3.988032e-01,  5.917298e-01,  7.153143e-01},
  {-4.356385e-01,  5.600607e-01,  7.046638e-01, -4.433648e-01,  5.740125e-01,  7.034196e-01},
  {-4.663408e-01,  5.664806e-01,  6.794307e-01, -4.636999e-01,  5.722117e-01,  6.916774e-01},
  {-6.020496e-01,  4.541513e-01,  6.567212e-01, -6.116100e-01,  4.532699e-01,  6.655951e-01},
  { 9.534719e-01,  2.759320e-01,  1.214611e-01,  9.632716e-01,  2.808398e-01,  1.188325e-01},
  {-5.409781e-01,  4.831043e-01,  6.884424e-01, -5.471700e-01,  4.925319e-01,  6.920089e-01},
  { 8.784716e-01,  4.421332e-01, -1.811239e-01,  8.879218e-01,  4.352250e-01, -2.075090e-01},
  {-6.788449e-01,  4.756121e-01,  5.594307e-01, -6.927946e-01,  4.812225e-01,  5.561632e-01},
  { 9.312713e-01,  3.643089e-01, -3.572881e-03,  9.401281e-01,  3.701865e-01, -2.511015e-03},
  {-6.787606e-01,  5.454232e-01,  4.917293e-01, -6.862511e-01,  5.447590e-01,  5.031451e-01},
  {-6.817796e-01,  7.225831e-01,  1.142376e-01, -6.917471e-01,  7.272810e-01,  1.157994e-01},
  {-6.319297e-01,  7.750168e-01, -3.715118e-03, -6.388899e-01,  7.827379e-01, -2.029216e-03},
  {-6.559945e-01,  7.495967e-01,  8.818145e-02, -6.697137e-01,  7.522079e-01,  8.080118e-02},
  { 7.522719e-01,  5.612606e-01, -3.450703e-01,  7.584745e-01,  5.681975e-01, -3.503621e-01},
  {-6.963038e-01,  5.523605e-01,  4.583217e-01, -7.080683e-01,  5.603579e-01,  4.533170e-01},
  {-7.221816e-01,  5.624665e-01,  4.025981e-01, -7.288216e-01,  5.689440e-01,  4.074059e-01},
  { 6.842074e-01,  6.179689e-01, -3.872656e-01,  6.868836e-01,  6.304372e-01, -3.893903e-01},
  {-4.664965e-01,  8.333303e-01, -2.965496e-01, -4.724279e-01,  8.390375e-01, -3.060972e-01},
  {-4.342080e-01,  8.330796e-01, -3.426979e-01, -4.425687e-01,  8.397433e-01, -3.461679e-01},
  {-3.964694e-01,  8.341566e-01, -3.833990e-01, -3.955604e-01,  8.366654e-01, -4.054528e-01},
  {-5.946990e-01,  6.040071e-01, -5.305737e-01, -5.962712e-01,  6.163320e-01, -5.342838e-01},
  { 3.787973e-01,  7.972575e-01, -4.699928e-01,  3.876764e-01,  8.040271e-01, -4.734232e-01},
  {-3.443622e-01,  8.234845e-01, -4.508748e-01, -3.479933e-01,  8.271183e-01, -4.643769e-01},
  {-2.634379e-02,  8.317612e-01, -5.545081e-01, -2.235398e-02,  8.408371e-01, -5.597939e-01},
  {-7.946733e-02,  8.270884e-01, -5.564258e-01, -8.292057e-02,  8.374905e-01, -5.591143e-01},
  { 2.905966e-01,  8.163708e-01, -4.990914e-01,  2.900791e-01,  8.266432e-01, -5.033845e-01},
  {-1.574945e-01,  8.110900e-01, -5.633191e-01, -1.573178e-01,  8.132640e-01, -5.785552e-01},
  {-1.791738e-01,  7.739125e-01, -6.074177e-01, -1.766288e-01,  7.883714e-01, -6.067500e-01},
  {-5.821865e-01,  3.539609e-01, -7.319634e-01, -5.820620e-01,  2.598432e-01, -7.839298e-01},
  {-4.378395e-01,  3.364428e-01, -8.337283e-01, -4.347291e-01,  3.430630e-01, -8.450933e-01},
  {-3.600379e-01,  3.472953e-01, -8.658861e-01, -3.647295e-01,  3.511466e-01, -8.743765e-01},
  {-5.658663e-01,  3.309032e-01, -7.551810e-01, -5.111526e-01,  3.251748e-01, -8.086081e-01},
  {-4.667504e-01,  3.317862e-01, -8.197939e-01, -4.734561e-01,  3.345448e-01, -8.275158e-01},
  {-3.085225e-01,  3.479656e-01, -8.852874e-01, -3.186044e-01,  3.589720e-01, -8.890990e-01},
  {-2.602620e-01,  3.344677e-01, -9.057566e-01, -2.603873e-01,  3.271209e-01, -9.198139e-01},
  {-1.093916e-01,  3.493053e-01, -9.306016e-01, -1.015363e-01,  3.552493e-01, -9.404035e-01},
  {-1.918120e-01,  3.307026e-01, -9.240367e-01, -1.961647e-01,  3.315461e-01, -9.340584e-01},
  { 5.099106e-01,  2.184566e-01,  8.320264e-01,  5.131595e-01,  2.216297e-01,  8.416776e-01},
  { 6.710064e-01,  1.597902e-01,  7.240286e-01,  6.744729e-01,  1.687659e-01,  7.331305e-01},
  { 4.117326e-01,  2.247229e-01,  8.831624e-01,  4.273620e-01,  2.236314e-01,  8.878191e-01},
  { 6.086708e-01,  2.884960e-01,  7.391142e-01,  5.782282e-01,  1.916453e-01,  8.073639e-01},
  { 3.793710e-01,  2.646766e-01,  8.865799e-01,  3.665455e-01,  2.658533e-01,  9.032373e-01},
  { 7.658650e-01,  1.919335e-01,  6.136875e-01,  7.743729e-01,  1.855369e-01,  6.219332e-01},
  { 3.108526e-01,  2.610976e-01,  9.138921e-01,  3.206496e-01,  2.764613e-01,  9.186634e-01},
  { 8.004455e-01,  2.007307e-01,  5.647957e-01,  8.052935e-01,  1.974434e-01,  5.774058e-01},
  { 2.464310e-01,  3.210571e-01,  9.144365e-01,  2.524624e-01,  3.122602e-01,  9.271603e-01},
  { 1.559007e-01,  3.263391e-01,  9.323077e-01,  1.592483e-01,  3.167748e-01,  9.461300e-01},
  { 8.765736e-01,  2.076308e-01,  4.341754e-01,  8.818789e-01,  2.050798e-01,  4.484560e-01},
  { 9.082068e-01,  1.785541e-01,  3.785219e-01,  9.189590e-01,  1.882304e-01,  3.754535e-01},
  { 9.275354e-01,  2.042541e-01,  3.129831e-01,  9.353771e-01,  2.001935e-01,  3.253834e-01},
  {-5.188405e-01,  5.291845e-01,  6.713929e-01, -5.215512e-01,  5.271903e-01,  6.862322e-01},
  { 9.491621e-01,  2.655656e-01,  1.690155e-01,  9.576524e-01,  2.689920e-01,  1.772821e-01},
  {-5.984965e-01,  5.544604e-01,  5.782522e-01, -6.057217e-01,  5.590228e-01,  5.843406e-01},
  {-6.339995e-01,  5.261978e-01,  5.667102e-01, -6.359295e-01,  5.232971e-01,  5.853307e-01},
  { 8.919190e-01,  4.197083e-01, -1.683021e-01,  9.035212e-01,  4.229031e-01, -1.602751e-01},
  { 9.097946e-01,  3.987229e-01, -1.152992e-01,  9.209359e-01,  4.008297e-01, -1.099920e-01},
  {-6.222840e-01,  5.702882e-01,  5.362219e-01, -6.272558e-01,  5.822487e-01,  5.370250e-01},
  { 8.460748e-01,  4.721217e-01, -2.475048e-01,  8.552560e-01,  4.792624e-01, -2.443981e-01},
  {-6.525257e-01,  5.468691e-01,  5.245420e-01, -6.611367e-01,  5.532306e-01,  5.269654e-01},
  {-6.853925e-01,  5.065338e-01,  5.231258e-01, -6.929886e-01,  5.148113e-01,  5.249699e-01},
  {-6.747777e-01,  5.886182e-01,  4.452007e-01, -6.841757e-01,  5.888202e-01,  4.539306e-01},
  {-6.798290e-01,  5.209815e-01, -5.161500e-01, -6.721004e-01,  5.249487e-01, -5.418221e-01},
  { 4.278509e-01,  7.865300e-01, -4.453247e-01,  4.376125e-01,  7.898421e-01, -4.533515e-01},
  { 3.307023e-01,  8.178412e-01, -4.709266e-01,  3.445023e-01,  8.217965e-01, -4.762882e-01},
  {-3.066548e-01,  8.133339e-01, -4.944197e-01, -3.083392e-01,  8.216847e-01, -5.006315e-01},
  { 1.397017e-01,  8.436871e-01, -5.183393e-01,  1.471446e-01,  8.537949e-01, -5.198669e-01},
  { 1.995809e-01,  8.441095e-01, -4.976412e-01,  1.999644e-01,  8.488802e-01, -5.101925e-01},
  { 1.174620e-01,  8.366000e-01, -5.350730e-01,  1.134230e-01,  8.462166e-01, -5.403064e-01},
  { 7.498942e-02,  8.429018e-01, -5.328164e-01,  7.361849e-02,  8.547793e-01, -5.336763e-01},
  {-1.204004e-01,  8.323299e-01, -5.410458e-01, -1.135407e-01,  8.446656e-01, -5.426996e-01},
  { 2.464541e-01,  8.275703e-01, -5.043688e-01,  2.496438e-01,  8.414945e-01, -5.004452e-01},
  {-6.067565e-01,  4.933198e-01, -6.232833e-01, -6.023965e-01,  4.941681e-01, -6.432564e-01},
  {-2.663215e-01,  7.607601e-01, -5.918758e-01, -2.634894e-01,  7.726735e-01, -5.953320e-01},
  {-4.498950e-01,  6.931409e-01, -5.631608e-01, -4.348887e-01,  6.941208e-01, -5.915534e-01},
  {-5.731350e-01,  4.689741e-01, -6.719967e-01, -5.851842e-01,  4.683934e-01, -6.775173e-01},
  {-3.840861e-01,  7.065214e-01, -5.943950e-01, -3.824210e-01,  7.134334e-01, -6.046779e-01},
  {-3.462675e-01,  7.082312e-01, -6.152297e-01, -3.537850e-01,  7.201263e-01, -6.141036e-01},
  {-5.572940e-01,  4.276832e-01, -7.116956e-01, -5.684035e-01,  4.345625e-01, -7.133971e-01},
  {-5.553778e-01,  3.957551e-01, -7.313914e-01, -5.555690e-01,  4.056095e-01, -7.400585e-01},
  {-8.256072e-02,  3.733749e-01, -9.239994e-01, -9.485594e-02,  3.788653e-01, -9.318445e-01},
  { 7.037935e-01,  1.926409e-01,  6.837867e-01,  7.118874e-01,  1.916096e-01,  6.909263e-01},
  { 7.269638e-01,  1.929869e-01,  6.589990e-01,  7.342064e-01,  1.959977e-01,  6.658855e-01},
  { 6.210907e-01,  2.054486e-01,  7.563315e-01,  6.293595e-01,  1.960456e-01,  7.657338e-01},
  { 6.048198e-01,  3.211642e-01,  7.287294e-01,  5.656720e-01,  2.031427e-01,  8.121715e-01},
  {-4.032803e-02,  3.758139e-01,  9.258172e-01, -4.316447e-02,  3.822308e-01,  9.342922e-01},
  {-2.097590e-01,  4.795256e-01,  8.520895e-01, -2.117768e-01,  4.908482e-01,  8.586327e-01},
  { 9.151829e-01,  2.015800e-01,  3.490070e-01,  9.250878e-01,  2.063746e-01,  3.500058e-01},
  { 9.326773e-01,  2.271355e-01,  2.802188e-01,  9.410555e-01,  2.341356e-01,  2.836861e-01},
  {-4.951515e-01,  5.770648e-01,  6.494777e-01, -4.894052e-01,  5.946010e-01,  6.540593e-01},
  {-4.282159e-01,  6.044253e-01,  6.717896e-01, -4.326139e-01,  6.118150e-01,  6.777832e-01},
  {-5.296280e-01,  5.794857e-01,  6.194276e-01, -5.381520e-01,  5.813427e-01,  6.271312e-01},
  {-4.605221e-01,  6.150127e-01,  6.400614e-01, -4.596496e-01,  6.229994e-01,  6.496432e-01},
  {-6.283807e-01,  4.902324e-01,  6.039948e-01, -6.401141e-01,  4.853510e-01,  6.128182e-01},
  {-5.013519e-01,  6.117997e-01,  6.118395e-01, -5.055974e-01,  6.234107e-01,  6.136708e-01},
  { 9.364623e-01,  3.452434e-01,  6.201135e-02,  9.447832e-01,  3.502696e-01,  7.470436e-02},
  {-5.392327e-01,  6.099051e-01,  5.807270e-01, -5.425458e-01,  6.176572e-01,  5.873708e-01},
  { 9.098411e-01,  4.103184e-01, -6.187148e-02,  9.205348e-01,  4.106787e-01, -6.959946e-02},
  { 8.572144e-01,  4.704904e-01, -2.093377e-01,  8.718723e-01,  4.645955e-01, -2.121540e-01},
  {-6.619188e-01,  4.903859e-01,  5.669085e-01, -6.716925e-01,  5.005104e-01,  5.649566e-01},
  { 9.167814e-01,  3.988344e-01,  2.104815e-02,  9.272841e-01,  4.010487e-01,  1.376631e-02},
  {-6.429592e-01,  7.646388e-01,  4.394263e-02, -6.459517e-01,  7.751008e-01,  5.317753e-02},
  {-5.732481e-01,  8.170380e-01, -6.193122e-02, -5.861682e-01,  8.211024e-01, -5.533837e-02},
  {-7.098182e-01,  6.563892e-01,  2.555609e-01, -7.169806e-01,  6.660945e-01,  2.512301e-01},
  {-7.100537e-01,  6.434721e-01,  2.859498e-01, -7.204033e-01,  6.464455e-01,  2.898040e-01},
  {-5.575076e-01,  8.234891e-01, -1.051227e-01, -5.594820e-01,  8.338853e-01, -1.117172e-01},
  {-6.765139e-01,  7.171916e-01,  1.672280e-01, -6.785235e-01,  7.278072e-01,  1.753960e-01},
  {-7.205866e-01,  6.149502e-01,  3.202987e-01, -7.186456e-01,  6.364027e-01,  3.152763e-01},
  { 7.161961e-01,  5.978919e-01, -3.599838e-01,  7.209602e-01,  6.095565e-01, -3.599203e-01},
  {-5.003831e-01,  8.331630e-01, -2.354910e-01, -5.003886e-01,  8.458531e-01, -2.345436e-01},
  {-4.176029e-01,  8.527753e-01, -3.136592e-01, -4.417799e-01,  8.542517e-01, -3.097625e-01},
  { 4.573232e-01,  7.746402e-01, -4.367928e-01,  4.629642e-01,  7.875252e-01, -4.316844e-01},
  {-6.495193e-01,  5.148671e-01, -5.594966e-01, -6.580586e-01,  5.189419e-01, -5.643755e-01},
  {-2.995651e-01,  8.402237e-01, -4.519789e-01, -3.035220e-01,  8.476193e-01, -4.585705e-01},
  {-5.374238e-01,  6.261466e-01, -5.649036e-01, -5.505322e-01,  6.277573e-01, -5.689463e-01},
  { 4.236225e-02,  8.540033e-01, -5.185403e-01,  5.299385e-02,  8.619699e-01, -5.244779e-01},
  {-7.886427e-02,  8.473664e-01, -5.251195e-01, -8.086630e-02,  8.569479e-01, -5.291277e-01},
  {-2.759876e-01,  8.155615e-01, -5.086159e-01, -2.781773e-01,  8.231789e-01, -5.156211e-01},
  {-2.598864e-01,  7.940168e-01, -5.495420e-01, -2.660212e-01,  8.031849e-01, -5.528978e-01},
  {-2.110918e-01,  7.876971e-01, -5.787689e-01, -2.101660e-01,  7.902774e-01, -5.934344e-01},
  {-2.315838e-01,  7.145882e-01, -6.601005e-01, -2.294724e-01,  7.272935e-01, -6.627654e-01},
  {-1.719992e-01,  7.112249e-01, -6.815977e-01, -1.708303e-01,  7.222155e-01, -6.856342e-01},
  {-1.266401e-01,  6.756369e-01, -7.262761e-01, -1.249130e-01,  6.862718e-01, -7.309588e-01},
  {-5.434261e-01,  3.706389e-01, -7.532031e-01, -5.480514e-01,  3.753335e-01, -7.613323e-01},
  {-7.098722e-02,  6.286924e-01, -7.744073e-01, -6.767601e-02,  6.307164e-01, -7.864416e-01},
  {-5.326590e-01,  3.148311e-01, -7.855926e-01, -5.409110e-01,  3.189596e-01, -7.915441e-01},
  {-4.454686e-02,  5.876950e-01, -8.078553e-01, -4.266109e-02,  5.880117e-01, -8.205461e-01},
  {-1.813860e-02,  5.157885e-01, -8.565239e-01, -2.102806e-02,  5.185146e-01, -8.669335e-01},
  { 7.932868e-03,  4.706455e-01, -8.822867e-01, -1.516142e-02,  4.738619e-01, -8.922433e-01},
  {-1.521324e-01,  3.618276e-01, -9.197481e-01, -1.533232e-01,  3.775197e-01, -9.245759e-01},
  { 4.612557e-01,  2.514794e-01,  8.508826e-01,  4.618840e-01,  2.509498e-01,  8.628791e-01},
  { 3.089152e-02,  3.559226e-01,  9.340047e-01,  3.960770e-02,  3.628248e-01,  9.421551e-01},
  { 2.098578e-01,  3.296178e-01,  9.204955e-01,  2.020336e-01,  3.340645e-01,  9.319080e-01},
  { 8.352498e-01,  2.579898e-01,  4.855913e-01,  8.590490e-01,  2.456013e-01,  4.718005e-01},
  {-1.825216e-01,  5.216445e-01,  8.334103e-01, -1.844325e-01,  5.073558e-01,  8.544472e-01},
  { 8.946527e-01,  2.228762e-01,  3.871985e-01,  9.020032e-01,  2.280232e-01,  3.940524e-01},
  {-1.379041e-01,  6.654788e-01,  7.335669e-01, -2.932968e-01,  5.879031e-01,  7.676008e-01},
  { 9.344036e-01,  2.594913e-01,  2.440376e-01,  9.450461e-01,  2.605164e-01,  2.447495e-01},
  {-5.774490e-01,  5.054986e-01,  6.411114e-01, -5.934588e-01,  5.120875e-01,  6.375200e-01},
  {-3.497529e-01,  6.266552e-01,  6.964024e-01, -3.623408e-01,  6.227418e-01,  7.083541e-01},
  {-5.943698e-01,  5.297204e-01,  6.050792e-01, -5.910922e-01,  5.331330e-01,  6.222846e-01},
  { 9.413129e-01,  3.174495e-01,  1.146986e-01,  9.466770e-01,  3.324661e-01,  1.189679e-01},
  {-4.039733e-01,  6.353390e-01,  6.581413e-01, -4.151634e-01,  6.320056e-01,  6.701277e-01},
  {-4.399493e-01,  6.380213e-01,  6.319600e-01, -4.467674e-01,  6.444806e-01,  6.371077e-01},
  { 8.889366e-01,  4.382713e-01, -1.330790e-01,  9.032884e-01,  4.344539e-01, -1.273009e-01},
  {-4.852426e-01,  6.452317e-01,  5.900980e-01, -4.987953e-01,  6.473383e-01,  5.941536e-01},
  {-5.672500e-01,  6.222227e-01,  5.395056e-01, -5.679595e-01,  6.281369e-01,  5.511141e-01},
  {-5.304161e-01,  6.491762e-01,  5.451871e-01, -5.463610e-01,  6.524130e-01,  5.447093e-01},
  { 9.085844e-01,  4.169580e-01, -2.490879e-02,  9.154615e-01,  4.263091e-01, -3.280852e-02},
  {-6.004360e-01,  7.991772e-01,  2.814988e-02, -6.076429e-01,  8.070364e-01,  1.805945e-02},
  {-6.453258e-01,  5.884401e-01,  4.871272e-01, -6.459028e-01,  6.024235e-01,  4.906677e-01},
  {-6.895090e-01,  6.940345e-01,  2.071074e-01, -6.923047e-01,  7.046468e-01,  2.122441e-01},
  {-5.343050e-01,  8.337986e-01, -1.389173e-01, -5.395153e-01,  8.444855e-01, -1.289709e-01},
  {-6.925930e-01,  5.977008e-01,  4.038176e-01, -6.904542e-01,  6.097392e-01,  4.151506e-01},
  {-6.930191e-01,  6.210046e-01,  3.661665e-01, -7.008899e-01,  6.258203e-01,  3.714313e-01},
  { 5.909526e-01,  6.956238e-01, -4.085124e-01,  6.018443e-01,  7.022349e-01, -4.068588e-01},
  { 5.648742e-01,  7.135439e-01, -4.144542e-01,  5.635938e-01,  7.244211e-01, -4.224455e-01},
  { 4.907533e-01,  7.624450e-01, -4.217094e-01,  4.805719e-01,  7.802237e-01, -4.256585e-01},
  {-3.338910e-01,  8.558474e-01, -3.950215e-01, -3.448537e-01,  8.583930e-01, -4.063345e-01},
  {-3.127948e-01,  8.528990e-01, -4.179984e-01, -3.124586e-01,  8.625184e-01, -4.234411e-01},
  {-2.678075e-01,  8.447914e-01, -4.632565e-01, -2.728093e-01,  8.515354e-01, -4.704615e-01},
  { 3.614815e-01,  8.272608e-01, -4.300823e-01,  3.679371e-01,  8.283130e-01, -4.465444e-01},
  { 3.393758e-01,  8.278488e-01, -4.466435e-01,  3.432625e-01,  8.354700e-01, -4.528165e-01},
  {-6.936397e-03,  8.611644e-01, -5.082793e-01, -1.490991e-02,  8.731081e-01, -5.082679e-01},
  {-6.132215e-02,  8.584167e-01, -5.092743e-01, -5.999032e-02,  8.639177e-01, -5.205024e-01},
  {-2.440648e-01,  8.446532e-01, -4.764383e-01, -2.459876e-01,  8.521854e-01, -4.838825e-01},
  { 1.306518e-01,  8.684182e-01, -4.783094e-01,  1.296799e-01,  8.752064e-01, -4.879299e-01},
  {-1.771803e-01,  8.356311e-01, -5.199305e-01, -1.854419e-01,  8.437420e-01, -5.240074e-01},
  {-2.210393e-01,  8.212953e-01, -5.259427e-01, -2.299622e-01,  8.325086e-01, -5.243272e-01},
  {-5.029823e-01,  6.482167e-01, -5.716852e-01, -5.078673e-01,  6.429753e-01, -5.912014e-01},
  {-5.530916e-01,  5.948594e-01, -5.832940e-01, -5.852836e-01,  5.187583e-01, -6.396843e-01},
  { 2.508506e-01,  8.466958e-01, -4.692338e-01,  2.501039e-01,  8.571363e-01, -4.729123e-01},
  {-4.634876e-01,  6.617840e-01, -5.892547e-01, -4.734653e-01,  6.608326e-01, -6.006293e-01},
  {-4.089883e-01,  6.823224e-01, -6.059411e-01, -4.099388e-01,  6.884111e-01, -6.155552e-01},
  {-5.337511e-01,  4.537332e-01, -7.136078e-01, -5.458551e-01,  4.483779e-01, -7.224006e-01},
  {-2.144406e-01,  7.023917e-01, -6.787202e-01, -2.146727e-01,  7.124056e-01, -6.835683e-01},
  {-1.548937e-01,  6.893927e-01, -7.076338e-01, -1.652154e-01,  6.941212e-01, -7.153826e-01},
  {-5.265796e-01,  3.547910e-01, -7.725524e-01, -5.246744e-01,  3.599627e-01, -7.848607e-01},
  {-5.244703e-01,  3.691244e-01, -7.672537e-01, -4.934675e-01,  3.657906e-01, -8.022160e-01},
  {-2.293170e-02,  4.290468e-01, -9.029912e-01, -1.987950e-02,  4.428050e-01, -9.079654e-01},
  {-3.178827e-01,  3.877351e-01, -8.652237e-01, -3.259924e-01,  3.959178e-01, -8.705429e-01},
  {-2.724397e-01,  3.796755e-01, -8.840945e-01, -2.652074e-01,  3.819375e-01, -8.970265e-01},
  {-5.830711e-02,  4.166423e-01,  9.071987e-01, -5.927366e-02,  4.151980e-01,  9.192187e-01},
  { 1.170409e-01,  3.475044e-01,  9.303452e-01,  1.147196e-01,  3.613688e-01,  9.365468e-01},
  {-1.211413e-01,  4.354898e-01,  8.920053e-01, -1.207505e-01,  4.479072e-01,  8.975877e-01},
  {-1.582586e-01,  4.605725e-01,  8.733998e-01, -1.654221e-01,  4.600680e-01,  8.842158e-01},
  { 2.822002e-01,  2.903517e-01,  9.143625e-01,  2.148089e-01,  3.636396e-01,  9.178743e-01},
  {-2.296344e-01,  5.454872e-01,  8.060470e-01, -2.261064e-01,  5.640199e-01,  8.072314e-01},
  {-1.651998e-01,  5.269488e-01,  8.336869e-01, -1.696852e-01,  5.362230e-01,  8.393673e-01},
  {-2.619569e-01,  5.807369e-01,  7.707939e-01, -2.711103e-01,  5.896053e-01,  7.744219e-01},
  {-1.587594e-01,  6.969014e-01,  6.993738e-01, -3.069987e-01,  6.022322e-01,  7.522173e-01},
  {-1.647779e-01,  7.066780e-01,  6.880803e-01, -3.111982e-01,  6.075446e-01,  7.449225e-01},
  {-5.427809e-01,  5.416331e-01,  6.418899e-01, -5.485690e-01,  5.485670e-01,  6.473068e-01},
  { 9.344406e-01,  2.815179e-01,  2.181017e-01,  9.423975e-01,  2.897402e-01,  2.209551e-01},
  { 9.371035e-01,  3.042449e-01,  1.710908e-01,  9.441507e-01,  3.069424e-01,  1.877488e-01},
  {-5.777743e-01,  5.583385e-01,  5.953445e-01, -5.772911e-01,  5.639465e-01,  6.079136e-01},
  { 9.274887e-01,  3.436823e-01,  1.471298e-01,  9.411343e-01,  3.384393e-01,  1.435594e-01},
  { 9.236594e-01,  3.697587e-01,  1.006568e-01,  9.363464e-01,  3.666454e-01,  9.854577e-02},
  {-5.805234e-01,  5.908138e-01,  5.602961e-01, -5.869309e-01,  6.020548e-01,  5.602697e-01},
  { 9.206643e-01,  3.857363e-01,  5.987316e-02,  9.282632e-01,  3.944492e-01,  6.018565e-02},
  {-6.017697e-01,  6.027969e-01,  5.239362e-01, -6.161039e-01,  6.099994e-01,  5.188222e-01},
  {-5.479571e-01,  8.352458e-01, -4.590714e-02, -5.683401e-01,  8.343232e-01, -4.194415e-02},
  {-5.867397e-01,  8.096918e-01, -1.164696e-02, -5.883871e-01,  8.213793e-01,  9.473592e-04},
  {-6.179566e-01,  7.828504e-01,  7.262844e-02, -6.249508e-01,  7.904418e-01,  7.417109e-02},
  {-6.487954e-01,  7.486303e-01,  1.364448e-01, -6.504231e-01,  7.595106e-01,  1.447604e-01},
  {-6.672971e-01,  7.047426e-01,  2.409404e-01, -6.731669e-01,  7.163007e-01,  2.337101e-01},
  {-4.887623e-01,  8.500125e-01, -1.964439e-01, -4.891482e-01,  8.608993e-01, -2.011311e-01},
  {-4.591084e-01,  8.588219e-01, -2.272540e-01, -4.634849e-01,  8.658727e-01, -2.373053e-01},
  { 4.119607e-01,  8.098949e-01, -4.175628e-01,  4.114702e-01,  8.190958e-01, -4.250375e-01},
  {-5.764692e-01,  5.932787e-01, -5.618752e-01, -5.854132e-01,  5.964696e-01, -5.677844e-01},
  {-2.106650e-01,  8.523900e-01, -4.785934e-01, -2.161550e-01,  8.625787e-01, -4.796953e-01},
  { 8.645652e-02,  8.680354e-01, -4.889169e-01,  8.802211e-02,  8.821653e-01, -4.846799e-01},
  { 2.802911e-02,  8.735349e-01, -4.859538e-01,  2.862494e-02,  8.810596e-01, -4.937527e-01},
  {-1.157896e-01,  8.700542e-01, -4.791642e-01, -1.229642e-01,  8.764905e-01, -4.873588e-01},
  {-1.627830e-01,  8.548159e-01, -4.927388e-01, -1.758481e-01,  8.652298e-01, -4.912518e-01},
  {-5.215764e-01,  6.654581e-01, -5.339696e-01, -5.663169e-01,  5.214900e-01, -6.543674e-01},
  {-5.132061e-01,  6.668689e-01, -5.402827e-01, -5.596723e-01,  5.222715e-01, -6.607043e-01},
  {-2.841106e-01,  7.129387e-01, -6.410924e-01, -2.885413e-01,  7.120956e-01, -6.575190e-01},
  {-1.243741e-01,  6.520011e-01, -7.479477e-01, -1.237890e-01,  6.621486e-01, -7.530659e-01},
  {-3.873611e-01,  3.721110e-01, -8.434956e-01, -3.899361e-01,  3.865278e-01, -8.481813e-01},
  {-4.340487e-02,  5.449063e-01, -8.373728e-01, -5.270854e-02,  5.586420e-01, -8.402465e-01},
  {-4.336490e-01,  3.840432e-01, -8.151437e-01, -4.383154e-01,  3.844548e-01, -8.251901e-01},
  {-5.750546e-02,  5.056973e-01, -8.607923e-01, -4.340569e-02,  5.106625e-01, -8.707541e-01},
  {-5.653877e-02,  4.008423e-01, -9.144008e-01, -7.873937e-02,  4.078115e-01, -9.210652e-01},
  {-1.301680e-01,  3.979007e-01, -9.081472e-01, -1.320195e-01,  4.029539e-01, -9.170983e-01},
  {-2.241318e-01,  3.725361e-01, -9.005453e-01, -2.284623e-01,  3.760875e-01, -9.095227e-01},
  {-1.800548e-01,  3.882000e-01, -9.038147e-01, -1.799946e-01,  3.957590e-01, -9.120560e-01},
  { 5.450492e-01,  2.452724e-01,  8.017249e-01,  5.566066e-01,  2.421328e-01,  8.077347e-01},
  { 4.193379e-01,  2.752006e-01,  8.651130e-01,  4.261377e-01,  2.814396e-01,  8.718205e-01},
  { 7.699249e-01,  2.261774e-01,  5.967072e-01,  7.829964e-01,  2.338277e-01,  5.942392e-01},
  { 6.637381e-02,  3.816503e-01,  9.219207e-01,  5.712399e-02,  3.822721e-01,  9.335268e-01},
  { 2.946098e-01,  3.348633e-01,  8.950260e-01,  3.012803e-01,  3.402545e-01,  9.024013e-01},
  { 8.030750e-01,  2.446656e-01,  5.433318e-01,  8.129944e-01,  2.528971e-01,  5.440248e-01},
  { 1.565887e-01,  3.653789e-01,  9.175937e-01,  1.556589e-01,  3.699718e-01,  9.272324e-01},
  { 4.068043e-01,  1.552349e-01,  9.002290e-01,  2.330307e-01,  3.787735e-01,  9.085103e-01},
  { 8.803686e-01,  2.489959e-01,  4.036735e-01,  8.853428e-01,  2.502832e-01,  4.176218e-01},
  { 9.088109e-01,  2.479428e-01,  3.355402e-01,  9.154878e-01,  2.539574e-01,  3.439040e-01},
  { 8.790573e-01,  4.582208e-01, -1.314985e-01,  8.928211e-01,  4.569743e-01, -1.221908e-01},
  {-4.301643e-01,  6.567052e-01,  6.194327e-01, -4.336793e-01,  6.653238e-01,  6.246037e-01},
  { 8.923473e-01,  4.429308e-01, -8.676786e-02,  8.981791e-01,  4.540001e-01, -8.968809e-02},
  { 8.885580e-01,  4.567507e-01, -4.293613e-02,  8.991066e-01,  4.598985e-01, -3.140510e-02},
  {-5.878266e-01,  6.454165e-01,  4.877476e-01, -5.926414e-01,  6.488091e-01,  4.986819e-01},
  {-6.187202e-01,  7.772335e-01,  1.144267e-01, -6.292051e-01,  7.824570e-01,  1.128042e-01},
  {-6.358716e-01,  6.289793e-01,  4.472724e-01, -6.460559e-01,  6.338816e-01,  4.490720e-01},
  {-6.598751e-01,  6.292170e-01,  4.106713e-01, -6.717252e-01,  6.343058e-01,  4.090242e-01},
  {-5.025304e-01,  8.502039e-01, -1.568964e-01, -5.084516e-01,  8.598070e-01, -1.519060e-01},
  {-6.819819e-01,  6.526588e-01,  3.300562e-01, -6.885362e-01,  6.589633e-01,  3.354774e-01},
  {-6.676037e-01,  6.859076e-01,  2.895445e-01, -6.758135e-01,  6.893271e-01,  2.982696e-01},
  { 6.626824e-01,  6.515291e-01, -3.692724e-01,  6.711307e-01,  6.624969e-01, -3.650480e-01},
  {-4.316563e-01,  8.649161e-01, -2.561111e-01, -4.444101e-01,  8.730916e-01, -2.482734e-01},
  {-3.609349e-01,  8.628369e-01, -3.538907e-01, -3.627502e-01,  8.751159e-01, -3.513606e-01},
  {-4.570477e-02,  8.814416e-01, -4.700764e-01, -4.779623e-02,  8.889442e-01, -4.778802e-01},
  {-8.098702e-02,  8.819440e-01, -4.643446e-01, -8.072723e-02,  8.866665e-01, -4.776829e-01},
  { 2.889382e-01,  8.481705e-01, -4.439838e-01,  3.004832e-01,  8.595232e-01, -4.379625e-01},
  { 1.706023e-01,  8.718560e-01, -4.590883e-01,  1.848289e-01,  8.802744e-01, -4.602554e-01},
  { 2.284619e-01,  8.671039e-01, -4.426467e-01,  2.364933e-01,  8.733419e-01, -4.496947e-01},
  {-5.440100e-01,  4.853136e-01, -6.844879e-01, -5.393097e-01,  5.000771e-01, -6.927711e-01},
  {-5.132002e-01,  4.123119e-01, -7.527447e-01, -5.118595e-01,  4.177234e-01, -7.644414e-01},
  {-3.434274e-01,  4.029773e-01, -8.483319e-01, -3.457345e-01,  4.091831e-01, -8.566816e-01},
  { 4.990360e-01,  2.628551e-01,  8.257543e-01,  5.102451e-01,  2.649624e-01,  8.308543e-01},
  { 5.874163e-01,  2.282858e-01,  7.764197e-01,  5.801011e-01,  2.416516e-01,  7.911777e-01},
  { 7.454447e-01,  2.378848e-01,  6.226741e-01,  7.405706e-01,  2.328076e-01,  6.467101e-01},
  { 3.507778e-01,  3.212089e-01,  8.796476e-01,  3.614916e-01,  3.199511e-01,  8.875962e-01},
  {-1.040389e-02,  4.011125e-01,  9.159697e-01, -6.876998e-03,  4.152171e-01,  9.210940e-01},
  { 7.759482e-01,  2.596493e-01,  5.748796e-01,  7.872832e-01,  2.660418e-01,  5.753369e-01},
  {-7.024708e-02,  4.502267e-01,  8.901468e-01, -6.052713e-02,  4.569747e-01,  8.990978e-01},
  { 8.169377e-01,  2.618437e-01,  5.138584e-01,  8.215773e-01,  2.659051e-01,  5.252127e-01},
  {-1.043169e-01,  4.834193e-01,  8.691512e-01, -1.309310e-01,  4.835525e-01,  8.787021e-01},
  {-7.778212e-02,  4.859160e-01,  8.705375e-01, -1.201598e-01,  4.991972e-01,  8.701894e-01},
  { 2.580364e-01,  3.665755e-01,  8.938902e-01,  2.524319e-01,  3.794959e-01,  9.017382e-01},
  { 1.752964e-01,  3.928587e-01,  9.027365e-01,  1.834854e-01,  3.991371e-01,  9.098859e-01},
  { 4.049569e-01,  2.129545e-01,  8.891908e-01,  2.445521e-01,  3.861992e-01,  9.010633e-01},
  { 8.410227e-01,  2.792222e-01,  4.633745e-01,  8.605500e-01,  2.779705e-01,  4.506302e-01},
  { 9.134473e-01,  2.813922e-01,  2.939939e-01,  9.246258e-01,  2.805311e-01,  2.953854e-01},
  {-4.336567e-01,  6.844350e-01,  5.860808e-01, -4.500132e-01,  6.795854e-01,  5.970887e-01},
  {-5.230820e-01,  6.770876e-01,  5.176269e-01, -5.181534e-01,  6.840181e-01,  5.333840e-01},
  { 8.930086e-01,  4.498996e-01,  1.122733e-02,  8.977820e-01,  4.633697e-01,  1.270956e-02},
  { 8.338432e-01,  5.063519e-01, -2.198030e-01,  8.364053e-01,  5.098962e-01, -2.476242e-01},
  { 8.353394e-01,  4.793184e-01, -2.691874e-01,  8.329979e-01,  5.130758e-01, -2.524944e-01},
  { 8.139870e-01,  5.217981e-01, -2.552489e-01,  8.308818e-01,  5.143677e-01, -2.568016e-01},
  { 7.912506e-01,  5.358475e-01, -2.946013e-01,  7.921436e-01,  5.478752e-01, -3.053310e-01},
  {-6.292160e-01,  7.580377e-01,  1.716569e-01, -6.422489e-01,  7.593775e-01,  1.781132e-01},
  {-6.398030e-01,  7.403399e-01,  2.062737e-01, -6.512522e-01,  7.445763e-01,  2.057633e-01},
  {-3.869085e-01,  8.708508e-01, -3.031842e-01, -3.910128e-01,  8.837492e-01, -2.948994e-01},
  {-2.760340e-01,  8.693203e-01, -4.099846e-01, -2.700996e-01,  8.803760e-01, -4.157596e-01},
  {-6.152470e-01,  5.306680e-01, -5.829775e-01, -6.119782e-01,  5.449836e-01, -5.910484e-01},
  {-2.201242e-01,  8.726451e-01, -4.359311e-01, -2.200397e-01,  8.890712e-01, -4.266236e-01},
  { 4.676553e-02,  8.919698e-01, -4.496698e-01,  3.955550e-02,  8.992620e-01, -4.589560e-01},
  {-1.652485e-01,  8.768712e-01, -4.514309e-01, -1.595032e-01,  8.860610e-01, -4.586158e-01},
  {-5.846257e-01,  5.403764e-01, -6.051497e-01, -5.784833e-01,  5.578080e-01, -6.124303e-01},
  {-5.943949e-01,  4.746463e-01, -6.491576e-01, -5.466354e-01,  5.360725e-01, -6.593026e-01},
  {-6.464813e-01,  3.477965e-01, -6.790431e-01, -5.291337e-01,  5.248947e-01, -6.821783e-01},
  {-4.722570e-01,  4.157837e-01, -7.772369e-01, -4.835722e-01,  4.146776e-01, -7.842605e-01},
  {-4.744731e-03,  5.322326e-01, -8.465849e-01, -9.185324e-02,  4.449221e-01, -9.037477e-01},
  {-2.046934e-01,  4.249967e-01, -8.817473e-01, -1.945535e-01,  4.335886e-01, -8.916386e-01},
  { 3.983161e-01,  3.098046e-01,  8.633454e-01,  4.001597e-01,  3.183152e-01,  8.714472e-01},
  { 1.777920e-02,  3.995782e-01,  9.165267e-01,  1.926147e-02,  4.124082e-01,  9.221798e-01},
  { 1.186144e-01,  4.054511e-01,  9.063885e-01,  1.177020e-01,  4.122856e-01,  9.148964e-01},
  { 3.036735e-01,  3.574103e-01,  8.831988e-01,  3.063468e-01,  3.586361e-01,  8.935341e-01},
  { 9.916098e-02, -4.900672e-01, -8.660262e-01, -9.939490e-02,  4.969257e-01,  8.741005e-01},
  {-1.199516e-01,  4.852119e-01,  8.661299e-01, -1.006450e-01,  4.969644e-01,  8.739355e-01},
  {-1.013534e-01,  4.544945e-01,  8.849645e-01, -9.841907e-02,  4.962673e-01,  8.745848e-01},
  { 8.255084e-01,  2.964075e-01,  4.802901e-01,  8.380615e-01,  2.930062e-01,  4.823707e-01},
  { 8.685117e-01,  2.973237e-01,  3.965931e-01,  8.826774e-01,  2.916572e-01,  3.964832e-01},
  { 2.527027e-01,  3.957776e-01,  8.828938e-01,  2.163946e-01,  4.067295e-01,  8.992301e-01},
  { 8.877035e-01,  2.814626e-01,  3.643642e-01,  8.935989e-01,  2.886271e-01,  3.729044e-01},
  {-1.852231e-01,  5.669652e-01,  8.026475e-01, -1.974419e-01,  5.766339e-01,  8.058385e-01},
  {-2.602302e-01,  6.240852e-01,  7.367481e-01, -2.588549e-01,  6.179052e-01,  7.563415e-01},
  {-3.150104e-01,  6.460115e-01,  6.952968e-01, -3.203617e-01,  6.492096e-01,  7.048119e-01},
  { 9.134915e-01,  3.848944e-01,  1.318692e-01,  9.212865e-01,  3.966081e-01,  1.217292e-01},
  {-3.692017e-01,  6.684138e-01,  6.456881e-01, -3.799528e-01,  6.784806e-01,  6.451079e-01},
  { 9.038361e-01,  4.221160e-01,  6.998929e-02,  9.125267e-01,  4.274374e-01,  7.400846e-02},
  {-4.785352e-01,  6.796624e-01,  5.559343e-01, -4.708144e-01,  6.941158e-01,  5.633827e-01},
  { 8.687744e-01,  4.877397e-01, -8.567991e-02,  8.784177e-01,  4.905466e-01, -9.290865e-02},
  { 8.717173e-01,  4.848888e-01,  7.065272e-02,  8.749459e-01,  5.046158e-01, -2.679617e-02},
  {-5.818617e-01,  8.106242e-01,  6.576590e-02, -5.822882e-01,  8.233027e-01,  6.306635e-02},
  {-5.185667e-01,  8.499989e-01, -9.268466e-02, -5.115623e-01,  8.665779e-01, -9.062658e-02},
  {-5.955428e-01,  7.961152e-01,  1.073745e-01, -6.024432e-01,  8.040718e-01,  1.067441e-01},
  {-5.863149e-01,  6.779786e-01,  4.433731e-01, -5.959833e-01,  6.858262e-01,  4.419361e-01},
  {-6.216641e-01,  6.617501e-01,  4.190711e-01, -6.196318e-01,  6.815895e-01,  4.151543e-01},
  { 7.056998e-01,  6.245998e-01, -3.344593e-01,  7.108410e-01,  6.316934e-01, -3.413998e-01},
  {-4.697317e-01,  8.739707e-01, -1.246092e-01, -4.798434e-01,  8.772017e-01, -1.453777e-01},
  { 6.307435e-01,  6.882225e-01, -3.584864e-01,  6.423228e-01,  6.922105e-01, -3.593758e-01},
  { 5.957867e-01,  7.152739e-01, -3.652689e-01,  6.118679e-01,  7.178479e-01, -3.622112e-01},
  {-3.367424e-01,  8.825636e-01, -3.281556e-01, -3.325015e-01,  8.951365e-01, -3.302182e-01},
  { 5.099643e-01,  7.717999e-01, -3.798175e-01,  5.117658e-01,  7.807015e-01, -3.866327e-01},
  {-2.977183e-01,  8.806687e-01, -3.684922e-01, -2.901365e-01,  8.956866e-01, -3.666575e-01},
  { 6.034393e-01, -5.549205e-01,  5.726468e-01, -6.093953e-01,  5.602854e-01, -5.792931e-01},
  { 6.044284e-01, -5.534489e-01,  5.730278e-01, -6.093412e-01,  5.597503e-01, -5.798671e-01},
  {-5.837900e-01,  5.678235e-01, -5.803152e-01, -6.069384e-01,  5.627217e-01, -5.795110e-01},
  {-6.369481e-01,  5.882945e-01, -4.982033e-01, -6.103051e-01,  5.605758e-01, -5.780531e-01},
  { 4.669352e-01,  7.989853e-01, -3.789379e-01,  4.722531e-01,  8.052056e-01, -3.866579e-01},
  {-2.397163e-01,  8.917277e-01, -3.838721e-01, -2.509597e-01,  8.991449e-01, -3.865615e-01},
  {-1.932086e-01,  8.970402e-01, -3.974786e-01, -1.927215e-01,  8.990077e-01, -4.189473e-01},
  { 3.838915e-01,  8.355706e-01, -3.930001e-01,  3.901647e-01,  8.422538e-01, -3.990771e-01},
  {-3.598547e-03,  8.944657e-01, -4.471221e-01, -1.147756e-02,  9.045151e-01, -4.501080e-01},
  { 3.087861e-01,  8.595842e-01, -4.071438e-01,  3.112324e-01,  8.660832e-01, -4.170320e-01},
  { 1.051496e-01,  8.923216e-01, -4.389824e-01,  1.102047e-01,  9.030759e-01, -4.395308e-01},
  {-4.765029e-01,  6.157759e-01, -6.275070e-01, -4.884824e-01,  6.212994e-01, -6.294743e-01},
  {-5.660638e-01,  4.342968e-01, -7.006840e-01, -5.132880e-01,  5.134638e-01, -7.026768e-01},
  {-2.079730e-01,  6.722775e-01, -7.104860e-01, -2.069447e-01,  6.773313e-01, -7.206023e-01},
  {-1.059221e-01,  5.911394e-01, -7.995841e-01, -1.033534e-01,  5.948802e-01, -8.101286e-01},
  {-6.181123e-02,  4.690239e-01, -8.810199e-01, -6.742663e-02,  4.601610e-01, -8.969824e-01},
  {-2.489187e-01,  4.262818e-01, -8.696685e-01, -2.607546e-01,  4.270285e-01, -8.777938e-01},
  { 5.738325e-02,  6.187132e-01, -7.835185e-01, -9.770291e-02,  4.511777e-01, -8.987570e-01},
  { 6.595554e-01,  2.719109e-01,  7.007504e-01,  6.693350e-01,  2.600524e-01,  7.108027e-01},
  { 7.112843e-01,  2.481865e-01,  6.576306e-01,  7.266682e-01,  2.653022e-01,  6.499587e-01},
  {-6.692655e-02,  5.125991e-01,  8.560158e-01, -9.045196e-02,  4.996695e-01,  8.735074e-01},
  { 1.728360e-01,  4.255631e-01,  8.882701e-01,  1.683923e-01,  4.290190e-01,  8.991421e-01},
  {-8.564054e-02,  5.396312e-01,  8.375344e-01, -1.127305e-01,  5.374057e-01,  8.485469e-01},
  {-1.353705e-01,  6.115739e-01,  7.795205e-01, -2.060462e-01,  5.975526e-01,  7.882523e-01},
  {-1.300591e-01,  6.302357e-01,  7.654330e-01, -2.136035e-01,  6.104923e-01,  7.774965e-01},
  { 9.110431e-01,  3.177449e-01,  2.627518e-01,  9.192346e-01,  3.220529e-01,  2.686504e-01},
  {-2.882242e-01,  6.364350e-01,  7.154559e-01, -2.914915e-01,  6.499529e-01,  7.165606e-01},
  { 9.155440e-01,  3.517700e-01,  1.950304e-01,  9.224703e-01,  3.560775e-01,  2.077051e-01},
  {-3.911450e-01,  6.836383e-01,  6.161528e-01, -3.929712e-01,  6.965435e-01,  6.174666e-01},
  { 8.644926e-01,  4.828953e-01, -1.395161e-01,  8.689092e-01,  4.988765e-01, -1.304024e-01},
  { 8.817099e-01,  4.703419e-01,  3.696154e-02,  8.919385e-01,  4.731721e-01,  3.793672e-02},
  {-5.483976e-01,  6.883432e-01,  4.748091e-01, -5.492052e-01,  6.960858e-01,  4.844587e-01},
  {-5.409845e-01,  8.407491e-01, -2.183430e-02, -5.369671e-01,  8.558286e-01, -9.449730e-03},
  {-5.484757e-01,  8.347166e-01,  4.922094e-02, -5.530949e-01,  8.451331e-01,  2.647894e-02},
  { 8.450782e-01,  5.317510e-01, -5.553192e-02,  8.587067e-01,  5.297085e-01, -5.401348e-02},
  { 7.457420e-01,  5.314416e-01, -4.017944e-01,  7.548836e-01,  5.870686e-01, -3.261698e-01},
  {-6.000596e-01,  6.961182e-01,  3.941419e-01, -6.007676e-01,  6.999567e-01,  4.123109e-01},
  {-6.472807e-01,  6.641852e-01,  3.740131e-01, -6.610283e-01,  6.622406e-01,  3.812337e-01},
  {-4.428681e-01,  8.801669e-01, -1.708041e-01, -4.526652e-01,  8.855726e-01, -1.781101e-01},
  {-7.012906e-01, -6.994231e-01,  1.378357e-01,  6.760900e-01,  7.436703e-01, -1.036437e-01},
  {-6.677346e-01, -7.371892e-01,  1.033575e-01,  6.761454e-01,  7.434760e-01, -1.046719e-01},
  { 6.643023e-01,  7.412866e-01, -9.589893e-02,  6.790521e-01,  7.419769e-01, -9.614437e-02},
  { 6.610550e-01,  7.347879e-01, -1.519640e-01,  6.742372e-01,  7.449679e-01, -1.063591e-01},
  { 5.563823e-01,  7.439324e-01, -3.701397e-01,  5.641379e-01,  7.564878e-01, -3.610523e-01},
  {-1.401650e-01,  8.962080e-01, -4.209097e-01, -1.479522e-01,  9.063573e-01, -4.213083e-01},
  { 3.904676e-01,  8.510839e-01, -3.509859e-01,  4.032286e-01,  8.567683e-01, -3.524735e-01},
  {-5.437626e-01,  5.719310e-01, -6.141801e-01, -5.468748e-01,  5.824713e-01, -6.184816e-01},
  { 3.372677e-01,  8.582516e-01, -3.868522e-01,  3.304782e-01,  8.703609e-01, -3.931346e-01},
  { 1.334219e-01,  8.996216e-01, -4.157879e-01,  1.297431e-01,  9.084697e-01, -4.227628e-01},
  {-5.120449e-01,  5.960647e-01, -6.184794e-01, -5.121853e-01,  6.009884e-01, -6.303525e-01},
  {-5.063300e-01,  5.539651e-01, -6.608727e-01, -5.086747e-01,  5.647256e-01, -6.657327e-01},
  {-4.201348e-01,  6.364992e-01, -6.468042e-01, -4.267482e-01,  6.474258e-01, -6.477599e-01},
  {-3.736756e-01,  6.735158e-01, -6.377641e-01, -3.825176e-01,  6.727614e-01, -6.495696e-01},
  {-4.935408e-01,  4.714915e-01, -7.308305e-01, -4.971333e-01,  4.723245e-01, -7.420462e-01},
  {-1.269082e-01,  6.173625e-01, -7.763748e-01, -1.411907e-01,  6.328098e-01, -7.749124e-01},
  {-4.727222e-01,  4.623351e-01, -7.501867e-01, -4.778658e-01,  4.605447e-01, -7.618447e-01},
  {-3.506385e-01,  4.308337e-01, -8.315257e-01, -3.541443e-01,  4.417326e-01, -8.368518e-01},
  {-3.911385e-01,  4.285818e-01, -8.144497e-01, -3.939849e-01,  4.341810e-01, -8.228783e-01},
  {-4.292618e-01,  3.675348e-01, -8.250166e-01, -4.370051e-01,  4.406158e-01, -7.973390e-01},
  {-2.996073e-01,  4.265393e-01, -8.534047e-01, -2.930768e-01,  4.311517e-01, -8.654951e-01},
  {-4.547022e-01,  4.196627e-01, -7.855757e-01, -4.567627e-01,  4.167671e-01, -7.990854e-01},
  {-4.532140e-01,  4.010304e-01, -7.960978e-01, -4.563018e-01,  4.159417e-01, -7.997785e-01},
  { 7.664650e-01,  6.352621e-01, -9.472837e-02, -4.566066e-01,  4.160880e-01, -7.995285e-01},
  { 4.510384e-01, -4.126482e-01,  7.913823e-01, -4.559514e-01,  4.178742e-01, -7.989706e-01},
  {-9.823337e-02,  5.019652e-01, -8.592911e-01, -1.000555e-01,  4.940487e-01, -8.756578e-01},
  {-5.327271e-02,  5.162266e-01, -8.547936e-01, -1.135276e-01,  4.645282e-01, -8.903834e-01},
  {-1.622371e-01,  4.393069e-01, -8.835658e-01, -1.587565e-01,  4.343796e-01, -8.986263e-01},
  { 5.771995e-01,  2.714170e-01,  7.701777e-01,  5.886623e-01,  2.757244e-01,  7.735169e-01},
  { 5.357548e-01,  2.886735e-01,  7.934951e-01,  5.333292e-01,  2.857851e-01,  8.091733e-01},
  { 6.297663e-01,  2.480139e-01,  7.361274e-01,  6.385828e-01,  2.619959e-01,  7.378663e-01},
  { 7.298781e-01,  2.920467e-01,  6.180507e-01,  7.425860e-01,  2.893517e-01,  6.210641e-01},
  { 3.721944e-01,  3.547373e-01,  8.576904e-01,  3.755461e-01,  3.514660e-01,  8.696605e-01},
  { 6.019558e-02,  4.357403e-01,  8.980573e-01,  5.496546e-02,  4.396941e-01,  9.080285e-01},
  { 3.305235e-01,  3.692119e-01,  8.685832e-01,  3.338407e-01,  3.733421e-01,  8.775182e-01},
  {-8.522249e-03,  4.446375e-01,  8.956701e-01, -1.673669e-04,  4.570232e-01,  9.011088e-01},
  {-3.855005e-02,  4.899637e-01,  8.708900e-01, -4.864227e-02,  4.910604e-01,  8.816805e-01},
  { 2.833266e-01,  4.066000e-01,  8.685635e-01,  2.800039e-01,  4.058008e-01,  8.819268e-01},
  {-6.001236e-02,  5.316921e-01,  8.448089e-01, -5.353612e-02,  5.380402e-01,  8.535304e-01},
  { 1.292246e-01,  4.506995e-01,  8.832729e-01,  1.387335e-01,  4.527237e-01,  8.925603e-01},
  { 8.317421e-01,  3.158534e-01,  4.565542e-01,  8.555593e-01,  3.198701e-01,  4.319527e-01},
  {-8.758286e-02,  5.613444e-01,  8.229349e-01, -1.187869e-01,  5.666496e-01,  8.280488e-01},
  { 8.924260e-01,  3.070222e-01,  3.306255e-01,  8.970415e-01,  3.197399e-01,  3.375879e-01},
  { 9.012694e-01,  3.557132e-01,  2.473489e-01,  9.130146e-01,  3.516197e-01,  2.522927e-01},
  {-4.404700e-01,  7.176194e-01,  5.394521e-01, -4.398561e-01,  7.215490e-01,  5.538570e-01},
  { 8.945493e-01,  4.271550e-01,  1.316062e-01,  9.052879e-01,  4.277297e-01,  1.355948e-01},
  {-4.893837e-01,  7.070596e-01,  5.104610e-01, -5.023806e-01,  7.114032e-01,  5.122325e-01},
  { 8.522460e-01,  4.968845e-01, -1.636540e-01,  8.563107e-01,  5.090496e-01, -1.687790e-01},
  { 8.430068e-01,  5.298512e-01, -9.272023e-02,  8.583531e-01,  5.244277e-01, -9.534863e-02},
  { 8.089792e-01,  4.881493e-01,  3.275105e-01,  8.495395e-01,  5.464628e-01, -2.338372e-02},
  {-5.621707e-01,  8.198743e-01,  1.084910e-01, -5.695507e-01,  8.277262e-01,  1.065158e-01},
  {-5.928403e-01,  7.867531e-01,  1.719303e-01, -5.972236e-01,  7.953207e-01,  1.779107e-01},
  {-6.308261e-01,  7.322388e-01,  2.566800e-01, -6.362398e-01,  7.404323e-01,  2.604242e-01},
  {-6.310215e-01,  7.192724e-01,  2.906185e-01, -6.374103e-01,  7.254258e-01,  2.971985e-01},
  {-6.486276e-01,  6.811686e-01,  3.395462e-01, -6.563360e-01,  6.862604e-01,  3.451525e-01},
  {-4.137180e-01,  8.846550e-01, -2.149954e-01, -4.103431e-01,  8.963283e-01, -2.215471e-01},
  {-2.961087e-01,  8.976501e-01, -3.264108e-01, -3.065813e-01,  9.044659e-01, -3.305109e-01},
  { 5.303416e-01,  7.756459e-01, -3.422152e-01,  5.423273e-01,  7.762337e-01, -3.524579e-01},
  { 4.276700e-01,  8.275452e-01, -3.636859e-01,  4.241996e-01,  8.427125e-01, -3.616261e-01},
  {-1.019123e-01,  9.057130e-01, -4.114584e-01, -1.020468e-01,  9.157135e-01, -4.146447e-01},
  { 4.233677e-01,  8.451030e-01, -3.264363e-01,  4.406401e-01,  8.526627e-01, -3.157304e-01},
  { 2.478492e-01,  8.827829e-01, -3.990804e-01,  2.467787e-01,  8.950567e-01, -3.985654e-01},
  { 1.870906e-01,  8.900642e-01, -4.156714e-01,  1.752940e-01,  9.046984e-01, -4.143337e-01},
  {-3.278191e-01,  6.762584e-01, -6.597039e-01, -3.240414e-01,  6.889333e-01, -6.642572e-01},
  {-3.645553e-01,  4.534622e-01, -8.133090e-01, -4.012780e-01,  4.515527e-01, -8.099025e-01},
  {-3.590966e-01,  4.477094e-01, -8.189053e-01, -4.102205e-01,  4.508240e-01, -8.070810e-01},
  {-1.589356e-01,  4.930521e-01, -8.553591e-01, -1.643466e-01,  5.018816e-01, -8.613802e-01},
  {-4.185997e-01,  5.272586e-01, -7.394409e-01, -4.400118e-01,  4.524316e-01, -7.890251e-01},
  { 7.454799e-01,  2.978577e-01,  5.962723e-01,  7.003585e-01,  2.901209e-01,  6.679864e-01},
  { 4.929609e-01,  3.037355e-01,  8.153124e-01,  5.010896e-01,  3.027848e-01,  8.234712e-01},
  { 4.540887e-01,  3.043871e-01,  8.373482e-01,  4.591737e-01,  3.176284e-01,  8.421077e-01},
  { 5.401691e-01,  3.277976e-01,  7.750910e-01,  5.409355e-01,  3.366233e-01,  7.841868e-01},
  { 5.116714e-01,  3.347169e-01,  7.913008e-01,  5.182292e-01,  3.356089e-01,  7.998000e-01},
  { 7.568691e-01,  2.937971e-01,  5.838086e-01,  7.558429e-01,  3.041336e-01,  5.975648e-01},
  { 7.520131e-03,  4.683575e-01,  8.835071e-01,  2.598726e-03,  4.665602e-01,  8.962044e-01},
  { 7.865992e-01,  3.064117e-01,  5.360724e-01,  7.910702e-01,  3.153186e-01,  5.437485e-01},
  { 8.251258e-01,  3.328731e-01,  4.564680e-01,  8.356940e-01,  3.300350e-01,  4.621404e-01},
  { 2.431715e-01,  4.257120e-01,  8.715715e-01,  2.258655e-01,  4.431369e-01,  8.794802e-01},
  {-1.375808e-01,  5.933862e-01,  7.930727e-01, -1.383755e-01,  5.921111e-01,  8.069221e-01},
  { 8.889251e-01,  3.385183e-01,  3.085736e-01,  9.053207e-01,  3.366985e-01,  2.964993e-01},
  {-2.523557e-01,  6.592794e-01,  7.082847e-01, -2.657741e-01,  6.609547e-01,  7.164975e-01},
  {-1.333288e-01,  6.583784e-01,  7.407842e-01, -2.202842e-01,  6.357762e-01,  7.537437e-01},
  {-3.244576e-01,  6.713419e-01,  6.663538e-01, -3.274966e-01,  6.821601e-01,  6.695287e-01},
  { 9.028299e-01,  3.936082e-01,  1.731203e-01,  9.076904e-01,  4.051376e-01,  1.812351e-01},
  {-4.682575e-01,  7.369450e-01,  4.874905e-01, -4.839363e-01,  7.444799e-01,  4.820985e-01},
  { 8.778307e-01,  4.702687e-01,  9.088728e-02,  8.902140e-01,  4.706796e-01,  8.285560e-02},
  {-5.179868e-01,  7.186688e-01,  4.639018e-01, -5.181730e-01,  7.280626e-01,  4.714705e-01},
  { 8.840099e-01,  4.668242e-01,  2.452997e-02,  8.731571e-01,  5.097612e-01,  2.880547e-02},
  { 8.448219e-01,  5.224747e-01, -1.153087e-01,  8.530545e-01,  5.253056e-01, -1.312935e-01},
  { 7.825052e-01,  4.449575e-01, -4.355440e-01,  7.892518e-01,  5.543458e-01, -3.011113e-01},
  {-4.911720e-01,  8.689332e-01, -6.086997e-02, -4.849683e-01,  8.844595e-01, -6.337395e-02},
  { 8.236272e-01,  5.625276e-01, -7.211734e-02,  8.220900e-01,  5.847690e-01, -5.566885e-02},
  {-5.974314e-01,  7.716090e-01,  2.183925e-01, -5.982144e-01,  7.861680e-01,  2.119960e-01},
  {-6.104574e-01,  7.038838e-01,  3.631658e-01, -6.201779e-01,  7.143634e-01,  3.548601e-01},
  {-6.259435e-01,  7.121336e-01,  3.179000e-01, -6.313639e-01,  7.202185e-01,  3.217550e-01},
  {-3.698682e-01,  8.943930e-01, -2.515128e-01, -3.718639e-01,  9.056438e-01, -2.497927e-01},
  {-3.261762e-01,  9.009076e-01, -2.863121e-01, -3.262742e-01,  9.126294e-01, -2.855233e-01},
  { 5.816664e-01,  7.410280e-01, -3.354723e-01,  5.862512e-01,  7.494718e-01, -3.398324e-01},
  {-2.426983e-01,  9.044064e-01, -3.509225e-01, -2.487324e-01,  9.146207e-01, -3.499622e-01},
  {-1.808604e-01,  9.150175e-01, -3.606002e-01, -1.803179e-01,  9.213982e-01, -3.733423e-01},
  { 4.665353e-01,  8.269685e-01, -3.137962e-01,  4.805177e-01,  8.271993e-01, -3.257895e-01},
  { 5.181967e-02,  9.149078e-01, -4.003229e-01,  5.841007e-02,  9.232512e-01, -4.062921e-01},
  {-7.294384e-03,  9.174994e-01, -3.976705e-01, -7.264438e-03,  9.255974e-01, -4.050844e-01},
  {-5.193236e-02,  9.059644e-01, -4.201566e-01, -4.431400e-02,  9.187863e-01, -4.180242e-01},
  {-4.219926e-01, -8.537223e-01,  3.050912e-01,  4.415467e-01,  8.528360e-01, -3.139914e-01},
  { 4.934040e-01,  8.140585e-01, -3.063679e-01,  4.429744e-01,  8.536323e-01, -3.097886e-01},
  {-4.514771e-01,  5.898618e-01, -6.695009e-01, -4.568661e-01,  5.985169e-01, -6.737338e-01},
  {-4.191952e-01,  6.012401e-01, -6.802836e-01, -4.266620e-01,  6.071923e-01, -6.856705e-01},
  {-4.692812e-01,  5.306503e-01, -7.058224e-01, -4.749925e-01,  5.375415e-01, -7.115452e-01},
  {-1.887651e-01,  6.438704e-01, -7.414840e-01, -1.924856e-01,  6.405755e-01, -7.572871e-01},
  {-1.726538e-01,  6.311866e-01, -7.561707e-01, -1.810762e-01,  6.343003e-01, -7.653406e-01},
  {-3.427755e-01,  4.612198e-01, -8.184016e-01, -3.367361e-01,  4.634013e-01, -8.323072e-01},
  {-1.352984e-01,  5.364985e-01, -8.329849e-01, -1.397098e-01,  5.454007e-01, -8.389820e-01},
  {-2.145307e-01,  4.710763e-01, -8.556072e-01, -2.234091e-01,  4.734680e-01, -8.641677e-01},
  { 4.203932e-01,  3.492116e-01,  8.374491e-01,  4.220736e-01,  3.533520e-01,  8.475350e-01},
  { 8.708727e-01,  3.407322e-01,  3.542348e-01,  8.804722e-01,  3.407720e-01,  3.598970e-01},
  { 8.646228e-01,  4.801413e-01,  1.479588e-01,  9.015818e-01,  4.001959e-01,  2.188097e-01},
  {-4.861543e-01,  7.618127e-01,  4.281299e-01, -4.869131e-01,  7.716839e-01,  4.339165e-01},
  {-3.816041e-01,  7.093621e-01,  5.926075e-01, -3.814970e-01,  7.204250e-01,  5.969194e-01},
  { 8.782471e-01,  4.748590e-01,  5.648877e-02,  8.763710e-01,  4.994119e-01,  5.871040e-02},
  {-5.133145e-01,  7.580886e-01,  4.022560e-01, -5.283815e-01,  7.559355e-01,  4.125989e-01},
  { 8.250161e-01,  5.516504e-01, -1.225982e-01,  8.410986e-01,  5.453327e-01, -1.266931e-01},
  {-5.318760e-01,  8.439005e-01,  7.028386e-02, -5.318111e-01,  8.566709e-01,  6.447906e-02},
  { 8.090101e-01,  5.717006e-01, -1.366058e-01,  8.186321e-01,  5.747273e-01, -1.428843e-01},
  { 7.733955e-01,  4.426388e-01, -4.537953e-01,  7.768949e-01,  5.682908e-01, -3.103648e-01},
  { 7.897828e-01,  6.102700e-01, -6.175384e-02,  8.023856e-01,  6.116870e-01, -5.387089e-02},
  {-5.564806e-01,  8.182975e-01,  1.439396e-01, -5.575165e-01,  8.314197e-01,  1.370443e-01},
  {-5.475693e-01,  8.168079e-01,  1.816390e-01, -5.671572e-01,  8.144169e-01,  1.895304e-01},
  { 7.483363e-01,  6.608822e-01, -5.681269e-02,  7.537681e-01,  6.698746e-01, -6.314477e-02},
  { 7.131638e-01,  6.991084e-01, -5.142751e-02,  7.213410e-01,  7.050228e-01, -5.912184e-02},
  { 6.722381e-01,  6.699810e-01, -3.149943e-01,  6.808574e-01,  6.731837e-01, -3.227106e-01},
  {-4.008117e-01,  8.963592e-01, -1.894472e-01, -4.010818e-01,  9.069073e-01, -1.937048e-01},
  { 6.945697e-01,  7.109745e-01, -1.099471e-01,  7.016328e-01,  7.184770e-01, -1.112996e-01},
  { 6.262379e-01,  7.066144e-01, -3.294272e-01,  6.317667e-01,  7.157047e-01, -3.309416e-01},
  {-2.648967e-01,  9.161360e-01, -3.008732e-01, -2.634666e-01,  9.242197e-01, -3.118897e-01},
  { 5.166565e-01,  7.959668e-01, -3.154409e-01,  5.138354e-01,  8.134194e-01, -3.085546e-01},
  { 5.041131e-01,  8.219481e-01, -2.650874e-01,  4.900372e-01,  8.358710e-01, -2.864733e-01},
  {-1.417287e-01,  9.159620e-01, -3.754019e-01, -1.399485e-01,  9.295231e-01, -3.705073e-01},
  { 3.792475e-01,  8.650418e-01, -3.284417e-01,  3.726746e-01,  8.784156e-01, -3.322378e-01},
  { 1.592374e-01,  9.093675e-01, -3.843099e-01,  1.595894e-01,  9.179611e-01, -3.914740e-01},
  { 9.789259e-02,  9.194398e-01, -3.808511e-01,  1.000755e-01,  9.268873e-01, -3.895424e-01},
  {-4.802981e-01,  5.794228e-01, -6.584702e-01, -4.870279e-01,  5.860751e-01, -6.634648e-01},
  {-3.598752e-01,  6.445721e-01, -6.745492e-01, -3.588954e-01,  6.618091e-01, -6.738482e-01},
  {-3.841926e-01,  6.133266e-01, -6.900917e-01, -3.831383e-01,  6.185064e-01, -7.010868e-01},
  {-2.669886e-01,  6.667232e-01, -6.958429e-01, -2.709960e-01,  6.695458e-01, -7.064984e-01},
  {-3.432316e-01,  5.459890e-01, -7.642566e-01, -3.581203e-01,  6.014959e-01, -7.285744e-01},
  { 5.807121e-01,  3.058525e-01,  7.544717e-01,  5.891250e-01,  3.088220e-01,  7.605503e-01},
  { 5.607221e-01,  3.523725e-01,  7.492826e-01,  5.658721e-01,  3.491318e-01,  7.607706e-01},
  { 4.673476e-01,  3.544551e-01,  8.099060e-01,  4.812216e-01,  3.566757e-01,  8.136848e-01},
  { 5.382434e-02,  4.732714e-01,  8.792709e-01,  4.788209e-02,  4.662070e-01,  8.951126e-01},
  { 4.196076e-02,  5.028845e-01,  8.633345e-01,  3.870796e-02,  5.032248e-01,  8.752914e-01},
  { 1.027723e-01,  4.507160e-01,  8.867316e-01,  1.013896e-01,  4.862907e-01,  8.798357e-01},
  {-4.736552e-03,  5.101137e-01,  8.600940e-01, -1.646137e-03,  5.184746e-01,  8.672079e-01},
  { 1.321099e-01,  4.450095e-01,  8.857277e-01,  1.325710e-01,  4.847166e-01,  8.765528e-01},
  { 8.436633e-01,  3.556756e-01,  4.021530e-01,  8.503169e-01,  3.611979e-01,  4.091202e-01},
  { 1.715916e-01,  4.442132e-01,  8.793356e-01,  1.933378e-01,  4.669886e-01,  8.748788e-01},
  { 2.503178e-01,  4.584247e-01,  8.527531e-01,  2.490631e-01,  4.626762e-01,  8.630006e-01},
  { 8.840218e-01,  3.641154e-01,  2.931306e-01,  8.883841e-01,  3.780226e-01,  2.979195e-01},
  {-1.792804e-01,  6.340505e-01,  7.522224e-01, -1.770739e-01,  6.424115e-01,  7.594860e-01},
  {-6.331952e-02,  5.650338e-01,  8.226345e-01, -1.222703e-01,  6.322355e-01,  7.785858e-01},
  {-7.234658e-02,  6.093765e-01,  7.895734e-01, -1.223921e-01,  6.351340e-01,  7.774669e-01},
  { 8.794994e-01,  4.407850e-01,  1.794140e-01,  8.952865e-01,  4.270580e-01,  1.922703e-01},
  {-4.451622e-01,  7.542319e-01,  4.826643e-01, -4.472575e-01,  7.640022e-01,  4.869556e-01},
  { 8.670890e-01,  4.725510e-01,  1.576458e-01,  8.863114e-01,  4.644896e-01,  1.399516e-01},
  {-3.416218e-01,  7.330620e-01,  5.881450e-01, -3.538155e-01,  7.324849e-01,  5.992879e-01},
  {-4.027833e-01,  7.254947e-01,  5.580530e-01, -4.011738e-01,  7.414890e-01,  5.568828e-01},
  {-5.151379e-01,  8.566306e-01,  2.858667e-02, -5.096361e-01,  8.735785e-01,  1.423855e-02},
  {-5.644669e-01,  7.163615e-01,  4.101260e-01, -5.617394e-01,  7.293789e-01,  4.163142e-01},
  { 8.204137e-01,  5.597038e-01,  1.168464e-01,  8.202044e-01,  5.897484e-01, -1.863602e-02},
  { 8.187847e-01,  5.453377e-01, -1.794391e-01,  8.221738e-01,  5.583858e-01, -1.819929e-01},
  {-5.592656e-01,  7.448686e-01,  3.638583e-01, -5.714519e-01,  7.492493e-01,  3.645967e-01},
  { 7.846262e-01,  5.981541e-01, -1.630138e-01,  7.950339e-01,  5.996958e-01, -1.707977e-01},
  {-4.397561e-01,  8.912790e-01, -1.106173e-01, -4.364314e-01,  9.045425e-01, -1.104477e-01},
  { 7.625457e-01,  6.410382e-01, -8.714410e-02,  7.664372e-01,  6.515991e-01, -9.422441e-02},
  { 7.903804e-01,  6.027622e-01, -1.094370e-01,  7.921878e-01,  6.155919e-01, -1.198785e-01},
  { 7.288176e-01,  6.776410e-01, -9.812068e-02,  7.340899e-01,  6.874965e-01, -9.667569e-02},
  { 7.557243e-01,  6.421258e-01, -1.286675e-01,  7.658114e-01,  6.493226e-01, -1.131317e-01},
  {-5.945168e-01,  7.272270e-01,  3.430606e-01, -6.017807e-01,  7.373982e-01,  3.390662e-01},
  {-5.890729e-01,  7.655230e-01,  2.587813e-01, -6.055995e-01,  7.627688e-01,  2.688782e-01},
  {-3.694804e-01,  9.064521e-01, -2.045211e-01, -3.772194e-01,  9.129023e-01, -2.125668e-01},
  {-3.133804e-01,  9.135143e-01, -2.593922e-01, -3.228542e-01,  9.220285e-01, -2.578749e-01},
  { 6.097150e-01,  7.773709e-01, -1.547317e-01,  6.197898e-01,  7.821781e-01, -1.579330e-01},
  { 5.636171e-01,  7.648514e-01, -3.119906e-01,  5.692648e-01,  7.730812e-01, -3.149086e-01},
  {-2.126849e-01,  9.194084e-01, -3.308372e-01, -2.119484e-01,  9.298553e-01, -3.336464e-01},
  { 5.428125e-01,  7.934116e-01, -2.754138e-01,  5.620424e-01,  7.848657e-01, -2.982925e-01},
  {-1.084128e-01,  9.294852e-01, -3.525677e-01, -1.046660e-01,  9.417407e-01, -3.507771e-01},
  {-6.097561e-02,  9.284104e-01, -3.665189e-01, -7.635408e-02,  9.378101e-01, -3.681820e-01},
  { 3.266017e-01,  8.852325e-01, -3.312019e-01,  3.305101e-01,  8.940427e-01, -3.385104e-01},
  { 2.745701e-01,  8.959774e-01, -3.490498e-01,  2.836233e-01,  9.062749e-01, -3.451155e-01},
  { 2.136533e-01,  9.021173e-01, -3.748824e-01,  2.058233e-01,  9.158524e-01, -3.738067e-01},
  { 1.509732e-03,  9.302450e-01, -3.669359e-01,  1.711462e-02,  9.389642e-01, -3.727337e-01},
  {-7.402182e-02,  3.755292e-01, -9.238499e-01, -3.232186e-01,  6.067762e-01, -7.416826e-01},
  {-4.051737e-01,  5.598621e-01, -7.227646e-01, -4.193040e-01,  5.643144e-01, -7.256722e-01},
  {-1.006776e-01,  3.997949e-01, -9.110588e-01, -3.263964e-01,  6.024560e-01, -7.425502e-01},
  {-2.184739e-01,  4.634486e-01, -8.587692e-01, -3.368958e-01,  5.922675e-01, -7.460488e-01},
  {-4.443971e-01,  5.005273e-01, -7.429560e-01, -4.517187e-01,  5.105814e-01, -7.457361e-01},
  {-1.522625e-01,  6.014523e-01, -7.842649e-01, -1.571114e-01,  5.909809e-01, -8.043190e-01},
  {-3.948937e-01,  4.816262e-01, -7.823651e-01, -4.032546e-01,  4.832944e-01, -7.903661e-01},
  {-2.787518e-01,  4.745493e-01, -8.349254e-01, -2.845385e-01,  4.847847e-01, -8.395773e-01},
  { 6.213910e-01,  3.054821e-01,  7.214942e-01,  6.234683e-01,  3.172740e-01,  7.290413e-01},
  { 6.370729e-01,  3.299755e-01,  6.966019e-01,  6.420674e-01,  3.290239e-01,  7.073684e-01},
  { 7.611412e-01,  3.331151e-01,  5.565055e-01,  6.869771e-01,  3.273493e-01,  6.659306e-01},
  { 6.939210e-01,  3.203493e-01,  6.448643e-01,  7.013692e-01,  3.190530e-01,  6.535785e-01},
  { 5.906200e-01,  3.552736e-01,  7.245334e-01,  6.030154e-01,  3.548381e-01,  7.289302e-01},
  { 7.338566e-01,  3.376930e-01,  5.894216e-01,  7.461945e-01,  3.404337e-01,  5.900663e-01},
  { 3.861313e-01,  4.013208e-01,  8.305687e-01,  3.547816e-01,  4.080329e-01,  8.535292e-01},
  { 7.943831e-01,  3.441657e-01,  5.005051e-01,  8.022088e-01,  3.528146e-01,  5.028557e-01},
  { 3.004519e-01,  4.415654e-01,  8.454281e-01,  3.084350e-01,  4.525084e-01,  8.491034e-01},
  {-1.955187e-02,  5.430974e-01,  8.394420e-01, -1.968305e-02,  5.541234e-01,  8.446467e-01},
  {-4.907656e-02,  5.705402e-01,  8.198019e-01, -4.441595e-02,  5.750601e-01,  8.295790e-01},
  {-8.878917e-02,  5.948306e-01,  7.989325e-01, -9.598879e-02,  6.019703e-01,  8.057825e-01},
  {-2.202514e-01,  6.572006e-01,  7.208167e-01, -2.163958e-01,  6.700549e-01,  7.246143e-01},
  {-2.211062e-01,  7.179465e-01,  6.600490e-01, -1.224545e-01,  6.380866e-01,  7.737687e-01},
  { 8.751928e-01,  3.969011e-01,  2.765991e-01,  8.846908e-01,  4.003453e-01,  2.791584e-01},
  { 8.346683e-01,  5.389602e-01,  1.133612e-01,  8.875570e-01,  4.174865e-01,  2.425525e-01},
  {-2.751954e-01,  7.095126e-01,  6.487367e-01, -2.908985e-01,  7.097502e-01,  6.576464e-01},
  {-3.247478e-01,  7.070051e-01,  6.282377e-01, -3.129617e-01,  7.139510e-01,  6.428022e-01},
  {-4.406327e-01,  7.967690e-01,  4.135238e-01, -4.559650e-01,  7.888536e-01,  4.366587e-01},
  {-3.687365e-01,  7.455307e-01,  5.551732e-01, -3.729848e-01,  7.510837e-01,  5.635788e-01},
  {-4.096292e-01,  7.540171e-01,  5.134804e-01, -4.120375e-01,  7.676846e-01,  5.116158e-01},
  {-5.159971e-01,  7.788386e-01,  3.565916e-01, -5.228162e-01,  7.834179e-01,  3.657642e-01},
  { 8.325428e-01,  5.197541e-01, -1.916461e-01,  8.379045e-01,  5.318621e-01, -1.895378e-01},
  { 8.403809e-01,  5.408354e-01,  3.545504e-02,  8.495787e-01,  5.457790e-01,  3.502350e-02},
  { 8.218421e-01,  5.693647e-01,  1.998553e-02,  8.388030e-01,  5.630226e-01,  1.734085e-02},
  {-5.535573e-01,  7.991074e-01,  2.345243e-01, -5.461345e-01,  8.181728e-01,  2.306397e-01},
  { 7.460471e-01,  6.363780e-01, -1.960535e-01,  8.182430e-01,  5.530882e-01, -2.132082e-01},
  {-5.562281e-01,  7.827283e-01,  2.791892e-01, -5.557556e-01,  7.918280e-01,  2.915609e-01},
  {-5.198807e-01,  8.441671e-01,  1.307903e-01, -5.236161e-01,  8.541847e-01,  1.306144e-01},
  {-5.016029e-01,  8.608857e-01,  8.526555e-02, -5.732827e-01,  7.713102e-01,  3.130721e-01},
  { 7.836311e-01,  5.824134e-01, -2.161411e-01,  7.921306e-01,  5.904313e-01, -2.116737e-01},
  { 7.570356e-01,  6.313274e-01, -1.682938e-01,  7.684585e-01,  6.311361e-01, -1.792698e-01},
  {-5.661689e-01,  8.030924e-01,  1.857298e-01, -5.936587e-01,  7.598742e-01,  3.017004e-01},
  {-3.966416e-01,  9.071362e-01, -1.406391e-01, -4.013729e-01,  9.150999e-01, -1.495363e-01},
  { 7.220533e-01,  6.778156e-01, -1.385817e-01,  7.219603e-01,  6.922501e-01, -1.429990e-01},
  {-3.855605e-01,  9.063914e-01, -1.726199e-01, -3.918493e-01,  9.166797e-01, -1.643828e-01},
  { 6.511543e-01,  7.420277e-01, -1.593514e-01,  6.556913e-01,  7.490981e-01, -1.726445e-01},
  {-2.679643e-01,  9.266698e-01, -2.635870e-01, -2.709476e-01,  9.352226e-01, -2.698478e-01},
  { 6.382948e-01,  7.437502e-01, -1.985332e-01,  6.406392e-01,  7.581421e-01, -1.889100e-01},
  { 6.074005e-01,  7.332383e-01, -3.056569e-01,  6.131864e-01,  7.400811e-01, -3.117167e-01},
  { 5.797707e-01,  7.760614e-01, -2.481826e-01,  5.889736e-01,  7.813160e-01, -2.520718e-01},
  { 5.385235e-01,  8.065722e-01, -2.437907e-01,  5.417514e-01,  8.185142e-01, -2.399493e-01},
  {-1.429712e-01,  9.343067e-01, -3.265430e-01, -1.519755e-01,  9.445149e-01, -3.250684e-01},
  { 3.899549e-01,  8.722584e-01, -2.951278e-01,  3.961877e-01,  8.794425e-01, -3.008304e-01},
  { 4.359793e-01,  8.538162e-01, -2.844647e-01,  4.419159e-01,  8.637396e-01, -2.830287e-01},
  {-2.796485e-01,  4.297792e-01, -8.585374e-01, -3.190383e-01,  6.160554e-01, -7.350761e-01},
  {-2.452203e-01,  6.329207e-01, -7.343557e-01, -2.535228e-01,  6.373475e-01, -7.418792e-01},
  {-2.486227e-01,  5.186767e-01, -8.180228e-01, -2.980188e-01,  6.218926e-01, -7.384469e-01},
  {-1.840837e-01,  5.326925e-01, -8.260459e-01, -1.765094e-01,  5.413398e-01, -8.346655e-01},
  {-2.167525e-01,  5.155561e-01, -8.289875e-01, -2.414954e-01,  4.977520e-01, -8.454539e-01},
  { 5.236331e-01,  3.774736e-01,  7.637553e-01,  5.316563e-01,  3.822641e-01,  7.694749e-01},
  { 4.128788e-01,  3.882678e-01,  8.238805e-01,  4.057515e-01,  3.900515e-01,  8.391061e-01},
  { 7.559850e-01,  3.486227e-01,  5.540296e-01,  7.686967e-01,  3.549409e-01,  5.513643e-01},
  { 8.049790e-01,  3.768687e-01,  4.582344e-01,  8.170667e-01,  3.757280e-01,  4.605564e-01},
  { 1.643656e-01,  5.000617e-01,  8.502484e-01,  1.661938e-01,  4.971614e-01,  8.637598e-01},
  { 2.695494e-01,  4.776515e-01,  8.361771e-01,  2.695599e-01,  4.800221e-01,  8.472240e-01},
  { 2.088002e-02,  5.437427e-01,  8.389922e-01,  1.493908e-02,  5.504864e-01,  8.471189e-01},
  {-8.152612e-02,  6.336948e-01,  7.692752e-01, -8.617142e-02,  6.408205e-01,  7.763968e-01},
  { 8.582298e-01,  3.828900e-01,  3.418140e-01,  8.606533e-01,  4.071760e-01,  3.381816e-01},
  {-4.968366e-02,  6.441702e-01,  7.632668e-01, -1.171984e-01,  6.499709e-01,  7.646374e-01},
  {-1.712337e-01,  6.357253e-01,  7.526835e-01, -1.568747e-01,  6.611598e-01,  7.477469e-01},
  {-2.678278e-01,  6.866524e-01,  6.758525e-01, -2.615697e-01,  6.965771e-01,  6.835407e-01},
  {-4.708371e-01,  8.068373e-01,  3.568277e-01, -4.739893e-01,  8.160325e-01,  3.609574e-01},
  {-5.161203e-01,  8.088964e-01,  2.816141e-01, -5.225580e-01,  8.133264e-01,  2.937645e-01},
  {-5.193698e-01,  8.261040e-01,  2.186486e-01, -5.290602e-01,  8.343135e-01,  2.118517e-01},
  {-4.491487e-01,  8.911087e-01, -6.473535e-02, -4.517580e-01,  9.021754e-01, -5.349899e-02},
  {-4.707114e-01,  8.817903e-01,  2.960578e-02, -4.838409e-01,  8.880830e-01,  1.774485e-02},
  {-5.025627e-01,  8.416758e-01,  1.975158e-01, -5.554495e-01,  7.802004e-01,  3.219107e-01},
  { 6.833093e-01,  7.029520e-01, -1.973501e-01,  8.131991e-01,  5.530054e-01, -2.334011e-01},
  {-4.840513e-01,  8.712656e-01,  8.118293e-02, -5.030153e-01,  8.723623e-01,  8.261772e-02},
  {-4.078791e-01,  9.052539e-01, -1.189535e-01, -4.085301e-01,  9.160041e-01, -1.221001e-01},
  { 7.198851e-01,  6.706725e-01, -1.787842e-01,  7.254582e-01,  6.832593e-01, -1.665915e-01},
  { 6.485672e-01,  7.030687e-01, -2.916421e-01,  6.575323e-01,  7.045230e-01, -3.036179e-01},
  {-3.376997e-01,  9.157897e-01, -2.174584e-01, -3.404244e-01,  9.247436e-01, -2.232286e-01},
  { 6.843033e-01,  7.111257e-01, -1.613358e-01,  6.905143e-01,  7.160447e-01, -1.770745e-01},
  { 6.107545e-01,  7.619293e-01, -2.155053e-01,  6.205112e-01,  7.685450e-01, -2.125779e-01},
  {-2.150751e-01,  9.366285e-01, -2.765317e-01, -2.150411e-01,  9.464733e-01, -2.807466e-01},
  { 5.078543e-01,  8.380278e-01, -1.994826e-01,  5.722942e-01,  8.059351e-01, -2.093617e-01},
  {-1.699336e-01,  9.346457e-01, -3.123460e-01, -1.732345e-01,  9.459218e-01, -3.099926e-01},
  { 3.445703e-01,  8.919638e-01, -2.926975e-01,  3.367405e-01,  9.015348e-01, -3.077706e-01},
  { 4.826832e-01,  8.354503e-01, -2.627539e-01,  4.740689e-01,  8.532611e-01, -2.609363e-01},
  { 2.304964e-01,  9.140558e-01, -3.337266e-01,  2.350279e-01,  9.202159e-01, -3.447394e-01},
  { 4.352183e-02,  9.368361e-01, -3.470502e-01,  3.898373e-02,  9.466810e-01, -3.509314e-01},
  {-3.258969e-01,  5.013586e-01, -8.015178e-01, -3.330067e-01,  4.962243e-01, -8.146997e-01},
  { 4.645414e-01,  3.961682e-01,  7.919925e-01,  4.784618e-01,  3.949062e-01,  7.974951e-01},
  { 4.953164e-01,  3.832484e-01,  7.796040e-01,  4.975016e-01,  3.862436e-01,  7.903611e-01},
  { 4.580365e-01,  4.127992e-01,  7.872733e-01,  3.585000e-01,  4.566059e-01,  8.282226e-01},
  { 3.158138e-01,  4.772694e-01,  8.200461e-01,  3.227906e-01,  4.777197e-01,  8.297368e-01},
  { 2.903920e-01,  4.939475e-01,  8.195660e-01,  2.936102e-01,  4.950862e-01,  8.307710e-01},
  { 8.212381e-01,  4.057296e-01,  4.011877e-01,  8.341456e-01,  4.071229e-01,  3.991673e-01},
  { 8.388038e-01,  4.100916e-01,  3.580964e-01,  8.485094e-01,  4.272303e-01,  3.471756e-01},
  { 8.322216e-01,  5.246722e-01,  1.792381e-01,  8.699352e-01,  4.378493e-01,  2.690439e-01},
  {-1.713787e-01,  6.770304e-01,  7.157228e-01, -1.848383e-01,  6.760244e-01,  7.278001e-01},
  {-3.054618e-01,  7.416058e-01,  5.972553e-01, -3.079644e-01,  7.481529e-01,  6.052202e-01},
  {-4.603114e-01,  7.980995e-01,  3.887811e-01, -4.545807e-01,  8.089511e-01,  3.997747e-01},
  { 8.522697e-01,  5.087572e-01,  1.216658e-01,  8.669659e-01,  5.024970e-01,  1.294290e-01},
  {-4.853546e-01,  8.184592e-01,  3.074986e-01, -4.912065e-01,  8.299378e-01,  3.013045e-01},
  { 8.227512e-01,  5.177175e-01, -2.346252e-01,  8.190472e-01,  5.431805e-01, -2.345262e-01},
  { 7.437130e-01,  6.237533e-01, -2.404635e-01,  8.093520e-01,  5.532995e-01, -2.443250e-01},
  { 7.582945e-01,  6.002474e-01, -2.543471e-01,  7.688421e-01,  6.024841e-01, -2.584192e-01},
  { 7.419359e-01,  6.312620e-01, -2.259187e-01,  7.518787e-01,  6.393631e-01, -2.162843e-01},
  {-2.936122e-01,  9.308573e-01, -2.174779e-01, -3.018167e-01,  9.389958e-01, -2.192367e-01},
  { 6.776011e-01,  7.066109e-01, -2.038570e-01,  6.831809e-01,  7.155183e-01, -2.053846e-01},
  {-1.754104e-01,  9.408810e-01, -2.897828e-01, -1.731595e-01,  9.522891e-01, -2.898881e-01},
  {-9.107388e-02,  9.433212e-01, -3.191406e-01, -9.244848e-02,  9.539024e-01, -3.199983e-01},
  { 5.106632e-01,  8.243665e-01, -2.442190e-01,  5.079885e-01,  8.403151e-01, -2.381220e-01},
  {-4.560224e-02,  9.428619e-01, -3.300482e-01, -4.750592e-02,  9.522598e-01, -3.343959e-01},
  { 4.530211e-01,  8.544075e-01, -2.544792e-01,  4.526402e-01,  8.650507e-01, -2.601679e-01},
  { 1.730965e-01,  9.256223e-01, -3.365426e-01,  1.798028e-01,  9.303927e-01, -3.505997e-01},
  { 1.298100e-01,  9.227241e-01, -3.629458e-01,  1.323128e-01,  9.342463e-01, -3.613258e-01},
  { 7.020308e-02,  9.384090e-01, -3.383196e-01,  8.224478e-02,  9.502153e-01, -3.334738e-01},
  {-3.199391e-01,  6.432884e-01, -6.955711e-01, -3.253769e-01,  6.493175e-01, -7.024142e-01},
  {-2.074189e-01,  6.194882e-01, -7.571074e-01, -2.307574e-01,  6.093108e-01, -7.722448e-01},
  {-4.145200e-01,  5.162784e-01, -7.494197e-01, -4.150589e-01,  5.233139e-01, -7.581128e-01},
  {-1.913756e-01,  5.943162e-01, -7.811298e-01, -1.938125e-01,  5.960132e-01, -7.925125e-01},
  { 7.087679e-01,  3.599936e-01,  6.066735e-01,  7.128868e-01,  3.627568e-01,  6.173161e-01},
  { 5.462248e-01,  3.964176e-01,  7.378967e-01,  5.416466e-01,  4.063973e-01,  7.498911e-01},
  { 3.922078e-01,  4.351900e-01,  8.104213e-01,  4.001929e-01,  4.371514e-01,  8.183021e-01},
  { 7.688637e-01,  3.742042e-01,  5.184783e-01,  7.693825e-01,  3.747253e-01,  5.371333e-01},
  { 1.001816e-01,  5.098656e-01,  8.544008e-01,  1.060100e-01,  5.206131e-01,  8.594148e-01},
  { 2.102674e-01,  4.910044e-01,  8.454007e-01,  2.156848e-01,  5.026242e-01,  8.495414e-01},
  {-3.923121e-02,  6.044736e-01,  7.956586e-01, -3.073092e-02,  6.096350e-01,  8.051519e-01},
  {-1.169838e-01,  6.677992e-01,  7.350912e-01, -1.111459e-01,  6.770926e-01,  7.416607e-01},
  { 8.600687e-01,  4.557171e-01,  2.293552e-01,  8.699194e-01,  4.636617e-01,  2.216806e-01},
  {-4.148197e-01,  8.011717e-01,  4.313334e-01, -4.263387e-01,  7.988160e-01,  4.489228e-01},
  { 8.404456e-01,  5.366247e-01,  7.539986e-02,  8.469125e-01,  5.457336e-01,  7.615390e-02},
  {-4.980211e-01,  8.477244e-01,  1.825879e-01, -5.011397e-01,  8.543400e-01,  1.995692e-01},
  {-4.146809e-01,  9.082615e-01, -5.568385e-02, -4.241236e-01,  9.149506e-01, -6.207074e-02},
  { 7.924533e-01,  6.099282e-01,  2.299591e-03,  7.953833e-01,  6.230971e-01, -1.021505e-03},
  {-4.741787e-01,  8.719558e-01,  1.218513e-01, -4.815105e-01,  8.811905e-01,  1.118809e-01},
  {-3.660118e-01,  9.197423e-01, -1.418072e-01, -3.708894e-01,  9.284237e-01, -1.460835e-01},
  { 5.825867e-01,  8.037173e-01, -1.209594e-01,  5.807223e-01,  8.079730e-01, -1.812875e-01},
  { 6.062535e-01,  7.466374e-01, -2.738418e-01,  6.138502e-01,  7.533560e-01, -2.766361e-01},
  { 3.001123e-01,  9.088681e-01, -2.896401e-01,  2.978404e-01,  9.167696e-01, -3.028301e-01},
  { 2.140942e-02,  9.481378e-01, -3.171375e-01, -1.003940e-03,  9.582585e-01, -3.203382e-01},
  { 6.660019e-02,  9.515867e-01, -3.000787e-01,  7.556882e-02,  9.593997e-01, -3.077656e-01},
  { 1.129919e-01,  9.393311e-01, -3.238673e-01,  1.160614e-01,  9.496446e-01, -3.249926e-01},
  {-2.704533e-01,  5.945379e-01, -7.572184e-01, -2.620145e-01,  6.024299e-01, -7.676565e-01},
  {-3.702774e-01,  5.328587e-01, -7.608919e-01, -3.782025e-01,  5.378596e-01, -7.676040e-01},
  { 7.137449e-01,  3.707362e-01,  5.942414e-01,  6.730450e-01,  3.671756e-01,  6.580812e-01},
  { 7.472749e-01,  4.087853e-01,  5.239034e-01,  7.634474e-01,  4.012760e-01,  5.263140e-01},
  { 7.786085e-01,  3.961926e-01,  4.866212e-01,  7.858088e-01,  4.053871e-01,  4.889245e-01},
  { 2.363237e-01,  5.098856e-01,  8.271443e-01,  2.341940e-01,  5.173422e-01,  8.356927e-01},
  { 8.152676e-01,  4.220084e-01,  3.965447e-01,  8.271335e-01,  4.423231e-01,  3.756106e-01},
  {-2.126825e-01,  6.968204e-01,  6.849873e-01, -2.089224e-01,  7.077797e-01,  6.901207e-01},
  { 8.434049e-01,  4.529704e-01,  2.889394e-01,  8.428730e-01,  4.613103e-01,  3.124761e-01},
  {-3.177657e-01,  7.664384e-01,  5.582089e-01, -3.234558e-01,  7.829139e-01,  5.507165e-01},
  {-3.495266e-01,  7.715256e-01,  5.315821e-01, -3.489674e-01,  7.788571e-01,  5.408047e-01},
  {-3.773910e-01,  7.872323e-01,  4.876897e-01, -3.748814e-01,  7.998696e-01,  4.904474e-01},
  {-4.886630e-01,  8.362053e-01,  2.489361e-01, -4.869697e-01,  8.474022e-01,  2.561943e-01},
  { 7.607114e-01,  6.489112e-01, -1.524419e-02,  7.718306e-01,  6.519510e-01, -1.109986e-02},
  { 7.255645e-01,  6.880751e-01, -1.043529e-02,  7.267734e-01,  7.013205e-01, -2.890289e-02},
  { 6.859608e-01,  7.260378e-01, -4.823877e-02,  6.920388e-01,  7.360255e-01, -4.450250e-02},
  { 6.319364e-01,  7.710246e-01, -7.859717e-02,  6.449784e-01,  7.727973e-01, -8.759113e-02},
  {-2.403066e-01,  9.444010e-01, -2.244093e-01, -2.360994e-01,  9.542906e-01, -2.333650e-01},
  { 6.672839e-01,  7.106640e-01, -2.229103e-01,  6.661087e-01,  7.214021e-01, -2.382508e-01},
  { 6.458813e-01,  7.188768e-01, -2.570085e-01,  6.487976e-01,  7.320008e-01, -2.532224e-01},
  { 7.264158e-01,  6.795456e-01, -1.026543e-01,  5.815998e-01,  8.076181e-01, -1.742965e-01},
  { 5.200996e-01,  8.303126e-01, -2.001938e-01,  5.231138e-01,  8.381946e-01, -2.113428e-01},
  { 2.670437e-01,  9.167036e-01, -2.972239e-01,  2.731493e-01,  9.253688e-01, -2.999388e-01},
  {-3.153431e-01,  5.623211e-01, -7.644303e-01, -3.134859e-01,  5.718476e-01, -7.717420e-01},
  {-2.112467e-01,  5.421726e-01, -8.132797e-01, -2.182770e-01,  5.500636e-01, -8.189355e-01},
  { 4.527037e-01,  4.271715e-01,  7.826774e-01,  4.646764e-01,  4.216001e-01,  7.919623e-01},
  { 5.618037e-01,  4.159194e-01,  7.151137e-01,  5.769207e-01,  4.170684e-01,  7.170032e-01},
  { 4.253399e-01,  4.533753e-01,  7.832859e-01,  4.183348e-01,  4.625642e-01,  7.949247e-01},
  { 7.319658e-01,  3.846972e-01,  5.623471e-01,  7.361764e-01,  3.925310e-01,  5.699508e-01},
  { 4.237922e-01,  4.540672e-01,  7.837239e-01,  3.681640e-01,  4.924320e-01,  8.017731e-01},
  { 1.402725e-01,  5.383168e-01,  8.309866e-01,  1.474546e-01,  5.363820e-01,  8.434585e-01},
  { 6.789220e-02,  5.479578e-01,  8.337464e-01,  6.793743e-02,  5.528938e-01,  8.429487e-01},
  { 1.601255e-02,  5.852106e-01,  8.107232e-01,  1.275540e-02,  5.961151e-01,  8.156920e-01},
  {-1.407359e-02,  6.292375e-01,  7.770857e-01, -1.292657e-02,  6.339696e-01,  7.866288e-01},
  { 2.277340e-01,  5.989997e-01,  7.676826e-01,  2.436169e-01,  6.000531e-01,  7.755389e-01},
  {-1.142293e-01,  6.976417e-01,  7.072819e-01, -1.270506e-01,  6.938989e-01,  7.233471e-01},
  {-2.559480e-01,  7.479651e-01,  6.124042e-01, -2.661736e-01,  7.594862e-01,  6.109005e-01},
  {-2.745598e-01,  7.650857e-01,  5.824611e-01, -2.774496e-01,  7.676630e-01,  5.954682e-01},
  { 7.681558e-01,  5.688062e-01, -2.939325e-01,  7.695391e-01,  5.863520e-01, -2.913531e-01},
  {-7.409204e-01, -6.544223e-01,  1.508919e-01,  7.618142e-01,  5.939965e-01, -2.961298e-01},
  { 7.181141e-01,  4.787892e-01, -5.050474e-01,  7.600755e-01,  5.957451e-01, -2.970836e-01},
  { 7.253188e-01,  6.283769e-01, -2.811674e-01,  7.206026e-01,  6.434728e-01, -2.959057e-01},
  {-3.317662e-01,  9.273807e-01, -1.729055e-01, -3.249075e-01,  9.421160e-01, -1.665031e-01},
  {-1.923971e-01,  9.542326e-01, -2.289619e-01, -2.019822e-01,  9.610763e-01, -2.375053e-01},
  {-1.647659e-01,  9.507216e-01, -2.626419e-01, -1.640214e-01,  9.608609e-01, -2.659270e-01},
  {-1.519148e-01,  9.843025e-01, -8.983565e-02, -1.504282e-01,  9.959902e-01, -7.905161e-02},
  { 5.637255e-01,  8.122535e-01, -1.498593e-01,  5.818830e-01,  8.089330e-01, -1.671049e-01},
  {-1.256738e-01,  9.494878e-01, -2.875395e-01, -1.140205e-01,  9.604732e-01, -2.921737e-01},
  { 4.695926e-01,  8.553694e-01, -2.186915e-01,  4.832846e-01,  8.588958e-01, -2.227499e-01},
  { 3.580287e-01,  8.929815e-01, -2.727627e-01,  3.715816e-01,  9.023132e-01, -2.619930e-01},
  {-7.828823e-02,  9.576554e-01, -2.770686e-01, -7.762328e-02,  9.683610e-01, -2.777174e-01},
  {-3.190398e-02,  9.571542e-01, -2.878160e-01, -3.760236e-02,  9.672142e-01, -2.897571e-01},
  { 4.134864e-01,  8.764024e-01, -2.468764e-01,  4.090385e-01,  8.904361e-01, -2.463609e-01},
  {-3.090728e-02,  9.688879e-01, -2.455627e-01, -4.191955e-02,  9.767464e-01, -2.551180e-01},
  { 1.396958e-01,  9.452937e-01, -2.947965e-01,  1.246131e-01,  9.552654e-01, -3.046611e-01},
  {-2.463642e-01,  5.727214e-01, -7.818534e-01, -2.481527e-01,  5.753644e-01, -7.926198e-01},
  {-2.940342e-01,  5.312043e-01, -7.945853e-01, -2.936400e-01,  5.383914e-01, -8.029813e-01},
  { 6.172246e-01,  3.920590e-01,  6.821463e-01,  6.250183e-01,  4.000163e-01,  6.869867e-01},
  { 7.005588e-01,  3.984757e-01,  5.919750e-01,  7.123200e-01,  3.961176e-01,  5.971354e-01},
  { 3.149085e-01,  5.203600e-01,  7.937620e-01,  3.284897e-01,  5.222145e-01,  8.001627e-01},
  { 2.686219e-01,  5.288253e-01,  8.051000e-01,  2.644886e-01,  5.406792e-01,  8.115324e-01},
  { 2.350333e-01,  5.562522e-01,  7.970840e-01,  2.399117e-01,  5.575649e-01,  8.078291e-01},
  { 7.893163e-01,  4.228192e-01,  4.452008e-01,  7.947832e-01,  4.307090e-01,  4.513218e-01},
  { 8.176758e-01,  4.634839e-01,  3.414513e-01,  8.176076e-01,  4.783779e-01,  3.515047e-01},
  { 1.941012e-01,  6.407750e-01,  7.427868e-01,  1.932732e-01,  6.519353e-01,  7.473280e-01},
  {-8.174012e-02,  6.804679e-01,  7.282046e-01, -8.520773e-02,  6.892498e-01,  7.338552e-01},
  { 8.404634e-01,  4.681727e-01,  2.728290e-01,  8.396270e-01,  4.875507e-01,  2.796508e-01},
  { 8.234083e-01,  4.758225e-01,  3.091792e-01,  8.273941e-01,  4.937735e-01,  3.075367e-01},
  { 8.469400e-01,  4.909142e-01,  2.041955e-01,  8.494781e-01,  5.003314e-01,  2.212233e-01},
  {-3.900706e-01,  8.221114e-01,  4.147021e-01, -3.870594e-01,  8.152965e-01,  4.542497e-01},
  {-2.776537e-01,  7.794067e-01,  5.616348e-01, -2.842163e-01,  7.850699e-01,  5.689935e-01},
  {-2.658884e-01,  7.859899e-01,  5.581427e-01, -2.773917e-01,  7.957085e-01,  5.574669e-01},
  {-3.458150e-01,  8.079076e-01,  4.771763e-01, -3.505001e-01,  8.141710e-01,  4.849144e-01},
  {-3.147467e-01,  8.037176e-01,  5.049480e-01, -3.181455e-01,  8.084638e-01,  5.157878e-01},
  { 8.253229e-01,  5.529252e-01,  1.145244e-01,  8.308538e-01,  5.632783e-01,  1.152589e-01},
  { 8.262079e-01,  5.559519e-01,  9.109348e-02,  8.327796e-01,  5.647382e-01,  9.183811e-02},
  {-4.425394e-01,  8.599020e-01,  2.544159e-01, -4.593178e-01,  8.659968e-01,  2.448324e-01},
  { 8.071104e-01,  5.883167e-01,  4.956105e-02,  8.136862e-01,  5.967769e-01,  5.155103e-02},
  {-4.550780e-01,  8.647106e-01,  2.125548e-01, -4.662615e-01,  8.689207e-01,  2.200982e-01},
  {-4.334581e-01,  8.999014e-01,  4.786967e-02, -4.360430e-01,  9.106819e-01,  3.731881e-02},
  {-4.579130e-01,  8.733522e-01,  1.660471e-01, -4.523011e-01,  8.874287e-01,  1.695904e-01},
  {-3.776545e-01,  9.213042e-01, -9.260530e-02, -3.790205e-01,  9.329577e-01, -8.247952e-02},
  {-4.226068e-01,  8.885213e-01,  1.786990e-01, -4.272225e-01,  8.992860e-01,  1.721420e-01},
  {-3.353340e-01,  9.357584e-01, -1.091214e-01, -3.380699e-01,  9.434448e-01, -1.284175e-01},
  { 7.088842e-01,  6.700128e-01, -2.203770e-01,  7.247283e-01,  6.649772e-01, -2.312136e-01},
  { 6.587639e-01,  7.508203e-01, -4.794936e-02,  6.645803e-01,  7.591072e-01, -5.453692e-02},
  { 6.293595e-01,  7.757806e-01, -4.550936e-02,  6.248193e-01,  7.866016e-01, -1.083683e-01},
  {-1.411872e-01,  9.804673e-01, -1.369308e-01, -1.347602e-01,  9.910271e-01, -1.434557e-01},
  { 2.375887e-01,  9.305082e-01, -2.787582e-01,  2.395115e-01,  9.392766e-01, -2.850864e-01},
  { 9.189591e-02,  9.574407e-01, -2.736100e-01,  9.450987e-02,  9.684446e-01, -2.721423e-01},
  { 1.221777e-01,  9.588601e-01, -2.562419e-01,  1.242443e-01,  9.677402e-01, -2.625283e-01},
  { 1.913214e-01,  9.354451e-01, -2.972180e-01,  1.975800e-01,  9.464436e-01, -2.934054e-01},
  { 2.069106e-02,  9.621202e-01, -2.718392e-01,  2.568362e-02,  9.732566e-01, -2.701650e-01},
  {-2.976742e-01,  5.543390e-01, -7.772377e-01, -2.599706e-01,  5.550295e-01, -8.032603e-01},
  {-2.333522e-01,  5.477173e-01, -8.034629e-01, -2.385377e-01,  5.536057e-01, -8.108578e-01},
  {-3.423087e-01,  5.159051e-01, -7.852814e-01, -2.635376e-01,  5.384976e-01, -8.132882e-01},
  { 5.080442e-01,  4.313032e-01,  7.455660e-01,  5.071940e-01,  4.481691e-01,  7.501833e-01},
  { 1.603424e-01,  5.521300e-01,  8.181949e-01,  1.570790e-01,  5.602032e-01,  8.260568e-01},
  { 1.846339e-01,  5.664921e-01,  8.031171e-01,  1.822245e-01,  5.723305e-01,  8.124679e-01},
  { 3.755521e-02,  6.252633e-01,  7.795098e-01,  4.384758e-02,  6.243128e-01,  7.932094e-01},
  { 1.687579e-01,  6.124294e-01,  7.723023e-01,  1.692511e-01,  6.117110e-01,  7.861527e-01},
  { 7.804645e-01,  4.616713e-01,  4.215861e-01,  7.902276e-01,  4.660501e-01,  4.233438e-01},
  { 2.837227e-01,  5.736380e-01,  7.684015e-01,  2.864732e-01,  5.847858e-01,  7.725495e-01},
  { 1.314861e-01,  6.479773e-01,  7.502245e-01,  1.311150e-01,  6.549189e-01,  7.581308e-01},
  {-6.960574e-02,  6.068071e-01,  7.917956e-01,  1.682909e-02,  6.668886e-01,  7.588457e-01},
  {-4.019511e-02,  6.667352e-01,  7.442100e-01, -4.300456e-02,  6.712777e-01,  7.539272e-01},
  {-1.377550e-01,  7.095073e-01,  6.911027e-01, -1.425120e-01,  7.123558e-01,  7.022164e-01},
  { 2.325280e-01,  6.414216e-01,  7.311013e-01,  2.298992e-01,  6.534758e-01,  7.355199e-01},
  {-2.082305e-01,  7.389553e-01,  6.407692e-01, -2.048587e-01,  7.501466e-01,  6.451208e-01},
  {-4.106287e-01,  8.219823e-01,  3.946254e-01, -4.237942e-01,  8.333370e-01,  3.831630e-01},
  {-4.275465e-01,  8.359150e-01,  3.441659e-01, -4.236125e-01,  8.473387e-01,  3.513345e-01},
  { 8.347811e-01,  5.260645e-01,  1.624708e-01,  8.382266e-01,  5.426067e-01,  1.543992e-01},
  {-3.618943e-01,  8.355351e-01,  4.134170e-01, -3.684633e-01,  8.419945e-01,  4.196987e-01},
  {-4.475250e-01,  8.420914e-01,  3.010040e-01, -4.456735e-01,  8.577458e-01,  2.941318e-01},
  { 7.747712e-01,  6.318913e-01,  2.104901e-02,  7.815962e-01,  6.399543e-01,  2.124679e-02},
  {-4.269347e-01,  9.004624e-01,  8.303159e-02, -4.287656e-01,  9.098867e-01,  9.557147e-02},
  {-4.294071e-01,  8.931927e-01,  1.334781e-01, -4.379199e-01,  9.013984e-01,  1.287426e-01},
  {-2.690797e-01,  9.460644e-01, -1.804392e-01, -2.760743e-01,  9.558787e-01, -1.759281e-01},
  {-1.869185e-01,  9.743516e-01, -1.253018e-01, -2.000733e-01,  9.825425e-01, -1.243144e-01},
  {-1.967035e-01,  9.765238e-01, -8.780029e-02, -1.993102e-01,  9.860579e-01, -9.401228e-02},
  {-1.757580e-01,  9.835334e-01, -4.208589e-02, -1.645169e-01,  9.961056e-01, -3.976736e-02},
  { 6.390942e-01,  7.568399e-01, -1.369379e-01,  5.985858e-01,  8.035694e-01, -1.298309e-01},
  {-1.584543e-01,  9.725917e-01, -1.701691e-01, -1.721255e-01,  9.810877e-01, -1.694504e-01},
  {-1.177144e-01,  9.920200e-01, -4.516119e-02, -1.221065e-01,  1.001513e+00, -5.419430e-02},
  {-1.068796e-01,  9.892375e-01, -9.993000e-02, -1.091605e-01,  9.984059e-01, -1.102027e-01},
  { 1.360668e-01,  9.650201e-01, -2.241026e-01,  1.312627e-01,  9.744937e-01, -2.324035e-01},
  { 3.332740e-01,  9.098325e-01, -2.472514e-01,  3.444270e-01,  9.160596e-01, -2.511710e-01},
  {-9.627957e-02,  9.838685e-01, -1.507746e-01, -9.944279e-02,  9.942371e-01, -1.499296e-01},
  {-8.263711e-02,  9.697197e-01, -2.298146e-01, -8.235778e-02,  9.792332e-01, -2.349361e-01},
  { 5.701338e-02,  9.617029e-01, -2.680991e-01,  5.630169e-02,  9.773210e-01, -2.501031e-01},
  {-3.358697e-01,  5.477659e-01, -7.662533e-01, -2.608945e-01,  5.479634e-01, -8.082272e-01},
  { 1.521837e-01,  5.544646e-01,  8.181742e-01,  1.504489e-01,  5.604640e-01,  8.271133e-01},
  { 1.622955e-01,  5.754988e-01,  8.015368e-01,  1.504430e-01,  5.605963e-01,  8.270248e-01},
  { 3.730103e-01,  5.028473e-01,  7.797486e-01,  3.926552e-01,  5.073910e-01,  7.818084e-01},
  { 7.537044e-01,  4.468031e-01,  4.819717e-01,  7.610269e-01,  4.474467e-01,  4.914376e-01},
  { 1.627288e-01,  5.890101e-01,  7.915722e-01,  1.609138e-01,  5.994587e-01,  7.972628e-01},
  { 7.879074e-02,  5.719822e-01,  8.164731e-01,  7.326514e-02,  5.838315e-01,  8.213667e-01},
  { 7.059658e-02,  6.039128e-01,  7.939177e-01,  6.624968e-02,  6.142645e-01,  7.994752e-01},
  { 8.087032e-02,  6.456285e-01,  7.593576e-01,  8.338556e-02,  6.459118e-01,  7.724740e-01},
  { 5.984311e-02,  6.845421e-01,  7.265128e-01,  4.915434e-02,  6.671178e-01,  7.572376e-01},
  {-1.076916e-01,  6.422439e-01,  7.588974e-01,  1.184740e-02,  6.766347e-01,  7.515267e-01},
  {-5.710768e-02,  6.731313e-01,  7.373146e-01,  6.804256e-03,  6.804549e-01,  7.468636e-01},
  {-1.741179e-01,  7.192821e-01,  6.725445e-01, -1.768561e-01,  7.352131e-01,  6.701133e-01},
  { 7.962002e-01,  5.363979e-01,  2.798974e-01,  8.110536e-01,  5.249106e-01,  2.958795e-01},
  { 8.260797e-01,  5.305447e-01,  1.900385e-01,  8.333089e-01,  5.325189e-01,  2.071338e-01},
  {-3.889988e-01,  8.675759e-01,  3.098258e-01, -3.977456e-01,  8.696931e-01,  3.260360e-01},
  {-2.569090e-01,  8.138298e-01,  5.212281e-01, -2.584557e-01,  8.188856e-01,  5.324426e-01},
  {-4.162476e-01,  8.614476e-01,  2.909395e-01, -4.223847e-01,  8.665537e-01,  3.025597e-01},
  {-3.135854e-01,  8.317516e-01,  4.580977e-01, -3.141151e-01,  8.395321e-01,  4.662459e-01},
  {-4.110918e-01,  9.115669e-01, -7.016861e-03, -4.092922e-01,  9.237229e-01, -9.198550e-03},
  {-3.888649e-01,  8.857026e-01,  2.536038e-01, -3.958845e-01,  8.961678e-01,  2.470352e-01},
  {-4.088419e-01,  8.868223e-01,  2.153935e-01, -4.050675e-01,  8.981399e-01,  2.239032e-01},
  { 6.955060e-01,  6.644700e-01, -2.734061e-01,  7.085717e-01,  6.666285e-01, -2.727964e-01},
  { 6.788433e-01,  6.899105e-01, -2.513868e-01,  6.918483e-01,  6.928972e-01, -2.492485e-01},
  {-2.187659e-01,  9.603281e-01, -1.729491e-01, -2.199314e-01,  9.730482e-01, -1.602503e-01},
  {-1.305542e-01,  9.620977e-01, -2.394234e-01, -1.368771e-01,  9.710794e-01, -2.431955e-01},
  { 9.493025e-02,  9.719187e-01, -2.153192e-01,  9.947010e-02,  9.816157e-01, -2.177498e-01},
  { 1.857577e-01,  9.506142e-01, -2.486500e-01,  1.948293e-01,  9.599885e-01, -2.476765e-01},
  { 7.507952e-02,  9.710779e-01, -2.266513e-01,  7.038138e-02,  9.816215e-01, -2.287878e-01},
  {-1.100135e-01,  9.755704e-01, -1.901562e-01, -1.007617e-01,  9.879104e-01, -1.864272e-01},
  { 6.385609e-01,  4.238829e-01,  6.423109e-01,  6.465368e-01,  4.222909e-01,  6.515668e-01},
  { 4.763287e-01,  4.663126e-01,  7.454284e-01,  4.896576e-01,  4.645174e-01,  7.518878e-01},
  { 5.875877e-01,  4.498081e-01,  6.726168e-01,  5.830930e-01,  4.527154e-01,  6.898761e-01},
  { 6.977023e-01,  4.470400e-01,  5.597916e-01,  7.106947e-01,  4.449556e-01,  5.637445e-01},
  { 5.475029e-01,  4.615896e-01,  6.979796e-01,  5.515965e-01,  4.670646e-01,  7.060236e-01},
  { 7.234704e-01,  4.503163e-01,  5.232645e-01,  7.294898e-01,  4.590963e-01,  5.272154e-01},
  { 1.405052e-01,  6.194490e-01,  7.723609e-01,  1.043155e-01,  6.255532e-01,  7.865576e-01},
  { 3.376577e-01,  5.507814e-01,  7.633001e-01,  3.334242e-01,  5.484982e-01,  7.802899e-01},
  { 7.839220e-01,  4.927666e-01,  3.776867e-01,  7.916079e-01,  5.025716e-01,  3.763799e-01},
  { 1.002460e-01,  6.792159e-01,  7.270602e-01,  1.107459e-01,  6.809517e-01,  7.381818e-01},
  { 1.446698e-01,  6.818864e-01,  7.170088e-01,  1.445570e-01,  6.815968e-01,  7.328861e-01},
  { 8.012711e-01,  5.400402e-01,  2.575289e-01,  8.173770e-01,  5.340347e-01,  2.599727e-01},
  {-2.274812e-01,  8.019735e-01,  5.523504e-01, -2.282231e-01,  8.091447e-01,  5.604174e-01},
  { 8.034276e-01,  5.782418e-01,  1.419178e-01,  8.161024e-01,  5.798743e-01,  1.364098e-01},
  {-2.980403e-01,  8.293749e-01,  4.725561e-01, -2.922600e-01,  8.382210e-01,  4.825325e-01},
  { 7.986319e-01,  5.943784e-01,  9.434672e-02,  8.041438e-01,  6.040022e-01,  9.705289e-02},
  {-3.622366e-01,  8.904933e-01,  2.753295e-01, -3.604037e-01,  9.017915e-01,  2.788360e-01},
  {-3.917050e-01,  9.122462e-01,  1.198920e-01, -4.003079e-01,  9.196306e-01,  1.220709e-01},
  {-3.860811e-01,  9.072363e-01,  1.669244e-01, -3.911954e-01,  9.145674e-01,  1.772033e-01},
  { 6.533415e-01,  7.560718e-01, -3.873351e-02,  6.607003e-01,  7.631109e-01, -4.496576e-02},
  {-2.766287e-01,  9.507540e-01, -1.397974e-01, -2.734835e-01,  9.624310e-01, -1.407310e-01},
  {-2.256831e-01,  9.736889e-01, -3.157594e-02, -2.349463e-01,  9.822035e-01, -3.080410e-02},
  {-2.333100e-01,  9.703642e-01, -6.292747e-02, -2.269575e-01,  9.823641e-01, -6.575213e-02},
  {-2.410339e-01,  9.639586e-01, -1.126347e-01, -2.399225e-01,  9.732079e-01, -1.271845e-01},
  { 7.593191e-01,  6.306342e-01, -1.604211e-01,  5.989920e-01,  8.056063e-01, -1.144192e-01},
  { 7.263988e-01,  6.835102e-01,  7.182373e-02,  5.986866e-01,  8.078250e-01, -1.091636e-01},
  {-1.640365e-01,  9.652117e-01, -2.036131e-01, -1.569829e-01,  9.761302e-01, -2.083271e-01},
  { 5.170544e-01,  8.402402e-01, -1.632520e-01,  5.224414e-01,  8.489111e-01, -1.651935e-01},
  { 3.335587e-01,  9.111763e-01, -2.418601e-01,  3.541981e-01,  9.187397e-01, -2.316511e-01},
  { 3.915987e-01,  8.955409e-01, -2.113219e-01,  3.969073e-01,  9.032353e-01, -2.179757e-01},
  {-5.550714e-02,  9.806339e-01, -1.878193e-01, -5.905862e-02,  9.910178e-01, -1.878073e-01},
  {-2.462891e-02,  9.795504e-01, -1.996854e-01, -6.155487e-03,  9.882863e-01, -2.100691e-01},
  { 6.707473e-01,  4.210472e-01,  6.105877e-01,  6.734166e-01,  4.355461e-01,  6.145641e-01},
  { 4.429300e-01,  4.858743e-01,  7.534847e-01,  4.341870e-01,  4.988354e-01,  7.638851e-01},
  { 1.426797e-01,  5.906069e-01,  7.942455e-01,  1.283260e-01,  5.858643e-01,  8.131216e-01},
  { 7.398037e-01,  4.930965e-01,  4.577624e-01,  7.444571e-01,  4.986469e-01,  4.669225e-01},
  { 2.818268e-01,  6.379709e-01,  7.166357e-01,  2.833878e-01,  6.467850e-01,  7.226586e-01},
  {-2.621011e-02,  7.080876e-01,  7.056381e-01, -2.434291e-02,  7.046744e-01,  7.236792e-01},
  {-1.229067e-01,  7.394471e-01,  6.619003e-01, -1.416635e-01,  7.494435e-01,  6.626726e-01},
  {-1.895818e-01,  7.714377e-01,  6.074064e-01, -1.961918e-01,  7.770029e-01,  6.153404e-01},
  {-2.148593e-01,  7.845077e-01,  5.817071e-01, -1.960807e-01,  7.969937e-01,  5.892557e-01},
  {-3.776911e-01,  8.552454e-01,  3.548306e-01, -3.800217e-01,  8.672705e-01,  3.525516e-01},
  {-3.488618e-01,  8.650900e-01,  3.604370e-01, -3.508130e-01,  8.754835e-01,  3.623905e-01},
  {-3.176834e-01,  8.589323e-01,  4.016374e-01, -3.248851e-01,  8.687826e-01,  4.006678e-01},
  {-3.428519e-01,  8.878547e-01,  3.068658e-01, -3.491775e-01,  8.982347e-01,  3.035092e-01},
  { 7.750029e-01,  6.289079e-01,  6.201090e-02,  7.800760e-01,  6.393661e-01,  5.981340e-02},
  {-3.607584e-01,  9.325170e-01, -1.629140e-02, -3.732402e-01,  9.385558e-01, -2.596119e-02},
  {-3.859552e-01,  9.218791e-01,  3.431543e-02, -3.962398e-01,  9.286790e-01,  3.765827e-02},
  {-3.538394e-01,  9.118615e-01,  2.081013e-01, -3.648779e-01,  9.204077e-01,  2.014506e-01},
  {-2.066404e-01,  9.784156e-01, -1.673083e-03, -2.137530e-01,  9.875053e-01,  3.933442e-03},
  { 1.449083e-03,  9.931668e-01, -1.166942e-01, -6.420173e-02,  1.004032e+00, -9.312575e-02},
  { 1.624167e-01,  9.665909e-01, -1.982999e-01,  1.627779e-01,  9.762723e-01, -2.031628e-01},
  { 2.824927e-01,  9.278755e-01, -2.434027e-01,  2.823347e-01,  9.411266e-01, -2.354762e-01},
  { 2.434282e-01,  9.424508e-01, -2.291923e-01,  2.469800e-01,  9.503953e-01, -2.379714e-01},
  { 2.386958e-02,  9.753816e-01, -2.192282e-01,  2.911229e-02,  9.872520e-01, -2.129865e-01},
  { 4.421350e-01,  8.778930e-01, -1.839030e-01,  4.491808e-01,  8.845885e-01, -1.913714e-01},
  { 5.103090e-01,  4.822721e-01,  7.120382e-01,  5.202335e-01,  4.868865e-01,  7.163629e-01},
  { 7.114170e-01,  4.894939e-01,  5.042634e-01,  7.248546e-01,  4.920287e-01,  5.033636e-01},
  {-7.604237e-02,  7.109535e-01,  6.991156e-01, -7.032660e-02,  7.241638e-01,  7.010782e-01},
  { 1.857597e-01,  6.919346e-01,  6.976531e-01,  1.948708e-01,  7.020510e-01,  7.012812e-01},
  { 8.003048e-01,  5.599392e-01,  2.144302e-01,  8.080186e-01,  5.680352e-01,  2.128999e-01},
  {-2.372769e-01,  8.448381e-01,  4.795293e-01, -2.437809e-01,  8.460623e-01,  4.955989e-01},
  {-3.019312e-01,  8.455666e-01,  4.402892e-01, -2.834440e-01,  8.602949e-01,  4.476837e-01},
  {-3.094370e-01,  8.843780e-01,  3.494630e-01, -3.199351e-01,  8.910258e-01,  3.529633e-01},
  { 7.423944e-01,  6.698977e-01, -9.358826e-03,  7.611200e-01,  6.635072e-01,  3.660705e-02},
  {-3.245596e-01,  9.445239e-01, -5.035642e-02, -3.321661e-01,  9.539352e-01, -5.432788e-02},
  {-3.034152e-01,  9.487453e-01, -8.844061e-02, -2.986468e-01,  9.605079e-01, -9.542475e-02},
  {-2.879598e-01,  9.548835e-01, -7.264075e-02, -2.840923e-01,  9.670953e-01, -6.992611e-02},
  {-2.845775e-01,  9.581522e-01, -3.098402e-02, -2.816593e-01,  9.693750e-01, -4.302664e-02},
  {-2.639854e-01,  9.644671e-01, -1.072084e-02, -2.726967e-01,  9.727710e-01, -1.498587e-02},
  {-2.381696e-01,  9.711710e-01,  1.010420e-02, -2.316664e-01,  9.832190e-01,  2.198475e-02},
  {-8.285861e-02,  9.955907e-01, -4.397227e-02, -7.657633e-02,  1.006391e+00, -4.678992e-02},
  {-1.481052e-01,  9.889461e-01, -7.111829e-03, -1.508687e-01,  9.990615e-01, -6.011392e-03},
  { 5.732288e-01,  8.176828e-01,  5.294942e-02,  5.765694e-01,  8.227050e-01, -1.077431e-01},
  { 1.067455e-01,  9.786958e-01, -1.753854e-01,  1.021136e-01,  9.890922e-01, -1.792982e-01},
  { 5.478284e-02,  9.815760e-01, -1.830503e-01,  4.804151e-02,  9.929992e-01, -1.803390e-01},
  {-4.989443e-02,  9.887030e-01, -1.413399e-01, -4.891160e-02,  1.000918e+00, -1.290221e-01},
  { 4.793401e-01,  8.602608e-01, -1.737368e-01,  4.785227e-01,  8.726851e-01, -1.741271e-01},
  { 5.970309e-01,  4.742182e-01,  6.470480e-01,  6.034317e-01,  4.791395e-01,  6.535856e-01},
  { 7.505239e-01,  5.177341e-01,  4.106888e-01,  7.528325e-01,  5.250447e-01,  4.224377e-01},
  { 3.243942e-01,  5.970942e-01,  7.336532e-01,  3.271503e-01,  6.075588e-01,  7.380516e-01},
  { 1.248011e-01,  7.084695e-01,  6.946191e-01,  1.092912e-01,  7.084032e-01,  7.121046e-01},
  { 7.084822e-02,  6.921564e-01,  7.182617e-01,  7.515743e-02,  7.044523e-01,  7.203959e-01},
  { 7.703101e-01,  5.395600e-01,  3.398491e-01,  7.731497e-01,  5.474893e-01,  3.512525e-01},
  { 2.288963e-01,  6.900027e-01,  6.866606e-01,  2.247952e-01,  7.032303e-01,  6.910519e-01},
  {-1.399645e-01,  7.638745e-01,  6.300045e-01, -1.375441e-01,  7.809313e-01,  6.261768e-01},
  { 7.833363e-01,  5.697110e-01,  2.486235e-01,  7.910863e-01,  5.771659e-01,  2.488898e-01},
  { 7.961280e-01,  5.803937e-01,  1.712406e-01,  8.043545e-01,  5.871090e-01,  1.708848e-01},
  {-1.785343e-01,  8.201977e-01,  5.435084e-01, -1.900512e-01,  8.286723e-01,  5.459415e-01},
  { 7.723684e-01,  6.258678e-01,  1.083351e-01,  7.838752e-01,  6.291522e-01,  1.029187e-01},
  {-2.527715e-01,  8.586329e-01,  4.459330e-01, -2.629040e-01,  8.667293e-01,  4.478066e-01},
  {-3.606961e-01,  9.296706e-01,  7.490562e-02, -3.670351e-01,  9.391049e-01,  6.508941e-02},
  {-3.327534e-01,  9.097717e-01,  2.481747e-01, -3.352639e-01,  9.230341e-01,  2.376449e-01},
  {-3.126678e-01,  9.496151e-01, -2.168003e-02, -3.088761e-01,  9.618265e-01, -1.887364e-02},
  { 4.692351e-02,  9.894214e-01, -1.372718e-01,  5.174277e-02,  9.991539e-01, -1.410390e-01},
  { 5.336302e-01,  8.354710e-01, -1.312510e-01,  5.345920e-01,  8.466662e-01, -1.350999e-01},
  { 3.080915e-01,  9.251670e-01, -2.216883e-01,  3.151177e-01,  9.364725e-01, -2.111910e-01},
  { 9.339761e-03,  9.861544e-01, -1.655664e-01,  3.335000e-03,  9.969876e-01, -1.639560e-01},
  { 4.008435e-01,  8.953955e-01, -1.938848e-01,  4.043756e-01,  9.060835e-01, -1.907246e-01},
  { 6.346605e-01,  4.665619e-01,  6.160568e-01,  6.365427e-01,  4.650492e-01,  6.319981e-01},
  { 5.691098e-01,  4.970760e-01,  6.550035e-01,  5.751430e-01,  5.106980e-01,  6.551921e-01},
  { 4.081236e-01,  5.397912e-01,  7.362477e-01,  4.082674e-01,  5.444080e-01,  7.468690e-01},
  { 5.349926e-01,  5.124809e-01,  6.716742e-01,  5.430722e-01,  5.206872e-01,  6.749229e-01},
  { 3.786450e-01,  5.727249e-01,  7.270586e-01,  3.794073e-01,  5.747377e-01,  7.393256e-01},
  { 2.642124e-02,  7.041823e-01,  7.095274e-01,  1.881509e-02,  7.162944e-01,  7.123479e-01},
  { 1.540470e-01,  7.191517e-01,  6.775621e-01,  1.653551e-01,  7.202774e-01,  6.890078e-01},
  { 1.826111e-01,  7.241554e-01,  6.650204e-01,  1.815382e-01,  7.199391e-01,  6.852779e-01},
  { 2.776829e-01,  6.834161e-01,  6.751553e-01,  2.698615e-01,  6.929168e-01,  6.840441e-01},
  { 7.640649e-01,  5.737246e-01,  2.950341e-01,  7.683444e-01,  5.863927e-01,  2.944047e-01},
  {-2.075175e-01,  8.342426e-01,  5.108578e-01, -2.030385e-01,  8.465982e-01,  5.127537e-01},
  {-3.415550e-01,  9.302291e-01,  1.342160e-01, -3.480730e-01,  9.386073e-01,  1.368600e-01},
  {-3.314027e-01,  9.289323e-01,  1.650968e-01, -3.387027e-01,  9.344063e-01,  1.817543e-01},
  {-2.553905e-01,  9.660687e-01,  3.855925e-02, -2.549838e-01,  9.770267e-01,  3.568729e-02},
  {-1.982876e-01,  9.786324e-01,  5.441185e-02, -2.103453e-01,  9.871948e-01,  4.553759e-02},
  { 6.636290e-02,  9.904892e-01, -1.205278e-01, -4.104418e-02,  1.008085e+00, -5.435963e-02},
  {-1.686393e-01,  9.852577e-01,  2.878025e-02, -1.629800e-01,  9.967852e-01,  2.702553e-02},
  { 2.337249e-02,  9.928843e-01, -1.167666e-01,  2.047276e-02,  1.003325e+00, -1.174643e-01},
  { 5.469168e-01,  8.298626e-01, -1.104997e-01,  5.536274e-01,  8.385013e-01, -1.062851e-01},
  {-1.910921e-02,  9.888658e-01, -1.475777e-01, -2.618350e-02,  9.994892e-01, -1.456438e-01},
  { 4.684448e-01,  5.173460e-01,  7.161792e-01,  4.745121e-01,  5.195713e-01,  7.250935e-01},
  { 5.009242e-01,  5.337365e-01,  6.813225e-01,  5.056399e-01,  5.247099e-01,  6.999179e-01},
  { 6.748965e-01,  4.857550e-01,  5.554789e-01,  6.795648e-01,  4.922668e-01,  5.628013e-01},
  { 6.998649e-01,  5.098970e-01,  5.001941e-01,  6.999694e-01,  5.187168e-01,  5.117196e-01},
  { 3.575776e-01,  6.274718e-01,  6.916773e-01,  3.575769e-01,  6.333581e-01,  7.013361e-01},
  { 7.139748e-01,  5.355384e-01,  4.510418e-01,  7.288435e-01,  5.463385e-01,  4.372454e-01},
  { 1.062757e-01,  7.185731e-01,  6.872832e-01,  9.552953e-02,  7.263965e-01,  6.957693e-01},
  { 1.101092e-02,  7.337115e-01,  6.793719e-01,  4.644733e-03,  7.404625e-01,  6.874337e-01},
  {-3.417333e-02,  7.523776e-01,  6.578452e-01, -2.633294e-02,  7.656528e-01,  6.587515e-01},
  {-3.470381e-02,  7.458187e-01,  6.652444e-01, -5.922056e-02,  7.480174e-01,  6.766338e-01},
  { 7.747180e-01,  5.936510e-01,  2.176939e-01,  7.880902e-01,  5.953784e-01,  2.128916e-01},
  { 7.546280e-01,  6.014432e-01,  2.623025e-01,  7.600690e-01,  6.104829e-01,  2.654991e-01},
  {-1.480591e-01,  8.024361e-01,  5.780787e-01, -1.426704e-01,  8.161561e-01,  5.782770e-01},
  {-1.118973e-01,  7.971486e-01,  5.933238e-01, -1.143612e-01,  8.009772e-01,  6.051672e-01},
  {-8.950809e-02,  7.637144e-01,  6.393188e-01, -8.385749e-02,  7.724046e-01,  6.459330e-01},
  { 7.719353e-01,  6.203473e-01,  1.388707e-01,  7.784615e-01,  6.286836e-01,  1.401412e-01},
  {-2.714274e-01,  8.795099e-01,  3.908830e-01, -2.647948e-01,  8.897812e-01,  3.988012e-01},
  { 7.223275e-01,  6.914207e-01,  1.343922e-02,  7.249901e-01,  7.025844e-01,  4.061552e-02},
  {-3.060620e-01,  9.324147e-01,  1.921692e-01, -3.167464e-01,  9.397057e-01,  1.936354e-01},
  {-2.994922e-01,  9.260736e-01,  2.295474e-01, -3.028176e-01,  9.358960e-01,  2.308025e-01},
  { 6.404095e-01,  7.679730e-01, -9.650739e-03,  6.461374e-01,  7.765280e-01, -1.988892e-02},
  { 6.205191e-02,  9.950809e-01, -7.722449e-02, -2.780714e-02,  1.009408e+00, -3.460702e-02},
  {-3.190817e-03,  9.955677e-01, -9.399351e-02,  8.559144e-04,  1.005967e+00, -9.437550e-02},
  { 5.778925e-01,  8.126200e-01, -7.542394e-02,  5.790755e-01,  8.241721e-01, -7.934978e-02},
  { 1.596451e-01,  9.775070e-01, -1.378166e-01,  1.660759e-01,  9.851622e-01, -1.508430e-01},
  { 2.185010e-01,  9.573845e-01, -1.888710e-01,  2.267053e-01,  9.665852e-01, -1.879281e-01},
  { 3.875654e-01,  8.751673e-01, -2.896126e-01,  4.099475e-01,  9.080966e-01, -1.678880e-01},
  { 5.922340e-01,  5.176986e-01,  6.174520e-01,  5.945225e-01,  5.193121e-01,  6.306639e-01},
  { 4.460281e-01,  5.588120e-01,  6.991338e-01,  4.571142e-01,  5.619523e-01,  7.043671e-01},
  { 6.906877e-01,  5.440273e-01,  4.764294e-01,  6.977257e-01,  5.476210e-01,  4.839129e-01},
  { 7.231035e-01,  5.557742e-01,  4.101663e-01,  7.285093e-01,  5.643784e-01,  4.142870e-01},
  { 5.573383e-02,  7.343834e-01,  6.764427e-01,  6.679921e-02,  7.400452e-01,  6.846483e-01},
  { 3.219687e-01,  6.630509e-01,  6.757957e-01,  3.276755e-01,  6.746159e-01,  6.770511e-01},
  { 3.210696e-01,  6.870543e-01,  6.518210e-01,  3.103280e-01,  6.925414e-01,  6.670525e-01},
  { 7.325369e-01,  5.838935e-01,  3.499400e-01,  7.435420e-01,  5.880135e-01,  3.507291e-01},
  { 7.816163e-03,  7.665755e-01,  6.421067e-01,  7.347062e-03,  7.771584e-01,  6.471508e-01},
  { 7.537090e-01,  6.128274e-01,  2.374140e-01,  7.509277e-01,  6.249885e-01,  2.576452e-01},
  {-2.022990e-01,  8.615000e-01,  4.657177e-01, -2.065745e-01,  8.718413e-01,  4.670007e-01},
  {-2.250397e-01,  8.798444e-01,  4.186062e-01, -2.423437e-01,  8.901578e-01,  4.120174e-01},
  {-2.952321e-01,  9.092419e-01,  2.934572e-01, -2.995048e-01,  9.151437e-01,  3.060693e-01},
  { 7.404301e-01,  6.670597e-01,  8.243032e-02,  7.531675e-01,  6.681142e-01,  8.512993e-02},
  {-3.166369e-01,  9.484038e-01,  1.646981e-02, -3.265982e-01,  9.554328e-01,  3.676679e-02},
  {-3.194232e-01,  9.406490e-01,  1.146665e-01, -3.210565e-01,  9.529138e-01,  9.873267e-02},
  {-2.401411e-01,  9.667085e-01,  8.835730e-02, -2.447355e-01,  9.764931e-01,  8.624098e-02},
  { 9.149953e-03,  9.980378e-01, -6.194204e-02,  2.055789e-02,  1.008376e+00, -6.027384e-02},
  { 1.278188e-02,  9.991245e-01, -3.983378e-02,  1.336161e-02,  1.009413e+00, -4.222086e-02},
  { 6.057234e-01,  7.945164e-01, -4.292816e-02,  6.157132e-01,  8.001761e-01, -3.873256e-02},
  {-7.683858e-02,  9.970310e-01,  4.988973e-03, -7.128832e-02,  1.007853e+00, -5.147548e-03},
  {-2.040668e-01,  9.747071e-01,  9.111911e-02, -1.931065e-01,  9.868808e-01,  9.822839e-02},
  { 9.902032e-02,  9.870545e-01, -1.261676e-01,  9.639923e-02,  9.977788e-01, -1.265819e-01},
  { 2.704084e-01,  9.544796e-01, -1.258887e-01,  2.799725e-01,  9.548485e-01, -1.753875e-01},
  { 7.223552e-02,  8.048751e-01, -5.890314e-01,  3.882492e-01,  9.192133e-01, -1.658681e-01},
  { 4.305972e-01,  8.930934e-01, -1.302697e-01,  4.403347e-01,  8.988277e-01, -1.381928e-01},
  { 5.474713e-01,  5.495636e-01,  6.310744e-01,  5.569531e-01,  5.483618e-01,  6.402977e-01},
  { 4.127560e-01,  5.974184e-01,  6.875491e-01,  4.213234e-01,  6.032628e-01,  6.929638e-01},
  { 1.109387e-01,  7.566255e-01,  6.443683e-01,  8.370733e-02,  7.686114e-01,  6.504633e-01},
  { 6.968940e-01,  5.919325e-01,  4.049130e-01,  7.096776e-01,  5.862102e-01,  4.166505e-01},
  { 1.346563e-01,  7.422621e-01,  6.564410e-01,  1.433322e-01,  7.527820e-01,  6.585203e-01},
  { 1.980820e-01,  7.715236e-01,  6.045781e-01, -5.594508e-02,  7.829591e-01,  6.361730e-01},
  {-3.246829e-02,  8.341919e-01,  5.505176e-01, -8.357213e-02,  7.973961e-01,  6.148543e-01},
  {-1.601263e-01,  8.462026e-01,  5.082330e-01, -1.588642e-01,  8.542363e-01,  5.156674e-01},
  {-3.032199e-01,  9.509462e-01,  6.131098e-02, -2.987483e-01,  9.630993e-01,  6.371630e-02},
  { 6.402855e-02,  9.953062e-01, -7.256649e-02,  7.057026e-02,  1.005088e+00, -7.547003e-02},
  {-1.073130e-01,  9.939865e-01,  2.179120e-02, -1.100472e-01,  1.003877e+00,  3.155737e-02},
  { 5.633420e-01,  8.243019e-01, -5.632184e-02,  5.783779e-01,  8.264387e-01, -5.798586e-02},
  { 3.220009e-01,  9.242105e-01, -2.053055e-01,  3.357930e-01,  9.391585e-01, -1.615740e-01},
  { 2.792885e-01,  9.598763e-01, -2.521097e-02,  3.160348e-01,  9.449899e-01, -1.673255e-01},
  { 4.797755e-01,  8.676857e-01, -1.301426e-01,  4.855677e-01,  8.781222e-01, -1.183598e-01},
  { 6.572566e-02,  9.328530e-01, -3.542107e-01,  3.821433e-01,  9.216300e-01, -1.595215e-01},
  { 6.401024e-01,  4.993756e-01,  5.838603e-01,  6.490474e-01,  5.007310e-01,  5.906655e-01},
  { 6.696025e-01,  5.304356e-01,  5.198755e-01,  6.770452e-01,  5.354324e-01,  5.251693e-01},
  { 1.859948e-01,  7.401914e-01,  6.461599e-01,  1.846304e-01,  7.541477e-01,  6.465660e-01},
  { 5.121409e-02,  7.727827e-01,  6.326010e-01,  5.589216e-02,  7.848292e-01,  6.338706e-01},
  { 3.018499e-01,  7.069199e-01,  6.396490e-01,  2.956159e-01,  7.183733e-01,  6.460861e-01},
  { 2.430152e-01,  7.242043e-01,  6.453462e-01,  2.592813e-01,  7.313186e-01,  6.471646e-01},
  {-8.544791e-02,  8.297383e-01,  5.515733e-01, -8.833254e-02,  8.345369e-01,  5.626870e-01},
  { 1.810928e-01,  8.247409e-01,  5.357312e-01, -5.779246e-02,  7.896610e-01,  6.276675e-01},
  { 2.711393e-01,  8.496066e-01,  4.523849e-01, -5.782977e-02,  7.875582e-01,  6.318753e-01},
  {-1.223382e-01,  8.309655e-01,  5.427060e-01, -1.162367e-01,  8.466366e-01,  5.390421e-01},
  { 5.855867e-02,  8.943408e-01,  4.435373e-01, -6.738119e-02,  7.912316e-01,  6.247263e-01},
  { 7.270702e-01,  6.427230e-01,  2.414048e-01,  7.321382e-01,  6.531766e-01,  2.450831e-01},
  { 7.557716e-01,  6.315893e-01,  1.729281e-01,  7.671907e-01,  6.335884e-01,  1.756953e-01},
  { 7.330725e-01,  6.500665e-01,  2.000458e-01,  7.306360e-01,  6.645156e-01,  2.132469e-01},
  {-2.648163e-01,  9.038969e-01,  3.359208e-01, -2.655641e-01,  9.148176e-01,  3.368298e-01},
  { 6.879086e-01,  7.257723e-01, -6.020392e-03,  6.870683e-01,  7.400334e-01,  3.424134e-02},
  {-2.761923e-01,  9.573111e-01,  8.528297e-02, -2.807878e-01,  9.666948e-01,  8.677826e-02},
  {-2.798133e-01,  9.507711e-01,  1.331870e-01, -2.763728e-01,  9.625227e-01,  1.343091e-01},
  { 6.530889e-01,  7.564399e-01,  3.568687e-02,  6.586441e-01,  7.657490e-01,  2.648031e-02},
  {-2.812274e-01,  9.458448e-01,  1.621379e-01, -2.593676e-01,  9.600540e-01,  1.785939e-01},
  { 4.498174e-02,  9.988012e-01, -1.930934e-02,  5.465551e-02,  1.008485e+00, -2.912215e-02},
  {-2.275677e-01,  9.646215e-01,  1.331099e-01, -2.304787e-01,  9.746722e-01,  1.332866e-01},
  {-4.389239e-02,  9.990353e-01,  1.350445e-03, -4.466259e-02,  1.009395e+00,  1.709740e-03},
  {-1.348953e-01,  9.886387e-01,  6.630745e-02, -1.281735e-01,  1.000652e+00,  5.604650e-02},
  { 2.870721e-01,  9.405332e-01, -1.816233e-01,  3.659374e-01,  9.312403e-01, -1.405834e-01},
  { 1.500389e-01,  9.595273e-01, -2.383187e-01,  2.460375e-01,  9.685843e-01, -1.489649e-01},
  { 5.160138e-01,  5.622337e-01,  6.462376e-01,  5.173419e-01,  5.726058e-01,  6.521948e-01},
  { 4.840319e-01,  5.649408e-01,  6.682476e-01,  4.943108e-01,  5.801478e-01,  6.632972e-01},
  { 6.558287e-01,  5.677098e-01,  4.975885e-01,  6.688063e-01,  5.702659e-01,  4.983735e-01},
  { 3.722634e-01,  6.654341e-01,  6.470066e-01,  3.878290e-01,  6.706825e-01,  6.485760e-01},
  { 6.727533e-01,  5.871053e-01,  4.502337e-01,  6.691630e-01,  5.983712e-01,  4.637396e-01},
  { 7.158466e-01,  6.306725e-01,  2.996929e-01,  7.246671e-01,  6.341051e-01,  3.060258e-01},
  {-1.459862e-01,  8.720541e-01,  4.671293e-01, -1.546746e-01,  8.751545e-01,  4.806779e-01},
  {-2.705506e-01,  9.243463e-01,  2.690471e-01, -2.713050e-01,  9.364747e-01,  2.651019e-01},
  { 6.959815e-01,  7.127377e-01,  8.726167e-02,  7.010826e-01,  7.206966e-01,  9.982187e-02},
  {-2.219250e-01,  9.303766e-01,  2.918021e-01, -2.232848e-01,  9.408410e-01,  2.929727e-01},
  { 6.245382e-01,  7.804656e-01,  2.873255e-02,  6.375576e-01,  7.832377e-01,  3.072109e-02},
  {-1.581596e-01,  9.831640e-01,  9.151033e-02, -1.657246e-01,  9.927484e-01,  8.865188e-02},
  { 1.867352e-01,  9.780463e-01, -9.249606e-02,  1.814103e-01,  9.893230e-01, -9.596863e-02},
  { 1.639797e-01,  9.826680e-01, -8.645400e-02,  1.661998e-01,  9.930439e-01, -8.438508e-02},
  { 1.226894e-01,  9.884791e-01, -8.863602e-02,  1.164588e-01,  9.996639e-01, -8.937567e-02},
  { 1.860751e-01,  9.770289e-01, -1.038772e-01,  2.126299e-01,  9.809496e-01, -1.157862e-01},
  { 5.202988e-01,  8.502722e-01, -7.953820e-02,  5.051826e-01,  8.711398e-01, -8.239947e-02},
  { 1.495001e-01,  9.828426e-01, -1.080286e-01,  2.198708e-01,  9.799939e-01, -1.209243e-01},
  { 3.139558e-01,  9.401390e-01, -1.325537e-01,  3.161291e-01,  9.493616e-01, -1.402024e-01},
  { 6.145499e-01,  5.754564e-01,  5.396094e-01,  6.239918e-01,  5.731053e-01,  5.505132e-01},
  { 5.783367e-01,  5.714576e-01,  5.822052e-01,  5.782922e-01,  5.851449e-01,  5.865691e-01},
  { 4.157204e-01,  6.406897e-01,  6.455177e-01,  4.261084e-01,  6.422236e-01,  6.533436e-01},
  { 1.094340e-01,  6.880104e-01,  7.174022e-01,  1.481967e-01,  7.818089e-01,  6.226451e-01},
  { 1.112503e-01,  6.154597e-01,  7.802773e-01,  1.960686e-01,  7.667626e-01,  6.280980e-01},
  { 6.951584e-01,  6.253772e-01,  3.544828e-01,  7.109475e-01,  6.267347e-01,  3.502005e-01},
  { 1.872109e-01,  7.025099e-01,  6.866090e-01,  2.264567e-01,  7.557067e-01,  6.312688e-01},
  {-5.597804e-02,  8.325114e-01,  5.511727e-01, -5.254315e-02,  8.386216e-01,  5.610926e-01},
  {-1.757374e-01,  8.862095e-01,  4.286598e-01, -1.738793e-01,  8.952709e-01,  4.348869e-01},
  {-2.247847e-01,  9.074015e-01,  3.550977e-01, -2.311556e-01,  9.150801e-01,  3.606462e-01},
  { 7.167953e-01,  6.784584e-01,  1.609305e-01,  7.260776e-01,  6.857006e-01,  1.533320e-01},
  {-2.437031e-01,  9.388156e-01,  2.433807e-01, -2.529525e-01,  9.460585e-01,  2.487149e-01},
  { 6.636283e-01,  7.420295e-01,  9.481321e-02,  6.654957e-01,  7.543822e-01,  9.437948e-02},
  {-1.788167e-01,  9.301257e-01,  3.207660e-01, -1.781757e-01,  9.422907e-01,  3.181407e-01},
  {-2.555381e-01,  9.451347e-01,  2.035208e-01, -2.506543e-01,  9.584816e-01,  1.983851e-01},
  { 1.331462e-02,  9.999110e-01,  9.106565e-04,  1.418154e-02,  1.010276e+00,  4.271374e-03},
  { 1.130974e-01,  9.927503e-01, -4.069125e-02,  1.177955e-01,  1.002532e+00, -4.396274e-02},
  {-1.493343e-01,  9.783372e-01,  1.433724e-01, -1.520186e-01,  9.879686e-01,  1.472465e-01},
  { 5.519618e-01,  8.335596e-01, -2.272841e-02,  5.530233e-01,  8.450906e-01, -2.951529e-02},
  { 3.134603e-01,  9.495929e-01, -3.998714e-03,  2.486723e-01,  9.703520e-01, -1.321349e-01},
  { 3.967442e-01,  9.110192e-01, -1.124188e-01,  3.897626e-01,  9.251626e-01, -1.141997e-01},
  { 4.901326e-01,  6.027909e-01,  6.296134e-01,  5.036903e-01,  6.039665e-01,  6.343492e-01},
  { 6.108158e-01,  5.313832e-01,  5.869719e-01,  6.154861e-01,  5.444314e-01,  5.879209e-01},
  { 5.240210e-01,  5.938334e-01,  6.105438e-01,  5.344963e-01,  5.968130e-01,  6.156352e-01},
  { 4.568779e-01,  6.003897e-01,  6.563497e-01,  4.566890e-01,  6.047855e-01,  6.682419e-01},
  { 6.428776e-01,  5.381717e-01,  5.450500e-01,  6.453162e-01,  5.519699e-01,  5.475186e-01},
  { 5.518246e-01,  5.930906e-01,  5.862876e-01,  5.601095e-01,  5.945578e-01,  5.946912e-01},
  { 6.239513e-01,  5.959169e-01,  5.055372e-01,  6.410351e-01,  5.984477e-01,  5.018121e-01},
  { 3.784525e-01,  6.852273e-01,  6.222839e-01,  3.807806e-01,  6.939317e-01,  6.279667e-01},
  { 6.054229e-02,  8.071846e-01,  5.871862e-01,  5.498800e-02,  8.057950e-01,  6.070781e-01},
  { 2.789390e-01,  7.410214e-01,  6.108030e-01,  2.897912e-01,  7.417606e-01,  6.218428e-01},
  {-2.512263e-02,  8.017328e-01,  5.971545e-01, -3.617102e-02,  8.223788e-01,  5.876498e-01},
  { 6.987718e-01,  6.710045e-01,  2.479336e-01,  7.074068e-01,  6.764295e-01,  2.508038e-01},
  {-1.099714e-01,  8.655045e-01,  4.886801e-01, -1.117138e-01,  8.676360e-01,  5.055680e-01},
  { 6.922884e-01,  6.946785e-01,  1.953417e-01,  6.932886e-01,  7.060803e-01,  2.041710e-01},
  { 7.381939e-01,  6.627421e-01,  1.258680e-01,  7.359021e-01,  6.806763e-01,  1.265415e-01},
  {-1.802205e-01,  9.082853e-01,  3.775425e-01, -1.823420e-01,  9.160048e-01,  3.854318e-01},
  { 7.049820e-01,  7.003264e-01,  1.119965e-01,  7.072994e-01,  7.103002e-01,  1.268294e-01},
  { 6.811759e-01,  7.175640e-01,  1.452626e-01,  6.911391e-01,  7.230287e-01,  1.429709e-01},
  {-1.915106e-01,  9.457315e-01,  2.625182e-01, -1.862175e-01,  9.588212e-01,  2.585668e-01},
  {-2.088654e-01,  9.528232e-01,  2.202343e-01, -2.136763e-01,  9.623451e-01,  2.215983e-01},
  {-1.109169e-01,  9.721341e-01,  2.065256e-01, -1.284242e-01,  9.784807e-01,  2.166935e-01},
  {-2.174264e-01,  9.603231e-01,  1.746576e-01, -2.221750e-01,  9.696009e-01,  1.771553e-01},
  { 6.541249e-02,  9.977561e-01,  1.427991e-02,  6.143415e-02,  1.008492e+00,  6.902703e-03},
  {-1.274247e-01,  9.772478e-01,  1.695571e-01, -1.290887e-01,  9.876283e-01,  1.697050e-01},
  {-1.818589e-01,  9.732586e-01,  1.403392e-01, -1.769372e-01,  9.846146e-01,  1.417753e-01},
  { 5.916353e-01,  8.062029e-01,  2.103056e-03,  5.880820e-01,  8.216059e-01,  2.757159e-03},
  { 1.416005e-01,  9.880313e-01, -6.118310e-02,  1.347035e-01,  1.000156e+00, -4.920973e-02},
  { 6.375431e-01,  6.013162e-01,  4.816198e-01,  6.441251e-01,  6.128018e-01,  4.800605e-01},
  { 9.365690e-02,  7.946011e-01,  5.998646e-01,  9.493671e-02,  8.054090e-01,  6.026418e-01},
  { 6.596249e-01,  6.275445e-01,  4.136216e-01,  6.634427e-01,  6.410726e-01,  4.120095e-01},
  { 3.349776e-01,  7.251456e-01,  6.016260e-01,  3.356241e-01,  7.310116e-01,  6.114371e-01},
  { 6.777696e-01,  6.329628e-01,  3.741477e-01,  6.822971e-01,  6.423782e-01,  3.777614e-01},
  {-2.496870e-02,  8.453963e-01,  5.335557e-01, -2.760963e-02,  8.533152e-01,  5.403365e-01},
  {-1.088536e-01,  9.599063e-01,  2.583233e-01, -1.181499e-01,  9.693505e-01,  2.593712e-01},
  { 1.020560e-01,  9.947522e-01, -7.252237e-03,  1.080649e-01,  1.004551e+00, -8.841452e-03},
  {-9.845772e-04,  9.990011e-01,  4.467158e-02, -2.241896e-03,  1.009646e+00,  3.855890e-02},
  { 2.013194e-01,  9.784427e-01, -4.604747e-02,  1.981442e-01,  9.894913e-01, -5.025549e-02},
  {-3.081889e-02,  9.980514e-01,  5.425386e-02, -3.074596e-02,  1.008737e+00,  4.879083e-02},
  {-6.453144e-02,  9.960858e-01,  6.040562e-02, -6.235407e-02,  1.005776e+00,  7.350337e-02},
  { 5.109416e-01,  8.590024e-01, -3.245990e-02,  5.182702e-01,  8.667435e-01, -3.217827e-02},
  { 4.319378e-01,  8.999334e-01,  5.957885e-02,  4.590599e-01,  8.989761e-01, -6.525517e-02},
  { 5.251149e-01,  8.460497e-01, -9.194680e-02,  3.704264e-01,  9.358460e-01, -8.864962e-02},
  { 4.447021e-01,  6.428918e-01,  6.236426e-01,  4.545192e-01,  6.479787e-01,  6.280238e-01},
  { 1.402226e-01,  8.077543e-01,  5.725998e-01,  1.298457e-01,  8.079750e-01,  5.926136e-01},
  { 6.095882e-01,  6.266359e-01,  4.855200e-01,  6.268358e-01,  6.284533e-01,  4.835265e-01},
  { 4.815249e-02,  8.200423e-01,  5.702737e-01,  4.187364e-02,  8.263089e-01,  5.799426e-01},
  { 1.042405e-02,  8.386719e-01,  5.445371e-01,  2.286194e-02,  8.485372e-01,  5.480285e-01},
  { 6.725879e-01,  6.941305e-01,  2.565315e-01,  6.861976e-01,  6.968602e-01,  2.571654e-01},
  { 6.612234e-01,  7.291108e-01,  1.765815e-01,  6.714370e-01,  7.341866e-01,  1.761434e-01},
  {-8.383280e-02,  9.471776e-01,  3.095589e-01, -7.926740e-02,  9.588180e-01,  3.086396e-01},
  { 6.279742e-01,  7.733523e-01,  8.703321e-02,  6.350018e-01,  7.805585e-01,  9.157200e-02},
  { 5.920590e-01,  8.037857e-01,  5.826491e-02,  5.994160e-01,  8.120072e-01,  4.721088e-02},
  {-1.737409e-01,  9.660165e-01,  1.913793e-01, -1.848038e-01,  9.735403e-01,  1.973303e-01},
  { 3.340641e-02,  9.980280e-01,  5.314271e-02,  4.358519e-02,  1.008557e+00,  4.231939e-02},
  { 2.377535e-01,  9.689409e-01, -6.802091e-02,  2.490044e-01,  9.770390e-01, -6.536145e-02},
  {-1.061974e-01,  9.868445e-01,  1.219020e-01, -1.058536e-01,  9.974322e-01,  1.216467e-01},
  { 3.508631e-01,  8.943365e-01,  2.775920e-01,  4.525667e-01,  9.010237e-01, -6.498364e-02},
  {-8.478639e-02,  9.916492e-01,  9.717540e-02, -9.162415e-02,  1.000402e+00,  1.080556e-01},
  { 4.088019e-01,  9.096127e-01,  7.406597e-02,  4.381083e-01,  9.080430e-01, -6.634700e-02},
  { 2.868555e-01,  9.522899e-01, -1.042014e-01,  2.961664e-01,  9.613798e-01, -9.442200e-02},
  { 1.819741e-01,  7.966474e-01,  5.764012e-01,  1.720908e-01,  8.048943e-01,  5.860078e-01},
  { 3.885812e-01,  7.140040e-01,  5.824114e-01,  3.895831e-01,  7.193641e-01,  5.929739e-01},
  { 6.304849e-01,  6.422010e-01,  4.359664e-01,  6.244375e-01,  6.571292e-01,  4.462517e-01},
  { 6.361311e-01,  6.701792e-01,  3.823571e-01,  6.550439e-01,  6.650444e-01,  3.866728e-01},
  { 6.706908e-01,  6.665956e-01,  3.253064e-01,  6.746319e-01,  6.722166e-01,  3.374605e-01},
  { 6.641125e-01,  6.876338e-01,  2.934526e-01,  6.745024e-01,  6.945205e-01,  2.890869e-01},
  { 6.589186e-01,  7.177291e-01,  2.251474e-01,  6.752920e-01,  7.178414e-01,  2.226398e-01},
  {-1.324955e-01,  9.301428e-01,  3.424607e-01, -1.298600e-01,  9.440103e-01,  3.359368e-01},
  {-1.459959e-01,  9.459125e-01,  2.897152e-01, -1.367324e-01,  9.538950e-01,  3.037454e-01},
  {-1.605123e-01,  9.567218e-01,  2.427327e-01, -1.621897e-01,  9.657993e-01,  2.485932e-01},
  {-8.025284e-02,  9.845799e-01,  1.554411e-01, -8.281443e-02,  9.947651e-01,  1.563928e-01},
  { 3.044071e-01,  9.508443e-01, -5.684685e-02,  3.087655e-01,  9.590027e-01, -7.654450e-02},
  { 4.012520e-01,  9.147921e-01, -4.639250e-02,  3.955206e-01,  9.273543e-01, -6.678124e-02},
  { 4.770268e-01,  6.380626e-01,  6.044185e-01,  4.780285e-01,  6.468631e-01,  6.115026e-01},
  { 4.248172e-01,  6.877454e-01,  5.886736e-01,  4.243353e-01,  6.995986e-01,  5.927728e-01},
  { 3.760993e-01,  7.334355e-01,  5.662347e-01,  3.773726e-01,  7.420861e-01,  5.725175e-01},
  { 9.855469e-02,  8.309743e-01,  5.475115e-01,  1.085703e-01,  8.453078e-01,  5.427171e-01},
  { 6.448231e-02,  8.429070e-01,  5.341815e-01,  5.651809e-02,  8.549051e-01,  5.355527e-01},
  { 5.537833e-01,  5.314741e-01,  6.409832e-01,  6.218331e-01,  6.760842e-01,  4.208509e-01},
  { 2.983441e-01,  7.615449e-01,  5.753607e-01,  3.025039e-01,  7.667967e-01,  5.842870e-01},
  { 6.446740e-01,  6.748070e-01,  3.592088e-01,  6.588075e-01,  6.818143e-01,  3.492631e-01},
  {-5.662962e-02,  8.611003e-01,  5.052717e-01, -6.185870e-02,  8.745102e-01,  5.022726e-01},
  {-1.327189e-01,  9.013242e-01,  4.123110e-01, -1.346991e-01,  9.155112e-01,  4.056687e-01},
  {-3.423583e-02,  9.529747e-01,  3.011098e-01, -4.313469e-02,  9.624521e-01,  3.044659e-01},
  { 6.399979e-01,  7.548357e-01,  1.436168e-01,  6.417942e-01,  7.681654e-01,  1.375000e-01},
  {-5.659871e-02,  9.632990e-01,  2.623959e-01, -5.417860e-02,  9.747057e-01,  2.605530e-01},
  {-6.431643e-02,  9.722201e-01,  2.250587e-01, -6.422027e-02,  9.821642e-01,  2.282618e-01},
  { 5.483338e-01,  8.352868e-01,  4.032492e-02,  5.534333e-01,  8.443543e-01,  4.076058e-02},
  { 1.555882e-01,  9.878217e-01,  8.050018e-04,  1.470783e-01,  9.995466e-01,  1.239310e-02},
  { 5.217948e-01,  8.529079e-01,  1.667904e-02,  5.296155e-01,  8.602242e-01,  2.013599e-02},
  { 4.968033e-01,  8.678157e-01,  9.081857e-03,  5.056393e-01,  8.747368e-01, -6.931341e-03},
  { 4.345125e-01,  9.005635e-01, -1.357098e-02,  4.709516e-01,  8.936105e-01, -2.341145e-02},
  { 7.164748e-01,  6.954336e-01, -5.510104e-02,  3.713648e-01,  9.388980e-01, -6.173221e-02},
  { 3.137044e-01,  9.473191e-01, -6.462191e-02,  3.385188e-01,  9.502098e-01, -5.820631e-02},
  { 5.184826e-01,  6.321162e-01,  5.758516e-01,  5.193057e-01,  6.379912e-01,  5.866583e-01},
  { 2.553874e-01,  7.796923e-01,  5.717142e-01,  2.475547e-01,  7.900253e-01,  5.791831e-01},
  { 4.691514e-01,  4.776078e-01,  7.428242e-01,  6.171394e-01,  6.812317e-01,  4.215013e-01},
  { 5.297734e-01,  6.146165e-01,  5.844541e-01,  6.107207e-01,  6.856902e-01,  4.215817e-01},
  { 4.046039e-03,  8.617989e-01,  5.072340e-01,  4.099098e-03,  8.716518e-01,  5.109596e-01},
  {-5.080460e-02,  9.345810e-01,  3.521041e-01, -3.685018e-02,  9.452379e-01,  3.550227e-01},
  { 5.918344e-01,  7.993717e-01,  1.036187e-01,  6.052573e-01,  8.005540e-01,  1.168799e-01},
  { 9.904848e-02,  9.939927e-01,  4.656117e-02,  1.041669e-01,  1.003880e+00,  4.745320e-02},
  { 7.129777e-02,  9.953685e-01,  6.448390e-02,  7.704744e-02,  1.005020e+00,  6.982851e-02},
  { 2.224161e-01,  9.748561e-01, -1.366173e-02,  2.287701e-01,  9.839418e-01, -2.007075e-02},
  { 4.762970e-01,  6.646568e-01,  5.756497e-01,  4.794482e-01,  6.657802e-01,  5.896989e-01},
  { 5.729560e-01,  6.271148e-01,  5.276822e-01,  5.714356e-01,  6.372932e-01,  5.368416e-01},
  { 4.496088e-01,  7.005715e-01,  5.541223e-01,  4.503500e-01,  7.049876e-01,  5.666181e-01},
  { 2.145820e-01,  8.095426e-01,  5.464388e-01,  2.133827e-01,  8.123152e-01,  5.616829e-01},
  { 1.366374e-01,  8.401458e-01,  5.248668e-01,  1.340146e-01,  8.564393e-01,  5.190638e-01},
  { 3.395323e-01,  7.587727e-01,  5.558612e-01,  3.347742e-01,  7.735035e-01,  5.572219e-01},
  { 5.844693e-01,  7.039779e-01,  4.034982e-01,  6.020439e-01,  7.020046e-01,  4.069577e-01},
  { 1.459493e-01,  8.598335e-01,  4.892701e-01,  1.535256e-01,  8.659647e-01,  4.974042e-01},
  { 9.904002e-02,  8.616909e-01,  4.976744e-01,  9.729216e-02,  8.720714e-01,  5.008998e-01},
  { 1.769342e-01,  8.784119e-01,  4.439446e-01,  1.799977e-01,  8.832284e-01,  4.589273e-01},
  { 6.401413e-01,  7.175279e-01,  2.745411e-01,  6.480277e-01,  7.219517e-01,  2.823633e-01},
  {-6.778930e-02,  8.820542e-01,  4.662456e-01, -7.151217e-02,  8.925790e-01,  4.680398e-01},
  {-1.157166e-02,  9.371716e-01,  3.486767e-01, -1.729170e-02,  9.432783e-01,  3.616647e-01},
  {-9.982575e-02,  8.975542e-01,  4.294546e-01, -9.746433e-02,  9.095509e-01,  4.290573e-01},
  {-9.729484e-02,  9.239981e-01,  3.698125e-01, -1.009592e-01,  9.320074e-01,  3.768848e-01},
  { 6.037173e-01,  7.835113e-01,  1.470900e-01,  6.223453e-01,  7.821792e-01,  1.475337e-01},
  { 1.347746e-01,  9.896252e-01,  4.977651e-02,  1.214513e-01,  1.001542e+00,  5.515314e-02},
  { 3.374614e-02,  9.924992e-01,  1.175019e-01,  4.078917e-02,  1.003096e+00,  1.140654e-01},
  {-4.618433e-02,  9.791320e-01,  1.979077e-01, -4.677441e-02,  9.914287e-01,  1.890936e-01},
  {-5.569590e-02,  9.852200e-01,  1.619860e-01, -5.336559e-02,  9.969964e-01,  1.550010e-01},
  {-2.682393e-02,  9.938513e-01,  1.074250e-01, -1.974588e-02,  1.003316e+00,  1.176560e-01},
  { 5.734728e-01,  6.561033e-01,  4.905685e-01,  5.774546e-01,  6.635600e-01,  4.971067e-01},
  { 1.566060e-01,  8.187301e-01,  5.524091e-01,  1.804153e-01,  8.265883e-01,  5.523384e-01},
  {-1.797106e-01, -8.181599e-01, -5.461855e-01,  1.824579e-01,  8.260328e-01,  5.524986e-01},
  { 6.368054e-01,  2.912749e-01, -7.138892e-01,  1.807610e-01,  8.262553e-01,  5.527236e-01},
  { 5.811282e-01,  6.821299e-01,  4.438341e-01,  5.832258e-01,  6.966839e-01,  4.428279e-01},
  { 3.875514e-01,  7.476953e-01,  5.392177e-01,  3.852593e-01,  7.574539e-01,  5.465504e-01},
  { 4.984368e-01,  6.772591e-01,  5.411846e-01,  5.821246e-01,  7.047106e-01,  4.305756e-01},
  { 1.279953e-01,  8.756577e-01,  4.656617e-01,  1.297041e-01,  8.803629e-01,  4.785538e-01},
  { 5.836905e-01,  7.143037e-01,  3.861034e-01,  5.985800e-01,  7.148697e-01,  3.892880e-01},
  { 2.255256e-01,  8.582612e-01,  4.610054e-01,  2.201657e-01,  8.641829e-01,  4.749654e-01},
  { 6.302589e-01,  7.035645e-01,  3.282845e-01,  6.246060e-01,  7.197875e-01,  3.356428e-01},
  { 1.615482e-01,  8.919356e-01,  4.223187e-01,  1.712572e-01,  8.971881e-01,  4.319736e-01},
  { 3.404059e-02,  9.125640e-01,  4.075145e-01,  1.628544e-02,  9.338655e-01,  3.853632e-01},
  { 2.170577e-01,  8.955376e-01,  3.884563e-01,  2.193980e-01,  9.003505e-01,  4.026306e-01},
  { 2.878658e-02,  9.389479e-01,  3.428530e-01,  2.092310e-02,  9.435329e-01,  3.608086e-01},
  { 6.240531e-01,  7.477182e-01,  2.268813e-01,  6.325120e-01,  7.515878e-01,  2.364907e-01},
  { 6.314738e-01,  7.511132e-01,  1.925349e-01,  6.288587e-01,  7.663900e-01,  1.951074e-01},
  {-2.137432e-03,  9.519594e-01,  3.062169e-01, -4.576205e-03,  9.642320e-01,  3.018451e-01},
  { 5.715913e-01,  8.102663e-01,  1.294297e-01,  5.716226e-01,  8.225951e-01,  1.321692e-01},
  { 5.168196e-01,  8.545655e-01,  5.114014e-02,  5.306128e-01,  8.567851e-01,  7.247689e-02},
  { 4.923560e-01,  8.697739e-01,  3.284684e-02,  5.022028e-01,  8.760040e-01,  3.595375e-02},
  { 4.486803e-01,  8.936923e-01, -2.772974e-05,  4.454649e-01,  9.068853e-01,  1.709316e-03},
  { 2.761049e-01,  9.607121e-01, -2.825629e-02,  2.781165e-01,  9.711472e-01, -2.012985e-02},
  { 4.942268e-01,  6.976655e-01,  5.186547e-01,  4.829695e-01,  6.990281e-01,  5.467902e-01},
  { 1.613334e-01,  8.082914e-01,  5.662478e-01,  1.813547e-01,  8.259884e-01,  5.529279e-01},
  { 1.746492e-01,  8.307246e-01,  5.285777e-01,  1.809779e-01,  8.332750e-01,  5.420107e-01},
  { 3.090180e-01,  7.853386e-01,  5.364243e-01,  3.267440e-01,  7.895211e-01,  5.392332e-01},
  {-1.525798e-02,  8.839284e-01,  4.673733e-01,  9.332891e-04,  8.910775e-01,  4.762914e-01},
  { 6.046863e-02,  8.760286e-01,  4.784532e-01,  4.817674e-02,  8.868244e-01,  4.823949e-01},
  {-1.301912e-02,  8.907331e-01,  4.543403e-01, -3.000599e-02,  9.046087e-01,  4.490614e-01},
  { 1.777080e-01,  9.068113e-01,  3.822475e-01,  1.754783e-01,  9.122545e-01,  3.973362e-01},
  { 6.087934e-01,  7.523859e-01,  2.515672e-01,  6.213210e-01,  7.582129e-01,  2.448607e-01},
  {-7.571379e-02,  9.112908e-01,  4.047425e-01, -7.984769e-02,  9.227058e-01,  4.038703e-01},
  { 2.414354e-01,  9.080120e-01,  3.423787e-01,  2.297869e-01,  9.198543e-01,  3.492051e-01},
  { 6.003537e-01,  7.774693e-01,  1.873951e-01,  6.079749e-01,  7.848912e-01,  1.876058e-01},
  { 5.588957e-01,  8.160337e-01,  1.473928e-01,  5.637534e-01,  8.241265e-01,  1.545354e-01},
  { 5.470712e-01,  8.314092e-01,  9.732373e-02,  5.406329e-01,  8.479930e-01,  9.750576e-02},
  { 8.473033e-02,  9.954712e-01,  4.310138e-02,  8.560634e-02,  1.001261e+00,  1.050024e-01},
  { 2.009779e-01,  9.791347e-01,  3.004933e-02,  2.092529e-01,  9.878587e-01,  3.504672e-02},
  { 6.960514e-01,  5.681937e-01,  4.389399e-01,  5.340127e-01,  6.792631e-01,  5.237482e-01},
  { 4.342489e-01,  7.793875e-01,  4.516447e-01,  5.327646e-01,  6.815277e-01,  5.237193e-01},
  { 4.289742e-01,  7.001176e-01,  5.708035e-01,  5.313354e-01,  6.793531e-01,  5.263478e-01},
  { 4.591211e-01,  7.797356e-01,  4.256997e-01,  5.325387e-01,  6.819857e-01,  5.217069e-01},
  { 5.325972e-01,  6.813794e-01,  5.020580e-01,  5.355162e-01,  6.943114e-01,  5.026617e-01},
  { 4.294854e-01,  7.278801e-01,  5.345398e-01,  4.442307e-01,  7.374839e-01,  5.288250e-01},
  { 5.190496e-01,  7.248582e-01,  4.529548e-01,  5.257775e-01,  7.260563e-01,  4.667656e-01},
  { 2.195353e-01,  8.298554e-01,  5.129758e-01,  2.228064e-01,  8.363742e-01,  5.212600e-01},
  { 4.653721e-01,  6.952819e-01,  5.477335e-01,  5.624748e-01,  7.262645e-01,  4.229376e-01},
  { 5.941240e-01,  7.250916e-01,  3.482226e-01,  5.958967e-01,  7.396936e-01,  3.444457e-01},
  { 6.126935e-01,  7.329163e-01,  2.957033e-01,  6.191424e-01,  7.406814e-01,  2.982226e-01},
  { 2.669458e-01,  8.696653e-01,  4.152375e-01,  2.662837e-01,  8.773448e-01,  4.245435e-01},
  {-6.214969e-03,  9.094911e-01,  4.156769e-01, -2.200765e-02,  9.189272e-01,  4.222341e-01},
  { 2.506258e-01,  8.998551e-01,  3.569979e-01,  2.580883e-01,  9.048966e-01,  3.680093e-01},
  {-2.544395e-03,  9.680082e-01,  2.509056e-01,  5.433707e-03,  9.777148e-01,  2.547931e-01},
  {-8.633595e-04,  9.738793e-01,  2.270646e-01, -1.677903e-03,  9.851002e-01,  2.246113e-01},
  { 1.080712e-01,  9.941407e-01, -2.202601e-03,  1.335643e-01,  9.969267e-01,  9.594981e-02},
  { 1.139469e-02,  9.872238e-01,  1.589317e-01,  3.665262e-03,  9.982908e-01,  1.558133e-01},
  { 4.301369e-01,  9.026065e-01, -1.684259e-02,  3.710927e-01,  9.397724e-01, -3.786214e-04},
  { 4.081794e-01,  6.794040e-01,  6.097538e-01,  5.571714e-01,  7.295956e-01,  4.220565e-01},
  { 2.572678e-01,  8.402811e-01,  4.772222e-01,  2.587298e-01,  8.462541e-01,  4.876374e-01},
  { 1.256541e-01,  7.776231e-01,  6.160465e-01,  4.367539e-02,  9.031245e-01,  4.509248e-01},
  { 7.187300e-02,  8.374045e-01,  5.418376e-01,  3.349226e-02,  9.041563e-01,  4.522568e-01},
  { 5.081398e-02,  9.239577e-01,  3.791045e-01,  5.800169e-02,  9.369128e-01,  3.737720e-01},
  { 5.732763e-01,  7.796493e-01,  2.519948e-01,  5.731579e-01,  7.948505e-01,  2.461415e-01},
  { 5.848615e-01,  7.817540e-01,  2.163280e-01,  5.884073e-01,  7.920776e-01,  2.174240e-01},
  { 5.607428e-01,  8.096131e-01,  1.734769e-01,  5.634617e-01,  8.201033e-01,  1.755695e-01},
  { 1.330724e-02,  9.808336e-01,  1.943919e-01,  1.590389e-02,  9.900283e-01,  2.011634e-01},
  { 7.373904e-02,  9.861369e-01,  1.486496e-01,  7.167470e-02,  9.976649e-01,  1.428445e-01},
  { 1.284107e-01,  9.917210e-01,  3.946272e-04,  1.599527e-01,  9.936916e-01,  8.871797e-02},
  { 1.961343e-01,  9.776119e-01,  7.619872e-02,  1.887542e-01,  9.901410e-01,  6.979848e-02},
  { 4.824853e-01,  8.740875e-01,  5.638156e-02,  4.873531e-01,  8.835047e-01,  7.084823e-02},
  { 4.623978e-01,  8.862055e-01,  2.877701e-02,  4.565215e-01,  9.002599e-01,  4.475490e-02},
  { 2.666365e-01,  9.637773e-01, -6.187468e-03,  2.751582e-01,  9.717342e-01,  3.002260e-02},
  { 3.718229e-01,  9.282380e-01,  1.103988e-02,  4.219636e-01,  9.178375e-01,  2.008926e-02},
  { 4.751084e-01,  7.455506e-01,  4.673611e-01,  4.823494e-01,  7.539533e-01,  4.688002e-01},
  { 4.224758e-01,  7.606652e-01,  4.928517e-01,  4.277970e-01,  7.625852e-01,  5.062933e-01},
  { 2.674167e-01,  8.099679e-01,  5.219582e-01,  2.613932e-01,  8.273565e-01,  5.177179e-01},
  { 3.687047e-01,  7.741907e-01,  5.144761e-01,  3.786291e-01,  7.827590e-01,  5.150581e-01},
  { 3.283253e-01,  8.009464e-01,  5.006869e-01,  3.359719e-01,  8.038288e-01,  5.117227e-01},
  { 8.696640e-02,  8.872561e-01,  4.530048e-01,  8.669277e-02,  8.951516e-01,  4.605032e-01},
  { 5.859725e-01,  7.561109e-01,  2.914320e-01,  5.974223e-01,  7.594810e-01,  2.952253e-01},
  { 1.447597e-01,  9.145222e-01,  3.777483e-01,  1.411503e-01,  9.270992e-01,  3.760855e-01},
  { 2.546216e-01,  9.079986e-01,  3.327257e-01,  2.763545e-01,  9.117289e-01,  3.365375e-01},
  { 4.085252e-02,  9.547394e-01,  2.946248e-01,  4.040141e-02,  9.639303e-01,  3.001361e-01},
  { 5.492939e-01,  8.102806e-01,  2.042582e-01,  5.560566e-01,  8.171809e-01,  2.095221e-01},
  { 2.310935e-01,  9.247723e-01,  3.023109e-01,  2.315403e-01,  9.318088e-01,  3.146425e-01},
  { 2.991490e-01,  9.264153e-01,  2.286144e-01,  1.947601e-01,  9.347543e-01,  3.304250e-01},
  { 3.051586e-01,  9.358227e-01,  1.763916e-01,  1.878040e-01,  9.386612e-01,  3.269436e-01},
  { 5.206876e-01,  8.395748e-01,  1.549151e-01,  5.287228e-01,  8.469583e-01,  1.549091e-01},
  { 1.177452e-01,  9.839029e-01,  1.344292e-01,  1.149905e-01,  9.948816e-01,  1.336617e-01},
  { 2.401157e-01,  9.686443e-01,  6.381779e-02,  2.449161e-01,  9.785306e-01,  5.808587e-02},
  { 3.037113e-01,  9.526978e-01, -1.123682e-02,  3.092083e-01,  9.615819e-01,  2.513094e-02},
  { 4.693736e-01,  7.143026e-01,  5.190955e-01,  4.677850e-01,  7.378615e-01,  5.075601e-01},
  {-4.734578e-01, -7.314849e-01, -4.906805e-01,  4.658522e-01,  7.401505e-01,  5.060027e-01},
  { 4.995276e-01,  7.494978e-01,  4.344250e-01,  5.404239e-01,  7.524201e-01,  4.033455e-01},
  { 2.986600e-01,  8.456193e-01,  4.424141e-01,  3.082240e-01,  8.560166e-01,  4.394452e-01},
  { 1.108098e-01,  8.958696e-01,  4.302776e-01,  1.050614e-01,  9.061220e-01,  4.344891e-01},
  { 7.710667e-02,  8.619690e-01,  5.010628e-01,  5.880722e-02,  9.038286e-01,  4.477841e-01},
  { 7.755657e-02,  9.120341e-01,  4.027143e-01,  7.983118e-02,  9.231862e-01,  4.027776e-01},
  { 1.137451e-01,  9.138322e-01,  3.898368e-01,  1.115689e-01,  9.218981e-01,  3.981612e-01},
  { 1.555282e-01,  9.339459e-01,  3.218013e-01,  1.667300e-01,  9.421704e-01,  3.246438e-01},
  { 6.600865e-02,  9.651130e-01,  2.533764e-01,  7.578411e-02,  9.727059e-01,  2.626334e-01},
  { 2.849824e-01,  9.487190e-01,  1.368108e-01,  1.817187e-01,  9.409154e-01,  3.202095e-01},
  { 4.548605e-01,  7.616808e-01,  4.614587e-01,  4.734931e-01,  7.417881e-01,  4.964219e-01},
  {-4.633977e-01, -7.292102e-01, -5.035028e-01,  4.672149e-01,  7.380648e-01,  5.077895e-01},
  {-4.853187e-01, -7.185942e-01, -4.980845e-01,  4.665717e-01,  7.356977e-01,  5.118001e-01},
  {-4.918397e-01, -7.159767e-01, -4.954505e-01,  4.665893e-01,  7.379071e-01,  5.085933e-01},
  { 8.048076e-01, -1.080628e-01, -5.836156e-01,  4.651345e-01,  7.405837e-01,  5.060291e-01},
  { 4.503323e-01,  7.453945e-01,  4.915158e-01,  4.633481e-01,  7.442061e-01,  5.023399e-01},
  { 3.028292e-01,  8.226767e-01,  4.811418e-01,  3.048361e-01,  8.309418e-01,  4.873281e-01},
  { 5.481974e-01,  7.549944e-01,  3.598095e-01,  5.611712e-01,  7.676103e-01,  3.416774e-01},
  { 5.497661e-01,  7.829470e-01,  2.911208e-01,  5.566732e-01,  7.893612e-01,  2.964897e-01},
  { 3.014058e-01,  8.787954e-01,  3.699636e-01,  3.143154e-01,  8.850030e-01,  3.726322e-01},
  { 5.406079e-01,  8.068401e-01,  2.382270e-01,  5.378278e-01,  8.215521e-01,  2.394887e-01},
  { 2.962047e-01,  8.989212e-01,  3.228056e-01,  2.944070e-01,  9.095004e-01,  3.277597e-01},
  { 9.450156e-02,  9.539319e-01,  2.847516e-01,  8.837609e-02,  9.664893e-01,  2.810065e-01},
  { 5.196761e-01,  8.314507e-01,  1.965362e-01,  5.250944e-01,  8.392603e-01,  2.019921e-01},
  { 2.641236e-01,  9.232153e-01,  2.791276e-01,  2.693700e-01,  9.370004e-01,  2.652347e-01},
  { 1.221956e-01,  9.653165e-01,  2.307213e-01,  1.179615e-01,  9.754560e-01,  2.354738e-01},
  { 2.185728e-01,  9.426028e-01,  2.524399e-01,  2.223217e-01,  9.520361e-01,  2.551057e-01},
  { 4.768325e-01,  8.691118e-01,  1.314360e-01,  4.861163e-01,  8.762112e-01,  1.297222e-01},
  { 1.661018e-01,  9.776000e-01,  1.292610e-01,  1.763392e-01,  9.868987e-01,  1.257557e-01},
  { 2.879321e-01,  9.550303e-01,  7.079632e-02,  2.881736e-01,  9.658860e-01,  7.000721e-02},
  { 3.577298e-01,  9.327575e-01,  4.464189e-02,  3.533522e-01,  9.459239e-01,  3.538273e-02},
  {-6.293173e-01,  7.309643e-01, -2.639144e-01,  4.708823e-01,  7.414515e-01,  4.993990e-01},
  { 4.479104e-01,  7.412503e-01,  4.999242e-01,  4.702567e-01,  7.407431e-01,  5.010370e-01},
  {-5.656897e-01, -6.532975e-01, -5.031872e-01,  4.674290e-01,  7.368669e-01,  5.093299e-01},
  { 7.356010e-01, -1.278747e-03, -6.774138e-01,  4.679706e-01,  7.325854e-01,  5.149774e-01},
  {-4.604070e-01, -7.260317e-01, -5.107870e-01,  4.668224e-01,  7.328609e-01,  5.156271e-01},
  { 4.344948e-01,  7.641685e-01,  4.767189e-01,  4.686838e-01,  7.411247e-01,  5.019456e-01},
  { 4.321314e-01,  7.432000e-01,  5.107995e-01,  4.665614e-01,  7.366583e-01,  5.104259e-01},
  { 4.674648e-01,  7.744758e-01,  4.262205e-01,  4.819089e-01,  7.740263e-01,  4.353479e-01},
  { 3.226946e-01,  8.604357e-01,  3.943585e-01,  3.232051e-01,  8.644798e-01,  4.112082e-01},
  { 5.143105e-01,  8.120444e-01,  2.758051e-01,  5.298789e-01,  8.151921e-01,  2.752205e-01},
  { 8.151668e-02,  9.328908e-01,  3.508131e-01,  8.602096e-02,  9.462180e-01,  3.437268e-01},
  { 1.191559e-01,  9.347138e-01,  3.348312e-01,  1.251100e-01,  9.396482e-01,  3.496934e-01},
  { 7.864165e-02,  9.453571e-01,  3.164103e-01,  7.911865e-02,  9.567181e-01,  3.154457e-01},
  { 6.821489e-02,  9.818237e-01,  1.771126e-01,  8.223302e-02,  9.908903e-01,  1.795861e-01},
  { 2.405264e-01,  9.481863e-01,  2.075805e-01,  2.508542e-01,  9.548808e-01,  2.148353e-01},
  { 2.004071e-01,  9.706585e-01,  1.328868e-01,  1.946738e-01,  9.827998e-01,  1.307123e-01},
  {-4.630813e-01, -7.260634e-01, -5.083184e-01,  4.672658e-01,  7.331067e-01,  5.148755e-01},
  { 3.909500e-01,  7.925107e-01,  4.680649e-01,  3.791111e-01,  8.045076e-01,  4.795011e-01},
  { 5.097191e-01,  7.643507e-01,  3.949108e-01,  5.115829e-01,  7.773930e-01,  3.934772e-01},
  { 3.946854e-01,  8.110741e-01,  4.317200e-01,  4.152096e-01,  8.256955e-01,  4.082991e-01},
  { 3.882288e-01,  8.218439e-01,  4.169543e-01,  3.843290e-01,  8.345848e-01,  4.202845e-01},
  { 3.891745e-01,  8.353931e-01,  3.881513e-01,  4.075370e-01,  8.431191e-01,  3.821936e-01},
  { 3.553746e-01,  8.395473e-01,  4.109370e-01,  3.657171e-01,  8.487082e-01,  4.090734e-01},
  { 3.159012e-01,  9.067320e-01,  2.793629e-01,  3.093932e-01,  9.159386e-01,  2.936190e-01},
  { 4.983534e-01,  8.364232e-01,  2.281230e-01,  4.972291e-01,  8.490253e-01,  2.297861e-01},
  { 4.774884e-01,  8.581530e-01,  1.886217e-01,  4.806854e-01,  8.669197e-01,  1.956377e-01},
  { 5.519201e-02,  9.760296e-01,  2.105233e-01,  6.661802e-02,  9.869369e-01,  2.058987e-01},
  { 3.318406e-01,  9.412390e-01,  6.285676e-02,  3.322509e-01,  9.522717e-01,  6.057511e-02},
  { 4.077578e-01,  8.124099e-01,  4.168017e-01,  4.059500e-01,  8.244980e-01,  4.198660e-01},
  { 3.660449e-01,  8.493674e-01,  3.802447e-01,  3.737619e-01,  8.635478e-01,  3.680586e-01},
  { 4.194993e-01,  8.468447e-01,  3.269165e-01,  4.151035e-01,  8.608119e-01,  3.279829e-01},
  { 3.506500e-01,  8.719018e-01,  3.418066e-01,  3.538871e-01,  8.828464e-01,  3.409192e-01},
  { 4.461529e-01,  8.481152e-01,  2.857417e-01,  4.578940e-01,  8.518977e-01,  2.923778e-01},
  { 4.861888e-01,  8.310345e-01,  2.701889e-01,  4.906312e-01,  8.448798e-01,  2.575679e-01},
  { 1.827273e-01,  9.479839e-01,  2.606477e-01,  1.748683e-01,  9.592284e-01,  2.649149e-01},
  { 2.953162e-01,  9.334019e-01,  2.038363e-01,  2.976815e-01,  9.448579e-01,  1.987699e-01},
  { 1.901308e-01,  9.633566e-01,  1.891940e-01,  2.050391e-01,  9.716953e-01,  1.861349e-01},
  { 2.579480e-01,  9.600740e-01,  1.082620e-01,  2.655457e-01,  9.683490e-01,  1.125420e-01},
  { 2.263260e-01,  9.674612e-01,  1.131163e-01,  2.310923e-01,  9.759235e-01,  1.226757e-01},
  { 4.256051e-01,  8.916632e-01,  1.542630e-01,  4.197425e-01,  9.142337e-01,  9.420857e-02},
  { 4.293668e-01,  7.811462e-01,  4.532712e-01,  4.292400e-01,  7.958767e-01,  4.507917e-01},
  { 3.492019e-01,  8.196695e-01,  4.540924e-01,  3.604563e-01,  8.264613e-01,  4.559738e-01},
  { 5.075955e-01,  7.969858e-01,  3.273535e-01,  5.069032e-01,  8.032708e-01,  3.445094e-01},
  { 4.700498e-01,  8.235915e-01,  3.174119e-01,  4.725440e-01,  8.345599e-01,  3.179518e-01},
  { 1.300012e-01,  9.482532e-01,  2.896819e-01,  1.315183e-01,  9.579665e-01,  2.930535e-01},
  { 3.109949e-01,  9.192664e-01,  2.413117e-01,  3.188987e-01,  9.277578e-01,  2.417630e-01},
  { 2.841283e-01,  9.450546e-01,  1.616877e-01,  2.945979e-01,  9.514928e-01,  1.695688e-01},
  { 3.328577e-01,  9.304169e-01,  1.533951e-01,  3.315833e-01,  9.418426e-01,  1.544855e-01},
  { 3.144985e-01,  9.283372e-01,  1.981937e-01,  4.006990e-01,  9.240876e-01,  9.336467e-02},
  { 5.196206e-01,  8.348344e-01,  1.817856e-01,  4.818955e-01,  7.979141e-01,  3.898600e-01},
  { 5.521003e-01,  8.334621e-01,  2.294054e-02,  4.660183e-01,  8.074030e-01,  3.896257e-01},
  { 4.941059e-01,  8.320620e-01,  2.520561e-01,  4.595577e-01,  8.121073e-01,  3.901525e-01},
  { 3.418860e-01,  8.891409e-01,  3.042080e-01,  3.381719e-01,  8.996502e-01,  3.116878e-01},
  { 3.257076e-01,  8.644969e-01,  3.828310e-01,  3.342580e-01,  9.301769e-01,  2.095781e-01},
  { 3.730600e-01,  7.458212e-01,  5.518849e-01,  3.415876e-01,  9.291888e-01,  2.077309e-01},
  { 4.163163e-01,  8.934294e-01,  1.687146e-01,  4.350950e-01,  8.986189e-01,  1.551079e-01},
  { 4.038578e-01,  9.060026e-01,  1.267204e-01,  4.136766e-01,  9.143105e-01,  1.196327e-01},
  { 3.692067e-01,  9.231588e-01,  1.070714e-01,  3.687746e-01,  9.339526e-01,  1.123362e-01},
  { 3.401085e-01,  9.298091e-01,  1.406458e-01,  3.961087e-01,  9.245723e-01,  9.563386e-02},
  { 3.256428e-01,  9.403456e-01,  9.852339e-02,  3.276032e-01,  9.510368e-01,  9.532191e-02},
  { 4.864752e-01,  7.932947e-01,  3.660948e-01,  4.808264e-01,  8.081352e-01,  3.696007e-01},
  { 4.411072e-01,  8.636406e-01,  2.440274e-01,  4.485391e-01,  8.743867e-01,  2.348237e-01},
  { 4.035530e-01,  8.518729e-01,  3.338527e-01,  3.487964e-01,  9.257076e-01,  2.056383e-01},
  { 3.754429e-01,  9.112866e-01,  1.691137e-01,  3.663619e-01,  9.258575e-01,  1.716042e-01},
  { 3.989269e-01,  8.712822e-01,  2.858754e-01,  4.019847e-01,  8.770167e-01,  3.002176e-01},
  { 3.676167e-01,  8.910727e-01,  2.661718e-01,  3.763483e-01,  8.991012e-01,  2.661947e-01},
  { 2.427233e-01,  9.573789e-01,  1.565601e-01,  2.510636e-01,  9.665711e-01,  1.535805e-01},
  { 4.350352e-01,  8.787282e-01,  1.964206e-01,  4.293010e-01,  8.903322e-01,  2.107909e-01},
  { 3.477015e-01,  9.062059e-01,  2.406127e-01,  3.555969e-01,  9.150075e-01,  2.391499e-01},
  { 3.928917e-01,  8.922260e-01,  2.226409e-01,  3.912456e-01,  9.053835e-01,  2.192914e-01},
  { 1.874154e-02, -7.384479e-01, -6.740500e-01,  1.805916e-02, -7.495483e-01, -6.772814e-01},
  { 3.129599e-01, -9.001143e-01, -3.030682e-01,  2.714558e-01, -8.699925e-01, -4.362178e-01},
  { 3.250977e-01, -8.929994e-01, -3.112290e-01,  2.754020e-01, -8.678839e-01, -4.404353e-01},
  { 1.646128e-01, -7.469186e-01, -6.442168e-01,  1.660219e-01, -7.473165e-01, -6.594059e-01},
  { 1.939799e-01, -6.779938e-01, -7.090107e-01,  1.957114e-01, -6.856923e-01, -7.170744e-01},
  {-4.687644e-01, -8.829017e-01, -2.728309e-02, -4.839107e-01, -8.863742e-01, -3.190797e-02},
  { 1.080422e-01, -9.061739e-01,  4.088714e-01,  9.902488e-02, -9.106113e-01,  4.264223e-01},
  { 2.293184e-01, -8.722375e-01,  4.319895e-01,  2.291766e-01, -8.817701e-01,  4.368262e-01},
  {-7.154655e-01, -5.768760e-01, -3.941106e-01, -7.238900e-01, -5.807019e-01, -3.995197e-01},
  {-7.707511e-01, -6.019419e-01,  2.088265e-01, -7.806401e-01, -6.058394e-01,  2.107222e-01},
  { 1.867951e-02, -6.366296e-01,  7.709434e-01,  2.590222e-02, -6.369161e-01,  7.839150e-01},
  { 5.772520e-02, -6.101264e-01,  7.901984e-01,  5.015615e-02, -6.122893e-01,  8.021486e-01},
  {-6.010944e-02, -6.048822e-01,  7.940431e-01, -5.569004e-02, -6.263008e-01,  7.908858e-01},
  {-6.657060e-01, -3.776674e-01, -6.435860e-01, -6.709680e-01, -3.894985e-01, -6.472589e-01},
  { 6.108656e-01,  3.883127e-01, -6.899683e-01,  5.814962e-01,  4.155839e-01, -7.141667e-01},
  {-9.620736e-01,  1.667920e-01,  2.158588e-01, -9.667476e-01,  1.774730e-01,  2.339919e-01},
  {-3.915072e-01, -4.487949e-02, -9.190800e-01, -3.920494e-01, -3.778409e-02, -9.304464e-01},
  {-3.712787e-01,  1.238401e-03, -9.285206e-01, -3.762589e-01, -7.094346e-03, -9.379314e-01},
  {-7.410685e-01, -2.309385e-01,  6.304640e-01, -7.330208e-01, -2.417422e-01,  6.519884e-01},
  { 8.279219e-01,  2.565499e-01, -4.987259e-01,  8.307158e-01,  2.609190e-01, -5.125586e-01},
  { 7.767849e-01,  3.420482e-01, -5.287800e-01,  7.855062e-01,  3.494734e-01, -5.307847e-01},
  {-8.764965e-01,  6.238861e-03, -4.813679e-01, -8.853905e-01, -7.359319e-04, -4.873909e-01},
  { 2.949060e-01,  5.770956e-01, -7.615715e-01,  3.866004e-01,  6.614360e-01, -6.587288e-01},
  {-6.173578e-01,  7.723440e-01, -1.495126e-01, -6.263902e-01,  7.799172e-01, -1.422259e-01},
  {-1.438981e-01,  7.322929e-01, -6.656129e-01, -1.492652e-01,  7.479358e-01, -6.627104e-01},
  {-2.251992e-01,  7.503742e-01, -6.214691e-01, -2.277060e-01,  7.561294e-01, -6.303096e-01},
  {-1.910127e-01,  7.400569e-01, -6.448488e-01, -1.987128e-01,  7.465535e-01, -6.511860e-01},
  { 5.244128e-01,  7.465244e-01, -4.095028e-01,  5.306485e-01,  7.572863e-01, -4.072022e-01},
  { 6.757506e-01,  2.245052e-01,  7.021102e-01,  6.879228e-01,  2.247138e-01,  7.050835e-01},
  {-1.045425e-01,  5.579547e-01, -8.232602e-01, -1.047695e-01,  5.655988e-01, -8.306586e-01},
  { 1.955607e-01,  5.327373e-01,  8.233755e-01,  2.022457e-01,  5.471702e-01,  8.249687e-01},
  { 5.635465e-01,  8.252140e-01,  3.790883e-02,  5.696604e-01,  8.336738e-01,  3.686338e-02},
  { 2.132511e-01,  8.073553e-01,  5.501831e-01,  1.839037e-01,  8.245976e-01,  5.541605e-01},
  { 1.331434e-01,  9.756833e-01,  1.741123e-01,  1.369636e-01,  9.846765e-01,  1.803632e-01},
  { 2.992960e-01,  9.467115e-01,  1.189922e-01,  3.047734e-01,  9.559763e-01,  1.187566e-01},
};

static GLushort spheresurf_indices[][3] =
{
  {   2,   31,    0},
  {   2,    4,    7},
  {   2,   12,   31},
  {   4,    2,    1},
  {   0,    1,    2},
  {   0,   31,   22},
  {   5,    6,    8},
  {   8,    6,   12},
  {   9,   12,    6},
  {  12,    2,   30},
  {   4,   21,   16},
  {   3,   31,   18},
  {   3,   22,   31},
  {  23,   22,    3},
  {  15,   29,   13},
  {   8,   29,    5},
  {   5,    9,    6},
  {   5,   29,    9},
  {  12,   30,    8},
  {  16,   10,   11},
  {   2,    7,   30},
  {  11,    7,    4},
  {  19,    3,   18},
  {  24,   14,   15},
  {  24,   15,   13},
  {  25,   27,   26},
  {  28,   13,   29},
  {  66,   15,   14},
  {  29,    8,   28},
  {  30,   28,    8},
  {  10,    7,   11},
  {  30,    7,   10},
  {  19,   17,    3},
  {   3,   17,   20},
  {  21,   37,   16},
  {   3,   20,   23},
  {  23,   20,   70},
  {  23,   70,   32},
  {  32,   70,   33},
  {  24,   34,   14},
  {  30,   26,   27},
  {  29,   15,   66},
  {  26,   30,   10},
  {   9,   29,   68},
  {  12,    9,   68},
  {  17,   57,   36},
  {  31,   12,   18},
  {  20,   17,   36},
  {  58,   37,   21},
  {  44,   58,   21},
  {  32,   33,  118},
  {  35,   24,   13},
  {  13,   28,   35},
  {  30,   27,   28},
  {  55,   26,   37},
  {  37,   26,   16},
  {  19,   18,   68},
  {  17,   19,   57},
  {  19,   45,   57},
  {  21,  118,   44},
  {  21,   38,  118},
  {  59,   46,   47},
  {  41,   42,   40},
  {  41,   63,   24},
  {  42,   41,   43},
  {  41,   24,   43},
  {  14,   34,   49},
  {  50,   85,   86},
  {  25,   84,   27},
  {  27,   84,   28},
  {  65,   66,   14},
  {  53,   56,   67},
  {  56,   55,   37},
  {  58,   56,   37},
  {  46,   59,   36},
  { 117,   46,   36},
  {  44,  152,   58},
  {  20,   36,   59},
  {  38,   32,  118},
  {  33,   60,  118},
  {  42,  108,   40},
  {  42,   43,   48},
  {  24,   82,   34},
  {  34,  126,   49},
  {  43,   35,   84},
  {  43,   24,   35},
  { 110,   25,   26},
  {  49,   85,   50},
  {  35,   28,   84},
  {  50,   86,   54},
  {  52,   54,   51},
  {  53,   55,   56},
  {  14,   49,   65},
  {  29,   66,   68},
  { 117,   36,   57},
  {  56,   58,   67},
  {  12,   68,   18},
  {  68,   45,   19},
  {  90,   47,   46},
  { 138,   47,   90},
  {  60,   39,   72},
  {  47,  138,   75},
  {  75,   73,   47},
  {  42,   62,  124},
  {  63,   41,   40},
  {  40,  108,   63},
  {  48,   62,   42},
  {  63,   82,   24},
  {  82,   83,   34},
  { 126,   34,   83},
  {  48,   43,   84},
  {  26,   55, 5885},
  {  26,  162,  110},
  {  54,   64,   51},
  {  54,   86,   64},
  {  53,  112,   55},
  {  53,  114,  128},
  {  51,   64,   52},
  { 130,   50,   54},
  { 150,  130,   54},
  {  53,   67,  114},
  {  54,   52,   87},
  {  52,  148,   87},
  {  67,   58,  152},
  {  45,  168,   57},
  {  45,   88,  168},
  {  20,   59,   69},
  {  20,   71,   70},
  {  71,   20,   69},
  { 119,   69,   59},
  { 119,   59,   47},
  { 119,   47,   73},
  { 176,   72,   39},
  { 100,   75,  138},
  {  77,   74,   75},
  {  76,   77,   81},
  {  78,   79,   80},
  { 124,   62,  104},
  {  62,  109,  104},
  {  62,   48,  109},
  {  82,   63,  125},
  { 125,  161,   82},
  {  84,  110,   48},
  { 110,   84,   25},
  {  53,  111,  112},
  {  53,  128,  111},
  {  49,   50,  113},
  { 113,   65,   49},
  {  54,   87,  115},
  {  45,   68,   66},
  {  54,  115,  150},
  {  67,  152,  132},
  {  45,   66,   88},
  {  57,  168,   89},
  {  89,  136,   57},
  {  71,   69,   70},
  {  70,   69,  119},
  {  70,  119,   60},
  {  72,  118,   60},
  {  61,  121,  139},
  { 176,   39,  139},
  {  75,   74,   73},
  {  73,   74,   93},
  {  91,   93,   74},
  {  92,   93,   91},
  {  92,   91,   74},
  {  94,   93,   92},
  { 138,   95,  100},
  {  61,   97,   96},
  {  92,   74,   77},
  {  92,   77,   98},
  {  92,   98,   99},
  {  92,   99,   94},
  { 101,  100,   95},
  { 183,  102,   79},
  {  96,   97,   76},
  {  96,   76,  103},
  {  97,   98,   77},
  {  97,   77,   76},
  {  99,   98,   97},
  {  75,  100,  101},
  {  77,   75,  101},
  {  79,   78,   81},
  { 106,  107,  105},
  { 108,   42,  124},
  { 124,  105,  108},
  { 105,  106,  107},
  { 142,  109,   48},
  {  48,  110,  142},
  {  49,  126,   85},
  {  82,  181,   83},
  { 127, 5885,   55},
  {  86,  163,   64},
  {  64,  163,   52},
  { 148,   52,  163},
  {  65,  150,   66},
  { 115,   87,  164},
  { 114,   67,  132},
  { 150,  115,  133},
  {  87,  148,  131},
  {  57,  134,  117},
  { 136,   89,  116},
  {  89,  135,  116},
  { 116,  135,  136},
  {  46,  117,  172},
  {  44,  118, 5886},
  { 172,   90,   46},
  { 122,  137, 5886},
  { 122, 5886,  120},
  { 120, 5886,   72},
  { 119,   73,   93},
  { 122,  120,  123},
  {  93, 5883,   60},
  {  72,  176,  123},
  { 183,  121,   61},
  {  93,   61, 5883},
  {  94,   61,   93},
  {  61,   94,   97},
  {  99,   97,   94},
  { 177,  122,  123},
  {  79,   81,  183},
  { 183,   77,  101},
  { 183,  101,   95},
  {  81,   77,  183},
  { 141,  124,  104},
  { 159,  105,  124},
  { 105,  107,  108},
  { 160,  194,  193},
  {  63,  108,  125},
  { 143,  162,   26},
  { 127,   55,  147},
  {  55,  112,  147},
  { 202,  112,  111},
  { 128,  202,  111},
  { 163,   86,   85},
  {  50,  129,  113},
  {  65,  113,  130},
  {  65,  130,  150},
  { 113,  129,  130},
  { 129,   50,  130},
  { 150,   88,   66},
  { 131,  164,   87},
  { 168,  150,  133},
  { 168,  135,   89},
  { 117,  134,  154},
  { 117,  154,  172},
  {  44, 5886,  152},
  { 122, 5887,  137},
  {  90,  172,  173},
  { 173,  138,   90},
  { 155,  139,  121},
  { 174,  139,  155},
  {  93,   60,  119},
  { 121,  183,  155},
  { 120,   72,  123},
  { 156,   95,  138},
  { 227,  191,  140},
  { 104,  109,  141},
  { 194,  107,  105},
  { 141,  109,  196},
  { 124,  141,  159},
  { 107,  194,  160},
  { 144,  108,  107},
  { 107,  160,  144},
  { 142,  110,  162},
  { 125,  144,  161},
  {5884,  127,  233},
  { 161,  181,   82},
  { 126,  238,   85},
  { 145,  282,  146},
  { 128,  114,  204},
  { 114,  149,  204},
  { 148,  240,  131},
  { 182,  131,  240},
  { 114,  132,  149},
  { 207,  149,  132},
  { 115,  164,  208},
  { 150,  168,   88},
  { 132,  152,  151},
  { 136,  135,  168},
  { 153,  137, 5887},
  { 122,  171, 5887},
  { 246,  174,  155},
  { 139,  174,  176},
  { 183,   95,  156},
  { 178,  157,  158},
  { 192,  158,  190},
  { 227,  140,  179},
  { 105,  258,  194},
  { 105,  159,  258},
  { 196,  109,  142},
  { 160,  229,  180},
  { 144,  125,  108},
  {5884,  233,  143},
  { 143,  142,  162},
  { 145,  146,  201},
  { 147,  309,  127},
  {  83,  235,  126},
  { 238,  126,  235},
  { 202,  147,  112},
  {  83,  181,  235},
  { 149,  210,  206},
  { 164,  131,  182},
  { 115,  208,  133},
  { 165,  166,  167},
  { 166,  167,  165},
  { 166,  209,  153},
  { 167,  166,  153},
  {  57,  170,  134},
  { 153,  169,  137},
  { 169,  152,  137},
  { 169,  151,  152},
  { 171,  122,  216},
  { 217,  155,  183},
  { 248,  138,  173},
  { 138,  175,  156},
  { 184,  156,  175},
  { 122,  177,  218},
  { 176,  174,  177},
  { 219,  183,  156},
  { 156,  221,  219},
  { 226,  157,  224},
  { 157,  178,  224},
  { 190,  158,  157},
  { 191,  253,  140},
  { 192,  190,  275},
  { 259,  141,  196},
  { 259,  231,  141},
  { 144,  160,  200},
  { 180,  200,  160},
  { 229,  197,  180},
  { 180,  199,  200},
  { 144,  200,  161},
  { 233,  230,  143},
  { 143,  230,  142},
  { 145,  234,  198},
  { 200,  181,  161},
  { 233,  127,  345},
  { 145,  201,  234},
  { 146,  261,  262},
  { 202,  128,  203},
  { 128,  204,  203},
  { 236,   85,  238},
  { 147,  202,  309},
  {  85,  236,  163},
  { 163,  239,  148},
  { 132,  169,  207},
  { 153,  209,  169},
  { 151,  169,  132},
  {  57,  136,  170},
  { 170,  212,  134},
  { 171,  211,  153},
  { 213,  211,  171},
  { 134,  212,  154},
  { 154,  214,  245},
  { 154,  245,  172},
  { 171,  153, 5887},
  { 247,  174,  246},
  { 217,  246,  155},
  { 174,  247,  218},
  { 138,  248,  175},
  { 217,  183,  219},
  { 175,  248,  184},
  { 218,  177,  174},
  { 221,  184,  185},
  { 156,  184,  221},
  { 251,  223,  225},
  { 186,  187,  188},
  { 186,  189,  187},
  { 186,  188,  189},
  { 178,  158,  252},
  { 157,  140,  253},
  { 191,  227,  193},
  { 179,  302,  227},
  { 229,  193,  227},
  { 191,  193,  194},
  { 141,  231,  159},
  { 196,  142,  230},
  { 180,  197,  232},
  { 200,  199,  181},
  { 127,  309,  345},
  { 237,  283,  146},
  { 146,  262,  237},
  { 204,  149,  205},
  { 149,  206,  205},
  { 149,  207,  210},
  { 164,  242,  208},
  { 164,  182,  242},
  { 208,  265,  133},
  { 167,  241,  166},
  { 241,  209,  166},
  { 211,  241,  167},
  { 265,  168,  133},
  { 167,  153,  211},
  { 209,  207,  169},
  { 136,  168,  265},
  { 265,  170,  136},
  { 170,  265,  212},
  { 243,  213,  216},
  { 214,  154,  215},
  { 154,  212,  215},
  { 171,  216,  213},
  { 246,  217,  293},
  { 172,  268,  295},
  { 217,  249,  293},
  { 172,  295,  173},
  { 173,  295,  248},
  { 216,  122,  218},
  { 217,  219,  249},
  { 249,  219,  221},
  { 220,  184,  248},
  { 220,  185,  184},
  { 185,  220,  221},
  { 221,  220,  250},
  { 223,  251,  222},
  { 222,  224,  223},
  { 223,  252,  225},
  { 187,  189,  252},
  { 187,  252,  188},
  { 157,  226,  140},
  { 274,  189,  188},
  { 157,  253,  273},
  { 157,  273,  190},
  { 333,  190,  273},
  { 302,  179,  272},
  { 190,  333,  275},
  { 277,  195,  198},
  { 258,  159,  279},
  { 159,  231,  279},
  { 198,  305,  145},
  { 282,  145,  305},
  { 341,  282,  305},
  { 280,  231,  259},
  { 180,  232,  199},
  { 199,  232,  235},
  { 146,  282,  261},
  { 201,  146,  283},
  { 202,  203,  348},
  { 311,  348,  203},
  { 263,  163,  236},
  { 163,  263,  239},
  { 239,  240,  148},
  { 182,  240,  264},
  { 209,  241,  210},
  { 210,  207,  209},
  { 242,  182,  351},
  { 266,  182,  264},
  { 291,  213,  243},
  { 243,  216,  423},
  { 244,  245,  214},
  { 214,  215,  244},
  { 245,  268,  172},
  { 247,  294,  218},
  { 325,  249,  221},
  { 225,  330,  251},
  { 222,  270,  224},
  { 223,  224,  252},
  { 252,  224,  178},
  { 226,  272,  140},
  { 272,  179,  140},
  { 188,  254,  274},
  { 188,  256,  254},
  { 256,  276,  254},
  { 158,  192,  256},
  { 276,  256,  257},
  { 192,  257,  256},
  { 276,  301,  255},
  { 257,  192,  228},
  { 257,  228,  276},
  { 227,  302,  229},
  { 277,  300,  195},
  { 195,  305,  198},
  { 231,  280,  279},
  { 197,  260,  232},
  { 199,  235,  181},
  { 306,  198,  234},
  { 234,  201,  310},
  { 203,  204,  311},
  { 285,  237,  262},
  { 205,  206,  286},
  { 210,  241,  289},
  { 208,  242,  287},
  { 208,  287,  352},
  { 206,  289,  286},
  { 208,  352,  265},
  { 211,  288,  241},
  { 210,  289,  206},
  { 182,  266,  351},
  { 423,  291,  243},
  { 265,  352,  212},
  { 212,  315,  215},
  { 215,  245,  244},
  { 247,  246,  318},
  { 218,  317,  216},
  { 318,  294,  247},
  { 249,  325,  323},
  { 220,  357,  325},
  { 250,  220,  325},
  { 250,  325,  221},
  { 222,  329,  270},
  { 270,  297,  224},
  { 224,  271,  226},
  { 272,  226,  271},
  { 298,  330,  225},
  { 252,  189,  225},
  { 271,  224,  297},
  { 225,  189,  298},
  { 188,  158,  256},
  { 333,  253,  191},
  { 402,  255,  301},
  { 192,  364,  228},
  { 300,  277, 5888},
  { 195,  300,  278},
  { 276,  228,  340},
  { 194,  258,  191},
  { 195,  278,  305},
  { 304,  305,  278},
  { 303,  258,  279},
  { 335,  407,  197},
  { 230,  281,  196},
  { 196,  281,  259},
  { 230,  233,  281},
  { 280,  259,  307},
  { 197,  407,  260},
  { 232,  308,  235},
  { 232,  260,  308},
  { 370,  235,  308},
  { 369,  234,  310},
  { 344,  281,  345},
  { 235,  370,  238},
  { 261,  284,  262},
  { 283,  237,  374},
  { 204,  205,  312},
  { 288,  289,  241},
  { 211,  290,  288},
  { 291,  290,  211},
  { 267,  423,  216},
  { 352,  315,  212},
  { 355,  314,  267},
  { 292,  379,  384},
  { 267,  216,  355},
  { 216,  317,  355},
  { 356,  218,  294},
  { 489,  248,  295},
  { 294,  269,  356},
  { 294,  318,  269},
  { 321,  269,  318},
  { 326,  394,  327},
  { 329,  222,  398},
  { 270,  432,  297},
  { 272,  271,  332},
  { 297,  331,  299},
  { 297,  299,  271},
  {5888,  401,  433},
  { 298,  189,  274},
  { 252,  158,  188},
  { 273,  253,  333},
  { 272,  332,  302},
  { 275,  364,  192},
  { 364,  340,  228},
  { 333,  191,  303},
  { 301,  276,  334},
  { 276,  339,  334},
  { 229,  302,  197},
  { 302,  335,  197},
  { 340,  339,  276},
  { 191,  258,  303},
  { 305,  304,  341},
  { 277,  198,  306},
  { 279,  280,  442},
  { 407,  408,  260},
  { 280,  307,  442},
  { 259,  281,  344},
  { 259,  344,  307},
  { 260,  346,  308},
  { 368,  346,  260},
  { 282,  343,  261},
  { 233,  345,  281},
  { 345,  371,  344},
  { 201,  283,  310},
  { 261,  413,  284},
  { 374,  237,  285},
  { 417,  236,  238},
  { 202,  348,  371},
  { 348,  311,  372},
  { 204,  312,  311},
  { 236,  417,  263},
  { 418,  263,  417},
  { 286,  312,  205},
  { 263,  418,  239},
  { 262,  376,  285},
  { 264,  313,  266},
  { 286,  350,  375},
  { 289,  288,  349},
  { 266,  313,  351},
  { 349,  288,  381},
  { 378,  289,  421},
  { 289,  378,  286},
  { 211,  213,  291},
  { 353,  290,  291},
  { 314,  423,  267},
  { 215,  316,  245},
  { 384,  354,  292},
  { 386,  316,  354},
  { 319,  317,  218},
  { 356,  319,  218},
  { 320,  293,  249},
  { 320,  296,  321},
  { 320,  249,  322},
  { 249,  323,  322},
  { 220,  248,  357},
  { 320,  322,  324},
  { 391,  324,  322},
  { 296,  320,  324},
  { 323,  391,  322},
  { 324,  391,  426},
  { 327,  394,  429},
  { 330,  298,  399},
  { 297,  432,  331},
  { 299,  331,  400},
  { 274,  467,  298},
  { 332,  335,  302},
  { 337,  336,  334},
  { 334,  339,  337},
  { 365, 5888,  277},
  { 304,  278,  403},
  { 336,  337,  338},
  { 339,  340,  507},
  { 303,  279,  333},
  { 341,  304,  410},
  { 341,  410,  342},
  { 343,  282,  341},
  { 369,  306,  234},
  { 308,  346,  370},
  { 310,  447,  369},
  { 261,  343,  413},
  { 371,  345,  309},
  { 310,  283,  448},
  { 262,  284,  347},
  { 452,  262,  347},
  { 374,  285,  313},
  { 450,  372,  311},
  { 311,  312,  373},
  { 373,  312,  375},
  { 312,  286,  375},
  { 418,  451,  239},
  { 264,  240,  419},
  { 264,  419,  374},
  { 374,  313,  264},
  { 287,  242,  422},
  { 349,  421,  289},
  { 422,  352,  287},
  { 290,  381,  288},
  { 315,  383,  215},
  { 354,  456,  292},
  { 385,  379,  380},
  { 290,  353,  381},
  { 355,  388,  314},
  { 215,  383,  316},
  { 316,  383,  354},
  { 384,  379,  385},
  { 316,  386,  245},
  { 386,  354,  387},
  { 293,  318,  246},
  { 245,  459,  268},
  { 318,  293,  320},
  { 318,  320,  321},
  { 295,  460,  489},
  { 489,  357,  248},
  { 358,  269,  359},
  { 427,  325,  357},
  { 323,  325,  392},
  { 326,  395,  394},
  { 360,  326,  432},
  { 326,  327,  432},
  { 360,  329,  393},
  { 327,  429,  396},
  { 360,  432,  361},
  { 360,  361,  329},
  { 329,  361,  270},
  { 432,  270,  361},
  { 299,  400,  271},
  { 400,  332,  271},
  { 400,  363,  332},
  { 332,  363,  335},
  { 255,  402,  274},
  { 403,  278,  300},
  { 367,  275,  333},
  { 337,  339,  338},
  { 338,  366,  336},
  { 339,  366,  338},
  { 365,  277,  306},
  { 366,  339,  406},
  { 333,  279,  367},
  { 403,  410,  304},
  { 410,  444,  342},
  { 408,  368,  260},
  { 444,  445,  342},
  { 341,  342,  343},
  { 411,  442,  307},
  { 411,  307,  344},
  { 413,  343,  515},
  { 446,  411,  344},
  { 346,  368,  412},
  { 346,  412,  370},
  { 447,  310,  415},
  { 284,  414,  416},
  { 448,  415,  310},
  { 413,  414,  284},
  { 284,  416,  347},
  { 238,  370,  417},
  { 309,  202,  371},
  { 347,  416,  452},
  { 450,  311,  373},
  { 452,  376,  262},
  { 375,  350,  420},
  { 376,  351,  313},
  { 376,  313,  285},
  { 350,  455,  420},
  { 377,  422,  242},
  { 242,  351,  377},
  { 378,  454,  350},
  { 455,  350,  454},
  { 292,  456,  379},
  { 314,  388,  424},
  { 388,  382,  424},
  { 383,  485,  354},
  { 384,  387,  354},
  { 245,  386,  459},
  { 388,  529,  382},
  { 461,  317,  319},
  { 319,  356,  461},
  { 356,  269,  461},
  { 357,  389,  427},
  { 425,  321,  390},
  { 425,  390,  533},
  { 390,  296,  533},
  { 269,  321,  359},
  { 321,  296,  390},
  { 296,  324,  533},
  { 392,  391,  323},
  { 391,  392,  488},
  { 360,  539,  326},
  { 395,  326,  539},
  { 360,  393,  539},
  { 428,  328,  429},
  { 430,  328,  428},
  { 395,  429,  394},
  { 328,  430,  397},
  { 396,  429,  397},
  { 432,  327,  431},
  { 362,  433,  501},
  { 434,  435,  362},
  { 435,  300,  362},
  { 467,  274,  437},
  { 467,  437,  547},
  { 274,  402,  437},
  { 275,  367,  364},
  { 504,  301,  334},
  { 301,  504,  505},
  { 301,  505,  402},
  { 364,  439,  340},
  { 300,  435,  403},
  { 335,  363,  404},
  { 335,  404,  407},
  { 407,  404,  405},
  { 407,  405,  408},
  { 365,  306,  440},
  { 403,  468,  410},
  { 443,  440,  306},
  { 366,  406,  409},
  { 408,  472,  368},
  { 471,  444,  410},
  { 306,  369,  443},
  { 343,  342,  515},
  { 517,  474,  344},
  { 371,  348,  372},
  { 448,  374,  419},
  { 452,  351,  376},
  { 377,  351,  452},
  { 349,  381,  421},
  { 421,  523,  378},
  { 422,  315,  352},
  { 315,  524,  383},
  { 383,  524,  485},
  { 424,  382,  529},
  { 387,  384,  458},
  { 386,  387,  459},
  { 317,  388,  355},
  { 388,  486,  529},
  { 317,  461,  388},
  { 268,  459,  295},
  { 269,  358,  461},
  { 461,  358,  490},
  { 490,  359,  487},
  { 425,  487,  359},
  { 487,  425,  533},
  { 358,  359,  490},
  { 488,  392,  491},
  { 357,  489,  389},
  { 359,  321,  425},
  { 426,  391,  488},
  { 389,  489,  534},
  { 389,  534,  427},
  { 325,  427,  534},
  { 327,  396,  431},
  { 431,  396,  462},
  { 396,  397,  462},
  { 431,  464,  432},
  { 251,  330,  398},
  { 465,  398,  330},
  { 330,  399,  465},
  { 501,  433,  546},
  { 433,  401,  502},
  { 298,  467,  399},
  { 331,  466,  400},
  { 401,  549,  502},
  { 434,  436,  435},
  { 438,  363,  400},
  { 435,  436,  468},
  { 638,  437,  402},
  { 334,  336,  504},
  { 364,  367,  439},
  { 363,  438,  508},
  { 365,  440,  401},
  { 365,  401, 5888},
  { 336,  366,  506},
  { 363,  508,  404},
  { 404,  408,  405},
  { 339,  470,  406},
  { 366,  409,  506},
  { 339,  507,  470},
  { 367,  279,  439},
  { 406,  441,  409},
  { 279,  442,  439},
  { 472,  408,  508},
  { 445,  515,  342},
  { 443,  369,  447},
  { 411,  446,  644},
  { 344,  474,  446},
  { 368,  475,  412},
  { 519,  413,  515},
  { 413,  519,  414},
  { 449,  416,  414},
  { 419,  415,  448},
  { 448,  283,  374},
  { 476,  371,  477},
  { 417,  520,  418},
  { 373,  375,  478},
  { 482,  478,  375},
  { 240,  239,  479},
  { 240,  479,  419},
  { 375,  420,  482},
  { 422,  377,  524},
  { 421,  381,  453},
  { 378,  523,  454},
  { 379,  481,  380},
  { 422,  524,  315},
  { 571,  522,  381},
  { 456,  354,  485},
  { 423,  314,  525},
  { 353,  571,  381},
  { 353,  291,  423},
  { 457,  314,  424},
  { 529,  457,  424},
  { 385,  458,  384},
  { 428,  429,  494},
  { 537,  430,  536},
  { 496,  539,  393},
  { 539,  540,  395},
  { 430,  497,  397},
  { 498,  393,  398},
  { 497,  462,  397},
  { 431,  462,  464},
  { 432,  464,  331},
  { 465,  399,  586},
  { 637,  433,  502},
  { 433,  637,  546},
  { 400,  503,  438},
  { 401,  440,  549},
  { 468,  550,  469},
  { 506,  504,  336},
  { 435,  468,  403},
  { 469,  550,  551},
  { 508,  408,  404},
  { 406,  470,  441},
  { 512,  439,  442},
  { 411,  512,  442},
  { 444,  471,  445},
  { 557,  644,  446},
  { 557,  446,  474},
  { 370,  412,  417},
  { 447,  415,  518},
  { 417,  412,  520},
  { 479,  518,  415},
  { 371,  476,  344},
  { 344,  476,  517},
  { 449,  414,  519},
  { 415,  419,  479},
  { 450,  373,  478},
  { 481,  480,  612},
  { 477,  371,  372},
  { 239,  451,  479},
  { 481,  483,  480},
  { 612,  480,  483},
  { 379,  521,  483},
  { 483,  481,  379},
  { 420,  455,  570},
  { 521,  379,  456},
  { 453,  381,  522},
  { 481,  484,  380},
  { 526,  525,  314},
  { 380,  572,  385},
  { 459,  530,  295},
  { 295,  530,  460},
  { 388,  461,  486},
  { 491,  658,  488},
  { 534,  491,  325},
  { 489,  575,  534},
  { 533,  324,  426},
  { 493,  492,  577},
  { 492,  493,  495},
  { 493,  494,  495},
  { 495,  494,  429},
  { 428,  536,  430},
  { 538,  582,  430},
  { 395,  540,  429},
  { 393,  498,  496},
  { 463,  583,  584},
  { 464,  462,  541},
  { 398,  465,  498},
  { 464,  541,  542},
  { 463,  584,  585},
  { 464,  542,  331},
  { 501,  673,  362},
  { 499,  500,  543},
  { 331,  542,  466},
  { 362,  673,  434},
  { 635,  434,  673},
  { 466,  503,  400},
  { 434,  635,  436},
  { 436,  550,  468},
  { 503,  591,  438},
  { 512,  340,  439},
  { 508,  438,  591},
  { 469,  551,  510},
  { 340,  512,  507},
  { 510,  511,  592},
  { 510,  551,  511},
  { 443,  549,  440},
  { 468,  509,  410},
  { 471,  410,  509},
  { 506,  409,  553},
  { 593,  472,  508},
  { 470,  554,  441},
  { 470,  507,  513},
  { 553,  409,  441},
  { 471,  552,  555},
  { 441,  473,  553},
  { 554,  473,  441},
  { 443,  447,  597},
  { 368,  472,  593},
  { 473,  514,  599},
  { 475,  368,  593},
  { 445,  516,  515},
  { 445,  471,  516},
  { 597,  447,  518},
  { 412,  475,  520},
  { 475,  605,  520},
  { 515,  602,  519},
  { 416,  449,  565},
  { 520,  561,  418},
  { 564,  372,  450},
  { 450,  478,  564},
  { 416,  565,  452},
  { 483,  521,  612},
  { 563,  477,  372},
  { 478,  482,  613},
  { 559,  451,  418},
  { 420,  614,  482},
  { 420,  570,  614},
  { 453,  522,  567},
  { 456,  485,  521},
  { 571,  654,  522},
  { 524,  566,  485},
  { 526,  314,  457},
  { 423,  656,  527},
  { 525,  526,  739},
  { 526,  457,  528},
  { 526,  528,  739},
  { 457,  655,  528},
  { 387,  458,  530},
  { 573,  385,  572},
  { 353,  423,  571},
  { 387,  530,  459},
  { 532,  487,  574},
  { 532,  574,  694},
  { 529,  486,  531},
  { 487,  532,  490},
  { 487,  533,  660},
  { 461,  490,  620},
  { 426,  488,  576},
  { 426,  576,  533},
  { 577,  622,  493},
  { 662,  625,  536},
  { 536,  625,  537},
  { 428,  494,  536},
  { 495,  429,  580},
  { 538,  430,  537},
  { 430,  582,  497},
  { 462,  497,  631},
  { 462,  631,  541},
  { 498,  669,  496},
  { 498,  465,  586},
  { 463,  585,  499},
  { 587,  499,  585},
  { 500,  499,  587},
  { 500,  587,  543},
  { 586,  399,  544},
  { 399,  467,  544},
  { 633,  544,  467},
  { 466,  542,  588},
  { 466,  588,  503},
  { 547,  633,  467},
  { 545,  502,  548},
  { 638,  547,  437},
  { 549,  548,  502},
  { 550,  436,  635},
  { 504,  676,  505},
  { 468,  469,  509},
  { 469,  510,  509},
  { 509,  552,  471},
  { 549,  443,  597},
  { 470,  513,  554},
  { 594,  553,  473},
  { 512,  411,  507},
  { 596,  507,  411},
  { 555,  552,  724},
  { 554,  598,  473},
  { 411,  644,  596},
  { 473,  598,  514},
  { 601,  471,  555},
  { 593,  647,  475},
  { 471,  601,  516},
  { 599,  514,  556},
  { 597,  518,  558},
  { 515,  516,  601},
  { 514,  598,  556},
  { 475,  647,  605},
  { 474,  517,  557},
  { 517,  476,  603},
  { 479,  559,  558},
  { 479,  558,  518},
  { 560,  520,  605},
  { 605,  561,  560},
  { 562,  449,  519},
  { 607,  476,  477},
  { 561,  520,  560},
  { 477,  609,  607},
  { 449,  562,  521},
  { 449,  521,  565},
  { 562,  612,  521},
  { 564,  478,  687},
  { 478,  613,  687},
  { 451,  559,  479},
  { 484,  481,  615},
  { 452,  565,  566},
  { 565,  521,  485},
  { 565,  485,  566},
  { 568,  567,  522},
  { 567,  568,  453},
  { 453,  568,  569},
  { 569,  421,  453},
  { 421,  569,  523},
  { 523,  616,  454},
  { 377,  452,  524},
  { 522,  654,  568},
  { 454,  616,  455},
  { 452,  566,  524},
  { 572,  380,  617},
  { 380,  484,  617},
  { 457,  618,  655},
  { 457,  619,  618},
  { 525,  656,  423},
  { 457,  529,  619},
  { 423,  527,  571},
  { 460,  530,  657},
  { 458,  385,  573},
  { 531,  742,  529},
  { 658,  491,  659},
  { 461,  620,  486},
  { 490,  532,  620},
  { 533,  576,  660},
  { 488,  621,  576},
  { 622,  579,  493},
  { 493,  579,  494},
  { 626,  623,  627},
  { 492,  495,  580},
  { 492,  580,  578},
  { 626,  627,  535},
  { 494,  579,  536},
  { 535,  627,  629},
  { 537,  625,  665},
  { 535,  581,  666},
  { 535,  629,  581},
  { 429,  540,  580},
  { 583,  581,  629},
  { 539,  496,  845},
  { 631,  497,  582},
  { 583,  630,  584},
  { 588,  541,  631},
  { 542,  541,  588},
  { 543,  587,  714},
  { 503,  588,  589},
  { 546,  673,  501},
  { 590,  634,  545},
  { 545,  634,  716},
  { 503,  589,  591},
  { 549,  639,  548},
  { 676,  504,  506},
  { 640,  505,  676},
  { 641,  508,  591},
  { 642,  676,  506},
  { 505,  640,  402},
  { 508,  641,  593},
  { 597,  639,  549},
  { 509,  510,  552},
  { 642,  506,  553},
  { 592,  552,  510},
  { 551,  812,  511},
  { 513,  726,  595},
  { 513,  595,  554},
  { 554,  595,  598},
  { 646,  473,  599},
  { 555,  645,  601},
  { 598,  600,  556},
  { 557,  517,  649},
  { 604,  558,  559},
  { 604,  651,  558},
  { 559,  606,  604},
  { 603,  476,  607},
  { 561,  606,  559},
  { 602,  608,  519},
  { 610,  519,  608},
  { 519,  610,  611},
  { 519,  611,  562},
  { 561,  559,  418},
  { 562,  611,  612},
  { 609,  477,  563},
  { 481,  612,  615},
  { 612,  611,  615},
  { 569,  652,  523},
  { 484,  615,  691},
  { 523,  652,  616},
  { 455,  616,  653},
  { 455,  653,  570},
  { 617,  484,  692},
  { 741,  619,  529},
  { 657,  530,  458},
  { 572,  693,  573},
  { 778,  573,  693},
  { 656,  571,  527},
  { 739,  656,  525},
  { 742,  741,  529},
  { 458,  573,  657},
  { 460,  657,  740},
  { 491,  534,  659},
  { 621,  696,  576},
  { 624, 5889,  578},
  { 623,  700,  627},
  { 578,  580,  624},
  { 664,  624,  580},
  { 536,  579,  662},
  { 625,  628,  665},
  { 540,  539,  794},
  { 630,  583,  629},
  { 583,  463,  667},
  { 463,  499,  667},
  { 584,  708,  585},
  { 498,  586,  669},
  { 668,  670,  757},
  { 499,  632,  667},
  { 499,  543,  632},
  { 712,  585,  709},
  { 587,  585,  714},
  { 543,  714,  672},
  { 588,  710,  589},
  { 590,  713,  634},
  { 545,  636,  502},
  { 673,  546,  717},
  { 547,  715,  633},
  { 590,  545,  548},
  { 590,  548,  675},
  { 718,  546,  637},
  { 589,  674,  591},
  { 596,  513,  507},
  { 552,  643,  724},
  { 552,  592,  643},
  { 678,  643,  592},
  { 677,  721,  553},
  { 592,  511,  678},
  { 727,  678,  511},
  { 812,  763,  511},
  { 511,  763,  727},
  { 553,  594,  677},
  { 597,  723,  639},
  { 597,  648,  723},
  { 558,  648,  597},
  { 645,  555,  724},
  { 473,  646,  594},
  { 599,  556,  768},
  { 598,  680,  600},
  { 769,  601,  645},
  { 600,  681,  556},
  { 556,  681,  770},
  { 647,  650,  605},
  { 515,  601,  602},
  { 517,  603,  649},
  { 650,  728,  605},
  { 651,  605,  728},
  { 602,  730,  608},
  { 561,  605,  651},
  { 606,  561,  651},
  { 651,  604,  606},
  { 608,  732,  610},
  { 607,  609,  822},
  { 731,  609,  563},
  { 609,  731,  822},
  { 611,  610,  615},
  { 372,  733,  563},
  { 372,  564,  733},
  { 613,  482,  688},
  { 614,  570,  773},
  { 734,  773,  570},
  { 653,  734,  570},
  { 569,  568,  654},
  { 652,  569,  654},
  { 652,  690,  616},
  { 776,  654,  571},
  { 484,  691,  692},
  { 656,  776,  571},
  { 655,  618,  876},
  { 572,  617,  693},
  { 744,  574,  487},
  { 834,  488,  658},
  { 620,  531,  486},
  { 531,  620,  532},
  { 532,  694,  742},
  { 621,  834,  661},
  { 661,  834,  696},
  { 661,  696,  621},
  { 695,  576,  835},
  {5889,  624,  698},
  { 882,  579,  622},
  { 664,  698,  624},
  { 699,  579,  882},
  { 701,  628,  625},
  { 579,  663,  662},
  { 663,  625,  662},
  { 703,  665,  628},
  { 628,  704,  703},
  { 626,  535,  666},
  { 540,  664,  580},
  { 626,  666,  795},
  { 582,  538,  752},
  { 666,  581,  750},
  { 629,  627,  705},
  { 751,  583,  667},
  { 629,  705,  630},
  { 708,  584,  630},
  { 706,  799,  668},
  { 757,  756,  668},
  { 669,  586,  758},
  { 631,  710,  588},
  { 671,  670,  668},
  { 672,  632,  543},
  { 586,  544,  758},
  { 670,  671,  713},
  { 673,  759,  635},
  { 672,  714,  711},
  { 713,  671,  634},
  { 589,  710,  674},
  { 545,  716,  636},
  { 636,  637,  502},
  { 633,  715,  712},
  { 636,  810,  637},
  { 718,  717,  546},
  { 675,  548,  720},
  { 402,  640,  761},
  { 639,  720,  548},
  { 642,  553,  721},
  { 643,  678,  722},
  { 593,  641,  762},
  { 593,  679,  647},
  { 594,  646,  764},
  { 598,  595,  680},
  { 726,  680,  595},
  { 596,  644,  726},
  { 724,  765,  645},
  { 647,  679,  650},
  { 644,  557,  682},
  { 648,  683,  728},
  { 680,  681,  600},
  { 685,  601,  769},
  { 556,  770,  729},
  { 557,  649,  682},
  { 683,  648,  684},
  { 651,  684,  648},
  { 683,  684,  728},
  { 648,  558,  651},
  { 602,  601,  685},
  { 607,  649,  603},
  { 649,  607,  861},
  { 728,  684,  651},
  { 610,  732,  686},
  { 610,  686,  615},
  { 482,  614,  773},
  { 687,  613,  772},
  { 613,  688,  689},
  { 613,  689,  772},
  { 688,  482,  689},
  { 686,  827,  615},
  { 735,  652,  654},
  { 690,  652,  735},
  { 690,  736,  616},
  { 654,  776,  830},
  { 831,  618,  619},
  { 619,  741,  737},
  { 617,  738,  693},
  { 657,  573,  778},
  { 658,  659,  780},
  { 787,  460,  740},
  { 742,  531,  532},
  { 660,  744,  487},
  { 460,  787,  489},
  { 746,  659,  534},
  { 489,  745,  575},
  { 660,  576,  695},
  { 696,  835,  576},
  { 746,  534,  575},
  { 623, 5890,  700},
  { 623,  626,  791},
  { 699,  663,  579},
  { 663,  701,  625},
  { 626,  747,  791},
  { 665,  703,  702},
  { 747,  626,  795},
  { 749,  537,  665},
  { 665,  702,  749},
  { 703,  749,  702},
  { 627,  748,  705},
  { 538,  537,  752},
  { 753,  752,  537},
  { 581,  583,  751},
  { 794,  539,  845},
  { 582,  752,  707},
  { 845,  496,  755},
  { 668,  756,  706},
  { 496,  669,  755},
  { 582,  707,  631},
  { 706,  754,  799},
  { 667,  632,  797},
  { 670,  801,  757},
  { 671,  668,  803},
  { 712,  714,  585},
  { 759,  673,  717},
  { 710,  804,  674},
  { 716,  851,  636},
  { 675,  713,  590},
  { 635,  759,  760},
  { 674,  809,  591},
  { 718,  981,  717},
  { 591,  809,  719},
  { 550,  760,  551},
  { 550,  635,  760},
  { 638,  808,  547},
  { 591,  719,  641},
  { 675,  720,  815},
  { 402,  761,  638},
  { 762,  641,  719},
  { 676,  642,  855},
  { 642,  721,  855},
  { 643,  722,  724},
  { 594,  764,  677},
  { 639,  723,  720},
  { 722,  678,  727},
  { 763,  725,  727},
  { 513,  596,  726},
  { 724,  896,  765},
  { 723,  648,  728},
  { 766,  764,  646},
  { 599,  766,  646},
  { 767,  644,  682},
  { 765,  769,  645},
  { 679,  728,  650},
  { 820,  770,  681},
  { 602,  685,  730},
  { 861,  607,  822},
  { 732,  608,  730},
  { 563,  733,  731},
  { 687,  733,  564},
  { 690,  735,  829},
  { 616,  736,  653},
  { 617,  913,  775},
  { 618,  831,  876},
  { 831,  619,  737},
  { 656,  777,  776},
  { 777,  656,  739},
  { 741,  784,  737},
  { 779,  694,  574},
  { 528,  655,  782},
  { 694,  779,  833},
  { 740,  657,  781},
  { 778,  781,  657},
  { 920,  779,  574},
  { 780,  879,  658},
  { 780,  659,  743},
  { 833,  742,  694},
  { 574,  744,  920},
  { 743,  659,  746},
  { 660,  695,  744},
  { 488,  834,  621},
  { 489,  787,  745},
  { 575,  745,  746},
  { 696,  834,  835},
  { 788,  577,  836},
  { 577,  788,  622},
  { 701,  839,  628},
  { 627,  700,  748},
  { 663,  793,  701},
  { 664,  540,  794},
  { 842,  706,  704},
  { 666,  750,  795},
  { 703,  704,  756},
  { 581,  751,  750},
  { 704,  706,  756},
  { 752,  796,  707},
  { 667,  797,  885},
  { 798,  799,  754},
  { 585,  708,  709},
  { 708,  758,  709},
  { 631,  707,  710},
  { 802,  712,  709},
  { 672,  800,  632},
  { 710,  707,  804},
  { 671,  803,  634},
  { 711,  805,  800},
  { 670,  713,  801},
  { 711,  714,  807},
  { 711,  807,  805},
  { 809,  674,  804},
  { 811,  713,  675},
  { 810,  636,  851},
  { 808,  715,  547},
  { 637,  853,  718},
  { 760,  812,  551},
  { 815,  811,  675},
  { 640,  854,  761},
  { 935,  763,  813},
  { 721,  677,  814},
  { 814,  677,  939},
  { 722,  727,  724},
  { 763,  935,  725},
  { 677,  764,  939},
  { 815,  720,  723},
  { 896,  724,  856},
  { 726,  644,  680},
  { 679,  593,  818},
  { 727,  725,  898},
  { 725,  859,  898},
  { 644,  767,  680},
  { 815,  723,  728},
  { 599,  768,  766},
  { 942,  820,  681},
  { 682,  649,  861},
  { 769,  821,  685},
  { 685,  821,  730},
  { 770,  864,  865},
  { 730,  821,  823},
  { 864,  824,  865},
  { 771,  822,  731},
  { 771,  731,  687},
  { 730,  823,  732},
  { 908,  732,  823},
  { 731,  733,  687},
  { 908,  872,  732},
  { 732,  872,  686},
  { 482,  773,  689},
  { 734,  825,  773},
  { 615,  827,  691},
  { 653,  736,  734},
  { 691,  828,  774},
  { 690,  829,  736},
  { 691,  774,  692},
  { 654,  830,  735},
  { 735,  830,  829},
  { 617,  692,  913},
  { 738,  617,  775},
  { 692,  774,  913},
  { 737,  784,  916},
  { 739,  528,  782},
  { 915,  739,  782},
  { 655,  832,  782},
  { 743,  917,  780},
  { 783,  784,  741},
  { 833,  785,  784},
  { 781,  778,  786},
  { 781,  786,  740},
  { 742,  783,  741},
  { 783,  742,  784},
  { 742,  833,  784},
  { 740,  786,  787},
  { 658,  879,  834},
  { 836,  923,  788},
  { 789,  698,  790},
  {5890,  790,  700},
  { 790,  698,  664},
  { 704,  628,  839},
  { 883,  792,  699},
  { 969,  791,  747},
  { 790,  748,  700},
  { 699,  792,  793},
  { 699,  793,  663},
  { 793,  841,  701},
  { 701,  841,  839},
  { 756,  749,  703},
  { 843,  705,  748},
  { 749,  753,  537},
  { 750,  751,  971},
  { 667,  885,  751},
  { 705,  843,  630},
  { 796,  752,  753},
  { 753,  749,  846},
  { 749,  756,  846},
  { 630,  843,  848},
  { 630,  848,  758},
  { 630,  758,  708},
  { 669,  758,  755},
  { 757,  846,  756},
  { 800,  797,  632},
  { 849,  797,  800},
  { 668,  799,  803},
  { 672,  711,  800},
  { 709,  758,  802},
  { 544,  802,  758},
  { 633,  712,  802},
  { 802,  544,  633},
  { 800,  805,  850},
  { 713,  806,  801},
  { 634,  803,  716},
  { 713,  811,  806},
  { 712,  715,  714},
  { 716,  803,  851},
  { 714,  808,  807},
  { 714,  715,  808},
  { 852,  719,  809},
  { 981,  718,  853},
  { 759,  717,  937},
  { 808,  638,  761},
  { 812,  813,  763},
  { 814,  855,  721},
  { 762,  818,  593},
  { 816,  856,  724},
  { 724,  727,  816},
  { 817,  816,  727},
  { 679,  818,  728},
  { 764,  766,  858},
  { 860,  765,  896},
  { 819,  768,  556},
  { 819,  556,  729},
  { 941,  768,  819},
  { 768,  941,  766},
  { 680,  899,  681},
  { 765,  860,  769},
  { 862,  769,  860},
  { 769,  862,  821},
  { 824,  864,  866},
  { 687,  772,  907},
  { 867,  869,  868},
  { 772, 1131,  907},
  { 772, 1034, 1131},
  { 772,  689, 1034},
  { 869,  867,  826},
  { 689,  773,  871},
  { 686,  873,  827},
  { 828,  827,  873},
  { 828,  870,  774},
  { 827,  828,  691},
  { 736,  914,  734},
  { 734,  914,  825},
  { 774,  826,  913},
  { 913,  874,  775},
  { 776,  955,  830},
  { 776,  777, 1038},
  { 831,  737,  916},
  { 877,  738,  775},
  { 777,  915, 1038},
  { 738,  877,  693},
  { 777,  739,  915},
  { 655,  876,  832},
  { 784,  959,  916},
  { 787,  778,  878},
  { 779,  920,  997},
  { 918,  782,  832},
  { 787,  786,  778},
  { 743,  746,  921},
  { 960,  744,  695},
  { 789,  880,  697},
  { 697,  881,  836},
  { 697,  880,  881},
  { 923,  837,  788},
  { 789,  838,  880},
  { 622,  788,  882},
  {5890,  791,  884},
  { 790,  664,  794},
  { 967,  792,  883},
  { 704,  839,  842},
  { 792,  840,  793},
  { 926,  795,  750},
  { 793,  840,  841},
  { 842,  844,  706},
  { 754,  706,  844},
  { 844,  847,  754},
  { 797,  928,  885},
  { 753,  846,  796},
  { 848,  755,  758},
  { 797,  849,  886},
  { 707,  796,  804},
  { 850,  849,  800},
  { 888,  804,  796},
  { 799,  798,  890},
  { 889,  803,  799},
  { 890,  889,  799},
  { 850,  891,  887},
  { 891,  850,  805},
  { 801,  806,  888},
  { 852,  888,  806},
  { 807,  893,  805},
  { 807,  808,  761},
  { 759,  982,  760},
  { 760,  982,  812},
  { 852,  806,  811},
  { 810,  938,  853},
  { 810,  853,  637},
  { 852,  762,  719},
  { 852,  811,  815},
  { 981,  894,  717},
  { 717,  894,  937},
  { 854,  640,  676},
  { 814,  895,  855},
  { 818,  762,  815},
  { 728,  818,  815},
  { 896,  856,  816},
  { 816,  817,  896},
  { 857,  896,  817},
  { 727,  897,  817},
  { 859,  725,  983},
  { 897,  727,  898},
  { 764,  858,  939},
  { 680,  767,  899},
  { 860,  896,  901},
  { 767,  682,  899},
  { 682,  861,  899},
  { 819,  729,  863},
  { 729,  770,  863},
  { 770,  820,  902},
  { 770,  902,  864},
  { 862,  905,  821},
  { 770,  865,  863},
  { 687,  907,  771},
  {1086,  771,  907},
  { 771, 1086,  822},
  { 821,  905,  823},
  { 906,  824,  866},
  { 826,  867,  912},
  { 867,  911,  912},
  { 869,  826,  774},
  { 910,  870,  828},
  { 910,  828,  873},
  { 868,  869,  870},
  { 869,  774,  870},
  { 872,  873,  686},
  { 914,  736,  954},
  { 775,  874,  952},
  { 875,  829,  830},
  { 829,  875,  736},
  { 956,  830,  955},
  { 952, 1039,  775},
  { 877,  775, 1039},
  { 876,  957,  832},
  { 693,  877,  778},
  { 915,  782,  918},
  { 959,  784, 1048},
  { 832,  957,  918},
  { 784,  785, 1048},
  { 785,  833, 1048},
  { 743,  921,  919},
  { 879,  998,  834},
  { 746,  745,  921},
  { 925,  836,  881},
  { 788,  837,  882},
  { 837,  924,  882},
  { 880,  838,  966},
  { 882,  924,  883},
  { 699,  882,  883},
  {5890,  884,  838},
  { 792,  967,  840},
  { 839,  841,  842},
  { 790,  845,  748},
  { 790,  794,  845},
  { 795, 1009,  747},
  { 840,  927,  841},
  { 971,  926,  750},
  { 748,  845,  843},
  { 972,  844,  842},
  { 885,  971,  751},
  { 843,  845,  848},
  { 755,  848,  845},
  { 847,  844,  972},
  { 886,  928,  797},
  { 798,  754,  929},
  { 757,  796,  846},
  { 887,  886,  849},
  { 796,  757,  801},
  { 849,  850,  887},
  { 803,  889,  851},
  { 890,  976,  889},
  { 890,  892,  976},
  { 890,  798,  892},
  { 805,  932,  891},
  { 809,  888,  852},
  { 807,  761,  893},
  { 854,  893,  761},
  { 938,  810,  934},
  { 815,  762,  852},
  { 937,  982,  759},
  { 854,  676, 1023},
  { 676,  855, 1023},
  { 814, 1026,  895},
  { 896,  857,  984},
  { 817,  897,  857},
  { 940,  898,  859},
  { 858,  766,  941},
  { 943,  898,  940},
  { 819,  863,  900},
  { 820,  942, 1031},
  { 681,  899,  942},
  { 861,  942,  899},
  { 862,  860,  901},
  { 863,  944,  900},
  { 820, 1031,  902},
  { 901,  946,  862},
  { 902, 1031,  864},
  { 903,  864, 1031},
  { 905,  862,  946},
  { 863,  865,  945},
  { 904,  945,  865},
  { 864,  903,  866},
  { 865,  824,  904},
  { 947, 1033,  867},
  { 908,  823,  905},
  { 990,  867, 1033},
  { 867,  990,  948},
  { 867,  948,  911},
  { 824,  949,  988},
  { 824,  906,  949},
  { 947,  867,  868},
  { 947,  868,  910},
  { 910,  868,  870},
  { 773,  825,  909},
  {1034,  689,  871},
  { 991,  910,  873},
  {1034,  773,  950},
  { 908,  991,  872},
  { 872,  991,  873},
  { 871,  773, 1034},
  { 825,  914,  909},
  { 913,  952,  874},
  { 912,  952,  913},
  { 826,  912,  913},
  { 830,  956,  875},
  { 992,  831, 1094},
  {1038,  915, 1044},
  { 878,  778,  877},
  { 958,  917,  743},
  { 743,  993,  958},
  { 997,  833,  779},
  { 917,  879,  780},
  { 744,  960,  920},
  { 787,  878,  745},
  {1053,  960,  695},
  { 834,  961,  835},
  {1053,  695,  835},
  {1004,  924,  837},
  { 880,  964,  881},
  { 836,  925,  923},
  { 880,  966,  964},
  { 881,  964,  925},
  { 924,  967,  883},
  { 838,  884,  966},
  { 884, 1069,  966},
  { 970,  884,  791},
  { 926, 1009,  795},
  { 840, 1011,  927},
  { 841,  927,  842},
  { 885,  928, 1012},
  { 847,  929,  754},
  { 973,  847,  972},
  { 847,  973,  929},
  { 888,  796,  801},
  { 930, 1018,  892},
  { 930,  892,  798},
  { 887,  891,  931},
  { 805,  893,  932},
  { 932,  933,  891},
  { 891,  933,  975},
  { 889,  976,  851},
  { 804,  888,  809},
  { 851,  934,  810},
  { 979,  935,  813},
  { 893,  854, 1023},
  { 934,  936,  938},
  { 982, 1025,  812},
  { 981,  853,  938},
  { 812, 1025,  813},
  { 939, 1026,  814},
  { 857,  897,  984},
  { 939,  858, 1115},
  { 897,  898,  985},
  { 819,  900, 1120},
  { 819, 1120,  941},
  { 898,  943,  985},
  { 944,  863,  945},
  { 861,  822,  986},
  { 945,  904, 1126},
  { 903, 1032,  866},
  { 824,  988,  904},
  { 905,  989,  908},
  { 991,  908,  989},
  { 990, 1033, 1220},
  { 909,  950,  773},
  { 951,  911, 1035},
  { 951,  952,  912},
  { 951,  912,  911},
  { 736,  875,  954},
  { 955, 1036,  956},
  { 876,  831,  957},
  { 831,  992,  957},
  { 831,  916, 1094},
  { 877, 1040,  878},
  {1040,  994,  878},
  { 743,  919, 1047},
  { 994,  921,  745},
  { 745,  878,  994},
  { 919,  921, 1046},
  { 834,  998,  961},
  { 961, 1053,  835},
  { 962,  922, 1000},
  {1060,  962, 1002},
  { 837,  923, 1005},
  {1005, 1004,  837},
  { 925, 1006,  923},
  { 924, 1004,  965},
  { 925, 1065, 1006},
  {1005,  923, 1006},
  { 963, 1063, 1008},
  {1065,  925,  964},
  { 924,  965,  967},
  { 967,  965,  968},
  { 967,  968, 1011},
  { 967, 1011,  840},
  { 969,  970,  791},
  {1010,  926,  971},
  { 972,  842,  927},
  { 927, 1014,  972},
  { 971,  885, 1012},
  { 972, 1014,  973},
  { 798,  929,  930},
  {1012,  928, 1074},
  {1077,  928,  886},
  { 886,  887, 1077},
  {1015,  973, 1014},
  {1077,  887, 1107},
  {1107,  887, 1017},
  { 931, 1017,  887},
  { 931,  891,  975},
  { 932,  980,  933},
  { 933,  980,  977},
  { 933,  977,  975},
  { 851,  976,  934},
  { 976,  978,  934},
  { 976,  892,  978},
  { 932, 1023,  980},
  { 893, 1023,  932},
  { 977,  980, 1022},
  { 935,  983,  725},
  {1026, 1024,  895},
  { 894, 1114,  937},
  { 937, 1114,  982},
  { 859, 1027,  940},
  {1027,  859,  983},
  { 939, 1115, 1083},
  { 984,  901,  896},
  { 985,  984,  897},
  { 942,  861, 1031},
  { 861,  986, 1031},
  { 901, 1124,  946},
  {1031, 1032,  903},
  {1126,  904,  988},
  { 905,  946,  987},
  { 866, 1128, 1087},
  {1086,  986,  822},
  { 906,  866, 1087},
  { 905,  987,  989},
  { 988,  949, 1130},
  { 989, 5891,  947},
  {1035,  911,  948},
  { 991,  947,  910},
  {1034,  950, 1133},
  { 953,  952, 1132},
  {1092,  909,  914},
  { 953, 1039,  952},
  { 875, 1037,  954},
  { 956, 1037,  875},
  {1039, 1040,  877},
  {1039, 1137, 1040},
  { 957,  995,  918},
  { 916,  959, 1096},
  { 919,  996, 1047},
  { 996,  919, 1046},
  {1046,  921,  994},
  { 833,  997, 1048},
  { 917,  998,  879},
  { 920,  999,  997},
  { 960, 1053, 1050},
  {1001, 1054,  922},
  { 922, 1182, 1000},
  {1002, 1056, 1060},
  { 922,  962, 1058},
  {1098, 1059, 1055},
  {1003, 1061, 1059},
  {1061, 1003, 1063},
  {1061, 1063,  963},
  {1064, 1008, 1063},
  { 963, 1008, 1007},
  { 965, 1066, 1067},
  {1007, 1008, 1009},
  { 965, 1067,  968},
  {1069, 1152,  966},
  { 968, 1070, 1011},
  {1007,  926, 1010},
  {1009,  926, 1007},
  {1008,  747, 1009},
  {1008, 1064,  969},
  {1008,  969,  747},
  {1064,  970,  969},
  { 884,  970, 1069},
  { 971, 1012, 1071},
  {1011, 1072,  927},
  { 927, 1013, 1014},
  { 929,  973, 1076},
  { 929, 1076,  930},
  {1075, 1016,  974},
  { 930, 1076, 1018},
  {1079,  974, 1016},
  {1158, 1079, 1016},
  {1308, 1017,  931},
  {1018, 1019,  892},
  {1020, 1109,  974},
  { 931,  975, 1308},
  {1019,  978,  892},
  {1021, 1020,  974},
  { 979,  974, 1079},
  { 979,  813, 1021},
  { 979, 1021,  974},
  { 975,  977, 1080},
  {1080,  977, 1022},
  { 934,  978,  936},
  { 980,  895, 1024},
  {1023,  855,  980},
  { 855,  895,  980},
  { 938, 1164,  981},
  { 894,  981, 1114},
  { 940, 1027, 1028},
  {1027,  983, 1111},
  { 901, 1029, 1084},
  { 901,  984, 1029},
  {1116, 1029,  984},
  { 984,  985, 1116},
  {1166,  943,  940},
  { 858, 1117, 1115},
  { 858,  941, 1117},
  { 944, 1121,  900},
  { 944,  945, 1123},
  { 944, 1123, 1169},
  {1123,  945, 1126},
  {1124, 1127,  946},
  {1032, 1085,  866},
  { 946, 1127,  987},
  { 987, 5891,  989},
  { 906, 1172,  949},
  { 949, 1089, 1130},
  { 949, 1172, 1089},
  { 989,  947,  991},
  { 948,  990, 1174},
  {1035,  948, 1174},
  { 952,  951, 1132},
  {1274,  954, 1037},
  {1036,  955,  776},
  {1036,  776, 1038},
  {1093,  957,  992},
  {1039, 1135, 1137},
  {1093, 1179,  957},
  {1040, 1041,  994},
  {1040, 1042, 1041},
  {1041, 1042, 1043},
  {1041, 1043,  994},
  { 957, 1179, 1045},
  { 957, 1045,  995},
  { 958,  993, 1139},
  {1137, 1046,  994},
  { 993,  743, 1047},
  { 993, 1047, 1095},
  {1047,  996, 1095},
  {1046, 1095,  996},
  { 997, 1049, 1048},
  {1231, 1048, 1049},
  { 999,  920, 1143},
  { 960, 1143,  920},
  { 960, 1050, 1143},
  { 999, 1049,  997},
  {1050, 1053, 1052},
  {1050, 1052, 1051},
  {1053,  961, 1234},
  {1182,  922, 1054},
  {1001, 1183, 1054},
  {1000, 1002,  962},
  {1001,  922, 1055},
  {1002, 1097, 1056},
  { 922, 1057, 1055},
  { 922, 1058, 1057},
  {1060, 1056, 1145},
  {1055, 1057, 1098},
  {1059, 1098, 1003},
  {1061,  963, 1187},
  {1062, 1187,  963},
  {1063, 1003, 1190},
  {1063, 1190, 1064},
  {1150, 1192, 1004},
  { 965, 1004, 1099},
  { 965, 1099, 1066},
  {1100, 1062,  963},
  {1005, 1150, 1004},
  { 963, 1007, 1100},
  {1099, 1244, 1066},
  {1065, 1197, 1006},
  {1150, 1005, 1006},
  {1102, 1067, 1066},
  { 964,  966, 1149},
  {1152, 1149,  966},
  {1100, 1007, 1010},
  { 968, 1067, 1068},
  { 968, 1068, 1070},
  {1010, 1071, 1100},
  {1071, 1012, 1104},
  {1010,  971, 1071},
  {1011, 1070, 1072},
  {1012, 1074, 1073},
  { 927, 1072, 1013},
  { 973, 1015, 1078},
  {1109, 1075,  974},
  { 973, 1078, 1076},
  {1080, 1308,  975},
  {1081, 1109, 1020},
  {1020, 1021, 1025},
  {1082, 1019, 1110},
  {1020, 1025, 1081},
  { 978, 1019, 1082},
  { 938,  978, 1082},
  {1021,  813, 1025},
  {1113, 1022,  980},
  {1111,  983,  935},
  {1113, 1024, 1026},
  {1024, 1113,  980},
  {1112, 1027, 1111},
  {1026,  939, 1083},
  {1027, 1165, 1028},
  {1028, 1166,  940},
  {1116, 1084, 1029},
  {1166, 1119,  943},
  {1118, 1116,  985},
  { 985,  943, 1118},
  {1030, 1118,  943},
  {1169, 1121,  944},
  {1119, 1030,  943},
  {1031,  986, 1032},
  {1086, 1032,  986},
  { 866, 1085, 1128},
  {1088, 1033,  947},
  {1223, 1132,  951},
  { 909, 1090, 1134},
  { 909, 1134,  950},
  {1091, 1090,  909},
  { 909, 1092, 1091},
  { 914,  954, 1092},
  {1132, 1222,  953},
  {1092,  954, 1274},
  {1037,  956, 1136},
  {1135, 1039,  953},
  {1175, 1137, 1135},
  {1177,  956, 1036},
  {1178, 1093,  992},
  {1095, 1046, 1138},
  {1138, 1046, 1137},
  { 915, 1280, 1228},
  { 915, 1228, 1044},
  {1095, 1139,  993},
  {1040, 1137, 1043},
  {1040, 1043, 1042},
  { 915, 1181, 1280},
  {1096, 1180,  916},
  { 916, 1180, 1094},
  {1137,  994, 1043},
  { 915,  918, 1181},
  { 959, 1048, 1096},
  { 917,  958, 1230},
  { 995, 1181,  918},
  { 917, 1230, 1140},
  { 917, 1140,  998},
  {1231, 1096, 1048},
  { 998, 1140, 1354},
  {1141, 1049,  999},
  {1142, 1282,  999},
  { 998, 1354,  961},
  {1050, 1051, 1143},
  { 999, 1143, 1142},
  {1052, 1143, 1051},
  {1053, 1233, 1052},
  {1182, 1235, 1000},
  {1055, 1184, 1001},
  {1000, 1097, 1002},
  {1000, 1185, 1097},
  {1097, 1144, 1056},
  {1057, 1058, 1146},
  {1057, 1146, 1190},
  {1058,  962, 1146},
  { 962, 1060, 1189},
  {1098, 1057, 1190},
  {1098, 1190, 1003},
  {1064, 1190, 1147},
  {1064, 1147,  970},
  {1066, 1244, 1102},
  {1103, 1006, 1197},
  {1006, 1103, 1101},
  {1101, 1103, 1150},
  {1101, 1150, 1006},
  {1067, 1102, 1068},
  { 970, 1151, 1069},
  {1071, 1104, 1100},
  {1152, 1069, 1151},
  {1104, 1012, 1073},
  {1074, 1105, 1073},
  {1013, 1199, 1014},
  {1156, 1014, 1199},
  {1014, 1156, 1015},
  {1075, 5892, 1016},
  {1075, 1106, 1201},
  {5892, 1158, 1016},
  { 928, 1077, 1074},
  {1108, 1015, 1156},
  {1015, 1108, 1078},
  {1078, 1157, 1076},
  {1075, 1109, 1106},
  {1077, 1107, 1200},
  {1017, 1308, 1203},
  {1078, 1108, 1157},
  {1018, 1258, 1019},
  {1110, 1160, 1082},
  {1109, 1081, 1161},
  { 979, 1079, 1111},
  {1160, 1164, 1082},
  {1082, 1164,  938},
  { 982, 1161, 1081},
  { 935,  979, 1111},
  {1112, 1111, 1209},
  { 938,  936,  978},
  {1025,  982, 1081},
  {1112, 1165, 1027},
  {1161,  982, 1114},
  {1026, 1083, 1113},
  {1083, 1115, 1261},
  {1165, 1166, 1028},
  { 941, 1120, 1117},
  {1030, 1125, 1118},
  { 900, 1121, 1120},
  {1030, 1119, 1122},
  {1119, 1168, 1122},
  {1126, 1167, 1123},
  {1030, 1122, 1125},
  {1122, 1168, 1217},
  {1122, 1217, 1125},
  {1267, 1217, 1170},
  {1086, 1085, 1032},
  {1171, 1086,  907},
  {1129,  987, 1127},
  { 906, 1087, 1172},
  {1088, 1219, 1033},
  {1089, 1269, 1130},
  {1220, 1033, 1219},
  {1089, 1173, 1269},
  {1089, 1172, 1173},
  {1220, 1174,  990},
  {1223, 1174, 1328},
  {1034, 1133, 1270},
  {1174, 1223, 1035},
  {1090, 1091, 1221},
  { 951, 1035, 1223},
  {1133,  950, 1134},
  {1092, 1274, 1091},
  { 953, 1222, 1135},
  {1036, 1038, 1332},
  { 956, 1177, 1136},
  {1138, 1331, 1095},
  {1036, 1332, 1226},
  { 992, 1094, 1229},
  { 992, 1229, 1178},
  {1139, 1230,  958},
  {1231, 1049, 1232},
  {1354, 1234,  961},
  {1183, 1001, 1184},
  {1055, 1059, 1184},
  {1185, 1144, 1097},
  {1188, 1060, 1145},
  {1059, 1061, 1187},
  { 962, 1189, 1146},
  {1188, 1189, 1060},
  {1100, 1191, 1062},
  {1100, 1104, 1191},
  {1147, 1151,  970},
  { 964, 1149, 1065},
  {1102, 1295, 1148},
  {1065, 1149, 1197},
  {1149, 1193, 1197},
  {1148, 1246, 1195},
  {1153, 1195, 1246},
  {1154, 1435, 1250},
  {1070, 1155, 1072},
  {1198, 1153, 1246},
  {1250, 1198, 1154},
  {1072, 1155, 1199},
  {1073, 1105, 1251},
  {1072, 1199, 1013},
  {1074, 1077, 1105},
  {1105, 1077, 1251},
  {1200, 1251, 1077},
  {1157, 1018, 1076},
  {1107, 1017, 1203},
  {1158, 1111, 1079},
  {1111, 1158, 1159},
  {1019, 1205, 1110},
  {1110, 1260, 1160},
  {1159, 1209, 1111},
  {1022, 1162, 1208},
  {1022, 1113, 1162},
  {1315, 1162, 1113},
  {1163, 1164, 1160},
  {1161, 1114, 1163},
  {1209, 1165, 1112},
  {1113, 1083, 1315},
  {1165, 1317, 1166},
  {1117, 1318, 1115},
  {1118, 1263, 1116},
  {1084, 1116, 1214},
  {1211, 1120, 1121},
  {1084, 1214,  901},
  {1119, 1213, 1168},
  {1124,  901, 1214},
  {1124, 1321, 1127},
  {1168, 1170, 1217},
  {1126,  988, 1215},
  {1085, 1086, 1171},
  {1085, 1171, 1128},
  {1216, 1125, 1217},
  { 988, 1130, 1215},
  {1129, 1218, 5891},
  {1322, 1130, 1269},
  {1088, 1218, 1219},
  {1220, 1327, 1174},
  {1133, 1134, 1273},
  {1037, 1136, 1224},
  {1135, 1276, 1175},
  {1225, 1095, 1331},
  {1175, 1137, 1176},
  {1137, 1176, 1175},
  {1093, 1178, 1278},
  {1038, 1044, 1332},
  {1095, 1227, 1139},
  {1179, 1181, 1045},
  {1229, 1094, 1180},
  {1045, 1181,  995},
  {1096, 1231, 1180},
  {1141,  999, 1282},
  {1049, 1141, 1232},
  {1354, 1140, 1283},
  {1143, 1052, 1233},
  {1233, 1053, 1234},
  {1054, 1355, 1182},
  {1054, 1183, 1355},
  {1186, 1144, 1185},
  {1056, 1237, 1145},
  {1144, 1186, 1056},
  {1056, 1186, 1237},
  {1191, 1240, 1062},
  {1099, 1004, 1192},
  {1150, 1243, 1192},
  {1102, 1244, 1295},
  {1242, 1104, 1245},
  {1196, 1245, 1104},
  {1070, 1068, 1194},
  {1102, 1194, 1068},
  {1102, 1148, 1195},
  {1104, 1073, 1196},
  {1103, 1247, 1150},
  {1070, 1194, 1155},
  {1154, 1198, 1246},
  {1073, 1251, 1196},
  {1153, 1198, 1249},
  {1301, 1108, 1156},
  {1373, 1108, 1307},
  {1201, 1106, 1202},
  {1108, 1373, 1253},
  {1158, 5892, 1204},
  {1157, 1108, 1253},
  {1257, 1254, 1202},
  {1202, 1106, 1257},
  {1106, 1109, 1257},
  {1204, 1377, 1158},
  {1160, 1260, 1206},
  {1259, 1257, 1161},
  {1205, 1260, 1110},
  {1160, 1207, 1163},
  {1163, 1259, 1161},
  {1159, 1377, 1209},
  {1022, 1208, 1080},
  {1316, 1165, 1209},
  {1163, 1114,  981},
  {1163,  981, 1164},
  {1083, 1261, 1315},
  {1211, 1117, 1120},
  {1214, 1116, 1263},
  {1317, 1212, 1166},
  {1210, 1167, 1319},
  {1167, 1210, 1169},
  {1210, 1211, 1121},
  {1210, 1121, 1169},
  {1118, 1125, 1264},
  {1212, 1213, 1166},
  {1166, 1213, 1119},
  {1167, 1169, 1123},
  {1216, 1264, 1125},
  {1170, 1393, 1267},
  {1126, 1215, 1266},
  {1321, 1129, 1127},
  {1087, 1128, 1268},
  {1171, 1268, 1128},
  {1130, 1322, 1215},
  {1087, 1268, 1172},
  {1268, 1171, 1131},
  {1171,  907, 1131},
  {1173, 1172, 1325},
  {1133, 1273, 1271},
  {1221, 1134, 1090},
  {1221, 1091, 1272},
  {1091, 1274, 1272},
  {1132, 1275, 1329},
  {1328, 1405, 1223},
  {1406, 1330, 1135},
  {1037, 1224, 1274},
  {1135, 1330, 1276},
  {1276, 1138, 1175},
  {1137, 1175, 1138},
  {1177, 1036, 1277},
  {1226, 1277, 1036},
  {1093, 1278, 1179},
  {1225, 1227, 1095},
  {1228, 1332, 1044},
  {1228, 1280, 1279},
  {1227, 1410, 1139},
  {1232, 1141, 1417},
  {1140, 1230, 1283},
  {1142, 1143, 1233},
  {1355, 1488, 1182},
  {1000, 1357, 1185},
  {1236, 1184, 1059},
  {1186, 1185, 1357},
  {1059, 1187, 1236},
  {1356, 1184, 1236},
  {1145, 1238, 1188},
  {1146, 1189, 1285},
  {1288, 1285, 1189},
  {1241, 1188, 1238},
  {1239, 1426, 1290},
  {1187, 1062, 1287},
  {1240, 1287, 1062},
  {1189, 1188, 1288},
  {1289, 1288, 1188},
  {1289, 1188, 1241},
  {1426, 1286, 1290},
  {1286, 1292, 1290},
  {1190, 1291, 1147},
  {1147, 1291, 1151},
  {1191, 1104, 1242},
  {1192, 1244, 1099},
  {1152, 1362, 1193},
  {1152, 1193, 1149},
  {1194, 1102, 1195},
  {1194, 1195, 1248},
  {1193, 1298, 1197},
  {1197, 1247, 1103},
  {1247, 1506, 1150},
  {1194, 1248, 1155},
  {1195, 1153, 1248},
  {1196, 1251, 1368},
  {1298, 1433, 1197},
  {1247, 1197, 1433},
  {1248, 1199, 1155},
  {1249, 1248, 1153},
  {1299, 1249, 1198},
  {1198, 1250, 1299},
  {1249, 1302, 1248},
  {1200, 1107, 1252},
  {1203, 1252, 1107},
  {1374, 1509, 1075},
  {1201, 1374, 1075},
  {1018, 1157, 1258},
  {1157, 1253, 1255},
  {1157, 1255, 1258},
  {1254, 1259, 1256},
  {1109, 1161, 1257},
  {1258, 1205, 1019},
  {1206, 1256, 1207},
  {1206, 1207, 1160},
  {1254, 1257, 1259},
  {1377, 1159, 1158},
  {1080, 1208, 1310},
  {1258, 1384, 1205},
  {1260, 1205, 1384},
  {1207, 1256, 1259},
  {1207, 1259, 1163},
  {1377, 1316, 1209},
  {1262, 1210, 1388},
  {1211, 1210, 1262},
  {1115, 1318, 1261},
  {1263, 1118, 1264},
  {1212, 1390, 1213},
  {1213, 1390, 1168},
  {1124, 1214, 1321},
  {1170, 1168, 1390},
  {1167, 1126, 1265},
  {1323, 1264, 1216},
  {1215, 1322, 1266},
  {1216, 1217, 1323},
  {1268, 1131, 1034},
  {1268, 1034, 1270},
  {1172, 1268, 1270},
  {1129, 1399, 1218},
  {1218, 1402, 1219},
  {1325, 1172, 1403},
  {1270, 1133, 1271},
  {1328, 1174, 1327},
  {1221, 1272, 1474},
  {1271, 1273, 1326},
  {1134, 1221, 1273},
  {1132, 1223, 1275},
  {1329, 1222, 1132},
  {1405, 1275, 1223},
  {1135, 1222, 1406},
  {1476, 1224, 1136},
  {1224, 1475, 1274},
  {1276, 1331, 1138},
  {1531, 1277, 1226},
  {1177, 1277, 1136},
  {1178, 1229, 1335},
  {1228, 1279, 1332},
  {1179, 1278, 1336},
  {1279, 1280, 1281},
  {1231, 1352, 1180},
  {1352, 1231, 1667},
  {1141, 1282, 1417},
  {1282, 1142, 1485},
  {1485, 1142, 1233},
  {1419, 1234, 1354},
  {1233, 1419, 1418},
  {1419, 1233, 1234},
  {1145, 1237, 5894},
  {1183, 1184, 1356},
  {1187, 1359, 1236},
  {1236, 1284, 1356},
  {1186, 1420, 1237},
  {1239, 1421, 1422},
  {1236, 1358, 1284},
  {1420, 1360, 1237},
  {1421, 1239, 1361},
  {1239, 1422, 1426},
  {1287, 1492, 1187},
  {1360, 5894, 1237},
  {1285, 1190, 1146},
  {1190, 1285, 1291},
  {1285, 1362, 1291},
  {1191, 1242, 1429},
  {1498, 1293, 1292},
  {1292, 1293, 1364},
  {1242, 1245, 1500},
  {1151, 1291, 1294},
  {1151, 1294, 1152},
  {1243, 1296, 1192},
  {1192, 1296, 1244},
  {1365, 1244, 1296},
  {1244, 1365, 1295},
  {1297, 1148, 1295},
  {1148, 1297, 1246},
  {1506, 1243, 1150},
  {1297, 1505, 1504},
  {1297, 1504, 1246},
  {1300, 1368, 1251},
  {1199, 1248, 1302},
  {1249, 1299, 1303},
  {1199, 1302, 1301},
  {1302, 1249, 1303},
  {1200, 1300, 1251},
  {1156, 1199, 1301},
  {1200, 1252, 1304},
  {1372, 1304, 1252},
  {1508, 1306, 1305},
  {1307, 1108, 1301},
  {1204, 5892, 1441},
  {1202, 1375, 1201},
  {1201, 1375, 1374},
  {1308, 1080, 1310},
  {1309, 1253, 1688},
  {1253, 1309, 1255},
  {1255, 1313, 1258},
  {1309, 1313, 1255},
  {1258, 1313, 1384},
  {1312, 1381, 1314},
  {1206, 1260, 1384},
  {1162, 1381, 1208},
  {1208, 1447, 1310},
  {1315, 1314, 1162},
  {1316, 1377, 1444},
  {1315, 1261, 1389},
  {1262, 1454, 1211},
  {1319, 1388, 1210},
  {1117, 1211, 1318},
  {1214, 1263, 1320},
  {1264, 1320, 1263},
  {1167, 1265, 1457},
  {1265, 1126, 1266},
  {1265, 1266, 1391},
  {1264, 1323, 1392},
  {1266, 1322, 1391},
  {1323, 1217, 1267},
  {1321, 1399, 1129},
  {1269, 1173, 1396},
  {1173, 1325, 1396},
  {1172, 1270, 1324},
  {1270, 1271, 1324},
  {1172, 1324, 1271},
  {1220, 1219, 1327},
  {1325, 1403, 1400},
  {1326, 1172, 1271},
  {1327, 1524, 1328},
  {1405, 1328, 1526},
  {1273, 1472, 1326},
  {1407, 1475, 1224},
  {1330, 1716, 1276},
  {1225, 1331, 1586},
  {1333, 1226, 1332},
  {1178, 1335, 1408},
  {1332, 1279, 1480},
  {1225, 1409, 1227},
  {1480, 1279, 1334},
  {1279, 1281, 1533},
  {1179, 1336, 1181},
  {1229, 1534, 1335},
  {1410, 1227, 1409},
  {1281, 1280, 1533},
  {1280, 1181, 1533},
  {1181, 1336, 1533},
  {1337, 1339, 1338},
  {1337, 1338, 1340},
  {1337, 1481, 1339},
  {1139, 1482, 1230},
  {1337, 1410, 1409},
  {1340, 1338, 1341},
  {1338, 1342, 1343},
  {1338, 1343, 1341},
  {1338, 1339, 1344},
  {1338, 1344, 1342},
  {1342, 1344, 1345},
  {1342, 1345, 1343},
  {1180, 1352, 1229},
  {1337, 1340, 1346},
  {1340, 1341, 1347},
  {1340, 1347, 1348},
  {1340, 1348, 1346},
  {1349, 1346, 1348},
  {1341, 1343, 1350},
  {1341, 1350, 1347},
  {1343, 1345, 1351},
  {1343, 1351, 1350},
  {1413, 1337, 1414},
  {1348, 1347, 1349},
  {1353, 1349, 1347},
  {1347, 1350, 1353},
  {1351, 1353, 1350},
  {1231, 1232, 1667},
  {1230, 1484, 1283},
  {1283, 1797, 1354},
  {1535, 1182, 1488},
  {1182, 1535, 1235},
  {1356, 1355, 1183},
  {1235, 1357, 1000},
  {1235, 1489, 1357},
  {1186, 1357, 1672},
  {1356, 1284, 1536},
  {1358, 1536, 1284},
  {1187, 1492, 1359},
  {1238, 1494, 1241},
  {1361, 1239, 1427},
  {1287, 1240, 1492},
  {1239, 1290, 1431},
  {1240, 1191, 1429},
  {1285, 1288, 1362},
  {1288, 1289, 1193},
  {1433, 1289, 1241},
  {1241, 1542, 1433},
  {1290, 1292, 1432},
  {1294, 1291, 1362},
  {1289, 1433, 1363},
  {1292, 1364, 1432},
  {1293, 1434, 1367},
  {1503, 1367, 1434},
  {1294, 1362, 1152},
  {1250, 1435, 1364},
  {1364, 1293, 1250},
  {1245, 1196, 1436},
  {1196, 1368, 1436},
  {1243, 1506, 1296},
  {1297, 1295, 1365},
  {1499, 1246, 1504},
  {1246, 1499, 1154},
  {1293, 1367, 1250},
  {1368, 1369, 1366},
  {1299, 1549, 1303},
  {1250, 1367, 1437},
  {1306, 1508, 1441},
  {1368, 1300, 1304},
  {1300, 1200, 1304},
  {1369, 1368, 1371},
  {1369, 1371, 1370},
  {1368, 1372, 1371},
  {1368, 1304, 1372},
  {1301, 1302, 1307},
  {1508, 1305, 1509},
  {1252, 1442, 1372},
  {5892, 1306, 1441},
  {1252, 1203, 1442},
  {1442, 1203, 1308},
  {1253, 1373, 1688},
  {1558, 1374, 1375},
  {1254, 1376, 1202},
  {1202, 1376, 1375},
  {1376, 1445, 1375},
  {1254, 1448, 1376},
  {1376, 1448, 1445},
  {1206, 1451, 1256},
  {1383, 1378, 1559},
  {1559, 1379, 1382},
  {1385, 1382, 1379},
  {1559, 1382, 1383},
  {1380, 1311, 1517},
  {1314, 1381, 1162},
  {1313, 1450, 1384},
  {1385, 1383, 1382},
  {1314, 1315, 1312},
  {1381, 1447, 1208},
  {1206, 1384, 1451},
  {1383, 1385, 1387},
  {1384, 1450, 1564},
  {1453, 1454, 1262},
  {1316, 1444, 1452},
  {1386, 1317, 1452},
  {1386, 1383, 1455},
  {1383, 1387, 1455},
  {1262, 1388, 1453},
  {1316, 1452, 1317},
  {1386, 1455, 1317},
  {1316, 1317, 1165},
  {1454, 1318, 1211},
  {1454, 1517, 1318},
  {1261, 1318, 1389},
  {1318, 1517, 1389},
  {1457, 1319, 1167},
  {1265, 1391, 1457},
  {1320, 1264, 1392},
  {1214, 1320, 1464},
  {1170, 1390, 1459},
  {1214, 1464, 1321},
  {1391, 1322, 1460},
  {1392, 1323, 1462},
  {1463, 1462, 1323},
  {1394, 1267, 1393},
  {1267, 1394, 1461},
  {1461, 1522, 1267},
  {1395, 1399, 1321},
  {1465, 1463, 1323},
  {1267, 1465, 1323},
  {1396, 1322, 1269},
  {1399, 1395, 1397},
  {1267, 1398, 1465},
  {1267, 1522, 1398},
  {1396, 1325, 1400},
  {1396, 1400, 1401},
  {1400, 1467, 1401},
  {1218, 1468, 1402},
  {1172, 1326, 1403},
  {1400, 1404, 1467},
  {1403, 1404, 1400},
  {1402, 1469, 1219},
  {1219, 1469, 1327},
  {1327, 1470, 1524},
  {1328, 1524, 1526},
  {1474, 1272, 1274},
  {1273, 1221, 1473},
  {1584, 1275, 1405},
  {1329, 1275, 1529},
  {1222, 1329, 1406},
  {1224, 1476, 1407},
  {1277, 1476, 1136},
  {1276, 1716, 1331},
  {1476, 1277, 1531},
  {1480, 1226, 1333},
  {1532, 1278, 1178},
  {1178, 1408, 1532},
  {1335, 1663, 1408},
  {1335, 1724, 1663},
  {1279, 1533, 1334},
  {1336, 1587, 1533},
  {1409, 1481, 1337},
  {1481, 1411, 1339},
  {1337, 1795, 1414},
  {1795, 1337, 1346},
  {1795, 1346, 1416},
  {1339, 1411, 1412},
  {1339, 1412, 1344},
  {1344, 1412, 1415},
  {1344, 1415, 1345},
  {1410, 1337, 1413},
  {1346, 1349, 1353},
  {1346, 1353, 1415},
  {1346, 1415, 1416},
  {1415, 1353, 1345},
  {1351, 1345, 1353},
  {1230, 1482, 1484},
  {1485, 1233, 1591},
  {1283, 1484, 1797},
  {1536, 1355, 1356},
  {1359, 1423, 1236},
  {1236, 1423, 1358},
  {1360, 1537, 5894},
  {5893, 1494, 1238},
  {1361, 1427, 1495},
  {1361, 1495, 1490},
  {1286, 1425, 1428},
  {1492, 1240, 1429},
  {1494, 1542, 1241},
  {1427, 1496, 1495},
  {1427, 1239, 1431},
  {1286, 1428, 1292},
  {1492, 1429, 1430},
  {1427, 1431, 1496},
  {1242, 1430, 1429},
  {1193, 1362, 1288},
  {1363, 1193, 1289},
  {1290, 1432, 1431},
  {1432, 1364, 1435},
  {1293, 1498, 1434},
  {1298, 1193, 1363},
  {1363, 1433, 1298},
  {1501, 1245, 1436},
  {1433, 1502, 1247},
  {1366, 1544, 1501},
  {1436, 1366, 1501},
  {1435, 1154, 1499},
  {1436, 1368, 1366},
  {1296, 1683, 1365},
  {1297, 1365, 1505},
  {1250, 1438, 1299},
  {1250, 1437, 1438},
  {1302, 1439, 1307},
  {1302, 1303, 1439},
  {1548, 1443, 1441},
  {1307, 1439, 1373},
  {1548, 1444, 1443},
  {1440, 1552, 1370},
  {1442, 1308, 1511},
  {1688, 1373, 1550},
  {1441, 1443, 1204},
  {1204, 1443, 1377},
  {1510, 1378, 1512},
  {1557, 1511, 1308},
  {1308, 1310, 1557},
  {1514, 1557, 1310},
  {1443, 1444, 1377},
  {1309, 1513, 1313},
  {1446, 1378, 1449},
  {1446, 1512, 1378},
  {1380, 1561, 1311},
  {1310, 1447, 1514},
  {1313, 1513, 1560},
  {1379, 1515, 1385},
  {1379, 1559, 1515},
  {1311, 1312, 1517},
  {1313, 1560, 1450},
  {1256, 1451, 1448},
  {1256, 1448, 1254},
  {1444, 1446, 1452},
  {1446, 1449, 1452},
  {1449, 1378, 1383},
  {1380, 1453, 1626},
  {1449, 1383, 1386},
  {1384, 1628, 1451},
  {1452, 1449, 1386},
  {1454, 1453, 1380},
  {1315, 1389, 1312},
  {1566, 1387, 1385},
  {1387, 1566, 1456},
  {1458, 1456, 1566},
  {1317, 1455, 1212},
  {1390, 1212, 1455},
  {1459, 1390, 1455},
  {1455, 1387, 1459},
  {1456, 1459, 1387},
  {1388, 1319, 1570},
  {1319, 1457, 1570},
  {1457, 1638, 1520},
  {1457, 1391, 1638},
  {1320, 1392, 1464},
  {1459, 1393, 1170},
  {1458, 1394, 1393},
  {1321, 1464, 1395},
  {1395, 1464, 1397},
  {1465, 1398, 1521},
  {1397, 1464, 1466},
  {1397, 1466, 1399},
  {1466, 1218, 1399},
  {1218, 1466, 1468},
  {1467, 1404, 1471},
  {1404, 1403, 1472},
  {1403, 1326, 1472},
  {1402, 1468, 1525},
  {1404, 1472, 1471},
  {1402, 1525, 1469},
  {1469, 1470, 1327},
  {1473, 1221, 1583},
  {1474, 1583, 1221},
  {1526, 1584, 1405},
  {1473, 1472, 1273},
  {1475, 1528, 1274},
  {1275, 1584, 1529},
  {1530, 1329, 1529},
  {1477, 1478, 1479},
  {1531, 1226, 1480},
  {1225, 1586, 1409},
  {1334, 1533, 1661},
  {1139, 1413, 1482},
  {1139, 1410, 1413},
  {1589, 1414, 1795},
  {1481, 1664, 1411},
  {1534, 1229, 1352},
  {1795, 1416, 1411},
  {1411, 1416, 1412},
  {1415, 1412, 1416},
  {1413, 1414, 1483},
  {1232, 1417, 1668},
  {1417, 1282, 1669},
  {1483, 1593, 1413},
  {1419, 1592, 1418},
  {1487, 1592, 1419},
  {1419, 1487, 1486},
  {1235, 1535, 1489},
  {1672, 1357, 1489},
  {1420, 1186, 1672},
  {1490, 1421, 1361},
  {1601, 5893, 1594},
  {1358, 1423, 1595},
  {1425, 1491, 1428},
  {5893, 1601, 1494},
  {1286, 1426, 1425},
  {1492, 1493, 1359},
  {1359, 1540, 1423},
  {1602, 1423, 1540},
  {1600, 1424, 1537},
  {1426, 1539, 1425},
  {1359, 1493, 1540},
  {1492, 1430, 1493},
  {1540, 1493, 1430},
  {1242, 1540, 1430},
  {1543, 1496, 1431},
  {1540, 1242, 1497},
  {1500, 1497, 1242},
  {1499, 1543, 1431},
  {1431, 1432, 1499},
  {1497, 1500, 1604},
  {1610, 1434, 1498},
  {1434, 1610, 1503},
  {1433, 1542, 1502},
  {1432, 1435, 1499},
  {1500, 1245, 1501},
  {1437, 1367, 1503},
  {1502, 1506, 1247},
  {1544, 1366, 1546},
  {1366, 1369, 1507},
  {1299, 1438, 1549},
  {1369, 1615, 1507},
  {1549, 1550, 1303},
  {1615, 1369, 1370},
  {1439, 1303, 1550},
  {1510, 1548, 1618},
  {1370, 1371, 1440},
  {1371, 1372, 1440},
  {1442, 1440, 1372},
  {1439, 1550, 1373},
  {1552, 1440, 1616},
  {1510, 1444, 1548},
  {1444, 1510, 1446},
  {1510, 1512, 1446},
  {1559, 1378, 1510},
  {1380, 1623, 1561},
  {1311, 1562, 1312},
  {1516, 1381, 1312},
  {1380, 1626, 1623},
  {1381, 1516, 1447},
  {1628, 1384, 1564},
  {1451, 1628, 1448},
  {1515, 1518, 1385},
  {1380, 1517, 1454},
  {1629, 1453, 1388},
  {1517, 1312, 1389},
  {1458, 1569, 1634},
  {1570, 1457, 1520},
  {1393, 1459, 1456},
  {1456, 1458, 1393},
  {1391, 1460, 1638},
  {1458, 1461, 1394},
  {1458, 1574, 1461},
  {1576, 1461, 1574},
  {1322, 1578, 1460},
  {1461, 1576, 1522},
  {1578, 1322, 1396},
  {1462, 1464, 1392},
  {1463, 1644, 1462},
  {1465, 1645, 1463},
  {1396, 1523, 1578},
  {1398, 1522, 1521},
  {1396, 1401, 1523},
  {1401, 1467, 1650},
  {1401, 1650, 1580},
  {1466, 1651, 1468},
  {1471, 1581, 1467},
  {1468, 1652, 1525},
  {1526, 1524, 1655},
  {1471, 1527, 1581},
  {1471, 1472, 1527},
  {1474, 1274, 1528},
  {1473, 1583, 1472},
  {1474, 1528, 1582},
  {1530, 1406, 1329},
  {1717, 1531, 1480},
  {1479, 1477, 1478},
  {1278, 1585, 1662},
  {1588, 1481, 1586},
  {1336, 1278, 1587},
  {1664, 1481, 1588},
  {1534, 1724, 1335},
  {1795, 1411, 1664},
  {1534, 1352, 1590},
  {1589, 1483, 1414},
  {1413, 1593, 1482},
  {1482, 1593, 1484},
  {1591, 1233, 1418},
  {1670, 1485, 1591},
  {1904, 1669, 1282},
  {1485, 1670, 1282},
  {1484, 1593, 1797},
  {1486, 1419, 1487},
  {1419, 1354, 1487},
  {1592, 1487, 1354},
  {1488, 1355, 1671},
  {1490, 1675, 1421},
  {1421, 1675, 1422},
  {1536, 1358, 1673},
  {1596, 1360, 1420},
  {1422, 1598, 1426},
  {1595, 1423, 1602},
  {1360, 1596, 1537},
  {1491, 1599, 1603},
  {1490, 1495, 1541},
  {1490, 1541, 1597},
  {1425, 1539, 1491},
  {1491, 1603, 1428},
  {1426, 1538, 1539},
  {1494, 1541, 1542},
  {1605, 1541, 1495},
  {1495, 1496, 1605},
  {1498, 1606, 1610},
  {1543, 1499, 1504},
  {1500, 1501, 1607},
  {1437, 1503, 1545},
  {1611, 1544, 1546},
  {1684, 1296, 1506},
  {1437, 1545, 1438},
  {1612, 1438, 1545},
  {1507, 1546, 1366},
  {1613, 1546, 1507},
  {1296, 1684, 1683},
  {1614, 1438, 1612},
  {1613, 1507, 1547},
  {1507, 1750, 1547},
  {1441, 1553, 1548},
  {1549, 1438, 1551},
  {1553, 1618, 1548},
  {1551, 1438, 1614},
  {1508, 1553, 1441},
  {1440, 1511, 1616},
  {1440, 1442, 1511},
  {1551, 1614, 1554},
  {1553, 1622, 1620},
  {1374, 1558, 1509},
  {1508, 1619, 1553},
  {1556, 1555, 1554},
  {1309, 1688, 1513},
  {1694, 1515, 1559},
  {1514, 1447, 1516},
  {1312, 1562, 1516},
  {1448, 1625, 1445},
  {1450, 1692, 1564},
  {1563, 1568, 1518},
  {1565, 1519, 1627},
  {1627, 1519, 1563},
  {1518, 1566, 1385},
  {1767, 1567, 1565},
  {1518, 1568, 1566},
  {1563, 1519, 1568},
  {1566, 1568, 1569},
  {1566, 1569, 1458},
  {1630, 1388, 1570},
  {1567, 1571, 1565},
  {1567, 1573, 1571},
  {1565, 1571, 1519},
  {1519, 1572, 1568},
  {1568, 1572, 1569},
  {1633, 1570, 1520},
  {1573, 1567, 1631},
  {1572, 1632, 1569},
  {1519, 1571, 1572},
  {1639, 1571, 1573},
  {1571, 1639, 1572},
  {1639, 1636, 1572},
  {1578, 1575, 1460},
  {1642, 1576, 1574},
  {1464, 1462, 1579},
  {1646, 1579, 1462},
  {1643, 1646, 1462},
  {1644, 1643, 1462},
  {1463, 1645, 1644},
  {1521, 1645, 1465},
  {1642, 1703, 1576},
  {1575, 1578, 1577},
  {1579, 1466, 1464},
  {1578, 1523, 1648},
  {1523, 1401, 1580},
  {1468, 1651, 1652},
  {1652, 1656, 1525},
  {1527, 1583, 1654},
  {1527, 1472, 1583},
  {1583, 1474, 1582},
  {1525, 1656, 1469},
  {1582, 1528, 1659},
  {1528, 1475, 1659},
  {1526, 5896, 1584},
  {1659, 1475, 1407},
  {1714, 1406, 1530},
  {1660, 1530, 1529},
  {1529, 1584, 1660},
  {1477, 1787, 1479},
  {1476, 1531, 1788},
  {1331, 1716, 1586},
  {1334, 1717, 1480},
  {1792, 1585, 1278},
  {1278, 1532, 1792},
  {1481, 1409, 1586},
  {1534, 1590, 1724},
  {1352, 1667, 1590},
  {1591, 1418, 1592},
  {1670, 1904, 1282},
  {1595, 1673, 1358},
  {1420, 1674, 1596},
  {1597, 1601, 1594},
  {1594, 5895, 1597},
  {5895, 1490, 1597},
  {1595, 1602, 1739},
  {1491, 1539, 1599},
  {1599, 1678, 1603},
  {1597, 1541, 1601},
  {1426, 1680, 1538},
  {1537, 1811, 1600},
  {1539, 1677, 1599},
  {1428, 1603, 1292},
  {1601, 1541, 1494},
  {1540, 1497, 1604},
  {1541, 1605, 1681},
  {1606, 1498, 1292},
  {1604, 1607, 1679},
  {1605, 1496, 1683},
  {1609, 1683, 1496},
  {1496, 1543, 1609},
  {1607, 1604, 1500},
  {1608, 1502, 1542},
  {1609, 1543, 1505},
  {1748, 1503, 1610},
  {1544, 1607, 1501},
  {1611, 1607, 1544},
  {1365, 1683, 1609},
  {1609, 1505, 1365},
  {1505, 1543, 1504},
  {1503, 1748, 1545},
  {1506, 1502, 1608},
  {1684, 1506, 1681},
  {1546, 1613, 1822},
  {1547, 1750, 1613},
  {1612, 1749, 1614},
  {1614, 1749, 1685},
  {1507, 1615, 1750},
  {1614, 1685, 1554},
  {1688, 1551, 1554},
  {1688, 1550, 1551},
  {1509, 1690, 1508},
  {1553, 1620, 1618},
  {1752, 1687, 1616},
  {1557, 1752, 1616},
  {1616, 1511, 1557},
  {1555, 1621, 1554},
  {1554, 1617, 1556},
  {1509, 1558, 1690},
  {1622, 1553, 1619},
  {1554, 1621, 1688},
  {1619, 1508, 1690},
  {1514, 1689, 1557},
  {1621, 1555, 1617},
  {1755, 1558, 1693},
  {1375, 1693, 1558},
  {1619, 1761, 1622},
  {1620, 1762, 1618},
  {1756, 1618, 1762},
  {1622, 1624, 1620},
  {1691, 1559, 1510},
  {1693, 1375, 1445},
  {1761, 1624, 1622},
  {1625, 1693, 1445},
  {1518, 1515, 1832},
  {1562, 1311, 1561},
  {1518, 1832, 1563},
  {1628, 1625, 1448},
  {1628, 1758, 1625},
  {1450, 1560, 1692},
  {1628, 1564, 1763},
  {1453, 1629, 1626},
  {1634, 1569, 1632},
  {1635, 1631, 1698},
  {1631, 1635, 1573},
  {1572, 1636, 1632},
  {1633, 1520, 1638},
  {1632, 1636, 1634},
  {1458, 1634, 1574},
  {1700, 1768, 1638},
  {1768, 1633, 1638},
  {1636, 1642, 1634},
  {1575, 1700, 1638},
  {1460, 1575, 1638},
  {1640, 1700, 1641},
  {1700, 1575, 1641},
  {1573, 1702, 1639},
  {1641, 1575, 1577},
  {1640, 1641, 1704},
  {1641, 1577, 1648},
  {1641, 1648, 1704},
  {1576, 1703, 1522},
  {1648, 1577, 1578},
  {1643, 1705, 1646},
  {1521, 1522, 1649},
  {1648, 1580, 1706},
  {1648, 1523, 1580},
  {1580, 1650, 1706},
  {1650, 1467, 1707},
  {1581, 1707, 1467},
  {1527, 1653, 1581},
  {1654, 1653, 1527},
  {1524, 1783, 1655},
  {1526, 1655, 5896},
  {1656, 1710, 1469},
  {1469, 1710, 1470},
  {1657, 1654, 1583},
  {1658, 1583, 1582},
  {1470, 1782, 1524},
  {1584, 5896, 1787},
  {1659, 1658, 1582},
  {1713, 1712, 1407},
  {1476, 1713, 1407},
  {1714, 1330, 1406},
  {1477, 1660, 1584},
  {1660, 1715, 1530},
  {1660, 1477, 1715},
  {1715, 1477, 1719},
  {1718, 1533, 1587},
  {1718, 1661, 1533},
  {1585, 1792, 1662},
  {1587, 1278, 1791},
  {1278, 1662, 1791},
  {1408, 1722, 1532},
  {1483, 1589, 1793},
  {1483, 1723, 1725},
  {1664, 1794, 1666},
  {1664, 1666, 1665},
  {1592, 1727, 1591},
  {1483, 1725, 1593},
  {1664, 1665, 1902},
  {1665, 1666, 1726},
  {1665, 1726, 1902},
  {1417, 1669, 1668},
  {1232, 1668, 1796},
  {1854, 1670, 1591},
  {1592, 1354, 1728},
  {1535, 1488, 1737},
  {1489, 1535, 1738},
  {1488, 1671, 1737},
  {1355, 1536, 1671},
  {1536, 1673, 1671},
  {1673, 1595, 1808},
  {1420, 1807, 1674},
  {1594, 1740, 5895},
  {1674, 1912, 1596},
  {1594, 1600, 1740},
  {1675, 1741, 1676},
  {1675, 1676, 1598},
  {1675, 1598, 1422},
  {1676, 1680, 1598},
  {1598, 1680, 1426},
  {1677, 1810, 1599},
  {1539, 1538, 1744},
  {1677, 1539, 1817},
  {1603, 1678, 1292},
  {1540, 1743, 1602},
  {1679, 1743, 1540},
  {1680, 1744, 1538},
  {1606, 1292, 1678},
  {1679, 1540, 1604},
  {1542, 1541, 1608},
  {1606, 1746, 1610},
  {1681, 1608, 1541},
  {1607, 1611, 1679},
  {1679, 1611, 1682},
  {1684, 1681, 1605},
  {1605, 1683, 1684},
  {1815, 1747, 1610},
  {1608, 1681, 1506},
  {1611, 1546, 1822},
  {1686, 1552, 1827},
  {1549, 1551, 1550},
  {1552, 1686, 1370},
  {1370, 1686, 1615},
  {1750, 1615, 1686},
  {1552, 1616, 1687},
  {1685, 1617, 1554},
  {1510, 1618, 1756},
  {1510, 1756, 1691},
  {1556, 1617, 1555},
  {1754, 1752, 1557},
  {1557, 1689, 1754},
  {1560, 1513, 1688},
  {1621, 1560, 1688},
  {1695, 1689, 1514},
  {1560, 1621, 1692},
  {1690, 1757, 1619},
  {1761, 1619, 1757},
  {1559, 1691, 1694},
  {1515, 1694, 1759},
  {1561, 1623, 1760},
  {1874, 1760, 1623},
  {1516, 1695, 1514},
  {1831, 1620, 1624},
  {1693, 1625, 1758},
  {1627, 1765, 1565},
  {1627, 1563, 1832},
  {1626, 1629, 1766},
  {1629, 1388, 1630},
  {1630, 1570, 1633},
  {1630, 1633, 1696},
  {1696, 1633, 1697},
  {1696, 1697, 1630},
  {1567, 1836, 1631},
  {1699, 1700, 1637},
  {1698, 1770, 1635},
  {1701, 1635, 1770},
  {1634, 1642, 1574},
  {1637, 1700, 1640},
  {1635, 1701, 1573},
  {1639, 1702, 1772},
  {1772, 1642, 1636},
  {1703, 1642, 1772},
  {1466, 1579, 1646},
  {1775, 1643, 1644},
  {1466, 1646, 1651},
  {1705, 1777, 1646},
  {1775, 1705, 1643},
  {1645, 1521, 1773},
  {1776, 1773, 1521},
  {1649, 1776, 1521},
  {1640, 1704, 1647},
  {1704, 1706, 1647},
  {1522, 1703, 1649},
  {1706, 1650, 1774},
  {1646, 1708, 1651},
  {1646, 1777, 1708},
  {1774, 1650, 1707},
  {1651, 1708, 1652},
  {1652, 1708, 1779},
  {1653, 1654, 1709},
  {1656, 1652, 1779},
  {1781, 1710, 1656},
  {1583, 1658, 1711},
  {1657, 1583, 1711},
  {1658, 1659, 1785},
  {1659, 1407, 1786},
  {1712, 1786, 1407},
  {1584, 1787, 1477},
  {1330, 1714, 1716},
  {1715, 1714, 1530},
  {1479, 1787, 1719},
  {1479, 1719, 1477},
  {1713, 1476, 1788},
  {1954, 1792, 1532},
  {1586, 1716, 1588},
  {1334, 1661, 1717},
  {1720, 1717, 1661},
  {1952, 1720, 1661},
  {1718, 1587, 1791},
  {1588, 1716, 1721},
  {1723, 1483, 1899},
  {1408, 1663, 1722},
  {1794, 1664, 1588},
  {1794, 1898, 1726},
  {1794, 1726, 1666},
  {1669, 1853, 1668},
  {1593, 1725, 1798},
  {1232, 1796, 1667},
  {1591, 1956, 1854},
  {1797, 1593, 1798},
  {1592, 1728, 1852},
  {1354, 1730, 1729},
  {1354, 1729, 1731},
  {1732, 1731, 1729},
  {1354, 1731, 1728},
  {1733, 1728, 1731},
  {1734, 1732, 1729},
  {1729, 1730, 1735},
  {1729, 1735, 1734},
  {1731, 1732, 1733},
  {1736, 1733, 1732},
  {1732, 1734, 1736},
  {1735, 1736, 1734},
  {1737, 1671, 1802},
  {1801, 1672, 1489},
  {1808, 1671, 1673},
  {1672, 1807, 1420},
  {1808, 1595, 1739},
  {1678, 1599, 1810},
  {5895, 1741, 1675},
  {1596, 1811, 1537},
  {1741, 5895, 1740},
  {1739, 1602, 1813},
  {1677, 1817, 1810},
  {1742, 1600, 1811},
  {1600, 1816, 1740},
  {1742, 1816, 1600},
  {1676, 1745, 1680},
  {1744, 1817, 1539},
  {1678, 1812, 1815},
  {1680, 1745, 1744},
  {1606, 1678, 1746},
  {1746, 1815, 1610},
  {1679, 1682, 1820},
  {2050, 1820, 1682},
  {1747, 1748, 1610},
  {1612, 1545, 1748},
  {1822, 1682, 1611},
  {1749, 1612, 1748},
  {1823, 1822, 1613},
  {1552, 1865, 1827},
  {1613, 1750, 1823},
  {1865, 1552, 1825},
  {1749, 1826, 1685},
  {1687, 1825, 1552},
  {1687, 1752, 1751},
  {1692, 1617, 1685},
  {1690, 1558, 1755},
  {1752, 1754, 1753},
  {1692, 1621, 1617},
  {1754, 1695, 1753},
  {1689, 1695, 1754},
  {1690, 1755, 1757},
  {1762, 1870, 1756},
  {1691, 1871, 1694},
  {1763, 1692, 1828},
  {1620, 1831, 1762},
  {1561, 1830, 1562},
  {1692, 1763, 1564},
  {1761, 1873, 1624},
  {1623, 1626, 1874},
  {1562, 1928, 1516},
  {1695, 1516, 1928},
  {1758, 1628, 1764},
  {1627, 1832, 1765},
  {1565, 1833, 1767},
  {1630, 1766, 1629},
  {1697, 1834, 1630},
  {1567, 1767, 1836},
  {1838, 1697, 1633},
  {1631, 1835, 1698},
  {1699, 1876, 1700},
  {1768, 1838, 1633},
  {1835, 1837, 1698},
  {1699, 1637, 1878},
  {1700, 1876, 1768},
  {1770, 1698, 1769},
  {1770, 1839, 1701},
  {1701, 1839, 1840},
  {1702, 1573, 1701},
  {1701, 1840, 1702},
  {1702, 1840, 1771},
  {1702, 1771, 1772},
  {1639, 1772, 1636},
  {1640, 1647, 2002},
  {1772, 1842, 1703},
  {1644, 1645, 1775},
  {1773, 1775, 1645},
  {1703, 1842, 1649},
  {1704, 1648, 1706},
  {1776, 1886, 1773},
  {1776, 1649, 1842},
  {1777, 1705, 1884},
  {1705, 1775, 1884},
  {1774, 1707, 1890},
  {1707, 1844, 1890},
  {1707, 1778, 1844},
  {1707, 1581, 1778},
  {1581, 1653, 1778},
  {1653, 1709, 1778},
  {1654, 1657, 1709},
  {1709, 1780, 1845},
  {1781, 1656, 1892},
  {1711, 1709, 1657},
  {1711, 1658, 1785},
  {1782, 1470, 1710},
  {1783, 1524, 1782},
  {1784, 1655, 1783},
  {1785, 1659, 1786},
  {1782, 2089, 1783},
  {1783, 1949, 1784},
  {5896, 1847, 1787},
  {1788, 1848, 1713},
  {1787, 1849, 1719},
  {1719, 1714, 1715},
  {1790, 1531, 1896},
  {1789, 1896, 1531},
  {1531, 1717, 1789},
  {1661, 1718, 1952},
  {1532, 1722, 1954},
  {1483, 1793, 1899},
  {1721, 1794, 1588},
  {1719, 1898, 1794},
  {1722, 1663, 1954},
  {1724, 1590, 1903},
  {1667, 1851, 1590},
  {1727, 1592, 1852},
  {1796, 1851, 1667},
  {1904, 1853, 1669},
  {1852, 1728, 1725},
  {1670, 1854, 1904},
  {1354, 1797, 1730},
  {1728, 1733, 1798},
  {1736, 1798, 1733},
  {1798, 1736, 1797},
  {1799, 1797, 1736},
  {1730, 1797, 1800},
  {1730, 1800, 1735},
  {1736, 1735, 1799},
  {1800, 1799, 1735},
  {1738, 2038, 1801},
  {1738, 1801, 1489},
  {1906, 1737, 1802},
  {1907, 2040, 1802},
  {1907, 1802, 1804},
  {1804, 1802, 1805},
  {1671, 1805, 1802},
  {1672, 1803, 1807},
  {1805, 1671, 1808},
  {1804, 1806, 1908},
  {1804, 1805, 1806},
  {1805, 1808, 1806},
  {1908, 1806, 1809},
  {1807, 1962, 1674},
  {1674, 1962, 1912},
  {1596, 1912, 1811},
  {1740, 1816, 1741},
  {1812, 1857, 1815},
  {1741, 1814, 1676},
  {1602, 1743, 1813},
  {1741, 1816, 1858},
  {1745, 1676, 1814},
  {1815, 1746, 1678},
  {1820, 1743, 1679},
  {1814, 1916, 1745},
  {1819, 1745, 1860},
  {1745, 1819, 1744},
  {1860, 1745, 1916},
  {1819, 1862, 1744},
  {1821, 1744, 1862},
  {1744, 1821, 1817},
  {1822, 2050, 1682},
  {1862, 1819, 1860},
  {1747, 1815, 1861},
  {1748, 1824, 1749},
  {1748, 1920, 1824},
  {1747, 1920, 1748},
  {1824, 1826, 1749},
  {1823, 1750, 1866},
  {1825, 1687, 1751},
  {1825, 1751, 1867},
  {1686, 1827, 1750},
  {1685, 1826, 1868},
  {1685, 1868, 1828},
  {1752, 1753, 1751},
  {1753, 1829, 1751},
  {1692, 1685, 1828},
  {1753, 1695, 1829},
  {1693, 1869, 1755},
  {1756, 1870, 1691},
  {1755, 1869, 1757},
  {1762, 1980, 1870},
  {1927, 1760, 1874},
  {1828, 1926, 1763},
  {1764, 1872, 1758},
  {2145, 1757, 1869},
  {1515, 1759, 1832},
  {1759, 1694, 1931},
  {1561, 1760, 1830},
  {1928, 1562, 1830},
  {1757, 2145, 1761},
  {1763, 1764, 1628},
  {1763, 1872, 1764},
  {1565, 1765, 1833},
  {1626, 1766, 1874},
  {1834, 1766, 1630},
  {1984, 1767, 1833},
  {1875, 1833, 1765},
  {1631, 1836, 1835},
  {1878, 1936, 1699},
  {1697, 1838, 1937},
  {1837, 1769, 1698},
  {1769, 1837, 1879},
  {1637, 1640, 2002},
  {1637, 2002, 1878},
  {1770, 1769, 1880},
  {1771, 1996, 1881},
  {1771, 1841, 1772},
  {1771, 1881, 1841},
  {1772, 1841, 1842},
  {1842, 1841, 1940},
  {1775, 1773, 1885},
  {1775, 1885, 1884},
  {1706, 1887, 1647},
  {1706, 1774, 1887},
  {1708, 1777, 1843},
  {1708, 1843, 1779},
  {1844, 1778, 1891},
  {1892, 1779, 1843},
  {1778, 1709, 1845},
  {1779, 1892, 1656},
  {1709, 1711, 1780},
  {1785, 1780, 1711},
  {1785, 1786, 1846},
  {1949, 1783, 2089},
  {1846, 1786, 1895},
  {1712, 1713, 1848},
  {1848, 1895, 1786},
  {1786, 1712, 1848},
  {2088, 1849, 1787},
  {1531, 1790, 1788},
  {1714, 1719, 1716},
  {1789, 1717, 1897},
  {1718, 2031, 1952},
  {1718, 1791, 2091},
  {1662, 1792, 1953},
  {1719, 1721, 1716},
  {1721, 1719, 1794},
  {1720, 1850, 1717},
  {1899, 1793, 2260},
  {1725, 1723, 1900},
  {1901, 1726, 2033},
  {1726, 1898, 2033},
  {1902, 1726, 1901},
  {1591, 1727, 1956},
  {1851, 1796, 2037},
  {1668, 1853, 1796},
  {1725, 1728, 1798},
  {1800, 1797, 1799},
  {1737, 1905, 1535},
  {1738, 1535, 1905},
  {1957, 1672, 1801},
  {1672, 1957, 1803},
  {1908, 1907, 1804},
  {1803, 1957, 1807},
  {1908, 1809, 1909},
  {1806, 1808, 1809},
  {1739, 1809, 1808},
  {1809, 1739, 1911},
  {1809, 1855, 1909},
  {1809, 1911, 1855},
  {1810, 1812, 1678},
  {1810, 1910, 1812},
  {1909, 1855, 1856},
  {1739, 1813, 1911},
  {1811, 1912, 1913},
  {1811, 1913, 1742},
  {1741, 1858, 1814},
  {1858, 1916, 1814},
  {1743, 1820, 1969},
  {1743, 1969, 1813},
  {1817, 1818, 1810},
  {1859, 1861, 1815},
  {1916, 1971, 1860},
  {1919, 1817, 1821},
  {1863, 1817, 1919},
  {1817, 1863, 1818},
  {1918, 2050, 1822},
  {1864, 1821, 1862},
  {1919, 1821, 1864},
  {1860, 2052, 1862},
  {1864, 1862, 2052},
  {1822, 1823, 1918},
  {1867, 1921, 1865},
  {1865, 1825, 1867},
  {1826, 1824, 1923},
  {1865, 1922, 1827},
  {1827, 1922, 1750},
  {1866, 1750, 1922},
  {1826, 1923, 1868},
  {1829, 1867, 1751},
  {1828, 1868, 1926},
  {1925, 1760, 1927},
  {1758, 1929, 1693},
  {1693, 1929, 1869},
  {1872, 1929, 1758},
  {1694, 1871, 1931},
  {1926, 1872, 1763},
  {1761, 1930, 1873},
  {1831, 1624, 1979},
  {1832, 1759, 1931},
  {1834, 1874, 1766},
  {1934, 1983, 1834},
  {1765, 1832, 1875},
  {2148, 1833, 1875},
  {2066, 1875, 1832},
  {1836, 1767, 1933},
  {1834, 1697, 1937},
  {1935, 1877, 1837},
  {1837, 1835, 1935},
  {1699, 1936, 1876},
  {1876, 1838, 1768},
  {1937, 1838, 1876},
  {1879, 1837, 1877},
  {1879, 1880, 1769},
  {1939, 1840, 1839},
  {1995, 1770, 1880},
  {1996, 1771, 1840},
  {1882, 2002, 1647},
  {1777, 1883, 1843},
  {1776, 1842, 1886},
  {1773, 1886, 1885},
  {1887, 1774, 1890},
  {1647, 1887, 1888},
  {1647, 1888, 1889},
  {1890, 1844, 1891},
  {1891, 1778, 1942},
  {1845, 1780, 1943},
  {1780, 1893, 1943},
  {1780, 1785, 1894},
  {1780, 1894, 1893},
  {1893, 1894, 1944},
  {1710, 2024, 1782},
  {1894, 2020, 1944},
  {1785, 1846, 1894},
  {1847, 2088, 1787},
  {1847, 1948, 2088},
  {1846, 1895, 2020},
  {1848, 1788, 1951},
  {1788, 1790, 1951},
  {1896, 1951, 1790},
  {2090, 1789, 1897},
  {1791, 1662, 1953},
  {1954, 1953, 1792},
  {1952, 1850, 1720},
  {1717, 1850, 1897},
  {2100, 1723, 1899},
  {1793, 1589, 2034},
  {2101, 2034, 1589},
  {2256, 1901, 2033},
  {1724, 1954, 1663},
  {2259, 1725, 1900},
  {1725, 2259, 1852},
  {1589, 1795, 2101},
  {1851, 1903, 1590},
  {1795, 1664, 1902},
  {1727, 1852, 2102},
  {1737, 2039, 1905},
  {1905, 2038, 1738},
  {1810, 2046, 1910},
  {1857, 1812, 1910},
  {2125, 1909, 1856},
  {1914, 1856, 1855},
  {1967, 1856, 1914},
  {1742, 2126, 1816},
  {1915, 1859, 1815},
  {1816, 2126, 1858},
  {1818, 1863, 1917},
  {1861, 1859, 2132},
  {1861, 2132, 1920},
  {1863, 1919, 1972},
  {1972, 2053, 1863},
  {1861, 1920, 1747},
  {1824, 1920, 2055},
  {1865, 1921, 2138},
  {1865, 2138, 1922},
  {1867, 1973, 1921},
  {1923, 1824, 2055},
  {1867, 1924, 1973},
  {1922, 1975, 1866},
  {1866, 1975, 1974},
  {2140, 1868, 1923},
  {1867, 1829, 1924},
  {1868, 2140, 1926},
  {1760, 1925, 2061},
  {2061, 1830, 1760},
  {1829, 1695, 1978},
  {1928, 1978, 1695},
  {1926, 2140, 1872},
  {1981, 1691, 1870},
  {1624, 1873, 1979},
  {1981, 1870, 1980},
  {2145, 1869, 1929},
  {1831, 2062, 1762},
  {1762, 2062, 1980},
  {1982, 1927, 1874},
  {1832, 1931, 2066},
  {1836, 1932, 1935},
  {1836, 1933, 1932},
  {1933, 1767, 1984},
  {1833, 2148, 1984},
  {2066, 1931, 2067},
  {1834, 1937, 1934},
  {1877, 1935, 2069},
  {1835, 1836, 1935},
  {1876, 1936, 2150},
  {1876, 1985, 1937},
  {1937, 1985, 1934},
  {1936, 1878, 1987},
  {1877, 1938, 1879},
  {1880, 1879, 1994},
  {1995, 1880, 2159},
  {1839, 1770, 1939},
  {1939, 1996, 1840},
  {1841, 1881, 1940},
  {1941, 1842, 1940},
  {2007, 1884, 1885},
  {1777, 1884, 1883},
  {1884, 2010, 1883},
  {1886, 2007, 1885},
  {1886, 1842, 1941},
  {1883, 2013, 1843},
  {1889, 1882, 1647},
  {1843, 2013, 1892},
  {1888, 1887, 1889},
  {1887, 1890, 2240},
  {1887, 2240, 1889},
  {1890, 1891, 2170},
  {1942, 2170, 1891},
  {1845, 1942, 1778},
  {1943, 2171, 1845},
  {1892, 2018, 1781},
  {1945, 1944, 2020},
  {1945, 1946, 2014},
  {1781, 2018, 1710},
  {1710, 2018, 2024},
  {1945, 2020, 1946},
  {1946, 2025, 2014},
  {1947, 2014, 2025},
  {1947, 2026, 2015},
  {2026, 1947, 2025},
  {1784, 1949, 2087},
  {1894, 1846, 2020},
  {2020, 1895, 1950},
  {1895, 1848, 1951},
  {2031, 1718, 2091},
  {1791, 1953, 2091},
  {1719, 1849, 2032},
  {1719, 2032, 1898},
  {2256, 1902, 1901},
  {1852, 2259, 2102},
  {1851, 2263, 1903},
  {1903, 1955, 1724},
  {2102, 1956, 1727},
  {1853, 2037, 1796},
  {1906, 2118, 1737},
  {1801, 2038, 1957},
  {2040, 1906, 1802},
  {1957, 2120, 1958},
  {1958, 2121, 1959},
  {1959, 1807, 1957},
  {1957, 1958, 1959},
  {1959, 2121, 1962},
  {1960, 1962, 2121},
  {1961, 2043, 1963},
  {2042, 1907, 1908},
  {1907, 2042, 2040},
  {1962, 1807, 1959},
  {1961, 2044, 1960},
  {1961, 1963, 2044},
  {1960, 2044, 1962},
  {1964, 2045, 2043},
  {1911, 1813, 2047},
  {2046, 2124, 1910},
  {1910, 2124, 1857},
  {1914, 1855, 1965},
  {1914, 1965, 1968},
  {1914, 1968, 1967},
  {1913, 2126, 1742},
  {1815, 1857, 1915},
  {1967, 2125, 1856},
  {1859, 1915, 1966},
  {1818, 1917, 1810},
  {2050, 1969, 1820},
  {1967, 1968, 2131},
  {2051, 2131, 1968},
  {1968, 1970, 2051},
  {2051, 1970, 2050},
  {1863, 2053, 1917},
  {2054, 2053, 1972},
  {1866, 1974, 2207},
  {2057, 1923, 2055},
  {1922, 2056, 1975},
  {1976, 1974, 1975},
  {1923, 2057, 2140},
  {1924, 1829, 2142},
  {2058, 1977, 2059},
  {1829, 1978, 2142},
  {2059, 1977, 1979},
  {1979, 1977, 2060},
  {1925, 1927, 2144},
  {1979, 1873, 2059},
  {1871, 1691, 1981},
  {2212, 1873, 1930},
  {1873, 2212, 2059},
  {2064, 1871, 1981},
  {1872, 2063, 1929},
  {1761, 2145, 1930},
  {1981, 1980, 2064},
  {1834, 1982, 1874},
  {1982, 1834, 2065},
  {1983, 2065, 1834},
  {2064, 1931, 1871},
  {1933, 1984, 2147},
  {2064, 2067, 1931},
  {1877, 2069, 1986},
  {1986, 1938, 1877},
  {1989, 1993, 1988},
  {1990, 1991, 2152},
  {1991, 1992, 2152},
  {1988, 1993, 1994},
  {1988, 1994, 1938},
  {1938, 1994, 1879},
  {1878, 2073, 1987},
  {1990, 1998, 1991},
  {1992, 1991, 2004},
  {1992, 2004, 1999},
  {1992, 1999, 2071},
  {2071, 2000, 2078},
  {1993, 2075, 1994},
  {2163, 1995, 2159},
  {1995, 1939, 1770},
  {1939, 1995, 2076},
  {1939, 2076, 1996},
  {1878, 2002, 2073},
  {1990, 2074, 1997},
  {1990, 1997, 1998},
  {1997, 2166, 2080},
  {1997, 2074, 2166},
  {1997, 2080, 1998},
  {2071, 1999, 2000},
  {2000, 2001, 2078},
  {2003, 1991, 1998},
  {1999, 2005, 2000},
  {2000, 2005, 2001},
  {2003, 2004, 1991},
  {2008, 2003, 1998},
  {2003, 2008, 2004},
  {2004, 2006, 1999},
  {1999, 2006, 2005},
  {2002, 1882, 2291},
  {2009, 2005, 2011},
  {2005, 2009, 2081},
  {1884, 2007, 2010},
  {1940, 1881, 2079},
  {2006, 2004, 2008},
  {2011, 2006, 2012},
  {2006, 2011, 2005},
  {2007, 1886, 1941},
  {2008, 2015, 2006},
  {2008, 2014, 2015},
  {2082, 2014, 2008},
  {2012, 2006, 2015},
  {2019, 2011, 2012},
  {2011, 2016, 2009},
  {2009, 2016, 2017},
  {1892, 2013, 2018},
  {2011, 2019, 2016},
  {2167, 2017, 2083},
  {1845, 2171, 1942},
  {1893, 1944, 2084},
  {1893, 2084, 1943},
  {1944, 1945, 2082},
  {2014, 1947, 2015},
  {2015, 2021, 2012},
  {2012, 2021, 2019},
  {2016, 2027, 2017},
  {2017, 2027, 2022},
  {2017, 2022, 2083},
  {2083, 2022, 2023},
  {2019, 2029, 2027},
  {2019, 2027, 2016},
  {2024, 2089, 1782},
  {2020, 1950, 1946},
  {2025, 1946, 1950},
  {2021, 2015, 2026},
  {2021, 2029, 2019},
  {1949, 2085, 2087},
  {1784, 2087, 1948},
  {2025, 2173, 2026},
  {1950, 1895, 1951},
  {1950, 1951, 2028},
  {2022, 2174, 2023},
  {1951, 1896, 2030},
  {1789, 2030, 1896},
  {2030, 1789, 2090},
  {1849, 2088, 2180},
  {2091, 1953, 2181},
  {2092, 1850, 1952},
  {2032, 2258, 1898},
  {1897, 1850, 2092},
  {2258, 2033, 1898},
  {2100, 1899, 2035},
  {1899, 2260, 2035},
  {1795, 1902, 2101},
  {2036, 1724, 1955},
  {1954, 1724, 2036},
  {1903, 2263, 1955},
  {1851, 2105, 2263},
  {1851, 2037, 2105},
  {1853, 2106, 2037},
  {1853, 1904, 2106},
  {1854, 2116, 1904},
  {2039, 2192, 1905},
  {1905, 2192, 2038},
  {2039, 1737, 2118},
  {1906, 2040, 2118},
  {2120, 2041, 1958},
  {1958, 2041, 2121},
  {1960, 2121, 1961},
  {2040, 2042, 2191},
  {2043, 2123, 1964},
  {2044, 1912, 1962},
  {1963, 2043, 2045},
  {2196, 1964, 2123},
  {1912, 2044, 1913},
  {1909, 2125, 2319},
  {1911, 2047, 1855},
  {1964, 2048, 2129},
  {1964, 2196, 2048},
  {2046, 1810, 2127},
  {1855, 2047, 1965},
  {1810, 1917, 2127},
  {2047, 1813, 1969},
  {1966, 1915, 2128},
  {2126, 2199, 1858},
  {2048, 2049, 2129},
  {1859, 1966, 2132},
  {1968, 1965, 1970},
  {1965, 1969, 1970},
  {1970, 1969, 2050},
  {1920, 2132, 2134},
  {1860, 1971, 2049},
  {1860, 2049, 2052},
  {2052, 2130, 2133},
  {1918, 2051, 2050},
  {2051, 1918, 2204},
  {2052, 2133, 1864},
  {2135, 2204, 1918},
  {1823, 2135, 1918},
  {1972, 1919, 2203},
  {1972, 2206, 2054},
  {2137, 1921, 1973},
  {1823, 1866, 2207},
  {2203, 2206, 1972},
  {1922, 2138, 2056},
  {1975, 2056, 1976},
  {2058, 2211, 1977},
  {2139, 2058, 2059},
  {1978, 1928, 2142},
  {1979, 2060, 1831},
  {2060, 1977, 2062},
  {2142, 1830, 2061},
  {1830, 2142, 1928},
  {1831, 2060, 2062},
  {1927, 1982, 2144},
  {1980, 2146, 2064},
  {1935, 1932, 2068},
  {2220, 2068, 1932},
  {1932, 1933, 2220},
  {2148, 1875, 2066},
  {1985, 2151, 1934},
  {1934, 2151, 1983},
  {2069, 1935, 2068},
  {1876, 2150, 2280},
  {1876, 2280, 1985},
  {1985, 2280, 2151},
  {1938, 1986, 2223},
  {2223, 1988, 1938},
  {1992, 2070, 2152},
  {2223, 1989, 1988},
  {2223, 2284, 1989},
  {2153, 1990, 2152},
  {2071, 2154, 1992},
  {1993, 1989, 2072},
  {1989, 2284, 2072},
  {2153, 2155, 1990},
  {1990, 2155, 2074},
  {1996, 2076, 2158},
  {1993, 2072, 2162},
  {1994, 2075, 2159},
  {1994, 2159, 1880},
  {1995, 2163, 2227},
  {1995, 2227, 2076},
  {2158, 2077, 1996},
  {1993, 2162, 2164},
  {2075, 2165, 2159},
  {2075, 1993, 2164},
  {2075, 2231, 2165},
  {1996, 2077, 1881},
  {2001, 2005, 2078},
  {2079, 1881, 2077},
  {2005, 2081, 2078},
  {2168, 1940, 2079},
  {2169, 1998, 2080},
  {2009, 2017, 2167},
  {2007, 1941, 2239},
  {1941, 2168, 2239},
  {2169, 2082, 1998},
  {1998, 2082, 2008},
  {2170, 2240, 1890},
  {2084, 2082, 2169},
  {2170, 1942, 2243},
  {2082, 2084, 1944},
  {2082, 1945, 2014},
  {2018, 2013, 2172},
  {2018, 2172, 2024},
  {1950, 2028, 2025},
  {2172, 2089, 2024},
  {2089, 2085, 1949},
  {2085, 2086, 2087},
  {2087, 2250, 1948},
  {2250, 2088, 1948},
  {2027, 2174, 2022},
  {2028, 1951, 2173},
  {2029, 2177, 2027},
  {1951, 2030, 2173},
  {2030, 2090, 2179},
  {1849, 2180, 2032},
  {2090, 1897, 2092},
  {2090, 2092, 2254},
  {1952, 2031, 2308},
  {2181, 1953, 2375},
  {2258, 2032, 2180},
  {2093, 2092, 1952},
  {2252, 2372, 2094},
  {2376, 2101, 1902},
  {2376, 1902, 2256},
  {2256, 2033, 2258},
  {2252, 2094, 2096},
  {2094, 2095, 2097},
  {2094, 2097, 2096},
  {2094, 2372, 2095},
  {2095, 2098, 2097},
  {2095, 2372, 2098},
  {1900, 1723, 2100},
  {2260, 1793, 2034},
  {1954, 2099, 1953},
  {2261, 2036, 1955},
  {2036, 2261, 2099},
  {2036, 2099, 1954},
  {2035, 2183, 2100},
  {2263, 2105, 2380},
  {2106, 2105, 2037},
  {2100, 2104, 2185},
  {2104, 2103, 2107},
  {2108, 2107, 2103},
  {2103, 2109, 2108},
  {2110, 2108, 2109},
  {2109, 2103, 2187},
  {2109, 2187, 2110},
  {2111, 2104, 2107},
  {2107, 2108, 2112},
  {2113, 2112, 2108},
  {2107, 2112, 2111},
  {2114, 2111, 2112},
  {2108, 2110, 2113},
  {2112, 2113, 2114},
  {2187, 2114, 2113},
  {1904, 2116, 2188},
  {2188, 2115, 1904},
  {2038, 2119, 1957},
  {2119, 2038, 2192},
  {2120, 2117, 2041},
  {2041, 2117, 2190},
  {2041, 2190, 2121},
  {2118, 2192, 2039},
  {2117, 2120, 2190},
  {1961, 2266, 2043},
  {2121, 2195, 1961},
  {1908, 2122, 2042},
  {1908, 1909, 2267},
  {1908, 2267, 2122},
  {2044, 1963, 2045},
  {2044, 2045, 2126},
  {1857, 2124, 1915},
  {2198, 1915, 2124},
  {1913, 2044, 2126},
  {1964, 2129, 2045},
  {2129, 2199, 2045},
  {1969, 1965, 2047},
  {2131, 2269, 1967},
  {1858, 2199, 1916},
  {1971, 2199, 2129},
  {2127, 1917, 2053},
  {1971, 1916, 2199},
  {2129, 2049, 1971},
  {2049, 2130, 2052},
  {1864, 2203, 1919},
  {1920, 2134, 2208},
  {1921, 2136, 2138},
  {1920, 2208, 2055},
  {1973, 1924, 2137},
  {1974, 1976, 2207},
  {2055, 2208, 2057},
  {1924, 2142, 2137},
  {2056, 2400, 1976},
  {2207, 1976, 2400},
  {2277, 2209, 2139},
  {2139, 2141, 2277},
  {2141, 2139, 2059},
  {2141, 2059, 2212},
  {1977, 2211, 2143},
  {1977, 2143, 2062},
  {2063, 1872, 2140},
  {1980, 2062, 2143},
  {2216, 1929, 2063},
  {2212, 1930, 2145},
  {1929, 2217, 2145},
  {2144, 1982, 2218},
  {1982, 2065, 2218},
  {1933, 2147, 2282},
  {2148, 2147, 1984},
  {2146, 2067, 2064},
  {2282, 2220, 1933},
  {2066, 2067, 2219},
  {2151, 2149, 1983},
  {2069, 2417, 1986},
  {2069, 2068, 2352},
  {2222, 1936, 1987},
  {2223, 1986, 2417},
  {2152, 2070, 2490},
  {2070, 1992, 2154},
  {2284, 2157, 2072},
  {1987, 2073, 2286},
  {2156, 2074, 2155},
  {2156, 2224, 2074},
  {2157, 2162, 2072},
  {2162, 2157, 2225},
  {2158, 2226, 2077},
  {2160, 2074, 2224},
  {2159, 2165, 2163},
  {2077, 2226, 2228},
  {2160, 2166, 2074},
  {2225, 2161, 2162},
  {2075, 2164, 2231},
  {2160, 2230, 2166},
  {2077, 2228, 2079},
  {2233, 2079, 2228},
  {2073, 2002, 2291},
  {2168, 2079, 2233},
  {2168, 1941, 1940},
  {2169, 2080, 2237},
  {2238, 1883, 2010},
  {2010, 2007, 2236},
  {2010, 2236, 2238},
  {2007, 2239, 2236},
  {2013, 1883, 2238},
  {1882, 1889, 2240},
  {2243, 2241, 2170},
  {1942, 2171, 2243},
  {2171, 1943, 2244},
  {2084, 2169, 1943},
  {2023, 2178, 2245},
  {2172, 2369, 2089},
  {2028, 2173, 2025},
  {2026, 2175, 2021},
  {2089, 2444, 2085},
  {2085, 2444, 2086},
  {2086, 2444, 2087},
  {2026, 2173, 2175},
  {2175, 2247, 2021},
  {2021, 2176, 2029},
  {2029, 2176, 2177},
  {2174, 2027, 2177},
  {2174, 2249, 2023},
  {2178, 2023, 2249},
  {2250, 2371, 2088},
  {2088, 2371, 2180},
  {2173, 2030, 2179},
  {2179, 2090, 2254},
  {2031, 2091, 2305},
  {2377, 2375, 1953},
  {2254, 2092, 2182},
  {2093, 2182, 2092},
  {2257, 2093, 1952},
  {2252, 2576, 2372},
  {1953, 2099, 2377},
  {2097, 2098, 2096},
  {2309, 2034, 2101},
  {2035, 2513, 2183},
  {2102, 2313, 1956},
  {2262, 1900, 2100},
  {2100, 2183, 2104},
  {2106, 1904, 2312},
  {2103, 2104, 2184},
  {2103, 2184, 2187},
  {2104, 2111, 2185},
  {2111, 2114, 2186},
  {2111, 2186, 2185},
  {1904, 2115, 2312},
  {1956, 2116, 1854},
  {2116, 1956, 2188},
  {2119, 2189, 1957},
  {1957, 2189, 2120},
  {2120, 2193, 2190},
  {2040, 2191, 2118},
  {2120, 2189, 2193},
  {2042, 2457, 2191},
  {2119, 2194, 2189},
  {2189, 2318, 2193},
  {2121, 2190, 2195},
  {2195, 2316, 1961},
  {2194, 2119, 2192},
  {2318, 2189, 2194},
  {2195, 2190, 2193},
  {1909, 2319, 2267},
  {2124, 2046, 2197},
  {2197, 2198, 2124},
  {1915, 2198, 2128},
  {2199, 2126, 2045},
  {2197, 2046, 2127},
  {2387, 2125, 1967},
  {2200, 2127, 2053},
  {2270, 2200, 2053},
  {1966, 2201, 2132},
  {2131, 2051, 2202},
  {2051, 2204, 2202},
  {2133, 2203, 1864},
  {2272, 2274, 2399},
  {2135, 2328, 2204},
  {2135, 1823, 2207},
  {2135, 2207, 2328},
  {2134, 2329, 2208},
  {2137, 2136, 1921},
  {2206, 2205, 2054},
  {2137, 2276, 2275},
  {2136, 2334, 2138},
  {2137, 2142, 2276},
  {2336, 2139, 2209},
  {2210, 2057, 2208},
  {2140, 2057, 2063},
  {2057, 2210, 2063},
  {2141, 2212, 2277},
  {2404, 2058, 2339},
  {2211, 2058, 2404},
  {2213, 2143, 2211},
  {2063, 2210, 2216},
  {1925, 2214, 2061},
  {2061, 2214, 2215},
  {2215, 2142, 2061},
  {2143, 2213, 1980},
  {2214, 1925, 2144},
  {1929, 2216, 2217},
  {2213, 2278, 1980},
  {2144, 2218, 2279},
  {1980, 2345, 2146},
  {2218, 2065, 2149},
  {2146, 2347, 2067},
  {2148, 2066, 2350},
  {1983, 2149, 2065},
  {2412, 2149, 2151},
  {2150, 1936, 2283},
  {2150, 2283, 2280},
  {1936, 2222, 2221},
  {2354, 2155, 2153},
  {2070, 2154, 2490},
  {2222, 1987, 2286},
  {2354, 2156, 2155},
  {2157, 2355, 2225},
  {2071, 2078, 2357},
  {2076, 2227, 2158},
  {2158, 2227, 2226},
  {2162, 2161, 2229},
  {2232, 2163, 2165},
  {2162, 2229, 2164},
  {2231, 2164, 2229},
  {2232, 2227, 2163},
  {2078, 2081, 2288},
  {2229, 2365, 2231},
  {2232, 2165, 2231},
  {2230, 2235, 2166},
  {2230, 2234, 2235},
  {2081, 2009, 2363},
  {2167, 2363, 2009},
  {2080, 2166, 2237},
  {2363, 2167, 2367},
  {2083, 2367, 2167},
  {1882, 2240, 2291},
  {2293, 2291, 2240},
  {2170, 2293, 2240},
  {2293, 2170, 2241},
  {2242, 2238, 2236},
  {2296, 2241, 2243},
  {2244, 1943, 2237},
  {2237, 1943, 2169},
  {2013, 2238, 2298},
  {2013, 2298, 2172},
  {2178, 2441, 2245},
  {2172, 2298, 2369},
  {5897, 2246, 2576},
  {2246, 5897, 2299},
  {2246, 2299, 2576},
  {2173, 2179, 2175},
  {2247, 2176, 2021},
  {2247, 2300, 2176},
  {2177, 2176, 2301},
  {2177, 2248, 2174},
  {2248, 2249, 2174},
  {2444, 2089, 2370},
  {2087, 2444, 2250},
  {5897, 2576, 2252},
  {2251, 2253, 2252},
  {5897, 2252, 2253},
  {2253, 2252, 2251},
  {2305, 2308, 2031},
  {2091, 2181, 2305},
  {2254, 2182, 2304},
  {2093, 2304, 2182},
  {2308, 2257, 1952},
  {2305, 2181, 2306},
  {2376, 2256, 2508},
  {2304, 2093, 2255},
  {2093, 2257, 2307},
  {2310, 1955, 2263},
  {2310, 2261, 1955},
  {2262, 2259, 1900},
  {2262, 2454, 2311},
  {2262, 2100, 2454},
  {2183, 2264, 2184},
  {2183, 2184, 2104},
  {2183, 2454, 2264},
  {2185, 2264, 2454},
  {2188, 2265, 2115},
  {2188, 2314, 2265},
  {2122, 2315, 2042},
  {2122, 2267, 2315},
  {2457, 2317, 2191},
  {2192, 2389, 2194},
  {2193, 2384, 2195},
  {2118, 2385, 2192},
  {2318, 2194, 2389},
  {2123, 2458, 2196},
  {2198, 2197, 2320},
  {2390, 2198, 2386},
  {2196, 2391, 2048},
  {2048, 2391, 2268},
  {2198, 2390, 2128},
  {2268, 2049, 2048},
  {1967, 2269, 2387},
  {2049, 2268, 2130},
  {2128, 2201, 1966},
  {2200, 2270, 2322},
  {2270, 2053, 2054},
  {2202, 2395, 2131},
  {2130, 2324, 2133},
  {2201, 2271, 2132},
  {2271, 2394, 2326},
  {2133, 2393, 2203},
  {2132, 2271, 2326},
  {2132, 2326, 2134},
  {2272, 2394, 2273},
  {2203, 2393, 2398},
  {2134, 2326, 2327},
  {2273, 2274, 2272},
  {2398, 2206, 2203},
  {2325, 2054, 2205},
  {2134, 2327, 2329},
  {2274, 2332, 2330},
  {2274, 2330, 2399},
  {2137, 2275, 2136},
  {2208, 2329, 2335},
  {2274, 2333, 2332},
  {2275, 2276, 2337},
  {2138, 2340, 2056},
  {2338, 2058, 2139},
  {2276, 2142, 2215},
  {2211, 2404, 2475},
  {2211, 2477, 2213},
  {2214, 2343, 2342},
  {2214, 2342, 2215},
  {2216, 2210, 2341},
  {2217, 2216, 2341},
  {2341, 2277, 2217},
  {2277, 2212, 2145},
  {2214, 2144, 2343},
  {2279, 2343, 2144},
  {2145, 2217, 2277},
  {2345, 2347, 2146},
  {2218, 2149, 2346},
  {2412, 2346, 2149},
  {2219, 2350, 2066},
  {2220, 2281, 2068},
  {2151, 2280, 2412},
  {2068, 2281, 2352},
  {2220, 2353, 2281},
  {2220, 2282, 2353},
  {1936, 2221, 2351},
  {1936, 2351, 2283},
  {2152, 2490, 2413},
  {2417, 2422, 2223},
  {2284, 2223, 2422},
  {2156, 2419, 2224},
  {2157, 2284, 2355},
  {2419, 2356, 2224},
  {2154, 2071, 2357},
  {2226, 2696, 2228},
  {2285, 2289, 2161},
  {2285, 2161, 2225},
  {2356, 2287, 2160},
  {2356, 2160, 2224},
  {2362, 2287, 2358},
  {2230, 2287, 2362},
  {2287, 2230, 2160},
  {2288, 2357, 2078},
  {2290, 2227, 2232},
  {2073, 2291, 2360},
  {2289, 2364, 2161},
  {2161, 2364, 2229},
  {2233, 2228, 2496},
  {2365, 2229, 2364},
  {2288, 2081, 2363},
  {2233, 2496, 2292},
  {2233, 2292, 2168},
  {2234, 2294, 2235},
  {2235, 2244, 2166},
  {2237, 2166, 2244},
  {2295, 2293, 2241},
  {2294, 2234, 2296},
  {2294, 2244, 2235},
  {2292, 2239, 2168},
  {2296, 2295, 2241},
  {2243, 2294, 2296},
  {2083, 2023, 2368},
  {2083, 2368, 2367},
  {2438, 2242, 2236},
  {2236, 2239, 2438},
  {2292, 2438, 2239},
  {2294, 2243, 2171},
  {2294, 2171, 2244},
  {2023, 2245, 2368},
  {2238, 2242, 2297},
  {2238, 2297, 2298},
  {2442, 2299, 5897},
  {2299, 2442, 2576},
  {2175, 2179, 2247},
  {2178, 2249, 2446},
  {2441, 2178, 2302},
  {2441, 2302, 2443},
  {2443, 2302, 2447},
  {2370, 2089, 2369},
  {2179, 2300, 2247},
  {2300, 2301, 2176},
  {2177, 2303, 2248},
  {2302, 2178, 2446},
  {2301, 2303, 2177},
  {2303, 2445, 2248},
  {2180, 2373, 2258},
  {2180, 2371, 2373},
  {2777, 2253, 2252},
  {2375, 2306, 2181},
  {2256, 2258, 2508},
  {2255, 2093, 2307},
  {2308, 2509, 2257},
  {2257, 2509, 2307},
  {2252, 2096, 2777},
  {2452, 2096, 2098},
  {2098, 2379, 2452},
  {2259, 2262, 2453},
  {2035, 2260, 2513},
  {2451, 2513, 2260},
  {2102, 2259, 2453},
  {2311, 2453, 2262},
  {2263, 2380, 2310},
  {2102, 2453, 2313},
  {2100, 2185, 2454},
  {2105, 2106, 2381},
  {1956, 2313, 2188},
  {2115, 2265, 2314},
  {2188, 2455, 2314},
  {2521, 2266, 2456},
  {2266, 2521, 2043},
  {2043, 2521, 2123},
  {2042, 2315, 2382},
  {2266, 1961, 2316},
  {2316, 2195, 2384},
  {2317, 2459, 2118},
  {2317, 2118, 2191},
  {2388, 2192, 2385},
  {2192, 2388, 2389},
  {2196, 2458, 2391},
  {2197, 2127, 2320},
  {2387, 2319, 2125},
  {2130, 2268, 2324},
  {2391, 2324, 2268},
  {2322, 2270, 2054},
  {2201, 2392, 2271},
  {2269, 2131, 2323},
  {2271, 2392, 2394},
  {2395, 2323, 2131},
  {2326, 2394, 2272},
  {2326, 2272, 2469},
  {2326, 2469, 2327},
  {2204, 2328, 2202},
  {2469, 2272, 2399},
  {2401, 2205, 2206},
  {2401, 2468, 2205},
  {2325, 2205, 2468},
  {2333, 2274, 2470},
  {2328, 2207, 2400},
  {2331, 2136, 2275},
  {2136, 2331, 2334},
  {2338, 2330, 2332},
  {2338, 2399, 2330},
  {2275, 2337, 2331},
  {2209, 2402, 2336},
  {2399, 2338, 2336},
  {2276, 2403, 2337},
  {2208, 2335, 2210},
  {2336, 2338, 2139},
  {2138, 2334, 2340},
  {2341, 2210, 2335},
  {2335, 2209, 2341},
  {2339, 2338, 2332},
  {2400, 2056, 2340},
  {2277, 2341, 2209},
  {2403, 2276, 2215},
  {2338, 2339, 2058},
  {2213, 2405, 2278},
  {2213, 2477, 2405},
  {2345, 2278, 2405},
  {2343, 2279, 2344},
  {2278, 2345, 1980},
  {2345, 2406, 2347},
  {2409, 2279, 2218},
  {2218, 2346, 2409},
  {2348, 2282, 2147},
  {2147, 2148, 2348},
  {2350, 2348, 2148},
  {2067, 2347, 2219},
  {2280, 2349, 2412},
  {2282, 2348, 2418},
  {2348, 2350, 2488},
  {2348, 2488, 2418},
  {2350, 2483, 2488},
  {2283, 2486, 2280},
  {2485, 2153, 2152},
  {2152, 2413, 2485},
  {2069, 2352, 2417},
  {2352, 2281, 2416},
  {2281, 2353, 2416},
  {2282, 2418, 2353},
  {2221, 2222, 2423},
  {2485, 2415, 2153},
  {2354, 2153, 2415},
  {2419, 2156, 2354},
  {2422, 2424, 2284},
  {2222, 2286, 2423},
  {2285, 2420, 2425},
  {2421, 2285, 2225},
  {2355, 2284, 2424},
  {2154, 2357, 2493},
  {2425, 2289, 2285},
  {2226, 2426, 2696},
  {2286, 2073, 2360},
  {2287, 2356, 2358},
  {2289, 2425, 2361},
  {2227, 2290, 2226},
  {2359, 2431, 2358},
  {2362, 2358, 2431},
  {2289, 2361, 2364},
  {2232, 2430, 2290},
  {2291, 2293, 2429},
  {2366, 2362, 2431},
  {2365, 2364, 2498},
  {2365, 2433, 2231},
  {2231, 2433, 2232},
  {2366, 2431, 2293},
  {2230, 2362, 2366},
  {2295, 2366, 2293},
  {2366, 2295, 2230},
  {2296, 2230, 2295},
  {2230, 2296, 2234},
  {2242, 2438, 2437},
  {2245, 2500, 2368},
  {2245, 2441, 2500},
  {2298, 2297, 2501},
  {2248, 2445, 2249},
  {2179, 2254, 2300},
  {2445, 2303, 2448},
  {2444, 2504, 2250},
  {2250, 2504, 2371},
  {2777, 5897, 2253},
  {2304, 2300, 2254},
  {2308, 2305, 2450},
  {2305, 2306, 2450},
  {2101, 2376, 2309},
  {2304, 2255, 2374},
  {2307, 2374, 2255},
  {2306, 2375, 2583},
  {2377, 2099, 2378},
  {2034, 2309, 2451},
  {2034, 2451, 2260},
  {2099, 2261, 2378},
  {2310, 2514, 2261},
  {2105, 2381, 2515},
  {2380, 2105, 2589},
  {2105, 2515, 2589},
  {2312, 2115, 2591},
  {2313, 2455, 2188},
  {2115, 2314, 2591},
  {2383, 2456, 2266},
  {2123, 2521, 2527},
  {2383, 2266, 2316},
  {2383, 2316, 2384},
  {2123, 2527, 2458},
  {2267, 2319, 2599},
  {2118, 2459, 2385},
  {2385, 2459, 2524},
  {2193, 2460, 2384},
  {2198, 2320, 2386},
  {2387, 2528, 2319},
  {2193, 2318, 2460},
  {2322, 2386, 2320},
  {2127, 2200, 2320},
  {2320, 2200, 2322},
  {2463, 2529, 2386},
  {2322, 2321, 2386},
  {2386, 2321, 2463},
  {2201, 2128, 2390},
  {2201, 2390, 2392},
  {2321, 2396, 2463},
  {2393, 2133, 2324},
  {2322, 2466, 2321},
  {2396, 2321, 2466},
  {2054, 2397, 2322},
  {2202, 2465, 2395},
  {2054, 2325, 2397},
  {2394, 2464, 2273},
  {2464, 2274, 2273},
  {2470, 2274, 2467},
  {2398, 2401, 2206},
  {2329, 2327, 2469},
  {2402, 2329, 2469},
  {2402, 2399, 2336},
  {2332, 2333, 2474},
  {2209, 2335, 2329},
  {2329, 2402, 2209},
  {2331, 2337, 2540},
  {2339, 2332, 2474},
  {2474, 2404, 2339},
  {2400, 2340, 2541},
  {2404, 2474, 2475},
  {2403, 2215, 2342},
  {2343, 2547, 2342},
  {2475, 2477, 2211},
  {2343, 2344, 2479},
  {2479, 2344, 2279},
  {2405, 2406, 2345},
  {2407, 2478, 2480},
  {2409, 2479, 2279},
  {2409, 2346, 2549},
  {2482, 2408, 2407},
  {2407, 2410, 2478},
  {2484, 2478, 2410},
  {2408, 2483, 2407},
  {2410, 2219, 2484},
  {2407, 2483, 2410},
  {2408, 2488, 2483},
  {2219, 2347, 2484},
  {2221, 2414, 2351},
  {2352, 2492, 2417},
  {2421, 2225, 2553},
  {2553, 2225, 2355},
  {2418, 2487, 2353},
  {2420, 2285, 2421},
  {2417, 2492, 2422},
  {2154, 2493, 2490},
  {2355, 2424, 2554},
  {2424, 2422, 2633},
  {2494, 2423, 2286},
  {2556, 2359, 2358},
  {2286, 2360, 2494},
  {2358, 2356, 2556},
  {2288, 2428, 2357},
  {2226, 2290, 2426},
  {2429, 2494, 2360},
  {2494, 2429, 2427},
  {2428, 2288, 2432},
  {2290, 2430, 2426},
  {2360, 2291, 2429},
  {2427, 2431, 2359},
  {2431, 2429, 2293},
  {2429, 2431, 2427},
  {2363, 2432, 2288},
  {2495, 2428, 2435},
  {2428, 2432, 2435},
  {2363, 2435, 2432},
  {2498, 2364, 2361},
  {2496, 2497, 2292},
  {2435, 2363, 2434},
  {2363, 2367, 2434},
  {2569, 2365, 2498},
  {2433, 2365, 2569},
  {2434, 2436, 2435},
  {2434, 2367, 2436},
  {2497, 2438, 2292},
  {2435, 2439, 2641},
  {2367, 2368, 2436},
  {2436, 2440, 2439},
  {2436, 2439, 2435},
  {2436, 2368, 2440},
  {2297, 2242, 2437},
  {2439, 2643, 2641},
  {2297, 2437, 2501},
  {2439, 2502, 2643},
  {2439, 2440, 2502},
  {2572, 2502, 2440},
  {5897, 2777, 2442},
  {2300, 2304, 2301},
  {2371, 2504, 2577},
  {2301, 2505, 2448},
  {2301, 2448, 2303},
  {2446, 2249, 2445},
  {2446, 2447, 2302},
  {2447, 2503, 2443},
  {2505, 2301, 2304},
  {2448, 2578, 2445},
  {2374, 2505, 2304},
  {2309, 2376, 2581},
  {2258, 2650, 2655},
  {2258, 2373, 2650},
  {2505, 2374, 2449},
  {2374, 2307, 2509},
  {2374, 2509, 2449},
  {2306, 2583, 2450},
  {2378, 2507, 2377},
  {2379, 2098, 2372},
  {2450, 2583, 2510},
  {2583, 2375, 2507},
  {2378, 2261, 2512},
  {2379, 2586, 2452},
  {2661, 2311, 2454},
  {2311, 2588, 2453},
  {2106, 2312, 2381},
  {2381, 2312, 2667},
  {2381, 2667, 2515},
  {2380, 2589, 2664},
  {2738, 2456, 2383},
  {2315, 2517, 2382},
  {2516, 2518, 2525},
  {2042, 2382, 2457},
  {2519, 2383, 2523},
  {2384, 2523, 2383},
  {2523, 2384, 2460},
  {2317, 2457, 2459},
  {2267, 2599, 2315},
  {2386, 2392, 2390},
  {2386, 2529, 2461},
  {2386, 2461, 2392},
  {2387, 2269, 2601},
  {2391, 2600, 2324},
  {2269, 2323, 2601},
  {2461, 2462, 2394},
  {2461, 2529, 2462},
  {2392, 2461, 2394},
  {2394, 2462, 2464},
  {2462, 2671, 2464},
  {2324, 2530, 2393},
  {2322, 2397, 2466},
  {2530, 2398, 2393},
  {2530, 2533, 2398},
  {2466, 2604, 2396},
  {2274, 2673, 2467},
  {2398, 2603, 2401},
  {2471, 2333, 2470},
  {2400, 2605, 2328},
  {2399, 2402, 2469},
  {2615, 2331, 2540},
  {2471, 2472, 2333},
  {2474, 2333, 2472},
  {2471, 2543, 2472},
  {2331, 2473, 2334},
  {2475, 2474, 2472},
  {2403, 2476, 2337},
  {2677, 2334, 2473},
  {2403, 2342, 2476},
  {2547, 2476, 2342},
  {2478, 2548, 2480},
  {2480, 2482, 2407},
  {2478, 2481, 2548},
  {2478, 2484, 2481},
  {2479, 2409, 2549},
  {2408, 2482, 2625},
  {2408, 2625, 2550},
  {2408, 2550, 2411},
  {2412, 2626, 2346},
  {2411, 2550, 2686},
  {2410, 2483, 2219},
  {2412, 2349, 2486},
  {2551, 2415, 2485},
  {2686, 2487, 2411},
  {2483, 2350, 2219},
  {2414, 2221, 2627},
  {2280, 2486, 2349},
  {2418, 2411, 2487},
  {2552, 2627, 2221},
  {2351, 2414, 2628},
  {2351, 2628, 2283},
  {2551, 2354, 2415},
  {2411, 2418, 2408},
  {2408, 2418, 2488},
  {2221, 2423, 2552},
  {2419, 2551, 2489},
  {2551, 2419, 2354},
  {2554, 2553, 2355},
  {2416, 2491, 2352},
  {2555, 2352, 2491},
  {2416, 2353, 2487},
  {2356, 2419, 2556},
  {2489, 2556, 2419},
  {2629, 2631, 2420},
  {2425, 2420, 2631},
  {2422, 2492, 2561},
  {2555, 2492, 2352},
  {2556, 2560, 2359},
  {2631, 2558, 2425},
  {2559, 2359, 2560},
  {2494, 2427, 2634},
  {2559, 2427, 2359},
  {2562, 2493, 2428},
  {2493, 2357, 2428},
  {2565, 2425, 2564},
  {2430, 2637, 2426},
  {2228, 2696, 2496},
  {2425, 2565, 2361},
  {2567, 2361, 2565},
  {2498, 2361, 2567},
  {2430, 2232, 2568},
  {2638, 2497, 2496},
  {2495, 2435, 2566},
  {2571, 2438, 2499},
  {2438, 2497, 2499},
  {2638, 2499, 2497},
  {2437, 2438, 2571},
  {2571, 2642, 2437},
  {2500, 2440, 2368},
  {2501, 2437, 2642},
  {2440, 2500, 2572},
  {2298, 2573, 2369},
  {2576, 2442, 2847},
  {2847, 2502, 2572},
  {2370, 2369, 2573},
  {2573, 2574, 2370},
  {2370, 2574, 2575},
  {2370, 2575, 2444},
  {2503, 2447, 2651},
  {2578, 2448, 2505},
  {2445, 2578, 2446},
  {2580, 2651, 2447},
  {2373, 2371, 2577},
  {2373, 2577, 2650},
  {2578, 2579, 2446},
  {2375, 2377, 2507},
  {2449, 2509, 2506},
  {2509, 2308, 2511},
  {2510, 2308, 2450},
  {2511, 2506, 2509},
  {2308, 2510, 2582},
  {2649, 2096, 2452},
  {2309, 2585, 2451},
  {2512, 2584, 2378},
  {2379, 2730, 2787},
  {2452, 2586, 2652},
  {2587, 2512, 2261},
  {2261, 2514, 2587},
  {2310, 2664, 2514},
  {2380, 2664, 2310},
  {2454, 2183, 2513},
  {2513, 2666, 2454},
  {2453, 2588, 2455},
  {2453, 2455, 2313},
  {2591, 2314, 2455},
  {2517, 2315, 2794},
  {2518, 2595, 2525},
  {2597, 2525, 2595},
  {2519, 2738, 2383},
  {2456, 2594, 2521},
  {2525, 2597, 2520},
  {2737, 2519, 2523},
  {2737, 2523, 2596},
  {2382, 2668, 2457},
  {2596, 2523, 2526},
  {2520, 2526, 2525},
  {2520, 2522, 2526},
  {2460, 2526, 2523},
  {2389, 2525, 2526},
  {2457, 2524, 2459},
  {2524, 2516, 2385},
  {2388, 2385, 2516},
  {2516, 2525, 2388},
  {2528, 2599, 2319},
  {2389, 2388, 2525},
  {2389, 2526, 2318},
  {2526, 2460, 2318},
  {2601, 2528, 2387},
  {2600, 2391, 2458},
  {2531, 2529, 2463},
  {2529, 2671, 2462},
  {2530, 2324, 2600},
  {2396, 2536, 2463},
  {2463, 2536, 2531},
  {2323, 2395, 2602},
  {2395, 2465, 2602},
  {2536, 2532, 2531},
  {2465, 2202, 2534},
  {2464, 2673, 2274},
  {2534, 2202, 2537},
  {2533, 2603, 2398},
  {2397, 2604, 2466},
  {2604, 2535, 2396},
  {2396, 2535, 2536},
  {2537, 2202, 2328},
  {2604, 2397, 2325},
  {2537, 2328, 2605},
  {2538, 2401, 2603},
  {2535, 2609, 2536},
  {2605, 2400, 2607},
  {2609, 2535, 2539},
  {2538, 2613, 2401},
  {2401, 2613, 2468},
  {2539, 2604, 2545},
  {2542, 2539, 2545},
  {2471, 2612, 2543},
  {2544, 2540, 2337},
  {2543, 2475, 2472},
  {2331, 2615, 2473},
  {2545, 2618, 2542},
  {2337, 2476, 2544},
  {2545, 2620, 2618},
  {2475, 2543, 2546},
  {2334, 2677, 2340},
  {2475, 2546, 2477},
  {2477, 2546, 2622},
  {2622, 2405, 2477},
  {2547, 2343, 2479},
  {2548, 2682, 2480},
  {2481, 2405, 2548},
  {2406, 2405, 2481},
  {2549, 2346, 2624},
  {2346, 2626, 2624},
  {2481, 2484, 2347},
  {2481, 2347, 2406},
  {2485, 2685, 2551},
  {2486, 2626, 2412},
  {2485, 2413, 2685},
  {2761, 2487, 2686},
  {2627, 2688, 2414},
  {2486, 2283, 2628},
  {2489, 2551, 2684},
  {2413, 2490, 2762},
  {2553, 2690, 2421},
  {2553, 2554, 2691},
  {2487, 2491, 2416},
  {2489, 2630, 2556},
  {2490, 2632, 2762},
  {2490, 2493, 2632},
  {2423, 2557, 2552},
  {2562, 2632, 2493},
  {2633, 2554, 2424},
  {2423, 2494, 2634},
  {2427, 2559, 2634},
  {2428, 2563, 2562},
  {2695, 2426, 2637},
  {2563, 2428, 2495},
  {2433, 2639, 2232},
  {2232, 2639, 2568},
  {2641, 2566, 2435},
  {2433, 2569, 2639},
  {2499, 2638, 2570},
  {2499, 2570, 2640},
  {2502, 2847, 2643},
  {2572, 2500, 2441},
  {2298, 2501, 2573},
  {2847, 2442, 2775},
  {2575, 2574, 2644},
  {2717, 2576, 2847},
  {2575, 2714, 2444},
  {2714, 2504, 2444},
  {2443, 2503, 2713},
  {2505, 2449, 2578},
  {2506, 2578, 2449},
  {2446, 2580, 2447},
  {2508, 2581, 2376},
  {2372, 2730, 2379},
  {2446, 2579, 2580},
  {2580, 2653, 2651},
  {2581, 2654, 2309},
  {2583, 2507, 2584},
  {2508, 2258, 2655},
  {2777, 2096, 2649},
  {2657, 2506, 2656},
  {2506, 2511, 2656},
  {2511, 2308, 2582},
  {2584, 2507, 2378},
  {2309, 2654, 2585},
  {2582, 2658, 2511},
  {2512, 2587, 2584},
  {2586, 2379, 2660},
  {2379, 2787, 2660},
  {2735, 2588, 2311},
  {2311, 2661, 2735},
  {2663, 2513, 2451},
  {2513, 2663, 2666},
  {2665, 2661, 2454},
  {2590, 2667, 2312},
  {2588, 2662, 2455},
  {2589, 2515, 2791},
  {2312, 2591, 2590},
  {2455, 2662, 2591},
  {2929, 2665, 2454},
  {2793, 2593, 2517},
  {2668, 2593, 2592},
  {2668, 2517, 2593},
  {2516, 2668, 2592},
  {2519, 2669, 2738},
  {2382, 2517, 2668},
  {2595, 2518, 2597},
  {2522, 2520, 2598},
  {2598, 2670, 2522},
  {2526, 2522, 2670},
  {2670, 2596, 2526},
  {2516, 2524, 2668},
  {2315, 2599, 2794},
  {2668, 2524, 2457},
  {2458, 2527, 2799},
  {2528, 2601, 2864},
  {2799, 2600, 2458},
  {2600, 2746, 2530},
  {2533, 2530, 2746},
  {2529, 2531, 2671},
  {2671, 2673, 2464},
  {2323, 2602, 2747},
  {2602, 2465, 2868},
  {2604, 2539, 2535},
  {2603, 2749, 2538},
  {2608, 2325, 2468},
  {2325, 2608, 2604},
  {2606, 2536, 2609},
  {2536, 2606, 2532},
  {5901, 2471, 2470},
  {2608, 2468, 2613},
  {2608, 2545, 2604},
  {2609, 2611, 2606},
  {2471, 2610, 2612},
  {5901, 2610, 2471},
  {2607, 2400, 2541},
  {2614, 2608, 2613},
  {2608, 2614, 2545},
  {2539, 2542, 2609},
  {2611, 2609, 2542},
  {2544, 2615, 2540},
  {2677, 2751, 2541},
  {2613, 2949, 2614},
  {2542, 2616, 2611},
  {2543, 2612, 2617},
  {2542, 2618, 2616},
  {2543, 2617, 2546},
  {2473, 2615, 2954},
  {2541, 2340, 2677},
  {2545, 2614, 2883},
  {2544, 2476, 2678},
  {2618, 2620, 2679},
  {2476, 2547, 2619},
  {2476, 2619, 2678},
  {2617, 2753, 2621},
  {2617, 2621, 2546},
  {2546, 2621, 2622},
  {2547, 2681, 2619},
  {2681, 2547, 2479},
  {2682, 2548, 2623},
  {2624, 2681, 2549},
  {2759, 2550, 2625},
  {2685, 2758, 2551},
  {2414, 2688, 2628},
  {2626, 2486, 2628},
  {2684, 2687, 2489},
  {2489, 2687, 2890},
  {2491, 2487, 2761},
  {2489, 2890, 2630},
  {2420, 2421, 2629},
  {2421, 2690, 2629},
  {2553, 2691, 2690},
  {2761, 2555, 2491},
  {2693, 2556, 2630},
  {2556, 2693, 2560},
  {2552, 2557, 2694},
  {2559, 2560, 2693},
  {2554, 2633, 2692},
  {5898, 2692, 2633},
  {2557, 2423, 2634},
  {2694, 2557, 2634},
  {2562, 2635, 2632},
  {2633, 2422, 5898},
  {2561, 5898, 2422},
  {2563, 2635, 2562},
  {2558, 2836, 2636},
  {2426, 2695, 2696},
  {2558, 2636, 2425},
  {2425, 2636, 2564},
  {2638, 2496, 2696},
  {2563, 2495, 2839},
  {2565, 2698, 2567},
  {2569, 2701, 2639},
  {2499, 2640, 2703},
  {2640, 2570, 2700},
  {2570, 2638, 2700},
  {2702, 2569, 2498},
  {2571, 2499, 2703},
  {2642, 2710, 2501},
  {2501, 2710, 2573},
  {2775, 2643, 2847},
  {2777, 2711, 2442},
  {2572, 2441, 2713},
  {2573, 2644, 2574},
  {2714, 2575, 2716},
  {2577, 2504, 2714},
  {2717, 2572, 2719},
  {2645, 2725, 2716},
  {2716, 2725, 2646},
  {2714, 2646, 2647},
  {2577, 2714, 2647},
  {2646, 2648, 2647},
  {2372, 2726, 2730},
  {2503, 2651, 2779},
  {2578, 2506, 2728},
  {2578, 2728, 2579},
  {2506, 2657, 2728},
  {2581, 2508, 2729},
  {2782, 2653, 2580},
  {2729, 2508, 2731},
  {2508, 2655, 2731},
  {2652, 2649, 2452},
  {2656, 2511, 2658},
  {2582, 2510, 2659},
  {2582, 2659, 2658},
  {2510, 2583, 2659},
  {2583, 2584, 2659},
  {2663, 2451, 2585},
  {2734, 2662, 2588},
  {2514, 2927, 2587},
  {2515, 2667, 2791},
  {2788, 2590, 2591},
  {2662, 2788, 2591},
  {2454, 2666, 2929},
  {2593, 2861, 2592},
  {2519, 2737, 2669},
  {2456, 2863, 2594},
  {2521, 2594, 2739},
  {2518, 2795, 2597},
  {2520, 2740, 2598},
  {2598, 2740, 2670},
  {2597, 2795, 2520},
  {2740, 2520, 2795},
  {2742, 2669, 2737},
  {2521, 2739, 2527},
  {2799, 2527, 2797},
  {2745, 2601, 2323},
  {2745, 2323, 2747},
  {2531, 2532, 2671},
  {2672, 2868, 2465},
  {2534, 2672, 2465},
  {2673, 2810, 2467},
  {2534, 2537, 2748},
  {2605, 2748, 2537},
  {2532, 2606, 2674},
  {2606, 2750, 2674},
  {2606, 2611, 2750},
  {2750, 2611, 2676},
  {2607, 2541, 2751},
  {2615, 2675, 2817},
  {2676, 2611, 2616},
  {2544, 2675, 2615},
  {2949, 2883, 2614},
  {2544, 2678, 2818},
  {2473, 2954, 2677},
  {2618, 2679, 2616},
  {2753, 2680, 2621},
  {2621, 2680, 2622},
  {2622, 2548, 2405},
  {2619, 2681, 2756},
  {2620, 2884, 2679},
  {2622, 2680, 2755},
  {2623, 2622, 2755},
  {2623, 2548, 2622},
  {2480, 2682, 2821},
  {2480, 2821, 2482},
  {2681, 2479, 2549},
  {2683, 2551, 2758},
  {2684, 2551, 2683},
  {2550, 2759, 2686},
  {2760, 2626, 2628},
  {2685, 2413, 2689},
  {2413, 2762, 2689},
  {2627, 2552, 2830},
  {2763, 2555, 2761},
  {2629, 2894, 2631},
  {2631, 2834, 2558},
  {2694, 2634, 2764},
  {2634, 2559, 2765},
  {2558, 2834, 2836},
  {2697, 2636, 2836},
  {2636, 2697, 2564},
  {2564, 2697, 2698},
  {2564, 2698, 2565},
  {2430, 2568, 2637},
  {2637, 2568, 2767},
  {2495, 2566, 2839},
  {2566, 2842, 2839},
  {2638, 2696, 2700},
  {2567, 2698, 2768},
  {2639, 2699, 2568},
  {2639, 2701, 2699},
  {2568, 2699, 2767},
  {2567, 2768, 2498},
  {2769, 2498, 2768},
  {2498, 2769, 2702},
  {2569, 2702, 2701},
  {2641, 2842, 2566},
  {2571, 2703, 2844},
  {2705, 2704, 2708},
  {2705, 2708, 2706},
  {2704, 2707, 2708},
  {2709, 2707, 2704},
  {2707, 2709, 2708},
  {2642, 2844, 2710},
  {2642, 2571, 2844},
  {2706, 2708, 2711},
  {2708, 2914, 2711},
  {2774, 2711, 2914},
  {2845, 2641, 2643},
  {2711, 2777, 2706},
  {2710, 2712, 2573},
  {2644, 2573, 2712},
  {2711, 2775, 2442},
  {2776, 2644, 2712},
  {2443, 2713, 2441},
  {2847, 2572, 2717},
  {2713, 2719, 2572},
  {2850, 2645, 2776},
  {2716, 2646, 2714},
  {2717, 2719, 2718},
  {2719, 2713, 2715},
  {2713, 2503, 2715},
  {2576, 2717, 2720},
  {2576, 2720, 2372},
  {2719, 2722, 2718},
  {2718, 2722, 2723},
  {2718, 2723, 2721},
  {2372, 2720, 2726},
  {2717, 2718, 2722},
  {2718, 2722, 2723},
  {2723, 2721, 2718},
  {2724, 2725, 2645},
  {2724, 2991, 2725},
  {2725, 2648, 2646},
  {2577, 2647, 2650},
  {2648, 2725, 2727},
  {2648, 2727, 2647},
  {2854, 2780, 2647},
  {2649, 2652, 3044},
  {2653, 2783, 2651},
  {2779, 2651, 2783},
  {2654, 2581, 2729},
  {2782, 2580, 2579},
  {2783, 2653, 2995},
  {2729, 2731, 2919},
  {2655, 2650, 2918},
  {2657, 2656, 2784},
  {2587, 2785, 2584},
  {2656, 2658, 2784},
  {2732, 2784, 2658},
  {2663, 2585, 2654},
  {2652, 2586, 2786},
  {2927, 3051, 2587},
  {2734, 2788, 2662},
  {2514, 2664, 2789},
  {2663, 5899, 2666},
  {2664, 2589, 2736},
  {2589, 2791, 2736},
  {2517, 2794, 2793},
  {2518, 2516, 2937},
  {2670, 2740, 2596},
  {2738, 2863, 2456},
  {2737, 2596, 2741},
  {2737, 2741, 2742},
  {2738, 2798, 2863},
  {2740, 2741, 2596},
  {2669, 2742, 2738},
  {2740, 2795, 2865},
  {2742, 2743, 2738},
  {2599, 2528, 2864},
  {2740, 2744, 2741},
  {2741, 2744, 2742},
  {2742, 2744, 2743},
  {2746, 2600, 2799},
  {2864, 2601, 2745},
  {2804, 2533, 2746},
  {2867, 2747, 2602},
  {2868, 2867, 2602},
  {2748, 2868, 2672},
  {2674, 2671, 2532},
  {2672, 2534, 2748},
  {2603, 2533, 2808},
  {2603, 2808, 2749},
  {2810, 2674, 2750},
  {2605, 2607, 2811},
  {2752, 2810, 2750},
  {2676, 2752, 2750},
  {2610, 5901, 2612},
  {2816, 2612, 5901},
  {5901, 2879, 2816},
  {2818, 2877, 2675},
  {2676, 2819, 2752},
  {2675, 2544, 2818},
  {2545, 2883, 2620},
  {2616, 2819, 2676},
  {2678, 2619, 2756},
  {2679, 2754, 2616},
  {2819, 2616, 2754},
  {2755, 2680, 2682},
  {2682, 2680, 2886},
  {2755, 2682, 2623},
  {2821, 2682, 2886},
  {2681, 2624, 2757},
  {2681, 2757, 2887},
  {2758, 2685, 2822},
  {3028, 2684, 2683},
  {2684, 3028, 2687},
  {2825, 2688, 2627},
  {2823, 2626, 2760},
  {2830, 2825, 2627},
  {2685, 2689, 2889},
  {2828, 2761, 2686},
  {2693, 2630, 2829},
  {2896, 2629, 2690},
  {2690, 2691, 2972},
  {2691, 2554, 2831},
  {2694, 2830, 2552},
  {2829, 2895, 2693},
  {2635, 2762, 2632},
  {2554, 2692, 2977},
  {2554, 2977, 2831},
  {2559, 2693, 2765},
  {2895, 2765, 2693},
  {2764, 2634, 2765},
  {2635, 2563, 2766},
  {2839, 2766, 2563},
  {2903, 2695, 2637},
  {2697, 2837, 2698},
  {2836, 2906, 2697},
  {2699, 2983, 2767},
  {2840, 2640, 2700},
  {2640, 2840, 2843},
  {2640, 2843, 2703},
  {2842, 2641, 2845},
  {2705, 2770, 2704},
  {2771, 2704, 2770},
  {2705, 2706, 2772},
  {2705, 2772, 2770},
  {2704, 2771, 2709},
  {2773, 2709, 2771},
  {2709, 2773, 2708},
  {2914, 2708, 2773},
  {2706, 2990, 2772},
  {2774, 2775, 2711},
  {2774, 2845, 2775},
  {2710, 2846, 2712},
  {2990, 2706, 2777},
  {2712, 2846, 2776},
  {2645, 2644, 2776},
  {2644, 2645, 2575},
  {2716, 2575, 2645},
  {2778, 2724, 2850},
  {2645, 2850, 2724},
  {2503, 2779, 2715},
  {2778, 2991, 2724},
  {2722, 2719, 2720},
  {2779, 2720, 2719},
  {2719, 2715, 2779},
  {2726, 2855, 2730},
  {2727, 2854, 2647},
  {2647, 2780, 2650},
  {2728, 2781, 2579},
  {2731, 2655, 2918},
  {3044, 2652, 2921},
  {2728, 2657, 2781},
  {2653, 2782, 2995},
  {2652, 2786, 2921},
  {2658, 2858, 2732},
  {2658, 2659, 2858},
  {2659, 2733, 2858},
  {2659, 2584, 2733},
  {2733, 2584, 2785},
  {2733, 2785, 2925},
  {2784, 2732, 2922},
  {2734, 2588, 2926},
  {2926, 2588, 2735},
  {2654, 2857, 2663},
  {2860, 2663, 2857},
  {5899, 2663, 2860},
  {2661, 2665, 2928},
  {2664, 2999, 2789},
  {2590, 2788, 2790},
  {2790, 2791, 2667},
  {2590, 2790, 2667},
  {2792, 2593, 2793},
  {2593, 2792, 2861},
  {2592, 2862, 2516},
  {2793, 2794, 3001},
  {2516, 2862, 2937},
  {2518, 2937, 2795},
  {2863, 3004, 2594},
  {2739, 2797, 2527},
  {2795, 2937, 2796},
  {2738, 2743, 2798},
  {2743, 2866, 2798},
  {2743, 2801, 2866},
  {2744, 2801, 2743},
  {2805, 2802, 2800},
  {2744, 2943, 2801},
  {2746, 2802, 2804},
  {2804, 2802, 2805},
  {2805, 2803, 2806},
  {2871, 2806, 2803},
  {2807, 2804, 2805},
  {2807, 2533, 2804},
  {2870, 2805, 2806},
  {2871, 2870, 2806},
  {2808, 2533, 2807},
  {2807, 2805, 2808},
  {2671, 2674, 2673},
  {2810, 2673, 2674},
  {2809, 2808, 2805},
  {2805, 2870, 2809},
  {2809, 2749, 2808},
  {2811, 2872, 2748},
  {2749, 2809, 2812},
  {2811, 2748, 2605},
  {2751, 2811, 2607},
  {2749, 2812, 2538},
  {2810, 2814, 2813},
  {2810, 2752, 2814},
  {2814, 2950, 2813},
  {2538, 2815, 2613},
  {2818, 2876, 2877},
  {2612, 2816, 2617},
  {2879, 2951, 2816},
  {2877, 2817, 2675},
  {2752, 2955, 2814},
  {2816, 2951, 2881},
  {2816, 2881, 2617},
  {2617, 2881, 2956},
  {2617, 2956, 2753},
  {2884, 2620, 2883},
  {2886, 2680, 2753},
  {2678, 2756, 2818},
  {2679, 2958, 2820},
  {2679, 2820, 2754},
  {2756, 2681, 2887},
  {2757, 2962, 2887},
  {2482, 2821, 2625},
  {2683, 2758, 2961},
  {2758, 2822, 2961},
  {2624, 2626, 2823},
  {2888, 2759, 2966},
  {2759, 2888, 2824},
  {2688, 2826, 2827},
  {2827, 2760, 2688},
  {2628, 2688, 2760},
  {2760, 2827, 2823},
  {2686, 2759, 2828},
  {2759, 2824, 2828},
  {2891, 2761, 2828},
  {2890, 2829, 2630},
  {2629, 2896, 2894},
  {2690, 2972, 2896},
  {5902, 2762, 2635},
  {2832, 2766, 2833},
  {2696, 2695, 2903},
  {2637, 2838, 2903},
  {2697, 2906, 2837},
  {2837, 2906, 2907},
  {2698, 2837, 2841},
  {2637, 2767, 2838},
  {2698, 2841, 2768},
  {2910, 2983, 2699},
  {2700, 2908, 2840},
  {2700, 2696, 2908},
  {2699, 2701, 2912},
  {2699, 2912, 2910},
  {2987, 2702, 2769},
  {2702, 2987, 2701},
  {2909, 2842, 2774},
  {2844, 2703, 2843},
  {2770, 2772, 2990},
  {2770, 2990, 2771},
  {2771, 2990, 2914},
  {2771, 2914, 2773},
  {2710, 2844, 2846},
  {2842, 2845, 2774},
  {2845, 2643, 2775},
  {2846, 2913, 2776},
  {2848, 2776, 2913},
  {2848, 2849, 2776},
  {2849, 2850, 2776},
  {2717, 2722, 2720},
  {2720, 2779, 2851},
  {2852, 2779, 2783},
  {2726, 2720, 2851},
  {2779, 2852, 2851},
  {2855, 2726, 2851},
  {2853, 2855, 2851},
  {2915, 2853, 2851},
  {2725, 2916, 2727},
  {2780, 3106, 2650},
  {2650, 3106, 2918},
  {2657, 2784, 2781},
  {2781, 2856, 2579},
  {2579, 2856, 2782},
  {2782, 2856, 2995},
  {2729, 2857, 2654},
  {2852, 2783, 2995},
  {2922, 2732, 2923},
  {2732, 2858, 2859},
  {2732, 2859, 2923},
  {2858, 2924, 2859},
  {2858, 2733, 2924},
  {2785, 2587, 3051},
  {3053, 3052, 2660},
  {2660, 2787, 3053},
  {2735, 2661, 2928},
  {2927, 2514, 2789},
  {2665, 2929, 2928},
  {2664, 2736, 2999},
  {2861, 3002, 2592},
  {2862, 2592, 3002},
  {3001, 2794, 2935},
  {2794, 2599, 2935},
  {2594, 3004, 2739},
  {2739, 2936, 2797},
  {2739, 3004, 2936},
  {2796, 3062, 2795},
  {2797, 2938, 2799},
  {2599, 2864, 3005},
  {2795, 3062, 2865},
  {2865, 3009, 2740},
  {3008, 2800, 3007},
  {2800, 2802, 3007},
  {2740, 3064, 2943},
  {2740, 2943, 2744},
  {2746, 2799, 2802},
  {2745, 2747, 3010},
  {2801, 2943, 2866},
  {2803, 3013, 2871},
  {2747, 2867, 3010},
  {2868, 2748, 2869},
  {2871, 2946, 2870},
  {2871, 3013, 2945},
  {2872, 2869, 2748},
  {2945, 2946, 2871},
  {2873, 2809, 2870},
  {2946, 2873, 2870},
  {2873, 2812, 2809},
  {2812, 2873, 2815},
  {2874, 2810, 2813},
  {2815, 2538, 2812},
  {5901, 2874, 2813},
  {2811, 2751, 2947},
  {2875, 2813, 2950},
  {2813, 2875, 5901},
  {2878, 2815, 2873},
  {2613, 2815, 2878},
  {2878, 2949, 2613},
  {2818, 2952, 2876},
  {2751, 2882, 2947},
  {2817, 2954, 2615},
  {2751, 2677, 2882},
  {2949, 2953, 2883},
  {2884, 2883, 2880},
  {2677, 2954, 2882},
  {2753, 2956, 2957},
  {2885, 2818, 2756},
  {2884, 2958, 2679},
  {2886, 2753, 2957},
  {2819, 2754, 2959},
  {2754, 2820, 2959},
  {2756, 2887, 2885},
  {2962, 2960, 2887},
  {2963, 2625, 2821},
  {2624, 2962, 2757},
  {2759, 2625, 2963},
  {2823, 2965, 2962},
  {2962, 2624, 2823},
  {2826, 2688, 2825},
  {3027, 2827, 2826},
  {2965, 2823, 2827},
  {2822, 2685, 2889},
  {3028, 2890, 2687},
  {2892, 2828, 2824},
  {2824, 2968, 2892},
  {2970, 2892, 2968},
  {2892, 2891, 2828},
  {2976, 2689, 2762},
  {2974, 2825, 2830},
  {2834, 2631, 2893},
  {2894, 2893, 2631},
  {2834, 2893, 3032},
  {2894, 2896, 3029},
  {2972, 3029, 2896},
  {2763, 2761, 2891},
  {2830, 2694, 2974},
  {2764, 2979, 2694},
  {3035, 2765, 2895},
  {3090, 2832, 2833},
  {2832, 3036, 5902},
  {2832, 5902, 2766},
  {2834, 3089, 2836},
  {2898, 2897, 2899},
  {3090, 2833, 5903},
  {2901, 5903, 2833},
  {2899, 2898, 2897},
  {2833, 2766, 2901},
  {3089, 3038, 2836},
  {2902, 2905, 5903},
  {2901, 2766, 2839},
  {2901, 2839, 2902},
  {2837, 2904, 2981},
  {2837, 2981, 2841},
  {2696, 2903, 2908},
  {2902, 2839, 2905},
  {2837, 2907, 2904},
  {2767, 2982, 2838},
  {2839, 2842, 2905},
  {2907, 2906, 2980},
  {2982, 2767, 2983},
  {2906, 2985, 2980},
  {2905, 2842, 2909},
  {2769, 2768, 2911},
  {3040, 2911, 2768},
  {2769, 2911, 2987},
  {2912, 2701, 2987},
  {3040, 2768, 2841},
  {2844, 2988, 2913},
  {2844, 2843, 2988},
  {2774, 2914, 2909},
  {2913, 2846, 2844},
  {2913, 2849, 2848},
  {2990, 2777, 3044},
  {3104, 2991, 2778},
  {2777, 2649, 3044},
  {2851, 2852, 2915},
  {2725, 2991, 2916},
  {2854, 3106, 2780},
  {2853, 2917, 2993},
  {2853, 2993, 2855},
  {3044, 2921, 3048},
  {2781, 2994, 2856},
  {2855, 2993, 2730},
  {2784, 2994, 2781},
  {2729, 3050, 2857},
  {2730, 2993, 2920},
  {2787, 2730, 2920},
  {2784, 2922, 2994},
  {2859, 2924, 2997},
  {2733, 2925, 2924},
  {2785, 3051, 2925},
  {2734, 2926, 3177},
  {2786, 3175, 2921},
  {2786, 2586, 3231},
  {2586, 2660, 3231},
  {2928, 2926, 2735},
  {2734, 3054, 2788},
  {2789, 3056, 2927},
  {2790, 2788, 3117},
  {2736, 3119, 2999},
  {2736, 2791, 3119},
  {3118, 3119, 2791},
  {2930, 2931, 2932},
  {5900, 2932, 2931},
  {2930, 2932, 2933},
  {2934, 2933, 2932},
  {2930, 2933, 3296},
  {2930, 3296, 2931},
  {2932, 5900, 2934},
  {3296, 2934, 5900},
  {2861, 2792, 2793},
  {3000, 2861, 2793},
  {3001, 3000, 2793},
  {2862, 3002, 3003},
  {3005, 2935, 2599},
  {2863, 3061, 3004},
  {2798, 3061, 2863},
  {2798, 2939, 3061},
  {2864, 2940, 3006},
  {2800, 2941, 2805},
  {2800, 3008, 2941},
  {2940, 2864, 2745},
  {2940, 2745, 3010},
  {2866, 2939, 2798},
  {2799, 3007, 2802},
  {2941, 2803, 2805},
  {2941, 3013, 2803},
  {2867, 2868, 2942},
  {3013, 2944, 2945},
  {2869, 2872, 3014},
  {2872, 2811, 3070},
  {2873, 2946, 3017},
  {3018, 2946, 2945},
  {2873, 3017, 2878},
  {2878, 3017, 2949},
  {2948, 3074, 2880},
  {2875, 2950, 3075},
  {2948, 2880, 2953},
  {2876, 2952, 3019},
  {2876, 3019, 2877},
  {2877, 3019, 2817},
  {2814, 2955, 2950},
  {2951, 3077, 2881},
  {2883, 2953, 2880},
  {2880, 3078, 2884},
  {2881, 3077, 2956},
  {2952, 2818, 2885},
  {2752, 3021, 2955},
  {2819, 3021, 2752},
  {2885, 3023, 3020},
  {2820, 3142, 2959},
  {2885, 2887, 3023},
  {2759, 2963, 2966},
  {2888, 2968, 2824},
  {2826, 2825, 2967},
  {2826, 2967, 2964},
  {2965, 2827, 3027},
  {2968, 3265, 2970},
  {3153, 2970, 3265},
  {3029, 2972, 2971},
  {2973, 2971, 2972},
  {2971, 2973, 3086},
  {2689, 2976, 2889},
  {3086, 2977, 2969},
  {2892, 2970, 2978},
  {2975, 2974, 2694},
  {2895, 3031, 3035},
  {5902, 2976, 2762},
  {2972, 2691, 2973},
  {2831, 2973, 2691},
  {2973, 2831, 3086},
  {2977, 3086, 2831},
  {2969, 2977, 3033},
  {2978, 2891, 2892},
  {3035, 2979, 2764},
  {3037, 5902, 3036},
  {2900, 2977, 5898},
  {2891, 2978, 2763},
  {2897, 2763, 2978},
  {2899, 2897, 2978},
  {2764, 2765, 3035},
  {2900, 2835, 2897},
  {5903, 2901, 2902},
  {2904, 2907, 2980},
  {3092, 2905, 2909},
  {2983, 2910, 3096},
  {2906, 3093, 2984},
  {2906, 2984, 2985},
  {2840, 2908, 2986},
  {2840, 2986, 3041},
  {2985, 2984, 3101},
  {2841, 2981, 3040},
  {2911, 3040, 3164},
  {2988, 2843, 3041},
  {2843, 2840, 3041},
  {3043, 2913, 2988},
  {2990, 3042, 2914},
  {2913, 2989, 2849},
  {2989, 2778, 2850},
  {2850, 2849, 2989},
  {3045, 2992, 2915},
  {2992, 3107, 2853},
  {2853, 2915, 2992},
  {3046, 2727, 2916},
  {2854, 2727, 3046},
  {2853, 3107, 2917},
  {3111, 2915, 2852},
  {2917, 3107, 2993},
  {2731, 3047, 2919},
  {2731, 2918, 3047},
  {2729, 2919, 2996},
  {2856, 2994, 2995},
  {2729, 2996, 3050},
  {2859, 2997, 2923},
  {2924, 3051, 2997},
  {2924, 2925, 3051},
  {2734, 3177, 3054},
  {2660, 3052, 3231},
  {2857, 3055, 2860},
  {2922, 2923, 3114},
  {2923, 2998, 3114},
  {3058, 5899, 2860},
  {2999, 3056, 2789},
  {2928, 2929, 3057},
  {2791, 2790, 3118},
  {2933, 2934, 3296},
  {2935, 3059, 3001},
  {2862, 3003, 2937},
  {2936, 2938, 2797},
  {2935, 3005, 3060},
  {2937, 3003, 3062},
  {2796, 2937, 3062},
  {3005, 2864, 3006},
  {2938, 3007, 2799},
  {2865, 3124, 3009},
  {3010, 3242, 2940},
  {2740, 3009, 3064},
  {3064, 3011, 2943},
  {2867, 2942, 3012},
  {2942, 2868, 3012},
  {2868, 3014, 3128},
  {2868, 2869, 3014},
  {2941, 3069, 3015},
  {2941, 3015, 3013},
  {2945, 2944, 3016},
  {2945, 3016, 3018},
  {2811, 2947, 3070},
  {2946, 3018, 3017},
  {3016, 3135, 3018},
  {3017, 3018, 2948},
  {3018, 3135, 2948},
  {3074, 2948, 3135},
  {2953, 2949, 3017},
  {3017, 2948, 2953},
  {3076, 2950, 2955},
  {2954, 2817, 3019},
  {2882, 2954, 3019},
  {3074, 3078, 2880},
  {3140, 3076, 2955},
  {2956, 3077, 2957},
  {2952, 2885, 3020},
  {3022, 3021, 2819},
  {3079, 2886, 2957},
  {2958, 3139, 2820},
  {2819, 2959, 3022},
  {3142, 3022, 2959},
  {2960, 3023, 2887},
  {2886, 3079, 3024},
  {3081, 3080, 2960},
  {2886, 3024, 2821},
  {2963, 2821, 3024},
  {2962, 3081, 2960},
  {2961, 3025, 2683},
  {2822, 3082, 2961},
  {2962, 2965, 3026},
  {3025, 3028, 2683},
  {2963, 3148, 2966},
  {2964, 3027, 2826},
  {2964, 3083, 3027},
  {2964, 2967, 3154},
  {3028, 3150, 2890},
  {2822, 2889, 3084},
  {2968, 3085, 3265},
  {3150, 2829, 2890},
  {3150, 3087, 2829},
  {3029, 3156, 2894},
  {3151, 2969, 3264},
  {3264, 3033, 3030},
  {2967, 2825, 3157},
  {2895, 2829, 3031},
  {2893, 2894, 3032},
  {2969, 3033, 3264},
  {3030, 2900, 3034},
  {3153, 2978, 2970},
  {2825, 2974, 3157},
  {2975, 2694, 2979},
  {2832, 3090, 3036},
  {3033, 2900, 3030},
  {2900, 2897, 3034},
  {2977, 2900, 3033},
  {2897, 2899, 3034},
  {2978, 3034, 2899},
  {3038, 3091, 2836},
  {2905, 3039, 5903},
  {3039, 2905, 3092},
  {2904, 2980, 2981},
  {2838, 3095, 2903},
  {2903, 3095, 2908},
  {3097, 2908, 3095},
  {2982, 3280, 2838},
  {2980, 2985, 3213},
  {3161, 2982, 2983},
  {3092, 2909, 2914},
  {2981, 3215, 3040},
  {2912, 3099, 3096},
  {2912, 3096, 2910},
  {2986, 2908, 3097},
  {3093, 3162, 2984},
  {2911, 3164, 2987},
  {2987, 3099, 2912},
  {2914, 3042, 3279},
  {3162, 3100, 2984},
  {2984, 3100, 3101},
  {2913, 3043, 2989},
  {2989, 3043, 3166},
  {2990, 3044, 3103},
  {2915, 3112, 3045},
  {2992, 3045, 3107},
  {2854, 3109, 3106},
  {2915, 3111, 3112},
  {2854, 3046, 3109},
  {3049, 2993, 3107},
  {2919, 3047, 3229},
  {2995, 3111, 2852},
  {2993, 3049, 2920},
  {2922, 3113, 2994},
  {2994, 3113, 2995},
  {2857, 3050, 3055},
  {3175, 3048, 2921},
  {2923, 2997, 2998},
  {2786, 3231, 3175},
  {3058, 2860, 3055},
  {3116, 2998, 3115},
  {2788, 3402, 3117},
  {2928, 3057, 2926},
  {2929, 2931, 3120},
  {2929, 3120, 3057},
  {2931, 3121, 3120},
  {2931, 3296, 3121},
  {2861, 3000, 3002},
  {3002, 3180, 3003},
  {2936, 3238, 2938},
  {2935, 3060, 3059},
  {3003, 3123, 3062},
  {2939, 3063, 3183},
  {3007, 3182, 3008},
  {2940, 3242, 3006},
  {3125, 3006, 3242},
  {3067, 2939, 2866},
  {2939, 3067, 3063},
  {3008, 3066, 2941},
  {3064, 3065, 3011},
  {3126, 3011, 3065},
  {3011, 3126, 2943},
  {3069, 2941, 3066},
  {3010, 2867, 3185},
  {3012, 3185, 2867},
  {3127, 2866, 2943},
  {3127, 3067, 2866},
  {3012, 2868, 3185},
  {3128, 3185, 2868},
  {3013, 3068, 2944},
  {3131, 3069, 3066},
  {3016, 2944, 3130},
  {3069, 3248, 3015},
  {2872, 3187, 3014},
  {3069, 3131, 3248},
  {3133, 3015, 3248},
  {3071, 3072, 3134},
  {3072, 3071, 3019},
  {2947, 3073, 3132},
  {3072, 3019, 2952},
  {3072, 2952, 3137},
  {3071, 3073, 3019},
  {3073, 2882, 3019},
  {3073, 2947, 2882},
  {3078, 3074, 3307},
  {3078, 3139, 2884},
  {2952, 3020, 3138},
  {2958, 2884, 3139},
  {2955, 3021, 3140},
  {2957, 3077, 3079},
  {3077, 3141, 3079},
  {3020, 3023, 3197},
  {3021, 3022, 3198},
  {3023, 2960, 3080},
  {3145, 2963, 3024},
  {2962, 3026, 3081},
  {3147, 3081, 3026},
  {2961, 3082, 3025},
  {2963, 3145, 3148},
  {3154, 3083, 2964},
  {3147, 3027, 3083},
  {3027, 3026, 2965},
  {3027, 3147, 3026},
  {3084, 3082, 2822},
  {2966, 3149, 2888},
  {3085, 2888, 3149},
  {2888, 3085, 2968},
  {3086, 2969, 3271},
  {3264, 3030, 3205},
  {3034, 3205, 3030},
  {3152, 3205, 3034},
  {3157, 3154, 2967},
  {3087, 3031, 2829},
  {3273, 3156, 3029},
  {3029, 2971, 3273},
  {3153, 3034, 2978},
  {3210, 2834, 3032},
  {3037, 3088, 5902},
  {2976, 5902, 3088},
  {3088, 2889, 2976},
  {2974, 2975, 3157},
  {3158, 3157, 2975},
  {2975, 2979, 3158},
  {2979, 3035, 3158},
  {3031, 3158, 3035},
  {2834, 3210, 3089},
  {3211, 3090, 5903},
  {2836, 3091, 2906},
  {3091, 3093, 2906},
  {2980, 3213, 3094},
  {2980, 3094, 2981},
  {2838, 3280, 3095},
  {2985, 3101, 3098},
  {2986, 3219, 3041},
  {3101, 3102, 3216},
  {3100, 3102, 3101},
  {3165, 3102, 3218},
  {2989, 3104, 2778},
  {3223, 2991, 3104},
  {2991, 3105, 2916},
  {3168, 3107, 3045},
  {3045, 3284, 3168},
  {3046, 2916, 3286},
  {3047, 2918, 3106},
  {3107, 3108, 3110},
  {3107, 3110, 3049},
  {3049, 3110, 3169},
  {2995, 3113, 3111},
  {3050, 2996, 3229},
  {2996, 2919, 3229},
  {3049, 3169, 3228},
  {2920, 3049, 3228},
  {2920, 3228, 2787},
  {2787, 3228, 3053},
  {2922, 3114, 3113},
  {2997, 3115, 2998},
  {2997, 3051, 3174},
  {2997, 3174, 3115},
  {3051, 2927, 3176},
  {3055, 3178, 3058},
  {3114, 2998, 3116},
  {2788, 3054, 3402},
  {2926, 3057, 3177},
  {2790, 3117, 3118},
  {3058, 3296, 5900},
  {3180, 3002, 3179},
  {3062, 3236, 3122},
  {3182, 2938, 3238},
  {3123, 3236, 3062},
  {3004, 3061, 2936},
  {3062, 3122, 3124},
  {3005, 3298, 3060},
  {3124, 2865, 3062},
  {2939, 3183, 3061},
  {2938, 3182, 3007},
  {3006, 3125, 3005},
  {3298, 3005, 3125},
  {3009, 3124, 3064},
  {3124, 3126, 3064},
  {3008, 3182, 3184},
  {3008, 3184, 3066},
  {3063, 3129, 3183},
  {3064, 3126, 3065},
  {3063, 3245, 3129},
  {3010, 3185, 3242},
  {3063, 3067, 3245},
  {2944, 3068, 3130},
  {3066, 3184, 3131},
  {3014, 3187, 3244},
  {3015, 3133, 3013},
  {3013, 3191, 3068},
  {3133, 3191, 3013},
  {3070, 2947, 3132},
  {3070, 3132, 3187},
  {3137, 3134, 3072},
  {3136, 3071, 3306},
  {3136, 3304, 3073},
  {3073, 3071, 3136},
  {2950, 3076, 3075},
  {3193, 3075, 3076},
  {3137, 2952, 3195},
  {3139, 3078, 3307},
  {3141, 3077, 3194},
  {2952, 3138, 3195},
  {3197, 3138, 3020},
  {3199, 3140, 3021},
  {3199, 3021, 3198},
  {3079, 3141, 3143},
  {3023, 3080, 3197},
  {3144, 3197, 3080},
  {3139, 3142, 2820},
  {3022, 3142, 3256},
  {3079, 3143, 3145},
  {3144, 3080, 3081},
  {3079, 3145, 3024},
  {3144, 3081, 3259},
  {3083, 3154, 3146},
  {3025, 3204, 3028},
  {3082, 3084, 3203},
  {3028, 3204, 3150},
  {2969, 3151, 3271},
  {3034, 3153, 3152},
  {3155, 3158, 3031},
  {3031, 3087, 3263},
  {3031, 3263, 3155},
  {3087, 3150, 3263},
  {3273, 2971, 3274},
  {2889, 3088, 3084},
  {3032, 3207, 3210},
  {3032, 2894, 3156},
  {3032, 3156, 3207},
  {3036, 3208, 3037},
  {3090, 3208, 3036},
  {3089, 3210, 3038},
  {3038, 3277, 3091},
  {3091, 3212, 3093},
  {3159, 3160, 3278},
  {3214, 3160, 3096},
  {3160, 3159, 3096},
  {2983, 3096, 3159},
  {2983, 3159, 3161},
  {3092, 2914, 3279},
  {3215, 2981, 3094},
  {3164, 3040, 3215},
  {3214, 3096, 3099},
  {2987, 3164, 3163},
  {2987, 3163, 3099},
  {2986, 3097, 3219},
  {3100, 3162, 3281},
  {2988, 5904, 3043},
  {2988, 3041, 5904},
  {3100, 3218, 3102},
  {2990, 3103, 3217},
  {3102, 3165, 3220},
  {3166, 3104, 2989},
  {3166, 3043, 5904},
  {3044, 3388, 3103},
  {3223, 3105, 2991},
  {3105, 3224, 2916},
  {3285, 3106, 3109},
  {3044, 3048, 3167},
  {3107, 3168, 3108},
  {2916, 3224, 3286},
  {3109, 3046, 3286},
  {3225, 3110, 3108},
  {3047, 3288, 3229},
  {3045, 3112, 3171},
  {3170, 3112, 3290},
  {3112, 3170, 3171},
  {3172, 3171, 3170},
  {3173, 3113, 3114},
  {3112, 3113, 3173},
  {3290, 3227, 3170},
  {3172, 3170, 3227},
  {3229, 3055, 3050},
  {3114, 3116, 3232},
  {3115, 3174, 3291},
  {3115, 3291, 3116},
  {2927, 3056, 3176},
  {3233, 3058, 3178},
  {3056, 3234, 3176},
  {3233, 3294, 3058},
  {3118, 3295, 3119},
  {3118, 3235, 3295},
  {3000, 3179, 3002},
  {3349, 3001, 3059},
  {3349, 3059, 3351},
  {3059, 3237, 3351},
  {2936, 3061, 3238},
  {3122, 3181, 3124},
  {3061, 3183, 3238},
  {3240, 3238, 3183},
  {3124, 3239, 3126},
  {3183, 3129, 3240},
  {3126, 3241, 2943},
  {3128, 3300, 3185},
  {3240, 3129, 3186},
  {3068, 3246, 3130},
  {3189, 3184, 3243},
  {3245, 3190, 3129},
  {3247, 3016, 3130},
  {3070, 3187, 2872},
  {3188, 3186, 3129},
  {3184, 3192, 3131},
  {3184, 3189, 3192},
  {3129, 3190, 3188},
  {3192, 3363, 3131},
  {3187, 3132, 3304},
  {3189, 3249, 3192},
  {3016, 3247, 3135},
  {3131, 3363, 3248},
  {3073, 3304, 3132},
  {3071, 3134, 3306},
  {3136, 3306, 3304},
  {2951, 3075, 3193},
  {3077, 3251, 3194},
  {3252, 3142, 3139},
  {3139, 3307, 3252},
  {3141, 3194, 3196},
  {3141, 3196, 3200},
  {3196, 3312, 3200},
  {3256, 3198, 3022},
  {3141, 3200, 3143},
  {3200, 3312, 3316},
  {3260, 3146, 3364},
  {3147, 3083, 3146},
  {3146, 3201, 3147},
  {3146, 3260, 3201},
  {3259, 3147, 3201},
  {3081, 3147, 3259},
  {3082, 3202, 3025},
  {3148, 3145, 3143},
  {3203, 3202, 3082},
  {3261, 3204, 3025},
  {2966, 3148, 3149},
  {3262, 3149, 3148},
  {3149, 3262, 3085},
  {3206, 3146, 3154},
  {3205, 3152, 3434},
  {3267, 3265, 3085},
  {3268, 3265, 3267},
  {2971, 3086, 3274},
  {3154, 3157, 3206},
  {3158, 3155, 3276},
  {3272, 3084, 3088},
  {3157, 3158, 3276},
  {3037, 3208, 3209},
  {3037, 3209, 3088},
  {3088, 3209, 3272},
  {3210, 3277, 3038},
  {3091, 3277, 3212},
  {3039, 3092, 3326},
  {3092, 3279, 3326},
  {3159, 3327, 3161},
  {3093, 3377, 3162},
  {2985, 3098, 3213},
  {3213, 3331, 3094},
  {3161, 3280, 2982},
  {3214, 3099, 3163},
  {3098, 3101, 3216},
  {3098, 3216, 3213},
  {3094, 3331, 3215},
  {3331, 3164, 3215},
  {3218, 3100, 3281},
  {3042, 2990, 3217},
  {3220, 3216, 3102},
  {3165, 3218, 3222},
  {3165, 3221, 3220},
  {3382, 3220, 3221},
  {3104, 3283, 3223},
  {3166, 3283, 3104},
  {3165, 3222, 3221},
  {3389, 3105, 3223},
  {3388, 3044, 3167},
  {3171, 3284, 3045},
  {3105, 3389, 3391},
  {3105, 3391, 3224},
  {3285, 3047, 3106},
  {3167, 3048, 3336},
  {3337, 3225, 3108},
  {3171, 3172, 3284},
  {3110, 3225, 3169},
  {3169, 3287, 3226},
  {3169, 3226, 3228},
  {3113, 3112, 3111},
  {3231, 3052, 3399},
  {3053, 3228, 3226},
  {3053, 3226, 3052},
  {3114, 3232, 3173},
  {3174, 3051, 3230},
  {3174, 3230, 3291},
  {3230, 3051, 3176},
  {3055, 3229, 3292},
  {3052, 3226, 3289},
  {3055, 3292, 3178},
  {3117, 3402, 3235},
  {3177, 3057, 3293},
  {3291, 3232, 3116},
  {2999, 3119, 3056},
  {3056, 3119, 3234},
  {3118, 3117, 3235},
  {3348, 3293, 3057},
  {3296, 3058, 3294},
  {3057, 3120, 3348},
  {3120, 3121, 3348},
  {3001, 3179, 3000},
  {3001, 3349, 3179},
  {3122, 3406, 3181},
  {3462, 3237, 3297},
  {3124, 3181, 3239},
  {3126, 3239, 3241},
  {3241, 3355, 2943},
  {3185, 3300, 3410},
  {3128, 3244, 3468},
  {3128, 3468, 3300},
  {3128, 3014, 3244},
  {3127, 3355, 3299},
  {3127, 3299, 3067},
  {3246, 3356, 3130},
  {3244, 3357, 3468},
  {3244, 3187, 3413},
  {3186, 3189, 3243},
  {3130, 3411, 3247},
  {3188, 3249, 3186},
  {3186, 3249, 3189},
  {3245, 3358, 3190},
  {3246, 3068, 3191},
  {3358, 3301, 3190},
  {3191, 3133, 3362},
  {3190, 3301, 3188},
  {3302, 3188, 3301},
  {3249, 3188, 3302},
  {3248, 3362, 3133},
  {3137, 3303, 3134},
  {3250, 3248, 3363},
  {3074, 3135, 3307},
  {3251, 3077, 3193},
  {3473, 3303, 3137},
  {3306, 3134, 3303},
  {3193, 3254, 3251},
  {3137, 3195, 3308},
  {3195, 3138, 3308},
  {3253, 3076, 3140},
  {3076, 3253, 3193},
  {3255, 3194, 3251},
  {3309, 3308, 3138},
  {3193, 3253, 3254},
  {3253, 3140, 3257},
  {3253, 3257, 3254},
  {3251, 3254, 3255},
  {3138, 3197, 3309},
  {3197, 3144, 3309},
  {3199, 3314, 3140},
  {3140, 3314, 3257},
  {3256, 3313, 3198},
  {3198, 3366, 3199},
  {3199, 3366, 3314},
  {3257, 3258, 3254},
  {3254, 3258, 3255},
  {3257, 3315, 3258},
  {3143, 3200, 3316},
  {3201, 3317, 3259},
  {3202, 3423, 3025},
  {3143, 3316, 3148},
  {3261, 3484, 3204},
  {3150, 3204, 3484},
  {3148, 3316, 3262},
  {3085, 3262, 3320},
  {3263, 3150, 3484},
  {3203, 3084, 3272},
  {3320, 3267, 3085},
  {3155, 3263, 3270},
  {3324, 3266, 3265},
  {3267, 3269, 3268},
  {3270, 3276, 3155},
  {3274, 3086, 3275},
  {3322, 3324, 3265},
  {3265, 3268, 3322},
  {3269, 3322, 3268},
  {3206, 3157, 3276},
  {3207, 3156, 3372},
  {3207, 3437, 3210},
  {3436, 3210, 3437},
  {3325, 3208, 3090},
  {3090, 3211, 3325},
  {3442, 3325, 3211},
  {3326, 3211, 3039},
  {3278, 3160, 3378},
  {3327, 3280, 3161},
  {3378, 3160, 3214},
  {3159, 3278, 3327},
  {3326, 3279, 3328},
  {3213, 3446, 3331},
  {3278, 3329, 3327},
  {3095, 3500, 3097},
  {3279, 3042, 3328},
  {3216, 3445, 3213},
  {3163, 3164, 3330},
  {3328, 3042, 3217},
  {3216, 3220, 3445},
  {3164, 3331, 3330},
  {3282, 3219, 3332},
  {3219, 3097, 3332},
  {3282, 3333, 5904},
  {5904, 3219, 3282},
  {3384, 3283, 3166},
  {3384, 3166, 5904},
  {3103, 3383, 3217},
  {3222, 3385, 3221},
  {3221, 3385, 3334},
  {3335, 3103, 3388},
  {3223, 3505, 3389},
  {3168, 3390, 3108},
  {3337, 3108, 3390},
  {3225, 3392, 3169},
  {3225, 3337, 3392},
  {3396, 3109, 3286},
  {3287, 3169, 3392},
  {3289, 3226, 3287},
  {3290, 3112, 3173},
  {3227, 3398, 3172},
  {3284, 3172, 3398},
  {3342, 3229, 3288},
  {3399, 3341, 3231},
  {3173, 3232, 3290},
  {3175, 3231, 3341},
  {3052, 3289, 3399},
  {3291, 3230, 3343},
  {3402, 3054, 3177},
  {3232, 3403, 3290},
  {3176, 3234, 3401},
  {3232, 3346, 3403},
  {3232, 3291, 3346},
  {3119, 3405, 3234},
  {3119, 3295, 3347},
  {3236, 3406, 3122},
  {3408, 3179, 3349},
  {3180, 3179, 3408},
  {3462, 3521, 3237},
  {3353, 3236, 3123},
  {3298, 3297, 3237},
  {3237, 3059, 3298},
  {3060, 3298, 3059},
  {3353, 3003, 3180},
  {3003, 3353, 3123},
  {3238, 3240, 3182},
  {3240, 3243, 3182},
  {3409, 3125, 3242},
  {3239, 3582, 3241},
  {3355, 3241, 3582},
  {3182, 3243, 3184},
  {3242, 3410, 3409},
  {3240, 3186, 3243},
  {3242, 3185, 3410},
  {2943, 3355, 3127},
  {3130, 3356, 3411},
  {3358, 3245, 3067},
  {3191, 3360, 3246},
  {3187, 3304, 3359},
  {3191, 3362, 3360},
  {3247, 3361, 3135},
  {3302, 3534, 3249},
  {3250, 3305, 3248},
  {3250, 3363, 3305},
  {3249, 3474, 3192},
  {3311, 3194, 3255},
  {3194, 3311, 3196},
  {3312, 3196, 3311},
  {3310, 3309, 3144},
  {3313, 3366, 3198},
  {3310, 3144, 3259},
  {3366, 3546, 3314},
  {3314, 3315, 3257},
  {3315, 3421, 3258},
  {3255, 3258, 3311},
  {3317, 3260, 3364},
  {3201, 3260, 3317},
  {3367, 3315, 3314},
  {3421, 3315, 3367},
  {3364, 3146, 3318},
  {3025, 3423, 3261},
  {3319, 3423, 3202},
  {3202, 3203, 3319},
  {3370, 3319, 3203},
  {3318, 3146, 3369},
  {3203, 3272, 3370},
  {3146, 3206, 3369},
  {3432, 3369, 3206},
  {3431, 3270, 3263},
  {3264, 3323, 3151},
  {3494, 3264, 3205},
  {3205, 3434, 3433},
  {3205, 3433, 3494},
  {3321, 3434, 3152},
  {3152, 3153, 3321},
  {3553, 3321, 3153},
  {3153, 3265, 3553},
  {3322, 3269, 3267},
  {3432, 3206, 3276},
  {3276, 3270, 3371},
  {3431, 3371, 3270},
  {3086, 3271, 3275},
  {3323, 3271, 3151},
  {3156, 3273, 3373},
  {3156, 3373, 3372},
  {3273, 3274, 3493},
  {3274, 3275, 3440},
  {3211, 3376, 3442},
  {3277, 3375, 3212},
  {3212, 3375, 3377},
  {3093, 3212, 3377},
  {3278, 3378, 3329},
  {3328, 3217, 3501},
  {3162, 3443, 3281},
  {3163, 3330, 3214},
  {3095, 3280, 3500},
  {3329, 3378, 3499},
  {3332, 3500, 3282},
  {3381, 3218, 3281},
  {3452, 3333, 3282},
  {3500, 3452, 3282},
  {3218, 3381, 3222},
  {3384, 5904, 3333},
  {3453, 3222, 3381},
  {3220, 3382, 3448},
  {3383, 3103, 3335},
  {3453, 3385, 3222},
  {3386, 3221, 3334},
  {3221, 3386, 3382},
  {3386, 3334, 3385},
  {3223, 3283, 3505},
  {3563, 3335, 3388},
  {3336, 3388, 3167},
  {3168, 3284, 3390},
  {3284, 3338, 3390},
  {3284, 3398, 3338},
  {3391, 3286, 3224},
  {3109, 3396, 3285},
  {3339, 3287, 3392},
  {3047, 3285, 3506},
  {3048, 3175, 3394},
  {3396, 3286, 3397},
  {3287, 3339, 3340},
  {3287, 3340, 3289},
  {3227, 3457, 3398},
  {3340, 3399, 3289},
  {3229, 3342, 3292},
  {3175, 3341, 3507},
  {3403, 3227, 3290},
  {3344, 3343, 3230},
  {3230, 3345, 3344},
  {3401, 3345, 3230},
  {3230, 3176, 3401},
  {3400, 3233, 3178},
  {3178, 3292, 3400},
  {3343, 3404, 3291},
  {3234, 3405, 3401},
  {3119, 3347, 3405},
  {3293, 3348, 3515},
  {3294, 3459, 3296},
  {3347, 3295, 3460},
  {3295, 3235, 3460},
  {3351, 3237, 3521},
  {3297, 3298, 3350},
  {3298, 3409, 3350},
  {3181, 3354, 3239},
  {3181, 3352, 3354},
  {3298, 3125, 3409},
  {3299, 3412, 3067},
  {3244, 3413, 3357},
  {3358, 3067, 3412},
  {3187, 3359, 3413},
  {3358, 3596, 3301},
  {3359, 3304, 3470},
  {3361, 3471, 3135},
  {3301, 3596, 3302},
  {3362, 3248, 3414},
  {3471, 3307, 3135},
  {3305, 3415, 3248},
  {3305, 3363, 3415},
  {3303, 3416, 3306},
  {3306, 3470, 3304},
  {3472, 3419, 3307},
  {3306, 3416, 3470},
  {3420, 3309, 3310},
  {3310, 3259, 3420},
  {3313, 3256, 3476},
  {3317, 3364, 3365},
  {3365, 3478, 3317},
  {3259, 3317, 3478},
  {3423, 3319, 3603},
  {3367, 3426, 3421},
  {3483, 3364, 3318},
  {3320, 3262, 3316},
  {3316, 3368, 3320},
  {3318, 3369, 3483},
  {3319, 3370, 3605},
  {3263, 3484, 3431},
  {3320, 3368, 3267},
  {3267, 3368, 3322},
  {3324, 3322, 3368},
  {3271, 3323, 3374},
  {3321, 3553, 3434},
  {3324, 3491, 3266},
  {3435, 3272, 3209},
  {3207, 3372, 3437},
  {3275, 3271, 3374},
  {3374, 3323, 3438},
  {3323, 3264, 3438},
  {3325, 3439, 3208},
  {3277, 3210, 3436},
  {3211, 3326, 3376},
  {3328, 3498, 3376},
  {3376, 3326, 3328},
  {3377, 3443, 3162},
  {3214, 3379, 3444},
  {3214, 3444, 3378},
  {3280, 3327, 3500},
  {3330, 3379, 3214},
  {3327, 3329, 3500},
  {3329, 3499, 3380},
  {3379, 3330, 3331},
  {3097, 3500, 3332},
  {3329, 3380, 3449},
  {3448, 3445, 3220},
  {3283, 3384, 3505},
  {3385, 3387, 3386},
  {3390, 3637, 3337},
  {3391, 3395, 3286},
  {3048, 3394, 3336},
  {3392, 3393, 3339},
  {3286, 3395, 3570},
  {3286, 3570, 3397},
  {3047, 3506, 3288},
  {3399, 3340, 3339},
  {3507, 3341, 3455},
  {3573, 3343, 3344},
  {3344, 3345, 3640},
  {3344, 3640, 3573},
  {3511, 3233, 3400},
  {3342, 3400, 3292},
  {3404, 3346, 3291},
  {3177, 3293, 3574},
  {3458, 3346, 3404},
  {3458, 3403, 3346},
  {3459, 3294, 3233},
  {3516, 3296, 3459},
  {3347, 3460, 3578},
  {3348, 3121, 3517},
  {3121, 3296, 3517},
  {3516, 3517, 3296},
  {3461, 3523, 3236},
  {3236, 3523, 3406},
  {3461, 3236, 3463},
  {3236, 3353, 3463},
  {3406, 3352, 3181},
  {3463, 3353, 3180},
  {3350, 3409, 3407},
  {3406, 3465, 3352},
  {3354, 3352, 3527},
  {3239, 3354, 3582},
  {3299, 3355, 3584},
  {3247, 3587, 3590},
  {3247, 3590, 3361},
  {3362, 3594, 3360},
  {3361, 3590, 3471},
  {3414, 3594, 3362},
  {3415, 3414, 3248},
  {3474, 3249, 3534},
  {3593, 3192, 3474},
  {3192, 3593, 3363},
  {3473, 3137, 3417},
  {3417, 3137, 3308},
  {3418, 3417, 3308},
  {3419, 3252, 3307},
  {3308, 3309, 3418},
  {3252, 3419, 3142},
  {3142, 3419, 3476},
  {3142, 3476, 3256},
  {3478, 3420, 3259},
  {3311, 3422, 3312},
  {3424, 3367, 3314},
  {3426, 3367, 3424},
  {3480, 3261, 3423},
  {3319, 3605, 3603},
  {3481, 3314, 3546},
  {3424, 3314, 3481},
  {3421, 3426, 3425},
  {3425, 3258, 3421},
  {3426, 3424, 3428},
  {3426, 3487, 3425},
  {3425, 3487, 3427},
  {3479, 3427, 3490},
  {3483, 3369, 3488},
  {3430, 3429, 3428},
  {3428, 3429, 3426},
  {3427, 3487, 3490},
  {3429, 3430, 3426},
  {3369, 3432, 3488},
  {3371, 3431, 3432},
  {3276, 3371, 3432},
  {3265, 3266, 3491},
  {3435, 3548, 3272},
  {3372, 3373, 3492},
  {3373, 3273, 3493},
  {3373, 3493, 3552},
  {3208, 3611, 3209},
  {3209, 3611, 3435},
  {3274, 3440, 3493},
  {3374, 3495, 3496},
  {3438, 3264, 3441},
  {3496, 3440, 3275},
  {3275, 3374, 3496},
  {3494, 3441, 3264},
  {3277, 3436, 3375},
  {3377, 3615, 3443},
  {3444, 3499, 3378},
  {3446, 3213, 3445},
  {3331, 3502, 3379},
  {3329, 3447, 3500},
  {3447, 3329, 3449},
  {3383, 3501, 3217},
  {3281, 3503, 3381},
  {3452, 3500, 3447},
  {3450, 3451, 3453},
  {3450, 3453, 3381},
  {3450, 3381, 3451},
  {3503, 3451, 3381},
  {3333, 3561, 3384},
  {3333, 3452, 3561},
  {3335, 3563, 3383},
  {3386, 3387, 3562},
  {3385, 3566, 3387},
  {3388, 3336, 3732},
  {3393, 3392, 3454},
  {3336, 3394, 3625},
  {3625, 3394, 3627},
  {3393, 3454, 3508},
  {3394, 3507, 3627},
  {3285, 3396, 3506},
  {3394, 3175, 3507},
  {3393, 3508, 3339},
  {3398, 3572, 3338},
  {3342, 3571, 3510},
  {3692, 3571, 3342},
  {3288, 3692, 3342},
  {3399, 3339, 3508},
  {3400, 3342, 3510},
  {3456, 3455, 3341},
  {3341, 3399, 3456},
  {3508, 3456, 3399},
  {3572, 3398, 3512},
  {3227, 3403, 3457},
  {3345, 3401, 3640},
  {3513, 3177, 3574},
  {3573, 3404, 3343},
  {3514, 3402, 3513},
  {3573, 3458, 3404},
  {3458, 3577, 3403},
  {3405, 3347, 3576},
  {3402, 3514, 3235},
  {3460, 3235, 3514},
  {3347, 3578, 3576},
  {3461, 3463, 3464},
  {3521, 3579, 3351},
  {3463, 3180, 3464},
  {3465, 3406, 3523},
  {3351, 3579, 3646},
  {3351, 3646, 3349},
  {3349, 3525, 3408},
  {3408, 3466, 3180},
  {3408, 3525, 3466},
  {3465, 3526, 3352},
  {3407, 3409, 3529},
  {3352, 3526, 3528},
  {3354, 3527, 3582},
  {3409, 3410, 3467},
  {3300, 3467, 3410},
  {3468, 3467, 3300},
  {3468, 3357, 3650},
  {3299, 3584, 3412},
  {3586, 3412, 3584},
  {3587, 3247, 3411},
  {3586, 3358, 3412},
  {3357, 3413, 3651},
  {3469, 3651, 3413},
  {3358, 3589, 3596},
  {3594, 3246, 3360},
  {3413, 3359, 3469},
  {3470, 3469, 3359},
  {3472, 3307, 3471},
  {3415, 3767, 3414},
  {3303, 3656, 3416},
  {3419, 3472, 3538},
  {3417, 3418, 3599},
  {3475, 3599, 3418},
  {3418, 3309, 3475},
  {3478, 3365, 3544},
  {3420, 3478, 3477},
  {3476, 3543, 3313},
  {3364, 3545, 3544},
  {3364, 3544, 3365},
  {3258, 3422, 3311},
  {3364, 3483, 3545},
  {3258, 3425, 3422},
  {3422, 3427, 3312},
  {3312, 3482, 3479},
  {3312, 3479, 3316},
  {3261, 3480, 3547},
  {3481, 3606, 3424},
  {3422, 3425, 3427},
  {3427, 3479, 3482},
  {3427, 3482, 3312},
  {3479, 3490, 3368},
  {3479, 3368, 3316},
  {3484, 3261, 3547},
  {3484, 3547, 3604},
  {3606, 3430, 3428},
  {3606, 3428, 3424},
  {3485, 3431, 3484},
  {3485, 3484, 3604},
  {3486, 3431, 3485},
  {3605, 3370, 3548},
  {3488, 3432, 3486},
  {3432, 3431, 3486},
  {3272, 3548, 3370},
  {3489, 3430, 3549},
  {3430, 3489, 3426},
  {3490, 3491, 3368},
  {3368, 3491, 3324},
  {3489, 3487, 3426},
  {3553, 3265, 3491},
  {3611, 3208, 3439},
  {3720, 3435, 3611},
  {3492, 3437, 3372},
  {3614, 3494, 3433},
  {3433, 3434, 3614},
  {3439, 3671, 3611},
  {3374, 3438, 3495},
  {3441, 3495, 3438},
  {3553, 3614, 3434},
  {3496, 3495, 3678},
  {3554, 3495, 3441},
  {3556, 3442, 3376},
  {3375, 3497, 3377},
  {3615, 3377, 3497},
  {3379, 3502, 3444},
  {3443, 3557, 3281},
  {3331, 3446, 3502},
  {3499, 3558, 3380},
  {3281, 3557, 3503},
  {3504, 3380, 3558},
  {3447, 3449, 3560},
  {3503, 3453, 3451},
  {3452, 3447, 3561},
  {3382, 3386, 3683},
  {3504, 3449, 3380},
  {3387, 3566, 3562},
  {3385, 3626, 3566},
  {3628, 3389, 3505},
  {3568, 3454, 3392},
  {3391, 3629, 3395},
  {3397, 3634, 3396},
  {3509, 3637, 3390},
  {3570, 3635, 3397},
  {3397, 3635, 3634},
  {3390, 3338, 3509},
  {3338, 3572, 3509},
  {3402, 3177, 3513},
  {3233, 3511, 3459},
  {3293, 3515, 3574},
  {3515, 3348, 3754},
  {3460, 3514, 3698},
  {3462, 3518, 3521},
  {3518, 3519, 3521},
  {3464, 3520, 3461},
  {3520, 3464, 3524},
  {3180, 3524, 3464},
  {3462, 3350, 3522},
  {3407, 3522, 3350},
  {3349, 3646, 3525},
  {3525, 3180, 3466},
  {3525, 3580, 3180},
  {3528, 3527, 3352},
  {3526, 3705, 3528},
  {3528, 3530, 3527},
  {3531, 3527, 3530},
  {3582, 3527, 3531},
  {3581, 3529, 3409},
  {3528, 3705, 3530},
  {3409, 3467, 3581},
  {3530, 3705, 3583},
  {3531, 3530, 3583},
  {3584, 3582, 3531},
  {3532, 3531, 3583},
  {3704, 3467, 3468},
  {3650, 3357, 3585},
  {3357, 3651, 3585},
  {3411, 3356, 3653},
  {3358, 3586, 3589},
  {3246, 3594, 3533},
  {3246, 3533, 3356},
  {3470, 3595, 3469},
  {3594, 3414, 3767},
  {3534, 3655, 3474},
  {3593, 3415, 3363},
  {3415, 3711, 3767},
  {3303, 3473, 3656},
  {3470, 3416, 3595},
  {3536, 3535, 3537},
  {3472, 3540, 3538},
  {3540, 3537, 3541},
  {3540, 3539, 3538},
  {3419, 3538, 3542},
  {3538, 3539, 3542},
  {3540, 3601, 3539},
  {3539, 3600, 3542},
  {3601, 3600, 3539},
  {3419, 3542, 3543},
  {3475, 3309, 3477},
  {3420, 3477, 3309},
  {3475, 3477, 3663},
  {3476, 3419, 3543},
  {3545, 3666, 3544},
  {3544, 3602, 3478},
  {3477, 3478, 3602},
  {3366, 3313, 3543},
  {3480, 3423, 3667},
  {3607, 3486, 3485},
  {3488, 3486, 3608},
  {3549, 3430, 3609},
  {3550, 3489, 3549},
  {3489, 3550, 3487},
  {3551, 3487, 3550},
  {3487, 3610, 3490},
  {3490, 3610, 3491},
  {3435, 3720, 3548},
  {3552, 3492, 3373},
  {3436, 3437, 3669},
  {3437, 3492, 3673},
  {3325, 3671, 3439},
  {3325, 3442, 3671},
  {3436, 3672, 3375},
  {3497, 3375, 3672},
  {3495, 3554, 3613},
  {3441, 3494, 3555},
  {3441, 3555, 3554},
  {3556, 3376, 3675},
  {3442, 3556, 3671},
  {3498, 3675, 3376},
  {3615, 3616, 3443},
  {3328, 3501, 3498},
  {3445, 3619, 3446},
  {3619, 3502, 3446},
  {3619, 3618, 3502},
  {3445, 3448, 3620},
  {3445, 3620, 3619},
  {3683, 3620, 3448},
  {3560, 3621, 3447},
  {3448, 3382, 3683},
  {3623, 3449, 3504},
  {3449, 3623, 3560},
  {3504, 3622, 3624},
  {3386, 3562, 3684},
  {3686, 3504, 3624},
  {3561, 3685, 3565},
  {3385, 3682, 3564},
  {3565, 3384, 3561},
  {3565, 3505, 3384},
  {3388, 3732, 3563},
  {3732, 3336, 3625},
  {3687, 3566, 3626},
  {3505, 3565, 3628},
  {3569, 3454, 3567},
  {3630, 3567, 3454},
  {3629, 3391, 3389},
  {3628, 3629, 3389},
  {3454, 3569, 3508},
  {3744, 3568, 3392},
  {3506, 3396, 3634},
  {3508, 3569, 3636},
  {3455, 3456, 3639},
  {3456, 3508, 3639},
  {3400, 3510, 3511},
  {3457, 3641, 3398},
  {3401, 3405, 3576},
  {3401, 3576, 3640},
  {3398, 3641, 3512},
  {3459, 3511, 3642},
  {3403, 3643, 3457},
  {3458, 3573, 3575},
  {3459, 3642, 3699},
  {3577, 3643, 3403},
  {3577, 3458, 3575},
  {3699, 3516, 3459},
  {3578, 3460, 3698},
  {3517, 3754, 3348},
  {3579, 3518, 3700},
  {3461, 3520, 3756},
  {3579, 3519, 3518},
  {3520, 3645, 3756},
  {3519, 3579, 3521},
  {3645, 3520, 3580},
  {3529, 3522, 3407},
  {3524, 3580, 3520},
  {3580, 3524, 3180},
  {3531, 3532, 3584},
  {3584, 3355, 3582},
  {3584, 3532, 3586},
  {3588, 3586, 3532},
  {3587, 3707, 3590},
  {3653, 3587, 3411},
  {3469, 3591, 3651},
  {3658, 3592, 3709},
  {3595, 3591, 3469},
  {3590, 3592, 3471},
  {3534, 3302, 3708},
  {3708, 3655, 3534},
  {3593, 3474, 3655},
  {3711, 3415, 3593},
  {3471, 3658, 3472},
  {3535, 3658, 3659},
  {3660, 3656, 3473},
  {3656, 3657, 3416},
  {3472, 3658, 3597},
  {3658, 3535, 3597},
  {3536, 3597, 3535},
  {3537, 3535, 3659},
  {3473, 3417, 3660},
  {3598, 3660, 3417},
  {3472, 3597, 3540},
  {3537, 3540, 3597},
  {3597, 3536, 3537},
  {3661, 3537, 3713},
  {3541, 3537, 3661},
  {3417, 3599, 3598},
  {3769, 3541, 3662},
  {3540, 3541, 3601},
  {3663, 3599, 3475},
  {3542, 3600, 3716},
  {3600, 3601, 3716},
  {3543, 3542, 3665},
  {3543, 3665, 3546},
  {3543, 3546, 3366},
  {3667, 3423, 3603},
  {3481, 3546, 3665},
  {3545, 3483, 3668},
  {3547, 3480, 3777},
  {3488, 3608, 3483},
  {3608, 3486, 3607},
  {3549, 3783, 3550},
  {3551, 3612, 3487},
  {3487, 3612, 3610},
  {3610, 3553, 3491},
  {3492, 3552, 3784},
  {3552, 3493, 3674},
  {3550, 3721, 3551},
  {3672, 3436, 3669},
  {3493, 3440, 3674},
  {3554, 3555, 3792},
  {3554, 3792, 3613},
  {3494, 3614, 3677},
  {3494, 3677, 3555},
  {3497, 3672, 3787},
  {3496, 3676, 3440},
  {3497, 3787, 3615},
  {3557, 3443, 3616},
  {3617, 3444, 3502},
  {3444, 3617, 3499},
  {3502, 3618, 3617},
  {3499, 3617, 3558},
  {3383, 3559, 3501},
  {3729, 3504, 3558},
  {3503, 3681, 3453},
  {3682, 3453, 3681},
  {3731, 3559, 3383},
  {3453, 3682, 3385},
  {3798, 3560, 3623},
  {3621, 3561, 3447},
  {3386, 3684, 3683},
  {3504, 3686, 3623},
  {3621, 3685, 3561},
  {3682, 3730, 3564},
  {3564, 3626, 3385},
  {3565, 3688, 3628},
  {3691, 3569, 3567},
  {3691, 3567, 3735},
  {3567, 3737, 3735},
  {3454, 3568, 3630},
  {3629, 3740, 3395},
  {3632, 3631, 3506},
  {3631, 3288, 3506},
  {3631, 3632, 3633},
  {3631, 3633, 3692},
  {3631, 3692, 3288},
  {3568, 3744, 3741},
  {3568, 3741, 3630},
  {3506, 3634, 3632},
  {3507, 3861, 3627},
  {3337, 3637, 3392},
  {3395, 3865, 3570},
  {3507, 3742, 3861},
  {3636, 3743, 5905},
  {3636, 5905, 3639},
  {3508, 3636, 3639},
  {3509, 3638, 3637},
  {3507, 3455, 3742},
  {3639, 3748, 3455},
  {3640, 3576, 3695},
  {3697, 3695, 3576},
  {3457, 3643, 3641},
  {3813, 3516, 3699},
  {3698, 3753, 3578},
  {3516, 3813, 3517},
  {3462, 3701, 3518},
  {3700, 3518, 3701},
  {3462, 3522, 3701},
  {3702, 3645, 3580},
  {3756, 3703, 3461},
  {3461, 3703, 3523},
  {3522, 3755, 3701},
  {3522, 3647, 3755},
  {3522, 3529, 3647},
  {3646, 3580, 3525},
  {3523, 3758, 3465},
  {3465, 3758, 3875},
  {3465, 3875, 3526},
  {3705, 3526, 3759},
  {3529, 3581, 3647},
  {3647, 3581, 3704},
  {3647, 3704, 3648},
  {3581, 3467, 3704},
  {3650, 3704, 3468},
  {3649, 3988, 3583},
  {3532, 3583, 3706},
  {3706, 3762, 3532},
  {3532, 3762, 3588},
  {3588, 3589, 3586},
  {3589, 3588, 3765},
  {3356, 3533, 3653},
  {3589, 3765, 3596},
  {3533, 3766, 3653},
  {3533, 3594, 3766},
  {3592, 3590, 3764},
  {3709, 3592, 3764},
  {3654, 3763, 3591},
  {3655, 3652, 3593},
  {3710, 3658, 3709},
  {3591, 3595, 3654},
  {3596, 3823, 3302},
  {3471, 3592, 3658},
  {3654, 3416, 3657},
  {3595, 3416, 3654},
  {3712, 3537, 3659},
  {3712, 3713, 3537},
  {3662, 3541, 3661},
  {3477, 3664, 3663},
  {3541, 3715, 3601},
  {3477, 3602, 3664},
  {3542, 3716, 3665},
  {3544, 3666, 3602},
  {3545, 3668, 3666},
  {3480, 3667, 3833},
  {3547, 3777, 3604},
  {3717, 3606, 3481},
  {3607, 3718, 3608},
  {3607, 3485, 3604},
  {3483, 3718, 3668},
  {3483, 3608, 3718},
  {3609, 3783, 3549},
  {3437, 3673, 3669},
  {3552, 3785, 3788},
  {3552, 3788, 3784},
  {3552, 3674, 3785},
  {3550, 3719, 3721},
  {3551, 3670, 3612},
  {3612, 3722, 3610},
  {3610, 3722, 3553},
  {3551, 3721, 3670},
  {3789, 3674, 3440},
  {3553, 3722, 3614},
  {3556, 3675, 3893},
  {3556, 3893, 3671},
  {3440, 3676, 3789},
  {3613, 3723, 3495},
  {3613, 3792, 3791},
  {3496, 3678, 3676},
  {3498, 3724, 3675},
  {3498, 3679, 3724},
  {3616, 3725, 3557},
  {3501, 3679, 3498},
  {3557, 3725, 3793},
  {3617, 3618, 3680},
  {3617, 3680, 3558},
  {3793, 3503, 3557},
  {3619, 3728, 3618},
  {3501, 3559, 3727},
  {3795, 3727, 3559},
  {3619, 3620, 3728},
  {3504, 3729, 3622},
  {3559, 3731, 3795},
  {3560, 3685, 3621},
  {3798, 3685, 3560},
  {3383, 3563, 3731},
  {3623, 3686, 3798},
  {3622, 3729, 3624},
  {3564, 3796, 3626},
  {3562, 3566, 3687},
  {3689, 3626, 3796},
  {3565, 3685, 3798},
  {3688, 3565, 3798},
  {3628, 3734, 3690},
  {3629, 3628, 3736},
  {3629, 3736, 3740},
  {3628, 3690, 3736},
  {3632, 3692, 3693},
  {3632, 3693, 3633},
  {3633, 3693, 3692},
  {3630, 3741, 3567},
  {3634, 3692, 3632},
  {3691, 3738, 3636},
  {3569, 3691, 3636},
  {3395, 3740, 3865},
  {3635, 3805, 3745},
  {3635, 3745, 3634},
  {3635, 3570, 3747},
  {3570, 3865, 3747},
  {3571, 3745, 3804},
  {3638, 3694, 3392},
  {3638, 3392, 3637},
  {3635, 3747, 3805},
  {3748, 3742, 3455},
  {3749, 3638, 3509},
  {3638, 3749, 3694},
  {3749, 3509, 3572},
  {3641, 3867, 3512},
  {3574, 3698, 3513},
  {3512, 3868, 3572},
  {3698, 3514, 3513},
  {3511, 3750, 3642},
  {3696, 3642, 3750},
  {3699, 3642, 3696},
  {3575, 3870, 3577},
  {3576, 3578, 3697},
  {3699, 3751, 3812},
  {3751, 3699, 3696},
  {3643, 3577, 3752},
  {3578, 3753, 3697},
  {3699, 3812, 3813},
  {3644, 3913, 3814},
  {3814, 3702, 3644},
  {3645, 3702, 3916},
  {3644, 3702, 3579},
  {3579, 3702, 3646},
  {3702, 3580, 3646},
  {3645, 3757, 3756},
  {3647, 3815, 3755},
  {3647, 3648, 3815},
  {3583, 3705, 3649},
  {3649, 3705, 3988},
  {3988, 3706, 3583},
  {3761, 3585, 3651},
  {3591, 3761, 3651},
  {3587, 3653, 3707},
  {3707, 3764, 3590},
  {3652, 3711, 3593},
  {3655, 3708, 3822},
  {3654, 3657, 3827},
  {3594, 3828, 3766},
  {3594, 3767, 3768},
  {3710, 3659, 3658},
  {3659, 3710, 3712},
  {3599, 3770, 3598},
  {3599, 3663, 3770},
  {3663, 3883, 3770},
  {3663, 3664, 3883},
  {3541, 3714, 3715},
  {3717, 3665, 3716},
  {3666, 3668, 3773},
  {3665, 3717, 3481},
  {3480, 3833, 3777},
  {3668, 3837, 3776},
  {3603, 3605, 3778},
  {3668, 3718, 3837},
  {3718, 3607, 3781},
  {3607, 3780, 3781},
  {3607, 3604, 3780},
  {3609, 3782, 3783},
  {3783, 3719, 3550},
  {3611, 3671, 3720},
  {3492, 3784, 3673},
  {3670, 3842, 3612},
  {3612, 3842, 3722},
  {3675, 3724, 3893},
  {3495, 3723, 3678},
  {3791, 3792, 3894},
  {3677, 3614, 3843},
  {3501, 3727, 3679},
  {3558, 3680, 3726},
  {3680, 3618, 3794},
  {3503, 3793, 3681},
  {3794, 3618, 3728},
  {3558, 3726, 3729},
  {3795, 3731, 3848},
  {3898, 3620, 3683},
  {3732, 3731, 3563},
  {3562, 3854, 3684},
  {3732, 3797, 3852},
  {3730, 3796, 3564},
  {3854, 3562, 3687},
  {3732, 3625, 3797},
  {3624, 3799, 3686},
  {3624, 3733, 3799},
  {3687, 3626, 3800},
  {3624, 3900, 3733},
  {3800, 3626, 3689},
  {3628, 3688, 3734},
  {3690, 3734, 3971},
  {3690, 3971, 3736},
  {3691, 3735, 3803},
  {3567, 3739, 3737},
  {3567, 3741, 3739},
  {3738, 3743, 3636},
  {3634, 3745, 3571},
  {3634, 3571, 3692},
  {3744, 3392, 3694},
  {3866, 3746, 3743},
  {5905, 3743, 3746},
  {3694, 3749, 3744},
  {3510, 3571, 3750},
  {3750, 3511, 3510},
  {3640, 3695, 3809},
  {3640, 3809, 3573},
  {3868, 3512, 3867},
  {3810, 3575, 3573},
  {4040, 3695, 3697},
  {3811, 3698, 3574},
  {3641, 3643, 3867},
  {3752, 3867, 3643},
  {3752, 3577, 3870},
  {3811, 3574, 3515},
  {3698, 3982, 3753},
  {3754, 3874, 3515},
  {3700, 3644, 3579},
  {3814, 3916, 3702},
  {3756, 3915, 3703},
  {3916, 3757, 3645},
  {3703, 3758, 3523},
  {3759, 3526, 3875},
  {3648, 3877, 3815},
  {3877, 3648, 3817},
  {3704, 3817, 3648},
  {3820, 3760, 3652},
  {3763, 3761, 3591},
  {3655, 3922, 3652},
  {3653, 3824, 3707},
  {3707, 3824, 3764},
  {3765, 3925, 3596},
  {3764, 3824, 3927},
  {3764, 3927, 3709},
  {3824, 3653, 3766},
  {3709, 3927, 3710},
  {3656, 3826, 3657},
  {3828, 3594, 3768},
  {3825, 3656, 3660},
  {3660, 3598, 3881},
  {3931, 3881, 3598},
  {3713, 3935, 3661},
  {3662, 3661, 3935},
  {3714, 3541, 3769},
  {3598, 3770, 3931},
  {3662, 3935, 3769},
  {3716, 3601, 3715},
  {3715, 3714, 3830},
  {3771, 3716, 3715},
  {3664, 3602, 3772},
  {3775, 3716, 3771},
  {3884, 3666, 3773},
  {3666, 3884, 3774},
  {3666, 3774, 3602},
  {3668, 3776, 3773},
  {3833, 3667, 3834},
  {3667, 3603, 3834},
  {3717, 3716, 3775},
  {3717, 3775, 3779},
  {3717, 3779, 3606},
  {3604, 3777, 3886},
  {3604, 3886, 3780},
  {3778, 3605, 3839},
  {3606, 3779, 3430},
  {3779, 3782, 3430},
  {3718, 3781, 3888},
  {3718, 3888, 3837},
  {3839, 3605, 3548},
  {3430, 3782, 3609},
  {3782, 3835, 3783},
  {3548, 3720, 3839},
  {3719, 3783, 3947},
  {3840, 3672, 3669},
  {3669, 3673, 3840},
  {3719, 3947, 3721},
  {3671, 3953, 3720},
  {3672, 3949, 3890},
  {3721, 3947, 3786},
  {3721, 3786, 3670},
  {3670, 3786, 3842},
  {3893, 3891, 3671},
  {3672, 3890, 3787},
  {3788, 3785, 3955},
  {4010, 3785, 3674},
  {3843, 3555, 3677},
  {3676, 3678, 3845},
  {3676, 3845, 3790},
  {3845, 3678, 3723},
  {3555, 3843, 3792},
  {3616, 3615, 3844},
  {3724, 3679, 3895},
  {3616, 3844, 3725},
  {3726, 3680, 3794},
  {3728, 3960, 3794},
  {3846, 3682, 3681},
  {3683, 3684, 3898},
  {3732, 3848, 3731},
  {3796, 3853, 3689},
  {3857, 3689, 3853},
  {3899, 3687, 3800},
  {3689, 3857, 3801},
  {3625, 3627, 3797},
  {3800, 3689, 3801},
  {3803, 3735, 3906},
  {3858, 3691, 3803},
  {3738, 3691, 3858},
  {3739, 3863, 3737},
  {3741, 3864, 3739},
  {3741, 3744, 3864},
  {3742, 3748, 3866},
  {3866, 3748, 3746},
  {5905, 3746, 3748},
  {3747, 3977, 3805},
  {3749, 3807, 3744},
  {3806, 3748, 5905},
  {3807, 3749, 3979},
  {3809, 3810, 3573},
  {3808, 3812, 3751},
  {3749, 3572, 3868},
  {3867, 3752, 3872},
  {3515, 3874, 3811},
  {3517, 3813, 3911},
  {3517, 3911, 3754},
  {3701, 3755, 3914},
  {3755, 4046, 3914},
  {3703, 3915, 3758},
  {3755, 3815, 4046},
  {3876, 3816, 4106},
  {3876, 3987, 3818},
  {3876, 3818, 3816},
  {3759, 3988, 3705},
  {3704, 3650, 3817},
  {3818, 3760, 3816},
  {3585, 3819, 3650},
  {3706, 3988, 3879},
  {3706, 3879, 3762},
  {3652, 3922, 3820},
  {3760, 3821, 3652},
  {3761, 3763, 3990},
  {3822, 3922, 3655},
  {3588, 3762, 3919},
  {3588, 3919, 3765},
  {3708, 3302, 3822},
  {3823, 3822, 3302},
  {3652, 3821, 3711},
  {3654, 3827, 3763},
  {3925, 3823, 3596},
  {3656, 3825, 3826},
  {3657, 3826, 3827},
  {3712, 3710, 3829},
  {3929, 3829, 3710},
  {3881, 3825, 3660},
  {3936, 3999, 3830},
  {3831, 3830, 3999},
  {3715, 3831, 3771},
  {3830, 3831, 3715},
  {3774, 3772, 3602},
  {3772, 3997, 3664},
  {3771, 3832, 3775},
  {3771, 3831, 3832},
  {3773, 3776, 3884},
  {3775, 3832, 3835},
  {3777, 3833, 3886},
  {3775, 3835, 3779},
  {3779, 3835, 3782},
  {3780, 3836, 3781},
  {3783, 3835, 3889},
  {3835, 3838, 3889},
  {3720, 3946, 3839},
  {3840, 3949, 3672},
  {3840, 3673, 3784},
  {3786, 3952, 3841},
  {3786, 3841, 3842},
  {3614, 3722, 3842},
  {4010, 3955, 3785},
  {3789, 4010, 3674},
  {3842, 3843, 3614},
  {3724, 4012, 3893},
  {3789, 3676, 3790},
  {4074, 3790, 3845},
  {3613, 3791, 3723},
  {3792, 3843, 3892},
  {3615, 3787, 3844},
  {3958, 3845, 3723},
  {3723, 3791, 3958},
  {3793, 3846, 3681},
  {3794, 3729, 3726},
  {3794, 3960, 3729},
  {3960, 3728, 3620},
  {3729, 3960, 3847},
  {3682, 3961, 3730},
  {3796, 3730, 3961},
  {3729, 3847, 3855},
  {3732, 3849, 3848},
  {3851, 3850, 3849},
  {3849, 3850, 3848},
  {3849, 3732, 3851},
  {3852, 3851, 3732},
  {3853, 3796, 3962},
  {3729, 3855, 3624},
  {3797, 3856, 3852},
  {3624, 3855, 3900},
  {3798, 3686, 3799},
  {3733, 3900, 3802},
  {3688, 3799, 3734},
  {3797, 3627, 3903},
  {3797, 3903, 3901},
  {3858, 3803, 3859},
  {3859, 3803, 3906},
  {3801, 3860, 4024},
  {3733, 3802, 3969},
  {3736, 3971, 3740},
  {3735, 3973, 3906},
  {3627, 3861, 3903},
  {3738, 3858, 3905},
  {3905, 3862, 3743},
  {3905, 3743, 3738},
  {3735, 3737, 3973},
  {3861, 3742, 3972},
  {3739, 3864, 3863},
  {3865, 3977, 3747},
  {3804, 3745, 3805},
  {3978, 3744, 3807},
  {3909, 3750, 3571},
  {3978, 3807, 3979},
  {3869, 3808, 3751},
  {3809, 4040, 3810},
  {3809, 3695, 4040},
  {3696, 3869, 3751},
  {3750, 3909, 3696},
  {3575, 3810, 3870},
  {3980, 3812, 3808},
  {3752, 3871, 3872},
  {3752, 3870, 3871},
  {3982, 3698, 4100},
  {3698, 3811, 4100},
  {3981, 3813, 3812},
  {3697, 3753, 3873},
  {3873, 3753, 3982},
  {3754, 3911, 3874},
  {3811, 3874, 3983},
  {3700, 3913, 3644},
  {3814, 3913, 3916},
  {3758, 3915, 4048},
  {3758, 4048, 3875},
  {3757, 4050, 3756},
  {4106, 3816, 3917},
  {3819, 3817, 3650},
  {3817, 3819, 3877},
  {3760, 3820, 3816},
  {3878, 3819, 3585},
  {3585, 3761, 3878},
  {3990, 3878, 3761},
  {3920, 3762, 3879},
  {3762, 3920, 3919},
  {3760, 3818, 3821},
  {3880, 3821, 3818},
  {3711, 3821, 3767},
  {3828, 3768, 3926},
  {3710, 3927, 3929},
  {3826, 3992, 3827},
  {3766, 3828, 3928},
  {3992, 3825, 3930},
  {3825, 3992, 3826},
  {3712, 3882, 3713},
  {3935, 3713, 3882},
  {3936, 3769, 3935},
  {3770, 3995, 3931},
  {3770, 3883, 3995},
  {3772, 3774, 3940},
  {3832, 3831, 3885},
  {3831, 3944, 3885},
  {3832, 3885, 3835},
  {3603, 3778, 3834},
  {3835, 3885, 3838},
  {3885, 3887, 3838},
  {3776, 3837, 3945},
  {4007, 3781, 3836},
  {3837, 3888, 3945},
  {3889, 3838, 4069},
  {3838, 3887, 4069},
  {3720, 3951, 3946},
  {3840, 3784, 3950},
  {3720, 3953, 3951},
  {3671, 3891, 3953},
  {3954, 3787, 3890},
  {3892, 3841, 3952},
  {3842, 3841, 3892},
  {3956, 3894, 3892},
  {3958, 3894, 3956},
  {3894, 3792, 3892},
  {3724, 3895, 4012},
  {3957, 4010, 3789},
  {3789, 3790, 3957},
  {3894, 3958, 3791},
  {3959, 3895, 3679},
  {3959, 3679, 3727},
  {3844, 3896, 3725},
  {3793, 3725, 3896},
  {3846, 3897, 3682},
  {3897, 3961, 3682},
  {3898, 3960, 3620},
  {3850, 3851, 3852},
  {3850, 3852, 3848},
  {3847, 3963, 3855},
  {3962, 4017, 3853},
  {3684, 3854, 3964},
  {3848, 3852, 3856},
  {3855, 3963, 3967},
  {3900, 3855, 3967},
  {3854, 3687, 3899},
  {3899, 3800, 4018},
  {3800, 3801, 4020},
  {3799, 3688, 3798},
  {3857, 3860, 3801},
  {3857, 4019, 3860},
  {3859, 3906, 3902},
  {3860, 4019, 3904},
  {3858, 4025, 3905},
  {3858, 3859, 4025},
  {3859, 3902, 4025},
  {3969, 3802, 3975},
  {3802, 3974, 3975},
  {3743, 3862, 3866},
  {3866, 3862, 4026},
  {3737, 3863, 3973},
  {3976, 3973, 3863},
  {4030, 3865, 3740},
  {3866, 3972, 3742},
  {3863, 3864, 4033},
  {3865, 4030, 3977},
  {3864, 3744, 3907},
  {3907, 3744, 3978},
  {3804, 3908, 3571},
  {3571, 3908, 3909},
  {3808, 3869, 4037},
  {4222, 4037, 3869},
  {3909, 4166, 3869},
  {3867, 4096, 3868},
  {3749, 3868, 3979},
  {4096, 3979, 3868},
  {3810, 4040, 3870},
  {3869, 3696, 3909},
  {4038, 3872, 3871},
  {3980, 3981, 3812},
  {3813, 3981, 3911},
  {4101, 3873, 3912},
  {3811, 3983, 3910},
  {3874, 3911, 3983},
  {3700, 4043, 3913},
  {3756, 4045, 3915},
  {3756, 4050, 4045},
  {4046, 3815, 3985},
  {3877, 3985, 3815},
  {3986, 4106, 3917},
  {3987, 4111, 3818},
  {3989, 3877, 3819},
  {3922, 3918, 3917},
  {3924, 3921, 3986},
  {3986, 3918, 3924},
  {3922, 3917, 3816},
  {3816, 3820, 3922},
  {3822, 3924, 3918},
  {3818, 4111, 3923},
  {3819, 3878, 3989},
  {4053, 3919, 3920},
  {4053, 3921, 3919},
  {3923, 3880, 3818},
  {3921, 3765, 3919},
  {3921, 3924, 3925},
  {3765, 3921, 3925},
  {3925, 3822, 3823},
  {3821, 3926, 3768},
  {3821, 3768, 3767},
  {3828, 3926, 3928},
  {3824, 4055, 3927},
  {3829, 3929, 4121},
  {3825, 3881, 3930},
  {4058, 3882, 3712},
  {4058, 3712, 3829},
  {3931, 4057, 3881},
  {3932, 3934, 3933},
  {3769, 3936, 3714},
  {3714, 3936, 3830},
  {3883, 3664, 3997},
  {3996, 4000, 3932},
  {3932, 4000, 3934},
  {3934, 4000, 4001},
  {3937, 3942, 3939},
  {3935, 3937, 3939},
  {3941, 3940, 3774},
  {3772, 3940, 3997},
  {3934, 4001, 3938},
  {3942, 3937, 3938},
  {3943, 3884, 3776},
  {3941, 3774, 3884},
  {3938, 4001, 3942},
  {4062, 3942, 4001},
  {3939, 3942, 4002},
  {4004, 3943, 3776},
  {4066, 4126, 3834},
  {3834, 3778, 4066},
  {3885, 3944, 3887},
  {4192, 3887, 3944},
  {3945, 4004, 3776},
  {3778, 3839, 4006},
  {3888, 3781, 4007},
  {3839, 3946, 4006},
  {3948, 3947, 3783},
  {3783, 3889, 3948},
  {3890, 3949, 4008},
  {4008, 3954, 3890},
  {3784, 3788, 4073},
  {3955, 4073, 3788},
  {3952, 4009, 3892},
  {3956, 3892, 4009},
  {3844, 3787, 3954},
  {3842, 3892, 3843},
  {4200, 3893, 4012},
  {4011, 3896, 3844},
  {3790, 4074, 3957},
  {3958, 4136, 3845},
  {3896, 4013, 3793},
  {3793, 4013, 3846},
  {3846, 4013, 4015},
  {3846, 4015, 3897},
  {3727, 3795, 4014},
  {3897, 4076, 3961},
  {3795, 3848, 4014},
  {3961, 3962, 3796},
  {3684, 4016, 3898},
  {3964, 4016, 3684},
  {3848, 3856, 3966},
  {3853, 4017, 3857},
  {3856, 3797, 3965},
  {3856, 3965, 3966},
  {3797, 3966, 3965},
  {3797, 3901, 3966},
  {4018, 3800, 4020},
  {4079, 3799, 3733},
  {3901, 3903, 4149},
  {4149, 3903, 3968},
  {3802, 3900, 3970},
  {3733, 3969, 4079},
  {3802, 3970, 3974},
  {3861, 3968, 3903},
  {4023, 4025, 3902},
  {3902, 3906, 4028},
  {4024, 3904, 4022},
  {3904, 4024, 3860},
  {3971, 4030, 3740},
  {4026, 3972, 3866},
  {4027, 3862, 3905},
  {3973, 4028, 3906},
  {3974, 4034, 3975},
  {3863, 4033, 3976},
  {3805, 4035, 3804},
  {3907, 4036, 3864},
  {3978, 4036, 3907},
  {4222, 3869, 4166},
  {3867, 4098, 4096},
  {3871, 3870, 4039},
  {3867, 3872, 4169},
  {3867, 4169, 4098},
  {3980, 4041, 3981},
  {3697, 4099, 4040},
  {3697, 3873, 4099},
  {3811, 3910, 4100},
  {3981, 4227, 3911},
  {3873, 3982, 3912},
  {3873, 4101, 4099},
  {3982, 4171, 3912},
  {4042, 4100, 3910},
  {3983, 3911, 4227},
  {3912, 4102, 4101},
  {3700, 3914, 4043},
  {4043, 3984, 3913},
  {3913, 3984, 3916},
  {3984, 4049, 3916},
  {3916, 4049, 3757},
  {3877, 4051, 3985},
  {3918, 3986, 3917},
  {4108, 4174, 3759},
  {3878, 4282, 3989},
  {3878, 3990, 4282},
  {3924, 3822, 3925},
  {3918, 3922, 3822},
  {3880, 3923, 4113},
  {3821, 3880, 3926},
  {3880, 4113, 3926},
  {3763, 3827, 3991},
  {3927, 4055, 3929},
  {4055, 3824, 4184},
  {3766, 4117, 3824},
  {3929, 4120, 4121},
  {3881, 4057, 3930},
  {4121, 4058, 3829},
  {3995, 4187, 3931},
  {3993, 4059, 3996},
  {3996, 3932, 3933},
  {3996, 3933, 3993},
  {3934, 3993, 3933},
  {3993, 3934, 3994},
  {3938, 3994, 3934},
  {3996, 4059, 4060},
  {3882, 4058, 3935},
  {3997, 3995, 3883},
  {3994, 3938, 3998},
  {3935, 4058, 3998},
  {3998, 3937, 3935},
  {3996, 4060, 4000},
  {3938, 3937, 3998},
  {3999, 3935, 3939},
  {3935, 3999, 3936},
  {4122, 3997, 3940},
  {3940, 3941, 4123},
  {3939, 4003, 3999},
  {3999, 4061, 3831},
  {3944, 3831, 4061},
  {3941, 3884, 3943},
  {3942, 4062, 4002},
  {3939, 4002, 4003},
  {4061, 3999, 4003},
  {4192, 3944, 4061},
  {4063, 3833, 3834},
  {3780, 3886, 4005},
  {3886, 4063, 4005},
  {3778, 4006, 4128},
  {3945, 3888, 4065},
  {3947, 3948, 4196},
  {3948, 3889, 4069},
  {4008, 3949, 4131},
  {3947, 4070, 3786},
  {3952, 3786, 4070},
  {3950, 3784, 4073},
  {3950, 4073, 4132},
  {3954, 4008, 4071},
  {3844, 3954, 4072},
  {3891, 3893, 4350},
  {3955, 4010, 4133},
  {4010, 3957, 4202},
  {3727, 4075, 3959},
  {4014, 3848, 4204},
  {4016, 3960, 3898},
  {3960, 4146, 3963},
  {3962, 4143, 4017},
  {3960, 3963, 3847},
  {3964, 4256, 4016},
  {3964, 3854, 4145},
  {3899, 4145, 3854},
  {4017, 4077, 3857},
  {4018, 4145, 3899},
  {3967, 3963, 4147},
  {3857, 4077, 4019},
  {3801, 4021, 4020},
  {4078, 3900, 3967},
  {4149, 3968, 4413},
  {3801, 4024, 4021},
  {3900, 4078, 4084},
  {3799, 4079, 3734},
  {4019, 4022, 3904},
  {4084, 3970, 3900},
  {3971, 4079, 3969},
  {3971, 3734, 4079},
  {3968, 3861, 3972},
  {3905, 4025, 4027},
  {4030, 3971, 3969},
  {4025, 4023, 4092},
  {4024, 4022, 4153},
  {4029, 4153, 4022},
  {4026, 3862, 4093},
  {4027, 4093, 3862},
  {4028, 3973, 4095},
  {4157, 3974, 3970},
  {3969, 3975, 4031},
  {3973, 3976, 4095},
  {3975, 4034, 4031},
  {3976, 4033, 4032},
  {3977, 4158, 3805},
  {4034, 3974, 4157},
  {3864, 4036, 4033},
  {3980, 3808, 4037},
  {3980, 4037, 4223},
  {3978, 3979, 4165},
  {4166, 3909, 3908},
  {4096, 4165, 3979},
  {3870, 4040, 4039},
  {3871, 4039, 4038},
  {4041, 4170, 3981},
  {3910, 4103, 4042},
  {4043, 3914, 4044},
  {4046, 4044, 3914},
  {4104, 4043, 4044},
  {4043, 4104, 3984},
  {3984, 4104, 4047},
  {4172, 4044, 4046},
  {3984, 4047, 4049},
  {4104, 4105, 4047},
  {4050, 3757, 4049},
  {4051, 4046, 3985},
  {4331, 3876, 4106},
  {4051, 3877, 4107},
  {3759, 3875, 4108},
  {3986, 4330, 4106},
  {3759, 4174, 3988},
  {3921, 4110, 3986},
  {3986, 4110, 4052},
  {3921, 4053, 4110},
  {3989, 4282, 4109},
  {4111, 4113, 3923},
  {3920, 3879, 4181},
  {3920, 4181, 4053},
  {3879, 4054, 4181},
  {3879, 3988, 4054},
  {3763, 3991, 4180},
  {3926, 4113, 3928},
  {3827, 3992, 3991},
  {3928, 4117, 3766},
  {3929, 4055, 4120},
  {3931, 4187, 4057},
  {3930, 4057, 4185},
  {4056, 3993, 4118},
  {3994, 4118, 3993},
  {4119, 4118, 3994},
  {4059, 3993, 4056},
  {3998, 4119, 3994},
  {3995, 3997, 4122},
  {3940, 4123, 4122},
  {4060, 4189, 4000},
  {3943, 4004, 3941},
  {4123, 3941, 4004},
  {4003, 4002, 4061},
  {3834, 4126, 4063},
  {4125, 4061, 4002},
  {4061, 4125, 4192},
  {3886, 3833, 4063},
  {4064, 4002, 4127},
  {4004, 3945, 4190},
  {4065, 4190, 3945},
  {4195, 4005, 4063},
  {4128, 4066, 3778},
  {3836, 3780, 4129},
  {4005, 4129, 3780},
  {4066, 4128, 4067},
  {4007, 4197, 3888},
  {4007, 3836, 4068},
  {4007, 4068, 4197},
  {4006, 3946, 4247},
  {3948, 4069, 4196},
  {4069, 4130, 4196},
  {4069, 4192, 4130},
  {3888, 4197, 4065},
  {3947, 4196, 4070},
  {3949, 3840, 4131},
  {4070, 4252, 3952},
  {3950, 4132, 3840},
  {3954, 4071, 4072},
  {4073, 3955, 4133},
  {4011, 3844, 4072},
  {4133, 4010, 4202},
  {4136, 3958, 4134},
  {3895, 4137, 4012},
  {3957, 4074, 4202},
  {3959, 4075, 3895},
  {3895, 4075, 4137},
  {4075, 3727, 4139},
  {3727, 4014, 4139},
  {4076, 3897, 4015},
  {4014, 4204, 4139},
  {4076, 4140, 3961},
  {3961, 4140, 3962},
  {4142, 4204, 3848},
  {4256, 3964, 4145},
  {4077, 4206, 4019},
  {4019, 4206, 4091},
  {4018, 4020, 4414},
  {4019, 4091, 4022},
  {4024, 4258, 4021},
  {3901, 4149, 4082},
  {3901, 4082, 4081},
  {4085, 4080, 3901},
  {3901, 4081, 4086},
  {4087, 4086, 4081},
  {3901, 4086, 4085},
  {4088, 4085, 4086},
  {4081, 4082, 4089},
  {4081, 4089, 4087},
  {4152, 3968, 3972},
  {4023, 3902, 4083},
  {4090, 4083, 3902},
  {4086, 4087, 4088},
  {4089, 4088, 4087},
  {3972, 4026, 4152},
  {4092, 4027, 4025},
  {3902, 4028, 4090},
  {4022, 4091, 4029},
  {4208, 4029, 4091},
  {4093, 4152, 4026},
  {4092, 4023, 4154},
  {4094, 4090, 4028},
  {4157, 3970, 4084},
  {4028, 4095, 4094},
  {3969, 4031, 4030},
  {4268, 4030, 4031},
  {4158, 4030, 4268},
  {3977, 4030, 4158},
  {4095, 3976, 4032},
  {4095, 4032, 4217},
  {4034, 4160, 4031},
  {4035, 4219, 3804},
  {3804, 4219, 3908},
  {4033, 4036, 4163},
  {4036, 3978, 4162},
  {3980, 4223, 4164},
  {3980, 4097, 4041},
  {4096, 4324, 4165},
  {4039, 4226, 4038},
  {4040, 4226, 4039},
  {4168, 4169, 3872},
  {3982, 4100, 4171},
  {3910, 3983, 4103},
  {4171, 4102, 3912},
  {4044, 4228, 4104},
  {4276, 4045, 4050},
  {4049, 4047, 4105},
  {4046, 4051, 4230},
  {4049, 4279, 4050},
  {3875, 4048, 4108},
  {4051, 4107, 4230},
  {3877, 3989, 4107},
  {4173, 3989, 4109},
  {3986, 4175, 4330},
  {4178, 3988, 4174},
  {4052, 4175, 3986},
  {4052, 4110, 4175},
  {3987, 4112, 4111},
  {4053, 4177, 4110},
  {3990, 3763, 4180},
  {4177, 4053, 4181},
  {4180, 3991, 3992},
  {4114, 4116, 4186},
  {4114, 4186, 4115},
  {3928, 4113, 4117},
  {4183, 3992, 4185},
  {4116, 4118, 4186},
  {4117, 4184, 3824},
  {3992, 3930, 4185},
  {4290, 4056, 4118},
  {4188, 4059, 4056},
  {4290, 4188, 4056},
  {4119, 3998, 4186},
  {4188, 4060, 4059},
  {4122, 4242, 3995},
  {4004, 4191, 4123},
  {4000, 4124, 4001},
  {4001, 4124, 4062},
  {4125, 4002, 4064},
  {4067, 4126, 4066},
  {4125, 4064, 4127},
  {3836, 4129, 4068},
  {4249, 4068, 4129},
  {3887, 4192, 4069},
  {4006, 4247, 4128},
  {4065, 4197, 4298},
  {4251, 4008, 4131},
  {3840, 4132, 4198},
  {3840, 4198, 4131},
  {4071, 4300, 4072},
  {4073, 4301, 4132},
  {3952, 4252, 4009},
  {4250, 3953, 3891},
  {4009, 4252, 3956},
  {4134, 3956, 4252},
  {4135, 4011, 4199},
  {3956, 4134, 3958},
  {3896, 4135, 4013},
  {4074, 3845, 4138},
  {4074, 4138, 4203},
  {3845, 4136, 4138},
  {4075, 4139, 4137},
  {4016, 4256, 4141},
  {4016, 4141, 3960},
  {3960, 4141, 4146},
  {4142, 3848, 4144},
  {4017, 4143, 4205},
  {4146, 4147, 3963},
  {3848, 3966, 4144},
  {4017, 4205, 4077},
  {4144, 4080, 4360},
  {4020, 4021, 4258},
  {4078, 3967, 4147},
  {4260, 4413, 3968},
  {4083, 4263, 4023},
  {4080, 4085, 4148},
  {4150, 4148, 4085},
  {4085, 4088, 4150},
  {4082, 4149, 4151},
  {4082, 4151, 4089},
  {4154, 4209, 4092},
  {4088, 4089, 4150},
  {4151, 4150, 4089},
  {4027, 4092, 4265},
  {4209, 4265, 4092},
  {4083, 4090, 4210},
  {4155, 4210, 4090},
  {4027, 4264, 4093},
  {4090, 4094, 4155},
  {4266, 4155, 4094},
  {4029, 4208, 4156},
  {4315, 4029, 4156},
  {4094, 4095, 4212},
  {4094, 4212, 4266},
  {4159, 4031, 4160},
  {3805, 4158, 4035},
  {4161, 4034, 4157},
  {4034, 4161, 4160},
  {4162, 3978, 4165},
  {4163, 4036, 4162},
  {3980, 4164, 4221},
  {4037, 4222, 4223},
  {3908, 4219, 4166},
  {3980, 4221, 4097},
  {4324, 4096, 4098},
  {4038, 4226, 4167},
  {4224, 4041, 4097},
  {4168, 3872, 4038},
  {4040, 4099, 4226},
  {4326, 4170, 4041},
  {3981, 4170, 4227},
  {4101, 4272, 4099},
  {4227, 4103, 3983},
  {4102, 4275, 4101},
  {4100, 4042, 4171},
  {4171, 4042, 4274},
  {4042, 4103, 4274},
  {3915, 4045, 4048},
  {4278, 4172, 4046},
  {4106, 4330, 4331},
  {4049, 4105, 4231},
  {4048, 4229, 4108},
  {4278, 4046, 4230},
  {4049, 4231, 4279},
  {4232, 3876, 4331},
  {3876, 4232, 3987},
  {4107, 3989, 4173},
  {3987, 4232, 4112},
  {4110, 4177, 4175},
  {4175, 4177, 4176},
  {4112, 4236, 4111},
  {4178, 4054, 3988},
  {4234, 4179, 4286},
  {4180, 3992, 4182},
  {4115, 4238, 4114},
  {4238, 4115, 4239},
  {3992, 4183, 4182},
  {4114, 4238, 4116},
  {4113, 4237, 4117},
  {4115, 4186, 4239},
  {4118, 4116, 4290},
  {4118, 4119, 4186},
  {4185, 4057, 4241},
  {4187, 3995, 4242},
  {4057, 4187, 4241},
  {4058, 4186, 3998},
  {4293, 4122, 4123},
  {4060, 4292, 4189},
  {4124, 4000, 4189},
  {4189, 4244, 4124},
  {4004, 4190, 4191},
  {4124, 4193, 4062},
  {4062, 4193, 4002},
  {4002, 4193, 4127},
  {4127, 4194, 4125},
  {4125, 4194, 4245},
  {4128, 4126, 4067},
  {4129, 4005, 4195},
  {4196, 4130, 4248},
  {4130, 4192, 4248},
  {4008, 4251, 4071},
  {4070, 4196, 4252},
  {4247, 3946, 4250},
  {3951, 4250, 3946},
  {4071, 4351, 4300},
  {4250, 3951, 3953},
  {4073, 4133, 4301},
  {4300, 4199, 4072},
  {4011, 4072, 4199},
  {3893, 4200, 4350},
  {4253, 4135, 4199},
  {4134, 4254, 4136},
  {4253, 4201, 4135},
  {4135, 4201, 4013},
  {4202, 4074, 4203},
  {4136, 4303, 4138},
  {4203, 4138, 4303},
  {4255, 4140, 4358},
  {4140, 4255, 3962},
  {4143, 3962, 4255},
  {4143, 4304, 4205},
  {3966, 3901, 4144},
  {3901, 4080, 4144},
  {4018, 4414, 4145},
  {4077, 4257, 4206},
  {4414, 4020, 4258},
  {4206, 4207, 4091},
  {4091, 4207, 4259},
  {4078, 4365, 4084},
  {4080, 4148, 4413},
  {4150, 4413, 4148},
  {4413, 4150, 4149},
  {4210, 4263, 4083},
  {4091, 4259, 4208},
  {4024, 4153, 4261},
  {4151, 4149, 4150},
  {4152, 4260, 3968},
  {4152, 4093, 4307},
  {4023, 4263, 4154},
  {4155, 4266, 4210},
  {4208, 4211, 4156},
  {4029, 4315, 4153},
  {4084, 4269, 4157},
  {4158, 4268, 4319},
  {4031, 4159, 4214},
  {4319, 4213, 4214},
  {4212, 4095, 4270},
  {4159, 4160, 4319},
  {4159, 4319, 4214},
  {4158, 4215, 4216},
  {4215, 4218, 4216},
  {4158, 4216, 4035},
  {4157, 4322, 4161},
  {4035, 4216, 4218},
  {4219, 4035, 4218},
  {4032, 4033, 4163},
  {4162, 4436, 4220},
  {4162, 4220, 4163},
  {4032, 4163, 4220},
  {4480, 4223, 4222},
  {4165, 4436, 4162},
  {4038, 4379, 4168},
  {4167, 4225, 4038},
  {4324, 4098, 4576},
  {4169, 4168, 4325},
  {4226, 4272, 4167},
  {4224, 4326, 4041},
  {4226, 4099, 4272},
  {4326, 4273, 4170},
  {4227, 4170, 4273},
  {4327, 4275, 4102},
  {4274, 4103, 4273},
  {4103, 4227, 4273},
  {4228, 4044, 4172},
  {4045, 4276, 4328},
  {4328, 4383, 4045},
  {4045, 4383, 4048},
  {4048, 4277, 4229},
  {4105, 4104, 4386},
  {4230, 4107, 4173},
  {4230, 4173, 4280},
  {4281, 4280, 4173},
  {4233, 4281, 4173},
  {4108, 4229, 4174},
  {4109, 4233, 4173},
  {4281, 4282, 4234},
  {4281, 4233, 4282},
  {4282, 4233, 4109},
  {4175, 4176, 4444},
  {3990, 4235, 4282},
  {4236, 4285, 4111},
  {4111, 4285, 4113},
  {4237, 4113, 4285},
  {4235, 4179, 4234},
  {4179, 4235, 4180},
  {3990, 4180, 4235},
  {4177, 4335, 4176},
  {4236, 4334, 4285},
  {4178, 4392, 4054},
  {4177, 4181, 4335},
  {4179, 4180, 4182},
  {4054, 4392, 4181},
  {4179, 4182, 4183},
  {4179, 4183, 4288},
  {4337, 4116, 4238},
  {4240, 4183, 4185},
  {4184, 4339, 4055},
  {4242, 4291, 4187},
  {4187, 4291, 4241},
  {4058, 4121, 4186},
  {4122, 4293, 4243},
  {4190, 4294, 4191},
  {4245, 4297, 4192},
  {4244, 4246, 4124},
  {4125, 4245, 4192},
  {4063, 4126, 4296},
  {4063, 4296, 4195},
  {4124, 4246, 4193},
  {4193, 4347, 4127},
  {4127, 4347, 4194},
  {4192, 4297, 4248},
  {4196, 4248, 4348},
  {4068, 4249, 4197},
  {4195, 4249, 4129},
  {4249, 4298, 4197},
  {4196, 4299, 4252},
  {4251, 4351, 4071},
  {4131, 4198, 4402},
  {4403, 4198, 4132},
  {4132, 4301, 4403},
  {4199, 4300, 4253},
  {4133, 4353, 4301},
  {4302, 4353, 4133},
  {4254, 4134, 4252},
  {4133, 4202, 4302},
  {4462, 4200, 4012},
  {4253, 4406, 4201},
  {4202, 4203, 4357},
  {4361, 4146, 4141},
  {4147, 4146, 4361},
  {4360, 4080, 4413},
  {4205, 4305, 4077},
  {4257, 4077, 4305},
  {4206, 4412, 4207},
  {4468, 4207, 4412},
  {4147, 4306, 4078},
  {4259, 4207, 4468},
  {4258, 4024, 4261},
  {4260, 4152, 4262},
  {4259, 4363, 4208},
  {4263, 4210, 4368},
  {4208, 4363, 4211},
  {4265, 4264, 4027},
  {4265, 4209, 4420},
  {4263, 4209, 4154},
  {4153, 4315, 4311},
  {4267, 4315, 4156},
  {4211, 4267, 4156},
  {4031, 4214, 4268},
  {4213, 4268, 4214},
  {4319, 4268, 4213},
  {4211, 4320, 4318},
  {4269, 4322, 4157},
  {4158, 4319, 4215},
  {4095, 4217, 4270},
  {4375, 4270, 4217},
  {4322, 4376, 4161},
  {4160, 4161, 4432},
  {4271, 4217, 4032},
  {4220, 4271, 4032},
  {4378, 4221, 4164},
  {4377, 4480, 4222},
  {4222, 4166, 4377},
  {4166, 4219, 4377},
  {4164, 4223, 4378},
  {4325, 4168, 4379},
  {4225, 4379, 4038},
  {4169, 4576, 4098},
  {4382, 4273, 4326},
  {4272, 4101, 4275},
  {4274, 4327, 4171},
  {4171, 4327, 4102},
  {4172, 4278, 4487},
  {4228, 4172, 4487},
  {4048, 4383, 4277},
  {4228, 4487, 4104},
  {4386, 4104, 4438},
  {4276, 4050, 4279},
  {4278, 4230, 4385},
  {4230, 4280, 4385},
  {4105, 4386, 4231},
  {4232, 4331, 4441},
  {4229, 4439, 4492},
  {4229, 4492, 4174},
  {4280, 4281, 4442},
  {4232, 4333, 4112},
  {4174, 4390, 4178},
  {4112, 4333, 4283},
  {4235, 4234, 4282},
  {4112, 4283, 4391},
  {4284, 4234, 4286},
  {4178, 4390, 4392},
  {4176, 4287, 4444},
  {4176, 4335, 4287},
  {4112, 4391, 4236},
  {4238, 4334, 4236},
  {4239, 4289, 4238},
  {4238, 4289, 4334},
  {4286, 4179, 4288},
  {4237, 4393, 4184},
  {4237, 4184, 4117},
  {4288, 4183, 4336},
  {4289, 4239, 4393},
  {4240, 4336, 4183},
  {4120, 4055, 4339},
  {4240, 4185, 4241},
  {4116, 4341, 4290},
  {4239, 4186, 4340},
  {4120, 4339, 4340},
  {4186, 4121, 4340},
  {4121, 4120, 4340},
  {4188, 4290, 4342},
  {4122, 4243, 4242},
  {4188, 4342, 4343},
  {4060, 4188, 4343},
  {4243, 4293, 4344},
  {4292, 4449, 4189},
  {4189, 4450, 4244},
  {4345, 4244, 4450},
  {4293, 4191, 4294},
  {4191, 4293, 4123},
  {4244, 4345, 4246},
  {4295, 4194, 4347},
  {4295, 4245, 4194},
  {4126, 4398, 4296},
  {4347, 4193, 4246},
  {4249, 4195, 4349},
  {4401, 4251, 4131},
  {4402, 4401, 4131},
  {4401, 4351, 4251},
  {3891, 4350, 4250},
  {4254, 4252, 4352},
  {4354, 4254, 4352},
  {4254, 4354, 4136},
  {4303, 4136, 4354},
  {4556, 4355, 4137},
  {5906, 4358, 4140},
  {4410, 4139, 4204},
  {4255, 4304, 4143},
  {4204, 4359, 4410},
  {4204, 4142, 4359},
  {4144, 4359, 4142},
  {4304, 4305, 4205},
  {4257, 4412, 4206},
  {4413, 4260, 4362},
  {4262, 4152, 4307},
  {4262, 4307, 4366},
  {4366, 4307, 4417},
  {4368, 4210, 4308},
  {4367, 4209, 4263},
  {4420, 4209, 4367},
  {4308, 4210, 4266},
  {4308, 4266, 4309},
  {4309, 4266, 4310},
  {4312, 4421, 4369},
  {4312, 4369, 4310},
  {4309, 4310, 4369},
  {4311, 4261, 4153},
  {4269, 4084, 4365},
  {4307, 4093, 4264},
  {4307, 4264, 4474},
  {4264, 4265, 4474},
  {4310, 4266, 4313},
  {4312, 4310, 4314},
  {4424, 4269, 4365},
  {4312, 4314, 4317},
  {4312, 4317, 4370},
  {4320, 4211, 4371},
  {4310, 4313, 4316},
  {4310, 4316, 4314},
  {4212, 4321, 4266},
  {4266, 4321, 4313},
  {4313, 4321, 4316},
  {4316, 4373, 4314},
  {4314, 4373, 4317},
  {4211, 4318, 4267},
  {4267, 4318, 4522},
  {4212, 4270, 4321},
  {4215, 4319, 4160},
  {4429, 4215, 4160},
  {4218, 4215, 4429},
  {4218, 4429, 4219},
  {4220, 4435, 4271},
  {4271, 4435, 4323},
  {4271, 4323, 4217},
  {4097, 4221, 4479},
  {4667, 4479, 4221},
  {4097, 4479, 4224},
  {4324, 4436, 4165},
  {4380, 4379, 4225},
  {4325, 4576, 4169},
  {4167, 4380, 4225},
  {4224, 4482, 4326},
  {4275, 4381, 4272},
  {4273, 4327, 4274},
  {4383, 4329, 4277},
  {4277, 4329, 4229},
  {4279, 4231, 4384},
  {4229, 4329, 4439},
  {4442, 4281, 4387},
  {4175, 4332, 4330},
  {4234, 4284, 4281},
  {4284, 4286, 4446},
  {4236, 4391, 4238},
  {4334, 4237, 4285},
  {4334, 4289, 4237},
  {4181, 4392, 4335},
  {4336, 4447, 4288},
  {4184, 4393, 4339},
  {4336, 4240, 4394},
  {4239, 4340, 4393},
  {4116, 4338, 4341},
  {4341, 4342, 4290},
  {4242, 4243, 4395},
  {4242, 4395, 4291},
  {4291, 4395, 4498},
  {4344, 4395, 4243},
  {4292, 4060, 4448},
  {4190, 4453, 4294},
  {4293, 4294, 4396},
  {4189, 4449, 4450},
  {4295, 4297, 4245},
  {4295, 4397, 4297},
  {4345, 4454, 4246},
  {4347, 4454, 4295},
  {4190, 4065, 4346},
  {4246, 4454, 4347},
  {4065, 4298, 4346},
  {4126, 4128, 4398},
  {4248, 4297, 4348},
  {4195, 4296, 4349},
  {4128, 4247, 4455},
  {4298, 4249, 4399},
  {4196, 4348, 4299},
  {4348, 4400, 4299},
  {4198, 4403, 4402},
  {4299, 4352, 4252},
  {4406, 4253, 4404},
  {4352, 4508, 4354},
  {4200, 4728, 4350},
  {4302, 4202, 4555},
  {4354, 4405, 4303},
  {4406, 4407, 4201},
  {4356, 4201, 4407},
  {4355, 4012, 4137},
  {4201, 4356, 5906},
  {4356, 4358, 5906},
  {4255, 4409, 4304},
  {4557, 4304, 4409},
  {4304, 4557, 4411},
  {4304, 4411, 4305},
  {4510, 4141, 4256},
  {4141, 4510, 4361},
  {4510, 4256, 4145},
  {4305, 4467, 4257},
  {4257, 4467, 4412},
  {4145, 4414, 4510},
  {4147, 4361, 4415},
  {4147, 4415, 4306},
  {4468, 4363, 4259},
  {4078, 4306, 4365},
  {4258, 4261, 4469},
  {4364, 4362, 4260},
  {4262, 4364, 4260},
  {4368, 4516, 4263},
  {4368, 4308, 4418},
  {4309, 4418, 4308},
  {4421, 4312, 4370},
  {4211, 4363, 4371},
  {4265, 4420, 4519},
  {4371, 4425, 4320},
  {4320, 4425, 4372},
  {4315, 4267, 4522},
  {4269, 4424, 4427},
  {4316, 4321, 4373},
  {4317, 4373, 4431},
  {4321, 4270, 4374},
  {4270, 4375, 4433},
  {4429, 4160, 4432},
  {4161, 4376, 4432},
  {4477, 4377, 4219},
  {4434, 4217, 4323},
  {4436, 4435, 4220},
  {4223, 4478, 4378},
  {4380, 4167, 4381},
  {4381, 4167, 4272},
  {4437, 4328, 4276},
  {4328, 4488, 4383},
  {4487, 4278, 4529},
  {4104, 4487, 4438},
  {4437, 4276, 4384},
  {4279, 4384, 4276},
  {4442, 4385, 4280},
  {4443, 4232, 4441},
  {4444, 4332, 4175},
  {4284, 4387, 4281},
  {4492, 4388, 4174},
  {4333, 4632, 4283},
  {4446, 4493, 4284},
  {4388, 4389, 4174},
  {4390, 4174, 4389},
  {4389, 4388, 4390},
  {4391, 4445, 4238},
  {4286, 4288, 4447},
  {4286, 4447, 4446},
  {4337, 4238, 4445},
  {4237, 4289, 4393},
  {4392, 4495, 4335},
  {4447, 4336, 4496},
  {4336, 4394, 4496},
  {4394, 4240, 4241},
  {4337, 4338, 4116},
  {4338, 4337, 4341},
  {4393, 4340, 4339},
  {4343, 4342, 4584},
  {4343, 4448, 4060},
  {4344, 4293, 4396},
  {4345, 4451, 4499},
  {4450, 4451, 4345},
  {4190, 4346, 4453},
  {4294, 4500, 4396},
  {4452, 4295, 4454},
  {4397, 4295, 4452},
  {4346, 4298, 4399},
  {4398, 4504, 4296},
  {4397, 4348, 4297},
  {4349, 4296, 4504},
  {4398, 4128, 4503},
  {4457, 4399, 4249},
  {4349, 4457, 4249},
  {4352, 4299, 4400},
  {4352, 4400, 4456},
  {4351, 4401, 4459},
  {4551, 4403, 4301},
  {4300, 4351, 4549},
  {4300, 4549, 4460},
  {4301, 4353, 4551},
  {4302, 4551, 4353},
  {4508, 4405, 4354},
  {4460, 4404, 4253},
  {4253, 4300, 4460},
  {4357, 4408, 4202},
  {4357, 4203, 4464},
  {4303, 4464, 4203},
  {4463, 4464, 4303},
  {4303, 4405, 4463},
  {4137, 4139, 4465},
  {4409, 4255, 4358},
  {4144, 4360, 4604},
  {4467, 4305, 4466},
  {4306, 4415, 4416},
  {4262, 4366, 4417},
  {4262, 4417, 4470},
  {4262, 4470, 4364},
  {4306, 4416, 4365},
  {4309, 4369, 4472},
  {4365, 4416, 4424},
  {4367, 4263, 4514},
  {4263, 4516, 4514},
  {4369, 4421, 4472},
  {4363, 4419, 4371},
  {4425, 4371, 4419},
  {4265, 4519, 4474},
  {4370, 4426, 4422},
  {4370, 4317, 4426},
  {4315, 4423, 4311},
  {4523, 4427, 4424},
  {4372, 4428, 4525},
  {4320, 4372, 4524},
  {4320, 4524, 4318},
  {4269, 4427, 4322},
  {4429, 4430, 4219},
  {4321, 4374, 4373},
  {4270, 4433, 4374},
  {4374, 4570, 4373},
  {4375, 4572, 4433},
  {4572, 4375, 4434},
  {4217, 4434, 4375},
  {4323, 4574, 4434},
  {4378, 4667, 4221},
  {4224, 4479, 4482},
  {4481, 4478, 4223},
  {4528, 4380, 4381},
  {4483, 4326, 4482},
  {4381, 4275, 4484},
  {4382, 4485, 4273},
  {4327, 4273, 4485},
  {4437, 4488, 4328},
  {4329, 4488, 4439},
  {4490, 4439, 4488},
  {4278, 4385, 4530},
  {4384, 4231, 4532},
  {4330, 4533, 4331},
  {4441, 4331, 4533},
  {4440, 4231, 4386},
  {4489, 4231, 4440},
  {4532, 4231, 4489},
  {4332, 4444, 4579},
  {4387, 4284, 4493},
  {4333, 4232, 4443},
  {4333, 4443, 4632},
  {4391, 4283, 4632},
  {4492, 4494, 4390},
  {4492, 4390, 4388},
  {4392, 4390, 4494},
  {4497, 4496, 4394},
  {4394, 4241, 4497},
  {4241, 4291, 4497},
  {4341, 4635, 4342},
  {4395, 4344, 4536},
  {4344, 4396, 4641},
  {4448, 4587, 4292},
  {4449, 4538, 4450},
  {4450, 4538, 4451},
  {4586, 4452, 4454},
  {4294, 4453, 4500},
  {4499, 4454, 4345},
  {4452, 4541, 4397},
  {4397, 4541, 4348},
  {4503, 4128, 4455},
  {4455, 4247, 4546},
  {4349, 4504, 4545},
  {4502, 4505, 4507},
  {4456, 4400, 4348},
  {4399, 4457, 4543},
  {4250, 4506, 4247},
  {4456, 4508, 4352},
  {4351, 4461, 4549},
  {4351, 4459, 4461},
  {4401, 4402, 4554},
  {4401, 4554, 4459},
  {4598, 4463, 4458},
  {4458, 4463, 4405},
  {4458, 4405, 4508},
  {4463, 4598, 4509},
  {4302, 4555, 4552},
  {4728, 4200, 4462},
  {4462, 4012, 4355},
  {4202, 4408, 4555},
  {4358, 4356, 4553},
  {4357, 4464, 4408},
  {4556, 4137, 4465},
  {4600, 4409, 4358},
  {4359, 4144, 4603},
  {4604, 4603, 4144},
  {4411, 4655, 4466},
  {4411, 4466, 4305},
  {4363, 4468, 4471},
  {4416, 4415, 4560},
  {4511, 4362, 4364},
  {4363, 4471, 4419},
  {4472, 4611, 4418},
  {4418, 4611, 4563},
  {4474, 4417, 4307},
  {4517, 4516, 4368},
  {4368, 4418, 4517},
  {4563, 4517, 4418},
  {4418, 4309, 4472},
  {4473, 4472, 4421},
  {4370, 4473, 4421},
  {4473, 4370, 4518},
  {4370, 4422, 4518},
  {4475, 4518, 4422},
  {4419, 4513, 4425},
  {4311, 4423, 4562},
  {4311, 4562, 4261},
  {4426, 4475, 4422},
  {4522, 4423, 4315},
  {4475, 4426, 4476},
  {4318, 4621, 4522},
  {4318, 4524, 4621},
  {4427, 4526, 4322},
  {4429, 4477, 4430},
  {4429, 4432, 4477},
  {4430, 4477, 4219},
  {4431, 4373, 4570},
  {4433, 4570, 4374},
  {4322, 4527, 4376},
  {4378, 4478, 4667},
  {4323, 4435, 4574},
  {4480, 4481, 4223},
  {4627, 4576, 4325},
  {4325, 4379, 4627},
  {4576, 4436, 4324},
  {4381, 4484, 4528},
  {4326, 4483, 4382},
  {4327, 4484, 4275},
  {4484, 4327, 4577},
  {4577, 4327, 4485},
  {5911, 4487, 4529},
  {4329, 4383, 4488},
  {4530, 4529, 4278},
  {4384, 4486, 4437},
  {4438, 4531, 4386},
  {4385, 4442, 4530},
  {4439, 4490, 4492},
  {4442, 4387, 4491},
  {4493, 4491, 4387},
  {4441, 4630, 4443},
  {4493, 4446, 4680},
  {4632, 4445, 4391},
  {4631, 4287, 4335},
  {4495, 4631, 4335},
  {4392, 4580, 4495},
  {4496, 4497, 4583},
  {4337, 4534, 4341},
  {4534, 4582, 4341},
  {4497, 4291, 4535},
  {4291, 4498, 4535},
  {4536, 4344, 4585},
  {4448, 4638, 4587},
  {4344, 4641, 4585},
  {4451, 4537, 4499},
  {4587, 4449, 4292},
  {4499, 4586, 4454},
  {4589, 4453, 4346},
  {4502, 4541, 4501},
  {4502, 4501, 4505},
  {4541, 4502, 4547},
  {4543, 4346, 4399},
  {4398, 4503, 4504},
  {4502, 4508, 4547},
  {4348, 4547, 4456},
  {4545, 4457, 4349},
  {4508, 4502, 4507},
  {4350, 4506, 4250},
  {4505, 4598, 4507},
  {4458, 4507, 4598},
  {4507, 4458, 4508},
  {4402, 4403, 4599},
  {4652, 4461, 4459},
  {4903, 4728, 4462},
  {4602, 4555, 4408},
  {4463, 4509, 4464},
  {4355, 4556, 4462},
  {4553, 4600, 4358},
  {4557, 4655, 4411},
  {4359, 4603, 4410},
  {4467, 4466, 4558},
  {4467, 4468, 4412},
  {4560, 4361, 4510},
  {4362, 4559, 4413},
  {4415, 4361, 4560},
  {4511, 4364, 4470},
  {4511, 4470, 4656},
  {4469, 4261, 4657},
  {4417, 4512, 4470},
  {4471, 4513, 4419},
  {4417, 4474, 4512},
  {4515, 4367, 4514},
  {4472, 4473, 4564},
  {4473, 4518, 4564},
  {4261, 4562, 4657},
  {4367, 4515, 4420},
  {4513, 4565, 4425},
  {4566, 4425, 4565},
  {4475, 4476, 4567},
  {4617, 4423, 4522},
  {4424, 4416, 4520},
  {4425, 4566, 4521},
  {4424, 4520, 4523},
  {4431, 4624, 5907},
  {4569, 5907, 4624},
  {4376, 4573, 4432},
  {4477, 4432, 4377},
  {4829, 4433, 4572},
  {4322, 4526, 4527},
  {4376, 4527, 4571},
  {4574, 4572, 4434},
  {4626, 4480, 4377},
  {4626, 4377, 4573},
  {4668, 4435, 4436},
  {4481, 4480, 4626},
  {4482, 4479, 4628},
  {4482, 4628, 4629},
  {4482, 4629, 4483},
  {4673, 4382, 4483},
  {4485, 4382, 4673},
  {4437, 4486, 4578},
  {4437, 4578, 4488},
  {4487, 5911, 4438},
  {4384, 4532, 4486},
  {4530, 4442, 4491},
  {4532, 4489, 4440},
  {4330, 4332, 4579},
  {4580, 4392, 4494},
  {4446, 4447, 4581},
  {4446, 4581, 4714},
  {4445, 4534, 4337},
  {4582, 4635, 4341},
  {4637, 4584, 4342},
  {4395, 4684, 4498},
  {4395, 4536, 4684},
  {4396, 4500, 4641},
  {4642, 4641, 4500},
  {4642, 4453, 4589},
  {4453, 4642, 4500},
  {4590, 4538, 4449},
  {4537, 4542, 4539},
  {4537, 4451, 4540},
  {4542, 4537, 4540},
  {4544, 4539, 4542},
  {4543, 4589, 4346},
  {4540, 4593, 4542},
  {4503, 4455, 4592},
  {4643, 4544, 4646},
  {4542, 4593, 4544},
  {4545, 4504, 4687},
  {4247, 4506, 4546},
  {4593, 4595, 4544},
  {4543, 4457, 4548},
  {4543, 4548, 4647},
  {4457, 4596, 4548},
  {4457, 4545, 4596},
  {4508, 4456, 4547},
  {4404, 4460, 4650},
  {4406, 4404, 4650},
  {4460, 4549, 4597},
  {4403, 4551, 4599},
  {4551, 4302, 4552},
  {4406, 4550, 4407},
  {4553, 4407, 4550},
  {4407, 4553, 4356},
  {4408, 4464, 4601},
  {4509, 4601, 4464},
  {4600, 4693, 4409},
  {4654, 4409, 4693},
  {4654, 4557, 4409},
  {4655, 4697, 4466},
  {4466, 4697, 4558},
  {4467, 4558, 4468},
  {4559, 4605, 4413},
  {4511, 4559, 4362},
  {4468, 4698, 4606},
  {4468, 4606, 4471},
  {4258, 4469, 4778},
  {4513, 4471, 4561},
  {4513, 4561, 4608},
  {4470, 4512, 4610},
  {4514, 4516, 4659},
  {4516, 4517, 4659},
  {4563, 4659, 4517},
  {4564, 4612, 4472},
  {4518, 4475, 4662},
  {4608, 4565, 4513},
  {4619, 4519, 4515},
  {4420, 4515, 4519},
  {4615, 4662, 4475},
  {4565, 4616, 4566},
  {4566, 4616, 4567},
  {4566, 4567, 4521},
  {4567, 4476, 5908},
  {4372, 4525, 4524},
  {4827, 4524, 4525},
  {4427, 4523, 4526},
  {4573, 4377, 4432},
  {4431, 4570, 4624},
  {4526, 4705, 4527},
  {4574, 4789, 4572},
  {4573, 4625, 4626},
  {4478, 4481, 4669},
  {4481, 4626, 4669},
  {4436, 4575, 4668},
  {4379, 4380, 4671},
  {4379, 4671, 4627},
  {4436, 4576, 4575},
  {4673, 4483, 4629},
  {4484, 4577, 4672},
  {4485, 4674, 4577},
  {4532, 4675, 4486},
  {4438, 4844, 4531},
  {4488, 4578, 4676},
  {4530, 4491, 4709},
  {4440, 4386, 4532},
  {4533, 4630, 4441},
  {4490, 4710, 4492},
  {4444, 4631, 4678},
  {4444, 4678, 4579},
  {4287, 4631, 4444},
  {4633, 4445, 4632},
  {4494, 4717, 4580},
  {4580, 4634, 4495},
  {4495, 4681, 4631},
  {4534, 4445, 4633},
  {4496, 4581, 4447},
  {4496, 4583, 4683},
  {4534, 4633, 4582},
  {4497, 4535, 4583},
  {4342, 4635, 4637},
  {4535, 4498, 4684},
  {4343, 4638, 4448},
  {4343, 4584, 4638},
  {4537, 4640, 4499},
  {4499, 4640, 4586},
  {4537, 4539, 4640},
  {4587, 4590, 4449},
  {4643, 4541, 4588},
  {4586, 4541, 4452},
  {4539, 4544, 4643},
  {4501, 4541, 4643},
  {4538, 4590, 4591},
  {4538, 4591, 4540},
  {4538, 4540, 4451},
  {4645, 4589, 4543},
  {4593, 4540, 4591},
  {4646, 4501, 4643},
  {4647, 4645, 4543},
  {4504, 4503, 4592},
  {4541, 4547, 4348},
  {4546, 4861, 4455},
  {4501, 4646, 4648},
  {4594, 4544, 4595},
  {4544, 4594, 4646},
  {4501, 4648, 4505},
  {4548, 4596, 4724},
  {4505, 4648, 4598},
  {4548, 4724, 4759},
  {4506, 4350, 4727},
  {4597, 4650, 4460},
  {4597, 4549, 4651},
  {4406, 4650, 4550},
  {4649, 4550, 4650},
  {4549, 4461, 4651},
  {4690, 4651, 4461},
  {4652, 4690, 4461},
  {4402, 4599, 4554},
  {4599, 4551, 4653},
  {4554, 4599, 4730},
  {4694, 4552, 4555},
  {4509, 4692, 4601},
  {4556, 4465, 4768},
  {4462, 4556, 4810},
  {4465, 4139, 4696},
  {4139, 4410, 4696},
  {4557, 4654, 4655},
  {4360, 5910, 4604},
  {4558, 4731, 4468},
  {4360, 4413, 4605},
  {4605, 4559, 4779},
  {4731, 4698, 4468},
  {4414, 4560, 4510},
  {4414, 4258, 4778},
  {4607, 4561, 4471},
  {4607, 4471, 4606},
  {4607, 4732, 4561},
  {4608, 4561, 4732},
  {4470, 4610, 4609},
  {4470, 4609, 4656},
  {4737, 4416, 4733},
  {4563, 4611, 4660},
  {4611, 4472, 4612},
  {4564, 4661, 4612},
  {4564, 4518, 4661},
  {4512, 4474, 4701},
  {4512, 4701, 4610},
  {4514, 4659, 4614},
  {4514, 4614, 4702},
  {4518, 4662, 4661},
  {4615, 4658, 4662},
  {4658, 4615, 4616},
  {4658, 4616, 4613},
  {4613, 4616, 4565},
  {4613, 4565, 4608},
  {4615, 4475, 4616},
  {4562, 4423, 4617},
  {4416, 4737, 4520},
  {4618, 4520, 4737},
  {4474, 4519, 4619},
  {4474, 4619, 4701},
  {4475, 4567, 4616},
  {4523, 4520, 4618},
  {4522, 4620, 4617},
  {4567, 5908, 4521},
  {4523, 4618, 4704},
  {4428, 4665, 4525},
  {4622, 4526, 4523},
  {4569, 4788, 4623},
  {4705, 4526, 4622},
  {4788, 4569, 4624},
  {4433, 4666, 4570},
  {4571, 4625, 4376},
  {4376, 4625, 4573},
  {4668, 4574, 4435},
  {4479, 4667, 4706},
  {4670, 4668, 4575},
  {4575, 4576, 4670},
  {4528, 4671, 4380},
  {4528, 4484, 4672},
  {4485, 4673, 4674},
  {4486, 4675, 4707},
  {4529, 4530, 4794},
  {4529, 4794, 5911},
  {4488, 4676, 4490},
  {4386, 4708, 4532},
  {4491, 4493, 4677},
  {4491, 4677, 4709},
  {4630, 4713, 4443},
  {4681, 4745, 4631},
  {4492, 4679, 4494},
  {4446, 4714, 4680},
  {4681, 4495, 4634},
  {4634, 4580, 4717},
  {4496, 4720, 4581},
  {4496, 4683, 4720},
  {4582, 4633, 4636},
  {4684, 4583, 4535},
  {4639, 4638, 4584},
  {4638, 4639, 4587},
  {4585, 4721, 4536},
  {4639, 4756, 4587},
  {4541, 4586, 4588},
  {4643, 4640, 4539},
  {4589, 4644, 4642},
  {4590, 4587, 4758},
  {4589, 4645, 4644},
  {4590, 4686, 4591},
  {4504, 4592, 4687},
  {4592, 4455, 4685},
  {4804, 4685, 4455},
  {4591, 4686, 4593},
  {4646, 4594, 4648},
  {4546, 4506, 4725},
  {4594, 4595, 4689},
  {4759, 4724, 4805},
  {4595, 4723, 4689},
  {4649, 4764, 4550},
  {4598, 4691, 4509},
  {4764, 4553, 4550},
  {4652, 4459, 4554},
  {4692, 4509, 4691},
  {4462, 4810, 4903},
  {4552, 4694, 4695},
  {4552, 4695, 4551},
  {4764, 4600, 4553},
  {4599, 4653, 4730},
  {4602, 4601, 4692},
  {4601, 4602, 4408},
  {4556, 4768, 4810},
  {4602, 4694, 4555},
  {4697, 4731, 4558},
  {4559, 4511, 4779},
  {4606, 4732, 4607},
  {4416, 4560, 4733},
  {4608, 4732, 4734},
  {4613, 4734, 4658},
  {4734, 4613, 4608},
  {4660, 4659, 4563},
  {4611, 4612, 4699},
  {4612, 4661, 4700},
  {4662, 4658, 4734},
  {4617, 4824, 4562},
  {4702, 4515, 4514},
  {4515, 4703, 4619},
  {4737, 4663, 4618},
  {4704, 4618, 4664},
  {4663, 4664, 4618},
  {4621, 4620, 4522},
  {4827, 4621, 4524},
  {4525, 4877, 4827},
  {4665, 4877, 4525},
  {4523, 4704, 4622},
  {4568, 4958, 4665},
  {4571, 4527, 4705},
  {4478, 4669, 4667},
  {4628, 4479, 4706},
  {4628, 4834, 4629},
  {4528, 4672, 4671},
  {4486, 4707, 4578},
  {4884, 4578, 4707},
  {4844, 4438, 5911},
  {4675, 4532, 4708},
  {4531, 4708, 4386},
  {4676, 4743, 4490},
  {4579, 4744, 4330},
  {4579, 4678, 4744},
  {4330, 4711, 4533},
  {4533, 4711, 4630},
  {4679, 4492, 4710},
  {4745, 4678, 4631},
  {4717, 4494, 4679},
  {4718, 4681, 4634},
  {4636, 4633, 4715},
  {4635, 4582, 4636},
  {4684, 4683, 4583},
  {4754, 4637, 4635},
  {4584, 4637, 4639},
  {4639, 4637, 4801},
  {4641, 4800, 4585},
  {4640, 4643, 4588},
  {4686, 4722, 4593},
  {4687, 4592, 4685},
  {4647, 4548, 4759},
  {4545, 4687, 4688},
  {4723, 4595, 4760},
  {4596, 4545, 4688},
  {4598, 4648, 4689},
  {4596, 4688, 4724},
  {4506, 4727, 4726},
  {4723, 4806, 4689},
  {4350, 4728, 4727},
  {4649, 4650, 4807},
  {4597, 4651, 4763},
  {4598, 4689, 4691},
  {4651, 4690, 4763},
  {4554, 4729, 4652},
  {4729, 4554, 4730},
  {4693, 4600, 4764},
  {4695, 4653, 4551},
  {4465, 4696, 4768},
  {4812, 4694, 4602},
  {4813, 4655, 4654},
  {4410, 4603, 4770},
  {4771, 4770, 4603},
  {4656, 4779, 4511},
  {4414, 4733, 4560},
  {4414, 4778, 4733},
  {4469, 4657, 4778},
  {4821, 4657, 4562},
  {4611, 4783, 4660},
  {4609, 4610, 4784},
  {4700, 4699, 4612},
  {4661, 4662, 4736},
  {4662, 4734, 4736},
  {4562, 4824, 4821},
  {4515, 4702, 4703},
  {4701, 4619, 4703},
  {4664, 4663, 4738},
  {4664, 4738, 4704},
  {4829, 4666, 4433},
  {4624, 4570, 4923},
  {4624, 4923, 4788},
  {4571, 4705, 4625},
  {4574, 5912, 4789},
  {4668, 5912, 4574},
  {4626, 4836, 4669},
  {4576, 4627, 4790},
  {4627, 4671, 4790},
  {4576, 4790, 4670},
  {4673, 4629, 4791},
  {4742, 4674, 4673},
  {4672, 4577, 4674},
  {4490, 4743, 4710},
  {4330, 4744, 4711},
  {4630, 4711, 4849},
  {4712, 4709, 4677},
  {4493, 4712, 4677},
  {4679, 4710, 4746},
  {4680, 4712, 4493},
  {4630, 4849, 4713},
  {4443, 4713, 4632},
  {4712, 4680, 4889},
  {4679, 4746, 4717},
  {4716, 4632, 4749},
  {4632, 4713, 4749},
  {4632, 4716, 4715},
  {4681, 4718, 4745},
  {4750, 4714, 4581},
  {4632, 4715, 4633},
  {4634, 4719, 4682},
  {4634, 4717, 4719},
  {4718, 4796, 4745},
  {4682, 4719, 4891},
  {4634, 4752, 4718},
  {4682, 4891, 4634},
  {4683, 4751, 4720},
  {4635, 4636, 4754},
  {4636, 4797, 4754},
  {4637, 4754, 4798},
  {4637, 4798, 4799},
  {4637, 4799, 4755},
  {4684, 4536, 4721},
  {4637, 4755, 4801},
  {4640, 4588, 4586},
  {4644, 4802, 4642},
  {4644, 4757, 4802},
  {4644, 4645, 4757},
  {4590, 4803, 4686},
  {4722, 4760, 4593},
  {4804, 4455, 4861},
  {4593, 4760, 4595},
  {4594, 4689, 4648},
  {4724, 4688, 4762},
  {4506, 4726, 4725},
  {4808, 4807, 4650},
  {4650, 4597, 4808},
  {4806, 4766, 4689},
  {4763, 4808, 4597},
  {4763, 4690, 4765},
  {4729, 4690, 4652},
  {4764, 4769, 4693},
  {4693, 4813, 4654},
  {4696, 4410, 4770},
  {4655, 4869, 4697},
  {4697, 4909, 4731},
  {4603, 4604, 4771},
  {4772, 4698, 4731},
  {4698, 4774, 4606},
  {4606, 4774, 4732},
  {4778, 4657, 4777},
  {4656, 4609, 4782},
  {4656, 4782, 4872},
  {4734, 4781, 4736},
  {4659, 4785, 4614},
  {4659, 4660, 4735},
  {4611, 4699, 4783},
  {4699, 4700, 4917},
  {4610, 4701, 4784},
  {4702, 4614, 4785},
  {4702, 4876, 4703},
  {4824, 4617, 4786},
  {4737, 4821, 4663},
  {4617, 4620, 4786},
  {4663, 4821, 4738},
  {4738, 4739, 4787},
  {4738, 4787, 4704},
  {4622, 4704, 4787},
  {4666, 4924, 4570},
  {4740, 4705, 4830},
  {4625, 4705, 4626},
  {4834, 4706, 4831},
  {4706, 4667, 4831},
  {4705, 4740, 4626},
  {4706, 4834, 4628},
  {4667, 4669, 4832},
  {4740, 4836, 4626},
  {4835, 4836, 4740},
  {4834, 4791, 4629},
  {4839, 5912, 4670},
  {4841, 4742, 4927},
  {4791, 4927, 4742},
  {4790, 4671, 4741},
  {4672, 4741, 4671},
  {4791, 4742, 4673},
  {4793, 5911, 4882},
  {4844, 5911, 4793},
  {4708, 4842, 4675},
  {4709, 4794, 4530},
  {4578, 4884, 4676},
  {4531, 4844, 4708},
  {4884, 4743, 4676},
  {4711, 4744, 4849},
  {4678, 4745, 4847},
  {4849, 4850, 4713},
  {4713, 4795, 4749},
  {4748, 4747, 4749},
  {4749, 4748, 4716},
  {4747, 4749, 4748},
  {4716, 4748, 4795},
  {4748, 4749, 4795},
  {4750, 4581, 4854},
  {4716, 4795, 4797},
  {4716, 4797, 4715},
  {4719, 4717, 4891},
  {4720, 4854, 4581},
  {4891, 4752, 4634},
  {4718, 4752, 4796},
  {4751, 4683, 4753},
  {4797, 4636, 4715},
  {4683, 4684, 4753},
  {4755, 4799, 4895},
  {4585, 4800, 4721},
  {4641, 4642, 4802},
  {4803, 4590, 4758},
  {4645, 4647, 4759},
  {4722, 4686, 4803},
  {4858, 4760, 4722},
  {4761, 4687, 4685},
  {4723, 4760, 4860},
  {4688, 4687, 4761},
  {5035, 4861, 4546},
  {4762, 4805, 4724},
  {4761, 4762, 4688},
  {4726, 4727, 4725},
  {4903, 5111, 4728},
  {4767, 4689, 4766},
  {4689, 4767, 4691},
  {4691, 4767, 4692},
  {4729, 4730, 4865},
  {4692, 4812, 4602},
  {4693, 4769, 4813},
  {4696, 4770, 4944},
  {4868, 4695, 4694},
  {4694, 4812, 4868},
  {4771, 4604, 4818},
  {4772, 4774, 4698},
  {4776, 4775, 4778},
  {4775, 4777, 4778},
  {4732, 4774, 4780},
  {4657, 4737, 4777},
  {4780, 4734, 4732},
  {4657, 4821, 4737},
  {4733, 4777, 4737},
  {4781, 4819, 4736},
  {4660, 4783, 4735},
  {4736, 4819, 4661},
  {4659, 4735, 4785},
  {4735, 4783, 4915},
  {4661, 4873, 4700},
  {4784, 4822, 4609},
  {4702, 4785, 4823},
  {4917, 4700, 4873},
  {4701, 4703, 4875},
  {4620, 4826, 4786},
  {4920, 4786, 4826},
  {4821, 4825, 4738},
  {4739, 4738, 4825},
  {4620, 4621, 4826},
  {4827, 4826, 4621},
  {4665, 4958, 4877},
  {4958, 4623, 4788},
  {4623, 4958, 4568},
  {4622, 4787, 4828},
  {4622, 4828, 4705},
  {4572, 4789, 4829},
  {4832, 4831, 4667},
  {4881, 4740, 4830},
  {4833, 4832, 4669},
  {4669, 4836, 4833},
  {4668, 4670, 5912},
  {4670, 4790, 4839},
  {4841, 4927, 4880},
  {4790, 4741, 4792},
  {4792, 4741, 4840},
  {4792, 4840, 4790},
  {4674, 4742, 4841},
  {4741, 4672, 4840},
  {4840, 4672, 4841},
  {4672, 4674, 4841},
  {4884, 4707, 4883},
  {4794, 4709, 4845},
  {4710, 4743, 4846},
  {4709, 4712, 4887},
  {4680, 4714, 4889},
  {4855, 4795, 4852},
  {4795, 4855, 4797},
  {4717, 4851, 4891},
  {4796, 4853, 4745},
  {4751, 4854, 4720},
  {4796, 4752, 4891},
  {4855, 4754, 4797},
  {4753, 4684, 4856},
  {4684, 4721, 4856},
  {4801, 4756, 4639},
  {4641, 4857, 4800},
  {4641, 4802, 4857},
  {4896, 4587, 4756},
  {4758, 4587, 4896},
  {4859, 4897, 4757},
  {4758, 5030, 4803},
  {4645, 4759, 4757},
  {4859, 4757, 4759},
  {4899, 4859, 4759},
  {4685, 4804, 4761},
  {4759, 4805, 4899},
  {4546, 4725, 5035},
  {4809, 4762, 4761},
  {4649, 4807, 4904},
  {4649, 4904, 4764},
  {4808, 4763, 4936},
  {4762, 4809, 4863},
  {4864, 4763, 4765},
  {4865, 4864, 4765},
  {4690, 4865, 4765},
  {4766, 4811, 4767},
  {4766, 4981, 4811},
  {4865, 4730, 4906},
  {4866, 4730, 4653},
  {4812, 4692, 4767},
  {4767, 4811, 4812},
  {4768, 4696, 4944},
  {4814, 4817, 4815},
  {4817, 4815, 4814},
  {4814, 5236, 4816},
  {4814, 4816, 4817},
  {4814, 4817, 5236},
  {4818, 4773, 4871},
  {4731, 4910, 4772},
  {4772, 4870, 4774},
  {4773, 4779, 4871},
  {4775, 4777, 4778},
  {4775, 4778, 4776},
  {4912, 4780, 4774},
  {4777, 4733, 4778},
  {4781, 4734, 4780},
  {4819, 4781, 4951},
  {4873, 4661, 4819},
  {4782, 4609, 4822},
  {4874, 4872, 4820},
  {4702, 4823, 4876},
  {4784, 5002, 4822},
  {4701, 4875, 4784},
  {4739, 4825, 4787},
  {4922, 4787, 4825},
  {4924, 4666, 4829},
  {4923, 4570, 4924},
  {4830, 4705, 4828},
  {4834, 4831, 4925},
  {4881, 4833, 4740},
  {4835, 4740, 4833},
  {4834, 5012, 4791},
  {4837, 4833, 4836},
  {4836, 4835, 4838},
  {4841, 4880, 4840},
  {4836, 4838, 4837},
  {4840, 4839, 4790},
  {4843, 4707, 4675},
  {4842, 4960, 4843},
  {4842, 4708, 4844},
  {4794, 4845, 4882},
  {4678, 4847, 4744},
  {4744, 4847, 4849},
  {4712, 4889, 4887},
  {4710, 4848, 4746},
  {4710, 4846, 4848},
  {4848, 4851, 4746},
  {4795, 4713, 4850},
  {4714, 4750, 4889},
  {4745, 4853, 4847},
  {5022, 4852, 4850},
  {4850, 4852, 4795},
  {4750, 4854, 4890},
  {4892, 4754, 4855},
  {4893, 4856, 4721},
  {4895, 4799, 4798},
  {4754, 4892, 4798},
  {4800, 4893, 4721},
  {4755, 4894, 4801},
  {4756, 4801, 5074},
  {4971, 4800, 4857},
  {4897, 4802, 4757},
  {4722, 4979, 4858},
  {4860, 4760, 4858},
  {4858, 4898, 4860},
  {4860, 4900, 4723},
  {4902, 4761, 4804},
  {4804, 4861, 4902},
  {4723, 4900, 4806},
  {4862, 4809, 4761},
  {4725, 4727, 5110},
  {4728, 5110, 4727},
  {4862, 4905, 4809},
  {4904, 4807, 4980},
  {4864, 4936, 4763},
  {4690, 4729, 4865},
  {4906, 4730, 4866},
  {4653, 4695, 4866},
  {4811, 4907, 4812},
  {4695, 4867, 4866},
  {4867, 4695, 4908},
  {4695, 4868, 4908},
  {4771, 4947, 4770},
  {4771, 4911, 4947},
  {4771, 4818, 4911},
  {4910, 4870, 4772},
  {4774, 4870, 4912},
  {4781, 4780, 4912},
  {4781, 4913, 4951},
  {4872, 4874, 4914},
  {4872, 4779, 4656},
  {4873, 4819, 4951},
  {4872, 4782, 4820},
  {4820, 4782, 4822},
  {4735, 4915, 4785},
  {4954, 4823, 4785},
  {4783, 4699, 4917},
  {5002, 4784, 4875},
  {4825, 4821, 4824},
  {4955, 4786, 4920},
  {4787, 4922, 4828},
  {4832, 4925, 4831},
  {4878, 4925, 4832},
  {4789, 5912, 4829},
  {4832, 4833, 4878},
  {4879, 4878, 4833},
  {4881, 4879, 4833},
  {4839, 4926, 5912},
  {4880, 4926, 4839},
  {4833, 4837, 4835},
  {4838, 4835, 4837},
  {4880, 4839, 4840},
  {4842, 4843, 4675},
  {4844, 4960, 4842},
  {4843, 4883, 4707},
  {4885, 4886, 4843},
  {4843, 4886, 4883},
  {4743, 4928, 4846},
  {4888, 4847, 4963},
  {4847, 4888, 4849},
  {4846, 5019, 4848},
  {4849, 4888, 4850},
  {4889, 4750, 5020},
  {4746, 4851, 4717},
  {4969, 4853, 4796},
  {4891, 4851, 4970},
  {4796, 4891, 4969},
  {4856, 4929, 4753},
  {4972, 4895, 4798},
  {4803, 5030, 4932},
  {4803, 4932, 4722},
  {4722, 4932, 4979},
  {4858, 5033, 4898},
  {4900, 4860, 4898},
  {4898, 4931, 4900},
  {4805, 4762, 4933},
  {4901, 4933, 4762},
  {4900, 4981, 4806},
  {4761, 4902, 4862},
  {4905, 4862, 4902},
  {4901, 4762, 5036},
  {4806, 4981, 4766},
  {4863, 4809, 4982},
  {4904, 4769, 4764},
  {4809, 4905, 4982},
  {5078, 4986, 4769},
  {4864, 4865, 4940},
  {4769, 4986, 4813},
  {4981, 4907, 4811},
  {4907, 4868, 4812},
  {5165, 4943, 4946},
  {4945, 4655, 4813},
  {4868, 4907, 4908},
  {5165, 4946, 4816},
  {4993, 4869, 4945},
  {4816, 4946, 4817},
  {4944, 4770, 4947},
  {4945, 4869, 4655},
  {5236, 4817, 5049},
  {4910, 4948, 4870},
  {4818, 4871, 4911},
  {4870, 4948, 4912},
  {4997, 4912, 4948},
  {4912, 4997, 4781},
  {4779, 4914, 4949},
  {4914, 4779, 4872},
  {4820, 4822, 4952},
  {4916, 4915, 4783},
  {4916, 4783, 4917},
  {4820, 4952, 4874},
  {4875, 4703, 4876},
  {4876, 4823, 4953},
  {4785, 4915, 4954},
  {4918, 4919, 4874},
  {4919, 4874, 4918},
  {4824, 4955, 4825},
  {4956, 4826, 4827},
  {4825, 4955, 4922},
  {4877, 4956, 4827},
  {4921, 5006, 4920},
  {4788, 4923, 5059},
  {4828, 4922, 4830},
  {5010, 4924, 4829},
  {4878, 5011, 4925},
  {4881, 4830, 5009},
  {4925, 5012, 4834},
  {4879, 4881, 4878},
  {5912, 4926, 5010},
  {4883, 4886, 4962},
  {4845, 4709, 4887},
  {4888, 4966, 4850},
  {4965, 4963, 4847},
  {4847, 4853, 4965},
  {4750, 4890, 5020},
  {4965, 4853, 4969},
  {4968, 4890, 4854},
  {4970, 4851, 5021},
  {5023, 4855, 4852},
  {4929, 4751, 4753},
  {4854, 4751, 4968},
  {4929, 4856, 4893},
  {5157, 4894, 5025},
  {4755, 5025, 4894},
  {4895, 5025, 4755},
  {5025, 4895, 4972},
  {4892, 4973, 4798},
  {4801, 4894, 5074},
  {5074, 4896, 4756},
  {4857, 4802, 4930},
  {4802, 4897, 4930},
  {4975, 4930, 4897},
  {4896, 5030, 4758},
  {4934, 4931, 5107},
  {4977, 4975, 4859},
  {4858, 4979, 5033},
  {4898, 5033, 4976},
  {4931, 4934, 4900},
  {4859, 4899, 4977},
  {4805, 4933, 4899},
  {4902, 4861, 4935},
  {4901, 5036, 4933},
  {4902, 4935, 4905},
  {4980, 5079, 4904},
  {4807, 4808, 4980},
  {4762, 4863, 4982},
  {5078, 4769, 4904},
  {4936, 4864, 5041},
  {4905, 4935, 4939},
  {4905, 4939, 4982},
  {4903, 4810, 4938},
  {4865, 4941, 4940},
  {4935, 4988, 4939},
  {4865, 4906, 5038},
  {5038, 4906, 4992},
  {4981, 4991, 4907},
  {4989, 4943, 4942},
  {4906, 4866, 4992},
  {4866, 4867, 5045},
  {4909, 4869, 4993},
  {4946, 5087, 4817},
  {4948, 4910, 4994},
  {4910, 4731, 4909},
  {4996, 4911, 4871},
  {4781, 4997, 4913},
  {4949, 4950, 4998},
  {4949, 4871, 4779},
  {4949, 4914, 4950},
  {4822, 5002, 5001},
  {5000, 4917, 4873},
  {4874, 4919, 4914},
  {5056, 4874, 4952},
  {4875, 4876, 5003},
  {4953, 5003, 4876},
  {4915, 4916, 5004},
  {4916, 4917, 5000},
  {4823, 4954, 5122},
  {4920, 4922, 4955},
  {4921, 4957, 5006},
  {5006, 4957, 4959},
  {4922, 5006, 5009},
  {4958, 4788, 5059},
  {4959, 5008, 5006},
  {4922, 5009, 4830},
  {4925, 5096, 5012},
  {4878, 4881, 5011},
  {4881, 5009, 5011},
  {5012, 4927, 4791},
  {4793, 5013, 4844},
  {5013, 4960, 4844},
  {4882, 5015, 4793},
  {5017, 4960, 5013},
  {4843, 4960, 4885},
  {4845, 5016, 4882},
  {4961, 4960, 5017},
  {4960, 4961, 4885},
  {4928, 4743, 4884},
  {4883, 4962, 4884},
  {4845, 4887, 5018},
  {5063, 4885, 4961},
  {4885, 5063, 4886},
  {5098, 4886, 5063},
  {5065, 5018, 4887},
  {5064, 4846, 4928},
  {4846, 5064, 5019},
  {4966, 4888, 4964},
  {5019, 4851, 4848},
  {4888, 4963, 4964},
  {4966, 5022, 4850},
  {4969, 4967, 4965},
  {4890, 4968, 5066},
  {5021, 5068, 4970},
  {4751, 4929, 4968},
  {4855, 5023, 5024},
  {4855, 5024, 4892},
  {4893, 4971, 5071},
  {4893, 4800, 4971},
  {4972, 5105, 5025},
  {4972, 4798, 4973},
  {4971, 4857, 5027},
  {4973, 4974, 5073},
  {4857, 4930, 5028},
  {4975, 4897, 4859},
  {4931, 5031, 5107},
  {4898, 5031, 4931},
  {4898, 4976, 5031},
  {5030, 4978, 4932},
  {5032, 4932, 4978},
  {4979, 4932, 5032},
  {4861, 5035, 4935},
  {4900, 4934, 4981},
  {4934, 5034, 4984},
  {4981, 4934, 4984},
  {5078, 4904, 5079},
  {4983, 4937, 4935},
  {4864, 4940, 5041},
  {4940, 4941, 5041},
  {4991, 4981, 4984},
  {4935, 4937, 4988},
  {4937, 4983, 4985},
  {4941, 4865, 5038},
  {4939, 4988, 4987},
  {4988, 4937, 4985},
  {4939, 4987, 4942},
  {4989, 4942, 4987},
  {4987, 4988, 4990},
  {4987, 4990, 4989},
  {4813, 4986, 5083},
  {5164, 4942, 4943},
  {4768, 5191, 4810},
  {5083, 5046, 4813},
  {4907, 4991, 4908},
  {4943, 4989, 4946},
  {5046, 5048, 4813},
  {4813, 5048, 4945},
  {5045, 4992, 4866},
  {4908, 5045, 4867},
  {4994, 4910, 4909},
  {4994, 4909, 5086},
  {5050, 4948, 4994},
  {5052, 4947, 4911},
  {4949, 4998, 4996},
  {4949, 4996, 4871},
  {4951, 4913, 5055},
  {4951, 5055, 4999},
  {4999, 4873, 4951},
  {4999, 5000, 4873},
  {4950, 4914, 5093},
  {5001, 4952, 4822},
  {5001, 5002, 5092},
  {4952, 5092, 5056},
  {4875, 5003, 5002},
  {4916, 5000, 5004},
  {4919, 4874, 5057},
  {4919, 5057, 4914},
  {4953, 4823, 5122},
  {4953, 5122, 5121},
  {4954, 4915, 5123},
  {4921, 4826, 4957},
  {5008, 4959, 5005},
  {5005, 4959, 5060},
  {5005, 5007, 5008},
  {5005, 5060, 5007},
  {5010, 5125, 4924},
  {4923, 4924, 5125},
  {4925, 5011, 5096},
  {5061, 5010, 4926},
  {5015, 5014, 4793},
  {4793, 5014, 5013},
  {5152, 5015, 4882},
  {4882, 5016, 5152},
  {5128, 5016, 4845},
  {4884, 4962, 4928},
  {4928, 4962, 5064},
  {5018, 5128, 4845},
  {4887, 4889, 5065},
  {5019, 5021, 4851},
  {5132, 4964, 4963},
  {5132, 4963, 4965},
  {5020, 4890, 5066},
  {4965, 4967, 5132},
  {5067, 4967, 4969},
  {4964, 5069, 4966},
  {4966, 5069, 5022},
  {5022, 5023, 4852},
  {4929, 5071, 4968},
  {4970, 5133, 4891},
  {5133, 4969, 4891},
  {4929, 4893, 5071},
  {5070, 4892, 5024},
  {5070, 4973, 4892},
  {4973, 5072, 4974},
  {5026, 4974, 5072},
  {5073, 4974, 5026},
  {4973, 5073, 4972},
  {4857, 5028, 5027},
  {4896, 5074, 5029},
  {4896, 5029, 5030},
  {4930, 4975, 5136},
  {4934, 5107, 5075},
  {5030, 5106, 4978},
  {4899, 5108, 4977},
  {5075, 5034, 4934},
  {5075, 5109, 5034},
  {4935, 5035, 4983},
  {5035, 4725, 5110},
  {5037, 5036, 4762},
  {4762, 4982, 5037},
  {4980, 4808, 5079},
  {4936, 5079, 4808},
  {5040, 5038, 4992},
  {4938, 5111, 4903},
  {4986, 5078, 5140},
  {5041, 5082, 4936},
  {4941, 5038, 5077},
  {4982, 4939, 5141},
  {4983, 5039, 5043},
  {4983, 5043, 4985},
  {5040, 5045, 5080},
  {5080, 5045, 5042},
  {4988, 4985, 4990},
  {4985, 5044, 4990},
  {4985, 5043, 5044},
  {4984, 5042, 4991},
  {4990, 5044, 5047},
  {4990, 5047, 4989},
  {4992, 5045, 5040},
  {5047, 5044, 5084},
  {4989, 5047, 4946},
  {4817, 5087, 5049},
  {4947, 5085, 4944},
  {5050, 4994, 5114},
  {4994, 5086, 5114},
  {5236, 5166, 4816},
  {5236, 5049, 4995},
  {5051, 4995, 5049},
  {5085, 4947, 5052},
  {5088, 4995, 5051},
  {4911, 4996, 5052},
  {5089, 4948, 5050},
  {5088, 5053, 5090},
  {5089, 4997, 4948},
  {5090, 5053, 5054},
  {5053, 4998, 5054},
  {4997, 5091, 4913},
  {5055, 4913, 5091},
  {5117, 4999, 5055},
  {4950, 5093, 4998},
  {4952, 5001, 5092},
  {5057, 4874, 5056},
  {5003, 4953, 5121},
  {4914, 5057, 5120},
  {4915, 5004, 5095},
  {4956, 4957, 4826},
  {4957, 4956, 4959},
  {4920, 5006, 4922},
  {4959, 5058, 5060},
  {5058, 4959, 5124},
  {5059, 5060, 4958},
  {4926, 4880, 5061},
  {5009, 5126, 5011},
  {4880, 4927, 5061},
  {5062, 5061, 4927},
  {5062, 4927, 5012},
  {5014, 5015, 5152},
  {5014, 5017, 5013},
  {5017, 5014, 5207},
  {4886, 5098, 4962},
  {5019, 5064, 5130},
  {5065, 4889, 5020},
  {5020, 5066, 5131},
  {5100, 5021, 5019},
  {5100, 5068, 5021},
  {4967, 5067, 5132},
  {5069, 5182, 5022},
  {5022, 5182, 5023},
  {5068, 5155, 4970},
  {4970, 5155, 5133},
  {5023, 5134, 5024},
  {5070, 5024, 5134},
  {4973, 5070, 5072},
  {5103, 5071, 5158},
  {5073, 5105, 4972},
  {5072, 5073, 5026},
  {4894, 5157, 5074},
  {5105, 5157, 5025},
  {5028, 4930, 5104},
  {5136, 5104, 4930},
  {5186, 5030, 5029},
  {4899, 4933, 5138},
  {4899, 5138, 5108},
  {5076, 5080, 5109},
  {5109, 5080, 5034},
  {5036, 5037, 5138},
  {4983, 5035, 5110},
  {5076, 5038, 5040},
  {5076, 5040, 5080},
  {5080, 4984, 5034},
  {5079, 4936, 5082},
  {5076, 5077, 5038},
  {5039, 4983, 5110},
  {5039, 5110, 5081},
  {5039, 5081, 5111},
  {4941, 5077, 5139},
  {4941, 5139, 5041},
  {5080, 5042, 4984},
  {5039, 5111, 5188},
  {5041, 5142, 5082},
  {5043, 5113, 5044},
  {5043, 5039, 5188},
  {5043, 5188, 5112},
  {5043, 5112, 5113},
  {4939, 4942, 5163},
  {4942, 5164, 5163},
  {5044, 5113, 5084},
  {5045, 4991, 5042},
  {4768, 4944, 5191},
  {5046, 5143, 5048},
  {5048, 5143, 5192},
  {5048, 5192, 4945},
  {4945, 5192, 4993},
  {5045, 4908, 4991},
  {4946, 5047, 5087},
  {4993, 5086, 4909},
  {4944, 5085, 5302},
  {5115, 5049, 5087},
  {5051, 5049, 5115},
  {5089, 5050, 5167},
  {5145, 5052, 4996},
  {5145, 4998, 5053},
  {4998, 5145, 4996},
  {5118, 5090, 5054},
  {5054, 4998, 5118},
  {5002, 5094, 5172},
  {5117, 5000, 4999},
  {5119, 5000, 5117},
  {5003, 5094, 5002},
  {5120, 5093, 4914},
  {5000, 5119, 5004},
  {5147, 5004, 5119},
  {5095, 5004, 5147},
  {4915, 5095, 5123},
  {4954, 5123, 5149},
  {5124, 4956, 4877},
  {4958, 5124, 4877},
  {5124, 5060, 5058},
  {5173, 5008, 5007},
  {5008, 5173, 5006},
  {5151, 5006, 5173},
  {5010, 5061, 5127},
  {5010, 5127, 5125},
  {4962, 5098, 5097},
  {4962, 5097, 5064},
  {5098, 5063, 5246},
  {5018, 5065, 5128},
  {5065, 5020, 5131},
  {5019, 5130, 5179},
  {5019, 5179, 5099},
  {5099, 5100, 5019},
  {5066, 4968, 5102},
  {5180, 5132, 5067},
  {5100, 5101, 5068},
  {5067, 4969, 5133},
  {5134, 5183, 5070},
  {4968, 5071, 5102},
  {5156, 5102, 5071},
  {5071, 5103, 5156},
  {5073, 5072, 5135},
  {4971, 5027, 5071},
  {5104, 5071, 5027},
  {5027, 5028, 5104},
  {5106, 5030, 5186},
  {5031, 4976, 5137},
  {5260, 5075, 5107},
  {5137, 4976, 5033},
  {4933, 5036, 5138},
  {5162, 5077, 5076},
  {5138, 5037, 5227},
  {5081, 5110, 5111},
  {4982, 5141, 5037},
  {5041, 5139, 5142},
  {5140, 5083, 4986},
  {4939, 5163, 5141},
  {5192, 5086, 4993},
  {5047, 5084, 5087},
  {4816, 5235, 5165},
  {5167, 5050, 5114},
  {5052, 5145, 5085},
  {5088, 5145, 5053},
  {5088, 5051, 5169},
  {5088, 5169, 5145},
  {5089, 5116, 4997},
  {5088, 5090, 4995},
  {4997, 5116, 5091},
  {5091, 5116, 5197},
  {5091, 5197, 5055},
  {5055, 5197, 5117},
  {5092, 5002, 5146},
  {5002, 5172, 5146},
  {4998, 5093, 5118},
  {5094, 5003, 5121},
  {5056, 5092, 5202},
  {5056, 5202, 5057},
  {5095, 5147, 5123},
  {5149, 5122, 4954},
  {4958, 5060, 5124},
  {4959, 4956, 5124},
  {5150, 5060, 5059},
  {5126, 5006, 5151},
  {5009, 5006, 5126},
  {4923, 5125, 5059},
  {5150, 5059, 5125},
  {5060, 5150, 5007},
  {5096, 5245, 5012},
  {5128, 5152, 5016},
  {5246, 5097, 5098},
  {5017, 5129, 4961},
  {5175, 5130, 5064},
  {4961, 5129, 5063},
  {5246, 5063, 5129},
  {5099, 5179, 5100},
  {5131, 5066, 5154},
  {5154, 5066, 5212},
  {5100, 5209, 5101},
  {5066, 5102, 5212},
  {5101, 5210, 5068},
  {5132, 5181, 4964},
  {5210, 5155, 5068},
  {5023, 5182, 5134},
  {5105, 5073, 5135},
  {5135, 5072, 5070},
  {5218, 4975, 4977},
  {4978, 5106, 5159},
  {5033, 5161, 5137},
  {4978, 5160, 5032},
  {5160, 5033, 5032},
  {5032, 5033, 4979},
  {5110, 4728, 5111},
  {5229, 5079, 5082},
  {5114, 5086, 5192},
  {5169, 5302, 5085},
  {5084, 5115, 5087},
  {5115, 5168, 5051},
  {5169, 5051, 5168},
  {5144, 4995, 5090},
  {5090, 5196, 5144},
  {5090, 5118, 5171},
  {5093, 5120, 5198},
  {5122, 5149, 5121},
  {5123, 5147, 5148},
  {5148, 5149, 5123},
  {5127, 5205, 5125},
  {5125, 5205, 5150},
  {5126, 5151, 5011},
  {5245, 5096, 5206},
  {5012, 5245, 5062},
  {5097, 5175, 5064},
  {5246, 5175, 5097},
  {5175, 5177, 5130},
  {5178, 5128, 5065},
  {5178, 5065, 5131},
  {5154, 5153, 5131},
  {5180, 5067, 5913},
  {5210, 5101, 5209},
  {5067, 5133, 5913},
  {4964, 5181, 5069},
  {5182, 5183, 5134},
  {5135, 5070, 5215},
  {5213, 5156, 5103},
  {5185, 5256, 5105},
  {5103, 5158, 5213},
  {5158, 5104, 5136},
  {5104, 5158, 5071},
  {5258, 5186, 5029},
  {5029, 5074, 5258},
  {5136, 4975, 5218},
  {5107, 5031, 5259},
  {5218, 4977, 5294},
  {5219, 5031, 5137},
  {5187, 5159, 5106},
  {5187, 5220, 5159},
  {5159, 5160, 4978},
  {5160, 5161, 5033},
  {5260, 5107, 5259},
  {4977, 5108, 5261},
  {5075, 5260, 5263},
  {5109, 5075, 5263},
  {5138, 5225, 5108},
  {5077, 5162, 5139},
  {5079, 5299, 5140},
  {5079, 5140, 5078},
  {5079, 5229, 5299},
  {4938, 4810, 5188},
  {5140, 5231, 5083},
  {5139, 5230, 5142},
  {5112, 5188, 5191},
  {5083, 5231, 5046},
  {5046, 5231, 5143},
  {5084, 5234, 5115},
  {5166, 5235, 4816},
  {5168, 5115, 5234},
  {5193, 5089, 5167},
  {5194, 5116, 5089},
  {4995, 5144, 5170},
  {5194, 5197, 5116},
  {5196, 5090, 5171},
  {5198, 5171, 5118},
  {5146, 5276, 5092},
  {5238, 5172, 5094},
  {5118, 5093, 5198},
  {5147, 5119, 5201},
  {5202, 5198, 5120},
  {5201, 5242, 5147},
  {5120, 5057, 5202},
  {5242, 5201, 5203},
  {5173, 5150, 5205},
  {5150, 5173, 5007},
  {5151, 5096, 5011},
  {5061, 5174, 5127},
  {5096, 5151, 5173},
  {5061, 5062, 5174},
  {5096, 5173, 5206},
  {5014, 5152, 5207},
  {5017, 5176, 5129},
  {5017, 5207, 5176},
  {5176, 5246, 5129},
  {5128, 5178, 5208},
  {5130, 5177, 5283},
  {5178, 5131, 5153},
  {5100, 5179, 5283},
  {5211, 5155, 5210},
  {5155, 5913, 5133},
  {5181, 5182, 5069},
  {5181, 5286, 5182},
  {5102, 5156, 5251},
  {5255, 5070, 5183},
  {5215, 5070, 5255},
  {5105, 5135, 5185},
  {5184, 5257, 5214},
  {5184, 5346, 5257},
  {5292, 5157, 5105},
  {5256, 5292, 5105},
  {5136, 5216, 5158},
  {5213, 5158, 5216},
  {5187, 5106, 5186},
  {5219, 5137, 5161},
  {5259, 5031, 5219},
  {5261, 5294, 4977},
  {5076, 5109, 5162},
  {5111, 4938, 5188},
  {5264, 5227, 5037},
  {5037, 5141, 5264},
  {5188, 5190, 5189},
  {5142, 5265, 5082},
  {5082, 5265, 5229},
  {5190, 5189, 5188},
  {5188, 5190, 5191},
  {5142, 5230, 5266},
  {5141, 5163, 5264},
  {5113, 5234, 5084},
  {5143, 5233, 5192},
  {5164, 4943, 5513},
  {5234, 5303, 5168},
  {5114, 5267, 5167},
  {5169, 5085, 5145},
  {5170, 5144, 5196},
  {5170, 5196, 4995},
  {5117, 5197, 5200},
  {5117, 5200, 5119},
  {5092, 5276, 5199},
  {5092, 5199, 5202},
  {5094, 5121, 5241},
  {5094, 5241, 5238},
  {5119, 5200, 5201},
  {5201, 5200, 5203},
  {5203, 5340, 5341},
  {5148, 5239, 5149},
  {5148, 5147, 5279},
  {5148, 5279, 5239},
  {5242, 5279, 5147},
  {5204, 5121, 5149},
  {5239, 5204, 5149},
  {5205, 5243, 5173},
  {5207, 5152, 5310},
  {5312, 5176, 5207},
  {5283, 5177, 5343},
  {5248, 5247, 5180},
  {5247, 5282, 5180},
  {5178, 5153, 5313},
  {5315, 5313, 5153},
  {5179, 5130, 5283},
  {5153, 5154, 5284},
  {5100, 5283, 5209},
  {5211, 5184, 5248},
  {5212, 5102, 5251},
  {5211, 5210, 5252},
  {5211, 5252, 5184},
  {5184, 5214, 5250},
  {5251, 5156, 5318},
  {5252, 5346, 5184},
  {5156, 5213, 5318},
  {5214, 5253, 5250},
  {5135, 5215, 5185},
  {5216, 5217, 5213},
  {5350, 5187, 5186},
  {5187, 5350, 5220},
  {5160, 5159, 5223},
  {5160, 5222, 5161},
  {5161, 5222, 5219},
  {5224, 5261, 5108},
  {5221, 5220, 5350},
  {5220, 5223, 5159},
  {5220, 5221, 5223},
  {5160, 5223, 5222},
  {5222, 5262, 5219},
  {5108, 5225, 5224},
  {5226, 5162, 5109},
  {5138, 5227, 5225},
  {5139, 5162, 5228},
  {5139, 5228, 5230},
  {5188, 4810, 5190},
  {5190, 4810, 5191},
  {5266, 5265, 5142},
  {5266, 5230, 5232},
  {5143, 5231, 5233},
  {5191, 4944, 5302},
  {5169, 5303, 5302},
  {5303, 5169, 5168},
  {5267, 5304, 5167},
  {5236, 4995, 5271},
  {5304, 5193, 5167},
  {4995, 5196, 5271},
  {5089, 5193, 5194},
  {5268, 5195, 5237},
  {5273, 5274, 5195},
  {5273, 5195, 5270},
  {5195, 5274, 5237},
  {5146, 5362, 5276},
  {5146, 5172, 5362},
  {5171, 5198, 5387},
  {5198, 5365, 5387},
  {5203, 5278, 5340},
  {5202, 5199, 5339},
  {5307, 5241, 5204},
  {5241, 5121, 5204},
  {5204, 5239, 5240},
  {5244, 5127, 5174},
  {5206, 5173, 5243},
  {5174, 5062, 5244},
  {5128, 5208, 5342},
  {5343, 5177, 5175},
  {5208, 5313, 5342},
  {5246, 5176, 5314},
  {5282, 5344, 5180},
  {5284, 5315, 5153},
  {5132, 5180, 5181},
  {5287, 5182, 5286},
  {5249, 5183, 5182},
  {5284, 5154, 5212},
  {5209, 5252, 5210},
  {5212, 5251, 5284},
  {5249, 5288, 5289},
  {5249, 5289, 5254},
  {5249, 5254, 5183},
  {5316, 5250, 5253},
  {5254, 5255, 5183},
  {5254, 5289, 5290},
  {5074, 5157, 5258},
  {5292, 5258, 5157},
  {5216, 5136, 5218},
  {5216, 5293, 5217},
  {5393, 5217, 5293},
  {5219, 5262, 5259},
  {5296, 5223, 5221},
  {5297, 5263, 5260},
  {5325, 5224, 5225},
  {5298, 5222, 5223},
  {5109, 5263, 5226},
  {5325, 5225, 5227},
  {5162, 5226, 5228},
  {5301, 5228, 5226},
  {5232, 5230, 5228},
  {5228, 5301, 5232},
  {5328, 5232, 5301},
  {5164, 5264, 5163},
  {5266, 5232, 5328},
  {5112, 5191, 5113},
  {5513, 4943, 5165},
  {5114, 5192, 5267},
  {5236, 5271, 5334},
  {5268, 5269, 5195},
  {5269, 5270, 5195},
  {5193, 5305, 5194},
  {5196, 5405, 5271},
  {5268, 5237, 5272},
  {5274, 5273, 5381},
  {5237, 5274, 5277},
  {5305, 5197, 5194},
  {5197, 5305, 5200},
  {5278, 5200, 5305},
  {5307, 5240, 5275},
  {5240, 5308, 5306},
  {5240, 5239, 5308},
  {5200, 5278, 5203},
  {5239, 5279, 5308},
  {5307, 5204, 5240},
  {5127, 5244, 5205},
  {5205, 5244, 5243},
  {5245, 5243, 5280},
  {5243, 5245, 5206},
  {5062, 5243, 5244},
  {5243, 5062, 5280},
  {5245, 5280, 5062},
  {5342, 5310, 5152},
  {5152, 5128, 5342},
  {5207, 5310, 5312},
  {5175, 5246, 5311},
  {5314, 5176, 5312},
  {5247, 5282, 5281},
  {5281, 5247, 5282},
  {5208, 5178, 5313},
  {5248, 5282, 5247},
  {5285, 5282, 5248},
  {5248, 5184, 5285},
  {5286, 5180, 5344},
  {5344, 5287, 5286},
  {5184, 5250, 5285},
  {5285, 5250, 5316},
  {5180, 5286, 5181},
  {5287, 5249, 5182},
  {5249, 5287, 5288},
  {5317, 5252, 5209},
  {5316, 5253, 5288},
  {5288, 5253, 5319},
  {5290, 5291, 5254},
  {5254, 5291, 5255},
  {5289, 5291, 5290},
  {5346, 5252, 5390},
  {5214, 5320, 5253},
  {5215, 5368, 5185},
  {5213, 5217, 5393},
  {5256, 5348, 5292},
  {5257, 5394, 5214},
  {5214, 5369, 5320},
  {5351, 5259, 5262},
  {5323, 5294, 5261},
  {5260, 5351, 5295},
  {5261, 5224, 5323},
  {5260, 5295, 5297},
  {5353, 5262, 5298},
  {5222, 5298, 5262},
  {5263, 5297, 5226},
  {5226, 5297, 5300},
  {5297, 5295, 5300},
  {5355, 5325, 5227},
  {5326, 5300, 5295},
  {5227, 5264, 5355},
  {5356, 5140, 5299},
  {5299, 5229, 5357},
  {5265, 5357, 5229},
  {5300, 5301, 5226},
  {5140, 5356, 5231},
  {5327, 5265, 5266},
  {5328, 5327, 5266},
  {5300, 5358, 5301},
  {5234, 5302, 5303},
  {5165, 5235, 5513},
  {5192, 5330, 5267},
  {5235, 5166, 5329},
  {5267, 5330, 5304},
  {5166, 5475, 5329},
  {5331, 5359, 5270},
  {5272, 5304, 5268},
  {5269, 5333, 5332},
  {5332, 5270, 5269},
  {5193, 5304, 5336},
  {5304, 5272, 5336},
  {5274, 5381, 5360},
  {5337, 5196, 5171},
  {5237, 5277, 5272},
  {5307, 5275, 5361},
  {5275, 5240, 5306},
  {5276, 5406, 5199},
  {5172, 5238, 5362},
  {5199, 5338, 5339},
  {5307, 5363, 5238},
  {5340, 5278, 5309},
  {5340, 5309, 5277},
  {5238, 5241, 5307},
  {5202, 5365, 5198},
  {5279, 5242, 5364},
  {5203, 5364, 5242},
  {5343, 5175, 5311},
  {5246, 5314, 5366},
  {5316, 5344, 5282},
  {5287, 5344, 5316},
  {5283, 5317, 5209},
  {5316, 5282, 5285},
  {5316, 5288, 5287},
  {5288, 5392, 5289},
  {5288, 5319, 5392},
  {5289, 5414, 5291},
  {5320, 5391, 5253},
  {5253, 5391, 5319},
  {5213, 5393, 5318},
  {5185, 5348, 5256},
  {5346, 5394, 5257},
  {5292, 5348, 5258},
  {5218, 5321, 5216},
  {5214, 5394, 5369},
  {5321, 5218, 5294},
  {5216, 5321, 5293},
  {5259, 5351, 5260},
  {5294, 5323, 5397},
  {5350, 5322, 5221},
  {5221, 5322, 5296},
  {5323, 5224, 5325},
  {5296, 5322, 5419},
  {5296, 5419, 5371},
  {5296, 5371, 5324},
  {5296, 5324, 5223},
  {5372, 5223, 5324},
  {5223, 5372, 5298},
  {5264, 5164, 5374},
  {5302, 5113, 5191},
  {5164, 5513, 5374},
  {5302, 5234, 5113},
  {5233, 5330, 5192},
  {5329, 5513, 5235},
  {5333, 5304, 5330},
  {5270, 5332, 5331},
  {5304, 5333, 5268},
  {5333, 5269, 5268},
  {5335, 5236, 5334},
  {5334, 5271, 5335},
  {5383, 5335, 5271},
  {5270, 5359, 5382},
  {5360, 5381, 5424},
  {5273, 5270, 5382},
  {5336, 5305, 5193},
  {5275, 5384, 5361},
  {5384, 5275, 5306},
  {5306, 5385, 5384},
  {5274, 5360, 5277},
  {5337, 5171, 5387},
  {5305, 5336, 5309},
  {5305, 5309, 5278},
  {5336, 5272, 5309},
  {5272, 5277, 5309},
  {5406, 5338, 5199},
  {5362, 5238, 5363},
  {5306, 5308, 5385},
  {5308, 5279, 5364},
  {5202, 5408, 5365},
  {5366, 5311, 5246},
  {5312, 5388, 5410},
  {5283, 5343, 5411},
  {5284, 5251, 5345},
  {5317, 5390, 5252},
  {5414, 5289, 5392},
  {5391, 5320, 5415},
  {5347, 5291, 5414},
  {5291, 5347, 5255},
  {5215, 5255, 5368},
  {5347, 5368, 5255},
  {5368, 5348, 5185},
  {5321, 5393, 5293},
  {5349, 5186, 5258},
  {5258, 5395, 5349},
  {5186, 5349, 5350},
  {5397, 5370, 5294},
  {5262, 5352, 5351},
  {5262, 5353, 5352},
  {5352, 5354, 5351},
  {5351, 5354, 5295},
  {5371, 5400, 5324},
  {5324, 5400, 5372},
  {5298, 5372, 5353},
  {5352, 5373, 5354},
  {5295, 5354, 5326},
  {5301, 5358, 5328},
  {5300, 5326, 5402},
  {5231, 5375, 5233},
  {5233, 5376, 5330},
  {5379, 5331, 5332},
  {5331, 5379, 5359},
  {5377, 5332, 5333},
  {5335, 5383, 5236},
  {5405, 5196, 5337},
  {5276, 5362, 5406},
  {5364, 5385, 5308},
  {5454, 5363, 5307},
  {5277, 5386, 5340},
  {5386, 5341, 5340},
  {5202, 5339, 5408},
  {5409, 5312, 5310},
  {5312, 5409, 5388},
  {5312, 5410, 5314},
  {5313, 5315, 5367},
  {5411, 5317, 5283},
  {5315, 5284, 5367},
  {5284, 5345, 5367},
  {5345, 5251, 5389},
  {5251, 5318, 5389},
  {5389, 5318, 5393},
  {5368, 5438, 5348},
  {5294, 5370, 5321},
  {5349, 5441, 5350},
  {5350, 5398, 5322},
  {5325, 5355, 5399},
  {5372, 5445, 5353},
  {5353, 5445, 5373},
  {5353, 5373, 5352},
  {5373, 5468, 5354},
  {5356, 5299, 5357},
  {5374, 5355, 5264},
  {5265, 5327, 5401},
  {5420, 5401, 5327},
  {5327, 5328, 5420},
  {5421, 5420, 5328},
  {5402, 5326, 5354},
  {5375, 5231, 5356},
  {5377, 5376, 5233},
  {5332, 5377, 5378},
  {5378, 5379, 5332},
  {5380, 5379, 5470},
  {5379, 5380, 5359},
  {5333, 5330, 5376},
  {5376, 5377, 5333},
  {5425, 5359, 5380},
  {5329, 5475, 5449},
  {5452, 5166, 5236},
  {5236, 5383, 5452},
  {5382, 5359, 5425},
  {5381, 5273, 5492},
  {5386, 5277, 5360},
  {5362, 5363, 5479},
  {5454, 5307, 5361},
  {5364, 5203, 5341},
  {5364, 5341, 5407},
  {5310, 5342, 5409},
  {5311, 5429, 5343},
  {5342, 5313, 5409},
  {5343, 5429, 5411},
  {5314, 5410, 5412},
  {5413, 5390, 5317},
  {5434, 5367, 5345},
  {5346, 5390, 5433},
  {5320, 5369, 5416},
  {5346, 5417, 5394},
  {5395, 5258, 5348},
  {5418, 5393, 5321},
  {5370, 5397, 5439},
  {5370, 5439, 5321},
  {5396, 5321, 5439},
  {5396, 5418, 5321},
  {5440, 5418, 5396},
  {5441, 5349, 5395},
  {5398, 5419, 5322},
  {5399, 5444, 5323},
  {5323, 5325, 5399},
  {5445, 5372, 5400},
  {5356, 5357, 5470},
  {5357, 5265, 5401},
  {5328, 5358, 5421},
  {5300, 5402, 5358},
  {5375, 5378, 5377},
  {5375, 5356, 5378},
  {5375, 5377, 5233},
  {5378, 5403, 5379},
  {5470, 5379, 5403},
  {5423, 5380, 5422},
  {5425, 5380, 5423},
  {5475, 5166, 5452},
  {5381, 5520, 5424},
  {5520, 5381, 5476},
  {5384, 5385, 5404},
  {5383, 5271, 5427},
  {5383, 5427, 5452},
  {5384, 5453, 5361},
  {5360, 5451, 5386},
  {5405, 5427, 5271},
  {5492, 5273, 5382},
  {5404, 5428, 5426},
  {5337, 5387, 5496},
  {5337, 5496, 5405},
  {5338, 5406, 5494},
  {5406, 5362, 5479},
  {5454, 5479, 5363},
  {5404, 5385, 5407},
  {5404, 5407, 5428},
  {5339, 5338, 5494},
  {5364, 5407, 5385},
  {5365, 5408, 5455},
  {5311, 5366, 5429},
  {5409, 5313, 5431},
  {5388, 5456, 5410},
  {5411, 5457, 5413},
  {5412, 5366, 5314},
  {5366, 5412, 5430},
  {5313, 5367, 5431},
  {5432, 5431, 5367},
  {5413, 5317, 5411},
  {5434, 5432, 5367},
  {5433, 5390, 5413},
  {5345, 5389, 5434},
  {5434, 5389, 5459},
  {5391, 5435, 5319},
  {5392, 5319, 5435},
  {5433, 5461, 5346},
  {5461, 5417, 5346},
  {5320, 5416, 5415},
  {5347, 5438, 5368},
  {5416, 5394, 5503},
  {5394, 5416, 5369},
  {5348, 5438, 5395},
  {5438, 5443, 5395},
  {5396, 5439, 5440},
  {5395, 5442, 5441},
  {5350, 5441, 5398},
  {5419, 5466, 5371},
  {5399, 5355, 5469},
  {5373, 5445, 5512},
  {5469, 5355, 5374},
  {5469, 5374, 5446},
  {5357, 5401, 5470},
  {5354, 5468, 5402},
  {5358, 5447, 5421},
  {5358, 5402, 5448},
  {5358, 5448, 5447},
  {5402, 5468, 5448},
  {5446, 5374, 5513},
  {5356, 5403, 5378},
  {5356, 5470, 5403},
  {5380, 5470, 5422},
  {5423, 5422, 5477},
  {5384, 5404, 5478},
  {5428, 5451, 5426},
  {5492, 5382, 5425},
  {5405, 5540, 5427},
  {5386, 5451, 5428},
  {5341, 5428, 5407},
  {5456, 5388, 5409},
  {5366, 5430, 5429},
  {5429, 5430, 5525},
  {5429, 5457, 5411},
  {5482, 5410, 5456},
  {5410, 5482, 5412},
  {5412, 5482, 5430},
  {5459, 5389, 5393},
  {5435, 5460, 5392},
  {5460, 5414, 5392},
  {5461, 5462, 5417},
  {5414, 5436, 5347},
  {5417, 5462, 5502},
  {5415, 5416, 5500},
  {5436, 5437, 5347},
  {5347, 5437, 5438},
  {5436, 5464, 5437},
  {5393, 5418, 5463},
  {5417, 5503, 5394},
  {5397, 5510, 5439},
  {5443, 5442, 5395},
  {5444, 5397, 5323},
  {5578, 5444, 5399},
  {5467, 5371, 5466},
  {5371, 5467, 5400},
  {5373, 5512, 5468},
  {5420, 5421, 5517},
  {5420, 5517, 5471},
  {5472, 5422, 5514},
  {5422, 5472, 5477},
  {5449, 5513, 5329},
  {5450, 5360, 5424},
  {5424, 5520, 5450},
  {5451, 5360, 5473},
  {5384, 5478, 5453},
  {5381, 5492, 5476},
  {5404, 5426, 5491},
  {5426, 5451, 5491},
  {5494, 5406, 5495},
  {5361, 5453, 5454},
  {5428, 5341, 5386},
  {5339, 5494, 5408},
  {5408, 5494, 5455},
  {5365, 5496, 5387},
  {5481, 5496, 5365},
  {5455, 5481, 5365},
  {5409, 5431, 5498},
  {5429, 5525, 5457},
  {5431, 5432, 5499},
  {5483, 5413, 5457},
  {5499, 5432, 5458},
  {5434, 5458, 5432},
  {5433, 5413, 5483},
  {5391, 5484, 5435},
  {5436, 5460, 5501},
  {5460, 5436, 5414},
  {5501, 5464, 5436},
  {5503, 5500, 5416},
  {5464, 5574, 5437},
  {5437, 5574, 5487},
  {5438, 5437, 5487},
  {5439, 5465, 5440},
  {5442, 5443, 5488},
  {5398, 5489, 5419},
  {5400, 5467, 5445},
  {5552, 5445, 5467},
  {5401, 5420, 5471},
  {5421, 5447, 5517},
  {5448, 5557, 5447},
  {5470, 5490, 5422},
  {5422, 5490, 5514},
  {5477, 5472, 5519},
  {5474, 5473, 5360},
  {5474, 5360, 5450},
  {5425, 5423, 5521},
  {5475, 5452, 5493},
  {5540, 5452, 5427},
  {5479, 5495, 5406},
  {5480, 5455, 5494},
  {5497, 5480, 5494},
  {5479, 5454, 5523},
  {5456, 5409, 5565},
  {5567, 5457, 5525},
  {5524, 5430, 5482},
  {5499, 5458, 5526},
  {5527, 5433, 5545},
  {5458, 5434, 5528},
  {5458, 5528, 5526},
  {5433, 5527, 5461},
  {5434, 5459, 5528},
  {5484, 5460, 5435},
  {5528, 5459, 5485},
  {5486, 5391, 5415},
  {5461, 5527, 5462},
  {5500, 5486, 5415},
  {5484, 5501, 5460},
  {5459, 5463, 5485},
  {5459, 5393, 5463},
  {5500, 5503, 5549},
  {5502, 5503, 5417},
  {5507, 5441, 5442},
  {5507, 5442, 5504},
  {5398, 5441, 5507},
  {5442, 5488, 5504},
  {5510, 5397, 5444},
  {5510, 5511, 5439},
  {5465, 5439, 5511},
  {5578, 5510, 5444},
  {5419, 5489, 5466},
  {5466, 5551, 5467},
  {5399, 5469, 5578},
  {5445, 5552, 5512},
  {5468, 5531, 5448},
  {5401, 5471, 5490},
  {5490, 5470, 5401},
  {5471, 5514, 5490},
  {5450, 5518, 5474},
  {5518, 5491, 5474},
  {5473, 5474, 5491},
  {5535, 5521, 5423},
  {5423, 5477, 5535},
  {5538, 5453, 5478},
  {5478, 5404, 5491},
  {5473, 5491, 5451},
  {5521, 5492, 5425},
  {5540, 5493, 5452},
  {5539, 5453, 5536},
  {5480, 5497, 5522},
  {5480, 5522, 5455},
  {5456, 5544, 5482},
  {5483, 5457, 5567},
  {5430, 5524, 5525},
  {5483, 5545, 5433},
  {5391, 5486, 5484},
  {5484, 5486, 5546},
  {5484, 5546, 5592},
  {5418, 5440, 5529},
  {5465, 5529, 5440},
  {5487, 5574, 5505},
  {5487, 5505, 5506},
  {5487, 5506, 5438},
  {5488, 5438, 5506},
  {5438, 5488, 5443},
  {5509, 5529, 5465},
  {5398, 5507, 5489},
  {5576, 5489, 5507},
  {5511, 5509, 5465},
  {5489, 5530, 5466},
  {5551, 5466, 5530},
  {5469, 5446, 5580},
  {5446, 5513, 5532},
  {5513, 5516, 5555},
  {5471, 5515, 5514},
  {5471, 5517, 5515},
  {5513, 5449, 5516},
  {5447, 5557, 5517},
  {5449, 5534, 5516},
  {5476, 5492, 5602},
  {5476, 5602, 5520},
  {5478, 5491, 5538},
  {5539, 5523, 5453},
  {5539, 5541, 5523},
  {5495, 5479, 5494},
  {5496, 5540, 5405},
  {5497, 5494, 5522},
  {5453, 5523, 5454},
  {5409, 5498, 5565},
  {5498, 5431, 5568},
  {5431, 5499, 5568},
  {5456, 5565, 5544},
  {5483, 5567, 5545},
  {5499, 5526, 5568},
  {5571, 5462, 5527},
  {5500, 5546, 5486},
  {5502, 5462, 5571},
  {5549, 5546, 5500},
  {5548, 5485, 5463},
  {5592, 5501, 5484},
  {5529, 5548, 5463},
  {5463, 5418, 5529},
  {5549, 5503, 5573},
  {5488, 5508, 5574},
  {5574, 5508, 5505},
  {5505, 5508, 5506},
  {5508, 5488, 5506},
  {5511, 5575, 5509},
  {5530, 5489, 5576},
  {5511, 5577, 5575},
  {5510, 5553, 5511},
  {5533, 5512, 5552},
  {5533, 5531, 5468},
  {5552, 5556, 5533},
  {5532, 5513, 5555},
  {5555, 5516, 5614},
  {5514, 5515, 5472},
  {5516, 5534, 5614},
  {5517, 5557, 5585},
  {5472, 5515, 5519},
  {5515, 5517, 5519},
  {5585, 5519, 5517},
  {5588, 5519, 5585},
  {5559, 5491, 5598},
  {5491, 5518, 5598},
  {5586, 5598, 5518},
  {5518, 5450, 5558},
  {5520, 5558, 5450},
  {5475, 5589, 5449},
  {5491, 5559, 5538},
  {5493, 5561, 5475},
  {5535, 5477, 5588},
  {5536, 5453, 5537},
  {5493, 5540, 5561},
  {5492, 5521, 5621},
  {5542, 5522, 5494},
  {5604, 5540, 5496},
  {5494, 5479, 5542},
  {5541, 5562, 5523},
  {5481, 5604, 5496},
  {5563, 5481, 5455},
  {5498, 5568, 5565},
  {5525, 5524, 5564},
  {5544, 5569, 5482},
  {5566, 5524, 5482},
  {5543, 5544, 5565},
  {5565, 5568, 5543},
  {5526, 5591, 5570},
  {5592, 5546, 5607},
  {5528, 5591, 5526},
  {5485, 5593, 5528},
  {5485, 5595, 5593},
  {5546, 5549, 5547},
  {5485, 5548, 5595},
  {5501, 5574, 5464},
  {5502, 5573, 5503},
  {5504, 5488, 5550},
  {5488, 5574, 5550},
  {5507, 5504, 5576},
  {5509, 5575, 5529},
  {5553, 5577, 5511},
  {5551, 5579, 5467},
  {5552, 5467, 5579},
  {5578, 5469, 5580},
  {5510, 5578, 5553},
  {5533, 5468, 5512},
  {5579, 5556, 5552},
  {5579, 5631, 5556},
  {5533, 5554, 5531},
  {5533, 5556, 5632},
  {5533, 5582, 5554},
  {5582, 5583, 5554},
  {5518, 5558, 5586},
  {5588, 5616, 5560},
  {5590, 5538, 5559},
  {5560, 5616, 5587},
  {5561, 5589, 5475},
  {5536, 5537, 5618},
  {5537, 5453, 5590},
  {5536, 5618, 5539},
  {5521, 5535, 5619},
  {5541, 5539, 5562},
  {5623, 5562, 5539},
  {5479, 5623, 5542},
  {5455, 5522, 5563},
  {5524, 5566, 5564},
  {5567, 5525, 5564},
  {5482, 5569, 5566},
  {5567, 5606, 5545},
  {5526, 5543, 5568},
  {5526, 5570, 5543},
  {5543, 5669, 5544},
  {5527, 5545, 5571},
  {5546, 5547, 5607},
  {5592, 5572, 5501},
  {5502, 5594, 5573},
  {5529, 5575, 5629},
  {5646, 5551, 5530},
  {5577, 5553, 5581},
  {5532, 5580, 5446},
  {5532, 5555, 5580},
  {5580, 5555, 5581},
  {5648, 5581, 5555},
  {5448, 5531, 5554},
  {5554, 5557, 5448},
  {5632, 5582, 5533},
  {5554, 5583, 5557},
  {5584, 5587, 5616},
  {5559, 5598, 5652},
  {5652, 5590, 5559},
  {5520, 5602, 5601},
  {5619, 5560, 5587},
  {5588, 5477, 5519},
  {5537, 5600, 5618},
  {5537, 5590, 5600},
  {5560, 5619, 5535},
  {5560, 5535, 5588},
  {5453, 5538, 5590},
  {5521, 5619, 5621},
  {5539, 5618, 5623},
  {5603, 5540, 5604},
  {5563, 5522, 5605},
  {5657, 5605, 5522},
  {5622, 5604, 5481},
  {5481, 5563, 5622},
  {5567, 5564, 5606},
  {5545, 5606, 5571},
  {5591, 5528, 5626},
  {5528, 5593, 5626},
  {5574, 5501, 5572},
  {5571, 5594, 5502},
  {5596, 5550, 5610},
  {5574, 5610, 5550},
  {5548, 5529, 5628},
  {5645, 5550, 5596},
  {5529, 5629, 5628},
  {5550, 5645, 5504},
  {5629, 5575, 5611},
  {5611, 5575, 5630},
  {5575, 5577, 5630},
  {5553, 5580, 5581},
  {5577, 5581, 5612},
  {5581, 5648, 5612},
  {5650, 5584, 5597},
  {5633, 5597, 5584},
  {5582, 5633, 5583},
  {5614, 5534, 5615},
  {5584, 5616, 5633},
  {5583, 5585, 5557},
  {5586, 5558, 5617},
  {5589, 5615, 5534},
  {5589, 5534, 5449},
  {5558, 5520, 5599},
  {5558, 5599, 5617},
  {5520, 5601, 5599},
  {5561, 5603, 5653},
  {5621, 5602, 5492},
  {5540, 5603, 5561},
  {5623, 5522, 5542},
  {5636, 5622, 5563},
  {5564, 5566, 5637},
  {5658, 5637, 5566},
  {5566, 5569, 5658},
  {5569, 5544, 5669},
  {5570, 5669, 5543},
  {5669, 5570, 5591},
  {5591, 5626, 5608},
  {5591, 5608, 5669},
  {5607, 5547, 5624},
  {5594, 5571, 5625},
  {5592, 5640, 5572},
  {5609, 5574, 5572},
  {5593, 5627, 5626},
  {5609, 5610, 5574},
  {5593, 5595, 5627},
  {5594, 5643, 5573},
  {5659, 5549, 5573},
  {5504, 5645, 5576},
  {5645, 5679, 5576},
  {5578, 5580, 5553},
  {5646, 5631, 5579},
  {5613, 5647, 5649},
  {5613, 5632, 5631},
  {5649, 5597, 5613},
  {5613, 5597, 5632},
  {5650, 5597, 5649},
  {5633, 5632, 5597},
  {5632, 5633, 5582},
  {5616, 5583, 5633},
  {5583, 5616, 5585},
  {5585, 5616, 5588},
  {5589, 5914, 5615},
  {5584, 5634, 5587},
  {5652, 5600, 5590},
  {5688, 5617, 5599},
  {5599, 5601, 5688},
  {5587, 5634, 5619},
  {5635, 5657, 5522},
  {5620, 5604, 5622},
  {5655, 5604, 5620},
  {5604, 5655, 5603},
  {5522, 5623, 5635},
  {5605, 5636, 5563},
  {5564, 5637, 5606},
  {5638, 5571, 5606},
  {5625, 5571, 5638},
  {5607, 5640, 5592},
  {5547, 5549, 5624},
  {5572, 5641, 5609},
  {5640, 5641, 5572},
  {5625, 5639, 5594},
  {5626, 5627, 5642},
  {5641, 5610, 5609},
  {5595, 5644, 5627},
  {5644, 5595, 5548},
  {5548, 5628, 5644},
  {5530, 5576, 5646},
  {5612, 5630, 5577},
  {5551, 5646, 5579},
  {5614, 5648, 5555},
  {5614, 5615, 5664},
  {5654, 5653, 5603},
  {5654, 5603, 5655},
  {5602, 5621, 5688},
  {5634, 5688, 5619},
  {5621, 5619, 5688},
  {5620, 5622, 5655},
  {5605, 5657, 5656},
  {5635, 5623, 5618},
  {5638, 5606, 5637},
  {5626, 5693, 5608},
  {5639, 5625, 5733},
  {5624, 5549, 5915},
  {5626, 5642, 5693},
  {5594, 5673, 5643},
  {5573, 5643, 5659},
  {5660, 5642, 5627},
  {5596, 5662, 5645},
  {5644, 5628, 5699},
  {5629, 5611, 5630},
  {5613, 5631, 5682},
  {5631, 5632, 5556},
  {5598, 5586, 5665},
  {5666, 5665, 5586},
  {5914, 5725, 5615},
  {5617, 5666, 5586},
  {5914, 5561, 5651},
  {5653, 5651, 5561},
  {5667, 5600, 5652},
  {5600, 5667, 5711},
  {5600, 5711, 5618},
  {5622, 5636, 5655},
  {5605, 5656, 5746},
  {5605, 5746, 5636},
  {5635, 5618, 5711},
  {5658, 5569, 5669},
  {5689, 5669, 5608},
  {5733, 5625, 5638},
  {5624, 5690, 5607},
  {5693, 5689, 5608},
  {5549, 5671, 5915},
  {5642, 5661, 5693},
  {5672, 5640, 5607},
  {5671, 5549, 5659},
  {5642, 5660, 5661},
  {5639, 5673, 5594},
  {5672, 5676, 5640},
  {5640, 5676, 5641},
  {5660, 5627, 5661},
  {5662, 5596, 5610},
  {5628, 5629, 5699},
  {5678, 5699, 5629},
  {5630, 5678, 5629},
  {5704, 5678, 5630},
  {5576, 5681, 5646},
  {5630, 5612, 5705},
  {5613, 5663, 5647},
  {5680, 5647, 5663},
  {5613, 5682, 5663},
  {5646, 5682, 5631},
  {5647, 5680, 5706},
  {5648, 5614, 5683},
  {5664, 5615, 5725},
  {5598, 5665, 5684},
  {5598, 5684, 5652},
  {5584, 5650, 5686},
  {5708, 5651, 5653},
  {5652, 5727, 5667},
  {5653, 5654, 5708},
  {5687, 5634, 5584},
  {5601, 5602, 5688},
  {5654, 5655, 5710},
  {5657, 5635, 5746},
  {5668, 5638, 5637},
  {5730, 5658, 5669},
  {5668, 5670, 5638},
  {5638, 5670, 5733},
  {5690, 5624, 5713},
  {5690, 5714, 5607},
  {5639, 5733, 5694},
  {5639, 5694, 5673},
  {5673, 5694, 5766},
  {5643, 5715, 5659},
  {5610, 5641, 5662},
  {5661, 5627, 5674},
  {5661, 5674, 5693},
  {5662, 5641, 5717},
  {5697, 5674, 5627},
  {5644, 5697, 5627},
  {5698, 5677, 5675},
  {5700, 5675, 5677},
  {5675, 5700, 5696},
  {5641, 5676, 5717},
  {5737, 5697, 5644},
  {5644, 5699, 5737},
  {5662, 5716, 5645},
  {5716, 5679, 5645},
  {5700, 5698, 5702},
  {5698, 5700, 5677},
  {5720, 5678, 5704},
  {5681, 5576, 5679},
  {5740, 5701, 5680},
  {5680, 5663, 5740},
  {5682, 5646, 5681},
  {5681, 5721, 5682},
  {5648, 5705, 5612},
  {5614, 5664, 5683},
  {5650, 5649, 5742},
  {5686, 5650, 5742},
  {5684, 5665, 5726},
  {5665, 5666, 5726},
  {5725, 5914, 5651},
  {5666, 5617, 5685},
  {5685, 5617, 5688},
  {5687, 5688, 5634},
  {5710, 5709, 5654},
  {5635, 5711, 5746},
  {5668, 5658, 5730},
  {5658, 5668, 5637},
  {5668, 5712, 5670},
  {5713, 5691, 5690},
  {5690, 5691, 5692},
  {5690, 5692, 5714},
  {5915, 5713, 5624},
  {5607, 5714, 5672},
  {5674, 5695, 5693},
  {5714, 5675, 5672},
  {5673, 5715, 5643},
  {5714, 5698, 5675},
  {5676, 5672, 5675},
  {5675, 5696, 5676},
  {5702, 5698, 5739},
  {5681, 5679, 5718},
  {5702, 5719, 5700},
  {5680, 5701, 5703},
  {5703, 5706, 5680},
  {5704, 5630, 5705},
  {5704, 5705, 5723},
  {5721, 5663, 5682},
  {5723, 5705, 5648},
  {5723, 5648, 5683},
  {5647, 5742, 5649},
  {5707, 5664, 5725},
  {5707, 5683, 5664},
  {5742, 5743, 5686},
  {5725, 5651, 5708},
  {5666, 5685, 5726},
  {5652, 5684, 5727},
  {5686, 5687, 5584},
  {5654, 5709, 5708},
  {5710, 5655, 5636},
  {5656, 5657, 5746},
  {5730, 5669, 5728},
  {5730, 5712, 5668},
  {5692, 5691, 5713},
  {5712, 5781, 5670},
  {5732, 5693, 5734},
  {5671, 5659, 5765},
  {5693, 5695, 5734},
  {5671, 5735, 5714},
  {5673, 5766, 5715},
  {5698, 5714, 5735},
  {5695, 5674, 5736},
  {5799, 5736, 5674},
  {5674, 5697, 5799},
  {5768, 5676, 5696},
  {5662, 5717, 5716},
  {5717, 5676, 5768},
  {5699, 5738, 5737},
  {5716, 5718, 5679},
  {5699, 5678, 5738},
  {5678, 5720, 5738},
  {5700, 5719, 5770},
  {5740, 5663, 5721},
  {5753, 5704, 5723},
  {5753, 5720, 5704},
  {5742, 5647, 5706},
  {5724, 5683, 5707},
  {5724, 5707, 5725},
  {5684, 5726, 5757},
  {5743, 5755, 5686},
  {5727, 5684, 5758},
  {5685, 5688, 5745},
  {5687, 5745, 5688},
  {5708, 5709, 5760},
  {5761, 5711, 5667},
  {5746, 5711, 5761},
  {5730, 5728, 5729},
  {5731, 5729, 5728},
  {5728, 5669, 5731},
  {5732, 5669, 5689},
  {5689, 5693, 5732},
  {5733, 5764, 5694},
  {5735, 5671, 5765},
  {5659, 5715, 5765},
  {5766, 5694, 5764},
  {5747, 5695, 5736},
  {5695, 5747, 5734},
  {5735, 5748, 5698},
  {5697, 5737, 5799},
  {5717, 5750, 5716},
  {5784, 5739, 5698},
  {5718, 5721, 5681},
  {5741, 5702, 5739},
  {5751, 5701, 5786},
  {5740, 5721, 5718},
  {5701, 5751, 5703},
  {5719, 5789, 5770},
  {5741, 5722, 5702},
  {5719, 5702, 5789},
  {5722, 5775, 5702},
  {5706, 5772, 5742},
  {5683, 5754, 5723},
  {5724, 5777, 5754},
  {5724, 5754, 5683},
  {5708, 5809, 5725},
  {5756, 5726, 5685},
  {5744, 5757, 5726},
  {5755, 5745, 5686},
  {5684, 5757, 5758},
  {5686, 5745, 5687},
  {5759, 5708, 5760},
  {5667, 5727, 5761},
  {5709, 5710, 5760},
  {5710, 5636, 5762},
  {5729, 5731, 5730},
  {5732, 5731, 5669},
  {5731, 5732, 5730},
  {5730, 5732, 5712},
  {5748, 5735, 5765},
  {5734, 5747, 5783},
  {5747, 5736, 5783},
  {5784, 5698, 5748},
  {5768, 5696, 5785},
  {5749, 5750, 5717},
  {5737, 5738, 5769},
  {5750, 5701, 5716},
  {5716, 5701, 5718},
  {5701, 5740, 5718},
  {5769, 5738, 5720},
  {5769, 5720, 5752},
  {5752, 5720, 5753},
  {5703, 5772, 5706},
  {5753, 5723, 5773},
  {5741, 5806, 5722},
  {5774, 5722, 5806},
  {5722, 5774, 5775},
  {5773, 5723, 5754},
  {5743, 5742, 5839},
  {5743, 5839, 5755},
  {5777, 5724, 5725},
  {5809, 5777, 5725},
  {5744, 5726, 5778},
  {5761, 5727, 5779},
  {5710, 5762, 5760},
  {5762, 5636, 5746},
  {5780, 5746, 5761},
  {5715, 5767, 5765},
  {5767, 5715, 5766},
  {5736, 5799, 5783},
  {5748, 5798, 5784},
  {5749, 5786, 5750},
  {5700, 5785, 5696},
  {5700, 5788, 5785},
  {5750, 5786, 5701},
  {5787, 5751, 5786},
  {5700, 5770, 5788},
  {5823, 5751, 5787},
  {5703, 5751, 5823},
  {5802, 5800, 5752},
  {5752, 5753, 5802},
  {5802, 5753, 5773},
  {5806, 5741, 5771},
  {5702, 5775, 5776},
  {5790, 5742, 5772},
  {5805, 5754, 5777},
  {5745, 5755, 5839},
  {5810, 5744, 5778},
  {5778, 5726, 5756},
  {5778, 5756, 5916},
  {5759, 5809, 5708},
  {5727, 5758, 5779},
  {5852, 5759, 5760},
  {5762, 5746, 5871},
  {5797, 5792, 5763},
  {5781, 5782, 5733},
  {5733, 5782, 5797},
  {5733, 5797, 5764},
  {5831, 5763, 5734},
  {5767, 5798, 5765},
  {5766, 5764, 5830},
  {5765, 5798, 5748},
  {5783, 5831, 5734},
  {5768, 5786, 5717},
  {5769, 5799, 5737},
  {5717, 5786, 5749},
  {5752, 5800, 5769},
  {5739, 5801, 5741},
  {5800, 5802, 5822},
  {5801, 5803, 5771},
  {5801, 5771, 5741},
  {5770, 5789, 5824},
  {5703, 5825, 5772},
  {5806, 5771, 5803},
  {5774, 5847, 5775},
  {5791, 5775, 5847},
  {5702, 5776, 5789},
  {5773, 5754, 5805},
  {5775, 5791, 5776},
  {5790, 5804, 5807},
  {5745, 5826, 5685},
  {5756, 5685, 5826},
  {5756, 5826, 5916},
  {5779, 5850, 5811},
  {5779, 5758, 5850},
  {5757, 5744, 5810},
  {5757, 5810, 5758},
  {5761, 5779, 5811},
  {5852, 5760, 5762},
  {5780, 5761, 5811},
  {5746, 5780, 5812},
  {5793, 5794, 5795},
  {5793, 5795, 5782},
  {5782, 5795, 5796},
  {5766, 5830, 5767},
  {5787, 5786, 5768},
  {5784, 5821, 5739},
  {5801, 5739, 5821},
  {5703, 5823, 5825},
  {5790, 5772, 5804},
  {5791, 5847, 5789},
  {5789, 5776, 5791},
  {5773, 5805, 5837},
  {5806, 5803, 5836},
  {5742, 5790, 5839},
  {5774, 5806, 5808},
  {5839, 5790, 5807},
  {5826, 5745, 5839},
  {5806, 5827, 5808},
  {5809, 5759, 5852},
  {5812, 5871, 5746},
  {5792, 5813, 5814},
  {5794, 5793, 5815},
  {5816, 5794, 5817},
  {5792, 5818, 5813},
  {5794, 5819, 5795},
  {5818, 5795, 5819},
  {5795, 5818, 5796},
  {5853, 5763, 5820},
  {5783, 5799, 5831},
  {5784, 5798, 5854},
  {5767, 5854, 5798},
  {5787, 5768, 5785},
  {5785, 5788, 5787},
  {5769, 5800, 5799},
  {5784, 5835, 5821},
  {5822, 5855, 5800},
  {5824, 5788, 5770},
  {5803, 5801, 5844},
  {5772, 5825, 5804},
  {5789, 5857, 5824},
  {5802, 5773, 5837},
  {5807, 5804, 5857},
  {5857, 5847, 5807},
  {5837, 5805, 5838},
  {5836, 5858, 5806},
  {5774, 5808, 5847},
  {5805, 5777, 5838},
  {5838, 5777, 5809},
  {5858, 5848, 5806},
  {5778, 5916, 5810},
  {5808, 5827, 5847},
  {5827, 5806, 5848},
  {5849, 5847, 5827},
  {5810, 5828, 5758},
  {5851, 5758, 5828},
  {5758, 5851, 5850},
  {5840, 5780, 5811},
  {5812, 5780, 5840},
  {5815, 5819, 5829},
  {5831, 5820, 5763},
  {5842, 5841, 5832},
  {5841, 5842, 5833},
  {5854, 5835, 5784},
  {5834, 5832, 5864},
  {5832, 5834, 5842},
  {5800, 5855, 5799},
  {5864, 5843, 5834},
  {5835, 5833, 5842},
  {5821, 5835, 5842},
  {5844, 5801, 5821},
  {5824, 5823, 5788},
  {5822, 5802, 5837},
  {5828, 5810, 5849},
  {5852, 5762, 5861},
  {5762, 5871, 5861},
  {5820, 5841, 5853},
  {5854, 5767, 5830},
  {5820, 5831, 5862},
  {5820, 5832, 5841},
  {5833, 5835, 5854},
  {5832, 5820, 5864},
  {5834, 5843, 5842},
  {5823, 5824, 5825},
  {5803, 5844, 5865},
  {5803, 5865, 5836},
  {5822, 5837, 5846},
  {5789, 5847, 5857},
  {5838, 5809, 5880},
  {5851, 5828, 5879},
  {5841, 5830, 5853},
  {5830, 5841, 5833},
  {5844, 5842, 5843},
  {5842, 5844, 5821},
  {5822, 5846, 5855},
  {5843, 5856, 5845},
  {5804, 5824, 5857},
  {5824, 5804, 5825},
  {5846, 5874, 5845},
  {5845, 5874, 5877},
  {5837, 5838, 5874},
  {5858, 5866, 5848},
  {5868, 5880, 5809},
  {5859, 5848, 5860},
  {5848, 5859, 5827},
  {5879, 5849, 5827},
  {5849, 5810, 5916},
  {5852, 5870, 5869},
  {5852, 5869, 5809},
  {5852, 5861, 5871},
  {5852, 5871, 5870},
  {5871, 5812, 5870},
  {5811, 5872, 5840},
  {5870, 5812, 5840},
  {5830, 5833, 5854},
  {5855, 5831, 5799},
  {5863, 5862, 5873},
  {5862, 5864, 5820},
  {5862, 5863, 5864},
  {5843, 5864, 5873},
  {5843, 5873, 5856},
  {5855, 5856, 5873},
  {5845, 5856, 5846},
  {5877, 5844, 5843},
  {5843, 5845, 5877},
  {5865, 5878, 5836},
  {5837, 5874, 5846},
  {5880, 5874, 5838},
  {5847, 5849, 5807},
  {5848, 5866, 5860},
  {5866, 5867, 5860},
  {5867, 5875, 5860},
  {5875, 5876, 5860},
  {5869, 5868, 5809},
  {5870, 5860, 5869},
  {5828, 5849, 5879},
  {5870, 5872, 5860},
  {5870, 5840, 5872},
  {5831, 5873, 5862},
  {5873, 5864, 5863},
  {5855, 5873, 5831},
  {5855, 5846, 5856},
  {5881, 5836, 5878},
  {5836, 5881, 5858},
  {5866, 5858, 5881},
  {5866, 5875, 5867},
  {5849, 5916, 5807},
  {5876, 5869, 5860},
  {5850, 5851, 5879},
  {5865, 5844, 5877},
  {5877, 5878, 5865},
  {5875, 5866, 5881},
  {5876, 5875, 5868},
  {5827, 5859, 5879},
  {5879, 5859, 5850},
  {5874, 5882, 5877},
  {5868, 5882, 5880},
  {5868, 5869, 5876},
  {5874, 5880, 5882},
  {5878, 5882, 5881},
  {5881, 5882, 5875},
  {5882, 5868, 5875},
  {5877, 5882, 5878},
  {   0,   21,    4},
  {   0,   22,   21},
  {  22,   32,   38},
  {   0,    4,    1},
  {  16,   26,   10},
  {  16,   11,    4},
  {5883,  139,   39},
  {5883,   61,  139},
  {5883,   39,   60},
  { 183,   61,  102},
  { 102,   96,  103},
  { 102,  103,   76},
  { 102,   61,   96},
  {  80,   76,   81},
  {  80,   81,   78},
  { 102,   80,   79},
  {  70,   60,   33},
  {5885, 5884,   26},
  {5884,  143,   26},
  {5885,  127, 5884},
  {5886,  118,   72},
  {5886,  137,  152},
  { 160,  193,  229},
  { 177,  123,  176},
  { 255,  254,  276},
  { 254,  255,  274},
  {5888,  362,  300},
  { 429,  328,  397},
  { 398,  222,  251},
  { 329,  398,  393},
  { 286,  378,  350},
  { 491,  392,  325},
  {5889,  697,  836},
  {5889,  577,  492},
  { 697, 5889,  698},
  {5889,  492,  578},
  { 623,  791, 5890},
  {5890,  838,  789},
  {5890,  789,  790},
  {5891, 1218, 1088},
  {1075, 1305, 1306},
  {1075, 1306, 5892},
  {1305, 1075, 1509},
  {5893, 5894, 1424},
  {5894, 1537, 1424},
  {5893, 1424, 1594},
  {1594, 1424, 1600},
  {5895, 1675, 1490},
  {1480, 1333, 1332},
  {1655, 1847, 5896},
  {1847, 1784, 1948},
  {2110, 2187, 2113},
  {2187, 2186, 2114},
  {2187, 2184, 2186},
  {2184, 2264, 2186},
  {2264, 2185, 2186},
  {2555, 2763, 2561},
  {2763, 2835, 2561},
  {5898, 2561, 2900},
  {2561, 2835, 2900},
  {2692, 5898, 2977},
  {2763, 2897, 2835},
  {2929, 2666, 5899},
  {5900, 2929, 5899},
  {5900, 5899, 3058},
  {2470, 2874, 5901},
  {5901, 2875, 2879},
  {2879, 3075, 2951},
  {2879, 2875, 3075},
  {2874, 2470, 2467},
  {2874, 2467, 2810},
  {3193, 3077, 2951},
  {5902, 2635, 2766},
  {5903, 3039, 3211},
  {5904, 3041, 3219},
  {3297, 3350, 3462},
  {5905, 3748, 3639},
  {3806, 3748, 5905},
  {3700, 3701, 3914},
  {4015, 5906, 4076},
  {4015, 4201, 5906},
  {5906, 4140, 4076},
  {5907, 4426, 4317},
  {5908, 4665, 4521},
  {5908, 4568, 4665},
  {5908, 5909, 4568},
  {4521, 4665, 4428},
  {4428, 4425, 4521},
  {4428, 4372, 4425},
  {5909, 4569, 4623},
  {5909, 4623, 4568},
  {4317, 4431, 5907},
  {4773, 5910, 4605},
  {4773, 4605, 4779},
  {5910, 4773, 4818},
  {4818, 4604, 5910},
  {4605, 5910, 4360},
  {4794, 4882, 5911},
  {4909, 4697, 4869},
  {5912, 5010, 4829},
  {4955, 4824, 4786},
  {4826, 4921, 4920},
  {5248, 5180, 5913},
  {5913, 5211, 5248},
  {5479, 5523, 5562},
  {5479, 5562, 5623},
  {5914, 5589, 5561},
  {5915, 5692, 5713},
  {5915, 5671, 5692},
  {5692, 5671, 5714},
  {5712, 5734, 5763},
  {5781, 5733, 5670},
  {5712, 5763, 5792},
  {5712, 5732, 5734},
  {5712, 5814, 5781},
  {5712, 5792, 5814},
  {5814, 5793, 5781},
  {5793, 5782, 5781},
  {5793, 5814, 5815},
  {5814, 5813, 5815},
  {5815, 5818, 5819},
  {5815, 5813, 5818},
  {5788, 5823, 5787},
  {5797, 5763, 5764},
  {5763, 5830, 5764},
  {5797, 5818, 5792},
  {5860, 5917, 5859},
  {5859, 5917, 5850},
  {5917, 5811, 5850},
  {5917, 5872, 5811},
  {  23,   32,   22},
  {  22,   38,   21},
  { 102,   76,   80},
  { 433,  362, 5888},
  { 836,  577, 5889},
  { 697,  698,  789},
  { 947, 5891, 1088},
  {5891,  987, 1129},
  {5894, 1238, 1145},
  {5894, 5893, 1238},
  {1655, 1784, 1847},
  {2561, 2492, 2555},
  {5900, 2931, 2929},
  {3896, 4011, 4135},
  {4201, 4015, 4013},
  {5907, 5909, 4426},
  {4476, 4426, 5909},
  {5909, 5907, 4569},
  {5829, 5794, 5815},
  {5782, 5796, 5797},
  {5796, 5818, 5797},
  {5829, 5816, 5817},
  {5817, 5794, 5829},
  {5819, 5794, 5816},
  {5829, 5819, 5816},
  {5807, 5826, 5839},
  {5860, 5872, 5917},
  {5908, 4476, 5909},
  {5155, 5211, 5913},
  {5763, 5853, 5830},
  {5807, 5916, 5826},
};

SVV_NAMESPACE_BEGIN

svvModel spheresurf( "spheresurf",
                     spheresurf_vertices, spheresurf_nvertices,
                     spheresurf_indices, spheresurf_nindices );

SVV_NAMESPACE_END

#endif /* SVV_SPHERESURF_H_ */
/*
 * End of: $Id: spheresurf.h,v 1.1.1.1 2006/12/19 22:59:28 christianh Exp $.
 * 
 */
