/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvModelSource.h,v 1.1.1.1 2006/12/19 22:58:36 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MODEL_SOURCE_H_
#  define SVV_MODEL_SOURCE_H_
#  include "svvMacros.h"
// VTK Filtering
#  include "vtkPolyDataSource.h"

SVV_NAMESPACE_BEGIN

/** \class   svvModelSource
 *  \brief   Creates a polygonal model centered at the origin.
 * 
 * \author  Sean McInerney
 * \version $Revision: 1.1.1.1 $
 * \date    $Date: 2006/12/19 22:58:36 $
 * 
 * \sa
 * vtkPolyDataSource
 */
class svvModelSource : public vtkPolyDataSource
{
public:
  static svvModelSource* New (void);
  vtkTypeRevisionMacro (svvModelSource, vtkPolyDataSource);
  void PrintSelf (ostream& os, vtkIndent indent);

  enum ModelType
  {
    VTK_EXT_TEAPOT = 0x0,
    VTK_EXT_COW,
    VTK_EXT_FACE,
    VTK_EXT_BOILER,
    VTK_EXT_MOTOR,
    VTK_EXT_PIALSURF,
    VTK_EXT_SPHERESURF,
    VTK_EXT_INFLATEDSURF,
    VTK_EXT_CORTEXSURF
  };

  /*@{*/
  /** Set/Get type of model. */
  vtkSetClampMacro (Model,int,VTK_EXT_TEAPOT,VTK_EXT_CORTEXSURF);
  vtkGetMacro (Model,int);
  void SetModelToTeapot (void)
    {this->SetModel(VTK_EXT_TEAPOT);}
  void SetModelToCow (void)
    {this->SetModel(VTK_EXT_COW);}
  void SetModelToFace (void)
    {this->SetModel(VTK_EXT_FACE);}
  void SetModelToBoiler (void)
    {this->SetModel(VTK_EXT_BOILER);}
  void SetModelToMotor (void)
    {this->SetModel(VTK_EXT_MOTOR);}
  void SetModelToPialSurface (void)
    {this->SetModel(VTK_EXT_PIALSURF);}
  void SetModelToSphereSurface (void)
    {this->SetModel(VTK_EXT_SPHERESURF);}
  void SetModelToInflatedSurface (void)
    {this->SetModel(VTK_EXT_INFLATEDSURF);}
  void SetModelToCortexSurface (void)
    {this->SetModel(VTK_EXT_CORTEXSURF);}
  const char* GetModelAsString (void);
  /*@}*/

  /*@{*/
  /** Set the scaling of the sphere (Default is 1.0). */
  vtkSetMacro (Scale,float);
  vtkGetMacro (Scale,float);
  /*@}*/

  /*@{*/
  /** Set the center of the sphere (Default is 0,0,0). */
  vtkSetVector3Macro (Center,float);
  vtkGetVectorMacro (Center,float,3);
  /*@}*/

  /*@{*/
  /** Toggle polygonal mesh normals in the output dataset. */
  vtkSetMacro (Normals,int);
  vtkGetMacro (Normals,int);
  vtkBooleanMacro (Normals,int);
  /*@}*/

protected:
  svvModelSource (void);
  ~svvModelSource();

  /** Execute method that should be used by subclasses of vtkSource. */
  void ExecuteData (vtkDataObject* vtkNotUsed(output));

  int   Model;
  float Scale;
  float Center[3];
  int   Normals;

private:
  svvModelSource (const svvModelSource&);  // Not implemented.
  void operator= (const svvModelSource&);  // Not implemented.
};

SVV_NAMESPACE_END

#endif /* SVV_MODEL_SOURCE_H_ */
/*
 * End of: $Id: svvModelSource.h,v 1.1.1.1 2006/12/19 22:58:36 christianh Exp $.
 * 
 */
