/* 
 * $Id: Usage.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $
 * 
 */
#include <iostream>

using std::ostream;
using std::endl;

void
PrintUsage(ostream& os, const char* progname)
{
  os << "Usage: " << progname << " -c 0.8 0.8 0.2 -i surface.vtk ..." << endl
     << endl
     << "  Flags requiring one or more file names:" << endl
     << "    -i <filename> : input surfaces" << endl
     << "        valid formats - VTK, OBJ, BYU, SLC, STL, and ASCII" << endl
     << "    -o <filename> : composite surface output" << endl
     << "        formats      - BYU, IV, PLY, STL, or VTK" << endl
     << "    -I <filename> : import 3DS or VRML scene" << endl
     << "    -E <filename> : export IV, OBJ, OOGL, RIB, or VRML scene" << endl
     << "  Flags affecting appearance of subsequent input(s):" << endl
     << "    -c <...>      : composite color; set by ..." << endl
     << "        -c <# # # #> - RGBA quadruplet [0.0 .. 1.0]" << endl
     << "        -c <# # #>   - RGB triplet [0.0 .. 1.0]" << endl
     << "        -c <name>    - defined color name (X11 defaults)" << endl
     << "    -m <name>     : material properties by name" << endl
     << "    -K? <#>       : reflectance scale factor [0.0 .. 1.0]" << endl
     << "    -K? <# # #>   : reflectance as RGB triplet [0.0 .. 1.0]" << endl
     << "        -Ka <...>    - ambient material reflectance" << endl
     << "        -Kd <...>    - diffuse material reflectance" << endl
     << "        -Ks <...>    - specular material reflectance" << endl
     << "    -Se <#>       : specular exponent [0.0 .. 128.0]" << endl
     << "    -a <alpha>    : set opacity [0.0 .. 1.0]" << endl
     << "    -F [<name>]   : show feature edges, (opt. material name)" << endl
     << "    -H [<name>]   : show convex hull, (opt. material name)" << endl
     << "        -H#          - create convex hull, recurse # times" << endl
     << "    -D [<0.9>] : mesh decimation (optional target reduction)" << endl
     << "    -D? [<1>]  : mesh subdivision (option # of subdivisions)" << endl
     << "        -Da <...>    - loop approximating subdivision" << endl
     << "        -Db <...>    - butterfly interpolating subdivision" << endl
     << "        -Dl <...>    - linear interpolating subdivision" << endl
     << "    -T <name>     : apply specified texture to next surface" << endl
     << "        -Tc <...>    - mapping to cylinder" << endl
     << "        -Tp <...>    - mapping to plane (default)" << endl
     << "        -Ts <...>    - mapping to sphere" << endl
     << "  Flags affecting optional view items:" << endl
     << "    -X            : show axes based on overall bounds" << endl
     << "    -B            : show overall bounding box" << endl
     << "    -V            : show volumetric information" << endl
     << "    -N            : force generation of normals" << endl
     << "    -O            : use orthographic viewing projection" << endl
     << "    -L <size>     : maximum actor size for display list use" << endl
     << "  Flags to generate test geometry:" << endl
     << "    -M [<res>]    : materials demonstration (opt. resolution)" << endl
     << "    -S <6-9 param>: generate parametric spiral shell" << endl
     << "                    (includes texure coordinates)" << endl
     << "        -S <theta res.> <phi res.> <num. spirals>" << endl
     << "           <final radius> <inner radius> <height>" << endl
     << "           [<flipX=0|1> <flipY=0|1> <flipZ=0|1>]" << endl
     << "        -St ...      - tessellate with triangles" << endl
     << "    -G <radius>   : generate sphere approximation via" << endl
     << "                    subdivided platonic polyhedra (includes" << endl
     << "                    texure coordinates)" << endl
     << "    -G# ...          - recursively subdivide # times" << endl
     << "    -G#s ...         - prevent seam (when texturing)" << endl
     << "    -G#t || -G#ts ...- subdivide from tetrahedron" << endl
     << "    -G#h || -G#hs ...- subdivide from hexahedron (cube)" << endl
     << "    -G#o || -G#os ...- subdivide from octahedron" << endl
     << "    -G#i || -G#is ...- subdivide from icosahedron (20 sides)" << endl
     << "  Flags affecting debugging output:" << endl
     << "    -h            : show help and exit" << endl
     << "    -v            : verbose " << endl
     << "    -q            : quiet" << endl
     << endl;
}

void
PrintMaterials(ostream& os)
{
  os << "Any of the standard X11 RGB color names may be specified." << endl
     << "These are typically listed in a text file at either:" << endl
     << "\t/usr/X11R6/lib/rgb.txt" << endl
     << "\t\t- or -" << endl
     << "\t/usr/openwin/lib/rgb.txt" << endl
     << endl
     << "Availible defined material names:"
     << "\t\"default\" (neutral, med-bright tone, i.e. very light grey)" << endl
     << "  Metal (directional, shiny):" << endl
     << "\t\"brass\"  \"bronze\"          \"polished bronze\"" << endl
     << "\t\"chrome\" \"copper\"          \"polished copper\"" << endl
     << "\t\"gold\"   \"polished gold\"   \"pewter\"" << endl
     << "\t\"silver\" \"polished silver\"" << endl
     << "  Gemstone (transparent, shiny):" << endl
     << "\t\"emerald\"  \"ruby\"" << endl
     << "  Semi-Precious (translucent, satin-tone):" << endl
     << "\t\"jade\"  \"obsidian\"  \"pearl\"  \"turquoise\"" << endl
     << "  Plastic (saturated, shiny):" << endl
     << "\t\"black plastic\"  \"cyan plastic\"    \"green plastic\"" << endl
     << "\t\"red plastic\"    \"white plastic\"   \"yellow plastic\"" << endl
     << "\t\"gray plastic\"   \"blue plastic\"    \"dark green plastic\""<< endl
     << "\t\"purple plastic\" \"magenta plastic\"" << endl
     << "  Rubber (saturated, dull):" << endl
     << "\t\"black rubber\"    \"cyan rubber\"     \"green rubber\"" << endl
     << "\t\"red rubber\"      \"white rubber\"    \"yellow rubber\"" << endl
     << "\t\"gray rubber\"     \"blue rubber\"     \"magenta rubber\"" << endl
     << "\t\"lavender rubber\" \"sky blue rubber\"" << endl
     << "  Gloss (very shiny, glossy):" << endl
     << "\t\"gloss black\"      \"gloss blue\"        \"gloss brown\"" << endl
     << "\t\"gloss dark green\" \"gloss light green\" \"gloss orange\"" << endl
     << "\t\"gloss red\"        \"gloss tan\"         \"gloss teal\"" << endl
     << "\t\"gloss violet\"     \"gloss white\"       \"gloss yellow\"" << endl
     << endl;
}

/* 
 * End of: $Id: Usage.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $.
 * 
 */
