/* -*- C++ -*-
 * 
 * $Id: svColorChooserUICb.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// VTK
#include "vtkSuperquadricSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkFeatureEdges.h"
#include "vtkRenderer.h"
// SV
#include "svView.H"
#include "svColorChooserUI.H"
#include "SV.H"


//-----------------------------------------------------------------------------
void
SetRedCb(Fl_Widget* w, void* p)
{
  static float rgb[3] = {0.f, 0.f, 0.f};

  Fl_Valuator* red = reinterpret_cast<Fl_Valuator*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);

  (chooser->GetProperty())->GetColor(rgb);
  rgb[0] = float(red->value());
  (chooser->GetProperty())->SetColor(rgb);
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
SetGreenCb(Fl_Widget* w, void* p)
{
  static float rgb[3] = {0.f, 0.f, 0.f};

  Fl_Valuator* green = reinterpret_cast<Fl_Valuator*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);

  (chooser->GetProperty())->GetColor(rgb);
  rgb[1] = float(green->value());
  (chooser->GetProperty())->SetColor(rgb);
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
SetBlueCb(Fl_Widget* w, void* p)
{
  static float rgb[3] = {0.f, 0.f, 0.f};

  Fl_Valuator* blue = reinterpret_cast<Fl_Valuator*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);

  (chooser->GetProperty())->GetColor(rgb);
  rgb[2] = float(blue->value());
  (chooser->GetProperty())->SetColor(rgb);
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
SetAlphaCb(Fl_Widget* w, void* p)
{
  static float alpha = 0.f;

  Fl_Valuator* alpha = reinterpret_cast<Fl_Valuator*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);

  alpha = float(alpha->value());
  (chooser->GetProperty())->SetOpacity(alpha);
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
ShadingCb(Fl_Widget* w, void* p)
{
  Fl_Menu_* menu = reinterpret_cast<Fl_Menu_*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  int index = menu->value();
  const Fl_Menu_Item* item = menu->mvalue();

  switch (index) {
  case 0:  (chooser->GetProperty())->SetInterpolationToFlat(); break;
  case 1:  (chooser->GetProperty())->SetInterpolationToGouraud(); break;
  case 2:  (chooser->GetProperty())->SetInterpolationToPhong(); break;
  default: (chooser->GetProperty())->SetInterpolationToGouraud(); break;
  }

  menu->label(item->label());
  menu->redraw();
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
RepresentationCb(Fl_Widget* w, void* p)
{
  Fl_Menu_* menu = reinterpret_cast<Fl_Menu_*>(w);
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  int index = menu->value();
  const Fl_Menu_Item* item = menu->mvalue();

  switch (index) {
  case 0:  (chooser->GetProperty())->SetRepresentationToPoints(); break;
  case 1:  (chooser->GetProperty())->SetRepresentationToWireframe(); break;
  case 2:  (chooser->GetProperty())->SetRepresentationToSurface(); break;
  default: (chooser->GetProperty())->SetRepresentationToSurface(); break;
  }

  menu->label(item->label());
  menu->redraw();
  chooser->ApplyProperties();
}

//-----------------------------------------------------------------------------
void
ApplyCb(Fl_Widget*, void* p)
{
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  chooser->tmp->DeepCopy(chooser->GetProperty());
  chooser->applied = 1;
}

//-----------------------------------------------------------------------------
void
CancelCb(Fl_Widget*, void* p)
{
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  chooser->Hide();
}

//-----------------------------------------------------------------------------
void
AcceptCb(Fl_Widget*, void* p)
{
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  chooser->tmp->DeepCopy(chooser->GetProperty());
  chooser->applied = 1;
  chooser->Hide();
}

//-----------------------------------------------------------------------------
void
HelpCb(Fl_Widget*, void* p)
{
  svColorChooserUI* chooser = reinterpret_cast<svColorChooserUI*>(p);
  // ... do something helpful here ...
}


//-----------------------------------------------------------------------------
void
svColorChooserUI::PrintSelf(ostream& os, vtkIndent indent)
{
  if(this->tmp) {
    os << indent << "tmp (vtkProperty):\n";
    this->tmp->PrintSelf(os,indent.GetNextIndent());
  }
  else {
    os << indent << "tmp (vtkProperty): (none)\n";
  }

  os << indent << "            applied: " << this->applied << "\n";
}

//-----------------------------------------------------------------------------
svColorChooserUI*
svColorChooserUI::New(void)
{
  // First try to create the object from the vtkGraphicsFactory
  vtkObject* ret = vtkGraphicsFactory::CreateInstance("svColorChooserUI");
  if(ret) {
    return reinterpret_cast<svColorChooserUI*>(ret);
  }
  // If the factory was unable to create the object, then create it here.
  return new svColorChooserUI;
}

//-----------------------------------------------------------------------------
void
svColorChooserUI::Init(void)
{
  this->mainWindow->show(SV::argc(),SV::argv());

  this->tmp = 0;
  this->applied = 0;
  // Create some test geometry and add it to the actor.
  vtkSuperquadricSource* source1 = vtkSuperquadricSource::New();
  vtkSuperquadricSource* source2 = vtkSuperquadricSource::New();
  source1->ToroidalOff();            source2->ToroidalOff();
  source1->SetThetaResolution(32);   source2->SetThetaResolution(32);
  source1->SetPhiResolution(32);     source2->SetPhiResolution(32);
  source1->SetPhiRoundness(0.3);     source2->SetPhiRoundness(0.7);
  source1->SetThetaRoundness(0.85);  source2->SetThetaRoundness(1.25);
  source1->SetScale(1.0, 1.0, 1.0);  source2->SetScale(0.8, 0.8, 0.8);
  source1->SetCenter(0.0, 0.0, 0.0); source2->SetCenter(-0.3, 0.3, 0.0);
  source1->Update();                 source2->Update();

  vtkPolyDataMapper* mapper1 = vtkPolyDataMapper::New();
  mapper1->SetInput(source1->GetOutput());

  vtkActor* actor1 = vtkActor::New();
  actor1->SetMapper(mapper1);
  (actor1->GetProperty())->SetOpacity(0.2);
  
  vtkFeatureEdges* featureEdges1 = vtkFeatureEdges::New();
  featureEdges1->SetInput(source1->GetOutput());
  featureEdges1->BoundaryEdgesOn();
  featureEdges1->ColoringOff();
  featureEdges1->ManifoldEdgesOff();
  
  vtkPolyDataMapper* mapper1fe =  vtkPolyDataMapper::New();
  mapper1fe->SetInput(featureEdges1->GetOutput());
  mapper1fe->SetResolveCoincidentTopologyToPolygonOffset();

  vtkActor* actor1fe = vtkActor::New();
  actor1fe->SetMapper(mapper1fe);

  vtkRenderer* renderer = this->View->GetCurrentRenderer();
  renderer->AddActor(actor1fe);
  renderer->AddActor(actor1);
  
  vtkPolyDataMapper* mapper2 = vtkPolyDataMapper::New();
  mapper2->SetInput(source2->GetOutput());
  this->SetMapper(mapper2);
  renderer->AddActor(this);

  // clean up references
  source1->Delete();
  mapper1->Delete();
  featureEdges1->Delete();
  mapper1fe->Delete();
  actor1fe->Delete();
  actor1->Delete();
  actor1fe->Delete();
  source2->Delete();
  mapper2->Delete();

  renderer->Render();
  this->mainWindow->hide();
}

//-----------------------------------------------------------------------------
void
svColorChooserUI::PropertyToValues(void)
{
  static float rgba[4] = {0.f, 0.f, 0.f, 0.f};

  (this->GetProperty())->GetColor(rgba);
  rgba[3] = (this->GetProperty())->GetOpacity();

  this->RedValue->value(double(rgba[0]));
  this->GreenValue->value(double(rgba[1]));
  this->BlueValue->value(double(rgba[2]));
  this->AlphaValue->value(double(rgba[3]));

  switch ((this->GetProperty())->GetInterpolation()) {
  case VTK_FLAT:    this->ShadingMenu->value(0); break;
  case VTK_GOURAUD:
  case VTK_PHONG:   this->ShadingMenu->value(1); break;
  default:          this->ShadingMenu->value(1); break;
  }
  this->ShadingMenu->label((this->ShadingMenu->mvalue())->label());

  switch ((this->GetProperty())->GetRepresentation()) {
  case VTK_POINTS:    this->RepresentationMenu->value(0); break;
  case VTK_WIREFRAME: this->RepresentationMenu->value(1); break;
  case VTK_SURFACE:   this->RepresentationMenu->value(2); break;
  default:            this->RepresentationMenu->value(2); break;
  }
  this->RepresentationMenu->label((this->RepresentationMenu->mvalue())->label());
}

//-----------------------------------------------------------------------------
void
svColorChooserUI::ValuesToProperty(void)
{
  static float rgba[4] = {0.f, 0.f, 0.f, 0.f};

  rgba[0] = double(this->RedValue->value());
  rgba[1] = double(this->GreenValue->value());
  rgba[2] = double(this->BlueValue->value());
  rgba[3] = double(this->AlphaValue->value());

  (this->GetProperty())->SetColor(rgba);
  (this->GetProperty())->SetOpacity(rgba[3]);

  switch (this->ShadingMenu->value()) {
  case 0:  (this->GetProperty())->SetInterpolationToFlat(); break;
  case 1:  (this->GetProperty())->SetInterpolationToGouraud(); break;
  case 2:  (this->GetProperty())->SetInterpolationToPhong(); break;
  default: (this->GetProperty())->SetInterpolationToGouraud(); break;
  }

  switch (this->RepresentationMenu->value()) {
  case 0:  (this->GetProperty())->SetRepresentationToPoints(); break;
  case 1:  (this->GetProperty())->SetRepresentationToWireframe(); break;
  case 2:  (this->GetProperty())->SetRepresentationToSurface(); break;
  default: (this->GetProperty())->SetRepresentationToSurface(); break;
  }
}

//-----------------------------------------------------------------------------
int
svColorChooserUI::Show(vtkProperty*& src)
{
  if(!src) src = this->MakeProperty();
  this->tmp = src;
  this->applied = 0;

  (this->GetProperty())->DeepCopy(this->tmp);
  this->ApplyProperties();
  this->PropertyToValues();
  this->mainWindow->redraw();

  this->mainWindow->show(SV::argc(),SV::argv());
  while(this->mainWindow->shown()) Fl::wait();

  this->tmp = 0;
  return this->applied;
}

//-----------------------------------------------------------------------------
void
svColorChooserUI::Hide()
{
  this->mainWindow->hide();
}

//-----------------------------------------------------------------------------
int
svColorChooserUI::Shown()
{
  return this->mainWindow->shown();
}


/* 
 * End of: $Id: svColorChooserUICb.cxx,v 1.1.1.1 2006/12/19 22:59:32 christianh Exp $.
 * 
 */
