// 
// $Id: svProperty.cxx,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $
// 

#include "svProperty.H"

// 
// static functions
// 

void
svProperty::PrintMaterials(ostream& os)
{
  if(glIsEnabled(GL_LIGHTING)==GL_FALSE) {
    os << "Lighting Disabled\n";
  }
  else {
    if(glIsEnabled(GL_COLOR_MATERIAL)==GL_TRUE) {

      GLint cmface = 0, cmparam = 0;
      glGetIntegerv(GL_COLOR_MATERIAL_FACE, &cmface);
      glGetIntegerv(GL_COLOR_MATERIAL_PARAMETER, &cmparam);

      os << "ColorMaterial Enabled: ( ";
      switch (cmface)
        {
        case GL_FRONT_AND_BACK: os << "GL_FRONT_AND_BACK, "; break;
        case GL_FRONT:          os << "GL_FRONT, "; break;
        case GL_BACK:           os << "GL_BACK, "; break;
        default:                os << "INVALID, "; break;
        }
      switch (cmparam)
        {
        case GL_EMISSION:            os << "GL_EMISSION )\n"; break;
        case GL_AMBIENT:             os << "GL_AMBIENT )\n"; break;
        case GL_DIFFUSE:             os << "GL_DIFFUSE )\n"; break;
        case GL_SPECULAR:            os << "GL_SPECULAR )\n"; break;
        case GL_AMBIENT_AND_DIFFUSE: os << "GL_AMBIENT_AND_DIFFUSE )\n"; break;
        default:                     os << "INVALID )\n"; break;
        }
    }

    GLfloat v[4];
    GLenum face = GL_FRONT;
    GLboolean twoside = GL_FALSE;

    glGetBooleanv(GL_LIGHT_MODEL_TWO_SIDE, &twoside);

    os << "Material ( GL_FRONT )\n";
      
    glGetMaterialfv(GL_FRONT, GL_EMISSION, v);
    os << "\tKe = { " << v[0] << ", " << v[1] << ", "
       << v[2] << ", " << v[3] << " }\n";
    glGetMaterialfv(GL_FRONT, GL_AMBIENT, v);
    os << "\tKa = { " << v[0] << ", " << v[1] << ", "
       << v[2] << ", " << v[3] << " }\n";
    glGetMaterialfv(GL_FRONT, GL_DIFFUSE, v);
    os << "\tKd = { " << v[0] << ", " << v[1] << ", "
       << v[2] << ", " << v[3] << " }\n";
    glGetMaterialfv(GL_FRONT, GL_SPECULAR, v);
    os << "\tKs = { " << v[0] << ", " << v[1] << ", "
       << v[2] << ", " << v[3] << " }\n";
    glGetMaterialfv(GL_FRONT, GL_SHININESS, v);
    os << "\tSe = " << v[0] << "\n";

    if(twoside) {
      os << "Material ( GL_BACK )\n";

      glGetMaterialfv(GL_BACK, GL_EMISSION, v);
      os << "\tKe = { " << v[0] << ", " << v[1] << ", "
         << v[2] << ", " << v[3] << " }\n";
      glGetMaterialfv(GL_BACK, GL_AMBIENT, v);
      os << "\tKa = { " << v[0] << ", " << v[1] << ", "
         << v[2] << ", " << v[3] << " }\n";
      glGetMaterialfv(GL_BACK, GL_DIFFUSE, v);
      os << "\tKd = { " << v[0] << ", " << v[1] << ", "
         << v[2] << ", " << v[3] << " }\n";
      glGetMaterialfv(GL_BACK, GL_SPECULAR, v);
      os << "\tKs = { " << v[0] << ", " << v[1] << ", "
         << v[2] << ", " << v[3] << " }\n";
      glGetMaterialfv(GL_BACK, GL_SHININESS, v);
      os << "\tSe = " << v[0] << "\n";
    }
  }
}

void
svProperty::PrintLighting(ostream& os)
{
  if(glIsEnabled(GL_LIGHTING)==GL_TRUE) {

    GLfloat v[4];
      
    GLboolean localview = GL_FALSE, twoside = GL_FALSE;
    glGetBooleanv(GL_LIGHT_MODEL_LOCAL_VIEWER, &localview);
    glGetBooleanv(GL_LIGHT_MODEL_TWO_SIDE, &twoside);
    glGetFloatv(GL_LIGHT_MODEL_AMBIENT, v);

    os << "Lighting Enabled: ( " << (localview?"local":"infinite")
       << ", " << (twoside?"two-sided":"one-sided") << ", Ka = { "
       << v[0] << ", " << v[1] << ", " << v[2] << ", " << v[3] << " } )\n";

    GLint maxlights = 0;
    glGetIntegerv(GL_MAX_LIGHTS, &maxlights);
    GLuint pastlast = GLuint(maxlights + GL_LIGHT0);
    
    for(GLuint light = GLuint(GL_LIGHT0); light<pastlast; light++) {
      
      if(glIsEnabled(GLenum(light))==GL_TRUE) {
        
        os << "\tGL_LIGHT" << (light - GLuint(GL_LIGHT0)) << ":\n";
        
        glGetLightfv(light, GL_AMBIENT, v);
        os << "\t\tKa = { " << v[0] << ", " << v[1] << ", "
           << v[2] << ", " << v[3] << " }\n";
        glGetLightfv(light, GL_DIFFUSE, v);
        os << "\t\tKd = { " << v[0] << ", " << v[1] << ", "
           << v[2] << ", " << v[3] << " }\n";
        glGetLightfv(light, GL_SPECULAR, v);
        os << "\t\tKs = { " << v[0] << ", " << v[1] << ", "
           << v[2] << ", " << v[3] << " }\n";
        glGetLightfv(light, GL_POSITION, v);
        os << "\t\tposition = ( " << v[0] << ", " << v[1] << ", "
           << v[2] << ", " << v[3] << " )\n";
        glGetLightfv(light, GL_SPOT_DIRECTION, v);
        os << "\t\tdirection = ( " << v[0] << ", " << v[1] << ", "
           << v[2] << " )\n";
        glGetLightfv(light, GL_SPOT_EXPONENT, v);
        os << "\t\texponent = " << v[0] << "\n";
        glGetLightfv(light, GL_SPOT_CUTOFF, v);
        os << "\t\tcutoff = " << v[0] << "\n";
        glGetLightfv(light, GL_CONSTANT_ATTENUATION, &v[2]);
        glGetLightfv(light, GL_LINEAR_ATTENUATION, &v[1]);
        glGetLightfv(light, GL_QUADRATIC_ATTENUATION, &v[0]);
        os << "\t\tattenuation = " << v[0] << "c^2 + " << v[1]
           << "c + "<< v[2] << "\n";
      }
    }
  }
}

// 
// member functions
// 

void
svProperty::PrintMaterial(ostream& os, GLenum face, GLenum pname)
{
  if(face != GL_BACK) face = GL_FRONT;

  GLfloat v[4];
  glGetMaterialfv(face, pname, v);

  switch (pname) {
  case GL_AMBIENT:   os << "\t       GL_AMBIENT: "; break;
  case GL_DIFFUSE:   os << "\t       GL_DIFFUSE: "; break;
  case GL_SPECULAR:  os << "\t      GL_SPECULAR: "; break;
  case GL_EMISSION:  os << "\t      GL_EMISSION: "; break;
  case GL_SHININESS: os << "\t     GL_SHININESS: "; break;
  default: return;
  }

  if(pname == GL_SHININESS) os << v[0];
  else os << "(" << v[0] << ", " << v[1] << ", " << v[2] << ", " << v[3] << ")";

  os << "\t(" << this->GetFaceAsString(face) << ")\n";
}
    
void
svProperty::PrintLight(ostream& os, GLenum light, GLenum pname)
{
  GLuint index = GLuint(light) - GLuint(GL_LIGHT0);

  GLfloat v[4];
  glGetLightfv(light, pname, v);

  switch (pname) {
  case GL_AMBIENT:               os << "\t       GL_AMBIENT: "; break;
  case GL_DIFFUSE:               os << "\t       GL_DIFFUSE: "; break;
  case GL_SPECULAR:              os << "\t      GL_SPECULAR: "; break;
  case GL_POSITION:              os << "\t      GL_POSITION: "; break;
  case GL_SPOT_DIRECTION:        os << "\tGL_SPOT_DIRECTION: "; break;
  case GL_SPOT_EXPONENT:         os << "\t GL_SPOT_EXPONENT: "; break;
  case GL_SPOT_CUTOFF:           os << "\t   GL_SPOT_CUTOFF: "; break;
  case GL_CONSTANT_ATTENUATION:  os << "  GL_CONSTANT_ATTENUATION: "; break;
  case GL_LINEAR_ATTENUATION:    os << "    GL_LINEAR_ATTENUATION: "; break;
  case GL_QUADRATIC_ATTENUATION: os << " GL_QUADRATIC_ATTENUATION: "; break;
  default: return;
  }

  if( pname==GL_SPOT_EXPONENT || pname==GL_SPOT_CUTOFF || pname==GL_CONSTANT_ATTENUATION ||
      pname==GL_LINEAR_ATTENUATION || pname==GL_QUADRATIC_ATTENUATION )
    os << v[0];
  else if( pname==GL_SPOT_DIRECTION )
    os << "(" << v[0] << ", " << v[1] << ", " << v[2] << ")";
  else
    os << "(" << v[0] << ", " << v[1] << ", " << v[2] << ", " << v[3] << ")";

  os << "\t(GL_LIGHT" << index << ")\n";
}

void
svProperty::PrintSelf(ostream& os)
{
  os << "svProperty (" << this << "):\n"
     << "\t        Color = { " << this->Color[0] << ", " << this->Color[1]
     << ", " << this->Color[2] << " }\n"
     << "\t AmbientColor = { " << this->AmbientColor[0] << ", "
     << this->AmbientColor[1] << ", " << this->AmbientColor[2] << " }\n"
     << "\t DiffuseColor = { " << this->DiffuseColor[0] << ", "
     << this->DiffuseColor[1] << ", " << this->DiffuseColor[2] << " }\n"
     << "\tSpecularColor = { " << this->SpecularColor[0] << ", "
     << this->SpecularColor[1] << ", " << this->SpecularColor[2] << " }\n"
     << "\t      Ambient = " << this->Ambient << "\n"
     << "\t      Diffuse = " << this->Diffuse << "\n"
     << "\t     Specular = " << this->Specular << "\n"
     << "\t    Shininess = " << this->Shininess << "\n"
     << "\t      Opacity = " << this->Opacity << "\n"
     << "\t   ShadeModel = "
     << this->GetShadeModelAsString(this->ShadeModel) << "\n"
     << "\t  PolygonMode = "
     << this->GetPolygonModeAsString(this->PolygonMode) << "\n"
     << "\t        Debug = " << this->Debug << "\n";
}

// 
// End of: $Id: svProperty.cxx,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $.
// 
