/* -*- C++ -*-
 * 
 * $Id: svSelectedGroup.H,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVSELECTEDGROUP_H_
#  define SVSELECTEDGROUP_H_

#  include <FL/Fl.H>
#  include <FL/Fl_Group.H>
#  include <FL/Fl_Button.H>
#  include "svColorButton.H"
#  include <sys/param.h>


class svSelectedGroup : public Fl_Group
{
  Fl_Button     nameButton;
  svColorButton colorButton;
  Fl_Button     promoteButton;
  Fl_Button     demoteButton;
  Fl_Button     removeButton;
  Fl_End        end;
  char          PathName[MAXPATHLEN+1];

public:
  svSelectedGroup(int x,int y,int w,int h,const char* l=0);
  void        Name(const char* name);
  const char* Name() const {return this->nameButton.label();}
  void        SetPath(const char* path);
  void        SetPathName(const char* path, const char* name);
  void        SetPathName(const char* pathname);
  const char* GetPathName() const {return this->PathName;}
};

#endif /* SVSELECTEDGROUP_H_ */
