/* -*- C++ -*-
 * 
 * $Id: svSelectedGroup.cxx,v 1.1.1.1 2006/12/19 22:59:34 christianh Exp $
 * 
 * 
 * Copyright (c) 2002 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#include <FL/gl.h>
#include <FL/Fl_Window.H>
#include <iostream>
#include <cstring>
#include "svSelectedGroup.H"


void
RemoveCb(Fl_Widget* w, void* v)
{
  Fl_Group* group  = w->parent();
  Fl_Group* parent = group->parent();
  parent->remove(group);
  (parent->window())->redraw();
  delete group;
}

void
PromoteCb(Fl_Widget* w, void* v)
{
  Fl_Group* group  = w->parent();
  Fl_Group* parent = group->parent();
  int       index  = parent->find(group);
  parent->insert(*group,(index>0 ? index-1 : 0));
  (parent->window())->redraw();
}

void
DemoteCb(Fl_Widget* w, void* v)
{
  Fl_Group* group  = w->parent();
  Fl_Group* parent = group->parent();
  int       index  = parent->find(group);
  if(index<(parent->children()-1)) {
    parent->insert(*(parent->child(index+1)),index);
  }
  (parent->window())->redraw();
}

svSelectedGroup::svSelectedGroup(int x,int y,int w,int h,const char* l=0)
  : Fl_Group(x,y,w,h),
    nameButton( x+1, y+1, w-2.5*h-19, h-2, l ),
    colorButton(   w-2.5*h-16, y+1, (h-2)/1,  h-2 ),
    promoteButton( w-1.5*h-16, y+1, (h-2)/2,  h-2, "@2<-" ),
    demoteButton(  w-1.0*h-16, y+1, (h-2)/2,  h-2, "@2->" ),
    removeButton(  w-0.5*h-16, y+1, (h-2)/2,  h-2, "@1+" ),
    end()
{
  this->resizable(nameButton);
  this->box(FL_FLAT_BOX);
  this->colorButton.SetColor(1.f,0.f,0.f,0.5f);
  this->promoteButton.callback(PromoteCb);
  this->demoteButton.callback(DemoteCb);
  this->removeButton.callback(RemoveCb);
}

void
svSelectedGroup::Name(const char* name)
{
  this->nameButton.label(name);
}

void
svSelectedGroup::SetPath(const char* path)
{
  if(strlcpy(this->PathName,path,MAXPATHLEN+1)>MAXPATHLEN) {
    cerr << "SelectedGroup::SetPath() WARNING: path '" << path
         << "' exceeds system path length limit (" << MAXPATHLEN << ")\n";
  }
  if(this->PathName[strlen(this->PathName)-1] != '/') {
    if(strlcat(this->PathName,"/",MAXPATHLEN+1)>MAXPATHLEN) {
      cerr << "SelectedGroup::SetPath() WARNING: path '" << path
           << "/' exceeds system path length limit (" << MAXPATHLEN
           << ")\n";
    }
  }
  if(strlcat(this->PathName,this->Name(),MAXPATHLEN+1)>MAXPATHLEN) {
    cerr << "SelectedGroup::SetPath() WARNING: pathname '" << this->PathName
         << this->Name() << "' exceeds system path length limit ("
         << MAXPATHLEN << ")\n";
  }
}

void
svSelectedGroup::SetPathName(const char* path, const char* name)
{
  this->Name(name);
  this->SetPath(path);
}

void
svSelectedGroup::SetPathName(const char* pathname)
{
  char* ptr = 0;
  if(!(ptr = strrchr(pathname,'/'))) {
    this->Name(pathname);
    this->SetPath(".");
  }
  else {
    this->Name(ptr+1);
    if(strlcpy(this->PathName,pathname,MAXPATHLEN+1)>MAXPATHLEN) {
      cerr << "SelectedGroup::SetPath() WARNING: pathname '" << pathname
           << "' exceeds system path length limit (" << MAXPATHLEN << ")\n";
    }
  }
}

// EOF
