////////////////////////////////////////////////////////////////
// The control panels!

#include "widget_panel.h"
#include <FL/fl_show_colormap.H>

// All the callbacks use the argument to indicate whether to load or store.
// This avoids the need for pointers to all the widgets, and keeps the
// code localized in the callbacks.
// A value of LOAD means to load.  The hope is that this will not collide
// with any actual useful values for the argument.  I also use this to
// initialized parts of the widget that are nyi by fluid.

svWidgetType* current_widget; // one of the selected ones
static int numselected; // number selected
static int haderror;

void
name_cb(Fl_Input* o, void* v)
{
  if(v == LOAD) {
    if(numselected != 1) {
      static char buf[16];
      (void)snprintf(buf,16,"(%d widgets)",numselected);
      (reinterpret_cast<Fl_Window*>(o->parent()->parent()->parent()))->
        label(buf);
      o->hide();
    } else {
      o->static_value(current_widget->name());
      o->show();
      (reinterpret_cast<Fl_Window*>(o->parent()->parent()->parent()))->
        label(current_widget->title());
    }
  } else {
    if(numselected == 1) {
      current_widget->name(o->value());
      // I don't update window title, as it probably is being closed
      // and wm2 (a window manager) barfs if you retitle and then
      // hide a window:
      // ((Fl_Window*)(o->parent()->parent()->parent()))->
      //   label(current_widget->title());
    }
  }
}

void
name_public_cb(Fl_Light_Button* i, void* v)
{
  if(v == LOAD) {
    i->value(current_widget->public_);
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget())
	((svWidgetType*)o)->public_ = i->value();
  }
}    

static char* oldlabel;
static unsigned oldlabellen;
static Fl_Input* label_input;

void
label_cb(Fl_Input* i, void* v)
{
  if(v == LOAD) {
    label_input = i;
    i->static_value(current_widget->label());
    if(strlen(i->value()) >= oldlabellen) {
      oldlabellen = strlen(i->value())+128;
      oldlabel = (char*)realloc(oldlabel,oldlabellen);
    }
    strcpy(oldlabel,i->value());
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) o->label(i->value());
  }
}

static Fl_Input* image_input;

void
image_cb(Fl_Input* i, void* v)
{
  if(v == LOAD) {
    image_input = i;
    if(current_widget->is_widget()) {
      i->activate();
      i->static_value(((svWidgetType*)current_widget)->image_name());
    } else i->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) ((svWidgetType*)o)->image_name(i->value());
  }
}

void
image_browse_cb(Fl_Button* b, void* v)
{
  if(v == LOAD) {
    if(current_widget->is_widget()) b->activate();
    else b->deactivate();
  } else {
    if(ui_find_image(image_input->value())) {
      image_input->value(ui_find_image_name);
      for(svType* o = svType::first; o; o = o->next)
	if(o->selected && o->is_widget()) ((svWidgetType*)o)->image_name(ui_find_image_name);
    }
  }
}

static Fl_Input* inactive_input;

void
inactive_cb(Fl_Input* i, void* v)
{
  if(v == LOAD) {
    inactive_input = i;
    if(current_widget->is_widget()) {
      i->activate();
      i->static_value(((svWidgetType*)current_widget)->inactive_name());
    } else i->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) ((svWidgetType*)o)->inactive_name(i->value());
  }
}

void
inactive_browse_cb(Fl_Button* b, void* v)
{
  if(v == LOAD) {
    if(current_widget->is_widget()) b->activate();
    else b->deactivate();
  } else {
    if(ui_find_image(inactive_input->value())) {
      inactive_input->value(ui_find_image_name);
      for(svType* o = svType::first; o; o = o->next)
	if(o->selected && o->is_widget()) ((svWidgetType*)o)->inactive_name(ui_find_image_name);
    }
  }
}

static Fl_Input* tooltip_input;

void
tooltip_cb(Fl_Input* i, void* v)
{
  if(v == LOAD) {
    tooltip_input = i;
    if(current_widget->is_widget()) {
      i->activate();
      i->static_value(((svWidgetType*)current_widget)->tooltip());
    } else i->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) ((svWidgetType*)o)->tooltip(i->value());
  }
}

Fl_Value_Input* x_input;
Fl_Value_Input* y_input;
Fl_Value_Input* w_input;
Fl_Value_Input* h_input;

void
x_cb(Fl_Value_Input* i, void* v)
{
  if(v == LOAD) {
    x_input = i;
    if(current_widget->is_widget()) {
      i->value(((svWidgetType *)current_widget)->o->x());
      x_input->activate();
    } else x_input->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) {
        Fl_Widget* w = ((svWidgetType *)o)->o;
	w->resize((int)i->value(), w->y(), w->w(), w->h());
      }
  }
}

void
y_cb(Fl_Value_Input* i, void* v)
{
  if(v == LOAD) {
    y_input = i;
    if(current_widget->is_widget()) {
      i->value(((svWidgetType *)current_widget)->o->y());
      y_input->activate();
    } else y_input->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) {
        Fl_Widget* w = ((svWidgetType *)o)->o;
	w->resize(w->x(), (int)i->value(), w->w(), w->h());
      }
  }
}

void
w_cb(Fl_Value_Input* i, void* v)
{
  if(v == LOAD) {
    w_input = i;
    if(current_widget->is_widget()) {
      i->value(((svWidgetType *)current_widget)->o->w());
      w_input->activate();
    } else w_input->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) {
        Fl_Widget* w = ((svWidgetType *)o)->o;
	w->resize(w->x(), w->y(), (int)i->value(), w->h());
      }
  }
}

void
h_cb(Fl_Value_Input* i, void* v)
{
  if(v == LOAD) {
    h_input = i;
    if(current_widget->is_widget()) {
      i->value(((svWidgetType *)current_widget)->o->h());
      h_input->activate();
    } else h_input->deactivate();
  } else {
    for(svType* o = svType::first; o; o = o->next)
      if(o->selected && o->is_widget()) {
        Fl_Widget* w = ((svWidgetType *)o)->o;
	w->resize(w->x(), w->y(), w->w(), (int)i->value());
      }
  }
}
