/* 
 * $Id: SurfaceGlommer0.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $
 * 
 */
#include "vtkProperty.h"
#include "vtkActorCollection.h"
#include "vtkAssembly.h"
#include "vtkAxes.h"
#include "vtkOutlineCornerSource.h"
#include "vtkCubeAxesActor2D.h"

#include "SurfaceGlomParallel.H"

#include "vtkInputPort.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkPolyDataMapper.h"
#include "vtkPolyDataWriter.h"

#include "svController.H"


static vtkAssembly*            gpBoundingAssembly = 0;
static vtkActor*               gpAxesActor        = 0;
static vtkAxes*                gpAxes             = 0;
static vtkOutlineCornerSource* gpOutline          = 0;
static vtkCubeAxesActor2D*     gpCubeAxesActor2D  = 0;

static void UpdateAxes(vtkRenderer*);

// SurfaceGlommer 0 for SurfaceGlomParallel.
// See SurfaceGlomParallel.cxx for more information.
void
SurfaceGlommer0(StringListRef inputArgs)
{
  StringListConstIter s;
  const char* outputFileName = NULL;
  bool interactiveFlag = true;

  for(s=inputArgs.begin(); s!=inputArgs.end(); s++)
    {
    if((*s) == "-o")
      {
      outputFileName = (*(++s)).c_str();
      }
    else if((*s) == "-nw")
      {
      interactiveFlag = false;
      }
  }

  // 
  // Create the RenderWindow, Renderer and both Actors
  // 
  vtkRenderer*               pRenderer     = vtkRenderer::New();
  vtkRenderWindow*           pRenderWindow = vtkRenderWindow::New();
  pRenderWindow->AddRenderer(pRenderer);
  vtkRenderWindowInteractor* pInteractor   = vtkRenderWindowInteractor::New();
  pInteractor->SetRenderWindow(pRenderWindow);

  sv.SetInteractor(pInteractor);

  pRenderWindow->SetWindowName("SurfaceGlomParallel");
  pRenderWindow->SetSize(WINDOW_WIDTH, WINDOW_HEIGHT);
  pRenderer->SetBackground(0.01, 0.02, 0.03);

  // Input ports
  vtkInputPort* pInputPort1 = vtkInputPort::New();
  {
    pInputPort1->SetRemoteProcessId(originalPortId);
    pInputPort1->SetTag(originalPortTag);
  }
  vtkInputPort* pInputPort2 = vtkInputPort::New();
  {
    pInputPort2->SetRemoteProcessId(glommedPortId);
    pInputPort2->SetTag(glommedPortTag);
  }

  // 
  // The original data is behind door number 1 ...
  // 
  vtkActor* pOriginalActor = vtkActor::New();
  {
    vtkPolyDataMapper* pPolyDataMapper = vtkPolyDataMapper::New();
    {
      pPolyDataMapper->SetInput(pInputPort1->GetPolyDataOutput());
      pPolyDataMapper->ScalarVisibilityOff();
      pPolyDataMapper->ImmediateModeRenderingOn();
    }
    vtkProperty* pProperty = sv.MakeProperty("gloss light green");
    pOriginalActor->SetProperty(pProperty);
    pOriginalActor->SetMapper(pPolyDataMapper);
    // Clean up.
    pProperty->Delete();
    pPolyDataMapper->Delete();
  }

  pRenderer->AddActor(pOriginalActor);

  float bounds[6];

  pOriginalActor->GetBounds(bounds);
  pOriginalActor->AddPosition(-(bounds[1]-bounds[0])/2.f, 0.f, 0.f);
  pRenderer->ResetCamera();
  pRenderWindow->Render();

  // Clean up.
  pOriginalActor->Delete();

  // 
  // Now lets deal with door number 2 ...
  // 
  vtkActor* pGlommedActor = vtkActor::New();
  {
    vtkPolyDataMapper* pGlommedMapper = vtkPolyDataMapper::New();
    {
      pGlommedMapper->SetInput(pInputPort2->GetPolyDataOutput());
      pGlommedMapper->ScalarVisibilityOff();
      pGlommedMapper->ImmediateModeRenderingOn();
    }
    vtkProperty* pProperty = sv.MakeProperty("gloss red");
    pGlommedActor->SetProperty(pProperty);
    pGlommedActor->SetMapper(pGlommedMapper);
    // Clean up.
    pProperty->Delete();
    pGlommedMapper->Delete();
  }

  pRenderer->AddActor(pGlommedActor);
  pGlommedActor->AddPosition(+(bounds[1]-bounds[0])/2.f, 0.f, 0.f);
  pRenderer->ResetCamera();
  pRenderWindow->Render();

  // Clean up.
  pGlommedActor->Delete();

  // Now update the Axes ...
  UpdateAxes(pRenderer);

  // Let's go
  pInteractor->Initialize();
  pInteractor->Start();

  // Maybe write out the glommed data.
  StringListConstIter s;
  for(s=inputArgs.begin(); s!=inputArgs.end(); s++) {
    if((*s) == "-o") {
      s++;

      vtkPolyDataWriter* pWriter = vtkPolyDataWriter::New();
      {
	pWriter->SetFileName((*(s)).c_str());
	//pWriter->SetFileTypeToASCII();
	pWriter->SetFileTypeToBinary();
	pWriter->SetInput(pInputPort2->GetPolyDataOutput());
	pWriter->Write();
      }
      pWriter->Delete();
    }
  }

  // Tell the other process we are done
  pInputPort1->GetController()->
    TriggerRMI(originalPortId, vtkMultiProcessController::BREAK_RMI_TAG); 
  pInputPort2->GetController()->
    TriggerRMI(glommedPortId, vtkMultiProcessController::BREAK_RMI_TAG); 

  // Cleanup
  pInputPort1->Delete();
  pInputPort2->Delete();
  pInteractor->Delete();
  pRenderWindow->Delete();
  pRenderer->Delete();
}

// ----------------------------------------------------------------------------
static void
UpdateAxes(vtkRenderer* pRenderer)
{
  if(!pRenderer) return;

  vtkActor* pActor;
  vtkActorCollection* pActorCollection = pRenderer->GetActors();

  float tmp[6], bounds[6] = { VTK_LARGE_FLOAT, -VTK_LARGE_FLOAT,
                              VTK_LARGE_FLOAT, -VTK_LARGE_FLOAT,
                              VTK_LARGE_FLOAT, -VTK_LARGE_FLOAT };

  pActorCollection->InitTraversal();
  while(pActor = pActorCollection->GetNextActor()) {
    pActor->GetBounds(tmp);
    if(tmp[0] < bounds[0]) bounds[0] = tmp[0];
    if(tmp[1] > bounds[1]) bounds[1] = tmp[1];
    if(tmp[2] < bounds[2]) bounds[2] = tmp[2];
    if(tmp[3] > bounds[3]) bounds[3] = tmp[3];
    if(tmp[4] < bounds[4]) bounds[4] = tmp[4];
    if(tmp[5] > bounds[5]) bounds[5] = tmp[5];
  }

  float center[3], range[3], length;

  center[0] = (bounds[0]+bounds[1])/2.f;
  center[1] = (bounds[2]+bounds[3])/2.f;
  center[2] = (bounds[4]+bounds[5])/2.f;
  range[0]  = bounds[1] - bounds[0];
  range[1]  = bounds[3] - bounds[2];
  range[2]  = bounds[5] - bounds[4];
  length    = float(sqrt( range[0]*range[0] +
                          range[1]*range[1] +
                          range[2]*range[2] ));

  if(!gpBoundingAssembly) {
    gpBoundingAssembly = vtkAssembly::New();
    {
      // axes part
      gpAxesActor = vtkActor::New();
      {
        vtkPolyDataMapper* pAxesMapper = vtkPolyDataMapper::New();
        {
          gpAxes = vtkAxes::New();
          {
            gpAxes->SymmetricOn();
            gpAxes->SetOrigin(center);
            gpAxes->SetScaleFactor(length/2.f);
            gpAxes->ComputeNormalsOn();
          }
          pAxesMapper->SetInput(gpAxes->GetOutput());
          gpAxes->Delete();
        }
        gpAxesActor->SetMapper(pAxesMapper);
        gpAxesActor->SetScale(range[0]/length,range[1]/length,range[2]/length);
        pAxesMapper->Delete();
      }
      gpBoundingAssembly->AddPart(gpAxesActor);
      gpAxesActor->Delete();
      // outline part
      vtkActor* pOutlineActor = vtkActor::New();
      {
        vtkPolyDataMapper* pOutlineMapper = vtkPolyDataMapper::New();
        {
          gpOutline = vtkOutlineCornerSource::New();
          {
            gpOutline->SetBounds(bounds);
            //gpOutline->SetCornerFactor(float);
          }
          pOutlineMapper->SetInput(gpOutline->GetOutput());
          gpOutline->Delete();
        }
        pOutlineActor->SetMapper(pOutlineMapper);
        pOutlineMapper->Delete();
      }
      gpBoundingAssembly->AddPart(pOutlineActor);
      pOutlineActor->Delete();
    }
    pRenderer->AddProp(gpBoundingAssembly);
    gpBoundingAssembly->Delete();
  }
  else {
    gpAxes->SetOrigin(center);
    gpAxes->SetScaleFactor(length/2.f);
    gpAxesActor->SetScale(range[0]/length,range[1]/length,range[2]/length);
    gpOutline->SetBounds(bounds);
  }

  if(!gpCubeAxesActor2D) {
    gpCubeAxesActor2D = vtkCubeAxesActor2D::New();
    {
      gpCubeAxesActor2D->SetBounds(bounds);
      gpCubeAxesActor2D->SetCamera(pRenderer->GetActiveCamera());
      gpCubeAxesActor2D->SetFlyModeToOuterEdges();
      gpCubeAxesActor2D->SetScaling(0/*Off*/);
      gpCubeAxesActor2D->SetShadow(1/*On*/);
      //gpCubeAxesActor2D->SetInertia(int);
    }
    pRenderer->AddProp(gpCubeAxesActor2D);
    gpCubeAxesActor2D->Delete();
  }
  else {
    gpCubeAxesActor2D->SetBounds(bounds);
  }

  pRenderer->GetRenderWindow()->Render();
}

/* 
 * End of: $Id: SurfaceGlommer0.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $.
 * 
 */
