/* 
 * $Id: SurfaceGlommer2.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $
 * 
 */
#include <cstdlib>
// VTK Common
#include "vtkPolyData.h"
// VTK Filtering
#include "vtkPolyDataSource.h"
// SurfaceGlomParallel
#include "SurfaceGlomParallel.H"
// Parallel
#include "vtkInputPort.h"
#include "vtkOutputPort.h"


extern vtkPolyDataSource*
CreateGlomContour(vtkPolyData*, float = 0.0625,float = 0.125,float = 1.0);


// SurfaceGlommer 2 for SurfaceGlomParallel.
// See SurfaceGlomParallel.cxx for more information.
void
SurfaceGlommer2(StringListRef inputArgs)
{
  float D     = 0.0625;
  float pad   = 0.125;
  float scale = 1.0;

  StringListConstIter s;

  for(s=inputArgs.begin(); s!=inputArgs.end(); s++) {
    if((*s) == "-D") {
      s++; D     = float(atof((*s).c_str()));
    }
    else if((*s) == "-P") {
      s++; pad   = float(atof((*s).c_str()));
    }
    else if((*s) == "-S") {
      s++; scale = float(atof((*s).c_str()));
    }
  }

  // Output port
  vtkOutputPort* pOutputPort = vtkOutputPort::New();
  {
    // Input port
    vtkInputPort* pInputPort1 = vtkInputPort::New();
    {
      pInputPort1->SetRemoteProcessId(originalPortId);
      pInputPort1->SetTag(originalPortTag);
    }
    // Glom the input data.
    vtkPolyDataSource* pGlomSource =
      CreateGlomContour(pInputPort1->GetPolyDataOutput(), D, pad, scale);
    // Clean up.
    pInputPort1->Delete();
    // Output port
    pOutputPort->SetInput(pGlomSource->GetOutput());
    pOutputPort->SetTag(glommedPortTag);
    // Process requests
    pOutputPort->WaitForUpdate();
  }

  // Clean up.
  pOutputPort->Delete();
}


/* 
 * End of: $Id: SurfaceGlommer2.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $.
 * 
 */
