/* 
 * $Id: Task2.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $
 * 
 */
#include "TestParallel.H"
#include "vtkImageData.h"
#include "vtkPolyData.h"
#include "vtkOutputPort.h"

// Task 2 for TestParallel.
// See TestParallel.cxx for more information.
void
Task2(double data)
{  
  double extent = data;
  int iextent = static_cast<int>(data);    

  // Glyph the gradient vector (with arrows)
  vtkGlyph3D* pArrows3D = vtkGlyph3D::New();
  {
    // Label the scalar field as the active vectors.
    vtkAssignAttribute* pAssignAttribute = vtkAssignAttribute::New();
    {
      vtkImageShrink3D* pMask = vtkImageShrink3D::New();
      {
        // Gradient vector.
        vtkImageGradient* pGradient = vtkImageGradient::New();
        {
          // Synthetic image source.
          vtkRTAnalyticSource* pRTAnalyticSource = vtkRTAnalyticSource::New();
          {
            pRTAnalyticSource->SetWholeExtent( -1*iextent, iextent,
                                               -1*iextent, iextent, 
                                               -1*iextent, iextent );
            pRTAnalyticSource->SetCenter(0, 0, 0);
            pRTAnalyticSource->SetStandardDeviation( 0.5 );
            pRTAnalyticSource->SetMaximum( 255.0 );
            pRTAnalyticSource->SetXFreq( 60 );
            pRTAnalyticSource->SetXMag( 10 );
            pRTAnalyticSource->SetYFreq( 30 );
            pRTAnalyticSource->SetYMag( 18 );
            pRTAnalyticSource->SetZFreq( 40 );
            pRTAnalyticSource->SetZMag( 5 );
            pRTAnalyticSource->GetOutput()->
              SetSpacing(2.0/extent, 2.0/extent, 2.0/extent);
          }
          pGradient->SetInput(pRTAnalyticSource->GetOutput());
          pGradient->SetDimensionality( 3 );
          // Clean up.
          pRTAnalyticSource->Delete();
        }
        pMask->SetInput(pGradient->GetOutput());
        pMask->SetShrinkFactors(5, 5, 5);
        // Clean up.
        pGradient->Delete();
      }
      pAssignAttribute->SetInput(pMask->GetOutput());
      pAssignAttribute->Assign( vtkDataSetAttributes::SCALARS,
                                vtkDataSetAttributes::VECTORS,
                                vtkAssignAttribute::POINT_DATA );
      // Clean up.
      pMask->Delete();
    }
    // 2D arrow glyph.
    vtkGlyphSource2D* pArrow2D = vtkGlyphSource2D::New();
    {
      pArrow2D->SetGlyphTypeToArrow();
      pArrow2D->SetScale(0.2);
      pArrow2D->FilledOff();
    }
    pArrows3D->SetInput(pAssignAttribute->GetOutput());
    pArrows3D->SetSource(pArrow2D->GetOutput());
    pArrows3D->ScalingOff();
    pArrows3D->OrientOn();
    pArrows3D->SetVectorModeToUseVector();
    pArrows3D->SetColorModeToColorByVector();
    // Clean up.
    pAssignAttribute->Delete();
    pArrow2D->Delete();
  }

  // Output port
  vtkOutputPort* pOutputPort = vtkOutputPort::New();
  {
    pOutputPort->SetInput(pArrows3D->GetOutput());
    pOutputPort->SetTag(11);
    // Process requests
    pOutputPort->WaitForUpdate();
  }

  // Clean up.
  pOutputPort->Delete();
}

/* 
 * End of: $Id: Task2.cxx,v 1.1.1.1 2006/12/19 22:59:39 christianh Exp $.
 * 
 */
