/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: Fl_Toggle_Node_Base.H,v 1.1.1.1 2006/12/19 22:59:53 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Originally from Flek (The Fast Light Environment Kit).
 * 
 */
#ifndef FL_TOGGLE_NODE_BASE_H_
#  define FL_TOGGLE_NODE_BASE_H_

/** \class   Fl_Toggle_Node_Base
 *  \brief   Data storage and management base class for Fl_Toggle_Tree.
 * 
 * \author  Sean McInerney (orig: James Dean Palmer, Flek library maintainer)
 * \version $Revision: 1.1.1.1 $
 * \date    $Date: 2006/12/19 22:59:53 $
 * 
 * \sa
 * Fl_Toggle_Node Fl_Toggle_Tree_Base Fl_Toggle_Tree
 */
class Fl_Toggle_Node_Base
{
  friend class Fl_Toggle_Tree_Base;

public:
  /** Constructor. */
  Fl_Toggle_Node_Base (bool aOpened = false)
    : parent_node_(0),
      previous_sibling_(0),
      next_sibling_(0),
      first_child_(0),
      visible_child_(0),
      opened_(aOpened) {}

  /** Get the parent of this element. */
  inline Fl_Toggle_Node_Base*   parent_node (void) const
    { return this->parent_node_; }

  /** Get the previous sibling node on the branch. */
  inline Fl_Toggle_Node_Base*   previous_sibling (void) const
    { return this->previous_sibling_; }

  /** Get the next sibling node on the branch. */
  inline Fl_Toggle_Node_Base*   next_sibling (void) const
    { return this->next_sibling_; }

  /** Get the first subnode (child) pointer. */
  inline Fl_Toggle_Node_Base*   first_child (void) const
    { return this->first_child_; }

  /** Return the first visible subnode (child) pointer. */
  inline Fl_Toggle_Node_Base*   visible_child (void) const
    { return this->visible_child_; }

  /** Return \c true if node is open, otherwise returns \c false. */
  inline bool                   opened (void) const
    { return this->opened_; }

protected:
  Fl_Toggle_Node_Base*  parent_node_;
  Fl_Toggle_Node_Base*  previous_sibling_;
  Fl_Toggle_Node_Base*  next_sibling_;
  Fl_Toggle_Node_Base*  first_child_;
  Fl_Toggle_Node_Base*  visible_child_;

  bool                  opened_;
};

#endif /* FL_TOGGLE_NODE_BASE_H_ */
/* 
 * End of: $Id: Fl_Toggle_Node_Base.H,v 1.1.1.1 2006/12/19 22:59:53 christianh Exp $.
 * 
 */
