/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: SvvCallbacks.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_CALLBACKS_H_
#  define SVV_CALLBACKS_H_
// FLTK
#  include <FL/Fl_Widget.H>
#  include <FL/Fl_Menu_.H>

/** Write the render window contents to a 2D image file. */
void    SvvSurfaceAddCb (Fl_Widget* widget, void* ptr);
void    SvvSurfaceSaveCb (Fl_Widget* widget, void* ptr);
void    SvvVolumeAddCb (Fl_Widget* widget, void* ptr);
void    SvvVolumeSaveCb (Fl_Widget* widget, void* ptr);
void    SvvSceneImportCb (Fl_Widget* widget, void* ptr);
void    SvvSceneExportCb (Fl_Widget* widget, void* ptr);
void    SvvSessionRestoreCb (Fl_Widget* widget, void* ptr);
void    SvvSessionRecordCb (Fl_Widget* widget, void* ptr);
void    SvvExitCb (Fl_Widget* widget, void* ptr);

void    SvvPaletteCb (Fl_Widget* widget, void* ptr);

void    SvvCreateViewCb (Fl_Widget* widget, void* ptr);
void    SvvInertiaCb (Fl_Widget* widget, void* ptr);
void    SvvRotateCb (Fl_Widget* widget, void* ptr);
void    SvvTranslateCb (Fl_Widget* widget, void* ptr);
void    SvvScaleCb (Fl_Widget* widget, void* ptr);
void    SvvCubeAxesCb (Fl_Widget* widget, void* ptr);
void    SvvBoundingBoxCb (Fl_Widget* widget, void* ptr);
void    SvvDepthSortCb (Fl_Widget* widget, void* ptr);

void    SvvMessagesCb (Fl_Widget* widget, void* ptr);
void    SvvUserHelpCb (Fl_Widget* widget, void* ptr);
void    SvvDeveloperHelpCb (Fl_Widget* widget, void* ptr);
void    SvvAboutCb (Fl_Widget* widget, void* ptr);

#endif /* SVV_CALLBACKS_H_ */
/* 
 * End of: $Id: SvvCallbacks.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
