/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svvMessagesRedirection.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef SVV_MESSAGES_REDIRECTION_H_
#  define SVV_MESSAGES_REDIRECTION_H_
#  include "svvConfiguration.h"
// VTK Common
#  include "vtkOutputWindow.h"

namespace vtkstd
{
class svvMessagesOutputStream;
}

/** \class   svvMessagesRedirection
 *  \brief   Redirects VTK messages and IOStreams to \c svvMessagesUI.
 * 
 * svvMessagesRedirection is derived derived from \c vtkOutputWindow and,
 * thereby, handles redirection of VTK messages. svvMessagesRedirection
 * additionally has facillities to redirect the standard IOStreams to
 * \c svvMessagesUI.
 * 
 * \author  Sean McInerney
 * \version $Revision: 1.1.1.1 $
 * \date    $Date: 2006/12/19 22:59:44 $
 * 
 * \sa vtkOutputWindow svvMessagesUI
 */
class SVV_EXPORT svvMessagesRedirection : public vtkOutputWindow
{
public:
  vtkTypeRevisionMacro(svvMessagesRedirection, vtkOutputWindow);

  /*@{*/
  /** Display the text.
   * The four specialized methods allow redirection or reformatting
   * of the messages according to their severity.
   */
  virtual void  DisplayText (const char*);
  virtual void  DisplayErrorText (const char*);
  virtual void  DisplayWarningText (const char*);
  virtual void  DisplayGenericWarningText (const char*);
  virtual void  DisplayDebugText (const char*);
  /*@}*/

  /** Redirect VTK messages to the SVV-specific output window. */
  static void   RedirectVtkStreams (void);

  /** Restore VTK messages to their default outputs. */
  static void   RestoreVtkStreams (void);

  /** Redirect \c cout to the SVV-specific output window. */
  static void   RedirectOutStream (void);

  /** Restore \c cout to its default output. */
  static void   RestoreOutStream (void);

  /** Redirect \c cerr to the SVV-specific output window. */
  static void   RedirectErrStream (void);

  /** Restore \c cerr to its default output. */
  static void   RestoreErrStream (void);

  /** Redirect \c clog to the SVV-specific output window. */
  static void   RedirectLogStream (void);

  /** Restore \c clog to its default output. */
  static void   RestoreLogStream (void);

protected:
  svvMessagesRedirection (void);
  virtual ~svvMessagesRedirection() {}

  static void   ClassInitialize (void);
  static void   ClassFinalize (void);

  static vtkOutputWindow*                       Default;

  static vtkstd::streambuf*                     OutBuffer;
  static vtkstd::streambuf*                     ErrBuffer;
  static vtkstd::streambuf*                     LogBuffer;

  static vtkstd::svvMessagesOutputStream*       OutStream;
  static vtkstd::svvMessagesOutputStream*       ErrStream;
  static vtkstd::svvMessagesOutputStream*       LogStream;

public:
  /** \internal Nested initializer class. */
  class Init
  {
  public:
    Init (void);
    ~Init();
  private:
    static long TranslationUnits;
    friend class svvMessagesRedirection;
  };

  friend class Init;

private:
  svvMessagesRedirection (const svvMessagesRedirection&);  // Not implemented.
  void operator= (const svvMessagesRedirection&);  // Not implemented.
};

#  ifndef SVV_MESSAGES_REDIRECTION_INITIALIZED_
#    define SVV_MESSAGES_REDIRECTION_INITIALIZED_
/** \internal Global initializer; ensure construction of static objects. */
static svvMessagesRedirection::Init svvMessagesRedirectionInitInstance;
#  endif /* SVV_MESSAGES_REDIRECTION_INITIALIZED_ */

#endif /* SVV_MESSAGES_REDIRECTION_H_ */
/*
 * End of: $Id: svvMessagesRedirection.h,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 *
 */
