/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: svv_file_chooser.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "svv_file_chooser.h"
// C++ forwarding ANSI C
#include <cstring>
// FLTK
#include <FL/filename.H>
#include <FL/Fl_File_Chooser.H>

static Fl_File_Chooser* fc = (Fl_File_Chooser *) 0;
static void		(*current_callback)(const char*) = 0;

static void
callback (Fl_File_Chooser*, void*)
{
  if (current_callback != NULL && fc->value() != NULL)
    (*current_callback)(fc->value());
}

void
svv_file_chooser_callback (void (*cb)(const char*))
{
  current_callback = cb;
}

int
svv_file_chooser (const char* aMessage,
                  const char* aPattern,
                  int         aType)
{
  if (aType & Fl_File_Chooser::DIRECTORY) aPattern = "*";

  if (fc == NULL)
    {
    fc = new Fl_File_Chooser(".", aPattern, aType, aMessage);
    fc->callback(callback, 0);
    }
  else
    {
    fc->label(aMessage);
    fc->filter(aPattern);
    fc->type(aType);
    }

  fc->show();

  while (fc->shown())
    Fl::wait();

  return (fc->value() != NULL ? fc->count() : 0);
}

int
svv_file_chooser_count (void)
{
  return (fc != NULL ? fc->count() : 0);
}

char*
svv_file_chooser_value (int aIndex, int aRelative)
{
  static char result[1024];

  if (fc != NULL && aIndex < svv_file_chooser_count())
    {
    if (aRelative != 0)
      {
      fl_filename_relative(result, sizeof(result), fc->value(aIndex+1));
      }
    else
      {
      strncpy(result, fc->value(aIndex+1), sizeof(result)-1);
      result[sizeof(result)-1] = '\0';
      }
    }
  else
    {
    result[0] = '\0';
    }

  return result;
}

char*
svv_dir_chooser (const char* aMessage,
                 int         aRelative)
{
  if (svv_file_chooser(aMessage,"*",Fl_File_Chooser::DIRECTORY) <= 0)
    return NULL;

  return svv_file_chooser_value(0,aRelative);
}

char*
svv_singlefile_chooser (const char* aMessage,
                        const char* aPattern,
                        int         aRelative)
{
  if (svv_file_chooser(aMessage, aPattern, Fl_File_Chooser::SINGLE) <= 0)
    return NULL;

  return svv_file_chooser_value(0,aRelative);
}

int
svv_multifile_chooser (const char* aMessage,
                       const char* aPattern)
{
  return svv_file_chooser(aMessage, aPattern, Fl_File_Chooser::MULTI);
}

char*
svv_newdir_chooser (const char* aMessage,
                    int         aRelative)
{
  if ( svv_file_chooser( aMessage, "*",
                         Fl_File_Chooser::DIRECTORY|Fl_File_Chooser::CREATE )
       <= 0 )
    return NULL;

  return svv_file_chooser_value(0,aRelative);
}

char*
svv_newfile_chooser (const char* aMessage,
                     const char* aPattern,
                     int         aRelative)
{
  if ( svv_file_chooser( aMessage, aPattern,
                         Fl_File_Chooser::SINGLE|Fl_File_Chooser::CREATE )
       <= 0 )
    return NULL;

  return svv_file_chooser_value(0,aRelative);
}

/* 
 * End of: $Id: svv_file_chooser.cxx,v 1.1.1.1 2006/12/19 22:59:44 christianh Exp $.
 * 
 */
