/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractMatrix4x4UI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkMatrix4x4UI.h"
// VTK Common
#include "vtkMatrix4x4.h"
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

// ----------------------------------------------------------------------------
//      v t k A b s t r a c t M a t r i x 4 x 4 U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractMatrix4x4UI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractMatrix4x4UI);

// ----------------------------------------------------------------------------
vtkAbstractMatrix4x4UI*
vtkAbstractMatrix4x4UI::New (void)
{
  vtkObject* result =
    vtkObjectFactory::CreateInstance("vtkAbstractMatrix4x4UI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractMatrix4x4UI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractMatrix4x4UI");

  return vtkMatrix4x4UI::New();
}


// ----------------------------------------------------------------------------
vtkAbstractMatrix4x4UI::vtkAbstractMatrix4x4UI (void)
  : Matrix(vtkMatrix4x4::New()),
    ClientMatrix(NULL)
{
  this->Matrix->Identity();
}

vtkAbstractMatrix4x4UI::~vtkAbstractMatrix4x4UI()
{
  if (this->ClientMatrix != NULL)
    {
    this->ClientMatrix->UnRegister(this);
    this->ClientMatrix = NULL;
    }
  if (this->Matrix != NULL)
    {
    this->Matrix->UnRegister(this);
    this->Matrix = NULL;
    }
}

// ----------------------------------------------------------------------------
void
vtkAbstractMatrix4x4UI::Receive (vtkObject* aObject)
{
  this->Check();

  if (this->ClientMatrix == NULL)
    {
    this->Deactivate();
    this->DefaultInternal(aObject);
    }
  else
    {
    this->Activate();
    this->Matrix->DeepCopy(this->ClientMatrix);
    this->ReceiveInternal(aObject);
    }
}

void
vtkAbstractMatrix4x4UI::Send (vtkObject* aObject)
{
  this->Check();

  if (this->ClientMatrix == NULL)
    {
    this->Deactivate();
    this->DefaultInternal(aObject);
    }
  else
    {
    this->Activate();
    this->SendInternal(aObject);
    this->ClientMatrix->DeepCopy(this->Matrix);
    }
}

void
vtkAbstractMatrix4x4UI::Default (vtkObject* aObject)
{
  this->Check();

  if (this->ClientMatrix == NULL)
    {
    this->Deactivate();
    this->DefaultInternal(aObject);
    }
  else
    {
    this->Activate();
    this->DefaultInternal(aObject);
    this->ClientMatrix->DeepCopy(this->Matrix);
    }
}

// ----------------------------------------------------------------------------
void
vtkAbstractMatrix4x4UI::SetClientMatrix(vtkMatrix4x4* aMatrix)
{
  vtkSetObjectBodyMacro(ClientMatrix, vtkMatrix4x4, aMatrix);
  this->Receive();
}

// ----------------------------------------------------------------------------
void
vtkAbstractMatrix4x4UI::PrintSelf (ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget, aIndent);

  aTarget << aIndent << "Matrix:       " << this->Matrix << endl;
  if (this->Matrix != NULL)
    this->Matrix->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "ClientMatrix: " << this->ClientMatrix << endl;
  if (this->ClientMatrix != NULL)
    this->ClientMatrix->PrintSelf(aTarget, aIndent.GetNextIndent());
}

/*
 * End of: $Id: vtkAbstractMatrix4x4UI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
