/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractNodeBrowserUI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkNodeBrowserUI.h"
// VTK Common
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

// ----------------------------------------------------------------------------
//      v t k A b s t r a c t N o d e B r o w s e r U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractNodeBrowserUI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractNodeBrowserUI);

// ----------------------------------------------------------------------------
vtkAbstractNodeBrowserUI*
vtkAbstractNodeBrowserUI::New (void)
{
  vtkObject* result =
    vtkObjectFactory::CreateInstance("vtkAbstractNodeBrowserUI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractNodeBrowserUI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractNodeBrowserUI");

  return vtkNodeBrowserUI::New();
}

// ----------------------------------------------------------------------------
void
vtkAbstractNodeBrowserUI::Default(vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

void
vtkAbstractNodeBrowserUI::Receive(vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

void
vtkAbstractNodeBrowserUI::Send(vtkObject* vtkNotUsed(a))
{
  //this->Check();
}

/*
 * End of: $Id: vtkAbstractNodeBrowserUI.cxx,v 1.1.1.1 2006/12/19 22:59:45 christianh Exp $.
 *
 */
