/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractToolBarUI.cxx,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkToolBarUI.h"
// 
#include "vtkRenderingContext.h"
#include "Fl_VTK_View.H"
#include "Fl_Toggle_Tree.H"
#include <FL/Fl_Browser.H>
#include "vtkAbstractViewUI.h"
#include "vtkNodeBrowserUI.h"
#include "vtkSourceBrowserUI.h"
#include "vtkAbstractSurfacePropertiesUI.h"
#include "vtkLightingUI.h"
#include "vtkAbstractViewportUI.h"
#include "vtkAbstractCameraUI.h"
#include "vtkAbstractMatrix4x4UI.h"
// VTK Common
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);

// ----------------------------------------------------------------------------
//     v t k A b s t r a c t T o o l B a r U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractToolBarUI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractToolBarUI);

// ----------------------------------------------------------------------------
vtkAbstractToolBarUI*
vtkAbstractToolBarUI::New (void)
{
  vtkObject* result = vtkObjectFactory::CreateInstance("vtkAbstractToolBarUI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractToolBarUI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractToolBarUI");

  return vtkToolBarUI::New();
}

// ----------------------------------------------------------------------------
vtkAbstractToolBarUI::vtkAbstractToolBarUI (void)
  : ViewUI(NULL),
    NodeBrowserUI(NULL),
    SourceBrowserUI(NULL),
    SurfacePropertiesUI(NULL),
    LightingUI(NULL),
    ViewportUI(NULL),
    CameraUI(NULL),
    Matrix4x4UI(NULL)
{
}

vtkAbstractToolBarUI::~vtkAbstractToolBarUI()
{
  if (this->SurfacePropertiesUI != NULL)
    {
    this->SurfacePropertiesUI->UnRegister(this);
    this->SurfacePropertiesUI = NULL;
    }
  if (this->LightingUI != NULL)
    {
    this->LightingUI->UnRegister(this);
    this->LightingUI = NULL;
    }
  if (this->CameraUI != NULL)
    {
    this->CameraUI->UnRegister(this);
    this->CameraUI = NULL;
    }
  if (this->Matrix4x4UI != NULL)
    {
    this->Matrix4x4UI->UnRegister(this);
    this->Matrix4x4UI = NULL;
    }
  if (this->ViewportUI != NULL)
    {
    this->ViewportUI->UnRegister(this);
    this->ViewportUI = NULL;
    }
  if (this->NodeBrowserUI != NULL)
    {
    this->NodeBrowserUI->UnRegister(this);
    this->NodeBrowserUI = NULL;
    }
  if (this->SourceBrowserUI != NULL)
    {
    this->SourceBrowserUI->UnRegister(this);
    this->SourceBrowserUI = NULL;
    }
  if (this->ViewUI != NULL)
    {
    this->ViewUI->UnRegister(this);
    this->ViewUI = NULL;
    }
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::Default (vtkObject* vtkNotUsed(o))
{
  //this->Check();
}

void
vtkAbstractToolBarUI::Receive (vtkObject* vtkNotUsed(o))
{
  //this->Check();
}

void
vtkAbstractToolBarUI::Send (vtkObject* vtkNotUsed(o) )
{
  //this->Check();
}

// ----------------------------------------------------------------------------
vtkRenderingContext*
vtkAbstractToolBarUI::GetClientRenderingContext (void)
{
  if (this->ClientRenderingContext == NULL)
    if (this->ViewUI != NULL)
      this->
        SetClientRenderingContext(this->ViewUI->GetClientRenderingContext());

  vtkDebugMacro(<< "returning ClientRenderingContext: "
                << this->ClientRenderingContext);

  return this->ClientRenderingContext;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetViewUI (vtkAbstractUI* aViewUI)
{
  if ( (aViewUI != NULL) &&
       (aViewUI->IsA("vtkAbstractViewUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set ViewUI with a "
                  << aViewUI->GetClassName()
                  << " ... setting ViewUI to NULL.");
    aViewUI = NULL;
    }

  vtkSetObjectBodyMacro(ViewUI, vtkAbstractUI, aViewUI);

  vtkRenderingContext* renderingContext;

  if (this->ViewUI != NULL)
    {
    renderingContext = this->ViewUI->GetClientRenderingContext();
    }

  this->SetClientRenderingContext(renderingContext);

  if (this->NodeBrowserUI != NULL)
    {
    this->NodeBrowserUI->SetClientRenderingContext(renderingContext);
    }
  if (this->SourceBrowserUI != NULL)
    {
    this->SourceBrowserUI->SetClientRenderingContext(renderingContext);
    }
  if (this->SurfacePropertiesUI != NULL)
    {
    this->SurfacePropertiesUI->SetClientRenderingContext(renderingContext);
    }
  if (this->LightingUI != NULL)
    {
    this->LightingUI->SetClientRenderingContext(renderingContext);
    }
  if (this->ViewportUI != NULL)
    {
    this->ViewportUI->SetClientRenderingContext(renderingContext);
    }
  if (this->CameraUI != NULL)
    {
    this->CameraUI->SetClientRenderingContext(renderingContext);
    }
  if (this->Matrix4x4UI != NULL)
    {
    this->Matrix4x4UI->SetClientRenderingContext(renderingContext);
    }
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetNodeBrowserUI (vtkAbstractUI* aNodeBrowserUI)
{
  if ( (aNodeBrowserUI != NULL) &&
       (aNodeBrowserUI->IsA("vtkNodeBrowserUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set NodeBrowserUI with a "
                  << aNodeBrowserUI->GetClassName()
                  << " ... setting NodeBrowserUI to NULL.");
    aNodeBrowserUI = NULL;
    }

  vtkSetObjectBodyMacro(NodeBrowserUI,vtkAbstractUI,aNodeBrowserUI);

  if (this->NodeBrowserUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->NodeBrowserUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetNodeBrowserUI (void)
{
  if (this->NodeBrowserUI == NULL)
    {
    vtkNodeBrowserUI* tmp = vtkNodeBrowserUI::New();

    this->SetNodeBrowserUI(tmp);
    tmp->Delete();
    }

  return this->NodeBrowserUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetSourceBrowserUI (vtkAbstractUI* aSourceBrowserUI)
{
  if ( (aSourceBrowserUI != NULL) &&
       (aSourceBrowserUI->IsA("vtkAbstractSourceBrowserUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set SourceBrowserUI with a "
                  << aSourceBrowserUI->GetClassName()
                  << " ... setting SourceBrowserUI to NULL.");
    aSourceBrowserUI = NULL;
    }

  vtkSetObjectBodyMacro(SourceBrowserUI,vtkAbstractUI,aSourceBrowserUI);

  if (this->SourceBrowserUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->SourceBrowserUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetSourceBrowserUI (void)
{
  if (this->SourceBrowserUI == NULL)
    {
    vtkAbstractSourceBrowserUI* tmp = vtkAbstractSourceBrowserUI::New();

    this->SetSourceBrowserUI(tmp);
    tmp->Delete();
    }

  return this->SourceBrowserUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetSurfacePropertiesUI (vtkAbstractUI* aSurfacePropsUI)
{
  if ( (aSurfacePropsUI != NULL) &&
       (aSurfacePropsUI->IsA("vtkAbstractSurfacePropertiesUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set SurfacePropertiesUI with a "
                  << aSurfacePropsUI->GetClassName()
                  << " ... setting SurfacePropertiesUI to NULL.");
    aSurfacePropsUI = NULL;
    }

  vtkSetObjectBodyMacro(SurfacePropertiesUI,vtkAbstractUI,aSurfacePropsUI);

  if (this->SurfacePropertiesUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->SurfacePropertiesUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetSurfacePropertiesUI (void)
{
  if (this->SurfacePropertiesUI == NULL)
    {
    vtkAbstractSurfacePropertiesUI* tmp = vtkAbstractSurfacePropertiesUI::New();

    this->SetSurfacePropertiesUI(tmp);
    tmp->Delete();
    }

  return this->SurfacePropertiesUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetLightingUI (vtkAbstractUI* aLightingUI)
{
  if ( (aLightingUI != NULL) &&
       (aLightingUI->IsA("vtkLightingUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set LightingUI with a "
                  << aLightingUI->GetClassName()
                  << " ... setting LightingUI to NULL.");
    aLightingUI = NULL;
    }

  vtkSetObjectBodyMacro(LightingUI,vtkAbstractUI,aLightingUI);

  if (this->LightingUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->LightingUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetLightingUI (void)
{
  if (this->LightingUI == NULL)
    {
    vtkLightingUI* tmp = vtkLightingUI::New();

    this->SetLightingUI(tmp);
    tmp->Delete();
    }

  return this->LightingUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetViewportUI (vtkAbstractUI* aViewportUI)
{
  if ( (aViewportUI != NULL) &&
       (aViewportUI->IsA("vtkAbstractViewportUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set ViewportUI with a "
                  << aViewportUI->GetClassName()
                  << " ... setting ViewportUI to NULL.");
    aViewportUI = NULL;
    }

  vtkSetObjectBodyMacro(ViewportUI,vtkAbstractUI,aViewportUI);

  if (this->ViewportUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->ViewportUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetViewportUI (void)
{
  if (this->ViewportUI == NULL)
    {
    vtkAbstractViewportUI* tmp = vtkAbstractViewportUI::New();

    this->SetViewportUI(tmp);
    tmp->Delete();
    }

  return this->ViewportUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetCameraUI (vtkAbstractUI* aCameraUI)
{
  if ( (aCameraUI != NULL) &&
       (aCameraUI->IsA("vtkAbstractCameraUI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set CameraUI with a "
                  << aCameraUI->GetClassName()
                  << " ... setting CameraUI to NULL.");
    aCameraUI = NULL;
    }

  vtkSetObjectBodyMacro(CameraUI,vtkAbstractUI,aCameraUI);

  if (this->CameraUI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->CameraUI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetCameraUI (void)
{
  if (this->CameraUI == NULL)
    {
    vtkAbstractCameraUI* tmp = vtkAbstractCameraUI::New();

    this->SetCameraUI(tmp);
    tmp->Delete();
    }

  return this->CameraUI;
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::SetMatrix4x4UI (vtkAbstractUI* aMatrix4x4UI)
{
  if ( (aMatrix4x4UI != NULL) &&
       (aMatrix4x4UI->IsA("vtkAbstractMatrix4x4UI") == 0) )
    {
    vtkErrorMacro(<< "Cannot set Matrix4x4UI with a "
                  << aMatrix4x4UI->GetClassName()
                  << " ... setting Matrix4x4UI to NULL.");
    aMatrix4x4UI = NULL;
    }

  vtkSetObjectBodyMacro(Matrix4x4UI,vtkAbstractUI,aMatrix4x4UI);

  if (this->Matrix4x4UI != NULL)
    {
    vtkRenderingContext* renderingContext = NULL;

    if (this->ViewUI != NULL)
      {
      renderingContext = this->ViewUI->GetClientRenderingContext();
      }
    this->Matrix4x4UI->SetClientRenderingContext(renderingContext);
    }
}

vtkAbstractUI*
vtkAbstractToolBarUI::GetMatrix4x4UI (void)
{
  if (this->Matrix4x4UI == NULL)
    {
    vtkAbstractMatrix4x4UI* tmp = vtkAbstractMatrix4x4UI::New();

    this->SetMatrix4x4UI(tmp);
    tmp->Delete();
    }

  return this->Matrix4x4UI;
}

// ----------------------------------------------------------------------------
Fl_Window*
vtkAbstractToolBarUI::GetViewWindow (void)
{
  if (this->ViewUI != NULL)
    return this->ViewUI->GetFltkWindow();

  return NULL;
}

Fl_VTK_View*
vtkAbstractToolBarUI::GetView (void)
{
  vtkAbstractViewUI* viewUI;

  if ((viewUI = vtkAbstractViewUI::SafeDownCast(this->ViewUI)) != NULL)
    return viewUI->GetView();

  return NULL;
}

Fl_Toggle_Tree*
vtkAbstractToolBarUI::GetNodeBrowser (void)
{
  vtkAbstractUI* ptr;

  if ((ptr = this->GetNodeBrowserUI()) != NULL)
    return (static_cast<vtkNodeBrowserUI*>(ptr))->Browser;

  return NULL;
}

Fl_Browser*
vtkAbstractToolBarUI::GetSourceBrowser (void)
{
  vtkAbstractUI* ptr;

  if ((ptr = this->GetSourceBrowserUI()) != NULL)
    return (static_cast<vtkSourceBrowserUI*>(ptr))->Browser;

  return NULL;
}

Fl_Window*
vtkAbstractToolBarUI::GetTopWindow (void)
{
  Fl_Window* win = this->GetFltkWindow()->window();
  return (win != NULL ? win : this->GetFltkWindow());
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::ShowMainWindow (int c,char** v)
{
  this->GetFltkWindow()->show(c,v);
}

void
vtkAbstractToolBarUI::ShowViewWindow (int c, char** v, int flag)
{
  if (this->ViewUI != NULL) this->ViewUI->Show(c,v,flag);
}

void
vtkAbstractToolBarUI::ShowMainWindow (void)
{
  this->GetFltkWindow()->show();
}

void
vtkAbstractToolBarUI::ShowViewWindow (int flag)
{
  if (this->ViewUI != NULL) this->ViewUI->Show(flag);
}

void
vtkAbstractToolBarUI::HideMainWindow (void)
{
  this->GetFltkWindow()->hide();
}

void
vtkAbstractToolBarUI::HideViewWindow (int flag)
{
  if (this->ViewUI != NULL) this->ViewUI->Hide(flag);
}

void
vtkAbstractToolBarUI::Show (int c,char** v)
{
  if (this->ViewUI == NULL)
    {
    vtkAbstractViewUI* viewUI = vtkAbstractViewUI::New();

    this->SetViewUI(viewUI);
    viewUI->Delete();
    }
  this->ShowViewWindow(c,v);
  this->ShowMainWindow(c,v);
}

void
vtkAbstractToolBarUI::Show (void)
{
  if (this->ViewUI == NULL)
    {
    vtkAbstractViewUI* viewUI = vtkAbstractViewUI::New();

    this->SetViewUI(viewUI);
    viewUI->Delete();
    }
  this->ShowViewWindow();
  this->ShowMainWindow();
}

void
vtkAbstractToolBarUI::Hide (void)
{
  if (this->ViewUI != NULL) this->ViewUI->Hide();
  this->GetFltkWindow()->hide();
}

// ----------------------------------------------------------------------------
void
vtkAbstractToolBarUI::PrintSelf (ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget,aIndent);

  aTarget << aIndent << "ViewUI:                 "
          << this->ViewUI << endl;
  if (this->ViewUI != NULL)
    this->ViewUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "NodeBrowserUI:          "
          << this->NodeBrowserUI << endl;
  if (this->NodeBrowserUI != NULL)
    this->NodeBrowserUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "SourceBrowserUI:        "
          << this->SourceBrowserUI << endl;
  if (this->SourceBrowserUI != NULL)
    this->SourceBrowserUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "SurfacePropertiesUI:    "
          << this->SurfacePropertiesUI << endl;
  if (this->SurfacePropertiesUI != NULL)
    this->SurfacePropertiesUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "LightingUI:             "
          << this->LightingUI << endl;
  if (this->LightingUI != NULL)
    this->LightingUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "ViewportUI:             "
          << this->ViewportUI << endl;
  if (this->ViewportUI != NULL)
    this->ViewportUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "CameraUI:               "
          << this->CameraUI << endl;
  if (this->CameraUI != NULL)
    this->CameraUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "Matrix4x4UI:            "
          << this->Matrix4x4UI << endl;
  if (this->Matrix4x4UI != NULL)
    this->Matrix4x4UI->PrintSelf(aTarget, aIndent.GetNextIndent());
}

/*
 * End of: $Id: vtkAbstractToolBarUI.cxx,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $.
 *
 */
