/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractToolBarUI.h,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_ABSTRACT_TOOLBAR_UI_H_
#  define VTK_ABSTRACT_TOOLBAR_UI_H_
#  include "vtkAbstractUI.h"

class Fl_VTK_View;
class Fl_Toggle_Tree;
class Fl_Browser;

class vtkAbstractToolBarUI : public vtkAbstractUI
{
public:
  static vtkAbstractToolBarUI* New (void);
  vtkTypeRevisionMacro (vtkAbstractToolBarUI, vtkAbstractUI);
  void  PrintSelf (ostream&, vtkIndent);

  void          Default (vtkObject* = 0);
  void          Receive (vtkObject* = 0);
  void          Send (vtkObject* = 0);

  VTK_EXTENSIONS_NAMESPACE_QUALIFIER vtkRenderingContext*
  GetClientRenderingContext (void);

  virtual void                  SetViewUI (vtkAbstractUI* viewUI);
  vtkGetObjectMacro (ViewUI,vtkAbstractUI);

  virtual void                  SetNodeBrowserUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetNodeBrowserUI (void);

  virtual void                  SetSourceBrowserUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetSourceBrowserUI (void);

  virtual void                  SetSurfacePropertiesUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetSurfacePropertiesUI (void);

  virtual void                  SetLightingUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetLightingUI (void);

  virtual void                  SetViewportUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetViewportUI (void);

  virtual void                  SetCameraUI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetCameraUI (void);

  virtual void                  SetMatrix4x4UI (vtkAbstractUI*);
  virtual vtkAbstractUI*        GetMatrix4x4UI (void);

  Fl_Window*                    GetViewWindow (void);
  Fl_VTK_View*                  GetView (void);

  virtual Fl_Toggle_Tree*       GetNodeBrowser (void);
  virtual Fl_Browser*           GetSourceBrowser (void);

  Fl_Window*                    GetTopWindow (void);

  void  ShowMainWindow (int c, char** v);
  void  ShowViewWindow (int c, char** v, int flag = 0);
  void  ShowMainWindow (void);
  void  ShowViewWindow (int flag = 0);
  void  HideMainWindow (void);
  void  HideViewWindow (int flag = 0);
  void  Show (int c,char** v);
  void  Show (void);
  void  Hide (void);

protected:
  vtkAbstractToolBarUI (void);
  ~vtkAbstractToolBarUI();

  vtkAbstractUI*        ViewUI;
  vtkAbstractUI*        NodeBrowserUI;
  vtkAbstractUI*        SourceBrowserUI;
  vtkAbstractUI*        SurfacePropertiesUI;
  vtkAbstractUI*        LightingUI;
  vtkAbstractUI*        ViewportUI;
  vtkAbstractUI*        CameraUI;
  vtkAbstractUI*        Matrix4x4UI;

private:
  vtkAbstractToolBarUI (const vtkAbstractToolBarUI&); // Not implemented.;
  void operator= (const vtkAbstractToolBarUI&); // Not implemented.;
};

#endif /* VTK_ABSTRACT_TOOLBAR_UI_H_ */
/*
 * End of: $Id: vtkAbstractToolBarUI.h,v 1.1.1.1 2006/12/19 22:59:46 christianh Exp $.
 *
 */
