/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkAbstractViewportUI.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkViewportUI.h"
// VTK
#include "vtkFrustumCoverageCuller.h"
#include "vtkCullerCollection.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
// vtkExtensions
#include "vtkRenderingContext.h"
// VTK Common
#include "vtkDebugLeaks.h"
#include "vtkObjectFactory.h"

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);

// ----------------------------------------------------------------------------
//      v t k A b s t r a c t V i e w p o r t U I
// ----------------------------------------------------------------------------
vtkCxxRevisionMacro (vtkAbstractViewportUI, "$Revision: 1.1.1.1 $");
vtkInstantiatorNewMacro (vtkAbstractViewportUI);

// ----------------------------------------------------------------------------
vtkAbstractViewportUI*
vtkAbstractViewportUI::New (void)
{
  vtkObject* result = vtkObjectFactory::CreateInstance("vtkAbstractViewportUI");

  if (result != NULL)
    {
    return static_cast<vtkAbstractViewportUI*>(result);
    }

  vtkDebugLeaks::DestructClass("vtkAbstractViewportUI");

  return vtkViewportUI::New();
}

// ----------------------------------------------------------------------------
void
vtkAbstractViewportUI::Send (vtkObject* vtkNotUsed(a))
{
  this->Check();

  int i;
  float tmp[4];

  vtkRenderingContext* renderingContext;

  if ((renderingContext = this->GetClientRenderingContext()) != NULL)
    {
    vtkRenderWindow* renderWindow;

    if ((renderWindow = this->GetClientRenderWindow()) != NULL)
      {
      vtkRenderer* renderer;

      if ((renderer = this->GetCurrentClientRenderer()) != NULL)
        {
        vtkCullerCollection* cullers;

        if ((cullers = renderer->GetCullers()) != NULL)
          {
          vtkFrustumCoverageCuller* culler;

          cullers->InitTraversal();

          if ( ( culler = vtkFrustumCoverageCuller::
                 SafeDownCast(cullers->GetNextItem()) ) != NULL )
            {
            this->GetSortingStyle(i);
            culler->SetSortingStyle(i);
            }
          }

        this->GetViewport(tmp);
        renderer->SetViewport(tmp);

        this->GetTwoSidedLighting(i);
        renderer->SetTwoSidedLighting(i);
        this->GetLightFollowCamera(i);
        renderer->SetLightFollowCamera(i);
        this->GetBackingStore(i);
        renderer->SetBackingStore(i);
        }

      this->GetPointSmoothing(i);
      renderWindow->SetPointSmoothing(i);
      this->GetLineSmoothing(i);
      renderWindow->SetLineSmoothing(i);
      this->GetPolygonSmoothing(i);
      renderWindow->SetPolygonSmoothing(i);
      }

    this->GetDesiredUpdateRate(tmp[0]);
    renderingContext->SetDesiredUpdateRate(tmp[0]);
    this->GetStillUpdateRate(tmp[0]);
    renderingContext->SetStillUpdateRate(tmp[0]);
    }
}

void
vtkAbstractViewportUI::Receive (vtkObject* aObject)
{
  this->Check();

  int i;
  float tmp[4];

  vtkRenderingContext* renderingContext;

  if ((renderingContext = this->GetClientRenderingContext()) != NULL)
    {
    vtkRenderWindow* renderWindow;

    if ((renderWindow = this->GetClientRenderWindow()) != NULL)
      {
      vtkRenderer* renderer;

      if ((renderer = this->GetCurrentClientRenderer()) != NULL)
        {
        vtkCullerCollection* cullers;

        if ((cullers = renderer->GetCullers()) != NULL)
          {
          vtkFrustumCoverageCuller* culler;

          cullers->InitTraversal();
          if ( ( culler = vtkFrustumCoverageCuller::
                 SafeDownCast(cullers->GetNextItem()) ) != NULL )
            {
            i = culler->GetSortingStyle();
            this->SetSortingStyle(i);
            }
          }

        renderer->GetViewport(tmp);
        this->SetViewport(tmp);

        i = renderer->GetTwoSidedLighting();
        this->SetTwoSidedLighting(i);
        i = renderer->GetLightFollowCamera();
        this->SetLightFollowCamera(i);
        i = renderer->GetBackingStore();
        this->SetBackingStore(i);
        }

      i = renderWindow->GetPointSmoothing();
      this->SetPointSmoothing(i);
      i = renderWindow->GetLineSmoothing();
      this->SetLineSmoothing(i);
      i = renderWindow->GetPolygonSmoothing();
      this->SetPolygonSmoothing(i);
      }

    tmp[0] = renderingContext->GetDesiredUpdateRate();
    this->SetDesiredUpdateRate(tmp[0]);
    tmp[0] = renderingContext->GetStillUpdateRate();
    this->SetStillUpdateRate(tmp[0]);
    }
  else
    {
    this->Default(aObject);
    }
}

void
vtkAbstractViewportUI::Default (vtkObject* aObject)
{
  this->SetSortingStyle(VTK_CULLER_SORT_NONE);

  float tmp[4] = { 0.0, 0.0, 1.0, 1.0 };

  this->SetViewport(tmp);

  this->SetTwoSidedLighting(1);
  this->SetLightFollowCamera(1);
  this->SetBackingStore(0);

  this->SetPointSmoothing(1);
  this->SetLineSmoothing(1);
  this->SetPolygonSmoothing(0);

  this->SetDesiredUpdateRate(8.0);
  this->SetStillUpdateRate(0.00010);

  this->Send(aObject);
}

/*
 * End of: $Id: vtkAbstractViewportUI.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 *
 */
