/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkLightingCb.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkLightingUI.h"
// VTK Rendering
#include "vtkRenderer.h"
// FLTK
#include <FL/fl_ask.H>  // fl_message()

// ----------------------------------------------------------------------------
void
LightingUIAmbientRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*   renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetAmbient(rgb);
  rgb[0] = float(aInput->value());
  renderer->SetAmbient(rgb);

  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIAmbientGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*  renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetAmbient(rgb);
  rgb[1] = float(aInput->value());
  renderer->SetAmbient(rgb);

  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIAmbientBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*  renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetAmbient(rgb);
  rgb[2] = float(aInput->value());
  renderer->SetAmbient(rgb);

  lightingUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
LightingUIBackgroundRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*  renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetBackground(rgb);
  rgb[0] = float(aInput->value());
  renderer->SetBackground(rgb);

  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIBackgroundGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*  renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetBackground(rgb);
  rgb[1] = float(aInput->value());
  renderer->SetBackground(rgb);

  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIBackgroundBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLightingUI* lightingUI;
  vtkRenderer*  renderer;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;
  if ((renderer = lightingUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float rgb[3];

  renderer->GetBackground(rgb);
  rgb[2] = float(aInput->value());
  renderer->SetBackground(rgb);

  lightingUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
LightingUIInsertLightButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI*       lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

}

void
LightingUIRemoveLightButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI*       lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

}

// ----------------------------------------------------------------------------
void
LightingUIHelpButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI*       lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

  fl_message("Sorry, the Renderer Lighting Help is not yet helpful.");
}

void
LightingUIApplyButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI*       lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

  lightingUI->Send();
  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIDefaultButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI*       lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

  lightingUI->Default();
  lightingUI->UpdateClientRenderingContext();
}

void
LightingUIUpdateButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI* lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

  lightingUI->UpdateClientRenderingContext();
  lightingUI->Receive();
}

void
LightingUICloseButtonCb (Fl_Button*, void* aPtr)
{
  vtkLightingUI* lightingUI;

  if ( (lightingUI = reinterpret_cast<vtkLightingUI*>(aPtr))
       == (vtkLightingUI *) 0 )
    return;

  //lightingUI->Send();
  //lightingUI->UpdateClientRenderingContext();
  lightingUI->Hide();
}

/* 
 * End of: $Id: vtkLightingCb.cxx,v 1.1.1.1 2006/12/19 22:59:47 christianh Exp $.
 * 
 */
