/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkLightingUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:48 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkLight.h"
#include "vtkLightCollection.h"

void
vtkLightingUI::Check (void)
{
  Fl::check();
}

void
vtkLightingUI::GetAmbient (float a[3])
{
  a[0] = this->mAmbientRed->value();
  a[1] = this->mAmbientGreen->value();
  a[2] = this->mAmbientBlue->value();
}

void
vtkLightingUI::SetAmbient (float a[3])
{
  this->mAmbientRed->value(a[0]);
  this->mAmbientGreen->value(a[1]);
  this->mAmbientBlue->value(a[2]);
}

void
vtkLightingUI::GetBackground (float a[3])
{
  a[0] = this->mBackgroundRed->value();
  a[1] = this->mBackgroundGreen->value();
  a[2] = this->mBackgroundBlue->value();
}

void
vtkLightingUI::SetBackground (float a[3])
{
  this->mBackgroundRed->value(a[0]);
  this->mBackgroundGreen->value(a[1]);
  this->mBackgroundBlue->value(a[2]);
}

vtkLight*
vtkLightingUI::GetLight0 (void)
{
  vtkLightCollection* lights;

  if ((lights = this->GetCurrentClientLights()) != NULL)
    {
    vtkLight* light;

    lights->InitTraversal();
    return lights->GetNextItem();
    }

  return NULL;
}

void
vtkLightingUI::InitializeLight0 (void)
{
  if (this->mRendererLight0 != NULL)
    {
    this->mRendererLight0->Initialize( this->GetClientRenderingContext(),
                                       this->GetLight0() );
    }
}

void
vtkLightingUI::DefaultToLight0 (vtkObject* vtkNotUsed(a))
{
  this->mRendererLight0->Default();
}

void
vtkLightingUI::ReceiveToLight0 (vtkObject* aObject)
{
  this->mRendererLight0->Receive(aObject);
}

void
vtkLightingUI::SendFromLight0 (vtkObject* aObject)
{
  this->mRendererLight0->Send(aObject);
}

/*
 * End of: $Id: vtkLightingUIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:48 christianh Exp $.
 *
 */
