/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkLoadDialogCb.cxx,v 1.1.1.1 2006/12/19 22:59:48 christianh Exp $
 * 
 * Copyright (c) 2003, 2004 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkLoadDialogUI.h"
#include "svv_file_chooser.h"
// FLTK
#include <FL/fl_ask.H>  // fl_message()

// ----------------------------------------------------------------------------
void
LoadDialogUISingleRadioCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ShowSingleGroup();
  //gui->Check();
}

void
LoadDialogUIMultipleRadioCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ShowMultipleGroup();
  //gui->Check();
}

void
LoadDialogUISeriesRadioCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ShowSeriesGroup();
  //gui->Check();
}

void
LoadDialogUIDirectoryRadioCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ShowDirectoryGroup();
  //gui->Check();
}

// ----------------------------------------------------------------------------
void
LoadDialogUISingleFileInputChooseCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  long          type;
  const char*   pattern;
  const char*   message = NULL;
  char*         pathName;

  gui->GetInputTypeValue(type);
  gui->GetInputTypeText(pattern);

  if      (type < vtkLoadDialogUI::VTK_INPUT_TYPE_POLYDATA)
    message = "Select single input";
  else if (type < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    message = "Select single surface / polygonal input";
  else
    message = "Select single volume / image input";

  if ((pathName = svv_singlefile_chooser(message, pattern)) != NULL)
    {
    gui->SetSingleFileInput(pathName);
    }
}

void
LoadDialogUISingleFileInputClearCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ClearSingleFileInput();
}

// ----------------------------------------------------------------------------
void
LoadDialogUIMultipleFileBrowserChooseCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  long          type;
  const char*   pattern;
  const char*   message = NULL;
  char*         pathName;
  int           count;

  gui->GetInputTypeValue(type);
  gui->GetInputTypeText(pattern);

  if      (type < vtkLoadDialogUI::VTK_INPUT_TYPE_POLYDATA)
    message = "Select multiple inputs";
  else if (type < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    message = "Select multiple surface / polygonal inputs";
  else
    message = "Select multiple volume / image inputs";

  if ((count = svv_multifile_chooser(message, pattern)) != 0)
    {
    for (int i=0; i<count; i++)
      {
      gui->AddToMultipleFileBrowser(svv_file_chooser_value(i));
      }
    }
}

void
LoadDialogUIMultipleFileBrowserClearCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ClearMultipleFileBrowser();
}

// ----------------------------------------------------------------------------
void
LoadDialogUIFirstFileInputCb (Fl_File_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFirstFileInputChooseCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  long          type;
  const char*   pattern;
  const char*   message = NULL;
  char*         pathName;

  gui->GetInputTypeValue(type);
  gui->GetInputTypeText(pattern);

  if      (type < vtkLoadDialogUI::VTK_INPUT_TYPE_POLYDATA)
    message = "Select First Input of Series";
  else if (type < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    message = "Select First Input of PolyData Series";
  else
    message = "Select First Input of Image Series (Volume)";

  if ((pathName = svv_singlefile_chooser(message, pattern)) != NULL)
    {
    gui->SetFirstFileInput(pathName);
    }
}

void
LoadDialogUIFirstFileInputClearCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ClearFirstFileInput();
}

void
LoadDialogUILastFileInputCb (Fl_File_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUILastFileInputChooseCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  long          type;
  const char*   pattern;
  const char*   message = NULL;
  char*         pathName;

  gui->GetInputTypeValue(type);
  gui->GetInputTypeText(pattern);

  if      (type < vtkLoadDialogUI::VTK_INPUT_TYPE_POLYDATA)
    message = "Select Last Input of Series";
  else if (type < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    message = "Select Last Input of PolyData Series";
  else
    message = "Select Last Input of Image Series (Volume)";

  if ((pathName = svv_singlefile_chooser(message, pattern)) != NULL)
    {
    gui->SetLastFileInput(pathName);
    }
}

void
LoadDialogUILastFileInputClearCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ClearLastFileInput();
}

// ----------------------------------------------------------------------------
void
LoadDialogUIDirectoryNameInputCb (Fl_File_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIDirectoryNameInputChooseCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  long          type;
  const char*   pattern;
  const char*   message = NULL;
  char*         pathName;

  gui->GetInputTypeValue(type);
  gui->GetInputTypeText(pattern);

  if      (type < vtkLoadDialogUI::VTK_INPUT_TYPE_POLYDATA)
    message = "Select directory containing inputs";
  else if (type < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    message = "Select directory containing surface / polygonal inputs";
  else
    message = "Select directory containing volume / image inputs";

  if ((pathName = svv_dir_chooser(message)) != NULL)
    {
    gui->SetDirectoryNameInput(pathName);
    }
}

void
LoadDialogUIDirectoryNameInputClearCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->ClearDirectoryNameInput();
}

// ----------------------------------------------------------------------------
void
LoadDialogUIFilePrefixInputCb (Fl_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFileDigitsInputCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFileInfixInputCb (Fl_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFileSuffixInputCb (Fl_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFileOffsetInputCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

void
LoadDialogUIFileCountInputCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkLoadDialogUI* gui;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;
}

// ----------------------------------------------------------------------------
void
LoadDialogUIInputTypeCb (Fl_Menu_* aMenu, long aItem)
{
  vtkLoadDialogUI* gui;

  if (aMenu == NULL)
    return;
  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aMenu->user_data())) == NULL)
    return;

  gui->SyncInputType();

  if      (aItem == vtkLoadDialogUI::VTK_INPUT_TYPE_AUTOMATIC)
    {
    gui->mSingleRadio->activate();
    gui->mMultipleRadio->activate();
    gui->mSeriesRadio->activate();
    gui->mDirectoryRadio->activate();
    gui->SetSelectionTypeToSingle();
    }
  else if (aItem < vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA)
    {
    gui->mSingleRadio->activate();
    gui->mMultipleRadio->activate();
    gui->mSeriesRadio->deactivate();
    gui->mDirectoryRadio->deactivate();
    gui->SetSelectionTypeToSingle();
    }
  else
    {
    gui->mMultipleRadio->deactivate();

    switch (aItem)
      {
      // Volume data
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA:
        gui->mSingleRadio->activate();
        gui->mSeriesRadio->activate();
        gui->mDirectoryRadio->activate();
        gui->SetSelectionTypeToSingle();
        break;

      // Single 3D Volume files.
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_VTK:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_VTK_VTK:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_VTK_VTI:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_VTK_PVTI:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_3D:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_3D_SLC:
        gui->mSingleRadio->activate();
        gui->mSeriesRadio->deactivate();
        gui->mDirectoryRadio->deactivate();
        gui->SetSelectionTypeToSingle();
        break;
      // Volume Series of 2D Slices.
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA_MR:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_GESIGNA_CT:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BUCHAR:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BSHORT:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BUSHORT:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_MEDICAL_BLOCK_BFLOAT:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_FREESURFER_COR:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_BMP:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_PNM:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_JPEG:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_PNG:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_TIFF:
      case vtkLoadDialogUI::VTK_INPUT_TYPE_IMAGEDATA_OTHER_2D_DEM:
        gui->mSeriesRadio->activate();
        gui->mDirectoryRadio->activate();
        gui->mSingleRadio->deactivate();
        gui->SetSelectionTypeToSeries();
        break;
      } // switch (aItem)
    }
}

// ----------------------------------------------------------------------------
void
LoadDialogUIHelpButtonCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  fl_message("Sorry, the Load Dialog Help is not yet helpful.");
}

void
LoadDialogUIApplyButtonCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->Send();
  gui->UpdateClientRenderingContext();
}

void
LoadDialogUIDefaultButtonCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->Default();
  gui->UpdateClientRenderingContext();
}

void
LoadDialogUIUpdateButtonCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->Receive();
  gui->UpdateClientRenderingContext();
}

void
LoadDialogUICloseButtonCb (Fl_Button* vtkNotUsed(a), void* aPtr)
{
  vtkLoadDialogUI* gui;

  if ((gui = reinterpret_cast<vtkLoadDialogUI*>(aPtr)) == NULL)
    return;

  gui->Hide();
}

/*
 * End of: $Id: vtkLoadDialogCb.cxx,v 1.1.1.1 2006/12/19 22:59:48 christianh Exp $.
 *
 */
