/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkMatrix4x4UIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

void
vtkMatrix4x4UI::Check (void)
{
  Fl::check();
}

void
vtkMatrix4x4UI::ReceiveInternal (vtkObject* vtkNotUsed(a))
{
  this->mValue00->value(this->Matrix->GetElement(0,0));
  this->mValue01->value(this->Matrix->GetElement(0,1));
  this->mValue02->value(this->Matrix->GetElement(0,2));
  this->mValue03->value(this->Matrix->GetElement(0,3));
  this->mValue10->value(this->Matrix->GetElement(1,0));
  this->mValue11->value(this->Matrix->GetElement(1,1));
  this->mValue12->value(this->Matrix->GetElement(1,2));
  this->mValue13->value(this->Matrix->GetElement(1,3));
  this->mValue20->value(this->Matrix->GetElement(2,0));
  this->mValue21->value(this->Matrix->GetElement(2,1));
  this->mValue22->value(this->Matrix->GetElement(2,2));
  this->mValue23->value(this->Matrix->GetElement(2,3));
  this->mValue30->value(this->Matrix->GetElement(3,0));
  this->mValue31->value(this->Matrix->GetElement(3,1));
  this->mValue32->value(this->Matrix->GetElement(3,2));
  this->mValue33->value(this->Matrix->GetElement(3,3));
}

void
vtkMatrix4x4UI::SendInternal (vtkObject* vtkNotUsed(a))
{
  this->Matrix->SetElement(0,0,this->mValue00->value());
  this->Matrix->SetElement(0,1,this->mValue01->value());
  this->Matrix->SetElement(0,2,this->mValue02->value());
  this->Matrix->SetElement(0,3,this->mValue03->value());
  this->Matrix->SetElement(1,0,this->mValue10->value());
  this->Matrix->SetElement(1,1,this->mValue11->value());
  this->Matrix->SetElement(1,2,this->mValue12->value());
  this->Matrix->SetElement(1,3,this->mValue13->value());
  this->Matrix->SetElement(2,0,this->mValue20->value());
  this->Matrix->SetElement(2,1,this->mValue21->value());
  this->Matrix->SetElement(2,2,this->mValue22->value());
  this->Matrix->SetElement(2,3,this->mValue23->value());
  this->Matrix->SetElement(3,0,this->mValue30->value());
  this->Matrix->SetElement(3,1,this->mValue31->value());
  this->Matrix->SetElement(3,2,this->mValue32->value());
  this->Matrix->SetElement(3,3,this->mValue33->value());
}

void
vtkMatrix4x4UI::DefaultInternal (vtkObject* aObject)
{
  this->Matrix->Identity();
  this->ReceiveInternal(aObject);
}

void
vtkMatrix4x4UI::Activate (void)
{
  this->mMatrixValues->activate();
  this->mApplyButton->activate();
}

void
vtkMatrix4x4UI::Deactivate (void)
{
  this->mMatrixValues->deactivate();
  this->mApplyButton->deactivate();
}

int
vtkMatrix4x4UI::IsActive (void)
{
  return (this->mMatrixValues->active() && this->mApplyButton->active() ?1:0);
}

/*
 * End of: $Id: vtkMatrix4x4UIImpl.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $.
 *
 */
