/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkSurfacePropertiesMaterialsCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkSurfacePropertiesUI.h"
// FLTK
#include <FL/Fl.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Menu_Item.H>
#include "Fl_Color_Chooser_A.H"
#include <FL/Fl_Value_Input.H>
// VTK Rendering
#include "vtkProperty.h"
// SVV
#include "svvTypes.h"   /* Material */

// ----------------------------------------------------------------------------
void
FrontDefinedMaterialsCb (Fl_Menu_Button* aMenu, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  const Fl_Menu_Item*     item;
  SvvMaterial                material;
  vtkProperty*            frontProperty;

  if (aMenu == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((item = aMenu->mvalue()) == NULL)
    return;
  if (!(vtkSurfacePropertiesUI::FindNamedMaterial(item->label(),material)))
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;
  
  float before = frontProperty->GetOpacity();

  // Translate from Material struct to Property object.
  vtkSurfacePropertiesUI::MaterialToProperty(frontProperty, material);
  // Update the interface inputs.
  gui->ReceiveFront();

  float after  = frontProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }
  
  gui->UpdateDemoRenderingContext();
}

void
BackDefinedMaterialsCb (Fl_Menu_Button* aMenu, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  const Fl_Menu_Item*     item;
  SvvMaterial                material;
  vtkProperty*            backProperty;

  if (aMenu == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((item = aMenu->mvalue()) == NULL)
    return;
  if (!(vtkSurfacePropertiesUI::FindNamedMaterial(item->label(),material)))
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float before = backProperty->GetOpacity();

  // Translate from Material struct to Property object.
  vtkSurfacePropertiesUI::MaterialToProperty(backProperty, material);
  // Update the interface inputs.
  gui->ReceiveBack();

  float after  = backProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }
  
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontColorChooserCb (Fl_Color_Chooser_A* aChooser, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aChooser == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetColor(aChooser->r(), aChooser->g(), aChooser->b());

  float before = frontProperty->GetOpacity();

  // Set property ivar to interface value.
  frontProperty->SetOpacity(aChooser->a());

  float after  = frontProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }

  gui->UpdateDemoRenderingContext();
}

void
BackColorChooserCb (Fl_Color_Chooser_A* aChooser, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aChooser == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetColor(aChooser->r(), aChooser->g(), aChooser->b());

  float before = backProperty->GetOpacity();

  // Set property ivar to interface value.
  backProperty->SetOpacity(aChooser->a());

  float after  = backProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetColor(rgb);
  frontProperty->SetColor(float(aInput->value()),rgb[1],rgb[2]);

  // Update front ambient, diffuse, and specular.
  gui->ReceiveFrontReflectance();
  gui->UpdateDemoRenderingContext();
}

void
FrontGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetColor(rgb);
  frontProperty->SetColor(rgb[0],float(aInput->value()),rgb[2]);

  // Update front ambient, diffuse, and specular.
  gui->ReceiveFrontReflectance();
  gui->UpdateDemoRenderingContext();
}

void
FrontBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetColor(rgb);
  frontProperty->SetColor(rgb[0],rgb[1],float(aInput->value()));

  // Update front ambient, diffuse, and specular.
  gui->ReceiveFrontReflectance();
  gui->UpdateDemoRenderingContext();
}

void
FrontOpacityCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float before = frontProperty->GetOpacity();

  frontProperty->SetOpacity(float(aInput->value()));

  float after  = frontProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontAmbientCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetAmbient(float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontAmbientRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetAmbientColor(rgb);
  frontProperty->SetAmbientColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontAmbientGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetAmbientColor(rgb);
  frontProperty->SetAmbientColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontAmbientBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetAmbientColor(rgb);
  frontProperty->SetAmbientColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontDiffuseCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetDiffuse(float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontDiffuseRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetDiffuseColor(rgb);
  frontProperty->SetDiffuseColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontDiffuseGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetDiffuseColor(rgb);
  frontProperty->SetDiffuseColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontDiffuseBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetDiffuseColor(rgb);
  frontProperty->SetDiffuseColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontSpecularCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetSpecular(float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontSpecularRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetSpecularColor(rgb);
  frontProperty->SetSpecularColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontSpecularGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetSpecularColor(rgb);
  frontProperty->SetSpecularColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

void
FrontSpecularBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  float rgb[3];
  frontProperty->GetSpecularColor(rgb);
  frontProperty->SetSpecularColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
FrontShininessCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            frontProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((frontProperty = gui->GetDemoFrontProperty()) == NULL)
    return;

  frontProperty->SetSpecularPower(float(aInput->value()));

  gui->ReceiveFrontComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
BackRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetColor(rgb);
  backProperty->SetColor(float(aInput->value()),rgb[1],rgb[2]);

  // Update back ambient, diffuse, and specular.
  gui->ReceiveBackReflectance();
  gui->UpdateDemoRenderingContext();
}

void
BackGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetColor(rgb);
  backProperty->SetColor(rgb[0],float(aInput->value()),rgb[2]);

  // Update back ambient, diffuse, and specular.
  gui->ReceiveBackReflectance();
  gui->UpdateDemoRenderingContext();
}

void
BackBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetColor(rgb);
  backProperty->SetColor(rgb[0],rgb[1],float(aInput->value()));

  // Update back ambient, diffuse, and specular.
  gui->ReceiveBackReflectance();
  gui->UpdateDemoRenderingContext();
}

void
BackOpacityCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float before = backProperty->GetOpacity();

  backProperty->SetOpacity(float(aInput->value()));

  float after  = backProperty->GetOpacity();

  if ((before<1.f && after>=1.f) || (before>=1.f && after<1.f))
    {
    gui->InitializeDemo();
    }

  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
BackAmbientCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetAmbient(float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackAmbientRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetAmbientColor(rgb);
  backProperty->SetAmbientColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackAmbientGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetAmbientColor(rgb);
  backProperty->SetAmbientColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackAmbientBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetAmbientColor(rgb);
  backProperty->SetAmbientColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
BackDiffuseCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetDiffuse(float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackDiffuseRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetDiffuseColor(rgb);
  backProperty->SetDiffuseColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackDiffuseGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetDiffuseColor(rgb);
  backProperty->SetDiffuseColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackDiffuseBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetDiffuseColor(rgb);
  backProperty->SetDiffuseColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
BackSpecularCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetSpecular(float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackSpecularRedCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetSpecularColor(rgb);
  backProperty->SetSpecularColor(float(aInput->value()),rgb[1],rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackSpecularGreenCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetSpecularColor(rgb);
  backProperty->SetSpecularColor(rgb[0],float(aInput->value()),rgb[2]);

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

void
BackSpecularBlueCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  float rgb[3];
  backProperty->GetSpecularColor(rgb);
  backProperty->SetSpecularColor(rgb[0],rgb[1],float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

// ----------------------------------------------------------------------------
void
BackShininessCb (Fl_Value_Input* aInput, void* aPtr)
{
  vtkSurfacePropertiesUI* gui;
  vtkProperty*            backProperty;

  if (aInput == NULL)
    return;
  if ((gui = reinterpret_cast<vtkSurfacePropertiesUI*>(aPtr)) == NULL)
    return;
  if ((backProperty = gui->GetDemoBackProperty()) == NULL)
    return;

  backProperty->SetSpecularPower(float(aInput->value()));

  gui->ReceiveBackComposite();
  gui->UpdateDemoRenderingContext();
}

/* 
 * End of: $Id: vtkSurfacePropertiesMaterialsCb.cxx,v 1.1.1.1 2006/12/19 22:59:49 christianh Exp $.
 * 
 */
