/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkToolBarTest.cxx,v 1.1.1.1 2006/12/19 22:59:50 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "svvController.h"
// VTL Common
#include "vtkOutputWindow.h"
#include "vtkInstantiator.h"

// C++ forwarding ANSI C
#include <cstdlib>
#include <cstring> /* strrchr() */
// FLTK
#include <FL/Fl.H>
#include <FL/gl.h>
#include <FL/Fl_Widget.H>
// SVV
#include "vtkToolBarUI.h"
#include "svvExitUI.h"
#include "svvMessagesRedirection.h"


// ----------------------------------------------------------------------------
static const char* sgInput  = 0;
static const char* sgOutput = 0;


// ----------------------------------------------------------------------------
static void
sgPrintUsage (ostream& aTarget, int& aArgc, char**& aArgv)
{
  const char* ptr;

  if ((ptr = strrchr(aArgv[0], '/')) != (char *) 0) ptr++;
  else                                              ptr = aArgv[0];

  aTarget << "Usage: " << ptr << endl;
  aTarget << Fl::help << endl;
}

// ----------------------------------------------------------------------------
static int
sgParseArgs (int aArgc, char** aArgv, int& aI)
{
  if      ((aArgv[aI][1] == 'i') && (aArgv[aI][2] == '\0') && (aI+1 < aArgc))
    {
    sgInput = aArgv[aI+1];
    aI += 2;
    return 2;
    }
  else if ((aArgv[aI][1] == 'o') && (aArgv[aI][2] == '\0') && (aI+1 < aArgc))
    {
    sgOutput = aArgv[aI+1];
    aI += 2;
    return 2;
    }
  else if ((aArgv[aI][1] == 'h') && (aArgv[aI][2] == '\0'))
    {
    sgPrintUsage(cerr, aArgc, aArgv);
    aI += 1;
    return 1;
    }

  return 0;
}

// ----------------------------------------------------------------------------
int
main (int argc, char* argv[])
{
  int i = 1;

  if (!Fl::args(argc, argv, i, sgParseArgs) || (i < argc-1))
    {
    sgPrintUsage(cerr, argc, argv);
    return 1;
    }

  Fl::lock();

  svvMessagesRedirection::RedirectVtkStreams();
  svvMessagesRedirection::RedirectLogStream();
  
  // Don't prompt the user with startup errors on unix.
#if defined(_WIN32) && !defined(__CYGWIN__)
  vtkOutputWindow::GetInstance()->PromptUserOn();
#else
  vtkOutputWindow::GetInstance()->PromptUserOff();
#endif

  vtkToolBarUI* gui = vtkToolBarUI::New();

  // Show the GUI tree window.
  gui->Show(argc, argv);

#ifdef SVV_UNIX
  signal(SIGILL, SvvSignalHandler);
  signal(SIGFPE, SvvSignalHandler);
  signal(SIGSEGV, SvvSignalHandler);
  signal(SIGBUS, SvvSignalHandler);
  signal(SIGINT, SvvSignalHandler);
#endif /* SVV_UNIX */

  int result = Fl::run();

  svvMessagesRedirection::RestoreVtkStreams();
  svvMessagesRedirection::RestoreLogStream();

  gui->Delete();

  return result;
}

/* 
 * End of: $Id: vtkToolBarTest.cxx,v 1.1.1.1 2006/12/19 22:59:50 christianh Exp $.
 * 
 */
