/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkViewportCb.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkViewportUI.h"
// VTK Rendering
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkCuller.h"
#include "vtkFrustumCoverageCuller.h"
#include "vtkCullerCollection.h"
// vtkExtensions
#include "vtkRenderingContext.h"
// FLTK
#include <FL/fl_ask.H>  // fl_message()

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);

// ----------------------------------------------------------------------------
void
ViewportUITwoSidedLightingToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  renderer->SetTwoSidedLighting(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUILightFollowsCameraToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  renderer->SetLightFollowCamera(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIBackingStoreToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  renderer->SetBackingStore(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
ViewportUIPointSmoothingToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI*   viewportUI;
  vtkRenderWindow* renderWindow;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderWindow = viewportUI->GetClientRenderWindow())
       == (vtkRenderWindow *) 0 )
    return;

  renderWindow->SetPointSmoothing(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUILineSmoothingToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI*   viewportUI;
  vtkRenderWindow* renderWindow;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderWindow = viewportUI->GetClientRenderWindow())
       == (vtkRenderWindow *) 0 )
    return;

  renderWindow->SetLineSmoothing(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIPolygonSmoothingToggleCb (Fl_Check_Button* aButton, void* aPtr)
{
  vtkViewportUI*   viewportUI;
  vtkRenderWindow* renderWindow;

  if (aButton == (Fl_Check_Button *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderWindow = viewportUI->GetClientRenderWindow())
       == (vtkRenderWindow *) 0 )
    return;

  renderWindow->SetPolygonSmoothing(int(aButton->value()));

  viewportUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
ViewportUIExtentX0Cb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float viewport[4];

  renderer->GetViewport(viewport);
  viewport[0] = float(aValuator->value());
  renderer->SetViewport(viewport);

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIExtentY0Cb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float viewport[4];

  renderer->GetViewport(viewport);
  viewport[1] = float(aValuator->value());
  renderer->SetViewport(viewport);

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIExtentX1Cb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float viewport[4];

  renderer->GetViewport(viewport);
  viewport[2] = float(aValuator->value());
  renderer->SetViewport(viewport);

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIExtentY1Cb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI* viewportUI;
  vtkRenderer*   renderer;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;

  float viewport[4];

  renderer->GetViewport(viewport);
  viewport[3] = float(aValuator->value());
  renderer->SetViewport(viewport);

  viewportUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
ViewportUICullerSortingMenuCb (Fl_Choice* aMenu, void* aPtr)
{
  vtkViewportUI*       viewportUI;
  vtkRenderer*         renderer;
  vtkCullerCollection* cullers;

  if (aMenu == (Fl_Choice *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ((renderer = viewportUI->GetCurrentClientRenderer()) == (vtkRenderer *) 0)
    return;
  if ((cullers = renderer->GetCullers()) == (vtkCullerCollection *) 0)
    return;

  vtkFrustumCoverageCuller* culler;

  cullers->InitTraversal();
  if ( (culler = vtkFrustumCoverageCuller::SafeDownCast(cullers->GetNextItem()))
       == (vtkFrustumCoverageCuller *) 0 )
    return;

  switch (aMenu->value())
    {
    case 1:  culler->SetSortingStyleToBackToFront(); break;
    case 2:  culler->SetSortingStyleToFrontToBack(); break;
    case 0:
    default: culler->SetSortingStyleToNone();        break;
    }
}

// ----------------------------------------------------------------------------
void
ViewportUIDesiredUpdateRateAdjusterCb (Fl_Adjuster* aValuator, void* aPtr)
{
  vtkViewportUI*       viewportUI;
  vtkRenderingContext* renderingContext;

  if (aValuator == (Fl_Adjuster *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderingContext = viewportUI->GetClientRenderingContext())
       == (vtkRenderingContext *) 0 )
    return;

  renderingContext->SetDesiredUpdateRate(float(aValuator->value()));
  viewportUI->mDesiredUpdateRate->value(aValuator->value());

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIDesiredUpdateRateCb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI*       viewportUI;
  vtkRenderingContext* renderingContext;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderingContext = viewportUI->GetClientRenderingContext())
       == (vtkRenderingContext *) 0 )
    return;

  renderingContext->SetDesiredUpdateRate(float(aValuator->value()));
  viewportUI->mDesiredUpdateRateAdjuster->value(aValuator->value());

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIStillUpdateRateAdjusterCb (Fl_Adjuster* aValuator, void* aPtr)
{
  vtkViewportUI*       viewportUI;
  vtkRenderingContext* renderingContext;

  if (aValuator == (Fl_Adjuster *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderingContext = viewportUI->GetClientRenderingContext())
       == (vtkRenderingContext *) 0 )
    return;

  renderingContext->SetStillUpdateRate(float(aValuator->value()));
  viewportUI->mStillUpdateRate->value(aValuator->value());

  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIStillUpdateRateCb (Fl_Value_Input* aValuator, void* aPtr)
{
  vtkViewportUI*       viewportUI;
  vtkRenderingContext* renderingContext;

  if (aValuator == (Fl_Value_Input *) 0)
    return;
  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;
  if ( (renderingContext = viewportUI->GetClientRenderingContext())
       == (vtkRenderingContext *) 0 )
    return;

  renderingContext->SetStillUpdateRate(float(aValuator->value()));
  viewportUI->mStillUpdateRateAdjuster->value(aValuator->value());

  viewportUI->UpdateClientRenderingContext();
}

// ----------------------------------------------------------------------------
void
ViewportUIHelpButtonCb (Fl_Button*, void* aPtr)
{
  vtkViewportUI* viewportUI;

  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;

  fl_message("Sorry, the Renderer Viewport Help is not yet helpful.");
}

void
ViewportUIApplyButtonCb (Fl_Button*, void* aPtr)
{
  vtkViewportUI* viewportUI;

  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;

  viewportUI->Send();
  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIDefaultButtonCb (Fl_Button*, void* aPtr)
{
  vtkViewportUI* viewportUI;

  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;

  viewportUI->Default();
  viewportUI->UpdateClientRenderingContext();
}

void
ViewportUIUpdateButtonCb (Fl_Button*, void* aPtr)
{
  vtkViewportUI* viewportUI;

  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;

  viewportUI->UpdateClientRenderingContext();
  viewportUI->Receive();
}

void
ViewportUICloseButtonCb (Fl_Button*, void* aPtr)
{
  vtkViewportUI* viewportUI;

  if ( (viewportUI = reinterpret_cast<vtkViewportUI*>(aPtr))
       == (vtkViewportUI *) 0 )
    return;

  viewportUI->Hide();
}

/* 
 * End of: $Id: vtkViewportCb.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $.
 * 
 */
