/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * $Id: vtkWidgets.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $
 * 
 * Copyright (c) 2002, 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#include "vtkWidgets.h"
// STL allocation.
#include <new>
// vtkExtensions
#include "vtkRenderingContext.h"
// SV widgets
#include "Fl_VTK_View.H"
#include "vtkViewUI.h"
#include "vtkToolBarUI.h"
#include "vtkNodeBrowserUI.h"
#include "vtkLightingUI.h"
#include "vtkViewportUI.h"
#include "vtkCameraUI.h"
#include "vtkSurfacePropertiesUI.h"
#include "vtkMatrix4x4UI.h"
// VTK Common
#include "vtkObjectFactory.h"

VTK_EXTENSIONS_NAMESPACE_USING(vtkRenderingContext);

/** \internal
 * this is for fake initialization
 */
template <typename T>
union _aligned_buffer_t
{
  char buf[sizeof(T)];
  struct { double a; double b; } padding;
};


long vtkWidgets::Init::s_translation_units_ = 0;

// Singleton static space.
static _aligned_buffer_t<vtkWidgets> fake;
// Singleton instance reference.
vtkWidgets& widgets = *(reinterpret_cast<vtkWidgets*>(&fake));

///////////////////////////////////////////////////////////////////////////////
// Begin class singleton internals
///////////////////////////////////////////////////////////////////////////////

vtkCxxRevisionMacro (vtkWidgets, "$Revision: 1.1.1.1 $");

vtkWidgets*
vtkWidgets::New(void)
{
  return &widgets;
}

// ----------------------------------------------------------------------------
vtkWidgets::vtkWidgets (void)
  : ViewUI(0),
    ToolBarUI(0),
    NodeBrowserUI(0),
    LightingUI(0),
    ViewportUI(0),
    CameraUI(0),
    SurfacePropertiesUI(0),
    Matrix4x4UI(0)
{
  if (this != &widgets)
    {
    vtkErrorMacro(<<"Violation of singleton policy should not be possible!");
    }
}

vtkWidgets::~vtkWidgets()
{
  if (this != &widgets)
    {
    vtkErrorMacro(<<"Violation of singleton policy should not be possible!");
    }

  if (this->ToolBarUI != (vtkToolBarUI *) 0)
    this->ToolBarUI->UnRegister(this);

  if (this->NodeBrowserUI != (vtkNodeBrowserUI *) 0)
    this->NodeBrowserUI->UnRegister(this);

  if (this->LightingUI != (vtkLightingUI *) 0)
    this->LightingUI->UnRegister(this);

  if (this->ViewportUI != (vtkViewportUI *) 0)
    this->ViewportUI->UnRegister(this);

  if (this->CameraUI != (vtkCameraUI *) 0)
    this->CameraUI->UnRegister(this);

  if (this->SurfacePropertiesUI != (vtkSurfacePropertiesUI *) 0)
    this->SurfacePropertiesUI->UnRegister(this);

  if (this->Matrix4x4UI != (vtkMatrix4x4UI *) 0)
    this->Matrix4x4UI->UnRegister(this);

  if (this->ViewUI != (vtkViewUI *) 0)
    this->ViewUI->UnRegister(this);
}

// ----------------------------------------------------------------------------
vtkWidgets::Init::Init(void)
{
  if (s_translation_units_++ == 0)
    {
    vtkWidgets::ClassInitialize();
    }
}

vtkWidgets::Init::~Init(void)
{
  if (--s_translation_units_ == 0)
    {
    vtkWidgets::ClassFinalize();
    }
}

// ----------------------------------------------------------------------------
void
vtkWidgets::ClassInitialize(void)
{
  vtkWidgets* widgetsPtr = new((void*)&fake) vtkWidgets;
}

void
vtkWidgets::ClassFinalize(void)
{
  vtkWidgets* widgetsPtr = reinterpret_cast<vtkWidgets*>(&widgets);
  // The superclass constructor sets the reference count to 1. Since the
  // instance owns itself, the count remains at 1 until it's time to die.
  widgetsPtr->SetReferenceCount(0);
  // EXPLICIT DESTRUCTOR CALL AHEAD ... think thrice!!!
  widgetsPtr->~vtkWidgets();
}

///////////////////////////////////////////////////////////////////////////////
// End of class singleton internals
///////////////////////////////////////////////////////////////////////////////

#if 0
// ----------------------------------------------------------------------------
vtkCxxSetObjectMacro (vtkWidgets, ViewUI, vtkViewUI);
vtkCxxSetObjectMacro (vtkWidgets, ToolBarUI, vtkToolBarUI);
vtkCxxSetObjectMacro (vtkWidgets, NodeBrowserUI, vtkNodeBrowserUI);
vtkCxxSetObjectMacro (vtkWidgets, LightingUI, vtkLightingUI);
vtkCxxSetObjectMacro (vtkWidgets, ViewportUI, vtkViewportUI);
vtkCxxSetObjectMacro (vtkWidgets, CameraUI, vtkCameraUI);
vtkCxxSetObjectMacro (vtkWidgets, SurfacePropertiesUI, vtkSurfacePropertiesUI);
vtkCxxSetObjectMacro (vtkWidgets, Matrix4x4UI, vtkMatrix4x4UI);
#endif /* 0 */

// ----------------------------------------------------------------------------
vtkViewUI*
vtkWidgets::GetViewUI (void)
{
  if (this->ViewUI == (vtkViewUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    this->ViewUI = vtkViewUI::New();
    renderingContext = this->ViewUI->GetClientRenderingContext();

    if (this->ToolBarUI != (vtkToolBarUI *) 0)
      this->ToolBarUI->SetClientRenderingContext(renderingContext);

    if (this->NodeBrowserUI != (vtkNodeBrowserUI *) 0)
      this->NodeBrowserUI->SetClientRenderingContext(renderingContext);

    if (this->LightingUI != (vtkLightingUI *) 0)
      this->LightingUI->SetClientRenderingContext(renderingContext);

    if (this->ViewportUI != (vtkViewportUI *) 0)
      this->ViewportUI->SetClientRenderingContext(renderingContext);

    if (this->CameraUI != (vtkCameraUI *) 0)
      this->CameraUI->SetClientRenderingContext(renderingContext);

    if (this->SurfacePropertiesUI != (vtkSurfacePropertiesUI *) 0)
      this->SurfacePropertiesUI->SetClientRenderingContext(renderingContext);

    if (this->Matrix4x4UI != (vtkMatrix4x4UI *) 0)
      this->Matrix4x4UI->SetClientRenderingContext(renderingContext);
    }

  return this->ViewUI;
}

// ----------------------------------------------------------------------------
vtkToolBarUI*
vtkWidgets::GetToolBarUI (void)
{
  if (this->ToolBarUI == (vtkToolBarUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->ToolBarUI = vtkToolBarUI::New();
      this->ToolBarUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->ToolBarUI;
}

// ----------------------------------------------------------------------------
vtkNodeBrowserUI*
vtkWidgets::GetNodeBrowserUI (void)
{
  if (this->NodeBrowserUI == (vtkNodeBrowserUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->NodeBrowserUI = vtkNodeBrowserUI::New();
      this->NodeBrowserUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->NodeBrowserUI;
}

// ----------------------------------------------------------------------------
vtkLightingUI*
vtkWidgets::GetLightingUI (void)
{
  if (this->LightingUI == (vtkLightingUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->LightingUI = vtkLightingUI::New();
      this->LightingUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->LightingUI;
}

// ----------------------------------------------------------------------------
vtkViewportUI*
vtkWidgets::GetViewportUI (void)
{
  if (this->ViewportUI == (vtkViewportUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->ViewportUI = vtkViewportUI::New();
      this->ViewportUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->ViewportUI;
}

// ----------------------------------------------------------------------------
vtkCameraUI*
vtkWidgets::GetCameraUI (void)
{
  if (this->CameraUI == (vtkCameraUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->CameraUI = vtkCameraUI::New();
      this->CameraUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->CameraUI;
}

// ----------------------------------------------------------------------------
vtkSurfacePropertiesUI*
vtkWidgets::GetSurfacePropertiesUI (void)
{
  if (this->SurfacePropertiesUI == (vtkSurfacePropertiesUI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->SurfacePropertiesUI = vtkSurfacePropertiesUI::New();
      this->SurfacePropertiesUI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->SurfacePropertiesUI;
}

// ----------------------------------------------------------------------------
vtkMatrix4x4UI*
vtkWidgets::GetMatrix4x4UI (void)
{
  if (this->Matrix4x4UI == (vtkMatrix4x4UI *) 0)
    {
    vtkRenderingContext* renderingContext;

    if ( (renderingContext = this->GetRenderingContext())
         != (vtkRenderingContext *) 0 )
      {
      this->Matrix4x4UI = vtkMatrix4x4UI::New();
      this->Matrix4x4UI->SetClientRenderingContext(renderingContext);
      }
    }

  return this->Matrix4x4UI;
}

// ----------------------------------------------------------------------------
Fl_VTK_View*
vtkWidgets::GetView(void)
{
  vtkViewUI*   viewUI;

  if ((viewUI = this->GetViewUI()) != (vtkViewUI *) 0)
    {
    return viewUI->GetView();
    }

  vtkErrorMacro(<< "Failed to get ViewUI ... NO View for you!");

  return (Fl_VTK_View *) 0;
}

// ----------------------------------------------------------------------------
vtkRenderingContext*
vtkWidgets::GetRenderingContext(void)
{
  vtkViewUI*           viewUI;

  if ((viewUI = this->GetViewUI()) != (vtkViewUI *) 0)
    {
    return viewUI->GetClientRenderingContext();
    }

  vtkErrorMacro(<< "Failed to get ViewUI ... NO Rendering Context for you!");

  return (vtkRenderingContext *) 0;
}

// ----------------------------------------------------------------------------
vtkRenderingContext*
vtkWidgets::GetCurrentRenderingContext(void)
{
  /* PLACEHOLDER */
  return (vtkRenderingContext *) 0;
}

// ----------------------------------------------------------------------------
void
vtkWidgets::PrintSelf (ostream& aTarget, vtkIndent aIndent)
{
  this->Superclass::PrintSelf(aTarget, aIndent);

  aTarget << aIndent << "ViewUI:              "
          << " (" << this->ViewUI << ")" << endl;
  if (this->ViewUI != (vtkViewUI *) 0)
    this->ViewUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "ToolBarUI:           "
          << " (" << this->ToolBarUI << ")" << endl;
  if (this->ToolBarUI != (vtkToolBarUI *) 0)
    this->ToolBarUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "NodeBrowserUI:              "
          << " (" << this->NodeBrowserUI << ")" << endl;
  if (this->NodeBrowserUI != (vtkNodeBrowserUI *) 0)
    this->NodeBrowserUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "LightingUI:          "
          << " (" << this->LightingUI << ")" << endl;
  if (this->LightingUI != (vtkLightingUI *) 0)
    this->LightingUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "ViewportUI:          "
          << " (" << this->ViewportUI << ")" << endl;
  if (this->ViewportUI != (vtkViewportUI *) 0)
    this->ViewportUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "CameraUI:            "
          << " (" << this->CameraUI << ")" << endl;
  if (this->CameraUI != (vtkCameraUI *) 0)
    this->CameraUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "SurfacePropertiesUI: "
          << " (" << this->SurfacePropertiesUI << ")" << endl;
  if (this->SurfacePropertiesUI != (vtkSurfacePropertiesUI *) 0)
    this->SurfacePropertiesUI->PrintSelf(aTarget, aIndent.GetNextIndent());

  aTarget << aIndent << "Matrix4x4UI:         "
          << " (" << this->Matrix4x4UI << ")" << endl;
  if (this->Matrix4x4UI != (vtkMatrix4x4UI *) 0)
    this->Matrix4x4UI->PrintSelf(aTarget, aIndent.GetNextIndent());
}

/* 
 * End of: $Id: vtkWidgets.cxx,v 1.1.1.1 2006/12/19 22:59:52 christianh Exp $.
 * 
 */
