/* 
 * 
 * $Id: Fl_AuthorRec.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 */
#include <cstdio> // for L_cuserid
#include <cstring> // strcmp()
#include <pwd.h> // for getpwnam_r
#include "Fl_AuthorRec.H"

static const int pad_ = 2;

Fl_AuthorRec::Fl_AuthorRec(int x, int y, int w, int h, const char* name)
  : Fl_Group(x,y,w,h,name),
    author_( x + (L_cuserid*6) + 2,
             y + pad_,
             w - (L_cuserid*6 + pad_*6 - 80),
             h - (pad_*2),
             "Unknown" ), end_(), comment_(0)
{
  char s[L_cuserid];

  if(!name && cuserid(s)) {
    this->label(s);
    name = s;
  }

  {
    setpwent();
    
    struct passwd* result;
    
    while(result = getpwent()) {
      if(strcmp(result->pw_name, name)==0) {
        this->comment_ = new char[strlen(result->pw_comment)+1];
        strncpy(this->comment_,result->pw_comment,strlen(result->pw_comment)+1);
        this->author_.label(this->comment_);
        break;
      }
    }
    
    endpwent();
  }

  this->box(FL_BORDER_BOX);
  this->color(FL_BACKGROUND2_COLOR);
  this->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  this->labelfont(FL_COURIER_BOLD);
  this->labelcolor(FL_DARK_RED);
  this->labelsize(12);
  this->author_.box(FL_UP_BOX);
  this->author_.color(FL_BACKGROUND2_COLOR);
  this->author_.align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  this->author_.labelcolor(FL_DARK_BLUE);
  this->author_.labelsize(12);
}

/* 
 * End of: $Id: Fl_AuthorRec.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
