/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: RgbFloat.cxx,v 1.1.1.1 2006/12/19 23:00:09 christianh Exp $
 * 
 */
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>

static bool s_GetNextColor(std::ifstream&, std::string&, float [3]);

int
main(int argc, char* argv[])
{
  if(argc < 2) {
    std::cerr << "Usage: " << argv[0] << " <path/rgb.txt>" << std::endl;
    return -1;
  }

  std::ifstream ifs;

  // Opens the file and positions the stream pointer at EOF ...
  ifs.open(argv[1], std::ios::in | std::ios::ate);

  if(ifs.is_open()) {
    std::string description;
    std::string name;
    std::string paletteId(argc>=3 ? argv[2] : "palette-01");
    std::string paletteDesc(argc>=4 ? argv[3] : "Palette 01");
    float color[3];
    int i = 0;

    std::cout << "  <Palette id=\"" << paletteId << "\""
              << " description=\"" << paletteDesc << "\">\n";

    // Rewind the stream ... and start reading the items.
    ifs.seekg(0, std::ios::beg);

    while(s_GetNextColor(ifs, description, color)) {
      name = description;

      for(std::string::size_type pos=0; pos<name.length(); pos++) {
        if(isspace(name[pos])) name[pos] = '-';
      }

      std::cout << "    <RGB id=\"rgb" << i << "\""
                << " name=\"" << name << "\""
                << " triplet=\""
                << color[0] << " " << color[1] << " " << color[2]
                << "\" />\n";

      i++;
    }

    std::cout << "  </Palette>\n";

  }
  ifs.close();

  return 0;
}

static bool
s_GetNextColor(std::ifstream& ifs, std::string& aName, float aColor[3])
{
  std::string line;

  do {
    if(!getline(ifs,line)) return false;
  }
  while(line[0]=='!' || line[0]=='#' || line[0]=='\n');

  std::istringstream ist(line);
  ist >> aColor[0] >> aColor[1] >> aColor[2];

  for(int j=0; j<3; j++) aColor[j] /= 255.f;

  if(!ist.good()) return false;

  ist.clear();

  char c;
  while(ist.get(c)) {
    if(!isspace(c)) {
      ist.putback(c);
      break;
    }
  }

  aName = ist.str().substr(ist.tellg(), std::streampos(EOF));
  
  return ((ifs.eof() || !ifs.good()) ? false : true);
}

/* End of: $Id: RgbFloat.cxx,v 1.1.1.1 2006/12/19 23:00:09 christianh Exp $. */
