#!/bin/csh
set com      = $0 ;
set dtd      = "${com:h}/../dtds/Sv.dtd" ;
set pattern  = "${com:h}/session_tags.sed" ;
set tags     = (`grep ELEMENT $dtd | sed -f $pattern | sort | uniq`) ;
@   nelem    = $#tags ;

# ---------------------------- session_tag_list.h -----------------------------
set list_hdr = "session_tag_enum.h" ;

if( -e $list_hdr ) rm -f $list_hdr ;
touch $list_hdr ;

printf '/* Generated file ... Do not edit. */\n'   >> $list_hdr ;
printf '#ifndef _SESSION_TAG_LIST_H_\n'            >> $list_hdr ;
printf '#  define _SESSION_TAG_LIST_H_\n\n'        >> $list_hdr ;
printf 'enum eSessionTag\n{\n  eNoneTag = 0x00,\n' >> $list_hdr ;

@ i = 1 ;

while ( $i <= $nelem )
  printf '  e%sTag,\n' $tags[$i] >> $list_hdr ;
  @ i++ ;
end

printf '  eUnknownTag\n};\n\n'              >> $list_hdr ;
printf '#endif /* _SESSION_TAG_LIST_H_ */\n' >> $list_hdr ;
printf '/* End of generated file. */\n'      >> $list_hdr ;

# ---------------------------- session_tag_pairs.h ----------------------------
set pair_hdr = "session_tag_pairs.h" ;

if( -e $pair_hdr ) rm -f $pair_hdr ;
touch $pair_hdr ;

set pairdef = 'std::pair<const std::string, const eSessionTag>' ;

echo '/* Generated file ... Do not edit. */'           >> $pair_hdr ;
echo '#ifndef _SESSION_TAG_PAIRS_H_'                   >> $pair_hdr ;
echo '#  define _SESSION_TAG_PAIRS_H_'                 >> $pair_hdr ;
echo ''                                                >> $pair_hdr ;
echo '#  include <map>'                                >> $pair_hdr ;
echo '#  include <string>'                             >> $pair_hdr ;
echo '#  include "'$list_hdr'"'                        >> $pair_hdr ;
echo ''                                                >> $pair_hdr ;
echo 'static const '$pairdef' s_session_tag_pairs[] =' >> $pair_hdr ;
echo '{'                                               >> $pair_hdr ;

@ i = 1 ;

while ( $i <= $nelem )
  echo '  '$pairdef'("'$tags[$i]'", e'$tags[$i]'Tag),' >> $pair_hdr ;
  @ i++ ;
end

echo '};'                                               >> $pair_hdr ;
echo ''                                                 >> $pair_hdr ;
echo 'static const int s_session_tag_count = '$nelem';' >> $pair_hdr ;
echo ''                                                 >> $pair_hdr ;
echo '#endif /* _SESSION_TAG_PAIRS_H_ */'               >> $pair_hdr ;
echo '/* End of generated file. */'                     >> $pair_hdr ;

exit 0 ;
