/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: session_tag_types.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 */
#include <assert.h>
#include <new>
#include "session_tag_types.h"
#include "session_tag_pairs.h"

template<class T> union _aligned_buffer_t
{
  char buf[sizeof(T)];
  struct {double a; double b;} padding;
};

long SessionTagMap::Init::s_translation_units_ = 0;

static _aligned_buffer_t<SessionTagMap> fake;
SessionTagMap& s_SessionTagMap_ = *(reinterpret_cast<SessionTagMap*>(&fake));


SessionTagMap::SessionTagMap(void) :
  _SessionTagMapBase( &(s_session_tag_pairs[0]),
                      &(s_session_tag_pairs[s_session_tag_count]) )
{
  assert(this == &s_SessionTagMap_);
}

SessionTagMap::~SessionTagMap(void)
{
  assert(this == &s_SessionTagMap_);
}

SessionTagMap&
SessionTagMap::GetInstance(void)
{
  return s_SessionTagMap_;
}

SessionTagMap::Init::Init()
{
  if(s_translation_units_++ == 0) SessionTagMap::ClassInitialize();
}

SessionTagMap::Init::~Init()
{
  if(--s_translation_units_ == 0) SessionTagMap::ClassFinalize();
}

void SessionTagMap::ClassInitialize()
{
  SessionTagMap* o = new((void*)&fake) SessionTagMap;
}

void SessionTagMap::ClassFinalize()
{
  SessionTagMap* o = reinterpret_cast<SessionTagMap*>(&s_SessionTagMap_);
  o->~SessionTagMap(); // DANGER!!! ... EXPLICIT DESTRUCTOR CALL!!!
}

/* 
 * End of: $Id: session_tag_types.cxx,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
