/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: session_tag_types.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $
 * 
 */
#ifndef _SESSION_TAG_TYPES_H_
#  define _SESSION_TAG_TYPES_H_

#  include <string>
#  include <map>
#  include "session_tag_enum.h"

typedef std::map<const std::string,const eSessionTag> _SessionTagMapBase;

class SessionTagMap : public _SessionTagMapBase
{
public:
  static SessionTagMap& GetInstance(void);

protected:
  SessionTagMap(void);
  ~SessionTagMap(void);

  static void ClassInitialize(void);
  static void ClassFinalize(void);

public:
  class Init
  {
  public:
    Init(void);
    ~Init(void);
  private:
    static long s_translation_units_;
    friend class SessionTagMap;
  };

  friend class Init;

private:
  SessionTagMap(const SessionTagMap&);
  /* void operator=(const SessionTagMap&); */
};

#  ifndef _SESSION_TAG_MAP_INITIALIZED_
#    define _SESSION_TAG_MAP_INITIALIZED_
static SessionTagMap::Init _SessionTagMap_singleton_init;
#  endif /* _SESSION_TAG_MAP_INITIALIZED_ */

#endif /* _SESSION_TAG_TYPES_H_ */
/* 
 * End of $Id: session_tag_types.h,v 1.1.1.1 2006/12/19 23:00:07 christianh Exp $.
 * 
 */
