/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkPaletteParser.h,v 1.1.1.1 2006/12/19 23:00:08 christianh Exp $
 * 
 * Copyright (c) 2003 Sean McInerney 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 *  * Neither the name of Sean McInerney nor the names of any contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 *  * Modified source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef VTK_PALETTE_PARSER_H_
#  define VTK_PALETTE_PARSER_H_
// vtkExtensions
#  include "vtkExpatBase.h"

/** \class   vtkPaletteParser
 *  \brief   Palette parser concrete vtkExpatBase subclass.
 * 
 * \author  Sean McInerney
 * \version $Revision: 1.1.1.1 $
 * \date    $Date: 2006/12/19 23:00:08 $
 * 
 * \sa
 * vtkExpatBase
 */

class vtkPaletteParser : public vtkExpatBase
{
public:
  static vtkPaletteParser* New(void);
  vtkTypeRevisionMacro(vtkPaletteParser,vtkExpatBase);
  void PrintSelf(std::ostream&, vtkIndent);

  /** Set the handlers used by expat callbacks. */
  virtual void ResetHandlers(void);

  /** Handler for element declarations in a \c DTD. */
  virtual void ElementDecl(const XML_Char* aName, XML_Content* aModel);

  /** Handler for attlist declarations in the \c DTD. */
  virtual void AttlistDecl(const XML_Char* aElname,
                           const XML_Char* aAttname,
                           const XML_Char* aAttType,
                           const XML_Char* aDefault,
                           int             aIsRequired);

  /** Handles XML decls. and text decls discovered in external entities. */
  virtual void XmlDecl(const XML_Char* aVersion,
                       const XML_Char* aEncoding,
                       int             aStandalone);

  /** Handler that will be called for all entity declarations. */
  virtual void EntityDecl(const XML_Char* aEntityName,
                          int             aIsParameterEntity,
                          const XML_Char* aValue,
                          int             aValueLength,
                          const XML_Char* aBase,
                          const XML_Char* aSystemId,
                          const XML_Char* aPublicId,
                          const XML_Char* aNotationName);

  /** Handler for start (and empty) tags. */
  virtual void StartElement(const XML_Char* aName, const XML_Char** aAttrs);

  /** Handler for end (and empty) tags. */
  virtual void EndElement(const XML_Char* aName);

  /** Text handler. */
  virtual void CharacterData(const XML_Char* aData, int aLen);

  /** Handler for processing instructions. */
  virtual void ProcessingInstruction(const XML_Char* aTarget,
                                     const XML_Char* aData);

  /** Handler for comments. */
  virtual void Comment(const XML_Char* aData);

  /** Handler that gets called at the beginning of a \c CDATA section. */
  virtual void StartCdataSection(void);

  /** Handler that gets called at the end of a \c CDATA section. */
  virtual void EndCdataSection(void);

  /** Handles any characters in the document not otherwise handled. */
  virtual void Default(const XML_Char* aData, int aLen);

  /** Handler called at start of a \c DOCTYPE declaration. */
  virtual void StartDoctypeDecl(const XML_Char* aDoctypeName,
                                const XML_Char* aSysid,
                                const XML_Char* aPubid,
                                int             aHasInternalSubset);

  /** Handler called at the end of a \c DOCTYPE declaration. */
  virtual void EndDoctypeDecl(void);

  /** Handler that receives notation declarations. */
  virtual void NotationDecl(const XML_Char* aNotationName,
                            const XML_Char* aBase,
                            const XML_Char* aSystemId,
                            const XML_Char* aPublicId);

  /** Handler to be called when a namespace is declared. */
  virtual void StartNamespaceDecl(const XML_Char* aPrefix,
                                  const XML_Char* aURI);

  /** Handler to be called when leaving the scope of a namespace declaration. */
  virtual void EndNamespaceDecl(const XML_Char* aPrefix);

  /** Handler that is called if the document is not "standalone". */
  virtual int  NotStandalone(void);

  /** Set an external entity reference handler. */
  virtual int  ExternalEntityRef(const XML_Char* aContext,
                                 const XML_Char* aBase,
                                 const XML_Char* aSystemId,
                                 const XML_Char* aPublicId);

  /** Skipped entity handler. */
  virtual void SkippedEntity(const XML_Char* aEntityName,
                             int aIsParameterEntity);

  /** Set a handler to deal with encodings other than the built in set. */
  virtual int  UnknownEncoding(const XML_Char* aName, XML_Encoding* aInfo);

protected:
  vtkPaletteParser(bool aCreateParser = true);
  virtual ~vtkPaletteParser(void);

private:
  vtkPaletteParser(const vtkPaletteParser&);  // Not implemented.
  void operator=(const vtkPaletteParser&);  // Not implemented.
};

#endif /* VTK_PALETTE_PARSER_H_ */
/*
 * End of: $Id: vtkPaletteParser.h,v 1.1.1.1 2006/12/19 23:00:08 christianh Exp $.
 * 
 */
