/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * 
 * $Id: vtkSessionImporter.h,v 1.1.1.1 2006/12/19 23:00:09 christianh Exp $
 * 
 */
#ifndef _VTK_SESSION_IMPORTER_H_
#  define _VTK_SESSION_IMPORTER_H_

// STL
#  include <string>
#  include <map>
#  include <stack>
// VTK Rendering + expat
#  include "vtkExpatBase.h"
// SV XML
#  include "session_tag_types.h"
#  include "session_header_types.h"
#  include "indent_stream.h"

class vtkProp;
class vtkPropAssembly;
class vtkAssembly;
class vtkProperty;
class vtkActor;
class vtkVolume;
class vtkCamera;
class vtkRenderer;
class vtkRenderingContext;

/** \class   vtkSessionImporter
 *  \brief   XML visualization session importer.
 * 
 * vtkSessionBase is an importer object that reads an XML file or
 * string containing the saved state of a visualization.
 * 
 * \author  Sean McInerney
 * \version $Version$
 * \date    $Date: 2006/12/19 23:00:09 $
 * 
 * \sa
 * vtkExpatBase
 */
class vtkSessionImporter : public vtkExpatBase
{
public:
  static vtkSessionImporter* New(void);
  vtkTypeMacro(vtkSessionImporter,vtkExpatBase);
  void PrintSelf(ostream& os, vtkIndent indent);

  enum eSessionSection
  {
    eNoneSection = 0x0,
    eHeaderSection,
    eInputSourceCollectionSection,
    eRenderingContextSection,
  };

  typedef std::stack<vtkAssembly*> AssemblyStack;
  typedef std::stack<vtkPropAssembly*> PropAssemblyStack;

  /** Start element handler override. */
  virtual void StartElement(const XML_Char* name, const XML_Char** attrs);

  /** End element handler override. */
  virtual void EndElement(const XML_Char* name);

  /** Text handler override. */
  virtual void CharacterData(const XML_Char* name, int length);

  /** Get copy of the header meta data (user responsible for deallocation). */
  HeaderRec* GetHeaderCopy(void);

protected:
  vtkSessionImporter(void);
  ~vtkSessionImporter(void);

  void HeaderHandler(const XML_Char* name, const XML_Char** attrs);
  void SourceCollectionHandler(const XML_Char* name, const XML_Char** attrs);
  void RenderingContextHandler(const XML_Char* name, const XML_Char** attrs);
  void RendererHandler(const XML_Char*  name, const XML_Char** attrs);
  void CameraHandler(const XML_Char* name, const XML_Char** attrs);
  void PropertyHandler(const XML_Char* name, const XML_Char** attrs);
  void PropHandler(const XML_Char* name, const XML_Char** attrs);
  void ActorHandler(const XML_Char* name, const XML_Char** attrs);
  void VolumeHandler(const XML_Char* name, const XML_Char** attrs);
  void FilterHandler(const XML_Char* name, const XML_Char** attrs);

  /** The current indentation level (not really needed in an Importer). */
  indent_stream Indent;

  SessionTagMap& TagMap;

  /** The currently handled top level section. */
  eSessionSection CurrentSection;

  /** Record of the header meta data. */
  HeaderRec* Header;

  /** Id to object association. */
  std::map<std::string,vtkObject*> IdMap;

  /** Stack of open elements. */
  std::stack<eSessionTag>      OpenElements;
  std::stack<vtkAssembly*>     OpenAssemblies;
  std::stack<vtkPropAssembly*> OpenPropAssemblies;

  /** Pointers to the currently handled element(s). */
  vtkRenderingContext*         pCurrentRenderingContext;
  vtkRenderer*                 pCurrentRenderer;
  vtkCamera*                   pCurrentCamera;
  vtkProp*                     pCurrentProp;
  vtkActor*                    pCurrentActor;
  vtkVolume*                   pCurrentVolume;
  vtkProperty*                 pCurrentProperty;
  
private:
  vtkSessionImporter(const vtkSessionImporter&);  // Not implemented.
  void operator=(const vtkSessionImporter&);  // Not implemented.
};

#endif /* _VTK_SESSION_IMPORTER_H_ */
/* 
 * End of: $Id: vtkSessionImporter.h,v 1.1.1.1 2006/12/19 23:00:09 christianh Exp $.
 * 
 */
