function [YOut,Trans_out] = Optimal_Number_of_Pcs2(Y)


len =length(Y);
st(1) = 1;

for i = 1:len
    ed(i)   = size(Y{i},1) + st(i) - 1;
    st(i+1) = ed(i)+1;
end
Tsgg = cell2mat(Y');

for sub = 1:len

    Ts0 = Y{sub};
    Ts0(isnan(Ts0)) = 0;

    Tsg = Tsgg([1:st(sub)-1 ed(sub)+1:ed(end)],:);
    Tsg(isnan(Tsg)) = 0;

    [time_points0,num_voxels] = size(Ts0);
    [time_points1,num_voxels] = size(Tsg);

    [rTs,Trans] = reduce_dimension(Ts0,size(Ts0,1));
    rTs0 = rTs - repmat(mean(rTs,2),1,num_voxels);
    rTs0 = rTs0 ./ repmat(sqrt(sum(rTs0.^2,2)),1,num_voxels);

    [rTsg] = reduce_dimension(Tsg,size(Tsg,1));
    rTsg = rTsg - repmat(mean(rTsg,2),1,num_voxels);
    rTsg = rTsg ./ repmat(sqrt(sum(rTsg.^2,2)),1,num_voxels);

    C = abs(rTs0*rTsg');
    for i = 1:size(rTs0,1)
        [ii,jj] = find(C == max(C(:)));
        r(ii,1)  = C(ii,jj);
        C(ii,:)  = -inf;
        C(:,jj)  = -inf;
    end

    h = norminv(1-0.01/size(rTs0,1),0,1/sqrt(num_voxels/27-3));
       
    ind       = (r>=h);
    YOut{sub} = rTs(ind,:);
    
    Trans_out{sub} = Trans(:,ind);

end
Debug = 1;
end
function [rTs,Trans] = reduce_dimension(Ts,q)
[p,n]=size(Ts);

C = cov(Ts');
[U,S,V] = svd(Ts,'econ');
dd = diag(S);
[dds,index] = sort(dd,'descend');
if fix(q)==q
    ind   = index(1:q);
    
else
    pp    = cumsum(dds)/sum(dds);
    ind_temp   = find(pp>q);
    ind = index(1:ind_temp(1)-1);
end
S2    = S(ind,ind);
Trans = U(:,ind)*inv(S2);
rTs   = V(:,ind)';
end

