%     This file is part of gCCA-NPAIRS.
% 
%     gCCA-NPAIRS is free software: you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 3 of the License, or
%     (at your option) any later version.
% 
%     gCCA is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
% 
%     You should have received a copy of the GNU General Public License
%     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.


function [Aout,Zm_out] = sort_eigenimages_withfulldata(A_full,Zm_full,A_in,Zm_in,subnum)

[numpcs_full,numvoxels] = size(Zm_full);
[numpcs_half,numvoxels] = size(Zm_in);

numpcs = min(numpcs_full,numpcs_half);

dim     = 0;
At_full = [];
for i   = 1:length(A_in)
    dim = max([size(A_in{i},1) dim]);
    At_full = [At_full;A_full{subnum(i)}];
end

At = cell2mat(A_in');

[inOctave] = in_octave();
if inOctave
    for i = 1:numpcs
        for j = 1:numpcs
            Temp = corr(Zm_full(i,:),Zm_in(j,:));
            r_temp(i,j) = abs(Temp);
            rep_sign(i,j) = Temp;
        end
    end
else
    for i = 1:numpcs
        for j = 1:numpcs
            Temp   = corrcoef(Zm_full(i,:),Zm_in(j,:));
            Temp_t = corrcoef(At_full(:,i),At(:,j));
            r_temp(i,j) = abs(Temp(1,2));
            rep_sign(i,j)   = Temp(1,2);
            rep_sign_t(i,j) = Temp_t(1,2);
        end
    end
end

clear i j

for i = 1:numpcs
    [iii,jjj] = find(r_temp == max(r_temp(:)));

    Zm_out(iii,:) = Zm_in(jjj,:);
    At_out(:,iii) = At(:,jjj);
    r_temp(iii,:) = -1;
    r_temp(:,jjj) = -1;

    a1(i) = iii;
    b1(i) = jjj;
    if sign(rep_sign(iii,jjj))~=sign(rep_sign_t(iii,jjj))
        Debug = 1;
    end
        
    if rep_sign(iii,jjj)<0
        Zm_out(iii,:) = -Zm_out(iii,:);
        At_out(:,iii) = -At_out(:,iii);
    end

end

clear i j 
subcount = 0;

ind_s = 1;
for i = subnum
    subcount = subcount + 1;
    dyn_dim = size(A_in{subcount},1);
    ind_ed  = ind_s + dyn_dim - 1;
    Aout(i,1:dyn_dim,:) = At_out(ind_s:ind_ed,:);
    ind_s = ind_ed + 1;
end


% for i = subnum
%     subcount = subcount + 1;
%     for j = 1:numpcs
%         dyn_dim = length(A_in{subcount}(:,b1(j)));
%         Aout(i,1:dyn_dim,j) = A_in{subcount}(1:dyn_dim,b1(j));
%         if rep_sign(a1(j),b1(j))<0
%             Aout(i,1:dyn_dim,j) = -Aout(i,1:dyn_dim,j);
%         end
%     end
% end

function [inOctave] = in_octave()
try
    OCTAVE_VERSION;
    inOctave = 1;
catch
    inOctave = 0;
end
