/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MetaDataDisplay
extends JTable {
    static final int TEXT_PADDING = 4;
    GeneralFileSystem fileSystem;
    private GeneralFile[] queryObj;
    private MetaDataRecordList[] rl;
    private MetaDataTable table;
    boolean keyValue = true;
    static int fontPixelHeight = -1;
    static Font font;
    static FontMetrics fontMetrics;

    void setKeyValue(boolean bl) {
        this.keyValue = bl;
    }

    boolean getKeyValue() {
        return this.keyValue;
    }

    public MetaDataDisplay(MetaDataRecordList metaDataRecordList) {
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = metaDataRecordList;
        this.initComponents();
    }

    public MetaDataDisplay(MetaDataRecordList[] metaDataRecordListArray) {
        this.rl = metaDataRecordListArray;
        this.initComponents();
    }

    public MetaDataDisplay(GeneralFile generalFile, MetaDataRecordList metaDataRecordList) {
        this.queryObj = new GeneralFile[1];
        this.queryObj[0] = generalFile;
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = metaDataRecordList;
        this.initComponents();
    }

    public MetaDataDisplay(GeneralFileSystem generalFileSystem, MetaDataRecordList[] metaDataRecordListArray) {
        this.fileSystem = generalFileSystem;
        this.rl = metaDataRecordListArray;
        this.queryObj = new GeneralFile[this.rl.length];
        this.initComponents();
    }

    MetaDataDisplay(MetaDataTable metaDataTable) {
        this.table = metaDataTable;
        this.initComponents();
    }

    private void initComponents() {
        if (this.rl != null) {
            String string = null;
            String string2 = null;
            Object object = null;
            this.createResultsTable(this.rl);
            if (this.fileSystem != null) {
                for (int i = 0; i < this.rl.length; ++i) {
                    object = this.rl[i].getValue("file name");
                    if (object == null) continue;
                    string = object.toString();
                    object = this.rl[i].getValue("directory name");
                    if (object == null) continue;
                    string2 = object.toString();
                    this.queryObj[i] = FileFactory.newFile(this.fileSystem, string2, string);
                }
            }
        } else if (this.table != null) {
            MetaDataDisplay.createMetaDataTable(this.table);
        }
    }

    public MetaDataRecordList[] getRecordLists() {
        return this.rl;
    }

    static int adjustColumnSizes(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        int n = jTable.getColumnCount();
        Component component = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < n; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            if (fontMetrics == null) {
                font = component.getFont();
                if (font == null) {
                    font = new Font("SansSerif", 0, 12);
                    component.setFont(font);
                }
                fontMetrics = component.getFontMetrics(font);
            }
            n2 = component.getPreferredSize().width + 4;
            int n5 = 0;
            int n6 = jTable.getRowCount();
            for (int j = 0; j < n6; ++j) {
                Object object = jTable.getValueAt(j, i);
                n5 = n3;
                if (object == null) {
                    n3 = 1;
                } else if (object instanceof String) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Integer) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Long) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Float) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Date) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof JTable) {
                    n3 = MetaDataDisplay.adjustColumnSizes((JTable)object);
                }
                n3 = Math.max(n3, n5);
            }
            n3 = Math.max(n2, n3);
            tableColumn.setPreferredWidth(n3);
            n4 += n3;
            n3 = 0;
        }
        return n4;
    }

    private static int getCellWidth(String string) {
        int n = fontMetrics.stringWidth(string);
        if (fontPixelHeight <= 0) {
            fontPixelHeight = fontMetrics.getHeight();
        }
        return n + 4;
    }

    private void createResultsTable(MetaDataRecordList[] metaDataRecordListArray) {
        Object object;
        int n;
        if (metaDataRecordListArray == null) {
            return;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = metaDataRecordListArray[0].getFieldCount();
        int n4 = metaDataRecordListArray.length;
        String[] stringArray = new String[n3];
        Object[][] objectArray = new Object[n4][n3];
        int n5 = 0;
        block6: for (n = 0; n < n3; ++n) {
            switch (metaDataRecordListArray[0].getFieldType(n)) {
                case 14: {
                    if (this.keyValue) {
                        MetaDataTable metaDataTable = metaDataRecordListArray[0].getTableValue(n);
                        object = new String[(n5 += n3 + metaDataTable.getRowCount()) - 1];
                        System.arraycopy(stringArray, 0, object, 0, n3);
                        for (int i = n3; i < n5; ++i) {
                            object[i - 1] = metaDataTable.getStringValue(i - n3, 0);
                        }
                        stringArray = object;
                        continue block6;
                    }
                    stringArray[n] = metaDataRecordListArray[0].getFieldName(n);
                    continue block6;
                }
                default: {
                    stringArray[n] = metaDataRecordListArray[0].getFieldName(n);
                }
            }
        }
        for (n = 0; n < n4; ++n) {
            block9: for (int i = 0; i < n3; ++i) {
                if (metaDataRecordListArray[n].getFieldCount() <= i) continue;
                switch (metaDataRecordListArray[n].getFieldType(i)) {
                    case 14: {
                        if (this.keyValue) {
                            object = metaDataRecordListArray[n].getTableValue(i);
                            Object[] objectArray2 = new Object[n5];
                            System.arraycopy(objectArray[n], 0, objectArray2, 0, n3);
                            for (int j = n3; j < n5; ++j) {
                                objectArray2[j - 1] = ((MetaDataTable)object).getStringValue(j - n3, 1);
                            }
                            objectArray[n] = objectArray2;
                            continue block9;
                        }
                        objectArray[n][i] = MetaDataDisplay.createMetaDataTable(metaDataRecordListArray[n].getTableValue(i));
                        n2 += metaDataRecordListArray[n].getTableValue(i).getRowCount();
                        continue block9;
                    }
                    default: {
                        objectArray[n][i] = metaDataRecordListArray[n].getStringValue(i);
                    }
                }
            }
        }
        MetaDataTableModel metaDataTableModel = new MetaDataTableModel(objectArray, stringArray);
        this.setModel(metaDataTableModel);
        if (!this.keyValue) {
            this.setDefaultRenderer(JTable.class, new MetaDataTableCellRenderer(this.getDefaultRenderer(JTable.class)));
        }
        this.setDefaultRenderer(String.class, new MetaDataTableCellRenderer(this.getDefaultRenderer(String.class)));
        if (this.queryObj != null) {
            if (!this.keyValue) {
                this.setDefaultEditor(JTable.class, new MetaDataTableCellEditor(metaDataTableModel, this.getDefaultEditor(JTable.class)));
            }
            this.setDefaultEditor(String.class, new MetaDataTableCellEditor(metaDataTableModel, this.getDefaultEditor(String.class)));
        }
        if (n2 > 1) {
            int n6 = MetaDataDisplay.adjustColumnSizes(this);
            int n7 = (objectArray.length + 1 + (n2 -= 2)) * fontPixelHeight;
            this.setPreferredScrollableViewportSize(new Dimension(n6, n7 * 2));
            this.setRowHeight(n7);
        } else {
            int n8 = MetaDataDisplay.adjustColumnSizes(this);
            int n9 = fontPixelHeight;
            this.setPreferredScrollableViewportSize(new Dimension(n8, n9));
            this.setRowHeight(n9);
        }
    }

    static JTable createMetaDataTable(MetaDataTable metaDataTable) {
        int n;
        int n2 = metaDataTable.getRowCount();
        int n3 = metaDataTable.getColumnCount();
        Object[][] objectArray = new Object[n2][n3];
        String string = null;
        Object[][] objectArray2 = null;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                string = metaDataTable.getStringValue(n, i);
                if (string != null && !string.equals("")) {
                    objectArray[n][n4] = string;
                    ++n4;
                    continue;
                }
                objectArray[n][n4] = "";
            }
            n5 = Math.max(n4, n5);
            n4 = 0;
        }
        objectArray2 = new Object[n2][n5];
        for (n = 0; n < n2; ++n) {
            System.arraycopy(objectArray[n], 0, objectArray2[n], 0, n5);
        }
        JTable jTable = new JTable(objectArray2, objectArray2[0]);
        Font font = jTable.getFont();
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
            jTable.setFont(font);
        }
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        int n6 = 0;
        int n7 = (n2 + 1) * fontMetrics.getHeight();
        jTable.setPreferredScrollableViewportSize(new Dimension(n6, n7 * 2));
        jTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                TableModel tableModel = (TableModel)tableModelEvent.getSource();
                String string = tableModel.getColumnName(n2);
                Object object = tableModel.getValueAt(n, n2);
            }
        });
        return jTable;
    }

    class MetaDataTableModel
    extends AbstractTableModel {
        Object[][] data;
        private String[] names;

        MetaDataTableModel(Object[][] objectArray, String[] stringArray) {
            this.data = objectArray;
            this.names = stringArray;
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.names.length;
        }

        public Object getValueAt(int n, int n2) {
            while (n2 >= this.data[n].length) {
                --n2;
            }
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            while (n >= this.data[0].length) {
                --n;
            }
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < this.data.length && n2 < this.data[n].length) {
                this.data[n][n2] = object;
            }
        }
    }

    class MetaDataTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer __defaultRenderer;
        private TableCellEditor defaultEditor;

        public MetaDataTableCellRenderer(TableCellRenderer tableCellRenderer) {
            this.__defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof JComponent) {
                return (JComponent)object;
            }
            return this.__defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class MetaDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private TableCellEditor defaultEditor;
        Object component;
        String originalValue;
        int currentRow = -1;
        int currentColumn = -1;

        public MetaDataTableCellEditor(final TableModel tableModel, TableCellEditor tableCellEditor) {
            this.defaultEditor = tableCellEditor;
            this.addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent changeEvent) {
                }

                public void editingStopped(ChangeEvent changeEvent) {
                    MetaDataRecordList[] metaDataRecordListArray = new MetaDataRecordList[1];
                    try {
                        if (MetaDataTableCellEditor.this.getCellEditorValue() instanceof JTable) {
                            JTable jTable = (JTable)MetaDataTableCellEditor.this.getCellEditorValue();
                            int n = jTable.getRowCount();
                            int n2 = jTable.getColumnCount();
                            String[][] stringArray = new String[n][n2];
                            int[] nArray = new int[n];
                            Object object = null;
                            for (int i = 0; i < n; ++i) {
                                for (int j = 0; j < n2; ++j) {
                                    object = jTable.getValueAt(i, j);
                                    if (object == null) continue;
                                    stringArray[i][j] = object.toString();
                                }
                                nArray[i] = 0;
                            }
                            MetaDataTable metaDataTable = new MetaDataTable(nArray, stringArray);
                            metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].getField(MetaDataTableCellEditor.this.currentColumn), metaDataTable);
                            if (MetaDataDisplay.this.queryObj[MetaDataTableCellEditor.this.currentRow] != null) {
                                MetaDataDisplay.this.queryObj[MetaDataTableCellEditor.this.currentRow].modifyMetaData(metaDataRecordListArray[0]);
                            }
                        } else if (MetaDataTableCellEditor.this.getCellEditorValue() instanceof JTextField) {
                            JTextField jTextField = (JTextField)MetaDataTableCellEditor.this.getCellEditorValue();
                            String string = jTextField.getText();
                            if (!string.equals(MetaDataTableCellEditor.this.originalValue)) {
                                Object object = MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].getValue(MetaDataTableCellEditor.this.currentColumn);
                                if (object instanceof MetaDataTable) {
                                    MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].setValue(MetaDataTableCellEditor.this.currentColumn, (MetaDataTable)object);
                                    metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].getField(MetaDataTableCellEditor.this.currentColumn), (MetaDataTable)object);
                                } else {
                                    MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].setValue(MetaDataTableCellEditor.this.currentColumn, string);
                                    metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.this.rl[MetaDataTableCellEditor.this.currentRow].getField(MetaDataTableCellEditor.this.currentColumn), string);
                                }
                                tableModel.setValueAt(object, MetaDataTableCellEditor.this.currentRow, MetaDataTableCellEditor.this.currentColumn);
                                if (MetaDataDisplay.this.queryObj[MetaDataTableCellEditor.this.currentRow] != null) {
                                    MetaDataDisplay.this.queryObj[MetaDataTableCellEditor.this.currentRow].modifyMetaData(metaDataRecordListArray[0]);
                                }
                            }
                        } else if (MetaDataTableCellEditor.this.getCellEditorValue() instanceof String) {
                            System.out.println("getCellEditorValue- String " + MetaDataTableCellEditor.this.getCellEditorValue());
                        }
                    }
                    catch (SRBException sRBException) {
                        sRBException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.defaultEditor != null) {
                this.defaultEditor = null;
            }
            if (this.component != null) {
                this.component = null;
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component = object;
            this.currentRow = n;
            this.currentColumn = n2;
            if (object instanceof String) {
                this.component = new JTextField((String)object);
                this.originalValue = (String)object;
            } else {
                this.component = this.defaultEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            return (Component)this.component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public Object getCellEditorValue() {
            return this.component;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            super.addCellEditorListener(cellEditorListener);
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return super.isCellEditable(eventObject);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            super.removeCellEditorListener(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return super.shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }
}

