/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Tupledata;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class TupledataDAO
implements clinical.server.dao.TupledataDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, Tupledata bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_TUPLEDATA ");
            buf.append(" (TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,EXTENDEDTUPLEID,COLUMNNAME,COLUMNTYPE,STOREDTUPLEID,TEXTVALUE,COMMENTS) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 11; ++i) {
                buf.append('?');
                if (i >= 10) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getTableid(), 2);
            ps.setObject(2, bean.getUniqueid(), 2);
            ps.setObject(3, bean.getOwner(), 2);
            ps.setTimestamp(4, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(5, bean.getModuser(), 2);
            ps.setObject(6, bean.getExtendedtupleid(), 2);
            ps.setObject(7, bean.getColumnname(), 12);
            ps.setObject(8, bean.getColumntype(), 12);
            ps.setObject(9, bean.getStoredtupleid(), 2);
            ps.setObject(10, bean.getTextvalue(), 12);
            ps.setObject(11, OracleUtils.getCLOB(con, bean.getComments()), 2005);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(Tupledata bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("TABLEID");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("EXTENDEDTUPLEID");
        buf.append(',');
        buf.append("COLUMNNAME");
        buf.append(',');
        buf.append("COLUMNTYPE");
        buf.append(',');
        buf.append("STOREDTUPLEID");
        buf.append(',');
        buf.append("TEXTVALUE");
        buf.append(',');
        buf.append("COMMENTS");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Tupledata bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getExtendedtupleid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXTENDEDTUPLEID=?");
            qi.values.add(bean.getExtendedtupleid());
            valueSet = true;
        }
        if (bean.getColumnname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COLUMNNAME=?");
            qi.values.add(bean.getColumnname());
            valueSet = true;
        }
        if (bean.getColumntype() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COLUMNTYPE=?");
            qi.values.add(bean.getColumntype());
            valueSet = true;
        }
        if (bean.getStoredtupleid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("STOREDTUPLEID=?");
            qi.values.add(bean.getStoredtupleid());
            valueSet = true;
        }
        if (bean.getTextvalue() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TEXTVALUE=?");
            qi.values.add(bean.getTextvalue());
            valueSet = true;
        }
        if (bean.getComments() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COMMENTS=?");
            qi.values.add(bean.getComments());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Tupledata bean, Tupledata criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_TUPLEDATA SET ");
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getExtendedtupleid() != null || bean.isNull("extendedtupleid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXTENDEDTUPLEID=? ");
            uqi.setValues.add(bean.getExtendedtupleid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("extendedtupleid"), uqi);
            valueSet = true;
        }
        if (bean.getColumnname() != null || bean.isNull("columnname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COLUMNNAME=? ");
            uqi.setValues.add(bean.getColumnname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("columnname"), uqi);
            valueSet = true;
        }
        if (bean.getColumntype() != null || bean.isNull("columntype")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COLUMNTYPE=? ");
            uqi.setValues.add(bean.getColumntype());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("columntype"), uqi);
            valueSet = true;
        }
        if (bean.getStoredtupleid() != null || bean.isNull("storedtupleid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("STOREDTUPLEID=? ");
            uqi.setValues.add(bean.getStoredtupleid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("storedtupleid"), uqi);
            valueSet = true;
        }
        if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TEXTVALUE=? ");
            uqi.setValues.add(bean.getTextvalue());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("textvalue"), uqi);
            valueSet = true;
        }
        if (bean.getComments() != null || bean.isNull("comments")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COMMENTS=? ");
            uqi.setValues.add(bean.getComments());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("comments"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Tupledata createObject(ResultSet rs) throws SQLException {
        Tupledata obj = new Tupledata();
        obj.setTableid((BigDecimal)rs.getObject(1));
        obj.setUniqueid((BigDecimal)rs.getObject(2));
        obj.setOwner((BigDecimal)rs.getObject(3));
        if (rs.getTimestamp(4) != null) {
            obj.setModtime(new Date(rs.getTimestamp(4).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(5));
        obj.setExtendedtupleid((BigDecimal)rs.getObject(6));
        obj.setColumnname((String)rs.getObject(7));
        obj.setColumntype((String)rs.getObject(8));
        obj.setStoredtupleid((BigDecimal)rs.getObject(9));
        obj.setTextvalue((String)rs.getObject(10));
        obj.setComments(OracleUtils.readCLOB((CLOB)rs.getObject(11)));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tupledata> find(Connection con, Tupledata criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Tupledata> results = new LinkedList<Tupledata>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_TUPLEDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Tupledata item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, Tupledata bean, Tupledata criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, Tupledata criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_TUPLEDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

