/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class BaseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected Throwable rootCause;
    private Object[] messageArgs;
    private String messageKey;
    private List<BaseException> exceptions;

    public BaseException() {
    }

    public BaseException(String msg) {
        super(msg);
    }

    public BaseException(String msg, String msgKey) {
        super(msg);
        this.messageKey = msgKey;
    }

    public BaseException(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    public BaseException(String message, Throwable rootCause) {
        super(message);
        this.rootCause = rootCause;
    }

    public void addException(BaseException be) {
        if (this.exceptions == null) {
            this.exceptions = new LinkedList<BaseException>();
        }
        this.exceptions.add(be);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.rootCause != null) {
            this.rootCause.printStackTrace(out);
        }
        out.flush();
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.rootCause != null) {
            this.rootCause.printStackTrace(writer);
        }
        writer.flush();
    }

    public void setRootCause(Throwable newRootCause) {
        this.rootCause = newRootCause;
    }

    public void setMessageKey(String newMessageKey) {
        this.messageKey = newMessageKey;
    }

    public void setMessageArgs(Object[] args) {
        this.messageArgs = args;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getMessageKey() {
        if (this.messageKey == null) {
            this.messageKey = "errors.common";
        }
        return this.messageKey;
    }

    public List<BaseException> getExceptions() {
        return this.exceptions;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }
}

