/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.pseudoserver.UnknownMethodException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

class HttpRequest {
    private static final int CR = 13;
    private static final int LF = 10;
    private Reader _reader;
    private String _protocol;
    private String _command;
    private String _uri;
    private Hashtable _headers = new Hashtable();
    private Hashtable _parameters;
    private byte[] _requestBody;

    HttpRequest(InputStream inputStream) throws IOException {
        StringTokenizer st = new StringTokenizer(this.readHeaderLine(inputStream));
        this._command = st.nextToken();
        this._uri = st.nextToken();
        this._protocol = st.nextToken();
        if (!(this._command.equals("GET") || this._command.equals("POST") || this._command.equals("PUT"))) {
            throw new UnknownMethodException(this._command);
        }
        this.readHeaders(inputStream);
        this.readContent(inputStream);
    }

    Reader getReader() {
        return this._reader;
    }

    String getCommand() {
        return this._command;
    }

    String getURI() {
        return this._uri;
    }

    String getProtocol() {
        return this._protocol;
    }

    String getHeader(String name) {
        return (String)this._headers.get(name.toUpperCase());
    }

    byte[] getBody() {
        return this._requestBody;
    }

    String[] getParameter(String name) {
        if (this._parameters == null) {
            this._parameters = this.readParameters(new String(this._requestBody));
        }
        return (String[])this._parameters.get(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("HttpRequest[ ");
        sb.append(this._command).append(' ').append(this._uri).append(' ').append(this._protocol).append("\n");
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            sb.append("      ").append(key).append(": ").append(this._headers.get(key)).append("\n");
        }
        sb.append("   body contains ").append(this.getBody().length).append(" byte(s) ]");
        return sb.toString();
    }

    private void readContent(InputStream inputStream) throws IOException {
        this._requestBody = new byte[this.getContentLength()];
        inputStream.read(this._requestBody);
        this._reader = new InputStreamReader(new ByteArrayInputStream(this._requestBody));
    }

    private int getContentLength() {
        try {
            return Integer.parseInt(this.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readHeaders(InputStream inputStream) throws IOException {
        String lastHeader = null;
        String header = this.readHeaderLine(inputStream);
        while (header.length() > 0) {
            if (header.charAt(0) <= ' ') {
                if (lastHeader == null) continue;
                this._headers.put(lastHeader, this._headers.get(lastHeader) + header.trim());
            } else {
                lastHeader = header.substring(0, header.indexOf(58)).toUpperCase();
                this._headers.put(lastHeader, header.substring(header.indexOf(58) + 1).trim());
            }
            header = this.readHeaderLine(inputStream);
        }
    }

    private String readHeaderLine(InputStream inputStream) throws IOException {
        StringBuffer sb = new StringBuffer();
        int b = inputStream.read();
        while (b != 13) {
            sb.append((char)b);
            b = inputStream.read();
        }
        b = inputStream.read();
        if (b != 10) {
            throw new IOException("Bad header line termination: " + b);
        }
        return sb.toString();
    }

    private Hashtable readParameters(String content) {
        Hashtable parameters = new Hashtable();
        if (content == null || content.trim().length() == 0) {
            return parameters;
        }
        StringTokenizer st = new StringTokenizer(content, "&=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            this.addParameter(parameters, HttpUnitUtils.decode(name), HttpUnitUtils.decode(st.nextToken()));
        }
        return parameters;
    }

    private void addParameter(Hashtable parameters, String name, String value) {
        String[] oldValues = (String[])parameters.get(name);
        if (oldValues == null) {
            parameters.put(name, new String[]{value});
        } else {
            String[] values = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[oldValues.length] = value;
            parameters.put(name, values);
        }
    }

    boolean wantsKeepAlive() {
        if ("Keep-alive".equalsIgnoreCase(this.getConnectionHeader())) {
            return true;
        }
        if (this._protocol.equals("HTTP/1.1")) {
            return !"Close".equalsIgnoreCase(this.getConnectionHeader());
        }
        return false;
    }

    private String getConnectionHeader() {
        return this.getHeader("Connection");
    }
}

