/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class TransferStatusPanel
extends JPanel
implements Runnable {
    private static final String SYMBOL_PERCENTAGE = "/";
    private static final String SYMBOL_DIVIDE = "\\";
    private static final int FILENAME_WIDTH = 20;
    private static final Font gridFont = new Font("courier", 0, 12);
    public static final int OVERWRITE = 2;
    private static final int APPEND = 1;
    public static final int SKIP = 0;
    private boolean toggleSymbol = true;
    private int bytesCopied = 0;
    private Thread drawSymbolThread = null;
    private long[] fileLengths;
    private int sourcesLength;
    private int index;
    protected GeneralFile[] sources;
    protected GeneralFile[] destinations;
    protected JProgressBar[] progressBars;
    protected JLabel[] fileNameLabel;
    protected int overwrite = 0;
    private static int sleepLength = 750;
    boolean skipFile = false;

    public TransferStatusPanel(GeneralFile generalFile) {
        this.sources = new GeneralFile[1];
        this.sources[0] = generalFile;
        this.destinations = new LocalFile[1];
        this.destinations[0] = new LocalFile(generalFile.getName());
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile[] generalFileArray) {
        this.sources = generalFileArray;
        this.destinations = new LocalFile[generalFileArray.length];
        for (int i = 0; i < generalFileArray.length; ++i) {
            this.destinations[i] = new LocalFile(generalFileArray[i].getName());
        }
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile generalFile, GeneralFile generalFile2) {
        this.sources = new GeneralFile[1];
        this.sources[0] = generalFile;
        this.destinations = new GeneralFile[1];
        this.destinations[0] = generalFile2;
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile[] generalFileArray, GeneralFile[] generalFileArray2) {
        if (generalFileArray.length != generalFileArray2.length) {
            new IllegalArgumentException("Must have equal number of sources and destination.");
        }
        this.sources = generalFileArray;
        this.destinations = generalFileArray2;
        this.initComponents();
    }

    private void initComponents() {
        this.sourcesLength = this.sources.length;
        if (this.sourcesLength != this.destinations.length) {
            throw new IllegalArgumentException();
        }
        this.progressBars = new JProgressBar[this.sourcesLength];
        this.fileNameLabel = new JLabel[this.sourcesLength];
        this.fileLengths = new long[this.sourcesLength];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        for (int i = 0; i < this.sourcesLength; ++i) {
            String string = this.sources[i].getAbsolutePath();
            this.fileLengths[i] = this.sources[i].length();
            this.bytesCopied = 0;
            this.progressBars[i] = new JProgressBar();
            this.progressBars[i].setString("Queued");
            this.progressBars[i].setStringPainted(true);
            this.progressBars[i].setMaximum((int)this.fileLengths[i]);
            this.progressBars[i].setValue(0);
            this.progressBars[i].setPreferredSize(new Dimension(150, 20));
            if (string.length() > 20) {
                int n = string.length() - 20;
                string = string.substring(n += 3, string.length());
                string = "..." + string;
            }
            this.fileNameLabel[i] = new JLabel(string, 2);
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            this.add((Component)this.fileNameLabel[i], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            this.add((Component)this.progressBars[i], gridBagConstraints);
        }
    }

    public void setOverwrite(int n) {
        if (n <= 2 && n >= 0) {
            this.overwrite = n;
        }
    }

    public int getOverwrite() {
        return this.overwrite;
    }

    public GeneralFile[] getSources() {
        return this.sources;
    }

    public GeneralFile[] getDestinations() {
        return this.destinations;
    }

    public void setSleepLength(int n) {
        if (n > 100) {
            sleepLength = n;
        }
    }

    public int getSleepLength() {
        return sleepLength;
    }

    public void start() throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferStatusPanel.this.startSymbolThread();
            }
        });
        this.copy(this.sources, this.destinations);
    }

    private void copy(final GeneralFile[] generalFileArray, final GeneralFile[] generalFileArray2) throws IOException {
        this.index = 0;
        while (this.index < this.sourcesLength) {
            if (this.overwrite == 2 || this.overwrite == 1 || !generalFileArray2[this.index].exists()) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            if (TransferStatusPanel.this.overwrite == 2) {
                                generalFileArray[TransferStatusPanel.this.index].copyTo(generalFileArray2[TransferStatusPanel.this.index], true);
                            } else if (TransferStatusPanel.this.overwrite == 1) {
                                generalFileArray[TransferStatusPanel.this.index].copyTo(generalFileArray2[TransferStatusPanel.this.index], false);
                            } else if (!generalFileArray2[TransferStatusPanel.this.index].exists()) {
                                generalFileArray[TransferStatusPanel.this.index].copyTo(generalFileArray2[TransferStatusPanel.this.index], false);
                            } else {
                                TransferStatusPanel.this.skipFile = true;
                            }
                        }
                        catch (SRBException sRBException) {
                            JOptionPane.showMessageDialog(null, sRBException + " " + sRBException.getStandardMessage());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(null, "" + iOException);
                        }
                    }
                }, "Copy");
                thread.start();
                this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                if (generalFileArray[this.index] instanceof SRBFile) {
                    while ((long)((int)((SRBFile)generalFileArray[this.index]).fileCopyStatus()) < this.fileLengths[this.index] && thread.isAlive()) {
                        this.bytesCopied = (int)((SRBFile)generalFileArray[this.index]).fileCopyStatus();
                        this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                        this.progressBars[this.index].setValue(this.bytesCopied);
                        this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                        try {
                            Thread.sleep(sleepLength);
                        }
                        catch (InterruptedException interruptedException) {
                            JOptionPane.showMessageDialog(null, interruptedException);
                        }
                    }
                } else if (generalFileArray2[this.index] instanceof SRBFile) {
                    while ((long)((int)((SRBFile)generalFileArray2[this.index]).fileCopyStatus()) < this.fileLengths[this.index] && thread.isAlive()) {
                        this.bytesCopied = (int)((SRBFile)generalFileArray2[this.index]).fileCopyStatus();
                        this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                        this.progressBars[this.index].setValue(this.bytesCopied);
                        this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                        try {
                            Thread.sleep(sleepLength);
                        }
                        catch (InterruptedException interruptedException) {
                            JOptionPane.showMessageDialog(null, interruptedException);
                        }
                    }
                }
                this.bytesCopied = (int)((SRBFile)generalFileArray2[this.index]).fileCopyStatus();
                this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    JOptionPane.showMessageDialog(null, "" + interruptedException);
                }
            } else if (generalFileArray2[this.index].isDirectory()) {
                GeneralFile[] generalFileArray3 = new GeneralFile[]{generalFileArray[this.index]};
                GeneralFile[] generalFileArray4 = new GeneralFile[]{FileFactory.newFile(generalFileArray2[this.index], generalFileArray[this.index].getName())};
                this.copy(generalFileArray3, generalFileArray4);
            } else {
                this.progressBars[this.index].setString("Skipped");
            }
            this.bytesCopied = 0;
            ++this.index;
        }
    }

    private void startSymbolThread() {
        if (this.drawSymbolThread == null) {
            this.drawSymbolThread = new Thread((Runnable)this, "ProgressBars");
            this.drawSymbolThread.setPriority(1);
            this.drawSymbolThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(sleepLength);
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "" + interruptedException);
            }
            TransferStatusPanel transferStatusPanel = this;
            synchronized (transferStatusPanel) {
                if (this.index >= this.fileLengths.length) {
                    break;
                }
                if (this.toggleSymbol) {
                    this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_DIVIDE + " " + this.fileLengths[this.index]);
                    this.toggleSymbol = false;
                } else {
                    this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                    this.toggleSymbol = true;
                }
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
            }
        }
    }

    private static void showHelp() {
        System.out.println("Usage: java TransferStatusPanel sourceURI destinationURI");
        System.out.println("Usage: java TransferStatusPanel -srb-upload host port username password homeDirectory mdasDomainHome defaultStorageResource localPath srbPath");
        System.out.println("Usage: java TransferStatusPanel -srb-proxy-upload host port username password homeDirectory mdasDomainHome defaultStorageResource certificateAuthorityFilePath localPath srbPath");
        System.out.println("Usage: java TransferStatusPanel -srb-download host port username password homeDirectory mdasDomainHome defaultStorageResource srbPath localPath ");
        System.out.println("Usage: java TransferStatusPanel -srb-proxy-download host port username password homeDirectory mdasDomainHome defaultStorageResource certificateAuthorityFilePath srbPath localPath ");
        System.out.println("Usage: java TransferStatusPanel -help");
    }

    public static void main(String[] stringArray) {
        GeneralFile[] generalFileArray;
        GeneralFile[] generalFileArray2;
        JFrame jFrame;
        block13: {
            jFrame = new JFrame("Test Panel");
            generalFileArray2 = new GeneralFile[1];
            generalFileArray = new GeneralFile[1];
            SRBFileSystem sRBFileSystem = null;
            SRBAccount sRBAccount = null;
            boolean bl = false;
            int n = 0;
            if (stringArray.length < 2 || stringArray[n].equals("-help")) {
                TransferStatusPanel.showHelp();
                System.exit(1);
            } else if (stringArray[n].startsWith("-srb")) {
                if (stringArray[n].startsWith("-srb-proxy")) {
                    sRBAccount = new SRBAccount(stringArray[n + 1], Integer.parseInt(stringArray[n + 2]), stringArray[n + 3], stringArray[n + 4], stringArray[n + 5], stringArray[n + 6], stringArray[n + 7]);
                    sRBAccount.setCertificateAuthority(stringArray[8]);
                    n += 10;
                } else {
                    sRBAccount = new SRBAccount(stringArray[n + 1], Integer.parseInt(stringArray[n + 2]), stringArray[n + 3], stringArray[n + 4], stringArray[n + 5], stringArray[n + 6], stringArray[n + 7]);
                    n += 8;
                }
                try {
                    sRBFileSystem = new SRBFileSystem(sRBAccount);
                    if (stringArray[0].indexOf("-upload") >= 0) {
                        generalFileArray2[0] = new LocalFile(stringArray[n]);
                        generalFileArray[0] = FileFactory.newFile(sRBFileSystem, stringArray[n + 1]);
                        break block13;
                    }
                    generalFileArray2[0] = FileFactory.newFile(sRBFileSystem, stringArray[n]);
                    generalFileArray[0] = new LocalFile(stringArray[n + 1]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                try {
                    generalFileArray2[0] = FileFactory.newFile(new URI(stringArray[n]));
                    generalFileArray[0] = FileFactory.newFile(new URI(stringArray[n + 1]));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        TransferStatusPanel transferStatusPanel = new TransferStatusPanel(generalFileArray2, generalFileArray);
        jFrame.getContentPane().add("Center", transferStatusPanel);
        jFrame.setResizable(true);
        jFrame.pack();
        jFrame.show();
        try {
            transferStatusPanel.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

