/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.servletunit.ParsedPath;
import com.meterware.servletunit.ServletMetaData;
import com.meterware.servletunit.ServletUnitHttpRequest;
import com.meterware.servletunit.ServletUnitServletConfig;
import com.meterware.servletunit.ServletUnitServletContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class WebApplication {
    private static final SecurityConstraint NULL_SECURITY_CONSTRAINT = new NullSecurityConstraint();
    private final ServletConfiguration SECURITY_CHECK_CONFIGURATION = new ServletConfiguration((class$com$meterware$servletunit$WebApplication$SecurityCheckServlet == null ? (class$com$meterware$servletunit$WebApplication$SecurityCheckServlet = WebApplication.class$("com.meterware.servletunit.WebApplication$SecurityCheckServlet")) : class$com$meterware$servletunit$WebApplication$SecurityCheckServlet).getName());
    private final ServletMapping SECURITY_CHECK_MAPPING = new ServletMapping(this.SECURITY_CHECK_CONFIGURATION);
    private ServletMap _servletMapping = new ServletMap();
    private ArrayList _securityConstraints = new ArrayList();
    private boolean _useBasicAuthentication;
    private boolean _useFormAuthentication;
    private String _authenticationRealm = "";
    private URL _loginURL;
    private URL _errorURL;
    private Hashtable _contextParameters = new Hashtable();
    private File _contextDir = null;
    private String _contextPath = null;
    private ServletUnitServletContext _servletContext;
    static final int DONT_AUTOLOAD = Integer.MIN_VALUE;
    static final int ANY_LOAD_ORDER = Integer.MAX_VALUE;
    static /* synthetic */ Class class$com$meterware$servletunit$WebApplication$SecurityCheckServlet;

    WebApplication() {
        this._contextPath = "";
    }

    WebApplication(Document document) throws MalformedURLException, SAXException {
        this(document, null, "");
    }

    WebApplication(Document document, String contextPath) throws MalformedURLException, SAXException {
        this(document, null, contextPath);
    }

    WebApplication(Document document, File file, String contextPath) throws MalformedURLException, SAXException {
        if (contextPath != null && contextPath.length() > 0 && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("Context path " + contextPath + " must start with '/'");
        }
        this._contextDir = file;
        this._contextPath = contextPath == null ? "" : contextPath;
        this.registerServlets(document);
        this.extractSecurityConstraints(document);
        this.extractContextParameters(document);
        this.extractLoginConfiguration(document);
        this._servletMapping.autoLoadServlets();
    }

    private void extractSecurityConstraints(Document document) throws SAXException {
        NodeList nl = document.getElementsByTagName("security-constraint");
        int i = 0;
        while (i < nl.getLength()) {
            this._securityConstraints.add(new SecurityConstraintImpl((Element)nl.item(i)));
            ++i;
        }
    }

    String getContextPath() {
        return this._contextPath;
    }

    ServletContext getServletContext() {
        if (this._servletContext == null) {
            this._servletContext = new ServletUnitServletContext(this);
        }
        return this._servletContext;
    }

    void registerServlet(String resourceName, String servletClassName, Hashtable initParams) {
        this.registerServlet(resourceName, new ServletConfiguration(servletClassName, initParams));
    }

    void registerServlet(String resourceName, ServletConfiguration servletConfiguration) {
        if (!resourceName.startsWith("/") && !resourceName.startsWith("*")) {
            resourceName = "/" + resourceName;
        }
        this._servletMapping.put(resourceName, servletConfiguration);
    }

    void destroyServlets() {
        this._servletMapping.destroyServlets();
    }

    ServletMetaData getServletRequest(URL url) {
        return this._servletMapping.get(url);
    }

    boolean usesBasicAuthentication() {
        return this._useBasicAuthentication;
    }

    boolean usesFormAuthentication() {
        return this._useFormAuthentication;
    }

    String getAuthenticationRealm() {
        return this._authenticationRealm;
    }

    URL getLoginURL() {
        return this._loginURL;
    }

    URL getErrorURL() {
        return this._errorURL;
    }

    boolean requiresAuthorization(URL url) {
        String file = url.getFile();
        String result = this._contextPath.equals("") ? file : (file.startsWith(this._contextPath) ? file.substring(this._contextPath.length()) : null);
        return this.getControllingConstraint(result) != NULL_SECURITY_CONSTRAINT;
    }

    String[] getPermittedRoles(URL url) {
        String file = url.getFile();
        String result = this._contextPath.equals("") ? file : (file.startsWith(this._contextPath) ? file.substring(this._contextPath.length()) : null);
        return this.getControllingConstraint(result).getPermittedRoles();
    }

    private SecurityConstraint getControllingConstraint(String urlPath) {
        Iterator i = this._securityConstraints.iterator();
        while (i.hasNext()) {
            SecurityConstraint sc = (SecurityConstraint)i.next();
            if (!sc.controlsPath(urlPath)) continue;
            return sc;
        }
        return NULL_SECURITY_CONSTRAINT;
    }

    File getResourceFile(String path) {
        if (this._contextDir == null) {
            return new File(path.substring(1));
        }
        return new File(this._contextDir, path.substring(1));
    }

    Hashtable getContextParameters() {
        return this._contextParameters;
    }

    private void extractLoginConfiguration(Document document) throws MalformedURLException, SAXException {
        NodeList nl = document.getElementsByTagName("login-config");
        if (nl.getLength() == 1) {
            Element loginConfigElement = (Element)nl.item(0);
            String authenticationMethod = WebApplication.getChildNodeValue(loginConfigElement, "auth-method", "BASIC");
            this._authenticationRealm = WebApplication.getChildNodeValue(loginConfigElement, "realm-name", "");
            if (authenticationMethod.equalsIgnoreCase("BASIC")) {
                this._useBasicAuthentication = true;
                if (this._authenticationRealm.length() == 0) {
                    throw new SAXException("No realm specified for BASIC Authorization");
                }
            } else if (authenticationMethod.equalsIgnoreCase("FORM")) {
                this._useFormAuthentication = true;
                if (this._authenticationRealm.length() == 0) {
                    throw new SAXException("No realm specified for FORM Authorization");
                }
                this._loginURL = new URL("http", "localhost", WebApplication.getChildNodeValue(loginConfigElement, "form-login-page"));
                this._errorURL = new URL("http", "localhost", WebApplication.getChildNodeValue(loginConfigElement, "form-error-page"));
            }
        }
    }

    private void registerServlets(Document document) throws SAXException {
        Hashtable nameToClass = new Hashtable();
        NodeList nl = document.getElementsByTagName("servlet");
        int i = 0;
        while (i < nl.getLength()) {
            this.registerServletClass(nameToClass, (Element)nl.item(i));
            ++i;
        }
        nl = document.getElementsByTagName("servlet-mapping");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            this.registerServlet(nameToClass, (Element)nl.item(i2));
            ++i2;
        }
    }

    private void registerServletClass(Dictionary mapping, Element servletElement) throws SAXException {
        mapping.put(WebApplication.getChildNodeValue(servletElement, "servlet-name"), new ServletConfiguration(servletElement));
    }

    private void registerServlet(Dictionary mapping, Element servletElement) throws SAXException {
        this.registerServlet(WebApplication.getChildNodeValue(servletElement, "url-pattern"), (ServletConfiguration)mapping.get(WebApplication.getChildNodeValue(servletElement, "servlet-name")));
    }

    private void extractContextParameters(Document document) throws SAXException {
        NodeList nl = document.getElementsByTagName("context-param");
        int i = 0;
        while (i < nl.getLength()) {
            Element param = (Element)nl.item(i);
            String name = WebApplication.getChildNodeValue(param, "param-name");
            String value = WebApplication.getChildNodeValue(param, "param-value");
            this._contextParameters.put(name, value);
            ++i;
        }
    }

    private static String getChildNodeValue(Element root, String childNodeName) throws SAXException {
        return WebApplication.getChildNodeValue(root, childNodeName, null);
    }

    private static String getChildNodeValue(Element root, String childNodeName, String defaultValue) throws SAXException {
        NodeList nl = root.getElementsByTagName(childNodeName);
        if (nl.getLength() == 1) {
            return WebApplication.getTextValue(nl.item(0)).trim();
        }
        if (defaultValue == null) {
            throw new SAXException("Node <" + root.getNodeName() + "> has no child named <" + childNodeName + ">");
        }
        return defaultValue;
    }

    private static String getTextValue(Node node) throws SAXException {
        Node textNode = node.getFirstChild();
        if (textNode == null) {
            return "";
        }
        if (textNode.getNodeType() != 3) {
            throw new SAXException("No text value found for <" + node.getNodeName() + "> node");
        }
        return textNode.getNodeValue();
    }

    private static boolean patternMatches(String urlPattern, String urlPath) {
        return urlPattern.equals(urlPath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServletMap {
        private final Map _exactMatches = new HashMap();
        private final Map _extensions = new HashMap();
        private final Map _urlTree = new HashMap();
        private ServletMapping _defaultMapping;

        ServletMap() {
        }

        void put(String mapping, ServletConfiguration servletConfiguration) {
            if (mapping.equals("/")) {
                this._defaultMapping = new ServletMapping(servletConfiguration);
            } else if (mapping.startsWith("*.")) {
                this._extensions.put(mapping.substring(2), new ServletMapping(servletConfiguration));
            } else if (!mapping.startsWith("/") || !mapping.endsWith("/*")) {
                this._exactMatches.put(mapping, new ServletMapping(servletConfiguration));
            } else {
                ParsedPath path = new ParsedPath(mapping);
                Map context = this._urlTree;
                while (path.hasNext()) {
                    String part = path.next();
                    if (part.equals("*")) {
                        context.put("*", new PartialMatchServletMapping(servletConfiguration, mapping));
                        return;
                    }
                    if (!context.containsKey(part)) {
                        context.put(part, new HashMap());
                    }
                    context = (Map)context.get(part);
                }
            }
        }

        ServletMetaData get(URL url) {
            String file = url.getFile();
            if (!file.startsWith(WebApplication.this._contextPath)) {
                throw new HttpNotFoundException("File path does not begin with '" + WebApplication.this._contextPath + "'", url);
            }
            String servletName = this.getServletName(file.substring(WebApplication.this._contextPath.length()));
            if (servletName.endsWith("j_security_check")) {
                return new ServletRequestImpl(url, servletName, WebApplication.this.SECURITY_CHECK_MAPPING);
            }
            return new ServletRequestImpl(url, servletName, this.getMapping(servletName));
        }

        private String getServletName(String urlFile) {
            if (urlFile.indexOf(63) < 0) {
                return urlFile;
            }
            return urlFile.substring(0, urlFile.indexOf(63));
        }

        public void destroyServlets() {
            if (this._defaultMapping != null) {
                this._defaultMapping.destroyServlet();
            }
            this.destroyServlets(this._exactMatches);
            this.destroyServlets(this._extensions);
            this.destroyServlets(this._urlTree);
        }

        private void destroyServlets(Map map) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof ServletMapping) {
                    ServletMapping servletMapping = (ServletMapping)o;
                    servletMapping.destroyServlet();
                    continue;
                }
                this.destroyServlets((Map)o);
            }
        }

        void autoLoadServlets() {
            ArrayList<ServletConfiguration> autoLoadable = new ArrayList<ServletConfiguration>();
            if (this._defaultMapping != null && this._defaultMapping.getConfiguration().isLoadOnStartup()) {
                autoLoadable.add(this._defaultMapping.getConfiguration());
            }
            this.collectAutoLoadableServlets(autoLoadable, this._exactMatches);
            this.collectAutoLoadableServlets(autoLoadable, this._extensions);
            this.collectAutoLoadableServlets(autoLoadable, this._urlTree);
            if (autoLoadable.isEmpty()) {
                return;
            }
            Collections.sort(autoLoadable, new Comparator(this){
                private final /* synthetic */ ServletMap this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    ServletConfiguration sc1 = (ServletConfiguration)o1;
                    ServletConfiguration sc2 = (ServletConfiguration)o2;
                    return sc1.getLoadOrder() <= sc2.getLoadOrder() ? -1 : 1;
                }
            });
            Iterator iterator = autoLoadable.iterator();
            while (iterator.hasNext()) {
                ServletConfiguration servletConfiguration = (ServletConfiguration)iterator.next();
                try {
                    servletConfiguration.getServlet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to autoload servlet: " + servletConfiguration.getClassName() + ": " + e);
                }
            }
        }

        private void collectAutoLoadableServlets(Collection collection, Map map) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof ServletMapping) {
                    ServletMapping servletMapping = (ServletMapping)o;
                    if (!servletMapping.getConfiguration().isLoadOnStartup()) continue;
                    collection.add(servletMapping.getConfiguration());
                    continue;
                }
                this.collectAutoLoadableServlets(collection, (Map)o);
            }
        }

        private ServletMapping getMapping(String url) {
            if (this._exactMatches.containsKey(url)) {
                return (ServletMapping)this._exactMatches.get(url);
            }
            Map context = this.getContextForLongestPathPrefix(url);
            if (context.containsKey("*")) {
                return (ServletMapping)context.get("*");
            }
            if (this._extensions.containsKey(this.getExtension(url))) {
                return (ServletMapping)this._extensions.get(this.getExtension(url));
            }
            if (this._urlTree.containsKey("/")) {
                return (ServletMapping)this._urlTree.get("/");
            }
            if (this._defaultMapping != null) {
                return this._defaultMapping;
            }
            String prefix = "/servlet/";
            if (!url.startsWith("/servlet/")) {
                return null;
            }
            String className = url.substring("/servlet/".length());
            try {
                Class.forName(className);
                return new ServletMapping(new ServletConfiguration(className));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private Map getContextForLongestPathPrefix(String url) {
            Map context = this._urlTree;
            ParsedPath path = new ParsedPath(url);
            while (path.hasNext()) {
                String part = path.next();
                if (!context.containsKey(part)) break;
                context = (Map)context.get(part);
            }
            return context;
        }

        private String getExtension(String url) {
            int index = url.lastIndexOf(46);
            if (index == -1 || index >= url.length() - 1) {
                return "";
            }
            return url.substring(index + 1);
        }
    }

    static class PartialMatchServletMapping
    extends ServletMapping {
        private String _prefix;

        public PartialMatchServletMapping(ServletConfiguration configuration, String prefix) {
            super(configuration);
            if (!prefix.endsWith("/*")) {
                throw new IllegalArgumentException(prefix + " does not end with '/*'");
            }
            this._prefix = prefix.substring(0, prefix.length() - 2);
        }

        String getServletPath(String servletName) {
            return this._prefix;
        }

        String getPathInfo(String servletName) {
            return servletName.length() > this._prefix.length() ? servletName.substring(this._prefix.length()) : null;
        }
    }

    static class ServletMapping {
        private ServletConfiguration _configuration;

        ServletConfiguration getConfiguration() {
            return this._configuration;
        }

        ServletMapping(ServletConfiguration configuration) {
            this._configuration = configuration;
        }

        String getServletPath(String servletName) {
            return servletName;
        }

        String getPathInfo(String servletName) {
            return null;
        }

        public void destroyServlet() {
            this.getConfiguration().destroyServlet();
        }
    }

    static class ServletRequestImpl
    implements ServletMetaData {
        private URL _url;
        private String _servletName;
        private ServletMapping _mapping;

        ServletRequestImpl(URL url, String servletName, ServletMapping mapping) {
            this._url = url;
            this._servletName = servletName;
            this._mapping = mapping;
        }

        public Servlet getServlet() throws ServletException {
            if (this.getConfiguration() == null) {
                throw new HttpNotFoundException("No servlet mapping defined", this._url);
            }
            try {
                return this.getConfiguration().getServlet();
            }
            catch (ClassNotFoundException e) {
                throw new HttpNotFoundException(this._url, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
        }

        public String getServletPath() {
            return this._mapping == null ? null : this._mapping.getServletPath(this._servletName);
        }

        public String getPathInfo() {
            return this._mapping == null ? null : this._mapping.getPathInfo(this._servletName);
        }

        private ServletConfiguration getConfiguration() {
            return this._mapping == null ? null : this._mapping.getConfiguration();
        }
    }

    static class SecurityConstraintImpl
    implements SecurityConstraint {
        private String[] _roles;
        private ArrayList _roleList = new ArrayList();
        private ArrayList _resources = new ArrayList();

        SecurityConstraintImpl(Element root) throws SAXException {
            NodeList roleNames = root.getElementsByTagName("role-name");
            int i = 0;
            while (i < roleNames.getLength()) {
                this._roleList.add(WebApplication.getTextValue(roleNames.item(i)));
                ++i;
            }
            NodeList resources = root.getElementsByTagName("web-resource-collection");
            int i2 = 0;
            while (i2 < resources.getLength()) {
                this._resources.add(new WebResourceCollection((Element)resources.item(i2)));
                ++i2;
            }
        }

        public boolean controlsPath(String urlPath) {
            return this.getMatchingCollection(urlPath) != null;
        }

        public String[] getPermittedRoles() {
            if (this._roles == null) {
                this._roles = this._roleList.toArray(new String[this._roleList.size()]);
            }
            return this._roles;
        }

        public WebResourceCollection getMatchingCollection(String urlPath) {
            Iterator i = this._resources.iterator();
            while (i.hasNext()) {
                WebResourceCollection wrc = (WebResourceCollection)i.next();
                if (!wrc.controlsPath(urlPath)) continue;
                return wrc;
            }
            return null;
        }

        class WebResourceCollection {
            private ArrayList _urlPatterns = new ArrayList();

            WebResourceCollection(Element root) throws SAXException {
                NodeList urlPatterns = root.getElementsByTagName("url-pattern");
                int i = 0;
                while (i < urlPatterns.getLength()) {
                    this._urlPatterns.add(WebApplication.getTextValue(urlPatterns.item(i)));
                    ++i;
                }
            }

            boolean controlsPath(String urlPath) {
                Iterator i = this._urlPatterns.iterator();
                while (i.hasNext()) {
                    String pattern = (String)i.next();
                    if (!WebApplication.patternMatches(pattern, urlPath)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    static class NullSecurityConstraint
    implements SecurityConstraint {
        private static final String[] NO_ROLES = new String[0];

        NullSecurityConstraint() {
        }

        public boolean controlsPath(String urlPath) {
            return false;
        }

        public String[] getPermittedRoles() {
            return NO_ROLES;
        }
    }

    static interface SecurityConstraint {
        public boolean controlsPath(String var1);

        public String[] getPermittedRoles();
    }

    class ServletConfiguration {
        private Servlet _servlet;
        private String _className;
        private Hashtable _initParams = new Hashtable();
        private int _loadOrder = Integer.MIN_VALUE;

        ServletConfiguration(String className) {
            this._className = className;
        }

        ServletConfiguration(String className, Hashtable initParams) {
            this._className = className;
            if (initParams != null) {
                this._initParams = initParams;
            }
        }

        ServletConfiguration(Element servletElement) throws SAXException {
            this(WebApplication.getChildNodeValue(servletElement, "servlet-class"));
            NodeList initParams = servletElement.getElementsByTagName("init-param");
            int i = initParams.getLength() - 1;
            while (i >= 0) {
                this._initParams.put(WebApplication.getChildNodeValue((Element)initParams.item(i), "param-name"), WebApplication.getChildNodeValue((Element)initParams.item(i), "param-value"));
                --i;
            }
            NodeList loadOrder = servletElement.getElementsByTagName("load-on-startup");
            int i2 = 0;
            while (i2 < loadOrder.getLength()) {
                String order = WebApplication.getTextValue(loadOrder.item(i2));
                try {
                    this._loadOrder = Integer.parseInt(order);
                }
                catch (NumberFormatException e) {
                    this._loadOrder = Integer.MAX_VALUE;
                }
                ++i2;
            }
        }

        synchronized Servlet getServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
            if (this._servlet == null) {
                Class<?> servletClass = Class.forName(this.getClassName());
                this._servlet = (Servlet)servletClass.newInstance();
                this._servlet.init((ServletConfig)new ServletUnitServletConfig(this._servlet, WebApplication.this, this.getInitParams()));
            }
            return this._servlet;
        }

        synchronized void destroyServlet() {
            if (this._servlet != null) {
                this._servlet.destroy();
            }
        }

        String getClassName() {
            return this._className;
        }

        Hashtable getInitParams() {
            return this._initParams;
        }

        boolean isLoadOnStartup() {
            return this._loadOrder != Integer.MIN_VALUE;
        }

        public int getLoadOrder() {
            return this._loadOrder;
        }
    }

    static class SecurityCheckServlet
    extends HttpServlet {
        SecurityCheckServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.handleLogin((ServletUnitHttpRequest)req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.handleLogin((ServletUnitHttpRequest)req, resp);
        }

        private void handleLogin(ServletUnitHttpRequest req, HttpServletResponse resp) throws IOException {
            String username = req.getParameter("j_username");
            String password = req.getParameter("j_password");
            req.writeFormAuthentication(username, password);
            resp.sendRedirect(req.getOriginalURL().toExternalForm());
        }
    }
}

