/*
 * Decompiled with CFR 0.152.
 */
package clinical.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jdom.Element;

public class GenUtils {
    protected static Map<String, String> siteIDMap = Collections.synchronizedMap(new HashMap(17));

    protected GenUtils() {
    }

    public static synchronized void populateSiteIDMap(Properties props) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = props.getProperty(name);
            siteIDMap.put(name, value);
        }
    }

    public static String getSiteName(String numericSiteID) {
        return siteIDMap.get(numericSiteID);
    }

    public static boolean isScanVisitType(String visitType) {
        return visitType.equalsIgnoreCase("scan") || visitType.equalsIgnoreCase("fmri scan") || visitType.equalsIgnoreCase("mri scan");
    }

    public static Properties loadProperties(String propsFilename) throws IOException {
        InputStream is = GenUtils.class.getClassLoader().getResourceAsStream(propsFilename);
        Properties props = new Properties();
        props.load(is);
        return props;
    }

    public static LinkedHashMap<String, String> extractNameValueMapFromProps(Properties props, String nameProperty, String valueProperty) {
        String nameKey;
        String name;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(7);
        int idx = 1;
        while ((name = props.getProperty(nameKey = nameProperty + "." + idx)) != null) {
            String valueKey = valueProperty + "." + idx;
            String value = props.getProperty(valueKey);
            map.put(name, value);
            ++idx;
        }
        return map;
    }

    public static String[] toList(Properties props, String propertyName, String delimiter) {
        String value = props.getProperty(propertyName);
        if (value == null) {
            return new String[0];
        }
        String regex = "\\s*" + delimiter + "\\s*";
        return value.split(regex);
    }

    public static String toTitleCase(String s) {
        StringBuffer buf = new StringBuffer(s);
        if (s.indexOf(32) != -1) {
            for (int i = 0; i < buf.length(); ++i) {
                if (i != 0 && (!Character.isWhitespace(buf.charAt(i - 1)) || !Character.isLetter(buf.charAt(i)))) continue;
                buf.setCharAt(i, Character.toUpperCase(buf.charAt(i)));
            }
        } else {
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        }
        return buf.toString();
    }

    public static boolean toBoolean(String value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value == "1") {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value == "0") {
            return false;
        }
        return defaultVal;
    }

    public static int toInt(String value, int defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static long toLong(String value, long defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static BigDecimal toBigDecimal(int value) {
        return new BigDecimal(String.valueOf(value));
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no") || value == "1" || value == "0";
    }

    public static String getAttributeValueAsString(Element elem, String attrName) {
        if (elem.getAttribute(attrName) != null) {
            return elem.getAttributeValue(attrName);
        }
        return null;
    }

    public static String getAttributeValueAsString(Element elem, String attrName, String defVal) {
        if (elem.getAttribute(attrName) != null) {
            return elem.getAttributeValue(attrName);
        }
        return defVal;
    }

    public static int getAttributeValueAsInt(Element elem, String attrName, int defaultVal) {
        if (elem.getAttribute(attrName) != null) {
            return GenUtils.toInt(elem.getAttributeValue(attrName), defaultVal);
        }
        return defaultVal;
    }

    public static Number toNumber(String value) {
        Number num = null;
        try {
            num = Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            try {
                num = Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                num = null;
            }
        }
        return num;
    }

    public static boolean isDecimalNumber(String value) {
        return value.matches("[-+]?\\d+\\.\\d+");
    }

    public static String getUniqueFile(String filename) {
        File f = new File(filename);
        int count = 0;
        String newFilename = filename;
        while (f.exists()) {
            newFilename = filename + "." + ++count;
            f = new File(newFilename);
        }
        return newFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object o, String filename) throws IOException {
        assert (o != null);
        ObjectOutputStream out = null;
        try {
            File f;
            boolean ok;
            String newFilename = GenUtils.getUniqueFile(filename);
            if (!newFilename.equals(filename) && !(ok = (f = new File(filename)).renameTo(new File(newFilename)))) {
                System.err.println("Cannot rename " + filename + " to " + newFilename + "!");
            }
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 4096));
            out.writeObject(o);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(String filename) throws IOException, ClassNotFoundException {
        assert (filename != null && new File(filename).isFile());
        ObjectInputStream in = null;
        try {
            Object o;
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename), 4096));
            Object object = o = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {}
            }
        }
    }

    public static String getBasePart(String filename) {
        if (filename == null) {
            return null;
        }
        int idx = filename.lastIndexOf(46);
        if (idx == -1) {
            return filename;
        }
        return filename.substring(0, idx);
    }

    public static synchronized String createTempFileName(String tempDir, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        StringBuffer buf = new StringBuffer(tempDir.length() + 40);
        buf.append(tempDir).append(File.separator);
        buf.append("temp_").append(System.currentTimeMillis()).append(extension);
        return buf.toString();
    }

    public static String findSiteID(String dbID) {
        int idx = dbID.lastIndexOf(95);
        if (idx == -1) {
            return null;
        }
        String theSiteName = dbID.substring(0, idx);
        for (Map.Entry<String, String> entry : siteIDMap.entrySet()) {
            String siteName = entry.getValue();
            if (!siteName.equals(theSiteName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String findSiteIDFromSiteName(String siteName) {
        siteName = siteName.toLowerCase();
        for (Map.Entry<String, String> entry : siteIDMap.entrySet()) {
            String sn = entry.getValue();
            if (!sn.equals(siteName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String leftPad(String s, char padChar, int padLength) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < padLength; ++i) {
            buf.append(padChar);
        }
        buf.append(s);
        return buf.toString();
    }

    public static String createServerURI(String scheme, String serverName, int port, String uri) {
        StringBuffer sb = new StringBuffer();
        if (port < 0) {
            port = 80;
        }
        sb.append(scheme).append("://").append(serverName);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            sb.append(':').append(port);
        }
        sb.append(uri);
        return sb.toString();
    }

    public static String dumpList(List<?> aList) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("----------------\n");
        for (Object item : aList) {
            buf.append(item.toString()).append('\n');
        }
        buf.append("----------------");
        return buf.toString();
    }

    public static StackTraceElement[] prepareStackTrace(Throwable t, String qnPrefix) {
        StackTraceElement[] stElems = t.getStackTrace();
        if (qnPrefix == null) {
            return stElems;
        }
        LinkedList<StackTraceElement> relevantTraces = new LinkedList<StackTraceElement>();
        for (int i = 0; i < stElems.length; ++i) {
            if (!stElems[i].getClassName().startsWith(qnPrefix)) continue;
            relevantTraces.add(stElems[i]);
        }
        stElems = new StackTraceElement[relevantTraces.size()];
        relevantTraces.toArray(stElems);
        return stElems;
    }

    public static String createAccessorName(String varName, String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(Character.toUpperCase(varName.charAt(0)));
        buf.append(varName.substring(1));
        return buf.toString();
    }

    public static String createHiddenNotesVariable(int questionID, int idx) {
        StringBuffer buf = new StringBuffer();
        buf.append("q").append(questionID);
        if (idx >= 0) {
            buf.append("_ans").append(idx);
        }
        buf.append("_notes");
        return buf.toString();
    }

    public static String createHiddenNotesVariable(int questionID, int scoreID, int idx) {
        StringBuffer buf = new StringBuffer();
        buf.append("q").append(questionID);
        if (idx >= 0) {
            buf.append("_ans").append(idx);
            if (scoreID >= 0) {
                buf.append('_').append(scoreID);
            }
        }
        buf.append("_notes");
        return buf.toString();
    }

    public static List<Comparable> extractList(String property, String delimiter, Class typeClazz) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        StringTokenizer stok = new StringTokenizer(property, delimiter);
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (typeClazz == Integer.class) {
                list.add(new Integer(token));
                continue;
            }
            if (typeClazz == String.class) {
                list.add((Comparable)((Object)token));
                continue;
            }
            throw new RuntimeException("Unsupported type to convert:" + typeClazz);
        }
        return list;
    }

    public static String generateKey(String subjectID, String siteID, int expID, int visitID, int segmentID) {
        StringBuffer buf = new StringBuffer();
        buf.append(subjectID).append('_').append(siteID).append('_');
        buf.append(expID).append('_').append(visitID).append('_');
        buf.append(segmentID);
        return buf.toString();
    }

    public static String formatNumber(double num, int fracDigits) {
        if (num == Double.NaN) {
            return "N/A";
        }
        NumberFormat numFormatter = NumberFormat.getInstance();
        if (fracDigits > 0) {
            numFormatter.setMaximumFractionDigits(fracDigits);
        }
        return numFormatter.format(num);
    }

    public static String applyWordWrapping(String line) {
        StringBuffer buf = new StringBuffer(line.length() + 10);
        if (line.length() < 80) {
            return line;
        }
        int maxLen = 80;
        int idx = 0;
        int len = line.length();
        while (idx < len) {
            if (idx + maxLen < len) {
                int locIdx = idx + maxLen;
                if (Character.isWhitespace(line.charAt(locIdx))) {
                    buf.append(line.substring(idx, locIdx)).append("\n");
                    idx += maxLen;
                    continue;
                }
                int endIdx = GenUtils.findFirstWhitespaceBefore(line, locIdx, idx);
                if (endIdx == idx) {
                    endIdx = GenUtils.findFirstWhitespaceAfter(line, locIdx);
                }
                buf.append(line.substring(idx, endIdx)).append("\n");
                idx = endIdx;
                continue;
            }
            buf.append(line.substring(idx));
            idx = len;
        }
        return buf.toString();
    }

    public static int findFirstWhitespaceAfter(String s, int startIdx) {
        int idx;
        int len = s.length();
        for (idx = startIdx; idx < len; ++idx) {
            if (!Character.isWhitespace(s.charAt(idx))) continue;
            return idx;
        }
        return idx;
    }

    public static int findFirstWhitespaceBefore(String s, int startIx, int lineStartIdx) {
        int idx;
        for (idx = startIx; idx > lineStartIdx; --idx) {
            if (!Character.isWhitespace(s.charAt(idx))) continue;
            return idx;
        }
        return idx;
    }

    public static String join(int[] arr, String delimiter) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(arr[i]);
            if (i + 1 >= arr.length) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(List<?> list, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            buf.append(element.toString());
            if (!iter.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(List<?> list, String delimiter, String surroundingChar) {
        StringBuffer buf = new StringBuffer();
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (surroundingChar != null) {
                buf.append(surroundingChar).append(element.toString()).append(surroundingChar);
            } else {
                buf.append(element.toString());
            }
            if (!iter.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(String[] arr, String delimiter, String surroundingChar) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (surroundingChar != null) {
                buf.append(surroundingChar).append(arr[i]).append(surroundingChar);
            } else {
                buf.append(arr[i]);
            }
            if (i + 1 >= arr.length) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String join(String[] arr, String delimiter, int startIdx, int endIdx) {
        StringBuffer buf = new StringBuffer();
        for (int i = startIdx; i < endIdx; ++i) {
            buf.append(arr[i]);
            if (i + 1 >= endIdx) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static boolean arrayEquals(String[] arr1, String[] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i].equals(arr2[i])) continue;
            return false;
        }
        return true;
    }

    public static String formatFileSize(long jobSize) {
        StringBuffer buf = new StringBuffer();
        if (jobSize < 1024L) {
            buf.append(jobSize).append('B');
        } else if (jobSize >= 1024L && jobSize < 0x100000L) {
            buf.append(Math.round((double)jobSize / 1024.0)).append("Kb");
        } else if (jobSize >= 0x100000L && jobSize < 0x40000000L) {
            buf.append(Math.round((double)jobSize / 1048576.0)).append("Mb");
        } else if (jobSize >= 0x40000000L) {
            NumberFormat numFormatter = NumberFormat.getInstance();
            numFormatter.setMaximumFractionDigits(2);
            double value = (double)jobSize / 1.073741824E9;
            buf.append(numFormatter.format(value)).append("Gb");
        }
        return buf.toString();
    }

    public static boolean isNotEmpty(String s) {
        if (s == null) {
            return false;
        }
        return s.trim().length() > 0;
    }

    public static boolean isValidEmail(String emailStr) {
        return emailStr.matches("^.+@[^\\.].*\\.[a-z]{2,}$");
    }

    public static String[] split(String s, String delimeters) {
        StringTokenizer stok = new StringTokenizer(s, delimeters);
        String[] toks = new String[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreTokens()) {
            toks[i++] = stok.nextToken();
        }
        return toks;
    }

    public static double toDouble(String value, double defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int byteVal = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
            String s = Integer.toHexString(byteVal);
            s = s.length() == 1 ? "0" + s : s;
            buf.append(s);
        }
        return buf.toString();
    }

    public static byte[] hexToBytes(String s) {
        char[] carr = s.toCharArray();
        byte[] bytes = new byte[carr.length / 2];
        StringBuilder buf = new StringBuilder(3);
        for (int i = 0; i < bytes.length; ++i) {
            buf.setLength(0);
            buf.append(carr[2 * i]);
            buf.append(carr[2 * i + 1]);
            int val = Integer.parseInt(buf.toString(), 16);
            bytes[i] = (byte)val;
        }
        return bytes;
    }

    public static String getMD5Digest(String text) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(text.getBytes());
        byte[] digest = md.digest();
        return GenUtils.toHex(digest);
    }
}

